/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('eaf99524-35e2-4669-afb8-dba1dc3fd689','2025-12-06 03:59:30','2025-12-06 03:59:30',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
INSERT INTO `encryption` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `cipher`, `control_location`, `key_size`, `provider`, `volume_type_id`, `encryption_id`) VALUES ('2025-12-06 04:30:25','2025-12-06 04:30:39','2025-12-06 04:30:39',1,'aes-cbc-essiv','front-end',256,'nova.volume.encryptors.luks.LuksEncryptor','6d432ce3-b478-4f23-b35d-eef894ccc524','04883d06-6c1b-47be-8ccb-d24094a0284b');
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','b146b8c5-381e-4c83-ad64-b3aac59f18f3','2025-12-06 03:59:40','2025-12-06 03:59:40',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('b146b8c5-381e-4c83-ad64-b3aac59f18f3','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2025-12-06 03:59:40','2025-12-06 03:59:40',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2025-12-06 03:59:33',NULL,NULL,0,1,'default','volumes',10),('2025-12-06 03:59:33',NULL,NULL,0,2,'default','snapshots',10),('2025-12-06 03:59:33',NULL,NULL,0,3,'default','gigabytes',1000),('2025-12-06 03:59:33',NULL,NULL,0,4,'default','consistencygroups',10),('2025-12-06 03:59:33',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2025-12-06 03:59:33',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2025-12-06 03:59:47','2025-12-06 04:55:01',NULL,0,1,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',326,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'4058477e-649f-495f-9333-5fdec3941397');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2025-12-06 04:30:24',NULL,'2025-12-06 04:30:39',1,'6d432ce3-b478-4f23-b35d-eef894ccc524','LUKS',NULL,1,NULL),('2025-12-06 03:59:40','2025-12-06 03:59:40',NULL,0,'f2832ce7-e7c3-416f-877b-1f65f3fef418','__DEFAULT__',NULL,1,'Default Volume Type');
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2025-12-06 03:59:40','2025-12-06 03:59:40.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'ede6ef04-46ef-4488-927c-727b57ffc18f','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/ede6ef04-46ef-4488-927c-727b57ffc18f','2025-12-06 04:27:51','2025-12-06 04:27:51',NULL,0,'{\"store\": \"default_backend\"}','active'),(2,'aa438896-10c1-40da-b7d7-baf5795de413','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/aa438896-10c1-40da-b7d7-baf5795de413','2025-12-06 04:27:54','2025-12-06 04:27:54',NULL,0,'{\"store\": \"default_backend\"}','active');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'ede6ef04-46ef-4488-927c-727b57ffc18f','hw_rng_model','virtio','2025-12-06 04:27:50','2025-12-06 04:27:50',NULL,0),(2,'aa438896-10c1-40da-b7d7-baf5795de413','hw_rng_model','virtio','2025-12-06 04:27:52','2025-12-06 04:27:52',NULL,0);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('aa438896-10c1-40da-b7d7-baf5795de413','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2025-12-06 04:27:52','2025-12-06 04:27:54',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','f55bbeaa267a4053ad08ac9d81c50699',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('ede6ef04-46ef-4488-927c-727b57ffc18f','cirros-0.6.2-x86_64-disk.img',21430272,'active','2025-12-06 04:27:50','2025-12-06 04:27:51',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','f55bbeaa267a4053ad08ac9d81c50699',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b');
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2025-12-06 03:58:29',NULL),(1,2,'image','CIM_RASD_','2025-12-06 03:58:30',NULL),(1,3,NULL,'CIM_SASD_','2025-12-06 03:58:31',NULL),(1,9,'image','hw_','2025-12-06 03:58:35',NULL),(1,10,'image','hw_','2025-12-06 03:58:35',NULL),(1,14,'image',NULL,'2025-12-06 03:58:35',NULL),(1,19,'image','hw_','2025-12-06 03:58:35',NULL),(1,25,'image','hw_','2025-12-06 03:58:36',NULL),(1,29,'image',NULL,'2025-12-06 03:58:36',NULL),(1,30,'image',NULL,'2025-12-06 03:58:36',NULL),(1,31,'image',NULL,'2025-12-06 03:58:36',NULL),(1,32,'image',NULL,'2025-12-06 03:58:36',NULL),(2,1,NULL,'CIM_PASD_','2025-12-06 03:58:29',NULL),(2,8,NULL,'hw_','2025-12-06 03:58:35',NULL),(2,9,NULL,'hw_','2025-12-06 03:58:35',NULL),(2,10,NULL,'hw_','2025-12-06 03:58:35',NULL),(2,11,NULL,NULL,'2025-12-06 03:58:35',NULL),(2,13,NULL,NULL,'2025-12-06 03:58:35',NULL),(2,14,NULL,NULL,'2025-12-06 03:58:35',NULL),(2,15,NULL,NULL,'2025-12-06 03:58:35',NULL),(2,16,NULL,'hw_','2025-12-06 03:58:35',NULL),(2,19,NULL,'hw_','2025-12-06 03:58:35',NULL),(2,22,NULL,NULL,'2025-12-06 03:58:36',NULL),(2,23,NULL,'hw_','2025-12-06 03:58:36',NULL),(2,24,NULL,'traits:','2025-12-06 03:58:36',NULL),(2,25,NULL,'hw_','2025-12-06 03:58:36',NULL),(2,26,NULL,NULL,'2025-12-06 03:58:36',NULL),(2,28,NULL,NULL,'2025-12-06 03:58:36',NULL),(2,29,NULL,NULL,'2025-12-06 03:58:36',NULL),(2,30,NULL,NULL,'2025-12-06 03:58:36',NULL),(2,31,NULL,NULL,'2025-12-06 03:58:36',NULL),(2,32,NULL,NULL,'2025-12-06 03:58:36',NULL),(2,33,NULL,'cinder_','2025-12-06 03:58:36',NULL),(3,1,NULL,'CIM_PASD_','2025-12-06 03:58:29',NULL),(3,2,NULL,'CIM_RASD_','2025-12-06 03:58:30',NULL),(3,3,NULL,'CIM_SASD_','2025-12-06 03:58:31',NULL),(3,4,NULL,'CIM_VSSD_','2025-12-06 03:58:32',NULL),(3,5,NULL,NULL,'2025-12-06 03:58:33',NULL),(3,6,NULL,NULL,'2025-12-06 03:58:34',NULL),(3,7,NULL,NULL,'2025-12-06 03:58:34',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2025-12-06 03:58:35',NULL),(4,1,NULL,'CIM_PASD_','2025-12-06 03:58:29',NULL),(4,2,NULL,'CIM_RASD_','2025-12-06 03:58:30',NULL),(4,3,NULL,'CIM_SASD_','2025-12-06 03:58:31',NULL),(4,4,NULL,'CIM_VSSD_','2025-12-06 03:58:32',NULL),(4,8,NULL,'hw:','2025-12-06 03:58:35',NULL),(4,9,NULL,'hw:','2025-12-06 03:58:35',NULL),(4,10,NULL,'hw:','2025-12-06 03:58:35',NULL),(4,12,NULL,'capabilities:','2025-12-06 03:58:35',NULL),(4,16,NULL,'hw:','2025-12-06 03:58:35',NULL),(4,17,NULL,NULL,'2025-12-06 03:58:35',NULL),(4,18,NULL,NULL,'2025-12-06 03:58:35',NULL),(4,19,NULL,'hw:','2025-12-06 03:58:35',NULL),(4,20,NULL,NULL,'2025-12-06 03:58:36',NULL),(4,21,NULL,NULL,'2025-12-06 03:58:36',NULL),(4,23,NULL,'hw:','2025-12-06 03:58:36',NULL),(4,24,NULL,'traits:','2025-12-06 03:58:36',NULL),(4,25,NULL,'hw:','2025-12-06 03:58:36',NULL),(5,1,'scheduler_hints',NULL,'2025-12-06 03:58:29',NULL),(5,30,'metadata',NULL,'2025-12-06 03:58:36',NULL),(5,31,'metadata',NULL,'2025-12-06 03:58:36',NULL),(5,32,'metadata',NULL,'2025-12-06 03:58:36',NULL),(6,30,NULL,NULL,'2025-12-06 03:58:36',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2025-12-06 03:58:28',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2025-12-06 03:58:29',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2025-12-06 03:58:31',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2025-12-06 03:58:32',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-12-06 03:58:33',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-12-06 03:58:34',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2025-12-06 03:58:34',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2025-12-06 03:58:34',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2025-12-06 03:58:35',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2025-12-06 03:58:35',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2025-12-06 03:58:35',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2025-12-06 03:58:35',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2025-12-06 03:58:35',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2025-12-06 03:58:35',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-06 03:58:35',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-06 03:58:35',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-06 03:58:35',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2025-12-06 03:58:35',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2025-12-06 03:58:35',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-06 03:58:36',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-06 03:58:36',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-06 03:58:36',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2025-12-06 03:58:36',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2025-12-06 03:58:36',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-06 03:58:36',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-06 03:58:36',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2025-12-06 03:58:36',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2025-12-06 03:58:36',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2025-12-06 03:58:36',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2025-12-06 03:58:36',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2025-12-06 03:58:36',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2025-12-06 03:58:36',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2025-12-06 03:58:36',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2025-12-06 03:58:35',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2025-12-06 03:58:35',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2025-12-06 03:58:35',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2025-12-06 03:58:36',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2025-12-06 03:58:36',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2025-12-06 03:58:36',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2025-12-06 03:58:36',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-12-06 03:58:36',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-12-06 03:58:36',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-12-06 03:58:36',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-12-06 03:58:36',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-12-06 03:58:36',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2025-12-06 03:58:36',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2025-12-06 03:58:36',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2025-12-06 03:58:36',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2025-12-06 03:58:36',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2025-12-06 03:58:36',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2025-12-06 03:58:36',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2025-12-06 03:58:36',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2025-12-06 03:58:36',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-12-06 03:58:36',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-12-06 03:58:36',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-12-06 03:58:36',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2025-12-06 03:58:29',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2025-12-06 03:58:29',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2025-12-06 03:58:29',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2025-12-06 03:58:30',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2025-12-06 03:58:30',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2025-12-06 03:58:30',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2025-12-06 03:58:30',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2025-12-06 03:58:30',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-12-06 03:58:30',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2025-12-06 03:58:30',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2025-12-06 03:58:30',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2025-12-06 03:58:30',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2025-12-06 03:58:30',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2025-12-06 03:58:30',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2025-12-06 03:58:30',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2025-12-06 03:58:30',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-12-06 03:58:30',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2025-12-06 03:58:31',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-12-06 03:58:31',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2025-12-06 03:58:31',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2025-12-06 03:58:31',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2025-12-06 03:58:31',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2025-12-06 03:58:31',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2025-12-06 03:58:32',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2025-12-06 03:58:32',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2025-12-06 03:58:32',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2025-12-06 03:58:32',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-12-06 03:58:32',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-12-06 03:58:32',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2025-12-06 03:58:32',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2025-12-06 03:58:32',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-12-06 03:58:32',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2025-12-06 03:58:32',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-12-06 03:58:32',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-12-06 03:58:32',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2025-12-06 03:58:32',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2025-12-06 03:58:32',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2025-12-06 03:58:32',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2025-12-06 03:58:32',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2025-12-06 03:58:32',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-12-06 03:58:32',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-12-06 03:58:33',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2025-12-06 03:58:33',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2025-12-06 03:58:33',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2025-12-06 03:58:33',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2025-12-06 03:58:33',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2025-12-06 03:58:33',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2025-12-06 03:58:33',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2025-12-06 03:58:33',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2025-12-06 03:58:33',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2025-12-06 03:58:33',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2025-12-06 03:58:33',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2025-12-06 03:58:33',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2025-12-06 03:58:34',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2025-12-06 03:58:34',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2025-12-06 03:58:35',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2025-12-06 03:58:35',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2025-12-06 03:58:35',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2025-12-06 03:58:35',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-06 03:58:35',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2025-12-06 03:58:35',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2025-12-06 03:58:35',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2025-12-06 03:58:35',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-12-06 03:58:35',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-12-06 03:58:35',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-12-06 03:58:35',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2025-12-06 03:58:35',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2025-12-06 03:58:35',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2025-12-06 03:58:35',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2025-12-06 03:58:35',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-12-06 03:58:35',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-12-06 03:58:35',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-12-06 03:58:35',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2025-12-06 03:58:35',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2025-12-06 03:58:35',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2025-12-06 03:58:35',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2025-12-06 03:58:35',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2025-12-06 03:58:35',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-06 03:58:35',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2025-12-06 03:58:35',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2025-12-06 03:58:35',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2025-12-06 03:58:35',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-06 03:58:35',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-06 03:58:35',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-12-06 03:58:35',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2025-12-06 03:58:35',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-12-06 03:58:35',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-06 03:58:35',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-06 03:58:35',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-06 03:58:35',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2025-12-06 03:58:35',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2025-12-06 03:58:35',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2025-12-06 03:58:35',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-12-06 03:58:35',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-12-06 03:58:35',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-12-06 03:58:36',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-12-06 03:58:36',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-12-06 03:58:36',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-12-06 03:58:36',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2025-12-06 03:58:36',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2025-12-06 03:58:36',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-06 03:58:36',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-06 03:58:36',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2025-12-06 03:58:36',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2025-12-06 03:58:36',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2025-12-06 03:58:36',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2025-12-06 03:58:36',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2025-12-06 03:58:36',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-06 03:58:36',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2025-12-06 03:58:36',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-12-06 03:58:36',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-12-06 03:58:36',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2025-12-06 03:58:36',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2025-12-06 03:58:36',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2025-12-06 03:58:36',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2025-12-06 03:58:36',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2025-12-06 03:58:36',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2025-12-06 03:58:36',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-12-06 03:58:36',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2025-12-06 03:58:36',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-12-06 03:58:36',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2025-12-06 03:58:36',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2025-12-06 03:58:36',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2025-12-06 03:58:36',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2025-12-06 03:58:36',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2025-12-06 03:58:36',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2025-12-06 03:58:36',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2025-12-06 03:58:36',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-12-06 03:58:36',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-12-06 03:58:36',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2025-12-06 03:58:36',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2025-12-06 03:58:36',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2025-12-06 03:58:29',NULL),(2,'OS::Glance::Image',1,'2025-12-06 03:58:29',NULL),(3,'OS::Nova::Aggregate',1,'2025-12-06 03:58:29',NULL),(4,'OS::Nova::Flavor',1,'2025-12-06 03:58:29',NULL),(5,'OS::Nova::Server',1,'2025-12-06 03:58:29',NULL),(6,'OS::Trove::Instance',1,'2025-12-06 03:58:36',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `heat`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `heat` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `heat`;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `resource_action` varchar(255) DEFAULT NULL,
  `resource_status` varchar(255) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `physical_resource_id` varchar(255) DEFAULT NULL,
  `resource_status_reason` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_properties` blob DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `ev_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  CONSTRAINT `ev_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `event_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1487 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event`
--

LOCK TABLES `event` WRITE;
/*!40000 ALTER TABLE `event` DISABLE KEYS */;
INSERT INTO `event` (`id`, `uuid`, `stack_id`, `created_at`, `updated_at`, `resource_action`, `resource_status`, `resource_name`, `physical_resource_id`, `resource_status_reason`, `resource_type`, `resource_properties`, `rsrc_prop_data_id`) VALUES (1,'90135e1c-5437-4f10-8510-0fe7a26448ed','811bae6d-4fc5-4754-a72c-d909d884fda4','2025-12-06 04:28:15',NULL,'CREATE','IN_PROGRESS','api-229566953-envstack','811bae6d-4fc5-4754-a72c-d909d884fda4','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(2,'525f7a49-426e-42bd-869c-b6af2d7011ca','5f8530d7-414e-4281-99ed-a0421078a053','2025-12-06 04:28:15',NULL,'CREATE','IN_PROGRESS','api-234010157-rsrcstack','5f8530d7-414e-4281-99ed-a0421078a053','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(3,'b978b669-ff1a-4509-b293-31d8999e9a78','5f8530d7-414e-4281-99ed-a0421078a053','2025-12-06 04:28:15',NULL,'CREATE','IN_PROGRESS','test','api-234010157-rsrcstack-test-zf3aqfvgczgh','state changed','OS::Heat::TestResource',NULL,1),(4,'2041351e-a547-4bd0-a237-3777a71ccda8','811bae6d-4fc5-4754-a72c-d909d884fda4','2025-12-06 04:28:15',NULL,'CREATE','IN_PROGRESS','test','api-229566953-envstack-test-xpppczncj2t2','state changed','OS::Heat::TestResource',NULL,2),(5,'ae4b9a21-71dc-49b8-9e67-441aa2fa2581','df0f1d90-584d-4519-9f92-c941e844c96f','2025-12-06 04:28:15',NULL,'CREATE','IN_PROGRESS','api-177751087-rsrcstack','df0f1d90-584d-4519-9f92-c941e844c96f','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(6,'4ae49163-ace3-4bbd-83ee-8b861ea8d9e5','811bae6d-4fc5-4754-a72c-d909d884fda4','2025-12-06 04:28:15',NULL,'CREATE','COMPLETE','test','api-229566953-envstack-test-xpppczncj2t2','state changed','OS::Heat::TestResource',NULL,2),(7,'eaa944ba-f644-4cb4-9055-025f398face5','5f8530d7-414e-4281-99ed-a0421078a053','2025-12-06 04:28:15',NULL,'CREATE','COMPLETE','test','api-234010157-rsrcstack-test-zf3aqfvgczgh','state changed','OS::Heat::TestResource',NULL,1),(8,'38081fbd-a0e9-47ef-a9d1-22233f53f9cf','811bae6d-4fc5-4754-a72c-d909d884fda4','2025-12-06 04:28:15',NULL,'CREATE','COMPLETE','api-229566953-envstack','811bae6d-4fc5-4754-a72c-d909d884fda4','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(9,'c84a8220-9851-4441-b400-1b03f378963d','5f8530d7-414e-4281-99ed-a0421078a053','2025-12-06 04:28:15',NULL,'CREATE','COMPLETE','api-234010157-rsrcstack','5f8530d7-414e-4281-99ed-a0421078a053','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(10,'5f7673cf-376f-490c-b260-181a004655a5','df0f1d90-584d-4519-9f92-c941e844c96f','2025-12-06 04:28:15',NULL,'CREATE','IN_PROGRESS','test','api-177751087-rsrcstack-test-cowkgpdzv5kv','state changed','OS::Heat::TestResource',NULL,3),(11,'654764d1-cd75-4bc1-8e94-c03e50e754e7','df0f1d90-584d-4519-9f92-c941e844c96f','2025-12-06 04:28:15',NULL,'CREATE','COMPLETE','test','api-177751087-rsrcstack-test-cowkgpdzv5kv','state changed','OS::Heat::TestResource',NULL,3),(12,'a495da6c-955d-4f18-b361-f491aaef818f','df0f1d90-584d-4519-9f92-c941e844c96f','2025-12-06 04:28:15',NULL,'CREATE','COMPLETE','api-177751087-rsrcstack','df0f1d90-584d-4519-9f92-c941e844c96f','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(13,'e8436920-ba63-4d5a-923e-98f7da2bcb7f','c22a3547-29b3-4d86-a454-7b0eb5bcdddc','2025-12-06 04:28:15',NULL,'CREATE','IN_PROGRESS','api-2090761251-rsrcstack','c22a3547-29b3-4d86-a454-7b0eb5bcdddc','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(14,'b03f5fbd-d709-44a6-b399-c3f9bb7eed2d','c22a3547-29b3-4d86-a454-7b0eb5bcdddc','2025-12-06 04:28:15',NULL,'CREATE','IN_PROGRESS','test','api-2090761251-rsrcstack-test-ksj2qxada2kn','state changed','OS::Heat::TestResource',NULL,4),(15,'00c2856f-5f5f-44a0-bef8-2699da2b1b73','c22a3547-29b3-4d86-a454-7b0eb5bcdddc','2025-12-06 04:28:15',NULL,'CREATE','COMPLETE','test','api-2090761251-rsrcstack-test-ksj2qxada2kn','state changed','OS::Heat::TestResource',NULL,4),(16,'589a63fa-b050-4f00-a5e2-558ba27e8d3f','c22a3547-29b3-4d86-a454-7b0eb5bcdddc','2025-12-06 04:28:15',NULL,'CREATE','COMPLETE','api-2090761251-rsrcstack','c22a3547-29b3-4d86-a454-7b0eb5bcdddc','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(17,'6413123a-5475-4b57-83ea-ab0561ef520d','5f8530d7-414e-4281-99ed-a0421078a053','2025-12-06 04:28:16',NULL,'CHECK','FAILED','test','api-234010157-rsrcstack-test-zf3aqfvgczgh','resource deleted','OS::Heat::TestResource',NULL,1),(18,'307e2fc2-4e4e-4015-8a37-a61f364439e0','811bae6d-4fc5-4754-a72c-d909d884fda4','2025-12-06 04:28:16',NULL,'DELETE','IN_PROGRESS','api-229566953-envstack','811bae6d-4fc5-4754-a72c-d909d884fda4','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(19,'348ba1c8-f11d-4d0c-a9e7-862a1b342fd5','811bae6d-4fc5-4754-a72c-d909d884fda4','2025-12-06 04:28:16',NULL,'DELETE','IN_PROGRESS','test','api-229566953-envstack-test-xpppczncj2t2','state changed','OS::Heat::TestResource',NULL,2),(20,'235d0adf-1018-4009-8f84-fa004571a070','811bae6d-4fc5-4754-a72c-d909d884fda4','2025-12-06 04:28:16',NULL,'DELETE','COMPLETE','test','api-229566953-envstack-test-xpppczncj2t2','state changed','OS::Heat::TestResource',NULL,2),(21,'1c13dda9-d29b-4376-be5c-4bca574dd095','811bae6d-4fc5-4754-a72c-d909d884fda4','2025-12-06 04:28:16',NULL,'DELETE','COMPLETE','api-229566953-envstack','811bae6d-4fc5-4754-a72c-d909d884fda4','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(22,'ac0e2449-29ea-4886-b17e-de7657b6c144','df0f1d90-584d-4519-9f92-c941e844c96f','2025-12-06 04:28:16',NULL,'CHECK','FAILED','test','api-177751087-rsrcstack-test-cowkgpdzv5kv','resource deleted','OS::Heat::TestResource',NULL,3),(23,'13141f6e-efd2-463e-97ba-7057be637623','5f8530d7-414e-4281-99ed-a0421078a053','2025-12-06 04:28:16',NULL,'DELETE','IN_PROGRESS','api-234010157-rsrcstack','5f8530d7-414e-4281-99ed-a0421078a053','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(24,'413b2cc7-d0aa-4484-b277-632ecdfeea48','5f8530d7-414e-4281-99ed-a0421078a053','2025-12-06 04:28:16',NULL,'DELETE','IN_PROGRESS','test','api-234010157-rsrcstack-test-zf3aqfvgczgh','state changed','OS::Heat::TestResource',NULL,1),(25,'7469799c-90e1-4090-a585-19b834dcae45','5f8530d7-414e-4281-99ed-a0421078a053','2025-12-06 04:28:16',NULL,'DELETE','COMPLETE','test','api-234010157-rsrcstack-test-zf3aqfvgczgh','state changed','OS::Heat::TestResource',NULL,1),(26,'7a0d6c53-75a1-4d5b-a52f-2b991c06373d','5f8530d7-414e-4281-99ed-a0421078a053','2025-12-06 04:28:16',NULL,'DELETE','COMPLETE','api-234010157-rsrcstack','5f8530d7-414e-4281-99ed-a0421078a053','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(27,'35c7a848-0a12-4c78-bee4-7809176da687','20dba6b3-a438-4e44-b1cf-2ea639dfe547','2025-12-06 04:28:18',NULL,'CREATE','IN_PROGRESS','api-177751087-empty','20dba6b3-a438-4e44-b1cf-2ea639dfe547','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(28,'3364072e-ae2c-4005-b0d7-bd7567ab4ea3','20dba6b3-a438-4e44-b1cf-2ea639dfe547','2025-12-06 04:28:18',NULL,'CREATE','COMPLETE','api-177751087-empty','20dba6b3-a438-4e44-b1cf-2ea639dfe547','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(29,'4e9e1499-bbf8-4ce1-94a6-e4e72afd0f60','20dba6b3-a438-4e44-b1cf-2ea639dfe547','2025-12-06 04:28:19',NULL,'DELETE','IN_PROGRESS','api-177751087-empty','20dba6b3-a438-4e44-b1cf-2ea639dfe547','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(30,'756f4407-bcc6-4cf0-be80-3db5ad65e414','20dba6b3-a438-4e44-b1cf-2ea639dfe547','2025-12-06 04:28:19',NULL,'DELETE','COMPLETE','api-177751087-empty','20dba6b3-a438-4e44-b1cf-2ea639dfe547','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(31,'eb4e77df-31dc-4de9-a598-90083272370a','fa303946-c89d-4a77-8a98-9541ade77b71','2025-12-06 04:28:20',NULL,'CREATE','IN_PROGRESS','api-177751087-stack','fa303946-c89d-4a77-8a98-9541ade77b71','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(32,'e9b678a7-9db5-4d30-8aca-1c6a61bf599d','fa303946-c89d-4a77-8a98-9541ade77b71','2025-12-06 04:28:20',NULL,'CREATE','IN_PROGRESS','test','api-177751087-stack-test-zmgdyff56ofx','state changed','OS::Heat::TestResource',NULL,5),(33,'a47c67fd-0186-43b6-827d-50a84a5d039b','fa303946-c89d-4a77-8a98-9541ade77b71','2025-12-06 04:28:20',NULL,'CREATE','COMPLETE','test','api-177751087-stack-test-zmgdyff56ofx','state changed','OS::Heat::TestResource',NULL,5),(34,'a700b027-8524-4ee6-b745-54116071c244','fa303946-c89d-4a77-8a98-9541ade77b71','2025-12-06 04:28:20',NULL,'CREATE','COMPLETE','api-177751087-stack','fa303946-c89d-4a77-8a98-9541ade77b71','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(35,'ed79bb2a-128d-4841-8105-680a8358ed3f','c6d268c7-a236-4917-aab2-a95383d82ad6','2025-12-06 04:28:21',NULL,'CREATE','IN_PROGRESS','api-2090761251-empty','c6d268c7-a236-4917-aab2-a95383d82ad6','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(36,'e71d6676-6503-4b04-8f42-c03fa45cd2bf','c6d268c7-a236-4917-aab2-a95383d82ad6','2025-12-06 04:28:21',NULL,'CREATE','COMPLETE','api-2090761251-empty','c6d268c7-a236-4917-aab2-a95383d82ad6','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(37,'d3bdf426-1fa9-4d0e-963d-9b2f3e3b255a','47323972-a587-4706-9100-a462afe54eb2','2025-12-06 04:28:21',NULL,'CREATE','IN_PROGRESS','api-229566953-empty','47323972-a587-4706-9100-a462afe54eb2','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(38,'7b417845-2016-4dce-a64f-4063e886865f','fa303946-c89d-4a77-8a98-9541ade77b71','2025-12-06 04:28:21',NULL,'UPDATE','IN_PROGRESS','api-177751087-stack','fa303946-c89d-4a77-8a98-9541ade77b71','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(39,'1918a1a3-bc3b-4d27-9bfb-8aa3da5173a4','47323972-a587-4706-9100-a462afe54eb2','2025-12-06 04:28:21',NULL,'CREATE','COMPLETE','api-229566953-empty','47323972-a587-4706-9100-a462afe54eb2','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(40,'dad31fce-6616-4b73-8ef4-003420892cc4','fa303946-c89d-4a77-8a98-9541ade77b71','2025-12-06 04:28:21',NULL,'UPDATE','IN_PROGRESS','test','api-177751087-stack-test-zmgdyff56ofx','state changed','OS::Heat::TestResource',NULL,5),(41,'d4133265-ccc7-476c-aec1-25aedd66e657','c6d268c7-a236-4917-aab2-a95383d82ad6','2025-12-06 04:28:22',NULL,'DELETE','IN_PROGRESS','api-2090761251-empty','c6d268c7-a236-4917-aab2-a95383d82ad6','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(42,'1785241d-4192-46d1-b3d2-63e5049edfee','c6d268c7-a236-4917-aab2-a95383d82ad6','2025-12-06 04:28:22',NULL,'DELETE','COMPLETE','api-2090761251-empty','c6d268c7-a236-4917-aab2-a95383d82ad6','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(43,'c8c82a16-7613-4f22-8e1f-9aece6cf47f5','9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:22',NULL,'CREATE','IN_PROGRESS','UpdatePortTest-39567136','9c80649e-8029-4a3d-8d41-2cefde857216','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(44,'7a9fb5a5-d2d3-4aa4-a780-384f3371974c','47323972-a587-4706-9100-a462afe54eb2','2025-12-06 04:28:22',NULL,'DELETE','IN_PROGRESS','api-229566953-empty','47323972-a587-4706-9100-a462afe54eb2','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(45,'af988d1f-50d4-47a4-984e-48c1b27c3fc0','47323972-a587-4706-9100-a462afe54eb2','2025-12-06 04:28:22',NULL,'DELETE','COMPLETE','api-229566953-empty','47323972-a587-4706-9100-a462afe54eb2','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(46,'6a24bb59-6199-46ed-9a0f-8228f76ad26d','9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:22',NULL,'CREATE','IN_PROGRESS','net','UpdatePortTest-39567136-net-uqo7ohql2nsr','state changed','OS::Neutron::Net',NULL,NULL),(47,'1fe2b590-e49c-46f1-92f7-5848796fee0e','e891c0be-46f8-4039-80ba-3d2098c6d785','2025-12-06 04:28:23',NULL,'CREATE','IN_PROGRESS','api-2090761251-stack','e891c0be-46f8-4039-80ba-3d2098c6d785','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(48,'57f4a18d-5b95-491c-a778-d985e4caa208','9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:23',NULL,'CREATE','COMPLETE','net','5bb017d0-d73d-4f54-b5fb-db3a628a4122','state changed','OS::Neutron::Net',NULL,NULL),(49,'b87343b9-453f-43be-9540-f5fabfa6c678','9c9c85f4-553c-4e26-a99e-a35619f0439b','2025-12-06 04:28:23',NULL,'CREATE','IN_PROGRESS','api-229566953-stack','9c9c85f4-553c-4e26-a99e-a35619f0439b','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(50,'5fd8eca5-dd39-409b-8878-b8071d53d1dd','9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:23',NULL,'CREATE','IN_PROGRESS','subnet','UpdatePortTest-39567136-subnet-hodb6pza2m2c','state changed','OS::Neutron::Subnet',NULL,7),(51,'3353716e-29c1-437e-9532-5e4dfa5a0561','e891c0be-46f8-4039-80ba-3d2098c6d785','2025-12-06 04:28:23',NULL,'CREATE','IN_PROGRESS','test','api-2090761251-stack-test-v7xaukb6xkrb','state changed','OS::Heat::TestResource',NULL,6),(52,'76d98f4f-2d17-4326-9525-d4e7a355acf7','e891c0be-46f8-4039-80ba-3d2098c6d785','2025-12-06 04:28:23',NULL,'CREATE','COMPLETE','test','api-2090761251-stack-test-v7xaukb6xkrb','state changed','OS::Heat::TestResource',NULL,6),(53,'cba761ab-8925-4b71-ba6e-42f0a7101800','e891c0be-46f8-4039-80ba-3d2098c6d785','2025-12-06 04:28:23',NULL,'CREATE','COMPLETE','api-2090761251-stack','e891c0be-46f8-4039-80ba-3d2098c6d785','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(54,'c2f9c7ac-f27c-44c7-9fa1-7223d7359755','9c9c85f4-553c-4e26-a99e-a35619f0439b','2025-12-06 04:28:23',NULL,'CREATE','IN_PROGRESS','test','api-229566953-stack-test-r6mklavd53gv','state changed','OS::Heat::TestResource',NULL,8),(55,'0ccded1f-2bc9-4545-b265-929c73bbe4ba','9c9c85f4-553c-4e26-a99e-a35619f0439b','2025-12-06 04:28:23',NULL,'CREATE','COMPLETE','test','api-229566953-stack-test-r6mklavd53gv','state changed','OS::Heat::TestResource',NULL,8),(56,'a4ca3165-3085-4167-b4b3-2d849ea2893d','9c9c85f4-553c-4e26-a99e-a35619f0439b','2025-12-06 04:28:23',NULL,'CREATE','COMPLETE','api-229566953-stack','9c9c85f4-553c-4e26-a99e-a35619f0439b','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(57,'6455c686-fa7a-4042-b136-e3bb3a8e5155','fa303946-c89d-4a77-8a98-9541ade77b71','2025-12-06 04:28:23',NULL,'UPDATE','COMPLETE','test','api-177751087-stack-test-zmgdyff56ofx','state changed','OS::Heat::TestResource',NULL,9),(58,'e7da562e-c1ec-4b49-8f58-225273df780a','fa303946-c89d-4a77-8a98-9541ade77b71','2025-12-06 04:28:24',NULL,'UPDATE','COMPLETE','api-177751087-stack','fa303946-c89d-4a77-8a98-9541ade77b71','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(59,'3da5a93f-4931-492c-a3ae-fe2376a2c142','9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:24',NULL,'CREATE','COMPLETE','subnet','6121f159-8ee9-47d5-847f-409fd23046f2','state changed','OS::Neutron::Subnet',NULL,7),(60,'f722c6f1-eb77-43d5-bac1-8b33a06eb7b4','9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:24',NULL,'CREATE','IN_PROGRESS','port','UpdatePortTest-39567136-port-n7khd7lynfb7','state changed','OS::Neutron::Port',NULL,10),(61,'97af584f-c2ec-437a-b7d6-30c5ed4e59a5','fa303946-c89d-4a77-8a98-9541ade77b71','2025-12-06 04:28:24',NULL,'UPDATE','IN_PROGRESS','api-177751087-stack','fa303946-c89d-4a77-8a98-9541ade77b71','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(62,'60b79368-0ec9-445a-8de7-dd07f0b66f78','fa303946-c89d-4a77-8a98-9541ade77b71','2025-12-06 04:28:24',NULL,'UPDATE','IN_PROGRESS','test','api-177751087-stack-test-zmgdyff56ofx','state changed','OS::Heat::TestResource',NULL,9),(63,'acfeb838-5674-4022-a359-5bae09920177','9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:25',NULL,'CREATE','COMPLETE','port','453744f7-d60f-45be-b014-0eb40a5006da','state changed','OS::Neutron::Port',NULL,10),(64,'a6ebc9a4-e130-4539-8470-bca383cfa930','930ed621-3ce6-46e9-a4df-e52f15ab6906','2025-12-06 04:28:25',NULL,'CREATE','IN_PROGRESS','EncryptedParametersTest-74094787','930ed621-3ce6-46e9-a4df-e52f15ab6906','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(65,'0e12673d-0140-4133-be57-2bb4bfa38fbb','9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:25',NULL,'CREATE','IN_PROGRESS','test','UpdatePortTest-39567136-test-bhbq7aep2lsk','state changed','OS::Heat::TestResource',NULL,12),(66,'cbf2ae1f-4cd3-4d2f-afed-a0388570fa3a','930ed621-3ce6-46e9-a4df-e52f15ab6906','2025-12-06 04:28:25',NULL,'CREATE','IN_PROGRESS','server_with_encrypted_property','En-094787-server_with_encrypted_property-oaxqxfi36eng','state changed','OS::Nova::Server',NULL,13),(67,'f688b186-5d38-43ee-8dd2-aa498a68676c','9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:25',NULL,'CREATE','COMPLETE','test','UpdatePortTest-39567136-test-bhbq7aep2lsk','state changed','OS::Heat::TestResource',NULL,12),(68,'7c2296d4-b6cd-4f9a-8d77-64cecf55cfd7','9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:25',NULL,'CREATE','COMPLETE','UpdatePortTest-39567136','9c80649e-8029-4a3d-8d41-2cefde857216','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(69,'0f0922bd-7cef-4128-8c60-3bba76affade','9c9c85f4-553c-4e26-a99e-a35619f0439b','2025-12-06 04:28:26',NULL,'UPDATE','IN_PROGRESS','api-229566953-stack','9c9c85f4-553c-4e26-a99e-a35619f0439b','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(70,'6b914d46-4676-429c-bcb6-9afd96159fbf','9c9c85f4-553c-4e26-a99e-a35619f0439b','2025-12-06 04:28:26',NULL,'UPDATE','IN_PROGRESS','test','api-229566953-stack-test-r6mklavd53gv','state changed','OS::Heat::TestResource',NULL,8),(71,'add56835-1f44-41c9-818c-b01dd5974490','fa303946-c89d-4a77-8a98-9541ade77b71','2025-12-06 04:28:26',NULL,'UPDATE','COMPLETE','test','api-177751087-stack-test-zmgdyff56ofx','state changed','OS::Heat::TestResource',NULL,14),(72,'8a5fcc7f-6b55-47a6-a482-8e641ffe7747','fa303946-c89d-4a77-8a98-9541ade77b71','2025-12-06 04:28:26',NULL,'UPDATE','COMPLETE','api-177751087-stack','fa303946-c89d-4a77-8a98-9541ade77b71','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(73,'ea9869f8-a8fe-4ba4-9e6f-674fced24c41','9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:27',NULL,'UPDATE','IN_PROGRESS','UpdatePortTest-39567136','9c80649e-8029-4a3d-8d41-2cefde857216','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(74,'2126d384-0a26-42f1-8785-d23f77475488','fa303946-c89d-4a77-8a98-9541ade77b71','2025-12-06 04:28:27',NULL,'DELETE','IN_PROGRESS','api-177751087-stack','fa303946-c89d-4a77-8a98-9541ade77b71','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(75,'01dc4d52-b860-4e63-8a54-fc783b12f6fd','9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:27',NULL,'UPDATE','IN_PROGRESS','port','453744f7-d60f-45be-b014-0eb40a5006da','state changed','OS::Neutron::Port',NULL,10),(76,'f0722d55-6771-4e7f-9008-4a68a45eef57','fa303946-c89d-4a77-8a98-9541ade77b71','2025-12-06 04:28:28',NULL,'DELETE','IN_PROGRESS','test','api-177751087-stack-test-zmgdyff56ofx','state changed','OS::Heat::TestResource',NULL,14),(77,'42abca95-dd5d-453a-b572-2a71c7e9c028','fa303946-c89d-4a77-8a98-9541ade77b71','2025-12-06 04:28:28',NULL,'DELETE','COMPLETE','test','api-177751087-stack-test-zmgdyff56ofx','state changed','OS::Heat::TestResource',NULL,14),(78,'4fc100dd-661a-4454-a2d1-c897897cb73b','fa303946-c89d-4a77-8a98-9541ade77b71','2025-12-06 04:28:28',NULL,'DELETE','COMPLETE','api-177751087-stack','fa303946-c89d-4a77-8a98-9541ade77b71','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(79,'d7c18d94-3177-4afa-bdd9-82e89b674f98','9c9c85f4-553c-4e26-a99e-a35619f0439b','2025-12-06 04:28:28',NULL,'UPDATE','COMPLETE','test','api-229566953-stack-test-r6mklavd53gv','state changed','OS::Heat::TestResource',NULL,15),(80,'3adc9371-2d50-4082-8081-5a1ffc5f2db9','9c9c85f4-553c-4e26-a99e-a35619f0439b','2025-12-06 04:28:28',NULL,'UPDATE','COMPLETE','api-229566953-stack','9c9c85f4-553c-4e26-a99e-a35619f0439b','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(81,'01d3d38c-4bef-4c3b-9641-4cf248e917e9','9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:29',NULL,'UPDATE','COMPLETE','port','453744f7-d60f-45be-b014-0eb40a5006da','state changed','OS::Neutron::Port',NULL,16),(82,'7463cfcf-7fb7-40b5-b197-fb09d93cf59f','9c9c85f4-553c-4e26-a99e-a35619f0439b','2025-12-06 04:28:29',NULL,'UPDATE','IN_PROGRESS','api-229566953-stack','9c9c85f4-553c-4e26-a99e-a35619f0439b','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(83,'747297e1-be70-4c95-a22b-c503a5d19d80','a030ddb3-972e-4d5d-8b3e-f84aaa91ce78','2025-12-06 04:28:29',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-1395331772','a030ddb3-972e-4d5d-8b3e-f84aaa91ce78','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(84,'f0c8451d-3ce6-4d77-bf0c-bdb46e8a2233','9c9c85f4-553c-4e26-a99e-a35619f0439b','2025-12-06 04:28:29',NULL,'UPDATE','IN_PROGRESS','test','api-229566953-stack-test-r6mklavd53gv','state changed','OS::Heat::TestResource',NULL,15),(85,'229cdea3-42eb-4626-8f52-c00a3dc28f7e','a030ddb3-972e-4d5d-8b3e-f84aaa91ce78','2025-12-06 04:28:29',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-1395331772-net-yrff46hdns3n','state changed','OS::Neutron::Net',NULL,NULL),(86,'b40dd6d2-da02-4c1a-b7ed-fa6a85f6dae5','9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:29',NULL,'UPDATE','COMPLETE','UpdatePortTest-39567136','9c80649e-8029-4a3d-8d41-2cefde857216','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(87,'e764db5a-d92c-4097-b400-2e6d050662ab','a030ddb3-972e-4d5d-8b3e-f84aaa91ce78','2025-12-06 04:28:30',NULL,'CREATE','COMPLETE','net','88cf0c3f-0bf9-482d-85b7-e3f90775ad49','state changed','OS::Neutron::Net',NULL,NULL),(88,'b65af467-cb7c-4469-955f-78d53222e66c','a030ddb3-972e-4d5d-8b3e-f84aaa91ce78','2025-12-06 04:28:31',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-1395331772-subnet-exeldvurjl3k','state changed','OS::Neutron::Subnet',NULL,18),(89,'b525dcfd-5e7a-4f2a-8d98-86b1a2de62f3','9c9c85f4-553c-4e26-a99e-a35619f0439b','2025-12-06 04:28:31',NULL,'UPDATE','COMPLETE','test','api-229566953-stack-test-r6mklavd53gv','state changed','OS::Heat::TestResource',NULL,19),(90,'0e557f7c-2ab3-4e95-8866-0204c93c876a','9c9c85f4-553c-4e26-a99e-a35619f0439b','2025-12-06 04:28:31',NULL,'UPDATE','COMPLETE','api-229566953-stack','9c9c85f4-553c-4e26-a99e-a35619f0439b','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(91,'71668fa7-f793-48d4-b60b-e0e062779d59','9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:32',NULL,'DELETE','IN_PROGRESS','UpdatePortTest-39567136','9c80649e-8029-4a3d-8d41-2cefde857216','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(92,'4d31aa41-a16a-4676-99da-cc98ceb28628','9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:32',NULL,'DELETE','IN_PROGRESS','test','UpdatePortTest-39567136-test-bhbq7aep2lsk','state changed','OS::Heat::TestResource',NULL,12),(93,'a5696de5-7e4d-4566-b1dc-bf1b99b8306a','9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:32',NULL,'DELETE','COMPLETE','test','UpdatePortTest-39567136-test-bhbq7aep2lsk','state changed','OS::Heat::TestResource',NULL,12),(94,'ccb14019-200d-429c-94f6-3922bbb74940','9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:32',NULL,'DELETE','IN_PROGRESS','port','453744f7-d60f-45be-b014-0eb40a5006da','state changed','OS::Neutron::Port',NULL,16),(95,'8640ed67-11d1-468c-b563-6eecaf84adba','9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:33',NULL,'DELETE','COMPLETE','port','453744f7-d60f-45be-b014-0eb40a5006da','state changed','OS::Neutron::Port',NULL,16),(96,'daaa645a-5fd8-4281-9de4-38ff31438dc2','a030ddb3-972e-4d5d-8b3e-f84aaa91ce78','2025-12-06 04:28:33',NULL,'CREATE','COMPLETE','subnet','72ad1f62-e50a-4796-9a7c-31bfd4acecb0','state changed','OS::Neutron::Subnet',NULL,18),(97,'0ac845ad-5306-40af-be5a-681d40bd8dce','a030ddb3-972e-4d5d-8b3e-f84aaa91ce78','2025-12-06 04:28:33',NULL,'CREATE','COMPLETE','UpdateSubnetTest-1395331772','a030ddb3-972e-4d5d-8b3e-f84aaa91ce78','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(98,'cff10c7b-3e35-4f82-854c-c22ef7326d51','9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:33',NULL,'DELETE','IN_PROGRESS','subnet','6121f159-8ee9-47d5-847f-409fd23046f2','state changed','OS::Neutron::Subnet',NULL,7),(99,'938e3bb2-c7ba-4c8c-9ed0-c6095787ae4d','9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:33',NULL,'DELETE','COMPLETE','subnet','6121f159-8ee9-47d5-847f-409fd23046f2','state changed','OS::Neutron::Subnet',NULL,7),(100,'158015bb-aa41-41ae-b8eb-ae8a793c0fe4','9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:33',NULL,'DELETE','IN_PROGRESS','net','5bb017d0-d73d-4f54-b5fb-db3a628a4122','state changed','OS::Neutron::Net',NULL,NULL),(101,'bb3ec9d6-e818-40dd-bea0-34ef84b7bc3a','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:33',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-954838670','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(102,'cc0d1c7a-9692-4294-920a-ff454f50ca49','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:34',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-954838670-parent_net-2bdkez35ixyr','state changed','OS::Neutron::Net',NULL,NULL),(103,'0ce97369-bff9-4546-962a-f0cd190020d9','9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:34',NULL,'DELETE','COMPLETE','net','5bb017d0-d73d-4f54-b5fb-db3a628a4122','state changed','OS::Neutron::Net',NULL,NULL),(104,'073f7ada-d472-46f0-9bb8-5644205ea648','9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:34',NULL,'DELETE','COMPLETE','UpdatePortTest-39567136','9c80649e-8029-4a3d-8d41-2cefde857216','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(105,'c0d5cecf-aa2f-4879-98d6-0d902d99a1b7','a030ddb3-972e-4d5d-8b3e-f84aaa91ce78','2025-12-06 04:28:35',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-1395331772','a030ddb3-972e-4d5d-8b3e-f84aaa91ce78','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(106,'5ea2cb3c-34d4-43fb-a6fc-b83f6776fd5f','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:35',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-954838670-trunk_net_two-ukkjcuujihnc','state changed','OS::Neutron::Net',NULL,NULL),(107,'cf83e787-6917-4aee-b087-b2706646d08a','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:35',NULL,'CREATE','COMPLETE','parent_net','46411669-3e9e-4679-8d33-96aeeae470cc','state changed','OS::Neutron::Net',NULL,NULL),(108,'62dd0526-868b-46f6-b4ee-b9a62925658e','a030ddb3-972e-4d5d-8b3e-f84aaa91ce78','2025-12-06 04:28:35',NULL,'UPDATE','IN_PROGRESS','subnet','72ad1f62-e50a-4796-9a7c-31bfd4acecb0','state changed','OS::Neutron::Subnet',NULL,18),(109,'95484f64-831d-4e9f-b1a5-894d4c4a593d','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:35',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-954838670-parent_subnet-uaqx3svb3zcb','state changed','OS::Neutron::Subnet',NULL,21),(110,'d905c579-cdcd-42b5-a405-ebbe38cd18d2','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:36',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-954838670-trunk_net_one-xiwhdztwl3xe','state changed','OS::Neutron::Net',NULL,NULL),(111,'026b5906-2938-48f5-a0e1-221f68cd1212','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:36',NULL,'CREATE','COMPLETE','trunk_net_two','d774ea99-7814-4d82-9470-d141490ef043','state changed','OS::Neutron::Net',NULL,NULL),(112,'8b6200d8-5de2-46e1-8d82-8c10a54c3da4','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:36',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-954838670-trunk_subnet_two-rgbadfhrevry','state changed','OS::Neutron::Subnet',NULL,22),(113,'9e60c248-7960-4422-bdf7-31492334a1cc','a030ddb3-972e-4d5d-8b3e-f84aaa91ce78','2025-12-06 04:28:36',NULL,'UPDATE','COMPLETE','subnet','72ad1f62-e50a-4796-9a7c-31bfd4acecb0','state changed','OS::Neutron::Subnet',NULL,23),(114,'ffdea011-1abc-4aaa-9d04-213951327d77','a030ddb3-972e-4d5d-8b3e-f84aaa91ce78','2025-12-06 04:28:36',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-1395331772','a030ddb3-972e-4d5d-8b3e-f84aaa91ce78','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(115,'9d3f767f-3a4a-4615-b592-b45a3315f3bf','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:37',NULL,'CREATE','COMPLETE','parent_subnet','a622bce9-1210-4ef2-a9f2-10300bdcabbe','state changed','OS::Neutron::Subnet',NULL,21),(116,'2f5b61b2-f360-4b05-960e-3a8b382ed96c','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:37',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-954838670-parent_port-zvif4xf6c4hk','state changed','OS::Neutron::Port',NULL,24),(117,'2364b11e-ba3a-497a-aeb2-2f7d734d7826','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:37',NULL,'CREATE','COMPLETE','trunk_net_one','ae2eff72-d93f-4097-a209-b442838f4082','state changed','OS::Neutron::Net',NULL,NULL),(118,'ef41dcee-fd4d-422e-a512-ba0fe59271cc','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:37',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-954838670-trunk_subnet_one-3wz73627xnso','state changed','OS::Neutron::Subnet',NULL,25),(119,'0245176a-266f-4d2c-957c-ea4287a5871a','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:37',NULL,'CREATE','IN_PROGRESS','UpdatePortTest-420400297','f9c30769-6c23-418b-84e3-434e3ef71b22','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(120,'43393e92-cd34-4b76-b0b1-65dfcd41fe6f','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:39',NULL,'CREATE','IN_PROGRESS','net','UpdatePortTest-420400297-net-t2l5xctlpmtl','state changed','OS::Neutron::Net',NULL,NULL),(121,'12ea2209-3b5d-46ca-bf81-56bd88937b25','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:39',NULL,'CREATE','COMPLETE','trunk_subnet_two','d5d51259-31eb-4492-a712-96015370ca86','state changed','OS::Neutron::Subnet',NULL,22),(122,'3ec4c059-7b80-4047-803e-3c106ab5f85b','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:39',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-954838670-sub_port_two-r2bm62ql42mf','state changed','OS::Neutron::Port',NULL,27),(123,'9b38886c-8653-418e-97d2-faec7391e41f','a030ddb3-972e-4d5d-8b3e-f84aaa91ce78','2025-12-06 04:28:40',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-1395331772','a030ddb3-972e-4d5d-8b3e-f84aaa91ce78','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(124,'752e09d1-2622-4bd4-bcae-046bc88674c8','a030ddb3-972e-4d5d-8b3e-f84aaa91ce78','2025-12-06 04:28:40',NULL,'DELETE','IN_PROGRESS','subnet','72ad1f62-e50a-4796-9a7c-31bfd4acecb0','state changed','OS::Neutron::Subnet',NULL,23),(125,'3d1db140-2209-4f69-bc48-cbaa6e47846c','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:40',NULL,'CREATE','COMPLETE','parent_port','0cb0a77a-1aa2-414e-be4d-4df7599f71ac','state changed','OS::Neutron::Port',NULL,24),(126,'ee9d6a01-68d1-4a32-9a75-c81af3651bc5','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:40',NULL,'CREATE','COMPLETE','net','22c87822-dadc-4aed-9722-6cb4c651490d','state changed','OS::Neutron::Net',NULL,NULL),(127,'c4cfa524-7401-4fbb-a752-f176f59549fd','a030ddb3-972e-4d5d-8b3e-f84aaa91ce78','2025-12-06 04:28:40',NULL,'DELETE','COMPLETE','subnet','72ad1f62-e50a-4796-9a7c-31bfd4acecb0','state changed','OS::Neutron::Subnet',NULL,23),(128,'eabd8380-8d7f-49d2-bcdf-f6fd91140a95','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:40',NULL,'CREATE','COMPLETE','trunk_subnet_one','ef19a4d6-1c83-4b8a-a01d-de1a07f6f4df','state changed','OS::Neutron::Subnet',NULL,25),(129,'4d42d549-2abb-4315-9967-331011255fbc','a030ddb3-972e-4d5d-8b3e-f84aaa91ce78','2025-12-06 04:28:40',NULL,'DELETE','IN_PROGRESS','net','88cf0c3f-0bf9-482d-85b7-e3f90775ad49','state changed','OS::Neutron::Net',NULL,NULL),(130,'1a5595d4-07c7-45c2-9623-b068eda8b199','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:40',NULL,'CREATE','IN_PROGRESS','subnet','UpdatePortTest-420400297-subnet-zkaub2mf6zsb','state changed','OS::Neutron::Subnet',NULL,28),(131,'8fcdff89-4238-45e1-9cc1-11d9e5ba0752','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:40',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-954838670-sub_port_one-yifq6jrhbleb','state changed','OS::Neutron::Port',NULL,29),(132,'a1a3797d-d36f-4444-ba91-f6a833626761','930ed621-3ce6-46e9-a4df-e52f15ab6906','2025-12-06 04:28:40',NULL,'CREATE','COMPLETE','server_with_encrypted_property','1633e001-88de-4ceb-b44e-69e9584b08a8','state changed','OS::Nova::Server',NULL,13),(133,'6686ff8f-e1c9-4d47-a8e0-b8a8a5aabb25','930ed621-3ce6-46e9-a4df-e52f15ab6906','2025-12-06 04:28:40',NULL,'CREATE','COMPLETE','EncryptedParametersTest-74094787','930ed621-3ce6-46e9-a4df-e52f15ab6906','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(134,'52e98fb8-3862-48b3-a976-178cae0bf33f','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:41',NULL,'CREATE','COMPLETE','subnet','7bacc5cb-9dd9-4a78-94ba-f81785a81555','state changed','OS::Neutron::Subnet',NULL,28),(135,'001ec36b-5a57-4241-a92a-0d584f7af5a8','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:41',NULL,'CREATE','IN_PROGRESS','port','UpdatePortTest-420400297-port-k6rurzbtzyo7','state changed','OS::Neutron::Port',NULL,30),(136,'e7ce02a9-4234-46a9-9833-58df828ffbbe','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:41',NULL,'CREATE','COMPLETE','sub_port_two','c413f1da-d8a9-48bf-bd3a-6509419f83e9','state changed','OS::Neutron::Port',NULL,27),(137,'015a77d4-3bd7-443b-8091-73695ffebc33','a030ddb3-972e-4d5d-8b3e-f84aaa91ce78','2025-12-06 04:28:41',NULL,'DELETE','COMPLETE','net','88cf0c3f-0bf9-482d-85b7-e3f90775ad49','state changed','OS::Neutron::Net',NULL,NULL),(138,'de25b9a9-7fad-46f7-92f2-a70beaa09493','a030ddb3-972e-4d5d-8b3e-f84aaa91ce78','2025-12-06 04:28:41',NULL,'DELETE','COMPLETE','UpdateSubnetTest-1395331772','a030ddb3-972e-4d5d-8b3e-f84aaa91ce78','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(139,'70989a39-2d55-4931-aaea-02da5e490935','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:42',NULL,'CREATE','COMPLETE','sub_port_one','f1bf571f-185b-4114-888d-72286c4caaa2','state changed','OS::Neutron::Port',NULL,29),(140,'1eb58dcd-c5c8-4481-813c-421b82cb3ca6','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:42',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-954838670-trunk-d6ci7pc63l2o','state changed','OS::Neutron::Trunk',NULL,31),(141,'d6c0775a-0dbb-468f-9d39-1a08cdd5751c','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:42',NULL,'CREATE','COMPLETE','port','d85b3a5b-1df7-466f-82b9-91c31857a349','state changed','OS::Neutron::Port',NULL,30),(142,'ffbbe74e-2afd-4458-afaa-66adfa234580','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:42',NULL,'CREATE','IN_PROGRESS','test','UpdatePortTest-420400297-test-glxvbjzv5myh','state changed','OS::Heat::TestResource',NULL,33),(143,'8cdf736e-0842-47fb-8d61-e2bbb3df0b30','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:42',NULL,'CREATE','COMPLETE','test','UpdatePortTest-420400297-test-glxvbjzv5myh','state changed','OS::Heat::TestResource',NULL,33),(144,'ced03190-1c8d-4bbb-ac6a-b5dad3987d86','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:42',NULL,'CREATE','COMPLETE','UpdatePortTest-420400297','f9c30769-6c23-418b-84e3-434e3ef71b22','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(145,'51f42b2b-88e6-4580-8b7c-6b0f8c4c093e','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:43',NULL,'CREATE','COMPLETE','trunk','6560792f-a913-4f1f-ac51-22b238881160','state changed','OS::Neutron::Trunk',NULL,31),(146,'e1a7898a-c1ff-456d-87c3-395af2c3529c','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:43',NULL,'CREATE','COMPLETE','UpdateTrunkTest-954838670','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(147,'bdb0fc80-523b-49af-8754-890a5a19dce5','930ed621-3ce6-46e9-a4df-e52f15ab6906','2025-12-06 04:28:43',NULL,'DELETE','IN_PROGRESS','EncryptedParametersTest-74094787','930ed621-3ce6-46e9-a4df-e52f15ab6906','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(148,'d7a8d32c-e461-4f5d-8cc9-ef5aa9f58d04','930ed621-3ce6-46e9-a4df-e52f15ab6906','2025-12-06 04:28:43',NULL,'DELETE','IN_PROGRESS','server_with_encrypted_property','1633e001-88de-4ceb-b44e-69e9584b08a8','state changed','OS::Nova::Server',NULL,13),(149,'7f845ca3-5bb3-4277-8610-3ac6b62f6160','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:44',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-954838670','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(150,'bb63cbf7-bacf-406b-8b9e-abfb41ebf793','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:45',NULL,'UPDATE','IN_PROGRESS','UpdatePortTest-420400297','f9c30769-6c23-418b-84e3-434e3ef71b22','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(151,'ced3c15c-d276-4be9-8d96-c6fdcd56e659','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:45',NULL,'UPDATE','IN_PROGRESS','port','d85b3a5b-1df7-466f-82b9-91c31857a349','state changed','OS::Neutron::Port',NULL,30),(152,'ff0a64b3-7d15-4930-973f-1eb4f96c24aa','c3997fe8-c05a-4490-a371-6e697dad4d53','2025-12-06 04:28:46',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-215065987','c3997fe8-c05a-4490-a371-6e697dad4d53','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(153,'d6db9846-3485-498b-842a-638565e8a204','c3997fe8-c05a-4490-a371-6e697dad4d53','2025-12-06 04:28:46',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-215065987-net-awz7rodcgbgd','state changed','OS::Neutron::Net',NULL,NULL),(154,'daaa5513-ff31-4e16-8eb8-0884ae27f5de','930ed621-3ce6-46e9-a4df-e52f15ab6906','2025-12-06 04:28:46',NULL,'DELETE','COMPLETE','server_with_encrypted_property','1633e001-88de-4ceb-b44e-69e9584b08a8','state changed','OS::Nova::Server',NULL,13),(155,'c82731f8-a4fe-4118-b8f2-f03cb61e8697','930ed621-3ce6-46e9-a4df-e52f15ab6906','2025-12-06 04:28:46',NULL,'DELETE','COMPLETE','EncryptedParametersTest-74094787','930ed621-3ce6-46e9-a4df-e52f15ab6906','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(156,'50c6b6f9-07b1-46a1-b5fd-db3c2e5acdc3','c3997fe8-c05a-4490-a371-6e697dad4d53','2025-12-06 04:28:47',NULL,'CREATE','COMPLETE','net','2d7846d7-d08f-4eda-90c9-8c5cb661f0b2','state changed','OS::Neutron::Net',NULL,NULL),(157,'6a25c70f-ac45-4210-900e-4e282aa3514f','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:47',NULL,'UPDATE','COMPLETE','port','d85b3a5b-1df7-466f-82b9-91c31857a349','The Resource port requires replacement.','OS::Neutron::Port',NULL,30),(158,'11566bb5-11fd-48ad-ad9f-2c506b0edd88','c3997fe8-c05a-4490-a371-6e697dad4d53','2025-12-06 04:28:47',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-215065987-subnet-yyb2jkc3ofth','state changed','OS::Neutron::Subnet',NULL,34),(159,'d70e0cdd-1014-4472-81f1-88aabb7bf685','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:47',NULL,'CREATE','IN_PROGRESS','port','UpdatePortTest-420400297-port-j5vqsvpeb5wc','state changed','OS::Neutron::Port',NULL,35),(160,'b9bd47ef-ace6-457d-9432-f98d8b019017','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:48',NULL,'UPDATE','IN_PROGRESS','trunk','6560792f-a913-4f1f-ac51-22b238881160','state changed','OS::Neutron::Trunk',NULL,31),(161,'9e79ff9b-aa57-483f-b3b2-95fa232a4c96','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:48',NULL,'CREATE','COMPLETE','port','f1b7c494-cb08-49f8-a912-c89aee37216e','state changed','OS::Neutron::Port',NULL,35),(162,'a955f373-f1db-4d6a-9b85-07e60fd98c15','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:49',NULL,'DELETE','IN_PROGRESS','port','d85b3a5b-1df7-466f-82b9-91c31857a349','state changed','OS::Neutron::Port',NULL,30),(163,'5652f4c3-ddd8-4396-a2f5-f106aa923740','c3997fe8-c05a-4490-a371-6e697dad4d53','2025-12-06 04:28:49',NULL,'CREATE','COMPLETE','subnet','c4c0cb55-6dc4-4018-95da-fd7a59436a82','state changed','OS::Neutron::Subnet',NULL,34),(164,'209db665-bc6a-4963-843a-b5ae37b04511','c3997fe8-c05a-4490-a371-6e697dad4d53','2025-12-06 04:28:49',NULL,'CREATE','COMPLETE','UpdateSubnetTest-215065987','c3997fe8-c05a-4490-a371-6e697dad4d53','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(165,'d49399d5-84b5-487a-b3c1-79b014972e83','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:49',NULL,'DELETE','COMPLETE','port','d85b3a5b-1df7-466f-82b9-91c31857a349','state changed','OS::Neutron::Port',NULL,30),(166,'3b7e6da0-d542-4b26-85f0-4656a62cf950','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:49',NULL,'UPDATE','COMPLETE','UpdatePortTest-420400297','f9c30769-6c23-418b-84e3-434e3ef71b22','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(167,'0c7b436d-474c-40a0-8b9e-fa70ab04de29','f15b23a5-7414-48b5-bdb0-c4dabcdcf623','2025-12-06 04:28:49',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-116901463','f15b23a5-7414-48b5-bdb0-c4dabcdcf623','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(168,'5270fec5-b4a8-489a-857e-bcbfe3702efd','f15b23a5-7414-48b5-bdb0-c4dabcdcf623','2025-12-06 04:28:49',NULL,'CREATE','IN_PROGRESS','random1','RemoteStackTest-116901463-random1-ukbyblmr6bnw','state changed','OS::Heat::RandomString',NULL,NULL),(169,'4b553582-1800-4ee4-9b1f-55e22134ea3c','f15b23a5-7414-48b5-bdb0-c4dabcdcf623','2025-12-06 04:28:49',NULL,'CREATE','COMPLETE','random1','RemoteStackTest-116901463-random1-ukbyblmr6bnw','state changed','OS::Heat::RandomString',NULL,NULL),(170,'c77c515c-82ad-418e-8342-03c08451b24e','f15b23a5-7414-48b5-bdb0-c4dabcdcf623','2025-12-06 04:28:49',NULL,'CREATE','COMPLETE','RemoteStackTest-116901463','f15b23a5-7414-48b5-bdb0-c4dabcdcf623','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(171,'e9b354f7-f092-4652-801f-47dd64cc2775','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:50',NULL,'UPDATE','COMPLETE','trunk','6560792f-a913-4f1f-ac51-22b238881160','state changed','OS::Neutron::Trunk',NULL,37),(172,'73e141e9-9681-4289-aaf8-939d39baf5c1','f15b23a5-7414-48b5-bdb0-c4dabcdcf623','2025-12-06 04:28:50',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-116901463','f15b23a5-7414-48b5-bdb0-c4dabcdcf623','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(173,'8f431afc-b1c6-4f30-8429-8487a985281e','f15b23a5-7414-48b5-bdb0-c4dabcdcf623','2025-12-06 04:28:50',NULL,'DELETE','IN_PROGRESS','random1','RemoteStackTest-116901463-random1-ukbyblmr6bnw','state changed','OS::Heat::RandomString',NULL,NULL),(174,'8b7698b9-7dc9-4995-a260-c45b0291dd5c','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:50',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-954838670','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(175,'d7f9c322-17c4-43b5-98f1-439fad531918','f15b23a5-7414-48b5-bdb0-c4dabcdcf623','2025-12-06 04:28:50',NULL,'DELETE','COMPLETE','random1','RemoteStackTest-116901463-random1-ukbyblmr6bnw','state changed','OS::Heat::RandomString',NULL,NULL),(176,'e8d3f991-680b-4f68-b853-3945dfb662f2','f15b23a5-7414-48b5-bdb0-c4dabcdcf623','2025-12-06 04:28:50',NULL,'DELETE','COMPLETE','RemoteStackTest-116901463','f15b23a5-7414-48b5-bdb0-c4dabcdcf623','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(177,'1586df65-e607-4d23-9282-9aa296b6dad1','c3997fe8-c05a-4490-a371-6e697dad4d53','2025-12-06 04:28:51',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-215065987','c3997fe8-c05a-4490-a371-6e697dad4d53','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(178,'baa45c3c-463c-4bcc-8657-c7172e1f28e3','c3997fe8-c05a-4490-a371-6e697dad4d53','2025-12-06 04:28:51',NULL,'UPDATE','IN_PROGRESS','subnet','c4c0cb55-6dc4-4018-95da-fd7a59436a82','state changed','OS::Neutron::Subnet',NULL,34),(179,'643a1d5d-d028-425b-bd5f-160bbb06bfb4','c3997fe8-c05a-4490-a371-6e697dad4d53','2025-12-06 04:28:52',NULL,'UPDATE','COMPLETE','subnet','c4c0cb55-6dc4-4018-95da-fd7a59436a82','state changed','OS::Neutron::Subnet',NULL,39),(180,'6de2aa9c-cf7f-4a5e-91ed-ad8410bc0d6c','c3997fe8-c05a-4490-a371-6e697dad4d53','2025-12-06 04:28:52',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-215065987','c3997fe8-c05a-4490-a371-6e697dad4d53','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(181,'39ad288b-8959-462c-8b27-3bb1c4e57bc8','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:55',NULL,'DELETE','IN_PROGRESS','UpdatePortTest-420400297','f9c30769-6c23-418b-84e3-434e3ef71b22','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(182,'a51ab904-8bd5-4dfe-a05e-b66eb5bfb8d5','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:56',NULL,'DELETE','IN_PROGRESS','port','f1b7c494-cb08-49f8-a912-c89aee37216e','state changed','OS::Neutron::Port',NULL,35),(183,'314d6ffd-b022-4c84-8f85-a72805af4318','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:57',NULL,'DELETE','COMPLETE','port','f1b7c494-cb08-49f8-a912-c89aee37216e','state changed','OS::Neutron::Port',NULL,35),(184,'ecf549d2-6789-400f-94bd-72220b265edf','83c13545-518e-421e-9f99-8ea87b70d42b','2025-12-06 04:28:57',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-410959829','83c13545-518e-421e-9f99-8ea87b70d42b','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(185,'511ad120-e530-4ac5-9180-877adee71cd6','c3997fe8-c05a-4490-a371-6e697dad4d53','2025-12-06 04:28:57',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-215065987','c3997fe8-c05a-4490-a371-6e697dad4d53','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(186,'3db23d22-84eb-4930-aff1-cdd657f6a97a','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:57',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-954838670','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(187,'82b0833f-1577-4b17-ab39-671a793c0dd0','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:57',NULL,'DELETE','IN_PROGRESS','subnet','7bacc5cb-9dd9-4a78-94ba-f81785a81555','state changed','OS::Neutron::Subnet',NULL,28),(188,'c82fcb96-31f1-4454-b8c9-ccb151674e2d','c3997fe8-c05a-4490-a371-6e697dad4d53','2025-12-06 04:28:57',NULL,'DELETE','IN_PROGRESS','subnet','c4c0cb55-6dc4-4018-95da-fd7a59436a82','state changed','OS::Neutron::Subnet',NULL,39),(189,'a43d4d1e-16b9-4597-b00e-878a3e281070','83c13545-518e-421e-9f99-8ea87b70d42b','2025-12-06 04:28:57',NULL,'CREATE','IN_PROGRESS','my_stack','RemoteStackTest-410959829-my_stack-ykioqnifchhb','state changed','OS::Heat::Stack',NULL,42),(190,'7e5c0cd2-2f94-4d4e-8d25-2aef21b09fe5','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:57',NULL,'DELETE','IN_PROGRESS','trunk','6560792f-a913-4f1f-ac51-22b238881160','state changed','OS::Neutron::Trunk',NULL,37),(191,'8095c7e0-7b67-4ef1-a3f6-188ca685dd1b','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:57',NULL,'DELETE','IN_PROGRESS','test','UpdatePortTest-420400297-test-glxvbjzv5myh','state changed','OS::Heat::TestResource',NULL,33),(192,'545289dc-f088-47a5-a753-76a1c27e0b3b','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:57',NULL,'DELETE','COMPLETE','test','UpdatePortTest-420400297-test-glxvbjzv5myh','state changed','OS::Heat::TestResource',NULL,33),(193,'9620da99-ef1e-4c3a-8111-07314e89e917','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:58',NULL,'DELETE','COMPLETE','trunk','6560792f-a913-4f1f-ac51-22b238881160','state changed','OS::Neutron::Trunk',NULL,37),(194,'8103bb8a-a744-4358-9d4f-d67d997ce706','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:58',NULL,'DELETE','IN_PROGRESS','parent_port','0cb0a77a-1aa2-414e-be4d-4df7599f71ac','state changed','OS::Neutron::Port',NULL,24),(195,'9e1dc93e-41bb-4651-aeed-714dbd72bf49','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:58',NULL,'DELETE','IN_PROGRESS','sub_port_one','f1bf571f-185b-4114-888d-72286c4caaa2','state changed','OS::Neutron::Port',NULL,29),(196,'4f6282de-e430-4782-bc4c-11aea2a59863','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:58',NULL,'DELETE','COMPLETE','subnet','7bacc5cb-9dd9-4a78-94ba-f81785a81555','state changed','OS::Neutron::Subnet',NULL,28),(197,'e78b2c5d-66a0-459f-b878-13a420109428','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:58',NULL,'DELETE','IN_PROGRESS','sub_port_two','c413f1da-d8a9-48bf-bd3a-6509419f83e9','state changed','OS::Neutron::Port',NULL,27),(198,'91f49e8f-e079-4287-a44d-c18bd478f1b5','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:58',NULL,'DELETE','IN_PROGRESS','net','22c87822-dadc-4aed-9722-6cb4c651490d','state changed','OS::Neutron::Net',NULL,NULL),(199,'435260b7-039d-460f-aa81-4d9b8eabecf9','c3997fe8-c05a-4490-a371-6e697dad4d53','2025-12-06 04:28:58',NULL,'DELETE','COMPLETE','subnet','c4c0cb55-6dc4-4018-95da-fd7a59436a82','state changed','OS::Neutron::Subnet',NULL,39),(200,'a2dd73e3-156e-4beb-a6a1-ce6962bfbeb5','c3997fe8-c05a-4490-a371-6e697dad4d53','2025-12-06 04:28:58',NULL,'DELETE','IN_PROGRESS','net','2d7846d7-d08f-4eda-90c9-8c5cb661f0b2','state changed','OS::Neutron::Net',NULL,NULL),(201,'ec1f5ed3-769f-411f-b59b-feda4d6651e6','9eb47515-8571-4a0a-bf1a-44ebcd8e61a8','2025-12-06 04:28:58',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-410959829-my_stack-ykioqnifchhb','9eb47515-8571-4a0a-bf1a-44ebcd8e61a8','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(202,'3ea270d8-1786-4d66-9164-d0d730653a6a','9eb47515-8571-4a0a-bf1a-44ebcd8e61a8','2025-12-06 04:28:58',NULL,'CREATE','IN_PROGRESS','random1','RemoteStackTest-410959829-my_stack-ykioqnifchhb-random1-iynwircubwxv','state changed','OS::Heat::RandomString',NULL,NULL),(203,'1dcdff48-4e48-4b99-9404-34c9e2fdf029','9eb47515-8571-4a0a-bf1a-44ebcd8e61a8','2025-12-06 04:28:58',NULL,'CREATE','COMPLETE','random1','RemoteStackTest-410959829-my_stack-ykioqnifchhb-random1-iynwircubwxv','state changed','OS::Heat::RandomString',NULL,NULL),(204,'c96b2702-2262-493b-91a4-8d5a9934ff60','9eb47515-8571-4a0a-bf1a-44ebcd8e61a8','2025-12-06 04:28:58',NULL,'CREATE','COMPLETE','RemoteStackTest-410959829-my_stack-ykioqnifchhb','9eb47515-8571-4a0a-bf1a-44ebcd8e61a8','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(205,'0336dce5-283c-497a-994e-9aaa6ac1a9b1','83c13545-518e-421e-9f99-8ea87b70d42b','2025-12-06 04:28:58',NULL,'CREATE','COMPLETE','my_stack','9eb47515-8571-4a0a-bf1a-44ebcd8e61a8','state changed','OS::Heat::Stack',NULL,42),(206,'5fb719ca-1549-49cb-a6f5-83c2b25141ed','83c13545-518e-421e-9f99-8ea87b70d42b','2025-12-06 04:28:58',NULL,'CREATE','COMPLETE','RemoteStackTest-410959829','83c13545-518e-421e-9f99-8ea87b70d42b','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(207,'c1d3a24c-59de-4459-807d-9e0ff7b2427b','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:58',NULL,'DELETE','COMPLETE','sub_port_one','f1bf571f-185b-4114-888d-72286c4caaa2','state changed','OS::Neutron::Port',NULL,29),(208,'e7ee892f-1513-48c8-a4e2-1eb04d6817c0','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:59',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','ef19a4d6-1c83-4b8a-a01d-de1a07f6f4df','state changed','OS::Neutron::Subnet',NULL,25),(209,'02a26d24-7644-44a9-bf98-e89b01125235','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:59',NULL,'DELETE','COMPLETE','parent_port','0cb0a77a-1aa2-414e-be4d-4df7599f71ac','state changed','OS::Neutron::Port',NULL,24),(210,'eb6a32ac-6681-4e4f-9571-fe3bf6d64c30','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:59',NULL,'DELETE','COMPLETE','sub_port_two','c413f1da-d8a9-48bf-bd3a-6509419f83e9','state changed','OS::Neutron::Port',NULL,27),(211,'28751ca7-b5c5-4b2f-b07e-a204597a53e0','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:59',NULL,'DELETE','IN_PROGRESS','parent_subnet','a622bce9-1210-4ef2-a9f2-10300bdcabbe','state changed','OS::Neutron::Subnet',NULL,21),(212,'36d29482-da3f-4b2e-86d0-e3d6cc60f0ae','c3997fe8-c05a-4490-a371-6e697dad4d53','2025-12-06 04:28:59',NULL,'DELETE','COMPLETE','net','2d7846d7-d08f-4eda-90c9-8c5cb661f0b2','state changed','OS::Neutron::Net',NULL,NULL),(213,'7300a06f-6aff-4352-aa08-506b9ed56be3','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:59',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','d5d51259-31eb-4492-a712-96015370ca86','state changed','OS::Neutron::Subnet',NULL,22),(214,'3d0462a7-3077-4a78-929d-622486d8392c','c3997fe8-c05a-4490-a371-6e697dad4d53','2025-12-06 04:28:59',NULL,'DELETE','COMPLETE','UpdateSubnetTest-215065987','c3997fe8-c05a-4490-a371-6e697dad4d53','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(215,'2e0540d9-bde3-422f-8929-865f5b70b9c8','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:59',NULL,'DELETE','COMPLETE','net','22c87822-dadc-4aed-9722-6cb4c651490d','state changed','OS::Neutron::Net',NULL,NULL),(216,'045153d8-df8c-43a6-aabe-8a1214384170','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:59',NULL,'DELETE','COMPLETE','trunk_subnet_one','ef19a4d6-1c83-4b8a-a01d-de1a07f6f4df','state changed','OS::Neutron::Subnet',NULL,25),(217,'e1992b66-a382-41b1-aad7-5dfde2587c1a','f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:59',NULL,'DELETE','COMPLETE','UpdatePortTest-420400297','f9c30769-6c23-418b-84e3-434e3ef71b22','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(218,'8cd79fad-942c-4b81-b61d-6e77a103c626','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:59',NULL,'DELETE','COMPLETE','parent_subnet','a622bce9-1210-4ef2-a9f2-10300bdcabbe','state changed','OS::Neutron::Subnet',NULL,21),(219,'7b81967c-e0bf-4275-b400-b87ba7fad5fa','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:59',NULL,'DELETE','COMPLETE','trunk_subnet_two','d5d51259-31eb-4492-a712-96015370ca86','state changed','OS::Neutron::Subnet',NULL,22),(220,'b3e72864-99f0-4a06-b2ca-bf818410d7ca','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:59',NULL,'DELETE','IN_PROGRESS','trunk_net_one','ae2eff72-d93f-4097-a209-b442838f4082','state changed','OS::Neutron::Net',NULL,NULL),(221,'81b240e5-efe5-4b25-9404-cdd52c136bac','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:59',NULL,'DELETE','IN_PROGRESS','parent_net','46411669-3e9e-4679-8d33-96aeeae470cc','state changed','OS::Neutron::Net',NULL,NULL),(222,'3ac7eab1-c7e3-48f5-901e-d8962e6efe4e','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:59',NULL,'DELETE','IN_PROGRESS','trunk_net_two','d774ea99-7814-4d82-9470-d141490ef043','state changed','OS::Neutron::Net',NULL,NULL),(223,'6907b5cf-e8a3-44bd-8d92-8761d7360ba8','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:29:00',NULL,'DELETE','COMPLETE','trunk_net_two','d774ea99-7814-4d82-9470-d141490ef043','state changed','OS::Neutron::Net',NULL,NULL),(224,'7cf5cda9-1089-45ec-9bb2-7b8b99a89127','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:29:00',NULL,'DELETE','COMPLETE','parent_net','46411669-3e9e-4679-8d33-96aeeae470cc','state changed','OS::Neutron::Net',NULL,NULL),(225,'8895fd15-3baf-466b-a89e-380f11d13634','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:29:00',NULL,'DELETE','COMPLETE','trunk_net_one','ae2eff72-d93f-4097-a209-b442838f4082','state changed','OS::Neutron::Net',NULL,NULL),(226,'7e6fd361-2fa3-4300-b65d-2c771f148d9d','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:29:00',NULL,'DELETE','COMPLETE','UpdateTrunkTest-954838670','a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(227,'567b5942-1590-45b3-8428-0907ef8284e3','17563277-94b3-481a-94c9-7d378cdc194b','2025-12-06 04:29:02',NULL,'CREATE','IN_PROGRESS','ResourcesList-1956950835','17563277-94b3-481a-94c9-7d378cdc194b','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(228,'c1898cb1-5e27-4a4b-a0bf-239ba8f9c753','17563277-94b3-481a-94c9-7d378cdc194b','2025-12-06 04:29:02',NULL,'CREATE','IN_PROGRESS','test1','ResourcesList-1956950835-test1-sdulr4osg6ik','state changed','OS::Heat::TestResource',NULL,43),(229,'bc0c32b0-b9c2-444f-85d0-1fac8614ba06','17563277-94b3-481a-94c9-7d378cdc194b','2025-12-06 04:29:02',NULL,'CREATE','COMPLETE','test1','ResourcesList-1956950835-test1-sdulr4osg6ik','state changed','OS::Heat::TestResource',NULL,43),(230,'303165b9-079d-40a0-8678-0e92456d2224','17563277-94b3-481a-94c9-7d378cdc194b','2025-12-06 04:29:02',NULL,'CREATE','IN_PROGRESS','test2','ResourcesList-1956950835-test2-sr2a7m6lcgnv','state changed','OS::Heat::TestResource',NULL,44),(231,'430385b0-b31b-463c-8cfd-b7f13fe867f9','17563277-94b3-481a-94c9-7d378cdc194b','2025-12-06 04:29:02',NULL,'CREATE','COMPLETE','test2','ResourcesList-1956950835-test2-sr2a7m6lcgnv','state changed','OS::Heat::TestResource',NULL,44),(232,'178a7d11-a0f3-4f9e-8557-e64c4ae41f52','17563277-94b3-481a-94c9-7d378cdc194b','2025-12-06 04:29:02',NULL,'CREATE','COMPLETE','ResourcesList-1956950835','17563277-94b3-481a-94c9-7d378cdc194b','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(233,'f20800cd-4021-4b6e-b821-60d9b820e9c3','17563277-94b3-481a-94c9-7d378cdc194b','2025-12-06 04:29:03',NULL,'DELETE','IN_PROGRESS','ResourcesList-1956950835','17563277-94b3-481a-94c9-7d378cdc194b','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(234,'ff0144c7-0618-45d4-b62a-78b6a147c4b9','9ae9478a-d759-45df-a4a5-3fff7f6f7405','2025-12-06 04:29:03',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-1540482388','9ae9478a-d759-45df-a4a5-3fff7f6f7405','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(235,'65142895-3f02-4fc1-b379-112c63736f24','17563277-94b3-481a-94c9-7d378cdc194b','2025-12-06 04:29:03',NULL,'DELETE','IN_PROGRESS','test2','ResourcesList-1956950835-test2-sr2a7m6lcgnv','state changed','OS::Heat::TestResource',NULL,44),(236,'c0a5bae7-0b63-4667-a61c-771c68b9cf76','17563277-94b3-481a-94c9-7d378cdc194b','2025-12-06 04:29:03',NULL,'DELETE','COMPLETE','test2','ResourcesList-1956950835-test2-sr2a7m6lcgnv','state changed','OS::Heat::TestResource',NULL,44),(237,'55cfe36d-8d64-40e6-9325-ff93864814ae','17563277-94b3-481a-94c9-7d378cdc194b','2025-12-06 04:29:03',NULL,'DELETE','IN_PROGRESS','test1','ResourcesList-1956950835-test1-sdulr4osg6ik','state changed','OS::Heat::TestResource',NULL,43),(238,'e839e30e-3411-4b45-beb2-1ed3459999f9','17563277-94b3-481a-94c9-7d378cdc194b','2025-12-06 04:29:03',NULL,'DELETE','COMPLETE','test1','ResourcesList-1956950835-test1-sdulr4osg6ik','state changed','OS::Heat::TestResource',NULL,43),(239,'3b63d7da-c541-4f36-9ae1-751a78f0a4d0','9ae9478a-d759-45df-a4a5-3fff7f6f7405','2025-12-06 04:29:03',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-1540482388-net-hxqfe5ihbc7z','state changed','OS::Neutron::Net',NULL,NULL),(240,'1f80c19d-ad50-4a7a-9b4f-c5222d284e9e','17563277-94b3-481a-94c9-7d378cdc194b','2025-12-06 04:29:03',NULL,'DELETE','COMPLETE','ResourcesList-1956950835','17563277-94b3-481a-94c9-7d378cdc194b','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(241,'31e1e32b-164a-47c2-b838-342d49df5d3c','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:03',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-933223569','c7cf0846-c3f2-4edd-850f-92d692c76a3a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(242,'4773fb42-1ba0-4b6a-a829-b66d6fb2b926','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:03',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-933223569-parent_net-vjuxpw3nlmty','state changed','OS::Neutron::Net',NULL,NULL),(243,'300e21e8-1b0c-4744-ad24-f4146253c2c6','83c13545-518e-421e-9f99-8ea87b70d42b','2025-12-06 04:29:04',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-410959829','83c13545-518e-421e-9f99-8ea87b70d42b','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(244,'ff3d8c9d-fe34-4b65-a5cd-5b66b2c12148','9ae9478a-d759-45df-a4a5-3fff7f6f7405','2025-12-06 04:29:04',NULL,'CREATE','COMPLETE','net','80c15e34-6b1a-4376-8a39-81b329aae54e','state changed','OS::Neutron::Net',NULL,NULL),(245,'b3843e36-977c-4e40-abbe-572efab43dd3','83c13545-518e-421e-9f99-8ea87b70d42b','2025-12-06 04:29:04',NULL,'DELETE','IN_PROGRESS','my_stack','9eb47515-8571-4a0a-bf1a-44ebcd8e61a8','state changed','OS::Heat::Stack',NULL,42),(246,'d1295e3d-b2c3-4759-b275-79cd7a506f1c','9ae9478a-d759-45df-a4a5-3fff7f6f7405','2025-12-06 04:29:04',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-1540482388-subnet-sglyt3a6k5hu','state changed','OS::Neutron::Subnet',NULL,46),(247,'c7fe6b51-555a-47f5-823e-dcc28a350f2b','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:04',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-933223569-trunk_net_two-rivzlqkb3ml3','state changed','OS::Neutron::Net',NULL,NULL),(248,'a37dd13b-1071-4b69-8043-b6d06a5b63ab','9eb47515-8571-4a0a-bf1a-44ebcd8e61a8','2025-12-06 04:29:04',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-410959829-my_stack-ykioqnifchhb','9eb47515-8571-4a0a-bf1a-44ebcd8e61a8','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(249,'8f4be867-68d3-4ad5-8c0f-c8d3f60c6c0d','9eb47515-8571-4a0a-bf1a-44ebcd8e61a8','2025-12-06 04:29:04',NULL,'DELETE','IN_PROGRESS','random1','RemoteStackTest-410959829-my_stack-ykioqnifchhb-random1-iynwircubwxv','state changed','OS::Heat::RandomString',NULL,NULL),(250,'00f036b4-3eb2-4f1d-a67d-9d0061934d5c','9eb47515-8571-4a0a-bf1a-44ebcd8e61a8','2025-12-06 04:29:05',NULL,'DELETE','COMPLETE','random1','RemoteStackTest-410959829-my_stack-ykioqnifchhb-random1-iynwircubwxv','state changed','OS::Heat::RandomString',NULL,NULL),(251,'3f2f4b0e-fbae-42f1-9d3b-f3a44381e23f','9eb47515-8571-4a0a-bf1a-44ebcd8e61a8','2025-12-06 04:29:05',NULL,'DELETE','COMPLETE','RemoteStackTest-410959829-my_stack-ykioqnifchhb','9eb47515-8571-4a0a-bf1a-44ebcd8e61a8','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(252,'a9774f27-129a-4ada-a6c3-73f38431da62','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:05',NULL,'CREATE','COMPLETE','parent_net','9707ea6e-e22c-461c-a053-f0f3c46d6ef5','state changed','OS::Neutron::Net',NULL,NULL),(253,'6945261c-6bdc-40cb-bea6-fc0e1b9b9677','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:05',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-933223569-parent_subnet-s2gk27zhkju2','state changed','OS::Neutron::Subnet',NULL,47),(254,'eefbc8fd-adcd-4cf0-b4b3-24a04bb8aa8c','83c13545-518e-421e-9f99-8ea87b70d42b','2025-12-06 04:29:05',NULL,'DELETE','COMPLETE','my_stack','9eb47515-8571-4a0a-bf1a-44ebcd8e61a8','state changed','OS::Heat::Stack',NULL,42),(255,'0ad7ff8f-7842-421a-917c-2c3cb1d7bbe6','83c13545-518e-421e-9f99-8ea87b70d42b','2025-12-06 04:29:05',NULL,'DELETE','COMPLETE','RemoteStackTest-410959829','83c13545-518e-421e-9f99-8ea87b70d42b','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(256,'d1f22884-40dc-400b-9a22-ace2aced68f2','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:05',NULL,'CREATE','COMPLETE','trunk_net_two','c779bd81-3bbe-47e2-a683-dbba250402e4','state changed','OS::Neutron::Net',NULL,NULL),(257,'cda35e6a-ae88-46e9-8fc5-2612013aafdd','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:05',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-933223569-trunk_net_one-h26aw5wyrcfo','state changed','OS::Neutron::Net',NULL,NULL),(258,'ae8842a7-24a4-4fa6-ab77-d65f45e2aa40','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:05',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-933223569-trunk_subnet_two-ezz7ngh2gijv','state changed','OS::Neutron::Subnet',NULL,48),(259,'22d8778d-2aa8-4905-ab6c-df1fff9049f4','9ae9478a-d759-45df-a4a5-3fff7f6f7405','2025-12-06 04:29:06',NULL,'CREATE','COMPLETE','subnet','1232efb9-4a49-4ba3-9a1e-67535d0e0553','state changed','OS::Neutron::Subnet',NULL,46),(260,'dfb2861d-634b-4137-bd48-74edca4dc208','9ae9478a-d759-45df-a4a5-3fff7f6f7405','2025-12-06 04:29:06',NULL,'CREATE','COMPLETE','UpdateSubnetTest-1540482388','9ae9478a-d759-45df-a4a5-3fff7f6f7405','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(261,'feb797da-dae3-46af-900a-32b5b9d9b3d6','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:06',NULL,'CREATE','COMPLETE','parent_subnet','82a5617c-6b9a-46af-8276-f7e6f42ca165','state changed','OS::Neutron::Subnet',NULL,47),(262,'9ec16bc1-1a17-40b3-a6e4-9e1e75462b35','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:06',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-933223569-parent_port-fa47cyrx7ip3','state changed','OS::Neutron::Port',NULL,49),(263,'691486f4-82e4-43a0-a242-88a2126c7ee9','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:06',NULL,'CREATE','COMPLETE','trunk_net_one','e5f69a60-15c4-438f-9c59-671c43e59660','state changed','OS::Neutron::Net',NULL,NULL),(264,'9aa16250-d8ec-4344-88e7-30d62cc228e6','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:07',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-933223569-trunk_subnet_one-n6hvqqux7hiq','state changed','OS::Neutron::Subnet',NULL,50),(265,'87d25c4b-877a-4b34-8f41-e1ef87cf71d1','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:07',NULL,'CREATE','COMPLETE','trunk_subnet_two','6f41851c-6349-41d3-89c1-5006adc2692c','state changed','OS::Neutron::Subnet',NULL,48),(266,'f8df9359-9b8d-45ea-89d0-04e72febac4c','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:07',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-933223569-sub_port_two-vla7anfrs6ja','state changed','OS::Neutron::Port',NULL,51),(267,'25bde9cd-6ead-4069-a60a-43c957041d21','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:08',NULL,'CREATE','COMPLETE','parent_port','c0d0ba86-25cf-40e3-a91a-6f2dde80943d','state changed','OS::Neutron::Port',NULL,49),(268,'a75f100b-7a74-4df4-a970-f5f2638033c0','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:08',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-933223569-trunk-a6hicu66cldg','state changed','OS::Neutron::Trunk',NULL,53),(269,'767b7cc9-ae6c-4248-9480-0ad9197c7079','9ae9478a-d759-45df-a4a5-3fff7f6f7405','2025-12-06 04:29:09',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-1540482388','9ae9478a-d759-45df-a4a5-3fff7f6f7405','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(270,'3398edbb-d423-47ae-bf1e-0067c7e21ad1','9ae9478a-d759-45df-a4a5-3fff7f6f7405','2025-12-06 04:29:09',NULL,'UPDATE','IN_PROGRESS','subnet','1232efb9-4a49-4ba3-9a1e-67535d0e0553','state changed','OS::Neutron::Subnet',NULL,46),(271,'1b19227d-4324-4125-895b-af2463f77696','c55eb522-6b82-4d4d-876c-d04d555c8e68','2025-12-06 04:29:09',NULL,'CREATE','IN_PROGRESS','ResourcesList-924050756','c55eb522-6b82-4d4d-876c-d04d555c8e68','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(272,'17c4578c-7e98-47bd-a1a3-095ef7285b78','c55eb522-6b82-4d4d-876c-d04d555c8e68','2025-12-06 04:29:09',NULL,'CREATE','IN_PROGRESS','test1','ResourcesList-924050756-test1-2i2p2hnox7ii','state changed','OS::Heat::TestResource',NULL,54),(273,'7018a12f-3bb4-4329-92d7-ed7d4be09b12','c55eb522-6b82-4d4d-876c-d04d555c8e68','2025-12-06 04:29:09',NULL,'CREATE','COMPLETE','test1','ResourcesList-924050756-test1-2i2p2hnox7ii','state changed','OS::Heat::TestResource',NULL,54),(274,'a1d07a1c-3fa3-4a00-b2f2-ee876f50eb9d','c55eb522-6b82-4d4d-876c-d04d555c8e68','2025-12-06 04:29:09',NULL,'CREATE','IN_PROGRESS','test2','ResourcesList-924050756-test2-aulocbuum4jm','state changed','OS::Heat::TestResource',NULL,55),(275,'01cb92b4-a9bd-408a-aa88-0df4e7ec15e8','c55eb522-6b82-4d4d-876c-d04d555c8e68','2025-12-06 04:29:09',NULL,'CREATE','COMPLETE','test2','ResourcesList-924050756-test2-aulocbuum4jm','state changed','OS::Heat::TestResource',NULL,55),(276,'1b457eaa-951b-4752-b465-f353b655b5bf','c55eb522-6b82-4d4d-876c-d04d555c8e68','2025-12-06 04:29:09',NULL,'CREATE','COMPLETE','ResourcesList-924050756','c55eb522-6b82-4d4d-876c-d04d555c8e68','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(277,'50d46f5f-6e1b-434b-987b-73dfbc442ad4','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:09',NULL,'CREATE','COMPLETE','trunk_subnet_one','83486500-6a53-4e38-ab20-4dcfc7c12f9d','state changed','OS::Neutron::Subnet',NULL,50),(278,'b22fdf27-03b1-40a8-bec3-b3743bd10fcf','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:09',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-933223569-sub_port_one-ee6qvrhnapjt','state changed','OS::Neutron::Port',NULL,56),(279,'0d858cd3-a1a8-4898-9938-c53a105fa93b','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:09',NULL,'CREATE','COMPLETE','sub_port_two','0ab50f19-a89f-4923-9117-34c3dd710693','state changed','OS::Neutron::Port',NULL,51),(280,'05bca4c8-c65d-443a-8497-83ac720a8b9d','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:09',NULL,'CREATE','COMPLETE','trunk','55e2db14-d47c-4bd1-97b3-736465d5be3a','state changed','OS::Neutron::Trunk',NULL,53),(281,'49362b6d-46bd-47e5-a3aa-58177bf58017','9ae9478a-d759-45df-a4a5-3fff7f6f7405','2025-12-06 04:29:10',NULL,'UPDATE','COMPLETE','subnet','1232efb9-4a49-4ba3-9a1e-67535d0e0553','state changed','OS::Neutron::Subnet',NULL,57),(282,'f11f8f92-31c3-495f-846e-2fd6df7c9ad9','9ae9478a-d759-45df-a4a5-3fff7f6f7405','2025-12-06 04:29:10',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-1540482388','9ae9478a-d759-45df-a4a5-3fff7f6f7405','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(283,'eada5294-b071-47ca-ad5f-48070b99a10b','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:10',NULL,'CREATE','COMPLETE','sub_port_one','7a3a13fd-e6c2-49ac-b1b1-720938360e30','state changed','OS::Neutron::Port',NULL,56),(284,'912e635d-a943-4c95-9a67-dd57c7c92af5','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:10',NULL,'CREATE','COMPLETE','UpdateTrunkTest-933223569','c7cf0846-c3f2-4edd-850f-92d692c76a3a','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(285,'32f6e7da-5217-4510-95b4-0214fc1c8efa','d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','2025-12-06 04:29:11',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-1623916689','d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(286,'4a6d5488-69c7-435a-a371-27ac44db4c86','d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','2025-12-06 04:29:11',NULL,'CREATE','IN_PROGRESS','my_stack','RemoteStackTest-1623916689-my_stack-p7ahpjpey6bm','state changed','OS::Heat::Stack',NULL,58),(287,'d02f5d34-49a9-4fbd-ab87-17c56810316d','3bc956e1-b959-4986-b7dc-f9769960ec42','2025-12-06 04:29:12',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-1623916689-my_stack-p7ahpjpey6bm','3bc956e1-b959-4986-b7dc-f9769960ec42','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(288,'29ac3c5e-77c2-4a7c-9d91-897d3329cd1b','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:12',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-933223569','c7cf0846-c3f2-4edd-850f-92d692c76a3a','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(289,'b1646d55-db5e-4804-b926-e1e44c175ae4','3bc956e1-b959-4986-b7dc-f9769960ec42','2025-12-06 04:29:12',NULL,'CREATE','IN_PROGRESS','random1','RemoteStackTest-1623916689-my_stack-p7ahpjpey6bm-random1-4x7iglkmx6lp','state changed','OS::Heat::RandomString',NULL,NULL),(290,'edd5b7da-5b61-4dfd-8acd-ea3f2137d665','3bc956e1-b959-4986-b7dc-f9769960ec42','2025-12-06 04:29:12',NULL,'CREATE','COMPLETE','random1','RemoteStackTest-1623916689-my_stack-p7ahpjpey6bm-random1-4x7iglkmx6lp','state changed','OS::Heat::RandomString',NULL,NULL),(291,'0093c203-9f63-4aa7-b527-4c5a5f98e282','3bc956e1-b959-4986-b7dc-f9769960ec42','2025-12-06 04:29:12',NULL,'CREATE','COMPLETE','RemoteStackTest-1623916689-my_stack-p7ahpjpey6bm','3bc956e1-b959-4986-b7dc-f9769960ec42','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(292,'ad62c910-5bb2-4a02-b3d3-7d139ced60f7','d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','2025-12-06 04:29:13',NULL,'CREATE','COMPLETE','my_stack','3bc956e1-b959-4986-b7dc-f9769960ec42','state changed','OS::Heat::Stack',NULL,58),(293,'8e2a1afc-66d8-4f78-a018-562c415816cb','d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','2025-12-06 04:29:13',NULL,'CREATE','COMPLETE','RemoteStackTest-1623916689','d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(294,'5c866d5e-78d3-4d9e-9bd5-6ff678004be5','9ae9478a-d759-45df-a4a5-3fff7f6f7405','2025-12-06 04:29:14',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-1540482388','9ae9478a-d759-45df-a4a5-3fff7f6f7405','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(295,'00c57ede-81fc-4347-958f-2cb412176967','c55eb522-6b82-4d4d-876c-d04d555c8e68','2025-12-06 04:29:14',NULL,'DELETE','IN_PROGRESS','ResourcesList-924050756','c55eb522-6b82-4d4d-876c-d04d555c8e68','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(296,'d7acc56d-c6a9-4100-91e7-59da3fedcbf1','c55eb522-6b82-4d4d-876c-d04d555c8e68','2025-12-06 04:29:14',NULL,'DELETE','IN_PROGRESS','test2','ResourcesList-924050756-test2-aulocbuum4jm','state changed','OS::Heat::TestResource',NULL,55),(297,'5f3c3f5c-de67-4c06-ac09-e939d5373028','c55eb522-6b82-4d4d-876c-d04d555c8e68','2025-12-06 04:29:14',NULL,'DELETE','COMPLETE','test2','ResourcesList-924050756-test2-aulocbuum4jm','state changed','OS::Heat::TestResource',NULL,55),(298,'aa72c354-bfdb-45b8-aced-edd05fd6f5d6','9ae9478a-d759-45df-a4a5-3fff7f6f7405','2025-12-06 04:29:14',NULL,'DELETE','IN_PROGRESS','subnet','1232efb9-4a49-4ba3-9a1e-67535d0e0553','state changed','OS::Neutron::Subnet',NULL,57),(299,'a7e00363-b4f1-464b-ab09-d831ec4ec54d','c55eb522-6b82-4d4d-876c-d04d555c8e68','2025-12-06 04:29:14',NULL,'DELETE','IN_PROGRESS','test1','ResourcesList-924050756-test1-2i2p2hnox7ii','state changed','OS::Heat::TestResource',NULL,54),(300,'c25b1ed4-74e9-4f86-86b1-701527e3fd6f','c55eb522-6b82-4d4d-876c-d04d555c8e68','2025-12-06 04:29:14',NULL,'DELETE','COMPLETE','test1','ResourcesList-924050756-test1-2i2p2hnox7ii','state changed','OS::Heat::TestResource',NULL,54),(301,'5ea3f271-c2a0-4095-bc06-d365188e0b1b','c55eb522-6b82-4d4d-876c-d04d555c8e68','2025-12-06 04:29:14',NULL,'DELETE','COMPLETE','ResourcesList-924050756','c55eb522-6b82-4d4d-876c-d04d555c8e68','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(302,'fc370679-6c13-455d-8155-d6850bc39916','9ae9478a-d759-45df-a4a5-3fff7f6f7405','2025-12-06 04:29:14',NULL,'DELETE','COMPLETE','subnet','1232efb9-4a49-4ba3-9a1e-67535d0e0553','state changed','OS::Neutron::Subnet',NULL,57),(303,'edf7332d-c854-4a18-95d5-3df435a31c25','9ae9478a-d759-45df-a4a5-3fff7f6f7405','2025-12-06 04:29:15',NULL,'DELETE','IN_PROGRESS','net','80c15e34-6b1a-4376-8a39-81b329aae54e','state changed','OS::Neutron::Net',NULL,NULL),(304,'3a688ec9-38d6-46f7-9511-44ff97bfe6ef','d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','2025-12-06 04:29:16',NULL,'SUSPEND','IN_PROGRESS','RemoteStackTest-1623916689','d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','Stack SUSPEND started','OS::Heat::Stack',NULL,NULL),(305,'934c79b8-e354-44a5-9448-463450be7e36','d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','2025-12-06 04:29:16',NULL,'SUSPEND','IN_PROGRESS','my_stack','3bc956e1-b959-4986-b7dc-f9769960ec42','state changed','OS::Heat::Stack',NULL,58),(306,'17d72641-dfaf-471c-b8c2-327bc934a369','9ae9478a-d759-45df-a4a5-3fff7f6f7405','2025-12-06 04:29:16',NULL,'DELETE','COMPLETE','net','80c15e34-6b1a-4376-8a39-81b329aae54e','state changed','OS::Neutron::Net',NULL,NULL),(307,'b161158f-a823-434e-b1d0-8e075218f1df','9ae9478a-d759-45df-a4a5-3fff7f6f7405','2025-12-06 04:29:16',NULL,'DELETE','COMPLETE','UpdateSubnetTest-1540482388','9ae9478a-d759-45df-a4a5-3fff7f6f7405','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(308,'897a73fe-c616-4242-a1af-52652ab62723','3bc956e1-b959-4986-b7dc-f9769960ec42','2025-12-06 04:29:16',NULL,'SUSPEND','IN_PROGRESS','RemoteStackTest-1623916689-my_stack-p7ahpjpey6bm','3bc956e1-b959-4986-b7dc-f9769960ec42','Stack SUSPEND started','OS::Heat::Stack',NULL,NULL),(309,'41b3c6de-a51e-4666-adf5-7cf8b2a01038','3bc956e1-b959-4986-b7dc-f9769960ec42','2025-12-06 04:29:16',NULL,'SUSPEND','IN_PROGRESS','random1','RemoteStackTest-1623916689-my_stack-p7ahpjpey6bm-random1-4x7iglkmx6lp','state changed','OS::Heat::RandomString',NULL,NULL),(310,'c873749e-0673-4ae0-a06c-f9970d07b410','3bc956e1-b959-4986-b7dc-f9769960ec42','2025-12-06 04:29:16',NULL,'SUSPEND','COMPLETE','random1','RemoteStackTest-1623916689-my_stack-p7ahpjpey6bm-random1-4x7iglkmx6lp','state changed','OS::Heat::RandomString',NULL,NULL),(311,'0c3d00ab-c6a0-426f-87a9-6034260b3d9f','3bc956e1-b959-4986-b7dc-f9769960ec42','2025-12-06 04:29:16',NULL,'SUSPEND','COMPLETE','RemoteStackTest-1623916689-my_stack-p7ahpjpey6bm','3bc956e1-b959-4986-b7dc-f9769960ec42','Stack SUSPEND completed successfully','OS::Heat::Stack',NULL,NULL),(312,'739c04fa-63eb-4c65-96fe-f773a0ab2876','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:16',NULL,'UPDATE','IN_PROGRESS','trunk','55e2db14-d47c-4bd1-97b3-736465d5be3a','state changed','OS::Neutron::Trunk',NULL,53),(313,'aaeed87c-e8b2-443a-b6b5-c5bd44af34f2','d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','2025-12-06 04:29:16',NULL,'SUSPEND','COMPLETE','my_stack','3bc956e1-b959-4986-b7dc-f9769960ec42','state changed','OS::Heat::Stack',NULL,58),(314,'5acd666c-303d-4bda-ac7c-390328a634c9','d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','2025-12-06 04:29:16',NULL,'SUSPEND','COMPLETE','RemoteStackTest-1623916689','d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','Stack SUSPEND completed successfully','OS::Heat::Stack',NULL,NULL),(315,'79e95150-bced-4c47-965e-418fc85e67a7','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:17',NULL,'UPDATE','COMPLETE','trunk','55e2db14-d47c-4bd1-97b3-736465d5be3a','state changed','OS::Neutron::Trunk',NULL,60),(316,'07ae0843-2980-4f41-9581-dd7651966631','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:18',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-933223569','c7cf0846-c3f2-4edd-850f-92d692c76a3a','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(317,'8e922135-180f-4835-8844-5571ef9fca99','3639c451-9460-4022-b93b-4d6a1e5c83f5','2025-12-06 04:29:20',NULL,'CREATE','IN_PROGRESS','StackTagTest-10561977','3639c451-9460-4022-b93b-4d6a1e5c83f5','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(318,'91352b67-fcb8-4d6f-8111-87084a253d2c','dd29ca5f-f6bb-4235-b0f2-94d3dbf0ed57','2025-12-06 04:29:20',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-18467160','dd29ca5f-f6bb-4235-b0f2-94d3dbf0ed57','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(319,'19681121-439d-4bf6-a00d-b71a7bc616c9','3639c451-9460-4022-b93b-4d6a1e5c83f5','2025-12-06 04:29:20',NULL,'CREATE','IN_PROGRESS','not-used','StackTagTest-10561977-not-used-qjfc2ssuieq7','state changed','OS::Heat::TestResource',NULL,61),(320,'95f7f775-05ff-4ee8-a264-5c24457355da','dd29ca5f-f6bb-4235-b0f2-94d3dbf0ed57','2025-12-06 04:29:20',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-18467160-net-mhx43zam2blo','state changed','OS::Neutron::Net',NULL,NULL),(321,'1d11e26e-0e0c-42b9-942a-9c604da52510','d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','2025-12-06 04:29:20',NULL,'RESUME','IN_PROGRESS','RemoteStackTest-1623916689','d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','Stack RESUME started','OS::Heat::Stack',NULL,NULL),(322,'6838c2dc-7471-4bfe-bd08-4dffd695dffd','d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','2025-12-06 04:29:20',NULL,'RESUME','IN_PROGRESS','my_stack','3bc956e1-b959-4986-b7dc-f9769960ec42','state changed','OS::Heat::Stack',NULL,58),(323,'9754fb81-9247-4c74-8f8e-d0d888a130ee','3bc956e1-b959-4986-b7dc-f9769960ec42','2025-12-06 04:29:21',NULL,'RESUME','IN_PROGRESS','RemoteStackTest-1623916689-my_stack-p7ahpjpey6bm','3bc956e1-b959-4986-b7dc-f9769960ec42','Stack RESUME started','OS::Heat::Stack',NULL,NULL),(324,'f31397d0-91ef-4061-9514-770c91233fdd','3bc956e1-b959-4986-b7dc-f9769960ec42','2025-12-06 04:29:21',NULL,'RESUME','IN_PROGRESS','random1','RemoteStackTest-1623916689-my_stack-p7ahpjpey6bm-random1-4x7iglkmx6lp','state changed','OS::Heat::RandomString',NULL,NULL),(325,'654325cd-0eb6-49b1-bcaf-93dbad65b06f','3bc956e1-b959-4986-b7dc-f9769960ec42','2025-12-06 04:29:21',NULL,'RESUME','COMPLETE','random1','RemoteStackTest-1623916689-my_stack-p7ahpjpey6bm-random1-4x7iglkmx6lp','state changed','OS::Heat::RandomString',NULL,NULL),(326,'59ebeb8a-b318-4b5d-8033-b55955b49c3f','3bc956e1-b959-4986-b7dc-f9769960ec42','2025-12-06 04:29:21',NULL,'RESUME','COMPLETE','RemoteStackTest-1623916689-my_stack-p7ahpjpey6bm','3bc956e1-b959-4986-b7dc-f9769960ec42','Stack RESUME completed successfully','OS::Heat::Stack',NULL,NULL),(327,'2752aca5-025a-43ba-b518-d5edc171380e','d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','2025-12-06 04:29:21',NULL,'RESUME','COMPLETE','my_stack','3bc956e1-b959-4986-b7dc-f9769960ec42','state changed','OS::Heat::Stack',NULL,58),(328,'712b30b0-89d7-4b97-bbfb-78ffc4e1b247','d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','2025-12-06 04:29:21',NULL,'RESUME','COMPLETE','RemoteStackTest-1623916689','d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','Stack RESUME completed successfully','OS::Heat::Stack',NULL,NULL),(329,'79875e5f-a2f3-4c42-a3a6-ecb6b5a42222','dd29ca5f-f6bb-4235-b0f2-94d3dbf0ed57','2025-12-06 04:29:21',NULL,'CREATE','COMPLETE','net','a5081f69-3a49-421b-a85d-cc3a4e934fbf','state changed','OS::Neutron::Net',NULL,NULL),(330,'0bdf4374-df43-4fa1-a781-996f9530a7f3','dd29ca5f-f6bb-4235-b0f2-94d3dbf0ed57','2025-12-06 04:29:21',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-18467160-subnet-4z3v4bzs63a6','state changed','OS::Neutron::Subnet',NULL,62),(331,'1c91c074-a3b8-4ecd-adda-58948bd28b22','dd29ca5f-f6bb-4235-b0f2-94d3dbf0ed57','2025-12-06 04:29:22',NULL,'CREATE','COMPLETE','subnet','f8e24859-3d3b-4eab-8214-2fa502636479','state changed','OS::Neutron::Subnet',NULL,62),(332,'e5344958-20d9-415e-a3c0-1ec17e8c16ae','dd29ca5f-f6bb-4235-b0f2-94d3dbf0ed57','2025-12-06 04:29:22',NULL,'CREATE','COMPLETE','UpdateSubnetTest-18467160','dd29ca5f-f6bb-4235-b0f2-94d3dbf0ed57','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(333,'1fea3d81-a66c-4cad-b019-b3d709d543fb','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:22',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-933223569','c7cf0846-c3f2-4edd-850f-92d692c76a3a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(334,'e6915242-c35b-46e6-a749-cbc8d7fe41e0','3639c451-9460-4022-b93b-4d6a1e5c83f5','2025-12-06 04:29:22',NULL,'CREATE','COMPLETE','not-used','StackTagTest-10561977-not-used-qjfc2ssuieq7','state changed','OS::Heat::TestResource',NULL,61),(335,'464ab3a2-c745-4daf-a549-bafaab8c706f','3639c451-9460-4022-b93b-4d6a1e5c83f5','2025-12-06 04:29:22',NULL,'CREATE','COMPLETE','StackTagTest-10561977','3639c451-9460-4022-b93b-4d6a1e5c83f5','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(336,'ed595e20-d08e-4a4a-a6a2-c99ab5b2f932','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:22',NULL,'DELETE','IN_PROGRESS','trunk','55e2db14-d47c-4bd1-97b3-736465d5be3a','state changed','OS::Neutron::Trunk',NULL,60),(337,'8d8f4e9e-6662-4f0d-91f3-66c5f9091b6a','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:22',NULL,'DELETE','COMPLETE','trunk','55e2db14-d47c-4bd1-97b3-736465d5be3a','state changed','OS::Neutron::Trunk',NULL,60),(338,'c4a8f34a-32c4-4230-8013-b5ff6b09ecc1','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:22',NULL,'DELETE','IN_PROGRESS','sub_port_one','7a3a13fd-e6c2-49ac-b1b1-720938360e30','state changed','OS::Neutron::Port',NULL,56),(339,'4b8036c1-abd8-4f84-9147-6242070a98ae','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:22',NULL,'DELETE','IN_PROGRESS','parent_port','c0d0ba86-25cf-40e3-a91a-6f2dde80943d','state changed','OS::Neutron::Port',NULL,49),(340,'4159938e-dc8c-4eea-ae9f-223bcc713b74','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:23',NULL,'DELETE','COMPLETE','sub_port_one','7a3a13fd-e6c2-49ac-b1b1-720938360e30','state changed','OS::Neutron::Port',NULL,56),(341,'f8511257-13f4-44d3-87b7-e7b0a7f33a99','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:23',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','83486500-6a53-4e38-ab20-4dcfc7c12f9d','state changed','OS::Neutron::Subnet',NULL,50),(342,'204c4058-e866-4306-8e2c-643913793140','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:25',NULL,'DELETE','IN_PROGRESS','sub_port_two','0ab50f19-a89f-4923-9117-34c3dd710693','state changed','OS::Neutron::Port',NULL,51),(343,'ef47e5c9-be71-4c00-9f28-a910f0f2ae28','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:25',NULL,'DELETE','COMPLETE','parent_port','c0d0ba86-25cf-40e3-a91a-6f2dde80943d','state changed','OS::Neutron::Port',NULL,49),(344,'ba52b783-b1d5-4883-b345-a308ad45cefc','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:25',NULL,'DELETE','IN_PROGRESS','parent_subnet','82a5617c-6b9a-46af-8276-f7e6f42ca165','state changed','OS::Neutron::Subnet',NULL,47),(345,'0666c11a-28ef-4daf-9f6c-a52460d1dc92','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:25',NULL,'DELETE','COMPLETE','trunk_subnet_one','83486500-6a53-4e38-ab20-4dcfc7c12f9d','state changed','OS::Neutron::Subnet',NULL,50),(346,'cb327575-de5d-4cda-8217-ad4578acfc18','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:25',NULL,'DELETE','IN_PROGRESS','trunk_net_one','e5f69a60-15c4-438f-9c59-671c43e59660','state changed','OS::Neutron::Net',NULL,NULL),(347,'be163d0e-9918-42fa-aef3-4f898b56f69b','3639c451-9460-4022-b93b-4d6a1e5c83f5','2025-12-06 04:29:25',NULL,'DELETE','IN_PROGRESS','StackTagTest-10561977','3639c451-9460-4022-b93b-4d6a1e5c83f5','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(348,'3981db14-50c6-474b-98a4-81dcb09f6e36','3639c451-9460-4022-b93b-4d6a1e5c83f5','2025-12-06 04:29:25',NULL,'DELETE','IN_PROGRESS','not-used','StackTagTest-10561977-not-used-qjfc2ssuieq7','state changed','OS::Heat::TestResource',NULL,61),(349,'c599d568-d8c1-4cba-9bad-a8902a869e5d','d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','2025-12-06 04:29:26',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-1623916689','d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(350,'1000297e-e4bb-4168-8038-f1887c76e140','d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','2025-12-06 04:29:26',NULL,'DELETE','IN_PROGRESS','my_stack','3bc956e1-b959-4986-b7dc-f9769960ec42','state changed','OS::Heat::Stack',NULL,58),(351,'ba0a8051-f329-4806-be41-5acd6d955b08','3bc956e1-b959-4986-b7dc-f9769960ec42','2025-12-06 04:29:26',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-1623916689-my_stack-p7ahpjpey6bm','3bc956e1-b959-4986-b7dc-f9769960ec42','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(352,'e2b68b1c-30e7-4e32-9a09-4326e49d074a','3bc956e1-b959-4986-b7dc-f9769960ec42','2025-12-06 04:29:26',NULL,'DELETE','IN_PROGRESS','random1','RemoteStackTest-1623916689-my_stack-p7ahpjpey6bm-random1-4x7iglkmx6lp','state changed','OS::Heat::RandomString',NULL,NULL),(353,'55ec45c2-ba4e-4bf2-8756-12b1d6b66941','3bc956e1-b959-4986-b7dc-f9769960ec42','2025-12-06 04:29:26',NULL,'DELETE','COMPLETE','random1','RemoteStackTest-1623916689-my_stack-p7ahpjpey6bm-random1-4x7iglkmx6lp','state changed','OS::Heat::RandomString',NULL,NULL),(354,'f2406fe1-94e7-495b-900c-00d0f316949d','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:26',NULL,'DELETE','COMPLETE','parent_subnet','82a5617c-6b9a-46af-8276-f7e6f42ca165','state changed','OS::Neutron::Subnet',NULL,47),(355,'ac5ffaa1-97b1-4431-9a4b-4440ce0d97a4','3bc956e1-b959-4986-b7dc-f9769960ec42','2025-12-06 04:29:26',NULL,'DELETE','COMPLETE','RemoteStackTest-1623916689-my_stack-p7ahpjpey6bm','3bc956e1-b959-4986-b7dc-f9769960ec42','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(356,'29b294ed-c472-422d-a6c3-f588e0cefa8a','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:26',NULL,'DELETE','COMPLETE','sub_port_two','0ab50f19-a89f-4923-9117-34c3dd710693','state changed','OS::Neutron::Port',NULL,51),(357,'9ab5163b-4e18-4adb-a6b0-2b094be2dbed','dd29ca5f-f6bb-4235-b0f2-94d3dbf0ed57','2025-12-06 04:29:26',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-18467160','dd29ca5f-f6bb-4235-b0f2-94d3dbf0ed57','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(358,'98acdf3f-8a46-40b7-9367-a27187f43ee4','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:26',NULL,'DELETE','IN_PROGRESS','parent_net','9707ea6e-e22c-461c-a053-f0f3c46d6ef5','state changed','OS::Neutron::Net',NULL,NULL),(359,'f7db95cb-6f87-4990-a7cb-dfd68c63ee63','d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','2025-12-06 04:29:26',NULL,'DELETE','COMPLETE','my_stack','3bc956e1-b959-4986-b7dc-f9769960ec42','state changed','OS::Heat::Stack',NULL,58),(360,'470fe612-d91a-4916-ae87-3b17a670669d','d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','2025-12-06 04:29:26',NULL,'DELETE','COMPLETE','RemoteStackTest-1623916689','d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(361,'0548af43-424a-4ed2-9d08-c26641223096','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:26',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','6f41851c-6349-41d3-89c1-5006adc2692c','state changed','OS::Neutron::Subnet',NULL,48),(362,'dbd76756-5b2e-43bb-a336-1f3d7a0962a2','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:26',NULL,'DELETE','COMPLETE','trunk_net_one','e5f69a60-15c4-438f-9c59-671c43e59660','state changed','OS::Neutron::Net',NULL,NULL),(363,'c506ff22-2ff8-4bc5-a72f-28037ba47827','dd29ca5f-f6bb-4235-b0f2-94d3dbf0ed57','2025-12-06 04:29:26',NULL,'UPDATE','IN_PROGRESS','subnet','f8e24859-3d3b-4eab-8214-2fa502636479','state changed','OS::Neutron::Subnet',NULL,62),(364,'d89f17b0-d900-4bca-917f-b8477b114407','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:27',NULL,'DELETE','COMPLETE','trunk_subnet_two','6f41851c-6349-41d3-89c1-5006adc2692c','state changed','OS::Neutron::Subnet',NULL,48),(365,'e5f09803-579c-4001-8b8a-b4c7553fbdc1','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:27',NULL,'DELETE','IN_PROGRESS','trunk_net_two','c779bd81-3bbe-47e2-a683-dbba250402e4','state changed','OS::Neutron::Net',NULL,NULL),(366,'07ca651e-bf9c-4ae6-a7a1-827fa0092163','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:27',NULL,'DELETE','COMPLETE','parent_net','9707ea6e-e22c-461c-a053-f0f3c46d6ef5','state changed','OS::Neutron::Net',NULL,NULL),(367,'fce29f83-17bc-48c4-b3f1-7bf9933e8563','3639c451-9460-4022-b93b-4d6a1e5c83f5','2025-12-06 04:29:27',NULL,'DELETE','COMPLETE','not-used','StackTagTest-10561977-not-used-qjfc2ssuieq7','state changed','OS::Heat::TestResource',NULL,61),(368,'0cf226a8-b3c8-4525-bd63-0899d02a08af','3639c451-9460-4022-b93b-4d6a1e5c83f5','2025-12-06 04:29:27',NULL,'DELETE','COMPLETE','StackTagTest-10561977','3639c451-9460-4022-b93b-4d6a1e5c83f5','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(369,'bf6bcc9b-a28e-444b-9994-0c265b1de71f','dd29ca5f-f6bb-4235-b0f2-94d3dbf0ed57','2025-12-06 04:29:28',NULL,'UPDATE','COMPLETE','subnet','f8e24859-3d3b-4eab-8214-2fa502636479','state changed','OS::Neutron::Subnet',NULL,65),(370,'ba63ab77-861d-4fec-9b16-20da6b6c36f2','dd29ca5f-f6bb-4235-b0f2-94d3dbf0ed57','2025-12-06 04:29:28',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-18467160','dd29ca5f-f6bb-4235-b0f2-94d3dbf0ed57','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(371,'bd0c315b-8ba3-4188-a578-d919da2ce801','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:28',NULL,'DELETE','COMPLETE','trunk_net_two','c779bd81-3bbe-47e2-a683-dbba250402e4','state changed','OS::Neutron::Net',NULL,NULL),(372,'4a9c04bb-2c63-411a-bc6a-b45761fb7fea','c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:28',NULL,'DELETE','COMPLETE','UpdateTrunkTest-933223569','c7cf0846-c3f2-4edd-850f-92d692c76a3a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(373,'34554ffc-b54e-455a-827b-8361b6f32427','78b23705-4c35-4970-95bc-2fe00169e605','2025-12-06 04:29:32',NULL,'CREATE','IN_PROGRESS','StackTagTest-1092282062','78b23705-4c35-4970-95bc-2fe00169e605','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(374,'cf4f9780-ae75-4bcb-9c79-1594f33c8a2d','78b23705-4c35-4970-95bc-2fe00169e605','2025-12-06 04:29:32',NULL,'CREATE','IN_PROGRESS','not-used','StackTagTest-1092282062-not-used-wi7xx5gqooj2','state changed','OS::Heat::TestResource',NULL,67),(375,'48a1ba5d-896c-4eaf-b1a0-911348134d5f','dd29ca5f-f6bb-4235-b0f2-94d3dbf0ed57','2025-12-06 04:29:32',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-18467160','dd29ca5f-f6bb-4235-b0f2-94d3dbf0ed57','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(376,'089bf8c5-2e6a-47aa-bbdb-46310ab3d70f','dd29ca5f-f6bb-4235-b0f2-94d3dbf0ed57','2025-12-06 04:29:32',NULL,'DELETE','IN_PROGRESS','subnet','f8e24859-3d3b-4eab-8214-2fa502636479','state changed','OS::Neutron::Subnet',NULL,65),(377,'39995f60-1657-489e-b235-c5f2646de3f4','006ba657-ef38-4f76-8a80-dc885566b284','2025-12-06 04:29:32',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-341818267','006ba657-ef38-4f76-8a80-dc885566b284','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(378,'df5053b5-32dd-4686-b706-28ab69003dd3','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:32',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-1006298183','758fa67e-b396-4351-9dc2-6517d90edfcb','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(379,'cbdac875-cbf7-4c90-bcb6-9e0b4d36606b','006ba657-ef38-4f76-8a80-dc885566b284','2025-12-06 04:29:32',NULL,'CREATE','IN_PROGRESS','my_stack','RemoteStackTest-341818267-my_stack-77mtmk7njbfp','state changed','OS::Heat::Stack',NULL,68),(380,'b0b55ff3-2b54-4e22-a916-06d0e6d72c35','dd29ca5f-f6bb-4235-b0f2-94d3dbf0ed57','2025-12-06 04:29:33',NULL,'DELETE','COMPLETE','subnet','f8e24859-3d3b-4eab-8214-2fa502636479','state changed','OS::Neutron::Subnet',NULL,65),(381,'c6db6022-bcb7-41fc-9700-ce4e602e2d66','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:34',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-1006298183-parent_net-vgfbytofrjmt','state changed','OS::Neutron::Net',NULL,NULL),(382,'eb17c0d9-e67d-4295-b860-26af36d995fc','dd29ca5f-f6bb-4235-b0f2-94d3dbf0ed57','2025-12-06 04:29:34',NULL,'DELETE','IN_PROGRESS','net','a5081f69-3a49-421b-a85d-cc3a4e934fbf','state changed','OS::Neutron::Net',NULL,NULL),(383,'fed02b16-b8f0-4634-abda-1727e1d96909','78b23705-4c35-4970-95bc-2fe00169e605','2025-12-06 04:29:34',NULL,'CREATE','COMPLETE','not-used','StackTagTest-1092282062-not-used-wi7xx5gqooj2','state changed','OS::Heat::TestResource',NULL,67),(384,'b6bd28f3-678a-41e8-ad4a-af7730b62dee','78b23705-4c35-4970-95bc-2fe00169e605','2025-12-06 04:29:34',NULL,'CREATE','COMPLETE','StackTagTest-1092282062','78b23705-4c35-4970-95bc-2fe00169e605','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(385,'67e53c5d-e553-4e75-9b2a-ca5d15e3a2d2','def15797-6bf9-445e-9c40-2859425d821c','2025-12-06 04:29:34',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-341818267-my_stack-77mtmk7njbfp','def15797-6bf9-445e-9c40-2859425d821c','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(386,'0d5ecbf6-e7d4-4a4a-944a-75ce73843fb5','def15797-6bf9-445e-9c40-2859425d821c','2025-12-06 04:29:34',NULL,'CREATE','IN_PROGRESS','random1','RemoteStackTest-341818267-my_stack-77mtmk7njbfp-random1-r2j55ckq6diw','state changed','OS::Heat::RandomString',NULL,NULL),(387,'06705c76-11da-4fe3-9aca-5aa08f3e58b0','def15797-6bf9-445e-9c40-2859425d821c','2025-12-06 04:29:34',NULL,'CREATE','COMPLETE','random1','RemoteStackTest-341818267-my_stack-77mtmk7njbfp-random1-r2j55ckq6diw','state changed','OS::Heat::RandomString',NULL,NULL),(388,'af51cec8-d5fb-4018-a9e4-f5917ead1f45','def15797-6bf9-445e-9c40-2859425d821c','2025-12-06 04:29:34',NULL,'CREATE','COMPLETE','RemoteStackTest-341818267-my_stack-77mtmk7njbfp','def15797-6bf9-445e-9c40-2859425d821c','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(389,'e38403f8-1065-4b68-a75b-ab92b01a415e','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:35',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-1006298183-trunk_net_two-y7s2okv6xyfy','state changed','OS::Neutron::Net',NULL,NULL),(390,'272a3555-fe37-411b-9e47-d47afd7dbac2','006ba657-ef38-4f76-8a80-dc885566b284','2025-12-06 04:29:35',NULL,'CREATE','COMPLETE','my_stack','def15797-6bf9-445e-9c40-2859425d821c','state changed','OS::Heat::Stack',NULL,68),(391,'a992fa62-e8ea-4477-9c39-4678aef7b722','006ba657-ef38-4f76-8a80-dc885566b284','2025-12-06 04:29:35',NULL,'CREATE','COMPLETE','RemoteStackTest-341818267','006ba657-ef38-4f76-8a80-dc885566b284','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(392,'47313038-f7f4-4b71-b7e9-dd7402f0b5b1','dd29ca5f-f6bb-4235-b0f2-94d3dbf0ed57','2025-12-06 04:29:35',NULL,'DELETE','COMPLETE','net','a5081f69-3a49-421b-a85d-cc3a4e934fbf','state changed','OS::Neutron::Net',NULL,NULL),(393,'42b039a9-36ba-4e60-8b22-d599ab601038','dd29ca5f-f6bb-4235-b0f2-94d3dbf0ed57','2025-12-06 04:29:35',NULL,'DELETE','COMPLETE','UpdateSubnetTest-18467160','dd29ca5f-f6bb-4235-b0f2-94d3dbf0ed57','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(394,'cfe699ea-e92f-4c07-9a9d-ad7ea7d2067d','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:35',NULL,'CREATE','COMPLETE','parent_net','9100ef72-d035-426a-81f7-e937ae98d3ed','state changed','OS::Neutron::Net',NULL,NULL),(395,'5a17391f-5bf8-4017-914e-1b276e063d57','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:35',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-1006298183-parent_subnet-v6ndbsxvvx3b','state changed','OS::Neutron::Subnet',NULL,69),(396,'a2efba99-6457-48e1-93f8-66a6f81a9597','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:36',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-1006298183-trunk_net_one-hobhva3mwnjv','state changed','OS::Neutron::Net',NULL,NULL),(397,'75b1f170-6edd-4bf0-8909-10e83b8616a7','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:36',NULL,'CREATE','COMPLETE','trunk_net_two','f94d8a47-757e-488a-a00a-2913455b40d7','state changed','OS::Neutron::Net',NULL,NULL),(398,'4839ccb8-67d3-495f-8106-ae8db737dd79','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:37',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-1006298183-trunk_subnet_two-wncrndipfrtd','state changed','OS::Neutron::Subnet',NULL,70),(399,'e2de6b6b-3e01-4202-b7a8-fce7ba92d58b','78b23705-4c35-4970-95bc-2fe00169e605','2025-12-06 04:29:37',NULL,'UPDATE','IN_PROGRESS','StackTagTest-1092282062','78b23705-4c35-4970-95bc-2fe00169e605','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(400,'3559a1f1-be25-454f-9a7a-62ece0c3daf2','78b23705-4c35-4970-95bc-2fe00169e605','2025-12-06 04:29:38',NULL,'UPDATE','IN_PROGRESS','not-used','StackTagTest-1092282062-not-used-wi7xx5gqooj2','state changed','OS::Heat::TestResource',NULL,67),(401,'40f275ff-914c-4f86-bf04-fc66409f5a85','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:38',NULL,'CREATE','COMPLETE','trunk_net_one','94d82ad2-c26e-4f23-9f27-89af726ef2e8','state changed','OS::Neutron::Net',NULL,NULL),(402,'c8ecc585-8da7-4cf7-96f2-1b5948a9b1b9','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:38',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-1006298183-trunk_subnet_one-u6gpl6uend7d','state changed','OS::Neutron::Subnet',NULL,71),(403,'fcfa5c35-f2aa-4088-83f5-9ed547a386fe','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:38',NULL,'CREATE','COMPLETE','parent_subnet','26309d79-a62e-4a15-862a-900a8363def8','state changed','OS::Neutron::Subnet',NULL,69),(404,'e11a74f2-6840-4275-9929-b92f0523f997','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:38',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-1006298183-parent_port-z3mlyg2jazbl','state changed','OS::Neutron::Port',NULL,72),(405,'7757fcd9-1e27-471e-b3ab-23ced1146994','c9a600fe-447f-4044-829d-9cbdaf912d22','2025-12-06 04:29:39',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-254983957','c9a600fe-447f-4044-829d-9cbdaf912d22','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(406,'7585c079-ff9e-4a17-938b-95446123e131','c9a600fe-447f-4044-829d-9cbdaf912d22','2025-12-06 04:29:39',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-254983957-net-mdyvzucacb4r','state changed','OS::Neutron::Net',NULL,NULL),(407,'947edcf3-a183-47f2-815a-cac91a53874e','78b23705-4c35-4970-95bc-2fe00169e605','2025-12-06 04:29:40',NULL,'UPDATE','COMPLETE','not-used','StackTagTest-1092282062-not-used-wi7xx5gqooj2','state changed','OS::Heat::TestResource',NULL,73),(408,'67d8453b-26f4-4f66-bad6-b1c9e762fb08','006ba657-ef38-4f76-8a80-dc885566b284','2025-12-06 04:29:40',NULL,'UPDATE','IN_PROGRESS','RemoteStackTest-341818267','006ba657-ef38-4f76-8a80-dc885566b284','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(409,'79731a5c-c08a-40fa-8e34-fae335a3dd55','78b23705-4c35-4970-95bc-2fe00169e605','2025-12-06 04:29:40',NULL,'UPDATE','COMPLETE','StackTagTest-1092282062','78b23705-4c35-4970-95bc-2fe00169e605','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(410,'6429603d-262c-4b57-8600-bba5fd89b39d','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:40',NULL,'CREATE','COMPLETE','trunk_subnet_two','4dc5bfe3-a0dd-4e80-81ef-9eb735682bbc','state changed','OS::Neutron::Subnet',NULL,70),(411,'00c01c83-9d32-4b36-9a59-faddb34f4778','006ba657-ef38-4f76-8a80-dc885566b284','2025-12-06 04:29:40',NULL,'UPDATE','IN_PROGRESS','my_stack','def15797-6bf9-445e-9c40-2859425d821c','state changed','OS::Heat::Stack',NULL,68),(412,'c9e1e870-5cbd-41d3-8463-81c20fd9a82c','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:40',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-1006298183-sub_port_two-hns64vtjjfzg','state changed','OS::Neutron::Port',NULL,74),(413,'7ef09fa4-7348-42f1-abff-6fc4add889aa','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:41',NULL,'CREATE','COMPLETE','trunk_subnet_one','0a33f110-e0cb-4db1-a8c5-516b8d5341a8','state changed','OS::Neutron::Subnet',NULL,71),(414,'b7e4152b-82d2-46aa-9acd-3b91fed1b988','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:41',NULL,'CREATE','COMPLETE','parent_port','e0d2b829-65ef-44a0-9891-0a2dcf3923fe','state changed','OS::Neutron::Port',NULL,72),(415,'8c3144a6-1a6a-48c3-9b55-f00ee9a4a0b1','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:41',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-1006298183-sub_port_one-or7znlwjambx','state changed','OS::Neutron::Port',NULL,75),(416,'ae59db13-4bb1-4a59-b321-ec10ce177959','def15797-6bf9-445e-9c40-2859425d821c','2025-12-06 04:29:41',NULL,'UPDATE','IN_PROGRESS','RemoteStackTest-341818267-my_stack-77mtmk7njbfp','def15797-6bf9-445e-9c40-2859425d821c','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(417,'e45cd3d4-c206-43cb-8cc8-95dab5c348bf','c9a600fe-447f-4044-829d-9cbdaf912d22','2025-12-06 04:29:41',NULL,'CREATE','COMPLETE','net','f61a1657-cb93-405a-9870-0750081f667c','state changed','OS::Neutron::Net',NULL,NULL),(418,'df60a87d-974e-4d9c-afc3-7d3c8a8cb7ba','c9a600fe-447f-4044-829d-9cbdaf912d22','2025-12-06 04:29:41',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-254983957-subnet-mqd66gsjtbvb','state changed','OS::Neutron::Subnet',NULL,76),(419,'1813d23c-0085-462c-b70e-a41300ed32bc','def15797-6bf9-445e-9c40-2859425d821c','2025-12-06 04:29:41',NULL,'DELETE','IN_PROGRESS','random1','RemoteStackTest-341818267-my_stack-77mtmk7njbfp-random1-r2j55ckq6diw','state changed','OS::Heat::RandomString',NULL,NULL),(420,'c694e6b1-90e9-4b9b-afb8-92770f04306d','def15797-6bf9-445e-9c40-2859425d821c','2025-12-06 04:29:42',NULL,'DELETE','COMPLETE','random1','RemoteStackTest-341818267-my_stack-77mtmk7njbfp-random1-r2j55ckq6diw','state changed','OS::Heat::RandomString',NULL,NULL),(421,'3cf8ba49-682d-4837-8718-5dbc742995e1','def15797-6bf9-445e-9c40-2859425d821c','2025-12-06 04:29:42',NULL,'CREATE','IN_PROGRESS','random2','RemoteStackTest-341818267-my_stack-77mtmk7njbfp-random2-uio4vb7db4ez','state changed','OS::Heat::RandomString',NULL,NULL),(422,'8f85c036-7f47-4d1c-81b9-d9e1af94b47c','def15797-6bf9-445e-9c40-2859425d821c','2025-12-06 04:29:42',NULL,'CREATE','COMPLETE','random2','RemoteStackTest-341818267-my_stack-77mtmk7njbfp-random2-uio4vb7db4ez','state changed','OS::Heat::RandomString',NULL,NULL),(423,'3576cdee-0b28-4d9f-b9cc-22f2ff0df0a2','def15797-6bf9-445e-9c40-2859425d821c','2025-12-06 04:29:43',NULL,'UPDATE','COMPLETE','RemoteStackTest-341818267-my_stack-77mtmk7njbfp','def15797-6bf9-445e-9c40-2859425d821c','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(424,'acc9bb33-f717-44a7-9ab9-0bee6963219b','78b23705-4c35-4970-95bc-2fe00169e605','2025-12-06 04:29:43',NULL,'UPDATE','IN_PROGRESS','StackTagTest-1092282062','78b23705-4c35-4970-95bc-2fe00169e605','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(425,'d85ecad1-b6cd-4616-be14-baf291f702c6','78b23705-4c35-4970-95bc-2fe00169e605','2025-12-06 04:29:43',NULL,'UPDATE','IN_PROGRESS','not-used','StackTagTest-1092282062-not-used-wi7xx5gqooj2','state changed','OS::Heat::TestResource',NULL,73),(426,'39e626b6-1cf3-4314-a043-2d992d2ef3f9','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:43',NULL,'CREATE','COMPLETE','sub_port_two','b4093632-b1df-4dc0-9575-14a42ea7f058','state changed','OS::Neutron::Port',NULL,74),(427,'147562b6-c79e-4355-a91e-aa421454e95d','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:43',NULL,'CREATE','COMPLETE','sub_port_one','b79cbe40-4353-40db-9cac-10116b6d738e','state changed','OS::Neutron::Port',NULL,75),(428,'e368e091-02ab-48a3-88b1-fc216181531d','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:43',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-1006298183-trunk-7hasxnmymoe5','state changed','OS::Neutron::Trunk',NULL,77),(429,'9d2c7a1d-50fc-4977-aa07-3643508db585','006ba657-ef38-4f76-8a80-dc885566b284','2025-12-06 04:29:43',NULL,'UPDATE','COMPLETE','my_stack','def15797-6bf9-445e-9c40-2859425d821c','state changed','OS::Heat::Stack',NULL,78),(430,'c123335d-f167-46e7-a699-fc92a085ab95','006ba657-ef38-4f76-8a80-dc885566b284','2025-12-06 04:29:43',NULL,'UPDATE','COMPLETE','RemoteStackTest-341818267','006ba657-ef38-4f76-8a80-dc885566b284','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(431,'54cdd235-0644-4675-b07b-6be30a4f0a45','c9a600fe-447f-4044-829d-9cbdaf912d22','2025-12-06 04:29:44',NULL,'CREATE','COMPLETE','subnet','dbd06594-0408-46e7-a4e6-aa5c6321ab1e','state changed','OS::Neutron::Subnet',NULL,76),(432,'ba86f903-eff3-4a54-ae7e-5ec34d1b758a','c9a600fe-447f-4044-829d-9cbdaf912d22','2025-12-06 04:29:44',NULL,'CREATE','COMPLETE','UpdateSubnetTest-254983957','c9a600fe-447f-4044-829d-9cbdaf912d22','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(433,'9c7323a1-80ba-450e-9f03-73ff53eb9eef','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:45',NULL,'CREATE','COMPLETE','trunk','c8ec44c1-4e44-42af-b0f7-c94f4339298b','state changed','OS::Neutron::Trunk',NULL,77),(434,'5855346b-a576-4a26-bec8-6e5b347da4e9','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:45',NULL,'CREATE','COMPLETE','UpdateTrunkTest-1006298183','758fa67e-b396-4351-9dc2-6517d90edfcb','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(435,'bb37d43d-660a-4f59-984f-55f8e85617f2','78b23705-4c35-4970-95bc-2fe00169e605','2025-12-06 04:29:45',NULL,'UPDATE','COMPLETE','not-used','StackTagTest-1092282062-not-used-wi7xx5gqooj2','state changed','OS::Heat::TestResource',NULL,79),(436,'dbf3d938-40a4-4d06-a2e2-e884e83e32f8','78b23705-4c35-4970-95bc-2fe00169e605','2025-12-06 04:29:45',NULL,'UPDATE','COMPLETE','StackTagTest-1092282062','78b23705-4c35-4970-95bc-2fe00169e605','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(437,'7141cb7c-df2e-45b4-9468-423f790c8510','006ba657-ef38-4f76-8a80-dc885566b284','2025-12-06 04:29:45',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-341818267','006ba657-ef38-4f76-8a80-dc885566b284','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(438,'b2cea330-221d-40cf-8a0c-c9951a4b8ee7','006ba657-ef38-4f76-8a80-dc885566b284','2025-12-06 04:29:45',NULL,'DELETE','IN_PROGRESS','my_stack','def15797-6bf9-445e-9c40-2859425d821c','state changed','OS::Heat::Stack',NULL,78),(439,'f7a5429f-59a1-4cde-9a68-abb57b52a117','def15797-6bf9-445e-9c40-2859425d821c','2025-12-06 04:29:45',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-341818267-my_stack-77mtmk7njbfp','def15797-6bf9-445e-9c40-2859425d821c','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(440,'a03875e7-5eac-4120-8238-012af6ed733b','def15797-6bf9-445e-9c40-2859425d821c','2025-12-06 04:29:45',NULL,'DELETE','IN_PROGRESS','random2','RemoteStackTest-341818267-my_stack-77mtmk7njbfp-random2-uio4vb7db4ez','state changed','OS::Heat::RandomString',NULL,NULL),(441,'cbe19bb7-a62a-42c5-bd56-b84cf0ae3b86','def15797-6bf9-445e-9c40-2859425d821c','2025-12-06 04:29:45',NULL,'DELETE','COMPLETE','random2','RemoteStackTest-341818267-my_stack-77mtmk7njbfp-random2-uio4vb7db4ez','state changed','OS::Heat::RandomString',NULL,NULL),(442,'c1e486bc-e596-4e5c-bc86-583750e9b932','def15797-6bf9-445e-9c40-2859425d821c','2025-12-06 04:29:45',NULL,'DELETE','COMPLETE','RemoteStackTest-341818267-my_stack-77mtmk7njbfp','def15797-6bf9-445e-9c40-2859425d821c','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(443,'f76f6233-d120-499a-81b5-28a4f65efd05','006ba657-ef38-4f76-8a80-dc885566b284','2025-12-06 04:29:45',NULL,'DELETE','COMPLETE','my_stack','def15797-6bf9-445e-9c40-2859425d821c','state changed','OS::Heat::Stack',NULL,78),(444,'63280e31-5f21-4e04-a617-83990faa9150','006ba657-ef38-4f76-8a80-dc885566b284','2025-12-06 04:29:45',NULL,'DELETE','COMPLETE','RemoteStackTest-341818267','006ba657-ef38-4f76-8a80-dc885566b284','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(445,'9db4c030-557e-4a92-abc8-6b11547a19a7','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:47',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-1006298183','758fa67e-b396-4351-9dc2-6517d90edfcb','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(446,'c5a17944-e360-4434-b986-2394fbbde06f','78b23705-4c35-4970-95bc-2fe00169e605','2025-12-06 04:29:47',NULL,'DELETE','IN_PROGRESS','StackTagTest-1092282062','78b23705-4c35-4970-95bc-2fe00169e605','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(447,'de3e9131-807d-4ca4-bf1f-c9f38013b1ea','78b23705-4c35-4970-95bc-2fe00169e605','2025-12-06 04:29:47',NULL,'DELETE','IN_PROGRESS','not-used','StackTagTest-1092282062-not-used-wi7xx5gqooj2','state changed','OS::Heat::TestResource',NULL,79),(448,'143d6cfc-a6b3-4d6d-ac10-05d70374cce1','78b23705-4c35-4970-95bc-2fe00169e605','2025-12-06 04:29:50',NULL,'DELETE','COMPLETE','not-used','StackTagTest-1092282062-not-used-wi7xx5gqooj2','state changed','OS::Heat::TestResource',NULL,79),(449,'e60fab8d-8563-411c-9274-f9682a7e59a4','c9a600fe-447f-4044-829d-9cbdaf912d22','2025-12-06 04:29:50',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-254983957','c9a600fe-447f-4044-829d-9cbdaf912d22','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(450,'8648093a-de02-404e-a763-3d2a83961fe7','78b23705-4c35-4970-95bc-2fe00169e605','2025-12-06 04:29:50',NULL,'DELETE','COMPLETE','StackTagTest-1092282062','78b23705-4c35-4970-95bc-2fe00169e605','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(451,'9fad98b5-1929-4934-ba2a-7860bc0064b5','c9a600fe-447f-4044-829d-9cbdaf912d22','2025-12-06 04:29:51',NULL,'UPDATE','IN_PROGRESS','subnet','dbd06594-0408-46e7-a4e6-aa5c6321ab1e','state changed','OS::Neutron::Subnet',NULL,76),(452,'ab776593-c7f1-44aa-b1d3-a4af19728f1a','6ad69760-d81b-4153-a8cf-d75a571a76ee','2025-12-06 04:29:52',NULL,'CREATE','IN_PROGRESS','StackEventsTest-347241810','6ad69760-d81b-4153-a8cf-d75a571a76ee','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(453,'54395dae-d964-4cac-99c2-39b69848d895','6ad69760-d81b-4153-a8cf-d75a571a76ee','2025-12-06 04:29:52',NULL,'CREATE','IN_PROGRESS','test_resource','StackEventsTest-347241810-test_resource-paufa56safnm','state changed','OS::Heat::TestResource',NULL,81),(454,'ee831ee1-e7cf-4d1a-a263-a70a0a1cf38a','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:52',NULL,'UPDATE','IN_PROGRESS','trunk','c8ec44c1-4e44-42af-b0f7-c94f4339298b','state changed','OS::Neutron::Trunk',NULL,77),(455,'eba4d0b5-888a-43ee-93ba-18a8d4962c25','6ad69760-d81b-4153-a8cf-d75a571a76ee','2025-12-06 04:29:52',NULL,'CREATE','COMPLETE','test_resource','StackEventsTest-347241810-test_resource-paufa56safnm','state changed','OS::Heat::TestResource',NULL,81),(456,'8e112b2b-3b1e-4e64-9876-4b15156537f9','6ad69760-d81b-4153-a8cf-d75a571a76ee','2025-12-06 04:29:52',NULL,'CREATE','COMPLETE','StackEventsTest-347241810','6ad69760-d81b-4153-a8cf-d75a571a76ee','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(457,'e86bbd78-a824-4113-8b21-03c2413bcd6d','c9a600fe-447f-4044-829d-9cbdaf912d22','2025-12-06 04:29:52',NULL,'UPDATE','COMPLETE','subnet','dbd06594-0408-46e7-a4e6-aa5c6321ab1e','state changed','OS::Neutron::Subnet',NULL,82),(458,'b038211f-b8c1-4e70-acd8-4c97ebf5cc59','c9a600fe-447f-4044-829d-9cbdaf912d22','2025-12-06 04:29:52',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-254983957','c9a600fe-447f-4044-829d-9cbdaf912d22','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(459,'85377b91-ec2b-4a68-a5d4-1e5f0097d0de','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:53',NULL,'UPDATE','COMPLETE','trunk','c8ec44c1-4e44-42af-b0f7-c94f4339298b','state changed','OS::Neutron::Trunk',NULL,83),(460,'2d1267ac-a1e7-4b92-805e-10bd78fa9f38','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:54',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-1006298183','758fa67e-b396-4351-9dc2-6517d90edfcb','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(461,'ab672245-0d9e-4855-916b-f09ac3b4b6f8','c9a600fe-447f-4044-829d-9cbdaf912d22','2025-12-06 04:29:55',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-254983957','c9a600fe-447f-4044-829d-9cbdaf912d22','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(462,'6359570f-f7a3-4dfd-ae3a-1cd461cae96d','c9a600fe-447f-4044-829d-9cbdaf912d22','2025-12-06 04:29:56',NULL,'DELETE','IN_PROGRESS','subnet','dbd06594-0408-46e7-a4e6-aa5c6321ab1e','state changed','OS::Neutron::Subnet',NULL,82),(463,'3eb8bfaf-cc2b-47bf-b925-50f1b3b2da45','6ad69760-d81b-4153-a8cf-d75a571a76ee','2025-12-06 04:29:56',NULL,'DELETE','IN_PROGRESS','StackEventsTest-347241810','6ad69760-d81b-4153-a8cf-d75a571a76ee','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(464,'a2866d60-64a6-48bb-9f07-d4f75617d326','6ad69760-d81b-4153-a8cf-d75a571a76ee','2025-12-06 04:29:56',NULL,'DELETE','IN_PROGRESS','test_resource','StackEventsTest-347241810-test_resource-paufa56safnm','state changed','OS::Heat::TestResource',NULL,81),(465,'80e351c7-7ce4-4f73-b494-8ea3f35f8a48','6ad69760-d81b-4153-a8cf-d75a571a76ee','2025-12-06 04:29:56',NULL,'DELETE','COMPLETE','test_resource','StackEventsTest-347241810-test_resource-paufa56safnm','state changed','OS::Heat::TestResource',NULL,81),(466,'ffa48835-5a35-4fbe-b8b3-579fa60b0148','6ad69760-d81b-4153-a8cf-d75a571a76ee','2025-12-06 04:29:56',NULL,'DELETE','COMPLETE','StackEventsTest-347241810','6ad69760-d81b-4153-a8cf-d75a571a76ee','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(467,'a7c93a42-1d24-476b-9edc-14f6aaaea8d9','f1760f48-9423-431b-b917-2fd0efa4c223','2025-12-06 04:29:56',NULL,'CREATE','IN_PROGRESS','RemoteDeeplyNestedStackTest-2039546384','f1760f48-9423-431b-b917-2fd0efa4c223','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(468,'e52cc98a-7459-4053-a325-4dc153757d08','f1760f48-9423-431b-b917-2fd0efa4c223','2025-12-06 04:29:56',NULL,'CREATE','IN_PROGRESS','network_stack','RemoteDeeplyNestedStackTest-2039546384-network_stack-tuxceswutxbo','state changed','OS::Heat::Stack',NULL,86),(469,'7bc1398b-53a5-4562-9e40-953ce799bd43','c9a600fe-447f-4044-829d-9cbdaf912d22','2025-12-06 04:29:56',NULL,'DELETE','COMPLETE','subnet','dbd06594-0408-46e7-a4e6-aa5c6321ab1e','state changed','OS::Neutron::Subnet',NULL,82),(470,'e759c0f6-120b-490a-a4d7-c098b3e75300','c9a600fe-447f-4044-829d-9cbdaf912d22','2025-12-06 04:29:56',NULL,'DELETE','IN_PROGRESS','net','f61a1657-cb93-405a-9870-0750081f667c','state changed','OS::Neutron::Net',NULL,NULL),(471,'e1806515-d1f5-4418-abc5-46d51ad93cc4','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:56',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-1006298183','758fa67e-b396-4351-9dc2-6517d90edfcb','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(472,'f594ead2-f19c-4a30-88c2-9ea11b94f2e8','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:56',NULL,'DELETE','IN_PROGRESS','trunk','c8ec44c1-4e44-42af-b0f7-c94f4339298b','state changed','OS::Neutron::Trunk',NULL,83),(473,'7bf3832b-a41d-4026-b3dc-78bcaf400110','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:56',NULL,'DELETE','COMPLETE','trunk','c8ec44c1-4e44-42af-b0f7-c94f4339298b','state changed','OS::Neutron::Trunk',NULL,83),(474,'4da97192-c20a-4826-be39-7d6b0688a504','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:57',NULL,'DELETE','IN_PROGRESS','parent_port','e0d2b829-65ef-44a0-9891-0a2dcf3923fe','state changed','OS::Neutron::Port',NULL,72),(475,'8bece72e-2d24-4508-8f2f-a5290277c4ed','c9a600fe-447f-4044-829d-9cbdaf912d22','2025-12-06 04:29:57',NULL,'DELETE','COMPLETE','net','f61a1657-cb93-405a-9870-0750081f667c','state changed','OS::Neutron::Net',NULL,NULL),(476,'0b3f8e87-8edb-46d3-b20c-585b5091140a','c9a600fe-447f-4044-829d-9cbdaf912d22','2025-12-06 04:29:57',NULL,'DELETE','COMPLETE','UpdateSubnetTest-254983957','c9a600fe-447f-4044-829d-9cbdaf912d22','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(477,'5dab275f-8786-4c5b-b622-1b9aa57d4fe7','a77182a5-55df-4c8f-88f7-4c1d5323fbeb','2025-12-06 04:29:57',NULL,'CREATE','IN_PROGRESS','RemoteDeeplyNestedStackTest-2039546384-network_stack-tuxceswutxbo','a77182a5-55df-4c8f-88f7-4c1d5323fbeb','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(478,'b8a5005f-5ed0-4566-bf59-fcc2d8892778','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:57',NULL,'DELETE','COMPLETE','parent_port','e0d2b829-65ef-44a0-9891-0a2dcf3923fe','state changed','OS::Neutron::Port',NULL,72),(479,'49263425-36eb-4506-ad6d-3ae84627b86f','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:57',NULL,'DELETE','IN_PROGRESS','parent_subnet','26309d79-a62e-4a15-862a-900a8363def8','state changed','OS::Neutron::Subnet',NULL,69),(480,'6d1a2b4e-fe9c-4481-b5b6-030c56ef1120','a77182a5-55df-4c8f-88f7-4c1d5323fbeb','2025-12-06 04:29:57',NULL,'CREATE','IN_PROGRESS','network_stack_as_custom_type','RemoteDeeplyNestedStackTest-2039546384-network_stack-tuxceswutxbo-network_stack_as_custom_type-gfwarkw5z52h','state changed','file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml',NULL,87),(481,'24bba5f5-4ecc-4549-ac45-e756fe9e9de1','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:57',NULL,'DELETE','IN_PROGRESS','sub_port_one','b79cbe40-4353-40db-9cac-10116b6d738e','state changed','OS::Neutron::Port',NULL,75),(482,'d4f5e977-eab5-4e01-87f5-b162d23af430','4c151c7c-65f0-478c-94a5-1cb8b8640e48','2025-12-06 04:29:57',NULL,'CREATE','IN_PROGRESS','RemoteDeeplyNestedStackTest-2039546384-network_stack-tuxceswutxbo-network_stack_as_custom_type-gfwarkw5z52h','4c151c7c-65f0-478c-94a5-1cb8b8640e48','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(483,'4b6ec941-a45a-48e2-be44-b0cee82b1314','4c151c7c-65f0-478c-94a5-1cb8b8640e48','2025-12-06 04:29:57',NULL,'CREATE','IN_PROGRESS','router','RemoteDeeplyNestedStackTest-2039546384-network_stack-tuxceswutxbo-network_stack_as_custom_type-gfwarkw5z52h-router-cllyrl4a6xv3','state changed','OS::Neutron::Router',NULL,88),(484,'fad28d59-38fb-4829-8265-5a75fa243217','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:57',NULL,'DELETE','COMPLETE','parent_subnet','26309d79-a62e-4a15-862a-900a8363def8','state changed','OS::Neutron::Subnet',NULL,69),(485,'b9ba03ec-6843-49ae-8649-5e4831dd782b','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:58',NULL,'DELETE','IN_PROGRESS','parent_net','9100ef72-d035-426a-81f7-e937ae98d3ed','state changed','OS::Neutron::Net',NULL,NULL),(486,'48d781a4-9463-484b-9dee-fadf87652f3c','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:58',NULL,'DELETE','COMPLETE','sub_port_one','b79cbe40-4353-40db-9cac-10116b6d738e','state changed','OS::Neutron::Port',NULL,75),(487,'ba74a15c-4b87-4b28-9060-3c8df52532c3','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:58',NULL,'DELETE','IN_PROGRESS','sub_port_two','b4093632-b1df-4dc0-9575-14a42ea7f058','state changed','OS::Neutron::Port',NULL,74),(488,'3bf92428-38c4-4312-b6a7-4541e64c5974','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:58',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','0a33f110-e0cb-4db1-a8c5-516b8d5341a8','state changed','OS::Neutron::Subnet',NULL,71),(489,'357d54d9-3e8a-4427-b796-b5f26e0b61c8','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:59',NULL,'DELETE','COMPLETE','parent_net','9100ef72-d035-426a-81f7-e937ae98d3ed','state changed','OS::Neutron::Net',NULL,NULL),(490,'c5df53a4-df99-4a09-bc0d-7e9f1e5b6efe','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:59',NULL,'DELETE','COMPLETE','trunk_subnet_one','0a33f110-e0cb-4db1-a8c5-516b8d5341a8','state changed','OS::Neutron::Subnet',NULL,71),(491,'7fe23dc8-3488-4382-bfb6-d6398f0d1164','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:59',NULL,'DELETE','IN_PROGRESS','trunk_net_one','94d82ad2-c26e-4f23-9f27-89af726ef2e8','state changed','OS::Neutron::Net',NULL,NULL),(492,'f1d4c676-42b7-4c91-a9c3-4f50776ee854','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:30:00',NULL,'DELETE','COMPLETE','sub_port_two','b4093632-b1df-4dc0-9575-14a42ea7f058','state changed','OS::Neutron::Port',NULL,74),(493,'9e3e4a63-5a51-499b-8985-d83a763c82c7','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:30:00',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','4dc5bfe3-a0dd-4e80-81ef-9eb735682bbc','state changed','OS::Neutron::Subnet',NULL,70),(494,'a9da7337-0ae7-408d-846a-43ddca6d02a2','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:30:01',NULL,'DELETE','COMPLETE','trunk_subnet_two','4dc5bfe3-a0dd-4e80-81ef-9eb735682bbc','state changed','OS::Neutron::Subnet',NULL,70),(495,'71e396bf-f069-4d5a-8a91-a143b2f50225','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:30:01',NULL,'DELETE','IN_PROGRESS','trunk_net_two','f94d8a47-757e-488a-a00a-2913455b40d7','state changed','OS::Neutron::Net',NULL,NULL),(496,'8c15bc84-2976-416e-a8fa-5aab5e58253f','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:30:01',NULL,'DELETE','COMPLETE','trunk_net_one','94d82ad2-c26e-4f23-9f27-89af726ef2e8','state changed','OS::Neutron::Net',NULL,NULL),(497,'29c183fb-ae66-4c67-bceb-7e4fcd75fd15','4c151c7c-65f0-478c-94a5-1cb8b8640e48','2025-12-06 04:30:01',NULL,'CREATE','COMPLETE','router','c5c262eb-9080-42d4-876d-33024fb64bc3','state changed','OS::Neutron::Router',NULL,88),(498,'749fcd71-f9c7-4132-9aa1-a29d65291136','4c151c7c-65f0-478c-94a5-1cb8b8640e48','2025-12-06 04:30:01',NULL,'CREATE','COMPLETE','RemoteDeeplyNestedStackTest-2039546384-network_stack-tuxceswutxbo-network_stack_as_custom_type-gfwarkw5z52h','4c151c7c-65f0-478c-94a5-1cb8b8640e48','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(499,'7e10cea9-0238-4c0f-ac6e-d61de833f403','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:30:01',NULL,'DELETE','COMPLETE','trunk_net_two','f94d8a47-757e-488a-a00a-2913455b40d7','state changed','OS::Neutron::Net',NULL,NULL),(500,'8c33e356-1fba-401b-ad1b-fbe985659ce0','a77182a5-55df-4c8f-88f7-4c1d5323fbeb','2025-12-06 04:30:01',NULL,'CREATE','COMPLETE','network_stack_as_custom_type','4c151c7c-65f0-478c-94a5-1cb8b8640e48','state changed','file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml',NULL,87),(501,'88a41357-f2b8-4179-ba1c-e85f0492873e','758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:30:01',NULL,'DELETE','COMPLETE','UpdateTrunkTest-1006298183','758fa67e-b396-4351-9dc2-6517d90edfcb','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(502,'d7089e57-1a72-437d-b701-3d408b7f15c2','a77182a5-55df-4c8f-88f7-4c1d5323fbeb','2025-12-06 04:30:01',NULL,'CREATE','COMPLETE','RemoteDeeplyNestedStackTest-2039546384-network_stack-tuxceswutxbo','a77182a5-55df-4c8f-88f7-4c1d5323fbeb','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(503,'03758bf0-d18b-4491-9705-695f1175033b','24398c00-fc29-4ccb-984e-76303f40d27a','2025-12-06 04:30:01',NULL,'CREATE','IN_PROGRESS','StackOutputsTest-1139037893','24398c00-fc29-4ccb-984e-76303f40d27a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(504,'c38a3efd-74a8-4097-97d0-18f0506ff7b4','eb100395-d68e-4497-a187-63f5f8ff0ed2','2025-12-06 04:30:01',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-1708440745','eb100395-d68e-4497-a187-63f5f8ff0ed2','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(505,'8f7dc86c-32ec-4fa9-b390-6f8f219e6e41','24398c00-fc29-4ccb-984e-76303f40d27a','2025-12-06 04:30:01',NULL,'CREATE','IN_PROGRESS','parent','StackOutputsTest-1139037893-parent-rmz53it6q55r','state changed','1.yaml',NULL,NULL),(506,'7b3e2a33-42b3-4595-86d5-12f98be93491','eb100395-d68e-4497-a187-63f5f8ff0ed2','2025-12-06 04:30:01',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-1708440745-net-dqwrf6g32wwt','state changed','OS::Neutron::Net',NULL,NULL),(507,'c3dddc2a-84c9-48a2-b7e9-955175408783','d00332b2-5d32-429a-a53c-42885ff38ad0','2025-12-06 04:30:02',NULL,'CREATE','IN_PROGRESS','StackOutputsTest-1139037893-parent-rmz53it6q55r','d00332b2-5d32-429a-a53c-42885ff38ad0','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(508,'b4613d53-72af-41a8-be08-0afe1c9dc599','d00332b2-5d32-429a-a53c-42885ff38ad0','2025-12-06 04:30:02',NULL,'CREATE','IN_PROGRESS','test_resource_b','StackOutputsTest-1139037893-parent-rmz53it6q55r-test_resource_b-gensqpu7hyes','state changed','OS::Heat::TestResource',NULL,90),(509,'d5b915b6-4a85-4b84-aac7-a9fb4f44e9ff','d00332b2-5d32-429a-a53c-42885ff38ad0','2025-12-06 04:30:02',NULL,'CREATE','COMPLETE','test_resource_b','StackOutputsTest-1139037893-parent-rmz53it6q55r-test_resource_b-gensqpu7hyes','state changed','OS::Heat::TestResource',NULL,90),(510,'b3585fd9-de1d-497b-91af-7b84d908c98e','d00332b2-5d32-429a-a53c-42885ff38ad0','2025-12-06 04:30:03',NULL,'CREATE','IN_PROGRESS','test_resource_a','StackOutputsTest-1139037893-parent-rmz53it6q55r-test_resource_a-oxtxohxyx6f2','state changed','OS::Heat::TestResource',NULL,91),(511,'9b7b84a9-94d6-4233-9b0d-b65b925b6745','d00332b2-5d32-429a-a53c-42885ff38ad0','2025-12-06 04:30:03',NULL,'CREATE','COMPLETE','test_resource_a','StackOutputsTest-1139037893-parent-rmz53it6q55r-test_resource_a-oxtxohxyx6f2','state changed','OS::Heat::TestResource',NULL,91),(512,'725b27e0-47d3-406a-9d8a-0d6170d0abea','d00332b2-5d32-429a-a53c-42885ff38ad0','2025-12-06 04:30:03',NULL,'CREATE','COMPLETE','StackOutputsTest-1139037893-parent-rmz53it6q55r','d00332b2-5d32-429a-a53c-42885ff38ad0','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(513,'1d3e3ae3-8b00-4521-8b8a-77e86629e58a','eb100395-d68e-4497-a187-63f5f8ff0ed2','2025-12-06 04:30:03',NULL,'CREATE','COMPLETE','net','d8f5c5af-65be-42e7-846f-901285c31660','state changed','OS::Neutron::Net',NULL,NULL),(514,'21580358-756a-4a89-a9eb-c6e75da0bd2d','f1760f48-9423-431b-b917-2fd0efa4c223','2025-12-06 04:30:03',NULL,'CREATE','COMPLETE','network_stack','a77182a5-55df-4c8f-88f7-4c1d5323fbeb','state changed','OS::Heat::Stack',NULL,86),(515,'c200c988-b8c9-4780-b7fe-a4cdd36a1f72','f1760f48-9423-431b-b917-2fd0efa4c223','2025-12-06 04:30:03',NULL,'CREATE','COMPLETE','RemoteDeeplyNestedStackTest-2039546384','f1760f48-9423-431b-b917-2fd0efa4c223','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(516,'f2c29915-d9a2-4985-b1d9-b13d5ebbc398','eb100395-d68e-4497-a187-63f5f8ff0ed2','2025-12-06 04:30:03',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-1708440745-subnet-gdrh23jz6kds','state changed','OS::Neutron::Subnet',NULL,92),(517,'e36ffef7-718c-4f53-80f6-a17129f2afe6','24398c00-fc29-4ccb-984e-76303f40d27a','2025-12-06 04:30:04',NULL,'CREATE','COMPLETE','parent','d00332b2-5d32-429a-a53c-42885ff38ad0','state changed','1.yaml',NULL,NULL),(518,'1ed392de-8953-454e-85db-4b4c989d9f5a','24398c00-fc29-4ccb-984e-76303f40d27a','2025-12-06 04:30:04',NULL,'CREATE','COMPLETE','StackOutputsTest-1139037893','24398c00-fc29-4ccb-984e-76303f40d27a','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(519,'90b547cb-93d3-4610-bcd3-b8a276e70051','f1760f48-9423-431b-b917-2fd0efa4c223','2025-12-06 04:30:05',NULL,'DELETE','IN_PROGRESS','RemoteDeeplyNestedStackTest-2039546384','f1760f48-9423-431b-b917-2fd0efa4c223','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(520,'1b29db87-bedb-428d-a228-f3a6b597b1a0','f1760f48-9423-431b-b917-2fd0efa4c223','2025-12-06 04:30:06',NULL,'DELETE','IN_PROGRESS','network_stack','a77182a5-55df-4c8f-88f7-4c1d5323fbeb','state changed','OS::Heat::Stack',NULL,86),(521,'a2f57bee-7c4f-4cb0-a681-59ec48c26479','eb100395-d68e-4497-a187-63f5f8ff0ed2','2025-12-06 04:30:06',NULL,'CREATE','COMPLETE','subnet','07c44b9e-2770-4f3a-ac90-e0d1aafa1aff','state changed','OS::Neutron::Subnet',NULL,92),(522,'72a23ffc-da89-4055-9886-7ebbf0423f99','eb100395-d68e-4497-a187-63f5f8ff0ed2','2025-12-06 04:30:06',NULL,'CREATE','COMPLETE','UpdateSubnetTest-1708440745','eb100395-d68e-4497-a187-63f5f8ff0ed2','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(523,'acf147c9-c2d2-4011-9554-66b34fb6a8c3','a77182a5-55df-4c8f-88f7-4c1d5323fbeb','2025-12-06 04:30:06',NULL,'DELETE','IN_PROGRESS','RemoteDeeplyNestedStackTest-2039546384-network_stack-tuxceswutxbo','a77182a5-55df-4c8f-88f7-4c1d5323fbeb','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(524,'aa704f82-f1f7-44c2-a360-a1339b8469bb','a77182a5-55df-4c8f-88f7-4c1d5323fbeb','2025-12-06 04:30:06',NULL,'DELETE','IN_PROGRESS','network_stack_as_custom_type','4c151c7c-65f0-478c-94a5-1cb8b8640e48','state changed','file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml',NULL,87),(525,'8bf3aa7f-fed6-4ca0-bc7b-b6e4866ef823','24398c00-fc29-4ccb-984e-76303f40d27a','2025-12-06 04:30:07',NULL,'UPDATE','IN_PROGRESS','StackOutputsTest-1139037893','24398c00-fc29-4ccb-984e-76303f40d27a','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(526,'febda2fc-b883-46e5-bb8f-86fc357bf2ef','4c151c7c-65f0-478c-94a5-1cb8b8640e48','2025-12-06 04:30:07',NULL,'DELETE','IN_PROGRESS','RemoteDeeplyNestedStackTest-2039546384-network_stack-tuxceswutxbo-network_stack_as_custom_type-gfwarkw5z52h','4c151c7c-65f0-478c-94a5-1cb8b8640e48','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(527,'89e6ca31-3d27-458a-afe0-1d7ce7a17924','24398c00-fc29-4ccb-984e-76303f40d27a','2025-12-06 04:30:07',NULL,'UPDATE','IN_PROGRESS','parent','d00332b2-5d32-429a-a53c-42885ff38ad0','state changed','1.yaml',NULL,NULL),(528,'18d893c9-cd4c-41a5-9c58-9f1f8d98da0e','4c151c7c-65f0-478c-94a5-1cb8b8640e48','2025-12-06 04:30:07',NULL,'DELETE','IN_PROGRESS','router','c5c262eb-9080-42d4-876d-33024fb64bc3','state changed','OS::Neutron::Router',NULL,88),(529,'29e83069-2da4-4801-b333-b5d6dcd81829','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:07',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-720889307','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(530,'76974827-aa1f-4968-9e17-7e0ee8473a2a','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:07',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-720889307-parent_net-cu7leeljavoj','state changed','OS::Neutron::Net',NULL,NULL),(531,'9e29c8c9-e101-416c-98d6-361176ee5299','d00332b2-5d32-429a-a53c-42885ff38ad0','2025-12-06 04:30:07',NULL,'UPDATE','IN_PROGRESS','StackOutputsTest-1139037893-parent-rmz53it6q55r','d00332b2-5d32-429a-a53c-42885ff38ad0','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(532,'e4b4e343-c58e-41c0-81b9-5de299dd788a','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:08',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-720889307-trunk_net_one-ty7bitziva4u','state changed','OS::Neutron::Net',NULL,NULL),(533,'dad7829a-6543-40f4-aa59-94847e7ee3f0','4c151c7c-65f0-478c-94a5-1cb8b8640e48','2025-12-06 04:30:08',NULL,'DELETE','COMPLETE','router','c5c262eb-9080-42d4-876d-33024fb64bc3','state changed','OS::Neutron::Router',NULL,88),(534,'88a4b99f-181e-4f03-b900-d0680ee9f5dd','4c151c7c-65f0-478c-94a5-1cb8b8640e48','2025-12-06 04:30:08',NULL,'DELETE','COMPLETE','RemoteDeeplyNestedStackTest-2039546384-network_stack-tuxceswutxbo-network_stack_as_custom_type-gfwarkw5z52h','4c151c7c-65f0-478c-94a5-1cb8b8640e48','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(535,'66f8f5bf-a37a-4832-8e3d-979e04fdabc2','d00332b2-5d32-429a-a53c-42885ff38ad0','2025-12-06 04:30:08',NULL,'UPDATE','COMPLETE','StackOutputsTest-1139037893-parent-rmz53it6q55r','d00332b2-5d32-429a-a53c-42885ff38ad0','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(536,'7be0ff6c-6500-4237-8749-e088f8c83d77','a77182a5-55df-4c8f-88f7-4c1d5323fbeb','2025-12-06 04:30:09',NULL,'DELETE','COMPLETE','network_stack_as_custom_type','4c151c7c-65f0-478c-94a5-1cb8b8640e48','state changed','file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml',NULL,87),(537,'9c1806dc-d55b-46eb-97c0-178d1d197546','a77182a5-55df-4c8f-88f7-4c1d5323fbeb','2025-12-06 04:30:09',NULL,'DELETE','COMPLETE','RemoteDeeplyNestedStackTest-2039546384-network_stack-tuxceswutxbo','a77182a5-55df-4c8f-88f7-4c1d5323fbeb','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(538,'195a5cc6-94bc-49ba-8810-181762ad84c6','24398c00-fc29-4ccb-984e-76303f40d27a','2025-12-06 04:30:09',NULL,'UPDATE','COMPLETE','parent','d00332b2-5d32-429a-a53c-42885ff38ad0','state changed','1.yaml',NULL,NULL),(539,'800ef8e2-9d10-4fd8-988e-4f1786d2c046','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:10',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-720889307-trunk_net_two-4wcgswb7attl','state changed','OS::Neutron::Net',NULL,NULL),(540,'28c8efbe-d450-4526-9a61-e6cc2dfa30ca','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:10',NULL,'CREATE','COMPLETE','parent_net','3626f49b-d25a-47bc-b0e6-67d1efcee15e','state changed','OS::Neutron::Net',NULL,NULL),(541,'c49aae75-f259-432b-b493-4babc1235d9a','f1760f48-9423-431b-b917-2fd0efa4c223','2025-12-06 04:30:10',NULL,'DELETE','COMPLETE','network_stack','a77182a5-55df-4c8f-88f7-4c1d5323fbeb','state changed','OS::Heat::Stack',NULL,86),(542,'9e559399-619f-4cfc-b840-99251c484485','f1760f48-9423-431b-b917-2fd0efa4c223','2025-12-06 04:30:10',NULL,'DELETE','COMPLETE','RemoteDeeplyNestedStackTest-2039546384','f1760f48-9423-431b-b917-2fd0efa4c223','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(543,'efc6d758-221d-4043-8510-9a8a3aa9d303','24398c00-fc29-4ccb-984e-76303f40d27a','2025-12-06 04:30:10',NULL,'UPDATE','COMPLETE','StackOutputsTest-1139037893','24398c00-fc29-4ccb-984e-76303f40d27a','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(544,'27cbc31d-b50a-4f40-8f26-13aa31bea929','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:10',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-720889307-parent_subnet-d4s2wr6z4zly','state changed','OS::Neutron::Subnet',NULL,94),(545,'c367c114-1d91-4524-9efb-172620c7ea2c','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:11',NULL,'CREATE','COMPLETE','trunk_net_one','6d4c3934-38d3-4d9d-b4c9-a99c3d909ed5','state changed','OS::Neutron::Net',NULL,NULL),(546,'ae021925-a763-49c2-827d-2ed576f57704','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:11',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-720889307-trunk_subnet_one-pwi64fknbmb2','state changed','OS::Neutron::Subnet',NULL,97),(547,'44adeab5-a4bd-445f-88a4-82924a28745a','24398c00-fc29-4ccb-984e-76303f40d27a','2025-12-06 04:30:12',NULL,'DELETE','IN_PROGRESS','StackOutputsTest-1139037893','24398c00-fc29-4ccb-984e-76303f40d27a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(548,'555d024e-b520-4cab-9b22-03d5561344aa','eb100395-d68e-4497-a187-63f5f8ff0ed2','2025-12-06 04:30:12',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-1708440745','eb100395-d68e-4497-a187-63f5f8ff0ed2','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(549,'e981326a-aa7e-4121-aef1-b69b33dc06e1','24398c00-fc29-4ccb-984e-76303f40d27a','2025-12-06 04:30:12',NULL,'DELETE','IN_PROGRESS','parent','d00332b2-5d32-429a-a53c-42885ff38ad0','state changed','1.yaml',NULL,NULL),(550,'08ab1509-df5e-4a74-968f-b41fbd6af646','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:12',NULL,'CREATE','COMPLETE','trunk_net_two','20dd2613-44e6-4998-ab0a-e8f764b9da7a','state changed','OS::Neutron::Net',NULL,NULL),(551,'b612ec51-cad8-4386-8084-8b77bae3c83e','d00332b2-5d32-429a-a53c-42885ff38ad0','2025-12-06 04:30:12',NULL,'DELETE','IN_PROGRESS','StackOutputsTest-1139037893-parent-rmz53it6q55r','d00332b2-5d32-429a-a53c-42885ff38ad0','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(552,'a5ebc564-c42d-4153-b6be-0d41e513ca44','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:12',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-720889307-trunk_subnet_two-4msene442obr','state changed','OS::Neutron::Subnet',NULL,98),(553,'2e73ef22-39ec-41d2-93b2-71e2b49b3ef2','d00332b2-5d32-429a-a53c-42885ff38ad0','2025-12-06 04:30:12',NULL,'DELETE','IN_PROGRESS','test_resource_a','StackOutputsTest-1139037893-parent-rmz53it6q55r-test_resource_a-oxtxohxyx6f2','state changed','OS::Heat::TestResource',NULL,91),(554,'c69dd37d-5f19-4030-b978-3c9c5f8b1991','d00332b2-5d32-429a-a53c-42885ff38ad0','2025-12-06 04:30:12',NULL,'DELETE','COMPLETE','test_resource_a','StackOutputsTest-1139037893-parent-rmz53it6q55r-test_resource_a-oxtxohxyx6f2','state changed','OS::Heat::TestResource',NULL,91),(555,'e315b119-ffa8-4cb1-a603-fb12c5303489','eb100395-d68e-4497-a187-63f5f8ff0ed2','2025-12-06 04:30:12',NULL,'UPDATE','IN_PROGRESS','subnet','07c44b9e-2770-4f3a-ac90-e0d1aafa1aff','state changed','OS::Neutron::Subnet',NULL,92),(556,'19cd64d9-89bf-474d-be0b-fc307b366e27','d00332b2-5d32-429a-a53c-42885ff38ad0','2025-12-06 04:30:13',NULL,'DELETE','IN_PROGRESS','test_resource_b','StackOutputsTest-1139037893-parent-rmz53it6q55r-test_resource_b-gensqpu7hyes','state changed','OS::Heat::TestResource',NULL,90),(557,'dbdff49e-7616-4637-af9f-571828dd14e8','d00332b2-5d32-429a-a53c-42885ff38ad0','2025-12-06 04:30:13',NULL,'DELETE','COMPLETE','test_resource_b','StackOutputsTest-1139037893-parent-rmz53it6q55r-test_resource_b-gensqpu7hyes','state changed','OS::Heat::TestResource',NULL,90),(558,'3508e195-8887-42e1-b7fc-a8aa36c333a1','d00332b2-5d32-429a-a53c-42885ff38ad0','2025-12-06 04:30:13',NULL,'DELETE','COMPLETE','StackOutputsTest-1139037893-parent-rmz53it6q55r','d00332b2-5d32-429a-a53c-42885ff38ad0','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(559,'15477f24-7569-40a1-8249-b0794930510d','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:13',NULL,'CREATE','COMPLETE','parent_subnet','3249f11a-1dd2-4e03-a1f5-6bd78f9c9f9e','state changed','OS::Neutron::Subnet',NULL,94),(560,'2d895a8b-d272-48b5-af06-329f5fd8651b','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:13',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-720889307-parent_port-fdpfcive4q2y','state changed','OS::Neutron::Port',NULL,99),(561,'78fb4a28-ad02-4043-8314-512af1d7adac','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:14',NULL,'CREATE','COMPLETE','trunk_subnet_two','f3d81ea1-954c-48e6-b64e-a5c257c47e93','state changed','OS::Neutron::Subnet',NULL,98),(562,'c5e6015e-be60-47f0-87f6-ee3042e819ad','24398c00-fc29-4ccb-984e-76303f40d27a','2025-12-06 04:30:14',NULL,'DELETE','COMPLETE','parent','d00332b2-5d32-429a-a53c-42885ff38ad0','state changed','1.yaml',NULL,NULL),(563,'fa6684ba-0973-4bfa-a89b-4e074d530fc0','24398c00-fc29-4ccb-984e-76303f40d27a','2025-12-06 04:30:14',NULL,'DELETE','COMPLETE','StackOutputsTest-1139037893','24398c00-fc29-4ccb-984e-76303f40d27a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(564,'f533dc14-2563-4565-9ddd-96961e624076','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:14',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-720889307-sub_port_two-zatwuzdvpifj','state changed','OS::Neutron::Port',NULL,100),(565,'875d7438-a1ff-4e84-a2c9-cc338584044f','eb100395-d68e-4497-a187-63f5f8ff0ed2','2025-12-06 04:30:14',NULL,'UPDATE','COMPLETE','subnet','07c44b9e-2770-4f3a-ac90-e0d1aafa1aff','state changed','OS::Neutron::Subnet',NULL,101),(566,'125cc912-689a-4eba-acb2-0af3a9d1bb0b','eb100395-d68e-4497-a187-63f5f8ff0ed2','2025-12-06 04:30:15',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-1708440745','eb100395-d68e-4497-a187-63f5f8ff0ed2','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(567,'49245b4b-6886-435d-b03c-815f1ab4133b','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:15',NULL,'CREATE','COMPLETE','trunk_subnet_one','789b2b25-b41a-4788-9eff-869eb6882b3b','state changed','OS::Neutron::Subnet',NULL,97),(568,'cbab9870-4444-4d25-9d63-7780052ab2c8','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:15',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-720889307-sub_port_one-37o7knk5yktm','state changed','OS::Neutron::Port',NULL,102),(569,'db1b8067-42ee-4bd5-8e9e-fdf51e517025','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:15',NULL,'CREATE','COMPLETE','parent_port','824cc269-1e9b-4cbc-a946-131e5c0d4b52','state changed','OS::Neutron::Port',NULL,99),(570,'97078a41-e60c-464a-a60e-872fd75d3919','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:16',NULL,'CREATE','COMPLETE','sub_port_two','9d74a47d-55b6-45cf-bb76-83f78a7ff83d','state changed','OS::Neutron::Port',NULL,100),(571,'c3731d25-4eb9-4058-b3ad-7244506fec2a','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:16',NULL,'CREATE','COMPLETE','sub_port_one','9cb8d158-a67c-4757-8b63-9804330f4266','state changed','OS::Neutron::Port',NULL,102),(572,'dbe63218-1581-4fe2-84fa-9e13cd22fcb4','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:16',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-720889307-trunk-hqaih4srnphk','state changed','OS::Neutron::Trunk',NULL,103),(573,'28190fe6-f52e-4ba7-ac32-19c85fa211f9','eb100395-d68e-4497-a187-63f5f8ff0ed2','2025-12-06 04:30:16',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-1708440745','eb100395-d68e-4497-a187-63f5f8ff0ed2','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(574,'53599279-b665-45f7-9de3-2a8c60755698','eb100395-d68e-4497-a187-63f5f8ff0ed2','2025-12-06 04:30:17',NULL,'DELETE','IN_PROGRESS','subnet','07c44b9e-2770-4f3a-ac90-e0d1aafa1aff','state changed','OS::Neutron::Subnet',NULL,101),(575,'2fca2a66-64d3-4aa8-b40c-46c1b3a75df0','c68cfc4a-8e59-4685-9457-25004f5b3c4f','2025-12-06 04:30:17',NULL,'CREATE','IN_PROGRESS','StackOutputsTest-1508166139','c68cfc4a-8e59-4685-9457-25004f5b3c4f','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(576,'6747103a-4a1b-4e8e-b7c4-421149965808','eb100395-d68e-4497-a187-63f5f8ff0ed2','2025-12-06 04:30:17',NULL,'DELETE','COMPLETE','subnet','07c44b9e-2770-4f3a-ac90-e0d1aafa1aff','state changed','OS::Neutron::Subnet',NULL,101),(577,'8c604130-e6f1-4669-a017-0ca960dbf3f5','c68cfc4a-8e59-4685-9457-25004f5b3c4f','2025-12-06 04:30:17',NULL,'CREATE','IN_PROGRESS','test_resource_a','StackOutputsTest-1508166139-test_resource_a-klorpub3oyvh','state changed','OS::Heat::TestResource',NULL,105),(578,'445261a2-d292-47ee-8b8c-afcd629130a3','eb100395-d68e-4497-a187-63f5f8ff0ed2','2025-12-06 04:30:17',NULL,'DELETE','IN_PROGRESS','net','d8f5c5af-65be-42e7-846f-901285c31660','state changed','OS::Neutron::Net',NULL,NULL),(579,'2777369a-0cea-4ad2-83c9-ee2dd7f25b62','c68cfc4a-8e59-4685-9457-25004f5b3c4f','2025-12-06 04:30:17',NULL,'CREATE','COMPLETE','test_resource_a','StackOutputsTest-1508166139-test_resource_a-klorpub3oyvh','state changed','OS::Heat::TestResource',NULL,105),(580,'132d311d-97f7-4bfc-b903-40f88fff50b2','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:18',NULL,'CREATE','COMPLETE','trunk','aed9f568-4f24-4115-be1d-bd1a705419fc','state changed','OS::Neutron::Trunk',NULL,103),(581,'dc0166a5-c7a7-4333-a1d2-eb8119b8e751','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:18',NULL,'CREATE','COMPLETE','UpdateTrunkTest-720889307','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(582,'c5d11b84-5f54-44eb-962f-6e5b1f5de187','eb100395-d68e-4497-a187-63f5f8ff0ed2','2025-12-06 04:30:18',NULL,'DELETE','COMPLETE','net','d8f5c5af-65be-42e7-846f-901285c31660','state changed','OS::Neutron::Net',NULL,NULL),(583,'37a10405-cf91-4a7c-b526-98dfcde3004c','eb100395-d68e-4497-a187-63f5f8ff0ed2','2025-12-06 04:30:18',NULL,'DELETE','COMPLETE','UpdateSubnetTest-1708440745','eb100395-d68e-4497-a187-63f5f8ff0ed2','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(584,'b9a1414a-50fc-4f9f-a5a4-08d3dfa2ccd1','c68cfc4a-8e59-4685-9457-25004f5b3c4f','2025-12-06 04:30:18',NULL,'CREATE','IN_PROGRESS','test_resource_b','StackOutputsTest-1508166139-test_resource_b-snilassh5oos','state changed','OS::Heat::TestResource',NULL,106),(585,'31f42b36-da8c-4296-b966-3539d794cbd4','c68cfc4a-8e59-4685-9457-25004f5b3c4f','2025-12-06 04:30:18',NULL,'CREATE','COMPLETE','test_resource_b','StackOutputsTest-1508166139-test_resource_b-snilassh5oos','state changed','OS::Heat::TestResource',NULL,106),(586,'879735ef-1f04-41b1-8690-5e992f1897f2','c68cfc4a-8e59-4685-9457-25004f5b3c4f','2025-12-06 04:30:18',NULL,'CREATE','COMPLETE','StackOutputsTest-1508166139','c68cfc4a-8e59-4685-9457-25004f5b3c4f','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(587,'09cbc51c-8d14-4153-b82c-bb833bd33c4b','c68cfc4a-8e59-4685-9457-25004f5b3c4f','2025-12-06 04:30:23',NULL,'DELETE','IN_PROGRESS','StackOutputsTest-1508166139','c68cfc4a-8e59-4685-9457-25004f5b3c4f','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(588,'432dad0d-0905-4e0c-8ce5-85e936f8fff1','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:23',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-720889307','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(589,'c7c53928-c172-45e7-88bb-e2c283f891dd','c68cfc4a-8e59-4685-9457-25004f5b3c4f','2025-12-06 04:30:23',NULL,'DELETE','IN_PROGRESS','test_resource_b','StackOutputsTest-1508166139-test_resource_b-snilassh5oos','state changed','OS::Heat::TestResource',NULL,106),(590,'80f84d17-8e75-4fcd-adf4-5f210e0ddc25','c68cfc4a-8e59-4685-9457-25004f5b3c4f','2025-12-06 04:30:23',NULL,'DELETE','COMPLETE','test_resource_b','StackOutputsTest-1508166139-test_resource_b-snilassh5oos','state changed','OS::Heat::TestResource',NULL,106),(591,'ff05932c-1c3f-4358-aacd-d14ffe8b1286','0bd141bc-a2b7-40be-8e8e-5db3ef2c7195','2025-12-06 04:30:24',NULL,'CREATE','IN_PROGRESS','EncryptionVolTypeTest-674294388','0bd141bc-a2b7-40be-8e8e-5db3ef2c7195','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(592,'ef4ad7ea-28ec-4079-8938-2669e31ce262','c68cfc4a-8e59-4685-9457-25004f5b3c4f','2025-12-06 04:30:24',NULL,'DELETE','IN_PROGRESS','test_resource_a','StackOutputsTest-1508166139-test_resource_a-klorpub3oyvh','state changed','OS::Heat::TestResource',NULL,105),(593,'86c8286e-dee3-477a-8d51-a24c4b51636c','c68cfc4a-8e59-4685-9457-25004f5b3c4f','2025-12-06 04:30:24',NULL,'DELETE','COMPLETE','test_resource_a','StackOutputsTest-1508166139-test_resource_a-klorpub3oyvh','state changed','OS::Heat::TestResource',NULL,105),(594,'55b84dbf-fd13-4057-9a36-244dce158ea3','c68cfc4a-8e59-4685-9457-25004f5b3c4f','2025-12-06 04:30:24',NULL,'DELETE','COMPLETE','StackOutputsTest-1508166139','c68cfc4a-8e59-4685-9457-25004f5b3c4f','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(595,'2a781df8-eb3f-4199-9efd-ac177f20e30d','0bd141bc-a2b7-40be-8e8e-5db3ef2c7195','2025-12-06 04:30:24',NULL,'CREATE','IN_PROGRESS','my_volume_type','EncryptionVolTypeTest-674294388-my_volume_type-ufalzcfx2jze','state changed','OS::Cinder::VolumeType',NULL,107),(596,'5daa4d33-33ed-4e0b-9693-155ebc9bd5c8','0bd141bc-a2b7-40be-8e8e-5db3ef2c7195','2025-12-06 04:30:24',NULL,'CREATE','COMPLETE','my_volume_type','6d432ce3-b478-4f23-b35d-eef894ccc524','state changed','OS::Cinder::VolumeType',NULL,107),(597,'046e9829-fd5a-478e-a6ff-ea47b07c1d82','0bd141bc-a2b7-40be-8e8e-5db3ef2c7195','2025-12-06 04:30:25',NULL,'CREATE','IN_PROGRESS','my_encrypted_vol_type','EncryptionVolTypeTest-674294388-my_encrypted_vol_type-dln3nedatapy','state changed','OS::Cinder::EncryptedVolumeType',NULL,108),(598,'62d6bbf8-05cc-44d1-a8f9-c8b5f9da37a4','0bd141bc-a2b7-40be-8e8e-5db3ef2c7195','2025-12-06 04:30:25',NULL,'CREATE','COMPLETE','my_encrypted_vol_type','6d432ce3-b478-4f23-b35d-eef894ccc524','state changed','OS::Cinder::EncryptedVolumeType',NULL,108),(599,'de1772ed-8b2e-4c9b-ad50-92598fcca1fd','0bd141bc-a2b7-40be-8e8e-5db3ef2c7195','2025-12-06 04:30:25',NULL,'CREATE','COMPLETE','EncryptionVolTypeTest-674294388','0bd141bc-a2b7-40be-8e8e-5db3ef2c7195','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(600,'872ac7a2-cfa3-4060-9f12-30a17f0f41d6','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:27',NULL,'UPDATE','IN_PROGRESS','trunk','aed9f568-4f24-4115-be1d-bd1a705419fc','state changed','OS::Neutron::Trunk',NULL,103),(601,'fb0b64b0-1d66-497a-b929-5e3aabc46ff2','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:30',NULL,'UPDATE','COMPLETE','trunk','aed9f568-4f24-4115-be1d-bd1a705419fc','state changed','OS::Neutron::Trunk',NULL,109),(602,'813dcb8d-5216-417b-ad33-fdfeed40f2f8','a33e8fb8-3ca2-49dd-841b-997a458f8276','2025-12-06 04:30:30',NULL,'CREATE','IN_PROGRESS','StackOutputsTest-273854717','a33e8fb8-3ca2-49dd-841b-997a458f8276','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(603,'b79bac18-a15b-406f-a6ed-e9748c95e9dd','a33e8fb8-3ca2-49dd-841b-997a458f8276','2025-12-06 04:30:30',NULL,'CREATE','IN_PROGRESS','test_resource_a','StackOutputsTest-273854717-test_resource_a-gzkddurdnc5s','state changed','OS::Heat::TestResource',NULL,110),(604,'e4b35abc-3e1f-476c-ae27-0d8c01ae54a1','a33e8fb8-3ca2-49dd-841b-997a458f8276','2025-12-06 04:30:30',NULL,'CREATE','COMPLETE','test_resource_a','StackOutputsTest-273854717-test_resource_a-gzkddurdnc5s','state changed','OS::Heat::TestResource',NULL,110),(605,'014ca8ad-4369-46a8-9366-626db6849d31','a33e8fb8-3ca2-49dd-841b-997a458f8276','2025-12-06 04:30:30',NULL,'CREATE','COMPLETE','StackOutputsTest-273854717','a33e8fb8-3ca2-49dd-841b-997a458f8276','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(606,'f8acab18-e173-4843-92a3-73cc221f8909','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:30',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-720889307','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(607,'6a863c16-1f19-4a60-bc51-3fd885f31251','0bd141bc-a2b7-40be-8e8e-5db3ef2c7195','2025-12-06 04:30:31',NULL,'UPDATE','IN_PROGRESS','EncryptionVolTypeTest-674294388','0bd141bc-a2b7-40be-8e8e-5db3ef2c7195','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(608,'150747a3-1a57-42e8-a070-d0c18d899d27','a33e8fb8-3ca2-49dd-841b-997a458f8276','2025-12-06 04:30:31',NULL,'UPDATE','IN_PROGRESS','StackOutputsTest-273854717','a33e8fb8-3ca2-49dd-841b-997a458f8276','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(609,'46fe2ac5-76cf-4211-89c5-b9effa79b9bc','0bd141bc-a2b7-40be-8e8e-5db3ef2c7195','2025-12-06 04:30:31',NULL,'UPDATE','IN_PROGRESS','my_encrypted_vol_type','6d432ce3-b478-4f23-b35d-eef894ccc524','state changed','OS::Cinder::EncryptedVolumeType',NULL,108),(610,'d97e32ef-351f-45fc-840a-cdd7ba77eaec','a33e8fb8-3ca2-49dd-841b-997a458f8276','2025-12-06 04:30:31',NULL,'CREATE','IN_PROGRESS','test_resource_b','StackOutputsTest-273854717-test_resource_b-etlnngbvveoo','state changed','OS::Heat::TestResource',NULL,111),(611,'3e395db5-4a0b-49f5-9c32-ba6c8b4bf903','a33e8fb8-3ca2-49dd-841b-997a458f8276','2025-12-06 04:30:31',NULL,'CREATE','COMPLETE','test_resource_b','StackOutputsTest-273854717-test_resource_b-etlnngbvveoo','state changed','OS::Heat::TestResource',NULL,111),(612,'2e1663ba-aca9-437c-a04c-a92e289860b3','a33e8fb8-3ca2-49dd-841b-997a458f8276','2025-12-06 04:30:31',NULL,'UPDATE','COMPLETE','StackOutputsTest-273854717','a33e8fb8-3ca2-49dd-841b-997a458f8276','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(613,'147d341a-eafe-4312-b371-dc99f0c23c72','0bd141bc-a2b7-40be-8e8e-5db3ef2c7195','2025-12-06 04:30:31',NULL,'UPDATE','COMPLETE','my_encrypted_vol_type','6d432ce3-b478-4f23-b35d-eef894ccc524','state changed','OS::Cinder::EncryptedVolumeType',NULL,112),(614,'dd03346a-2a9d-4a5b-87a3-78bd4e70cd3c','0bd141bc-a2b7-40be-8e8e-5db3ef2c7195','2025-12-06 04:30:33',NULL,'UPDATE','COMPLETE','EncryptionVolTypeTest-674294388','0bd141bc-a2b7-40be-8e8e-5db3ef2c7195','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(615,'4a41207d-d729-4068-842b-5b9125e78e14','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:36',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-720889307','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(616,'9700b33b-c5f5-42e5-8c4c-9bf9533e8889','a33e8fb8-3ca2-49dd-841b-997a458f8276','2025-12-06 04:30:37',NULL,'DELETE','IN_PROGRESS','StackOutputsTest-273854717','a33e8fb8-3ca2-49dd-841b-997a458f8276','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(617,'d36610a0-2d0c-40a2-aed7-6aa5c9c46bcd','0bd141bc-a2b7-40be-8e8e-5db3ef2c7195','2025-12-06 04:30:39',NULL,'DELETE','IN_PROGRESS','EncryptionVolTypeTest-674294388','0bd141bc-a2b7-40be-8e8e-5db3ef2c7195','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(618,'661f8020-3d82-4978-83cd-b7620fa7c03f','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:39',NULL,'DELETE','IN_PROGRESS','trunk','aed9f568-4f24-4115-be1d-bd1a705419fc','state changed','OS::Neutron::Trunk',NULL,109),(619,'34ff7c26-6493-4a31-8efa-c7a0fee40c1d','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:39',NULL,'DELETE','IN_PROGRESS','sub_port_two','9d74a47d-55b6-45cf-bb76-83f78a7ff83d','state changed','OS::Neutron::Port',NULL,100),(620,'11aa220c-2197-4ab2-9069-cc82c31f351a','a33e8fb8-3ca2-49dd-841b-997a458f8276','2025-12-06 04:30:39',NULL,'DELETE','IN_PROGRESS','test_resource_b','StackOutputsTest-273854717-test_resource_b-etlnngbvveoo','state changed','OS::Heat::TestResource',NULL,111),(621,'fd52f7ad-abcd-4829-b1ee-3d4f307ec477','0bd141bc-a2b7-40be-8e8e-5db3ef2c7195','2025-12-06 04:30:39',NULL,'DELETE','IN_PROGRESS','my_encrypted_vol_type','6d432ce3-b478-4f23-b35d-eef894ccc524','state changed','OS::Cinder::EncryptedVolumeType',NULL,112),(622,'35cdbbb1-8cb1-4335-a486-d0f904fa38f6','a33e8fb8-3ca2-49dd-841b-997a458f8276','2025-12-06 04:30:39',NULL,'DELETE','COMPLETE','test_resource_b','StackOutputsTest-273854717-test_resource_b-etlnngbvveoo','state changed','OS::Heat::TestResource',NULL,111),(623,'ba910dfe-07d3-466c-9a6b-66cedf1d0b24','a33e8fb8-3ca2-49dd-841b-997a458f8276','2025-12-06 04:30:39',NULL,'DELETE','IN_PROGRESS','test_resource_a','StackOutputsTest-273854717-test_resource_a-gzkddurdnc5s','state changed','OS::Heat::TestResource',NULL,110),(624,'53bef6c3-ec4e-4f99-a5f6-d26dcd1e7073','a33e8fb8-3ca2-49dd-841b-997a458f8276','2025-12-06 04:30:39',NULL,'DELETE','COMPLETE','test_resource_a','StackOutputsTest-273854717-test_resource_a-gzkddurdnc5s','state changed','OS::Heat::TestResource',NULL,110),(625,'5886d34c-5ccc-4cbe-8640-5554c7aba6bb','a33e8fb8-3ca2-49dd-841b-997a458f8276','2025-12-06 04:30:39',NULL,'DELETE','COMPLETE','StackOutputsTest-273854717','a33e8fb8-3ca2-49dd-841b-997a458f8276','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(626,'4149018a-2899-4878-b5b8-ffc68347d2fb','0bd141bc-a2b7-40be-8e8e-5db3ef2c7195','2025-12-06 04:30:39',NULL,'DELETE','COMPLETE','my_encrypted_vol_type','6d432ce3-b478-4f23-b35d-eef894ccc524','state changed','OS::Cinder::EncryptedVolumeType',NULL,112),(627,'a5e87a62-6cc8-4c11-aa3a-078591eed537','0bd141bc-a2b7-40be-8e8e-5db3ef2c7195','2025-12-06 04:30:39',NULL,'DELETE','IN_PROGRESS','my_volume_type','6d432ce3-b478-4f23-b35d-eef894ccc524','state changed','OS::Cinder::VolumeType',NULL,107),(628,'7d4ca1cf-dd30-452f-a40d-7704e233fa19','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:39',NULL,'DELETE','COMPLETE','trunk','aed9f568-4f24-4115-be1d-bd1a705419fc','state changed','OS::Neutron::Trunk',NULL,109),(629,'b446d1e7-6b28-41e8-99dd-5598f4ab0035','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:39',NULL,'DELETE','IN_PROGRESS','sub_port_one','9cb8d158-a67c-4757-8b63-9804330f4266','state changed','OS::Neutron::Port',NULL,102),(630,'85596e23-d994-4497-9a22-f50dba6dbbc6','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:39',NULL,'DELETE','IN_PROGRESS','parent_port','824cc269-1e9b-4cbc-a946-131e5c0d4b52','state changed','OS::Neutron::Port',NULL,99),(631,'cb4a55cd-8d6c-4689-a812-792257bfce1d','0bd141bc-a2b7-40be-8e8e-5db3ef2c7195','2025-12-06 04:30:40',NULL,'DELETE','COMPLETE','my_volume_type','6d432ce3-b478-4f23-b35d-eef894ccc524','state changed','OS::Cinder::VolumeType',NULL,107),(632,'66b9e481-8ac9-464d-bab2-16d0a5858d92','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:40',NULL,'DELETE','COMPLETE','sub_port_two','9d74a47d-55b6-45cf-bb76-83f78a7ff83d','state changed','OS::Neutron::Port',NULL,100),(633,'9d35be94-9c92-496b-9f68-0a35182025d8','0bd141bc-a2b7-40be-8e8e-5db3ef2c7195','2025-12-06 04:30:40',NULL,'DELETE','COMPLETE','EncryptionVolTypeTest-674294388','0bd141bc-a2b7-40be-8e8e-5db3ef2c7195','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(634,'84f66980-46ba-418c-99a8-8712c1c94141','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:40',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','f3d81ea1-954c-48e6-b64e-a5c257c47e93','state changed','OS::Neutron::Subnet',NULL,98),(635,'13834e93-f118-4378-a2a9-1688baeba569','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:41',NULL,'DELETE','COMPLETE','parent_port','824cc269-1e9b-4cbc-a946-131e5c0d4b52','state changed','OS::Neutron::Port',NULL,99),(636,'01016b7d-8e15-4116-8d0b-3b5a040fd732','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:41',NULL,'DELETE','COMPLETE','trunk_subnet_two','f3d81ea1-954c-48e6-b64e-a5c257c47e93','state changed','OS::Neutron::Subnet',NULL,98),(637,'af2061c5-a61a-4f37-90a7-a42d6ce4abb5','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:41',NULL,'DELETE','COMPLETE','sub_port_one','9cb8d158-a67c-4757-8b63-9804330f4266','state changed','OS::Neutron::Port',NULL,102),(638,'a03cbecd-182f-4756-b326-f42727644e7b','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:41',NULL,'DELETE','IN_PROGRESS','parent_subnet','3249f11a-1dd2-4e03-a1f5-6bd78f9c9f9e','state changed','OS::Neutron::Subnet',NULL,94),(639,'5ec1b42a-45c0-44f1-a99b-e5bce5e6e835','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:41',NULL,'DELETE','IN_PROGRESS','trunk_net_two','20dd2613-44e6-4998-ab0a-e8f764b9da7a','state changed','OS::Neutron::Net',NULL,NULL),(640,'67e69083-1d5a-426e-b996-ea64ce38f5d9','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:41',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','789b2b25-b41a-4788-9eff-869eb6882b3b','state changed','OS::Neutron::Subnet',NULL,97),(641,'8b833c06-3160-4d53-9abc-473ee504d427','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:41',NULL,'DELETE','COMPLETE','parent_subnet','3249f11a-1dd2-4e03-a1f5-6bd78f9c9f9e','state changed','OS::Neutron::Subnet',NULL,94),(642,'c9c544d6-06e3-4d70-b722-52b1e2f3b545','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:41',NULL,'DELETE','COMPLETE','trunk_subnet_one','789b2b25-b41a-4788-9eff-869eb6882b3b','state changed','OS::Neutron::Subnet',NULL,97),(643,'921a81ae-d87a-4671-a0af-edabf5149c70','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:41',NULL,'DELETE','IN_PROGRESS','parent_net','3626f49b-d25a-47bc-b0e6-67d1efcee15e','state changed','OS::Neutron::Net',NULL,NULL),(644,'0299f412-686c-40df-8671-978efdc25c07','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:41',NULL,'DELETE','IN_PROGRESS','trunk_net_one','6d4c3934-38d3-4d9d-b4c9-a99c3d909ed5','state changed','OS::Neutron::Net',NULL,NULL),(645,'5bdb066c-cec7-429c-9819-e8d77cbad428','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:42',NULL,'DELETE','COMPLETE','trunk_net_two','20dd2613-44e6-4998-ab0a-e8f764b9da7a','state changed','OS::Neutron::Net',NULL,NULL),(646,'32f5792c-5171-433f-b9f5-31b6d396a05c','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:42',NULL,'DELETE','COMPLETE','parent_net','3626f49b-d25a-47bc-b0e6-67d1efcee15e','state changed','OS::Neutron::Net',NULL,NULL),(647,'13631054-b2bc-4506-871c-7c8d3f96dacb','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:42',NULL,'DELETE','COMPLETE','trunk_net_one','6d4c3934-38d3-4d9d-b4c9-a99c3d909ed5','state changed','OS::Neutron::Net',NULL,NULL),(648,'5a619a17-f9e8-48a1-87f0-c01fc3e2ae16','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:42',NULL,'DELETE','COMPLETE','UpdateTrunkTest-720889307','cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(649,'f48112e0-e4fc-44c4-bfa5-61289cf5df03','da340568-cbbe-4bc8-a4f2-1aea8f33a257','2025-12-06 04:30:47',NULL,'CREATE','IN_PROGRESS','add_network','da340568-cbbe-4bc8-a4f2-1aea8f33a257','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(650,'9ec699ab-161b-4013-b5d7-c1af6ad1f45e','da340568-cbbe-4bc8-a4f2-1aea8f33a257','2025-12-06 04:30:47',NULL,'CREATE','IN_PROGRESS','net','add_network-net-iedsa4gurnp6','state changed','OS::Neutron::Net',NULL,114),(651,'44d0d995-edf2-4c9b-b9b2-fd85ade5d8b2','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:30:48',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-876755024','e8d5aee7-ee2c-447f-84cc-f35318b33d01','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(652,'71c50bcd-2b47-4a85-b3c2-ea18b772e6d8','da340568-cbbe-4bc8-a4f2-1aea8f33a257','2025-12-06 04:30:49',NULL,'CREATE','COMPLETE','net','2237eb6d-3e36-4313-a59c-11790910609f','state changed','OS::Neutron::Net',NULL,114),(653,'335c8dd8-d591-4782-bafe-c0ff5a347415','da340568-cbbe-4bc8-a4f2-1aea8f33a257','2025-12-06 04:30:49',NULL,'CREATE','IN_PROGRESS','subnet','add_network-subnet-o6lhcujyqepl','state changed','OS::Neutron::Subnet',NULL,115),(654,'013aa869-5da3-47a4-bcda-52264e172019','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:30:49',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-876755024-parent_net-bgzjabttycdo','state changed','OS::Neutron::Net',NULL,NULL),(655,'57d4a48d-63db-4977-8dac-111dbee7aafc','65323099-7274-4625-8062-8976b050a5e9','2025-12-06 04:30:49',NULL,'CREATE','IN_PROGRESS','TemplateAPITest-182259896','65323099-7274-4625-8062-8976b050a5e9','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(656,'d4098b26-5605-4777-a70b-3b2453e96c89','65323099-7274-4625-8062-8976b050a5e9','2025-12-06 04:30:49',NULL,'CREATE','IN_PROGRESS','test1','TemplateAPITest-182259896-test1-2ve2gftczpca','state changed','OS::Heat::TestResource',NULL,116),(657,'2e3bed8a-300c-4f9f-834b-8c7d52cff2de','65323099-7274-4625-8062-8976b050a5e9','2025-12-06 04:30:49',NULL,'CREATE','COMPLETE','test1','TemplateAPITest-182259896-test1-2ve2gftczpca','state changed','OS::Heat::TestResource',NULL,116),(658,'7395c8ee-f06d-44db-a2fa-791bd1588257','65323099-7274-4625-8062-8976b050a5e9','2025-12-06 04:30:49',NULL,'CREATE','COMPLETE','TemplateAPITest-182259896','65323099-7274-4625-8062-8976b050a5e9','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(659,'032e0a09-2241-498b-9c0c-a2c291465f33','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:30:50',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-876755024-trunk_net_two-aw5yecfsmvax','state changed','OS::Neutron::Net',NULL,NULL),(660,'a92b8dac-4cee-423e-9bff-49be59eab1f3','65323099-7274-4625-8062-8976b050a5e9','2025-12-06 04:30:50',NULL,'DELETE','IN_PROGRESS','TemplateAPITest-182259896','65323099-7274-4625-8062-8976b050a5e9','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(661,'8e1674e7-c096-41a2-9f6a-c67fc7661ddf','65323099-7274-4625-8062-8976b050a5e9','2025-12-06 04:30:50',NULL,'DELETE','IN_PROGRESS','test1','TemplateAPITest-182259896-test1-2ve2gftczpca','state changed','OS::Heat::TestResource',NULL,116),(662,'97a86a8d-8168-492f-a26f-8070e054e5ad','65323099-7274-4625-8062-8976b050a5e9','2025-12-06 04:30:51',NULL,'DELETE','COMPLETE','test1','TemplateAPITest-182259896-test1-2ve2gftczpca','state changed','OS::Heat::TestResource',NULL,116),(663,'41f7ae53-e814-4d87-b938-3bafb5fde07d','65323099-7274-4625-8062-8976b050a5e9','2025-12-06 04:30:51',NULL,'DELETE','COMPLETE','TemplateAPITest-182259896','65323099-7274-4625-8062-8976b050a5e9','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(664,'08b882e3-f723-415a-8297-f7309983d100','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:30:51',NULL,'CREATE','COMPLETE','parent_net','240ebf34-37fc-46fd-b18a-26c97d25bff1','state changed','OS::Neutron::Net',NULL,NULL),(665,'062c3337-a61e-4382-8e3c-de283750d2b4','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:30:51',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-876755024-parent_subnet-bz3lhes54bys','state changed','OS::Neutron::Subnet',NULL,117),(666,'0d637f1f-e642-4a12-ab5b-55658016152d','da340568-cbbe-4bc8-a4f2-1aea8f33a257','2025-12-06 04:30:51',NULL,'CREATE','COMPLETE','subnet','b0dcf160-b51e-451c-b2ae-a8d3149f4a3a','state changed','OS::Neutron::Subnet',NULL,115),(667,'a760bb5c-eea3-4d67-beca-c44d571498cf','da340568-cbbe-4bc8-a4f2-1aea8f33a257','2025-12-06 04:30:51',NULL,'CREATE','IN_PROGRESS','server','add_network-server-q4g4mxnanklm','state changed','OS::Nova::Server',NULL,118),(668,'238dbe01-6b69-484b-ba4d-28aaa4b75952','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:30:51',NULL,'CREATE','COMPLETE','trunk_net_two','960af457-30ff-4e1d-8751-c5b69ce4cbb0','state changed','OS::Neutron::Net',NULL,NULL),(669,'c01e5646-566f-4a71-998f-1b9e68beec54','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:30:51',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-876755024-trunk_net_one-lgsmgkuvp6sp','state changed','OS::Neutron::Net',NULL,NULL),(670,'10494751-508f-43fe-8833-b5d5df6408f2','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:30:51',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-876755024-trunk_subnet_two-de2rp4r4kohn','state changed','OS::Neutron::Subnet',NULL,119),(671,'c9881fb1-7444-40c3-8022-59deea067365','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:30:53',NULL,'CREATE','COMPLETE','parent_subnet','1d03f59f-2c99-454d-aff2-1b1217cbf64b','state changed','OS::Neutron::Subnet',NULL,117),(672,'9043155e-5222-4d95-a67f-1abdf2295618','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:30:53',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-876755024-parent_port-pjwrdoo7hq3x','state changed','OS::Neutron::Port',NULL,120),(673,'24008be0-b8af-4e49-bdcb-7ee758deb079','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:30:53',NULL,'CREATE','COMPLETE','trunk_net_one','f1cc897d-b0f7-441e-87c1-bc21ce5fad5b','state changed','OS::Neutron::Net',NULL,NULL),(674,'c130770f-4f47-44bb-9a21-1d3e515d5834','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:30:53',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-876755024-trunk_subnet_one-upghalcn6pfi','state changed','OS::Neutron::Subnet',NULL,121),(675,'d79e77d3-fa8d-4a40-bc21-c41357079fe7','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:30:54',NULL,'CREATE','COMPLETE','trunk_subnet_two','4118a631-a799-4811-a85d-61fbd58133f7','state changed','OS::Neutron::Subnet',NULL,119),(676,'0d82187a-b038-4784-8ac0-fa044b0eea2b','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:30:54',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-876755024-sub_port_two-xdpawxwvs5ea','state changed','OS::Neutron::Port',NULL,122),(677,'8da019df-09f6-40ea-9400-6a90faa221e1','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:30:55',NULL,'CREATE','COMPLETE','trunk_subnet_one','4bbae0e7-9dec-44fa-b675-fcf2ff4ad47a','state changed','OS::Neutron::Subnet',NULL,121),(678,'39be6ff5-ad16-4f88-aed4-1acc1585bfab','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:30:56',NULL,'CREATE','COMPLETE','parent_port','e337482a-3064-431b-b6ad-1cdbbea8e499','state changed','OS::Neutron::Port',NULL,120),(679,'fa0a5494-16d4-4c99-89ce-e074c5e7e624','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:30:56',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-876755024-sub_port_one-usfwymodis2t','state changed','OS::Neutron::Port',NULL,123),(680,'51510026-fc78-4b88-91c7-a6a4a953aa39','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:30:56',NULL,'CREATE','COMPLETE','sub_port_two','eb2e03fb-1081-41e7-bea2-1a7a722b1c90','state changed','OS::Neutron::Port',NULL,122),(681,'23bcbcd6-229e-451f-9625-e0453f012e1b','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:30:57',NULL,'CREATE','COMPLETE','sub_port_one','c0397dd1-a778-4ae2-8c92-4a263a3e7f1f','state changed','OS::Neutron::Port',NULL,123),(682,'87c6547e-eb95-42ba-b3d8-5420f672776f','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:30:57',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-876755024-trunk-4vmlckwxn6eb','state changed','OS::Neutron::Trunk',NULL,124),(683,'f92710b1-fcb6-479f-8479-ce949a98c5a6','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:01',NULL,'CREATE','COMPLETE','trunk','374a4087-7783-4f79-b6f0-bc018584cd3d','state changed','OS::Neutron::Trunk',NULL,124),(684,'79122c99-f22d-4301-972e-ef4d8feabe71','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:01',NULL,'CREATE','COMPLETE','UpdateTrunkTest-876755024','e8d5aee7-ee2c-447f-84cc-f35318b33d01','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(685,'6967c42a-dcc6-4921-b569-78514a1196e8','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:07',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-876755024','e8d5aee7-ee2c-447f-84cc-f35318b33d01','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(686,'751981c3-fe20-4262-a152-220c572d2fae','da340568-cbbe-4bc8-a4f2-1aea8f33a257','2025-12-06 04:31:09',NULL,'CREATE','COMPLETE','server','d54f68c6-285a-4029-8ffa-f3567194b92b','state changed','OS::Nova::Server',NULL,118),(687,'df2c6e02-9c82-41ad-8548-e3fb7b429c54','da340568-cbbe-4bc8-a4f2-1aea8f33a257','2025-12-06 04:31:09',NULL,'CREATE','COMPLETE','add_network','da340568-cbbe-4bc8-a4f2-1aea8f33a257','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(688,'0e066ea0-82c3-42ca-a08a-ac515d881615','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:11',NULL,'UPDATE','IN_PROGRESS','trunk','374a4087-7783-4f79-b6f0-bc018584cd3d','state changed','OS::Neutron::Trunk',NULL,124),(689,'db3e1366-289e-41fa-a6b0-fbddc4a5ae32','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:13',NULL,'UPDATE','COMPLETE','trunk','374a4087-7783-4f79-b6f0-bc018584cd3d','state changed','OS::Neutron::Trunk',NULL,125),(690,'db39c2fa-b492-488d-b55d-47054a478359','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:13',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-876755024','e8d5aee7-ee2c-447f-84cc-f35318b33d01','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(691,'25aea265-50d8-4cd9-8283-91602f03f1ea','da340568-cbbe-4bc8-a4f2-1aea8f33a257','2025-12-06 04:31:16',NULL,'UPDATE','IN_PROGRESS','add_network','da340568-cbbe-4bc8-a4f2-1aea8f33a257','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(692,'eb6d65cd-dbc0-4e81-8020-b0809eb40efa','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:16',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-876755024','e8d5aee7-ee2c-447f-84cc-f35318b33d01','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(693,'1af79262-bccf-4619-8c45-9cbc98f46d1f','da340568-cbbe-4bc8-a4f2-1aea8f33a257','2025-12-06 04:31:17',NULL,'UPDATE','IN_PROGRESS','server','d54f68c6-285a-4029-8ffa-f3567194b92b','state changed','OS::Nova::Server',NULL,118),(694,'67ab741d-a4d2-482a-8bd1-2b976332881f','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:17',NULL,'DELETE','IN_PROGRESS','sub_port_two','eb2e03fb-1081-41e7-bea2-1a7a722b1c90','state changed','OS::Neutron::Port',NULL,122),(695,'1ae8e70c-c1f6-4911-a33b-c04d71264fb7','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:18',NULL,'DELETE','IN_PROGRESS','trunk','374a4087-7783-4f79-b6f0-bc018584cd3d','state changed','OS::Neutron::Trunk',NULL,125),(696,'45946fda-1650-4a1a-b345-182a58d4b194','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:18',NULL,'DELETE','COMPLETE','sub_port_two','eb2e03fb-1081-41e7-bea2-1a7a722b1c90','state changed','OS::Neutron::Port',NULL,122),(697,'bfd9824f-8d2a-4f80-948b-74de8abb0492','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:18',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','4118a631-a799-4811-a85d-61fbd58133f7','state changed','OS::Neutron::Subnet',NULL,119),(698,'b16a9d9b-719f-4b8a-817a-b2ffd8d0f2af','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:18',NULL,'DELETE','COMPLETE','trunk','374a4087-7783-4f79-b6f0-bc018584cd3d','state changed','OS::Neutron::Trunk',NULL,125),(699,'8fbd4a2a-4a5b-4dfa-a891-bf174ef42025','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:18',NULL,'DELETE','IN_PROGRESS','parent_port','e337482a-3064-431b-b6ad-1cdbbea8e499','state changed','OS::Neutron::Port',NULL,120),(700,'dcefc654-1077-488d-b13c-79a2641a0257','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:18',NULL,'DELETE','IN_PROGRESS','sub_port_one','c0397dd1-a778-4ae2-8c92-4a263a3e7f1f','state changed','OS::Neutron::Port',NULL,123),(701,'6b08154d-2628-4f89-afee-a51f0ced8296','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:18',NULL,'DELETE','COMPLETE','trunk_subnet_two','4118a631-a799-4811-a85d-61fbd58133f7','state changed','OS::Neutron::Subnet',NULL,119),(702,'42ecf0d2-7ee8-4c64-b0d7-0748361e8f89','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:18',NULL,'DELETE','IN_PROGRESS','trunk_net_two','960af457-30ff-4e1d-8751-c5b69ce4cbb0','state changed','OS::Neutron::Net',NULL,NULL),(703,'c8347977-0678-4556-b7bc-f141f4d50a7a','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:19',NULL,'DELETE','COMPLETE','parent_port','e337482a-3064-431b-b6ad-1cdbbea8e499','state changed','OS::Neutron::Port',NULL,120),(704,'0735844f-9ff8-4ece-b9e7-1dbb7fc9182d','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:19',NULL,'DELETE','IN_PROGRESS','parent_subnet','1d03f59f-2c99-454d-aff2-1b1217cbf64b','state changed','OS::Neutron::Subnet',NULL,117),(705,'4199fbc7-c725-4ba9-9a59-6c3784568b0e','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:19',NULL,'DELETE','COMPLETE','sub_port_one','c0397dd1-a778-4ae2-8c92-4a263a3e7f1f','state changed','OS::Neutron::Port',NULL,123),(706,'ae80398b-cdd3-4334-8db1-d0c662818d57','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:19',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','4bbae0e7-9dec-44fa-b675-fcf2ff4ad47a','state changed','OS::Neutron::Subnet',NULL,121),(707,'ada72f2a-bd8a-4873-bfe2-05ee4cdf4d29','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:20',NULL,'DELETE','COMPLETE','trunk_net_two','960af457-30ff-4e1d-8751-c5b69ce4cbb0','state changed','OS::Neutron::Net',NULL,NULL),(708,'2e1826c3-2e07-496a-9886-af6bfb9730d2','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:20',NULL,'DELETE','COMPLETE','parent_subnet','1d03f59f-2c99-454d-aff2-1b1217cbf64b','state changed','OS::Neutron::Subnet',NULL,117),(709,'49040ed8-4890-482f-893d-5ef8a0268795','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:20',NULL,'DELETE','IN_PROGRESS','parent_net','240ebf34-37fc-46fd-b18a-26c97d25bff1','state changed','OS::Neutron::Net',NULL,NULL),(710,'baa24234-8168-4c02-99bb-6c8db929f533','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:20',NULL,'DELETE','COMPLETE','trunk_subnet_one','4bbae0e7-9dec-44fa-b675-fcf2ff4ad47a','state changed','OS::Neutron::Subnet',NULL,121),(711,'bcf7110e-f4b7-470d-ae40-c547f5306638','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:20',NULL,'DELETE','IN_PROGRESS','trunk_net_one','f1cc897d-b0f7-441e-87c1-bc21ce5fad5b','state changed','OS::Neutron::Net',NULL,NULL),(712,'85163ce3-5c60-4af1-9445-85903c81cda5','da340568-cbbe-4bc8-a4f2-1aea8f33a257','2025-12-06 04:31:20',NULL,'UPDATE','COMPLETE','server','d54f68c6-285a-4029-8ffa-f3567194b92b','state changed','OS::Nova::Server',NULL,128),(713,'8a3b8a0b-a8ab-4e3c-a6f7-86b59ba57e20','da340568-cbbe-4bc8-a4f2-1aea8f33a257','2025-12-06 04:31:20',NULL,'UPDATE','COMPLETE','add_network','da340568-cbbe-4bc8-a4f2-1aea8f33a257','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(714,'fc50b4dc-3263-4ea7-a053-bf5e9f0791b8','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:21',NULL,'DELETE','COMPLETE','parent_net','240ebf34-37fc-46fd-b18a-26c97d25bff1','state changed','OS::Neutron::Net',NULL,NULL),(715,'fb47aec9-f9b4-4fb5-b5d7-ee7893ece362','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:21',NULL,'DELETE','COMPLETE','trunk_net_one','f1cc897d-b0f7-441e-87c1-bc21ce5fad5b','state changed','OS::Neutron::Net',NULL,NULL),(716,'5a1bac50-5bcb-40ad-9871-1a23e884ca86','e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:31:21',NULL,'DELETE','COMPLETE','UpdateTrunkTest-876755024','e8d5aee7-ee2c-447f-84cc-f35318b33d01','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(717,'d817220f-752d-47b8-b4c8-b62d6cdd4462','da340568-cbbe-4bc8-a4f2-1aea8f33a257','2025-12-06 04:31:23',NULL,'DELETE','IN_PROGRESS','add_network','da340568-cbbe-4bc8-a4f2-1aea8f33a257','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(718,'0648f8c2-f68a-4efa-9eaa-4345de944cdb','da340568-cbbe-4bc8-a4f2-1aea8f33a257','2025-12-06 04:31:23',NULL,'DELETE','IN_PROGRESS','server','d54f68c6-285a-4029-8ffa-f3567194b92b','state changed','OS::Nova::Server',NULL,128),(719,'b2cd8f92-5767-44f7-88e8-05a0ea80e6a4','da340568-cbbe-4bc8-a4f2-1aea8f33a257','2025-12-06 04:31:25',NULL,'DELETE','COMPLETE','server','d54f68c6-285a-4029-8ffa-f3567194b92b','state changed','OS::Nova::Server',NULL,128),(720,'dfe3da26-fb0b-4673-b4ec-704c8b2bc01a','da340568-cbbe-4bc8-a4f2-1aea8f33a257','2025-12-06 04:31:25',NULL,'DELETE','IN_PROGRESS','subnet','b0dcf160-b51e-451c-b2ae-a8d3149f4a3a','state changed','OS::Neutron::Subnet',NULL,115),(721,'cb71a6e9-c5e5-4dff-9bec-d88f3950df68','da340568-cbbe-4bc8-a4f2-1aea8f33a257','2025-12-06 04:31:26',NULL,'DELETE','COMPLETE','subnet','b0dcf160-b51e-451c-b2ae-a8d3149f4a3a','state changed','OS::Neutron::Subnet',NULL,115),(722,'d45b2937-9730-41e8-88fa-ced007d4ac92','da340568-cbbe-4bc8-a4f2-1aea8f33a257','2025-12-06 04:31:26',NULL,'DELETE','IN_PROGRESS','net','2237eb6d-3e36-4313-a59c-11790910609f','state changed','OS::Neutron::Net',NULL,114),(723,'9fe4f559-0f12-4f49-a20e-6bfe1aa38758','da340568-cbbe-4bc8-a4f2-1aea8f33a257','2025-12-06 04:31:27',NULL,'DELETE','COMPLETE','net','2237eb6d-3e36-4313-a59c-11790910609f','state changed','OS::Neutron::Net',NULL,114),(724,'cca47809-5f21-4233-91a4-530c43df2c95','da340568-cbbe-4bc8-a4f2-1aea8f33a257','2025-12-06 04:31:27',NULL,'DELETE','COMPLETE','add_network','da340568-cbbe-4bc8-a4f2-1aea8f33a257','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(725,'618d2696-8a84-4ceb-81ea-e7e3ab7146c8','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:28',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-1063395537','972e8df9-ff9a-43be-83ca-99885251b30c','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(726,'ebdec4d8-f641-4fa3-b990-b5cf7edcfa01','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:28',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-1063395537-parent_net-dtijaw357lhf','state changed','OS::Neutron::Net',NULL,NULL),(727,'ac26de36-787e-4b89-b6ea-3628d4caaecb','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:29',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-1063395537-trunk_net_two-ngqknnlehx6x','state changed','OS::Neutron::Net',NULL,NULL),(728,'eae133a5-4f08-4ed1-8c39-5822e7165397','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:30',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-1063395537-trunk_net_one-kpm3ez3qw4kz','state changed','OS::Neutron::Net',NULL,NULL),(729,'180f2fba-be5a-4e4f-bd1e-c6747a4ba5cb','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:30',NULL,'CREATE','COMPLETE','parent_net','e0e6655f-2b27-4a53-a7be-e09568428231','state changed','OS::Neutron::Net',NULL,NULL),(730,'118f4c73-b61a-4319-b033-ba1862747c4a','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:30',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-1063395537-parent_subnet-d3heyztgre3y','state changed','OS::Neutron::Subnet',NULL,130),(731,'0f29412e-97c4-4dd4-b2f8-b0977685ed65','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:31',NULL,'CREATE','COMPLETE','trunk_net_two','f1811a43-f9df-42b2-9450-8d36ac731210','state changed','OS::Neutron::Net',NULL,NULL),(732,'f3b994bc-3f14-473f-94c2-82a98de2dbe5','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:31',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-1063395537-trunk_subnet_two-flrmliuycsna','state changed','OS::Neutron::Subnet',NULL,131),(733,'0593f2b4-e257-4f79-a7e6-32f1eb355123','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:33',NULL,'CREATE','COMPLETE','trunk_net_one','256b0bf6-7f6b-429c-83ce-04c6322c5ef3','state changed','OS::Neutron::Net',NULL,NULL),(734,'3d181b17-dc48-46a2-a5f7-c307b5829a97','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:34',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-1063395537-trunk_subnet_one-q3i5cu5oe6jm','state changed','OS::Neutron::Subnet',NULL,132),(735,'44adaaed-9d86-40a9-ac78-8e920f27d386','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:35',NULL,'CREATE','COMPLETE','parent_subnet','e9c7c446-567e-4862-a73a-6f3d6f748ff3','state changed','OS::Neutron::Subnet',NULL,130),(736,'dd5cda35-bac4-4c3e-9eea-7cb522d26716','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:35',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-1063395537-parent_port-eok4vf45yc56','state changed','OS::Neutron::Port',NULL,133),(737,'42789274-5753-4b82-810b-ad8b11f55a3e','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','2025-12-06 04:31:35',NULL,'CREATE','IN_PROGRESS','same_fixed_ip','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(738,'6114e995-f2d3-45e0-a648-c22c778d5cce','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:35',NULL,'CREATE','COMPLETE','trunk_subnet_two','742878d1-50b9-4107-9871-6cdbfaf9a209','state changed','OS::Neutron::Subnet',NULL,131),(739,'603e30d9-0bbf-4491-84bb-d1b4437cf69b','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','2025-12-06 04:31:35',NULL,'CREATE','IN_PROGRESS','net','same_fixed_ip-net-infipkinipa4','state changed','OS::Neutron::Net',NULL,134),(740,'6acff991-8a63-4284-ad32-f42485c7f2cb','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:35',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-1063395537-sub_port_two-w7a5aqxztzpg','state changed','OS::Neutron::Port',NULL,135),(741,'f3bb4962-7fb7-4c07-b89d-7f56862dd353','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:36',NULL,'CREATE','COMPLETE','trunk_subnet_one','00c5c1e6-743d-4637-a68c-94c1191ab1fc','state changed','OS::Neutron::Subnet',NULL,132),(742,'d1b0dc9a-871b-4c43-b0a4-af3e6a8db311','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:36',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-1063395537-sub_port_one-oqgag3m2xud3','state changed','OS::Neutron::Port',NULL,136),(743,'f8ad8bf7-0289-4ccf-a49e-d06c4aa2b2d0','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:36',NULL,'CREATE','COMPLETE','parent_port','76807028-ffa3-4aa8-9fc7-109a2068d319','state changed','OS::Neutron::Port',NULL,133),(744,'0c1e7c40-99d1-49cd-ab0a-a0697af21692','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:36',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-1063395537-trunk-5rpff3vxsrop','state changed','OS::Neutron::Trunk',NULL,137),(745,'8d76effa-a3f6-45bf-8249-31bfbdd70a44','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','2025-12-06 04:31:36',NULL,'CREATE','COMPLETE','net','9c133d0f-4804-41d4-80e5-5e7664269226','state changed','OS::Neutron::Net',NULL,134),(746,'9169b4cd-8dc2-4910-bfa4-f7bc6d4976de','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','2025-12-06 04:31:37',NULL,'CREATE','IN_PROGRESS','subnet','same_fixed_ip-subnet-pqlucbna4ffx','state changed','OS::Neutron::Subnet',NULL,138),(747,'bc994ef7-c2bb-4067-bcd0-474f3d5a62e1','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:37',NULL,'CREATE','COMPLETE','sub_port_two','bbd0b03f-365b-4ab9-b9d2-0146af3f4aaf','state changed','OS::Neutron::Port',NULL,135),(748,'a9c47559-db8b-4cec-9905-557defe884d1','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:37',NULL,'CREATE','COMPLETE','sub_port_one','d14cc36f-906d-43e7-988e-00efdf4f335f','state changed','OS::Neutron::Port',NULL,136),(749,'e9cea387-f833-47f4-8e6c-9d7585f5927e','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:37',NULL,'CREATE','COMPLETE','trunk','c655f07e-b900-4fb7-b2c5-7cc8258355de','state changed','OS::Neutron::Trunk',NULL,137),(750,'caa8ccac-1942-44ee-b65c-58596596aae1','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:37',NULL,'CREATE','COMPLETE','UpdateTrunkTest-1063395537','972e8df9-ff9a-43be-83ca-99885251b30c','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(751,'cdf7847c-3858-4c4b-ad4c-14ba1ad6966a','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','2025-12-06 04:31:38',NULL,'CREATE','COMPLETE','subnet','61b02501-a543-49ec-a25e-9648f4ba8734','state changed','OS::Neutron::Subnet',NULL,138),(752,'895d7304-1981-49e4-bb97-3f599674947b','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','2025-12-06 04:31:38',NULL,'CREATE','IN_PROGRESS','server','same_fixed_ip-server-uazrf77ewuvy','state changed','OS::Nova::Server',NULL,139),(753,'0fa1110c-1c9f-41fe-a6fc-c647e8321bf8','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:41',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-1063395537','972e8df9-ff9a-43be-83ca-99885251b30c','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(754,'f7a8714e-da9c-43b4-9175-e009c6b934c1','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:45',NULL,'UPDATE','IN_PROGRESS','trunk','c655f07e-b900-4fb7-b2c5-7cc8258355de','state changed','OS::Neutron::Trunk',NULL,137),(755,'7d0199d2-70be-48a7-9bf7-71313b505bef','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:46',NULL,'UPDATE','COMPLETE','trunk','c655f07e-b900-4fb7-b2c5-7cc8258355de','state changed','OS::Neutron::Trunk',NULL,140),(756,'fe5d5ba0-7f4b-4713-8e48-bfb7f29c7df1','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:46',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-1063395537','972e8df9-ff9a-43be-83ca-99885251b30c','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(757,'891855a3-9021-4cb0-bb4f-64e98218216d','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:51',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-1063395537','972e8df9-ff9a-43be-83ca-99885251b30c','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(758,'5d33f55f-68a3-4a30-ba16-f42c84931c2f','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:51',NULL,'DELETE','IN_PROGRESS','trunk','c655f07e-b900-4fb7-b2c5-7cc8258355de','state changed','OS::Neutron::Trunk',NULL,140),(759,'3284c202-fa67-41a5-bd88-bc6515021531','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:51',NULL,'DELETE','COMPLETE','trunk','c655f07e-b900-4fb7-b2c5-7cc8258355de','state changed','OS::Neutron::Trunk',NULL,140),(760,'a929970e-8475-43b0-896f-8e42c1c8e1e1','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:51',NULL,'DELETE','IN_PROGRESS','parent_port','76807028-ffa3-4aa8-9fc7-109a2068d319','state changed','OS::Neutron::Port',NULL,133),(761,'65c0d5a9-9a37-4dab-81ee-045cbfbb3774','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:52',NULL,'DELETE','IN_PROGRESS','sub_port_two','bbd0b03f-365b-4ab9-b9d2-0146af3f4aaf','state changed','OS::Neutron::Port',NULL,135),(762,'555a1d21-0e91-407c-81c8-4431b992e8b4','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:52',NULL,'DELETE','COMPLETE','parent_port','76807028-ffa3-4aa8-9fc7-109a2068d319','state changed','OS::Neutron::Port',NULL,133),(763,'4aea1b54-1537-479c-88ae-27e070d337b8','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:52',NULL,'DELETE','IN_PROGRESS','parent_subnet','e9c7c446-567e-4862-a73a-6f3d6f748ff3','state changed','OS::Neutron::Subnet',NULL,130),(764,'18ee7e82-d0fe-464d-ad51-9ac82fd9b15e','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:53',NULL,'DELETE','COMPLETE','sub_port_two','bbd0b03f-365b-4ab9-b9d2-0146af3f4aaf','state changed','OS::Neutron::Port',NULL,135),(765,'bb274818-b4dc-4ac9-92e2-1da3f2f021de','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:53',NULL,'DELETE','COMPLETE','parent_subnet','e9c7c446-567e-4862-a73a-6f3d6f748ff3','state changed','OS::Neutron::Subnet',NULL,130),(766,'ac76d6b2-0ca3-4b0e-9c20-49908b1d4e72','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:53',NULL,'DELETE','IN_PROGRESS','sub_port_one','d14cc36f-906d-43e7-988e-00efdf4f335f','state changed','OS::Neutron::Port',NULL,136),(767,'5cfe8870-ced0-48b0-867b-9e2721335fb0','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:53',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','742878d1-50b9-4107-9871-6cdbfaf9a209','state changed','OS::Neutron::Subnet',NULL,131),(768,'25aa08d1-b661-47c1-9eb3-73cf504dd6cd','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:53',NULL,'DELETE','IN_PROGRESS','parent_net','e0e6655f-2b27-4a53-a7be-e09568428231','state changed','OS::Neutron::Net',NULL,NULL),(769,'6dfd0478-0766-4848-87bc-2423c099a006','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:54',NULL,'DELETE','COMPLETE','trunk_subnet_two','742878d1-50b9-4107-9871-6cdbfaf9a209','state changed','OS::Neutron::Subnet',NULL,131),(770,'f92eb0cc-4560-445f-8a9e-079a87be3cc2','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:54',NULL,'DELETE','COMPLETE','sub_port_one','d14cc36f-906d-43e7-988e-00efdf4f335f','state changed','OS::Neutron::Port',NULL,136),(771,'cf2192e1-7c35-476a-a251-95285747d7a5','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','2025-12-06 04:31:54',NULL,'CREATE','COMPLETE','server','cf9f323c-17b0-45b4-b919-93080f0bc5b1','state changed','OS::Nova::Server',NULL,139),(772,'157a90bc-000d-4872-a54f-6fcc7c6ad231','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:54',NULL,'DELETE','IN_PROGRESS','trunk_net_two','f1811a43-f9df-42b2-9450-8d36ac731210','state changed','OS::Neutron::Net',NULL,NULL),(773,'9c3dcf7c-b839-414d-a16a-0b626b3f6508','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:54',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','00c5c1e6-743d-4637-a68c-94c1191ab1fc','state changed','OS::Neutron::Subnet',NULL,132),(774,'b9424686-1fe0-4952-90fc-c53c4095f1c1','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','2025-12-06 04:31:54',NULL,'CREATE','COMPLETE','same_fixed_ip','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(775,'1d82d9bf-1c01-4ace-b9f2-36eb2a1fa5c2','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:54',NULL,'DELETE','COMPLETE','parent_net','e0e6655f-2b27-4a53-a7be-e09568428231','state changed','OS::Neutron::Net',NULL,NULL),(776,'2476a622-8888-47a8-803e-2605a49b3f2f','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:55',NULL,'DELETE','COMPLETE','trunk_subnet_one','00c5c1e6-743d-4637-a68c-94c1191ab1fc','state changed','OS::Neutron::Subnet',NULL,132),(777,'1989694d-4db3-4e53-932d-14e2fb0931d9','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:55',NULL,'DELETE','IN_PROGRESS','trunk_net_one','256b0bf6-7f6b-429c-83ce-04c6322c5ef3','state changed','OS::Neutron::Net',NULL,NULL),(778,'4784774d-9bfc-43b4-b344-fdda565f0960','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:55',NULL,'DELETE','COMPLETE','trunk_net_two','f1811a43-f9df-42b2-9450-8d36ac731210','state changed','OS::Neutron::Net',NULL,NULL),(779,'37c70bb0-a64a-4d95-8165-b77d6ec1f303','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:56',NULL,'DELETE','COMPLETE','trunk_net_one','256b0bf6-7f6b-429c-83ce-04c6322c5ef3','state changed','OS::Neutron::Net',NULL,NULL),(780,'35f99439-55c5-417a-ae2b-73a319a3e8a3','972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:56',NULL,'DELETE','COMPLETE','UpdateTrunkTest-1063395537','972e8df9-ff9a-43be-83ca-99885251b30c','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(781,'72088fa2-cdab-4755-9670-11432343acaa','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','2025-12-06 04:32:00',NULL,'UPDATE','IN_PROGRESS','same_fixed_ip','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(782,'2ca9da30-a4ac-48d3-8371-bdd94a008753','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','2025-12-06 04:32:02',NULL,'UPDATE','IN_PROGRESS','server','cf9f323c-17b0-45b4-b919-93080f0bc5b1','state changed','OS::Nova::Server',NULL,139),(783,'a2ffd2d9-8dda-47ad-8cae-5db34acd8fb0','b6138931-f064-4bad-82be-d29b893dd3de','2025-12-06 04:32:03',NULL,'CREATE','IN_PROGRESS','ExternalReferencesTest-2005517343','b6138931-f064-4bad-82be-d29b893dd3de','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(784,'014754ae-351e-4c7b-bd3b-98dabfed9153','b6138931-f064-4bad-82be-d29b893dd3de','2025-12-06 04:32:03',NULL,'ADOPT','IN_PROGRESS','test1','ExternalReferencesTest-2005517343-test1-xp5akjwccv56','state changed','OS::Heat::TestResource',NULL,NULL),(785,'8af8ed7b-5f4f-485c-ac5c-c5b92f4a8fd9','b6138931-f064-4bad-82be-d29b893dd3de','2025-12-06 04:32:03',NULL,'ADOPT','COMPLETE','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(786,'9ec43dad-d6fc-431e-8bf6-649b0e814711','b6138931-f064-4bad-82be-d29b893dd3de','2025-12-06 04:32:03',NULL,'CHECK','COMPLETE','test1','foobar','CHECK not supported for OS::Heat::TestResource','OS::Heat::TestResource',NULL,NULL),(787,'17a9da6e-ea72-415f-aab9-fc700601c8c5','b6138931-f064-4bad-82be-d29b893dd3de','2025-12-06 04:32:03',NULL,'CREATE','COMPLETE','ExternalReferencesTest-2005517343','b6138931-f064-4bad-82be-d29b893dd3de','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(788,'44a88357-734f-424d-82aa-a64094e54280','b6138931-f064-4bad-82be-d29b893dd3de','2025-12-06 04:32:04',NULL,'DELETE','IN_PROGRESS','ExternalReferencesTest-2005517343','b6138931-f064-4bad-82be-d29b893dd3de','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(789,'01c23e87-5e87-46e1-b390-9664c3fae089','b6138931-f064-4bad-82be-d29b893dd3de','2025-12-06 04:32:04',NULL,'DELETE','IN_PROGRESS','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(790,'a8497da2-eb52-44d2-b6c3-38ce3c386bcf','b6138931-f064-4bad-82be-d29b893dd3de','2025-12-06 04:32:05',NULL,'DELETE','COMPLETE','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(791,'f921b58a-9d70-445e-9a0e-7023893b0b46','b6138931-f064-4bad-82be-d29b893dd3de','2025-12-06 04:32:05',NULL,'DELETE','COMPLETE','ExternalReferencesTest-2005517343','b6138931-f064-4bad-82be-d29b893dd3de','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(792,'d03cb4be-75b1-4030-aee4-dfeb0c93c300','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','2025-12-06 04:32:09',NULL,'UPDATE','COMPLETE','server','cf9f323c-17b0-45b4-b919-93080f0bc5b1','state changed','OS::Nova::Server',NULL,143),(793,'55ec6dbe-18df-4884-bf5b-8aafb9dd41bc','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','2025-12-06 04:32:09',NULL,'UPDATE','COMPLETE','same_fixed_ip','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(794,'03841884-895d-447e-b453-af2cbc0cfd63','08a33720-ff62-440e-9d6a-2d0217dbf6d4','2025-12-06 04:32:11',NULL,'CREATE','IN_PROGRESS','ExternalReferencesTest-1355638834','08a33720-ff62-440e-9d6a-2d0217dbf6d4','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(795,'10995204-10cd-47ff-b2b5-8c1fd543e8e9','08a33720-ff62-440e-9d6a-2d0217dbf6d4','2025-12-06 04:32:11',NULL,'ADOPT','IN_PROGRESS','test1','ExternalReferencesTest-1355638834-test1-vsjvonnbq5xc','state changed','OS::Heat::TestResource',NULL,NULL),(796,'ff54b41d-d034-498d-b187-dbf421843715','08a33720-ff62-440e-9d6a-2d0217dbf6d4','2025-12-06 04:32:11',NULL,'ADOPT','COMPLETE','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(797,'3ae1ee60-b58d-4fff-a32a-ce3e89adf6c8','08a33720-ff62-440e-9d6a-2d0217dbf6d4','2025-12-06 04:32:11',NULL,'CHECK','COMPLETE','test1','foobar','CHECK not supported for OS::Heat::TestResource','OS::Heat::TestResource',NULL,NULL),(798,'d08329dd-75c7-496f-8c93-e6ce9690bf86','08a33720-ff62-440e-9d6a-2d0217dbf6d4','2025-12-06 04:32:11',NULL,'CREATE','COMPLETE','ExternalReferencesTest-1355638834','08a33720-ff62-440e-9d6a-2d0217dbf6d4','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(799,'48f45750-2f06-4747-b664-f4b12c522d21','08a33720-ff62-440e-9d6a-2d0217dbf6d4','2025-12-06 04:32:13',NULL,'UPDATE','IN_PROGRESS','ExternalReferencesTest-1355638834','08a33720-ff62-440e-9d6a-2d0217dbf6d4','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(800,'3c1e4df6-ab85-405e-b0c0-0b6c8a1ab864','08a33720-ff62-440e-9d6a-2d0217dbf6d4','2025-12-06 04:32:13',NULL,'UPDATE','COMPLETE','ExternalReferencesTest-1355638834','08a33720-ff62-440e-9d6a-2d0217dbf6d4','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(801,'ec59fd2b-dbd9-4234-95fa-40573b944f49','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','2025-12-06 04:32:15',NULL,'DELETE','IN_PROGRESS','same_fixed_ip','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(802,'6df04d10-0422-4d70-b6cb-89382a115da0','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','2025-12-06 04:32:15',NULL,'DELETE','IN_PROGRESS','server','cf9f323c-17b0-45b4-b919-93080f0bc5b1','state changed','OS::Nova::Server',NULL,143),(803,'162d900d-6b32-4ae6-8007-eaa1892dfc03','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','2025-12-06 04:32:18',NULL,'DELETE','COMPLETE','server','cf9f323c-17b0-45b4-b919-93080f0bc5b1','state changed','OS::Nova::Server',NULL,143),(804,'98d14fcb-ffae-4552-96a3-f7b16a0fd268','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','2025-12-06 04:32:18',NULL,'DELETE','IN_PROGRESS','subnet','61b02501-a543-49ec-a25e-9648f4ba8734','state changed','OS::Neutron::Subnet',NULL,138),(805,'67b36c02-7349-46b9-84b8-ced8251bbff7','08a33720-ff62-440e-9d6a-2d0217dbf6d4','2025-12-06 04:32:18',NULL,'DELETE','IN_PROGRESS','ExternalReferencesTest-1355638834','08a33720-ff62-440e-9d6a-2d0217dbf6d4','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(806,'ced2908e-f18d-4965-b248-15031ccac586','08a33720-ff62-440e-9d6a-2d0217dbf6d4','2025-12-06 04:32:18',NULL,'DELETE','IN_PROGRESS','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(807,'3808a3cf-86bf-4058-8846-ea77cbd0710a','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','2025-12-06 04:32:18',NULL,'DELETE','COMPLETE','subnet','61b02501-a543-49ec-a25e-9648f4ba8734','state changed','OS::Neutron::Subnet',NULL,138),(808,'5ed7769c-17cd-433e-baa3-36fcaead45e9','08a33720-ff62-440e-9d6a-2d0217dbf6d4','2025-12-06 04:32:18',NULL,'DELETE','COMPLETE','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(809,'8ce16ce9-6086-4e8a-9144-95097c9faeaf','08a33720-ff62-440e-9d6a-2d0217dbf6d4','2025-12-06 04:32:18',NULL,'DELETE','COMPLETE','ExternalReferencesTest-1355638834','08a33720-ff62-440e-9d6a-2d0217dbf6d4','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(810,'2cf915fe-30fb-4e32-93f4-262b89e0d691','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','2025-12-06 04:32:18',NULL,'DELETE','IN_PROGRESS','net','9c133d0f-4804-41d4-80e5-5e7664269226','state changed','OS::Neutron::Net',NULL,134),(811,'74c93255-53cd-48d4-bca4-f82b39c59a08','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','2025-12-06 04:32:19',NULL,'DELETE','COMPLETE','net','9c133d0f-4804-41d4-80e5-5e7664269226','state changed','OS::Neutron::Net',NULL,134),(812,'e9c29a6f-be6c-47be-a3b0-c95709b6274a','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','2025-12-06 04:32:19',NULL,'DELETE','COMPLETE','same_fixed_ip','9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(813,'51b9c480-ee17-4338-b16d-d2f602f820a7','4c1b238e-4e21-4355-9f20-402770b3e07b','2025-12-06 04:32:22',NULL,'CREATE','IN_PROGRESS','add_subnet','4c1b238e-4e21-4355-9f20-402770b3e07b','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(814,'022742ab-0a89-4be9-8052-133987bb4e7c','4c1b238e-4e21-4355-9f20-402770b3e07b','2025-12-06 04:32:22',NULL,'CREATE','IN_PROGRESS','net','add_subnet-net-m6s3fe7b7bny','state changed','OS::Neutron::Net',NULL,145),(815,'ec2e1486-791d-4a49-a3b2-70ace4ab5526','4c1b238e-4e21-4355-9f20-402770b3e07b','2025-12-06 04:32:23',NULL,'CREATE','COMPLETE','net','f13f304e-89e8-445e-b1aa-4e561c622773','state changed','OS::Neutron::Net',NULL,145),(816,'07986cf8-77b2-416c-aef6-6d56ae4d1469','4c1b238e-4e21-4355-9f20-402770b3e07b','2025-12-06 04:32:23',NULL,'CREATE','IN_PROGRESS','subnet','add_subnet-subnet-dgzmua54kuj3','state changed','OS::Neutron::Subnet',NULL,146),(817,'9a70f9a6-a0f7-4000-a86f-c984850a187b','b852d540-3586-467d-8302-50003be001ce','2025-12-06 04:32:24',NULL,'CREATE','IN_PROGRESS','ExternalReferencesTest-1327548665','b852d540-3586-467d-8302-50003be001ce','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(818,'74c0b586-1ac0-4136-8170-ee397b8254bc','4c1b238e-4e21-4355-9f20-402770b3e07b','2025-12-06 04:32:24',NULL,'CREATE','COMPLETE','subnet','e0684a45-94d6-4841-bfd8-9416f384a41a','state changed','OS::Neutron::Subnet',NULL,146),(819,'4a1a913e-43e8-40d6-b311-6aaf90e08143','b852d540-3586-467d-8302-50003be001ce','2025-12-06 04:32:24',NULL,'CREATE','IN_PROGRESS','test1','ExternalReferencesTest-1327548665-test1-b7qhs3k2cy5z','state changed','OS::Heat::TestResource',NULL,NULL),(820,'f070f00e-060d-4862-a51a-ac97eb979dc3','b852d540-3586-467d-8302-50003be001ce','2025-12-06 04:32:24',NULL,'CREATE','COMPLETE','test1','ExternalReferencesTest-1327548665-test1-b7qhs3k2cy5z','state changed','OS::Heat::TestResource',NULL,NULL),(821,'6b44f02b-549d-44fe-a16c-b2f7bc3cb725','4c1b238e-4e21-4355-9f20-402770b3e07b','2025-12-06 04:32:24',NULL,'CREATE','IN_PROGRESS','server','add_subnet-server-cszm44zem75x','state changed','OS::Nova::Server',NULL,147),(822,'bb14c5dc-6435-49b3-a260-087d89b6bc30','b852d540-3586-467d-8302-50003be001ce','2025-12-06 04:32:24',NULL,'CREATE','COMPLETE','ExternalReferencesTest-1327548665','b852d540-3586-467d-8302-50003be001ce','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(823,'0490b1af-8314-4171-ada1-232ea3954feb','b852d540-3586-467d-8302-50003be001ce','2025-12-06 04:32:25',NULL,'UPDATE','IN_PROGRESS','ExternalReferencesTest-1327548665','b852d540-3586-467d-8302-50003be001ce','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(824,'93765ff7-6dcc-4676-9247-280d6d2148c9','b852d540-3586-467d-8302-50003be001ce','2025-12-06 04:32:25',NULL,'UPDATE','FAILED','ExternalReferencesTest-1327548665','b852d540-3586-467d-8302-50003be001ce','Resource UPDATE failed: NotSupported: resources.test1: Update to property external_id of test1 (OS::Heat::TestResource) is not supported.','OS::Heat::Stack',NULL,NULL),(825,'1c8c38aa-f2ca-494b-8d93-6e7ac8dd0cec','b852d540-3586-467d-8302-50003be001ce','2025-12-06 04:32:29',NULL,'DELETE','IN_PROGRESS','ExternalReferencesTest-1327548665','b852d540-3586-467d-8302-50003be001ce','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(826,'4ccac468-fc52-4821-aabf-e38367e8565a','b852d540-3586-467d-8302-50003be001ce','2025-12-06 04:32:29',NULL,'DELETE','IN_PROGRESS','test1','ExternalReferencesTest-1327548665-test1-b7qhs3k2cy5z','state changed','OS::Heat::TestResource',NULL,NULL),(827,'8e5f8e02-9ed0-458f-a4c9-359ef25559f1','b852d540-3586-467d-8302-50003be001ce','2025-12-06 04:32:29',NULL,'DELETE','COMPLETE','test1','ExternalReferencesTest-1327548665-test1-b7qhs3k2cy5z','state changed','OS::Heat::TestResource',NULL,NULL),(828,'72b9deb3-af62-4910-9499-6f8d8e5439d0','b852d540-3586-467d-8302-50003be001ce','2025-12-06 04:32:29',NULL,'DELETE','COMPLETE','ExternalReferencesTest-1327548665','b852d540-3586-467d-8302-50003be001ce','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(829,'8c2e63fa-aa8f-4a62-9ddd-42263bdb18e7','4c1b238e-4e21-4355-9f20-402770b3e07b','2025-12-06 04:32:34',NULL,'CREATE','COMPLETE','server','409e6523-9f12-42dc-a3b6-bc3aacc607fe','state changed','OS::Nova::Server',NULL,147),(830,'7629b43e-abc1-45ff-ab6c-3609f4ad8159','4c1b238e-4e21-4355-9f20-402770b3e07b','2025-12-06 04:32:34',NULL,'CREATE','COMPLETE','add_subnet','4c1b238e-4e21-4355-9f20-402770b3e07b','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(831,'21a999d0-ab70-4c6a-b508-3a26716b49a1','6cd20e7a-88b2-48da-b03f-5f3b7623c5f5','2025-12-06 04:32:37',NULL,'CREATE','IN_PROGRESS','HooksTest-989875015','6cd20e7a-88b2-48da-b03f-5f3b7623c5f5','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(832,'034b401e-b520-4763-913e-a59f9a290909','6cd20e7a-88b2-48da-b03f-5f3b7623c5f5','2025-12-06 04:32:37',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-989875015-foo_step1-mhnq4nrqehty','state changed','OS::Heat::RandomString',NULL,NULL),(833,'dd85b371-b70a-453f-97bf-328525ea4b83','6cd20e7a-88b2-48da-b03f-5f3b7623c5f5','2025-12-06 04:32:37',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-989875015-foo_step1-mhnq4nrqehty','state changed','OS::Heat::RandomString',NULL,NULL),(834,'d3b74b6e-4020-4f7f-ae03-00193540ddc1','6cd20e7a-88b2-48da-b03f-5f3b7623c5f5','2025-12-06 04:32:38',NULL,'INIT','COMPLETE','foo_step2',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(835,'49a37f96-a084-455c-8643-b5ff949a7c0f','6cd20e7a-88b2-48da-b03f-5f3b7623c5f5','2025-12-06 04:32:42',NULL,'INIT','COMPLETE','foo_step2',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(836,'cc004e90-3f91-4ad9-82ab-50ad811e9d1a','6cd20e7a-88b2-48da-b03f-5f3b7623c5f5','2025-12-06 04:32:42',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-989875015-foo_step2-cfjnbbuw72id','state changed','OS::Heat::RandomString',NULL,NULL),(837,'26c6bd5a-5ae2-4582-8b62-4e683d13a406','4c1b238e-4e21-4355-9f20-402770b3e07b','2025-12-06 04:32:42',NULL,'UPDATE','IN_PROGRESS','add_subnet','4c1b238e-4e21-4355-9f20-402770b3e07b','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(838,'b5c96772-c5eb-464e-ad67-2ca300279a34','4c1b238e-4e21-4355-9f20-402770b3e07b','2025-12-06 04:32:43',NULL,'UPDATE','IN_PROGRESS','server','409e6523-9f12-42dc-a3b6-bc3aacc607fe','state changed','OS::Nova::Server',NULL,147),(839,'99a5ab8a-9de2-4d1c-8198-6e65cee11e99','6cd20e7a-88b2-48da-b03f-5f3b7623c5f5','2025-12-06 04:32:45',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-989875015-foo_step2-cfjnbbuw72id','state changed','OS::Heat::RandomString',NULL,NULL),(840,'3f2b548b-e509-4fe8-b893-183417570f89','6cd20e7a-88b2-48da-b03f-5f3b7623c5f5','2025-12-06 04:32:45',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-989875015-foo_step3-qguwyqhilwrd','state changed','OS::Heat::RandomString',NULL,NULL),(841,'b45dc299-f433-4f18-a459-7ecff24954ed','6cd20e7a-88b2-48da-b03f-5f3b7623c5f5','2025-12-06 04:32:45',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-989875015-foo_step3-qguwyqhilwrd','state changed','OS::Heat::RandomString',NULL,NULL),(842,'4b84d591-d919-4599-8714-c8499718786f','6cd20e7a-88b2-48da-b03f-5f3b7623c5f5','2025-12-06 04:32:45',NULL,'CREATE','COMPLETE','HooksTest-989875015','6cd20e7a-88b2-48da-b03f-5f3b7623c5f5','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(843,'6e606ff5-cef8-431c-8da8-54a7666655b6','6cd20e7a-88b2-48da-b03f-5f3b7623c5f5','2025-12-06 04:32:48',NULL,'DELETE','IN_PROGRESS','HooksTest-989875015','6cd20e7a-88b2-48da-b03f-5f3b7623c5f5','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(844,'a66b2897-6c17-4dde-8405-4e7e55eb4ed2','6cd20e7a-88b2-48da-b03f-5f3b7623c5f5','2025-12-06 04:32:49',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-989875015-foo_step3-qguwyqhilwrd','state changed','OS::Heat::RandomString',NULL,NULL),(845,'41381c5e-697b-4cda-b4e6-e21e577bb219','6cd20e7a-88b2-48da-b03f-5f3b7623c5f5','2025-12-06 04:32:49',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-989875015-foo_step3-qguwyqhilwrd','state changed','OS::Heat::RandomString',NULL,NULL),(846,'c0e6d3dc-39d3-47e0-8389-0fbd02fc14c8','6cd20e7a-88b2-48da-b03f-5f3b7623c5f5','2025-12-06 04:32:50',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-989875015-foo_step2-cfjnbbuw72id','state changed','OS::Heat::RandomString',NULL,NULL),(847,'ab48ad28-db0f-4a36-8d26-54e5bc28582f','6cd20e7a-88b2-48da-b03f-5f3b7623c5f5','2025-12-06 04:32:50',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-989875015-foo_step2-cfjnbbuw72id','state changed','OS::Heat::RandomString',NULL,NULL),(848,'5fb4107e-0bca-4e2b-9d7b-bbf8199687b9','6cd20e7a-88b2-48da-b03f-5f3b7623c5f5','2025-12-06 04:32:50',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-989875015-foo_step1-mhnq4nrqehty','state changed','OS::Heat::RandomString',NULL,NULL),(849,'cfce6a91-5e66-4637-ac7e-3d40931512a3','6cd20e7a-88b2-48da-b03f-5f3b7623c5f5','2025-12-06 04:32:51',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-989875015-foo_step1-mhnq4nrqehty','state changed','OS::Heat::RandomString',NULL,NULL),(850,'dd67093e-6909-4657-9d6b-5f0ef4978cd7','6cd20e7a-88b2-48da-b03f-5f3b7623c5f5','2025-12-06 04:32:51',NULL,'DELETE','COMPLETE','HooksTest-989875015','6cd20e7a-88b2-48da-b03f-5f3b7623c5f5','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(851,'86acb134-46ad-4f36-8206-6fb5ceacffb6','4c1b238e-4e21-4355-9f20-402770b3e07b','2025-12-06 04:32:53',NULL,'UPDATE','COMPLETE','server','409e6523-9f12-42dc-a3b6-bc3aacc607fe','state changed','OS::Nova::Server',NULL,149),(852,'84504dc1-1775-4240-9e99-bed79751c1f4','4c1b238e-4e21-4355-9f20-402770b3e07b','2025-12-06 04:32:53',NULL,'UPDATE','COMPLETE','add_subnet','4c1b238e-4e21-4355-9f20-402770b3e07b','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(853,'cf5340d5-63b6-4bb8-8ebc-37ef3933db1a','7e7aef01-9063-4dfe-b1e6-878cf42ae5c2','2025-12-06 04:33:00',NULL,'CREATE','IN_PROGRESS','HooksTest-440720371','7e7aef01-9063-4dfe-b1e6-878cf42ae5c2','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(854,'c05b68ac-0110-4d42-b6e3-1b6b7ed2d36d','7e7aef01-9063-4dfe-b1e6-878cf42ae5c2','2025-12-06 04:33:00',NULL,'CREATE','IN_PROGRESS','nested','HooksTest-440720371-nested-6sw3rfzcclkw','state changed','nested.yaml',NULL,NULL),(855,'f40ee28a-17b6-454e-b014-13357a137af7','2e238c19-c25b-4d43-bdb7-6a7015fc9473','2025-12-06 04:33:00',NULL,'CREATE','IN_PROGRESS','HooksTest-440720371-nested-6sw3rfzcclkw','2e238c19-c25b-4d43-bdb7-6a7015fc9473','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(856,'290d5603-c08c-4182-a1f7-c8aaf897f17e','2e238c19-c25b-4d43-bdb7-6a7015fc9473','2025-12-06 04:33:00',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-440720371-nested-6sw3rfzcclkw-foo_step1-kbohdlk4x7wu','state changed','OS::Heat::RandomString',NULL,NULL),(857,'4528b6dc-6ee2-4ff7-a1e2-756d31edbb60','2e238c19-c25b-4d43-bdb7-6a7015fc9473','2025-12-06 04:33:00',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-440720371-nested-6sw3rfzcclkw-foo_step1-kbohdlk4x7wu','state changed','OS::Heat::RandomString',NULL,NULL),(858,'29419213-ce1a-4a5d-9fa2-6dc59ecac167','2e238c19-c25b-4d43-bdb7-6a7015fc9473','2025-12-06 04:33:00',NULL,'INIT','COMPLETE','foo_step2',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(859,'f54a8bd5-be8e-4a35-a8d2-1614651476ed','4c1b238e-4e21-4355-9f20-402770b3e07b','2025-12-06 04:33:00',NULL,'DELETE','IN_PROGRESS','add_subnet','4c1b238e-4e21-4355-9f20-402770b3e07b','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(860,'bc5d949e-1d6f-443a-a245-5e0cf37ee2da','4c1b238e-4e21-4355-9f20-402770b3e07b','2025-12-06 04:33:01',NULL,'DELETE','IN_PROGRESS','server','409e6523-9f12-42dc-a3b6-bc3aacc607fe','state changed','OS::Nova::Server',NULL,149),(861,'d7c14973-2686-4f3d-b087-9d9e4423da86','4c1b238e-4e21-4355-9f20-402770b3e07b','2025-12-06 04:33:02',NULL,'DELETE','COMPLETE','server','409e6523-9f12-42dc-a3b6-bc3aacc607fe','state changed','OS::Nova::Server',NULL,149),(862,'7a096b5f-7153-4536-b2e4-1e95933843b3','4c1b238e-4e21-4355-9f20-402770b3e07b','2025-12-06 04:33:02',NULL,'DELETE','IN_PROGRESS','subnet','e0684a45-94d6-4841-bfd8-9416f384a41a','state changed','OS::Neutron::Subnet',NULL,146),(863,'2a472f5e-4a6c-4ba6-9e76-4e428ea71b33','4c1b238e-4e21-4355-9f20-402770b3e07b','2025-12-06 04:33:03',NULL,'DELETE','COMPLETE','subnet','e0684a45-94d6-4841-bfd8-9416f384a41a','state changed','OS::Neutron::Subnet',NULL,146),(864,'79f74d68-80f4-478d-80bf-458bac0654e0','4c1b238e-4e21-4355-9f20-402770b3e07b','2025-12-06 04:33:03',NULL,'DELETE','IN_PROGRESS','net','f13f304e-89e8-445e-b1aa-4e561c622773','state changed','OS::Neutron::Net',NULL,145),(865,'35e1536b-106b-43e0-94ae-cc146261482e','4c1b238e-4e21-4355-9f20-402770b3e07b','2025-12-06 04:33:03',NULL,'DELETE','COMPLETE','net','f13f304e-89e8-445e-b1aa-4e561c622773','state changed','OS::Neutron::Net',NULL,145),(866,'7e53765b-6511-4c4d-92bd-cab894f89e73','4c1b238e-4e21-4355-9f20-402770b3e07b','2025-12-06 04:33:03',NULL,'DELETE','COMPLETE','add_subnet','4c1b238e-4e21-4355-9f20-402770b3e07b','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(867,'58755f6d-773d-41b1-8349-4d8f9d3d4797','2e238c19-c25b-4d43-bdb7-6a7015fc9473','2025-12-06 04:33:11',NULL,'INIT','COMPLETE','foo_step2',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(868,'c88e85df-bcb4-409a-9154-903e7c04556e','2e238c19-c25b-4d43-bdb7-6a7015fc9473','2025-12-06 04:33:11',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-440720371-nested-6sw3rfzcclkw-foo_step2-nl7kjf6ifzbx','state changed','OS::Heat::RandomString',NULL,NULL),(869,'9a59dd23-1dc7-4e00-8fe1-523ab63ff253','38571d71-c8bd-437e-8699-b48e38e95263','2025-12-06 04:33:11',NULL,'CREATE','IN_PROGRESS','multi_networks_swaps','38571d71-c8bd-437e-8699-b48e38e95263','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(870,'e1c9ad70-aed9-41ea-b9ce-019282654fe8','38571d71-c8bd-437e-8699-b48e38e95263','2025-12-06 04:33:12',NULL,'CREATE','IN_PROGRESS','net','multi_networks_swaps-net-fbgox6pcezac','state changed','OS::Neutron::Net',NULL,151),(871,'5cedb8cc-8a29-4fb6-b854-739f8f05d923','2e238c19-c25b-4d43-bdb7-6a7015fc9473','2025-12-06 04:33:12',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-440720371-nested-6sw3rfzcclkw-foo_step2-nl7kjf6ifzbx','state changed','OS::Heat::RandomString',NULL,NULL),(872,'18b71d2d-1c99-4e5a-94b3-f5a7e4cd31e0','2e238c19-c25b-4d43-bdb7-6a7015fc9473','2025-12-06 04:33:12',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-440720371-nested-6sw3rfzcclkw-foo_step3-kh6tbaxwlrof','state changed','OS::Heat::RandomString',NULL,NULL),(873,'b8586fb8-b949-4fe4-94e8-94fecf2bca2e','2e238c19-c25b-4d43-bdb7-6a7015fc9473','2025-12-06 04:33:13',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-440720371-nested-6sw3rfzcclkw-foo_step3-kh6tbaxwlrof','state changed','OS::Heat::RandomString',NULL,NULL),(874,'87c0ef98-8fae-4e24-b6e4-47033ee64c5f','2e238c19-c25b-4d43-bdb7-6a7015fc9473','2025-12-06 04:33:13',NULL,'CREATE','COMPLETE','HooksTest-440720371-nested-6sw3rfzcclkw','2e238c19-c25b-4d43-bdb7-6a7015fc9473','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(875,'50c4a3b5-3626-4dd9-a0a2-940b5c64bcd9','7e7aef01-9063-4dfe-b1e6-878cf42ae5c2','2025-12-06 04:33:15',NULL,'CREATE','COMPLETE','nested','2e238c19-c25b-4d43-bdb7-6a7015fc9473','state changed','nested.yaml',NULL,NULL),(876,'933b43e2-e3cf-4a02-af31-bbdc63836f90','7e7aef01-9063-4dfe-b1e6-878cf42ae5c2','2025-12-06 04:33:17',NULL,'CREATE','COMPLETE','HooksTest-440720371','7e7aef01-9063-4dfe-b1e6-878cf42ae5c2','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(877,'5de83e17-5061-4c73-838d-c5ce2dc62a4d','7e7aef01-9063-4dfe-b1e6-878cf42ae5c2','2025-12-06 04:33:17',NULL,'DELETE','IN_PROGRESS','HooksTest-440720371','7e7aef01-9063-4dfe-b1e6-878cf42ae5c2','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(878,'35189afd-1379-49c3-8ebc-c20e2f3e8cd7','7e7aef01-9063-4dfe-b1e6-878cf42ae5c2','2025-12-06 04:33:17',NULL,'DELETE','IN_PROGRESS','nested','2e238c19-c25b-4d43-bdb7-6a7015fc9473','state changed','nested.yaml',NULL,NULL),(879,'71f42084-a886-45de-8047-3789d7d792b4','2e238c19-c25b-4d43-bdb7-6a7015fc9473','2025-12-06 04:33:18',NULL,'DELETE','IN_PROGRESS','HooksTest-440720371-nested-6sw3rfzcclkw','2e238c19-c25b-4d43-bdb7-6a7015fc9473','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(880,'1febe6e9-3278-47a4-badd-0d70538ac891','38571d71-c8bd-437e-8699-b48e38e95263','2025-12-06 04:33:18',NULL,'CREATE','COMPLETE','net','e6942e2a-91ce-4406-b56c-00342e7f460d','state changed','OS::Neutron::Net',NULL,151),(881,'1642db20-7b2f-45e4-9dd1-3d823ad06d01','38571d71-c8bd-437e-8699-b48e38e95263','2025-12-06 04:33:18',NULL,'CREATE','IN_PROGRESS','subnet','multi_networks_swaps-subnet-xneb6k6r7zz7','state changed','OS::Neutron::Subnet',NULL,152),(882,'d3f1ab48-a535-447d-ae81-c63432f57314','2e238c19-c25b-4d43-bdb7-6a7015fc9473','2025-12-06 04:33:18',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-440720371-nested-6sw3rfzcclkw-foo_step3-kh6tbaxwlrof','state changed','OS::Heat::RandomString',NULL,NULL),(883,'a7a83a68-f3e7-4e02-81a1-764250990b25','2e238c19-c25b-4d43-bdb7-6a7015fc9473','2025-12-06 04:33:18',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-440720371-nested-6sw3rfzcclkw-foo_step3-kh6tbaxwlrof','state changed','OS::Heat::RandomString',NULL,NULL),(884,'3a7f44bb-3814-4d84-9ed3-06f1e49695d4','2e238c19-c25b-4d43-bdb7-6a7015fc9473','2025-12-06 04:33:18',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-440720371-nested-6sw3rfzcclkw-foo_step2-nl7kjf6ifzbx','state changed','OS::Heat::RandomString',NULL,NULL),(885,'144ebf64-b177-4047-b697-657879c9e1a3','2e238c19-c25b-4d43-bdb7-6a7015fc9473','2025-12-06 04:33:18',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-440720371-nested-6sw3rfzcclkw-foo_step2-nl7kjf6ifzbx','state changed','OS::Heat::RandomString',NULL,NULL),(886,'e5d899d0-f321-460a-9f31-831da19d428b','2e238c19-c25b-4d43-bdb7-6a7015fc9473','2025-12-06 04:33:18',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-440720371-nested-6sw3rfzcclkw-foo_step1-kbohdlk4x7wu','state changed','OS::Heat::RandomString',NULL,NULL),(887,'97c759e7-23ba-4c4d-a33e-e5c8f6fc1b06','2e238c19-c25b-4d43-bdb7-6a7015fc9473','2025-12-06 04:33:18',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-440720371-nested-6sw3rfzcclkw-foo_step1-kbohdlk4x7wu','state changed','OS::Heat::RandomString',NULL,NULL),(888,'b28d1f4a-7b74-48d2-9843-0ed5ef7473d7','2e238c19-c25b-4d43-bdb7-6a7015fc9473','2025-12-06 04:33:18',NULL,'DELETE','COMPLETE','HooksTest-440720371-nested-6sw3rfzcclkw','2e238c19-c25b-4d43-bdb7-6a7015fc9473','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(889,'b8909746-1c8f-417b-b9ab-316381dfb187','7e7aef01-9063-4dfe-b1e6-878cf42ae5c2','2025-12-06 04:33:19',NULL,'DELETE','COMPLETE','nested','2e238c19-c25b-4d43-bdb7-6a7015fc9473','state changed','nested.yaml',NULL,NULL),(890,'cec7ddf5-1763-488e-ae76-013005b7eee1','7e7aef01-9063-4dfe-b1e6-878cf42ae5c2','2025-12-06 04:33:19',NULL,'DELETE','COMPLETE','HooksTest-440720371','7e7aef01-9063-4dfe-b1e6-878cf42ae5c2','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(891,'e940010f-556d-4a62-9441-d74788620540','38571d71-c8bd-437e-8699-b48e38e95263','2025-12-06 04:33:20',NULL,'CREATE','COMPLETE','subnet','4ffb149f-a9e2-424a-98ec-8dc53f7e2a0a','state changed','OS::Neutron::Subnet',NULL,152),(892,'dd5bc489-ec5a-41d1-bf74-b58ffc580a3e','38571d71-c8bd-437e-8699-b48e38e95263','2025-12-06 04:33:20',NULL,'CREATE','IN_PROGRESS','server','multi_networks_swaps-server-3ypwnxv6f56f','state changed','OS::Nova::Server',NULL,153),(893,'7913ead4-20af-44d5-a1f2-f0ed2c50e1ac','8febfde3-e636-4b94-bac5-97c2406ddb60','2025-12-06 04:33:24',NULL,'CREATE','IN_PROGRESS','HooksTest-747296320','8febfde3-e636-4b94-bac5-97c2406ddb60','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(894,'ebf964a9-2476-4cc6-8d39-ddfe6bdb9047','8febfde3-e636-4b94-bac5-97c2406ddb60','2025-12-06 04:33:24',NULL,'INIT','COMPLETE','foo_step1',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(895,'534d2e8e-4855-4e67-a9c3-040515d18214','8febfde3-e636-4b94-bac5-97c2406ddb60','2025-12-06 04:33:28',NULL,'INIT','COMPLETE','foo_step1',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(896,'33703fbc-9406-4257-bbae-54e86ab42760','8febfde3-e636-4b94-bac5-97c2406ddb60','2025-12-06 04:33:28',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-747296320-foo_step1-pfafjcndakqi','state changed','OS::Heat::RandomString',NULL,NULL),(897,'2234389f-cd8c-432d-b2bb-c32c2112b347','8febfde3-e636-4b94-bac5-97c2406ddb60','2025-12-06 04:33:29',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-747296320-foo_step1-pfafjcndakqi','state changed','OS::Heat::RandomString',NULL,NULL),(898,'7af3c844-f21b-45ba-b976-113cec91d4cc','8febfde3-e636-4b94-bac5-97c2406ddb60','2025-12-06 04:33:29',NULL,'INIT','COMPLETE','foo_step2',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(899,'6911c0c9-2540-4ed9-b8da-c2f38aea7763','8febfde3-e636-4b94-bac5-97c2406ddb60','2025-12-06 04:33:34',NULL,'INIT','COMPLETE','foo_step2',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(900,'cf9f83fc-d2dd-4813-90ef-04110f6491a6','8febfde3-e636-4b94-bac5-97c2406ddb60','2025-12-06 04:33:34',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-747296320-foo_step2-biylivripuhw','state changed','OS::Heat::RandomString',NULL,NULL),(901,'20b315b0-fe6f-4f85-a578-d1dce3e432bb','8febfde3-e636-4b94-bac5-97c2406ddb60','2025-12-06 04:33:35',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-747296320-foo_step2-biylivripuhw','state changed','OS::Heat::RandomString',NULL,NULL),(902,'791d2833-504e-46e1-ac01-110ba6a0252d','8febfde3-e636-4b94-bac5-97c2406ddb60','2025-12-06 04:33:35',NULL,'INIT','COMPLETE','foo_step3',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(903,'7356f8ba-e623-4b32-b864-19a8972361ad','8febfde3-e636-4b94-bac5-97c2406ddb60','2025-12-06 04:33:39',NULL,'INIT','COMPLETE','foo_step3',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(904,'0eefb0d3-2415-42b1-afdb-9f245593365d','8febfde3-e636-4b94-bac5-97c2406ddb60','2025-12-06 04:33:39',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-747296320-foo_step3-rkgpsbixqc7a','state changed','OS::Heat::RandomString',NULL,NULL),(905,'44256ff1-9c5d-485e-928b-db4a0e2e6983','8febfde3-e636-4b94-bac5-97c2406ddb60','2025-12-06 04:33:41',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-747296320-foo_step3-rkgpsbixqc7a','state changed','OS::Heat::RandomString',NULL,NULL),(906,'d0a19c78-3140-4489-a9ba-3ae9a7e25925','8febfde3-e636-4b94-bac5-97c2406ddb60','2025-12-06 04:33:41',NULL,'CREATE','COMPLETE','HooksTest-747296320','8febfde3-e636-4b94-bac5-97c2406ddb60','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(907,'f03b705d-0301-44a6-a7d5-6e06c0b0fd1a','8febfde3-e636-4b94-bac5-97c2406ddb60','2025-12-06 04:33:43',NULL,'DELETE','IN_PROGRESS','HooksTest-747296320','8febfde3-e636-4b94-bac5-97c2406ddb60','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(908,'e967c19c-53f5-4993-843e-d195c28ebfd6','8febfde3-e636-4b94-bac5-97c2406ddb60','2025-12-06 04:33:44',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-747296320-foo_step3-rkgpsbixqc7a','state changed','OS::Heat::RandomString',NULL,NULL),(909,'c34f675e-1a13-4ea7-bf2b-3dee045df83d','8febfde3-e636-4b94-bac5-97c2406ddb60','2025-12-06 04:33:44',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-747296320-foo_step3-rkgpsbixqc7a','state changed','OS::Heat::RandomString',NULL,NULL),(910,'f5119b21-912a-47ff-acaa-65675a42a76e','8febfde3-e636-4b94-bac5-97c2406ddb60','2025-12-06 04:33:46',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-747296320-foo_step2-biylivripuhw','state changed','OS::Heat::RandomString',NULL,NULL),(911,'c8bc9236-da03-496b-ab4f-3125ccbf4387','8febfde3-e636-4b94-bac5-97c2406ddb60','2025-12-06 04:33:46',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-747296320-foo_step2-biylivripuhw','state changed','OS::Heat::RandomString',NULL,NULL),(912,'dba8eaa2-d9e7-492a-b76b-69232d8d0b2a','8febfde3-e636-4b94-bac5-97c2406ddb60','2025-12-06 04:33:46',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-747296320-foo_step1-pfafjcndakqi','state changed','OS::Heat::RandomString',NULL,NULL),(913,'f02b7d2f-c266-4a52-8ff9-76ec51a67002','8febfde3-e636-4b94-bac5-97c2406ddb60','2025-12-06 04:33:46',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-747296320-foo_step1-pfafjcndakqi','state changed','OS::Heat::RandomString',NULL,NULL),(914,'e795b196-82b2-430c-a2d8-dd309c3b1198','8febfde3-e636-4b94-bac5-97c2406ddb60','2025-12-06 04:33:46',NULL,'DELETE','COMPLETE','HooksTest-747296320','8febfde3-e636-4b94-bac5-97c2406ddb60','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(915,'a6abaa6c-038b-4b70-8c19-1e9fc1672109','ab67569e-834e-446a-81fe-d6f6fb8fe840','2025-12-06 04:33:52',NULL,'CREATE','IN_PROGRESS','HooksTest-1462708843','ab67569e-834e-446a-81fe-d6f6fb8fe840','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(916,'46b21a33-d8f9-45d2-9cbb-f370a36f6ad8','ab67569e-834e-446a-81fe-d6f6fb8fe840','2025-12-06 04:33:52',NULL,'CREATE','IN_PROGRESS','rg','HooksTest-1462708843-rg-vdvjvjzs2rqz','state changed','OS::Heat::ResourceGroup',NULL,154),(917,'ade5e9e4-82dd-413e-a2f9-17a484e3aadd','38571d71-c8bd-437e-8699-b48e38e95263','2025-12-06 04:33:52',NULL,'CREATE','COMPLETE','server','2ca5eaf8-d6e2-4292-bd6e-11fec743a5d1','state changed','OS::Nova::Server',NULL,153),(918,'546e6ed7-ca55-468b-a713-f0d0c88ed19e','38571d71-c8bd-437e-8699-b48e38e95263','2025-12-06 04:33:52',NULL,'CREATE','COMPLETE','multi_networks_swaps','38571d71-c8bd-437e-8699-b48e38e95263','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(919,'8bba1e80-cfaf-442f-b41e-41f706149b54','994b892d-a3c8-4913-939a-ceb580643578','2025-12-06 04:33:52',NULL,'CREATE','IN_PROGRESS','HooksTest-1462708843-rg-vdvjvjzs2rqz','994b892d-a3c8-4913-939a-ceb580643578','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(920,'4ed46240-36f6-4cc4-bd74-76d5068305e2','994b892d-a3c8-4913-939a-ceb580643578','2025-12-06 04:33:52',NULL,'CREATE','IN_PROGRESS','0','HooksTest-1462708843-rg-vdvjvjzs2rqz-0-b2spodfjvvbk','state changed','OS::Heat::RandomString',NULL,NULL),(921,'b760184c-7251-4a00-8b71-1da0b7bc496f','994b892d-a3c8-4913-939a-ceb580643578','2025-12-06 04:33:52',NULL,'CREATE','COMPLETE','0','HooksTest-1462708843-rg-vdvjvjzs2rqz-0-b2spodfjvvbk','state changed','OS::Heat::RandomString',NULL,NULL),(922,'d0d1dc9d-23fd-4471-bd99-dbf2455fc8e8','994b892d-a3c8-4913-939a-ceb580643578','2025-12-06 04:33:52',NULL,'CREATE','COMPLETE','HooksTest-1462708843-rg-vdvjvjzs2rqz','994b892d-a3c8-4913-939a-ceb580643578','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(923,'2e1075ff-d795-4595-b211-7a262c0fa146','ab67569e-834e-446a-81fe-d6f6fb8fe840','2025-12-06 04:33:54',NULL,'CREATE','COMPLETE','rg','994b892d-a3c8-4913-939a-ceb580643578','state changed','OS::Heat::ResourceGroup',NULL,154),(924,'d413a31a-fd45-498b-a027-9280101f5179','ab67569e-834e-446a-81fe-d6f6fb8fe840','2025-12-06 04:33:54',NULL,'CREATE','COMPLETE','HooksTest-1462708843','ab67569e-834e-446a-81fe-d6f6fb8fe840','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(925,'c5d4f34c-3c22-431a-b78c-8fd2785d0ac4','ab67569e-834e-446a-81fe-d6f6fb8fe840','2025-12-06 04:33:58',NULL,'UPDATE','IN_PROGRESS','HooksTest-1462708843','ab67569e-834e-446a-81fe-d6f6fb8fe840','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(926,'504c5d4a-2a23-4a17-9cc2-f7be7bcf69fc','ab67569e-834e-446a-81fe-d6f6fb8fe840','2025-12-06 04:33:58',NULL,'CREATE','COMPLETE','rg','994b892d-a3c8-4913-939a-ceb580643578','UPDATE paused until Hook pre-update is cleared','OS::Heat::ResourceGroup',NULL,154),(927,'e53262f4-adba-4669-955b-80c9de409e7c','ab67569e-834e-446a-81fe-d6f6fb8fe840','2025-12-06 04:33:59',NULL,'CREATE','COMPLETE','rg','994b892d-a3c8-4913-939a-ceb580643578','Hook pre-update is cleared','OS::Heat::ResourceGroup',NULL,154),(928,'63946549-8a72-41ab-a94b-52a4f98bc746','ab67569e-834e-446a-81fe-d6f6fb8fe840','2025-12-06 04:33:59',NULL,'UPDATE','IN_PROGRESS','rg','994b892d-a3c8-4913-939a-ceb580643578','state changed','OS::Heat::ResourceGroup',NULL,154),(929,'8f499484-b7e0-4620-9510-44db62ed3752','994b892d-a3c8-4913-939a-ceb580643578','2025-12-06 04:34:00',NULL,'UPDATE','IN_PROGRESS','HooksTest-1462708843-rg-vdvjvjzs2rqz','994b892d-a3c8-4913-939a-ceb580643578','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(930,'69407373-74b6-4920-a797-fc67452c5423','994b892d-a3c8-4913-939a-ceb580643578','2025-12-06 04:34:01',NULL,'CREATE','IN_PROGRESS','1','HooksTest-1462708843-rg-vdvjvjzs2rqz-1-z3dpzuc5hp2u','state changed','OS::Heat::RandomString',NULL,NULL),(931,'534a6a21-779f-478a-a9e9-5ede14b9d83f','994b892d-a3c8-4913-939a-ceb580643578','2025-12-06 04:34:01',NULL,'CREATE','COMPLETE','1','HooksTest-1462708843-rg-vdvjvjzs2rqz-1-z3dpzuc5hp2u','state changed','OS::Heat::RandomString',NULL,NULL),(932,'d005ede3-deac-4be0-bcfa-ae3d38aab823','994b892d-a3c8-4913-939a-ceb580643578','2025-12-06 04:34:01',NULL,'UPDATE','COMPLETE','HooksTest-1462708843-rg-vdvjvjzs2rqz','994b892d-a3c8-4913-939a-ceb580643578','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(933,'b2cddca2-6f14-4a4f-bd3a-42ff80faec6b','38571d71-c8bd-437e-8699-b48e38e95263','2025-12-06 04:34:02',NULL,'UPDATE','IN_PROGRESS','multi_networks_swaps','38571d71-c8bd-437e-8699-b48e38e95263','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(934,'921a6449-7af2-4827-83b3-ac6f9b413498','ab67569e-834e-446a-81fe-d6f6fb8fe840','2025-12-06 04:34:02',NULL,'UPDATE','COMPLETE','rg','994b892d-a3c8-4913-939a-ceb580643578','state changed','OS::Heat::ResourceGroup',NULL,156),(935,'c57ac664-71ad-4617-a7ff-93328aed6c90','ab67569e-834e-446a-81fe-d6f6fb8fe840','2025-12-06 04:34:02',NULL,'UPDATE','COMPLETE','HooksTest-1462708843','ab67569e-834e-446a-81fe-d6f6fb8fe840','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(936,'a9d5ef9a-93cd-4086-a320-a7fb97553b1d','38571d71-c8bd-437e-8699-b48e38e95263','2025-12-06 04:34:03',NULL,'UPDATE','IN_PROGRESS','server','2ca5eaf8-d6e2-4292-bd6e-11fec743a5d1','state changed','OS::Nova::Server',NULL,153),(937,'1901ad26-de4b-4daa-8983-01b7554e5df2','ab67569e-834e-446a-81fe-d6f6fb8fe840','2025-12-06 04:34:04',NULL,'DELETE','IN_PROGRESS','HooksTest-1462708843','ab67569e-834e-446a-81fe-d6f6fb8fe840','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(938,'a9b7e244-3d20-462c-a8c0-970421658b1c','ab67569e-834e-446a-81fe-d6f6fb8fe840','2025-12-06 04:34:04',NULL,'DELETE','IN_PROGRESS','rg','994b892d-a3c8-4913-939a-ceb580643578','state changed','OS::Heat::ResourceGroup',NULL,156),(939,'e6d36ea0-9cc7-4590-b6d9-0dda51be9947','994b892d-a3c8-4913-939a-ceb580643578','2025-12-06 04:34:04',NULL,'DELETE','IN_PROGRESS','HooksTest-1462708843-rg-vdvjvjzs2rqz','994b892d-a3c8-4913-939a-ceb580643578','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(940,'91dcc506-2d29-4a6b-a653-3f8b7fb7d06d','994b892d-a3c8-4913-939a-ceb580643578','2025-12-06 04:34:04',NULL,'DELETE','IN_PROGRESS','1','HooksTest-1462708843-rg-vdvjvjzs2rqz-1-z3dpzuc5hp2u','state changed','OS::Heat::RandomString',NULL,NULL),(941,'ae0a4e26-f29e-42aa-932b-8feea2dee364','994b892d-a3c8-4913-939a-ceb580643578','2025-12-06 04:34:04',NULL,'DELETE','COMPLETE','1','HooksTest-1462708843-rg-vdvjvjzs2rqz-1-z3dpzuc5hp2u','state changed','OS::Heat::RandomString',NULL,NULL),(942,'8ca8f8f1-4650-4d13-9a55-191cd562a045','994b892d-a3c8-4913-939a-ceb580643578','2025-12-06 04:34:05',NULL,'DELETE','IN_PROGRESS','0','HooksTest-1462708843-rg-vdvjvjzs2rqz-0-b2spodfjvvbk','state changed','OS::Heat::RandomString',NULL,NULL),(943,'401db587-5a84-469f-a0cb-4b0146660589','994b892d-a3c8-4913-939a-ceb580643578','2025-12-06 04:34:05',NULL,'DELETE','COMPLETE','0','HooksTest-1462708843-rg-vdvjvjzs2rqz-0-b2spodfjvvbk','state changed','OS::Heat::RandomString',NULL,NULL),(944,'ef8ec27e-44af-4766-973a-a4721802971f','994b892d-a3c8-4913-939a-ceb580643578','2025-12-06 04:34:05',NULL,'DELETE','COMPLETE','HooksTest-1462708843-rg-vdvjvjzs2rqz','994b892d-a3c8-4913-939a-ceb580643578','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(945,'c5a5a128-97cd-4762-a3d6-95e84f055145','ab67569e-834e-446a-81fe-d6f6fb8fe840','2025-12-06 04:34:06',NULL,'DELETE','COMPLETE','rg','994b892d-a3c8-4913-939a-ceb580643578','state changed','OS::Heat::ResourceGroup',NULL,156),(946,'1d71ee15-560e-49e5-af05-6453ac30f025','ab67569e-834e-446a-81fe-d6f6fb8fe840','2025-12-06 04:34:06',NULL,'DELETE','COMPLETE','HooksTest-1462708843','ab67569e-834e-446a-81fe-d6f6fb8fe840','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(947,'bb774ecb-9ecf-4bf3-80a5-41dc87c8edea','38571d71-c8bd-437e-8699-b48e38e95263','2025-12-06 04:34:08',NULL,'UPDATE','COMPLETE','server','2ca5eaf8-d6e2-4292-bd6e-11fec743a5d1','state changed','OS::Nova::Server',NULL,157),(948,'387dc3c6-2820-4d55-94f6-9ea553991fe8','38571d71-c8bd-437e-8699-b48e38e95263','2025-12-06 04:34:09',NULL,'UPDATE','COMPLETE','multi_networks_swaps','38571d71-c8bd-437e-8699-b48e38e95263','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(949,'4885831b-da67-46e4-8198-fa92ca2f4355','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','2025-12-06 04:34:11',NULL,'CREATE','IN_PROGRESS','HooksTest-669160053','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(950,'40bd72a9-5e44-4719-93d2-86e12e6ae473','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','2025-12-06 04:34:11',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-669160053-foo_step1-shmzvqjfnx7t','state changed','OS::Heat::RandomString',NULL,NULL),(951,'d3b62691-22ab-40cf-9e32-011778673cac','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','2025-12-06 04:34:11',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-669160053-foo_step1-shmzvqjfnx7t','state changed','OS::Heat::RandomString',NULL,NULL),(952,'fdf63b08-bb5a-4502-a7d9-7cc320610c29','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','2025-12-06 04:34:11',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-669160053-foo_step2-schiskgstjeg','state changed','OS::Heat::RandomString',NULL,NULL),(953,'882ba749-2dd0-4422-90d2-687aa18b852e','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','2025-12-06 04:34:11',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-669160053-foo_step2-schiskgstjeg','state changed','OS::Heat::RandomString',NULL,NULL),(954,'d7df65d3-09ce-41fd-a258-7f87310445e0','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','2025-12-06 04:34:11',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-669160053-foo_step3-epzpyiuby4sb','state changed','OS::Heat::RandomString',NULL,NULL),(955,'8e383a53-048f-48ca-b3ea-3d7733f2c8e6','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','2025-12-06 04:34:11',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-669160053-foo_step3-epzpyiuby4sb','state changed','OS::Heat::RandomString',NULL,NULL),(956,'9762727e-f7af-4fca-9b59-519de4e26a47','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','2025-12-06 04:34:11',NULL,'CREATE','COMPLETE','HooksTest-669160053','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(957,'c54acade-71aa-4aad-9d78-781b7687db22','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','2025-12-06 04:34:12',NULL,'UPDATE','IN_PROGRESS','HooksTest-669160053','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(958,'04a22f13-540b-47b1-8e1b-ffff9a3e2d28','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','2025-12-06 04:34:12',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-669160053-foo_step2-schiskgstjeg','UPDATE paused until Hook pre-update is cleared','OS::Heat::RandomString',NULL,NULL),(959,'3af504a4-95ea-4d6d-8b32-5329c19c1b20','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','2025-12-06 04:34:13',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-669160053-foo_step2-schiskgstjeg','Hook pre-update is cleared','OS::Heat::RandomString',NULL,NULL),(960,'0dfcd02a-67c6-4766-8091-74168e9c4297','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','2025-12-06 04:34:14',NULL,'UPDATE','COMPLETE','HooksTest-669160053','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(961,'cba8420d-2280-4f0d-ad80-cc6a42e9d36a','38571d71-c8bd-437e-8699-b48e38e95263','2025-12-06 04:34:14',NULL,'DELETE','IN_PROGRESS','multi_networks_swaps','38571d71-c8bd-437e-8699-b48e38e95263','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(962,'e90a3f2e-b4ae-4a50-8371-fd09f846a6ca','38571d71-c8bd-437e-8699-b48e38e95263','2025-12-06 04:34:15',NULL,'DELETE','IN_PROGRESS','server','2ca5eaf8-d6e2-4292-bd6e-11fec743a5d1','state changed','OS::Nova::Server',NULL,157),(963,'5d610ff3-d1ae-491a-baae-816dbb9935f7','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','2025-12-06 04:34:19',NULL,'DELETE','IN_PROGRESS','HooksTest-669160053','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(964,'f8a757ae-d744-4cb5-9c68-3f7b4e5960fd','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','2025-12-06 04:34:19',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-669160053-foo_step3-epzpyiuby4sb','state changed','OS::Heat::RandomString',NULL,NULL),(965,'82194151-5c71-4977-9191-2307c556cd2d','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','2025-12-06 04:34:19',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-669160053-foo_step3-epzpyiuby4sb','state changed','OS::Heat::RandomString',NULL,NULL),(966,'2cbb0aa1-0a2a-4154-a037-a12942a36ccc','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','2025-12-06 04:34:19',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-669160053-foo_step2-schiskgstjeg','state changed','OS::Heat::RandomString',NULL,NULL),(967,'96dbf7fe-b3f6-4cb0-905a-31c4faaa75b8','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','2025-12-06 04:34:19',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-669160053-foo_step2-schiskgstjeg','state changed','OS::Heat::RandomString',NULL,NULL),(968,'bc5bbefc-6b07-4690-8054-1a1669ff557b','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','2025-12-06 04:34:19',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-669160053-foo_step1-shmzvqjfnx7t','state changed','OS::Heat::RandomString',NULL,NULL),(969,'8bf22443-ebfc-4330-a3a7-cb7fb43815c6','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','2025-12-06 04:34:19',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-669160053-foo_step1-shmzvqjfnx7t','state changed','OS::Heat::RandomString',NULL,NULL),(970,'3cb81221-75d2-4678-a2ac-42cd57e34209','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','2025-12-06 04:34:19',NULL,'DELETE','COMPLETE','HooksTest-669160053','5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(971,'8c0ffec0-0984-400e-8ab3-c16ec94888af','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:26',NULL,'CREATE','IN_PROGRESS','HooksTest-1819575342','be0c1535-71df-48d2-b9fa-e963697b3cf9','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(972,'348ef6f6-0c84-4f9a-a66c-cf6baff81d07','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:26',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-1819575342-foo_step1-563opkr3am5i','state changed','OS::Heat::RandomString',NULL,NULL),(973,'74c7993a-fd5a-453f-b2c9-59ce983aa4ee','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:26',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-1819575342-foo_step1-563opkr3am5i','state changed','OS::Heat::RandomString',NULL,NULL),(974,'03367fb9-16e8-4870-bb91-d594c055ac37','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:26',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-1819575342-foo_step2-lkjfqw7nletw','state changed','OS::Heat::RandomString',NULL,NULL),(975,'6e5d1982-118b-408f-be38-fb9ef9cefeab','38571d71-c8bd-437e-8699-b48e38e95263','2025-12-06 04:34:27',NULL,'DELETE','COMPLETE','server','2ca5eaf8-d6e2-4292-bd6e-11fec743a5d1','state changed','OS::Nova::Server',NULL,157),(976,'ea79adaf-53a3-484f-8e8f-0d5244e39c00','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:27',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1819575342-foo_step2-lkjfqw7nletw','state changed','OS::Heat::RandomString',NULL,NULL),(977,'f2541a3a-d513-46c2-8d21-54d39f4bdd7c','38571d71-c8bd-437e-8699-b48e38e95263','2025-12-06 04:34:27',NULL,'DELETE','IN_PROGRESS','subnet','4ffb149f-a9e2-424a-98ec-8dc53f7e2a0a','state changed','OS::Neutron::Subnet',NULL,152),(978,'9106f456-8127-4742-878d-36d885b85fc9','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:27',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-1819575342-foo_step3-hlx5bq5vo77i','state changed','OS::Heat::RandomString',NULL,NULL),(979,'38bfb8fc-83d5-493c-8c17-51b10db94d6b','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:27',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-1819575342-foo_step3-hlx5bq5vo77i','state changed','OS::Heat::RandomString',NULL,NULL),(980,'cf84bcc0-b4ce-4211-aeda-1f502e6ec187','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:27',NULL,'CREATE','COMPLETE','HooksTest-1819575342','be0c1535-71df-48d2-b9fa-e963697b3cf9','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(981,'162308ae-9aad-4090-bfea-b5b02c06a339','38571d71-c8bd-437e-8699-b48e38e95263','2025-12-06 04:34:28',NULL,'DELETE','COMPLETE','subnet','4ffb149f-a9e2-424a-98ec-8dc53f7e2a0a','state changed','OS::Neutron::Subnet',NULL,152),(982,'35e212f5-2dc6-4dc1-9314-995da78f5766','38571d71-c8bd-437e-8699-b48e38e95263','2025-12-06 04:34:29',NULL,'DELETE','IN_PROGRESS','net','e6942e2a-91ce-4406-b56c-00342e7f460d','state changed','OS::Neutron::Net',NULL,151),(983,'a61b4124-59ae-4413-8bb7-c07370ede439','38571d71-c8bd-437e-8699-b48e38e95263','2025-12-06 04:34:30',NULL,'DELETE','COMPLETE','net','e6942e2a-91ce-4406-b56c-00342e7f460d','state changed','OS::Neutron::Net',NULL,151),(984,'497e5038-da47-43c4-981b-2a10af427c8b','38571d71-c8bd-437e-8699-b48e38e95263','2025-12-06 04:34:30',NULL,'DELETE','COMPLETE','multi_networks_swaps','38571d71-c8bd-437e-8699-b48e38e95263','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(985,'79d21fb1-5a9e-49c6-bc98-623cf48c32d8','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:33',NULL,'UPDATE','IN_PROGRESS','HooksTest-1819575342','be0c1535-71df-48d2-b9fa-e963697b3cf9','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(986,'7469886d-b288-4efd-a751-2aa411a53e1b','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:34',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1819575342-foo_step2-lkjfqw7nletw','UPDATE paused until Hook pre-update is cleared','OS::Heat::RandomString',NULL,NULL),(987,'eb5c52a7-4f7c-4fe3-b58a-a0e4c4058dfd','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:35',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1819575342-foo_step2-lkjfqw7nletw','Hook pre-update is cleared','OS::Heat::RandomString',NULL,NULL),(988,'eb9b2156-95b6-4d74-8ac1-fca7dfc0fa2b','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:35',NULL,'UPDATE','IN_PROGRESS','foo_step2','HooksTest-1819575342-foo_step2-lkjfqw7nletw','state changed','OS::Heat::RandomString',NULL,NULL),(989,'e30fd97a-cf6e-4f6a-a5b8-34a8beb947da','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:35',NULL,'UPDATE','COMPLETE','foo_step2','HooksTest-1819575342-foo_step2-lkjfqw7nletw','The Resource foo_step2 requires replacement.','OS::Heat::RandomString',NULL,NULL),(990,'8f702591-98a3-4024-b28e-cffd2f183ac7','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:35',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-1819575342-foo_step2-frdcfqgjaqec','state changed','OS::Heat::RandomString',NULL,159),(991,'8356588f-fedf-48e9-9fb4-944f5aa0559a','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:35',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1819575342-foo_step2-frdcfqgjaqec','state changed','OS::Heat::RandomString',NULL,159),(992,'db9e8165-51dd-4d06-b30e-bf09bfad857d','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:36',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-1819575342-foo_step2-lkjfqw7nletw','state changed','OS::Heat::RandomString',NULL,NULL),(993,'ff620b42-8ce4-4671-90b6-4b500f07cff5','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:36',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-1819575342-foo_step2-lkjfqw7nletw','state changed','OS::Heat::RandomString',NULL,NULL),(994,'352b1d84-f9d1-4e62-af72-7b34316dd43e','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:36',NULL,'UPDATE','COMPLETE','HooksTest-1819575342','be0c1535-71df-48d2-b9fa-e963697b3cf9','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(995,'823c3ff0-a2c8-4e27-b719-967a0da5e91a','737833fa-65b0-44f0-b058-a95eb48e9bac','2025-12-06 04:34:36',NULL,'CREATE','IN_PROGRESS','swap_network_port','737833fa-65b0-44f0-b058-a95eb48e9bac','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(996,'9bc11f5d-2e6c-4ac0-a102-ef9f708d614c','737833fa-65b0-44f0-b058-a95eb48e9bac','2025-12-06 04:34:36',NULL,'CREATE','IN_PROGRESS','net','swap_network_port-net-wpnrrmn6q2fb','state changed','OS::Neutron::Net',NULL,160),(997,'02ee4a4d-52a6-41fa-8551-1caeba0591d0','737833fa-65b0-44f0-b058-a95eb48e9bac','2025-12-06 04:34:37',NULL,'CREATE','COMPLETE','net','1061a7b2-c8c3-40cb-b101-43753ec587e1','state changed','OS::Neutron::Net',NULL,160),(998,'531a93f6-e459-4f15-90e3-7b71b07d3306','737833fa-65b0-44f0-b058-a95eb48e9bac','2025-12-06 04:34:37',NULL,'CREATE','IN_PROGRESS','subnet','swap_network_port-subnet-qrob2436ojmy','state changed','OS::Neutron::Subnet',NULL,161),(999,'2df7f670-bbc1-4091-953d-b617b73e950a','737833fa-65b0-44f0-b058-a95eb48e9bac','2025-12-06 04:34:39',NULL,'CREATE','COMPLETE','subnet','bd042101-5559-4751-b113-9a0431247e7c','state changed','OS::Neutron::Subnet',NULL,161),(1000,'94176f75-06f7-4e22-b806-de0515d27847','737833fa-65b0-44f0-b058-a95eb48e9bac','2025-12-06 04:34:39',NULL,'CREATE','IN_PROGRESS','server','swap_network_port-server-wwzoeoaryrf2','state changed','OS::Nova::Server',NULL,162),(1001,'1e2fa9e1-3bd9-4e98-93fc-a346d9e75dae','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:40',NULL,'DELETE','IN_PROGRESS','HooksTest-1819575342','be0c1535-71df-48d2-b9fa-e963697b3cf9','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1002,'960a4bff-620f-4c00-bad5-93b192ffa244','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:40',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-1819575342-foo_step3-hlx5bq5vo77i','state changed','OS::Heat::RandomString',NULL,NULL),(1003,'3478e778-bbcf-44a5-891e-ec464a2dd81d','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:40',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-1819575342-foo_step3-hlx5bq5vo77i','state changed','OS::Heat::RandomString',NULL,NULL),(1004,'f5040466-bb93-4141-8e61-90fdd9fc0db5','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:41',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-1819575342-foo_step2-frdcfqgjaqec','state changed','OS::Heat::RandomString',NULL,159),(1005,'316c8341-1b63-4730-a10c-4a0664342148','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:41',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-1819575342-foo_step2-frdcfqgjaqec','state changed','OS::Heat::RandomString',NULL,159),(1006,'bd54aef7-9227-4233-a65b-bbbb69dba226','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:41',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-1819575342-foo_step1-563opkr3am5i','state changed','OS::Heat::RandomString',NULL,NULL),(1007,'73772ec9-e123-4cfd-a86e-db573f3b88cd','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:41',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-1819575342-foo_step1-563opkr3am5i','state changed','OS::Heat::RandomString',NULL,NULL),(1008,'5c8b48eb-ed40-4589-bf9a-235c1603e8fc','be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:41',NULL,'DELETE','COMPLETE','HooksTest-1819575342','be0c1535-71df-48d2-b9fa-e963697b3cf9','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1009,'90952913-281c-4592-96ab-5e18b5748f03','c98858c0-8548-49bf-b00d-f7d9e593bee8','2025-12-06 04:34:48',NULL,'CREATE','IN_PROGRESS','server_with_port','c98858c0-8548-49bf-b00d-f7d9e593bee8','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1010,'a646753b-55a9-4fdd-bf1a-d16f144dd9c4','c98858c0-8548-49bf-b00d-f7d9e593bee8','2025-12-06 04:34:48',NULL,'CREATE','IN_PROGRESS','net','server_with_port-net-ssitu56m3gbk','state changed','OS::Neutron::Net',NULL,163),(1011,'2ca300e1-9e67-4df3-a321-5fac9d341fcb','c98858c0-8548-49bf-b00d-f7d9e593bee8','2025-12-06 04:34:50',NULL,'CREATE','COMPLETE','net','86f759c0-6534-4f0e-9aa3-8c17145066d4','state changed','OS::Neutron::Net',NULL,163),(1012,'bcbe9cf1-9e23-4655-ae6f-7b864ed1a4d2','c98858c0-8548-49bf-b00d-f7d9e593bee8','2025-12-06 04:34:50',NULL,'CREATE','IN_PROGRESS','subnet','server_with_port-subnet-sta5alvwqzjv','state changed','OS::Neutron::Subnet',NULL,164),(1013,'80792a00-a86b-4bc4-9410-6b9a00e7cb72','c98858c0-8548-49bf-b00d-f7d9e593bee8','2025-12-06 04:34:52',NULL,'CREATE','COMPLETE','subnet','33841296-ad0e-434f-bf01-e6dfb872efdf','state changed','OS::Neutron::Subnet',NULL,164),(1014,'bad9cbb7-4a91-4e8b-aad0-f90a512b06a3','c98858c0-8548-49bf-b00d-f7d9e593bee8','2025-12-06 04:34:52',NULL,'CREATE','IN_PROGRESS','port','server_with_port-port-edslp3wejm6r','state changed','OS::Neutron::Port',NULL,165),(1015,'e6a38d2f-9024-4404-9aaa-873b5106802c','c98858c0-8548-49bf-b00d-f7d9e593bee8','2025-12-06 04:34:58',NULL,'CREATE','COMPLETE','port','44c3fcc3-062d-4f3f-b1b1-544a62a37987','state changed','OS::Neutron::Port',NULL,165),(1016,'d81f75a3-2c43-4692-bd09-66a6b5307eff','c98858c0-8548-49bf-b00d-f7d9e593bee8','2025-12-06 04:34:58',NULL,'CREATE','IN_PROGRESS','server','server_with_port-server-ho3uuva7bjnw','state changed','OS::Nova::Server',NULL,166),(1017,'c66fcd0e-8158-4aef-8c16-76e9b832aaa9','737833fa-65b0-44f0-b058-a95eb48e9bac','2025-12-06 04:34:58',NULL,'CREATE','COMPLETE','server','2b96ba4d-6af2-4e63-8de5-59d747b3437d','state changed','OS::Nova::Server',NULL,162),(1018,'210c144d-ef4c-40c2-a833-519c6314ce47','737833fa-65b0-44f0-b058-a95eb48e9bac','2025-12-06 04:34:58',NULL,'CREATE','COMPLETE','swap_network_port','737833fa-65b0-44f0-b058-a95eb48e9bac','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1019,'38a1c006-ba4a-4100-891f-8fc30a41d93b','737833fa-65b0-44f0-b058-a95eb48e9bac','2025-12-06 04:35:10',NULL,'UPDATE','IN_PROGRESS','swap_network_port','737833fa-65b0-44f0-b058-a95eb48e9bac','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1020,'f08ede37-349b-499c-8c00-560efb90a212','737833fa-65b0-44f0-b058-a95eb48e9bac','2025-12-06 04:35:10',NULL,'UPDATE','IN_PROGRESS','server','2b96ba4d-6af2-4e63-8de5-59d747b3437d','state changed','OS::Nova::Server',NULL,162),(1021,'6fe82af9-d4be-4950-9249-33ff8744ef7e','737833fa-65b0-44f0-b058-a95eb48e9bac','2025-12-06 04:35:13',NULL,'UPDATE','COMPLETE','server','2b96ba4d-6af2-4e63-8de5-59d747b3437d','state changed','OS::Nova::Server',NULL,168),(1022,'818f98f1-3d6f-4c4d-8228-9d30e3b9b437','737833fa-65b0-44f0-b058-a95eb48e9bac','2025-12-06 04:35:13',NULL,'UPDATE','COMPLETE','swap_network_port','737833fa-65b0-44f0-b058-a95eb48e9bac','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1023,'5fa52918-55f7-446b-b005-d6acdbcc4305','c98858c0-8548-49bf-b00d-f7d9e593bee8','2025-12-06 04:35:13',NULL,'CREATE','COMPLETE','server','0abaa42c-5fa2-4c3d-84ce-105a0c65cd06','state changed','OS::Nova::Server',NULL,166),(1024,'80a62329-8fd3-4571-aad4-4692cf3f4861','c98858c0-8548-49bf-b00d-f7d9e593bee8','2025-12-06 04:35:13',NULL,'CREATE','COMPLETE','server_with_port','c98858c0-8548-49bf-b00d-f7d9e593bee8','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1025,'d87e3d0f-5e64-4930-8ed6-4bf2d6ba250c','c98858c0-8548-49bf-b00d-f7d9e593bee8','2025-12-06 04:35:17',NULL,'DELETE','IN_PROGRESS','server_with_port','c98858c0-8548-49bf-b00d-f7d9e593bee8','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1026,'d115c835-bab7-4a70-903e-27e94443ec13','c98858c0-8548-49bf-b00d-f7d9e593bee8','2025-12-06 04:35:18',NULL,'DELETE','IN_PROGRESS','server','0abaa42c-5fa2-4c3d-84ce-105a0c65cd06','state changed','OS::Nova::Server',NULL,166),(1027,'4c38b908-4bd0-4da5-abeb-7f2bc6889f15','737833fa-65b0-44f0-b058-a95eb48e9bac','2025-12-06 04:35:21',NULL,'DELETE','IN_PROGRESS','swap_network_port','737833fa-65b0-44f0-b058-a95eb48e9bac','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1028,'22d2a35c-e6fc-4d12-a684-c05b94680ec4','737833fa-65b0-44f0-b058-a95eb48e9bac','2025-12-06 04:35:21',NULL,'DELETE','IN_PROGRESS','server','2b96ba4d-6af2-4e63-8de5-59d747b3437d','state changed','OS::Nova::Server',NULL,168),(1029,'ad1b98ef-70f7-407d-9de5-c3d427f18be9','c98858c0-8548-49bf-b00d-f7d9e593bee8','2025-12-06 04:35:23',NULL,'DELETE','COMPLETE','server','0abaa42c-5fa2-4c3d-84ce-105a0c65cd06','state changed','OS::Nova::Server',NULL,166),(1030,'d36e2fb2-f1d3-4bf9-9e86-f9c32d5f67ab','737833fa-65b0-44f0-b058-a95eb48e9bac','2025-12-06 04:35:23',NULL,'DELETE','COMPLETE','server','2b96ba4d-6af2-4e63-8de5-59d747b3437d','state changed','OS::Nova::Server',NULL,168),(1031,'09a698b2-d51a-4dc4-a869-e1bbea504841','737833fa-65b0-44f0-b058-a95eb48e9bac','2025-12-06 04:35:24',NULL,'DELETE','IN_PROGRESS','subnet','bd042101-5559-4751-b113-9a0431247e7c','state changed','OS::Neutron::Subnet',NULL,161),(1032,'2df2a4a7-6b30-48ac-887b-3ec6ee21c5e1','c98858c0-8548-49bf-b00d-f7d9e593bee8','2025-12-06 04:35:24',NULL,'DELETE','IN_PROGRESS','port','44c3fcc3-062d-4f3f-b1b1-544a62a37987','state changed','OS::Neutron::Port',NULL,165),(1033,'4d18c744-1f35-4953-817c-a74716e80b2e','737833fa-65b0-44f0-b058-a95eb48e9bac','2025-12-06 04:35:25',NULL,'DELETE','COMPLETE','subnet','bd042101-5559-4751-b113-9a0431247e7c','state changed','OS::Neutron::Subnet',NULL,161),(1034,'b19c8a93-a0c9-4450-a0df-5ec78318be85','737833fa-65b0-44f0-b058-a95eb48e9bac','2025-12-06 04:35:25',NULL,'DELETE','IN_PROGRESS','net','1061a7b2-c8c3-40cb-b101-43753ec587e1','state changed','OS::Neutron::Net',NULL,160),(1035,'5ae03adc-3169-42a6-9f7a-f26b65987e40','c98858c0-8548-49bf-b00d-f7d9e593bee8','2025-12-06 04:35:25',NULL,'DELETE','COMPLETE','port','44c3fcc3-062d-4f3f-b1b1-544a62a37987','state changed','OS::Neutron::Port',NULL,165),(1036,'f9807aec-02b4-4ab6-b832-67f10026cc50','c98858c0-8548-49bf-b00d-f7d9e593bee8','2025-12-06 04:35:25',NULL,'DELETE','IN_PROGRESS','subnet','33841296-ad0e-434f-bf01-e6dfb872efdf','state changed','OS::Neutron::Subnet',NULL,164),(1037,'b8a22a97-231e-4a81-aeab-fadd8db10e44','c98858c0-8548-49bf-b00d-f7d9e593bee8','2025-12-06 04:35:26',NULL,'DELETE','COMPLETE','subnet','33841296-ad0e-434f-bf01-e6dfb872efdf','state changed','OS::Neutron::Subnet',NULL,164),(1038,'1ca76cf4-c9da-4c4e-8ef5-8f2097881ed4','c98858c0-8548-49bf-b00d-f7d9e593bee8','2025-12-06 04:35:26',NULL,'DELETE','IN_PROGRESS','net','86f759c0-6534-4f0e-9aa3-8c17145066d4','state changed','OS::Neutron::Net',NULL,163),(1039,'94dac3fe-3a67-4527-9356-77f04e99f615','737833fa-65b0-44f0-b058-a95eb48e9bac','2025-12-06 04:35:27',NULL,'DELETE','COMPLETE','net','1061a7b2-c8c3-40cb-b101-43753ec587e1','state changed','OS::Neutron::Net',NULL,160),(1040,'e216bff0-cb8d-499a-906a-a92ce4a567c8','737833fa-65b0-44f0-b058-a95eb48e9bac','2025-12-06 04:35:27',NULL,'DELETE','COMPLETE','swap_network_port','737833fa-65b0-44f0-b058-a95eb48e9bac','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1041,'864ff681-c627-42bc-9116-2f48089407ac','c98858c0-8548-49bf-b00d-f7d9e593bee8','2025-12-06 04:35:27',NULL,'DELETE','COMPLETE','net','86f759c0-6534-4f0e-9aa3-8c17145066d4','state changed','OS::Neutron::Net',NULL,163),(1042,'bf8c6f52-399c-42e7-8216-7f935464ee51','c98858c0-8548-49bf-b00d-f7d9e593bee8','2025-12-06 04:35:27',NULL,'DELETE','COMPLETE','server_with_port','c98858c0-8548-49bf-b00d-f7d9e593bee8','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1043,'ee5546c9-2ba6-41e2-8b1d-36c0e8b7f69a','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','2025-12-06 04:35:33',NULL,'CREATE','IN_PROGRESS','swap_network_subnet','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1044,'ed59b885-aca2-415d-9453-58d64fd2c353','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','2025-12-06 04:35:33',NULL,'CREATE','IN_PROGRESS','net','swap_network_subnet-net-vgabmfallesh','state changed','OS::Neutron::Net',NULL,170),(1045,'2d2c5467-72e4-4cfb-8eda-3207590fa93c','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','2025-12-06 04:35:34',NULL,'CREATE','COMPLETE','net','71e87c16-d80f-449e-b69a-6d1d1bb8e53b','state changed','OS::Neutron::Net',NULL,170),(1046,'ba0ef75a-b1d2-4177-9052-2910839ee73a','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','2025-12-06 04:35:34',NULL,'CREATE','IN_PROGRESS','subnet','swap_network_subnet-subnet-yhyujifc6jnq','state changed','OS::Neutron::Subnet',NULL,171),(1047,'e7e9bf92-9a56-4825-9bce-9e47675642f3','6fbed961-da2c-4c09-9fcd-917156473909','2025-12-06 04:35:34',NULL,'CREATE','IN_PROGRESS','server_with_sub_ip','6fbed961-da2c-4c09-9fcd-917156473909','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1048,'b1457b33-1eca-41f3-8884-c816c6ff5d81','6fbed961-da2c-4c09-9fcd-917156473909','2025-12-06 04:35:35',NULL,'CREATE','IN_PROGRESS','security_group','server_with_sub_ip-security_group-wyavwy43c5r6','state changed','OS::Neutron::SecurityGroup',NULL,172),(1049,'568034af-c71a-4758-983e-7db1bec68c86','6fbed961-da2c-4c09-9fcd-917156473909','2025-12-06 04:35:36',NULL,'CREATE','IN_PROGRESS','net','server_with_sub_ip-net-yyqcz4hoyj4l','state changed','OS::Neutron::Net',NULL,173),(1050,'a80d7836-7313-4a19-87c3-d00130d5c83a','6fbed961-da2c-4c09-9fcd-917156473909','2025-12-06 04:35:36',NULL,'CREATE','COMPLETE','security_group','a71c4598-ef72-4a68-a8c5-879c3450f193','state changed','OS::Neutron::SecurityGroup',NULL,172),(1051,'232adc04-a266-483e-92fd-be7991ef7539','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','2025-12-06 04:35:36',NULL,'CREATE','COMPLETE','subnet','c8f52e5f-fa50-42e5-8238-43fa114fee47','state changed','OS::Neutron::Subnet',NULL,171),(1052,'f6430dcb-52da-4064-aa8d-8d39d7e6f0cc','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','2025-12-06 04:35:36',NULL,'CREATE','IN_PROGRESS','server','swap_network_subnet-server-wqjbwur2izkm','state changed','OS::Nova::Server',NULL,174),(1053,'24cbcdc3-65e0-43c8-96cf-6a860855ffe3','6fbed961-da2c-4c09-9fcd-917156473909','2025-12-06 04:35:36',NULL,'CREATE','COMPLETE','net','1a55605b-726b-49cd-9c85-c3162017eb87','state changed','OS::Neutron::Net',NULL,173),(1054,'e6ec0b3f-8e09-4449-93d9-e91b01b0f31f','6fbed961-da2c-4c09-9fcd-917156473909','2025-12-06 04:35:36',NULL,'CREATE','IN_PROGRESS','subnet','server_with_sub_ip-subnet-3ly6wqzp5lei','state changed','OS::Neutron::Subnet',NULL,175),(1055,'95ee508d-64ef-4ab8-b297-e3b6b85ddce5','6fbed961-da2c-4c09-9fcd-917156473909','2025-12-06 04:35:40',NULL,'CREATE','COMPLETE','subnet','2b4e0e66-463f-4bf6-a637-e97d5f6323fe','state changed','OS::Neutron::Subnet',NULL,175),(1056,'492b52f6-e3e1-408a-8378-ec616261c7c9','6fbed961-da2c-4c09-9fcd-917156473909','2025-12-06 04:35:40',NULL,'CREATE','IN_PROGRESS','server','server_with_sub_ip-server-gz7tqk5aimej','state changed','OS::Nova::Server',NULL,176),(1057,'eb0aaa05-afae-4326-bbe9-ea1ba856fb8c','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','2025-12-06 04:35:56',NULL,'CREATE','COMPLETE','server','7c0747c2-e852-425e-a215-516e9e5907a1','state changed','OS::Nova::Server',NULL,174),(1058,'f3f23462-a2f9-4ee0-b692-48af6c137c2e','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','2025-12-06 04:35:57',NULL,'CREATE','COMPLETE','swap_network_subnet','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1059,'85642832-a260-4f01-a8dc-bde02c3a08fc','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','2025-12-06 04:36:03',NULL,'UPDATE','IN_PROGRESS','swap_network_subnet','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1060,'0336699b-b774-446f-8656-4b61d061efab','6fbed961-da2c-4c09-9fcd-917156473909','2025-12-06 04:36:04',NULL,'CREATE','COMPLETE','server','b60a112b-afbf-4920-806f-732b550e557c','state changed','OS::Nova::Server',NULL,176),(1061,'eb735b89-1eb1-44d3-8659-d385b7255cd9','6fbed961-da2c-4c09-9fcd-917156473909','2025-12-06 04:36:05',NULL,'CREATE','COMPLETE','server_with_sub_ip','6fbed961-da2c-4c09-9fcd-917156473909','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1062,'7b788bb3-21e9-4911-8ae8-709200e6cc3e','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','2025-12-06 04:36:06',NULL,'UPDATE','IN_PROGRESS','server','7c0747c2-e852-425e-a215-516e9e5907a1','state changed','OS::Nova::Server',NULL,174),(1063,'b543d488-8a1b-47fb-84d5-5a204338b0dd','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','2025-12-06 04:36:10',NULL,'UPDATE','COMPLETE','server','7c0747c2-e852-425e-a215-516e9e5907a1','state changed','OS::Nova::Server',NULL,178),(1064,'76737af2-b009-48d1-a7dd-57d75f9892ed','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','2025-12-06 04:36:10',NULL,'UPDATE','COMPLETE','swap_network_subnet','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1065,'f0555ddf-6308-4aa8-80e2-5a21c90477d9','6fbed961-da2c-4c09-9fcd-917156473909','2025-12-06 04:36:12',NULL,'DELETE','IN_PROGRESS','server_with_sub_ip','6fbed961-da2c-4c09-9fcd-917156473909','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1066,'4380e1bd-d349-4c1e-98c8-97771a8cc2cf','6fbed961-da2c-4c09-9fcd-917156473909','2025-12-06 04:36:12',NULL,'DELETE','IN_PROGRESS','server','b60a112b-afbf-4920-806f-732b550e557c','state changed','OS::Nova::Server',NULL,176),(1067,'5a26d7ff-6b6f-421b-98e2-7979cba030de','6fbed961-da2c-4c09-9fcd-917156473909','2025-12-06 04:36:17',NULL,'DELETE','COMPLETE','server','b60a112b-afbf-4920-806f-732b550e557c','state changed','OS::Nova::Server',NULL,176),(1068,'e9803c3a-154b-471f-b579-2285886f056e','6fbed961-da2c-4c09-9fcd-917156473909','2025-12-06 04:36:17',NULL,'DELETE','IN_PROGRESS','subnet','2b4e0e66-463f-4bf6-a637-e97d5f6323fe','state changed','OS::Neutron::Subnet',NULL,175),(1069,'89587b32-f20d-4e7c-bae4-eb4ecd6297cd','6fbed961-da2c-4c09-9fcd-917156473909','2025-12-06 04:36:17',NULL,'DELETE','IN_PROGRESS','security_group','a71c4598-ef72-4a68-a8c5-879c3450f193','state changed','OS::Neutron::SecurityGroup',NULL,172),(1070,'888125bd-7247-4fbf-b105-6b5987260ea6','6fbed961-da2c-4c09-9fcd-917156473909','2025-12-06 04:36:18',NULL,'DELETE','COMPLETE','subnet','2b4e0e66-463f-4bf6-a637-e97d5f6323fe','state changed','OS::Neutron::Subnet',NULL,175),(1071,'2351843a-c787-4fc0-9746-49145bba74dd','6fbed961-da2c-4c09-9fcd-917156473909','2025-12-06 04:36:18',NULL,'DELETE','IN_PROGRESS','net','1a55605b-726b-49cd-9c85-c3162017eb87','state changed','OS::Neutron::Net',NULL,173),(1072,'2b2fc3f1-373e-4705-9240-a668c634e8ee','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','2025-12-06 04:36:18',NULL,'DELETE','IN_PROGRESS','swap_network_subnet','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1073,'d0d1bfc2-8583-4601-be94-ce0fedf9a129','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','2025-12-06 04:36:18',NULL,'DELETE','IN_PROGRESS','server','7c0747c2-e852-425e-a215-516e9e5907a1','state changed','OS::Nova::Server',NULL,178),(1074,'cc77b7ad-b59f-47ad-b9b1-4347289fc0d7','6fbed961-da2c-4c09-9fcd-917156473909','2025-12-06 04:36:19',NULL,'DELETE','COMPLETE','net','1a55605b-726b-49cd-9c85-c3162017eb87','state changed','OS::Neutron::Net',NULL,173),(1075,'e14b20e0-0120-4270-b58c-a1e5c4e8d5bf','6fbed961-da2c-4c09-9fcd-917156473909','2025-12-06 04:36:19',NULL,'DELETE','COMPLETE','security_group','a71c4598-ef72-4a68-a8c5-879c3450f193','state changed','OS::Neutron::SecurityGroup',NULL,172),(1076,'fa292e64-5d14-4144-9926-0243b4995349','6fbed961-da2c-4c09-9fcd-917156473909','2025-12-06 04:36:19',NULL,'DELETE','COMPLETE','server_with_sub_ip','6fbed961-da2c-4c09-9fcd-917156473909','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1077,'30143c3c-50e7-41f9-bd03-03f9fbb47997','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','2025-12-06 04:36:20',NULL,'DELETE','COMPLETE','server','7c0747c2-e852-425e-a215-516e9e5907a1','state changed','OS::Nova::Server',NULL,178),(1078,'6eca6d91-529c-435a-8c2b-17d383873d55','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','2025-12-06 04:36:20',NULL,'DELETE','IN_PROGRESS','subnet','c8f52e5f-fa50-42e5-8238-43fa114fee47','state changed','OS::Neutron::Subnet',NULL,171),(1079,'7c9330fb-bdf0-470d-af47-ede700532723','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','2025-12-06 04:36:21',NULL,'DELETE','COMPLETE','subnet','c8f52e5f-fa50-42e5-8238-43fa114fee47','state changed','OS::Neutron::Subnet',NULL,171),(1080,'9a413e1b-030d-4989-91af-ebd01636584f','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','2025-12-06 04:36:21',NULL,'DELETE','IN_PROGRESS','net','71e87c16-d80f-449e-b69a-6d1d1bb8e53b','state changed','OS::Neutron::Net',NULL,170),(1081,'6a57a07e-59d0-44ee-a4b7-c61c3766fbc0','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','2025-12-06 04:36:22',NULL,'DELETE','COMPLETE','net','71e87c16-d80f-449e-b69a-6d1d1bb8e53b','state changed','OS::Neutron::Net',NULL,170),(1082,'fd019383-2e85-42c8-93ed-3170cbdf6dbc','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','2025-12-06 04:36:22',NULL,'DELETE','COMPLETE','swap_network_subnet','a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1083,'8b12dc16-c174-4a04-b76f-aebff746e56b','fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:36:22',NULL,'CREATE','IN_PROGRESS','create_server_with_sub_ip','fa575325-64fd-4f36-af83-bafee4834a12','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1084,'188a3d5f-43c9-4788-aab5-018f238975dd','fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:36:22',NULL,'CREATE','IN_PROGRESS','net','create_server_with_sub_ip-net-hqj37s5ieldh','state changed','OS::Neutron::Net',NULL,181),(1085,'e5c39ed2-40d1-42a8-8450-7da88dd92451','fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:36:23',NULL,'CREATE','COMPLETE','net','4239dcbd-d6c3-426b-843a-295a3ed880d1','state changed','OS::Neutron::Net',NULL,181),(1086,'7e6c7d4f-fd96-4697-8c2b-7dfa26405cb1','fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:36:23',NULL,'CREATE','IN_PROGRESS','subnet_b','create_server_with_sub_ip-subnet_b-ddsogc23n5np','state changed','OS::Neutron::Subnet',NULL,182),(1087,'94eaae36-d1c5-48e8-82a5-c105167fed34','fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:36:23',NULL,'CREATE','IN_PROGRESS','subnet_a','create_server_with_sub_ip-subnet_a-ubuuapuq3kr6','state changed','OS::Neutron::Subnet',NULL,183),(1088,'e13d5a83-d1fd-4c65-ac38-2ffe07a10c5d','da33927f-07f9-40f5-ab87-4a396a5afb18','2025-12-06 04:36:24',NULL,'CREATE','IN_PROGRESS','swap_subnet_network','da33927f-07f9-40f5-ab87-4a396a5afb18','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1089,'a392bfee-2753-4cc9-a32f-f52f179db024','da33927f-07f9-40f5-ab87-4a396a5afb18','2025-12-06 04:36:24',NULL,'CREATE','IN_PROGRESS','net','swap_subnet_network-net-bep5zpe7k4ds','state changed','OS::Neutron::Net',NULL,184),(1090,'faf3b61f-3b96-4263-8b8b-ad9dbb51d4aa','fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:36:25',NULL,'CREATE','COMPLETE','subnet_b','579ac940-890f-4384-b6e7-0dc18af11849','state changed','OS::Neutron::Subnet',NULL,182),(1091,'514e665a-1c45-4d5d-8dc9-40dbe294dc0e','da33927f-07f9-40f5-ab87-4a396a5afb18','2025-12-06 04:36:30',NULL,'CREATE','COMPLETE','net','fb6b677c-1569-42bb-993c-ea78451aefe3','state changed','OS::Neutron::Net',NULL,184),(1092,'75bf2447-2975-413f-9e24-a2c285acaa35','da33927f-07f9-40f5-ab87-4a396a5afb18','2025-12-06 04:36:31',NULL,'CREATE','IN_PROGRESS','subnet','swap_subnet_network-subnet-gmpkw4qeok6r','state changed','OS::Neutron::Subnet',NULL,185),(1093,'41d13cba-8b3e-4a34-9ef8-375cec2dcdd5','fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:36:31',NULL,'CREATE','COMPLETE','subnet_a','88c33f60-89f1-4a43-ba8d-d2830eaa6d99','state changed','OS::Neutron::Subnet',NULL,183),(1094,'b009d7ee-ec6f-4131-b03c-19989ec1b1dd','fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:36:31',NULL,'CREATE','IN_PROGRESS','server','create_server_with_sub_ip-server-jwjbzqjkwf2m','state changed','OS::Nova::Server',NULL,186),(1095,'16f1ec6b-0c44-4b69-8ab6-78288e5d45c5','da33927f-07f9-40f5-ab87-4a396a5afb18','2025-12-06 04:36:34',NULL,'CREATE','COMPLETE','subnet','2cc5353b-f3fe-4f03-b159-e7043638a9f5','state changed','OS::Neutron::Subnet',NULL,185),(1096,'6f7ce225-bcb6-4442-9c7e-7f9827a08c64','da33927f-07f9-40f5-ab87-4a396a5afb18','2025-12-06 04:36:35',NULL,'CREATE','IN_PROGRESS','server','swap_subnet_network-server-susv7qrogevt','state changed','OS::Nova::Server',NULL,187),(1097,'323ad460-b4bd-4cbd-9d77-48aad0d5f621','fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:36:48',NULL,'CREATE','COMPLETE','server','276c3f87-58ec-4c17-a5f4-5523c5330d32','state changed','OS::Nova::Server',NULL,186),(1098,'db34b96c-c968-447f-a50a-32ce61b65256','fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:36:48',NULL,'CREATE','COMPLETE','create_server_with_sub_ip','fa575325-64fd-4f36-af83-bafee4834a12','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1099,'27bdf89a-98e1-4b07-88bc-29dafbaa64a5','da33927f-07f9-40f5-ab87-4a396a5afb18','2025-12-06 04:36:54',NULL,'CREATE','COMPLETE','server','12751a0a-4c8c-4bf2-b035-8f876dd9066e','state changed','OS::Nova::Server',NULL,187),(1100,'826d4d76-e415-40d0-90a3-d39b73563c1d','da33927f-07f9-40f5-ab87-4a396a5afb18','2025-12-06 04:36:54',NULL,'CREATE','COMPLETE','swap_subnet_network','da33927f-07f9-40f5-ab87-4a396a5afb18','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1101,'60d0fa2c-6c0f-4a12-8140-69a9fb035878','fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:36:55',NULL,'UPDATE','IN_PROGRESS','create_server_with_sub_ip','fa575325-64fd-4f36-af83-bafee4834a12','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1102,'4253f3cd-b226-408a-a0b8-e024ee1f0f93','fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:36:56',NULL,'UPDATE','IN_PROGRESS','server','276c3f87-58ec-4c17-a5f4-5523c5330d32','state changed','OS::Nova::Server',NULL,186),(1103,'acf15ddc-210f-4655-a680-624b0f04fe3c','da33927f-07f9-40f5-ab87-4a396a5afb18','2025-12-06 04:36:58',NULL,'UPDATE','IN_PROGRESS','swap_subnet_network','da33927f-07f9-40f5-ab87-4a396a5afb18','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1104,'32ca3a3b-c01e-4103-9e04-ba224cf6fc5b','da33927f-07f9-40f5-ab87-4a396a5afb18','2025-12-06 04:36:59',NULL,'UPDATE','IN_PROGRESS','server','12751a0a-4c8c-4bf2-b035-8f876dd9066e','state changed','OS::Nova::Server',NULL,187),(1105,'5e1c40bd-9469-4c48-818c-81042407b502','da33927f-07f9-40f5-ab87-4a396a5afb18','2025-12-06 04:37:05',NULL,'UPDATE','COMPLETE','server','12751a0a-4c8c-4bf2-b035-8f876dd9066e','state changed','OS::Nova::Server',NULL,190),(1106,'36648f18-a8aa-46d5-9561-8d3ab2b83748','da33927f-07f9-40f5-ab87-4a396a5afb18','2025-12-06 04:37:05',NULL,'UPDATE','COMPLETE','swap_subnet_network','da33927f-07f9-40f5-ab87-4a396a5afb18','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1107,'42a09036-4c19-4a45-ac77-79c7098accca','da33927f-07f9-40f5-ab87-4a396a5afb18','2025-12-06 04:37:08',NULL,'DELETE','IN_PROGRESS','swap_subnet_network','da33927f-07f9-40f5-ab87-4a396a5afb18','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1108,'7621a886-8c6c-4e66-be15-6d46dc0fbc1c','da33927f-07f9-40f5-ab87-4a396a5afb18','2025-12-06 04:37:09',NULL,'DELETE','IN_PROGRESS','server','12751a0a-4c8c-4bf2-b035-8f876dd9066e','state changed','OS::Nova::Server',NULL,190),(1109,'e1cc0f94-2e5a-483a-b306-457b20ef6c75','da33927f-07f9-40f5-ab87-4a396a5afb18','2025-12-06 04:37:11',NULL,'DELETE','COMPLETE','server','12751a0a-4c8c-4bf2-b035-8f876dd9066e','state changed','OS::Nova::Server',NULL,190),(1110,'56cb054f-9395-416f-8072-0e31c22dbcde','da33927f-07f9-40f5-ab87-4a396a5afb18','2025-12-06 04:37:11',NULL,'DELETE','IN_PROGRESS','subnet','2cc5353b-f3fe-4f03-b159-e7043638a9f5','state changed','OS::Neutron::Subnet',NULL,185),(1111,'d1846a27-2bc6-42f5-a9e2-b8f1efaefde7','da33927f-07f9-40f5-ab87-4a396a5afb18','2025-12-06 04:37:11',NULL,'DELETE','COMPLETE','subnet','2cc5353b-f3fe-4f03-b159-e7043638a9f5','state changed','OS::Neutron::Subnet',NULL,185),(1112,'6e79e05d-9153-47ac-9bef-110014950299','da33927f-07f9-40f5-ab87-4a396a5afb18','2025-12-06 04:37:11',NULL,'DELETE','IN_PROGRESS','net','fb6b677c-1569-42bb-993c-ea78451aefe3','state changed','OS::Neutron::Net',NULL,184),(1113,'e87f44d9-01a9-4123-9ff2-a6bb85a66980','da33927f-07f9-40f5-ab87-4a396a5afb18','2025-12-06 04:37:12',NULL,'DELETE','COMPLETE','net','fb6b677c-1569-42bb-993c-ea78451aefe3','state changed','OS::Neutron::Net',NULL,184),(1114,'6a25ee08-b31c-4565-b850-5fe2aa131f39','da33927f-07f9-40f5-ab87-4a396a5afb18','2025-12-06 04:37:12',NULL,'DELETE','COMPLETE','swap_subnet_network','da33927f-07f9-40f5-ab87-4a396a5afb18','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1115,'f75e16dd-861e-43cb-9ff7-30b3f79a009b','fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:37:13',NULL,'UPDATE','COMPLETE','server','276c3f87-58ec-4c17-a5f4-5523c5330d32','state changed','OS::Nova::Server',NULL,192),(1116,'660f6091-091c-4238-ad40-ee5a0a5400ea','fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:37:13',NULL,'UPDATE','COMPLETE','create_server_with_sub_ip','fa575325-64fd-4f36-af83-bafee4834a12','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1117,'5c063b5b-b965-44fb-85d0-84a60180fea6','8c1edcdf-b2b8-4cdb-9333-ef6e32048c46','2025-12-06 04:37:18',NULL,'CREATE','IN_PROGRESS','StackUnicodeTemplateTest-2051045241','8c1edcdf-b2b8-4cdb-9333-ef6e32048c46','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1118,'f0f240da-2e0d-4b21-b129-3af6137148fe','8c1edcdf-b2b8-4cdb-9333-ef6e32048c46','2025-12-06 04:37:18',NULL,'CREATE','IN_PROGRESS','资源','StackUnicodeTemplateTest-2051045241-资源-htxbdbdj3rre','state changed','OS::Heat::RandomString',NULL,193),(1119,'f35ab0ca-cf47-472f-8ec8-012727bc156c','8c1edcdf-b2b8-4cdb-9333-ef6e32048c46','2025-12-06 04:37:18',NULL,'CREATE','COMPLETE','资源','StackUnicodeTemplateTest-2051045241-资源-htxbdbdj3rre','state changed','OS::Heat::RandomString',NULL,193),(1120,'1693c90d-aa04-4c95-9dd0-f72326022f93','8c1edcdf-b2b8-4cdb-9333-ef6e32048c46','2025-12-06 04:37:18',NULL,'CREATE','COMPLETE','StackUnicodeTemplateTest-2051045241','8c1edcdf-b2b8-4cdb-9333-ef6e32048c46','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1121,'ca75dec4-dcba-4570-84fc-bb25e03a8eac','fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:37:19',NULL,'DELETE','IN_PROGRESS','create_server_with_sub_ip','fa575325-64fd-4f36-af83-bafee4834a12','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1122,'577e096d-5f02-420b-b255-2bd170206abf','fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:37:19',NULL,'DELETE','IN_PROGRESS','server','276c3f87-58ec-4c17-a5f4-5523c5330d32','state changed','OS::Nova::Server',NULL,192),(1123,'9cc48a99-1cb6-45a6-bc19-159e154ca98a','8c1edcdf-b2b8-4cdb-9333-ef6e32048c46','2025-12-06 04:37:19',NULL,'DELETE','IN_PROGRESS','StackUnicodeTemplateTest-2051045241','8c1edcdf-b2b8-4cdb-9333-ef6e32048c46','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1124,'29e75c30-fb48-43c7-91d8-7dd6adede86f','8c1edcdf-b2b8-4cdb-9333-ef6e32048c46','2025-12-06 04:37:19',NULL,'DELETE','IN_PROGRESS','资源','StackUnicodeTemplateTest-2051045241-资源-htxbdbdj3rre','state changed','OS::Heat::RandomString',NULL,193),(1125,'6a75e446-177a-41eb-9507-832c6822c109','8c1edcdf-b2b8-4cdb-9333-ef6e32048c46','2025-12-06 04:37:19',NULL,'DELETE','COMPLETE','资源','StackUnicodeTemplateTest-2051045241-资源-htxbdbdj3rre','state changed','OS::Heat::RandomString',NULL,193),(1126,'ba4d612d-4f23-4b14-ba61-157ed0a44608','8c1edcdf-b2b8-4cdb-9333-ef6e32048c46','2025-12-06 04:37:19',NULL,'DELETE','COMPLETE','StackUnicodeTemplateTest-2051045241','8c1edcdf-b2b8-4cdb-9333-ef6e32048c46','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1127,'ac75c38f-fc12-4b02-8148-37270152f051','fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:37:23',NULL,'DELETE','COMPLETE','server','276c3f87-58ec-4c17-a5f4-5523c5330d32','state changed','OS::Nova::Server',NULL,192),(1128,'44813434-c727-4710-8b7d-fa2c3bf82f8f','fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:37:24',NULL,'DELETE','IN_PROGRESS','subnet_b','579ac940-890f-4384-b6e7-0dc18af11849','state changed','OS::Neutron::Subnet',NULL,182),(1129,'88c3588b-9e59-4acf-b391-7a7148a4aafa','fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:37:24',NULL,'DELETE','IN_PROGRESS','subnet_a','88c33f60-89f1-4a43-ba8d-d2830eaa6d99','state changed','OS::Neutron::Subnet',NULL,183),(1130,'a77fa3eb-4848-4aeb-b255-c72efc42b73a','fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:37:27',NULL,'DELETE','COMPLETE','subnet_b','579ac940-890f-4384-b6e7-0dc18af11849','state changed','OS::Neutron::Subnet',NULL,182),(1131,'20ee62cc-7449-4a33-b3fe-d58f172a8c75','fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:37:27',NULL,'DELETE','COMPLETE','subnet_a','88c33f60-89f1-4a43-ba8d-d2830eaa6d99','state changed','OS::Neutron::Subnet',NULL,183),(1132,'4294822c-2274-42ed-b5bf-3be87b6c8c96','fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:37:27',NULL,'DELETE','IN_PROGRESS','net','4239dcbd-d6c3-426b-843a-295a3ed880d1','state changed','OS::Neutron::Net',NULL,181),(1133,'0fd84e63-658c-4071-85f9-020a2f88a3c2','fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:37:27',NULL,'DELETE','COMPLETE','net','4239dcbd-d6c3-426b-843a-295a3ed880d1','state changed','OS::Neutron::Net',NULL,181),(1134,'4401fa31-08ae-4fda-81c0-10ebaea94d82','fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:37:27',NULL,'DELETE','COMPLETE','create_server_with_sub_ip','fa575325-64fd-4f36-af83-bafee4834a12','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1135,'30cc1cea-27d4-4f16-9d3e-dfc44f4ee772','33729b66-d857-494a-b152-a364ad25ff94','2025-12-06 04:37:31',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-2056388355','33729b66-d857-494a-b152-a364ad25ff94','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1136,'f672382e-6ba1-4c02-9808-7b23e136ddc0','33729b66-d857-494a-b152-a364ad25ff94','2025-12-06 04:37:31',NULL,'CREATE','IN_PROGRESS','server','Pa-llelDeploymentsTest-2056388355-server-eblgw7yclh2q','state changed','OS::Nova::Server',NULL,195),(1137,'fa2a9d17-1573-44ab-a3b8-af9ac1250f19','33729b66-d857-494a-b152-a364ad25ff94','2025-12-06 04:37:45',NULL,'CREATE','COMPLETE','server','70ab76f9-c1b0-4a03-972f-cab7cba5a2f5','state changed','OS::Nova::Server',NULL,195),(1138,'ef1e5918-2b5b-41b0-bd5d-a4edfe716af8','33729b66-d857-494a-b152-a364ad25ff94','2025-12-06 04:37:45',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-2056388355','33729b66-d857-494a-b152-a364ad25ff94','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1139,'52d22227-e6c9-4371-aadb-25ec333559b1','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:37:51',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-796190467','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1140,'147d4860-8f9e-45f7-8014-9b9508b83934','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:37:53',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-796190467-config-ml5g2os3wvlf','state changed','OS::Heat::SoftwareConfig',NULL,196),(1141,'a9ce3e87-f055-4d43-adbb-ae0d406e17b0','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:37:53',NULL,'CREATE','COMPLETE','config','ae7968e6-dcd9-4ee4-9e1d-d1f5cbbbf5a3','state changed','OS::Heat::SoftwareConfig',NULL,196),(1142,'0542f171-4a7e-451c-8a8f-c335de8a1c15','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:37:53',NULL,'CREATE','IN_PROGRESS','dep_4','ParallelDeploymentsTest-796190467-dep_4-5l5rkc4rkbl4','state changed','OS::Heat::SoftwareDeployments',NULL,197),(1143,'378f319e-730c-411d-8053-55d91d9f0b41','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:37:53',NULL,'CREATE','IN_PROGRESS','dep_3','ParallelDeploymentsTest-796190467-dep_3-w4rpny2hfutm','state changed','OS::Heat::SoftwareDeployments',NULL,198),(1144,'09f552c1-6dfb-4a19-bcc9-1f7c08423cf3','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:37:53',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-796190467-dep_2-m4j3rhy5x3sh','state changed','OS::Heat::SoftwareDeployments',NULL,199),(1145,'4daa26ee-c1f6-4430-9d73-8f47db211cb7','7967df7a-68fa-4a43-bdb0-821ba4b96bb1','2025-12-06 04:37:53',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-796190467-dep_4-5l5rkc4rkbl4','7967df7a-68fa-4a43-bdb0-821ba4b96bb1','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1146,'79a24bae-8c08-42a0-9082-6d951d3cd303','32a9ef71-f427-412b-a14f-1110064ee79f','2025-12-06 04:37:53',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-796190467-dep_3-w4rpny2hfutm','32a9ef71-f427-412b-a14f-1110064ee79f','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1147,'63728048-48a0-4086-bd76-3e0a9318a57b','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:37:53',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-796190467-dep_1-dixzb6ouqerb','state changed','OS::Heat::SoftwareDeployments',NULL,200),(1148,'0faff932-1248-4116-b952-524360da18e7','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:37:53',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-796190467-dep_0-txogag7zsutv','state changed','OS::Heat::SoftwareDeployments',NULL,201),(1149,'590bcada-4d04-42d2-85f4-eeff836a33bd','5959fd78-7790-4543-84a2-60452176a852','2025-12-06 04:37:53',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-796190467-dep_2-m4j3rhy5x3sh','5959fd78-7790-4543-84a2-60452176a852','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1150,'74931d63-fbb6-4581-9385-3cf64a6f8c85','7967df7a-68fa-4a43-bdb0-821ba4b96bb1','2025-12-06 04:37:54',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-796190467-dep_4-5l5rkc4rkbl4-0-daufad2efiov','state changed','OS::Heat::SoftwareDeployment',NULL,202),(1151,'370a2390-b875-4d8a-8b27-0bb83a9c5130','03ba8d57-c0c6-4dd7-9ace-a80f1497e1f4','2025-12-06 04:37:54',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-796190467-dep_1-dixzb6ouqerb','03ba8d57-c0c6-4dd7-9ace-a80f1497e1f4','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1152,'13d368c6-3f60-4477-8335-35eba7b9c368','a489fb24-54df-4fa3-8800-1d2fd5fdad32','2025-12-06 04:37:54',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-796190467-dep_0-txogag7zsutv','a489fb24-54df-4fa3-8800-1d2fd5fdad32','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1153,'4b35ec9b-7029-443e-872c-fb1fbb87a4e0','32a9ef71-f427-412b-a14f-1110064ee79f','2025-12-06 04:37:54',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-796190467-dep_3-w4rpny2hfutm-0-5ep5w5fxobbf','state changed','OS::Heat::SoftwareDeployment',NULL,203),(1154,'d7c4faa3-fd7e-4685-b2e9-94d137abdd59','5959fd78-7790-4543-84a2-60452176a852','2025-12-06 04:37:54',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-796190467-dep_2-m4j3rhy5x3sh-0-tfzuqe235vva','state changed','OS::Heat::SoftwareDeployment',NULL,204),(1155,'405e47b3-18f9-405a-856a-d79b48283a7c','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:37:54',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1287797711','1326e81d-c775-44e9-b704-3d4b41a91f89','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1156,'5b701836-9668-4631-8113-5c2154db5066','03ba8d57-c0c6-4dd7-9ace-a80f1497e1f4','2025-12-06 04:37:54',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-796190467-dep_1-dixzb6ouqerb-0-xdnut6mom5sn','state changed','OS::Heat::SoftwareDeployment',NULL,205),(1157,'bea4445a-18ae-4089-90ea-57ca9363743e','a489fb24-54df-4fa3-8800-1d2fd5fdad32','2025-12-06 04:37:54',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-796190467-dep_0-txogag7zsutv-0-vopitpbxf47o','state changed','OS::Heat::SoftwareDeployment',NULL,206),(1158,'b90dffc2-8b82-4bd7-8bf6-54fdad1a21db','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:37:54',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-1287797711-config-ykzfaaeuc226','state changed','OS::Heat::SoftwareConfig',NULL,207),(1159,'ea1e2a36-a0c6-4100-a514-f00a384d589d','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:37:54',NULL,'CREATE','COMPLETE','config','ec676521-0249-4ea4-a897-c3b08bf881d0','state changed','OS::Heat::SoftwareConfig',NULL,207),(1160,'3bfb001d-ff58-4228-8352-5be8854072f3','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:37:54',NULL,'CREATE','IN_PROGRESS','dep_4','ParallelDeploymentsTest-1287797711-dep_4-euryujob2lky','state changed','OS::Heat::SoftwareDeployments',NULL,208),(1161,'651a5dbb-19c2-4a3c-9db9-53b08aa7dee6','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:37:54',NULL,'CREATE','IN_PROGRESS','dep_3','ParallelDeploymentsTest-1287797711-dep_3-itd463qzrk6l','state changed','OS::Heat::SoftwareDeployments',NULL,209),(1162,'f4e50b7d-85e6-4d23-9f16-182a9e470dd1','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:37:54',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-1287797711-dep_2-on4jhdwzy6ci','state changed','OS::Heat::SoftwareDeployments',NULL,210),(1163,'848eddae-0c4c-4e03-9ead-1506877876d3','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:37:54',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-1287797711-dep_1-ugecj2zbk73j','state changed','OS::Heat::SoftwareDeployments',NULL,211),(1164,'3bcb151d-590a-448b-9cde-ab0ba1a40809','40a720fe-4d5b-4614-97b6-f6c7da13689f','2025-12-06 04:37:54',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1287797711-dep_3-itd463qzrk6l','40a720fe-4d5b-4614-97b6-f6c7da13689f','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1165,'312bc2fe-bdf5-42ce-8bfc-d6282a97b98f','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:37:54',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-1287797711-dep_0-6vmc4aliomlp','state changed','OS::Heat::SoftwareDeployments',NULL,212),(1166,'26fe3178-5d58-4edc-86e4-756ccd6d6f60','a0e25fbe-b3e7-47a3-a8f0-2a362ef8447a','2025-12-06 04:37:54',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1287797711-dep_4-euryujob2lky','a0e25fbe-b3e7-47a3-a8f0-2a362ef8447a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1167,'21fafad8-d541-4c4b-b058-6c8f817e6258','81f3f155-2b09-47f6-a17b-108f033edcc8','2025-12-06 04:37:54',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1287797711-dep_2-on4jhdwzy6ci','81f3f155-2b09-47f6-a17b-108f033edcc8','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1168,'cb8f1a83-7fc3-486d-842f-bceb76320607','7dc8aa63-c560-4fc3-8d80-5507b1029158','2025-12-06 04:37:54',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1287797711-dep_1-ugecj2zbk73j','7dc8aa63-c560-4fc3-8d80-5507b1029158','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1169,'d3b7d746-7871-4847-9463-7107e12247da','40a720fe-4d5b-4614-97b6-f6c7da13689f','2025-12-06 04:37:54',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1287797711-dep_3-itd463qzrk6l-0-6oka4mx4kljf','state changed','OS::Heat::SoftwareDeployment',NULL,213),(1170,'99149093-2067-46f3-ad8b-60a2c012d7b4','81f3f155-2b09-47f6-a17b-108f033edcc8','2025-12-06 04:37:54',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1287797711-dep_2-on4jhdwzy6ci-0-47ndh3d466ib','state changed','OS::Heat::SoftwareDeployment',NULL,214),(1171,'7fe2cada-2e73-4135-9ad9-893a49a34ffc','ac3aa260-7638-4b1d-a06c-125c77c959b2','2025-12-06 04:37:54',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1287797711-dep_0-6vmc4aliomlp','ac3aa260-7638-4b1d-a06c-125c77c959b2','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1172,'c09e6038-e817-4dbe-9326-67766a0ac496','a0e25fbe-b3e7-47a3-a8f0-2a362ef8447a','2025-12-06 04:37:54',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1287797711-dep_4-euryujob2lky-0-qmcacgbvrovp','state changed','OS::Heat::SoftwareDeployment',NULL,215),(1173,'ee29f78e-0c3b-436d-99c4-c5f39e5f942c','7dc8aa63-c560-4fc3-8d80-5507b1029158','2025-12-06 04:37:54',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1287797711-dep_1-ugecj2zbk73j-0-iy6bvsr6yxkc','state changed','OS::Heat::SoftwareDeployment',NULL,216),(1174,'9202eacb-7dbb-44a4-bfdc-4f77f5b5b060','ac3aa260-7638-4b1d-a06c-125c77c959b2','2025-12-06 04:37:54',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1287797711-dep_0-6vmc4aliomlp-0-afybeioidb73','state changed','OS::Heat::SoftwareDeployment',NULL,217),(1175,'0f3439a9-4a73-4009-a901-1429480fff57','fa4f95c2-2ec3-4000-9201-2fcb3780307f','2025-12-06 04:38:02',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1504859677','fa4f95c2-2ec3-4000-9201-2fcb3780307f','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1176,'d2b73831-c6b7-49a5-8498-dff8b9c62806','fa4f95c2-2ec3-4000-9201-2fcb3780307f','2025-12-06 04:38:02',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-1504859677-config-kimmfficeag4','state changed','OS::Heat::SoftwareConfig',NULL,218),(1177,'f7468330-8a8e-4dd7-82ee-f78f6f37583c','fa4f95c2-2ec3-4000-9201-2fcb3780307f','2025-12-06 04:38:02',NULL,'CREATE','COMPLETE','config','acaaf735-bd9e-4a52-83f9-5890ced4a443','state changed','OS::Heat::SoftwareConfig',NULL,218),(1178,'e5c0897f-1fae-48a4-86cc-1c17b111eed1','fa4f95c2-2ec3-4000-9201-2fcb3780307f','2025-12-06 04:38:02',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-1504859677-dep_1-bs3xr3box7nj','state changed','OS::Heat::SoftwareDeployments',NULL,219),(1179,'d4b724f9-aecf-4894-a5fd-66fd8a692322','fa4f95c2-2ec3-4000-9201-2fcb3780307f','2025-12-06 04:38:02',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-1504859677-dep_2-wadsndhsuxa6','state changed','OS::Heat::SoftwareDeployments',NULL,220),(1180,'2b9930da-5c4c-4f57-bf9c-257be8dd5a8e','fa4f95c2-2ec3-4000-9201-2fcb3780307f','2025-12-06 04:38:02',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-1504859677-dep_0-nd3g2mpbvpyi','state changed','OS::Heat::SoftwareDeployments',NULL,221),(1181,'78011d53-24cb-4ecd-ace3-b4e4c6514f54','b50a060c-24a0-42a2-9ed9-fb8b7e59648a','2025-12-06 04:38:02',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1504859677-dep_1-bs3xr3box7nj','b50a060c-24a0-42a2-9ed9-fb8b7e59648a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1182,'5e732994-d85e-49fc-8551-ce4a219e5971','35d328f4-ee7e-4f36-9525-a4caf1efdee2','2025-12-06 04:38:02',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1504859677-dep_2-wadsndhsuxa6','35d328f4-ee7e-4f36-9525-a4caf1efdee2','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1183,'a48671c8-43d6-4898-8f82-e413e3a7b1b3','b2987bbc-cd98-412c-9cee-832c0d57203b','2025-12-06 04:38:02',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1504859677-dep_0-nd3g2mpbvpyi','b2987bbc-cd98-412c-9cee-832c0d57203b','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1184,'88b19598-dc79-457e-9843-e4269b282b92','35d328f4-ee7e-4f36-9525-a4caf1efdee2','2025-12-06 04:38:02',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1504859677-dep_2-wadsndhsuxa6-0-hdlipjh2ijmu','state changed','OS::Heat::SoftwareDeployment',NULL,222),(1185,'0cc0ef83-3d0a-4b0c-a1d1-2236672074c9','b50a060c-24a0-42a2-9ed9-fb8b7e59648a','2025-12-06 04:38:02',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1504859677-dep_1-bs3xr3box7nj-0-xfgbdnkgadke','state changed','OS::Heat::SoftwareDeployment',NULL,223),(1186,'0928bc19-3f75-4575-b51d-f2ca7e7bf985','b2987bbc-cd98-412c-9cee-832c0d57203b','2025-12-06 04:38:02',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1504859677-dep_0-nd3g2mpbvpyi-0-fxl6ycrxsbie','state changed','OS::Heat::SoftwareDeployment',NULL,224),(1187,'75395815-db84-4679-ab09-0ffac63b650e','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','2025-12-06 04:38:04',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1700023022','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1188,'5f35fc25-2af9-4b45-b4ba-734e35004055','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','2025-12-06 04:38:04',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-1700023022-config-d7qswaqzmnmu','state changed','OS::Heat::SoftwareConfig',NULL,225),(1189,'577bbcb0-e06c-4237-b127-0573921d02a7','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','2025-12-06 04:38:04',NULL,'CREATE','COMPLETE','config','e5c33846-8b92-40fc-8098-1b9140dbd9f0','state changed','OS::Heat::SoftwareConfig',NULL,225),(1190,'096ae644-9c9e-44e2-a135-d53d30a26464','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','2025-12-06 04:38:04',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-1700023022-dep_2-o65vs4l6xhe4','state changed','OS::Heat::SoftwareDeployments',NULL,226),(1191,'aa3d4471-a460-4797-95ba-ee9dc6a8aaf0','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','2025-12-06 04:38:04',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-1700023022-dep_0-rq2d722x4sgq','state changed','OS::Heat::SoftwareDeployments',NULL,227),(1192,'a64ebf42-e58e-426b-8fcb-5b090ae01b6f','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','2025-12-06 04:38:04',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-1700023022-dep_1-zc5owplcobgl','state changed','OS::Heat::SoftwareDeployments',NULL,228),(1193,'e831aa1c-8dda-401d-8c81-c084fda959bc','3da796f8-a8d2-48f6-94d6-873a981aacdd','2025-12-06 04:38:04',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1700023022-dep_0-rq2d722x4sgq','3da796f8-a8d2-48f6-94d6-873a981aacdd','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1194,'a8f34072-e16c-43d5-9e15-0fe0cf08b18a','2e8e9785-0960-4726-bf75-0356744490b8','2025-12-06 04:38:04',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1700023022-dep_2-o65vs4l6xhe4','2e8e9785-0960-4726-bf75-0356744490b8','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1195,'962ceee6-ee14-4505-a9a3-67a96327b675','94d6f227-51f1-4e49-8e59-bf2000bad4ac','2025-12-06 04:38:04',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1700023022-dep_1-zc5owplcobgl','94d6f227-51f1-4e49-8e59-bf2000bad4ac','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1196,'b872abac-36d7-4d79-9eba-ccc4a445fd94','3da796f8-a8d2-48f6-94d6-873a981aacdd','2025-12-06 04:38:04',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1700023022-dep_0-rq2d722x4sgq-0-c7pnfxvzil5e','state changed','OS::Heat::SoftwareDeployment',NULL,229),(1197,'6e799deb-a7ef-4c63-83f5-800c46a1b062','2e8e9785-0960-4726-bf75-0356744490b8','2025-12-06 04:38:04',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1700023022-dep_2-o65vs4l6xhe4-0-vycpfpyujhea','state changed','OS::Heat::SoftwareDeployment',NULL,230),(1198,'8c5fd2f2-874a-48a3-a65e-1fcdbe772e4f','94d6f227-51f1-4e49-8e59-bf2000bad4ac','2025-12-06 04:38:04',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1700023022-dep_1-zc5owplcobgl-0-mf6ql3ur2mrr','state changed','OS::Heat::SoftwareDeployment',NULL,231),(1199,'cf0aa44d-717c-422d-8531-9aec3ffd06fd','8bb330dc-64fc-4131-8131-786ce5a2c07f','2025-12-06 04:38:05',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1080007079','8bb330dc-64fc-4131-8131-786ce5a2c07f','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1200,'6d6fb381-700d-4005-ada9-a89feb116dd3','8bb330dc-64fc-4131-8131-786ce5a2c07f','2025-12-06 04:38:05',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-1080007079-config-xevae6sv7qok','state changed','OS::Heat::SoftwareConfig',NULL,232),(1201,'6fafae2b-0efc-47f8-b33e-8dd1545e17f7','8bb330dc-64fc-4131-8131-786ce5a2c07f','2025-12-06 04:38:08',NULL,'CREATE','COMPLETE','config','b20d1fd1-2bd2-48cf-a825-309052cf9ccb','state changed','OS::Heat::SoftwareConfig',NULL,232),(1202,'d6137b50-45a0-4f2e-84e4-82d0a8909b98','8bb330dc-64fc-4131-8131-786ce5a2c07f','2025-12-06 04:38:08',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-1080007079-dep_0-o4by3xv37yjg','state changed','OS::Heat::SoftwareDeployments',NULL,233),(1203,'b7ee4ae5-79ae-4934-8450-568b2eb234d7','8bb330dc-64fc-4131-8131-786ce5a2c07f','2025-12-06 04:38:08',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-1080007079-dep_1-dzf3ueiakkj6','state changed','OS::Heat::SoftwareDeployments',NULL,234),(1204,'20a5579c-d21f-4967-bcb0-20800cd54d1f','8bb330dc-64fc-4131-8131-786ce5a2c07f','2025-12-06 04:38:08',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-1080007079-dep_2-ocodvce77vfp','state changed','OS::Heat::SoftwareDeployments',NULL,235),(1205,'8d80b093-b392-433f-95cc-120f3a012ade','2f038ab6-0913-4deb-8e67-6f13fb08bcd5','2025-12-06 04:38:09',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1080007079-dep_0-o4by3xv37yjg','2f038ab6-0913-4deb-8e67-6f13fb08bcd5','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1206,'043a3d69-4f28-4d57-b284-cafb3b0beb60','d676cc74-f520-4420-84f7-26fb9ab3b975','2025-12-06 04:38:09',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1080007079-dep_1-dzf3ueiakkj6','d676cc74-f520-4420-84f7-26fb9ab3b975','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1207,'b9d2354b-727e-41af-bf88-399efd42fc94','29f1f4a3-9cba-41c1-8c7e-e84dff6d00f8','2025-12-06 04:38:09',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1080007079-dep_2-ocodvce77vfp','29f1f4a3-9cba-41c1-8c7e-e84dff6d00f8','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1208,'a2f95db1-b3f1-4818-bf22-14e3218bc9f7','d676cc74-f520-4420-84f7-26fb9ab3b975','2025-12-06 04:38:09',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1080007079-dep_1-dzf3ueiakkj6-0-e34ikvpk6y4x','state changed','OS::Heat::SoftwareDeployment',NULL,236),(1209,'3003c01e-944f-4383-a393-7ff4d2816697','2f038ab6-0913-4deb-8e67-6f13fb08bcd5','2025-12-06 04:38:09',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1080007079-dep_0-o4by3xv37yjg-0-5oexdivuwzqs','state changed','OS::Heat::SoftwareDeployment',NULL,237),(1210,'5db1060f-d36e-4644-b32d-a1a06c954b96','29f1f4a3-9cba-41c1-8c7e-e84dff6d00f8','2025-12-06 04:38:09',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1080007079-dep_2-ocodvce77vfp-0-eqcz4xbzmnfl','state changed','OS::Heat::SoftwareDeployment',NULL,238),(1211,'6cd56ad7-9ca5-481c-afaf-2908535c274a','d676cc74-f520-4420-84f7-26fb9ab3b975','2025-12-06 04:38:19',NULL,'SIGNAL','IN_PROGRESS','0','0bec04d7-c416-43dd-8cb8-43f7e26a3e0c','Signal: deployment 0bec04d7-c416-43dd-8cb8-43f7e26a3e0c succeeded','OS::Heat::SoftwareDeployment',NULL,236),(1212,'2c9509a2-e290-4f1b-9248-fd04d9734ffc','d676cc74-f520-4420-84f7-26fb9ab3b975','2025-12-06 04:38:19',NULL,'CREATE','COMPLETE','0','0bec04d7-c416-43dd-8cb8-43f7e26a3e0c','state changed','OS::Heat::SoftwareDeployment',NULL,236),(1213,'af5a0f4b-9999-4ebf-bcff-9df46be60066','d676cc74-f520-4420-84f7-26fb9ab3b975','2025-12-06 04:38:20',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1080007079-dep_1-dzf3ueiakkj6','d676cc74-f520-4420-84f7-26fb9ab3b975','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1214,'0f828103-6111-4c42-a688-50316bc1b09e','2f038ab6-0913-4deb-8e67-6f13fb08bcd5','2025-12-06 04:38:20',NULL,'SIGNAL','IN_PROGRESS','0','ae077f09-a848-48c6-885f-6cf896c99fd4','Signal: deployment ae077f09-a848-48c6-885f-6cf896c99fd4 succeeded','OS::Heat::SoftwareDeployment',NULL,237),(1215,'92c93a96-0e49-4c53-b56a-8b9dfb2b63d7','2f038ab6-0913-4deb-8e67-6f13fb08bcd5','2025-12-06 04:38:21',NULL,'CREATE','COMPLETE','0','ae077f09-a848-48c6-885f-6cf896c99fd4','state changed','OS::Heat::SoftwareDeployment',NULL,237),(1216,'ddb82536-c6f5-4b34-93ce-07be1753c8fa','8bb330dc-64fc-4131-8131-786ce5a2c07f','2025-12-06 04:38:21',NULL,'CREATE','COMPLETE','dep_1','d676cc74-f520-4420-84f7-26fb9ab3b975','state changed','OS::Heat::SoftwareDeployments',NULL,234),(1217,'ba83bbdb-7529-444a-aff1-e8694ac7f188','29f1f4a3-9cba-41c1-8c7e-e84dff6d00f8','2025-12-06 04:38:21',NULL,'SIGNAL','IN_PROGRESS','0','52320d36-d025-4998-b085-8271f6c29661','Signal: deployment 52320d36-d025-4998-b085-8271f6c29661 succeeded','OS::Heat::SoftwareDeployment',NULL,238),(1218,'3db97a26-9cd2-4d9e-b2b7-b7669a965092','2f038ab6-0913-4deb-8e67-6f13fb08bcd5','2025-12-06 04:38:21',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1080007079-dep_0-o4by3xv37yjg','2f038ab6-0913-4deb-8e67-6f13fb08bcd5','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1219,'06f78255-9e60-43ad-bdb5-2453c7c05dff','8bb330dc-64fc-4131-8131-786ce5a2c07f','2025-12-06 04:38:25',NULL,'CREATE','COMPLETE','dep_0','2f038ab6-0913-4deb-8e67-6f13fb08bcd5','state changed','OS::Heat::SoftwareDeployments',NULL,233),(1220,'c05a3de0-e272-4a0f-9b73-43e35e402433','29f1f4a3-9cba-41c1-8c7e-e84dff6d00f8','2025-12-06 04:38:25',NULL,'CREATE','COMPLETE','0','52320d36-d025-4998-b085-8271f6c29661','state changed','OS::Heat::SoftwareDeployment',NULL,238),(1221,'c0221a8b-2459-4420-a6c5-757cfe963f52','a0e25fbe-b3e7-47a3-a8f0-2a362ef8447a','2025-12-06 04:38:25',NULL,'SIGNAL','IN_PROGRESS','0','1a5a56a3-24bf-4e83-a3aa-fb03b94dd3dc','Signal: deployment 1a5a56a3-24bf-4e83-a3aa-fb03b94dd3dc succeeded','OS::Heat::SoftwareDeployment',NULL,215),(1222,'2544f226-712a-4b82-83fc-bdeac7649343','29f1f4a3-9cba-41c1-8c7e-e84dff6d00f8','2025-12-06 04:38:25',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1080007079-dep_2-ocodvce77vfp','29f1f4a3-9cba-41c1-8c7e-e84dff6d00f8','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1223,'e43f0de7-ad60-4e66-83c6-87137e3a4d35','8bb330dc-64fc-4131-8131-786ce5a2c07f','2025-12-06 04:38:26',NULL,'CREATE','COMPLETE','dep_2','29f1f4a3-9cba-41c1-8c7e-e84dff6d00f8','state changed','OS::Heat::SoftwareDeployments',NULL,235),(1224,'70575c4c-431f-4970-9509-6510b18c3e61','a0e25fbe-b3e7-47a3-a8f0-2a362ef8447a','2025-12-06 04:38:28',NULL,'CREATE','COMPLETE','0','1a5a56a3-24bf-4e83-a3aa-fb03b94dd3dc','state changed','OS::Heat::SoftwareDeployment',NULL,215),(1225,'051b7fb1-51be-4d23-b723-c12217bb024c','40a720fe-4d5b-4614-97b6-f6c7da13689f','2025-12-06 04:38:28',NULL,'SIGNAL','IN_PROGRESS','0','3ed3dc9b-aa03-4937-a79a-22590f1051f1','Signal: deployment 3ed3dc9b-aa03-4937-a79a-22590f1051f1 succeeded','OS::Heat::SoftwareDeployment',NULL,213),(1226,'9dce8b64-2b78-49bf-985f-9b6f44ee1d83','8bb330dc-64fc-4131-8131-786ce5a2c07f','2025-12-06 04:38:28',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1080007079','8bb330dc-64fc-4131-8131-786ce5a2c07f','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1227,'2ccd34ca-433c-40c2-92d7-952d6790185c','40a720fe-4d5b-4614-97b6-f6c7da13689f','2025-12-06 04:38:28',NULL,'CREATE','COMPLETE','0','3ed3dc9b-aa03-4937-a79a-22590f1051f1','state changed','OS::Heat::SoftwareDeployment',NULL,213),(1228,'ce1d3c50-6244-4bfc-be1d-fd71373d940d','a0e25fbe-b3e7-47a3-a8f0-2a362ef8447a','2025-12-06 04:38:28',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1287797711-dep_4-euryujob2lky','a0e25fbe-b3e7-47a3-a8f0-2a362ef8447a','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1229,'725ee766-2af5-4c45-8323-89af4edaf288','40a720fe-4d5b-4614-97b6-f6c7da13689f','2025-12-06 04:38:28',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1287797711-dep_3-itd463qzrk6l','40a720fe-4d5b-4614-97b6-f6c7da13689f','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1230,'6a50e628-9a66-4c03-817d-1a488f6a751c','7dc8aa63-c560-4fc3-8d80-5507b1029158','2025-12-06 04:38:28',NULL,'SIGNAL','IN_PROGRESS','0','4fd84b96-e2bb-47cf-b65e-67f61e35ba6e','Signal: deployment 4fd84b96-e2bb-47cf-b65e-67f61e35ba6e succeeded','OS::Heat::SoftwareDeployment',NULL,216),(1231,'26d8a189-2463-4618-9c25-6c3acedc3345','81f3f155-2b09-47f6-a17b-108f033edcc8','2025-12-06 04:38:28',NULL,'SIGNAL','IN_PROGRESS','0','733933fe-1f26-4369-ae02-c26200add634','Signal: deployment 733933fe-1f26-4369-ae02-c26200add634 succeeded','OS::Heat::SoftwareDeployment',NULL,214),(1232,'712896bb-51b9-4515-8c2c-7e11218a545f','ac3aa260-7638-4b1d-a06c-125c77c959b2','2025-12-06 04:38:28',NULL,'SIGNAL','IN_PROGRESS','0','8f5810e9-7abc-484c-8586-b8a5c535161e','Signal: deployment 8f5810e9-7abc-484c-8586-b8a5c535161e succeeded','OS::Heat::SoftwareDeployment',NULL,217),(1233,'9fe55da3-5d4c-4626-bedd-ec526be3dcf9','ac3aa260-7638-4b1d-a06c-125c77c959b2','2025-12-06 04:38:29',NULL,'CREATE','COMPLETE','0','8f5810e9-7abc-484c-8586-b8a5c535161e','state changed','OS::Heat::SoftwareDeployment',NULL,217),(1234,'418a1474-5b0c-474d-9f8d-a1a7213d7943','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:38:30',NULL,'CREATE','COMPLETE','dep_3','40a720fe-4d5b-4614-97b6-f6c7da13689f','state changed','OS::Heat::SoftwareDeployments',NULL,209),(1235,'0b039c73-29b1-4dd2-b03a-29637706800d','35d328f4-ee7e-4f36-9525-a4caf1efdee2','2025-12-06 04:38:30',NULL,'SIGNAL','IN_PROGRESS','0','18c74a26-4e20-4e51-b895-50e2a14db9dc','Signal: deployment 18c74a26-4e20-4e51-b895-50e2a14db9dc succeeded','OS::Heat::SoftwareDeployment',NULL,222),(1236,'bb51fcd8-2092-4771-bb9e-72cacad27382','ac3aa260-7638-4b1d-a06c-125c77c959b2','2025-12-06 04:38:30',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1287797711-dep_0-6vmc4aliomlp','ac3aa260-7638-4b1d-a06c-125c77c959b2','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1237,'a0ce7aa0-363b-4ba9-b721-9f23e20e09f4','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:38:30',NULL,'CREATE','COMPLETE','dep_4','a0e25fbe-b3e7-47a3-a8f0-2a362ef8447a','state changed','OS::Heat::SoftwareDeployments',NULL,208),(1238,'d4f9248d-c515-48c9-b2ef-55e53d72a916','7dc8aa63-c560-4fc3-8d80-5507b1029158','2025-12-06 04:38:30',NULL,'CREATE','COMPLETE','0','4fd84b96-e2bb-47cf-b65e-67f61e35ba6e','state changed','OS::Heat::SoftwareDeployment',NULL,216),(1239,'eaf280e5-b734-412b-a1c5-133d611fae2f','81f3f155-2b09-47f6-a17b-108f033edcc8','2025-12-06 04:38:30',NULL,'CREATE','COMPLETE','0','733933fe-1f26-4369-ae02-c26200add634','state changed','OS::Heat::SoftwareDeployment',NULL,214),(1240,'68b3414c-6407-4dd4-890a-20044a3f1944','81f3f155-2b09-47f6-a17b-108f033edcc8','2025-12-06 04:38:30',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1287797711-dep_2-on4jhdwzy6ci','81f3f155-2b09-47f6-a17b-108f033edcc8','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1241,'106fda47-0b98-4cb4-b669-155728f68838','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:38:30',NULL,'CREATE','COMPLETE','dep_0','ac3aa260-7638-4b1d-a06c-125c77c959b2','state changed','OS::Heat::SoftwareDeployments',NULL,212),(1242,'41e3b412-d267-4f15-826a-c110463e056f','7dc8aa63-c560-4fc3-8d80-5507b1029158','2025-12-06 04:38:31',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1287797711-dep_1-ugecj2zbk73j','7dc8aa63-c560-4fc3-8d80-5507b1029158','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1243,'d3e01c17-f2f2-48e3-b9ac-74cbfd52b04e','b2987bbc-cd98-412c-9cee-832c0d57203b','2025-12-06 04:38:31',NULL,'SIGNAL','IN_PROGRESS','0','21827941-9549-4ae4-bce0-b612b6dfa569','Signal: deployment 21827941-9549-4ae4-bce0-b612b6dfa569 succeeded','OS::Heat::SoftwareDeployment',NULL,224),(1244,'7999e9be-9b29-49df-9240-f12bd3284fb0','b50a060c-24a0-42a2-9ed9-fb8b7e59648a','2025-12-06 04:38:31',NULL,'SIGNAL','IN_PROGRESS','0','d8e52e1b-1a50-40b2-9d2d-fba732837157','Signal: deployment d8e52e1b-1a50-40b2-9d2d-fba732837157 succeeded','OS::Heat::SoftwareDeployment',NULL,223),(1245,'e394f935-c8e1-407e-8257-d4867afa83c5','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:38:32',NULL,'CREATE','COMPLETE','dep_2','81f3f155-2b09-47f6-a17b-108f033edcc8','state changed','OS::Heat::SoftwareDeployments',NULL,210),(1246,'b213e393-3233-4dd4-91fc-daf2c0771f79','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:38:32',NULL,'CREATE','COMPLETE','dep_1','7dc8aa63-c560-4fc3-8d80-5507b1029158','state changed','OS::Heat::SoftwareDeployments',NULL,211),(1247,'6fee7115-2c85-4832-b0c2-faff10e479be','35d328f4-ee7e-4f36-9525-a4caf1efdee2','2025-12-06 04:38:32',NULL,'CREATE','COMPLETE','0','18c74a26-4e20-4e51-b895-50e2a14db9dc','state changed','OS::Heat::SoftwareDeployment',NULL,222),(1248,'32a226e5-d196-48d5-a683-a494adc07b32','b2987bbc-cd98-412c-9cee-832c0d57203b','2025-12-06 04:38:32',NULL,'CREATE','COMPLETE','0','21827941-9549-4ae4-bce0-b612b6dfa569','state changed','OS::Heat::SoftwareDeployment',NULL,224),(1249,'005d8e20-da18-49d5-9ec1-7882b415a2c7','3da796f8-a8d2-48f6-94d6-873a981aacdd','2025-12-06 04:38:32',NULL,'SIGNAL','IN_PROGRESS','0','32227c59-2526-4751-becd-03c3541523d5','Signal: deployment 32227c59-2526-4751-becd-03c3541523d5 succeeded','OS::Heat::SoftwareDeployment',NULL,229),(1250,'db4a29b7-f196-4032-b5cb-fc729d5b1bad','b50a060c-24a0-42a2-9ed9-fb8b7e59648a','2025-12-06 04:38:32',NULL,'CREATE','COMPLETE','0','d8e52e1b-1a50-40b2-9d2d-fba732837157','state changed','OS::Heat::SoftwareDeployment',NULL,223),(1251,'b62fe2af-b37b-458b-a546-9056f8d03db2','35d328f4-ee7e-4f36-9525-a4caf1efdee2','2025-12-06 04:38:33',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1504859677-dep_2-wadsndhsuxa6','35d328f4-ee7e-4f36-9525-a4caf1efdee2','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1252,'89560b5c-2785-4297-963b-9caf503ede92','b2987bbc-cd98-412c-9cee-832c0d57203b','2025-12-06 04:38:33',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1504859677-dep_0-nd3g2mpbvpyi','b2987bbc-cd98-412c-9cee-832c0d57203b','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1253,'bdb2b99e-df37-4d2b-941b-79f298a066ec','b50a060c-24a0-42a2-9ed9-fb8b7e59648a','2025-12-06 04:38:33',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1504859677-dep_1-bs3xr3box7nj','b50a060c-24a0-42a2-9ed9-fb8b7e59648a','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1254,'ba0f5b92-7460-4bd1-b58c-700b1ec4a888','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:38:33',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1287797711','1326e81d-c775-44e9-b704-3d4b41a91f89','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1255,'31cbef99-2e92-4fd6-aa3b-a4ee52c6601d','94d6f227-51f1-4e49-8e59-bf2000bad4ac','2025-12-06 04:38:33',NULL,'SIGNAL','IN_PROGRESS','0','d1cc43b3-412c-494d-81ab-873442fec2c1','Signal: deployment d1cc43b3-412c-494d-81ab-873442fec2c1 succeeded','OS::Heat::SoftwareDeployment',NULL,231),(1256,'6f012168-dff1-4a34-9e6e-edcb7e0fecf3','2e8e9785-0960-4726-bf75-0356744490b8','2025-12-06 04:38:33',NULL,'SIGNAL','IN_PROGRESS','0','de413000-1bf3-4d18-b043-df9cd6e9e36f','Signal: deployment de413000-1bf3-4d18-b043-df9cd6e9e36f succeeded','OS::Heat::SoftwareDeployment',NULL,230),(1257,'f5e0986e-d7e1-45b3-94ce-83e3fdd2163d','fa4f95c2-2ec3-4000-9201-2fcb3780307f','2025-12-06 04:38:33',NULL,'CREATE','COMPLETE','dep_2','35d328f4-ee7e-4f36-9525-a4caf1efdee2','state changed','OS::Heat::SoftwareDeployments',NULL,220),(1258,'12406aca-0e53-4ea4-b83e-21d747ac0b2e','7967df7a-68fa-4a43-bdb0-821ba4b96bb1','2025-12-06 04:38:34',NULL,'SIGNAL','IN_PROGRESS','0','ddfaa87e-0560-4446-84cf-0c23755f1b2b','Signal: deployment ddfaa87e-0560-4446-84cf-0c23755f1b2b succeeded','OS::Heat::SoftwareDeployment',NULL,202),(1259,'1f533b3d-8d14-44f6-846e-3b4587651100','fa4f95c2-2ec3-4000-9201-2fcb3780307f','2025-12-06 04:38:34',NULL,'CREATE','COMPLETE','dep_1','b50a060c-24a0-42a2-9ed9-fb8b7e59648a','state changed','OS::Heat::SoftwareDeployments',NULL,219),(1260,'9374af27-49c5-42ef-af92-4202a254fad7','fa4f95c2-2ec3-4000-9201-2fcb3780307f','2025-12-06 04:38:34',NULL,'CREATE','COMPLETE','dep_0','b2987bbc-cd98-412c-9cee-832c0d57203b','state changed','OS::Heat::SoftwareDeployments',NULL,221),(1261,'0ddc3e86-5f93-4fbe-b225-a3f0694960ae','3da796f8-a8d2-48f6-94d6-873a981aacdd','2025-12-06 04:38:34',NULL,'CREATE','COMPLETE','0','32227c59-2526-4751-becd-03c3541523d5','state changed','OS::Heat::SoftwareDeployment',NULL,229),(1262,'9b712fd2-d621-4a2c-8a7c-8db051254cf0','7967df7a-68fa-4a43-bdb0-821ba4b96bb1','2025-12-06 04:38:34',NULL,'CREATE','COMPLETE','0','ddfaa87e-0560-4446-84cf-0c23755f1b2b','state changed','OS::Heat::SoftwareDeployment',NULL,202),(1263,'e257b907-4d88-4a59-8e5b-67adcbb5e883','94d6f227-51f1-4e49-8e59-bf2000bad4ac','2025-12-06 04:38:34',NULL,'CREATE','COMPLETE','0','d1cc43b3-412c-494d-81ab-873442fec2c1','state changed','OS::Heat::SoftwareDeployment',NULL,231),(1264,'810dc3d6-3d7e-474f-9111-4405069d4efd','2e8e9785-0960-4726-bf75-0356744490b8','2025-12-06 04:38:34',NULL,'CREATE','COMPLETE','0','de413000-1bf3-4d18-b043-df9cd6e9e36f','state changed','OS::Heat::SoftwareDeployment',NULL,230),(1265,'b97d9190-0f79-4937-b244-31d76d60d821','a489fb24-54df-4fa3-8800-1d2fd5fdad32','2025-12-06 04:38:34',NULL,'SIGNAL','IN_PROGRESS','0','2b998e93-80b9-46c1-915e-c2c53039936a','Signal: deployment 2b998e93-80b9-46c1-915e-c2c53039936a succeeded','OS::Heat::SoftwareDeployment',NULL,206),(1266,'f94be551-8a72-4305-af27-33272304c3b7','5959fd78-7790-4543-84a2-60452176a852','2025-12-06 04:38:34',NULL,'SIGNAL','IN_PROGRESS','0','0f496ff4-632a-4c58-aa55-fdaaaf46a339','Signal: deployment 0f496ff4-632a-4c58-aa55-fdaaaf46a339 succeeded','OS::Heat::SoftwareDeployment',NULL,204),(1267,'46914196-d379-4c7f-8ecf-d704bb4cc034','3da796f8-a8d2-48f6-94d6-873a981aacdd','2025-12-06 04:38:34',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1700023022-dep_0-rq2d722x4sgq','3da796f8-a8d2-48f6-94d6-873a981aacdd','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1268,'273796f4-b0e9-430b-91c0-612d532529b6','fa4f95c2-2ec3-4000-9201-2fcb3780307f','2025-12-06 04:38:34',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1504859677','fa4f95c2-2ec3-4000-9201-2fcb3780307f','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1269,'b9255c68-d1a9-4eb1-aca2-8f45deeb664e','94d6f227-51f1-4e49-8e59-bf2000bad4ac','2025-12-06 04:38:34',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1700023022-dep_1-zc5owplcobgl','94d6f227-51f1-4e49-8e59-bf2000bad4ac','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1270,'bfe97d7a-743b-4504-9044-d3756708ed05','7967df7a-68fa-4a43-bdb0-821ba4b96bb1','2025-12-06 04:38:34',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-796190467-dep_4-5l5rkc4rkbl4','7967df7a-68fa-4a43-bdb0-821ba4b96bb1','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1271,'863c17d0-e466-4fb6-9fd6-7bef4e8c9919','2e8e9785-0960-4726-bf75-0356744490b8','2025-12-06 04:38:34',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1700023022-dep_2-o65vs4l6xhe4','2e8e9785-0960-4726-bf75-0356744490b8','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1272,'30ebd111-7123-4539-9924-36af127f2fbf','32a9ef71-f427-412b-a14f-1110064ee79f','2025-12-06 04:38:34',NULL,'SIGNAL','IN_PROGRESS','0','b334f0d6-5d25-466a-bd84-a010b407e35d','Signal: deployment b334f0d6-5d25-466a-bd84-a010b407e35d succeeded','OS::Heat::SoftwareDeployment',NULL,203),(1273,'88340f47-1277-47c4-86f0-39e58eac0f91','03ba8d57-c0c6-4dd7-9ace-a80f1497e1f4','2025-12-06 04:38:34',NULL,'SIGNAL','IN_PROGRESS','0','fa27f470-99ee-47f6-8f1d-d6978b46482b','Signal: deployment fa27f470-99ee-47f6-8f1d-d6978b46482b succeeded','OS::Heat::SoftwareDeployment',NULL,205),(1274,'90f0773b-4148-435e-917e-5210b068695e','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','2025-12-06 04:38:34',NULL,'CREATE','COMPLETE','dep_2','2e8e9785-0960-4726-bf75-0356744490b8','state changed','OS::Heat::SoftwareDeployments',NULL,226),(1275,'bfbc8c9c-9c54-476a-86c1-f0044bfc36bb','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','2025-12-06 04:38:34',NULL,'CREATE','COMPLETE','dep_1','94d6f227-51f1-4e49-8e59-bf2000bad4ac','state changed','OS::Heat::SoftwareDeployments',NULL,228),(1276,'11d01ad9-b43d-42b6-b049-61fb33ea5690','5959fd78-7790-4543-84a2-60452176a852','2025-12-06 04:38:35',NULL,'CREATE','COMPLETE','0','0f496ff4-632a-4c58-aa55-fdaaaf46a339','state changed','OS::Heat::SoftwareDeployment',NULL,204),(1277,'fea8ac9d-ba6f-4a8b-b6c6-03f1d4faa1f9','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:38:35',NULL,'CREATE','COMPLETE','dep_4','7967df7a-68fa-4a43-bdb0-821ba4b96bb1','state changed','OS::Heat::SoftwareDeployments',NULL,197),(1278,'6185515f-2e70-4c2d-b694-f01e7a29546b','a489fb24-54df-4fa3-8800-1d2fd5fdad32','2025-12-06 04:38:35',NULL,'CREATE','COMPLETE','0','2b998e93-80b9-46c1-915e-c2c53039936a','state changed','OS::Heat::SoftwareDeployment',NULL,206),(1279,'6e409bab-924f-4b40-80a0-10877491fad4','32a9ef71-f427-412b-a14f-1110064ee79f','2025-12-06 04:38:35',NULL,'CREATE','COMPLETE','0','b334f0d6-5d25-466a-bd84-a010b407e35d','state changed','OS::Heat::SoftwareDeployment',NULL,203),(1280,'3d70ea4c-7c63-4540-8330-a1663eb652b2','03ba8d57-c0c6-4dd7-9ace-a80f1497e1f4','2025-12-06 04:38:35',NULL,'CREATE','COMPLETE','0','fa27f470-99ee-47f6-8f1d-d6978b46482b','state changed','OS::Heat::SoftwareDeployment',NULL,205),(1281,'3cecf06d-0d53-4423-92f1-6faee80271ed','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','2025-12-06 04:38:35',NULL,'CREATE','COMPLETE','dep_0','3da796f8-a8d2-48f6-94d6-873a981aacdd','state changed','OS::Heat::SoftwareDeployments',NULL,227),(1282,'87ab1210-6d1d-45d4-9000-5add478fb2d0','5959fd78-7790-4543-84a2-60452176a852','2025-12-06 04:38:35',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-796190467-dep_2-m4j3rhy5x3sh','5959fd78-7790-4543-84a2-60452176a852','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1283,'e3210508-6012-4e11-8c9a-813ee4581134','a489fb24-54df-4fa3-8800-1d2fd5fdad32','2025-12-06 04:38:35',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-796190467-dep_0-txogag7zsutv','a489fb24-54df-4fa3-8800-1d2fd5fdad32','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1284,'92a61acc-46b2-4ae9-8ccd-1f8ceacd4b11','32a9ef71-f427-412b-a14f-1110064ee79f','2025-12-06 04:38:35',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-796190467-dep_3-w4rpny2hfutm','32a9ef71-f427-412b-a14f-1110064ee79f','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1285,'1807b94d-c150-449f-ac1e-edbde002273c','03ba8d57-c0c6-4dd7-9ace-a80f1497e1f4','2025-12-06 04:38:35',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-796190467-dep_1-dixzb6ouqerb','03ba8d57-c0c6-4dd7-9ace-a80f1497e1f4','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1286,'e53a75e4-cc99-41c0-a26f-0f5a13d5adb0','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','2025-12-06 04:38:35',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1700023022','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1287,'e0030640-7bbe-4e90-993d-b56ecdae8fda','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:38:35',NULL,'CREATE','COMPLETE','dep_3','32a9ef71-f427-412b-a14f-1110064ee79f','state changed','OS::Heat::SoftwareDeployments',NULL,198),(1288,'95e2afb6-5ae0-4809-b500-2ed0bb95963e','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:38:35',NULL,'CREATE','COMPLETE','dep_2','5959fd78-7790-4543-84a2-60452176a852','state changed','OS::Heat::SoftwareDeployments',NULL,199),(1289,'34c30efa-a211-4e1d-bc07-37508e4fee85','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:38:35',NULL,'CREATE','COMPLETE','dep_1','03ba8d57-c0c6-4dd7-9ace-a80f1497e1f4','state changed','OS::Heat::SoftwareDeployments',NULL,200),(1290,'f4614454-97c4-4024-bf54-3aa0a0a00e2c','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:38:35',NULL,'CREATE','COMPLETE','dep_0','a489fb24-54df-4fa3-8800-1d2fd5fdad32','state changed','OS::Heat::SoftwareDeployments',NULL,201),(1291,'07b48c92-d696-4795-a1b2-89e5e43960c2','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:38:35',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-796190467','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1292,'e865f2c8-c7a1-4e77-b1f2-c70477848289','8bb330dc-64fc-4131-8131-786ce5a2c07f','2025-12-06 04:38:40',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1080007079','8bb330dc-64fc-4131-8131-786ce5a2c07f','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1293,'4dc4114d-0781-42fe-9640-717eb5e9d860','8bb330dc-64fc-4131-8131-786ce5a2c07f','2025-12-06 04:38:40',NULL,'DELETE','IN_PROGRESS','dep_1','d676cc74-f520-4420-84f7-26fb9ab3b975','state changed','OS::Heat::SoftwareDeployments',NULL,234),(1294,'d1b8d165-ceac-4aa6-aec3-17f659d8ae85','d676cc74-f520-4420-84f7-26fb9ab3b975','2025-12-06 04:38:40',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1080007079-dep_1-dzf3ueiakkj6','d676cc74-f520-4420-84f7-26fb9ab3b975','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1295,'835af81e-4917-42be-9179-fc5b61e3d3ea','d676cc74-f520-4420-84f7-26fb9ab3b975','2025-12-06 04:38:40',NULL,'DELETE','IN_PROGRESS','0','0bec04d7-c416-43dd-8cb8-43f7e26a3e0c','state changed','OS::Heat::SoftwareDeployment',NULL,236),(1296,'c97d5064-1601-43c1-8037-69e383c15a2e','8bb330dc-64fc-4131-8131-786ce5a2c07f','2025-12-06 04:38:41',NULL,'DELETE','IN_PROGRESS','dep_2','29f1f4a3-9cba-41c1-8c7e-e84dff6d00f8','state changed','OS::Heat::SoftwareDeployments',NULL,235),(1297,'9a75a0eb-9053-463c-ac77-b724eeca1c85','29f1f4a3-9cba-41c1-8c7e-e84dff6d00f8','2025-12-06 04:38:41',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1080007079-dep_2-ocodvce77vfp','29f1f4a3-9cba-41c1-8c7e-e84dff6d00f8','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1298,'f800b8ca-c5e2-47a6-98ee-ad81437bed0b','29f1f4a3-9cba-41c1-8c7e-e84dff6d00f8','2025-12-06 04:38:41',NULL,'DELETE','IN_PROGRESS','0','52320d36-d025-4998-b085-8271f6c29661','state changed','OS::Heat::SoftwareDeployment',NULL,238),(1299,'0c0890ce-ea4d-45de-829c-5579cf40d79a','d676cc74-f520-4420-84f7-26fb9ab3b975','2025-12-06 04:38:41',NULL,'DELETE','COMPLETE','0','0bec04d7-c416-43dd-8cb8-43f7e26a3e0c','state changed','OS::Heat::SoftwareDeployment',NULL,236),(1300,'3e9353b8-5e92-45e0-8385-2a22db96c260','d676cc74-f520-4420-84f7-26fb9ab3b975','2025-12-06 04:38:41',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1080007079-dep_1-dzf3ueiakkj6','d676cc74-f520-4420-84f7-26fb9ab3b975','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1301,'99aaab55-0b5d-4dab-b52e-73826bc634c5','29f1f4a3-9cba-41c1-8c7e-e84dff6d00f8','2025-12-06 04:38:42',NULL,'DELETE','COMPLETE','0','52320d36-d025-4998-b085-8271f6c29661','state changed','OS::Heat::SoftwareDeployment',NULL,238),(1302,'7458e9b1-3121-42ce-ae59-1e21e030f689','29f1f4a3-9cba-41c1-8c7e-e84dff6d00f8','2025-12-06 04:38:42',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1080007079-dep_2-ocodvce77vfp','29f1f4a3-9cba-41c1-8c7e-e84dff6d00f8','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1303,'4ecf0ef0-c104-45eb-92d7-ebe0a3f46104','8bb330dc-64fc-4131-8131-786ce5a2c07f','2025-12-06 04:38:42',NULL,'DELETE','IN_PROGRESS','dep_0','2f038ab6-0913-4deb-8e67-6f13fb08bcd5','state changed','OS::Heat::SoftwareDeployments',NULL,233),(1304,'fffe1743-e93c-4d5e-a28a-ac3b6a0b804d','2f038ab6-0913-4deb-8e67-6f13fb08bcd5','2025-12-06 04:38:42',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1080007079-dep_0-o4by3xv37yjg','2f038ab6-0913-4deb-8e67-6f13fb08bcd5','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1305,'c3280ef5-348c-4273-b957-601bbb912c3f','8bb330dc-64fc-4131-8131-786ce5a2c07f','2025-12-06 04:38:42',NULL,'DELETE','COMPLETE','dep_2','29f1f4a3-9cba-41c1-8c7e-e84dff6d00f8','state changed','OS::Heat::SoftwareDeployments',NULL,235),(1306,'6f0c1e53-a4ca-441f-97e8-5a6351d8ffa7','8bb330dc-64fc-4131-8131-786ce5a2c07f','2025-12-06 04:38:42',NULL,'DELETE','COMPLETE','dep_1','d676cc74-f520-4420-84f7-26fb9ab3b975','state changed','OS::Heat::SoftwareDeployments',NULL,234),(1307,'82e1300d-29ac-4d4d-8f1a-1d75147d966a','2f038ab6-0913-4deb-8e67-6f13fb08bcd5','2025-12-06 04:38:42',NULL,'DELETE','IN_PROGRESS','0','ae077f09-a848-48c6-885f-6cf896c99fd4','state changed','OS::Heat::SoftwareDeployment',NULL,237),(1308,'5ff0909a-e08e-46d6-9cb3-8567377919db','2f038ab6-0913-4deb-8e67-6f13fb08bcd5','2025-12-06 04:38:43',NULL,'DELETE','COMPLETE','0','ae077f09-a848-48c6-885f-6cf896c99fd4','state changed','OS::Heat::SoftwareDeployment',NULL,237),(1309,'151f18da-a704-4fbb-9bcd-fd32a1a15ed3','2f038ab6-0913-4deb-8e67-6f13fb08bcd5','2025-12-06 04:38:43',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1080007079-dep_0-o4by3xv37yjg','2f038ab6-0913-4deb-8e67-6f13fb08bcd5','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1310,'ddac531b-1b26-4404-bb2e-b1323963cbf9','8bb330dc-64fc-4131-8131-786ce5a2c07f','2025-12-06 04:38:44',NULL,'DELETE','COMPLETE','dep_0','2f038ab6-0913-4deb-8e67-6f13fb08bcd5','state changed','OS::Heat::SoftwareDeployments',NULL,233),(1311,'704561bf-e858-43be-8540-d54958dd0481','8bb330dc-64fc-4131-8131-786ce5a2c07f','2025-12-06 04:38:44',NULL,'DELETE','IN_PROGRESS','config','b20d1fd1-2bd2-48cf-a825-309052cf9ccb','state changed','OS::Heat::SoftwareConfig',NULL,232),(1312,'eeb4a7c9-bf45-4e45-b0a9-0124dd25fd3f','8bb330dc-64fc-4131-8131-786ce5a2c07f','2025-12-06 04:38:44',NULL,'DELETE','COMPLETE','config','b20d1fd1-2bd2-48cf-a825-309052cf9ccb','state changed','OS::Heat::SoftwareConfig',NULL,232),(1313,'a7f89ba9-727a-4ce2-b89d-19878a038812','8bb330dc-64fc-4131-8131-786ce5a2c07f','2025-12-06 04:38:44',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1080007079','8bb330dc-64fc-4131-8131-786ce5a2c07f','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1314,'928cfa6b-75c8-4acf-b236-edc28777342e','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','2025-12-06 04:38:49',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1700023022','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1315,'54a57c6b-9541-48c9-a8d7-328eb6db62b8','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','2025-12-06 04:38:49',NULL,'DELETE','IN_PROGRESS','dep_2','2e8e9785-0960-4726-bf75-0356744490b8','state changed','OS::Heat::SoftwareDeployments',NULL,226),(1316,'b1392045-aa49-409d-a42d-0a49e86555cd','2e8e9785-0960-4726-bf75-0356744490b8','2025-12-06 04:38:49',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1700023022-dep_2-o65vs4l6xhe4','2e8e9785-0960-4726-bf75-0356744490b8','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1317,'f0f85d39-8999-40af-8e19-fd9a42526f63','2e8e9785-0960-4726-bf75-0356744490b8','2025-12-06 04:38:49',NULL,'DELETE','IN_PROGRESS','0','de413000-1bf3-4d18-b043-df9cd6e9e36f','state changed','OS::Heat::SoftwareDeployment',NULL,230),(1318,'51295789-fa38-4689-a16a-aa9ebc686318','2e8e9785-0960-4726-bf75-0356744490b8','2025-12-06 04:38:50',NULL,'DELETE','COMPLETE','0','de413000-1bf3-4d18-b043-df9cd6e9e36f','state changed','OS::Heat::SoftwareDeployment',NULL,230),(1319,'942e0753-2247-4b84-8dae-c1f0902ba971','2e8e9785-0960-4726-bf75-0356744490b8','2025-12-06 04:38:50',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1700023022-dep_2-o65vs4l6xhe4','2e8e9785-0960-4726-bf75-0356744490b8','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1320,'2fa8d55c-18bb-4853-84c3-96647ee6c4f7','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','2025-12-06 04:38:50',NULL,'DELETE','IN_PROGRESS','dep_0','3da796f8-a8d2-48f6-94d6-873a981aacdd','state changed','OS::Heat::SoftwareDeployments',NULL,227),(1321,'73ec7656-cf58-43de-8581-2944c0c82243','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','2025-12-06 04:38:50',NULL,'DELETE','COMPLETE','dep_2','2e8e9785-0960-4726-bf75-0356744490b8','state changed','OS::Heat::SoftwareDeployments',NULL,226),(1322,'cbe995d5-82b8-480f-8c4d-0fc33bbfcd9f','3da796f8-a8d2-48f6-94d6-873a981aacdd','2025-12-06 04:38:50',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1700023022-dep_0-rq2d722x4sgq','3da796f8-a8d2-48f6-94d6-873a981aacdd','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1323,'7199ef4e-896e-4e9e-b8a3-bc878109a3eb','3da796f8-a8d2-48f6-94d6-873a981aacdd','2025-12-06 04:38:50',NULL,'DELETE','IN_PROGRESS','0','32227c59-2526-4751-becd-03c3541523d5','state changed','OS::Heat::SoftwareDeployment',NULL,229),(1324,'3dc18c5c-474b-4d36-ad22-4f698ea1d188','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','2025-12-06 04:38:51',NULL,'DELETE','IN_PROGRESS','dep_1','94d6f227-51f1-4e49-8e59-bf2000bad4ac','state changed','OS::Heat::SoftwareDeployments',NULL,228),(1325,'081ed2d3-6e09-497a-b832-a1a07ccc921f','94d6f227-51f1-4e49-8e59-bf2000bad4ac','2025-12-06 04:38:51',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1700023022-dep_1-zc5owplcobgl','94d6f227-51f1-4e49-8e59-bf2000bad4ac','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1326,'239758af-2a7d-4b30-b3aa-552dc9cfaa7c','94d6f227-51f1-4e49-8e59-bf2000bad4ac','2025-12-06 04:38:51',NULL,'DELETE','IN_PROGRESS','0','d1cc43b3-412c-494d-81ab-873442fec2c1','state changed','OS::Heat::SoftwareDeployment',NULL,231),(1327,'06b0ba77-9849-445d-b7ac-c0376d6cd555','3da796f8-a8d2-48f6-94d6-873a981aacdd','2025-12-06 04:38:51',NULL,'DELETE','COMPLETE','0','32227c59-2526-4751-becd-03c3541523d5','state changed','OS::Heat::SoftwareDeployment',NULL,229),(1328,'c15340ae-bdae-43fa-9b4e-66410e935253','3da796f8-a8d2-48f6-94d6-873a981aacdd','2025-12-06 04:38:51',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1700023022-dep_0-rq2d722x4sgq','3da796f8-a8d2-48f6-94d6-873a981aacdd','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1329,'e923dbbe-0f8b-42f3-be70-0cfbcbc9f992','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','2025-12-06 04:38:52',NULL,'DELETE','COMPLETE','dep_0','3da796f8-a8d2-48f6-94d6-873a981aacdd','state changed','OS::Heat::SoftwareDeployments',NULL,227),(1330,'4f4ab91b-ae42-4bb5-93cb-5e9441bddbb8','94d6f227-51f1-4e49-8e59-bf2000bad4ac','2025-12-06 04:38:52',NULL,'DELETE','COMPLETE','0','d1cc43b3-412c-494d-81ab-873442fec2c1','state changed','OS::Heat::SoftwareDeployment',NULL,231),(1331,'4e01ce95-0687-44de-82fc-ea68baac8ef3','94d6f227-51f1-4e49-8e59-bf2000bad4ac','2025-12-06 04:38:52',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1700023022-dep_1-zc5owplcobgl','94d6f227-51f1-4e49-8e59-bf2000bad4ac','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1332,'6b2b4dad-83eb-4e29-9947-40cba78cd5b2','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','2025-12-06 04:38:53',NULL,'DELETE','COMPLETE','dep_1','94d6f227-51f1-4e49-8e59-bf2000bad4ac','state changed','OS::Heat::SoftwareDeployments',NULL,228),(1333,'a75037fb-81b2-47bb-abf5-a8afcc5669cf','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','2025-12-06 04:38:53',NULL,'DELETE','IN_PROGRESS','config','e5c33846-8b92-40fc-8098-1b9140dbd9f0','state changed','OS::Heat::SoftwareConfig',NULL,225),(1334,'cc4c08cc-a1ba-405e-b11f-96b9b72b079b','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','2025-12-06 04:38:54',NULL,'DELETE','COMPLETE','config','e5c33846-8b92-40fc-8098-1b9140dbd9f0','state changed','OS::Heat::SoftwareConfig',NULL,225),(1335,'e6c7e78b-008c-4cc0-8808-efef78095765','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','2025-12-06 04:38:54',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1700023022','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1336,'92490136-1f55-4ceb-9222-fb982a80aca5','fa4f95c2-2ec3-4000-9201-2fcb3780307f','2025-12-06 04:38:59',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1504859677','fa4f95c2-2ec3-4000-9201-2fcb3780307f','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1337,'005e44e4-c728-4aa0-ad57-5d0ab15dc271','fa4f95c2-2ec3-4000-9201-2fcb3780307f','2025-12-06 04:38:59',NULL,'DELETE','IN_PROGRESS','dep_1','b50a060c-24a0-42a2-9ed9-fb8b7e59648a','state changed','OS::Heat::SoftwareDeployments',NULL,219),(1338,'b5c97375-14de-4e2f-bf08-92b3b4984edb','b50a060c-24a0-42a2-9ed9-fb8b7e59648a','2025-12-06 04:38:59',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1504859677-dep_1-bs3xr3box7nj','b50a060c-24a0-42a2-9ed9-fb8b7e59648a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1339,'b807094c-8d63-4709-9169-0d7a01fb9a0a','b50a060c-24a0-42a2-9ed9-fb8b7e59648a','2025-12-06 04:38:59',NULL,'DELETE','IN_PROGRESS','0','d8e52e1b-1a50-40b2-9d2d-fba732837157','state changed','OS::Heat::SoftwareDeployment',NULL,223),(1340,'1e825173-6f6b-4787-8ede-bf7ebdde8c7c','fa4f95c2-2ec3-4000-9201-2fcb3780307f','2025-12-06 04:39:00',NULL,'DELETE','IN_PROGRESS','dep_2','35d328f4-ee7e-4f36-9525-a4caf1efdee2','state changed','OS::Heat::SoftwareDeployments',NULL,220),(1341,'87a1dcef-5af8-48d7-b9e8-f3ef21c9bd5d','35d328f4-ee7e-4f36-9525-a4caf1efdee2','2025-12-06 04:39:00',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1504859677-dep_2-wadsndhsuxa6','35d328f4-ee7e-4f36-9525-a4caf1efdee2','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1342,'e1323392-9596-4175-921f-681878beb181','35d328f4-ee7e-4f36-9525-a4caf1efdee2','2025-12-06 04:39:00',NULL,'DELETE','IN_PROGRESS','0','18c74a26-4e20-4e51-b895-50e2a14db9dc','state changed','OS::Heat::SoftwareDeployment',NULL,222),(1343,'84dc4751-d4b1-442b-974d-ab97b33002e2','b50a060c-24a0-42a2-9ed9-fb8b7e59648a','2025-12-06 04:39:01',NULL,'DELETE','COMPLETE','0','d8e52e1b-1a50-40b2-9d2d-fba732837157','state changed','OS::Heat::SoftwareDeployment',NULL,223),(1344,'9449156e-fd8d-4d55-b5b8-63f138f2648d','b50a060c-24a0-42a2-9ed9-fb8b7e59648a','2025-12-06 04:39:01',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1504859677-dep_1-bs3xr3box7nj','b50a060c-24a0-42a2-9ed9-fb8b7e59648a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1345,'831f4770-7474-4462-912e-b385782f3d8d','fa4f95c2-2ec3-4000-9201-2fcb3780307f','2025-12-06 04:39:01',NULL,'DELETE','IN_PROGRESS','dep_0','b2987bbc-cd98-412c-9cee-832c0d57203b','state changed','OS::Heat::SoftwareDeployments',NULL,221),(1346,'889bf832-e01c-4870-becb-639fd9c19c19','b2987bbc-cd98-412c-9cee-832c0d57203b','2025-12-06 04:39:01',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1504859677-dep_0-nd3g2mpbvpyi','b2987bbc-cd98-412c-9cee-832c0d57203b','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1347,'a0d357d3-649f-4613-a888-f525f50a2d0c','b2987bbc-cd98-412c-9cee-832c0d57203b','2025-12-06 04:39:01',NULL,'DELETE','IN_PROGRESS','0','21827941-9549-4ae4-bce0-b612b6dfa569','state changed','OS::Heat::SoftwareDeployment',NULL,224),(1348,'de0dbebe-4430-4d10-b67a-5a303c863e5a','fa4f95c2-2ec3-4000-9201-2fcb3780307f','2025-12-06 04:39:01',NULL,'DELETE','COMPLETE','dep_1','b50a060c-24a0-42a2-9ed9-fb8b7e59648a','state changed','OS::Heat::SoftwareDeployments',NULL,219),(1349,'6dc2a4ee-50dd-4803-ba62-3bdb864c5737','35d328f4-ee7e-4f36-9525-a4caf1efdee2','2025-12-06 04:39:01',NULL,'DELETE','COMPLETE','0','18c74a26-4e20-4e51-b895-50e2a14db9dc','state changed','OS::Heat::SoftwareDeployment',NULL,222),(1350,'781d1dfe-45d7-451f-b7a7-c4bcaa680df5','35d328f4-ee7e-4f36-9525-a4caf1efdee2','2025-12-06 04:39:01',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1504859677-dep_2-wadsndhsuxa6','35d328f4-ee7e-4f36-9525-a4caf1efdee2','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1351,'6b744d56-7eb3-4c24-b1fc-da51d248672c','b2987bbc-cd98-412c-9cee-832c0d57203b','2025-12-06 04:39:02',NULL,'DELETE','COMPLETE','0','21827941-9549-4ae4-bce0-b612b6dfa569','state changed','OS::Heat::SoftwareDeployment',NULL,224),(1352,'b75d2fcb-3d6d-43e6-b8c1-c6969b61c073','b2987bbc-cd98-412c-9cee-832c0d57203b','2025-12-06 04:39:02',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1504859677-dep_0-nd3g2mpbvpyi','b2987bbc-cd98-412c-9cee-832c0d57203b','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1353,'dc5dd91a-4502-4bba-99c8-35e7a72b5eab','fa4f95c2-2ec3-4000-9201-2fcb3780307f','2025-12-06 04:39:02',NULL,'DELETE','COMPLETE','dep_0','b2987bbc-cd98-412c-9cee-832c0d57203b','state changed','OS::Heat::SoftwareDeployments',NULL,221),(1354,'915fc9b8-a060-4416-8d22-dd8ab7c5fd5c','fa4f95c2-2ec3-4000-9201-2fcb3780307f','2025-12-06 04:39:04',NULL,'DELETE','COMPLETE','dep_2','35d328f4-ee7e-4f36-9525-a4caf1efdee2','state changed','OS::Heat::SoftwareDeployments',NULL,220),(1355,'0d73b4f5-fdb9-47d5-8311-3167e20a693e','fa4f95c2-2ec3-4000-9201-2fcb3780307f','2025-12-06 04:39:05',NULL,'DELETE','IN_PROGRESS','config','acaaf735-bd9e-4a52-83f9-5890ced4a443','state changed','OS::Heat::SoftwareConfig',NULL,218),(1356,'b2d8731c-e914-4674-891e-1da38f506763','fa4f95c2-2ec3-4000-9201-2fcb3780307f','2025-12-06 04:39:06',NULL,'DELETE','COMPLETE','config','acaaf735-bd9e-4a52-83f9-5890ced4a443','state changed','OS::Heat::SoftwareConfig',NULL,218),(1357,'af0c0ee0-119a-4e2e-af31-d8c316ea89ba','fa4f95c2-2ec3-4000-9201-2fcb3780307f','2025-12-06 04:39:07',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1504859677','fa4f95c2-2ec3-4000-9201-2fcb3780307f','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1358,'4283b26d-e430-483a-82f1-78198e8dfccf','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:39:15',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1287797711','1326e81d-c775-44e9-b704-3d4b41a91f89','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1359,'94c50e90-6027-4560-8708-84b990f95763','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:39:15',NULL,'DELETE','IN_PROGRESS','dep_4','a0e25fbe-b3e7-47a3-a8f0-2a362ef8447a','state changed','OS::Heat::SoftwareDeployments',NULL,208),(1360,'b1177c6c-b3db-47ec-aad6-b30f96ff9e3c','a0e25fbe-b3e7-47a3-a8f0-2a362ef8447a','2025-12-06 04:39:15',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1287797711-dep_4-euryujob2lky','a0e25fbe-b3e7-47a3-a8f0-2a362ef8447a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1361,'c5005d50-171e-4853-8ef7-f90a8a598e18','a0e25fbe-b3e7-47a3-a8f0-2a362ef8447a','2025-12-06 04:39:15',NULL,'DELETE','IN_PROGRESS','0','1a5a56a3-24bf-4e83-a3aa-fb03b94dd3dc','state changed','OS::Heat::SoftwareDeployment',NULL,215),(1362,'1646cdca-5d01-476f-88a7-c4e3d27eeaea','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:39:16',NULL,'DELETE','IN_PROGRESS','dep_1','7dc8aa63-c560-4fc3-8d80-5507b1029158','state changed','OS::Heat::SoftwareDeployments',NULL,211),(1363,'9f5d1942-b6de-47a2-985c-5005b82cfafe','7dc8aa63-c560-4fc3-8d80-5507b1029158','2025-12-06 04:39:16',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1287797711-dep_1-ugecj2zbk73j','7dc8aa63-c560-4fc3-8d80-5507b1029158','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1364,'2fbf763b-f4f9-4cb1-a7e7-45a3a33633c1','7dc8aa63-c560-4fc3-8d80-5507b1029158','2025-12-06 04:39:16',NULL,'DELETE','IN_PROGRESS','0','4fd84b96-e2bb-47cf-b65e-67f61e35ba6e','state changed','OS::Heat::SoftwareDeployment',NULL,216),(1365,'55861312-f535-45e5-b9b7-cc6897296593','a0e25fbe-b3e7-47a3-a8f0-2a362ef8447a','2025-12-06 04:39:16',NULL,'DELETE','COMPLETE','0','1a5a56a3-24bf-4e83-a3aa-fb03b94dd3dc','state changed','OS::Heat::SoftwareDeployment',NULL,215),(1366,'eea1c735-cf68-41d5-8e63-f9489c593336','a0e25fbe-b3e7-47a3-a8f0-2a362ef8447a','2025-12-06 04:39:16',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1287797711-dep_4-euryujob2lky','a0e25fbe-b3e7-47a3-a8f0-2a362ef8447a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1367,'f7888e44-dc00-4fb6-9a82-cf4bfdb1f841','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:39:16',NULL,'DELETE','COMPLETE','dep_4','a0e25fbe-b3e7-47a3-a8f0-2a362ef8447a','state changed','OS::Heat::SoftwareDeployments',NULL,208),(1368,'8ef67257-41ac-4f92-afa1-7a0b2a7f4c7c','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:39:17',NULL,'DELETE','IN_PROGRESS','dep_3','40a720fe-4d5b-4614-97b6-f6c7da13689f','state changed','OS::Heat::SoftwareDeployments',NULL,209),(1369,'e69a9438-7b1e-40d1-9875-806ed7f95e07','40a720fe-4d5b-4614-97b6-f6c7da13689f','2025-12-06 04:39:17',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1287797711-dep_3-itd463qzrk6l','40a720fe-4d5b-4614-97b6-f6c7da13689f','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1370,'4ab24312-596e-4791-b90a-b7bc3c6d94f6','7dc8aa63-c560-4fc3-8d80-5507b1029158','2025-12-06 04:39:17',NULL,'DELETE','COMPLETE','0','4fd84b96-e2bb-47cf-b65e-67f61e35ba6e','state changed','OS::Heat::SoftwareDeployment',NULL,216),(1371,'01e152a3-fe6b-483e-b26e-dbb4ca7560f0','7dc8aa63-c560-4fc3-8d80-5507b1029158','2025-12-06 04:39:17',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1287797711-dep_1-ugecj2zbk73j','7dc8aa63-c560-4fc3-8d80-5507b1029158','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1372,'1a5585c0-9c10-4846-a13d-9f507ce6498e','40a720fe-4d5b-4614-97b6-f6c7da13689f','2025-12-06 04:39:17',NULL,'DELETE','IN_PROGRESS','0','3ed3dc9b-aa03-4937-a79a-22590f1051f1','state changed','OS::Heat::SoftwareDeployment',NULL,213),(1373,'74030457-80ee-4bd5-a45f-f83465b7afd5','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:39:17',NULL,'DELETE','COMPLETE','dep_1','7dc8aa63-c560-4fc3-8d80-5507b1029158','state changed','OS::Heat::SoftwareDeployments',NULL,211),(1374,'410fff51-3335-42c7-832a-25485da176fd','40a720fe-4d5b-4614-97b6-f6c7da13689f','2025-12-06 04:39:18',NULL,'DELETE','COMPLETE','0','3ed3dc9b-aa03-4937-a79a-22590f1051f1','state changed','OS::Heat::SoftwareDeployment',NULL,213),(1375,'1d22aaaf-9d64-408e-8654-0047afa0d6dd','40a720fe-4d5b-4614-97b6-f6c7da13689f','2025-12-06 04:39:18',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1287797711-dep_3-itd463qzrk6l','40a720fe-4d5b-4614-97b6-f6c7da13689f','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1376,'e1882ea5-d2e3-4a27-8df7-91ee4b3cc801','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:39:18',NULL,'DELETE','COMPLETE','dep_3','40a720fe-4d5b-4614-97b6-f6c7da13689f','state changed','OS::Heat::SoftwareDeployments',NULL,209),(1377,'69cc1e00-1ee9-4742-949f-fbf7161e59c9','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:39:18',NULL,'DELETE','IN_PROGRESS','dep_0','ac3aa260-7638-4b1d-a06c-125c77c959b2','state changed','OS::Heat::SoftwareDeployments',NULL,212),(1378,'145155bb-c663-4d8b-8ed8-6d6887377d67','ac3aa260-7638-4b1d-a06c-125c77c959b2','2025-12-06 04:39:18',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1287797711-dep_0-6vmc4aliomlp','ac3aa260-7638-4b1d-a06c-125c77c959b2','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1379,'21907386-c1e3-4e7c-8d8c-8ef7ce9cce1b','ac3aa260-7638-4b1d-a06c-125c77c959b2','2025-12-06 04:39:19',NULL,'DELETE','IN_PROGRESS','0','8f5810e9-7abc-484c-8586-b8a5c535161e','state changed','OS::Heat::SoftwareDeployment',NULL,217),(1380,'270010b0-1828-4d66-8097-e3fc3dfdaa8b','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:39:19',NULL,'DELETE','IN_PROGRESS','dep_2','81f3f155-2b09-47f6-a17b-108f033edcc8','state changed','OS::Heat::SoftwareDeployments',NULL,210),(1381,'5b8eba51-70c9-415a-b8dc-dac8fbd0ced3','81f3f155-2b09-47f6-a17b-108f033edcc8','2025-12-06 04:39:19',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1287797711-dep_2-on4jhdwzy6ci','81f3f155-2b09-47f6-a17b-108f033edcc8','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1382,'de177bfa-ef58-4c76-bf79-1aa9a72ba16f','81f3f155-2b09-47f6-a17b-108f033edcc8','2025-12-06 04:39:19',NULL,'DELETE','IN_PROGRESS','0','733933fe-1f26-4369-ae02-c26200add634','state changed','OS::Heat::SoftwareDeployment',NULL,214),(1383,'369ce2ea-87a9-4a93-945d-e8429740aa5e','ac3aa260-7638-4b1d-a06c-125c77c959b2','2025-12-06 04:39:19',NULL,'DELETE','COMPLETE','0','8f5810e9-7abc-484c-8586-b8a5c535161e','state changed','OS::Heat::SoftwareDeployment',NULL,217),(1384,'505b6299-6823-4b5a-87f4-5b2b17cbde06','ac3aa260-7638-4b1d-a06c-125c77c959b2','2025-12-06 04:39:19',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1287797711-dep_0-6vmc4aliomlp','ac3aa260-7638-4b1d-a06c-125c77c959b2','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1385,'92ba501b-385c-48f3-819c-e0f081f136df','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:39:19',NULL,'DELETE','COMPLETE','dep_0','ac3aa260-7638-4b1d-a06c-125c77c959b2','state changed','OS::Heat::SoftwareDeployments',NULL,212),(1386,'ea36c32b-2662-4721-be49-7962e1c69beb','81f3f155-2b09-47f6-a17b-108f033edcc8','2025-12-06 04:39:21',NULL,'DELETE','COMPLETE','0','733933fe-1f26-4369-ae02-c26200add634','state changed','OS::Heat::SoftwareDeployment',NULL,214),(1387,'22099f4d-682b-408e-8dfa-6a9205653418','81f3f155-2b09-47f6-a17b-108f033edcc8','2025-12-06 04:39:21',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1287797711-dep_2-on4jhdwzy6ci','81f3f155-2b09-47f6-a17b-108f033edcc8','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1388,'36845845-a95d-4727-bac9-3e0ff9d7e603','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:39:24',NULL,'DELETE','COMPLETE','dep_2','81f3f155-2b09-47f6-a17b-108f033edcc8','state changed','OS::Heat::SoftwareDeployments',NULL,210),(1389,'aaebe767-26a5-4305-915b-8d52347af62f','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:39:25',NULL,'DELETE','IN_PROGRESS','config','ec676521-0249-4ea4-a897-c3b08bf881d0','state changed','OS::Heat::SoftwareConfig',NULL,207),(1390,'c9fa1523-e056-4ad8-ad6b-c668335f819c','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:39:25',NULL,'DELETE','COMPLETE','config','ec676521-0249-4ea4-a897-c3b08bf881d0','state changed','OS::Heat::SoftwareConfig',NULL,207),(1391,'5787f4ce-638a-4e12-8e67-bb5706e07fce','1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:39:25',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1287797711','1326e81d-c775-44e9-b704-3d4b41a91f89','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1392,'a924a78d-ec9f-4f86-8810-45f1f53f1d8a','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:39:31',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-796190467','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1393,'4ba8f430-0e33-442a-8ad1-114dc55ce900','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:39:31',NULL,'DELETE','IN_PROGRESS','dep_2','5959fd78-7790-4543-84a2-60452176a852','state changed','OS::Heat::SoftwareDeployments',NULL,199),(1394,'e62cee2b-f86a-43fa-b33d-3b8c136c10ae','5959fd78-7790-4543-84a2-60452176a852','2025-12-06 04:39:31',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-796190467-dep_2-m4j3rhy5x3sh','5959fd78-7790-4543-84a2-60452176a852','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1395,'f16da729-8912-483e-967e-81868bf2588b','5959fd78-7790-4543-84a2-60452176a852','2025-12-06 04:39:31',NULL,'DELETE','IN_PROGRESS','0','0f496ff4-632a-4c58-aa55-fdaaaf46a339','state changed','OS::Heat::SoftwareDeployment',NULL,204),(1396,'68331c17-1015-4ecd-b1a7-e970093a3f36','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:39:32',NULL,'DELETE','IN_PROGRESS','dep_4','7967df7a-68fa-4a43-bdb0-821ba4b96bb1','state changed','OS::Heat::SoftwareDeployments',NULL,197),(1397,'5a76bea4-478d-450e-86c0-6a7d4eb53dd8','7967df7a-68fa-4a43-bdb0-821ba4b96bb1','2025-12-06 04:39:33',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-796190467-dep_4-5l5rkc4rkbl4','7967df7a-68fa-4a43-bdb0-821ba4b96bb1','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1398,'3bec1036-5c3a-4af4-8d25-df72926d5ce8','7967df7a-68fa-4a43-bdb0-821ba4b96bb1','2025-12-06 04:39:33',NULL,'DELETE','IN_PROGRESS','0','ddfaa87e-0560-4446-84cf-0c23755f1b2b','state changed','OS::Heat::SoftwareDeployment',NULL,202),(1399,'e37d029c-2f2e-41f1-8e5f-e573e4cbd928','5959fd78-7790-4543-84a2-60452176a852','2025-12-06 04:39:33',NULL,'DELETE','COMPLETE','0','0f496ff4-632a-4c58-aa55-fdaaaf46a339','state changed','OS::Heat::SoftwareDeployment',NULL,204),(1400,'ad01ad07-5004-4170-9259-dfb2e6b77b33','5959fd78-7790-4543-84a2-60452176a852','2025-12-06 04:39:33',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-796190467-dep_2-m4j3rhy5x3sh','5959fd78-7790-4543-84a2-60452176a852','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1401,'5ef0c382-5f57-4651-a3b5-b3a3cb3d0ba5','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:39:33',NULL,'DELETE','COMPLETE','dep_2','5959fd78-7790-4543-84a2-60452176a852','state changed','OS::Heat::SoftwareDeployments',NULL,199),(1402,'1e7c72ae-23a1-437e-a069-c0db49674bb6','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:39:33',NULL,'DELETE','IN_PROGRESS','dep_1','03ba8d57-c0c6-4dd7-9ace-a80f1497e1f4','state changed','OS::Heat::SoftwareDeployments',NULL,200),(1403,'af0d956d-32d9-4910-ab56-936c1e4cf062','03ba8d57-c0c6-4dd7-9ace-a80f1497e1f4','2025-12-06 04:39:33',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-796190467-dep_1-dixzb6ouqerb','03ba8d57-c0c6-4dd7-9ace-a80f1497e1f4','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1404,'674c7902-42f4-4f0b-9cf9-eaa28d88cca0','03ba8d57-c0c6-4dd7-9ace-a80f1497e1f4','2025-12-06 04:39:34',NULL,'DELETE','IN_PROGRESS','0','fa27f470-99ee-47f6-8f1d-d6978b46482b','state changed','OS::Heat::SoftwareDeployment',NULL,205),(1405,'c6e9e6fc-882e-4a54-a29e-033ea81baf0b','7967df7a-68fa-4a43-bdb0-821ba4b96bb1','2025-12-06 04:39:34',NULL,'DELETE','COMPLETE','0','ddfaa87e-0560-4446-84cf-0c23755f1b2b','state changed','OS::Heat::SoftwareDeployment',NULL,202),(1406,'d398b27d-4c47-48b4-96b0-1ebfc67b4be0','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:39:34',NULL,'DELETE','IN_PROGRESS','dep_3','32a9ef71-f427-412b-a14f-1110064ee79f','state changed','OS::Heat::SoftwareDeployments',NULL,198),(1407,'463b53c6-526b-4cfe-92ed-9c54f36b6a24','7967df7a-68fa-4a43-bdb0-821ba4b96bb1','2025-12-06 04:39:34',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-796190467-dep_4-5l5rkc4rkbl4','7967df7a-68fa-4a43-bdb0-821ba4b96bb1','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1408,'e8c38966-0631-4386-9bcf-f8103d284362','03ba8d57-c0c6-4dd7-9ace-a80f1497e1f4','2025-12-06 04:39:34',NULL,'DELETE','COMPLETE','0','fa27f470-99ee-47f6-8f1d-d6978b46482b','state changed','OS::Heat::SoftwareDeployment',NULL,205),(1409,'83d76c75-4d8e-41f3-8dcd-26ecae389689','32a9ef71-f427-412b-a14f-1110064ee79f','2025-12-06 04:39:34',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-796190467-dep_3-w4rpny2hfutm','32a9ef71-f427-412b-a14f-1110064ee79f','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1410,'a3f01e62-ccd7-485d-8ea6-54237d753680','03ba8d57-c0c6-4dd7-9ace-a80f1497e1f4','2025-12-06 04:39:34',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-796190467-dep_1-dixzb6ouqerb','03ba8d57-c0c6-4dd7-9ace-a80f1497e1f4','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1411,'a84e7469-4a5f-433f-a814-bba7ebac4796','32a9ef71-f427-412b-a14f-1110064ee79f','2025-12-06 04:39:34',NULL,'DELETE','IN_PROGRESS','0','b334f0d6-5d25-466a-bd84-a010b407e35d','state changed','OS::Heat::SoftwareDeployment',NULL,203),(1412,'e0ac2f01-0d2d-4a51-a353-0e76a9ab0dfe','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:39:35',NULL,'DELETE','COMPLETE','dep_1','03ba8d57-c0c6-4dd7-9ace-a80f1497e1f4','state changed','OS::Heat::SoftwareDeployments',NULL,200),(1413,'18044d79-1871-47de-83a8-4062d619b698','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:39:35',NULL,'DELETE','COMPLETE','dep_4','7967df7a-68fa-4a43-bdb0-821ba4b96bb1','state changed','OS::Heat::SoftwareDeployments',NULL,197),(1414,'6d30996b-c195-4f49-945a-355f496dea52','32a9ef71-f427-412b-a14f-1110064ee79f','2025-12-06 04:39:35',NULL,'DELETE','COMPLETE','0','b334f0d6-5d25-466a-bd84-a010b407e35d','state changed','OS::Heat::SoftwareDeployment',NULL,203),(1415,'a96c3828-6828-4a04-9a5b-cb7a72fcf305','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:39:35',NULL,'DELETE','IN_PROGRESS','dep_0','a489fb24-54df-4fa3-8800-1d2fd5fdad32','state changed','OS::Heat::SoftwareDeployments',NULL,201),(1416,'429ef25e-fd03-4d70-b870-cca980ba6064','32a9ef71-f427-412b-a14f-1110064ee79f','2025-12-06 04:39:35',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-796190467-dep_3-w4rpny2hfutm','32a9ef71-f427-412b-a14f-1110064ee79f','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1417,'3fff7e8a-8455-4c04-8c25-7a4b45db1ee2','a489fb24-54df-4fa3-8800-1d2fd5fdad32','2025-12-06 04:39:35',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-796190467-dep_0-txogag7zsutv','a489fb24-54df-4fa3-8800-1d2fd5fdad32','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1418,'123d9b2a-d3bc-4052-a795-aa9578b61cbf','a489fb24-54df-4fa3-8800-1d2fd5fdad32','2025-12-06 04:39:35',NULL,'DELETE','IN_PROGRESS','0','2b998e93-80b9-46c1-915e-c2c53039936a','state changed','OS::Heat::SoftwareDeployment',NULL,206),(1419,'da96418c-c291-4dcd-9304-b029b87ee05a','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:39:36',NULL,'DELETE','COMPLETE','dep_3','32a9ef71-f427-412b-a14f-1110064ee79f','state changed','OS::Heat::SoftwareDeployments',NULL,198),(1420,'b773bce4-5a1c-41a2-bc5e-32bcc01fe9ad','a489fb24-54df-4fa3-8800-1d2fd5fdad32','2025-12-06 04:39:37',NULL,'DELETE','COMPLETE','0','2b998e93-80b9-46c1-915e-c2c53039936a','state changed','OS::Heat::SoftwareDeployment',NULL,206),(1421,'fd62de1b-9db8-4bb8-a639-c8e02c6a7516','a489fb24-54df-4fa3-8800-1d2fd5fdad32','2025-12-06 04:39:37',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-796190467-dep_0-txogag7zsutv','a489fb24-54df-4fa3-8800-1d2fd5fdad32','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1422,'8721e299-347f-4812-83a4-538c20cbe262','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:39:39',NULL,'DELETE','COMPLETE','dep_0','a489fb24-54df-4fa3-8800-1d2fd5fdad32','state changed','OS::Heat::SoftwareDeployments',NULL,201),(1423,'5ae64abf-44fe-4854-b2b1-702e141fc589','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:39:41',NULL,'DELETE','IN_PROGRESS','config','ae7968e6-dcd9-4ee4-9e1d-d1f5cbbbf5a3','state changed','OS::Heat::SoftwareConfig',NULL,196),(1424,'22260faf-8b33-43e3-aab7-b17e136f559e','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:39:41',NULL,'DELETE','COMPLETE','config','ae7968e6-dcd9-4ee4-9e1d-d1f5cbbbf5a3','state changed','OS::Heat::SoftwareConfig',NULL,196),(1425,'40bb665b-f4a1-4bfe-addd-101c51a49f34','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:39:41',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-796190467','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1426,'684a9d63-f598-48e7-ab18-76f09de13de5','33729b66-d857-494a-b152-a364ad25ff94','2025-12-06 04:39:45',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-2056388355','33729b66-d857-494a-b152-a364ad25ff94','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1427,'a88bedd7-9a32-4345-9245-2e4c05aae891','33729b66-d857-494a-b152-a364ad25ff94','2025-12-06 04:39:45',NULL,'DELETE','IN_PROGRESS','server','70ab76f9-c1b0-4a03-972f-cab7cba5a2f5','state changed','OS::Nova::Server',NULL,195),(1428,'370575d5-a2fc-4d2f-8cbb-3ac579d1431a','33729b66-d857-494a-b152-a364ad25ff94','2025-12-06 04:39:52',NULL,'DELETE','COMPLETE','server','70ab76f9-c1b0-4a03-972f-cab7cba5a2f5','state changed','OS::Nova::Server',NULL,195),(1429,'1c5f3e9c-2aa5-45af-a8bf-b34b2ad34c4f','33729b66-d857-494a-b152-a364ad25ff94','2025-12-06 04:39:52',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-2056388355','33729b66-d857-494a-b152-a364ad25ff94','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1430,'a5441108-bdcb-4fe6-ad57-b4837b8c753c','9770ae5b-d5f6-4788-8560-f024b14c6672','2025-12-06 04:39:58',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-2124645028','9770ae5b-d5f6-4788-8560-f024b14c6672','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1431,'d054e9ed-6522-4418-8d22-cf58d9b6bb32','9770ae5b-d5f6-4788-8560-f024b14c6672','2025-12-06 04:39:59',NULL,'CREATE','IN_PROGRESS','server','Pa-llelDeploymentsTest-2124645028-server-mbkrwnck6ezm','state changed','OS::Nova::Server',NULL,239),(1432,'79a9816e-e948-41b0-a81e-1e804250838c','9770ae5b-d5f6-4788-8560-f024b14c6672','2025-12-06 04:40:12',NULL,'CREATE','COMPLETE','server','446987cb-d72d-4631-8ce6-2da7b3951475','state changed','OS::Nova::Server',NULL,239),(1433,'2921313a-7aa7-462c-afd7-2f51446bd547','9770ae5b-d5f6-4788-8560-f024b14c6672','2025-12-06 04:40:12',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-2124645028','9770ae5b-d5f6-4788-8560-f024b14c6672','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1434,'33309474-286c-46d1-b7c0-5c28c8530bf1','0c199995-f685-4cda-9487-b9fba4bd651f','2025-12-06 04:40:15',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1855891113','0c199995-f685-4cda-9487-b9fba4bd651f','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1435,'7a2c5640-bd44-4739-8135-5f82b526045c','0c199995-f685-4cda-9487-b9fba4bd651f','2025-12-06 04:40:15',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-1855891113-config-gnbb2ik53mre','state changed','OS::Heat::SoftwareConfig',NULL,240),(1436,'64ae349d-1e28-442d-8831-4210b60d63ca','0c199995-f685-4cda-9487-b9fba4bd651f','2025-12-06 04:40:15',NULL,'CREATE','COMPLETE','config','a2bf6543-68d4-45b2-8c5f-a902fc3582ec','state changed','OS::Heat::SoftwareConfig',NULL,240),(1437,'9723d61c-749c-44d9-9bd4-9edbec9346d4','0c199995-f685-4cda-9487-b9fba4bd651f','2025-12-06 04:40:15',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-1855891113-dep_0-fpvlnauhtbx7','state changed','OS::Heat::SoftwareDeployments',NULL,241),(1438,'6332d123-6167-4070-b0ab-c582929a1e5a','0c199995-f685-4cda-9487-b9fba4bd651f','2025-12-06 04:40:15',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-1855891113-dep_1-yl2aejpg6ypz','state changed','OS::Heat::SoftwareDeployments',NULL,242),(1439,'f7fed77b-caed-4c4b-ae0e-226def63e361','0c199995-f685-4cda-9487-b9fba4bd651f','2025-12-06 04:40:15',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-1855891113-dep_2-xvi4ebuumjew','state changed','OS::Heat::SoftwareDeployments',NULL,243),(1440,'25378112-b976-4e35-b04f-4465e7a04126','237b0453-1901-423d-a107-e08a79190113','2025-12-06 04:40:15',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1855891113-dep_0-fpvlnauhtbx7','237b0453-1901-423d-a107-e08a79190113','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1441,'47dcad76-7f17-408a-a5bc-90149886179e','093cb3c6-d376-4f93-bc88-6137e9055c81','2025-12-06 04:40:15',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1855891113-dep_1-yl2aejpg6ypz','093cb3c6-d376-4f93-bc88-6137e9055c81','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1442,'05e2f934-934e-4582-855f-a668f91dd7d2','58698bb5-a1f2-4361-bfd2-aaeeed077d93','2025-12-06 04:40:15',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1855891113-dep_2-xvi4ebuumjew','58698bb5-a1f2-4361-bfd2-aaeeed077d93','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1443,'5457455d-bf32-416f-9c3f-a1760780aa2b','237b0453-1901-423d-a107-e08a79190113','2025-12-06 04:40:15',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1855891113-dep_0-fpvlnauhtbx7-0-3aeogcw7oa6r','state changed','OS::Heat::SoftwareDeployment',NULL,244),(1444,'44b57f83-519b-4106-b53e-2873d0f029f4','093cb3c6-d376-4f93-bc88-6137e9055c81','2025-12-06 04:40:15',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1855891113-dep_1-yl2aejpg6ypz-0-ixbpsmpofclg','state changed','OS::Heat::SoftwareDeployment',NULL,245),(1445,'2918ab68-6f95-4364-9d53-a85e4139a201','58698bb5-a1f2-4361-bfd2-aaeeed077d93','2025-12-06 04:40:15',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1855891113-dep_2-xvi4ebuumjew-0-ztmut4isv5xb','state changed','OS::Heat::SoftwareDeployment',NULL,246),(1446,'23455857-aa91-4991-883b-aaa5985dbc86','093cb3c6-d376-4f93-bc88-6137e9055c81','2025-12-06 04:41:17',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1855891113-dep_1-yl2aejpg6ypz','093cb3c6-d376-4f93-bc88-6137e9055c81','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1447,'b4ee3b00-8712-4920-b71b-eebf03e55ba7','0c199995-f685-4cda-9487-b9fba4bd651f','2025-12-06 04:41:17',NULL,'CREATE','FAILED','dep_2','58698bb5-a1f2-4361-bfd2-aaeeed077d93','CREATE aborted (Task create from SoftwareDeployments \"dep_2\" Stack \"ParallelDeploymentsTest-1855891113\" [0c199995-f685-4cda-9487-b9fba4bd651f] Timed out)','OS::Heat::SoftwareDeployments',NULL,243),(1448,'a4e4c7a3-567f-48c5-b080-ef4dac454052','0c199995-f685-4cda-9487-b9fba4bd651f','2025-12-06 04:41:17',NULL,'CREATE','FAILED','dep_1','093cb3c6-d376-4f93-bc88-6137e9055c81','CREATE aborted (Task create from SoftwareDeployments \"dep_1\" Stack \"ParallelDeploymentsTest-1855891113\" [0c199995-f685-4cda-9487-b9fba4bd651f] Timed out)','OS::Heat::SoftwareDeployments',NULL,242),(1449,'38db3095-7458-4693-8e12-80d4041558fe','0c199995-f685-4cda-9487-b9fba4bd651f','2025-12-06 04:41:17',NULL,'CREATE','FAILED','dep_0','237b0453-1901-423d-a107-e08a79190113','CREATE aborted (Task create from SoftwareDeployments \"dep_0\" Stack \"ParallelDeploymentsTest-1855891113\" [0c199995-f685-4cda-9487-b9fba4bd651f] Timed out)','OS::Heat::SoftwareDeployments',NULL,241),(1450,'430c1359-ad6a-4009-bf74-d41d1c334a42','58698bb5-a1f2-4361-bfd2-aaeeed077d93','2025-12-06 04:41:17',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1855891113-dep_2-xvi4ebuumjew','58698bb5-a1f2-4361-bfd2-aaeeed077d93','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1451,'1e52266b-ae3b-4c10-b815-24fdb61cb1c0','237b0453-1901-423d-a107-e08a79190113','2025-12-06 04:41:17',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1855891113-dep_0-fpvlnauhtbx7','237b0453-1901-423d-a107-e08a79190113','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1452,'ef91c1fa-d695-4166-acd1-0b5ab18dcfc4','0c199995-f685-4cda-9487-b9fba4bd651f','2025-12-06 04:41:17',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1855891113','0c199995-f685-4cda-9487-b9fba4bd651f','Timed out','OS::Heat::Stack',NULL,NULL),(1453,'18cad744-7769-4d20-90db-127b14bfc17a','0c199995-f685-4cda-9487-b9fba4bd651f','2025-12-06 04:41:17',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1855891113','0c199995-f685-4cda-9487-b9fba4bd651f','Timed out','OS::Heat::Stack',NULL,NULL),(1454,'3ad0f778-ae0b-4205-a385-9e22c83491c4','237b0453-1901-423d-a107-e08a79190113','2025-12-06 04:41:17',NULL,'CREATE','FAILED','0','92f9b0b4-5e98-437b-98c9-6dac28b4e0e8','CREATE aborted (Task create from SoftwareDeployment \"0\" Stack \"ParallelDeploymentsTest-1855891113-dep_0-fpvlnauhtbx7\" [237b0453-1901-423d-a107-e08a79190113] Timed out)','OS::Heat::SoftwareDeployment',NULL,244),(1455,'8d343521-1ea7-4230-8474-0f9796e84f26','093cb3c6-d376-4f93-bc88-6137e9055c81','2025-12-06 04:41:17',NULL,'CREATE','FAILED','0','ad2bf730-d7a3-4dfc-bc5b-8e461b0a23ad','CREATE aborted (Task create from SoftwareDeployment \"0\" Stack \"ParallelDeploymentsTest-1855891113-dep_1-yl2aejpg6ypz\" [093cb3c6-d376-4f93-bc88-6137e9055c81] Timed out)','OS::Heat::SoftwareDeployment',NULL,245),(1456,'dcf803f9-64a1-457f-914b-86f72d0557f6','0c199995-f685-4cda-9487-b9fba4bd651f','2025-12-06 04:41:17',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1855891113','0c199995-f685-4cda-9487-b9fba4bd651f','Timed out','OS::Heat::Stack',NULL,NULL),(1457,'454b0fb7-6f6d-465c-b23e-1c16493823af','58698bb5-a1f2-4361-bfd2-aaeeed077d93','2025-12-06 04:41:17',NULL,'CREATE','FAILED','0','62d77fda-4406-4d65-97a1-b9a2d6385a9f','CREATE aborted (Task create from SoftwareDeployment \"0\" Stack \"ParallelDeploymentsTest-1855891113-dep_2-xvi4ebuumjew\" [58698bb5-a1f2-4361-bfd2-aaeeed077d93] Timed out)','OS::Heat::SoftwareDeployment',NULL,246),(1458,'03856408-7f43-4948-bd6c-b04483a132b7','237b0453-1901-423d-a107-e08a79190113','2025-12-06 04:41:17',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1855891113-dep_0-fpvlnauhtbx7','237b0453-1901-423d-a107-e08a79190113','Timed out','OS::Heat::Stack',NULL,NULL),(1459,'47486003-2916-4c2a-afa3-5186854aa08e','58698bb5-a1f2-4361-bfd2-aaeeed077d93','2025-12-06 04:41:17',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1855891113-dep_2-xvi4ebuumjew','58698bb5-a1f2-4361-bfd2-aaeeed077d93','Timed out','OS::Heat::Stack',NULL,NULL),(1460,'b875928d-922b-4098-836c-7a6e104c2b83','093cb3c6-d376-4f93-bc88-6137e9055c81','2025-12-06 04:41:17',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1855891113-dep_1-yl2aejpg6ypz','093cb3c6-d376-4f93-bc88-6137e9055c81','Timed out','OS::Heat::Stack',NULL,NULL),(1461,'5b47362b-093f-41ad-97c8-e2b3194ffca3','0c199995-f685-4cda-9487-b9fba4bd651f','2025-12-06 04:41:20',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1855891113','0c199995-f685-4cda-9487-b9fba4bd651f','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1462,'4398a380-8f39-4fdf-aed8-246503631ae5','0c199995-f685-4cda-9487-b9fba4bd651f','2025-12-06 04:41:20',NULL,'DELETE','IN_PROGRESS','dep_1','093cb3c6-d376-4f93-bc88-6137e9055c81','state changed','OS::Heat::SoftwareDeployments',NULL,242),(1463,'d6d45b57-67b3-467b-9b36-91b44eef5d08','093cb3c6-d376-4f93-bc88-6137e9055c81','2025-12-06 04:41:20',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1855891113-dep_1-yl2aejpg6ypz','093cb3c6-d376-4f93-bc88-6137e9055c81','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1464,'8b9ba28f-04d8-43c4-a87b-0fee3905fd06','093cb3c6-d376-4f93-bc88-6137e9055c81','2025-12-06 04:41:20',NULL,'DELETE','IN_PROGRESS','0','ad2bf730-d7a3-4dfc-bc5b-8e461b0a23ad','state changed','OS::Heat::SoftwareDeployment',NULL,245),(1465,'26471c38-6236-4231-b322-62dc15bf62e6','0c199995-f685-4cda-9487-b9fba4bd651f','2025-12-06 04:41:21',NULL,'DELETE','IN_PROGRESS','dep_2','58698bb5-a1f2-4361-bfd2-aaeeed077d93','state changed','OS::Heat::SoftwareDeployments',NULL,243),(1466,'41e9ffb3-2caa-4d78-8547-5ded7fe73b7c','58698bb5-a1f2-4361-bfd2-aaeeed077d93','2025-12-06 04:41:21',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1855891113-dep_2-xvi4ebuumjew','58698bb5-a1f2-4361-bfd2-aaeeed077d93','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1467,'c2f41b33-bd14-4d19-9493-a71b0e40dbeb','58698bb5-a1f2-4361-bfd2-aaeeed077d93','2025-12-06 04:41:21',NULL,'DELETE','IN_PROGRESS','0','62d77fda-4406-4d65-97a1-b9a2d6385a9f','state changed','OS::Heat::SoftwareDeployment',NULL,246),(1468,'834314c1-1f08-400d-bd0f-0ba661e633f7','093cb3c6-d376-4f93-bc88-6137e9055c81','2025-12-06 04:41:21',NULL,'DELETE','COMPLETE','0','ad2bf730-d7a3-4dfc-bc5b-8e461b0a23ad','state changed','OS::Heat::SoftwareDeployment',NULL,245),(1469,'343d4b77-b17a-44e2-87c3-6444db2ada45','093cb3c6-d376-4f93-bc88-6137e9055c81','2025-12-06 04:41:21',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1855891113-dep_1-yl2aejpg6ypz','093cb3c6-d376-4f93-bc88-6137e9055c81','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1470,'d49ebe7d-ca4a-4285-b57d-63f05a52a57e','0c199995-f685-4cda-9487-b9fba4bd651f','2025-12-06 04:41:22',NULL,'DELETE','COMPLETE','dep_1','093cb3c6-d376-4f93-bc88-6137e9055c81','state changed','OS::Heat::SoftwareDeployments',NULL,242),(1471,'0c71c899-5974-4aa1-ae74-5f6f5a058d3f','0c199995-f685-4cda-9487-b9fba4bd651f','2025-12-06 04:41:22',NULL,'DELETE','IN_PROGRESS','dep_0','237b0453-1901-423d-a107-e08a79190113','state changed','OS::Heat::SoftwareDeployments',NULL,241),(1472,'285ccf34-78fe-4280-abf6-48d725a5e05c','237b0453-1901-423d-a107-e08a79190113','2025-12-06 04:41:23',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1855891113-dep_0-fpvlnauhtbx7','237b0453-1901-423d-a107-e08a79190113','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1473,'2fcff540-198b-43c7-996d-2fbba12c18b3','237b0453-1901-423d-a107-e08a79190113','2025-12-06 04:41:23',NULL,'DELETE','IN_PROGRESS','0','92f9b0b4-5e98-437b-98c9-6dac28b4e0e8','state changed','OS::Heat::SoftwareDeployment',NULL,244),(1474,'7293b0fe-c99e-4f89-94bc-7e33ef1c3b34','58698bb5-a1f2-4361-bfd2-aaeeed077d93','2025-12-06 04:41:23',NULL,'DELETE','COMPLETE','0','62d77fda-4406-4d65-97a1-b9a2d6385a9f','state changed','OS::Heat::SoftwareDeployment',NULL,246),(1475,'eeb9c227-f9cb-4369-a125-6e41ac4630b4','58698bb5-a1f2-4361-bfd2-aaeeed077d93','2025-12-06 04:41:23',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1855891113-dep_2-xvi4ebuumjew','58698bb5-a1f2-4361-bfd2-aaeeed077d93','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1476,'a0184519-e211-4747-a14c-7de95502677d','0c199995-f685-4cda-9487-b9fba4bd651f','2025-12-06 04:41:24',NULL,'DELETE','COMPLETE','dep_2','58698bb5-a1f2-4361-bfd2-aaeeed077d93','state changed','OS::Heat::SoftwareDeployments',NULL,243),(1477,'5d8a763e-3e15-4b34-bcb3-75177ce9c8a5','237b0453-1901-423d-a107-e08a79190113','2025-12-06 04:41:24',NULL,'DELETE','COMPLETE','0','92f9b0b4-5e98-437b-98c9-6dac28b4e0e8','state changed','OS::Heat::SoftwareDeployment',NULL,244),(1478,'20f299a8-072f-4680-a5eb-780756c8596e','237b0453-1901-423d-a107-e08a79190113','2025-12-06 04:41:25',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1855891113-dep_0-fpvlnauhtbx7','237b0453-1901-423d-a107-e08a79190113','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1479,'56322891-d7b0-429f-89dc-b87c0f848190','0c199995-f685-4cda-9487-b9fba4bd651f','2025-12-06 04:41:27',NULL,'DELETE','COMPLETE','dep_0','237b0453-1901-423d-a107-e08a79190113','state changed','OS::Heat::SoftwareDeployments',NULL,241),(1480,'5efa8acc-ce99-4fba-9436-783185208988','0c199995-f685-4cda-9487-b9fba4bd651f','2025-12-06 04:41:27',NULL,'DELETE','IN_PROGRESS','config','a2bf6543-68d4-45b2-8c5f-a902fc3582ec','state changed','OS::Heat::SoftwareConfig',NULL,240),(1481,'469adf35-d70f-4895-9245-52908cae0ca9','0c199995-f685-4cda-9487-b9fba4bd651f','2025-12-06 04:41:28',NULL,'DELETE','COMPLETE','config','a2bf6543-68d4-45b2-8c5f-a902fc3582ec','state changed','OS::Heat::SoftwareConfig',NULL,240),(1482,'452ec6b8-6c1f-450a-9603-d52b8494c143','0c199995-f685-4cda-9487-b9fba4bd651f','2025-12-06 04:41:28',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1855891113','0c199995-f685-4cda-9487-b9fba4bd651f','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1483,'5222dd56-b838-445c-83f7-f3ac60259b50','9770ae5b-d5f6-4788-8560-f024b14c6672','2025-12-06 04:41:35',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-2124645028','9770ae5b-d5f6-4788-8560-f024b14c6672','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1484,'4965bc1c-33c6-4535-a83a-e4a11e2a04a2','9770ae5b-d5f6-4788-8560-f024b14c6672','2025-12-06 04:41:35',NULL,'DELETE','IN_PROGRESS','server','446987cb-d72d-4631-8ce6-2da7b3951475','state changed','OS::Nova::Server',NULL,239),(1485,'16c69c5a-fcfc-434c-8563-ef7fce091e83','9770ae5b-d5f6-4788-8560-f024b14c6672','2025-12-06 04:41:39',NULL,'DELETE','COMPLETE','server','446987cb-d72d-4631-8ce6-2da7b3951475','state changed','OS::Nova::Server',NULL,239),(1486,'c34b2fe5-8a49-4038-9c8a-a8fd2c04f5f1','9770ae5b-d5f6-4788-8560-f024b14c6672','2025-12-06 04:41:39',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-2124645028','9770ae5b-d5f6-4788-8560-f024b14c6672','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL);
/*!40000 ALTER TABLE `event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('heat','/usr/lib/python3.9/site-packages/heat/db/sqlalchemy/migrate_repo',86);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template`
--

DROP TABLE IF EXISTS `raw_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `template` longtext DEFAULT NULL,
  `files` longtext DEFAULT NULL,
  `environment` longtext DEFAULT NULL,
  `files_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_tmpl_files_fkey_ref` (`files_id`),
  CONSTRAINT `raw_tmpl_files_fkey_ref` FOREIGN KEY (`files_id`) REFERENCES `raw_template_files` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=233 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template`
--

LOCK TABLES `raw_template` WRITE;
/*!40000 ALTER TABLE `raw_template` DISABLE KEYS */;
INSERT INTO `raw_template` (`id`, `created_at`, `updated_at`, `template`, `files`, `environment`, `files_id`) VALUES (2,'2025-12-06 04:28:14',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(3,'2025-12-06 04:28:14',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(5,'2025-12-06 04:28:16',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"test\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(6,'2025-12-06 04:28:16',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(8,'2025-12-06 04:28:19',NULL,'{\"heat_template_version\": \"2016-04-08\"}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(14,'2025-12-06 04:28:22',NULL,'{\"heat_template_version\": \"2016-04-08\"}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(15,'2025-12-06 04:28:22',NULL,'{\"heat_template_version\": \"2016-04-08\"}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(16,'2025-12-06 04:28:22',NULL,'{\"heat_template_version\": \"pike\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"value\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(22,'2025-12-06 04:28:27',NULL,'{\"heat_template_version\": \"pike\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"new_patched_value\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(24,'2025-12-06 04:28:29',NULL,'{\"heat_template_version\": \"pike\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}, \"action_wait_secs\": {\"update\": 1}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"new_patched_value\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(25,'2025-12-06 04:28:32',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create port wit ip_address.\", \"parameters\": {\"mac\": {\"type\": \"string\", \"default\": \"00-00-00-00-BB-BB\"}}, \"resources\": {}, \"outputs\": {\"port_ip\": {\"value\": {\"get_attr\": [\"port\", \"fixed_ips\", 0, \"ip_address\"]}}, \"mac_address\": {\"value\": {\"get_attr\": [\"port\", \"mac_address\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(29,'2025-12-06 04:28:40',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(30,'2025-12-06 04:28:43',NULL,'{\"heat_template_version\": \"2014-10-16\", \"parameters\": {\"image\": {\"type\": \"string\"}, \"flavor\": {\"type\": \"string\"}, \"network\": {\"type\": \"string\"}, \"foo\": {\"type\": \"string\", \"description\": \"parameter with encryption turned on\", \"hidden\": true, \"default\": \"secret\"}}, \"resources\": {}, \"outputs\": {\"encrypted_foo_param\": {\"description\": \"encrypted param\", \"value\": {\"get_param\": \"foo\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\", \"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"network\": \"heat_tempestconf_network\", \"foo\": \"my_encrypted_foo\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(35,'2025-12-06 04:28:50',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"remote_key\": {\"value\": {\"get_attr\": [\"random1\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(37,'2025-12-06 04:28:55',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create port wit ip_address.\", \"parameters\": {\"mac\": {\"type\": \"string\", \"default\": \"00-00-00-00-BB-BB\"}}, \"resources\": {}, \"outputs\": {\"port_ip\": {\"value\": {\"get_attr\": [\"port\", \"fixed_ips\", 0, \"ip_address\"]}}, \"mac_address\": {\"value\": {\"get_attr\": [\"port\", \"mac_address\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"mac\": \"00-00-00-00-AA-AA\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(39,'2025-12-06 04:28:57',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(40,'2025-12-06 04:28:57',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(45,'2025-12-06 04:29:02',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(46,'2025-12-06 04:29:04',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"key\": {\"value\": {\"get_attr\": [\"my_stack\", \"outputs\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',1),(47,'2025-12-06 04:29:04',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"remote_key\": {\"value\": {\"get_attr\": [\"random1\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',2),(53,'2025-12-06 04:29:14',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(54,'2025-12-06 04:29:14',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(57,'2025-12-06 04:29:22',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(58,'2025-12-06 04:29:25',NULL,'{\"heat_template_version\": \"2014-10-16\", \"description\": \"foo\", \"parameters\": {\"input\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(59,'2025-12-06 04:29:26',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"key\": {\"value\": {\"get_attr\": [\"my_stack\", \"outputs\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',3),(60,'2025-12-06 04:29:26',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"remote_key\": {\"value\": {\"get_attr\": [\"random1\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',4),(65,'2025-12-06 04:29:32',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(72,'2025-12-06 04:29:45',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"key\": {\"value\": {\"get_attr\": [\"my_stack\", \"outputs\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',7),(73,'2025-12-06 04:29:45',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"remote_key\": {\"value\": {\"get_attr\": [\"random2\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',8),(75,'2025-12-06 04:29:47',NULL,'{\"heat_template_version\": \"2014-10-16\", \"description\": \"foo\", \"parameters\": {\"input\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"input\": \"none\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(79,'2025-12-06 04:29:55',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(80,'2025-12-06 04:29:56',NULL,'{\"heat_template_version\": \"2014-10-16\", \"parameters\": null, \"resources\": {}, \"outputs\": {\"resource_id\": {\"description\": \"ID of resource\", \"value\": {\"get_resource\": \"test_resource\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(82,'2025-12-06 04:29:56',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(87,'2025-12-06 04:30:05',NULL,'{\"description\": \"The root stack (containing a remote stack) for the deeply-nested remote\\nstack test.\\n\", \"heat_template_version\": \"2015-10-15\", \"outputs\": {\"router\": {\"value\": {\"get_attr\": [\"network_stack\", \"outputs\", \"router\"]}}}, \"parameters\": {\"name\": {\"constraints\": [{\"allowed_pattern\": \"[a-z][a-z0-9-]{1,}\"}], \"description\": \"Name of the router\", \"type\": \"string\"}, \"network_name\": {\"constraints\": [{\"custom_constraint\": \"neutron.network\"}], \"description\": \"The public network to connect to\", \"type\": \"string\"}, \"region\": {\"default\": \"RegionOne\", \"description\": \"The region in which to create the remote stack\", \"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"name\": \"remote-nested\", \"network_name\": \"public\", \"region\": \"regionOne\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',9),(89,'2025-12-06 04:30:06',NULL,'{\"heat_template_version\": \"2015-10-15\", \"description\": \"The intermediate stack (containing a local nested stack) to be instantiated\\nremotely in the remote deeply-nested stack test.\\n\", \"parameters\": {\"name\": {\"type\": \"string\", \"description\": \"Name of the router\", \"constraints\": [{\"allowed_pattern\": \"[a-z][a-z0-9-]{1,}\"}]}, \"network_name\": {\"type\": \"string\", \"description\": \"The public network to connect to\", \"constraints\": [{\"custom_constraint\": \"neutron.network\"}]}}, \"resources\": {}, \"outputs\": {\"router\": {\"value\": {\"get_attr\": [\"network_stack_as_custom_type\", \"router\"]}}}}','null','{\"resource_registry\": {\"resources\": {}, \"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\": \"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\"}, \"parameters\": {\"name\": \"remote-nested\", \"network_name\": \"public\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',10),(91,'2025-12-06 04:30:07',NULL,'{\"heat_template_version\": \"2015-10-15\", \"description\": \"The base stack (containing an actual resource) for the remote deeply-nested\\nstack test.\\n\", \"parameters\": {\"name\": {\"type\": \"string\", \"description\": \"Name of the router\", \"constraints\": [{\"allowed_pattern\": \"[a-z][a-z0-9-]{1,}\"}]}, \"network_name\": {\"type\": \"string\", \"description\": \"The network to connect to\", \"constraints\": [{\"custom_constraint\": \"neutron.network\"}]}}, \"resources\": {}, \"outputs\": {\"router\": {\"value\": {\"get_resource\": \"router\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"name\": \"remote-nested\", \"network_name\": \"public\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',10),(93,'2025-12-06 04:30:11',NULL,'{\"heat_template_version\": \"2015-10-15\", \"resources\": {}, \"outputs\": {\"resource_output_a\": {\"value\": {\"get_attr\": [\"parent\", \"resource_output_a\"]}, \"description\": \"parent a\"}, \"resource_output_b\": {\"value\": {\"get_attr\": [\"parent\", \"resource_output_b\"]}, \"description\": \"parent b\"}}}','null','{\"resource_registry\": {\"resources\": {}, \"1.yaml\": \"1.yaml\"}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',12),(95,'2025-12-06 04:30:12',NULL,'{\"heat_template_version\": \"2015-10-15\", \"resources\": {}, \"outputs\": {\"resource_output_a\": {\"description\": \"Output of resource a\", \"value\": {\"get_attr\": [\"test_resource_a\", \"output\"]}}, \"resource_output_b\": {\"description\": \"Output of resource b\", \"value\": {\"get_param\": \"foo\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',12),(97,'2025-12-06 04:30:16',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(98,'2025-12-06 04:30:23',NULL,'{\"heat_template_version\": \"2015-10-15\", \"resources\": {}, \"outputs\": {\"resource_output_a\": {\"description\": \"Output of resource a\", \"value\": {\"get_attr\": [\"test_resource_a\", \"output\"]}}, \"resource_output_b\": {\"description\": \"Output of resource b\", \"value\": {\"get_attr\": [\"test_resource_b\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(104,'2025-12-06 04:30:36',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(105,'2025-12-06 04:30:37',NULL,'{\"heat_template_version\": \"2015-10-15\", \"resources\": {}, \"outputs\": {\"output_value\": {\"description\": \"Output of resource b\", \"value\": {\"get_attr\": [\"test_resource_b\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(106,'2025-12-06 04:30:38',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create encryption volume type.\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(110,'2025-12-06 04:30:50',NULL,'{\"heat_template_version\": \"2014-10-16\", \"description\": \"Test Template APIs\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(113,'2025-12-06 04:31:16',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(114,'2025-12-06 04:31:22',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(118,'2025-12-06 04:31:51',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(121,'2025-12-06 04:32:04',NULL,'{\"heat_template_version\": \"2016-10-14\", \"resources\": {}, \"outputs\": {\"str\": {\"value\": {\"get_resource\": \"test1\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(124,'2025-12-06 04:32:15',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(125,'2025-12-06 04:32:18',NULL,'{\"heat_template_version\": \"2016-10-14\", \"resources\": {}, \"outputs\": {\"str\": {\"value\": {\"get_resource\": \"test1\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(127,'2025-12-06 04:32:23',NULL,'{\"heat_template_version\": \"2016-10-14\", \"resources\": {\"test1\": {\"type\": \"OS::Heat::TestResource\"}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(129,'2025-12-06 04:32:29',NULL,'{\"heat_template_version\": \"2016-10-14\", \"resources\": {}, \"outputs\": {\"str\": {\"value\": {\"get_resource\": \"test1\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(132,'2025-12-06 04:32:48',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_step2\": {\"hooks\": \"pre-create\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(135,'2025-12-06 04:33:00',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(137,'2025-12-06 04:33:17',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"nested\": {\"foo_step2\": {\"hooks\": \"pre-create\"}}}, \"nested.yaml\": \"nested.yaml\"}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',13),(138,'2025-12-06 04:33:18',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_step2\": {\"hooks\": \"pre-create\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',13),(140,'2025-12-06 04:33:43',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_*\": {\"hooks\": \"pre-create\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(146,'2025-12-06 04:34:04',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"rg\": {\"hooks\": \"pre-update\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(147,'2025-12-06 04:34:04',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}, \"outputs\": {\"refs_map\": {\"value\": {\"0\": {\"get_resource\": \"0\"}, \"1\": {\"get_resource\": \"1\"}}}}}','null','{\"resource_registry\": {\"resources\": {\"hooks\": \"pre-update\"}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(150,'2025-12-06 04:34:14',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(151,'2025-12-06 04:34:19',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_step2\": {\"hooks\": \"pre-update\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(155,'2025-12-06 04:34:40',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_step2\": {\"hooks\": \"pre-update\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(158,'2025-12-06 04:35:17',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server with port.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(159,'2025-12-06 04:35:21',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(163,'2025-12-06 04:36:12',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server with subnet and fixed_ip.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"networks\": {\"value\": {\"get_attr\": [\"server\", \"networks\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(164,'2025-12-06 04:36:18',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(169,'2025-12-06 04:37:08',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(171,'2025-12-06 04:37:18',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"networks\": {\"value\": {\"get_attr\": [\"server\", \"networks\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(172,'2025-12-06 04:37:19',NULL,'{\"heat_template_version\": \"2014-10-16\", \"description\": \"\\u8fd9\\u662f\\u4e00\\u4e2a\\u63cf\\u8ff0\", \"parameters\": {\"\\u53c2\\u6570\": {\"type\": \"number\", \"default\": 10, \"label\": \"\\u6807\\u7b7e\", \"description\": \"\\u8fd9\\u662f\\u4e00\\u4e2a\\u63cf\\u8ff0\"}}, \"resources\": {}, \"outputs\": {\"\\u8f93\\u51fa\": {\"description\": \"\\u8fd9\\u662f\\u4e00\\u4e2a\\u63cf\\u8ff0\", \"value\": {\"get_attr\": [\"\\u8d44\\u6e90\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(198,'2025-12-06 04:38:40',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(199,'2025-12-06 04:38:40',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(200,'2025-12-06 04:38:41',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(201,'2025-12-06 04:38:42',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(202,'2025-12-06 04:38:49',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(203,'2025-12-06 04:38:49',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(204,'2025-12-06 04:38:50',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(205,'2025-12-06 04:38:51',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(206,'2025-12-06 04:38:59',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(207,'2025-12-06 04:38:59',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(208,'2025-12-06 04:39:00',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(209,'2025-12-06 04:39:01',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(210,'2025-12-06 04:39:15',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(211,'2025-12-06 04:39:15',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(212,'2025-12-06 04:39:16',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(213,'2025-12-06 04:39:17',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(214,'2025-12-06 04:39:18',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(215,'2025-12-06 04:39:19',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(216,'2025-12-06 04:39:31',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(217,'2025-12-06 04:39:31',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(218,'2025-12-06 04:39:33',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(219,'2025-12-06 04:39:33',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(220,'2025-12-06 04:39:34',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(221,'2025-12-06 04:39:35',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(222,'2025-12-06 04:39:45',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}, \"network\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"server\": {\"value\": {\"get_resource\": \"server\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"network\": \"heat_tempestconf_network\", \"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(228,'2025-12-06 04:41:20',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"446987cb-d72d-4631-8ce6-2da7b3951475\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(229,'2025-12-06 04:41:20',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(230,'2025-12-06 04:41:21',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(231,'2025-12-06 04:41:22',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(232,'2025-12-06 04:41:35',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}, \"network\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"server\": {\"value\": {\"get_resource\": \"server\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"network\": \"heat_tempestconf_network\", \"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL);
/*!40000 ALTER TABLE `raw_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template_files`
--

DROP TABLE IF EXISTS `raw_template_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `files` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template_files`
--

LOCK TABLES `raw_template_files` WRITE;
/*!40000 ALTER TABLE `raw_template_files` DISABLE KEYS */;
INSERT INTO `raw_template_files` (`id`, `files`, `created_at`, `updated_at`) VALUES (1,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}','2025-12-06 04:28:56',NULL),(2,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}','2025-12-06 04:28:57',NULL),(3,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}','2025-12-06 04:29:10',NULL),(4,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}','2025-12-06 04:29:11',NULL),(7,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random2:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random2, value]}\\n\"}','2025-12-06 04:29:40',NULL),(8,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random2:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random2, value]}\\n\"}','2025-12-06 04:29:41',NULL),(9,'{\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The base stack (containing an actual resource) for the remote deeply-nested\\\\nstack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"router\\\": {\\\"type\\\": \\\"OS::Neutron::Router\\\", \\\"properties\\\": {\\\"name\\\": {\\\"list_join\\\": [\\\"-\\\", [{\\\"get_param\\\": \\\"name\\\"}, \\\"router\\\"]]}, \\\"external_gateway_info\\\": {\\\"network\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_resource\\\": \\\"router\\\"}}}}\", \"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_intermediate.yaml\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The intermediate stack (containing a local nested stack) to be instantiated\\\\nremotely in the remote deeply-nested stack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The public network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"network_stack_as_custom_type\\\": {\\\"type\\\": \\\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\\\", \\\"properties\\\": {\\\"name\\\": {\\\"get_param\\\": \\\"name\\\"}, \\\"network_name\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_attr\\\": [\\\"network_stack_as_custom_type\\\", \\\"router\\\"]}}}}\"}','2025-12-06 04:29:54',NULL),(10,'{\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The base stack (containing an actual resource) for the remote deeply-nested\\\\nstack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"router\\\": {\\\"type\\\": \\\"OS::Neutron::Router\\\", \\\"properties\\\": {\\\"name\\\": {\\\"list_join\\\": [\\\"-\\\", [{\\\"get_param\\\": \\\"name\\\"}, \\\"router\\\"]]}, \\\"external_gateway_info\\\": {\\\"network\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_resource\\\": \\\"router\\\"}}}}\", \"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_intermediate.yaml\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The intermediate stack (containing a local nested stack) to be instantiated\\\\nremotely in the remote deeply-nested stack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The public network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"network_stack_as_custom_type\\\": {\\\"type\\\": \\\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\\\", \\\"properties\\\": {\\\"name\\\": {\\\"get_param\\\": \\\"name\\\"}, \\\"network_name\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_attr\\\": [\\\"network_stack_as_custom_type\\\", \\\"router\\\"]}}}}\"}','2025-12-06 04:29:56',NULL),(12,'{\"1.yaml\": \"\\nheat_template_version: 2015-10-15\\nresources:\\n  test_resource_a:\\n    type: OS::Heat::TestResource\\n    properties:\\n      value: \'a\'\\n  test_resource_b:\\n    type: OS::Heat::TestResource\\n    properties:\\n      value: \'b\'\\noutputs:\\n  resource_output_a:\\n    description: \'Output of resource a\'\\n    value: { get_attr: [test_resource_a, output] }\\n  resource_output_b:\\n    description: \'Output of resource b\'\\n    value: { get_param: foo }\\n\"}','2025-12-06 04:30:07',NULL),(13,'{\"nested.yaml\": \"heat_template_version: \'2014-10-16\'\\nresources:\\n  foo_step1:\\n    type: OS::Heat::RandomString\\n  foo_step2:\\n    depends_on: foo_step1\\n    type: OS::Heat::RandomString\\n  foo_step3:\\n    depends_on: foo_step2\\n    type: OS::Heat::RandomString\\n\"}','2025-12-06 04:32:59',NULL);
/*!40000 ALTER TABLE `raw_template_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource`
--

DROP TABLE IF EXISTS `resource`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `nova_instance` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `rsrc_metadata` longtext DEFAULT NULL,
  `properties_data` longtext DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  `atomic_key` int(11) DEFAULT NULL,
  `needed_by` longtext DEFAULT NULL,
  `requires` longtext DEFAULT NULL,
  `replaces` int(11) DEFAULT NULL,
  `replaced_by` int(11) DEFAULT NULL,
  `current_template_id` int(11) DEFAULT NULL,
  `properties_data_encrypted` tinyint(1) DEFAULT NULL,
  `root_stack_id` varchar(36) DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  `attr_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `current_template_id` (`current_template_id`),
  KEY `ix_resource_root_stack_id` (`root_stack_id`),
  KEY `rsrc_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  KEY `rsrc_attr_data_ref` (`attr_data_id`),
  CONSTRAINT `resource_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`),
  CONSTRAINT `resource_ibfk_2` FOREIGN KEY (`current_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `rsrc_attr_data_ref` FOREIGN KEY (`attr_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `rsrc_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=227 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource`
--

LOCK TABLES `resource` WRITE;
/*!40000 ALTER TABLE `resource` DISABLE KEYS */;
INSERT INTO `resource` (`id`, `uuid`, `nova_instance`, `name`, `created_at`, `updated_at`, `action`, `status`, `status_reason`, `stack_id`, `rsrc_metadata`, `properties_data`, `engine_id`, `atomic_key`, `needed_by`, `requires`, `replaces`, `replaced_by`, `current_template_id`, `properties_data_encrypted`, `root_stack_id`, `rsrc_prop_data_id`, `attr_data_id`) VALUES (3,'c79af555-ca33-413a-868a-c2779b905216','api-177751087-rsrcstack-test-cowkgpdzv5kv','test','2025-12-06 04:28:15',NULL,'CHECK','FAILED','resource deleted','df0f1d90-584d-4519-9f92-c941e844c96f','{}','null',NULL,4,'[]','[]',NULL,NULL,2,NULL,'df0f1d90-584d-4519-9f92-c941e844c96f',3,NULL),(4,'c030694d-3a85-4549-979a-d157cc5314d6','api-2090761251-rsrcstack-test-ksj2qxada2kn','test','2025-12-06 04:28:15',NULL,'CREATE','COMPLETE','state changed','c22a3547-29b3-4d86-a454-7b0eb5bcdddc','{}','null',NULL,2,'[]','[]',NULL,NULL,3,NULL,'c22a3547-29b3-4d86-a454-7b0eb5bcdddc',4,NULL),(10,'83ebaa21-e0a2-4afe-b646-af779445fcf8','api-2090761251-stack-test-v7xaukb6xkrb','test','2025-12-06 04:28:23',NULL,'CREATE','COMPLETE','state changed','e891c0be-46f8-4039-80ba-3d2098c6d785','{}','null',NULL,2,'[]','[]',NULL,NULL,16,NULL,'e891c0be-46f8-4039-80ba-3d2098c6d785',6,NULL),(11,'2a3eecd5-8a58-48f9-b1a3-e05695c9aa72','api-229566953-stack-test-r6mklavd53gv','test','2025-12-06 04:28:23','2025-12-06 04:28:29','UPDATE','COMPLETE','state changed','9c9c85f4-553c-4e26-a99e-a35619f0439b','{}','null',NULL,6,'[]','[]',NULL,NULL,24,NULL,'9c9c85f4-553c-4e26-a99e-a35619f0439b',19,NULL);
/*!40000 ALTER TABLE `resource` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_data`
--

DROP TABLE IF EXISTS `resource_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  `redact` tinyint(1) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `resource_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_resource_id` (`resource_id`),
  CONSTRAINT `fk_resource_id` FOREIGN KEY (`resource_id`) REFERENCES `resource` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=248 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_data`
--

LOCK TABLES `resource_data` WRITE;
/*!40000 ALTER TABLE `resource_data` DISABLE KEYS */;
INSERT INTO `resource_data` (`id`, `created_at`, `updated_at`, `key`, `value`, `redact`, `decrypt_method`, `resource_id`) VALUES (3,'2025-12-06 04:28:15',NULL,'value','test',0,'',3),(4,'2025-12-06 04:28:15',NULL,'value','test',0,'',4),(7,'2025-12-06 04:28:23',NULL,'value','value',0,'',10),(8,'2025-12-06 04:28:23','2025-12-06 04:28:29','value','new_patched_value',0,'',11);
/*!40000 ALTER TABLE `resource_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_properties_data`
--

DROP TABLE IF EXISTS `resource_properties_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_properties_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `data` longtext DEFAULT NULL,
  `encrypted` tinyint(1) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=247 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_properties_data`
--

LOCK TABLES `resource_properties_data` WRITE;
/*!40000 ALTER TABLE `resource_properties_data` DISABLE KEYS */;
INSERT INTO `resource_properties_data` (`id`, `data`, `encrypted`, `created_at`, `updated_at`) VALUES (1,'{\"value\": \"test\"}',0,'2025-12-06 04:28:15',NULL),(2,'{\"value\": \"test\"}',0,'2025-12-06 04:28:15',NULL),(3,'{\"value\": \"test\"}',0,'2025-12-06 04:28:15',NULL),(4,'{\"value\": \"test\"}',0,'2025-12-06 04:28:15',NULL),(5,'{\"value\": \"value\"}',0,'2025-12-06 04:28:20',NULL),(6,'{\"value\": \"value\"}',0,'2025-12-06 04:28:23',NULL),(7,'{\"enable_dhcp\": false, \"network\": \"5bb017d0-d73d-4f54-b5fb-db3a628a4122\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-12-06 04:28:23',NULL),(8,'{\"value\": \"value\"}',0,'2025-12-06 04:28:23',NULL),(9,'{\"value\": \"new_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2025-12-06 04:28:23',NULL),(10,'{\"network\": \"5bb017d0-d73d-4f54-b5fb-db3a628a4122\", \"mac_address\": \"00-00-00-00-BB-BB\", \"fixed_ips\": [{\"subnet\": \"6121f159-8ee9-47d5-847f-409fd23046f2\", \"ip_address\": \"11.11.11.11\"}]}',0,'2025-12-06 04:28:24',NULL),(12,'{\"value\": \"Test1\", \"fail\": false}',0,'2025-12-06 04:28:25',NULL),(13,'{\"name\": \"my_encrypted_foo\", \"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\", \"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"networks\": [{\"network\": \"heat_tempestconf_network\"}]}',0,'2025-12-06 04:28:25',NULL),(14,'{\"value\": \"new_patched_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2025-12-06 04:28:26',NULL),(15,'{\"value\": \"new_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2025-12-06 04:28:28',NULL),(16,'{\"network\": \"5bb017d0-d73d-4f54-b5fb-db3a628a4122\", \"mac_address\": \"00-00-00-00-BB-BB\", \"fixed_ips\": [{\"subnet\": \"6121f159-8ee9-47d5-847f-409fd23046f2\"}]}',0,'2025-12-06 04:28:29',NULL),(18,'{\"network\": \"88cf0c3f-0bf9-482d-85b7-e3f90775ad49\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-12-06 04:28:31',NULL),(19,'{\"value\": \"new_patched_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2025-12-06 04:28:31',NULL),(21,'{\"cidr\": \"10.0.0.0/16\", \"network\": \"46411669-3e9e-4679-8d33-96aeeae470cc\"}',0,'2025-12-06 04:28:35',NULL),(22,'{\"cidr\": \"10.20.0.0/16\", \"network\": \"d774ea99-7814-4d82-9470-d141490ef043\"}',0,'2025-12-06 04:28:36',NULL),(23,'{\"network\": \"88cf0c3f-0bf9-482d-85b7-e3f90775ad49\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.100\"}]}',0,'2025-12-06 04:28:36',NULL),(24,'{\"name\": \"trunk_parent_port\", \"network\": \"46411669-3e9e-4679-8d33-96aeeae470cc\"}',0,'2025-12-06 04:28:37',NULL),(25,'{\"cidr\": \"10.10.0.0/16\", \"network\": \"ae2eff72-d93f-4097-a209-b442838f4082\"}',0,'2025-12-06 04:28:37',NULL),(27,'{\"name\": \"trunk_sub_port_two\", \"network\": \"d774ea99-7814-4d82-9470-d141490ef043\"}',0,'2025-12-06 04:28:39',NULL),(28,'{\"enable_dhcp\": false, \"network\": \"22c87822-dadc-4aed-9722-6cb4c651490d\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-12-06 04:28:40',NULL),(29,'{\"name\": \"trunk_sub_port_one\", \"network\": \"ae2eff72-d93f-4097-a209-b442838f4082\"}',0,'2025-12-06 04:28:40',NULL),(30,'{\"network\": \"22c87822-dadc-4aed-9722-6cb4c651490d\", \"mac_address\": \"00-00-00-00-BB-BB\", \"fixed_ips\": [{\"subnet\": \"7bacc5cb-9dd9-4a78-94ba-f81785a81555\", \"ip_address\": \"11.11.11.11\"}]}',0,'2025-12-06 04:28:41',NULL),(31,'{\"name\": \"test_trunk\", \"port\": \"0cb0a77a-1aa2-414e-be4d-4df7599f71ac\", \"sub_ports\": [{\"port\": \"f1bf571f-185b-4114-888d-72286c4caaa2\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2025-12-06 04:28:42',NULL),(33,'{\"value\": \"Test1\", \"fail\": false}',0,'2025-12-06 04:28:42',NULL),(34,'{\"network\": \"2d7846d7-d08f-4eda-90c9-8c5cb661f0b2\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-12-06 04:28:47',NULL),(35,'{\"network\": \"22c87822-dadc-4aed-9722-6cb4c651490d\", \"mac_address\": \"00-00-00-00-AA-AA\", \"fixed_ips\": [{\"subnet\": \"7bacc5cb-9dd9-4a78-94ba-f81785a81555\", \"ip_address\": \"11.11.11.11\"}]}',0,'2025-12-06 04:28:47',NULL),(37,'{\"name\": \"test_trunk\", \"port\": \"0cb0a77a-1aa2-414e-be4d-4df7599f71ac\", \"sub_ports\": [{\"port\": \"f1bf571f-185b-4114-888d-72286c4caaa2\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}, {\"port\": \"c413f1da-d8a9-48bf-bd3a-6509419f83e9\", \"segmentation_id\": 20, \"segmentation_type\": \"vlan\"}]}',0,'2025-12-06 04:28:50',NULL),(39,'{\"network\": \"2d7846d7-d08f-4eda-90c9-8c5cb661f0b2\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": []}',0,'2025-12-06 04:28:52',NULL),(42,'{\"context\": {\"region_name\": \"regionOne\"}, \"template\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}',0,'2025-12-06 04:28:57',NULL),(43,'{\"value\": \"Test1\"}',0,'2025-12-06 04:29:02',NULL),(44,'{\"value\": \"Test2\"}',0,'2025-12-06 04:29:02',NULL),(46,'{\"network\": \"80c15e34-6b1a-4376-8a39-81b329aae54e\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-12-06 04:29:04',NULL),(47,'{\"network\": \"9707ea6e-e22c-461c-a053-f0f3c46d6ef5\", \"cidr\": \"10.0.0.0/16\"}',0,'2025-12-06 04:29:05',NULL),(48,'{\"network\": \"c779bd81-3bbe-47e2-a683-dbba250402e4\", \"cidr\": \"10.20.0.0/16\"}',0,'2025-12-06 04:29:05',NULL),(49,'{\"network\": \"9707ea6e-e22c-461c-a053-f0f3c46d6ef5\", \"name\": \"trunk_parent_port\"}',0,'2025-12-06 04:29:06',NULL),(50,'{\"network\": \"e5f69a60-15c4-438f-9c59-671c43e59660\", \"cidr\": \"10.10.0.0/16\"}',0,'2025-12-06 04:29:07',NULL),(51,'{\"network\": \"c779bd81-3bbe-47e2-a683-dbba250402e4\", \"name\": \"trunk_sub_port_two\"}',0,'2025-12-06 04:29:07',NULL),(53,'{\"name\": \"test_trunk\", \"port\": \"c0d0ba86-25cf-40e3-a91a-6f2dde80943d\", \"sub_ports\": null}',0,'2025-12-06 04:29:08',NULL),(54,'{\"value\": \"Test1\"}',0,'2025-12-06 04:29:09',NULL),(55,'{\"value\": \"Test2\"}',0,'2025-12-06 04:29:09',NULL),(56,'{\"network\": \"e5f69a60-15c4-438f-9c59-671c43e59660\", \"name\": \"trunk_sub_port_one\"}',0,'2025-12-06 04:29:09',NULL),(57,'{\"network\": \"80c15e34-6b1a-4376-8a39-81b329aae54e\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.9\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-12-06 04:29:10',NULL),(58,'{\"context\": {\"region_name\": \"regionOne\"}, \"template\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}',0,'2025-12-06 04:29:11',NULL),(60,'{\"name\": \"test_trunk\", \"port\": \"c0d0ba86-25cf-40e3-a91a-6f2dde80943d\", \"sub_ports\": [{\"port\": \"7a3a13fd-e6c2-49ac-b1b1-720938360e30\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2025-12-06 04:29:17',NULL),(61,'{\"wait_secs\": 1, \"value\": \"test\"}',0,'2025-12-06 04:29:20',NULL),(62,'{\"network\": \"a5081f69-3a49-421b-a85d-cc3a4e934fbf\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-12-06 04:29:21',NULL),(65,'{\"network\": \"a5081f69-3a49-421b-a85d-cc3a4e934fbf\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": null, \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-12-06 04:29:28',NULL),(67,'{\"wait_secs\": 1, \"value\": \"test\"}',0,'2025-12-06 04:29:32',NULL),(68,'{\"context\": {\"region_name\": \"regionOne\"}, \"template\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}',0,'2025-12-06 04:29:32',NULL),(69,'{\"cidr\": \"10.0.0.0/16\", \"network\": \"9100ef72-d035-426a-81f7-e937ae98d3ed\"}',0,'2025-12-06 04:29:35',NULL),(70,'{\"cidr\": \"10.20.0.0/16\", \"network\": \"f94d8a47-757e-488a-a00a-2913455b40d7\"}',0,'2025-12-06 04:29:37',NULL),(71,'{\"cidr\": \"10.10.0.0/16\", \"network\": \"94d82ad2-c26e-4f23-9f27-89af726ef2e8\"}',0,'2025-12-06 04:29:38',NULL),(72,'{\"name\": \"trunk_parent_port\", \"network\": \"9100ef72-d035-426a-81f7-e937ae98d3ed\"}',0,'2025-12-06 04:29:38',NULL),(73,'{\"wait_secs\": 1, \"value\": \"next\"}',0,'2025-12-06 04:29:40',NULL),(74,'{\"name\": \"trunk_sub_port_two\", \"network\": \"f94d8a47-757e-488a-a00a-2913455b40d7\"}',0,'2025-12-06 04:29:40',NULL),(75,'{\"name\": \"trunk_sub_port_one\", \"network\": \"94d82ad2-c26e-4f23-9f27-89af726ef2e8\"}',0,'2025-12-06 04:29:41',NULL),(76,'{\"network\": \"f61a1657-cb93-405a-9870-0750081f667c\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-12-06 04:29:41',NULL),(77,'{\"name\": \"test_trunk\", \"port\": \"e0d2b829-65ef-44a0-9891-0a2dcf3923fe\", \"sub_ports\": [{\"port\": \"b79cbe40-4353-40db-9cac-10116b6d738e\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2025-12-06 04:29:43',NULL),(78,'{\"context\": {\"region_name\": \"regionOne\"}, \"template\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random2:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random2, value]}\\n\"}',0,'2025-12-06 04:29:43',NULL),(79,'{\"wait_secs\": 1, \"value\": \"none\"}',0,'2025-12-06 04:29:45',NULL),(81,'{\"value\": \"test1\", \"fail\": false, \"update_replace\": false, \"wait_secs\": 0}',0,'2025-12-06 04:29:52',NULL),(82,'{\"network\": \"f61a1657-cb93-405a-9870-0750081f667c\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\"}',0,'2025-12-06 04:29:52',NULL),(83,'{\"name\": \"test_trunk\", \"port\": \"e0d2b829-65ef-44a0-9891-0a2dcf3923fe\", \"sub_ports\": []}',0,'2025-12-06 04:29:53',NULL),(86,'{\"context\": {\"region_name\": \"regionOne\"}, \"parameters\": {\"name\": \"remote-nested\", \"network_name\": \"public\"}, \"template\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The intermediate stack (containing a local nested stack) to be instantiated\\\\nremotely in the remote deeply-nested stack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The public network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"network_stack_as_custom_type\\\": {\\\"type\\\": \\\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\\\", \\\"properties\\\": {\\\"name\\\": {\\\"get_param\\\": \\\"name\\\"}, \\\"network_name\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_attr\\\": [\\\"network_stack_as_custom_type\\\", \\\"router\\\"]}}}}\"}',0,'2025-12-06 04:29:56',NULL),(87,'{\"name\": \"remote-nested\", \"network_name\": \"public\"}',0,'2025-12-06 04:29:57',NULL),(88,'{\"name\": \"remote-nested-router\", \"external_gateway_info\": {\"network\": \"public\"}}',0,'2025-12-06 04:29:57',NULL),(90,'{\"value\": \"b\"}',0,'2025-12-06 04:30:02',NULL),(91,'{\"value\": \"a\"}',0,'2025-12-06 04:30:03',NULL),(92,'{\"network\": \"d8f5c5af-65be-42e7-846f-901285c31660\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-12-06 04:30:03',NULL),(94,'{\"cidr\": \"10.0.0.0/16\", \"network\": \"3626f49b-d25a-47bc-b0e6-67d1efcee15e\"}',0,'2025-12-06 04:30:10',NULL),(97,'{\"cidr\": \"10.10.0.0/16\", \"network\": \"6d4c3934-38d3-4d9d-b4c9-a99c3d909ed5\"}',0,'2025-12-06 04:30:11',NULL),(98,'{\"cidr\": \"10.20.0.0/16\", \"network\": \"20dd2613-44e6-4998-ab0a-e8f764b9da7a\"}',0,'2025-12-06 04:30:12',NULL),(99,'{\"name\": \"trunk_parent_port\", \"network\": \"3626f49b-d25a-47bc-b0e6-67d1efcee15e\"}',0,'2025-12-06 04:30:13',NULL),(100,'{\"name\": \"trunk_sub_port_two\", \"network\": \"20dd2613-44e6-4998-ab0a-e8f764b9da7a\"}',0,'2025-12-06 04:30:14',NULL),(101,'{\"network\": \"d8f5c5af-65be-42e7-846f-901285c31660\", \"cidr\": \"11.11.11.0/24\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2025-12-06 04:30:14',NULL),(102,'{\"name\": \"trunk_sub_port_one\", \"network\": \"6d4c3934-38d3-4d9d-b4c9-a99c3d909ed5\"}',0,'2025-12-06 04:30:15',NULL),(103,'{\"name\": \"test_trunk\", \"port\": \"824cc269-1e9b-4cbc-a946-131e5c0d4b52\", \"sub_ports\": [{\"port\": \"9cb8d158-a67c-4757-8b63-9804330f4266\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}, {\"port\": \"9d74a47d-55b6-45cf-bb76-83f78a7ff83d\", \"segmentation_id\": 20, \"segmentation_type\": \"vlan\"}]}',0,'2025-12-06 04:30:16',NULL),(105,'{\"value\": \"a\"}',0,'2025-12-06 04:30:17',NULL),(106,'{\"value\": \"b\"}',0,'2025-12-06 04:30:18',NULL),(107,'{\"name\": \"LUKS\"}',0,'2025-12-06 04:30:24',NULL),(108,'{\"provider\": \"nova.volume.encryptors.luks.LuksEncryptor\", \"control_location\": \"front-end\", \"cipher\": \"aes-xts-plain64\", \"key_size\": 512, \"volume_type\": \"6d432ce3-b478-4f23-b35d-eef894ccc524\"}',0,'2025-12-06 04:30:25',NULL),(109,'{\"name\": \"test_trunk\", \"port\": \"824cc269-1e9b-4cbc-a946-131e5c0d4b52\", \"sub_ports\": [{\"port\": \"9cb8d158-a67c-4757-8b63-9804330f4266\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2025-12-06 04:30:29',NULL),(110,'{\"value\": \"foo\"}',0,'2025-12-06 04:30:30',NULL),(111,'{\"value\": \"foo\"}',0,'2025-12-06 04:30:31',NULL),(112,'{\"provider\": \"nova.volume.encryptors.luks.LuksEncryptor\", \"control_location\": \"front-end\", \"cipher\": \"aes-cbc-essiv\", \"key_size\": 256, \"volume_type\": \"6d432ce3-b478-4f23-b35d-eef894ccc524\"}',0,'2025-12-06 04:30:31',NULL),(114,'{\"name\": \"the_net\"}',0,'2025-12-06 04:30:47',NULL),(115,'{\"name\": \"the_subnet\", \"network\": \"2237eb6d-3e36-4313-a59c-11790910609f\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-12-06 04:30:49',NULL),(116,'{\"update_replace\": false, \"wait_secs\": 0, \"value\": \"Test1\", \"fail\": false}',0,'2025-12-06 04:30:49',NULL),(117,'{\"cidr\": \"10.0.0.0/16\", \"network\": \"240ebf34-37fc-46fd-b18a-26c97d25bff1\"}',0,'2025-12-06 04:30:51',NULL),(118,'{\"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\", \"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"networks\": [{\"subnet\": \"b0dcf160-b51e-451c-b2ae-a8d3149f4a3a\"}]}',0,'2025-12-06 04:30:51',NULL),(119,'{\"cidr\": \"10.20.0.0/16\", \"network\": \"960af457-30ff-4e1d-8751-c5b69ce4cbb0\"}',0,'2025-12-06 04:30:51',NULL),(120,'{\"name\": \"trunk_parent_port\", \"network\": \"240ebf34-37fc-46fd-b18a-26c97d25bff1\"}',0,'2025-12-06 04:30:53',NULL),(121,'{\"cidr\": \"10.10.0.0/16\", \"network\": \"f1cc897d-b0f7-441e-87c1-bc21ce5fad5b\"}',0,'2025-12-06 04:30:53',NULL),(122,'{\"name\": \"trunk_sub_port_two\", \"network\": \"960af457-30ff-4e1d-8751-c5b69ce4cbb0\"}',0,'2025-12-06 04:30:54',NULL),(123,'{\"name\": \"trunk_sub_port_one\", \"network\": \"f1cc897d-b0f7-441e-87c1-bc21ce5fad5b\"}',0,'2025-12-06 04:30:56',NULL),(124,'{\"name\": \"test_trunk\", \"port\": \"e337482a-3064-431b-b6ad-1cdbbea8e499\", \"sub_ports\": [{\"port\": \"c0397dd1-a778-4ae2-8c92-4a263a3e7f1f\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2025-12-06 04:30:57',NULL),(125,'{\"name\": \"test_trunk\", \"port\": \"e337482a-3064-431b-b6ad-1cdbbea8e499\", \"sub_ports\": [{\"port\": \"c0397dd1-a778-4ae2-8c92-4a263a3e7f1f\", \"segmentation_id\": 99, \"segmentation_type\": \"vlan\"}]}',0,'2025-12-06 04:31:13',NULL),(128,'{\"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\", \"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"networks\": [{\"network\": \"2237eb6d-3e36-4313-a59c-11790910609f\", \"subnet\": \"b0dcf160-b51e-451c-b2ae-a8d3149f4a3a\"}]}',0,'2025-12-06 04:31:20',NULL),(130,'{\"network\": \"e0e6655f-2b27-4a53-a7be-e09568428231\", \"cidr\": \"10.0.0.0/16\"}',0,'2025-12-06 04:31:30',NULL),(131,'{\"network\": \"f1811a43-f9df-42b2-9450-8d36ac731210\", \"cidr\": \"10.20.0.0/16\"}',0,'2025-12-06 04:31:31',NULL),(132,'{\"network\": \"256b0bf6-7f6b-429c-83ce-04c6322c5ef3\", \"cidr\": \"10.10.0.0/16\"}',0,'2025-12-06 04:31:33',NULL),(133,'{\"network\": \"e0e6655f-2b27-4a53-a7be-e09568428231\", \"name\": \"trunk_parent_port\"}',0,'2025-12-06 04:31:35',NULL),(134,'{\"name\": \"the_net\"}',0,'2025-12-06 04:31:35',NULL),(135,'{\"network\": \"f1811a43-f9df-42b2-9450-8d36ac731210\", \"name\": \"trunk_sub_port_two\"}',0,'2025-12-06 04:31:35',NULL),(136,'{\"network\": \"256b0bf6-7f6b-429c-83ce-04c6322c5ef3\", \"name\": \"trunk_sub_port_one\"}',0,'2025-12-06 04:31:36',NULL),(137,'{\"name\": \"test_trunk\", \"port\": \"76807028-ffa3-4aa8-9fc7-109a2068d319\", \"sub_ports\": null}',0,'2025-12-06 04:31:36',NULL),(138,'{\"name\": \"the_subnet\", \"network\": \"9c133d0f-4804-41d4-80e5-5e7664269226\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-12-06 04:31:37',NULL),(139,'{\"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\", \"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"networks\": [{\"network\": \"9c133d0f-4804-41d4-80e5-5e7664269226\"}]}',0,'2025-12-06 04:31:38',NULL),(140,'{\"description\": \"This is a test trunk\", \"name\": \"pineapple\", \"port\": \"76807028-ffa3-4aa8-9fc7-109a2068d319\", \"sub_ports\": null}',0,'2025-12-06 04:31:46',NULL),(143,'{\"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\", \"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"networks\": [{\"network\": \"9c133d0f-4804-41d4-80e5-5e7664269226\", \"fixed_ip\": \"11.11.11.126\"}]}',0,'2025-12-06 04:32:09',NULL),(145,'{\"name\": \"the_net\"}',0,'2025-12-06 04:32:22',NULL),(146,'{\"name\": \"the_subnet\", \"network\": \"f13f304e-89e8-445e-b1aa-4e561c622773\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-12-06 04:32:23',NULL),(147,'{\"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\", \"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"networks\": [{\"network\": \"f13f304e-89e8-445e-b1aa-4e561c622773\"}]}',0,'2025-12-06 04:32:24',NULL),(149,'{\"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\", \"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"networks\": [{\"network\": \"f13f304e-89e8-445e-b1aa-4e561c622773\", \"subnet\": \"e0684a45-94d6-4841-bfd8-9416f384a41a\"}]}',0,'2025-12-06 04:32:53',NULL),(151,'{\"name\": \"the_net\"}',0,'2025-12-06 04:33:11',NULL),(152,'{\"name\": \"the_subnet\", \"network\": \"e6942e2a-91ce-4406-b56c-00342e7f460d\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-12-06 04:33:18',NULL),(153,'{\"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\", \"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"networks\": [{\"network\": \"e6942e2a-91ce-4406-b56c-00342e7f460d\"}, {\"network\": \"e6942e2a-91ce-4406-b56c-00342e7f460d\", \"fixed_ip\": \"11.11.11.33\"}, {\"subnet\": \"4ffb149f-a9e2-424a-98ec-8dc53f7e2a0a\"}]}',0,'2025-12-06 04:33:20',NULL),(154,'{\"count\": 1, \"resource_def\": {\"type\": \"OS::Heat::RandomString\"}}',0,'2025-12-06 04:33:52',NULL),(156,'{\"count\": 2, \"resource_def\": {\"type\": \"OS::Heat::RandomString\"}}',0,'2025-12-06 04:34:02',NULL),(157,'{\"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\", \"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"networks\": [{\"subnet\": \"4ffb149f-a9e2-424a-98ec-8dc53f7e2a0a\"}, {\"network\": \"e6942e2a-91ce-4406-b56c-00342e7f460d\"}, {\"network\": \"e6942e2a-91ce-4406-b56c-00342e7f460d\", \"subnet\": \"4ffb149f-a9e2-424a-98ec-8dc53f7e2a0a\"}]}',0,'2025-12-06 04:34:08',NULL),(159,'{\"length\": 10}',0,'2025-12-06 04:34:35',NULL),(160,'{\"name\": \"the_net\"}',0,'2025-12-06 04:34:36',NULL),(161,'{\"name\": \"the_subnet\", \"network\": \"1061a7b2-c8c3-40cb-b101-43753ec587e1\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-12-06 04:34:37',NULL),(162,'{\"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\", \"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"networks\": [{\"network\": \"1061a7b2-c8c3-40cb-b101-43753ec587e1\"}]}',0,'2025-12-06 04:34:39',NULL),(163,'{\"name\": \"server_with_port_net\"}',0,'2025-12-06 04:34:48',NULL),(164,'{\"network\": \"86f759c0-6534-4f0e-9aa3-8c17145066d4\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-12-06 04:34:50',NULL),(165,'{\"network\": \"86f759c0-6534-4f0e-9aa3-8c17145066d4\", \"fixed_ips\": [{\"subnet\": \"33841296-ad0e-434f-bf01-e6dfb872efdf\", \"ip_address\": \"11.11.11.11\"}]}',0,'2025-12-06 04:34:52',NULL),(166,'{\"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\", \"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"networks\": [{\"port\": \"44c3fcc3-062d-4f3f-b1b1-544a62a37987\"}]}',0,'2025-12-06 04:34:58',NULL),(168,'{\"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\", \"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"networks\": [{\"port\": \"0b6a3af3-3c90-4029-86ce-5719d311260d\"}]}',0,'2025-12-06 04:35:13',NULL),(170,'{\"name\": \"the_net\"}',0,'2025-12-06 04:35:33',NULL),(171,'{\"name\": \"the_subnet\", \"network\": \"71e87c16-d80f-449e-b69a-6d1d1bb8e53b\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-12-06 04:35:34',NULL),(172,'{\"name\": \"the_sg\", \"description\": \"Ping and SSH\", \"rules\": [{\"protocol\": \"icmp\"}, {\"protocol\": \"tcp\", \"port_range_min\": 22, \"port_range_max\": 22}]}',0,'2025-12-06 04:35:35',NULL),(173,'{\"name\": \"my_net\"}',0,'2025-12-06 04:35:36',NULL),(174,'{\"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\", \"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"networks\": [{\"network\": \"71e87c16-d80f-449e-b69a-6d1d1bb8e53b\"}]}',0,'2025-12-06 04:35:36',NULL),(175,'{\"network\": \"1a55605b-726b-49cd-9c85-c3162017eb87\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-12-06 04:35:36',NULL),(176,'{\"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\", \"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"networks\": [{\"subnet\": \"2b4e0e66-463f-4bf6-a637-e97d5f6323fe\", \"fixed_ip\": \"11.11.11.11\"}], \"security_groups\": [\"a71c4598-ef72-4a68-a8c5-879c3450f193\"]}',0,'2025-12-06 04:35:40',NULL),(178,'{\"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\", \"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"networks\": [{\"subnet\": \"c8f52e5f-fa50-42e5-8238-43fa114fee47\"}]}',0,'2025-12-06 04:36:10',NULL),(181,'{\"name\": \"the_net\"}',0,'2025-12-06 04:36:22',NULL),(182,'{\"network\": \"4239dcbd-d6c3-426b-843a-295a3ed880d1\", \"cidr\": \"12.12.12.0/24\", \"name\": \"subnet_b\"}',0,'2025-12-06 04:36:23',NULL),(183,'{\"network\": \"4239dcbd-d6c3-426b-843a-295a3ed880d1\", \"cidr\": \"11.11.11.0/24\", \"name\": \"subnet_a\"}',0,'2025-12-06 04:36:23',NULL),(184,'{\"name\": \"the_net\"}',0,'2025-12-06 04:36:24',NULL),(185,'{\"name\": \"the_subnet\", \"network\": \"fb6b677c-1569-42bb-993c-ea78451aefe3\", \"cidr\": \"11.11.11.0/24\"}',0,'2025-12-06 04:36:31',NULL),(186,'{\"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\", \"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"networks\": [{\"subnet\": \"88c33f60-89f1-4a43-ba8d-d2830eaa6d99\"}]}',0,'2025-12-06 04:36:31',NULL),(187,'{\"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\", \"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"networks\": [{\"subnet\": \"2cc5353b-f3fe-4f03-b159-e7043638a9f5\"}]}',0,'2025-12-06 04:36:35',NULL),(190,'{\"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\", \"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"networks\": [{\"network\": \"fb6b677c-1569-42bb-993c-ea78451aefe3\"}]}',0,'2025-12-06 04:37:05',NULL),(192,'{\"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\", \"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"networks\": [{\"subnet\": \"579ac940-890f-4384-b6e7-0dc18af11849\"}]}',0,'2025-12-06 04:37:13',NULL),(193,'{\"length\": 10}',0,'2025-12-06 04:37:18',NULL),(195,'{\"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\", \"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"user_data_format\": \"SOFTWARE_CONFIG\", \"networks\": [{\"network\": \"heat_tempestconf_network\"}]}',0,'2025-12-06 04:37:31',NULL),(196,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2025-12-06 04:37:53',NULL),(197,'{\"config\": \"ae7968e6-dcd9-4ee4-9e1d-d1f5cbbbf5a3\", \"servers\": {\"0\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}}',0,'2025-12-06 04:37:53',NULL),(198,'{\"config\": \"ae7968e6-dcd9-4ee4-9e1d-d1f5cbbbf5a3\", \"servers\": {\"0\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}}',0,'2025-12-06 04:37:53',NULL),(199,'{\"config\": \"ae7968e6-dcd9-4ee4-9e1d-d1f5cbbbf5a3\", \"servers\": {\"0\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}}',0,'2025-12-06 04:37:53',NULL),(200,'{\"config\": \"ae7968e6-dcd9-4ee4-9e1d-d1f5cbbbf5a3\", \"servers\": {\"0\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}}',0,'2025-12-06 04:37:53',NULL),(201,'{\"config\": \"ae7968e6-dcd9-4ee4-9e1d-d1f5cbbbf5a3\", \"servers\": {\"0\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}}',0,'2025-12-06 04:37:53',NULL),(202,'{\"config\": \"ae7968e6-dcd9-4ee4-9e1d-d1f5cbbbf5a3\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}',0,'2025-12-06 04:37:54',NULL),(203,'{\"config\": \"ae7968e6-dcd9-4ee4-9e1d-d1f5cbbbf5a3\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}',0,'2025-12-06 04:37:54',NULL),(204,'{\"config\": \"ae7968e6-dcd9-4ee4-9e1d-d1f5cbbbf5a3\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}',0,'2025-12-06 04:37:54',NULL),(205,'{\"config\": \"ae7968e6-dcd9-4ee4-9e1d-d1f5cbbbf5a3\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}',0,'2025-12-06 04:37:54',NULL),(206,'{\"config\": \"ae7968e6-dcd9-4ee4-9e1d-d1f5cbbbf5a3\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}',0,'2025-12-06 04:37:54',NULL),(207,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2025-12-06 04:37:54',NULL),(208,'{\"config\": \"ec676521-0249-4ea4-a897-c3b08bf881d0\", \"servers\": {\"0\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}}',0,'2025-12-06 04:37:54',NULL),(209,'{\"config\": \"ec676521-0249-4ea4-a897-c3b08bf881d0\", \"servers\": {\"0\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}}',0,'2025-12-06 04:37:54',NULL),(210,'{\"config\": \"ec676521-0249-4ea4-a897-c3b08bf881d0\", \"servers\": {\"0\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}}',0,'2025-12-06 04:37:54',NULL),(211,'{\"config\": \"ec676521-0249-4ea4-a897-c3b08bf881d0\", \"servers\": {\"0\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}}',0,'2025-12-06 04:37:54',NULL),(212,'{\"config\": \"ec676521-0249-4ea4-a897-c3b08bf881d0\", \"servers\": {\"0\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}}',0,'2025-12-06 04:37:54',NULL),(213,'{\"config\": \"ec676521-0249-4ea4-a897-c3b08bf881d0\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}',0,'2025-12-06 04:37:54',NULL),(214,'{\"config\": \"ec676521-0249-4ea4-a897-c3b08bf881d0\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}',0,'2025-12-06 04:37:54',NULL),(215,'{\"config\": \"ec676521-0249-4ea4-a897-c3b08bf881d0\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}',0,'2025-12-06 04:37:54',NULL),(216,'{\"config\": \"ec676521-0249-4ea4-a897-c3b08bf881d0\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}',0,'2025-12-06 04:37:54',NULL),(217,'{\"config\": \"ec676521-0249-4ea4-a897-c3b08bf881d0\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}',0,'2025-12-06 04:37:54',NULL),(218,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2025-12-06 04:38:02',NULL),(219,'{\"config\": \"acaaf735-bd9e-4a52-83f9-5890ced4a443\", \"servers\": {\"0\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}}',0,'2025-12-06 04:38:02',NULL),(220,'{\"config\": \"acaaf735-bd9e-4a52-83f9-5890ced4a443\", \"servers\": {\"0\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}}',0,'2025-12-06 04:38:02',NULL),(221,'{\"config\": \"acaaf735-bd9e-4a52-83f9-5890ced4a443\", \"servers\": {\"0\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}}',0,'2025-12-06 04:38:02',NULL),(222,'{\"config\": \"acaaf735-bd9e-4a52-83f9-5890ced4a443\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}',0,'2025-12-06 04:38:02',NULL),(223,'{\"config\": \"acaaf735-bd9e-4a52-83f9-5890ced4a443\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}',0,'2025-12-06 04:38:02',NULL),(224,'{\"config\": \"acaaf735-bd9e-4a52-83f9-5890ced4a443\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}',0,'2025-12-06 04:38:02',NULL),(225,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2025-12-06 04:38:04',NULL),(226,'{\"config\": \"e5c33846-8b92-40fc-8098-1b9140dbd9f0\", \"servers\": {\"0\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}}',0,'2025-12-06 04:38:04',NULL),(227,'{\"config\": \"e5c33846-8b92-40fc-8098-1b9140dbd9f0\", \"servers\": {\"0\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}}',0,'2025-12-06 04:38:04',NULL),(228,'{\"config\": \"e5c33846-8b92-40fc-8098-1b9140dbd9f0\", \"servers\": {\"0\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}}',0,'2025-12-06 04:38:04',NULL),(229,'{\"config\": \"e5c33846-8b92-40fc-8098-1b9140dbd9f0\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}',0,'2025-12-06 04:38:04',NULL),(230,'{\"config\": \"e5c33846-8b92-40fc-8098-1b9140dbd9f0\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}',0,'2025-12-06 04:38:04',NULL),(231,'{\"config\": \"e5c33846-8b92-40fc-8098-1b9140dbd9f0\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}',0,'2025-12-06 04:38:04',NULL),(232,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2025-12-06 04:38:05',NULL),(233,'{\"config\": \"b20d1fd1-2bd2-48cf-a825-309052cf9ccb\", \"servers\": {\"0\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}}',0,'2025-12-06 04:38:08',NULL),(234,'{\"config\": \"b20d1fd1-2bd2-48cf-a825-309052cf9ccb\", \"servers\": {\"0\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}}',0,'2025-12-06 04:38:08',NULL),(235,'{\"config\": \"b20d1fd1-2bd2-48cf-a825-309052cf9ccb\", \"servers\": {\"0\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}}',0,'2025-12-06 04:38:08',NULL),(236,'{\"config\": \"b20d1fd1-2bd2-48cf-a825-309052cf9ccb\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}',0,'2025-12-06 04:38:09',NULL),(237,'{\"config\": \"b20d1fd1-2bd2-48cf-a825-309052cf9ccb\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}',0,'2025-12-06 04:38:09',NULL),(238,'{\"config\": \"b20d1fd1-2bd2-48cf-a825-309052cf9ccb\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"70ab76f9-c1b0-4a03-972f-cab7cba5a2f5\"}',0,'2025-12-06 04:38:09',NULL),(239,'{\"image\": \"ede6ef04-46ef-4488-927c-727b57ffc18f\", \"flavor\": \"74974162-824a-46b7-81c6-1d47fc1b190d\", \"user_data_format\": \"SOFTWARE_CONFIG\", \"networks\": [{\"network\": \"heat_tempestconf_network\"}]}',0,'2025-12-06 04:39:59',NULL),(240,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2025-12-06 04:40:15',NULL),(241,'{\"config\": \"a2bf6543-68d4-45b2-8c5f-a902fc3582ec\", \"servers\": {\"0\": \"446987cb-d72d-4631-8ce6-2da7b3951475\"}}',0,'2025-12-06 04:40:15',NULL),(242,'{\"config\": \"a2bf6543-68d4-45b2-8c5f-a902fc3582ec\", \"servers\": {\"0\": \"446987cb-d72d-4631-8ce6-2da7b3951475\"}}',0,'2025-12-06 04:40:15',NULL),(243,'{\"config\": \"a2bf6543-68d4-45b2-8c5f-a902fc3582ec\", \"servers\": {\"0\": \"446987cb-d72d-4631-8ce6-2da7b3951475\"}}',0,'2025-12-06 04:40:15',NULL),(244,'{\"config\": \"a2bf6543-68d4-45b2-8c5f-a902fc3582ec\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"446987cb-d72d-4631-8ce6-2da7b3951475\"}',0,'2025-12-06 04:40:15',NULL),(245,'{\"config\": \"a2bf6543-68d4-45b2-8c5f-a902fc3582ec\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"446987cb-d72d-4631-8ce6-2da7b3951475\"}',0,'2025-12-06 04:40:15',NULL),(246,'{\"config\": \"a2bf6543-68d4-45b2-8c5f-a902fc3582ec\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"446987cb-d72d-4631-8ce6-2da7b3951475\"}',0,'2025-12-06 04:40:15',NULL);
/*!40000 ALTER TABLE `resource_properties_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(36) NOT NULL,
  `engine_id` varchar(36) NOT NULL,
  `host` varchar(255) NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `topic` varchar(255) NOT NULL,
  `report_interval` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `engine_id`, `host`, `hostname`, `binary`, `topic`, `report_interval`, `created_at`, `updated_at`, `deleted_at`) VALUES ('07b7275a-e769-4027-af37-0dcb9b48deb9','235028cf-6004-4ff3-b7a8-49ab053e8c8d','heat-engine-55fc64bfdd-779rm','heat-engine-55fc64bfdd-779rm','heat-engine','engine',60,'2025-12-06 04:00:10','2025-12-06 04:54:11',NULL),('093f460e-006f-46b2-9eb9-8cee25b8bd36','48818b1d-0e53-46b1-b2f7-92b689a9865e','heat-engine-5d96658447-rg8zs','heat-engine-5d96658447-rg8zs','heat-engine','engine',60,'2025-12-06 04:00:10','2025-12-06 04:00:33','2025-12-06 04:00:33'),('0f69cf9b-67f9-409a-b51b-55b72697cc2f','3517dcab-c19b-4e38-b548-89858cdaaa34','heat-engine-5d96658447-rg8zs','heat-engine-5d96658447-rg8zs','heat-engine','engine',60,'2025-12-06 04:00:10','2025-12-06 04:00:39','2025-12-06 04:00:39'),('4b43df34-c366-4604-ac4b-b79a3bc610f3','6128620b-72be-4d96-86b8-a99f87b77a5e','heat-engine-5d96658447-rg8zs','heat-engine-5d96658447-rg8zs','heat-engine','engine',60,'2025-12-06 04:00:10','2025-12-06 04:00:39','2025-12-06 04:00:39'),('5229492a-0627-401c-b6c8-4751d375fcb0','85e258c7-214e-4848-9c79-86dcadf831ee','heat-engine-55fc64bfdd-779rm','heat-engine-55fc64bfdd-779rm','heat-engine','engine',60,'2025-12-06 04:00:10','2025-12-06 04:54:11',NULL),('c531ee12-3e53-4572-8294-6c0e641c1590','cf6a66ab-2d31-4c82-b5f0-a4b7d0a27e6f','heat-engine-55fc64bfdd-779rm','heat-engine-55fc64bfdd-779rm','heat-engine','engine',60,'2025-12-06 04:00:10','2025-12-06 04:54:11',NULL),('e050083c-a90e-42d0-b3a3-a88d2e5d966f','c4f52c93-4064-4741-a413-db794785f3ad','heat-engine-55fc64bfdd-779rm','heat-engine-55fc64bfdd-779rm','heat-engine','engine',60,'2025-12-06 04:00:10','2025-12-06 04:54:11',NULL),('f7b8ff3b-3ab0-496b-a9d0-794c3062b30d','dfdf5dc4-b368-446c-84c0-070e9cc192dd','heat-engine-5d96658447-rg8zs','heat-engine-5d96658447-rg8zs','heat-engine','engine',60,'2025-12-06 04:00:10','2025-12-06 04:00:33','2025-12-06 04:00:33');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot`
--

DROP TABLE IF EXISTS `snapshot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot` (
  `id` varchar(36) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` varchar(255) DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  KEY `ix_snapshot_tenant` (`tenant`),
  CONSTRAINT `snapshot_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot`
--

LOCK TABLES `snapshot` WRITE;
/*!40000 ALTER TABLE `snapshot` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_config`
--

DROP TABLE IF EXISTS `software_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_config` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `group` varchar(255) DEFAULT NULL,
  `config` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_software_config_tenant` (`tenant`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_config`
--

LOCK TABLES `software_config` WRITE;
/*!40000 ALTER TABLE `software_config` DISABLE KEYS */;
INSERT INTO `software_config` (`id`, `created_at`, `updated_at`, `name`, `group`, `config`, `tenant`) VALUES ('3f9ee17a-d490-438b-9751-2cb75abed4b4','2025-12-06 04:28:17',NULL,'api-2090761251-config','script','{\"inputs\": [], \"outputs\": [], \"options\": {}, \"config\": \"#!/bin/sh -x\\\\necho hello\"}','6e6af296d1254d4db17b6afe1ddf3c4e'),('b6663aaf-fbd9-4da2-b0f6-da5d5b7ec63d','2025-12-06 04:28:18',NULL,'api-234010157-config','script','{\"inputs\": [], \"outputs\": [], \"options\": {}, \"config\": \"#!/bin/sh -x\\\\necho hello\"}','6e6af296d1254d4db17b6afe1ddf3c4e');
/*!40000 ALTER TABLE `software_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_deployment`
--

DROP TABLE IF EXISTS `software_deployment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_deployment` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `server_id` varchar(36) NOT NULL,
  `config_id` varchar(36) NOT NULL,
  `input_values` longtext DEFAULT NULL,
  `output_values` longtext DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `config_id` (`config_id`),
  KEY `ix_software_deployment_server_id` (`server_id`),
  KEY `ix_software_deployment_created_at` (`created_at`),
  KEY `ix_software_deployment_tenant` (`tenant`),
  CONSTRAINT `software_deployment_ibfk_1` FOREIGN KEY (`config_id`) REFERENCES `software_config` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_deployment`
--

LOCK TABLES `software_deployment` WRITE;
/*!40000 ALTER TABLE `software_deployment` DISABLE KEYS */;
INSERT INTO `software_deployment` (`id`, `created_at`, `updated_at`, `server_id`, `config_id`, `input_values`, `output_values`, `action`, `status`, `status_reason`, `tenant`, `stack_user_project_id`) VALUES ('ecf75ac1-1ca2-485c-8862-4fe5e7d12176','2025-12-06 04:28:18','2025-12-06 04:28:19','dummy_server','b6663aaf-fbd9-4da2-b0f6-da5d5b7ec63d','{}','null','ACTION1','COMPLETE','completed','6e6af296d1254d4db17b6afe1ddf3c4e',NULL);
/*!40000 ALTER TABLE `software_deployment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack`
--

DROP TABLE IF EXISTS `stack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `raw_template_id` int(11) NOT NULL,
  `prev_raw_template_id` int(11) DEFAULT NULL,
  `user_creds_id` int(11) DEFAULT NULL,
  `username` varchar(256) DEFAULT NULL,
  `owner_id` varchar(36) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `timeout` int(11) DEFAULT NULL,
  `tenant` varchar(256) DEFAULT NULL,
  `disable_rollback` tinyint(1) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  `backup` tinyint(1) DEFAULT NULL,
  `nested_depth` int(11) DEFAULT NULL,
  `convergence` tinyint(1) DEFAULT NULL,
  `current_traversal` varchar(36) DEFAULT NULL,
  `current_deps` longtext DEFAULT NULL,
  `parent_resource_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_template_id` (`raw_template_id`),
  KEY `prev_raw_template_id` (`prev_raw_template_id`),
  KEY `user_creds_id` (`user_creds_id`),
  KEY `ix_stack_tenant` (`tenant`(255)),
  KEY `ix_stack_owner_id` (`owner_id`),
  KEY `ix_stack_name` (`name`),
  CONSTRAINT `stack_ibfk_1` FOREIGN KEY (`raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_2` FOREIGN KEY (`prev_raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_3` FOREIGN KEY (`user_creds_id`) REFERENCES `user_creds` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack`
--

LOCK TABLES `stack` WRITE;
/*!40000 ALTER TABLE `stack` DISABLE KEYS */;
INSERT INTO `stack` (`id`, `created_at`, `updated_at`, `deleted_at`, `name`, `raw_template_id`, `prev_raw_template_id`, `user_creds_id`, `username`, `owner_id`, `action`, `status`, `status_reason`, `timeout`, `tenant`, `disable_rollback`, `stack_user_project_id`, `backup`, `nested_depth`, `convergence`, `current_traversal`, `current_deps`, `parent_resource_name`) VALUES ('006ba657-ef38-4f76-8a80-dc885566b284','2025-12-06 04:29:32','2025-12-06 04:29:45','2025-12-06 04:29:46','RemoteStackTest-341818267',72,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'77733d9e821a42fab8046b9fbe8a891e',0,0,1,'375aeb6b-04fe-4949-9bcd-3701ff0c13ce','{\"edges\": [[[57, false], null]]}',NULL),('03ba8d57-c0c6-4dd7-9ace-a80f1497e1f4','2025-12-06 04:37:54','2025-12-06 04:39:33','2025-12-06 04:39:34','ParallelDeploymentsTest-796190467-dep_1-dixzb6ouqerb',219,NULL,NULL,'demo_tempestconf','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'606c462d29e444b0a98779507e12617e',0,1,1,'65de3a42-1cc9-457d-9004-c016967b6330','{\"edges\": [[[185, false], null]]}','dep_1'),('08a33720-ff62-440e-9d6a-2d0217dbf6d4','2025-12-06 04:32:11','2025-12-06 04:32:18','2025-12-06 04:32:19','ExternalReferencesTest-1355638834',125,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'3afa9170874a419db20317e8ec0bbf8d',0,0,1,'ed4dbc08-b905-4b8b-aab4-b92b1b712787','{\"edges\": [[[125, false], null]]}',NULL),('093cb3c6-d376-4f93-bc88-6137e9055c81','2025-12-06 04:40:15','2025-12-06 04:41:20','2025-12-06 04:41:21','ParallelDeploymentsTest-1855891113-dep_1-yl2aejpg6ypz',229,NULL,NULL,'demo_tempestconf','0c199995-f685-4cda-9487-b9fba4bd651f','DELETE','COMPLETE','Stack DELETE completed successfully',1,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'67457a2eb8414a54b5a281fbdb8f5b69',0,1,1,'2fa456f4-448c-4aea-8f94-6e0d08b8d3a3','{\"edges\": [[[225, false], null]]}','dep_1'),('0bd141bc-a2b7-40be-8e8e-5db3ef2c7195','2025-12-06 04:30:24','2025-12-06 04:30:38','2025-12-06 04:30:40','EncryptionVolTypeTest-674294388',106,NULL,NULL,'admin',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'f55bbeaa267a4053ad08ac9d81c50699',1,'bf6478ad7d4846e59b81bde55da8cdbe',0,0,1,'37047d8d-05ca-4857-a9b7-b226cb3f6a68','{\"edges\": [[[94, false], [93, false]]]}',NULL),('0c199995-f685-4cda-9487-b9fba4bd651f','2025-12-06 04:40:14','2025-12-06 04:41:20','2025-12-06 04:41:31','ParallelDeploymentsTest-1855891113',228,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'67457a2eb8414a54b5a281fbdb8f5b69',0,0,1,'dac1f133-7ff3-4248-b86c-e71678606136','{\"edges\": [[[223, false], [221, false]], [[223, false], [222, false]], [[223, false], [220, false]]]}',NULL),('1326e81d-c775-44e9-b704-3d4b41a91f89','2025-12-06 04:37:53','2025-12-06 04:39:15','2025-12-06 04:39:27','ParallelDeploymentsTest-1287797711',210,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'fd07bc18cb5640118b2195fbb4e80aa5',0,0,1,'034452ef-069c-41ac-9b47-19346651aca7','{\"edges\": [[[192, false], [188, false]], [[192, false], [189, false]], [[192, false], [190, false]], [[192, false], [187, false]], [[192, false], [191, false]]]}',NULL),('17563277-94b3-481a-94c9-7d378cdc194b','2025-12-06 04:29:01','2025-12-06 04:29:02','2025-12-06 04:29:03','ResourcesList-1956950835',45,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'fd68d46d8524440b8de6b3d8ad72f679',0,0,1,'5b01619e-122f-479a-b4c4-4d031de14c72','{\"edges\": [[[36, false], [35, false]]]}',NULL),('20dba6b3-a438-4e44-b1cf-2ea639dfe547','2025-12-06 04:28:18','2025-12-06 04:28:19','2025-12-06 04:28:20','api-177751087-empty',8,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'dc9f9973fa58454bb04e746d4142882c',0,0,1,'a70d33d4-2853-4bbe-8e73-8856cd3c1dd4','{\"edges\": []}',NULL),('237b0453-1901-423d-a107-e08a79190113','2025-12-06 04:40:15','2025-12-06 04:41:22','2025-12-06 04:41:25','ParallelDeploymentsTest-1855891113-dep_0-fpvlnauhtbx7',231,NULL,NULL,'demo_tempestconf','0c199995-f685-4cda-9487-b9fba4bd651f','DELETE','COMPLETE','Stack DELETE completed successfully',1,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'67457a2eb8414a54b5a281fbdb8f5b69',0,1,1,'7a74ee5f-c409-44a7-bb97-fc1c6a0863e5','{\"edges\": [[[224, false], null]]}','dep_0'),('24398c00-fc29-4ccb-984e-76303f40d27a','2025-12-06 04:30:01','2025-12-06 04:30:11','2025-12-06 04:30:15','StackOutputsTest-1139037893',93,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'f7896b49b83f4d19be01d409dd8cd807',0,0,1,'146ac9a9-a8e9-4735-8a5d-15e68c2c6100','{\"edges\": [[[76, false], null]]}',NULL),('29f1f4a3-9cba-41c1-8c7e-e84dff6d00f8','2025-12-06 04:38:09','2025-12-06 04:38:41','2025-12-06 04:38:42','ParallelDeploymentsTest-1080007079-dep_2-ocodvce77vfp',200,NULL,NULL,'demo_tempestconf','8bb330dc-64fc-4131-8131-786ce5a2c07f','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'62b6e624e978476b9ae90e1f23dc4de2',0,1,1,'508f35ac-7f70-4f2e-995f-0da4d4a7a588','{\"edges\": [[[218, false], null]]}','dep_2'),('2e238c19-c25b-4d43-bdb7-6a7015fc9473','2025-12-06 04:33:00','2025-12-06 04:33:18','2025-12-06 04:33:18','HooksTest-440720371-nested-6sw3rfzcclkw',138,NULL,NULL,'demo_tempestconf','7e7aef01-9063-4dfe-b1e6-878cf42ae5c2','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'cadba49bb71d48589daa535f8591651e',0,1,1,'ddce0513-463b-47d1-b4d8-840eed51ecf0','{\"edges\": [[[135, false], [134, false]], [[136, false], [135, false]]]}','nested'),('2e8e9785-0960-4726-bf75-0356744490b8','2025-12-06 04:38:04','2025-12-06 04:38:49','2025-12-06 04:38:50','ParallelDeploymentsTest-1700023022-dep_2-o65vs4l6xhe4',203,NULL,NULL,'demo_tempestconf','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'deb0bfc687544457bed312d11ded3274',0,1,1,'f45c2507-c165-4022-af8b-5ab5147f4db9','{\"edges\": [[[210, false], null]]}','dep_2'),('2f038ab6-0913-4deb-8e67-6f13fb08bcd5','2025-12-06 04:38:09','2025-12-06 04:38:42','2025-12-06 04:38:43','ParallelDeploymentsTest-1080007079-dep_0-o4by3xv37yjg',201,NULL,NULL,'demo_tempestconf','8bb330dc-64fc-4131-8131-786ce5a2c07f','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'62b6e624e978476b9ae90e1f23dc4de2',0,1,1,'e97839ed-5131-4220-803a-a68ef449499b','{\"edges\": [[[217, false], null]]}','dep_0'),('32a9ef71-f427-412b-a14f-1110064ee79f','2025-12-06 04:37:53','2025-12-06 04:39:34','2025-12-06 04:39:35','ParallelDeploymentsTest-796190467-dep_3-w4rpny2hfutm',220,NULL,NULL,'demo_tempestconf','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'606c462d29e444b0a98779507e12617e',0,1,1,'55eb1553-4306-4307-a9ce-8e13be640440','{\"edges\": [[[183, false], null]]}','dep_3'),('33729b66-d857-494a-b152-a364ad25ff94','2025-12-06 04:37:30','2025-12-06 04:39:45','2025-12-06 04:39:53','ParallelDeploymentsTest-2056388355',222,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'3653f54cdb694b028ec89c2d004e9f1c',0,0,1,'ce2493e5-8d9b-4057-9452-9c4ad14f6958','{\"edges\": [[[175, false], null]]}',NULL),('35d328f4-ee7e-4f36-9525-a4caf1efdee2','2025-12-06 04:38:02','2025-12-06 04:39:00','2025-12-06 04:39:01','ParallelDeploymentsTest-1504859677-dep_2-wadsndhsuxa6',208,NULL,NULL,'demo_tempestconf','fa4f95c2-2ec3-4000-9201-2fcb3780307f','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'e22012781c7e4932b0fa8c673ce7c0ce',0,1,1,'457ce660-c20d-4884-970b-46fcf50d78ae','{\"edges\": [[[203, false], null]]}','dep_2'),('3639c451-9460-4022-b93b-4d6a1e5c83f5','2025-12-06 04:29:19','2025-12-06 04:29:25','2025-12-06 04:29:28','StackTagTest-10561977',58,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'9bcbeff2790c4bf9b847bea716c7951f',0,0,1,'16beea43-05da-41b9-b66d-12396dd771c1','{\"edges\": [[[53, false], null]]}',NULL),('38571d71-c8bd-437e-8699-b48e38e95263','2025-12-06 04:33:10','2025-12-06 04:34:14','2025-12-06 04:34:32','multi_networks_swaps',150,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'8051cbd712eb4a05869e09e468a8c9e9',0,0,1,'beb1d193-d717-486e-9204-ec0b2a89f22e','{\"edges\": [[[139, false], [137, false]], [[139, false], [138, false]], [[138, false], [137, false]]]}',NULL),('3bc956e1-b959-4986-b7dc-f9769960ec42','2025-12-06 04:29:12','2025-12-06 04:29:26','2025-12-06 04:29:27','RemoteStackTest-1623916689-my_stack-p7ahpjpey6bm',60,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'10e1f1944f044204985a5ff953ee22d5',0,0,1,'f701de5d-3e7d-497c-9424-635dd7f5471a','{\"edges\": [[[52, false], null]]}',NULL),('3da796f8-a8d2-48f6-94d6-873a981aacdd','2025-12-06 04:38:04','2025-12-06 04:38:50','2025-12-06 04:38:51','ParallelDeploymentsTest-1700023022-dep_0-rq2d722x4sgq',204,NULL,NULL,'demo_tempestconf','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'deb0bfc687544457bed312d11ded3274',0,1,1,'9881060a-b476-48dc-8b6b-53ee776fea92','{\"edges\": [[[209, false], null]]}','dep_0'),('40a720fe-4d5b-4614-97b6-f6c7da13689f','2025-12-06 04:37:54','2025-12-06 04:39:17','2025-12-06 04:39:18','ParallelDeploymentsTest-1287797711-dep_3-itd463qzrk6l',213,NULL,NULL,'demo_tempestconf','1326e81d-c775-44e9-b704-3d4b41a91f89','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'fd07bc18cb5640118b2195fbb4e80aa5',0,1,1,'15255d92-131e-42b9-8a2b-c66850524c31','{\"edges\": [[[193, false], null]]}','dep_3'),('47323972-a587-4706-9100-a462afe54eb2','2025-12-06 04:28:21','2025-12-06 04:28:22','2025-12-06 04:28:23','api-229566953-empty',15,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'ded32b15c66a485c8cd3e10041d242e0',0,0,1,'4cd38f13-a049-40f2-8a81-e4bc303b0280','{\"edges\": []}',NULL),('4c151c7c-65f0-478c-94a5-1cb8b8640e48','2025-12-06 04:29:57','2025-12-06 04:30:07','2025-12-06 04:30:08','RemoteDeeplyNestedStackTest-2039546384-network_stack-tuxceswutxbo-network_stack_as_custom_type-gfwarkw5z52h',91,NULL,NULL,'demo_tempestconf','a77182a5-55df-4c8f-88f7-4c1d5323fbeb','DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'e9f10b8c706d4780ab65ac935548e5a3',0,1,1,'00186482-c2b9-4a74-909b-91227c3396b6','{\"edges\": [[[75, false], null]]}','network_stack_as_custom_type'),('4c1b238e-4e21-4355-9f20-402770b3e07b','2025-12-06 04:32:22','2025-12-06 04:33:00','2025-12-06 04:33:04','add_subnet',135,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'ab1a57e13135494988cae112b3128095',0,0,1,'e6466abc-4974-46d0-80c2-8f1aebf3dc42','{\"edges\": [[[128, false], [126, false]], [[128, false], [127, false]], [[127, false], [126, false]]]}',NULL),('58698bb5-a1f2-4361-bfd2-aaeeed077d93','2025-12-06 04:40:15','2025-12-06 04:41:21','2025-12-06 04:41:23','ParallelDeploymentsTest-1855891113-dep_2-xvi4ebuumjew',230,NULL,NULL,'demo_tempestconf','0c199995-f685-4cda-9487-b9fba4bd651f','DELETE','COMPLETE','Stack DELETE completed successfully',1,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'67457a2eb8414a54b5a281fbdb8f5b69',0,1,1,'ac7b3180-0153-4b28-a636-5b92078e96f7','{\"edges\": [[[226, false], null]]}','dep_2'),('5959fd78-7790-4543-84a2-60452176a852','2025-12-06 04:37:53','2025-12-06 04:39:31','2025-12-06 04:39:33','ParallelDeploymentsTest-796190467-dep_2-m4j3rhy5x3sh',217,NULL,NULL,'demo_tempestconf','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'606c462d29e444b0a98779507e12617e',0,1,1,'2b992f28-8b9b-4951-af9a-626309421aab','{\"edges\": [[[184, false], null]]}','dep_2'),('5e2f4b12-cda8-4324-abbe-a55ed8ab1ee1','2025-12-06 04:34:10','2025-12-06 04:34:19','2025-12-06 04:34:20','HooksTest-669160053',151,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'57a4130282cb45b79343c68419c7eab3',0,0,1,'01f4f2fa-070a-4f48-ab92-f9f1049d18f9','{\"edges\": [[[147, false], [146, false]], [[148, false], [147, false]]]}',NULL),('5f8530d7-414e-4281-99ed-a0421078a053','2025-12-06 04:28:14','2025-12-06 04:28:16','2025-12-06 04:28:18','api-234010157-rsrcstack',6,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'d2dda6d2484940bca885329bc0457948',0,0,1,'fd8e0853-ef06-44bf-b938-6617a5ec9a4d','{\"edges\": [[[2, false], null]]}',NULL),('65323099-7274-4625-8062-8976b050a5e9','2025-12-06 04:30:49','2025-12-06 04:30:50','2025-12-06 04:30:51','TemplateAPITest-182259896',110,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'cae14dda15d241f08415e0a7b45f7110',0,0,1,'942d64fa-eb7f-438b-9c01-a95b81afc9be','{\"edges\": [[[110, false], null]]}',NULL),('6ad69760-d81b-4153-a8cf-d75a571a76ee','2025-12-06 04:29:51','2025-12-06 04:29:56','2025-12-06 04:29:56','StackEventsTest-347241810',80,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'1e7f905b91674522bea58778674efadd',0,0,1,'2c824082-1f99-4bd1-81e7-bc52052f2ab6','{\"edges\": [[[72, false], null]]}',NULL),('6cd20e7a-88b2-48da-b03f-5f3b7623c5f5','2025-12-06 04:32:35','2025-12-06 04:32:48','2025-12-06 04:32:54','HooksTest-989875015',132,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'707feec89e2e4264b1ee19888698ac0e',0,0,1,'b0a7dccf-7c6c-421f-9abc-df49b6ab9516','{\"edges\": [[[131, false], [130, false]], [[132, false], [131, false]]]}',NULL),('6fbed961-da2c-4c09-9fcd-917156473909','2025-12-06 04:35:34','2025-12-06 04:36:12','2025-12-06 04:36:20','server_with_sub_ip',163,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'8a76b7e9b6ba4a7e900ae157b250225f',0,0,1,'a3b5f57d-6f92-43c3-bb99-0dd41f17cd13','{\"edges\": [[[166, false], [163, false]], [[164, false], [163, false]], [[165, false], [164, false]]]}',NULL),('737833fa-65b0-44f0-b058-a95eb48e9bac','2025-12-06 04:34:36','2025-12-06 04:35:20','2025-12-06 04:35:27','swap_network_port',159,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'e8d5ea42876346c09fdc38aa7e95b936',0,0,1,'0189b38d-5938-4b46-b88d-feeb4f158108','{\"edges\": [[[154, false], [153, false]], [[155, false], [154, false]]]}',NULL),('758fa67e-b396-4351-9dc2-6517d90edfcb','2025-12-06 04:29:32','2025-12-06 04:29:56','2025-12-06 04:30:02','UpdateTrunkTest-1006298183',82,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'3f896d950e6e4615a04bc5dfabb437cf',0,0,1,'09707806-063e-4eec-acf7-a933c6251a11','{\"edges\": [[[60, false], [58, false]], [[62, false], [61, false]], [[62, false], [59, false]], [[61, false], [59, false]], [[64, false], [63, false]], [[64, false], [60, false]], [[63, false], [60, false]], [[67, false], [66, false]], [[67, false], [65, false]], [[66, false], [65, false]]]}',NULL),('78b23705-4c35-4970-95bc-2fe00169e605','2025-12-06 04:29:31','2025-12-06 04:29:47','2025-12-06 04:29:51','StackTagTest-1092282062',75,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'cc7cd373645e47f2b26eac6fc957bdff',0,0,1,'c2f2607e-7aed-48eb-8753-ee1237571b97','{\"edges\": [[[56, false], null]]}',NULL),('7967df7a-68fa-4a43-bdb0-821ba4b96bb1','2025-12-06 04:37:53','2025-12-06 04:39:33','2025-12-06 04:39:34','ParallelDeploymentsTest-796190467-dep_4-5l5rkc4rkbl4',218,NULL,NULL,'demo_tempestconf','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'606c462d29e444b0a98779507e12617e',0,1,1,'ce3326a5-ebfe-4806-8460-1bd9c9cc09fd','{\"edges\": [[[182, false], null]]}','dep_4'),('7dc8aa63-c560-4fc3-8d80-5507b1029158','2025-12-06 04:37:54','2025-12-06 04:39:16','2025-12-06 04:39:17','ParallelDeploymentsTest-1287797711-dep_1-ugecj2zbk73j',212,NULL,NULL,'demo_tempestconf','1326e81d-c775-44e9-b704-3d4b41a91f89','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'fd07bc18cb5640118b2195fbb4e80aa5',0,1,1,'8cd88f22-cfb6-4bbc-a75e-36015c80b164','{\"edges\": [[[196, false], null]]}','dep_1'),('7e7aef01-9063-4dfe-b1e6-878cf42ae5c2','2025-12-06 04:32:59','2025-12-06 04:33:17','2025-12-06 04:33:20','HooksTest-440720371',137,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'cadba49bb71d48589daa535f8591651e',0,0,1,'c623078b-449d-4121-81b0-7c16f6cff719','{\"edges\": [[[133, false], null]]}',NULL),('811bae6d-4fc5-4754-a72c-d909d884fda4','2025-12-06 04:28:14','2025-12-06 04:28:16','2025-12-06 04:28:17','api-229566953-envstack',5,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'e2232e2314b149b690477d070c78fb3f',0,0,1,'2f9a0f1b-54af-4dc4-b798-6433aab792df','{\"edges\": [[[1, false], null]]}',NULL),('81f3f155-2b09-47f6-a17b-108f033edcc8','2025-12-06 04:37:54','2025-12-06 04:39:19','2025-12-06 04:39:21','ParallelDeploymentsTest-1287797711-dep_2-on4jhdwzy6ci',215,NULL,NULL,'demo_tempestconf','1326e81d-c775-44e9-b704-3d4b41a91f89','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'fd07bc18cb5640118b2195fbb4e80aa5',0,1,1,'df5f2d6f-2be7-4e2c-a3c9-eab0786b9767','{\"edges\": [[[194, false], null]]}','dep_2'),('83c13545-518e-421e-9f99-8ea87b70d42b','2025-12-06 04:28:56','2025-12-06 04:29:04','2025-12-06 04:29:05','RemoteStackTest-410959829',46,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'ecce1c354e094cd28e8520ed4559f16a',0,0,1,'8ea46f4d-d4f7-4c6e-a002-b586a36f4070','{\"edges\": [[[33, false], null]]}',NULL),('8bb330dc-64fc-4131-8131-786ce5a2c07f','2025-12-06 04:38:05','2025-12-06 04:38:40','2025-12-06 04:38:45','ParallelDeploymentsTest-1080007079',198,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'62b6e624e978476b9ae90e1f23dc4de2',0,0,1,'07f911ba-81c6-40e2-82ed-1b386767b724','{\"edges\": [[[215, false], [213, false]], [[215, false], [214, false]], [[215, false], [212, false]]]}',NULL),('8c1edcdf-b2b8-4cdb-9333-ef6e32048c46','2025-12-06 04:37:18','2025-12-06 04:37:19','2025-12-06 04:37:20','StackUnicodeTemplateTest-2051045241',172,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'c888e4ea4bbf4bba8228a780edfeeb49',0,0,1,'43d7cdc7-aae4-4cc8-96ec-74e421084a5a','{\"edges\": [[[174, false], null]]}',NULL),('8febfde3-e636-4b94-bac5-97c2406ddb60','2025-12-06 04:33:24','2025-12-06 04:33:43','2025-12-06 04:33:48','HooksTest-747296320',140,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'f92d0e051dd34c5bb6ea7526ff2000e7',0,0,1,'a21c48b8-cb53-4b21-92e0-361062c7281e','{\"edges\": [[[141, false], [140, false]], [[142, false], [141, false]]]}',NULL),('930ed621-3ce6-46e9-a4df-e52f15ab6906','2025-12-06 04:28:25','2025-12-06 04:28:43','2025-12-06 04:28:47','EncryptedParametersTest-74094787',30,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'42f5034c0c794f9cbe3f59939735fc6b',0,0,1,'cdcd0042-3f8c-4684-87a5-52f2e628674c','{\"edges\": [[[12, false], null]]}',NULL),('94d6f227-51f1-4e49-8e59-bf2000bad4ac','2025-12-06 04:38:04','2025-12-06 04:38:51','2025-12-06 04:38:52','ParallelDeploymentsTest-1700023022-dep_1-zc5owplcobgl',205,NULL,NULL,'demo_tempestconf','dcc0cb69-13d8-49b8-9e21-b0de955ece6d','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'deb0bfc687544457bed312d11ded3274',0,1,1,'95093e86-25be-4eaf-b062-5821fbc13e79','{\"edges\": [[[211, false], null]]}','dep_1'),('972e8df9-ff9a-43be-83ca-99885251b30c','2025-12-06 04:31:27','2025-12-06 04:31:51','2025-12-06 04:31:57','UpdateTrunkTest-1063395537',118,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'548745c1837a4caa8c45df63b21ea727',0,0,1,'4fdfa30c-4b8a-431f-b57c-913398e1f14f','{\"edges\": [[[115, false], [114, false]], [[115, false], [111, false]], [[114, false], [111, false]], [[113, false], [112, false]], [[117, false], [116, false]], [[117, false], [113, false]], [[116, false], [113, false]], [[120, false], [118, false]], [[120, false], [119, false]], [[119, false], [118, false]]]}',NULL),('9770ae5b-d5f6-4788-8560-f024b14c6672','2025-12-06 04:39:57','2025-12-06 04:41:35','2025-12-06 04:41:41','ParallelDeploymentsTest-2124645028',232,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'2b1dc93cce1c4195837b52656f8e92ff',0,0,1,'a55d08af-3d4a-4d0d-bc15-21bdcd51d086','{\"edges\": [[[219, false], null]]}',NULL),('994b892d-a3c8-4913-939a-ceb580643578','2025-12-06 04:33:52','2025-12-06 04:34:04','2025-12-06 04:34:05','HooksTest-1462708843-rg-vdvjvjzs2rqz',147,NULL,NULL,'demo_tempestconf','ab67569e-834e-446a-81fe-d6f6fb8fe840','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'82223040fc4d4af1bbc2fc08d2029dba',0,1,1,'df2e5011-c7fb-422a-82f9-b1211c61c9e0','{\"edges\": [[[144, false], null], [[145, false], null]]}','rg'),('9ae5e4c3-4b98-4aeb-8604-bb0e78fdc460','2025-12-06 04:31:35','2025-12-06 04:32:15','2025-12-06 04:32:20','same_fixed_ip',124,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'e0aaee5341044c6886e4c62864ff2cf0',0,0,1,'0c529c7c-f31d-4b47-bd8c-eea8252b9167','{\"edges\": [[[123, false], [121, false]], [[123, false], [122, false]], [[122, false], [121, false]]]}',NULL),('9ae9478a-d759-45df-a4a5-3fff7f6f7405','2025-12-06 04:29:02','2025-12-06 04:29:14','2025-12-06 04:29:16','UpdateSubnetTest-1540482388',53,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'8a2b5bd78b594ea7bd2fd831b3fdc65e',0,0,1,'59270712-3c42-4cab-b3d1-a66e469cad84','{\"edges\": [[[38, false], [37, false]]]}',NULL),('9c80649e-8029-4a3d-8d41-2cefde857216','2025-12-06 04:28:21','2025-12-06 04:28:32','2025-12-06 04:28:35','UpdatePortTest-39567136',25,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'eadce5c143a34b37996c2fb8d9ff9fa6',0,0,1,'007bea04-cde5-4935-8f5a-1f3f750e2eca','{\"edges\": [[[7, false], [6, false]], [[9, false], [7, false]], [[9, false], [8, false]], [[8, false], [7, false]]]}',NULL),('9c9c85f4-553c-4e26-a99e-a35619f0439b','2025-12-06 04:28:23','2025-12-06 04:28:29',NULL,'api-229566953-stack',24,NULL,11,'demo_tempestconf',NULL,'UPDATE','COMPLETE','Stack UPDATE completed successfully',NULL,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'c23d10512acd4d1a864d9f3144bce8a7',0,0,1,'5f9317f5-37b3-4cff-a6b7-bf8b976d7256','{\"edges\": [[[11, false], [11, true]]]}',NULL),('9eb47515-8571-4a0a-bf1a-44ebcd8e61a8','2025-12-06 04:28:58','2025-12-06 04:29:04','2025-12-06 04:29:05','RemoteStackTest-410959829-my_stack-ykioqnifchhb',47,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'ddb6887e270848d0a627ab47fe99b669',0,0,1,'f5b89078-0b84-4a4b-aedb-beb75b205903','{\"edges\": [[[34, false], null]]}',NULL),('a030ddb3-972e-4d5d-8b3e-f84aaa91ce78','2025-12-06 04:28:29','2025-12-06 04:28:40','2025-12-06 04:28:42','UpdateSubnetTest-1395331772',29,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'aab288a26c1247d78ba314882d5db7c7',0,0,1,'c2c6a49f-0d73-4041-8092-9b8e9a7d07b7','{\"edges\": [[[14, false], [13, false]]]}',NULL),('a0e25fbe-b3e7-47a3-a8f0-2a362ef8447a','2025-12-06 04:37:54','2025-12-06 04:39:15','2025-12-06 04:39:16','ParallelDeploymentsTest-1287797711-dep_4-euryujob2lky',211,NULL,NULL,'demo_tempestconf','1326e81d-c775-44e9-b704-3d4b41a91f89','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'fd07bc18cb5640118b2195fbb4e80aa5',0,1,1,'27ab27e0-76f0-49d9-a3e2-fcd5f0a4327b','{\"edges\": [[[195, false], null]]}','dep_4'),('a26b5db1-a18e-4a5b-a3f7-29e481ca6d54','2025-12-06 04:28:33','2025-12-06 04:28:57','2025-12-06 04:29:01','UpdateTrunkTest-954838670',39,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'9f78c8ec8b1441f2bdeeb27ab9de0bd4',0,0,1,'2b0bcc7e-7eb0-49c4-b14e-635365fb0cf0','{\"edges\": [[[22, false], [15, false]], [[17, false], [15, false]], [[16, false], [15, false]], [[19, false], [18, false]], [[19, false], [16, false]], [[18, false], [16, false]], [[21, false], [20, false]], [[21, false], [17, false]], [[20, false], [17, false]], [[24, false], [23, false]], [[24, false], [22, false]], [[23, false], [22, false]]]}',NULL),('a33e8fb8-3ca2-49dd-841b-997a458f8276','2025-12-06 04:30:29','2025-12-06 04:30:37','2025-12-06 04:30:40','StackOutputsTest-273854717',105,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'9f498e4638f2474197b6d25147f82007',0,0,1,'6b106950-8c4d-4f05-b8aa-181e1f74fa0b','{\"edges\": [[[95, false], [96, false]]]}',NULL),('a489fb24-54df-4fa3-8800-1d2fd5fdad32','2025-12-06 04:37:54','2025-12-06 04:39:35','2025-12-06 04:39:37','ParallelDeploymentsTest-796190467-dep_0-txogag7zsutv',221,NULL,NULL,'demo_tempestconf','d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'606c462d29e444b0a98779507e12617e',0,1,1,'5c97b8d3-2ad6-45f4-878e-cdcb89d68eb1','{\"edges\": [[[186, false], null]]}','dep_0'),('a6619ae3-efe1-41e8-beb6-69c4e9a85dd5','2025-12-06 04:35:32','2025-12-06 04:36:18','2025-12-06 04:36:22','swap_network_subnet',164,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'c3785d6417644a3fa7cae20cb645de9c',0,0,1,'4a66f2ae-cbde-4c0e-9578-4a230176a9f2','{\"edges\": [[[161, false], [160, false]], [[162, false], [161, false]]]}',NULL),('a77182a5-55df-4c8f-88f7-4c1d5323fbeb','2025-12-06 04:29:57','2025-12-06 04:30:06','2025-12-06 04:30:11','RemoteDeeplyNestedStackTest-2039546384-network_stack-tuxceswutxbo',89,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'e9f10b8c706d4780ab65ac935548e5a3',0,0,1,'e245474f-72b3-4bf0-8084-20ebe52ed71e','{\"edges\": [[[74, false], null]]}',NULL),('ab67569e-834e-446a-81fe-d6f6fb8fe840','2025-12-06 04:33:51','2025-12-06 04:34:04','2025-12-06 04:34:08','HooksTest-1462708843',146,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'82223040fc4d4af1bbc2fc08d2029dba',0,0,1,'c4981e62-8860-422f-bbf7-4c9b5a763a99','{\"edges\": [[[143, false], null]]}',NULL),('ac3aa260-7638-4b1d-a06c-125c77c959b2','2025-12-06 04:37:54','2025-12-06 04:39:18','2025-12-06 04:39:19','ParallelDeploymentsTest-1287797711-dep_0-6vmc4aliomlp',214,NULL,NULL,'demo_tempestconf','1326e81d-c775-44e9-b704-3d4b41a91f89','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'fd07bc18cb5640118b2195fbb4e80aa5',0,1,1,'7e627db8-8277-4ce1-83e1-27d38ffd7420','{\"edges\": [[[197, false], null]]}','dep_0'),('b2987bbc-cd98-412c-9cee-832c0d57203b','2025-12-06 04:38:02','2025-12-06 04:39:01','2025-12-06 04:39:02','ParallelDeploymentsTest-1504859677-dep_0-nd3g2mpbvpyi',209,NULL,NULL,'demo_tempestconf','fa4f95c2-2ec3-4000-9201-2fcb3780307f','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'e22012781c7e4932b0fa8c673ce7c0ce',0,1,1,'def1776f-7923-4425-aee4-c0bb7e32fe92','{\"edges\": [[[204, false], null]]}','dep_0'),('b50a060c-24a0-42a2-9ed9-fb8b7e59648a','2025-12-06 04:38:02','2025-12-06 04:38:59','2025-12-06 04:39:01','ParallelDeploymentsTest-1504859677-dep_1-bs3xr3box7nj',207,NULL,NULL,'demo_tempestconf','fa4f95c2-2ec3-4000-9201-2fcb3780307f','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'e22012781c7e4932b0fa8c673ce7c0ce',0,1,1,'18d06869-8d11-41c7-8dcd-14bad8a598fe','{\"edges\": [[[202, false], null]]}','dep_1'),('b6138931-f064-4bad-82be-d29b893dd3de','2025-12-06 04:32:02','2025-12-06 04:32:04','2025-12-06 04:32:07','ExternalReferencesTest-2005517343',121,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'1da0210185f048c0aa11f09ee3667248',0,0,1,'3f94c271-edf8-4991-a1f7-172e0d5002c2','{\"edges\": [[[124, false], null]]}',NULL),('b852d540-3586-467d-8302-50003be001ce','2025-12-06 04:32:24','2025-12-06 04:32:29','2025-12-06 04:32:30','ExternalReferencesTest-1327548665',129,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'71deb60f91104410bc1f1fb39d9fc138',0,0,1,'e067db69-e58a-4b93-8c03-04a1b1838c54','{\"edges\": [[[129, false], null]]}',NULL),('be0c1535-71df-48d2-b9fa-e963697b3cf9','2025-12-06 04:34:26','2025-12-06 04:34:40','2025-12-06 04:34:42','HooksTest-1819575342',155,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'76458515e79343c8949e59c448bca254',0,0,1,'8f12fb89-b8e0-47c7-aee6-2084b382ac57','{\"edges\": [[[149, false], null], [[151, false], [152, false]]]}',NULL),('c22a3547-29b3-4d86-a454-7b0eb5bcdddc','2025-12-06 04:28:15',NULL,NULL,'api-2090761251-rsrcstack',3,NULL,4,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'8f1fe5724b22457788bdb242044759ca',0,0,1,'0d422b86-aa8c-4bd4-bf78-9d0f59a66855','{\"edges\": [[[4, true], null]]}',NULL),('c3997fe8-c05a-4490-a371-6e697dad4d53','2025-12-06 04:28:45','2025-12-06 04:28:57','2025-12-06 04:28:59','UpdateSubnetTest-215065987',40,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'79cf9a8f1d6148e1b31426865e9320b3',0,0,1,'8dcb47e4-38f5-4c50-af92-0d24f55a0d62','{\"edges\": [[[30, false], [29, false]]]}',NULL),('c55eb522-6b82-4d4d-876c-d04d555c8e68','2025-12-06 04:29:08','2025-12-06 04:29:14','2025-12-06 04:29:15','ResourcesList-924050756',54,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'74120b21a8c5454297b6ea140e6cc672',0,0,1,'46d6f7be-e12c-4f40-8164-6958de8e96a6','{\"edges\": [[[50, false], [49, false]]]}',NULL),('c68cfc4a-8e59-4685-9457-25004f5b3c4f','2025-12-06 04:30:17','2025-12-06 04:30:22','2025-12-06 04:30:25','StackOutputsTest-1508166139',98,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'c46bedeff3b246a28aefe1bcad8ef770',0,0,1,'36ab1e89-13b7-439e-9b58-54c994da5ea8','{\"edges\": [[[91, false], null], [[92, false], null]]}',NULL),('c6d268c7-a236-4917-aab2-a95383d82ad6','2025-12-06 04:28:20','2025-12-06 04:28:22','2025-12-06 04:28:22','api-2090761251-empty',14,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'dd9497f2a5984b108102a4f5dfc816f1',0,0,1,'e760405f-07d5-45f6-a705-bee39a160007','{\"edges\": []}',NULL),('c7cf0846-c3f2-4edd-850f-92d692c76a3a','2025-12-06 04:29:03','2025-12-06 04:29:22','2025-12-06 04:29:30','UpdateTrunkTest-933223569',57,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'7f6a83a98f504f438ab2b7f86386468a',0,0,1,'1aeff27b-ea3c-41d5-857a-947e29e61b29','{\"edges\": [[[39, false], [40, false]], [[43, false], [39, false]], [[43, false], [42, false]], [[42, false], [39, false]], [[41, false], [40, false]], [[45, false], [44, false]], [[45, false], [41, false]], [[44, false], [41, false]], [[48, false], [47, false]], [[48, false], [46, false]], [[47, false], [46, false]]]}',NULL),('c98858c0-8548-49bf-b00d-f7d9e593bee8','2025-12-06 04:34:46','2025-12-06 04:35:17','2025-12-06 04:35:28','server_with_port',158,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'fec650eedd2a47aa9e3bc6610eebd44e',0,0,1,'58b62c65-83a5-4e4f-9bf6-f1fa46c46ad1','{\"edges\": [[[158, false], [156, false]], [[158, false], [157, false]], [[157, false], [156, false]], [[159, false], [158, false]], [[159, false], [157, false]]]}',NULL),('c9a600fe-447f-4044-829d-9cbdaf912d22','2025-12-06 04:29:38','2025-12-06 04:29:55','2025-12-06 04:29:57','UpdateSubnetTest-254983957',79,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'a8dd5edfe7e140448b42ed2cf7e5f6e8',0,0,1,'e305b9c1-04bd-4659-9aff-bc1fb26598e4','{\"edges\": [[[70, false], [69, false]]]}',NULL),('cfc6fd88-0c10-4096-9a16-b0e5f11f72ae','2025-12-06 04:30:06','2025-12-06 04:30:36','2025-12-06 04:30:44','UpdateTrunkTest-720889307',104,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'d586991efa28409492af36bbc5c934db',0,0,1,'d49a0fbb-7365-406a-962c-687b79fd6827','{\"edges\": [[[83, false], [81, false]], [[82, false], [81, false]], [[88, false], [82, false]], [[88, false], [87, false]], [[87, false], [82, false]], [[90, false], [83, false]], [[90, false], [89, false]], [[89, false], [83, false]], [[86, false], [85, false]], [[86, false], [84, false]], [[85, false], [84, false]]]}',NULL),('d00332b2-5d32-429a-a53c-42885ff38ad0','2025-12-06 04:30:02','2025-12-06 04:30:12','2025-12-06 04:30:13','StackOutputsTest-1139037893-parent-rmz53it6q55r',95,NULL,NULL,'demo_tempestconf','24398c00-fc29-4ccb-984e-76303f40d27a','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'f7896b49b83f4d19be01d409dd8cd807',0,1,1,'2465403e-5e1e-4795-b7e1-18968025b37e','{\"edges\": [[[79, false], null], [[80, false], null]]}','parent'),('d676cc74-f520-4420-84f7-26fb9ab3b975','2025-12-06 04:38:09','2025-12-06 04:38:40','2025-12-06 04:38:41','ParallelDeploymentsTest-1080007079-dep_1-dzf3ueiakkj6',199,NULL,NULL,'demo_tempestconf','8bb330dc-64fc-4131-8131-786ce5a2c07f','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'62b6e624e978476b9ae90e1f23dc4de2',0,1,1,'d1b72f76-936a-4152-a1a1-d9ff1f57dc05','{\"edges\": [[[216, false], null]]}','dep_1'),('d6dc9e91-e9f8-40ba-9cc8-a8c798f21813','2025-12-06 04:29:11','2025-12-06 04:29:26','2025-12-06 04:29:27','RemoteStackTest-1623916689',59,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'d69f1d4bc85b48a88c3b0c105ae06d9a',0,0,1,'36eadc67-0022-4a43-8088-8ca7a9fd2b10','{\"edges\": [[[51, false], null]]}',NULL),('d99a8d5c-ee1e-4f56-95ae-80d19dac5b52','2025-12-06 04:37:51','2025-12-06 04:39:31','2025-12-06 04:39:42','ParallelDeploymentsTest-796190467',216,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'606c462d29e444b0a98779507e12617e',0,0,1,'c978daa9-57d7-4c3e-8dfd-addcc38a4ac1','{\"edges\": [[[181, false], [179, false]], [[181, false], [177, false]], [[181, false], [180, false]], [[181, false], [178, false]], [[181, false], [176, false]]]}',NULL),('da33927f-07f9-40f5-ab87-4a396a5afb18','2025-12-06 04:36:24','2025-12-06 04:37:08','2025-12-06 04:37:13','swap_subnet_network',169,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'03d29ce014414d58b98ae1d37c3683d4',0,0,1,'e047ab40-711d-4947-8d32-9c98d8334599','{\"edges\": [[[173, false], [172, false]], [[173, false], [171, false]], [[172, false], [171, false]]]}',NULL),('da340568-cbbe-4bc8-a4f2-1aea8f33a257','2025-12-06 04:30:46','2025-12-06 04:31:22','2025-12-06 04:31:28','add_network',114,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'e0452f39ab5c46d5ad09e26115adee89',0,0,1,'47d0bd60-7df1-4fdc-9506-cc03f8103f1c','{\"edges\": [[[99, false], [97, false]], [[99, false], [98, false]], [[98, false], [97, false]]]}',NULL),('dcc0cb69-13d8-49b8-9e21-b0de955ece6d','2025-12-06 04:38:03','2025-12-06 04:38:49','2025-12-06 04:38:54','ParallelDeploymentsTest-1700023022',202,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'deb0bfc687544457bed312d11ded3274',0,0,1,'17c37ecf-2540-4f5f-9759-fc508be526d2','{\"edges\": [[[208, false], [207, false]], [[208, false], [205, false]], [[208, false], [206, false]]]}',NULL),('dd29ca5f-f6bb-4235-b0f2-94d3dbf0ed57','2025-12-06 04:29:19','2025-12-06 04:29:32','2025-12-06 04:29:35','UpdateSubnetTest-18467160',65,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'c5855d4f98cb46ba9a692da3d84676ed',0,0,1,'0d05a1f3-f0b1-40bf-95f4-35683893ce1d','{\"edges\": [[[55, false], [54, false]]]}',NULL),('def15797-6bf9-445e-9c40-2859425d821c','2025-12-06 04:29:34','2025-12-06 04:29:45','2025-12-06 04:29:46','RemoteStackTest-341818267-my_stack-77mtmk7njbfp',73,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'690125f6f6184a9684bc3604daf3ced5',0,0,1,'cdc9e9b7-c8f1-47b8-b2d8-ad5b630f5fec','{\"edges\": [[[71, false], null]]}',NULL),('df0f1d90-584d-4519-9f92-c941e844c96f','2025-12-06 04:28:14',NULL,NULL,'api-177751087-rsrcstack',2,NULL,3,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'1f08ac2c7d1947f598b3e256d01b0fa1',0,0,1,'8c39e9d5-ef8f-46b0-aaec-8470d8aadbd4','{\"edges\": [[[3, true], null]]}',NULL),('e891c0be-46f8-4039-80ba-3d2098c6d785','2025-12-06 04:28:22',NULL,NULL,'api-2090761251-stack',16,NULL,10,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'a0838d8d2cbb48d0aeafcc13d5912b53',0,0,1,'609b7729-d593-47d6-8e05-f0b81eaea112','{\"edges\": [[[10, true], null]]}',NULL),('e8d5aee7-ee2c-447f-84cc-f35318b33d01','2025-12-06 04:30:48','2025-12-06 04:31:16','2025-12-06 04:31:22','UpdateTrunkTest-876755024',113,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'0376b12a25f344c08a7dcbd1c0b6202f',0,0,1,'017a6274-6dfb-4eb6-82bb-bdca6dfabe3d','{\"edges\": [[[102, false], [100, false]], [[101, false], [100, false]], [[104, false], [103, false]], [[104, false], [101, false]], [[103, false], [101, false]], [[106, false], [102, false]], [[106, false], [105, false]], [[105, false], [102, false]], [[109, false], [107, false]], [[109, false], [108, false]], [[108, false], [107, false]]]}',NULL),('eb100395-d68e-4497-a187-63f5f8ff0ed2','2025-12-06 04:30:01','2025-12-06 04:30:16','2025-12-06 04:30:19','UpdateSubnetTest-1708440745',97,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'c81679cf36274f5d98f24d9db3d9c7c7',0,0,1,'e8ff449f-59e5-4f48-b914-f16442a0e04e','{\"edges\": [[[78, false], [77, false]]]}',NULL),('f15b23a5-7414-48b5-bdb0-c4dabcdcf623','2025-12-06 04:28:49','2025-12-06 04:28:50','2025-12-06 04:28:51','RemoteStackTest-116901463',35,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'fd8bcb6fa3c64d7eb30aaec125c9bc0a',0,0,1,'aef4a0ba-d903-44b7-a709-d1887ab96075','{\"edges\": [[[32, false], null]]}',NULL),('f1760f48-9423-431b-b917-2fd0efa4c223','2025-12-06 04:29:55','2025-12-06 04:30:05','2025-12-06 04:30:11','RemoteDeeplyNestedStackTest-2039546384',87,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'f38d1654785f4966bb85af03b318f161',0,0,1,'24a0a697-a513-4a03-9816-030331789e56','{\"edges\": [[[73, false], null]]}',NULL),('f9c30769-6c23-418b-84e3-434e3ef71b22','2025-12-06 04:28:37','2025-12-06 04:28:55','2025-12-06 04:29:00','UpdatePortTest-420400297',37,NULL,NULL,'admin',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'f55bbeaa267a4053ad08ac9d81c50699',1,'f70f8412548a4940b8a27a32d215c714',0,0,1,'eb4613de-c66e-4995-afae-fa8f97ade887','{\"edges\": [[[25, false], null], [[27, false], [31, false]], [[28, false], [31, false]], [[28, false], [27, false]]]}',NULL),('fa303946-c89d-4a77-8a98-9541ade77b71','2025-12-06 04:28:20','2025-12-06 04:28:27','2025-12-06 04:28:28','api-177751087-stack',22,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'849bbb95abb2464bb34e15f8798bb0f6',0,0,1,'dd4471c8-eaa4-4c9e-93fa-327fabd6eb2d','{\"edges\": [[[5, false], null]]}',NULL),('fa4f95c2-2ec3-4000-9201-2fcb3780307f','2025-12-06 04:38:02','2025-12-06 04:38:59','2025-12-06 04:39:10','ParallelDeploymentsTest-1504859677',206,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'e22012781c7e4932b0fa8c673ce7c0ce',0,0,1,'44749b40-2d1f-4772-8c92-d40e39e9a24e','{\"edges\": [[[201, false], [199, false]], [[201, false], [200, false]], [[201, false], [198, false]]]}',NULL),('fa575325-64fd-4f36-af83-bafee4834a12','2025-12-06 04:36:22','2025-12-06 04:37:18','2025-12-06 04:37:28','create_server_with_sub_ip',171,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'6e6af296d1254d4db17b6afe1ddf3c4e',1,'6543511a5d354762a4d182eca1c27014',0,0,1,'d4253b98-4f50-4581-8f88-73700d0b63b4','{\"edges\": [[[169, false], [167, false]], [[168, false], [167, false]], [[170, false], [169, false]], [[170, false], [168, false]]]}',NULL);
/*!40000 ALTER TABLE `stack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_lock`
--

DROP TABLE IF EXISTS `stack_lock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_lock` (
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`stack_id`),
  CONSTRAINT `stack_lock_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_lock`
--

LOCK TABLES `stack_lock` WRITE;
/*!40000 ALTER TABLE `stack_lock` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack_lock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_tag`
--

DROP TABLE IF EXISTS `stack_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `tag` varchar(80) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  CONSTRAINT `stack_tag_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_tag`
--

LOCK TABLES `stack_tag` WRITE;
/*!40000 ALTER TABLE `stack_tag` DISABLE KEYS */;
INSERT INTO `stack_tag` (`id`, `created_at`, `updated_at`, `tag`, `stack_id`) VALUES (1,'2025-12-06 04:29:19',NULL,'foo','3639c451-9460-4022-b93b-4d6a1e5c83f5'),(2,'2025-12-06 04:29:19',NULL,'data-processing-cluster','3639c451-9460-4022-b93b-4d6a1e5c83f5');
/*!40000 ALTER TABLE `stack_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_point`
--

DROP TABLE IF EXISTS `sync_point`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sync_point` (
  `entity_id` varchar(36) NOT NULL,
  `traversal_id` varchar(36) NOT NULL,
  `is_update` tinyint(1) NOT NULL,
  `atomic_key` int(11) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `input_data` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`traversal_id`,`is_update`),
  KEY `fk_stack_id` (`stack_id`),
  CONSTRAINT `fk_stack_id` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_point`
--

LOCK TABLES `sync_point` WRITE;
/*!40000 ALTER TABLE `sync_point` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_point` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_creds`
--

DROP TABLE IF EXISTS `user_creds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_creds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `region_name` varchar(255) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `tenant` varchar(1024) DEFAULT NULL,
  `auth_url` text DEFAULT NULL,
  `tenant_id` varchar(256) DEFAULT NULL,
  `trust_id` varchar(255) DEFAULT NULL,
  `trustor_user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_creds`
--

LOCK TABLES `user_creds` WRITE;
/*!40000 ALTER TABLE `user_creds` DISABLE KEYS */;
INSERT INTO `user_creds` (`id`, `created_at`, `updated_at`, `username`, `password`, `region_name`, `decrypt_method`, `tenant`, `auth_url`, `tenant_id`, `trust_id`, `trustor_user_id`) VALUES (3,'2025-12-06 04:28:14',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','6e6af296d1254d4db17b6afe1ddf3c4e','gAAAAABpM7Deix-xIDKsOS3Cy9h1L1pgLrWL3y-6YTLSDNpIj3hu6QopKqeBj2MqBTF9sSwbJv1XNTLgBCTxPHBZFm1V1vILRENdn_4V13HcpiSA7UvfRbmnFSi8IZLBJpPnhbXsVkcn','ad95eccdcf9d4faf99b0125c465ba45f'),(4,'2025-12-06 04:28:15',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','6e6af296d1254d4db17b6afe1ddf3c4e','gAAAAABpM7DfggSDuDnB2vJ_Ctpnp84AvGrRbXe4RrkYBR-pfZXXHZOcuxFLyiPr31fQO45tS7LPpn0wl002UhiWKL-FAogpXRwtKb6UPC0jBiBeAxe9hYAUsOjZRr2z06PsbyncBOcf','ad95eccdcf9d4faf99b0125c465ba45f'),(10,'2025-12-06 04:28:22',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','6e6af296d1254d4db17b6afe1ddf3c4e','gAAAAABpM7Dm_lZ27di76rfyiUVqPCj_bVUGRW_Z5NkpmQglkdVOoEOhozYMXfYKcxKCLt8QRwz70jYtbu9PRo66_-d6PYoubLfSn9TYoajTCPY-IrcFQSkTQuZd-5aIfmDYntmC6K68','ad95eccdcf9d4faf99b0125c465ba45f'),(11,'2025-12-06 04:28:23',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','6e6af296d1254d4db17b6afe1ddf3c4e','gAAAAABpM7Dnmtgx-qnFGcJnA8qxu1zSFlM__odN_pVxQNkiKdoiaH5m86CLKlJKl7h1ICnQNe4kZ8PA8FbbifrqQsmKhAO-pyo69rAXeTA9ZRClXNKPiUL0qcBWlBOcLdRFfxU3NOg1','ad95eccdcf9d4faf99b0125c465ba45f');
/*!40000 ALTER TABLE `user_creds` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `external_id` (`external_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','1da66e351a5b46c7a3210e5099ab3ff5','ac5245b98e0d412ba45c65d30381966f','26bb47fc1c7c4bdb8a87fc41269be8c8',0),('UserProject','1da66e351a5b46c7a3210e5099ab3ff5','ac5245b98e0d412ba45c65d30381966f','3c88f9448cf14f6886cc63cdf8dd824e',0),('UserProject','2b63750ed7c44b85b8ae0854312ae82c','ac5245b98e0d412ba45c65d30381966f','26bb47fc1c7c4bdb8a87fc41269be8c8',0),('UserProject','2b63750ed7c44b85b8ae0854312ae82c','ac5245b98e0d412ba45c65d30381966f','3c88f9448cf14f6886cc63cdf8dd824e',0),('UserProject','5497d2f9a63e487cb9dd28f08cf1ae37','ac5245b98e0d412ba45c65d30381966f','26bb47fc1c7c4bdb8a87fc41269be8c8',0),('UserProject','5497d2f9a63e487cb9dd28f08cf1ae37','ac5245b98e0d412ba45c65d30381966f','3c88f9448cf14f6886cc63cdf8dd824e',0),('UserProject','5d5b45eff1914943a9b9f1dfe4c7931f','ac5245b98e0d412ba45c65d30381966f','15b0da36d33a4a56a2024e0671a3fca0',0),('UserProject','5d5b45eff1914943a9b9f1dfe4c7931f','ac5245b98e0d412ba45c65d30381966f','26bb47fc1c7c4bdb8a87fc41269be8c8',0),('UserProject','5d5b45eff1914943a9b9f1dfe4c7931f','ac5245b98e0d412ba45c65d30381966f','3c88f9448cf14f6886cc63cdf8dd824e',0),('UserProject','61104f98dba2496db1cb8efad12173c6','ac5245b98e0d412ba45c65d30381966f','26bb47fc1c7c4bdb8a87fc41269be8c8',0),('UserProject','61104f98dba2496db1cb8efad12173c6','ac5245b98e0d412ba45c65d30381966f','3c88f9448cf14f6886cc63cdf8dd824e',0),('UserProject','6681b695bf5743df827280b61cbea116','ac5245b98e0d412ba45c65d30381966f','26bb47fc1c7c4bdb8a87fc41269be8c8',0),('UserProject','6681b695bf5743df827280b61cbea116','ac5245b98e0d412ba45c65d30381966f','3c88f9448cf14f6886cc63cdf8dd824e',0),('UserProject','6abc60d07f1b4be6a1da76b8e5c3055d','ac5245b98e0d412ba45c65d30381966f','26bb47fc1c7c4bdb8a87fc41269be8c8',0),('UserProject','6abc60d07f1b4be6a1da76b8e5c3055d','ac5245b98e0d412ba45c65d30381966f','3c88f9448cf14f6886cc63cdf8dd824e',0),('UserProject','ad95eccdcf9d4faf99b0125c465ba45f','6e6af296d1254d4db17b6afe1ddf3c4e','14812f8077c64b27a4e004db1ef55d9e',0),('UserProject','e9df8c89dd8d49d0a4b8f6f8b98afed0','6e6af296d1254d4db17b6afe1ddf3c4e','3c88f9448cf14f6886cc63cdf8dd824e',0),('UserProject','e9df8c89dd8d49d0a4b8f6f8b98afed0','f55bbeaa267a4053ad08ac9d81c50699','3c88f9448cf14f6886cc63cdf8dd824e',0),('UserProject','ee9ecdb0cf1649aebdc574370c271ce1','ac5245b98e0d412ba45c65d30381966f','26bb47fc1c7c4bdb8a87fc41269be8c8',0),('UserProject','ee9ecdb0cf1649aebdc574370c271ce1','ac5245b98e0d412ba45c65d30381966f','3c88f9448cf14f6886cc63cdf8dd824e',0),('UserProject','fb046e284bf643818c5d9ad1b57a72ed','ac5245b98e0d412ba45c65d30381966f','26bb47fc1c7c4bdb8a87fc41269be8c8',0),('UserProject','fb046e284bf643818c5d9ad1b57a72ed','ac5245b98e0d412ba45c65d30381966f','3c88f9448cf14f6886cc63cdf8dd824e',0),('UserDomain','1a43fc07e1b94bec915f7344b57c92a4','6be9d3a1cb10421883d62806d22f4cc6','3c88f9448cf14f6886cc63cdf8dd824e',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('0b62f5866dbc48dc9425aeca9ab5b9b8',NULL,'internal','829e1cc89da34a648c57c0e0b807f9db','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('204b43656b8640469788d297f0937d81',NULL,'internal','0b1b36b1cc764c61b3feaeaee96335a5','https://swift-internal.openstack.svc:8080/v1/AUTH_%(tenant_id)s','{\"name\": \"swift\"}',1,'regionOne'),('221111a95e934a0eb9a28b1621772f42',NULL,'public','2fff2dbe121e4cfa8766b0db666ade26','https://heat-cfnapi-public-openstack.apps-crc.testing/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('37e5e312e9644cacba2e9fb9d5010c49',NULL,'public','0b1b36b1cc764c61b3feaeaee96335a5','https://swift-public-openstack.apps-crc.testing/v1/AUTH_%(tenant_id)s','{\"name\": \"swift\"}',1,'regionOne'),('3abdb01170b74275b9265f8d650d482b',NULL,'public','40329b894e634965a58fdda54375c766','https://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('3ad799a107d3474f9537140716c9dab9',NULL,'internal','1290b135c96e48e48e6bb61fadcf180c','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('446e095edaf24bb39c571acc6c33568c',NULL,'public','829e1cc89da34a648c57c0e0b807f9db','https://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('651e513f9175469fb753d024e7e266d2',NULL,'public','18be6a15db394c46975fe517ed428104','https://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('a65933579dee4ad5a5a82e2c71744abc',NULL,'internal','2fff2dbe121e4cfa8766b0db666ade26','https://heat-cfnapi-internal.openstack.svc:8000/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('bedc479b21d84f9ab608933808a6194d',NULL,'internal','81933190847349e5bfd2d8b6f525bcb5','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('c2520ec6181442fa9ea465699432b4b7',NULL,'internal','65f9ad927b8d4a509384547e877f1458','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('cfe7d4c61d2046e38d46b98ad68bb897',NULL,'internal','a1757207c9684c43afadacb960e59735','https://heat-api-internal.openstack.svc:8004/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('d829d2ba7c6d47d9baa3b5330fba517e',NULL,'public','81933190847349e5bfd2d8b6f525bcb5','https://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('d87f72b9ac9d4b60888f0058b932bab2',NULL,'public','a1757207c9684c43afadacb960e59735','https://heat-api-public-openstack.apps-crc.testing/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('dc1e56ef2a334f1b9b3acf887e53d1aa',NULL,'public','65f9ad927b8d4a509384547e877f1458','https://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('e48c716a9b4d4acdaf65496a8e5993f3',NULL,'internal','40329b894e634965a58fdda54375c766','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('ef5fcd5d0c2e4323b9df57ffe2bda70f',NULL,'internal','18be6a15db394c46975fe517ed428104','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('f1580a6e359c43b78684421d36839b5f',NULL,'public','1290b135c96e48e48e6bb61fadcf180c','https://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('f57efa676d334a2f96e235048164ee3d',NULL,'internal','94b2a86361f341ea8b2a79a47da46c09','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('f81698df0386480ca0ebb0e399599b23',NULL,'public','94b2a86361f341ea8b2a79a47da46c09','https://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('14812f8077c64b27a4e004db1ef55d9e','27ddb36bf1e642659557533cc0fa4788'),('3c88f9448cf14f6886cc63cdf8dd824e','14812f8077c64b27a4e004db1ef55d9e');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'e9df8c89dd8d49d0a4b8f6f8b98afed0','default','admin',0,NULL),(2,'6abc60d07f1b4be6a1da76b8e5c3055d','default','glance',0,NULL),(3,'1a43fc07e1b94bec915f7344b57c92a4','6be9d3a1cb10421883d62806d22f4cc6','heat_stack_domain_admin',0,NULL),(4,'fb046e284bf643818c5d9ad1b57a72ed','default','neutron',0,NULL),(5,'ee9ecdb0cf1649aebdc574370c271ce1','default','swift',0,NULL),(6,'2b63750ed7c44b85b8ae0854312ae82c','default','barbican',0,NULL),(7,'5d5b45eff1914943a9b9f1dfe4c7931f','default','ceilometer',0,NULL),(8,'5497d2f9a63e487cb9dd28f08cf1ae37','default','nova',0,NULL),(9,'6681b695bf5743df827280b61cbea116','default','cinder',0,NULL),(10,'1da66e351a5b46c7a3210e5099ab3ff5','default','placement',0,NULL),(11,'61104f98dba2496db1cb8efad12173c6','default','heat',0,NULL),(12,'ad95eccdcf9d4faf99b0125c465ba45f','default','demo_tempestconf',0,NULL),(13,'21877cdf91ac4109949f9fca60fafaae','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$q99ubqU6e.7XnwTUHumQxeeCpyyd5anbL1rmidv/WekqmGBd6J1x.',1764993523308797,NULL,'2025-12-06 03:58:43'),(2,2,NULL,0,'$2b$12$gkcBmjbPrWx6l0VLCjg3peGz3KPQ22iW3B33ScY0ilvrID0Rgm8au',1764993595025364,NULL,'2025-12-06 03:59:55'),(3,3,NULL,0,'$2b$12$N4wnp.U8LkaiTFdIQkaIbuuLi380mprnDVaZLerCA/4uv0Pe8bWVm',1764993595875353,NULL,'2025-12-06 03:59:55'),(4,4,NULL,0,'$2b$12$tjTyPTU/XNwLHeYdmq8fH.sbOf.WIaPk/AB4Qep/ZR1l1y8UwbvCa',1764993600287461,NULL,'2025-12-06 04:00:00'),(5,5,NULL,0,'$2b$12$VkNuf3Z3ew5QSbB96yu01e0GH1yhZVVc4PqxXZLTXbR6cYMl/aydK',1764993603031534,NULL,'2025-12-06 04:00:03'),(6,6,NULL,0,'$2b$12$EeXhW92qJHkwAzSbpy3N0uOrtGGt/mMmQZZIyTW3RY7EVlcgsU0oO',1764993609870934,NULL,'2025-12-06 04:00:09'),(7,7,NULL,0,'$2b$12$z/Iy58Zt8GRlDWor2PjG2.puBb0zVLlcVwr3Immgr89i6bbDPQTdW',1764993617425296,NULL,'2025-12-06 04:00:17'),(8,8,NULL,0,'$2b$12$VwzFs8n5iRUBYLRaQTzNMu2ocBmN0rvopPuKRqZCeifeKWBWzW96.',1764993624599272,NULL,'2025-12-06 04:00:24'),(9,9,NULL,0,'$2b$12$iqDUyONI4Y91CJXAbXraKuI1/dTe3tXDMqFsqWScEeM6yWX9fKPGC',1764993631491520,NULL,'2025-12-06 04:00:31'),(10,10,NULL,0,'$2b$12$AG8qorB8TirhHilAalRpKeRlg6T6OWJJyN/GvQ6v2LXLzQgpr2LFy',1764993639617058,NULL,'2025-12-06 04:00:39'),(11,11,NULL,0,'$2b$12$meSodtCi2Hhw/SFjJXSglelK2PJk0K7kvCtDyZ9Z/JFP3A2SF9XSq',1764993643281964,NULL,'2025-12-06 04:00:43'),(12,12,NULL,0,'$2b$12$r3BWCuhRqCbv.sBOhXNNPe0GXKJsBnTuRINX2qgvkUKnVyfef9cai',1764995256240846,NULL,'2025-12-06 04:27:36'),(13,13,NULL,0,'$2b$12$Mlw6MJ2XIrH8ixN1SzrS6e77m7QtCmSebFG7PKRQxM6y7MXSDMh.2',1764995257063693,NULL,'2025-12-06 04:27:37');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('09f87163eb9c4257881dc006128b2e77','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('1f08ac2c7d1947f598b3e256d01b0fa1','6e6af296d1254d4db17b6afe1ddf3c4e-df0f1d90-584d-4519-9f92-c941e84','{}','Heat stack user project',1,'6be9d3a1cb10421883d62806d22f4cc6','6be9d3a1cb10421883d62806d22f4cc6',0),('6be9d3a1cb10421883d62806d22f4cc6','heat_stack','{}','Domain for Heat stacks',1,'<<keystone.domain.root>>',NULL,1),('6e6af296d1254d4db17b6afe1ddf3c4e','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('8f1fe5724b22457788bdb242044759ca','6e6af296d1254d4db17b6afe1ddf3c4e-c22a3547-29b3-4d86-a454-7b0eb5b','{}','Heat stack user project',1,'6be9d3a1cb10421883d62806d22f4cc6','6be9d3a1cb10421883d62806d22f4cc6',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('a0838d8d2cbb48d0aeafcc13d5912b53','6e6af296d1254d4db17b6afe1ddf3c4e-e891c0be-46f8-4039-80ba-3d2098c','{}','Heat stack user project',1,'6be9d3a1cb10421883d62806d22f4cc6','6be9d3a1cb10421883d62806d22f4cc6',0),('ac5245b98e0d412ba45c65d30381966f','service','{}','service',1,'default','default',0),('c23d10512acd4d1a864d9f3144bce8a7','6e6af296d1254d4db17b6afe1ddf3c4e-9c9c85f4-553c-4e26-a99e-a35619f','{}','Heat stack user project',1,'6be9d3a1cb10421883d62806d22f4cc6','6be9d3a1cb10421883d62806d22f4cc6',0),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1),('f55bbeaa267a4053ad08ac9d81c50699','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=161 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,NULL,NULL,'60e0b1fad6814587a732378ca7dffcfb',NULL,NULL,'2025-12-06 04:28:16',NULL,'2025-12-06 04:28:16',NULL,NULL),(2,NULL,'e2232e2314b149b690477d070c78fb3f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:28:17',NULL,'2025-12-06 04:28:17',NULL,NULL),(3,NULL,NULL,NULL,NULL,'b0c4247fdca34d9b8266a1d0a1dfb566',NULL,NULL,'2025-12-06 04:28:17',NULL,'2025-12-06 04:28:17',NULL,NULL),(4,NULL,'d2dda6d2484940bca885329bc0457948',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:28:18',NULL,'2025-12-06 04:28:18',NULL,NULL),(5,NULL,NULL,NULL,NULL,'f7888da5a7a145af884a4fc65023144a',NULL,NULL,'2025-12-06 04:28:19',NULL,'2025-12-06 04:28:19',NULL,NULL),(6,NULL,'dc9f9973fa58454bb04e746d4142882c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:28:20',NULL,'2025-12-06 04:28:20',NULL,NULL),(7,NULL,NULL,NULL,NULL,'16d25f228a024afa9fa9e6e3419a6e0e',NULL,NULL,'2025-12-06 04:28:22',NULL,'2025-12-06 04:28:22',NULL,NULL),(8,NULL,NULL,NULL,NULL,'f10769ea73204557af716356d39cdc9b',NULL,NULL,'2025-12-06 04:28:22',NULL,'2025-12-06 04:28:22',NULL,NULL),(9,NULL,'dd9497f2a5984b108102a4f5dfc816f1',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:28:22',NULL,'2025-12-06 04:28:22',NULL,NULL),(10,NULL,'ded32b15c66a485c8cd3e10041d242e0',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:28:23',NULL,'2025-12-06 04:28:23',NULL,NULL),(11,NULL,NULL,NULL,NULL,'e9b5cf1ed95047fe8eb3aa4d92d8553a',NULL,NULL,'2025-12-06 04:28:28',NULL,'2025-12-06 04:28:28',NULL,NULL),(12,NULL,'849bbb95abb2464bb34e15f8798bb0f6',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:28:28',NULL,'2025-12-06 04:28:28',NULL,NULL),(13,NULL,NULL,NULL,NULL,'3d35a71329404043bd3ee9c361aa61b7',NULL,NULL,'2025-12-06 04:28:34',NULL,'2025-12-06 04:28:34',NULL,NULL),(14,NULL,'eadce5c143a34b37996c2fb8d9ff9fa6',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:28:35',NULL,'2025-12-06 04:28:35',NULL,NULL),(15,NULL,NULL,NULL,NULL,'386f4b628d0041a7b6efbe08ea15eeab',NULL,NULL,'2025-12-06 04:28:41',NULL,'2025-12-06 04:28:41',NULL,NULL),(16,NULL,'aab288a26c1247d78ba314882d5db7c7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:28:42',NULL,'2025-12-06 04:28:42',NULL,NULL),(17,NULL,NULL,NULL,NULL,'3d766907009546ab80a0594c2ecb9715',NULL,NULL,'2025-12-06 04:28:46',NULL,'2025-12-06 04:28:46',NULL,NULL),(18,NULL,'42f5034c0c794f9cbe3f59939735fc6b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:28:47',NULL,'2025-12-06 04:28:47',NULL,NULL),(19,NULL,NULL,NULL,NULL,'8f2e3d7f416b4c908b1234d81fd6002e',NULL,NULL,'2025-12-06 04:28:50',NULL,'2025-12-06 04:28:50',NULL,NULL),(20,NULL,'fd8bcb6fa3c64d7eb30aaec125c9bc0a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:28:51',NULL,'2025-12-06 04:28:51',NULL,NULL),(21,NULL,NULL,NULL,NULL,'e139c6361ea04b0c9b46b61d1410c7d4',NULL,NULL,'2025-12-06 04:28:59',NULL,'2025-12-06 04:28:59',NULL,NULL),(22,NULL,'79cf9a8f1d6148e1b31426865e9320b3',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:28:59',NULL,'2025-12-06 04:28:59',NULL,NULL),(23,NULL,NULL,NULL,NULL,'337f80a47e0543ba9f87be3f3b0acf58',NULL,NULL,'2025-12-06 04:28:59',NULL,'2025-12-06 04:28:59',NULL,NULL),(24,NULL,'f70f8412548a4940b8a27a32d215c714',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:29:00',NULL,'2025-12-06 04:29:00',NULL,NULL),(25,NULL,NULL,NULL,NULL,'d2e955be030a4e438c91a5e700ce5af0',NULL,NULL,'2025-12-06 04:29:01',NULL,'2025-12-06 04:29:01',NULL,NULL),(26,NULL,'9f78c8ec8b1441f2bdeeb27ab9de0bd4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:29:01',NULL,'2025-12-06 04:29:01',NULL,NULL),(27,NULL,NULL,NULL,NULL,'efd59e0c4e4048f78cc24197da1cc6c1',NULL,NULL,'2025-12-06 04:29:03',NULL,'2025-12-06 04:29:03',NULL,NULL),(28,NULL,'fd68d46d8524440b8de6b3d8ad72f679',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:29:03',NULL,'2025-12-06 04:29:03',NULL,NULL),(29,NULL,NULL,NULL,NULL,'5ebcc9fe7b7649d09c9a61571a0071f2',NULL,NULL,'2025-12-06 04:29:05',NULL,'2025-12-06 04:29:05',NULL,NULL),(30,NULL,NULL,NULL,NULL,'66b519db70114824b950489209f2a804',NULL,NULL,'2025-12-06 04:29:05',NULL,'2025-12-06 04:29:05',NULL,NULL),(31,NULL,'ddb6887e270848d0a627ab47fe99b669',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:29:05',NULL,'2025-12-06 04:29:05',NULL,NULL),(32,NULL,'ecce1c354e094cd28e8520ed4559f16a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:29:05',NULL,'2025-12-06 04:29:05',NULL,NULL),(33,NULL,NULL,NULL,NULL,'4254e6dac87e4dd291902ae91e80faef',NULL,NULL,'2025-12-06 04:29:14',NULL,'2025-12-06 04:29:14',NULL,NULL),(34,NULL,'74120b21a8c5454297b6ea140e6cc672',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:29:15',NULL,'2025-12-06 04:29:15',NULL,NULL),(35,NULL,NULL,NULL,NULL,'ee681df15c0044e3a67153065c48e311',NULL,NULL,'2025-12-06 04:29:16',NULL,'2025-12-06 04:29:16',NULL,NULL),(36,NULL,'8a2b5bd78b594ea7bd2fd831b3fdc65e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:29:16',NULL,'2025-12-06 04:29:16',NULL,NULL),(37,NULL,NULL,NULL,NULL,'a60ff25de78d40a98e321127fd273b8b',NULL,NULL,'2025-12-06 04:29:26',NULL,'2025-12-06 04:29:26',NULL,NULL),(38,NULL,NULL,NULL,NULL,'9c0cec501bb54fef970e5f9ed2eebb5b',NULL,NULL,'2025-12-06 04:29:26',NULL,'2025-12-06 04:29:26',NULL,NULL),(39,NULL,'10e1f1944f044204985a5ff953ee22d5',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:29:27',NULL,'2025-12-06 04:29:27',NULL,NULL),(40,NULL,'d69f1d4bc85b48a88c3b0c105ae06d9a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:29:27',NULL,'2025-12-06 04:29:27',NULL,NULL),(41,NULL,NULL,NULL,NULL,'82d2f9d507684c008e48c02355651ad7',NULL,NULL,'2025-12-06 04:29:28',NULL,'2025-12-06 04:29:28',NULL,NULL),(42,NULL,'9bcbeff2790c4bf9b847bea716c7951f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:29:28',NULL,'2025-12-06 04:29:28',NULL,NULL),(43,NULL,NULL,NULL,NULL,'0c5abba1e75b44bcb6c07c1c026cadc1',NULL,NULL,'2025-12-06 04:29:28',NULL,'2025-12-06 04:29:28',NULL,NULL),(44,NULL,'7f6a83a98f504f438ab2b7f86386468a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:29:29',NULL,'2025-12-06 04:29:29',NULL,NULL),(45,NULL,NULL,NULL,NULL,'f65fb84f6816455cb3b6a2347b4cb3a4',NULL,NULL,'2025-12-06 04:29:35',NULL,'2025-12-06 04:29:35',NULL,NULL),(46,NULL,'c5855d4f98cb46ba9a692da3d84676ed',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:29:35',NULL,'2025-12-06 04:29:35',NULL,NULL),(47,NULL,NULL,NULL,NULL,'98f6e95ee58d452494a799dee305ca76',NULL,NULL,'2025-12-06 04:29:45',NULL,'2025-12-06 04:29:45',NULL,NULL),(48,NULL,NULL,NULL,NULL,'f1bc04806c4d4da0b6a42e83dfdaf07a',NULL,NULL,'2025-12-06 04:29:45',NULL,'2025-12-06 04:29:45',NULL,NULL),(49,NULL,'690125f6f6184a9684bc3604daf3ced5',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:29:46',NULL,'2025-12-06 04:29:46',NULL,NULL),(50,NULL,'77733d9e821a42fab8046b9fbe8a891e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:29:46',NULL,'2025-12-06 04:29:46',NULL,NULL),(51,NULL,NULL,NULL,NULL,'8548173614ca4728a36757745199f0b8',NULL,NULL,'2025-12-06 04:29:50',NULL,'2025-12-06 04:29:50',NULL,NULL),(52,NULL,'cc7cd373645e47f2b26eac6fc957bdff',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:29:51',NULL,'2025-12-06 04:29:51',NULL,NULL),(53,NULL,NULL,NULL,NULL,'bfc3605c7f314d5c86154c6254d6e701',NULL,NULL,'2025-12-06 04:29:56',NULL,'2025-12-06 04:29:56',NULL,NULL),(54,NULL,'1e7f905b91674522bea58778674efadd',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:29:56',NULL,'2025-12-06 04:29:56',NULL,NULL),(55,NULL,NULL,NULL,NULL,'f7ec8b076eca45cc887de9526301e929',NULL,NULL,'2025-12-06 04:29:57',NULL,'2025-12-06 04:29:57',NULL,NULL),(56,NULL,'a8dd5edfe7e140448b42ed2cf7e5f6e8',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:29:57',NULL,'2025-12-06 04:29:57',NULL,NULL),(57,NULL,NULL,NULL,NULL,'5f1157f7ce854af0accf36da2fc67f4d',NULL,NULL,'2025-12-06 04:30:01',NULL,'2025-12-06 04:30:01',NULL,NULL),(58,NULL,'3f896d950e6e4615a04bc5dfabb437cf',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:30:02',NULL,'2025-12-06 04:30:02',NULL,NULL),(59,NULL,NULL,NULL,NULL,'86d6007c9a144554bb440fbf0a722bca',NULL,NULL,'2025-12-06 04:30:10',NULL,'2025-12-06 04:30:10',NULL,NULL),(60,NULL,NULL,NULL,NULL,'0afbbc8233a0404cbee96fd7bde537a5',NULL,NULL,'2025-12-06 04:30:10',NULL,'2025-12-06 04:30:10',NULL,NULL),(61,NULL,'e9f10b8c706d4780ab65ac935548e5a3',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:30:11',NULL,'2025-12-06 04:30:11',NULL,NULL),(62,NULL,'f38d1654785f4966bb85af03b318f161',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:30:11',NULL,'2025-12-06 04:30:11',NULL,NULL),(63,NULL,NULL,NULL,NULL,'d9a680dc4de2463dbe27aef9e4c66ae7',NULL,NULL,'2025-12-06 04:30:14',NULL,'2025-12-06 04:30:14',NULL,NULL),(64,NULL,'f7896b49b83f4d19be01d409dd8cd807',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:30:15',NULL,'2025-12-06 04:30:15',NULL,NULL),(65,NULL,NULL,NULL,NULL,'75183a78f50d4262b74ca0b1fb9d5c8b',NULL,NULL,'2025-12-06 04:30:18',NULL,'2025-12-06 04:30:18',NULL,NULL),(66,NULL,'c81679cf36274f5d98f24d9db3d9c7c7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:30:19',NULL,'2025-12-06 04:30:19',NULL,NULL),(67,NULL,NULL,NULL,NULL,'2f092b34b2fd4d3787c1766eb586ea72',NULL,NULL,'2025-12-06 04:30:24',NULL,'2025-12-06 04:30:24',NULL,NULL),(68,NULL,'c46bedeff3b246a28aefe1bcad8ef770',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:30:25',NULL,'2025-12-06 04:30:25',NULL,NULL),(69,NULL,NULL,NULL,NULL,'f002b06cc9b541e49fe423dd9a3a1969',NULL,NULL,'2025-12-06 04:30:39',NULL,'2025-12-06 04:30:39',NULL,NULL),(70,NULL,NULL,NULL,NULL,'4d8da02629fa42b883ede42cb6bd28a6',NULL,NULL,'2025-12-06 04:30:40',NULL,'2025-12-06 04:30:40',NULL,NULL),(71,NULL,'9f498e4638f2474197b6d25147f82007',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:30:40',NULL,'2025-12-06 04:30:40',NULL,NULL),(72,NULL,'bf6478ad7d4846e59b81bde55da8cdbe',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:30:40',NULL,'2025-12-06 04:30:40',NULL,NULL),(73,NULL,NULL,NULL,NULL,'858990b1a49f4637b95d0bba110e229e',NULL,NULL,'2025-12-06 04:30:44',NULL,'2025-12-06 04:30:44',NULL,NULL),(74,NULL,'d586991efa28409492af36bbc5c934db',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:30:44',NULL,'2025-12-06 04:30:44',NULL,NULL),(75,NULL,NULL,NULL,NULL,'c7c4b9ac2607442aa536410d63975bc3',NULL,NULL,'2025-12-06 04:30:51',NULL,'2025-12-06 04:30:51',NULL,NULL),(76,NULL,'cae14dda15d241f08415e0a7b45f7110',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:30:51',NULL,'2025-12-06 04:30:51',NULL,NULL),(77,NULL,NULL,NULL,NULL,'c2b8a57bcc5c4cf495bdd433d7e3904e',NULL,NULL,'2025-12-06 04:31:21',NULL,'2025-12-06 04:31:21',NULL,NULL),(78,NULL,'0376b12a25f344c08a7dcbd1c0b6202f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:31:22',NULL,'2025-12-06 04:31:22',NULL,NULL),(79,NULL,NULL,NULL,NULL,'18195c4fa5cd4dceb4c1ee608c335f2b',NULL,NULL,'2025-12-06 04:31:28',NULL,'2025-12-06 04:31:28',NULL,NULL),(80,NULL,'e0452f39ab5c46d5ad09e26115adee89',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:31:28',NULL,'2025-12-06 04:31:28',NULL,NULL),(81,NULL,NULL,NULL,NULL,'cf712926a2b14bfb8d5bfdcf19d37fcb',NULL,NULL,'2025-12-06 04:31:56',NULL,'2025-12-06 04:31:56',NULL,NULL),(82,NULL,'548745c1837a4caa8c45df63b21ea727',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:31:57',NULL,'2025-12-06 04:31:57',NULL,NULL),(83,NULL,NULL,NULL,NULL,'e2c9d8b780df4677bd992a2ca745177a',NULL,NULL,'2025-12-06 04:32:05',NULL,'2025-12-06 04:32:05',NULL,NULL),(84,NULL,'1da0210185f048c0aa11f09ee3667248',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:32:05',NULL,'2025-12-06 04:32:05',NULL,NULL),(85,NULL,NULL,NULL,NULL,'6b1d27cdbdbc4c3aa146172bf810a8ac',NULL,NULL,'2025-12-06 04:32:19',NULL,'2025-12-06 04:32:19',NULL,NULL),(86,NULL,'3afa9170874a419db20317e8ec0bbf8d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:32:19',NULL,'2025-12-06 04:32:19',NULL,NULL),(87,NULL,NULL,NULL,NULL,'2f68eca081b24f90a515044b00111745',NULL,NULL,'2025-12-06 04:32:19',NULL,'2025-12-06 04:32:19',NULL,NULL),(88,NULL,'e0aaee5341044c6886e4c62864ff2cf0',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:32:20',NULL,'2025-12-06 04:32:20',NULL,NULL),(89,NULL,NULL,NULL,NULL,'a0b5931c98d2458a91de25b382cd738d',NULL,NULL,'2025-12-06 04:32:30',NULL,'2025-12-06 04:32:30',NULL,NULL),(90,NULL,'71deb60f91104410bc1f1fb39d9fc138',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:32:30',NULL,'2025-12-06 04:32:30',NULL,NULL),(91,NULL,NULL,NULL,NULL,'fa62478a4e8f41758613832891e39691',NULL,NULL,'2025-12-06 04:32:53',NULL,'2025-12-06 04:32:53',NULL,NULL),(92,NULL,'707feec89e2e4264b1ee19888698ac0e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:32:54',NULL,'2025-12-06 04:32:54',NULL,NULL),(93,NULL,NULL,NULL,NULL,'f0ece70676174907afc36051d7fbed66',NULL,NULL,'2025-12-06 04:33:04',NULL,'2025-12-06 04:33:04',NULL,NULL),(94,NULL,'ab1a57e13135494988cae112b3128095',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:33:04',NULL,'2025-12-06 04:33:04',NULL,NULL),(95,NULL,NULL,NULL,NULL,'d94ffcdf65414ecf969c45e3af85c8ad',NULL,NULL,'2025-12-06 04:33:19',NULL,'2025-12-06 04:33:19',NULL,NULL),(96,NULL,'cadba49bb71d48589daa535f8591651e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:33:20',NULL,'2025-12-06 04:33:20',NULL,NULL),(97,NULL,NULL,NULL,NULL,'5c209b72d1b549e9b173f29fb8bae806',NULL,NULL,'2025-12-06 04:33:46',NULL,'2025-12-06 04:33:46',NULL,NULL),(98,NULL,'f92d0e051dd34c5bb6ea7526ff2000e7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:33:48',NULL,'2025-12-06 04:33:48',NULL,NULL),(99,NULL,NULL,NULL,NULL,'7d562dc506554c36b7fb4c2c030cfbe0',NULL,NULL,'2025-12-06 04:34:06',NULL,'2025-12-06 04:34:06',NULL,NULL),(100,NULL,'82223040fc4d4af1bbc2fc08d2029dba',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:34:08',NULL,'2025-12-06 04:34:08',NULL,NULL),(101,NULL,NULL,NULL,NULL,'6f2a0a815e0f4ba090eb08f08fc7df9e',NULL,NULL,'2025-12-06 04:34:20',NULL,'2025-12-06 04:34:20',NULL,NULL),(102,NULL,'57a4130282cb45b79343c68419c7eab3',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:34:20',NULL,'2025-12-06 04:34:20',NULL,NULL),(103,NULL,NULL,NULL,NULL,'d90299afb5d74f6493a50d7ca9c722fe',NULL,NULL,'2025-12-06 04:34:31',NULL,'2025-12-06 04:34:31',NULL,NULL),(104,NULL,'8051cbd712eb4a05869e09e468a8c9e9',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:34:32',NULL,'2025-12-06 04:34:32',NULL,NULL),(105,NULL,NULL,NULL,NULL,'efb9d3b443cf4dfeb04fbf48a043db38',NULL,NULL,'2025-12-06 04:34:42',NULL,'2025-12-06 04:34:42',NULL,NULL),(106,NULL,'76458515e79343c8949e59c448bca254',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:34:42',NULL,'2025-12-06 04:34:42',NULL,NULL),(107,NULL,NULL,NULL,NULL,'7e3efabf3b804bf1a1e7a1793cf65bee',NULL,NULL,'2025-12-06 04:35:27',NULL,'2025-12-06 04:35:27',NULL,NULL),(108,NULL,'e8d5ea42876346c09fdc38aa7e95b936',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:35:27',NULL,'2025-12-06 04:35:27',NULL,NULL),(109,NULL,NULL,NULL,NULL,'e38fb36ce93342fbb26d7ea18e232238',NULL,NULL,'2025-12-06 04:35:27',NULL,'2025-12-06 04:35:27',NULL,NULL),(110,NULL,'fec650eedd2a47aa9e3bc6610eebd44e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:35:28',NULL,'2025-12-06 04:35:28',NULL,NULL),(111,NULL,NULL,NULL,NULL,'c980abef652f4d59b1c485382e7bf92e',NULL,NULL,'2025-12-06 04:36:19',NULL,'2025-12-06 04:36:19',NULL,NULL),(112,NULL,'8a76b7e9b6ba4a7e900ae157b250225f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:36:20',NULL,'2025-12-06 04:36:20',NULL,NULL),(113,NULL,NULL,NULL,NULL,'50ee6f86a41844afab13941fd477bc00',NULL,NULL,'2025-12-06 04:36:22',NULL,'2025-12-06 04:36:22',NULL,NULL),(114,NULL,'c3785d6417644a3fa7cae20cb645de9c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:36:22',NULL,'2025-12-06 04:36:22',NULL,NULL),(115,NULL,NULL,NULL,NULL,'d6f1d6437b944060a9e38d81f274e4a5',NULL,NULL,'2025-12-06 04:37:12',NULL,'2025-12-06 04:37:12',NULL,NULL),(116,NULL,'03d29ce014414d58b98ae1d37c3683d4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:37:13',NULL,'2025-12-06 04:37:13',NULL,NULL),(117,NULL,NULL,NULL,NULL,'9d409e37ac3a4b4fb9d8921bef61cf16',NULL,NULL,'2025-12-06 04:37:19',NULL,'2025-12-06 04:37:19',NULL,NULL),(118,NULL,'c888e4ea4bbf4bba8228a780edfeeb49',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:37:20',NULL,'2025-12-06 04:37:20',NULL,NULL),(119,NULL,NULL,NULL,NULL,'2cfa9facfc95444789890ec5ffe7838b',NULL,NULL,'2025-12-06 04:37:27',NULL,'2025-12-06 04:37:27',NULL,NULL),(120,NULL,'6543511a5d354762a4d182eca1c27014',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:37:28',NULL,'2025-12-06 04:37:28',NULL,NULL),(121,NULL,NULL,'4b3eebc714c74c9b84a3566a046b7dc8',NULL,NULL,NULL,NULL,'2025-12-06 04:38:41',NULL,'2025-12-06 04:38:41',NULL,NULL),(122,NULL,NULL,'44489f5f70114e3da4dc960c6857c31c',NULL,NULL,NULL,NULL,'2025-12-06 04:38:42',NULL,'2025-12-06 04:38:42',NULL,NULL),(123,NULL,NULL,'ffbaf0702a1f4a9e8e4585f1f6627f99',NULL,NULL,NULL,NULL,'2025-12-06 04:38:43',NULL,'2025-12-06 04:38:43',NULL,NULL),(124,NULL,NULL,NULL,NULL,'3b7288d8751848168486f468cfe2dc56',NULL,NULL,'2025-12-06 04:38:44',NULL,'2025-12-06 04:38:44',NULL,NULL),(125,NULL,'62b6e624e978476b9ae90e1f23dc4de2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:38:45',NULL,'2025-12-06 04:38:45',NULL,NULL),(126,NULL,NULL,'53c4d9f11ecd4a96aeb9281368c976bd',NULL,NULL,NULL,NULL,'2025-12-06 04:38:50',NULL,'2025-12-06 04:38:50',NULL,NULL),(127,NULL,NULL,'97372a7d0c4543ef917bc0d17db9ef6d',NULL,NULL,NULL,NULL,'2025-12-06 04:38:51',NULL,'2025-12-06 04:38:51',NULL,NULL),(128,NULL,NULL,'b8ec85f2c6014cd1aa624468c88137a8',NULL,NULL,NULL,NULL,'2025-12-06 04:38:52',NULL,'2025-12-06 04:38:52',NULL,NULL),(129,NULL,NULL,NULL,NULL,'2d1dd71b7fed4e7480b08f7c2e2ca17c',NULL,NULL,'2025-12-06 04:38:54',NULL,'2025-12-06 04:38:54',NULL,NULL),(130,NULL,'deb0bfc687544457bed312d11ded3274',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:38:54',NULL,'2025-12-06 04:38:54',NULL,NULL),(131,NULL,NULL,'4429400b211747148246eea335b186b8',NULL,NULL,NULL,NULL,'2025-12-06 04:39:01',NULL,'2025-12-06 04:39:01',NULL,NULL),(132,NULL,NULL,'a4478a272a814265bd197ed269a99dcc',NULL,NULL,NULL,NULL,'2025-12-06 04:39:01',NULL,'2025-12-06 04:39:01',NULL,NULL),(133,NULL,NULL,'99409695e34d4099893467c62f7a29e1',NULL,NULL,NULL,NULL,'2025-12-06 04:39:02',NULL,'2025-12-06 04:39:02',NULL,NULL),(134,NULL,NULL,NULL,NULL,'f2857260886348fe99bbbfd5f7c5ee05',NULL,NULL,'2025-12-06 04:39:08',NULL,'2025-12-06 04:39:08',NULL,NULL),(135,NULL,'e22012781c7e4932b0fa8c673ce7c0ce',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:39:10',NULL,'2025-12-06 04:39:10',NULL,NULL),(136,NULL,NULL,'38a5564d4a4e48a0a7fa5ab23eb626d0',NULL,NULL,NULL,NULL,'2025-12-06 04:39:16',NULL,'2025-12-06 04:39:16',NULL,NULL),(137,NULL,NULL,'4a34d49581a7472ab2ea94c8daee13f6',NULL,NULL,NULL,NULL,'2025-12-06 04:39:17',NULL,'2025-12-06 04:39:17',NULL,NULL),(138,NULL,NULL,'9d0a2705f40642558e16e78bf87bb0ad',NULL,NULL,NULL,NULL,'2025-12-06 04:39:18',NULL,'2025-12-06 04:39:18',NULL,NULL),(139,NULL,NULL,'c652a51d3ba544bdac388ae736c6ac12',NULL,NULL,NULL,NULL,'2025-12-06 04:39:19',NULL,'2025-12-06 04:39:19',NULL,NULL),(140,NULL,NULL,'4f706d5ed8f94181b3bc5d4a2103869b',NULL,NULL,NULL,NULL,'2025-12-06 04:39:21',NULL,'2025-12-06 04:39:21',NULL,NULL),(141,NULL,NULL,NULL,NULL,'1d6c752dbf614481ba76ee49dfe2b9a6',NULL,NULL,'2025-12-06 04:39:25',NULL,'2025-12-06 04:39:25',NULL,NULL),(142,NULL,'fd07bc18cb5640118b2195fbb4e80aa5',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:39:27',NULL,'2025-12-06 04:39:27',NULL,NULL),(143,NULL,NULL,'e4451051f147406ab2f76c0df158396f',NULL,NULL,NULL,NULL,'2025-12-06 04:39:33',NULL,'2025-12-06 04:39:33',NULL,NULL),(144,NULL,NULL,'3085cedafd774e34ba00d6611791977f',NULL,NULL,NULL,NULL,'2025-12-06 04:39:34',NULL,'2025-12-06 04:39:34',NULL,NULL),(145,NULL,NULL,'ad5229b8e49e4de89a36d221e3b01595',NULL,NULL,NULL,NULL,'2025-12-06 04:39:34',NULL,'2025-12-06 04:39:34',NULL,NULL),(146,NULL,NULL,'f067a9d5c2df4bafb88a839cc6e8df58',NULL,NULL,NULL,NULL,'2025-12-06 04:39:35',NULL,'2025-12-06 04:39:35',NULL,NULL),(147,NULL,NULL,'04cf3952156e4a0ebfc490b71a5c9109',NULL,NULL,NULL,NULL,'2025-12-06 04:39:37',NULL,'2025-12-06 04:39:37',NULL,NULL),(148,NULL,NULL,NULL,NULL,'124d4b34e5fc45599cb2919892bad644',NULL,NULL,'2025-12-06 04:39:41',NULL,'2025-12-06 04:39:41',NULL,NULL),(149,NULL,'606c462d29e444b0a98779507e12617e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:39:42',NULL,'2025-12-06 04:39:42',NULL,NULL),(150,NULL,NULL,'d04e92957e7747aea85ca4f3722bb915',NULL,NULL,NULL,NULL,'2025-12-06 04:39:46',NULL,'2025-12-06 04:39:46',NULL,NULL),(151,NULL,NULL,NULL,NULL,'41acf8748de54d098c54a292b8b573cb',NULL,NULL,'2025-12-06 04:39:53',NULL,'2025-12-06 04:39:53',NULL,NULL),(152,NULL,'3653f54cdb694b028ec89c2d004e9f1c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:39:53',NULL,'2025-12-06 04:39:53',NULL,NULL),(153,NULL,NULL,'260c230f41714586b2ff52b5554cc26d',NULL,NULL,NULL,NULL,'2025-12-06 04:41:21',NULL,'2025-12-06 04:41:21',NULL,NULL),(154,NULL,NULL,'a55af8db73f34d70a4ea7cf9b92e5e40',NULL,NULL,NULL,NULL,'2025-12-06 04:41:23',NULL,'2025-12-06 04:41:23',NULL,NULL),(155,NULL,NULL,'b4c335052eec45ca95fc2b02656f59c3',NULL,NULL,NULL,NULL,'2025-12-06 04:41:24',NULL,'2025-12-06 04:41:24',NULL,NULL),(156,NULL,NULL,NULL,NULL,'c830d595853746f587845fc1fc01e79c',NULL,NULL,'2025-12-06 04:41:30',NULL,'2025-12-06 04:41:30',NULL,NULL),(157,NULL,'67457a2eb8414a54b5a281fbdb8f5b69',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:41:31',NULL,'2025-12-06 04:41:31',NULL,NULL),(158,NULL,NULL,'c33f03910a92447aa20ad53afd3193ae',NULL,NULL,NULL,NULL,'2025-12-06 04:41:35',NULL,'2025-12-06 04:41:35',NULL,NULL),(159,NULL,NULL,NULL,NULL,'c9023591238f48e699f8a857238018c4',NULL,NULL,'2025-12-06 04:41:40',NULL,'2025-12-06 04:41:40',NULL,NULL),(160,NULL,'2b1dc93cce1c4195837b52656f8e92ff',NULL,NULL,NULL,NULL,NULL,'2025-12-06 04:41:41',NULL,'2025-12-06 04:41:41',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('14812f8077c64b27a4e004db1ef55d9e','member','{}','<<null>>',NULL),('15b0da36d33a4a56a2024e0671a3fca0','SwiftSystemReader','{}','<<null>>',NULL),('16fb89af3c814af7b517b14255aec560','SwiftProjectReader','{}','<<null>>',NULL),('26bb47fc1c7c4bdb8a87fc41269be8c8','service','{}','<<null>>',NULL),('27ddb36bf1e642659557533cc0fa4788','reader','{}','<<null>>',NULL),('28b3964001474b80b9a27ff80ab69274','ResellerAdmin','{}','<<null>>',NULL),('34242fe5668d48e2a36d1a9ba23c69d9','swiftoperator','{}','<<null>>',NULL),('3c88f9448cf14f6886cc63cdf8dd824e','admin','{}','<<null>>',NULL),('9208484731714ce18405ffcb728c9478','heat_stack_user','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('14812f8077c64b27a4e004db1ef55d9e','IMMU','true'),('27ddb36bf1e642659557533cc0fa4788','IMMU','true'),('3c88f9448cf14f6886cc63cdf8dd824e','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('0b1b36b1cc764c61b3feaeaee96335a5','object-store',1,'{\"description\": \"Swift Object Storage\", \"name\": \"swift\"}'),('1290b135c96e48e48e6bb61fadcf180c','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('18be6a15db394c46975fe517ed428104','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('2fff2dbe121e4cfa8766b0db666ade26','cloudformation',1,'{\"description\": \"Heat Cloudformation API service\", \"name\": \"heat-cfn\"}'),('40329b894e634965a58fdda54375c766','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('65f9ad927b8d4a509384547e877f1458','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('81933190847349e5bfd2d8b6f525bcb5','identity',1,'{\"name\": \"keystone\"}'),('829e1cc89da34a648c57c0e0b807f9db','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('94b2a86361f341ea8b2a79a47da46c09','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('a1757207c9684c43afadacb960e59735','orchestration',1,'{\"description\": \"Heat API service\", \"name\": \"heat\"}'),('cd6e18bf1ee44256b911f0ff901b1342','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','e9df8c89dd8d49d0a4b8f6f8b98afed0','system','3c88f9448cf14f6886cc63cdf8dd824e',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_trust_id` (`trust_id`),
  KEY `ix_token_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
INSERT INTO `trust` (`id`, `trustor_user_id`, `trustee_user_id`, `project_id`, `impersonation`, `deleted_at`, `expires_at`, `remaining_uses`, `extra`, `expires_at_int`, `redelegated_trust_id`, `redelegation_count`) VALUES ('0afbbc8233a0404cbee96fd7bde537a5','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:30:10',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('0c5abba1e75b44bcb6c07c1c026cadc1','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:29:28',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('124d4b34e5fc45599cb2919892bad644','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:39:41',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('16d25f228a024afa9fa9e6e3419a6e0e','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:28:22',NULL,NULL,'{\"roles\": [{\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}, {\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}]}',NULL,NULL,0),('18195c4fa5cd4dceb4c1ee608c335f2b','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:31:28',NULL,NULL,'{\"roles\": [{\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}, {\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}]}',NULL,NULL,0),('1d6c752dbf614481ba76ee49dfe2b9a6','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:39:25',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('2cfa9facfc95444789890ec5ffe7838b','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:37:27',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('2d1dd71b7fed4e7480b08f7c2e2ca17c','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:38:54',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('2f092b34b2fd4d3787c1766eb586ea72','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:30:24',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('2f68eca081b24f90a515044b00111745','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:32:19',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('337f80a47e0543ba9f87be3f3b0acf58','e9df8c89dd8d49d0a4b8f6f8b98afed0','61104f98dba2496db1cb8efad12173c6','f55bbeaa267a4053ad08ac9d81c50699',1,'2025-12-06 04:28:59',NULL,NULL,'{\"roles\": [{\"id\": \"3c88f9448cf14f6886cc63cdf8dd824e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}, {\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}]}',NULL,NULL,0),('386f4b628d0041a7b6efbe08ea15eeab','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:28:41',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('3b7288d8751848168486f468cfe2dc56','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:38:44',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('3d35a71329404043bd3ee9c361aa61b7','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:28:34',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('3d766907009546ab80a0594c2ecb9715','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:28:46',NULL,NULL,'{\"roles\": [{\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}, {\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}]}',NULL,NULL,0),('41acf8748de54d098c54a292b8b573cb','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:39:53',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('4254e6dac87e4dd291902ae91e80faef','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:29:14',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('4d8da02629fa42b883ede42cb6bd28a6','e9df8c89dd8d49d0a4b8f6f8b98afed0','61104f98dba2496db1cb8efad12173c6','f55bbeaa267a4053ad08ac9d81c50699',1,'2025-12-06 04:30:40',NULL,NULL,'{\"roles\": [{\"id\": \"3c88f9448cf14f6886cc63cdf8dd824e\"}, {\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('50ee6f86a41844afab13941fd477bc00','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:36:22',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('5c209b72d1b549e9b173f29fb8bae806','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:33:46',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('5ebcc9fe7b7649d09c9a61571a0071f2','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:29:05',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('5f1157f7ce854af0accf36da2fc67f4d','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:30:01',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('60e0b1fad6814587a732378ca7dffcfb','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:28:16',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('66b519db70114824b950489209f2a804','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:29:05',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('6b1d27cdbdbc4c3aa146172bf810a8ac','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:32:19',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('6f2a0a815e0f4ba090eb08f08fc7df9e','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:34:20',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('75183a78f50d4262b74ca0b1fb9d5c8b','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:30:18',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('7d562dc506554c36b7fb4c2c030cfbe0','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:34:06',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('7e3efabf3b804bf1a1e7a1793cf65bee','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:35:27',NULL,NULL,'{\"roles\": [{\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}, {\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}]}',NULL,NULL,0),('82d2f9d507684c008e48c02355651ad7','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:29:28',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('8548173614ca4728a36757745199f0b8','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:29:50',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('858990b1a49f4637b95d0bba110e229e','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:30:44',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('86d6007c9a144554bb440fbf0a722bca','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:30:10',NULL,NULL,'{\"roles\": [{\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}, {\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}]}',NULL,NULL,0),('8f2e3d7f416b4c908b1234d81fd6002e','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:28:50',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('97df9305bba843fdb18398fbdf9c302e','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('98f6e95ee58d452494a799dee305ca76','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:29:45',NULL,NULL,'{\"roles\": [{\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}, {\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}]}',NULL,NULL,0),('9c0cec501bb54fef970e5f9ed2eebb5b','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:29:26',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('9d409e37ac3a4b4fb9d8921bef61cf16','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:37:19',NULL,NULL,'{\"roles\": [{\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}, {\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}]}',NULL,NULL,0),('9f5eaa6b647d4c879b5ab67f23d1a796','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('a0b5931c98d2458a91de25b382cd738d','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:32:30',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('a60ff25de78d40a98e321127fd273b8b','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:29:26',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('ab1c5dc57d86414ba81d421fe03175e3','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('b0c4247fdca34d9b8266a1d0a1dfb566','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:28:17',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('ba940c377bdb4c6086e843782a9f591d','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('bfc3605c7f314d5c86154c6254d6e701','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:29:56',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('c2b8a57bcc5c4cf495bdd433d7e3904e','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:31:21',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('c7c4b9ac2607442aa536410d63975bc3','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:30:51',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('c830d595853746f587845fc1fc01e79c','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:41:30',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('c9023591238f48e699f8a857238018c4','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:41:40',NULL,NULL,'{\"roles\": [{\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}, {\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}]}',NULL,NULL,0),('c980abef652f4d59b1c485382e7bf92e','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:36:19',NULL,NULL,'{\"roles\": [{\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}, {\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}]}',NULL,NULL,0),('cf712926a2b14bfb8d5bfdcf19d37fcb','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:31:56',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('d2e955be030a4e438c91a5e700ce5af0','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:29:01',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('d6f1d6437b944060a9e38d81f274e4a5','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:37:12',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('d90299afb5d74f6493a50d7ca9c722fe','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:34:31',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('d94ffcdf65414ecf969c45e3af85c8ad','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:33:19',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('d9a680dc4de2463dbe27aef9e4c66ae7','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:30:14',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('e139c6361ea04b0c9b46b61d1410c7d4','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:28:59',NULL,NULL,'{\"roles\": [{\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}, {\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}]}',NULL,NULL,0),('e2c9d8b780df4677bd992a2ca745177a','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:32:05',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('e38fb36ce93342fbb26d7ea18e232238','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:35:27',NULL,NULL,'{\"roles\": [{\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}, {\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}]}',NULL,NULL,0),('e9b5cf1ed95047fe8eb3aa4d92d8553a','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:28:28',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('ee681df15c0044e3a67153065c48e311','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:29:16',NULL,NULL,'{\"roles\": [{\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}, {\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}]}',NULL,NULL,0),('efb9d3b443cf4dfeb04fbf48a043db38','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:34:42',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('efd59e0c4e4048f78cc24197da1cc6c1','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:29:03',NULL,NULL,'{\"roles\": [{\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}, {\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}]}',NULL,NULL,0),('f002b06cc9b541e49fe423dd9a3a1969','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:30:39',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('f0ece70676174907afc36051d7fbed66','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:33:04',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('f10769ea73204557af716356d39cdc9b','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:28:22',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('f1bc04806c4d4da0b6a42e83dfdaf07a','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:29:45',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('f2857260886348fe99bbbfd5f7c5ee05','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:39:08',NULL,NULL,'{\"roles\": [{\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}, {\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}]}',NULL,NULL,0),('f65fb84f6816455cb3b6a2347b4cb3a4','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:29:35',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('f7888da5a7a145af884a4fc65023144a','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:28:19',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0),('f7ec8b076eca45cc887de9526301e929','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:29:57',NULL,NULL,'{\"roles\": [{\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}, {\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}]}',NULL,NULL,0),('fa62478a4e8f41758613832891e39691','ad95eccdcf9d4faf99b0125c465ba45f','61104f98dba2496db1cb8efad12173c6','6e6af296d1254d4db17b6afe1ddf3c4e',1,'2025-12-06 04:32:53',NULL,NULL,'{\"roles\": [{\"id\": \"14812f8077c64b27a4e004db1ef55d9e\"}, {\"id\": \"27ddb36bf1e642659557533cc0fa4788\"}]}',NULL,NULL,0);
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
INSERT INTO `trust_role` (`trust_id`, `role_id`) VALUES ('0afbbc8233a0404cbee96fd7bde537a5','14812f8077c64b27a4e004db1ef55d9e'),('0afbbc8233a0404cbee96fd7bde537a5','27ddb36bf1e642659557533cc0fa4788'),('0c5abba1e75b44bcb6c07c1c026cadc1','14812f8077c64b27a4e004db1ef55d9e'),('0c5abba1e75b44bcb6c07c1c026cadc1','27ddb36bf1e642659557533cc0fa4788'),('124d4b34e5fc45599cb2919892bad644','14812f8077c64b27a4e004db1ef55d9e'),('124d4b34e5fc45599cb2919892bad644','27ddb36bf1e642659557533cc0fa4788'),('16d25f228a024afa9fa9e6e3419a6e0e','14812f8077c64b27a4e004db1ef55d9e'),('16d25f228a024afa9fa9e6e3419a6e0e','27ddb36bf1e642659557533cc0fa4788'),('18195c4fa5cd4dceb4c1ee608c335f2b','14812f8077c64b27a4e004db1ef55d9e'),('18195c4fa5cd4dceb4c1ee608c335f2b','27ddb36bf1e642659557533cc0fa4788'),('1d6c752dbf614481ba76ee49dfe2b9a6','14812f8077c64b27a4e004db1ef55d9e'),('1d6c752dbf614481ba76ee49dfe2b9a6','27ddb36bf1e642659557533cc0fa4788'),('2cfa9facfc95444789890ec5ffe7838b','14812f8077c64b27a4e004db1ef55d9e'),('2cfa9facfc95444789890ec5ffe7838b','27ddb36bf1e642659557533cc0fa4788'),('2d1dd71b7fed4e7480b08f7c2e2ca17c','14812f8077c64b27a4e004db1ef55d9e'),('2d1dd71b7fed4e7480b08f7c2e2ca17c','27ddb36bf1e642659557533cc0fa4788'),('2f092b34b2fd4d3787c1766eb586ea72','14812f8077c64b27a4e004db1ef55d9e'),('2f092b34b2fd4d3787c1766eb586ea72','27ddb36bf1e642659557533cc0fa4788'),('2f68eca081b24f90a515044b00111745','14812f8077c64b27a4e004db1ef55d9e'),('2f68eca081b24f90a515044b00111745','27ddb36bf1e642659557533cc0fa4788'),('337f80a47e0543ba9f87be3f3b0acf58','14812f8077c64b27a4e004db1ef55d9e'),('337f80a47e0543ba9f87be3f3b0acf58','27ddb36bf1e642659557533cc0fa4788'),('337f80a47e0543ba9f87be3f3b0acf58','3c88f9448cf14f6886cc63cdf8dd824e'),('386f4b628d0041a7b6efbe08ea15eeab','14812f8077c64b27a4e004db1ef55d9e'),('386f4b628d0041a7b6efbe08ea15eeab','27ddb36bf1e642659557533cc0fa4788'),('3b7288d8751848168486f468cfe2dc56','14812f8077c64b27a4e004db1ef55d9e'),('3b7288d8751848168486f468cfe2dc56','27ddb36bf1e642659557533cc0fa4788'),('3d35a71329404043bd3ee9c361aa61b7','14812f8077c64b27a4e004db1ef55d9e'),('3d35a71329404043bd3ee9c361aa61b7','27ddb36bf1e642659557533cc0fa4788'),('3d766907009546ab80a0594c2ecb9715','14812f8077c64b27a4e004db1ef55d9e'),('3d766907009546ab80a0594c2ecb9715','27ddb36bf1e642659557533cc0fa4788'),('41acf8748de54d098c54a292b8b573cb','14812f8077c64b27a4e004db1ef55d9e'),('41acf8748de54d098c54a292b8b573cb','27ddb36bf1e642659557533cc0fa4788'),('4254e6dac87e4dd291902ae91e80faef','14812f8077c64b27a4e004db1ef55d9e'),('4254e6dac87e4dd291902ae91e80faef','27ddb36bf1e642659557533cc0fa4788'),('4d8da02629fa42b883ede42cb6bd28a6','14812f8077c64b27a4e004db1ef55d9e'),('4d8da02629fa42b883ede42cb6bd28a6','27ddb36bf1e642659557533cc0fa4788'),('4d8da02629fa42b883ede42cb6bd28a6','3c88f9448cf14f6886cc63cdf8dd824e'),('50ee6f86a41844afab13941fd477bc00','14812f8077c64b27a4e004db1ef55d9e'),('50ee6f86a41844afab13941fd477bc00','27ddb36bf1e642659557533cc0fa4788'),('5c209b72d1b549e9b173f29fb8bae806','14812f8077c64b27a4e004db1ef55d9e'),('5c209b72d1b549e9b173f29fb8bae806','27ddb36bf1e642659557533cc0fa4788'),('5ebcc9fe7b7649d09c9a61571a0071f2','14812f8077c64b27a4e004db1ef55d9e'),('5ebcc9fe7b7649d09c9a61571a0071f2','27ddb36bf1e642659557533cc0fa4788'),('5f1157f7ce854af0accf36da2fc67f4d','14812f8077c64b27a4e004db1ef55d9e'),('5f1157f7ce854af0accf36da2fc67f4d','27ddb36bf1e642659557533cc0fa4788'),('60e0b1fad6814587a732378ca7dffcfb','14812f8077c64b27a4e004db1ef55d9e'),('60e0b1fad6814587a732378ca7dffcfb','27ddb36bf1e642659557533cc0fa4788'),('66b519db70114824b950489209f2a804','14812f8077c64b27a4e004db1ef55d9e'),('66b519db70114824b950489209f2a804','27ddb36bf1e642659557533cc0fa4788'),('6b1d27cdbdbc4c3aa146172bf810a8ac','14812f8077c64b27a4e004db1ef55d9e'),('6b1d27cdbdbc4c3aa146172bf810a8ac','27ddb36bf1e642659557533cc0fa4788'),('6f2a0a815e0f4ba090eb08f08fc7df9e','14812f8077c64b27a4e004db1ef55d9e'),('6f2a0a815e0f4ba090eb08f08fc7df9e','27ddb36bf1e642659557533cc0fa4788'),('75183a78f50d4262b74ca0b1fb9d5c8b','14812f8077c64b27a4e004db1ef55d9e'),('75183a78f50d4262b74ca0b1fb9d5c8b','27ddb36bf1e642659557533cc0fa4788'),('7d562dc506554c36b7fb4c2c030cfbe0','14812f8077c64b27a4e004db1ef55d9e'),('7d562dc506554c36b7fb4c2c030cfbe0','27ddb36bf1e642659557533cc0fa4788'),('7e3efabf3b804bf1a1e7a1793cf65bee','14812f8077c64b27a4e004db1ef55d9e'),('7e3efabf3b804bf1a1e7a1793cf65bee','27ddb36bf1e642659557533cc0fa4788'),('82d2f9d507684c008e48c02355651ad7','14812f8077c64b27a4e004db1ef55d9e'),('82d2f9d507684c008e48c02355651ad7','27ddb36bf1e642659557533cc0fa4788'),('8548173614ca4728a36757745199f0b8','14812f8077c64b27a4e004db1ef55d9e'),('8548173614ca4728a36757745199f0b8','27ddb36bf1e642659557533cc0fa4788'),('858990b1a49f4637b95d0bba110e229e','14812f8077c64b27a4e004db1ef55d9e'),('858990b1a49f4637b95d0bba110e229e','27ddb36bf1e642659557533cc0fa4788'),('86d6007c9a144554bb440fbf0a722bca','14812f8077c64b27a4e004db1ef55d9e'),('86d6007c9a144554bb440fbf0a722bca','27ddb36bf1e642659557533cc0fa4788'),('8f2e3d7f416b4c908b1234d81fd6002e','14812f8077c64b27a4e004db1ef55d9e'),('8f2e3d7f416b4c908b1234d81fd6002e','27ddb36bf1e642659557533cc0fa4788'),('97df9305bba843fdb18398fbdf9c302e','14812f8077c64b27a4e004db1ef55d9e'),('97df9305bba843fdb18398fbdf9c302e','27ddb36bf1e642659557533cc0fa4788'),('98f6e95ee58d452494a799dee305ca76','14812f8077c64b27a4e004db1ef55d9e'),('98f6e95ee58d452494a799dee305ca76','27ddb36bf1e642659557533cc0fa4788'),('9c0cec501bb54fef970e5f9ed2eebb5b','14812f8077c64b27a4e004db1ef55d9e'),('9c0cec501bb54fef970e5f9ed2eebb5b','27ddb36bf1e642659557533cc0fa4788'),('9d409e37ac3a4b4fb9d8921bef61cf16','14812f8077c64b27a4e004db1ef55d9e'),('9d409e37ac3a4b4fb9d8921bef61cf16','27ddb36bf1e642659557533cc0fa4788'),('9f5eaa6b647d4c879b5ab67f23d1a796','14812f8077c64b27a4e004db1ef55d9e'),('9f5eaa6b647d4c879b5ab67f23d1a796','27ddb36bf1e642659557533cc0fa4788'),('a0b5931c98d2458a91de25b382cd738d','14812f8077c64b27a4e004db1ef55d9e'),('a0b5931c98d2458a91de25b382cd738d','27ddb36bf1e642659557533cc0fa4788'),('a60ff25de78d40a98e321127fd273b8b','14812f8077c64b27a4e004db1ef55d9e'),('a60ff25de78d40a98e321127fd273b8b','27ddb36bf1e642659557533cc0fa4788'),('ab1c5dc57d86414ba81d421fe03175e3','14812f8077c64b27a4e004db1ef55d9e'),('ab1c5dc57d86414ba81d421fe03175e3','27ddb36bf1e642659557533cc0fa4788'),('b0c4247fdca34d9b8266a1d0a1dfb566','14812f8077c64b27a4e004db1ef55d9e'),('b0c4247fdca34d9b8266a1d0a1dfb566','27ddb36bf1e642659557533cc0fa4788'),('ba940c377bdb4c6086e843782a9f591d','14812f8077c64b27a4e004db1ef55d9e'),('ba940c377bdb4c6086e843782a9f591d','27ddb36bf1e642659557533cc0fa4788'),('bfc3605c7f314d5c86154c6254d6e701','14812f8077c64b27a4e004db1ef55d9e'),('bfc3605c7f314d5c86154c6254d6e701','27ddb36bf1e642659557533cc0fa4788'),('c2b8a57bcc5c4cf495bdd433d7e3904e','14812f8077c64b27a4e004db1ef55d9e'),('c2b8a57bcc5c4cf495bdd433d7e3904e','27ddb36bf1e642659557533cc0fa4788'),('c7c4b9ac2607442aa536410d63975bc3','14812f8077c64b27a4e004db1ef55d9e'),('c7c4b9ac2607442aa536410d63975bc3','27ddb36bf1e642659557533cc0fa4788'),('c830d595853746f587845fc1fc01e79c','14812f8077c64b27a4e004db1ef55d9e'),('c830d595853746f587845fc1fc01e79c','27ddb36bf1e642659557533cc0fa4788'),('c9023591238f48e699f8a857238018c4','14812f8077c64b27a4e004db1ef55d9e'),('c9023591238f48e699f8a857238018c4','27ddb36bf1e642659557533cc0fa4788'),('c980abef652f4d59b1c485382e7bf92e','14812f8077c64b27a4e004db1ef55d9e'),('c980abef652f4d59b1c485382e7bf92e','27ddb36bf1e642659557533cc0fa4788'),('cf712926a2b14bfb8d5bfdcf19d37fcb','14812f8077c64b27a4e004db1ef55d9e'),('cf712926a2b14bfb8d5bfdcf19d37fcb','27ddb36bf1e642659557533cc0fa4788'),('d2e955be030a4e438c91a5e700ce5af0','14812f8077c64b27a4e004db1ef55d9e'),('d2e955be030a4e438c91a5e700ce5af0','27ddb36bf1e642659557533cc0fa4788'),('d6f1d6437b944060a9e38d81f274e4a5','14812f8077c64b27a4e004db1ef55d9e'),('d6f1d6437b944060a9e38d81f274e4a5','27ddb36bf1e642659557533cc0fa4788'),('d90299afb5d74f6493a50d7ca9c722fe','14812f8077c64b27a4e004db1ef55d9e'),('d90299afb5d74f6493a50d7ca9c722fe','27ddb36bf1e642659557533cc0fa4788'),('d94ffcdf65414ecf969c45e3af85c8ad','14812f8077c64b27a4e004db1ef55d9e'),('d94ffcdf65414ecf969c45e3af85c8ad','27ddb36bf1e642659557533cc0fa4788'),('d9a680dc4de2463dbe27aef9e4c66ae7','14812f8077c64b27a4e004db1ef55d9e'),('d9a680dc4de2463dbe27aef9e4c66ae7','27ddb36bf1e642659557533cc0fa4788'),('e139c6361ea04b0c9b46b61d1410c7d4','14812f8077c64b27a4e004db1ef55d9e'),('e139c6361ea04b0c9b46b61d1410c7d4','27ddb36bf1e642659557533cc0fa4788'),('e2c9d8b780df4677bd992a2ca745177a','14812f8077c64b27a4e004db1ef55d9e'),('e2c9d8b780df4677bd992a2ca745177a','27ddb36bf1e642659557533cc0fa4788'),('e38fb36ce93342fbb26d7ea18e232238','14812f8077c64b27a4e004db1ef55d9e'),('e38fb36ce93342fbb26d7ea18e232238','27ddb36bf1e642659557533cc0fa4788'),('e9b5cf1ed95047fe8eb3aa4d92d8553a','14812f8077c64b27a4e004db1ef55d9e'),('e9b5cf1ed95047fe8eb3aa4d92d8553a','27ddb36bf1e642659557533cc0fa4788'),('ee681df15c0044e3a67153065c48e311','14812f8077c64b27a4e004db1ef55d9e'),('ee681df15c0044e3a67153065c48e311','27ddb36bf1e642659557533cc0fa4788'),('efb9d3b443cf4dfeb04fbf48a043db38','14812f8077c64b27a4e004db1ef55d9e'),('efb9d3b443cf4dfeb04fbf48a043db38','27ddb36bf1e642659557533cc0fa4788'),('efd59e0c4e4048f78cc24197da1cc6c1','14812f8077c64b27a4e004db1ef55d9e'),('efd59e0c4e4048f78cc24197da1cc6c1','27ddb36bf1e642659557533cc0fa4788'),('f002b06cc9b541e49fe423dd9a3a1969','14812f8077c64b27a4e004db1ef55d9e'),('f002b06cc9b541e49fe423dd9a3a1969','27ddb36bf1e642659557533cc0fa4788'),('f0ece70676174907afc36051d7fbed66','14812f8077c64b27a4e004db1ef55d9e'),('f0ece70676174907afc36051d7fbed66','27ddb36bf1e642659557533cc0fa4788'),('f10769ea73204557af716356d39cdc9b','14812f8077c64b27a4e004db1ef55d9e'),('f10769ea73204557af716356d39cdc9b','27ddb36bf1e642659557533cc0fa4788'),('f1bc04806c4d4da0b6a42e83dfdaf07a','14812f8077c64b27a4e004db1ef55d9e'),('f1bc04806c4d4da0b6a42e83dfdaf07a','27ddb36bf1e642659557533cc0fa4788'),('f2857260886348fe99bbbfd5f7c5ee05','14812f8077c64b27a4e004db1ef55d9e'),('f2857260886348fe99bbbfd5f7c5ee05','27ddb36bf1e642659557533cc0fa4788'),('f65fb84f6816455cb3b6a2347b4cb3a4','14812f8077c64b27a4e004db1ef55d9e'),('f65fb84f6816455cb3b6a2347b4cb3a4','27ddb36bf1e642659557533cc0fa4788'),('f7888da5a7a145af884a4fc65023144a','14812f8077c64b27a4e004db1ef55d9e'),('f7888da5a7a145af884a4fc65023144a','27ddb36bf1e642659557533cc0fa4788'),('f7ec8b076eca45cc887de9526301e929','14812f8077c64b27a4e004db1ef55d9e'),('f7ec8b076eca45cc887de9526301e929','27ddb36bf1e642659557533cc0fa4788'),('fa62478a4e8f41758613832891e39691','14812f8077c64b27a4e004db1ef55d9e'),('fa62478a4e8f41758613832891e39691','27ddb36bf1e642659557533cc0fa4788');
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('1a43fc07e1b94bec915f7344b57c92a4','{}',1,NULL,'2025-12-06 03:59:56','2025-12-06','6be9d3a1cb10421883d62806d22f4cc6'),('1da66e351a5b46c7a3210e5099ab3ff5','{}',1,'ac5245b98e0d412ba45c65d30381966f','2025-12-06 04:00:39','2025-12-06','default'),('21877cdf91ac4109949f9fca60fafaae','{\"tenantId\": \"09f87163eb9c4257881dc006128b2e77\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2025-12-06 04:27:37',NULL,'default'),('2b63750ed7c44b85b8ae0854312ae82c','{}',1,'ac5245b98e0d412ba45c65d30381966f','2025-12-06 04:00:10',NULL,'default'),('5497d2f9a63e487cb9dd28f08cf1ae37','{}',1,'ac5245b98e0d412ba45c65d30381966f','2025-12-06 04:00:24','2025-12-06','default'),('5d5b45eff1914943a9b9f1dfe4c7931f','{}',1,'ac5245b98e0d412ba45c65d30381966f','2025-12-06 04:00:17','2025-12-06','default'),('61104f98dba2496db1cb8efad12173c6','{}',1,'ac5245b98e0d412ba45c65d30381966f','2025-12-06 04:00:43','2025-12-06','default'),('6681b695bf5743df827280b61cbea116','{}',1,'ac5245b98e0d412ba45c65d30381966f','2025-12-06 04:00:31','2025-12-06','default'),('6abc60d07f1b4be6a1da76b8e5c3055d','{}',1,'ac5245b98e0d412ba45c65d30381966f','2025-12-06 03:59:55','2025-12-06','default'),('ad95eccdcf9d4faf99b0125c465ba45f','{\"tenantId\": \"6e6af296d1254d4db17b6afe1ddf3c4e\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2025-12-06 04:27:36','2025-12-06','default'),('e9df8c89dd8d49d0a4b8f6f8b98afed0','{}',1,NULL,'2025-12-06 03:58:43','2025-12-06','default'),('ee9ecdb0cf1649aebdc574370c271ce1','{}',1,'ac5245b98e0d412ba45c65d30381966f','2025-12-06 04:00:03','2025-12-06','default'),('fb046e284bf643818c5d9ad1b57a72ed','{}',1,'ac5245b98e0d412ba45c65d30381966f','2025-12-06 04:00:00','2025-12-06','default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','keystone','keystone_e5f1','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_e5f1','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','placement','placement_785f','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_785f','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','glance','glance_633c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_633c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_1352','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','heat','heat_ec26','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_da9d','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_e48e','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_1352','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','heat','heat_ec26','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_da9d','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_e48e','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_1043','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_1043','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_cdd3','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_cdd3','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1764993428}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1764993428}'),('localhost','keystone_e5f1','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*24EA68AF034BE55AD6E89323A076026B809ADBC0\",\"password_last_changed\":1764993446}'),('%','keystone_e5f1','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*24EA68AF034BE55AD6E89323A076026B809ADBC0\",\"password_last_changed\":1764993446}'),('localhost','placement_785f','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*C15047D59CD7A0D27FE346EF7DEB2FCF6250C6C0\",\"password_last_changed\":1764993446}'),('%','placement_785f','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*C15047D59CD7A0D27FE346EF7DEB2FCF6250C6C0\",\"password_last_changed\":1764993446}'),('localhost','glance_633c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*271C6F0DD6D560D9FEBBB50450F9D9C7B269C5B2\",\"password_last_changed\":1764993447}'),('%','glance_633c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*271C6F0DD6D560D9FEBBB50450F9D9C7B269C5B2\",\"password_last_changed\":1764993447}'),('localhost','cinder_1352','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*33E9F1C762C63C7060181BC7D0C1392BEA93423C\",\"password_last_changed\":1764993505}'),('localhost','heat_ec26','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*DEB2245A15DD4F471B775F4EC2B8344CADF2F3C8\",\"password_last_changed\":1764993505}'),('localhost','neutron_da9d','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*FB65A8AD5C0370663EBA913FF4F54354790072D9\",\"password_last_changed\":1764993505}'),('localhost','barbican_e48e','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*C81F5CF6EAF2E17D74A5642C837631B9EC90E835\",\"password_last_changed\":1764993505}'),('%','cinder_1352','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*33E9F1C762C63C7060181BC7D0C1392BEA93423C\",\"password_last_changed\":1764993505}'),('%','heat_ec26','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*DEB2245A15DD4F471B775F4EC2B8344CADF2F3C8\",\"password_last_changed\":1764993505}'),('%','neutron_da9d','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*FB65A8AD5C0370663EBA913FF4F54354790072D9\",\"password_last_changed\":1764993505}'),('%','barbican_e48e','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*C81F5CF6EAF2E17D74A5642C837631B9EC90E835\",\"password_last_changed\":1764993505}'),('localhost','nova_api_1043','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*861279F3DBA804ED5655BDF68D5704A62A92F02C\",\"password_last_changed\":1764993627}'),('%','nova_api_1043','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*861279F3DBA804ED5655BDF68D5704A62A92F02C\",\"password_last_changed\":1764993628}'),('localhost','nova_cell0_cdd3','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D64B18DE1095311828D5D264E29D4D7744C21A4D\",\"password_last_changed\":1764993628}'),('%','nova_cell0_cdd3','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D64B18DE1095311828D5D264E29D4D7744C21A4D\",\"password_last_changed\":1764993628}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mysql_plugin\n-------------------------------------\n\nA plugin can be installed with the mysql_plugin utility if the server is\ncompletely offline.\n\nThe syntax is:\n\nmysql_plugin [options] <plugin> ENABLE|DISABLE\n\nFor example, to install the server_audit audit plugin, you could execute the\nfollowing:\n\nmysql_plugin server_audit ENABLE\n\nIf a plugin is installed with this utility, then a record will be added to the\nmysql.plugins table for the plugin. This means that the plugin will\nautomatically be loaded every time the server restarts, unless specifically\nuninstalled or deactivated.\n\nConfiguring the Plugin Directory\n--------------------------------\n\nWhen a plugin is being installed, the server looks for the plugin\'s library in\nthe server\'s plugin directory. This directory is configured by the plugin_dir\nsystem variable. This can be specified as a command-line argument to mysqld or\nit can be specified in a relevant server option group in an option file. For\nexample:\n\n[mariadb]\n...\nplugin_dir = /usr/lib64/mysql/plugin\n\nConfiguring the Minimum Plugin Maturity\n---------------------------------------\n\nWhen a plugin is being installed, the server compares the plugin\'s maturity\nlevel against the server\'s minimum allowed plugin maturity. This can help\nprevent users from using unstable plugins on production servers. This minimum\nplugin maturity is configured by the plugin_maturity system variable. This can\nbe specified as a command-line argument to mysqld or it can be specified in a\nrelevant server option group in an option file. For example:\n\n[mariadb]\n...\nplugin_maturity = stable\n\nConfiguring Plugin Activation at Server Startup\n-----------------------------------------------\n\nA plugin will be loaded by default when the server starts if:\n\n* The plugin was installed with the INSTALL SONAME statement.\n* The plugin was installed with the INSTALL PLUGIN statement.\n* The plugin was installed with the mysql_plugin utility.\n* The server is configured to load the plugin with the --plugin-load-add\noption.\n* The server is configured to load the plugin with the --plugin-load option.\n\nThis behavior can be changed with special options that take the form\n--plugin-name. For example, for the server_audit audit plugin, the special\noption is called --server-audit.\n\nThe possible values for these special options are:\n\n+---------------------------------------+------------------------------------+\n| Option Value                          | Description                        |\n+---------------------------------------+------------------------------------+\n| OFF                                   | Disables the plugin without        |\n|                                       | removing it from the               |\n|                                       | mysql.plugins table.               |\n+---------------------------------------+------------------------------------+\n| ON                                    | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will still continue         |\n|                                       | starting up, but the plugin will   |\n|                                       | be disabled.                       |\n+---------------------------------------+------------------------------------+\n| FORCE                                 | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error.                             |\n+---------------------------------------+------------------------------------+\n| FORCE_PLUS_PERMANENT                  | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error. In addition, the plugin     |\n|                                       | cannot be uninstalled with         |\n|                                       | UNINSTALL SONAME or UNINSTALL      |\n|                                       | PLUGIN while the server is         |\n|                                       | running.                           |\n+---------------------------------------+------------------------------------+\n\nA plugin\'s status can be found by looking at the PLUGIN_STATUS column of the\ninformation_schema.PLUGINS table.\n\nUninstalling Plugins\n--------------------\n\nPlugins that are found in the mysql.plugin table, that is those that were\ninstalled with INSTALL SONAME, INSTALL PLUGIN or mysql_plugin can be\nuninstalled in one of two ways:\n\n* The UNINSTALL SONAME or the UNINSTALL PLUGIN statement while the server is\nrunning\n* With mysql_plugin while the server is offline.\n\nPlugins that were enabled as a --plugin-load option do not need to be\nuninstalled. If --plugin-load is omitted the next time the server starts, or\nthe plugin is not listed as one of the --plugin-load entries, the plugin will\nnot be loaded.\n\nUNINSTALL PLUGIN uninstalls a single installed plugin, while UNINSTALL SONAME\nuninstalls all plugins belonging to a given library.\n\nURL: https://mariadb.com/kb/en/plugin-overview/','','https://mariadb.com/kb/en/plugin-overview/'),(79,'MBR Definition',6,'Description\n-----------\n\nThe MBR (Minimum Bounding Rectangle), or Envelope is the bounding geometry,\nformed by the minimum and maximum (X,Y) coordinates:\n\nExamples\n--------\n\n((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nURL: https://mariadb.com/kb/en/mbr-definition/','','https://mariadb.com/kb/en/mbr-definition/'),(80,'MBRContains',6,'Syntax\n------\n\nMBRContains(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\ncontains the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\n\nSET @g2 = GeomFromText(\'Point(1 1)\');\n\nSELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n+----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrcontains/','','https://mariadb.com/kb/en/mbrcontains/'),(82,'MBREqual',6,'Syntax\n------\n\nMBREqual(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are the same.\n\nExamples\n--------\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 2)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 2, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 3)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 4, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 0 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/mbrequal/','','https://mariadb.com/kb/en/mbrequal/'),(86,'MBRWithin',6,'Syntax\n------\n\nMBRWithin(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1 is\nwithin the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRContains().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nSELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n\nURL: https://mariadb.com/kb/en/mbrwithin/','','https://mariadb.com/kb/en/mbrwithin/'),(75,'UNINSTALL PLUGIN',5,'Syntax\n------\n\nUNINSTALL PLUGIN [IF EXISTS] plugin_name\n\nDescription\n-----------\n\nThis statement removes a single installed plugin. To uninstall the whole\nlibrary which contains the plugin, use UNINSTALL SONAME. You cannot uninstall\na plugin if any table that uses it is open.\n\nplugin_name must be the name of some plugin that is listed in the mysql.plugin\ntable. The server executes the plugin\'s deinitialization function and removes\nthe row for the plugin from the mysql.plugin table, so that subsequent server\nrestarts will not load and initialize the plugin. UNINSTALL PLUGIN does not\nremove the plugin\'s shared library file.\n\nTo use UNINSTALL PLUGIN, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nUNINSTALL PLUGIN example;\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------+\n| Level | Code | Message                       |\n+-------+------+-------------------------------+\n| Note  | 1305 | PLUGIN example does not exist |\n+-------+------+-------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-plugin/','','https://mariadb.com/kb/en/uninstall-plugin/'),(76,'INSTALL SONAME',5,'Syntax\n------\n\nINSTALL SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of INSTALL PLUGIN. It installs all plugins from a\ngiven plugin_library. See INSTALL PLUGIN for details.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL SONAME adds one or more lines to the mysql.plugin table that describes\nthe plugin. This table contains the plugin name and library file name.\n\nINSTALL SONAME causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL SONAME also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL SONAME, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nSONAME only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nIf you need to install only one plugin from a library, use the INSTALL PLUGIN\nstatement.\n\nExamples\n--------\n\nTo load the XtraDB storage engine and all of its information_schema tables\nwith one statement, use\n\nINSTALL SONAME \'ha_xtradb\';\n\nThis statement can be used instead of INSTALL PLUGIN even when the library\ncontains only one plugin:\n\nINSTALL SONAME \'ha_sequence\';\n\nURL: https://mariadb.com/kb/en/install-soname/','','https://mariadb.com/kb/en/install-soname/'),(77,'UNINSTALL SONAME',5,'Syntax\n------\n\nUNINSTALL SONAME  [IF EXISTS] \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of UNINSTALL PLUGIN statement, that removes all\nplugins belonging to a specified plugin_library. See UNINSTALL PLUGIN for\ndetails.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nTo use UNINSTALL SONAME, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin library does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nTo uninstall the XtraDB plugin and all of its information_schema tables with\none statement, use\n\nUNINSTALL SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------------+\n| Level | Code | Message                             |\n+-------+------+-------------------------------------+\n| Note  | 1305 | SONAME ha_example.so does not exist |\n+-------+------+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-soname/','','https://mariadb.com/kb/en/uninstall-soname/'),(90,'NULLIF',7,'Syntax\n------\n\nNULLIF(expr1,expr2)\n\nDescription\n-----------\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is the\nsame as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nExamples\n--------\n\nSELECT NULLIF(1,1);\n+-------------+\n| NULLIF(1,1) |\n+-------------+\n|        NULL |\n+-------------+\n\nSELECT NULLIF(1,2);\n+-------------+\n| NULLIF(1,2) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/nullif/','','https://mariadb.com/kb/en/nullif/'),(91,'NVL',7,'MariaDB starting with 10.3\n--------------------------\nFrom MariaDB 10.3, NVL is a synonym for IFNULL.\n\nURL: https://mariadb.com/kb/en/nvl/','','https://mariadb.com/kb/en/nvl/'),(92,'NVL2',7,'MariaDB starting with 10.3\n--------------------------\nThe NLV2 function was introduced in MariaDB 10.3.0.\n\nSyntax\n------\n\nNVL2(expr1,expr2,expr3)\n\nDescription\n-----------\n\nThe NVL2 function returns a value based on whether a specified expression is\nNULL or not. If expr1 is not NULL, then NVL2 returns expr2. If expr1 is NULL,\nthen NVL2 returns expr3.\n\nExamples\n--------\n\nSELECT NVL2(NULL,1,2);\n+----------------+\n| NVL2(NULL,1,2) |\n+----------------+\n|              2 |\n+----------------+\n\nSELECT NVL2(\'x\',1,2);\n+---------------+\n| NVL2(\'x\',1,2) |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/nvl2/','','https://mariadb.com/kb/en/nvl2/'),(81,'MBRDisjoint',6,'Syntax\n------\n\nMBRDisjoint(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are disjoint. Two geometries are disjoint if they do not\nintersect, that is touch or overlap.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECTmbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrdisjoint/','','https://mariadb.com/kb/en/mbrdisjoint/'),(83,'MBRIntersects',6,'Syntax\n------\n\nMBRIntersects(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 intersect.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      1 |\n+------------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      0 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/mbrintersects/','','https://mariadb.com/kb/en/mbrintersects/'),(84,'MBROverlaps',6,'Syntax\n------\n\nMBROverlaps(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 overlap. The term spatially overlaps is used if two\ngeometries intersect and their intersection results in a geometry of the same\ndimension but not equal to either of the given geometries.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbroverlaps/','','https://mariadb.com/kb/en/mbroverlaps/'),(85,'MBRTouches',6,'Syntax\n------\n\nMBRTouches(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 touch. Two geometries spatially touch if the interiors of\nthe geometries do not intersect, but the boundary of one of the geometries\nintersects either the boundary or the interior of the other.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   1 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/mbrtouches/','','https://mariadb.com/kb/en/mbrtouches/'),(87,'CASE OPERATOR',7,'Syntax\n------\n\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nDescription\n-----------\n\nThe first version returns the result where value=compare_value. The second\nversion returns the result for the first condition that is true. If there was\nno matching result value, the result after ELSE is returned, or NULL if there\nis no ELSE part.\n\nThere is also a CASE statement, which differs from the CASE operator described\nhere.\n\nExamples\n--------\n\nSELECT CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END;\n+------------------------------------------------------------+\n| CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END |\n+------------------------------------------------------------+\n| one                                                        |\n+------------------------------------------------------------+\n\nSELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n+--------------------------------------------+\n| CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END |\n+--------------------------------------------+\n| true                                       |\n+--------------------------------------------+\n\nSELECT CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n+-----------------------------------------------------+\n| CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END |\n+-----------------------------------------------------+\n|                                                NULL |\n+-----------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/case-operator/','','https://mariadb.com/kb/en/case-operator/'),(101,'UNLOCK TABLES',8,'Syntax\n------\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\nSee LOCK TABLES for more information.\n\nIn addition to releasing table locks acquired by the LOCK TABLES statement,\nthe UNLOCK TABLES statement also releases the global read lock acquired by the\nFLUSH TABLES WITH READ LOCK statement. The FLUSH TABLES WITH READ LOCK\nstatement is very useful for performing backups. See FLUSH for more\ninformation about FLUSH TABLES WITH READ LOCK.\n\nURL: https://mariadb.com/kb/en/transactions-unlock-tables/','','https://mariadb.com/kb/en/transactions-unlock-tables/'),(103,'XA Transactions',8,'Overview\n--------\n\nThe MariaDB XA implementation is based on the X/Open CAE document Distributed\nTransaction Processing: The XA Specification. This document is published by\nThe Open Group and available at\nhttp://www.opengroup.org/public/pubs/catalog/c193.htm.\n\nXA transactions are designed to allow distributed transactions, where a\ntransaction manager (the application) controls a transaction which involves\nmultiple resources. Such resources are usually DBMSs, but could be resources\nof any type. The whole set of required transactional operations is called a\nglobal transaction. Each subset of operations which involve a single resource\nis called a local transaction. XA used a 2-phases commit (2PC). With the first\ncommit, the transaction manager tells each resource to prepare an effective\ncommit, and waits for a confirm message. The changes are not still made\neffective at this point. If any of the resources encountered an error, the\ntransaction manager will rollback the global transaction. If all resources\ncommunicate that the first commit is successful, the transaction manager can\nrequire a second commit, which makes the changes effective.\n\nIn MariaDB, XA transactions can only be used with storage engines that support\nthem. At least InnoDB, TokuDB, SPIDER and MyRocks support them. For InnoDB,\nuntil MariaDB 10.2, XA transactions can be disabled by setting the\ninnodb_support_xa server system variable to 0. From MariaDB 10.3, XA\ntransactions are always supported.\n\nLike regular transactions, XA transactions create metadata locks on accessed\ntables.\n\nXA transactions require REPEATABLE READ as a minimum isolation level. However,\ndistributed transactions should always use SERIALIZABLE.\n\nTrying to start more than one XA transaction at the same time produces a 1400\nerror (SQLSTATE \'XAE09\'). The same error is produced when attempting to start\nan XA transaction while a regular transaction is in effect. Trying to start a\nregular transaction while an XA transaction is in effect produces a 1399 error\n(SQLSTATE \'XAE07\').\n\nThe statements that cause an implicit COMMIT for regular transactions produce\na 1400 error (SQLSTATE \'XAE09\') if a XA transaction is in effect.\n\nInternal XA vs External XA\n--------------------------\n\nXA transactions are an overloaded term in MariaDB. If a storage engine is\nXA-capable, it can mean one or both of these:\n\n* It supports MariaDB\'s internal two-phase commit API. This is transparent to\nthe user. Sometimes this is called \"internal XA\", since MariaDB\'s internal\ntransaction coordinator log can handle coordinating these transactions.\n\n* It supports XA transactions, with the XA START, XA PREPARE, XA COMMIT, etc.\nstatements. Sometimes this is called \"external XA\", since it requires the use\nof an external transaction coordinator to use this feature properly.\n\nTransaction Coordinator Log\n---------------------------\n\nIf you have two or more XA-capable storage engines enabled, then a transaction\ncoordinator log must be available.\n\nThere are currently two implementations of the transaction coordinator log:\n\n* Binary log-based transaction coordinator log\n* Memory-mapped file-based transaction coordinator log\n\nIf the binary log is enabled on a server, then the server will use the binary\nlog-based transaction coordinator log. Otherwise, it will use the\nmemory-mapped file-based transaction coordinator log.\n\nSee Transaction Coordinator Log for more information.\n\nSyntax\n------\n\nXA {START|BEGIN} xid [JOIN|RESUME]\n\nXA END xid [SUSPEND [FOR MIGRATE]]\n\nXA PREPARE xid\n\nXA COMMIT xid [ONE PHASE]\n\nXA ROLLBACK xid\n\nXA RECOVER [FORMAT=[\'RAW\'|\'SQL\']]\n\nxid: gtrid [, bqual [, formatID ]]\n\nThe interface to XA transactions is a set of SQL statements starting with XA.\nEach statement changes a transaction\'s state, determining which actions it can\nperform. A transaction which does not exist is in the NON-EXISTING state.\n\nXA START (or BEGIN) starts a transaction and defines its xid (a transaction\nidentifier). The JOIN or RESUME keywords have no effect. The new transaction\nwill be in ACTIVE state.\n\nThe xid can have 3 components, though only the first one is mandatory. gtrid\nis a quoted string representing a global transaction identifier. bqual is a\nquoted string representing a local transaction identifier. formatID is an\nunsigned integer indicating the format used for the first two components; if\nnot specified, defaults to 1. MariaDB does not interpret in any way these\ncomponents, and only uses them to identify a transaction. xids of transactions\nin effect must be unique.\n\nXA END declares that the specified ACTIVE transaction is finished and it\nchanges its state to IDLE. SUSPEND [FOR MIGRATE] has no effect.\n\nXA PREPARE prepares an IDLE transaction for commit, changing its state to\nPREPARED. This is the first commit.\n\nXA COMMIT definitely commits and terminates a transaction which has already\nbeen PREPARED. If the ONE PHASE clause is specified, this statements performs\na 1-phase commit on an IDLE transaction.\n\nXA ROLLBACK rolls back and terminates an IDLE or PREPARED transaction.\n\nXA RECOVER shows information about all PREPARED transactions.\n\nWhen trying to execute an operation which is not allowed for the transaction\'s\ncurrent state, an error is produced:\n\nXA COMMIT \'test\' ONE PHASE;\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  ACTIVE state\n\nXA COMMIT \'test2\';\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  NON-EXISTING state\n\nXA RECOVER\n----------\n\nThe XA RECOVER statement shows information about all transactions which are in\nthe PREPARED state. It does not matter which connection created the\ntransaction: if it has been PREPARED, it appears. But this does not mean that\na connection can commit or rollback a transaction which was started by another\nconnection. Note that transactions using a 1-phase commit are never in the\nPREPARED state, so they cannot be shown by XA RECOVER.\n\nXA RECOVER produces four columns:\n\nXA RECOVER;\n+----------+--------------+--------------+------+\n| formatID | gtrid_length | bqual_length | data |\n+----------+--------------+--------------+------+\n|        1 |            4 |            0 | test |\n+----------+--------------+--------------+------+\n\nMariaDB starting with 10.3.3\n----------------------------\nYou can use XA RECOVER FORMAT=\'SQL\' to get the data in a human readable form\nthat can be directly copy-pasted into XA COMMIT or XA ROLLBACK. This is\nparticularly useful for binary xid generated by some transaction coordinators.\n\nformatID is the formatID part of xid.\n\ndata are the gtrid and bqual parts of xid, concatenated.\n\ngtrid_length and bqual_length are the lengths of gtrid and bqual, respectevely.\n\nExamples\n--------\n\n2-phases commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA PREPARE \'test\';\n\nXA COMMIT \'test\';\n\n1-phase commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA COMMIT \'test\' ONE PHASE;\n\nHuman-readable:\n\nxa start \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\ninsert t1 values (40);\n\nxa end \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa prepare \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa recover format=\'RAW\';\n+----------+--------------+--------------+--------------------+\n| formatID | gtrid_length | bqual_length | data               |\n+----------+--------------+--------------+--------------------+\n34      67v78abc       11 |            7 | 12\ndef |\n+----------+--------------+--------------+--------------------+\n\nxa recover format=\'SQL\';\n+----------+--------------+--------------+-------------------------------------\n---------+\n| formatID | gtrid_length | bqual_length | data                               \n     |\n+----------+--------------+--------------+-------------------------------------\n---------+\n|        3 |           11 |            7 |\nX\'31320d3334093637763738\',X\'6162630a646566\',3 |\n+----------+--------------+--------------+-------------------------------------\n---------+\n\nxa rollback X\'31320d3334093637763738\',X\'6162630a646566\',3;\n\nKnown Issues\n------------\n\nMariaDB Galera Cluster\n----------------------\n\nMariaDB Galera Cluster does not support XA transactions.\n\nHowever, MariaDB Galera Cluster builds include a built-in plugin called wsrep.\nPrior to MariaDB 10.4.3, this plugin was internally considered an XA-capable\nstorage engine. Consequently, these MariaDB Galera Cluster builds have\nmultiple XA-capable storage engines by default, even if the only \"real\"\nstorage engine that supports external XA transactions enabled on these builds\nby default is InnoDB. Therefore, when using one these builds MariaDB would be\nforced to use a transaction coordinator log by default, which could have\nperformance implications.\n\nSee Transaction Coordinator Log Overview: MariaDB Galera Cluster for more\ninformation.\n\nURL: https://mariadb.com/kb/en/xa-transactions/','','https://mariadb.com/kb/en/xa-transactions/'),(104,'CREATE USER',10,'Syntax\n------\n\nCREATE [OR REPLACE] USER [IF NOT EXISTS] \n user_specification [,user_specification ...] \n [REQUIRE {NONE | tls_option [[AND] tls_option ...] }]\n [WITH resource_option [resource_option ...] ]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR cou