/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('96fa4b08-59b1-4042-b392-74eb2da028d1','2026-01-23 18:21:56','2026-01-23 18:21:56',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','f220327b-7fc1-48ea-a468-10610fb4c2e7','2026-01-23 18:21:46','2026-01-23 18:21:46',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('f220327b-7fc1-48ea-a468-10610fb4c2e7','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2026-01-23 18:21:46','2026-01-23 18:21:46',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2026-01-23 18:21:44',NULL,NULL,0,1,'default','volumes',10),('2026-01-23 18:21:44',NULL,NULL,0,2,'default','snapshots',10),('2026-01-23 18:21:44',NULL,NULL,0,3,'default','gigabytes',1000),('2026-01-23 18:21:44',NULL,NULL,0,4,'default','consistencygroups',10),('2026-01-23 18:21:44',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2026-01-23 18:21:44',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2026-01-23 18:21:56','2026-01-23 19:24:41',NULL,0,1,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',372,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'c40d9718-2ed3-4e22-a9a6-0468be822504'),('2026-01-23 18:54:18','2026-01-23 19:24:42',NULL,0,2,'hostgroup@ceph','cinder-volume','cinder-volume',182,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'589f6d41-9678-4553-971f-f3533688403c'),('2026-01-23 18:54:19','2026-01-23 19:24:42',NULL,0,3,'cinder-backup-0','cinder-backup','cinder-backup',182,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'e45eff99-1080-4753-b6b5-f3a39fbe9f64');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2026-01-23 18:21:46','2026-01-23 18:21:46',NULL,0,'df8f8812-4819-40f0-8495-52062f4b3d31','__DEFAULT__',NULL,1,'Default Volume Type');
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2026-01-23 18:21:46','2026-01-23 18:21:46.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'6c18dec6-2f84-4af3-8fb2-bcd04b34c330','rbd://4da2adac-d096-5ead-9ec5-3108259ba9e4/images/6c18dec6-2f84-4af3-8fb2-bcd04b34c330/snap','2026-01-23 18:59:32','2026-01-23 18:59:32',NULL,0,'{\"store\": \"default_backend\"}','active'),(2,'4b46ff04-fd60-4584-abad-c756e0e7388c','rbd://4da2adac-d096-5ead-9ec5-3108259ba9e4/images/4b46ff04-fd60-4584-abad-c756e0e7388c/snap','2026-01-23 18:59:34','2026-01-23 18:59:34',NULL,0,'{\"store\": \"default_backend\"}','active');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'6c18dec6-2f84-4af3-8fb2-bcd04b34c330','hw_rng_model','virtio','2026-01-23 18:59:28','2026-01-23 18:59:28',NULL,0),(2,'4b46ff04-fd60-4584-abad-c756e0e7388c','hw_rng_model','virtio','2026-01-23 18:59:33','2026-01-23 18:59:33',NULL,0);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('4b46ff04-fd60-4584-abad-c756e0e7388c','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2026-01-23 18:59:33','2026-01-23 18:59:34',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','03b69a8a6d0b48389cffb70904385997',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('6c18dec6-2f84-4af3-8fb2-bcd04b34c330','cirros-0.6.2-x86_64-disk.img',21430272,'active','2026-01-23 18:59:28','2026-01-23 18:59:32',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','03b69a8a6d0b48389cffb70904385997',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b');
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2026-01-23 18:20:35',NULL),(1,2,'image','CIM_RASD_','2026-01-23 18:20:35',NULL),(1,3,NULL,'CIM_SASD_','2026-01-23 18:20:35',NULL),(1,9,'image','hw_','2026-01-23 18:20:35',NULL),(1,10,'image','hw_','2026-01-23 18:20:35',NULL),(1,14,'image',NULL,'2026-01-23 18:20:36',NULL),(1,19,'image','hw_','2026-01-23 18:20:36',NULL),(1,25,'image','hw_','2026-01-23 18:20:36',NULL),(1,29,'image',NULL,'2026-01-23 18:20:36',NULL),(1,30,'image',NULL,'2026-01-23 18:20:36',NULL),(1,31,'image',NULL,'2026-01-23 18:20:37',NULL),(1,32,'image',NULL,'2026-01-23 18:20:37',NULL),(2,1,NULL,'CIM_PASD_','2026-01-23 18:20:35',NULL),(2,8,NULL,'hw_','2026-01-23 18:20:35',NULL),(2,9,NULL,'hw_','2026-01-23 18:20:35',NULL),(2,10,NULL,'hw_','2026-01-23 18:20:35',NULL),(2,11,NULL,NULL,'2026-01-23 18:20:35',NULL),(2,13,NULL,NULL,'2026-01-23 18:20:36',NULL),(2,14,NULL,NULL,'2026-01-23 18:20:36',NULL),(2,15,NULL,NULL,'2026-01-23 18:20:36',NULL),(2,16,NULL,'hw_','2026-01-23 18:20:36',NULL),(2,19,NULL,'hw_','2026-01-23 18:20:36',NULL),(2,22,NULL,NULL,'2026-01-23 18:20:36',NULL),(2,23,NULL,'hw_','2026-01-23 18:20:36',NULL),(2,24,NULL,'traits:','2026-01-23 18:20:36',NULL),(2,25,NULL,'hw_','2026-01-23 18:20:36',NULL),(2,26,NULL,NULL,'2026-01-23 18:20:36',NULL),(2,28,NULL,NULL,'2026-01-23 18:20:36',NULL),(2,29,NULL,NULL,'2026-01-23 18:20:36',NULL),(2,30,NULL,NULL,'2026-01-23 18:20:36',NULL),(2,31,NULL,NULL,'2026-01-23 18:20:37',NULL),(2,32,NULL,NULL,'2026-01-23 18:20:37',NULL),(2,33,NULL,'cinder_','2026-01-23 18:20:37',NULL),(3,1,NULL,'CIM_PASD_','2026-01-23 18:20:35',NULL),(3,2,NULL,'CIM_RASD_','2026-01-23 18:20:35',NULL),(3,3,NULL,'CIM_SASD_','2026-01-23 18:20:35',NULL),(3,4,NULL,'CIM_VSSD_','2026-01-23 18:20:35',NULL),(3,5,NULL,NULL,'2026-01-23 18:20:35',NULL),(3,6,NULL,NULL,'2026-01-23 18:20:35',NULL),(3,7,NULL,NULL,'2026-01-23 18:20:35',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2026-01-23 18:20:35',NULL),(4,1,NULL,'CIM_PASD_','2026-01-23 18:20:35',NULL),(4,2,NULL,'CIM_RASD_','2026-01-23 18:20:35',NULL),(4,3,NULL,'CIM_SASD_','2026-01-23 18:20:35',NULL),(4,4,NULL,'CIM_VSSD_','2026-01-23 18:20:35',NULL),(4,8,NULL,'hw:','2026-01-23 18:20:35',NULL),(4,9,NULL,'hw:','2026-01-23 18:20:35',NULL),(4,10,NULL,'hw:','2026-01-23 18:20:35',NULL),(4,12,NULL,'capabilities:','2026-01-23 18:20:35',NULL),(4,16,NULL,'hw:','2026-01-23 18:20:36',NULL),(4,17,NULL,NULL,'2026-01-23 18:20:36',NULL),(4,18,NULL,NULL,'2026-01-23 18:20:36',NULL),(4,19,NULL,'hw:','2026-01-23 18:20:36',NULL),(4,20,NULL,NULL,'2026-01-23 18:20:36',NULL),(4,21,NULL,NULL,'2026-01-23 18:20:36',NULL),(4,23,NULL,'hw:','2026-01-23 18:20:36',NULL),(4,24,NULL,'traits:','2026-01-23 18:20:36',NULL),(4,25,NULL,'hw:','2026-01-23 18:20:36',NULL),(5,1,'scheduler_hints',NULL,'2026-01-23 18:20:35',NULL),(5,30,'metadata',NULL,'2026-01-23 18:20:36',NULL),(5,31,'metadata',NULL,'2026-01-23 18:20:37',NULL),(5,32,'metadata',NULL,'2026-01-23 18:20:37',NULL),(6,30,NULL,NULL,'2026-01-23 18:20:36',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2026-01-23 18:20:35',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2026-01-23 18:20:35',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2026-01-23 18:20:35',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2026-01-23 18:20:35',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-01-23 18:20:35',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-01-23 18:20:35',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2026-01-23 18:20:35',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2026-01-23 18:20:35',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2026-01-23 18:20:35',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2026-01-23 18:20:35',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2026-01-23 18:20:35',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2026-01-23 18:20:35',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2026-01-23 18:20:36',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2026-01-23 18:20:36',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-23 18:20:36',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-23 18:20:36',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-23 18:20:36',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2026-01-23 18:20:36',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2026-01-23 18:20:36',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-23 18:20:36',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-23 18:20:36',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-23 18:20:36',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2026-01-23 18:20:36',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2026-01-23 18:20:36',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-23 18:20:36',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-23 18:20:36',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2026-01-23 18:20:36',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2026-01-23 18:20:36',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2026-01-23 18:20:36',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2026-01-23 18:20:36',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2026-01-23 18:20:36',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2026-01-23 18:20:37',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2026-01-23 18:20:37',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2026-01-23 18:20:36',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2026-01-23 18:20:36',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2026-01-23 18:20:36',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2026-01-23 18:20:36',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2026-01-23 18:20:36',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2026-01-23 18:20:36',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2026-01-23 18:20:36',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-23 18:20:36',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-23 18:20:36',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-01-23 18:20:36',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-01-23 18:20:36',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-23 18:20:36',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2026-01-23 18:20:36',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2026-01-23 18:20:36',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2026-01-23 18:20:36',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2026-01-23 18:20:37',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2026-01-23 18:20:37',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2026-01-23 18:20:37',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2026-01-23 18:20:37',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2026-01-23 18:20:37',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-23 18:20:37',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-23 18:20:37',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-23 18:20:37',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2026-01-23 18:20:35',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2026-01-23 18:20:35',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2026-01-23 18:20:35',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2026-01-23 18:20:35',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2026-01-23 18:20:35',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-01-23 18:20:35',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2026-01-23 18:20:35',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-01-23 18:20:35',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2026-01-23 18:20:35',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2026-01-23 18:20:35',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2026-01-23 18:20:35',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2026-01-23 18:20:35',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2026-01-23 18:20:35',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2026-01-23 18:20:35',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2026-01-23 18:20:35',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2026-01-23 18:20:35',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2026-01-23 18:20:35',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2026-01-23 18:20:35',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2026-01-23 18:20:35',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2026-01-23 18:20:35',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2026-01-23 18:20:35',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-23 18:20:35',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2026-01-23 18:20:35',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2026-01-23 18:20:36',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2026-01-23 18:20:36',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-23 18:20:36',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-23 18:20:36',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-23 18:20:36',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2026-01-23 18:20:36',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2026-01-23 18:20:36',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2026-01-23 18:20:36',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2026-01-23 18:20:36',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-23 18:20:36',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-01-23 18:20:36',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-01-23 18:20:36',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2026-01-23 18:20:36',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2026-01-23 18:20:36',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2026-01-23 18:20:36',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2026-01-23 18:20:36',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2026-01-23 18:20:36',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-23 18:20:36',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2026-01-23 18:20:36',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2026-01-23 18:20:36',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2026-01-23 18:20:36',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-23 18:20:36',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-23 18:20:36',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-23 18:20:36',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2026-01-23 18:20:36',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-23 18:20:36',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-23 18:20:36',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-23 18:20:36',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-23 18:20:36',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2026-01-23 18:20:36',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2026-01-23 18:20:36',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2026-01-23 18:20:36',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-01-23 18:20:36',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-01-23 18:20:36',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-01-23 18:20:36',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-01-23 18:20:36',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-01-23 18:20:36',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-01-23 18:20:36',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2026-01-23 18:20:36',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2026-01-23 18:20:36',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-23 18:20:36',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-23 18:20:36',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2026-01-23 18:20:36',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2026-01-23 18:20:36',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2026-01-23 18:20:36',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2026-01-23 18:20:36',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2026-01-23 18:20:36',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-23 18:20:36',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2026-01-23 18:20:36',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-01-23 18:20:36',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-01-23 18:20:36',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2026-01-23 18:20:36',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2026-01-23 18:20:36',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2026-01-23 18:20:36',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2026-01-23 18:20:36',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2026-01-23 18:20:36',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2026-01-23 18:20:36',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-01-23 18:20:36',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2026-01-23 18:20:36',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-01-23 18:20:36',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2026-01-23 18:20:36',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2026-01-23 18:20:36',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2026-01-23 18:20:36',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2026-01-23 18:20:36',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2026-01-23 18:20:36',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2026-01-23 18:20:36',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2026-01-23 18:20:36',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-01-23 18:20:36',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-01-23 18:20:36',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2026-01-23 18:20:36',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2026-01-23 18:20:37',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2026-01-23 18:20:35',NULL),(2,'OS::Glance::Image',1,'2026-01-23 18:20:35',NULL),(3,'OS::Nova::Aggregate',1,'2026-01-23 18:20:35',NULL),(4,'OS::Nova::Flavor',1,'2026-01-23 18:20:35',NULL),(5,'OS::Nova::Server',1,'2026-01-23 18:20:35',NULL),(6,'OS::Trove::Instance',1,'2026-01-23 18:20:36',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `external_id` (`external_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','0cd8b67b22eb44eeb37be8163da1ecc2','92bdd319f82b46e2be56c4a54357168d','03bc2f05d6d04131aa3e380d4ea0fdcd',0),('UserProject','0cd8b67b22eb44eeb37be8163da1ecc2','92bdd319f82b46e2be56c4a54357168d','7596206c139048d9b2cd8efd5dc0f1ff',0),('UserProject','2dad1823bd8c4927a0c016416e1a98fe','92bdd319f82b46e2be56c4a54357168d','03bc2f05d6d04131aa3e380d4ea0fdcd',0),('UserProject','2dad1823bd8c4927a0c016416e1a98fe','92bdd319f82b46e2be56c4a54357168d','7596206c139048d9b2cd8efd5dc0f1ff',0),('UserProject','4119423243334b86bc666820b3ac5cf0','92bdd319f82b46e2be56c4a54357168d','03bc2f05d6d04131aa3e380d4ea0fdcd',0),('UserProject','4119423243334b86bc666820b3ac5cf0','92bdd319f82b46e2be56c4a54357168d','7596206c139048d9b2cd8efd5dc0f1ff',0),('UserProject','775b59d13293427386ef89a85ae242eb','92bdd319f82b46e2be56c4a54357168d','03bc2f05d6d04131aa3e380d4ea0fdcd',0),('UserProject','775b59d13293427386ef89a85ae242eb','92bdd319f82b46e2be56c4a54357168d','df014587d4514e6cbf0e55543bab4b6a',0),('UserProject','8bc2eb15461742fb9aafbd3726295065','03b69a8a6d0b48389cffb70904385997','03bc2f05d6d04131aa3e380d4ea0fdcd',0),('UserProject','8bc2eb15461742fb9aafbd3726295065','03b69a8a6d0b48389cffb70904385997','7e140ca5ba7e487d97be4b79ac5b6bd8',0),('UserProject','8bc2eb15461742fb9aafbd3726295065','37e2e54f07464de3beb717dbff93203d','03bc2f05d6d04131aa3e380d4ea0fdcd',0),('UserProject','94db1bb83e4f4e1ebac4c99ca9c7dad6','92bdd319f82b46e2be56c4a54357168d','03bc2f05d6d04131aa3e380d4ea0fdcd',0),('UserProject','94db1bb83e4f4e1ebac4c99ca9c7dad6','92bdd319f82b46e2be56c4a54357168d','7596206c139048d9b2cd8efd5dc0f1ff',0),('UserProject','c422e27902f34c1ca768fe9634c3b2e2','92bdd319f82b46e2be56c4a54357168d','03bc2f05d6d04131aa3e380d4ea0fdcd',0),('UserProject','c422e27902f34c1ca768fe9634c3b2e2','92bdd319f82b46e2be56c4a54357168d','7596206c139048d9b2cd8efd5dc0f1ff',0),('UserProject','d4a5735653074fa8886b8853dbd6c101','92bdd319f82b46e2be56c4a54357168d','03bc2f05d6d04131aa3e380d4ea0fdcd',0),('UserProject','d4a5735653074fa8886b8853dbd6c101','92bdd319f82b46e2be56c4a54357168d','7596206c139048d9b2cd8efd5dc0f1ff',0),('UserProject','d55bec79358042d887f09f979b1641af','92bdd319f82b46e2be56c4a54357168d','03bc2f05d6d04131aa3e380d4ea0fdcd',0),('UserProject','d55bec79358042d887f09f979b1641af','92bdd319f82b46e2be56c4a54357168d','7596206c139048d9b2cd8efd5dc0f1ff',0),('UserProject','df65ad12b38c44888f8fe0e48bbf314b','92bdd319f82b46e2be56c4a54357168d','03bc2f05d6d04131aa3e380d4ea0fdcd',0),('UserProject','df65ad12b38c44888f8fe0e48bbf314b','92bdd319f82b46e2be56c4a54357168d','7596206c139048d9b2cd8efd5dc0f1ff',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('0471fa39297641b28281c1afc9839462',NULL,'internal','a7fc4ed4b27a4b519c6e2596659e2b08','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('12262ad9a5eb487b8faa62d6a9f51a78',NULL,'public','650a7caef42b4d2ab376d0e241c69547','https://manila-public-openstack.apps-crc.testing/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('15cdd78d49514ef5b25a23fc634c81b2',NULL,'internal','12666387721d4837a72d07c56438f793','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('1d7505c3a83b4254aa3b92b4f331603c',NULL,'internal','f7ceda547446472c81d8eec23142c37f','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('240f2f505d2f424e8bb9cd4f192a6c6c',NULL,'internal','1771b37da2894e55b2535f3a662db40f','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('36095c1abe994e6dbdbbf5669972cea9',NULL,'internal','650a7caef42b4d2ab376d0e241c69547','https://manila-internal.openstack.svc:8786/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('429c594a2bd04f798fb9e3ea93a45eb1',NULL,'public','4240ec9dda0545c192bc2cc1df3649d2','https://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('4e2338a8536f469bb9bc6f8eec0a896c',NULL,'internal','4240ec9dda0545c192bc2cc1df3649d2','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('50f8200be9ed48ab97d8ee94a4b3f952',NULL,'internal','1440418ba7fd4038b6b2c4e9ae3fb85c','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('56a672b522e84bf4ad170f07f6bc18c1',NULL,'public','12666387721d4837a72d07c56438f793','https://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('57c2a069011047d3ba87db30fcd6f8f6',NULL,'internal','7625561f8d974008b3a4b1e7296498ab','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('61a81d67d87a448c9e065b82f46da125',NULL,'public','a7fc4ed4b27a4b519c6e2596659e2b08','https://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('7a6961a0a2bd4f8285c26651391d5fbd',NULL,'public','1771b37da2894e55b2535f3a662db40f','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('7e5ae399b6eb45f9acab6803cd22bd18',NULL,'internal','a4cc23f332b34994b7d6a5644c2a613e','https://manila-internal.openstack.svc:8786/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('8f18f981437a4fd1a1118ec28d3643f9',NULL,'public','a4cc23f332b34994b7d6a5644c2a613e','https://manila-public-openstack.apps-crc.testing/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('a27726a619504e5fa43252e9babb61f0',NULL,'internal','4cc12bef517247b89f9e0b75fa57616e','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('c1c9ec2abd1b46df99c2eac417ac8c56',NULL,'public','f7ceda547446472c81d8eec23142c37f','https://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('c5ed1f1eaaf84569863a713a56141f16',NULL,'public','7625561f8d974008b3a4b1e7296498ab','https://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('c718fcb6175846ef96bff8a4af968356',NULL,'public','4cc12bef517247b89f9e0b75fa57616e','https://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('daf7ecbeca5b4654b5e3396eeff530a3',NULL,'public','1440418ba7fd4038b6b2c4e9ae3fb85c','https://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('03bc2f05d6d04131aa3e380d4ea0fdcd','df014587d4514e6cbf0e55543bab4b6a'),('df014587d4514e6cbf0e55543bab4b6a','31271de7f4734844adf932f948ca8b9f');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=233 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'8bc2eb15461742fb9aafbd3726295065','default','admin',0,NULL),(2,'c422e27902f34c1ca768fe9634c3b2e2','default','cinder',0,NULL),(3,'df65ad12b38c44888f8fe0e48bbf314b','default','glance',0,NULL),(4,'2dad1823bd8c4927a0c016416e1a98fe','default','nova',0,NULL),(5,'d55bec79358042d887f09f979b1641af','default','placement',0,NULL),(6,'d4a5735653074fa8886b8853dbd6c101','default','neutron',0,NULL),(7,'0cd8b67b22eb44eeb37be8163da1ecc2','default','ceilometer',0,NULL),(8,'4119423243334b86bc666820b3ac5cf0','default','barbican',0,NULL),(9,'775b59d13293427386ef89a85ae242eb','default','swift',0,NULL),(10,'94db1bb83e4f4e1ebac4c99ca9c7dad6','default','manila',0,NULL),(11,'16bb0ac6a5ab47ffb944c1fc8c9852c7','default','demo_tempestconf',0,NULL),(12,'b2ab5f1a983e4b4ab7299e3ce027859c','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=233 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$uL35Q8X/vH0AhL6M6dKb0.5JAePYwoHKTz.2JUj5X0533Xb5aU1vO',1769192459386759,NULL,'2026-01-23 18:20:59'),(2,2,NULL,0,'$2b$12$PggSOi/4B7uB53Q4YjilxekS7qR3xve6uyJBzBzZhY.PD8kj26XRq',1769192529461538,NULL,'2026-01-23 18:22:09'),(3,3,NULL,0,'$2b$12$dW.S0Rk8WXQDIj8h/oBXoOmffRY.LLFsYDcmrCbF8oTY3dZbjpftK',1769192532089033,NULL,'2026-01-23 18:22:12'),(4,4,NULL,0,'$2b$12$CzMswxWwleTBjWJ8XDjcM.mqzz1Td1491M0kiCoHOGUNjwqAzRgLS',1769192534545898,NULL,'2026-01-23 18:22:14'),(5,5,NULL,0,'$2b$12$ogsq7zwjthi3j2JC2Tg7nuJqa4U27uto.UYleRqtZwQ2H/U1ofW4y',1769192537573144,NULL,'2026-01-23 18:22:17'),(6,6,NULL,0,'$2b$12$UxPX/61Ia8iYqnzmyFDcpO8qpc7VJrZnta7usCNqoWdmXqUcRYQwm',1769192540352616,NULL,'2026-01-23 18:22:20'),(7,7,NULL,0,'$2b$12$YL2uIZ.7Uj3gBvj8uVwlSuNIpRv2DCrdyeHd7zU.iRc9lkHACMS36',1769192542942189,NULL,'2026-01-23 18:22:22'),(8,8,NULL,0,'$2b$12$pIiDotpvlhkejkgqPdMKh.42YolNI7v4S11UWVtY9nJxbxAQcs21W',1769192545027568,NULL,'2026-01-23 18:22:25'),(9,9,NULL,0,'$2b$12$ZnFmJGxKDFmlhqz0wGU5POR96NJsieMN.xckt9kFE3WYPcTyzIcWq',1769193406863283,NULL,'2026-01-23 18:36:46'),(10,10,NULL,0,'$2b$12$IWxppJJRDWfAhW8j/uxf1.WAskLqiIrI53uPP4F3T4h7wBDqsxb72',1769194512465269,NULL,'2026-01-23 18:55:12'),(11,11,NULL,0,'$2b$12$AV82eXLPEzwvUXProBcbduGURUhgtIxXDDU/9SVOUQNL0.KViEihy',1769194667620151,NULL,'2026-01-23 18:57:47'),(12,12,NULL,0,'$2b$12$NyawQ0L2DCZIzEd0cMpUiu42QmXh0VlH.xXX9JgiQscBNEPtcqG2C',1769194668215917,NULL,'2026-01-23 18:57:48');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('03b69a8a6d0b48389cffb70904385997','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0),('37e2e54f07464de3beb717dbff93203d','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('816c197577a445e1815734cd206a12b2','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('92bdd319f82b46e2be56c4a54357168d','service','{}','service',1,'default','default',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=395 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,'6d2d75dc2d794b45933c57b75f848570',NULL,NULL,NULL,NULL,'2026-01-23 18:59:57',NULL,'2026-01-23 18:59:57',NULL,NULL),(2,NULL,NULL,'66215d31c8374f079f2d0e4001fe5695',NULL,NULL,NULL,NULL,'2026-01-23 18:59:57',NULL,'2026-01-23 18:59:57',NULL,NULL),(3,NULL,NULL,'06a3e3e1a3834663b95a7b4d0055ac2b',NULL,NULL,NULL,NULL,'2026-01-23 18:59:57',NULL,'2026-01-23 18:59:57',NULL,NULL),(4,NULL,NULL,'4135193e051b4da488a637813fa089aa',NULL,NULL,NULL,NULL,'2026-01-23 18:59:58',NULL,'2026-01-23 18:59:58',NULL,NULL),(5,NULL,'52d4309d2d504d8b825dc0e84c8654e1',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:00:00',NULL,'2026-01-23 19:00:00',NULL,NULL),(6,NULL,NULL,'3d4fcfd8c2114f4684e31dc1de88729d',NULL,NULL,NULL,NULL,'2026-01-23 19:00:04',NULL,'2026-01-23 19:00:04',NULL,NULL),(7,NULL,'0a4663889f4f47daacce04a8e4030117',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:00:04',NULL,'2026-01-23 19:00:04',NULL,NULL),(8,NULL,NULL,'9eb57eff73284ab386f11ebeac59f114',NULL,NULL,NULL,NULL,'2026-01-23 19:00:04',NULL,'2026-01-23 19:00:04',NULL,NULL),(9,NULL,'45da306d940c4000a74c2e2f1dc303db',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:00:06',NULL,'2026-01-23 19:00:06',NULL,NULL),(10,NULL,NULL,'c7f4c9eab4a846d8ba82be247d01f746',NULL,NULL,NULL,NULL,'2026-01-23 19:00:08',NULL,'2026-01-23 19:00:08',NULL,NULL),(11,NULL,NULL,'0361eac1cf1f4ea988334968d9451f2f',NULL,NULL,NULL,NULL,'2026-01-23 19:00:08',NULL,'2026-01-23 19:00:08',NULL,NULL),(12,NULL,NULL,'fe4bef7f11184042b5e32df18701003e',NULL,NULL,NULL,NULL,'2026-01-23 19:00:08',NULL,'2026-01-23 19:00:08',NULL,NULL),(13,NULL,'3f38697b55014585bfbeb92f42a147ef',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:00:10',NULL,'2026-01-23 19:00:10',NULL,NULL),(14,NULL,'0e54bd0b3225437da16cf2e5beb5146a',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:00:10',NULL,'2026-01-23 19:00:10',NULL,NULL),(15,NULL,'3d19092b341b4b11bb951b35f4435520',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:00:11',NULL,'2026-01-23 19:00:11',NULL,NULL),(16,NULL,NULL,'9609802a67f54f2db3ce87658c329a18',NULL,NULL,NULL,NULL,'2026-01-23 19:00:12',NULL,'2026-01-23 19:00:12',NULL,NULL),(17,NULL,NULL,'0795a54f77a74c43826f8b3c9e89d38a',NULL,NULL,NULL,NULL,'2026-01-23 19:00:12',NULL,'2026-01-23 19:00:12',NULL,NULL),(18,NULL,NULL,'d1d451d7e0e64bd3b447c74b97e73217',NULL,NULL,NULL,NULL,'2026-01-23 19:00:12',NULL,'2026-01-23 19:00:12',NULL,NULL),(19,NULL,'9862921f574848afbbb3400c1e97df9b',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:00:13',NULL,'2026-01-23 19:00:13',NULL,NULL),(20,NULL,NULL,'b33aec4472214e0d9f8f2c09d6be11f6',NULL,NULL,NULL,NULL,'2026-01-23 19:00:13',NULL,'2026-01-23 19:00:13',NULL,NULL),(21,NULL,'467b2408297b42be8cd4d2672763afc5',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:00:14',NULL,'2026-01-23 19:00:14',NULL,NULL),(22,NULL,'75464f02dab24436a4d51d2f6a25f049',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:00:15',NULL,'2026-01-23 19:00:15',NULL,NULL),(23,NULL,'91991deea63743aea683dc7e4ded5161',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:00:16',NULL,'2026-01-23 19:00:16',NULL,NULL),(24,NULL,NULL,'db5d0400ca534fac87fb3bfce8f373c8',NULL,NULL,NULL,NULL,'2026-01-23 19:00:18',NULL,'2026-01-23 19:00:18',NULL,NULL),(25,NULL,NULL,'0f3e9c00691c4b379dd9f659aa456bb9',NULL,NULL,NULL,NULL,'2026-01-23 19:00:19',NULL,'2026-01-23 19:00:19',NULL,NULL),(26,NULL,NULL,'e7ddfb858cab40888dc0c078e9ae2c56',NULL,NULL,NULL,NULL,'2026-01-23 19:00:20',NULL,'2026-01-23 19:00:20',NULL,NULL),(27,NULL,'efe162ce112a4953b7ac61ccd05cc160',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:00:20',NULL,'2026-01-23 19:00:20',NULL,NULL),(28,NULL,'283c7d9c543240c496f74d94af98ee9a',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:00:21',NULL,'2026-01-23 19:00:21',NULL,NULL),(29,NULL,NULL,'fdccbfb497384ac989a47ca2556034ca',NULL,NULL,NULL,NULL,'2026-01-23 19:00:22',NULL,'2026-01-23 19:00:22',NULL,NULL),(30,NULL,NULL,'6388e13bcc3d499f887298aaa889fa23',NULL,NULL,NULL,NULL,'2026-01-23 19:00:22',NULL,'2026-01-23 19:00:22',NULL,NULL),(31,NULL,NULL,'0a1ed3fdb60143ebba79a14d73e95bde',NULL,NULL,NULL,NULL,'2026-01-23 19:00:22',NULL,'2026-01-23 19:00:22',NULL,NULL),(32,NULL,NULL,'64a77c2b0c554249a8bbe5c298b6f1ba',NULL,NULL,NULL,NULL,'2026-01-23 19:00:22',NULL,'2026-01-23 19:00:22',NULL,NULL),(33,NULL,'37933d0cde6d43d79dfad68b3c91b196',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:00:24',NULL,'2026-01-23 19:00:24',NULL,NULL),(34,NULL,'4c762eee821b41d1a7ec9015bb92a684',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:00:24',NULL,'2026-01-23 19:00:24',NULL,NULL),(35,NULL,'f100236b507c430cb7a1488f076e4f53',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:00:25',NULL,'2026-01-23 19:00:25',NULL,NULL),(36,NULL,NULL,'724d774bc74a4783a9ece8e34e08bd8c',NULL,NULL,NULL,NULL,'2026-01-23 19:00:26',NULL,'2026-01-23 19:00:26',NULL,NULL),(37,NULL,'a656024251194b8abab1f0e0ac791185',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:00:26',NULL,'2026-01-23 19:00:26',NULL,NULL),(38,NULL,'75f8ea90d0aa4a17be3c2e65d373ec73',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:00:28',NULL,'2026-01-23 19:00:28',NULL,NULL),(39,NULL,NULL,'ec38866976dd43c18bb6b7c1d4805172',NULL,NULL,NULL,NULL,'2026-01-23 19:00:29',NULL,'2026-01-23 19:00:29',NULL,NULL),(40,NULL,NULL,'6018ecba8bec451d85018cd3ed66bac3',NULL,NULL,NULL,NULL,'2026-01-23 19:00:30',NULL,'2026-01-23 19:00:30',NULL,NULL),(41,NULL,'b65f710c783341f7ae335e8619294f30',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:00:30',NULL,'2026-01-23 19:00:30',NULL,NULL),(42,NULL,'5272f9b172db4a39943b136299a5759d',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:00:31',NULL,'2026-01-23 19:00:31',NULL,NULL),(43,NULL,NULL,'d61723154d4046c9b3fe7d389387bdbc',NULL,NULL,NULL,NULL,'2026-01-23 19:00:37',NULL,'2026-01-23 19:00:37',NULL,NULL),(44,NULL,NULL,'1e95c237ea5747b4a08f83f80294e464',NULL,NULL,NULL,NULL,'2026-01-23 19:00:38',NULL,'2026-01-23 19:00:38',NULL,NULL),(45,NULL,'d88d4dbc206d4c8a869eedd7050c1def',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:00:39',NULL,'2026-01-23 19:00:39',NULL,NULL),(46,NULL,'c05ab92b2e7d4b60ac9797fc95883ada',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:00:39',NULL,'2026-01-23 19:00:39',NULL,NULL),(47,NULL,NULL,'c8402f2305e24e9f9b8d5c800c77efe6',NULL,NULL,NULL,NULL,'2026-01-23 19:00:43',NULL,'2026-01-23 19:00:43',NULL,NULL),(48,NULL,'a649f7ea3c2d44e3a199e6d652031736',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:00:48',NULL,'2026-01-23 19:00:48',NULL,NULL),(49,NULL,NULL,'4d945a4b5cb14e898a061ccd3bdd280a',NULL,NULL,NULL,NULL,'2026-01-23 19:01:04',NULL,'2026-01-23 19:01:04',NULL,NULL),(50,NULL,NULL,'bfabc600dbc045e0928c1f9f204b0a96',NULL,NULL,NULL,NULL,'2026-01-23 19:01:04',NULL,'2026-01-23 19:01:04',NULL,NULL),(51,NULL,NULL,'4b4388099eda401c8d6e3167f7eaa99d',NULL,NULL,NULL,NULL,'2026-01-23 19:01:04',NULL,'2026-01-23 19:01:04',NULL,NULL),(52,NULL,NULL,'a1cc0d15604b4978bb7c1af07be60037',NULL,NULL,NULL,NULL,'2026-01-23 19:01:04',NULL,'2026-01-23 19:01:04',NULL,NULL),(53,NULL,'6ba1464b0a744138858c9d7bf91300f0',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:01:06',NULL,'2026-01-23 19:01:06',NULL,NULL),(54,NULL,'1b542af72b5b4135985ec9171c167a6a',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:01:07',NULL,'2026-01-23 19:01:07',NULL,NULL),(55,NULL,'96c5b6dd74114ae68d830ca0b1f51b50',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:01:08',NULL,'2026-01-23 19:01:08',NULL,NULL),(56,NULL,NULL,'558d317bd62542eb9fe7a15800c7d18f',NULL,NULL,NULL,NULL,'2026-01-23 19:01:11',NULL,'2026-01-23 19:01:11',NULL,NULL),(57,NULL,'7976ff17c3f840919d65487c1a87daad',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:01:16',NULL,'2026-01-23 19:01:16',NULL,NULL),(58,NULL,NULL,'03a60d2561c74d4285401ee890fe82a9',NULL,NULL,NULL,NULL,'2026-01-23 19:01:17',NULL,'2026-01-23 19:01:17',NULL,NULL),(59,NULL,NULL,'12e4cec96401441f84317127e71f8a3e',NULL,NULL,NULL,NULL,'2026-01-23 19:01:17',NULL,'2026-01-23 19:01:17',NULL,NULL),(60,NULL,NULL,'3955e9d60ac242908520b97ad24ca3a3',NULL,NULL,NULL,NULL,'2026-01-23 19:01:18',NULL,'2026-01-23 19:01:18',NULL,NULL),(61,NULL,'c4d9abcb8b5d4ddbb7aae59773caeb27',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:01:19',NULL,'2026-01-23 19:01:19',NULL,NULL),(62,NULL,'9e708dc344a64ca294a4473db436e198',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:01:19',NULL,'2026-01-23 19:01:19',NULL,NULL),(63,NULL,'c08a228a2fd544d895496b19fa883312',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:01:20',NULL,'2026-01-23 19:01:20',NULL,NULL),(64,NULL,NULL,'27c671e84ca04863ac3c831e80a260cb',NULL,NULL,NULL,NULL,'2026-01-23 19:01:22',NULL,'2026-01-23 19:01:22',NULL,NULL),(65,NULL,'9360b9523bf8413f9e6b3d3e533f270a',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:01:24',NULL,'2026-01-23 19:01:24',NULL,NULL),(66,NULL,NULL,'c1c8384de14c4a31ae08ff4e69a1c9bb',NULL,NULL,NULL,NULL,'2026-01-23 19:01:28',NULL,'2026-01-23 19:01:28',NULL,NULL),(67,NULL,NULL,'6103b8d06dd34f2297d3338de94a9702',NULL,NULL,NULL,NULL,'2026-01-23 19:01:28',NULL,'2026-01-23 19:01:28',NULL,NULL),(68,NULL,'dcb726ed64514381891686f89d347595',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:01:30',NULL,'2026-01-23 19:01:30',NULL,NULL),(69,NULL,'f4dfaf18b59645668dfa1623e2da94e8',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:01:30',NULL,'2026-01-23 19:01:30',NULL,NULL),(70,NULL,NULL,'49a6179d92fe443cb929316bbaf3caab',NULL,NULL,NULL,NULL,'2026-01-23 19:01:34',NULL,'2026-01-23 19:01:34',NULL,NULL),(71,NULL,NULL,'ec6aa7d52f084c298bf0dfa48b0c1537',NULL,NULL,NULL,NULL,'2026-01-23 19:01:34',NULL,'2026-01-23 19:01:34',NULL,NULL),(72,NULL,NULL,'134878de241d413e9f610790cff9caa1',NULL,NULL,NULL,NULL,'2026-01-23 19:01:35',NULL,'2026-01-23 19:01:35',NULL,NULL),(73,NULL,'ab837b96f146435fa10c280ff78f7a38',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:01:37',NULL,'2026-01-23 19:01:37',NULL,NULL),(74,NULL,'31990e0fe83f4f1a992e1e2f4dd942a7',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:01:37',NULL,'2026-01-23 19:01:37',NULL,NULL),(75,NULL,NULL,'555a7140337545308cadd80f91dce139',NULL,NULL,NULL,NULL,'2026-01-23 19:01:39',NULL,'2026-01-23 19:01:39',NULL,NULL),(76,NULL,NULL,'db9e71e21f1e4d4c9ffead581d83867d',NULL,NULL,NULL,NULL,'2026-01-23 19:01:41',NULL,'2026-01-23 19:01:41',NULL,NULL),(77,NULL,NULL,'1cd7d375d545450f96aa8980d80de544',NULL,NULL,NULL,NULL,'2026-01-23 19:01:41',NULL,'2026-01-23 19:01:41',NULL,NULL),(78,NULL,'21df02f0b6444d60979433a266ef7dff',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:01:41',NULL,'2026-01-23 19:01:41',NULL,NULL),(79,NULL,NULL,'9ccc6c27b2f84f0197b33f4fae50f643',NULL,NULL,NULL,NULL,'2026-01-23 19:01:42',NULL,'2026-01-23 19:01:42',NULL,NULL),(80,NULL,'e8084c86b3fd4afc9961f6c56bf01e81',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:01:43',NULL,'2026-01-23 19:01:43',NULL,NULL),(81,NULL,NULL,'d41cbd73b9864040acd77f7fd992f772',NULL,NULL,NULL,NULL,'2026-01-23 19:01:44',NULL,'2026-01-23 19:01:44',NULL,NULL),(82,NULL,'f85c74702ad842e8800d0c3c7578fed7',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:01:44',NULL,'2026-01-23 19:01:44',NULL,NULL),(83,NULL,'fdf44e9f3d4c4741a86f2dba182105bf',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:01:45',NULL,'2026-01-23 19:01:45',NULL,NULL),(84,NULL,'5d98b2da51784056a523bab517e4d079',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:01:46',NULL,'2026-01-23 19:01:46',NULL,NULL),(85,NULL,NULL,'61b25e22e6314f8bacdb698b20154a66',NULL,NULL,NULL,NULL,'2026-01-23 19:01:48',NULL,'2026-01-23 19:01:48',NULL,NULL),(86,NULL,'68fc8f264f0d4c76a5f943f85dad92ab',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:01:49',NULL,'2026-01-23 19:01:49',NULL,NULL),(87,NULL,NULL,'8588fbc16d3c4bb7a4b49171b44b071b',NULL,NULL,NULL,NULL,'2026-01-23 19:01:55',NULL,'2026-01-23 19:01:55',NULL,NULL),(88,NULL,NULL,'52e73d5a04a341b6a7e0bdd3001b9a03',NULL,NULL,NULL,NULL,'2026-01-23 19:01:58',NULL,'2026-01-23 19:01:58',NULL,NULL),(89,NULL,NULL,'25ebb8b143d84bfab128a474701250d6',NULL,NULL,NULL,NULL,'2026-01-23 19:01:59',NULL,'2026-01-23 19:01:59',NULL,NULL),(90,NULL,NULL,'327ffcd22b74448d87157bdd4632b23d',NULL,NULL,NULL,NULL,'2026-01-23 19:01:59',NULL,'2026-01-23 19:01:59',NULL,NULL),(91,NULL,NULL,'891b9fa93a664d2fa3f69edca9096b01',NULL,NULL,NULL,NULL,'2026-01-23 19:01:59',NULL,'2026-01-23 19:01:59',NULL,NULL),(92,NULL,'e9255972eb454fca909aa1528e4f83a2',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:01:59',NULL,'2026-01-23 19:01:59',NULL,NULL),(93,NULL,NULL,'1efc60dfafb740f48a10184f26e16386',NULL,NULL,NULL,NULL,'2026-01-23 19:02:00',NULL,'2026-01-23 19:02:00',NULL,NULL),(94,NULL,'17cfa608425e4698a0025b52d2440b22',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:02:01',NULL,'2026-01-23 19:02:01',NULL,NULL),(95,NULL,'1490bc1cfa8e446280d7d1f208cdd9cc',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:02:01',NULL,'2026-01-23 19:02:01',NULL,NULL),(96,NULL,'d374d537b1c94dfb900615f7d786f7df',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:02:01',NULL,'2026-01-23 19:02:01',NULL,NULL),(97,NULL,'bd0d4498326a45708c5d8845efe3901e',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:02:02',NULL,'2026-01-23 19:02:02',NULL,NULL),(98,NULL,NULL,'02cf1773172749a795486a650e80cd7c',NULL,NULL,NULL,NULL,'2026-01-23 19:02:05',NULL,'2026-01-23 19:02:05',NULL,NULL),(99,NULL,'2de04bdd421b4b01902225329bc9117d',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:02:06',NULL,'2026-01-23 19:02:06',NULL,NULL),(100,NULL,NULL,'b2cf0363c7494477a01260cc6a7eeff9',NULL,NULL,NULL,NULL,'2026-01-23 19:02:07',NULL,'2026-01-23 19:02:07',NULL,NULL),(101,NULL,NULL,'d4854e7989914b0a8de972d4f7254ff2',NULL,NULL,NULL,NULL,'2026-01-23 19:02:07',NULL,'2026-01-23 19:02:07',NULL,NULL),(102,NULL,NULL,'06e0d50765b84a109551bfac230deae0',NULL,NULL,NULL,NULL,'2026-01-23 19:02:07',NULL,'2026-01-23 19:02:07',NULL,NULL),(103,NULL,NULL,'5c2fff94939f4642a2e75eb30319547a',NULL,NULL,NULL,NULL,'2026-01-23 19:02:07',NULL,'2026-01-23 19:02:07',NULL,NULL),(104,NULL,NULL,'caf94632105a41dcab21b4b0716c8995',NULL,NULL,NULL,NULL,'2026-01-23 19:02:08',NULL,'2026-01-23 19:02:08',NULL,NULL),(105,NULL,NULL,'ca72c3c1f0694fd6a221e281113a32f7',NULL,NULL,NULL,NULL,'2026-01-23 19:02:08',NULL,'2026-01-23 19:02:08',NULL,NULL),(106,NULL,NULL,'ff42f234acae403d93bdd1420b8e72ed',NULL,NULL,NULL,NULL,'2026-01-23 19:02:08',NULL,'2026-01-23 19:02:08',NULL,NULL),(107,NULL,NULL,'4733a97b25be4b8ba942670932fad772',NULL,NULL,NULL,NULL,'2026-01-23 19:02:09',NULL,'2026-01-23 19:02:09',NULL,NULL),(108,NULL,'a21bf3c8096c4b24b7b487a028be19cc',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:02:11',NULL,'2026-01-23 19:02:11',NULL,NULL),(109,NULL,'47cae74819a1492e8b07a175e1d4fd33',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:02:13',NULL,'2026-01-23 19:02:13',NULL,NULL),(110,NULL,'0034e94cde5c402eb542d58e14a80d2c',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:02:13',NULL,'2026-01-23 19:02:13',NULL,NULL),(111,NULL,'7709a3944aa74a38a56fddea6d99fc00',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:02:13',NULL,'2026-01-23 19:02:13',NULL,NULL),(112,NULL,'1a8798b902e7464fa59d9b7585e84a49',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:02:14',NULL,'2026-01-23 19:02:14',NULL,NULL),(113,NULL,'4ae7213413b84a0699337622cc4b5035',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:02:14',NULL,'2026-01-23 19:02:14',NULL,NULL),(114,NULL,NULL,'d4699fb6f80746b4a636ab8962e102d0',NULL,NULL,NULL,NULL,'2026-01-23 19:02:25',NULL,'2026-01-23 19:02:25',NULL,NULL),(115,NULL,'538e549e0d1e4309a3c16b3a4f48e842',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:02:26',NULL,'2026-01-23 19:02:26',NULL,NULL),(116,NULL,NULL,'05317d639b51442e8c3bb3c6684ab6ba',NULL,NULL,NULL,NULL,'2026-01-23 19:02:31',NULL,'2026-01-23 19:02:31',NULL,NULL),(117,NULL,NULL,'7e1da12ad1874b919b7bc8012c4ff418',NULL,NULL,NULL,NULL,'2026-01-23 19:02:32',NULL,'2026-01-23 19:02:32',NULL,NULL),(118,NULL,NULL,'c4b175256fb642a18dbf9f009812932b',NULL,NULL,NULL,NULL,'2026-01-23 19:02:32',NULL,'2026-01-23 19:02:32',NULL,NULL),(119,NULL,NULL,'52f2018349c84e03b47a8d0070363bd8',NULL,NULL,NULL,NULL,'2026-01-23 19:02:32',NULL,'2026-01-23 19:02:32',NULL,NULL),(120,NULL,NULL,'cf78c38e3f6f4cae977f3610c4befcd9',NULL,NULL,NULL,NULL,'2026-01-23 19:02:33',NULL,'2026-01-23 19:02:33',NULL,NULL),(121,NULL,'8e9dc0d70be24766935b5acd4a5e93cf',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:02:33',NULL,'2026-01-23 19:02:33',NULL,NULL),(122,NULL,'9b74a1f4e6a642998dfa70a0dd52f1e3',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:02:34',NULL,'2026-01-23 19:02:34',NULL,NULL),(123,NULL,'dcaebac10d574ce2aa3ba16906fd5dbc',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:02:34',NULL,'2026-01-23 19:02:34',NULL,NULL),(124,NULL,'651e9ae308044a99ad23c56794221400',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:02:35',NULL,'2026-01-23 19:02:35',NULL,NULL),(125,NULL,NULL,'004e146afca24ee79df34e1d7833fcd9',NULL,NULL,NULL,NULL,'2026-01-23 19:02:38',NULL,'2026-01-23 19:02:38',NULL,NULL),(126,NULL,NULL,'91a20337cec8428d94f3580d7a4687e7',NULL,NULL,NULL,NULL,'2026-01-23 19:02:47',NULL,'2026-01-23 19:02:47',NULL,NULL),(127,NULL,NULL,'58ba79b6c9994c0fb14affae9b8f0c8c',NULL,NULL,NULL,NULL,'2026-01-23 19:02:53',NULL,'2026-01-23 19:02:53',NULL,NULL),(128,NULL,NULL,'795d61c6748c4ee1963bd0cf94173c58',NULL,NULL,NULL,NULL,'2026-01-23 19:02:53',NULL,'2026-01-23 19:02:53',NULL,NULL),(129,NULL,NULL,'a4516c6220434cb08070a8aa8745c1df',NULL,NULL,NULL,NULL,'2026-01-23 19:02:53',NULL,'2026-01-23 19:02:53',NULL,NULL),(130,NULL,NULL,'965b45de63644e028d16845f46c7c2ca',NULL,NULL,NULL,NULL,'2026-01-23 19:02:54',NULL,'2026-01-23 19:02:54',NULL,NULL),(131,NULL,NULL,'756425207c7b4fecb6340ae30f1ada1b',NULL,NULL,NULL,NULL,'2026-01-23 19:02:54',NULL,'2026-01-23 19:02:54',NULL,NULL),(132,NULL,NULL,'aab37409764d412dbda1be20cc09c609',NULL,NULL,NULL,NULL,'2026-01-23 19:02:54',NULL,'2026-01-23 19:02:54',NULL,NULL),(133,NULL,'db171ed11cd54288960e2675bc51a3a1',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:02:54',NULL,'2026-01-23 19:02:54',NULL,NULL),(134,NULL,'e19ff7e178044a3f9516cdc773fa4d6b',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:02:56',NULL,'2026-01-23 19:02:56',NULL,NULL),(135,NULL,'0ca8df8f00a8427f9bc7156599cbbfd2',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:02:56',NULL,'2026-01-23 19:02:56',NULL,NULL),(136,NULL,'0717dc01879548e7809d4ba33eb72aec',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:02:56',NULL,'2026-01-23 19:02:56',NULL,NULL),(137,NULL,'57eff797a391455984703b0bf861474f',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:02:56',NULL,'2026-01-23 19:02:56',NULL,NULL),(138,NULL,'a9e6aa878c9c4cbaba399c1a4dd39ad1',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:02:57',NULL,'2026-01-23 19:02:57',NULL,NULL),(139,NULL,NULL,'3053c402e18948f8953268e1e7a47766',NULL,NULL,NULL,NULL,'2026-01-23 19:03:00',NULL,'2026-01-23 19:03:00',NULL,NULL),(140,NULL,'974a5eb70f304575af3d9d8450d5029c',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:03:02',NULL,'2026-01-23 19:03:02',NULL,NULL),(141,NULL,NULL,'cddc78d3af8042c998874d55ab4d04b2',NULL,NULL,NULL,NULL,'2026-01-23 19:03:02',NULL,'2026-01-23 19:03:02',NULL,NULL),(142,NULL,NULL,'48aab17447ce4d90a8a1db613f1ea646',NULL,NULL,NULL,NULL,'2026-01-23 19:03:06',NULL,'2026-01-23 19:03:06',NULL,NULL),(143,NULL,NULL,'0e9985f1654840fc8f2fe5f5af570061',NULL,NULL,NULL,NULL,'2026-01-23 19:03:06',NULL,'2026-01-23 19:03:06',NULL,NULL),(144,NULL,NULL,'904af709fd434fcca88b14de6c87fbe5',NULL,NULL,NULL,NULL,'2026-01-23 19:03:06',NULL,'2026-01-23 19:03:06',NULL,NULL),(145,NULL,'e855b6d0e3d04ffa942cfb0fcb157024',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:03:07',NULL,'2026-01-23 19:03:07',NULL,NULL),(146,NULL,'dffb6bb84e0948e583c61438ddae2eea',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:03:08',NULL,'2026-01-23 19:03:08',NULL,NULL),(147,NULL,'f2beea25a5e947aab5d0bb53058124cf',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:03:09',NULL,'2026-01-23 19:03:09',NULL,NULL),(148,NULL,NULL,'11cb836cfb86412b9a9b57bded74810a',NULL,NULL,NULL,NULL,'2026-01-23 19:03:09',NULL,'2026-01-23 19:03:09',NULL,NULL),(149,NULL,NULL,'88cfe66173fd44c9ac3005ab49fd2ab8',NULL,NULL,NULL,NULL,'2026-01-23 19:03:10',NULL,'2026-01-23 19:03:10',NULL,NULL),(150,NULL,NULL,'9e61df16b63e452597d7838045e2b7db',NULL,NULL,NULL,NULL,'2026-01-23 19:03:10',NULL,'2026-01-23 19:03:10',NULL,NULL),(151,NULL,NULL,'839959ba5e324432bfd774ff58ddba2c',NULL,NULL,NULL,NULL,'2026-01-23 19:03:10',NULL,'2026-01-23 19:03:10',NULL,NULL),(152,NULL,NULL,'7a8a6d534c904bf48123cc2336178c30',NULL,NULL,NULL,NULL,'2026-01-23 19:03:11',NULL,'2026-01-23 19:03:11',NULL,NULL),(153,NULL,NULL,'2caaa2bea59549f48039d35cd4c79c3d',NULL,NULL,NULL,NULL,'2026-01-23 19:03:12',NULL,'2026-01-23 19:03:12',NULL,NULL),(154,NULL,NULL,'3be3bf2b0acd404ca606b9261c2eadb4',NULL,NULL,NULL,NULL,'2026-01-23 19:03:12',NULL,'2026-01-23 19:03:12',NULL,NULL),(155,NULL,'4f5e8bd3776649ceb731681e5486e338',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:03:12',NULL,'2026-01-23 19:03:12',NULL,NULL),(156,NULL,'8ea2dddd772b49f1b9e0a76f8a04e556',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:03:13',NULL,'2026-01-23 19:03:13',NULL,NULL),(157,NULL,'ca397374b0cc4a62a55f70299be57903',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:03:13',NULL,'2026-01-23 19:03:13',NULL,NULL),(158,NULL,'3d8b026c7ff443fd8da339c16384afd4',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:03:13',NULL,'2026-01-23 19:03:13',NULL,NULL),(159,NULL,'34359dfa6b3143e792c82df9342f2c90',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:03:14',NULL,'2026-01-23 19:03:14',NULL,NULL),(160,NULL,NULL,'e5a7a688c24548c6bb7c39f3d4ddcd58',NULL,NULL,NULL,NULL,'2026-01-23 19:03:15',NULL,'2026-01-23 19:03:15',NULL,NULL),(161,NULL,NULL,'17ec91f691e54474893d8e435e589e7d',NULL,NULL,NULL,NULL,'2026-01-23 19:03:15',NULL,'2026-01-23 19:03:15',NULL,NULL),(162,NULL,NULL,'70e6f57b617a48ac91e9becad5c41de0',NULL,NULL,NULL,NULL,'2026-01-23 19:03:15',NULL,'2026-01-23 19:03:15',NULL,NULL),(163,NULL,NULL,'47006f07a7ce4e0bb141ea3515bffdf9',NULL,NULL,NULL,NULL,'2026-01-23 19:03:16',NULL,'2026-01-23 19:03:16',NULL,NULL),(164,NULL,'f4ee7a5c73364ed7a337f847acfa9202',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:03:16',NULL,'2026-01-23 19:03:16',NULL,NULL),(165,NULL,NULL,'26833fbf137d47cca81c2b6a182cbde1',NULL,NULL,NULL,NULL,'2026-01-23 19:03:17',NULL,'2026-01-23 19:03:17',NULL,NULL),(166,NULL,'ffef6e5d784545df93ba290a70829660',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:03:17',NULL,'2026-01-23 19:03:17',NULL,NULL),(167,NULL,'33014b8e05e14acd8b22688a3e5bc974',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:03:18',NULL,'2026-01-23 19:03:18',NULL,NULL),(168,NULL,'f5e4735967a34372b7d1e5cd6d3f5fef',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:03:18',NULL,'2026-01-23 19:03:18',NULL,NULL),(169,NULL,'26ffaef7ee914dff8756a8885f9f07e2',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:03:19',NULL,'2026-01-23 19:03:19',NULL,NULL),(170,NULL,NULL,'c6e224824016442c8906f7b2badfb228',NULL,NULL,NULL,NULL,'2026-01-23 19:03:21',NULL,'2026-01-23 19:03:21',NULL,NULL),(171,NULL,NULL,'7d61e2c466cb4da8a77a235a76eb59b7',NULL,NULL,NULL,NULL,'2026-01-23 19:03:22',NULL,'2026-01-23 19:03:22',NULL,NULL),(172,NULL,'83090285dd2247b9bcfbfd3c31953c07',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:03:22',NULL,'2026-01-23 19:03:22',NULL,NULL),(173,NULL,'793eddeaa64f4fb492b8a8dc42621892',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:03:23',NULL,'2026-01-23 19:03:23',NULL,NULL),(174,NULL,NULL,'854648bbe22341d688196552385ef34e',NULL,NULL,NULL,NULL,'2026-01-23 19:03:30',NULL,'2026-01-23 19:03:30',NULL,NULL),(175,NULL,NULL,'886ae9f8d85b45299215f046dc178830',NULL,NULL,NULL,NULL,'2026-01-23 19:03:30',NULL,'2026-01-23 19:03:30',NULL,NULL),(176,NULL,NULL,'cdd31d4ffc43492cbcccba4814e2d76e',NULL,NULL,NULL,NULL,'2026-01-23 19:03:30',NULL,'2026-01-23 19:03:30',NULL,NULL),(177,NULL,NULL,'ee751e4daa1e4219be220975d209631e',NULL,NULL,NULL,NULL,'2026-01-23 19:03:31',NULL,'2026-01-23 19:03:31',NULL,NULL),(178,NULL,'a8836123057e49ac857e8374c9186ff3',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:03:32',NULL,'2026-01-23 19:03:32',NULL,NULL),(179,NULL,'3d8f5d61509c46c2bba9e2b115532953',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:03:34',NULL,'2026-01-23 19:03:34',NULL,NULL),(180,NULL,'e6ec5d1a306544cca047dafa9a4196f0',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:03:35',NULL,'2026-01-23 19:03:35',NULL,NULL),(181,NULL,NULL,'a0370e2a377f4be594090f7c16f4eb8e',NULL,NULL,NULL,NULL,'2026-01-23 19:03:42',NULL,'2026-01-23 19:03:42',NULL,NULL),(182,NULL,NULL,'b3ec277fe4624b46b687bc78d7cf6a03',NULL,NULL,NULL,NULL,'2026-01-23 19:03:44',NULL,'2026-01-23 19:03:44',NULL,NULL),(183,NULL,NULL,'d6ec4fcb5f0d453fa1cf2cc0b074cba7',NULL,NULL,NULL,NULL,'2026-01-23 19:03:44',NULL,'2026-01-23 19:03:44',NULL,NULL),(184,NULL,NULL,'6a4ad71a32f54a66959770e6e73088a1',NULL,NULL,NULL,NULL,'2026-01-23 19:03:44',NULL,'2026-01-23 19:03:44',NULL,NULL),(185,NULL,'659313dc7d8f4c0aa1d1fbff464fad35',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:03:45',NULL,'2026-01-23 19:03:45',NULL,NULL),(186,NULL,'3f9725edbd1b4cf299e129c2c7587203',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:03:46',NULL,'2026-01-23 19:03:46',NULL,NULL),(187,NULL,'f74f91fa86fd4696808d7b969d91e8ec',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:03:47',NULL,'2026-01-23 19:03:47',NULL,NULL),(188,NULL,NULL,'5bd1f1df98034071ad18a1883f56d6f9',NULL,NULL,NULL,NULL,'2026-01-23 19:03:57',NULL,'2026-01-23 19:03:57',NULL,NULL),(189,NULL,NULL,'2fbff2750c964489941186e6647353bd',NULL,NULL,NULL,NULL,'2026-01-23 19:04:06',NULL,'2026-01-23 19:04:06',NULL,NULL),(190,NULL,'08f0ac3daf4849ccbfe15d2f731f4f1f',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:04:08',NULL,'2026-01-23 19:04:08',NULL,NULL),(191,NULL,NULL,'6a0276608a0a45b799ecde402bec39c9',NULL,NULL,NULL,NULL,'2026-01-23 19:04:10',NULL,'2026-01-23 19:04:10',NULL,NULL),(192,NULL,NULL,'fd03ddd06d374af6aaab5af51dd14875',NULL,NULL,NULL,NULL,'2026-01-23 19:04:11',NULL,'2026-01-23 19:04:11',NULL,NULL),(193,NULL,NULL,'dc6866278e7a4ca6987744d0fa9f4396',NULL,NULL,NULL,NULL,'2026-01-23 19:04:11',NULL,'2026-01-23 19:04:11',NULL,NULL),(194,NULL,NULL,'bb4211db47164dcea6a95410df299b20',NULL,NULL,NULL,NULL,'2026-01-23 19:04:11',NULL,'2026-01-23 19:04:11',NULL,NULL),(195,NULL,'dccb811a2a4d431c902f85f2cd7321b9',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:04:13',NULL,'2026-01-23 19:04:13',NULL,NULL),(196,NULL,'5ed6311cb89a4e81ac3637cb0a3cdbbe',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:04:14',NULL,'2026-01-23 19:04:14',NULL,NULL),(197,NULL,NULL,'dd48f8ad431048ee963afe07d57b264b',NULL,NULL,NULL,NULL,'2026-01-23 19:04:16',NULL,'2026-01-23 19:04:16',NULL,NULL),(198,NULL,'b82776023cca4d32b88102cf9cef38d6',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:04:20',NULL,'2026-01-23 19:04:20',NULL,NULL),(199,NULL,'9b7d16c500684560a7771530b05b3972',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:04:21',NULL,'2026-01-23 19:04:21',NULL,NULL),(200,NULL,NULL,'2b6dadb05d14498fb74d0e3ed633c1c2',NULL,NULL,NULL,NULL,'2026-01-23 19:04:23',NULL,'2026-01-23 19:04:23',NULL,NULL),(201,NULL,NULL,'ddcb456a9e21440eb19ddff410127fd4',NULL,NULL,NULL,NULL,'2026-01-23 19:04:23',NULL,'2026-01-23 19:04:23',NULL,NULL),(202,NULL,NULL,'fb6b2ec6e473458b8942848fd2a9a80a',NULL,NULL,NULL,NULL,'2026-01-23 19:04:24',NULL,'2026-01-23 19:04:24',NULL,NULL),(203,NULL,'a8b7a97fca294a4d9f6d071009571221',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:04:27',NULL,'2026-01-23 19:04:27',NULL,NULL),(204,NULL,'c6800c61a729485399ab218c492767ab',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:04:28',NULL,'2026-01-23 19:04:28',NULL,NULL),(205,NULL,'182b21a4575a4acc866fcdd5f8991734',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:04:30',NULL,'2026-01-23 19:04:30',NULL,NULL),(206,NULL,NULL,'4265711fece1445e9b94defc2d4b4367',NULL,NULL,NULL,NULL,'2026-01-23 19:04:33',NULL,'2026-01-23 19:04:33',NULL,NULL),(207,NULL,'acc02a76085849ae8406760025214a42',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:04:34',NULL,'2026-01-23 19:04:34',NULL,NULL),(208,NULL,NULL,'ccaf767f50714f34a3cd450b0e5594f8',NULL,NULL,NULL,NULL,'2026-01-23 19:04:39',NULL,'2026-01-23 19:04:39',NULL,NULL),(209,NULL,'1a997ded7b724a6f930b5a79720e59b3',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:04:43',NULL,'2026-01-23 19:04:43',NULL,NULL),(210,NULL,NULL,'a6becf5af42d455eb44f4d1479c24d78',NULL,NULL,NULL,NULL,'2026-01-23 19:04:47',NULL,'2026-01-23 19:04:47',NULL,NULL),(211,NULL,NULL,'1a04690e8f284aa39ed37e0b6aa7b3ee',NULL,NULL,NULL,NULL,'2026-01-23 19:04:48',NULL,'2026-01-23 19:04:48',NULL,NULL),(212,NULL,NULL,'f4f6ea92457a411a953d294d1910fe13',NULL,NULL,NULL,NULL,'2026-01-23 19:04:48',NULL,'2026-01-23 19:04:48',NULL,NULL),(213,NULL,NULL,'97e5b5856f774106be398a432c1a2e3a',NULL,NULL,NULL,NULL,'2026-01-23 19:04:48',NULL,'2026-01-23 19:04:48',NULL,NULL),(214,NULL,'5d979c3ed74a492981b806cb6f7d0021',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:04:51',NULL,'2026-01-23 19:04:51',NULL,NULL),(215,NULL,'80929ec982324a779c14b4908347afea',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:04:52',NULL,'2026-01-23 19:04:52',NULL,NULL),(216,NULL,'e523821f05f24ee683a3bef9e5423573',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:04:53',NULL,'2026-01-23 19:04:53',NULL,NULL),(217,NULL,NULL,'a0f5066edde847d7a6b46b1cacfb318f',NULL,NULL,NULL,NULL,'2026-01-23 19:04:56',NULL,'2026-01-23 19:04:56',NULL,NULL),(218,NULL,NULL,'88101913793f4fc0aa9daee6ac1630d3',NULL,NULL,NULL,NULL,'2026-01-23 19:04:59',NULL,'2026-01-23 19:04:59',NULL,NULL),(219,NULL,NULL,'8cdefb62c2c24150972e18eca4902a83',NULL,NULL,NULL,NULL,'2026-01-23 19:04:59',NULL,'2026-01-23 19:04:59',NULL,NULL),(220,NULL,NULL,'c3067ad1204f4d2eab3e3096fef5f890',NULL,NULL,NULL,NULL,'2026-01-23 19:04:59',NULL,'2026-01-23 19:04:59',NULL,NULL),(221,NULL,NULL,'8e744b1df347447e8bfb1c4aeba1c969',NULL,NULL,NULL,NULL,'2026-01-23 19:05:00',NULL,'2026-01-23 19:05:00',NULL,NULL),(222,NULL,NULL,'eeabb00740a8442eb5cb3065882b8ff9',NULL,NULL,NULL,NULL,'2026-01-23 19:05:02',NULL,'2026-01-23 19:05:02',NULL,NULL),(223,NULL,NULL,'f3cf5b853e784d67bc2df2569fdcdc1e',NULL,NULL,NULL,NULL,'2026-01-23 19:05:03',NULL,'2026-01-23 19:05:03',NULL,NULL),(224,NULL,'6db861b7b589496dad9d2cdb45d2d2d0',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:05:03',NULL,'2026-01-23 19:05:03',NULL,NULL),(225,NULL,NULL,'f6797453c4c74d3fb330e2b4b321bba8',NULL,NULL,NULL,NULL,'2026-01-23 19:05:03',NULL,'2026-01-23 19:05:03',NULL,NULL),(226,NULL,'23bfe70ec4764c33bddc5b756996d34f',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:05:04',NULL,'2026-01-23 19:05:04',NULL,NULL),(227,NULL,'b6dd6b14fe7c4bf1898e05671f9b0684',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:05:04',NULL,'2026-01-23 19:05:04',NULL,NULL),(228,NULL,'0243ec0d65504cb58398506b6d0f9a62',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:05:05',NULL,'2026-01-23 19:05:05',NULL,NULL),(229,NULL,'a35c4019e632481b8d602b69987634b5',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:05:06',NULL,'2026-01-23 19:05:06',NULL,NULL),(230,NULL,'6333b89cc67749f896506316d34639f6',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:05:07',NULL,'2026-01-23 19:05:07',NULL,NULL),(231,NULL,NULL,'2790e5c9c9d240419427a8f4bbad331b',NULL,NULL,NULL,NULL,'2026-01-23 19:05:18',NULL,'2026-01-23 19:05:18',NULL,NULL),(232,NULL,NULL,'138624e038574255bf814c2664032bee',NULL,NULL,NULL,NULL,'2026-01-23 19:05:22',NULL,'2026-01-23 19:05:22',NULL,NULL),(233,NULL,NULL,'f0e8ac45c1524f459e9b5655391cbd63',NULL,NULL,NULL,NULL,'2026-01-23 19:05:23',NULL,'2026-01-23 19:05:23',NULL,NULL),(234,NULL,NULL,'8219d01fee96420aadd4db6ee9173a8e',NULL,NULL,NULL,NULL,'2026-01-23 19:05:23',NULL,'2026-01-23 19:05:23',NULL,NULL),(235,NULL,NULL,'4cdaf3be00a843b7aca77970f17d1587',NULL,NULL,NULL,NULL,'2026-01-23 19:05:23',NULL,'2026-01-23 19:05:23',NULL,NULL),(236,NULL,NULL,'0cdc36ee00844d51a9bfb80f7be4a983',NULL,NULL,NULL,NULL,'2026-01-23 19:05:23',NULL,'2026-01-23 19:05:23',NULL,NULL),(237,NULL,NULL,'5e0a42b544d64e149379c17e691c1c6c',NULL,NULL,NULL,NULL,'2026-01-23 19:05:24',NULL,'2026-01-23 19:05:24',NULL,NULL),(238,NULL,NULL,'cf9cb1c5b24b4d11834ee07296f6fa1b',NULL,NULL,NULL,NULL,'2026-01-23 19:05:24',NULL,'2026-01-23 19:05:24',NULL,NULL),(239,NULL,'8ecf67da29b04bd89431f71cece6e5cf',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:05:24',NULL,'2026-01-23 19:05:24',NULL,NULL),(240,NULL,'169ea256fbb149038ef9717ca1a37ea5',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:05:25',NULL,'2026-01-23 19:05:25',NULL,NULL),(241,NULL,NULL,'cf77227ecbe746cab9614616f678ce31',NULL,NULL,NULL,NULL,'2026-01-23 19:05:25',NULL,'2026-01-23 19:05:25',NULL,NULL),(242,NULL,'c523487c135d4194b23022c25357897b',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:05:25',NULL,'2026-01-23 19:05:25',NULL,NULL),(243,NULL,NULL,'2ca0a44a9df04cffb40a45c77e5d5c2d',NULL,NULL,NULL,NULL,'2026-01-23 19:05:25',NULL,'2026-01-23 19:05:25',NULL,NULL),(244,NULL,NULL,'a4d978b3b9354591bd18248dd01ad501',NULL,NULL,NULL,NULL,'2026-01-23 19:05:26',NULL,'2026-01-23 19:05:26',NULL,NULL),(245,NULL,NULL,'94565c395bb24b54b95e5a40a22c558e',NULL,NULL,NULL,NULL,'2026-01-23 19:05:26',NULL,'2026-01-23 19:05:26',NULL,NULL),(246,NULL,'ea8bf7af9a334d019b1ac13e86db9097',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:05:26',NULL,'2026-01-23 19:05:26',NULL,NULL),(247,NULL,'d2167bebcfc74e1c85fc2a6647218f7b',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:05:26',NULL,'2026-01-23 19:05:26',NULL,NULL),(248,NULL,'6e81efcadc1a4938a53855b68f0acfd2',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:05:27',NULL,'2026-01-23 19:05:27',NULL,NULL),(249,NULL,'cc77f1d8022442f9bd9f7e258f349903',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:05:27',NULL,'2026-01-23 19:05:27',NULL,NULL),(250,NULL,'430cf4fee1e04b8f9326ebd6ea4e5a72',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:05:28',NULL,'2026-01-23 19:05:28',NULL,NULL),(251,NULL,NULL,'f15b8783abf344ef9058ad618f4c5ea6',NULL,NULL,NULL,NULL,'2026-01-23 19:05:28',NULL,'2026-01-23 19:05:28',NULL,NULL),(252,NULL,'9f1d557335ca4fb19a11c7d8161a5663',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:05:29',NULL,'2026-01-23 19:05:29',NULL,NULL),(253,NULL,'aa911793a24344c09f427596327a2408',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:05:29',NULL,'2026-01-23 19:05:29',NULL,NULL),(254,NULL,NULL,'767061f8596f444f8e3ea7f80967fec5',NULL,NULL,NULL,NULL,'2026-01-23 19:05:34',NULL,'2026-01-23 19:05:34',NULL,NULL),(255,NULL,'b17f281119ff44cbbbf9816794032547',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:05:36',NULL,'2026-01-23 19:05:36',NULL,NULL),(256,NULL,NULL,'2ab2a6f1ae2343d0815d619d01aed55b',NULL,NULL,NULL,NULL,'2026-01-23 19:05:45',NULL,'2026-01-23 19:05:45',NULL,NULL),(257,NULL,NULL,'9c4042b5b9c640f89f2cced6d4f42a9b',NULL,NULL,NULL,NULL,'2026-01-23 19:05:46',NULL,'2026-01-23 19:05:46',NULL,NULL),(258,NULL,NULL,'56eafce32ea24f4b8ba2699547f993e9',NULL,NULL,NULL,NULL,'2026-01-23 19:05:46',NULL,'2026-01-23 19:05:46',NULL,NULL),(259,NULL,NULL,'b37619b16ec1433f8310bbafbc7b5a8d',NULL,NULL,NULL,NULL,'2026-01-23 19:05:50',NULL,'2026-01-23 19:05:50',NULL,NULL),(260,NULL,'283b89301a234374a4dbf7307759750d',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:05:56',NULL,'2026-01-23 19:05:56',NULL,NULL),(261,NULL,'b7087ac6482f49c6ab23dac2fb067a01',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:05:58',NULL,'2026-01-23 19:05:58',NULL,NULL),(262,NULL,'38135cce7dc649389dda9abfdb9c4cca',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:05:58',NULL,'2026-01-23 19:05:58',NULL,NULL),(263,NULL,NULL,'017953799ebc43bfbaa0781dbe7a9b21',NULL,NULL,NULL,NULL,'2026-01-23 19:06:08',NULL,'2026-01-23 19:06:08',NULL,NULL),(264,NULL,NULL,'597914cc46a94739a10d6c016f18118b',NULL,NULL,NULL,NULL,'2026-01-23 19:06:09',NULL,'2026-01-23 19:06:09',NULL,NULL),(265,NULL,NULL,'1d4f0a94ccd84390b02a6b5b835f5eb4',NULL,NULL,NULL,NULL,'2026-01-23 19:06:09',NULL,'2026-01-23 19:06:09',NULL,NULL),(266,NULL,NULL,'c51cf672526c4448ab34eebb4ae8de78',NULL,NULL,NULL,NULL,'2026-01-23 19:06:09',NULL,'2026-01-23 19:06:09',NULL,NULL),(267,NULL,'75e52a4cdd254dab988208cec10afe8e',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:06:11',NULL,'2026-01-23 19:06:11',NULL,NULL),(268,NULL,'95f811fd2c324eb3b59d9057691aa9b0',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:06:13',NULL,'2026-01-23 19:06:13',NULL,NULL),(269,NULL,'da53e8f0e0df42b4ba06fea7f0693510',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:06:16',NULL,'2026-01-23 19:06:16',NULL,NULL),(270,NULL,NULL,'f395e891216c41888bac49e47c3ac432',NULL,NULL,NULL,NULL,'2026-01-23 19:06:20',NULL,'2026-01-23 19:06:20',NULL,NULL),(271,NULL,'05bdf608ce00460ba07de9e0ce988795',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:06:21',NULL,'2026-01-23 19:06:21',NULL,NULL),(272,NULL,NULL,'827fb98d5c3440eabb20183705f415a8',NULL,NULL,NULL,NULL,'2026-01-23 19:06:42',NULL,'2026-01-23 19:06:42',NULL,NULL),(273,NULL,NULL,'b41c18afdb6346b291f5525a5b5aca4d',NULL,NULL,NULL,NULL,'2026-01-23 19:06:43',NULL,'2026-01-23 19:06:43',NULL,NULL),(274,NULL,NULL,'1f380b30b01f4d3fa656e1f1627b7438',NULL,NULL,NULL,NULL,'2026-01-23 19:06:43',NULL,'2026-01-23 19:06:43',NULL,NULL),(275,NULL,NULL,'c9f4705a7cee4776baf8252f85eee02c',NULL,NULL,NULL,NULL,'2026-01-23 19:06:43',NULL,'2026-01-23 19:06:43',NULL,NULL),(276,NULL,'123b18cd80cf4839b9af4091eeba5289',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:06:45',NULL,'2026-01-23 19:06:45',NULL,NULL),(277,NULL,'1e5a07e60ba9416db9dd4733653459eb',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:06:46',NULL,'2026-01-23 19:06:46',NULL,NULL),(278,NULL,'5ce1c1cb978d4655b95674240227e033',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:06:47',NULL,'2026-01-23 19:06:47',NULL,NULL),(279,NULL,NULL,'2ca9144238bc437c9a704c1fd3c655bc',NULL,NULL,NULL,NULL,'2026-01-23 19:06:49',NULL,'2026-01-23 19:06:49',NULL,NULL),(280,NULL,NULL,'92e18278738a4683b3df1c1991657b6a',NULL,NULL,NULL,NULL,'2026-01-23 19:06:49',NULL,'2026-01-23 19:06:49',NULL,NULL),(281,NULL,NULL,'72c10a6dc7104c18ac27162d188683d7',NULL,NULL,NULL,NULL,'2026-01-23 19:06:49',NULL,'2026-01-23 19:06:49',NULL,NULL),(282,NULL,NULL,'334ff7397bf148cba7964c675f416b46',NULL,NULL,NULL,NULL,'2026-01-23 19:06:49',NULL,'2026-01-23 19:06:49',NULL,NULL),(283,NULL,NULL,'39690acf77cd4929bf30d8ec50697f1a',NULL,NULL,NULL,NULL,'2026-01-23 19:06:53',NULL,'2026-01-23 19:06:53',NULL,NULL),(284,NULL,NULL,'3fa870f48267408e95d6a29688c52358',NULL,NULL,NULL,NULL,'2026-01-23 19:06:53',NULL,'2026-01-23 19:06:53',NULL,NULL),(285,NULL,NULL,'dc28385d0f62450e91eb8f017612ae1d',NULL,NULL,NULL,NULL,'2026-01-23 19:06:53',NULL,'2026-01-23 19:06:53',NULL,NULL),(286,NULL,NULL,'7a1a35011363435a8a558e98e87b8831',NULL,NULL,NULL,NULL,'2026-01-23 19:06:54',NULL,'2026-01-23 19:06:54',NULL,NULL),(287,NULL,NULL,'281b1a07f0594040909f18f8e48eaba4',NULL,NULL,NULL,NULL,'2026-01-23 19:06:54',NULL,'2026-01-23 19:06:54',NULL,NULL),(288,NULL,NULL,'232d80619d784a9587f780fb3c822a56',NULL,NULL,NULL,NULL,'2026-01-23 19:06:54',NULL,'2026-01-23 19:06:54',NULL,NULL),(289,NULL,'e8f64b90a3ae45319732036257384d67',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:06:55',NULL,'2026-01-23 19:06:55',NULL,NULL),(290,NULL,'ea42c32b4fc5450f8d1f0b7cf46b935c',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:06:55',NULL,'2026-01-23 19:06:55',NULL,NULL),(291,NULL,'9789389adaf540268d712c8247b577db',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:06:56',NULL,'2026-01-23 19:06:56',NULL,NULL),(292,NULL,'ef50bedea4bc4cfd892c55fa7305015f',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:06:56',NULL,'2026-01-23 19:06:56',NULL,NULL),(293,NULL,'1bedbf7265dc42cf859f02ee7f9194c5',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:06:56',NULL,'2026-01-23 19:06:56',NULL,NULL),(294,NULL,'a974d076b414490dbf4b9dbc7a0c0e95',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:06:57',NULL,'2026-01-23 19:06:57',NULL,NULL),(295,NULL,NULL,'7b2e4aaa1a624b2e99d816e83126388a',NULL,NULL,NULL,NULL,'2026-01-23 19:06:59',NULL,'2026-01-23 19:06:59',NULL,NULL),(296,NULL,'0fc90fa55a4e4fab88c8b41fbb5ea8ef',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:07:00',NULL,'2026-01-23 19:07:00',NULL,NULL),(297,NULL,NULL,'1f6f9c8f7a4e4751b56ac88030764d33',NULL,NULL,NULL,NULL,'2026-01-23 19:07:01',NULL,'2026-01-23 19:07:01',NULL,NULL),(298,NULL,NULL,'b8d4ff8070f247e2bfd1ac9cb7b53590',NULL,NULL,NULL,NULL,'2026-01-23 19:07:01',NULL,'2026-01-23 19:07:01',NULL,NULL),(299,NULL,NULL,'72af4681724345b8be85549b39af0d4b',NULL,NULL,NULL,NULL,'2026-01-23 19:07:01',NULL,'2026-01-23 19:07:01',NULL,NULL),(300,NULL,NULL,'58f63363248e4e62b897102f67fc1f58',NULL,NULL,NULL,NULL,'2026-01-23 19:07:01',NULL,'2026-01-23 19:07:01',NULL,NULL),(301,NULL,'f509082937e24fd8bfd8740ad1446ded',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:07:03',NULL,'2026-01-23 19:07:03',NULL,NULL),(302,NULL,'192e9d570ec04d58b341c60171c2c452',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:07:04',NULL,'2026-01-23 19:07:04',NULL,NULL),(303,NULL,'f63f45098bfa494fb09e8c8c5245df6e',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:07:04',NULL,'2026-01-23 19:07:04',NULL,NULL),(304,NULL,NULL,'c900cdf13e0e4f70a40524917c48fbe7',NULL,NULL,NULL,NULL,'2026-01-23 19:07:05',NULL,'2026-01-23 19:07:05',NULL,NULL),(305,NULL,NULL,'8ea82f684b3340c5949707821c1c52c2',NULL,NULL,NULL,NULL,'2026-01-23 19:07:05',NULL,'2026-01-23 19:07:05',NULL,NULL),(306,NULL,NULL,'eea75b21dca2426f888dccc0c565f545',NULL,NULL,NULL,NULL,'2026-01-23 19:07:05',NULL,'2026-01-23 19:07:05',NULL,NULL),(307,NULL,NULL,'c1d86753b5184ef0b045e74cb9cc0e33',NULL,NULL,NULL,NULL,'2026-01-23 19:07:05',NULL,'2026-01-23 19:07:05',NULL,NULL),(308,NULL,NULL,'9afe56bcb6f347799f8585b1079c343c',NULL,NULL,NULL,NULL,'2026-01-23 19:07:07',NULL,'2026-01-23 19:07:07',NULL,NULL),(309,NULL,'008dd070572f40748eca5ae6e87d237d',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:07:07',NULL,'2026-01-23 19:07:07',NULL,NULL),(310,NULL,NULL,'0ee3b61db0254b40bc85214e7d348538',NULL,NULL,NULL,NULL,'2026-01-23 19:07:07',NULL,'2026-01-23 19:07:07',NULL,NULL),(311,NULL,NULL,'29cec5bae2654ecf8df5eb4f3de10540',NULL,NULL,NULL,NULL,'2026-01-23 19:07:07',NULL,'2026-01-23 19:07:07',NULL,NULL),(312,NULL,'d9491b09ad364da488d75370d9409b3f',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:07:08',NULL,'2026-01-23 19:07:08',NULL,NULL),(313,NULL,NULL,'5246f3d030174b21a5d8d3013551dbdb',NULL,NULL,NULL,NULL,'2026-01-23 19:07:08',NULL,'2026-01-23 19:07:08',NULL,NULL),(314,NULL,'2c1e173af51a4ba0a7d7dcbbf3255bfa',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:07:09',NULL,'2026-01-23 19:07:09',NULL,NULL),(315,NULL,'f26f2d792338416dba0946a14c07d341',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:07:09',NULL,'2026-01-23 19:07:09',NULL,NULL),(316,NULL,'3fb8d4a8278546deacbbb6d960f5b0bb',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:07:10',NULL,'2026-01-23 19:07:10',NULL,NULL),(317,NULL,'24a608a9d5514d46a6ab52ef506558ed',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:07:10',NULL,'2026-01-23 19:07:10',NULL,NULL),(318,NULL,NULL,'cfadc9d7af0b44f48d3be609708992b3',NULL,NULL,NULL,NULL,'2026-01-23 19:07:14',NULL,'2026-01-23 19:07:14',NULL,NULL),(319,NULL,NULL,'02a38fd372d54825882d2b76e2408a99',NULL,NULL,NULL,NULL,'2026-01-23 19:07:14',NULL,'2026-01-23 19:07:14',NULL,NULL),(320,NULL,NULL,'0daa854806f04a8f9cb4a61150e615bf',NULL,NULL,NULL,NULL,'2026-01-23 19:07:14',NULL,'2026-01-23 19:07:14',NULL,NULL),(321,NULL,NULL,'da21fe9cec284fc6a1740a1643a5f01c',NULL,NULL,NULL,NULL,'2026-01-23 19:07:15',NULL,'2026-01-23 19:07:15',NULL,NULL),(322,NULL,'8ef2e7b772bf414b9d6c084c7663325d',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:07:16',NULL,'2026-01-23 19:07:16',NULL,NULL),(323,NULL,'c5c3a21ca6234d3bb541ce66455714e6',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:07:18',NULL,'2026-01-23 19:07:18',NULL,NULL),(324,NULL,NULL,'67b44701fb4e4e7d8f206c3732d706c6',NULL,NULL,NULL,NULL,'2026-01-23 19:07:20',NULL,'2026-01-23 19:07:20',NULL,NULL),(325,NULL,'b68525ca985b4aa1886512c7e2045c08',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:07:20',NULL,'2026-01-23 19:07:20',NULL,NULL),(326,NULL,NULL,'968d5d01fead4ec5974c92681f5cd389',NULL,NULL,NULL,NULL,'2026-01-23 19:07:21',NULL,'2026-01-23 19:07:21',NULL,NULL),(327,NULL,NULL,'d926f4815b01488eb2a3c27038521d39',NULL,NULL,NULL,NULL,'2026-01-23 19:07:21',NULL,'2026-01-23 19:07:21',NULL,NULL),(328,NULL,NULL,'45c6efa55189466baf8eeb82d0e3e0a0',NULL,NULL,NULL,NULL,'2026-01-23 19:07:21',NULL,'2026-01-23 19:07:21',NULL,NULL),(329,NULL,'80d90eeb9ca24336b08e0bcdbf71ea17',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:07:22',NULL,'2026-01-23 19:07:22',NULL,NULL),(330,NULL,'cd28fe6ab6ac42579a9ef7ca014c6978',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:07:23',NULL,'2026-01-23 19:07:23',NULL,NULL),(331,NULL,'7913b897d28542f58ee3ff3265e20fe5',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:07:24',NULL,'2026-01-23 19:07:24',NULL,NULL),(332,NULL,NULL,'0b436d15fc35435aa368f74ee79eb007',NULL,NULL,NULL,NULL,'2026-01-23 19:07:26',NULL,'2026-01-23 19:07:26',NULL,NULL),(333,NULL,NULL,'ed5c842e04be49998894b87c878d8e26',NULL,NULL,NULL,NULL,'2026-01-23 19:07:27',NULL,'2026-01-23 19:07:27',NULL,NULL),(334,NULL,NULL,'fa64d835cfb24abdadffecdf627ddd14',NULL,NULL,NULL,NULL,'2026-01-23 19:07:27',NULL,'2026-01-23 19:07:27',NULL,NULL),(335,NULL,NULL,'5fb964f4678a4e7b9a36e8d19580e148',NULL,NULL,NULL,NULL,'2026-01-23 19:07:27',NULL,'2026-01-23 19:07:27',NULL,NULL),(336,NULL,'94369b34b7bd4af6a8f5fd179d3c1332',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:07:28',NULL,'2026-01-23 19:07:28',NULL,NULL),(337,NULL,'f4f71ce2034b41ebaf65ee78c945b255',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:07:29',NULL,'2026-01-23 19:07:29',NULL,NULL),(338,NULL,'f8b2409d9fb44a2798afbe6525dbb9e4',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:07:31',NULL,'2026-01-23 19:07:31',NULL,NULL),(339,NULL,NULL,'d6eec9723c1b43aabf80030e58cdb879',NULL,NULL,NULL,NULL,'2026-01-23 19:07:37',NULL,'2026-01-23 19:07:37',NULL,NULL),(340,NULL,NULL,'c2bebaf99e6041d99b66cb884b6a3da8',NULL,NULL,NULL,NULL,'2026-01-23 19:07:37',NULL,'2026-01-23 19:07:37',NULL,NULL),(341,NULL,NULL,'1aef645be4214bb699f2a9b8ecd6ac05',NULL,NULL,NULL,NULL,'2026-01-23 19:07:38',NULL,'2026-01-23 19:07:38',NULL,NULL),(342,NULL,NULL,'46fe0642d3be407489c6d0968a6ad9ab',NULL,NULL,NULL,NULL,'2026-01-23 19:07:38',NULL,'2026-01-23 19:07:38',NULL,NULL),(343,NULL,'b3bb8a2aa7214043a25eaece59d78a53',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:07:42',NULL,'2026-01-23 19:07:42',NULL,NULL),(344,NULL,'2b458a59161c4dd8ae02bb5d46d25f81',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:07:43',NULL,'2026-01-23 19:07:43',NULL,NULL),(345,NULL,'b2edd040efc84528bb0920dd7f598d0b',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:07:44',NULL,'2026-01-23 19:07:44',NULL,NULL),(346,NULL,NULL,'1dd4720dbbf64e75a5e187ea61727455',NULL,NULL,NULL,NULL,'2026-01-23 19:07:49',NULL,'2026-01-23 19:07:49',NULL,NULL),(347,NULL,NULL,'8263f588feb3441b90a14974c5c7dfcf',NULL,NULL,NULL,NULL,'2026-01-23 19:07:57',NULL,'2026-01-23 19:07:57',NULL,NULL),(348,NULL,NULL,'ca1311af467245d8bcae17f244c543db',NULL,NULL,NULL,NULL,'2026-01-23 19:07:57',NULL,'2026-01-23 19:07:57',NULL,NULL),(349,NULL,NULL,'401075ccd7024124a6f910bdb707da84',NULL,NULL,NULL,NULL,'2026-01-23 19:07:57',NULL,'2026-01-23 19:07:57',NULL,NULL),(350,NULL,'95b9d54e0073410987627acb712eef00',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:07:58',NULL,'2026-01-23 19:07:58',NULL,NULL),(351,NULL,'d54620fee09145c8a224ea89cfd450d9',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:07:59',NULL,'2026-01-23 19:07:59',NULL,NULL),(352,NULL,'c65808ebd8034050a7f642ca129ed6de',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:08:00',NULL,'2026-01-23 19:08:00',NULL,NULL),(353,NULL,NULL,'82586d8b81804fef8f093dae41c8b223',NULL,NULL,NULL,NULL,'2026-01-23 19:08:27',NULL,'2026-01-23 19:08:27',NULL,NULL),(354,NULL,NULL,'8b705f09c12d4ce5a601553ed40999ca',NULL,NULL,NULL,NULL,'2026-01-23 19:08:35',NULL,'2026-01-23 19:08:35',NULL,NULL),(355,NULL,NULL,'77520b512b09481594399d1d447d3353',NULL,NULL,NULL,NULL,'2026-01-23 19:08:41',NULL,'2026-01-23 19:08:41',NULL,NULL),(356,NULL,NULL,'da117aee4edb43bdb8249107e1a77812',NULL,NULL,NULL,NULL,'2026-01-23 19:08:41',NULL,'2026-01-23 19:08:41',NULL,NULL),(357,NULL,NULL,'654e2616fb08403d81d1560fb673dbae',NULL,NULL,NULL,NULL,'2026-01-23 19:08:42',NULL,'2026-01-23 19:08:42',NULL,NULL),(358,NULL,NULL,'3deb3c1777d64f18bc9de677a095431d',NULL,NULL,NULL,NULL,'2026-01-23 19:08:42',NULL,'2026-01-23 19:08:42',NULL,NULL),(359,NULL,NULL,'8cc24629a2d540b6ad61507a2aebf3bb',NULL,NULL,NULL,NULL,'2026-01-23 19:08:42',NULL,'2026-01-23 19:08:42',NULL,NULL),(360,NULL,NULL,'e7b0d4711d26432cae278458b6b2fe73',NULL,NULL,NULL,NULL,'2026-01-23 19:08:42',NULL,'2026-01-23 19:08:42',NULL,NULL),(361,NULL,'58c0aab73912491f94e58ddb6bbf151f',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:08:43',NULL,'2026-01-23 19:08:43',NULL,NULL),(362,NULL,'8548bd568a5448648a2e519eb3ab357a',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:08:44',NULL,'2026-01-23 19:08:44',NULL,NULL),(363,NULL,'998a3a4c23934c4dafb2e2112ce1af90',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:08:44',NULL,'2026-01-23 19:08:44',NULL,NULL),(364,NULL,'9d4128f708404c81b3df08096aa8484b',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:08:45',NULL,'2026-01-23 19:08:45',NULL,NULL),(365,NULL,'fbeb73f734de49e0b3aa570ff5d8de5c',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:08:45',NULL,'2026-01-23 19:08:45',NULL,NULL),(366,NULL,'122f9cc8fe454d0e80faf8e1b08cbc1b',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:08:46',NULL,'2026-01-23 19:08:46',NULL,NULL),(367,NULL,NULL,'21daafd6b8884a8bac661e3f4b1e9376',NULL,NULL,NULL,NULL,'2026-01-23 19:08:57',NULL,'2026-01-23 19:08:57',NULL,NULL),(368,NULL,NULL,'c1d4cf45efb24e09b11fe9f4fdf168aa',NULL,NULL,NULL,NULL,'2026-01-23 19:08:58',NULL,'2026-01-23 19:08:58',NULL,NULL),(369,NULL,NULL,'06cf53b820e34c74b5ed6e38f590535c',NULL,NULL,NULL,NULL,'2026-01-23 19:09:04',NULL,'2026-01-23 19:09:04',NULL,NULL),(370,NULL,NULL,'7c3e99067f3e429087200b71eb78020c',NULL,NULL,NULL,NULL,'2026-01-23 19:09:04',NULL,'2026-01-23 19:09:04',NULL,NULL),(371,NULL,NULL,'ef5631fe4d164799a820cfac84045299',NULL,NULL,NULL,NULL,'2026-01-23 19:09:04',NULL,'2026-01-23 19:09:04',NULL,NULL),(372,NULL,NULL,'9387f9e13c974a7b9c7352ead07a670a',NULL,NULL,NULL,NULL,'2026-01-23 19:09:06',NULL,'2026-01-23 19:09:06',NULL,NULL),(373,NULL,NULL,'23039536ba6e4addb2e38b77b7a78f5a',NULL,NULL,NULL,NULL,'2026-01-23 19:09:07',NULL,'2026-01-23 19:09:07',NULL,NULL),(374,NULL,'653a849beaac4b3b9077641d9f9b4c5a',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:09:07',NULL,'2026-01-23 19:09:07',NULL,NULL),(375,NULL,NULL,'9b24b39b21a44df6b14c03e83b822e74',NULL,NULL,NULL,NULL,'2026-01-23 19:09:07',NULL,'2026-01-23 19:09:07',NULL,NULL),(376,NULL,'b17f9a502db941108eaa44a3e9aa605c',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:09:08',NULL,'2026-01-23 19:09:08',NULL,NULL),(377,NULL,'1a5960313fbf4abc9008b10730d182c2',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:09:09',NULL,'2026-01-23 19:09:09',NULL,NULL),(378,NULL,'689e9c033bd540e7b875cda7620ef527',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:09:09',NULL,'2026-01-23 19:09:09',NULL,NULL),(379,NULL,'25ab22f3f2214f1685af23b1e9f04ebe',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:09:10',NULL,'2026-01-23 19:09:10',NULL,NULL),(380,NULL,'903bee80a77148d58089510ca528b136',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:09:11',NULL,'2026-01-23 19:09:11',NULL,NULL),(381,NULL,NULL,'edc269d40f074c45b1f37a9de41bb5f9',NULL,NULL,NULL,NULL,'2026-01-23 19:09:18',NULL,'2026-01-23 19:09:18',NULL,NULL),(382,NULL,NULL,'6bfd8cc1684648fea284dcdc63f34609',NULL,NULL,NULL,NULL,'2026-01-23 19:09:19',NULL,'2026-01-23 19:09:19',NULL,NULL),(383,NULL,NULL,'0f55d5ab70b548d899bb030258e0d1c9',NULL,NULL,NULL,NULL,'2026-01-23 19:09:19',NULL,'2026-01-23 19:09:19',NULL,NULL),(384,NULL,NULL,'25287a2e83824248a4aa27b3121f9898',NULL,NULL,NULL,NULL,'2026-01-23 19:09:19',NULL,'2026-01-23 19:09:19',NULL,NULL),(385,NULL,'90f1f4b94b214899b3ad3242cda3ccce',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:09:23',NULL,'2026-01-23 19:09:23',NULL,NULL),(386,NULL,'9026c74739024ecd8e64c7838d0b9213',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:09:26',NULL,'2026-01-23 19:09:26',NULL,NULL),(387,NULL,'ff76894d5fa74fcfb4bc2a463211fcb1',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:09:28',NULL,'2026-01-23 19:09:28',NULL,NULL),(388,NULL,NULL,'86994f0379fd4fd191d95637dc1630d2',NULL,NULL,NULL,NULL,'2026-01-23 19:09:42',NULL,'2026-01-23 19:09:42',NULL,NULL),(389,NULL,NULL,'a622f76c64c643c1904e54c2dde49e5a',NULL,NULL,NULL,NULL,'2026-01-23 19:09:49',NULL,'2026-01-23 19:09:49',NULL,NULL),(390,NULL,NULL,'1bd0c42bc54a4a38a8b8b6e1093c9ce7',NULL,NULL,NULL,NULL,'2026-01-23 19:09:49',NULL,'2026-01-23 19:09:49',NULL,NULL),(391,NULL,NULL,'ff16e462e4984085950a006f9dc0b570',NULL,NULL,NULL,NULL,'2026-01-23 19:09:50',NULL,'2026-01-23 19:09:50',NULL,NULL),(392,NULL,'95ac89268f194512ad7d3acc9531cb92',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:09:51',NULL,'2026-01-23 19:09:51',NULL,NULL),(393,NULL,'07e698407b254151a7a1ba401f6bb52e',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:09:54',NULL,'2026-01-23 19:09:54',NULL,NULL),(394,NULL,'fa940230ee5d4b789e048d6d8d0968cd',NULL,NULL,NULL,NULL,NULL,'2026-01-23 19:09:56',NULL,'2026-01-23 19:09:56',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('03bc2f05d6d04131aa3e380d4ea0fdcd','admin','{}','<<null>>',NULL),('31271de7f4734844adf932f948ca8b9f','reader','{}','<<null>>',NULL),('408a6ad6b29349a1a902a1b5dea78926','ResellerAdmin','{}','<<null>>',NULL),('7596206c139048d9b2cd8efd5dc0f1ff','service','{}','<<null>>',NULL),('7e140ca5ba7e487d97be4b79ac5b6bd8','swiftoperator','{}','<<null>>',NULL),('df014587d4514e6cbf0e55543bab4b6a','member','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('03bc2f05d6d04131aa3e380d4ea0fdcd','IMMU','true'),('31271de7f4734844adf932f948ca8b9f','IMMU','true'),('df014587d4514e6cbf0e55543bab4b6a','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('12666387721d4837a72d07c56438f793','identity',1,'{\"name\": \"keystone\"}'),('1440418ba7fd4038b6b2c4e9ae3fb85c','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('1771b37da2894e55b2535f3a662db40f','object-store',1,'{\"name\": \"swift\", \"description\": \"OpenStack Object Storage\"}'),('4240ec9dda0545c192bc2cc1df3649d2','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('4cc12bef517247b89f9e0b75fa57616e','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('650a7caef42b4d2ab376d0e241c69547','sharev2',1,'{\"description\": \"Manila V2 Service\", \"name\": \"manilav2\"}'),('7625561f8d974008b3a4b1e7296498ab','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('9e426f02e3aa460f99960873216e8532','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('a4cc23f332b34994b7d6a5644c2a613e','share',1,'{\"description\": \"Manila V1 Service\", \"name\": \"manila\"}'),('a7fc4ed4b27a4b519c6e2596659e2b08','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('f7ceda547446472c81d8eec23142c37f','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','8bc2eb15461742fb9aafbd3726295065','system','03bc2f05d6d04131aa3e380d4ea0fdcd',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_trust_id` (`trust_id`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_user_id` (`user_id`),
  KEY `ix_token_expires_valid` (`expires`,`valid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('0cd8b67b22eb44eeb37be8163da1ecc2','{}',1,'92bdd319f82b46e2be56c4a54357168d','2026-01-23 18:22:23','2026-01-23','default'),('16bb0ac6a5ab47ffb944c1fc8c9852c7','{\"tenantId\": \"37e2e54f07464de3beb717dbff93203d\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2026-01-23 18:57:47',NULL,'default'),('2dad1823bd8c4927a0c016416e1a98fe','{}',1,'92bdd319f82b46e2be56c4a54357168d','2026-01-23 18:22:14','2026-01-23','default'),('4119423243334b86bc666820b3ac5cf0','{}',1,'92bdd319f82b46e2be56c4a54357168d','2026-01-23 18:22:25',NULL,'default'),('775b59d13293427386ef89a85ae242eb','{}',1,'92bdd319f82b46e2be56c4a54357168d','2026-01-23 18:36:47',NULL,'default'),('8bc2eb15461742fb9aafbd3726295065','{}',1,NULL,'2026-01-23 18:20:59','2026-01-23','default'),('94db1bb83e4f4e1ebac4c99ca9c7dad6','{}',1,'92bdd319f82b46e2be56c4a54357168d','2026-01-23 18:55:12','2026-01-23','default'),('b2ab5f1a983e4b4ab7299e3ce027859c','{\"tenantId\": \"816c197577a445e1815734cd206a12b2\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2026-01-23 18:57:48',NULL,'default'),('c422e27902f34c1ca768fe9634c3b2e2','{}',1,'92bdd319f82b46e2be56c4a54357168d','2026-01-23 18:22:09','2026-01-23','default'),('d4a5735653074fa8886b8853dbd6c101','{}',1,'92bdd319f82b46e2be56c4a54357168d','2026-01-23 18:22:20','2026-01-23','default'),('d55bec79358042d887f09f979b1641af','{}',1,'92bdd319f82b46e2be56c4a54357168d','2026-01-23 18:22:17','2026-01-23','default'),('df65ad12b38c44888f8fe0e48bbf314b','{}',1,'92bdd319f82b46e2be56c4a54357168d','2026-01-23 18:22:12','2026-01-23','default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `manila`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `manila` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `manila`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('aebe2a413e13');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `async_operation_data`
--

DROP TABLE IF EXISTS `async_operation_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `async_operation_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `async_operation_data`
--

LOCK TABLES `async_operation_data` WRITE;
/*!40000 ALTER TABLE `async_operation_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `async_operation_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `availability_zones`
--

DROP TABLE IF EXISTS `availability_zones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `availability_zones` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `az_name_uc` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `availability_zones`
--

LOCK TABLES `availability_zones` WRITE;
/*!40000 ALTER TABLE `availability_zones` DISABLE KEYS */;
INSERT INTO `availability_zones` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`) VALUES ('2026-01-23 18:55:15.890797',NULL,NULL,'False','5a2138fd-ba6d-48ad-9535-0dd6138ffaec','nova');
/*!40000 ALTER TABLE `availability_zones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backend_info`
--

DROP TABLE IF EXISTS `backend_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backend_info` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `host` varchar(255) NOT NULL,
  `info_hash` varchar(255) NOT NULL,
  PRIMARY KEY (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backend_info`
--

LOCK TABLES `backend_info` WRITE;
/*!40000 ALTER TABLE `backend_info` DISABLE KEYS */;
INSERT INTO `backend_info` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `host`, `info_hash`) VALUES ('2026-01-23 18:55:25.467209',NULL,NULL,0,'hostgroup@cephfs','e66c0dfc0d422efa26af62f5a81dd60603e2d39a');
/*!40000 ALTER TABLE `backend_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `drivers_private_data`
--

DROP TABLE IF EXISTS `drivers_private_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `drivers_private_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `drivers_private_data`
--

LOCK TABLES `drivers_private_data` WRITE;
/*!40000 ALTER TABLE `drivers_private_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `drivers_private_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_id` varchar(36) DEFAULT NULL,
  `action_id` varchar(10) NOT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
INSERT INTO `messages` (`id`, `project_id`, `request_id`, `resource_type`, `resource_id`, `action_id`, `detail_id`, `message_level`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `expires_at`) VALUES ('05f219bb-56b7-45b2-b957-72297c6864c0','08f0ac3daf4849ccbfe15d2f731f4f1f','req-0f6398c1-fa08-448a-bc54-86b32f02d46a','SHARE','88064b1f-2796-4781-8f3d-4593b6580021','001','008','ERROR','2026-01-23 19:03:56.057775',NULL,NULL,'False','2026-02-22 19:03:56'),('075634dc-dde3-4994-a280-f92f42131444','08f0ac3daf4849ccbfe15d2f731f4f1f','req-8542919d-1168-4694-afc8-729f0dc9aab3','SHARE','7834bedd-587b-48b5-86e3-9975b049f7a3','001','008','ERROR','2026-01-23 19:04:00.823464',NULL,'2026-01-23 19:04:04.148628','075634dc-dde3-4994-a280-f92f42131444','2026-02-22 19:04:00'),('138613ce-1580-485d-ba23-c689ebab9a81','08f0ac3daf4849ccbfe15d2f731f4f1f','req-a9a2f1ec-61c8-4411-a273-7c5a26ac0186','SHARE','2e64c116-8c52-41df-b4be-e03adb9e0bbe','001','008','ERROR','2026-01-23 19:03:52.512157',NULL,NULL,'False','2026-02-22 19:03:52'),('138dcf48-f7cf-4eb6-aff8-a1ceb6925202','e19ff7e178044a3f9516cdc773fa4d6b','req-0866f864-e46d-4cd5-8905-13e8748abd10','SHARE','3b030aa9-c2a3-412f-bf95-1476db82a6ad','010','020','ERROR','2026-01-23 19:02:17.665796',NULL,NULL,'False','2026-02-22 19:02:17'),('42dfbca5-7542-482d-9737-efdfdf1beb30','08f0ac3daf4849ccbfe15d2f731f4f1f','req-ce0401de-5d0f-4e62-b171-5dc0caa5abd9','SHARE','391232c3-3948-4ccb-a6c7-38654bac3ce2','001','008','ERROR','2026-01-23 19:03:32.503664',NULL,NULL,'False','2026-02-22 19:03:32'),('55387d0c-d3e6-4bc8-b874-609f986c4a55','08f0ac3daf4849ccbfe15d2f731f4f1f','req-a6b5f94a-7fc3-4a6a-a156-a9ce3559327e','SHARE','265aabd6-df6d-409b-81b1-b331c143ed96','001','008','ERROR','2026-01-23 19:03:44.333097',NULL,NULL,'False','2026-02-22 19:03:44'),('61a6c084-b2c8-4102-b0c5-3abbd4cbb448','3f9725edbd1b4cf299e129c2c7587203','req-b46359b3-d14b-48db-8e58-bb2371764353','SHARE','4d8f6ad2-640a-446d-9f8c-17c7e37baa77','001','008','ERROR','2026-01-23 19:03:26.584854',NULL,NULL,'False','2026-02-22 19:03:26'),('68d12e8b-40f8-4589-af21-e425d468a378','3f9725edbd1b4cf299e129c2c7587203','req-93d5d1af-1783-45ac-bb9b-93d534d337aa','SHARE','366a6c27-7a41-4ec7-85c2-8355e39c9e2b','001','008','ERROR','2026-01-23 19:03:34.746553',NULL,NULL,'False','2026-02-22 19:03:34'),('6b5f2c20-c68f-4421-8fa4-e73b23e27248','08f0ac3daf4849ccbfe15d2f731f4f1f','req-afe9a613-91b1-42ce-b07b-715277163712','SHARE','7d876ca7-1a61-4950-b214-03431c416d34','001','008','ERROR','2026-01-23 19:03:28.664088',NULL,NULL,'False','2026-02-22 19:03:28'),('6c6ae873-4577-458b-847b-1deede383b53','08f0ac3daf4849ccbfe15d2f731f4f1f','req-9c19881d-3a44-4b32-82f6-ad389d20473d','SHARE','29861bb5-32b3-471d-8b8b-fd8698202092','001','008','ERROR','2026-01-23 19:03:40.780377',NULL,NULL,'False','2026-02-22 19:03:40'),('72bf7227-42fd-48ac-b420-1c7ef795de18','3f9725edbd1b4cf299e129c2c7587203','req-c592d20d-dc7a-46ce-b63d-8f6bb1b2405a','SHARE','469ce416-fdcf-42ae-9fb1-1c87fce73818','001','008','ERROR','2026-01-23 19:03:38.982462',NULL,NULL,'False','2026-02-22 19:03:38'),('918f8120-f448-4406-ad71-74455664d233','3f9725edbd1b4cf299e129c2c7587203','req-1db5ff57-68cd-4061-a89f-dd9e77480979','SHARE','5328202d-ad99-407a-b316-29648f9d1631','001','008','ERROR','2026-01-23 19:03:30.660548',NULL,NULL,'False','2026-02-22 19:03:30'),('c40b0bbb-0369-45dc-b6e7-f7a5d3452b4f','08f0ac3daf4849ccbfe15d2f731f4f1f','req-22b1e1e4-eb09-4c99-ba61-0b58df1a009c','SHARE','dbac94e4-a674-42d5-a070-37b6c59282db','001','008','ERROR','2026-01-23 19:03:47.990727',NULL,NULL,'False','2026-02-22 19:03:47'),('c8fae66f-6683-40a2-91bd-85b5988c2645','08f0ac3daf4849ccbfe15d2f731f4f1f','req-51f5f350-0ba9-4596-8985-0b20c5404825','SHARE','abd86165-d5a5-4739-904a-95596ad006a9','001','008','ERROR','2026-01-23 19:03:36.363454',NULL,NULL,'False','2026-02-22 19:03:36'),('d9e8cb9e-bd14-4e4b-91c3-b64bc6e0ba0f','3f9725edbd1b4cf299e129c2c7587203','req-7e2795b0-c418-4972-a8cc-b0be1fcfa777','SHARE','e3437183-3378-4616-9647-d91c796bea3e','001','008','ERROR','2026-01-23 19:03:22.342273',NULL,NULL,'False','2026-02-22 19:03:22'),('f2b0c871-ee00-464a-a39b-d1d8bdf93c94','08f0ac3daf4849ccbfe15d2f731f4f1f','req-4c850ef2-a55f-4311-84dc-d93a6fba2553','SHARE','493e7f0d-e65f-4a69-bc39-608606a704e8','001','008','ERROR','2026-01-23 19:03:24.766146',NULL,'2026-01-23 19:03:28.052338','f2b0c871-ee00-464a-a39b-d1d8bdf93c94','2026-02-22 19:03:24');
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `network_allocations`
--

DROP TABLE IF EXISTS `network_allocations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `network_allocations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ip_address` varchar(64) DEFAULT NULL,
  `mac_address` varchar(32) DEFAULT NULL,
  `share_server_id` varchar(36) NOT NULL,
  `label` varchar(255) DEFAULT 'user',
  `network_type` varchar(32) DEFAULT NULL,
  `segmentation_id` int(11) DEFAULT NULL,
  `ip_version` int(11) DEFAULT NULL,
  `cidr` varchar(64) DEFAULT NULL,
  `gateway` varchar(64) DEFAULT NULL,
  `mtu` int(11) DEFAULT NULL,
  `share_network_subnet_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_server_id` (`share_server_id`),
  KEY `fk_network_allocation_subnet_id_share_network_subnets` (`share_network_subnet_id`),
  CONSTRAINT `fk_network_allocation_subnet_id_share_network_subnets` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`),
  CONSTRAINT `network_allocations_ibfk_1` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `network_allocations`
--

LOCK TABLES `network_allocations` WRITE;
/*!40000 ALTER TABLE `network_allocations` DISABLE KEYS */;
/*!40000 ALTER TABLE `network_allocations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_share_type_quotas`
--

DROP TABLE IF EXISTS `project_share_type_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_share_type_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uc_quotas_per_share_types` (`share_type_id`,`resource`,`deleted`,`project_id`),
  CONSTRAINT `share_type_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_share_type_quotas`
--

LOCK TABLES `project_share_type_quotas` WRITE;
/*!40000 ALTER TABLE `project_share_type_quotas` DISABLE KEYS */;
INSERT INTO `project_share_type_quotas` (`id`, `project_id`, `resource`, `hard_limit`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_type_id`) VALUES (1,'9e708dc344a64ca294a4473db436e198','shares',2,'2026-01-23 19:00:24.242219',NULL,'2026-01-23 19:01:16.490203',1,'d6086e5f-4d59-4e21-9550-2e32e22fbdf6'),(2,'9e708dc344a64ca294a4473db436e198','gigabytes',4,'2026-01-23 19:00:24.251505',NULL,'2026-01-23 19:01:16.490203',2,'d6086e5f-4d59-4e21-9550-2e32e22fbdf6'),(3,'9e708dc344a64ca294a4473db436e198','shares',2,'2026-01-23 19:00:24.468047',NULL,'2026-01-23 19:01:16.217158',3,'d9dd72be-5638-411d-adb4-977298762a87'),(4,'9e708dc344a64ca294a4473db436e198','gigabytes',4,'2026-01-23 19:00:24.472638',NULL,'2026-01-23 19:01:16.217158',4,'d9dd72be-5638-411d-adb4-977298762a87'),(5,'9e708dc344a64ca294a4473db436e198','shares',53,'2026-01-23 19:00:41.323323',NULL,'2026-01-23 19:00:41.688360',5,'fe1ae4c1-4e7d-4e4f-a296-9dc3f02f66e4'),(6,'9e708dc344a64ca294a4473db436e198','snapshots',53,'2026-01-23 19:00:41.337844',NULL,'2026-01-23 19:00:41.688360',6,'fe1ae4c1-4e7d-4e4f-a296-9dc3f02f66e4'),(7,'9e708dc344a64ca294a4473db436e198','gigabytes',1003,'2026-01-23 19:00:41.358379',NULL,'2026-01-23 19:00:41.688360',7,'fe1ae4c1-4e7d-4e4f-a296-9dc3f02f66e4'),(8,'9e708dc344a64ca294a4473db436e198','snapshot_gigabytes',1003,'2026-01-23 19:00:41.395066',NULL,'2026-01-23 19:00:41.688360',8,'fe1ae4c1-4e7d-4e4f-a296-9dc3f02f66e4'),(9,'9e708dc344a64ca294a4473db436e198','share_replicas',103,'2026-01-23 19:00:41.415348',NULL,'2026-01-23 19:00:41.688360',9,'fe1ae4c1-4e7d-4e4f-a296-9dc3f02f66e4'),(10,'9e708dc344a64ca294a4473db436e198','replica_gigabytes',1003,'2026-01-23 19:00:41.458632',NULL,'2026-01-23 19:00:41.688360',10,'fe1ae4c1-4e7d-4e4f-a296-9dc3f02f66e4'),(11,'9e708dc344a64ca294a4473db436e198','shares',53,'2026-01-23 19:00:42.265330',NULL,'2026-01-23 19:00:42.456339',11,'7d22c28a-bab0-4847-bdbf-5b1f68253190'),(12,'9e708dc344a64ca294a4473db436e198','snapshots',53,'2026-01-23 19:00:42.277263',NULL,'2026-01-23 19:00:42.456339',12,'7d22c28a-bab0-4847-bdbf-5b1f68253190'),(13,'9e708dc344a64ca294a4473db436e198','gigabytes',1003,'2026-01-23 19:00:42.293682',NULL,'2026-01-23 19:00:42.456339',13,'7d22c28a-bab0-4847-bdbf-5b1f68253190'),(14,'9e708dc344a64ca294a4473db436e198','snapshot_gigabytes',1003,'2026-01-23 19:00:42.307309',NULL,'2026-01-23 19:00:42.456339',14,'7d22c28a-bab0-4847-bdbf-5b1f68253190'),(15,'9e708dc344a64ca294a4473db436e198','share_replicas',103,'2026-01-23 19:00:42.316556',NULL,'2026-01-23 19:00:42.456339',15,'7d22c28a-bab0-4847-bdbf-5b1f68253190'),(16,'9e708dc344a64ca294a4473db436e198','replica_gigabytes',1003,'2026-01-23 19:00:42.360954',NULL,'2026-01-23 19:00:42.456339',16,'7d22c28a-bab0-4847-bdbf-5b1f68253190'),(17,'9e708dc344a64ca294a4473db436e198','shares',12,'2026-01-23 19:00:44.555047',NULL,'2026-01-23 19:01:15.645827',17,'de31c409-0480-47b7-a09f-ba5b43c6081a'),(18,'9e708dc344a64ca294a4473db436e198','shares',49,'2026-01-23 19:00:58.091541',NULL,'2026-01-23 19:01:14.172935',18,'71cf80fe-8ab2-49f3-8b42-dd4b205ff1ae'),(19,'9e708dc344a64ca294a4473db436e198','gigabytes',999,'2026-01-23 19:00:59.209962',NULL,'2026-01-23 19:01:14.172935',19,'71cf80fe-8ab2-49f3-8b42-dd4b205ff1ae'),(20,'9e708dc344a64ca294a4473db436e198','snapshots',49,'2026-01-23 19:00:59.400132',NULL,'2026-01-23 19:01:14.172935',20,'71cf80fe-8ab2-49f3-8b42-dd4b205ff1ae'),(21,'9e708dc344a64ca294a4473db436e198','snapshot_gigabytes',999,'2026-01-23 19:00:59.678791',NULL,'2026-01-23 19:01:14.172935',21,'71cf80fe-8ab2-49f3-8b42-dd4b205ff1ae'),(22,'9e708dc344a64ca294a4473db436e198','share_replicas',99,'2026-01-23 19:01:00.506026',NULL,'2026-01-23 19:01:14.172935',22,'71cf80fe-8ab2-49f3-8b42-dd4b205ff1ae'),(23,'9e708dc344a64ca294a4473db436e198','replica_gigabytes',999,'2026-01-23 19:01:00.837688',NULL,'2026-01-23 19:01:14.172935',23,'71cf80fe-8ab2-49f3-8b42-dd4b205ff1ae'),(24,'9e708dc344a64ca294a4473db436e198','shares',49,'2026-01-23 19:01:01.265366',NULL,'2026-01-23 19:01:13.254749',24,'b8db0a80-ec85-42c1-b292-cc539d8381ad'),(25,'9e708dc344a64ca294a4473db436e198','gigabytes',999,'2026-01-23 19:01:01.700476',NULL,'2026-01-23 19:01:13.254749',25,'b8db0a80-ec85-42c1-b292-cc539d8381ad'),(26,'9e708dc344a64ca294a4473db436e198','snapshots',49,'2026-01-23 19:01:02.161111',NULL,'2026-01-23 19:01:13.254749',26,'b8db0a80-ec85-42c1-b292-cc539d8381ad'),(27,'9e708dc344a64ca294a4473db436e198','snapshot_gigabytes',999,'2026-01-23 19:01:02.595269',NULL,'2026-01-23 19:01:13.254749',27,'b8db0a80-ec85-42c1-b292-cc539d8381ad'),(28,'9e708dc344a64ca294a4473db436e198','share_replicas',99,'2026-01-23 19:01:02.865760',NULL,'2026-01-23 19:01:13.254749',28,'b8db0a80-ec85-42c1-b292-cc539d8381ad'),(29,'9e708dc344a64ca294a4473db436e198','replica_gigabytes',999,'2026-01-23 19:01:03.774815',NULL,'2026-01-23 19:01:13.254749',29,'b8db0a80-ec85-42c1-b292-cc539d8381ad'),(30,'9e708dc344a64ca294a4473db436e198','shares',11,'2026-01-23 19:01:04.389570',NULL,'2026-01-23 19:01:12.912158',30,'e0e6fa64-95a6-4624-b32f-df2af84dc8d6'),(31,'9e708dc344a64ca294a4473db436e198','shares',-1,'2026-01-23 19:01:05.125595',NULL,'2026-01-23 19:01:12.406043',31,'dea7574c-f5d8-45d6-bb8e-5a8cf73f3f1f');
/*!40000 ALTER TABLE `project_share_type_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_user_quotas`
--

DROP TABLE IF EXISTS `project_user_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_user_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `resource` varchar(25) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_user_quotas`
--

LOCK TABLES `project_user_quotas` WRITE;
/*!40000 ALTER TABLE `project_user_quotas` DISABLE KEYS */;
INSERT INTO `project_user_quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `user_id`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2026-01-23 19:00:24.093494',NULL,'2026-01-23 19:00:40.574340',1,'03a60d2561c74d4285401ee890fe82a9','9e708dc344a64ca294a4473db436e198','shares',2),(2,'2026-01-23 19:00:24.097869',NULL,'2026-01-23 19:00:40.574340',2,'03a60d2561c74d4285401ee890fe82a9','9e708dc344a64ca294a4473db436e198','gigabytes',7),(3,'2026-01-23 19:00:44.403286',NULL,'2026-01-23 19:00:44.637741',3,'03a60d2561c74d4285401ee890fe82a9','9e708dc344a64ca294a4473db436e198','shares',11),(4,'2026-01-23 19:00:49.278698',NULL,'2026-01-23 19:00:49.429676',4,'03a60d2561c74d4285401ee890fe82a9','9e708dc344a64ca294a4473db436e198','gigabytes',-1),(5,'2026-01-23 19:00:49.563755',NULL,'2026-01-23 19:00:49.805542',5,'03a60d2561c74d4285401ee890fe82a9','9e708dc344a64ca294a4473db436e198','share_replicas',-1),(6,'2026-01-23 19:00:50.012760',NULL,'2026-01-23 19:00:50.397288',6,'03a60d2561c74d4285401ee890fe82a9','9e708dc344a64ca294a4473db436e198','replica_gigabytes',-1),(7,'2026-01-23 19:00:50.528733',NULL,'2026-01-23 19:00:51.044506',7,'03a60d2561c74d4285401ee890fe82a9','9e708dc344a64ca294a4473db436e198','share_networks',-1),(8,'2026-01-23 19:00:52.566790',NULL,'2026-01-23 19:00:52.897000',8,'03a60d2561c74d4285401ee890fe82a9','9e708dc344a64ca294a4473db436e198','shares',-1),(9,'2026-01-23 19:00:53.273513',NULL,'2026-01-23 19:00:54.070833',9,'03a60d2561c74d4285401ee890fe82a9','9e708dc344a64ca294a4473db436e198','snapshot_gigabytes',-1),(10,'2026-01-23 19:00:56.676262',NULL,'2026-01-23 19:00:57.359915',10,'03a60d2561c74d4285401ee890fe82a9','9e708dc344a64ca294a4473db436e198','snapshots',-1),(11,'2026-01-23 19:01:07.136350',NULL,'2026-01-23 19:01:07.266808',11,'03a60d2561c74d4285401ee890fe82a9','9e708dc344a64ca294a4473db436e198','gigabytes',999),(12,'2026-01-23 19:01:08.373095',NULL,'2026-01-23 19:01:08.448804',12,'03a60d2561c74d4285401ee890fe82a9','9e708dc344a64ca294a4473db436e198','share_replicas',99),(13,'2026-01-23 19:01:08.883652',NULL,'2026-01-23 19:01:08.947796',13,'03a60d2561c74d4285401ee890fe82a9','9e708dc344a64ca294a4473db436e198','replica_gigabytes',999),(14,'2026-01-23 19:01:09.103082',NULL,'2026-01-23 19:01:09.179852',14,'03a60d2561c74d4285401ee890fe82a9','9e708dc344a64ca294a4473db436e198','share_networks',9),(15,'2026-01-23 19:01:09.365167',NULL,'2026-01-23 19:01:09.564932',15,'03a60d2561c74d4285401ee890fe82a9','9e708dc344a64ca294a4473db436e198','shares',49),(16,'2026-01-23 19:01:10.238471',NULL,'2026-01-23 19:01:10.442566',16,'03a60d2561c74d4285401ee890fe82a9','9e708dc344a64ca294a4473db436e198','snapshot_gigabytes',999),(17,'2026-01-23 19:01:10.747210',NULL,'2026-01-23 19:01:10.807410',17,'03a60d2561c74d4285401ee890fe82a9','9e708dc344a64ca294a4473db436e198','snapshots',49),(18,'2026-01-23 19:01:11.017224',NULL,'2026-01-23 19:01:11.072702',18,'03a60d2561c74d4285401ee890fe82a9','9e708dc344a64ca294a4473db436e198','shares',11),(19,'2026-01-23 19:01:11.382905',NULL,'2026-01-23 19:01:11.457039',19,'03a60d2561c74d4285401ee890fe82a9','9e708dc344a64ca294a4473db436e198','shares',-1);
/*!40000 ALTER TABLE `project_user_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_usages_project_id` (`project_id`)
) ENGINE=InnoDB AUTO_INCREMENT=270 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `share_type_id`) VALUES ('2026-01-23 18:59:51.366332','2026-01-23 19:01:24.678235',NULL,0,1,'c1c8384de14c4a31ae08ff4e69a1c9bb','dcb726ed64514381891686f89d347595','shares',0,0,NULL,NULL),('2026-01-23 18:59:51.371996','2026-01-23 19:01:24.678238',NULL,0,2,'c1c8384de14c4a31ae08ff4e69a1c9bb','dcb726ed64514381891686f89d347595','gigabytes',0,0,NULL,NULL),('2026-01-23 18:59:51.655551','2026-01-23 19:01:24.678240','2026-01-23 19:01:28.040059',3,3,NULL,'dcb726ed64514381891686f89d347595','shares',0,0,NULL,'38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 18:59:51.658162','2026-01-23 19:01:24.678241','2026-01-23 19:01:28.040059',4,4,NULL,'dcb726ed64514381891686f89d347595','gigabytes',0,0,NULL,'38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 18:59:56.385895','2026-01-23 19:00:06.380442',NULL,0,5,'fe4bef7f11184042b5e32df18701003e','3f38697b55014585bfbeb92f42a147ef','shares',0,0,NULL,NULL),('2026-01-23 18:59:56.389278','2026-01-23 19:00:06.380446',NULL,0,6,'fe4bef7f11184042b5e32df18701003e','3f38697b55014585bfbeb92f42a147ef','gigabytes',0,0,NULL,NULL),('2026-01-23 18:59:56.401734','2026-01-23 19:00:06.380448','2026-01-23 19:00:08.212789',7,7,NULL,'3f38697b55014585bfbeb92f42a147ef','shares',0,0,NULL,'66b39355-b59e-45ea-8a76-32ccea2cc4b3'),('2026-01-23 18:59:56.404279','2026-01-23 19:00:06.380450','2026-01-23 19:00:08.212789',8,8,NULL,'3f38697b55014585bfbeb92f42a147ef','gigabytes',0,0,NULL,'66b39355-b59e-45ea-8a76-32ccea2cc4b3'),('2026-01-23 18:59:56.810461','2026-01-23 19:00:08.725075',NULL,0,9,'d1d451d7e0e64bd3b447c74b97e73217','91991deea63743aea683dc7e4ded5161','shares',0,0,NULL,NULL),('2026-01-23 18:59:56.816120','2026-01-23 19:00:08.725079',NULL,0,10,'d1d451d7e0e64bd3b447c74b97e73217','91991deea63743aea683dc7e4ded5161','gigabytes',0,0,NULL,NULL),('2026-01-23 18:59:56.830056','2026-01-23 19:00:08.725081','2026-01-23 19:00:11.764123',11,11,NULL,'91991deea63743aea683dc7e4ded5161','shares',0,0,NULL,'11eb753a-cfca-443f-8db2-def2cf1f0e7e'),('2026-01-23 18:59:56.832465','2026-01-23 19:00:08.725083','2026-01-23 19:00:11.764123',12,12,NULL,'91991deea63743aea683dc7e4ded5161','gigabytes',0,0,NULL,'11eb753a-cfca-443f-8db2-def2cf1f0e7e'),('2026-01-23 19:00:00.595822','2026-01-23 19:00:06.354684',NULL,0,13,'d1d451d7e0e64bd3b447c74b97e73217','91991deea63743aea683dc7e4ded5161','snapshots',0,0,NULL,NULL),('2026-01-23 19:00:00.599535','2026-01-23 19:00:06.354688',NULL,0,14,'d1d451d7e0e64bd3b447c74b97e73217','91991deea63743aea683dc7e4ded5161','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-23 19:00:00.615564','2026-01-23 19:00:06.354690','2026-01-23 19:00:11.764123',15,15,NULL,'91991deea63743aea683dc7e4ded5161','snapshots',0,0,NULL,'11eb753a-cfca-443f-8db2-def2cf1f0e7e'),('2026-01-23 19:00:00.619612','2026-01-23 19:00:06.354692','2026-01-23 19:00:11.764123',16,16,NULL,'91991deea63743aea683dc7e4ded5161','snapshot_gigabytes',0,0,NULL,'11eb753a-cfca-443f-8db2-def2cf1f0e7e'),('2026-01-23 19:00:12.078635','2026-01-23 19:00:19.208901',NULL,0,17,'64a77c2b0c554249a8bbe5c298b6f1ba','4c762eee821b41d1a7ec9015bb92a684','shares',0,0,NULL,NULL),('2026-01-23 19:00:12.080480','2026-01-23 19:00:19.208906',NULL,0,18,'64a77c2b0c554249a8bbe5c298b6f1ba','4c762eee821b41d1a7ec9015bb92a684','gigabytes',0,0,NULL,NULL),('2026-01-23 19:00:12.089935','2026-01-23 19:00:19.208909','2026-01-23 19:00:22.096731',19,19,NULL,'4c762eee821b41d1a7ec9015bb92a684','shares',0,0,NULL,'fd74222d-9aee-436c-9b35-942741042afa'),('2026-01-23 19:00:12.091689','2026-01-23 19:00:19.208912','2026-01-23 19:00:22.096731',20,20,NULL,'4c762eee821b41d1a7ec9015bb92a684','gigabytes',0,0,NULL,'fd74222d-9aee-436c-9b35-942741042afa'),('2026-01-23 19:00:24.584051','2026-01-23 19:00:36.324651','2026-01-23 19:00:40.576990',21,21,'03a60d2561c74d4285401ee890fe82a9','9e708dc344a64ca294a4473db436e198','shares',0,0,NULL,NULL),('2026-01-23 19:00:24.588026','2026-01-23 19:00:36.324655','2026-01-23 19:00:40.576990',22,22,'03a60d2561c74d4285401ee890fe82a9','9e708dc344a64ca294a4473db436e198','gigabytes',0,0,NULL,NULL),('2026-01-23 19:00:24.606141','2026-01-23 19:00:32.713503','2026-01-23 19:00:40.660253',23,23,NULL,'9e708dc344a64ca294a4473db436e198','shares',0,0,NULL,'d6086e5f-4d59-4e21-9550-2e32e22fbdf6'),('2026-01-23 19:00:24.614606','2026-01-23 19:00:32.713504','2026-01-23 19:00:40.660253',24,24,NULL,'9e708dc344a64ca294a4473db436e198','gigabytes',0,0,NULL,'d6086e5f-4d59-4e21-9550-2e32e22fbdf6'),('2026-01-23 19:00:28.141447','2026-01-23 19:01:20.535117',NULL,0,25,'c1c8384de14c4a31ae08ff4e69a1c9bb','dcb726ed64514381891686f89d347595','snapshots',0,0,NULL,NULL),('2026-01-23 19:00:28.143546','2026-01-23 19:01:20.535119',NULL,0,26,'c1c8384de14c4a31ae08ff4e69a1c9bb','dcb726ed64514381891686f89d347595','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-23 19:00:28.153876','2026-01-23 19:01:20.535121','2026-01-23 19:01:28.040059',27,27,NULL,'dcb726ed64514381891686f89d347595','snapshots',0,0,NULL,'38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:28.156195','2026-01-23 19:01:20.535122','2026-01-23 19:01:28.040059',28,28,NULL,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',0,0,NULL,'38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:28.378836','2026-01-23 19:00:36.324657','2026-01-23 19:00:40.660253',29,29,NULL,'9e708dc344a64ca294a4473db436e198','shares',0,0,NULL,'d9dd72be-5638-411d-adb4-977298762a87'),('2026-01-23 19:00:28.381567','2026-01-23 19:00:36.324659','2026-01-23 19:00:40.660253',30,30,NULL,'9e708dc344a64ca294a4473db436e198','gigabytes',0,0,NULL,'d9dd72be-5638-411d-adb4-977298762a87'),('2026-01-23 19:00:42.193798','2026-01-23 19:01:08.265537',NULL,0,31,'558d317bd62542eb9fe7a15800c7d18f','7976ff17c3f840919d65487c1a87daad','shares',0,0,NULL,NULL),('2026-01-23 19:00:42.195704','2026-01-23 19:01:08.265540',NULL,0,32,'558d317bd62542eb9fe7a15800c7d18f','7976ff17c3f840919d65487c1a87daad','gigabytes',0,0,NULL,NULL),('2026-01-23 19:00:42.217367','2026-01-23 19:01:08.265542','2026-01-23 19:01:11.296362',33,33,NULL,'7976ff17c3f840919d65487c1a87daad','shares',0,0,NULL,'2a58a533-a0c8-400a-8e5d-7f96a5448c79'),('2026-01-23 19:00:42.220211','2026-01-23 19:01:08.265543','2026-01-23 19:01:11.296362',34,34,NULL,'7976ff17c3f840919d65487c1a87daad','gigabytes',0,0,NULL,'2a58a533-a0c8-400a-8e5d-7f96a5448c79'),('2026-01-23 19:00:45.774081','2026-01-23 19:01:04.177628',NULL,0,35,'558d317bd62542eb9fe7a15800c7d18f','7976ff17c3f840919d65487c1a87daad','snapshots',0,0,NULL,NULL),('2026-01-23 19:00:45.778139','2026-01-23 19:01:04.177632',NULL,0,36,'558d317bd62542eb9fe7a15800c7d18f','7976ff17c3f840919d65487c1a87daad','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-23 19:00:45.800655','2026-01-23 19:01:04.177634','2026-01-23 19:01:11.296362',37,37,NULL,'7976ff17c3f840919d65487c1a87daad','snapshots',0,0,NULL,'2a58a533-a0c8-400a-8e5d-7f96a5448c79'),('2026-01-23 19:00:45.804632','2026-01-23 19:01:04.177636','2026-01-23 19:01:11.296362',38,38,NULL,'7976ff17c3f840919d65487c1a87daad','snapshot_gigabytes',0,0,NULL,'2a58a533-a0c8-400a-8e5d-7f96a5448c79'),('2026-01-23 19:01:21.664315','2026-01-23 19:01:21.715110','2026-01-23 19:01:25.500099',39,39,'1efc60dfafb740f48a10184f26e16386','1490bc1cfa8e446280d7d1f208cdd9cc','shares',1,0,NULL,NULL),('2026-01-23 19:01:21.667872','2026-01-23 19:01:21.715113','2026-01-23 19:01:25.500099',40,40,'1efc60dfafb740f48a10184f26e16386','1490bc1cfa8e446280d7d1f208cdd9cc','gigabytes',1,0,NULL,NULL),('2026-01-23 19:01:21.687914','2026-01-23 19:01:21.715114','2026-01-23 19:01:25.500099',41,41,NULL,'1490bc1cfa8e446280d7d1f208cdd9cc','shares',1,0,NULL,'f4a6bef4-70c7-455a-897f-b3e9b5f4c268'),('2026-01-23 19:01:21.690860','2026-01-23 19:01:21.715115','2026-01-23 19:01:25.500099',42,42,NULL,'1490bc1cfa8e446280d7d1f208cdd9cc','gigabytes',1,0,NULL,'f4a6bef4-70c7-455a-897f-b3e9b5f4c268'),('2026-01-23 19:01:25.707233','2026-01-23 19:01:27.690816','2026-01-23 19:01:37.128839',43,43,'1efc60dfafb740f48a10184f26e16386','1490bc1cfa8e446280d7d1f208cdd9cc','shares',2,0,NULL,NULL),('2026-01-23 19:01:25.714757','2026-01-23 19:01:27.690819','2026-01-23 19:01:37.128839',44,44,'1efc60dfafb740f48a10184f26e16386','1490bc1cfa8e446280d7d1f208cdd9cc','gigabytes',2,0,NULL,NULL),('2026-01-23 19:01:27.659147','2026-01-23 19:01:27.690822','2026-01-23 19:01:37.128839',45,45,NULL,'1490bc1cfa8e446280d7d1f208cdd9cc','shares',1,0,NULL,'88ad68ca-8786-477c-9b56-3373e78c4057'),('2026-01-23 19:01:27.662858','2026-01-23 19:01:27.690824','2026-01-23 19:01:37.128839',46,46,NULL,'1490bc1cfa8e446280d7d1f208cdd9cc','gigabytes',1,0,NULL,'88ad68ca-8786-477c-9b56-3373e78c4057'),('2026-01-23 19:01:31.416741','2026-01-23 19:01:31.888245','2026-01-23 19:01:37.128839',47,47,'1efc60dfafb740f48a10184f26e16386','1490bc1cfa8e446280d7d1f208cdd9cc','snapshots',1,0,NULL,NULL),('2026-01-23 19:01:31.419102','2026-01-23 19:01:31.888248','2026-01-23 19:01:37.128839',48,48,'1efc60dfafb740f48a10184f26e16386','1490bc1cfa8e446280d7d1f208cdd9cc','snapshot_gigabytes',1,0,NULL,NULL),('2026-01-23 19:01:31.588537','2026-01-23 19:01:31.888250','2026-01-23 19:01:37.128839',49,49,NULL,'1490bc1cfa8e446280d7d1f208cdd9cc','snapshots',1,0,NULL,'88ad68ca-8786-477c-9b56-3373e78c4057'),('2026-01-23 19:01:31.594888','2026-01-23 19:01:31.888251','2026-01-23 19:01:37.128839',50,50,NULL,'1490bc1cfa8e446280d7d1f208cdd9cc','snapshot_gigabytes',1,0,NULL,'88ad68ca-8786-477c-9b56-3373e78c4057'),('2026-01-23 19:01:43.945009','2026-01-23 19:02:50.990587',NULL,0,51,'58ba79b6c9994c0fb14affae9b8f0c8c','e19ff7e178044a3f9516cdc773fa4d6b','shares',0,0,NULL,NULL),('2026-01-23 19:01:43.946668','2026-01-23 19:02:50.990591',NULL,0,52,'58ba79b6c9994c0fb14affae9b8f0c8c','e19ff7e178044a3f9516cdc773fa4d6b','gigabytes',0,0,NULL,NULL),('2026-01-23 19:01:44.174656','2026-01-23 19:02:50.990592','2026-01-23 19:02:52.848185',53,53,NULL,'e19ff7e178044a3f9516cdc773fa4d6b','shares',0,0,NULL,'2edae7de-0cac-41e9-8dee-a7f49a9c9caa'),('2026-01-23 19:01:44.177796','2026-01-23 19:02:50.990593','2026-01-23 19:02:52.848185',54,54,NULL,'e19ff7e178044a3f9516cdc773fa4d6b','gigabytes',0,0,NULL,'2edae7de-0cac-41e9-8dee-a7f49a9c9caa'),('2026-01-23 19:01:47.972753','2026-01-23 19:02:46.265861',NULL,0,55,NULL,'e19ff7e178044a3f9516cdc773fa4d6b','shares',0,0,NULL,'fe8a42c9-28ea-4c66-bed3-f2f6d12529fa'),('2026-01-23 19:01:47.975637','2026-01-23 19:02:46.265862',NULL,0,56,NULL,'e19ff7e178044a3f9516cdc773fa4d6b','gigabytes',0,0,NULL,'fe8a42c9-28ea-4c66-bed3-f2f6d12529fa'),('2026-01-23 19:01:50.056992','2026-01-23 19:01:50.107674',NULL,0,57,'1efc60dfafb740f48a10184f26e16386','1490bc1cfa8e446280d7d1f208cdd9cc','snapshot_gigabytes',-1,0,NULL,NULL),('2026-01-23 19:01:50.066985','2026-01-23 19:01:50.107676',NULL,0,58,'1efc60dfafb740f48a10184f26e16386','1490bc1cfa8e446280d7d1f208cdd9cc','snapshots',-1,0,NULL,NULL),('2026-01-23 19:01:50.081474','2026-01-23 19:01:50.107678','2026-01-23 19:01:56.635625',59,59,NULL,'1490bc1cfa8e446280d7d1f208cdd9cc','snapshot_gigabytes',-1,0,NULL,'88ad68ca-8786-477c-9b56-3373e78c4057'),('2026-01-23 19:01:50.094861','2026-01-23 19:01:50.107679','2026-01-23 19:01:56.635625',60,60,NULL,'1490bc1cfa8e446280d7d1f208cdd9cc','snapshots',-1,0,NULL,'88ad68ca-8786-477c-9b56-3373e78c4057'),('2026-01-23 19:01:51.098912','2026-01-23 19:01:56.324328',NULL,0,61,'25ebb8b143d84bfab128a474701250d6','bd0d4498326a45708c5d8845efe3901e','shares',0,0,NULL,NULL),('2026-01-23 19:01:51.100848','2026-01-23 19:01:56.324332',NULL,0,62,'25ebb8b143d84bfab128a474701250d6','bd0d4498326a45708c5d8845efe3901e','gigabytes',0,0,NULL,NULL),('2026-01-23 19:01:51.109787','2026-01-23 19:01:56.324334','2026-01-23 19:01:59.176140',63,63,NULL,'bd0d4498326a45708c5d8845efe3901e','shares',0,0,NULL,'09dbe7c6-481d-459a-98b0-2e78689c591b'),('2026-01-23 19:01:51.111689','2026-01-23 19:01:56.324336','2026-01-23 19:01:59.176140',64,64,NULL,'bd0d4498326a45708c5d8845efe3901e','gigabytes',0,0,NULL,'09dbe7c6-481d-459a-98b0-2e78689c591b'),('2026-01-23 19:01:51.381554','2026-01-23 19:01:55.518610',NULL,0,65,'52e73d5a04a341b6a7e0bdd3001b9a03','e9255972eb454fca909aa1528e4f83a2','shares',0,0,NULL,NULL),('2026-01-23 19:01:51.390907','2026-01-23 19:01:55.518613',NULL,0,66,'52e73d5a04a341b6a7e0bdd3001b9a03','e9255972eb454fca909aa1528e4f83a2','gigabytes',0,0,NULL,NULL),('2026-01-23 19:01:51.404276','2026-01-23 19:01:55.518614','2026-01-23 19:01:58.440060',67,67,NULL,'e9255972eb454fca909aa1528e4f83a2','shares',0,0,NULL,'3c6be9a4-c34f-4d70-9659-317852304237'),('2026-01-23 19:01:51.406264','2026-01-23 19:01:55.518616','2026-01-23 19:01:58.440060',68,68,NULL,'e9255972eb454fca909aa1528e4f83a2','gigabytes',0,0,NULL,'3c6be9a4-c34f-4d70-9659-317852304237'),('2026-01-23 19:01:53.538686','2026-01-23 19:01:57.109345',NULL,0,69,'1efc60dfafb740f48a10184f26e16386','1490bc1cfa8e446280d7d1f208cdd9cc','shares',0,0,NULL,NULL),('2026-01-23 19:01:53.544061','2026-01-23 19:01:57.109348',NULL,0,70,'1efc60dfafb740f48a10184f26e16386','1490bc1cfa8e446280d7d1f208cdd9cc','gigabytes',0,0,NULL,NULL),('2026-01-23 19:01:53.557586','2026-01-23 19:01:53.573177','2026-01-23 19:01:56.635625',71,71,NULL,'1490bc1cfa8e446280d7d1f208cdd9cc','shares',0,0,NULL,'88ad68ca-8786-477c-9b56-3373e78c4057'),('2026-01-23 19:01:53.561237','2026-01-23 19:01:53.573178','2026-01-23 19:01:56.635625',72,72,NULL,'1490bc1cfa8e446280d7d1f208cdd9cc','gigabytes',0,0,NULL,'88ad68ca-8786-477c-9b56-3373e78c4057'),('2026-01-23 19:01:55.170483','2026-01-23 19:02:42.955454',NULL,0,73,'795d61c6748c4ee1963bd0cf94173c58','db171ed11cd54288960e2675bc51a3a1','shares',0,0,NULL,NULL),('2026-01-23 19:01:55.172271','2026-01-23 19:02:42.955457',NULL,0,74,'795d61c6748c4ee1963bd0cf94173c58','db171ed11cd54288960e2675bc51a3a1','gigabytes',0,0,NULL,NULL),('2026-01-23 19:01:55.187912','2026-01-23 19:02:42.955458',NULL,0,75,NULL,'db171ed11cd54288960e2675bc51a3a1','shares',0,0,NULL,'fe8a42c9-28ea-4c66-bed3-f2f6d12529fa'),('2026-01-23 19:01:55.190171','2026-01-23 19:02:42.955459',NULL,0,76,NULL,'db171ed11cd54288960e2675bc51a3a1','gigabytes',0,0,NULL,'fe8a42c9-28ea-4c66-bed3-f2f6d12529fa'),('2026-01-23 19:01:57.096997','2026-01-23 19:01:57.109349','2026-01-23 19:02:00.648105',77,77,NULL,'1490bc1cfa8e446280d7d1f208cdd9cc','shares',0,0,NULL,'f4a6bef4-70c7-455a-897f-b3e9b5f4c268'),('2026-01-23 19:01:57.099718','2026-01-23 19:01:57.109350','2026-01-23 19:02:00.648105',78,78,NULL,'1490bc1cfa8e446280d7d1f208cdd9cc','gigabytes',0,0,NULL,'f4a6bef4-70c7-455a-897f-b3e9b5f4c268'),('2026-01-23 19:02:04.176129','2026-01-23 19:02:07.292635',NULL,0,79,'d4854e7989914b0a8de972d4f7254ff2','0034e94cde5c402eb542d58e14a80d2c','share_networks',0,0,NULL,NULL),('2026-01-23 19:02:04.877183','2026-01-23 19:02:05.200752',NULL,0,80,'06e0d50765b84a109551bfac230deae0','1a8798b902e7464fa59d9b7585e84a49','share_networks',1,0,NULL,NULL),('2026-01-23 19:02:14.024075','2026-01-23 19:03:02.825349',NULL,0,81,'48aab17447ce4d90a8a1db613f1ea646','f2beea25a5e947aab5d0bb53058124cf','shares',0,0,NULL,NULL),('2026-01-23 19:02:14.026560','2026-01-23 19:03:02.825352',NULL,0,82,'48aab17447ce4d90a8a1db613f1ea646','f2beea25a5e947aab5d0bb53058124cf','gigabytes',0,0,NULL,NULL),('2026-01-23 19:02:14.037587','2026-01-23 19:03:02.825353','2026-01-23 19:03:06.435840',83,83,NULL,'f2beea25a5e947aab5d0bb53058124cf','shares',0,0,NULL,'5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:02:14.040096','2026-01-23 19:03:02.825355','2026-01-23 19:03:06.435840',84,84,NULL,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',0,0,NULL,'5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:02:16.504840','2026-01-23 19:02:30.814183',NULL,0,85,'cf78c38e3f6f4cae977f3610c4befcd9','dcaebac10d574ce2aa3ba16906fd5dbc','shares',0,0,NULL,NULL),('2026-01-23 19:02:16.506607','2026-01-23 19:02:30.814186',NULL,0,86,'cf78c38e3f6f4cae977f3610c4befcd9','dcaebac10d574ce2aa3ba16906fd5dbc','gigabytes',0,0,NULL,NULL),('2026-01-23 19:02:16.517452','2026-01-23 19:02:30.814187','2026-01-23 19:02:33.636016',87,87,NULL,'dcaebac10d574ce2aa3ba16906fd5dbc','shares',0,0,NULL,'c2e7b8e1-0b37-4bdc-b0cd-490536ec4c44'),('2026-01-23 19:02:16.519256','2026-01-23 19:02:30.814189','2026-01-23 19:02:33.636016',88,88,NULL,'dcaebac10d574ce2aa3ba16906fd5dbc','gigabytes',0,0,NULL,'c2e7b8e1-0b37-4bdc-b0cd-490536ec4c44'),('2026-01-23 19:02:16.609321','2026-01-23 19:02:21.915490',NULL,0,89,'d4699fb6f80746b4a636ab8962e102d0','538e549e0d1e4309a3c16b3a4f48e842','shares',0,0,NULL,NULL),('2026-01-23 19:02:16.612750','2026-01-23 19:02:21.915494',NULL,0,90,'d4699fb6f80746b4a636ab8962e102d0','538e549e0d1e4309a3c16b3a4f48e842','gigabytes',0,0,NULL,NULL),('2026-01-23 19:02:16.625956','2026-01-23 19:02:21.915496','2026-01-23 19:02:24.836444',91,91,NULL,'538e549e0d1e4309a3c16b3a4f48e842','shares',0,0,NULL,'c45f2ba3-7d51-4245-94b8-6909ec45f40d'),('2026-01-23 19:02:16.627843','2026-01-23 19:02:21.915497','2026-01-23 19:02:24.836444',92,92,NULL,'538e549e0d1e4309a3c16b3a4f48e842','gigabytes',0,0,NULL,'c45f2ba3-7d51-4245-94b8-6909ec45f40d'),('2026-01-23 19:02:24.583883','2026-01-23 19:02:39.273734','2026-01-23 19:02:52.848185',93,93,NULL,'db171ed11cd54288960e2675bc51a3a1','shares',0,0,NULL,'2edae7de-0cac-41e9-8dee-a7f49a9c9caa'),('2026-01-23 19:02:24.588829','2026-01-23 19:02:39.273735','2026-01-23 19:02:52.848185',94,94,NULL,'db171ed11cd54288960e2675bc51a3a1','gigabytes',0,0,NULL,'2edae7de-0cac-41e9-8dee-a7f49a9c9caa'),('2026-01-23 19:02:36.868501','2026-01-23 19:03:09.022687',NULL,0,95,'2caaa2bea59549f48039d35cd4c79c3d','8ea2dddd772b49f1b9e0a76f8a04e556','shares',0,0,NULL,NULL),('2026-01-23 19:02:36.874934','2026-01-23 19:03:09.022690',NULL,0,96,'2caaa2bea59549f48039d35cd4c79c3d','8ea2dddd772b49f1b9e0a76f8a04e556','gigabytes',0,0,NULL,NULL),('2026-01-23 19:02:36.886936','2026-01-23 19:03:09.022691','2026-01-23 19:03:12.058936',97,97,NULL,'8ea2dddd772b49f1b9e0a76f8a04e556','shares',0,0,NULL,'9d723286-feb8-4b59-ba94-db1ea3aa7f91'),('2026-01-23 19:02:36.889576','2026-01-23 19:03:09.022693','2026-01-23 19:03:12.058936',98,98,NULL,'8ea2dddd772b49f1b9e0a76f8a04e556','gigabytes',0,0,NULL,'9d723286-feb8-4b59-ba94-db1ea3aa7f91'),('2026-01-23 19:02:39.970905','2026-01-23 19:02:51.099755',NULL,0,99,'aab37409764d412dbda1be20cc09c609','a9e6aa878c9c4cbaba399c1a4dd39ad1','shares',0,0,NULL,NULL),('2026-01-23 19:02:39.973451','2026-01-23 19:02:51.099757',NULL,0,100,'aab37409764d412dbda1be20cc09c609','a9e6aa878c9c4cbaba399c1a4dd39ad1','gigabytes',0,0,NULL,NULL),('2026-01-23 19:02:39.990271','2026-01-23 19:02:51.099759','2026-01-23 19:02:53.910219',101,101,NULL,'a9e6aa878c9c4cbaba399c1a4dd39ad1','shares',0,0,NULL,'bdb8bf7b-3c8f-4c28-b5d9-d9a31db95eaa'),('2026-01-23 19:02:39.992377','2026-01-23 19:02:51.099760','2026-01-23 19:02:53.910219',102,102,NULL,'a9e6aa878c9c4cbaba399c1a4dd39ad1','gigabytes',0,0,NULL,'bdb8bf7b-3c8f-4c28-b5d9-d9a31db95eaa'),('2026-01-23 19:02:40.420434','2026-01-23 19:03:05.567763',NULL,0,103,'2caaa2bea59549f48039d35cd4c79c3d','8ea2dddd772b49f1b9e0a76f8a04e556','snapshots',0,0,NULL,NULL),('2026-01-23 19:02:40.422484','2026-01-23 19:03:05.567766',NULL,0,104,'2caaa2bea59549f48039d35cd4c79c3d','8ea2dddd772b49f1b9e0a76f8a04e556','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-23 19:02:40.433181','2026-01-23 19:03:05.567767','2026-01-23 19:03:12.058936',105,105,NULL,'8ea2dddd772b49f1b9e0a76f8a04e556','snapshots',0,0,NULL,'9d723286-feb8-4b59-ba94-db1ea3aa7f91'),('2026-01-23 19:02:40.435336','2026-01-23 19:03:05.567769','2026-01-23 19:03:12.058936',106,106,NULL,'8ea2dddd772b49f1b9e0a76f8a04e556','snapshot_gigabytes',0,0,NULL,'9d723286-feb8-4b59-ba94-db1ea3aa7f91'),('2026-01-23 19:02:43.332678','2026-01-23 19:02:47.562981',NULL,0,107,'aab37409764d412dbda1be20cc09c609','a9e6aa878c9c4cbaba399c1a4dd39ad1','snapshots',0,0,NULL,NULL),('2026-01-23 19:02:43.334296','2026-01-23 19:02:47.562984',NULL,0,108,'aab37409764d412dbda1be20cc09c609','a9e6aa878c9c4cbaba399c1a4dd39ad1','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-23 19:02:43.370260','2026-01-23 19:02:47.562985','2026-01-23 19:02:53.910219',109,109,NULL,'a9e6aa878c9c4cbaba399c1a4dd39ad1','snapshots',0,0,NULL,'bdb8bf7b-3c8f-4c28-b5d9-d9a31db95eaa'),('2026-01-23 19:02:43.372350','2026-01-23 19:02:47.562987','2026-01-23 19:02:53.910219',110,110,NULL,'a9e6aa878c9c4cbaba399c1a4dd39ad1','snapshot_gigabytes',0,0,NULL,'bdb8bf7b-3c8f-4c28-b5d9-d9a31db95eaa'),('2026-01-23 19:03:02.116259','2026-01-23 19:03:12.250679',NULL,0,111,'17ec91f691e54474893d8e435e589e7d','26ffaef7ee914dff8756a8885f9f07e2','shares',0,0,NULL,NULL),('2026-01-23 19:03:02.118374','2026-01-23 19:03:12.250683',NULL,0,112,'17ec91f691e54474893d8e435e589e7d','26ffaef7ee914dff8756a8885f9f07e2','gigabytes',0,0,NULL,NULL),('2026-01-23 19:03:02.127032','2026-01-23 19:03:12.250685','2026-01-23 19:03:15.333722',113,113,NULL,'26ffaef7ee914dff8756a8885f9f07e2','shares',0,0,NULL,'5970bbf1-902e-4fec-a95f-9ecee5bbb631'),('2026-01-23 19:03:02.128721','2026-01-23 19:03:12.250687','2026-01-23 19:03:15.333722',114,114,NULL,'26ffaef7ee914dff8756a8885f9f07e2','gigabytes',0,0,NULL,'5970bbf1-902e-4fec-a95f-9ecee5bbb631'),('2026-01-23 19:03:05.685821','2026-01-23 19:03:11.317068',NULL,0,115,'17ec91f691e54474893d8e435e589e7d','26ffaef7ee914dff8756a8885f9f07e2','snapshots',0,0,NULL,NULL),('2026-01-23 19:03:05.690157','2026-01-23 19:03:11.317071',NULL,0,116,'17ec91f691e54474893d8e435e589e7d','26ffaef7ee914dff8756a8885f9f07e2','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-23 19:03:05.722982','2026-01-23 19:03:11.317072','2026-01-23 19:03:15.333722',117,117,NULL,'26ffaef7ee914dff8756a8885f9f07e2','snapshots',0,0,NULL,'5970bbf1-902e-4fec-a95f-9ecee5bbb631'),('2026-01-23 19:03:05.736726','2026-01-23 19:03:11.317073','2026-01-23 19:03:15.333722',118,118,NULL,'26ffaef7ee914dff8756a8885f9f07e2','snapshot_gigabytes',0,0,NULL,'5970bbf1-902e-4fec-a95f-9ecee5bbb631'),('2026-01-23 19:03:19.593877','2026-01-23 19:06:50.568331',NULL,0,119,'39690acf77cd4929bf30d8ec50697f1a','1bedbf7265dc42cf859f02ee7f9194c5','shares',0,0,NULL,NULL),('2026-01-23 19:03:19.597363','2026-01-23 19:06:50.568334',NULL,0,120,'39690acf77cd4929bf30d8ec50697f1a','1bedbf7265dc42cf859f02ee7f9194c5','gigabytes',0,0,NULL,NULL),('2026-01-23 19:03:19.625881','2026-01-23 19:06:50.568336',NULL,0,121,NULL,'1bedbf7265dc42cf859f02ee7f9194c5','shares',1,0,NULL,'1cd0aa0c-256d-4747-b5c6-735c1e4e32e0'),('2026-01-23 19:03:19.628170','2026-01-23 19:06:50.568337',NULL,0,122,NULL,'1bedbf7265dc42cf859f02ee7f9194c5','gigabytes',1,0,NULL,'1cd0aa0c-256d-4747-b5c6-735c1e4e32e0'),('2026-01-23 19:03:22.095337','2026-01-23 19:03:42.602940',NULL,0,123,'b3ec277fe4624b46b687bc78d7cf6a03','3f9725edbd1b4cf299e129c2c7587203','shares',0,0,NULL,NULL),('2026-01-23 19:03:22.097631','2026-01-23 19:03:42.602943',NULL,0,124,'b3ec277fe4624b46b687bc78d7cf6a03','3f9725edbd1b4cf299e129c2c7587203','gigabytes',0,0,NULL,NULL),('2026-01-23 19:03:22.107977','2026-01-23 19:03:26.203258','2026-01-23 19:03:43.936096',125,125,NULL,'3f9725edbd1b4cf299e129c2c7587203','shares',0,0,NULL,'7362d9e0-868c-4044-a9a6-eed78870ee61'),('2026-01-23 19:03:22.110112','2026-01-23 19:03:26.203259','2026-01-23 19:03:43.936096',126,126,NULL,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',0,0,NULL,'7362d9e0-868c-4044-a9a6-eed78870ee61'),('2026-01-23 19:03:24.649194','2026-01-23 19:04:04.380456',NULL,0,127,'2fbff2750c964489941186e6647353bd','08f0ac3daf4849ccbfe15d2f731f4f1f','shares',0,0,NULL,NULL),('2026-01-23 19:03:24.651915','2026-01-23 19:04:04.380460',NULL,0,128,'2fbff2750c964489941186e6647353bd','08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',0,0,NULL,NULL),('2026-01-23 19:03:24.661589','2026-01-23 19:03:28.383591','2026-01-23 19:04:06.417501',129,129,NULL,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',0,0,NULL,'7902365b-5660-46c8-997e-208dd53ae844'),('2026-01-23 19:03:24.672656','2026-01-23 19:03:28.383592','2026-01-23 19:04:06.417501',130,130,NULL,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',0,0,NULL,'7902365b-5660-46c8-997e-208dd53ae844'),('2026-01-23 19:03:26.486132','2026-01-23 19:03:30.056035','2026-01-23 19:03:43.763214',131,131,NULL,'3f9725edbd1b4cf299e129c2c7587203','shares',0,0,NULL,'5bd00120-9b60-4196-9d38-c1e025658518'),('2026-01-23 19:03:26.488405','2026-01-23 19:03:30.056036','2026-01-23 19:03:43.763214',132,132,NULL,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',0,0,NULL,'5bd00120-9b60-4196-9d38-c1e025658518'),('2026-01-23 19:03:28.073025','2026-01-23 19:03:29.836962',NULL,0,133,'886ae9f8d85b45299215f046dc178830','a8836123057e49ac857e8374c9186ff3','share_networks',1,0,NULL,NULL),('2026-01-23 19:03:28.551651','2026-01-23 19:03:32.170846','2026-01-23 19:04:05.992079',134,134,NULL,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',0,0,NULL,'241a7152-12d1-48bb-b5c7-291a074f5b66'),('2026-01-23 19:03:28.553993','2026-01-23 19:03:32.170848','2026-01-23 19:04:05.992079',135,135,NULL,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',0,0,NULL,'241a7152-12d1-48bb-b5c7-291a074f5b66'),('2026-01-23 19:03:30.431950','2026-01-23 19:03:34.303600','2026-01-23 19:03:43.624627',136,136,NULL,'3f9725edbd1b4cf299e129c2c7587203','shares',0,0,NULL,'c19ff7fa-2a85-4740-abc5-3c03e603c222'),('2026-01-23 19:03:30.435888','2026-01-23 19:03:34.303601','2026-01-23 19:03:43.624627',137,137,NULL,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',0,0,NULL,'c19ff7fa-2a85-4740-abc5-3c03e603c222'),('2026-01-23 19:03:32.386892','2026-01-23 19:03:40.438141','2026-01-23 19:04:05.795850',138,138,NULL,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',0,0,NULL,'8a953b9f-99f3-477f-8f8b-a85b076a7406'),('2026-01-23 19:03:32.388712','2026-01-23 19:03:40.438142','2026-01-23 19:04:05.795850',139,139,NULL,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',0,0,NULL,'8a953b9f-99f3-477f-8f8b-a85b076a7406'),('2026-01-23 19:03:34.609000','2026-01-23 19:03:38.319056','2026-01-23 19:03:43.482981',140,140,NULL,'3f9725edbd1b4cf299e129c2c7587203','shares',0,0,NULL,'bccb681a-3222-4edc-857a-aaeddd11ad78'),('2026-01-23 19:03:34.611163','2026-01-23 19:03:38.319058','2026-01-23 19:03:43.482981',141,141,NULL,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',0,0,NULL,'bccb681a-3222-4edc-857a-aaeddd11ad78'),('2026-01-23 19:03:36.233592','2026-01-23 19:03:40.148302','2026-01-23 19:04:05.607093',142,142,NULL,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',0,0,NULL,'7f7e6a30-a2c4-443f-a0c5-e0dfdb57d9d3'),('2026-01-23 19:03:36.238071','2026-01-23 19:03:40.148303','2026-01-23 19:04:05.607093',143,143,NULL,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',0,0,NULL,'7f7e6a30-a2c4-443f-a0c5-e0dfdb57d9d3'),('2026-01-23 19:03:38.616577','2026-01-23 19:03:42.602944','2026-01-23 19:03:43.312291',144,144,NULL,'3f9725edbd1b4cf299e129c2c7587203','shares',0,0,NULL,'e14aad06-9466-486c-bc63-26592e0cdf52'),('2026-01-23 19:03:38.618749','2026-01-23 19:03:42.602945','2026-01-23 19:03:43.312291',145,145,NULL,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',0,0,NULL,'e14aad06-9466-486c-bc63-26592e0cdf52'),('2026-01-23 19:03:40.657446','2026-01-23 19:03:52.237831','2026-01-23 19:04:05.327937',146,146,NULL,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',0,0,NULL,'25eb52ab-ed01-4f19-94db-7202aa609ac2'),('2026-01-23 19:03:40.659737','2026-01-23 19:03:52.237832','2026-01-23 19:04:05.327937',147,147,NULL,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',0,0,NULL,'25eb52ab-ed01-4f19-94db-7202aa609ac2'),('2026-01-23 19:03:40.681224','2026-01-23 19:04:08.107875',NULL,0,148,'fd03ddd06d374af6aaab5af51dd14875','5ed6311cb89a4e81ac3637cb0a3cdbbe','shares',0,0,NULL,NULL),('2026-01-23 19:03:40.683503','2026-01-23 19:04:08.107878',NULL,0,149,'fd03ddd06d374af6aaab5af51dd14875','5ed6311cb89a4e81ac3637cb0a3cdbbe','gigabytes',0,0,NULL,NULL),('2026-01-23 19:03:40.692836','2026-01-23 19:04:08.107880','2026-01-23 19:04:11.193442',150,150,NULL,'5ed6311cb89a4e81ac3637cb0a3cdbbe','shares',0,0,NULL,'d4340069-92a0-40b1-9a2d-4931749a22be'),('2026-01-23 19:03:40.694999','2026-01-23 19:04:08.107881','2026-01-23 19:04:11.193442',151,151,NULL,'5ed6311cb89a4e81ac3637cb0a3cdbbe','gigabytes',0,0,NULL,'d4340069-92a0-40b1-9a2d-4931749a22be'),('2026-01-23 19:03:44.189498','2026-01-23 19:03:51.943425','2026-01-23 19:04:05.121032',152,152,NULL,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',0,0,NULL,'1b656fe8-9e38-4e1f-8896-27918147c270'),('2026-01-23 19:03:44.193121','2026-01-23 19:03:51.943426','2026-01-23 19:04:05.121032',153,153,NULL,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',0,0,NULL,'1b656fe8-9e38-4e1f-8896-27918147c270'),('2026-01-23 19:03:47.880115','2026-01-23 19:03:51.690700','2026-01-23 19:04:04.964117',154,154,NULL,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',0,0,NULL,'0cc522bc-772d-444b-91ef-721acf2d84b1'),('2026-01-23 19:03:47.882943','2026-01-23 19:03:51.690701','2026-01-23 19:04:04.964117',155,155,NULL,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',0,0,NULL,'0cc522bc-772d-444b-91ef-721acf2d84b1'),('2026-01-23 19:03:52.203910','2026-01-23 19:04:21.007320',NULL,0,156,'2b6dadb05d14498fb74d0e3ed633c1c2','182b21a4575a4acc866fcdd5f8991734','shares',0,0,NULL,NULL),('2026-01-23 19:03:52.206360','2026-01-23 19:04:21.007323',NULL,0,157,'2b6dadb05d14498fb74d0e3ed633c1c2','182b21a4575a4acc866fcdd5f8991734','gigabytes',0,0,NULL,NULL),('2026-01-23 19:03:52.216618','2026-01-23 19:04:21.007324','2026-01-23 19:04:23.006097',158,158,NULL,'182b21a4575a4acc866fcdd5f8991734','shares',0,0,NULL,'fc3dea75-7a38-41a5-9a53-1370369a0c3e'),('2026-01-23 19:03:52.218958','2026-01-23 19:04:21.007325','2026-01-23 19:04:23.006097',159,159,NULL,'182b21a4575a4acc866fcdd5f8991734','gigabytes',0,0,NULL,'fc3dea75-7a38-41a5-9a53-1370369a0c3e'),('2026-01-23 19:03:52.403502','2026-01-23 19:04:00.288285','2026-01-23 19:04:04.801308',160,160,NULL,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',0,0,NULL,'e9d1bb70-adca-4093-9b6e-5c2f0f61fbea'),('2026-01-23 19:03:52.405311','2026-01-23 19:04:00.288287','2026-01-23 19:04:04.801308',161,161,NULL,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',0,0,NULL,'e9d1bb70-adca-4093-9b6e-5c2f0f61fbea'),('2026-01-23 19:03:55.906487','2026-01-23 19:04:00.003035','2026-01-23 19:04:04.632439',162,162,NULL,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',0,0,NULL,'91c26460-9fbd-4287-97cf-8d78828587a3'),('2026-01-23 19:03:55.911927','2026-01-23 19:04:00.003037','2026-01-23 19:04:04.632439',163,163,NULL,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',0,0,NULL,'91c26460-9fbd-4287-97cf-8d78828587a3'),('2026-01-23 19:04:00.538076','2026-01-23 19:04:04.380462','2026-01-23 19:04:04.480701',164,164,NULL,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',0,0,NULL,'b1e1b985-0ef4-4803-84b5-18474a1939bf'),('2026-01-23 19:04:00.540162','2026-01-23 19:04:04.380464','2026-01-23 19:04:04.480701',165,165,NULL,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',0,0,NULL,'b1e1b985-0ef4-4803-84b5-18474a1939bf'),('2026-01-23 19:04:22.507008','2026-01-23 19:04:34.739845',NULL,0,166,'97e5b5856f774106be398a432c1a2e3a','e523821f05f24ee683a3bef9e5423573','shares',0,0,NULL,NULL),('2026-01-23 19:04:22.515703','2026-01-23 19:04:34.739847',NULL,0,167,'97e5b5856f774106be398a432c1a2e3a','e523821f05f24ee683a3bef9e5423573','gigabytes',0,0,NULL,NULL),('2026-01-23 19:04:22.550500','2026-01-23 19:04:34.739849','2026-01-23 19:04:48.103911',168,168,NULL,'e523821f05f24ee683a3bef9e5423573','shares',0,0,NULL,'d7fe3112-4905-44e0-a7a6-b013dde8491c'),('2026-01-23 19:04:22.552853','2026-01-23 19:04:34.739850','2026-01-23 19:04:48.103911',169,169,NULL,'e523821f05f24ee683a3bef9e5423573','gigabytes',0,0,NULL,'d7fe3112-4905-44e0-a7a6-b013dde8491c'),('2026-01-23 19:04:26.309663','2026-01-23 19:04:43.656506',NULL,0,170,'1a04690e8f284aa39ed37e0b6aa7b3ee','5d979c3ed74a492981b806cb6f7d0021','shares',0,0,NULL,NULL),('2026-01-23 19:04:26.311299','2026-01-23 19:04:43.656510',NULL,0,171,'1a04690e8f284aa39ed37e0b6aa7b3ee','5d979c3ed74a492981b806cb6f7d0021','gigabytes',0,0,NULL,NULL),('2026-01-23 19:04:26.399456','2026-01-23 19:04:43.656511','2026-01-23 19:04:48.103911',172,172,NULL,'5d979c3ed74a492981b806cb6f7d0021','shares',0,0,NULL,'d7fe3112-4905-44e0-a7a6-b013dde8491c'),('2026-01-23 19:04:26.401386','2026-01-23 19:04:43.656512','2026-01-23 19:04:48.103911',173,173,NULL,'5d979c3ed74a492981b806cb6f7d0021','gigabytes',0,0,NULL,'d7fe3112-4905-44e0-a7a6-b013dde8491c'),('2026-01-23 19:04:37.301748','2026-01-23 19:05:19.980846',NULL,0,174,'0cdc36ee00844d51a9bfb80f7be4a983','6e81efcadc1a4938a53855b68f0acfd2','shares',0,0,NULL,NULL),('2026-01-23 19:04:37.303646','2026-01-23 19:05:19.980848',NULL,0,175,'0cdc36ee00844d51a9bfb80f7be4a983','6e81efcadc1a4938a53855b68f0acfd2','gigabytes',0,0,NULL,NULL),('2026-01-23 19:04:37.952603','2026-01-23 19:05:19.980849','2026-01-23 19:05:23.721912',176,176,NULL,'6e81efcadc1a4938a53855b68f0acfd2','shares',0,0,NULL,'21de215f-d5bc-482a-9a75-67ea712434b1'),('2026-01-23 19:04:37.955650','2026-01-23 19:05:19.980851','2026-01-23 19:05:23.721912',177,177,NULL,'6e81efcadc1a4938a53855b68f0acfd2','gigabytes',0,0,NULL,'21de215f-d5bc-482a-9a75-67ea712434b1'),('2026-01-23 19:04:52.060149','2026-01-23 19:04:58.016844',NULL,0,178,'eeabb00740a8442eb5cb3065882b8ff9','6333b89cc67749f896506316d34639f6','shares',0,0,NULL,NULL),('2026-01-23 19:04:52.063051','2026-01-23 19:04:58.016848',NULL,0,179,'eeabb00740a8442eb5cb3065882b8ff9','6333b89cc67749f896506316d34639f6','gigabytes',0,0,NULL,NULL),('2026-01-23 19:04:52.075295','2026-01-23 19:04:58.016850','2026-01-23 19:05:02.738169',180,180,NULL,'6333b89cc67749f896506316d34639f6','shares',0,0,NULL,'d75ba714-c404-43a1-a9ef-110a3d3d2fa3'),('2026-01-23 19:04:52.077782','2026-01-23 19:04:58.016851','2026-01-23 19:05:02.738169',181,181,NULL,'6333b89cc67749f896506316d34639f6','gigabytes',0,0,NULL,'d75ba714-c404-43a1-a9ef-110a3d3d2fa3'),('2026-01-23 19:04:55.657352','2026-01-23 19:05:06.365953',NULL,0,182,'0cdc36ee00844d51a9bfb80f7be4a983','6e81efcadc1a4938a53855b68f0acfd2','share_groups',0,0,NULL,NULL),('2026-01-23 19:05:13.794352','2026-01-23 19:05:19.906051',NULL,0,183,'4cdaf3be00a843b7aca77970f17d1587','8ecf67da29b04bd89431f71cece6e5cf','shares',0,0,NULL,NULL),('2026-01-23 19:05:13.796438','2026-01-23 19:05:19.906055',NULL,0,184,'4cdaf3be00a843b7aca77970f17d1587','8ecf67da29b04bd89431f71cece6e5cf','gigabytes',0,0,NULL,NULL),('2026-01-23 19:05:14.046129','2026-01-23 19:05:19.906057','2026-01-23 19:05:22.731480',185,185,NULL,'8ecf67da29b04bd89431f71cece6e5cf','shares',0,0,NULL,'e2842727-9db2-48d3-8b3d-2a3115f7f601'),('2026-01-23 19:05:14.048949','2026-01-23 19:05:19.906058','2026-01-23 19:05:22.731480',186,186,NULL,'8ecf67da29b04bd89431f71cece6e5cf','gigabytes',0,0,NULL,'e2842727-9db2-48d3-8b3d-2a3115f7f601'),('2026-01-23 19:05:31.735903','2026-01-23 19:05:34.592261',NULL,0,187,'767061f8596f444f8e3ea7f80967fec5','b17f281119ff44cbbbf9816794032547','share_networks',0,0,NULL,NULL),('2026-01-23 19:05:32.879592','2026-01-23 19:07:03.007634',NULL,0,188,'0ee3b61db0254b40bc85214e7d348538','3fb8d4a8278546deacbbb6d960f5b0bb','shares',0,0,NULL,NULL),('2026-01-23 19:05:32.882846','2026-01-23 19:07:03.007637',NULL,0,189,'0ee3b61db0254b40bc85214e7d348538','3fb8d4a8278546deacbbb6d960f5b0bb','gigabytes',0,0,NULL,NULL),('2026-01-23 19:05:32.893920','2026-01-23 19:05:50.951404','2026-01-23 19:05:53.530457',190,190,NULL,'3fb8d4a8278546deacbbb6d960f5b0bb','shares',0,0,NULL,'52b6d957-ef7a-4cb1-b863-d97f55c93c1a'),('2026-01-23 19:05:32.896288','2026-01-23 19:05:50.951406','2026-01-23 19:05:53.530457',191,191,NULL,'3fb8d4a8278546deacbbb6d960f5b0bb','gigabytes',0,0,NULL,'52b6d957-ef7a-4cb1-b863-d97f55c93c1a'),('2026-01-23 19:05:34.513791','2026-01-23 19:06:50.842183',NULL,0,192,'7a1a35011363435a8a558e98e87b8831','ef50bedea4bc4cfd892c55fa7305015f','shares',0,0,NULL,NULL),('2026-01-23 19:05:34.521587','2026-01-23 19:06:50.842186',NULL,0,193,'7a1a35011363435a8a558e98e87b8831','ef50bedea4bc4cfd892c55fa7305015f','gigabytes',0,0,NULL,NULL),('2026-01-23 19:05:34.538183','2026-01-23 19:06:50.842187','2026-01-23 19:06:54.019947',194,194,NULL,'ef50bedea4bc4cfd892c55fa7305015f','shares',0,0,NULL,'4b614781-282f-426a-a8da-c9980601f345'),('2026-01-23 19:05:34.540775','2026-01-23 19:06:50.842188','2026-01-23 19:06:54.019947',195,195,NULL,'ef50bedea4bc4cfd892c55fa7305015f','gigabytes',0,0,NULL,'4b614781-282f-426a-a8da-c9980601f345'),('2026-01-23 19:05:36.409363','2026-01-23 19:06:59.469384',NULL,0,196,'0ee3b61db0254b40bc85214e7d348538','3fb8d4a8278546deacbbb6d960f5b0bb','snapshots',0,0,NULL,NULL),('2026-01-23 19:05:36.412571','2026-01-23 19:06:59.469387',NULL,0,197,'0ee3b61db0254b40bc85214e7d348538','3fb8d4a8278546deacbbb6d960f5b0bb','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-23 19:05:36.426072','2026-01-23 19:05:43.305728','2026-01-23 19:05:53.530457',198,198,NULL,'3fb8d4a8278546deacbbb6d960f5b0bb','snapshots',0,0,NULL,'52b6d957-ef7a-4cb1-b863-d97f55c93c1a'),('2026-01-23 19:05:36.429829','2026-01-23 19:05:43.305729','2026-01-23 19:05:53.530457',199,199,NULL,'3fb8d4a8278546deacbbb6d960f5b0bb','snapshot_gigabytes',0,0,NULL,'52b6d957-ef7a-4cb1-b863-d97f55c93c1a'),('2026-01-23 19:05:41.167556','2026-01-23 19:05:46.087882',NULL,0,200,'9c4042b5b9c640f89f2cced6d4f42a9b','283b89301a234374a4dbf7307759750d','share_networks',0,0,NULL,NULL),('2026-01-23 19:05:53.904296','2026-01-23 19:05:59.463966','2026-01-23 19:07:07.604135',201,201,NULL,'3fb8d4a8278546deacbbb6d960f5b0bb','shares',0,0,NULL,'f57d6e7a-ef40-49d3-9e68-6fb5a008c4a4'),('2026-01-23 19:05:53.906676','2026-01-23 19:05:59.463968','2026-01-23 19:07:07.604135',202,202,NULL,'3fb8d4a8278546deacbbb6d960f5b0bb','gigabytes',0,0,NULL,'f57d6e7a-ef40-49d3-9e68-6fb5a008c4a4'),('2026-01-23 19:06:02.191791','2026-01-23 19:07:03.007638','2026-01-23 19:07:06.257338',203,203,NULL,'3fb8d4a8278546deacbbb6d960f5b0bb','shares',0,0,NULL,'a231ee93-b5f1-4fc4-a3d2-0055417021c0'),('2026-01-23 19:06:02.197484','2026-01-23 19:07:03.007640','2026-01-23 19:07:06.257338',204,204,NULL,'3fb8d4a8278546deacbbb6d960f5b0bb','gigabytes',0,0,NULL,'a231ee93-b5f1-4fc4-a3d2-0055417021c0'),('2026-01-23 19:06:09.519802','2026-01-23 19:06:59.469389','2026-01-23 19:07:06.257338',205,205,NULL,'3fb8d4a8278546deacbbb6d960f5b0bb','snapshots',0,0,NULL,'a231ee93-b5f1-4fc4-a3d2-0055417021c0'),('2026-01-23 19:06:09.524290','2026-01-23 19:06:59.469390','2026-01-23 19:07:06.257338',206,206,NULL,'3fb8d4a8278546deacbbb6d960f5b0bb','snapshot_gigabytes',0,0,NULL,'a231ee93-b5f1-4fc4-a3d2-0055417021c0'),('2026-01-23 19:06:18.842026','2026-01-23 19:06:18.938557',NULL,0,207,'f395e891216c41888bac49e47c3ac432','05bdf608ce00460ba07de9e0ce988795','share_networks',1,0,NULL,NULL),('2026-01-23 19:06:26.652144','2026-01-23 19:06:40.576317',NULL,0,208,'b41c18afdb6346b291f5525a5b5aca4d','5ce1c1cb978d4655b95674240227e033','shares',1,0,NULL,NULL),('2026-01-23 19:06:26.654024','2026-01-23 19:06:40.576321',NULL,0,209,'b41c18afdb6346b291f5525a5b5aca4d','5ce1c1cb978d4655b95674240227e033','gigabytes',1,0,NULL,NULL),('2026-01-23 19:06:26.662618','2026-01-23 19:06:40.576322','2026-01-23 19:06:42.993395',210,210,NULL,'5ce1c1cb978d4655b95674240227e033','shares',1,0,NULL,'1339bb0a-ff5c-466e-9368-c1558d7331e6'),('2026-01-23 19:06:26.664895','2026-01-23 19:06:40.576324','2026-01-23 19:06:42.993395',211,211,NULL,'5ce1c1cb978d4655b95674240227e033','gigabytes',1,0,NULL,'1339bb0a-ff5c-466e-9368-c1558d7331e6'),('2026-01-23 19:06:30.650446','2026-01-23 19:06:31.925975',NULL,0,212,'1f380b30b01f4d3fa656e1f1627b7438','1e5a07e60ba9416db9dd4733653459eb','shares',0,0,NULL,NULL),('2026-01-23 19:06:30.652303','2026-01-23 19:06:31.925978',NULL,0,213,'1f380b30b01f4d3fa656e1f1627b7438','1e5a07e60ba9416db9dd4733653459eb','gigabytes',0,0,NULL,NULL),('2026-01-23 19:06:30.671802','2026-01-23 19:06:30.842699',NULL,0,214,'1f380b30b01f4d3fa656e1f1627b7438','5ce1c1cb978d4655b95674240227e033','shares',-1,0,NULL,NULL),('2026-01-23 19:06:30.673499','2026-01-23 19:06:30.842702',NULL,0,215,'1f380b30b01f4d3fa656e1f1627b7438','5ce1c1cb978d4655b95674240227e033','gigabytes',-1,0,NULL,NULL),('2026-01-23 19:06:31.622075','2026-01-23 19:06:31.925980','2026-01-23 19:06:42.993395',216,216,NULL,'1e5a07e60ba9416db9dd4733653459eb','shares',0,0,NULL,'1339bb0a-ff5c-466e-9368-c1558d7331e6'),('2026-01-23 19:06:31.626348','2026-01-23 19:06:31.925982','2026-01-23 19:06:42.993395',217,217,NULL,'1e5a07e60ba9416db9dd4733653459eb','gigabytes',0,0,NULL,'1339bb0a-ff5c-466e-9368-c1558d7331e6'),('2026-01-23 19:06:35.535160','2026-01-23 19:06:35.575969',NULL,0,218,'72c10a6dc7104c18ac27162d188683d7','1bedbf7265dc42cf859f02ee7f9194c5','shares',1,0,NULL,NULL),('2026-01-23 19:06:35.537571','2026-01-23 19:06:35.575970',NULL,0,219,'72c10a6dc7104c18ac27162d188683d7','1bedbf7265dc42cf859f02ee7f9194c5','gigabytes',1,0,NULL,NULL),('2026-01-23 19:07:09.721014','2026-01-23 19:07:12.755518',NULL,0,220,'02a38fd372d54825882d2b76e2408a99','8ef2e7b772bf414b9d6c084c7663325d','share_networks',0,0,NULL,NULL),('2026-01-23 19:07:14.181507','2026-01-23 19:07:20.869512',NULL,0,221,'968d5d01fead4ec5974c92681f5cd389','cd28fe6ab6ac42579a9ef7ca014c6978','share_networks',0,0,NULL,NULL),('2026-01-23 19:07:16.104283','2026-01-23 19:08:38.566595',NULL,0,222,'77520b512b09481594399d1d447d3353','998a3a4c23934c4dafb2e2112ce1af90','shares',0,0,NULL,NULL),('2026-01-23 19:07:16.106136','2026-01-23 19:08:38.566597',NULL,0,223,'77520b512b09481594399d1d447d3353','998a3a4c23934c4dafb2e2112ce1af90','gigabytes',0,0,NULL,NULL),('2026-01-23 19:07:16.116180','2026-01-23 19:08:38.566599','2026-01-23 19:08:41.604594',224,224,NULL,'998a3a4c23934c4dafb2e2112ce1af90','shares',0,0,NULL,'58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:07:16.117932','2026-01-23 19:08:38.566600','2026-01-23 19:08:41.604594',225,225,NULL,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',0,0,NULL,'58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:07:19.576065','2026-01-23 19:08:35.108107',NULL,0,226,'77520b512b09481594399d1d447d3353','998a3a4c23934c4dafb2e2112ce1af90','snapshots',0,0,NULL,NULL),('2026-01-23 19:07:19.578001','2026-01-23 19:08:35.108110',NULL,0,227,'77520b512b09481594399d1d447d3353','998a3a4c23934c4dafb2e2112ce1af90','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-23 19:07:19.588310','2026-01-23 19:08:35.108111','2026-01-23 19:08:41.604594',228,228,NULL,'998a3a4c23934c4dafb2e2112ce1af90','snapshots',0,0,NULL,'58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:07:19.592355','2026-01-23 19:08:35.108112','2026-01-23 19:08:41.604594',229,229,NULL,'998a3a4c23934c4dafb2e2112ce1af90','snapshot_gigabytes',0,0,NULL,'58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:07:28.764502','2026-01-23 19:07:56.563030',NULL,0,230,'8263f588feb3441b90a14974c5c7dfcf','c65808ebd8034050a7f642ca129ed6de','shares',0,0,NULL,NULL),('2026-01-23 19:07:28.766998','2026-01-23 19:07:56.563033',NULL,0,231,'8263f588feb3441b90a14974c5c7dfcf','c65808ebd8034050a7f642ca129ed6de','gigabytes',0,0,NULL,NULL),('2026-01-23 19:07:28.777228','2026-01-23 19:07:56.563034','2026-01-23 19:07:56.946676',232,232,NULL,'c65808ebd8034050a7f642ca129ed6de','shares',0,0,NULL,'a23d81ce-d5e1-43ae-b5f6-7a08ac609609'),('2026-01-23 19:07:28.779320','2026-01-23 19:07:56.563036','2026-01-23 19:07:56.946676',233,233,NULL,'c65808ebd8034050a7f642ca129ed6de','gigabytes',0,0,NULL,'a23d81ce-d5e1-43ae-b5f6-7a08ac609609'),('2026-01-23 19:07:32.520637','2026-01-23 19:07:50.557723',NULL,0,234,'8263f588feb3441b90a14974c5c7dfcf','c65808ebd8034050a7f642ca129ed6de','snapshots',0,0,NULL,NULL),('2026-01-23 19:07:32.523223','2026-01-23 19:07:50.557726',NULL,0,235,'8263f588feb3441b90a14974c5c7dfcf','c65808ebd8034050a7f642ca129ed6de','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-23 19:07:32.539087','2026-01-23 19:07:50.557728','2026-01-23 19:07:56.946676',236,236,NULL,'c65808ebd8034050a7f642ca129ed6de','snapshots',0,0,NULL,'a23d81ce-d5e1-43ae-b5f6-7a08ac609609'),('2026-01-23 19:07:32.542005','2026-01-23 19:07:50.557730','2026-01-23 19:07:56.946676',237,237,NULL,'c65808ebd8034050a7f642ca129ed6de','snapshot_gigabytes',0,0,NULL,'a23d81ce-d5e1-43ae-b5f6-7a08ac609609'),('2026-01-23 19:07:49.800403','2026-01-23 19:08:39.258380',NULL,0,238,'3deb3c1777d64f18bc9de677a095431d','8548bd568a5448648a2e519eb3ab357a','shares',0,0,NULL,NULL),('2026-01-23 19:07:49.802618','2026-01-23 19:08:39.258383',NULL,0,239,'3deb3c1777d64f18bc9de677a095431d','8548bd568a5448648a2e519eb3ab357a','gigabytes',0,0,NULL,NULL),('2026-01-23 19:07:49.812600','2026-01-23 19:08:39.258385','2026-01-23 19:08:42.341936',240,240,NULL,'8548bd568a5448648a2e519eb3ab357a','shares',0,0,NULL,'ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:07:49.814920','2026-01-23 19:08:39.258387','2026-01-23 19:08:42.341936',241,241,NULL,'8548bd568a5448648a2e519eb3ab357a','gigabytes',0,0,NULL,'ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:07:53.483055','2026-01-23 19:08:35.892624',NULL,0,242,'3deb3c1777d64f18bc9de677a095431d','8548bd568a5448648a2e519eb3ab357a','snapshots',0,0,NULL,NULL),('2026-01-23 19:07:53.487558','2026-01-23 19:08:35.892627',NULL,0,243,'3deb3c1777d64f18bc9de677a095431d','8548bd568a5448648a2e519eb3ab357a','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-23 19:07:53.501430','2026-01-23 19:08:35.892628','2026-01-23 19:08:42.341936',244,244,NULL,'8548bd568a5448648a2e519eb3ab357a','snapshots',0,0,NULL,'ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:07:53.504356','2026-01-23 19:08:35.892629','2026-01-23 19:08:42.341936',245,245,NULL,'8548bd568a5448648a2e519eb3ab357a','snapshot_gigabytes',0,0,NULL,'ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:08:05.150193','2026-01-23 19:09:01.319649',NULL,0,246,'06cf53b820e34c74b5ed6e38f590535c','b17f9a502db941108eaa44a3e9aa605c','shares',0,0,NULL,NULL),('2026-01-23 19:08:05.152552','2026-01-23 19:09:01.319652',NULL,0,247,'06cf53b820e34c74b5ed6e38f590535c','b17f9a502db941108eaa44a3e9aa605c','gigabytes',0,0,NULL,NULL),('2026-01-23 19:08:05.163651','2026-01-23 19:09:01.319653','2026-01-23 19:09:04.257812',248,248,NULL,'b17f9a502db941108eaa44a3e9aa605c','shares',0,0,NULL,'c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:05.165852','2026-01-23 19:09:01.319655','2026-01-23 19:09:04.257812',249,249,NULL,'b17f9a502db941108eaa44a3e9aa605c','gigabytes',0,0,NULL,'c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:08.549977','2026-01-23 19:08:57.823945',NULL,0,250,'06cf53b820e34c74b5ed6e38f590535c','b17f9a502db941108eaa44a3e9aa605c','snapshots',0,0,NULL,NULL),('2026-01-23 19:08:08.552142','2026-01-23 19:08:57.823948',NULL,0,251,'06cf53b820e34c74b5ed6e38f590535c','b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-23 19:08:08.561370','2026-01-23 19:08:57.823949','2026-01-23 19:09:04.257812',252,252,NULL,'b17f9a502db941108eaa44a3e9aa605c','snapshots',0,0,NULL,'c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:08.564875','2026-01-23 19:08:57.823950','2026-01-23 19:09:04.257812',253,253,NULL,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',0,0,NULL,'c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:50.605370','2026-01-23 19:09:02.894204',NULL,0,254,'9387f9e13c974a7b9c7352ead07a670a','25ab22f3f2214f1685af23b1e9f04ebe','shares',0,0,NULL,NULL),('2026-01-23 19:08:50.607937','2026-01-23 19:09:02.894208',NULL,0,255,'9387f9e13c974a7b9c7352ead07a670a','25ab22f3f2214f1685af23b1e9f04ebe','gigabytes',0,0,NULL,NULL),('2026-01-23 19:08:50.641560','2026-01-23 19:09:02.894210','2026-01-23 19:09:06.167214',256,256,NULL,'25ab22f3f2214f1685af23b1e9f04ebe','shares',0,0,NULL,'9d06412d-874f-45c2-b39d-2192c8184009'),('2026-01-23 19:08:50.643633','2026-01-23 19:09:02.894212','2026-01-23 19:09:06.167214',257,257,NULL,'25ab22f3f2214f1685af23b1e9f04ebe','gigabytes',0,0,NULL,'9d06412d-874f-45c2-b39d-2192c8184009'),('2026-01-23 19:08:54.043229','2026-01-23 19:08:59.110368',NULL,0,258,'9387f9e13c974a7b9c7352ead07a670a','25ab22f3f2214f1685af23b1e9f04ebe','snapshots',0,0,NULL,NULL),('2026-01-23 19:08:54.045728','2026-01-23 19:08:59.110372',NULL,0,259,'9387f9e13c974a7b9c7352ead07a670a','25ab22f3f2214f1685af23b1e9f04ebe','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-23 19:08:54.059372','2026-01-23 19:08:59.110374','2026-01-23 19:09:06.167214',260,260,NULL,'25ab22f3f2214f1685af23b1e9f04ebe','snapshots',0,0,NULL,'9d06412d-874f-45c2-b39d-2192c8184009'),('2026-01-23 19:08:54.062497','2026-01-23 19:08:59.110375','2026-01-23 19:09:06.167214',261,261,NULL,'25ab22f3f2214f1685af23b1e9f04ebe','snapshot_gigabytes',0,0,NULL,'9d06412d-874f-45c2-b39d-2192c8184009'),('2026-01-23 19:09:33.499319','2026-01-23 19:09:46.434447',NULL,0,262,'a622f76c64c643c1904e54c2dde49e5a','07e698407b254151a7a1ba401f6bb52e','shares',0,0,NULL,NULL),('2026-01-23 19:09:33.502255','2026-01-23 19:09:46.434450',NULL,0,263,'a622f76c64c643c1904e54c2dde49e5a','07e698407b254151a7a1ba401f6bb52e','gigabytes',0,0,NULL,NULL),('2026-01-23 19:09:33.516841','2026-01-23 19:09:46.434452','2026-01-23 19:09:49.436960',264,264,NULL,'07e698407b254151a7a1ba401f6bb52e','shares',0,0,NULL,'7d583f94-a44a-47c6-b6fb-99c2483a84cb'),('2026-01-23 19:09:33.520217','2026-01-23 19:09:46.434453','2026-01-23 19:09:49.436960',265,265,NULL,'07e698407b254151a7a1ba401f6bb52e','gigabytes',0,0,NULL,'7d583f94-a44a-47c6-b6fb-99c2483a84cb'),('2026-01-23 19:09:37.104702','2026-01-23 19:09:42.980470',NULL,0,266,'a622f76c64c643c1904e54c2dde49e5a','07e698407b254151a7a1ba401f6bb52e','snapshots',0,0,NULL,NULL),('2026-01-23 19:09:37.107076','2026-01-23 19:09:42.980474',NULL,0,267,'a622f76c64c643c1904e54c2dde49e5a','07e698407b254151a7a1ba401f6bb52e','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-23 19:09:37.126970','2026-01-23 19:09:42.980477','2026-01-23 19:09:49.436960',268,268,NULL,'07e698407b254151a7a1ba401f6bb52e','snapshots',0,0,NULL,'7d583f94-a44a-47c6-b6fb-99c2483a84cb'),('2026-01-23 19:09:37.131458','2026-01-23 19:09:42.980478','2026-01-23 19:09:49.436960',269,269,NULL,'07e698407b254151a7a1ba401f6bb52e','snapshot_gigabytes',0,0,NULL,'7d583f94-a44a-47c6-b6fb-99c2483a84cb');
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
INSERT INTO `quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2026-01-23 19:00:23.536109',NULL,'2026-01-23 19:00:40.654966',1,'9e708dc344a64ca294a4473db436e198','shares',3),(2,'2026-01-23 19:00:23.746789',NULL,'2026-01-23 19:00:40.654966',2,'9e708dc344a64ca294a4473db436e198','gigabytes',10),(3,'2026-01-23 19:00:41.022035',NULL,'2026-01-23 19:00:41.883792',3,'9e708dc344a64ca294a4473db436e198','shares',55),(4,'2026-01-23 19:00:41.038439',NULL,'2026-01-23 19:00:41.883792',4,'9e708dc344a64ca294a4473db436e198','snapshots',55),(5,'2026-01-23 19:00:41.054163',NULL,'2026-01-23 19:00:41.883792',5,'9e708dc344a64ca294a4473db436e198','gigabytes',1005),(6,'2026-01-23 19:00:41.077352',NULL,'2026-01-23 19:00:41.883792',6,'9e708dc344a64ca294a4473db436e198','snapshot_gigabytes',1005),(7,'2026-01-23 19:00:41.085136',NULL,'2026-01-23 19:00:41.883792',7,'9e708dc344a64ca294a4473db436e198','share_replicas',105),(8,'2026-01-23 19:00:41.093860',NULL,'2026-01-23 19:00:41.883792',8,'9e708dc344a64ca294a4473db436e198','replica_gigabytes',1005),(9,'2026-01-23 19:00:42.114980',NULL,'2026-01-23 19:00:42.654229',9,'9e708dc344a64ca294a4473db436e198','shares',55),(10,'2026-01-23 19:00:42.122475',NULL,'2026-01-23 19:00:42.654229',10,'9e708dc344a64ca294a4473db436e198','snapshots',55),(11,'2026-01-23 19:00:42.131520',NULL,'2026-01-23 19:00:42.654229',11,'9e708dc344a64ca294a4473db436e198','gigabytes',1005),(12,'2026-01-23 19:00:42.140763',NULL,'2026-01-23 19:00:42.654229',12,'9e708dc344a64ca294a4473db436e198','snapshot_gigabytes',1005),(13,'2026-01-23 19:00:42.157682',NULL,'2026-01-23 19:00:42.654229',13,'9e708dc344a64ca294a4473db436e198','share_replicas',105),(14,'2026-01-23 19:00:42.163526',NULL,'2026-01-23 19:00:42.654229',14,'9e708dc344a64ca294a4473db436e198','replica_gigabytes',1005),(15,'2026-01-23 19:00:42.889644',NULL,'2026-01-23 19:00:43.523108',15,'9e708dc344a64ca294a4473db436e198','shares',52),(16,'2026-01-23 19:00:43.128431',NULL,'2026-01-23 19:00:43.523108',16,'9e708dc344a64ca294a4473db436e198','snapshots',52),(17,'2026-01-23 19:00:43.140247',NULL,'2026-01-23 19:00:43.523108',17,'9e708dc344a64ca294a4473db436e198','gigabytes',1002),(18,'2026-01-23 19:00:43.255701',NULL,'2026-01-23 19:00:43.523108',18,'9e708dc344a64ca294a4473db436e198','snapshot_gigabytes',1002),(19,'2026-01-23 19:00:43.368660',NULL,'2026-01-23 19:00:43.523108',19,'9e708dc344a64ca294a4473db436e198','share_networks',12),(20,'2026-01-23 19:00:43.416464',NULL,'2026-01-23 19:00:43.523108',20,'9e708dc344a64ca294a4473db436e198','share_replicas',102),(21,'2026-01-23 19:00:43.435866',NULL,'2026-01-23 19:00:43.523108',21,'9e708dc344a64ca294a4473db436e198','replica_gigabytes',1002),(22,'2026-01-23 19:00:44.236602',NULL,'2026-01-23 19:00:44.701185',22,'9e708dc344a64ca294a4473db436e198','shares',13),(23,'2026-01-23 19:00:44.937197',NULL,'2026-01-23 19:00:45.138136',23,'9e708dc344a64ca294a4473db436e198','gigabytes',-1),(24,'2026-01-23 19:00:45.304300',NULL,'2026-01-23 19:00:45.794686',24,'9e708dc344a64ca294a4473db436e198','share_replicas',-1),(25,'2026-01-23 19:00:45.929883',NULL,'2026-01-23 19:00:46.166198',25,'9e708dc344a64ca294a4473db436e198','replica_gigabytes',-1),(26,'2026-01-23 19:00:46.599084',NULL,'2026-01-23 19:00:47.397469',26,'9e708dc344a64ca294a4473db436e198','share_networks',-1),(27,'2026-01-23 19:00:47.735633',NULL,'2026-01-23 19:00:47.908310',27,'9e708dc344a64ca294a4473db436e198','shares',-1),(28,'2026-01-23 19:00:48.405536',NULL,'2026-01-23 19:00:48.637175',28,'9e708dc344a64ca294a4473db436e198','snapshot_gigabytes',-1),(29,'2026-01-23 19:00:48.850035',NULL,'2026-01-23 19:00:49.073153',29,'9e708dc344a64ca294a4473db436e198','snapshots',-1),(30,'2026-01-23 19:01:04.152025',NULL,'2026-01-23 19:01:04.562178',30,'9e708dc344a64ca294a4473db436e198','shares',10),(31,'2026-01-23 19:01:04.916569',NULL,'2026-01-23 19:01:05.227965',31,'9e708dc344a64ca294a4473db436e198','shares',10),(32,'2026-01-23 19:01:05.594617',NULL,'2026-01-23 19:01:05.776359',32,'9e708dc344a64ca294a4473db436e198','gigabytes',1002),(33,'2026-01-23 19:01:05.979377',NULL,'2026-01-23 19:01:06.061083',33,'9e708dc344a64ca294a4473db436e198','share_networks',12),(34,'2026-01-23 19:01:06.241560',NULL,'2026-01-23 19:01:06.327082',34,'9e708dc344a64ca294a4473db436e198','shares',52),(35,'2026-01-23 19:01:06.593009',NULL,'2026-01-23 19:01:06.666201',35,'9e708dc344a64ca294a4473db436e198','snapshot_gigabytes',1002),(36,'2026-01-23 19:01:06.884644',NULL,'2026-01-23 19:01:06.948534',36,'9e708dc344a64ca294a4473db436e198','snapshots',52),(37,'2026-01-23 19:01:08.039868',NULL,'2026-01-23 19:01:08.185064',37,'9e708dc344a64ca294a4473db436e198','share_replicas',99),(38,'2026-01-23 19:01:08.672170',NULL,'2026-01-23 19:01:08.739132',38,'9e708dc344a64ca294a4473db436e198','replica_gigabytes',999),(39,'2026-01-23 19:01:10.916793',NULL,'2026-01-23 19:01:11.129846',39,'9e708dc344a64ca294a4473db436e198','shares',10),(40,'2026-01-23 19:01:11.208498',NULL,'2026-01-23 19:01:12.048571',40,'9e708dc344a64ca294a4473db436e198','shares',10),(41,'2026-01-23 19:01:25.270770',NULL,'2026-01-23 19:01:25.495496',41,'1490bc1cfa8e446280d7d1f208cdd9cc','shares',1),(42,'2026-01-23 19:01:31.293877',NULL,'2026-01-23 19:01:37.126111',42,'1490bc1cfa8e446280d7d1f208cdd9cc','snapshots',1),(43,'2026-01-23 19:01:45.691999',NULL,'2026-01-23 19:01:45.946780',43,'1490bc1cfa8e446280d7d1f208cdd9cc','shares',10),(44,'2026-01-23 19:01:46.271318',NULL,'2026-01-23 19:01:46.511254',44,'1490bc1cfa8e446280d7d1f208cdd9cc','shares',10);
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `usage_id` (`usage_id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=976 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `share_type_id`) VALUES ('2026-01-23 18:59:51.375096',NULL,'2026-01-23 18:59:53.274313',1,1,'c1c8384de14c4a31ae08ff4e69a1c9bb','03d0aa01-7577-4a7d-b75b-54a7a65b516a',1,'dcb726ed64514381891686f89d347595','shares',1,'2026-01-24 18:59:51',NULL),('2026-01-23 18:59:51.378200',NULL,'2026-01-23 18:59:53.274313',2,2,'c1c8384de14c4a31ae08ff4e69a1c9bb','32248e83-5591-47ac-ab46-3a032325a9f5',2,'dcb726ed64514381891686f89d347595','gigabytes',1,'2026-01-24 18:59:51',NULL),('2026-01-23 18:59:51.659688',NULL,'2026-01-23 18:59:53.274313',3,3,NULL,'1e91b6bf-16e5-4841-b598-681156c7572a',3,'dcb726ed64514381891686f89d347595','shares',1,'2026-01-24 18:59:51','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 18:59:51.660713',NULL,'2026-01-23 18:59:53.274313',4,4,NULL,'7f61c172-9b64-40dc-af94-74920806ef29',4,'dcb726ed64514381891686f89d347595','gigabytes',1,'2026-01-24 18:59:51','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 18:59:56.391592',NULL,'2026-01-23 18:59:56.440956',5,5,'fe4bef7f11184042b5e32df18701003e','52202be4-6ca8-46a7-a0e8-4a7e2c0d3905',5,'3f38697b55014585bfbeb92f42a147ef','shares',1,'2026-01-24 18:59:56',NULL),('2026-01-23 18:59:56.393476',NULL,'2026-01-23 18:59:56.440956',6,6,'fe4bef7f11184042b5e32df18701003e','90491d9a-d085-4bb6-b270-ca9d1ea30e85',6,'3f38697b55014585bfbeb92f42a147ef','gigabytes',1,'2026-01-24 18:59:56',NULL),('2026-01-23 18:59:56.406092',NULL,'2026-01-23 18:59:56.440956',7,7,NULL,'d9ec9c83-3970-447d-8b99-e081e0020f85',7,'3f38697b55014585bfbeb92f42a147ef','shares',1,'2026-01-24 18:59:56','66b39355-b59e-45ea-8a76-32ccea2cc4b3'),('2026-01-23 18:59:56.407208',NULL,'2026-01-23 18:59:56.440956',8,8,NULL,'88c0cf9a-d5e3-4f15-bfd1-d7af9488ad41',8,'3f38697b55014585bfbeb92f42a147ef','gigabytes',1,'2026-01-24 18:59:56','66b39355-b59e-45ea-8a76-32ccea2cc4b3'),('2026-01-23 18:59:56.822725',NULL,'2026-01-23 18:59:56.874183',9,9,'d1d451d7e0e64bd3b447c74b97e73217','ed1cedda-edae-4f62-a9a4-c0a90341ea41',9,'91991deea63743aea683dc7e4ded5161','shares',1,'2026-01-24 18:59:56',NULL),('2026-01-23 18:59:56.824094',NULL,'2026-01-23 18:59:56.874183',10,10,'d1d451d7e0e64bd3b447c74b97e73217','debe0c30-0c9d-4778-8943-3c9a6c79f286',10,'91991deea63743aea683dc7e4ded5161','gigabytes',1,'2026-01-24 18:59:56',NULL),('2026-01-23 18:59:56.834862',NULL,'2026-01-23 18:59:56.874183',11,11,NULL,'a10dcd3b-a1ac-4b42-a4f8-06dbf641226e',11,'91991deea63743aea683dc7e4ded5161','shares',1,'2026-01-24 18:59:56','11eb753a-cfca-443f-8db2-def2cf1f0e7e'),('2026-01-23 18:59:56.836119',NULL,'2026-01-23 18:59:56.874183',12,12,NULL,'44a51ab8-4a3d-468c-9e96-6a487abb6894',12,'91991deea63743aea683dc7e4ded5161','gigabytes',1,'2026-01-24 18:59:56','11eb753a-cfca-443f-8db2-def2cf1f0e7e'),('2026-01-23 18:59:57.010572',NULL,'2026-01-23 18:59:57.042484',13,13,'c1c8384de14c4a31ae08ff4e69a1c9bb','a1d95460-7b7c-4ac2-a4d0-3cda393cc440',1,'dcb726ed64514381891686f89d347595','shares',1,'2026-01-24 18:59:56',NULL),('2026-01-23 18:59:57.011602',NULL,'2026-01-23 18:59:57.042484',14,14,'c1c8384de14c4a31ae08ff4e69a1c9bb','297a4901-3a10-4aa9-b40a-736036b0e759',2,'dcb726ed64514381891686f89d347595','gigabytes',1,'2026-01-24 18:59:56',NULL),('2026-01-23 18:59:57.016810',NULL,'2026-01-23 18:59:57.042484',15,15,NULL,'2e88cb17-0208-4799-aaca-73921b8caa8b',3,'dcb726ed64514381891686f89d347595','shares',1,'2026-01-24 18:59:56','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 18:59:57.017836',NULL,'2026-01-23 18:59:57.042484',16,16,NULL,'76752db0-6e12-4ff6-b4fb-e6d9ff088910',4,'dcb726ed64514381891686f89d347595','gigabytes',1,'2026-01-24 18:59:56','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:00.601258',NULL,'2026-01-23 19:00:00.806809',17,17,'d1d451d7e0e64bd3b447c74b97e73217','7f1abbaf-f848-44bd-850a-63cf09c0d3ec',13,'91991deea63743aea683dc7e4ded5161','snapshots',1,'2026-01-24 19:00:00',NULL),('2026-01-23 19:00:00.602518',NULL,'2026-01-23 19:00:00.806809',18,18,'d1d451d7e0e64bd3b447c74b97e73217','7bdf496a-9511-4e18-afe3-28d533a5f926',14,'91991deea63743aea683dc7e4ded5161','snapshot_gigabytes',1,'2026-01-24 19:00:00',NULL),('2026-01-23 19:00:00.631850',NULL,'2026-01-23 19:00:00.806809',19,19,NULL,'87a0df29-96a2-408c-b1ea-11d0fffa9533',15,'91991deea63743aea683dc7e4ded5161','snapshots',1,'2026-01-24 19:00:00','11eb753a-cfca-443f-8db2-def2cf1f0e7e'),('2026-01-23 19:00:00.635079',NULL,'2026-01-23 19:00:00.806809',20,20,NULL,'1384ec3e-7e5f-4bcd-b4b3-83260c9bcf1a',16,'91991deea63743aea683dc7e4ded5161','snapshot_gigabytes',1,'2026-01-24 19:00:00','11eb753a-cfca-443f-8db2-def2cf1f0e7e'),('2026-01-23 19:00:00.651523',NULL,'2026-01-23 19:00:00.821966',21,21,'c1c8384de14c4a31ae08ff4e69a1c9bb','23e5c0f3-7d43-4708-b58f-d9fc3ca42c34',2,'dcb726ed64514381891686f89d347595','gigabytes',1,'2026-01-24 19:00:00',NULL),('2026-01-23 19:00:00.662472',NULL,'2026-01-23 19:00:00.821966',22,22,NULL,'cd22791f-0e23-4b16-94db-05e9105e20d3',4,'dcb726ed64514381891686f89d347595','gigabytes',1,'2026-01-24 19:00:00','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:04.352815',NULL,'2026-01-23 19:00:04.401632',23,23,'c1c8384de14c4a31ae08ff4e69a1c9bb','5e65bc2e-9c5c-4dff-a46b-bf1db2d96dc7',1,'dcb726ed64514381891686f89d347595','shares',-1,'2026-01-24 19:00:04',NULL),('2026-01-23 19:00:04.353805',NULL,'2026-01-23 19:00:04.401632',24,24,'c1c8384de14c4a31ae08ff4e69a1c9bb','d1b685dd-6f41-441f-8310-7a9bae503b94',2,'dcb726ed64514381891686f89d347595','gigabytes',-2,'2026-01-24 19:00:04',NULL),('2026-01-23 19:00:04.365265',NULL,'2026-01-23 19:00:04.401632',25,25,NULL,'518f1957-cc9b-40d0-bfa9-a7b4292aafcf',3,'dcb726ed64514381891686f89d347595','shares',-1,'2026-01-24 19:00:04','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:04.367099',NULL,'2026-01-23 19:00:04.401632',26,26,NULL,'b5aecbae-8f15-4197-83e8-f3c25510311a',4,'dcb726ed64514381891686f89d347595','gigabytes',-2,'2026-01-24 19:00:04','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:04.590847',NULL,'2026-01-23 19:00:04.630852',27,27,'c1c8384de14c4a31ae08ff4e69a1c9bb','bf520750-db2a-491d-88ee-3c15aae5e1e6',1,'dcb726ed64514381891686f89d347595','shares',1,'2026-01-24 19:00:04',NULL),('2026-01-23 19:00:04.592042',NULL,'2026-01-23 19:00:04.630852',28,28,'c1c8384de14c4a31ae08ff4e69a1c9bb','d00f640f-9563-46ff-aef6-d88bad138fd7',2,'dcb726ed64514381891686f89d347595','gigabytes',1,'2026-01-24 19:00:04',NULL),('2026-01-23 19:00:04.598923',NULL,'2026-01-23 19:00:04.630852',29,29,NULL,'264db7e6-362f-4f0d-8256-e2641445ed9b',3,'dcb726ed64514381891686f89d347595','shares',1,'2026-01-24 19:00:04','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:04.600498',NULL,'2026-01-23 19:00:04.630852',30,30,NULL,'3a365215-ce62-426f-b7ad-5927c3cccef8',4,'dcb726ed64514381891686f89d347595','gigabytes',1,'2026-01-24 19:00:04','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:05.077301',NULL,'2026-01-23 19:00:06.354250',31,31,'d1d451d7e0e64bd3b447c74b97e73217','6ca0b81e-f3a5-41b9-bb84-ee96d717d9ef',13,'91991deea63743aea683dc7e4ded5161','snapshots',-1,'2026-01-24 19:00:05',NULL),('2026-01-23 19:00:05.077996',NULL,'2026-01-23 19:00:06.354250',32,32,'d1d451d7e0e64bd3b447c74b97e73217','60f701a7-5410-462e-bea0-2a6ff4b48b39',14,'91991deea63743aea683dc7e4ded5161','snapshot_gigabytes',-1,'2026-01-24 19:00:05',NULL),('2026-01-23 19:00:05.329145',NULL,'2026-01-23 19:00:06.379856',33,33,'fe4bef7f11184042b5e32df18701003e','8ceba723-9274-4e64-9c4d-d5dbecf2c57a',5,'3f38697b55014585bfbeb92f42a147ef','shares',-1,'2026-01-24 19:00:05',NULL),('2026-01-23 19:00:05.345184',NULL,'2026-01-23 19:00:06.379856',34,34,'fe4bef7f11184042b5e32df18701003e','0fdb5baa-1e7b-4d0c-897a-346585803a0e',6,'3f38697b55014585bfbeb92f42a147ef','gigabytes',-1,'2026-01-24 19:00:05',NULL),('2026-01-23 19:00:05.389689',NULL,'2026-01-23 19:00:06.354250',35,35,NULL,'6eedd41d-da65-439b-a3f7-cf36c3292fcf',15,'91991deea63743aea683dc7e4ded5161','snapshots',-1,'2026-01-24 19:00:05','11eb753a-cfca-443f-8db2-def2cf1f0e7e'),('2026-01-23 19:00:05.390731',NULL,'2026-01-23 19:00:06.354250',36,36,NULL,'63a4f0d3-25c0-4d71-8dd8-0e359e4f838d',16,'91991deea63743aea683dc7e4ded5161','snapshot_gigabytes',-1,'2026-01-24 19:00:05','11eb753a-cfca-443f-8db2-def2cf1f0e7e'),('2026-01-23 19:00:06.160906',NULL,'2026-01-23 19:00:06.379856',37,37,NULL,'af6cb6ae-c8d9-463c-864e-6a8cf1cbcea9',7,'3f38697b55014585bfbeb92f42a147ef','shares',-1,'2026-01-24 19:00:05','66b39355-b59e-45ea-8a76-32ccea2cc4b3'),('2026-01-23 19:00:06.162096',NULL,'2026-01-23 19:00:06.379856',38,38,NULL,'ebdbd72e-b9a9-4ef2-8854-2b19472041e6',8,'3f38697b55014585bfbeb92f42a147ef','gigabytes',-1,'2026-01-24 19:00:05','66b39355-b59e-45ea-8a76-32ccea2cc4b3'),('2026-01-23 19:00:08.077832',NULL,'2026-01-23 19:00:08.687055',39,39,'c1c8384de14c4a31ae08ff4e69a1c9bb','008402e3-3c67-4004-8139-0ba29622adb8',2,'dcb726ed64514381891686f89d347595','gigabytes',1,'2026-01-24 19:00:08',NULL),('2026-01-23 19:00:08.210304',NULL,'2026-01-23 19:00:08.687055',40,40,NULL,'4822dd36-d5da-4860-9667-bfc075f911b1',4,'dcb726ed64514381891686f89d347595','gigabytes',1,'2026-01-24 19:00:08','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:08.691810',NULL,'2026-01-23 19:00:08.724530',41,41,'d1d451d7e0e64bd3b447c74b97e73217','7d3e024d-7db7-4290-a0c0-3f81407d6e29',9,'91991deea63743aea683dc7e4ded5161','shares',-1,'2026-01-24 19:00:08',NULL),('2026-01-23 19:00:08.693982',NULL,'2026-01-23 19:00:08.724530',42,42,'d1d451d7e0e64bd3b447c74b97e73217','e0a15894-7945-44d8-9360-9499e378fa49',10,'91991deea63743aea683dc7e4ded5161','gigabytes',-1,'2026-01-24 19:00:08',NULL),('2026-01-23 19:00:08.709125',NULL,'2026-01-23 19:00:08.724530',43,43,NULL,'714e3462-ee1e-402f-89e8-d53292646772',11,'91991deea63743aea683dc7e4ded5161','shares',-1,'2026-01-24 19:00:08','11eb753a-cfca-443f-8db2-def2cf1f0e7e'),('2026-01-23 19:00:08.711857',NULL,'2026-01-23 19:00:08.724530',44,44,NULL,'515725e9-a12f-47f3-be14-59dd82deb4d4',12,'91991deea63743aea683dc7e4ded5161','gigabytes',-1,'2026-01-24 19:00:08','11eb753a-cfca-443f-8db2-def2cf1f0e7e'),('2026-01-23 19:00:09.768379',NULL,'2026-01-23 19:00:09.785227',45,45,'c1c8384de14c4a31ae08ff4e69a1c9bb','50cc43a8-d367-4499-93cf-b8e539966b89',1,'dcb726ed64514381891686f89d347595','shares',-1,'2026-01-24 19:00:09',NULL),('2026-01-23 19:00:09.769186',NULL,'2026-01-23 19:00:09.785227',46,46,'c1c8384de14c4a31ae08ff4e69a1c9bb','103d1f63-8d1d-4121-9a22-e19e85cf96b7',2,'dcb726ed64514381891686f89d347595','gigabytes',-2,'2026-01-24 19:00:09',NULL),('2026-01-23 19:00:09.774749',NULL,'2026-01-23 19:00:09.785227',47,47,NULL,'fe93b7a6-bdcb-4b5a-a32b-95a582172471',3,'dcb726ed64514381891686f89d347595','shares',-1,'2026-01-24 19:00:09','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:09.775444',NULL,'2026-01-23 19:00:09.785227',48,48,NULL,'ce18db78-25a8-4207-a336-8eec427546d5',4,'dcb726ed64514381891686f89d347595','gigabytes',-2,'2026-01-24 19:00:09','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:12.082980',NULL,'2026-01-23 19:00:12.109933',49,49,'64a77c2b0c554249a8bbe5c298b6f1ba','27ccf6fc-1a05-48c0-96be-da2ed40e92a7',17,'4c762eee821b41d1a7ec9015bb92a684','shares',1,'2026-01-24 19:00:12',NULL),('2026-01-23 19:00:12.084377',NULL,'2026-01-23 19:00:12.109933',50,50,'64a77c2b0c554249a8bbe5c298b6f1ba','c2c8480b-0d2f-452b-bab5-4b0c9fc62044',18,'4c762eee821b41d1a7ec9015bb92a684','gigabytes',1,'2026-01-24 19:00:12',NULL),('2026-01-23 19:00:12.093145',NULL,'2026-01-23 19:00:12.109933',51,51,NULL,'0092e4c6-e730-4af2-8e3e-132df6a0e64c',19,'4c762eee821b41d1a7ec9015bb92a684','shares',1,'2026-01-24 19:00:12','fd74222d-9aee-436c-9b35-942741042afa'),('2026-01-23 19:00:12.094182',NULL,'2026-01-23 19:00:12.109933',52,52,NULL,'8fdf16aa-e193-4f53-a810-1e757346f1ed',20,'4c762eee821b41d1a7ec9015bb92a684','gigabytes',1,'2026-01-24 19:00:12','fd74222d-9aee-436c-9b35-942741042afa'),('2026-01-23 19:00:12.922193',NULL,'2026-01-23 19:00:12.981016',53,53,'c1c8384de14c4a31ae08ff4e69a1c9bb','ed9b554a-a0e1-4e12-83e6-3134fec53325',1,'dcb726ed64514381891686f89d347595','shares',1,'2026-01-24 19:00:12',NULL),('2026-01-23 19:00:12.927674',NULL,'2026-01-23 19:00:12.981016',54,54,'c1c8384de14c4a31ae08ff4e69a1c9bb','f2781cdd-f27f-44c2-a963-52efe08a0e73',2,'dcb726ed64514381891686f89d347595','gigabytes',1,'2026-01-24 19:00:12',NULL),('2026-01-23 19:00:12.946791',NULL,'2026-01-23 19:00:12.981016',55,55,NULL,'3108b028-ce4a-470e-bf8c-0c1c56080a4b',3,'dcb726ed64514381891686f89d347595','shares',1,'2026-01-24 19:00:12','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:12.947901',NULL,'2026-01-23 19:00:12.981016',56,56,NULL,'3bbba199-e67c-4f68-843c-10cc7169cb2d',4,'dcb726ed64514381891686f89d347595','gigabytes',1,'2026-01-24 19:00:12','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:17.204815',NULL,'2026-01-23 19:00:17.225266',57,57,'c1c8384de14c4a31ae08ff4e69a1c9bb','91b2d7cc-1708-4edc-b53a-491d1a225f2a',1,'dcb726ed64514381891686f89d347595','shares',-1,'2026-01-24 19:00:17',NULL),('2026-01-23 19:00:17.205744',NULL,'2026-01-23 19:00:17.225266',58,58,'c1c8384de14c4a31ae08ff4e69a1c9bb','3d616840-5e22-41dc-abb5-fe4aa1628672',2,'dcb726ed64514381891686f89d347595','gigabytes',-1,'2026-01-24 19:00:17',NULL),('2026-01-23 19:00:17.214851',NULL,'2026-01-23 19:00:17.225266',59,59,NULL,'5d4f2e03-f74a-40a7-a4c8-92e9b78f2a88',3,'dcb726ed64514381891686f89d347595','shares',-1,'2026-01-24 19:00:17','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:17.215574',NULL,'2026-01-23 19:00:17.225266',60,60,NULL,'c1d9b769-ad82-488e-a038-405c93725608',4,'dcb726ed64514381891686f89d347595','gigabytes',-1,'2026-01-24 19:00:17','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:18.927974',NULL,'2026-01-23 19:00:19.208190',61,61,'64a77c2b0c554249a8bbe5c298b6f1ba','db371992-8423-4343-b006-a1b3ed185e3c',17,'4c762eee821b41d1a7ec9015bb92a684','shares',-1,'2026-01-24 19:00:18',NULL),('2026-01-23 19:00:18.928713',NULL,'2026-01-23 19:00:19.208190',62,62,'64a77c2b0c554249a8bbe5c298b6f1ba','4b3a45a9-56fa-4dc2-98e2-98a51ec2359c',18,'4c762eee821b41d1a7ec9015bb92a684','gigabytes',-1,'2026-01-24 19:00:18',NULL),('2026-01-23 19:00:19.075223',NULL,'2026-01-23 19:00:19.208190',63,63,NULL,'c0b7b639-aa55-4188-9c23-753bf0c83d20',19,'4c762eee821b41d1a7ec9015bb92a684','shares',-1,'2026-01-24 19:00:18','fd74222d-9aee-436c-9b35-942741042afa'),('2026-01-23 19:00:19.076235',NULL,'2026-01-23 19:00:19.208190',64,64,NULL,'afbebe73-518c-4dc1-a37e-8527794f425b',20,'4c762eee821b41d1a7ec9015bb92a684','gigabytes',-1,'2026-01-24 19:00:18','fd74222d-9aee-436c-9b35-942741042afa'),('2026-01-23 19:00:20.573380',NULL,'2026-01-23 19:00:20.606915',65,65,'c1c8384de14c4a31ae08ff4e69a1c9bb','0e04a90b-52db-40e2-8c8c-7f658982fdf2',1,'dcb726ed64514381891686f89d347595','shares',1,'2026-01-24 19:00:20',NULL),('2026-01-23 19:00:20.574879',NULL,'2026-01-23 19:00:20.606915',66,66,'c1c8384de14c4a31ae08ff4e69a1c9bb','76204aa4-7da2-478e-a598-ad377dee6ce9',2,'dcb726ed64514381891686f89d347595','gigabytes',1,'2026-01-24 19:00:20',NULL),('2026-01-23 19:00:20.582449',NULL,'2026-01-23 19:00:20.606915',67,67,NULL,'d74af1c7-ac61-4cf9-afbd-e0b0499ef9e3',3,'dcb726ed64514381891686f89d347595','shares',1,'2026-01-24 19:00:20','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:20.585894',NULL,'2026-01-23 19:00:20.606915',68,68,NULL,'3da9b74d-65e0-4090-b6d1-e3300dc2bbfb',4,'dcb726ed64514381891686f89d347595','gigabytes',1,'2026-01-24 19:00:20','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:24.590524',NULL,'2026-01-23 19:00:24.649455',69,69,'03a60d2561c74d4285401ee890fe82a9','3652744e-4333-4e92-8d1b-dbc0a548fcd5',21,'9e708dc344a64ca294a4473db436e198','shares',1,'2026-01-24 19:00:24',NULL),('2026-01-23 19:00:24.591795',NULL,'2026-01-23 19:00:24.649455',70,70,'03a60d2561c74d4285401ee890fe82a9','d40a3980-1ab2-42a1-92cd-47594d2ab8cb',22,'9e708dc344a64ca294a4473db436e198','gigabytes',4,'2026-01-24 19:00:24',NULL),('2026-01-23 19:00:24.599541',NULL,'2026-01-23 19:00:24.619313',71,71,'c1c8384de14c4a31ae08ff4e69a1c9bb','d630fbd7-0f30-455d-b128-821da2c25b1b',1,'dcb726ed64514381891686f89d347595','shares',-1,'2026-01-24 19:00:24',NULL),('2026-01-23 19:00:24.600398',NULL,'2026-01-23 19:00:24.619313',72,72,'c1c8384de14c4a31ae08ff4e69a1c9bb','02081b2a-d730-4c9a-b4f5-be14134bf4c3',2,'dcb726ed64514381891686f89d347595','gigabytes',-1,'2026-01-24 19:00:24',NULL),('2026-01-23 19:00:24.606808',NULL,'2026-01-23 19:00:24.619313',73,73,NULL,'9e839778-2b2e-43c6-b01f-9b3ab72e96c5',3,'dcb726ed64514381891686f89d347595','shares',-1,'2026-01-24 19:00:24','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:24.607669',NULL,'2026-01-23 19:00:24.619313',74,74,NULL,'f03f3f3e-e0bf-456e-bc33-6937205f5032',4,'dcb726ed64514381891686f89d347595','gigabytes',-1,'2026-01-24 19:00:24','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:24.626122',NULL,'2026-01-23 19:00:24.649455',75,75,NULL,'31804e91-755c-4fc9-957e-822b40560854',23,'9e708dc344a64ca294a4473db436e198','shares',1,'2026-01-24 19:00:24','d6086e5f-4d59-4e21-9550-2e32e22fbdf6'),('2026-01-23 19:00:24.627640',NULL,'2026-01-23 19:00:24.649455',76,76,NULL,'65bc2da9-ee69-4bc1-805d-402d23d5de08',24,'9e708dc344a64ca294a4473db436e198','gigabytes',4,'2026-01-24 19:00:24','d6086e5f-4d59-4e21-9550-2e32e22fbdf6'),('2026-01-23 19:00:28.015270',NULL,'2026-01-23 19:00:28.090191',77,77,'03a60d2561c74d4285401ee890fe82a9','39a75576-9515-4646-8cbb-d097dd281d49',21,'9e708dc344a64ca294a4473db436e198','shares',1,'2026-01-24 19:00:27',NULL),('2026-01-23 19:00:28.017053',NULL,'2026-01-23 19:00:28.090191',78,78,'03a60d2561c74d4285401ee890fe82a9','a3f05d98-6638-439f-87dd-5d1dea9e4e23',22,'9e708dc344a64ca294a4473db436e198','gigabytes',3,'2026-01-24 19:00:27',NULL),('2026-01-23 19:00:28.145376',NULL,'2026-01-23 19:00:28.214377',79,79,'c1c8384de14c4a31ae08ff4e69a1c9bb','57ca32d7-d428-4598-8555-59c4a448d597',25,'dcb726ed64514381891686f89d347595','snapshots',1,'2026-01-24 19:00:28',NULL),('2026-01-23 19:00:28.146616',NULL,'2026-01-23 19:00:28.214377',80,80,'c1c8384de14c4a31ae08ff4e69a1c9bb','a081884f-53fc-4d60-a39c-fa5ee17bc179',26,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',1,'2026-01-24 19:00:28',NULL),('2026-01-23 19:00:28.157740',NULL,'2026-01-23 19:00:28.214377',81,81,NULL,'6953fdd5-ebfd-4cf6-bcb7-d7101c674c84',27,'dcb726ed64514381891686f89d347595','snapshots',1,'2026-01-24 19:00:28','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:28.158791',NULL,'2026-01-23 19:00:28.214377',82,82,NULL,'e6806aeb-ead7-4f5a-b65e-e45ff1e5ba10',28,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',1,'2026-01-24 19:00:28','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:28.363876',NULL,'2026-01-23 19:00:28.406065',83,83,'03a60d2561c74d4285401ee890fe82a9','d33dd4b7-b1d6-4952-a0cc-fc593aedba22',21,'9e708dc344a64ca294a4473db436e198','shares',1,'2026-01-24 19:00:28',NULL),('2026-01-23 19:00:28.369552',NULL,'2026-01-23 19:00:28.406065',84,84,'03a60d2561c74d4285401ee890fe82a9','f817d9aa-15cb-4dd8-a222-768fd1f1fbbe',22,'9e708dc344a64ca294a4473db436e198','gigabytes',3,'2026-01-24 19:00:28',NULL),('2026-01-23 19:00:28.383322',NULL,'2026-01-23 19:00:28.406065',85,85,NULL,'9c993063-b5d0-4b19-953a-1d9b3b681f65',29,'9e708dc344a64ca294a4473db436e198','shares',1,'2026-01-24 19:00:28','d9dd72be-5638-411d-adb4-977298762a87'),('2026-01-23 19:00:28.384834',NULL,'2026-01-23 19:00:28.406065',86,86,NULL,'71eeecd9-5bfc-4b41-a461-f0c29ed82556',30,'9e708dc344a64ca294a4473db436e198','gigabytes',3,'2026-01-24 19:00:28','d9dd72be-5638-411d-adb4-977298762a87'),('2026-01-23 19:00:32.320208',NULL,'2026-01-23 19:00:32.341817',87,87,'c1c8384de14c4a31ae08ff4e69a1c9bb','6e7bfd32-7860-4918-a5e6-d2960199452c',25,'dcb726ed64514381891686f89d347595','snapshots',-1,'2026-01-24 19:00:32',NULL),('2026-01-23 19:00:32.322092',NULL,'2026-01-23 19:00:32.341817',88,88,'c1c8384de14c4a31ae08ff4e69a1c9bb','0d6eca78-4591-4334-bd4e-666154fb0af7',26,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',-1,'2026-01-24 19:00:32',NULL),('2026-01-23 19:00:32.330214',NULL,'2026-01-23 19:00:32.341817',89,89,NULL,'ed5a25e2-2899-4851-8b45-4e76458e376e',27,'dcb726ed64514381891686f89d347595','snapshots',-1,'2026-01-24 19:00:32','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:32.332039',NULL,'2026-01-23 19:00:32.341817',90,90,NULL,'850774e8-5e96-402c-9246-9a9e96c6757b',28,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',-1,'2026-01-24 19:00:32','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:32.694769',NULL,'2026-01-23 19:00:32.713027',91,91,'03a60d2561c74d4285401ee890fe82a9','8d2feef4-77aa-4240-996a-c3fcce1ace6e',21,'9e708dc344a64ca294a4473db436e198','shares',-1,'2026-01-24 19:00:32',NULL),('2026-01-23 19:00:32.697700',NULL,'2026-01-23 19:00:32.713027',92,92,'03a60d2561c74d4285401ee890fe82a9','43b82a8c-ff4b-493c-9fba-95fd4c26d612',22,'9e708dc344a64ca294a4473db436e198','gigabytes',-4,'2026-01-24 19:00:32',NULL),('2026-01-23 19:00:32.704456',NULL,'2026-01-23 19:00:32.713027',93,93,NULL,'ca3b66ec-89d0-420b-ab1f-399b021bff8d',23,'9e708dc344a64ca294a4473db436e198','shares',-1,'2026-01-24 19:00:32','d6086e5f-4d59-4e21-9550-2e32e22fbdf6'),('2026-01-23 19:00:32.705176',NULL,'2026-01-23 19:00:32.713027',94,94,NULL,'02bc438f-2398-4433-8122-102dd7aed57d',24,'9e708dc344a64ca294a4473db436e198','gigabytes',-4,'2026-01-24 19:00:32','d6086e5f-4d59-4e21-9550-2e32e22fbdf6'),('2026-01-23 19:00:36.255740',NULL,'2026-01-23 19:00:36.323997',95,95,'03a60d2561c74d4285401ee890fe82a9','b73f3942-dcb1-4e23-9019-d07dba960a08',21,'9e708dc344a64ca294a4473db436e198','shares',-1,'2026-01-24 19:00:36',NULL),('2026-01-23 19:00:36.256564',NULL,'2026-01-23 19:00:36.323997',96,96,'03a60d2561c74d4285401ee890fe82a9','0358478c-8536-49e6-9ce0-3d020b5acedd',22,'9e708dc344a64ca294a4473db436e198','gigabytes',-3,'2026-01-24 19:00:36',NULL),('2026-01-23 19:00:36.306793',NULL,'2026-01-23 19:00:36.323997',97,97,NULL,'2055ec66-687b-4d91-8fad-b3191ff8e5ad',29,'9e708dc344a64ca294a4473db436e198','shares',-1,'2026-01-24 19:00:36','d9dd72be-5638-411d-adb4-977298762a87'),('2026-01-23 19:00:36.308060',NULL,'2026-01-23 19:00:36.323997',98,98,NULL,'45d088a0-b605-40cc-90d1-196a2187b8e2',30,'9e708dc344a64ca294a4473db436e198','gigabytes',-3,'2026-01-24 19:00:36','d9dd72be-5638-411d-adb4-977298762a87'),('2026-01-23 19:00:41.811083',NULL,'2026-01-23 19:00:41.965195',99,99,'c1c8384de14c4a31ae08ff4e69a1c9bb','45ea143f-5fc4-4c88-9e47-d48f9e1e1b58',25,'dcb726ed64514381891686f89d347595','snapshots',1,'2026-01-24 19:00:41',NULL),('2026-01-23 19:00:41.812902',NULL,'2026-01-23 19:00:41.965195',100,100,'c1c8384de14c4a31ae08ff4e69a1c9bb','2306b2f7-ae52-48ca-9850-7c2209c7d542',26,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',1,'2026-01-24 19:00:41',NULL),('2026-01-23 19:00:41.831388',NULL,'2026-01-23 19:00:41.965195',101,101,NULL,'2a1ae55d-ef80-4233-a4d6-cc1275797a26',27,'dcb726ed64514381891686f89d347595','snapshots',1,'2026-01-24 19:00:41','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:41.832943',NULL,'2026-01-23 19:00:41.965195',102,102,NULL,'b5107869-6866-47a1-9a77-ba0ddbf3897f',28,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',1,'2026-01-24 19:00:41','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:42.197309',NULL,'2026-01-23 19:00:42.264520',103,103,'558d317bd62542eb9fe7a15800c7d18f','5532f674-682c-4975-920d-796a47c4e62a',31,'7976ff17c3f840919d65487c1a87daad','shares',1,'2026-01-24 19:00:42',NULL),('2026-01-23 19:00:42.199050',NULL,'2026-01-23 19:00:42.264520',104,104,'558d317bd62542eb9fe7a15800c7d18f','3975a736-f068-43b1-9319-c56599bcdca5',32,'7976ff17c3f840919d65487c1a87daad','gigabytes',1,'2026-01-24 19:00:42',NULL),('2026-01-23 19:00:42.222851',NULL,'2026-01-23 19:00:42.264520',105,105,NULL,'8d2eb2b0-c324-4faa-a4c9-ac5e5dd18cab',33,'7976ff17c3f840919d65487c1a87daad','shares',1,'2026-01-24 19:00:42','2a58a533-a0c8-400a-8e5d-7f96a5448c79'),('2026-01-23 19:00:42.225252',NULL,'2026-01-23 19:00:42.264520',106,106,NULL,'42876ffb-43f7-4c3b-8209-3e953d42d9c7',34,'7976ff17c3f840919d65487c1a87daad','gigabytes',1,'2026-01-24 19:00:42','2a58a533-a0c8-400a-8e5d-7f96a5448c79'),('2026-01-23 19:00:45.780758',NULL,'2026-01-23 19:00:46.101006',107,107,'558d317bd62542eb9fe7a15800c7d18f','1859f210-0768-4288-9e24-38ac80681f44',35,'7976ff17c3f840919d65487c1a87daad','snapshots',1,'2026-01-24 19:00:45',NULL),('2026-01-23 19:00:45.782490',NULL,'2026-01-23 19:00:46.101006',108,108,'558d317bd62542eb9fe7a15800c7d18f','fdd356b0-fcc1-4030-a89d-b860104ecf53',36,'7976ff17c3f840919d65487c1a87daad','snapshot_gigabytes',1,'2026-01-24 19:00:45',NULL),('2026-01-23 19:00:45.807216',NULL,'2026-01-23 19:00:46.101006',109,109,NULL,'205ae90a-898a-488d-837b-4505fcae01c8',37,'7976ff17c3f840919d65487c1a87daad','snapshots',1,'2026-01-24 19:00:45','2a58a533-a0c8-400a-8e5d-7f96a5448c79'),('2026-01-23 19:00:45.808763',NULL,'2026-01-23 19:00:46.101006',110,110,NULL,'aa7347df-d9fc-427c-97b8-f101feb751d4',38,'7976ff17c3f840919d65487c1a87daad','snapshot_gigabytes',1,'2026-01-24 19:00:45','2a58a533-a0c8-400a-8e5d-7f96a5448c79'),('2026-01-23 19:00:46.205922',NULL,'2026-01-23 19:00:47.282678',111,111,'c1c8384de14c4a31ae08ff4e69a1c9bb','f721e62d-8154-4434-840a-c3ad274cec3a',25,'dcb726ed64514381891686f89d347595','snapshots',1,'2026-01-24 19:00:46',NULL),('2026-01-23 19:00:46.211353',NULL,'2026-01-23 19:00:47.282678',112,112,'c1c8384de14c4a31ae08ff4e69a1c9bb','90508089-15f2-4794-9231-fd7c0d088465',26,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',1,'2026-01-24 19:00:46',NULL),('2026-01-23 19:00:46.518958',NULL,'2026-01-23 19:00:47.282678',113,113,NULL,'8edf18ee-fdf3-43a9-b6a0-e123c58cc921',27,'dcb726ed64514381891686f89d347595','snapshots',1,'2026-01-24 19:00:46','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:46.520946',NULL,'2026-01-23 19:00:47.282678',114,114,NULL,'2e22ad32-f20f-460b-913e-3edcea05b854',28,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',1,'2026-01-24 19:00:46','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:52.579351',NULL,'2026-01-23 19:00:52.844713',115,115,'558d317bd62542eb9fe7a15800c7d18f','6a6051c4-2387-4ed7-8748-ef29a53aa463',35,'7976ff17c3f840919d65487c1a87daad','snapshots',1,'2026-01-24 19:00:52',NULL),('2026-01-23 19:00:52.580937',NULL,'2026-01-23 19:00:52.844713',116,116,'558d317bd62542eb9fe7a15800c7d18f','7d8cc708-6da3-4ab7-805a-063348eae957',36,'7976ff17c3f840919d65487c1a87daad','snapshot_gigabytes',1,'2026-01-24 19:00:52',NULL),('2026-01-23 19:00:52.677617',NULL,'2026-01-23 19:00:52.844713',117,117,NULL,'2103ea1f-8612-4ed5-93b9-23449037e584',37,'7976ff17c3f840919d65487c1a87daad','snapshots',1,'2026-01-24 19:00:52','2a58a533-a0c8-400a-8e5d-7f96a5448c79'),('2026-01-23 19:00:52.679965',NULL,'2026-01-23 19:00:52.844713',118,118,NULL,'56c3ac3d-efbe-4580-992a-5c8491360857',38,'7976ff17c3f840919d65487c1a87daad','snapshot_gigabytes',1,'2026-01-24 19:00:52','2a58a533-a0c8-400a-8e5d-7f96a5448c79'),('2026-01-23 19:00:52.730551',NULL,'2026-01-23 19:00:53.197058',119,119,'c1c8384de14c4a31ae08ff4e69a1c9bb','fbe91b3c-168e-4019-a94d-b86dac97b4c9',25,'dcb726ed64514381891686f89d347595','snapshots',1,'2026-01-24 19:00:52',NULL),('2026-01-23 19:00:52.731717',NULL,'2026-01-23 19:00:53.197058',120,120,'c1c8384de14c4a31ae08ff4e69a1c9bb','7e597764-f15f-472c-ac7d-a91d6b6893d0',26,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',1,'2026-01-24 19:00:52',NULL),('2026-01-23 19:00:52.828871',NULL,'2026-01-23 19:00:53.197058',121,121,NULL,'5388598f-7563-412c-acf0-a33852d7054f',27,'dcb726ed64514381891686f89d347595','snapshots',1,'2026-01-24 19:00:52','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:52.831560',NULL,'2026-01-23 19:00:53.197058',122,122,NULL,'5554ea01-d215-461f-81f4-d84a944d80e9',28,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',1,'2026-01-24 19:00:52','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:58.080283',NULL,'2026-01-23 19:00:59.189958',123,123,'c1c8384de14c4a31ae08ff4e69a1c9bb','a6800cd4-d6fd-40fc-8ad7-222d140fa43a',25,'dcb726ed64514381891686f89d347595','snapshots',1,'2026-01-24 19:00:58',NULL),('2026-01-23 19:00:58.081806',NULL,'2026-01-23 19:00:59.189958',124,124,'c1c8384de14c4a31ae08ff4e69a1c9bb','1405bf90-fd8b-4217-8b65-12616b756ae9',26,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',1,'2026-01-24 19:00:58',NULL),('2026-01-23 19:00:59.002552',NULL,'2026-01-23 19:00:59.189958',125,125,NULL,'f66d0368-ec63-4925-94a7-559fa541bb15',27,'dcb726ed64514381891686f89d347595','snapshots',1,'2026-01-24 19:00:58','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:00:59.007081',NULL,'2026-01-23 19:00:59.189958',126,126,NULL,'9c0f66cb-f385-45c4-80c5-c1a50fb31e64',28,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',1,'2026-01-24 19:00:58','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:01:00.383887',NULL,'2026-01-23 19:01:00.551716',127,127,'558d317bd62542eb9fe7a15800c7d18f','9097e3f5-fa63-479b-b7c1-526999529e6a',35,'7976ff17c3f840919d65487c1a87daad','snapshots',-1,'2026-01-24 19:01:00',NULL),('2026-01-23 19:01:00.384707',NULL,'2026-01-23 19:01:00.551716',128,128,'558d317bd62542eb9fe7a15800c7d18f','f28ae308-0e67-4211-80b9-24ea250e8fbd',36,'7976ff17c3f840919d65487c1a87daad','snapshot_gigabytes',-1,'2026-01-24 19:01:00',NULL),('2026-01-23 19:01:00.483905',NULL,'2026-01-23 19:01:00.551716',129,129,NULL,'3c1611bc-74bb-45b5-8f6a-34370bd413dc',37,'7976ff17c3f840919d65487c1a87daad','snapshots',-1,'2026-01-24 19:01:00','2a58a533-a0c8-400a-8e5d-7f96a5448c79'),('2026-01-23 19:01:00.485916',NULL,'2026-01-23 19:01:00.551716',130,130,NULL,'02689653-c704-4b3b-b61c-33ee4aacb32c',38,'7976ff17c3f840919d65487c1a87daad','snapshot_gigabytes',-1,'2026-01-24 19:01:00','2a58a533-a0c8-400a-8e5d-7f96a5448c79'),('2026-01-23 19:01:04.163248',NULL,'2026-01-23 19:01:04.177108',131,131,'558d317bd62542eb9fe7a15800c7d18f','dfc43a98-4bc2-4f6b-89d4-cfac0439e7ed',35,'7976ff17c3f840919d65487c1a87daad','snapshots',-1,'2026-01-24 19:01:04',NULL),('2026-01-23 19:01:04.164333',NULL,'2026-01-23 19:01:04.177108',132,132,'558d317bd62542eb9fe7a15800c7d18f','29817d53-625b-4016-9f4e-c6e91bdb2d63',36,'7976ff17c3f840919d65487c1a87daad','snapshot_gigabytes',-1,'2026-01-24 19:01:04',NULL),('2026-01-23 19:01:04.169398',NULL,'2026-01-23 19:01:04.177108',133,133,NULL,'e1236a05-939f-42de-ab05-1e8fd918d632',37,'7976ff17c3f840919d65487c1a87daad','snapshots',-1,'2026-01-24 19:01:04','2a58a533-a0c8-400a-8e5d-7f96a5448c79'),('2026-01-23 19:01:04.170086',NULL,'2026-01-23 19:01:04.177108',134,134,NULL,'05deb865-125c-4ec4-bd38-0d4336ad322f',38,'7976ff17c3f840919d65487c1a87daad','snapshot_gigabytes',-1,'2026-01-24 19:01:04','2a58a533-a0c8-400a-8e5d-7f96a5448c79'),('2026-01-23 19:01:04.216091',NULL,'2026-01-23 19:01:04.288457',135,135,'c1c8384de14c4a31ae08ff4e69a1c9bb','6a37c496-4b74-45b4-8d35-79cc8e09e206',25,'dcb726ed64514381891686f89d347595','snapshots',1,'2026-01-24 19:01:04',NULL),('2026-01-23 19:01:04.218283',NULL,'2026-01-23 19:01:04.288457',136,136,'c1c8384de14c4a31ae08ff4e69a1c9bb','7ed17d4b-bb07-47da-aa0a-f66c431a01f5',26,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',1,'2026-01-24 19:01:04',NULL),('2026-01-23 19:01:04.226049',NULL,'2026-01-23 19:01:04.288457',137,137,NULL,'635ca0b8-38fa-4859-9edf-3d126b8b9025',27,'dcb726ed64514381891686f89d347595','snapshots',1,'2026-01-24 19:01:04','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:01:04.227215',NULL,'2026-01-23 19:01:04.288457',138,138,NULL,'e35534a7-a096-42c1-a4f0-f79260083f44',28,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',1,'2026-01-24 19:01:04','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:01:06.117736',NULL,'2026-01-23 19:01:06.132620',139,139,'c1c8384de14c4a31ae08ff4e69a1c9bb','4bea517b-32cc-477d-828a-353cf7e73685',25,'dcb726ed64514381891686f89d347595','snapshots',-1,'2026-01-24 19:01:06',NULL),('2026-01-23 19:01:06.118486',NULL,'2026-01-23 19:01:06.132620',140,140,'c1c8384de14c4a31ae08ff4e69a1c9bb','4560fe79-c8d5-43b3-9007-5d52cfe4a60d',26,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',-1,'2026-01-24 19:01:06',NULL),('2026-01-23 19:01:06.124465',NULL,'2026-01-23 19:01:06.132620',141,141,NULL,'4913c0b8-2a0f-4b4c-9815-c0ed5b53b57d',27,'dcb726ed64514381891686f89d347595','snapshots',-1,'2026-01-24 19:01:06','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:01:06.125164',NULL,'2026-01-23 19:01:06.132620',142,142,NULL,'a17928c6-9da1-4c59-8081-c45753701674',28,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',-1,'2026-01-24 19:01:06','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:01:08.243538',NULL,'2026-01-23 19:01:08.264842',143,143,'558d317bd62542eb9fe7a15800c7d18f','1f539553-e571-4358-b62a-628ef78d3166',31,'7976ff17c3f840919d65487c1a87daad','shares',-1,'2026-01-24 19:01:08',NULL),('2026-01-23 19:01:08.244525',NULL,'2026-01-23 19:01:08.264842',144,144,'558d317bd62542eb9fe7a15800c7d18f','b0a2ddd9-ae5e-4bc1-a816-7976785a3666',32,'7976ff17c3f840919d65487c1a87daad','gigabytes',-1,'2026-01-24 19:01:08',NULL),('2026-01-23 19:01:08.252925',NULL,'2026-01-23 19:01:08.264842',145,145,NULL,'9fd778b6-765b-409b-8c46-21d0144f9255',33,'7976ff17c3f840919d65487c1a87daad','shares',-1,'2026-01-24 19:01:08','2a58a533-a0c8-400a-8e5d-7f96a5448c79'),('2026-01-23 19:01:08.253687',NULL,'2026-01-23 19:01:08.264842',146,146,NULL,'080d0785-fd28-46d8-a5ec-6316de2d5e85',34,'7976ff17c3f840919d65487c1a87daad','gigabytes',-1,'2026-01-24 19:01:08','2a58a533-a0c8-400a-8e5d-7f96a5448c79'),('2026-01-23 19:01:09.433274',NULL,'2026-01-23 19:01:09.456915',147,147,'c1c8384de14c4a31ae08ff4e69a1c9bb','4161ddbd-43e5-4cdb-9a30-8c5d36cbac1c',25,'dcb726ed64514381891686f89d347595','snapshots',-1,'2026-01-24 19:01:09',NULL),('2026-01-23 19:01:09.434198',NULL,'2026-01-23 19:01:09.456915',148,148,'c1c8384de14c4a31ae08ff4e69a1c9bb','707d3de3-3ebb-4ef6-89ae-a101fbcfbd57',26,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',-1,'2026-01-24 19:01:09',NULL),('2026-01-23 19:01:09.445159',NULL,'2026-01-23 19:01:09.456915',149,149,NULL,'4f940b1c-57c6-4a60-ac58-f5ff5f4027c7',27,'dcb726ed64514381891686f89d347595','snapshots',-1,'2026-01-24 19:01:09','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:01:09.446024',NULL,'2026-01-23 19:01:09.456915',150,150,NULL,'3b27cee8-325f-416f-a769-33265ec3dc44',28,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',-1,'2026-01-24 19:01:09','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:01:13.412092',NULL,'2026-01-23 19:01:14.183022',151,151,'c1c8384de14c4a31ae08ff4e69a1c9bb','2000ca3f-4007-4d50-ba98-7034b9feff36',25,'dcb726ed64514381891686f89d347595','snapshots',-1,'2026-01-24 19:01:13',NULL),('2026-01-23 19:01:13.413066',NULL,'2026-01-23 19:01:14.183022',152,152,'c1c8384de14c4a31ae08ff4e69a1c9bb','a18d9392-7493-4695-9bda-795ecac0b68a',26,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',-1,'2026-01-24 19:01:13',NULL),('2026-01-23 19:01:14.161722',NULL,'2026-01-23 19:01:14.183022',153,153,NULL,'d39e0b7d-d159-4928-bf3d-f095411f8e6b',27,'dcb726ed64514381891686f89d347595','snapshots',-1,'2026-01-24 19:01:13','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:01:14.162382',NULL,'2026-01-23 19:01:14.183022',154,154,NULL,'e53958bf-4a0d-43ca-a85b-faf018d6a517',28,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',-1,'2026-01-24 19:01:13','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:01:17.004760',NULL,'2026-01-23 19:01:17.028366',155,155,'c1c8384de14c4a31ae08ff4e69a1c9bb','2037ac15-ddc6-4271-b5c3-c358afac7e5d',25,'dcb726ed64514381891686f89d347595','snapshots',-1,'2026-01-24 19:01:16',NULL),('2026-01-23 19:01:17.005649',NULL,'2026-01-23 19:01:17.028366',156,156,'c1c8384de14c4a31ae08ff4e69a1c9bb','98ca3f1c-716f-419f-b8fa-9aaaacc5970d',26,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',-1,'2026-01-24 19:01:16',NULL),('2026-01-23 19:01:17.014353',NULL,'2026-01-23 19:01:17.028366',157,157,NULL,'9a769471-4208-45a8-b5e3-0a2f0f16c096',27,'dcb726ed64514381891686f89d347595','snapshots',-1,'2026-01-24 19:01:16','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:01:17.015212',NULL,'2026-01-23 19:01:17.028366',158,158,NULL,'57a75cc4-3633-4bc8-9cb2-5f106078fa1a',28,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',-1,'2026-01-24 19:01:16','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:01:20.521278',NULL,'2026-01-23 19:01:20.534704',159,159,'c1c8384de14c4a31ae08ff4e69a1c9bb','c7da2974-a7ec-480f-b0c6-c67cf87ece2b',25,'dcb726ed64514381891686f89d347595','snapshots',-1,'2026-01-24 19:01:20',NULL),('2026-01-23 19:01:20.521991',NULL,'2026-01-23 19:01:20.534704',160,160,'c1c8384de14c4a31ae08ff4e69a1c9bb','da2a4e6c-cd93-4508-9184-42e257400ec4',26,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',-1,'2026-01-24 19:01:20',NULL),('2026-01-23 19:01:20.527384',NULL,'2026-01-23 19:01:20.534704',161,161,NULL,'0986346b-46b8-4820-8551-200b04ddcf07',27,'dcb726ed64514381891686f89d347595','snapshots',-1,'2026-01-24 19:01:20','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:01:20.528210',NULL,'2026-01-23 19:01:20.534704',162,162,NULL,'1a020072-6718-4197-a5a5-770881b9f545',28,'dcb726ed64514381891686f89d347595','snapshot_gigabytes',-1,'2026-01-24 19:01:20','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:01:21.671233',NULL,'2026-01-23 19:01:21.714698',163,163,'1efc60dfafb740f48a10184f26e16386','e080cbf3-3537-49e5-a876-6840aaef2de2',39,'1490bc1cfa8e446280d7d1f208cdd9cc','shares',1,'2026-01-24 19:01:21',NULL),('2026-01-23 19:01:21.675958',NULL,'2026-01-23 19:01:21.714698',164,164,'1efc60dfafb740f48a10184f26e16386','4ad7909e-398d-4dbb-825b-76bcf4bf4d37',40,'1490bc1cfa8e446280d7d1f208cdd9cc','gigabytes',1,'2026-01-24 19:01:21',NULL),('2026-01-23 19:01:21.692888',NULL,'2026-01-23 19:01:21.714698',165,165,NULL,'80b89f63-e8e1-4142-98ac-87e40d13d681',41,'1490bc1cfa8e446280d7d1f208cdd9cc','shares',1,'2026-01-24 19:01:21','f4a6bef4-70c7-455a-897f-b3e9b5f4c268'),('2026-01-23 19:01:21.694113',NULL,'2026-01-23 19:01:21.714698',166,166,NULL,'b23994e6-3f3a-47d2-9234-5fce78c15092',42,'1490bc1cfa8e446280d7d1f208cdd9cc','gigabytes',1,'2026-01-24 19:01:21','f4a6bef4-70c7-455a-897f-b3e9b5f4c268'),('2026-01-23 19:01:24.635982',NULL,'2026-01-23 19:01:24.677834',167,167,'c1c8384de14c4a31ae08ff4e69a1c9bb','66ff7c4d-261a-4d40-990b-bb0741c0c4ae',1,'dcb726ed64514381891686f89d347595','shares',-1,'2026-01-24 19:01:24',NULL),('2026-01-23 19:01:24.636776',NULL,'2026-01-23 19:01:24.677834',168,168,'c1c8384de14c4a31ae08ff4e69a1c9bb','4d0c6588-ffa3-438f-9218-13904564f4a8',2,'dcb726ed64514381891686f89d347595','gigabytes',-1,'2026-01-24 19:01:24',NULL),('2026-01-23 19:01:24.642693',NULL,'2026-01-23 19:01:24.677834',169,169,NULL,'28008441-baeb-40c0-9008-4bd8b9282253',3,'dcb726ed64514381891686f89d347595','shares',-1,'2026-01-24 19:01:24','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:01:24.643821',NULL,'2026-01-23 19:01:24.677834',170,170,NULL,'01da023a-21ec-4bda-aec7-1296de790b12',4,'dcb726ed64514381891686f89d347595','gigabytes',-1,'2026-01-24 19:01:24','38503086-e059-46cf-afc1-5c445beccdd6'),('2026-01-23 19:01:26.497788',NULL,'2026-01-23 19:01:27.690336',171,171,'1efc60dfafb740f48a10184f26e16386','a4b0f405-af0a-45ca-ad55-dc96a4e398fd',43,'1490bc1cfa8e446280d7d1f208cdd9cc','shares',1,'2026-01-24 19:01:25',NULL),('2026-01-23 19:01:26.949775',NULL,'2026-01-23 19:01:27.690336',172,172,'1efc60dfafb740f48a10184f26e16386','a18deaa0-ebbe-4662-ada8-69425c6b5d42',44,'1490bc1cfa8e446280d7d1f208cdd9cc','gigabytes',1,'2026-01-24 19:01:25',NULL),('2026-01-23 19:01:27.665533',NULL,'2026-01-23 19:01:27.690336',173,173,NULL,'49764aa2-ed48-4001-af33-23a5bd53df06',45,'1490bc1cfa8e446280d7d1f208cdd9cc','shares',1,'2026-01-24 19:01:25','88ad68ca-8786-477c-9b56-3373e78c4057'),('2026-01-23 19:01:27.667402',NULL,'2026-01-23 19:01:27.690336',174,174,NULL,'8e11f4d3-69ce-423b-8578-cd4e7b9d12df',46,'1490bc1cfa8e446280d7d1f208cdd9cc','gigabytes',1,'2026-01-24 19:01:25','88ad68ca-8786-477c-9b56-3373e78c4057'),('2026-01-23 19:01:31.420448',NULL,'2026-01-23 19:01:31.887767',175,175,'1efc60dfafb740f48a10184f26e16386','9bef11ef-c62b-48ed-b743-55a5d5498097',47,'1490bc1cfa8e446280d7d1f208cdd9cc','snapshots',1,'2026-01-24 19:01:31',NULL),('2026-01-23 19:01:31.421674',NULL,'2026-01-23 19:01:31.887767',176,176,'1efc60dfafb740f48a10184f26e16386','209c2c32-06af-4187-87d5-5fa2eeea41b9',48,'1490bc1cfa8e446280d7d1f208cdd9cc','snapshot_gigabytes',1,'2026-01-24 19:01:31',NULL),('2026-01-23 19:01:31.598468',NULL,'2026-01-23 19:01:31.887767',177,177,NULL,'13523317-fe74-41d8-843f-45af87dd837e',49,'1490bc1cfa8e446280d7d1f208cdd9cc','snapshots',1,'2026-01-24 19:01:31','88ad68ca-8786-477c-9b56-3373e78c4057'),('2026-01-23 19:01:31.600059',NULL,'2026-01-23 19:01:31.887767',178,178,NULL,'cc6e4dbd-080d-4b64-baa9-646e03b5c577',50,'1490bc1cfa8e446280d7d1f208cdd9cc','snapshot_gigabytes',1,'2026-01-24 19:01:31','88ad68ca-8786-477c-9b56-3373e78c4057'),('2026-01-23 19:01:43.948192',NULL,'2026-01-23 19:01:44.447149',179,179,'58ba79b6c9994c0fb14affae9b8f0c8c','93f3cf52-7e8d-400e-b299-12ce5a6c3eaf',51,'e19ff7e178044a3f9516cdc773fa4d6b','shares',1,'2026-01-24 19:01:43',NULL),('2026-01-23 19:01:43.949242',NULL,'2026-01-23 19:01:44.447149',180,180,'58ba79b6c9994c0fb14affae9b8f0c8c','9b6f58a3-3ebc-48c3-9714-78055c10423c',52,'e19ff7e178044a3f9516cdc773fa4d6b','gigabytes',1,'2026-01-24 19:01:43',NULL),('2026-01-23 19:01:44.183461',NULL,'2026-01-23 19:01:44.447149',181,181,NULL,'a77c40e4-af6a-4bb1-b795-833376f61088',53,'e19ff7e178044a3f9516cdc773fa4d6b','shares',1,'2026-01-24 19:01:43','2edae7de-0cac-41e9-8dee-a7f49a9c9caa'),('2026-01-23 19:01:44.186324',NULL,'2026-01-23 19:01:44.447149',182,182,NULL,'d6808c7d-746e-463e-be13-56b0034b1a8d',54,'e19ff7e178044a3f9516cdc773fa4d6b','gigabytes',1,'2026-01-24 19:01:43','2edae7de-0cac-41e9-8dee-a7f49a9c9caa'),('2026-01-23 19:01:47.962429',NULL,'2026-01-23 19:01:48.260725',183,183,'58ba79b6c9994c0fb14affae9b8f0c8c','b0d3fa14-18f7-4035-a025-3a61e1cd71ff',51,'e19ff7e178044a3f9516cdc773fa4d6b','shares',1,'2026-01-24 19:01:47',NULL),('2026-01-23 19:01:47.964070',NULL,'2026-01-23 19:01:48.260725',184,184,'58ba79b6c9994c0fb14affae9b8f0c8c','47596818-853f-4c6f-83ee-06692604e6e5',52,'e19ff7e178044a3f9516cdc773fa4d6b','gigabytes',1,'2026-01-24 19:01:47',NULL),('2026-01-23 19:01:47.978977',NULL,'2026-01-23 19:01:48.260725',185,185,NULL,'3076d53d-f70e-4a96-9123-5112ae910c2b',55,'e19ff7e178044a3f9516cdc773fa4d6b','shares',1,'2026-01-24 19:01:47','fe8a42c9-28ea-4c66-bed3-f2f6d12529fa'),('2026-01-23 19:01:47.981543',NULL,'2026-01-23 19:01:48.260725',186,186,NULL,'7573c81e-2a5e-4da4-a03f-1599e0a996b3',56,'e19ff7e178044a3f9516cdc773fa4d6b','gigabytes',1,'2026-01-24 19:01:47','fe8a42c9-28ea-4c66-bed3-f2f6d12529fa'),('2026-01-23 19:01:50.070194',NULL,'2026-01-23 19:01:50.107236',187,187,'1efc60dfafb740f48a10184f26e16386','28fe90d2-523c-4406-a70c-a984e051dc3c',58,'1490bc1cfa8e446280d7d1f208cdd9cc','snapshots',-1,'2026-01-24 19:01:49',NULL),('2026-01-23 19:01:50.071325',NULL,'2026-01-23 19:01:50.107236',188,188,'1efc60dfafb740f48a10184f26e16386','b412dee4-90b4-4804-b67f-ce258b0bef02',57,'1490bc1cfa8e446280d7d1f208cdd9cc','snapshot_gigabytes',-1,'2026-01-24 19:01:49',NULL),('2026-01-23 19:01:50.097306',NULL,'2026-01-23 19:01:50.107236',189,189,NULL,'cc2666b1-0abc-44d3-915c-0fe1cdf0d27d',60,'1490bc1cfa8e446280d7d1f208cdd9cc','snapshots',-1,'2026-01-24 19:01:49','88ad68ca-8786-477c-9b56-3373e78c4057'),('2026-01-23 19:01:50.098050',NULL,'2026-01-23 19:01:50.107236',190,190,NULL,'cb18d736-5f67-4dc6-95a5-547ccdbe18e0',59,'1490bc1cfa8e446280d7d1f208cdd9cc','snapshot_gigabytes',-1,'2026-01-24 19:01:49','88ad68ca-8786-477c-9b56-3373e78c4057'),('2026-01-23 19:01:51.102638',NULL,'2026-01-23 19:01:51.134588',191,191,'25ebb8b143d84bfab128a474701250d6','8f0938a6-4cbd-4fa5-9f0c-f4670adc86cd',61,'bd0d4498326a45708c5d8845efe3901e','shares',1,'2026-01-24 19:01:51',NULL),('2026-01-23 19:01:51.103937',NULL,'2026-01-23 19:01:51.134588',192,192,'25ebb8b143d84bfab128a474701250d6','1470028e-edd5-4412-9595-ac64f6c8f575',62,'bd0d4498326a45708c5d8845efe3901e','gigabytes',1,'2026-01-24 19:01:51',NULL),('2026-01-23 19:01:51.113251',NULL,'2026-01-23 19:01:51.134588',193,193,NULL,'4e835c2f-e29c-4ff7-91de-27d522ee73f0',63,'bd0d4498326a45708c5d8845efe3901e','shares',1,'2026-01-24 19:01:51','09dbe7c6-481d-459a-98b0-2e78689c591b'),('2026-01-23 19:01:51.114237',NULL,'2026-01-23 19:01:51.134588',194,194,NULL,'1f195a72-52b4-403e-96ae-cdf662131725',64,'bd0d4498326a45708c5d8845efe3901e','gigabytes',1,'2026-01-24 19:01:51','09dbe7c6-481d-459a-98b0-2e78689c591b'),('2026-01-23 19:01:51.395739',NULL,'2026-01-23 19:01:51.437055',195,195,'52e73d5a04a341b6a7e0bdd3001b9a03','d66c3a89-ee11-4af8-b529-b97e3ccc55c4',65,'e9255972eb454fca909aa1528e4f83a2','shares',1,'2026-01-24 19:01:51',NULL),('2026-01-23 19:01:51.397201',NULL,'2026-01-23 19:01:51.437055',196,196,'52e73d5a04a341b6a7e0bdd3001b9a03','ef7de860-3b3f-488c-94cb-a9ad0be9888c',66,'e9255972eb454fca909aa1528e4f83a2','gigabytes',1,'2026-01-24 19:01:51',NULL),('2026-01-23 19:01:51.408137',NULL,'2026-01-23 19:01:51.437055',197,197,NULL,'e139a4fe-9646-48db-84ff-b5c929e8fae8',67,'e9255972eb454fca909aa1528e4f83a2','shares',1,'2026-01-24 19:01:51','3c6be9a4-c34f-4d70-9659-317852304237'),('2026-01-23 19:01:51.409371',NULL,'2026-01-23 19:01:51.437055',198,198,NULL,'bce5728d-a55f-4345-9e50-e28887918fd9',68,'e9255972eb454fca909aa1528e4f83a2','gigabytes',1,'2026-01-24 19:01:51','3c6be9a4-c34f-4d70-9659-317852304237'),('2026-01-23 19:01:53.548861',NULL,'2026-01-23 19:01:53.572749',199,199,'1efc60dfafb740f48a10184f26e16386','bf46b629-2684-49ab-8c2d-2acc1c6a5641',69,'1490bc1cfa8e446280d7d1f208cdd9cc','shares',-1,'2026-01-24 19:01:53',NULL),('2026-01-23 19:01:53.550490',NULL,'2026-01-23 19:01:53.572749',200,200,'1efc60dfafb740f48a10184f26e16386','48d51cd5-fd0d-47f2-8b2b-553919f7c296',70,'1490bc1cfa8e446280d7d1f208cdd9cc','gigabytes',-1,'2026-01-24 19:01:53',NULL),('2026-01-23 19:01:53.563785',NULL,'2026-01-23 19:01:53.572749',201,201,NULL,'ce9b7837-3e06-4d15-9f87-0fb7d917aa45',71,'1490bc1cfa8e446280d7d1f208cdd9cc','shares',-1,'2026-01-24 19:01:53','88ad68ca-8786-477c-9b56-3373e78c4057'),('2026-01-23 19:01:53.564433',NULL,'2026-01-23 19:01:53.572749',202,202,NULL,'47a35dfb-e948-4743-8831-5261af91ddd8',72,'1490bc1cfa8e446280d7d1f208cdd9cc','gigabytes',-1,'2026-01-24 19:01:53','88ad68ca-8786-477c-9b56-3373e78c4057'),('2026-01-23 19:01:55.175377',NULL,'2026-01-23 19:01:55.232319',203,203,'795d61c6748c4ee1963bd0cf94173c58','37231124-fe4b-47dd-a671-e840a87871e6',73,'db171ed11cd54288960e2675bc51a3a1','shares',1,'2026-01-24 19:01:55',NULL),('2026-01-23 19:01:55.177818',NULL,'2026-01-23 19:01:55.232319',204,204,'795d61c6748c4ee1963bd0cf94173c58','3c8e7c2c-e2c4-4610-8336-9c286a93a27f',74,'db171ed11cd54288960e2675bc51a3a1','gigabytes',1,'2026-01-24 19:01:55',NULL),('2026-01-23 19:01:55.192180',NULL,'2026-01-23 19:01:55.232319',205,205,NULL,'7027debd-620c-4a7d-b161-d406a1f344d3',75,'db171ed11cd54288960e2675bc51a3a1','shares',1,'2026-01-24 19:01:55','fe8a42c9-28ea-4c66-bed3-f2f6d12529fa'),('2026-01-23 19:01:55.193559',NULL,'2026-01-23 19:01:55.232319',206,206,NULL,'5e3ebe79-2d7c-499b-a81e-22a521e5f40d',76,'db171ed11cd54288960e2675bc51a3a1','gigabytes',1,'2026-01-24 19:01:55','fe8a42c9-28ea-4c66-bed3-f2f6d12529fa'),('2026-01-23 19:01:55.490162',NULL,'2026-01-23 19:01:55.518186',207,207,'52e73d5a04a341b6a7e0bdd3001b9a03','e1328c94-2002-4e7a-97a8-482015521d0b',65,'e9255972eb454fca909aa1528e4f83a2','shares',-1,'2026-01-24 19:01:55',NULL),('2026-01-23 19:01:55.491543',NULL,'2026-01-23 19:01:55.518186',208,208,'52e73d5a04a341b6a7e0bdd3001b9a03','a543e8c1-f027-4079-bfab-6623d95c71cc',66,'e9255972eb454fca909aa1528e4f83a2','gigabytes',-1,'2026-01-24 19:01:55',NULL),('2026-01-23 19:01:55.500149',NULL,'2026-01-23 19:01:55.518186',209,209,NULL,'188e1b7b-1b2e-47bd-ae4e-74f17e1554fd',67,'e9255972eb454fca909aa1528e4f83a2','shares',-1,'2026-01-24 19:01:55','3c6be9a4-c34f-4d70-9659-317852304237'),('2026-01-23 19:01:55.503898',NULL,'2026-01-23 19:01:55.518186',210,210,NULL,'1d81a78e-f920-4d6c-9be1-abd863e26a1c',68,'e9255972eb454fca909aa1528e4f83a2','gigabytes',-1,'2026-01-24 19:01:55','3c6be9a4-c34f-4d70-9659-317852304237'),('2026-01-23 19:01:56.307904',NULL,'2026-01-23 19:01:56.323800',211,211,'25ebb8b143d84bfab128a474701250d6','908c5b0e-4d29-488e-a4d5-3686165cf4b3',61,'bd0d4498326a45708c5d8845efe3901e','shares',-1,'2026-01-24 19:01:56',NULL),('2026-01-23 19:01:56.308776',NULL,'2026-01-23 19:01:56.323800',212,212,'25ebb8b143d84bfab128a474701250d6','95347d4a-3eff-4bfb-89c8-6e1fc39b4925',62,'bd0d4498326a45708c5d8845efe3901e','gigabytes',-1,'2026-01-24 19:01:56',NULL),('2026-01-23 19:01:56.314597',NULL,'2026-01-23 19:01:56.323800',213,213,NULL,'403f7f42-5f56-4774-9e62-41e7023ab9d0',63,'bd0d4498326a45708c5d8845efe3901e','shares',-1,'2026-01-24 19:01:56','09dbe7c6-481d-459a-98b0-2e78689c591b'),('2026-01-23 19:01:56.315353',NULL,'2026-01-23 19:01:56.323800',214,214,NULL,'9d1eda62-e902-43ba-b7cc-f8b9be11b515',64,'bd0d4498326a45708c5d8845efe3901e','gigabytes',-1,'2026-01-24 19:01:56','09dbe7c6-481d-459a-98b0-2e78689c591b'),('2026-01-23 19:01:57.088107',NULL,'2026-01-23 19:01:57.108999',215,215,'1efc60dfafb740f48a10184f26e16386','8cbaa446-cb07-4886-8bda-6a18f7c88789',69,'1490bc1cfa8e446280d7d1f208cdd9cc','shares',-1,'2026-01-24 19:01:57',NULL),('2026-01-23 19:01:57.088748',NULL,'2026-01-23 19:01:57.108999',216,216,'1efc60dfafb740f48a10184f26e16386','27781358-aba6-4e0d-86a9-097b3b811998',70,'1490bc1cfa8e446280d7d1f208cdd9cc','gigabytes',-1,'2026-01-24 19:01:57',NULL),('2026-01-23 19:01:57.101910',NULL,'2026-01-23 19:01:57.108999',217,217,NULL,'9db91546-87ec-454c-8466-5cff435ee9ca',77,'1490bc1cfa8e446280d7d1f208cdd9cc','shares',-1,'2026-01-24 19:01:57','f4a6bef4-70c7-455a-897f-b3e9b5f4c268'),('2026-01-23 19:01:57.102498',NULL,'2026-01-23 19:01:57.108999',218,218,NULL,'0db41c5a-667a-40f1-9118-970c7e49120b',78,'1490bc1cfa8e446280d7d1f208cdd9cc','gigabytes',-1,'2026-01-24 19:01:57','f4a6bef4-70c7-455a-897f-b3e9b5f4c268'),('2026-01-23 19:02:04.178937',NULL,'2026-01-23 19:02:04.240008',219,219,'d4854e7989914b0a8de972d4f7254ff2','ff71aa75-f8ee-40fd-9c48-c90c4357de5c',79,'0034e94cde5c402eb542d58e14a80d2c','share_networks',1,'2026-01-24 19:02:04',NULL),('2026-01-23 19:02:04.880404',NULL,'2026-01-23 19:02:05.199510',220,220,'06e0d50765b84a109551bfac230deae0','ca8d27c0-63da-4cf0-ad70-bc00753cc114',80,'1a8798b902e7464fa59d9b7585e84a49','share_networks',1,'2026-01-24 19:02:04',NULL),('2026-01-23 19:02:07.286560',NULL,'2026-01-23 19:02:07.292034',221,221,'d4854e7989914b0a8de972d4f7254ff2','bb3f8852-77c4-4c4d-b8a2-14ca2636897f',79,'0034e94cde5c402eb542d58e14a80d2c','share_networks',-1,'2026-01-24 19:02:07',NULL),('2026-01-23 19:02:14.028761',NULL,'2026-01-23 19:02:14.077309',222,222,'48aab17447ce4d90a8a1db613f1ea646','771b105f-0c36-4d10-95ca-99f8d592eec8',81,'f2beea25a5e947aab5d0bb53058124cf','shares',1,'2026-01-24 19:02:13',NULL),('2026-01-23 19:02:14.030044',NULL,'2026-01-23 19:02:14.077309',223,223,'48aab17447ce4d90a8a1db613f1ea646','b5d1aa8f-d8e9-4ecc-833a-c4afc44e65be',82,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',1,'2026-01-24 19:02:13',NULL),('2026-01-23 19:02:14.042381',NULL,'2026-01-23 19:02:14.077309',224,224,NULL,'7234c292-cfc0-43a0-85a6-130b6af93333',83,'f2beea25a5e947aab5d0bb53058124cf','shares',1,'2026-01-24 19:02:13','5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:02:14.043623',NULL,'2026-01-23 19:02:14.077309',225,225,NULL,'20ac2a39-930f-41c9-bb70-c136f7638c3b',84,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',1,'2026-01-24 19:02:13','5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:02:16.508100',NULL,'2026-01-23 19:02:16.538689',226,226,'cf78c38e3f6f4cae977f3610c4befcd9','96798afb-3455-42de-b2b3-258d5e2ab013',85,'dcaebac10d574ce2aa3ba16906fd5dbc','shares',1,'2026-01-24 19:02:16',NULL),('2026-01-23 19:02:16.509169',NULL,'2026-01-23 19:02:16.538689',227,227,'cf78c38e3f6f4cae977f3610c4befcd9','6351b493-2cb2-460d-94d9-a75921093e21',86,'dcaebac10d574ce2aa3ba16906fd5dbc','gigabytes',1,'2026-01-24 19:02:16',NULL),('2026-01-23 19:02:16.520690',NULL,'2026-01-23 19:02:16.538689',228,228,NULL,'864e6252-ae81-41e3-939c-4e07265a20f5',87,'dcaebac10d574ce2aa3ba16906fd5dbc','shares',1,'2026-01-24 19:02:16','c2e7b8e1-0b37-4bdc-b0cd-490536ec4c44'),('2026-01-23 19:02:16.521859',NULL,'2026-01-23 19:02:16.538689',229,229,NULL,'a1fcf8e9-d906-45cb-ba2f-d23b95204078',88,'dcaebac10d574ce2aa3ba16906fd5dbc','gigabytes',1,'2026-01-24 19:02:16','c2e7b8e1-0b37-4bdc-b0cd-490536ec4c44'),('2026-01-23 19:02:16.615193',NULL,'2026-01-23 19:02:16.691298',230,230,'d4699fb6f80746b4a636ab8962e102d0','5c8b851b-9aab-4ac4-b72e-ef8c49493295',89,'538e549e0d1e4309a3c16b3a4f48e842','shares',1,'2026-01-24 19:02:16',NULL),('2026-01-23 19:02:16.618612',NULL,'2026-01-23 19:02:16.691298',231,231,'d4699fb6f80746b4a636ab8962e102d0','a0c69469-e467-4b07-8b89-510db6bb386f',90,'538e549e0d1e4309a3c16b3a4f48e842','gigabytes',1,'2026-01-24 19:02:16',NULL),('2026-01-23 19:02:16.637308',NULL,'2026-01-23 19:02:16.691298',232,232,NULL,'8c34001e-c6b5-458b-9701-71736dcf5caa',91,'538e549e0d1e4309a3c16b3a4f48e842','shares',1,'2026-01-24 19:02:16','c45f2ba3-7d51-4245-94b8-6909ec45f40d'),('2026-01-23 19:02:16.641538',NULL,'2026-01-23 19:02:16.691298',233,233,NULL,'1d73a987-5a18-4276-be72-02328bcd466b',92,'538e549e0d1e4309a3c16b3a4f48e842','gigabytes',1,'2026-01-24 19:02:16','c45f2ba3-7d51-4245-94b8-6909ec45f40d'),('2026-01-23 19:02:17.507086',NULL,'2026-01-23 19:02:17.550288',234,234,'48aab17447ce4d90a8a1db613f1ea646','b53a27bf-7e08-4b5c-96f6-bd3d0958a019',81,'f2beea25a5e947aab5d0bb53058124cf','shares',1,'2026-01-24 19:02:17',NULL),('2026-01-23 19:02:17.508515',NULL,'2026-01-23 19:02:17.550288',235,235,'48aab17447ce4d90a8a1db613f1ea646','822f811e-ac83-49a3-aa3c-4d1bac79e6a2',82,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',1,'2026-01-24 19:02:17',NULL),('2026-01-23 19:02:17.516554',NULL,'2026-01-23 19:02:17.550288',236,236,NULL,'571fbac8-108b-453a-832e-7d672cf937e6',83,'f2beea25a5e947aab5d0bb53058124cf','shares',1,'2026-01-24 19:02:17','5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:02:17.519823',NULL,'2026-01-23 19:02:17.550288',237,237,NULL,'152f3f1f-b0d9-40b3-809e-7b37fab3e9ec',84,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',1,'2026-01-24 19:02:17','5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:02:21.880720',NULL,'2026-01-23 19:02:21.914990',238,238,'d4699fb6f80746b4a636ab8962e102d0','203e97f5-1618-4a4e-a842-337f15532669',89,'538e549e0d1e4309a3c16b3a4f48e842','shares',-1,'2026-01-24 19:02:21',NULL),('2026-01-23 19:02:21.886998',NULL,'2026-01-23 19:02:21.914990',239,239,'d4699fb6f80746b4a636ab8962e102d0','044ce404-3ed0-49b4-b50b-af3ae67f8849',90,'538e549e0d1e4309a3c16b3a4f48e842','gigabytes',-1,'2026-01-24 19:02:21',NULL),('2026-01-23 19:02:21.901643',NULL,'2026-01-23 19:02:21.914990',240,240,NULL,'a79a8389-6e57-41cb-a291-832ea175b2fc',91,'538e549e0d1e4309a3c16b3a4f48e842','shares',-1,'2026-01-24 19:02:21','c45f2ba3-7d51-4245-94b8-6909ec45f40d'),('2026-01-23 19:02:21.902977',NULL,'2026-01-23 19:02:21.914990',241,241,NULL,'3fa794a3-d67a-4db9-ab21-585a0d8f0a30',92,'538e549e0d1e4309a3c16b3a4f48e842','gigabytes',-1,'2026-01-24 19:02:21','c45f2ba3-7d51-4245-94b8-6909ec45f40d'),('2026-01-23 19:02:21.962932',NULL,'2026-01-23 19:02:21.976890',242,242,'48aab17447ce4d90a8a1db613f1ea646','1ddf0d55-9876-42b7-aced-102c8cdbf4f2',81,'f2beea25a5e947aab5d0bb53058124cf','shares',-1,'2026-01-24 19:02:21',NULL),('2026-01-23 19:02:21.964280',NULL,'2026-01-23 19:02:21.976890',243,243,'48aab17447ce4d90a8a1db613f1ea646','860805f4-b1ee-41e9-bf32-b0c34038b2d9',82,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',-1,'2026-01-24 19:02:21',NULL),('2026-01-23 19:02:21.970072',NULL,'2026-01-23 19:02:21.976890',244,244,NULL,'9c18b999-457a-4c2b-90fc-f064409b3876',83,'f2beea25a5e947aab5d0bb53058124cf','shares',-1,'2026-01-24 19:02:21','5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:02:21.970901',NULL,'2026-01-23 19:02:21.976890',245,245,NULL,'75172efc-e3a1-43d3-b63c-603b4f2a8470',84,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',-1,'2026-01-24 19:02:21','5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:02:24.370812',NULL,'2026-01-23 19:02:24.629256',246,246,'795d61c6748c4ee1963bd0cf94173c58','4f91889d-e3a7-4945-9482-e46405b0b249',73,'db171ed11cd54288960e2675bc51a3a1','shares',1,'2026-01-24 19:02:24',NULL),('2026-01-23 19:02:24.371984',NULL,'2026-01-23 19:02:24.629256',247,247,'795d61c6748c4ee1963bd0cf94173c58','ae326354-baa6-48aa-b5ae-bfdb755a344e',74,'db171ed11cd54288960e2675bc51a3a1','gigabytes',1,'2026-01-24 19:02:24',NULL),('2026-01-23 19:02:24.592720',NULL,'2026-01-23 19:02:24.629256',248,248,NULL,'452f1f80-d94e-4c61-beef-0b418f28889e',93,'db171ed11cd54288960e2675bc51a3a1','shares',1,'2026-01-24 19:02:24','2edae7de-0cac-41e9-8dee-a7f49a9c9caa'),('2026-01-23 19:02:24.595156',NULL,'2026-01-23 19:02:24.629256',249,249,NULL,'2a701849-c48a-45e1-bce2-f1da6cd54843',94,'db171ed11cd54288960e2675bc51a3a1','gigabytes',1,'2026-01-24 19:02:24','2edae7de-0cac-41e9-8dee-a7f49a9c9caa'),('2026-01-23 19:02:24.953616',NULL,'2026-01-23 19:02:24.988263',250,250,'48aab17447ce4d90a8a1db613f1ea646','cc1e899f-5000-41b5-8559-881fcb225f92',81,'f2beea25a5e947aab5d0bb53058124cf','shares',1,'2026-01-24 19:02:24',NULL),('2026-01-23 19:02:24.955243',NULL,'2026-01-23 19:02:24.988263',251,251,'48aab17447ce4d90a8a1db613f1ea646','50c211e2-6e43-47c0-ae77-78dacacc1178',82,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',1,'2026-01-24 19:02:24',NULL),('2026-01-23 19:02:24.963087',NULL,'2026-01-23 19:02:24.988263',252,252,NULL,'2798ade7-00b0-4cc1-bd1c-9bbaa1355ceb',83,'f2beea25a5e947aab5d0bb53058124cf','shares',1,'2026-01-24 19:02:24','5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:02:24.964386',NULL,'2026-01-23 19:02:24.988263',253,253,NULL,'7de480a7-c127-4321-bdf5-f986e87a9f2a',84,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',1,'2026-01-24 19:02:24','5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:02:30.414778',NULL,'2026-01-23 19:02:30.441198',254,254,'48aab17447ce4d90a8a1db613f1ea646','50523996-c5f4-41ad-9581-79ecbfd10034',81,'f2beea25a5e947aab5d0bb53058124cf','shares',-1,'2026-01-24 19:02:30',NULL),('2026-01-23 19:02:30.415702',NULL,'2026-01-23 19:02:30.441198',255,255,'48aab17447ce4d90a8a1db613f1ea646','f26ff32c-b005-4172-a0ca-af5c3702d555',82,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',-1,'2026-01-24 19:02:30',NULL),('2026-01-23 19:02:30.429825',NULL,'2026-01-23 19:02:30.441198',256,256,NULL,'118075c8-4603-41c2-b73a-79bf903a21c1',83,'f2beea25a5e947aab5d0bb53058124cf','shares',-1,'2026-01-24 19:02:30','5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:02:30.430897',NULL,'2026-01-23 19:02:30.441198',257,257,NULL,'9d6d664f-9a8b-474c-a575-62ac67b18a12',84,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',-1,'2026-01-24 19:02:30','5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:02:30.799210',NULL,'2026-01-23 19:02:30.813756',258,258,'cf78c38e3f6f4cae977f3610c4befcd9','19e53238-6a9c-41f4-9dd4-e64952b7f728',85,'dcaebac10d574ce2aa3ba16906fd5dbc','shares',-1,'2026-01-24 19:02:30',NULL),('2026-01-23 19:02:30.799967',NULL,'2026-01-23 19:02:30.813756',259,259,'cf78c38e3f6f4cae977f3610c4befcd9','3d4f9924-0fac-4374-b52a-66be1c19e8f5',86,'dcaebac10d574ce2aa3ba16906fd5dbc','gigabytes',-1,'2026-01-24 19:02:30',NULL),('2026-01-23 19:02:30.805208',NULL,'2026-01-23 19:02:30.813756',260,260,NULL,'6b407316-6acc-4f85-a5af-cefd91684bdc',87,'dcaebac10d574ce2aa3ba16906fd5dbc','shares',-1,'2026-01-24 19:02:30','c2e7b8e1-0b37-4bdc-b0cd-490536ec4c44'),('2026-01-23 19:02:30.806024',NULL,'2026-01-23 19:02:30.813756',261,261,NULL,'8af2a737-8dde-423d-ae97-c77210702d43',88,'dcaebac10d574ce2aa3ba16906fd5dbc','gigabytes',-1,'2026-01-24 19:02:30','c2e7b8e1-0b37-4bdc-b0cd-490536ec4c44'),('2026-01-23 19:02:33.457687',NULL,'2026-01-23 19:02:33.488227',262,262,'48aab17447ce4d90a8a1db613f1ea646','fa614e6c-ef0e-44ab-8c86-8c2bc0c3ea2d',81,'f2beea25a5e947aab5d0bb53058124cf','shares',1,'2026-01-24 19:02:33',NULL),('2026-01-23 19:02:33.459279',NULL,'2026-01-23 19:02:33.488227',263,263,'48aab17447ce4d90a8a1db613f1ea646','f68ba364-c7a8-4abf-9fe8-4cf81ebda5bf',82,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',1,'2026-01-24 19:02:33',NULL),('2026-01-23 19:02:33.465773',NULL,'2026-01-23 19:02:33.488227',264,264,NULL,'82329dd1-b659-41b0-b073-afad1237d791',83,'f2beea25a5e947aab5d0bb53058124cf','shares',1,'2026-01-24 19:02:33','5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:02:33.467178',NULL,'2026-01-23 19:02:33.488227',265,265,NULL,'49f3f4cf-da29-423e-831c-8dc72858d267',84,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',1,'2026-01-24 19:02:33','5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:02:36.878326',NULL,'2026-01-23 19:02:36.925180',266,266,'2caaa2bea59549f48039d35cd4c79c3d','0c42b37f-0c48-4be8-8a7a-dce4e7736b7b',95,'8ea2dddd772b49f1b9e0a76f8a04e556','shares',1,'2026-01-24 19:02:36',NULL),('2026-01-23 19:02:36.880297',NULL,'2026-01-23 19:02:36.925180',267,267,'2caaa2bea59549f48039d35cd4c79c3d','3bc9486b-340c-4699-9f41-66783756804c',96,'8ea2dddd772b49f1b9e0a76f8a04e556','gigabytes',1,'2026-01-24 19:02:36',NULL),('2026-01-23 19:02:36.891794',NULL,'2026-01-23 19:02:36.925180',268,268,NULL,'33dbb277-7e64-4f8b-9c5f-2b823ae3228e',97,'8ea2dddd772b49f1b9e0a76f8a04e556','shares',1,'2026-01-24 19:02:36','9d723286-feb8-4b59-ba94-db1ea3aa7f91'),('2026-01-23 19:02:36.893263',NULL,'2026-01-23 19:02:36.925180',269,269,NULL,'3c964583-8ca5-4970-8d68-0eac61dd3ec0',98,'8ea2dddd772b49f1b9e0a76f8a04e556','gigabytes',1,'2026-01-24 19:02:36','9d723286-feb8-4b59-ba94-db1ea3aa7f91'),('2026-01-23 19:02:37.499720',NULL,'2026-01-23 19:02:37.514995',270,270,'48aab17447ce4d90a8a1db613f1ea646','9b19c1bd-5e9d-4efa-923a-7e4a010ab804',81,'f2beea25a5e947aab5d0bb53058124cf','shares',-1,'2026-01-24 19:02:37',NULL),('2026-01-23 19:02:37.500630',NULL,'2026-01-23 19:02:37.514995',271,271,'48aab17447ce4d90a8a1db613f1ea646','0eb64a52-7386-492e-8d80-74d6c385bb19',82,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',-1,'2026-01-24 19:02:37',NULL),('2026-01-23 19:02:37.506601',NULL,'2026-01-23 19:02:37.514995',272,272,NULL,'21b3fd9d-838d-4e74-bbd9-7593349c9112',83,'f2beea25a5e947aab5d0bb53058124cf','shares',-1,'2026-01-24 19:02:37','5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:02:37.507199',NULL,'2026-01-23 19:02:37.514995',273,273,NULL,'177f5fe4-36c1-4be5-80c5-841119455c15',84,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',-1,'2026-01-24 19:02:37','5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:02:39.259792',NULL,'2026-01-23 19:02:39.273292',274,274,'795d61c6748c4ee1963bd0cf94173c58','2387dc0c-4ae7-4e37-8ba5-6b69b8be1106',73,'db171ed11cd54288960e2675bc51a3a1','shares',-1,'2026-01-24 19:02:39',NULL),('2026-01-23 19:02:39.260636',NULL,'2026-01-23 19:02:39.273292',275,275,'795d61c6748c4ee1963bd0cf94173c58','47893a3f-cb65-47f7-b223-678fe1e900c6',74,'db171ed11cd54288960e2675bc51a3a1','gigabytes',-1,'2026-01-24 19:02:39',NULL),('2026-01-23 19:02:39.266110',NULL,'2026-01-23 19:02:39.273292',276,276,NULL,'add41d67-300d-403e-8053-cc1d2227531b',93,'db171ed11cd54288960e2675bc51a3a1','shares',-1,'2026-01-24 19:02:39','2edae7de-0cac-41e9-8dee-a7f49a9c9caa'),('2026-01-23 19:02:39.266790',NULL,'2026-01-23 19:02:39.273292',277,277,NULL,'0cd54aa1-e717-4c06-a95a-0facac478dd4',94,'db171ed11cd54288960e2675bc51a3a1','gigabytes',-1,'2026-01-24 19:02:39','2edae7de-0cac-41e9-8dee-a7f49a9c9caa'),('2026-01-23 19:02:39.975120',NULL,'2026-01-23 19:02:40.017462',278,278,'aab37409764d412dbda1be20cc09c609','b3fd0783-a75b-4f71-a432-f8ebb6dde657',99,'a9e6aa878c9c4cbaba399c1a4dd39ad1','shares',1,'2026-01-24 19:02:39',NULL),('2026-01-23 19:02:39.976664',NULL,'2026-01-23 19:02:40.017462',279,279,'aab37409764d412dbda1be20cc09c609','7e824d75-464e-4c15-92b0-8264e1db5b78',100,'a9e6aa878c9c4cbaba399c1a4dd39ad1','gigabytes',1,'2026-01-24 19:02:39',NULL),('2026-01-23 19:02:39.993957',NULL,'2026-01-23 19:02:40.017462',280,280,NULL,'0b6edaad-6c5b-4ef3-8a3c-a95c7e59dfe2',101,'a9e6aa878c9c4cbaba399c1a4dd39ad1','shares',1,'2026-01-24 19:02:39','bdb8bf7b-3c8f-4c28-b5d9-d9a31db95eaa'),('2026-01-23 19:02:39.995035',NULL,'2026-01-23 19:02:40.017462',281,281,NULL,'d0eab7cc-81b5-48d4-a1e9-273e2077c080',102,'a9e6aa878c9c4cbaba399c1a4dd39ad1','gigabytes',1,'2026-01-24 19:02:39','bdb8bf7b-3c8f-4c28-b5d9-d9a31db95eaa'),('2026-01-23 19:02:40.424307',NULL,'2026-01-23 19:02:40.492884',282,282,'2caaa2bea59549f48039d35cd4c79c3d','d2ad2a99-dcdf-43a1-933d-2b6c32483735',103,'8ea2dddd772b49f1b9e0a76f8a04e556','snapshots',1,'2026-01-24 19:02:40',NULL),('2026-01-23 19:02:40.425662',NULL,'2026-01-23 19:02:40.492884',283,283,'2caaa2bea59549f48039d35cd4c79c3d','458e1c37-01bc-493f-9fdf-fdfb392b3753',104,'8ea2dddd772b49f1b9e0a76f8a04e556','snapshot_gigabytes',1,'2026-01-24 19:02:40',NULL),('2026-01-23 19:02:40.437247',NULL,'2026-01-23 19:02:40.492884',284,284,NULL,'59a40406-ac65-42a7-a123-6a1b4b5fcd7b',105,'8ea2dddd772b49f1b9e0a76f8a04e556','snapshots',1,'2026-01-24 19:02:40','9d723286-feb8-4b59-ba94-db1ea3aa7f91'),('2026-01-23 19:02:40.439362',NULL,'2026-01-23 19:02:40.492884',285,285,NULL,'ea7b7a51-d576-4989-bdda-17fd058e6970',106,'8ea2dddd772b49f1b9e0a76f8a04e556','snapshot_gigabytes',1,'2026-01-24 19:02:40','9d723286-feb8-4b59-ba94-db1ea3aa7f91'),('2026-01-23 19:02:40.553040',NULL,'2026-01-23 19:02:40.579769',286,286,'48aab17447ce4d90a8a1db613f1ea646','4d37e11a-d369-4324-9f26-ff918fbe0654',81,'f2beea25a5e947aab5d0bb53058124cf','shares',1,'2026-01-24 19:02:40',NULL),('2026-01-23 19:02:40.554213',NULL,'2026-01-23 19:02:40.579769',287,287,'48aab17447ce4d90a8a1db613f1ea646','adb38eab-670a-4b8c-a348-d6c446f4ffb0',82,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',1,'2026-01-24 19:02:40',NULL),('2026-01-23 19:02:40.559848',NULL,'2026-01-23 19:02:40.579769',288,288,NULL,'9c39a176-94b7-4566-b527-04904d2f4fa7',83,'f2beea25a5e947aab5d0bb53058124cf','shares',1,'2026-01-24 19:02:40','5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:02:40.560852',NULL,'2026-01-23 19:02:40.579769',289,289,NULL,'286e9981-4629-4723-9e76-8e7cc41d8605',84,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',1,'2026-01-24 19:02:40','5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:02:42.933736',NULL,'2026-01-23 19:02:42.954933',290,290,'795d61c6748c4ee1963bd0cf94173c58','261407a5-5ebc-43c7-a15e-209976ac04d7',73,'db171ed11cd54288960e2675bc51a3a1','shares',-1,'2026-01-24 19:02:42',NULL),('2026-01-23 19:02:42.934585',NULL,'2026-01-23 19:02:42.954933',291,291,'795d61c6748c4ee1963bd0cf94173c58','40fd9518-7381-44b8-93f0-4a9ea3b2ffdc',74,'db171ed11cd54288960e2675bc51a3a1','gigabytes',-1,'2026-01-24 19:02:42',NULL),('2026-01-23 19:02:42.945919',NULL,'2026-01-23 19:02:42.954933',292,292,NULL,'ef1a1075-4b18-46d3-863d-b13ac9635398',75,'db171ed11cd54288960e2675bc51a3a1','shares',-1,'2026-01-24 19:02:42','fe8a42c9-28ea-4c66-bed3-f2f6d12529fa'),('2026-01-23 19:02:42.947018',NULL,'2026-01-23 19:02:42.954933',293,293,NULL,'a131fa50-7123-4ae4-a782-8274de7a28ab',76,'db171ed11cd54288960e2675bc51a3a1','gigabytes',-1,'2026-01-24 19:02:42','fe8a42c9-28ea-4c66-bed3-f2f6d12529fa'),('2026-01-23 19:02:43.335931',NULL,'2026-01-23 19:02:43.424481',294,294,'aab37409764d412dbda1be20cc09c609','88a1bac9-924d-4a50-a49a-b320ff7e81de',107,'a9e6aa878c9c4cbaba399c1a4dd39ad1','snapshots',1,'2026-01-24 19:02:43',NULL),('2026-01-23 19:02:43.337037',NULL,'2026-01-23 19:02:43.424481',295,295,'aab37409764d412dbda1be20cc09c609','5a43a3c0-a84c-43cb-9802-4ccbcbdfa293',108,'a9e6aa878c9c4cbaba399c1a4dd39ad1','snapshot_gigabytes',1,'2026-01-24 19:02:43',NULL),('2026-01-23 19:02:43.373928',NULL,'2026-01-23 19:02:43.424481',296,296,NULL,'a36a3f68-ca63-4c65-9684-d92054179067',109,'a9e6aa878c9c4cbaba399c1a4dd39ad1','snapshots',1,'2026-01-24 19:02:43','bdb8bf7b-3c8f-4c28-b5d9-d9a31db95eaa'),('2026-01-23 19:02:43.374997',NULL,'2026-01-23 19:02:43.424481',297,297,NULL,'cabc9f8e-ec0b-416a-a61b-7db1630a6466',110,'a9e6aa878c9c4cbaba399c1a4dd39ad1','snapshot_gigabytes',1,'2026-01-24 19:02:43','bdb8bf7b-3c8f-4c28-b5d9-d9a31db95eaa'),('2026-01-23 19:02:43.862942',NULL,'2026-01-23 19:02:43.900873',298,298,'2caaa2bea59549f48039d35cd4c79c3d','0db03b12-f1b4-4d9e-ac82-622f9aca7520',95,'8ea2dddd772b49f1b9e0a76f8a04e556','shares',1,'2026-01-24 19:02:43',NULL),('2026-01-23 19:02:43.864301',NULL,'2026-01-23 19:02:43.900873',299,299,'2caaa2bea59549f48039d35cd4c79c3d','f0032972-8d2d-41cb-a59d-8d1bb5f2cfe5',96,'8ea2dddd772b49f1b9e0a76f8a04e556','gigabytes',1,'2026-01-24 19:02:43',NULL),('2026-01-23 19:02:43.873664',NULL,'2026-01-23 19:02:43.900873',300,300,NULL,'1b6114b1-246e-48c0-b1a2-2662dc24d158',97,'8ea2dddd772b49f1b9e0a76f8a04e556','shares',1,'2026-01-24 19:02:43','9d723286-feb8-4b59-ba94-db1ea3aa7f91'),('2026-01-23 19:02:43.874971',NULL,'2026-01-23 19:02:43.900873',301,301,NULL,'ffb57b9f-19c3-4910-8d90-d3893a113e07',98,'8ea2dddd772b49f1b9e0a76f8a04e556','gigabytes',1,'2026-01-24 19:02:43','9d723286-feb8-4b59-ba94-db1ea3aa7f91'),('2026-01-23 19:02:45.546067',NULL,'2026-01-23 19:02:45.560714',302,302,'48aab17447ce4d90a8a1db613f1ea646','e0782966-33b4-4890-8bd2-9b2ac5d1e219',81,'f2beea25a5e947aab5d0bb53058124cf','shares',-1,'2026-01-24 19:02:45',NULL),('2026-01-23 19:02:45.547181',NULL,'2026-01-23 19:02:45.560714',303,303,'48aab17447ce4d90a8a1db613f1ea646','74a9050f-2bdf-4196-80b8-5d1633925d48',82,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',-1,'2026-01-24 19:02:45',NULL),('2026-01-23 19:02:45.552998',NULL,'2026-01-23 19:02:45.560714',304,304,NULL,'9cf62445-08aa-41b0-b6ec-82310fcf5916',83,'f2beea25a5e947aab5d0bb53058124cf','shares',-1,'2026-01-24 19:02:45','5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:02:45.553823',NULL,'2026-01-23 19:02:45.560714',305,305,NULL,'3a3860ff-9510-4307-a260-a5169079ff01',84,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',-1,'2026-01-24 19:02:45','5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:02:46.250681',NULL,'2026-01-23 19:02:46.265475',306,306,'58ba79b6c9994c0fb14affae9b8f0c8c','ebb0e283-ede4-4bcf-b8c0-df9d99e13852',51,'e19ff7e178044a3f9516cdc773fa4d6b','shares',-1,'2026-01-24 19:02:46',NULL),('2026-01-23 19:02:46.251524',NULL,'2026-01-23 19:02:46.265475',307,307,'58ba79b6c9994c0fb14affae9b8f0c8c','26c5303a-0fd7-45c1-ae1f-6b32cfc26e5c',52,'e19ff7e178044a3f9516cdc773fa4d6b','gigabytes',-1,'2026-01-24 19:02:46',NULL),('2026-01-23 19:02:46.257543',NULL,'2026-01-23 19:02:46.265475',308,308,NULL,'261e524a-13c4-43e0-bb9e-106287283a98',55,'e19ff7e178044a3f9516cdc773fa4d6b','shares',-1,'2026-01-24 19:02:46','fe8a42c9-28ea-4c66-bed3-f2f6d12529fa'),('2026-01-23 19:02:46.258152',NULL,'2026-01-23 19:02:46.265475',309,309,NULL,'86f77a5c-50e3-4c4c-8358-f9bfc6344ffe',56,'e19ff7e178044a3f9516cdc773fa4d6b','gigabytes',-1,'2026-01-24 19:02:46','fe8a42c9-28ea-4c66-bed3-f2f6d12529fa'),('2026-01-23 19:02:47.533719',NULL,'2026-01-23 19:02:47.562471',310,310,'aab37409764d412dbda1be20cc09c609','2d9f8178-6ef8-4a9c-9c15-073f5c9a44ea',107,'a9e6aa878c9c4cbaba399c1a4dd39ad1','snapshots',-1,'2026-01-24 19:02:47',NULL),('2026-01-23 19:02:47.534603',NULL,'2026-01-23 19:02:47.562471',311,311,'aab37409764d412dbda1be20cc09c609','3a9f44db-1844-4fee-9b4b-2dccb44dc7a1',108,'a9e6aa878c9c4cbaba399c1a4dd39ad1','snapshot_gigabytes',-1,'2026-01-24 19:02:47',NULL),('2026-01-23 19:02:47.543131',NULL,'2026-01-23 19:02:47.562471',312,312,NULL,'a71e122d-6678-464e-be48-37dcdd691aea',109,'a9e6aa878c9c4cbaba399c1a4dd39ad1','snapshots',-1,'2026-01-24 19:02:47','bdb8bf7b-3c8f-4c28-b5d9-d9a31db95eaa'),('2026-01-23 19:02:47.549278',NULL,'2026-01-23 19:02:47.562471',313,313,NULL,'97df41ea-1827-4293-94bd-3830f1911af2',110,'a9e6aa878c9c4cbaba399c1a4dd39ad1','snapshot_gigabytes',-1,'2026-01-24 19:02:47','bdb8bf7b-3c8f-4c28-b5d9-d9a31db95eaa'),('2026-01-23 19:02:50.113160',NULL,'2026-01-23 19:02:50.158916',314,314,'48aab17447ce4d90a8a1db613f1ea646','bbe6a300-6935-4879-9fb2-ba2e815de333',81,'f2beea25a5e947aab5d0bb53058124cf','shares',1,'2026-01-24 19:02:50',NULL),('2026-01-23 19:02:50.114577',NULL,'2026-01-23 19:02:50.158916',315,315,'48aab17447ce4d90a8a1db613f1ea646','6e3ef6c7-4501-44f0-ab3d-b1812f5557cf',82,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',1,'2026-01-24 19:02:50',NULL),('2026-01-23 19:02:50.122318',NULL,'2026-01-23 19:02:50.158916',316,316,NULL,'4909b7da-3d8e-46b6-9f42-96027dfc666a',83,'f2beea25a5e947aab5d0bb53058124cf','shares',1,'2026-01-24 19:02:50','5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:02:50.124034',NULL,'2026-01-23 19:02:50.158916',317,317,NULL,'65fc926a-8006-4347-aa0c-8ba06f11ee1a',84,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',1,'2026-01-24 19:02:50','5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:02:50.954727',NULL,'2026-01-23 19:02:50.990155',318,318,'58ba79b6c9994c0fb14affae9b8f0c8c','84e92bd3-4126-4989-957d-82d6d0057750',51,'e19ff7e178044a3f9516cdc773fa4d6b','shares',-1,'2026-01-24 19:02:50',NULL),('2026-01-23 19:02:50.957367',NULL,'2026-01-23 19:02:50.990155',319,319,'58ba79b6c9994c0fb14affae9b8f0c8c','b43cc5ef-870a-4cea-8ae1-0466ff78c17e',52,'e19ff7e178044a3f9516cdc773fa4d6b','gigabytes',-1,'2026-01-24 19:02:50',NULL),('2026-01-23 19:02:50.974617',NULL,'2026-01-23 19:02:50.990155',320,320,NULL,'da9ff175-6a60-4935-9491-9565c29ef8e0',53,'e19ff7e178044a3f9516cdc773fa4d6b','shares',-1,'2026-01-24 19:02:50','2edae7de-0cac-41e9-8dee-a7f49a9c9caa'),('2026-01-23 19:02:50.975668',NULL,'2026-01-23 19:02:50.990155',321,321,NULL,'9e640d28-46b9-41b9-a69c-c10601998abd',54,'e19ff7e178044a3f9516cdc773fa4d6b','gigabytes',-1,'2026-01-24 19:02:50','2edae7de-0cac-41e9-8dee-a7f49a9c9caa'),('2026-01-23 19:02:51.084275',NULL,'2026-01-23 19:02:51.099353',322,322,'aab37409764d412dbda1be20cc09c609','bc687d87-9b8c-4e40-bab8-eafe960e4641',99,'a9e6aa878c9c4cbaba399c1a4dd39ad1','shares',-1,'2026-01-24 19:02:51',NULL),('2026-01-23 19:02:51.085282',NULL,'2026-01-23 19:02:51.099353',323,323,'aab37409764d412dbda1be20cc09c609','ebb81c3d-5f9e-470f-9dc8-49b00a6e2705',100,'a9e6aa878c9c4cbaba399c1a4dd39ad1','gigabytes',-1,'2026-01-24 19:02:51',NULL),('2026-01-23 19:02:51.091217',NULL,'2026-01-23 19:02:51.099353',324,324,NULL,'a44e9d08-f757-456c-aae7-5441b26abaac',101,'a9e6aa878c9c4cbaba399c1a4dd39ad1','shares',-1,'2026-01-24 19:02:51','bdb8bf7b-3c8f-4c28-b5d9-d9a31db95eaa'),('2026-01-23 19:02:51.091899',NULL,'2026-01-23 19:02:51.099353',325,325,NULL,'c49f6e48-56ed-4642-af54-b82d5276c7ac',102,'a9e6aa878c9c4cbaba399c1a4dd39ad1','gigabytes',-1,'2026-01-24 19:02:51','bdb8bf7b-3c8f-4c28-b5d9-d9a31db95eaa'),('2026-01-23 19:02:56.720018',NULL,'2026-01-23 19:02:56.742007',326,326,'48aab17447ce4d90a8a1db613f1ea646','7242c888-7067-4bd0-9861-1c3362ddd751',81,'f2beea25a5e947aab5d0bb53058124cf','shares',-1,'2026-01-24 19:02:56',NULL),('2026-01-23 19:02:56.720865',NULL,'2026-01-23 19:02:56.742007',327,327,'48aab17447ce4d90a8a1db613f1ea646','7db86161-ed4a-47cd-b068-f5cbab49b207',82,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',-1,'2026-01-24 19:02:56',NULL),('2026-01-23 19:02:56.729733',NULL,'2026-01-23 19:02:56.742007',328,328,NULL,'6a187033-9056-4f89-ad62-ee2ebd19542a',83,'f2beea25a5e947aab5d0bb53058124cf','shares',-1,'2026-01-24 19:02:56','5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:02:56.730959',NULL,'2026-01-23 19:02:56.742007',329,329,NULL,'53fb6014-6c4c-442a-b00d-18deb3c6b64e',84,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',-1,'2026-01-24 19:02:56','5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:03:01.949607',NULL,'2026-01-23 19:03:02.052253',330,330,'2caaa2bea59549f48039d35cd4c79c3d','262dd228-475b-463d-93ec-cd8c70c406af',95,'8ea2dddd772b49f1b9e0a76f8a04e556','shares',-1,'2026-01-24 19:03:01',NULL),('2026-01-23 19:03:01.950317',NULL,'2026-01-23 19:03:02.052253',331,331,'2caaa2bea59549f48039d35cd4c79c3d','403347bc-68b8-46da-bffd-ad7c8977c7cc',96,'8ea2dddd772b49f1b9e0a76f8a04e556','gigabytes',-1,'2026-01-24 19:03:01',NULL),('2026-01-23 19:03:02.032625',NULL,'2026-01-23 19:03:02.052253',332,332,NULL,'16928fdc-7ea4-4432-bf7c-4ecbc4429bbc',97,'8ea2dddd772b49f1b9e0a76f8a04e556','shares',-1,'2026-01-24 19:03:01','9d723286-feb8-4b59-ba94-db1ea3aa7f91'),('2026-01-23 19:03:02.037543',NULL,'2026-01-23 19:03:02.052253',333,333,NULL,'197bc225-d1c8-4b95-b381-9f064092fe2d',98,'8ea2dddd772b49f1b9e0a76f8a04e556','gigabytes',-1,'2026-01-24 19:03:01','9d723286-feb8-4b59-ba94-db1ea3aa7f91'),('2026-01-23 19:03:02.119981',NULL,'2026-01-23 19:03:02.160092',334,334,'17ec91f691e54474893d8e435e589e7d','29b71b02-fbfd-46dd-b6d4-02163e3d166f',111,'26ffaef7ee914dff8756a8885f9f07e2','shares',1,'2026-01-24 19:03:02',NULL),('2026-01-23 19:03:02.121217',NULL,'2026-01-23 19:03:02.160092',335,335,'17ec91f691e54474893d8e435e589e7d','87b030f9-8a66-4538-99b6-d87404963283',112,'26ffaef7ee914dff8756a8885f9f07e2','gigabytes',1,'2026-01-24 19:03:02',NULL),('2026-01-23 19:03:02.131851',NULL,'2026-01-23 19:03:02.160092',336,336,NULL,'d47eff73-1e21-4235-8adf-6de112a5e0d0',113,'26ffaef7ee914dff8756a8885f9f07e2','shares',1,'2026-01-24 19:03:02','5970bbf1-902e-4fec-a95f-9ecee5bbb631'),('2026-01-23 19:03:02.133228',NULL,'2026-01-23 19:03:02.160092',337,337,NULL,'80b8185e-44b7-46bb-904b-ee768f1328e1',114,'26ffaef7ee914dff8756a8885f9f07e2','gigabytes',1,'2026-01-24 19:03:02','5970bbf1-902e-4fec-a95f-9ecee5bbb631'),('2026-01-23 19:03:02.793999',NULL,'2026-01-23 19:03:02.824898',338,338,'48aab17447ce4d90a8a1db613f1ea646','767c7969-ac2d-4706-9ed8-1611de106e62',81,'f2beea25a5e947aab5d0bb53058124cf','shares',-1,'2026-01-24 19:03:02',NULL),('2026-01-23 19:03:02.794830',NULL,'2026-01-23 19:03:02.824898',339,339,'48aab17447ce4d90a8a1db613f1ea646','c239c148-ceea-478d-a8d9-a1022e3faec9',82,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',-1,'2026-01-24 19:03:02',NULL),('2026-01-23 19:03:02.814807',NULL,'2026-01-23 19:03:02.824898',340,340,NULL,'f3b76d40-e8c8-4d66-a172-5aa00a8a36ef',83,'f2beea25a5e947aab5d0bb53058124cf','shares',-1,'2026-01-24 19:03:02','5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:03:02.816037',NULL,'2026-01-23 19:03:02.824898',341,341,NULL,'328dfdfd-b166-42de-886d-c93f5f63a065',84,'f2beea25a5e947aab5d0bb53058124cf','gigabytes',-1,'2026-01-24 19:03:02','5a7e3cee-6582-4736-9a7d-82a9c9a4db19'),('2026-01-23 19:03:05.547073',NULL,'2026-01-23 19:03:05.567290',342,342,'2caaa2bea59549f48039d35cd4c79c3d','1f27402e-5a57-4c0b-bce9-38d0de1604f2',103,'8ea2dddd772b49f1b9e0a76f8a04e556','snapshots',-1,'2026-01-24 19:03:05',NULL),('2026-01-23 19:03:05.547728',NULL,'2026-01-23 19:03:05.567290',343,343,'2caaa2bea59549f48039d35cd4c79c3d','f1a306b1-8e13-46f8-984d-2df0f960892c',104,'8ea2dddd772b49f1b9e0a76f8a04e556','snapshot_gigabytes',-1,'2026-01-24 19:03:05',NULL),('2026-01-23 19:03:05.554670',NULL,'2026-01-23 19:03:05.567290',344,344,NULL,'98836959-1b7e-4717-98d3-03ba088a6967',105,'8ea2dddd772b49f1b9e0a76f8a04e556','snapshots',-1,'2026-01-24 19:03:05','9d723286-feb8-4b59-ba94-db1ea3aa7f91'),('2026-01-23 19:03:05.555552',NULL,'2026-01-23 19:03:05.567290',345,345,NULL,'4ad85461-e0c1-4cea-a931-dc92f47d7086',106,'8ea2dddd772b49f1b9e0a76f8a04e556','snapshot_gigabytes',-1,'2026-01-24 19:03:05','9d723286-feb8-4b59-ba94-db1ea3aa7f91'),('2026-01-23 19:03:05.699021',NULL,'2026-01-23 19:03:06.489606',346,346,'17ec91f691e54474893d8e435e589e7d','a3ba599a-cbf0-4b53-9f9b-25700428a420',115,'26ffaef7ee914dff8756a8885f9f07e2','snapshots',1,'2026-01-24 19:03:05',NULL),('2026-01-23 19:03:05.700755',NULL,'2026-01-23 19:03:06.489606',347,347,'17ec91f691e54474893d8e435e589e7d','80c10a0d-765c-41da-a5c3-11141fd5a50b',116,'26ffaef7ee914dff8756a8885f9f07e2','snapshot_gigabytes',1,'2026-01-24 19:03:05',NULL),('2026-01-23 19:03:05.739545',NULL,'2026-01-23 19:03:06.489606',348,348,NULL,'7fc7a8f7-20f4-40a0-b572-5fb25afec6a6',117,'26ffaef7ee914dff8756a8885f9f07e2','snapshots',1,'2026-01-24 19:03:05','5970bbf1-902e-4fec-a95f-9ecee5bbb631'),('2026-01-23 19:03:05.741082',NULL,'2026-01-23 19:03:06.489606',349,349,NULL,'5954e45b-dfd0-4ed4-a2f3-b8c08b5a1494',118,'26ffaef7ee914dff8756a8885f9f07e2','snapshot_gigabytes',1,'2026-01-24 19:03:05','5970bbf1-902e-4fec-a95f-9ecee5bbb631'),('2026-01-23 19:03:09.005085',NULL,'2026-01-23 19:03:09.022101',350,350,'2caaa2bea59549f48039d35cd4c79c3d','a19ef596-c2c9-42f2-bbe7-3a3ed13cb2ce',95,'8ea2dddd772b49f1b9e0a76f8a04e556','shares',-1,'2026-01-24 19:03:08',NULL),('2026-01-23 19:03:09.006040',NULL,'2026-01-23 19:03:09.022101',351,351,'2caaa2bea59549f48039d35cd4c79c3d','94f18b98-ae86-47ee-a257-71b2e9f65744',96,'8ea2dddd772b49f1b9e0a76f8a04e556','gigabytes',-1,'2026-01-24 19:03:08',NULL),('2026-01-23 19:03:09.013252',NULL,'2026-01-23 19:03:09.022101',352,352,NULL,'2baa6e22-e066-4fd6-ae67-eba41896484f',97,'8ea2dddd772b49f1b9e0a76f8a04e556','shares',-1,'2026-01-24 19:03:08','9d723286-feb8-4b59-ba94-db1ea3aa7f91'),('2026-01-23 19:03:09.014281',NULL,'2026-01-23 19:03:09.022101',353,353,NULL,'66b6ab6d-3faf-49ea-aa41-2894287836e3',98,'8ea2dddd772b49f1b9e0a76f8a04e556','gigabytes',-1,'2026-01-24 19:03:08','9d723286-feb8-4b59-ba94-db1ea3aa7f91'),('2026-01-23 19:03:11.293688',NULL,'2026-01-23 19:03:11.316571',354,354,'17ec91f691e54474893d8e435e589e7d','f37fdea8-4e68-4601-9264-94a7af137580',115,'26ffaef7ee914dff8756a8885f9f07e2','snapshots',-1,'2026-01-24 19:03:11',NULL),('2026-01-23 19:03:11.294761',NULL,'2026-01-23 19:03:11.316571',355,355,'17ec91f691e54474893d8e435e589e7d','4762c5b2-d000-40a5-995b-231f12c0e89b',116,'26ffaef7ee914dff8756a8885f9f07e2','snapshot_gigabytes',-1,'2026-01-24 19:03:11',NULL),('2026-01-23 19:03:11.307984',NULL,'2026-01-23 19:03:11.316571',356,356,NULL,'373a5bbf-3b36-43ef-94f6-f784758f26a5',117,'26ffaef7ee914dff8756a8885f9f07e2','snapshots',-1,'2026-01-24 19:03:11','5970bbf1-902e-4fec-a95f-9ecee5bbb631'),('2026-01-23 19:03:11.308829',NULL,'2026-01-23 19:03:11.316571',357,357,NULL,'667401b8-180d-4f90-81cf-7dde2454daa1',118,'26ffaef7ee914dff8756a8885f9f07e2','snapshot_gigabytes',-1,'2026-01-24 19:03:11','5970bbf1-902e-4fec-a95f-9ecee5bbb631'),('2026-01-23 19:03:12.070211',NULL,'2026-01-23 19:03:12.250088',358,358,'17ec91f691e54474893d8e435e589e7d','95b41466-5fe1-49df-b217-2e4834e46fd0',111,'26ffaef7ee914dff8756a8885f9f07e2','shares',-1,'2026-01-24 19:03:12',NULL),('2026-01-23 19:03:12.071092',NULL,'2026-01-23 19:03:12.250088',359,359,'17ec91f691e54474893d8e435e589e7d','353f0419-369e-46c1-b205-ef6d212237e9',112,'26ffaef7ee914dff8756a8885f9f07e2','gigabytes',-1,'2026-01-24 19:03:12',NULL),('2026-01-23 19:03:12.098462',NULL,'2026-01-23 19:03:12.250088',360,360,NULL,'6dabacbb-05d6-44bf-a4b0-50cadfe2b868',113,'26ffaef7ee914dff8756a8885f9f07e2','shares',-1,'2026-01-24 19:03:12','5970bbf1-902e-4fec-a95f-9ecee5bbb631'),('2026-01-23 19:03:12.099200',NULL,'2026-01-23 19:03:12.250088',361,361,NULL,'a722c867-6827-432b-957b-c310b87695bd',114,'26ffaef7ee914dff8756a8885f9f07e2','gigabytes',-1,'2026-01-24 19:03:12','5970bbf1-902e-4fec-a95f-9ecee5bbb631'),('2026-01-23 19:03:19.600433',NULL,'2026-01-23 19:03:19.651501',362,362,'39690acf77cd4929bf30d8ec50697f1a','13747f0a-e39d-46b2-9f78-c62f22e016fa',119,'1bedbf7265dc42cf859f02ee7f9194c5','shares',1,'2026-01-24 19:03:19',NULL),('2026-01-23 19:03:19.603226',NULL,'2026-01-23 19:03:19.651501',363,363,'39690acf77cd4929bf30d8ec50697f1a','43b3d878-d2c4-4f24-bf63-0c5fd0d99d24',120,'1bedbf7265dc42cf859f02ee7f9194c5','gigabytes',1,'2026-01-24 19:03:19',NULL),('2026-01-23 19:03:19.630019',NULL,'2026-01-23 19:03:19.651501',364,364,NULL,'c2a6b000-6e84-43c2-83a7-f53143ab1012',121,'1bedbf7265dc42cf859f02ee7f9194c5','shares',1,'2026-01-24 19:03:19','1cd0aa0c-256d-4747-b5c6-735c1e4e32e0'),('2026-01-23 19:03:19.631334',NULL,'2026-01-23 19:03:19.651501',365,365,NULL,'86fa9b06-3f34-4438-86f2-1eea66b77c9b',122,'1bedbf7265dc42cf859f02ee7f9194c5','gigabytes',1,'2026-01-24 19:03:19','1cd0aa0c-256d-4747-b5c6-735c1e4e32e0'),('2026-01-23 19:03:22.099410',NULL,'2026-01-23 19:03:22.192250',366,366,'b3ec277fe4624b46b687bc78d7cf6a03','0b0a2ec3-6c4c-4689-83de-da38b5e6ebbb',123,'3f9725edbd1b4cf299e129c2c7587203','shares',1,'2026-01-24 19:03:22',NULL),('2026-01-23 19:03:22.101263',NULL,'2026-01-23 19:03:22.192250',367,367,'b3ec277fe4624b46b687bc78d7cf6a03','22cf8063-88cf-4857-be25-4b7f7dbd664b',124,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',1,'2026-01-24 19:03:22',NULL),('2026-01-23 19:03:22.112041',NULL,'2026-01-23 19:03:22.192250',368,368,NULL,'f2e5d727-25d6-44ca-a64b-928df233887a',125,'3f9725edbd1b4cf299e129c2c7587203','shares',1,'2026-01-24 19:03:22','7362d9e0-868c-4044-a9a6-eed78870ee61'),('2026-01-23 19:03:22.113195',NULL,'2026-01-23 19:03:22.192250',369,369,NULL,'468b44a9-65c2-492f-acdb-8d979e96505c',126,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',1,'2026-01-24 19:03:22','7362d9e0-868c-4044-a9a6-eed78870ee61'),('2026-01-23 19:03:24.654091',NULL,'2026-01-23 19:03:24.696001',370,370,'2fbff2750c964489941186e6647353bd','284c882c-f4cb-4e8b-bb46-2327229017af',127,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',1,'2026-01-24 19:03:24',NULL),('2026-01-23 19:03:24.655404',NULL,'2026-01-23 19:03:24.696001',371,371,'2fbff2750c964489941186e6647353bd','30e6de25-480f-4359-8d56-72b79fd69523',128,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',1,'2026-01-24 19:03:24',NULL),('2026-01-23 19:03:24.674756',NULL,'2026-01-23 19:03:24.696001',372,372,NULL,'96072e78-c38e-4167-bb3e-8988d1b62e2a',129,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',1,'2026-01-24 19:03:24','7902365b-5660-46c8-997e-208dd53ae844'),('2026-01-23 19:03:24.675893',NULL,'2026-01-23 19:03:24.696001',373,373,NULL,'c3f4fdc2-8b3b-4d05-b513-9240364a25c6',130,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',1,'2026-01-24 19:03:24','7902365b-5660-46c8-997e-208dd53ae844'),('2026-01-23 19:03:26.153735',NULL,'2026-01-23 19:03:26.202459',374,374,'b3ec277fe4624b46b687bc78d7cf6a03','0f05c7f0-de74-4558-934b-6b34c1abcffe',123,'3f9725edbd1b4cf299e129c2c7587203','shares',-1,'2026-01-24 19:03:26',NULL),('2026-01-23 19:03:26.156819',NULL,'2026-01-23 19:03:26.202459',375,375,'b3ec277fe4624b46b687bc78d7cf6a03','9ed66efd-7e94-4b00-b9a2-e61d805543e5',124,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',-1,'2026-01-24 19:03:26',NULL),('2026-01-23 19:03:26.167802',NULL,'2026-01-23 19:03:26.202459',376,376,NULL,'4166095d-baef-4190-964f-ce827dcd4c6c',125,'3f9725edbd1b4cf299e129c2c7587203','shares',-1,'2026-01-24 19:03:26','7362d9e0-868c-4044-a9a6-eed78870ee61'),('2026-01-23 19:03:26.168678',NULL,'2026-01-23 19:03:26.202459',377,377,NULL,'7a253bec-11a4-4236-9e2f-dbce74f32a9f',126,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',-1,'2026-01-24 19:03:26','7362d9e0-868c-4044-a9a6-eed78870ee61'),('2026-01-23 19:03:26.477261',NULL,'2026-01-23 19:03:26.510007',378,378,'b3ec277fe4624b46b687bc78d7cf6a03','78645d62-ba3e-4c96-a97d-b7a9969f17d9',123,'3f9725edbd1b4cf299e129c2c7587203','shares',1,'2026-01-24 19:03:26',NULL),('2026-01-23 19:03:26.478927',NULL,'2026-01-23 19:03:26.510007',379,379,'b3ec277fe4624b46b687bc78d7cf6a03','60547f64-123c-4b9a-99f5-e9ac71b21905',124,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',1,'2026-01-24 19:03:26',NULL),('2026-01-23 19:03:26.490064',NULL,'2026-01-23 19:03:26.510007',380,380,NULL,'290c392d-b97e-4af9-8392-c93a925bebe6',131,'3f9725edbd1b4cf299e129c2c7587203','shares',1,'2026-01-24 19:03:26','5bd00120-9b60-4196-9d38-c1e025658518'),('2026-01-23 19:03:26.491215',NULL,'2026-01-23 19:03:26.510007',381,381,NULL,'a168e0c0-ed76-4ce4-9598-4d6a6b3af044',132,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',1,'2026-01-24 19:03:26','5bd00120-9b60-4196-9d38-c1e025658518'),('2026-01-23 19:03:28.076094',NULL,'2026-01-23 19:03:28.147952',382,382,'886ae9f8d85b45299215f046dc178830','92b1f6f0-97e5-4511-a222-6a2bb85beade',133,'a8836123057e49ac857e8374c9186ff3','share_networks',1,'2026-01-24 19:03:28',NULL),('2026-01-23 19:03:28.255489',NULL,'2026-01-23 19:03:28.309493',383,383,'886ae9f8d85b45299215f046dc178830','56c0d811-e30f-43e1-bc80-cd5b70a68f8c',133,'a8836123057e49ac857e8374c9186ff3','share_networks',1,'2026-01-24 19:03:28',NULL),('2026-01-23 19:03:28.360528',NULL,'2026-01-23 19:03:28.382871',384,384,'2fbff2750c964489941186e6647353bd','4ada3cd1-a808-4d39-ba4c-4528f5271494',127,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',-1,'2026-01-24 19:03:28',NULL),('2026-01-23 19:03:28.366628',NULL,'2026-01-23 19:03:28.382871',385,385,'2fbff2750c964489941186e6647353bd','23453475-e1b3-4fc6-b60b-c2be4ccf9dae',128,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',-1,'2026-01-24 19:03:28',NULL),('2026-01-23 19:03:28.373687',NULL,'2026-01-23 19:03:28.382871',386,386,NULL,'3c97b309-5b4e-41e7-84be-f2cab8308854',129,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',-1,'2026-01-24 19:03:28','7902365b-5660-46c8-997e-208dd53ae844'),('2026-01-23 19:03:28.374755',NULL,'2026-01-23 19:03:28.382871',387,387,NULL,'688474c7-7400-4aa9-aa81-a148469cd400',130,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',-1,'2026-01-24 19:03:28','7902365b-5660-46c8-997e-208dd53ae844'),('2026-01-23 19:03:28.544072',NULL,'2026-01-23 19:03:28.578307',388,388,'2fbff2750c964489941186e6647353bd','5b9ea7e8-fb39-47b8-8835-dd53f39487cb',127,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',1,'2026-01-24 19:03:28',NULL),('2026-01-23 19:03:28.545265',NULL,'2026-01-23 19:03:28.578307',389,389,'2fbff2750c964489941186e6647353bd','7c009a23-7e73-4629-840d-9bcca6efe881',128,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',1,'2026-01-24 19:03:28',NULL),('2026-01-23 19:03:28.555883',NULL,'2026-01-23 19:03:28.578307',390,390,NULL,'a069dabf-5e41-4dee-a194-712bb771170c',134,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',1,'2026-01-24 19:03:28','241a7152-12d1-48bb-b5c7-291a074f5b66'),('2026-01-23 19:03:28.557149',NULL,'2026-01-23 19:03:28.578307',391,391,NULL,'8dfdf6e9-e518-4871-9ff5-313a7620085d',135,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',1,'2026-01-24 19:03:28','241a7152-12d1-48bb-b5c7-291a074f5b66'),('2026-01-23 19:03:28.867380',NULL,'2026-01-23 19:03:28.873289',392,392,'886ae9f8d85b45299215f046dc178830','3b40eb9c-16cf-4207-a800-3ba3e119fd9c',133,'a8836123057e49ac857e8374c9186ff3','share_networks',-1,'2026-01-24 19:03:28',NULL),('2026-01-23 19:03:29.018491',NULL,'2026-01-23 19:03:29.058591',393,393,'886ae9f8d85b45299215f046dc178830','45407697-3899-4b7b-acd1-ff8d6d44897f',133,'a8836123057e49ac857e8374c9186ff3','share_networks',1,'2026-01-24 19:03:28',NULL),('2026-01-23 19:03:29.818977',NULL,'2026-01-23 19:03:29.836101',394,394,'886ae9f8d85b45299215f046dc178830','6dce122d-1ce0-4da4-ba8c-c5789f346fb3',133,'a8836123057e49ac857e8374c9186ff3','share_networks',-1,'2026-01-24 19:03:29',NULL),('2026-01-23 19:03:30.040202',NULL,'2026-01-23 19:03:30.055349',395,395,'b3ec277fe4624b46b687bc78d7cf6a03','f19574de-b8f3-4cd2-8ef2-887a41518186',123,'3f9725edbd1b4cf299e129c2c7587203','shares',-1,'2026-01-24 19:03:30',NULL),('2026-01-23 19:03:30.040863',NULL,'2026-01-23 19:03:30.055349',396,396,'b3ec277fe4624b46b687bc78d7cf6a03','9241376d-9302-49bd-a930-c8062d5812c3',124,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',-1,'2026-01-24 19:03:30',NULL),('2026-01-23 19:03:30.046103',NULL,'2026-01-23 19:03:30.055349',397,397,NULL,'5a6f80c1-6297-41bd-a5eb-0df00817b9be',131,'3f9725edbd1b4cf299e129c2c7587203','shares',-1,'2026-01-24 19:03:30','5bd00120-9b60-4196-9d38-c1e025658518'),('2026-01-23 19:03:30.046717',NULL,'2026-01-23 19:03:30.055349',398,398,NULL,'831a1f83-d423-4ec9-9f66-850fad51056d',132,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',-1,'2026-01-24 19:03:30','5bd00120-9b60-4196-9d38-c1e025658518'),('2026-01-23 19:03:30.396791',NULL,'2026-01-23 19:03:30.531294',399,399,'b3ec277fe4624b46b687bc78d7cf6a03','c1e4a120-a4ff-461b-a969-9b78b5591ebc',123,'3f9725edbd1b4cf299e129c2c7587203','shares',1,'2026-01-24 19:03:30',NULL),('2026-01-23 19:03:30.401133',NULL,'2026-01-23 19:03:30.531294',400,400,'b3ec277fe4624b46b687bc78d7cf6a03','ca55daa3-70f0-4cc8-ad07-efd728c6430d',124,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',1,'2026-01-24 19:03:30',NULL),('2026-01-23 19:03:30.438801',NULL,'2026-01-23 19:03:30.531294',401,401,NULL,'6e62a2f6-13da-4fa8-b25d-4fafd8b97979',136,'3f9725edbd1b4cf299e129c2c7587203','shares',1,'2026-01-24 19:03:30','c19ff7fa-2a85-4740-abc5-3c03e603c222'),('2026-01-23 19:03:30.441186',NULL,'2026-01-23 19:03:30.531294',402,402,NULL,'0b5b12bd-1127-4b61-a8b8-575612c028bc',137,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',1,'2026-01-24 19:03:30','c19ff7fa-2a85-4740-abc5-3c03e603c222'),('2026-01-23 19:03:32.149050',NULL,'2026-01-23 19:03:32.170257',403,403,'2fbff2750c964489941186e6647353bd','1cc071cc-c1fb-457c-b8eb-a540cb1e84f0',127,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',-1,'2026-01-24 19:03:32',NULL),('2026-01-23 19:03:32.150228',NULL,'2026-01-23 19:03:32.170257',404,404,'2fbff2750c964489941186e6647353bd','87a6beca-1e8c-4266-8d47-eebb756624c0',128,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',-1,'2026-01-24 19:03:32',NULL),('2026-01-23 19:03:32.158805',NULL,'2026-01-23 19:03:32.170257',405,405,NULL,'e0540ed3-1850-44e2-bdbd-44f1d8bf6251',134,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',-1,'2026-01-24 19:03:32','241a7152-12d1-48bb-b5c7-291a074f5b66'),('2026-01-23 19:03:32.159988',NULL,'2026-01-23 19:03:32.170257',406,406,NULL,'7193f50f-3dab-48d1-82f5-a105d297e643',135,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',-1,'2026-01-24 19:03:32','241a7152-12d1-48bb-b5c7-291a074f5b66'),('2026-01-23 19:03:32.380421',NULL,'2026-01-23 19:03:32.409691',407,407,'2fbff2750c964489941186e6647353bd','fea2619b-1fba-4a5e-9d94-bb791b52cdd1',127,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',1,'2026-01-24 19:03:32',NULL),('2026-01-23 19:03:32.381634',NULL,'2026-01-23 19:03:32.409691',408,408,'2fbff2750c964489941186e6647353bd','a57c7058-21a0-483f-988d-7ec7257f6e19',128,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',1,'2026-01-24 19:03:32',NULL),('2026-01-23 19:03:32.390362',NULL,'2026-01-23 19:03:32.409691',409,409,NULL,'2a5042d2-9953-4f04-ada9-e9741163a2c8',138,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',1,'2026-01-24 19:03:32','8a953b9f-99f3-477f-8f8b-a85b076a7406'),('2026-01-23 19:03:32.391560',NULL,'2026-01-23 19:03:32.409691',410,410,NULL,'bfdd21c7-ced5-4239-8133-5a6da2dfc662',139,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',1,'2026-01-24 19:03:32','8a953b9f-99f3-477f-8f8b-a85b076a7406'),('2026-01-23 19:03:34.288540',NULL,'2026-01-23 19:03:34.302925',411,411,'b3ec277fe4624b46b687bc78d7cf6a03','68919098-a50b-4216-9bbe-e872ebc82a6f',123,'3f9725edbd1b4cf299e129c2c7587203','shares',-1,'2026-01-24 19:03:34',NULL),('2026-01-23 19:03:34.289395',NULL,'2026-01-23 19:03:34.302925',412,412,'b3ec277fe4624b46b687bc78d7cf6a03','ca83542a-56e8-494e-9554-256fbbd6a377',124,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',-1,'2026-01-24 19:03:34',NULL),('2026-01-23 19:03:34.295264',NULL,'2026-01-23 19:03:34.302925',413,413,NULL,'5f877745-c59c-48b4-8087-7e2448896c96',136,'3f9725edbd1b4cf299e129c2c7587203','shares',-1,'2026-01-24 19:03:34','c19ff7fa-2a85-4740-abc5-3c03e603c222'),('2026-01-23 19:03:34.296044',NULL,'2026-01-23 19:03:34.302925',414,414,NULL,'29c1a6a7-1593-426a-b241-29730db19720',137,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',-1,'2026-01-24 19:03:34','c19ff7fa-2a85-4740-abc5-3c03e603c222'),('2026-01-23 19:03:34.600914',NULL,'2026-01-23 19:03:34.659240',415,415,'b3ec277fe4624b46b687bc78d7cf6a03','db319cfc-ff8d-4b2e-89d8-f0abf3bc98e8',123,'3f9725edbd1b4cf299e129c2c7587203','shares',1,'2026-01-24 19:03:34',NULL),('2026-01-23 19:03:34.602278',NULL,'2026-01-23 19:03:34.659240',416,416,'b3ec277fe4624b46b687bc78d7cf6a03','5cec99e8-1f0e-497b-8dc1-74364e406586',124,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',1,'2026-01-24 19:03:34',NULL),('2026-01-23 19:03:34.613257',NULL,'2026-01-23 19:03:34.659240',417,417,NULL,'19082934-2678-4cdc-baa6-3ddbe4759220',140,'3f9725edbd1b4cf299e129c2c7587203','shares',1,'2026-01-24 19:03:34','bccb681a-3222-4edc-857a-aaeddd11ad78'),('2026-01-23 19:03:34.617439',NULL,'2026-01-23 19:03:34.659240',418,418,NULL,'991d91db-8830-4f04-8838-5451dfcc8a87',141,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',1,'2026-01-24 19:03:34','bccb681a-3222-4edc-857a-aaeddd11ad78'),('2026-01-23 19:03:36.104058',NULL,'2026-01-23 19:03:36.275860',419,419,'2fbff2750c964489941186e6647353bd','88196635-92c3-4cdb-aa94-548aa423ff8e',127,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',1,'2026-01-24 19:03:36',NULL),('2026-01-23 19:03:36.105242',NULL,'2026-01-23 19:03:36.275860',420,420,'2fbff2750c964489941186e6647353bd','1f63c7d3-34ef-4bd1-b14d-371ae0a599f6',128,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',1,'2026-01-24 19:03:36',NULL),('2026-01-23 19:03:36.241970',NULL,'2026-01-23 19:03:36.275860',421,421,NULL,'876b5d63-db3c-4603-98ef-d4ee713fc38b',142,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',1,'2026-01-24 19:03:36','7f7e6a30-a2c4-443f-a0c5-e0dfdb57d9d3'),('2026-01-23 19:03:36.243884',NULL,'2026-01-23 19:03:36.275860',422,422,NULL,'7be65d88-5b92-4ba0-911a-24125b66bea6',143,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',1,'2026-01-24 19:03:36','7f7e6a30-a2c4-443f-a0c5-e0dfdb57d9d3'),('2026-01-23 19:03:38.258277',NULL,'2026-01-23 19:03:38.318292',423,423,'b3ec277fe4624b46b687bc78d7cf6a03','a4b88a73-f6c7-45a4-a1bc-327a78805d97',123,'3f9725edbd1b4cf299e129c2c7587203','shares',-1,'2026-01-24 19:03:38',NULL),('2026-01-23 19:03:38.258962',NULL,'2026-01-23 19:03:38.318292',424,424,'b3ec277fe4624b46b687bc78d7cf6a03','62ce8fdf-6570-43cb-9b40-5405aa9dcb1a',124,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',-1,'2026-01-24 19:03:38',NULL),('2026-01-23 19:03:38.295666',NULL,'2026-01-23 19:03:38.318292',425,425,NULL,'e0ff8c59-5fab-4f5f-892f-fa648f1ea4ba',140,'3f9725edbd1b4cf299e129c2c7587203','shares',-1,'2026-01-24 19:03:38','bccb681a-3222-4edc-857a-aaeddd11ad78'),('2026-01-23 19:03:38.296371',NULL,'2026-01-23 19:03:38.318292',426,426,NULL,'1298378e-f69b-4076-8ea2-d64c64e30a1b',141,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',-1,'2026-01-24 19:03:38','bccb681a-3222-4edc-857a-aaeddd11ad78'),('2026-01-23 19:03:38.551697',NULL,'2026-01-23 19:03:38.864594',427,427,'b3ec277fe4624b46b687bc78d7cf6a03','ab516086-a442-4824-b200-fdee9e1958f8',123,'3f9725edbd1b4cf299e129c2c7587203','shares',1,'2026-01-24 19:03:38',NULL),('2026-01-23 19:03:38.552969',NULL,'2026-01-23 19:03:38.864594',428,428,'b3ec277fe4624b46b687bc78d7cf6a03','d14f9562-af52-4681-bf59-807bc6878f04',124,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',1,'2026-01-24 19:03:38',NULL),('2026-01-23 19:03:38.620570',NULL,'2026-01-23 19:03:38.864594',429,429,NULL,'7a1d4908-fd80-4e51-99d3-1ae0af0ce60e',144,'3f9725edbd1b4cf299e129c2c7587203','shares',1,'2026-01-24 19:03:38','e14aad06-9466-486c-bc63-26592e0cdf52'),('2026-01-23 19:03:38.621881',NULL,'2026-01-23 19:03:38.864594',430,430,NULL,'18014a48-ed9d-4c09-bacd-61f3850e9163',145,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',1,'2026-01-24 19:03:38','e14aad06-9466-486c-bc63-26592e0cdf52'),('2026-01-23 19:03:40.132672',NULL,'2026-01-23 19:03:40.147851',431,431,'2fbff2750c964489941186e6647353bd','f1657eb7-faca-45a4-ac42-249c799d52c0',127,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',-1,'2026-01-24 19:03:40',NULL),('2026-01-23 19:03:40.133341',NULL,'2026-01-23 19:03:40.147851',432,432,'2fbff2750c964489941186e6647353bd','e162649b-1b2d-4af8-9a82-e04886f14748',128,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',-1,'2026-01-24 19:03:40',NULL),('2026-01-23 19:03:40.138791',NULL,'2026-01-23 19:03:40.147851',433,433,NULL,'93d217ed-ba48-4009-b27b-df809a152c69',142,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',-1,'2026-01-24 19:03:40','7f7e6a30-a2c4-443f-a0c5-e0dfdb57d9d3'),('2026-01-23 19:03:40.139379',NULL,'2026-01-23 19:03:40.147851',434,434,NULL,'d6651f22-e9e4-4b62-8d55-bfd527c6c4bb',143,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',-1,'2026-01-24 19:03:40','7f7e6a30-a2c4-443f-a0c5-e0dfdb57d9d3'),('2026-01-23 19:03:40.419548',NULL,'2026-01-23 19:03:40.437716',435,435,'2fbff2750c964489941186e6647353bd','5de8d11e-eb8a-4003-b749-53da52d8ac7c',127,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',-1,'2026-01-24 19:03:40',NULL),('2026-01-23 19:03:40.420365',NULL,'2026-01-23 19:03:40.437716',436,436,'2fbff2750c964489941186e6647353bd','eacf7ae5-9c06-42bd-8df8-628f7f4a81c9',128,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',-1,'2026-01-24 19:03:40',NULL),('2026-01-23 19:03:40.429373',NULL,'2026-01-23 19:03:40.437716',437,437,NULL,'48dc52a2-4f95-4acf-a079-b22d74e35368',138,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',-1,'2026-01-24 19:03:40','8a953b9f-99f3-477f-8f8b-a85b076a7406'),('2026-01-23 19:03:40.430210',NULL,'2026-01-23 19:03:40.437716',438,438,NULL,'d55f6ace-ddf9-4b71-bacf-10159c72d810',139,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',-1,'2026-01-24 19:03:40','8a953b9f-99f3-477f-8f8b-a85b076a7406'),('2026-01-23 19:03:40.649198',NULL,'2026-01-23 19:03:40.688931',439,439,'2fbff2750c964489941186e6647353bd','9e30206e-c77c-4f53-8ba1-0404ec38055c',127,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',1,'2026-01-24 19:03:40',NULL),('2026-01-23 19:03:40.650663',NULL,'2026-01-23 19:03:40.688931',440,440,'2fbff2750c964489941186e6647353bd','fa858b09-3d51-4718-855d-45992c5eba54',128,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',1,'2026-01-24 19:03:40',NULL),('2026-01-23 19:03:40.661708',NULL,'2026-01-23 19:03:40.688931',441,441,NULL,'d8567675-c7e1-48a2-809d-1a036f7ebd9b',146,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',1,'2026-01-24 19:03:40','25eb52ab-ed01-4f19-94db-7202aa609ac2'),('2026-01-23 19:03:40.662940',NULL,'2026-01-23 19:03:40.688931',442,442,NULL,'174c48c2-8ab0-4fa7-b602-b835631ce714',147,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',1,'2026-01-24 19:03:40','25eb52ab-ed01-4f19-94db-7202aa609ac2'),('2026-01-23 19:03:40.685359',NULL,'2026-01-23 19:03:40.721245',443,443,'fd03ddd06d374af6aaab5af51dd14875','664f5800-1b8f-48fc-859f-796846ff27c8',148,'5ed6311cb89a4e81ac3637cb0a3cdbbe','shares',1,'2026-01-24 19:03:40',NULL),('2026-01-23 19:03:40.686715',NULL,'2026-01-23 19:03:40.721245',444,444,'fd03ddd06d374af6aaab5af51dd14875','fff31623-af90-4028-9f03-bf957170ff7c',149,'5ed6311cb89a4e81ac3637cb0a3cdbbe','gigabytes',1,'2026-01-24 19:03:40',NULL),('2026-01-23 19:03:40.697005',NULL,'2026-01-23 19:03:40.721245',445,445,NULL,'d432f3bf-56af-4a08-8a12-6badaa10cb87',150,'5ed6311cb89a4e81ac3637cb0a3cdbbe','shares',1,'2026-01-24 19:03:40','d4340069-92a0-40b1-9a2d-4931749a22be'),('2026-01-23 19:03:40.698968',NULL,'2026-01-23 19:03:40.721245',446,446,NULL,'04ab0470-1150-4d84-89bf-dea9db92286f',151,'5ed6311cb89a4e81ac3637cb0a3cdbbe','gigabytes',1,'2026-01-24 19:03:40','d4340069-92a0-40b1-9a2d-4931749a22be'),('2026-01-23 19:03:42.495701',NULL,'2026-01-23 19:03:42.602465',447,447,'b3ec277fe4624b46b687bc78d7cf6a03','ff5c7ed7-8234-4143-9b6f-db5e05d02142',123,'3f9725edbd1b4cf299e129c2c7587203','shares',-1,'2026-01-24 19:03:42',NULL),('2026-01-23 19:03:42.496799',NULL,'2026-01-23 19:03:42.602465',448,448,'b3ec277fe4624b46b687bc78d7cf6a03','a6413105-7b49-4b98-acd6-95b13b176c47',124,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',-1,'2026-01-24 19:03:42',NULL),('2026-01-23 19:03:42.591787',NULL,'2026-01-23 19:03:42.602465',449,449,NULL,'2cc582a1-7b02-47ed-8217-a4ba46e47fbd',144,'3f9725edbd1b4cf299e129c2c7587203','shares',-1,'2026-01-24 19:03:42','e14aad06-9466-486c-bc63-26592e0cdf52'),('2026-01-23 19:03:42.592948',NULL,'2026-01-23 19:03:42.602465',450,450,NULL,'ec9b6bcb-da18-4a79-895d-2a5cc53b75f7',145,'3f9725edbd1b4cf299e129c2c7587203','gigabytes',-1,'2026-01-24 19:03:42','e14aad06-9466-486c-bc63-26592e0cdf52'),('2026-01-23 19:03:44.174914',NULL,'2026-01-23 19:03:44.232314',451,451,'2fbff2750c964489941186e6647353bd','ea956f3f-b1ee-42f4-972b-7b74a8d176c4',127,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',1,'2026-01-24 19:03:44',NULL),('2026-01-23 19:03:44.176660',NULL,'2026-01-23 19:03:44.232314',452,452,'2fbff2750c964489941186e6647353bd','2870dca1-7e4b-4d43-a8ec-986dc6354a0a',128,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',1,'2026-01-24 19:03:44',NULL),('2026-01-23 19:03:44.195782',NULL,'2026-01-23 19:03:44.232314',453,453,NULL,'e14d3a4d-9fdb-44e7-9210-f1e0f8387fa4',152,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',1,'2026-01-24 19:03:44','1b656fe8-9e38-4e1f-8896-27918147c270'),('2026-01-23 19:03:44.198059',NULL,'2026-01-23 19:03:44.232314',454,454,NULL,'2c4294e1-f11b-43d8-99c6-5cd8c53c27af',153,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',1,'2026-01-24 19:03:44','1b656fe8-9e38-4e1f-8896-27918147c270'),('2026-01-23 19:03:44.921353',NULL,'2026-01-23 19:03:44.954959',455,455,'fd03ddd06d374af6aaab5af51dd14875','2c77e4c4-17c7-4e6e-8572-519b236aa360',148,'5ed6311cb89a4e81ac3637cb0a3cdbbe','shares',1,'2026-01-24 19:03:44',NULL),('2026-01-23 19:03:44.922853',NULL,'2026-01-23 19:03:44.954959',456,456,'fd03ddd06d374af6aaab5af51dd14875','9f51a84a-379c-4dc2-94b2-d61b8d8e9122',149,'5ed6311cb89a4e81ac3637cb0a3cdbbe','gigabytes',1,'2026-01-24 19:03:44',NULL),('2026-01-23 19:03:44.931766',NULL,'2026-01-23 19:03:44.954959',457,457,NULL,'91788800-1957-4c21-a222-4804944a2666',150,'5ed6311cb89a4e81ac3637cb0a3cdbbe','shares',1,'2026-01-24 19:03:44','d4340069-92a0-40b1-9a2d-4931749a22be'),('2026-01-23 19:03:44.933145',NULL,'2026-01-23 19:03:44.954959',458,458,NULL,'6b7fb583-7337-4ad8-8363-0c675865e2f3',151,'5ed6311cb89a4e81ac3637cb0a3cdbbe','gigabytes',1,'2026-01-24 19:03:44','d4340069-92a0-40b1-9a2d-4931749a22be'),('2026-01-23 19:03:47.859648',NULL,'2026-01-23 19:03:47.908112',459,459,'2fbff2750c964489941186e6647353bd','b0824acc-b939-4212-abae-08c6e91e7abd',127,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',1,'2026-01-24 19:03:47',NULL),('2026-01-23 19:03:47.860820',NULL,'2026-01-23 19:03:47.908112',460,460,'2fbff2750c964489941186e6647353bd','cd2b44c0-54c0-46b5-9ed8-74cad88d37aa',128,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',1,'2026-01-24 19:03:47',NULL),('2026-01-23 19:03:47.884906',NULL,'2026-01-23 19:03:47.908112',461,461,NULL,'17568d41-da30-4c46-bb25-d4002c0cf413',154,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',1,'2026-01-24 19:03:47','0cc522bc-772d-444b-91ef-721acf2d84b1'),('2026-01-23 19:03:47.886152',NULL,'2026-01-23 19:03:47.908112',462,462,NULL,'7bbd6922-7806-40f2-a307-6d6b3d8c2e2f',155,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',1,'2026-01-24 19:03:47','0cc522bc-772d-444b-91ef-721acf2d84b1'),('2026-01-23 19:03:49.097856',NULL,'2026-01-23 19:03:49.122359',463,463,'fd03ddd06d374af6aaab5af51dd14875','2a95e281-31d1-4a4c-bd56-ed6db1ba9752',148,'5ed6311cb89a4e81ac3637cb0a3cdbbe','shares',1,'2026-01-24 19:03:49',NULL),('2026-01-23 19:03:49.099047',NULL,'2026-01-23 19:03:49.122359',464,464,'fd03ddd06d374af6aaab5af51dd14875','5b518bbe-957e-4e50-85fc-7c601910cbe0',149,'5ed6311cb89a4e81ac3637cb0a3cdbbe','gigabytes',1,'2026-01-24 19:03:49',NULL),('2026-01-23 19:03:49.104181',NULL,'2026-01-23 19:03:49.122359',465,465,NULL,'aec215f3-36bb-4aae-8f78-9397c5c19b92',150,'5ed6311cb89a4e81ac3637cb0a3cdbbe','shares',1,'2026-01-24 19:03:49','d4340069-92a0-40b1-9a2d-4931749a22be'),('2026-01-23 19:03:49.105191',NULL,'2026-01-23 19:03:49.122359',466,466,NULL,'4bf56185-b4bd-4468-b378-43bd3aa3e346',151,'5ed6311cb89a4e81ac3637cb0a3cdbbe','gigabytes',1,'2026-01-24 19:03:49','d4340069-92a0-40b1-9a2d-4931749a22be'),('2026-01-23 19:03:51.634256',NULL,'2026-01-23 19:03:51.690192',467,467,'2fbff2750c964489941186e6647353bd','d807983e-0b1b-49a3-93df-a41bf3e6c582',127,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',-1,'2026-01-24 19:03:51',NULL),('2026-01-23 19:03:51.635213',NULL,'2026-01-23 19:03:51.690192',468,468,'2fbff2750c964489941186e6647353bd','9e716a45-880f-4a07-bc4f-1b72fb8e7875',128,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',-1,'2026-01-24 19:03:51',NULL),('2026-01-23 19:03:51.650896',NULL,'2026-01-23 19:03:51.690192',469,469,NULL,'b79d9c7d-964c-4361-9f36-9ecc86cacc6a',154,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',-1,'2026-01-24 19:03:51','0cc522bc-772d-444b-91ef-721acf2d84b1'),('2026-01-23 19:03:51.651905',NULL,'2026-01-23 19:03:51.690192',470,470,NULL,'a7d3f295-f957-4c20-8ee7-24333ef1ac53',155,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',-1,'2026-01-24 19:03:51','0cc522bc-772d-444b-91ef-721acf2d84b1'),('2026-01-23 19:03:51.919562',NULL,'2026-01-23 19:03:51.942926',471,471,'2fbff2750c964489941186e6647353bd','d75088fc-766d-4b6b-9dfb-20043dd0d17b',127,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',-1,'2026-01-24 19:03:51',NULL),('2026-01-23 19:03:51.920391',NULL,'2026-01-23 19:03:51.942926',472,472,'2fbff2750c964489941186e6647353bd','26f5c67d-a320-46fa-b61b-54c7ceb933fa',128,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',-1,'2026-01-24 19:03:51',NULL),('2026-01-23 19:03:51.933955',NULL,'2026-01-23 19:03:51.942926',473,473,NULL,'559f4e84-2427-48d6-a733-3cf5070bd75e',152,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',-1,'2026-01-24 19:03:51','1b656fe8-9e38-4e1f-8896-27918147c270'),('2026-01-23 19:03:51.934845',NULL,'2026-01-23 19:03:51.942926',474,474,NULL,'d337ad6f-d907-4ac1-8635-9317f5bc6e87',153,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',-1,'2026-01-24 19:03:51','1b656fe8-9e38-4e1f-8896-27918147c270'),('2026-01-23 19:03:52.208574',NULL,'2026-01-23 19:03:52.249933',475,475,'2b6dadb05d14498fb74d0e3ed633c1c2','eedeb64b-b88e-4fc4-b7da-41b2aba6300a',156,'182b21a4575a4acc866fcdd5f8991734','shares',1,'2026-01-24 19:03:52',NULL),('2026-01-23 19:03:52.210112',NULL,'2026-01-23 19:03:52.249933',476,476,'2b6dadb05d14498fb74d0e3ed633c1c2','0cd6f0b8-006c-4fb2-803c-d46d5f638825',157,'182b21a4575a4acc866fcdd5f8991734','gigabytes',1,'2026-01-24 19:03:52',NULL),('2026-01-23 19:03:52.217270',NULL,'2026-01-23 19:03:52.237301',477,477,'2fbff2750c964489941186e6647353bd','38406619-1f90-4abe-8b8f-48de649a6f47',127,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',-1,'2026-01-24 19:03:52',NULL),('2026-01-23 19:03:52.218003',NULL,'2026-01-23 19:03:52.237301',478,478,'2fbff2750c964489941186e6647353bd','eba5fb3c-96fe-4f84-808e-6114b0128f35',128,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',-1,'2026-01-24 19:03:52',NULL),('2026-01-23 19:03:52.221501',NULL,'2026-01-23 19:03:52.249933',479,479,NULL,'fb02d43b-3bb5-46a2-ba57-dc5a3e706850',158,'182b21a4575a4acc866fcdd5f8991734','shares',1,'2026-01-24 19:03:52','fc3dea75-7a38-41a5-9a53-1370369a0c3e'),('2026-01-23 19:03:52.223302',NULL,'2026-01-23 19:03:52.249933',480,480,NULL,'f4298eb9-d9a0-40ec-948f-ac18248e5b74',159,'182b21a4575a4acc866fcdd5f8991734','gigabytes',1,'2026-01-24 19:03:52','fc3dea75-7a38-41a5-9a53-1370369a0c3e'),('2026-01-23 19:03:52.224400',NULL,'2026-01-23 19:03:52.237301',481,481,NULL,'d855e218-9814-4f52-89fd-d9bdccfcf179',146,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',-1,'2026-01-24 19:03:52','25eb52ab-ed01-4f19-94db-7202aa609ac2'),('2026-01-23 19:03:52.225817',NULL,'2026-01-23 19:03:52.237301',482,482,NULL,'d199af7f-c99a-4f85-9f02-e5aadcc7cdd0',147,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',-1,'2026-01-24 19:03:52','25eb52ab-ed01-4f19-94db-7202aa609ac2'),('2026-01-23 19:03:52.394337',NULL,'2026-01-23 19:03:52.435990',483,483,'2fbff2750c964489941186e6647353bd','6bd4b547-f1b6-4281-ab31-40f5b39f3aab',127,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',1,'2026-01-24 19:03:52',NULL),('2026-01-23 19:03:52.395570',NULL,'2026-01-23 19:03:52.435990',484,484,'2fbff2750c964489941186e6647353bd','e9ab02a0-14fa-4414-8d28-05d531ff91a6',128,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',1,'2026-01-24 19:03:52',NULL),('2026-01-23 19:03:52.406826',NULL,'2026-01-23 19:03:52.435990',485,485,NULL,'4186cc65-4a56-402c-ac68-5f1b71d10fba',160,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',1,'2026-01-24 19:03:52','e9d1bb70-adca-4093-9b6e-5c2f0f61fbea'),('2026-01-23 19:03:52.407987',NULL,'2026-01-23 19:03:52.435990',486,486,NULL,'5a94e1e7-b8c7-4712-8ec4-7238998201b7',161,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',1,'2026-01-24 19:03:52','e9d1bb70-adca-4093-9b6e-5c2f0f61fbea'),('2026-01-23 19:03:53.077099',NULL,'2026-01-23 19:03:53.103399',487,487,'fd03ddd06d374af6aaab5af51dd14875','694a8903-b947-45fd-a3d9-9b7945f6b737',148,'5ed6311cb89a4e81ac3637cb0a3cdbbe','shares',1,'2026-01-24 19:03:53',NULL),('2026-01-23 19:03:53.078469',NULL,'2026-01-23 19:03:53.103399',488,488,'fd03ddd06d374af6aaab5af51dd14875','9727b7e6-186c-493e-9cd0-e513b79bfa20',149,'5ed6311cb89a4e81ac3637cb0a3cdbbe','gigabytes',1,'2026-01-24 19:03:53',NULL),('2026-01-23 19:03:53.083943',NULL,'2026-01-23 19:03:53.103399',489,489,NULL,'eae544bc-c908-463a-a523-99cb15adf50b',150,'5ed6311cb89a4e81ac3637cb0a3cdbbe','shares',1,'2026-01-24 19:03:53','d4340069-92a0-40b1-9a2d-4931749a22be'),('2026-01-23 19:03:53.085078',NULL,'2026-01-23 19:03:53.103399',490,490,NULL,'dbee9f30-c5e7-4847-b332-4ecc657138c6',151,'5ed6311cb89a4e81ac3637cb0a3cdbbe','gigabytes',1,'2026-01-24 19:03:53','d4340069-92a0-40b1-9a2d-4931749a22be'),('2026-01-23 19:03:55.891577',NULL,'2026-01-23 19:03:55.952143',491,491,'2fbff2750c964489941186e6647353bd','0f2c9997-565f-4761-b45b-8fb21d077b99',127,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',1,'2026-01-24 19:03:55',NULL),('2026-01-23 19:03:55.893237',NULL,'2026-01-23 19:03:55.952143',492,492,'2fbff2750c964489941186e6647353bd','7d848a3e-d056-44cf-b66d-4a8974ae3bf1',128,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',1,'2026-01-24 19:03:55',NULL),('2026-01-23 19:03:55.913973',NULL,'2026-01-23 19:03:55.952143',493,493,NULL,'b0ad7d9a-719a-4e8e-8345-2f0c10078863',162,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',1,'2026-01-24 19:03:55','91c26460-9fbd-4287-97cf-8d78828587a3'),('2026-01-23 19:03:55.915728',NULL,'2026-01-23 19:03:55.952143',494,494,NULL,'4fdb8002-f9ed-4c51-a0fe-162271147c65',163,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',1,'2026-01-24 19:03:55','91c26460-9fbd-4287-97cf-8d78828587a3'),('2026-01-23 19:03:57.614672',NULL,'2026-01-23 19:03:57.641496',495,495,'fd03ddd06d374af6aaab5af51dd14875','38de8cde-6fbc-49dc-b6d0-46b580d4951d',148,'5ed6311cb89a4e81ac3637cb0a3cdbbe','shares',-1,'2026-01-24 19:03:57',NULL),('2026-01-23 19:03:57.615831',NULL,'2026-01-23 19:03:57.641496',496,496,'fd03ddd06d374af6aaab5af51dd14875','6dbb2847-13d4-47ab-bb89-59230e89dad2',149,'5ed6311cb89a4e81ac3637cb0a3cdbbe','gigabytes',-1,'2026-01-24 19:03:57',NULL),('2026-01-23 19:03:57.633151',NULL,'2026-01-23 19:03:57.641496',497,497,NULL,'b1d0961d-0736-46d1-8234-4962784ebafb',150,'5ed6311cb89a4e81ac3637cb0a3cdbbe','shares',-1,'2026-01-24 19:03:57','d4340069-92a0-40b1-9a2d-4931749a22be'),('2026-01-23 19:03:57.633960',NULL,'2026-01-23 19:03:57.641496',498,498,NULL,'fd771bbf-b7a4-4a76-a2c7-bda2ab33e539',151,'5ed6311cb89a4e81ac3637cb0a3cdbbe','gigabytes',-1,'2026-01-24 19:03:57','d4340069-92a0-40b1-9a2d-4931749a22be'),('2026-01-23 19:03:59.953644',NULL,'2026-01-23 19:04:00.002460',499,499,'2fbff2750c964489941186e6647353bd','2853888f-aaac-4488-8b61-03138fcafd24',127,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',-1,'2026-01-24 19:03:59',NULL),('2026-01-23 19:03:59.957173',NULL,'2026-01-23 19:04:00.002460',500,500,'2fbff2750c964489941186e6647353bd','cbabdced-7b71-48b7-a4be-a14b14d6988a',128,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',-1,'2026-01-24 19:03:59',NULL),('2026-01-23 19:03:59.991848',NULL,'2026-01-23 19:04:00.002460',501,501,NULL,'edbf06b1-9280-4a57-a839-8e646ac2eab0',162,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',-1,'2026-01-24 19:03:59','91c26460-9fbd-4287-97cf-8d78828587a3'),('2026-01-23 19:03:59.992688',NULL,'2026-01-23 19:04:00.002460',502,502,NULL,'7faaa789-11a2-48a6-9a26-1d735e43e64e',163,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',-1,'2026-01-24 19:03:59','91c26460-9fbd-4287-97cf-8d78828587a3'),('2026-01-23 19:04:00.219665',NULL,'2026-01-23 19:04:00.287155',503,503,'2fbff2750c964489941186e6647353bd','94b92ae7-41fc-4d08-b751-d189a7c663ea',127,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',-1,'2026-01-24 19:04:00',NULL),('2026-01-23 19:04:00.220486',NULL,'2026-01-23 19:04:00.287155',504,504,'2fbff2750c964489941186e6647353bd','3d09ed93-6b51-4e72-962c-56546ab25f1c',128,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',-1,'2026-01-24 19:04:00',NULL),('2026-01-23 19:04:00.270442',NULL,'2026-01-23 19:04:00.287155',505,505,NULL,'7ab9e91c-98b5-4659-bc0a-d3885247faf0',160,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',-1,'2026-01-24 19:04:00','e9d1bb70-adca-4093-9b6e-5c2f0f61fbea'),('2026-01-23 19:04:00.271329',NULL,'2026-01-23 19:04:00.287155',506,506,NULL,'abe1a5f9-13c5-4676-af6b-d48933b07182',161,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',-1,'2026-01-24 19:04:00','e9d1bb70-adca-4093-9b6e-5c2f0f61fbea'),('2026-01-23 19:04:00.529896',NULL,'2026-01-23 19:04:00.574113',507,507,'2fbff2750c964489941186e6647353bd','40c8c921-1186-462b-97c7-f82e31b46aa3',127,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',1,'2026-01-24 19:04:00',NULL),('2026-01-23 19:04:00.530968',NULL,'2026-01-23 19:04:00.574113',508,508,'2fbff2750c964489941186e6647353bd','e2d6ed5e-c5d0-4741-b596-c6b720075c82',128,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',1,'2026-01-24 19:04:00',NULL),('2026-01-23 19:04:00.544627',NULL,'2026-01-23 19:04:00.574113',509,509,NULL,'cc829d0d-7841-4ffd-8bf9-ac998651c8c7',164,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',1,'2026-01-24 19:04:00','b1e1b985-0ef4-4803-84b5-18474a1939bf'),('2026-01-23 19:04:00.546256',NULL,'2026-01-23 19:04:00.574113',510,510,NULL,'0accaaae-b7ec-43b1-b3da-61b057a196e8',165,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',1,'2026-01-24 19:04:00','b1e1b985-0ef4-4803-84b5-18474a1939bf'),('2026-01-23 19:04:01.322476',NULL,'2026-01-23 19:04:01.345366',511,511,'fd03ddd06d374af6aaab5af51dd14875','ff6da823-2809-48e7-8088-9a5b64cc2e6c',148,'5ed6311cb89a4e81ac3637cb0a3cdbbe','shares',-1,'2026-01-24 19:04:01',NULL),('2026-01-23 19:04:01.324716',NULL,'2026-01-23 19:04:01.345366',512,512,'fd03ddd06d374af6aaab5af51dd14875','2bf236f5-bc84-4ad8-b470-f9f92d6299d8',149,'5ed6311cb89a4e81ac3637cb0a3cdbbe','gigabytes',-1,'2026-01-24 19:04:01',NULL),('2026-01-23 19:04:01.335848',NULL,'2026-01-23 19:04:01.345366',513,513,NULL,'b73393a4-20a4-4499-aefc-6870cf0a10ba',150,'5ed6311cb89a4e81ac3637cb0a3cdbbe','shares',-1,'2026-01-24 19:04:01','d4340069-92a0-40b1-9a2d-4931749a22be'),('2026-01-23 19:04:01.336893',NULL,'2026-01-23 19:04:01.345366',514,514,NULL,'96316105-6f74-4cc5-b3b7-b667c5106cd9',151,'5ed6311cb89a4e81ac3637cb0a3cdbbe','gigabytes',-1,'2026-01-24 19:04:01','d4340069-92a0-40b1-9a2d-4931749a22be'),('2026-01-23 19:04:04.350618',NULL,'2026-01-23 19:04:04.379609',515,515,'2fbff2750c964489941186e6647353bd','dfed5adc-7896-42ac-b1f4-a47051e3e3ec',127,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',-1,'2026-01-24 19:04:04',NULL),('2026-01-23 19:04:04.351350',NULL,'2026-01-23 19:04:04.379609',516,516,'2fbff2750c964489941186e6647353bd','cdeec4ea-4ea6-4a2e-adaa-42ebfb0a6f4f',128,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',-1,'2026-01-24 19:04:04',NULL),('2026-01-23 19:04:04.365254',NULL,'2026-01-23 19:04:04.379609',517,517,NULL,'bc4e45df-8af4-44b6-8094-25ffcb240523',164,'08f0ac3daf4849ccbfe15d2f731f4f1f','shares',-1,'2026-01-24 19:04:04','b1e1b985-0ef4-4803-84b5-18474a1939bf'),('2026-01-23 19:04:04.366002',NULL,'2026-01-23 19:04:04.379609',518,518,NULL,'f8de3cb0-73d2-404d-9d94-2eefe07fc704',165,'08f0ac3daf4849ccbfe15d2f731f4f1f','gigabytes',-1,'2026-01-24 19:04:04','b1e1b985-0ef4-4803-84b5-18474a1939bf'),('2026-01-23 19:04:04.692220',NULL,'2026-01-23 19:04:04.721008',519,519,'fd03ddd06d374af6aaab5af51dd14875','9766489c-a11f-4b84-b5ec-a5b52a4d671d',148,'5ed6311cb89a4e81ac3637cb0a3cdbbe','shares',-1,'2026-01-24 19:04:04',NULL),('2026-01-23 19:04:04.693395',NULL,'2026-01-23 19:04:04.721008',520,520,'fd03ddd06d374af6aaab5af51dd14875','ee92918d-ccdc-46a7-ae25-eb9fac6de4f3',149,'5ed6311cb89a4e81ac3637cb0a3cdbbe','gigabytes',-1,'2026-01-24 19:04:04',NULL),('2026-01-23 19:04:04.705646',NULL,'2026-01-23 19:04:04.721008',521,521,NULL,'b19ec6b1-e449-4e99-9fcf-a5194f48edc5',150,'5ed6311cb89a4e81ac3637cb0a3cdbbe','shares',-1,'2026-01-24 19:04:04','d4340069-92a0-40b1-9a2d-4931749a22be'),('2026-01-23 19:04:04.708348',NULL,'2026-01-23 19:04:04.721008',522,522,NULL,'c6882f42-c52c-4390-801e-6650c542c8c5',151,'5ed6311cb89a4e81ac3637cb0a3cdbbe','gigabytes',-1,'2026-01-24 19:04:04','d4340069-92a0-40b1-9a2d-4931749a22be'),('2026-01-23 19:04:08.076149',NULL,'2026-01-23 19:04:08.107316',523,523,'fd03ddd06d374af6aaab5af51dd14875','ccb5968c-c8cb-44f1-8c72-32a0c0b9b332',148,'5ed6311cb89a4e81ac3637cb0a3cdbbe','shares',-1,'2026-01-24 19:04:08',NULL),('2026-01-23 19:04:08.076870',NULL,'2026-01-23 19:04:08.107316',524,524,'fd03ddd06d374af6aaab5af51dd14875','e27b9461-cb93-4994-a3bb-a4b06f6b1a2c',149,'5ed6311cb89a4e81ac3637cb0a3cdbbe','gigabytes',-1,'2026-01-24 19:04:08',NULL),('2026-01-23 19:04:08.087429',NULL,'2026-01-23 19:04:08.107316',525,525,NULL,'462c4270-99e6-4816-9a70-58d8133f42ac',150,'5ed6311cb89a4e81ac3637cb0a3cdbbe','shares',-1,'2026-01-24 19:04:08','d4340069-92a0-40b1-9a2d-4931749a22be'),('2026-01-23 19:04:08.088152',NULL,'2026-01-23 19:04:08.107316',526,526,NULL,'b633717b-b305-4951-aa2f-df8d40934308',151,'5ed6311cb89a4e81ac3637cb0a3cdbbe','gigabytes',-1,'2026-01-24 19:04:08','d4340069-92a0-40b1-9a2d-4931749a22be'),('2026-01-23 19:04:20.976537',NULL,'2026-01-23 19:04:21.006871',527,527,'2b6dadb05d14498fb74d0e3ed633c1c2','2b8ae0f3-4e23-4a3f-8c94-14c9b2a93290',156,'182b21a4575a4acc866fcdd5f8991734','shares',-1,'2026-01-24 19:04:20',NULL),('2026-01-23 19:04:20.977335',NULL,'2026-01-23 19:04:21.006871',528,528,'2b6dadb05d14498fb74d0e3ed633c1c2','a0c6c6be-8bf7-46c8-9e41-4dcc35c1bc55',157,'182b21a4575a4acc866fcdd5f8991734','gigabytes',-1,'2026-01-24 19:04:20',NULL),('2026-01-23 19:04:20.984457',NULL,'2026-01-23 19:04:21.006871',529,529,NULL,'14aeb6e1-7cc1-46eb-8115-e1d6f806349d',158,'182b21a4575a4acc866fcdd5f8991734','shares',-1,'2026-01-24 19:04:20','fc3dea75-7a38-41a5-9a53-1370369a0c3e'),('2026-01-23 19:04:20.985239',NULL,'2026-01-23 19:04:21.006871',530,530,NULL,'1124f675-4e19-4959-af9c-18fb034d21f7',159,'182b21a4575a4acc866fcdd5f8991734','gigabytes',-1,'2026-01-24 19:04:20','fc3dea75-7a38-41a5-9a53-1370369a0c3e'),('2026-01-23 19:04:22.517470',NULL,'2026-01-23 19:04:22.583921',531,531,'97e5b5856f774106be398a432c1a2e3a','7e6e1f0b-74bf-4c18-a9cb-745d7ee387ec',166,'e523821f05f24ee683a3bef9e5423573','shares',1,'2026-01-24 19:04:22',NULL),('2026-01-23 19:04:22.518775',NULL,'2026-01-23 19:04:22.583921',532,532,'97e5b5856f774106be398a432c1a2e3a','9f356eb4-b736-49c6-8209-07de52e58887',167,'e523821f05f24ee683a3bef9e5423573','gigabytes',1,'2026-01-24 19:04:22',NULL),('2026-01-23 19:04:22.556698',NULL,'2026-01-23 19:04:22.583921',533,533,NULL,'1fb97d77-88af-4b1d-9ce5-0ecadb45aefe',168,'e523821f05f24ee683a3bef9e5423573','shares',1,'2026-01-24 19:04:22','d7fe3112-4905-44e0-a7a6-b013dde8491c'),('2026-01-23 19:04:22.557994',NULL,'2026-01-23 19:04:22.583921',534,534,NULL,'048cfa9d-6e98-4e06-8d61-397dd131cd9c',169,'e523821f05f24ee683a3bef9e5423573','gigabytes',1,'2026-01-24 19:04:22','d7fe3112-4905-44e0-a7a6-b013dde8491c'),('2026-01-23 19:04:26.312643',NULL,'2026-01-23 19:04:26.832732',535,535,'1a04690e8f284aa39ed37e0b6aa7b3ee','5d475dc4-2301-4710-a4a1-9fb504517fad',170,'5d979c3ed74a492981b806cb6f7d0021','shares',1,'2026-01-24 19:04:26',NULL),('2026-01-23 19:04:26.313605',NULL,'2026-01-23 19:04:26.832732',536,536,'1a04690e8f284aa39ed37e0b6aa7b3ee','4a624cb3-be3d-44b8-a1d8-8411a003bfe1',171,'5d979c3ed74a492981b806cb6f7d0021','gigabytes',1,'2026-01-24 19:04:26',NULL),('2026-01-23 19:04:26.403008',NULL,'2026-01-23 19:04:26.832732',537,537,NULL,'c4d60ea6-6e48-4d54-9579-fa3f43ee5565',172,'5d979c3ed74a492981b806cb6f7d0021','shares',1,'2026-01-24 19:04:26','d7fe3112-4905-44e0-a7a6-b013dde8491c'),('2026-01-23 19:04:26.404052',NULL,'2026-01-23 19:04:26.832732',538,538,NULL,'7459570f-e880-491c-b7d0-d37b428668b4',173,'5d979c3ed74a492981b806cb6f7d0021','gigabytes',1,'2026-01-24 19:04:26','d7fe3112-4905-44e0-a7a6-b013dde8491c'),('2026-01-23 19:04:30.874071',NULL,'2026-01-23 19:04:30.907870',539,539,'1a04690e8f284aa39ed37e0b6aa7b3ee','f743e7b5-87e3-4c21-b836-6013c806d8de',170,'5d979c3ed74a492981b806cb6f7d0021','shares',-1,'2026-01-24 19:04:30',NULL),('2026-01-23 19:04:30.875958',NULL,'2026-01-23 19:04:30.907870',540,540,'1a04690e8f284aa39ed37e0b6aa7b3ee','9e6f3860-f1b9-4cf7-8c02-1047b3e1a2bf',171,'5d979c3ed74a492981b806cb6f7d0021','gigabytes',-1,'2026-01-24 19:04:30',NULL),('2026-01-23 19:04:30.888966',NULL,'2026-01-23 19:04:30.907870',541,541,NULL,'aa08e1d3-94c6-4e34-8332-0a318dfe7061',172,'5d979c3ed74a492981b806cb6f7d0021','shares',-1,'2026-01-24 19:04:30','d7fe3112-4905-44e0-a7a6-b013dde8491c'),('2026-01-23 19:04:30.892864',NULL,'2026-01-23 19:04:30.907870',542,542,NULL,'78e7ee6f-8155-45d7-a511-f6df66b015a6',173,'5d979c3ed74a492981b806cb6f7d0021','gigabytes',-1,'2026-01-24 19:04:30','d7fe3112-4905-44e0-a7a6-b013dde8491c'),('2026-01-23 19:04:34.706023',NULL,'2026-01-23 19:04:34.739430',543,543,'97e5b5856f774106be398a432c1a2e3a','94b686f1-9b76-4832-9724-99e1c5913629',166,'e523821f05f24ee683a3bef9e5423573','shares',-1,'2026-01-24 19:04:34',NULL),('2026-01-23 19:04:34.709975',NULL,'2026-01-23 19:04:34.739430',544,544,'97e5b5856f774106be398a432c1a2e3a','7153250a-d1fd-4732-99cc-b13fd2f74cb1',167,'e523821f05f24ee683a3bef9e5423573','gigabytes',-1,'2026-01-24 19:04:34',NULL),('2026-01-23 19:04:34.718732',NULL,'2026-01-23 19:04:34.739430',545,545,NULL,'f6f0ffce-1114-453d-98d1-d20a6b9adbfc',168,'e523821f05f24ee683a3bef9e5423573','shares',-1,'2026-01-24 19:04:34','d7fe3112-4905-44e0-a7a6-b013dde8491c'),('2026-01-23 19:04:34.719982',NULL,'2026-01-23 19:04:34.739430',546,546,NULL,'dcda4029-6760-41a0-918f-3e619a2648ae',169,'e523821f05f24ee683a3bef9e5423573','gigabytes',-1,'2026-01-24 19:04:34','d7fe3112-4905-44e0-a7a6-b013dde8491c'),('2026-01-23 19:04:37.305362',NULL,'2026-01-23 19:04:38.005116',547,547,'0cdc36ee00844d51a9bfb80f7be4a983','beaaa7ef-8862-4073-bd7e-d9a88be07612',174,'6e81efcadc1a4938a53855b68f0acfd2','shares',1,'2026-01-24 19:04:37',NULL),('2026-01-23 19:04:37.306459',NULL,'2026-01-23 19:04:38.005116',548,548,'0cdc36ee00844d51a9bfb80f7be4a983','af67ccc5-0d88-4a1c-b832-75bd41b53a3f',175,'6e81efcadc1a4938a53855b68f0acfd2','gigabytes',1,'2026-01-24 19:04:37',NULL),('2026-01-23 19:04:37.754555',NULL,'2026-01-23 19:04:38.101079',549,549,'1a04690e8f284aa39ed37e0b6aa7b3ee','801ab648-d93e-428d-bd89-7412232a7523',170,'5d979c3ed74a492981b806cb6f7d0021','shares',1,'2026-01-24 19:04:37',NULL),('2026-01-23 19:04:37.755850',NULL,'2026-01-23 19:04:38.101079',550,550,'1a04690e8f284aa39ed37e0b6aa7b3ee','29da97cd-03af-4361-a5c3-28508f468864',171,'5d979c3ed74a492981b806cb6f7d0021','gigabytes',1,'2026-01-24 19:04:37',NULL),('2026-01-23 19:04:37.957456',NULL,'2026-01-23 19:04:38.005116',551,551,NULL,'5a6568e5-695c-4a00-9bb7-1fa59798b369',176,'6e81efcadc1a4938a53855b68f0acfd2','shares',1,'2026-01-24 19:04:37','21de215f-d5bc-482a-9a75-67ea712434b1'),('2026-01-23 19:04:37.958583',NULL,'2026-01-23 19:04:38.005116',552,552,NULL,'3d515c0c-c415-4018-ade6-e73394d12b4e',177,'6e81efcadc1a4938a53855b68f0acfd2','gigabytes',1,'2026-01-24 19:04:37','21de215f-d5bc-482a-9a75-67ea712434b1'),('2026-01-23 19:04:37.988753',NULL,'2026-01-23 19:04:38.101079',553,553,NULL,'056bf0d3-4a30-489f-b5f3-b82da0a52e9b',172,'5d979c3ed74a492981b806cb6f7d0021','shares',1,'2026-01-24 19:04:37','d7fe3112-4905-44e0-a7a6-b013dde8491c'),('2026-01-23 19:04:37.991296',NULL,'2026-01-23 19:04:38.101079',554,554,NULL,'ee7e5c2e-3a2c-454b-87ed-51f568c94c20',173,'5d979c3ed74a492981b806cb6f7d0021','gigabytes',1,'2026-01-24 19:04:37','d7fe3112-4905-44e0-a7a6-b013dde8491c'),('2026-01-23 19:04:41.811914',NULL,'2026-01-23 19:04:42.962237',555,555,'0cdc36ee00844d51a9bfb80f7be4a983','7004d1b5-670e-43c8-8dda-e0c5fb871b4a',174,'6e81efcadc1a4938a53855b68f0acfd2','shares',1,'2026-01-24 19:04:41',NULL),('2026-01-23 19:04:41.813623',NULL,'2026-01-23 19:04:42.962237',556,556,'0cdc36ee00844d51a9bfb80f7be4a983','d8f37f1d-ed4b-47ab-af65-bdfd6520a598',175,'6e81efcadc1a4938a53855b68f0acfd2','gigabytes',1,'2026-01-24 19:04:41',NULL),('2026-01-23 19:04:42.188612',NULL,'2026-01-23 19:04:42.962237',557,557,NULL,'d9208179-f367-484a-9147-1f98724465d9',176,'6e81efcadc1a4938a53855b68f0acfd2','shares',1,'2026-01-24 19:04:41','21de215f-d5bc-482a-9a75-67ea712434b1'),('2026-01-23 19:04:42.190618',NULL,'2026-01-23 19:04:42.962237',558,558,NULL,'618a1d50-763f-414c-b0c6-7204140528af',177,'6e81efcadc1a4938a53855b68f0acfd2','gigabytes',1,'2026-01-24 19:04:41','21de215f-d5bc-482a-9a75-67ea712434b1'),('2026-01-23 19:04:43.432258',NULL,'2026-01-23 19:04:43.656035',559,559,'1a04690e8f284aa39ed37e0b6aa7b3ee','00c9869a-08b5-45a1-a0be-f4c0a8aceeaa',170,'5d979c3ed74a492981b806cb6f7d0021','shares',-1,'2026-01-24 19:04:43',NULL),('2026-01-23 19:04:43.436588',NULL,'2026-01-23 19:04:43.656035',560,560,'1a04690e8f284aa39ed37e0b6aa7b3ee','bd0aa5b1-54a0-4306-81b3-9f1389aea7fe',171,'5d979c3ed74a492981b806cb6f7d0021','gigabytes',-1,'2026-01-24 19:04:43',NULL),('2026-01-23 19:04:43.566786',NULL,'2026-01-23 19:04:43.656035',561,561,NULL,'0cbbbd08-9eba-479f-a861-42ff2f0459f9',172,'5d979c3ed74a492981b806cb6f7d0021','shares',-1,'2026-01-24 19:04:43','d7fe3112-4905-44e0-a7a6-b013dde8491c'),('2026-01-23 19:04:43.568142',NULL,'2026-01-23 19:04:43.656035',562,562,NULL,'64f2725b-e305-4c08-a80c-04a08f954686',173,'5d979c3ed74a492981b806cb6f7d0021','gigabytes',-1,'2026-01-24 19:04:43','d7fe3112-4905-44e0-a7a6-b013dde8491c'),('2026-01-23 19:04:48.213330',NULL,'2026-01-23 19:04:48.389294',563,563,'0cdc36ee00844d51a9bfb80f7be4a983','f5aa0282-bd54-4946-bf26-7348330126fc',174,'6e81efcadc1a4938a53855b68f0acfd2','shares',-1,'2026-01-24 19:04:48',NULL),('2026-01-23 19:04:48.216541',NULL,'2026-01-23 19:04:48.389294',564,564,'0cdc36ee00844d51a9bfb80f7be4a983','1db8ebd5-3188-45c4-8319-d1ad78e56c61',175,'6e81efcadc1a4938a53855b68f0acfd2','gigabytes',-1,'2026-01-24 19:04:48',NULL),('2026-01-23 19:04:48.344475',NULL,'2026-01-23 19:04:48.389294',565,565,NULL,'3bac697f-f865-4adf-9724-91060fbad6ab',176,'6e81efcadc1a4938a53855b68f0acfd2','shares',-1,'2026-01-24 19:04:48','21de215f-d5bc-482a-9a75-67ea712434b1'),('2026-01-23 19:04:48.345962',NULL,'2026-01-23 19:04:48.389294',566,566,NULL,'5c69c113-2665-4a00-b80e-eaeba2d47bbd',177,'6e81efcadc1a4938a53855b68f0acfd2','gigabytes',-1,'2026-01-24 19:04:48','21de215f-d5bc-482a-9a75-67ea712434b1'),('2026-01-23 19:04:52.066224',NULL,'2026-01-23 19:04:52.112753',567,567,'eeabb00740a8442eb5cb3065882b8ff9','3df60fe5-75a1-4672-9506-2fa284bd99b5',178,'6333b89cc67749f896506316d34639f6','shares',1,'2026-01-24 19:04:52',NULL),('2026-01-23 19:04:52.067734',NULL,'2026-01-23 19:04:52.112753',568,568,'eeabb00740a8442eb5cb3065882b8ff9','d5093a1a-b7a9-4236-9f8c-fa329725ba47',179,'6333b89cc67749f896506316d34639f6','gigabytes',1,'2026-01-24 19:04:52',NULL),('2026-01-23 19:04:52.080241',NULL,'2026-01-23 19:04:52.112753',569,569,NULL,'f50e8640-8622-4697-ae1e-c02d26e7ccb9',180,'6333b89cc67749f896506316d34639f6','shares',1,'2026-01-24 19:04:52','d75ba714-c404-43a1-a9ef-110a3d3d2fa3'),('2026-01-23 19:04:52.081695',NULL,'2026-01-23 19:04:52.112753',570,570,NULL,'a4c25f62-e4e4-4a91-a9e1-069fcc52adb7',181,'6333b89cc67749f896506316d34639f6','gigabytes',1,'2026-01-24 19:04:52','d75ba714-c404-43a1-a9ef-110a3d3d2fa3'),('2026-01-23 19:04:52.094988',NULL,'2026-01-23 19:04:52.116995',571,571,'0cdc36ee00844d51a9bfb80f7be4a983','ed67ec27-05d7-4e55-b5f0-b573b01a5fac',174,'6e81efcadc1a4938a53855b68f0acfd2','shares',-1,'2026-01-24 19:04:51',NULL),('2026-01-23 19:04:52.096701',NULL,'2026-01-23 19:04:52.116995',572,572,'0cdc36ee00844d51a9bfb80f7be4a983','c8b85770-48f1-4e1e-9b3b-58613756de4b',175,'6e81efcadc1a4938a53855b68f0acfd2','gigabytes',-1,'2026-01-24 19:04:51',NULL),('2026-01-23 19:04:52.104757',NULL,'2026-01-23 19:04:52.116995',573,573,NULL,'32de4c95-567b-4707-986f-e2072e98013f',176,'6e81efcadc1a4938a53855b68f0acfd2','shares',-1,'2026-01-24 19:04:51','21de215f-d5bc-482a-9a75-67ea712434b1'),('2026-01-23 19:04:52.105687',NULL,'2026-01-23 19:04:52.116995',574,574,NULL,'d495919d-1579-43b0-9c1f-e1018659bd66',177,'6e81efcadc1a4938a53855b68f0acfd2','gigabytes',-1,'2026-01-24 19:04:51','21de215f-d5bc-482a-9a75-67ea712434b1'),('2026-01-23 19:04:55.660515',NULL,'2026-01-23 19:04:56.051342',575,575,'0cdc36ee00844d51a9bfb80f7be4a983','7812c4da-0572-4702-9cc9-f9c76c46618f',182,'6e81efcadc1a4938a53855b68f0acfd2','share_groups',1,'2026-01-24 19:04:55',NULL),('2026-01-23 19:04:57.967594',NULL,'2026-01-23 19:04:58.016213',576,576,'eeabb00740a8442eb5cb3065882b8ff9','b5dfe3bf-28eb-48c9-a6d0-d9d9925fb522',178,'6333b89cc67749f896506316d34639f6','shares',-1,'2026-01-24 19:04:57',NULL),('2026-01-23 19:04:57.968534',NULL,'2026-01-23 19:04:58.016213',577,577,'eeabb00740a8442eb5cb3065882b8ff9','648fe53e-6ae8-4da0-b7cd-7aa919317a24',179,'6333b89cc67749f896506316d34639f6','gigabytes',-1,'2026-01-24 19:04:57',NULL),('2026-01-23 19:04:57.996199',NULL,'2026-01-23 19:04:58.016213',578,578,NULL,'21f3fea0-ec2b-445f-b36e-d5ce9d669729',180,'6333b89cc67749f896506316d34639f6','shares',-1,'2026-01-24 19:04:57','d75ba714-c404-43a1-a9ef-110a3d3d2fa3'),('2026-01-23 19:04:57.997080',NULL,'2026-01-23 19:04:58.016213',579,579,NULL,'cbd456b3-bf31-4870-9a2e-00614baee401',181,'6333b89cc67749f896506316d34639f6','gigabytes',-1,'2026-01-24 19:04:57','d75ba714-c404-43a1-a9ef-110a3d3d2fa3'),('2026-01-23 19:05:00.644675',NULL,'2026-01-23 19:05:02.507105',580,580,'0cdc36ee00844d51a9bfb80f7be4a983','c5e6c146-6b82-484e-8737-dfb2b11bc79f',182,'6e81efcadc1a4938a53855b68f0acfd2','share_groups',-1,'2026-01-24 19:05:00',NULL),('2026-01-23 19:05:02.830956',NULL,'2026-01-23 19:05:02.851250',581,581,'0cdc36ee00844d51a9bfb80f7be4a983','7814cfc4-e062-43b8-aa95-25019062e579',182,'6e81efcadc1a4938a53855b68f0acfd2','share_groups',1,'2026-01-24 19:05:02',NULL),('2026-01-23 19:05:06.354680',NULL,'2026-01-23 19:05:06.365513',582,582,'0cdc36ee00844d51a9bfb80f7be4a983','9ea2150f-d2a7-4a8f-8cfa-e0b745fe6e0a',182,'6e81efcadc1a4938a53855b68f0acfd2','share_groups',-1,'2026-01-24 19:05:06',NULL),('2026-01-23 19:05:06.790212',NULL,'2026-01-23 19:05:06.828846',583,583,'0cdc36ee00844d51a9bfb80f7be4a983','cbdf0150-90f5-4fb4-aa72-15d621f2fae0',174,'6e81efcadc1a4938a53855b68f0acfd2','shares',1,'2026-01-24 19:05:06',NULL),('2026-01-23 19:05:06.791519',NULL,'2026-01-23 19:05:06.828846',584,584,'0cdc36ee00844d51a9bfb80f7be4a983','fa7119f3-3867-447b-a21e-957f63a42486',175,'6e81efcadc1a4938a53855b68f0acfd2','gigabytes',1,'2026-01-24 19:05:06',NULL),('2026-01-23 19:05:06.799815',NULL,'2026-01-23 19:05:06.828846',585,585,NULL,'62d144b8-0bc0-44be-aeab-ec571cc612d9',176,'6e81efcadc1a4938a53855b68f0acfd2','shares',1,'2026-01-24 19:05:06','21de215f-d5bc-482a-9a75-67ea712434b1'),('2026-01-23 19:05:06.801462',NULL,'2026-01-23 19:05:06.828846',586,586,NULL,'d55e9e00-b545-4f4b-8e6b-d514a6c9960e',177,'6e81efcadc1a4938a53855b68f0acfd2','gigabytes',1,'2026-01-24 19:05:06','21de215f-d5bc-482a-9a75-67ea712434b1'),('2026-01-23 19:05:11.649704',NULL,'2026-01-23 19:05:11.673094',587,587,'0cdc36ee00844d51a9bfb80f7be4a983','c4645032-7374-4c6d-aa66-1f1fab0a7073',174,'6e81efcadc1a4938a53855b68f0acfd2','shares',-1,'2026-01-24 19:05:11',NULL),('2026-01-23 19:05:11.650392',NULL,'2026-01-23 19:05:11.673094',588,588,'0cdc36ee00844d51a9bfb80f7be4a983','203e379b-c18c-43ed-9f83-5180bda0c54d',175,'6e81efcadc1a4938a53855b68f0acfd2','gigabytes',-1,'2026-01-24 19:05:11',NULL),('2026-01-23 19:05:11.659350',NULL,'2026-01-23 19:05:11.673094',589,589,NULL,'4990c466-c2d8-4c66-851d-250c08e35cf9',176,'6e81efcadc1a4938a53855b68f0acfd2','shares',-1,'2026-01-24 19:05:11','21de215f-d5bc-482a-9a75-67ea712434b1'),('2026-01-23 19:05:11.660384',NULL,'2026-01-23 19:05:11.673094',590,590,NULL,'1100e3db-1912-4ef2-b419-ada9de97df60',177,'6e81efcadc1a4938a53855b68f0acfd2','gigabytes',-1,'2026-01-24 19:05:11','21de215f-d5bc-482a-9a75-67ea712434b1'),('2026-01-23 19:05:13.797984',NULL,'2026-01-23 19:05:14.173161',591,591,'4cdaf3be00a843b7aca77970f17d1587','0211005d-dd43-44a7-b905-68dabcf9fde2',183,'8ecf67da29b04bd89431f71cece6e5cf','shares',1,'2026-01-24 19:05:13',NULL),('2026-01-23 19:05:13.799051',NULL,'2026-01-23 19:05:14.173161',592,592,'4cdaf3be00a843b7aca77970f17d1587','dad0ced5-9dba-4f43-b916-21ddf195ad51',184,'8ecf67da29b04bd89431f71cece6e5cf','gigabytes',1,'2026-01-24 19:05:13',NULL),('2026-01-23 19:05:14.051723',NULL,'2026-01-23 19:05:14.173161',593,593,NULL,'1dc3fbd6-4a99-4f6c-96ca-fb56e302de45',185,'8ecf67da29b04bd89431f71cece6e5cf','shares',1,'2026-01-24 19:05:13','e2842727-9db2-48d3-8b3d-2a3115f7f601'),('2026-01-23 19:05:14.054104',NULL,'2026-01-23 19:05:14.173161',594,594,NULL,'50a4ea9e-e2b5-4ff7-997e-341eb03622cc',186,'8ecf67da29b04bd89431f71cece6e5cf','gigabytes',1,'2026-01-24 19:05:13','e2842727-9db2-48d3-8b3d-2a3115f7f601'),('2026-01-23 19:05:15.108062',NULL,'2026-01-23 19:05:15.256528',595,595,'0cdc36ee00844d51a9bfb80f7be4a983','4d045e41-4d11-4f61-91d6-462d62050a81',174,'6e81efcadc1a4938a53855b68f0acfd2','shares',1,'2026-01-24 19:05:15',NULL),('2026-01-23 19:05:15.109242',NULL,'2026-01-23 19:05:15.256528',596,596,'0cdc36ee00844d51a9bfb80f7be4a983','fc81689a-9ba2-49c6-a02e-63588a427119',175,'6e81efcadc1a4938a53855b68f0acfd2','gigabytes',1,'2026-01-24 19:05:15',NULL),('2026-01-23 19:05:15.220882',NULL,'2026-01-23 19:05:15.256528',597,597,NULL,'a2f416e2-03b9-4649-b3f2-fe33da554911',176,'6e81efcadc1a4938a53855b68f0acfd2','shares',1,'2026-01-24 19:05:15','21de215f-d5bc-482a-9a75-67ea712434b1'),('2026-01-23 19:05:15.224007',NULL,'2026-01-23 19:05:15.256528',598,598,NULL,'9d9ec30d-e705-4de3-b93e-5f3f4f58cf21',177,'6e81efcadc1a4938a53855b68f0acfd2','gigabytes',1,'2026-01-24 19:05:15','21de215f-d5bc-482a-9a75-67ea712434b1'),('2026-01-23 19:05:19.795879',NULL,'2026-01-23 19:05:19.905531',599,599,'4cdaf3be00a843b7aca77970f17d1587','24ed861b-938d-4502-a10f-e4e3786d14db',183,'8ecf67da29b04bd89431f71cece6e5cf','shares',-1,'2026-01-24 19:05:19',NULL),('2026-01-23 19:05:19.797525',NULL,'2026-01-23 19:05:19.905531',600,600,'4cdaf3be00a843b7aca77970f17d1587','3c8b7744-cc53-4800-a0bf-d34e48e7089c',184,'8ecf67da29b04bd89431f71cece6e5cf','gigabytes',-1,'2026-01-24 19:05:19',NULL),('2026-01-23 19:05:19.886516',NULL,'2026-01-23 19:05:19.905531',601,601,NULL,'2203aae1-37e7-49d8-8d98-d7f92aeec827',185,'8ecf67da29b04bd89431f71cece6e5cf','shares',-1,'2026-01-24 19:05:19','e2842727-9db2-48d3-8b3d-2a3115f7f601'),('2026-01-23 19:05:19.887800',NULL,'2026-01-23 19:05:19.905531',602,602,NULL,'0878aea0-c9c9-4d74-b439-4dd58fd28234',186,'8ecf67da29b04bd89431f71cece6e5cf','gigabytes',-1,'2026-01-24 19:05:19','e2842727-9db2-48d3-8b3d-2a3115f7f601'),('2026-01-23 19:05:19.916804',NULL,'2026-01-23 19:05:19.980463',603,603,'0cdc36ee00844d51a9bfb80f7be4a983','2a435949-b856-4b3d-b943-842778dcbd65',174,'6e81efcadc1a4938a53855b68f0acfd2','shares',-1,'2026-01-24 19:05:19',NULL),('2026-01-23 19:05:19.917828',NULL,'2026-01-23 19:05:19.980463',604,604,'0cdc36ee00844d51a9bfb80f7be4a983','3174395c-aa24-4ce2-af1e-36d608b2fd1f',175,'6e81efcadc1a4938a53855b68f0acfd2','gigabytes',-1,'2026-01-24 19:05:19',NULL),('2026-01-23 19:05:19.970687',NULL,'2026-01-23 19:05:19.980463',605,605,NULL,'0233553b-6cb8-4488-9b03-d15b0bae83ca',176,'6e81efcadc1a4938a53855b68f0acfd2','shares',-1,'2026-01-24 19:05:19','21de215f-d5bc-482a-9a75-67ea712434b1'),('2026-01-23 19:05:19.971490',NULL,'2026-01-23 19:05:19.980463',606,606,NULL,'70482948-e5d9-4cc5-b65c-9fb83785a0cc',177,'6e81efcadc1a4938a53855b68f0acfd2','gigabytes',-1,'2026-01-24 19:05:19','21de215f-d5bc-482a-9a75-67ea712434b1'),('2026-01-23 19:05:31.737624',NULL,'2026-01-23 19:05:31.763956',607,607,'767061f8596f444f8e3ea7f80967fec5','7eb21bb7-5cd8-413a-b12c-ad70ceefb307',187,'b17f281119ff44cbbbf9816794032547','share_networks',1,'2026-01-24 19:05:31',NULL),('2026-01-23 19:05:32.635122',NULL,'2026-01-23 19:05:32.642042',608,608,'767061f8596f444f8e3ea7f80967fec5','b39719e3-3edf-419d-ad0b-84706cf7070f',187,'b17f281119ff44cbbbf9816794032547','share_networks',-1,'2026-01-24 19:05:32',NULL),('2026-01-23 19:05:32.884437',NULL,'2026-01-23 19:05:32.920102',609,609,'767061f8596f444f8e3ea7f80967fec5','e1ad1268-a013-4ae8-8f8f-417203c4dc40',187,'b17f281119ff44cbbbf9816794032547','share_networks',1,'2026-01-24 19:05:32',NULL),('2026-01-23 19:05:32.885086',NULL,'2026-01-23 19:05:32.933331',610,610,'0ee3b61db0254b40bc85214e7d348538','c7f8bc39-6ab6-4156-9cd4-a082344c0ee3',188,'3fb8d4a8278546deacbbb6d960f5b0bb','shares',1,'2026-01-24 19:05:32',NULL),('2026-01-23 19:05:32.886707',NULL,'2026-01-23 19:05:32.933331',611,611,'0ee3b61db0254b40bc85214e7d348538','a75970b0-39ba-4ef1-a7ef-8b748a16c7ce',189,'3fb8d4a8278546deacbbb6d960f5b0bb','gigabytes',1,'2026-01-24 19:05:32',NULL),('2026-01-23 19:05:32.899832',NULL,'2026-01-23 19:05:32.933331',612,612,NULL,'4d0234d8-5bff-4ac9-a033-2f22cf0b07e6',190,'3fb8d4a8278546deacbbb6d960f5b0bb','shares',1,'2026-01-24 19:05:32','52b6d957-ef7a-4cb1-b863-d97f55c93c1a'),('2026-01-23 19:05:32.911119',NULL,'2026-01-23 19:05:32.933331',613,613,NULL,'0f47e821-5655-4c99-9c00-6e8002ee776f',191,'3fb8d4a8278546deacbbb6d960f5b0bb','gigabytes',1,'2026-01-24 19:05:32','52b6d957-ef7a-4cb1-b863-d97f55c93c1a'),('2026-01-23 19:05:33.620670',NULL,'2026-01-23 19:05:33.627814',614,614,'767061f8596f444f8e3ea7f80967fec5','80080bb9-4554-4635-b9f6-72bce6579272',187,'b17f281119ff44cbbbf9816794032547','share_networks',-1,'2026-01-24 19:05:33',NULL),('2026-01-23 19:05:33.857846',NULL,'2026-01-23 19:05:33.887703',615,615,'767061f8596f444f8e3ea7f80967fec5','6693600f-1888-4879-99b8-a66fe7c8947e',187,'b17f281119ff44cbbbf9816794032547','share_networks',1,'2026-01-24 19:05:33',NULL),('2026-01-23 19:05:34.527491',NULL,'2026-01-23 19:05:34.583622',616,616,'7a1a35011363435a8a558e98e87b8831','52c682c4-a348-42b5-971f-410db8315a82',192,'ef50bedea4bc4cfd892c55fa7305015f','shares',1,'2026-01-24 19:05:34',NULL),('2026-01-23 19:05:34.529562',NULL,'2026-01-23 19:05:34.583622',617,617,'7a1a35011363435a8a558e98e87b8831','44da819c-9180-48b4-ba19-a89c312ac1b3',193,'ef50bedea4bc4cfd892c55fa7305015f','gigabytes',1,'2026-01-24 19:05:34',NULL),('2026-01-23 19:05:34.543648',NULL,'2026-01-23 19:05:34.583622',618,618,NULL,'3c4190da-d31c-4101-99d5-f321662e7fc9',194,'ef50bedea4bc4cfd892c55fa7305015f','shares',1,'2026-01-24 19:05:34','4b614781-282f-426a-a8da-c9980601f345'),('2026-01-23 19:05:34.544922',NULL,'2026-01-23 19:05:34.583622',619,619,NULL,'8fa53b1d-3e33-4b55-a406-a6734b0771a3',195,'ef50bedea4bc4cfd892c55fa7305015f','gigabytes',1,'2026-01-24 19:05:34','4b614781-282f-426a-a8da-c9980601f345'),('2026-01-23 19:05:34.586147',NULL,'2026-01-23 19:05:34.591933',620,620,'767061f8596f444f8e3ea7f80967fec5','81667734-29f9-4ca6-acfb-39dd9a917804',187,'b17f281119ff44cbbbf9816794032547','share_networks',-1,'2026-01-24 19:05:34',NULL),('2026-01-23 19:05:36.414852',NULL,'2026-01-23 19:05:36.501707',621,621,'0ee3b61db0254b40bc85214e7d348538','3706c874-df53-4475-bd0d-1c541776d5e2',196,'3fb8d4a8278546deacbbb6d960f5b0bb','snapshots',1,'2026-01-24 19:05:36',NULL),('2026-01-23 19:05:36.416165',NULL,'2026-01-23 19:05:36.501707',622,622,'0ee3b61db0254b40bc85214e7d348538','19921656-9f03-4585-87cd-44d30dc86cd1',197,'3fb8d4a8278546deacbbb6d960f5b0bb','snapshot_gigabytes',1,'2026-01-24 19:05:36',NULL),('2026-01-23 19:05:36.431583',NULL,'2026-01-23 19:05:36.501707',623,623,NULL,'3d600bb3-8fa5-43e8-9c86-9491057cc913',198,'3fb8d4a8278546deacbbb6d960f5b0bb','snapshots',1,'2026-01-24 19:05:36','52b6d957-ef7a-4cb1-b863-d97f55c93c1a'),('2026-01-23 19:05:36.433032',NULL,'2026-01-23 19:05:36.501707',624,624,NULL,'32fd4bb0-9222-4e0d-9e80-de1bd640353e',199,'3fb8d4a8278546deacbbb6d960f5b0bb','snapshot_gigabytes',1,'2026-01-24 19:05:36','52b6d957-ef7a-4cb1-b863-d97f55c93c1a'),('2026-01-23 19:05:39.307940',NULL,'2026-01-23 19:05:39.426378',625,625,'7a1a35011363435a8a558e98e87b8831','6f0d1bce-b6fc-4182-82a3-97f5801fd5b4',192,'ef50bedea4bc4cfd892c55fa7305015f','shares',1,'2026-01-24 19:05:39',NULL),('2026-01-23 19:05:39.310023',NULL,'2026-01-23 19:05:39.426378',626,626,'7a1a35011363435a8a558e98e87b8831','6c5c145e-b9fd-4188-9c57-f3fc9aa9a6ed',193,'ef50bedea4bc4cfd892c55fa7305015f','gigabytes',1,'2026-01-24 19:05:39',NULL),('2026-01-23 19:05:39.337825',NULL,'2026-01-23 19:05:39.426378',627,627,NULL,'01049801-66c4-4736-bd5e-3e2dc275460d',194,'ef50bedea4bc4cfd892c55fa7305015f','shares',1,'2026-01-24 19:05:39','4b614781-282f-426a-a8da-c9980601f345'),('2026-01-23 19:05:39.339124',NULL,'2026-01-23 19:05:39.426378',628,628,NULL,'b58979e8-b13f-4915-9d54-0f0eb62465b6',195,'ef50bedea4bc4cfd892c55fa7305015f','gigabytes',1,'2026-01-24 19:05:39','4b614781-282f-426a-a8da-c9980601f345'),('2026-01-23 19:05:41.169777',NULL,'2026-01-23 19:05:41.200475',629,629,'9c4042b5b9c640f89f2cced6d4f42a9b','9ab5249f-c82d-4319-b2e1-1b17896b06da',200,'283b89301a234374a4dbf7307759750d','share_networks',1,'2026-01-24 19:05:41',NULL),('2026-01-23 19:05:42.333508',NULL,'2026-01-23 19:05:43.117957',630,630,'9c4042b5b9c640f89f2cced6d4f42a9b','16bf7a6f-98f5-4a8b-9453-737fcb5bab65',200,'283b89301a234374a4dbf7307759750d','share_networks',1,'2026-01-24 19:05:42',NULL),('2026-01-23 19:05:43.090885',NULL,'2026-01-23 19:05:43.305030',631,631,'0ee3b61db0254b40bc85214e7d348538','2e9b43a8-5684-4578-82d4-fdc65557e653',196,'3fb8d4a8278546deacbbb6d960f5b0bb','snapshots',-1,'2026-01-24 19:05:41',NULL),('2026-01-23 19:05:43.091840',NULL,'2026-01-23 19:05:43.305030',632,632,'0ee3b61db0254b40bc85214e7d348538','9feb537d-bd0a-4b10-a62e-0dc3969829b4',197,'3fb8d4a8278546deacbbb6d960f5b0bb','snapshot_gigabytes',-1,'2026-01-24 19:05:41',NULL),('2026-01-23 19:05:43.252672',NULL,'2026-01-23 19:05:43.305030',633,633,NULL,'bca6b31b-593a-4051-ad71-43ca32f7113b',198,'3fb8d4a8278546deacbbb6d960f5b0bb','snapshots',-1,'2026-01-24 19:05:41','52b6d957-ef7a-4cb1-b863-d97f55c93c1a'),('2026-01-23 19:05:43.253766',NULL,'2026-01-23 19:05:43.305030',634,634,NULL,'7628e53f-2cda-48cb-9055-cd6159dc0562',199,'3fb8d4a8278546deacbbb6d960f5b0bb','snapshot_gigabytes',-1,'2026-01-24 19:05:41','52b6d957-ef7a-4cb1-b863-d97f55c93c1a'),('2026-01-23 19:05:44.138004',NULL,'2026-01-23 19:05:44.145790',635,635,'9c4042b5b9c640f89f2cced6d4f42a9b','af1052e0-a753-4512-b9e3-c70d77432047',200,'283b89301a234374a4dbf7307759750d','share_networks',-1,'2026-01-24 19:05:44',NULL),('2026-01-23 19:05:44.271318',NULL,'2026-01-23 19:05:44.304470',636,636,'9c4042b5b9c640f89f2cced6d4f42a9b','287f622f-a0ba-4834-8104-9497f458bb1a',200,'283b89301a234374a4dbf7307759750d','share_networks',1,'2026-01-24 19:05:44',NULL),('2026-01-23 19:05:44.925868',NULL,'2026-01-23 19:05:44.933256',637,637,'9c4042b5b9c640f89f2cced6d4f42a9b','17bb9fb6-ad0c-4729-9b27-fa1fa6111fe9',200,'283b89301a234374a4dbf7307759750d','share_networks',-1,'2026-01-24 19:05:44',NULL),('2026-01-23 19:05:46.081462',NULL,'2026-01-23 19:05:46.087545',638,638,'9c4042b5b9c640f89f2cced6d4f42a9b','3135cd3a-1818-4951-b588-3dfbbeb2a07b',200,'283b89301a234374a4dbf7307759750d','share_networks',-1,'2026-01-24 19:05:46',NULL),('2026-01-23 19:05:50.909350',NULL,'2026-01-23 19:05:50.950934',639,639,'0ee3b61db0254b40bc85214e7d348538','b569b008-f41c-4fff-85a7-6d087fdfd1c2',188,'3fb8d4a8278546deacbbb6d960f5b0bb','shares',-1,'2026-01-24 19:05:50',NULL),('2026-01-23 19:05:50.911112',NULL,'2026-01-23 19:05:50.950934',640,640,'0ee3b61db0254b40bc85214e7d348538','a89b447c-a58c-4978-beeb-758037fdcd3d',189,'3fb8d4a8278546deacbbb6d960f5b0bb','gigabytes',-1,'2026-01-24 19:05:50',NULL),('2026-01-23 19:05:50.924093',NULL,'2026-01-23 19:05:50.950934',641,641,NULL,'76e2ada0-bd96-4a32-81f0-b9277660d0a8',190,'3fb8d4a8278546deacbbb6d960f5b0bb','shares',-1,'2026-01-24 19:05:50','52b6d957-ef7a-4cb1-b863-d97f55c93c1a'),('2026-01-23 19:05:50.927403',NULL,'2026-01-23 19:05:50.950934',642,642,NULL,'0e869bdc-a33a-4aad-9dbd-2ac1a77f63f9',191,'3fb8d4a8278546deacbbb6d960f5b0bb','gigabytes',-1,'2026-01-24 19:05:50','52b6d957-ef7a-4cb1-b863-d97f55c93c1a'),('2026-01-23 19:05:53.778820',NULL,'2026-01-23 19:05:54.160352',643,643,'0ee3b61db0254b40bc85214e7d348538','47d2a8d6-e6e1-4a1e-aefb-668d217178c7',188,'3fb8d4a8278546deacbbb6d960f5b0bb','shares',1,'2026-01-24 19:05:53',NULL),('2026-01-23 19:05:53.780031',NULL,'2026-01-23 19:05:54.160352',644,644,'0ee3b61db0254b40bc85214e7d348538','a4b79ecd-9551-4301-bd8e-99e87bcd9d41',189,'3fb8d4a8278546deacbbb6d960f5b0bb','gigabytes',1,'2026-01-24 19:05:53',NULL),('2026-01-23 19:05:53.908636',NULL,'2026-01-23 19:05:54.160352',645,645,NULL,'2100d26a-6be0-47c3-8025-ac7a6e7f3fbe',201,'3fb8d4a8278546deacbbb6d960f5b0bb','shares',1,'2026-01-24 19:05:53','f57d6e7a-ef40-49d3-9e68-6fb5a008c4a4'),('2026-01-23 19:05:53.910087',NULL,'2026-01-23 19:05:54.160352',646,646,NULL,'36cb6e2d-0378-49b3-8d11-028945c5a4d7',202,'3fb8d4a8278546deacbbb6d960f5b0bb','gigabytes',1,'2026-01-24 19:05:53','f57d6e7a-ef40-49d3-9e68-6fb5a008c4a4'),('2026-01-23 19:05:55.376629',NULL,'2026-01-23 19:05:55.420094',647,647,'7a1a35011363435a8a558e98e87b8831','18ac5515-d1b0-4be8-afa8-7a7b5dd0966d',192,'ef50bedea4bc4cfd892c55fa7305015f','shares',-1,'2026-01-24 19:05:55',NULL),('2026-01-23 19:05:55.377626',NULL,'2026-01-23 19:05:55.420094',648,648,'7a1a35011363435a8a558e98e87b8831','a98a667e-f383-4b3d-9582-2e02b6c48780',193,'ef50bedea4bc4cfd892c55fa7305015f','gigabytes',-1,'2026-01-24 19:05:55',NULL),('2026-01-23 19:05:55.395444',NULL,'2026-01-23 19:05:55.420094',649,649,NULL,'f04c725a-7556-4c68-92d9-7fee81d13be6',194,'ef50bedea4bc4cfd892c55fa7305015f','shares',-1,'2026-01-24 19:05:55','4b614781-282f-426a-a8da-c9980601f345'),('2026-01-23 19:05:55.397152',NULL,'2026-01-23 19:05:55.420094',650,650,NULL,'8fc6541b-386f-416b-b0ea-d0646738d33c',195,'ef50bedea4bc4cfd892c55fa7305015f','gigabytes',-1,'2026-01-24 19:05:55','4b614781-282f-426a-a8da-c9980601f345'),('2026-01-23 19:05:56.827516',NULL,'2026-01-23 19:05:57.231256',651,651,'7a1a35011363435a8a558e98e87b8831','1591f271-8e9a-45c5-88ff-15b9ee8f962c',192,'ef50bedea4bc4cfd892c55fa7305015f','shares',1,'2026-01-24 19:05:56',NULL),('2026-01-23 19:05:56.828699',NULL,'2026-01-23 19:05:57.231256',652,652,'7a1a35011363435a8a558e98e87b8831','943328cb-127c-45e3-bbeb-3867cb1ca5e3',193,'ef50bedea4bc4cfd892c55fa7305015f','gigabytes',1,'2026-01-24 19:05:56',NULL),('2026-01-23 19:05:57.063241',NULL,'2026-01-23 19:05:57.231256',653,653,NULL,'b29989d3-1d79-4e17-80f4-45c6d46cb394',194,'ef50bedea4bc4cfd892c55fa7305015f','shares',1,'2026-01-24 19:05:56','4b614781-282f-426a-a8da-c9980601f345'),('2026-01-23 19:05:57.064765',NULL,'2026-01-23 19:05:57.231256',654,654,NULL,'b06fa1b3-4d46-4e36-9fe5-4111b5f40625',195,'ef50bedea4bc4cfd892c55fa7305015f','gigabytes',1,'2026-01-24 19:05:56','4b614781-282f-426a-a8da-c9980601f345'),('2026-01-23 19:05:59.385152',NULL,'2026-01-23 19:05:59.463433',655,655,'0ee3b61db0254b40bc85214e7d348538','6b60660b-7f88-4a97-8c4d-eef61732fc59',188,'3fb8d4a8278546deacbbb6d960f5b0bb','shares',-1,'2026-01-24 19:05:59',NULL),('2026-01-23 19:05:59.385811',NULL,'2026-01-23 19:05:59.463433',656,656,'0ee3b61db0254b40bc85214e7d348538','20563df5-0214-4315-b54b-c46c2eb22fb8',189,'3fb8d4a8278546deacbbb6d960f5b0bb','gigabytes',-1,'2026-01-24 19:05:59',NULL),('2026-01-23 19:05:59.440984',NULL,'2026-01-23 19:05:59.463433',657,657,NULL,'436c2070-a681-4052-b783-8af11d3c1183',201,'3fb8d4a8278546deacbbb6d960f5b0bb','shares',-1,'2026-01-24 19:05:59','f57d6e7a-ef40-49d3-9e68-6fb5a008c4a4'),('2026-01-23 19:05:59.442001',NULL,'2026-01-23 19:05:59.463433',658,658,NULL,'b4587254-adda-473c-b3b8-fb56a3733f1f',202,'3fb8d4a8278546deacbbb6d960f5b0bb','gigabytes',-1,'2026-01-24 19:05:59','f57d6e7a-ef40-49d3-9e68-6fb5a008c4a4'),('2026-01-23 19:06:02.182024',NULL,'2026-01-23 19:06:02.232572',659,659,'0ee3b61db0254b40bc85214e7d348538','99561f2d-1e5f-46d4-baf7-32b224cb8fd9',188,'3fb8d4a8278546deacbbb6d960f5b0bb','shares',1,'2026-01-24 19:06:02',NULL),('2026-01-23 19:06:02.183891',NULL,'2026-01-23 19:06:02.232572',660,660,'0ee3b61db0254b40bc85214e7d348538','78af16ed-14f4-4347-8988-f06722cce4d8',189,'3fb8d4a8278546deacbbb6d960f5b0bb','gigabytes',1,'2026-01-24 19:06:02',NULL),('2026-01-23 19:06:02.200824',NULL,'2026-01-23 19:06:02.232572',661,661,NULL,'e99e5004-e516-41cd-abc4-daae6b60427c',203,'3fb8d4a8278546deacbbb6d960f5b0bb','shares',1,'2026-01-24 19:06:02','a231ee93-b5f1-4fc4-a3d2-0055417021c0'),('2026-01-23 19:06:02.204819',NULL,'2026-01-23 19:06:02.232572',662,662,NULL,'f8536b6a-3c5b-42ea-8449-8907e523bf49',204,'3fb8d4a8278546deacbbb6d960f5b0bb','gigabytes',1,'2026-01-24 19:06:02','a231ee93-b5f1-4fc4-a3d2-0055417021c0'),('2026-01-23 19:06:07.028083',NULL,'2026-01-23 19:06:07.046162',663,663,'7a1a35011363435a8a558e98e87b8831','9ac61ef1-0ba8-4abc-9b15-704be74d1ccc',192,'ef50bedea4bc4cfd892c55fa7305015f','shares',-1,'2026-01-24 19:06:07',NULL),('2026-01-23 19:06:07.028842',NULL,'2026-01-23 19:06:07.046162',664,664,'7a1a35011363435a8a558e98e87b8831','f1364308-9308-4a2d-b896-02efa78064f8',193,'ef50bedea4bc4cfd892c55fa7305015f','gigabytes',-1,'2026-01-24 19:06:07',NULL),('2026-01-23 19:06:07.036402',NULL,'2026-01-23 19:06:07.046162',665,665,NULL,'ed7adbab-ac32-4191-86d5-f1616a2460fa',194,'ef50bedea4bc4cfd892c55fa7305015f','shares',-1,'2026-01-24 19:06:07','4b614781-282f-426a-a8da-c9980601f345'),('2026-01-23 19:06:07.037252',NULL,'2026-01-23 19:06:07.046162',666,666,NULL,'31bfbcfe-d645-4f44-a7a2-a5d500ad4799',195,'ef50bedea4bc4cfd892c55fa7305015f','gigabytes',-1,'2026-01-24 19:06:07','4b614781-282f-426a-a8da-c9980601f345'),('2026-01-23 19:06:09.470583',NULL,'2026-01-23 19:06:09.495278',667,667,'7a1a35011363435a8a558e98e87b8831','e8c8f459-0f57-469c-aafa-4ac0779f6d7f',192,'ef50bedea4bc4cfd892c55fa7305015f','shares',1,'2026-01-24 19:06:09',NULL),('2026-01-23 19:06:09.471718',NULL,'2026-01-23 19:06:09.495278',668,668,'7a1a35011363435a8a558e98e87b8831','ad89ab85-5c76-4898-9b14-5ad97ca6329c',193,'ef50bedea4bc4cfd892c55fa7305015f','gigabytes',1,'2026-01-24 19:06:09',NULL),('2026-01-23 19:06:09.476960',NULL,'2026-01-23 19:06:09.495278',669,669,NULL,'4498d20c-8e12-439b-8ebc-9453c6f1d031',194,'ef50bedea4bc4cfd892c55fa7305015f','shares',1,'2026-01-24 19:06:09','4b614781-282f-426a-a8da-c9980601f345'),('2026-01-23 19:06:09.478101',NULL,'2026-01-23 19:06:09.495278',670,670,NULL,'54a08294-51a5-4e41-86fa-d3b7949ea109',195,'ef50bedea4bc4cfd892c55fa7305015f','gigabytes',1,'2026-01-24 19:06:09','4b614781-282f-426a-a8da-c9980601f345'),('2026-01-23 19:06:09.511030',NULL,'2026-01-23 19:06:09.633901',671,671,'0ee3b61db0254b40bc85214e7d348538','b6c98ff9-f492-4e24-b5c4-3d5dd3b3e891',196,'3fb8d4a8278546deacbbb6d960f5b0bb','snapshots',1,'2026-01-24 19:06:09',NULL),('2026-01-23 19:06:09.512353',NULL,'2026-01-23 19:06:09.633901',672,672,'0ee3b61db0254b40bc85214e7d348538','b1c4bc95-630a-4cdb-a3b0-8c611e9cfd53',197,'3fb8d4a8278546deacbbb6d960f5b0bb','snapshot_gigabytes',1,'2026-01-24 19:06:09',NULL),('2026-01-23 19:06:09.528032',NULL,'2026-01-23 19:06:09.633901',673,673,NULL,'f3f7e189-b6e6-4511-ac1d-6016d8e7b2db',205,'3fb8d4a8278546deacbbb6d960f5b0bb','snapshots',1,'2026-01-24 19:06:09','a231ee93-b5f1-4fc4-a3d2-0055417021c0'),('2026-01-23 19:06:09.530397',NULL,'2026-01-23 19:06:09.633901',674,674,NULL,'e8b430ee-ed54-41a8-9a44-dfb71ed85832',206,'3fb8d4a8278546deacbbb6d960f5b0bb','snapshot_gigabytes',1,'2026-01-24 19:06:09','a231ee93-b5f1-4fc4-a3d2-0055417021c0'),('2026-01-23 19:06:13.646602',NULL,'2026-01-23 19:06:13.684158',675,675,'0ee3b61db0254b40bc85214e7d348538','4406f0e7-dfef-4162-b648-5c0e9f0e755b',188,'3fb8d4a8278546deacbbb6d960f5b0bb','shares',1,'2026-01-24 19:06:13',NULL),('2026-01-23 19:06:13.648186',NULL,'2026-01-23 19:06:13.684158',676,676,'0ee3b61db0254b40bc85214e7d348538','c06e5536-9369-4472-82c5-725678d00fb7',189,'3fb8d4a8278546deacbbb6d960f5b0bb','gigabytes',1,'2026-01-24 19:06:13',NULL),('2026-01-23 19:06:13.654317',NULL,'2026-01-23 19:06:13.684158',677,677,NULL,'8eb3f2a7-f53e-46e4-91ce-55fbde391ddc',203,'3fb8d4a8278546deacbbb6d960f5b0bb','shares',1,'2026-01-24 19:06:13','a231ee93-b5f1-4fc4-a3d2-0055417021c0'),('2026-01-23 19:06:13.656594',NULL,'2026-01-23 19:06:13.684158',678,678,NULL,'adc86837-f7b3-4bd2-9bbf-a4317fcb655a',204,'3fb8d4a8278546deacbbb6d960f5b0bb','gigabytes',1,'2026-01-24 19:06:13','a231ee93-b5f1-4fc4-a3d2-0055417021c0'),('2026-01-23 19:06:18.843984',NULL,'2026-01-23 19:06:18.938014',679,679,'f395e891216c41888bac49e47c3ac432','5a032e4d-e7fb-4abe-8acb-dbd34183a896',207,'05bdf608ce00460ba07de9e0ce988795','share_networks',1,'2026-01-24 19:06:18',NULL),('2026-01-23 19:06:19.500158',NULL,'2026-01-23 19:06:19.518636',680,680,'7a1a35011363435a8a558e98e87b8831','74a6d7b8-bc4e-4e93-a2b5-997600956bd6',192,'ef50bedea4bc4cfd892c55fa7305015f','shares',-1,'2026-01-24 19:06:19',NULL),('2026-01-23 19:06:19.501071',NULL,'2026-01-23 19:06:19.518636',681,681,'7a1a35011363435a8a558e98e87b8831','24d1e68b-53ee-43b9-a54e-6a9d11ac1d4b',193,'ef50bedea4bc4cfd892c55fa7305015f','gigabytes',-1,'2026-01-24 19:06:19',NULL),('2026-01-23 19:06:19.509733',NULL,'2026-01-23 19:06:19.518636',682,682,NULL,'24dabd45-f2d8-40a4-bfe8-72cec32dc855',194,'ef50bedea4bc4cfd892c55fa7305015f','shares',-1,'2026-01-24 19:06:19','4b614781-282f-426a-a8da-c9980601f345'),('2026-01-23 19:06:19.511580',NULL,'2026-01-23 19:06:19.518636',683,683,NULL,'5eeae1ac-6ec9-4715-8f07-4bdc0d7e803b',195,'ef50bedea4bc4cfd892c55fa7305015f','gigabytes',-1,'2026-01-24 19:06:19','4b614781-282f-426a-a8da-c9980601f345'),('2026-01-23 19:06:26.655502',NULL,'2026-01-23 19:06:26.688607',684,684,'b41c18afdb6346b291f5525a5b5aca4d','7e34382f-696c-47cb-a1ef-0982e565cb33',208,'5ce1c1cb978d4655b95674240227e033','shares',1,'2026-01-24 19:06:26',NULL),('2026-01-23 19:06:26.656555',NULL,'2026-01-23 19:06:26.688607',685,685,'b41c18afdb6346b291f5525a5b5aca4d','c66f9a3f-5b16-46d4-8e82-f4c67c712ad7',209,'5ce1c1cb978d4655b95674240227e033','gigabytes',1,'2026-01-24 19:06:26',NULL),('2026-01-23 19:06:26.666438',NULL,'2026-01-23 19:06:26.688607',686,686,NULL,'5a635e98-425e-4287-9b58-0f6ce978f4f2',210,'5ce1c1cb978d4655b95674240227e033','shares',1,'2026-01-24 19:06:26','1339bb0a-ff5c-466e-9368-c1558d7331e6'),('2026-01-23 19:06:26.667518',NULL,'2026-01-23 19:06:26.688607',687,687,NULL,'530527ee-9344-47ff-8313-8809d2b436a2',211,'5ce1c1cb978d4655b95674240227e033','gigabytes',1,'2026-01-24 19:06:26','1339bb0a-ff5c-466e-9368-c1558d7331e6'),('2026-01-23 19:06:30.653813',NULL,'2026-01-23 19:06:30.829271',688,688,'1f380b30b01f4d3fa656e1f1627b7438','3ca68df4-a9ac-4979-a965-84042d6822eb',212,'1e5a07e60ba9416db9dd4733653459eb','shares',1,'2026-01-24 19:06:30',NULL),('2026-01-23 19:06:30.655182',NULL,'2026-01-23 19:06:30.829271',689,689,'1f380b30b01f4d3fa656e1f1627b7438','de9eef1f-031f-47c2-95f5-19cbe6f49a15',213,'1e5a07e60ba9416db9dd4733653459eb','gigabytes',1,'2026-01-24 19:06:30',NULL),('2026-01-23 19:06:30.674952',NULL,'2026-01-23 19:06:30.842211',690,690,'1f380b30b01f4d3fa656e1f1627b7438','81de5a33-0e91-48be-8c76-26141f6bce74',214,'5ce1c1cb978d4655b95674240227e033','shares',-1,'2026-01-24 19:06:30',NULL),('2026-01-23 19:06:30.675573',NULL,'2026-01-23 19:06:30.842211',691,691,'1f380b30b01f4d3fa656e1f1627b7438','5816f858-20ca-4ba1-8a18-e18a43311de3',215,'5ce1c1cb978d4655b95674240227e033','gigabytes',-1,'2026-01-24 19:06:30',NULL),('2026-01-23 19:06:31.612528',NULL,'2026-01-23 19:06:31.925398',692,692,'1f380b30b01f4d3fa656e1f1627b7438','abddca26-e1c6-48d7-bda0-a92acdc10cc0',212,'1e5a07e60ba9416db9dd4733653459eb','shares',-1,'2026-01-24 19:06:31',NULL),('2026-01-23 19:06:31.613427',NULL,'2026-01-23 19:06:31.925398',693,693,'1f380b30b01f4d3fa656e1f1627b7438','12740f02-5b13-4bba-a3ef-672c2b4f8179',213,'1e5a07e60ba9416db9dd4733653459eb','gigabytes',-1,'2026-01-24 19:06:31',NULL),('2026-01-23 19:06:31.630355',NULL,'2026-01-23 19:06:31.925398',694,694,NULL,'158b95a4-0ea8-4719-a0d2-3361c4098726',216,'1e5a07e60ba9416db9dd4733653459eb','shares',-1,'2026-01-24 19:06:31','1339bb0a-ff5c-466e-9368-c1558d7331e6'),('2026-01-23 19:06:31.631404',NULL,'2026-01-23 19:06:31.925398',695,695,NULL,'7ca2bdd3-6567-47f9-983f-778023b514d6',217,'1e5a07e60ba9416db9dd4733653459eb','gigabytes',-1,'2026-01-24 19:06:31','1339bb0a-ff5c-466e-9368-c1558d7331e6'),('2026-01-23 19:06:34.564507',NULL,'2026-01-23 19:06:34.613571',696,696,'b41c18afdb6346b291f5525a5b5aca4d','484de6d3-039f-4d17-8d2a-8d199714dd04',208,'5ce1c1cb978d4655b95674240227e033','shares',1,'2026-01-24 19:06:34',NULL),('2026-01-23 19:06:34.565889',NULL,'2026-01-23 19:06:34.613571',697,697,'b41c18afdb6346b291f5525a5b5aca4d','9cffbbb6-f75a-4fa7-be53-eeac34a90639',209,'5ce1c1cb978d4655b95674240227e033','gigabytes',1,'2026-01-24 19:06:34',NULL),('2026-01-23 19:06:34.574999',NULL,'2026-01-23 19:06:34.613571',698,698,NULL,'730ce305-b783-4fa8-a07c-6bd9bef2c976',210,'5ce1c1cb978d4655b95674240227e033','shares',1,'2026-01-24 19:06:34','1339bb0a-ff5c-466e-9368-c1558d7331e6'),('2026-01-23 19:06:34.576542',NULL,'2026-01-23 19:06:34.613571',699,699,NULL,'a431ff4d-b517-436a-b5c0-814673d4aeb5',211,'5ce1c1cb978d4655b95674240227e033','gigabytes',1,'2026-01-24 19:06:34','1339bb0a-ff5c-466e-9368-c1558d7331e6'),('2026-01-23 19:06:35.539219',NULL,'2026-01-23 19:06:35.575341',700,700,'72c10a6dc7104c18ac27162d188683d7','b73d2e42-6d14-422d-8b4f-f1dd10fb03b0',218,'1bedbf7265dc42cf859f02ee7f9194c5','shares',1,'2026-01-24 19:06:35',NULL),('2026-01-23 19:06:35.540394',NULL,'2026-01-23 19:06:35.575341',701,701,'72c10a6dc7104c18ac27162d188683d7','68008fb7-e184-43eb-9bae-6c63c97d7e80',219,'1bedbf7265dc42cf859f02ee7f9194c5','gigabytes',1,'2026-01-24 19:06:35',NULL),('2026-01-23 19:06:35.547326',NULL,'2026-01-23 19:06:35.575341',702,702,NULL,'d1cc3a97-973f-4e13-baa3-cccbe62900d9',121,'1bedbf7265dc42cf859f02ee7f9194c5','shares',1,'2026-01-24 19:06:35','1cd0aa0c-256d-4747-b5c6-735c1e4e32e0'),('2026-01-23 19:06:35.548929',NULL,'2026-01-23 19:06:35.575341',703,703,NULL,'57b1f01f-3721-4a27-b1c8-b0c07fc895b2',122,'1bedbf7265dc42cf859f02ee7f9194c5','gigabytes',1,'2026-01-24 19:06:35','1cd0aa0c-256d-4747-b5c6-735c1e4e32e0'),('2026-01-23 19:06:39.917549',NULL,'2026-01-23 19:06:40.575701',704,704,'b41c18afdb6346b291f5525a5b5aca4d','69dfac3e-7af4-4724-b7ff-187e41646ade',208,'5ce1c1cb978d4655b95674240227e033','shares',-1,'2026-01-24 19:06:39',NULL),('2026-01-23 19:06:39.918596',NULL,'2026-01-23 19:06:40.575701',705,705,'b41c18afdb6346b291f5525a5b5aca4d','b0cae50a-5f64-4ece-b099-5d7cff60a4a6',209,'5ce1c1cb978d4655b95674240227e033','gigabytes',-1,'2026-01-24 19:06:39',NULL),('2026-01-23 19:06:39.934733',NULL,'2026-01-23 19:06:40.575701',706,706,NULL,'a7f562ef-fbab-4a85-908f-f6cdb864fc34',210,'5ce1c1cb978d4655b95674240227e033','shares',-1,'2026-01-24 19:06:39','1339bb0a-ff5c-466e-9368-c1558d7331e6'),('2026-01-23 19:06:39.936580',NULL,'2026-01-23 19:06:40.575701',707,707,NULL,'68da3769-f9e6-438c-a97e-6ad01249a894',211,'5ce1c1cb978d4655b95674240227e033','gigabytes',-1,'2026-01-24 19:06:39','1339bb0a-ff5c-466e-9368-c1558d7331e6'),('2026-01-23 19:06:50.550610',NULL,'2026-01-23 19:06:50.567916',708,708,'39690acf77cd4929bf30d8ec50697f1a','29fed568-22c4-4039-af3b-b82f2bf8c853',119,'1bedbf7265dc42cf859f02ee7f9194c5','shares',-1,'2026-01-24 19:06:50',NULL),('2026-01-23 19:06:50.551243',NULL,'2026-01-23 19:06:50.567916',709,709,'39690acf77cd4929bf30d8ec50697f1a','c051c0a4-00bc-4213-ab73-a18c1c7e620e',120,'1bedbf7265dc42cf859f02ee7f9194c5','gigabytes',-1,'2026-01-24 19:06:50',NULL),('2026-01-23 19:06:50.557428',NULL,'2026-01-23 19:06:50.567916',710,710,NULL,'5fde814c-2ec0-4b97-ae69-3aba22ad8cda',121,'1bedbf7265dc42cf859f02ee7f9194c5','shares',-1,'2026-01-24 19:06:50','1cd0aa0c-256d-4747-b5c6-735c1e4e32e0'),('2026-01-23 19:06:50.558031',NULL,'2026-01-23 19:06:50.567916',711,711,NULL,'e23766b0-05e2-409f-8a6d-68741c401797',122,'1bedbf7265dc42cf859f02ee7f9194c5','gigabytes',-1,'2026-01-24 19:06:50','1cd0aa0c-256d-4747-b5c6-735c1e4e32e0'),('2026-01-23 19:06:50.796789',NULL,'2026-01-23 19:06:50.841794',712,712,'7a1a35011363435a8a558e98e87b8831','f7149120-9fa5-42ca-984f-a233d2cfb409',192,'ef50bedea4bc4cfd892c55fa7305015f','shares',-1,'2026-01-24 19:06:50',NULL),('2026-01-23 19:06:50.797645',NULL,'2026-01-23 19:06:50.841794',713,713,'7a1a35011363435a8a558e98e87b8831','7e5df684-fbe8-41a0-9928-4ae304983042',193,'ef50bedea4bc4cfd892c55fa7305015f','gigabytes',-1,'2026-01-24 19:06:50',NULL),('2026-01-23 19:06:50.830290',NULL,'2026-01-23 19:06:50.841794',714,714,NULL,'ef3ae68b-fec2-4443-b7b0-2f44450c3b57',194,'ef50bedea4bc4cfd892c55fa7305015f','shares',-1,'2026-01-24 19:06:50','4b614781-282f-426a-a8da-c9980601f345'),('2026-01-23 19:06:50.830962',NULL,'2026-01-23 19:06:50.841794',715,715,NULL,'2de9adfd-53e5-4135-9a1a-3531ff3f44e3',195,'ef50bedea4bc4cfd892c55fa7305015f','gigabytes',-1,'2026-01-24 19:06:50','4b614781-282f-426a-a8da-c9980601f345'),('2026-01-23 19:06:55.878150',NULL,'2026-01-23 19:06:55.895896',716,716,'0ee3b61db0254b40bc85214e7d348538','742db640-4ed5-4967-b5a2-2c9c8bd2eac3',188,'3fb8d4a8278546deacbbb6d960f5b0bb','shares',-1,'2026-01-24 19:06:55',NULL),('2026-01-23 19:06:55.878915',NULL,'2026-01-23 19:06:55.895896',717,717,'0ee3b61db0254b40bc85214e7d348538','2a1932bd-02ea-4a47-918d-c6f725b96f2d',189,'3fb8d4a8278546deacbbb6d960f5b0bb','gigabytes',-1,'2026-01-24 19:06:55',NULL),('2026-01-23 19:06:55.887716',NULL,'2026-01-23 19:06:55.895896',718,718,NULL,'ecef4eea-44e0-4a74-a696-1b3f4b2f426e',203,'3fb8d4a8278546deacbbb6d960f5b0bb','shares',-1,'2026-01-24 19:06:55','a231ee93-b5f1-4fc4-a3d2-0055417021c0'),('2026-01-23 19:06:55.888442',NULL,'2026-01-23 19:06:55.895896',719,719,NULL,'041ed06e-2254-4c53-8c31-cffa7d8b28a0',204,'3fb8d4a8278546deacbbb6d960f5b0bb','gigabytes',-1,'2026-01-24 19:06:55','a231ee93-b5f1-4fc4-a3d2-0055417021c0'),('2026-01-23 19:06:59.451456',NULL,'2026-01-23 19:06:59.468909',720,720,'0ee3b61db0254b40bc85214e7d348538','d65a2363-6a49-44b5-8e4b-df5fe7aafdbb',196,'3fb8d4a8278546deacbbb6d960f5b0bb','snapshots',-1,'2026-01-24 19:06:59',NULL),('2026-01-23 19:06:59.452219',NULL,'2026-01-23 19:06:59.468909',721,721,'0ee3b61db0254b40bc85214e7d348538','39338b46-ff4b-4ad7-bd3f-e102796cbb2f',197,'3fb8d4a8278546deacbbb6d960f5b0bb','snapshot_gigabytes',-1,'2026-01-24 19:06:59',NULL),('2026-01-23 19:06:59.459945',NULL,'2026-01-23 19:06:59.468909',722,722,NULL,'3d5022fb-9b78-4ecb-a4c0-e70f984ef26d',205,'3fb8d4a8278546deacbbb6d960f5b0bb','snapshots',-1,'2026-01-24 19:06:59','a231ee93-b5f1-4fc4-a3d2-0055417021c0'),('2026-01-23 19:06:59.460709',NULL,'2026-01-23 19:06:59.468909',723,723,NULL,'782f680b-b5eb-40f2-a535-5b1b215ee11a',206,'3fb8d4a8278546deacbbb6d960f5b0bb','snapshot_gigabytes',-1,'2026-01-24 19:06:59','a231ee93-b5f1-4fc4-a3d2-0055417021c0'),('2026-01-23 19:07:02.990332',NULL,'2026-01-23 19:07:03.007212',724,724,'0ee3b61db0254b40bc85214e7d348538','4ca41fcd-c1ef-4797-a960-3f94a56877ef',188,'3fb8d4a8278546deacbbb6d960f5b0bb','shares',-1,'2026-01-24 19:07:02',NULL),('2026-01-23 19:07:02.991330',NULL,'2026-01-23 19:07:03.007212',725,725,'0ee3b61db0254b40bc85214e7d348538','a6a76869-3b2e-4ce3-bfd9-a01315cbd351',189,'3fb8d4a8278546deacbbb6d960f5b0bb','gigabytes',-1,'2026-01-24 19:07:02',NULL),('2026-01-23 19:07:02.998315',NULL,'2026-01-23 19:07:03.007212',726,726,NULL,'f6081565-4347-4258-80cb-7ca8df468a73',203,'3fb8d4a8278546deacbbb6d960f5b0bb','shares',-1,'2026-01-24 19:07:02','a231ee93-b5f1-4fc4-a3d2-0055417021c0'),('2026-01-23 19:07:02.999156',NULL,'2026-01-23 19:07:03.007212',727,727,NULL,'d7d20333-21cc-4525-b9b1-719cf200989a',204,'3fb8d4a8278546deacbbb6d960f5b0bb','gigabytes',-1,'2026-01-24 19:07:02','a231ee93-b5f1-4fc4-a3d2-0055417021c0'),('2026-01-23 19:07:09.722887',NULL,'2026-01-23 19:07:09.795899',728,728,'02a38fd372d54825882d2b76e2408a99','b283802a-3ad0-4eae-a4db-fb31d77c5641',220,'8ef2e7b772bf414b9d6c084c7663325d','share_networks',1,'2026-01-24 19:07:09',NULL),('2026-01-23 19:07:10.116131',NULL,'2026-01-23 19:07:10.123159',729,729,'02a38fd372d54825882d2b76e2408a99','0eff0c31-0c28-4fe2-8185-6cdbc7f56fb7',220,'8ef2e7b772bf414b9d6c084c7663325d','share_networks',-1,'2026-01-24 19:07:10',NULL),('2026-01-23 19:07:10.676158',NULL,'2026-01-23 19:07:10.707438',730,730,'02a38fd372d54825882d2b76e2408a99','a88b0d27-c720-428b-8941-e834c355259b',220,'8ef2e7b772bf414b9d6c084c7663325d','share_networks',1,'2026-01-24 19:07:10',NULL),('2026-01-23 19:07:11.556297',NULL,'2026-01-23 19:07:11.596893',731,731,'02a38fd372d54825882d2b76e2408a99','5001bdfb-a2f9-465a-ad39-51270cd5c330',220,'8ef2e7b772bf414b9d6c084c7663325d','share_networks',-1,'2026-01-24 19:07:11',NULL),('2026-01-23 19:07:12.212857',NULL,'2026-01-23 19:07:12.311723',732,732,'02a38fd372d54825882d2b76e2408a99','504f4d16-1746-456f-b053-75df2d765031',220,'8ef2e7b772bf414b9d6c084c7663325d','share_networks',1,'2026-01-24 19:07:12',NULL),('2026-01-23 19:07:12.619248',NULL,'2026-01-23 19:07:12.754974',733,733,'02a38fd372d54825882d2b76e2408a99','6421ef71-9b96-403c-99ba-a35d7e2eb8d9',220,'8ef2e7b772bf414b9d6c084c7663325d','share_networks',-1,'2026-01-24 19:07:12',NULL),('2026-01-23 19:07:14.183683',NULL,'2026-01-23 19:07:14.216337',734,734,'968d5d01fead4ec5974c92681f5cd389','ccb6ad58-fb20-4b19-a04c-82d53f1b6dcf',221,'cd28fe6ab6ac42579a9ef7ca014c6978','share_networks',1,'2026-01-24 19:07:14',NULL),('2026-01-23 19:07:14.730316',NULL,'2026-01-23 19:07:14.829824',735,735,'968d5d01fead4ec5974c92681f5cd389','37eb9f64-7aa6-43de-81f9-03942e75e0d1',221,'cd28fe6ab6ac42579a9ef7ca014c6978','share_networks',1,'2026-01-24 19:07:14',NULL),('2026-01-23 19:07:15.224636',NULL,'2026-01-23 19:07:15.256340',736,736,'968d5d01fead4ec5974c92681f5cd389','dadf589c-92d1-4fbf-9c55-bdd2fe3b16ea',221,'cd28fe6ab6ac42579a9ef7ca014c6978','share_networks',1,'2026-01-24 19:07:15',NULL),('2026-01-23 19:07:15.489276',NULL,'2026-01-23 19:07:15.495446',737,737,'968d5d01fead4ec5974c92681f5cd389','39704717-a702-477e-83ef-25d396a31b4c',221,'cd28fe6ab6ac42579a9ef7ca014c6978','share_networks',-1,'2026-01-24 19:07:15',NULL),('2026-01-23 19:07:15.872450',NULL,'2026-01-23 19:07:15.905510',738,738,'968d5d01fead4ec5974c92681f5cd389','85b7a63a-3c2c-4893-917d-fe80a5dca66e',221,'cd28fe6ab6ac42579a9ef7ca014c6978','share_networks',1,'2026-01-24 19:07:15',NULL),('2026-01-23 19:07:16.008773',NULL,'2026-01-23 19:07:16.039031',739,739,'968d5d01fead4ec5974c92681f5cd389','14b648a4-3347-44d0-899f-f126cf709b97',221,'cd28fe6ab6ac42579a9ef7ca014c6978','share_networks',1,'2026-01-24 19:07:15',NULL),('2026-01-23 19:07:16.107815',NULL,'2026-01-23 19:07:16.141281',740,740,'77520b512b09481594399d1d447d3353','5895446f-d7f2-4fc4-84ac-8c254aa6176f',222,'998a3a4c23934c4dafb2e2112ce1af90','shares',1,'2026-01-24 19:07:16',NULL),('2026-01-23 19:07:16.109112',NULL,'2026-01-23 19:07:16.141281',741,741,'77520b512b09481594399d1d447d3353','b92145d0-022c-4f9e-8e94-243f0bbcb16b',223,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',1,'2026-01-24 19:07:16',NULL),('2026-01-23 19:07:16.119450',NULL,'2026-01-23 19:07:16.141281',742,742,NULL,'3bffbd50-964f-4a8e-958b-9b24ed47da01',224,'998a3a4c23934c4dafb2e2112ce1af90','shares',1,'2026-01-24 19:07:16','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:07:16.120471',NULL,'2026-01-23 19:07:16.141281',743,743,NULL,'c3039f41-57b9-4b70-b7f2-f49becf253e5',225,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',1,'2026-01-24 19:07:16','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:07:16.167836',NULL,'2026-01-23 19:07:16.172915',744,744,'968d5d01fead4ec5974c92681f5cd389','ac7cfe40-6645-4112-ab6b-7a02c4ce5e90',221,'cd28fe6ab6ac42579a9ef7ca014c6978','share_networks',-1,'2026-01-24 19:07:16',NULL),('2026-01-23 19:07:16.411308',NULL,'2026-01-23 19:07:16.598116',745,745,'968d5d01fead4ec5974c92681f5cd389','8d305d53-c673-4eb9-9086-e82a045cca6d',221,'cd28fe6ab6ac42579a9ef7ca014c6978','share_networks',-1,'2026-01-24 19:07:16',NULL),('2026-01-23 19:07:18.631708',NULL,'2026-01-23 19:07:18.659118',746,746,'968d5d01fead4ec5974c92681f5cd389','8779dbf9-7677-430a-a332-c7c5aef3e880',221,'cd28fe6ab6ac42579a9ef7ca014c6978','share_networks',1,'2026-01-24 19:07:18',NULL),('2026-01-23 19:07:18.771115',NULL,'2026-01-23 19:07:18.776981',747,747,'968d5d01fead4ec5974c92681f5cd389','c71b5697-457a-438c-b394-22e835a54d78',221,'cd28fe6ab6ac42579a9ef7ca014c6978','share_networks',-1,'2026-01-24 19:07:18',NULL),('2026-01-23 19:07:18.855142',NULL,'2026-01-23 19:07:18.889105',748,748,'968d5d01fead4ec5974c92681f5cd389','076cf8e9-029a-47c0-b267-047338c617cf',221,'cd28fe6ab6ac42579a9ef7ca014c6978','share_networks',1,'2026-01-24 19:07:18',NULL),('2026-01-23 19:07:19.141374',NULL,'2026-01-23 19:07:19.318562',749,749,'968d5d01fead4ec5974c92681f5cd389','47856556-9dab-4529-9da3-b181ac7982b6',221,'cd28fe6ab6ac42579a9ef7ca014c6978','share_networks',-1,'2026-01-24 19:07:19',NULL),('2026-01-23 19:07:19.579663',NULL,'2026-01-23 19:07:19.821465',750,750,'77520b512b09481594399d1d447d3353','e2dce768-de91-4884-b5b7-05f6e9f63a79',226,'998a3a4c23934c4dafb2e2112ce1af90','snapshots',1,'2026-01-24 19:07:19',NULL),('2026-01-23 19:07:19.580948',NULL,'2026-01-23 19:07:19.821465',751,751,'77520b512b09481594399d1d447d3353','0ded0d47-43e9-4286-89f7-e9d55c60a261',227,'998a3a4c23934c4dafb2e2112ce1af90','snapshot_gigabytes',1,'2026-01-24 19:07:19',NULL),('2026-01-23 19:07:19.594614',NULL,'2026-01-23 19:07:19.821465',752,752,NULL,'2277118a-3f1c-41dc-9a2a-0b167689207f',228,'998a3a4c23934c4dafb2e2112ce1af90','snapshots',1,'2026-01-24 19:07:19','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:07:19.599253',NULL,'2026-01-23 19:07:19.821465',753,753,NULL,'99865b32-1482-4c51-b950-06a9924550df',229,'998a3a4c23934c4dafb2e2112ce1af90','snapshot_gigabytes',1,'2026-01-24 19:07:19','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:07:20.532526',NULL,'2026-01-23 19:07:20.540374',754,754,'968d5d01fead4ec5974c92681f5cd389','8494adf8-86b7-4edc-b21c-9a928a2b90b6',221,'cd28fe6ab6ac42579a9ef7ca014c6978','share_networks',-1,'2026-01-24 19:07:20',NULL),('2026-01-23 19:07:20.860113',NULL,'2026-01-23 19:07:20.869038',755,755,'968d5d01fead4ec5974c92681f5cd389','4a570683-f570-4d36-bd77-2472b1b164ca',221,'cd28fe6ab6ac42579a9ef7ca014c6978','share_networks',-1,'2026-01-24 19:07:20',NULL),('2026-01-23 19:07:23.494131',NULL,'2026-01-23 19:07:23.525605',756,756,'77520b512b09481594399d1d447d3353','011e6ce7-a094-4a30-9c56-5c5f7253c970',222,'998a3a4c23934c4dafb2e2112ce1af90','shares',1,'2026-01-24 19:07:23',NULL),('2026-01-23 19:07:23.495530',NULL,'2026-01-23 19:07:23.525605',757,757,'77520b512b09481594399d1d447d3353','f0514a7e-ecde-4758-af73-d0b459cc8df3',223,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',1,'2026-01-24 19:07:23',NULL),('2026-01-23 19:07:23.502612',NULL,'2026-01-23 19:07:23.525605',758,758,NULL,'c447993a-6257-4514-ae3e-e329efe7a4c3',224,'998a3a4c23934c4dafb2e2112ce1af90','shares',1,'2026-01-24 19:07:23','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:07:23.505809',NULL,'2026-01-23 19:07:23.525605',759,759,NULL,'56fe1133-d499-4633-97d5-4341a12fc680',225,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',1,'2026-01-24 19:07:23','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:07:28.769967',NULL,'2026-01-23 19:07:28.811828',760,760,'8263f588feb3441b90a14974c5c7dfcf','e3f116a5-1c82-4e28-8452-0f1002c1170b',230,'c65808ebd8034050a7f642ca129ed6de','shares',1,'2026-01-24 19:07:28',NULL),('2026-01-23 19:07:28.771758',NULL,'2026-01-23 19:07:28.811828',761,761,'8263f588feb3441b90a14974c5c7dfcf','cfe8fdaf-4857-4e7c-a1e1-bb4d7a3143fe',231,'c65808ebd8034050a7f642ca129ed6de','gigabytes',2,'2026-01-24 19:07:28',NULL),('2026-01-23 19:07:28.781655',NULL,'2026-01-23 19:07:28.811828',762,762,NULL,'c3d05f3a-ede3-47c1-8f43-db47cca2dc7a',232,'c65808ebd8034050a7f642ca129ed6de','shares',1,'2026-01-24 19:07:28','a23d81ce-d5e1-43ae-b5f6-7a08ac609609'),('2026-01-23 19:07:28.782755',NULL,'2026-01-23 19:07:28.811828',763,763,NULL,'62085c9c-512e-4dcf-8228-28852f7f7302',233,'c65808ebd8034050a7f642ca129ed6de','gigabytes',2,'2026-01-24 19:07:28','a23d81ce-d5e1-43ae-b5f6-7a08ac609609'),('2026-01-23 19:07:32.525353',NULL,'2026-01-23 19:07:32.636134',764,764,'8263f588feb3441b90a14974c5c7dfcf','e1c327ae-ad61-4e42-b66a-a9eea1382cee',234,'c65808ebd8034050a7f642ca129ed6de','snapshots',1,'2026-01-24 19:07:32',NULL),('2026-01-23 19:07:32.527613',NULL,'2026-01-23 19:07:32.636134',765,765,'8263f588feb3441b90a14974c5c7dfcf','7a2b0e76-3dbd-4b1c-bd85-ca4f6dacef56',235,'c65808ebd8034050a7f642ca129ed6de','snapshot_gigabytes',2,'2026-01-24 19:07:32',NULL),('2026-01-23 19:07:32.544647',NULL,'2026-01-23 19:07:32.636134',766,766,NULL,'e74fa3ee-a6fe-41f7-aeba-ce92b0ece394',236,'c65808ebd8034050a7f642ca129ed6de','snapshots',1,'2026-01-24 19:07:32','a23d81ce-d5e1-43ae-b5f6-7a08ac609609'),('2026-01-23 19:07:32.546869',NULL,'2026-01-23 19:07:32.636134',767,767,NULL,'d6ddea4e-ca66-48b1-a69e-9e92d28f9052',237,'c65808ebd8034050a7f642ca129ed6de','snapshot_gigabytes',2,'2026-01-24 19:07:32','a23d81ce-d5e1-43ae-b5f6-7a08ac609609'),('2026-01-23 19:07:33.401826',NULL,'2026-01-23 19:07:33.434322',768,768,'8263f588feb3441b90a14974c5c7dfcf','6b87cb13-a4bb-426b-89b1-af99ba568450',234,'c65808ebd8034050a7f642ca129ed6de','snapshots',-1,'2026-01-24 19:07:33',NULL),('2026-01-23 19:07:33.402656',NULL,'2026-01-23 19:07:33.434322',769,769,'8263f588feb3441b90a14974c5c7dfcf','19eb9adb-bbff-4115-aa73-2aa128942f13',235,'c65808ebd8034050a7f642ca129ed6de','snapshot_gigabytes',-2,'2026-01-24 19:07:33',NULL),('2026-01-23 19:07:33.425687',NULL,'2026-01-23 19:07:33.434322',770,770,NULL,'e48eb4a6-8ad9-444e-ab55-087cc9502cd1',236,'c65808ebd8034050a7f642ca129ed6de','snapshots',-1,'2026-01-24 19:07:33','a23d81ce-d5e1-43ae-b5f6-7a08ac609609'),('2026-01-23 19:07:33.426500',NULL,'2026-01-23 19:07:33.434322',771,771,NULL,'c3b34715-d4e6-445e-bceb-5df0e60d3d08',237,'c65808ebd8034050a7f642ca129ed6de','snapshot_gigabytes',-2,'2026-01-24 19:07:33','a23d81ce-d5e1-43ae-b5f6-7a08ac609609'),('2026-01-23 19:07:37.072811',NULL,'2026-01-23 19:07:37.104134',772,772,'8263f588feb3441b90a14974c5c7dfcf','41cb8bff-4ef1-4a8f-862c-571be89b0b6a',230,'c65808ebd8034050a7f642ca129ed6de','shares',-1,'2026-01-24 19:07:37',NULL),('2026-01-23 19:07:37.073536',NULL,'2026-01-23 19:07:37.104134',773,773,'8263f588feb3441b90a14974c5c7dfcf','bc292b3b-2bd4-4551-96cd-91d6c8c722b4',231,'c65808ebd8034050a7f642ca129ed6de','gigabytes',-2,'2026-01-24 19:07:37',NULL),('2026-01-23 19:07:37.089224',NULL,'2026-01-23 19:07:37.104134',774,774,NULL,'792746da-0b93-4a00-bbf7-49068ae4ab73',232,'c65808ebd8034050a7f642ca129ed6de','shares',-1,'2026-01-24 19:07:37','a23d81ce-d5e1-43ae-b5f6-7a08ac609609'),('2026-01-23 19:07:37.090564',NULL,'2026-01-23 19:07:37.104134',775,775,NULL,'210d787c-db5d-439d-972a-00a44982d49a',233,'c65808ebd8034050a7f642ca129ed6de','gigabytes',-2,'2026-01-24 19:07:37','a23d81ce-d5e1-43ae-b5f6-7a08ac609609'),('2026-01-23 19:07:40.178197',NULL,'2026-01-23 19:07:41.776075',776,776,'8263f588feb3441b90a14974c5c7dfcf','bcdc9639-2397-464d-bf19-ff35c820558e',230,'c65808ebd8034050a7f642ca129ed6de','shares',1,'2026-01-24 19:07:40',NULL),('2026-01-23 19:07:40.179615',NULL,'2026-01-23 19:07:41.776075',777,777,'8263f588feb3441b90a14974c5c7dfcf','57552faa-5272-4e55-8f7e-186702a0be46',231,'c65808ebd8034050a7f642ca129ed6de','gigabytes',1,'2026-01-24 19:07:40',NULL),('2026-01-23 19:07:40.964630',NULL,'2026-01-23 19:07:41.776075',778,778,NULL,'d6158aa6-0857-48d7-82f4-6c895e09197f',232,'c65808ebd8034050a7f642ca129ed6de','shares',1,'2026-01-24 19:07:40','a23d81ce-d5e1-43ae-b5f6-7a08ac609609'),('2026-01-23 19:07:40.966055',NULL,'2026-01-23 19:07:41.776075',779,779,NULL,'6e729f84-5db9-46e5-be87-be1bcf544ec6',233,'c65808ebd8034050a7f642ca129ed6de','gigabytes',1,'2026-01-24 19:07:40','a23d81ce-d5e1-43ae-b5f6-7a08ac609609'),('2026-01-23 19:07:45.613070',NULL,'2026-01-23 19:07:45.822296',780,780,'8263f588feb3441b90a14974c5c7dfcf','70117bd9-5958-4cf5-9ae0-a80489c8b91c',234,'c65808ebd8034050a7f642ca129ed6de','snapshots',1,'2026-01-24 19:07:45',NULL),('2026-01-23 19:07:45.741012',NULL,'2026-01-23 19:07:45.822296',781,781,'8263f588feb3441b90a14974c5c7dfcf','05ca389f-fe9e-4399-8d17-01192b81106b',235,'c65808ebd8034050a7f642ca129ed6de','snapshot_gigabytes',1,'2026-01-24 19:07:45',NULL),('2026-01-23 19:07:45.749818',NULL,'2026-01-23 19:07:45.822296',782,782,NULL,'7f10c1e9-3bac-47f2-9ce2-4b5cd892c547',236,'c65808ebd8034050a7f642ca129ed6de','snapshots',1,'2026-01-24 19:07:45','a23d81ce-d5e1-43ae-b5f6-7a08ac609609'),('2026-01-23 19:07:45.750958',NULL,'2026-01-23 19:07:45.822296',783,783,NULL,'5fcd490f-5214-4bea-86cb-5a406a5a903e',237,'c65808ebd8034050a7f642ca129ed6de','snapshot_gigabytes',1,'2026-01-24 19:07:45','a23d81ce-d5e1-43ae-b5f6-7a08ac609609'),('2026-01-23 19:07:49.804323',NULL,'2026-01-23 19:07:49.839031',784,784,'3deb3c1777d64f18bc9de677a095431d','5332b340-b01d-476e-af1d-1d4e531dd53f',238,'8548bd568a5448648a2e519eb3ab357a','shares',1,'2026-01-24 19:07:49',NULL),('2026-01-23 19:07:49.805521',NULL,'2026-01-23 19:07:49.839031',785,785,'3deb3c1777d64f18bc9de677a095431d','683e4a43-f618-4f7c-bed1-f1493b2ca43b',239,'8548bd568a5448648a2e519eb3ab357a','gigabytes',1,'2026-01-24 19:07:49',NULL),('2026-01-23 19:07:49.817743',NULL,'2026-01-23 19:07:49.839031',786,786,NULL,'f3b2bc80-63e7-4db3-9f18-0be134b42f72',240,'8548bd568a5448648a2e519eb3ab357a','shares',1,'2026-01-24 19:07:49','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:07:49.819636',NULL,'2026-01-23 19:07:49.839031',787,787,NULL,'ad652bb9-7b89-4b35-8cb6-d904803739e5',241,'8548bd568a5448648a2e519eb3ab357a','gigabytes',1,'2026-01-24 19:07:49','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:07:50.544462',NULL,'2026-01-23 19:07:50.557325',788,788,'8263f588feb3441b90a14974c5c7dfcf','0c66e604-8556-4c8c-a7ef-b52624a87b10',234,'c65808ebd8034050a7f642ca129ed6de','snapshots',-1,'2026-01-24 19:07:50',NULL),('2026-01-23 19:07:50.545243',NULL,'2026-01-23 19:07:50.557325',789,789,'8263f588feb3441b90a14974c5c7dfcf','2ad0e254-2d39-4acc-a20c-360d7fb5548a',235,'c65808ebd8034050a7f642ca129ed6de','snapshot_gigabytes',-1,'2026-01-24 19:07:50',NULL),('2026-01-23 19:07:50.550232',NULL,'2026-01-23 19:07:50.557325',790,790,NULL,'4471c5ca-8478-4038-b371-86afa6c995fd',236,'c65808ebd8034050a7f642ca129ed6de','snapshots',-1,'2026-01-24 19:07:50','a23d81ce-d5e1-43ae-b5f6-7a08ac609609'),('2026-01-23 19:07:50.550809',NULL,'2026-01-23 19:07:50.557325',791,791,NULL,'b0583005-8fa3-4d19-b086-07f802df53b5',237,'c65808ebd8034050a7f642ca129ed6de','snapshot_gigabytes',-1,'2026-01-24 19:07:50','a23d81ce-d5e1-43ae-b5f6-7a08ac609609'),('2026-01-23 19:07:53.489825',NULL,'2026-01-23 19:07:53.583615',792,792,'3deb3c1777d64f18bc9de677a095431d','6d1f0b09-ba51-4e8a-a264-44ae57570bfd',242,'8548bd568a5448648a2e519eb3ab357a','snapshots',1,'2026-01-24 19:07:53',NULL),('2026-01-23 19:07:53.491585',NULL,'2026-01-23 19:07:53.583615',793,793,'3deb3c1777d64f18bc9de677a095431d','ad9284a4-379f-4ce4-b78f-7553368ec847',243,'8548bd568a5448648a2e519eb3ab357a','snapshot_gigabytes',1,'2026-01-24 19:07:53',NULL),('2026-01-23 19:07:53.506655',NULL,'2026-01-23 19:07:53.583615',794,794,NULL,'e18ac688-7487-4a94-a661-8e6036b2aaab',244,'8548bd568a5448648a2e519eb3ab357a','snapshots',1,'2026-01-24 19:07:53','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:07:53.508034',NULL,'2026-01-23 19:07:53.583615',795,795,NULL,'883ae725-c818-42dc-a830-135a8373d3e1',245,'8548bd568a5448648a2e519eb3ab357a','snapshot_gigabytes',1,'2026-01-24 19:07:53','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:07:56.518761',NULL,'2026-01-23 19:07:56.562469',796,796,'8263f588feb3441b90a14974c5c7dfcf','67a16bd8-aa8d-4bc8-a29b-d7a74d6eb0de',230,'c65808ebd8034050a7f642ca129ed6de','shares',-1,'2026-01-24 19:07:56',NULL),('2026-01-23 19:07:56.519662',NULL,'2026-01-23 19:07:56.562469',797,797,'8263f588feb3441b90a14974c5c7dfcf','48578f6a-7b16-4c39-83de-a0a5c36b4781',231,'c65808ebd8034050a7f642ca129ed6de','gigabytes',-1,'2026-01-24 19:07:56',NULL),('2026-01-23 19:07:56.537455',NULL,'2026-01-23 19:07:56.562469',798,798,NULL,'fe10c3a4-d0f1-48d1-b1ba-9e1c757205dc',232,'c65808ebd8034050a7f642ca129ed6de','shares',-1,'2026-01-24 19:07:56','a23d81ce-d5e1-43ae-b5f6-7a08ac609609'),('2026-01-23 19:07:56.538225',NULL,'2026-01-23 19:07:56.562469',799,799,NULL,'1b8cd63f-fbd7-4f0d-b9f4-a8c5a8dc4633',233,'c65808ebd8034050a7f642ca129ed6de','gigabytes',-1,'2026-01-24 19:07:56','a23d81ce-d5e1-43ae-b5f6-7a08ac609609'),('2026-01-23 19:07:58.278440',NULL,'2026-01-23 19:07:58.311344',800,800,'3deb3c1777d64f18bc9de677a095431d','c940418d-3f73-446a-bd58-e71a410911ca',238,'8548bd568a5448648a2e519eb3ab357a','shares',1,'2026-01-24 19:07:58',NULL),('2026-01-23 19:07:58.279976',NULL,'2026-01-23 19:07:58.311344',801,801,'3deb3c1777d64f18bc9de677a095431d','1eb0d8bd-34d3-4e5f-af1e-8014a51d44a8',239,'8548bd568a5448648a2e519eb3ab357a','gigabytes',1,'2026-01-24 19:07:58',NULL),('2026-01-23 19:07:58.290075',NULL,'2026-01-23 19:07:58.311344',802,802,NULL,'c2d6097b-dfdd-4301-a547-8418f522b398',240,'8548bd568a5448648a2e519eb3ab357a','shares',1,'2026-01-24 19:07:58','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:07:58.291164',NULL,'2026-01-23 19:07:58.311344',803,803,NULL,'bfa8e755-bf3c-4ca0-a581-c77d34a14556',241,'8548bd568a5448648a2e519eb3ab357a','gigabytes',1,'2026-01-24 19:07:58','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:07:58.685737',NULL,'2026-01-23 19:07:58.766347',804,804,'77520b512b09481594399d1d447d3353','43443bcd-1c5f-444e-a454-0fe64c58d546',222,'998a3a4c23934c4dafb2e2112ce1af90','shares',1,'2026-01-24 19:07:58',NULL),('2026-01-23 19:07:58.687185',NULL,'2026-01-23 19:07:58.766347',805,805,'77520b512b09481594399d1d447d3353','59bcfdd9-8092-4e67-87ac-895b1f18993e',223,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',1,'2026-01-24 19:07:58',NULL),('2026-01-23 19:07:58.692694',NULL,'2026-01-23 19:07:58.766347',806,806,NULL,'63949ecf-c00f-4c25-b8a4-5c4db1b24a68',224,'998a3a4c23934c4dafb2e2112ce1af90','shares',1,'2026-01-24 19:07:58','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:07:58.693822',NULL,'2026-01-23 19:07:58.766347',807,807,NULL,'5b196744-4492-4e14-b21e-b7115067358e',225,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',1,'2026-01-24 19:07:58','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:08:02.194778',NULL,'2026-01-23 19:08:02.459272',808,808,'77520b512b09481594399d1d447d3353','95595198-909d-427e-8b99-03d8b5341edf',223,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',1,'2026-01-24 19:08:02',NULL),('2026-01-23 19:08:02.202560',NULL,'2026-01-23 19:08:02.459272',809,809,NULL,'ecc9ecda-4057-4417-8cd5-5e640bc1ebaf',225,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',1,'2026-01-24 19:08:02','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:08:02.628143',NULL,'2026-01-23 19:08:02.644090',810,810,'3deb3c1777d64f18bc9de677a095431d','8e8ba67a-b2c8-4f0a-9a73-1be7a3e44946',238,'8548bd568a5448648a2e519eb3ab357a','shares',-1,'2026-01-24 19:08:02',NULL),('2026-01-23 19:08:02.629318',NULL,'2026-01-23 19:08:02.644090',811,811,'3deb3c1777d64f18bc9de677a095431d','5dca58c7-ab7b-4499-a946-363687666b17',239,'8548bd568a5448648a2e519eb3ab357a','gigabytes',-1,'2026-01-24 19:08:02',NULL),('2026-01-23 19:08:02.634664',NULL,'2026-01-23 19:08:02.644090',812,812,NULL,'7b8863e5-8543-4013-9315-1d3c2f489757',240,'8548bd568a5448648a2e519eb3ab357a','shares',-1,'2026-01-24 19:08:02','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:08:02.635295',NULL,'2026-01-23 19:08:02.644090',813,813,NULL,'8c509616-b53d-4047-b620-25475e4d37e4',241,'8548bd568a5448648a2e519eb3ab357a','gigabytes',-1,'2026-01-24 19:08:02','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:08:05.154217',NULL,'2026-01-23 19:08:05.202006',814,814,'06cf53b820e34c74b5ed6e38f590535c','649456ce-4e1e-4531-ba13-b20a5dd06bf1',246,'b17f9a502db941108eaa44a3e9aa605c','shares',1,'2026-01-24 19:08:05',NULL),('2026-01-23 19:08:05.155322',NULL,'2026-01-23 19:08:05.202006',815,815,'06cf53b820e34c74b5ed6e38f590535c','a7476a08-fe20-4cc3-94d6-8abd17d1da7a',247,'b17f9a502db941108eaa44a3e9aa605c','gigabytes',1,'2026-01-24 19:08:05',NULL),('2026-01-23 19:08:05.167759',NULL,'2026-01-23 19:08:05.202006',816,816,NULL,'88e0ca59-3767-494e-ae80-e8f6614ae0fc',248,'b17f9a502db941108eaa44a3e9aa605c','shares',1,'2026-01-24 19:08:05','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:05.169161',NULL,'2026-01-23 19:08:05.202006',817,817,NULL,'285d9962-3b1f-470b-9fa3-1643a748fade',249,'b17f9a502db941108eaa44a3e9aa605c','gigabytes',1,'2026-01-24 19:08:05','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:05.922149',NULL,'2026-01-23 19:08:05.966155',818,818,'3deb3c1777d64f18bc9de677a095431d','c7e9a13a-6bb6-4573-89a2-4fe1814da86b',238,'8548bd568a5448648a2e519eb3ab357a','shares',1,'2026-01-24 19:08:05',NULL),('2026-01-23 19:08:05.923602',NULL,'2026-01-23 19:08:05.966155',819,819,'3deb3c1777d64f18bc9de677a095431d','b9dec70b-59c2-4a6c-b96e-b940e229f356',239,'8548bd568a5448648a2e519eb3ab357a','gigabytes',2,'2026-01-24 19:08:05',NULL),('2026-01-23 19:08:05.935617',NULL,'2026-01-23 19:08:05.966155',820,820,NULL,'cb0d74e8-d42b-4607-a6c7-6983362e7605',240,'8548bd568a5448648a2e519eb3ab357a','shares',1,'2026-01-24 19:08:05','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:08:05.937064',NULL,'2026-01-23 19:08:05.966155',821,821,NULL,'3464fd30-42de-4208-9457-87509a3cd036',241,'8548bd568a5448648a2e519eb3ab357a','gigabytes',2,'2026-01-24 19:08:05','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:08:06.154061',NULL,'2026-01-23 19:08:06.287117',822,822,'77520b512b09481594399d1d447d3353','3cbae23a-70ab-4a49-9c3c-11991ae2ed50',222,'998a3a4c23934c4dafb2e2112ce1af90','shares',-1,'2026-01-24 19:08:06',NULL),('2026-01-23 19:08:06.155335',NULL,'2026-01-23 19:08:06.287117',823,823,'77520b512b09481594399d1d447d3353','7425b708-01bc-4ced-ad5c-b60c5afd2b1f',223,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',-2,'2026-01-24 19:08:06',NULL),('2026-01-23 19:08:06.273021',NULL,'2026-01-23 19:08:06.287117',824,824,NULL,'8b288cc7-1086-4627-b416-9986501f0718',224,'998a3a4c23934c4dafb2e2112ce1af90','shares',-1,'2026-01-24 19:08:06','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:08:06.275132',NULL,'2026-01-23 19:08:06.287117',825,825,NULL,'3ce4e536-1258-4bbe-8487-bcfec9dd57a1',225,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',-2,'2026-01-24 19:08:06','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:08:08.553694',NULL,'2026-01-23 19:08:08.622662',826,826,'06cf53b820e34c74b5ed6e38f590535c','e1898ee8-52b8-4225-b462-8622f5bb7425',250,'b17f9a502db941108eaa44a3e9aa605c','snapshots',1,'2026-01-24 19:08:08',NULL),('2026-01-23 19:08:08.554928',NULL,'2026-01-23 19:08:08.622662',827,827,'06cf53b820e34c74b5ed6e38f590535c','e5f7b143-9a57-4f63-af53-07fda2efa5b3',251,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',1,'2026-01-24 19:08:08',NULL),('2026-01-23 19:08:08.566663',NULL,'2026-01-23 19:08:08.622662',828,828,NULL,'466aedae-e2f0-4143-9c84-73c3b27299c8',252,'b17f9a502db941108eaa44a3e9aa605c','snapshots',1,'2026-01-24 19:08:08','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:08.567731',NULL,'2026-01-23 19:08:08.622662',829,829,NULL,'0bec2a6d-b062-45ba-bd31-6c483e0f88d3',253,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',1,'2026-01-24 19:08:08','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:09.886072',NULL,'2026-01-23 19:08:09.906623',830,830,'3deb3c1777d64f18bc9de677a095431d','5e0e4c7c-d71b-427e-8530-e211b7bac963',238,'8548bd568a5448648a2e519eb3ab357a','shares',-1,'2026-01-24 19:08:09',NULL),('2026-01-23 19:08:09.888246',NULL,'2026-01-23 19:08:09.906623',831,831,'3deb3c1777d64f18bc9de677a095431d','63bfb887-3ee9-4588-bc08-1c3c88145303',239,'8548bd568a5448648a2e519eb3ab357a','gigabytes',-2,'2026-01-24 19:08:09',NULL),('2026-01-23 19:08:09.898162',NULL,'2026-01-23 19:08:09.906623',832,832,NULL,'01ed937c-d430-4c5e-b0b3-a7d7aef386cb',240,'8548bd568a5448648a2e519eb3ab357a','shares',-1,'2026-01-24 19:08:09','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:08:09.899029',NULL,'2026-01-23 19:08:09.906623',833,833,NULL,'cf01f12e-86e8-4642-9f18-f7aaabad3bac',241,'8548bd568a5448648a2e519eb3ab357a','gigabytes',-2,'2026-01-24 19:08:09','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:08:11.910238',NULL,'2026-01-23 19:08:11.979247',834,834,'06cf53b820e34c74b5ed6e38f590535c','84260dd6-4ff1-4b6e-9ab3-59f0d7081905',250,'b17f9a502db941108eaa44a3e9aa605c','snapshots',1,'2026-01-24 19:08:11',NULL),('2026-01-23 19:08:11.911574',NULL,'2026-01-23 19:08:11.979247',835,835,'06cf53b820e34c74b5ed6e38f590535c','14df812a-cfe6-4ca5-8b3b-ce0bf52a51f8',251,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',1,'2026-01-24 19:08:11',NULL),('2026-01-23 19:08:11.918824',NULL,'2026-01-23 19:08:11.979247',836,836,NULL,'51225221-f09f-4889-a889-1763ba3624af',252,'b17f9a502db941108eaa44a3e9aa605c','snapshots',1,'2026-01-24 19:08:11','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:11.919918',NULL,'2026-01-23 19:08:11.979247',837,837,NULL,'63e6baa6-25bd-464e-81aa-c88d4882f38a',253,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',1,'2026-01-24 19:08:11','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:12.830636',NULL,'2026-01-23 19:08:12.857844',838,838,'77520b512b09481594399d1d447d3353','6ee87fb9-e066-47a4-8e78-7df86e301a29',222,'998a3a4c23934c4dafb2e2112ce1af90','shares',1,'2026-01-24 19:08:12',NULL),('2026-01-23 19:08:12.831861',NULL,'2026-01-23 19:08:12.857844',839,839,'77520b512b09481594399d1d447d3353','19865679-16a0-41b2-a5f1-b7e76eafeab8',223,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',2,'2026-01-24 19:08:12',NULL),('2026-01-23 19:08:12.838025',NULL,'2026-01-23 19:08:12.857844',840,840,NULL,'f73e1b93-2b22-4ccf-b6f9-ad81439f2442',224,'998a3a4c23934c4dafb2e2112ce1af90','shares',1,'2026-01-24 19:08:12','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:08:12.839181',NULL,'2026-01-23 19:08:12.857844',841,841,NULL,'a9b780e6-cd1b-4faa-8a0d-9620183ffad9',225,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',2,'2026-01-24 19:08:12','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:08:13.001032',NULL,'2026-01-23 19:08:13.032885',842,842,'3deb3c1777d64f18bc9de677a095431d','6fefa339-3970-47c1-976c-9703ec380fab',238,'8548bd568a5448648a2e519eb3ab357a','shares',1,'2026-01-24 19:08:12',NULL),('2026-01-23 19:08:13.002665',NULL,'2026-01-23 19:08:13.032885',843,843,'3deb3c1777d64f18bc9de677a095431d','8bb6c678-cda9-4870-9827-f655f3e472b4',239,'8548bd568a5448648a2e519eb3ab357a','gigabytes',1,'2026-01-24 19:08:12',NULL),('2026-01-23 19:08:13.011553',NULL,'2026-01-23 19:08:13.032885',844,844,NULL,'f662f37a-13ab-4ebf-9b62-0c105b93bae6',240,'8548bd568a5448648a2e519eb3ab357a','shares',1,'2026-01-24 19:08:12','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:08:13.012685',NULL,'2026-01-23 19:08:13.032885',845,845,NULL,'74c04741-9874-4dfd-a637-6d6316e87112',241,'8548bd568a5448648a2e519eb3ab357a','gigabytes',1,'2026-01-24 19:08:12','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:08:16.430429',NULL,'2026-01-23 19:08:16.461481',846,846,'77520b512b09481594399d1d447d3353','174d76d9-6b00-44c2-ab74-22077d9718be',223,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',-1,'2026-01-24 19:08:16',NULL),('2026-01-23 19:08:16.438525',NULL,'2026-01-23 19:08:16.461481',847,847,NULL,'ca27d73c-a9ca-44e1-93b0-f0fa26bcbe7c',225,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',-1,'2026-01-24 19:08:16','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:08:16.507255',NULL,'2026-01-23 19:08:16.527197',848,848,'06cf53b820e34c74b5ed6e38f590535c','ebebca53-8dcf-4f4d-9be7-00f9a6b7ecf1',250,'b17f9a502db941108eaa44a3e9aa605c','snapshots',-1,'2026-01-24 19:08:16',NULL),('2026-01-23 19:08:16.509164',NULL,'2026-01-23 19:08:16.527197',849,849,'06cf53b820e34c74b5ed6e38f590535c','3ca0e364-5418-4cc5-bc5f-d203bb82dfe5',251,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',-1,'2026-01-24 19:08:16',NULL),('2026-01-23 19:08:16.516849',NULL,'2026-01-23 19:08:16.527197',850,850,NULL,'a2b00372-c402-493b-9e59-524c689db82f',252,'b17f9a502db941108eaa44a3e9aa605c','snapshots',-1,'2026-01-24 19:08:16','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:16.517801',NULL,'2026-01-23 19:08:16.527197',851,851,NULL,'6de31ddf-b30a-4a49-8e38-86545ba4cbdd',253,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',-1,'2026-01-24 19:08:16','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:16.976520',NULL,'2026-01-23 19:08:16.991533',852,852,'3deb3c1777d64f18bc9de677a095431d','71257824-f42a-4f33-a821-326b309e330c',238,'8548bd568a5448648a2e519eb3ab357a','shares',-1,'2026-01-24 19:08:16',NULL),('2026-01-23 19:08:16.977309',NULL,'2026-01-23 19:08:16.991533',853,853,'3deb3c1777d64f18bc9de677a095431d','02e55a92-e0ba-47bb-b862-4aa812de013f',239,'8548bd568a5448648a2e519eb3ab357a','gigabytes',-1,'2026-01-24 19:08:16',NULL),('2026-01-23 19:08:16.983872',NULL,'2026-01-23 19:08:16.991533',854,854,NULL,'07664d73-636d-4942-bd91-295bf35bc062',240,'8548bd568a5448648a2e519eb3ab357a','shares',-1,'2026-01-24 19:08:16','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:08:16.984527',NULL,'2026-01-23 19:08:16.991533',855,855,NULL,'7d08d08e-9128-49ec-9ac8-4c4b34d9ad56',241,'8548bd568a5448648a2e519eb3ab357a','gigabytes',-1,'2026-01-24 19:08:16','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:08:19.460196',NULL,'2026-01-23 19:08:19.525238',856,856,'06cf53b820e34c74b5ed6e38f590535c','bcd1ec94-fb70-4d5a-99f3-aa319a773bb2',250,'b17f9a502db941108eaa44a3e9aa605c','snapshots',1,'2026-01-24 19:08:19',NULL),('2026-01-23 19:08:19.461324',NULL,'2026-01-23 19:08:19.525238',857,857,'06cf53b820e34c74b5ed6e38f590535c','561b6aff-8460-4834-a4df-e304757dd3e2',251,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',1,'2026-01-24 19:08:19',NULL),('2026-01-23 19:08:19.467137',NULL,'2026-01-23 19:08:19.525238',858,858,NULL,'ed5ea331-ae5e-4cce-9e4d-bcd8553f873d',252,'b17f9a502db941108eaa44a3e9aa605c','snapshots',1,'2026-01-24 19:08:19','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:19.468507',NULL,'2026-01-23 19:08:19.525238',859,859,NULL,'31a3e9bf-af55-49e1-9674-146dafdff14c',253,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',1,'2026-01-24 19:08:19','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:19.944744',NULL,'2026-01-23 19:08:19.962202',860,860,'77520b512b09481594399d1d447d3353','d4a51aed-99ee-442f-89c2-5a5939926740',222,'998a3a4c23934c4dafb2e2112ce1af90','shares',-1,'2026-01-24 19:08:19',NULL),('2026-01-23 19:08:19.945685',NULL,'2026-01-23 19:08:19.962202',861,861,'77520b512b09481594399d1d447d3353','e438df67-b3a6-4f09-8a4b-93512adc86e4',223,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',-1,'2026-01-24 19:08:19',NULL),('2026-01-23 19:08:19.951499',NULL,'2026-01-23 19:08:19.962202',862,862,NULL,'01111b7b-d014-4022-a7b4-0336730ebe7e',224,'998a3a4c23934c4dafb2e2112ce1af90','shares',-1,'2026-01-24 19:08:19','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:08:19.952324',NULL,'2026-01-23 19:08:19.962202',863,863,NULL,'d1d05d60-dd81-4f03-a3f0-98630f57390c',225,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',-1,'2026-01-24 19:08:19','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:08:20.020273',NULL,'2026-01-23 19:08:20.056035',864,864,'3deb3c1777d64f18bc9de677a095431d','c446dcbb-0add-473c-ab7a-53ae86d7a2c1',238,'8548bd568a5448648a2e519eb3ab357a','shares',1,'2026-01-24 19:08:19',NULL),('2026-01-23 19:08:20.021391',NULL,'2026-01-23 19:08:20.056035',865,865,'3deb3c1777d64f18bc9de677a095431d','91d7f3ef-b262-4d1f-81a3-c8176f898f10',239,'8548bd568a5448648a2e519eb3ab357a','gigabytes',1,'2026-01-24 19:08:19',NULL),('2026-01-23 19:08:20.030482',NULL,'2026-01-23 19:08:20.056035',866,866,NULL,'8d878bfc-5c69-42b9-b6b5-5fea14c0395c',240,'8548bd568a5448648a2e519eb3ab357a','shares',1,'2026-01-24 19:08:19','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:08:20.033667',NULL,'2026-01-23 19:08:20.056035',867,867,NULL,'98f7aa69-7b65-4057-bcfb-119e4ea7ce02',241,'8548bd568a5448648a2e519eb3ab357a','gigabytes',1,'2026-01-24 19:08:19','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:08:22.920575',NULL,'2026-01-23 19:08:23.013023',868,868,'77520b512b09481594399d1d447d3353','24bd5123-0eb2-483e-89d3-b729d98cf7bd',222,'998a3a4c23934c4dafb2e2112ce1af90','shares',1,'2026-01-24 19:08:22',NULL),('2026-01-23 19:08:22.921816',NULL,'2026-01-23 19:08:23.013023',869,869,'77520b512b09481594399d1d447d3353','79c699aa-08a9-4c63-9950-14e2278a54f9',223,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',1,'2026-01-24 19:08:22',NULL),('2026-01-23 19:08:22.927898',NULL,'2026-01-23 19:08:23.013023',870,870,NULL,'d3af24ab-9b3e-4fa9-a081-32055a0e600c',224,'998a3a4c23934c4dafb2e2112ce1af90','shares',1,'2026-01-24 19:08:22','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:08:22.928977',NULL,'2026-01-23 19:08:23.013023',871,871,NULL,'2e63d0ca-7518-48ec-b08e-c88bd57828f7',225,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',1,'2026-01-24 19:08:22','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:08:24.100509',NULL,'2026-01-23 19:08:24.179149',872,872,'3deb3c1777d64f18bc9de677a095431d','3ab5315a-90ff-42ab-9a64-a5a8de715af2',238,'8548bd568a5448648a2e519eb3ab357a','shares',-1,'2026-01-24 19:08:24',NULL),('2026-01-23 19:08:24.101210',NULL,'2026-01-23 19:08:24.179149',873,873,'3deb3c1777d64f18bc9de677a095431d','e950718b-44c1-43d4-96b8-c969ccff2861',239,'8548bd568a5448648a2e519eb3ab357a','gigabytes',-1,'2026-01-24 19:08:24',NULL),('2026-01-23 19:08:24.148679',NULL,'2026-01-23 19:08:24.179149',874,874,NULL,'553aad9b-67ba-4c3a-a8b9-4d00dbcf66ef',240,'8548bd568a5448648a2e519eb3ab357a','shares',-1,'2026-01-24 19:08:24','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:08:24.149636',NULL,'2026-01-23 19:08:24.179149',875,875,NULL,'4bf210c5-b5c0-4688-9072-38e9ff8e6bd6',241,'8548bd568a5448648a2e519eb3ab357a','gigabytes',-1,'2026-01-24 19:08:24','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:08:24.352156',NULL,'2026-01-23 19:08:24.369890',876,876,'06cf53b820e34c74b5ed6e38f590535c','812976cd-b7e9-49fe-992d-89dffa4a1cc6',250,'b17f9a502db941108eaa44a3e9aa605c','snapshots',-1,'2026-01-24 19:08:24',NULL),('2026-01-23 19:08:24.353172',NULL,'2026-01-23 19:08:24.369890',877,877,'06cf53b820e34c74b5ed6e38f590535c','a04773f9-5c6f-4f3a-a072-405161c59660',251,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',-1,'2026-01-24 19:08:24',NULL),('2026-01-23 19:08:24.361032',NULL,'2026-01-23 19:08:24.369890',878,878,NULL,'cd8b5e40-4a4c-4224-bafb-e317282fd0b9',252,'b17f9a502db941108eaa44a3e9aa605c','snapshots',-1,'2026-01-24 19:08:24','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:24.361821',NULL,'2026-01-23 19:08:24.369890',879,879,NULL,'19fbad7c-c2bf-4754-b885-b28a30a16325',253,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',-1,'2026-01-24 19:08:24','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:27.176258',NULL,'2026-01-23 19:08:27.209189',880,880,'3deb3c1777d64f18bc9de677a095431d','eed09a51-adaf-4499-b091-a29aaa0433a6',238,'8548bd568a5448648a2e519eb3ab357a','shares',1,'2026-01-24 19:08:27',NULL),('2026-01-23 19:08:27.177789',NULL,'2026-01-23 19:08:27.209189',881,881,'3deb3c1777d64f18bc9de677a095431d','849b3fbe-b9e5-4746-919b-fcd35a7bd641',239,'8548bd568a5448648a2e519eb3ab357a','gigabytes',1,'2026-01-24 19:08:27',NULL),('2026-01-23 19:08:27.183912',NULL,'2026-01-23 19:08:27.209189',882,882,NULL,'6bdff7bb-db88-461c-9253-c0793bff5780',240,'8548bd568a5448648a2e519eb3ab357a','shares',1,'2026-01-24 19:08:27','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:08:27.185325',NULL,'2026-01-23 19:08:27.209189',883,883,NULL,'c5c2781a-dd98-424d-ae85-ff24f5b623c6',241,'8548bd568a5448648a2e519eb3ab357a','gigabytes',1,'2026-01-24 19:08:27','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:08:27.449173',NULL,'2026-01-23 19:08:27.527337',884,884,'06cf53b820e34c74b5ed6e38f590535c','56678320-bd39-4c0f-a79f-f6c862178248',250,'b17f9a502db941108eaa44a3e9aa605c','snapshots',1,'2026-01-24 19:08:27',NULL),('2026-01-23 19:08:27.450386',NULL,'2026-01-23 19:08:27.527337',885,885,'06cf53b820e34c74b5ed6e38f590535c','325e25d1-dc83-4922-9e7a-1ab76c832109',251,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',1,'2026-01-24 19:08:27',NULL),('2026-01-23 19:08:27.456549',NULL,'2026-01-23 19:08:27.527337',886,886,NULL,'00ee48f4-114b-43d7-8479-3093ba0ea3c4',252,'b17f9a502db941108eaa44a3e9aa605c','snapshots',1,'2026-01-24 19:08:27','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:27.457779',NULL,'2026-01-23 19:08:27.527337',887,887,NULL,'5a2d5866-4222-4438-9b73-ad148c6160b8',253,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',1,'2026-01-24 19:08:27','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:28.086013',NULL,'2026-01-23 19:08:28.101565',888,888,'77520b512b09481594399d1d447d3353','3c60299c-a429-4c27-a839-f78e2d36ef44',222,'998a3a4c23934c4dafb2e2112ce1af90','shares',-1,'2026-01-24 19:08:28',NULL),('2026-01-23 19:08:28.086736',NULL,'2026-01-23 19:08:28.101565',889,889,'77520b512b09481594399d1d447d3353','11afd7ec-12fc-4151-a4da-5351bbdaad7c',223,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',-1,'2026-01-24 19:08:28',NULL),('2026-01-23 19:08:28.091618',NULL,'2026-01-23 19:08:28.101565',890,890,NULL,'d280d772-96e4-484f-b5ac-4c1b22643a95',224,'998a3a4c23934c4dafb2e2112ce1af90','shares',-1,'2026-01-24 19:08:28','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:08:28.092347',NULL,'2026-01-23 19:08:28.101565',891,891,NULL,'3d1de4f7-ac8e-46b9-985d-8f041076028c',225,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',-1,'2026-01-24 19:08:28','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:08:32.384348',NULL,'2026-01-23 19:08:32.461038',892,892,'06cf53b820e34c74b5ed6e38f590535c','258769e7-ba6f-4506-a404-a08a632f6cc0',250,'b17f9a502db941108eaa44a3e9aa605c','snapshots',-1,'2026-01-24 19:08:32',NULL),('2026-01-23 19:08:32.385935',NULL,'2026-01-23 19:08:32.461038',893,893,'06cf53b820e34c74b5ed6e38f590535c','3edfbdbb-eb40-438f-8fd7-bf4eaa5dbc64',251,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',-1,'2026-01-24 19:08:32',NULL),('2026-01-23 19:08:32.391816',NULL,'2026-01-23 19:08:32.489641',894,894,'77520b512b09481594399d1d447d3353','2e5c0a66-6bcd-46a0-a8d9-9532c3a467d3',222,'998a3a4c23934c4dafb2e2112ce1af90','shares',-1,'2026-01-24 19:08:32',NULL),('2026-01-23 19:08:32.394292',NULL,'2026-01-23 19:08:32.489641',895,895,'77520b512b09481594399d1d447d3353','ed7dec00-223f-48b6-81c8-1049a230de92',223,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',-1,'2026-01-24 19:08:32',NULL),('2026-01-23 19:08:32.401173',NULL,'2026-01-23 19:08:32.461038',896,896,NULL,'b929d088-aecb-4e32-893a-90f7f4c573e8',252,'b17f9a502db941108eaa44a3e9aa605c','snapshots',-1,'2026-01-24 19:08:32','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:32.402143',NULL,'2026-01-23 19:08:32.461038',897,897,NULL,'3839169d-e9a1-478f-9460-ab092faf5f3e',253,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',-1,'2026-01-24 19:08:32','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:32.445541',NULL,'2026-01-23 19:08:32.489641',898,898,NULL,'f798e2b9-80a8-42a1-8941-72088f04c4fa',224,'998a3a4c23934c4dafb2e2112ce1af90','shares',-1,'2026-01-24 19:08:32','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:08:32.456032',NULL,'2026-01-23 19:08:32.489641',899,899,NULL,'c3a2999b-01d2-4e38-b439-a171dbabace7',225,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',-1,'2026-01-24 19:08:32','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:08:32.539687',NULL,'2026-01-23 19:08:32.663833',900,900,'3deb3c1777d64f18bc9de677a095431d','1c9db047-cb14-43f9-9d5f-04b200727494',238,'8548bd568a5448648a2e519eb3ab357a','shares',-1,'2026-01-24 19:08:32',NULL),('2026-01-23 19:08:32.541507',NULL,'2026-01-23 19:08:32.663833',901,901,'3deb3c1777d64f18bc9de677a095431d','19dcc3c9-4044-4750-bab9-92c746567ce9',239,'8548bd568a5448648a2e519eb3ab357a','gigabytes',-1,'2026-01-24 19:08:32',NULL),('2026-01-23 19:08:32.642310',NULL,'2026-01-23 19:08:32.663833',902,902,NULL,'85b39f86-b3bb-4335-afd8-68a703511d92',240,'8548bd568a5448648a2e519eb3ab357a','shares',-1,'2026-01-24 19:08:32','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:08:32.643160',NULL,'2026-01-23 19:08:32.663833',903,903,NULL,'78b61681-f62a-45bf-8afb-1ba824c87fa5',241,'8548bd568a5448648a2e519eb3ab357a','gigabytes',-1,'2026-01-24 19:08:32','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:08:34.621639',NULL,'2026-01-23 19:08:34.702703',904,904,'06cf53b820e34c74b5ed6e38f590535c','1f702efb-e482-4350-a2e5-da7f645cbe70',250,'b17f9a502db941108eaa44a3e9aa605c','snapshots',1,'2026-01-24 19:08:34',NULL),('2026-01-23 19:08:34.623051',NULL,'2026-01-23 19:08:34.702703',905,905,'06cf53b820e34c74b5ed6e38f590535c','72469205-da27-40a1-9346-0e1fe7597fb1',251,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',1,'2026-01-24 19:08:34',NULL),('2026-01-23 19:08:34.629748',NULL,'2026-01-23 19:08:34.702703',906,906,NULL,'07fdbaab-0a16-40fd-8cc4-31b98df9180f',252,'b17f9a502db941108eaa44a3e9aa605c','snapshots',1,'2026-01-24 19:08:34','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:34.631142',NULL,'2026-01-23 19:08:34.702703',907,907,NULL,'329158fb-5ef7-416d-82f4-d405855549d8',253,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',1,'2026-01-24 19:08:34','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:35.074598',NULL,'2026-01-23 19:08:35.107651',908,908,'77520b512b09481594399d1d447d3353','3179ab58-3b75-4833-ae2e-f9011367cb90',226,'998a3a4c23934c4dafb2e2112ce1af90','snapshots',-1,'2026-01-24 19:08:35',NULL),('2026-01-23 19:08:35.075369',NULL,'2026-01-23 19:08:35.107651',909,909,'77520b512b09481594399d1d447d3353','4ae81c8d-10b9-42de-8797-d252ee3eb167',227,'998a3a4c23934c4dafb2e2112ce1af90','snapshot_gigabytes',-1,'2026-01-24 19:08:35',NULL),('2026-01-23 19:08:35.097033',NULL,'2026-01-23 19:08:35.107651',910,910,NULL,'a5ecf9d0-399f-48b5-9149-5c14d5f12420',228,'998a3a4c23934c4dafb2e2112ce1af90','snapshots',-1,'2026-01-24 19:08:35','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:08:35.098383',NULL,'2026-01-23 19:08:35.107651',911,911,NULL,'dca10cbd-0e30-4729-8b27-681ba2f32a22',229,'998a3a4c23934c4dafb2e2112ce1af90','snapshot_gigabytes',-1,'2026-01-24 19:08:35','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:08:35.874845',NULL,'2026-01-23 19:08:35.891517',912,912,'3deb3c1777d64f18bc9de677a095431d','4abe173a-a1b1-4e47-a9aa-7d5ec420d981',242,'8548bd568a5448648a2e519eb3ab357a','snapshots',-1,'2026-01-24 19:08:35',NULL),('2026-01-23 19:08:35.875698',NULL,'2026-01-23 19:08:35.891517',913,913,'3deb3c1777d64f18bc9de677a095431d','eccad344-c706-4a60-8d44-6542718e4c6c',243,'8548bd568a5448648a2e519eb3ab357a','snapshot_gigabytes',-1,'2026-01-24 19:08:35',NULL),('2026-01-23 19:08:35.881803',NULL,'2026-01-23 19:08:35.891517',914,914,NULL,'226b6efa-bbbb-42aa-8a21-671e927dcde0',244,'8548bd568a5448648a2e519eb3ab357a','snapshots',-1,'2026-01-24 19:08:35','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:08:35.883472',NULL,'2026-01-23 19:08:35.891517',915,915,NULL,'2199149a-136b-44f5-9df9-7c8708217342',245,'8548bd568a5448648a2e519eb3ab357a','snapshot_gigabytes',-1,'2026-01-24 19:08:35','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:08:38.531150',NULL,'2026-01-23 19:08:38.566165',916,916,'77520b512b09481594399d1d447d3353','9aecfd0f-fd0c-489a-9f58-cae546659ef7',222,'998a3a4c23934c4dafb2e2112ce1af90','shares',-1,'2026-01-24 19:08:38',NULL),('2026-01-23 19:08:38.531897',NULL,'2026-01-23 19:08:38.566165',917,917,'77520b512b09481594399d1d447d3353','76e05e29-c65d-4c59-941f-a72fc265a7de',223,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',-1,'2026-01-24 19:08:38',NULL),('2026-01-23 19:08:38.557649',NULL,'2026-01-23 19:08:38.566165',918,918,NULL,'9a3cabef-9c37-4b7c-80c1-084811e4231f',224,'998a3a4c23934c4dafb2e2112ce1af90','shares',-1,'2026-01-24 19:08:38','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:08:38.558588',NULL,'2026-01-23 19:08:38.566165',919,919,NULL,'fc899b54-5b2f-470a-ae82-b9f09a4d7bd4',225,'998a3a4c23934c4dafb2e2112ce1af90','gigabytes',-1,'2026-01-24 19:08:38','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0'),('2026-01-23 19:08:39.233127',NULL,'2026-01-23 19:08:39.257869',920,920,'3deb3c1777d64f18bc9de677a095431d','d35c4df2-9fc9-4300-95f1-e02c10a689c5',238,'8548bd568a5448648a2e519eb3ab357a','shares',-1,'2026-01-24 19:08:39',NULL),('2026-01-23 19:08:39.234320',NULL,'2026-01-23 19:08:39.257869',921,921,'3deb3c1777d64f18bc9de677a095431d','0327651c-2639-4e92-bf28-a24d01b9501d',239,'8548bd568a5448648a2e519eb3ab357a','gigabytes',-1,'2026-01-24 19:08:39',NULL),('2026-01-23 19:08:39.246261',NULL,'2026-01-23 19:08:39.257869',922,922,NULL,'be9a00e7-35cb-4b81-b359-17cc008d7feb',240,'8548bd568a5448648a2e519eb3ab357a','shares',-1,'2026-01-24 19:08:39','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:08:39.247213',NULL,'2026-01-23 19:08:39.257869',923,923,NULL,'eee52b75-4646-496b-861d-7db1193179ba',241,'8548bd568a5448648a2e519eb3ab357a','gigabytes',-1,'2026-01-24 19:08:39','ae9b0b0a-11bb-4691-b72a-a62b561e3b36'),('2026-01-23 19:08:40.586436',NULL,'2026-01-23 19:08:40.751364',924,924,'06cf53b820e34c74b5ed6e38f590535c','0307ad75-5c92-4075-b373-ab12601b750b',250,'b17f9a502db941108eaa44a3e9aa605c','snapshots',-1,'2026-01-24 19:08:40',NULL),('2026-01-23 19:08:40.587053',NULL,'2026-01-23 19:08:40.751364',925,925,'06cf53b820e34c74b5ed6e38f590535c','4d91ddd8-6c88-41a7-b8a3-2835b39095fd',251,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',-1,'2026-01-24 19:08:40',NULL),('2026-01-23 19:08:40.737487',NULL,'2026-01-23 19:08:40.751364',926,926,NULL,'6cd0430c-ead6-4e62-819f-7f12b675a8d0',252,'b17f9a502db941108eaa44a3e9aa605c','snapshots',-1,'2026-01-24 19:08:40','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:40.738506',NULL,'2026-01-23 19:08:40.751364',927,927,NULL,'7f6e98e4-6fac-4597-8461-f63ee43c39e5',253,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',-1,'2026-01-24 19:08:40','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:45.429456',NULL,'2026-01-23 19:08:45.618858',928,928,'06cf53b820e34c74b5ed6e38f590535c','182869e1-56ee-4f9e-8165-d3c8a5c48d8c',250,'b17f9a502db941108eaa44a3e9aa605c','snapshots',1,'2026-01-24 19:08:45',NULL),('2026-01-23 19:08:45.431063',NULL,'2026-01-23 19:08:45.618858',929,929,'06cf53b820e34c74b5ed6e38f590535c','12a69aa7-18ee-4e35-91cd-593dc63b56be',251,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',1,'2026-01-24 19:08:45',NULL),('2026-01-23 19:08:45.500490',NULL,'2026-01-23 19:08:45.618858',930,930,NULL,'e243b3a7-1846-4a10-82ef-d342b015e79f',252,'b17f9a502db941108eaa44a3e9aa605c','snapshots',1,'2026-01-24 19:08:45','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:45.501920',NULL,'2026-01-23 19:08:45.618858',931,931,NULL,'fc038e54-de30-48d9-be5f-22a43affd18b',253,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',1,'2026-01-24 19:08:45','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:50.611710',NULL,'2026-01-23 19:08:50.701797',932,932,'9387f9e13c974a7b9c7352ead07a670a','de1b4775-dd0f-43eb-94ba-575481590642',254,'25ab22f3f2214f1685af23b1e9f04ebe','shares',1,'2026-01-24 19:08:50',NULL),('2026-01-23 19:08:50.614002',NULL,'2026-01-23 19:08:50.701797',933,933,'9387f9e13c974a7b9c7352ead07a670a','e649270d-c450-498f-918f-10d581924f38',255,'25ab22f3f2214f1685af23b1e9f04ebe','gigabytes',1,'2026-01-24 19:08:50',NULL),('2026-01-23 19:08:50.645633',NULL,'2026-01-23 19:08:50.701797',934,934,NULL,'6cde0d22-3c37-47fc-8cad-5eed1c766188',256,'25ab22f3f2214f1685af23b1e9f04ebe','shares',1,'2026-01-24 19:08:50','9d06412d-874f-45c2-b39d-2192c8184009'),('2026-01-23 19:08:50.646797',NULL,'2026-01-23 19:08:50.701797',935,935,NULL,'8151b373-6e50-4bc2-be7d-4d9783009b14',257,'25ab22f3f2214f1685af23b1e9f04ebe','gigabytes',1,'2026-01-24 19:08:50','9d06412d-874f-45c2-b39d-2192c8184009'),('2026-01-23 19:08:51.560591',NULL,'2026-01-23 19:08:51.580571',936,936,'06cf53b820e34c74b5ed6e38f590535c','50b98278-53ab-4b8d-887b-24ab76180507',250,'b17f9a502db941108eaa44a3e9aa605c','snapshots',-1,'2026-01-24 19:08:51',NULL),('2026-01-23 19:08:51.561285',NULL,'2026-01-23 19:08:51.580571',937,937,'06cf53b820e34c74b5ed6e38f590535c','e48f9214-4d88-470e-bf3d-ef1636b5a20d',251,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',-1,'2026-01-24 19:08:51',NULL),('2026-01-23 19:08:51.568044',NULL,'2026-01-23 19:08:51.580571',938,938,NULL,'2613bfb2-3cf9-4809-a0a0-21e74db4d84b',252,'b17f9a502db941108eaa44a3e9aa605c','snapshots',-1,'2026-01-24 19:08:51','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:51.570653',NULL,'2026-01-23 19:08:51.580571',939,939,NULL,'90213dd7-0a1d-4f49-a371-cd687332973b',253,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',-1,'2026-01-24 19:08:51','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:54.047562',NULL,'2026-01-23 19:08:54.127706',940,940,'9387f9e13c974a7b9c7352ead07a670a','8bdd537c-1d35-42c7-bcca-2701cc5bfc5e',258,'25ab22f3f2214f1685af23b1e9f04ebe','snapshots',1,'2026-01-24 19:08:54',NULL),('2026-01-23 19:08:54.048844',NULL,'2026-01-23 19:08:54.127706',941,941,'9387f9e13c974a7b9c7352ead07a670a','8199990d-3be8-4557-80f2-4cbfcec8bef2',259,'25ab22f3f2214f1685af23b1e9f04ebe','snapshot_gigabytes',1,'2026-01-24 19:08:54',NULL),('2026-01-23 19:08:54.064273',NULL,'2026-01-23 19:08:54.127706',942,942,NULL,'98f29014-ee1e-411a-82cd-7889f1d93fdd',260,'25ab22f3f2214f1685af23b1e9f04ebe','snapshots',1,'2026-01-24 19:08:54','9d06412d-874f-45c2-b39d-2192c8184009'),('2026-01-23 19:08:54.065331',NULL,'2026-01-23 19:08:54.127706',943,943,NULL,'5a287f46-e045-499c-ab2e-095593237811',261,'25ab22f3f2214f1685af23b1e9f04ebe','snapshot_gigabytes',1,'2026-01-24 19:08:54','9d06412d-874f-45c2-b39d-2192c8184009'),('2026-01-23 19:08:57.780888',NULL,'2026-01-23 19:08:57.823503',944,944,'06cf53b820e34c74b5ed6e38f590535c','741bcbd1-ba07-4e06-8906-9288e416d966',250,'b17f9a502db941108eaa44a3e9aa605c','snapshots',-1,'2026-01-24 19:08:57',NULL),('2026-01-23 19:08:57.782007',NULL,'2026-01-23 19:08:57.823503',945,945,'06cf53b820e34c74b5ed6e38f590535c','10e68332-92f0-470e-89e2-74090aafcf6d',251,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',-1,'2026-01-24 19:08:57',NULL),('2026-01-23 19:08:57.796330',NULL,'2026-01-23 19:08:57.823503',946,946,NULL,'bc089502-a307-4ecc-a841-2530fd48e5e2',252,'b17f9a502db941108eaa44a3e9aa605c','snapshots',-1,'2026-01-24 19:08:57','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:57.797281',NULL,'2026-01-23 19:08:57.823503',947,947,NULL,'a35ac76e-8ae6-4c05-aeb4-c5d9881f2984',253,'b17f9a502db941108eaa44a3e9aa605c','snapshot_gigabytes',-1,'2026-01-24 19:08:57','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:08:59.090614',NULL,'2026-01-23 19:08:59.109816',948,948,'9387f9e13c974a7b9c7352ead07a670a','2a86fb86-8747-482f-bc17-49202c15824f',258,'25ab22f3f2214f1685af23b1e9f04ebe','snapshots',-1,'2026-01-24 19:08:59',NULL),('2026-01-23 19:08:59.091439',NULL,'2026-01-23 19:08:59.109816',949,949,'9387f9e13c974a7b9c7352ead07a670a','3f3f7713-a860-465e-bc8c-59b56b3f9b1d',259,'25ab22f3f2214f1685af23b1e9f04ebe','snapshot_gigabytes',-1,'2026-01-24 19:08:59',NULL),('2026-01-23 19:08:59.098040',NULL,'2026-01-23 19:08:59.109816',950,950,NULL,'c65cbeef-dfd8-4881-be1e-3246b41f4353',260,'25ab22f3f2214f1685af23b1e9f04ebe','snapshots',-1,'2026-01-24 19:08:59','9d06412d-874f-45c2-b39d-2192c8184009'),('2026-01-23 19:08:59.099223',NULL,'2026-01-23 19:08:59.109816',951,951,NULL,'9348d4c9-53bf-470c-97cc-020c8fb8d8d4',261,'25ab22f3f2214f1685af23b1e9f04ebe','snapshot_gigabytes',-1,'2026-01-24 19:08:59','9d06412d-874f-45c2-b39d-2192c8184009'),('2026-01-23 19:09:01.207724',NULL,'2026-01-23 19:09:01.319174',952,952,'06cf53b820e34c74b5ed6e38f590535c','62efc0e2-f40a-4380-8080-db1fa54b0ad9',246,'b17f9a502db941108eaa44a3e9aa605c','shares',-1,'2026-01-24 19:09:01',NULL),('2026-01-23 19:09:01.208624',NULL,'2026-01-23 19:09:01.319174',953,953,'06cf53b820e34c74b5ed6e38f590535c','03afd6b1-5c9d-4972-a073-c50a25eafc5e',247,'b17f9a502db941108eaa44a3e9aa605c','gigabytes',-1,'2026-01-24 19:09:01',NULL),('2026-01-23 19:09:01.304944',NULL,'2026-01-23 19:09:01.319174',954,954,NULL,'d507b5ce-7cc0-486b-ab0e-bd15cfe33afa',248,'b17f9a502db941108eaa44a3e9aa605c','shares',-1,'2026-01-24 19:09:01','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:09:01.306485',NULL,'2026-01-23 19:09:01.319174',955,955,NULL,'95a370d9-ed18-4833-91e2-ab141cf92b8c',249,'b17f9a502db941108eaa44a3e9aa605c','gigabytes',-1,'2026-01-24 19:09:01','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d'),('2026-01-23 19:09:02.758042',NULL,'2026-01-23 19:09:02.893553',956,956,'9387f9e13c974a7b9c7352ead07a670a','c1727739-c6d1-4e8b-8470-6d000b694261',254,'25ab22f3f2214f1685af23b1e9f04ebe','shares',-1,'2026-01-24 19:09:02',NULL),('2026-01-23 19:09:02.758991',NULL,'2026-01-23 19:09:02.893553',957,957,'9387f9e13c974a7b9c7352ead07a670a','ac3366b4-aedb-446b-a2fc-e9f5052678ac',255,'25ab22f3f2214f1685af23b1e9f04ebe','gigabytes',-1,'2026-01-24 19:09:02',NULL),('2026-01-23 19:09:02.829608',NULL,'2026-01-23 19:09:02.893553',958,958,NULL,'66c712e3-60a6-4d72-9987-31420f2ddd8f',256,'25ab22f3f2214f1685af23b1e9f04ebe','shares',-1,'2026-01-24 19:09:02','9d06412d-874f-45c2-b39d-2192c8184009'),('2026-01-23 19:09:02.830309',NULL,'2026-01-23 19:09:02.893553',959,959,NULL,'57bea924-594e-46c8-b108-5ff5679bc47f',257,'25ab22f3f2214f1685af23b1e9f04ebe','gigabytes',-1,'2026-01-24 19:09:02','9d06412d-874f-45c2-b39d-2192c8184009'),('2026-01-23 19:09:33.505507',NULL,'2026-01-23 19:09:33.684116',960,960,'a622f76c64c643c1904e54c2dde49e5a','fc48330e-08f7-49e8-b5af-ba4c4e4ba5a2',262,'07e698407b254151a7a1ba401f6bb52e','shares',1,'2026-01-24 19:09:33',NULL),('2026-01-23 19:09:33.508131',NULL,'2026-01-23 19:09:33.684116',961,961,'a622f76c64c643c1904e54c2dde49e5a','ee1f0ff8-8835-40f2-a356-4ea585200d84',263,'07e698407b254151a7a1ba401f6bb52e','gigabytes',1,'2026-01-24 19:09:33',NULL),('2026-01-23 19:09:33.523273',NULL,'2026-01-23 19:09:33.684116',962,962,NULL,'e5b18c1f-e883-48e1-bb5f-ab02650ff0da',264,'07e698407b254151a7a1ba401f6bb52e','shares',1,'2026-01-24 19:09:33','7d583f94-a44a-47c6-b6fb-99c2483a84cb'),('2026-01-23 19:09:33.525389',NULL,'2026-01-23 19:09:33.684116',963,963,NULL,'d840e5ca-f1bb-49c8-bc4b-907e16a2ba20',265,'07e698407b254151a7a1ba401f6bb52e','gigabytes',1,'2026-01-24 19:09:33','7d583f94-a44a-47c6-b6fb-99c2483a84cb'),('2026-01-23 19:09:37.108954',NULL,'2026-01-23 19:09:37.203593',964,964,'a622f76c64c643c1904e54c2dde49e5a','2ccc5a0e-7c56-4e84-a755-62253a6ad528',266,'07e698407b254151a7a1ba401f6bb52e','snapshots',1,'2026-01-24 19:09:37',NULL),('2026-01-23 19:09:37.110627',NULL,'2026-01-23 19:09:37.203593',965,965,'a622f76c64c643c1904e54c2dde49e5a','f156b760-f054-4e82-9bb9-4d2122f59667',267,'07e698407b254151a7a1ba401f6bb52e','snapshot_gigabytes',1,'2026-01-24 19:09:37',NULL),('2026-01-23 19:09:37.134614',NULL,'2026-01-23 19:09:37.203593',966,966,NULL,'9547ffd0-3a8a-4e97-9f82-26b518f0cee2',268,'07e698407b254151a7a1ba401f6bb52e','snapshots',1,'2026-01-24 19:09:37','7d583f94-a44a-47c6-b6fb-99c2483a84cb'),('2026-01-23 19:09:37.136129',NULL,'2026-01-23 19:09:37.203593',967,967,NULL,'67a1605c-1dd4-4437-801c-bd82bead6a3b',269,'07e698407b254151a7a1ba401f6bb52e','snapshot_gigabytes',1,'2026-01-24 19:09:37','7d583f94-a44a-47c6-b6fb-99c2483a84cb'),('2026-01-23 19:09:42.947640',NULL,'2026-01-23 19:09:42.979825',968,968,'a622f76c64c643c1904e54c2dde49e5a','ff0916ac-9e3d-41ed-a592-67ce3c764177',266,'07e698407b254151a7a1ba401f6bb52e','snapshots',-1,'2026-01-24 19:09:42',NULL),('2026-01-23 19:09:42.948806',NULL,'2026-01-23 19:09:42.979825',969,969,'a622f76c64c643c1904e54c2dde49e5a','634bd912-0b63-4e52-bd4a-fa668769e822',267,'07e698407b254151a7a1ba401f6bb52e','snapshot_gigabytes',-1,'2026-01-24 19:09:42',NULL),('2026-01-23 19:09:42.967188',NULL,'2026-01-23 19:09:42.979825',970,970,NULL,'1508af06-92f1-419e-9157-b18b67b64a4a',268,'07e698407b254151a7a1ba401f6bb52e','snapshots',-1,'2026-01-24 19:09:42','7d583f94-a44a-47c6-b6fb-99c2483a84cb'),('2026-01-23 19:09:42.968252',NULL,'2026-01-23 19:09:42.979825',971,971,NULL,'5e06af9b-c291-4b22-838f-e6301da73b64',269,'07e698407b254151a7a1ba401f6bb52e','snapshot_gigabytes',-1,'2026-01-24 19:09:42','7d583f94-a44a-47c6-b6fb-99c2483a84cb'),('2026-01-23 19:09:46.419730',NULL,'2026-01-23 19:09:46.434013',972,972,'a622f76c64c643c1904e54c2dde49e5a','40a5336c-0887-4e60-a72f-4faa0b0b8161',262,'07e698407b254151a7a1ba401f6bb52e','shares',-1,'2026-01-24 19:09:46',NULL),('2026-01-23 19:09:46.420518',NULL,'2026-01-23 19:09:46.434013',973,973,'a622f76c64c643c1904e54c2dde49e5a','36ffc17f-9be9-4c83-92c0-4b7907f9978c',263,'07e698407b254151a7a1ba401f6bb52e','gigabytes',-1,'2026-01-24 19:09:46',NULL),('2026-01-23 19:09:46.426391',NULL,'2026-01-23 19:09:46.434013',974,974,NULL,'f2afbba2-d4a2-4a6f-a312-8af3886165d8',264,'07e698407b254151a7a1ba401f6bb52e','shares',-1,'2026-01-24 19:09:46','7d583f94-a44a-47c6-b6fb-99c2483a84cb'),('2026-01-23 19:09:46.427064',NULL,'2026-01-23 19:09:46.434013',975,975,NULL,'ef83a1a0-60b5-4dfd-86bb-08ee8b9922d9',265,'07e698407b254151a7a1ba401f6bb52e','gigabytes',-1,'2026-01-24 19:09:46','7d583f94-a44a-47c6-b6fb-99c2483a84cb');
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `security_services`
--

DROP TABLE IF EXISTS `security_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `security_services` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `type` varchar(32) NOT NULL,
  `dns_ip` varchar(64) DEFAULT NULL,
  `server` varchar(255) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `user` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `ou` varchar(255) DEFAULT NULL,
  `default_ad_site` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `security_services`
--

LOCK TABLES `security_services` WRITE;
/*!40000 ALTER TABLE `security_services` DISABLE KEYS */;
INSERT INTO `security_services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `type`, `dns_ip`, `server`, `domain`, `user`, `password`, `name`, `description`, `ou`, `default_ad_site`) VALUES ('2026-01-23 19:05:43.423514','2026-01-23 19:05:43.932225','2026-01-23 19:05:43.931627','07ed9d6d-f858-4bde-a0b7-11162f844161','07ed9d6d-f858-4bde-a0b7-11162f844161','283b89301a234374a4dbf7307759750d','ldap','203.0.113.83','203.0.113.160','tempest-ss-domain-192676406','tempest-ss-user-1563082071','tempest-ss-password-1715656994','tempest-ss-name-1571542681','tempest-ss-desc-1225832647',NULL,NULL),('2026-01-23 19:00:36.094008','2026-01-23 19:00:36.530182','2026-01-23 19:00:36.529815','0bb74107-f8d3-441d-b5dd-c87d752bdcae','0bb74107-f8d3-441d-b5dd-c87d752bdcae','c05ab92b2e7d4b60ac9797fc95883ada','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2026-01-23 19:05:41.277802',NULL,NULL,'False','0ed2df46-da6c-4394-b016-af9f3ae54804','283b89301a234374a4dbf7307759750d','ldap',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:05:13.796120','2026-01-23 19:05:13.964597','2026-01-23 19:05:13.964089','14444c78-51da-4032-9f9f-639ebcb76696','14444c78-51da-4032-9f9f-639ebcb76696','430cf4fee1e04b8f9326ebd6ea4e5a72','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-23 19:05:44.440263','2026-01-23 19:05:44.669869','2026-01-23 19:05:44.669542','1b072ae8-5bca-4b96-87fa-2b6d6d850f51','1b072ae8-5bca-4b96-87fa-2b6d6d850f51','283b89301a234374a4dbf7307759750d','ldap','203.0.113.94','203.0.113.142','tempest-ss-domain-531338293','tempest-ss-user-1877291621','tempest-ss-password-241753147','tempest-ss-name-1145140448','tempest-ss-desc-1784557493',NULL,NULL),('2026-01-23 19:05:22.093018','2026-01-23 19:05:22.205331','2026-01-23 19:05:22.205032','1c3962a5-1855-4d83-855e-5e52ca1fe1e2','1c3962a5-1855-4d83-855e-5e52ca1fe1e2','430cf4fee1e04b8f9326ebd6ea4e5a72','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-23 19:05:23.449236','2026-01-23 19:05:24.399987','2026-01-23 19:05:24.399599','1c8162a6-c053-4df8-bc12-4bd95a15b3e1','1c8162a6-c053-4df8-bc12-4bd95a15b3e1','430cf4fee1e04b8f9326ebd6ea4e5a72','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-23 19:05:14.414643','2026-01-23 19:05:15.085872','2026-01-23 19:05:15.085577','1fb25eb0-dbf3-4acf-8354-2db3f488f322','1fb25eb0-dbf3-4acf-8354-2db3f488f322','430cf4fee1e04b8f9326ebd6ea4e5a72','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-23 19:05:21.261062','2026-01-23 19:05:21.410668','2026-01-23 19:05:21.410354','20218e22-4890-4e0d-bb43-61651a12d0a1','20218e22-4890-4e0d-bb43-61651a12d0a1','430cf4fee1e04b8f9326ebd6ea4e5a72','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-23 19:05:20.770837','2026-01-23 19:05:21.057058','2026-01-23 19:05:21.056772','2312fca0-1573-4f64-846d-b0666d9e9782','2312fca0-1573-4f64-846d-b0666d9e9782','430cf4fee1e04b8f9326ebd6ea4e5a72','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-23 19:05:22.576057','2026-01-23 19:05:22.742000','2026-01-23 19:05:22.741658','30ac5349-61bb-49ad-bc61-136d0d9864b3','30ac5349-61bb-49ad-bc61-136d0d9864b3','cc77f1d8022442f9bd9f7e258f349903','ldap','203.0.113.237','203.0.113.87','tempest-ss-domain-543963215','tempest-ss-user-188429625','tempest-ss-password-1970649167','tempest-ss-name-333646706','tempest-ss-desc-1738023881',NULL,NULL),('2026-01-23 19:00:34.731295','2026-01-23 19:00:34.867979','2026-01-23 19:00:34.867275','32402ba2-51ea-4378-9b0b-a99178d9aa1d','32402ba2-51ea-4378-9b0b-a99178d9aa1d','c05ab92b2e7d4b60ac9797fc95883ada','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2026-01-23 19:00:32.573081','2026-01-23 19:00:32.741531','2026-01-23 19:00:32.740920','359d09a6-bad8-4944-89f0-6d4a8d6eaec5','359d09a6-bad8-4944-89f0-6d4a8d6eaec5','c05ab92b2e7d4b60ac9797fc95883ada','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2026-01-23 19:05:12.887125','2026-01-23 19:05:12.958782','2026-01-23 19:05:12.958473','3b31787b-294b-4945-9c56-0316e37fd911','3b31787b-294b-4945-9c56-0316e37fd911','430cf4fee1e04b8f9326ebd6ea4e5a72','kerberos','203.0.113.181','203.0.113.248','tempest-ss-domain-1586873297','tempest-ss-user-2139288228','tempest-ss-password-779105991','tempest-ss-name-409149364','tempest-ss-desc-1948869334',NULL,NULL),('2026-01-23 19:05:23.375742','2026-01-23 19:05:24.626129','2026-01-23 19:05:24.625725','3ef32d21-d700-4583-b101-358a38873215','3ef32d21-d700-4583-b101-358a38873215','430cf4fee1e04b8f9326ebd6ea4e5a72','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-23 19:05:22.049239','2026-01-23 19:05:22.320129','2026-01-23 19:05:22.319778','44fbc8c4-a226-46bf-a36d-322b41f71cfa','44fbc8c4-a226-46bf-a36d-322b41f71cfa','430cf4fee1e04b8f9326ebd6ea4e5a72','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-23 19:05:21.638374','2026-01-23 19:05:21.939837','2026-01-23 19:05:21.939549','452b35db-e68e-4db7-9ff2-b0dadc711be3','452b35db-e68e-4db7-9ff2-b0dadc711be3','430cf4fee1e04b8f9326ebd6ea4e5a72','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-23 19:05:20.383216','2026-01-23 19:05:20.650305','2026-01-23 19:05:20.649979','470def5c-3859-4098-89e2-b377d9466ba4','470def5c-3859-4098-89e2-b377d9466ba4','430cf4fee1e04b8f9326ebd6ea4e5a72','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-23 19:05:13.042391','2026-01-23 19:05:13.098836','2026-01-23 19:05:13.098544','48292671-5156-45dd-8a73-829e9b7fcfe1','48292671-5156-45dd-8a73-829e9b7fcfe1','430cf4fee1e04b8f9326ebd6ea4e5a72','active_directory','203.0.113.181','203.0.113.248','tempest-ss-domain-1586873297','tempest-ss-user-2139288228','tempest-ss-password-779105991','tempest-ss-name-409149364','tempest-ss-desc-1948869334',NULL,NULL),('2026-01-23 19:00:34.651971','2026-01-23 19:00:35.069398','2026-01-23 19:00:35.068999','4924ae0d-8ef9-4110-8e58-77815414b20a','4924ae0d-8ef9-4110-8e58-77815414b20a','c05ab92b2e7d4b60ac9797fc95883ada','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2026-01-23 19:05:21.201131','2026-01-23 19:05:21.542304','2026-01-23 19:05:21.542013','4f1e859c-8545-41a3-853d-a9c8fdc25def','4f1e859c-8545-41a3-853d-a9c8fdc25def','430cf4fee1e04b8f9326ebd6ea4e5a72','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-23 19:00:33.722909','2026-01-23 19:00:33.878626','2026-01-23 19:00:33.877811','50e69880-befa-4c3b-b947-392e3e9d7fd1','50e69880-befa-4c3b-b947-392e3e9d7fd1','c05ab92b2e7d4b60ac9797fc95883ada','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2026-01-23 19:05:13.737120','2026-01-23 19:05:14.237639','2026-01-23 19:05:14.237210','51d3543d-6b3d-412d-8151-8966caa6ae63','51d3543d-6b3d-412d-8151-8966caa6ae63','430cf4fee1e04b8f9326ebd6ea4e5a72','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-23 19:05:17.182909','2026-01-23 19:05:17.902681','2026-01-23 19:05:17.902246','53a6f32b-0aef-4d48-93b6-b74ec701fe3b','53a6f32b-0aef-4d48-93b6-b74ec701fe3b','430cf4fee1e04b8f9326ebd6ea4e5a72','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-23 19:05:12.346401','2026-01-23 19:05:13.539105','2026-01-23 19:05:13.538617','5890f610-e3e1-4a6e-9ea8-8eeb2383b856','5890f610-e3e1-4a6e-9ea8-8eeb2383b856','430cf4fee1e04b8f9326ebd6ea4e5a72','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-23 19:00:36.812748','2026-01-23 19:00:37.013236','2026-01-23 19:00:37.012901','659f3605-9551-4e84-8b26-a0687497997f','659f3605-9551-4e84-8b26-a0687497997f','c05ab92b2e7d4b60ac9797fc95883ada','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2026-01-23 19:05:12.459367','2026-01-23 19:05:13.349314','2026-01-23 19:05:13.348764','6dbe7007-88e1-47ee-b888-0e1caa88de28','6dbe7007-88e1-47ee-b888-0e1caa88de28','430cf4fee1e04b8f9326ebd6ea4e5a72','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-23 19:05:14.356059','2026-01-23 19:05:15.360255','2026-01-23 19:05:15.359855','749597d3-ad71-45a0-a3dd-daa2bc9f3ef9','749597d3-ad71-45a0-a3dd-daa2bc9f3ef9','430cf4fee1e04b8f9326ebd6ea4e5a72','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-23 19:05:33.968979',NULL,NULL,'False','7781a44d-3c61-41bc-9de5-6c74a7b0e8f7','b17f281119ff44cbbbf9816794032547','ldap','203.0.113.114','203.0.113.87','tempest-ss-domain-244107459','tempest-ss-user-557671442','tempest-ss-password-878235799','tempest-ss-name-1591741598','tempest-ss-desc-1612697406',NULL,NULL),('2026-01-23 19:05:15.970438','2026-01-23 19:05:16.651882','2026-01-23 19:05:16.651594','7a184a53-367a-4edd-9117-552b5e3c8ebb','7a184a53-367a-4edd-9117-552b5e3c8ebb','430cf4fee1e04b8f9326ebd6ea4e5a72','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-23 19:05:17.487690','2026-01-23 19:05:17.701080','2026-01-23 19:05:17.700780','7d72bccb-6994-4b12-91f7-48a3c0491b14','7d72bccb-6994-4b12-91f7-48a3c0491b14','430cf4fee1e04b8f9326ebd6ea4e5a72','ldap','203.0.113.227','203.0.113.4','tempest-ss-domain-41183139','tempest-ss-user-1732759473','tempest-ss-password-607073869','tempest-ss-name-1306095380','tempest-ss-desc-781404377','tempest-ss-ou-1734870402',NULL),('2026-01-23 19:00:33.652577','2026-01-23 19:00:34.009514','2026-01-23 19:00:34.009204','82c9f1cc-2d51-43ec-8784-b6ca4644630e','82c9f1cc-2d51-43ec-8784-b6ca4644630e','c05ab92b2e7d4b60ac9797fc95883ada','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2026-01-23 19:00:34.188069','2026-01-23 19:00:34.534919','2026-01-23 19:00:34.534585','8394a3ae-0bc2-4974-b8d8-7af1086b488e','8394a3ae-0bc2-4974-b8d8-7af1086b488e','c05ab92b2e7d4b60ac9797fc95883ada','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2026-01-23 19:00:32.507758','2026-01-23 19:00:33.501678','2026-01-23 19:00:33.500957','9286d441-3aba-4541-9b02-679bb1847a5b','9286d441-3aba-4541-9b02-679bb1847a5b','c05ab92b2e7d4b60ac9797fc95883ada','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2002-02-02 00:00:00.000000',NULL,NULL,'False','9a233f11-c1bf-433b-ae3e-3b3034f1b9da','1a8798b902e7464fa59d9b7585e84a49','kerberos',NULL,NULL,NULL,NULL,NULL,'sn_with_ldap_ss','fake description',NULL,NULL),('2026-01-23 19:00:37.286309','2026-01-23 19:00:37.790428','2026-01-23 19:00:37.789992','9ab4438f-fc7a-42fa-ba00-15d58c700134','9ab4438f-fc7a-42fa-ba00-15d58c700134','c05ab92b2e7d4b60ac9797fc95883ada','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2026-01-23 19:05:14.478429','2026-01-23 19:05:14.613620','2026-01-23 19:05:14.613140','9fc04e12-9aac-4304-be91-013eca244e0e','9fc04e12-9aac-4304-be91-013eca244e0e','430cf4fee1e04b8f9326ebd6ea4e5a72','ldap','203.0.113.124','203.0.113.51','tempest-ss-domain-802552017','tempest-ss-user-999104163','tempest-ss-password-2007830993','tempest-ss-name-802540055','tempest-ss-desc-143564726',NULL,NULL),('2026-01-23 19:05:23.514682','2026-01-23 19:05:24.040532','2026-01-23 19:05:24.040153','a3a04cbe-4635-4d80-bf30-b583a92a58fa','a3a04cbe-4635-4d80-bf30-b583a92a58fa','430cf4fee1e04b8f9326ebd6ea4e5a72','ldap','203.0.113.147','203.0.113.99','tempest-ss-domain-1453681231','tempest-ss-user-330008622','tempest-ss-password-1518194063','tempest-ss-name-1498530287','tempest-ss-desc-1491314281','tempest-ss-ou-404061877',NULL),('2026-01-23 19:05:18.822292','2026-01-23 19:05:19.068777','2026-01-23 19:05:19.068494','a5aa570c-d6b2-423f-8c62-5be666f4d118','a5aa570c-d6b2-423f-8c62-5be666f4d118','430cf4fee1e04b8f9326ebd6ea4e5a72','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-23 19:05:22.416632','2026-01-23 19:05:23.177990','2026-01-23 19:05:23.177652','a6e0ee02-65bc-420a-b37d-96800aa8c442','a6e0ee02-65bc-420a-b37d-96800aa8c442','430cf4fee1e04b8f9326ebd6ea4e5a72','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-23 19:00:35.494816','2026-01-23 19:00:35.933550','2026-01-23 19:00:35.933152','a72cb541-6370-4d15-affd-a04cc8dc56ba','a72cb541-6370-4d15-affd-a04cc8dc56ba','c05ab92b2e7d4b60ac9797fc95883ada','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2026-01-23 19:00:36.157784','2026-01-23 19:00:36.371258','2026-01-23 19:00:36.370727','ab7b0c75-a156-4c19-ab1e-d0231039720c','ab7b0c75-a156-4c19-ab1e-d0231039720c','c05ab92b2e7d4b60ac9797fc95883ada','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2026-01-23 19:05:16.240860','2026-01-23 19:05:16.451568','2026-01-23 19:05:16.451168','aee5e5a0-3edc-438d-934f-84587bdff66a','aee5e5a0-3edc-438d-934f-84587bdff66a','430cf4fee1e04b8f9326ebd6ea4e5a72','ldap','203.0.113.32','203.0.113.202','tempest-ss-domain-117443654','tempest-ss-user-273650048','tempest-ss-password-1796807342','tempest-ss-name-939205551','tempest-ss-desc-322704565','tempest-ss-ou-1950334672',NULL),('2026-01-23 19:05:31.945919','2026-01-23 19:05:32.358786','2026-01-23 19:05:32.358340','af18911c-8971-4cbc-8983-d418cc3eb2e8','af18911c-8971-4cbc-8983-d418cc3eb2e8','b17f281119ff44cbbbf9816794032547','ldap','203.0.113.158','203.0.113.127','tempest-ss-domain-376020202','tempest-ss-user-1596051166','tempest-ss-password-62071566','tempest-ss-name-2082354081','tempest-ss-desc-925944972',NULL,NULL),('2026-01-23 19:05:21.698766','2026-01-23 19:05:21.822405','2026-01-23 19:05:21.821848','aff598c5-4333-4a92-9374-553d776dbc74','aff598c5-4333-4a92-9374-553d776dbc74','430cf4fee1e04b8f9326ebd6ea4e5a72','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-23 19:05:20.432369','2026-01-23 19:05:20.555296','2026-01-23 19:05:20.554953','b3e6a872-0e14-4439-b588-4368abb0eaaf','b3e6a872-0e14-4439-b588-4368abb0eaaf','430cf4fee1e04b8f9326ebd6ea4e5a72','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-23 19:00:34.250080','2026-01-23 19:00:34.387344','2026-01-23 19:00:34.386993','bb3ddc56-514f-428c-841c-5e72279f6632','bb3ddc56-514f-428c-841c-5e72279f6632','c05ab92b2e7d4b60ac9797fc95883ada','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2002-02-02 00:00:00.000000',NULL,NULL,'False','c284e7a8-c9c8-4a30-8125-1b413fcf646b','cd28fe6ab6ac42579a9ef7ca014c6978','kerberos',NULL,NULL,NULL,NULL,NULL,'sn_with_ldap_ss','fake description',NULL,NULL),('2026-01-23 19:05:33.026391',NULL,NULL,'False','c7d5bf54-c35e-4306-9c07-0d7d25f1165b','b17f281119ff44cbbbf9816794032547','ldap','203.0.113.151','203.0.113.230','tempest-ss-domain-1045584362','tempest-ss-user-47507491','tempest-ss-password-655102559','tempest-ss-name-1192109381','tempest-ss-desc-1467826878',NULL,NULL),('2026-01-23 19:05:15.733895','2026-01-23 19:05:16.871621','2026-01-23 19:05:16.871193','cb1ced84-b7a7-4b68-9c11-677617c6be57','cb1ced84-b7a7-4b68-9c11-677617c6be57','430cf4fee1e04b8f9326ebd6ea4e5a72','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-23 19:05:22.467247','2026-01-23 19:05:22.884484','2026-01-23 19:05:22.884175','ce9172db-bc0d-4a67-855f-50ac9813a556','ce9172db-bc0d-4a67-855f-50ac9813a556','430cf4fee1e04b8f9326ebd6ea4e5a72','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-23 19:05:19.783162','2026-01-23 19:05:20.228941','2026-01-23 19:05:20.228588','cf9bca6e-5262-4680-9b62-4f52a632d0af','cf9bca6e-5262-4680-9b62-4f52a632d0af','430cf4fee1e04b8f9326ebd6ea4e5a72','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-23 19:05:19.937021','2026-01-23 19:05:20.096558','2026-01-23 19:05:20.096191','d54cf424-5809-463f-b25c-449495dfeace','d54cf424-5809-463f-b25c-449495dfeace','430cf4fee1e04b8f9326ebd6ea4e5a72','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-23 19:00:35.670220','2026-01-23 19:00:35.777003','2026-01-23 19:00:35.776657','d73b3873-965f-40a4-bd15-a722d09bc4e5','d73b3873-965f-40a4-bd15-a722d09bc4e5','c05ab92b2e7d4b60ac9797fc95883ada','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2026-01-23 19:02:04.089385',NULL,NULL,'False','d802a673-15d3-408d-9251-4d7e9d8cd26d','0034e94cde5c402eb542d58e14a80d2c','ldap','203.0.113.1','203.0.113.96','tempest-ss-domain-969110425','tempest-ss-user-729505466','tempest-ss-password-93041846','tempest-ss-name-1183282720','tempest-ss-desc-983115736',NULL,NULL),('2026-01-23 19:07:14.062447',NULL,NULL,'False','d8409690-42bc-4d18-bb6c-16fafe624e12','cd28fe6ab6ac42579a9ef7ca014c6978','ldap','203.0.113.42','203.0.113.10','tempest-ss-domain-1848444449','tempest-ss-user-1557743611','tempest-ss-password-1855208','tempest-ss-name-369897782','tempest-ss-desc-1198650628',NULL,NULL),('2026-01-23 19:05:12.578602','2026-01-23 19:05:12.744966','2026-01-23 19:05:12.744676','d9848755-9092-44ab-afe3-3ac4e8be2e6a','d9848755-9092-44ab-afe3-3ac4e8be2e6a','430cf4fee1e04b8f9326ebd6ea4e5a72','ldap','203.0.113.181','203.0.113.248','tempest-ss-domain-1586873297','tempest-ss-user-2139288228','tempest-ss-password-779105991','tempest-ss-name-409149364','tempest-ss-desc-1948869334',NULL,NULL),('2026-01-23 19:00:37.353504','2026-01-23 19:00:37.496131','2026-01-23 19:00:37.495527','d9e46ce8-9049-43e6-80fa-c1ed146e425f','d9e46ce8-9049-43e6-80fa-c1ed146e425f','c05ab92b2e7d4b60ac9797fc95883ada','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2026-01-23 19:06:07.574370','2026-01-23 19:06:07.691556','2026-01-23 19:06:07.691065','eabe0acd-b49e-4a25-b2a6-d6e80429f9bd','eabe0acd-b49e-4a25-b2a6-d6e80429f9bd','75e52a4cdd254dab988208cec10afe8e','ldap','203.0.113.205','203.0.113.36','tempest-ss-domain-1500580661','tempest-ss-user-989155589','tempest-ss-password-2010974962','tempest-ss-name-105313989','tempest-ss-desc-2133108385',NULL,NULL),('2026-01-23 19:05:20.828623','2026-01-23 19:05:20.919669','2026-01-23 19:05:20.919305','ec0c79f4-ac42-49d2-abbb-4612350aefab','ec0c79f4-ac42-49d2-abbb-4612350aefab','430cf4fee1e04b8f9326ebd6ea4e5a72','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-23 19:05:18.239552','2026-01-23 19:05:19.595180','2026-01-23 19:05:19.594718','f2a24322-f289-4d57-9092-3152df942191','f2a24322-f289-4d57-9092-3152df942191','430cf4fee1e04b8f9326ebd6ea4e5a72','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-23 19:05:17.106118','2026-01-23 19:05:18.099192','2026-01-23 19:05:18.098778','f3a99283-0aac-430f-a6b6-9c390263f197','f3a99283-0aac-430f-a6b6-9c390263f197','430cf4fee1e04b8f9326ebd6ea4e5a72','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-23 19:05:44.384035',NULL,NULL,'False','fb089594-ad99-447b-8c31-a74927520542','283b89301a234374a4dbf7307759750d','ldap','203.0.113.158','203.0.113.79','tempest-ss-domain-1282814470','tempest-ss-user-159701167','tempest-ss-password-1776790644','tempest-ss-name-799814979','tempest-ss-desc-34270662',NULL,NULL),('2026-01-23 19:00:36.716340','2026-01-23 19:00:37.170657','2026-01-23 19:00:37.170221','fc06cf2c-bc52-4de6-8a20-c1c59f3e8533','fc06cf2c-bc52-4de6-8a20-c1c59f3e8533','c05ab92b2e7d4b60ac9797fc95883ada','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL);
/*!40000 ALTER TABLE `security_services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  `state` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `service_az_id_fk` (`availability_zone_id`),
  CONSTRAINT `service_az_id_fk` FOREIGN KEY (`availability_zone_id`) REFERENCES `availability_zones` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone_id`, `state`) VALUES ('2026-01-23 18:55:15.892256','2026-01-23 19:24:38.481430',NULL,0,1,'hostgroup','manila-scheduler','manila-scheduler',175,0,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','up'),('2026-01-23 18:55:25.267301','2026-01-23 19:24:41.475566',NULL,0,2,'hostgroup@cephfs','manila-share','manila-share',174,0,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','up');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_access_map`
--

DROP TABLE IF EXISTS `share_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_access_map` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `share_id` varchar(36) NOT NULL,
  `access_type` varchar(255) DEFAULT NULL,
  `access_to` varchar(255) DEFAULT NULL,
  `access_level` varchar(2) DEFAULT NULL,
  `access_key` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_id` (`share_id`),
  CONSTRAINT `share_access_map_ibfk_1` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_access_map`
--

LOCK TABLES `share_access_map` WRITE;
/*!40000 ALTER TABLE `share_access_map` DISABLE KEYS */;
INSERT INTO `share_access_map` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_id`, `access_type`, `access_to`, `access_level`, `access_key`) VALUES ('2026-01-23 19:06:13.495623','2026-01-23 19:06:18.775598','2026-01-23 19:06:19.454399','009dc29b-0fe0-4160-a616-f7f4f249ff8d','009dc29b-0fe0-4160-a616-f7f4f249ff8d','47e3b685-1a97-423d-9bd9-6c6581606054','cephx','tempest-cephx-id-1979362240','rw','AQClxnNpAojkOBAARNkL0ldM2hwmUEOd/D0QBw=='),('2026-01-23 19:05:39.566173','2026-01-23 19:05:50.919369','2026-01-23 19:06:50.523343','08353937-22a0-4a38-8336-9b7dded61bd4','08353937-22a0-4a38-8336-9b7dded61bd4','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','alice','rw','AQCGxnNpCOHEFBAAG/SsaqUC8gh5dKcXsXW9uA=='),('2026-01-23 19:02:21.008553','2026-01-23 19:02:35.241052','2026-01-23 19:02:50.833252','206d5aed-6ccc-490e-86a1-678866f7f1cb','206d5aed-6ccc-490e-86a1-678866f7f1cb','3b030aa9-c2a3-412f-bf95-1476db82a6ad','cephx','david','rw','AQC9xXNpA8vlEBAAYTesFP+0it8aQvvfuvkqsw=='),('2026-01-23 19:04:23.155122','2026-01-23 19:04:27.242060','2026-01-23 19:06:50.523343','23939b5c-94e9-49d4-8a27-d657b917979d','23939b5c-94e9-49d4-8a27-d657b917979d','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','alice_bob','rw','AQA3xnNpb+k9HhAAoDdFT/25Low2Xl+6L6DWxQ=='),('2026-01-23 19:04:30.555296','2026-01-23 19:04:34.645877','2026-01-23 19:06:50.523343','37808798-f444-4fd7-b543-7e5db4c5d5a5','37808798-f444-4fd7-b543-7e5db4c5d5a5','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','alice_bob','ro','AQA+xnNpyfsSORAAmaiisffp9eE+/ughis5oRQ=='),('2026-01-23 19:06:24.350813','2026-01-23 19:06:28.132002','2026-01-23 19:06:50.523343','44fa36de-07a8-4085-aec9-4794a7fb50af','44fa36de-07a8-4085-aec9-4794a7fb50af','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','alice bob','ro','AQCwxnNp2ppINxAA8JAyhUgSGbrK5QOo6Mn+Fw=='),('2026-01-23 19:06:28.279216','2026-01-23 19:06:32.053798','2026-01-23 19:06:50.768749','5714c3cb-ff8d-44cc-ba28-04a30879d1f9','5714c3cb-ff8d-44cc-ba28-04a30879d1f9','37853495-d9b6-4d2c-abc6-da37b9ee8591','cephx','tempest-cephx-id-1979362240','rw','AQC1xnNpZqjWGxAADyM/fbPnUIdAE+w4cbOpOg=='),('2026-01-23 19:04:46.340740','2026-01-23 19:04:52.086476','2026-01-23 19:06:50.523343','6cc3db01-4b75-4559-af3e-9fd02f0f596d','6cc3db01-4b75-4559-af3e-9fd02f0f596d','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','alice bob','ro','AQBQxnNpq+sjERAAhfRxjHQOT1bmfIPRfrAZkQ=='),('2026-01-23 19:06:17.034717','2026-01-23 19:06:22.059053','2026-01-23 19:06:50.523343','73d3c936-65fa-40ed-823e-f25ff194fd12','73d3c936-65fa-40ed-823e-f25ff194fd12','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','alice bob','rw','AQCpxnNpCUEJORAAbCju6bE/fxy9y+Cjm3aeLg=='),('2026-01-23 19:06:31.216856','2026-01-23 19:06:46.117638','2026-01-23 19:06:50.523343','7b509c97-c373-469f-a71e-73c05d408395','7b509c97-c373-469f-a71e-73c05d408395','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','bob','rw','AQC3xnNpNHSYKBAAq4FCdCewEd+vp6kKO1BuJQ=='),('2026-01-23 19:02:17.395574','2026-01-23 19:02:50.065847','2026-01-23 19:02:50.833252','7e5b419f-d0bb-43dd-b357-9422e267be95','7e5b419f-d0bb-43dd-b357-9422e267be95','3b030aa9-c2a3-412f-bf95-1476db82a6ad','cephx','admin','rw',NULL),('2026-01-23 19:04:06.557040','2026-01-23 19:04:11.706300','2026-01-23 19:04:20.931461','80616bb4-6d26-42b2-91d5-9428015fff90','80616bb4-6d26-42b2-91d5-9428015fff90','57d4aac1-6dba-40f5-b7ab-eecb70beae03','cephx','eve47','rw','AQAnxnNp+hNlFxAAt4DbPprKdDBIvIs8WSpqtA=='),('2026-01-23 19:04:55.370647','2026-01-23 19:05:00.010265','2026-01-23 19:06:50.523343','80ec6408-07fa-454d-81cf-cf1c647592bd','80ec6408-07fa-454d-81cf-cf1c647592bd','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','alice','rw','AQBYxnNpbMxhFxAA6VX5Q1UAh06Q0TOe1hSgUA=='),('2026-01-23 19:06:01.129611','2026-01-23 19:06:06.476651','2026-01-23 19:06:06.997547','837f4568-5101-46a9-bea7-49836966cf5d','837f4568-5101-46a9-bea7-49836966cf5d','ec07c5de-032d-4294-a579-616d0c9c5cc9','cephx','tempest-cephx-id-1979362240','rw','AQCZxnNpyWIUFhAASb5sBfehJeWFe/pB9MunKw=='),('2026-01-23 19:01:51.734330','2026-01-23 19:02:14.059068','2026-01-23 19:02:46.212257','8971a8a8-c840-4ac1-a3e8-6afcf118871b','8971a8a8-c840-4ac1-a3e8-6afcf118871b','7938988f-34fb-477d-9ef4-7346a281e738','cephx','Joe','rw','AQCgxXNpEjupDhAAYaXYZr6neTjjsBDTr3W5Kw=='),('2026-01-23 19:03:52.189772','2026-01-23 19:03:55.966038','2026-01-23 19:06:50.523343','8bab543a-d9f7-4e51-9fb9-7b19daa0aabc','8bab543a-d9f7-4e51-9fb9-7b19daa0aabc','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','alice bob','rw','AQAYxnNpy4doIhAAYN6IPdZrFtNljLQBr7aQpg=='),('2026-01-23 19:05:54.164128','2026-01-23 19:05:58.507791','2026-01-23 19:06:50.523343','90214cb7-685b-4154-bb9e-1bc671058da8','90214cb7-685b-4154-bb9e-1bc671058da8','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','alice','ro','AQCTxnNpeSWjEhAAeU7IS6iAFllWCN+EmWCO6A=='),('2026-01-23 19:03:23.254429','2026-01-23 19:03:27.537856','2026-01-23 19:06:50.523343','93868318-f7ab-418f-96fd-02dca51f438d','93868318-f7ab-418f-96fd-02dca51f438d','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','alice','rw','AQD8xXNpz4cdHhAAy6dYKVIKlEjCszOLeXixAA=='),('2026-01-23 19:06:09.498707','2026-01-23 19:06:14.026988','2026-01-23 19:06:50.523343','93f79db3-0d4c-4b47-92a7-c86a02326bb2','93f79db3-0d4c-4b47-92a7-c86a02326bb2','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','alice_bob','ro','AQCixnNpWNVBBhAAtD4EfEjqCQOj63Vc5wyl9g=='),('2026-01-23 19:03:59.086645','2026-01-23 19:04:03.126339','2026-01-23 19:04:20.931461','94b60fa7-ac31-413c-9e1f-d7c72259d85d','94b60fa7-ac31-413c-9e1f-d7c72259d85d','57d4aac1-6dba-40f5-b7ab-eecb70beae03','cephx','eve48','rw','AQAgxnNp+qCtIRAA2RIcJiGzlVsQkoC0as3ZDA=='),('2026-01-23 19:03:45.200622','2026-01-23 19:03:48.976608','2026-01-23 19:06:50.523343','955d6163-4e5d-4102-91b1-5c3e9347f9e9','955d6163-4e5d-4102-91b1-5c3e9347f9e9','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','alice_bob','ro','AQARxnNpeszIIRAA8+Kt3gACqpEl8ak6M04m7w=='),('2026-01-23 19:05:17.504317','2026-01-23 19:05:21.374554','2026-01-23 19:06:50.523343','9abc1852-3812-4ad8-bc3d-46550e1940df','9abc1852-3812-4ad8-bc3d-46550e1940df','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','alice_bob','ro','AQBuxnNpPC61BBAAEyPnLIHPnSOu8l5UByUw8Q=='),('2026-01-23 19:06:38.964206','2026-01-23 19:06:42.523900','2026-01-23 19:06:43.058265','a7942d94-cdf2-4b0a-bc96-462aa747cafd','a7942d94-cdf2-4b0a-bc96-462aa747cafd','69a009ee-f397-404a-b72b-02056e1c0d04','cephx','bob','rw','AQC3xnNpNHSYKBAAq4FCdCewEd+vp6kKO1BuJQ=='),('2026-01-23 19:06:42.186817','2026-01-23 19:06:46.305905','2026-01-23 19:06:50.768749','ae0a179f-210f-47f4-8eed-d3b014bfeb93','ae0a179f-210f-47f4-8eed-d3b014bfeb93','37853495-d9b6-4d2c-abc6-da37b9ee8591','cephx','tempest-cephx-id-1979362240','rw','AQDCxnNpzrgsJBAAkwDiWRU/8poHACM7tLZTWw=='),('2026-01-23 19:05:42.993094','2026-01-23 19:05:53.612038','2026-01-23 19:05:55.134218','b161c3b8-b4db-43c0-889b-96666a2a657f','b161c3b8-b4db-43c0-889b-96666a2a657f','1289a7a6-fe12-4d2f-b00b-358016b0e61e','cephx','tempest-cephx-id-1979362240','rw','AQCKxnNpdHuzCxAAinOtRVvJQ+0rIOzwotHKYg=='),('2026-01-23 19:06:01.951745','2026-01-23 19:06:06.274531','2026-01-23 19:06:50.523343','b8099063-8d9f-48f8-bcc4-b25b2cab9157','b8099063-8d9f-48f8-bcc4-b25b2cab9157','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','alice_bob','rw','AQCaxnNpkQp1KxAApCHP1qVIFCEL/2j4Ihw+FA=='),('2026-01-23 19:01:58.583959','2026-01-23 19:02:05.976208','2026-01-23 19:02:42.898023','bb1424bf-b79d-461d-b5be-0aa3c37fdfe9','bb1424bf-b79d-461d-b5be-0aa3c37fdfe9','227c770e-cd8a-40bc-b862-45ce5532d775','cephx','Joe','rw',NULL),('2026-01-23 19:06:35.243362','2026-01-23 19:06:39.018522','2026-01-23 19:06:50.768749','cabc5650-cc0f-417b-bb07-72bd9c01b3f1','cabc5650-cc0f-417b-bb07-72bd9c01b3f1','37853495-d9b6-4d2c-abc6-da37b9ee8591','cephx','tempest-cephx-id-1979362240','rw','AQC9xnNpueeqDRAAGICo0Oa+Y3YPQRPQRL2N6w=='),('2026-01-23 19:02:28.102604','2026-01-23 19:02:31.682007','2026-01-23 19:02:39.236523','d22f4149-9947-4344-804e-06348910de4e','d22f4149-9947-4344-804e-06348910de4e','784dce8f-a5a5-4328-baac-1ef916284d88','cephx','david','rw',NULL),('2026-01-23 19:03:30.914175','2026-01-23 19:03:34.722246','2026-01-23 19:06:50.523343','d342317c-10b3-40a1-a5bf-bb3b441079e8','d342317c-10b3-40a1-a5bf-bb3b441079e8','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','alice','ro','AQADxnNpu1ktCxAATTkBGrZz5AoKYVVz/WCVgg=='),('2026-01-23 19:03:55.604187','2026-01-23 19:04:19.988176','2026-01-23 19:04:20.931461','d42eccdc-ad91-4736-aeac-16c8437380e9','d42eccdc-ad91-4736-aeac-16c8437380e9','57d4aac1-6dba-40f5-b7ab-eecb70beae03','cephx','eve49','rw','AQAcxnNpEx1SAhAAJsZksUrmMvtEX8YEJwpBJw=='),('2026-01-23 19:06:20.730450','2026-01-23 19:06:25.260069','2026-01-23 19:06:50.768749','d4738379-fb8c-4ce3-a1f1-0ddc65a513fc','d4738379-fb8c-4ce3-a1f1-0ddc65a513fc','37853495-d9b6-4d2c-abc6-da37b9ee8591','cephx','tempest-cephx-id-1979362240','rw','AQCtxnNplEb1LBAA56xTGqSF1tCdhW8FiReWdA=='),('2026-01-23 19:03:59.514478','2026-01-23 19:04:03.239463','2026-01-23 19:06:50.523343','d5da5d57-006e-48de-8f39-8fa5d7290f5b','d5da5d57-006e-48de-8f39-8fa5d7290f5b','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','alice bob','ro','AQAgxnNprnnCNxAA56htFqAQtm2VsdWrKEkx1A=='),('2026-01-23 19:04:06.528637','2026-01-23 19:04:10.822076','2026-01-23 19:06:50.523343','da65c09a-2298-46e2-972f-1f28a92487ae','da65c09a-2298-46e2-972f-1f28a92487ae','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','alice','rw','AQAnxnNpI9fxChAAUGwGiYtpCTqdIu+Rkuo6rQ=='),('2026-01-23 19:05:24.694240','2026-01-23 19:05:28.596490','2026-01-23 19:06:50.523343','dc122773-8e5f-4599-bf59-4ce04b4ed7aa','dc122773-8e5f-4599-bf59-4ce04b4ed7aa','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','alice bob','rw','AQB1xnNp0AbOChAAF0blyukeEseoqonv4ootag=='),('2026-01-23 19:02:02.284121','2026-01-23 19:02:10.449938','2026-01-23 19:02:42.898023','e0543fe7-c931-41e7-b972-b9af835658f0','e0543fe7-c931-41e7-b972-b9af835658f0','227c770e-cd8a-40bc-b862-45ce5532d775','cephx','tempest-cephx-id-1425431123','rw','AQCqxXNpz0JeIBAAcTvKBX0AY4+nH+Nfz4xP5g=='),('2026-01-23 19:03:38.095292','2026-01-23 19:03:41.899395','2026-01-23 19:06:50.523343','e2533af8-b25f-4613-b248-45e14098446d','e2533af8-b25f-4613-b248-45e14098446d','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','alice_bob','rw','AQAKxnNpFyYBIxAAbsdzpg/sQg7Ynl8qVMICQg=='),('2026-01-23 19:05:03.547252','2026-01-23 19:05:07.813019','2026-01-23 19:06:50.523343','e837cb99-067d-4e96-b02a-ecd310609055','e837cb99-067d-4e96-b02a-ecd310609055','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','alice','ro','AQBfxnNpZxhyMxAArYAJoNAAZmg7HHhDV5Ro3A=='),('2026-01-23 19:04:14.388432','2026-01-23 19:04:19.966246','2026-01-23 19:06:50.523343','ed44e868-fc10-424f-8c11-0940a32756e8','ed44e868-fc10-424f-8c11-0940a32756e8','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','alice','ro','AQAvxnNphek5ERAADoils05r8waUKpYRpNOudg=='),('2026-01-23 19:04:37.822757','2026-01-23 19:04:43.078950','2026-01-23 19:06:50.523343','ede786ab-19d9-4dde-9106-48bb020b91cf','ede786ab-19d9-4dde-9106-48bb020b91cf','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','alice bob','rw','AQBGxnNpGtrANhAAONYCOxKqdX+/39Chr0xDDw=='),('2026-01-23 19:05:32.131934','2026-01-23 19:05:36.060798','2026-01-23 19:06:50.523343','ee804d5e-58aa-4593-886c-f71d0a8921f2','ee804d5e-58aa-4593-886c-f71d0a8921f2','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','alice bob','ro','AQB8xnNpVg1XLxAA9nW+J5ZdecHqUvgj3FhUDA=='),('2026-01-23 19:01:54.403576','2026-01-23 19:01:55.947698','2026-01-23 19:01:56.274906','f46cc066-daf6-498a-8a79-a2027eec3736','f46cc066-daf6-498a-8a79-a2027eec3736','a8641b5d-7b3b-4197-9cc0-76b90318f554','cephx','tempest-cephx-id-1573583560','rw','AQCixXNp5Eu1JxAAa2qACFiTstiaQGRdX4VvQg=='),('2026-01-23 19:05:10.627709','2026-01-23 19:05:14.347475','2026-01-23 19:06:50.523343','f6fbba55-33d5-48ac-a099-1691d3e433d8','f6fbba55-33d5-48ac-a099-1691d3e433d8','925d3664-bf68-4a0a-92b4-6195aa90de88','cephx','alice_bob','rw','AQBnxnNpfgphAxAAQvUsRuR+puSEhgdhyD6/KA==');
/*!40000 ALTER TABLE `share_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_access_rules_metadata`
--

DROP TABLE IF EXISTS `share_access_rules_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_access_rules_metadata` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `access_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `access_id` (`access_id`),
  CONSTRAINT `share_access_rules_metadata_ibfk_1` FOREIGN KEY (`access_id`) REFERENCES `share_access_map` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_access_rules_metadata`
--

LOCK TABLES `share_access_rules_metadata` WRITE;
/*!40000 ALTER TABLE `share_access_rules_metadata` DISABLE KEYS */;
INSERT INTO `share_access_rules_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `access_id`, `key`, `value`, `id`) VALUES ('2026-01-23 19:01:54.404716',NULL,'2026-01-23 19:01:56.172675','1','f46cc066-daf6-498a-8a79-a2027eec3736','key1','value1',1),('2026-01-23 19:03:55.606977',NULL,'2026-01-23 19:04:20.760954','2','d42eccdc-ad91-4736-aeac-16c8437380e9','key1','value1',2),('2026-01-23 19:03:55.608064','2026-01-23 19:04:15.071054','2026-01-23 19:04:20.760954','3','d42eccdc-ad91-4736-aeac-16c8437380e9','key2','value6_new',3),('2026-01-23 19:03:59.088065',NULL,'2026-01-23 19:04:04.234669','4','94b60fa7-ac31-413c-9e1f-d7c72259d85d','key3','v3',4),('2026-01-23 19:03:59.089874',NULL,'2026-01-23 19:04:04.234669','5','94b60fa7-ac31-413c-9e1f-d7c72259d85d','key4','value4',5),('2026-01-23 19:04:06.557660','2026-01-23 19:04:10.635650','2026-01-23 19:04:12.015645','6','80616bb4-6d26-42b2-91d5-9428015fff90','key1','vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv',6),('2026-01-23 19:04:06.558036','2026-01-23 19:04:10.891333','2026-01-23 19:04:12.015645','7','80616bb4-6d26-42b2-91d5-9428015fff90','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value2',7),('2026-01-23 19:04:15.055052',NULL,'2026-01-23 19:04:20.760954','8','d42eccdc-ad91-4736-aeac-16c8437380e9','key7','value7',8),('2026-01-23 19:06:35.244774',NULL,'2026-01-23 19:06:40.611510','9','cabc5650-cc0f-417b-bb07-72bd9c01b3f1','key1','v1',9),('2026-01-23 19:06:35.245674',NULL,'2026-01-23 19:06:40.611510','10','cabc5650-cc0f-417b-bb07-72bd9c01b3f1','key2','v2',10),('2026-01-23 19:06:42.187476',NULL,'2026-01-23 19:06:46.584000','11','ae0a179f-210f-47f4-8eed-d3b014bfeb93','key1','v1',11),('2026-01-23 19:06:42.187782',NULL,'2026-01-23 19:06:46.584000','12','ae0a179f-210f-47f4-8eed-d3b014bfeb93','key2','v2',12);
/*!40000 ALTER TABLE `share_access_rules_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_share_type_mappings`
--

DROP TABLE IF EXISTS `share_group_share_type_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_share_type_mappings` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_group_id` varchar(36) DEFAULT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_sgstm_share_group_id` (`share_group_id`),
  KEY `fk_sgstm_share_type_id` (`share_type_id`),
  CONSTRAINT `fk_sgstm_share_group_id` FOREIGN KEY (`share_group_id`) REFERENCES `share_groups` (`id`),
  CONSTRAINT `fk_sgstm_share_type_id` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_share_type_mappings`
--

LOCK TABLES `share_group_share_type_mappings` WRITE;
/*!40000 ALTER TABLE `share_group_share_type_mappings` DISABLE KEYS */;
INSERT INTO `share_group_share_type_mappings` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_group_id`, `share_type_id`) VALUES ('01e6378e-35cd-4ef7-a72c-c770c38d5e3d','2026-01-23 19:05:02.838851',NULL,'2026-01-23 19:05:06.420152','01e6378e-35cd-4ef7-a72c-c770c38d5e3d','6b31e860-10ee-43b8-b69b-3931b32aba37','21de215f-d5bc-482a-9a75-67ea712434b1'),('4a41691c-7f87-48b8-9722-21430507e529','2026-01-23 19:04:55.860495',NULL,'2026-01-23 19:05:02.558455','4a41691c-7f87-48b8-9722-21430507e529','20bc8457-64c2-49cd-863d-7d9377e1a1fe','21de215f-d5bc-482a-9a75-67ea712434b1');
/*!40000 ALTER TABLE `share_group_share_type_mappings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_snapshots`
--

DROP TABLE IF EXISTS `share_group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_snapshots` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `share_group_id` varchar(36) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_share_group_snapshots_share_group_id` (`share_group_id`),
  CONSTRAINT `fk_share_group_snapshots_share_group_id` FOREIGN KEY (`share_group_id`) REFERENCES `share_groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_snapshots`
--

LOCK TABLES `share_group_snapshots` WRITE;
/*!40000 ALTER TABLE `share_group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_type_projects`
--

DROP TABLE IF EXISTS `share_group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sgtp_project_id_uc` (`share_group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `sgtp_id_fk` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_type_projects`
--

LOCK TABLES `share_group_type_projects` WRITE;
/*!40000 ALTER TABLE `share_group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_type_share_type_mappings`
--

DROP TABLE IF EXISTS `share_group_type_share_type_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_type_share_type_mappings` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_group_type_id` varchar(36) NOT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sgtp_id_sgt_id_uc` (`share_group_type_id`),
  KEY `sgtp_id_st_id_uc` (`share_type_id`),
  CONSTRAINT `sgtp_id_sgt_id_uc` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`),
  CONSTRAINT `sgtp_id_st_id_uc` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_type_share_type_mappings`
--

LOCK TABLES `share_group_type_share_type_mappings` WRITE;
/*!40000 ALTER TABLE `share_group_type_share_type_mappings` DISABLE KEYS */;
INSERT INTO `share_group_type_share_type_mappings` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_group_type_id`, `share_type_id`) VALUES ('1033564e-61f7-488e-a562-989d41bca753','2026-01-23 19:00:23.215167',NULL,'2026-01-23 19:01:16.678862','1033564e-61f7-488e-a562-989d41bca753','519f446a-3d16-4f6d-99a8-8598486fd365','d20bdec5-e74c-4607-88bd-eca35cfd175e'),('4c73831c-c0b8-4157-a448-d2a150fc10e9','2026-01-23 19:07:24.921649',NULL,'2026-01-23 19:07:26.896276','4c73831c-c0b8-4157-a448-d2a150fc10e9','f658c3af-38dc-4365-8067-1ec4718bf8b4','428c0ad2-9d3f-4b12-8023-52107603632f'),('6dd05b8e-d2f8-4038-9aaf-d30523821f7d','2026-01-23 19:01:21.456748',NULL,'2026-01-23 19:02:00.208812','6dd05b8e-d2f8-4038-9aaf-d30523821f7d','93514cfa-b2b9-4ca2-8dd1-ab768b84e78c','f4a6bef4-70c7-455a-897f-b3e9b5f4c268'),('d3011271-beb7-4919-a69b-287ad99e4e14','2026-01-23 19:04:28.636326',NULL,'2026-01-23 19:05:23.339936','d3011271-beb7-4919-a69b-287ad99e4e14','ce491032-81d6-4fd7-a801-52315e44f40b','21de215f-d5bc-482a-9a75-67ea712434b1');
/*!40000 ALTER TABLE `share_group_type_share_type_mappings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_type_specs`
--

DROP TABLE IF EXISTS `share_group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `spec_key` varchar(255) DEFAULT NULL,
  `spec_value` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sgtp_id_extra_specs_fk` (`share_group_type_id`),
  CONSTRAINT `sgtp_id_extra_specs_fk` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_type_specs`
--

LOCK TABLES `share_group_type_specs` WRITE;
/*!40000 ALTER TABLE `share_group_type_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_types`
--

DROP TABLE IF EXISTS `share_group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_types` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_share_group_type_name` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_types`
--

LOCK TABLES `share_group_types` WRITE;
/*!40000 ALTER TABLE `share_group_types` DISABLE KEYS */;
INSERT INTO `share_group_types` (`id`, `created_at`, `updated_at`, `deleted_at`, `is_public`, `name`, `deleted`) VALUES ('519f446a-3d16-4f6d-99a8-8598486fd365','2026-01-23 19:00:23.213632',NULL,'2026-01-23 19:01:16.684789',1,'tempest-unique_sgtype_name-964871324','519f446a-3d16-4f6d-99a8-8598486fd365'),('93514cfa-b2b9-4ca2-8dd1-ab768b84e78c','2026-01-23 19:01:21.455651',NULL,'2026-01-23 19:02:00.212305',1,'tempest-unique_sgtype_name-1632538251','93514cfa-b2b9-4ca2-8dd1-ab768b84e78c'),('ce491032-81d6-4fd7-a801-52315e44f40b','2026-01-23 19:04:28.635090',NULL,'2026-01-23 19:05:23.345017',1,'tempest-unique_sgtype_name-407748050','ce491032-81d6-4fd7-a801-52315e44f40b'),('f658c3af-38dc-4365-8067-1ec4718bf8b4','2026-01-23 19:07:24.919897',NULL,'2026-01-23 19:07:26.900105',1,'tempest-unique_sgtype_name-1285897097','f658c3af-38dc-4365-8067-1ec4718bf8b4');
/*!40000 ALTER TABLE `share_group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_groups`
--

DROP TABLE IF EXISTS `share_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_groups` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `host` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `source_share_group_snapshot_id` varchar(36) DEFAULT NULL,
  `share_network_id` varchar(36) DEFAULT NULL,
  `share_server_id` varchar(36) DEFAULT NULL,
  `share_group_type_id` varchar(36) DEFAULT NULL,
  `consistent_snapshot_support` enum('pool','host') DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_share_group_share_network_id` (`share_network_id`),
  KEY `fk_share_group_share_server_id` (`share_server_id`),
  KEY `sgt_id_sg_id_uc` (`share_group_type_id`),
  CONSTRAINT `fk_share_group_share_network_id` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`),
  CONSTRAINT `fk_share_group_share_server_id` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`),
  CONSTRAINT `sgt_id_sg_id_uc` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_groups`
--

LOCK TABLES `share_groups` WRITE;
/*!40000 ALTER TABLE `share_groups` DISABLE KEYS */;
INSERT INTO `share_groups` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `user_id`, `project_id`, `host`, `name`, `description`, `status`, `source_share_group_snapshot_id`, `share_network_id`, `share_server_id`, `share_group_type_id`, `consistent_snapshot_support`, `availability_zone_id`) VALUES ('20bc8457-64c2-49cd-863d-7d9377e1a1fe','2026-01-23 19:04:56.527653','2026-01-23 19:05:02.555347','2026-01-23 19:05:02.553888','20bc8457-64c2-49cd-863d-7d9377e1a1fe','0cdc36ee00844d51a9bfb80f7be4a983','6e81efcadc1a4938a53855b68f0acfd2','hostgroup@cephfs#cephfs',NULL,NULL,'deleting',NULL,NULL,NULL,'ce491032-81d6-4fd7-a801-52315e44f40b',NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec'),('6b31e860-10ee-43b8-b69b-3931b32aba37','2026-01-23 19:05:02.998340','2026-01-23 19:05:06.418097','2026-01-23 19:05:06.416968','6b31e860-10ee-43b8-b69b-3931b32aba37','0cdc36ee00844d51a9bfb80f7be4a983','6e81efcadc1a4938a53855b68f0acfd2','hostgroup@cephfs#cephfs',NULL,NULL,'deleting',NULL,NULL,NULL,'ce491032-81d6-4fd7-a801-52315e44f40b',NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec');
/*!40000 ALTER TABLE `share_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instance_access_map`
--

DROP TABLE IF EXISTS `share_instance_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instance_access_map` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `share_instance_id` varchar(36) DEFAULT NULL,
  `access_id` varchar(36) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `siam_instance_fk` (`share_instance_id`),
  KEY `siam_access_fk` (`access_id`),
  CONSTRAINT `siam_access_fk` FOREIGN KEY (`access_id`) REFERENCES `share_access_map` (`id`),
  CONSTRAINT `siam_instance_fk` FOREIGN KEY (`share_instance_id`) REFERENCES `share_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instance_access_map`
--

LOCK TABLES `share_instance_access_map` WRITE;
/*!40000 ALTER TABLE `share_instance_access_map` DISABLE KEYS */;
INSERT INTO `share_instance_access_map` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_instance_id`, `access_id`, `state`) VALUES ('2026-01-23 19:02:28.113534','2026-01-23 19:02:31.876798','2026-01-23 19:02:31.876357','073ebd2f-c1b5-480c-993b-14d14d3d7f29','073ebd2f-c1b5-480c-993b-14d14d3d7f29','4c4cc1cb-4d10-4014-806c-a3aa7cd153c6','d22f4149-9947-4344-804e-06348910de4e','deleted'),('2026-01-23 19:01:58.599713','2026-01-23 19:02:06.148332','2026-01-23 19:02:06.147862','0c91ac4f-1c67-41f1-9b2e-b50495119e62','0c91ac4f-1c67-41f1-9b2e-b50495119e62','957eb80d-b96f-4546-9b33-5d50aefacdfe','bb1424bf-b79d-461d-b5be-0aa3c37fdfe9','deleted'),('2026-01-23 19:04:30.572149','2026-01-23 19:04:35.382224','2026-01-23 19:04:35.381831','1150af1c-0366-4e4f-976a-062044d4fecd','1150af1c-0366-4e4f-976a-062044d4fecd','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','37808798-f444-4fd7-b543-7e5db4c5d5a5','deleted'),('2026-01-23 19:01:54.416345','2026-01-23 19:01:56.170121','2026-01-23 19:01:56.169094','1b70a521-c569-4b1c-838d-6da1aeb168d6','1b70a521-c569-4b1c-838d-6da1aeb168d6','7e746fb3-c8b1-4b98-8d5d-0856a5904d96','f46cc066-daf6-498a-8a79-a2027eec3736','deleted'),('2026-01-23 19:06:24.360682','2026-01-23 19:06:28.840617','2026-01-23 19:06:28.840135','2466271f-1d03-47d1-9b03-cef648d1a70a','2466271f-1d03-47d1-9b03-cef648d1a70a','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','44fa36de-07a8-4085-aec9-4794a7fb50af','deleted'),('2026-01-23 19:05:39.576227','2026-01-23 19:05:52.635503','2026-01-23 19:05:52.635112','26f91fd7-c08e-4b86-b5e4-e5f19472b835','26f91fd7-c08e-4b86-b5e4-e5f19472b835','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','08353937-22a0-4a38-8336-9b7dded61bd4','deleted'),('2026-01-23 19:04:06.568850','2026-01-23 19:04:12.013964','2026-01-23 19:04:12.013602','2e691e3e-e661-4727-8e3b-42e2ab1d701a','2e691e3e-e661-4727-8e3b-42e2ab1d701a','f985db04-31d5-4dab-ade3-fdc049b4357a','80616bb4-6d26-42b2-91d5-9428015fff90','deleted'),('2026-01-23 19:03:59.529923','2026-01-23 19:04:04.251870','2026-01-23 19:04:04.251346','2ed53a78-ad87-48f0-9f83-ecd4b3b4ef53','2ed53a78-ad87-48f0-9f83-ecd4b3b4ef53','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','d5da5d57-006e-48de-8f39-8fa5d7290f5b','deleted'),('2026-01-23 19:02:21.031015','2026-01-23 19:02:35.468059','2026-01-23 19:02:35.467517','3059070c-01f5-4e7d-a43c-096197a2fe08','3059070c-01f5-4e7d-a43c-096197a2fe08','27d42cf3-c581-4351-85ac-a91e5a37a2c7','206d5aed-6ccc-490e-86a1-678866f7f1cb','deleted'),('2026-01-23 19:05:32.158247','2026-01-23 19:05:38.918868','2026-01-23 19:05:38.918519','347a6326-bb15-4039-8327-e1a6de7371d4','347a6326-bb15-4039-8327-e1a6de7371d4','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','ee804d5e-58aa-4593-886c-f71d0a8921f2','deleted'),('2026-01-23 19:06:31.234040','2026-01-23 19:06:46.382549','2026-01-23 19:06:46.382132','36431551-8ec2-4e0b-973f-0b4af7eedbc7','36431551-8ec2-4e0b-973f-0b4af7eedbc7','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','7b509c97-c373-469f-a71e-73c05d408395','deleted'),('2026-01-23 19:03:45.213981','2026-01-23 19:03:49.183322','2026-01-23 19:03:49.182740','3f61dbdc-3d42-4311-949a-82dc087fe07e','3f61dbdc-3d42-4311-949a-82dc087fe07e','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','955d6163-4e5d-4102-91b1-5c3e9347f9e9','deleted'),('2026-01-23 19:03:52.200979','2026-01-23 19:03:56.326333','2026-01-23 19:03:56.325800','4af1ca10-0b5b-4d9d-8125-3eb58ce028d9','4af1ca10-0b5b-4d9d-8125-3eb58ce028d9','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','8bab543a-d9f7-4e51-9fb9-7b19daa0aabc','deleted'),('2026-01-23 19:05:24.708846','2026-01-23 19:05:28.976175','2026-01-23 19:05:28.975764','4cd31fcb-e4b9-4efc-8b60-0a9d394a39fa','4cd31fcb-e4b9-4efc-8b60-0a9d394a39fa','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','dc122773-8e5f-4599-bf59-4ce04b4ed7aa','deleted'),('2026-01-23 19:03:55.635964','2026-01-23 19:04:20.756668','2026-01-23 19:04:20.756189','504b613d-4914-4eb2-852f-e2cea94bf607','504b613d-4914-4eb2-852f-e2cea94bf607','f985db04-31d5-4dab-ade3-fdc049b4357a','d42eccdc-ad91-4736-aeac-16c8437380e9','deleted'),('2026-01-23 19:04:55.381334','2026-01-23 19:05:00.245936','2026-01-23 19:05:00.245467','5d1b095b-55da-48f3-8592-1da3c6272445','5d1b095b-55da-48f3-8592-1da3c6272445','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','80ec6408-07fa-454d-81cf-cf1c647592bd','deleted'),('2026-01-23 19:04:06.539320','2026-01-23 19:04:11.063899','2026-01-23 19:04:11.063517','5ef8ab5c-1242-4678-8cfd-426686816840','5ef8ab5c-1242-4678-8cfd-426686816840','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','da65c09a-2298-46e2-972f-1f28a92487ae','deleted'),('2026-01-23 19:06:38.976141','2026-01-23 19:06:43.053864','2026-01-23 19:06:43.053475','62c5559f-c7b6-46c1-a0df-ca78ee75b376','62c5559f-c7b6-46c1-a0df-ca78ee75b376','fba5485d-e5a8-4974-84d8-e4e56ba346a4','a7942d94-cdf2-4b0a-bc96-462aa747cafd','deleted'),('2026-01-23 19:06:28.291189','2026-01-23 19:06:32.932262','2026-01-23 19:06:32.931688','654ff408-4068-4037-b91d-0853ade913b1','654ff408-4068-4037-b91d-0853ade913b1','2d153082-1f6f-49c0-9c45-aa3f03ba31d4','5714c3cb-ff8d-44cc-ba28-04a30879d1f9','deleted'),('2026-01-23 19:03:23.265214','2026-01-23 19:03:27.707609','2026-01-23 19:03:27.707141','660f02dd-75ea-49a4-b357-ef8ee649dd03','660f02dd-75ea-49a4-b357-ef8ee649dd03','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','93868318-f7ab-418f-96fd-02dca51f438d','deleted'),('2026-01-23 19:06:35.269661','2026-01-23 19:06:40.608624','2026-01-23 19:06:40.608197','6d1cef52-86b0-45d9-9f89-135d67bd3d7a','6d1cef52-86b0-45d9-9f89-135d67bd3d7a','2d153082-1f6f-49c0-9c45-aa3f03ba31d4','cabc5650-cc0f-417b-bb07-72bd9c01b3f1','deleted'),('2026-01-23 19:04:14.402960','2026-01-23 19:04:20.712900','2026-01-23 19:04:20.712436','714fa822-f4a5-41dd-a094-d362fd78671e','714fa822-f4a5-41dd-a094-d362fd78671e','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','ed44e868-fc10-424f-8c11-0940a32756e8','deleted'),('2026-01-23 19:01:51.746834','2026-01-23 19:02:14.411679','2026-01-23 19:02:14.411191','71feff26-2508-45c0-8337-385307090ff1','71feff26-2508-45c0-8337-385307090ff1','1291e2ec-1b23-4741-b658-cb06b2d77e76','8971a8a8-c840-4ac1-a3e8-6afcf118871b','deleted'),('2026-01-23 19:04:37.835055','2026-01-23 19:04:43.692626','2026-01-23 19:04:43.691956','77abe5a4-549f-4214-a3e0-3c499330d288','77abe5a4-549f-4214-a3e0-3c499330d288','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','ede786ab-19d9-4dde-9106-48bb020b91cf','deleted'),('2026-01-23 19:06:01.145371','2026-01-23 19:06:06.875536','2026-01-23 19:06:06.874575','82ab6735-4d94-4420-b239-c38d09f46294','82ab6735-4d94-4420-b239-c38d09f46294','58ccdce1-cbc8-4922-8f55-95da428422fa','837f4568-5101-46a9-bea7-49836966cf5d','deleted'),('2026-01-23 19:06:17.045186','2026-01-23 19:06:22.489226','2026-01-23 19:06:22.488829','854bb1c8-ce63-43eb-ac75-f17f21ef41d4','854bb1c8-ce63-43eb-ac75-f17f21ef41d4','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','73d3c936-65fa-40ed-823e-f25ff194fd12','deleted'),('2026-01-23 19:04:46.493633','2026-01-23 19:04:52.568056','2026-01-23 19:04:52.567641','86f3d19a-171d-4e33-a7c7-2b915f062c7f','86f3d19a-171d-4e33-a7c7-2b915f062c7f','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','6cc3db01-4b75-4559-af3e-9fd02f0f596d','deleted'),('2026-01-23 19:04:23.167709','2026-01-23 19:04:27.713235','2026-01-23 19:04:27.712787','95b1d4be-aad5-4999-b19e-26f1760e2376','95b1d4be-aad5-4999-b19e-26f1760e2376','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','23939b5c-94e9-49d4-8a27-d657b917979d','deleted'),('2026-01-23 19:06:20.757056','2026-01-23 19:06:25.582596','2026-01-23 19:06:25.582203','a1e16d06-ffee-41fb-a850-215ec2f650df','a1e16d06-ffee-41fb-a850-215ec2f650df','2d153082-1f6f-49c0-9c45-aa3f03ba31d4','d4738379-fb8c-4ce3-a1f1-0ddc65a513fc','deleted'),('2026-01-23 19:03:30.925391','2026-01-23 19:03:34.959028','2026-01-23 19:03:34.958651','a7371d92-4e4c-4f3f-91db-14c83799ac93','a7371d92-4e4c-4f3f-91db-14c83799ac93','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','d342317c-10b3-40a1-a5bf-bb3b441079e8','deleted'),('2026-01-23 19:03:38.107201','2026-01-23 19:03:42.498375','2026-01-23 19:03:42.498003','a7778316-8f8b-478a-a97e-fce3d9b65005','a7778316-8f8b-478a-a97e-fce3d9b65005','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','e2533af8-b25f-4613-b248-45e14098446d','deleted'),('2026-01-23 19:06:01.965630','2026-01-23 19:06:06.658366','2026-01-23 19:06:06.658016','abf3c66f-c06c-4a81-b27a-364fffdac4b7','abf3c66f-c06c-4a81-b27a-364fffdac4b7','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','b8099063-8d9f-48f8-bcc4-b25b2cab9157','deleted'),('2026-01-23 19:02:17.405833','2026-01-23 19:02:50.215068','2026-01-23 19:02:50.214712','ac61214c-2a34-4fd4-990e-aeb35f185e4f','ac61214c-2a34-4fd4-990e-aeb35f185e4f','27d42cf3-c581-4351-85ac-a91e5a37a2c7','7e5b419f-d0bb-43dd-b357-9422e267be95','deleted'),('2026-01-23 19:03:59.103474','2026-01-23 19:04:04.230697','2026-01-23 19:04:04.230200','afa1cd71-ba26-4465-9c71-c134b0d2dfbb','afa1cd71-ba26-4465-9c71-c134b0d2dfbb','f985db04-31d5-4dab-ade3-fdc049b4357a','94b60fa7-ac31-413c-9e1f-d7c72259d85d','deleted'),('2026-01-23 19:05:54.173813','2026-01-23 19:05:58.846938','2026-01-23 19:05:58.846353','c98f6820-a697-4e6e-93ef-8dc4a939eec5','c98f6820-a697-4e6e-93ef-8dc4a939eec5','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','90214cb7-685b-4154-bb9e-1bc671058da8','deleted'),('2026-01-23 19:05:03.559359','2026-01-23 19:05:08.485114','2026-01-23 19:05:08.484715','ccab82d4-99a9-440b-8400-4d38114f36d4','ccab82d4-99a9-440b-8400-4d38114f36d4','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','e837cb99-067d-4e96-b02a-ecd310609055','deleted'),('2026-01-23 19:06:09.511400','2026-01-23 19:06:15.601945','2026-01-23 19:06:15.601163','cfd7a859-445c-4fb4-b979-1c7cbfe2170f','cfd7a859-445c-4fb4-b979-1c7cbfe2170f','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','93f79db3-0d4c-4b47-92a7-c86a02326bb2','deleted'),('2026-01-23 19:05:10.643751','2026-01-23 19:05:14.685502','2026-01-23 19:05:14.685035','d145ae67-124c-4631-a8f5-8f4c3c97bd92','d145ae67-124c-4631-a8f5-8f4c3c97bd92','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','f6fbba55-33d5-48ac-a099-1691d3e433d8','deleted'),('2026-01-23 19:02:02.294732','2026-01-23 19:02:11.059499','2026-01-23 19:02:11.058940','d1d2abfd-fbb0-4a0a-946f-bc775a27c3d0','d1d2abfd-fbb0-4a0a-946f-bc775a27c3d0','957eb80d-b96f-4546-9b33-5d50aefacdfe','e0543fe7-c931-41e7-b972-b9af835658f0','deleted'),('2026-01-23 19:05:17.515846','2026-01-23 19:05:21.628155','2026-01-23 19:05:21.627802','d59c0dde-4732-45bf-98e9-24815faabf0f','d59c0dde-4732-45bf-98e9-24815faabf0f','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','9abc1852-3812-4ad8-bc3d-46550e1940df','deleted'),('2026-01-23 19:06:42.205293','2026-01-23 19:06:46.581371','2026-01-23 19:06:46.580927','d96bfbd4-385a-473a-8d85-a5bc05d807d6','d96bfbd4-385a-473a-8d85-a5bc05d807d6','2d153082-1f6f-49c0-9c45-aa3f03ba31d4','ae0a179f-210f-47f4-8eed-d3b014bfeb93','deleted'),('2026-01-23 19:06:13.506349','2026-01-23 19:06:19.278382','2026-01-23 19:06:19.277889','e5d8cebb-9c7c-4dd3-be55-0352763530fb','e5d8cebb-9c7c-4dd3-be55-0352763530fb','e1861ac0-d15e-48e7-8018-9e451a8b3dee','009dc29b-0fe0-4160-a616-f7f4f249ff8d','deleted'),('2026-01-23 19:05:43.003700','2026-01-23 19:05:54.296489','2026-01-23 19:05:54.296079','e9356dfb-4971-4997-8e28-317d8cf98e93','e9356dfb-4971-4997-8e28-317d8cf98e93','34962dc4-5e08-41ca-b8ab-f76521ae76f2','b161c3b8-b4db-43c0-889b-96666a2a657f','deleted');
/*!40000 ALTER TABLE `share_instance_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instance_export_locations`
--

DROP TABLE IF EXISTS `share_instance_export_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instance_export_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `path` varchar(2000) DEFAULT NULL,
  `share_instance_id` varchar(36) DEFAULT NULL,
  `is_admin_only` tinyint(1) DEFAULT NULL,
  `uuid` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `sel_instance_id_fk` (`share_instance_id`),
  CONSTRAINT `sel_instance_id_fk` FOREIGN KEY (`share_instance_id`) REFERENCES `share_instances` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instance_export_locations`
--

LOCK TABLES `share_instance_export_locations` WRITE;
/*!40000 ALTER TABLE `share_instance_export_locations` DISABLE KEYS */;
INSERT INTO `share_instance_export_locations` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `path`, `share_instance_id`, `is_admin_only`, `uuid`) VALUES (1,'2026-01-23 18:59:53.953757','2026-01-23 19:01:24.482571','2026-01-23 19:01:24.481029',1,'192.168.122.100:6789:/volumes/_nogroup/813e89aa-6f7f-4c70-8d5a-de6aa64dcb0f/96bd1521-7f0a-4814-8a3f-4ba43ad77cc6','813e89aa-6f7f-4c70-8d5a-de6aa64dcb0f',0,'c979967b-39b1-4ecc-86bc-4a7e19fbe818'),(2,'2026-01-23 18:59:56.721951','2026-01-23 19:00:05.022959','2026-01-23 19:00:05.022104',2,'192.168.122.100:6789:/volumes/_nogroup/f7fdf74a-3877-444d-a8d2-806e64741582/564694cf-df71-4f18-9d9f-cc11342eec83','f7fdf74a-3877-444d-a8d2-806e64741582',0,'cfd196ad-085f-4944-bf1a-2917f5c281b0'),(3,'2026-01-23 18:59:57.123087','2026-01-23 19:00:08.417504','2026-01-23 19:00:08.415506',3,'192.168.122.100:6789:/volumes/_nogroup/a0a8215b-eedb-45d9-a08e-7e13600761d5/58c64058-42c9-4d10-bcaa-c172aded3cf6','a0a8215b-eedb-45d9-a08e-7e13600761d5',0,'707839f2-c252-4c3f-bbbd-a7b3382932a0'),(4,'2026-01-23 18:59:57.311925','2026-01-23 19:00:03.401476','2026-01-23 19:00:03.400260',4,'192.168.122.100:6789:/volumes/_nogroup/c9f4e008-d833-4462-9cc2-c6b75c41215b/98ac6f0c-3dab-4248-b0bb-2aa3d9aa4d2e','c9f4e008-d833-4462-9cc2-c6b75c41215b',0,'4c33b17f-0da7-4afa-b7a2-19eae28f1bd1'),(5,'2026-01-23 19:00:06.158326','2026-01-23 19:00:09.705574','2026-01-23 19:00:09.704267',5,'192.168.122.100:6789:/volumes/_nogroup/a8a8bc57-0cf3-40b2-af69-e9b0e686c548/ed0bd6c2-d3b2-4881-adac-ee4b7ce9441d','a8a8bc57-0cf3-40b2-af69-e9b0e686c548',0,'0fc191b1-a52d-4238-b869-893257999ec2'),(6,'2026-01-23 19:00:12.485711','2026-01-23 19:00:18.742729','2026-01-23 19:00:18.741624',6,'192.168.122.100:6789:/volumes/_nogroup/9ba675d4-570c-4cbb-af0d-aeb9f85aa3ba/450b6288-d44e-4784-afc8-35081d573dbf','9ba675d4-570c-4cbb-af0d-aeb9f85aa3ba',0,'a00be454-c9c2-49d9-ab56-d593c09acc4f'),(7,'2026-01-23 19:00:13.276338','2026-01-23 19:00:17.142135','2026-01-23 19:00:17.140727',7,'192.168.122.100:6789:/volumes/_nogroup/049e69f2-19e1-41e8-b13d-2d953d142e3c/76a3c7d0-7076-4941-abae-fe7b4a268443','049e69f2-19e1-41e8-b13d-2d953d142e3c',0,'deeb77cb-6d15-42dc-943e-0207c2658d30'),(8,'2026-01-23 19:00:20.856685','2026-01-23 19:00:24.526162','2026-01-23 19:00:24.525187',8,'192.168.122.100:6789:/volumes/_nogroup/e378cb20-e217-4231-960b-f50749860b80/13537e84-a011-4234-ada7-6aaf18524ea7','e378cb20-e217-4231-960b-f50749860b80',0,'37763e50-8149-4f7c-8a50-21f8ef5c8be8'),(9,'2026-01-23 19:00:25.017665','2026-01-23 19:00:32.629889','2026-01-23 19:00:32.628812',9,'192.168.122.100:6789:/volumes/_nogroup/e6c475e8-8ebf-4542-a7ab-36860fe78789/4fe40108-7329-4a56-a747-8b44a0e65832','e6c475e8-8ebf-4542-a7ab-36860fe78789',0,'aa396545-5545-4929-8044-48b8c42c078c'),(10,'2026-01-23 19:00:28.878568','2026-01-23 19:00:36.151681','2026-01-23 19:00:36.150020',10,'192.168.122.100:6789:/volumes/_nogroup/a78e7c29-37d2-401f-be9f-e1812f305e12/dffda640-1089-4f8a-a2cd-cc394b3690b3','a78e7c29-37d2-401f-be9f-e1812f305e12',0,'d39d97c0-5b8e-4044-bfaa-3e868dbc03d0'),(11,'2026-01-23 19:00:43.122179','2026-01-23 19:01:08.168592','2026-01-23 19:01:08.167486',11,'192.168.122.100:6789:/volumes/_nogroup/8c3aacd4-958b-4e71-b998-b587ef3cb3df/894bfdbb-349c-49c6-8970-c5295fcef973','8c3aacd4-958b-4e71-b998-b587ef3cb3df',0,'da39e5ca-9b26-43db-8220-45686352cadc'),(12,'2026-01-23 19:01:21.984950','2026-01-23 19:01:57.045145','2026-01-23 19:01:57.044282',12,'192.168.122.100:6789:/volumes/_nogroup/d1a416c3-7f64-49d4-b1be-a176db014aeb/a55bf9e0-b519-442a-b27b-cc3f11223d87','d1a416c3-7f64-49d4-b1be-a176db014aeb',0,'6c3cb20d-7a70-4d26-8068-438a4a4ccd44'),(13,'2026-01-23 19:01:28.826954','2026-01-23 19:01:53.475809','2026-01-23 19:01:53.474374',13,'192.168.122.100:6789:/volumes/_nogroup/349e50d8-8b7b-4b2a-9bbb-82e4a22fd8a9/49b99125-16c3-4f13-8156-4b095d27bbdb','349e50d8-8b7b-4b2a-9bbb-82e4a22fd8a9',0,'98a690c8-dac9-4dc5-9c89-13aec6c2aafc'),(14,'2026-01-23 19:01:44.960351','2026-01-23 19:02:50.359020','2026-01-23 19:02:50.357839',14,'192.168.122.100:6789:/volumes/_nogroup/27d42cf3-c581-4351-85ac-a91e5a37a2c7/c1ace486-d1b1-40ea-947d-f01d12491da4','27d42cf3-c581-4351-85ac-a91e5a37a2c7',0,'11723b31-4c33-41a9-af89-38f32b9d90cd'),(15,'2026-01-23 19:01:48.538570','2026-01-23 19:02:46.188930','2026-01-23 19:02:46.187791',15,'192.168.122.100:6789:/volumes/_nogroup/1291e2ec-1b23-4741-b658-cb06b2d77e76/ffba04e2-08cf-47b9-bd47-0043de8e96c3','1291e2ec-1b23-4741-b658-cb06b2d77e76',0,'6a684a9a-0d8e-4948-bbfd-1b9e3d4b15fe'),(16,'2026-01-23 19:01:51.465207','2026-01-23 19:01:56.251070','2026-01-23 19:01:56.250161',16,'192.168.122.100:6789:/volumes/_nogroup/7e746fb3-c8b1-4b98-8d5d-0856a5904d96/f32de13e-2f8a-40aa-a81e-50c3527b0601','7e746fb3-c8b1-4b98-8d5d-0856a5904d96',0,'155ed1d3-adb7-4836-8a5e-62500a1d0101'),(17,'2026-01-23 19:01:51.950508','2026-01-23 19:01:55.339724','2026-01-23 19:01:55.338683',17,'192.168.122.100:6789:/volumes/_nogroup/0b2a4f38-d054-4cd4-98b9-e0a2222a0f26/70fda8a1-fc9d-4241-920f-230513aae6ff','0b2a4f38-d054-4cd4-98b9-e0a2222a0f26',0,'6098b8f9-7dfe-430f-bda9-f11fdae11954'),(18,'2026-01-23 19:01:55.505508','2026-01-23 19:02:42.872255','2026-01-23 19:02:42.870767',18,'192.168.122.100:6789:/volumes/_nogroup/957eb80d-b96f-4546-9b33-5d50aefacdfe/229e3528-6bd5-404f-9247-9cadfdbd82bc','957eb80d-b96f-4546-9b33-5d50aefacdfe',0,'5992f772-e6e6-41fc-8118-7fa2ba7a4b7a'),(19,'2026-01-23 19:02:14.564534','2026-01-23 19:03:02.659539','2026-01-23 19:03:02.658656',19,'192.168.122.100:6789:/volumes/_nogroup/638d8bf8-4cef-4bb0-add8-32a6d6937431/e56f1a85-9f86-4f29-8f7c-a28f7c361b9c','638d8bf8-4cef-4bb0-add8-32a6d6937431',0,'337694b7-ffb7-49d2-aa41-047f67ad7033'),(20,'2026-01-23 19:02:16.791973','2026-01-23 19:02:30.741909','2026-01-23 19:02:30.740945',20,'192.168.122.100:6789:/volumes/_nogroup/cea1143e-99c2-47fd-9222-42d7395a438e/16ff9829-c1d2-49e8-8fb9-df5f99e144d5','cea1143e-99c2-47fd-9222-42d7395a438e',0,'3f7508c8-242d-4cfe-893d-e4c1269152fb'),(21,'2026-01-23 19:02:16.919468','2026-01-23 19:02:21.740483','2026-01-23 19:02:21.739095',21,'192.168.122.100:6789:/volumes/_nogroup/0e81367e-537f-4aee-8570-08ff0c9c7c27/eae16b10-8aa6-446d-a800-4d1b31446b6e','0e81367e-537f-4aee-8570-08ff0c9c7c27',0,'f88fd132-013a-4a9d-8019-aca33f74fe0d'),(22,'2026-01-23 19:02:18.385236','2026-01-23 19:02:21.908534','2026-01-23 19:02:21.906346',22,'192.168.122.100:6789:/volumes/_nogroup/8254111f-72e3-43c6-937a-37e35e2a9b5f/6c61b547-9f38-4188-9422-572853b300e5','8254111f-72e3-43c6-937a-37e35e2a9b5f',0,'f56314b3-08b6-44c1-b003-276d00d1305d'),(23,'2026-01-23 19:02:25.188055','2026-01-23 19:02:39.211941','2026-01-23 19:02:39.210989',23,'192.168.122.100:6789:/volumes/_nogroup/4c4cc1cb-4d10-4014-806c-a3aa7cd153c6/c65e0bdc-4763-488c-8bc4-5dc94ca352d7','4c4cc1cb-4d10-4014-806c-a3aa7cd153c6',0,'2d4a1879-67c3-4e67-b793-c983bbaa52fa'),(24,'2026-01-23 19:02:25.543267','2026-01-23 19:02:30.298160','2026-01-23 19:02:30.296844',24,'192.168.122.100:6789:/volumes/_nogroup/ea8f2387-32ae-461c-a095-2db8629c4d12/1c646e6e-b031-4cb5-a96f-273ae0fc543e','ea8f2387-32ae-461c-a095-2db8629c4d12',0,'1e8db367-aa08-42f8-b8ad-4efd0de2f250'),(25,'2026-01-23 19:02:33.767567','2026-01-23 19:02:37.445613','2026-01-23 19:02:37.444750',25,'192.168.122.100:6789:/volumes/_nogroup/9ff37cdd-dadb-4205-9f9d-26df1c040f98/ca70c03c-fab0-43fc-8eb7-994fe6b42801','9ff37cdd-dadb-4205-9f9d-26df1c040f98',0,'ca6d983c-056f-485d-ac2d-bdaaf3117373'),(26,'2026-01-23 19:02:37.272936','2026-01-23 19:03:08.940951','2026-01-23 19:03:08.939881',26,'192.168.122.100:6789:/volumes/_nogroup/f6c4c50e-f72c-439c-a86a-fc2726fe09af/2749c494-8646-4af9-9180-34590b901d74','f6c4c50e-f72c-439c-a86a-fc2726fe09af',0,'30e76571-3e85-4df7-ae9b-be1216182da9'),(27,'2026-01-23 19:02:40.925120','2026-01-23 19:02:51.040144','2026-01-23 19:02:51.039142',27,'192.168.122.100:6789:/volumes/_nogroup/da2057f4-30b8-4287-b324-aaa510666419/1f00d6e5-9724-4d7b-9984-7f13c821915d','da2057f4-30b8-4287-b324-aaa510666419',0,'dcdefe0c-e4d7-47e4-a4a3-6a151c6cf0a6'),(28,'2026-01-23 19:02:41.082486','2026-01-23 19:02:45.504832','2026-01-23 19:02:45.503729',28,'192.168.122.100:6789:/volumes/_nogroup/0ec0da82-b94c-4d70-ba4c-e5b9fc27dc1e/f13c888d-5714-4252-924d-106f140f5711','0ec0da82-b94c-4d70-ba4c-e5b9fc27dc1e',0,'7a06fd87-2bd3-4eb1-a594-8ae481af376c'),(29,'2026-01-23 19:02:50.931779','2026-01-23 19:02:56.656270','2026-01-23 19:02:56.655175',29,'192.168.122.100:6789:/volumes/_nogroup/a9ac4747-bff1-455b-923a-8ae6bf6a959a/f42dbae3-77db-4923-a7b0-e305383e81b8','a9ac4747-bff1-455b-923a-8ae6bf6a959a',0,'873159cd-a0db-4c97-a079-bbe459153cc4'),(30,'2026-01-23 19:02:56.152642','2026-01-23 19:03:01.890331','2026-01-23 19:03:01.889304',30,'192.168.122.100:6789:/volumes/_nogroup/821840f9-97a9-48b2-a779-bb77ecd1f3bf/32292b2b-cecc-42cd-8eca-13e275c0c590','821840f9-97a9-48b2-a779-bb77ecd1f3bf',0,'dfffcc5e-c393-41ca-8d01-3dccb7401a60'),(31,'2026-01-23 19:03:02.471205','2026-01-23 19:03:12.013284','2026-01-23 19:03:12.012067',31,'192.168.122.100:6789:/volumes/_nogroup/26b68481-1e3f-49e4-928e-ce608e53fe50/906a1cf5-1886-4fbc-8409-b6578de293bc','26b68481-1e3f-49e4-928e-ce608e53fe50',0,'dff53327-52df-400b-b9f4-b21349e6acfa'),(32,'2026-01-23 19:03:20.274523','2026-01-23 19:06:50.482684','2026-01-23 19:06:50.481549',32,'192.168.122.100:6789:/volumes/_nogroup/9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6/26ffb8a8-1216-4627-b59b-a809cb977363','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6',0,'0f39782a-20c3-48df-bf11-69d97c6369ce'),(33,'2026-01-23 19:03:41.114586','2026-01-23 19:04:08.000158','2026-01-23 19:04:07.995159',33,'192.168.122.100:6789:/volumes/_nogroup/ee5c9b95-36ca-40c5-b310-750aabee4b07/5d542ba0-e40a-46d8-ae5d-1a05dc65bf0f','ee5c9b95-36ca-40c5-b310-750aabee4b07',0,'0bd56985-da72-429e-b08e-12ee94e3b80d'),(34,'2026-01-23 19:03:45.320063','2026-01-23 19:04:04.534862','2026-01-23 19:04:04.533520',34,'192.168.122.100:6789:/volumes/_nogroup/2cc197a2-1b4a-427e-9d00-dd49916b35df/17390c27-2061-4f50-9c26-0635782ac042','2cc197a2-1b4a-427e-9d00-dd49916b35df',0,'8a25d03f-1e82-4c72-95ac-ea0910d812c2'),(35,'2026-01-23 19:03:49.629644','2026-01-23 19:04:01.208568','2026-01-23 19:04:01.206573',35,'192.168.122.100:6789:/volumes/_nogroup/3f4b47db-bc72-4155-915f-95273d2ed043/58324401-fe57-4f8a-a583-6442ca4cfa06','3f4b47db-bc72-4155-915f-95273d2ed043',0,'e1df7191-b306-48e3-a3bb-0ec64e0ea022'),(36,'2026-01-23 19:03:52.613023','2026-01-23 19:04:20.894805','2026-01-23 19:04:20.893248',36,'192.168.122.100:6789:/volumes/_nogroup/f985db04-31d5-4dab-ade3-fdc049b4357a/96161543-030c-47f7-ace7-5f41849f177e','f985db04-31d5-4dab-ade3-fdc049b4357a',0,'7473e2c5-47e2-40cd-8287-f79843fbae12'),(37,'2026-01-23 19:03:53.338936','2026-01-23 19:03:57.563209','2026-01-23 19:03:57.562235',37,'192.168.122.100:6789:/volumes/_nogroup/e51baba4-47d7-48aa-a6e0-ba58a86949b3/ffaa2ae9-32ce-459c-8b7f-8295bd6cd7c9','e51baba4-47d7-48aa-a6e0-ba58a86949b3',0,'3270807b-b43a-4819-ab25-b1328c8ff19d'),(38,'2026-01-23 19:04:23.125773','2026-01-23 19:04:34.628652','2026-01-23 19:04:34.626936',38,'192.168.122.100:6789:/volumes/_nogroup/58517681-eea7-4542-9aa9-1caa99f33856/ece6447e-bcfc-4f26-ad8c-6adbc2f5f1ce','58517681-eea7-4542-9aa9-1caa99f33856',0,'94e69f5c-27cb-4497-a6a8-a01282b5dd88'),(39,'2026-01-23 19:04:27.479882','2026-01-23 19:04:30.774528','2026-01-23 19:04:30.772359',39,'192.168.122.100:6789:/volumes/_nogroup/5229476a-6a4f-49c2-9bcd-5dab192f60a7/aa98ede0-bb9c-4d11-a1b5-374c41fb367d','5229476a-6a4f-49c2-9bcd-5dab192f60a7',0,'7ec552ab-fd42-41cd-9f01-bacbee27b1ea'),(40,'2026-01-23 19:04:39.343621','2026-01-23 19:04:51.919527','2026-01-23 19:04:51.915757',40,'192.168.122.100:6789:/volumes/_nogroup/ea32016d-d076-4cdb-87b1-5845df1c383d/3d3aa4a3-c446-44bf-8f3f-09134b386913','ea32016d-d076-4cdb-87b1-5845df1c383d',0,'98809662-366f-4ca6-bbd9-cf4de6488303'),(41,'2026-01-23 19:04:39.384668','2026-01-23 19:04:43.156269','2026-01-23 19:04:43.155306',41,'192.168.122.100:6789:/volumes/_nogroup/f6fe75ed-09c7-41b1-a5a6-78194558df7e/fc40569c-59bd-4440-9d0b-4c4bcae98971','f6fe75ed-09c7-41b1-a5a6-78194558df7e',0,'569c1eeb-5758-4c2b-9229-e646ef3ae4a3'),(42,'2026-01-23 19:04:43.703110','2026-01-23 19:04:48.060034','2026-01-23 19:04:48.059129',42,'192.168.122.100:6789:/volumes/_nogroup/dca5fa61-ae49-4ea7-b61f-b63caccb203e/8273c511-737c-4532-9ce0-819958a98905','dca5fa61-ae49-4ea7-b61f-b63caccb203e',0,'3868ef85-ae80-46e1-9259-f002452293fe'),(43,'2026-01-23 19:04:52.828956','2026-01-23 19:04:57.902763','2026-01-23 19:04:57.901531',43,'192.168.122.100:6789:/volumes/_nogroup/7581fe4e-6784-4ac5-b13d-2b32f94d378c/9d568488-ab47-4810-961b-d742f695cd05','7581fe4e-6784-4ac5-b13d-2b32f94d378c',0,'1e099b90-cbeb-4163-a5a0-de67494f0c9b'),(44,'2026-01-23 19:05:08.266163','2026-01-23 19:05:11.588227','2026-01-23 19:05:11.585783',44,'192.168.122.100:6789:/volumes/_nogroup/7c8fd20a-b01b-4f68-87ff-9188d64cf184/5ec7af24-272a-498e-b331-4b1a4ef130ee','7c8fd20a-b01b-4f68-87ff-9188d64cf184',0,'6b53226d-d388-43c5-8c9e-5991427f6a90'),(45,'2026-01-23 19:05:14.466663','2026-01-23 19:05:19.670865','2026-01-23 19:05:19.668677',45,'192.168.122.100:6789:/volumes/_nogroup/c88504fb-ae34-4350-82e6-9d10001a8eb2/b70a76b5-edec-4772-b13c-7b2ca6c4f906','c88504fb-ae34-4350-82e6-9d10001a8eb2',0,'54786256-5c5b-4645-87a4-596596756579'),(46,'2026-01-23 19:05:16.011793','2026-01-23 19:05:19.664922','2026-01-23 19:05:19.663394',46,'192.168.122.100:6789:/volumes/_nogroup/89e841f0-56dd-4e4e-8222-ae52cf7d9c48/d531052d-a685-4ac9-9d4c-5e839929ec39','89e841f0-56dd-4e4e-8222-ae52cf7d9c48',0,'f0aa11fb-38d6-42fd-bd4d-7141c750a360'),(47,'2026-01-23 19:05:33.343563','2026-01-23 19:05:49.095046','2026-01-23 19:05:49.093928',47,'192.168.122.100:6789:/volumes/_nogroup/2649806c-36b6-496b-8324-f7d5569ca22e/28d335de-0c89-48c0-958c-a1737bc8ff9f','2649806c-36b6-496b-8324-f7d5569ca22e',0,'b0b585bd-23bd-493f-935f-61df723158b5'),(48,'2026-01-23 19:05:35.510339','2026-01-23 19:06:50.748018','2026-01-23 19:06:50.747178',48,'192.168.122.100:6789:/volumes/_nogroup/2d153082-1f6f-49c0-9c45-aa3f03ba31d4/4af2fca2-ded3-4f0d-9e2e-b14759090fe4','2d153082-1f6f-49c0-9c45-aa3f03ba31d4',0,'f8e0c972-321d-4b14-be7d-8027ee040244'),(49,'2026-01-23 19:05:40.701730','2026-01-23 19:05:54.966036','2026-01-23 19:05:54.964267',49,'192.168.122.100:6789:/volumes/_nogroup/34962dc4-5e08-41ca-b8ab-f76521ae76f2/18be0f70-6e8c-433a-aaa5-ff75690f3db2','34962dc4-5e08-41ca-b8ab-f76521ae76f2',0,'d6b2d5ce-f6fe-4b84-8c6e-67c9511f094b'),(50,'2026-01-23 19:05:55.744354','2026-01-23 19:05:58.980751','2026-01-23 19:05:58.979160',50,'192.168.122.100:6789:/volumes/_nogroup/7c487935-93a6-4d7a-a6c9-f402d645b4e2/32b41355-85ca-4a8d-bb24-3bc26dbaf676','7c487935-93a6-4d7a-a6c9-f402d645b4e2',0,'eb0a113f-3caf-4aba-a9d3-dba6590e3183'),(51,'2026-01-23 19:05:58.095439','2026-01-23 19:06:06.975677','2026-01-23 19:06:06.974300',51,'192.168.122.100:6789:/volumes/_nogroup/58ccdce1-cbc8-4922-8f55-95da428422fa/0fc65e1a-93c9-48b8-acca-6485b788fa73','58ccdce1-cbc8-4922-8f55-95da428422fa',0,'d9caf286-d530-414c-9e32-21c3087781d3'),(52,'2026-01-23 19:06:06.276333','2026-01-23 19:07:02.931946','2026-01-23 19:07:02.930147',52,'192.168.122.100:6789:/volumes/_nogroup/a974fb39-4b39-4d59-84a7-f8f3ffa56b12/6132594c-6945-4493-8278-28b4ac14c072','a974fb39-4b39-4d59-84a7-f8f3ffa56b12',0,'0a355063-1f83-4e9b-a4a0-94d565e0ab8c'),(53,'2026-01-23 19:06:09.940941','2026-01-23 19:06:19.392587','2026-01-23 19:06:19.390561',53,'192.168.122.100:6789:/volumes/_nogroup/e1861ac0-d15e-48e7-8018-9e451a8b3dee/8d49cc89-ff1c-401b-8222-1d3cb91f7a28','e1861ac0-d15e-48e7-8018-9e451a8b3dee',0,'c9f43567-e14b-4815-905d-40e5f26efe03'),(54,'2026-01-23 19:06:28.084787','2026-01-23 19:06:31.523316','2026-01-23 19:06:31.522002',54,'192.168.122.100:6789:/volumes/_nogroup/137cf5f0-949a-449f-82d0-ceae6fdaaa3e/6215fdcb-384f-465a-8c54-7825a9e0a2fc','137cf5f0-949a-449f-82d0-ceae6fdaaa3e',0,'17073a15-c8d6-4ce1-821b-ae0c5aff0aa6'),(55,'2026-01-23 19:06:35.915439','2026-01-23 19:06:39.235475','2026-01-23 19:06:39.232005',55,'192.168.122.100:6789:/volumes/_nogroup/4ab0802a-2a55-43b2-9e63-a0e480add7c1/a8f40bcc-fe1e-443d-bbfb-b54817d514cc','4ab0802a-2a55-43b2-9e63-a0e480add7c1',0,'de05428c-472c-4e7d-8484-73b731c04170'),(56,'2026-01-23 19:06:36.281183','2026-01-23 19:06:36.279239',NULL,0,'192.168.122.100:6789:/volumes/_nogroup/fba5485d-e5a8-4974-84d8-e4e56ba346a4/9aee36c1-5f50-49fa-9e8e-df410133e8e1','fba5485d-e5a8-4974-84d8-e4e56ba346a4',0,'92c5c1cb-1bb8-4264-a7b6-dd7eedd408ec'),(57,'2026-01-23 19:06:52.676403','2026-01-23 19:06:55.821584','2026-01-23 19:06:55.820284',57,'192.168.122.100:6789:/volumes/_nogroup/2372c43f-e00a-4e92-b338-82e4882d6cb1/f3b88e5e-db71-4c1b-85c2-3d20d6b3d0d4','2372c43f-e00a-4e92-b338-82e4882d6cb1',0,'cfba5c5c-7f0b-4e49-85f6-ebc2d52b0f57'),(58,'2026-01-23 19:07:16.830760','2026-01-23 19:08:38.476068','2026-01-23 19:08:38.475173',58,'192.168.122.100:6789:/volumes/_nogroup/c09bd88d-6bf6-440e-b929-87c3d463c101/f9d6d7b8-b95f-4222-aee0-6813a4f2131f','c09bd88d-6bf6-440e-b929-87c3d463c101',0,'9426e417-abc6-421e-b4e7-adefe90fb22a'),(59,'2026-01-23 19:07:31.335646','2026-01-23 19:07:37.003130','2026-01-23 19:07:37.002104',59,'192.168.122.100:6789:/volumes/_nogroup/ca22b681-9cb5-4a64-81d1-5d9133599b53/b730fee6-f526-440c-a62b-fbd5a1b98ada','ca22b681-9cb5-4a64-81d1-5d9133599b53',0,'1a8a8eae-4bfd-4375-b41e-2d4590246ac2'),(60,'2026-01-23 19:07:42.314257','2026-01-23 19:07:56.370078','2026-01-23 19:07:56.368985',60,'192.168.122.100:6789:/volumes/_nogroup/f0a550da-da13-43b9-818c-b94c83664b8c/f9891615-1e88-4a61-a7db-0b03b2a7dd06','f0a550da-da13-43b9-818c-b94c83664b8c',0,'e8cbdf55-681b-44d6-9b71-86b76d4150c0'),(61,'2026-01-23 19:07:50.058365','2026-01-23 19:08:39.096895','2026-01-23 19:08:39.095869',61,'192.168.122.100:6789:/volumes/_nogroup/a1da1abe-af26-445a-9262-0ff686ee8203/caefab48-56b5-452f-a972-3e8fed4bff9b','a1da1abe-af26-445a-9262-0ff686ee8203',0,'31b6fbd6-38f1-4bd3-b314-dcac0a6f483b'),(62,'2026-01-23 19:07:56.365910','2026-01-23 19:08:31.524073','2026-01-23 19:08:31.521644',62,'192.168.122.100:6789:/volumes/_nogroup/c5afb25c-aa10-424c-a2b9-1de8cd95ec12/cf543da1-dccc-482e-bb6f-381638973d21','c5afb25c-aa10-424c-a2b9-1de8cd95ec12',0,'9908a4bc-b9f9-41e1-a5a2-9d99ae555cb4'),(63,'2026-01-23 19:07:58.683991','2026-01-23 19:08:02.547932','2026-01-23 19:08:02.546887',63,'192.168.122.100:6789:/volumes/_nogroup/cb820b50-42e3-42ba-9e37-9bcbf6f06c8c/8edecfc0-efcd-409f-9b95-38cd77cf76c1','cb820b50-42e3-42ba-9e37-9bcbf6f06c8c',0,'7e021bad-347c-44ff-a2ac-5163f5cfc667'),(64,'2026-01-23 19:07:58.994501','2026-01-23 19:08:06.049980','2026-01-23 19:08:06.048908',64,'192.168.122.100:6789:/volumes/_nogroup/f56806ef-3edf-4541-b599-18f3a7b7c7c4/2431a9b3-a5b4-4eec-ad8e-ef75ef7b1c87','f56806ef-3edf-4541-b599-18f3a7b7c7c4',0,'3c01af40-a2bf-4831-8616-afd92cdab24e'),(65,'2026-01-23 19:08:05.587200','2026-01-23 19:09:01.134263','2026-01-23 19:09:01.133199',65,'192.168.122.100:6789:/volumes/_nogroup/b8a58bec-b849-4bc6-8dba-3cc458df53f5/3c0741de-9039-4fe3-b2d7-809655c235a1','b8a58bec-b849-4bc6-8dba-3cc458df53f5',0,'6a45d0ed-824d-4e40-8b15-206edf0d25e2'),(66,'2026-01-23 19:08:06.317892','2026-01-23 19:08:09.820705','2026-01-23 19:08:09.819509',66,'192.168.122.100:6789:/volumes/_nogroup/897e454b-4a6d-4c3a-bde6-222bf698dc84/30e45005-9d16-408a-8fd0-e7f60a03fde4','897e454b-4a6d-4c3a-bde6-222bf698dc84',0,'8ce01853-86c9-4187-8efa-88f85e1ad765'),(67,'2026-01-23 19:08:13.317188','2026-01-23 19:08:19.885194','2026-01-23 19:08:19.883913',67,'192.168.122.100:6789:/volumes/_nogroup/9a2901e0-1e2a-431b-ad0b-0539c4b54da0/95a77749-507c-4b3a-b63b-6b2b655ed135','9a2901e0-1e2a-431b-ad0b-0539c4b54da0',0,'6f648ed3-2bd2-4af2-9590-0b1dfc41a7a1'),(68,'2026-01-23 19:08:13.454221','2026-01-23 19:08:16.880795','2026-01-23 19:08:16.879867',68,'192.168.122.100:6789:/volumes/_nogroup/3732f0e1-a134-4643-95be-27f3fc23eec2/c203658f-cf43-4de7-b814-374f653abba1','3732f0e1-a134-4643-95be-27f3fc23eec2',0,'d7b2d5e4-ebe8-48e7-92c3-03a1ac323062'),(69,'2026-01-23 19:08:20.273193','2026-01-23 19:08:24.042567','2026-01-23 19:08:24.041509',69,'192.168.122.100:6789:/volumes/_nogroup/82ea23d8-4358-4944-b79d-0263b8fedbbf/891bbab1-e8b8-4240-8971-1cd48fa45d78','82ea23d8-4358-4944-b79d-0263b8fedbbf',0,'e764b82b-54e8-4352-9c45-a0fc3700b330'),(70,'2026-01-23 19:08:23.355262','2026-01-23 19:08:28.043830','2026-01-23 19:08:28.042578',70,'192.168.122.100:6789:/volumes/_nogroup/71a90bd9-cf43-41a3-9d27-2205ff800090/a74f09d5-6405-402c-9941-199927d22561','71a90bd9-cf43-41a3-9d27-2205ff800090',0,'74a21ef6-cb9b-4d1e-a642-86bc495b4001'),(71,'2026-01-23 19:08:27.550326','2026-01-23 19:08:32.479516','2026-01-23 19:08:32.478604',71,'192.168.122.100:6789:/volumes/_nogroup/4b279f6d-4f8f-42f5-a19b-c361caa46a7c/96b99af2-fe85-4aa6-8b8a-0cf0e67a4756','4b279f6d-4f8f-42f5-a19b-c361caa46a7c',0,'e11df976-7c1c-4d70-86ae-50fc2962c1c4'),(72,'2026-01-23 19:08:50.988772','2026-01-23 19:09:02.650695','2026-01-23 19:09:02.649537',72,'192.168.122.100:6789:/volumes/_nogroup/cb4de7c2-b53e-4f25-93d6-250c4ea8ac22/43852489-d26f-4f74-ae80-28dc4ab27e85','cb4de7c2-b53e-4f25-93d6-250c4ea8ac22',0,'befb5870-d091-4d86-9dc4-b546a7f3be5b'),(73,'2026-01-23 19:09:33.962653','2026-01-23 19:09:46.287546','2026-01-23 19:09:46.286300',73,'192.168.122.100:6789:/volumes/_nogroup/aa2c8728-a923-4fbb-967a-08864f87ea61/b630a642-2f75-48cc-b83e-f84ce4a3c572','aa2c8728-a923-4fbb-967a-08864f87ea61',0,'47d1c7da-158f-47ea-8012-a68a931aa40f');
/*!40000 ALTER TABLE `share_instance_export_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instance_export_locations_metadata`
--

DROP TABLE IF EXISTS `share_instance_export_locations_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instance_export_locations_metadata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `export_location_id` int(11) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `elm_el_id_uc` (`export_location_id`,`key`,`deleted`),
  CONSTRAINT `elm_id_fk` FOREIGN KEY (`export_location_id`) REFERENCES `share_instance_export_locations` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instance_export_locations_metadata`
--

LOCK TABLES `share_instance_export_locations_metadata` WRITE;
/*!40000 ALTER TABLE `share_instance_export_locations_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_instance_export_locations_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instances`
--

DROP TABLE IF EXISTS `share_instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instances` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `share_id` varchar(36) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `share_network_id` varchar(36) DEFAULT NULL,
  `share_server_id` varchar(36) DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  `access_rules_status` varchar(255) DEFAULT NULL,
  `replica_state` varchar(255) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  `cast_rules_to_readonly` tinyint(1) NOT NULL,
  `progress` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `si_share_network_fk` (`share_network_id`),
  KEY `si_share_server_fk` (`share_server_id`),
  KEY `si_az_id_fk` (`availability_zone_id`),
  KEY `si_st_id_fk` (`share_type_id`),
  KEY `share_instances_share_id_idx` (`share_id`),
  CONSTRAINT `si_az_id_fk` FOREIGN KEY (`availability_zone_id`) REFERENCES `availability_zones` (`id`),
  CONSTRAINT `si_share_fk` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`),
  CONSTRAINT `si_share_network_fk` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`),
  CONSTRAINT `si_share_server_fk` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`),
  CONSTRAINT `si_st_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instances`
--

LOCK TABLES `share_instances` WRITE;
/*!40000 ALTER TABLE `share_instances` DISABLE KEYS */;
INSERT INTO `share_instances` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_id`, `host`, `status`, `scheduled_at`, `launched_at`, `terminated_at`, `share_network_id`, `share_server_id`, `availability_zone_id`, `access_rules_status`, `replica_state`, `share_type_id`, `cast_rules_to_readonly`, `progress`) VALUES ('2026-01-23 19:00:12.991179','2026-01-23 19:00:17.166500','2026-01-23 19:00:17.165770','049e69f2-19e1-41e8-b13d-2d953d142e3c','049e69f2-19e1-41e8-b13d-2d953d142e3c','36a9c8b6-9e21-4434-b741-212702a77736','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:00:13','2026-01-23 19:00:13','2026-01-23 19:00:16',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'38503086-e059-46cf-afc1-5c445beccdd6',0,'100%'),('2026-01-23 19:03:38.876271','2026-01-23 19:03:42.462606','2026-01-23 19:03:42.461989','09631b81-f042-458a-bda9-cfaa8080b1b7','09631b81-f042-458a-bda9-cfaa8080b1b7','469ce416-fdcf-42ae-9fb1-1c87fce73818','','deleted','2026-01-23 19:03:38',NULL,NULL,NULL,NULL,NULL,'active',NULL,'e14aad06-9466-486c-bc63-26592e0cdf52',0,NULL),('2026-01-23 19:01:51.443385','2026-01-23 19:01:55.366005','2026-01-23 19:01:55.364231','0b2a4f38-d054-4cd4-98b9-e0a2222a0f26','0b2a4f38-d054-4cd4-98b9-e0a2222a0f26','cb1c2ffc-c624-4f86-bab1-ad8814d0d029','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:01:51','2026-01-23 19:01:51','2026-01-23 19:01:55',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'3c6be9a4-c34f-4d70-9659-317852304237',0,'100%'),('2026-01-23 19:03:47.921488','2026-01-23 19:03:51.594960','2026-01-23 19:03:51.594326','0e10ccbe-f255-4340-9345-373a3645bea0','0e10ccbe-f255-4340-9345-373a3645bea0','dbac94e4-a674-42d5-a070-37b6c59282db','','deleted','2026-01-23 19:03:47',NULL,NULL,NULL,NULL,NULL,'active',NULL,'0cc522bc-772d-444b-91ef-721acf2d84b1',0,NULL),('2026-01-23 19:02:16.699680','2026-01-23 19:02:21.770064','2026-01-23 19:02:21.769332','0e81367e-537f-4aee-8570-08ff0c9c7c27','0e81367e-537f-4aee-8570-08ff0c9c7c27','e4b2c96d-a4ff-40fc-9b17-291106bf282c','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:02:16','2026-01-23 19:02:16','2026-01-23 19:02:21',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'c45f2ba3-7d51-4245-94b8-6909ec45f40d',0,'100%'),('2026-01-23 19:02:40.586082','2026-01-23 19:02:45.517841','2026-01-23 19:02:45.517077','0ec0da82-b94c-4d70-ba4c-e5b9fc27dc1e','0ec0da82-b94c-4d70-ba4c-e5b9fc27dc1e','3f4883fe-85fc-4897-9382-f88c948a4c2b','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:02:40','2026-01-23 19:02:41','2026-01-23 19:02:45',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'5a7e3cee-6582-4736-9a7d-82a9c9a4db19',0,'100%'),('2026-01-23 19:01:48.270838','2026-01-23 19:02:46.202977','2026-01-23 19:02:46.202284','1291e2ec-1b23-4741-b658-cb06b2d77e76','1291e2ec-1b23-4741-b658-cb06b2d77e76','7938988f-34fb-477d-9ef4-7346a281e738','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:01:48','2026-01-23 19:01:48','2026-01-23 19:02:46',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'fe8a42c9-28ea-4c66-bed3-f2f6d12529fa',0,'100%'),('2026-01-23 19:06:26.694383','2026-01-23 19:06:31.543374','2026-01-23 19:06:31.542748','137cf5f0-949a-449f-82d0-ceae6fdaaa3e','137cf5f0-949a-449f-82d0-ceae6fdaaa3e','ab471169-de9b-4160-affe-e7fd580570d1','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:06:26','2026-01-23 19:06:28','2026-01-23 19:06:31',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'1339bb0a-ff5c-466e-9368-c1558d7331e6',0,'100%'),('2026-01-23 19:06:13.700083','2026-01-23 19:06:55.839892','2026-01-23 19:06:55.838906','2372c43f-e00a-4e92-b338-82e4882d6cb1','2372c43f-e00a-4e92-b338-82e4882d6cb1','b4a0d77a-8aca-4f04-b55e-45899decea01','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:06:13','2026-01-23 19:06:14','2026-01-23 19:06:55',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'a231ee93-b5f1-4fc4-a3d2-0055417021c0',0,'100%'),('2026-01-23 19:04:00.582285','2026-01-23 19:04:04.319877','2026-01-23 19:04:04.318759','248540bb-5516-42ef-a791-5b61f2401593','248540bb-5516-42ef-a791-5b61f2401593','7834bedd-587b-48b5-86e3-9975b049f7a3','','deleted','2026-01-23 19:04:00',NULL,NULL,NULL,NULL,NULL,'active',NULL,'b1e1b985-0ef4-4803-84b5-18474a1939bf',0,NULL),('2026-01-23 19:05:32.941698','2026-01-23 19:05:50.796913','2026-01-23 19:05:50.796312','2649806c-36b6-496b-8324-f7d5569ca22e','2649806c-36b6-496b-8324-f7d5569ca22e','8453ecac-20f9-422a-b1ad-2bd319766708','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:05:33','2026-01-23 19:05:33','2026-01-23 19:05:43',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'52b6d957-ef7a-4cb1-b863-d97f55c93c1a',0,'100%'),('2026-01-23 19:03:02.166483','2026-01-23 19:03:12.030028','2026-01-23 19:03:12.029462','26b68481-1e3f-49e4-928e-ce608e53fe50','26b68481-1e3f-49e4-928e-ce608e53fe50','5df7f392-10cf-4571-bdf9-06da47e30bbd','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:03:02','2026-01-23 19:03:02','2026-01-23 19:03:11',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'5970bbf1-902e-4fec-a95f-9ecee5bbb631',0,'100%'),('2026-01-23 19:01:44.455274','2026-01-23 19:02:50.380844','2026-01-23 19:02:50.380282','27d42cf3-c581-4351-85ac-a91e5a37a2c7','27d42cf3-c581-4351-85ac-a91e5a37a2c7','3b030aa9-c2a3-412f-bf95-1476db82a6ad','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:01:44','2026-01-23 19:01:44','2026-01-23 19:02:49',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'2edae7de-0cac-41e9-8dee-a7f49a9c9caa',0,'100%'),('2026-01-23 19:03:44.960664','2026-01-23 19:04:04.643397','2026-01-23 19:04:04.640693','2cc197a2-1b4a-427e-9d00-dd49916b35df','2cc197a2-1b4a-427e-9d00-dd49916b35df','29d694db-1498-45de-818b-999e5140dad6','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:03:45','2026-01-23 19:03:45','2026-01-23 19:04:04',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'d4340069-92a0-40b1-9a2d-4931749a22be',0,'100%'),('2026-01-23 19:05:34.590720','2026-01-23 19:06:50.761562','2026-01-23 19:06:50.760924','2d153082-1f6f-49c0-9c45-aa3f03ba31d4','2d153082-1f6f-49c0-9c45-aa3f03ba31d4','37853495-d9b6-4d2c-abc6-da37b9ee8591','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:05:34','2026-01-23 19:05:35','2026-01-23 19:06:50',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'4b614781-282f-426a-a8da-c9980601f345',0,'100%'),('2026-01-23 19:05:39.578233','2026-01-23 19:05:55.125975','2026-01-23 19:05:55.125438','34962dc4-5e08-41ca-b8ab-f76521ae76f2','34962dc4-5e08-41ca-b8ab-f76521ae76f2','1289a7a6-fe12-4d2f-b00b-358016b0e61e','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:05:39','2026-01-23 19:05:40','2026-01-23 19:05:53',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'4b614781-282f-426a-a8da-c9980601f345',0,'100%'),('2026-01-23 19:01:27.743820','2026-01-23 19:01:53.503370','2026-01-23 19:01:53.502851','349e50d8-8b7b-4b2a-9bbb-82e4a22fd8a9','349e50d8-8b7b-4b2a-9bbb-82e4a22fd8a9','ad431efc-4255-4370-895c-6ab531b1785e','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:01:27','2026-01-23 19:01:28','2026-01-23 19:01:53',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'88ad68ca-8786-477c-9b56-3373e78c4057',0,'100%'),('2026-01-23 19:08:13.039435','2026-01-23 19:08:16.897964','2026-01-23 19:08:16.897362','3732f0e1-a134-4643-95be-27f3fc23eec2','3732f0e1-a134-4643-95be-27f3fc23eec2','58086060-20fd-490e-b109-47b5495a4e56','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:08:13','2026-01-23 19:08:13','2026-01-23 19:08:16',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'ae9b0b0a-11bb-4691-b72a-a62b561e3b36',0,'100%'),('2026-01-23 19:03:49.130789','2026-01-23 19:04:01.233476','2026-01-23 19:04:01.232840','3f4b47db-bc72-4155-915f-95273d2ed043','3f4b47db-bc72-4155-915f-95273d2ed043','39284e92-1b49-4324-96db-4c5831010bf3','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:03:49','2026-01-23 19:03:49','2026-01-23 19:04:00',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'d4340069-92a0-40b1-9a2d-4931749a22be',0,'100%'),('2026-01-23 19:03:40.695646','2026-01-23 19:03:52.181158','2026-01-23 19:03:52.180102','4024f96e-1f9a-4403-8970-7babeb5ad503','4024f96e-1f9a-4403-8970-7babeb5ad503','29861bb5-32b3-471d-8b8b-fd8698202092','','deleted','2026-01-23 19:03:40',NULL,NULL,NULL,NULL,NULL,'active',NULL,'25eb52ab-ed01-4f19-94db-7202aa609ac2',0,NULL),('2026-01-23 19:03:22.257513','2026-01-23 19:03:26.108842','2026-01-23 19:03:26.107993','44eeaf56-b85e-4f97-b37c-d1865946d3f0','44eeaf56-b85e-4f97-b37c-d1865946d3f0','e3437183-3378-4616-9647-d91c796bea3e','','deleted','2026-01-23 19:03:22',NULL,NULL,NULL,NULL,NULL,'active',NULL,'7362d9e0-868c-4044-a9a6-eed78870ee61',0,NULL),('2026-01-23 19:06:34.622388','2026-01-23 19:06:39.257767','2026-01-23 19:06:39.257215','4ab0802a-2a55-43b2-9e63-a0e480add7c1','4ab0802a-2a55-43b2-9e63-a0e480add7c1','b4308187-b5c6-41cc-9f65-4b5ef066d494','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:06:34','2026-01-23 19:06:35','2026-01-23 19:06:38',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'1339bb0a-ff5c-466e-9368-c1558d7331e6',0,'100%'),('2026-01-23 19:08:27.216364','2026-01-23 19:08:32.504326','2026-01-23 19:08:32.503740','4b279f6d-4f8f-42f5-a19b-c361caa46a7c','4b279f6d-4f8f-42f5-a19b-c361caa46a7c','10389d2f-ee79-4aa1-86d0-deb816518b03','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:08:27','2026-01-23 19:08:27','2026-01-23 19:08:31',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'ae9b0b0a-11bb-4691-b72a-a62b561e3b36',0,'100%'),('2026-01-23 19:02:24.692586','2026-01-23 19:02:39.229057','2026-01-23 19:02:39.228287','4c4cc1cb-4d10-4014-806c-a3aa7cd153c6','4c4cc1cb-4d10-4014-806c-a3aa7cd153c6','784dce8f-a5a5-4328-baac-1ef916284d88','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:02:24','2026-01-23 19:02:25','2026-01-23 19:02:39',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'2edae7de-0cac-41e9-8dee-a7f49a9c9caa',0,'100%'),('2026-01-23 19:04:26.839594','2026-01-23 19:04:30.801327','2026-01-23 19:04:30.800349','5229476a-6a4f-49c2-9bcd-5dab192f60a7','5229476a-6a4f-49c2-9bcd-5dab192f60a7','eb3d3e12-5a94-47ea-9820-bf28b2fbcb9a','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:04:26','2026-01-23 19:04:27','2026-01-23 19:04:30',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'d7fe3112-4905-44e0-a7a6-b013dde8491c',0,'100%'),('2026-01-23 19:04:22.593506','2026-01-23 19:04:34.647908','2026-01-23 19:04:34.646865','58517681-eea7-4542-9aa9-1caa99f33856','58517681-eea7-4542-9aa9-1caa99f33856','c5ec9c35-4d7c-4fc8-b621-d53247587e9c','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:04:22','2026-01-23 19:04:23','2026-01-23 19:04:34',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'d7fe3112-4905-44e0-a7a6-b013dde8491c',0,'100%'),('2026-01-23 19:05:57.626539','2026-01-23 19:06:06.991400','2026-01-23 19:06:06.990820','58ccdce1-cbc8-4922-8f55-95da428422fa','58ccdce1-cbc8-4922-8f55-95da428422fa','ec07c5de-032d-4294-a579-616d0c9c5cc9','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:05:57','2026-01-23 19:05:58','2026-01-23 19:06:04',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'4b614781-282f-426a-a8da-c9980601f345',0,'100%'),('2026-01-23 19:03:34.668608','2026-01-23 19:03:38.227907','2026-01-23 19:03:38.227150','5bf64f47-8d35-4fff-ad53-9eee16f9c2bc','5bf64f47-8d35-4fff-ad53-9eee16f9c2bc','366a6c27-7a41-4ec7-85c2-8355e39c9e2b','','deleted','2026-01-23 19:03:34',NULL,NULL,NULL,NULL,NULL,'active',NULL,'bccb681a-3222-4edc-857a-aaeddd11ad78',0,NULL),('2026-01-23 19:02:14.085264','2026-01-23 19:03:02.728494','2026-01-23 19:03:02.727674','638d8bf8-4cef-4bb0-add8-32a6d6937431','638d8bf8-4cef-4bb0-add8-32a6d6937431','21ed6874-3e57-49ad-ad3d-e168df853ebc','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:02:14','2026-01-23 19:02:14','2026-01-23 19:03:02',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'5a7e3cee-6582-4736-9a7d-82a9c9a4db19',0,'100%'),('2026-01-23 19:08:23.041378','2026-01-23 19:08:28.056827','2026-01-23 19:08:28.056266','71a90bd9-cf43-41a3-9d27-2205ff800090','71a90bd9-cf43-41a3-9d27-2205ff800090','e2d2d17f-a5c7-4419-8e2a-29f8cd7104e8','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:08:23','2026-01-23 19:08:23','2026-01-23 19:08:27',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'58e5f12d-28d9-46d7-9f8a-fe63de5ccde0',0,'100%'),('2026-01-23 19:03:28.585795','2026-01-23 19:03:32.111555','2026-01-23 19:03:32.110763','73cb7069-ee95-40ef-84c8-94f9b1bdecaf','73cb7069-ee95-40ef-84c8-94f9b1bdecaf','7d876ca7-1a61-4950-b214-03431c416d34','','deleted','2026-01-23 19:03:28',NULL,NULL,NULL,NULL,NULL,'active',NULL,'241a7152-12d1-48bb-b5c7-291a074f5b66',0,NULL),('2026-01-23 19:04:52.119049','2026-01-23 19:04:57.921853','2026-01-23 19:04:57.920958','7581fe4e-6784-4ac5-b13d-2b32f94d378c','7581fe4e-6784-4ac5-b13d-2b32f94d378c','d0a208d6-678f-49b1-b388-ee4a0edb5c52','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:04:52','2026-01-23 19:04:52','2026-01-23 19:04:57',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'d75ba714-c404-43a1-a9ef-110a3d3d2fa3',0,'100%'),('2026-01-23 19:05:54.256626','2026-01-23 19:05:59.331825','2026-01-23 19:05:59.330920','7c487935-93a6-4d7a-a6c9-f402d645b4e2','7c487935-93a6-4d7a-a6c9-f402d645b4e2','16fc78cd-4631-4b5e-bee7-624b90b7fa9f','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:05:54','2026-01-23 19:05:55','2026-01-23 19:05:58',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'f57d6e7a-ef40-49d3-9e68-6fb5a008c4a4',0,'100%'),('2026-01-23 19:05:06.840076','2026-01-23 19:05:11.610316','2026-01-23 19:05:11.609658','7c8fd20a-b01b-4f68-87ff-9188d64cf184','7c8fd20a-b01b-4f68-87ff-9188d64cf184','1ec67602-9d35-44a8-8c55-aae8555c9738','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:05:06','2026-01-23 19:05:08','2026-01-23 19:05:10',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'21de215f-d5bc-482a-9a75-67ea712434b1',0,'100%'),('2026-01-23 19:01:51.140307','2026-01-23 19:01:56.263682','2026-01-23 19:01:56.263111','7e746fb3-c8b1-4b98-8d5d-0856a5904d96','7e746fb3-c8b1-4b98-8d5d-0856a5904d96','a8641b5d-7b3b-4197-9cc0-76b90318f554','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:01:51','2026-01-23 19:01:51','2026-01-23 19:01:55',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'09dbe7c6-481d-459a-98b0-2e78689c591b',0,'100%'),('2026-01-23 18:59:53.282178','2026-01-23 19:01:24.575091','2026-01-23 19:01:24.573863','813e89aa-6f7f-4c70-8d5a-de6aa64dcb0f','813e89aa-6f7f-4c70-8d5a-de6aa64dcb0f','3bb50cf4-b86f-48ff-934d-15e15af9f620','hostgroup@cephfs#cephfs','deleted','2026-01-23 18:59:53','2026-01-23 18:59:53','2026-01-23 19:01:24',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'38503086-e059-46cf-afc1-5c445beccdd6',0,'100%'),('2026-01-23 19:02:43.914183','2026-01-23 19:03:01.909337','2026-01-23 19:03:01.908794','821840f9-97a9-48b2-a779-bb77ecd1f3bf','821840f9-97a9-48b2-a779-bb77ecd1f3bf','386e06d8-ac44-45fc-b5bc-cda5ad18efea','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:02:43','2026-01-23 19:02:44','2026-01-23 19:03:01',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'9d723286-feb8-4b59-ba94-db1ea3aa7f91',0,'100%'),('2026-01-23 19:03:55.957544','2026-01-23 19:03:59.925116','2026-01-23 19:03:59.924561','823598ed-9f90-4825-aaeb-5267d3ef831b','823598ed-9f90-4825-aaeb-5267d3ef831b','88064b1f-2796-4781-8f3d-4593b6580021','','deleted','2026-01-23 19:03:55',NULL,NULL,NULL,NULL,NULL,'active',NULL,'91c26460-9fbd-4287-97cf-8d78828587a3',0,NULL),('2026-01-23 19:02:17.583308','2026-01-23 19:02:21.927908','2026-01-23 19:02:21.927236','8254111f-72e3-43c6-937a-37e35e2a9b5f','8254111f-72e3-43c6-937a-37e35e2a9b5f','ffe680b4-30d4-4706-b8cf-657ed9c2476e','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:02:17','2026-01-23 19:02:18','2026-01-23 19:02:21',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'5a7e3cee-6582-4736-9a7d-82a9c9a4db19',0,'100%'),('2026-01-23 19:08:20.062336','2026-01-23 19:08:24.062616','2026-01-23 19:08:24.061179','82ea23d8-4358-4944-b79d-0263b8fedbbf','82ea23d8-4358-4944-b79d-0263b8fedbbf','85c98837-c914-4e4d-8b55-a429680295cd','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:08:20','2026-01-23 19:08:20','2026-01-23 19:08:23',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'ae9b0b0a-11bb-4691-b72a-a62b561e3b36',0,'100%'),('2026-01-23 19:08:05.972173','2026-01-23 19:08:09.839749','2026-01-23 19:08:09.839051','897e454b-4a6d-4c3a-bde6-222bf698dc84','897e454b-4a6d-4c3a-bde6-222bf698dc84','6aca15d2-5578-4867-adfa-2bf5c083fe5c','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:08:06','2026-01-23 19:08:06','2026-01-23 19:08:09',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'ae9b0b0a-11bb-4691-b72a-a62b561e3b36',0,'100%'),('2026-01-23 19:05:15.264700','2026-01-23 19:05:19.714121','2026-01-23 19:05:19.713354','89e841f0-56dd-4e4e-8222-ae52cf7d9c48','89e841f0-56dd-4e4e-8222-ae52cf7d9c48','95f14abf-d821-478e-a525-5c4864abf611','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:05:15','2026-01-23 19:05:16','2026-01-23 19:05:19',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'21de215f-d5bc-482a-9a75-67ea712434b1',0,'100%'),('2026-01-23 19:00:42.278313','2026-01-23 19:01:08.192195','2026-01-23 19:01:08.191540','8c3aacd4-958b-4e71-b998-b587ef3cb3df','8c3aacd4-958b-4e71-b998-b587ef3cb3df','b7e6ccd3-b475-4741-95bf-f79468206c11','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:00:42','2026-01-23 19:00:43','2026-01-23 19:01:07',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'2a58a533-a0c8-400a-8e5d-7f96a5448c79',0,'100%'),('2026-01-23 19:01:55.238621','2026-01-23 19:02:42.889951','2026-01-23 19:02:42.889042','957eb80d-b96f-4546-9b33-5d50aefacdfe','957eb80d-b96f-4546-9b33-5d50aefacdfe','227c770e-cd8a-40bc-b862-45ce5532d775','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:01:55','2026-01-23 19:01:55','2026-01-23 19:02:42',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'fe8a42c9-28ea-4c66-bed3-f2f6d12529fa',0,'100%'),('2026-01-23 19:03:36.281755','2026-01-23 19:03:40.100773','2026-01-23 19:03:40.100178','99be3343-af04-4d04-ba68-8f8aeea98314','99be3343-af04-4d04-ba68-8f8aeea98314','abd86165-d5a5-4739-904a-95596ad006a9','','deleted','2026-01-23 19:03:36',NULL,NULL,NULL,NULL,NULL,'active',NULL,'7f7e6a30-a2c4-443f-a0c5-e0dfdb57d9d3',0,NULL),('2026-01-23 19:08:12.863634','2026-01-23 19:08:19.903018','2026-01-23 19:08:19.902329','9a2901e0-1e2a-431b-ad0b-0539c4b54da0','9a2901e0-1e2a-431b-ad0b-0539c4b54da0','b477be78-9127-48f3-918b-227b7d20ddba','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:08:12','2026-01-23 19:08:13','2026-01-23 19:08:19',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'58e5f12d-28d9-46d7-9f8a-fe63de5ccde0',0,'100%'),('2026-01-23 19:03:19.657905','2026-01-23 19:06:50.515534','2026-01-23 19:06:50.514910','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','9ac5a4a7-976b-4e6b-b5a2-f7c4671155d6','925d3664-bf68-4a0a-92b4-6195aa90de88','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:03:19','2026-01-23 19:03:20','2026-01-23 19:06:50',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'1cd0aa0c-256d-4747-b5c6-735c1e4e32e0',0,'100%'),('2026-01-23 19:00:12.116368','2026-01-23 19:00:18.895551','2026-01-23 19:00:18.894963','9ba675d4-570c-4cbb-af0d-aeb9f85aa3ba','9ba675d4-570c-4cbb-af0d-aeb9f85aa3ba','dd9103b6-9748-41da-9bdc-cbd2c6fcd0d7','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:00:12','2026-01-23 19:00:12','2026-01-23 19:00:18',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'fd74222d-9aee-436c-9b35-942741042afa',0,'100%'),('2026-01-23 19:02:33.493522','2026-01-23 19:02:37.458950','2026-01-23 19:02:37.458351','9ff37cdd-dadb-4205-9f9d-26df1c040f98','9ff37cdd-dadb-4205-9f9d-26df1c040f98','7662b1bb-78a6-468c-b02d-242bc6501e96','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:02:33','2026-01-23 19:02:33','2026-01-23 19:02:37',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'5a7e3cee-6582-4736-9a7d-82a9c9a4db19',0,'100%'),('2026-01-23 18:59:56.883249','2026-01-23 19:00:08.433793','2026-01-23 19:00:08.433070','a0a8215b-eedb-45d9-a08e-7e13600761d5','a0a8215b-eedb-45d9-a08e-7e13600761d5','84f80d8e-7753-43a3-b2e1-760b2497acf3','hostgroup@cephfs#cephfs','deleted','2026-01-23 18:59:56','2026-01-23 18:59:57','2026-01-23 19:00:08',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'11eb753a-cfca-443f-8db2-def2cf1f0e7e',0,'100%'),('2026-01-23 19:07:49.847907','2026-01-23 19:08:39.188995','2026-01-23 19:08:39.187529','a1da1abe-af26-445a-9262-0ff686ee8203','a1da1abe-af26-445a-9262-0ff686ee8203','1c640b45-4f70-4ab0-b31e-d65cb9f227fe','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:07:49','2026-01-23 19:07:50','2026-01-23 19:08:38',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'ae9b0b0a-11bb-4691-b72a-a62b561e3b36',0,'100%'),('2026-01-23 19:00:28.412856','2026-01-23 19:00:36.195159','2026-01-23 19:00:36.194454','a78e7c29-37d2-401f-be9f-e1812f305e12','a78e7c29-37d2-401f-be9f-e1812f305e12','b8bebdc7-0681-4493-b749-f6ba99e6588b','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:00:28','2026-01-23 19:00:28','2026-01-23 19:00:35',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'d9dd72be-5638-411d-adb4-977298762a87',0,'100%'),('2026-01-23 19:00:04.648467','2026-01-23 19:00:09.721943','2026-01-23 19:00:09.721129','a8a8bc57-0cf3-40b2-af69-e9b0e686c548','a8a8bc57-0cf3-40b2-af69-e9b0e686c548','7d0a6496-9c62-4373-afd1-0df6484dfced','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:00:04','2026-01-23 19:00:06','2026-01-23 19:00:09',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'38503086-e059-46cf-afc1-5c445beccdd6',0,'100%'),('2026-01-23 19:06:02.240844','2026-01-23 19:07:02.951141','2026-01-23 19:07:02.950606','a974fb39-4b39-4d59-84a7-f8f3ffa56b12','a974fb39-4b39-4d59-84a7-f8f3ffa56b12','6ef51183-9eb7-460b-91d9-d5b9e76c3afd','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:06:02','2026-01-23 19:06:06','2026-01-23 19:07:02',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'a231ee93-b5f1-4fc4-a3d2-0055417021c0',0,'100%'),('2026-01-23 19:02:50.164300','2026-01-23 19:02:56.677086','2026-01-23 19:02:56.676523','a9ac4747-bff1-455b-923a-8ae6bf6a959a','a9ac4747-bff1-455b-923a-8ae6bf6a959a','3da810db-9a70-4383-aaf3-cc25bc7e9cab','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:02:50','2026-01-23 19:02:50','2026-01-23 19:02:56',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'5a7e3cee-6582-4736-9a7d-82a9c9a4db19',0,'100%'),('2026-01-23 19:09:33.701869','2026-01-23 19:09:46.362509','2026-01-23 19:09:46.361898','aa2c8728-a923-4fbb-967a-08864f87ea61','aa2c8728-a923-4fbb-967a-08864f87ea61','6e946115-7c50-4b74-844b-36e0e549695b','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:09:33','2026-01-23 19:09:33','2026-01-23 19:09:45',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'7d583f94-a44a-47c6-b6fb-99c2483a84cb',0,'100%'),('2026-01-23 19:08:05.210196','2026-01-23 19:09:01.158064','2026-01-23 19:09:01.157163','b8a58bec-b849-4bc6-8dba-3cc458df53f5','b8a58bec-b849-4bc6-8dba-3cc458df53f5','d24254b0-53ec-4084-8545-391802f0a833','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:08:05','2026-01-23 19:08:05','2026-01-23 19:09:00',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d',0,'100%'),('2026-01-23 19:07:16.148419','2026-01-23 19:08:38.493139','2026-01-23 19:08:38.492592','c09bd88d-6bf6-440e-b929-87c3d463c101','c09bd88d-6bf6-440e-b929-87c3d463c101','d4df52fc-5514-4f2f-adf6-7e0a4fb0f9c6','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:07:16','2026-01-23 19:07:17','2026-01-23 19:08:38',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'58e5f12d-28d9-46d7-9f8a-fe63de5ccde0',0,'100%'),('2026-01-23 19:07:23.533075','2026-01-23 19:08:32.275495','2026-01-23 19:08:32.274538','c5afb25c-aa10-424c-a2b9-1de8cd95ec12','c5afb25c-aa10-424c-a2b9-1de8cd95ec12','5f871fb6-01a9-4012-ba73-cb3c1ec609fd','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:07:23','2026-01-23 19:07:31','2026-01-23 19:08:31',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'58e5f12d-28d9-46d7-9f8a-fe63de5ccde0',0,'100%'),('2026-01-23 19:05:14.179166','2026-01-23 19:05:19.730930','2026-01-23 19:05:19.730082','c88504fb-ae34-4350-82e6-9d10001a8eb2','c88504fb-ae34-4350-82e6-9d10001a8eb2','63940a9b-b535-42eb-a7cd-94b38ca85aee','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:05:14','2026-01-23 19:05:14','2026-01-23 19:05:19',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'e2842727-9db2-48d3-8b3d-2a3115f7f601',0,'100%'),('2026-01-23 18:59:57.048063','2026-01-23 19:00:04.283723','2026-01-23 19:00:04.282196','c9f4e008-d833-4462-9cc2-c6b75c41215b','c9f4e008-d833-4462-9cc2-c6b75c41215b','8784868c-ca01-49f8-b77a-a337914b8f22','hostgroup@cephfs#cephfs','deleted','2026-01-23 18:59:57','2026-01-23 18:59:57','2026-01-23 19:00:01',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'38503086-e059-46cf-afc1-5c445beccdd6',0,'100%'),('2026-01-23 19:07:28.818136','2026-01-23 19:07:37.019662','2026-01-23 19:07:37.019082','ca22b681-9cb5-4a64-81d1-5d9133599b53','ca22b681-9cb5-4a64-81d1-5d9133599b53','1036c742-b7c8-4486-8595-4ecfc41b77f3','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:07:28','2026-01-23 19:07:31','2026-01-23 19:07:36',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'a23d81ce-d5e1-43ae-b5f6-7a08ac609609',0,'100%'),('2026-01-23 19:08:50.738693','2026-01-23 19:09:02.672385','2026-01-23 19:09:02.671837','cb4de7c2-b53e-4f25-93d6-250c4ea8ac22','cb4de7c2-b53e-4f25-93d6-250c4ea8ac22','4c63b0d1-2bfd-41f1-a117-86a846be3efd','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:08:50','2026-01-23 19:08:51','2026-01-23 19:09:02',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'9d06412d-874f-45c2-b39d-2192c8184009',0,'100%'),('2026-01-23 19:07:58.317663','2026-01-23 19:08:02.578886','2026-01-23 19:08:02.577904','cb820b50-42e3-42ba-9e37-9bcbf6f06c8c','cb820b50-42e3-42ba-9e37-9bcbf6f06c8c','2842acb6-6a55-4fe8-bf4e-af508fb83d9f','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:07:58','2026-01-23 19:07:58','2026-01-23 19:08:02',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'ae9b0b0a-11bb-4691-b72a-a62b561e3b36',0,'100%'),('2026-01-23 19:03:24.701048','2026-01-23 19:03:28.310027','2026-01-23 19:03:28.309142','cdd23073-4a3f-4b6b-9b5e-73398958293c','cdd23073-4a3f-4b6b-9b5e-73398958293c','493e7f0d-e65f-4a69-bc39-608606a704e8','','deleted','2026-01-23 19:03:24',NULL,NULL,NULL,NULL,NULL,'active',NULL,'7902365b-5660-46c8-997e-208dd53ae844',0,NULL),('2026-01-23 19:02:16.553043','2026-01-23 19:02:30.761082','2026-01-23 19:02:30.760459','cea1143e-99c2-47fd-9222-42d7395a438e','cea1143e-99c2-47fd-9222-42d7395a438e','ba284aa9-66e4-45a0-8056-c16cce3c54ad','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:02:16','2026-01-23 19:02:16','2026-01-23 19:02:30',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'c2e7b8e1-0b37-4bdc-b0cd-490536ec4c44',0,'100%'),('2026-01-23 19:01:21.723480','2026-01-23 19:01:57.057603','2026-01-23 19:01:57.057027','d1a416c3-7f64-49d4-b1be-a176db014aeb','d1a416c3-7f64-49d4-b1be-a176db014aeb','66da67fb-2a2c-4f7a-9f67-7e48c0389d7a','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:01:21','2026-01-23 19:01:22','2026-01-23 19:01:56',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'f4a6bef4-70c7-455a-897f-b3e9b5f4c268',0,'100%'),('2026-01-23 19:03:52.443663','2026-01-23 19:04:00.185023','2026-01-23 19:04:00.184428','d8c17fb7-ce65-4e6b-9839-cf4ebc5c35d2','d8c17fb7-ce65-4e6b-9839-cf4ebc5c35d2','2e64c116-8c52-41df-b4be-e03adb9e0bbe','','deleted','2026-01-23 19:03:52',NULL,NULL,NULL,NULL,NULL,'active',NULL,'e9d1bb70-adca-4093-9b6e-5c2f0f61fbea',0,NULL),('2026-01-23 19:02:40.024669','2026-01-23 19:02:51.053574','2026-01-23 19:02:51.052914','da2057f4-30b8-4287-b324-aaa510666419','da2057f4-30b8-4287-b324-aaa510666419','7bca3129-9356-42c9-8b48-e6061ed16f01','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:02:40','2026-01-23 19:02:41','2026-01-23 19:02:50',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'bdb8bf7b-3c8f-4c28-b5d9-d9a31db95eaa',0,'100%'),('2026-01-23 19:04:42.983534','2026-01-23 19:04:48.122551','2026-01-23 19:04:48.121776','dca5fa61-ae49-4ea7-b61f-b63caccb203e','dca5fa61-ae49-4ea7-b61f-b63caccb203e','d6447ad8-5951-4450-ab89-7af9a5180737','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:04:43','2026-01-23 19:04:43','2026-01-23 19:04:46',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'21de215f-d5bc-482a-9a75-67ea712434b1',0,'100%'),('2026-01-23 19:06:09.504016','2026-01-23 19:06:19.441050','2026-01-23 19:06:19.439930','e1861ac0-d15e-48e7-8018-9e451a8b3dee','e1861ac0-d15e-48e7-8018-9e451a8b3dee','47e3b685-1a97-423d-9bd9-6c6581606054','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:06:09','2026-01-23 19:06:09','2026-01-23 19:06:17',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'4b614781-282f-426a-a8da-c9980601f345',0,'100%'),('2026-01-23 19:00:20.613220','2026-01-23 19:00:24.553595','2026-01-23 19:00:24.552670','e378cb20-e217-4231-960b-f50749860b80','e378cb20-e217-4231-960b-f50749860b80','bbabf70e-3352-413a-bdd1-d9721e768900','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:00:20','2026-01-23 19:00:20','2026-01-23 19:00:24',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'38503086-e059-46cf-afc1-5c445beccdd6',0,'100%'),('2026-01-23 19:03:53.109383','2026-01-23 19:03:57.577452','2026-01-23 19:03:57.576631','e51baba4-47d7-48aa-a6e0-ba58a86949b3','e51baba4-47d7-48aa-a6e0-ba58a86949b3','d3d7082d-d3b5-4f70-ac80-ec0346fa5547','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:03:53','2026-01-23 19:03:53','2026-01-23 19:03:57',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'d4340069-92a0-40b1-9a2d-4931749a22be',0,'100%'),('2026-01-23 19:00:24.655516','2026-01-23 19:00:32.646305','2026-01-23 19:00:32.645737','e6c475e8-8ebf-4542-a7ab-36860fe78789','e6c475e8-8ebf-4542-a7ab-36860fe78789','cd71c963-62da-4024-9a5f-ee995db00e8e','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:00:24','2026-01-23 19:00:25','2026-01-23 19:00:32',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'d6086e5f-4d59-4e21-9550-2e32e22fbdf6',0,'100%'),('2026-01-23 19:04:38.081325','2026-01-23 19:04:51.950567','2026-01-23 19:04:51.949946','ea32016d-d076-4cdb-87b1-5845df1c383d','ea32016d-d076-4cdb-87b1-5845df1c383d','98da0987-8f83-410f-9b05-c7ad0936208c','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:04:38','2026-01-23 19:04:39','2026-01-23 19:04:51',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'21de215f-d5bc-482a-9a75-67ea712434b1',0,'100%'),('2026-01-23 19:02:24.996981','2026-01-23 19:02:30.333799','2026-01-23 19:02:30.332142','ea8f2387-32ae-461c-a095-2db8629c4d12','ea8f2387-32ae-461c-a095-2db8629c4d12','ce5d5adc-fe46-4e48-83cf-a608b2bd061e','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:02:25','2026-01-23 19:02:25','2026-01-23 19:02:30',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'5a7e3cee-6582-4736-9a7d-82a9c9a4db19',0,'100%'),('2026-01-23 19:03:26.515585','2026-01-23 19:03:30.005553','2026-01-23 19:03:30.004930','ecdf93df-9eb6-44a8-89b5-0373288d41ef','ecdf93df-9eb6-44a8-89b5-0373288d41ef','4d8f6ad2-640a-446d-9f8c-17c7e37baa77','','deleted','2026-01-23 19:03:26',NULL,NULL,NULL,NULL,NULL,'active',NULL,'5bd00120-9b60-4196-9d38-c1e025658518',0,NULL),('2026-01-23 19:03:40.728395','2026-01-23 19:04:08.033023','2026-01-23 19:04:08.032348','ee5c9b95-36ca-40c5-b310-750aabee4b07','ee5c9b95-36ca-40c5-b310-750aabee4b07','e9348c7b-8056-43c2-88d5-4ea6f5c6b0c6','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:03:40','2026-01-23 19:03:41','2026-01-23 19:04:07',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'d4340069-92a0-40b1-9a2d-4931749a22be',0,'100%'),('2026-01-23 19:07:41.975867','2026-01-23 19:07:56.470233','2026-01-23 19:07:56.468864','f0a550da-da13-43b9-818c-b94c83664b8c','f0a550da-da13-43b9-818c-b94c83664b8c','91677b82-e607-4b55-bd2b-bf34898cc935','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:07:42','2026-01-23 19:07:42','2026-01-23 19:07:53',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'a23d81ce-d5e1-43ae-b5f6-7a08ac609609',0,'100%'),('2026-01-23 19:07:58.772825','2026-01-23 19:08:06.078799','2026-01-23 19:08:06.078039','f56806ef-3edf-4541-b599-18f3a7b7c7c4','f56806ef-3edf-4541-b599-18f3a7b7c7c4','0c705063-7c58-4940-ab8f-3fe6ed80ea78','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:07:58','2026-01-23 19:07:59','2026-01-23 19:08:05',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'58e5f12d-28d9-46d7-9f8a-fe63de5ccde0',0,'100%'),('2026-01-23 19:02:36.931891','2026-01-23 19:03:08.963247','2026-01-23 19:03:08.962395','f6c4c50e-f72c-439c-a86a-fc2726fe09af','f6c4c50e-f72c-439c-a86a-fc2726fe09af','6f28e846-7b1c-4dec-80da-017ad13ed962','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:02:37','2026-01-23 19:02:37','2026-01-23 19:03:08',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'9d723286-feb8-4b59-ba94-db1ea3aa7f91',0,'100%'),('2026-01-23 19:03:44.243652','2026-01-23 19:03:51.885804','2026-01-23 19:03:51.885241','f6db495b-0fc6-4acd-a2ef-6dd99e4202da','f6db495b-0fc6-4acd-a2ef-6dd99e4202da','265aabd6-df6d-409b-81b1-b331c143ed96','','deleted','2026-01-23 19:03:44',NULL,NULL,NULL,NULL,NULL,'active',NULL,'1b656fe8-9e38-4e1f-8896-27918147c270',0,NULL),('2026-01-23 19:04:38.111600','2026-01-23 19:04:43.331870','2026-01-23 19:04:43.331225','f6fe75ed-09c7-41b1-a5a6-78194558df7e','f6fe75ed-09c7-41b1-a5a6-78194558df7e','8bba90e0-40c5-41d4-8973-4840f22849f9','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:04:38','2026-01-23 19:04:39','2026-01-23 19:04:42',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'d7fe3112-4905-44e0-a7a6-b013dde8491c',0,'100%'),('2026-01-23 18:59:56.448672','2026-01-23 19:00:05.224166','2026-01-23 19:00:05.222964','f7fdf74a-3877-444d-a8d2-806e64741582','f7fdf74a-3877-444d-a8d2-806e64741582','7edeeaf9-75d2-4c10-9e64-7a0f1fd33342','hostgroup@cephfs#cephfs','deleted','2026-01-23 18:59:56','2026-01-23 18:59:56','2026-01-23 19:00:04',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'66b39355-b59e-45ea-8a76-32ccea2cc4b3',0,'100%'),('2026-01-23 19:03:32.418197','2026-01-23 19:03:40.377808','2026-01-23 19:03:40.377118','f8e9c789-f38b-4391-b0db-0c43c9178656','f8e9c789-f38b-4391-b0db-0c43c9178656','391232c3-3948-4ccb-a6c7-38654bac3ce2','','deleted','2026-01-23 19:03:32',NULL,NULL,NULL,NULL,NULL,'active',NULL,'8a953b9f-99f3-477f-8f8b-a85b076a7406',0,NULL),('2026-01-23 19:03:52.259391','2026-01-23 19:04:20.920491','2026-01-23 19:04:20.919603','f985db04-31d5-4dab-ade3-fdc049b4357a','f985db04-31d5-4dab-ade3-fdc049b4357a','57d4aac1-6dba-40f5-b7ab-eecb70beae03','hostgroup@cephfs#cephfs','deleted','2026-01-23 19:03:52','2026-01-23 19:03:52','2026-01-23 19:04:17',NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'fc3dea75-7a38-41a5-9a53-1370369a0c3e',0,'100%'),('2026-01-23 19:06:35.584116','2026-01-23 19:06:43.093541',NULL,'False','fba5485d-e5a8-4974-84d8-e4e56ba346a4','69a009ee-f397-404a-b72b-02056e1c0d04','hostgroup@cephfs#cephfs','available','2026-01-23 19:06:35','2026-01-23 19:06:36',NULL,NULL,NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','active',NULL,'1cd0aa0c-256d-4747-b5c6-735c1e4e32e0',0,'100%'),('2026-01-23 19:03:30.539451','2026-01-23 19:03:34.234336','2026-01-23 19:03:34.233490','fbedeec5-54d1-4d53-98f8-116a9d8a035e','fbedeec5-54d1-4d53-98f8-116a9d8a035e','5328202d-ad99-407a-b316-29648f9d1631','','deleted','2026-01-23 19:03:30',NULL,NULL,NULL,NULL,NULL,'active',NULL,'c19ff7fa-2a85-4740-abc5-3c03e603c222',0,NULL);
/*!40000 ALTER TABLE `share_instances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_metadata`
--

DROP TABLE IF EXISTS `share_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_metadata` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `share_id` (`share_id`),
  CONSTRAINT `share_metadata_ibfk_1` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=108 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_metadata`
--

LOCK TABLES `share_metadata` WRITE;
/*!40000 ALTER TABLE `share_metadata` DISABLE KEYS */;
INSERT INTO `share_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_id`, `key`, `value`) VALUES ('2026-01-23 18:59:53.936001',NULL,'2026-01-23 19:01:24.603075',1,1,'3bb50cf4-b86f-48ff-934d-15e15af9f620','__mount_options','fs=cephfs'),('2026-01-23 18:59:56.711640',NULL,'2026-01-23 19:00:05.297327',2,2,'7edeeaf9-75d2-4c10-9e64-7a0f1fd33342','__mount_options','fs=cephfs'),('2026-01-23 18:59:57.108436',NULL,'2026-01-23 19:00:08.444120',3,3,'84f80d8e-7753-43a3-b2e1-760b2497acf3','__mount_options','fs=cephfs'),('2026-01-23 18:59:57.296509',NULL,'2026-01-23 19:00:04.310877',4,4,'8784868c-ca01-49f8-b77a-a337914b8f22','__mount_options','fs=cephfs'),('2026-01-23 19:00:05.295839',NULL,'2026-01-23 19:00:09.738870',5,5,'7d0a6496-9c62-4373-afd1-0df6484dfced','__mount_options','fs=cephfs'),('2026-01-23 19:00:12.471324',NULL,'2026-01-23 19:00:18.905095',6,6,'dd9103b6-9748-41da-9bdc-cbd2c6fcd0d7','__mount_options','fs=cephfs'),('2026-01-23 19:00:13.259170',NULL,'2026-01-23 19:00:17.181994',7,7,'36a9c8b6-9e21-4434-b741-212702a77736','__mount_options','fs=cephfs'),('2026-01-23 19:00:20.845525',NULL,'2026-01-23 19:00:24.569607',8,8,'bbabf70e-3352-413a-bdd1-d9721e768900','__mount_options','fs=cephfs'),('2026-01-23 19:00:24.973886',NULL,'2026-01-23 19:00:32.656911',9,9,'cd71c963-62da-4024-9a5f-ee995db00e8e','__mount_options','fs=cephfs'),('2026-01-23 19:00:28.867505',NULL,'2026-01-23 19:00:36.218387',10,10,'b8bebdc7-0681-4493-b749-f6ba99e6588b','__mount_options','fs=cephfs'),('2026-01-23 19:00:42.863795',NULL,'2026-01-23 19:01:08.211156',11,11,'b7e6ccd3-b475-4741-95bf-f79468206c11','__mount_options','fs=cephfs'),('2026-01-23 19:01:21.971855',NULL,'2026-01-23 19:01:57.066527',12,12,'66da67fb-2a2c-4f7a-9f67-7e48c0389d7a','__mount_options','fs=cephfs'),('2026-01-23 19:01:28.651319',NULL,'2026-01-23 19:01:53.512171',13,13,'ad431efc-4255-4370-895c-6ab531b1785e','__mount_options','fs=cephfs'),('2026-01-23 19:01:44.944946',NULL,'2026-01-23 19:02:50.855027',14,14,'3b030aa9-c2a3-412f-bf95-1476db82a6ad','__mount_options','fs=cephfs'),('2026-01-23 19:01:48.528089',NULL,'2026-01-23 19:02:46.215537',15,15,'7938988f-34fb-477d-9ef4-7346a281e738','__mount_options','fs=cephfs'),('2026-01-23 19:01:51.446018',NULL,'2026-01-23 19:01:56.278783',16,16,'a8641b5d-7b3b-4197-9cc0-76b90318f554','__mount_options','fs=cephfs'),('2026-01-23 19:01:51.927397',NULL,'2026-01-23 19:01:55.394643',17,17,'cb1c2ffc-c624-4f86-bab1-ad8814d0d029','__mount_options','fs=cephfs'),('2026-01-23 19:01:55.494333',NULL,'2026-01-23 19:02:42.903649',18,18,'227c770e-cd8a-40bc-b862-45ce5532d775','__mount_options','fs=cephfs'),('2026-01-23 19:02:14.541379',NULL,'2026-01-23 19:03:02.744168',19,19,'21ed6874-3e57-49ad-ad3d-e168df853ebc','__mount_options','fs=cephfs'),('2026-01-23 19:02:16.775876',NULL,'2026-01-23 19:02:30.772978',20,20,'ba284aa9-66e4-45a0-8056-c16cce3c54ad','__mount_options','fs=cephfs'),('2026-01-23 19:02:16.910341',NULL,'2026-01-23 19:02:21.787848',21,21,'e4b2c96d-a4ff-40fc-9b17-291106bf282c','__mount_options','fs=cephfs'),('2026-01-23 19:02:18.369484',NULL,'2026-01-23 19:02:21.943660',22,22,'ffe680b4-30d4-4706-b8cf-657ed9c2476e','__mount_options','fs=cephfs'),('2026-01-23 19:02:20.957052',NULL,'2026-01-23 19:02:21.943660',23,23,'ffe680b4-30d4-4706-b8cf-657ed9c2476e','key5','value5'),('2026-01-23 19:02:20.961089',NULL,'2026-01-23 19:02:21.943660',24,24,'ffe680b4-30d4-4706-b8cf-657ed9c2476e','key6','value6'),('2026-01-23 19:02:21.212440',NULL,'2026-01-23 19:02:21.943660',25,25,'ffe680b4-30d4-4706-b8cf-657ed9c2476e','key7','value7'),('2026-01-23 19:02:21.216926',NULL,'2026-01-23 19:02:21.943660',26,26,'ffe680b4-30d4-4706-b8cf-657ed9c2476e','key8','value8'),('2026-01-23 19:02:25.171287',NULL,'2026-01-23 19:02:39.239751',27,27,'784dce8f-a5a5-4328-baac-1ef916284d88','__mount_options','fs=cephfs'),('2026-01-23 19:02:25.528970',NULL,'2026-01-23 19:02:30.359260',28,28,'ce5d5adc-fe46-4e48-83cf-a608b2bd061e','__mount_options','fs=cephfs'),('2026-01-23 19:02:28.515701',NULL,'2026-01-23 19:02:30.359260',29,29,'ce5d5adc-fe46-4e48-83cf-a608b2bd061e','key3','value3'),('2026-01-23 19:02:28.519256',NULL,'2026-01-23 19:02:30.359260',30,30,'ce5d5adc-fe46-4e48-83cf-a608b2bd061e','key4','value4'),('2026-01-23 19:02:28.525845',NULL,'2026-01-23 19:02:30.359260',31,31,'ce5d5adc-fe46-4e48-83cf-a608b2bd061e','key.5.1','value.5'),('2026-01-23 19:02:33.473944',NULL,'2026-01-23 19:02:37.470589',32,32,'7662b1bb-78a6-468c-b02d-242bc6501e96','key1','value1'),('2026-01-23 19:02:33.474558',NULL,'2026-01-23 19:02:37.470589',33,33,'7662b1bb-78a6-468c-b02d-242bc6501e96','key2','value2'),('2026-01-23 19:02:33.752615',NULL,'2026-01-23 19:02:37.470589',34,34,'7662b1bb-78a6-468c-b02d-242bc6501e96','__mount_options','fs=cephfs'),('2026-01-23 19:02:36.902355',NULL,'2026-01-23 19:03:08.977701',35,35,'6f28e846-7b1c-4dec-80da-017ad13ed962','foo_key_share_1','foo_value_share_1'),('2026-01-23 19:02:36.902925',NULL,'2026-01-23 19:03:08.977701',36,36,'6f28e846-7b1c-4dec-80da-017ad13ed962','bar_key_share_1','foo_value_share_1'),('2026-01-23 19:02:37.263638',NULL,'2026-01-23 19:03:08.977701',37,37,'6f28e846-7b1c-4dec-80da-017ad13ed962','__mount_options','fs=cephfs'),('2026-01-23 19:02:40.904727',NULL,'2026-01-23 19:02:51.062913',38,38,'7bca3129-9356-42c9-8b48-e6061ed16f01','__mount_options','fs=cephfs'),('2026-01-23 19:02:41.053038',NULL,'2026-01-23 19:02:45.526657',39,39,'3f4883fe-85fc-4897-9382-f88c948a4c2b','__mount_options','fs=cephfs'),('2026-01-23 19:02:43.880572','2026-01-23 19:02:44.231575','2026-01-23 19:02:45.526657',40,40,'3f4883fe-85fc-4897-9382-f88c948a4c2b','key9','value13'),('2026-01-23 19:02:43.882063',NULL,'2026-01-23 19:03:01.922401',41,41,'386e06d8-ac44-45fc-b5bc-cda5ad18efea','foo_key_share_2','foo_value_share_2'),('2026-01-23 19:02:43.882686',NULL,'2026-01-23 19:03:01.922401',42,42,'386e06d8-ac44-45fc-b5bc-cda5ad18efea','bar_key_share_2','foo_value_share_2'),('2026-01-23 19:02:43.884220',NULL,'2026-01-23 19:02:45.526657',43,43,'3f4883fe-85fc-4897-9382-f88c948a4c2b','key10','value10'),('2026-01-23 19:02:44.171827',NULL,'2026-01-23 19:03:01.922401',44,44,'386e06d8-ac44-45fc-b5bc-cda5ad18efea','__mount_options','fs=cephfs'),('2026-01-23 19:02:44.244381',NULL,'2026-01-23 19:02:45.526657',45,45,'3f4883fe-85fc-4897-9382-f88c948a4c2b','key11','value11'),('2026-01-23 19:02:48.674585',NULL,'2026-01-23 19:03:02.744168',46,46,'21ed6874-3e57-49ad-ad3d-e168df853ebc','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value'),('2026-01-23 19:02:48.928127','2026-01-23 19:02:49.670041','2026-01-23 19:03:02.744168',47,47,'21ed6874-3e57-49ad-ad3d-e168df853ebc','key','v'),('2026-01-23 19:02:49.284895',NULL,'2026-01-23 19:03:02.744168',48,48,'21ed6874-3e57-49ad-ad3d-e168df853ebc','k','value'),('2026-01-23 19:02:50.908450',NULL,'2026-01-23 19:02:56.688297',49,49,'3da810db-9a70-4383-aaf3-cc25bc7e9cab','__mount_options','fs=cephfs'),('2026-01-23 19:02:53.685940',NULL,'2026-01-23 19:02:56.688297',50,50,'3da810db-9a70-4383-aaf3-cc25bc7e9cab','key9','value9'),('2026-01-23 19:02:53.693552',NULL,'2026-01-23 19:02:56.688297',51,51,'3da810db-9a70-4383-aaf3-cc25bc7e9cab','key10','value10'),('2026-01-23 19:02:54.117006',NULL,'2026-01-23 19:02:56.688297',52,52,'3da810db-9a70-4383-aaf3-cc25bc7e9cab','key11','value11'),('2026-01-23 19:02:54.123920',NULL,'2026-01-23 19:02:56.688297',53,53,'3da810db-9a70-4383-aaf3-cc25bc7e9cab','key12','value12'),('2026-01-23 19:03:00.075886',NULL,'2026-01-23 19:03:02.744168',54,54,'21ed6874-3e57-49ad-ad3d-e168df853ebc','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value'),('2026-01-23 19:03:00.536560',NULL,'2026-01-23 19:03:02.744168',55,55,'21ed6874-3e57-49ad-ad3d-e168df853ebc','key','vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv'),('2026-01-23 19:03:01.177202',NULL,'2026-01-23 19:03:02.744168',56,56,'21ed6874-3e57-49ad-ad3d-e168df853ebc','k','value'),('2026-01-23 19:03:01.574747',NULL,'2026-01-23 19:03:02.744168',57,57,'21ed6874-3e57-49ad-ad3d-e168df853ebc','key','v'),('2026-01-23 19:03:02.450670',NULL,'2026-01-23 19:03:12.039670',58,58,'5df7f392-10cf-4571-bdf9-06da47e30bbd','__mount_options','fs=cephfs'),('2026-01-23 19:03:20.264608',NULL,'2026-01-23 19:06:50.527096',59,59,'925d3664-bf68-4a0a-92b4-6195aa90de88','__mount_options','fs=cephfs'),('2026-01-23 19:03:41.104135',NULL,'2026-01-23 19:04:08.049492',60,60,'e9348c7b-8056-43c2-88d5-4ea6f5c6b0c6','__mount_options','fs=cephfs'),('2026-01-23 19:03:45.290571',NULL,'2026-01-23 19:04:04.660625',61,61,'29d694db-1498-45de-818b-999e5140dad6','__mount_options','fs=cephfs'),('2026-01-23 19:03:49.616312',NULL,'2026-01-23 19:04:01.251850',62,62,'39284e92-1b49-4324-96db-4c5831010bf3','__mount_options','fs=cephfs'),('2026-01-23 19:03:52.532934',NULL,'2026-01-23 19:04:20.935520',63,63,'57d4aac1-6dba-40f5-b7ab-eecb70beae03','__mount_options','fs=cephfs'),('2026-01-23 19:03:53.328165',NULL,'2026-01-23 19:03:57.588878',64,64,'d3d7082d-d3b5-4f70-ac80-ec0346fa5547','__mount_options','fs=cephfs'),('2026-01-23 19:04:23.023702',NULL,'2026-01-23 19:04:34.664564',65,65,'c5ec9c35-4d7c-4fc8-b621-d53247587e9c','__mount_options','fs=cephfs'),('2026-01-23 19:04:27.435280',NULL,'2026-01-23 19:04:30.818835',66,66,'eb3d3e12-5a94-47ea-9820-bf28b2fbcb9a','__mount_options','fs=cephfs'),('2026-01-23 19:04:39.115959',NULL,'2026-01-23 19:04:51.967584',67,67,'98da0987-8f83-410f-9b05-c7ad0936208c','__mount_options','fs=cephfs'),('2026-01-23 19:04:39.361666',NULL,'2026-01-23 19:04:43.346907',68,68,'8bba90e0-40c5-41d4-8973-4840f22849f9','__mount_options','fs=cephfs'),('2026-01-23 19:04:43.689249',NULL,'2026-01-23 19:04:48.152770',69,69,'d6447ad8-5951-4450-ab89-7af9a5180737','__mount_options','fs=cephfs'),('2026-01-23 19:04:52.802945',NULL,'2026-01-23 19:04:57.937024',70,70,'d0a208d6-678f-49b1-b388-ee4a0edb5c52','__mount_options','fs=cephfs'),('2026-01-23 19:05:07.769774',NULL,'2026-01-23 19:05:11.626202',71,71,'1ec67602-9d35-44a8-8c55-aae8555c9738','__mount_options','fs=cephfs'),('2026-01-23 19:05:14.148827',NULL,'2026-01-23 19:05:19.748342',72,72,'63940a9b-b535-42eb-a7cd-94b38ca85aee','key','value'),('2026-01-23 19:05:14.452329',NULL,'2026-01-23 19:05:19.748342',73,73,'63940a9b-b535-42eb-a7cd-94b38ca85aee','__mount_options','fs=cephfs'),('2026-01-23 19:05:15.773503',NULL,'2026-01-23 19:05:19.746484',74,74,'95f14abf-d821-478e-a525-5c4864abf611','__mount_options','fs=cephfs'),('2026-01-23 19:05:33.331794',NULL,'2026-01-23 19:05:50.823965',75,75,'8453ecac-20f9-422a-b1ad-2bd319766708','__mount_options','fs=cephfs'),('2026-01-23 19:05:35.491356',NULL,'2026-01-23 19:06:50.772805',76,76,'37853495-d9b6-4d2c-abc6-da37b9ee8591','__mount_options','fs=cephfs'),('2026-01-23 19:05:40.684794',NULL,'2026-01-23 19:05:55.179400',77,77,'1289a7a6-fe12-4d2f-b00b-358016b0e61e','__mount_options','fs=cephfs'),('2026-01-23 19:05:55.274795',NULL,'2026-01-23 19:05:59.355189',78,78,'16fc78cd-4631-4b5e-bee7-624b90b7fa9f','__mount_options','fs=cephfs'),('2026-01-23 19:05:58.077510',NULL,'2026-01-23 19:06:07.001177',79,79,'ec07c5de-032d-4294-a579-616d0c9c5cc9','__mount_options','fs=cephfs'),('2026-01-23 19:06:06.222233',NULL,'2026-01-23 19:07:02.962508',80,80,'6ef51183-9eb7-460b-91d9-d5b9e76c3afd','__mount_options','fs=cephfs'),('2026-01-23 19:06:09.894333',NULL,'2026-01-23 19:06:19.459087',81,81,'47e3b685-1a97-423d-9bd9-6c6581606054','__mount_options','fs=cephfs'),('2026-01-23 19:06:14.282947',NULL,'2026-01-23 19:06:55.851822',82,82,'b4a0d77a-8aca-4f04-b55e-45899decea01','__mount_options','fs=cephfs'),('2026-01-23 19:06:28.063245',NULL,'2026-01-23 19:06:31.559860',83,83,'ab471169-de9b-4160-affe-e7fd580570d1','__mount_options','fs=cephfs'),('2026-01-23 19:06:35.895903',NULL,'2026-01-23 19:06:39.273766',84,84,'b4308187-b5c6-41cc-9f65-4b5ef066d494','__mount_options','fs=cephfs'),('2026-01-23 19:06:36.264050',NULL,NULL,0,85,'69a009ee-f397-404a-b72b-02056e1c0d04','__mount_options','fs=cephfs'),('2026-01-23 19:07:16.125539',NULL,'2026-01-23 19:08:38.503676',86,86,'d4df52fc-5514-4f2f-adf6-7e0a4fb0f9c6','foo_key_share_1','foo_value_share_1'),('2026-01-23 19:07:16.125867',NULL,'2026-01-23 19:08:38.503676',87,87,'d4df52fc-5514-4f2f-adf6-7e0a4fb0f9c6','bar_key_share_1','foo_value_share_1'),('2026-01-23 19:07:16.416943',NULL,'2026-01-23 19:08:38.503676',88,88,'d4df52fc-5514-4f2f-adf6-7e0a4fb0f9c6','__mount_options','fs=cephfs'),('2026-01-23 19:07:23.511507',NULL,'2026-01-23 19:08:32.312750',89,89,'5f871fb6-01a9-4012-ba73-cb3c1ec609fd','foo_key_share_2','foo_value_share_2'),('2026-01-23 19:07:23.511867',NULL,'2026-01-23 19:08:32.312750',90,90,'5f871fb6-01a9-4012-ba73-cb3c1ec609fd','bar_key_share_2','foo_value_share_2'),('2026-01-23 19:07:31.179887',NULL,'2026-01-23 19:08:32.312750',91,91,'5f871fb6-01a9-4012-ba73-cb3c1ec609fd','__mount_options','fs=cephfs'),('2026-01-23 19:07:31.284644',NULL,'2026-01-23 19:07:37.035633',92,92,'1036c742-b7c8-4486-8595-4ecfc41b77f3','__mount_options','fs=cephfs'),('2026-01-23 19:07:42.295017',NULL,'2026-01-23 19:07:56.492124',93,93,'91677b82-e607-4b55-bd2b-bf34898cc935','__mount_options','fs=cephfs'),('2026-01-23 19:07:50.048230',NULL,'2026-01-23 19:08:39.205570',94,94,'1c640b45-4f70-4ab0-b31e-d65cb9f227fe','__mount_options','fs=cephfs'),('2026-01-23 19:07:58.655027',NULL,'2026-01-23 19:08:02.603191',95,95,'2842acb6-6a55-4fe8-bf4e-af508fb83d9f','__mount_options','fs=cephfs'),('2026-01-23 19:07:58.981903',NULL,'2026-01-23 19:08:06.097215',96,96,'0c705063-7c58-4940-ab8f-3fe6ed80ea78','__mount_options','fs=cephfs'),('2026-01-23 19:08:05.575307',NULL,'2026-01-23 19:09:01.174192',97,97,'d24254b0-53ec-4084-8545-391802f0a833','__mount_options','fs=cephfs'),('2026-01-23 19:08:06.294171',NULL,'2026-01-23 19:08:09.851039',98,98,'6aca15d2-5578-4867-adfa-2bf5c083fe5c','__mount_options','fs=cephfs'),('2026-01-23 19:08:13.299744',NULL,'2026-01-23 19:08:19.914764',99,99,'b477be78-9127-48f3-918b-227b7d20ddba','__mount_options','fs=cephfs'),('2026-01-23 19:08:13.439549',NULL,'2026-01-23 19:08:16.952424',100,100,'58086060-20fd-490e-b109-47b5495a4e56','__mount_options','fs=cephfs'),('2026-01-23 19:08:20.261572',NULL,'2026-01-23 19:08:24.075115',101,101,'85c98837-c914-4e4d-8b55-a429680295cd','__mount_options','fs=cephfs'),('2026-01-23 19:08:23.346676',NULL,'2026-01-23 19:08:28.065194',102,102,'e2d2d17f-a5c7-4419-8e2a-29f8cd7104e8','__mount_options','fs=cephfs'),('2026-01-23 19:08:27.536987',NULL,'2026-01-23 19:08:32.516563',103,103,'10389d2f-ee79-4aa1-86d0-deb816518b03','__mount_options','fs=cephfs'),('2026-01-23 19:08:50.972152',NULL,'2026-01-23 19:09:02.730487',104,104,'4c63b0d1-2bfd-41f1-a117-86a846be3efd','__mount_options','fs=cephfs'),('2026-01-23 19:09:33.593698',NULL,'2026-01-23 19:09:46.388148',105,105,'6e946115-7c50-4b74-844b-36e0e549695b','foo_key_share_1','foo_value_share_1'),('2026-01-23 19:09:33.594261',NULL,'2026-01-23 19:09:46.388148',106,106,'6e946115-7c50-4b74-844b-36e0e549695b','bar_key_share_1','foo_value_share_1'),('2026-01-23 19:09:33.948216',NULL,'2026-01-23 19:09:46.388148',107,107,'6e946115-7c50-4b74-844b-36e0e549695b','__mount_options','fs=cephfs');
/*!40000 ALTER TABLE `share_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_network_security_service_association`
--

DROP TABLE IF EXISTS `share_network_security_service_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_network_security_service_association` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_network_id` varchar(36) NOT NULL,
  `security_service_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `share_network_id` (`share_network_id`),
  KEY `security_service_id` (`security_service_id`),
  CONSTRAINT `share_network_security_service_association_ibfk_1` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`),
  CONSTRAINT `share_network_security_service_association_ibfk_2` FOREIGN KEY (`security_service_id`) REFERENCES `security_services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_network_security_service_association`
--

LOCK TABLES `share_network_security_service_association` WRITE;
/*!40000 ALTER TABLE `share_network_security_service_association` DISABLE KEYS */;
INSERT INTO `share_network_security_service_association` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_network_id`, `security_service_id`) VALUES ('2026-01-23 19:02:04.621675','2026-01-23 19:02:07.252547','2026-01-23 19:02:07.251642',1,1,'40002562-b449-4298-aae2-3888cca25260','d802a673-15d3-408d-9251-4d7e9d8cd26d'),('2026-01-23 19:02:05.518329',NULL,NULL,0,2,'60ea1b10-2146-4dd4-b9f1-bc496f3d8e42','9a233f11-c1bf-433b-ae3e-3b3034f1b9da'),('2026-01-23 19:05:32.068141','2026-01-23 19:05:32.183486','2026-01-23 19:05:32.182653',3,3,'8495fbb4-fd35-4570-ba4e-3e302f5973d4','af18911c-8971-4cbc-8983-d418cc3eb2e8'),('2026-01-23 19:05:33.130293','2026-01-23 19:05:33.572455','2026-01-23 19:05:33.572158',4,4,'c59d43e3-7e46-4d7a-b528-8a79a259bdf9','c7d5bf54-c35e-4306-9c07-0d7d25f1165b'),('2026-01-23 19:05:34.086371','2026-01-23 19:05:34.186779','2026-01-23 19:05:34.186460',5,5,'a64f7b9f-2427-47bf-92ca-940f58eff0bc','7781a44d-3c61-41bc-9de5-6c74a7b0e8f7'),('2026-01-23 19:05:34.366405','2026-01-23 19:05:34.548391','2026-01-23 19:05:34.547637',6,6,'a64f7b9f-2427-47bf-92ca-940f58eff0bc','7781a44d-3c61-41bc-9de5-6c74a7b0e8f7'),('2026-01-23 19:05:41.727682','2026-01-23 19:05:46.044703','2026-01-23 19:05:46.044369',7,7,'227524c2-e409-41d7-9e1d-2e1b0a74ade4','0ed2df46-da6c-4394-b016-af9f3ae54804'),('2026-01-23 19:05:43.531706','2026-01-23 19:05:43.757372','2026-01-23 19:05:43.756921',8,8,'961b0850-0534-4b2e-a186-8e511ff78bfd','07ed9d6d-f858-4bde-a0b7-11162f844161'),('2026-01-23 19:05:44.527635','2026-01-23 19:05:44.893978','2026-01-23 19:05:44.893220',9,9,'0414a198-a925-4de8-b1a4-dfb975e2bb3f','fb089594-ad99-447b-8c31-a74927520542'),('2026-01-23 19:07:14.441898','2026-01-23 19:07:20.824971','2026-01-23 19:07:20.824650',10,10,'81f95788-4a03-4584-ab33-56c077d52b92','d8409690-42bc-4d18-bb6c-16fafe624e12'),('2026-01-23 19:07:15.042514','2026-01-23 19:07:20.495145','2026-01-23 19:07:20.494749',11,11,'16c93783-0185-4e32-82aa-7e4bb958add3','c284e7a8-c9c8-4a30-8125-1b413fcf646b');
/*!40000 ALTER TABLE `share_network_security_service_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_network_subnet_metadata`
--

DROP TABLE IF EXISTS `share_network_subnet_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_network_subnet_metadata` (
  `deleted` varchar(36) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_network_subnet_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `share_network_subnet_id` (`share_network_subnet_id`),
  CONSTRAINT `share_network_subnet_metadata_ibfk_1` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_network_subnet_metadata`
--

LOCK TABLES `share_network_subnet_metadata` WRITE;
/*!40000 ALTER TABLE `share_network_subnet_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_network_subnet_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_network_subnets`
--

DROP TABLE IF EXISTS `share_network_subnets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_network_subnets` (
  `id` varchar(36) NOT NULL,
  `neutron_net_id` varchar(36) DEFAULT NULL,
  `neutron_subnet_id` varchar(36) DEFAULT NULL,
  `network_type` varchar(32) DEFAULT NULL,
  `cidr` varchar(64) DEFAULT NULL,
  `segmentation_id` int(11) DEFAULT NULL,
  `gateway` varchar(64) DEFAULT NULL,
  `mtu` int(11) DEFAULT NULL,
  `share_network_id` varchar(36) DEFAULT NULL,
  `ip_version` int(11) DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_share_network_subnets_share_network_id_share_networks` (`share_network_id`),
  KEY `fk_share_network_subnets_availaility_zone_id_availability_zones` (`availability_zone_id`),
  CONSTRAINT `fk_share_network_subnets_availaility_zone_id_availability_zones` FOREIGN KEY (`availability_zone_id`) REFERENCES `availability_zones` (`id`),
  CONSTRAINT `fk_share_network_subnets_share_network_id_share_networks` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_network_subnets`
--

LOCK TABLES `share_network_subnets` WRITE;
/*!40000 ALTER TABLE `share_network_subnets` DISABLE KEYS */;
INSERT INTO `share_network_subnets` (`id`, `neutron_net_id`, `neutron_subnet_id`, `network_type`, `cidr`, `segmentation_id`, `gateway`, `mtu`, `share_network_id`, `ip_version`, `availability_zone_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES ('02e93b30-758b-4228-b330-82387c95db95',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'8ef7dc4c-047f-490e-baec-93d1cda196a8',NULL,NULL,'2026-01-23 19:03:28.282301',NULL,NULL,'False'),('03b67783-3c5c-4b0f-af0a-c123fc3d0f51',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'9ea48508-6d71-48c6-a611-4cf980bde2a2',NULL,NULL,'2026-01-23 19:03:29.046882',NULL,NULL,'False'),('0b1fdd50-838e-422d-ab7f-49cbc397ae87','tempest-net-id-1748609630','tempest-subnet-id-1447947787',NULL,NULL,NULL,NULL,NULL,'f3d484b6-7df1-4cda-908b-8f686ad8dc98',NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','2026-01-23 19:07:10.885963','2026-01-23 19:07:11.141180','2026-01-23 19:07:11.140698','0b1fdd50-838e-422d-ab7f-49cbc397ae87'),('1554bce6-14d1-4a5d-918d-c59c815bedb2','tempest-net-id-596108145','tempest-subnet-id-2126131846','vlan','10.0.0.0/24',1000,NULL,NULL,'81f95788-4a03-4584-ab33-56c077d52b92',4,NULL,'2002-02-02 00:00:00.000000','2026-01-23 19:07:19.624809',NULL,'False'),('22438e54-168a-4051-a8ad-8f227b89260f','tempest-net-id-1520733822','tempest-subnet-id-1290900077',NULL,NULL,NULL,NULL,NULL,'c59d43e3-7e46-4d7a-b528-8a79a259bdf9',NULL,NULL,'2026-01-23 19:05:32.908995',NULL,NULL,'False'),('2cc11664-a61d-4ebb-a36d-c8375c1716f7','tempest-net-id-1412139775','tempest-subnet-id-24874047',NULL,NULL,NULL,NULL,NULL,'5a74b660-aae2-49f5-b07c-fd47a2390dc6',NULL,NULL,'2026-01-23 19:07:18.877283',NULL,NULL,'False'),('36eb37d9-9653-477f-9910-22a64a32d2e5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'f3d484b6-7df1-4cda-908b-8f686ad8dc98',NULL,NULL,'2026-01-23 19:07:10.695972',NULL,NULL,'False'),('37d314fe-3441-4901-ae94-e771eac1f6c7','tempest-net-id-2091525656','tempest-subnet-id-2096295704',NULL,NULL,NULL,NULL,NULL,'19546698-b1b1-42f7-b654-effe462b6a6b',NULL,NULL,'2026-01-23 19:07:15.895105',NULL,NULL,'False'),('4169db6e-ff80-4e03-b405-2e49ffd96126',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'f3bd7e99-94c8-4574-83be-8b5c05729c5d',NULL,NULL,'2026-01-23 19:06:18.928944',NULL,NULL,'False'),('52c8c910-0050-4208-b278-7c6167e52a4e','tempest-net-id-1412139775','tempest-subnet-id-24874047',NULL,NULL,NULL,NULL,NULL,'a13c466a-c591-45b3-8d53-fdd92e19f172',NULL,NULL,'2026-01-23 19:07:18.650106',NULL,NULL,'False'),('550bc46d-2b3c-4fea-9b4b-90ee48b2a084',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'227524c2-e409-41d7-9e1d-2e1b0a74ade4',NULL,NULL,'2026-01-23 19:05:41.189844',NULL,NULL,'False'),('582235f4-6ad8-494e-8418-dd6d6d4fe90d','tempest-net-id-1717766935','tempest-subnet-id-1762374084',NULL,NULL,NULL,NULL,NULL,'0414a198-a925-4de8-b1a4-dfb975e2bb3f',NULL,NULL,'2026-01-23 19:05:44.294971',NULL,NULL,'False'),('5f58dcf7-2a74-495a-a455-543055134c4d',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'cc22065c-16ec-47ef-aab3-102d8626f2d8',NULL,NULL,'2026-01-23 19:07:09.740729',NULL,NULL,'False'),('646a6c50-0284-4398-92f4-d6638bc13e15','tempest-net-id-621844128','tempest-subnet-id-1881991642',NULL,NULL,NULL,NULL,NULL,'9ea48508-6d71-48c6-a611-4cf980bde2a2',NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','2026-01-23 19:03:29.398400','2026-01-23 19:03:29.591431','2026-01-23 19:03:29.590694','646a6c50-0284-4398-92f4-d6638bc13e15'),('9184b588-d061-41b5-8de0-3139ef8c4d8e','tempest-net-id-1357715067','tempest-subnet-id-1889618156',NULL,NULL,NULL,NULL,NULL,'961b0850-0534-4b2e-a186-8e511ff78bfd',NULL,NULL,'2026-01-23 19:05:42.886281',NULL,NULL,'False'),('a1858529-b03a-4790-98af-dd5aab752581','tempest-net-id-762850189','tempest-subnet-id-1205189393',NULL,NULL,NULL,NULL,NULL,'8495fbb4-fd35-4570-ba4e-3e302f5973d4',NULL,NULL,'2026-01-23 19:05:31.755142',NULL,NULL,'False'),('a4fd97fb-74d9-454b-b28e-39f4847ac1fc','tempest-net-id-344870946','tempest-subnet-id-1346789083',NULL,NULL,NULL,NULL,NULL,'f3bd7e99-94c8-4574-83be-8b5c05729c5d',NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','2026-01-23 19:06:19.733370','2026-01-23 19:06:19.848462','2026-01-23 19:06:19.847390','a4fd97fb-74d9-454b-b28e-39f4847ac1fc'),('a55c240e-182c-4b41-98ba-949a3b1e3672','tempest-net-id-332240759','tempest-subnet-id-1021566995',NULL,NULL,NULL,NULL,NULL,'c6b9c8bc-236f-4b84-8be4-72468824f4eb',NULL,NULL,'2026-01-23 19:07:15.247795',NULL,NULL,'False'),('ac3fba77-a8b9-4ea2-a680-2edd7131cbb5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'63f18200-31b5-41f8-8764-56c9a7272a22',NULL,NULL,'2026-01-23 19:03:28.129998',NULL,NULL,'False'),('c14022cc-cf4f-45f1-bed8-f28c64f795e9','test net id','test subnet id','local','10.0.0.0/13',2000,NULL,NULL,'16c93783-0185-4e32-82aa-7e4bb958add3',6,NULL,'2003-03-03 00:00:00.000000',NULL,NULL,'False'),('c4388c37-b637-4ca8-b602-e10d1b45228a','tempest-net-id-2091525656','tempest-subnet-id-2096295704',NULL,NULL,NULL,NULL,NULL,'a836965a-fcf9-4389-965c-13b10095f144',NULL,NULL,'2026-01-23 19:07:16.027950',NULL,NULL,'False'),('cca5defb-2184-4268-aec0-0a4732b6bda9','test net id','test subnet id','local','10.0.0.0/13',2000,NULL,NULL,'60ea1b10-2146-4dd4-b9f1-bc496f3d8e42',6,NULL,'2003-03-03 00:00:00.000000',NULL,NULL,'False'),('ccfbd394-d7f6-4749-8082-6f1ffc1aec4e','1111','2222','vlan','10.0.0.0/24',1000,NULL,NULL,'40002562-b449-4298-aae2-3888cca25260',4,NULL,'2002-02-02 00:00:00.000000',NULL,NULL,'False'),('cdc79f16-2dcb-48e6-b5e6-35a9cebc5721','tempest-net-id-1441272242','tempest-subnet-id-1275752576',NULL,NULL,NULL,NULL,NULL,'a7ef485a-a20f-430b-8a62-4574042ba546',NULL,NULL,'2026-01-23 19:07:12.292265',NULL,NULL,'False'),('e0178104-5bad-4c49-af60-d925eacadc56','tempest-net-id-2130156603','tempest-subnet-id-157717129',NULL,NULL,NULL,NULL,NULL,'8ef7dc4c-047f-490e-baec-93d1cda196a8',NULL,'5a2138fd-ba6d-48ad-9535-0dd6138ffaec','2026-01-23 19:03:28.549641','2026-01-23 19:03:28.656537','2026-01-23 19:03:28.655754','e0178104-5bad-4c49-af60-d925eacadc56'),('efbdb6c9-0645-47b7-a128-36d49aea651c','tempest-net-id-125894231','tempest-subnet-id-2093863045',NULL,NULL,NULL,NULL,NULL,'a64f7b9f-2427-47bf-92ca-940f58eff0bc',NULL,NULL,'2026-01-23 19:05:33.878756',NULL,NULL,'False');
/*!40000 ALTER TABLE `share_network_subnets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_networks`
--

DROP TABLE IF EXISTS `share_networks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_networks` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(36) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_networks`
--

LOCK TABLES `share_networks` WRITE;
/*!40000 ALTER TABLE `share_networks` DISABLE KEYS */;
INSERT INTO `share_networks` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `user_id`, `name`, `description`, `status`) VALUES ('2026-01-23 19:05:44.278101','2026-01-23 19:05:44.907671','2026-01-23 19:05:44.907238','0414a198-a925-4de8-b1a4-dfb975e2bb3f','0414a198-a925-4de8-b1a4-dfb975e2bb3f','283b89301a234374a4dbf7307759750d','9c4042b5b9c640f89f2cced6d4f42a9b','tempest-sn-name-1101342138','tempest-sn-desc-32381336','active'),('2003-03-03 00:00:00.000000','2026-01-23 19:07:20.512763','2026-01-23 19:07:20.512141','16c93783-0185-4e32-82aa-7e4bb958add3','16c93783-0185-4e32-82aa-7e4bb958add3','cd28fe6ab6ac42579a9ef7ca014c6978','968d5d01fead4ec5974c92681f5cd389','sn_with_kerberos_ss','fake description','active'),('2026-01-23 19:07:15.876843','2026-01-23 19:07:16.390324','2026-01-23 19:07:16.389879','19546698-b1b1-42f7-b654-effe462b6a6b','19546698-b1b1-42f7-b654-effe462b6a6b','cd28fe6ab6ac42579a9ef7ca014c6978','968d5d01fead4ec5974c92681f5cd389','tempest-sn-name-308292984','tempest-sn-desc-1729442603','active'),('2026-01-23 19:05:41.175444','2026-01-23 19:05:46.064501','2026-01-23 19:05:46.064048','227524c2-e409-41d7-9e1d-2e1b0a74ade4','227524c2-e409-41d7-9e1d-2e1b0a74ade4','283b89301a234374a4dbf7307759750d','9c4042b5b9c640f89f2cced6d4f42a9b',NULL,NULL,'active'),('2002-02-02 00:00:00.000000','2026-01-23 19:02:07.269005','2026-01-23 19:02:07.268059','40002562-b449-4298-aae2-3888cca25260','40002562-b449-4298-aae2-3888cca25260','0034e94cde5c402eb542d58e14a80d2c','d4854e7989914b0a8de972d4f7254ff2','sn_with_ldap_ss','fake description','active'),('2026-01-23 19:07:18.860080','2026-01-23 19:07:19.044847','2026-01-23 19:07:19.044453','5a74b660-aae2-49f5-b07c-fd47a2390dc6','5a74b660-aae2-49f5-b07c-fd47a2390dc6','cd28fe6ab6ac42579a9ef7ca014c6978','968d5d01fead4ec5974c92681f5cd389','tempest-sn-name-1034026265','tempest-sn-desc-1682732005','active'),('2003-03-03 00:00:00.000000',NULL,NULL,'False','60ea1b10-2146-4dd4-b9f1-bc496f3d8e42','1a8798b902e7464fa59d9b7585e84a49','06e0d50765b84a109551bfac230deae0','sn_with_kerberos_ss','fake description','active'),('2026-01-23 19:03:28.093087','2026-01-23 19:03:28.853633','2026-01-23 19:03:28.852821','63f18200-31b5-41f8-8764-56c9a7272a22','63f18200-31b5-41f8-8764-56c9a7272a22','a8836123057e49ac857e8374c9186ff3','886ae9f8d85b45299215f046dc178830',NULL,NULL,'active'),('2002-02-02 00:00:00.000000','2026-01-23 19:07:20.840204','2026-01-23 19:07:20.839729','81f95788-4a03-4584-ab33-56c077d52b92','81f95788-4a03-4584-ab33-56c077d52b92','cd28fe6ab6ac42579a9ef7ca014c6978','968d5d01fead4ec5974c92681f5cd389','tempest-sn-name-1757704522','tempest-sn-desc-606693545','active'),('2026-01-23 19:05:31.742028','2026-01-23 19:05:32.611347','2026-01-23 19:05:32.610874','8495fbb4-fd35-4570-ba4e-3e302f5973d4','8495fbb4-fd35-4570-ba4e-3e302f5973d4','b17f281119ff44cbbbf9816794032547','767061f8596f444f8e3ea7f80967fec5','tempest-sn-name-1579505522','tempest-sn-desc-1208289650','active'),('2026-01-23 19:03:28.261045',NULL,NULL,'False','8ef7dc4c-047f-490e-baec-93d1cda196a8','a8836123057e49ac857e8374c9186ff3','886ae9f8d85b45299215f046dc178830',NULL,NULL,'active'),('2026-01-23 19:05:42.768321','2026-01-23 19:05:44.119734','2026-01-23 19:05:44.119175','961b0850-0534-4b2e-a186-8e511ff78bfd','961b0850-0534-4b2e-a186-8e511ff78bfd','283b89301a234374a4dbf7307759750d','9c4042b5b9c640f89f2cced6d4f42a9b','tempest-sn-name-886316062','tempest-sn-desc-856519410','active'),('2026-01-23 19:03:29.024690','2026-01-23 19:03:29.802404','2026-01-23 19:03:29.801386','9ea48508-6d71-48c6-a611-4cf980bde2a2','9ea48508-6d71-48c6-a611-4cf980bde2a2','a8836123057e49ac857e8374c9186ff3','886ae9f8d85b45299215f046dc178830',NULL,NULL,'active'),('2026-01-23 19:07:18.635725','2026-01-23 19:07:18.755532','2026-01-23 19:07:18.755055','a13c466a-c591-45b3-8d53-fdd92e19f172','a13c466a-c591-45b3-8d53-fdd92e19f172','cd28fe6ab6ac42579a9ef7ca014c6978','968d5d01fead4ec5974c92681f5cd389','tempest-sn-name-1034026265','tempest-sn-desc-1682732005','active'),('2026-01-23 19:05:33.862803','2026-01-23 19:05:34.564540','2026-01-23 19:05:34.563666','a64f7b9f-2427-47bf-92ca-940f58eff0bc','a64f7b9f-2427-47bf-92ca-940f58eff0bc','b17f281119ff44cbbbf9816794032547','767061f8596f444f8e3ea7f80967fec5','tempest-sn-name-302755738','tempest-sn-desc-292819196','active'),('2026-01-23 19:07:12.270982','2026-01-23 19:07:12.570898','2026-01-23 19:07:12.570067','a7ef485a-a20f-430b-8a62-4574042ba546','a7ef485a-a20f-430b-8a62-4574042ba546','8ef2e7b772bf414b9d6c084c7663325d','02a38fd372d54825882d2b76e2408a99','tempest-sn-name-36684674','tempest-sn-desc-761724428','active'),('2026-01-23 19:07:16.015483','2026-01-23 19:07:16.153561','2026-01-23 19:07:16.153113','a836965a-fcf9-4389-965c-13b10095f144','a836965a-fcf9-4389-965c-13b10095f144','cd28fe6ab6ac42579a9ef7ca014c6978','968d5d01fead4ec5974c92681f5cd389','tempest-sn-name-308292984','tempest-sn-desc-1729442603','active'),('2026-01-23 19:05:32.889468','2026-01-23 19:05:33.590469','2026-01-23 19:05:33.588588','c59d43e3-7e46-4d7a-b528-8a79a259bdf9','c59d43e3-7e46-4d7a-b528-8a79a259bdf9','b17f281119ff44cbbbf9816794032547','767061f8596f444f8e3ea7f80967fec5','tempest-sn-name-641080567','tempest-sn-desc-1468202812','active'),('2026-01-23 19:07:15.228860','2026-01-23 19:07:15.475126','2026-01-23 19:07:15.474692','c6b9c8bc-236f-4b84-8be4-72468824f4eb','c6b9c8bc-236f-4b84-8be4-72468824f4eb','cd28fe6ab6ac42579a9ef7ca014c6978','968d5d01fead4ec5974c92681f5cd389','tempest-sn-name-98869237','tempest-sn-desc-353422268','active'),('2026-01-23 19:07:09.728023','2026-01-23 19:07:10.100607','2026-01-23 19:07:10.100042','cc22065c-16ec-47ef-aab3-102d8626f2d8','cc22065c-16ec-47ef-aab3-102d8626f2d8','8ef2e7b772bf414b9d6c084c7663325d','02a38fd372d54825882d2b76e2408a99',NULL,NULL,'active'),('2026-01-23 19:06:18.901681',NULL,NULL,'False','f3bd7e99-94c8-4574-83be-8b5c05729c5d','05bdf608ce00460ba07de9e0ce988795','f395e891216c41888bac49e47c3ac432',NULL,NULL,'active'),('2026-01-23 19:07:10.680215','2026-01-23 19:07:11.511265','2026-01-23 19:07:11.510835','f3d484b6-7df1-4cda-908b-8f686ad8dc98','f3d484b6-7df1-4cda-908b-8f686ad8dc98','8ef2e7b772bf414b9d6c084c7663325d','02a38fd372d54825882d2b76e2408a99',NULL,NULL,'active');
/*!40000 ALTER TABLE `share_networks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_server_backend_details`
--

DROP TABLE IF EXISTS `share_server_backend_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_server_backend_details` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_server_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `share_server_id` (`share_server_id`),
  CONSTRAINT `share_server_backend_details_ibfk_1` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_server_backend_details`
--

LOCK TABLES `share_server_backend_details` WRITE;
/*!40000 ALTER TABLE `share_server_backend_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_server_backend_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_server_share_network_subnet_mappings`
--

DROP TABLE IF EXISTS `share_server_share_network_subnet_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_server_share_network_subnet_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_server_id` varchar(36) NOT NULL,
  `share_network_subnet_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_ss_sns_m_share_server_id_share_servers` (`share_server_id`),
  KEY `fk_ss_sns_m_share_network_subnet_id_share_network_subnets` (`share_network_subnet_id`),
  CONSTRAINT `fk_ss_sns_m_share_network_subnet_id_share_network_subnets` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`),
  CONSTRAINT `fk_ss_sns_m_share_server_id_share_servers` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_server_share_network_subnet_mappings`
--

LOCK TABLES `share_server_share_network_subnet_mappings` WRITE;
/*!40000 ALTER TABLE `share_server_share_network_subnet_mappings` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_server_share_network_subnet_mappings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_servers`
--

DROP TABLE IF EXISTS `share_servers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_servers` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `host` varchar(255) DEFAULT NULL,
  `status` varchar(32) DEFAULT NULL,
  `is_auto_deletable` tinyint(1) DEFAULT NULL,
  `identifier` varchar(255) DEFAULT NULL,
  `task_state` varchar(255) DEFAULT NULL,
  `source_share_server_id` varchar(36) DEFAULT NULL,
  `security_service_update_support` tinyint(1) NOT NULL DEFAULT 0,
  `network_allocation_update_support` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `fk_share_servers_source_share_server_id` (`source_share_server_id`),
  CONSTRAINT `fk_share_servers_source_share_server_id` FOREIGN KEY (`source_share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_servers`
--

LOCK TABLES `share_servers` WRITE;
/*!40000 ALTER TABLE `share_servers` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_servers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_access_map`
--

DROP TABLE IF EXISTS `share_snapshot_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_access_map` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_snapshot_id` varchar(36) DEFAULT NULL,
  `access_type` varchar(255) DEFAULT NULL,
  `access_to` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ssam_snapshot_fk` (`share_snapshot_id`),
  CONSTRAINT `ssam_snapshot_fk` FOREIGN KEY (`share_snapshot_id`) REFERENCES `share_snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_access_map`
--

LOCK TABLES `share_snapshot_access_map` WRITE;
/*!40000 ALTER TABLE `share_snapshot_access_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_instance_access_map`
--

DROP TABLE IF EXISTS `share_snapshot_instance_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_instance_access_map` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_snapshot_instance_id` varchar(36) DEFAULT NULL,
  `access_id` varchar(36) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ssiam_snapshot_instance_fk` (`share_snapshot_instance_id`),
  KEY `ssam_access_fk` (`access_id`),
  CONSTRAINT `ssam_access_fk` FOREIGN KEY (`access_id`) REFERENCES `share_snapshot_access_map` (`id`),
  CONSTRAINT `ssiam_snapshot_instance_fk` FOREIGN KEY (`share_snapshot_instance_id`) REFERENCES `share_snapshot_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_instance_access_map`
--

LOCK TABLES `share_snapshot_instance_access_map` WRITE;
/*!40000 ALTER TABLE `share_snapshot_instance_access_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_instance_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_instance_export_locations`
--

DROP TABLE IF EXISTS `share_snapshot_instance_export_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_instance_export_locations` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_snapshot_instance_id` varchar(36) DEFAULT NULL,
  `path` varchar(2000) DEFAULT NULL,
  `is_admin_only` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ssiel_snapshot_instance_fk` (`share_snapshot_instance_id`),
  CONSTRAINT `ssiel_snapshot_instance_fk` FOREIGN KEY (`share_snapshot_instance_id`) REFERENCES `share_snapshot_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_instance_export_locations`
--

LOCK TABLES `share_snapshot_instance_export_locations` WRITE;
/*!40000 ALTER TABLE `share_snapshot_instance_export_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_instance_export_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_instances`
--

DROP TABLE IF EXISTS `share_snapshot_instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_instances` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `share_instance_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `share_proto` varchar(255) DEFAULT NULL,
  `share_group_snapshot_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ssi_snapshot_fk` (`snapshot_id`),
  KEY `ssi_share_instance_fk` (`share_instance_id`),
  CONSTRAINT `ssi_share_instance_fk` FOREIGN KEY (`share_instance_id`) REFERENCES `share_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_instances`
--

LOCK TABLES `share_snapshot_instances` WRITE;
/*!40000 ALTER TABLE `share_snapshot_instances` DISABLE KEYS */;
INSERT INTO `share_snapshot_instances` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `snapshot_id`, `share_instance_id`, `status`, `progress`, `provider_location`, `user_id`, `project_id`, `size`, `share_proto`, `share_group_snapshot_id`) VALUES ('2026-01-23 19:08:08.587343','2026-01-23 19:08:57.732992','2026-01-23 19:08:57.732228','07765c7c-c79c-4c9c-b4e1-eb82fb30e21c','07765c7c-c79c-4c9c-b4e1-eb82fb30e21c','aea27463-e745-4cdf-b933-f34265646329','b8a58bec-b849-4bc6-8dba-3cc458df53f5','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:07:53.532768','2026-01-23 19:08:35.811069','2026-01-23 19:08:35.810280','117dfa48-4122-43f1-91a6-c0069747cede','117dfa48-4122-43f1-91a6-c0069747cede','c72bee12-7f03-4342-a0eb-04d39fa0a5a4','a1da1abe-af26-445a-9262-0ff686ee8203','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:07:45.770550','2026-01-23 19:07:50.507173','2026-01-23 19:07:50.506265','21864cd1-392f-4e6e-bb83-b7db38eeb626','21864cd1-392f-4e6e-bb83-b7db38eeb626','81df423a-af39-4393-a966-b0937dc73485','f0a550da-da13-43b9-818c-b94c83664b8c','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:02:40.457715','2026-01-23 19:03:05.506813','2026-01-23 19:03:05.506346','22f9ca4d-0f2d-43f9-b7c2-39a93632a737','22f9ca4d-0f2d-43f9-b7c2-39a93632a737','0d399fc2-1c4a-4fa4-a842-d2d9e4db8512','f6c4c50e-f72c-439c-a86a-fc2726fe09af','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:07:19.777454','2026-01-23 19:08:34.974527','2026-01-23 19:08:34.973996','2e22f4cc-505c-4e71-9134-2fa711cee58c','2e22f4cc-505c-4e71-9134-2fa711cee58c','f7119362-56c6-41a3-a825-295c8385d456','c09bd88d-6bf6-440e-b929-87c3d463c101','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:01:31.736232','2026-01-23 19:01:49.962392','2026-01-23 19:01:49.961900','3b316d82-4a97-4373-b0b5-54ea536d2817','3b316d82-4a97-4373-b0b5-54ea536d2817','e321d9c3-2ef6-4719-b058-31b227661b87','349e50d8-8b7b-4b2a-9bbb-82e4a22fd8a9','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:08:45.535572','2026-01-23 19:08:51.502248','2026-01-23 19:08:51.501830','4b69fd96-9531-494b-a7cb-cb4682a0d87d','4b69fd96-9531-494b-a7cb-cb4682a0d87d','fff171a8-cb0e-434d-aaef-163dc51e46db','b8a58bec-b849-4bc6-8dba-3cc458df53f5','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:08:34.657400','2026-01-23 19:08:40.546395','2026-01-23 19:08:40.545986','59ad9788-d464-4c36-8276-7b68dd1c408e','59ad9788-d464-4c36-8276-7b68dd1c408e','7a9b1bc3-c5b4-4ffd-bcd5-79b532a504e0','b8a58bec-b849-4bc6-8dba-3cc458df53f5','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:05:36.461482','2026-01-23 19:05:41.237668','2026-01-23 19:05:41.236900','5a92e829-b779-4d6a-86d3-e30739ce4640','5a92e829-b779-4d6a-86d3-e30739ce4640','41ef5335-9df1-41d2-a109-22ba85d3567b','2649806c-36b6-496b-8324-f7d5569ca22e','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:00:00.718584','2026-01-23 19:00:04.857261','2026-01-23 19:00:04.856572','6bcd36ca-343f-4a64-9ade-e69aae9fc755','6bcd36ca-343f-4a64-9ade-e69aae9fc755','d0fab392-1de9-468f-8ddd-0e8673bf9cea','a0a8215b-eedb-45d9-a08e-7e13600761d5','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:08:19.487871','2026-01-23 19:08:24.310305','2026-01-23 19:08:24.309906','769b22c4-afb8-4b6e-b8a0-d29e1651ab74','769b22c4-afb8-4b6e-b8a0-d29e1651ab74','384e95a6-7587-4e64-943f-75b52be57cc0','b8a58bec-b849-4bc6-8dba-3cc458df53f5','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:00:46.040456','2026-01-23 19:01:04.102832','2026-01-23 19:01:04.102081','8a8f4c34-3602-4c1b-9d6f-90bcadc0a2b7','8a8f4c34-3602-4c1b-9d6f-90bcadc0a2b7','f6297e64-4bea-4cf5-a7c3-096c342cca94','8c3aacd4-958b-4e71-b998-b587ef3cb3df','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:06:09.570302','2026-01-23 19:06:59.387720','2026-01-23 19:06:59.387166','91ef0345-6629-4e97-ba21-4bc60ef4b65b','91ef0345-6629-4e97-ba21-4bc60ef4b65b','cdd68b8f-be76-4491-bcdc-990526be471f','a974fb39-4b39-4d59-84a7-f8f3ffa56b12','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:08:27.483831','2026-01-23 19:08:32.231724','2026-01-23 19:08:32.231092','92391ed6-22d5-4be9-ab4f-a3e9253c123a','92391ed6-22d5-4be9-ab4f-a3e9253c123a','0d41606b-3c6a-49d1-ae8f-8d8fc9ec2007','b8a58bec-b849-4bc6-8dba-3cc458df53f5','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:08:54.089166','2026-01-23 19:08:59.037931','2026-01-23 19:08:59.037315','96b82404-033c-404f-8259-7402ea1ce023','96b82404-033c-404f-8259-7402ea1ce023','37fb13a4-3bbe-4617-bd83-2f119a82680c','cb4de7c2-b53e-4f25-93d6-250c4ea8ac22','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:00:41.909773','2026-01-23 19:01:20.476137','2026-01-23 19:01:20.475589','97cdfd79-b988-4626-a98d-a77e7f8f9c6d','97cdfd79-b988-4626-a98d-a77e7f8f9c6d','40099f4c-64b9-4793-91a5-8cec06f6370d','813e89aa-6f7f-4c70-8d5a-de6aa64dcb0f','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:00:52.727468','2026-01-23 19:00:59.775093','2026-01-23 19:00:59.774648','9a5b226f-dbf8-4a92-ba98-cee757f80297','9a5b226f-dbf8-4a92-ba98-cee757f80297','ad76e9d3-bc9b-4f07-99a8-9c0edee4549e','8c3aacd4-958b-4e71-b998-b587ef3cb3df','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:09:37.165192','2026-01-23 19:09:42.867896','2026-01-23 19:09:42.867350','a1ee0ee3-99a7-4e0f-8d21-99cc122f6a44','a1ee0ee3-99a7-4e0f-8d21-99cc122f6a44','b02922a0-ce94-4a9d-86c4-763307de222d','aa2c8728-a923-4fbb-967a-08864f87ea61','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:00:59.035187','2026-01-23 19:01:09.387706','2026-01-23 19:01:09.387111','aaa210cc-1f19-45c2-8b54-f2b45f28d1c9','aaa210cc-1f19-45c2-8b54-f2b45f28d1c9','7de60689-f2ab-45ae-8aa7-dd2bb230a472','813e89aa-6f7f-4c70-8d5a-de6aa64dcb0f','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:00:28.177226','2026-01-23 19:00:32.261812','2026-01-23 19:00:32.261308','ac550a10-2960-4957-90e7-920e24404d04','ac550a10-2960-4957-90e7-920e24404d04','88b13502-f510-4325-a8f5-797343db3fc5','813e89aa-6f7f-4c70-8d5a-de6aa64dcb0f','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:00:47.194607','2026-01-23 19:01:16.765224','2026-01-23 19:01:16.764608','c09bf33b-68fc-4afe-921b-aa0d9f3d7960','c09bf33b-68fc-4afe-921b-aa0d9f3d7960','1b7bb815-c96a-4c7f-8325-17c1098513a3','813e89aa-6f7f-4c70-8d5a-de6aa64dcb0f','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:00:52.894273','2026-01-23 19:01:13.204348','2026-01-23 19:01:13.203869','dd32eeec-5a8f-4c4e-9ab5-8669e63515c5','dd32eeec-5a8f-4c4e-9ab5-8669e63515c5','9425dea3-7e92-4e57-96a9-0eeb8d61fea2','813e89aa-6f7f-4c70-8d5a-de6aa64dcb0f','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:03:05.780178','2026-01-23 19:03:11.249379','2026-01-23 19:03:11.248925','de85100c-6917-4012-99ca-41973a562a73','de85100c-6917-4012-99ca-41973a562a73','749ef186-fa39-4590-aae7-f85c11afac2a','26b68481-1e3f-49e4-928e-ce608e53fe50','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:02:43.392281','2026-01-23 19:02:47.489169','2026-01-23 19:02:47.488765','e0e569dd-06da-47d6-9ed3-5f32e4b27bde','e0e569dd-06da-47d6-9ed3-5f32e4b27bde','a35127f8-9b81-4991-98e4-157cc93eee79','da2057f4-30b8-4287-b324-aaa510666419','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:01:04.252429','2026-01-23 19:01:06.078858','2026-01-23 19:01:06.078342','e9bef8c7-d2b4-47f2-8b32-4f9fbb9e41ec','e9bef8c7-d2b4-47f2-8b32-4f9fbb9e41ec','fb3f4422-819c-4771-8d5d-1753533710d7','813e89aa-6f7f-4c70-8d5a-de6aa64dcb0f','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:07:32.580355','2026-01-23 19:07:33.355932','2026-01-23 19:07:33.355312','ea5fca0e-7166-47ce-8ff0-ef57fbc5ca8a','ea5fca0e-7166-47ce-8ff0-ef57fbc5ca8a','35716c41-5b72-46b0-b1fd-367179c86a72','ca22b681-9cb5-4a64-81d1-5d9133599b53','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-23 19:08:11.938281','2026-01-23 19:08:16.409589','2026-01-23 19:08:16.407967','ff3bf6c7-50df-4ff3-b5c1-61682211af1e','ff3bf6c7-50df-4ff3-b5c1-61682211af1e','05d8d6a4-f40b-47a0-9f79-f4489052a0d6','b8a58bec-b849-4bc6-8dba-3cc458df53f5','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `share_snapshot_instances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_metadata`
--

DROP TABLE IF EXISTS `share_snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_metadata` (
  `deleted` varchar(36) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `share_snapshot_id` (`share_snapshot_id`),
  CONSTRAINT `share_snapshot_metadata_ibfk_1` FOREIGN KEY (`share_snapshot_id`) REFERENCES `share_snapshots` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_metadata`
--

LOCK TABLES `share_snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `share_snapshot_metadata` DISABLE KEYS */;
INSERT INTO `share_snapshot_metadata` (`deleted`, `created_at`, `updated_at`, `deleted_at`, `share_snapshot_id`, `key`, `value`, `id`) VALUES ('1','2026-01-23 19:08:15.306296','2026-01-23 19:08:15.526694','2026-01-23 19:08:16.426548','05d8d6a4-f40b-47a0-9f79-f4489052a0d6','key5','value5',1),('2','2026-01-23 19:08:15.310264','2026-01-23 19:08:15.552125','2026-01-23 19:08:16.426548','05d8d6a4-f40b-47a0-9f79-f4489052a0d6','key6','value6',2),('3','2026-01-23 19:08:15.578119',NULL,'2026-01-23 19:08:16.426548','05d8d6a4-f40b-47a0-9f79-f4489052a0d6','key7','value7',3),('4','2026-01-23 19:08:15.579994',NULL,'2026-01-23 19:08:16.426548','05d8d6a4-f40b-47a0-9f79-f4489052a0d6','key8','value8',4),('5','2026-01-23 19:08:22.871348','2026-01-23 19:08:23.432247','2026-01-23 19:08:24.323030','384e95a6-7587-4e64-943f-75b52be57cc0','key3','value3',5),('6','2026-01-23 19:08:22.874210','2026-01-23 19:08:23.558845','2026-01-23 19:08:24.323030','384e95a6-7587-4e64-943f-75b52be57cc0','key4','value4',6),('7','2026-01-23 19:08:22.876705','2026-01-23 19:08:23.676733','2026-01-23 19:08:24.323030','384e95a6-7587-4e64-943f-75b52be57cc0','key.5.1','value.5',7),('8','2026-01-23 19:08:27.482546',NULL,'2026-01-23 19:08:32.271872','0d41606b-3c6a-49d1-ae8f-8d8fc9ec2007','key1','value1',8),('9','2026-01-23 19:08:27.482971',NULL,'2026-01-23 19:08:32.271872','0d41606b-3c6a-49d1-ae8f-8d8fc9ec2007','key2','value2',9),('10','2026-01-23 19:08:38.102395','2026-01-23 19:08:39.231548','2026-01-23 19:08:40.562645','7a9b1bc3-c5b4-4ffd-bcd5-79b532a504e0','key9','value13',10),('11','2026-01-23 19:08:38.104764','2026-01-23 19:08:39.347611','2026-01-23 19:08:40.562645','7a9b1bc3-c5b4-4ffd-bcd5-79b532a504e0','key10','value10',11),('12','2026-01-23 19:08:38.682400','2026-01-23 19:08:39.588094','2026-01-23 19:08:40.562645','7a9b1bc3-c5b4-4ffd-bcd5-79b532a504e0','key11','value11',12),('13','2026-01-23 19:08:43.814690','2026-01-23 19:08:54.724145','2026-01-23 19:08:57.748750','aea27463-e745-4cdf-b933-f34265646329','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value',13),('14','2026-01-23 19:08:44.183231','2026-01-23 19:08:54.764068','2026-01-23 19:08:57.748750','aea27463-e745-4cdf-b933-f34265646329','key','v',14),('15','2026-01-23 19:08:44.662961','2026-01-23 19:08:54.819196','2026-01-23 19:08:57.748750','aea27463-e745-4cdf-b933-f34265646329','k','value',15),('16','2026-01-23 19:08:49.199603','2026-01-23 19:08:50.663155','2026-01-23 19:08:51.516773','fff171a8-cb0e-434d-aaef-163dc51e46db','key9','value9',16),('17','2026-01-23 19:08:49.202583','2026-01-23 19:08:50.825497','2026-01-23 19:08:51.516773','fff171a8-cb0e-434d-aaef-163dc51e46db','key10','value10',17),('18','2026-01-23 19:08:49.851915','2026-01-23 19:08:50.948024','2026-01-23 19:08:51.516773','fff171a8-cb0e-434d-aaef-163dc51e46db','key11','value11',18),('19','2026-01-23 19:08:49.855312','2026-01-23 19:08:51.093695','2026-01-23 19:08:51.516773','fff171a8-cb0e-434d-aaef-163dc51e46db','key12','value12',19),('20','2026-01-23 19:08:54.865450','2026-01-23 19:08:55.245348','2026-01-23 19:08:57.748750','aea27463-e745-4cdf-b933-f34265646329','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value',20),('21','2026-01-23 19:08:55.355254','2026-01-23 19:08:55.753788','2026-01-23 19:08:57.748750','aea27463-e745-4cdf-b933-f34265646329','key','vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv',21),('22','2026-01-23 19:08:55.792311','2026-01-23 19:08:56.162249','2026-01-23 19:08:57.748750','aea27463-e745-4cdf-b933-f34265646329','k','value',22),('23','2026-01-23 19:08:56.322921',NULL,'2026-01-23 19:08:57.748750','aea27463-e745-4cdf-b933-f34265646329','key','v',23);
/*!40000 ALTER TABLE `share_snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshots`
--

DROP TABLE IF EXISTS `share_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshots` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `share_id` varchar(36) NOT NULL,
  `size` int(11) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `share_size` int(11) DEFAULT NULL,
  `share_proto` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_id` (`share_id`),
  CONSTRAINT `share_snapshots_ibfk_1` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshots`
--

LOCK TABLES `share_snapshots` WRITE;
/*!40000 ALTER TABLE `share_snapshots` DISABLE KEYS */;
INSERT INTO `share_snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `share_id`, `size`, `display_name`, `display_description`, `share_size`, `share_proto`) VALUES ('2026-01-23 19:08:11.937129','2026-01-23 19:08:16.428157','2026-01-23 19:08:16.427741','05d8d6a4-f40b-47a0-9f79-f4489052a0d6','05d8d6a4-f40b-47a0-9f79-f4489052a0d6','06cf53b820e34c74b5ed6e38f590535c','b17f9a502db941108eaa44a3e9aa605c','d24254b0-53ec-4084-8545-391802f0a833',1,'tempest-tempest-created-share-snap-1591320748','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-23 19:02:40.456780','2026-01-23 19:03:05.518221','2026-01-23 19:03:05.517875','0d399fc2-1c4a-4fa4-a842-d2d9e4db8512','0d399fc2-1c4a-4fa4-a842-d2d9e4db8512','2caaa2bea59549f48039d35cd4c79c3d','8ea2dddd772b49f1b9e0a76f8a04e556','6f28e846-7b1c-4dec-80da-017ad13ed962',1,'tempest-tempest-snapshot-name-1066284282','tempest-tempest-snapshot-description-1943592773',1,'CEPHFS'),('2026-01-23 19:08:27.480850','2026-01-23 19:08:32.280175','2026-01-23 19:08:32.279508','0d41606b-3c6a-49d1-ae8f-8d8fc9ec2007','0d41606b-3c6a-49d1-ae8f-8d8fc9ec2007','06cf53b820e34c74b5ed6e38f590535c','b17f9a502db941108eaa44a3e9aa605c','d24254b0-53ec-4084-8545-391802f0a833',1,'tempest-tempest-created-share-snap-777618997','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-23 19:00:47.193261','2026-01-23 19:01:16.789333','2026-01-23 19:01:16.788796','1b7bb815-c96a-4c7f-8325-17c1098513a3','1b7bb815-c96a-4c7f-8325-17c1098513a3','c1c8384de14c4a31ae08ff4e69a1c9bb','dcb726ed64514381891686f89d347595','3bb50cf4-b86f-48ff-934d-15e15af9f620',1,'tempest-tempest-created-share-snap-322490927','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-23 19:07:32.579218','2026-01-23 19:07:33.368492','2026-01-23 19:07:33.368074','35716c41-5b72-46b0-b1fd-367179c86a72','35716c41-5b72-46b0-b1fd-367179c86a72','8263f588feb3441b90a14974c5c7dfcf','c65808ebd8034050a7f642ca129ed6de','1036c742-b7c8-4486-8595-4ecfc41b77f3',2,'tempest-tempest-created-share-snap-620689604','Tempest\'s snapshot',2,'CEPHFS'),('2026-01-23 19:08:54.088250','2026-01-23 19:08:59.062076','2026-01-23 19:08:59.061280','37fb13a4-3bbe-4617-bd83-2f119a82680c','37fb13a4-3bbe-4617-bd83-2f119a82680c','9387f9e13c974a7b9c7352ead07a670a','25ab22f3f2214f1685af23b1e9f04ebe','4c63b0d1-2bfd-41f1-a117-86a846be3efd',1,'tempest-tempest-new-name-for-snapshot-1398004983','tempest-tempest-new-description-for-snapshot-807604991',1,'CEPHFS'),('2026-01-23 19:08:19.486988','2026-01-23 19:08:24.324449','2026-01-23 19:08:24.324053','384e95a6-7587-4e64-943f-75b52be57cc0','384e95a6-7587-4e64-943f-75b52be57cc0','06cf53b820e34c74b5ed6e38f590535c','b17f9a502db941108eaa44a3e9aa605c','d24254b0-53ec-4084-8545-391802f0a833',1,'tempest-tempest-created-share-snap-1568057458','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-23 19:00:41.906842','2026-01-23 19:01:20.494856','2026-01-23 19:01:20.494375','40099f4c-64b9-4793-91a5-8cec06f6370d','40099f4c-64b9-4793-91a5-8cec06f6370d','c1c8384de14c4a31ae08ff4e69a1c9bb','dcb726ed64514381891686f89d347595','3bb50cf4-b86f-48ff-934d-15e15af9f620',1,'tempest-tempest-created-share-snap-1186135468','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-23 19:05:36.460402','2026-01-23 19:05:41.263403','2026-01-23 19:05:41.262914','41ef5335-9df1-41d2-a109-22ba85d3567b','41ef5335-9df1-41d2-a109-22ba85d3567b','0ee3b61db0254b40bc85214e7d348538','3fb8d4a8278546deacbbb6d960f5b0bb','8453ecac-20f9-422a-b1ad-2bd319766708',1,'tempest-tempest-created-share-snap-1324021110','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-23 19:03:05.779093','2026-01-23 19:03:11.263798','2026-01-23 19:03:11.263433','749ef186-fa39-4590-aae7-f85c11afac2a','749ef186-fa39-4590-aae7-f85c11afac2a','17ec91f691e54474893d8e435e589e7d','26ffaef7ee914dff8756a8885f9f07e2','5df7f392-10cf-4571-bdf9-06da47e30bbd',1,'tempest-tempest-created-share-snap-835368357','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-23 19:08:34.656172','2026-01-23 19:08:40.564106','2026-01-23 19:08:40.563698','7a9b1bc3-c5b4-4ffd-bcd5-79b532a504e0','7a9b1bc3-c5b4-4ffd-bcd5-79b532a504e0','06cf53b820e34c74b5ed6e38f590535c','b17f9a502db941108eaa44a3e9aa605c','d24254b0-53ec-4084-8545-391802f0a833',1,'tempest-tempest-created-share-snap-749090772','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-23 19:00:59.033987','2026-01-23 19:01:09.401685','2026-01-23 19:01:09.401183','7de60689-f2ab-45ae-8aa7-dd2bb230a472','7de60689-f2ab-45ae-8aa7-dd2bb230a472','c1c8384de14c4a31ae08ff4e69a1c9bb','dcb726ed64514381891686f89d347595','3bb50cf4-b86f-48ff-934d-15e15af9f620',1,'tempest-tempest-created-share-snap-339437462','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-23 19:07:45.769686','2026-01-23 19:07:50.522254','2026-01-23 19:07:50.521847','81df423a-af39-4393-a966-b0937dc73485','81df423a-af39-4393-a966-b0937dc73485','8263f588feb3441b90a14974c5c7dfcf','c65808ebd8034050a7f642ca129ed6de','91677b82-e607-4b55-bd2b-bf34898cc935',1,'tempest-tempest-created-share-snap-36131762','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-23 19:00:28.176353','2026-01-23 19:00:32.274980','2026-01-23 19:00:32.274464','88b13502-f510-4325-a8f5-797343db3fc5','88b13502-f510-4325-a8f5-797343db3fc5','c1c8384de14c4a31ae08ff4e69a1c9bb','dcb726ed64514381891686f89d347595','3bb50cf4-b86f-48ff-934d-15e15af9f620',1,'tempest-tempest-created-share-snap-1287984123','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-23 19:00:52.892756','2026-01-23 19:01:13.226294','2026-01-23 19:01:13.225724','9425dea3-7e92-4e57-96a9-0eeb8d61fea2','9425dea3-7e92-4e57-96a9-0eeb8d61fea2','c1c8384de14c4a31ae08ff4e69a1c9bb','dcb726ed64514381891686f89d347595','3bb50cf4-b86f-48ff-934d-15e15af9f620',1,'tempest-tempest-created-share-snap-1040876045','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-23 19:02:43.391304','2026-01-23 19:02:47.500806','2026-01-23 19:02:47.500428','a35127f8-9b81-4991-98e4-157cc93eee79','a35127f8-9b81-4991-98e4-157cc93eee79','aab37409764d412dbda1be20cc09c609','a9e6aa878c9c4cbaba399c1a4dd39ad1','7bca3129-9356-42c9-8b48-e6061ed16f01',1,'tempest-tempest-created-share-snap-2059391716','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-23 19:00:52.726330','2026-01-23 19:00:59.786649','2026-01-23 19:00:59.786266','ad76e9d3-bc9b-4f07-99a8-9c0edee4549e','ad76e9d3-bc9b-4f07-99a8-9c0edee4549e','558d317bd62542eb9fe7a15800c7d18f','7976ff17c3f840919d65487c1a87daad','b7e6ccd3-b475-4741-95bf-f79468206c11',1,'tempest-tempest-created-share-snap-1827700462','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-23 19:08:08.586548','2026-01-23 19:08:57.750398','2026-01-23 19:08:57.749903','aea27463-e745-4cdf-b933-f34265646329','aea27463-e745-4cdf-b933-f34265646329','06cf53b820e34c74b5ed6e38f590535c','b17f9a502db941108eaa44a3e9aa605c','d24254b0-53ec-4084-8545-391802f0a833',1,'tempest-tempest-snapshot-name-1906347137','tempest-tempest-snapshot-description-1494293792',1,'CEPHFS'),('2026-01-23 19:09:37.164222','2026-01-23 19:09:42.885909','2026-01-23 19:09:42.885500','b02922a0-ce94-4a9d-86c4-763307de222d','b02922a0-ce94-4a9d-86c4-763307de222d','a622f76c64c643c1904e54c2dde49e5a','07e698407b254151a7a1ba401f6bb52e','6e946115-7c50-4b74-844b-36e0e549695b',1,'tempest-tempest-snapshot-name-1620686522','tempest-tempest-snapshot-description-1807382106',1,'CEPHFS'),('2026-01-23 19:07:53.531198','2026-01-23 19:08:35.826203','2026-01-23 19:08:35.825738','c72bee12-7f03-4342-a0eb-04d39fa0a5a4','c72bee12-7f03-4342-a0eb-04d39fa0a5a4','3deb3c1777d64f18bc9de677a095431d','8548bd568a5448648a2e519eb3ab357a','1c640b45-4f70-4ab0-b31e-d65cb9f227fe',1,'tempest-tempest-snapshot-name-1478399957','tempest-tempest-snapshot-description-777697167',1,'CEPHFS'),('2026-01-23 19:06:09.569047','2026-01-23 19:06:59.403989','2026-01-23 19:06:59.403554','cdd68b8f-be76-4491-bcdc-990526be471f','cdd68b8f-be76-4491-bcdc-990526be471f','0ee3b61db0254b40bc85214e7d348538','3fb8d4a8278546deacbbb6d960f5b0bb','6ef51183-9eb7-460b-91d9-d5b9e76c3afd',1,'tempest-tempest-created-share-snap-1197218792','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-23 19:00:00.715107','2026-01-23 19:00:04.887059','2026-01-23 19:00:04.885225','d0fab392-1de9-468f-8ddd-0e8673bf9cea','d0fab392-1de9-468f-8ddd-0e8673bf9cea','d1d451d7e0e64bd3b447c74b97e73217','91991deea63743aea683dc7e4ded5161','84f80d8e-7753-43a3-b2e1-760b2497acf3',1,'tempest-tempest-created-share-snap-1607979840','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-23 19:01:31.734194','2026-01-23 19:01:49.975045','2026-01-23 19:01:49.974634','e321d9c3-2ef6-4719-b058-31b227661b87','e321d9c3-2ef6-4719-b058-31b227661b87','1efc60dfafb740f48a10184f26e16386','1490bc1cfa8e446280d7d1f208cdd9cc','ad431efc-4255-4370-895c-6ab531b1785e',1,'tempest-tempest-created-share-snap-853847547','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-23 19:00:46.039311','2026-01-23 19:01:04.124575','2026-01-23 19:01:04.123851','f6297e64-4bea-4cf5-a7c3-096c342cca94','f6297e64-4bea-4cf5-a7c3-096c342cca94','558d317bd62542eb9fe7a15800c7d18f','7976ff17c3f840919d65487c1a87daad','b7e6ccd3-b475-4741-95bf-f79468206c11',1,'tempest-tempest-created-share-snap-605352966','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-23 19:07:19.776258','2026-01-23 19:08:34.992431','2026-01-23 19:08:34.991945','f7119362-56c6-41a3-a825-295c8385d456','f7119362-56c6-41a3-a825-295c8385d456','77520b512b09481594399d1d447d3353','998a3a4c23934c4dafb2e2112ce1af90','d4df52fc-5514-4f2f-adf6-7e0a4fb0f9c6',1,'tempest-tempest-snapshot-name-1380054378','tempest-tempest-snapshot-description-493679902',1,'CEPHFS'),('2026-01-23 19:01:04.251299','2026-01-23 19:01:06.092940','2026-01-23 19:01:06.092463','fb3f4422-819c-4771-8d5d-1753533710d7','fb3f4422-819c-4771-8d5d-1753533710d7','c1c8384de14c4a31ae08ff4e69a1c9bb','dcb726ed64514381891686f89d347595','3bb50cf4-b86f-48ff-934d-15e15af9f620',1,'tempest-tempest-created-share-snap-1391576324','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-23 19:08:45.534392','2026-01-23 19:08:51.519498','2026-01-23 19:08:51.518763','fff171a8-cb0e-434d-aaef-163dc51e46db','fff171a8-cb0e-434d-aaef-163dc51e46db','06cf53b820e34c74b5ed6e38f590535c','b17f9a502db941108eaa44a3e9aa605c','d24254b0-53ec-4084-8545-391802f0a833',1,'tempest-tempest-created-share-snap-1283846295','Tempest\'s snapshot',1,'CEPHFS');
/*!40000 ALTER TABLE `share_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_type_extra_specs`
--

DROP TABLE IF EXISTS `share_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_type_extra_specs` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_type_id` varchar(36) NOT NULL,
  `spec_key` varchar(255) DEFAULT NULL,
  `spec_value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `st_id_fk` (`share_type_id`),
  CONSTRAINT `st_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=293 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_type_extra_specs`
--

LOCK TABLES `share_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `share_type_extra_specs` DISABLE KEYS */;
INSERT INTO `share_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_type_id`, `spec_key`, `spec_value`) VALUES ('2026-01-23 18:56:44.433799',NULL,NULL,0,1,'fe8a42c9-28ea-4c66-bed3-f2f6d12529fa','driver_handles_share_servers','False'),('2026-01-23 18:56:49.899167',NULL,NULL,0,2,'fe8a42c9-28ea-4c66-bed3-f2f6d12529fa','snapshot_support','True'),('2026-01-23 18:56:49.979162',NULL,NULL,0,3,'fe8a42c9-28ea-4c66-bed3-f2f6d12529fa','create_share_from_snapshot_support','True'),('2026-01-23 18:59:50.694559',NULL,'2026-01-23 19:01:27.947748',4,4,'38503086-e059-46cf-afc1-5c445beccdd6','driver_handles_share_servers','False'),('2026-01-23 18:59:50.694926',NULL,'2026-01-23 19:01:27.947748',5,5,'38503086-e059-46cf-afc1-5c445beccdd6','snapshot_support','True'),('2026-01-23 18:59:56.260067',NULL,'2026-01-23 19:00:08.082902',6,6,'66b39355-b59e-45ea-8a76-32ccea2cc4b3','driver_handles_share_servers','False'),('2026-01-23 18:59:56.694891',NULL,'2026-01-23 19:00:11.752720',7,7,'11eb753a-cfca-443f-8db2-def2cf1f0e7e','driver_handles_share_servers','False'),('2026-01-23 18:59:56.695392',NULL,'2026-01-23 19:00:11.752720',8,8,'11eb753a-cfca-443f-8db2-def2cf1f0e7e','snapshot_support','True'),('2026-01-23 19:00:11.709758',NULL,'2026-01-23 19:00:22.085700',9,9,'fd74222d-9aee-436c-9b35-942741042afa','driver_handles_share_servers','False'),('2026-01-23 19:00:17.675187',NULL,'2026-01-23 19:00:19.801035',10,10,'0ba2a8df-9160-42af-a8e7-be84b050ffe5','driver_handles_share_servers','False'),('2026-01-23 19:00:18.615866',NULL,'2026-01-23 19:00:18.820468',11,11,'570e2128-d9f0-410a-abba-3a293ba140a3','driver_handles_share_servers','False'),('2026-01-23 19:00:19.293851',NULL,'2026-01-23 19:00:19.632757',12,12,'cb9d8e25-10b5-4195-a8e2-ff14358c7b8c','driver_handles_share_servers','False'),('2026-01-23 19:00:23.140423',NULL,'2026-01-23 19:01:16.850674',13,13,'d20bdec5-e74c-4607-88bd-eca35cfd175e','driver_handles_share_servers','False'),('2026-01-23 19:00:23.140839',NULL,'2026-01-23 19:01:16.850674',14,14,'d20bdec5-e74c-4607-88bd-eca35cfd175e','snapshot_support','True'),('2026-01-23 19:00:23.141228',NULL,'2026-01-23 19:01:16.850674',15,15,'d20bdec5-e74c-4607-88bd-eca35cfd175e','create_share_from_snapshot_support','True'),('2026-01-23 19:00:23.296476',NULL,'2026-01-23 19:01:16.484247',16,16,'d6086e5f-4d59-4e21-9550-2e32e22fbdf6','driver_handles_share_servers','False'),('2026-01-23 19:00:23.404478',NULL,'2026-01-23 19:01:16.180915',17,17,'d9dd72be-5638-411d-adb4-977298762a87','driver_handles_share_servers','False'),('2026-01-23 19:00:34.084615',NULL,'2026-01-23 19:00:37.215439',18,18,'2fe49992-3c3b-4b9c-a2d7-cccc6feebc77','driver_handles_share_servers','False'),('2026-01-23 19:00:34.309736',NULL,'2026-01-23 19:00:37.059111',19,19,'1be2171c-172c-4827-9c2f-25e9cf6269b4','driver_handles_share_servers','False'),('2026-01-23 19:00:34.514513',NULL,'2026-01-23 19:00:36.896753',20,20,'a84c3c47-46dd-48bf-aabc-fc7e686073fd','driver_handles_share_servers','False'),('2026-01-23 19:00:34.666074',NULL,'2026-01-23 19:00:36.717054',21,21,'acddb3b9-1c01-40c4-bf2e-e4a5b099de5d','driver_handles_share_servers','False'),('2026-01-23 19:00:34.803896',NULL,'2026-01-23 19:00:36.529931',22,22,'4d1768a0-5258-4dfd-9934-ee372aaacb63','driver_handles_share_servers','False'),('2026-01-23 19:00:34.804286',NULL,'2026-01-23 19:00:36.529931',23,23,'4d1768a0-5258-4dfd-9934-ee372aaacb63','share_backend_name','tempest-fake_name-769543931'),('2026-01-23 19:00:35.258075',NULL,'2026-01-23 19:00:36.366379',24,24,'c7204dfa-a6eb-48e5-bdc0-83a5bf1eb95f','driver_handles_share_servers','False'),('2026-01-23 19:00:35.258674',NULL,'2026-01-23 19:00:36.366379',25,25,'c7204dfa-a6eb-48e5-bdc0-83a5bf1eb95f','share_backend_name','tempest-fake_name-1887808418'),('2026-01-23 19:00:35.593136',NULL,'2026-01-23 19:00:36.162875',26,26,'e87a072c-42d8-418d-8093-0ab15e422ea8','driver_handles_share_servers','False'),('2026-01-23 19:00:35.593535',NULL,'2026-01-23 19:00:36.162875',27,27,'e87a072c-42d8-418d-8093-0ab15e422ea8','share_backend_name','tempest-fake_name-1286909356'),('2026-01-23 19:00:35.855636',NULL,'2026-01-23 19:00:36.022058',28,28,'01535ae3-3812-4d38-a5a3-8103be9deab1','driver_handles_share_servers','False'),('2026-01-23 19:00:35.856673',NULL,'2026-01-23 19:00:36.022058',29,29,'01535ae3-3812-4d38-a5a3-8103be9deab1','share_backend_name','tempest-fake_name-1149069053'),('2026-01-23 19:00:40.768833',NULL,'2026-01-23 19:01:16.016054',30,30,'fe1ae4c1-4e7d-4e4f-a296-9dc3f02f66e4','driver_handles_share_servers','False'),('2026-01-23 19:00:41.957844',NULL,'2026-01-23 19:01:15.851965',31,31,'7d22c28a-bab0-4847-bdbf-5b1f68253190','driver_handles_share_servers','False'),('2026-01-23 19:00:42.063931',NULL,'2026-01-23 19:01:11.261087',32,32,'2a58a533-a0c8-400a-8e5d-7f96a5448c79','driver_handles_share_servers','False'),('2026-01-23 19:00:42.064336',NULL,'2026-01-23 19:01:11.261087',33,33,'2a58a533-a0c8-400a-8e5d-7f96a5448c79','snapshot_support','True'),('2026-01-23 19:00:43.900640',NULL,'2026-01-23 19:01:15.638804',34,34,'de31c409-0480-47b7-a09f-ba5b43c6081a','driver_handles_share_servers','False'),('2026-01-23 19:00:57.641366',NULL,'2026-01-23 19:01:13.617201',35,35,'71cf80fe-8ab2-49f3-8b42-dd4b205ff1ae','driver_handles_share_servers','False'),('2026-01-23 19:01:00.988475',NULL,'2026-01-23 19:01:13.171668',36,36,'b8db0a80-ec85-42c1-b292-cc539d8381ad','driver_handles_share_servers','False'),('2026-01-23 19:01:04.050321',NULL,'2026-01-23 19:01:12.578799',37,37,'e0e6fa64-95a6-4624-b32f-df2af84dc8d6','driver_handles_share_servers','False'),('2026-01-23 19:01:04.735841',NULL,'2026-01-23 19:01:12.208708',38,38,'dea7574c-f5d8-45d6-bb8e-5a8cf73f3f1f','driver_handles_share_servers','False'),('2026-01-23 19:01:10.905042',NULL,'2026-01-23 19:01:17.175844',39,39,'c52c18ef-2487-4fde-b7d9-fd5aafc38799','driver_handles_share_servers','False'),('2026-01-23 19:01:10.996120',NULL,'2026-01-23 19:01:11.075354',40,40,'c52c18ef-2487-4fde-b7d9-fd5aafc38799','key1','value1'),('2026-01-23 19:01:10.999976',NULL,'2026-01-23 19:01:17.175844',41,41,'c52c18ef-2487-4fde-b7d9-fd5aafc38799','key2','value2'),('2026-01-23 19:01:11.206213',NULL,'2026-01-23 19:01:16.740829',42,42,'6ecd5248-0c3f-466e-8a41-8005e30ebe1b','driver_handles_share_servers','False'),('2026-01-23 19:01:11.363021',NULL,'2026-01-23 19:01:16.740829',43,43,'6ecd5248-0c3f-466e-8a41-8005e30ebe1b','key1','value1'),('2026-01-23 19:01:11.365559',NULL,'2026-01-23 19:01:16.740829',44,44,'6ecd5248-0c3f-466e-8a41-8005e30ebe1b','key2','value2'),('2026-01-23 19:01:11.435369',NULL,'2026-01-23 19:01:11.562538',45,45,'6ecd5248-0c3f-466e-8a41-8005e30ebe1b','snapshot_support','True'),('2026-01-23 19:01:12.172233',NULL,'2026-01-23 19:01:16.529993',46,46,'cffd7404-fd76-4a0c-aea3-a94718f54750','driver_handles_share_servers','False'),('2026-01-23 19:01:12.504233',NULL,'2026-01-23 19:01:16.529993',47,47,'cffd7404-fd76-4a0c-aea3-a94718f54750','key1','value1'),('2026-01-23 19:01:12.509387',NULL,'2026-01-23 19:01:16.529993',48,48,'cffd7404-fd76-4a0c-aea3-a94718f54750','key2','value2'),('2026-01-23 19:01:12.793844',NULL,'2026-01-23 19:01:13.178353',49,49,'cffd7404-fd76-4a0c-aea3-a94718f54750','snapshot_support','True'),('2026-01-23 19:01:13.383951',NULL,'2026-01-23 19:01:16.366480',50,50,'29abad15-462c-458d-a066-6085cd6f7638','driver_handles_share_servers','False'),('2026-01-23 19:01:13.569697',NULL,'2026-01-23 19:01:16.366480',51,51,'29abad15-462c-458d-a066-6085cd6f7638','key1','value1'),('2026-01-23 19:01:13.573891','2026-01-23 19:01:14.248621','2026-01-23 19:01:16.366480',52,52,'29abad15-462c-458d-a066-6085cd6f7638','key2','value2_updated'),('2026-01-23 19:01:15.639799',NULL,'2026-01-23 19:01:16.033291',53,53,'45ed9847-8003-4899-9917-623b61033e5e','driver_handles_share_servers','False'),('2026-01-23 19:01:15.770099','2026-01-23 19:01:15.855741','2026-01-23 19:01:16.033291',54,54,'45ed9847-8003-4899-9917-623b61033e5e','key1','fake_value1_updated'),('2026-01-23 19:01:15.772080',NULL,'2026-01-23 19:01:16.033291',55,55,'45ed9847-8003-4899-9917-623b61033e5e','key2','value2'),('2026-01-23 19:01:21.340959',NULL,'2026-01-23 19:02:00.425313',56,56,'f4a6bef4-70c7-455a-897f-b3e9b5f4c268','driver_handles_share_servers','False'),('2026-01-23 19:01:25.004052',NULL,'2026-01-23 19:01:41.174130',57,57,'ab5e0ba6-2fa1-409f-bb67-c9bdb722d4f7','driver_handles_share_servers','False'),('2026-01-23 19:01:25.005749',NULL,'2026-01-23 19:01:41.174130',58,58,'ab5e0ba6-2fa1-409f-bb67-c9bdb722d4f7','key','value'),('2026-01-23 19:01:25.249298',NULL,'2026-01-23 19:01:40.862495',59,59,'4e7b7168-6b87-4a2a-80ab-5579719011ff','driver_handles_share_servers','False'),('2026-01-23 19:01:25.249929',NULL,'2026-01-23 19:01:40.862495',60,60,'4e7b7168-6b87-4a2a-80ab-5579719011ff','key','value'),('2026-01-23 19:01:25.469639',NULL,'2026-01-23 19:01:40.655363',61,61,'c8c1ab2d-4ba9-4e88-8a26-8d09a193d45d','driver_handles_share_servers','False'),('2026-01-23 19:01:25.470080',NULL,'2026-01-23 19:01:40.655363',62,62,'c8c1ab2d-4ba9-4e88-8a26-8d09a193d45d','key','value'),('2026-01-23 19:01:25.816133',NULL,'2026-01-23 19:01:56.604011',63,63,'88ad68ca-8786-477c-9b56-3373e78c4057','driver_handles_share_servers','False'),('2026-01-23 19:01:25.817622',NULL,'2026-01-23 19:01:56.604011',64,64,'88ad68ca-8786-477c-9b56-3373e78c4057','snapshot_support','True'),('2026-01-23 19:01:25.955101',NULL,'2026-01-23 19:01:40.225219',65,65,'294933d5-91fd-45b2-9141-9874618fb322','driver_handles_share_servers','False'),('2026-01-23 19:01:25.955577',NULL,'2026-01-23 19:01:40.225219',66,66,'294933d5-91fd-45b2-9141-9874618fb322','key','value'),('2026-01-23 19:01:27.817635',NULL,'2026-01-23 19:01:39.734349',67,67,'e5ca42ee-68c2-4b01-845b-39d2860931e6','driver_handles_share_servers','False'),('2026-01-23 19:01:27.818347',NULL,'2026-01-23 19:01:39.734349',68,68,'e5ca42ee-68c2-4b01-845b-39d2860931e6','key','value'),('2026-01-23 19:01:28.063646',NULL,'2026-01-23 19:01:39.591528',69,69,'02c710ee-7ae2-4e4e-ac73-759c228785e2','driver_handles_share_servers','False'),('2026-01-23 19:01:28.064712',NULL,'2026-01-23 19:01:39.591528',70,70,'02c710ee-7ae2-4e4e-ac73-759c228785e2','key','value'),('2026-01-23 19:01:28.239964',NULL,'2026-01-23 19:01:39.375316',71,71,'02c12a22-5427-4c6c-b87f-eb433f880af4','driver_handles_share_servers','False'),('2026-01-23 19:01:28.240495',NULL,'2026-01-23 19:01:39.375316',72,72,'02c12a22-5427-4c6c-b87f-eb433f880af4','key','value'),('2026-01-23 19:01:28.540177',NULL,'2026-01-23 19:01:39.158279',73,73,'4068c482-4cf6-4085-ab3b-5dc1cb0438d7','driver_handles_share_servers','False'),('2026-01-23 19:01:28.540619',NULL,'2026-01-23 19:01:39.158279',74,74,'4068c482-4cf6-4085-ab3b-5dc1cb0438d7','key','value'),('2026-01-23 19:01:28.955821',NULL,'2026-01-23 19:01:38.936770',75,75,'fd645f94-058c-4b60-86e9-e294c5e003f4','driver_handles_share_servers','False'),('2026-01-23 19:01:28.956594',NULL,'2026-01-23 19:01:38.936770',76,76,'fd645f94-058c-4b60-86e9-e294c5e003f4','key','value'),('2026-01-23 19:01:29.124378',NULL,'2026-01-23 19:01:38.782762',77,77,'57b4b2fc-5029-4e99-8770-34db65c4fa31','driver_handles_share_servers','False'),('2026-01-23 19:01:29.124888',NULL,'2026-01-23 19:01:38.782762',78,78,'57b4b2fc-5029-4e99-8770-34db65c4fa31','key','value'),('2026-01-23 19:01:29.575763',NULL,'2026-01-23 19:01:38.514109',79,79,'37209b8d-f339-444b-8945-9922b6ffd6e4','driver_handles_share_servers','False'),('2026-01-23 19:01:29.576203',NULL,'2026-01-23 19:01:38.514109',80,80,'37209b8d-f339-444b-8945-9922b6ffd6e4','key','value'),('2026-01-23 19:01:30.071829',NULL,'2026-01-23 19:01:38.290388',81,81,'e39ead33-5640-434e-a4aa-19a020aec979','driver_handles_share_servers','False'),('2026-01-23 19:01:30.072197',NULL,'2026-01-23 19:01:38.290388',82,82,'e39ead33-5640-434e-a4aa-19a020aec979','key','value'),('2026-01-23 19:01:30.423212',NULL,'2026-01-23 19:01:37.872099',83,83,'6c88bfb9-5179-4d63-8806-2e3ddc35dc3e','driver_handles_share_servers','False'),('2026-01-23 19:01:30.423620',NULL,'2026-01-23 19:01:37.872099',84,84,'6c88bfb9-5179-4d63-8806-2e3ddc35dc3e','key','value'),('2026-01-23 19:01:30.662445',NULL,'2026-01-23 19:01:37.679449',85,85,'c1072551-6657-414f-9f98-7cc14a9c82fe','driver_handles_share_servers','False'),('2026-01-23 19:01:30.662942',NULL,'2026-01-23 19:01:37.679449',86,86,'c1072551-6657-414f-9f98-7cc14a9c82fe','key','value'),('2026-01-23 19:01:31.017051',NULL,'2026-01-23 19:01:37.429600',87,87,'01d9fa86-c625-41a1-851e-dd567d5dd2ed','driver_handles_share_servers','False'),('2026-01-23 19:01:31.017458',NULL,'2026-01-23 19:01:37.429600',88,88,'01d9fa86-c625-41a1-851e-dd567d5dd2ed','key','value'),('2026-01-23 19:01:31.349774',NULL,'2026-01-23 19:01:37.143333',89,89,'1f94ccc4-fbaa-4aee-9f65-76736d2cb44a','driver_handles_share_servers','False'),('2026-01-23 19:01:31.350142',NULL,'2026-01-23 19:01:37.143333',90,90,'1f94ccc4-fbaa-4aee-9f65-76736d2cb44a','key','value'),('2026-01-23 19:01:31.610485',NULL,'2026-01-23 19:01:36.922645',91,91,'a0645fd5-1d7e-47f9-a253-aec212942112','driver_handles_share_servers','False'),('2026-01-23 19:01:31.611934',NULL,'2026-01-23 19:01:36.922645',92,92,'a0645fd5-1d7e-47f9-a253-aec212942112','key','value'),('2026-01-23 19:01:32.121178',NULL,'2026-01-23 19:01:36.782241',93,93,'0563c7fe-47a6-4233-8551-f91f36f41af9','driver_handles_share_servers','False'),('2026-01-23 19:01:32.121561',NULL,'2026-01-23 19:01:36.782241',94,94,'0563c7fe-47a6-4233-8551-f91f36f41af9','key','value'),('2026-01-23 19:01:32.380903',NULL,'2026-01-23 19:01:36.468860',95,95,'0aee96d0-3f89-49a2-9dad-967c11d75485','driver_handles_share_servers','False'),('2026-01-23 19:01:32.382035',NULL,'2026-01-23 19:01:36.468860',96,96,'0aee96d0-3f89-49a2-9dad-967c11d75485','key','value'),('2026-01-23 19:01:33.868539',NULL,'2026-01-23 19:01:36.013596',97,97,'d00cd00a-ca7d-4c00-ab4e-fcac37c54388','driver_handles_share_servers','False'),('2026-01-23 19:01:33.868888',NULL,'2026-01-23 19:01:36.013596',98,98,'d00cd00a-ca7d-4c00-ab4e-fcac37c54388','key','value'),('2026-01-23 19:01:34.203803',NULL,'2026-01-23 19:01:35.607663',99,99,'838ea691-05a8-4d8b-aaaa-cbc1b1269ff2','driver_handles_share_servers','False'),('2026-01-23 19:01:34.204143',NULL,'2026-01-23 19:01:35.607663',100,100,'838ea691-05a8-4d8b-aaaa-cbc1b1269ff2','key','value'),('2026-01-23 19:01:34.620180',NULL,'2026-01-23 19:01:35.357663',101,101,'6869453a-1ff7-4fb9-a53f-f52fa4f7b6bf','driver_handles_share_servers','False'),('2026-01-23 19:01:34.620721',NULL,'2026-01-23 19:01:35.357663',102,102,'6869453a-1ff7-4fb9-a53f-f52fa4f7b6bf','key','value'),('2026-01-23 19:01:37.413433',NULL,'2026-01-23 19:01:49.314020',103,103,'a5d4d2e7-d073-45e8-ba1a-57670b080d11','driver_handles_share_servers','False'),('2026-01-23 19:01:37.634860',NULL,'2026-01-23 19:01:49.072776',104,104,'11c35f20-bb21-4239-a222-efd96a84e0fe','driver_handles_share_servers','False'),('2026-01-23 19:01:37.842252',NULL,'2026-01-23 19:01:48.918961',105,105,'a7f6bdb1-0337-48dd-84aa-75fbaa03f9a9','driver_handles_share_servers','False'),('2026-01-23 19:01:39.385598',NULL,'2026-01-23 19:01:48.686592',106,106,'0cde3e5c-bf41-48bc-a11a-67335ece719f','driver_handles_share_servers','False'),('2026-01-23 19:01:39.540565',NULL,'2026-01-23 19:01:48.552364',107,107,'70146a41-2567-477f-98e4-d8ed61b13341','driver_handles_share_servers','False'),('2026-01-23 19:01:39.705788',NULL,'2026-01-23 19:01:48.038811',108,108,'bf221b07-5323-4a0c-b177-91f80c06a919','driver_handles_share_servers','False'),('2026-01-23 19:01:43.080388',NULL,'2026-01-23 19:01:47.892515',109,109,'d8f88b49-ed0e-4442-af6f-b572076f3ebe','driver_handles_share_servers','False'),('2026-01-23 19:01:43.372652',NULL,'2026-01-23 19:01:47.563566',110,110,'b70c6cfd-9144-4b1a-a024-d2fe9a1782c8','driver_handles_share_servers','False'),('2026-01-23 19:01:43.759755',NULL,'2026-01-23 19:02:52.841787',111,111,'2edae7de-0cac-41e9-8dee-a7f49a9c9caa','driver_handles_share_servers','False'),('2026-01-23 19:01:43.852650',NULL,'2026-01-23 19:01:47.347781',112,112,'29931267-3546-42b4-b9b9-ccd6accc390e','driver_handles_share_servers','False'),('2026-01-23 19:01:44.374662',NULL,'2026-01-23 19:01:47.182046',113,113,'c2d214e8-9edd-4d78-a60d-c0e7d1fdfbfc','driver_handles_share_servers','False'),('2026-01-23 19:01:45.575828',NULL,'2026-01-23 19:01:46.864300',114,114,'c12fedec-9263-4a38-9733-50cab2896f84','driver_handles_share_servers','False'),('2026-01-23 19:01:46.169024',NULL,'2026-01-23 19:01:46.666899',115,115,'bb2ee399-479f-4113-be34-76b82fcdfc5e','driver_handles_share_servers','False'),('2026-01-23 19:01:50.905076',NULL,'2026-01-23 19:01:59.159832',116,116,'09dbe7c6-481d-459a-98b0-2e78689c591b','driver_handles_share_servers','False'),('2026-01-23 19:01:51.272933',NULL,'2026-01-23 19:01:58.423358',117,117,'3c6be9a4-c34f-4d70-9659-317852304237','driver_handles_share_servers','False'),('2026-01-23 19:02:13.841626',NULL,'2026-01-23 19:03:06.417182',118,118,'5a7e3cee-6582-4736-9a7d-82a9c9a4db19','driver_handles_share_servers','False'),('2026-01-23 19:02:16.398545',NULL,'2026-01-23 19:02:33.628490',119,119,'c2e7b8e1-0b37-4bdc-b0cd-490536ec4c44','driver_handles_share_servers','False'),('2026-01-23 19:02:16.399118',NULL,'2026-01-23 19:02:33.628490',120,120,'c2e7b8e1-0b37-4bdc-b0cd-490536ec4c44','storage_protocol','cephfs'),('2026-01-23 19:02:16.510567',NULL,'2026-01-23 19:02:24.822482',121,121,'c45f2ba3-7d51-4245-94b8-6909ec45f40d','driver_handles_share_servers','False'),('2026-01-23 19:02:20.071591',NULL,'2026-01-23 19:02:29.951658',122,122,'a4d99fb4-0fbf-437d-ba1c-e9e0410214e6','driver_handles_share_servers','False'),('2026-01-23 19:02:20.072312',NULL,'2026-01-23 19:02:29.951658',123,123,'a4d99fb4-0fbf-437d-ba1c-e9e0410214e6','key','value'),('2026-01-23 19:02:20.735009',NULL,'2026-01-23 19:02:20.820619',124,124,'1b550314-8ab5-4058-80b6-dbd816bc8544','driver_handles_share_servers','False'),('2026-01-23 19:02:21.091778',NULL,'2026-01-23 19:02:29.624335',125,125,'bb61d7b1-db83-43bd-9008-302de44c0f6a','driver_handles_share_servers','False'),('2026-01-23 19:02:21.092264',NULL,'2026-01-23 19:02:29.624335',126,126,'bb61d7b1-db83-43bd-9008-302de44c0f6a','key','value'),('2026-01-23 19:02:21.092688',NULL,'2026-01-23 19:02:29.624335',127,127,'bb61d7b1-db83-43bd-9008-302de44c0f6a','snapshot_support','True'),('2026-01-23 19:02:21.208380',NULL,'2026-01-23 19:02:29.473125',128,128,'9d3355a2-448e-419a-a551-a0bae08ae486','driver_handles_share_servers','False'),('2026-01-23 19:02:21.208837',NULL,'2026-01-23 19:02:29.473125',129,129,'9d3355a2-448e-419a-a551-a0bae08ae486','key','value'),('2026-01-23 19:02:21.209197',NULL,'2026-01-23 19:02:29.473125',130,130,'9d3355a2-448e-419a-a551-a0bae08ae486','snapshot_support','True'),('2026-01-23 19:02:21.336209',NULL,'2026-01-23 19:02:29.301067',131,131,'7233f462-a966-41d0-a4d1-93e931579db5','driver_handles_share_servers','False'),('2026-01-23 19:02:21.337290',NULL,'2026-01-23 19:02:29.301067',132,132,'7233f462-a966-41d0-a4d1-93e931579db5','key','value'),('2026-01-23 19:02:21.337825',NULL,'2026-01-23 19:02:29.301067',133,133,'7233f462-a966-41d0-a4d1-93e931579db5','snapshot_support','True'),('2026-01-23 19:02:21.460459',NULL,'2026-01-23 19:02:29.069910',134,134,'25801be5-eb5d-4b6e-8460-46106918df30','driver_handles_share_servers','False'),('2026-01-23 19:02:21.460814',NULL,'2026-01-23 19:02:29.069910',135,135,'25801be5-eb5d-4b6e-8460-46106918df30','key','value'),('2026-01-23 19:02:21.594226',NULL,'2026-01-23 19:02:28.894506',136,136,'c5feba7d-f5b8-4aa4-b246-f54d5789d63d','driver_handles_share_servers','False'),('2026-01-23 19:02:21.594590',NULL,'2026-01-23 19:02:28.894506',137,137,'c5feba7d-f5b8-4aa4-b246-f54d5789d63d','key','value'),('2026-01-23 19:02:21.725336',NULL,'2026-01-23 19:02:28.404735',138,138,'72e8df1c-0e23-411b-8dc7-b9e5bee6a50d','driver_handles_share_servers','False'),('2026-01-23 19:02:21.726200',NULL,'2026-01-23 19:02:28.404735',139,139,'72e8df1c-0e23-411b-8dc7-b9e5bee6a50d','snapshot_support','True'),('2026-01-23 19:02:21.853240',NULL,'2026-01-23 19:02:28.190375',140,140,'c73250e8-8acb-483e-867c-3220b05d9c0c','driver_handles_share_servers','False'),('2026-01-23 19:02:21.853788',NULL,'2026-01-23 19:02:28.190375',141,141,'c73250e8-8acb-483e-867c-3220b05d9c0c','snapshot_support','True'),('2026-01-23 19:02:21.972788',NULL,'2026-01-23 19:02:28.056149',142,142,'72211383-6f50-4575-b26e-bb81dc49e3b8','driver_handles_share_servers','False'),('2026-01-23 19:02:21.973270',NULL,'2026-01-23 19:02:28.056149',143,143,'72211383-6f50-4575-b26e-bb81dc49e3b8','snapshot_support','True'),('2026-01-23 19:02:22.124265',NULL,'2026-01-23 19:02:27.834866',144,144,'089de6c8-43a9-4fa7-ae7a-a7148e7cc379','driver_handles_share_servers','False'),('2026-01-23 19:02:22.244612',NULL,'2026-01-23 19:02:27.693777',145,145,'ee80c2be-8f68-4b04-a213-b7cd17c249cf','driver_handles_share_servers','False'),('2026-01-23 19:02:22.602004',NULL,'2026-01-23 19:02:27.544989',146,146,'4a6b46f1-83fc-4b7a-8799-ed929c616159','driver_handles_share_servers','False'),('2026-01-23 19:02:22.806701',NULL,'2026-01-23 19:02:27.348464',147,147,'18503586-4909-4378-85c8-f30e1412b637','driver_handles_share_servers','False'),('2026-01-23 19:02:23.003771',NULL,'2026-01-23 19:02:27.216252',148,148,'a0072387-63b6-4177-b92b-2b80369f9240','driver_handles_share_servers','False'),('2026-01-23 19:02:23.193998',NULL,'2026-01-23 19:02:27.101566',149,149,'7415a844-4e37-40e4-ba79-763108f46aa2','driver_handles_share_servers','False'),('2026-01-23 19:02:23.194512',NULL,'2026-01-23 19:02:27.101566',150,150,'7415a844-4e37-40e4-ba79-763108f46aa2','key','value'),('2026-01-23 19:02:23.372328',NULL,'2026-01-23 19:02:26.928944',151,151,'2590b43a-7c68-428e-a9e7-7663ba88a470','driver_handles_share_servers','False'),('2026-01-23 19:02:23.372749',NULL,'2026-01-23 19:02:26.928944',152,152,'2590b43a-7c68-428e-a9e7-7663ba88a470','key','value'),('2026-01-23 19:02:23.510622',NULL,'2026-01-23 19:02:26.794704',153,153,'2745fe16-3d4c-4889-a0b1-8bb3a28cf4c2','driver_handles_share_servers','False'),('2026-01-23 19:02:23.510999',NULL,'2026-01-23 19:02:26.794704',154,154,'2745fe16-3d4c-4889-a0b1-8bb3a28cf4c2','key','value'),('2026-01-23 19:02:23.656831',NULL,'2026-01-23 19:02:26.639316',155,155,'675a9256-f4e6-4d3b-85a8-73873754a6e7','driver_handles_share_servers','False'),('2026-01-23 19:02:23.657246',NULL,'2026-01-23 19:02:26.639316',156,156,'675a9256-f4e6-4d3b-85a8-73873754a6e7','key','value'),('2026-01-23 19:02:23.774270',NULL,'2026-01-23 19:02:26.518820',157,157,'8b9fb549-5b3f-460f-92e6-81bf79bcf119','driver_handles_share_servers','False'),('2026-01-23 19:02:23.774679',NULL,'2026-01-23 19:02:26.518820',158,158,'8b9fb549-5b3f-460f-92e6-81bf79bcf119','key','value'),('2026-01-23 19:02:23.900638',NULL,'2026-01-23 19:02:26.393771',159,159,'200726d1-abe6-42b0-90a5-86109188403e','driver_handles_share_servers','False'),('2026-01-23 19:02:23.901078',NULL,'2026-01-23 19:02:26.393771',160,160,'200726d1-abe6-42b0-90a5-86109188403e','key','value'),('2026-01-23 19:02:24.013175',NULL,'2026-01-23 19:02:26.276518',161,161,'8af9324a-792a-4c3c-ae66-d999a4f7cbd9','driver_handles_share_servers','False'),('2026-01-23 19:02:24.013587',NULL,'2026-01-23 19:02:26.276518',162,162,'8af9324a-792a-4c3c-ae66-d999a4f7cbd9','key','value'),('2026-01-23 19:02:24.151051',NULL,'2026-01-23 19:02:26.051195',163,163,'44a35c45-53bc-4c40-9cd5-0325356b198b','driver_handles_share_servers','False'),('2026-01-23 19:02:24.151953',NULL,'2026-01-23 19:02:26.051195',164,164,'44a35c45-53bc-4c40-9cd5-0325356b198b','key','value'),('2026-01-23 19:02:24.428357',NULL,'2026-01-23 19:02:25.916760',165,165,'71f68e1f-566a-4085-8ac1-ee7949ddd9e3','driver_handles_share_servers','False'),('2026-01-23 19:02:24.428890',NULL,'2026-01-23 19:02:25.916760',166,166,'71f68e1f-566a-4085-8ac1-ee7949ddd9e3','key','value'),('2026-01-23 19:02:24.756469',NULL,'2026-01-23 19:02:25.771278',167,167,'912e9ac5-b808-494d-85a4-82011bad3c89','driver_handles_share_servers','False'),('2026-01-23 19:02:24.756878',NULL,'2026-01-23 19:02:25.771278',168,168,'912e9ac5-b808-494d-85a4-82011bad3c89','key','value'),('2026-01-23 19:02:24.965612',NULL,'2026-01-23 19:02:25.600433',169,169,'0193aa8d-7571-455c-8b0d-a2950002fec3','driver_handles_share_servers','False'),('2026-01-23 19:02:24.966603',NULL,'2026-01-23 19:02:25.600433',170,170,'0193aa8d-7571-455c-8b0d-a2950002fec3','key','value'),('2026-01-23 19:02:25.238916',NULL,'2026-01-23 19:02:25.450079',171,171,'f74130ae-ed68-4b2d-a06a-4dad17a6481f','driver_handles_share_servers','False'),('2026-01-23 19:02:25.239393',NULL,'2026-01-23 19:02:25.450079',172,172,'f74130ae-ed68-4b2d-a06a-4dad17a6481f','key','value'),('2026-01-23 19:02:36.736461',NULL,'2026-01-23 19:03:12.046613',173,173,'9d723286-feb8-4b59-ba94-db1ea3aa7f91','driver_handles_share_servers','False'),('2026-01-23 19:02:36.736938',NULL,'2026-01-23 19:03:12.046613',174,174,'9d723286-feb8-4b59-ba94-db1ea3aa7f91','storage_protocol','cephfs'),('2026-01-23 19:02:36.737326',NULL,'2026-01-23 19:03:12.046613',175,175,'9d723286-feb8-4b59-ba94-db1ea3aa7f91','snapshot_support','True'),('2026-01-23 19:02:36.737778',NULL,'2026-01-23 19:03:12.046613',176,176,'9d723286-feb8-4b59-ba94-db1ea3aa7f91','create_share_from_snapshot_support','True'),('2026-01-23 19:02:39.886923',NULL,'2026-01-23 19:02:53.902500',177,177,'bdb8bf7b-3c8f-4c28-b5d9-d9a31db95eaa','driver_handles_share_servers','False'),('2026-01-23 19:02:39.887321',NULL,'2026-01-23 19:02:53.902500',178,178,'bdb8bf7b-3c8f-4c28-b5d9-d9a31db95eaa','snapshot_support','True'),('2026-01-23 19:03:00.233273',NULL,'2026-01-23 19:03:00.582062',179,179,'34423574-3a1e-43b4-94ab-7cec3c572ca2','driver_handles_share_servers','False'),('2026-01-23 19:03:00.399423',NULL,'2026-01-23 19:03:00.582062',180,180,'34423574-3a1e-43b4-94ab-7cec3c572ca2','key1','value1'),('2026-01-23 19:03:00.404279',NULL,'2026-01-23 19:03:00.582062',181,181,'34423574-3a1e-43b4-94ab-7cec3c572ca2','key2','value2'),('2026-01-23 19:03:01.913219',NULL,'2026-01-23 19:03:15.325355',182,182,'5970bbf1-902e-4fec-a95f-9ecee5bbb631','driver_handles_share_servers','False'),('2026-01-23 19:03:01.915535',NULL,'2026-01-23 19:03:15.325355',183,183,'5970bbf1-902e-4fec-a95f-9ecee5bbb631','snapshot_support','True'),('2026-01-23 19:03:08.250667',NULL,'2026-01-23 19:03:10.563019',184,184,'29155a5d-3f9f-41b5-aa99-b31d0a041aa6','driver_handles_share_servers','False'),('2026-01-23 19:03:08.251077',NULL,'2026-01-23 19:03:10.563019',185,185,'29155a5d-3f9f-41b5-aa99-b31d0a041aa6','key','value'),('2026-01-23 19:03:08.712799',NULL,'2026-01-23 19:03:10.428948',186,186,'194ec277-d85a-4796-8f50-3ac073a467f7','driver_handles_share_servers','False'),('2026-01-23 19:03:09.268896',NULL,'2026-01-23 19:03:10.246963',187,187,'2838eb7c-97d6-47b8-baba-2e71138dd7bc','driver_handles_share_servers','False'),('2026-01-23 19:03:09.269306',NULL,'2026-01-23 19:03:10.246963',188,188,'2838eb7c-97d6-47b8-baba-2e71138dd7bc','key','value'),('2026-01-23 19:03:09.501853',NULL,'2026-01-23 19:03:10.123542',189,189,'3bbc27ef-11af-483f-9431-5fa0928bcd72','driver_handles_share_servers','False'),('2026-01-23 19:03:09.502316',NULL,'2026-01-23 19:03:10.123542',190,190,'3bbc27ef-11af-483f-9431-5fa0928bcd72','key','value'),('2026-01-23 19:03:19.340014',NULL,NULL,0,191,'1cd0aa0c-256d-4747-b5c6-735c1e4e32e0','driver_handles_share_servers','False'),('2026-01-23 19:03:21.903832',NULL,'2026-01-23 19:03:43.906778',192,192,'7362d9e0-868c-4044-a9a6-eed78870ee61','driver_handles_share_servers','False'),('2026-01-23 19:03:21.904204',NULL,'2026-01-23 19:03:43.906778',193,193,'7362d9e0-868c-4044-a9a6-eed78870ee61','vendor_name','foobar'),('2026-01-23 19:03:24.453103',NULL,'2026-01-23 19:04:06.407206',194,194,'7902365b-5660-46c8-997e-208dd53ae844','driver_handles_share_servers','False'),('2026-01-23 19:03:24.453712',NULL,'2026-01-23 19:04:06.407206',195,195,'7902365b-5660-46c8-997e-208dd53ae844','vendor_name','foobar'),('2026-01-23 19:03:26.326102',NULL,'2026-01-23 19:03:43.755939',196,196,'5bd00120-9b60-4196-9d38-c1e025658518','driver_handles_share_servers','False'),('2026-01-23 19:03:26.326496',NULL,'2026-01-23 19:03:43.755939',197,197,'5bd00120-9b60-4196-9d38-c1e025658518','vendor_name','foobar'),('2026-01-23 19:03:27.936737',NULL,'2026-01-23 19:03:30.351465',198,198,'19d5d84a-edfa-486d-8d52-1fcf138606da','driver_handles_share_servers','False'),('2026-01-23 19:03:28.452942',NULL,'2026-01-23 19:04:05.912930',199,199,'241a7152-12d1-48bb-b5c7-291a074f5b66','driver_handles_share_servers','False'),('2026-01-23 19:03:28.453369',NULL,'2026-01-23 19:04:05.912930',200,200,'241a7152-12d1-48bb-b5c7-291a074f5b66','vendor_name','foobar'),('2026-01-23 19:03:30.182362',NULL,'2026-01-23 19:03:43.615136',201,201,'c19ff7fa-2a85-4740-abc5-3c03e603c222','driver_handles_share_servers','False'),('2026-01-23 19:03:30.182881',NULL,'2026-01-23 19:03:43.615136',202,202,'c19ff7fa-2a85-4740-abc5-3c03e603c222','vendor_name','foobar'),('2026-01-23 19:03:32.287298',NULL,'2026-01-23 19:04:05.777947',203,203,'8a953b9f-99f3-477f-8f8b-a85b076a7406','driver_handles_share_servers','False'),('2026-01-23 19:03:32.287685',NULL,'2026-01-23 19:04:05.777947',204,204,'8a953b9f-99f3-477f-8f8b-a85b076a7406','vendor_name','foobar'),('2026-01-23 19:03:34.449671',NULL,'2026-01-23 19:03:43.474635',205,205,'bccb681a-3222-4edc-857a-aaeddd11ad78','driver_handles_share_servers','False'),('2026-01-23 19:03:34.450952',NULL,'2026-01-23 19:03:43.474635',206,206,'bccb681a-3222-4edc-857a-aaeddd11ad78','vendor_name','foobar'),('2026-01-23 19:03:35.935934',NULL,'2026-01-23 19:04:05.575682',207,207,'7f7e6a30-a2c4-443f-a0c5-e0dfdb57d9d3','driver_handles_share_servers','False'),('2026-01-23 19:03:35.936295',NULL,'2026-01-23 19:04:05.575682',208,208,'7f7e6a30-a2c4-443f-a0c5-e0dfdb57d9d3','vendor_name','foobar'),('2026-01-23 19:03:38.461899',NULL,'2026-01-23 19:03:43.186600',209,209,'e14aad06-9466-486c-bc63-26592e0cdf52','driver_handles_share_servers','False'),('2026-01-23 19:03:38.462375',NULL,'2026-01-23 19:03:43.186600',210,210,'e14aad06-9466-486c-bc63-26592e0cdf52','vendor_name','foobar'),('2026-01-23 19:03:40.543400',NULL,'2026-01-23 19:04:11.181996',211,211,'d4340069-92a0-40b1-9a2d-4931749a22be','driver_handles_share_servers','False'),('2026-01-23 19:03:40.549387',NULL,'2026-01-23 19:04:05.243464',212,212,'25eb52ab-ed01-4f19-94db-7202aa609ac2','driver_handles_share_servers','False'),('2026-01-23 19:03:40.553006',NULL,'2026-01-23 19:04:05.243464',213,213,'25eb52ab-ed01-4f19-94db-7202aa609ac2','vendor_name','foobar'),('2026-01-23 19:03:44.052856',NULL,'2026-01-23 19:04:05.113085',214,214,'1b656fe8-9e38-4e1f-8896-27918147c270','driver_handles_share_servers','False'),('2026-01-23 19:03:44.053353',NULL,'2026-01-23 19:04:05.113085',215,215,'1b656fe8-9e38-4e1f-8896-27918147c270','vendor_name','foobar'),('2026-01-23 19:03:47.742156',NULL,'2026-01-23 19:04:04.957778',216,216,'0cc522bc-772d-444b-91ef-721acf2d84b1','driver_handles_share_servers','False'),('2026-01-23 19:03:47.742548',NULL,'2026-01-23 19:04:04.957778',217,217,'0cc522bc-772d-444b-91ef-721acf2d84b1','vendor_name','foobar'),('2026-01-23 19:03:52.065942',NULL,'2026-01-23 19:04:22.972302',218,218,'fc3dea75-7a38-41a5-9a53-1370369a0c3e','driver_handles_share_servers','False'),('2026-01-23 19:03:52.295498',NULL,'2026-01-23 19:04:04.785750',219,219,'e9d1bb70-adca-4093-9b6e-5c2f0f61fbea','driver_handles_share_servers','False'),('2026-01-23 19:03:52.298439',NULL,'2026-01-23 19:04:04.785750',220,220,'e9d1bb70-adca-4093-9b6e-5c2f0f61fbea','vendor_name','foobar'),('2026-01-23 19:03:55.743222',NULL,'2026-01-23 19:04:04.622643',221,221,'91c26460-9fbd-4287-97cf-8d78828587a3','driver_handles_share_servers','False'),('2026-01-23 19:03:55.743669',NULL,'2026-01-23 19:04:04.622643',222,222,'91c26460-9fbd-4287-97cf-8d78828587a3','vendor_name','foobar'),('2026-01-23 19:04:00.454490',NULL,'2026-01-23 19:04:04.473610',223,223,'b1e1b985-0ef4-4803-84b5-18474a1939bf','driver_handles_share_servers','False'),('2026-01-23 19:04:00.454863',NULL,'2026-01-23 19:04:04.473610',224,224,'b1e1b985-0ef4-4803-84b5-18474a1939bf','vendor_name','foobar'),('2026-01-23 19:04:22.138542',NULL,'2026-01-23 19:04:48.084050',225,225,'d7fe3112-4905-44e0-a7a6-b013dde8491c','driver_handles_share_servers','False'),('2026-01-23 19:04:28.557825',NULL,'2026-01-23 19:05:23.707645',226,226,'21de215f-d5bc-482a-9a75-67ea712434b1','driver_handles_share_servers','False'),('2026-01-23 19:04:28.989162',NULL,'2026-01-23 19:04:29.134624',227,227,'bb5a20c8-3d55-4595-9f1a-2ec799a582e6','driver_handles_share_servers','False'),('2026-01-23 19:04:28.990000',NULL,'2026-01-23 19:04:29.134624',228,228,'bb5a20c8-3d55-4595-9f1a-2ec799a582e6','availability_zones','az1,az2,az 3'),('2026-01-23 19:04:29.310857',NULL,'2026-01-23 19:04:29.444030',229,229,'da138aad-482b-4f1c-bef3-50fe4655e1a5','driver_handles_share_servers','False'),('2026-01-23 19:04:29.311801',NULL,'2026-01-23 19:04:29.444030',230,230,'da138aad-482b-4f1c-bef3-50fe4655e1a5','availability_zones','az1,az2,az 3'),('2026-01-23 19:04:30.014100',NULL,'2026-01-23 19:04:30.464258',231,231,'bf025c70-0375-4e9b-ac55-0aad11277999','driver_handles_share_servers','False'),('2026-01-23 19:04:30.014534',NULL,'2026-01-23 19:04:30.464258',232,232,'bf025c70-0375-4e9b-ac55-0aad11277999','availability_zones','az1,az2,az 3'),('2026-01-23 19:04:30.791020',NULL,'2026-01-23 19:04:31.203892',233,233,'5636a757-eb14-4c6d-856b-6a34b8194e73','driver_handles_share_servers','False'),('2026-01-23 19:04:30.791546',NULL,'2026-01-23 19:04:31.203892',234,234,'5636a757-eb14-4c6d-856b-6a34b8194e73','availability_zones','az1,az2,az 3'),('2026-01-23 19:04:30.881364',NULL,'2026-01-23 19:04:31.045579',235,235,'0bc3268c-c454-441c-8439-12ff325621e6','driver_handles_share_servers','False'),('2026-01-23 19:04:31.347836',NULL,'2026-01-23 19:04:31.793643',236,236,'8bdc87ef-b1bf-4f1b-bea3-ce68b63425f7','driver_handles_share_servers','False'),('2026-01-23 19:04:31.348361',NULL,'2026-01-23 19:04:31.793643',237,237,'8bdc87ef-b1bf-4f1b-bea3-ce68b63425f7','availability_zones','az1,az2,az 3'),('2026-01-23 19:04:31.421040',NULL,'2026-01-23 19:04:31.629772',238,238,'8863da6b-a9f0-4f21-ae90-9b75466f7968','driver_handles_share_servers','False'),('2026-01-23 19:04:32.408331',NULL,'2026-01-23 19:04:32.876697',239,239,'dd482e1b-2f54-4d29-8a58-921721140e24','driver_handles_share_servers','False'),('2026-01-23 19:04:32.408965',NULL,'2026-01-23 19:04:32.876697',240,240,'dd482e1b-2f54-4d29-8a58-921721140e24','availability_zones','az1,az2,az 3'),('2026-01-23 19:04:32.568353',NULL,'2026-01-23 19:04:32.724178',241,241,'d578ab27-3645-491a-bb7e-2652716f36c8','driver_handles_share_servers','False'),('2026-01-23 19:04:33.005169',NULL,'2026-01-23 19:04:33.614856',242,242,'26fac589-138b-4667-bc8b-a8ef3d4fe177','driver_handles_share_servers','False'),('2026-01-23 19:04:33.005740',NULL,'2026-01-23 19:04:33.614856',243,243,'26fac589-138b-4667-bc8b-a8ef3d4fe177','availability_zones','az1,az2,az 3'),('2026-01-23 19:04:33.134330',NULL,'2026-01-23 19:04:33.448655',244,244,'758e7a6d-ee8b-4a1f-a781-b47c53691278','driver_handles_share_servers','False'),('2026-01-23 19:04:33.759391',NULL,'2026-01-23 19:04:34.367171',245,245,'ecfa30eb-5a32-4a5a-b521-c71e95e7fd4c','driver_handles_share_servers','False'),('2026-01-23 19:04:33.759846',NULL,'2026-01-23 19:04:34.367171',246,246,'ecfa30eb-5a32-4a5a-b521-c71e95e7fd4c','availability_zones','az1,az2,az 3'),('2026-01-23 19:04:33.836259',NULL,'2026-01-23 19:04:34.004853',247,247,'7de9f82d-eb24-4249-bddd-9eb84c0e45d9','driver_handles_share_servers','False'),('2026-01-23 19:04:34.579243',NULL,'2026-01-23 19:04:35.055612',248,248,'f7777b47-4e94-493d-b356-2e6931ee62ea','driver_handles_share_servers','False'),('2026-01-23 19:04:34.579622',NULL,'2026-01-23 19:04:35.055612',249,249,'f7777b47-4e94-493d-b356-2e6931ee62ea','availability_zones','az1,az2,az 3'),('2026-01-23 19:04:34.727776',NULL,'2026-01-23 19:04:34.886378',250,250,'6a6ab53f-8926-431b-8eb6-c935652e1b97','driver_handles_share_servers','False'),('2026-01-23 19:04:35.573306','2026-01-23 19:04:55.485705','2026-01-23 19:05:23.707645',251,251,'21de215f-d5bc-482a-9a75-67ea712434b1','availability_zones','nova'),('2026-01-23 19:04:51.889747',NULL,'2026-01-23 19:05:02.720200',252,252,'d75ba714-c404-43a1-a9ef-110a3d3d2fa3','driver_handles_share_servers','False'),('2026-01-23 19:05:12.250003',NULL,'2026-01-23 19:05:25.695301',253,253,'052aaa63-db71-4ec4-82dc-b5d1d435038b','driver_handles_share_servers','False'),('2026-01-23 19:05:13.700966',NULL,'2026-01-23 19:05:22.725118',254,254,'e2842727-9db2-48d3-8b3d-2a3115f7f601','driver_handles_share_servers','False'),('2026-01-23 19:05:32.566270',NULL,'2026-01-23 19:07:07.589172',255,255,'f57d6e7a-ef40-49d3-9e68-6fb5a008c4a4','driver_handles_share_servers','False'),('2026-01-23 19:05:32.656176',NULL,'2026-01-23 19:05:53.459173',256,256,'52b6d957-ef7a-4cb1-b863-d97f55c93c1a','driver_handles_share_servers','False'),('2026-01-23 19:05:32.656603',NULL,'2026-01-23 19:05:53.459173',257,257,'52b6d957-ef7a-4cb1-b863-d97f55c93c1a','snapshot_support','True'),('2026-01-23 19:05:34.321254',NULL,'2026-01-23 19:06:54.012039',258,258,'4b614781-282f-426a-a8da-c9980601f345','driver_handles_share_servers','False'),('2026-01-23 19:05:41.394009',NULL,'2026-01-23 19:05:45.715831',259,259,'29d64f6b-201c-4e1a-ba37-1b02e6f497e5','driver_handles_share_servers','False'),('2026-01-23 19:06:02.062767',NULL,'2026-01-23 19:07:06.236383',260,260,'a231ee93-b5f1-4fc4-a3d2-0055417021c0','driver_handles_share_servers','False'),('2026-01-23 19:06:02.063431',NULL,'2026-01-23 19:07:06.236383',261,261,'a231ee93-b5f1-4fc4-a3d2-0055417021c0','snapshot_support','True'),('2026-01-23 19:06:02.064370',NULL,'2026-01-23 19:07:06.236383',262,262,'a231ee93-b5f1-4fc4-a3d2-0055417021c0','create_share_from_snapshot_support','True'),('2026-01-23 19:06:07.412138',NULL,'2026-01-23 19:06:09.137230',263,263,'8be0a894-cda6-4db1-955b-76ab5f70d810','driver_handles_share_servers','False'),('2026-01-23 19:06:19.081501',NULL,'2026-01-23 19:06:20.338713',264,264,'c4f22e08-066f-4b0f-9188-4b8734ed06a1','driver_handles_share_servers','False'),('2026-01-23 19:06:26.484504',NULL,'2026-01-23 19:06:42.987144',265,265,'1339bb0a-ff5c-466e-9368-c1558d7331e6','driver_handles_share_servers','False'),('2026-01-23 19:07:09.563829',NULL,'2026-01-23 19:07:14.383036',266,266,'c5ad0898-14df-4398-97d5-7af7452c5183','driver_handles_share_servers','False'),('2026-01-23 19:07:13.913774',NULL,'2026-01-23 19:07:21.041059',267,267,'78465957-80d3-4b8a-b854-4da73f80a663','driver_handles_share_servers','False'),('2026-01-23 19:07:15.920481',NULL,'2026-01-23 19:08:41.593445',268,268,'58e5f12d-28d9-46d7-9f8a-fe63de5ccde0','driver_handles_share_servers','False'),('2026-01-23 19:07:15.920898',NULL,'2026-01-23 19:08:41.593445',269,269,'58e5f12d-28d9-46d7-9f8a-fe63de5ccde0','snapshot_support','True'),('2026-01-23 19:07:15.921274',NULL,'2026-01-23 19:08:41.593445',270,270,'58e5f12d-28d9-46d7-9f8a-fe63de5ccde0','create_share_from_snapshot_support','True'),('2026-01-23 19:07:24.849014',NULL,'2026-01-23 19:07:27.104202',271,271,'428c0ad2-9d3f-4b12-8023-52107603632f','driver_handles_share_servers','False'),('2026-01-23 19:07:25.454517','2026-01-23 19:07:25.853948','2026-01-23 19:07:27.104202',272,272,'428c0ad2-9d3f-4b12-8023-52107603632f','availability_zones','az_that_doesnt_exist'),('2026-01-23 19:07:25.585852',NULL,'2026-01-23 19:07:25.720044',273,273,'509f5254-8a30-4895-be5c-250a60d8f755','driver_handles_share_servers','False'),('2026-01-23 19:07:28.599142',NULL,'2026-01-23 19:07:56.938277',274,274,'a23d81ce-d5e1-43ae-b5f6-7a08ac609609','driver_handles_share_servers','False'),('2026-01-23 19:07:28.599502',NULL,'2026-01-23 19:07:56.938277',275,275,'a23d81ce-d5e1-43ae-b5f6-7a08ac609609','snapshot_support','True'),('2026-01-23 19:07:28.599809',NULL,'2026-01-23 19:07:56.938277',276,276,'a23d81ce-d5e1-43ae-b5f6-7a08ac609609','create_share_from_snapshot_support','True'),('2026-01-23 19:07:35.706316',NULL,'2026-01-23 19:07:37.778254',277,277,'f0532df6-4315-4c59-b021-d808b59838e1','driver_handles_share_servers','False'),('2026-01-23 19:07:35.819285',NULL,'2026-01-23 19:07:37.610677',278,278,'778b77df-c780-48d8-a231-aa35c7391981','driver_handles_share_servers','False'),('2026-01-23 19:07:49.639632',NULL,'2026-01-23 19:08:42.333970',279,279,'ae9b0b0a-11bb-4691-b72a-a62b561e3b36','driver_handles_share_servers','False'),('2026-01-23 19:07:49.639964',NULL,'2026-01-23 19:08:42.333970',280,280,'ae9b0b0a-11bb-4691-b72a-a62b561e3b36','snapshot_support','True'),('2026-01-23 19:08:05.018271',NULL,'2026-01-23 19:09:04.246657',281,281,'c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d','driver_handles_share_servers','False'),('2026-01-23 19:08:05.018632',NULL,'2026-01-23 19:09:04.246657',282,282,'c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d','snapshot_support','True'),('2026-01-23 19:08:05.018977',NULL,'2026-01-23 19:09:04.246657',283,283,'c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d','create_share_from_snapshot_support','True'),('2026-01-23 19:08:50.424727',NULL,'2026-01-23 19:09:05.873513',284,284,'9d06412d-874f-45c2-b39d-2192c8184009','driver_handles_share_servers','False'),('2026-01-23 19:08:50.425138',NULL,'2026-01-23 19:09:05.873513',285,285,'9d06412d-874f-45c2-b39d-2192c8184009','snapshot_support','True'),('2026-01-23 19:09:15.970649',NULL,'2026-01-23 19:09:18.892169',286,286,'93bf7be6-2778-498b-9d8b-e5fde7a68d78','driver_handles_share_servers','False'),('2026-01-23 19:09:16.086552',NULL,'2026-01-23 19:09:18.410884',287,287,'d03605c9-c2b7-4e26-ae5b-7e1725728f25','driver_handles_share_servers','False'),('2026-01-23 19:09:16.086971',NULL,'2026-01-23 19:09:18.410884',288,288,'d03605c9-c2b7-4e26-ae5b-7e1725728f25','provisioning:max_share_size','5'),('2026-01-23 19:09:16.087282',NULL,'2026-01-23 19:09:18.410884',289,289,'d03605c9-c2b7-4e26-ae5b-7e1725728f25','provisioning:min_share_size','2'),('2026-01-23 19:09:33.288524',NULL,'2026-01-23 19:09:49.352770',290,290,'7d583f94-a44a-47c6-b6fb-99c2483a84cb','driver_handles_share_servers','False'),('2026-01-23 19:09:33.289025',NULL,'2026-01-23 19:09:49.352770',291,291,'7d583f94-a44a-47c6-b6fb-99c2483a84cb','snapshot_support','True'),('2026-01-23 19:09:33.289504',NULL,'2026-01-23 19:09:49.352770',292,292,'7d583f94-a44a-47c6-b6fb-99c2483a84cb','create_share_from_snapshot_support','True');
/*!40000 ALTER TABLE `share_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_type_projects`
--

DROP TABLE IF EXISTS `share_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `stp_project_id_uc` (`share_type_id`,`project_id`,`deleted`),
  CONSTRAINT `stp_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_type_projects`
--

LOCK TABLES `share_type_projects` WRITE;
/*!40000 ALTER TABLE `share_type_projects` DISABLE KEYS */;
INSERT INTO `share_type_projects` (`id`, `created_at`, `updated_at`, `deleted_at`, `share_type_id`, `project_id`, `deleted`) VALUES (1,'2026-01-23 19:02:20.281534',NULL,'2026-01-23 19:02:20.530754','a4d99fb4-0fbf-437d-ba1c-e9e0410214e6','dcaebac10d574ce2aa3ba16906fd5dbc',1);
/*!40000 ALTER TABLE `share_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_types`
--

DROP TABLE IF EXISTS `share_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_types` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `st_name_uc` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_types`
--

LOCK TABLES `share_types` WRITE;
/*!40000 ALTER TABLE `share_types` DISABLE KEYS */;
INSERT INTO `share_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `is_public`, `description`) VALUES ('2026-01-23 19:00:35.854732',NULL,'2026-01-23 19:00:36.025738','01535ae3-3812-4d38-a5a3-8103be9deab1','01535ae3-3812-4d38-a5a3-8103be9deab1','tempest-unique_st_name-599962400',1,NULL),('2026-01-23 19:02:24.964688','2026-01-23 19:02:25.032190','2026-01-23 19:02:25.604206','0193aa8d-7571-455c-8b0d-a2950002fec3','0193aa8d-7571-455c-8b0d-a2950002fec3','tempest-tempest-manila-1226781420',1,NULL),('2026-01-23 19:01:31.016325',NULL,'2026-01-23 19:01:37.433030','01d9fa86-c625-41a1-851e-dd567d5dd2ed','01d9fa86-c625-41a1-851e-dd567d5dd2ed','tempest-typeshare-type-1945472513',1,NULL),('2026-01-23 19:01:28.238745',NULL,'2026-01-23 19:01:39.378334','02c12a22-5427-4c6c-b87f-eb433f880af4','02c12a22-5427-4c6c-b87f-eb433f880af4','tempest-typeshare-type-1839469745',1,NULL),('2026-01-23 19:01:28.062950',NULL,'2026-01-23 19:01:39.594341','02c710ee-7ae2-4e4e-ac73-759c228785e2','02c710ee-7ae2-4e4e-ac73-759c228785e2','tempest-typeshare-type-2064480127',1,NULL),('2026-01-23 19:05:12.248960',NULL,'2026-01-23 19:05:25.700208','052aaa63-db71-4ec4-82dc-b5d1d435038b','052aaa63-db71-4ec4-82dc-b5d1d435038b','tempest-typeshare-type-1267579467',1,NULL),('2026-01-23 19:01:32.120518',NULL,'2026-01-23 19:01:36.788059','0563c7fe-47a6-4233-8551-f91f36f41af9','0563c7fe-47a6-4233-8551-f91f36f41af9','tempest-typeshare-type-1066883413',1,NULL),('2026-01-23 19:02:22.123597',NULL,'2026-01-23 19:02:27.837195','089de6c8-43a9-4fa7-ae7a-a7148e7cc379','089de6c8-43a9-4fa7-ae7a-a7148e7cc379','tempest-tempest-manila-930076956',1,NULL),('2026-01-23 19:01:50.904360',NULL,'2026-01-23 19:01:59.161987','09dbe7c6-481d-459a-98b0-2e78689c591b','09dbe7c6-481d-459a-98b0-2e78689c591b','tempest-typeshare-type-1974244998',1,NULL),('2026-01-23 19:01:32.379737',NULL,'2026-01-23 19:01:36.471505','0aee96d0-3f89-49a2-9dad-967c11d75485','0aee96d0-3f89-49a2-9dad-967c11d75485','tempest-typeshare-type-391562004',1,NULL),('2026-01-23 19:00:17.674083',NULL,'2026-01-23 19:00:19.804274','0ba2a8df-9160-42af-a8e7-be84b050ffe5','0ba2a8df-9160-42af-a8e7-be84b050ffe5','tempest-typeshare-type-2089506333',1,NULL),('2026-01-23 19:04:30.879775',NULL,'2026-01-23 19:04:31.049283','0bc3268c-c454-441c-8439-12ff325621e6','0bc3268c-c454-441c-8439-12ff325621e6','tempest-support_any_az_share_type-330235807',1,NULL),('2026-01-23 19:03:47.741023',NULL,'2026-01-23 19:04:04.960097','0cc522bc-772d-444b-91ef-721acf2d84b1','0cc522bc-772d-444b-91ef-721acf2d84b1','tempest-share-type-187504380',1,NULL),('2026-01-23 19:01:39.384826',NULL,'2026-01-23 19:01:48.688530','0cde3e5c-bf41-48bc-a11a-67335ece719f','0cde3e5c-bf41-48bc-a11a-67335ece719f','tempest-typeshare-type-315307532',1,NULL),('2026-01-23 19:01:37.634102',NULL,'2026-01-23 19:01:49.074900','11c35f20-bb21-4239-a222-efd96a84e0fe','11c35f20-bb21-4239-a222-efd96a84e0fe','tempest-typeshare-type-1325562173',1,NULL),('2026-01-23 18:59:56.693695',NULL,'2026-01-23 19:00:11.757310','11eb753a-cfca-443f-8db2-def2cf1f0e7e','11eb753a-cfca-443f-8db2-def2cf1f0e7e','tempest-typeshare-type-457976058',1,NULL),('2026-01-23 19:06:26.483846',NULL,'2026-01-23 19:06:42.989499','1339bb0a-ff5c-466e-9368-c1558d7331e6','1339bb0a-ff5c-466e-9368-c1558d7331e6','tempest-typeshare-type-1129541606',1,NULL),('2026-01-23 19:02:22.805898',NULL,'2026-01-23 19:02:27.351155','18503586-4909-4378-85c8-f30e1412b637','18503586-4909-4378-85c8-f30e1412b637','tempest-tempest-manila-1307446086',1,NULL),('2026-01-23 19:03:08.712193',NULL,'2026-01-23 19:03:10.431354','194ec277-d85a-4796-8f50-3ac073a467f7','194ec277-d85a-4796-8f50-3ac073a467f7','tempest-share-type-1779336110',0,NULL),('2026-01-23 19:03:27.935693',NULL,'2026-01-23 19:03:30.355362','19d5d84a-edfa-486d-8d52-1fcf138606da','19d5d84a-edfa-486d-8d52-1fcf138606da','tempest-typeshare-type-660354417',1,NULL),('2026-01-23 19:02:20.734231',NULL,'2026-01-23 19:02:20.828149','1b550314-8ab5-4058-80b6-dbd816bc8544','1b550314-8ab5-4058-80b6-dbd816bc8544','tempest-tempest-manila-457039565',1,NULL),('2026-01-23 19:03:44.051965',NULL,'2026-01-23 19:04:05.115625','1b656fe8-9e38-4e1f-8896-27918147c270','1b656fe8-9e38-4e1f-8896-27918147c270','tempest-share-type-1564988592',1,NULL),('2026-01-23 19:00:34.308916',NULL,'2026-01-23 19:00:37.061944','1be2171c-172c-4827-9c2f-25e9cf6269b4','1be2171c-172c-4827-9c2f-25e9cf6269b4','tempest-typeshare-type-2063520138',1,NULL),('2026-01-23 19:03:19.339115',NULL,NULL,'False','1cd0aa0c-256d-4747-b5c6-735c1e4e32e0','tempest-typeshare-type-1112731008',1,NULL),('2026-01-23 19:01:31.349056',NULL,'2026-01-23 19:01:37.146499','1f94ccc4-fbaa-4aee-9f65-76736d2cb44a','1f94ccc4-fbaa-4aee-9f65-76736d2cb44a','tempest-typeshare-type-1127668061',1,NULL),('2026-01-23 19:02:23.899714','2026-01-23 19:02:23.959139','2026-01-23 19:02:26.395882','200726d1-abe6-42b0-90a5-86109188403e','200726d1-abe6-42b0-90a5-86109188403e','tempest-type_updated-280084778',1,'description_updated'),('2026-01-23 19:04:28.557082',NULL,'2026-01-23 19:05:23.711708','21de215f-d5bc-482a-9a75-67ea712434b1','21de215f-d5bc-482a-9a75-67ea712434b1','tempest-typeshare-type-414691449',1,NULL),('2026-01-23 19:03:28.452193',NULL,'2026-01-23 19:04:05.915494','241a7152-12d1-48bb-b5c7-291a074f5b66','241a7152-12d1-48bb-b5c7-291a074f5b66','tempest-share-type-901354310',1,NULL),('2026-01-23 19:02:21.459599',NULL,'2026-01-23 19:02:29.072844','25801be5-eb5d-4b6e-8460-46106918df30','25801be5-eb5d-4b6e-8460-46106918df30','tempest-tempest-manila-152532815',1,NULL),('2026-01-23 19:02:23.371672','2026-01-23 19:02:23.452749','2026-01-23 19:02:26.933854','2590b43a-7c68-428e-a9e7-7663ba88a470','2590b43a-7c68-428e-a9e7-7663ba88a470','tempest-type_updated-429793638',1,'Description for share type'),('2026-01-23 19:03:40.548771',NULL,'2026-01-23 19:04:05.245532','25eb52ab-ed01-4f19-94db-7202aa609ac2','25eb52ab-ed01-4f19-94db-7202aa609ac2','tempest-share-type-280915769',1,NULL),('2026-01-23 19:04:33.004501',NULL,'2026-01-23 19:04:33.617293','26fac589-138b-4667-bc8b-a8ef3d4fe177','26fac589-138b-4667-bc8b-a8ef3d4fe177','tempest-support_some_azs_share_type-587984485',1,NULL),('2026-01-23 19:02:23.509872','2026-01-23 19:02:23.579168','2026-01-23 19:02:26.799601','2745fe16-3d4c-4889-a0b1-8bb3a28cf4c2','2745fe16-3d4c-4889-a0b1-8bb3a28cf4c2','tempest-tempest-manila-1953342775',1,'description_updated'),('2026-01-23 19:03:09.268063',NULL,'2026-01-23 19:03:10.251604','2838eb7c-97d6-47b8-baba-2e71138dd7bc','2838eb7c-97d6-47b8-baba-2e71138dd7bc','tempest-typeshare-type-1552573847',1,NULL),('2026-01-23 19:03:08.249431',NULL,'2026-01-23 19:03:10.565547','29155a5d-3f9f-41b5-aa99-b31d0a041aa6','29155a5d-3f9f-41b5-aa99-b31d0a041aa6','tempest-typeshare-type-387570376',1,NULL),('2026-01-23 19:01:25.954133',NULL,'2026-01-23 19:01:40.227913','294933d5-91fd-45b2-9141-9874618fb322','294933d5-91fd-45b2-9141-9874618fb322','tempest-typeshare-type-727377536',1,NULL),('2026-01-23 19:01:43.851831',NULL,'2026-01-23 19:01:47.351202','29931267-3546-42b4-b9b9-ccd6accc390e','29931267-3546-42b4-b9b9-ccd6accc390e','tempest-typeshare-type-1380708930',1,NULL),('2026-01-23 19:01:13.382618',NULL,'2026-01-23 19:01:16.370149','29abad15-462c-458d-a066-6085cd6f7638','29abad15-462c-458d-a066-6085cd6f7638','tempest-share-type-855418768',1,NULL),('2026-01-23 19:05:41.393333',NULL,'2026-01-23 19:05:45.719832','29d64f6b-201c-4e1a-ba37-1b02e6f497e5','29d64f6b-201c-4e1a-ba37-1b02e6f497e5','tempest-typeshare-type-1436773012',1,NULL),('2026-01-23 19:00:42.062500',NULL,'2026-01-23 19:01:11.263169','2a58a533-a0c8-400a-8e5d-7f96a5448c79','2a58a533-a0c8-400a-8e5d-7f96a5448c79','tempest-typeshare-type-521374621',1,NULL),('2026-01-23 19:01:43.758925',NULL,'2026-01-23 19:02:52.843810','2edae7de-0cac-41e9-8dee-a7f49a9c9caa','2edae7de-0cac-41e9-8dee-a7f49a9c9caa','tempest-typeshare-type-1683691660',1,NULL),('2026-01-23 19:00:34.083747',NULL,'2026-01-23 19:00:37.218775','2fe49992-3c3b-4b9c-a2d7-cccc6feebc77','2fe49992-3c3b-4b9c-a2d7-cccc6feebc77','tempest-typeshare-type-1444791565',1,NULL),('2026-01-23 19:03:00.232466',NULL,'2026-01-23 19:03:00.584170','34423574-3a1e-43b4-94ab-7cec3c572ca2','34423574-3a1e-43b4-94ab-7cec3c572ca2','tempest-share-type-976127037',1,NULL),('2026-01-23 19:01:29.574982',NULL,'2026-01-23 19:01:38.518188','37209b8d-f339-444b-8945-9922b6ffd6e4','37209b8d-f339-444b-8945-9922b6ffd6e4','tempest-typeshare-type-719170464',1,NULL),('2026-01-23 18:59:50.693901',NULL,'2026-01-23 19:01:27.955656','38503086-e059-46cf-afc1-5c445beccdd6','38503086-e059-46cf-afc1-5c445beccdd6','tempest-typeshare-type-528995832',1,NULL),('2026-01-23 19:03:09.500684',NULL,'2026-01-23 19:03:10.126285','3bbc27ef-11af-483f-9431-5fa0928bcd72','3bbc27ef-11af-483f-9431-5fa0928bcd72','tempest-typeshare-type-1241505092',1,NULL),('2026-01-23 19:01:51.272090',NULL,'2026-01-23 19:01:58.425481','3c6be9a4-c34f-4d70-9659-317852304237','3c6be9a4-c34f-4d70-9659-317852304237','tempest-typeshare-type-1810335693',1,NULL),('2026-01-23 19:01:28.539048',NULL,'2026-01-23 19:01:39.160627','4068c482-4cf6-4085-ab3b-5dc1cb0438d7','4068c482-4cf6-4085-ab3b-5dc1cb0438d7','tempest-typeshare-type-1255108057',1,NULL),('2026-01-23 19:07:24.848033',NULL,'2026-01-23 19:07:27.107087','428c0ad2-9d3f-4b12-8023-52107603632f','428c0ad2-9d3f-4b12-8023-52107603632f','tempest-typeshare-type-2110238553',1,NULL),('2026-01-23 19:02:24.149868','2026-01-23 19:02:24.236612','2026-01-23 19:02:26.053821','44a35c45-53bc-4c40-9cd5-0325356b198b','44a35c45-53bc-4c40-9cd5-0325356b198b','tempest-tempest-manila-436102578',1,'description_updated'),('2026-01-23 19:01:15.638666',NULL,'2026-01-23 19:01:16.035845','45ed9847-8003-4899-9917-623b61033e5e','45ed9847-8003-4899-9917-623b61033e5e','tempest-share-type-998347302',1,NULL),('2026-01-23 19:02:22.600766',NULL,'2026-01-23 19:02:27.547422','4a6b46f1-83fc-4b7a-8799-ed929c616159','4a6b46f1-83fc-4b7a-8799-ed929c616159','tempest-tempest-manila-1741146928',1,NULL),('2026-01-23 19:05:34.320513',NULL,'2026-01-23 19:06:54.015129','4b614781-282f-426a-a8da-c9980601f345','4b614781-282f-426a-a8da-c9980601f345','tempest-typeshare-type-724868198',1,NULL),('2026-01-23 19:00:34.803156',NULL,'2026-01-23 19:00:36.532992','4d1768a0-5258-4dfd-9934-ee372aaacb63','4d1768a0-5258-4dfd-9934-ee372aaacb63','tempest-unique_st_name-757590164',1,NULL),('2026-01-23 19:01:25.247763',NULL,'2026-01-23 19:01:40.865498','4e7b7168-6b87-4a2a-80ab-5579719011ff','4e7b7168-6b87-4a2a-80ab-5579719011ff','tempest-typeshare-type-574829967',1,NULL),('2026-01-23 19:07:25.585179',NULL,'2026-01-23 19:07:25.722492','509f5254-8a30-4895-be5c-250a60d8f755','509f5254-8a30-4895-be5c-250a60d8f755','tempest-support_any_az_share_type-1680852064',1,NULL),('2026-01-23 19:05:32.655075',NULL,'2026-01-23 19:05:53.461801','52b6d957-ef7a-4cb1-b863-d97f55c93c1a','52b6d957-ef7a-4cb1-b863-d97f55c93c1a','tempest-typeshare-type-193059322',1,NULL),('2026-01-23 19:04:30.789841',NULL,'2026-01-23 19:04:31.206350','5636a757-eb14-4c6d-856b-6a34b8194e73','5636a757-eb14-4c6d-856b-6a34b8194e73','tempest-support_some_azs_share_type-371084232',1,NULL),('2026-01-23 19:00:18.614806',NULL,'2026-01-23 19:00:18.823102','570e2128-d9f0-410a-abba-3a293ba140a3','570e2128-d9f0-410a-abba-3a293ba140a3','tempest-tempest-manila-1613140331',1,NULL),('2026-01-23 19:01:29.123332',NULL,'2026-01-23 19:01:38.786003','57b4b2fc-5029-4e99-8770-34db65c4fa31','57b4b2fc-5029-4e99-8770-34db65c4fa31','tempest-typeshare-type-617910903',1,NULL),('2026-01-23 19:07:15.918382',NULL,'2026-01-23 19:08:41.596718','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0','58e5f12d-28d9-46d7-9f8a-fe63de5ccde0','tempest-typeshare-type-1121508818',1,NULL),('2026-01-23 19:03:01.912553',NULL,'2026-01-23 19:03:15.328338','5970bbf1-902e-4fec-a95f-9ecee5bbb631','5970bbf1-902e-4fec-a95f-9ecee5bbb631','tempest-typeshare-type-1409057838',1,NULL),('2026-01-23 19:02:13.840740',NULL,'2026-01-23 19:03:06.420761','5a7e3cee-6582-4736-9a7d-82a9c9a4db19','5a7e3cee-6582-4736-9a7d-82a9c9a4db19','tempest-typeshare-type-937116380',1,NULL),('2026-01-23 19:03:26.325377',NULL,'2026-01-23 19:03:43.758170','5bd00120-9b60-4196-9d38-c1e025658518','5bd00120-9b60-4196-9d38-c1e025658518','tempest-share-type-985841350',1,NULL),('2026-01-23 18:59:56.258878',NULL,'2026-01-23 19:00:08.086510','66b39355-b59e-45ea-8a76-32ccea2cc4b3','66b39355-b59e-45ea-8a76-32ccea2cc4b3','tempest-typeshare-type-2053696345',1,NULL),('2026-01-23 19:02:23.656054','2026-01-23 19:02:23.714159','2026-01-23 19:02:26.641898','675a9256-f4e6-4d3b-85a8-73873754a6e7','675a9256-f4e6-4d3b-85a8-73873754a6e7','tempest-tempest-manila-478638722',1,'Description for share type'),('2026-01-23 19:01:34.618489',NULL,'2026-01-23 19:01:35.359687','6869453a-1ff7-4fb9-a53f-f52fa4f7b6bf','6869453a-1ff7-4fb9-a53f-f52fa4f7b6bf','tempest-typeshare-type-362214303',1,NULL),('2026-01-23 19:04:34.726993',NULL,'2026-01-23 19:04:34.888534','6a6ab53f-8926-431b-8eb6-c935652e1b97','6a6ab53f-8926-431b-8eb6-c935652e1b97','tempest-support_any_az_share_type-1124340060',1,NULL),('2026-01-23 19:01:30.422004',NULL,'2026-01-23 19:01:37.875616','6c88bfb9-5179-4d63-8806-2e3ddc35dc3e','6c88bfb9-5179-4d63-8806-2e3ddc35dc3e','tempest-typeshare-type-1370264464',1,NULL),('2026-01-23 19:01:11.204217',NULL,'2026-01-23 19:01:16.743557','6ecd5248-0c3f-466e-8a41-8005e30ebe1b','6ecd5248-0c3f-466e-8a41-8005e30ebe1b','tempest-share-type-289530124',1,NULL),('2026-01-23 19:01:39.539343',NULL,'2026-01-23 19:01:48.556028','70146a41-2567-477f-98e4-d8ed61b13341','70146a41-2567-477f-98e4-d8ed61b13341','tempest-typeshare-type-146552238',1,NULL),('2026-01-23 19:00:57.640582',NULL,'2026-01-23 19:01:13.619918','71cf80fe-8ab2-49f3-8b42-dd4b205ff1ae','71cf80fe-8ab2-49f3-8b42-dd4b205ff1ae','tempest-typeshare-type-956869099',1,NULL),('2026-01-23 19:02:24.426282','2026-01-23 19:02:24.659194','2026-01-23 19:02:25.919118','71f68e1f-566a-4085-8ac1-ee7949ddd9e3','71f68e1f-566a-4085-8ac1-ee7949ddd9e3','tempest-tempest-manila-1321694226',1,'Description for share type'),('2026-01-23 19:02:21.971824',NULL,'2026-01-23 19:02:28.058543','72211383-6f50-4575-b26e-bb81dc49e3b8','72211383-6f50-4575-b26e-bb81dc49e3b8','tempest-tempest-manila-1034344676',1,NULL),('2026-01-23 19:02:21.334938',NULL,'2026-01-23 19:02:29.304553','7233f462-a966-41d0-a4d1-93e931579db5','7233f462-a966-41d0-a4d1-93e931579db5','tempest-tempest-manila-432601280',1,NULL),('2026-01-23 19:02:21.724399',NULL,'2026-01-23 19:02:28.406766','72e8df1c-0e23-411b-8dc7-b9e5bee6a50d','72e8df1c-0e23-411b-8dc7-b9e5bee6a50d','tempest-tempest-manila-1952350684',1,NULL),('2026-01-23 19:03:21.903105',NULL,'2026-01-23 19:03:43.910928','7362d9e0-868c-4044-a9a6-eed78870ee61','7362d9e0-868c-4044-a9a6-eed78870ee61','tempest-share-type-133766848',1,NULL),('2026-01-23 19:02:23.193173','2026-01-23 19:02:23.276735','2026-01-23 19:02:27.103979','7415a844-4e37-40e4-ba79-763108f46aa2','7415a844-4e37-40e4-ba79-763108f46aa2','tempest-type_updated-1301715463',1,'description_updated'),('2026-01-23 19:04:33.133580',NULL,'2026-01-23 19:04:33.452219','758e7a6d-ee8b-4a1f-a781-b47c53691278','758e7a6d-ee8b-4a1f-a781-b47c53691278','tempest-support_any_az_share_type-486013999',1,NULL),('2026-01-23 19:07:35.818402',NULL,'2026-01-23 19:07:37.613609','778b77df-c780-48d8-a231-aa35c7391981','778b77df-c780-48d8-a231-aa35c7391981','tempest-typeshare-type-1643301168',1,NULL),('2026-01-23 19:07:13.913072',NULL,'2026-01-23 19:07:21.044053','78465957-80d3-4b8a-b854-4da73f80a663','78465957-80d3-4b8a-b854-4da73f80a663','tempest-typeshare-type-170478906',1,NULL),('2026-01-23 19:03:24.452258',NULL,'2026-01-23 19:04:06.411323','7902365b-5660-46c8-997e-208dd53ae844','7902365b-5660-46c8-997e-208dd53ae844','tempest-share-type-135147374',1,NULL),('2026-01-23 19:00:41.957053',NULL,'2026-01-23 19:01:15.854056','7d22c28a-bab0-4847-bdbf-5b1f68253190','7d22c28a-bab0-4847-bdbf-5b1f68253190','tempest-typeshare-type-2123541833',0,NULL),('2026-01-23 19:09:33.287435',NULL,'2026-01-23 19:09:49.355681','7d583f94-a44a-47c6-b6fb-99c2483a84cb','7d583f94-a44a-47c6-b6fb-99c2483a84cb','tempest-typeshare-type-1726845902',1,NULL),('2026-01-23 19:04:33.834559',NULL,'2026-01-23 19:04:34.008640','7de9f82d-eb24-4249-bddd-9eb84c0e45d9','7de9f82d-eb24-4249-bddd-9eb84c0e45d9','tempest-support_any_az_share_type-2101383360',1,NULL),('2026-01-23 19:03:35.935286',NULL,'2026-01-23 19:04:05.578441','7f7e6a30-a2c4-443f-a0c5-e0dfdb57d9d3','7f7e6a30-a2c4-443f-a0c5-e0dfdb57d9d3','tempest-share-type-119623532',1,NULL),('2026-01-23 19:01:34.203064',NULL,'2026-01-23 19:01:35.610981','838ea691-05a8-4d8b-aaaa-cbc1b1269ff2','838ea691-05a8-4d8b-aaaa-cbc1b1269ff2','tempest-typeshare-type-128069524',1,NULL),('2026-01-23 19:04:31.420319',NULL,'2026-01-23 19:04:31.631755','8863da6b-a9f0-4f21-ae90-9b75466f7968','8863da6b-a9f0-4f21-ae90-9b75466f7968','tempest-support_any_az_share_type-495949881',1,NULL),('2026-01-23 19:01:25.815208',NULL,'2026-01-23 19:01:56.606860','88ad68ca-8786-477c-9b56-3373e78c4057','88ad68ca-8786-477c-9b56-3373e78c4057','tempest-typeshare-type-820928463',1,NULL),('2026-01-23 19:03:32.286539',NULL,'2026-01-23 19:04:05.789881','8a953b9f-99f3-477f-8f8b-a85b076a7406','8a953b9f-99f3-477f-8f8b-a85b076a7406','tempest-share-type-1138800177',1,NULL),('2026-01-23 19:02:24.012498','2026-01-23 19:02:24.083359','2026-01-23 19:02:26.280264','8af9324a-792a-4c3c-ae66-d999a4f7cbd9','8af9324a-792a-4c3c-ae66-d999a4f7cbd9','tempest-type_updated-1555959867',1,'Description for share type'),('2026-01-23 19:02:23.773463','2026-01-23 19:02:23.831678','2026-01-23 19:02:26.520981','8b9fb549-5b3f-460f-92e6-81bf79bcf119','8b9fb549-5b3f-460f-92e6-81bf79bcf119','tempest-tempest-manila-401890132',0,'Description for share type'),('2026-01-23 19:04:31.346893',NULL,'2026-01-23 19:04:31.795961','8bdc87ef-b1bf-4f1b-bea3-ce68b63425f7','8bdc87ef-b1bf-4f1b-bea3-ce68b63425f7','tempest-support_some_azs_share_type-32675632',1,NULL),('2026-01-23 19:06:07.411527',NULL,'2026-01-23 19:06:09.139457','8be0a894-cda6-4db1-955b-76ab5f70d810','8be0a894-cda6-4db1-955b-76ab5f70d810','tempest-typeshare-type-1045660925',1,NULL),('2026-01-23 19:02:24.755652','2026-01-23 19:02:24.872160','2026-01-23 19:02:25.773427','912e9ac5-b808-494d-85a4-82011bad3c89','912e9ac5-b808-494d-85a4-82011bad3c89','tempest-tempest-manila-2023199501',0,'Description for share type'),('2026-01-23 19:03:55.742361',NULL,'2026-01-23 19:04:04.625191','91c26460-9fbd-4287-97cf-8d78828587a3','91c26460-9fbd-4287-97cf-8d78828587a3','tempest-share-type-611475316',1,NULL),('2026-01-23 19:09:15.969829',NULL,'2026-01-23 19:09:18.897832','93bf7be6-2778-498b-9d8b-e5fde7a68d78','93bf7be6-2778-498b-9d8b-e5fde7a68d78','tempest-typeshare-type-1524668076',1,NULL),('2026-01-23 19:08:50.423786',NULL,'2026-01-23 19:09:05.876514','9d06412d-874f-45c2-b39d-2192c8184009','9d06412d-874f-45c2-b39d-2192c8184009','tempest-typeshare-type-76784596',1,NULL),('2026-01-23 19:02:21.207621',NULL,'2026-01-23 19:02:29.475248','9d3355a2-448e-419a-a551-a0bae08ae486','9d3355a2-448e-419a-a551-a0bae08ae486','tempest-tempest-manila-1372587257',1,NULL),('2026-01-23 19:02:36.735598',NULL,'2026-01-23 19:03:12.053187','9d723286-feb8-4b59-ba94-db1ea3aa7f91','9d723286-feb8-4b59-ba94-db1ea3aa7f91','tempest-typeshare-type-43243195',1,NULL),('2026-01-23 19:02:23.003023',NULL,'2026-01-23 19:02:27.218756','a0072387-63b6-4177-b92b-2b80369f9240','a0072387-63b6-4177-b92b-2b80369f9240','tempest-tempest-manila-967374725',1,NULL),('2026-01-23 19:01:31.609313',NULL,'2026-01-23 19:01:36.925173','a0645fd5-1d7e-47f9-a253-aec212942112','a0645fd5-1d7e-47f9-a253-aec212942112','tempest-typeshare-type-671767001',1,NULL),('2026-01-23 19:06:02.061582',NULL,'2026-01-23 19:07:06.248439','a231ee93-b5f1-4fc4-a3d2-0055417021c0','a231ee93-b5f1-4fc4-a3d2-0055417021c0','tempest-typeshare-type-989795765',1,NULL),('2026-01-23 19:07:28.596002',NULL,'2026-01-23 19:07:56.940570','a23d81ce-d5e1-43ae-b5f6-7a08ac609609','a23d81ce-d5e1-43ae-b5f6-7a08ac609609','tempest-typeshare-type-1851760060',1,NULL),('2026-01-23 19:02:20.070914',NULL,'2026-01-23 19:02:29.955137','a4d99fb4-0fbf-437d-ba1c-e9e0410214e6','a4d99fb4-0fbf-437d-ba1c-e9e0410214e6','tempest-tempest-manila-1414360219',0,NULL),('2026-01-23 19:01:37.412706',NULL,'2026-01-23 19:01:49.316298','a5d4d2e7-d073-45e8-ba1a-57670b080d11','a5d4d2e7-d073-45e8-ba1a-57670b080d11','tempest-typeshare-type-1431617367',1,NULL),('2026-01-23 19:01:37.841479',NULL,'2026-01-23 19:01:48.925140','a7f6bdb1-0337-48dd-84aa-75fbaa03f9a9','a7f6bdb1-0337-48dd-84aa-75fbaa03f9a9','tempest-typeshare-type-1720860887',1,NULL),('2026-01-23 19:00:34.513719',NULL,'2026-01-23 19:00:36.903434','a84c3c47-46dd-48bf-aabc-fc7e686073fd','a84c3c47-46dd-48bf-aabc-fc7e686073fd','tempest-typeshare-type-485111248',1,NULL),('2026-01-23 19:01:25.003016',NULL,'2026-01-23 19:01:41.177527','ab5e0ba6-2fa1-409f-bb67-c9bdb722d4f7','ab5e0ba6-2fa1-409f-bb67-c9bdb722d4f7','tempest-typeshare-type-1646700406',1,NULL),('2026-01-23 19:00:34.665468',NULL,'2026-01-23 19:00:36.719900','acddb3b9-1c01-40c4-bf2e-e4a5b099de5d','acddb3b9-1c01-40c4-bf2e-e4a5b099de5d','tempest-typeshare-type-1481326766',1,NULL),('2026-01-23 19:07:49.638926',NULL,'2026-01-23 19:08:42.336374','ae9b0b0a-11bb-4691-b72a-a62b561e3b36','ae9b0b0a-11bb-4691-b72a-a62b561e3b36','tempest-typeshare-type-1933271007',1,NULL),('2026-01-23 19:04:00.453778',NULL,'2026-01-23 19:04:04.475966','b1e1b985-0ef4-4803-84b5-18474a1939bf','b1e1b985-0ef4-4803-84b5-18474a1939bf','tempest-share-type-1182059854',1,NULL),('2026-01-23 19:01:43.371721',NULL,'2026-01-23 19:01:47.565804','b70c6cfd-9144-4b1a-a024-d2fe9a1782c8','b70c6cfd-9144-4b1a-a024-d2fe9a1782c8','tempest-typeshare-type-1516122132',1,NULL),('2026-01-23 19:01:00.987598',NULL,'2026-01-23 19:01:13.174666','b8db0a80-ec85-42c1-b292-cc539d8381ad','b8db0a80-ec85-42c1-b292-cc539d8381ad','tempest-typeshare-type-312443660',0,NULL),('2026-01-23 19:01:46.168206',NULL,'2026-01-23 19:01:46.669939','bb2ee399-479f-4113-be34-76b82fcdfc5e','bb2ee399-479f-4113-be34-76b82fcdfc5e','tempest-typeshare-type-616622178',1,NULL),('2026-01-23 19:04:28.988505',NULL,'2026-01-23 19:04:29.136970','bb5a20c8-3d55-4595-9f1a-2ec799a582e6','bb5a20c8-3d55-4595-9f1a-2ec799a582e6','tempest-az_share_type-1364634108',1,NULL),('2026-01-23 19:02:21.090523',NULL,'2026-01-23 19:02:29.628578','bb61d7b1-db83-43bd-9008-302de44c0f6a','bb61d7b1-db83-43bd-9008-302de44c0f6a','tempest-tempest-manila-1095113068',1,NULL),('2026-01-23 19:03:34.448808',NULL,'2026-01-23 19:03:43.477051','bccb681a-3222-4edc-857a-aaeddd11ad78','bccb681a-3222-4edc-857a-aaeddd11ad78','tempest-share-type-180504826',1,NULL),('2026-01-23 19:02:39.886175',NULL,'2026-01-23 19:02:53.905455','bdb8bf7b-3c8f-4c28-b5d9-d9a31db95eaa','bdb8bf7b-3c8f-4c28-b5d9-d9a31db95eaa','tempest-typeshare-type-2039400958',1,NULL),('2026-01-23 19:04:30.013191',NULL,'2026-01-23 19:04:30.467243','bf025c70-0375-4e9b-ac55-0aad11277999','bf025c70-0375-4e9b-ac55-0aad11277999','tempest-az_share_type-2072731195',1,NULL),('2026-01-23 19:01:39.705066',NULL,'2026-01-23 19:01:48.040894','bf221b07-5323-4a0c-b177-91f80c06a919','bf221b07-5323-4a0c-b177-91f80c06a919','tempest-typeshare-type-525310287',1,NULL),('2026-01-23 19:01:30.661518',NULL,'2026-01-23 19:01:37.681666','c1072551-6657-414f-9f98-7cc14a9c82fe','c1072551-6657-414f-9f98-7cc14a9c82fe','tempest-typeshare-type-398365316',1,NULL),('2026-01-23 19:01:45.575210',NULL,'2026-01-23 19:01:46.867279','c12fedec-9263-4a38-9733-50cab2896f84','c12fedec-9263-4a38-9733-50cab2896f84','tempest-typeshare-type-1591463515',1,NULL),('2026-01-23 19:03:30.181488',NULL,'2026-01-23 19:03:43.617688','c19ff7fa-2a85-4740-abc5-3c03e603c222','c19ff7fa-2a85-4740-abc5-3c03e603c222','tempest-share-type-878195324',1,NULL),('2026-01-23 19:01:44.373934',NULL,'2026-01-23 19:01:47.184528','c2d214e8-9edd-4d78-a60d-c0e7d1fdfbfc','c2d214e8-9edd-4d78-a60d-c0e7d1fdfbfc','tempest-typeshare-type-1139426076',1,NULL),('2026-01-23 19:02:16.397228',NULL,'2026-01-23 19:02:33.631240','c2e7b8e1-0b37-4bdc-b0cd-490536ec4c44','c2e7b8e1-0b37-4bdc-b0cd-490536ec4c44','tempest-share-type-1365427806',1,NULL),('2026-01-23 19:02:16.509730',NULL,'2026-01-23 19:02:24.827011','c45f2ba3-7d51-4245-94b8-6909ec45f40d','c45f2ba3-7d51-4245-94b8-6909ec45f40d','tempest-typeshare-type-899471160',1,NULL),('2026-01-23 19:06:19.080558',NULL,'2026-01-23 19:06:20.349475','c4f22e08-066f-4b0f-9188-4b8734ed06a1','c4f22e08-066f-4b0f-9188-4b8734ed06a1','tempest-typeshare-type-1471733761',1,NULL),('2026-01-23 19:01:10.904312',NULL,'2026-01-23 19:01:17.178237','c52c18ef-2487-4fde-b7d9-fd5aafc38799','c52c18ef-2487-4fde-b7d9-fd5aafc38799','tempest-share-type-435515559',1,NULL),('2026-01-23 19:07:09.563138',NULL,'2026-01-23 19:07:14.385277','c5ad0898-14df-4398-97d5-7af7452c5183','c5ad0898-14df-4398-97d5-7af7452c5183','tempest-typeshare-type-815826296',1,NULL),('2026-01-23 19:02:21.593556',NULL,'2026-01-23 19:02:28.899132','c5feba7d-f5b8-4aa4-b246-f54d5789d63d','c5feba7d-f5b8-4aa4-b246-f54d5789d63d','tempest-tempest-manila-198242944',1,'Description for share type'),('2026-01-23 19:00:35.256361',NULL,'2026-01-23 19:00:36.369195','c7204dfa-a6eb-48e5-bdc0-83a5bf1eb95f','c7204dfa-a6eb-48e5-bdc0-83a5bf1eb95f','tempest-unique_st_name-1517023931',1,NULL),('2026-01-23 19:02:21.852544',NULL,'2026-01-23 19:02:28.193143','c73250e8-8acb-483e-867c-3220b05d9c0c','c73250e8-8acb-483e-867c-3220b05d9c0c','tempest-tempest-manila-2097981748',1,NULL),('2026-01-23 19:08:05.017561',NULL,'2026-01-23 19:09:04.252694','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d','c7fbfb50-d0c0-46d3-86bb-c52c572f9d9d','tempest-typeshare-type-1168519039',1,NULL),('2026-01-23 19:01:25.466139',NULL,'2026-01-23 19:01:40.657914','c8c1ab2d-4ba9-4e88-8a26-8d09a193d45d','c8c1ab2d-4ba9-4e88-8a26-8d09a193d45d','tempest-typeshare-type-322162029',1,NULL),('2026-01-23 19:00:19.292772',NULL,'2026-01-23 19:00:19.635708','cb9d8e25-10b5-4195-a8e2-ff14358c7b8c','cb9d8e25-10b5-4195-a8e2-ff14358c7b8c','tempest-tempest-manila-1199887120',0,NULL),('2026-01-23 19:01:12.171552',NULL,'2026-01-23 19:01:16.533235','cffd7404-fd76-4a0c-aea3-a94718f54750','cffd7404-fd76-4a0c-aea3-a94718f54750','tempest-share-type-531038383',1,NULL),('2026-01-23 19:01:33.867744',NULL,'2026-01-23 19:01:36.017942','d00cd00a-ca7d-4c00-ab4e-fcac37c54388','d00cd00a-ca7d-4c00-ab4e-fcac37c54388','tempest-typeshare-type-1548524454',1,NULL),('2026-01-23 19:09:16.085775',NULL,'2026-01-23 19:09:18.414084','d03605c9-c2b7-4e26-ae5b-7e1725728f25','d03605c9-c2b7-4e26-ae5b-7e1725728f25','tempest-typeshare-type-953948721',1,NULL),('2026-01-23 19:00:23.139702',NULL,'2026-01-23 19:01:16.853656','d20bdec5-e74c-4607-88bd-eca35cfd175e','d20bdec5-e74c-4607-88bd-eca35cfd175e','tempest-typeshare-type-1802072756',1,NULL),('2026-01-23 19:03:40.542328',NULL,'2026-01-23 19:04:11.185365','d4340069-92a0-40b1-9a2d-4931749a22be','d4340069-92a0-40b1-9a2d-4931749a22be','tempest-typeshare-type-1811125073',1,NULL),('2026-01-23 19:04:32.567685',NULL,'2026-01-23 19:04:32.727327','d578ab27-3645-491a-bb7e-2652716f36c8','d578ab27-3645-491a-bb7e-2652716f36c8','tempest-support_any_az_share_type-514741723',1,NULL),('2026-01-23 19:00:23.295814',NULL,'2026-01-23 19:01:16.486785','d6086e5f-4d59-4e21-9550-2e32e22fbdf6','d6086e5f-4d59-4e21-9550-2e32e22fbdf6','tempest-typeshare-type-1945089940',1,NULL),('2026-01-23 19:04:51.888614',NULL,'2026-01-23 19:05:02.722891','d75ba714-c404-43a1-a9ef-110a3d3d2fa3','d75ba714-c404-43a1-a9ef-110a3d3d2fa3','tempest-typeshare-type-646559181',1,NULL),('2026-01-23 19:04:22.137743',NULL,'2026-01-23 19:04:48.088374','d7fe3112-4905-44e0-a7a6-b013dde8491c','d7fe3112-4905-44e0-a7a6-b013dde8491c','tempest-typeshare-type-451324213',1,NULL),('2026-01-23 19:01:43.079570',NULL,'2026-01-23 19:01:47.896785','d8f88b49-ed0e-4442-af6f-b572076f3ebe','d8f88b49-ed0e-4442-af6f-b572076f3ebe','tempest-typeshare-type-17817393',1,NULL),('2026-01-23 19:00:23.401312',NULL,'2026-01-23 19:01:16.186819','d9dd72be-5638-411d-adb4-977298762a87','d9dd72be-5638-411d-adb4-977298762a87','tempest-typeshare-type-457433179',1,NULL),('2026-01-23 19:04:29.310222',NULL,'2026-01-23 19:04:29.446965','da138aad-482b-4f1c-bef3-50fe4655e1a5','da138aad-482b-4f1c-bef3-50fe4655e1a5','tempest-az_share_type-358689390',1,NULL),('2026-01-23 19:04:32.405980',NULL,'2026-01-23 19:04:32.878717','dd482e1b-2f54-4d29-8a58-921721140e24','dd482e1b-2f54-4d29-8a58-921721140e24','tempest-support_some_azs_share_type-288812419',1,NULL),('2026-01-23 19:00:43.899754',NULL,'2026-01-23 19:01:15.641430','de31c409-0480-47b7-a09f-ba5b43c6081a','de31c409-0480-47b7-a09f-ba5b43c6081a','tempest-typeshare-type-1346701877',1,NULL),('2026-01-23 19:01:04.735018',NULL,'2026-01-23 19:01:12.211057','dea7574c-f5d8-45d6-bb8e-5a8cf73f3f1f','dea7574c-f5d8-45d6-bb8e-5a8cf73f3f1f','tempest-typeshare-type-1324495159',1,NULL),('2026-01-23 19:01:04.049300',NULL,'2026-01-23 19:01:12.583263','e0e6fa64-95a6-4624-b32f-df2af84dc8d6','e0e6fa64-95a6-4624-b32f-df2af84dc8d6','tempest-typeshare-type-119490519',1,NULL),('2026-01-23 19:03:38.460870',NULL,'2026-01-23 19:03:43.189233','e14aad06-9466-486c-bc63-26592e0cdf52','e14aad06-9466-486c-bc63-26592e0cdf52','tempest-share-type-487906972',1,NULL),('2026-01-23 19:05:13.699307',NULL,'2026-01-23 19:05:22.727350','e2842727-9db2-48d3-8b3d-2a3115f7f601','e2842727-9db2-48d3-8b3d-2a3115f7f601','tempest-typeshare-type-1350515029',1,NULL),('2026-01-23 19:01:30.071146',NULL,'2026-01-23 19:01:38.315506','e39ead33-5640-434e-a4aa-19a020aec979','e39ead33-5640-434e-a4aa-19a020aec979','tempest-typeshare-type-1293716719',1,NULL),('2026-01-23 19:01:27.816748',NULL,'2026-01-23 19:01:39.736702','e5ca42ee-68c2-4b01-845b-39d2860931e6','e5ca42ee-68c2-4b01-845b-39d2860931e6','tempest-typeshare-type-1609683387',1,NULL),('2026-01-23 19:00:35.591353',NULL,'2026-01-23 19:00:36.166113','e87a072c-42d8-418d-8093-0ab15e422ea8','e87a072c-42d8-418d-8093-0ab15e422ea8','tempest-unique_st_name-745396434',1,NULL),('2026-01-23 19:03:52.294487',NULL,'2026-01-23 19:04:04.789563','e9d1bb70-adca-4093-9b6e-5c2f0f61fbea','e9d1bb70-adca-4093-9b6e-5c2f0f61fbea','tempest-share-type-1538965643',1,NULL),('2026-01-23 19:04:33.757258',NULL,'2026-01-23 19:04:34.369251','ecfa30eb-5a32-4a5a-b521-c71e95e7fd4c','ecfa30eb-5a32-4a5a-b521-c71e95e7fd4c','tempest-support_some_azs_share_type-962010701',1,NULL),('2026-01-23 19:02:22.243399',NULL,'2026-01-23 19:02:27.695941','ee80c2be-8f68-4b04-a213-b7cd17c249cf','ee80c2be-8f68-4b04-a213-b7cd17c249cf','tempest-tempest-manila-830139498',1,'Description for share type'),('2026-01-23 19:07:35.705541',NULL,'2026-01-23 19:07:37.780443','f0532df6-4315-4c59-b021-d808b59838e1','f0532df6-4315-4c59-b021-d808b59838e1','tempest-typeshare-type-434351950',1,NULL),('2026-01-23 19:01:21.340255',NULL,'2026-01-23 19:02:00.427952','f4a6bef4-70c7-455a-897f-b3e9b5f4c268','f4a6bef4-70c7-455a-897f-b3e9b5f4c268','tempest-typeshare-type-727745880',1,NULL),('2026-01-23 19:05:32.565621',NULL,'2026-01-23 19:07:07.595356','f57d6e7a-ef40-49d3-9e68-6fb5a008c4a4','f57d6e7a-ef40-49d3-9e68-6fb5a008c4a4','tempest-typeshare-type-1469099344',1,NULL),('2026-01-23 19:02:25.237844','2026-01-23 19:02:25.325639','2026-01-23 19:02:25.452562','f74130ae-ed68-4b2d-a06a-4dad17a6481f','f74130ae-ed68-4b2d-a06a-4dad17a6481f','tempest-tempest-manila-677241521',1,NULL),('2026-01-23 19:04:34.578053',NULL,'2026-01-23 19:04:35.057940','f7777b47-4e94-493d-b356-2e6931ee62ea','f7777b47-4e94-493d-b356-2e6931ee62ea','tempest-support_some_azs_share_type-150158882',1,NULL),('2026-01-23 19:03:52.065231',NULL,'2026-01-23 19:04:22.974953','fc3dea75-7a38-41a5-9a53-1370369a0c3e','fc3dea75-7a38-41a5-9a53-1370369a0c3e','tempest-typeshare-type-1899966799',1,NULL),('2026-01-23 19:01:28.954001',NULL,'2026-01-23 19:01:38.940510','fd645f94-058c-4b60-86e9-e294c5e003f4','fd645f94-058c-4b60-86e9-e294c5e003f4','tempest-typeshare-type-738395825',1,NULL),('2026-01-23 19:00:11.708942',NULL,'2026-01-23 19:00:22.090877','fd74222d-9aee-436c-9b35-942741042afa','fd74222d-9aee-436c-9b35-942741042afa','tempest-typeshare-type-192153736',1,NULL),('2026-01-23 19:00:40.768029',NULL,'2026-01-23 19:01:16.018705','fe1ae4c1-4e7d-4e4f-a296-9dc3f02f66e4','fe1ae4c1-4e7d-4e4f-a296-9dc3f02f66e4','tempest-typeshare-type-230263757',1,NULL),('2026-01-23 18:56:44.432190',NULL,NULL,'False','fe8a42c9-28ea-4c66-bed3-f2f6d12529fa','default',1,NULL);
/*!40000 ALTER TABLE `share_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shares`
--

DROP TABLE IF EXISTS `shares`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shares` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `share_proto` varchar(255) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `snapshot_support` tinyint(1) DEFAULT NULL,
  `share_group_id` varchar(36) DEFAULT NULL,
  `source_share_group_snapshot_member_id` varchar(36) DEFAULT NULL,
  `task_state` varchar(255) DEFAULT NULL,
  `replication_type` varchar(255) DEFAULT NULL,
  `create_share_from_snapshot_support` tinyint(1) DEFAULT NULL,
  `revert_to_snapshot_support` tinyint(1) DEFAULT NULL,
  `mount_snapshot_support` tinyint(1) DEFAULT NULL,
  `is_soft_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `scheduled_to_be_deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_shares_share_group_id` (`share_group_id`),
  CONSTRAINT `fk_shares_share_group_id` FOREIGN KEY (`share_group_id`) REFERENCES `share_groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shares`
--

LOCK TABLES `shares` WRITE;
/*!40000 ALTER TABLE `shares` DISABLE KEYS */;
INSERT INTO `shares` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `size`, `display_name`, `display_description`, `snapshot_id`, `share_proto`, `is_public`, `snapshot_support`, `share_group_id`, `source_share_group_snapshot_member_id`, `task_state`, `replication_type`, `create_share_from_snapshot_support`, `revert_to_snapshot_support`, `mount_snapshot_support`, `is_soft_deleted`, `scheduled_to_be_deleted_at`) VALUES ('2026-01-23 19:07:58.697943','2026-01-23 19:08:06.100312','2026-01-23 19:08:06.099872','0c705063-7c58-4940-ab8f-3fe6ed80ea78','0c705063-7c58-4940-ab8f-3fe6ed80ea78','77520b512b09481594399d1d447d3353','998a3a4c23934c4dafb2e2112ce1af90',2,'tempest-tempest-created-share-848298195','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-23 19:07:28.789648','2026-01-23 19:07:37.037874','2026-01-23 19:07:37.037481','1036c742-b7c8-4486-8595-4ecfc41b77f3','1036c742-b7c8-4486-8595-4ecfc41b77f3','8263f588feb3441b90a14974c5c7dfcf','c65808ebd8034050a7f642ca129ed6de',2,'tempest-tempest-created-share-2039849597','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-23 19:08:27.189552','2026-01-23 19:08:32.518455','2026-01-23 19:08:32.518053','10389d2f-ee79-4aa1-86d0-deb816518b03','10389d2f-ee79-4aa1-86d0-deb816518b03','3deb3c1777d64f18bc9de677a095431d','8548bd568a5448648a2e519eb3ab357a',1,'tempest-tempest-created-share-777867455','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:05:39.348694','2026-01-23 19:05:55.180997','2026-01-23 19:05:55.180644','1289a7a6-fe12-4d2f-b00b-358016b0e61e','1289a7a6-fe12-4d2f-b00b-358016b0e61e','7a1a35011363435a8a558e98e87b8831','ef50bedea4bc4cfd892c55fa7305015f',1,'tempest-tempest-created-share-1623841231','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:05:54.058281','2026-01-23 19:05:59.357961','2026-01-23 19:05:59.357494','16fc78cd-4631-4b5e-bee7-624b90b7fa9f','16fc78cd-4631-4b5e-bee7-624b90b7fa9f','0ee3b61db0254b40bc85214e7d348538','3fb8d4a8278546deacbbb6d960f5b0bb',1,'tempest-tempest-created-share-1227749087','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:07:49.824298','2026-01-23 19:08:39.207047','2026-01-23 19:08:39.206614','1c640b45-4f70-4ab0-b31e-d65cb9f227fe','1c640b45-4f70-4ab0-b31e-d65cb9f227fe','3deb3c1777d64f18bc9de677a095431d','8548bd568a5448648a2e519eb3ab357a',1,'tempest-tempest-share-name-451287390','tempest-tempest-share-description-1581029540',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:05:06.809176','2026-01-23 19:05:11.628401','2026-01-23 19:05:11.627933','1ec67602-9d35-44a8-8c55-aae8555c9738','1ec67602-9d35-44a8-8c55-aae8555c9738','0cdc36ee00844d51a9bfb80f7be4a983','6e81efcadc1a4938a53855b68f0acfd2',1,'tempest-tempest-created-share-628916604','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:02:14.050977','2026-01-23 19:03:02.746456','2026-01-23 19:03:02.745957','21ed6874-3e57-49ad-ad3d-e168df853ebc','21ed6874-3e57-49ad-ad3d-e168df853ebc','48aab17447ce4d90a8a1db613f1ea646','f2beea25a5e947aab5d0bb53058124cf',1,'tempest-tempest-created-share-759297855','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:01:55.198147','2026-01-23 19:02:42.905476','2026-01-23 19:02:42.904974','227c770e-cd8a-40bc-b862-45ce5532d775','227c770e-cd8a-40bc-b862-45ce5532d775','795d61c6748c4ee1963bd0cf94173c58','db171ed11cd54288960e2675bc51a3a1',1,'tempest-tempest-created-share-1613154477','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-23 19:03:44.205967','2026-01-23 19:03:51.897332','2026-01-23 19:03:51.897001','265aabd6-df6d-409b-81b1-b331c143ed96','265aabd6-df6d-409b-81b1-b331c143ed96','2fbff2750c964489941186e6647353bd','08f0ac3daf4849ccbfe15d2f731f4f1f',1,'tempest-tempest-created-share-775338282','tempest-tempest-created-share-desc-152561941',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:07:58.294828','2026-01-23 19:08:02.604973','2026-01-23 19:08:02.604492','2842acb6-6a55-4fe8-bf4e-af508fb83d9f','2842acb6-6a55-4fe8-bf4e-af508fb83d9f','3deb3c1777d64f18bc9de677a095431d','8548bd568a5448648a2e519eb3ab357a',1,'tempest-tempest-created-share-237927621','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:03:40.667470','2026-01-23 19:03:52.194461','2026-01-23 19:03:52.194104','29861bb5-32b3-471d-8b8b-fd8698202092','29861bb5-32b3-471d-8b8b-fd8698202092','2fbff2750c964489941186e6647353bd','08f0ac3daf4849ccbfe15d2f731f4f1f',1,'tempest-tempest-created-share-585179795','tempest-tempest-created-share-desc-313328871',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:03:44.940109','2026-01-23 19:04:04.662544','2026-01-23 19:04:04.661909','29d694db-1498-45de-818b-999e5140dad6','29d694db-1498-45de-818b-999e5140dad6','fd03ddd06d374af6aaab5af51dd14875','5ed6311cb89a4e81ac3637cb0a3cdbbe',1,'tempest-tempest-share-name-1376150686','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:03:52.412435','2026-01-23 19:04:00.196972','2026-01-23 19:04:00.196616','2e64c116-8c52-41df-b4be-e03adb9e0bbe','2e64c116-8c52-41df-b4be-e03adb9e0bbe','2fbff2750c964489941186e6647353bd','08f0ac3daf4849ccbfe15d2f731f4f1f',1,'tempest-tempest-created-share-1978037781','tempest-tempest-created-share-desc-2076102667',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:03:34.633992','2026-01-23 19:03:38.240723','2026-01-23 19:03:38.240266','366a6c27-7a41-4ec7-85c2-8355e39c9e2b','366a6c27-7a41-4ec7-85c2-8355e39c9e2b','b3ec277fe4624b46b687bc78d7cf6a03','3f9725edbd1b4cf299e129c2c7587203',1,'tempest-tempest-created-share-1481091494','tempest-tempest-created-share-desc-1414545519',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:00:12.953555','2026-01-23 19:00:17.184008','2026-01-23 19:00:17.183380','36a9c8b6-9e21-4434-b741-212702a77736','36a9c8b6-9e21-4434-b741-212702a77736','c1c8384de14c4a31ae08ff4e69a1c9bb','dcb726ed64514381891686f89d347595',1,'tempest-tempest-created-share-1163204176','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:05:34.553090','2026-01-23 19:06:50.774640','2026-01-23 19:06:50.774168','37853495-d9b6-4d2c-abc6-da37b9ee8591','37853495-d9b6-4d2c-abc6-da37b9ee8591','7a1a35011363435a8a558e98e87b8831','ef50bedea4bc4cfd892c55fa7305015f',1,'tempest-tempest-created-share-2140172365','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:02:43.880469','2026-01-23 19:03:01.923976','2026-01-23 19:03:01.923584','386e06d8-ac44-45fc-b5bc-cda5ad18efea','386e06d8-ac44-45fc-b5bc-cda5ad18efea','2caaa2bea59549f48039d35cd4c79c3d','8ea2dddd772b49f1b9e0a76f8a04e556',1,'tempest-tempest-share-name-655219862','tempest-tempest-share-description-517568507','0d399fc2-1c4a-4fa4-a842-d2d9e4db8512','CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-23 19:03:32.396308','2026-01-23 19:03:40.391867','2026-01-23 19:03:40.391532','391232c3-3948-4ccb-a6c7-38654bac3ce2','391232c3-3948-4ccb-a6c7-38654bac3ce2','2fbff2750c964489941186e6647353bd','08f0ac3daf4849ccbfe15d2f731f4f1f',1,'tempest-tempest-created-share-66362641','tempest-tempest-created-share-desc-1250823140',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:03:49.108681','2026-01-23 19:04:01.253618','2026-01-23 19:04:01.253255','39284e92-1b49-4324-96db-4c5831010bf3','39284e92-1b49-4324-96db-4c5831010bf3','fd03ddd06d374af6aaab5af51dd14875','5ed6311cb89a4e81ac3637cb0a3cdbbe',1,'tempest-tempest-share-name-598147884','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:01:44.420959','2026-01-23 19:02:50.858228','2026-01-23 19:02:50.857662','3b030aa9-c2a3-412f-bf95-1476db82a6ad','3b030aa9-c2a3-412f-bf95-1476db82a6ad','58ba79b6c9994c0fb14affae9b8f0c8c','e19ff7e178044a3f9516cdc773fa4d6b',1,'tempest-tempest-created-share-673863012','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 18:59:53.140471','2026-01-23 19:01:24.610775','2026-01-23 19:01:24.610348','3bb50cf4-b86f-48ff-934d-15e15af9f620','3bb50cf4-b86f-48ff-934d-15e15af9f620','c1c8384de14c4a31ae08ff4e69a1c9bb','dcb726ed64514381891686f89d347595',1,'tempest-tempest-created-share-1853298834','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:02:50.130589','2026-01-23 19:02:56.690431','2026-01-23 19:02:56.689926','3da810db-9a70-4383-aaf3-cc25bc7e9cab','3da810db-9a70-4383-aaf3-cc25bc7e9cab','48aab17447ce4d90a8a1db613f1ea646','f2beea25a5e947aab5d0bb53058124cf',1,'tempest-tempest-created-share-1340429657','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:02:40.564716','2026-01-23 19:02:45.527935','2026-01-23 19:02:45.527560','3f4883fe-85fc-4897-9382-f88c948a4c2b','3f4883fe-85fc-4897-9382-f88c948a4c2b','48aab17447ce4d90a8a1db613f1ea646','f2beea25a5e947aab5d0bb53058124cf',1,'tempest-tempest-created-share-1457468039','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:03:38.710978','2026-01-23 19:03:42.474549','2026-01-23 19:03:42.474041','469ce416-fdcf-42ae-9fb1-1c87fce73818','469ce416-fdcf-42ae-9fb1-1c87fce73818','b3ec277fe4624b46b687bc78d7cf6a03','3f9725edbd1b4cf299e129c2c7587203',1,'tempest-tempest-created-share-2019316992','tempest-tempest-created-share-desc-1339234857',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:06:09.481694','2026-01-23 19:06:19.461216','2026-01-23 19:06:19.460815','47e3b685-1a97-423d-9bd9-6c6581606054','47e3b685-1a97-423d-9bd9-6c6581606054','7a1a35011363435a8a558e98e87b8831','ef50bedea4bc4cfd892c55fa7305015f',1,'tempest-tempest-created-share-1275161950','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:03:24.683515','2026-01-23 19:03:28.341109','2026-01-23 19:03:28.340167','493e7f0d-e65f-4a69-bc39-608606a704e8','493e7f0d-e65f-4a69-bc39-608606a704e8','2fbff2750c964489941186e6647353bd','08f0ac3daf4849ccbfe15d2f731f4f1f',1,'tempest-tempest-created-share-517267256','tempest-tempest-created-share-desc-1387815044',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:08:50.659967','2026-01-23 19:09:02.732146','2026-01-23 19:09:02.731761','4c63b0d1-2bfd-41f1-a117-86a846be3efd','4c63b0d1-2bfd-41f1-a117-86a846be3efd','9387f9e13c974a7b9c7352ead07a670a','25ab22f3f2214f1685af23b1e9f04ebe',1,'tempest-tempest-new-name-1757106292','tempest-tempest-new-description-621907110',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:03:26.495538','2026-01-23 19:03:30.021726','2026-01-23 19:03:30.021293','4d8f6ad2-640a-446d-9f8c-17c7e37baa77','4d8f6ad2-640a-446d-9f8c-17c7e37baa77','b3ec277fe4624b46b687bc78d7cf6a03','3f9725edbd1b4cf299e129c2c7587203',1,'tempest-tempest-created-share-255916507','tempest-tempest-created-share-desc-1151129657',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:03:30.447834','2026-01-23 19:03:34.265905','2026-01-23 19:03:34.265295','5328202d-ad99-407a-b316-29648f9d1631','5328202d-ad99-407a-b316-29648f9d1631','b3ec277fe4624b46b687bc78d7cf6a03','3f9725edbd1b4cf299e129c2c7587203',1,'tempest-tempest-created-share-1346127941','tempest-tempest-created-share-desc-1859625669',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:03:52.232589','2026-01-23 19:04:20.937515','2026-01-23 19:04:20.936993','57d4aac1-6dba-40f5-b7ab-eecb70beae03','57d4aac1-6dba-40f5-b7ab-eecb70beae03','2b6dadb05d14498fb74d0e3ed633c1c2','182b21a4575a4acc866fcdd5f8991734',1,'tempest-tempest-created-share-688892764','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:08:13.017547','2026-01-23 19:08:16.954233','2026-01-23 19:08:16.953838','58086060-20fd-490e-b109-47b5495a4e56','58086060-20fd-490e-b109-47b5495a4e56','3deb3c1777d64f18bc9de677a095431d','8548bd568a5448648a2e519eb3ab357a',1,'tempest-tempest-created-share-989467779','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:03:02.141166','2026-01-23 19:03:12.041216','2026-01-23 19:03:12.040763','5df7f392-10cf-4571-bdf9-06da47e30bbd','5df7f392-10cf-4571-bdf9-06da47e30bbd','17ec91f691e54474893d8e435e589e7d','26ffaef7ee914dff8756a8885f9f07e2',1,'tempest-tempest-created-share-627938627','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:07:23.510615','2026-01-23 19:08:32.315250','2026-01-23 19:08:32.314874','5f871fb6-01a9-4012-ba73-cb3c1ec609fd','5f871fb6-01a9-4012-ba73-cb3c1ec609fd','77520b512b09481594399d1d447d3353','998a3a4c23934c4dafb2e2112ce1af90',1,'tempest-tempest-share-name-1975160455','tempest-tempest-share-description-494164119','f7119362-56c6-41a3-a825-295c8385d456','CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-23 19:05:14.119881','2026-01-23 19:05:19.750949','2026-01-23 19:05:19.750088','63940a9b-b535-42eb-a7cd-94b38ca85aee','63940a9b-b535-42eb-a7cd-94b38ca85aee','4cdaf3be00a843b7aca77970f17d1587','8ecf67da29b04bd89431f71cece6e5cf',1,'public_share','public_share_desc',NULL,'CEPHFS',1,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:01:21.700746','2026-01-23 19:01:57.067900','2026-01-23 19:01:57.067550','66da67fb-2a2c-4f7a-9f67-7e48c0389d7a','66da67fb-2a2c-4f7a-9f67-7e48c0389d7a','1efc60dfafb740f48a10184f26e16386','1490bc1cfa8e446280d7d1f208cdd9cc',1,'tempest-tempest-created-share-444643120','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:06:35.553642',NULL,NULL,'False','69a009ee-f397-404a-b72b-02056e1c0d04','72c10a6dc7104c18ac27162d188683d7','1bedbf7265dc42cf859f02ee7f9194c5',1,'tempest-tempest-created-share-1820676674','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:08:05.942387','2026-01-23 19:08:09.853155','2026-01-23 19:08:09.852703','6aca15d2-5578-4867-adfa-2bf5c083fe5c','6aca15d2-5578-4867-adfa-2bf5c083fe5c','3deb3c1777d64f18bc9de677a095431d','8548bd568a5448648a2e519eb3ab357a',2,'tempest-tempest-created-share-1077542613','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:09:33.591955','2026-01-23 19:09:46.390784','2026-01-23 19:09:46.390273','6e946115-7c50-4b74-844b-36e0e549695b','6e946115-7c50-4b74-844b-36e0e549695b','a622f76c64c643c1904e54c2dde49e5a','07e698407b254151a7a1ba401f6bb52e',1,'tempest-tempest-share-name-1708772138','tempest-tempest-share-description-1153121348',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-23 19:06:02.210096','2026-01-23 19:07:02.964064','2026-01-23 19:07:02.963677','6ef51183-9eb7-460b-91d9-d5b9e76c3afd','6ef51183-9eb7-460b-91d9-d5b9e76c3afd','0ee3b61db0254b40bc85214e7d348538','3fb8d4a8278546deacbbb6d960f5b0bb',1,'tempest-tempest-created-share-326425301','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-23 19:02:36.900782','2026-01-23 19:03:08.979645','2026-01-23 19:03:08.978978','6f28e846-7b1c-4dec-80da-017ad13ed962','6f28e846-7b1c-4dec-80da-017ad13ed962','2caaa2bea59549f48039d35cd4c79c3d','8ea2dddd772b49f1b9e0a76f8a04e556',1,'tempest-tempest-share-name-2020962208','tempest-tempest-share-description-1572518236',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-23 19:02:33.472575','2026-01-23 19:02:37.472706','2026-01-23 19:02:37.472151','7662b1bb-78a6-468c-b02d-242bc6501e96','7662b1bb-78a6-468c-b02d-242bc6501e96','48aab17447ce4d90a8a1db613f1ea646','f2beea25a5e947aab5d0bb53058124cf',1,'tempest-tempest-created-share-478206095','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:04:00.553055','2026-01-23 19:04:04.332602','2026-01-23 19:04:04.331888','7834bedd-587b-48b5-86e3-9975b049f7a3','7834bedd-587b-48b5-86e3-9975b049f7a3','2fbff2750c964489941186e6647353bd','08f0ac3daf4849ccbfe15d2f731f4f1f',1,'tempest-tempest-created-share-1275265212','tempest-tempest-created-share-desc-902994427',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:02:24.604057','2026-01-23 19:02:39.241197','2026-01-23 19:02:39.240866','784dce8f-a5a5-4328-baac-1ef916284d88','784dce8f-a5a5-4328-baac-1ef916284d88','795d61c6748c4ee1963bd0cf94173c58','db171ed11cd54288960e2675bc51a3a1',1,'tempest-tempest-created-share-742443733','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:01:47.988561','2026-01-23 19:02:46.217702','2026-01-23 19:02:46.217044','7938988f-34fb-477d-9ef4-7346a281e738','7938988f-34fb-477d-9ef4-7346a281e738','58ba79b6c9994c0fb14affae9b8f0c8c','e19ff7e178044a3f9516cdc773fa4d6b',1,'tempest-tempest-created-share-427149719','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-23 19:02:40.000799','2026-01-23 19:02:51.064268','2026-01-23 19:02:51.063915','7bca3129-9356-42c9-8b48-e6061ed16f01','7bca3129-9356-42c9-8b48-e6061ed16f01','aab37409764d412dbda1be20cc09c609','a9e6aa878c9c4cbaba399c1a4dd39ad1',1,'tempest-tempest-created-share-2049318570','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:00:04.610266','2026-01-23 19:00:09.741662','2026-01-23 19:00:09.741014','7d0a6496-9c62-4373-afd1-0df6484dfced','7d0a6496-9c62-4373-afd1-0df6484dfced','c1c8384de14c4a31ae08ff4e69a1c9bb','dcb726ed64514381891686f89d347595',2,'tempest-tempest-created-share-1305368465','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:03:28.561813','2026-01-23 19:03:32.126670','2026-01-23 19:03:32.126163','7d876ca7-1a61-4950-b214-03431c416d34','7d876ca7-1a61-4950-b214-03431c416d34','2fbff2750c964489941186e6647353bd','08f0ac3daf4849ccbfe15d2f731f4f1f',1,'tempest-tempest-created-share-460730508','tempest-tempest-created-share-desc-118639223',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 18:59:56.412145','2026-01-23 19:00:05.299502','2026-01-23 19:00:05.299097','7edeeaf9-75d2-4c10-9e64-7a0f1fd33342','7edeeaf9-75d2-4c10-9e64-7a0f1fd33342','fe4bef7f11184042b5e32df18701003e','3f38697b55014585bfbeb92f42a147ef',1,'tempest-tempest-created-share-181188145','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:05:32.916015','2026-01-23 19:05:50.827573','2026-01-23 19:05:50.827085','8453ecac-20f9-422a-b1ad-2bd319766708','8453ecac-20f9-422a-b1ad-2bd319766708','0ee3b61db0254b40bc85214e7d348538','3fb8d4a8278546deacbbb6d960f5b0bb',1,'tempest-tempest-created-share-1877820337','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 18:59:56.841058','2026-01-23 19:00:08.446249','2026-01-23 19:00:08.445620','84f80d8e-7753-43a3-b2e1-760b2497acf3','84f80d8e-7753-43a3-b2e1-760b2497acf3','d1d451d7e0e64bd3b447c74b97e73217','91991deea63743aea683dc7e4ded5161',1,'tempest-tempest-created-share-1146906907','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:08:20.038273','2026-01-23 19:08:24.076828','2026-01-23 19:08:24.076390','85c98837-c914-4e4d-8b55-a429680295cd','85c98837-c914-4e4d-8b55-a429680295cd','3deb3c1777d64f18bc9de677a095431d','8548bd568a5448648a2e519eb3ab357a',1,'tempest-tempest-created-share-1072586967','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 18:59:57.021030','2026-01-23 19:00:04.313265','2026-01-23 19:00:04.312619','8784868c-ca01-49f8-b77a-a337914b8f22','8784868c-ca01-49f8-b77a-a337914b8f22','c1c8384de14c4a31ae08ff4e69a1c9bb','dcb726ed64514381891686f89d347595',2,'tempest-tempest-created-share-653098389','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:03:55.922051','2026-01-23 19:03:59.936215','2026-01-23 19:03:59.935872','88064b1f-2796-4781-8f3d-4593b6580021','88064b1f-2796-4781-8f3d-4593b6580021','2fbff2750c964489941186e6647353bd','08f0ac3daf4849ccbfe15d2f731f4f1f',1,'tempest-tempest-created-share-186556507','tempest-tempest-created-share-desc-433222109',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:04:37.998499','2026-01-23 19:04:43.348818','2026-01-23 19:04:43.348437','8bba90e0-40c5-41d4-8973-4840f22849f9','8bba90e0-40c5-41d4-8973-4840f22849f9','1a04690e8f284aa39ed37e0b6aa7b3ee','5d979c3ed74a492981b806cb6f7d0021',1,'tempest-tempest-new-share-name-326368094','share is now updated',NULL,'CEPHFS',1,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:07:41.697067','2026-01-23 19:07:56.494035','2026-01-23 19:07:56.493533','91677b82-e607-4b55-bd2b-bf34898cc935','91677b82-e607-4b55-bd2b-bf34898cc935','8263f588feb3441b90a14974c5c7dfcf','c65808ebd8034050a7f642ca129ed6de',1,'tempest-tempest-created-share-1221910062','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-23 19:03:19.635574','2026-01-23 19:06:50.529622','2026-01-23 19:06:50.529192','925d3664-bf68-4a0a-92b4-6195aa90de88','925d3664-bf68-4a0a-92b4-6195aa90de88','39690acf77cd4929bf30d8ec50697f1a','1bedbf7265dc42cf859f02ee7f9194c5',1,'tempest-tempest-created-share-1598786819','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:05:15.233244','2026-01-23 19:05:19.751672','2026-01-23 19:05:19.751298','95f14abf-d821-478e-a525-5c4864abf611','95f14abf-d821-478e-a525-5c4864abf611','0cdc36ee00844d51a9bfb80f7be4a983','6e81efcadc1a4938a53855b68f0acfd2',1,'tempest-tempest-created-share-1219804264','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:04:37.987133','2026-01-23 19:04:51.970505','2026-01-23 19:04:51.970125','98da0987-8f83-410f-9b05-c7ad0936208c','98da0987-8f83-410f-9b05-c7ad0936208c','0cdc36ee00844d51a9bfb80f7be4a983','6e81efcadc1a4938a53855b68f0acfd2',1,'tempest-tempest-created-share-1877869780','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:01:51.119245','2026-01-23 19:01:56.281312','2026-01-23 19:01:56.280656','a8641b5d-7b3b-4197-9cc0-76b90318f554','a8641b5d-7b3b-4197-9cc0-76b90318f554','25ebb8b143d84bfab128a474701250d6','bd0d4498326a45708c5d8845efe3901e',1,'tempest-tempest-created-share-3156990','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:06:26.673191','2026-01-23 19:06:31.561644','2026-01-23 19:06:31.561250','ab471169-de9b-4160-affe-e7fd580570d1','ab471169-de9b-4160-affe-e7fd580570d1','1f380b30b01f4d3fa656e1f1627b7438','1e5a07e60ba9416db9dd4733653459eb',1,'tempest-tempest-share-name-211451500','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:03:36.254657','2026-01-23 19:03:40.111174','2026-01-23 19:03:40.110829','abd86165-d5a5-4739-904a-95596ad006a9','abd86165-d5a5-4739-904a-95596ad006a9','2fbff2750c964489941186e6647353bd','08f0ac3daf4849ccbfe15d2f731f4f1f',1,'tempest-tempest-created-share-1142988897','tempest-tempest-created-share-desc-909428432',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:01:27.673187','2026-01-23 19:01:53.513523','2026-01-23 19:01:53.513156','ad431efc-4255-4370-895c-6ab531b1785e','ad431efc-4255-4370-895c-6ab531b1785e','1efc60dfafb740f48a10184f26e16386','1490bc1cfa8e446280d7d1f208cdd9cc',1,'tempest-tempest-created-share-737440903','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:06:34.585225','2026-01-23 19:06:39.278995','2026-01-23 19:06:39.278570','b4308187-b5c6-41cc-9f65-4b5ef066d494','b4308187-b5c6-41cc-9f65-4b5ef066d494','b41c18afdb6346b291f5525a5b5aca4d','5ce1c1cb978d4655b95674240227e033',1,'tempest-tempest-share-name-428960726','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:08:12.843637','2026-01-23 19:08:19.916474','2026-01-23 19:08:19.916005','b477be78-9127-48f3-918b-227b7d20ddba','b477be78-9127-48f3-918b-227b7d20ddba','77520b512b09481594399d1d447d3353','998a3a4c23934c4dafb2e2112ce1af90',1,'tempest-tempest-created-share-73702303','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-23 19:06:13.660637','2026-01-23 19:06:55.854635','2026-01-23 19:06:55.854204','b4a0d77a-8aca-4f04-b55e-45899decea01','b4a0d77a-8aca-4f04-b55e-45899decea01','0ee3b61db0254b40bc85214e7d348538','3fb8d4a8278546deacbbb6d960f5b0bb',1,'tempest-tempest-created-share-792716644','Tempest\'s share','cdd68b8f-be76-4491-bcdc-990526be471f','CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-23 19:00:42.238941','2026-01-23 19:01:08.213159','2026-01-23 19:01:08.212640','b7e6ccd3-b475-4741-95bf-f79468206c11','b7e6ccd3-b475-4741-95bf-f79468206c11','558d317bd62542eb9fe7a15800c7d18f','7976ff17c3f840919d65487c1a87daad',1,'tempest-tempest-created-share-503519110','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:00:28.390359','2026-01-23 19:00:36.220305','2026-01-23 19:00:36.219815','b8bebdc7-0681-4493-b749-f6ba99e6588b','b8bebdc7-0681-4493-b749-f6ba99e6588b','03a60d2561c74d4285401ee890fe82a9','9e708dc344a64ca294a4473db436e198',3,'tempest-tempest-created-share-135006551','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:02:16.525483','2026-01-23 19:02:30.774384','2026-01-23 19:02:30.773966','ba284aa9-66e4-45a0-8056-c16cce3c54ad','ba284aa9-66e4-45a0-8056-c16cce3c54ad','cf78c38e3f6f4cae977f3610c4befcd9','dcaebac10d574ce2aa3ba16906fd5dbc',1,'tempest-share-450683816','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:00:20.590204','2026-01-23 19:00:24.571721','2026-01-23 19:00:24.571123','bbabf70e-3352-413a-bdd1-d9721e768900','bbabf70e-3352-413a-bdd1-d9721e768900','c1c8384de14c4a31ae08ff4e69a1c9bb','dcb726ed64514381891686f89d347595',1,'tempest-tempest-created-share-1564100347','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:04:22.562857','2026-01-23 19:04:34.666968','2026-01-23 19:04:34.666685','c5ec9c35-4d7c-4fc8-b621-d53247587e9c','c5ec9c35-4d7c-4fc8-b621-d53247587e9c','97e5b5856f774106be398a432c1a2e3a','e523821f05f24ee683a3bef9e5423573',1,'public_share - must be visible to all projects in the cloud','public_share_desc',NULL,'CEPHFS',1,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:01:51.415972','2026-01-23 19:01:55.399469','2026-01-23 19:01:55.398880','cb1c2ffc-c624-4f86-bab1-ad8814d0d029','cb1c2ffc-c624-4f86-bab1-ad8814d0d029','52e73d5a04a341b6a7e0bdd3001b9a03','e9255972eb454fca909aa1528e4f83a2',1,'tempest-tempest-created-share-1782989214','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:00:24.631849','2026-01-23 19:00:32.658340','2026-01-23 19:00:32.657971','cd71c963-62da-4024-9a5f-ee995db00e8e','cd71c963-62da-4024-9a5f-ee995db00e8e','03a60d2561c74d4285401ee890fe82a9','9e708dc344a64ca294a4473db436e198',4,'tempest-tempest-created-share-1332520729','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:02:24.969168','2026-01-23 19:02:30.362101','2026-01-23 19:02:30.361392','ce5d5adc-fe46-4e48-83cf-a608b2bd061e','ce5d5adc-fe46-4e48-83cf-a608b2bd061e','48aab17447ce4d90a8a1db613f1ea646','f2beea25a5e947aab5d0bb53058124cf',1,'tempest-tempest-created-share-967383561','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:04:52.093103','2026-01-23 19:04:57.939372','2026-01-23 19:04:57.938772','d0a208d6-678f-49b1-b388-ee4a0edb5c52','d0a208d6-678f-49b1-b388-ee4a0edb5c52','eeabb00740a8442eb5cb3065882b8ff9','6333b89cc67749f896506316d34639f6',1,'tempest-tempest-created-share-102502334','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:08:05.178346','2026-01-23 19:09:01.176802','2026-01-23 19:09:01.176237','d24254b0-53ec-4084-8545-391802f0a833','d24254b0-53ec-4084-8545-391802f0a833','06cf53b820e34c74b5ed6e38f590535c','b17f9a502db941108eaa44a3e9aa605c',1,'tempest-tempest-share-name-1756243115','tempest-tempest-share-description-2042582844',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-23 19:03:53.089070','2026-01-23 19:03:57.590623','2026-01-23 19:03:57.590158','d3d7082d-d3b5-4f70-ac80-ec0346fa5547','d3d7082d-d3b5-4f70-ac80-ec0346fa5547','fd03ddd06d374af6aaab5af51dd14875','5ed6311cb89a4e81ac3637cb0a3cdbbe',1,'tempest-tempest-share-name-1843379678','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:07:16.124789','2026-01-23 19:08:38.505196','2026-01-23 19:08:38.504831','d4df52fc-5514-4f2f-adf6-7e0a4fb0f9c6','d4df52fc-5514-4f2f-adf6-7e0a4fb0f9c6','77520b512b09481594399d1d447d3353','998a3a4c23934c4dafb2e2112ce1af90',1,'tempest-tempest-share-name-726940165','tempest-tempest-share-description-111260921',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-23 19:04:42.932488','2026-01-23 19:04:48.155595','2026-01-23 19:04:48.155255','d6447ad8-5951-4450-ab89-7af9a5180737','d6447ad8-5951-4450-ab89-7af9a5180737','0cdc36ee00844d51a9bfb80f7be4a983','6e81efcadc1a4938a53855b68f0acfd2',1,'tempest-tempest-created-share-395884256','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:03:47.890606','2026-01-23 19:03:51.608963','2026-01-23 19:03:51.608620','dbac94e4-a674-42d5-a070-37b6c59282db','dbac94e4-a674-42d5-a070-37b6c59282db','2fbff2750c964489941186e6647353bd','08f0ac3daf4849ccbfe15d2f731f4f1f',1,'tempest-tempest-created-share-1519913889','tempest-tempest-created-share-desc-2118134218',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:00:12.097988','2026-01-23 19:00:18.906551','2026-01-23 19:00:18.906171','dd9103b6-9748-41da-9bdc-cbd2c6fcd0d7','dd9103b6-9748-41da-9bdc-cbd2c6fcd0d7','64a77c2b0c554249a8bbe5c298b6f1ba','4c762eee821b41d1a7ec9015bb92a684',1,'tempest-tempest-created-share-394590633','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:08:22.933386','2026-01-23 19:08:28.066648','2026-01-23 19:08:28.066351','e2d2d17f-a5c7-4419-8e2a-29f8cd7104e8','e2d2d17f-a5c7-4419-8e2a-29f8cd7104e8','77520b512b09481594399d1d447d3353','998a3a4c23934c4dafb2e2112ce1af90',1,'tempest-tempest-created-share-1450133182','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-23 19:03:22.117589','2026-01-23 19:03:26.134887','2026-01-23 19:03:26.134217','e3437183-3378-4616-9647-d91c796bea3e','e3437183-3378-4616-9647-d91c796bea3e','b3ec277fe4624b46b687bc78d7cf6a03','3f9725edbd1b4cf299e129c2c7587203',1,'tempest-tempest-created-share-1270952509','tempest-tempest-created-share-desc-461910163',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:02:16.649940','2026-01-23 19:02:21.792199','2026-01-23 19:02:21.791693','e4b2c96d-a4ff-40fc-9b17-291106bf282c','e4b2c96d-a4ff-40fc-9b17-291106bf282c','d4699fb6f80746b4a636ab8962e102d0','538e549e0d1e4309a3c16b3a4f48e842',1,'tempest-tempest-created-share-2066542062','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:03:40.705882','2026-01-23 19:04:08.051114','2026-01-23 19:04:08.050680','e9348c7b-8056-43c2-88d5-4ea6f5c6b0c6','e9348c7b-8056-43c2-88d5-4ea6f5c6b0c6','fd03ddd06d374af6aaab5af51dd14875','5ed6311cb89a4e81ac3637cb0a3cdbbe',1,'tempest-tempest-share-name-284603282','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:04:26.804385','2026-01-23 19:04:30.820777','2026-01-23 19:04:30.820395','eb3d3e12-5a94-47ea-9820-bf28b2fbcb9a','eb3d3e12-5a94-47ea-9820-bf28b2fbcb9a','1a04690e8f284aa39ed37e0b6aa7b3ee','5d979c3ed74a492981b806cb6f7d0021',1,'private_share','private share in the primary user project',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:05:57.175591','2026-01-23 19:06:07.003164','2026-01-23 19:06:07.002767','ec07c5de-032d-4294-a579-616d0c9c5cc9','ec07c5de-032d-4294-a579-616d0c9c5cc9','7a1a35011363435a8a558e98e87b8831','ef50bedea4bc4cfd892c55fa7305015f',1,'tempest-tempest-created-share-56822107','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-23 19:02:17.526698','2026-01-23 19:02:21.945223','2026-01-23 19:02:21.944839','ffe680b4-30d4-4706-b8cf-657ed9c2476e','ffe680b4-30d4-4706-b8cf-657ed9c2476e','48aab17447ce4d90a8a1db613f1ea646','f2beea25a5e947aab5d0bb53058124cf',1,'tempest-tempest-created-share-1404429817','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL);
/*!40000 ALTER TABLE `shares` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `resource_id` varchar(36) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime(6) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
INSERT INTO `transfers` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `resource_id`, `resource_type`, `display_name`, `salt`, `crypt_hash`, `expires_at`, `source_project_id`, `destination_project_id`, `accepted`) VALUES ('18aa61c2-2d6a-4571-90e0-daaec2affe32','2026-01-23 19:06:30.048633','2026-01-23 19:06:30.816673','2026-01-23 19:06:30.816670','1','ab471169-de9b-4160-affe-e7fd580570d1','share','tempest-tempest-created-share-transfer-886285801','ccb8ce5e','579d6bc14045c5c41732acb750e36efff812b5b32f4a4b5cb6434035f6112c4e','2026-01-23 19:11:30.047703','5ce1c1cb978d4655b95674240227e033','1e5a07e60ba9416db9dd4733653459eb',1),('4c2e4332-33f6-4880-b054-5af9e83bfe63','2026-01-23 19:03:48.346804',NULL,'2026-01-23 19:03:48.747530','4c2e4332-33f6-4880-b054-5af9e83bfe63','29d694db-1498-45de-818b-999e5140dad6','share','tempest-tempest-created-share-transfer-2010124895','d8b0d185','c935925f1d5a73b316cf98056b44e9c0bde800e2e77f131e519207a7cbe2f326','2026-01-23 19:08:48.344689','5ed6311cb89a4e81ac3637cb0a3cdbbe',NULL,0),('94cb7025-1bee-4378-a644-1de67dfd6f36','2026-01-23 19:03:56.410715',NULL,'2026-01-23 19:03:56.718535','94cb7025-1bee-4378-a644-1de67dfd6f36','d3d7082d-d3b5-4f70-ac80-ec0346fa5547','share','tempest-tempest-created-share-transfer-570866392','81e34ce8','14020921151aa1ed6b60a8561fa3b4128dcc120416322ea5d331615449252a27','2026-01-23 19:08:56.409697','5ed6311cb89a4e81ac3637cb0a3cdbbe',NULL,0),('c6ec663b-ab5c-40d4-a459-b4f71b1825ce','2026-01-23 19:03:52.560853',NULL,'2026-01-23 19:03:52.855313','c6ec663b-ab5c-40d4-a459-b4f71b1825ce','39284e92-1b49-4324-96db-4c5831010bf3','share','tempest-tempest-created-share-transfer-227073369','b9e3a308','ad5208525a7e2ac1b0252ef05e4040a38f4f3697943d4865a27f2df61dba1e47','2026-01-23 19:08:52.558707','5ed6311cb89a4e81ac3637cb0a3cdbbe',NULL,0),('d2105032-565c-45b4-8a5f-2c51093044b3','2026-01-23 19:06:37.986017',NULL,'2026-01-23 19:06:38.597030','d2105032-565c-45b4-8a5f-2c51093044b3','b4308187-b5c6-41cc-9f65-4b5ef066d494','share','tempest_share_transfer','e2bb8b15','ff9ec6c7e474ad2c0eda165f3be0ade7fcd72401f1f8b0427f436a639f44945d','2026-01-23 19:11:37.984699','5ce1c1cb978d4655b95674240227e033',NULL,0),('e26cda3f-3869-405c-86bc-d479d57f9dc7','2026-01-23 19:03:44.138258',NULL,'2026-01-23 19:03:44.722129','e26cda3f-3869-405c-86bc-d479d57f9dc7','e9348c7b-8056-43c2-88d5-4ea6f5c6b0c6','share','tempest-tempest-created-share-transfer-354209023','8ad6faa0','3d4655a7adce9f4866d9acee4bebdde77c3cb2e671bac0c863915ec9d8209beb','2026-01-23 19:08:44.134944','5ed6311cb89a4e81ac3637cb0a3cdbbe',NULL,0);
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','placement','placement_c9ab','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','keystone','keystone_4388','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_c9ab','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_4388','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','glance','glance_8c35','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_8c35','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_f7e0','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_f7e0','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_0a4f','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_0a4f','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_301c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_301c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_9fa7','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_9fa7','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_90e1','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_90e1','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','manila','manila_aa79','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','manila','manila_aa79','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1769192422}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1769192422}'),('localhost','placement_c9ab','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B4110B0B16190E1A0F1AAD7BDE65740F2918F5DB\",\"password_last_changed\":1769192405}'),('localhost','keystone_4388','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*9840C7D14E57F38A56D7A53C990C447C32F4BAFF\",\"password_last_changed\":1769192405}'),('%','placement_c9ab','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B4110B0B16190E1A0F1AAD7BDE65740F2918F5DB\",\"password_last_changed\":1769192405}'),('%','keystone_4388','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*9840C7D14E57F38A56D7A53C990C447C32F4BAFF\",\"password_last_changed\":1769192405}'),('localhost','glance_8c35','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*91244C8D42B65EF03B55CD81197F4CAAACD60246\",\"password_last_changed\":1769192411}'),('%','glance_8c35','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*91244C8D42B65EF03B55CD81197F4CAAACD60246\",\"password_last_changed\":1769192411}'),('localhost','barbican_f7e0','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*DE5C401D69E9342981C0A9A7191589AA85C91579\",\"password_last_changed\":1769192443}'),('%','barbican_f7e0','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*DE5C401D69E9342981C0A9A7191589AA85C91579\",\"password_last_changed\":1769192443}'),('localhost','cinder_0a4f','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*41D2B85963A289A27FBDB39C3FA256E72548BF05\",\"password_last_changed\":1769192443}'),('%','cinder_0a4f','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*41D2B85963A289A27FBDB39C3FA256E72548BF05\",\"password_last_changed\":1769192444}'),('localhost','neutron_301c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*40F1508C07C8D104475ED9516C232EC83A863C86\",\"password_last_changed\":1769192444}'),('%','neutron_301c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*40F1508C07C8D104475ED9516C232EC83A863C86\",\"password_last_changed\":1769192444}'),('localhost','nova_cell0_9fa7','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*39BD4F8B3343A7497D880F7A0BE7AA3E3D628B8E\",\"password_last_changed\":1769192538}'),('%','nova_cell0_9fa7','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*39BD4F8B3343A7497D880F7A0BE7AA3E3D628B8E\",\"password_last_changed\":1769192538}'),('localhost','nova_api_90e1','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*DC9209D78231799544D9885F74E29D1E15D5E5A7\",\"password_last_changed\":1769192539}'),('%','nova_api_90e1','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*DC9209D78231799544D9885F74E29D1E15D5E5A7\",\"password_last_changed\":1769192539}'),('localhost','manila_aa79','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B8FEE640CAF37E54783F81148054BD7AAA82471C\",\"password_last_changed\":1769194452}'),('%','manila_aa79','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B8FEE640CAF37E54783F81148054BD7AAA82471C\",\"password_last_changed\":1769194452}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mysql_plugin\n-----------