/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('c853b78a-fcca-401f-9288-e0a6dc29d7af','2026-02-28 09:21:34','2026-02-28 09:21:34',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','dbaa378e-7ebb-4c4a-ab99-4a58de15dee0','2026-02-28 09:21:24','2026-02-28 09:21:24',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('dbaa378e-7ebb-4c4a-ab99-4a58de15dee0','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2026-02-28 09:21:24','2026-02-28 09:21:24',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2026-02-28 09:21:23',NULL,NULL,0,1,'default','volumes',10),('2026-02-28 09:21:23',NULL,NULL,0,2,'default','snapshots',10),('2026-02-28 09:21:23',NULL,NULL,0,3,'default','gigabytes',1000),('2026-02-28 09:21:23',NULL,NULL,0,4,'default','consistencygroups',10),('2026-02-28 09:21:23',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2026-02-28 09:21:23',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2026-02-28 09:21:35','2026-02-28 11:18:09',NULL,0,1,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',695,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'bd2324ef-52dc-4398-930d-ee72019e1823'),('2026-02-28 09:51:19','2026-02-28 11:18:12',NULL,0,2,'cinder-backup-0','cinder-backup','cinder-backup',521,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'5310b5d1-3d4b-42cf-b7e3-bbd58c39920f'),('2026-02-28 09:51:19','2026-02-28 11:18:11',NULL,0,3,'hostgroup@ceph','cinder-volume','cinder-volume',521,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'9963e89e-b7e6-40ed-ac0b-99c9c80d9224');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2026-02-28 09:21:24','2026-02-28 09:21:24',NULL,0,'04e5ff7c-00ea-42d1-b5b5-a1f96feab1eb','__DEFAULT__',NULL,1,'Default Volume Type');
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2026-02-28 09:21:24','2026-02-28 09:21:24.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'ceb167e8-5ad0-4fa3-bcff-a4573362f9a0','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/ceb167e8-5ad0-4fa3-bcff-a4573362f9a0/snap','2026-02-28 09:55:57','2026-02-28 09:56:08','2026-02-28 09:56:08',1,'{\"store\": \"default_backend\"}','deleted'),(2,'69bde4b7-947e-4c9f-8b55-96fa18b7208d','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/69bde4b7-947e-4c9f-8b55-96fa18b7208d/snap','2026-02-28 09:55:59','2026-02-28 09:56:12','2026-02-28 09:56:12',1,'{\"store\": \"default_backend\"}','deleted'),(3,'acaa20bc-4ba4-4568-8d34-510237f0abb5','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/acaa20bc-4ba4-4568-8d34-510237f0abb5/snap','2026-02-28 09:56:27','2026-02-28 10:50:45','2026-02-28 10:50:45',1,'{\"store\": \"default_backend\"}','deleted'),(4,'f3755b31-d5fb-4f1b-9b58-6260fd65fc72','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/f3755b31-d5fb-4f1b-9b58-6260fd65fc72/snap','2026-02-28 09:58:17','2026-02-28 10:52:53','2026-02-28 10:52:53',1,'{\"store\": \"default_backend\"}','deleted'),(5,'88971623-4808-4102-a4a7-34a287d8b7fe','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/88971623-4808-4102-a4a7-34a287d8b7fe/snap','2026-02-28 09:58:19','2026-02-28 10:52:56','2026-02-28 10:52:56',1,'{\"store\": \"default_backend\"}','deleted'),(6,'2faaae0a-1f52-46d5-96e2-689c416dab4c','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/2faaae0a-1f52-46d5-96e2-689c416dab4c/snap','2026-02-28 10:02:15','2026-02-28 10:02:18','2026-02-28 10:02:18',1,'{\"store\": \"default_backend\"}','deleted'),(7,'342ed071-b7ab-43f1-b140-4013b177d36b','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/342ed071-b7ab-43f1-b140-4013b177d36b/snap','2026-02-28 10:03:39','2026-02-28 10:03:56','2026-02-28 10:03:56',1,'{\"store\": \"default_backend\"}','deleted'),(8,'15834e2d-0d53-4b8a-8f0b-345fe662dcbf','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/15834e2d-0d53-4b8a-8f0b-345fe662dcbf/snap','2026-02-28 10:04:35','2026-02-28 10:04:37','2026-02-28 10:04:37',1,'{\"store\": \"default_backend\"}','deleted'),(9,'60ad6e6b-14e8-4ec6-9e02-5b68cbfcac60','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/60ad6e6b-14e8-4ec6-9e02-5b68cbfcac60/snap','2026-02-28 10:05:12','2026-02-28 10:05:13','2026-02-28 10:05:13',1,'{\"store\": \"default_backend\"}','deleted'),(10,'830ebb40-f7a7-4e0f-9487-d755555148cb','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/830ebb40-f7a7-4e0f-9487-d755555148cb/snap','2026-02-28 10:05:34','2026-02-28 10:05:37','2026-02-28 10:05:37',1,'{\"store\": \"default_backend\"}','deleted'),(11,'38cb5514-6684-4136-959d-9444907f6bfa','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/38cb5514-6684-4136-959d-9444907f6bfa/snap','2026-02-28 10:05:59','2026-02-28 10:06:28','2026-02-28 10:06:28',1,'{\"store\": \"default_backend\"}','deleted'),(12,'64671ca6-d66f-48a8-9905-66fd8ae90fc9','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/64671ca6-d66f-48a8-9905-66fd8ae90fc9/snap','2026-02-28 10:08:31','2026-02-28 10:08:33','2026-02-28 10:08:33',1,'{\"store\": \"default_backend\"}','deleted'),(13,'d6f9704e-a041-47c4-bed1-6ca11061c49a','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/d6f9704e-a041-47c4-bed1-6ca11061c49a/snap','2026-02-28 10:08:42','2026-02-28 10:08:46','2026-02-28 10:08:46',1,'{\"store\": \"default_backend\"}','deleted'),(14,'d2b40a95-7ba7-4bd1-9cd5-7b6bd9ab0b87','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/d2b40a95-7ba7-4bd1-9cd5-7b6bd9ab0b87/snap','2026-02-28 10:09:08','2026-02-28 10:10:16','2026-02-28 10:10:16',1,'{\"store\": \"default_backend\"}','deleted'),(15,'7a38b1bc-ebc5-4262-9991-4c580b461c0a','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/7a38b1bc-ebc5-4262-9991-4c580b461c0a/snap','2026-02-28 10:09:12','2026-02-28 10:10:13','2026-02-28 10:10:13',1,'{\"store\": \"default_backend\"}','deleted'),(16,'928e81a1-3ac7-4b82-94e8-2be945cb3d36','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/928e81a1-3ac7-4b82-94e8-2be945cb3d36/snap','2026-02-28 10:09:15','2026-02-28 10:10:09','2026-02-28 10:10:09',1,'{\"store\": \"default_backend\"}','deleted'),(17,'bd212f15-02ac-422d-b109-19f5cd1e442e','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/bd212f15-02ac-422d-b109-19f5cd1e442e/snap','2026-02-28 10:09:29','2026-02-28 10:09:39','2026-02-28 10:09:39',1,'{\"store\": \"default_backend\"}','deleted'),(18,'9ce992ef-e998-43ea-9bd4-8cdaf2841ea4','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/9ce992ef-e998-43ea-9bd4-8cdaf2841ea4/snap','2026-02-28 10:09:33','2026-02-28 10:09:59','2026-02-28 10:09:59',1,'{\"store\": \"default_backend\"}','deleted'),(19,'7f101383-680e-4e57-98bb-8ecf7964ef03','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/7f101383-680e-4e57-98bb-8ecf7964ef03/snap','2026-02-28 10:09:35','2026-02-28 10:09:37','2026-02-28 10:09:37',1,'{\"store\": \"default_backend\"}','deleted'),(20,'fdddffc1-692d-46e3-8fbc-eca1a14df1a2','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/fdddffc1-692d-46e3-8fbc-eca1a14df1a2/snap','2026-02-28 10:09:41','2026-02-28 10:09:57','2026-02-28 10:09:57',1,'{\"store\": \"default_backend\"}','deleted'),(21,'b452f76e-84b8-461a-8b95-21b09f41396c','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/b452f76e-84b8-461a-8b95-21b09f41396c/snap','2026-02-28 10:09:48','2026-02-28 10:09:56','2026-02-28 10:09:56',1,'{\"store\": \"default_backend\"}','deleted'),(22,'342d07d0-ce6e-40be-938e-c99ef1da978f','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/342d07d0-ce6e-40be-938e-c99ef1da978f/snap','2026-02-28 10:10:16','2026-02-28 10:10:27','2026-02-28 10:10:27',1,'{\"store\": \"default_backend\"}','deleted'),(23,'566c962b-ab07-4ea4-8c4a-daa71c23c042','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/566c962b-ab07-4ea4-8c4a-daa71c23c042/snap','2026-02-28 10:10:53','2026-02-28 10:11:16','2026-02-28 10:11:16',1,'{\"store\": \"default_backend\"}','deleted'),(24,'31c8918a-4cbd-4459-b04d-e55d79f71575','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/31c8918a-4cbd-4459-b04d-e55d79f71575/snap','2026-02-28 10:11:05','2026-02-28 10:11:19','2026-02-28 10:11:19',1,'{\"store\": \"default_backend\"}','deleted'),(25,'a3ff9934-08db-4bb8-903b-7c981dea1b00','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/a3ff9934-08db-4bb8-903b-7c981dea1b00/snap','2026-02-28 10:11:14','2026-02-28 10:11:18','2026-02-28 10:11:18',1,'{\"store\": \"default_backend\"}','deleted'),(26,'a76de62a-d69e-4c03-92ec-aaff7623c365','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/a76de62a-d69e-4c03-92ec-aaff7623c365/snap','2026-02-28 10:12:09','2026-02-28 10:12:57','2026-02-28 10:12:57',1,'{\"store\": \"default_backend\"}','deleted'),(27,'337de210-963f-41af-92a4-16b5716eae17','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/337de210-963f-41af-92a4-16b5716eae17/snap','2026-02-28 10:12:28','2026-02-28 10:12:53','2026-02-28 10:12:53',1,'{\"store\": \"default_backend\"}','deleted'),(28,'22a70b75-075f-4875-bc53-299afbb39f44','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/22a70b75-075f-4875-bc53-299afbb39f44/snap','2026-02-28 10:16:50','2026-02-28 10:17:19','2026-02-28 10:17:19',1,'{\"store\": \"default_backend\"}','deleted'),(29,'1583781d-ec8c-4060-a2ad-53d52445d23e','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/1583781d-ec8c-4060-a2ad-53d52445d23e/snap','2026-02-28 10:19:53','2026-02-28 10:20:11','2026-02-28 10:20:11',1,'{\"store\": \"default_backend\"}','deleted'),(30,'818dfec7-2d43-4696-a4bb-91240db544c9','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/818dfec7-2d43-4696-a4bb-91240db544c9/snap','2026-02-28 10:20:10','2026-02-28 10:20:12','2026-02-28 10:20:12',1,'{\"store\": \"default_backend\"}','deleted'),(31,'e7cdbd31-c9ec-472e-9e30-4697be3ffc7a','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/e7cdbd31-c9ec-472e-9e30-4697be3ffc7a/snap','2026-02-28 10:23:23','2026-02-28 10:23:29','2026-02-28 10:23:29',1,'{\"store\": \"default_backend\"}','deleted'),(32,'f5079d19-e128-4eef-85f9-01a7c15d6be6','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/f5079d19-e128-4eef-85f9-01a7c15d6be6/snap','2026-02-28 10:23:25','2026-02-28 10:23:27','2026-02-28 10:23:27',1,'{\"store\": \"default_backend\"}','deleted'),(33,'f5580b42-39c5-4447-90bb-f9baf47b726d','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/f5580b42-39c5-4447-90bb-f9baf47b726d/snap','2026-02-28 10:27:19','2026-02-28 10:27:21','2026-02-28 10:27:21',1,'{\"store\": \"default_backend\"}','deleted'),(34,'af4015d7-81af-4d5d-9b4e-0f37f3f2bbfb','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/af4015d7-81af-4d5d-9b4e-0f37f3f2bbfb/snap','2026-02-28 10:27:26','2026-02-28 10:27:39','2026-02-28 10:27:39',1,'{\"store\": \"default_backend\"}','deleted'),(35,'a4838d37-05ed-4203-b692-45939f4c6ad8','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/a4838d37-05ed-4203-b692-45939f4c6ad8/snap','2026-02-28 10:27:27','2026-02-28 10:27:38','2026-02-28 10:27:38',1,'{\"store\": \"default_backend\"}','deleted'),(36,'c9b9e283-ecf7-4f3f-aee1-4c7854409097','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/c9b9e283-ecf7-4f3f-aee1-4c7854409097/snap','2026-02-28 10:27:28','2026-02-28 10:27:37','2026-02-28 10:27:37',1,'{\"store\": \"default_backend\"}','deleted'),(37,'c8cc932b-144c-4a52-84ff-42d3fc1539b3','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/c8cc932b-144c-4a52-84ff-42d3fc1539b3/snap','2026-02-28 10:27:28','2026-02-28 10:27:36','2026-02-28 10:27:36',1,'{\"store\": \"default_backend\"}','deleted'),(38,'24e38daf-a484-45ea-894a-725ec3f04d60','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/24e38daf-a484-45ea-894a-725ec3f04d60/snap','2026-02-28 10:27:30','2026-02-28 10:27:35','2026-02-28 10:27:35',1,'{\"store\": \"default_backend\"}','deleted'),(39,'0a7fb1a8-6af9-40f8-9827-daab8ad70bfc','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/0a7fb1a8-6af9-40f8-9827-daab8ad70bfc/snap','2026-02-28 10:27:31','2026-02-28 10:27:34','2026-02-28 10:27:34',1,'{\"store\": \"default_backend\"}','deleted'),(40,'889a5b88-09b7-4c48-88ed-168ca73ca921','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/889a5b88-09b7-4c48-88ed-168ca73ca921/snap','2026-02-28 10:29:18','2026-02-28 10:30:15','2026-02-28 10:30:15',1,'{\"store\": \"default_backend\"}','deleted'),(41,'4f149197-39c6-4851-9529-9ce8f0064ae9','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/4f149197-39c6-4851-9529-9ce8f0064ae9/snap','2026-02-28 10:30:04','2026-02-28 10:30:06','2026-02-28 10:30:06',1,'{\"store\": \"default_backend\"}','deleted'),(42,'4c20447f-84ff-45ca-86c2-e5ad9d598628','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/4c20447f-84ff-45ca-86c2-e5ad9d598628/snap','2026-02-28 10:48:21','2026-02-28 10:48:37','2026-02-28 10:48:37',1,'{\"store\": \"default_backend\"}','deleted'),(43,'087aef76-8992-43d2-904b-9de16190aade','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/087aef76-8992-43d2-904b-9de16190aade/snap','2026-02-28 10:53:13','2026-02-28 10:55:36','2026-02-28 10:55:36',1,'{\"store\": \"default_backend\"}','deleted'),(44,'7f05bf2a-85ee-4ccc-9a47-1417636e3886','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/7f05bf2a-85ee-4ccc-9a47-1417636e3886/snap','2026-02-28 10:55:01','2026-02-28 11:01:43','2026-02-28 11:01:43',1,'{\"store\": \"default_backend\"}','deleted'),(45,'d0e60e33-a136-40ea-abdc-f49d2250fee7','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/d0e60e33-a136-40ea-abdc-f49d2250fee7/snap','2026-02-28 10:55:03','2026-02-28 11:01:46','2026-02-28 11:01:46',1,'{\"store\": \"default_backend\"}','deleted'),(46,'ad2585f3-a876-4568-a6c7-c739ffe0b007','rbd://8f528268-ea2d-5d7b-af45-49b405fed6de/images/ad2585f3-a876-4568-a6c7-c739ffe0b007/snap','2026-02-28 11:01:51','2026-02-28 11:02:43','2026-02-28 11:02:43',1,'{\"store\": \"default_backend\"}','deleted');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
INSERT INTO `image_members` (`id`, `image_id`, `member`, `can_share`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`) VALUES (1,'25b251cf-d2d3-4791-ac23-4c46c14f375b','5d1af0e2b62848a080d21fbcbd59d88e',0,'2026-02-28 10:09:50','2026-02-28 10:09:50','2026-02-28 10:09:50',1,'accepted'),(2,'0d8dfa14-3b8d-4dbe-937d-25edc1c0fccd','5d1af0e2b62848a080d21fbcbd59d88e',0,'2026-02-28 10:09:51','2026-02-28 10:09:51','2026-02-28 10:09:51',1,'accepted'),(3,'c24456e8-6059-4829-a43c-9748cea729c4','5d1af0e2b62848a080d21fbcbd59d88e',0,'2026-02-28 10:09:52','2026-02-28 10:09:52','2026-02-28 10:09:52',1,'rejected'),(4,'f11b8ff5-5543-44b5-b05a-1bfe58acd828','5d1af0e2b62848a080d21fbcbd59d88e',0,'2026-02-28 10:09:52','2026-02-28 10:09:52','2026-02-28 10:09:52',1,'accepted'),(5,'64da16e2-6a49-482e-be77-e36b9b8b2aad','647c88c7fec948008ce5cd152f2633c2',0,'2026-02-28 10:20:22','2026-02-28 10:20:22','2026-02-28 10:20:22',1,'pending'),(6,'6b233e12-3f74-4230-95e0-5d351ffd62b0','647c88c7fec948008ce5cd152f2633c2',0,'2026-02-28 10:20:22','2026-02-28 10:20:22','2026-02-28 10:20:22',1,'pending'),(7,'f5580b42-39c5-4447-90bb-f9baf47b726d','1a938794f1c34af1b55d1f3e3b7e81a6',0,'2026-02-28 10:27:20','2026-02-28 10:27:21','2026-02-28 10:27:21',1,'pending');
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=466 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'ceb167e8-5ad0-4fa3-bcff-a4573362f9a0','hw_rng_model','virtio','2026-02-28 09:55:54','2026-02-28 09:56:08','2026-02-28 09:56:08',1),(2,'69bde4b7-947e-4c9f-8b55-96fa18b7208d','hw_rng_model','virtio','2026-02-28 09:55:58','2026-02-28 09:56:12','2026-02-28 09:56:12',1),(3,'acaa20bc-4ba4-4568-8d34-510237f0abb5','owner_specified.openstack.md5','','2026-02-28 09:56:23','2026-02-28 10:50:45','2026-02-28 10:50:45',1),(4,'acaa20bc-4ba4-4568-8d34-510237f0abb5','owner_specified.openstack.sha256','','2026-02-28 09:56:23','2026-02-28 10:50:45','2026-02-28 10:50:45',1),(5,'acaa20bc-4ba4-4568-8d34-510237f0abb5','owner_specified.openstack.object','images/cirros-0.6.2-test-operator','2026-02-28 09:56:23','2026-02-28 10:50:45','2026-02-28 10:50:45',1),(6,'acaa20bc-4ba4-4568-8d34-510237f0abb5','os_glance_stage_host','https://glance-default-external-api-0.glance-default-external-api.openstack.svc:9292','2026-02-28 09:56:23','2026-02-28 10:50:45','2026-02-28 10:50:45',1),(8,'acaa20bc-4ba4-4568-8d34-510237f0abb5','os_glance_importing_to_stores','','2026-02-28 09:56:24','2026-02-28 10:50:45','2026-02-28 10:50:45',1),(9,'acaa20bc-4ba4-4568-8d34-510237f0abb5','os_glance_failed_import','','2026-02-28 09:56:24','2026-02-28 10:50:45','2026-02-28 10:50:45',1),(10,'f3755b31-d5fb-4f1b-9b58-6260fd65fc72','hw_rng_model','virtio','2026-02-28 09:58:16','2026-02-28 10:52:53','2026-02-28 10:52:53',1),(11,'88971623-4808-4102-a4a7-34a287d8b7fe','hw_rng_model','virtio','2026-02-28 09:58:17','2026-02-28 10:52:56','2026-02-28 10:52:56',1),(12,'342ed071-b7ab-43f1-b140-4013b177d36b','os_distro','value2','2026-02-28 10:03:40','2026-02-28 10:03:56','2026-02-28 10:03:56',1),(13,'342ed071-b7ab-43f1-b140-4013b177d36b','os_version','alt1','2026-02-28 10:03:40','2026-02-28 10:03:56','2026-02-28 10:03:56',1),(14,'342ed071-b7ab-43f1-b140-4013b177d36b','architecture','value3','2026-02-28 10:03:48','2026-02-28 10:03:56','2026-02-28 10:03:56',1),(15,'15834e2d-0d53-4b8a-8f0b-345fe662dcbf','hw_rng_model','virtio','2026-02-28 10:04:30','2026-02-28 10:04:37','2026-02-28 10:04:37',1),(16,'15834e2d-0d53-4b8a-8f0b-345fe662dcbf','base_image_ref','f3755b31-d5fb-4f1b-9b58-6260fd65fc72','2026-02-28 10:04:30','2026-02-28 10:04:37','2026-02-28 10:04:37',1),(17,'15834e2d-0d53-4b8a-8f0b-345fe662dcbf','owner_user_name','tempest-ImagesTestJSON-2059286278-project-member','2026-02-28 10:04:30','2026-02-28 10:04:37','2026-02-28 10:04:37',1),(18,'15834e2d-0d53-4b8a-8f0b-345fe662dcbf','owner_project_name','tempest-ImagesTestJSON-2059286278','2026-02-28 10:04:30','2026-02-28 10:04:37','2026-02-28 10:04:37',1),(19,'15834e2d-0d53-4b8a-8f0b-345fe662dcbf','boot_roles','member,reader','2026-02-28 10:04:30','2026-02-28 10:04:37','2026-02-28 10:04:37',1),(20,'15834e2d-0d53-4b8a-8f0b-345fe662dcbf','hw_machine_type','q35','2026-02-28 10:04:30','2026-02-28 10:04:37','2026-02-28 10:04:37',1),(21,'15834e2d-0d53-4b8a-8f0b-345fe662dcbf','hw_cdrom_bus','sata','2026-02-28 10:04:30','2026-02-28 10:04:37','2026-02-28 10:04:37',1),(22,'15834e2d-0d53-4b8a-8f0b-345fe662dcbf','hw_disk_bus','virtio','2026-02-28 10:04:30','2026-02-28 10:04:37','2026-02-28 10:04:37',1),(23,'15834e2d-0d53-4b8a-8f0b-345fe662dcbf','hw_input_bus','usb','2026-02-28 10:04:30','2026-02-28 10:04:37','2026-02-28 10:04:37',1),(24,'15834e2d-0d53-4b8a-8f0b-345fe662dcbf','hw_pointer_model','usbtablet','2026-02-28 10:04:30','2026-02-28 10:04:37','2026-02-28 10:04:37',1),(25,'15834e2d-0d53-4b8a-8f0b-345fe662dcbf','hw_video_model','virtio','2026-02-28 10:04:30','2026-02-28 10:04:37','2026-02-28 10:04:37',1),(26,'15834e2d-0d53-4b8a-8f0b-345fe662dcbf','hw_vif_model','virtio','2026-02-28 10:04:30','2026-02-28 10:04:37','2026-02-28 10:04:37',1),(27,'15834e2d-0d53-4b8a-8f0b-345fe662dcbf','instance_uuid','9ba2ebb5-d13a-4778-bb5b-46e42d2c49ab','2026-02-28 10:04:30','2026-02-28 10:04:37','2026-02-28 10:04:37',1),(28,'15834e2d-0d53-4b8a-8f0b-345fe662dcbf','user_id','163582c3e6a34c87b52f82ac4f189f77','2026-02-28 10:04:30','2026-02-28 10:04:37','2026-02-28 10:04:37',1),(29,'15834e2d-0d53-4b8a-8f0b-345fe662dcbf','image_type','snapshot','2026-02-28 10:04:30','2026-02-28 10:04:37','2026-02-28 10:04:37',1),(30,'368a95dc-f2bf-43b2-80e0-562f69f20423','hw_rng_model','virtio','2026-02-28 10:04:31','2026-02-28 10:04:31','2026-02-28 10:04:31',1),(31,'368a95dc-f2bf-43b2-80e0-562f69f20423','base_image_ref','f3755b31-d5fb-4f1b-9b58-6260fd65fc72','2026-02-28 10:04:31','2026-02-28 10:04:31','2026-02-28 10:04:31',1),(32,'368a95dc-f2bf-43b2-80e0-562f69f20423','owner_user_name','tempest-ImagesOneServerNegativeTestJSON-356581433-project-member','2026-02-28 10:04:31','2026-02-28 10:04:31','2026-02-28 10:04:31',1),(33,'368a95dc-f2bf-43b2-80e0-562f69f20423','owner_project_name','tempest-ImagesOneServerNegativeTestJSON-356581433','2026-02-28 10:04:31','2026-02-28 10:04:32','2026-02-28 10:04:32',1),(34,'368a95dc-f2bf-43b2-80e0-562f69f20423','boot_roles','member,reader','2026-02-28 10:04:31','2026-02-28 10:04:32','2026-02-28 10:04:32',1),(35,'368a95dc-f2bf-43b2-80e0-562f69f20423','hw_machine_type','q35','2026-02-28 10:04:31','2026-02-28 10:04:32','2026-02-28 10:04:32',1),(36,'368a95dc-f2bf-43b2-80e0-562f69f20423','hw_cdrom_bus','sata','2026-02-28 10:04:31','2026-02-28 10:04:32','2026-02-28 10:04:32',1),(37,'368a95dc-f2bf-43b2-80e0-562f69f20423','hw_disk_bus','virtio','2026-02-28 10:04:31','2026-02-28 10:04:32','2026-02-28 10:04:32',1),(38,'368a95dc-f2bf-43b2-80e0-562f69f20423','hw_input_bus','usb','2026-02-28 10:04:31','2026-02-28 10:04:32','2026-02-28 10:04:32',1),(39,'368a95dc-f2bf-43b2-80e0-562f69f20423','hw_pointer_model','usbtablet','2026-02-28 10:04:31','2026-02-28 10:04:32','2026-02-28 10:04:32',1),(40,'368a95dc-f2bf-43b2-80e0-562f69f20423','hw_video_model','virtio','2026-02-28 10:04:31','2026-02-28 10:04:32','2026-02-28 10:04:32',1),(41,'368a95dc-f2bf-43b2-80e0-562f69f20423','hw_vif_model','virtio','2026-02-28 10:04:31','2026-02-28 10:04:32','2026-02-28 10:04:32',1),(42,'368a95dc-f2bf-43b2-80e0-562f69f20423','instance_uuid','6d74f9b9-edf7-4d81-b139-cb664b2ab68c','2026-02-28 10:04:31','2026-02-28 10:04:32','2026-02-28 10:04:32',1),(43,'368a95dc-f2bf-43b2-80e0-562f69f20423','user_id','2737540b5d9a437cac0ea91b25f0c5d8','2026-02-28 10:04:31','2026-02-28 10:04:32','2026-02-28 10:04:32',1),(44,'368a95dc-f2bf-43b2-80e0-562f69f20423','image_type','snapshot','2026-02-28 10:04:31','2026-02-28 10:04:32','2026-02-28 10:04:32',1),(45,'15834e2d-0d53-4b8a-8f0b-345fe662dcbf','image_state','available','2026-02-28 10:04:34','2026-02-28 10:04:37','2026-02-28 10:04:37',1),(46,'15834e2d-0d53-4b8a-8f0b-345fe662dcbf','image_location','snapshot','2026-02-28 10:04:34','2026-02-28 10:04:37','2026-02-28 10:04:37',1),(47,'15834e2d-0d53-4b8a-8f0b-345fe662dcbf','owner_id','a2ce6ed219d94b3b88c2d2d7001f6c3a','2026-02-28 10:04:34','2026-02-28 10:04:37','2026-02-28 10:04:37',1),(48,'fb0dbe89-ad99-412d-9a08-eeddbc9f2714','hw_rng_model','virtio','2026-02-28 10:05:02','2026-02-28 10:05:03','2026-02-28 10:05:03',1),(49,'fb0dbe89-ad99-412d-9a08-eeddbc9f2714','base_image_ref','f3755b31-d5fb-4f1b-9b58-6260fd65fc72','2026-02-28 10:05:02','2026-02-28 10:05:03','2026-02-28 10:05:03',1),(50,'fb0dbe89-ad99-412d-9a08-eeddbc9f2714','owner_user_name','tempest-ImagesOneServerNegativeTestJSON-356581433-project-member','2026-02-28 10:05:02','2026-02-28 10:05:03','2026-02-28 10:05:03',1),(51,'fb0dbe89-ad99-412d-9a08-eeddbc9f2714','owner_project_name','tempest-ImagesOneServerNegativeTestJSON-356581433','2026-02-28 10:05:02','2026-02-28 10:05:03','2026-02-28 10:05:03',1),(52,'fb0dbe89-ad99-412d-9a08-eeddbc9f2714','boot_roles','member,reader','2026-02-28 10:05:02','2026-02-28 10:05:03','2026-02-28 10:05:03',1),(53,'fb0dbe89-ad99-412d-9a08-eeddbc9f2714','hw_machine_type','q35','2026-02-28 10:05:02','2026-02-28 10:05:03','2026-02-28 10:05:03',1),(54,'fb0dbe89-ad99-412d-9a08-eeddbc9f2714','hw_cdrom_bus','sata','2026-02-28 10:05:02','2026-02-28 10:05:03','2026-02-28 10:05:03',1),(55,'fb0dbe89-ad99-412d-9a08-eeddbc9f2714','hw_disk_bus','virtio','2026-02-28 10:05:02','2026-02-28 10:05:03','2026-02-28 10:05:03',1),(56,'fb0dbe89-ad99-412d-9a08-eeddbc9f2714','hw_input_bus','usb','2026-02-28 10:05:02','2026-02-28 10:05:03','2026-02-28 10:05:03',1),(57,'fb0dbe89-ad99-412d-9a08-eeddbc9f2714','hw_pointer_model','usbtablet','2026-02-28 10:05:02','2026-02-28 10:05:03','2026-02-28 10:05:03',1),(58,'fb0dbe89-ad99-412d-9a08-eeddbc9f2714','hw_video_model','virtio','2026-02-28 10:05:02','2026-02-28 10:05:03','2026-02-28 10:05:03',1),(59,'fb0dbe89-ad99-412d-9a08-eeddbc9f2714','hw_vif_model','virtio','2026-02-28 10:05:02','2026-02-28 10:05:03','2026-02-28 10:05:03',1),(60,'fb0dbe89-ad99-412d-9a08-eeddbc9f2714','instance_uuid','c1e4150a-4695-4464-a271-378970447180','2026-02-28 10:05:02','2026-02-28 10:05:03','2026-02-28 10:05:03',1),(61,'fb0dbe89-ad99-412d-9a08-eeddbc9f2714','user_id','2737540b5d9a437cac0ea91b25f0c5d8','2026-02-28 10:05:02','2026-02-28 10:05:03','2026-02-28 10:05:03',1),(62,'fb0dbe89-ad99-412d-9a08-eeddbc9f2714','image_type','snapshot','2026-02-28 10:05:02','2026-02-28 10:05:03','2026-02-28 10:05:03',1),(63,'60ad6e6b-14e8-4ec6-9e02-5b68cbfcac60','hw_rng_model','virtio','2026-02-28 10:05:06','2026-02-28 10:05:13','2026-02-28 10:05:13',1),(64,'60ad6e6b-14e8-4ec6-9e02-5b68cbfcac60','base_image_ref','f3755b31-d5fb-4f1b-9b58-6260fd65fc72','2026-02-28 10:05:06','2026-02-28 10:05:13','2026-02-28 10:05:13',1),(65,'60ad6e6b-14e8-4ec6-9e02-5b68cbfcac60','owner_user_name','tempest-ImagesTestJSON-2059286278-project-member','2026-02-28 10:05:06','2026-02-28 10:05:13','2026-02-28 10:05:13',1),(66,'60ad6e6b-14e8-4ec6-9e02-5b68cbfcac60','owner_project_name','tempest-ImagesTestJSON-2059286278','2026-02-28 10:05:06','2026-02-28 10:05:13','2026-02-28 10:05:13',1),(67,'60ad6e6b-14e8-4ec6-9e02-5b68cbfcac60','boot_roles','member,reader','2026-02-28 10:05:06','2026-02-28 10:05:13','2026-02-28 10:05:13',1),(68,'60ad6e6b-14e8-4ec6-9e02-5b68cbfcac60','hw_machine_type','q35','2026-02-28 10:05:06','2026-02-28 10:05:13','2026-02-28 10:05:13',1),(69,'60ad6e6b-14e8-4ec6-9e02-5b68cbfcac60','hw_cdrom_bus','sata','2026-02-28 10:05:06','2026-02-28 10:05:13','2026-02-28 10:05:13',1),(70,'60ad6e6b-14e8-4ec6-9e02-5b68cbfcac60','hw_disk_bus','virtio','2026-02-28 10:05:06','2026-02-28 10:05:13','2026-02-28 10:05:13',1),(71,'60ad6e6b-14e8-4ec6-9e02-5b68cbfcac60','hw_input_bus','usb','2026-02-28 10:05:06','2026-02-28 10:05:13','2026-02-28 10:05:13',1),(72,'60ad6e6b-14e8-4ec6-9e02-5b68cbfcac60','hw_pointer_model','usbtablet','2026-02-28 10:05:06','2026-02-28 10:05:13','2026-02-28 10:05:13',1),(73,'60ad6e6b-14e8-4ec6-9e02-5b68cbfcac60','hw_video_model','virtio','2026-02-28 10:05:06','2026-02-28 10:05:13','2026-02-28 10:05:13',1),(74,'60ad6e6b-14e8-4ec6-9e02-5b68cbfcac60','hw_vif_model','virtio','2026-02-28 10:05:06','2026-02-28 10:05:13','2026-02-28 10:05:13',1),(75,'60ad6e6b-14e8-4ec6-9e02-5b68cbfcac60','instance_uuid','ff5bf118-ea06-44c0-81f0-0a229162e1d8','2026-02-28 10:05:06','2026-02-28 10:05:13','2026-02-28 10:05:13',1),(76,'60ad6e6b-14e8-4ec6-9e02-5b68cbfcac60','user_id','163582c3e6a34c87b52f82ac4f189f77','2026-02-28 10:05:06','2026-02-28 10:05:13','2026-02-28 10:05:13',1),(77,'60ad6e6b-14e8-4ec6-9e02-5b68cbfcac60','image_type','snapshot','2026-02-28 10:05:06','2026-02-28 10:05:13','2026-02-28 10:05:13',1),(78,'60ad6e6b-14e8-4ec6-9e02-5b68cbfcac60','image_state','available','2026-02-28 10:05:11','2026-02-28 10:05:13','2026-02-28 10:05:13',1),(79,'60ad6e6b-14e8-4ec6-9e02-5b68cbfcac60','image_location','snapshot','2026-02-28 10:05:11','2026-02-28 10:05:13','2026-02-28 10:05:13',1),(80,'60ad6e6b-14e8-4ec6-9e02-5b68cbfcac60','owner_id','a2ce6ed219d94b3b88c2d2d7001f6c3a','2026-02-28 10:05:11','2026-02-28 10:05:13','2026-02-28 10:05:13',1),(81,'830ebb40-f7a7-4e0f-9487-d755555148cb','hw_rng_model','virtio','2026-02-28 10:05:28','2026-02-28 10:05:37','2026-02-28 10:05:37',1),(82,'830ebb40-f7a7-4e0f-9487-d755555148cb','base_image_ref','f3755b31-d5fb-4f1b-9b58-6260fd65fc72','2026-02-28 10:05:28','2026-02-28 10:05:37','2026-02-28 10:05:37',1),(83,'830ebb40-f7a7-4e0f-9487-d755555148cb','owner_user_name','tempest-ImagesTestJSON-2059286278-project-member','2026-02-28 10:05:28','2026-02-28 10:05:37','2026-02-28 10:05:37',1),(84,'830ebb40-f7a7-4e0f-9487-d755555148cb','owner_project_name','tempest-ImagesTestJSON-2059286278','2026-02-28 10:05:28','2026-02-28 10:05:37','2026-02-28 10:05:37',1),(85,'830ebb40-f7a7-4e0f-9487-d755555148cb','boot_roles','member,reader','2026-02-28 10:05:28','2026-02-28 10:05:37','2026-02-28 10:05:37',1),(86,'830ebb40-f7a7-4e0f-9487-d755555148cb','hw_machine_type','q35','2026-02-28 10:05:28','2026-02-28 10:05:37','2026-02-28 10:05:37',1),(87,'830ebb40-f7a7-4e0f-9487-d755555148cb','hw_cdrom_bus','sata','2026-02-28 10:05:28','2026-02-28 10:05:37','2026-02-28 10:05:37',1),(88,'830ebb40-f7a7-4e0f-9487-d755555148cb','hw_disk_bus','virtio','2026-02-28 10:05:28','2026-02-28 10:05:37','2026-02-28 10:05:37',1),(89,'830ebb40-f7a7-4e0f-9487-d755555148cb','hw_input_bus','usb','2026-02-28 10:05:28','2026-02-28 10:05:37','2026-02-28 10:05:37',1),(90,'830ebb40-f7a7-4e0f-9487-d755555148cb','hw_pointer_model','usbtablet','2026-02-28 10:05:28','2026-02-28 10:05:37','2026-02-28 10:05:37',1),(91,'830ebb40-f7a7-4e0f-9487-d755555148cb','hw_video_model','virtio','2026-02-28 10:05:28','2026-02-28 10:05:37','2026-02-28 10:05:37',1),(92,'830ebb40-f7a7-4e0f-9487-d755555148cb','hw_vif_model','virtio','2026-02-28 10:05:28','2026-02-28 10:05:37','2026-02-28 10:05:37',1),(93,'830ebb40-f7a7-4e0f-9487-d755555148cb','old_vm_state','active','2026-02-28 10:05:28','2026-02-28 10:05:37','2026-02-28 10:05:37',1),(94,'830ebb40-f7a7-4e0f-9487-d755555148cb','instance_uuid','abcde488-a508-4239-9f40-28af252a1cd3','2026-02-28 10:05:28','2026-02-28 10:05:37','2026-02-28 10:05:37',1),(95,'830ebb40-f7a7-4e0f-9487-d755555148cb','user_id','163582c3e6a34c87b52f82ac4f189f77','2026-02-28 10:05:28','2026-02-28 10:05:37','2026-02-28 10:05:37',1),(96,'830ebb40-f7a7-4e0f-9487-d755555148cb','image_type','snapshot','2026-02-28 10:05:28','2026-02-28 10:05:37','2026-02-28 10:05:37',1),(97,'830ebb40-f7a7-4e0f-9487-d755555148cb','image_state','available','2026-02-28 10:05:33','2026-02-28 10:05:37','2026-02-28 10:05:37',1),(98,'830ebb40-f7a7-4e0f-9487-d755555148cb','image_location','snapshot','2026-02-28 10:05:33','2026-02-28 10:05:38','2026-02-28 10:05:38',1),(99,'830ebb40-f7a7-4e0f-9487-d755555148cb','owner_id','a2ce6ed219d94b3b88c2d2d7001f6c3a','2026-02-28 10:05:33','2026-02-28 10:05:38','2026-02-28 10:05:38',1),(100,'38cb5514-6684-4136-959d-9444907f6bfa','hw_rng_model','virtio','2026-02-28 10:05:54','2026-02-28 10:06:28','2026-02-28 10:06:28',1),(101,'38cb5514-6684-4136-959d-9444907f6bfa','base_image_ref','f3755b31-d5fb-4f1b-9b58-6260fd65fc72','2026-02-28 10:05:54','2026-02-28 10:06:28','2026-02-28 10:06:28',1),(102,'38cb5514-6684-4136-959d-9444907f6bfa','owner_user_name','tempest-ImagesTestJSON-2059286278-project-member','2026-02-28 10:05:54','2026-02-28 10:06:28','2026-02-28 10:06:28',1),(103,'38cb5514-6684-4136-959d-9444907f6bfa','owner_project_name','tempest-ImagesTestJSON-2059286278','2026-02-28 10:05:54','2026-02-28 10:06:28','2026-02-28 10:06:28',1),(104,'38cb5514-6684-4136-959d-9444907f6bfa','boot_roles','member,reader','2026-02-28 10:05:54','2026-02-28 10:06:28','2026-02-28 10:06:28',1),(105,'38cb5514-6684-4136-959d-9444907f6bfa','hw_machine_type','q35','2026-02-28 10:05:54','2026-02-28 10:06:28','2026-02-28 10:06:28',1),(106,'38cb5514-6684-4136-959d-9444907f6bfa','hw_cdrom_bus','sata','2026-02-28 10:05:54','2026-02-28 10:06:28','2026-02-28 10:06:28',1),(107,'38cb5514-6684-4136-959d-9444907f6bfa','hw_disk_bus','virtio','2026-02-28 10:05:54','2026-02-28 10:06:28','2026-02-28 10:06:28',1),(108,'38cb5514-6684-4136-959d-9444907f6bfa','hw_input_bus','usb','2026-02-28 10:05:54','2026-02-28 10:06:28','2026-02-28 10:06:28',1),(109,'38cb5514-6684-4136-959d-9444907f6bfa','hw_pointer_model','usbtablet','2026-02-28 10:05:54','2026-02-28 10:06:28','2026-02-28 10:06:28',1),(110,'38cb5514-6684-4136-959d-9444907f6bfa','hw_video_model','virtio','2026-02-28 10:05:54','2026-02-28 10:06:28','2026-02-28 10:06:28',1),(111,'38cb5514-6684-4136-959d-9444907f6bfa','hw_vif_model','virtio','2026-02-28 10:05:54','2026-02-28 10:06:28','2026-02-28 10:06:28',1),(112,'38cb5514-6684-4136-959d-9444907f6bfa','instance_uuid','a9cfb8a4-5855-4ff2-8afa-3e14094e801e','2026-02-28 10:05:54','2026-02-28 10:06:28','2026-02-28 10:06:28',1),(113,'38cb5514-6684-4136-959d-9444907f6bfa','user_id','163582c3e6a34c87b52f82ac4f189f77','2026-02-28 10:05:54','2026-02-28 10:06:28','2026-02-28 10:06:28',1),(114,'38cb5514-6684-4136-959d-9444907f6bfa','image_type','snapshot','2026-02-28 10:05:54','2026-02-28 10:06:28','2026-02-28 10:06:28',1),(115,'38cb5514-6684-4136-959d-9444907f6bfa','image_state','available','2026-02-28 10:05:58','2026-02-28 10:06:28','2026-02-28 10:06:28',1),(116,'38cb5514-6684-4136-959d-9444907f6bfa','image_location','snapshot','2026-02-28 10:05:58','2026-02-28 10:06:28','2026-02-28 10:06:28',1),(117,'38cb5514-6684-4136-959d-9444907f6bfa','owner_id','a2ce6ed219d94b3b88c2d2d7001f6c3a','2026-02-28 10:05:58','2026-02-28 10:06:28','2026-02-28 10:06:28',1),(118,'04d681c2-17b7-46f1-b55e-50765e3f3f4c','hw_rng_model','virtio','2026-02-28 10:06:45','2026-02-28 10:06:47','2026-02-28 10:06:47',1),(119,'04d681c2-17b7-46f1-b55e-50765e3f3f4c','base_image_ref','f3755b31-d5fb-4f1b-9b58-6260fd65fc72','2026-02-28 10:06:45','2026-02-28 10:06:47','2026-02-28 10:06:47',1),(120,'04d681c2-17b7-46f1-b55e-50765e3f3f4c','owner_user_name','tempest-ImagesTestJSON-2059286278-project-member','2026-02-28 10:06:45','2026-02-28 10:06:47','2026-02-28 10:06:47',1),(121,'04d681c2-17b7-46f1-b55e-50765e3f3f4c','owner_project_name','tempest-ImagesTestJSON-2059286278','2026-02-28 10:06:45','2026-02-28 10:06:47','2026-02-28 10:06:47',1),(122,'04d681c2-17b7-46f1-b55e-50765e3f3f4c','boot_roles','member,reader','2026-02-28 10:06:45','2026-02-28 10:06:47','2026-02-28 10:06:47',1),(123,'04d681c2-17b7-46f1-b55e-50765e3f3f4c','hw_machine_type','q35','2026-02-28 10:06:45','2026-02-28 10:06:47','2026-02-28 10:06:47',1),(124,'04d681c2-17b7-46f1-b55e-50765e3f3f4c','hw_cdrom_bus','sata','2026-02-28 10:06:45','2026-02-28 10:06:47','2026-02-28 10:06:47',1),(125,'04d681c2-17b7-46f1-b55e-50765e3f3f4c','hw_disk_bus','virtio','2026-02-28 10:06:45','2026-02-28 10:06:47','2026-02-28 10:06:47',1),(126,'04d681c2-17b7-46f1-b55e-50765e3f3f4c','hw_input_bus','usb','2026-02-28 10:06:45','2026-02-28 10:06:47','2026-02-28 10:06:47',1),(127,'04d681c2-17b7-46f1-b55e-50765e3f3f4c','hw_pointer_model','usbtablet','2026-02-28 10:06:45','2026-02-28 10:06:47','2026-02-28 10:06:47',1),(128,'04d681c2-17b7-46f1-b55e-50765e3f3f4c','hw_video_model','virtio','2026-02-28 10:06:45','2026-02-28 10:06:47','2026-02-28 10:06:47',1),(129,'04d681c2-17b7-46f1-b55e-50765e3f3f4c','hw_vif_model','virtio','2026-02-28 10:06:45','2026-02-28 10:06:47','2026-02-28 10:06:47',1),(130,'04d681c2-17b7-46f1-b55e-50765e3f3f4c','instance_uuid','07582da6-e482-439d-b147-937e74817014','2026-02-28 10:06:45','2026-02-28 10:06:47','2026-02-28 10:06:47',1),(131,'04d681c2-17b7-46f1-b55e-50765e3f3f4c','user_id','163582c3e6a34c87b52f82ac4f189f77','2026-02-28 10:06:45','2026-02-28 10:06:47','2026-02-28 10:06:47',1),(132,'04d681c2-17b7-46f1-b55e-50765e3f3f4c','image_type','snapshot','2026-02-28 10:06:45','2026-02-28 10:06:47','2026-02-28 10:06:47',1),(133,'64671ca6-d66f-48a8-9905-66fd8ae90fc9','hw_rng_model','virtio','2026-02-28 10:08:25','2026-02-28 10:08:33','2026-02-28 10:08:33',1),(134,'64671ca6-d66f-48a8-9905-66fd8ae90fc9','base_image_ref','f3755b31-d5fb-4f1b-9b58-6260fd65fc72','2026-02-28 10:08:25','2026-02-28 10:08:33','2026-02-28 10:08:33',1),(135,'64671ca6-d66f-48a8-9905-66fd8ae90fc9','owner_user_name','tempest-ImagesOneServerTestJSON-1749734354-project-member','2026-02-28 10:08:25','2026-02-28 10:08:33','2026-02-28 10:08:33',1),(136,'64671ca6-d66f-48a8-9905-66fd8ae90fc9','owner_project_name','tempest-ImagesOneServerTestJSON-1749734354','2026-02-28 10:08:25','2026-02-28 10:08:33','2026-02-28 10:08:33',1),(137,'64671ca6-d66f-48a8-9905-66fd8ae90fc9','boot_roles','member,reader','2026-02-28 10:08:25','2026-02-28 10:08:33','2026-02-28 10:08:33',1),(138,'64671ca6-d66f-48a8-9905-66fd8ae90fc9','hw_machine_type','q35','2026-02-28 10:08:25','2026-02-28 10:08:33','2026-02-28 10:08:33',1),(139,'64671ca6-d66f-48a8-9905-66fd8ae90fc9','hw_cdrom_bus','sata','2026-02-28 10:08:25','2026-02-28 10:08:33','2026-02-28 10:08:33',1),(140,'64671ca6-d66f-48a8-9905-66fd8ae90fc9','hw_disk_bus','virtio','2026-02-28 10:08:25','2026-02-28 10:08:33','2026-02-28 10:08:33',1),(141,'64671ca6-d66f-48a8-9905-66fd8ae90fc9','hw_input_bus','usb','2026-02-28 10:08:25','2026-02-28 10:08:33','2026-02-28 10:08:33',1),(142,'64671ca6-d66f-48a8-9905-66fd8ae90fc9','hw_pointer_model','usbtablet','2026-02-28 10:08:25','2026-02-28 10:08:33','2026-02-28 10:08:33',1),(143,'64671ca6-d66f-48a8-9905-66fd8ae90fc9','hw_video_model','virtio','2026-02-28 10:08:25','2026-02-28 10:08:33','2026-02-28 10:08:33',1),(144,'64671ca6-d66f-48a8-9905-66fd8ae90fc9','hw_vif_model','virtio','2026-02-28 10:08:25','2026-02-28 10:08:33','2026-02-28 10:08:33',1),(145,'64671ca6-d66f-48a8-9905-66fd8ae90fc9','instance_uuid','bbbba0d8-fff9-4f59-ab31-54ff03b71390','2026-02-28 10:08:25','2026-02-28 10:08:33','2026-02-28 10:08:33',1),(146,'64671ca6-d66f-48a8-9905-66fd8ae90fc9','user_id','5db9d3a48c914c5ea9326b6a8c8c0f36','2026-02-28 10:08:25','2026-02-28 10:08:33','2026-02-28 10:08:33',1),(147,'64671ca6-d66f-48a8-9905-66fd8ae90fc9','image_type','test','2026-02-28 10:08:25','2026-02-28 10:08:33','2026-02-28 10:08:33',1),(148,'64671ca6-d66f-48a8-9905-66fd8ae90fc9','image_state','available','2026-02-28 10:08:30','2026-02-28 10:08:33','2026-02-28 10:08:33',1),(149,'64671ca6-d66f-48a8-9905-66fd8ae90fc9','image_location','snapshot','2026-02-28 10:08:30','2026-02-28 10:08:33','2026-02-28 10:08:33',1),(150,'64671ca6-d66f-48a8-9905-66fd8ae90fc9','owner_id','3b8b0d675b3747fd80cb2186e41d2ebf','2026-02-28 10:08:30','2026-02-28 10:08:33','2026-02-28 10:08:33',1),(151,'d6f9704e-a041-47c4-bed1-6ca11061c49a','hw_rng_model','virtio','2026-02-28 10:08:35','2026-02-28 10:08:46','2026-02-28 10:08:46',1),(152,'d6f9704e-a041-47c4-bed1-6ca11061c49a','base_image_ref','f3755b31-d5fb-4f1b-9b58-6260fd65fc72','2026-02-28 10:08:35','2026-02-28 10:08:46','2026-02-28 10:08:46',1),(153,'d6f9704e-a041-47c4-bed1-6ca11061c49a','owner_user_name','tempest-ImagesOneServerTestJSON-1749734354-project-member','2026-02-28 10:08:35','2026-02-28 10:08:46','2026-02-28 10:08:46',1),(154,'d6f9704e-a041-47c4-bed1-6ca11061c49a','owner_project_name','tempest-ImagesOneServerTestJSON-1749734354','2026-02-28 10:08:35','2026-02-28 10:08:46','2026-02-28 10:08:46',1),(155,'d6f9704e-a041-47c4-bed1-6ca11061c49a','boot_roles','member,reader','2026-02-28 10:08:35','2026-02-28 10:08:46','2026-02-28 10:08:46',1),(156,'d6f9704e-a041-47c4-bed1-6ca11061c49a','hw_machine_type','q35','2026-02-28 10:08:35','2026-02-28 10:08:46','2026-02-28 10:08:46',1),(157,'d6f9704e-a041-47c4-bed1-6ca11061c49a','hw_cdrom_bus','sata','2026-02-28 10:08:35','2026-02-28 10:08:46','2026-02-28 10:08:46',1),(158,'d6f9704e-a041-47c4-bed1-6ca11061c49a','hw_disk_bus','virtio','2026-02-28 10:08:35','2026-02-28 10:08:46','2026-02-28 10:08:46',1),(159,'d6f9704e-a041-47c4-bed1-6ca11061c49a','hw_input_bus','usb','2026-02-28 10:08:35','2026-02-28 10:08:46','2026-02-28 10:08:46',1),(160,'d6f9704e-a041-47c4-bed1-6ca11061c49a','hw_pointer_model','usbtablet','2026-02-28 10:08:35','2026-02-28 10:08:46','2026-02-28 10:08:46',1),(161,'d6f9704e-a041-47c4-bed1-6ca11061c49a','hw_video_model','virtio','2026-02-28 10:08:35','2026-02-28 10:08:46','2026-02-28 10:08:46',1),(162,'d6f9704e-a041-47c4-bed1-6ca11061c49a','hw_vif_model','virtio','2026-02-28 10:08:35','2026-02-28 10:08:46','2026-02-28 10:08:46',1),(163,'d6f9704e-a041-47c4-bed1-6ca11061c49a','instance_uuid','bbbba0d8-fff9-4f59-ab31-54ff03b71390','2026-02-28 10:08:35','2026-02-28 10:08:46','2026-02-28 10:08:46',1),(164,'d6f9704e-a041-47c4-bed1-6ca11061c49a','user_id','5db9d3a48c914c5ea9326b6a8c8c0f36','2026-02-28 10:08:35','2026-02-28 10:08:46','2026-02-28 10:08:46',1),(165,'d6f9704e-a041-47c4-bed1-6ca11061c49a','image_type','snapshot','2026-02-28 10:08:35','2026-02-28 10:08:46','2026-02-28 10:08:46',1),(166,'d6f9704e-a041-47c4-bed1-6ca11061c49a','image_state','available','2026-02-28 10:08:41','2026-02-28 10:08:46','2026-02-28 10:08:46',1),(167,'d6f9704e-a041-47c4-bed1-6ca11061c49a','image_location','snapshot','2026-02-28 10:08:41','2026-02-28 10:08:46','2026-02-28 10:08:46',1),(168,'d6f9704e-a041-47c4-bed1-6ca11061c49a','owner_id','3b8b0d675b3747fd80cb2186e41d2ebf','2026-02-28 10:08:41','2026-02-28 10:08:46','2026-02-28 10:08:46',1),(169,'bd212f15-02ac-422d-b109-19f5cd1e442e','ramdisk_id','00000000-1111-2222-3333-444455556666','2026-02-28 10:09:27','2026-02-28 10:09:39','2026-02-28 10:09:39',1),(170,'bd212f15-02ac-422d-b109-19f5cd1e442e','os_glance_stage_host','https://glance-default-external-api-0.glance-default-external-api.openstack.svc:9292','2026-02-28 10:09:27','2026-02-28 10:09:39','2026-02-28 10:09:39',1),(172,'bd212f15-02ac-422d-b109-19f5cd1e442e','os_glance_importing_to_stores','','2026-02-28 10:09:28','2026-02-28 10:09:39','2026-02-28 10:09:39',1),(173,'bd212f15-02ac-422d-b109-19f5cd1e442e','os_glance_failed_import','','2026-02-28 10:09:28','2026-02-28 10:09:39','2026-02-28 10:09:39',1),(174,'9ce992ef-e998-43ea-9bd4-8cdaf2841ea4','hw_rng_model','virtio','2026-02-28 10:09:28','2026-02-28 10:09:59','2026-02-28 10:09:59',1),(175,'9ce992ef-e998-43ea-9bd4-8cdaf2841ea4','base_image_ref','f3755b31-d5fb-4f1b-9b58-6260fd65fc72','2026-02-28 10:09:28','2026-02-28 10:09:59','2026-02-28 10:09:59',1),(176,'9ce992ef-e998-43ea-9bd4-8cdaf2841ea4','owner_user_name','tempest-ListImageFiltersTestJSON-1834030841-project-member','2026-02-28 10:09:28','2026-02-28 10:09:59','2026-02-28 10:09:59',1),(177,'9ce992ef-e998-43ea-9bd4-8cdaf2841ea4','owner_project_name','tempest-ListImageFiltersTestJSON-1834030841','2026-02-28 10:09:28','2026-02-28 10:09:59','2026-02-28 10:09:59',1),(178,'9ce992ef-e998-43ea-9bd4-8cdaf2841ea4','boot_roles','member,reader','2026-02-28 10:09:28','2026-02-28 10:09:59','2026-02-28 10:09:59',1),(179,'9ce992ef-e998-43ea-9bd4-8cdaf2841ea4','hw_machine_type','q35','2026-02-28 10:09:28','2026-02-28 10:09:59','2026-02-28 10:09:59',1),(180,'9ce992ef-e998-43ea-9bd4-8cdaf2841ea4','hw_cdrom_bus','sata','2026-02-28 10:09:28','2026-02-28 10:09:59','2026-02-28 10:09:59',1),(181,'9ce992ef-e998-43ea-9bd4-8cdaf2841ea4','hw_disk_bus','virtio','2026-02-28 10:09:28','2026-02-28 10:09:59','2026-02-28 10:09:59',1),(182,'9ce992ef-e998-43ea-9bd4-8cdaf2841ea4','hw_input_bus','usb','2026-02-28 10:09:28','2026-02-28 10:09:59','2026-02-28 10:09:59',1),(183,'9ce992ef-e998-43ea-9bd4-8cdaf2841ea4','hw_pointer_model','usbtablet','2026-02-28 10:09:28','2026-02-28 10:09:59','2026-02-28 10:09:59',1),(184,'9ce992ef-e998-43ea-9bd4-8cdaf2841ea4','hw_video_model','virtio','2026-02-28 10:09:28','2026-02-28 10:09:59','2026-02-28 10:09:59',1),(185,'9ce992ef-e998-43ea-9bd4-8cdaf2841ea4','hw_vif_model','virtio','2026-02-28 10:09:28','2026-02-28 10:09:59','2026-02-28 10:09:59',1),(186,'9ce992ef-e998-43ea-9bd4-8cdaf2841ea4','instance_uuid','9098ebf3-e36c-492b-9c50-dc6f0078794d','2026-02-28 10:09:28','2026-02-28 10:09:59','2026-02-28 10:09:59',1),(187,'9ce992ef-e998-43ea-9bd4-8cdaf2841ea4','user_id','7b7f4fcc1d0d41f59aed36b3de16f8e2','2026-02-28 10:09:28','2026-02-28 10:09:59','2026-02-28 10:09:59',1),(188,'9ce992ef-e998-43ea-9bd4-8cdaf2841ea4','image_type','snapshot','2026-02-28 10:09:28','2026-02-28 10:09:59','2026-02-28 10:09:59',1),(189,'7f101383-680e-4e57-98bb-8ecf7964ef03','ramdisk_id','00000000-1111-2222-3333-444455556666','2026-02-28 10:09:30','2026-02-28 10:09:37','2026-02-28 10:09:37',1),(191,'7f101383-680e-4e57-98bb-8ecf7964ef03','os_glance_importing_to_stores','','2026-02-28 10:09:31','2026-02-28 10:09:37','2026-02-28 10:09:37',1),(192,'7f101383-680e-4e57-98bb-8ecf7964ef03','os_glance_failed_import','','2026-02-28 10:09:31','2026-02-28 10:09:37','2026-02-28 10:09:37',1),(193,'9ce992ef-e998-43ea-9bd4-8cdaf2841ea4','image_state','available','2026-02-28 10:09:33','2026-02-28 10:09:59','2026-02-28 10:09:59',1),(194,'9ce992ef-e998-43ea-9bd4-8cdaf2841ea4','image_location','snapshot','2026-02-28 10:09:33','2026-02-28 10:09:59','2026-02-28 10:09:59',1),(195,'9ce992ef-e998-43ea-9bd4-8cdaf2841ea4','owner_id','6a54f983c0fa466f9e11947f104ed5ca','2026-02-28 10:09:33','2026-02-28 10:09:59','2026-02-28 10:09:59',1),(196,'fdddffc1-692d-46e3-8fbc-eca1a14df1a2','hw_rng_model','virtio','2026-02-28 10:09:36','2026-02-28 10:09:57','2026-02-28 10:09:57',1),(197,'fdddffc1-692d-46e3-8fbc-eca1a14df1a2','base_image_ref','f3755b31-d5fb-4f1b-9b58-6260fd65fc72','2026-02-28 10:09:36','2026-02-28 10:09:57','2026-02-28 10:09:57',1),(198,'fdddffc1-692d-46e3-8fbc-eca1a14df1a2','owner_user_name','tempest-ListImageFiltersTestJSON-1834030841-project-member','2026-02-28 10:09:36','2026-02-28 10:09:57','2026-02-28 10:09:57',1),(199,'fdddffc1-692d-46e3-8fbc-eca1a14df1a2','owner_project_name','tempest-ListImageFiltersTestJSON-1834030841','2026-02-28 10:09:36','2026-02-28 10:09:57','2026-02-28 10:09:57',1),(200,'fdddffc1-692d-46e3-8fbc-eca1a14df1a2','boot_roles','member,reader','2026-02-28 10:09:36','2026-02-28 10:09:57','2026-02-28 10:09:57',1),(201,'fdddffc1-692d-46e3-8fbc-eca1a14df1a2','hw_machine_type','q35','2026-02-28 10:09:36','2026-02-28 10:09:57','2026-02-28 10:09:57',1),(202,'fdddffc1-692d-46e3-8fbc-eca1a14df1a2','hw_cdrom_bus','sata','2026-02-28 10:09:36','2026-02-28 10:09:57','2026-02-28 10:09:57',1),(203,'fdddffc1-692d-46e3-8fbc-eca1a14df1a2','hw_disk_bus','virtio','2026-02-28 10:09:36','2026-02-28 10:09:57','2026-02-28 10:09:57',1),(204,'fdddffc1-692d-46e3-8fbc-eca1a14df1a2','hw_input_bus','usb','2026-02-28 10:09:36','2026-02-28 10:09:57','2026-02-28 10:09:57',1),(205,'fdddffc1-692d-46e3-8fbc-eca1a14df1a2','hw_pointer_model','usbtablet','2026-02-28 10:09:36','2026-02-28 10:09:57','2026-02-28 10:09:57',1),(206,'fdddffc1-692d-46e3-8fbc-eca1a14df1a2','hw_video_model','virtio','2026-02-28 10:09:36','2026-02-28 10:09:57','2026-02-28 10:09:57',1),(207,'fdddffc1-692d-46e3-8fbc-eca1a14df1a2','hw_vif_model','virtio','2026-02-28 10:09:36','2026-02-28 10:09:57','2026-02-28 10:09:57',1),(208,'fdddffc1-692d-46e3-8fbc-eca1a14df1a2','instance_uuid','226b6da4-15c9-4d10-ab4d-194b313446f9','2026-02-28 10:09:36','2026-02-28 10:09:57','2026-02-28 10:09:57',1),(209,'fdddffc1-692d-46e3-8fbc-eca1a14df1a2','user_id','7b7f4fcc1d0d41f59aed36b3de16f8e2','2026-02-28 10:09:36','2026-02-28 10:09:57','2026-02-28 10:09:57',1),(210,'fdddffc1-692d-46e3-8fbc-eca1a14df1a2','image_type','snapshot','2026-02-28 10:09:36','2026-02-28 10:09:57','2026-02-28 10:09:57',1),(211,'fdddffc1-692d-46e3-8fbc-eca1a14df1a2','image_state','available','2026-02-28 10:09:40','2026-02-28 10:09:57','2026-02-28 10:09:57',1),(212,'fdddffc1-692d-46e3-8fbc-eca1a14df1a2','image_location','snapshot','2026-02-28 10:09:40','2026-02-28 10:09:57','2026-02-28 10:09:57',1),(213,'fdddffc1-692d-46e3-8fbc-eca1a14df1a2','owner_id','6a54f983c0fa466f9e11947f104ed5ca','2026-02-28 10:09:40','2026-02-28 10:09:57','2026-02-28 10:09:57',1),(214,'b452f76e-84b8-461a-8b95-21b09f41396c','hw_rng_model','virtio','2026-02-28 10:09:43','2026-02-28 10:09:56','2026-02-28 10:09:56',1),(215,'b452f76e-84b8-461a-8b95-21b09f41396c','base_image_ref','f3755b31-d5fb-4f1b-9b58-6260fd65fc72','2026-02-28 10:09:43','2026-02-28 10:09:56','2026-02-28 10:09:56',1),(216,'b452f76e-84b8-461a-8b95-21b09f41396c','owner_user_name','tempest-ListImageFiltersTestJSON-1834030841-project-member','2026-02-28 10:09:43','2026-02-28 10:09:56','2026-02-28 10:09:56',1),(217,'b452f76e-84b8-461a-8b95-21b09f41396c','owner_project_name','tempest-ListImageFiltersTestJSON-1834030841','2026-02-28 10:09:43','2026-02-28 10:09:56','2026-02-28 10:09:56',1),(218,'b452f76e-84b8-461a-8b95-21b09f41396c','boot_roles','member,reader','2026-02-28 10:09:43','2026-02-28 10:09:56','2026-02-28 10:09:56',1),(219,'b452f76e-84b8-461a-8b95-21b09f41396c','hw_machine_type','q35','2026-02-28 10:09:43','2026-02-28 10:09:56','2026-02-28 10:09:56',1),(220,'b452f76e-84b8-461a-8b95-21b09f41396c','hw_cdrom_bus','sata','2026-02-28 10:09:43','2026-02-28 10:09:56','2026-02-28 10:09:56',1),(221,'b452f76e-84b8-461a-8b95-21b09f41396c','hw_disk_bus','virtio','2026-02-28 10:09:43','2026-02-28 10:09:56','2026-02-28 10:09:56',1),(222,'b452f76e-84b8-461a-8b95-21b09f41396c','hw_input_bus','usb','2026-02-28 10:09:43','2026-02-28 10:09:56','2026-02-28 10:09:56',1),(223,'b452f76e-84b8-461a-8b95-21b09f41396c','hw_pointer_model','usbtablet','2026-02-28 10:09:43','2026-02-28 10:09:56','2026-02-28 10:09:56',1),(224,'b452f76e-84b8-461a-8b95-21b09f41396c','hw_video_model','virtio','2026-02-28 10:09:43','2026-02-28 10:09:56','2026-02-28 10:09:56',1),(225,'b452f76e-84b8-461a-8b95-21b09f41396c','hw_vif_model','virtio','2026-02-28 10:09:43','2026-02-28 10:09:56','2026-02-28 10:09:56',1),(226,'b452f76e-84b8-461a-8b95-21b09f41396c','instance_uuid','9098ebf3-e36c-492b-9c50-dc6f0078794d','2026-02-28 10:09:43','2026-02-28 10:09:56','2026-02-28 10:09:56',1),(227,'b452f76e-84b8-461a-8b95-21b09f41396c','user_id','7b7f4fcc1d0d41f59aed36b3de16f8e2','2026-02-28 10:09:43','2026-02-28 10:09:56','2026-02-28 10:09:56',1),(228,'b452f76e-84b8-461a-8b95-21b09f41396c','image_type','snapshot','2026-02-28 10:09:43','2026-02-28 10:09:56','2026-02-28 10:09:56',1),(229,'b452f76e-84b8-461a-8b95-21b09f41396c','image_state','available','2026-02-28 10:09:48','2026-02-28 10:09:56','2026-02-28 10:09:56',1),(230,'b452f76e-84b8-461a-8b95-21b09f41396c','image_location','snapshot','2026-02-28 10:09:48','2026-02-28 10:09:56','2026-02-28 10:09:56',1),(231,'b452f76e-84b8-461a-8b95-21b09f41396c','owner_id','6a54f983c0fa466f9e11947f104ed5ca','2026-02-28 10:09:48','2026-02-28 10:09:56','2026-02-28 10:09:56',1),(232,'342d07d0-ce6e-40be-938e-c99ef1da978f','hw_rng_model','virtio','2026-02-28 10:09:56','2026-02-28 10:10:27','2026-02-28 10:10:27',1),(233,'342d07d0-ce6e-40be-938e-c99ef1da978f','base_image_ref','f3755b31-d5fb-4f1b-9b58-6260fd65fc72','2026-02-28 10:09:56','2026-02-28 10:10:27','2026-02-28 10:10:27',1),(234,'342d07d0-ce6e-40be-938e-c99ef1da978f','owner_user_name','tempest-DeleteServersTestJSON-515886650-project-member','2026-02-28 10:09:56','2026-02-28 10:10:27','2026-02-28 10:10:27',1),(235,'342d07d0-ce6e-40be-938e-c99ef1da978f','owner_project_name','tempest-DeleteServersTestJSON-515886650','2026-02-28 10:09:56','2026-02-28 10:10:27','2026-02-28 10:10:27',1),(236,'342d07d0-ce6e-40be-938e-c99ef1da978f','boot_roles','member,reader','2026-02-28 10:09:56','2026-02-28 10:10:27','2026-02-28 10:10:27',1),(237,'342d07d0-ce6e-40be-938e-c99ef1da978f','hw_machine_type','q35','2026-02-28 10:09:56','2026-02-28 10:10:27','2026-02-28 10:10:27',1),(238,'342d07d0-ce6e-40be-938e-c99ef1da978f','hw_cdrom_bus','sata','2026-02-28 10:09:56','2026-02-28 10:10:27','2026-02-28 10:10:27',1),(239,'342d07d0-ce6e-40be-938e-c99ef1da978f','hw_disk_bus','virtio','2026-02-28 10:09:56','2026-02-28 10:10:27','2026-02-28 10:10:27',1),(240,'342d07d0-ce6e-40be-938e-c99ef1da978f','hw_input_bus','usb','2026-02-28 10:09:56','2026-02-28 10:10:27','2026-02-28 10:10:27',1),(241,'342d07d0-ce6e-40be-938e-c99ef1da978f','hw_pointer_model','usbtablet','2026-02-28 10:09:56','2026-02-28 10:10:27','2026-02-28 10:10:27',1),(242,'342d07d0-ce6e-40be-938e-c99ef1da978f','hw_video_model','virtio','2026-02-28 10:09:56','2026-02-28 10:10:27','2026-02-28 10:10:27',1),(243,'342d07d0-ce6e-40be-938e-c99ef1da978f','hw_vif_model','virtio','2026-02-28 10:09:56','2026-02-28 10:10:27','2026-02-28 10:10:27',1),(244,'342d07d0-ce6e-40be-938e-c99ef1da978f','instance_uuid','9633f2a0-e94b-40f8-a1c1-6a9ebf9458be','2026-02-28 10:09:56','2026-02-28 10:10:27','2026-02-28 10:10:27',1),(245,'342d07d0-ce6e-40be-938e-c99ef1da978f','user_id','33855957e5e3480b850c2ddef62a5f89','2026-02-28 10:09:56','2026-02-28 10:10:27','2026-02-28 10:10:27',1),(246,'342d07d0-ce6e-40be-938e-c99ef1da978f','image_type','snapshot','2026-02-28 10:09:56','2026-02-28 10:10:27','2026-02-28 10:10:27',1),(247,'342d07d0-ce6e-40be-938e-c99ef1da978f','image_state','available','2026-02-28 10:10:16','2026-02-28 10:10:27','2026-02-28 10:10:27',1),(248,'342d07d0-ce6e-40be-938e-c99ef1da978f','image_location','snapshot','2026-02-28 10:10:16','2026-02-28 10:10:27','2026-02-28 10:10:27',1),(249,'342d07d0-ce6e-40be-938e-c99ef1da978f','owner_id','a5095f810f0d431788237ae1da262bf6','2026-02-28 10:10:16','2026-02-28 10:10:27','2026-02-28 10:10:27',1),(250,'566c962b-ab07-4ea4-8c4a-daa71c23c042','hw_rng_model','virtio','2026-02-28 10:10:48','2026-02-28 10:11:16','2026-02-28 10:11:16',1),(251,'566c962b-ab07-4ea4-8c4a-daa71c23c042','base_image_ref','f3755b31-d5fb-4f1b-9b58-6260fd65fc72','2026-02-28 10:10:48','2026-02-28 10:11:16','2026-02-28 10:11:16',1),(252,'566c962b-ab07-4ea4-8c4a-daa71c23c042','owner_user_name','tempest-ServerActionsTestOtherB-909812490-project-member','2026-02-28 10:10:48','2026-02-28 10:11:16','2026-02-28 10:11:16',1),(253,'566c962b-ab07-4ea4-8c4a-daa71c23c042','owner_project_name','tempest-ServerActionsTestOtherB-909812490','2026-02-28 10:10:48','2026-02-28 10:11:16','2026-02-28 10:11:16',1),(254,'566c962b-ab07-4ea4-8c4a-daa71c23c042','boot_roles','member,reader','2026-02-28 10:10:48','2026-02-28 10:11:16','2026-02-28 10:11:16',1),(255,'566c962b-ab07-4ea4-8c4a-daa71c23c042','hw_machine_type','q35','2026-02-28 10:10:48','2026-02-28 10:11:16','2026-02-28 10:11:16',1),(256,'566c962b-ab07-4ea4-8c4a-daa71c23c042','hw_cdrom_bus','sata','2026-02-28 10:10:48','2026-02-28 10:11:16','2026-02-28 10:11:16',1),(257,'566c962b-ab07-4ea4-8c4a-daa71c23c042','hw_disk_bus','virtio','2026-02-28 10:10:48','2026-02-28 10:11:16','2026-02-28 10:11:16',1),(258,'566c962b-ab07-4ea4-8c4a-daa71c23c042','hw_input_bus','usb','2026-02-28 10:10:48','2026-02-28 10:11:16','2026-02-28 10:11:16',1),(259,'566c962b-ab07-4ea4-8c4a-daa71c23c042','hw_pointer_model','usbtablet','2026-02-28 10:10:48','2026-02-28 10:11:16','2026-02-28 10:11:16',1),(260,'566c962b-ab07-4ea4-8c4a-daa71c23c042','hw_video_model','virtio','2026-02-28 10:10:48','2026-02-28 10:11:16','2026-02-28 10:11:16',1),(261,'566c962b-ab07-4ea4-8c4a-daa71c23c042','hw_vif_model','virtio','2026-02-28 10:10:48','2026-02-28 10:11:16','2026-02-28 10:11:16',1),(262,'566c962b-ab07-4ea4-8c4a-daa71c23c042','instance_uuid','30a5d845-ce28-490a-afe8-3b7552f02c63','2026-02-28 10:10:48','2026-02-28 10:11:16','2026-02-28 10:11:16',1),(263,'566c962b-ab07-4ea4-8c4a-daa71c23c042','user_id','48e14a77ec8842f98a0d2efc6d5e167f','2026-02-28 10:10:48','2026-02-28 10:11:16','2026-02-28 10:11:16',1),(264,'566c962b-ab07-4ea4-8c4a-daa71c23c042','image_type','backup','2026-02-28 10:10:48','2026-02-28 10:11:16','2026-02-28 10:11:16',1),(265,'566c962b-ab07-4ea4-8c4a-daa71c23c042','backup_type','daily','2026-02-28 10:10:48','2026-02-28 10:11:16','2026-02-28 10:11:16',1),(266,'566c962b-ab07-4ea4-8c4a-daa71c23c042','image_state','available','2026-02-28 10:10:52','2026-02-28 10:11:16','2026-02-28 10:11:16',1),(267,'566c962b-ab07-4ea4-8c4a-daa71c23c042','image_location','snapshot','2026-02-28 10:10:52','2026-02-28 10:11:16','2026-02-28 10:11:16',1),(268,'566c962b-ab07-4ea4-8c4a-daa71c23c042','owner_id','cffbbb9857954b188c363e9565817bf2','2026-02-28 10:10:52','2026-02-28 10:11:16','2026-02-28 10:11:16',1),(269,'31c8918a-4cbd-4459-b04d-e55d79f71575','hw_rng_model','virtio','2026-02-28 10:11:00','2026-02-28 10:11:19','2026-02-28 10:11:19',1),(270,'31c8918a-4cbd-4459-b04d-e55d79f71575','base_image_ref','f3755b31-d5fb-4f1b-9b58-6260fd65fc72','2026-02-28 10:11:00','2026-02-28 10:11:19','2026-02-28 10:11:19',1),(271,'31c8918a-4cbd-4459-b04d-e55d79f71575','owner_user_name','tempest-ServerActionsTestOtherB-909812490-project-member','2026-02-28 10:11:00','2026-02-28 10:11:19','2026-02-28 10:11:19',1),(272,'31c8918a-4cbd-4459-b04d-e55d79f71575','owner_project_name','tempest-ServerActionsTestOtherB-909812490','2026-02-28 10:11:00','2026-02-28 10:11:19','2026-02-28 10:11:19',1),(273,'31c8918a-4cbd-4459-b04d-e55d79f71575','boot_roles','member,reader','2026-02-28 10:11:00','2026-02-28 10:11:19','2026-02-28 10:11:19',1),(274,'31c8918a-4cbd-4459-b04d-e55d79f71575','hw_machine_type','q35','2026-02-28 10:11:00','2026-02-28 10:11:19','2026-02-28 10:11:19',1),(275,'31c8918a-4cbd-4459-b04d-e55d79f71575','hw_cdrom_bus','sata','2026-02-28 10:11:00','2026-02-28 10:11:19','2026-02-28 10:11:19',1),(276,'31c8918a-4cbd-4459-b04d-e55d79f71575','hw_disk_bus','virtio','2026-02-28 10:11:00','2026-02-28 10:11:19','2026-02-28 10:11:19',1),(277,'31c8918a-4cbd-4459-b04d-e55d79f71575','hw_input_bus','usb','2026-02-28 10:11:00','2026-02-28 10:11:19','2026-02-28 10:11:19',1),(278,'31c8918a-4cbd-4459-b04d-e55d79f71575','hw_pointer_model','usbtablet','2026-02-28 10:11:00','2026-02-28 10:11:19','2026-02-28 10:11:19',1),(279,'31c8918a-4cbd-4459-b04d-e55d79f71575','hw_video_model','virtio','2026-02-28 10:11:00','2026-02-28 10:11:19','2026-02-28 10:11:19',1),(280,'31c8918a-4cbd-4459-b04d-e55d79f71575','hw_vif_model','virtio','2026-02-28 10:11:00','2026-02-28 10:11:19','2026-02-28 10:11:19',1),(281,'31c8918a-4cbd-4459-b04d-e55d79f71575','instance_uuid','30a5d845-ce28-490a-afe8-3b7552f02c63','2026-02-28 10:11:00','2026-02-28 10:11:19','2026-02-28 10:11:19',1),(282,'31c8918a-4cbd-4459-b04d-e55d79f71575','user_id','48e14a77ec8842f98a0d2efc6d5e167f','2026-02-28 10:11:00','2026-02-28 10:11:19','2026-02-28 10:11:19',1),(283,'31c8918a-4cbd-4459-b04d-e55d79f71575','image_type','backup','2026-02-28 10:11:00','2026-02-28 10:11:19','2026-02-28 10:11:19',1),(284,'31c8918a-4cbd-4459-b04d-e55d79f71575','backup_type','daily','2026-02-28 10:11:00','2026-02-28 10:11:19','2026-02-28 10:11:19',1),(285,'31c8918a-4cbd-4459-b04d-e55d79f71575','image_state','available','2026-02-28 10:11:04','2026-02-28 10:11:19','2026-02-28 10:11:19',1),(286,'31c8918a-4cbd-4459-b04d-e55d79f71575','image_location','snapshot','2026-02-28 10:11:04','2026-02-28 10:11:19','2026-02-28 10:11:19',1),(287,'31c8918a-4cbd-4459-b04d-e55d79f71575','owner_id','cffbbb9857954b188c363e9565817bf2','2026-02-28 10:11:04','2026-02-28 10:11:19','2026-02-28 10:11:19',1),(288,'a3ff9934-08db-4bb8-903b-7c981dea1b00','hw_rng_model','virtio','2026-02-28 10:11:07','2026-02-28 10:11:18','2026-02-28 10:11:18',1),(289,'a3ff9934-08db-4bb8-903b-7c981dea1b00','base_image_ref','f3755b31-d5fb-4f1b-9b58-6260fd65fc72','2026-02-28 10:11:07','2026-02-28 10:11:18','2026-02-28 10:11:18',1),(290,'a3ff9934-08db-4bb8-903b-7c981dea1b00','owner_user_name','tempest-ServerActionsTestOtherB-909812490-project-member','2026-02-28 10:11:07','2026-02-28 10:11:18','2026-02-28 10:11:18',1),(291,'a3ff9934-08db-4bb8-903b-7c981dea1b00','owner_project_name','tempest-ServerActionsTestOtherB-909812490','2026-02-28 10:11:07','2026-02-28 10:11:18','2026-02-28 10:11:18',1),(292,'a3ff9934-08db-4bb8-903b-7c981dea1b00','boot_roles','member,reader','2026-02-28 10:11:07','2026-02-28 10:11:18','2026-02-28 10:11:18',1),(293,'a3ff9934-08db-4bb8-903b-7c981dea1b00','hw_machine_type','q35','2026-02-28 10:11:07','2026-02-28 10:11:18','2026-02-28 10:11:18',1),(294,'a3ff9934-08db-4bb8-903b-7c981dea1b00','hw_cdrom_bus','sata','2026-02-28 10:11:07','2026-02-28 10:11:18','2026-02-28 10:11:18',1),(295,'a3ff9934-08db-4bb8-903b-7c981dea1b00','hw_disk_bus','virtio','2026-02-28 10:11:07','2026-02-28 10:11:18','2026-02-28 10:11:18',1),(296,'a3ff9934-08db-4bb8-903b-7c981dea1b00','hw_input_bus','usb','2026-02-28 10:11:07','2026-02-28 10:11:18','2026-02-28 10:11:18',1),(297,'a3ff9934-08db-4bb8-903b-7c981dea1b00','hw_pointer_model','usbtablet','2026-02-28 10:11:07','2026-02-28 10:11:18','2026-02-28 10:11:18',1),(298,'a3ff9934-08db-4bb8-903b-7c981dea1b00','hw_video_model','virtio','2026-02-28 10:11:07','2026-02-28 10:11:18','2026-02-28 10:11:18',1),(299,'a3ff9934-08db-4bb8-903b-7c981dea1b00','hw_vif_model','virtio','2026-02-28 10:11:07','2026-02-28 10:11:18','2026-02-28 10:11:18',1),(300,'a3ff9934-08db-4bb8-903b-7c981dea1b00','instance_uuid','30a5d845-ce28-490a-afe8-3b7552f02c63','2026-02-28 10:11:07','2026-02-28 10:11:18','2026-02-28 10:11:18',1),(301,'a3ff9934-08db-4bb8-903b-7c981dea1b00','user_id','48e14a77ec8842f98a0d2efc6d5e167f','2026-02-28 10:11:07','2026-02-28 10:11:18','2026-02-28 10:11:18',1),(302,'a3ff9934-08db-4bb8-903b-7c981dea1b00','image_type','backup','2026-02-28 10:11:07','2026-02-28 10:11:18','2026-02-28 10:11:18',1),(303,'a3ff9934-08db-4bb8-903b-7c981dea1b00','backup_type','daily','2026-02-28 10:11:07','2026-02-28 10:11:18','2026-02-28 10:11:18',1),(304,'a3ff9934-08db-4bb8-903b-7c981dea1b00','image_state','available','2026-02-28 10:11:13','2026-02-28 10:11:18','2026-02-28 10:11:18',1),(305,'a3ff9934-08db-4bb8-903b-7c981dea1b00','image_location','snapshot','2026-02-28 10:11:13','2026-02-28 10:11:18','2026-02-28 10:11:18',1),(306,'a3ff9934-08db-4bb8-903b-7c981dea1b00','owner_id','cffbbb9857954b188c363e9565817bf2','2026-02-28 10:11:13','2026-02-28 10:11:18','2026-02-28 10:11:18',1),(307,'a76de62a-d69e-4c03-92ec-aaff7623c365','hw_rng_model','virtio','2026-02-28 10:12:04','2026-02-28 10:12:57','2026-02-28 10:12:57',1),(308,'a76de62a-d69e-4c03-92ec-aaff7623c365','base_image_ref','f3755b31-d5fb-4f1b-9b58-6260fd65fc72','2026-02-28 10:12:04','2026-02-28 10:12:57','2026-02-28 10:12:57',1),(309,'a76de62a-d69e-4c03-92ec-aaff7623c365','owner_user_name','tempest-ServerActionsTestOtherB-909812490-project-member','2026-02-28 10:12:04','2026-02-28 10:12:57','2026-02-28 10:12:57',1),(310,'a76de62a-d69e-4c03-92ec-aaff7623c365','owner_project_name','tempest-ServerActionsTestOtherB-909812490','2026-02-28 10:12:04','2026-02-28 10:12:57','2026-02-28 10:12:57',1),(311,'a76de62a-d69e-4c03-92ec-aaff7623c365','boot_roles','member,reader','2026-02-28 10:12:04','2026-02-28 10:12:57','2026-02-28 10:12:57',1),(312,'a76de62a-d69e-4c03-92ec-aaff7623c365','hw_machine_type','q35','2026-02-28 10:12:04','2026-02-28 10:12:57','2026-02-28 10:12:57',1),(313,'a76de62a-d69e-4c03-92ec-aaff7623c365','hw_cdrom_bus','sata','2026-02-28 10:12:04','2026-02-28 10:12:57','2026-02-28 10:12:57',1),(314,'a76de62a-d69e-4c03-92ec-aaff7623c365','hw_disk_bus','virtio','2026-02-28 10:12:04','2026-02-28 10:12:57','2026-02-28 10:12:57',1),(315,'a76de62a-d69e-4c03-92ec-aaff7623c365','hw_input_bus','usb','2026-02-28 10:12:04','2026-02-28 10:12:57','2026-02-28 10:12:57',1),(316,'a76de62a-d69e-4c03-92ec-aaff7623c365','hw_pointer_model','usbtablet','2026-02-28 10:12:04','2026-02-28 10:12:57','2026-02-28 10:12:57',1),(317,'a76de62a-d69e-4c03-92ec-aaff7623c365','hw_video_model','virtio','2026-02-28 10:12:04','2026-02-28 10:12:57','2026-02-28 10:12:57',1),(318,'a76de62a-d69e-4c03-92ec-aaff7623c365','hw_vif_model','virtio','2026-02-28 10:12:04','2026-02-28 10:12:57','2026-02-28 10:12:57',1),(319,'a76de62a-d69e-4c03-92ec-aaff7623c365','instance_uuid','56badf5b-d05a-4123-b43c-087a91e0e3b6','2026-02-28 10:12:04','2026-02-28 10:12:57','2026-02-28 10:12:57',1),(320,'a76de62a-d69e-4c03-92ec-aaff7623c365','user_id','48e14a77ec8842f98a0d2efc6d5e167f','2026-02-28 10:12:04','2026-02-28 10:12:57','2026-02-28 10:12:57',1),(321,'a76de62a-d69e-4c03-92ec-aaff7623c365','image_type','snapshot','2026-02-28 10:12:04','2026-02-28 10:12:57','2026-02-28 10:12:57',1),(322,'a76de62a-d69e-4c03-92ec-aaff7623c365','image_state','available','2026-02-28 10:12:09','2026-02-28 10:12:57','2026-02-28 10:12:57',1),(323,'a76de62a-d69e-4c03-92ec-aaff7623c365','image_location','snapshot','2026-02-28 10:12:09','2026-02-28 10:12:57','2026-02-28 10:12:57',1),(324,'a76de62a-d69e-4c03-92ec-aaff7623c365','owner_id','cffbbb9857954b188c363e9565817bf2','2026-02-28 10:12:09','2026-02-28 10:12:57','2026-02-28 10:12:57',1),(325,'337de210-963f-41af-92a4-16b5716eae17','hw_rng_model','virtio','2026-02-28 10:12:20','2026-02-28 10:12:53','2026-02-28 10:12:53',1),(326,'337de210-963f-41af-92a4-16b5716eae17','base_image_ref','f3755b31-d5fb-4f1b-9b58-6260fd65fc72','2026-02-28 10:12:20','2026-02-28 10:12:53','2026-02-28 10:12:53',1),(327,'337de210-963f-41af-92a4-16b5716eae17','owner_user_name','tempest-ServerActionsTestOtherB-909812490-project-member','2026-02-28 10:12:20','2026-02-28 10:12:53','2026-02-28 10:12:53',1),(328,'337de210-963f-41af-92a4-16b5716eae17','owner_project_name','tempest-ServerActionsTestOtherB-909812490','2026-02-28 10:12:20','2026-02-28 10:12:53','2026-02-28 10:12:53',1),(329,'337de210-963f-41af-92a4-16b5716eae17','boot_roles','member,reader','2026-02-28 10:12:20','2026-02-28 10:12:53','2026-02-28 10:12:53',1),(330,'337de210-963f-41af-92a4-16b5716eae17','hw_machine_type','q35','2026-02-28 10:12:20','2026-02-28 10:12:53','2026-02-28 10:12:53',1),(331,'337de210-963f-41af-92a4-16b5716eae17','hw_cdrom_bus','sata','2026-02-28 10:12:20','2026-02-28 10:12:53','2026-02-28 10:12:53',1),(332,'337de210-963f-41af-92a4-16b5716eae17','hw_disk_bus','virtio','2026-02-28 10:12:20','2026-02-28 10:12:53','2026-02-28 10:12:53',1),(333,'337de210-963f-41af-92a4-16b5716eae17','hw_input_bus','usb','2026-02-28 10:12:20','2026-02-28 10:12:53','2026-02-28 10:12:53',1),(334,'337de210-963f-41af-92a4-16b5716eae17','hw_pointer_model','usbtablet','2026-02-28 10:12:20','2026-02-28 10:12:53','2026-02-28 10:12:53',1),(335,'337de210-963f-41af-92a4-16b5716eae17','hw_video_model','virtio','2026-02-28 10:12:20','2026-02-28 10:12:53','2026-02-28 10:12:53',1),(336,'337de210-963f-41af-92a4-16b5716eae17','hw_vif_model','virtio','2026-02-28 10:12:20','2026-02-28 10:12:53','2026-02-28 10:12:53',1),(337,'337de210-963f-41af-92a4-16b5716eae17','instance_uuid','30a5d845-ce28-490a-afe8-3b7552f02c63','2026-02-28 10:12:20','2026-02-28 10:12:53','2026-02-28 10:12:53',1),(338,'337de210-963f-41af-92a4-16b5716eae17','user_id','48e14a77ec8842f98a0d2efc6d5e167f','2026-02-28 10:12:20','2026-02-28 10:12:53','2026-02-28 10:12:53',1),(339,'337de210-963f-41af-92a4-16b5716eae17','image_type','snapshot','2026-02-28 10:12:20','2026-02-28 10:12:53','2026-02-28 10:12:53',1),(340,'337de210-963f-41af-92a4-16b5716eae17','image_state','available','2026-02-28 10:12:27','2026-02-28 10:12:53','2026-02-28 10:12:53',1),(341,'337de210-963f-41af-92a4-16b5716eae17','image_location','snapshot','2026-02-28 10:12:27','2026-02-28 10:12:53','2026-02-28 10:12:53',1),(342,'337de210-963f-41af-92a4-16b5716eae17','owner_id','cffbbb9857954b188c363e9565817bf2','2026-02-28 10:12:27','2026-02-28 10:12:53','2026-02-28 10:12:53',1),(343,'3b21ab4b-c073-46e0-8268-a242c273db0f','hw_rng_model','virtio','2026-02-28 10:13:22','2026-02-28 10:13:23','2026-02-28 10:13:23',1),(344,'3b21ab4b-c073-46e0-8268-a242c273db0f','base_image_ref','f3755b31-d5fb-4f1b-9b58-6260fd65fc72','2026-02-28 10:13:22','2026-02-28 10:13:23','2026-02-28 10:13:23',1),(345,'3b21ab4b-c073-46e0-8268-a242c273db0f','owner_user_name','tempest-ServersAaction247Test-1778300402-project-member','2026-02-28 10:13:22','2026-02-28 10:13:23','2026-02-28 10:13:23',1),(346,'3b21ab4b-c073-46e0-8268-a242c273db0f','owner_project_name','tempest-ServersAaction247Test-1778300402','2026-02-28 10:13:22','2026-02-28 10:13:23','2026-02-28 10:13:23',1),(347,'3b21ab4b-c073-46e0-8268-a242c273db0f','boot_roles','member,reader','2026-02-28 10:13:22','2026-02-28 10:13:23','2026-02-28 10:13:23',1),(348,'3b21ab4b-c073-46e0-8268-a242c273db0f','hw_machine_type','q35','2026-02-28 10:13:22','2026-02-28 10:13:23','2026-02-28 10:13:23',1),(349,'3b21ab4b-c073-46e0-8268-a242c273db0f','hw_cdrom_bus','sata','2026-02-28 10:13:22','2026-02-28 10:13:23','2026-02-28 10:13:23',1),(350,'3b21ab4b-c073-46e0-8268-a242c273db0f','hw_disk_bus','virtio','2026-02-28 10:13:22','2026-02-28 10:13:23','2026-02-28 10:13:23',1),(351,'3b21ab4b-c073-46e0-8268-a242c273db0f','hw_input_bus','usb','2026-02-28 10:13:22','2026-02-28 10:13:23','2026-02-28 10:13:23',1),(352,'3b21ab4b-c073-46e0-8268-a242c273db0f','hw_pointer_model','usbtablet','2026-02-28 10:13:22','2026-02-28 10:13:23','2026-02-28 10:13:23',1),(353,'3b21ab4b-c073-46e0-8268-a242c273db0f','hw_video_model','virtio','2026-02-28 10:13:22','2026-02-28 10:13:23','2026-02-28 10:13:23',1),(354,'3b21ab4b-c073-46e0-8268-a242c273db0f','hw_vif_model','virtio','2026-02-28 10:13:22','2026-02-28 10:13:23','2026-02-28 10:13:23',1),(355,'3b21ab4b-c073-46e0-8268-a242c273db0f','instance_uuid','43abdac9-81fa-437c-8a7c-fb7b1a9ff97f','2026-02-28 10:13:22','2026-02-28 10:13:23','2026-02-28 10:13:23',1),(356,'3b21ab4b-c073-46e0-8268-a242c273db0f','user_id','a11a56ff5fb844d1b03a25da76136c9d','2026-02-28 10:13:22','2026-02-28 10:13:23','2026-02-28 10:13:23',1),(357,'3b21ab4b-c073-46e0-8268-a242c273db0f','image_type','backup','2026-02-28 10:13:22','2026-02-28 10:13:23','2026-02-28 10:13:23',1),(358,'3b21ab4b-c073-46e0-8268-a242c273db0f','backup_type','daily','2026-02-28 10:13:22','2026-02-28 10:13:23','2026-02-28 10:13:23',1),(359,'22a70b75-075f-4875-bc53-299afbb39f44','hw_rng_model','virtio','2026-02-28 10:16:42','2026-02-28 10:17:19','2026-02-28 10:17:19',1),(360,'22a70b75-075f-4875-bc53-299afbb39f44','base_image_ref','f3755b31-d5fb-4f1b-9b58-6260fd65fc72','2026-02-28 10:16:42','2026-02-28 10:17:19','2026-02-28 10:17:19',1),(361,'22a70b75-075f-4875-bc53-299afbb39f44','owner_user_name','tempest-ServersNegativeTestJSON-621636341-project-member','2026-02-28 10:16:42','2026-02-28 10:17:19','2026-02-28 10:17:19',1),(362,'22a70b75-075f-4875-bc53-299afbb39f44','owner_project_name','tempest-ServersNegativeTestJSON-621636341','2026-02-28 10:16:42','2026-02-28 10:17:19','2026-02-28 10:17:19',1),(363,'22a70b75-075f-4875-bc53-299afbb39f44','boot_roles','member,reader','2026-02-28 10:16:42','2026-02-28 10:17:19','2026-02-28 10:17:19',1),(364,'22a70b75-075f-4875-bc53-299afbb39f44','hw_machine_type','q35','2026-02-28 10:16:42','2026-02-28 10:17:19','2026-02-28 10:17:19',1),(365,'22a70b75-075f-4875-bc53-299afbb39f44','hw_cdrom_bus','sata','2026-02-28 10:16:42','2026-02-28 10:17:19','2026-02-28 10:17:19',1),(366,'22a70b75-075f-4875-bc53-299afbb39f44','hw_disk_bus','virtio','2026-02-28 10:16:42','2026-02-28 10:17:19','2026-02-28 10:17:19',1),(367,'22a70b75-075f-4875-bc53-299afbb39f44','hw_input_bus','usb','2026-02-28 10:16:42','2026-02-28 10:17:19','2026-02-28 10:17:19',1),(368,'22a70b75-075f-4875-bc53-299afbb39f44','hw_pointer_model','usbtablet','2026-02-28 10:16:42','2026-02-28 10:17:19','2026-02-28 10:17:19',1),(369,'22a70b75-075f-4875-bc53-299afbb39f44','hw_video_model','virtio','2026-02-28 10:16:42','2026-02-28 10:17:19','2026-02-28 10:17:19',1),(370,'22a70b75-075f-4875-bc53-299afbb39f44','hw_vif_model','virtio','2026-02-28 10:16:42','2026-02-28 10:17:19','2026-02-28 10:17:19',1),(371,'22a70b75-075f-4875-bc53-299afbb39f44','instance_uuid','4db5bcd7-8b41-4850-8c88-89ad757c8558','2026-02-28 10:16:42','2026-02-28 10:17:19','2026-02-28 10:17:19',1),(372,'22a70b75-075f-4875-bc53-299afbb39f44','user_id','7ef51521ffc947cbbce8323ec2b71753','2026-02-28 10:16:42','2026-02-28 10:17:19','2026-02-28 10:17:19',1),(373,'22a70b75-075f-4875-bc53-299afbb39f44','image_type','snapshot','2026-02-28 10:16:42','2026-02-28 10:17:19','2026-02-28 10:17:19',1),(374,'22a70b75-075f-4875-bc53-299afbb39f44','image_state','available','2026-02-28 10:16:50','2026-02-28 10:17:19','2026-02-28 10:17:19',1),(375,'22a70b75-075f-4875-bc53-299afbb39f44','image_location','snapshot','2026-02-28 10:16:50','2026-02-28 10:17:19','2026-02-28 10:17:19',1),(376,'22a70b75-075f-4875-bc53-299afbb39f44','owner_id','c0c4bc44c37f4a4f83c83b6105be3190','2026-02-28 10:16:50','2026-02-28 10:17:19','2026-02-28 10:17:19',1),(377,'818dfec7-2d43-4696-a4bb-91240db544c9','base_image_ref','1583781d-ec8c-4060-a2ad-53d52445d23e','2026-02-28 10:20:06','2026-02-28 10:20:12','2026-02-28 10:20:12',1),(378,'818dfec7-2d43-4696-a4bb-91240db544c9','owner_user_name','tempest-ImageDependencyTests-2065005612-project-member','2026-02-28 10:20:06','2026-02-28 10:20:12','2026-02-28 10:20:12',1),(379,'818dfec7-2d43-4696-a4bb-91240db544c9','owner_project_name','tempest-ImageDependencyTests-2065005612','2026-02-28 10:20:06','2026-02-28 10:20:12','2026-02-28 10:20:12',1),(380,'818dfec7-2d43-4696-a4bb-91240db544c9','boot_roles','member,reader','2026-02-28 10:20:06','2026-02-28 10:20:12','2026-02-28 10:20:12',1),(381,'818dfec7-2d43-4696-a4bb-91240db544c9','hw_machine_type','q35','2026-02-28 10:20:06','2026-02-28 10:20:12','2026-02-28 10:20:12',1),(382,'818dfec7-2d43-4696-a4bb-91240db544c9','hw_cdrom_bus','sata','2026-02-28 10:20:06','2026-02-28 10:20:12','2026-02-28 10:20:12',1),(383,'818dfec7-2d43-4696-a4bb-91240db544c9','hw_disk_bus','virtio','2026-02-28 10:20:06','2026-02-28 10:20:12','2026-02-28 10:20:12',1),(384,'818dfec7-2d43-4696-a4bb-91240db544c9','hw_input_bus','usb','2026-02-28 10:20:06','2026-02-28 10:20:12','2026-02-28 10:20:12',1),(385,'818dfec7-2d43-4696-a4bb-91240db544c9','hw_pointer_model','usbtablet','2026-02-28 10:20:06','2026-02-28 10:20:12','2026-02-28 10:20:12',1),(386,'818dfec7-2d43-4696-a4bb-91240db544c9','hw_video_model','virtio','2026-02-28 10:20:06','2026-02-28 10:20:12','2026-02-28 10:20:12',1),(387,'818dfec7-2d43-4696-a4bb-91240db544c9','hw_vif_model','virtio','2026-02-28 10:20:06','2026-02-28 10:20:12','2026-02-28 10:20:12',1),(388,'818dfec7-2d43-4696-a4bb-91240db544c9','instance_uuid','98504b0a-8c47-4488-b870-9fb9ebfa3e59','2026-02-28 10:20:06','2026-02-28 10:20:12','2026-02-28 10:20:12',1),(389,'818dfec7-2d43-4696-a4bb-91240db544c9','user_id','05780ead76294473ae8c8fc112f7610d','2026-02-28 10:20:06','2026-02-28 10:20:12','2026-02-28 10:20:12',1),(390,'818dfec7-2d43-4696-a4bb-91240db544c9','image_type','snapshot','2026-02-28 10:20:06','2026-02-28 10:20:12','2026-02-28 10:20:12',1),(391,'818dfec7-2d43-4696-a4bb-91240db544c9','image_state','available','2026-02-28 10:20:10','2026-02-28 10:20:12','2026-02-28 10:20:12',1),(392,'818dfec7-2d43-4696-a4bb-91240db544c9','image_location','snapshot','2026-02-28 10:20:10','2026-02-28 10:20:12','2026-02-28 10:20:12',1),(393,'818dfec7-2d43-4696-a4bb-91240db544c9','owner_id','f743c06bc2ae45fda68427b8418baef8','2026-02-28 10:20:10','2026-02-28 10:20:12','2026-02-28 10:20:12',1),(395,'05349771-69a6-40b0-a547-3eb5043c8d01','os_glance_importing_to_stores','','2026-02-28 10:20:29','2026-02-28 10:50:44','2026-02-28 10:50:44',1),(396,'05349771-69a6-40b0-a547-3eb5043c8d01','os_glance_failed_import','default_backend','2026-02-28 10:20:29','2026-02-28 10:50:44','2026-02-28 10:50:44',1),(397,'f5079d19-e128-4eef-85f9-01a7c15d6be6','ramdisk_id','00000000-1111-2222-3333-444455556666','2026-02-28 10:23:24','2026-02-28 10:23:27','2026-02-28 10:23:27',1),(398,'889a5b88-09b7-4c48-88ed-168ca73ca921','hw_rng_model','virtio','2026-02-28 10:29:13','2026-02-28 10:30:15','2026-02-28 10:30:15',1),(399,'889a5b88-09b7-4c48-88ed-168ca73ca921','base_image_ref','f3755b31-d5fb-4f1b-9b58-6260fd65fc72','2026-02-28 10:29:13','2026-02-28 10:30:15','2026-02-28 10:30:15',1),(400,'889a5b88-09b7-4c48-88ed-168ca73ca921','owner_user_name','tempest-TestSnapshotPattern-2121060882-project-member','2026-02-28 10:29:13','2026-02-28 10:30:15','2026-02-28 10:30:15',1),(401,'889a5b88-09b7-4c48-88ed-168ca73ca921','owner_project_name','tempest-TestSnapshotPattern-2121060882','2026-02-28 10:29:13','2026-02-28 10:30:15','2026-02-28 10:30:15',1),(402,'889a5b88-09b7-4c48-88ed-168ca73ca921','boot_roles','member,reader','2026-02-28 10:29:13','2026-02-28 10:30:15','2026-02-28 10:30:15',1),(403,'889a5b88-09b7-4c48-88ed-168ca73ca921','hw_machine_type','q35','2026-02-28 10:29:13','2026-02-28 10:30:15','2026-02-28 10:30:15',1),(404,'889a5b88-09b7-4c48-88ed-168ca73ca921','hw_cdrom_bus','sata','2026-02-28 10:29:13','2026-02-28 10:30:15','2026-02-28 10:30:15',1),(405,'889a5b88-09b7-4c48-88ed-168ca73ca921','hw_disk_bus','virtio','2026-02-28 10:29:13','2026-02-28 10:30:15','2026-02-28 10:30:15',1),(406,'889a5b88-09b7-4c48-88ed-168ca73ca921','hw_input_bus','usb','2026-02-28 10:29:13','2026-02-28 10:30:15','2026-02-28 10:30:15',1),(407,'889a5b88-09b7-4c48-88ed-168ca73ca921','hw_pointer_model','usbtablet','2026-02-28 10:29:13','2026-02-28 10:30:15','2026-02-28 10:30:15',1),(408,'889a5b88-09b7-4c48-88ed-168ca73ca921','hw_video_model','virtio','2026-02-28 10:29:13','2026-02-28 10:30:15','2026-02-28 10:30:15',1),(409,'889a5b88-09b7-4c48-88ed-168ca73ca921','hw_vif_model','virtio','2026-02-28 10:29:13','2026-02-28 10:30:15','2026-02-28 10:30:15',1),(410,'889a5b88-09b7-4c48-88ed-168ca73ca921','instance_uuid','360effe7-8380-410d-a5b8-59c28fa4a75a','2026-02-28 10:29:13','2026-02-28 10:30:15','2026-02-28 10:30:15',1),(411,'889a5b88-09b7-4c48-88ed-168ca73ca921','user_id','f54beab12fce4ee8adf80742bf33b916','2026-02-28 10:29:13','2026-02-28 10:30:15','2026-02-28 10:30:15',1),(412,'889a5b88-09b7-4c48-88ed-168ca73ca921','image_type','snapshot','2026-02-28 10:29:13','2026-02-28 10:30:15','2026-02-28 10:30:15',1),(413,'889a5b88-09b7-4c48-88ed-168ca73ca921','image_state','available','2026-02-28 10:29:17','2026-02-28 10:30:15','2026-02-28 10:30:15',1),(414,'889a5b88-09b7-4c48-88ed-168ca73ca921','image_location','snapshot','2026-02-28 10:29:17','2026-02-28 10:30:15','2026-02-28 10:30:15',1),(415,'889a5b88-09b7-4c48-88ed-168ca73ca921','owner_id','344dd946e14146ab93c01183964c71b3','2026-02-28 10:29:17','2026-02-28 10:30:15','2026-02-28 10:30:15',1),(416,'889a5b88-09b7-4c48-88ed-168ca73ca921','version','8.0','2026-02-28 10:29:19','2026-02-28 10:30:15','2026-02-28 10:30:15',1),(417,'4f149197-39c6-4851-9529-9ce8f0064ae9','hw_rng_model','virtio','2026-02-28 10:29:59','2026-02-28 10:30:06','2026-02-28 10:30:06',1),(418,'4f149197-39c6-4851-9529-9ce8f0064ae9','base_image_ref','f3755b31-d5fb-4f1b-9b58-6260fd65fc72','2026-02-28 10:29:59','2026-02-28 10:30:06','2026-02-28 10:30:06',1),(419,'4f149197-39c6-4851-9529-9ce8f0064ae9','owner_user_name','tempest-TestSnapshotPattern-2121060882-project-member','2026-02-28 10:29:59','2026-02-28 10:30:06','2026-02-28 10:30:06',1),(420,'4f149197-39c6-4851-9529-9ce8f0064ae9','owner_project_name','tempest-TestSnapshotPattern-2121060882','2026-02-28 10:29:59','2026-02-28 10:30:06','2026-02-28 10:30:06',1),(421,'4f149197-39c6-4851-9529-9ce8f0064ae9','boot_roles','member,reader','2026-02-28 10:29:59','2026-02-28 10:30:06','2026-02-28 10:30:06',1),(422,'4f149197-39c6-4851-9529-9ce8f0064ae9','hw_machine_type','q35','2026-02-28 10:29:59','2026-02-28 10:30:06','2026-02-28 10:30:06',1),(423,'4f149197-39c6-4851-9529-9ce8f0064ae9','hw_cdrom_bus','sata','2026-02-28 10:29:59','2026-02-28 10:30:06','2026-02-28 10:30:06',1),(424,'4f149197-39c6-4851-9529-9ce8f0064ae9','hw_disk_bus','virtio','2026-02-28 10:29:59','2026-02-28 10:30:06','2026-02-28 10:30:06',1),(425,'4f149197-39c6-4851-9529-9ce8f0064ae9','hw_input_bus','usb','2026-02-28 10:29:59','2026-02-28 10:30:06','2026-02-28 10:30:06',1),(426,'4f149197-39c6-4851-9529-9ce8f0064ae9','hw_pointer_model','usbtablet','2026-02-28 10:29:59','2026-02-28 10:30:06','2026-02-28 10:30:06',1),(427,'4f149197-39c6-4851-9529-9ce8f0064ae9','hw_video_model','virtio','2026-02-28 10:29:59','2026-02-28 10:30:06','2026-02-28 10:30:06',1),(428,'4f149197-39c6-4851-9529-9ce8f0064ae9','hw_vif_model','virtio','2026-02-28 10:29:59','2026-02-28 10:30:06','2026-02-28 10:30:06',1),(429,'4f149197-39c6-4851-9529-9ce8f0064ae9','instance_uuid','0292c690-55db-421d-a004-21a0acd72961','2026-02-28 10:29:59','2026-02-28 10:30:06','2026-02-28 10:30:06',1),(430,'4f149197-39c6-4851-9529-9ce8f0064ae9','user_id','f54beab12fce4ee8adf80742bf33b916','2026-02-28 10:29:59','2026-02-28 10:30:06','2026-02-28 10:30:06',1),(431,'4f149197-39c6-4851-9529-9ce8f0064ae9','image_type','snapshot','2026-02-28 10:29:59','2026-02-28 10:30:06','2026-02-28 10:30:06',1),(432,'4f149197-39c6-4851-9529-9ce8f0064ae9','image_state','available','2026-02-28 10:29:59','2026-02-28 10:30:06','2026-02-28 10:30:06',1),(433,'4f149197-39c6-4851-9529-9ce8f0064ae9','image_location','snapshot','2026-02-28 10:29:59','2026-02-28 10:30:06','2026-02-28 10:30:06',1),(434,'4f149197-39c6-4851-9529-9ce8f0064ae9','owner_id','344dd946e14146ab93c01183964c71b3','2026-02-28 10:29:59','2026-02-28 10:30:06','2026-02-28 10:30:06',1),(435,'4f149197-39c6-4851-9529-9ce8f0064ae9','version','8.0','2026-02-28 10:29:59','2026-02-28 10:30:06','2026-02-28 10:30:06',1),(436,'4c20447f-84ff-45ca-86c2-e5ad9d598628','hw_rng_model','virtio','2026-02-28 10:48:14','2026-02-28 10:48:37','2026-02-28 10:48:37',1),(437,'4c20447f-84ff-45ca-86c2-e5ad9d598628','base_image_ref','f3755b31-d5fb-4f1b-9b58-6260fd65fc72','2026-02-28 10:48:14','2026-02-28 10:48:37','2026-02-28 10:48:37',1),(438,'4c20447f-84ff-45ca-86c2-e5ad9d598628','owner_user_name','tempest-TestShelveInstance-1186988285-project-member','2026-02-28 10:48:14','2026-02-28 10:48:37','2026-02-28 10:48:37',1),(439,'4c20447f-84ff-45ca-86c2-e5ad9d598628','owner_project_name','tempest-TestShelveInstance-1186988285','2026-02-28 10:48:14','2026-02-28 10:48:37','2026-02-28 10:48:37',1),(440,'4c20447f-84ff-45ca-86c2-e5ad9d598628','boot_roles','member,reader','2026-02-28 10:48:14','2026-02-28 10:48:37','2026-02-28 10:48:37',1),(441,'4c20447f-84ff-45ca-86c2-e5ad9d598628','hw_machine_type','q35','2026-02-28 10:48:14','2026-02-28 10:48:37','2026-02-28 10:48:37',1),(442,'4c20447f-84ff-45ca-86c2-e5ad9d598628','hw_cdrom_bus','sata','2026-02-28 10:48:14','2026-02-28 10:48:37','2026-02-28 10:48:37',1),(443,'4c20447f-84ff-45ca-86c2-e5ad9d598628','hw_disk_bus','virtio','2026-02-28 10:48:14','2026-02-28 10:48:37','2026-02-28 10:48:37',1),(444,'4c20447f-84ff-45ca-86c2-e5ad9d598628','hw_input_bus','usb','2026-02-28 10:48:14','2026-02-28 10:48:37','2026-02-28 10:48:37',1),(445,'4c20447f-84ff-45ca-86c2-e5ad9d598628','hw_pointer_model','usbtablet','2026-02-28 10:48:14','2026-02-28 10:48:37','2026-02-28 10:48:37',1),(446,'4c20447f-84ff-45ca-86c2-e5ad9d598628','hw_video_model','virtio','2026-02-28 10:48:14','2026-02-28 10:48:37','2026-02-28 10:48:37',1),(447,'4c20447f-84ff-45ca-86c2-e5ad9d598628','hw_vif_model','virtio','2026-02-28 10:48:14','2026-02-28 10:48:37','2026-02-28 10:48:37',1),(448,'4c20447f-84ff-45ca-86c2-e5ad9d598628','instance_uuid','d47f4919-0816-4363-b2eb-fa6580859e88','2026-02-28 10:48:14','2026-02-28 10:48:37','2026-02-28 10:48:37',1),(449,'4c20447f-84ff-45ca-86c2-e5ad9d598628','user_id','7efc7418904f44aa8c8c9c3e06ac552b','2026-02-28 10:48:14','2026-02-28 10:48:37','2026-02-28 10:48:37',1),(450,'4c20447f-84ff-45ca-86c2-e5ad9d598628','image_type','snapshot','2026-02-28 10:48:14','2026-02-28 10:48:37','2026-02-28 10:48:37',1),(451,'4c20447f-84ff-45ca-86c2-e5ad9d598628','image_state','available','2026-02-28 10:48:21','2026-02-28 10:48:37','2026-02-28 10:48:37',1),(452,'4c20447f-84ff-45ca-86c2-e5ad9d598628','image_location','snapshot','2026-02-28 10:48:21','2026-02-28 10:48:37','2026-02-28 10:48:37',1),(453,'4c20447f-84ff-45ca-86c2-e5ad9d598628','owner_id','d7baef4f72e742e8aa7530d7a586ed2b','2026-02-28 10:48:21','2026-02-28 10:48:37','2026-02-28 10:48:37',1),(454,'087aef76-8992-43d2-904b-9de16190aade','owner_specified.openstack.md5','','2026-02-28 10:53:07','2026-02-28 10:55:36','2026-02-28 10:55:36',1),(455,'087aef76-8992-43d2-904b-9de16190aade','owner_specified.openstack.sha256','','2026-02-28 10:53:07','2026-02-28 10:55:36','2026-02-28 10:55:36',1),(456,'087aef76-8992-43d2-904b-9de16190aade','owner_specified.openstack.object','images/cirros-0.6.2-test-operator','2026-02-28 10:53:07','2026-02-28 10:55:36','2026-02-28 10:55:36',1),(457,'087aef76-8992-43d2-904b-9de16190aade','os_glance_stage_host','https://glance-default-external-api-0.glance-default-external-api.openstack.svc:9292','2026-02-28 10:53:08','2026-02-28 10:55:36','2026-02-28 10:55:36',1),(459,'087aef76-8992-43d2-904b-9de16190aade','os_glance_importing_to_stores','','2026-02-28 10:53:08','2026-02-28 10:55:36','2026-02-28 10:55:36',1),(460,'087aef76-8992-43d2-904b-9de16190aade','os_glance_failed_import','','2026-02-28 10:53:08','2026-02-28 10:55:36','2026-02-28 10:55:36',1),(461,'7f05bf2a-85ee-4ccc-9a47-1417636e3886','hw_rng_model','virtio','2026-02-28 10:54:59','2026-02-28 11:01:43','2026-02-28 11:01:43',1),(462,'d0e60e33-a136-40ea-abdc-f49d2250fee7','hw_rng_model','virtio','2026-02-28 10:55:02','2026-02-28 11:01:46','2026-02-28 11:01:46',1),(463,'ad2585f3-a876-4568-a6c7-c739ffe0b007','owner_specified.openstack.md5','','2026-02-28 11:01:50','2026-02-28 11:02:43','2026-02-28 11:02:43',1),(464,'ad2585f3-a876-4568-a6c7-c739ffe0b007','owner_specified.openstack.sha256','','2026-02-28 11:01:50','2026-02-28 11:02:43','2026-02-28 11:02:43',1),(465,'ad2585f3-a876-4568-a6c7-c739ffe0b007','owner_specified.openstack.object','images/cirros-0.6.2-x86_64-disk','2026-02-28 11:01:50','2026-02-28 11:02:43','2026-02-28 11:02:43',1);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
INSERT INTO `image_tags` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'03abc412-1dd9-4953-821b-34b602947bfb','tempest-tag-682672610','2026-02-28 10:09:58','2026-02-28 10:09:58','2026-02-28 10:09:58',1),(2,'af4015d7-81af-4d5d-9b4e-0f37f3f2bbfb','tempest-tag-51911345','2026-02-28 10:27:25','2026-02-28 10:27:39','2026-02-28 10:27:39',1),(3,'af4015d7-81af-4d5d-9b4e-0f37f3f2bbfb','tempest-tag-1989461117','2026-02-28 10:27:25','2026-02-28 10:27:39','2026-02-28 10:27:39',1),(4,'a4838d37-05ed-4203-b692-45939f4c6ad8','tempest-tag-847574227','2026-02-28 10:27:26','2026-02-28 10:27:38','2026-02-28 10:27:38',1),(5,'a4838d37-05ed-4203-b692-45939f4c6ad8','tempest-tag-1518071360','2026-02-28 10:27:26','2026-02-28 10:27:38','2026-02-28 10:27:38',1),(6,'c9b9e283-ecf7-4f3f-aee1-4c7854409097','tempest-tag-1780120914','2026-02-28 10:27:27','2026-02-28 10:27:37','2026-02-28 10:27:37',1),(7,'c9b9e283-ecf7-4f3f-aee1-4c7854409097','tempest-tag-1465198083','2026-02-28 10:27:27','2026-02-28 10:27:37','2026-02-28 10:27:37',1),(8,'c8cc932b-144c-4a52-84ff-42d3fc1539b3','tempest-tag-1287468891','2026-02-28 10:27:28','2026-02-28 10:27:36','2026-02-28 10:27:36',1),(9,'c8cc932b-144c-4a52-84ff-42d3fc1539b3','tempest-tag-130947743','2026-02-28 10:27:28','2026-02-28 10:27:36','2026-02-28 10:27:36',1),(10,'24e38daf-a484-45ea-894a-725ec3f04d60','tempest-tag-67931750','2026-02-28 10:27:28','2026-02-28 10:27:35','2026-02-28 10:27:35',1),(11,'24e38daf-a484-45ea-894a-725ec3f04d60','tempest-tag-771276246','2026-02-28 10:27:28','2026-02-28 10:27:35','2026-02-28 10:27:35',1),(12,'0a7fb1a8-6af9-40f8-9827-daab8ad70bfc','tempest-tag-514022244','2026-02-28 10:27:30','2026-02-28 10:27:34','2026-02-28 10:27:34',1),(13,'0a7fb1a8-6af9-40f8-9827-daab8ad70bfc','tempest-tag-629833348','2026-02-28 10:27:30','2026-02-28 10:27:34','2026-02-28 10:27:34',1);
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('03abc412-1dd9-4953-821b-34b602947bfb','tempest-ImagesTagsTest-image-1257000101',NULL,'deleted','2026-02-28 10:09:58','2026-02-28 10:09:58','2026-02-28 10:09:58',1,'raw','bare',NULL,'30df99731c0242ae8b46aaef781d186a',0,0,0,NULL,'private',0,NULL,NULL),('04d681c2-17b7-46f1-b55e-50765e3f3f4c','tempest-test-snap-1320535812',NULL,'deleted','2026-02-28 10:06:45','2026-02-28 10:06:47','2026-02-28 10:06:47',1,NULL,NULL,NULL,'a2ce6ed219d94b3b88c2d2d7001f6c3a',1,0,0,NULL,'private',0,NULL,NULL),('05349771-69a6-40b0-a547-3eb5043c8d01','tempest-test-1147335691',NULL,'deleted','2026-02-28 10:20:29','2026-02-28 10:50:44','2026-02-28 10:50:44',1,'raw','bare',NULL,'bd35cb64e7b6408ca1905d0603b81114',0,0,0,NULL,'shared',0,NULL,NULL),('087aef76-8992-43d2-904b-9de16190aade','cirros-0.6.2-test-operator',117440512,'deleted','2026-02-28 10:53:07','2026-02-28 10:55:36','2026-02-28 10:55:36',1,'raw','bare','4245576e3df99ea1211871b8b9514d3b','eb0c6377c53644999dac7645ece0c360',0,0,0,117440512,'public',0,'sha512','dbb480bdc4f13ead7e00b62766df2815ddc8d4775af8a82ec40f8afd433d4cb95a109a58fbe7e0a661be86e0a06321c00362bc881f58c61c40bd2d1486954594'),('0a7fb1a8-6af9-40f8-9827-daab8ad70bfc','tempest-ListUserImagesTest-image-2019637420',3025,'deleted','2026-02-28 10:27:30','2026-02-28 10:27:34','2026-02-28 10:27:34',1,'vhd','bare','8750f3eeb0f689798080b20e56d40877','8aa4c660836e4ae992a47ce0868d1867',0,0,0,NULL,'private',0,'sha512','1bbf2cda8669c7c59688fc10b27b6ba867510523f47b463cb3c55dbf476484a8b30e9c24bc9d6eedbc4e7e04ae1bc0562c05fb432a9c160eb0f52a2a415539c2'),('0d8dfa14-3b8d-4dbe-937d-25edc1c0fccd','tempest-ImagesMemberTest-image-115737491',NULL,'deleted','2026-02-28 10:09:51','2026-02-28 10:09:51','2026-02-28 10:09:51',1,'raw','bare',NULL,'33fce9f8e5ae41a0978c0956c1f9f971',0,0,0,NULL,'shared',0,NULL,NULL),('11f85a5a-a547-422e-be6b-1f24f8009622','tempest-ListUserImagesTest-image-1079519448',NULL,'deleted','2026-02-28 10:27:33','2026-02-28 10:27:33','2026-02-28 10:27:33',1,NULL,NULL,NULL,'8aa4c660836e4ae992a47ce0868d1867',0,0,0,NULL,'shared',1,NULL,NULL),('15834e2d-0d53-4b8a-8f0b-345fe662dcbf','tempest-test-snap-1079527372',1073741824,'deleted','2026-02-28 10:04:30','2026-02-28 10:04:37','2026-02-28 10:04:37',1,'raw','bare',NULL,'a2ce6ed219d94b3b88c2d2d7001f6c3a',1,0,0,NULL,'private',0,NULL,NULL),('1583781d-ec8c-4060-a2ad-53d52445d23e','tempest-image-dependency-test-1415239692',1024,'deleted','2026-02-28 10:19:52','2026-02-28 10:20:11','2026-02-28 10:20:11',1,'raw','bare','8dbf5d7f5ae126eb3d2e8c6f3c6631aa','f743c06bc2ae45fda68427b8418baef8',0,0,0,1024,'private',0,'sha512','e4b1cd527372e7766397eec232a354bb972342078f141bd157f8d59cf95cb83437fee7d36c9feb2cab3df9cd8d2680ea68de2616b39f72fe0b3650cee16551e0'),('164f3d1c-d010-4262-99c5-2d1e2b119fee','tempest-new-image-1154022733',NULL,'deleted','2026-02-28 10:23:26','2026-02-28 10:23:26','2026-02-28 10:23:26',1,'qcow2','bare',NULL,'67bbe0cd3e93488fb66367c896885cc0',0,0,0,NULL,'private',0,NULL,NULL),('22a70b75-075f-4875-bc53-299afbb39f44','tempest-ServersNegativeTestJSON-server-76744621-shelved',1073741824,'deleted','2026-02-28 10:16:42','2026-02-28 10:17:19','2026-02-28 10:17:19',1,'raw','bare',NULL,'c0c4bc44c37f4a4f83c83b6105be3190',1,0,0,NULL,'private',0,NULL,NULL),('24e38daf-a484-45ea-894a-725ec3f04d60','tempest-ListUserImagesTest-image-720625313',1068,'deleted','2026-02-28 10:27:28','2026-02-28 10:27:35','2026-02-28 10:27:35',1,'aki','bare','4c19b8b26c0a83f650fbd5520947d009','8aa4c660836e4ae992a47ce0868d1867',0,0,0,NULL,'private',0,'sha512','583116b2372338f4226391fb615e1d06157834a8e4d477caad4e753a64fb47cd4b77e259cef068013ee79b3f9d30f0288e5ffce77eae988e217b64d89fdaa582'),('25b251cf-d2d3-4791-ac23-4c46c14f375b','tempest-ImagesMemberTest-image-1249041111',NULL,'deleted','2026-02-28 10:09:50','2026-02-28 10:09:51','2026-02-28 10:09:51',1,'raw','bare',NULL,'33fce9f8e5ae41a0978c0956c1f9f971',0,0,0,NULL,'shared',0,NULL,NULL),('2eac6bed-bd5a-4777-b2e7-ca1c642ef30e','tempest-test-101547813',NULL,'deleted','2026-02-28 10:27:44','2026-02-28 10:27:44','2026-02-28 10:27:44',1,'raw','bare',NULL,'ce7b34dc1f6440b9903c420596a82d01',0,0,0,NULL,'shared',0,NULL,NULL),('2faaae0a-1f52-46d5-96e2-689c416dab4c','tempest-image-632003444',3363,'deleted','2026-02-28 10:02:14','2026-02-28 10:02:18','2026-02-28 10:02:18',1,'qcow2','bare','4815ca883cfeaec7c70dd7012460a178','77b16dca4a0349faa70c2658f7b3d54c',0,129,0,NULL,'private',0,'sha512','2813121159813249707be6b7e03331fe30e51c7c370cbdcf2667b0a875060270e4c02c8275c80feedb29e63298dbc64b9a88e27a8db5f18b780cca59af223e65'),('31c8918a-4cbd-4459-b04d-e55d79f71575','tempest-backup-2-1779290159',1073741824,'deleted','2026-02-28 10:11:00','2026-02-28 10:11:19','2026-02-28 10:11:19',1,'raw','bare',NULL,'cffbbb9857954b188c363e9565817bf2',1,0,0,NULL,'private',0,NULL,NULL),('337de210-963f-41af-92a4-16b5716eae17','tempest-ServerActionsTestOtherB-server-655402139-shelved',1073741824,'deleted','2026-02-28 10:12:20','2026-02-28 10:12:53','2026-02-28 10:12:53',1,'raw','bare',NULL,'cffbbb9857954b188c363e9565817bf2',1,0,0,NULL,'private',0,NULL,NULL),('342d07d0-ce6e-40be-938e-c99ef1da978f','tempest-DeleteServersTestJSON-server-980989576-shelved',1073741824,'deleted','2026-02-28 10:09:56','2026-02-28 10:10:27','2026-02-28 10:10:27',1,'raw','bare',NULL,'a5095f810f0d431788237ae1da262bf6',1,0,0,NULL,'private',0,NULL,NULL),('342ed071-b7ab-43f1-b140-4013b177d36b','tempest-image-884620189',1024,'deleted','2026-02-28 10:03:38','2026-02-28 10:03:56','2026-02-28 10:03:56',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','50baaf787aa74602956d26c2e62174bf',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('368a95dc-f2bf-43b2-80e0-562f69f20423','tempest-ImagesOneServerNegativeTestJSON-image-1908744974',NULL,'deleted','2026-02-28 10:04:31','2026-02-28 10:04:32','2026-02-28 10:04:32',1,NULL,NULL,NULL,'da458887a8634c5a8b9a38fcbcc44e07',1,0,0,NULL,'private',0,NULL,NULL),('37ce91b1-8103-458d-a5c4-da9785d41cf8','tempest-BasicOperationsImagesAdminTest-Image-170959781',NULL,'deleted','2026-02-28 10:19:39','2026-02-28 10:19:40','2026-02-28 10:19:40',1,'raw','bare',NULL,'ad2f506115af4d66af9262b9b92f3bf2',0,0,0,NULL,'public',0,NULL,NULL),('38cb5514-6684-4136-959d-9444907f6bfa','tempest-test-snap-350209641',1073741824,'deleted','2026-02-28 10:05:54','2026-02-28 10:06:28','2026-02-28 10:06:28',1,'raw','bare',NULL,'a2ce6ed219d94b3b88c2d2d7001f6c3a',1,0,0,NULL,'private',0,NULL,NULL),('3b21ab4b-c073-46e0-8268-a242c273db0f','tempest-backup-1-940370303',NULL,'deleted','2026-02-28 10:13:22','2026-02-28 10:13:23','2026-02-28 10:13:23',1,'qcow2','bare',NULL,'efd550ad4a4044b5b976691be30a846c',1,0,0,NULL,'private',0,NULL,NULL),('4c20447f-84ff-45ca-86c2-e5ad9d598628','tempest-TestShelveInstance-server-373381639-shelved',1073741824,'deleted','2026-02-28 10:48:14','2026-02-28 10:48:37','2026-02-28 10:48:37',1,'raw','bare',NULL,'d7baef4f72e742e8aa7530d7a586ed2b',1,0,0,NULL,'private',0,NULL,NULL),('4f149197-39c6-4851-9529-9ce8f0064ae9','tempest-TestSnapshotPatternsnapshot-957199983',1073741824,'deleted','2026-02-28 10:29:59','2026-02-28 10:30:06','2026-02-28 10:30:06',1,'raw','bare',NULL,'344dd946e14146ab93c01183964c71b3',1,0,0,NULL,'private',0,NULL,NULL),('566c962b-ab07-4ea4-8c4a-daa71c23c042','tempest-backup-1-423316443',1073741824,'deleted','2026-02-28 10:10:48','2026-02-28 10:11:16','2026-02-28 10:11:16',1,'raw','bare',NULL,'cffbbb9857954b188c363e9565817bf2',1,0,0,NULL,'private',0,NULL,NULL),('5cef583f-ee5c-443e-bec2-1be1e20ae4cc',NULL,NULL,'deleted','2026-02-28 10:19:39','2026-02-28 10:19:39','2026-02-28 10:19:39',1,'raw','bare',NULL,'b1a420cf467f48ad810ebb78f3866948',0,0,0,NULL,'shared',0,NULL,NULL),('5f926d24-a2e8-4b55-9d94-1f70e334b2f5',NULL,NULL,'deleted','2026-02-28 10:19:40','2026-02-28 10:19:40','2026-02-28 10:19:40',1,'raw','bare',NULL,'f002e4611ce64d909b5c0dbfcfd27036',0,0,0,NULL,'shared',0,NULL,NULL),('60ad6e6b-14e8-4ec6-9e02-5b68cbfcac60','tempest-test-snap-571885268',1073741824,'deleted','2026-02-28 10:05:06','2026-02-28 10:05:13','2026-02-28 10:05:13',1,'raw','bare',NULL,'a2ce6ed219d94b3b88c2d2d7001f6c3a',1,0,0,NULL,'private',0,NULL,NULL),('64671ca6-d66f-48a8-9905-66fd8ae90fc9','tempest-image-826143768',1073741824,'deleted','2026-02-28 10:08:25','2026-02-28 10:08:33','2026-02-28 10:08:33',1,'raw','bare',NULL,'3b8b0d675b3747fd80cb2186e41d2ebf',1,0,0,NULL,'private',0,NULL,NULL),('64da16e2-6a49-482e-be77-e36b9b8b2aad','tempest-ImagesMemberNegativeTest-image-712023274',NULL,'deleted','2026-02-28 10:20:22','2026-02-28 10:20:22','2026-02-28 10:20:22',1,'raw','bare',NULL,'11d32c584dcf4b5aa2f8b68c016b96f8',0,0,0,NULL,'shared',0,NULL,NULL),('69bde4b7-947e-4c9f-8b55-96fa18b7208d','cirros-0.6.2-x86_64-disk.img_alt',21430272,'deleted','2026-02-28 09:55:58','2026-02-28 09:56:12','2026-02-28 09:56:12',1,'qcow2','bare','c8fc807773e5354afe61636071771906','eb0c6377c53644999dac7645ece0c360',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('6b233e12-3f74-4230-95e0-5d351ffd62b0','tempest-ImagesMemberNegativeTest-image-1952599568',NULL,'deleted','2026-02-28 10:20:22','2026-02-28 10:20:22','2026-02-28 10:20:22',1,'raw','bare',NULL,'11d32c584dcf4b5aa2f8b68c016b96f8',0,0,0,NULL,'shared',0,NULL,NULL),('7423a20c-67c7-40c5-ad78-6316a47a4ab9','tempest-test-901525112',NULL,'deleted','2026-02-28 10:27:43','2026-02-28 10:27:45','2026-02-28 10:27:45',1,NULL,NULL,NULL,'ce7b34dc1f6440b9903c420596a82d01',0,0,0,NULL,'shared',0,NULL,NULL),('75ef2421-d402-4c53-a2df-d046e5c1a858','tempest-test-1725919164',NULL,'deleted','2026-02-28 10:27:43','2026-02-28 10:27:44','2026-02-28 10:27:44',1,'raw','bare',NULL,'ce7b34dc1f6440b9903c420596a82d01',0,0,0,NULL,'shared',0,NULL,NULL),('7a38b1bc-ebc5-4262-9991-4c580b461c0a','tempest-ListImageFiltersTestJSON-image-634418446',1024,'deleted','2026-02-28 10:09:10','2026-02-28 10:10:13','2026-02-28 10:10:13',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','6a54f983c0fa466f9e11947f104ed5ca',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('7f05bf2a-85ee-4ccc-9a47-1417636e3886','cirros-0.6.2-x86_64-disk.img',21430272,'deleted','2026-02-28 10:54:59','2026-02-28 11:01:43','2026-02-28 11:01:43',1,'qcow2','bare','c8fc807773e5354afe61636071771906','eb0c6377c53644999dac7645ece0c360',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('7f101383-680e-4e57-98bb-8ecf7964ef03','tempest-image-1406303757',117440512,'deleted','2026-02-28 10:09:30','2026-02-28 10:09:37','2026-02-28 10:09:37',1,'raw','bare','4245576e3df99ea1211871b8b9514d3b','a71fb26e084e46d6b656e41936ac5794',0,0,0,117440512,'private',0,'sha512','dbb480bdc4f13ead7e00b62766df2815ddc8d4775af8a82ec40f8afd433d4cb95a109a58fbe7e0a661be86e0a06321c00362bc881f58c61c40bd2d1486954594'),('818dfec7-2d43-4696-a4bb-91240db544c9','tempest-ImageDependencyTestssnapshot-1628338601',1073741824,'deleted','2026-02-28 10:20:06','2026-02-28 10:20:12','2026-02-28 10:20:12',1,'raw','bare',NULL,'f743c06bc2ae45fda68427b8418baef8',1,0,0,NULL,'private',0,NULL,NULL),('82a31a36-1ce5-465c-b0dc-84645e81ab65','tempest-task_image-1874495436',NULL,'deleted','2026-02-28 10:09:14','2026-02-28 10:09:14','2026-02-28 10:09:14',1,'qcow2','bare',NULL,NULL,0,0,0,NULL,'public',0,NULL,NULL),('830ebb40-f7a7-4e0f-9487-d755555148cb','tempest-test-snap-1968950157',1073741824,'deleted','2026-02-28 10:05:28','2026-02-28 10:05:38','2026-02-28 10:05:38',1,'raw','bare',NULL,'a2ce6ed219d94b3b88c2d2d7001f6c3a',1,0,0,NULL,'private',0,NULL,NULL),('88971623-4808-4102-a4a7-34a287d8b7fe','cirros-0.6.2-x86_64-disk.img_alt',21430272,'deleted','2026-02-28 09:58:17','2026-02-28 10:52:56','2026-02-28 10:52:56',1,'qcow2','bare','c8fc807773e5354afe61636071771906','eb0c6377c53644999dac7645ece0c360',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('889a5b88-09b7-4c48-88ed-168ca73ca921','tempest-TestSnapshotPatternsnapshot-946860430',1073741824,'deleted','2026-02-28 10:29:13','2026-02-28 10:30:15','2026-02-28 10:30:15',1,'raw','bare',NULL,'344dd946e14146ab93c01183964c71b3',1,0,0,NULL,'private',0,NULL,NULL),('8b75599f-536e-4d8a-9a82-93ca19ac590b',NULL,NULL,'deleted','2026-02-28 10:27:31','2026-02-28 10:27:31','2026-02-28 10:27:31',1,NULL,NULL,NULL,'8aa4c660836e4ae992a47ce0868d1867',0,0,0,NULL,'shared',1,NULL,NULL),('928e81a1-3ac7-4b82-94e8-2be945cb3d36','tempest-ListImageFiltersTestJSON-image-52212715',1024,'deleted','2026-02-28 10:09:13','2026-02-28 10:10:09','2026-02-28 10:10:09',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','6a54f983c0fa466f9e11947f104ed5ca',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('9ce992ef-e998-43ea-9bd4-8cdaf2841ea4','tempest-ListImageFiltersTestJSON-image-1782802109',1073741824,'deleted','2026-02-28 10:09:28','2026-02-28 10:09:59','2026-02-28 10:09:59',1,'raw','bare',NULL,'6a54f983c0fa466f9e11947f104ed5ca',1,0,0,NULL,'private',0,NULL,NULL),('a3073515-16a1-46c5-a0a2-2f9f79bcc70a','tempest-ImagesTagsNegativeTest-image-848006391',NULL,'deleted','2026-02-28 10:23:37','2026-02-28 10:23:37','2026-02-28 10:23:37',1,'raw','bare',NULL,'ea8221af0cd241d7b9463c961fe30179',0,0,0,NULL,'private',0,NULL,NULL),('a3ff9934-08db-4bb8-903b-7c981dea1b00','tempest-backup-3-581239555',1073741824,'deleted','2026-02-28 10:11:07','2026-02-28 10:11:18','2026-02-28 10:11:18',1,'raw','bare',NULL,'cffbbb9857954b188c363e9565817bf2',1,0,0,NULL,'private',0,NULL,NULL),('a4838d37-05ed-4203-b692-45939f4c6ad8','tempest-ListUserImagesTest-image-932691567',1585,'deleted','2026-02-28 10:27:26','2026-02-28 10:27:38','2026-02-28 10:27:38',1,'raw','bare','0a3ef1518a234bba7f0d426b4a3f8cb6','8aa4c660836e4ae992a47ce0868d1867',0,0,0,1585,'private',0,'sha512','4c1faf84b71ff78213120b72fe770394b300066474e9dba3733d2cce1f32ca5033f06a9491f75f741bd34f88b5b8cb2de6eea4cb9058b93bfc5307cb60be9dfe'),('a76de62a-d69e-4c03-92ec-aaff7623c365','tempest-ServerActionsTestOtherB-server-440852658-shelved',1073741824,'deleted','2026-02-28 10:12:04','2026-02-28 10:12:57','2026-02-28 10:12:57',1,'raw','bare',NULL,'cffbbb9857954b188c363e9565817bf2',1,0,0,NULL,'private',0,NULL,NULL),('acaa20bc-4ba4-4568-8d34-510237f0abb5','cirros-0.6.2-test-operator',117440512,'deleted','2026-02-28 09:56:23','2026-02-28 10:50:45','2026-02-28 10:50:45',1,'raw','bare','4245576e3df99ea1211871b8b9514d3b','eb0c6377c53644999dac7645ece0c360',0,0,0,117440512,'public',0,'sha512','dbb480bdc4f13ead7e00b62766df2815ddc8d4775af8a82ec40f8afd433d4cb95a109a58fbe7e0a661be86e0a06321c00362bc881f58c61c40bd2d1486954594'),('ad2585f3-a876-4568-a6c7-c739ffe0b007','cirros-0.6.2-x86_64-disk',21430272,'deleted','2026-02-28 11:01:50','2026-02-28 11:02:43','2026-02-28 11:02:43',1,'qcow2','bare','c8fc807773e5354afe61636071771906','eb0c6377c53644999dac7645ece0c360',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('af4015d7-81af-4d5d-9b4e-0f37f3f2bbfb','tempest-ListUserImagesTest-image-1172977627',2750,'deleted','2026-02-28 10:27:25','2026-02-28 10:27:39','2026-02-28 10:27:39',1,'qcow2','bare','33811b5e8cd179d4b4286dd163aa4610','8aa4c660836e4ae992a47ce0868d1867',0,0,0,NULL,'private',0,'sha512','11440655c8cf6fbb058b4be898a2d34c71a9c7e6e71ab2eb9356cea67511d076b36b42790c4ae10a26aeeda50d822a75d6695047ce76bcc20f2520307837e1d4'),('b452f76e-84b8-461a-8b95-21b09f41396c','tempest-ListImageFiltersTestJSON-image-1711375420',1073741824,'deleted','2026-02-28 10:09:43','2026-02-28 10:09:56','2026-02-28 10:09:56',1,'raw','bare',NULL,'6a54f983c0fa466f9e11947f104ed5ca',1,0,0,NULL,'private',0,NULL,NULL),('b978c9fc-5848-49ab-b596-8766095b08da','tempest-image-675495514',NULL,'deleted','2026-02-28 10:23:24','2026-02-28 10:23:24','2026-02-28 10:23:24',1,'qcow2','bare',NULL,'67bbe0cd3e93488fb66367c896885cc0',0,0,0,NULL,'private',0,NULL,NULL),('bd212f15-02ac-422d-b109-19f5cd1e442e','tempest-image-1220365592',1024,'deleted','2026-02-28 10:09:27','2026-02-28 10:09:39','2026-02-28 10:09:39',1,'raw','bare','8c4e833f096c38361a67c338e2ea6bef','a71fb26e084e46d6b656e41936ac5794',0,0,0,1024,'private',0,'sha512','c6d87deb8a37b2a3ad379152cfb3972338f75102a65dc11898999f9dcacfb55e82a651a9eaf4f6eaeb280679c597f266ccc2ab4579013effe1a4849336d1ae45'),('c24456e8-6059-4829-a43c-9748cea729c4','tempest-ImagesMemberTest-image-1642684387',NULL,'deleted','2026-02-28 10:09:51','2026-02-28 10:09:52','2026-02-28 10:09:52',1,'raw','bare',NULL,'33fce9f8e5ae41a0978c0956c1f9f971',0,0,0,NULL,'shared',0,NULL,NULL),('c8cc932b-144c-4a52-84ff-42d3fc1539b3','tempest-ListUserImagesTest-image-860306529',2313,'deleted','2026-02-28 10:27:28','2026-02-28 10:27:36','2026-02-28 10:27:36',1,'ari','bare','ffafdb6a08f55be7a70b5bb00fee1a73','8aa4c660836e4ae992a47ce0868d1867',0,0,0,NULL,'private',0,'sha512','e3232e5ba2a02c1d6f1f1ebb0527ea8bcc2ad5be466bdcbed591ea0470265338f5b89e1988835db84bc1da457787a7b551c6503160d7c5795e002fdfed09ded4'),('c9b9e283-ecf7-4f3f-aee1-4c7854409097','tempest-ListUserImagesTest-image-1214986322',1384,'deleted','2026-02-28 10:27:27','2026-02-28 10:27:37','2026-02-28 10:27:37',1,'ami','bare','a0db5f694193ca79219db3d44d7e348b','8aa4c660836e4ae992a47ce0868d1867',0,0,0,NULL,'private',0,'sha512','42c3b186b61a516cfe445d07cdf47525b00e4401271622c48f75064a10c27e03e9fe458bec143f87a79fca5d46a948cbeb518df16f92363192fe78c77b415792'),('ceb167e8-5ad0-4fa3-bcff-a4573362f9a0','cirros-0.6.2-x86_64-disk.img',21430272,'deleted','2026-02-28 09:55:54','2026-02-28 09:56:08','2026-02-28 09:56:08',1,'qcow2','bare','c8fc807773e5354afe61636071771906','eb0c6377c53644999dac7645ece0c360',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('d0e60e33-a136-40ea-abdc-f49d2250fee7','cirros-0.6.2-x86_64-disk.img_alt',21430272,'deleted','2026-02-28 10:55:02','2026-02-28 11:01:46','2026-02-28 11:01:46',1,'qcow2','bare','c8fc807773e5354afe61636071771906','eb0c6377c53644999dac7645ece0c360',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('d2b40a95-7ba7-4bd1-9cd5-7b6bd9ab0b87','tempest-ListImageFiltersTestJSON-image-1121590817',1024,'deleted','2026-02-28 10:09:06','2026-02-28 10:10:16','2026-02-28 10:10:16',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','6a54f983c0fa466f9e11947f104ed5ca',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('d6f9704e-a041-47c4-bed1-6ca11061c49a','tempest-₡-1001288060',1073741824,'deleted','2026-02-28 10:08:35','2026-02-28 10:08:46','2026-02-28 10:08:46',1,'raw','bare',NULL,'3b8b0d675b3747fd80cb2186e41d2ebf',1,0,0,NULL,'private',0,NULL,NULL),('e7cdbd31-c9ec-472e-9e30-4697be3ffc7a','tempest-image-2140980531',1024,'deleted','2026-02-28 10:23:22','2026-02-28 10:23:29','2026-02-28 10:23:29',1,'raw','bare','0392d284e0d9b9a343bd06f5bceee257','67bbe0cd3e93488fb66367c896885cc0',0,0,0,1024,'private',0,'sha512','bd16e95dd521c2a39cb8668770ca715086b861b07fd07a52700475dd284a7be08b350bc6b07f3e78bc5632953a2186108915a6cc47bcdb180ae76455ee6b938c'),('f11b8ff5-5543-44b5-b05a-1bfe58acd828','tempest-ImagesMemberTest-image-820451256',NULL,'deleted','2026-02-28 10:09:52','2026-02-28 10:09:53','2026-02-28 10:09:53',1,'raw','bare',NULL,'33fce9f8e5ae41a0978c0956c1f9f971',0,0,0,NULL,'shared',0,NULL,NULL),('f3755b31-d5fb-4f1b-9b58-6260fd65fc72','cirros-0.6.2-x86_64-disk.img',21430272,'deleted','2026-02-28 09:58:16','2026-02-28 10:52:53','2026-02-28 10:52:53',1,'qcow2','bare','c8fc807773e5354afe61636071771906','eb0c6377c53644999dac7645ece0c360',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('f5079d19-e128-4eef-85f9-01a7c15d6be6','tempest-image-433067702',1024,'deleted','2026-02-28 10:23:24','2026-02-28 10:23:27','2026-02-28 10:23:27',1,'qcow2','bare','bbf12f13d3ea7720680584d752e525f1','67bbe0cd3e93488fb66367c896885cc0',0,0,0,NULL,'private',0,'sha512','7cb574a30bfbf837593a2d8e609628c3745b4c1660288be2bb48465c3d6e916a91546be78e4dc0da602d0d1f0b3e69b4a05cfec81d89c6f766855e01f9e982ca'),('f5580b42-39c5-4447-90bb-f9baf47b726d','tempest-ListSharedImagesTest-image-546541086',2048,'deleted','2026-02-28 10:27:19','2026-02-28 10:27:21','2026-02-28 10:27:21',1,'qcow2','bare','5c09a4c069a44eeca3aafc3a9929c927','ccfe18aee2ef470785f94a645b3b432a',0,0,0,NULL,'shared',0,'sha512','600694da876694063552cea446d8cde9f7c595b72fd5f52001d4ae7cda3fa8f7d0ed68265ecf58bffbad0979ba5694dcd9a0f86642d0b1a084cd2aec1161f091'),('fb0dbe89-ad99-412d-9a08-eeddbc9f2714','tempest-ImagesOneServerNegativeTestJSON-image-1894457425',NULL,'deleted','2026-02-28 10:05:02','2026-02-28 10:05:03','2026-02-28 10:05:03',1,NULL,NULL,NULL,'da458887a8634c5a8b9a38fcbcc44e07',1,0,0,NULL,'private',0,NULL,NULL),('fdddffc1-692d-46e3-8fbc-eca1a14df1a2','tempest-ListImageFiltersTestJSON-image-454375314',1073741824,'deleted','2026-02-28 10:09:36','2026-02-28 10:09:57','2026-02-28 10:09:57',1,'raw','bare',NULL,'6a54f983c0fa466f9e11947f104ed5ca',1,0,0,NULL,'private',0,NULL,NULL);
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2026-02-28 09:20:06',NULL),(1,2,'image','CIM_RASD_','2026-02-28 09:20:07',NULL),(1,3,NULL,'CIM_SASD_','2026-02-28 09:20:10',NULL),(1,9,'image','hw_','2026-02-28 09:20:10',NULL),(1,10,'image','hw_','2026-02-28 09:20:10',NULL),(1,14,'image',NULL,'2026-02-28 09:20:10',NULL),(1,19,'image','hw_','2026-02-28 09:20:10',NULL),(1,25,'image','hw_','2026-02-28 09:20:11',NULL),(1,29,'image',NULL,'2026-02-28 09:20:11',NULL),(1,30,'image',NULL,'2026-02-28 09:20:11',NULL),(1,31,'image',NULL,'2026-02-28 09:20:11',NULL),(1,32,'image',NULL,'2026-02-28 09:20:11',NULL),(2,1,NULL,'CIM_PASD_','2026-02-28 09:20:06',NULL),(2,8,NULL,'hw_','2026-02-28 09:20:10',NULL),(2,9,NULL,'hw_','2026-02-28 09:20:10',NULL),(2,10,NULL,'hw_','2026-02-28 09:20:10',NULL),(2,11,NULL,NULL,'2026-02-28 09:20:10',NULL),(2,13,NULL,NULL,'2026-02-28 09:20:10',NULL),(2,14,NULL,NULL,'2026-02-28 09:20:10',NULL),(2,15,NULL,NULL,'2026-02-28 09:20:10',NULL),(2,16,NULL,'hw_','2026-02-28 09:20:10',NULL),(2,19,NULL,'hw_','2026-02-28 09:20:10',NULL),(2,22,NULL,NULL,'2026-02-28 09:20:10',NULL),(2,23,NULL,'hw_','2026-02-28 09:20:11',NULL),(2,24,NULL,'traits:','2026-02-28 09:20:11',NULL),(2,25,NULL,'hw_','2026-02-28 09:20:11',NULL),(2,26,NULL,NULL,'2026-02-28 09:20:11',NULL),(2,28,NULL,NULL,'2026-02-28 09:20:11',NULL),(2,29,NULL,NULL,'2026-02-28 09:20:11',NULL),(2,30,NULL,NULL,'2026-02-28 09:20:11',NULL),(2,31,NULL,NULL,'2026-02-28 09:20:11',NULL),(2,32,NULL,NULL,'2026-02-28 09:20:11',NULL),(2,33,NULL,'cinder_','2026-02-28 09:20:11',NULL),(3,1,NULL,'CIM_PASD_','2026-02-28 09:20:06',NULL),(3,2,NULL,'CIM_RASD_','2026-02-28 09:20:08',NULL),(3,3,NULL,'CIM_SASD_','2026-02-28 09:20:10',NULL),(3,4,NULL,'CIM_VSSD_','2026-02-28 09:20:10',NULL),(3,5,NULL,NULL,'2026-02-28 09:20:10',NULL),(3,6,NULL,NULL,'2026-02-28 09:20:10',NULL),(3,7,NULL,NULL,'2026-02-28 09:20:10',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2026-02-28 09:20:10',NULL),(4,1,NULL,'CIM_PASD_','2026-02-28 09:20:06',NULL),(4,2,NULL,'CIM_RASD_','2026-02-28 09:20:08',NULL),(4,3,NULL,'CIM_SASD_','2026-02-28 09:20:10',NULL),(4,4,NULL,'CIM_VSSD_','2026-02-28 09:20:10',NULL),(4,8,NULL,'hw:','2026-02-28 09:20:10',NULL),(4,9,NULL,'hw:','2026-02-28 09:20:10',NULL),(4,10,NULL,'hw:','2026-02-28 09:20:10',NULL),(4,12,NULL,'capabilities:','2026-02-28 09:20:10',NULL),(4,16,NULL,'hw:','2026-02-28 09:20:10',NULL),(4,17,NULL,NULL,'2026-02-28 09:20:10',NULL),(4,18,NULL,NULL,'2026-02-28 09:20:10',NULL),(4,19,NULL,'hw:','2026-02-28 09:20:10',NULL),(4,20,NULL,NULL,'2026-02-28 09:20:10',NULL),(4,21,NULL,NULL,'2026-02-28 09:20:10',NULL),(4,23,NULL,'hw:','2026-02-28 09:20:11',NULL),(4,24,NULL,'traits:','2026-02-28 09:20:11',NULL),(4,25,NULL,'hw:','2026-02-28 09:20:11',NULL),(5,1,'scheduler_hints',NULL,'2026-02-28 09:20:06',NULL),(5,30,'metadata',NULL,'2026-02-28 09:20:11',NULL),(5,31,'metadata',NULL,'2026-02-28 09:20:11',NULL),(5,32,'metadata',NULL,'2026-02-28 09:20:11',NULL),(6,30,NULL,NULL,'2026-02-28 09:20:11',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2026-02-28 09:20:05',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2026-02-28 09:20:07',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2026-02-28 09:20:10',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2026-02-28 09:20:10',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-02-28 09:20:10',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-02-28 09:20:10',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2026-02-28 09:20:10',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2026-02-28 09:20:10',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2026-02-28 09:20:10',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2026-02-28 09:20:10',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2026-02-28 09:20:10',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2026-02-28 09:20:10',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2026-02-28 09:20:10',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2026-02-28 09:20:10',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-02-28 09:20:10',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-02-28 09:20:10',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-02-28 09:20:10',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2026-02-28 09:20:10',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2026-02-28 09:20:10',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-02-28 09:20:10',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-02-28 09:20:10',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-02-28 09:20:10',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2026-02-28 09:20:11',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2026-02-28 09:20:11',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-02-28 09:20:11',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-02-28 09:20:11',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2026-02-28 09:20:11',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2026-02-28 09:20:11',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2026-02-28 09:20:11',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2026-02-28 09:20:11',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2026-02-28 09:20:11',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2026-02-28 09:20:11',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2026-02-28 09:20:11',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2026-02-28 09:20:10',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2026-02-28 09:20:10',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2026-02-28 09:20:10',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2026-02-28 09:20:11',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2026-02-28 09:20:11',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2026-02-28 09:20:11',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2026-02-28 09:20:11',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-02-28 09:20:11',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-02-28 09:20:11',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-02-28 09:20:11',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-02-28 09:20:11',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-02-28 09:20:11',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2026-02-28 09:20:11',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2026-02-28 09:20:11',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2026-02-28 09:20:11',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2026-02-28 09:20:11',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2026-02-28 09:20:11',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2026-02-28 09:20:11',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2026-02-28 09:20:11',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2026-02-28 09:20:11',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-02-28 09:20:11',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-02-28 09:20:11',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-02-28 09:20:11',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=134 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2026-02-28 09:20:06',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2026-02-28 09:20:07',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2026-02-28 09:20:07',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2026-02-28 09:20:08',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2026-02-28 09:20:08',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2026-02-28 09:20:08',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2026-02-28 09:20:08',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2026-02-28 09:20:09',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-02-28 09:20:09',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2026-02-28 09:20:09',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2026-02-28 09:20:09',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2026-02-28 09:20:09',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2026-02-28 09:20:09',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2026-02-28 09:20:09',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2026-02-28 09:20:09',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-02-28 09:20:10',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2026-02-28 09:20:10',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2026-02-28 09:20:10',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2026-02-28 09:20:10',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2026-02-28 09:20:10',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2026-02-28 09:20:10',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2026-02-28 09:20:10',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2026-02-28 09:20:10',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2026-02-28 09:20:10',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2026-02-28 09:20:10',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2026-02-28 09:20:10',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2026-02-28 09:20:10',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2026-02-28 09:20:10',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2026-02-28 09:20:10',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2026-02-28 09:20:10',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2026-02-28 09:20:10',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2026-02-28 09:20:10',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-02-28 09:20:10',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-02-28 09:20:10',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-02-28 09:20:10',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2026-02-28 09:20:10',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2026-02-28 09:20:10',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2026-02-28 09:20:10',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2026-02-28 09:20:10',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-02-28 09:20:10',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-02-28 09:20:10',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-02-28 09:20:10',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2026-02-28 09:20:10',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2026-02-28 09:20:10',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2026-02-28 09:20:10',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2026-02-28 09:20:10',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2026-02-28 09:20:10',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2026-02-28 09:20:10',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2026-02-28 09:20:10',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-02-28 09:20:10',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-02-28 09:20:10',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-02-28 09:20:10',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2026-02-28 09:20:10',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-02-28 09:20:10',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2026-02-28 09:20:10',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-02-28 09:20:10',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-02-28 09:20:10',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2026-02-28 09:20:10',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2026-02-28 09:20:10',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2026-02-28 09:20:10',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-02-28 09:20:10',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-02-28 09:20:10',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-02-28 09:20:10',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-02-28 09:20:10',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-02-28 09:20:10',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-02-28 09:20:10',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2026-02-28 09:20:10',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2026-02-28 09:20:10',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2026-02-28 09:20:10',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2026-02-28 09:20:10',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2026-02-28 09:20:11',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2026-02-28 09:20:11',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2026-02-28 09:20:11',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2026-02-28 09:20:11',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2026-02-28 09:20:11',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-02-28 09:20:11',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2026-02-28 09:20:11',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-02-28 09:20:11',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-02-28 09:20:11',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2026-02-28 09:20:11',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2026-02-28 09:20:11',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2026-02-28 09:20:11',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2026-02-28 09:20:11',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2026-02-28 09:20:11',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2026-02-28 09:20:11',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-02-28 09:20:11',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2026-02-28 09:20:11',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-02-28 09:20:11',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2026-02-28 09:20:11',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2026-02-28 09:20:11',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2026-02-28 09:20:11',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2026-02-28 09:20:11',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2026-02-28 09:20:11',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2026-02-28 09:20:11',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2026-02-28 09:20:11',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-02-28 09:20:11',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-02-28 09:20:11',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2026-02-28 09:20:11',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2026-02-28 09:20:11',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2026-02-28 09:20:06',NULL),(2,'OS::Glance::Image',1,'2026-02-28 09:20:06',NULL),(3,'OS::Nova::Aggregate',1,'2026-02-28 09:20:06',NULL),(4,'OS::Nova::Flavor',1,'2026-02-28 09:20:06',NULL),(5,'OS::Nova::Server',1,'2026-02-28 09:20:06',NULL),(6,'OS::Trove::Instance',1,'2026-02-28 09:20:11',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
INSERT INTO `task_info` (`task_id`, `input`, `result`, `message`) VALUES ('37acf13f-ecad-4866-ba20-0bf1fd80ecb8','{\"image_id\": \"05349771-69a6-40b0-a547-3eb5043c8d01\", \"import_req\": {\"method\": {\"name\": \"web-download\", \"uri\": \"http://does-not.exist/no/possible/way\"}, \"stores\": [\"default_backend\"]}, \"backend\": [\"default_backend\"]}',NULL,'Task failed due to Internal Error'),('44126639-e851-44c2-a24d-eff98238372f','{\"image_id\": \"acaa20bc-4ba4-4568-8d34-510237f0abb5\", \"import_req\": {\"method\": {\"name\": \"glance-direct\"}}, \"backend\": [\"default_backend\"]}','{\"image_id\": \"acaa20bc-4ba4-4568-8d34-510237f0abb5\"}','Copied 112 MiB'),('588a14af-a4d0-409d-a3b3-a018f7bf996a','{\"image_id\": \"087aef76-8992-43d2-904b-9de16190aade\", \"import_req\": {\"method\": {\"name\": \"glance-direct\"}}, \"backend\": [\"default_backend\"]}','{\"image_id\": \"087aef76-8992-43d2-904b-9de16190aade\"}','Copied 112 MiB'),('94f0548a-330b-4aaf-9901-020f1daaccc6','{\"image_id\": \"bd212f15-02ac-422d-b109-19f5cd1e442e\", \"import_req\": {\"method\": {\"name\": \"glance-direct\"}, \"all_stores\": true}, \"backend\": [\"default_backend\"]}','{\"image_id\": \"bd212f15-02ac-422d-b109-19f5cd1e442e\"}','Copied 0 MiB'),('9b4172ca-f343-4395-a27a-af97922ebc86','{\"image_id\": \"7f101383-680e-4e57-98bb-8ecf7964ef03\", \"import_req\": {\"method\": {\"name\": \"web-download\", \"uri\": \"https://download.cirros-cloud.net/0.6.2/cirros-0.6.2-x86_64-disk.img\"}, \"all_stores\": true}, \"backend\": [\"default_backend\"]}','{\"image_id\": \"7f101383-680e-4e57-98bb-8ecf7964ef03\"}','Copied 112 MiB'),('9f6aebc3-f91f-40b4-808f-5152594bf5f1','{\"image_properties\": {\"container_format\": \"bare\", \"disk_format\": \"qcow2\", \"visibility\": \"public\", \"name\": \"tempest-task_image-1874495436\"}, \"import_from_format\": \"qcow2\", \"import_from\": \"http://tempest-dummy-img-file-491970153.qcow2\"}',NULL,'Task failed due to Internal Error');
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
INSERT INTO `tasks` (`id`, `type`, `status`, `owner`, `expires_at`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `image_id`, `request_id`, `user_id`) VALUES ('37acf13f-ecad-4866-ba20-0bf1fd80ecb8','api_image_import','failure','bd35cb64e7b6408ca1905d0603b81114','2026-03-02 10:20:29','2026-02-28 10:20:29','2026-02-28 10:20:29',NULL,0,'05349771-69a6-40b0-a547-3eb5043c8d01','req-7f46c9e1-aa1a-4dfc-83f5-1b6f103f4386','12f3a8b77ead4d4a94f1839409d259cf'),('44126639-e851-44c2-a24d-eff98238372f','api_image_import','success','eb0c6377c53644999dac7645ece0c360','2026-03-02 09:56:27','2026-02-28 09:56:23','2026-02-28 09:56:27',NULL,0,'acaa20bc-4ba4-4568-8d34-510237f0abb5','req-d544af55-49a2-4d63-97b9-b8643b86b724','3c965705ef9f4f29b279dd463fa4cd3e'),('588a14af-a4d0-409d-a3b3-a018f7bf996a','api_image_import','success','eb0c6377c53644999dac7645ece0c360','2026-03-02 10:53:13','2026-02-28 10:53:08','2026-02-28 10:53:13',NULL,0,'087aef76-8992-43d2-904b-9de16190aade','req-46d79402-0599-439c-8358-9a6e77eafdab','3c965705ef9f4f29b279dd463fa4cd3e'),('94f0548a-330b-4aaf-9901-020f1daaccc6','api_image_import','success','a71fb26e084e46d6b656e41936ac5794','2026-03-02 10:09:29','2026-02-28 10:09:28','2026-02-28 10:09:29',NULL,0,'bd212f15-02ac-422d-b109-19f5cd1e442e','req-d673b724-fed5-4dc4-9553-30f5a7367b32','b88e9552ce584b7892a828621678b21b'),('9b4172ca-f343-4395-a27a-af97922ebc86','api_image_import','success','a71fb26e084e46d6b656e41936ac5794','2026-03-02 10:09:35','2026-02-28 10:09:31','2026-02-28 10:09:35',NULL,0,'7f101383-680e-4e57-98bb-8ecf7964ef03','req-921d51c2-4881-446e-8f11-97e54b184e43','b88e9552ce584b7892a828621678b21b'),('9f6aebc3-f91f-40b4-808f-5152594bf5f1','import','failure','ad75313c4c45408fb829ea5580d590d7','2026-03-02 10:09:14','2026-02-28 10:09:13','2026-02-28 10:09:14',NULL,0,NULL,'req-9029e056-1d49-4865-8b24-e62fac679155','e0057a4e259c411cb046434149db54bb');
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `external_id` (`external_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','11044767c16d4dec9f8daec1923058a4','c82e2e65a98541158f389f0d87d2945f','634761601c834b638c087b378a1488be',0),('UserProject','11044767c16d4dec9f8daec1923058a4','c82e2e65a98541158f389f0d87d2945f','e2e464fed49a4288b45e064e4d67dec3',0),('UserProject','1d9013252fae4332b0e73688f5e4136d','c82e2e65a98541158f389f0d87d2945f','634761601c834b638c087b378a1488be',0),('UserProject','1d9013252fae4332b0e73688f5e4136d','c82e2e65a98541158f389f0d87d2945f','e2e464fed49a4288b45e064e4d67dec3',0),('UserProject','2d3d96bfdd92494b8060dbccec7c980b','c82e2e65a98541158f389f0d87d2945f','634761601c834b638c087b378a1488be',0),('UserProject','2d3d96bfdd92494b8060dbccec7c980b','c82e2e65a98541158f389f0d87d2945f','e2e464fed49a4288b45e064e4d67dec3',0),('UserProject','3c965705ef9f4f29b279dd463fa4cd3e','eb0c6377c53644999dac7645ece0c360','b702bb347cb146fc815a66b28d21b1dc',0),('UserProject','3c965705ef9f4f29b279dd463fa4cd3e','eb0c6377c53644999dac7645ece0c360','e2e464fed49a4288b45e064e4d67dec3',0),('UserProject','4e3f86f8bfcc4998b82b29de47087e65','c82e2e65a98541158f389f0d87d2945f','634761601c834b638c087b378a1488be',0),('UserProject','4e3f86f8bfcc4998b82b29de47087e65','c82e2e65a98541158f389f0d87d2945f','e2e464fed49a4288b45e064e4d67dec3',0),('UserProject','4eea6738cacb4e0eac4facaba05c81fb','c82e2e65a98541158f389f0d87d2945f','634761601c834b638c087b378a1488be',0),('UserProject','4eea6738cacb4e0eac4facaba05c81fb','c82e2e65a98541158f389f0d87d2945f','e2e464fed49a4288b45e064e4d67dec3',0),('UserProject','aa2554a8e81c45cdacf7319e60ea5d5d','c82e2e65a98541158f389f0d87d2945f','634761601c834b638c087b378a1488be',0),('UserProject','aa2554a8e81c45cdacf7319e60ea5d5d','c82e2e65a98541158f389f0d87d2945f','e2e464fed49a4288b45e064e4d67dec3',0),('UserProject','b84ee62ae1124ca1a48ce0c9ca09411f','c82e2e65a98541158f389f0d87d2945f','c3167bbdc0e24db9bf6f3a76d543cae5',0),('UserProject','b84ee62ae1124ca1a48ce0c9ca09411f','c82e2e65a98541158f389f0d87d2945f','e2e464fed49a4288b45e064e4d67dec3',0),('UserProject','df8d53b73fd149b2bbf4282ae6f3ca67','c82e2e65a98541158f389f0d87d2945f','634761601c834b638c087b378a1488be',0),('UserProject','df8d53b73fd149b2bbf4282ae6f3ca67','c82e2e65a98541158f389f0d87d2945f','e2e464fed49a4288b45e064e4d67dec3',0),('UserProject','eac0b5da4a2d42e0a760d6171cb7af80','c82e2e65a98541158f389f0d87d2945f','634761601c834b638c087b378a1488be',0),('UserProject','eac0b5da4a2d42e0a760d6171cb7af80','c82e2e65a98541158f389f0d87d2945f','e2e464fed49a4288b45e064e4d67dec3',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('05d72fc016394cd6a7fd2970c93c713e',NULL,'public','228e348e9bc3492bbcd8ea1c517ec8e1','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('2191094aa6e24489a9aa8255bf37210f',NULL,'public','bc0fa7aa6ad446d3a3ecaeea64120b1c','https://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('247fbf759fa94264bf73ade08ef0beae',NULL,'internal','b2589c8af3c341dda093ae61cfb9acbe','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('2e4ae89f14594055a5899807c6cc028f',NULL,'public','16399c0308e74105a43bccac984cb981','https://manila-public-openstack.apps-crc.testing/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('3ef993780075445eb869b6c9d4f613de',NULL,'internal','bb59b9adb75b4efeba17566aeb24f1c1','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('40dee2bebd10448fbf5eea1894085a1c',NULL,'public','b2589c8af3c341dda093ae61cfb9acbe','https://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('45776e8180a24931a7e34e18dec1d840',NULL,'internal','7042bd28e78d483cb8e676e941780c15','https://manila-internal.openstack.svc:8786/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('466163a7f35b418094aacd0a5f23af7c',NULL,'internal','4b1e9890ec364114afeadd111948a859','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('46ec9c549feb4180b263be602fb5c90a',NULL,'internal','3b8c8f900c0e4f4e9e3048992645474d','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('6ecaa53394f443c5990f1b86ba01f3fb',NULL,'internal','228e348e9bc3492bbcd8ea1c517ec8e1','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('7459c2722b5c42e8826213aaebb57e63',NULL,'public','bb59b9adb75b4efeba17566aeb24f1c1','https://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('902ecc62e86c4957a509972c0dae61c5',NULL,'internal','11778b2894684b4b9661aa769b4b450c','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('97fa5b3937184f918e69e480fdd9ddce',NULL,'public','7042bd28e78d483cb8e676e941780c15','https://manila-public-openstack.apps-crc.testing/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('b9fde69951ee400cb1eaeca9f8e917db',NULL,'public','3e0e62e5936a4e58b78ccfade4e11f6c','https://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('ca7a360e748e4e35988d132109e3228c',NULL,'internal','bc0fa7aa6ad446d3a3ecaeea64120b1c','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('cbd452b761754d6286c99b3e3123bcb0',NULL,'public','11778b2894684b4b9661aa769b4b450c','https://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('dccacce6ed024422848f808eeaf9e140',NULL,'public','3b8c8f900c0e4f4e9e3048992645474d','https://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('e5f94e13239245ffa1a8c6799684a313',NULL,'internal','16399c0308e74105a43bccac984cb981','https://manila-internal.openstack.svc:8786/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('e735c4c2513e4617bd7fbb6949ba22e3',NULL,'public','4b1e9890ec364114afeadd111948a859','https://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('f50598cd5d9d422e9d03f742224f7324',NULL,'internal','3e0e62e5936a4e58b78ccfade4e11f6c','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('c3167bbdc0e24db9bf6f3a76d543cae5','b97fd32597a04077aadb94deb6f05340'),('e2e464fed49a4288b45e064e4d67dec3','c3167bbdc0e24db9bf6f3a76d543cae5');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=392 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'3c965705ef9f4f29b279dd463fa4cd3e','default','admin',0,NULL),(2,'4eea6738cacb4e0eac4facaba05c81fb','default','neutron',0,NULL),(3,'1d9013252fae4332b0e73688f5e4136d','default','cinder',0,NULL),(4,'2d3d96bfdd92494b8060dbccec7c980b','default','glance',0,NULL),(5,'11044767c16d4dec9f8daec1923058a4','default','ceilometer',0,NULL),(6,'4e3f86f8bfcc4998b82b29de47087e65','default','barbican',0,NULL),(7,'eac0b5da4a2d42e0a760d6171cb7af80','default','nova',0,NULL),(8,'df8d53b73fd149b2bbf4282ae6f3ca67','default','placement',0,NULL),(9,'b84ee62ae1124ca1a48ce0c9ca09411f','default','swift',0,NULL),(10,'aa2554a8e81c45cdacf7319e60ea5d5d','default','manila',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=393 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$Vje.tO.TPRkLkjHiPhRiluQjVV5GIWsUFeOUmQ4Y9J010r7/Y.Ejy',1772270439789334,NULL,'2026-02-28 09:20:39'),(2,2,NULL,0,'$2b$12$J5khERpes2jd/oIBJzh.BejqmxU3RLdcphr/6Zs2DgoLBlEM1w.JO',1772270509884425,NULL,'2026-02-28 09:21:49'),(3,3,NULL,0,'$2b$12$hxsy1XdQQDXU5v5l4OeP8O3irbYbVRdbTwyCEJHYCrdL0bTwdNTHy',1772270512075460,NULL,'2026-02-28 09:21:52'),(4,4,NULL,0,'$2b$12$pBcZbRkj8jjq.YdFP35JSuZX9raw7ijX0D//hhhxlQyaigofxwwse',1772270514184544,NULL,'2026-02-28 09:21:54'),(5,5,NULL,0,'$2b$12$5/lDKm48r2EipURhZ3yJUer7PgHSG2qH.c2avoafjRQ6oEPQHkIwW',1772270516340896,NULL,'2026-02-28 09:21:56'),(6,6,NULL,0,'$2b$12$vp9T.1WdfwzJESIaE9tL6eXSxFeKUSWan0JpAWFd3SrpeoJ4ikXkS',1772270518545821,NULL,'2026-02-28 09:21:58'),(7,7,NULL,0,'$2b$12$skeSmcfnKqfeogVw4PW7qedEha6GYw3pa4D32x9jCHYjUsZ8U4.7a',1772270520838339,NULL,'2026-02-28 09:22:00'),(8,8,NULL,0,'$2b$12$qJJ5h6I5uzrJMPoV9bh.peiUbzAb9ehkTxYqfv8GQSfEsTT7FD2Ru',1772270534718411,NULL,'2026-02-28 09:22:14'),(9,9,NULL,0,'$2b$12$url5NdQVU0uUOSMQZmTZqeEDllb/Lt5sminNyOMksxQdjWWjYYfn2',1772271328650260,NULL,'2026-02-28 09:35:28'),(10,10,NULL,0,'$2b$12$2jcpmGUMYz/qfJhtwPDEZ.d5.hxo66Iqvd3zfUahCSY9UZBHHJ8U.',1772272300015976,NULL,'2026-02-28 09:51:40');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('c82e2e65a98541158f389f0d87d2945f','service','{}','service',1,'default','default',0),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1),('eb0c6377c53644999dac7645ece0c360','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=818 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,'590103dc79334a6087219bc1c9892421',NULL,NULL,NULL,NULL,'2026-02-28 09:58:42',NULL,'2026-02-28 09:58:42',NULL,NULL),(2,NULL,NULL,'da07f960ae114b5a9fa6858b0ba7e1d2',NULL,NULL,NULL,NULL,'2026-02-28 09:58:42',NULL,'2026-02-28 09:58:42',NULL,NULL),(3,NULL,NULL,'e70d189eaec54fb6800e73dd428bf63e',NULL,NULL,NULL,NULL,'2026-02-28 09:58:44',NULL,'2026-02-28 09:58:44',NULL,NULL),(4,NULL,NULL,'a1abe63203ed478eaa18868ba68f9ea3',NULL,NULL,NULL,NULL,'2026-02-28 09:58:44',NULL,'2026-02-28 09:58:44',NULL,NULL),(5,NULL,'77118f28234443728da8b0a241f2d1fb',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:58:45',NULL,'2026-02-28 09:58:45',NULL,NULL),(6,NULL,'38cdc4f9a9344ef591b2c2dea605b07c',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:58:48',NULL,'2026-02-28 09:58:48',NULL,NULL),(7,NULL,'605ac30f12e24ff1afa5236c50fd0da9',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:58:49',NULL,'2026-02-28 09:58:49',NULL,NULL),(8,NULL,'c0f3ac18263b45dcb68d0865252f440d',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:58:50',NULL,'2026-02-28 09:58:50',NULL,NULL),(9,NULL,NULL,'5e038197d52d4aafa80ad349fc1f0cf9',NULL,NULL,NULL,NULL,'2026-02-28 09:58:53',NULL,'2026-02-28 09:58:53',NULL,NULL),(10,NULL,NULL,'ae3310d3b06f43679a5c61e62154f64d',NULL,NULL,NULL,NULL,'2026-02-28 09:58:53',NULL,'2026-02-28 09:58:53',NULL,NULL),(11,NULL,NULL,'ec0ff96c7f4041b9af5f5c87adecb7cb',NULL,NULL,NULL,NULL,'2026-02-28 09:58:54',NULL,'2026-02-28 09:58:54',NULL,NULL),(12,NULL,NULL,'46c38bd505de4df2be1e50515cf5b030',NULL,NULL,NULL,NULL,'2026-02-28 09:58:54',NULL,'2026-02-28 09:58:54',NULL,NULL),(13,NULL,'4dafc930366c403fa465c3efb30a464a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:58:54',NULL,'2026-02-28 09:58:54',NULL,NULL),(14,NULL,'a7a859aacb3042438bd6aa7a726ad843',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:58:55',NULL,'2026-02-28 09:58:55',NULL,NULL),(15,NULL,'f28a5634ecc1463a8aa7ba68960d6fd4',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:58:55',NULL,'2026-02-28 09:58:55',NULL,NULL),(16,NULL,'4f180909e22346eb91c2c3067afc6c2a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:58:56',NULL,'2026-02-28 09:58:56',NULL,NULL),(17,NULL,NULL,'9391362a054c4974bb439e4a05ed9fcb',NULL,NULL,NULL,NULL,'2026-02-28 09:58:58',NULL,'2026-02-28 09:58:58',NULL,NULL),(18,NULL,NULL,'ab9dd3b5706f429689a06dcf267b940b',NULL,NULL,NULL,NULL,'2026-02-28 09:58:59',NULL,'2026-02-28 09:58:59',NULL,NULL),(19,NULL,NULL,'e9b2856ce4b94e099c1313d253fb4074',NULL,NULL,NULL,NULL,'2026-02-28 09:58:59',NULL,'2026-02-28 09:58:59',NULL,NULL),(20,NULL,'915f20b5394f4d19aba77e35edffa5b5',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:58:59',NULL,'2026-02-28 09:58:59',NULL,NULL),(21,NULL,NULL,'bf653755896048359489425c72e9b351',NULL,NULL,NULL,NULL,'2026-02-28 09:58:59',NULL,'2026-02-28 09:58:59',NULL,NULL),(22,NULL,NULL,'94646edb36174490bae29ded1a719c94',NULL,NULL,NULL,NULL,'2026-02-28 09:58:59',NULL,'2026-02-28 09:58:59',NULL,NULL),(23,NULL,'34b5b126e5b2436d8147b68a813d9d5e',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:00',NULL,'2026-02-28 09:59:00',NULL,NULL),(24,NULL,'b8acd189a7a044579a75429b98f0af59',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:00',NULL,'2026-02-28 09:59:00',NULL,NULL),(25,NULL,'b01cd31e31c3404b8a04a00af20733b6',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:01',NULL,'2026-02-28 09:59:01',NULL,NULL),(26,NULL,'432ea552c1d645aba78f07f6c921690f',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:01',NULL,'2026-02-28 09:59:01',NULL,NULL),(27,NULL,NULL,'7cf60b81eb054d9293cb634469a9be72',NULL,NULL,NULL,NULL,'2026-02-28 09:59:03',NULL,'2026-02-28 09:59:03',NULL,NULL),(28,NULL,NULL,'f17d94c2885e4a989cc8347b49e1ea05',NULL,NULL,NULL,NULL,'2026-02-28 09:59:03',NULL,'2026-02-28 09:59:03',NULL,NULL),(29,NULL,'909ef10d37ab47c7bccb43f072d1d988',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:04',NULL,'2026-02-28 09:59:04',NULL,NULL),(30,NULL,'716cb221278442c5861ca9621116f635',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:06',NULL,'2026-02-28 09:59:06',NULL,NULL),(31,NULL,NULL,'750f1fae3d134641bb750de73defdff7',NULL,NULL,NULL,NULL,'2026-02-28 09:59:06',NULL,'2026-02-28 09:59:06',NULL,NULL),(32,NULL,NULL,'19876bcb4c754b64acc860a253e69f19',NULL,NULL,NULL,NULL,'2026-02-28 09:59:06',NULL,'2026-02-28 09:59:06',NULL,NULL),(33,NULL,'d976ecf18a894a5ba4750f494a9cbd31',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:07',NULL,'2026-02-28 09:59:07',NULL,NULL),(34,NULL,'a95a882cb9e0470881ab24b57a504170',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:09',NULL,'2026-02-28 09:59:09',NULL,NULL),(35,NULL,NULL,'d788b13ef6494357a5db8981d5d5cb31',NULL,NULL,NULL,NULL,'2026-02-28 09:59:09',NULL,'2026-02-28 09:59:09',NULL,NULL),(36,NULL,NULL,'2da526c251564b2faf9a266ee465dca8',NULL,NULL,NULL,NULL,'2026-02-28 09:59:10',NULL,'2026-02-28 09:59:10',NULL,NULL),(37,NULL,'43e8bba3259243d6ac7b62a99db0ecb8',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:11',NULL,'2026-02-28 09:59:11',NULL,NULL),(38,NULL,'b58a882031844ad7a52a637b65b11c2b',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:12',NULL,'2026-02-28 09:59:12',NULL,NULL),(39,NULL,NULL,'cd40b0c438af4dda866d36e5a08ab2eb',NULL,NULL,NULL,NULL,'2026-02-28 09:59:13',NULL,'2026-02-28 09:59:13',NULL,NULL),(40,NULL,NULL,'3485c9dd84f747d0bd864e4decf76001',NULL,NULL,NULL,NULL,'2026-02-28 09:59:13',NULL,'2026-02-28 09:59:13',NULL,NULL),(41,NULL,'8415cf4e6f174f76929c8f6b03d8b194',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:14',NULL,'2026-02-28 09:59:14',NULL,NULL),(42,NULL,'93a099c24ee542e984c533b76286a05a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:15',NULL,'2026-02-28 09:59:15',NULL,NULL),(43,NULL,NULL,'a1250d0caf304de7808083910d05a00c',NULL,NULL,NULL,NULL,'2026-02-28 09:59:16',NULL,'2026-02-28 09:59:16',NULL,NULL),(44,NULL,NULL,'94d6170cd2f94eff8bfdfa7b73db8937',NULL,NULL,NULL,NULL,'2026-02-28 09:59:16',NULL,'2026-02-28 09:59:16',NULL,NULL),(45,NULL,'6f64659b7d1844a690713e2e715e2c6c',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:18',NULL,'2026-02-28 09:59:18',NULL,NULL),(46,NULL,'523c1d05cdf54664aea9e70881c4e48e',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:18',NULL,'2026-02-28 09:59:18',NULL,NULL),(47,NULL,NULL,'7a8cb0d7bf534bdb81b8bfb7bd4b6170',NULL,NULL,NULL,NULL,'2026-02-28 09:59:19',NULL,'2026-02-28 09:59:19',NULL,NULL),(48,NULL,'8297b8140f524db284d08719828f622b',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:19',NULL,'2026-02-28 09:59:19',NULL,NULL),(49,NULL,NULL,'2fc584447fea4216b283d66bf6b9558b',NULL,NULL,NULL,NULL,'2026-02-28 09:59:19',NULL,'2026-02-28 09:59:19',NULL,NULL),(50,NULL,NULL,'abb365b7683543e19018c96d1aa0fb0c',NULL,NULL,NULL,NULL,'2026-02-28 09:59:20',NULL,'2026-02-28 09:59:20',NULL,NULL),(51,NULL,'0e2fbef76e8d499db2064eabd6a56f6e',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:21',NULL,'2026-02-28 09:59:21',NULL,NULL),(52,NULL,NULL,'f1b1660549ca4a109c7327eb1e35a3d6',NULL,NULL,NULL,NULL,'2026-02-28 09:59:21',NULL,'2026-02-28 09:59:21',NULL,NULL),(53,NULL,NULL,'6357e15831ec4adfb2817d622523e729',NULL,NULL,NULL,NULL,'2026-02-28 09:59:22',NULL,'2026-02-28 09:59:22',NULL,NULL),(54,NULL,'271f81aa4856442aa4626744d14cea0a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:22',NULL,'2026-02-28 09:59:22',NULL,NULL),(55,NULL,'9b5c0508d47c440dbdfd7208bc89a391',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:24',NULL,'2026-02-28 09:59:24',NULL,NULL),(56,NULL,'93c27def893c48c0998cd55456ed0e89',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:25',NULL,'2026-02-28 09:59:25',NULL,NULL),(57,NULL,NULL,'f285b05675cf49d8812463f1f0d35eb3',NULL,NULL,NULL,NULL,'2026-02-28 09:59:28',NULL,'2026-02-28 09:59:28',NULL,NULL),(58,NULL,NULL,'59d0f54f19814637812288345cb14d39',NULL,NULL,NULL,NULL,'2026-02-28 09:59:28',NULL,'2026-02-28 09:59:28',NULL,NULL),(59,NULL,NULL,'a9bdd6e6677641d5b14fdcd0b38a561c',NULL,NULL,NULL,NULL,'2026-02-28 09:59:29',NULL,'2026-02-28 09:59:29',NULL,NULL),(60,NULL,NULL,'af60c1e9e4cc410a8131c072a7942c5f',NULL,NULL,NULL,NULL,'2026-02-28 09:59:30',NULL,'2026-02-28 09:59:30',NULL,NULL),(61,NULL,'056bbee826f042bc922f04eebd9ccf55',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:31',NULL,'2026-02-28 09:59:31',NULL,NULL),(62,NULL,'064748214fa84ec2b096208e7d6a8f82',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:31',NULL,'2026-02-28 09:59:31',NULL,NULL),(63,NULL,'4e458b86a66849d59e5e6ae46a2356d4',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:32',NULL,'2026-02-28 09:59:32',NULL,NULL),(64,NULL,'90e80b12dc004305b89866ed2aaa33e3',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:32',NULL,'2026-02-28 09:59:32',NULL,NULL),(65,NULL,NULL,'cb44d68abc064a61bcc28bdd4b228751',NULL,NULL,NULL,NULL,'2026-02-28 09:59:36',NULL,'2026-02-28 09:59:36',NULL,NULL),(66,NULL,NULL,'587e4e738b214ce794be8d663cad657b',NULL,NULL,NULL,NULL,'2026-02-28 09:59:36',NULL,'2026-02-28 09:59:36',NULL,NULL),(67,NULL,NULL,'e5dcf48d8caa43a2a8c6dbfe28054e66',NULL,NULL,NULL,NULL,'2026-02-28 09:59:37',NULL,'2026-02-28 09:59:37',NULL,NULL),(68,NULL,NULL,'b1d5171d63e642d988c85af3419706e8',NULL,NULL,NULL,NULL,'2026-02-28 09:59:37',NULL,'2026-02-28 09:59:37',NULL,NULL),(69,NULL,'dcd4e6502ff64fafa8b5941efd85e62f',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:38',NULL,'2026-02-28 09:59:38',NULL,NULL),(70,NULL,'cd907f914e9047178ee445d0f7b94f15',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:38',NULL,'2026-02-28 09:59:38',NULL,NULL),(71,NULL,'dc47aae4632649e6978185d199df37da',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:38',NULL,'2026-02-28 09:59:38',NULL,NULL),(72,NULL,NULL,'8f91c252440146a0a7e821b021fc43cb',NULL,NULL,NULL,NULL,'2026-02-28 09:59:39',NULL,'2026-02-28 09:59:39',NULL,NULL),(73,NULL,NULL,'b6b7512626e943ebb1953f26e1daae3f',NULL,NULL,NULL,NULL,'2026-02-28 09:59:39',NULL,'2026-02-28 09:59:39',NULL,NULL),(74,NULL,'8ca10aa96dd34478a41752d93437aa14',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:39',NULL,'2026-02-28 09:59:39',NULL,NULL),(75,NULL,NULL,'8685b17d654648e2886b017a62bd0bee',NULL,NULL,NULL,NULL,'2026-02-28 09:59:39',NULL,'2026-02-28 09:59:39',NULL,NULL),(76,NULL,'bb53876da62b4295a4818e20ef59bcb4',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:40',NULL,'2026-02-28 09:59:40',NULL,NULL),(77,NULL,'af38be351c6545daba89e07787b9c190',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:41',NULL,'2026-02-28 09:59:41',NULL,NULL),(78,NULL,'663ed2bc4de04e89a9ad701b9894f7f3',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:42',NULL,'2026-02-28 09:59:42',NULL,NULL),(79,NULL,'80335c22deb64dfb9a01550be82014b9',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:43',NULL,'2026-02-28 09:59:43',NULL,NULL),(80,NULL,NULL,'0d5ea4e9eeca4e16803ecc2a630d67b0',NULL,NULL,NULL,NULL,'2026-02-28 09:59:45',NULL,'2026-02-28 09:59:45',NULL,NULL),(81,NULL,'c3aa85c5129347e5b32672f9dde01f4a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:45',NULL,'2026-02-28 09:59:45',NULL,NULL),(82,NULL,NULL,'bae2ea49855b4b1fac6831f57ee993c8',NULL,NULL,NULL,NULL,'2026-02-28 09:59:47',NULL,'2026-02-28 09:59:47',NULL,NULL),(83,NULL,NULL,'c11aeefe2bfc4e848778aec9b667cb56',NULL,NULL,NULL,NULL,'2026-02-28 09:59:47',NULL,'2026-02-28 09:59:47',NULL,NULL),(84,NULL,NULL,'d378bc062b524816bc2e15c6834a4b1a',NULL,NULL,NULL,NULL,'2026-02-28 09:59:48',NULL,'2026-02-28 09:59:48',NULL,NULL),(85,NULL,NULL,'2f68c0f096c54476bd6e2584393cfe5d',NULL,NULL,NULL,NULL,'2026-02-28 09:59:48',NULL,'2026-02-28 09:59:48',NULL,NULL),(86,NULL,'0274ee52aa964a63a165aefdcd2c0fd6',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:48',NULL,'2026-02-28 09:59:48',NULL,NULL),(87,NULL,'54c9600f113c4f9992f11aeea1612545',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:50',NULL,'2026-02-28 09:59:50',NULL,NULL),(88,NULL,'c991734281e64da88a7d6e0dfa5e1259',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:50',NULL,'2026-02-28 09:59:50',NULL,NULL),(89,NULL,'766b9bfacd624ff5a4b8c1317c449145',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:50',NULL,'2026-02-28 09:59:50',NULL,NULL),(90,NULL,NULL,'8a74a42fa9f941aaade83d63aded149a',NULL,NULL,NULL,NULL,'2026-02-28 09:59:52',NULL,'2026-02-28 09:59:52',NULL,NULL),(91,NULL,NULL,'7a0b86e74e7642048cf10d7d38941a52',NULL,NULL,NULL,NULL,'2026-02-28 09:59:53',NULL,'2026-02-28 09:59:53',NULL,NULL),(92,NULL,'62d5e04523a64c6da1016d4fc1f8c1ec',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:54',NULL,'2026-02-28 09:59:54',NULL,NULL),(93,NULL,NULL,'3eb9fb6a00294c6a93fd465a856fe57d',NULL,NULL,NULL,NULL,'2026-02-28 09:59:54',NULL,'2026-02-28 09:59:54',NULL,NULL),(94,NULL,NULL,'4f91389abdd34fc183cf5a8b8f922c4b',NULL,NULL,NULL,NULL,'2026-02-28 09:59:54',NULL,'2026-02-28 09:59:54',NULL,NULL),(95,NULL,'373e1d203c794b7289ebe110bf090a75',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:56',NULL,'2026-02-28 09:59:56',NULL,NULL),(96,NULL,'3083ee136590428d86a6fc1f6b87c54e',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:56',NULL,'2026-02-28 09:59:56',NULL,NULL),(97,NULL,'14582d149caa48a28c6b44a9f829bb9c',NULL,NULL,NULL,NULL,NULL,'2026-02-28 09:59:57',NULL,'2026-02-28 09:59:57',NULL,NULL),(98,NULL,NULL,'e07c4766140645ef86be2eec9fc9f652',NULL,NULL,NULL,NULL,'2026-02-28 10:00:01',NULL,'2026-02-28 10:00:01',NULL,NULL),(99,NULL,NULL,'bad99129cffa439fbce453c090640b7f',NULL,NULL,NULL,NULL,'2026-02-28 10:00:01',NULL,'2026-02-28 10:00:01',NULL,NULL),(100,NULL,NULL,'bbafa74de02c4669a9ff53e6ea9434c7',NULL,NULL,NULL,NULL,'2026-02-28 10:00:01',NULL,'2026-02-28 10:00:01',NULL,NULL),(101,NULL,NULL,'79037a3405534f868beb7ee698ef2edd',NULL,NULL,NULL,NULL,'2026-02-28 10:00:01',NULL,'2026-02-28 10:00:01',NULL,NULL),(102,NULL,'8ebb521075db4c24a71b0f2a5cb0ae5c',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:02',NULL,'2026-02-28 10:00:02',NULL,NULL),(103,NULL,'2d647b3d923447808e10d2c4eb3e8836',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:03',NULL,'2026-02-28 10:00:03',NULL,NULL),(104,NULL,'03fbb70d153048f79ebfcf6b9fd2dec6',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:04',NULL,'2026-02-28 10:00:04',NULL,NULL),(105,NULL,'2657391cb78c44a796b7aace27a1e62a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:04',NULL,'2026-02-28 10:00:04',NULL,NULL),(106,NULL,NULL,'330f60740eda47c589662819f21d61bf',NULL,NULL,NULL,NULL,'2026-02-28 10:00:11',NULL,'2026-02-28 10:00:11',NULL,NULL),(107,NULL,NULL,'37426d031271452cb11c8b1e92ebe277',NULL,NULL,NULL,NULL,'2026-02-28 10:00:11',NULL,'2026-02-28 10:00:11',NULL,NULL),(108,NULL,'7e5512e1a9b045fc9248442848fd8e4f',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:12',NULL,'2026-02-28 10:00:12',NULL,NULL),(109,NULL,'9cd849430cdc473391344d9e0c297bb7',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:16',NULL,'2026-02-28 10:00:16',NULL,NULL),(110,NULL,NULL,'1e1fe17532ba42f08284df768e59361b',NULL,NULL,NULL,NULL,'2026-02-28 10:00:18',NULL,'2026-02-28 10:00:18',NULL,NULL),(111,NULL,NULL,'e0f2bba9598a461fba2f1fe4009d870a',NULL,NULL,NULL,NULL,'2026-02-28 10:00:18',NULL,'2026-02-28 10:00:18',NULL,NULL),(112,NULL,'d8d11cb18c7a4f0bb17a76974faf1f67',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:19',NULL,'2026-02-28 10:00:19',NULL,NULL),(113,NULL,'2947548c2cf54e3c91bffea53b63c8ba',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:20',NULL,'2026-02-28 10:00:20',NULL,NULL),(114,NULL,NULL,'fc5e066f03a64ef5b49adb99999f5b0c',NULL,NULL,NULL,NULL,'2026-02-28 10:00:25',NULL,'2026-02-28 10:00:25',NULL,NULL),(115,NULL,NULL,'fa5feade41424d9bab590f6ed0b62ce8',NULL,NULL,NULL,NULL,'2026-02-28 10:00:25',NULL,'2026-02-28 10:00:25',NULL,NULL),(116,NULL,'fe3fb28f73414ad4992b8d4b499261e5',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:26',NULL,'2026-02-28 10:00:26',NULL,NULL),(117,NULL,'3147b37ab7ff46fab946bafe25948287',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:28',NULL,'2026-02-28 10:00:28',NULL,NULL),(118,NULL,NULL,'137c57a081ef448e87e6ee3762d09a10',NULL,NULL,NULL,NULL,'2026-02-28 10:00:32',NULL,'2026-02-28 10:00:32',NULL,NULL),(119,NULL,NULL,'fbbda653764b41c6a0d9c5f1a589bdfe',NULL,NULL,NULL,NULL,'2026-02-28 10:00:32',NULL,'2026-02-28 10:00:32',NULL,NULL),(120,NULL,NULL,'fe16ef4b58de443ba0abd815064150e4',NULL,NULL,NULL,NULL,'2026-02-28 10:00:33',NULL,'2026-02-28 10:00:33',NULL,NULL),(121,NULL,NULL,'00b1f480c2ee43839920282c405181f1',NULL,NULL,NULL,NULL,'2026-02-28 10:00:33',NULL,'2026-02-28 10:00:33',NULL,NULL),(122,NULL,NULL,'bbb695a450c4426098c91e30411503c1',NULL,NULL,NULL,NULL,'2026-02-28 10:00:33',NULL,'2026-02-28 10:00:33',NULL,NULL),(123,NULL,NULL,'fbc07469967345c7aeba228950a94243',NULL,NULL,NULL,NULL,'2026-02-28 10:00:33',NULL,'2026-02-28 10:00:33',NULL,NULL),(124,NULL,'28fea2ec5f724190b6d7966ed36747db',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:34',NULL,'2026-02-28 10:00:34',NULL,NULL),(125,NULL,'7d9c93e3ee774e3ea2b19d16b9ceab1b',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:34',NULL,'2026-02-28 10:00:34',NULL,NULL),(126,NULL,'eed31d836a3a47e1b91eea6af27cad28',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:35',NULL,'2026-02-28 10:00:35',NULL,NULL),(127,NULL,'179ac1b345e44371a698f9ff7f4ed1d4',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:35',NULL,'2026-02-28 10:00:35',NULL,NULL),(128,NULL,'e4f45092f1eb4be4a943c7f5a66702ec',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:35',NULL,'2026-02-28 10:00:35',NULL,NULL),(129,NULL,'ff7c097fa27e4209aa25291c428ce04a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:36',NULL,'2026-02-28 10:00:36',NULL,NULL),(130,NULL,NULL,'cb71641f461242f9afa154410c27a4c5',NULL,NULL,NULL,NULL,'2026-02-28 10:00:37',NULL,'2026-02-28 10:00:37',NULL,NULL),(131,NULL,NULL,'aa88e7a4d6a74829a2aa88687f3e0d9b',NULL,NULL,NULL,NULL,'2026-02-28 10:00:38',NULL,'2026-02-28 10:00:38',NULL,NULL),(132,NULL,'e4ed979bda47466ebd87517c73a12e9d',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:39',NULL,'2026-02-28 10:00:39',NULL,NULL),(133,NULL,NULL,'6da7ad858e094cfb812f8ec94247980c',NULL,NULL,NULL,NULL,'2026-02-28 10:00:40',NULL,'2026-02-28 10:00:40',NULL,NULL),(134,NULL,NULL,'3a90fad970a247aaacb1f4327ac53724',NULL,NULL,NULL,NULL,'2026-02-28 10:00:40',NULL,'2026-02-28 10:00:40',NULL,NULL),(135,NULL,'048b401fefe0402ab609aa3c8e535be6',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:41',NULL,'2026-02-28 10:00:41',NULL,NULL),(136,NULL,'a7b8b5a6eef14d3a912a483c8b9c9144',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:42',NULL,'2026-02-28 10:00:42',NULL,NULL),(137,NULL,'ca586db7866547f5bbdaadafcbe36bd3',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:44',NULL,'2026-02-28 10:00:44',NULL,NULL),(138,NULL,NULL,'522df4d008da4d19b398949ef97500c2',NULL,NULL,NULL,NULL,'2026-02-28 10:00:46',NULL,'2026-02-28 10:00:46',NULL,NULL),(139,NULL,'e1a006c845c24c2cbc07c2e04def58f1',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:46',NULL,'2026-02-28 10:00:46',NULL,NULL),(140,NULL,NULL,'8861f29ced7d47f4b9addeaff6e9cb5b',NULL,NULL,NULL,NULL,'2026-02-28 10:00:46',NULL,'2026-02-28 10:00:46',NULL,NULL),(141,NULL,NULL,'a976fa9c0d074e26a40dab0bce00f1e6',NULL,NULL,NULL,NULL,'2026-02-28 10:00:46',NULL,'2026-02-28 10:00:46',NULL,NULL),(142,NULL,'4f3cb1baa3f54713a0a57fb7d5bb8ae4',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:48',NULL,'2026-02-28 10:00:48',NULL,NULL),(143,NULL,NULL,'0fd70750260c43a3a303b4346aed0e9a',NULL,NULL,NULL,NULL,'2026-02-28 10:00:48',NULL,'2026-02-28 10:00:48',NULL,NULL),(144,NULL,NULL,'12e661cb0cc24d3f87d5ad5e55437da9',NULL,NULL,NULL,NULL,'2026-02-28 10:00:48',NULL,'2026-02-28 10:00:48',NULL,NULL),(145,NULL,'c646fcb3f3674274a9c518cb94787b84',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:48',NULL,'2026-02-28 10:00:48',NULL,NULL),(146,NULL,'7d3a67f58b574202981a05108643a28a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:50',NULL,'2026-02-28 10:00:50',NULL,NULL),(147,NULL,'962ad781bef44a669f4439ec50ff4508',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:51',NULL,'2026-02-28 10:00:51',NULL,NULL),(148,NULL,NULL,'95ddf16bda4143ea941ce17cfc911405',NULL,NULL,NULL,NULL,'2026-02-28 10:00:51',NULL,'2026-02-28 10:00:51',NULL,NULL),(149,NULL,NULL,'25abadf852654cf8950a0835e5a1f117',NULL,NULL,NULL,NULL,'2026-02-28 10:00:52',NULL,'2026-02-28 10:00:52',NULL,NULL),(150,NULL,'5c7fa75bb7a0446e9363c55f99a80443',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:53',NULL,'2026-02-28 10:00:53',NULL,NULL),(151,NULL,'4ac49531ed064b46ad859254f3bb2a57',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:54',NULL,'2026-02-28 10:00:54',NULL,NULL),(152,NULL,NULL,'1f0dd2a3b5b84083a9287c8f111410df',NULL,NULL,NULL,NULL,'2026-02-28 10:00:55',NULL,'2026-02-28 10:00:55',NULL,NULL),(153,NULL,NULL,'f2388a890ecd427ba9981f7b98660796',NULL,NULL,NULL,NULL,'2026-02-28 10:00:55',NULL,'2026-02-28 10:00:55',NULL,NULL),(154,NULL,'54411192e87e44039874d4294285647b',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:56',NULL,'2026-02-28 10:00:56',NULL,NULL),(155,NULL,'179a867733e14a75a3ab8f80bc9a84dc',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:00:57',NULL,'2026-02-28 10:00:57',NULL,NULL),(156,NULL,NULL,'779d41ff145d4a3abf360c3a479b8490',NULL,NULL,NULL,NULL,'2026-02-28 10:01:03',NULL,'2026-02-28 10:01:03',NULL,NULL),(157,NULL,NULL,'333fd7f611a24adbbb4944125360b69f',NULL,NULL,NULL,NULL,'2026-02-28 10:01:03',NULL,'2026-02-28 10:01:03',NULL,NULL),(158,NULL,'496a553567e542c5b07090b179f96e31',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:01:06',NULL,'2026-02-28 10:01:06',NULL,NULL),(159,NULL,'49992439be834f248f9ba70f4239b1c9',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:01:08',NULL,'2026-02-28 10:01:08',NULL,NULL),(160,NULL,NULL,'7ac435168e6f4ccba7cb81ee4a4de7b3',NULL,NULL,NULL,NULL,'2026-02-28 10:01:12',NULL,'2026-02-28 10:01:12',NULL,NULL),(161,NULL,NULL,'891f2361e11443dfae5ca6c5cec9c6e7',NULL,NULL,NULL,NULL,'2026-02-28 10:01:12',NULL,'2026-02-28 10:01:12',NULL,NULL),(162,NULL,'0ccb15001174492391bb624e86727896',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:01:13',NULL,'2026-02-28 10:01:13',NULL,NULL),(163,NULL,'7a4e4f81e7524bc18b13babed54d6af0',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:01:14',NULL,'2026-02-28 10:01:14',NULL,NULL),(164,NULL,NULL,'bf06d33f07d54a60bff952b57a770e77',NULL,NULL,NULL,NULL,'2026-02-28 10:01:15',NULL,'2026-02-28 10:01:15',NULL,NULL),(165,NULL,NULL,'b07a0c19ab0f464e9414b8de1f3f23b0',NULL,NULL,NULL,NULL,'2026-02-28 10:01:15',NULL,'2026-02-28 10:01:15',NULL,NULL),(166,NULL,NULL,'659c6b9da71d4b6d88c16cd01e3e121b',NULL,NULL,NULL,NULL,'2026-02-28 10:01:16',NULL,'2026-02-28 10:01:16',NULL,NULL),(167,NULL,'383ac6e5ec8946a0afec20ecf5e8021e',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:01:17',NULL,'2026-02-28 10:01:17',NULL,NULL),(168,NULL,'b3cac0b1e8b5417184b3b8163e0c489a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:01:18',NULL,'2026-02-28 10:01:18',NULL,NULL),(169,NULL,NULL,'21698ebd1b7c4cca8d47ac0414e7b2e3',NULL,NULL,NULL,NULL,'2026-02-28 10:01:19',NULL,'2026-02-28 10:01:19',NULL,NULL),(170,NULL,NULL,'18da6b266c9d4acd9353f4e385565f70',NULL,NULL,NULL,NULL,'2026-02-28 10:01:19',NULL,'2026-02-28 10:01:19',NULL,NULL),(171,NULL,'b115c4f46f404786a5d71f0b12cc0ab2',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:01:19',NULL,'2026-02-28 10:01:19',NULL,NULL),(172,NULL,'a2f5e82f36474a5d9592018c70faa496',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:01:20',NULL,'2026-02-28 10:01:20',NULL,NULL),(173,NULL,'cf6e397068364b4fa1b2435938258f83',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:01:21',NULL,'2026-02-28 10:01:21',NULL,NULL),(174,NULL,NULL,'d12cfb1e6b0d4d93916ba6a6c4b75cfc',NULL,NULL,NULL,NULL,'2026-02-28 10:01:56',NULL,'2026-02-28 10:01:56',NULL,NULL),(175,NULL,NULL,'b9190d82939143d782afeba7662b6241',NULL,NULL,NULL,NULL,'2026-02-28 10:01:57',NULL,'2026-02-28 10:01:57',NULL,NULL),(176,NULL,NULL,'3b1dc716928742ca935bb155783e2d9a',NULL,NULL,NULL,NULL,'2026-02-28 10:01:58',NULL,'2026-02-28 10:01:58',NULL,NULL),(177,NULL,'59eeacf1fc7e434d81334a4fff5e51d9',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:01:58',NULL,'2026-02-28 10:01:58',NULL,NULL),(178,NULL,'446562351a804787bd6c523245bada39',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:01:58',NULL,'2026-02-28 10:01:58',NULL,NULL),(179,NULL,'388f2f7e6d59433a8c88217806df2e33',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:01:58',NULL,'2026-02-28 10:01:58',NULL,NULL),(180,NULL,NULL,'e1baa264bdcf43f4a0cebf74d400661b',NULL,NULL,NULL,NULL,'2026-02-28 10:02:01',NULL,'2026-02-28 10:02:01',NULL,NULL),(181,NULL,'51e3eebd21f348faa6e24906fe6dae68',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:02:02',NULL,'2026-02-28 10:02:02',NULL,NULL),(182,NULL,NULL,'d4b79ce4547c4651aa83eae44a585acc',NULL,NULL,NULL,NULL,'2026-02-28 10:02:04',NULL,'2026-02-28 10:02:04',NULL,NULL),(183,NULL,NULL,'cf52af81168e4f869f4d8ce74effab2a',NULL,NULL,NULL,NULL,'2026-02-28 10:02:04',NULL,'2026-02-28 10:02:04',NULL,NULL),(184,NULL,'ebf998b81b5e47b39834b1c560a3220b',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:02:05',NULL,'2026-02-28 10:02:05',NULL,NULL),(185,NULL,NULL,'48a7524535c946a6bb9d85d38f17896f',NULL,NULL,NULL,NULL,'2026-02-28 10:02:06',NULL,'2026-02-28 10:02:06',NULL,NULL),(186,NULL,'2cf3914a85fa495690640bacfea249b5',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:02:06',NULL,'2026-02-28 10:02:06',NULL,NULL),(187,NULL,'1044a53c61ad42b9a01692514ca6bdec',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:02:08',NULL,'2026-02-28 10:02:08',NULL,NULL),(188,NULL,NULL,'93c7041caa9e497f876c52f3261e97d9',NULL,NULL,NULL,NULL,'2026-02-28 10:02:10',NULL,'2026-02-28 10:02:10',NULL,NULL),(189,NULL,NULL,'eda70465920243f1a803f3cba5f2a714',NULL,NULL,NULL,NULL,'2026-02-28 10:02:10',NULL,'2026-02-28 10:02:10',NULL,NULL),(190,NULL,'503bf771a92a4049b01db8e7ffa7926b',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:02:12',NULL,'2026-02-28 10:02:12',NULL,NULL),(191,NULL,'230f58be0b5b4b55a02f2a1c9ede4968',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:02:12',NULL,'2026-02-28 10:02:12',NULL,NULL),(192,NULL,NULL,'40663a133b2e49d98d12a6b547bcdf96',NULL,NULL,NULL,NULL,'2026-02-28 10:02:18',NULL,'2026-02-28 10:02:18',NULL,NULL),(193,NULL,'77b16dca4a0349faa70c2658f7b3d54c',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:02:20',NULL,'2026-02-28 10:02:20',NULL,NULL),(194,NULL,NULL,'c1d3b80b39ba4f3392d63b05c85009e2',NULL,NULL,NULL,NULL,'2026-02-28 10:02:24',NULL,'2026-02-28 10:02:24',NULL,NULL),(195,NULL,NULL,'29c668ed41724c5cba4cec3db22c4e4c',NULL,NULL,NULL,NULL,'2026-02-28 10:02:24',NULL,'2026-02-28 10:02:24',NULL,NULL),(196,NULL,'8a25ecc7a73c497a82af21d72e02c011',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:02:26',NULL,'2026-02-28 10:02:26',NULL,NULL),(197,NULL,'a1e90097927e484eb57dee6ac05b7b47',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:02:28',NULL,'2026-02-28 10:02:28',NULL,NULL),(198,NULL,NULL,'78e7cf5a2d834d9c9c5fae5f0c2bd052',NULL,NULL,NULL,NULL,'2026-02-28 10:02:31',NULL,'2026-02-28 10:02:31',NULL,NULL),(199,NULL,'58cb059a8f6d438296555d2248cc0f14',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:02:32',NULL,'2026-02-28 10:02:32',NULL,NULL),(200,NULL,NULL,'4323f5f6c03442de891daa600f5de9ff',NULL,NULL,NULL,NULL,'2026-02-28 10:02:32',NULL,'2026-02-28 10:02:32',NULL,NULL),(201,NULL,NULL,'f4b54419b238403e8f44416deed48769',NULL,NULL,NULL,NULL,'2026-02-28 10:02:32',NULL,'2026-02-28 10:02:32',NULL,NULL),(202,NULL,'7f9b13595f5f493dbfd3168de38b80f3',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:02:34',NULL,'2026-02-28 10:02:34',NULL,NULL),(203,NULL,'46e91f35b11c4b169f62d453fcd91dfe',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:02:35',NULL,'2026-02-28 10:02:35',NULL,NULL),(204,NULL,NULL,'b4fc91115ddb4082abfeb4a98ea636d1',NULL,NULL,NULL,NULL,'2026-02-28 10:02:46',NULL,'2026-02-28 10:02:46',NULL,NULL),(205,NULL,'39dda633e73046d7a2bfabb3d64085b8',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:02:47',NULL,'2026-02-28 10:02:47',NULL,NULL),(206,NULL,NULL,'4fb1e2bbed9c4e2395c13dba974f8603',NULL,NULL,NULL,NULL,'2026-02-28 10:02:48',NULL,'2026-02-28 10:02:48',NULL,NULL),(207,NULL,NULL,'0e532ad680b24bcbac2ad58e279c9d00',NULL,NULL,NULL,NULL,'2026-02-28 10:02:48',NULL,'2026-02-28 10:02:48',NULL,NULL),(208,NULL,'339b7f5b41a54615b051fb9d036072dd',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:02:50',NULL,'2026-02-28 10:02:50',NULL,NULL),(209,NULL,'81c87609780749f7b368e51bddc62945',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:02:51',NULL,'2026-02-28 10:02:51',NULL,NULL),(210,NULL,NULL,'efdb04dd55214946958e43f96b704a42',NULL,NULL,NULL,NULL,'2026-02-28 10:02:55',NULL,'2026-02-28 10:02:55',NULL,NULL),(211,NULL,NULL,'f59f3bb6f3a741c1814778dc86465db9',NULL,NULL,NULL,NULL,'2026-02-28 10:02:55',NULL,'2026-02-28 10:02:55',NULL,NULL),(212,NULL,NULL,'60aaf6ef28624725bb5aa26740775451',NULL,NULL,NULL,NULL,'2026-02-28 10:02:55',NULL,'2026-02-28 10:02:55',NULL,NULL),(213,NULL,'ba2c541f441144ec9ad63dcf0fa3a4e6',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:02:56',NULL,'2026-02-28 10:02:56',NULL,NULL),(214,NULL,'511e52180afe46c795ddc80760bb5511',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:02:57',NULL,'2026-02-28 10:02:57',NULL,NULL),(215,NULL,'f37977e222ab46ee9c672f6bd0aba4ce',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:02:58',NULL,'2026-02-28 10:02:58',NULL,NULL),(216,NULL,NULL,'606e8a7f7511413bb49ed95fbc4f9aca',NULL,NULL,NULL,NULL,'2026-02-28 10:03:01',NULL,'2026-02-28 10:03:01',NULL,NULL),(217,NULL,NULL,'9fc51bed27404445b180d2a5839281c4',NULL,NULL,NULL,NULL,'2026-02-28 10:03:02',NULL,'2026-02-28 10:03:02',NULL,NULL),(218,NULL,'696daa1e8c294d898761db83632cc6fc',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:03:03',NULL,'2026-02-28 10:03:03',NULL,NULL),(219,NULL,'55e76f245ba743de97ff0c2ef44a00c9',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:03:04',NULL,'2026-02-28 10:03:04',NULL,NULL),(220,NULL,NULL,'59da8cf5041f4ffc8a44b2cebe936435',NULL,NULL,NULL,NULL,'2026-02-28 10:03:11',NULL,'2026-02-28 10:03:11',NULL,NULL),(221,NULL,'996394b722b44628a2278c0d532bbbbf',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:03:11',NULL,'2026-02-28 10:03:11',NULL,NULL),(222,NULL,NULL,'678df28a33b147768bd6e1e5d3b17ccf',NULL,NULL,NULL,NULL,'2026-02-28 10:03:33',NULL,'2026-02-28 10:03:33',NULL,NULL),(223,NULL,'2ee8273ac001494c973c44a7dd357180',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:03:34',NULL,'2026-02-28 10:03:34',NULL,NULL),(224,NULL,NULL,'687a9b7a6c924ddd8903c1fef24ec075',NULL,NULL,NULL,NULL,'2026-02-28 10:03:35',NULL,'2026-02-28 10:03:35',NULL,NULL),(225,NULL,'2da223bc11bf4dfa90c6578da5c5efd0',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:03:36',NULL,'2026-02-28 10:03:36',NULL,NULL),(226,NULL,NULL,'2973b4a88c3d4417a732901954bb6c6a',NULL,NULL,NULL,NULL,'2026-02-28 10:03:42',NULL,'2026-02-28 10:03:42',NULL,NULL),(227,NULL,'dd177a65e6274abe9b6091a2f34c319c',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:03:43',NULL,'2026-02-28 10:03:43',NULL,NULL),(228,NULL,NULL,'8bee8f40a9a348bf9535f36335a2f730',NULL,NULL,NULL,NULL,'2026-02-28 10:03:45',NULL,'2026-02-28 10:03:45',NULL,NULL),(229,NULL,'f0f1796f2631496b93c901c830ca4a4c',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:03:46',NULL,'2026-02-28 10:03:46',NULL,NULL),(230,NULL,NULL,'01b8d83f48a047d18fd7b93f4e57e7cb',NULL,NULL,NULL,NULL,'2026-02-28 10:03:48',NULL,'2026-02-28 10:03:48',NULL,NULL),(231,NULL,'79489ad3bbb049198a0bc73ee71e0d41',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:03:49',NULL,'2026-02-28 10:03:49',NULL,NULL),(232,NULL,NULL,'4acbe674b8684ad0927819284cc571b0',NULL,NULL,NULL,NULL,'2026-02-28 10:03:53',NULL,'2026-02-28 10:03:53',NULL,NULL),(233,NULL,'f5a14176de5746d59940d66238c3de86',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:03:56',NULL,'2026-02-28 10:03:56',NULL,NULL),(234,NULL,NULL,'4243599ad0d048f594bb024c24de3696',NULL,NULL,NULL,NULL,'2026-02-28 10:03:56',NULL,'2026-02-28 10:03:56',NULL,NULL),(235,NULL,'50baaf787aa74602956d26c2e62174bf',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:03:57',NULL,'2026-02-28 10:03:57',NULL,NULL),(236,NULL,NULL,'7a44c3f76b144221b23743a554a4a839',NULL,NULL,NULL,NULL,'2026-02-28 10:04:28',NULL,'2026-02-28 10:04:28',NULL,NULL),(237,NULL,'1a4f47b449434c708378388c3e76610e',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:04:29',NULL,'2026-02-28 10:04:29',NULL,NULL),(238,NULL,NULL,'9d1b896ce12e429e997b9df12319e8c7',NULL,NULL,NULL,NULL,'2026-02-28 10:04:46',NULL,'2026-02-28 10:04:46',NULL,NULL),(239,NULL,'87d5e3ac10694292a43d233004e2123a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:04:48',NULL,'2026-02-28 10:04:48',NULL,NULL),(240,NULL,NULL,'6bbc470612fa48afb6c2a143ba966473',NULL,NULL,NULL,NULL,'2026-02-28 10:05:26',NULL,'2026-02-28 10:05:26',NULL,NULL),(241,NULL,'135c387aaa024e42b1c3c19237591cf3',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:05:27',NULL,'2026-02-28 10:05:27',NULL,NULL),(242,NULL,NULL,'2737540b5d9a437cac0ea91b25f0c5d8',NULL,NULL,NULL,NULL,'2026-02-28 10:05:28',NULL,'2026-02-28 10:05:28',NULL,NULL),(243,NULL,'da458887a8634c5a8b9a38fcbcc44e07',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:05:28',NULL,'2026-02-28 10:05:28',NULL,NULL),(244,NULL,NULL,'210bed2b688c4f49b3b195105d4a3357',NULL,NULL,NULL,NULL,'2026-02-28 10:05:31',NULL,'2026-02-28 10:05:31',NULL,NULL),(245,NULL,'ecf0a8924569418bb89c0a8d87bf4154',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:05:34',NULL,'2026-02-28 10:05:34',NULL,NULL),(246,NULL,NULL,'0b71bb5872674804aa34524e7a87be8f',NULL,NULL,NULL,NULL,'2026-02-28 10:05:47',NULL,'2026-02-28 10:05:47',NULL,NULL),(247,NULL,'eb703db4587f4cb691438651014cecb2',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:05:49',NULL,'2026-02-28 10:05:49',NULL,NULL),(248,NULL,NULL,'af24a6d4c4c246cf80645675cc85b3c6',NULL,NULL,NULL,NULL,'2026-02-28 10:06:07',NULL,'2026-02-28 10:06:07',NULL,NULL),(249,NULL,'2fc066bf883d477dab2475efe229ee9f',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:06:08',NULL,'2026-02-28 10:06:08',NULL,NULL),(250,NULL,NULL,'d83ef2b77047458db9060496f444a384',NULL,NULL,NULL,NULL,'2026-02-28 10:06:59',NULL,'2026-02-28 10:06:59',NULL,NULL),(251,NULL,'b2155277af74424e955b1904a947ab64',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:07:00',NULL,'2026-02-28 10:07:00',NULL,NULL),(252,NULL,NULL,'163582c3e6a34c87b52f82ac4f189f77',NULL,NULL,NULL,NULL,'2026-02-28 10:07:06',NULL,'2026-02-28 10:07:06',NULL,NULL),(253,NULL,'a2ce6ed219d94b3b88c2d2d7001f6c3a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:07:08',NULL,'2026-02-28 10:07:08',NULL,NULL),(254,NULL,NULL,'2fb3d513ea594a16b369828f6241faad',NULL,NULL,NULL,NULL,'2026-02-28 10:07:15',NULL,'2026-02-28 10:07:15',NULL,NULL),(255,NULL,'2aad5348ceb64741a41ce47f4b69ccdf',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:07:17',NULL,'2026-02-28 10:07:17',NULL,NULL),(256,NULL,NULL,'c9a7366cce344abcb7310041ed02610a',NULL,NULL,NULL,NULL,'2026-02-28 10:07:38',NULL,'2026-02-28 10:07:38',NULL,NULL),(257,NULL,'5df107d99f104138b864f28cf3b749ad',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:07:39',NULL,'2026-02-28 10:07:39',NULL,NULL),(258,NULL,NULL,'f1d18942aa7a4f4f9f673058f8c5f232',NULL,NULL,NULL,NULL,'2026-02-28 10:07:39',NULL,'2026-02-28 10:07:39',NULL,NULL),(259,NULL,NULL,'4c3e34e421f447f386ae2320858c95b8',NULL,NULL,NULL,NULL,'2026-02-28 10:07:40',NULL,'2026-02-28 10:07:40',NULL,NULL),(260,NULL,'5478fb37e3fa483c86ed85ad939d42da',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:07:40',NULL,'2026-02-28 10:07:40',NULL,NULL),(261,NULL,NULL,'391fc26f8c094222ab6379abd93c0cd7',NULL,NULL,NULL,NULL,'2026-02-28 10:07:40',NULL,'2026-02-28 10:07:40',NULL,NULL),(262,NULL,'696c1808e0d64cc7b255195d851e06d1',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:07:41',NULL,'2026-02-28 10:07:41',NULL,NULL),(263,NULL,NULL,'6d0e0a14ccaa4d7aae0da6f110ac34a2',NULL,NULL,NULL,NULL,'2026-02-28 10:07:43',NULL,'2026-02-28 10:07:43',NULL,NULL),(264,NULL,'ec17ccb74bce456388b064c9e93f4cc9',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:07:45',NULL,'2026-02-28 10:07:45',NULL,NULL),(265,NULL,NULL,'60711ac7e710489e88d5986629400935',NULL,NULL,NULL,NULL,'2026-02-28 10:07:49',NULL,'2026-02-28 10:07:49',NULL,NULL),(266,NULL,'38c881fc94ab4413af2380f5ed085da7',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:07:51',NULL,'2026-02-28 10:07:51',NULL,NULL),(267,NULL,NULL,'606300b6675944f6a558effb03c9be57',NULL,NULL,NULL,NULL,'2026-02-28 10:07:52',NULL,'2026-02-28 10:07:52',NULL,NULL),(268,NULL,'96e86ed701304d78bdf80efa568a7706',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:07:53',NULL,'2026-02-28 10:07:53',NULL,NULL),(269,NULL,NULL,'0c60d7ea01f44c2c855907df7c4ada72',NULL,NULL,NULL,NULL,'2026-02-28 10:07:56',NULL,'2026-02-28 10:07:56',NULL,NULL),(270,NULL,'ac2b797f8a8c4e869434b3e11b5d4cb3',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:07:56',NULL,'2026-02-28 10:07:56',NULL,NULL),(271,NULL,'ad4bdc14fef147939470ca461ea10926',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:07:57',NULL,'2026-02-28 10:07:57',NULL,NULL),(272,NULL,NULL,'7b911658e33a44b7b9db6eb162f28eaf',NULL,NULL,NULL,NULL,'2026-02-28 10:07:57',NULL,'2026-02-28 10:07:57',NULL,NULL),(273,NULL,NULL,'76ca3178cc9f43fcaa44d640dc64c447',NULL,NULL,NULL,NULL,'2026-02-28 10:07:57',NULL,'2026-02-28 10:07:57',NULL,NULL),(274,NULL,'021578c53cb249cba3f02d003d1d6d83',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:00',NULL,'2026-02-28 10:08:00',NULL,NULL),(275,NULL,'87b582e14dc946fba579b2f127f33fe4',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:02',NULL,'2026-02-28 10:08:02',NULL,NULL),(276,NULL,'c507187144964b409a15821a8a7df5de',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:06',NULL,'2026-02-28 10:08:06',NULL,NULL),(277,NULL,'d9c2c30fe4864d20836eb0c96f713217',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:07',NULL,'2026-02-28 10:08:07',NULL,NULL),(278,NULL,'3bb0051328824451974ef6ec7ee9f18a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:08',NULL,'2026-02-28 10:08:08',NULL,NULL),(279,NULL,NULL,'93b99233c0af4b79bc4cc3139fb26bd1',NULL,NULL,NULL,NULL,'2026-02-28 10:08:09',NULL,'2026-02-28 10:08:09',NULL,NULL),(280,NULL,NULL,'015057fcb4bb4aae989809dcefd43684',NULL,NULL,NULL,NULL,'2026-02-28 10:08:10',NULL,'2026-02-28 10:08:10',NULL,NULL),(281,NULL,'829e53f074b0414e9348a1ef5342993e',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:11',NULL,'2026-02-28 10:08:11',NULL,NULL),(282,NULL,'99d49e4fae914012afe73236840ef807',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:15',NULL,'2026-02-28 10:08:15',NULL,NULL),(283,NULL,'efb858b171b34f6cbcc70a7c837ac825',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:21',NULL,'2026-02-28 10:08:21',NULL,NULL),(284,NULL,'f05f3135c10e450fb608e2396316c00a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:21',NULL,'2026-02-28 10:08:21',NULL,NULL),(285,NULL,NULL,'7620919b20d74930bcc2172b0eeba28f',NULL,NULL,NULL,NULL,'2026-02-28 10:08:22',NULL,'2026-02-28 10:08:22',NULL,NULL),(286,NULL,'52cf0dd38c45432cafc85606f1fb20d5',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:22',NULL,'2026-02-28 10:08:22',NULL,NULL),(287,NULL,'360a0a3f3fcd4651918e3c1638c873bd',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:22',NULL,'2026-02-28 10:08:22',NULL,NULL),(288,NULL,NULL,'8de322f2e2aa4e1f88e38b3f81fca9b6',NULL,NULL,NULL,NULL,'2026-02-28 10:08:23',NULL,'2026-02-28 10:08:23',NULL,NULL),(289,NULL,NULL,'02f675dc217e4e3989e1168cb8cec6c8',NULL,NULL,NULL,NULL,'2026-02-28 10:08:23',NULL,'2026-02-28 10:08:23',NULL,NULL),(290,NULL,'0f512043a867446bb9c478ca893d55f5',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:24',NULL,'2026-02-28 10:08:24',NULL,NULL),(291,NULL,'268874e35df24a29a20d289bc5535f7a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:25',NULL,'2026-02-28 10:08:25',NULL,NULL),(292,NULL,NULL,'31fae9a9ccee4fcd863f56e911479189',NULL,NULL,NULL,NULL,'2026-02-28 10:08:29',NULL,'2026-02-28 10:08:29',NULL,NULL),(293,NULL,NULL,'f2df6353e11b498eaf68d0eab7b7478b',NULL,NULL,NULL,NULL,'2026-02-28 10:08:29',NULL,'2026-02-28 10:08:29',NULL,NULL),(294,NULL,'787b18bf7c594fe6ad440a825f232e23',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:30',NULL,'2026-02-28 10:08:30',NULL,NULL),(295,NULL,NULL,'09273a42bfa545c6b417dbbbc2500571',NULL,NULL,NULL,NULL,'2026-02-28 10:08:30',NULL,'2026-02-28 10:08:30',NULL,NULL),(296,NULL,NULL,'85ceaf3707484ddfb64f69927eec3f49',NULL,NULL,NULL,NULL,'2026-02-28 10:08:30',NULL,'2026-02-28 10:08:30',NULL,NULL),(297,NULL,'27d2c0dbcb1140f4b07619143ca392cb',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:31',NULL,'2026-02-28 10:08:31',NULL,NULL),(298,NULL,'765f34d3921c4e67ba6653a545c5ddd2',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:32',NULL,'2026-02-28 10:08:32',NULL,NULL),(299,NULL,NULL,'eb52857f37ae4c42815767488316da21',NULL,NULL,NULL,NULL,'2026-02-28 10:08:33',NULL,'2026-02-28 10:08:33',NULL,NULL),(300,NULL,'9d6b720bb7334b139fc12e9faa051906',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:34',NULL,'2026-02-28 10:08:34',NULL,NULL),(301,NULL,'bfcca673d6bd4f218a5f3015d3eacc16',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:35',NULL,'2026-02-28 10:08:35',NULL,NULL),(302,NULL,NULL,'3d4207fa4433493fbf6c73f9575b22f1',NULL,NULL,NULL,NULL,'2026-02-28 10:08:36',NULL,'2026-02-28 10:08:36',NULL,NULL),(303,NULL,NULL,'39c7b7346ac04a70b755a11397e38fd7',NULL,NULL,NULL,NULL,'2026-02-28 10:08:36',NULL,'2026-02-28 10:08:36',NULL,NULL),(304,NULL,NULL,'380e85a2d2344b32bcce482cfaec339e',NULL,NULL,NULL,NULL,'2026-02-28 10:08:36',NULL,'2026-02-28 10:08:36',NULL,NULL),(305,NULL,'28ff5f537f414624b315bf4a4f55517c',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:38',NULL,'2026-02-28 10:08:38',NULL,NULL),(306,NULL,'d685507d83804a48a6f792dcb9d70734',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:39',NULL,'2026-02-28 10:08:39',NULL,NULL),(307,NULL,'f9b02420625b4056bb6a8d507fcf5552',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:42',NULL,'2026-02-28 10:08:42',NULL,NULL),(308,NULL,NULL,'9645d95f2a17473cbebb27c362ea3bb1',NULL,NULL,NULL,NULL,'2026-02-28 10:08:49',NULL,'2026-02-28 10:08:49',NULL,NULL),(309,NULL,'93e325024ecf4d98a4a96264045bdf15',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:49',NULL,'2026-02-28 10:08:49',NULL,NULL),(310,NULL,'52a549a087f244578582f51b01d85d51',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:51',NULL,'2026-02-28 10:08:51',NULL,NULL),(311,NULL,'f09ee2e7d133419ab7d01339303f8923',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:51',NULL,'2026-02-28 10:08:51',NULL,NULL),(312,NULL,NULL,'c5d5f7eda9d3439c874a80d5dc0ccfc2',NULL,NULL,NULL,NULL,'2026-02-28 10:08:53',NULL,'2026-02-28 10:08:53',NULL,NULL),(313,NULL,'80efd8db25434c8e8dd8ff3bc968269d',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:53',NULL,'2026-02-28 10:08:53',NULL,NULL),(314,NULL,'e19566bd8f1b4483b388d3323c1a91bc',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:54',NULL,'2026-02-28 10:08:54',NULL,NULL),(315,NULL,NULL,'5669d043e0964a888905e60476cfd6fb',NULL,NULL,NULL,NULL,'2026-02-28 10:08:55',NULL,'2026-02-28 10:08:55',NULL,NULL),(316,NULL,NULL,'89a5169dad244574bd6057dc59ec50a1',NULL,NULL,NULL,NULL,'2026-02-28 10:08:55',NULL,'2026-02-28 10:08:55',NULL,NULL),(317,NULL,NULL,'57f3364628094760a84f6fceabfacf2d',NULL,NULL,NULL,NULL,'2026-02-28 10:08:55',NULL,'2026-02-28 10:08:55',NULL,NULL),(318,NULL,'8783d30e00eb45a69a344eec6b6cadc5',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:08:59',NULL,'2026-02-28 10:08:59',NULL,NULL),(319,NULL,'06f01beca3da49b687c5cfd011e482c6',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:09:00',NULL,'2026-02-28 10:09:00',NULL,NULL),(320,NULL,NULL,'5db9d3a48c914c5ea9326b6a8c8c0f36',NULL,NULL,NULL,NULL,'2026-02-28 10:09:02',NULL,'2026-02-28 10:09:02',NULL,NULL),(321,NULL,'3b8b0d675b3747fd80cb2186e41d2ebf',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:09:04',NULL,'2026-02-28 10:09:04',NULL,NULL),(322,NULL,NULL,'f3bd83d29eac45b5b058febf62a07078',NULL,NULL,NULL,NULL,'2026-02-28 10:09:05',NULL,'2026-02-28 10:09:05',NULL,NULL),(323,NULL,'a953311287ca456aaabf0be1c03eb13d',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:09:06',NULL,'2026-02-28 10:09:06',NULL,NULL),(324,NULL,NULL,'7943dceaa0d74159b9a7df7e270dd938',NULL,NULL,NULL,NULL,'2026-02-28 10:09:08',NULL,'2026-02-28 10:09:08',NULL,NULL),(325,NULL,'258ae1c2bc964eb3a8ec22f402e5a15d',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:09:10',NULL,'2026-02-28 10:09:10',NULL,NULL),(326,NULL,NULL,'e0057a4e259c411cb046434149db54bb',NULL,NULL,NULL,NULL,'2026-02-28 10:09:15',NULL,'2026-02-28 10:09:15',NULL,NULL),(327,NULL,NULL,'8f75ca1d57e541db93cb3ebd972f9f9d',NULL,NULL,NULL,NULL,'2026-02-28 10:09:15',NULL,'2026-02-28 10:09:15',NULL,NULL),(328,NULL,'27b09604e3914dfdb0b1d716b77f0f9a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:09:16',NULL,'2026-02-28 10:09:16',NULL,NULL),(329,NULL,'ad75313c4c45408fb829ea5580d590d7',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:09:18',NULL,'2026-02-28 10:09:18',NULL,NULL),(330,NULL,NULL,'35aa1fe862a2437dbcc12fc7b0acbf91',NULL,NULL,NULL,NULL,'2026-02-28 10:09:18',NULL,'2026-02-28 10:09:18',NULL,NULL),(331,NULL,'30cb5e2d14fb4fb7a9d37cf231549329',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:09:19',NULL,'2026-02-28 10:09:19',NULL,NULL),(332,NULL,NULL,'8b5aab236aaa483f9a6637a457f28046',NULL,NULL,NULL,NULL,'2026-02-28 10:09:22',NULL,'2026-02-28 10:09:22',NULL,NULL),(333,NULL,NULL,'8ae0f888db9d416cb3c20ae5bb8af540',NULL,NULL,NULL,NULL,'2026-02-28 10:09:22',NULL,'2026-02-28 10:09:22',NULL,NULL),(334,NULL,'8844f78cbaa54c86955d955c0fe62ecf',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:09:24',NULL,'2026-02-28 10:09:24',NULL,NULL),(335,NULL,'8aa6336fef224438aa9e7de1b39b4ef0',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:09:25',NULL,'2026-02-28 10:09:25',NULL,NULL),(336,NULL,NULL,'b88e9552ce584b7892a828621678b21b',NULL,NULL,NULL,NULL,'2026-02-28 10:09:39',NULL,'2026-02-28 10:09:39',NULL,NULL),(337,NULL,'a71fb26e084e46d6b656e41936ac5794',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:09:40',NULL,'2026-02-28 10:09:40',NULL,NULL),(338,NULL,NULL,'2f1783cc6909456d9f299270ef92d65f',NULL,NULL,NULL,NULL,'2026-02-28 10:09:42',NULL,'2026-02-28 10:09:42',NULL,NULL),(339,NULL,'5e7d01bdecf84678b6cc162b55c7c9b1',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:09:44',NULL,'2026-02-28 10:09:44',NULL,NULL),(340,NULL,NULL,'231696aaecd544dcaa8a89972dc786e5',NULL,NULL,NULL,NULL,'2026-02-28 10:09:46',NULL,'2026-02-28 10:09:46',NULL,NULL),(341,NULL,'a008319fac8748e99e0edf90183729b0',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:09:47',NULL,'2026-02-28 10:09:47',NULL,NULL),(342,NULL,NULL,'9901f45eda7a4defb9b747797fc69be0',NULL,NULL,NULL,NULL,'2026-02-28 10:09:53',NULL,'2026-02-28 10:09:53',NULL,NULL),(343,NULL,NULL,'0f26a5c4734c42ef873081cbbf03f947',NULL,NULL,NULL,NULL,'2026-02-28 10:09:53',NULL,'2026-02-28 10:09:53',NULL,NULL),(344,NULL,NULL,'1341b7bab4cc4ddca989e12ab7770723',NULL,NULL,NULL,NULL,'2026-02-28 10:09:55',NULL,'2026-02-28 10:09:55',NULL,NULL),(345,NULL,'5d1af0e2b62848a080d21fbcbd59d88e',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:09:55',NULL,'2026-02-28 10:09:55',NULL,NULL),(346,NULL,'13c8391ebb8644dea661a093a38db268',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:09:56',NULL,'2026-02-28 10:09:56',NULL,NULL),(347,NULL,'33fce9f8e5ae41a0978c0956c1f9f971',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:09:56',NULL,'2026-02-28 10:09:56',NULL,NULL),(348,NULL,NULL,'c3d4711dab7a4ded9f1118b302305ad2',NULL,NULL,NULL,NULL,'2026-02-28 10:09:58',NULL,'2026-02-28 10:09:58',NULL,NULL),(349,NULL,'30df99731c0242ae8b46aaef781d186a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:10:00',NULL,'2026-02-28 10:10:00',NULL,NULL),(350,NULL,NULL,'d80c14bc415e49c3a9dc8ac6a6ebb568',NULL,NULL,NULL,NULL,'2026-02-28 10:10:07',NULL,'2026-02-28 10:10:07',NULL,NULL),(351,NULL,NULL,'b1530f76b32740c9b3fb7fb98060619d',NULL,NULL,NULL,NULL,'2026-02-28 10:10:07',NULL,'2026-02-28 10:10:07',NULL,NULL),(352,NULL,'06a73cd8e18b4d158cd54a207510ce94',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:10:08',NULL,'2026-02-28 10:10:08',NULL,NULL),(353,NULL,'e12d79e2bb734b15b50a6624f29c3c27',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:10:09',NULL,'2026-02-28 10:10:09',NULL,NULL),(354,NULL,NULL,'7b7f4fcc1d0d41f59aed36b3de16f8e2',NULL,NULL,NULL,NULL,'2026-02-28 10:10:16',NULL,'2026-02-28 10:10:16',NULL,NULL),(355,NULL,'6a54f983c0fa466f9e11947f104ed5ca',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:10:19',NULL,'2026-02-28 10:10:19',NULL,NULL),(356,NULL,NULL,'a1e776fd8a67477fad8bbe7d95b7d595',NULL,NULL,NULL,NULL,'2026-02-28 10:10:24',NULL,'2026-02-28 10:10:24',NULL,NULL),(357,NULL,NULL,'16be7f16c5cd48e9bcb676f677028b89',NULL,NULL,NULL,NULL,'2026-02-28 10:10:25',NULL,'2026-02-28 10:10:25',NULL,NULL),(358,NULL,NULL,'43ded412415a423bb4eb7acd682d70b6',NULL,NULL,NULL,NULL,'2026-02-28 10:10:25',NULL,'2026-02-28 10:10:25',NULL,NULL),(359,NULL,'119f76d35d964d099df62a72f6295530',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:10:26',NULL,'2026-02-28 10:10:26',NULL,NULL),(360,NULL,'f9195aa3f67e485ea9f6d0ca2f67209d',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:10:27',NULL,'2026-02-28 10:10:27',NULL,NULL),(361,NULL,'94a556c7dfdc4575a97d7596e30fb97d',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:10:28',NULL,'2026-02-28 10:10:28',NULL,NULL),(362,NULL,NULL,'929f77fe9b7345fea9a6837d1424a22d',NULL,NULL,NULL,NULL,'2026-02-28 10:10:30',NULL,'2026-02-28 10:10:30',NULL,NULL),(363,NULL,NULL,'a73c734f7c64473bbb1461338b8bc953',NULL,NULL,NULL,NULL,'2026-02-28 10:10:31',NULL,'2026-02-28 10:10:31',NULL,NULL),(364,NULL,'6cbe3849938c4996b63df82d5d30d4bd',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:10:33',NULL,'2026-02-28 10:10:33',NULL,NULL),(365,NULL,'d50d18abe97b46cfa86cb28e14ab5102',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:10:33',NULL,'2026-02-28 10:10:33',NULL,NULL),(366,NULL,NULL,'631b3e4b42d14f5cb6d48ace75c8910d',NULL,NULL,NULL,NULL,'2026-02-28 10:10:50',NULL,'2026-02-28 10:10:50',NULL,NULL),(367,NULL,'edb1f21bd10c4ff6a95b61a31f30c9f7',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:10:51',NULL,'2026-02-28 10:10:51',NULL,NULL),(368,NULL,NULL,'7bba8e26db2f4200960779ee5c28beab',NULL,NULL,NULL,NULL,'2026-02-28 10:10:59',NULL,'2026-02-28 10:10:59',NULL,NULL),(369,NULL,'277d545016024b3790e04cf192b53384',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:11:00',NULL,'2026-02-28 10:11:00',NULL,NULL),(370,NULL,NULL,'5be1cfae40a8471aad09034355135e7b',NULL,NULL,NULL,NULL,'2026-02-28 10:11:03',NULL,'2026-02-28 10:11:03',NULL,NULL),(371,NULL,'c18692f0d57143fbbcdfef89f8912a83',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:11:04',NULL,'2026-02-28 10:11:04',NULL,NULL),(372,NULL,NULL,'e117c5b6ba924a268ef38850f1470c35',NULL,NULL,NULL,NULL,'2026-02-28 10:11:13',NULL,'2026-02-28 10:11:13',NULL,NULL),(373,NULL,'0a2caf358b4642809971976655ef5491',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:11:14',NULL,'2026-02-28 10:11:14',NULL,NULL),(374,NULL,NULL,'33855957e5e3480b850c2ddef62a5f89',NULL,NULL,NULL,NULL,'2026-02-28 10:11:27',NULL,'2026-02-28 10:11:27',NULL,NULL),(375,NULL,'a5095f810f0d431788237ae1da262bf6',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:11:28',NULL,'2026-02-28 10:11:28',NULL,NULL),(376,NULL,NULL,'71332cf873754b789eb47eee6804bd4f',NULL,NULL,NULL,NULL,'2026-02-28 10:11:32',NULL,'2026-02-28 10:11:32',NULL,NULL),(377,NULL,'6f08c8eb73d84666baef72187e7fb727',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:11:33',NULL,'2026-02-28 10:11:33',NULL,NULL),(378,NULL,NULL,'5602939de3af45cabb2ca0c6d79a61f2',NULL,NULL,NULL,NULL,'2026-02-28 10:11:47',NULL,'2026-02-28 10:11:47',NULL,NULL),(379,NULL,'d6270bcaad4d4048b439814440d1db6f',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:11:50',NULL,'2026-02-28 10:11:50',NULL,NULL),(380,NULL,NULL,'819cb122df6e4f4ebcada5817f7d142c',NULL,NULL,NULL,NULL,'2026-02-28 10:11:52',NULL,'2026-02-28 10:11:52',NULL,NULL),(381,NULL,'1c0c158efb2a4e8db50e75402b3d0f2a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:11:53',NULL,'2026-02-28 10:11:53',NULL,NULL),(382,NULL,NULL,'05f7daf505a349dcb8574e9ef6f061fb',NULL,NULL,NULL,NULL,'2026-02-28 10:12:06',NULL,'2026-02-28 10:12:06',NULL,NULL),(383,NULL,'af2c91609b444c458a32203261ac88d3',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:12:08',NULL,'2026-02-28 10:12:08',NULL,NULL),(384,NULL,NULL,'4d03368d5ddc403db8a8315dabe88681',NULL,NULL,NULL,NULL,'2026-02-28 10:12:11',NULL,'2026-02-28 10:12:11',NULL,NULL),(385,NULL,'676657ed4ac447c580a9480d26bd7f87',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:12:12',NULL,'2026-02-28 10:12:12',NULL,NULL),(386,NULL,NULL,'d288373f5e1c43e49d1929dde479d077',NULL,NULL,NULL,NULL,'2026-02-28 10:12:19',NULL,'2026-02-28 10:12:19',NULL,NULL),(387,NULL,'eee2150aa89a47edb94777bda48e4515',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:12:22',NULL,'2026-02-28 10:12:22',NULL,NULL),(388,NULL,NULL,'4285303dac0b4ee497a908cdca0aecf4',NULL,NULL,NULL,NULL,'2026-02-28 10:12:53',NULL,'2026-02-28 10:12:53',NULL,NULL),(389,NULL,'8174cdce90534957854824466483d42b',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:12:54',NULL,'2026-02-28 10:12:54',NULL,NULL),(390,NULL,NULL,'eb9112c47be049458954cae3854ff11e',NULL,NULL,NULL,NULL,'2026-02-28 10:12:59',NULL,'2026-02-28 10:12:59',NULL,NULL),(391,NULL,NULL,'ad2f338892e84dd18f856a9959864b12',NULL,NULL,NULL,NULL,'2026-02-28 10:12:59',NULL,'2026-02-28 10:12:59',NULL,NULL),(392,NULL,'3c6b811ba2e041689239c0575ebbc079',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:13:00',NULL,'2026-02-28 10:13:00',NULL,NULL),(393,NULL,'671fc17db1f0471a9e576497a9756619',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:13:01',NULL,'2026-02-28 10:13:01',NULL,NULL),(394,NULL,NULL,'48e14a77ec8842f98a0d2efc6d5e167f',NULL,NULL,NULL,NULL,'2026-02-28 10:13:11',NULL,'2026-02-28 10:13:11',NULL,NULL),(395,NULL,'cffbbb9857954b188c363e9565817bf2',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:13:12',NULL,'2026-02-28 10:13:12',NULL,NULL),(396,NULL,NULL,'c2465d2d41534ef098e24bdd413eefab',NULL,NULL,NULL,NULL,'2026-02-28 10:13:19',NULL,'2026-02-28 10:13:19',NULL,NULL),(397,NULL,'b83705c4693849a58c70b1271f24f320',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:13:20',NULL,'2026-02-28 10:13:20',NULL,NULL),(398,NULL,NULL,'a11a56ff5fb844d1b03a25da76136c9d',NULL,NULL,NULL,NULL,'2026-02-28 10:13:26',NULL,'2026-02-28 10:13:26',NULL,NULL),(399,NULL,'efd550ad4a4044b5b976691be30a846c',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:13:27',NULL,'2026-02-28 10:13:27',NULL,NULL),(400,NULL,NULL,'c60ae50e478245b49930e1e71ea14df4',NULL,NULL,NULL,NULL,'2026-02-28 10:13:57',NULL,'2026-02-28 10:13:57',NULL,NULL),(401,NULL,'f398725990434948ba6927f1c1477015',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:13:58',NULL,'2026-02-28 10:13:58',NULL,NULL),(402,NULL,NULL,'1312bfae02d0476797aeb530c17effb9',NULL,NULL,NULL,NULL,'2026-02-28 10:14:02',NULL,'2026-02-28 10:14:02',NULL,NULL),(403,NULL,'a0d8ed768e104efaa3c56509e8ac7a20',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:14:03',NULL,'2026-02-28 10:14:03',NULL,NULL),(404,NULL,NULL,'ec5caafc16ec43a493f7d553353a27c3',NULL,NULL,NULL,NULL,'2026-02-28 10:14:51',NULL,'2026-02-28 10:14:51',NULL,NULL),(405,NULL,'809bf856030f4316b385ba1c02291ca7',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:14:52',NULL,'2026-02-28 10:14:52',NULL,NULL),(406,NULL,NULL,'bde6aa41e97042259d2b158328b8a7aa',NULL,NULL,NULL,NULL,'2026-02-28 10:14:55',NULL,'2026-02-28 10:14:55',NULL,NULL),(407,NULL,NULL,'bdf11e9e10084a9996c39bd33825a5bf',NULL,NULL,NULL,NULL,'2026-02-28 10:14:55',NULL,'2026-02-28 10:14:55',NULL,NULL),(408,NULL,'fc53b82ced3f4ace96ed5ed48ae01670',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:14:56',NULL,'2026-02-28 10:14:56',NULL,NULL),(409,NULL,NULL,'c6b5724da2e648fd85fd8cb293525967',NULL,NULL,NULL,NULL,'2026-02-28 10:15:31',NULL,'2026-02-28 10:15:31',NULL,NULL),(410,NULL,'92b324a375ad4f198dc44d31a0e0a6eb',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:15:32',NULL,'2026-02-28 10:15:32',NULL,NULL),(411,NULL,NULL,'14b2d28379164786ad68563acb83a50a',NULL,NULL,NULL,NULL,'2026-02-28 10:16:21',NULL,'2026-02-28 10:16:21',NULL,NULL),(412,NULL,'fd70835696bf4e12a062516e9de5527d',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:16:26',NULL,'2026-02-28 10:16:26',NULL,NULL),(413,NULL,NULL,'cc52c9235e704591a857b1b746c257ea',NULL,NULL,NULL,NULL,'2026-02-28 10:16:46',NULL,'2026-02-28 10:16:46',NULL,NULL),(414,NULL,'692561f0659d4af58ab14beffb24eb70',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:16:48',NULL,'2026-02-28 10:16:48',NULL,NULL),(415,NULL,NULL,'1cb883c7e1bc470eb00cb23a94d0ddb0',NULL,NULL,NULL,NULL,'2026-02-28 10:17:07',NULL,'2026-02-28 10:17:07',NULL,NULL),(416,NULL,'5d42755d9af04d5ba2e00e083f33ca82',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:17:07',NULL,'2026-02-28 10:17:07',NULL,NULL),(417,NULL,NULL,'3ae46addcec3432c94c933fdd18dfa9c',NULL,NULL,NULL,NULL,'2026-02-28 10:17:43',NULL,'2026-02-28 10:17:43',NULL,NULL),(418,NULL,'9a2bd9695a47497e8f68da82a992d545',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:17:43',NULL,'2026-02-28 10:17:43',NULL,NULL),(419,NULL,NULL,'7ef51521ffc947cbbce8323ec2b71753',NULL,NULL,NULL,NULL,'2026-02-28 10:17:57',NULL,'2026-02-28 10:17:57',NULL,NULL),(420,NULL,'c0c4bc44c37f4a4f83c83b6105be3190',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:17:58',NULL,'2026-02-28 10:17:58',NULL,NULL),(421,NULL,NULL,'6148f57430024c88b784fbb0c71913ec',NULL,NULL,NULL,NULL,'2026-02-28 10:18:01',NULL,'2026-02-28 10:18:01',NULL,NULL),(422,NULL,'bffaa3cca8724d0bbe7eb7950a31ea79',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:03',NULL,'2026-02-28 10:18:03',NULL,NULL),(423,NULL,'ecc6f9ad8598445589b9efcb083c4198',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:08',NULL,'2026-02-28 10:18:08',NULL,NULL),(424,NULL,'db3e0b0b8088436dbcdbf84a373030d8',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:09',NULL,'2026-02-28 10:18:09',NULL,NULL),(425,NULL,NULL,'62c7433245d949b6bbe82ab2ae7a11d5',NULL,NULL,NULL,NULL,'2026-02-28 10:18:09',NULL,'2026-02-28 10:18:09',NULL,NULL),(426,NULL,NULL,'eb5b757dd8f648089a4d6861df01ebbd',NULL,NULL,NULL,NULL,'2026-02-28 10:18:09',NULL,'2026-02-28 10:18:09',NULL,NULL),(427,NULL,'6aee7220cdbc42d7885b20d2f4e1f68a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:11',NULL,'2026-02-28 10:18:11',NULL,NULL),(428,NULL,'f04505cb8aa540f59f92ac0792c35950',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:13',NULL,'2026-02-28 10:18:13',NULL,NULL),(429,NULL,NULL,'0427dc6c83144f41bdf38ba9df97ed3c',NULL,NULL,NULL,NULL,'2026-02-28 10:18:18',NULL,'2026-02-28 10:18:18',NULL,NULL),(430,NULL,NULL,'54b54aa9fcbc4363b43977e77b8c1257',NULL,NULL,NULL,NULL,'2026-02-28 10:18:19',NULL,'2026-02-28 10:18:19',NULL,NULL),(431,NULL,'b1ce0045803244baac253e7c4a34b421',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:20',NULL,'2026-02-28 10:18:20',NULL,NULL),(432,NULL,'ba8f473405254da3b555305e8ff5b4a1',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:21',NULL,'2026-02-28 10:18:21',NULL,NULL),(433,NULL,NULL,'39a5a5ba4d2d4c23a0ce8f1bd89eca09',NULL,NULL,NULL,NULL,'2026-02-28 10:18:23',NULL,'2026-02-28 10:18:23',NULL,NULL),(434,NULL,'e8f77fb8fb324fd68b3aa3716dff1c40',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:24',NULL,'2026-02-28 10:18:24',NULL,NULL),(435,NULL,'a2f0a2e25bd94a17945541e0aa00542e',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:26',NULL,'2026-02-28 10:18:26',NULL,NULL),(436,NULL,'9ecbbce8850f403fad40ef8bd6d6224f',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:26',NULL,'2026-02-28 10:18:26',NULL,NULL),(437,NULL,'d4d4a38fe853479db2e20052b4e35b3c',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:26',NULL,'2026-02-28 10:18:26',NULL,NULL),(438,NULL,NULL,'c201f9130ad646ce905b77a11063fa4c',NULL,NULL,NULL,NULL,'2026-02-28 10:18:26',NULL,'2026-02-28 10:18:26',NULL,NULL),(439,NULL,NULL,'0f967b531a9f436daf4e2cb1c924d5e0',NULL,NULL,NULL,NULL,'2026-02-28 10:18:27',NULL,'2026-02-28 10:18:27',NULL,NULL),(440,NULL,'5810301d189d42deb039117a08eb0631',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:28',NULL,'2026-02-28 10:18:28',NULL,NULL),(441,NULL,'2e811d310b4645d59a0003a0cddc4380',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:29',NULL,'2026-02-28 10:18:29',NULL,NULL),(442,NULL,NULL,'43035d65ad034408bddb0ce499205de0',NULL,NULL,NULL,NULL,'2026-02-28 10:18:33',NULL,'2026-02-28 10:18:33',NULL,NULL),(443,NULL,'3046dd6bf91c4a16999ecd7e2807f339',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:33',NULL,'2026-02-28 10:18:33',NULL,NULL),(444,NULL,'3ac597e9f8aa4bb384f530452810f64a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:34',NULL,'2026-02-28 10:18:34',NULL,NULL),(445,NULL,'aa5067c1d6514f95b374563e52326ef7',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:34',NULL,'2026-02-28 10:18:34',NULL,NULL),(446,NULL,'0155eb4a99904c4fbad8f24c78843595',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:34',NULL,'2026-02-28 10:18:34',NULL,NULL),(447,NULL,'cc139aceeb8d4cf7b63ea13775351b88',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:35',NULL,'2026-02-28 10:18:35',NULL,NULL),(448,NULL,'ff5e6a10c44643fdb0bb97df13c3662a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:35',NULL,'2026-02-28 10:18:35',NULL,NULL),(449,NULL,'afb9cf723f8048f8bb3c739a919f3bb3',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:35',NULL,'2026-02-28 10:18:35',NULL,NULL),(450,NULL,'5f569035e89a4a93b811856353d023a3',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:36',NULL,'2026-02-28 10:18:36',NULL,NULL),(451,NULL,'d643904f04a8487499d0aa0a70602566',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:36',NULL,'2026-02-28 10:18:36',NULL,NULL),(452,NULL,'8c8d0f72de1542c7aa323bc43c89df42',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:36',NULL,'2026-02-28 10:18:36',NULL,NULL),(453,NULL,'4deb7c3e6fe14fc18e784a1c1fd95013',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:37',NULL,'2026-02-28 10:18:37',NULL,NULL),(454,NULL,'da9f8c0714534c3dbfaab4a09043a48f',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:37',NULL,'2026-02-28 10:18:37',NULL,NULL),(455,NULL,'f7820d46bca441cbad611e42790e84fe',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:38',NULL,'2026-02-28 10:18:38',NULL,NULL),(456,NULL,'c2380cf8960244f5919e13e31c524382',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:38',NULL,'2026-02-28 10:18:38',NULL,NULL),(457,NULL,NULL,'66c4e3e544744df685e7398980683dc7',NULL,NULL,NULL,NULL,'2026-02-28 10:18:38',NULL,'2026-02-28 10:18:38',NULL,NULL),(458,NULL,NULL,'b423488810df4c9ab5077faf84af5c11',NULL,NULL,NULL,NULL,'2026-02-28 10:18:39',NULL,'2026-02-28 10:18:39',NULL,NULL),(459,NULL,'24fe6e6f4e6e48c8a27daa77fb26a098',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:40',NULL,'2026-02-28 10:18:40',NULL,NULL),(460,NULL,'9f2c40d04d4d40858a546b9ea50dd263',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:41',NULL,'2026-02-28 10:18:41',NULL,NULL),(461,NULL,'de283f5d80144cb5a1547f369f78e8cd',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:45',NULL,'2026-02-28 10:18:45',NULL,NULL),(462,NULL,NULL,'33a3a15aec6c4f4295d65b559aed4bb5',NULL,NULL,NULL,NULL,'2026-02-28 10:18:45',NULL,'2026-02-28 10:18:45',NULL,NULL),(463,NULL,NULL,'d0500f02235f49938714a33205286cd3',NULL,NULL,NULL,NULL,'2026-02-28 10:18:45',NULL,'2026-02-28 10:18:45',NULL,NULL),(464,NULL,'69e26b8352d84208a906fd42635855f6',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:48',NULL,'2026-02-28 10:18:48',NULL,NULL),(465,NULL,'d1397e2cd50f4a07a9586185db025d11',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:48',NULL,'2026-02-28 10:18:48',NULL,NULL),(466,NULL,NULL,'c7fd6c72acef4301b3b99697a8f4a8c9',NULL,NULL,NULL,NULL,'2026-02-28 10:18:54',NULL,'2026-02-28 10:18:54',NULL,NULL),(467,NULL,'3855bc04cdba494cb6f9e97c2bc068aa',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:56',NULL,'2026-02-28 10:18:56',NULL,NULL),(468,NULL,NULL,'c7fd6c72acef4301b3b99697a8f4a8c9',NULL,NULL,NULL,NULL,'2026-02-28 10:18:58',NULL,'2026-02-28 10:18:58',NULL,NULL),(469,NULL,'dda9d345524a4202b5ee926d58c6ab6b',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:59',NULL,'2026-02-28 10:18:59',NULL,NULL),(470,NULL,'9837828234d84324a0f434c20e5cdda0',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:18:59',NULL,'2026-02-28 10:18:59',NULL,NULL),(471,NULL,NULL,'c1872916b7164f449060c56a4c754ae9',NULL,NULL,NULL,NULL,'2026-02-28 10:19:00',NULL,'2026-02-28 10:19:00',NULL,NULL),(472,NULL,NULL,'b619a4e9cfd64115a704c5bd71ea3665',NULL,NULL,NULL,NULL,'2026-02-28 10:19:00',NULL,'2026-02-28 10:19:00',NULL,NULL),(473,NULL,'67d8586f35dc436ea27e22b68b3821ba',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:19:03',NULL,'2026-02-28 10:19:03',NULL,NULL),(474,NULL,NULL,'699bde3f63e74d6398856d2096d2cba8',NULL,NULL,NULL,NULL,'2026-02-28 10:19:03',NULL,'2026-02-28 10:19:03',NULL,NULL),(475,NULL,'365a17a7555f4d9ebd6f15b530614181',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:19:04',NULL,'2026-02-28 10:19:04',NULL,NULL),(476,NULL,'e987a1d2da224f548b18032faa94aa1a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:19:04',NULL,'2026-02-28 10:19:04',NULL,NULL),(477,NULL,NULL,'063ef7a56f22437792ca7c6f7c875793',NULL,NULL,NULL,NULL,'2026-02-28 10:19:11',NULL,'2026-02-28 10:19:11',NULL,NULL),(478,NULL,NULL,'e79fe47c4e0642ecbc7065f929694faf',NULL,NULL,NULL,NULL,'2026-02-28 10:19:11',NULL,'2026-02-28 10:19:11',NULL,NULL),(479,NULL,'1e43f77f790744848a97515115489d9e',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:19:14',NULL,'2026-02-28 10:19:14',NULL,NULL),(480,NULL,'e17947e0c3b24df69a08fc5e41aabe35',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:19:16',NULL,'2026-02-28 10:19:16',NULL,NULL),(481,NULL,NULL,'782ea2b916c8416582b1094c0faeb439',NULL,NULL,NULL,NULL,'2026-02-28 10:19:22',NULL,'2026-02-28 10:19:22',NULL,NULL),(482,NULL,NULL,'99530c323188499c8d0e75b8edf1f77b',NULL,NULL,NULL,NULL,'2026-02-28 10:19:23',NULL,'2026-02-28 10:19:23',NULL,NULL),(483,NULL,NULL,'4ac8388c720948439b83ba484ace7432',NULL,NULL,NULL,NULL,'2026-02-28 10:19:23',NULL,'2026-02-28 10:19:23',NULL,NULL),(484,NULL,'78093201ffbd416ba6a78d27f12a4d58',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:19:23',NULL,'2026-02-28 10:19:23',NULL,NULL),(485,NULL,'a06976428c3d4f649a1b4d894fc6fb2e',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:19:24',NULL,'2026-02-28 10:19:24',NULL,NULL),(486,NULL,NULL,'782ea2b916c8416582b1094c0faeb439',NULL,NULL,NULL,NULL,'2026-02-28 10:19:24',NULL,'2026-02-28 10:19:24',NULL,NULL),(487,NULL,'a65859598d644c7ea11971ae548871b6',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:19:24',NULL,'2026-02-28 10:19:24',NULL,NULL),(488,NULL,'d636d27e87b8467096251f0d63d312ff',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:19:25',NULL,'2026-02-28 10:19:25',NULL,NULL),(489,NULL,'4c568ca6a09a48c1a1197267be4d4583',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:19:25',NULL,'2026-02-28 10:19:25',NULL,NULL),(490,NULL,'a9190dcb14324847a3b0cf7fb5f7112d',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:19:25',NULL,'2026-02-28 10:19:25',NULL,NULL),(491,NULL,NULL,'29a988334e384b92938cecdb524e41ab',NULL,NULL,NULL,NULL,'2026-02-28 10:19:26',NULL,'2026-02-28 10:19:26',NULL,NULL),(492,NULL,NULL,'0980181bef864b3dbcc614b0f32f26fd',NULL,NULL,NULL,NULL,'2026-02-28 10:19:27',NULL,'2026-02-28 10:19:27',NULL,NULL),(493,NULL,NULL,'782ea2b916c8416582b1094c0faeb439',NULL,NULL,NULL,NULL,'2026-02-28 10:19:27',NULL,'2026-02-28 10:19:27',NULL,NULL),(494,NULL,'98447fa1ab7b4f3bb06af3ed10ca563d',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:19:28',NULL,'2026-02-28 10:19:28',NULL,NULL),(495,NULL,'87e7f7e4855e4f72a4be4d096e92305e',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:19:29',NULL,'2026-02-28 10:19:29',NULL,NULL),(496,NULL,'c8f2da6e56844fc4a2a4968f9deb40b8',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:19:31',NULL,'2026-02-28 10:19:31',NULL,NULL),(497,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:19:33',NULL,'2026-02-28 10:19:33','-G24xi6-QB6z9f5yu1Lr8w',NULL),(498,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:19:34',NULL,'2026-02-28 10:19:34','Ix3aZKDoSsKX2VlceTH9kQ',NULL),(499,NULL,NULL,'5d487afe7b3e42c3bdb28a767b4221d6',NULL,NULL,NULL,NULL,'2026-02-28 10:19:34',NULL,'2026-02-28 10:19:34',NULL,NULL),(500,NULL,'15362517ace04c0e873080f64d528713',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:19:36',NULL,'2026-02-28 10:19:36',NULL,NULL),(501,NULL,NULL,'8005b71ad6364d20bc9232d6a31b6d7d',NULL,NULL,NULL,NULL,'2026-02-28 10:19:40',NULL,'2026-02-28 10:19:40',NULL,NULL),(502,NULL,NULL,'989bc5cea050476390e2963ee9bd365e',NULL,NULL,NULL,NULL,'2026-02-28 10:19:40',NULL,'2026-02-28 10:19:40',NULL,NULL),(503,NULL,'ad2f506115af4d66af9262b9b92f3bf2',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:19:42',NULL,'2026-02-28 10:19:42',NULL,NULL),(504,NULL,'8cd4d99b13454f22b4a0367002117026',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:19:43',NULL,'2026-02-28 10:19:43',NULL,NULL),(505,NULL,NULL,'876d0345d3d34cd0b341f2bf4f16293c',NULL,NULL,NULL,NULL,'2026-02-28 10:19:48',NULL,'2026-02-28 10:19:48',NULL,NULL),(506,NULL,NULL,'36765f72257f4c6d9cc59fee7423eaf4',NULL,NULL,NULL,NULL,'2026-02-28 10:19:48',NULL,'2026-02-28 10:19:48',NULL,NULL),(507,NULL,'787ff913c2bd4a32af011586890a72ea',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:19:49',NULL,'2026-02-28 10:19:49',NULL,NULL),(508,NULL,'6d8beb29b3494285af930150d93b6b9a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:19:50',NULL,'2026-02-28 10:19:50',NULL,NULL),(509,NULL,NULL,'05780ead76294473ae8c8fc112f7610d',NULL,NULL,NULL,NULL,'2026-02-28 10:20:17',NULL,'2026-02-28 10:20:17',NULL,NULL),(510,NULL,'f743c06bc2ae45fda68427b8418baef8',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:20:19',NULL,'2026-02-28 10:20:19',NULL,NULL),(511,NULL,NULL,'e046cfa11b3745c79d4d00db57512b0f',NULL,NULL,NULL,NULL,'2026-02-28 10:20:23',NULL,'2026-02-28 10:20:23',NULL,NULL),(512,NULL,NULL,'3b243f61f2844cd6a47fbbb0d71c2597',NULL,NULL,NULL,NULL,'2026-02-28 10:20:23',NULL,'2026-02-28 10:20:23',NULL,NULL),(513,NULL,'11d32c584dcf4b5aa2f8b68c016b96f8',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:20:25',NULL,'2026-02-28 10:20:25',NULL,NULL),(514,NULL,'647c88c7fec948008ce5cd152f2633c2',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:20:27',NULL,'2026-02-28 10:20:27',NULL,NULL),(515,NULL,NULL,'12f3a8b77ead4d4a94f1839409d259cf',NULL,NULL,NULL,NULL,'2026-02-28 10:20:31',NULL,'2026-02-28 10:20:31',NULL,NULL),(516,NULL,'bd35cb64e7b6408ca1905d0603b81114',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:20:32',NULL,'2026-02-28 10:20:32',NULL,NULL),(517,NULL,NULL,'b9006c7543a244aa948b78020335223a',NULL,NULL,NULL,NULL,'2026-02-28 10:20:34',NULL,'2026-02-28 10:20:34',NULL,NULL),(518,NULL,'6952e00efd364e1491714983e2425e93',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:20:35',NULL,'2026-02-28 10:20:35',NULL,NULL),(519,NULL,NULL,'8d03850a765742908401b28b9f983e96',NULL,NULL,NULL,NULL,'2026-02-28 10:20:50',NULL,'2026-02-28 10:20:50',NULL,NULL),(520,NULL,'3882eded03594958a2e5d10832a6c3a9',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:20:51',NULL,'2026-02-28 10:20:51',NULL,NULL),(521,NULL,NULL,'864dceeabfd944c59e866f2f2786a0c9',NULL,NULL,NULL,NULL,'2026-02-28 10:20:52',NULL,'2026-02-28 10:20:52',NULL,NULL),(522,NULL,NULL,'34a1208cf8fa40e19709dd9b49776222',NULL,NULL,NULL,NULL,'2026-02-28 10:20:52',NULL,'2026-02-28 10:20:52',NULL,NULL),(523,NULL,'bd7baa7cd8a74f5c8a900c914c9a75bb',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:20:53',NULL,'2026-02-28 10:20:53',NULL,NULL),(524,NULL,'88fe469898364e908fcf28f3f58dea6e',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:20:54',NULL,'2026-02-28 10:20:54',NULL,NULL),(525,NULL,NULL,'5008d9de46ac40a181c69f621cb48998',NULL,NULL,NULL,NULL,'2026-02-28 10:21:05',NULL,'2026-02-28 10:21:05',NULL,NULL),(526,NULL,NULL,'81560cf2b1ee4196ad6d57127f04daaa',NULL,NULL,NULL,NULL,'2026-02-28 10:21:05',NULL,'2026-02-28 10:21:05',NULL,NULL),(527,NULL,'95f465ab5b2b41a693896d4c722cd15a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:21:06',NULL,'2026-02-28 10:21:06',NULL,NULL),(528,NULL,'5db65ff23bde4fb086287053f93b25bd',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:21:07',NULL,'2026-02-28 10:21:07',NULL,NULL),(529,NULL,NULL,'17ee551657ed4a4c8a2f040ff863ad9a',NULL,NULL,NULL,NULL,'2026-02-28 10:21:09',NULL,'2026-02-28 10:21:09',NULL,NULL),(530,NULL,'124d8457f7e342f1ab81af27d8c3ba3a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:21:11',NULL,'2026-02-28 10:21:11',NULL,NULL),(531,NULL,'a6f54b6b87554c1fac78c922c21830fc',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:21:19',NULL,'2026-02-28 10:21:19',NULL,NULL),(532,NULL,NULL,'f55a355fdace4a7e8e20823c3a213c7d',NULL,NULL,NULL,NULL,'2026-02-28 10:22:02',NULL,'2026-02-28 10:22:02',NULL,NULL),(533,NULL,NULL,'af89723da59045f2a4ceceff189ff1f8',NULL,NULL,NULL,NULL,'2026-02-28 10:22:02',NULL,'2026-02-28 10:22:02',NULL,NULL),(534,NULL,'418472ba4cba4c39b50f5ac719a50578',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:22:03',NULL,'2026-02-28 10:22:03',NULL,NULL),(535,NULL,'4deec945c3d341748afc6642d1d3f426',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:22:04',NULL,'2026-02-28 10:22:04',NULL,NULL),(536,NULL,NULL,'f18b63d43ee24e59bdff962c9a727213',NULL,NULL,NULL,NULL,'2026-02-28 10:22:05',NULL,'2026-02-28 10:22:05',NULL,NULL),(537,NULL,'14500a4ea1d94c0e9c58b076f5c918b5',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:22:06',NULL,'2026-02-28 10:22:06',NULL,NULL),(538,NULL,NULL,'70e8f691ae0f4768bb68cd8d497033e8',NULL,NULL,NULL,NULL,'2026-02-28 10:22:07',NULL,'2026-02-28 10:22:07',NULL,NULL),(539,NULL,NULL,'66be341bd19b48449a9bded547c8e0bd',NULL,NULL,NULL,NULL,'2026-02-28 10:22:07',NULL,'2026-02-28 10:22:07',NULL,NULL),(540,NULL,'ef79acdc729a4b62963ca360baeb426f',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:22:08',NULL,'2026-02-28 10:22:08',NULL,NULL),(541,NULL,'335faa1173e64cf8a7b107ae6238353d',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:22:09',NULL,'2026-02-28 10:22:09',NULL,NULL),(542,NULL,NULL,'2e653197144c44e6a50d57d554238bbf',NULL,NULL,NULL,NULL,'2026-02-28 10:22:09',NULL,'2026-02-28 10:22:09',NULL,NULL),(543,NULL,NULL,'f1f3064d90a447398bcbefca5c312249',NULL,NULL,NULL,NULL,'2026-02-28 10:22:10',NULL,'2026-02-28 10:22:10',NULL,NULL),(544,NULL,'6aa6503c04bf4065b9b93ee7e258c865',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:22:11',NULL,'2026-02-28 10:22:11',NULL,NULL),(545,NULL,'dd6ceda2826a41689f356ac633950745',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:22:12',NULL,'2026-02-28 10:22:12',NULL,NULL),(546,NULL,NULL,'48a1070d6e564889bc73e96630717e6b',NULL,NULL,NULL,NULL,'2026-02-28 10:22:14',NULL,'2026-02-28 10:22:14',NULL,NULL),(547,NULL,NULL,'6e8473a7c2014ffd9ee8e5ff6a846ea1',NULL,NULL,NULL,NULL,'2026-02-28 10:22:14',NULL,'2026-02-28 10:22:14',NULL,NULL),(548,NULL,'bc71bfdd83e644cd9d1bc0ccd91d1a2b',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:22:15',NULL,'2026-02-28 10:22:15',NULL,NULL),(549,NULL,'e2b8b7b5b1b04fa88acc1a59a1b5d8b1',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:22:16',NULL,'2026-02-28 10:22:16',NULL,NULL),(550,NULL,NULL,'858e250aeee54bf0b0bac6c4b895cd3d',NULL,NULL,NULL,NULL,'2026-02-28 10:22:21',NULL,'2026-02-28 10:22:21',NULL,NULL),(551,NULL,'6b71b35f387e480fb3e686d4a11bf39f',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:22:22',NULL,'2026-02-28 10:22:22',NULL,NULL),(552,NULL,NULL,'c97da499c9534966b26a6220ab1ae062',NULL,NULL,NULL,NULL,'2026-02-28 10:22:22',NULL,'2026-02-28 10:22:22',NULL,NULL),(553,NULL,NULL,'429279ef9024455489c01e35ae8d0c15',NULL,NULL,NULL,NULL,'2026-02-28 10:22:22',NULL,'2026-02-28 10:22:22',NULL,NULL),(554,NULL,NULL,'f85e979e59b144ed916617003bab357c',NULL,NULL,NULL,NULL,'2026-02-28 10:22:22',NULL,'2026-02-28 10:22:22',NULL,NULL),(555,NULL,NULL,'f85e979e59b144ed916617003bab357c',NULL,NULL,NULL,NULL,'2026-02-28 10:22:23',NULL,'2026-02-28 10:22:23',NULL,NULL),(556,NULL,NULL,'429279ef9024455489c01e35ae8d0c15',NULL,NULL,NULL,NULL,'2026-02-28 10:22:23',NULL,'2026-02-28 10:22:23',NULL,NULL),(557,NULL,NULL,'c97da499c9534966b26a6220ab1ae062',NULL,NULL,NULL,NULL,'2026-02-28 10:22:23',NULL,'2026-02-28 10:22:23',NULL,NULL),(558,NULL,NULL,'50f9ed844a224e5798d4fa7c89eaad5a',NULL,NULL,NULL,NULL,'2026-02-28 10:22:26',NULL,'2026-02-28 10:22:26',NULL,NULL),(559,NULL,'5bad7d09f95f4bb89ad776416f4acc1d',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:22:26',NULL,'2026-02-28 10:22:26',NULL,NULL),(560,NULL,NULL,'97f8de46f7d54845a94a7f0dbb824b1d',NULL,NULL,NULL,NULL,'2026-02-28 10:22:27',NULL,'2026-02-28 10:22:27',NULL,NULL),(561,NULL,NULL,'31bfbe9c189b4dd4a28a85376dd251f3',NULL,NULL,NULL,NULL,'2026-02-28 10:22:27',NULL,'2026-02-28 10:22:27',NULL,NULL),(562,NULL,'2abcbf7f5228498b87c8291a6e105895',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:22:29',NULL,'2026-02-28 10:22:29',NULL,NULL),(563,NULL,'97427a33ce5a407cba0eabfe53f19829',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:22:30',NULL,'2026-02-28 10:22:30',NULL,NULL),(564,NULL,NULL,'2f7374ba50504762809f7a96fd707266',NULL,NULL,NULL,NULL,'2026-02-28 10:22:32',NULL,'2026-02-28 10:22:32',NULL,NULL),(565,NULL,'7593acb0b3ec48fe9d6e5460708cb2d5',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:22:33',NULL,'2026-02-28 10:22:33',NULL,NULL),(566,NULL,'f97b924813cd4214a8fc382ca69c4e60',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:22:33',NULL,'2026-02-28 10:22:33',NULL,NULL),(567,NULL,NULL,'8efb5a503d2441dabbb520eb339f2618',NULL,NULL,NULL,NULL,'2026-02-28 10:22:33',NULL,'2026-02-28 10:22:33',NULL,NULL),(568,NULL,NULL,'942954cc73574428a4d8f73eaa636c09',NULL,NULL,NULL,NULL,'2026-02-28 10:22:34',NULL,'2026-02-28 10:22:34',NULL,NULL),(569,NULL,'5a9dd054e5c94ce087f0bcd071a36660',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:22:35',NULL,'2026-02-28 10:22:35',NULL,NULL),(570,NULL,'a9f64796d3a241b09b8146f16c529a4f',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:22:36',NULL,'2026-02-28 10:22:36',NULL,NULL),(571,NULL,NULL,'00242561874342e0b6a98fd6ffd4373c',NULL,NULL,NULL,NULL,'2026-02-28 10:22:40',NULL,'2026-02-28 10:22:40',NULL,NULL),(572,NULL,NULL,'6c2917b635954508849a344088c7d559',NULL,NULL,NULL,NULL,'2026-02-28 10:22:40',NULL,'2026-02-28 10:22:40',NULL,NULL),(573,NULL,'cd883fd433a34ed7aa17e9a1e92d2279',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:22:42',NULL,'2026-02-28 10:22:42',NULL,NULL),(574,NULL,'dadcaa1cf44744eb9011fd394c704c1b',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:22:42',NULL,'2026-02-28 10:22:42',NULL,NULL),(575,NULL,NULL,NULL,NULL,'ecb2ba302c5d4d13a76388b27be0ce68',NULL,NULL,'2026-02-28 10:22:48',NULL,'2026-02-28 10:22:48',NULL,NULL),(576,NULL,NULL,'ed0f5bb67f314ae488a2dfa7c5aac2ee',NULL,NULL,NULL,NULL,'2026-02-28 10:22:48',NULL,'2026-02-28 10:22:48',NULL,NULL),(577,NULL,'d4a99bf3d9294871ab36b038ebe9d674',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:22:48',NULL,'2026-02-28 10:22:48',NULL,NULL),(578,NULL,NULL,NULL,NULL,'ff526274bb0d45bab256effae382f209',NULL,NULL,'2026-02-28 10:22:51',NULL,'2026-02-28 10:22:51',NULL,NULL),(579,NULL,NULL,'5a2d0f85d83e46d6bce9ce89fd822aed',NULL,NULL,NULL,NULL,'2026-02-28 10:22:51',NULL,'2026-02-28 10:22:51',NULL,NULL),(580,NULL,'80aeb9e610f24be4a7039718afffb4ab',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:22:51',NULL,'2026-02-28 10:22:51',NULL,NULL),(581,NULL,NULL,NULL,NULL,'10a6747790aa4a788d5879f5ec690fb6',NULL,NULL,'2026-02-28 10:22:53',NULL,'2026-02-28 10:22:53',NULL,NULL),(582,NULL,NULL,'4098f9fc730041da83f4deaf5f569451',NULL,NULL,NULL,NULL,'2026-02-28 10:22:54',NULL,'2026-02-28 10:22:54',NULL,NULL),(583,NULL,'34b01efcf62945d9814a8145c08e933e',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:22:54',NULL,'2026-02-28 10:22:54',NULL,NULL),(584,NULL,NULL,'4d09e0704bc04853a4075d0fb2a76848',NULL,NULL,NULL,NULL,'2026-02-28 10:22:56',NULL,'2026-02-28 10:22:56',NULL,NULL),(585,NULL,'8ec5936a61924833b5bbeee0f23eb264',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:22:56',NULL,'2026-02-28 10:22:56',NULL,NULL),(586,NULL,NULL,NULL,NULL,'955bdd10bea4411584f1140302569f0c',NULL,NULL,'2026-02-28 10:22:58',NULL,'2026-02-28 10:22:58',NULL,NULL),(587,NULL,NULL,'ec9893cb587b42f5acc1cf3afe06418f',NULL,NULL,NULL,NULL,'2026-02-28 10:22:59',NULL,'2026-02-28 10:22:59',NULL,NULL),(588,NULL,'f9c29f5cce414f459cc7c19a81e8dff2',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:22:59',NULL,'2026-02-28 10:22:59',NULL,NULL),(589,NULL,NULL,NULL,NULL,'48adfab5e6f74669967dea73d9444336',NULL,NULL,'2026-02-28 10:23:01',NULL,'2026-02-28 10:23:01',NULL,NULL),(590,NULL,NULL,'22855601268b45609ebcd12713d36280',NULL,NULL,NULL,NULL,'2026-02-28 10:23:02',NULL,'2026-02-28 10:23:02',NULL,NULL),(591,NULL,'674d1eab9e484dbca0ec4fdcd9f5bb2d',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:23:02',NULL,'2026-02-28 10:23:02',NULL,NULL),(592,NULL,NULL,'324a0d95b97d4044a7b984b489c0f34c',NULL,NULL,NULL,NULL,'2026-02-28 10:23:02',NULL,'2026-02-28 10:23:02',NULL,NULL),(593,NULL,NULL,'854018e0082146fbaf077b70a8f44b45',NULL,NULL,NULL,NULL,'2026-02-28 10:23:02',NULL,'2026-02-28 10:23:02',NULL,NULL),(594,NULL,'0ca29c91b41549daa2dc22d60908eb05',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:23:05',NULL,'2026-02-28 10:23:05',NULL,NULL),(595,NULL,'78864d182ca840f0a61b3f944f9461c5',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:23:06',NULL,'2026-02-28 10:23:06',NULL,NULL),(596,NULL,NULL,'cb108f0cafa2405280bb8ccb3ab325b5',NULL,NULL,NULL,NULL,'2026-02-28 10:23:09',NULL,'2026-02-28 10:23:09',NULL,NULL),(597,NULL,'1f30ed6f04bb4e9581626cfbfb53a622',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:23:10',NULL,'2026-02-28 10:23:10',NULL,NULL),(598,NULL,NULL,'fadc16a93aba49ad90de6e702655da0e',NULL,NULL,NULL,NULL,'2026-02-28 10:23:12',NULL,'2026-02-28 10:23:12',NULL,NULL),(599,NULL,'fe60785d5ec8493fa8fc6bb45a6ae57b',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:23:14',NULL,'2026-02-28 10:23:14',NULL,NULL),(600,NULL,NULL,'dee89be5ab1d4d3cb12c6ec9fb944136',NULL,NULL,NULL,NULL,'2026-02-28 10:23:17',NULL,'2026-02-28 10:23:17',NULL,NULL),(601,NULL,NULL,'8ddd9396c98e4368aa762fd5a61091fd',NULL,NULL,NULL,NULL,'2026-02-28 10:23:18',NULL,'2026-02-28 10:23:18',NULL,NULL),(602,NULL,'c40694e3456e4ba9ba2f9626db063518',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:23:19',NULL,'2026-02-28 10:23:19',NULL,NULL),(603,NULL,'420ef20544b3434f813c576e43f36e70',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:23:20',NULL,'2026-02-28 10:23:20',NULL,NULL),(604,NULL,NULL,'bc007ed008704741942144c16a89ac24',NULL,NULL,NULL,NULL,'2026-02-28 10:23:26',NULL,'2026-02-28 10:23:26',NULL,NULL),(605,NULL,'7330819c1f4f4bfdb96694219c3e13f9',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:23:28',NULL,'2026-02-28 10:23:28',NULL,NULL),(606,NULL,NULL,'702fe998a0a3479487e7caa12ca75fb5',NULL,NULL,NULL,NULL,'2026-02-28 10:23:30',NULL,'2026-02-28 10:23:30',NULL,NULL),(607,NULL,'67bbe0cd3e93488fb66367c896885cc0',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:23:31',NULL,'2026-02-28 10:23:31',NULL,NULL),(608,NULL,NULL,'4faeec2f8b0342f4ac94b66e381a05f2',NULL,NULL,NULL,NULL,'2026-02-28 10:23:34',NULL,'2026-02-28 10:23:34',NULL,NULL),(609,NULL,'a770ae3f8507449f925ecab17c2cdf2c',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:23:35',NULL,'2026-02-28 10:23:35',NULL,NULL),(610,NULL,NULL,'e69c785044b643ccb7c1cff1c50db88c',NULL,NULL,NULL,NULL,'2026-02-28 10:23:38',NULL,'2026-02-28 10:23:38',NULL,NULL),(611,NULL,'ea8221af0cd241d7b9463c961fe30179',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:23:39',NULL,'2026-02-28 10:23:39',NULL,NULL),(612,NULL,NULL,'120b183f1e484937b96fc486c1fc06aa',NULL,NULL,NULL,NULL,'2026-02-28 10:24:10',NULL,'2026-02-28 10:24:10',NULL,NULL),(613,NULL,NULL,'65a0480f2c3b48a4bfcf70227e4230f8',NULL,NULL,NULL,NULL,'2026-02-28 10:24:10',NULL,'2026-02-28 10:24:10',NULL,NULL),(614,NULL,NULL,'864ead56f7b34bad83afadf83b9e6a1b',NULL,NULL,NULL,NULL,'2026-02-28 10:24:10',NULL,'2026-02-28 10:24:10',NULL,NULL),(615,NULL,'534205baf6f04f968eb7fd26debe8279',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:24:11',NULL,'2026-02-28 10:24:11',NULL,NULL),(616,NULL,'c64426555c744e15a6a3568510b132d1',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:24:12',NULL,'2026-02-28 10:24:12',NULL,NULL),(617,NULL,'43da895eeae54af3b6c050f9329c99ef',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:24:13',NULL,'2026-02-28 10:24:13',NULL,NULL),(618,NULL,'a256cbd98c5a409fb9ce8d425dc1613b',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:24:25',NULL,'2026-02-28 10:24:25',NULL,NULL),(619,NULL,NULL,'8c0294b95e824da4ad40eed2eb22681f',NULL,NULL,NULL,NULL,'2026-02-28 10:24:35',NULL,'2026-02-28 10:24:35',NULL,NULL),(620,NULL,'aa9d839058c943aab655a5b7e0e13750',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:24:37',NULL,'2026-02-28 10:24:37',NULL,NULL),(621,NULL,NULL,'30797c1e587b4532a2e148d0cdcd9c51',NULL,NULL,NULL,NULL,'2026-02-28 10:24:50',NULL,'2026-02-28 10:24:50',NULL,NULL),(622,NULL,NULL,'a8fb41c6f8d842d3b17c9155a84a1e99',NULL,NULL,NULL,NULL,'2026-02-28 10:24:50',NULL,'2026-02-28 10:24:50',NULL,NULL),(623,NULL,'1c3cb5cdfa53405bb0387af43e804bd1',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:24:51',NULL,'2026-02-28 10:24:51',NULL,NULL),(624,NULL,NULL,'4d4d0af9c13240908c15702b7cced039',NULL,NULL,NULL,NULL,'2026-02-28 10:25:06',NULL,'2026-02-28 10:25:06',NULL,NULL),(625,NULL,NULL,'99b0880b56d543bbb1ba274e76994e26',NULL,NULL,NULL,NULL,'2026-02-28 10:25:07',NULL,'2026-02-28 10:25:07',NULL,NULL),(626,NULL,'b8bd365f89544b8aa8bd6ef2c56b205a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:25:09',NULL,'2026-02-28 10:25:09',NULL,NULL),(627,NULL,'e064bbea661440ea95b1fac5c1b81fb4',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:25:10',NULL,'2026-02-28 10:25:10',NULL,NULL),(628,NULL,NULL,'2740ca582c7e4862afdd3b12668527f8',NULL,NULL,NULL,NULL,'2026-02-28 10:25:15',NULL,'2026-02-28 10:25:15',NULL,NULL),(629,NULL,NULL,'636a691f38b84b8188b177caf34a141b',NULL,NULL,NULL,NULL,'2026-02-28 10:25:15',NULL,'2026-02-28 10:25:15',NULL,NULL),(630,NULL,'7872b1eaa75a41cbb383e577def423a7',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:25:17',NULL,'2026-02-28 10:25:17',NULL,NULL),(631,NULL,'200a6ebf15aa4c458eb60350422e6d5b',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:25:18',NULL,'2026-02-28 10:25:18',NULL,NULL),(632,NULL,NULL,'df63289bf60946e2a983ee2fa57352b1',NULL,NULL,NULL,NULL,'2026-02-28 10:25:23',NULL,'2026-02-28 10:25:23',NULL,NULL),(633,NULL,'ff0879b364b142e782530e413eb35f55',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:25:24',NULL,'2026-02-28 10:25:24',NULL,NULL),(634,NULL,NULL,'905531b452654da988062192b95a856d',NULL,NULL,NULL,NULL,'2026-02-28 10:25:27',NULL,'2026-02-28 10:25:27',NULL,NULL),(635,NULL,'aec37bd3d00b4005bf031c7fc8dabbd0',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:25:28',NULL,'2026-02-28 10:25:28',NULL,NULL),(636,NULL,NULL,'ab551b36bb474f93b87ff860a7b59605',NULL,NULL,NULL,NULL,'2026-02-28 10:25:33',NULL,'2026-02-28 10:25:33',NULL,NULL),(637,NULL,NULL,'38528f5b5b9541a8bf0fc93110648716',NULL,NULL,NULL,NULL,'2026-02-28 10:25:33',NULL,'2026-02-28 10:25:33',NULL,NULL),(638,NULL,'e1a0d261537d4b619fd96b6edc1c10e0',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:25:34',NULL,'2026-02-28 10:25:34',NULL,NULL),(639,NULL,'a07df24161b1405e978cd3e942282f70',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:25:36',NULL,'2026-02-28 10:25:36',NULL,NULL),(640,NULL,'a5a4d7abc8874302af924558ae3a27da',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:25:40',NULL,'2026-02-28 10:25:40',NULL,NULL),(641,NULL,'1a82b03f23fe4b32a5058bd5668845cd',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:25:41',NULL,'2026-02-28 10:25:41',NULL,NULL),(642,NULL,'53b3a193b3d04d0c9bf8e050a3c6f675',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:25:41',NULL,'2026-02-28 10:25:41',NULL,NULL),(643,NULL,NULL,'447e5bfb3c35483f80e7b5d30da7d000',NULL,NULL,NULL,NULL,'2026-02-28 10:25:42',NULL,'2026-02-28 10:25:42',NULL,NULL),(644,NULL,'a61959bb9d404bc1befd394495b698da',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:25:42',NULL,'2026-02-28 10:25:42',NULL,NULL),(645,NULL,'efecde99dfe448609f0a61f6fcc80e2c',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:25:43',NULL,'2026-02-28 10:25:43',NULL,NULL),(646,NULL,'50812cd6c21d44aaa63c36597bf72f9e',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:25:43',NULL,'2026-02-28 10:25:43',NULL,NULL),(647,NULL,'b134d39c56c0474b8dfb789be96be857',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:25:44',NULL,'2026-02-28 10:25:44',NULL,NULL),(648,NULL,NULL,'a058509387d1498faacc5d71605f683a',NULL,NULL,NULL,NULL,'2026-02-28 10:25:44',NULL,'2026-02-28 10:25:44',NULL,NULL),(649,NULL,NULL,'15f72b97b9b34521bc528a5312191709',NULL,NULL,NULL,NULL,'2026-02-28 10:25:44',NULL,'2026-02-28 10:25:44',NULL,NULL),(650,NULL,'f2e8fad3f59e4a198fbb3ca2e77d78b4',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:25:46',NULL,'2026-02-28 10:25:46',NULL,NULL),(651,NULL,'6187055335fa47e5be925c895a9a2f93',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:25:47',NULL,'2026-02-28 10:25:47',NULL,NULL),(652,NULL,NULL,'fac7fbd552ff44b68e5d69836aefbeaa',NULL,NULL,NULL,NULL,'2026-02-28 10:25:51',NULL,'2026-02-28 10:25:51',NULL,NULL),(653,NULL,NULL,'74920a691e7f4b7595db45084fec5788',NULL,NULL,NULL,NULL,'2026-02-28 10:25:51',NULL,'2026-02-28 10:25:51',NULL,NULL),(654,NULL,'32db62755ad64b86bfd5bf27ec576a6b',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:25:53',NULL,'2026-02-28 10:25:53',NULL,NULL),(655,NULL,NULL,'c82d3202d8774f35b22de0ca1ff95ad9',NULL,NULL,NULL,NULL,'2026-02-28 10:25:53',NULL,'2026-02-28 10:25:53',NULL,NULL),(656,NULL,'20abcae1e88b4ab88a16bd032009e98d',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:25:54',NULL,'2026-02-28 10:25:54',NULL,NULL),(657,NULL,'a5c264946768448e9246a07a54d4b13c',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:25:54',NULL,'2026-02-28 10:25:54',NULL,NULL),(658,NULL,NULL,NULL,NULL,NULL,'d544dad64a794f4fb385768143842a48',NULL,'2026-02-28 10:25:57',NULL,'2026-02-28 10:25:57',NULL,NULL),(659,NULL,NULL,NULL,NULL,NULL,'d8881487eadd4440821c8362663d580a',NULL,'2026-02-28 10:25:57',NULL,'2026-02-28 10:25:57',NULL,NULL),(660,NULL,NULL,NULL,NULL,NULL,'12fe27b81f5f42ab97c8aee8d5f8c8ea',NULL,'2026-02-28 10:25:57',NULL,'2026-02-28 10:25:57',NULL,NULL),(661,NULL,NULL,NULL,NULL,NULL,'dfa0ebe549b14b178deae47accd008f3',NULL,'2026-02-28 10:25:57',NULL,'2026-02-28 10:25:57',NULL,NULL),(662,NULL,NULL,NULL,NULL,NULL,'c5104051ecf241189a3824453e30b684',NULL,'2026-02-28 10:25:58',NULL,'2026-02-28 10:25:58',NULL,NULL),(663,NULL,NULL,'72c772ac085140689009c20025d405f8',NULL,NULL,NULL,NULL,'2026-02-28 10:25:58',NULL,'2026-02-28 10:25:58',NULL,NULL),(664,NULL,NULL,'856e5dd6dc7c4ee9b07f96f56acdcb8d',NULL,NULL,NULL,NULL,'2026-02-28 10:25:58',NULL,'2026-02-28 10:25:58',NULL,NULL),(665,NULL,'c13a15cded014de99fcbaed52afbe7c2',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:26:00',NULL,'2026-02-28 10:26:00',NULL,NULL),(666,NULL,'40acbb3f460c4a16b760969b14c26186',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:26:02',NULL,'2026-02-28 10:26:02',NULL,NULL),(667,NULL,NULL,'24e672aea808435c82dc8ef7c8813f0d',NULL,NULL,NULL,NULL,'2026-02-28 10:26:06',NULL,'2026-02-28 10:26:06',NULL,NULL),(668,NULL,NULL,'9de54e1f159e4b11aa30cb4f7fac366e',NULL,NULL,NULL,NULL,'2026-02-28 10:26:06',NULL,'2026-02-28 10:26:06',NULL,NULL),(669,NULL,'05dcdc958ca0451884070319792387d9',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:26:07',NULL,'2026-02-28 10:26:07',NULL,NULL),(670,NULL,'4d20af10fb6a4a96b3fedd33b5fcf33c',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:26:08',NULL,'2026-02-28 10:26:08',NULL,NULL),(671,NULL,'7001e700e3314014bfae3ea609c6e174',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:26:12',NULL,'2026-02-28 10:26:12',NULL,NULL),(672,NULL,NULL,'010463c1dc3f49148ca35737ce87e319',NULL,NULL,NULL,NULL,'2026-02-28 10:26:12',NULL,'2026-02-28 10:26:12',NULL,NULL),(673,NULL,NULL,'82b02fdbcb8b4a7a9f01f6e0ac2e60db',NULL,NULL,NULL,NULL,'2026-02-28 10:26:13',NULL,'2026-02-28 10:26:13',NULL,NULL),(674,NULL,'809166289363498b9e04dfa33d71b9f0',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:26:16',NULL,'2026-02-28 10:26:16',NULL,NULL),(675,NULL,'31be8164e21f46889b56b2be7b3fb410',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:26:17',NULL,'2026-02-28 10:26:17',NULL,NULL),(676,NULL,NULL,'1224bfc9ea934a5ab7c1f47f17a42c73',NULL,NULL,NULL,NULL,'2026-02-28 10:26:21',NULL,'2026-02-28 10:26:21',NULL,NULL),(677,NULL,NULL,'1224bfc9ea934a5ab7c1f47f17a42c73',NULL,NULL,NULL,NULL,'2026-02-28 10:26:22',NULL,'2026-02-28 10:26:22',NULL,NULL),(678,NULL,'2c5b674b744a4c34b2b7210535e7e42c',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:26:22',NULL,'2026-02-28 10:26:22',NULL,NULL),(679,NULL,NULL,'b0d4b71e747d455ea7c98b7c0ab8fc08',NULL,NULL,NULL,NULL,'2026-02-28 10:26:22',NULL,'2026-02-28 10:26:22',NULL,NULL),(680,NULL,NULL,'f11793c847404decb4b69316672e1070',NULL,NULL,NULL,NULL,'2026-02-28 10:26:23',NULL,'2026-02-28 10:26:23',NULL,NULL),(681,NULL,NULL,'fb8576897acf4b659566a84ba24aef31',NULL,NULL,NULL,NULL,'2026-02-28 10:26:24',NULL,'2026-02-28 10:26:24',NULL,NULL),(682,NULL,'33cdaa543a704f6b9d8a2f72f827a9c6',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:26:24',NULL,'2026-02-28 10:26:24',NULL,NULL),(683,NULL,'3b5e402693fa4fe39a386dbc8335a3b9',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:26:26',NULL,'2026-02-28 10:26:26',NULL,NULL),(684,NULL,'af2a4236b52c4058a8aba9e745a92360',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:26:26',NULL,'2026-02-28 10:26:26',NULL,NULL),(685,NULL,NULL,'0e31cea089954b2d9fd4c0e9e0ed958b',NULL,NULL,NULL,NULL,'2026-02-28 10:26:32',NULL,'2026-02-28 10:26:32',NULL,NULL),(686,NULL,'50e39c1062e44790b7aedcd3f240dda8',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:26:35',NULL,'2026-02-28 10:26:35',NULL,NULL),(687,NULL,NULL,'94e542cadd8e42b18168b2801ed35ab7',NULL,NULL,NULL,NULL,'2026-02-28 10:26:38',NULL,'2026-02-28 10:26:38',NULL,NULL),(688,NULL,'d3d30be27a3f4fc2af549ffbcaf69bef',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:26:39',NULL,'2026-02-28 10:26:39',NULL,NULL),(689,NULL,NULL,'faec548b365c4d4ab54a37af76c2629b',NULL,NULL,NULL,NULL,'2026-02-28 10:26:43',NULL,'2026-02-28 10:26:43',NULL,NULL),(690,NULL,NULL,'dc8c36dc12834043aa3e0a6ad0f5fb3b',NULL,NULL,NULL,NULL,'2026-02-28 10:26:43',NULL,'2026-02-28 10:26:43',NULL,NULL),(691,NULL,'77480088482042028f626594bb1f4711',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:26:44',NULL,'2026-02-28 10:26:44',NULL,NULL),(692,NULL,'cab08f9842da4baaaaf2ce77b8ba74d2',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:26:45',NULL,'2026-02-28 10:26:45',NULL,NULL),(693,NULL,NULL,'0bc93918dc0146beaa5b78d931d6c606',NULL,NULL,NULL,NULL,'2026-02-28 10:26:50',NULL,'2026-02-28 10:26:50',NULL,NULL),(694,NULL,NULL,'345f91184de24197b24bc184fb457ec6',NULL,NULL,NULL,NULL,'2026-02-28 10:26:51',NULL,'2026-02-28 10:26:51',NULL,NULL),(695,NULL,NULL,'1fdb655e5dc64fc7876c4da0254e2ef4',NULL,NULL,NULL,NULL,'2026-02-28 10:26:51',NULL,'2026-02-28 10:26:51',NULL,NULL),(696,NULL,'c04ef483e5fa4cf29a7e66290f043ca3',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:26:52',NULL,'2026-02-28 10:26:52',NULL,NULL),(697,NULL,'0ce13055eb174cda99b5ebdf68c1a008',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:26:52',NULL,'2026-02-28 10:26:52',NULL,NULL),(698,NULL,'85c3dc10829e44b8871c7501c5306271',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:26:53',NULL,'2026-02-28 10:26:53',NULL,NULL),(699,NULL,NULL,'d5f005bed23e4a6a91c06cdc1e4cd4f6',NULL,NULL,NULL,NULL,'2026-02-28 10:26:55',NULL,'2026-02-28 10:26:55',NULL,NULL),(700,NULL,'9adb1314d39a4bc890e8b4698e4d8b70',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:26:56',NULL,'2026-02-28 10:26:56',NULL,NULL),(701,NULL,NULL,'86283de120f44aa3901e4ba762e0ff3e',NULL,NULL,NULL,NULL,'2026-02-28 10:26:57',NULL,'2026-02-28 10:26:57',NULL,NULL),(702,NULL,NULL,'31f7df9e08834629969b530703e05f2d',NULL,NULL,NULL,NULL,'2026-02-28 10:26:57',NULL,'2026-02-28 10:26:57',NULL,NULL),(703,NULL,'9412a7b5a37e4f30afa819f5df9d1f78',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:26:59',NULL,'2026-02-28 10:26:59',NULL,NULL),(704,NULL,'4bcade8d626a41e180fb79febbfc6968',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:27:01',NULL,'2026-02-28 10:27:01',NULL,NULL),(705,NULL,NULL,'283dbc2fc0c94e678bc6d25fc41117d8',NULL,NULL,NULL,NULL,'2026-02-28 10:27:06',NULL,'2026-02-28 10:27:06',NULL,NULL),(706,NULL,NULL,'a709e7090a3c4b7a967765a89a5f5e62',NULL,NULL,NULL,NULL,'2026-02-28 10:27:06',NULL,'2026-02-28 10:27:06',NULL,NULL),(707,NULL,'9c91a9d6c97c4ecda0d916100beb2c03',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:27:07',NULL,'2026-02-28 10:27:07',NULL,NULL),(708,NULL,'dbc2f6ca883e4f5084f9a2d57f6531aa',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:27:08',NULL,'2026-02-28 10:27:08',NULL,NULL),(709,NULL,NULL,'f9046d3ef932481196b82d5e1fdd5de6',NULL,NULL,NULL,NULL,'2026-02-28 10:27:11',NULL,'2026-02-28 10:27:11',NULL,NULL),(710,NULL,NULL,'d000e26b1aaf4a60bd2c928412e59ca5',NULL,NULL,NULL,NULL,'2026-02-28 10:27:11',NULL,'2026-02-28 10:27:11',NULL,NULL),(711,NULL,NULL,'0f60276a0ef0499ab49ea65e3054604b',NULL,NULL,NULL,NULL,'2026-02-28 10:27:11',NULL,'2026-02-28 10:27:11',NULL,NULL),(712,NULL,NULL,'9539e6abe09747588d7711dad00221b4',NULL,NULL,NULL,NULL,'2026-02-28 10:27:12',NULL,'2026-02-28 10:27:12',NULL,NULL),(713,NULL,NULL,'57e449a0a5794aff830486543b86a719',NULL,NULL,NULL,NULL,'2026-02-28 10:27:12',NULL,'2026-02-28 10:27:12',NULL,NULL),(714,NULL,'79ca6f14eabc468fa3782a6cd3ae4486',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:27:12',NULL,'2026-02-28 10:27:12',NULL,NULL),(715,NULL,'1dab7067181d43f1acb702fce4ca882c',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:27:14',NULL,'2026-02-28 10:27:14',NULL,NULL),(716,NULL,'726aae950ac141049c953fa352bd555a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:27:15',NULL,'2026-02-28 10:27:15',NULL,NULL),(717,NULL,'1eb3aafa74d14544ba5cde61223f2e23',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:27:15',NULL,'2026-02-28 10:27:15',NULL,NULL),(718,NULL,'c6026252a4384472b37b98062f137dab',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:27:16',NULL,'2026-02-28 10:27:16',NULL,NULL),(719,NULL,NULL,'5ca1250827284f8c8d36c029f20b44a7',NULL,NULL,NULL,NULL,'2026-02-28 10:27:17',NULL,'2026-02-28 10:27:17',NULL,NULL),(720,NULL,'32a39e8cde2f4524a7dd15e916525a83',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:27:18',NULL,'2026-02-28 10:27:18',NULL,NULL),(721,NULL,NULL,'67e8ce68e0124823877ec317f8fd2ca0',NULL,NULL,NULL,NULL,'2026-02-28 10:27:21',NULL,'2026-02-28 10:27:21',NULL,NULL),(722,NULL,NULL,'1c3b6b5455684dd4a553369530af2c65',NULL,NULL,NULL,NULL,'2026-02-28 10:27:21',NULL,'2026-02-28 10:27:21',NULL,NULL),(723,NULL,'1a938794f1c34af1b55d1f3e3b7e81a6',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:27:22',NULL,'2026-02-28 10:27:22',NULL,NULL),(724,NULL,'ccfe18aee2ef470785f94a645b3b432a',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:27:23',NULL,'2026-02-28 10:27:23',NULL,NULL),(725,NULL,NULL,'127ffd62269342219d9769ef78779278',NULL,NULL,NULL,NULL,'2026-02-28 10:27:38',NULL,'2026-02-28 10:27:38',NULL,NULL),(726,NULL,NULL,'6559f8f0e47a4bcbbebb9a33d5a7c3c0',NULL,NULL,NULL,NULL,'2026-02-28 10:27:39',NULL,'2026-02-28 10:27:39',NULL,NULL),(727,NULL,'810d5f46c2f244a59296e83618af50fe',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:27:39',NULL,'2026-02-28 10:27:39',NULL,NULL),(728,NULL,'8aa4c660836e4ae992a47ce0868d1867',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:27:41',NULL,'2026-02-28 10:27:41',NULL,NULL),(729,NULL,NULL,'1ca1d21bd8e24a8ab561e1d4afba1009',NULL,NULL,NULL,NULL,'2026-02-28 10:27:45',NULL,'2026-02-28 10:27:45',NULL,NULL),(730,NULL,'ce7b34dc1f6440b9903c420596a82d01',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:27:48',NULL,'2026-02-28 10:27:48',NULL,NULL),(731,NULL,NULL,'26b1c9f09dbc4c78864455ba9ebad379',NULL,NULL,NULL,NULL,'2026-02-28 10:27:49',NULL,'2026-02-28 10:27:49',NULL,NULL),(732,NULL,'bf21c1736b4043698e1f9355dc135459',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:27:52',NULL,'2026-02-28 10:27:52',NULL,NULL),(733,NULL,NULL,'3ed826a3011e43d68aac3f001281440a',NULL,NULL,NULL,NULL,'2026-02-28 10:27:58',NULL,'2026-02-28 10:27:58',NULL,NULL),(734,NULL,NULL,'ae0bbf55ab4c4d1da3f4ff66ab9e2ec4',NULL,NULL,NULL,NULL,'2026-02-28 10:27:58',NULL,'2026-02-28 10:27:58',NULL,NULL),(735,NULL,'859784d5f59f4db99fb375f781853be3',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:27:59',NULL,'2026-02-28 10:27:59',NULL,NULL),(736,NULL,'2a038009ea374da1917dcf4fe64a32d6',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:28:00',NULL,'2026-02-28 10:28:00',NULL,NULL),(737,NULL,NULL,'5416cb9ec2d440aabda29f7e20cc062e',NULL,NULL,NULL,NULL,'2026-02-28 10:28:09',NULL,'2026-02-28 10:28:09',NULL,NULL),(738,NULL,'ff23cab6472d4ce08aae65796326505c',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:28:10',NULL,'2026-02-28 10:28:10',NULL,NULL),(739,NULL,NULL,'f9dd03f07d754030bedc45ef75a2ceb8',NULL,NULL,NULL,NULL,'2026-02-28 10:28:13',NULL,'2026-02-28 10:28:13',NULL,NULL),(740,NULL,NULL,'f2e19e31595b4d0f9eacb1115267399b',NULL,NULL,NULL,NULL,'2026-02-28 10:28:13',NULL,'2026-02-28 10:28:13',NULL,NULL),(741,NULL,'b907eb5634054c23999a514f3cbfbc23',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:28:14',NULL,'2026-02-28 10:28:14',NULL,NULL),(742,NULL,'7ce39c963f444662aed01e0a213c7c1f',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:28:15',NULL,'2026-02-28 10:28:15',NULL,NULL),(743,NULL,NULL,'e168d3fb328e4b45bd8918bb3d910380',NULL,NULL,NULL,NULL,'2026-02-28 10:28:27',NULL,'2026-02-28 10:28:27',NULL,NULL),(744,NULL,'930e4653333844b48604138502fb4bea',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:28:28',NULL,'2026-02-28 10:28:28',NULL,NULL),(745,NULL,NULL,'c0ac50bb1ee14294b63950bc16b90376',NULL,NULL,NULL,NULL,'2026-02-28 10:28:34',NULL,'2026-02-28 10:28:34',NULL,NULL),(746,NULL,'aa7760fa32c646ea9b6022fb13cbad1c',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:28:37',NULL,'2026-02-28 10:28:37',NULL,NULL),(747,NULL,NULL,'07469daa165743479f10b06fdf856363',NULL,NULL,NULL,NULL,'2026-02-28 10:28:41',NULL,'2026-02-28 10:28:41',NULL,NULL),(748,NULL,'47f7c6382b824e0d89ad8bcc277ab5d8',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:28:42',NULL,'2026-02-28 10:28:42',NULL,NULL),(749,NULL,NULL,'ac58474e5ed14ce6b1c5b9697d03ff84',NULL,NULL,NULL,NULL,'2026-02-28 10:29:18',NULL,'2026-02-28 10:29:18',NULL,NULL),(750,NULL,'c294adf99b0c4542bfe5f677c8f06fef',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:29:19',NULL,'2026-02-28 10:29:19',NULL,NULL),(751,NULL,NULL,'17bbdce048f042998175e4f881537258',NULL,NULL,NULL,NULL,'2026-02-28 10:30:34',NULL,'2026-02-28 10:30:34',NULL,NULL),(752,NULL,'d63dffc0c4824b1ba9837c0e749feaf5',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:30:36',NULL,'2026-02-28 10:30:36',NULL,NULL),(753,NULL,NULL,'f54beab12fce4ee8adf80742bf33b916',NULL,NULL,NULL,NULL,'2026-02-28 10:30:36',NULL,'2026-02-28 10:30:36',NULL,NULL),(754,NULL,NULL,'ae12c36e39e14bca894adfbda0e210c6',NULL,NULL,NULL,NULL,'2026-02-28 10:30:37',NULL,'2026-02-28 10:30:37',NULL,NULL),(755,NULL,'b8afc4ff109d4ba6892617bb2c7a5388',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:30:38',NULL,'2026-02-28 10:30:38',NULL,NULL),(756,NULL,'344dd946e14146ab93c01183964c71b3',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:30:39',NULL,'2026-02-28 10:30:39',NULL,NULL),(757,NULL,NULL,'64f45043985d497faa08058976d8e184',NULL,NULL,NULL,NULL,'2026-02-28 10:31:02',NULL,'2026-02-28 10:31:02',NULL,NULL),(758,NULL,NULL,'c5ece5096d1b42409e2eb56523296065',NULL,NULL,NULL,NULL,'2026-02-28 10:31:02',NULL,'2026-02-28 10:31:02',NULL,NULL),(759,NULL,'351ec22aef4b452a8c102443e75a4380',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:31:03',NULL,'2026-02-28 10:31:03',NULL,NULL),(760,NULL,'11d5279379534cbeb64722fed466cc1e',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:31:03',NULL,'2026-02-28 10:31:03',NULL,NULL),(761,NULL,NULL,'90c002bc56a143a7bcbe5adf4f4304aa',NULL,NULL,NULL,NULL,'2026-02-28 10:31:17',NULL,'2026-02-28 10:31:17',NULL,NULL),(762,NULL,'e6065f41cb9a4465a1bd4507c19a482b',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:31:18',NULL,'2026-02-28 10:31:18',NULL,NULL),(763,NULL,NULL,'9bfc6a570eb741ce95e2c60a63644a2b',NULL,NULL,NULL,NULL,'2026-02-28 10:31:20',NULL,'2026-02-28 10:31:20',NULL,NULL),(764,NULL,'ec026d82218f416eb37e41e5c8ffb032',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:31:22',NULL,'2026-02-28 10:31:22',NULL,NULL),(765,NULL,NULL,'650c2257f77e4479a1983c3866e0005f',NULL,NULL,NULL,NULL,'2026-02-28 10:31:25',NULL,'2026-02-28 10:31:25',NULL,NULL),(766,NULL,'10742efebeb549cbbecc7918ebea8ac5',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:31:26',NULL,'2026-02-28 10:31:26',NULL,NULL),(767,NULL,NULL,'4f82ceae360548babfdc917b651fd34b',NULL,NULL,NULL,NULL,'2026-02-28 10:31:37',NULL,'2026-02-28 10:31:37',NULL,NULL),(768,NULL,'be19625e641445a99b3342c3e50786a8',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:31:39',NULL,'2026-02-28 10:31:39',NULL,NULL),(769,NULL,NULL,'f6180bee2d4e40fe8342015cac7ab23c',NULL,NULL,NULL,NULL,'2026-02-28 10:32:16',NULL,'2026-02-28 10:32:16',NULL,NULL),(770,NULL,NULL,'810bc4f795cf498f92be704701e49b73',NULL,NULL,NULL,NULL,'2026-02-28 10:32:16',NULL,'2026-02-28 10:32:16',NULL,NULL),(771,NULL,'316d681aa82d493cbcf41bdc47bd0849',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:32:18',NULL,'2026-02-28 10:32:18',NULL,NULL),(772,NULL,'cd2766ea8b8b48448dd602dfacf13bee',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:32:19',NULL,'2026-02-28 10:32:19',NULL,NULL),(773,NULL,NULL,'ecebf54c6f3344489cf5e51d91d8ed5a',NULL,NULL,NULL,NULL,'2026-02-28 10:42:29',NULL,'2026-02-28 10:42:29',NULL,NULL),(774,NULL,NULL,'dc29bc155df648c6afb5595dcaa377fd',NULL,NULL,NULL,NULL,'2026-02-28 10:42:29',NULL,'2026-02-28 10:42:29',NULL,NULL),(775,NULL,'c724b8068ae9474a9f785bbb84881ff4',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:42:39',NULL,'2026-02-28 10:42:39',NULL,NULL),(776,NULL,'2fef3ce64b984ecab0903a053eab58f6',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:42:41',NULL,'2026-02-28 10:42:41',NULL,NULL),(777,NULL,NULL,'be6308f3690c465980a359a9628b8847',NULL,NULL,NULL,NULL,'2026-02-28 10:47:13',NULL,'2026-02-28 10:47:13',NULL,NULL),(778,NULL,NULL,'7d671d396e7d4a908967cfcc3a3aea5a',NULL,NULL,NULL,NULL,'2026-02-28 10:47:13',NULL,'2026-02-28 10:47:13',NULL,NULL),(779,NULL,'3eafc20864ad4643a4b4fe6f12c46c36',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:47:14',NULL,'2026-02-28 10:47:14',NULL,NULL),(780,NULL,'e055fd8fc0a14939963636c4c701bb37',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:47:15',NULL,'2026-02-28 10:47:15',NULL,NULL),(781,NULL,NULL,'7efc7418904f44aa8c8c9c3e06ac552b',NULL,NULL,NULL,NULL,'2026-02-28 10:49:10',NULL,'2026-02-28 10:49:10',NULL,NULL),(782,NULL,NULL,'e57a155ca2a24c10bb2761d20dfcf8d7',NULL,NULL,NULL,NULL,'2026-02-28 10:49:10',NULL,'2026-02-28 10:49:10',NULL,NULL),(783,NULL,'d7baef4f72e742e8aa7530d7a586ed2b',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:49:11',NULL,'2026-02-28 10:49:11',NULL,NULL),(784,NULL,'01e7f42b4c7242e9acaa895f0f90f8ab',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:49:11',NULL,'2026-02-28 10:49:11',NULL,NULL),(785,NULL,NULL,'614c57a28e0243a28cf8486175f17fa1',NULL,NULL,NULL,NULL,'2026-02-28 10:49:25',NULL,'2026-02-28 10:49:25',NULL,NULL),(786,NULL,NULL,'b95b5c4eab214ad1b93becd4f70af26a',NULL,NULL,NULL,NULL,'2026-02-28 10:49:25',NULL,'2026-02-28 10:49:25',NULL,NULL),(787,NULL,'511870ee2f544eda9f99387c4899e77b',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:49:26',NULL,'2026-02-28 10:49:26',NULL,NULL),(788,NULL,NULL,'3b61ee2651c648abacf025ebb79ec599',NULL,NULL,NULL,NULL,'2026-02-28 10:49:48',NULL,'2026-02-28 10:49:48',NULL,NULL),(789,NULL,NULL,'c7419ad1b4f54023bf3a11193f48c565',NULL,NULL,NULL,NULL,'2026-02-28 10:49:48',NULL,'2026-02-28 10:49:48',NULL,NULL),(790,NULL,'3db9e24aa20044b6bcaade728a86d131',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:49:49',NULL,'2026-02-28 10:49:49',NULL,NULL),(791,NULL,'10cb603dbd5b46848d82ec2c2fad1311',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:49:50',NULL,'2026-02-28 10:49:50',NULL,NULL),(792,NULL,NULL,'ed42a19212e241bba9ee35580db5ca66',NULL,NULL,NULL,NULL,'2026-02-28 10:49:54',NULL,'2026-02-28 10:49:54',NULL,NULL),(793,NULL,NULL,'93a0b19ec61c4da19dce09c4c1794924',NULL,NULL,NULL,NULL,'2026-02-28 10:49:54',NULL,'2026-02-28 10:49:54',NULL,NULL),(794,NULL,'9a71dec23ec74df394ba8608f3d8af99',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:49:55',NULL,'2026-02-28 10:49:55',NULL,NULL),(795,NULL,'d0bc713fb9694b388f04a8d8b8161bf7',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:49:58',NULL,'2026-02-28 10:49:58',NULL,NULL),(796,NULL,NULL,'b59cf797510b4b9fa50eae0c21a4b99f',NULL,NULL,NULL,NULL,'2026-02-28 10:50:32',NULL,'2026-02-28 10:50:32',NULL,NULL),(797,NULL,NULL,'9ea8d53006a34aa19ce0730557f35bd5',NULL,NULL,NULL,NULL,'2026-02-28 10:50:32',NULL,'2026-02-28 10:50:32',NULL,NULL),(798,NULL,'050625c7b5844f129d06114fa72782d8',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:50:35',NULL,'2026-02-28 10:50:35',NULL,NULL),(799,NULL,'13ee67b043c94fce86306d542cd743b8',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:50:36',NULL,'2026-02-28 10:50:36',NULL,NULL),(800,NULL,NULL,'15672f96b88b4894a32daa8445522e76',NULL,NULL,NULL,NULL,'2026-02-28 10:50:45',NULL,'2026-02-28 10:50:45',NULL,NULL),(801,NULL,NULL,'8072d89082a844a6b46cc7b90dec500a',NULL,NULL,NULL,NULL,'2026-02-28 10:50:45',NULL,'2026-02-28 10:50:45',NULL,NULL),(802,NULL,'01bf8a17f96541eb8fc26e1733f921c7',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:50:46',NULL,'2026-02-28 10:50:46',NULL,NULL),(803,NULL,'1510648e993040c19e0f17472733a474',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:50:46',NULL,'2026-02-28 10:50:46',NULL,NULL),(804,NULL,NULL,'fd01a0fd8670442c9591ed54d8a49a9e',NULL,NULL,NULL,NULL,'2026-02-28 10:55:28',NULL,'2026-02-28 10:55:28',NULL,NULL),(805,NULL,NULL,'3af953149b1a41a086fc39dfc920213c',NULL,NULL,NULL,NULL,'2026-02-28 10:55:28',NULL,'2026-02-28 10:55:28',NULL,NULL),(806,NULL,'6e1d5c3a2175460eb058ac943a7982a1',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:55:30',NULL,'2026-02-28 10:55:30',NULL,NULL),(807,NULL,'449cd7a4de444dc69a89fa2426f8bebd',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:55:30',NULL,'2026-02-28 10:55:30',NULL,NULL),(808,NULL,NULL,'c22f2efbdefa4317a2110393ebc1165b',NULL,NULL,NULL,NULL,'2026-02-28 10:55:37',NULL,'2026-02-28 10:55:37',NULL,NULL),(809,NULL,NULL,'5050f1e965364689aeedba2ead39a366',NULL,NULL,NULL,NULL,'2026-02-28 10:55:37',NULL,'2026-02-28 10:55:37',NULL,NULL),(810,NULL,'2697afc665b74b81b67c152945116903',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:55:37',NULL,'2026-02-28 10:55:37',NULL,NULL),(811,NULL,'a388b9de7ca34862b2534628d3605adf',NULL,NULL,NULL,NULL,NULL,'2026-02-28 10:55:37',NULL,'2026-02-28 10:55:37',NULL,NULL),(812,NULL,NULL,'b275005e7fef418bbc491ec40374ffe4',NULL,NULL,NULL,NULL,'2026-02-28 11:02:28',NULL,'2026-02-28 11:02:28',NULL,NULL),(813,NULL,NULL,'2b786d0963b64417aa546204604adcfa',NULL,NULL,NULL,NULL,'2026-02-28 11:02:32',NULL,'2026-02-28 11:02:32',NULL,NULL),(814,NULL,NULL,'e862477f01864e67bd943a775596ff33',NULL,NULL,NULL,NULL,'2026-02-28 11:02:36',NULL,'2026-02-28 11:02:36',NULL,NULL),(815,NULL,NULL,'e862477f01864e67bd943a775596ff33',NULL,NULL,NULL,NULL,'2026-02-28 11:02:37',NULL,'2026-02-28 11:02:37',NULL,NULL),(816,NULL,'d1a6933ec2074301a0fc13dc6d9d4ecc',NULL,NULL,NULL,NULL,NULL,'2026-02-28 11:02:46',NULL,'2026-02-28 11:02:46',NULL,NULL),(817,NULL,NULL,'3113c66418094ae6b472e9f0ddd58443',NULL,NULL,NULL,NULL,'2026-02-28 11:02:50',NULL,'2026-02-28 11:02:50',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('634761601c834b638c087b378a1488be','service','{}','<<null>>',NULL),('b702bb347cb146fc815a66b28d21b1dc','swiftoperator','{}','<<null>>',NULL),('b97fd32597a04077aadb94deb6f05340','reader','{}','<<null>>',NULL),('c3167bbdc0e24db9bf6f3a76d543cae5','member','{}','<<null>>',NULL),('e2e464fed49a4288b45e064e4d67dec3','admin','{}','<<null>>',NULL),('ffbe2b8b18f34600bb7c96861a96b8f9','ResellerAdmin','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('b97fd32597a04077aadb94deb6f05340','IMMU','true'),('c3167bbdc0e24db9bf6f3a76d543cae5','IMMU','true'),('e2e464fed49a4288b45e064e4d67dec3','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('11778b2894684b4b9661aa769b4b450c','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('16399c0308e74105a43bccac984cb981','sharev2',1,'{\"description\": \"Manila V2 Service\", \"name\": \"manilav2\"}'),('228e348e9bc3492bbcd8ea1c517ec8e1','object-store',1,'{\"name\": \"swift\", \"description\": \"OpenStack Object Storage\"}'),('3b8c8f900c0e4f4e9e3048992645474d','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('3e0e62e5936a4e58b78ccfade4e11f6c','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('4b1e9890ec364114afeadd111948a859','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('6cd5942d99724fb7830d05c312d6ff27','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('7042bd28e78d483cb8e676e941780c15','share',1,'{\"description\": \"Manila V1 Service\", \"name\": \"manila\"}'),('b2589c8af3c341dda093ae61cfb9acbe','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('bb59b9adb75b4efeba17566aeb24f1c1','identity',1,'{\"name\": \"keystone\"}'),('bc0fa7aa6ad446d3a3ecaeea64120b1c','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','3c965705ef9f4f29b279dd463fa4cd3e','system','e2e464fed49a4288b45e064e4d67dec3',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_user_id` (`user_id`),
  KEY `ix_token_trust_id` (`trust_id`),
  KEY `ix_token_expires` (`expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
INSERT INTO `trust_role` (`trust_id`, `role_id`) VALUES ('10a6747790aa4a788d5879f5ec690fb6','46c90a8f44804ec0a9b3dda8f815153e'),('48adfab5e6f74669967dea73d9444336','f697b9f2db36416985c59df1edb18259'),('955bdd10bea4411584f1140302569f0c','3f94e46b3e53432c93d1d3848ff856ba'),('ecb2ba302c5d4d13a76388b27be0ce68','56bc6de5fff64566a0a09a77efcd829a'),('ff526274bb0d45bab256effae382f209','937b0fdeba65421cb86f21d240aec5fc');
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('11044767c16d4dec9f8daec1923058a4','{}',1,'c82e2e65a98541158f389f0d87d2945f','2026-02-28 09:21:56','2026-02-28','default'),('1d9013252fae4332b0e73688f5e4136d','{}',1,'c82e2e65a98541158f389f0d87d2945f','2026-02-28 09:21:52','2026-02-28','default'),('2d3d96bfdd92494b8060dbccec7c980b','{}',1,'c82e2e65a98541158f389f0d87d2945f','2026-02-28 09:21:54','2026-02-28','default'),('3c965705ef9f4f29b279dd463fa4cd3e','{}',1,NULL,'2026-02-28 09:20:40','2026-02-28','default'),('4e3f86f8bfcc4998b82b29de47087e65','{}',1,'c82e2e65a98541158f389f0d87d2945f','2026-02-28 09:21:58',NULL,'default'),('4eea6738cacb4e0eac4facaba05c81fb','{}',1,'c82e2e65a98541158f389f0d87d2945f','2026-02-28 09:21:50','2026-02-28','default'),('aa2554a8e81c45cdacf7319e60ea5d5d','{}',1,'c82e2e65a98541158f389f0d87d2945f','2026-02-28 09:51:40','2026-02-28','default'),('b84ee62ae1124ca1a48ce0c9ca09411f','{}',1,'c82e2e65a98541158f389f0d87d2945f','2026-02-28 09:35:28',NULL,'default'),('df8d53b73fd149b2bbf4282ae6f3ca67','{}',1,'c82e2e65a98541158f389f0d87d2945f','2026-02-28 09:22:14','2026-02-28','default'),('eac0b5da4a2d42e0a760d6171cb7af80','{}',1,'c82e2e65a98541158f389f0d87d2945f','2026-02-28 09:22:01','2026-02-28','default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `manila`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `manila` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `manila`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('aebe2a413e13');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `async_operation_data`
--

DROP TABLE IF EXISTS `async_operation_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `async_operation_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `async_operation_data`
--

LOCK TABLES `async_operation_data` WRITE;
/*!40000 ALTER TABLE `async_operation_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `async_operation_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `availability_zones`
--

DROP TABLE IF EXISTS `availability_zones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `availability_zones` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `az_name_uc` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `availability_zones`
--

LOCK TABLES `availability_zones` WRITE;
/*!40000 ALTER TABLE `availability_zones` DISABLE KEYS */;
INSERT INTO `availability_zones` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`) VALUES ('2026-02-28 09:51:42.411491',NULL,NULL,'False','8b94c0af-f9ee-4af2-b1b2-4e178d1712c1','nova');
/*!40000 ALTER TABLE `availability_zones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backend_info`
--

DROP TABLE IF EXISTS `backend_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backend_info` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `host` varchar(255) NOT NULL,
  `info_hash` varchar(255) NOT NULL,
  PRIMARY KEY (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backend_info`
--

LOCK TABLES `backend_info` WRITE;
/*!40000 ALTER TABLE `backend_info` DISABLE KEYS */;
INSERT INTO `backend_info` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `host`, `info_hash`) VALUES ('2026-02-28 09:51:49.246895',NULL,NULL,0,'hostgroup@cephfs','e66c0dfc0d422efa26af62f5a81dd60603e2d39a');
/*!40000 ALTER TABLE `backend_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `drivers_private_data`
--

DROP TABLE IF EXISTS `drivers_private_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `drivers_private_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `drivers_private_data`
--

LOCK TABLES `drivers_private_data` WRITE;
/*!40000 ALTER TABLE `drivers_private_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `drivers_private_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_id` varchar(36) DEFAULT NULL,
  `action_id` varchar(10) NOT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `network_allocations`
--

DROP TABLE IF EXISTS `network_allocations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `network_allocations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ip_address` varchar(64) DEFAULT NULL,
  `mac_address` varchar(32) DEFAULT NULL,
  `share_server_id` varchar(36) NOT NULL,
  `label` varchar(255) DEFAULT 'user',
  `network_type` varchar(32) DEFAULT NULL,
  `segmentation_id` int(11) DEFAULT NULL,
  `ip_version` int(11) DEFAULT NULL,
  `cidr` varchar(64) DEFAULT NULL,
  `gateway` varchar(64) DEFAULT NULL,
  `mtu` int(11) DEFAULT NULL,
  `share_network_subnet_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_server_id` (`share_server_id`),
  KEY `fk_network_allocation_subnet_id_share_network_subnets` (`share_network_subnet_id`),
  CONSTRAINT `fk_network_allocation_subnet_id_share_network_subnets` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`),
  CONSTRAINT `network_allocations_ibfk_1` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `network_allocations`
--

LOCK TABLES `network_allocations` WRITE;
/*!40000 ALTER TABLE `network_allocations` DISABLE KEYS */;
/*!40000 ALTER TABLE `network_allocations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_share_type_quotas`
--

DROP TABLE IF EXISTS `project_share_type_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_share_type_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uc_quotas_per_share_types` (`share_type_id`,`resource`,`deleted`,`project_id`),
  CONSTRAINT `share_type_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_share_type_quotas`
--

LOCK TABLES `project_share_type_quotas` WRITE;
/*!40000 ALTER TABLE `project_share_type_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_share_type_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_user_quotas`
--

DROP TABLE IF EXISTS `project_user_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_user_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `resource` varchar(25) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_user_quotas`
--

LOCK TABLES `project_user_quotas` WRITE;
/*!40000 ALTER TABLE `project_user_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_user_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_usages_project_id` (`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `usage_id` (`usage_id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `security_services`
--

DROP TABLE IF EXISTS `security_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `security_services` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `type` varchar(32) NOT NULL,
  `dns_ip` varchar(64) DEFAULT NULL,
  `server` varchar(255) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `user` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `ou` varchar(255) DEFAULT NULL,
  `default_ad_site` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `security_services`
--

LOCK TABLES `security_services` WRITE;
/*!40000 ALTER TABLE `security_services` DISABLE KEYS */;
/*!40000 ALTER TABLE `security_services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  `state` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `service_az_id_fk` (`availability_zone_id`),
  CONSTRAINT `service_az_id_fk` FOREIGN KEY (`availability_zone_id`) REFERENCES `availability_zones` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone_id`, `state`) VALUES ('2026-02-28 09:51:42.413216','2026-02-28 11:18:19.149542',NULL,0,1,'hostgroup','manila-scheduler','manila-scheduler',518,0,'8b94c0af-f9ee-4af2-b1b2-4e178d1712c1','up'),('2026-02-28 09:51:49.165185','2026-02-28 11:18:16.714047',NULL,0,2,'hostgroup@cephfs','manila-share','manila-share',518,0,'8b94c0af-f9ee-4af2-b1b2-4e178d1712c1','up');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_access_map`
--

DROP TABLE IF EXISTS `share_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_access_map` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `share_id` varchar(36) NOT NULL,
  `access_type` varchar(255) DEFAULT NULL,
  `access_to` varchar(255) DEFAULT NULL,
  `access_level` varchar(2) DEFAULT NULL,
  `access_key` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_id` (`share_id`),
  CONSTRAINT `share_access_map_ibfk_1` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_access_map`
--

LOCK TABLES `share_access_map` WRITE;
/*!40000 ALTER TABLE `share_access_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_access_rules_metadata`
--

DROP TABLE IF EXISTS `share_access_rules_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_access_rules_metadata` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `access_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `access_id` (`access_id`),
  CONSTRAINT `share_access_rules_metadata_ibfk_1` FOREIGN KEY (`access_id`) REFERENCES `share_access_map` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_access_rules_metadata`
--

LOCK TABLES `share_access_rules_metadata` WRITE;
/*!40000 ALTER TABLE `share_access_rules_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_access_rules_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_share_type_mappings`
--

DROP TABLE IF EXISTS `share_group_share_type_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_share_type_mappings` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_group_id` varchar(36) DEFAULT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_sgstm_share_group_id` (`share_group_id`),
  KEY `fk_sgstm_share_type_id` (`share_type_id`),
  CONSTRAINT `fk_sgstm_share_group_id` FOREIGN KEY (`share_group_id`) REFERENCES `share_groups` (`id`),
  CONSTRAINT `fk_sgstm_share_type_id` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_share_type_mappings`
--

LOCK TABLES `share_group_share_type_mappings` WRITE;
/*!40000 ALTER TABLE `share_group_share_type_mappings` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_share_type_mappings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_snapshots`
--

DROP TABLE IF EXISTS `share_group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_snapshots` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `share_group_id` varchar(36) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_share_group_snapshots_share_group_id` (`share_group_id`),
  CONSTRAINT `fk_share_group_snapshots_share_group_id` FOREIGN KEY (`share_group_id`) REFERENCES `share_groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_snapshots`
--

LOCK TABLES `share_group_snapshots` WRITE;
/*!40000 ALTER TABLE `share_group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_type_projects`
--

DROP TABLE IF EXISTS `share_group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sgtp_project_id_uc` (`share_group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `sgtp_id_fk` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_type_projects`
--

LOCK TABLES `share_group_type_projects` WRITE;
/*!40000 ALTER TABLE `share_group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_type_share_type_mappings`
--

DROP TABLE IF EXISTS `share_group_type_share_type_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_type_share_type_mappings` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_group_type_id` varchar(36) NOT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sgtp_id_sgt_id_uc` (`share_group_type_id`),
  KEY `sgtp_id_st_id_uc` (`share_type_id`),
  CONSTRAINT `sgtp_id_sgt_id_uc` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`),
  CONSTRAINT `sgtp_id_st_id_uc` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_type_share_type_mappings`
--

LOCK TABLES `share_group_type_share_type_mappings` WRITE;
/*!40000 ALTER TABLE `share_group_type_share_type_mappings` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_type_share_type_mappings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_type_specs`
--

DROP TABLE IF EXISTS `share_group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `spec_key` varchar(255) DEFAULT NULL,
  `spec_value` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sgtp_id_extra_specs_fk` (`share_group_type_id`),
  CONSTRAINT `sgtp_id_extra_specs_fk` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_type_specs`
--

LOCK TABLES `share_group_type_specs` WRITE;
/*!40000 ALTER TABLE `share_group_type_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_types`
--

DROP TABLE IF EXISTS `share_group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_types` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_share_group_type_name` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_types`
--

LOCK TABLES `share_group_types` WRITE;
/*!40000 ALTER TABLE `share_group_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_groups`
--

DROP TABLE IF EXISTS `share_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_groups` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `host` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `source_share_group_snapshot_id` varchar(36) DEFAULT NULL,
  `share_network_id` varchar(36) DEFAULT NULL,
  `share_server_id` varchar(36) DEFAULT NULL,
  `share_group_type_id` varchar(36) DEFAULT NULL,
  `consistent_snapshot_support` enum('pool','host') DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_share_group_share_network_id` (`share_network_id`),
  KEY `fk_share_group_share_server_id` (`share_server_id`),
  KEY `sgt_id_sg_id_uc` (`share_group_type_id`),
  CONSTRAINT `fk_share_group_share_network_id` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`),
  CONSTRAINT `fk_share_group_share_server_id` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`),
  CONSTRAINT `sgt_id_sg_id_uc` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_groups`
--

LOCK TABLES `share_groups` WRITE;
/*!40000 ALTER TABLE `share_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instance_access_map`
--

DROP TABLE IF EXISTS `share_instance_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instance_access_map` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `share_instance_id` varchar(36) DEFAULT NULL,
  `access_id` varchar(36) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `siam_instance_fk` (`share_instance_id`),
  KEY `siam_access_fk` (`access_id`),
  CONSTRAINT `siam_access_fk` FOREIGN KEY (`access_id`) REFERENCES `share_access_map` (`id`),
  CONSTRAINT `siam_instance_fk` FOREIGN KEY (`share_instance_id`) REFERENCES `share_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instance_access_map`
--

LOCK TABLES `share_instance_access_map` WRITE;
/*!40000 ALTER TABLE `share_instance_access_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_instance_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instance_export_locations`
--

DROP TABLE IF EXISTS `share_instance_export_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instance_export_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `path` varchar(2000) DEFAULT NULL,
  `share_instance_id` varchar(36) DEFAULT NULL,
  `is_admin_only` tinyint(1) DEFAULT NULL,
  `uuid` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `sel_instance_id_fk` (`share_instance_id`),
  CONSTRAINT `sel_instance_id_fk` FOREIGN KEY (`share_instance_id`) REFERENCES `share_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instance_export_locations`
--

LOCK TABLES `share_instance_export_locations` WRITE;
/*!40000 ALTER TABLE `share_instance_export_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_instance_export_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instance_export_locations_metadata`
--

DROP TABLE IF EXISTS `share_instance_export_locations_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instance_export_locations_metadata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `export_location_id` int(11) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `elm_el_id_uc` (`export_location_id`,`key`,`deleted`),
  CONSTRAINT `elm_id_fk` FOREIGN KEY (`export_location_id`) REFERENCES `share_instance_export_locations` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instance_export_locations_metadata`
--

LOCK TABLES `share_instance_export_locations_metadata` WRITE;
/*!40000 ALTER TABLE `share_instance_export_locations_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_instance_export_locations_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instances`
--

DROP TABLE IF EXISTS `share_instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instances` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `share_id` varchar(36) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `share_network_id` varchar(36) DEFAULT NULL,
  `share_server_id` varchar(36) DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  `access_rules_status` varchar(255) DEFAULT NULL,
  `replica_state` varchar(255) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  `cast_rules_to_readonly` tinyint(1) NOT NULL,
  `progress` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `si_share_network_fk` (`share_network_id`),
  KEY `si_share_server_fk` (`share_server_id`),
  KEY `si_az_id_fk` (`availability_zone_id`),
  KEY `si_st_id_fk` (`share_type_id`),
  KEY `share_instances_share_id_idx` (`share_id`),
  CONSTRAINT `si_az_id_fk` FOREIGN KEY (`availability_zone_id`) REFERENCES `availability_zones` (`id`),
  CONSTRAINT `si_share_fk` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`),
  CONSTRAINT `si_share_network_fk` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`),
  CONSTRAINT `si_share_server_fk` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`),
  CONSTRAINT `si_st_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instances`
--

LOCK TABLES `share_instances` WRITE;
/*!40000 ALTER TABLE `share_instances` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_instances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_metadata`
--

DROP TABLE IF EXISTS `share_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_metadata` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `share_id` (`share_id`),
  CONSTRAINT `share_metadata_ibfk_1` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_metadata`
--

LOCK TABLES `share_metadata` WRITE;
/*!40000 ALTER TABLE `share_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_network_security_service_association`
--

DROP TABLE IF EXISTS `share_network_security_service_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_network_security_service_association` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_network_id` varchar(36) NOT NULL,
  `security_service_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `share_network_id` (`share_network_id`),
  KEY `security_service_id` (`security_service_id`),
  CONSTRAINT `share_network_security_service_association_ibfk_1` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`),
  CONSTRAINT `share_network_security_service_association_ibfk_2` FOREIGN KEY (`security_service_id`) REFERENCES `security_services` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_network_security_service_association`
--

LOCK TABLES `share_network_security_service_association` WRITE;
/*!40000 ALTER TABLE `share_network_security_service_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_network_security_service_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_network_subnet_metadata`
--

DROP TABLE IF EXISTS `share_network_subnet_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_network_subnet_metadata` (
  `deleted` varchar(36) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_network_subnet_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `share_network_subnet_id` (`share_network_subnet_id`),
  CONSTRAINT `share_network_subnet_metadata_ibfk_1` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_network_subnet_metadata`
--

LOCK TABLES `share_network_subnet_metadata` WRITE;
/*!40000 ALTER TABLE `share_network_subnet_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_network_subnet_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_network_subnets`
--

DROP TABLE IF EXISTS `share_network_subnets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_network_subnets` (
  `id` varchar(36) NOT NULL,
  `neutron_net_id` varchar(36) DEFAULT NULL,
  `neutron_subnet_id` varchar(36) DEFAULT NULL,
  `network_type` varchar(32) DEFAULT NULL,
  `cidr` varchar(64) DEFAULT NULL,
  `segmentation_id` int(11) DEFAULT NULL,
  `gateway` varchar(64) DEFAULT NULL,
  `mtu` int(11) DEFAULT NULL,
  `share_network_id` varchar(36) DEFAULT NULL,
  `ip_version` int(11) DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_share_network_subnets_share_network_id_share_networks` (`share_network_id`),
  KEY `fk_share_network_subnets_availaility_zone_id_availability_zones` (`availability_zone_id`),
  CONSTRAINT `fk_share_network_subnets_availaility_zone_id_availability_zones` FOREIGN KEY (`availability_zone_id`) REFERENCES `availability_zones` (`id`),
  CONSTRAINT `fk_share_network_subnets_share_network_id_share_networks` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_network_subnets`
--

LOCK TABLES `share_network_subnets` WRITE;
/*!40000 ALTER TABLE `share_network_subnets` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_network_subnets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_networks`
--

DROP TABLE IF EXISTS `share_networks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_networks` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(36) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_networks`
--

LOCK TABLES `share_networks` WRITE;
/*!40000 ALTER TABLE `share_networks` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_networks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_server_backend_details`
--

DROP TABLE IF EXISTS `share_server_backend_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_server_backend_details` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_server_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `share_server_id` (`share_server_id`),
  CONSTRAINT `share_server_backend_details_ibfk_1` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_server_backend_details`
--

LOCK TABLES `share_server_backend_details` WRITE;
/*!40000 ALTER TABLE `share_server_backend_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_server_backend_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_server_share_network_subnet_mappings`
--

DROP TABLE IF EXISTS `share_server_share_network_subnet_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_server_share_network_subnet_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_server_id` varchar(36) NOT NULL,
  `share_network_subnet_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_ss_sns_m_share_server_id_share_servers` (`share_server_id`),
  KEY `fk_ss_sns_m_share_network_subnet_id_share_network_subnets` (`share_network_subnet_id`),
  CONSTRAINT `fk_ss_sns_m_share_network_subnet_id_share_network_subnets` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`),
  CONSTRAINT `fk_ss_sns_m_share_server_id_share_servers` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_server_share_network_subnet_mappings`
--

LOCK TABLES `share_server_share_network_subnet_mappings` WRITE;
/*!40000 ALTER TABLE `share_server_share_network_subnet_mappings` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_server_share_network_subnet_mappings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_servers`
--

DROP TABLE IF EXISTS `share_servers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_servers` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `host` varchar(255) DEFAULT NULL,
  `status` varchar(32) DEFAULT NULL,
  `is_auto_deletable` tinyint(1) DEFAULT NULL,
  `identifier` varchar(255) DEFAULT NULL,
  `task_state` varchar(255) DEFAULT NULL,
  `source_share_server_id` varchar(36) DEFAULT NULL,
  `security_service_update_support` tinyint(1) NOT NULL DEFAULT 0,
  `network_allocation_update_support` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `fk_share_servers_source_share_server_id` (`source_share_server_id`),
  CONSTRAINT `fk_share_servers_source_share_server_id` FOREIGN KEY (`source_share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_servers`
--

LOCK TABLES `share_servers` WRITE;
/*!40000 ALTER TABLE `share_servers` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_servers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_access_map`
--

DROP TABLE IF EXISTS `share_snapshot_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_access_map` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_snapshot_id` varchar(36) DEFAULT NULL,
  `access_type` varchar(255) DEFAULT NULL,
  `access_to` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ssam_snapshot_fk` (`share_snapshot_id`),
  CONSTRAINT `ssam_snapshot_fk` FOREIGN KEY (`share_snapshot_id`) REFERENCES `share_snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_access_map`
--

LOCK TABLES `share_snapshot_access_map` WRITE;
/*!40000 ALTER TABLE `share_snapshot_access_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_instance_access_map`
--

DROP TABLE IF EXISTS `share_snapshot_instance_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_instance_access_map` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_snapshot_instance_id` varchar(36) DEFAULT NULL,
  `access_id` varchar(36) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ssiam_snapshot_instance_fk` (`share_snapshot_instance_id`),
  KEY `ssam_access_fk` (`access_id`),
  CONSTRAINT `ssam_access_fk` FOREIGN KEY (`access_id`) REFERENCES `share_snapshot_access_map` (`id`),
  CONSTRAINT `ssiam_snapshot_instance_fk` FOREIGN KEY (`share_snapshot_instance_id`) REFERENCES `share_snapshot_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_instance_access_map`
--

LOCK TABLES `share_snapshot_instance_access_map` WRITE;
/*!40000 ALTER TABLE `share_snapshot_instance_access_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_instance_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_instance_export_locations`
--

DROP TABLE IF EXISTS `share_snapshot_instance_export_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_instance_export_locations` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_snapshot_instance_id` varchar(36) DEFAULT NULL,
  `path` varchar(2000) DEFAULT NULL,
  `is_admin_only` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ssiel_snapshot_instance_fk` (`share_snapshot_instance_id`),
  CONSTRAINT `ssiel_snapshot_instance_fk` FOREIGN KEY (`share_snapshot_instance_id`) REFERENCES `share_snapshot_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_instance_export_locations`
--

LOCK TABLES `share_snapshot_instance_export_locations` WRITE;
/*!40000 ALTER TABLE `share_snapshot_instance_export_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_instance_export_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_instances`
--

DROP TABLE IF EXISTS `share_snapshot_instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_instances` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `share_instance_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `share_proto` varchar(255) DEFAULT NULL,
  `share_group_snapshot_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ssi_snapshot_fk` (`snapshot_id`),
  KEY `ssi_share_instance_fk` (`share_instance_id`),
  CONSTRAINT `ssi_share_instance_fk` FOREIGN KEY (`share_instance_id`) REFERENCES `share_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_instances`
--

LOCK TABLES `share_snapshot_instances` WRITE;
/*!40000 ALTER TABLE `share_snapshot_instances` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_instances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_metadata`
--

DROP TABLE IF EXISTS `share_snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_metadata` (
  `deleted` varchar(36) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `share_snapshot_id` (`share_snapshot_id`),
  CONSTRAINT `share_snapshot_metadata_ibfk_1` FOREIGN KEY (`share_snapshot_id`) REFERENCES `share_snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_metadata`
--

LOCK TABLES `share_snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `share_snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshots`
--

DROP TABLE IF EXISTS `share_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshots` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `share_id` varchar(36) NOT NULL,
  `size` int(11) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `share_size` int(11) DEFAULT NULL,
  `share_proto` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_id` (`share_id`),
  CONSTRAINT `share_snapshots_ibfk_1` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshots`
--

LOCK TABLES `share_snapshots` WRITE;
/*!40000 ALTER TABLE `share_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_type_extra_specs`
--

DROP TABLE IF EXISTS `share_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_type_extra_specs` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_type_id` varchar(36) NOT NULL,
  `spec_key` varchar(255) DEFAULT NULL,
  `spec_value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `st_id_fk` (`share_type_id`),
  CONSTRAINT `st_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_type_extra_specs`
--

LOCK TABLES `share_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `share_type_extra_specs` DISABLE KEYS */;
INSERT INTO `share_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_type_id`, `spec_key`, `spec_value`) VALUES ('2026-02-28 09:53:04.374622',NULL,NULL,0,1,'bb295069-6250-477e-9163-8a68aaedea41','driver_handles_share_servers','False'),('2026-02-28 09:53:08.501116',NULL,NULL,0,2,'bb295069-6250-477e-9163-8a68aaedea41','snapshot_support','True'),('2026-02-28 09:53:08.514185',NULL,NULL,0,3,'bb295069-6250-477e-9163-8a68aaedea41','create_share_from_snapshot_support','True');
/*!40000 ALTER TABLE `share_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_type_projects`
--

DROP TABLE IF EXISTS `share_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `stp_project_id_uc` (`share_type_id`,`project_id`,`deleted`),
  CONSTRAINT `stp_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_type_projects`
--

LOCK TABLES `share_type_projects` WRITE;
/*!40000 ALTER TABLE `share_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_types`
--

DROP TABLE IF EXISTS `share_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_types` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `st_name_uc` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_types`
--

LOCK TABLES `share_types` WRITE;
/*!40000 ALTER TABLE `share_types` DISABLE KEYS */;
INSERT INTO `share_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `is_public`, `description`) VALUES ('2026-02-28 09:53:04.372835',NULL,NULL,'False','bb295069-6250-477e-9163-8a68aaedea41','default',1,NULL);
/*!40000 ALTER TABLE `share_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shares`
--

DROP TABLE IF EXISTS `shares`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shares` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `share_proto` varchar(255) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `snapshot_support` tinyint(1) DEFAULT NULL,
  `share_group_id` varchar(36) DEFAULT NULL,
  `source_share_group_snapshot_member_id` varchar(36) DEFAULT NULL,
  `task_state` varchar(255) DEFAULT NULL,
  `replication_type` varchar(255) DEFAULT NULL,
  `create_share_from_snapshot_support` tinyint(1) DEFAULT NULL,
  `revert_to_snapshot_support` tinyint(1) DEFAULT NULL,
  `mount_snapshot_support` tinyint(1) DEFAULT NULL,
  `is_soft_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `scheduled_to_be_deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_shares_share_group_id` (`share_group_id`),
  CONSTRAINT `fk_shares_share_group_id` FOREIGN KEY (`share_group_id`) REFERENCES `share_groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shares`
--

LOCK TABLES `shares` WRITE;
/*!40000 ALTER TABLE `shares` DISABLE KEYS */;
/*!40000 ALTER TABLE `shares` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `resource_id` varchar(36) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime(6) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','glance','glance_4d7d','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_4d7d','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','keystone','keystone_56c8','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_56c8','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','placement','placement_df7d','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_df7d','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_5882','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_5882','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_247f','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_aabe','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_aabe','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_247f','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_815f','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_815f','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_3a07','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_3a07','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','manila','manila_3817','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','manila','manila_3817','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1772270391}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1772270391}'),('localhost','glance_4d7d','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B9C614833BF5229458C5C8022802807FAB8732D1\",\"password_last_changed\":1772270385}'),('%','glance_4d7d','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B9C614833BF5229458C5C8022802807FAB8732D1\",\"password_last_changed\":1772270385}'),('localhost','keystone_56c8','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*DEC8844B41F00B3E539DE59F64808A5480458B4A\",\"password_last_changed\":1772270385}'),('%','keystone_56c8','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*DEC8844B41F00B3E539DE59F64808A5480458B4A\",\"password_last_changed\":1772270385}'),('localhost','placement_df7d','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D4018BFEE73163E9141C0C106BDCFD898F61C84D\",\"password_last_changed\":1772270386}'),('%','placement_df7d','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D4018BFEE73163E9141C0C106BDCFD898F61C84D\",\"password_last_changed\":1772270386}'),('localhost','cinder_5882','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*DF19070C08680563FD8DBBC29ED1FE262572E59C\",\"password_last_changed\":1772270423}'),('%','cinder_5882','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*DF19070C08680563FD8DBBC29ED1FE262572E59C\",\"password_last_changed\":1772270423}'),('localhost','neutron_aabe','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*1EBE4CF24E1849D5ABB9B2F306E40EE6D432A83D\",\"password_last_changed\":1772270424}'),('localhost','barbican_247f','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*28C799CABB0E1CD314EA147858A5DB1804E51FAA\",\"password_last_changed\":1772270424}'),('%','neutron_aabe','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*1EBE4CF24E1849D5ABB9B2F306E40EE6D432A83D\",\"password_last_changed\":1772270424}'),('%','barbican_247f','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*28C799CABB0E1CD314EA147858A5DB1804E51FAA\",\"password_last_changed\":1772270424}'),('localhost','nova_api_815f','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*709B2CE2C31A757A33BB445E0F95F52414272FB6\",\"password_last_changed\":1772270523}'),('%','nova_api_815f','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*709B2CE2C31A757A33BB445E0F95F52414272FB6\",\"password_last_changed\":1772270523}'),('localhost','nova_cell0_3a07','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*3AEEE66A75FF114A50A99240A0D1E64B055DE043\",\"password_last_changed\":1772270524}'),('%','nova_cell0_3a07','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*3AEEE66A75FF114A50A99240A0D1E64B055DE043\",\"password_last_changed\":1772270524}'),('localhost','manila_3817','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*FC1345AC34A5536412200FB6DF350D51B3E055E6\",\"password_last_changed\":1772272275}'),('%','manila_3817','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*FC1345AC34A5536412200FB6DF350D51B3E055E6\",\"password_last_changed\":1772272275}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mysql_plugin\n-------------------------------------\n\nA plugin can be installed with the mysql_plugin utility if the server is\ncompletely offline.\n\nThe syntax is:\n\nmysql_plugin [options] <plugin> ENABLE|DISABLE\n\nFor example, to install the server_audit audit plugin, you could execute the\nfollowing:\n\nmysql_plugin server_audit ENABLE\n\nIf a plugin is installed with this utility, then a record will be added to the\nmysql.plugins table for the plugin. This means that the plugin will\nautomatically be loaded every time the server restarts, unless specifically\nuninstalled or deactivated.\n\nConfiguring the Plugin Directory\n--------------------------------\n\nWhen a plugin is being installed, the server looks for the plugin\'s library in\nthe server\'s plugin directory. This directory is configured by the plugin_dir\nsystem variable. This can be specified as a command-line argument to mysqld or\nit can be specified in a relevant server option group in an option file. For\nexample:\n\n[mariadb]\n...\nplugin_dir = /usr/lib64/mysql/plugin\n\nConfiguring the Minimum Plugin Maturity\n---------------------------------------\n\nWhen a plugin is being installed, the server compares the plugin\'s maturity\nlevel against the server\'s minimum allowed plugin maturity. This can help\nprevent users from using unstable plugins on production servers. This minimum\nplugin maturity is configured by the plugin_maturity system variable. This can\nbe specified as a command-line argument to mysqld or it can be specified in a\nrelevant server option group in an option file. For example:\n\n[mariadb]\n...\nplugin_maturity = stable\n\nConfiguring Plugin Activation at Server Startup\n-----------------------------------------------\n\nA plugin will be loaded by default when the server starts if:\n\n* The plugin was installed with the INSTALL SONAME statement.\n* The plugin was installed with the INSTALL PLUGIN statement.\n* The plugin was installed with the mysql_plugin utility.\n* The server is configured to load the plugin with the --plugin-load-add\noption.\n* The server is configured to load the plugin with the --plugin-load option.\n\nThis behavior can be changed with special options that take the form\n--plugin-name. For example, for the server_audit audit plugin, the special\noption is called --server-audit.\n\nThe possible values for these special options are:\n\n+---------------------------------------+------------------------------------+\n| Option Value                          | Description                        |\n+---------------------------------------+------------------------------------+\n| OFF                                   | Disables the plugin without        |\n|                                       | removing it from the               |\n|                                       | mysql.plugins table.               |\n+---------------------------------------+------------------------------------+\n| ON                                    | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will still continue         |\n|                                       | starting up, but the plugin will   |\n|                                       | be disabled.                       |\n+---------------------------------------+------------------------------------+\n| FORCE                                 | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error.                             |\n+---------------------------------------+------------------------------------+\n| FORCE_PLUS_PERMANENT                  | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error. In addition, the plugin     |\n|                                       | cannot be uninstalled with         |\n|                                       | UNINSTALL SONAME or UNINSTALL      |\n|                                       | PLUGIN while the server is         |\n|                                       | running.                           |\n+---------------------------------------+------------------------------------+\n\nA plugin\'s status can be found by looking at the PLUGIN_STATUS column of the\ninformation_schema.PLUGINS table.\n\nUninstalling Plugins\n--------------------\n\nPlugins that are found in the mysql.plugin table, that is those that were\ninstalled with INSTALL SONAME, INSTALL PLUGIN or mysql_plugin can be\nuninstalled in one of two ways:\n\n* The UNINSTALL SONAME or the UNINSTALL PLUGIN statement while the server is\nrunning\n* With mysql_plugin while the server is offline.\n\nPlugins that were enabled as a --plugin-load option do not need to be\nuninstalled. If --plugin-load is omitted the next time the server starts, or\nthe plugin is not listed as one of the --plugin-load entries, the plugin will\nnot be loaded.\n\nUNINSTALL PLUGIN uninstalls a single installed plugin, while UNINSTALL SONAME\nuninstalls all plugins belonging to a given library.\n\nURL: https://mariadb.com/kb/en/plugin-overview/','','https://mariadb.com/kb/en/plugin-overview/'),(79,'MBR Definition',6,'Description\n-----------\n\nThe MBR (Minimum Bounding Rectangle), or Envelope is the bounding geometry,\nformed by the minimum and maximum (X,Y) coordinates:\n\nExamples\n--------\n\n((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nURL: https://mariadb.com/kb/en/mbr-definition/','','https://mariadb.com/kb/en/mbr-definition/'),(80,'MBRContains',6,'Syntax\n------\n\nMBRContains(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\ncontains the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\n\nSET @g2 = GeomFromText(\'Point(1 1)\');\n\nSELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n+----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrcontains/','','https://mariadb.com/kb/en/mbrcontains/'),(82,'MBREqual',6,'Syntax\n------\n\nMBREqual(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are the same.\n\nExamples\n--------\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 2)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 2, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 3)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 4, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 0 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/mbrequal/','','https://mariadb.com/kb/en/mbrequal/'),(86,'MBRWithin',6,'Syntax\n------\n\nMBRWithin(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1 is\nwithin the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRContains().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nSELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n\nURL: https://mariadb.com/kb/en/mbrwithin/','','https://mariadb.com/kb/en/mbrwithin/'),(75,'UNINSTALL PLUGIN',5,'Syntax\n------\n\nUNINSTALL PLUGIN [IF EXISTS] plugin_name\n\nDescription\n-----------\n\nThis statement removes a single installed plugin. To uninstall the whole\nlibrary which contains the plugin, use UNINSTALL SONAME. You cannot uninstall\na plugin if any table that uses it is open.\n\nplugin_name must be the name of some plugin that is listed in the mysql.plugin\ntable. The server executes the plugin\'s deinitialization function and removes\nthe row for the plugin from the mysql.plugin table, so that subsequent server\nrestarts will not load and initialize the plugin. UNINSTALL PLUGIN does not\nremove the plugin\'s shared library file.\n\nTo use UNINSTALL PLUGIN, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nUNINSTALL PLUGIN example;\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------+\n| Level | Code | Message                       |\n+-------+------+-------------------------------+\n| Note  | 1305 | PLUGIN example does not exist |\n+-------+------+-------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-plugin/','','https://mariadb.com/kb/en/uninstall-plugin/'),(76,'INSTALL SONAME',5,'Syntax\n------\n\nINSTALL SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of INSTALL PLUGIN. It installs all plugins from a\ngiven plugin_library. See INSTALL PLUGIN for details.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL SONAME adds one or more lines to the mysql.plugin table that describes\nthe plugin. This table contains the plugin name and library file name.\n\nINSTALL SONAME causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL SONAME also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL SONAME, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nSONAME only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nIf you need to install only one plugin from a library, use the INSTALL PLUGIN\nstatement.\n\nExamples\n--------\n\nTo load the XtraDB storage engine and all of its information_schema tables\nwith one statement, use\n\nINSTALL SONAME \'ha_xtradb\';\n\nThis statement can be used instead of INSTALL PLUGIN even when the library\ncontains only one plugin:\n\nINSTALL SONAME \'ha_sequence\';\n\nURL: https://mariadb.com/kb/en/install-soname/','','https://mariadb.com/kb/en/install-soname/'),(77,'UNINSTALL SONAME',5,'Syntax\n------\n\nUNINSTALL SONAME  [IF EXISTS] \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of UNINSTALL PLUGIN statement, that removes all\nplugins belonging to a specified plugin_library. See UNINSTALL PLUGIN for\ndetails.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nTo use UNINSTALL SONAME, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin library does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nTo uninstall the XtraDB plugin and all of its information_schema tables with\none statement, use\n\nUNINSTALL SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------------+\n| Level | Code | Message                             |\n+-------+------+-------------------------------------+\n| Note  | 1305 | SONAME ha_example.so does not exist |\n+-------+------+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-soname/','','https://mariadb.com/kb/en/uninstall-soname/'),(90,'NULLIF',7,'Syntax\n------\n\nNULLIF(expr1,expr2)\n\nDescription\n-----------\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is the\nsame as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nExamples\n--------\n\nSELECT NULLIF(1,1);\n+-------------+\n| NULLIF(1,1) |\n+-------------+\n|        NULL |\n+-------------+\n\nSELECT NULLIF(1,2);\n+-------------+\n| NULLIF(1,2) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/nullif/','','https://mariadb.com/kb/en/nullif/'),(91,'NVL',7,'MariaDB starting with 10.3\n--------------------------\nFrom MariaDB 10.3, NVL is a synonym for IFNULL.\n\nURL: https://mariadb.com/kb/en/nvl/','','https://mariadb.com/kb/en/nvl/'),(92,'NVL2',7,'MariaDB starting with 10.3\n--------------------------\nThe NLV2 function was introduced in MariaDB 10.3.0.\n\nSyntax\n------\n\nNVL2(expr1,expr2,expr3)\n\nDescription\n-----------\n\nThe NVL2 function returns a value based on whether a specified expression is\nNULL or not. If expr1 is not NULL, then NVL2 returns expr2. If expr1 is NULL,\nthen NVL2 returns expr3.\n\nExamples\n--------\n\nSELECT NVL2(NULL,1,2);\n+----------------+\n| NVL2(NULL,1,2) |\n+----------------+\n|              2 |\n+----------------+\n\nSELECT NVL2(\'x\',1,2);\n+---------------+\n| NVL2(\'x\',1,2) |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/nvl2/','','https://mariadb.com/kb/en/nvl2/'),(81,'MBRDisjoint',6,'Syntax\n------\n\nMBRDisjoint(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are disjoint. Two geometries are disjoint if they do not\nintersect, that is touch or overlap.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECTmbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrdisjoint/','','https://mariadb.com/kb/en/mbrdisjoint/'),(83,'MBRIntersects',6,'Syntax\n------\n\nMBRIntersects(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 intersect.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      1 |\n+------------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      0 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/mbrintersects/','','https://mariadb.com/kb/en/mbrintersects/'),(84,'MBROverlaps',6,'Syntax\n------\n\nMBROverlaps(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 overlap. The term spatially overlaps is used if two\ngeometries intersect and their intersection results in a geometry of the same\ndimension but not equal to either of the given geometries.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbroverlaps/','','https://mariadb.com/kb/en/mbroverlaps/'),(85,'MBRTouches',6,'Syntax\n------\n\nMBRTouches(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 touch. Two geometries spatially touch if the interiors of\nthe geometries do not intersect, but the boundary of one of the geometries\nintersects either the boundary or the interior of the other.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   1 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/mbrtouches/','','https://mariadb.com/kb/en/mbrtouches/'),(87,'CASE OPERATOR',7,'Syntax\n------\n\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nDescription\n-----------\n\nThe first version returns the result where value=compare_value. The second\nversion returns the result for the first condition that is true. If there was\nno matching result value, the result after ELSE is returned, or NULL if there\nis no ELSE part.\n\nThere is also a CASE statement, which differs from the CASE operator described\nhere.\n\nExamples\n--------\n\nSELECT CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END;\n+------------------------------------------------------------+\n| CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END |\n+------------------------------------------------------------+\n| one                                                        |\n+------------------------------------------------------------+\n\nSELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n+--------------------------------------------+\n| CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END |\n+--------------------------------------------+\n| true                                       |\n+--------------------------------------------+\n\nSELECT CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n+-----------------------------------------------------+\n| CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END |\n+-----------------------------------------------------+\n|                                                NULL |\n+-----------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/case-operator/','','https://mariadb.com/kb/en/case-operator/'),(101,'UNLOCK TABLES',8,'Syntax\n------\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\nSee LOCK TABLES for more information.\n\nIn addition to releasing table locks acquired by the LOCK TABLES statement,\nthe UNLOCK TABLES statement also releases the global read lock acquired by the\nFLUSH TABLES WITH READ LOCK statement. The FLUSH TABLES WITH READ LOCK\nstatement is very useful for performing backups. See FLUSH for more\ninformation about FLUSH TABLES WITH READ LOCK.\n\nURL: https://mariadb.com/kb/en/transactions-unlock-tables/','','https://mariadb.com/kb/en/transactions-unlock-tables/'),(103,'XA Transactions',8,'Overview\n--------\n\nThe MariaDB XA implementation is based on the X/Open CAE document Distributed\nTransaction Processing: The XA Specification. This document is published by\nThe Open Group and available at\nhttp://www.opengroup.org/public/pubs/catalog/c193.htm.\n\nXA transactions are designed to allow distributed transactions, where a\ntransaction manager (the application) controls a transaction which involves\nmultiple resources. Such resources are usually DBMSs, but could be resources\nof any type. The whole set of required transactional operations is called a\nglobal transaction. Each subset of operations which involve a single resource\nis called a local transaction. XA used a 2-phases commit (2PC). With the first\ncommit, the transaction manager tells each resource to prepare an effective\ncommit, and waits for a confirm message. The changes are not still made\neffective at this point. If any of the resources encountered an error, the\ntransaction manager will rollback the global transaction. If all resources\ncommunicate that the first commit is successful, the transaction manager can\nrequire a second commit, which makes the changes effective.\n\nIn MariaDB, XA transactions can only be used with storage engines that support\nthem. At least InnoDB, TokuDB, SPIDER and MyRocks support them. For InnoDB,\nuntil MariaDB 10.2, XA transactions can be disabled by setting the\ninnodb_support_xa server system variable to 0. From MariaDB 10.3, XA\ntransactions are always supported.\n\nLike regular transactions, XA transactions create metadata locks on accessed\ntables.\n\nXA transactions require REPEATABLE READ as a minimum isolation level. However,\ndistributed transactions should always use SERIALIZABLE.\n\nTrying to start more than one XA transaction at the same time produces a 1400\nerror (SQLSTATE \'XAE09\'). The same error is produced when attempting to start\nan XA transaction while a regular transaction is in effect. Trying to start a\nregular transaction while an XA transaction is in effect produces a 1399 error\n(SQLSTATE \'XAE07\').\n\nThe statements that cause an implicit COMMIT for regular transactions produce\na 1400 error (SQLSTATE \'XAE09\') if a XA transaction is in effect.\n\nInternal XA vs External XA\n--------------------------\n\nXA transactions are an overloaded term in MariaDB. If a storage engine is\nXA-capable, it can mean one or both of these:\n\n* It supports MariaDB\'s internal two-phase commit API. This is transparent to\nthe user. Sometimes this is called \"internal XA\", since MariaDB\'s internal\ntransaction coordinator log can handle coordinating these transactions.\n\n* It supports XA transactions, with the XA START, XA PREPARE, XA COMMIT, etc.\nstatements. Sometimes this is called \"external XA\", since it requires the use\nof an external transaction coordinator to use this feature properly.\n\nTransaction Coordinator Log\n---------------------------\n\nIf you have two or more XA-capable storage engines enabled, then a transaction\ncoordinator log must be available.\n\nThere are currently two implementations of the transaction coordinator log:\n\n* Binary log-based transaction coordinator log\n* Memory-mapped file-based transaction coordinator log\n\nIf the binary log is enabled on a server, then the server will use the binary\nlog-based transaction coordinator log. Otherwise, it will use the\nmemory-mapped file-based transaction coordinator log.\n\nSee Transaction Coordinator Log for more information.\n\nSyntax\n------\n\nXA {START|BEGIN} xid [JOIN|RESUME]\n\nXA END xid [SUSPEND [FOR MIGRATE]]\n\nXA PREPARE xid\n\nXA COMMIT xid [ONE PHASE]\n\nXA ROLLBACK xid\n\nXA RECOVER [FORMAT=[\'RAW\'|\'SQL\']]\n\nxid: gtrid [, bqual [, formatID ]]\n\nThe interface to XA transactions is a set of SQL statements starting with XA.\nEach statement changes a transaction\'s state, determining which actions it can\nperform. A transaction which does not exist is in the NON-EXISTING state.\n\nXA START (or BEGIN) starts a transaction and defines its xid (a transaction\nidentifier). The JOIN or RESUME keywords have no effect. The new transaction\nwill be in ACTIVE state.\n\nThe xid can have 3 components, though only the first one is mandatory. gtrid\nis a quoted string representing a global transaction identifier. bqual is a\nquoted string representing a local transaction identifier. formatID is an\nunsigned integer indicating the format used for the first two components; if\nnot specified, defaults to 1. MariaDB does not interpret in any way these\ncomponents, and only uses them to identify a transaction. xids of transactions\nin effect must be unique.\n\nXA END declares that the specified ACTIVE transaction is finished and it\nchanges its state to IDLE. SUSPEND [FOR MIGRATE] has no effect.\n\nXA PREPARE prepares an IDLE transaction for commit, changing its state to\nPREPARED. This is the first commit.\n\nXA COMMIT definitely commits and terminates a transaction which has already\nbeen PREPARED. If the ONE PHASE clause is specified, this statements performs\na 1-phase commit on an IDLE transaction.\n\nXA ROLLBACK rolls back and terminates an IDLE or PREPARED transaction.\n\nXA RECOVER shows information about all PREPARED transactions.\n\nWhen trying to execute an operation which is not allowed for the transaction\'s\ncurrent state, an error is produced:\n\nXA COMMIT \'test\' ONE PHASE;\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  ACTIVE state\n\nXA COMMIT \'test2\';\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  NON-EXISTING state\n\nXA RECOVER\n----------\n\nThe XA RECOVER statement shows information about all transactions which are in\nthe PREPARED state. It does not matter which connection created the\ntransaction: if it has been PREPARED, it appears. But this does not mean that\na connection can commit or rollback a transaction which was started by another\nconnection. Note that transactions using a 1-phase commit are never in the\nPREPARED state, so they cannot be shown by XA RECOVER.\n\nXA RECOVER produces four columns:\n\nXA RECOVER;\n+----------+--------------+--------------+------+\n| formatID | gtrid_length | bqual_length | data |\n+----------+--------------+--------------+------+\n|        1 |            4 |            0 | test |\n+----------+--------------+--------------+------+\n\nMariaDB starting with 10.3.3\n----------------------------\nYou can use XA RECOVER FORMAT=\'SQL\' to get the data in a human readable form\nthat can be directly copy-pasted into XA COMMIT or XA ROLLBACK. This is\nparticularly useful for binary xid generated by some transaction coordinators.\n\nformatID is the formatID part of xid.\n\ndata are the gtrid and bqual parts of xid, concatenated.\n\ngtrid_length and bqual_length are the lengths of gtrid and bqual, respectevely.\n\nExamples\n--------\n\n2-phases commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA PREPARE \'test\';\n\nXA COMMIT \'test\';\n\n1-phase commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA COMMIT \'test\' ONE PHASE;\n\nHuman-readable:\n\nxa start \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\ninsert t1 values (40);\n\nxa end \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa prepare \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa recover format=\'RAW\';\n+----------+--------------+--------------+--------------------+\n| formatID | gtrid_length | bqual_length | data               |\n+----------+--------------+--------------+--------------------+\n34      67v78abc       11 |            7 | 12\ndef |\n+----------+--------------+--------------+--------------------+\n\nxa recover format=\'SQL\';\n+----------+--------------+--------------+-------------------------------------\n---------+\n| formatID | gtrid_length | bqual_length | data                               \n     |\n+----------+--------------+--------------+-------------------------------------\n---------+\n|        3 |           11 |            7 |\nX\'31320d3334093637763738\',X\'6162630a646566\',3 |\n+----------+--------------+--------------+-------------------------------------\n---------+\n\nxa rollback X\'31320d3334093637763738\',X\'6162630a646566\',3;\n\nKnown Issues\n------------\n\nMariaDB Galera Cluster\n----------------------\n\nMariaDB Galera Cluster does not support XA transactions.\n\nHowever, MariaDB Galera Cluster builds include a built-in plugin called wsrep.\nPrior to MariaDB 10.4.3, this plugin was internally considered an XA-capable\nstorage engine. Consequently, these MariaDB Galera Cluster builds have\nmultiple XA-capable storage engines by default, even if the only \"real\"\nstorage engine that supports external XA transactions enabled on these builds\nby default is InnoDB. Therefore, when using one these builds MariaDB would be\nforced to use a transaction coordinator log by default, which could have\nperformance implications.\n\nSee Transaction Coordinator Log Overview: MariaDB Galera Cluster for more\ninformation.\n\nURL: https://mariadb.com/kb/en/xa-transactions/','','https://mariadb.com/kb/en/xa-transactions/'),(104,'CREATE USER',10,'Syntax\n------\n\nCREATE [OR REPLACE] USER [IF NOT EXISTS] \n user_specification [,user_specification ...] \n [REQUIRE {NONE | tls_option [[AND] tls_option ...] }]\n [WITH resource_option [resource_option ...] ]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe CREATE USER statement creates new MariaDB accounts. To use it, you must\nhave the global CREATE USER privilege or the INSERT privilege for the mysql\ndatabase. For each account, CREATE USER creates a new row in mysql.user (until\nMariaDB 10.3 this is a table, from MariaDB 10.4 it\'s a view) or\nmysql.global_priv_table (from MariaDB 10.4) that has no privileges.\n\nIf any of the specified accounts, or any permissions for the specified\naccounts, already exist, then the server returns ERROR 1396 (HY000). If an\nerror occurs, CREATE USER will still create the accounts that do not result in\nan error. Only one error is produced for all users which have not been created:\n\nERROR 1396 (HY000): \n Operation CREATE USER failed for \'u1\'@\'%\',\'u2\'@\'%\'\n\nCREATE USER, DROP USER, CREATE ROLE, and DROP ROLE all produce the same error\ncode when they fail.\n\nSee Account Names below for details on how account names are specified.\n\nOR REPLACE\n----------\n\nIf the optional OR REPLACE clause is used, it is basically a shortcut for:\n\nDROP USER IF EXISTS name;\nCREATE USER name ...;\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE OR REPLACE USER foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected (0.00 sec)\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified user already exists.\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE USER IF NOT EXISTS foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+----------------------------------------------------+\n| Level | Code | Message                                            |\n+-------+------+----------------------------------------------------+\n| Note  | 1973 | Can\'t create user \'foo2\'@\'test\'; it already exists |\n+-------+------+----------------------------------------------------+\n\nAuthentication Options\n----------------------\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored in the\nmysql.user/mysql.global_priv_table table.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nCREATE USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored in the\nmysql.user/mysql.global_priv_table table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nCREATE USER foo2@test IDENTIFIED BY PASSWORD\n\'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nCREATE USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nCREATE USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\') OR\nunix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nCREATE USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to create a user with resource limits:\n\nCREATE USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nAccount Names\n-------------\n\nAccount names have both a user name component and a host name component, and\nare specified as \'user_name\'@\'host_name\'.\n\nThe user name and host name may be unquoted, quoted as strings using double\nquotes (\") or single quotes (\'), or quoted as identifiers using backticks (`).\nYou must use quotes when using special characters (such as a hyphen) or\nwildcard characters. If you quote, you must quote the user name and host name\nseparately (for example \'user_name\'@\'host_name\').\n\nHost Name Component\n-------------------\n\nIf the host name is not provided, it is assumed to be \'%\'.\n\nHost names may contain the wildcard characters % and _. They are matched as if\nby the LIKE clause. If you need to use a wildcard character literally (for\nexample, to match a domain name with an underscore), prefix the character with\na backslash. See LIKE for more information on escaping wildcard characters.\n\nHost name matches are case-insensitive. Host names can match either domain\nnames or IP addresses. Use \'localhost\' as the host name to allow only local\nclient connections.\n\nYou can use a netmask to match a range of IP addresses using \'base_ip/netmask\'\nas the host name. A user with an IP address ip_addr will be allowed to connect\nif the following condition is true:\n\nip_addr & netmask = base_ip\n\nFor example, given a user:\n\nCREATE USER \'maria\'@\'247.150.130.0/255.255.255.0\';\n\nthe IP addresses satisfying this condition range from 247.150.130.0 to\n247.150.130.255.\n\nUsing 255.255.255.255 is equivalent to not using a netmask at all. Netmasks\ncannot be used for IPv6 addresses.\n\nNote that the credentials added when creating a user with the \'%\' wildcard\nhost will not grant access in all cases. For example, some systems come with\nan anonymous localhost user, and when connecting from localhost this will take\nprecedence.\n\nBefore MariaDB 10.6, the host name component could be up to 60 characters in\nlength. Starting from MariaDB 10.6, it can be up to 255 characters.\n\nUser Name Component\n-------------------\n\nUser names must match exactly, including case. A user name that is empty is\nknown as an anonymous account and is allowed to match a login attempt with any\nuser name component. These are described more in the next section.\n\nFor valid identifiers to use as user names, see Identifier Names.\n\nIt is possible for more than one account to match when a user connects.\nMariaDB selects the first matching account after sorting according to the\nfollowing criteria:\n\n* Accounts with an exact host name are sorted before accounts using a wildcard\nin the\nhost name. Host names using a netmask are considered to be exact for sorting.\n* Accounts with a wildcard in the host name are sorted according to the\nposition of\nthe first wildcard character. Those with a wildcard character later in the\nhost name\nsort before those with a wildcard character earlier in the host name.\n* Accounts with a non-empty user name sort before accounts with an empty user\nname.\n* Accounts with an empty user name are sorted last. As mentioned previously,\nthese are known as anonymous accounts. These are described more in the next\nsection.\n\nThe following table shows a list of example account as sorted by these\ncriteria:\n\n+---------+-------------+\n| User    | Host        |\n+---------+-------------+\n| joffrey | 192.168.0.3 |\n|         | 192.168.0.% |\n| joffrey | 192.168.%   |\n|         | 192.168.%   |\n+---------+-------------+\n\nOnce connected, you only have the privileges granted to the account that\nmatched, not all accounts that could have matched. For example, consider the\nfollowing commands:\n\nCREATE USER \'joffrey\'@\'192.168.0.3\';\nCREATE USER \'joffrey\'@\'%\';\nGRANT SELECT ON test.t1 to \'joffrey\'@\'192.168.0.3\';\nGRANT SELECT ON test.t2 to \'joffrey\'@\'%\';\n\nIf you connect as joffrey from 192.168.0.3, you will have the SELECT privilege\non the table test.t1, but not on the table test.t2. If you connect as joffrey\nfrom any other IP address, you will have the SELECT privilege on the table\ntest.t2, but not on the table test.t1.\n\nUsernames can be up to 80 characters long before 10.6 and starting from 10.6\nit can be 128 characters long.\n\nAnonymous Accounts\n------------------\n\nAnonymous accounts are accounts where the user name portion of the account\nname is empty. These accounts act as special catch-all accounts. If a user\nattempts to log into the system from a host, and an anonymous account exists\nwith a host name portion that matches the user\'s host, then the user will log\nin as the anonymous account if there is no more specific account match for the\nuser name that the user entered.\n\nFor example, here are some anonymous accounts:\n\nCREATE USER \'\'@\'localhost\';\nCREATE USER \'\'@\'192.168.0.3\';\n\nFixing a Legacy Default Anonymous Account\n-----------------------------------------\n\nOn some systems, the mysql.db table has some entries for the \'\'@\'%\' anonymous\naccount by default. Unfortunately, there is no matching entry in the\nmysql.user/mysql.global_priv_table table, which means that this anonymous\naccount doesn\'t exactly exist, but it does have privileges--usually on the\ndefault test database created by mysql_install_db. These account-less\nprivileges are a legacy that is leftover from a time when MySQL\'s privilege\nsystem was less advanced.\n\nThis situation means that you will run into errors if you try to create a\n\'\'@\'%\' account. For example:\n\nCREATE USER \'\'@\'%\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'\'@\'%\'\n\nThe fix is to DELETE the row in the mysql.db table and then execute FLUSH\nPRIVILEGES:\n\nDELETE FROM mysql.db WHERE User=\'\' AND Host=\'%\';\nFLUSH PRIVILEGES;\n\nAnd then the account can be created:\n\nCREATE USER \'\'@\'%\';\nQuery OK, 0 rows affected (0.01 sec)\n\nSee MDEV-13486 for more information.\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nCREATE USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/create-user/','','https://mariadb.com/kb/en/create-user/'),(105,'ALTER USER',10,'Syntax\n------\n\nALTER USER [IF EXISTS] \n user_specification [,user_specification] ...\n [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n [WITH resource_option [resource_option] ...]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule] ...\n\nauthentication_rule:\n authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe ALTER USER statement modifies existing MariaDB accounts. To use it, you\nmust have the global CREATE USER privilege or the UPDATE privilege for the\nmysql database. The global SUPER privilege is also required if the read_only\nsystem variable is enabled.\n\nIf any of the specified user accounts do not yet exist, an error results. If\nan error occurs, ALTER USER will still modify the accounts that do not result\nin an error. Only one error is produced for all users which have not been\nmodified.\n\nIF EXISTS\n---------\n\nWhen the IF EXISTS clause is used, MariaDB will return a warning instead of an\nerror for each specified user that does not exist.\n\nAccount Names\n-------------\n\nFor ALTER USER statements, account names are specified as the username\nargument in the same way as they are for CREATE USER statements. See account\nnames from the CREATE USER page for details on how account names are specified.\n\nCURRENT_USER or CURRENT_USER() can also be used to alter the account logged\ninto the current session. For example, to change the current user\'s password\nto mariadb:\n\nALTER USER CURRENT_USER() IDENTIFIED BY \'mariadb\';\n\nAuthentication Options\n----------------------\n\nMariaDB starting with 10.4\n--------------------------\nFrom MariaDB 10.4, it is possible to use more than one authentication plugin\nfor each user account. For example, this can be useful to slowly migrate users\nto the more secure ed25519 authentication plugin over time, while allowing the\nold mysql_native_password authentication plugin as an alternative for the\ntransitional period. See Authentication from MariaDB 10.4 for more.\n\nWhen running ALTER USER, not specifying an authentication option in the\nIDENTIFIED VIA clause will remove that authentication method. (However this\nwas not the case before MariaDB 10.4.13, see MDEV-21928)\n\nFor example, a user is created with the ability to authenticate via both a\npassword and unix_socket:\n\nCREATE USER \'bob\'@\'localhost\' \n IDENTIFIED VIA mysql_native_password USING PASSWORD(\'pwd\')\n OR unix_socket;\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED VIA mysql_native_password\n USING \'*975B2CD4FF9AE554FE8AD33168FBFC326D2021DD\'\n OR unix_socket\n\nIf the user\'s password is updated, but unix_socket authentication is not\nspecified in the IDENTIFIED VIA clause, unix_socket authentication will no\nlonger be permitted.\n\nALTER USER \'bob\'@\'localhost\' IDENTIFIED VIA mysql_native_password \n USING PASSWORD(\'pwd2\');\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED BY PASSWORD \'*38366FDA01695B6A5A9DD4E428D9FB8F7EB75512\'\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored to the mysql.user table.\n\nFor example, if our password is mariadb, then we can set the account\'s\npassword with:\n\nALTER USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD#function. It will be stored to the\nmysql.user table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n\nAnd then we can set an account\'s password with the hash:\n\nALTER USER foo2@test \n IDENTIFIED BY PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nALTER USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nALTER USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nIn MariaDB 10.4 and later, the USING or AS keyword can also be used to provide\na plain-text password to a plugin if it\'s provided as an argument to the\nPASSWORD() function. This is only valid for authentication plugins that have\nimplemented a hook for the PASSWORD() function. For example, the ed25519\nauthentication plugin supports this:\n\nALTER USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can alter a user account to require these TLS options with\nthe following:\n\nALTER USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\' AND\n ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+------------------------------------+---------------------------------------+\n| Limit Type                         | Description                           |\n+------------------------------------+---------------------------------------+\n| MAX_QUERIES_PER_HOUR               | Number of statements that the         |\n|                                    | account can issue per hour            |\n|                                    | (including updates)                   |\n+------------------------------------+---------------------------------------+\n| MAX_UPDATES_PER_HOUR               | Number of updates (not queries) that  |\n|                                    | the account can issue per hour        |\n+------------------------------------+---------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR           | Number of connections that the        |\n|                                    | account can start per hour            |\n+------------------------------------+---------------------------------------+\n| MAX_USER_CONNECTIONS               | Number of simultaneous connections    |\n|                                    | that can be accepted from the same    |\n|                                    | account; if it is 0, max_connections  |\n|                                    | will be used instead; if              |\n|                                    | max_connections is 0, there is no     |\n|                                    | limit for this account\'s              |\n|                                    | simultaneous connections.             |\n+------------------------------------+---------------------------------------+\n| MAX_STATEMENT_TIME                 | Timeout, in seconds, for statements   |\n|                                    | executed by the user. See also        |\n|                                    | Aborting Statements that Exceed a     |\n|                                    | Certain Time to Execute.              |\n+------------------------------------+---------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to set an account\'s resource limits:\n\nALTER USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nALTER USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/alter-user/','','https://mariadb.com/kb/en/alter-user/'),(107,'GRANT',10,'Syntax\n------\n\nGRANT\n  priv_type [(column_list)]\n   [, priv_type [(column_list)]] ...\n  ON [object_type] priv_level\n  TO user_specification [ user_options ...]\n\nuser_specification:\n username [authentication_option]\n | PUBLIC\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\nGRANT PROXY ON username\n  TO user_specification [, user_specification ...]\n  [WITH GRANT OPTION]\n\nGRANT rolename TO grantee [, grantee ...]\n  [WITH ADMIN OPTION]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nuser_options:\n  [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n  [WITH with_option [with_option] ...]\n\nobject_type:\n  TABLE\n | FUNCTION\n | PROCEDURE\n | PACKAGE\n\npriv_level:\n  *\n | *.*\n | db_name.*\n | db_name.tbl_name\n | tbl_name\n | db_name.routine_name\n\nwith_option:\n  GRANT OPTION\n | resource_option\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nDescription\n-----------\n\nThe GRANT statement allows you to grant privileges or roles to accounts. To\nuse GRANT, you must have the GRANT OPTION privilege, and you must have the\nprivileges that you are granting.\n\nUse the REVOKE statement to revoke privileges granted with the GRANT statement.\n\nUse the SHOW GRANTS statement to determine what privileges an account has.\n\nAccount Names\n-------------\n\nFor GRANT statements, account names are specified as the username argument in\nthe same way as they are for CREATE USER statements. See account names from\nthe CREATE USER page for details on how account names are specified.\n\nImplicit Account Creation\n-------------------------\n\nThe GRANT statement also allows you to implicitly create accounts in some\ncases.\n\nIf the account does not yet exist, then GRANT can implicitly create it. To\nimplicitly create an account with GRANT, a user is required to have the same\nprivileges that would be required to explicitly create the account with the\nCREATE USER statement.\n\nIf the NO_AUTO_CREATE_USER SQL_MODE is set, then accounts can only be created\nif authentication information is specified, or with a CREATE USER statement.\nIf no authentication information is provided, GRANT will produce an error when\nthe specified account does not exist, for example:\n\nshow variables like \'%sql_mode%\' ;\n+---------------+--------------------------------------------+\n| Variable_name | Value                                      |\n+---------------+--------------------------------------------+\n| sql_mode      | NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n+---------------+--------------------------------------------+\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' IDENTIFIED BY \'\';\nERROR 1133 (28000): Can\'t find any matching row in the user table\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' \n IDENTIFIED VIA PAM using \'mariadb\' require ssl ;\nQuery OK, 0 rows affected (0.00 sec)\n\nselect host, user from mysql.user where user=\'user123\' ;\n\n+------+----------+\n| host | user     |\n+------+----------+\n| %    | user123 |\n+------+----------+\n\nPrivilege Levels\n----------------\n\nPrivileges can be set globally, for an entire database, for a table or\nroutine, or for individual columns in a table. Certain privileges can only be\nset at certain levels.\n\n* Global privileges priv_type are granted using *.* for\npriv_level. Global privileges include privileges to administer the database\nand manage user accounts, as well as privileges for all tables, functions, and\nprocedures. Global privileges are stored in the mysql.user table prior to\nMariaDB 10.4, and in  mysql.global_priv table afterwards.\n* Database privileges priv_type are granted using db_name.*\nfor priv_level, or using just * to use default database. Database\nprivileges include privileges to create tables and functions, as well as\nprivileges for all tables, functions, and procedures in the database. Database\nprivileges are stored in the mysql.db table.\n* Table privileges priv_type are granted using db_name.tbl_name\nfor priv_level, or using just tbl_name to specify a table in the default\ndatabase. The TABLE keyword is optional. Table privileges include the\nability to select and change data in the table. Certain table privileges can\nbe granted for individual columns.\n* Column privileges priv_type are granted by specifying a table for\npriv_level and providing a column list after the privilege type. They allow\nyou to control exactly which columns in a table users can select and change.\n* Function privileges priv_type are granted using FUNCTION db_name.routine_name\nfor priv_level, or using just  FUNCTION routine_name to specify a function\nin the default database.\n* Procedure privileges priv_type are granted using PROCEDURE\ndb_name.routine_name\nfor priv_level, or using just PROCEDURE routine_name to specify a procedure\nin the default database.\n\nThe USAGE Privilege\n-------------------\n\nThe USAGE privilege grants no real privileges. The SHOW GRANTS statement will\nshow a global USAGE privilege for a newly-created user. You can use USAGE with\nthe GRANT statement to change options like GRANT OPTION and\nMAX_USER_CONNECTIONS without changing any account privileges.\n\nThe ALL PRIVILEGES Privilege\n----------------------------\n\nThe ALL PRIVILEGES privilege grants all available privileges. Granting all\nprivileges only affects the given privilege level. For example, granting all\nprivileges on a table does not grant any privileges on the database or\nglobally.\n\nUsing ALL PRIVILEGES does not grant the special GRANT OPTION privilege.\n\nYou can use ALL instead of ALL PRIVILEGES.\n\nThe GRANT OPTION Privilege\n--------------------------\n\nUse the WITH GRANT OPTION clause to give users the ability to grant privileges\nto other users at the given privilege level. Users with the GRANT OPTION\nprivilege can only grant privileges they have. They cannot grant privileges at\na higher privilege level than they have the GRANT OPTION privilege.\n\nThe GRANT OPTION privilege cannot be set for individual columns. If you use\nWITH GRANT OPTION when specifying column privileges, the GRANT OPTION\nprivilege will be granted for the entire table.\n\nUsing the WITH GRANT OPTION clause is equivalent to listing GRANT OPTION as a\nprivilege.\n\nGlobal Privileges\n-----------------\n\nThe following table lists the privileges that can be granted globally. You can\nalso grant all database, table, and function privileges globally. When granted\nglobally, these privileges apply to all databases, tables, or functions,\nincluding those created later.\n\nTo set a global privilege, use *.* for priv_level.\n\nBINLOG ADMIN\n------------\n\nEnables administration of the binary log, including the PURGE BINARY LOGS\nstatement and setting the system variables:\n\n* binlog_annotate_row_events\n* binlog_cache_size\n* binlog_commit_wait_count\n* binlog_commit_wait_usec\n* binlog_direct_non_transactional_updates\n* binlog_expire_logs_seconds\n* binlog_file_cache_size\n* binlog_format\n* binlog_row_image\n* binlog_row_metadata\n* binlog_stmt_cache_size\n* expire_logs_days\n* log_bin_compress\n* log_bin_compress_min_len\n* log_bin_trust_function_creators\n* max_binlog_cache_size\n* max_binlog_size\n* max_binlog_stmt_cache_size\n* sql_log_bin and\n* sync_binlog.\n\nAdded in MariaDB 10.5.2.\n\nBINLOG MONITOR\n--------------\n\nNew name for REPLICATION CLIENT from MariaDB 10.5.2, (REPLICATION CLIENT still\nsupported as an alias for compatibility purposes). Permits running SHOW\ncommands related to the binary log, in particular the SHOW BINLOG STATUS and\nSHOW BINARY LOGS statements. Unlike REPLICATION CLIENT prior to MariaDB 10.5,\nSHOW REPLICA STATUS isn\'t included in this privilege, and REPLICA MONITOR is\nrequired.\n\nBINLOG REPLAY\n-------------\n\nEnables replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), executing SET timestamp when secure_timestamp is set to\nreplication, and setting the session values of system variables usually\nincluded in BINLOG output, in particular:\n\n* gtid_domain_id\n* gtid_seq_no\n* pseudo_thread_id\n* server_id.\n\nAdded in MariaDB 10.5.2\n\nCONNECTION ADMIN\n----------------\n\nEnables administering connection resource limit options. This includes\nignoring the limits specified by:\n\n* max_connections\n* max_user_connections and\n* max_password_errors.\n\nThe statements specified in init_connect are not executed, killing connections\nand queries owned by other users is permitted. The following\nconnection-related system variables can be changed:\n\n* connect_timeout\n* disconnect_on_expired_password\n* extra_max_connections\n* init_connect\n* max_connections\n* max_connect_errors\n* max_password_errors\n* proxy_protocol_networks\n* secure_auth\n* slow_launch_time\n* thread_pool_exact_stats\n* thread_pool_dedicated_listener\n* thread_pool_idle_timeout\n* thread_pool_max_threads\n* thread_pool_min_threads\n* thread_pool_oversubscribe\n* thread_pool_prio_kickup_timer\n* thread_pool_priority\n* thread_pool_size, and\n* thread_pool_stall_limit.\n\nAdded in MariaDB 10.5.2.\n\nCREATE USER\n-----------\n\nCreate a user using the CREATE USER statement, or implicitly create a user\nwith the GRANT statement.\n\nFEDERATED ADMIN\n---------------\n\nExecute CREATE SERVER, ALTER SERVER, and DROP SERVER statements. Added in\nMariaDB 10.5.2.\n\nFILE\n----\n\nRead and write files on the server, using statements like LOAD DATA INFILE or\nfunctions like LOAD_FILE(). Also needed to create CONNECT outward tables.\nMariaDB server must have the permissions to access those files.\n\nGRANT OPTION\n------------\n\nGrant global privileges. You can only grant privileges that you have.\n\nPROCESS\n-------\n\nShow information about the active processes, for example via SHOW PROCESSLIST\nor mysqladmin processlist. If you have the PROCESS privilege, you can see all\nthreads. Otherwise, you can see only your own threads (that is, threads\nassociated with the MariaDB account that you are using).\n\nREAD_ONLY ADMIN\n---------------\n\nUser can set the read_only system variable and allows the user to perform\nwrite operations, even when the read_only option is active. Added in MariaDB\n10.5.2.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nRELOAD\n------\n\nExecute FLUSH statements or equivalent mariadb-admin/mysqladmin commands.\n\nREPLICATION CLIENT\n------------------\n\nExecute SHOW MASTER STATUS and SHOW BINARY LOGS informative statements.\nRenamed to BINLOG MONITOR in MariaDB 10.5.2 (but still supported as an alias\nfor compatibility reasons). SHOW SLAVE STATUS was part of REPLICATION CLIENT\nprior to MariaDB 10.5.\n\nREPLICATION MASTER ADMIN\n------------------------\n\nPermits administration of primary servers, including the SHOW REPLICA HOSTS\nstatement, and setting the gtid_binlog_state, gtid_domain_id,\nmaster_verify_checksum and server_id system variables. Added in MariaDB 10.5.2.\n\nREPLICA MONITOR\n---------------\n\nPermit SHOW REPLICA STATUS and SHOW RELAYLOG EVENTS. From MariaDB 10.5.9.\n\nWhen a user would upgrade from an older major release to a MariaDB 10.5 minor\nrelease prior to MariaDB 10.5.9, certain user accounts would lose\ncapabilities. For example, a user account that had the REPLICATION CLIENT\nprivilege in older major releases could run SHOW REPLICA STATUS, but after\nupgrading to a MariaDB 10.5 minor release prior to MariaDB 10.5.9, they could\nno longer run SHOW REPLICA STATUS, because that statement was changed to\nrequire the REPLICATION REPLICA ADMIN privilege.\n\nThis issue is fixed in MariaDB 10.5.9 with this new privilege, which now\ngrants the user the ability to execute SHOW [ALL] (SLAVE | REPLICA) STATUS.\n\nWhen a database is upgraded from an older major release to MariaDB Server\n10.5.9 or later, any user accounts with the REPLICATION CLIENT or REPLICATION\nSLAVE privileges will automatically be granted the new REPLICA MONITOR\nprivilege. The privilege fix occurs when the server is started up, not when\nmariadb-upgrade is performed.\n\nHowever, when a database is upgraded from an early 10.5 minor release to\n10.5.9 and later, the user will have to fix any user account privileges\nmanually.\n\nREPLICATION REPLICA\n-------------------\n\nSynonym for REPLICATION SLAVE. From MariaDB 10.5.1.\n\nREPLICATION SLAVE\n-----------------\n\nAccounts used by replica servers on the primary need this privilege. This is\nneeded to get the updates made on the master. From MariaDB 10.5.1, REPLICATION\nREPLICA is an alias for REPLICATION SLAVE.\n\nREPLICATION SLAVE ADMIN\n-----------------------\n\nPermits administering replica servers, including START REPLICA/SLAVE, STOP\nREPLICA/SLAVE, CHANGE MASTER, SHOW REPLICA/SLAVE STATUS, SHOW RELAYLOG EVENTS\nstatements, replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), and setting the system variables:\n\n* gtid_cleanup_batch_size\n* gtid_ignore_duplicates\n* gtid_pos_auto_engines\n* gtid_slave_pos\n* gtid_strict_mode\n* init_slave\n* read_binlog_speed_limit\n* relay_log_purge\n* relay_log_recovery\n* replicate_do_db\n* replicate_do_table\n* replicate_events_marked_for_skip\n* replicate_ignore_db\n* replicate_ignore_table\n* replicate_wild_do_table\n* replicate_wild_ignore_table\n* slave_compressed_protocol\n* slave_ddl_exec_mode\n* slave_domain_parallel_threads\n* slave_exec_mode\n* slave_max_allowed_packet\n* slave_net_timeout\n* slave_parallel_max_queued\n* slave_parallel_mode\n* slave_parallel_threads\n* slave_parallel_workers\n* slave_run_triggers_for_rbr\n* slave_sql_verify_checksum\n* slave_transaction_retry_interval\n* slave_type_conversions\n* sync_master_info\n* sync_relay_log, and\n* sync_relay_log_info.\n\nAdded in MariaDB 10.5.2.\n\nSET USER\n--------\n\nEnables setting the DEFINER when creating triggers, views, stored functions\nand stored procedures. Added in MariaDB 10.5.2.\n\nSHOW DATABASES\n--------------\n\nList all databases using the SHOW DATABASES statement. Without the SHOW\nDATABASES privilege, you can still issue the SHOW DATABASES statement, but it\nwill only list databases containing tables on which you have privileges.\n\nSHUTDOWN\n--------\n\nShut down the server using SHUTDOWN or the mysqladmin shutdown command.\n\nSUPER\n-----\n\nExecute superuser statements: CHANGE MASTER TO, KILL (users who do not have\nthis privilege can only KILL their own threads), PURGE LOGS, SET global system\nvariables, or the mysqladmin debug command. Also, this permission allows the\nuser to write data even if the read_only startup option is set, enable or\ndisable logging, enable or disable replication on replica, specify a DEFINER\nfor statements that support that clause, connect once reaching the\nMAX_CONNECTIONS. If a statement has been specified for the init-connect mysqld\noption, that command will not be executed when a user with SUPER privileges\nconnects to the server.\n\nThe SUPER privilege has been split into multiple smaller privileges from\nMariaDB 10.5.2 to allow for more fine-grained privileges, although it remains\nan alias for these smaller privileges.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nDatabase Privileges\n-------------------\n\nThe following table lists the privileges that can be granted at the database\nlevel. You can also grant all table and function privileges at the database\nlevel. Table and function privileges on a database apply to all tables or\nfunctions in that database, including those created later.\n\nTo set a privilege for a database, specify the database using db_name.* for\npriv_level, or just use * to specify the default database.\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a database using the CREATE      |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. You can      |\n|                                  | grant the CREATE privilege on           |\n|                                  | databases that do not yet exist. This   |\n|                                  | also grants the CREATE privilege on     |\n|                                  | all tables in the database.             |\n+----------------------------------+-----------------------------------------+\n| CREATE ROUTINE                   | Create Stored Programs using the        |\n|                                  | CREATE PROCEDURE and CREATE FUNCTION    |\n|                                  | statements.                             |\n+----------------------------------+-----------------------------------------+\n| CREATE TEMPORARY TABLES          | Create temporary tables with the        |\n|                                  | CREATE TEMPORARY TABLE statement. This  |\n|                                  | privilege enable writing and dropping   |\n|                                  | those temporary tables                  |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a database using the DROP          |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. This also    |\n|                                  | grants the DROP privilege on all        |\n|                                  | tables in the database.                 |\n+----------------------------------+-----------------------------------------+\n| EVENT                            | Create, drop and alter EVENTs.          |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant database privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n| LOCK TABLES                      | Acquire explicit locks using the LOCK   |\n|                                  | TABLES statement; you also need to      |\n|                                  | have the SELECT privilege on a table,   |\n|                                  | in order to lock it.                    |\n+----------------------------------+-----------------------------------------+\n\nTable Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER                            | Change the structure of an existing     |\n|                                  | table using the ALTER TABLE statement.  |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a table using the CREATE TABLE   |\n|                                  | statement.  You can grant the CREATE    |\n|                                  | privilege on tables that do not yet     |\n|                                  | exist.                                  |\n+----------------------------------+-----------------------------------------+\n| CREATE VIEW                      | Create a view using the CREATE_VIEW     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| DELETE                           | Remove rows from a table using the      |\n|                                  | DELETE statement.                       |\n+----------------------------------+-----------------------------------------+\n| DELETE HISTORY                   | Remove historical rows from a table     |\n|                                  | using the DELETE HISTORY statement.     |\n|                                  | Displays as DELETE VERSIONING ROWS      |\n|                                  | when running SHOW GRANTS until MariaDB  |\n|                                  | 10.3.15 and until MariaDB 10.4.5        |\n|                                  | (MDEV-17655), or when running SHOW      |\n|                                  | PRIVILEGES until MariaDB 10.5.2,        |\n|                                  | MariaDB 10.4.13 and MariaDB 10.3.23     |\n|                                  | (MDEV-20382). From MariaDB 10.3.4.      |\n|                                  | From MariaDB 10.3.5, if a user has the  |\n|                                  | SUPER privilege but not this            |\n|                                  | privilege, running mysql_upgrade will   |\n|                                  | grant this privilege as well.           |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a table using the DROP TABLE       |\n|                                  | statement or a view using the DROP      |\n|                                  | VIEW statement. Also required to        |\n|                                  | execute the TRUNCATE TABLE statement.   |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant table privileges. You can only    |\n|                                  | grant privileges that you have.         |\n+----------------------------------+-----------------------------------------+\n| INDEX                            | Create an index on a table using the    |\n|                                  | CREATE INDEX statement. Without the     |\n|                                  | INDEX privilege, you can still create   |\n|                                  | indexes when creating a table using     |\n|                                  | the CREATE TABLE statement if the you   |\n|                                  | have the CREATE privilege, and you can  |\n|                                  | create indexes using the ALTER TABLE    |\n|                                  | statement if you have the ALTER         |\n|                                  | privilege.                              |\n+----------------------------------+-----------------------------------------+\n| INSERT                           | Add rows to a table using the INSERT    |\n|                                  | statement.  The INSERT privilege can    |\n|                                  | also be set on individual columns; see  |\n|                                  | Column Privileges below for details.    |\n+----------------------------------+-----------------------------------------+\n| REFERENCES                       | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT                           | Read data from a table using the        |\n|                                  | SELECT statement. The SELECT privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n| SHOW VIEW                        | Show the CREATE VIEW statement to       |\n|                                  | create a view using the SHOW CREATE     |\n|                                  | VIEW statement.                         |\n+----------------------------------+-----------------------------------------+\n| TRIGGER                          | Execute triggers associated to tables   |\n|                                  | you update, execute the CREATE TRIGGER  |\n|                                  | and DROP TRIGGER statements. You will   |\n|                                  | still be able to see triggers.          |\n+----------------------------------+-----------------------------------------+\n| UPDATE                           | Update existing rows in a table using   |\n|                                  | the UPDATE statement. UPDATE            |\n|                                  | statements usually include a WHERE      |\n|                                  | clause to update only certain rows.     |\n|                                  | You must have SELECT privileges on the  |\n|                                  | table or the appropriate columns for    |\n|                                  | the WHERE clause. The UPDATE privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n\nColumn Privileges\n-----------------\n\nSome table privileges can be set for individual columns of a table. To use\ncolumn privileges, specify the table explicitly and provide a list of column\nnames after the privilege type. For example, the following statement would\nallow the user to read the names and positions of employees, but not other\ninformation from the same table, such as salaries.\n\nGRANT SELECT (name, position) on Employee to \'jeffrey\'@\'localhost\';\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| INSERT (column_list)             | Add rows specifying values in columns   |\n|                                  | using the INSERT statement. If you      |\n|                                  | only have column-level INSERT           |\n|                                  | privileges, you must specify the        |\n|                                  | columns you are setting in the INSERT   |\n|                                  | statement. All other columns will be    |\n|                                  | set to their default values, or NULL.   |\n+----------------------------------+-----------------------------------------+\n| REFERENCES (column_list)         | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT (column_list)             | Read values in columns using the        |\n|                                  | SELECT statement. You cannot access or  |\n|                                  | query any columns for which you do not  |\n|                                  | have SELECT privileges, including in    |\n|                                  | WHERE, ON, GROUP BY, and ORDER BY       |\n|                                  | clauses.                                |\n+----------------------------------+-----------------------------------------+\n| UPDATE (column_list)             | Update values in columns of existing    |\n|                                  | rows using the UPDATE statement.        |\n|                                  | UPDATE statements usually include a     |\n|                                  | WHERE clause to update only certain     |\n|                                  | rows. You must have SELECT privileges   |\n|                                  | on the table or the appropriate         |\n|                                  | columns for the WHERE clause.           |\n+----------------------------------+-----------------------------------------+\n\nFunction Privileges\n-------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | function using the ALTER FUNCTION       |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Use a stored function. You need SELECT  |\n|                                  | privileges for any tables or columns    |\n|                                  | accessed by the function.               |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant function privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nProcedure Privileges\n--------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | procedure using the ALTER PROCEDURE     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Execute a stored procedure using the    |\n|                                  | CALL statement. The privilege to call   |\n|                                  | a procedure may allow you to perform    |\n|                                  | actions you wouldn\'t otherwise be able  |\n|                                  | to do, such as insert rows into a       |\n|                                  | table.                                  |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant procedure privileges. You can     |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nGRANT EXECUTE ON PROCEDURE mysql.create_db TO maintainer;\n\nProxy Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| PROXY                            | Permits one user to be a proxy for      |\n|                                  | another.                                |\n+----------------------------------+-----------------------------------------+\n\nThe PROXY privilege allows one user to proxy as another user, which means\ntheir privileges change to that of the proxy user, and the CURRENT_USER()\nfunction returns the user name of the proxy user.\n\nThe PROXY privilege only works with authentication plugins that support it.\nThe default mysql_native_password authentication plugin does not support proxy\nusers.\n\nThe pam authentication plugin is the only plugin included with MariaDB that\ncurrently supports proxy users. The PROXY privilege is commonly used with the\npam authentication plugin to enable user and group mapping with PAM.\n\nFor example, to grant the PROXY privilege to an anonymous account that\nauthenticates with the pam authentication plugin, you could execute the\nfollowing:\n\nCREATE USER \'dba\'@\'%\' IDENTIFIED BY \'strongpassword\';\nGRANT ALL PRIVILEGES ON *.* TO \'dba\'@\'%\' ;\n\nCREATE USER \'\'@\'%\' IDENTIFIED VIA pam USING \'mariadb\';\nGRANT PROXY ON \'dba\'@\'%\' TO \'\'@\'%\';\n\nA user account can only grant the PROXY privilege for a specific user account\nif the granter also has the PROXY privilege for that specific user account,\nand if that privilege is defined WITH GRANT OPTION. For example, the following\nexample fails because the granter does not have the PROXY privilege for that\nspecific user account at all:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nAnd the following example fails because the granter does have the PROXY\nprivilege for that specific user account, but it is not defined WITH GRANT\nOPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\'                     \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nBut the following example succeeds because the granter does have the PROXY\nprivilege for that specific user account, and it is defined WITH GRANT OPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\' WITH GRANT OPTION   \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\n\nA user account can grant the PROXY privilege for any other user account if the\ngranter has the PROXY privilege for the \'\'@\'%\' anonymous user account, like\nthis:\n\nGRANT PROXY ON \'\'@\'%\' TO \'dba\'@\'localhost\' WITH GRANT OPTION;\n\nFor example, the following example succeeds because the user can grant the\nPROXY privilege for any other user account:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'\'@\'%\' TO \'alice\'@\'localhost\' WITH GRANT OPTION              \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'app1_dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nGRANT PROXY ON \'app2_dba\'@\'localhost\' TO \'carol\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nThe default root user accounts created by mysql_install_db have this\nprivilege. For example:\n\nGRANT ALL PRIVILEGES ON *.* TO \'root\'@\'localhost\' WITH GRANT OPTION;\nGRANT PROXY ON \'\'@\'%\' TO \'root\'@\'localhost\' WITH GRANT OPTION;\n\nThis allows the default root user accounts to grant the PROXY privilege for\nany other user account, and it also allows the default root user accounts to\ngrant others the privilege to do the same.\n\nAuthentication Options\n----------------------\n\nThe authentication options for the GRANT statement are the same as those for\nthe CREATE USER statement.\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \n PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\') OR unix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nTo set resource limits for an account, if you do not want to change that\naccount\'s privileges, you can issue a GRANT statement with the USAGE\nprivilege, which has no meaning. The statement can name some or all limit\ntypes, in any order.\n\nHere is an example showing how to set resource limits:\n\nGRANT USAGE ON *.* TO \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 0\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nUsers with the CONNECTION ADMIN privilege (in MariaDB 10.5.2 and later) or the\nSUPER privilege are not restricted by max_user_connections, max_connections,\nor max_password_errors.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nGRANT USAGE ON *.* TO \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nRoles\n-----\n\nSyntax\n------\n\nGRANT role TO grantee [, grantee ... ]\n[ WITH ADMIN OPTION ]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nThe GRANT statement is also used to grant the use of a role to one or more\nusers or other roles. In order to be able to grant a role, the grantor doing\nso must have permission to do so (see WITH ADMIN in the CREATE ROLE article).\n\nSpecifying the WITH ADMIN OPTION permits the grantee to in turn grant the role\nto another.\n\nFor example, the following commands show how to grant the same role to a\ncouple different users.\n\nGRANT journalist TO hulda;\n\nGRANT journalist TO berengar WITH ADMIN OPTION;\n\nIf a user has been granted a role, they do not automatically obtain all\npermissions associated with that role. These permissions are only in use when\nthe user activates the role with the SET ROLE statement.\n\nTO PUBLIC\n---------\n\nMariaDB starting with 10.11\n---------------------------\n\nSyntax\n------\n\nGRANT <privilege> ON <database>.<object> TO PUBLIC;\nREVOKE <privilege> ON <database>.<object> FROM PUBLIC;\n\nGRANT ... TO PUBLIC grants privileges to all users with access to the server.\nThe privileges also apply to users created after the privileges are granted.\nThis can be useful when one only wants to state once that all users need to\nhave a certain set of privileges.\n\nWhen running SHOW GRANTS, a user will also see all privileges inherited from\nPUBLIC. SHOW GRANTS FOR PUBLIC will only show TO PUBLIC grants.\n\nGrant Examples\n--------------\n\nGranting Root-like Privileges\n-----------------------------\n\nYou can create a user that has privileges similar to the default root accounts\nby executing the following:\n\nCREATE USER \'alexander\'@\'localhost\';\nGRANT ALL PRIVILEGES ON  *.* to \'alexander\'@\'localhost\' WITH GRANT OPTION;\n\nURL: https://mariadb.com/kb/en/grant/','','https://mariadb.com/kb/en/grant/'),(117,'Authentication from MariaDB 10.4',10,'MariaDB starting with 10.4\n--------------------------\nMariaDB 10.4 introduced a number of changes to the authentication process,\nintended to make things easier and more intuitive.\n\nOverview\n--------\n\nThere are four new main features in 10.4 relating to authentication:\n\n* It is possible to use more than one authentication plugin for each user\naccount. For example, this can be useful to slowly migrate users to the more\nsecure ed25519 authentication plugin over time, while allowing the old\nmysql_native_password authentication plugin as an alternative for the\ntransitional period.\n* The root@localhost user account created by mysql_install_db is created with\nthe ability to use two authentication plugins.\nFirst, it is configured to try to use the unix_socket authentication plugin.\nThis allows the root@localhost user to login without a password via the local\nUnix socket file defined by the socket system variable, as long as the login\nis attempted from a process owned by the operating system root user account.\nSecond, if authentication fails with the unix_socket authentication plugin,\nthen it is configured to try to use the mysql_native_password authentication\nplugin. However, an invalid password is initially set, so in order to\nauthenticate this way, a password must be set with SET PASSWORD.\nHowever, just using the unix_socket authentication plugin may be fine for many\nusers, and it is very secure. You may want to try going without password\nauthentication to see how well it works for you. Remember, the best way to\nkeep your password safe is not to have one!\n\n* All user accounts, passwords, and global privileges are now stored in the\nmysql.global_priv table. The mysql.user table still exists and has exactly the\nsame set of columns as before, but it’s now a view that references the\nmysql.global_priv table. Tools that analyze the mysql.user table should\ncontinue to work as before. From MariaDB 10.4.13, the dedicated mariadb.sys\nuser is created as the definer of this view. Previously root was the definer,\nwhich resulted in privilege problems when this username was changed.\n* MariaDB 10.4 adds supports for User Password Expiry, which is not active by\ndefault.\n\nDescription\n-----------\n\nAs a result of the above changes, the open-for-everyone all-powerful root\naccount is finally gone. And installation scripts will no longer demand that\nyou \"PLEASE REMEMBER TO SET A PASSWORD FOR THE MariaDB root USER !\", because\nthe root account is securely created automatically.\n\nTwo all-powerful accounts are created by default — root and the OS user that\nowns the data directory, typically mysql. They are created as:\n\nCREATE USER root@localhost IDENTIFIED VIA unix_socket OR mysql_native_password\nUSING \'invalid\'\nCREATE USER mysql@localhost IDENTIFIED VIA unix_socket OR\nmysql_native_password USING \'invalid\'\n\nUsing unix_socket means that if you are the system root user, you can login as\nroot@locahost without a password. This technique was pioneered by Otto\nKekäläinen in Debian MariaDB packages and has been successfully used in Debian\nsince as early as MariaDB 10.0.\n\nIt is based on a simple fact that asking the system root for a password adds\nno extra security — root has full access to all the data files and all process\nmemory anyway. But not asking for a password means, there is no root password\nto forget (no need for the numerous tutorials on \"how to reset MariaDB root\npassword\"). And if you want to script some tedious database work, there is no\nneed to store the root password in plain text for the script to use (no need\nfor debian-sys-maint user).\n\nStill, some users may wish to log in as MariaDB root without using sudo. Hence\nthe old authentication method — conventional MariaDB password — is still\navailable. By default it is disabled (\"invalid\" is not a valid password hash),\nbut one can set the password with a usual SET PASSWORD statement. And still\nretain the password-less access via sudo.\n\nIf you install MariaDB locally (say from a tarball), you would not want to use\nsudo to be able to login. This is why MariaDB creates a second all-powerful\nuser with the same name as a system user that owns the data directory. In\nlocal (not system-wide) installations, this will be the user who installed\nMariaDB — they automatically get convenient password-less root-like access,\nbecause they can access all the data files anyway.\n\nEven if MariaDB is installed system-wide, you may not want to run your\ndatabase maintenance scripts as system root — now you can run them as system\nmysql user. And you will know that they will never destroy your entire system,\neven if you make a typo in a shell script.\n\nHowever, seasoned MariaDB DBAs who are used to the old ways do need to make\nsome changes. See the examples below for common tasks.\n\nCookbook\n--------\n\nAfter installing MariaDB system-wide the first thing you’ve got used to doing\nis logging in into the unprotected root account and protecting it, that is,\nsetting the root password:\n\n$ sudo dnf install MariaDB-server\n$ mysql -uroot\n...\nMariaDB> set password = password(\"XH4VmT3_jt\");\n\nThis is not only unnecessary now, it will simply not work — there is no\nunprotected root account. To login as root use\n\n$ sudo dnf install MariaDB-server\n$ sudo mysql\n\nNote that it implies you are connecting via the unix socket, not tcp. If you\nhappen to have protocol=tcp in a system-wide /etc/my.cnf file, use sudo mysql\n--protocol=socket.\n\nAfter installing MariaDB locally you’ve also used to connect to the\nunprotected root account using mysql -uroot. This will not work either, simply\nuse mysql without specifying a username.\n\nIf you\'ve forgotten your root password, no problem — you can still connect\nusing sudo and change the password. And if you\'ve also removed unix_socket\nauthentication, to restore access do as follows:\n\n* restart MariaDB with --skip-grant-tables\n* login into the unprotected server\n* run FLUSH PRIVILEGES (note, before 10.4 this would’ve been the last step,\nnot anymore). This disables --skip-grant-tables and allows you to change the\nstored authentication method\n* run SET PASSWORD FOR root@localhost to change the root password.\n\nTo view inside privilege tables, the old mysql.user table still exists. You\ncan select from it as before, although you cannot update it anymore. It\ndoesn’t show alternative authentication plugins and this was one of the\nreasons for switching to the mysql.global_priv table — complex authentication\nrules did not fit into rigid structure of a relational table. You can select\nfrom the new table, for example:\n\nselect concat(user, \'@\', host, \' => \', json_detailed(priv)) from\nmysql.global_priv;\n\nReverting to the Previous Authentication Method for root@localhost\n------------------------------------------------------------------\n\nIf you don\'t want the root@localhost user account created by mysql_install_db\nto use unix_socket authentication by default, then there are a few ways to\nrevert to the previous mysql_native_password authentication method for this\nuser account.\n\nConfiguring mysql_install_db to Revert to the Previous Authentication Method\n----------------------------------------------------------------------------\n\nOne way to revert to the previous mysql_native_password authentication method\nfor the root@localhost user account is to execute mysql_install_db with a\nspecial option. If mysql_install_db is executed while\n--auth-root-authentication-method=normal is specified, then it will create the\ndefault user accounts using the default behavior of MariaDB 10.3 and before.\n\nThis means that the root@localhost user account will use mysql_native_password\nauthentication by default. There are some other differences as well. See\nmysql_install_db: User Accounts Created by Default for more information.\n\nFor example, the option can be set on the command-line while running\nmysql_install_db:\n\nmysql_install_db --user=mysql --datadir=/var/lib/mysql\n--auth-root-authentication-method=normal\n\nThe option can also be set in an option file in an option group supported by\nmysql_install_db. For example:\n\n[mysql_install_db]\nauth_root_authentication_method=normal\n\nIf the option is set in an option file and if mysql_install_db is executed,\nthen mysql_install_db will read this option from the option file, and it will\nautomatically set this option.\n\nAltering the User Account to Revert to the Previous Authentication Method\n-------------------------------------------------------------------------\n\nIf you have already installed MariaDB, and if the root@localhost user account\nis already using unix_socket authentication, then you can revert to the old\nmysql_native_password authentication method for the user account by executing\nthe following:\n\nALTER USER root@localhost IDENTIFIED VIA mysql_native_password USING\nPASSWORD(\"verysecret\")\n\nURL: https://mariadb.com/kb/en/authentication-from-mariadb-104/','','https://mariadb.com/kb/en/authentication-from-mariadb-104/'),(119,'ST_X',11,'Syntax\n------\n\nST_X(p)\nX(p)\n\nDescription\n-----------\n\nReturns the X-coordinate value for the point p as a double-precision number.\n\nST_X() and X() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT X(GeomFromText(@pt));\n+----------------------+\n| X(GeomFromText(@pt)) |\n+----------------------+\n|                 56.7 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_x/','','https://mariadb.com/kb/en/st_x/'),(88,'IF Function',7,'Syntax\n------\n\nIF(expr1,expr2,expr3)\n\nDescription\n-----------\n\nIf expr1 is TRUE (expr1 <> 0 and expr1 <> NULL) then IF() returns expr2;\notherwise it returns expr3. IF() returns a numeric or string value, depending\non the context in which it is used.\n\nNote: There is also an IF statement which differs from the IF() function\ndescribed here.\n\nExamples\n--------\n\nSELECT IF(1>2,2,3);\n+-------------+\n| IF(1>2,2,3) |\n+-------------+\n|           3 |\n+-------------+\n\nSELECT IF(1<2,\'yes\',\'no\');\n+--------------------+\n| IF(1<2,\'yes\',\'no\') |\n+--------------------+\n| yes                |\n+--------------------+\n\nSELECT IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\');\n+---------------------------------------+\n| IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\') |\n+---------------------------------------+\n| no                                    |\n+---------------------------------------+\n\nURL: https://mariadb.com/kb/en/if-function/','','https://mariadb.com/kb/en/if-function/'),(89,'IFNULL',7,'Syntax\n------\n\nIFNULL(expr1,expr2)\nNVL(expr1,expr2)\n\nDescription\n-----------\n\nIf expr1 is not NULL, IFNULL() returns expr1; otherwise it returns expr2.\nIFNULL() returns a numeric or string value, depending on the context in which\nit is used.\n\nFrom MariaDB 10.3, NVL() is an alias for IFNULL().\n\nExamples\n--------\n\nSELECT IFNULL(1,0); \n+-------------+\n| IFNULL(1,0) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT IFNULL(NULL,10);\n+-----------------+\n| IFNULL(NULL,10) |\n+-----------------+\n|              10 |\n+-----------------+\n\nSELECT IFNULL(1/0,10);\n+----------------+\n| IFNULL(1/0,10) |\n+----------------+\n|        10.0000 |\n+----------------+\n\nSELECT IFNULL(1/0,\'yes\');\n+-------------------+\n| IFNULL(1/0,\'yes\') |\n+-------------------+\n| yes               |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/ifnull/','','https://mariadb.com/kb/en/ifnull/'),(94,'START TRANSACTION',8,'Syntax\n------\n\nSTART TRANSACTION [transaction_property [, transaction_property] ...] | BEGIN\n[WORK]\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nROLLBACK [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nSET autocommit = {0 | 1}\n\ntransaction_property:\n  WITH CONSISTENT SNAPSHOT\n | READ WRITE\n | READ ONLY\n\nDescription\n-----------\n\nThe START TRANSACTION or BEGIN statement begins a new transaction. COMMIT\ncommits the current transaction, making its changes permanent. ROLLBACK rolls\nback the current transaction, canceling its changes. The SET autocommit\nstatement disables or enables the default autocommit mode for the current\nsession.\n\nSTART TRANSACTION and SET autocommit = 1 implicitly commit the current\ntransaction, if any.\n\nThe optional WORK keyword is supported for COMMIT and ROLLBACK, as are the\nCHAIN and RELEASE clauses. CHAIN and RELEASE can be used for additional\ncontrol over transaction completion. The value of the completion_type system\nvariable determines the default completion behavior.\n\nThe AND CHAIN clause causes a new transaction to begin as soon as the current\none ends, and the new transaction has the same isolation level as the\njust-terminated transaction. The RELEASE clause causes the server to\ndisconnect the current client session after terminating the current\ntransaction. Including the NO keyword suppresses CHAIN or RELEASE completion,\nwhich can be useful if the completion_type system variable is set to cause\nchaining or release completion by default.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can perform DDL\nstatements on temporary tables.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the SET TRANSACTION\nstatement, in which case the specified mode is valid for all sessions, or for\nall subsequent transaction used by the current session.\n\nautocommit\n----------\n\nBy default, MariaDB runs with autocommit mode enabled. This means that as soon\nas you execute a statement that updates (modifies) a table, MariaDB stores the\nupdate on disk to make it permanent. To disable autocommit mode, use the\nfollowing statement:\n\nSET autocommit=0;\n\nAfter disabling autocommit mode by setting the autocommit variable to zero,\nchanges to transaction-safe tables (such as those for InnoDB or NDBCLUSTER)\nare not made permanent immediately. You must use COMMIT to store your changes\nto disk or ROLLBACK to ignore the changes.\n\nTo disable autocommit mode for a single series of statements, use the START\nTRANSACTION statement.\n\nDDL Statements\n--------------\n\nDDL statements (CREATE, ALTER, DROP) and administrative statements (FLUSH,\nRESET, OPTIMIZE, ANALYZE, CHECK, REPAIR, CACHE INDEX), transaction management\nstatements (BEGIN, START TRANSACTION) and LOAD DATA INFILE, cause an implicit\nCOMMIT and start a new transaction. An exception to this rule are the DDL that\noperate on temporary tables: you can CREATE, ALTER and DROP them without\ncausing any COMMIT, but those actions cannot be rolled back. This means that\nif you call ROLLBACK, the temporary tables you created in the transaction will\nremain, while the rest of the transaction will be rolled back.\n\nTransactions cannot be used in Stored Functions or Triggers. In Stored\nProcedures and Events BEGIN is not allowed, so you should use START\nTRANSACTION instead.\n\nA transaction acquires a metadata lock on every table it accesses to prevent\nother connections from altering their structure. The lock is released at the\nend of the transaction. This happens even with non-transactional storage\nengines (like MEMORY or CONNECT), so it makes sense to use transactions with\nnon-transactional tables.\n\nin_transaction\n--------------\n\nThe in_transaction system variable is a session-only, read-only variable that\nreturns 1 inside a transaction, and 0 if not in a transaction.\n\nWITH CONSISTENT SNAPSHOT\n------------------------\n\nThe WITH CONSISTENT SNAPSHOT option starts a consistent read for storage\nengines such as InnoDB that can do so, the same as if a START TRANSACTION\nfollowed by a SELECT from any InnoDB table was issued.\n\nSee Enhancements for START TRANSACTION WITH CONSISTENT SNAPSHOT.\n\nExamples\n--------\n\nSTART TRANSACTION;\nSELECT @A:=SUM(salary) FROM table1 WHERE type=1;\nUPDATE table2 SET summary=@A WHERE type=1;\nCOMMIT;\n\nURL: https://mariadb.com/kb/en/start-transaction/','','https://mariadb.com/kb/en/start-transaction/'),(120,'ST_Y',11,'Syntax\n------\n\nST_Y(p)\nY(p)\n\nDescription\n-----------\n\nReturns the Y-coordinate value for the point p as a double-precision number.\n\nST_Y() and Y() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT Y(GeomFromText(@pt));\n+----------------------+\n| Y(GeomFromText(@pt)) |\n+----------------------+\n|                53.34 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_y/','','https://mariadb.com/kb/en/st_y/'),(121,'X',11,'A synonym for ST_X.\n\nURL: https://mariadb.com/kb/en/point-properties-x/','','https://mariadb.com/kb/en/point-properties-x/'),(122,'Y',11,'A synonym for ST_Y.\n\nURL: https://mariadb.com/kb/en/point-properties-y/','','https://mariadb.com/kb/en/point-properties-y/'),(125,'DECODE_ORACLE',12,'MariaDB starting with 10.3.2\n----------------------------\nDECODE_ORACLE is a synonym for the Oracle mode version of the DECODE function,\nand is available in all modes.\n\nURL: https://mariadb.com/kb/en/decode_oracle/','','https://mariadb.com/kb/en/decode_oracle/'),(93,'SET TRANSACTION',8,'Syntax\n------\n\nSET [GLOBAL | SESSION] TRANSACTION\n  transaction_property [, transaction_property] ...\n\ntransaction_property:\n  ISOLATION LEVEL level\n | READ WRITE\n | READ ONLY\n\nlevel:\n  REPEATABLE READ\n | READ COMMITTED\n | READ UNCOMMITTED\n | SERIALIZABLE\n\nDescription\n-----------\n\nThis statement sets the transaction isolation level or the transaction access\nmode globally, for the current session, or for the next transaction:\n\n* With the GLOBAL keyword, the statement sets the default\n transaction level globally for all subsequent sessions. Existing sessions are\n unaffected.\n* With the SESSION keyword, the statement sets the default\n transaction level for all subsequent transactions performed within the\n current session.\n* Without any SESSION or GLOBAL keyword,\n the statement sets the isolation level for the next (not started) transaction\n performed within the current session.\n\nA change to the global default isolation level requires the SUPER privilege.\nAny session is free to change its session isolation level (even in the middle\nof a transaction), or the isolation level for its next transaction.\n\nIsolation Level\n---------------\n\nTo set the global default isolation level at server startup, use the\n--transaction-isolation=level option on the command line or in an option file.\nValues of level for this option use dashes rather than spaces, so the\nallowable values are READ-UNCOMMITTED, READ-COMMITTED, REPEATABLE-READ, or\nSERIALIZABLE. For example, to set the default isolation level to REPEATABLE\nREAD, use these lines in the [mysqld] section of an option file:\n\n[mysqld]\ntransaction-isolation = REPEATABLE-READ\nTo determine the global and session transaction isolation levels at runtime,\ncheck the value of the tx_isolation system variable:\n\nSELECT @@GLOBAL.tx_isolation, @@tx_isolation;\n\nInnoDB supports each of the translation isolation levels described here using\ndifferent locking strategies. The default level is REPEATABLE READ. For\nadditional information about InnoDB record-level locks and how it uses them to\nexecute various types of statements, see InnoDB Lock Modes, and\nhttp://dev.mysql.com/doc/refman/en/innodb-locks-set.html.\n\nIsolation Levels\n----------------\n\nThe following sections describe how MariaDB supports the different transaction\nlevels.\n\nREAD UNCOMMITTED\n----------------\n\nSELECT statements are performed in a non-locking fashion, but a possible\nearlier version of a row might be used. Thus, using this isolation level, such\nreads are not consistent. This is also called a \"dirty read.\" Otherwise, this\nisolation level works like READ COMMITTED.\n\nREAD COMMITTED\n--------------\n\nA somewhat Oracle-like isolation level with respect to consistent\n(non-locking) reads: Each consistent read, even within the same transaction,\nsets and reads its own fresh snapshot. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), InnoDB locks\nonly index records, not the gaps before them, and thus allows the free\ninsertion of new records next to locked records. For UPDATE and DELETE\nstatements, locking depends on whether the statement uses a unique index with\na unique search condition (such as WHERE id = 100), or a range-type search\ncondition (such as WHERE id > 100). For a unique index with a unique search\ncondition, InnoDB locks only the index record found, not the gap before it.\nFor range-type searches, InnoDB locks the index range scanned, using gap locks\nor next-key (gap plus index-record) locks to block insertions by other\nsessions into the gaps covered by the range. This is necessary because\n\"phantom rows\" must be blocked for MySQL replication and recovery to work.\n\nNote: If the READ COMMITTED isolation level is used or the\ninnodb_locks_unsafe_for_binlog system variable is enabled, there is no InnoDB\ngap locking except for foreign-key constraint checking and duplicate-key\nchecking. Also, record locks for non-matching rows are released after MariaDB\nhas evaluated the WHERE condition.If you use READ COMMITTED or enable\ninnodb_locks_unsafe_for_binlog, you must use row-based binary logging.\n\nREPEATABLE READ\n---------------\n\nThis is the default isolation level for InnoDB. For consistent reads, there is\nan important difference from the READ COMMITTED isolation level: All\nconsistent reads within the same transaction read the snapshot established by\nthe first read. This convention means that if you issue several plain\n(non-locking) SELECT statements within the same transaction, these SELECT\nstatements are consistent also with respect to each other. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), UPDATE, and\nDELETE statements, locking depends on whether the statement uses a unique\nindex with a unique search condition, or a range-type search condition. For a\nunique index with a unique search condition, InnoDB locks only the index\nrecord found, not the gap before it. For other search conditions, InnoDB locks\nthe index range scanned, using gap locks or next-key (gap plus index-record)\nlocks to block insertions by other sessions into the gaps covered by the range.\n\nThis is the minimum isolation level for non-distributed XA transactions.\n\nSERIALIZABLE\n------------\n\nThis level is like REPEATABLE READ, but InnoDB implicitly converts all plain\nSELECT statements to SELECT ... LOCK IN SHARE MODE if autocommit is disabled.\nIf autocommit is enabled, the SELECT is its own transaction. It therefore is\nknown to be read only and can be serialized if performed as a consistent\n(non-locking) read and need not block for other transactions. (This means that\nto force a plain SELECT to block if other transactions have modified the\nselected rows, you should disable autocommit.)\n\nDistributed XA transactions should always use this isolation level.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can perform DDL\nstatements on temporary tables.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the START TRANSACTION\nstatement, in which case the specified mode is only valid for one transaction.\n\nExamples\n--------\n\nSET GLOBAL TRANSACTION ISOLATION LEVEL SERIALIZABLE;\n\nAttempting to set the isolation level within an existing transaction without\nspecifying GLOBAL or SESSION.\n\nSTART TRANSACTION;\n\nSET TRANSACTION ISOLATION LEVEL SERIALIZABLE;\nERROR 1568 (25001): Transaction characteristics can\'t be changed while a\ntransaction is in progress\n\nURL: https://mariadb.com/kb/en/set-transaction/','','https://mariadb.com/kb/en/set-transaction/'),(126,'AES_DECRYPT',12,'Syntax\n------\n\nAES_DECRYPT(crypt_str,key_str)\n\nDescription\n-----------\n\nThis function allows decryption of data using the official AES (Advanced\nEncryption Standard) algorithm. For more information, see the description of\nAES_ENCRYPT().\n\nURL: https://mariadb.com/kb/en/aes_decrypt/','','https://mariadb.com/kb/en/aes_decrypt/'),(133,'MD5',12,'Syntax\n------\n\nMD5(str)\n\nDescription\n-----------\n\nCalculates an MD5 128-bit checksum for the string.\n\nThe return value is a 32-hex digit string, and as of MariaDB 5.5, is a\nnonbinary string in the connection character set and collation, determined by\nthe values of the character_set_connection and collation_connection system\nvariables. Before 5.5, the return value was a binary string.\n\nNULL is returned if the argument was NULL.\n\nExamples\n--------\n\nSELECT MD5(\'testing\');\n+----------------------------------+\n| MD5(\'testing\')                   |\n+----------------------------------+\n| ae2b1fca515949e5d54fb22b8ed95575 |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/md5/','','https://mariadb.com/kb/en/md5/'),(95,'COMMIT',8,'The COMMIT statement ends a transaction, saving any changes to the data so\nthat they become visible to subsequent transactions. Also, unlocks metadata\nchanged by current transaction. If autocommit is set to 1, an implicit commit\nis performed after each statement. Otherwise, all transactions which don\'t end\nwith an explicit COMMIT are implicitly rollbacked and the changes are lost.\nThe ROLLBACK statement can be used to do this explicitly.\n\nThe required syntax for the COMMIT statement is as follows:\n\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\n\nCOMMIT is the more important transaction terminator, as well as the more\ninteresting one. The basic form of the COMMIT statement is simply the keyword\nCOMMIT (the keyword WORK is simply noise and can be omitted without changing\nthe effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated.\n\nRELEASE tells the server to disconnect the client immediately after the\ncurrent transaction.\n\nThere are NO RELEASE and AND NO CHAIN options. By default, commits do not\nRELEASE or CHAIN, but it\'s possible to change this default behavior with the\ncompletion_type server system variable. In this case, the AND NO CHAIN and NO\nRELEASE options override the server default.\n\nURL: https://mariadb.com/kb/en/commit/','','https://mariadb.com/kb/en/commit/'),(96,'ROLLBACK',8,'The ROLLBACK statement rolls back (ends) a transaction, destroying any changes\nto SQL-data so that they never become visible to subsequent transactions. The\nrequired syntax for the ROLLBACK statement is as follows.\n\nROLLBACK [ WORK ] [ AND [ NO ] CHAIN ] \n[ TO [ SAVEPOINT ] {<savepoint name> | <simple target specification>} ]\n\nThe ROLLBACK statement will either end a transaction, destroying all data\nchanges that happened during any of the transaction, or it will just destroy\nany data changes that happened since you established a savepoint. The basic\nform of the ROLLBACK statement is just the keyword ROLLBACK (the keyword WORK\nis simply noise and can be omitted without changing the effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated. The AND NO CHAIN option just tells your DBMS to end the\ntransaction — that is, these four SQL statements are equivalent:\n\nROLLBACK; \nROLLBACK WORK; \nROLLBACK AND NO CHAIN; \nROLLBACK WORK AND NO CHAIN;\n\nAll of them end a transaction without saving any transaction characteristics.\nThe only other options, the equivalent statements:\n\nROLLBACK AND CHAIN;\nROLLBACK WORK AND CHAIN;\n\nboth tell your DBMS to end a transaction, but to save that transaction\'s\ncharacteristics for the next transaction.\n\nROLLBACK is much simpler than COMMIT: it may involve no more than a few\ndeletions (of Cursors, locks, prepared SQL statements and log-file entries).\nIt\'s usually assumed that ROLLBACK can\'t fail, although such a thing is\nconceivable (for example, an encompassing transaction might reject an attempt\nto ROLLBACK because it\'s lining up for a COMMIT).\n\nROLLBACK cancels all effects of a transaction. It does not cancel effects on\nobjects outside the DBMS\'s control (for example the values in host program\nvariables or the settings made by some SQL/CLI function calls). But in\ngeneral, it is a convenient statement for those situations when you say \"oops,\nthis isn\'t working\" or when you simply don\'t care whether your temporary work\nbecomes permanent or not.\n\nHere is a moot question. If all you\'ve been doing is SELECTs, so that there\nhave been no data changes, should you end the transaction with ROLLBACK or\nCOMMIT? It shouldn\'t really matter because both ROLLBACK and COMMIT do the\nsame transaction-terminating job. However, the popular conception is that\nROLLBACK implies failure, so after a successful series of SELECT statements\nthe convention is to end the transaction with COMMIT rather than ROLLBACK.\n\nMariaDB (and most other DBMSs) supports rollback of SQL-data change\nstatements, but not of SQL-Schema statements. This means that if you use any\nof CREATE, ALTER, DROP, GRANT, REVOKE, you are implicitly committing at\nexecution time.\n\nINSERT INTO Table_2 VALUES(5); \nDROP TABLE Table_3 CASCADE; \nROLLBACK;\n\nThe result will be that both the INSERT and the DROP will go through as\nseparate transactions so the ROLLBACK will have no effect.\n\nURL: https://mariadb.com/kb/en/rollback/','','https://mariadb.com/kb/en/rollback/'),(138,'ENDPOINT',13,'A synonym for ST_ENDPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-endpoint/','','https://mariadb.com/kb/en/linestring-properties-endpoint/'),(139,'GLENGTH',13,'Syntax\n------\n\nGLength(ls)\n\nDescription\n-----------\n\nReturns as a double-precision number the length of the LineString value ls in\nits associated spatial reference.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT GLength(GeomFromText(@ls));\n+----------------------------+\n| GLength(GeomFromText(@ls)) |\n+----------------------------+\n|           2.82842712474619 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/glength/','','https://mariadb.com/kb/en/glength/'),(140,'NumPoints',13,'A synonym for ST_NumPoints.\n\nURL: https://mariadb.com/kb/en/linestring-properties-numpoints/','','https://mariadb.com/kb/en/linestring-properties-numpoints/'),(141,'PointN',13,'A synonym for ST_PointN.\n\nURL: https://mariadb.com/kb/en/linestring-properties-pointn/','','https://mariadb.com/kb/en/linestring-properties-pointn/'),(142,'STARTPOINT',13,'A synonym for ST_STARTPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-startpoint/','','https://mariadb.com/kb/en/linestring-properties-startpoint/'),(143,'ST_ENDPOINT',13,'Syntax\n------\n\nST_EndPoint(ls)\nEndPoint(ls)\n\nDescription\n-----------\n\nReturns the Point that is the endpoint of the LineString value ls.\n\nST_EndPoint() and EndPoint() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(EndPoint(GeomFromText(@ls)));\n+-------------------------------------+\n| AsText(EndPoint(GeomFromText(@ls))) |\n+-------------------------------------+\n| POINT(3 3)                          |\n+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_endpoint/','','https://mariadb.com/kb/en/st_endpoint/'),(144,'ST_NUMPOINTS',13,'Syntax\n------\n\nST_NumPoints(ls)\nNumPoints(ls)\n\nDescription\n-----------\n\nReturns the number of Point objects in the LineString value ls.\n\nST_NumPoints() and NumPoints() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT NumPoints(GeomFromText(@ls));\n+------------------------------+\n| NumPoints(GeomFromText(@ls)) |\n+------------------------------+\n|                            3 |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/st_numpoints/','','https://mariadb.com/kb/en/st_numpoints/'),(97,'LOCK TABLES',8,'Syntax\n------\n\nLOCK TABLE[S]\n  tbl_name [[AS] alias] lock_type\n  [, tbl_name [[AS] alias] lock_type] ...\n  [WAIT n|NOWAIT]\n\nlock_type:\n  READ [LOCAL]\n | [LOW_PRIORITY] WRITE\n | WRITE CONCURRENT\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nThe lock_type can be one of:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| READ                      | Read lock, no writes allowed                   |\n+---------------------------+------------------------------------------------+\n| READ LOCAL                | Read lock, but allow concurrent inserts        |\n+---------------------------+------------------------------------------------+\n| WRITE                     | Exclusive write lock. No other connections     |\n|                           | can read or write to this table                |\n+---------------------------+------------------------------------------------+\n| LOW_PRIORITY WRITE        | Exclusive write lock, but allow new read       |\n|                           | locks on the table until we get the write      |\n|                           | lock.                                          |\n+---------------------------+------------------------------------------------+\n| WRITE CONCURRENT          | Exclusive write lock, but allow READ LOCAL     |\n|                           | locks to the table.                            |\n+---------------------------+------------------------------------------------+\n\nMariaDB enables client sessions to acquire table locks explicitly for the\npurpose of cooperating with other sessions for access to tables, or to prevent\nother sessions from modifying tables during periods when a session requires\nexclusive access to them. A session can acquire or release locks only for\nitself. One session cannot acquire locks for another session or release locks\nheld by another session.\n\nLocks may be used to emulate transactions or to get more speed when updating\ntables.\n\nLOCK TABLES explicitly acquires table locks for the current client session.\nTable locks can be acquired for base tables or views. To use LOCK TABLES, you\nmust have the LOCK TABLES privilege, and the SELECT privilege for each object\nto be locked. See GRANT\n\nFor view locking, LOCK TABLES adds all base tables used in the view to the set\nof tables to be locked and locks them automatically. If you lock a table\nexplicitly with LOCK TABLES, any tables used in triggers are also locked\nimplicitly, as described in Triggers and Implicit Locks.\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\n\nMariaDB starting with 10.3.0\n----------------------------\n\nWAIT/NOWAIT\n-----------\n\nSet the lock wait timeout. See WAIT and NOWAIT.\n\nLimitations\n-----------\n\n* LOCK TABLES doesn\'t work when using Galera cluster.   You may experience\ncrashes or locks when used with Galera.\n* LOCK TABLES works on XtraDB/InnoDB tables only if the innodb_table_locks\nsystem variable is set to 1 (the default) and autocommit is set to 0 (1 is\ndefault). Please note that no error message will be returned on LOCK TABLES\nwith innodb_table_locks = 0.\n* LOCK TABLES implicitly commits the active transaction, if any. Also,\nstarting a transaction always releases all table locks acquired with LOCK\nTABLES. This means that there is no way to have table locks and an active\ntransaction at the same time. The only exceptions are the transactions in\nautocommit mode. To preserve the data integrity between transactional and\nnon-transactional tables, the GET_LOCK() function can be used.\n* When using LOCK TABLES on a TEMPORARY table, it will always be locked with a\nWRITE lock.\n* While a connection holds an explicit read lock on a table, it cannot modify\nit. If you try, the following error will be produced:\n\nERROR 1099 (HY000): Table \'tab_name\' was locked with a READ lock and can\'t be\nupdated\n\n* While a connection holds an explicit lock on a table, it cannot access a\nnon-locked table. If you try, the following error will be produced:\n\nERROR 1100 (HY000): Table \'tab_name\' was not locked with LOCK TABLES\n\n* While a connection holds an explicit lock on a table, it cannot issue the\nfollowing: INSERT DELAYED, CREATE TABLE, CREATE TABLE ... LIKE, and DDL\nstatements involving stored programs and views (except for triggers). If you\ntry, the following error will be produced:\n\nERROR 1192 (HY000): Can\'t execute the given command because you have active\nlocked tables or an active transaction\n\n* LOCK TABLES can not be used in stored routines - if you try, the following\nerror will be produced on creation. This restriction was removed in MariaDB\n10.6.2:\n\nERROR 1314 (0A000): LOCK is not allowed in stored procedures\n\nURL: https://mariadb.com/kb/en/lock-tables/','','https://mariadb.com/kb/en/lock-tables/'),(145,'ST_POINTN',13,'Syntax\n------\n\nST_PointN(ls,N)\nPointN(ls,N)\n\nDescription\n-----------\n\nReturns the N-th Point in the LineString value ls. Points are numbered\nbeginning with 1.\n\nST_PointN() and PointN() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(PointN(GeomFromText(@ls),2));\n+-------------------------------------+\n| AsText(PointN(GeomFromText(@ls),2)) |\n+-------------------------------------+\n| POINT(2 2)                          |\n+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_pointn/','','https://mariadb.com/kb/en/st_pointn/'),(146,'ST_STARTPOINT',13,'Syntax\n------\n\nST_StartPoint(ls)\nStartPoint(ls)\n\nDescription\n-----------\n\nReturns the Point that is the start point of the LineString value ls.\n\nST_StartPoint() and StartPoint() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(StartPoint(GeomFromText(@ls)));\n+---------------------------------------+\n| AsText(StartPoint(GeomFromText(@ls))) |\n+---------------------------------------+\n| POINT(1 1)                            |\n+---------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_startpoint/','','https://mariadb.com/kb/en/st_startpoint/'),(150,'INET_ATON',14,'Syntax\n------\n\nINET_ATON(expr)\n\nDescription\n-----------\n\nGiven the dotted-quad representation of an IPv4 network address as a string,\nreturns an integer that represents the numeric value of the address. Addresses\nmay be 4- or 8-byte addresses.\n\nReturns NULL if the argument is not understood.\n\nExamples\n--------\n\nSELECT INET_ATON(\'192.168.1.1\');\n+--------------------------+\n| INET_ATON(\'192.168.1.1\') |\n+--------------------------+\n|               3232235777 |\n+--------------------------+\n\nThis is calculated as follows: 192 x 2563 + 168 x 256 2 + 1 x 256 + 1\n\nURL: https://mariadb.com/kb/en/inet_aton/','','https://mariadb.com/kb/en/inet_aton/'),(151,'INET_NTOA',14,'Syntax\n------\n\nINET_NTOA(expr)\n\nDescription\n-----------\n\nGiven a numeric IPv4 network address in network byte order (4 or 8 byte),\nreturns the dotted-quad representation of the address as a string.\n\nExamples\n--------\n\nSELECT INET_NTOA(3232235777);\n+-----------------------+\n| INET_NTOA(3232235777) |\n+-----------------------+\n| 192.168.1.1           |\n+-----------------------+\n\n192.168.1.1 corresponds to 3232235777 since 192 x 2563 + 168 x 256 2 + 1 x 256\n+ 1 = 3232235777\n\nURL: https://mariadb.com/kb/en/inet_ntoa/','','https://mariadb.com/kb/en/inet_ntoa/'),(98,'SAVEPOINT',8,'Syntax\n------\n\nSAVEPOINT identifier\nROLLBACK [WORK] TO [SAVEPOINT] identifier\nRELEASE SAVEPOINT identifier\n\nDescription\n-----------\n\nInnoDB supports the SQL statements SAVEPOINT, ROLLBACK TO SAVEPOINT, RELEASE\nSAVEPOINT and the optional WORK keyword for ROLLBACK.\n\nEach savepoint must have a legal MariaDB identifier. A savepoint is a named\nsub-transaction.\n\nNormally ROLLBACK undoes the changes performed by the whole transaction. When\nused with the TO clause, it undoes the changes performed after the specified\nsavepoint, and erases all subsequent savepoints. However, all locks that have\nbeen acquired after the save point will survive. RELEASE SAVEPOINT does not\nrollback or commit any changes, but removes the specified savepoint.\n\nWhen the execution of a trigger or a stored function begins, it is not\npossible to use statements which reference a savepoint which was defined from\nout of that stored program.\n\nWhen a COMMIT (including implicit commits) or a ROLLBACK statement (with no TO\nclause) is performed, they act on the whole transaction, and all savepoints\nare removed.\n\nErrors\n------\n\nIf COMMIT or ROLLBACK is issued and no transaction was started, no error is\nreported.\n\nIf SAVEPOINT is issued and no transaction was started, no error is reported\nbut no savepoint is created. When ROLLBACK TO SAVEPOINT or RELEASE SAVEPOINT\nis called for a savepoint that does not exist, an error like this is issued:\n\nERROR 1305 (42000): SAVEPOINT svp_name does not exist\n\nURL: https://mariadb.com/kb/en/savepoint/','','https://mariadb.com/kb/en/savepoint/'),(99,'Metadata Locking',8,'MariaDB supports metadata locking. This means that when a transaction\n(including XA transactions) uses a table, it locks its metadata until the end\nof transaction. Non-transactional tables are also locked, as well as views and\nobjects which are related to locked tables/views (stored functions, triggers,\netc). When a connection tries to use a DDL statement (like an ALTER TABLE)\nwhich modifies a table that is locked, that connection is queued, and has to\nwait until it\'s unlocked. Using savepoints and performing a partial rollback\ndoes not release metadata locks.\n\nLOCK TABLES ... WRITE are also queued. Some wrong statements which produce an\nerror may not need to wait for the lock to be freed.\n\nThe metadata lock\'s timeout is determined by the value of the\nlock_wait_timeout server system variable (in seconds). However, note that its\ndefault value is 31536000 (1 year, MariaDB <= 10.2.3), or 86400 (1 day,\nMariaDB >= 10.2.4). If this timeout is exceeded, the following error is\nreturned:\n\nERROR 1205 (HY000): Lock wait timeout exceeded; try restarting transaction\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table stores information about existing metadata locks.\n\nMariaDB starting with 10.5.2\n----------------------------\nFrom MariaDB 10.5, the Performance Schema metadata_locks table contains\nmetadata lock information.\n\nExample\n-------\n\nLet\'s use the following MEMORY (non-transactional) table:\n\nCREATE TABLE t (a INT) ENGINE = MEMORY;\n\nConnection 1 starts a transaction, and INSERTs a row into t:\n\nSTART TRANSACTION;\n\nINSERT INTO t SET a=1;\n\nt\'s metadata is now locked by connection 1. Connection 2 tries to alter t, but\nhas to wait:\n\nALTER TABLE t ADD COLUMN b INT;\n\nConnection 2\'s prompt is blocked now.\n\nNow connection 1 ends the transaction:\n\nCOMMIT;\n\n...and connection 2 finally gets the output of its command:\n\nQuery OK, 1 row affected (35.23 sec)\nRecords: 1  Duplicates: 0  Warnings: 0\n\nURL: https://mariadb.com/kb/en/metadata-locking/','','https://mariadb.com/kb/en/metadata-locking/'),(100,'Transaction Timeouts',8,'MariaDB has always had the wait_timeout and interactive_timeout settings,\nwhich close connections after a certain period of inactivity.\n\nHowever, these are by default set to a long wait period. In situations where\ntransactions may be started, but not committed or rolled back, more granular\ncontrol and a shorter timeout may be desirable so as to avoid locks being held\nfor too long.\n\nMariaDB 10.3 introduced three new variables to handle this situation.\n\n* idle_transaction_timeout (all transactions)\n* idle_write_transaction_timeout (write transactions - called\nidle_readwrite_transaction_timeout until MariaDB 10.3.2)\n* idle_readonly_transaction_timeout (read transactions)\n\nThese accept a time in seconds to time out, by closing the connection,\ntransactions that are idle for longer than this period. By default all are set\nto zero, or no timeout.\n\nidle_transaction_timeout affects all transactions,\nidle_write_transaction_timeout affects write transactions only and\nidle_readonly_transaction_timeout affects read transactions only. The latter\ntwo variables work independently. However, if either is set along with\nidle_transaction_timeout, the settings for idle_write_transaction_timeout or\nidle_readonly_transaction_timeout will take precedence.\n\nExamples\n--------\n\nSET SESSION idle_transaction_timeout=2;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 3 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nSET SESSION idle_write_transaction_timeout=2;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 3 seconds\nSELECT * FROM t;\nEmpty set (0.000 sec)\nINSERT INTO t VALUES(1);\n## wait 3 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nSET SESSION idle_transaction_timeout=2, SESSION\nidle_readonly_transaction_timeout=10;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n ## wait 3 seconds\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 11 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nURL: https://mariadb.com/kb/en/transaction-timeouts/','','https://mariadb.com/kb/en/transaction-timeouts/'),(152,'IS_FREE_LOCK',14,'Syntax\n------\n\nIS_FREE_LOCK(str)\n\nDescription\n-----------\n\nChecks whether the lock named str is free to use (that is, not locked).\nReturns 1 if the lock is free (no one is using the lock), 0 if the lock is in\nuse, and NULL if an error occurs (such as an incorrect argument, like an empty\nstring or NULL). str is case insensitive.\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table contains information about locks of this kind (as\nwell as metadata locks).\n\nStatements using the IS_FREE_LOCK function are not safe for statement-based\nreplication.\n\nURL: https://mariadb.com/kb/en/is_free_lock/','','https://mariadb.com/kb/en/is_free_lock/'),(156,'IS_IPV6',14,'Syntax\n------\n\nIS_IPV6(expr)\n\nDescription\n-----------\n\nReturns 1 if the expression is a valid IPv6 address specified as a string,\notherwise returns 0. Does not consider IPv4 addresses to be valid IPv6\naddresses.\n\nExamples\n--------\n\nSELECT IS_IPV6(\'48f3::d432:1431:ba23:846f\');\n+--------------------------------------+\n| IS_IPV6(\'48f3::d432:1431:ba23:846f\') |\n+--------------------------------------+\n|                                    1 |\n+--------------------------------------+\n1 row in set (0.02 sec)\n\nSELECT IS_IPV6(\'10.0.1.1\');\n+---------------------+\n| IS_IPV6(\'10.0.1.1\') |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/is_ipv6/','','https://mariadb.com/kb/en/is_ipv6/'),(157,'IS_USED_LOCK',14,'Syntax\n------\n\nIS_USED_LOCK(str)\n\nDescription\n-----------\n\nChecks whether the lock named str is in use (that is, locked). If so, it\nreturns the connection identifier of the client that holds the lock.\nOtherwise, it returns NULL. str is case insensitive.\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table contains information about locks of this kind (as\nwell as metadata locks).\n\nStatements using the IS_USED_LOCK function are not safe for statement-based\nreplication.\n\nURL: https://mariadb.com/kb/en/is_used_lock/','','https://mariadb.com/kb/en/is_used_lock/'),(102,'WAIT and NOWAIT',8,'MariaDB starting with 10.3.0\n----------------------------\nMariaDB 10.3.0 introduced extended syntax so that it is possible to set\ninnodb_lock_wait_timeout and lock_wait_timeout for the following statements:\n\nSyntax\n------\n\nALTER TABLE tbl_name [WAIT n|NOWAIT] ...\nCREATE ... INDEX ON tbl_name (index_col_name, ...) [WAIT n|NOWAIT] ...\nDROP INDEX ... [WAIT n|NOWAIT]\nDROP TABLE tbl_name [WAIT n|NOWAIT] ...\nLOCK TABLE ... [WAIT n|NOWAIT]\nOPTIMIZE TABLE tbl_name [WAIT n|NOWAIT]\nRENAME TABLE tbl_name [WAIT n|NOWAIT] ...\nSELECT ... FOR UPDATE [WAIT n|NOWAIT]\nSELECT ... LOCK IN SHARE MODE [WAIT n|NOWAIT]\nTRUNCATE TABLE tbl_name [WAIT n|NOWAIT]\n\nDescription\n-----------\n\nThe lock wait timeout can be explicitly set in the statement by using either\nWAIT n (to set the wait in seconds) or NOWAIT, in which case the statement\nwill immediately fail if the lock cannot be obtained. WAIT 0 is equivalent to\nNOWAIT.\n\nURL: https://mariadb.com/kb/en/wait-and-nowait/','','https://mariadb.com/kb/en/wait-and-nowait/'),(106,'DROP USER',10,'Syntax\n------\n\nDROP USER [IF EXISTS] user_name [, user_name] ...\n\nDescription\n-----------\n\nThe DROP USER statement removes one or more MariaDB accounts. It removes\nprivilege rows for the account from all grant tables. To use this statement,\nyou must have the global CREATE USER privilege or the DELETE privilege for the\nmysql database. Each account is named using the same format as for the CREATE\nUSER statement; for example, \'jeffrey\'@\'localhost\'. If you specify only the\nuser name part of the account name, a host name part of \'%\' is used. For\nadditional information about specifying account names, see CREATE USER.\n\nNote that, if you specify an account that is currently connected, it will not\nbe deleted until the connection is closed. The connection will not be\nautomatically closed.\n\nIf any of the specified user accounts do not exist, ERROR 1396 (HY000)\nresults. If an error occurs, DROP USER will still drop the accounts that do\nnot result in an error. Only one error is produced for all users which have\nnot been dropped:\n\nERROR 1396 (HY000): Operation DROP USER failed for \'u1\'@\'%\',\'u2\'@\'%\'\n\nFailed CREATE or DROP operations, for both users and roles, produce the same\nerror code.\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the user does not exist.\n\nExamples\n--------\n\nDROP USER bob;\n\nDROP USER foo2@localhost,foo2@\'127.%\';\n\nIF EXISTS:\n\nDROP USER bob;\nERROR 1396 (HY000): Operation DROP USER failed for \'bob\'@\'%\'\n\nDROP USER IF EXISTS bob;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+---------------------------------------------+\n| Level | Code | Message                                     |\n+-------+------+---------------------------------------------+\n| Note  | 1974 | Can\'t drop user \'bob\'@\'%\'; it doesn\'t exist |\n+-------+------+---------------------------------------------+\n\nURL: https://mariadb.com/kb/en/drop-user/','','https://mariadb.com/kb/en/drop-user/'),(108,'RENAME USER',10,'Syntax\n------\n\nRENAME USER old_user TO new_user\n  [, old_user TO new_user] ...\n\nDescription\n-----------\n\nThe RENAME USER statement renames existing MariaDB accounts. To use it, you\nmust have the global CREATE USER privilege or the UPDATE privilege for the\nmysql database. Each account is named using the same format as for the CREATE\nUSER statement; for example, \'jeffrey\'@\'localhost\'. If you specify only the\nuser name part of the account name, a host name part of \'%\' is used.\n\nIf any of the old user accounts do not exist or any of the new user accounts\nalready exist, ERROR 1396 (HY000) results. If an error occurs, RENAME USER\nwill still rename the accounts that do not result in an error.\n\nExamples\n--------\n\nCREATE USER \'donald\', \'mickey\';\nRENAME USER \'donald\' TO \'duck\'@\'localhost\', \'mickey\' TO \'mouse\'@\'localhost\';\n\nURL: https://mariadb.com/kb/en/rename-user/','','https://mariadb.com/kb/en/rename-user/'),(109,'REVOKE',10,'Privileges\n----------\n\nSyntax\n------\n\nREVOKE \n  priv_type [(column_list)]\n   [, priv_type [(column_list)]] ...\n  ON [object_type] priv_level\n  FROM user [, user] ...\n\nREVOKE ALL PRIVILEGES, GRANT OPTION\n  FROM user [, user] ...\n\nDescription\n-----------\n\nThe REVOKE statement enables system administrators to revoke privileges (or\nroles - see section below) from MariaDB accounts. Each account is named using\nthe same format as for the GRANT statement; for example,\n\'jeffrey\'@\'localhost\'. If you specify only the user name part of the account\nname, a host name part of \'%\' is used. For details on the levels at which\nprivileges exist, the allowable priv_type and priv_level values, and the\nsyntax for specifying users and passwords, see GRANT.\n\nTo use the first REVOKE syntax, you must have the GRANT OPTION privilege, and\nyou must have the privileges that you are revoking.\n\nTo revoke all privileges, use the second syntax, which drops all global,\ndatabase, table, column, and routine privileges for the named user or users:\n\nREVOKE ALL PRIVILEGES, GRANT OPTION FROM user [, user] ...\n\nTo use this REVOKE syntax, you must have the global CREATE USER privilege or\nthe UPDATE privilege for the mysql database. See GRANT.\n\nExamples\n--------\n\nREVOKE SUPER ON *.* FROM \'alexander\'@\'localhost\';\n\nRoles\n-----\n\nSyntax\n------\n\nREVOKE role  [, role ...]\n  FROM grantee [, grantee2 ... ]\n\nREVOKE ADMIN OPTION FOR role FROM grantee [, grantee2]\n\nDescription\n-----------\n\nREVOKE is also used to remove a role from a user or another role that it\'s\npreviously been assigned to. If a role has previously been set as a default\nrole, REVOKE does not remove the record of the default role from the\nmysql.user table. If the role is subsequently granted again, it will again be\nthe user\'s default. Use SET DEFAULT ROLE NONE to explicitly remove this.\n\nBefore MariaDB 10.1.13, the REVOKE role statement was not permitted in\nprepared statements.\n\nExample\n-------\n\nREVOKE journalist FROM hulda\n\nURL: https://mariadb.com/kb/en/revoke/','','https://mariadb.com/kb/en/revoke/'),(160,'NAME_CONST',14,'Syntax\n------\n\nNAME_CONST(name,value)\n\nDescription\n-----------\n\nReturns the given value. When used to produce a result set column,\nNAME_CONST() causes the column to have the given name. The arguments should be\nconstants.\n\nThis function is used internally when replicating stored procedures. It makes\nlittle sense to use it explicitly in SQL statements, and it was not supposed\nto be used like that.\n\nSELECT NAME_CONST(\'myname\', 14);\n+--------+\n| myname |\n+--------+\n|     14 |\n+--------+\n\nURL: https://mariadb.com/kb/en/name_const/','','https://mariadb.com/kb/en/name_const/'),(163,'SLEEP',14,'Syntax\n------\n\nSLEEP(duration)\n\nDescription\n-----------\n\nSleeps (pauses) for the number of seconds given by the duration argument, then\nreturns 0. If SLEEP() is interrupted, it returns 1. The duration may have a\nfractional part given in microseconds.\n\nStatements using the SLEEP() function are not safe for replication.\n\nExample\n-------\n\nSELECT SLEEP(5.5);\n+------------+\n| SLEEP(5.5) |\n+------------+\n|          0 |\n+------------+\n1 row in set (5.50 sec)\n\nURL: https://mariadb.com/kb/en/sleep/','','https://mariadb.com/kb/en/sleep/'),(167,'!',15,'Syntax\n------\n\nNOT, !\n\nDescription\n-----------\n\nLogical NOT. Evaluates to 1 if the operand is 0, to 0 if the operand is\nnon-zero, and NOT NULL returns NULL.\n\nBy default, the ! operator has a higher precedence. If the HIGH_NOT_PRECEDENCE\nSQL_MODE flag is set, NOT and ! have the same precedence.\n\nExamples\n--------\n\nSELECT NOT 10;\n+--------+\n| NOT 10 |\n+--------+\n|      0 |\n+--------+\n\nSELECT NOT 0;\n+-------+\n| NOT 0 |\n+-------+\n|     1 |\n+-------+\n\nSELECT NOT NULL;\n+----------+\n| NOT NULL |\n+----------+\n|     NULL |\n+----------+\n\nSELECT ! (1+1);\n+---------+\n| ! (1+1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ! 1+1;\n+-------+\n| ! 1+1 |\n+-------+\n|     1 |\n+-------+\n\nURL: https://mariadb.com/kb/en/not/','','https://mariadb.com/kb/en/not/'),(110,'SET PASSWORD',10,'Syntax\n------\n\nSET PASSWORD [FOR user] =\n  {\n    PASSWORD(\'some password\')\n   | OLD_PASSWORD(\'some password\')\n   | \'encrypted password\'\n  }\n\nDescription\n-----------\n\nThe SET PASSWORD statement assigns a password to an existing MariaDB user\naccount.\n\nIf the password is specified using the PASSWORD() or OLD_PASSWORD() function,\nthe literal text of the password should be given. If the password is specified\nwithout using either function, the password should be the already-encrypted\npassword value as returned by PASSWORD().\n\nOLD_PASSWORD() should only be used if your MariaDB/MySQL clients are very old\n(< 4.0.0).\n\nWith no FOR clause, this statement sets the password for the current user. Any\nclient that has connected to the server using a non-anonymous account can\nchange the password for that account.\n\nWith a FOR clause, this statement sets the password for a specific account on\nthe current server host. Only clients that have the UPDATE privilege for the\nmysql database can do this. The user value should be given in\nuser_name@host_name format, where user_name and host_name are exactly as they\nare listed in the User and Host columns of the mysql.user table (or view in\nMariaDB-10.4 onwards) entry.\n\nThe argument to PASSWORD() and the password given to MariaDB clients can be of\narbitrary length.\n\nAuthentication Plugin Support\n-----------------------------\n\nMariaDB starting with 10.4\n--------------------------\nIn MariaDB 10.4 and later, SET PASSWORD (with or without PASSWORD()) works for\naccounts authenticated via any authentication plugin that supports passwords\nstored in the mysql.global_priv table.\n\nThe ed25519, mysql_native_password, and mysql_old_password authentication\nplugins store passwords in the mysql.global_priv table.\n\nIf you run SET PASSWORD on an account that authenticates with one of these\nauthentication plugins that stores passwords in the mysql.global_priv table,\nthen the PASSWORD() function is evaluated by the specific authentication\nplugin used by the account. The authentication plugin hashes the password with\na method that is compatible with that specific authentication plugin.\n\nThe unix_socket, named_pipe, gssapi, and pam authentication plugins do not\nstore passwords in the mysql.global_priv table. These authentication plugins\nrely on other methods to authenticate the user.\n\nIf you attempt to run SET PASSWORD on an account that authenticates with one\nof these authentication plugins that doesn\'t store a password in the\nmysql.global_priv table, then MariaDB Server will raise a warning like the\nfollowing:\n\nSET PASSWORD is ignored for users authenticating via unix_socket plugin\n\nSee Authentication from MariaDB 10.4 for an overview of authentication changes\nin MariaDB 10.4.\n\nMariaDB until 10.3\n------------------\nIn MariaDB 10.3 and before, SET PASSWORD (with or without PASSWORD()) only\nworks for accounts authenticated via mysql_native_password or\nmysql_old_password authentication plugins\n\nPasswordless User Accounts\n--------------------------\n\nUser accounts do not always require passwords to login.\n\nThe unix_socket , named_pipe and gssapi authentication plugins do not require\na password to authenticate the user.\n\nThe pam authentication plugin may or may not require a password to\nauthenticate the user, depending on the specific configuration.\n\nThe mysql_native_password and mysql_old_password authentication plugins\nrequire passwords for authentication, but the password can be blank. In that\ncase, no password is required.\n\nIf you provide a password while attempting to log into the server as an\naccount that doesn\'t require a password, then MariaDB server will simply\nignore the password.\n\nMariaDB starting with 10.4\n--------------------------\nIn MariaDB 10.4 and later, a user account can be defined to use multiple\nauthentication plugins in a specific order of preference. This specific\nscenario may be more noticeable in these versions, since an account could be\nassociated with some authentication plugins that require a password, and some\nthat do not.\n\nExample\n-------\n\nFor example, if you had an entry with User and Host column values of \'bob\' and\n\'%.loc.gov\', you would write the statement like this:\n\nSET PASSWORD FOR \'bob\'@\'%.loc.gov\' = PASSWORD(\'newpass\');\n\nIf you want to delete a password for a user, you would do:\n\nSET PASSWORD FOR \'bob\'@localhost = PASSWORD(\"\");\n\nURL: https://mariadb.com/kb/en/set-password/','','https://mariadb.com/kb/en/set-password/'),(112,'DROP ROLE',10,'Syntax\n------\n\nDROP ROLE [IF EXISTS] role_name [,role_name ...]\n\nDescription\n-----------\n\nThe DROP ROLE statement removes one or more MariaDB roles. To use this\nstatement, you must have the global CREATE USER privilege or the DELETE\nprivilege for the mysql database.\n\nDROP ROLE does not disable roles for connections which selected them with SET\nROLE. If a role has previously been set as a default role, DROP ROLE does not\nremove the record of the default role from the mysql.user table. If the role\nis subsequently recreated and granted, it will again be the user\'s default.\nUse SET DEFAULT ROLE NONE to explicitly remove this.\n\nIf any of the specified user accounts do not exist, ERROR 1396 (HY000)\nresults. If an error occurs, DROP ROLE will still drop the roles that do not\nresult in an error. Only one error is produced for all roles which have not\nbeen dropped:\n\nERROR 1396 (HY000): Operation DROP ROLE failed for \'a\',\'b\',\'c\'\n\nFailed CREATE or DROP operations, for both users and roles, produce the same\nerror code.\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a warning instead of an\nerror if the role does not exist.\n\nExamples\n--------\n\nDROP ROLE journalist;\n\nThe same thing using the optional IF EXISTS clause:\n\nDROP ROLE journalist;\nERROR 1396 (HY000): Operation DROP ROLE failed for \'journalist\'\n\nDROP ROLE IF EXISTS journalist;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nNote (Code 1975): Can\'t drop role \'journalist\'; it doesn\'t exist\n\nURL: https://mariadb.com/kb/en/drop-role/','','https://mariadb.com/kb/en/drop-role/'),(168,'&&',15,'Syntax\n------\n\nAND, &&\n\nDescription\n-----------\n\nLogical AND. Evaluates to 1 if all operands are non-zero and not NULL, to 0 if\none or more operands are 0, otherwise NULL is returned.\n\nFor this operator, short-circuit evaluation can be used.\n\nExamples\n--------\n\nSELECT 1 && 1;\n+--------+\n| 1 && 1 |\n+--------+\n|      1 |\n+--------+\n\nSELECT 1 && 0;\n+--------+\n| 1 && 0 |\n+--------+\n|      0 |\n+--------+\n\nSELECT 1 && NULL;\n+-----------+\n| 1 && NULL |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT 0 && NULL;\n+-----------+\n| 0 && NULL |\n+-----------+\n|         0 |\n+-----------+\n\nSELECT NULL && 0;\n+-----------+\n| NULL && 0 |\n+-----------+\n|         0 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/and/','','https://mariadb.com/kb/en/and/'),(169,'XOR',15,'Syntax\n------\n\nXOR\n\nDescription\n-----------\n\nXOR stands for eXclusive OR. Returns NULL if either operand is NULL. For\nnon-NULL operands, evaluates to 1 if an odd number of operands is non-zero,\notherwise 0 is returned.\n\nExamples\n--------\n\nSELECT 1 XOR 1;\n+---------+\n| 1 XOR 1 |\n+---------+\n|       0 |\n+---------+\n\nSELECT 1 XOR 0;\n+---------+\n| 1 XOR 0 |\n+---------+\n|       1 |\n+---------+\n\nSELECT 1 XOR NULL;\n+------------+\n| 1 XOR NULL |\n+------------+\n|       NULL |\n+------------+\n\nIn the following example, the right 1 XOR 1 is evaluated first, and returns 0.\nThen, 1 XOR 0 is evaluated, and 1 is returned.\n\nSELECT 1 XOR 1 XOR 1;\n+---------------+\n| 1 XOR 1 XOR 1 |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/xor/','','https://mariadb.com/kb/en/xor/'),(111,'CREATE ROLE',10,'Syntax\n------\n\nCREATE [OR REPLACE] ROLE [IF NOT EXISTS] role \n [WITH ADMIN\n  {CURRENT_USER | CURRENT_ROLE | user | role}]\n\nDescription\n-----------\n\nThe CREATE ROLE statement creates one or more MariaDB roles. To use it, you\nmust have the global CREATE USER privilege or the INSERT privilege for the\nmysql database. For each account, CREATE ROLE creates a new row in the\nmysql.user table that has no privileges, and with the corresponding is_role\nfield set to Y. It also creates a record in the mysql.roles_mapping table.\n\nIf any of the specified roles already exist, ERROR 1396 (HY000) results. If an\nerror occurs, CREATE ROLE will still create the roles that do not result in an\nerror. The maximum length for a role is 128 characters. Role names can be\nquoted, as explained in the Identifier names page. Only one error is produced\nfor all roles which have not been created:\n\nERROR 1396 (HY000): Operation CREATE ROLE failed for \'a\',\'b\',\'c\'\n\nFailed CREATE or DROP operations, for both users and roles, produce the same\nerror code.\n\nPUBLIC and NONE are reserved, and cannot be used as role names. NONE is used\nto unset a role and PUBLIC has a special use in other systems, such as Oracle,\nso is reserved for compatibility purposes.\n\nFor valid identifiers to use as role names, see Identifier Names.\n\nWITH ADMIN\n----------\n\nThe optional WITH ADMIN clause determines whether the current user, the\ncurrent role or another user or role has use of the newly created role. If the\nclause is omitted, WITH ADMIN CURRENT_USER is treated as the default, which\nmeans that the current user will be able to GRANT this role to users.\n\nOR REPLACE\n----------\n\nIf the optional OR REPLACE clause is used, it acts as a shortcut for:\n\nDROP ROLE IF EXISTS name;\nCREATE ROLE name ...;\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified role already exists. Cannot be used together with\nthe OR REPLACE clause.\n\nExamples\n--------\n\nCREATE ROLE journalist;\n\nCREATE ROLE developer WITH ADMIN lorinda@localhost;\n\nGranting the role to another user. Only user lorinda@localhost has permission\nto grant the developer role:\n\nSELECT USER();\n+-------------------+\n| USER()            |\n+-------------------+\n| henning@localhost |\n+-------------------+\n...\nGRANT developer TO ian@localhost;\nAccess denied for user \'henning\'@\'localhost\'\n\nSELECT USER();\n+-------------------+\n| USER()            |\n+-------------------+\n| lorinda@localhost |\n+-------------------+\n\nGRANT m_role TO ian@localhost;\n\nThe OR REPLACE and IF NOT EXISTS clauses. The journalist role already exists:\n\nCREATE ROLE journalist;\nERROR 1396 (HY000): Operation CREATE ROLE failed for \'journalist\'\n\nCREATE OR REPLACE ROLE journalist;\nQuery OK, 0 rows affected (0.00 sec)\n\nCREATE ROLE IF NOT EXISTS journalist;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+---------------------------------------------------+\n| Level | Code | Message                                           |\n+-------+------+---------------------------------------------------+\n| Note  | 1975 | Can\'t create role \'journalist\'; it already exists |\n+-------+------+---------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/create-role/','','https://mariadb.com/kb/en/create-role/'),(113,'SET ROLE',10,'Syntax\n------\n\nSET ROLE { role | NONE }\n\nDescription\n-----------\n\nThe SET ROLE statement enables a role, along with all of its associated\npermissions, for the current session. To unset a role, use NONE .\n\nIf a role that doesn\'t exist, or to which the user has not been assigned, is\nspecified, an ERROR 1959 (OP000): Invalid role specification error occurs.\n\nAn automatic SET ROLE is implicitly performed when a user connects if that\nuser has been assigned a default role. See SET DEFAULT ROLE.\n\nExample\n-------\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| NULL         |\n+--------------+\n\nSET ROLE staff;\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| staff        |\n+--------------+\n\nSET ROLE NONE;\n\nSELECT CURRENT_ROLE();\n+----------------+\n| CURRENT_ROLE() |\n+----------------+\n| NULL           |\n+----------------+\n\nURL: https://mariadb.com/kb/en/set-role/','','https://mariadb.com/kb/en/set-role/'),(114,'SET DEFAULT ROLE',10,'Syntax\n------\n\nSET DEFAULT ROLE { role | NONE } [ FOR user@host ]\n\nDescription\n-----------\n\nThe SET DEFAULT ROLE statement sets a default role for a specified (or\ncurrent) user. A default role is automatically enabled when a user connects\n(an implicit SET ROLE statement is executed immediately after a connection is\nestablished).\n\nTo be able to set a role as a default, the role must already have been granted\nto that user, and one needs the privileges to enable this role (if you cannot\ndo SET ROLE X, you won\'t be able to do SET DEFAULT ROLE X). To set a default\nrole for another user one needs to have write access to the mysql database.\n\nTo remove a user\'s default role, use SET DEFAULT ROLE NONE [ FOR user@host ].\nThe record of the default role is not removed if the role is dropped or\nrevoked, so if the role is subsequently re-created or granted, it will again\nbe the user\'s default role.\n\nThe default role is stored in the default_role column in the mysql.user\ntable/view, as well as in the Information Schema APPLICABLE_ROLES table, so\nthese can be viewed to see which role has been assigned to a user as the\ndefault.\n\nExamples\n--------\n\nSetting a default role for the current user:\n\nSET DEFAULT ROLE journalist;\n\nRemoving a default role from the current user:\n\nSET DEFAULT ROLE NONE;\n\nSetting a default role for another user. The role has to have been granted to\nthe user before it can be set as default:\n\nCREATE ROLE journalist;\nCREATE USER taniel;\n\nSET DEFAULT ROLE journalist FOR taniel;\nERROR 1959 (OP000): Invalid role specification `journalist`\n\nGRANT journalist TO taniel;\nSET DEFAULT ROLE journalist FOR taniel;\n\nViewing mysql.user:\n\nselect * from mysql.user where user=\'taniel\'\\G\n*************************** 1. row ***************************\n         Host: %\n         User: taniel\n...\n       is_role: N\n     default_role: journalist\n...\n\nRemoving a default role for another user\n\nSET DEFAULT ROLE NONE FOR taniel;\n\nURL: https://mariadb.com/kb/en/set-default-role/','','https://mariadb.com/kb/en/set-default-role/'),(184,'STDDEV_SAMP',16,'Syntax\n------\n\nSTDDEV_SAMP(expr)\n\nDescription\n-----------\n\nReturns the sample standard deviation of expr (the square root of VAR_SAMP()).\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nSTDDEV_SAMP() can be used as a window function.\n\nSTDDEV_SAMP() returns NULL if there were no matching rows.\n\nURL: https://mariadb.com/kb/en/stddev_samp/','','https://mariadb.com/kb/en/stddev_samp/'),(189,'BENCHMARK',17,'Syntax\n------\n\nBENCHMARK(count,expr)\n\nDescription\n-----------\n\nThe BENCHMARK() function executes the expression expr repeatedly count times.\nIt may be used to time how quickly MariaDB processes the expression. The\nresult value is always 0. The intended use is from within the mysql client,\nwhich reports query execution times.\n\nExamples\n--------\n\nSELECT BENCHMARK(1000000,ENCODE(\'hello\',\'goodbye\'));\n+----------------------------------------------+\n| BENCHMARK(1000000,ENCODE(\'hello\',\'goodbye\')) |\n+----------------------------------------------+\n|                                            0 |\n+----------------------------------------------+\n1 row in set (0.21 sec)\n\nURL: https://mariadb.com/kb/en/benchmark/','','https://mariadb.com/kb/en/benchmark/'),(115,'Roles Overview',10,'Description\n-----------\n\nA role bundles a number of privileges together. It assists larger\norganizations where, typically, a number of users would have the same\nprivileges, and, previously, the only way to change the privileges for a group\nof users was by changing each user\'s privileges individually.\n\nAlternatively, multiple external users could have been assigned the same user,\nand there would have been no way to see which actual user was responsible for\nwhich action.\n\nWith roles, managing this is easy. For example, there could be a number of\nusers assigned to a journalist role, with identical privileges. Changing the\nprivileges for all the journalists is a matter of simply changing the role\'s\nprivileges, while the individual user is still linked with any changes that\ntake place.\n\nRoles are created with the CREATE ROLE statement, and dropped with the DROP\nROLE statement. Roles are then assigned to a user with an extension to the\nGRANT statement, while privileges are assigned to a role in the regular way\nwith GRANT. Similarly, the REVOKE statement can be used to both revoke a role\nfrom a user, or revoke a privilege from a role.\n\nOnce a user has connected, he can obtain all privileges associated with a role\nby setting a role with the SET ROLE statement. The CURRENT_ROLE function\nreturns the currently set role for the session, if any.\n\nOnly roles granted directly to a user can be set, roles granted to other roles\ncannot. Instead the privileges granted to a role, which is, in turn, granted\nto another role (grantee), will be immediately available to any user who sets\nthis second grantee role.\n\nThe SET DEFAULT ROLE statement allows one to set a default role for a user. A\ndefault role is automatically enabled when a user connects (an implicit SET\nROLE statement is executed immediately after a connection is established).\n\nRoles were implemented as a GSoC 2013 project by Vicentiu Ciorbaru.\n\nSystem Tables\n-------------\n\nInformation about roles and who they\'ve been granted to can be found in the\nInformation Schema APPLICABLE_ROLES table as well as the mysql.ROLES_MAPPING\ntable.\n\nThe Information Schema ENABLED_ROLES table shows the enabled roles for the\ncurrent session.\n\nExamples\n--------\n\nCreating a role and granting a privilege:\n\nCREATE ROLE journalist;\n\nGRANT SHOW DATABASES ON *.* TO journalist;\n\nGRANT journalist to hulda;\n\nNote, that hulda has no SHOW DATABASES privilege, even though she was granted\nthe journalist role. She needs to set the role first:\n\nSHOW DATABASES;\n+--------------------+\n| Database           |\n+--------------------+\n| information_schema |\n+--------------------+\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| NULL         |\n+--------------+\n\nSET ROLE journalist;\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| journalist   |\n+--------------+\n\nSHOW DATABASES;\n+--------------------+\n| Database           |\n+--------------------+\n| ...                |\n| information_schema |\n| mysql              |\n| performance_schema |\n| test               |\n| ...                |\n+--------------------+\n\nSET ROLE NONE;\n\nRoles can be granted to roles:\n\nCREATE ROLE writer;\n\nGRANT SELECT ON data.* TO writer;\n\nGRANT writer TO journalist;\n\nBut one does not need to set a role granted to a role. For example, hulda will\nautomatically get all writer privileges when she sets the journalist role:\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| NULL         |\n+--------------+\n\nSHOW TABLES FROM data;\nEmpty set (0.01 sec)\n\nSET ROLE journalist;\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| journalist   |\n+--------------+\n\nSHOW TABLES FROM data;\n+------------------------------+\n| Tables_in_data               |\n+------------------------------+\n| set1                         |\n| ...                          |\n+------------------------------+\n\nRoles and Views (and Stored Routines)\n-------------------------------------\n\nWhen a user sets a role, he, in a sense, has two identities with two\nassociated sets of privileges. But a view (or a stored routine) can have only\none definer. So, when a view (or a stored routine) is created with the SQL\nSECURITY DEFINER, one can specify whether the definer should be CURRENT_USER\n(and the view will have none of the privileges of the user\'s role) or\nCURRENT_ROLE (in this case, the view will use role\'s privileges, but none of\nthe user\'s privileges). As a result, sometimes one can create a view that is\nimpossible to use.\n\nCREATE ROLE r1;\n\nGRANT ALL ON db1.* TO r1;\n\nGRANT r1 TO foo@localhost;\n\nGRANT ALL ON db.* TO foo@localhost;\n\nSELECT CURRENT_USER\n+---------------+\n| current_user  |\n+---------------+\n| foo@localhost |\n+---------------+\n\nSET ROLE r1;\n\nCREATE TABLE db1.t1 (i int);\n\nCREATE VIEW db.v1 AS SELECT * FROM db1.t1;\n\nSHOW CREATE VIEW db.v1;\n+------+-----------------------------------------------------------------------\n------------------------------------------------------------------+------------\n---------+----------------------+\n| View | Create View                                                          \n                                 |\ncharacter_set_client | collation_connection |\n+------+-----------------------------------------------------------------------\n------------------------------------------------------------------+------------\n---------+----------------------+\n| v1   | CREATE ALGORITHM=UNDEFINED DEFINER=`foo`@`localhost` SQL SECURITY\nDEFINER VIEW `db`.`v1` AS SELECT `db1`.`t1`.`i` AS `i` from `db1`.`t1` | utf8 \n       | utf8_general_ci      |\n+------+-----------------------------------------------------------------------\n------------------------------------------------------------------+------------\n---------+----------------------+\n\nCREATE DEFINER=CURRENT_ROLE VIEW db.v2 AS SELECT * FROM db1.t1;\n\nSHOW CREATE VIEW db.b2;\n+------+-----------------------------------------------------------------------\n-----------------------------------------------------+----------------------+--\n-------------------+\n| View | Create View                                                          \n                           | character_set_client |\ncollation_connection |\n+------+-----------------------------------------------------------------------\n-----------------------------------------------------+----------------------+--\n-------------------+\n| v2   | CREATE ALGORITHM=UNDEFINED DEFINER=`r1` SQL SECURITY DEFINER VIEW\n`db`.`v2` AS select `db1`.`t1`.`a` AS `a` from `db1`.`t1` | utf8              \n | utf8_general_ci      |\n+------+-----------------------------------------------------------------------\n-----------------------------------------------------+----------------------+--\n-------------------+\n\nOther Resources\n---------------\n\n* Roles Review by Peter Gulutzan\n\nURL: https://mariadb.com/kb/en/roles_overview/','','https://mariadb.com/kb/en/roles_overview/'),(190,'BINLOG_GTID_POS',17,'Syntax\n------\n\nBINLOG_GTID_POS(binlog_filename,binlog_offset)\n\nDescription\n-----------\n\nThe BINLOG_GTID_POS() function takes as input an old-style binary log position\nin the form of a file name and a file offset. It looks up the position in the\ncurrent binlog, and returns a string representation of the corresponding GTID\nposition. If the position is not found in the current binlog, NULL is returned.\n\nExamples\n--------\n\nSELECT BINLOG_GTID_POS(\"master-bin.000001\", 600);\n\nURL: https://mariadb.com/kb/en/binlog_gtid_pos/','','https://mariadb.com/kb/en/binlog_gtid_pos/'),(116,'Account Locking',10,'MariaDB starting with 10.4.2\n----------------------------\nAccount locking was introduced in MariaDB 10.4.2.\n\nDescription\n-----------\n\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected).\n\nUser accounts can be locked at creation, with the CREATE USER statement, or\nmodified after creation with the ALTER USER statement. For example:\n\nCREATE USER \'lorin\'@\'localhost\' ACCOUNT LOCK;\n\nor\n\nALTER USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nThe server will return an ER_ACCOUNT_HAS_BEEN_LOCKED error when locked users\nattempt to connect:\n\nmysql -ulorin\n ERROR 4151 (HY000): Access denied, this account is locked\n\nThe ALTER USER statement is also used to unlock a user:\n\nALTER USER \'lorin\'@\'localhost\' ACCOUNT UNLOCK;\n\nThe SHOW CREATE USER statement will show whether the account is locked:\n\nSHOW CREATE USER \'marijn\'@\'localhost\';\n+-----------------------------------------------+\n| CREATE USER for marijn@localhost              |\n+-----------------------------------------------+\n| CREATE USER \'marijn\'@\'localhost\' ACCOUNT LOCK |\n+-----------------------------------------------+\n\nas well as querying the mysql.global_priv table:\n\nSELECT CONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv)) FROM\nmysql.global_priv \n WHERE user=\'marijn\';\n+------------------------------------------------------------------------------\n-------+\n| CONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv))                        \n    |\n+------------------------------------------------------------------------------\n-------+\n| marijn@localhost => {\n  \"access\": 0,\n  \"plugin\": \"mysql_native_password\",\n  \"authentication_string\": \"\",\n  \"account_locked\": true,\n  \"password_last_changed\": 1558017158\n} |\n+------------------------------------------------------------------------------\n-------+\n\nURL: https://mariadb.com/kb/en/account-locking/','','https://mariadb.com/kb/en/account-locking/'),(118,'User Password Expiry',10,'MariaDB starting with 10.4.3\n----------------------------\nUser password expiry was introduced in MariaDB 10.4.3.\n\nPassword expiry permits administrators to expire user passwords, either\nmanually or automatically.\n\nSystem Variables\n----------------\n\nThere are two system variables which affect password expiry:\ndefault_password_lifetime, which determines the amount of time between\nrequiring the user to change their password. 0, the default, means automatic\npassword expiry is not active.\n\nThe second variable, disconnect_on_expired_password determines whether a\nclient is permitted to connect if their password has expired, or whether they\nare permitted to connect in sandbox mode, able to perform a limited subset of\nqueries related to resetting the password, in particular SET PASSWORD and SET.\n\nSetting a Password Expiry Limit for a User\n------------------------------------------\n\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal using the CREATE USER or ALTER USER statements, for example:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nLimits can be disabled by use of the NEVER keyword, for example:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\n\nA manually set limit can be restored the system default by use of DEFAULT, for\nexample:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nSHOW CREATE USER\n----------------\n\nThe SHOW CREATE USER statement will display information about the password\nexpiry status of the user. Unlike MySQL, it will not display if the user is\nunlocked, or if the password expiry is set to default.\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\nCREATE USER \'konstantin\'@\'localhost\' PASSWORD EXPIRE NEVER;\nCREATE USER \'amse\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nSHOW CREATE USER \'monty\'@\'localhost\';\n+------------------------------------------------------------------+\n| CREATE USER for monty@localhost                                  |\n+------------------------------------------------------------------+\n| CREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY |\n+------------------------------------------------------------------+\n\nSHOW CREATE USER \'konstantin\'@\'localhost\';\n+------------------------------------------------------------+\n| CREATE USER for konstantin@localhost                       |\n+------------------------------------------------------------+\n| CREATE USER \'konstantin\'@\'localhost\' PASSWORD EXPIRE NEVER |\n+------------------------------------------------------------+\n\nSHOW CREATE USER \'amse\'@\'localhost\';\n+--------------------------------+\n| CREATE USER for amse@localhost |\n+--------------------------------+\n| CREATE USER \'amse\'@\'localhost\' |\n+--------------------------------+\n\nChecking When Passwords Expire\n------------------------------\n\nThe following query can be used to check when the current passwords expire for\nall users:\n\nWITH password_expiration_info AS (\n SELECT User, Host,\n IF(\n IFNULL(JSON_EXTRACT(Priv, \'$.password_lifetime\'), -1) = -1,\n @@global.default_password_lifetime,\n JSON_EXTRACT(Priv, \'$.password_lifetime\')\n ) AS password_lifetime,\n JSON_EXTRACT(Priv, \'$.password_last_changed\') AS password_last_changed\n FROM mysql.global_priv\n)\nSELECT pei.User, pei.Host,\n pei.password_lifetime,\n FROM_UNIXTIME(pei.password_last_changed) AS password_last_changed_datetime,\n FROM_UNIXTIME(\n pei.password_last_changed +\n (pei.password_lifetime * 60 * 60 * 24)\n ) AS password_expiration_datetime\n FROM password_expiration_info pei\n WHERE pei.password_lifetime != 0\n AND pei.password_last_changed IS NOT NULL\nUNION\nSELECT pei.User, pei.Host,\n pei.password_lifetime,\n FROM_UNIXTIME(pei.password_last_changed) AS password_last_changed_datetime,\n 0 AS password_expiration_datetime\n FROM password_expiration_info pei\n WHERE pei.password_lifetime = 0\n OR pei.password_last_changed IS NULL;\n\n--connect-expired-password Client Option\n----------------------------------------\n\nThe mysql client --connect-expired-password option notifies the server that\nthe client is prepared to handle expired password sandbox mode (even if the\n--batch option was specified).\n\nURL: https://mariadb.com/kb/en/user-password-expiry/','','https://mariadb.com/kb/en/user-password-expiry/'),(193,'COLLATION',17,'Syntax\n------\n\nCOLLATION(str)\n\nDescription\n-----------\n\nReturns the collation of the string argument. If str is not a string, it is\nconsidered as a binary string (so the function returns \'binary\'). This applies\nto NULL, too. The return value is a string in the utf8 character set.\n\nSee Character Sets and Collations.\n\nExamples\n--------\n\nSELECT COLLATION(\'abc\');\n+-------------------+\n| COLLATION(\'abc\')  |\n+-------------------+\n| latin1_swedish_ci |\n+-------------------+\n\nSELECT COLLATION(_utf8\'abc\');\n+-----------------------+\n| COLLATION(_utf8\'abc\') |\n+-----------------------+\n| utf8_general_ci       |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/collation/','','https://mariadb.com/kb/en/collation/'),(194,'CONNECTION_ID',17,'Syntax\n------\n\nCONNECTION_ID()\n\nDescription\n-----------\n\nReturns the connection ID for the connection. Every connection (including\nevents) has an ID that is unique among the set of currently connected clients.\n\nUntil MariaDB 10.3.1, returns MYSQL_TYPE_LONGLONG, or bigint(10), in all\ncases. From MariaDB 10.3.1, returns MYSQL_TYPE_LONG, or int(10), when the\nresult would fit within 32-bits.\n\nExamples\n--------\n\nSELECT CONNECTION_ID();\n+-----------------+\n| CONNECTION_ID() |\n+-----------------+\n|               3 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/connection_id/','','https://mariadb.com/kb/en/connection_id/'),(123,'UNCOMPRESS',12,'Syntax\n------\n\nUNCOMPRESS(string_to_uncompress)\n\nDescription\n-----------\n\nUncompresses a string compressed by the COMPRESS() function. If the argument\nis not a compressed value, the result is NULL. This function requires MariaDB\nto have been compiled with a compression library such as zlib. Otherwise, the\nreturn value is always NULL. The have_compress server system variable\nindicates whether a compression library is present.\n\nExamples\n--------\n\nSELECT UNCOMPRESS(COMPRESS(\'a string\'));\n+----------------------------------+\n| UNCOMPRESS(COMPRESS(\'a string\')) |\n+----------------------------------+\n| a string                         |\n+----------------------------------+\n\nSELECT UNCOMPRESS(\'a string\');\n+------------------------+\n| UNCOMPRESS(\'a string\') |\n+------------------------+\n| NULL                   |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/uncompress/','','https://mariadb.com/kb/en/uncompress/'),(124,'DECODE',12,'Syntax\n------\n\nDECODE(crypt_str,pass_str)\n\nIn Oracle mode from MariaDB 10.3.2:\n\nDECODE(expr, search_expr, result_expr [, search_expr2, result_expr2 ...]\n[default_expr])\n\nIn all modes from MariaDB 10.3.2:\n\nDECODE_ORACLE(expr, search_expr, result_expr [, search_expr2, result_expr2\n...] [default_expr])\n\nDescription\n-----------\n\nIn the default mode, DECODE decrypts the encrypted string crypt_str using\npass_str as the password. crypt_str should be a string returned from ENCODE().\nThe resulting string will be the original string only if pass_str is the same.\n\nIn Oracle mode from MariaDB 10.3.2, DECODE compares expr to the search\nexpressions, in order. If it finds a match, the corresponding result\nexpression is returned. If no matches are found, the default expression is\nreturned, or NULL if no default is provided.\n\nNULLs are treated as equivalent.\n\nDECODE_ORACLE is a synonym for the Oracle-mode version of the function, and is\navailable in all modes.\n\nExamples\n--------\n\nFrom MariaDB 10.3.2:\n\nSELECT DECODE_ORACLE(2+1,3*1,\'found1\',3*2,\'found2\',\'default\');\n+--------------------------------------------------------+\n| DECODE_ORACLE(2+1,3*1,\'found1\',3*2,\'found2\',\'default\') |\n+--------------------------------------------------------+\n| found1                                                 |\n+--------------------------------------------------------+\n\nSELECT DECODE_ORACLE(2+4,3*1,\'found1\',3*2,\'found2\',\'default\');\n+--------------------------------------------------------+\n| DECODE_ORACLE(2+4,3*1,\'found1\',3*2,\'found2\',\'default\') |\n+--------------------------------------------------------+\n| found2                                                 |\n+--------------------------------------------------------+\n\nSELECT DECODE_ORACLE(2+2,3*1,\'found1\',3*2,\'found2\',\'default\');\n+--------------------------------------------------------+\n| DECODE_ORACLE(2+2,3*1,\'found1\',3*2,\'found2\',\'default\') |\n+--------------------------------------------------------+\n| default                                                |\n+--------------------------------------------------------+\n\nNulls are treated as equivalent:\n\nSELECT DECODE_ORACLE(NULL,NULL,\'Nulls are equivalent\',\'Nulls are not\nequivalent\');\n+----------------------------------------------------------------------------+\n| DECODE_ORACLE(NULL,NULL,\'Nulls are equivalent\',\'Nulls are not equivalent\') |\n+----------------------------------------------------------------------------+\n| Nulls are equivalent                                                       |\n+----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/decode/','','https://mariadb.com/kb/en/decode/'),(127,'AES_ENCRYPT',12,'Syntax\n------\n\nAES_ENCRYPT(str,key_str)\n\nDescription\n-----------\n\nAES_ENCRYPT() and AES_DECRYPT() allow encryption and decryption of data using\nthe official AES (Advanced Encryption Standard) algorithm, previously known as\n\"Rijndael.\" Encoding with a 128-bit key length is used, but you can extend it\nup to 256 bits by modifying the source. We chose 128 bits because it is much\nfaster and it is secure enough for most purposes.\n\nAES_ENCRYPT() encrypts a string str using the key key_str, and returns a\nbinary string.\n\nAES_DECRYPT() decrypts the encrypted string and returns the original string.\n\nThe input arguments may be any length. If either argument is NULL, the result\nof this function is also NULL.\n\nBecause AES is a block-level algorithm, padding is used to encode uneven\nlength strings and so the result string length may be calculated using this\nformula:\n\n16 x (trunc(string_length / 16) + 1)\n\nIf AES_DECRYPT() detects invalid data or incorrect padding, it returns NULL.\nHowever, it is possible for AES_DECRYPT() to return a non-NULL value (possibly\ngarbage) if the input data or the key is invalid.\n\nExamples\n--------\n\nINSERT INTO t VALUES (AES_ENCRYPT(\'text\',SHA2(\'password\',512)));\n\nURL: https://mariadb.com/kb/en/aes_encrypt/','','https://mariadb.com/kb/en/aes_encrypt/'),(205,'SCHEMA',17,'Syntax\n------\n\nSCHEMA()\n\nDescription\n-----------\n\nThis function is a synonym for DATABASE().\n\nURL: https://mariadb.com/kb/en/schema/','','https://mariadb.com/kb/en/schema/'),(206,'SESSION_USER',17,'Syntax\n------\n\nSESSION_USER()\n\nDescription\n-----------\n\nSESSION_USER() is a synonym for USER().\n\nURL: https://mariadb.com/kb/en/session_user/','','https://mariadb.com/kb/en/session_user/'),(207,'SYSTEM_USER',17,'Syntax\n------\n\nSYSTEM_USER()\n\nDescription\n-----------\n\nSYSTEM_USER() is a synonym for USER().\n\nURL: https://mariadb.com/kb/en/system_user/','','https://mariadb.com/kb/en/system_user/'),(210,'Assignment Operator (:=)',18,'Syntax\n------\n\nvar_name := expr\n\nDescription\n-----------\n\nAssignment operator for assigning a value. The value on the right is assigned\nto the variable on left.\n\nUnlike the = operator, := can always be used to assign a value to a variable.\n\nThis operator works with both user-defined variables and local variables.\n\nWhen assigning the same value to several variables, LAST_VALUE() can be useful.\n\nExamples\n--------\n\nSELECT @x := 10;\n+----------+\n| @x := 10 |\n+----------+\n|       10 |\n+----------+\n\nSELECT @x, @y := @x;\n+------+----------+\n| @x   | @y := @x |\n+------+----------+\n|   10 |       10 |\n+------+----------+\n\nURL: https://mariadb.com/kb/en/assignment-operator/','','https://mariadb.com/kb/en/assignment-operator/'),(221,'GREATEST',19,'Syntax\n------\n\nGREATEST(value1,value2,...)\n\nDescription\n-----------\n\nWith two or more arguments, returns the largest (maximum-valued) argument. The\narguments are compared using the same rules as for LEAST().\n\nExamples\n--------\n\nSELECT GREATEST(2,0);\n+---------------+\n| GREATEST(2,0) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT GREATEST(34.0,3.0,5.0,767.0);\n+------------------------------+\n| GREATEST(34.0,3.0,5.0,767.0) |\n+------------------------------+\n|                        767.0 |\n+------------------------------+\n\nSELECT GREATEST(\'B\',\'A\',\'C\');\n+-----------------------+\n| GREATEST(\'B\',\'A\',\'C\') |\n+-----------------------+\n| C                     |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/greatest/','','https://mariadb.com/kb/en/greatest/'),(226,'IS NOT NULL',19,'Syntax\n------\n\nIS NOT NULL\n\nDescription\n-----------\n\nTests whether a value is not NULL. See also NULL Values in MariaDB.\n\nExamples\n--------\n\nSELECT 1 IS NOT NULL, 0 IS NOT NULL, NULL IS NOT NULL;\n+---------------+---------------+------------------+\n| 1 IS NOT NULL | 0 IS NOT NULL | NULL IS NOT NULL |\n+---------------+---------------+------------------+\n|             1 |             1 |                0 |\n+---------------+---------------+------------------+\n\nURL: https://mariadb.com/kb/en/is-not-null/','','https://mariadb.com/kb/en/is-not-null/'),(128,'COMPRESS',12,'Syntax\n------\n\nCOMPRESS(string_to_compress)\n\nDescription\n-----------\n\nCompresses a string and returns the result as a binary string. This function\nrequires MariaDB to have been compiled with a compression library such as\nzlib. Otherwise, the return value is always NULL. The compressed string can be\nuncompressed with UNCOMPRESS().\n\nThe have_compress server system variable indicates whether a compression\nlibrary is present.\n\nExamples\n--------\n\nSELECT LENGTH(COMPRESS(REPEAT(\'a\',1000)));\n+------------------------------------+\n| LENGTH(COMPRESS(REPEAT(\'a\',1000))) |\n+------------------------------------+\n|                                 21 |\n+------------------------------------+\n\nSELECT LENGTH(COMPRESS(\'\'));\n+----------------------+\n| LENGTH(COMPRESS(\'\')) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSELECT LENGTH(COMPRESS(\'a\'));\n+-----------------------+\n| LENGTH(COMPRESS(\'a\')) |\n+-----------------------+\n|                    13 |\n+-----------------------+\n\nSELECT LENGTH(COMPRESS(REPEAT(\'a\',16)));\n+----------------------------------+\n| LENGTH(COMPRESS(REPEAT(\'a\',16))) |\n+----------------------------------+\n|                               15 |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/compress/','','https://mariadb.com/kb/en/compress/'),(129,'DES_DECRYPT',12,'DES_DECRYPT has been deprecated from MariaDB 10.10.0, and will be removed in a\nfuture release.\n\nSyntax\n------\n\nDES_DECRYPT(crypt_str[,key_str])\n\nDescription\n-----------\n\nDecrypts a string encrypted with DES_ENCRYPT(). If an error occurs, this\nfunction returns NULL.\n\nThis function works only if MariaDB has been configured with TLS support.\n\nIf no key_str argument is given, DES_DECRYPT() examines the first byte of the\nencrypted string to determine the DES key number that was used to encrypt the\noriginal string, and then reads the key from the DES key file to decrypt the\nmessage. For this to work, the user must have the SUPER privilege. The key\nfile can be specified with the --des-key-file server option.\n\nIf you pass this function a key_str argument, that string is used as the key\nfor decrypting the message.\n\nIf the crypt_str argument does not appear to be an encrypted string, MariaDB\nreturns the given crypt_str.\n\nURL: https://mariadb.com/kb/en/des_decrypt/','','https://mariadb.com/kb/en/des_decrypt/'),(130,'DES_ENCRYPT',12,'DES_ENCRYPT has been deprecated from MariaDB 10.10.0, and will be removed in a\nfuture release.\n\nSyntax\n------\n\nDES_ENCRYPT(str[,{key_num|key_str}])\n\nDescription\n-----------\n\nEncrypts the string with the given key using the Triple-DES algorithm.\n\nThis function works only if MariaDB has been configured with TLS support.\n\nThe encryption key to use is chosen based on the second argument to\nDES_ENCRYPT(), if one was given. With no argument, the first key from the DES\nkey file is used. With a key_num argument, the given key number (0-9) from the\nDES key file is used. With a key_str argument, the given key string is used to\nencrypt str.\n\nThe key file can be specified with the --des-key-file server option.\n\nThe return string is a binary string where the first character is CHAR(128 |\nkey_num). If an error occurs, DES_ENCRYPT() returns NULL.\n\nThe 128 is added to make it easier to recognize an encrypted key. If you use a\nstring key, key_num is 127.\n\nThe string length for the result is given by this formula:\n\nnew_len = orig_len + (8 - (orig_len % 8)) + 1\n\nEach line in the DES key file has the following format:\n\nkey_num des_key_str\n\nEach key_num value must be a number in the range from 0 to 9. Lines in the\nfile may be in any order. des_key_str is the string that is used to encrypt\nthe message. There should be at least one space between the number and the\nkey. The first key is the default key that is used if you do not specify any\nkey argument to DES_ENCRYPT().\n\nYou can tell MariaDB to read new key values from the key file with the FLUSH\nDES_KEY_FILE statement. This requires the RELOAD privilege.\n\nOne benefit of having a set of default keys is that it gives applications a\nway to check for the existence of encrypted column values, without giving the\nend user the right to decrypt those values.\n\nExamples\n--------\n\nSELECT customer_address FROM customer_table \n WHERE crypted_credit_card = DES_ENCRYPT(\'credit_card_number\');\n\nURL: https://mariadb.com/kb/en/des_encrypt/','','https://mariadb.com/kb/en/des_encrypt/'),(131,'ENCODE',12,'Syntax\n------\n\nENCODE(str,pass_str)\n\nDescription\n-----------\n\nENCODE is not considered cryptographically secure, and should not be used for\npassword encryption.\n\nEncrypt str using pass_str as the password. To decrypt the result, use\nDECODE().\n\nThe result is a binary string of the same length as str.\n\nThe strength of the encryption is based on how good the random generator is.\n\nIt is not recommended to rely on the encryption performed by the ENCODE\nfunction. Using a salt value (changed when a password is updated) will improve\nmatters somewhat, but for storing passwords, consider a more cryptographically\nsecure function, such as SHA2().\n\nExamples\n--------\n\nENCODE(\'not so secret text\', CONCAT(\'random_salt\',\'password\'))\n\nURL: https://mariadb.com/kb/en/encode/','','https://mariadb.com/kb/en/encode/'),(228,'ISNULL',19,'Syntax\n------\n\nISNULL(expr)\n\nDescription\n-----------\n\nIf expr is NULL, ISNULL() returns 1, otherwise it returns 0.\n\nSee also NULL Values in MariaDB.\n\nExamples\n--------\n\nSELECT ISNULL(1+1);\n+-------------+\n| ISNULL(1+1) |\n+-------------+\n|           0 |\n+-------------+\n\nSELECT ISNULL(1/0);\n+-------------+\n| ISNULL(1/0) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/isnull/','','https://mariadb.com/kb/en/isnull/'),(232,'&',20,'Syntax\n------\n\n&\n\nDescription\n-----------\n\nBitwise AND. Converts the values to binary and compares bits. Only if both the\ncorresponding bits are 1 is the resulting bit also 1.\n\nSee also bitwise OR.\n\nExamples\n--------\n\nSELECT 2&1;\n+-----+\n| 2&1 |\n+-----+\n|   0 |\n+-----+\n\nSELECT 3&1;\n+-----+\n| 3&1 |\n+-----+\n|   1 |\n+-----+\n\nSELECT 29 & 15;\n+---------+\n| 29 & 15 |\n+---------+\n|      13 |\n+---------+\n\nURL: https://mariadb.com/kb/en/bitwise_and/','','https://mariadb.com/kb/en/bitwise_and/'),(233,'<<',20,'Syntax\n------\n\nvalue1 << value2\n\nDescription\n-----------\n\nConverts a longlong (BIGINT) number (value1) to binary and shifts value2 units\nto the left.\n\nExamples\n--------\n\nSELECT 1 << 2;\n+--------+\n| 1 << 2 |\n+--------+\n|      4 |\n+--------+\n\nURL: https://mariadb.com/kb/en/shift-left/','','https://mariadb.com/kb/en/shift-left/'),(234,'>>',20,'Syntax\n------\n\nvalue1 >> value2\n\nDescription\n-----------\n\nConverts a longlong (BIGINT) number (value1) to binary and shifts value2 units\nto the right.\n\nExamples\n--------\n\nSELECT 4 >> 2;\n+--------+\n| 4 >> 2 |\n+--------+\n|      1 |\n+--------+\n\nURL: https://mariadb.com/kb/en/shift-right/','','https://mariadb.com/kb/en/shift-right/'),(235,'BIT_COUNT',20,'Syntax\n------\n\nBIT_COUNT(N)\n\nDescription\n-----------\n\nReturns the number of bits that are set in the argument N.\n\nExamples\n--------\n\nSELECT BIT_COUNT(29), BIT_COUNT(b\'101010\');\n+---------------+----------------------+\n| BIT_COUNT(29) | BIT_COUNT(b\'101010\') |\n+---------------+----------------------+\n|             4 |                    3 |\n+---------------+----------------------+\n\nURL: https://mariadb.com/kb/en/bit_count/','','https://mariadb.com/kb/en/bit_count/'),(132,'ENCRYPT',12,'Syntax\n------\n\nENCRYPT(str[,salt])\n\nDescription\n-----------\n\nEncrypts a string using the Unix crypt() system call, returning an encrypted\nbinary string. The salt argument should be a string with at least two\ncharacters or the returned result will be NULL. If no salt argument is given,\na random value of sufficient length is used.\n\nIt is not recommended to use ENCRYPT() with utf16, utf32 or ucs2 multi-byte\ncharacter sets because the crypt() system call expects a string terminated\nwith a zero byte.\n\nNote that the underlying crypt() system call may have some limitations, such\nas ignoring all but the first eight characters.\n\nIf the have_crypt system variable is set to NO (because the crypt() system\ncall is not available), the ENCRYPT function will always return NULL.\n\nExamples\n--------\n\nSELECT ENCRYPT(\'encrypt me\');\n+-----------------------+\n| ENCRYPT(\'encrypt me\') |\n+-----------------------+\n| 4I5BsEx0lqTDk         |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/encrypt/','','https://mariadb.com/kb/en/encrypt/'),(134,'OLD_PASSWORD',12,'Syntax\n------\n\nOLD_PASSWORD(str)\n\nDescription\n-----------\n\nOLD_PASSWORD() was added to MySQL when the implementation of PASSWORD() was\nchanged to improve security. OLD_PASSWORD() returns the value of the old\n(pre-MySQL 4.1) implementation of PASSWORD() as a string, and is intended to\npermit you to reset passwords for any pre-4.1 clients that need to connect to\na more recent MySQL server version, or any version of MariaDB, without locking\nthem out.\n\nAs of MariaDB 5.5, the return value is a nonbinary string in the connection\ncharacter set and collation, determined by the values of the\ncharacter_set_connection and collation_connection system variables. Before\n5.5, the return value was a binary string.\n\nThe return value is 16 bytes in length, or NULL if the argument was NULL.\n\nURL: https://mariadb.com/kb/en/old_password/','','https://mariadb.com/kb/en/old_password/'),(135,'PASSWORD',12,'Syntax\n------\n\nPASSWORD(str)\n\nDescription\n-----------\n\nThe PASSWORD() function is used for hashing passwords for use in\nauthentication by the MariaDB server. It is not intended for use in other\napplications.\n\nCalculates and returns a hashed password string from the plaintext password\nstr. Returns an empty string (>= MariaDB 10.0.4) if the argument was NULL.\n\nThe return value is a nonbinary string in the connection character set and\ncollation, determined by the values of the character_set_connection and\ncollation_connection system variables.\n\nThis is the function that is used for hashing MariaDB passwords for storage in\nthe Password column of the user table (see privileges), usually used with the\nSET PASSWORD statement. It is not intended for use in other applications.\n\nUntil MariaDB 10.3, the return value is 41-bytes in length, and the first\ncharacter is always \'*\'. From MariaDB 10.4, the function takes into account\nthe authentication plugin where applicable (A CREATE USER or SET PASSWORD\nstatement). For example, when used in conjunction with a user authenticated by\nthe ed25519 plugin, the statement will create a longer hash:\n\nCREATE USER edtest@localhost IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nCREATE USER edtest2@localhost IDENTIFIED BY \'secret\';\n\nSELECT CONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv)) FROM\nmysql.global_priv\n WHERE user LIKE \'edtest%\'\\G\n*************************** 1. row ***************************\nCONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv)): edtest@localhost => {\n...\n  \"plugin\": \"ed25519\",\n  \"authentication_string\": \"ZIgUREUg5PVgQ6LskhXmO+eZLS0nC8be6HPjYWR4YJY\",\n...\n}\n*************************** 2. row ***************************\nCONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv)): edtest2@localhost => {\n...\n  \"plugin\": \"mysql_native_password\",\n  \"authentication_string\": \"*14E65567ABDB5135D0CFD9A70B3032C179A49EE7\",\n...\n}\n\nThe behavior of this function is affected by the value of the old_passwords\nsystem variable. If this is set to 1 (0 is default), MariaDB reverts to using\nthe mysql_old_password authentication plugin by default for newly created\nusers and passwords.\n\nExamples\n--------\n\nSELECT PASSWORD(\'notagoodpwd\');\n+-------------------------------------------+\n| PASSWORD(\'notagoodpwd\')                   |\n+-------------------------------------------+\n| *3A70EE9FC6594F88CE9E959CD51C5A1C002DC937 |\n+-------------------------------------------+\n\nSET PASSWORD FOR \'bob\'@\'%.loc.gov\' = PASSWORD(\'newpass\');\n\nURL: https://mariadb.com/kb/en/password/','','https://mariadb.com/kb/en/password/'),(136,'SHA1',12,'Syntax\n------\n\nSHA1(str), SHA(str)\n\nDescription\n-----------\n\nCalculates an SHA-1 160-bit checksum for the string str, as described in RFC\n3174 (Secure Hash Algorithm).\n\nThe value is returned as a string of 40 hex digits, or NULL if the argument\nwas NULL. As of MariaDB 5.5, the return value is a nonbinary string in the\nconnection character set and collation, determined by the values of the\ncharacter_set_connection and collation_connection system variables. Before\n5.5, the return value was a binary string.\n\nExamples\n--------\n\nSELECT SHA1(\'some boring text\');\n+------------------------------------------+\n| SHA1(\'some boring text\')                 |\n+------------------------------------------+\n| af969fc2085b1bb6d31e517d5c456def5cdd7093 |\n+------------------------------------------+\n\nURL: https://mariadb.com/kb/en/sha1/','','https://mariadb.com/kb/en/sha1/'),(236,'^',20,'Syntax\n------\n\n^\n\nDescription\n-----------\n\nBitwise XOR. Converts the values to binary and compares bits. If one (and only\none) of the corresponding bits is 1 is the resulting bit also 1.\n\nExamples\n--------\n\nSELECT 1 ^ 1;\n+-------+\n| 1 ^ 1 |\n+-------+\n|     0 |\n+-------+\n\nSELECT 1 ^ 0;\n+-------+\n| 1 ^ 0 |\n+-------+\n|     1 |\n+-------+\n\nSELECT 11 ^ 3;\n+--------+\n| 11 ^ 3 |\n+--------+\n|      8 |\n+--------+\n\nURL: https://mariadb.com/kb/en/bitwise-xor/','','https://mariadb.com/kb/en/bitwise-xor/'),(237,'|',20,'Syntax\n------\n\n|\n\nDescription\n-----------\n\nBitwise OR. Converts the values to binary and compares bits. If either of the\ncorresponding bits has a value of 1, the resulting bit is also 1.\n\nSee also bitwise AND.\n\nExamples\n--------\n\nSELECT 2|1;\n+-----+\n| 2|1 |\n+-----+\n|   3 |\n+-----+\n\nSELECT 29 | 15;\n+---------+\n| 29 | 15 |\n+---------+\n|      31 |\n+---------+\n\nURL: https://mariadb.com/kb/en/bitwise-or/','','https://mariadb.com/kb/en/bitwise-or/'),(238,'~',20,'Syntax\n------\n\n~\n\nDescription\n-----------\n\nBitwise NOT. Converts the value to 4 bytes binary and inverts all bits.\n\nExamples\n--------\n\nSELECT 3 & ~1;\n+--------+\n| 3 & ~1 |\n+--------+\n|      2 |\n+--------+\n\nSELECT 5 & ~1;\n+--------+\n| 5 & ~1 |\n+--------+\n|      4 |\n+--------+\n\nURL: https://mariadb.com/kb/en/bitwise-not/','','https://mariadb.com/kb/en/bitwise-not/'),(240,'TRUE FALSE',20,'Description\n-----------\n\nThe constants TRUE and FALSE evaluate to 1 and 0, respectively. The constant\nnames can be written in any lettercase.\n\nExamples\n--------\n\nSELECT TRUE, true, FALSE, false;\n+------+------+-------+-------+\n| TRUE | TRUE | FALSE | FALSE |\n+------+------+-------+-------+\n|    1 |    1 |     0 |     0 |\n+------+------+-------+-------+\n\nURL: https://mariadb.com/kb/en/true-false/','','https://mariadb.com/kb/en/true-false/'),(243,'CHECK VIEW',21,'Syntax\n------\n\nCHECK VIEW view_name\n\nDescription\n-----------\n\nThe CHECK VIEW statement was introduced in MariaDB 10.0.18 to assist with\nfixing MDEV-6916, an issue introduced in MariaDB 5.2 where the view algorithms\nwere swapped. It checks whether the view algorithm is correct. It is run as\npart of mysql_upgrade, and should not normally be required in regular use.\n\nURL: https://mariadb.com/kb/en/check-view/','','https://mariadb.com/kb/en/check-view/'),(137,'SHA2',12,'Syntax\n------\n\nSHA2(str,hash_len)\n\nDescription\n-----------\n\nGiven a string str, calculates an SHA-2 checksum, which is considered more\ncryptographically secure than its SHA-1 equivalent. The SHA-2 family includes\nSHA-224, SHA-256, SHA-384, and SHA-512, and the hash_len must correspond to\none of these, i.e. 224, 256, 384 or 512. 0 is equivalent to 256.\n\nThe return value is a nonbinary string in the connection character set and\ncollation, determined by the values of the character_set_connection and\ncollation_connection system variables.\n\nNULL is returned if the hash length is not valid, or the string str is NULL.\n\nSHA2 will only work if MariaDB was has been configured with TLS support.\n\nExamples\n--------\n\nSELECT SHA2(\'Maria\',224);\n+----------------------------------------------------------+\n| SHA2(\'Maria\',224)                                        |\n+----------------------------------------------------------+\n| 6cc67add32286412efcab9d0e1675a43a5c2ef3cec8879f81516ff83 |\n+----------------------------------------------------------+\n\nSELECT SHA2(\'Maria\',256);\n+------------------------------------------------------------------+\n| SHA2(\'Maria\',256)                                                |\n+------------------------------------------------------------------+\n| 9ff18ebe7449349f358e3af0b57cf7a032c1c6b2272cb2656ff85eb112232f16 |\n+------------------------------------------------------------------+\n\nSELECT SHA2(\'Maria\',0);\n+------------------------------------------------------------------+\n| SHA2(\'Maria\',0)                                                  |\n+------------------------------------------------------------------+\n| 9ff18ebe7449349f358e3af0b57cf7a032c1c6b2272cb2656ff85eb112232f16 |\n+------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/sha2/','','https://mariadb.com/kb/en/sha2/'),(148,'INET6_ATON',14,'Syntax\n------\n\nINET6_ATON(expr)\n\nDescription\n-----------\n\nGiven an IPv6 or IPv4 network address as a string, returns a binary string\nthat represents the numeric value of the address.\n\nNo trailing zone ID\'s or traling network masks are permitted. For IPv4\naddresses, or IPv6 addresses with IPv4 address parts, no classful addresses or\ntrailing port numbers are permitted and octal numbers are not supported.\n\nThe returned binary string will be VARBINARY(16) or VARBINARY(4) for IPv6 and\nIPv4 addresses respectively.\n\nReturns NULL if the argument is not understood.\n\nMariaDB starting with 10.5.0\n----------------------------\nFrom MariaDB 10.5.0, INET6_ATON can take INET6 as an argument.\n\nExamples\n--------\n\nSELECT HEX(INET6_ATON(\'10.0.1.1\'));\n+-----------------------------+\n| HEX(INET6_ATON(\'10.0.1.1\')) |\n+-----------------------------+\n| 0A000101                    |\n+-----------------------------+\n\nSELECT HEX(INET6_ATON(\'48f3::d432:1431:ba23:846f\'));\n+----------------------------------------------+\n| HEX(INET6_ATON(\'48f3::d432:1431:ba23:846f\')) |\n+----------------------------------------------+\n| 48F3000000000000D4321431BA23846F             |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/inet6_aton/','','https://mariadb.com/kb/en/inet6_aton/'),(149,'INET6_NTOA',14,'Syntax\n------\n\nINET6_NTOA(expr)\n\nDescription\n-----------\n\nGiven an IPv6 or IPv4 network address as a numeric binary string, returns the\naddress as a nonbinary string in the connection character set.\n\nThe return string is lowercase, and is platform independent, since it does not\nuse functions specific to the operating system. It has a maximum length of 39\ncharacters.\n\nReturns NULL if the argument is not understood.\n\nExamples\n--------\n\nSELECT INET6_NTOA(UNHEX(\'0A000101\'));\n+-------------------------------+\n| INET6_NTOA(UNHEX(\'0A000101\')) |\n+-------------------------------+\n| 10.0.1.1                      |\n+-------------------------------+\n\nSELECT INET6_NTOA(UNHEX(\'48F3000000000000D4321431BA23846F\'));\n+-------------------------------------------------------+\n| INET6_NTOA(UNHEX(\'48F3000000000000D4321431BA23846F\')) |\n+-------------------------------------------------------+\n| 48f3::d432:1431:ba23:846f                             |\n+-------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/inet6_ntoa/','','https://mariadb.com/kb/en/inet6_ntoa/'),(153,'IS_IPV4',14,'Syntax\n------\n\nIS_IPV4(expr)\n\nDescription\n-----------\n\nIf the expression is a valid IPv4 address, returns 1, otherwise returns 0.\n\nIS_IPV4() is stricter than INET_ATON(), but as strict as INET6_ATON(), in\ndetermining the validity of an IPv4 address. This implies that if IS_IPV4\nreturns 1, the same expression will always return a non-NULL result when\npassed to INET_ATON(), but that the reverse may not apply.\n\nExamples\n--------\n\nSELECT IS_IPV4(\'1110.0.1.1\');\n+-----------------------+\n| IS_IPV4(\'1110.0.1.1\') |\n+-----------------------+\n|                     0 |\n+-----------------------+\n\nSELECT IS_IPV4(\'48f3::d432:1431:ba23:846f\');\n+--------------------------------------+\n| IS_IPV4(\'48f3::d432:1431:ba23:846f\') |\n+--------------------------------------+\n|                                    0 |\n+--------------------------------------+\n\nURL: https://mariadb.com/kb/en/is_ipv4/','','https://mariadb.com/kb/en/is_ipv4/'),(270,'CHAR BYTE',23,'Description\n-----------\n\nThe CHAR BYTE data type is an alias for the BINARY data type. This is a\ncompatibility feature.\n\nURL: https://mariadb.com/kb/en/char-byte/','','https://mariadb.com/kb/en/char-byte/'),(272,'INET6',23,'MariaDB starting with 10.5.0\n----------------------------\nThe INET6 data type was added in MariaDB 10.5.0\n\nSyntax\n------\n\nINET6\n\nDescription\n-----------\n\nThe INET6 data type is intended for storage of IPv6 addresses, as well as IPv4\naddresses assuming conventional mapping of IPv4 addresses into IPv6 addresses.\n\nBoth short and long IPv6 notation are permitted, according to RFC-5952.\n\n* Values are stored as a 16-byte fixed length binary string, with most\nsignificant byte first.\n* Storage engines see INET6 as BINARY(16).\n* Clients see INET6 as CHAR(39) and get text representation on retrieval.\n\nThe IPv4-compatible notation is considered as deprecated. It is supported for\ncompatibility with the INET6_ATON function, which also understands this\nformat. It\'s recommended to use the mapped format to store IPv4 addresses in\nINET6.\n\nWhen an IPv4 mapped (or compatible) value is stored in INET6, it still\noccupies 16 bytes:\n\nRetrieval\n---------\n\nOn retrieval, in the client-server text protocol, INET6 values are converted\nto the short text representation, according to RFC-5952, that is with all\nleading zeroes in each group removed and with consequent zero groups\ncompressed.\n\nBesides creating one\'s own stored function, there is no a way to retrieve an\nINET6 value using long text representation.\n\nCasting\n-------\n\n* CAST from a character string to INET6 understands addresses in short or long\ntext notation (including IPv4 mapped and compatible addresses). NULL is\nreturned if the format is not understood.\n* CAST from a binary string to INET6 requires a 16-byte string as an argument.\nNULL is returned if the argument length is not equal to 16.\n* CAST from other data types to INET6 first converts data to a character\nstring, then CAST from character string to INET6 is applied.\n* CAST from INET6 to CHAR returns short text address notation.\n* CAST from INET6 to BINARY returns its 16-byte binary string representation.\n* CAST from INET6 to data types other than CHAR (e.g. SIGNED, UNSIGNED, TIME,\netc) returns an error.\n\nComparisons\n-----------\n\nAn INET6 expression can be compared to:\n\n* another INET6 expression\n* a character string expression with a text (short or long) address\nrepresentation:\n* a 16-byte binary string expression:\n\nAttempting to compare INET6 to an expression of any other data type returns an\nerror.\n\nMixing INET6 Values for Result\n------------------------------\n\nAn INET6 expression can be mixed for result (i.e. UNION, CASE..THEN, COALESCE\netc) with:\n\n* another INET6 expression. The resulting data type is INET6.\n* a character string in text (short or long) address representation. The\nresult data type is INET6. The character string counterpart is automatically\nconverted to INET6. If the string format is not understood, it\'s converted\nwith a warning to either NULL or to \'::\', depending on the NULL-ability of the\nresult.\n* a 16-byte binary string. The resulting data type is INET6. The binary string\ncounterpart is automatically converted to INET6. If the length of the binary\nstring is not equal to 16, it\'s converted with a warning to NULL or to \'::\'\ndepending on the NULL-ability of the result.\n\nAttempts to mix INET6 for result with other data types will return an error.\n\nMixing INET6 with other data types for LEAST and GREATEST, when mixing for\ncomparison and mixing for result are involved at the same time, uses the same\nrules with mixing for result, described in the previous paragraphs.\n\nFunctions and Operators\n-----------------------\n\n* HEX() with an INET6 argument returns a hexadecimal representation of the\nunderlying 16-byte binary string\n* Arithmetic operators (+,-,*,/,MOD,DIV) are not supported for INET6. This may\nchange in the future.\n* The INET6_ATON function now understands INET6 values as an argument\n* The prototypes of the IS_IPV4_COMPAT and IS_IPV4_MAPPED functions have\nchanged from a BINARY(16) to a INET6,\n* When the argument for these two functions is not INET6, automatic implicit\nCAST to INET6 is applied. As a consequence, both functions now understand\narguments in both text representation and binary(16) representation. Before\nMariaDB 10.5.0, these functions understood only binary(16) representation.\n\nPrepared Statement Parameters\n-----------------------------\n\nINET6 understands both text and binary(16) address representation in prepared\nstatement parameters (PREPARE..EXECUTE and EXECUTE IMMEDIATE statements).\n\nMigration between  BINARY(16) and INET6\n---------------------------------------\n\nBefore MariaDB 10.5.0, you may have used BINARY(16) as a storage for IPv6\ninternet addresses, in combination with INET6_ATON and INET6_NTOA to\nrespectively insert and retrieve data.\n\nFrom 10.5, you can ALTER BINARY(16) columns storing IPv6 addresses to INET6.\nAfter such an alter, there is no a need to use INET6_ATON() and INET6_NTOA().\nAddresses can be inserted and retrieved directly.\n\nIt is also possible to convert INET6 columns to BINARY(16) and continue using\nthe data in combination with INET6_NTOA() and INET6_ATON().\n\nExamples\n--------\n\nCREATE TABLE t1 (a INET6);\n\nInserting using short text address notation:\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n\nLong text address notation:\n\nINSERT INTO t1 VALUES (\'2001:0db8:0000:0000:0000:ff00:0042:8329\');\n\n16-byte binary string notation:\n\nINSERT INTO t1 VALUES (0x20010DB8000000000000FF0000428329);\nINSERT INTO t1 VALUES (UNHEX(\'20010DB8000000000000FF0000428329\'));\n\nIPv4 addresses, using IPv4-mapped and IPv4-compatible notations:\n\nINSERT INTO t1 VALUES (\'::ffff:192.0.2.128\'); -- mapped\nINSERT INTO t1 VALUES (\'::192.0.2.128\'); -- compatible\n\nSELECT * FROM t1;\n+------------------------+\n| a                      |\n+------------------------+\n| 2001:db8::ff00:42:8329 |\n| 2001:db8::ff00:42:8329 |\n| 2001:db8::ff00:42:8329 |\n| 2001:db8::ff00:42:8329 |\n| ::ffff:192.0.2.128     |\n| ::192.0.2.128          |\n+------------------------+\n\nIPv4 mapped (or compatible) values still occupy 16 bytes:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'::ffff:192.0.2.128\');\n\nSELECT * FROM t1;\n+--------------------+\n| a                  |\n+--------------------+\n| ::ffff:192.0.2.128 |\n+--------------------+\n\nSELECT HEX(a) FROM t1;\n+----------------------------------+\n| HEX(a)                           |\n+----------------------------------+\n| 00000000000000000000FFFFC0000280 |\n+----------------------------------+\n\nCasting from INET6 to anything other than CHAR returns an error:\n\nSELECT CAST(a AS DECIMAL) FROM t1;\n\nERROR 4079 (HY000): Illegal parameter data type inet6 for operation\n\'decimal_typecast\'\n\nComparison Examples\n-------------------\n\nComparison with another INET6 expression:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n  CREATE OR REPLACE TABLE t2 (a INET6);\n\nINSERT INTO t1 VALUES\n(\'2001:db8::ff00:42:8328\'),(\'2001:db8::ff00:42:8329\');\n  INSERT INTO t2 VALUES\n(\'2001:db8::ff00:42:832a\'),(\'2001:db8::ff00:42:8329\');\n\nSELECT t1.* FROM t1,t2 WHERE t1.a=t2.a;\n  +------------------------+\n  | a                      |\n  +------------------------+\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nWith a character string expression with a text (short or long) address\nrepresentation:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n\nSELECT * FROM t1 WHERE a=\'2001:db8::ff00:42:8329\';\n  +------------------------+\n  | a                      |\n  +------------------------+\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nWith a 16-byte binary string expression:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n\nSELECT * FROM t1 WHERE a=X\'20010DB8000000000000FF0000428329\';\n  +------------------------+\n  | a                      |\n  +------------------------+\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nWith an expression of another data type:\n\nSELECT * FROM t1 WHERE a=1;\nERROR 4078 (HY000): Illegal parameter data types inet6 and int for operation\n\'=\'\n\nMixing for Result Examples\n--------------------------\n\nMixed with another INET6 expression, returning an INET6 data type:\n\nCREATE OR REPLACE TABLE t1 (a INET6, b INET6);\n\nINSERT INTO t1 VALUES (NULL,\'2001:db8::ff00:42:8329\');\n\nSELECT a FROM t1 UNION SELECT b FROM t1;\n  +------------------------+\n  | a                      |\n  +------------------------+\n  | NULL                   |\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nSELECT COALESCE(a, b) FROM t1;\n  +------------------------+\n  | COALESCE(a, b)         |\n  +------------------------+\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nMixed with a character string in text (short or long) address representation:\n\nCREATE OR REPLACE TABLE t1 (a INET6, b VARCHAR(64));\n\nINSERT INTO t1 VALUES (NULL,\'2001:db8::ff00:42:8328\');\n\nINSERT INTO t1 VALUES (NULL,\'2001:db8::ff00:42:832a garbage\');\n\nSELECT COALESCE(a,b) FROM t1;\n  +------------------------+\n  | COALESCE(a,b)          |\n  +------------------------+\n  | 2001:db8::ff00:42:8328 |\n  | NULL                   |\n  +------------------------+\n  2 rows in set, 1 warning (0.001 sec)\n\nSHOW WARNINGS;\n\n+---------+------+---------------------------------------------------------+\n  | Level   | Code | Message\n|\n\n+---------+------+---------------------------------------------------------+\n  | Warning | 1292 | Incorrect inet6 value: \'2001:db8::ff00:42:832a garbage\'\n|\n\n+---------+------+---------------------------------------------------------+\n\nMixed with a 16-byte binary string:\n\nCREATE OR REPLACE TABLE t1 (a INET6, b VARBINARY(16));\n\nINSERT INTO t1 VALUES (NULL,CONCAT(0xFFFF,REPEAT(0x0000,6),0xFFFF));\n\nINSERT INTO t1 VALUES (NULL,0x00/*garbage*/);\n\nSELECT COALESCE(a,b) FROM t1;\n  +---------------+\n  | COALESCE(a,b) |\n  +---------------+\n  | ffff::ffff    |\n  | NULL          |\n  +---------------+\n  2 rows in set, 1 warning (0.001 sec)\n\nSHOW WARNINGS;\n  +---------+------+-------------------------------+\n  | Level   | Code | Message                       |\n  +---------+------+-------------------------------+\n  | Warning | 1292 | Incorrect inet6 value: \'\\x00\' |\n  +---------+------+-------------------------------+\n\nMixing with other data types:\n\nSELECT CAST(\'ffff::ffff\' AS INET6) UNION SELECT 1;\nERROR 4078 (HY000): Illegal parameter data types inet6 and int for operation\n\'UNION\'\n\nFunctions and Operators Examples\n--------------------------------\n\nHEX with an INET6 argument returning a hexadecimal representation:\n\nSELECT HEX(CAST(\'2001:db8::ff00:42:8329\' AS INET6));\n  +----------------------------------------------+\n  | HEX(CAST(\'2001:db8::ff00:42:8329\' AS INET6)) |\n  +----------------------------------------------+\n  | 20010DB8000000000000FF0000428329             |\n  +----------------------------------------------+\n\nINET6_ATON now understands INET6 values as an argument:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n\nSELECT a, HEX(INET6_ATON(a)) FROM t1;\n  +------------------------+----------------------------------+\n  | a                      | HEX(INET6_ATON(a))               |\n  +------------------------+----------------------------------+\n  | 2001:db8::ff00:42:8329 | 20010DB8000000000000FF0000428329 |\n  +------------------------+----------------------------------+\n\nIS_IPV4_COMPAT and IS_IPV4_MAPPED prototype now a BINARY(16)):\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n  INSERT INTO t1 VALUES (\'::ffff:192.168.0.1\');\n  INSERT INTO t1 VALUES (\'::192.168.0.1\');\n\nSELECT a, IS_IPV4_MAPPED(a), IS_IPV4_COMPAT(a) FROM t1;\n  +------------------------+-------------------+-------------------+\n  | a                      | IS_IPV4_MAPPED(a) | IS_IPV4_COMPAT(a) |\n  +------------------------+-------------------+-------------------+\n  | 2001:db8::ff00:42:8329 |                 0 |                 0 |\n  | ::ffff:192.168.0.1     |                 1 |                 0 |\n  | ::192.168.0.1          |                 0 |                 1 |\n  +------------------------+-------------------+-------------------+\n\nAutomatic implicit CAST to INET6:\n\nCREATE OR REPLACE TABLE t1 (\n   a INET6,\n   b VARCHAR(39) DEFAULT a\n  );\n\nINSERT INTO t1 (a) VALUES (\'ffff::ffff\'),(\'::ffff:192.168.0.1\');\n\nSELECT a, IS_IPV4_MAPPED(a), b, IS_IPV4_MAPPED(b) FROM t1;\n\n+--------------------+-------------------+--------------------+----------------\n--+\n  | a                  | IS_IPV4_MAPPED(a) | b                  |\nIS_IPV4_MAPPED(b) |\n\n+--------------------+-------------------+--------------------+----------------\n--+\n  | ffff::ffff         |                 0 | ffff::ffff         |\n  0 |\n  | ::ffff:192.168.0.1 |                 1 | ::ffff:192.168.0.1 |\n  1 |\n\n+--------------------+-------------------+--------------------+----------------\n--+\n\nCREATE OR REPLACE TABLE t1 (\n   a INET6,\n   b BINARY(16) DEFAULT UNHEX(HEX(a))\n  );\n\nINSERT INTO t1 (a) VALUES (\'ffff::ffff\'),(\'::ffff:192.168.0.1\');\n\nSELECT a, IS_IPV4_MAPPED(a), HEX(b), IS_IPV4_MAPPED(b) FROM t1;\n\n+--------------------+-------------------+----------------------------------+--\n----------------+\n  | a                  | IS_IPV4_MAPPED(a) | HEX(b)\n | IS_IPV4_MAPPED(b) |\n\n+--------------------+-------------------+----------------------------------+--\n----------------+\n  | ffff::ffff         |                 0 |\nFFFF000000000000000000000000FFFF |                 0 |\n  | ::ffff:192.168.0.1 |                 1 |\n00000000000000000000FFFFC0A80001 |                 1 |\n\n+--------------------+-------------------+----------------------------------+--\n----------------+\n\nPrepared Statement Parameters Examples\n--------------------------------------\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nEXECUTE IMMEDIATE \'INSERT INTO t1 VALUES (?)\' USING \'ffff::fffe\';\nEXECUTE IMMEDIATE \'INSERT INTO t1 VALUES (?)\' USING\nX\'FFFF000000000000000000000000FFFF\';\n\nSELECT * FROM t1;\n+------------+\n| a          |\n+------------+\n| ffff::fffe |\n| ffff::ffff |\n+------------+\n\nEXECUTE IMMEDIATE \'SELECT * FROM t1 WHERE a=?\' USING \'ffff::fffe\';\n+------------+\n| a          |\n+------------+\n| ffff::fffe |\n+------------+\n\nEXECUTE IMMEDIATE \'SELECT * FROM t1 WHERE a=?\' USING\nX\'FFFF000000000000000000000000FFFF\';\n+------------+\n| a          |\n+------------+\n| ffff::ffff |\n+------------+\n\nMigration between BINARY(16) and INET6 Examples\n-----------------------------------------------\n\nBefore MariaDB 10.5:\n\nCREATE OR REPLACE TABLE t1 (a BINARY(16));\n\nINSERT INTO t1 VALUES (INET6_ATON(\'ffff::ffff\'));\n\nSELECT INET6_NTOA(a) FROM t1;\n+---------------+\n| INET6_NTOA(a) |\n+---------------+\n| ffff::ffff    |\n+---------------+\n\nMigrating to INET6, from MariaDB 10.5:\n\nALTER TABLE t1 MODIFY a INET6;\n\nINSERT INTO t1 VALUES (\'ffff::fffe\');\n\nSELECT * FROM t1;\n+------------+\n| a          |\n+------------+\n| ffff::ffff |\n| ffff::fffe |\n+------------+\n\nMigration from INET6 to BINARY(16):\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\nINSERT INTO t1 VALUES (\'::ffff:192.168.0.1\');\nINSERT INTO t1 VALUES (\'::192.168.0.1\');\n\nALTER TABLE t1 MODIFY a BINARY(16);\n\nSELECT INET6_NTOA(a) FROM t1;\n+------------------------+\n| INET6_NTOA(a)          |\n+------------------------+\n| 2001:db8::ff00:42:8329 |\n| ::ffff:192.168.0.1     |\n| ::192.168.0.1          |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/inet6/','','https://mariadb.com/kb/en/inet6/'),(274,'MEDIUMBLOB',23,'Syntax\n------\n\nMEDIUMBLOB\n\nDescription\n-----------\n\nA BLOB column with a maximum length of 16,777,215 (224 - 1) bytes. Each\nMEDIUMBLOB value is stored using a three-byte length prefix that indicates the\nnumber of bytes in the value.\n\nURL: https://mariadb.com/kb/en/mediumblob/','','https://mariadb.com/kb/en/mediumblob/'),(275,'MEDIUMTEXT',23,'Syntax\n------\n\nMEDIUMTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nDescription\n-----------\n\nA TEXT column with a maximum length of 16,777,215 (224 - 1) characters. The\neffective maximum length is less if the value contains multi-byte characters.\nEach MEDIUMTEXT value is stored using a three-byte length prefix that\nindicates the number of bytes in the value.\n\nURL: https://mariadb.com/kb/en/mediumtext/','','https://mariadb.com/kb/en/mediumtext/'),(276,'LONGBLOB',23,'Syntax\n------\n\nLONGBLOB\n\nDescription\n-----------\n\nA BLOB column with a maximum length of 4,294,967,295 bytes or 4GB (232 - 1).\nThe effective maximum length of LONGBLOB columns depends on the configured\nmaximum packet size in the client/server protocol and available memory. Each\nLONGBLOB value is stored using a four-byte length prefix that indicates the\nnumber of bytes in the value.\n\nOracle Mode\n-----------\n\nMariaDB starting with 10.3\n--------------------------\nIn Oracle mode from MariaDB 10.3, BLOB is a synonym for LONGBLOB.\n\nURL: https://mariadb.com/kb/en/longblob/','','https://mariadb.com/kb/en/longblob/'),(280,'TINYBLOB',23,'Syntax\n------\n\nTINYBLOB\n\nDescription\n-----------\n\nA BLOB column with a maximum length of 255 (28 - 1) bytes. Each TINYBLOB value\nis stored using a one-byte length prefix that indicates the number of bytes in\nthe value.\n\nURL: https://mariadb.com/kb/en/tinyblob/','','https://mariadb.com/kb/en/tinyblob/'),(281,'TINYTEXT',23,'Syntax\n------\n\nTINYTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nDescription\n-----------\n\nA TEXT column with a maximum length of 255 (28 - 1) characters. The effective\nmaximum length is less if the value contains multi-byte characters. Each\nTINYTEXT value is stored using a one-byte length prefix that indicates the\nnumber of bytes in the value.\n\nURL: https://mariadb.com/kb/en/tinytext/','','https://mariadb.com/kb/en/tinytext/'),(147,'GET_LOCK',14,'Syntax\n------\n\nGET_LOCK(str,timeout)\n\nDescription\n-----------\n\nTries to obtain a lock with a name given by the string str, using a timeout of\ntimeout seconds. Returns 1 if the lock was obtained successfully, 0 if the\nattempt timed out (for example, because another client has previously locked\nthe name), or NULL if an error occurred (such as running out of memory or the\nthread was killed with mysqladmin kill).\n\nA lock is released with RELEASE_LOCK(), when the connection terminates (either\nnormally or abnormally). A connection can hold multiple locks at the same\ntime, so a lock that is no longer needed needs to be explicitly released.\n\nThe IS_FREE_LOCK function returns whether a specified lock a free or not, and\nthe IS_USED_LOCK whether the function is in use or not.\n\nLocks obtained with GET_LOCK() do not interact with transactions. That is,\ncommitting a transaction does not release any such locks obtained during the\ntransaction.\n\nIt is also possible to recursively set the same lock. If a lock with the same\nname is set n times, it needs to be released n times as well.\n\nstr is case insensitive for GET_LOCK() and related functions. If str is an\nempty string or NULL, GET_LOCK() returns NULL and does nothing. From MariaDB\n10.2.2, timeout supports microseconds. Before then, it was rounded to the\nclosest integer.\n\nIf the metadata_lock_info plugin is installed, locks acquired with this\nfunction are visible in the Information Schema METADATA_LOCK_INFO table.\n\nThis function can be used to implement application locks or to simulate record\nlocks. Names are locked on a server-wide basis. If a name has been locked by\none client, GET_LOCK() blocks any request by another client for a lock with\nthe same name. This allows clients that agree on a given lock name to use the\nname to perform cooperative advisory locking. But be aware that it also allows\na client that is not among the set of cooperating clients to lock a name,\neither inadvertently or deliberately, and thus prevent any of the cooperating\nclients from locking that name. One way to reduce the likelihood of this is to\nuse lock names that are database-specific or application-specific. For\nexample, use lock names of the form db_name.str or app_name.str.\n\nStatements using the GET_LOCK function are not safe for statement-based\nreplication.\n\nThe patch to permit multiple locks was contributed by Konstantin \"Kostja\"\nOsipov (MDEV-3917).\n\nExamples\n--------\n\nSELECT GET_LOCK(\'lock1\',10);\n+----------------------+\n| GET_LOCK(\'lock1\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT IS_FREE_LOCK(\'lock1\'), IS_USED_LOCK(\'lock1\');\n+-----------------------+-----------------------+\n| IS_FREE_LOCK(\'lock1\') | IS_USED_LOCK(\'lock1\') |\n+-----------------------+-----------------------+\n|                     0 |                    46 |\n+-----------------------+-----------------------+\n\nSELECT IS_FREE_LOCK(\'lock2\'), IS_USED_LOCK(\'lock2\');\n+-----------------------+-----------------------+\n| IS_FREE_LOCK(\'lock2\') | IS_USED_LOCK(\'lock2\') |\n+-----------------------+-----------------------+\n|                     1 |                  NULL |\n+-----------------------+-----------------------+\n\nMultiple locks can be held:\n\nSELECT GET_LOCK(\'lock2\',10);\n+----------------------+\n| GET_LOCK(\'lock2\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT IS_FREE_LOCK(\'lock1\'), IS_FREE_LOCK(\'lock2\');\n+-----------------------+-----------------------+\n| IS_FREE_LOCK(\'lock1\') | IS_FREE_LOCK(\'lock2\') |\n+-----------------------+-----------------------+\n|                     0 |                     0 |\n+-----------------------+-----------------------+\n\nSELECT RELEASE_LOCK(\'lock1\'), RELEASE_LOCK(\'lock2\');\n+-----------------------+-----------------------+\n| RELEASE_LOCK(\'lock1\') | RELEASE_LOCK(\'lock2\') |\n+-----------------------+-----------------------+\n|                     1 |                     1 |\n+-----------------------+-----------------------+\n\nIt is possible to hold the same lock recursively. This example is viewed using\nthe metadata_lock_info plugin:\n\nSELECT GET_LOCK(\'lock3\',10);\n+----------------------+\n| GET_LOCK(\'lock3\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT GET_LOCK(\'lock3\',10);\n+----------------------+\n| GET_LOCK(\'lock3\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n| THREAD_ID | LOCK_MODE           | LOCK_DURATION | LOCK_TYPE | TABLE_SCHEMA |\nTABLE_NAME |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n|        46 | MDL_SHARED_NO_WRITE | NULL          | User lock | lock3        |\n     |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n\nSELECT RELEASE_LOCK(\'lock3\');\n+-----------------------+\n| RELEASE_LOCK(\'lock3\') |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n| THREAD_ID | LOCK_MODE           | LOCK_DURATION | LOCK_TYPE | TABLE_SCHEMA |\nTABLE_NAME |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n|        46 | MDL_SHARED_NO_WRITE | NULL          | User lock | lock3        |\n     |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n\nSELECT RELEASE_LOCK(\'lock3\');\n+-----------------------+\n| RELEASE_LOCK(\'lock3\') |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\nEmpty set (0.000 sec)\n\nTimeout example: Connection 1:\n\nSELECT GET_LOCK(\'lock4\',10);\n+----------------------+\n| GET_LOCK(\'lock4\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 2:\n\nSELECT GET_LOCK(\'lock4\',10);\n\nAfter 10 seconds...\n\n+----------------------+\n| GET_LOCK(\'lock4\',10) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nDeadlocks are automatically detected and resolved. Connection 1:\n\nSELECT GET_LOCK(\'lock5\',10); \n+----------------------+\n| GET_LOCK(\'lock5\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 2:\n\nSELECT GET_LOCK(\'lock6\',10);\n+----------------------+\n| GET_LOCK(\'lock6\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 1:\n\nSELECT GET_LOCK(\'lock6\',10); \n+----------------------+\n| GET_LOCK(\'lock6\',10) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nConnection 2:\n\nSELECT GET_LOCK(\'lock5\',10);\nERROR 1213 (40001): Deadlock found when trying to get lock; try restarting\ntransaction\n\nURL: https://mariadb.com/kb/en/get_lock/','','https://mariadb.com/kb/en/get_lock/'),(284,'SET Data Type',23,'Syntax\n------\n\nSET(\'value1\',\'value2\',...) [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nDescription\n-----------\n\nA set. A string object that can have zero or more values, each of which must\nbe chosen from the list of values \'value1\', \'value2\', ... A SET column can\nhave a maximum of 64 members. SET values are represented internally as\nintegers.\n\nSET values cannot contain commas.\n\nIf a SET contains duplicate values, an error will be returned if strict mode\nis enabled, or a warning if strict mode is not enabled.\n\nURL: https://mariadb.com/kb/en/set-data-type/','','https://mariadb.com/kb/en/set-data-type/'),(154,'IS_IPV4_COMPAT',14,'Syntax\n------\n\nIS_IPV4_COMPAT(expr)\n\nDescription\n-----------\n\nReturns 1 if a given numeric binary string IPv6 address, such as returned by\nINET6_ATON(), is IPv4-compatible, otherwise returns 0.\n\nMariaDB starting with 10.5.0\n----------------------------\nFrom MariaDB 10.5.0, when the argument is not INET6, automatic implicit CAST\nto INET6 is applied. As a consequence, IS_IPV4_COMPAT now understands\narguments in both text representation and binary(16) representation. Before\nMariaDB 10.5.0, the function understood only binary(16) representation.\n\nExamples\n--------\n\nSELECT IS_IPV4_COMPAT(INET6_ATON(\'::10.0.1.1\'));\n+------------------------------------------+\n| IS_IPV4_COMPAT(INET6_ATON(\'::10.0.1.1\')) |\n+------------------------------------------+\n|                                        1 |\n+------------------------------------------+\n\nSELECT IS_IPV4_COMPAT(INET6_ATON(\'::48f3::d432:1431:ba23:846f\'));\n+-----------------------------------------------------------+\n| IS_IPV4_COMPAT(INET6_ATON(\'::48f3::d432:1431:ba23:846f\')) |\n+-----------------------------------------------------------+\n|                                                         0 |\n+-----------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/is_ipv4_compat/','','https://mariadb.com/kb/en/is_ipv4_compat/'),(155,'IS_IPV4_MAPPED',14,'Syntax\n------\n\nIS_IPV4_MAPPED(expr)\n\nDescription\n-----------\n\nReturns 1 if a given a numeric binary string IPv6 address, such as returned by\nINET6_ATON(), is a valid IPv4-mapped address, otherwise returns 0.\n\nMariaDB starting with 10.5.0\n----------------------------\nFrom MariaDB 10.5.0, when the argument is not INET6, automatic implicit CAST\nto INET6 is applied. As a consequence, IS_IPV4_MAPPED now understands\narguments in both text representation and binary(16) representation. Before\nMariaDB 10.5.0, the function understood only binary(16) representation.\n\nExamples\n--------\n\nSELECT IS_IPV4_MAPPED(INET6_ATON(\'::10.0.1.1\'));\n+------------------------------------------+\n| IS_IPV4_MAPPED(INET6_ATON(\'::10.0.1.1\')) |\n+------------------------------------------+\n|                                        0 |\n+------------------------------------------+\n\nSELECT IS_IPV4_MAPPED(INET6_ATON(\'::ffff:10.0.1.1\'));\n+-----------------------------------------------+\n| IS_IPV4_MAPPED(INET6_ATON(\'::ffff:10.0.1.1\')) |\n+-----------------------------------------------+\n|                                             1 |\n+-----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/is_ipv4_mapped/','','https://mariadb.com/kb/en/is_ipv4_mapped/'),(159,'MASTER_POS_WAIT',14,'Syntax\n------\n\nMASTER_POS_WAIT(log_name,log_pos[,timeout,[\"connection_name\"]])\n\nDescription\n-----------\n\nThis function is useful in replication for controlling primary/replica\nsynchronization. It blocks until the replica has read and applied all updates\nup to the specified position (log_name,log_pos) in the primary log. The return\nvalue is the number of log events the replica had to wait for to advance to\nthe specified position. The function returns NULL if the replica SQL thread is\nnot started, the replica\'s primary information is not initialized, the\narguments are incorrect, or an error occurs. It returns -1 if the timeout has\nbeen exceeded. If the replica SQL thread stops while MASTER_POS_WAIT() is\nwaiting, the function returns NULL. If the replica is past the specified\nposition, the function returns immediately.\n\nIf a timeout value is specified, MASTER_POS_WAIT() stops waiting when timeout\nseconds have elapsed. timeout must be greater than 0; a zero or negative\ntimeout means no timeout.\n\nThe connection_name is used when you are using multi-source-replication. If\nyou don\'t specify it, it\'s set to the value of the default_master_connection\nsystem variable.\n\nStatements using the MASTER_POS_WAIT() function are not safe for replication.\n\nURL: https://mariadb.com/kb/en/master_pos_wait/','','https://mariadb.com/kb/en/master_pos_wait/'),(161,'RELEASE_ALL_LOCKS',14,'MariaDB until 10.5.2\n--------------------\nRELEASE_ALL_LOCKS was added in MariaDB 10.5.2.\n\nSyntax\n------\n\nRELEASE_ALL_LOCKS()\n\nDescription\n-----------\n\nReleases all named locks held by the current session. Returns the number of\nlocks released, or 0 if none were held.\n\nStatements using the RELEASE_ALL_LOCKS function are not safe for\nstatement-based replication.\n\nExamples\n--------\n\nSELECT RELEASE_ALL_LOCKS();\n+---------------------+\n| RELEASE_ALL_LOCKS() | \n+---------------------+\n|                   0 |\n+---------------------+\n\nSELECT GET_LOCK(\'lock1\',10);\n+----------------------+\n| GET_LOCK(\'lock1\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT RELEASE_ALL_LOCKS();\n+---------------------+\n| RELEASE_ALL_LOCKS() | \n+---------------------+\n|                   1 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/release_all_locks/','','https://mariadb.com/kb/en/release_all_locks/'),(288,'TIMESTAMP',23,'Syntax\n------\n\nTIMESTAMP [(<microsecond precision)]\n\nDescription\n-----------\n\nA timestamp in the format YYYY-MM-DD HH:MM:SS.ffffff.\n\nThe timestamp field is generally used to define at which moment in time a row\nwas added or updated and by default will automatically be assigned the current\ndatetime when a record is inserted or updated. The automatic properties only\napply to the first TIMESTAMP in the record; subsequent TIMESTAMP columns will\nnot be changed.\n\nMariaDB includes the --mysql56-temporal-format option, on by default, which\nallows MariaDB to store TIMESTAMPs using the same low-level format MySQL 5.6\nuses.\n\nFor more information, see Internal Format.\n\nSupported Values\n----------------\n\nMariaDB stores values that use the TIMESTAMP data type as the number of\nseconds since \'1970-01-01 00:00:00\' (UTC). This means that the TIMESTAMP data\ntype can hold values between \'1970-01-01 00:00:01\' (UTC) and \'2038-01-19\n03:14:07\' (UTC).\n\nMariaDB can also store microseconds with a precision between 0 and 6. If no\nmicrosecond precision is specified, then 0 is used by default.\n\nAutomatic Values\n----------------\n\nMariaDB has special behavior for the first column that uses the TIMESTAMP data\ntype in a specific table. For the first column that uses the TIMESTAMP data\ntype in a specific table, MariaDB automatically assigns the following\nproperties to the column:\n\n* DEFAULT CURRENT_TIMESTAMP\n* ON UPDATE CURRENT_TIMESTAMP\n\nThis means that if the column is not explicitly assigned a value in an INSERT\nor UPDATE query, then MariaDB will automatically initialize the column\'s value\nwith the current date and time.\n\nThis automatic initialization for INSERT and UPDATE queries can also be\nexplicitly enabled for a column that uses the TIMESTAMP data type by\nspecifying the DEFAULT CURRENT_TIMESTAMP and ON UPDATE CURRENT_TIMESTAMP\nclauses for the column. In these clauses, any synonym of CURRENT_TIMESTAMP is\naccepted, including CURRENT_TIMESTAMP(), NOW(), LOCALTIME, LOCALTIME(),\nLOCALTIMESTAMP, and LOCALTIMESTAMP().\n\nThis automatic initialization for INSERT queries can also be explicitly\ndisabled for a column that uses the TIMESTAMP data type by specifying a\nconstant DEFAULT value. For example, DEFAULT 0.\n\nThis automatic initialization for UPDATE queries can also be explicitly\ndisabled for a column that uses the TIMESTAMP data type by specifying a\nDEFAULT clause for the column, but no ON UPDATE clause. If a DEFAULT clause is\nexplicitly specified for a column that uses the TIMESTAMP data type, but an ON\nUPDATE clause is not specified for the column, then the timestamp value will\nnot automatically change when an UPDATE statement is executed.\n\nMariaDB also has special behavior if NULL is assigned to column that uses the\nTIMESTAMP data type. If the column is assigned the NULL value in an INSERT or\nUPDATE query, then MariaDB will automatically initialize the column\'s value\nwith the current date and time. For details, see NULL values in MariaDB.\n\nThis automatic initialization for NULL values can also be explicitly disabled\nfor a column that uses the TIMESTAMP data type by specifying the NULL\nattribute for the column. In this case, if the column\'s value is set to NULL,\nthen the column\'s value will actually be set to NULL.\n\nTime Zones\n----------\n\nIf a column uses the TIMESTAMP data type, then any inserted values are\nconverted from the session\'s time zone to Coordinated Universal Time (UTC)\nwhen stored, and converted back to the session\'s time zone when retrieved.\n\nMariaDB does not currently store any time zone identifier with the value of\nthe TIMESTAMP data type. See MDEV-10018 for more information.\n\nMariaDB does not currently support time zone literals that contain time zone\nidentifiers. See MDEV-11829 for more information.\n\nLimitations\n-----------\n\n* Because the TIMESTAMP value is stored as Epoch Seconds, the timestamp value\n\'1970-01-01 00:00:00\' (UTC) is reserved since the second #0 is used to\nrepresent \'0000-00-00 00:00:00\'.\n* In MariaDB 5.5 and before there could only be one TIMESTAMP column per table\nthat had CURRENT_TIMESTAMP defined as its default value. This limit has no\nlonger applied since MariaDB 10.0.\n\nSQL_MODE=MAXDB\n--------------\n\nIf the SQL_MODE is set to MAXDB, TIMESTAMP fields will be silently converted\nto DATETIME.\n\nInternal Format\n---------------\n\nIn MariaDB 10.1.2 a new temporal format was introduced from MySQL 5.6 that\nalters how the TIME, DATETIME and TIMESTAMP columns operate at lower levels.\nThese changes allow these temporal data types to have fractional parts and\nnegative values. You can disable this feature using the\nmysql56_temporal_format system variable.\n\nTables that include TIMESTAMP values that were created on an older version of\nMariaDB or that were created while the mysql56_temporal_format system variable\nwas disabled continue to store data using the older data type format.\n\nIn order to update table columns from the older format to the newer format,\nexecute an ALTER TABLE... MODIFY COLUMN statement that changes the column to\nthe *same* data type. This change may be needed if you want to export the\ntable\'s tablespace and import it onto a server that has\nmysql56_temporal_format=ON set (see MDEV-15225).\n\nFor instance, if you have a TIMESTAMP column in your table:\n\nSHOW VARIABLES LIKE \'mysql56_temporal_format\';\n\n+-------------------------+-------+\n| Variable_name           | Value |\n+-------------------------+-------+\n| mysql56_temporal_format | ON    |\n+-------------------------+-------+\n\nALTER TABLE example_table MODIFY ts_col TIMESTAMP;\n\nWhen MariaDB executes the ALTER TABLE statement, it converts the data from the\nolder temporal format to the newer one.\n\nIn the event that you have several tables and columns using temporal data\ntypes that you want to switch over to the new format, make sure the system\nvariable is enabled, then perform a dump and restore using mysqldump. The\ncolumns using relevant temporal data types are restored using the new temporal\nformat.\n\nStarting from MariaDB 10.5.1 columns with old temporal formats are marked with\na /* mariadb-5.3 */ comment in the output of SHOW CREATE TABLE, SHOW COLUMNS,\nDESCRIBE statements, as well as in the COLUMN_TYPE column of the\nINFORMATION_SCHEMA.COLUMNS Table.\n\nSHOW CREATE TABLE mariadb5312_timestamp\\G\n*************************** 1. row ***************************\n   Table: mariadb5312_timestamp\nCreate Table: CREATE TABLE `mariadb5312_timestamp` (\n `ts0` timestamp /* mariadb-5.3 */ NOT NULL DEFAULT current_timestamp() ON\nUPDATE current_timestamp(),\n `ts6` timestamp(6) /* mariadb-5.3 */ NOT NULL DEFAULT \'0000-00-00\n00:00:00.000000\'\n) ENGINE=MyISAM DEFAULT CHARSET=latin1\n\nNote: Prior to MySQL 4.1 a different format for the TIMESTAMP datatype was\nused. This format is unsupported in MariaDB 5.1 and upwards.\n\nExamples\n--------\n\nCREATE TABLE t (id INT, ts TIMESTAMP);\n\nDESC t;\n+-------+-----------+------+-----+-------------------+-------------------------\n---+\n| Field | Type      | Null | Key | Default           | Extra                  \n  |\n+-------+-----------+------+-----+-------------------+-------------------------\n---+\n| id    | int(11)   | YES  |     | NULL              |                        \n  |\n| ts    | timestamp | NO   |     | CURRENT_TIMESTAMP | on update\nCURRENT_TIMESTAMP |\n+-------+-----------+------+-----+-------------------+-------------------------\n---+\n\nINSERT INTO t(id)  VALUES (1),(2);\n\nSELECT * FROM t;\n+------+---------------------+\n| id   | ts                  |\n+------+---------------------+\n|    1 | 2013-07-22 12:50:05 |\n|    2 | 2013-07-22 12:50:05 |\n+------+---------------------+\n\nINSERT INTO t  VALUES (3,NULL),(4,\'2001-07-22 12:12:12\');\n\nSELECT * FROM t;\n+------+---------------------+\n| id   | ts                  |\n+------+---------------------+\n|    1 | 2013-07-22 12:50:05 |\n|    2 | 2013-07-22 12:50:05 |\n|    3 | 2013-07-22 12:51:56 |\n|    4 | 2001-07-22 12:12:12 |\n+------+---------------------+\n\nConverting to Unix epoch:\n\nSELECT ts, UNIX_TIMESTAMP(ts) FROM t;\n+---------------------+--------------------+\n| ts                  | UNIX_TIMESTAMP(ts) |\n+---------------------+--------------------+\n| 2013-07-22 12:50:05 |         1374490205 |\n| 2013-07-22 12:50:05 |         1374490205 |\n| 2013-07-22 12:51:56 |         1374490316 |\n| 2001-07-22 12:12:12 |          995796732 |\n+---------------------+--------------------+\n\nUpdate also changes the timestamp:\n\nUPDATE t set id=5 WHERE id=1;\n\nSELECT * FROM t;\n+------+---------------------+\n| id   | ts                  |\n+------+---------------------+\n|    5 | 2013-07-22 14:52:33 |\n|    2 | 2013-07-22 12:50:05 |\n|    3 | 2013-07-22 12:51:56 |\n|    4 | 2001-07-22 12:12:12 |\n+------+---------------------+\n\nDefault NULL:\n\nCREATE TABLE t2 (id INT, ts TIMESTAMP NULL ON UPDATE CURRENT_TIMESTAMP);\n\nINSERT INTO t(id)  VALUES (1),(2);\n\nSELECT * FROM t2;\n\nINSERT INTO t2(id)  VALUES (1),(2);\n\nSELECT * FROM t2;\n+------+------+\n| id   | ts   |\n+------+------+\n|    1 | NULL |\n|    2 | NULL |\n+------+------+\n\nUPDATE t2 SET id=3 WHERE id=1;\n\nSELECT * FROM t2;\n+------+---------------------+\n| id   | ts                  |\n+------+---------------------+\n|    3 | 2013-07-22 15:32:22 |\n|    2 | NULL                |\n+------+---------------------+\n\nOnly the first timestamp is automatically inserted and updated:\n\nCREATE TABLE t3 (id INT, ts1 TIMESTAMP, ts2 TIMESTAMP);\n\nINSERT INTO t3(id)  VALUES (1),(2);\n\nSELECT * FROM t3;\n+------+---------------------+---------------------+\n| id   | ts1                 | ts2                 |\n+------+---------------------+---------------------+\n|    1 | 2013-07-22 15:35:07 | 0000-00-00 00:00:00 |\n|    2 | 2013-07-22 15:35:07 | 0000-00-00 00:00:00 |\n+------+---------------------+---------------------+\n\nDESC t3;\n+-------+-----------+------+-----+---------------------+-----------------------\n-----+\n| Field | Type      | Null | Key | Default             | Extra                \n   |\n+-------+-----------+------+-----+---------------------+-----------------------\n-----+\n| id    | int(11)   | YES  |     | NULL                |                      \n   |\n| ts1   | timestamp | NO   |     | CURRENT_TIMESTAMP   | on update\nCURRENT_TIMESTAMP |\n| ts2   | timestamp | NO   |     | 0000-00-00 00:00:00 |                      \n   |\n+-------+-----------+------+-----+---------------------+-----------------------\n-----+\n\nExplicitly setting a timestamp with the CURRENT_TIMESTAMP function:\n\nINSERT INTO t3(id,ts2)  VALUES (3,CURRENT_TIMESTAMP());\n\nSELECT * FROM t3;\n+------+---------------------+---------------------+\n| id   | ts1                 | ts2                 |\n+------+---------------------+---------------------+\n|    1 | 2013-07-22 15:35:07 | 0000-00-00 00:00:00 |\n|    2 | 2013-07-22 15:35:07 | 0000-00-00 00:00:00 |\n|    3 | 2013-07-22 15:38:52 | 2013-07-22 15:38:52 |\n+------+---------------------+---------------------+\n\nSpecifying the timestamp as NOT NULL:\n\nCREATE TABLE t4 (id INT, ts TIMESTAMP NOT NULL);\n\nINSERT INTO t4(id)  VALUES (1);\nSELECT SLEEP(1);\nINSERT INTO t4(id,ts) VALUES (2,NULL);\n\nSELECT * FROM t4;\n\nURL: https://mariadb.com/kb/en/timestamp/','','https://mariadb.com/kb/en/timestamp/'),(298,'GOTO',24,'MariaDB starting with 10.3\n--------------------------\nThe GOTO statement was introduced in MariaDB 10.3 for Oracle compatibility.\n\nSyntax\n------\n\nGOTO label\n\nDescription\n-----------\n\nThe GOTO statement causes the code to jump to the specified label, and\ncontinue operating from there. It is only accepted when in Oracle mode.\n\nExample\n-------\n\nSET sql_mode=ORACLE;\n\nDELIMITER //\n\nCREATE OR REPLACE PROCEDURE p1 AS\n\nBEGIN\n\nSELECT 1;\n GOTO label;\n SELECT 2;\n <<label>>\n SELECT 3;\n\nEND;\n\n//\n\nDELIMITER\n\ncall p1();\n+---+\n| 1 |\n+---+\n| 1 |\n+---+\n1 row in set (0.000 sec)\n\n+---+\n| 3 |\n+---+\n| 3 |\n+---+\n1 row in set (0.000 sec)\n\nURL: https://mariadb.com/kb/en/goto/','','https://mariadb.com/kb/en/goto/'),(299,'IF',24,'Syntax\n------\n\nIF search_condition THEN statement_list\n  [ELSEIF search_condition THEN statement_list] ...\n  [ELSE statement_list]\nEND IF;\n\nDescription\n-----------\n\nIF implements a basic conditional construct. If the search_condition evaluates\nto true, the corresponding SQL statement list is executed. If no\nsearch_condition matches, the statement list in the ELSE clause is executed.\nEach statement_list consists of one or more statements.\n\nURL: https://mariadb.com/kb/en/if/','','https://mariadb.com/kb/en/if/'),(303,'LOOP',24,'Syntax\n------\n\n[begin_label:] LOOP\n  statement_list\nEND LOOP [end_label]\n\nDescription\n-----------\n\nLOOP implements a simple loop construct, enabling repeated execution of the\nstatement list, which consists of one or more statements, each terminated by a\nsemicolon (i.e., ;) statement delimiter. The statements within the loop are\nrepeated until the loop is exited; usually this is accomplished with a LEAVE\nstatement.\n\nA LOOP statement can be labeled. end_label cannot be given unless begin_label\nalso is present. If both are present, they must be the same.\n\nSee Delimiters in the mysql client for more on delimiter usage in the client.\n\nURL: https://mariadb.com/kb/en/loop/','','https://mariadb.com/kb/en/loop/'),(306,'RETURN',24,'Syntax\n------\n\nRETURN expr\n\nThe RETURN statement terminates execution of a stored function and returns the\nvalue expr to the function caller. There must be at least one RETURN statement\nin a stored function. If the function has multiple exit points, all exit\npoints must have a RETURN.\n\nThis statement is not used in stored procedures, triggers, or events. LEAVE\ncan be used instead.\n\nThe following example shows that RETURN can return the result of a scalar\nsubquery:\n\nCREATE FUNCTION users_count() RETURNS BOOL\n READS SQL DATA\nBEGIN\n RETURN (SELECT COUNT(DISTINCT User) FROM mysql.user);\nEND;\n\nURL: https://mariadb.com/kb/en/return/','','https://mariadb.com/kb/en/return/'),(158,'MASTER_GTID_WAIT',14,'Syntax\n------\n\nMASTER_GTID_WAIT(gtid-list[, timeout)\n\nDescription\n-----------\n\nThis function takes a string containing a comma-separated list of global\ntransaction id\'s (similar to the value of, for example, gtid_binlog_pos). It\nwaits until the value of gtid_slave_pos has the same or higher seq_no within\nall replication domains specified in the gtid-list; in other words, it waits\nuntil the slave has reached the specified GTID position.\n\nAn optional second argument gives a timeout in seconds. If the timeout expires\nbefore the specified GTID position is reached, then the function returns -1.\nPassing NULL or a negative number for the timeout means no timeout, and the\nfunction will wait indefinitely.\n\nIf the wait completes without a timeout, 0 is returned. Passing NULL for the\ngtid-list makes the function return NULL immediately, without waiting.\n\nThe gtid-list may be the empty string, in which case MASTER_GTID_WAIT()\nreturns immediately. If the gtid-list contains fewer domains than\ngtid_slave_pos, then only those domains are waited upon. If gtid-list contains\na domain that is not present in @@gtid_slave_pos, then MASTER_GTID_WAIT() will\nwait until an event containing such domain_id arrives on the slave (or until\ntimed out or killed).\n\nMASTER_GTID_WAIT() can be useful to ensure that a slave has caught up to a\nmaster. Simply take the value of gtid_binlog_pos on the master, and use it in\na MASTER_GTID_WAIT() call on the slave; when the call completes, the slave\nwill have caught up with that master position.\n\nMASTER_GTID_WAIT() can also be used in client applications together with the\nlast_gtid session variable. This is useful in a read-scaleout replication\nsetup, where the application writes to a single master but divides the reads\nout to a number of slaves to distribute the load. In such a setup, there is a\nrisk that an application could first do an update on the master, and then a\nbit later do a read on a slave, and if the slave is not fast enough, the data\nread from the slave might not include the update just made, possibly confusing\nthe application and/or the end-user. One way to avoid this is to request the\nvalue of last_gtid on the master just after the update. Then before doing the\nread on the slave, do a MASTER_GTID_WAIT() on the value obtained from the\nmaster; this will ensure that the read is not performed until the slave has\nreplicated sufficiently far for the update to have become visible.\n\nNote that MASTER_GTID_WAIT() can be used even if the slave is configured not\nto use GTID for connections (CHANGE MASTER TO master_use_gtid=no). This is\nbecause from MariaDB 10, GTIDs are always logged on the master server, and\nalways recorded on the slave servers.\n\nDifferences to MASTER_POS_WAIT()\n--------------------------------\n\n* MASTER_GTID_WAIT() is global; it waits for any master connection to reach\n the specified GTID position. MASTER_POS_WAIT() works only against a\n specific connection. This also means that while MASTER_POS_WAIT() aborts if\n its master connection is terminated with STOP SLAVE or due to an error,\n MASTER_GTID_WAIT() continues to wait while slaves are stopped.\n\n* MASTER_GTID_WAIT() can take its timeout as a floating-point value, so a\n timeout in fractional seconds is supported, eg. MASTER_GTID_WAIT(\"0-1-100\",\n 0.5). (The minimum wait is one microsecond, 0.000001 seconds).\n\n* MASTER_GTID_WAIT() allows one to specify a timeout of zero in order to do a\n non-blocking check to see if the slaves have progressed to a specific GTID\nposition\n (MASTER_POS_WAIT() takes a zero timeout as meaning an infinite wait). To do\n an infinite MASTER_GTID_WAIT(), specify a negative timeout, or omit the\n timeout argument.\n\n* MASTER_GTID_WAIT() does not return the number of events executed since the\n wait started, nor does it return NULL if a slave thread is stopped. It\n always returns either 0 for successful wait completed, or -1 for timeout\n reached (or NULL if the specified gtid-pos is NULL).\n\nSince MASTER_GTID_WAIT() looks only at the seq_no part of the GTIDs, not the\nserver_id, care is needed if a slave becomes diverged from another server so\nthat two different GTIDs with the same seq_no (in the same domain) arrive at\nthe same server. This situation is in any case best avoided; setting\ngtid_strict_mode is recommended, as this will prevent any such out-of-order\nsequence numbers from ever being replicated on a slave.\n\nURL: https://mariadb.com/kb/en/master_gtid_wait/','','https://mariadb.com/kb/en/master_gtid_wait/'),(164,'UUID',14,'Syntax\n------\n\nUUID()\n\nDescription\n-----------\n\nReturns a Universally Unique Identifier (UUID).\n\nA UUID is designed as a number that is globally unique in space and time. Two\ncalls to UUID() are expected to generate two different values, even if these\ncalls are performed on two separate computers that are not connected to each\nother.\n\nUUID() results are intended to be unique, but cannot always be relied upon to\nunpredictable and unguessable, so should not be relied upon for these purposes.\n\nA UUID is a 128-bit number represented by a utf8 string of five hexadecimal\nnumbers in aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee format:\n\n* The first three numbers are generated from a timestamp.\n* The fourth number preserves temporal uniqueness in case the timestamp value\n loses monotonicity (for example, due to daylight saving time).\n* The fifth number is an IEEE 802 node number that provides spatial uniqueness.\n A random number is substituted if the latter is not available (for example,\n because the host computer has no Ethernet card, or we do not know how to find\n the hardware address of an interface on your operating system). In this case,\n spatial uniqueness cannot be guaranteed. Nevertheless, a collision should\n have very low probability.\n\nCurrently, the MAC address of an interface is taken into account only on\nFreeBSD and Linux. On other operating systems, MariaDB uses a randomly\ngenerated 48-bit number.\n\nStatements using the UUID() function are not safe for replication.\n\nThe results are generated according to the \"DCE 1.1:Remote Procedure Call\"\n(Appendix A) CAE (Common Applications Environment) Specifications published by\nThe Open Group in October 1997 (Document Number C706).\n\nExamples\n--------\n\nSELECT UUID();\n+--------------------------------------+\n| UUID()                               |\n+--------------------------------------+\n| cd41294a-afb0-11df-bc9b-00241dd75637 |\n+--------------------------------------+\n\nURL: https://mariadb.com/kb/en/uuid/','','https://mariadb.com/kb/en/uuid/'),(309,'WHILE',24,'Syntax\n------\n\n[begin_label:] WHILE search_condition DO\n  statement_list\nEND WHILE [end_label]\n\nDescription\n-----------\n\nThe statement list within a WHILE statement is repeated as long as the\nsearch_condition is true. statement_list consists of one or more statements.\nIf the loop must be executed at least once, REPEAT ... LOOP can be used\ninstead.\n\nA WHILE statement can be labeled. end_label cannot be given unless begin_label\nalso is present. If both are present, they must be the same.\n\nExamples\n--------\n\nCREATE PROCEDURE dowhile()\nBEGIN\n DECLARE v1 INT DEFAULT 5;\n\nWHILE v1 > 0 DO\n  ...\n  SET v1 = v1 - 1;\n END WHILE;\nEND\n\nURL: https://mariadb.com/kb/en/while/','','https://mariadb.com/kb/en/while/'),(312,'OPEN',24,'Syntax\n------\n\n<= MariaDB 10.2\n\nOPEN cursor_name\n\nFrom MariaDB 10.3\n\nOPEN cursor_name [expression[,...]];\n\nDescription\n-----------\n\nThis statement opens a cursor which was previously declared with DECLARE\nCURSOR.\n\nThe query associated to the DECLARE CURSOR is executed when OPEN is executed.\nIt is important to remember this if the query produces an error, or calls\nfunctions which have side effects.\n\nThis is necessary in order to FETCH rows from a cursor.\n\nSee Cursor Overview for an example.\n\nURL: https://mariadb.com/kb/en/open/','','https://mariadb.com/kb/en/open/'),(162,'RELEASE_LOCK',14,'Syntax\n------\n\nRELEASE_LOCK(str)\n\nDescription\n-----------\n\nReleases the lock named by the string str that was obtained with GET_LOCK().\nReturns 1 if the lock was released, 0 if the lock was not established by this\nthread (in which case the lock is not released), and NULL if the named lock\ndid not exist. The lock does not exist if it was never obtained by a call to\nGET_LOCK() or if it has previously been released.\n\nstr is case insensitive. If str is an empty string or NULL, RELEASE_LOCK()\nreturns NULL and does nothing.\n\nStatements using the RELEASE_LOCK() function are not safe for replication.\n\nThe DO statement is convenient to use with RELEASE_LOCK().\n\nExamples\n--------\n\nConnection1:\n\nSELECT GET_LOCK(\'lock1\',10);\n+----------------------+\n| GET_LOCK(\'lock1\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 2:\n\nSELECT GET_LOCK(\'lock2\',10);\n+----------------------+\n| GET_LOCK(\'lock2\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 1:\n\nSELECT RELEASE_LOCK(\'lock1\'), RELEASE_LOCK(\'lock2\'), RELEASE_LOCK(\'lock3\');\n+-----------------------+-----------------------+-----------------------+\n| RELEASE_LOCK(\'lock1\') | RELEASE_LOCK(\'lock2\') | RELEASE_LOCK(\'lock3\') |\n+-----------------------+-----------------------+-----------------------+\n|                     1 |                     0 |                  NULL |\n+-----------------------+-----------------------+-----------------------+\n\nFrom MariaDB 10.0.2, it is possible to hold the same lock recursively. This\nexample is viewed using the metadata_lock_info plugin:\n\nSELECT GET_LOCK(\'lock3\',10);\n+----------------------+\n| GET_LOCK(\'lock3\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT GET_LOCK(\'lock3\',10);\n+----------------------+\n| GET_LOCK(\'lock3\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n| THREAD_ID | LOCK_MODE           | LOCK_DURATION | LOCK_TYPE | TABLE_SCHEMA |\nTABLE_NAME |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n|        46 | MDL_SHARED_NO_WRITE | NULL          | User lock | lock3        |\n     |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n\nSELECT RELEASE_LOCK(\'lock3\');\n+-----------------------+\n| RELEASE_LOCK(\'lock3\') |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n| THREAD_ID | LOCK_MODE           | LOCK_DURATION | LOCK_TYPE | TABLE_SCHEMA |\nTABLE_NAME |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n|        46 | MDL_SHARED_NO_WRITE | NULL          | User lock | lock3        |\n     |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n\nSELECT RELEASE_LOCK(\'lock3\');\n+-----------------------+\n| RELEASE_LOCK(\'lock3\') |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\nEmpty set (0.000 sec)\n\nURL: https://mariadb.com/kb/en/release_lock/','','https://mariadb.com/kb/en/release_lock/'),(165,'UUID_SHORT',14,'Syntax\n------\n\nUUID_SHORT()\n\nDescription\n-----------\n\nReturns a \"short\" universally unique identifier as a 64-bit unsigned integer\n(rather than a string-form 128-bit identifier as returned by the UUID()\nfunction).\n\nThe value of UUID_SHORT() is guaranteed to be unique if the following\nconditions hold:\n\n* The server_id of the current host is unique among your set of master and\n slave servers\n* server_id is between 0 and 255\n* You don\'t set back your system time for your server between mysqld restarts\n* You do not invoke UUID_SHORT() on average more than 16\n million times per second between mysqld restarts\n\nThe UUID_SHORT() return value is constructed this way:\n\n(server_id & 255) << 56\n+ (server_startup_time_in_seconds << 24)\n+ incremented_variable++;\n\nStatements using the UUID_SHORT() function are not safe for statement-based\nreplication.\n\nExamples\n--------\n\nSELECT UUID_SHORT();\n+-------------------+\n| UUID_SHORT()      |\n+-------------------+\n| 21517162376069120 |\n+-------------------+\n\ncreate table t1 (a bigint unsigned default(uuid_short()) primary key);\ninsert into t1 values(),();\nselect * from t1;\n+-------------------+\n| a                 |\n+-------------------+\n| 98113699159474176 |\n| 98113699159474177 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/uuid_short/','','https://mariadb.com/kb/en/uuid_short/'),(166,'VALUES / VALUE',14,'Syntax\n------\n\nMariaDB starting with 10.3.3\n----------------------------\n\nVALUE(col_name)\n\nMariaDB until 10.3.2\n--------------------\n\nVALUES(col_name)\n\nDescription\n-----------\n\nIn an INSERT ... ON DUPLICATE KEY UPDATE statement, you can use the\nVALUES(col_name) function in the UPDATE clause to refer to column values from\nthe INSERT portion of the statement. In other words, VALUES(col_name) in the\nUPDATE clause refers to the value of col_name that would be inserted, had no\nduplicate-key conflict occurred. This function is especially useful in\nmultiple-row inserts.\n\nThe VALUES() function is meaningful only in INSERT ... ON DUPLICATE KEY UPDATE\nstatements and returns NULL otherwise.\n\nIn MariaDB 10.3.3 this function was renamed to VALUE(), because it\'s\nincompatible with the standard Table Value Constructors syntax, implemented in\nMariaDB 10.3.3.\n\nThe VALUES() function can still be used even from MariaDB 10.3.3, but only in\nINSERT ... ON DUPLICATE KEY UPDATE statements; it\'s a syntax error otherwise.\n\nExamples\n--------\n\nMariaDB starting with 10.3.3\n----------------------------\n\nINSERT INTO t (a,b,c) VALUES (1,2,3),(4,5,6)\n  ON DUPLICATE KEY UPDATE c=VALUE(a)+VALUE(b);\n\nMariaDB until 10.3.2\n--------------------\n\nINSERT INTO t (a,b,c) VALUES (1,2,3),(4,5,6)\n  ON DUPLICATE KEY UPDATE c=VALUES(a)+VALUES(b);\n\nURL: https://mariadb.com/kb/en/values-value/','','https://mariadb.com/kb/en/values-value/'),(313,'FETCH',24,'Syntax\n------\n\nFETCH cursor_name INTO var_name [, var_name] ...\n\nDescription\n-----------\n\nThis statement fetches the next row (if a row exists) using the specified open\ncursor, and advances the cursor pointer.\n\nvar_name can be a local variable, but not a user-defined variable.\n\nIf no more rows are available, a No Data condition occurs with SQLSTATE value\n02000. To detect this condition, you can set up a handler for it (or for a NOT\nFOUND condition).\n\nSee Cursor Overview for an example.\n\nURL: https://mariadb.com/kb/en/fetch/','','https://mariadb.com/kb/en/fetch/'),(314,'CLOSE',24,'Syntax\n------\n\nCLOSE cursor_name\n\nDescription\n-----------\n\nThis statement closes a previously opened cursor. The cursor must have been\npreviously opened or else an error occurs.\n\nIf not closed explicitly, a cursor is closed at the end of the compound\nstatement in which it was declared.\n\nSee Cursor Overview for an example.\n\nURL: https://mariadb.com/kb/en/close/','','https://mariadb.com/kb/en/close/'),(315,'BUFFER',25,'A synonym for ST_BUFFER.\n\nURL: https://mariadb.com/kb/en/buffer/','','https://mariadb.com/kb/en/buffer/'),(170,'||',15,'Syntax\n------\n\nOR, ||\n\nDescription\n-----------\n\nLogical OR. When both operands are non-NULL, the result is 1 if any operand is\nnon-zero, and 0 otherwise. With a NULL operand, the result is 1 if the other\noperand is non-zero, and NULL otherwise. If both operands are NULL, the result\nis NULL.\n\nFor this operator, short-circuit evaluation can be used.\n\nNote that, if the PIPES_AS_CONCAT SQL_MODE is set, || is used as a string\nconcatenation operator. This means that a || b is the same as CONCAT(a,b). See\nCONCAT() for details.\n\nOracle Mode\n-----------\n\nMariaDB starting with 10.3\n--------------------------\nIn Oracle mode from MariaDB 10.3, || ignores NULL.\n\nExamples\n--------\n\nSELECT 1 || 1;\n+--------+\n| 1 || 1 |\n+--------+\n|      1 |\n+--------+\n\nSELECT 1 || 0;\n+--------+\n| 1 || 0 |\n+--------+\n|      1 |\n+--------+\n\nSELECT 0 || 0;\n+--------+\n| 0 || 0 |\n+--------+\n|      0 |\n+--------+\n\nSELECT 0 || NULL;\n+-----------+\n| 0 || NULL |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT 1 || NULL;\n+-----------+\n| 1 || NULL |\n+-----------+\n|         1 |\n+-----------+\n\nIn Oracle mode, from MariaDB 10.3:\n\nSELECT 0 || NULL;\n+-----------+\n| 0 || NULL |\n+-----------+\n| 0         |\n+-----------+\n\nURL: https://mariadb.com/kb/en/or/','','https://mariadb.com/kb/en/or/'),(171,'Stored Aggregate Functions',16,'MariaDB starting with 10.3.3\n----------------------------\nThe ability to create stored aggregate functions was added in MariaDB 10.3.3.\n\nAggregate functions are functions that are computed over a sequence of rows\nand return one result for the sequence of rows.\n\nCreating a custom aggregate function is done using the CREATE FUNCTION\nstatement with two main differences:\n\n* The addition of the AGGREGATE keyword, so CREATE AGGREGATE FUNCTION\n* The FETCH GROUP NEXT ROW instruction inside the loop\n* Oracle PL/SQL compatibility using SQL/PL is provided\n\nStandard Syntax\n---------------\n\nCREATE AGGREGATE FUNCTION function_name (parameters) RETURNS return_type\nBEGIN\n   All types of declarations\n   DECLARE CONTINUE HANDLER FOR NOT FOUND RETURN return_val;\n   LOOP\n     FETCH GROUP NEXT ROW; // fetches next row from table\n     other instructions\n   END LOOP;\nEND\n\nStored aggregate functions were a 2016 Google Summer of Code project by Varun\nGupta.\n\nUsing SQL/PL\n------------\n\nSET sql_mode=Oracle;\nDELIMITER //\n\nCREATE AGGREGATE FUNCTION function_name (parameters) RETURN return_type\n declarations\nBEGIN\n LOOP\n   FETCH GROUP NEXT ROW; -- fetches next row from table\n   -- other instructions\n\nEND LOOP;\nEXCEPTION\n WHEN NO_DATA_FOUND THEN\n   RETURN return_val;\nEND //\n\nDELIMITER ;\n\nExamples\n--------\n\nFirst a simplified example:\n\nCREATE TABLE marks(stud_id INT, grade_count INT);\n\nINSERT INTO marks VALUES (1,6), (2,4), (3,7), (4,5), (5,8);\n\nSELECT * FROM marks;\n+---------+-------------+\n| stud_id | grade_count |\n+---------+-------------+\n|       1 |           6 |\n|       2 |           4 |\n|       3 |           7 |\n|       4 |           5 |\n|       5 |           8 |\n+---------+-------------+\n\nDELIMITER //\nCREATE AGGREGATE FUNCTION IF NOT EXISTS aggregate_count(x INT) RETURNS INT\nBEGIN\n DECLARE count_students INT DEFAULT 0;\n DECLARE CONTINUE HANDLER FOR NOT FOUND\n RETURN count_students;\n   LOOP\n     FETCH GROUP NEXT ROW;\n     IF x  THEN\n      SET count_students = count_students+1;\n     END IF;\n   END LOOP;\nEND //\nDELIMITER ;\n\nA non-trivial example that cannot easily be rewritten using existing functions:\n\nDELIMITER //\nCREATE AGGREGATE FUNCTION medi_int(x INT) RETURNS DOUBLE\nBEGIN\n DECLARE CONTINUE HANDLER FOR NOT FOUND\n  BEGIN\n   DECLARE res DOUBLE;\n   DECLARE cnt INT DEFAULT (SELECT COUNT(*) FROM tt);\n   DECLARE lim INT DEFAULT (cnt-1) DIV 2;\n   IF cnt % 2 = 0 THEN\n    SET res = (SELECT AVG(a) FROM (SELECT a FROM tt ORDER BY a LIMIT\nlim,2) ttt);\n   ELSE\n    SET res = (SELECT a FROM tt ORDER BY a LIMIT lim,1);\n   END IF;\n   DROP TEMPORARY TABLE tt;\n   RETURN res;\n  END;\n CREATE TEMPORARY TABLE tt (a INT);\n LOOP\n  FETCH GROUP NEXT ROW;\n  INSERT INTO tt VALUES (x);\n END LOOP;\nEND //\nDELIMITER ;\n\nSQL/PL Example\n--------------\n\nThis uses the same marks table as created above.\n\nSET sql_mode=Oracle;\nDELIMITER //\n\nCREATE AGGREGATE FUNCTION aggregate_count(x INT) RETURN INT AS count_students\nINT DEFAULT 0;\nBEGIN\n LOOP\n   FETCH GROUP NEXT ROW;\n   IF x  THEN\n    SET count_students := count_students+1;\n   END IF;\n END LOOP;\nEXCEPTION\n WHEN NO_DATA_FOUND THEN\n   RETURN count_students;\nEND aggregate_count //\nDELIMITER ;\n\nSELECT aggregate_count(stud_id) FROM marks;\n\nURL: https://mariadb.com/kb/en/stored-aggregate-functions/','','https://mariadb.com/kb/en/stored-aggregate-functions/'),(172,'AVG',16,'Syntax\n------\n\nAVG([DISTINCT] expr)\n\nDescription\n-----------\n\nReturns the average value of expr. The DISTINCT option can be used to return\nthe average of the distinct values of expr. NULL values are ignored. It is an\naggregate function, and so can be used with the GROUP BY clause.\n\nAVG() returns NULL if there were no matching rows.\n\nAVG() can be used as a window function.\n\nExamples\n--------\n\nCREATE TABLE sales (sales_value INT);\n\nINSERT INTO sales VALUES(10),(20),(20),(40);\n\nSELECT AVG(sales_value) FROM sales;\n+------------------+\n| AVG(sales_value) |\n+------------------+\n|          22.5000 |\n+------------------+\n\nSELECT AVG(DISTINCT(sales_value)) FROM sales;\n+----------------------------+\n| AVG(DISTINCT(sales_value)) |\n+----------------------------+\n|                    23.3333 |\n+----------------------------+\n\nCommonly, AVG() is used with a GROUP BY clause:\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT name, AVG(score) FROM student GROUP BY name;\n+---------+------------+\n| name    | AVG(score) |\n+---------+------------+\n| Chun    |    74.0000 |\n| Esben   |    37.0000 |\n| Kaolin  |    72.0000 |\n| Tatiana |    85.0000 |\n+---------+------------+\n\nBe careful to avoid this common mistake, not grouping correctly and returning\nmismatched data:\n\nSELECT name,test,AVG(score) FROM student;\n+------+------+------------+\n| name | test | MIN(score) |\n+------+------+------------+\n| Chun | SQL  |         31 |\n+------+------+------------+\n\nAs a window function:\n\nCREATE TABLE student_test (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT name, test, score, AVG(score) OVER (PARTITION BY test) \n  AS average_by_test FROM student_test;\n+---------+--------+-------+-----------------+\n| name    | test   | score | average_by_test |\n+---------+--------+-------+-----------------+\n| Chun    | SQL    |    75 |         65.2500 |\n| Chun    | Tuning |    73 |         68.7500 |\n| Esben   | SQL    |    43 |         65.2500 |\n| Esben   | Tuning |    31 |         68.7500 |\n| Kaolin  | SQL    |    56 |         65.2500 |\n| Kaolin  | Tuning |    88 |         68.7500 |\n| Tatiana | SQL    |    87 |         65.2500 |\n| Tatiana | Tuning |    83 |         68.7500 |\n+---------+--------+-------+-----------------+\n\nURL: https://mariadb.com/kb/en/avg/','','https://mariadb.com/kb/en/avg/'),(173,'BIT_AND',16,'Syntax\n------\n\nBIT_AND(expr) [over_clause]\n\nDescription\n-----------\n\nReturns the bitwise AND of all bits in expr. The calculation is performed with\n64-bit (BIGINT) precision. It is an aggregate function, and so can be used\nwith the GROUP BY clause.\n\nIf no rows match, BIT_AND will return a value with all bits set to 1. NULL\nvalues have no effect on the result unless all results are NULL, which is\ntreated as no match.\n\nBIT_AND can be used as a window function with the addition of the over_clause.\n\nExamples\n--------\n\nCREATE TABLE vals (x INT);\n\nINSERT INTO vals VALUES(111),(110),(100);\n\nSELECT BIT_AND(x), BIT_OR(x), BIT_XOR(x) FROM vals;\n+------------+-----------+------------+\n| BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+------------+-----------+------------+\n|        100 |       111 |        101 |\n+------------+-----------+------------+\n\nAs an aggregate function:\n\nCREATE TABLE vals2 (category VARCHAR(1), x INT);\n\nINSERT INTO vals2 VALUES\n (\'a\',111),(\'a\',110),(\'a\',100),\n (\'b\',\'000\'),(\'b\',001),(\'b\',011);\n\nSELECT category, BIT_AND(x), BIT_OR(x), BIT_XOR(x) \n FROM vals GROUP BY category;\n+----------+------------+-----------+------------+\n| category | BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+----------+------------+-----------+------------+\n| a        |        100 |       111 |        101 |\n| b        |          0 |        11 |         10 |\n+----------+------------+-----------+------------+\n\nNo match:\n\nSELECT BIT_AND(NULL);\n+----------------------+\n| BIT_AND(NULL)        |\n+----------------------+\n| 18446744073709551615 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/bit_and/','','https://mariadb.com/kb/en/bit_and/'),(174,'BIT_OR',16,'Syntax\n------\n\nBIT_OR(expr) [over_clause]\n\nDescription\n-----------\n\nReturns the bitwise OR of all bits in expr. The calculation is performed with\n64-bit (BIGINT) precision. It is an aggregate function, and so can be used\nwith the GROUP BY clause.\n\nIf no rows match, BIT_OR will return a value with all bits set to 0. NULL\nvalues have no effect on the result unless all results are NULL, which is\ntreated as no match.\n\nBIT_OR can be used as a window function with the addition of the over_clause.\n\nExamples\n--------\n\nCREATE TABLE vals (x INT);\n\nINSERT INTO vals VALUES(111),(110),(100);\n\nSELECT BIT_AND(x), BIT_OR(x), BIT_XOR(x) FROM vals;\n+------------+-----------+------------+\n| BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+------------+-----------+------------+\n|        100 |       111 |        101 |\n+------------+-----------+------------+\n\nAs an aggregate function:\n\nCREATE TABLE vals2 (category VARCHAR(1), x INT);\n\nINSERT INTO vals2 VALUES\n (\'a\',111),(\'a\',110),(\'a\',100),\n (\'b\',\'000\'),(\'b\',001),(\'b\',011);\n\nSELECT category, BIT_AND(x), BIT_OR(x), BIT_XOR(x) \n FROM vals GROUP BY category;\n+----------+------------+-----------+------------+\n| category | BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+----------+------------+-----------+------------+\n| a        |        100 |       111 |        101 |\n| b        |          0 |        11 |         10 |\n+----------+------------+-----------+------------+\n\nNo match:\n\nSELECT BIT_OR(NULL);\n+--------------+\n| BIT_OR(NULL) |\n+--------------+\n|            0 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/bit_or/','','https://mariadb.com/kb/en/bit_or/'),(175,'BIT_XOR',16,'Syntax\n------\n\nBIT_XOR(expr) [over_clause]\n\nDescription\n-----------\n\nReturns the bitwise XOR of all bits in expr. The calculation is performed with\n64-bit (BIGINT) precision. It is an aggregate function, and so can be used\nwith the GROUP BY clause.\n\nIf no rows match, BIT_XOR will return a value with all bits set to 0. NULL\nvalues have no effect on the result unless all results are NULL, which is\ntreated as no match.\n\nBIT_XOR can be used as a window function with the addition of the over_clause.\n\nExamples\n--------\n\nCREATE TABLE vals (x INT);\n\nINSERT INTO vals VALUES(111),(110),(100);\n\nSELECT BIT_AND(x), BIT_OR(x), BIT_XOR(x) FROM vals;\n+------------+-----------+------------+\n| BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+------------+-----------+------------+\n|        100 |       111 |        101 |\n+------------+-----------+------------+\n\nAs an aggregate function:\n\nCREATE TABLE vals2 (category VARCHAR(1), x INT);\n\nINSERT INTO vals2 VALUES\n (\'a\',111),(\'a\',110),(\'a\',100),\n (\'b\',\'000\'),(\'b\',001),(\'b\',011);\n\nSELECT category, BIT_AND(x), BIT_OR(x), BIT_XOR(x) \n FROM vals GROUP BY category;\n+----------+------------+-----------+------------+\n| category | BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+----------+------------+-----------+------------+\n| a        |        100 |       111 |        101 |\n| b        |          0 |        11 |         10 |\n+----------+------------+-----------+------------+\n\nNo match:\n\nSELECT BIT_XOR(NULL);\n+---------------+\n| BIT_XOR(NULL) |\n+---------------+\n|             0 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/bit_xor/','','https://mariadb.com/kb/en/bit_xor/'),(176,'COUNT',16,'Syntax\n------\n\nCOUNT(expr)\n\nDescription\n-----------\n\nReturns a count of the number of non-NULL values of expr in the rows retrieved\nby a SELECT statement. The result is a BIGINT value. It is an aggregate\nfunction, and so can be used with the GROUP BY clause.\n\nCOUNT(*) counts the total number of rows in a table.\n\nCOUNT() returns 0 if there were no matching rows.\n\nCOUNT() can be used as a window function.\n\nExamples\n--------\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT COUNT(*) FROM student;\n+----------+\n| COUNT(*) |\n+----------+\n|        8 |\n+----------+\n\nCOUNT(DISTINCT) example:\n\nSELECT COUNT(DISTINCT (name)) FROM student;\n+------------------------+\n| COUNT(DISTINCT (name)) |\n+------------------------+\n|                      4 |\n+------------------------+\n\nAs a window function\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, COUNT(score) OVER (PARTITION BY name) \n  AS tests_written FROM student_test;\n+---------+--------+-------+---------------+\n| name    | test   | score | tests_written |\n+---------+--------+-------+---------------+\n| Chun    | SQL    |    75 |             2 |\n| Chun    | Tuning |    73 |             2 |\n| Esben   | SQL    |    43 |             2 |\n| Esben   | Tuning |    31 |             2 |\n| Kaolin  | SQL    |    56 |             2 |\n| Kaolin  | Tuning |    88 |             2 |\n| Tatiana | SQL    |    87 |             1 |\n+---------+--------+-------+---------------+\n\nURL: https://mariadb.com/kb/en/count/','','https://mariadb.com/kb/en/count/'),(316,'CONVEXHULL',25,'A synonym for ST_CONVEXHULL.\n\nURL: https://mariadb.com/kb/en/convexhull/','','https://mariadb.com/kb/en/convexhull/'),(317,'GEOMETRYCOLLECTION',25,'Syntax\n------\n\nGeometryCollection(g1,g2,...)\n\nDescription\n-----------\n\nConstructs a WKB GeometryCollection. If any argument is not a well-formed WKB\nrepresentation of a geometry, the return value is NULL.\n\nExamples\n--------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/geometrycollection/','','https://mariadb.com/kb/en/geometrycollection/'),(177,'COUNT DISTINCT',16,'Syntax\n------\n\nCOUNT(DISTINCT expr,[expr...])\n\nDescription\n-----------\n\nReturns a count of the number of different non-NULL values.\n\nCOUNT(DISTINCT) returns 0 if there were no matching rows.\n\nAlthough, from MariaDB 10.2.0, COUNT can be used as a window function, COUNT\nDISTINCT cannot be.\n\nExamples\n--------\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT COUNT(*) FROM student;\n+----------+\n| COUNT(*) |\n+----------+\n|        8 |\n+----------+\n\nSELECT COUNT(DISTINCT (name)) FROM student;\n+------------------------+\n| COUNT(DISTINCT (name)) |\n+------------------------+\n|                      4 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/count-distinct/','','https://mariadb.com/kb/en/count-distinct/'),(178,'GROUP_CONCAT',16,'Syntax\n------\n\nGROUP_CONCAT(expr)\n\nDescription\n-----------\n\nThis function returns a string result with the concatenated non-NULL values\nfrom a group. It returns NULL if there are no non-NULL values.\n\nThe maximum returned length in bytes is determined by the group_concat_max_len\nserver system variable, which defaults to 1M (>= MariaDB 10.2.4) or 1K (<=\nMariaDB 10.2.3).\n\nIf group_concat_max_len <= 512, the return type is VARBINARY or VARCHAR;\notherwise, the return type is BLOB or TEXT. The choice between binary or\nnon-binary types depends from the input.\n\nThe full syntax is as follows:\n\nGROUP_CONCAT([DISTINCT] expr [,expr ...]\n      [ORDER BY {unsigned_integer | col_name | expr}\n        [ASC | DESC] [,col_name ...]]\n      [SEPARATOR str_val]\n      [LIMIT {[offset,] row_count | row_count OFFSET offset}])\n\nDISTINCT eliminates duplicate values from the output string.\n\nORDER BY determines the order of returned values.\n\nSEPARATOR specifies a separator between the values. The default separator is a\ncomma (,). It is possible to avoid using a separator by specifying an empty\nstring.\n\nLIMIT\n-----\n\nMariaDB starting with 10.3.3\n----------------------------\nUntil MariaDB 10.3.2, it was not possible to use the LIMIT clause with\nGROUP_CONCAT. This restriction was lifted in MariaDB 10.3.3.\n\nExamples\n--------\n\nSELECT student_name,\n   GROUP_CONCAT(test_score)\n   FROM student\n   GROUP BY student_name;\n\nGet a readable list of MariaDB users from the mysql.user table:\n\nSELECT GROUP_CONCAT(DISTINCT User ORDER BY User SEPARATOR \'\\n\')\n FROM mysql.user;\n\nIn the former example, DISTINCT is used because the same user may occur more\nthan once. The new line (\\n) used as a SEPARATOR makes the results easier to\nread.\n\nGet a readable list of hosts from which each user can connect:\n\nSELECT User, GROUP_CONCAT(Host ORDER BY Host SEPARATOR \', \') \n FROM mysql.user GROUP BY User ORDER BY User;\n\nThe former example shows the difference between the GROUP_CONCAT\'s ORDER BY\n(which sorts the concatenated hosts), and the SELECT\'s ORDER BY (which sorts\nthe rows).\n\nFrom MariaDB 10.3.3, LIMIT can be used with GROUP_CONCAT, so, for example,\ngiven the following table:\n\nCREATE TABLE d (dd DATE, cc INT);\n\nINSERT INTO d VALUES (\'2017-01-01\',1);\nINSERT INTO d VALUES (\'2017-01-02\',2);\nINSERT INTO d VALUES (\'2017-01-04\',3);\n\nthe following query:\n\nSELECT SUBSTRING_INDEX(GROUP_CONCAT(CONCAT_WS(\":\",dd,cc) ORDER BY cc\nDESC),\",\",1) FROM d;\n+----------------------------------------------------------------------------+\n| SUBSTRING_INDEX(GROUP_CONCAT(CONCAT_WS(\":\",dd,cc) ORDER BY cc DESC),\",\",1) |\n+----------------------------------------------------------------------------+\n| 2017-01-04:3                                                               |\n+----------------------------------------------------------------------------+\n\ncan be more simply rewritten as:\n\nSELECT GROUP_CONCAT(CONCAT_WS(\":\",dd,cc) ORDER BY cc DESC LIMIT 1) FROM d;\n+-------------------------------------------------------------+\n| GROUP_CONCAT(CONCAT_WS(\":\",dd,cc) ORDER BY cc DESC LIMIT 1) |\n+-------------------------------------------------------------+\n| 2017-01-04:3                                                |\n+-------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/group_concat/','','https://mariadb.com/kb/en/group_concat/'),(179,'MAX',16,'Syntax\n------\n\nMAX([DISTINCT] expr)\n\nDescription\n-----------\n\nReturns the largest, or maximum, value of expr. MAX() can also take a string\nargument in which case it returns the maximum string value. The DISTINCT\nkeyword can be used to find the maximum of the distinct values of expr,\nhowever, this produces the same result as omitting DISTINCT.\n\nNote that SET and ENUM fields are currently compared by their string value\nrather than their relative position in the set, so MAX() may produce a\ndifferent highest result than ORDER BY DESC.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nMAX() can be used as a window function.\n\nMAX() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT name, MAX(score) FROM student GROUP BY name;\n+---------+------------+\n| name    | MAX(score) |\n+---------+------------+\n| Chun    |         75 |\n| Esben   |         43 |\n| Kaolin  |         88 |\n| Tatiana |         87 |\n+---------+------------+\n\nMAX string:\n\nSELECT MAX(name) FROM student;\n+-----------+\n| MAX(name) |\n+-----------+\n| Tatiana   |\n+-----------+\n\nBe careful to avoid this common mistake, not grouping correctly and returning\nmismatched data:\n\nSELECT name,test,MAX(SCORE) FROM student;\n+------+------+------------+\n| name | test | MAX(SCORE) |\n+------+------+------------+\n| Chun | SQL  |         88 |\n+------+------+------------+\n\nDifference between ORDER BY DESC and MAX():\n\nCREATE TABLE student2(name CHAR(10),grade ENUM(\'b\',\'c\',\'a\'));\n\nINSERT INTO student2 VALUES(\'Chun\',\'b\'),(\'Esben\',\'c\'),(\'Kaolin\',\'a\');\n\nSELECT MAX(grade) FROM student2;\n+------------+\n| MAX(grade) |\n+------------+\n| c          |\n+------------+\n\nSELECT grade FROM student2 ORDER BY grade DESC LIMIT 1;\n+-------+\n| grade |\n+-------+\n| a     |\n+-------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, MAX(score) \n OVER (PARTITION BY name) AS highest_score FROM student_test;\n+---------+--------+-------+---------------+\n| name    | test   | score | highest_score |\n+---------+--------+-------+---------------+\n| Chun    | SQL    |    75 |            75 |\n| Chun    | Tuning |    73 |            75 |\n| Esben   | SQL    |    43 |            43 |\n| Esben   | Tuning |    31 |            43 |\n| Kaolin  | SQL    |    56 |            88 |\n| Kaolin  | Tuning |    88 |            88 |\n| Tatiana | SQL    |    87 |            87 |\n+---------+--------+-------+---------------+\n\nURL: https://mariadb.com/kb/en/max/','','https://mariadb.com/kb/en/max/'),(180,'MIN',16,'Syntax\n------\n\nMIN([DISTINCT] expr)\n\nDescription\n-----------\n\nReturns the minimum value of expr. MIN() may take a string argument, in which\ncase it returns the minimum string value. The DISTINCT keyword can be used to\nfind the minimum of the distinct values of expr, however, this produces the\nsame result as omitting DISTINCT.\n\nNote that SET and ENUM fields are currently compared by their string value\nrather than their relative position in the set, so MIN() may produce a\ndifferent lowest result than ORDER BY ASC.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nMIN() can be used as a window function.\n\nMIN() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT name, MIN(score) FROM student GROUP BY name;\n+---------+------------+\n| name    | MIN(score) |\n+---------+------------+\n| Chun    |         73 |\n| Esben   |         31 |\n| Kaolin  |         56 |\n| Tatiana |         83 |\n+---------+------------+\n\nMIN() with a string:\n\nSELECT MIN(name) FROM student;\n+-----------+\n| MIN(name) |\n+-----------+\n| Chun      |\n+-----------+\n\nBe careful to avoid this common mistake, not grouping correctly and returning\nmismatched data:\n\nSELECT name,test,MIN(score) FROM student;\n+------+------+------------+\n| name | test | MIN(score) |\n+------+------+------------+\n| Chun | SQL  |         31 |\n+------+------+------------+\n\nDifference between ORDER BY ASC and MIN():\n\nCREATE TABLE student2(name CHAR(10),grade ENUM(\'b\',\'c\',\'a\'));\n\nINSERT INTO student2 VALUES(\'Chun\',\'b\'),(\'Esben\',\'c\'),(\'Kaolin\',\'a\');\n\nSELECT MIN(grade) FROM student2;\n+------------+\n| MIN(grade) |\n+------------+\n| a          |\n+------------+\n\nSELECT grade FROM student2 ORDER BY grade ASC LIMIT 1;\n+-------+\n| grade |\n+-------+\n| b     |\n+-------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, MIN(score) \n OVER (PARTITION BY name) AS lowest_score FROM student_test;\n+---------+--------+-------+--------------+\n| name    | test   | score | lowest_score |\n+---------+--------+-------+--------------+\n| Chun    | SQL    |    75 |           73 |\n| Chun    | Tuning |    73 |           73 |\n| Esben   | SQL    |    43 |           31 |\n| Esben   | Tuning |    31 |           31 |\n| Kaolin  | SQL    |    56 |           56 |\n| Kaolin  | Tuning |    88 |           56 |\n| Tatiana | SQL    |    87 |           87 |\n+---------+--------+-------+--------------+\n\nURL: https://mariadb.com/kb/en/min/','','https://mariadb.com/kb/en/min/'),(181,'STD',16,'Syntax\n------\n\nSTD(expr)\n\nDescription\n-----------\n\nReturns the population standard deviation of expr. This is an extension to\nstandard SQL. The standard SQL function STDDEV_POP() can be used instead.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nSTD() can be used as a window function.\n\nThis function returns NULL if there were no matching rows.\n\nExamples\n--------\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, STDDEV_POP(score) \n OVER (PARTITION BY test) AS stddev_results FROM student_test;\n+---------+--------+-------+----------------+\n| name    | test   | score | stddev_results |\n+---------+--------+-------+----------------+\n| Chun    | SQL    |    75 |        16.9466 |\n| Chun    | Tuning |    73 |        24.1247 |\n| Esben   | SQL    |    43 |        16.9466 |\n| Esben   | Tuning |    31 |        24.1247 |\n| Kaolin  | SQL    |    56 |        16.9466 |\n| Kaolin  | Tuning |    88 |        24.1247 |\n| Tatiana | SQL    |    87 |        16.9466 |\n+---------+--------+-------+----------------+\n\nURL: https://mariadb.com/kb/en/std/','','https://mariadb.com/kb/en/std/'),(319,'MULTILINESTRING',25,'Syntax\n------\n\nMultiLineString(ls1,ls2,...)\n\nDescription\n-----------\n\nConstructs a WKB MultiLineString value using WKB LineString arguments. If any\nargument is not a WKB LineString, the return value is NULL.\n\nExample\n-------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nINSERT INTO gis_multi_line VALUES\n (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16 23,16\n48))\')),\n (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n (MLineFromWKB(AsWKB(MultiLineString(LineString(Point(1, 2), \n  Point(3, 5)), LineString(Point(2, 5),Point(5, 8),Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/multilinestring/','','https://mariadb.com/kb/en/multilinestring/'),(320,'MULTIPOINT',25,'Syntax\n------\n\nMultiPoint(pt1,pt2,...)\n\nDescription\n-----------\n\nConstructs a WKB MultiPoint value using WKB Point arguments. If any argument\nis not a WKB Point, the return value is NULL.\n\nExamples\n--------\n\nSET @g = ST_GEOMFROMTEXT(\'MultiPoint( 1 1, 2 2, 5 3, 7 2, 9 3, 8 4, 6 6, 6 9,\n4 9, 1 5 )\');\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/multipoint/','','https://mariadb.com/kb/en/multipoint/'),(322,'POINT',25,'Syntax\n------\n\nPoint(x,y)\n\nDescription\n-----------\n\nConstructs a WKB Point using the given coordinates.\n\nExamples\n--------\n\nSET @g = ST_GEOMFROMTEXT(\'Point(1 1)\');\n\nCREATE TABLE gis_point  (g POINT);\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/point/','','https://mariadb.com/kb/en/point/'),(323,'PointOnSurface',25,'A synonym for ST_PointOnSurface.\n\nURL: https://mariadb.com/kb/en/pointonsurface/','','https://mariadb.com/kb/en/pointonsurface/'),(327,'ST_INTERSECTION',25,'Syntax\n------\n\nST_INTERSECTION(g1,g2)\n\nDescription\n-----------\n\nReturns a geometry that is the intersection, or shared portion, of geometry g1\nand geometry g2.\n\nExamples\n--------\n\nSET @g1 = ST_GEOMFROMTEXT(\'POINT(2 1)\');\n\nSET @g2 = ST_GEOMFROMTEXT(\'LINESTRING(2 1, 0 2)\');\n\nSELECT ASTEXT(ST_INTERSECTION(@g1,@g2));\n+----------------------------------+\n| ASTEXT(ST_INTERSECTION(@g1,@g2)) |\n+----------------------------------+\n| POINT(2 1)                       |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/st_intersection/','','https://mariadb.com/kb/en/st_intersection/'),(182,'STDDEV',16,'Syntax\n------\n\nSTDDEV(expr)\n\nDescription\n-----------\n\nReturns the population standard deviation of expr. This function is provided\nfor compatibility with Oracle. The standard SQL function STDDEV_POP() can be\nused instead.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nSTDDEV() can be used as a window function.\n\nThis function returns NULL if there were no matching rows.\n\nExamples\n--------\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, STDDEV_POP(score) \n OVER (PARTITION BY test) AS stddev_results FROM student_test;\n+---------+--------+-------+----------------+\n| name    | test   | score | stddev_results |\n+---------+--------+-------+----------------+\n| Chun    | SQL    |    75 |        16.9466 |\n| Chun    | Tuning |    73 |        24.1247 |\n| Esben   | SQL    |    43 |        16.9466 |\n| Esben   | Tuning |    31 |        24.1247 |\n| Kaolin  | SQL    |    56 |        16.9466 |\n| Kaolin  | Tuning |    88 |        24.1247 |\n| Tatiana | SQL    |    87 |        16.9466 |\n+---------+--------+-------+----------------+\n\nURL: https://mariadb.com/kb/en/stddev/','','https://mariadb.com/kb/en/stddev/'),(183,'STDDEV_POP',16,'Syntax\n------\n\nSTDDEV_POP(expr)\n\nDescription\n-----------\n\nReturns the population standard deviation of expr (the square root of\nVAR_POP()). You can also use STD() or STDDEV(), which are equivalent but not\nstandard SQL.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nSTDDEV_POP() can be used as a window function.\n\nSTDDEV_POP() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, STDDEV_POP(score) \n OVER (PARTITION BY test) AS stddev_results FROM student_test;\n+---------+--------+-------+----------------+\n| name    | test   | score | stddev_results |\n+---------+--------+-------+----------------+\n| Chun    | SQL    |    75 |        16.9466 |\n| Chun    | Tuning |    73 |        24.1247 |\n| Esben   | SQL    |    43 |        16.9466 |\n| Esben   | Tuning |    31 |        24.1247 |\n| Kaolin  | SQL    |    56 |        16.9466 |\n| Kaolin  | Tuning |    88 |        24.1247 |\n| Tatiana | SQL    |    87 |        16.9466 |\n+---------+--------+-------+----------------+\n\nURL: https://mariadb.com/kb/en/stddev_pop/','','https://mariadb.com/kb/en/stddev_pop/'),(185,'SUM',16,'Syntax\n------\n\nSUM([DISTINCT] expr)\n\nDescription\n-----------\n\nReturns the sum of expr. If the return set has no rows, SUM() returns NULL.\nThe DISTINCT keyword can be used to sum only the distinct values of expr.\n\nSUM() can be used as a window function, although not with the DISTINCT\nspecifier.\n\nExamples\n--------\n\nCREATE TABLE sales (sales_value INT);\nINSERT INTO sales VALUES(10),(20),(20),(40);\n\nSELECT SUM(sales_value) FROM sales;\n+------------------+\n| SUM(sales_value) |\n+------------------+\n|               90 |\n+------------------+\n\nSELECT SUM(DISTINCT(sales_value)) FROM sales;\n+----------------------------+\n| SUM(DISTINCT(sales_value)) |\n+----------------------------+\n|                         70 |\n+----------------------------+\n\nCommonly, SUM is used with a GROUP BY clause:\n\nCREATE TABLE sales (name CHAR(10), month CHAR(10), units INT);\n\nINSERT INTO sales VALUES \n (\'Chun\', \'Jan\', 75), (\'Chun\', \'Feb\', 73),\n (\'Esben\', \'Jan\', 43), (\'Esben\', \'Feb\', 31),\n (\'Kaolin\', \'Jan\', 56), (\'Kaolin\', \'Feb\', 88),\n (\'Tatiana\', \'Jan\', 87), (\'Tatiana\', \'Feb\', 83);\n\nSELECT name, SUM(units) FROM sales GROUP BY name;\n+---------+------------+\n| name    | SUM(units) |\n+---------+------------+\n| Chun    |        148 |\n| Esben   |         74 |\n| Kaolin  |        144 |\n| Tatiana |        170 |\n+---------+------------+\n\nThe GROUP BY clause is required when using an aggregate function along with\nregular column data, otherwise the result will be a mismatch, as in the\nfollowing common type of mistake:\n\nSELECT name,SUM(units) FROM sales\n;+------+------------+\n| name | SUM(units) |\n+------+------------+\n| Chun |        536 |\n+------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, SUM(score) OVER (PARTITION BY name) AS total_score\nFROM student_test;\n+---------+--------+-------+-------------+\n| name    | test   | score | total_score |\n+---------+--------+-------+-------------+\n| Chun    | SQL    |    75 |         148 |\n| Chun    | Tuning |    73 |         148 |\n| Esben   | SQL    |    43 |          74 |\n| Esben   | Tuning |    31 |          74 |\n| Kaolin  | SQL    |    56 |         144 |\n| Kaolin  | Tuning |    88 |         144 |\n| Tatiana | SQL    |    87 |          87 |\n+---------+--------+-------+-------------+\n\nURL: https://mariadb.com/kb/en/sum/','','https://mariadb.com/kb/en/sum/'),(328,'ST_POINTONSURFACE',25,'MariaDB starting with 10.1.2\n----------------------------\nST_POINTONSURFACE() was introduced in MariaDB 10.1.2\n\nSyntax\n------\n\nST_PointOnSurface(g)\nPointOnSurface(g)\n\nDescription\n-----------\n\nGiven a geometry, returns a POINT guaranteed to intersect a surface. However,\nsee MDEV-7514.\n\nST_PointOnSurface() and PointOnSurface() are synonyms.\n\nURL: https://mariadb.com/kb/en/st_pointonsurface/','','https://mariadb.com/kb/en/st_pointonsurface/'),(339,'FLUSH',26,'Syntax\n------\n\nFLUSH [NO_WRITE_TO_BINLOG | LOCAL]\n  flush_option [, flush_option] ...\n\nor when flushing tables:\n\nFLUSH [NO_WRITE_TO_BINLOG | LOCAL] TABLES [table_list]  [table_flush_option]\n\nwhere table_list is a list of tables separated by , (comma).\n\nDescription\n-----------\n\nThe FLUSH statement clears or reloads various internal caches used by MariaDB.\nTo execute FLUSH, you must have the RELOAD privilege. See GRANT.\n\nThe RESET statement is similar to FLUSH. See RESET.\n\nYou cannot issue a FLUSH statement from within a stored function or a trigger.\nDoing so within a stored procedure is permitted, as long as it is not called\nby a stored function or trigger. See Stored Routine Limitations, Stored\nFunction Limitations and Trigger Limitations.\n\nIf a listed table is a view, an error like the following will be produced:\n\nERROR 1347 (HY000): \'test.v\' is not BASE TABLE\n\nBy default, FLUSH statements are written to the binary log and will be\nreplicated. The NO_WRITE_TO_BINLOG keyword (LOCAL is an alias) will ensure the\nstatement is not written to the binary log.\n\nThe different flush options are:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| CHANGED_PAGE_BITMAPS      | XtraDB only. Internal command used for backup  |\n|                           | purposes. See the Information Schema           |\n|                           | CHANGED_PAGE_BITMAPS Table.                    |\n+---------------------------+------------------------------------------------+\n| CLIENT_STATISTICS         | Reset client statistics (see SHOW              |\n|                           | CLIENT_STATISTICS).                            |\n+---------------------------+------------------------------------------------+\n| DES_KEY_FILE              | Reloads the DES key file (Specified with the   |\n|                           | --des-key-file startup option).                |\n+---------------------------+------------------------------------------------+\n| HOSTS                     | Flush the hostname cache (used for converting  |\n|                           | ip to host names and for unblocking blocked    |\n|                           | hosts. See max_connect_errors and              |\n|                           | performance_schema.host_cache                  |\n+---------------------------+------------------------------------------------+\n| INDEX_STATISTICS          | Reset index statistics (see SHOW               |\n|                           | INDEX_STATISTICS).                             |\n+---------------------------+------------------------------------------------+\n| [ERROR | ENGINE |         | Close and reopen the specified log type, or    |\n| GENERAL | SLOW | BINARY   | all log types if none are specified. FLUSH     |\n| | RELAY] LOGS             | RELAY LOGS [connection-name] can be used to    |\n|                           | flush the relay logs for a specific            |\n|                           | connection. Only one connection can be         |\n|                           | specified per FLUSH command. See Multi-source  |\n|                           | replication. FLUSH ENGINE LOGS will delete     |\n|                           | all unneeded Aria redo logs. Since MariaDB     |\n|                           | 10.1.30 and MariaDB 10.2.11, FLUSH BINARY      |\n|                           | LOGS DELETE_DOMAIN_ID=(list-of-domains) can    |\n|                           | be used to discard obsolete GTID domains from  |\n|                           | the server\'s binary log state. In order for    |\n|                           | this to be successful, no event group from     |\n|                           | the listed GTID domains can be present in      |\n|                           | existing binary log files. If some still       |\n|                           | exist, then they must be purged prior to       |\n|                           | executing this command. If the command         |\n|                           | completes successfully, then it also rotates   |\n|                           | the binary log.                                |\n+---------------------------+------------------------------------------------+\n| MASTER                    | Deprecated option, use RESET MASTER instead.   |\n+---------------------------+------------------------------------------------+\n| PRIVILEGES                | Reload all privileges from the privilege       |\n|                           | tables in the mysql database. If the server    |\n|                           | is started with --skip-grant-table option,     |\n|                           | this will activate the privilege tables again. |\n+---------------------------+------------------------------------------------+\n| QUERY CACHE               | Defragment the query cache to better utilize   |\n|                           | its memory. If you want to reset the query     |\n|                           | cache, you can do it with RESET QUERY CACHE.   |\n+---------------------------+------------------------------------------------+\n| QUERY_RESPONSE_TIME       | See the QUERY_RESPONSE_TIME plugin.            |\n+---------------------------+------------------------------------------------+\n| SLAVE                     | Deprecated option, use RESET REPLICA or RESET  |\n|                           | SLAVE instead.                                 |\n+---------------------------+------------------------------------------------+\n| SSL                       | Used to dynamically reinitialize the server\'s  |\n|                           | TLS context by reloading the files defined by  |\n|                           | several TLS system variables. See FLUSH SSL    |\n|                           | for more information. This command was first   |\n|                           | added in MariaDB 10.4.1.                       |\n+---------------------------+------------------------------------------------+\n| STATUS                    | Resets all server status variables that can    |\n|                           | be reset to 0. Not all global status           |\n|                           | variables support this, so not all global      |\n|                           | values are reset. See FLUSH STATUS for more    |\n|                           | information.                                   |\n+---------------------------+------------------------------------------------+\n| TABLE                     | Close tables given as options or all open      |\n|                           | tables if no table list was used. From         |\n|                           | MariaDB 10.4.1, using without any table list   |\n|                           | will only close tables not in use, and tables  |\n|                           | not locked by the FLUSH TABLES connection. If  |\n|                           | there are no locked tables, FLUSH TABLES will  |\n|                           | be instant and will not cause any waits, as    |\n|                           | it no longer waits for tables in use. When a   |\n|                           | table list is provided, from MariaDB 10.4.1,   |\n|                           | the server will wait for the end of any        |\n|                           | transactions that are using the tables.        |\n|                           | Previously, FLUSH TABLES only waited for the   |\n|                           | statements to complete.                        |\n+---------------------------+------------------------------------------------+\n| TABLES                    | Same as FLUSH TABLE.                           |\n+---------------------------+------------------------------------------------+\n| TABLES ... FOR EXPORT     | For InnoDB tables, flushes table changes to    |\n|                           | disk to permit binary table copies while the   |\n|                           | server is running. See FLUSH TABLES ... FOR    |\n|                           | EXPORT for more.                               |\n+---------------------------+------------------------------------------------+\n| TABLES WITH READ LOCK     | Closes all open tables. New tables are only    |\n|                           | allowed to be opened with read locks until an  |\n|                           | UNLOCK TABLES is given.                        |\n+---------------------------+------------------------------------------------+\n| TABLES WITH READ LOCK     | As TABLES WITH READ LOCK but also disable all  |\n| AND DISABLE CHECKPOINT    | checkpoint writes by transactional table       |\n|                           | engines. This is useful when doing a disk      |\n|                           | snapshot of all tables.                        |\n+---------------------------+------------------------------------------------+\n| TABLE_STATISTICS          | Reset table statistics (see SHOW               |\n|                           | TABLE_STATISTICS).                             |\n+---------------------------+------------------------------------------------+\n| USER_RESOURCES            | Resets all per hour user resources. This       |\n|                           | enables clients that have exhausted their      |\n|                           | resources to connect again.                    |\n+---------------------------+------------------------------------------------+\n| USER_STATISTICS           | Reset user statistics (see SHOW                |\n|                           | USER_STATISTICS).                              |\n+---------------------------+------------------------------------------------+\n| USER_VARIABLES            | Reset user variables (see User-defined         |\n|                           | variables).                                    |\n+---------------------------+------------------------------------------------+\n\nYou can also use the mysqladmin client to flush things. Use mysqladmin --help\nto examine what flush commands it supports.\n\nFLUSH RELAY LOGS\n----------------\n\nFLUSH RELAY LOGS \'connection_name\';\n\nCompatibility with MySQL\n------------------------\n\nMariaDB starting with 10.7.0\n----------------------------\nThe FOR CHANNEL keyword was added for MySQL compatibility. This is identical\nas using the channel_name directly after the FLUSH command.\n\nFor example, one can now use:\n\nFLUSH RELAY LOGS FOR CHANNEL \'connection_name\';\n\nFLUSH STATUS\n------------\n\nServer status variables can be reset by executing the following:\n\nFLUSH STATUS;\n\nGlobal Status Variables that Support FLUSH STATUS\n-------------------------------------------------\n\nNot all global status variables support being reset by FLUSH STATUS.\nCurrently, the following status variables are reset by FLUSH STATUS:\n\n* Aborted_clients\n* Aborted_connects\n* Binlog_cache_disk_use\n* Binlog_cache_use\n* Binlog_stmt_cache_disk_use\n* Binlog_stmt_cache_use\n* Connection_errors_accept\n* Connection_errors_internal\n* Connection_errors_max_connections\n* Connection_errors_peer_address\n* Connection_errors_select\n* Connection_errors_tcpwrap\n* Created_tmp_files\n* Delayed_errors\n* Delayed_writes\n* Feature_check_constraint\n* Feature_delay_key_write\n* Max_used_connections\n* Opened_plugin_libraries\n* Performance_schema_accounts_lost\n* Performance_schema_cond_instances_lost\n* Performance_schema_digest_lost\n* Performance_schema_file_handles_lost\n* Performance_schema_file_instances_lost\n* Performance_schema_hosts_lost\n* Performance_schema_locker_lost\n* Performance_schema_mutex_instances_lost\n* Performance_schema_rwlock_instances_lost\n* Performance_schema_session_connect_attrs_lost\n* Performance_schema_socket_instances_lost\n* Performance_schema_stage_classes_lost\n* Performance_schema_statement_classes_lost\n* Performance_schema_table_handles_lost\n* Performance_schema_table_instances_lost\n* Performance_schema_thread_instances_lost\n* Performance_schema_users_lost\n* Qcache_hits\n* Qcache_inserts\n* Qcache_lowmem_prunes\n* Qcache_not_cached\n* Rpl_semi_sync_master_no_times\n* Rpl_semi_sync_master_no_tx\n* Rpl_semi_sync_master_timefunc_failures\n* Rpl_semi_sync_master_wait_pos_backtraverse\n* Rpl_semi_sync_master_yes_tx\n* Rpl_transactions_multi_engine\n* Server_audit_writes_failed\n* Slave_retried_transactions\n* Slow_launch_threads\n* Ssl_accept_renegotiates\n* Ssl_accepts\n* Ssl_callback_cache_hits\n* Ssl_client_connects\n* Ssl_connect_renegotiates\n* Ssl_ctx_verify_depth\n* Ssl_ctx_verify_mode\n* Ssl_finished_accepts\n* Ssl_finished_connects\n* Ssl_session_cache_hits\n* Ssl_session_cache_misses\n* Ssl_session_cache_overflows\n* Ssl_session_cache_size\n* Ssl_session_cache_timeouts\n* Ssl_sessions_reused\n* Ssl_used_session_cache_entries\n* Subquery_cache_hit\n* Subquery_cache_miss\n* Table_locks_immediate\n* Table_locks_waited\n* Tc_log_max_pages_used\n* Tc_log_page_waits\n* Transactions_gtid_foreign_engine\n* Transactions_multi_engine\n\nThe different usage of FLUSH TABLES\n-----------------------------------\n\nThe purpose of FLUSH TABLES\n---------------------------\n\nThe purpose of FLUSH TABLES is to clean up the open table cache and table\ndefinition cache from not in use tables. This frees up memory and file\ndescriptors. Normally this is not needed as the caches works on a FIFO bases,\nbut can be useful if the server seams to use up to much memory for some reason.\n\nThe purpose of FLUSH TABLES WITH READ LOCK \n-------------------------------------------\n\nFLUSH TABLES WITH READ LOCK is useful if you want to take a backup of some\ntables. When FLUSH TABLES WITH READ LOCK returns, all write access to tables\nare blocked and all tables are marked as \'properly closed\' on disk. The tables\ncan still be used for read operations.\n\nThe purpose of FLUSH TABLES table_list\n--------------------------------------\n\nFLUSH TABLES table_list is useful if you want to copy a table object/files to\nor from the server. This command puts a lock that stops new users of the table\nand will wait until everyone has stopped using the table. The table is then\nremoved from the table definition and table cache.\n\nNote that it\'s up to the user to ensure that no one is accessing the table\nbetween FLUSH TABLES and the table is copied to or from the server. This can\nbe secured by using LOCK TABLES.\n\nIf there are any tables locked by the connection that is using FLUSH TABLES\nall the locked tables will be closed as part of the flush and reopened and\nrelocked before FLUSH TABLES returns. This allows one to copy the table after\nFLUSH TABLES returns without having any writes on the table. For now this\nworks works with most tables, except InnoDB as InnoDB may do background purges\non the table even while it\'s write locked.\n\nThe purpose of FLUSH TABLES table_list WITH READ LOCK\n-----------------------------------------------------\n\nFLUSH TABLES table_list WITH READ LOCK should work as FLUSH TABLES WITH READ\nLOCK, but only those tables that are listed will be properly closed. However\nin practice this works exactly like FLUSH TABLES WITH READ LOCK as the FLUSH\ncommand has anyway to wait for all WRITE operations to end because we are\ndepending on a global read lock for this code. In the future we should\nconsider fixing this to instead use meta data locks.\n\nImplementation of FLUSH TABLES commands in MariaDB 10.4.8 and above\n-------------------------------------------------------------------\n\nImplementation of FLUSH TABLES\n------------------------------\n\n* Free memory and file descriptors not in use\n\nImplementation of FLUSH TABLES WITH READ LOCK\n---------------------------------------------\n\n* Lock all tables read only for simple old style backup.\n* All background writes are suspended and tables are marked as closed.\n* No statement requiring table changes are allowed for any user until UNLOCK\nTABLES.\n\nInstead of using FLUSH TABLE WITH READ LOCK one should in most cases instead\nuse BACKUP STAGE BLOCK_COMMIT.\n\nImplementation of FLUSH TABLES table_list\n-----------------------------------------\n\n* Free memory and file descriptors for tables not in use from table list.\n* Lock given tables as read only.\n* Wait until all translations has ended that uses any of the given tables.\n* Wait until all background writes are suspended and tables are marked as\nclosed.\n\nImplementation of FLUSH TABLES table_list FOR EXPORT\n----------------------------------------------------\n\n* Free memory and file descriptors for tables not in use from table list\n* Lock given tables as read.\n* Wait until all background writes are suspended and tables are marked as\nclosed.\n* Check that all tables supports FOR EXPORT\n* No changes to these tables allowed until UNLOCK TABLES\n\nThis is basically the same behavior as in old MariaDB version if one first\nlock the tables, then do FLUSH TABLES. The tables will be copyable until\nUNLOCK TABLES.\n\nFLUSH SSL\n---------\n\nMariaDB starting with 10.4\n--------------------------\nThe FLUSH SSL command was first added in MariaDB 10.4.\n\nIn MariaDB 10.4 and later, the FLUSH SSL command can be used to dynamically\nreinitialize the server\'s TLS context. This is most useful if you need to\nreplace a certificate that is about to expire without restarting the server.\n\nThis operation is performed by reloading the files defined by the following\nTLS system variables:\n\n* ssl_cert\n* ssl_key\n* ssl_ca\n* ssl_capath\n* ssl_crl\n* ssl_crlpath\n\nThese TLS system variables are not dynamic, so their values can not be changed\nwithout restarting the server.\n\nIf you want to dynamically reinitialize the server\'s TLS context, then you\nneed to change the certificate and key files at the relevant paths defined by\nthese TLS system variables, without actually changing the values of the\nvariables. See MDEV-19341 for more information.\n\nReducing Memory Usage\n---------------------\n\nTo flush some of the global caches that take up memory, you could execute the\nfollowing command:\n\nFLUSH LOCAL HOSTS,\n QUERY CACHE,\n TABLE_STATISTICS,\n INDEX_STATISTICS,\n USER_STATISTICS;\n\nURL: https://mariadb.com/kb/en/flush/','','https://mariadb.com/kb/en/flush/'),(340,'FLUSH QUERY CACHE',26,'Description\n-----------\n\nYou can defragment the query cache to better utilize its memory with the FLUSH\nQUERY CACHE statement. The statement does not remove any queries from the\ncache.\n\nThe RESET QUERY CACHE statement removes all query results from the query\ncache. The FLUSH TABLES statement also does this.\n\nURL: https://mariadb.com/kb/en/flush-query-cache/','','https://mariadb.com/kb/en/flush-query-cache/'),(186,'VARIANCE',16,'Syntax\n------\n\nVARIANCE(expr)\n\nDescription\n-----------\n\nReturns the population standard variance of expr. This is an extension to\nstandard SQL. The standard SQL function VAR_POP() can be used instead.\n\nVariance is calculated by\n\n* working out the mean for the set\n* for each number, subtracting the mean and squaring the result\n* calculate the average of the resulting differences\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nVARIANCE() can be used as a window function.\n\nVARIANCE() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nCREATE TABLE v(i tinyint);\n\nINSERT INTO v VALUES(101),(99);\n\nSELECT VARIANCE(i) FROM v;\n+-------------+\n| VARIANCE(i) |\n+-------------+\n|      1.0000 |\n+-------------+\n\nINSERT INTO v VALUES(120),(80);\n\nSELECT VARIANCE(i) FROM v;\n+-------------+\n| VARIANCE(i) |\n+-------------+\n|    200.5000 |\n+-------------+\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, VAR_POP(score) \n OVER (PARTITION BY test) AS variance_results FROM student_test;\n+---------+--------+-------+------------------+\n| name    | test   | score | variance_results |\n+---------+--------+-------+------------------+\n| Chun    | SQL    |    75 |         287.1875 |\n| Chun    | Tuning |    73 |         582.0000 |\n| Esben   | SQL    |    43 |         287.1875 |\n| Esben   | Tuning |    31 |         582.0000 |\n| Kaolin  | SQL    |    56 |         287.1875 |\n| Kaolin  | Tuning |    88 |         582.0000 |\n| Tatiana | SQL    |    87 |         287.1875 |\n+---------+--------+-------+------------------+\n\nURL: https://mariadb.com/kb/en/variance/','','https://mariadb.com/kb/en/variance/'),(187,'VAR_POP',16,'Syntax\n------\n\nVAR_POP(expr)\n\nDescription\n-----------\n\nReturns the population standard variance of expr. It considers rows as the\nwhole population, not as a sample, so it has the number of rows as the\ndenominator. You can also use VARIANCE(), which is equivalent but is not\nstandard SQL.\n\nVariance is calculated by\n\n* working out the mean for the set\n* for each number, subtracting the mean and squaring the result\n* calculate the average of the resulting differences\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nVAR_POP() can be used as a window function.\n\nVAR_POP() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nCREATE TABLE v(i tinyint);\n\nINSERT INTO v VALUES(101),(99);\n\nSELECT VAR_POP(i) FROM v;\n+------------+\n| VAR_POP(i) |\n+------------+\n|     1.0000 |\n+------------+\n\nINSERT INTO v VALUES(120),(80);\n\nSELECT VAR_POP(i) FROM v;\n+------------+\n| VAR_POP(i) |\n+------------+\n|   200.5000 |\n+------------+\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, VAR_POP(score) \n OVER (PARTITION BY test) AS variance_results FROM student_test;\n+---------+--------+-------+------------------+\n| name    | test   | score | variance_results |\n+---------+--------+-------+------------------+\n| Chun    | SQL    |    75 |         287.1875 |\n| Esben   | SQL    |    43 |         287.1875 |\n| Kaolin  | SQL    |    56 |         287.1875 |\n| Tatiana | SQL    |    87 |         287.1875 |\n| Chun    | Tuning |    73 |         582.0000 |\n| Esben   | Tuning |    31 |         582.0000 |\n| Kaolin  | Tuning |    88 |         582.0000 |\n+---------+--------+-------+------------------+\n\nURL: https://mariadb.com/kb/en/var_pop/','','https://mariadb.com/kb/en/var_pop/'),(343,'SHOW SLAVE STATUS',26,'Syntax\n------\n\nSHOW SLAVE [\"connection_name\"] STATUS [FOR CHANNEL \"connection_name\"]\nSHOW REPLICA [\"connection_name\"] STATUS -- From MariaDB 10.5.1\n\nor\n\nSHOW ALL SLAVES STATUS\nSHOW ALL REPLICAS STATUS -- From MariaDB 10.5.1\n\nDescription\n-----------\n\nThis statement is to be run on a replica and provides status information on\nessential parameters of the replica threads.\n\nThis statement requires the SUPER privilege, the REPLICATION_CLIENT privilege,\nor, from MariaDB 10.5.2, the REPLICATION SLAVE ADMIN privilege, or, from\nMariaDB 10.5.9, the REPLICA MONITOR privilege.\n\nMulti-Source\n------------\n\nThe ALL and \"connection_name\" options allow you to connect to many primaries\nat the same time.\n\nALL SLAVES (or ALL REPLICAS from MariaDB 10.5.1) gives you a list of all\nconnections to the primary nodes.\n\nThe rows will be sorted according to Connection_name.\n\nIf you specify a connection_name, you only get the information about that\nconnection. If connection_name is not used, then the name set by\ndefault_master_connection is used. If the connection name doesn\'t exist you\nwill get an error: There is no master connection for \'xxx\'.\n\nMariaDB starting with 10.7.0\n----------------------------\nThe FOR CHANNEL keyword was added for MySQL compatibility. This is identical\nas using the channel_name directly after SHOW SLAVE.\n\nColumn Descriptions\n-------------------\n\n+---------------+---------------------------------------+-------------------+\n| Name          | Description                           | Added             |\n+---------------+---------------------------------------+-------------------+\n| Connection_na | Name of the primary connection.       |                   |\n| e             | Returned with SHOW ALL SLAVES STATUS  |                   |\n|               | (or SHOW ALL REPLICAS STATUS from     |                   |\n|               | MariaDB 10.5.1) only.                 |                   |\n+---------------+---------------------------------------+-------------------+\n| Slave_SQL_Sta | State of SQL thread. Returned with    |                   |\n| e             | SHOW ALL SLAVES STATUS (or SHOW ALL   |                   |\n|               | REPLICAS STATUS from MariaDB 10.5.1)  |                   |\n|               | only. See Slave SQL Thread States.    |                   |\n+---------------+---------------------------------------+-------------------+\n| Slave_IO_Stat | State of I/O thread. See Slave I/O    |                   |\n|               | Thread States.                        |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_host   | Master host that the replica is       |                   |\n|               | connected to.                         |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_user   | Account user name being used to       |                   |\n|               | connect to the primary.               |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_port   | The port being used to connect to     |                   |\n|               | the primary.                          |                   |\n+---------------+---------------------------------------+-------------------+\n| Connect_Retry | Time in seconds between retries to    |                   |\n|               | connect. The default is 60. The       |                   |\n|               | CHANGE MASTER TO statement can set    |                   |\n|               | this. The master-retry-count option   |                   |\n|               | determines the maximum number of      |                   |\n|               | reconnection attempts.                |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_Log_Fi | Name of the primary binary log file   |                   |\n| e             | that the I/O thread is currently      |                   |\n|               | reading from.                         |                   |\n+---------------+---------------------------------------+-------------------+\n| Read_Master_L | Position up to which the I/O thread   |                   |\n| g_Pos         | has read in the current primary       |                   |\n|               | binary log file.                      |                   |\n+---------------+---------------------------------------+-------------------+\n| Relay_Log_Fil | Name of the relay log file that the   |                   |\n|               | SQL thread is currently processing.   |                   |\n+---------------+---------------------------------------+-------------------+\n| Relay_Log_Pos | Position up to which the SQL thread   |                   |\n|               | has finished processing in the        |                   |\n|               | current relay log file.               |                   |\n+---------------+---------------------------------------+-------------------+\n| Relay_Master_ | Name of the primary binary log file   |                   |\n| og_File       | that contains the most recent event   |                   |\n|               | executed by the SQL thread.           |                   |\n+---------------+---------------------------------------+-------------------+\n| Slave_IO_Runn | Whether the replica I/O thread is     |                   |\n| ng            | running and connected (Yes), running  |                   |\n|               | but not connected to a primary        |                   |\n|               | (Connecting) or not running (No).     |                   |\n+---------------+---------------------------------------+-------------------+\n| Slave_SQL_Run | Whether or not the SQL thread is      |                   |\n| ing           | running.                              |                   |\n+---------------+---------------------------------------+-------------------+\n| Replicate_Do_ | Databases specified for replicating   |                   |\n| B             | with the replicate_do_db option.      |                   |\n+---------------+---------------------------------------+-------------------+\n| Replicate_Ign | Databases specified for ignoring      |                   |\n| re_DB         | with the replicate_ignore_db option.  |                   |\n+---------------+---------------------------------------+-------------------+\n| Replicate_Do_ | Tables specified for replicating      |                   |\n| able          | with the replicate_do_table option.   |                   |\n+---------------+---------------------------------------+-------------------+\n| Replicate_Ign | Tables specified for ignoring with    |                   |\n| re_Table      | the replicate_ignore_table option.    |                   |\n+---------------+---------------------------------------+-------------------+\n| Replicate_Wil | Tables specified for replicating      |                   |\n| _Do_Table     | with the replicate_wild_do_table      |                   |\n|               | option.                               |                   |\n+---------------+---------------------------------------+-------------------+\n| Replicate_Wil | Tables specified for ignoring with    |                   |\n| _Ignore_Table | the replicate_wild_ignore_table       |                   |\n|               | option.                               |                   |\n+---------------+---------------------------------------+-------------------+\n| Last_Errno    | Alias for Last_SQL_Errno (see below)  |                   |\n+---------------+---------------------------------------+-------------------+\n| Last Error    | Alias for Last_SQL_Error (see below)  |                   |\n+---------------+---------------------------------------+-------------------+\n| Skip_Counter  | Number of events that a replica       |                   |\n|               | skips from the master, as recorded    |                   |\n|               | in the sql_slave_skip_counter system  |                   |\n|               | variable.                             |                   |\n+---------------+---------------------------------------+-------------------+\n| Exec_Master_L | Position up to which the SQL thread   |                   |\n| g_Pos         | has processed in the current master   |                   |\n|               | binary log file. Can be used to       |                   |\n|               | start a new replica from a current    |                   |\n|               | replica with the CHANGE MASTER TO     |                   |\n|               | ... MASTER_LOG_POS option.            |                   |\n+---------------+---------------------------------------+-------------------+\n| Relay_Log_Spa | Total size of all relay log files     |                   |\n| e             | combined.                             |                   |\n+---------------+---------------------------------------+-------------------+\n| Until_Conditi |                                       |                   |\n| n             |                                       |                   |\n+---------------+---------------------------------------+-------------------+\n| Until_Log_Fil | The MASTER_LOG_FILE value of the      |                   |\n|               | START SLAVE UNTIL condition.          |                   |\n+---------------+---------------------------------------+-------------------+\n| Until_Log_Pos | The MASTER_LOG_POS value of the       |                   |\n|               | START SLAVE UNTIL condition.          |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_SSL_Al | Whether an SSL connection is          |                   |\n| owed          | permitted (Yes), not permitted (No)   |                   |\n|               | or permitted but without the replica  |                   |\n|               | having SSL support enabled (Ignored)  |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_SSL_CA | The MASTER_SSL_CA option of the       |                   |\n| File          | CHANGE MASTER TO statement.           |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_SSL_CA | The MASTER_SSL_CAPATH option of the   |                   |\n| Path          | CHANGE MASTER TO statement.           |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_SSL_Ce | The MASTER_SSL_CERT option of the     |                   |\n| t             | CHANGE MASTER TO statement.           |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_SSL_Ci | The MASTER_SSL_CIPHER option of the   |                   |\n| her           | CHANGE MASTER TO statement.           |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_SSL_Ke | The MASTER_SSL_KEY option of the      |                   |\n|               | CHANGE MASTER TO statement.           |                   |\n+---------------+---------------------------------------+-------------------+\n| Seconds_Behin | Difference between the timestamp      |                   |\n| _Master       | logged on the master for the event    |                   |\n|               | that the replica is currently         |                   |\n|               | processing, and the current           |                   |\n|               | timestamp on the replica. Zero if     |                   |\n|               | the replica is not currently          |                   |\n|               | processing an event. With parallel    |                   |\n|               | replication, seconds_behind_master    |                   |\n|               | is updated only after transactions    |                   |\n|               | commit.                               |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_SSL_Ve | The MASTER_SSL_VERIFY_SERVER_CERT     |                   |\n| ify_Server_Ce | option of the CHANGE MASTER TO        |                   |\n| t             | statement.                            |                   |\n+---------------+---------------------------------------+-------------------+\n| Last_IO_Errno | Error code of the most recent error   |                   |\n|               | that caused the I/O thread to stop    |                   |\n|               | (also recorded in the replica\'s       |                   |\n|               | error log). 0 means no error. RESET   |                   |\n|               | SLAVE or RESET MASTER will reset      |                   |\n|               | this value.                           |                   |\n+---------------+---------------------------------------+-------------------+\n| Last_IO_Error | Error message of the most recent      |                   |\n|               | error that caused the I/O thread to   |                   |\n|               | stop (also recorded in the replica\'s  |                   |\n|               | error log). An empty string means no  |                   |\n|               | error. RESET SLAVE or RESET MASTER    |                   |\n|               | will reset this value.                |                   |\n+---------------+---------------------------------------+-------------------+\n| Last_SQL_Errn | Error code of the most recent error   |                   |\n|               | that caused the SQL thread to stop    |                   |\n|               | (also recorded in the replica\'s       |                   |\n|               | error log). 0 means no error. RESET   |                   |\n|               | SLAVE or RESET MASTER will reset      |                   |\n|               | this value.                           |                   |\n+---------------+---------------------------------------+-------------------+\n| Last_SQL_Erro | Error message of the most recent      |                   |\n|               | error that caused the SQL thread to   |                   |\n|               | stop (also recorded in the replica\'s  |                   |\n|               | error log). An empty string means no  |                   |\n|               | error. RESET SLAVE or RESET MASTER    |                   |\n|               | will reset this value.                |                   |\n+---------------+---------------------------------------+-------------------+\n| Replicate_Ign | List of server_ids that are           |                   |\n| re_Server_Ids | currently being ignored for           |                   |\n|               | replication purposes, or an empty     |                   |\n|               | string for none, as specified in the  |                   |\n|               | IGNORE_SERVER_IDS option of the       |                   |\n|               | CHANGE MASTER TO statement.           |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_Server | The master\'s server_id value.         |                   |\n| Id            |                                       |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_SSL_Cr | The MASTER_SSL_CRL option of the      |                   |\n|               | CHANGE MASTER TO statement.           |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_SSL_Cr | The MASTER_SSL_CRLPATH option of the  |                   |\n| path          | CHANGE MASTER TO statement.           |                   |\n+---------------+---------------------------------------+-------------------+\n| Using_Gtid    | Whether or not global transaction     |                   |\n|               | ID\'s are being used for replication   |                   |\n|               | (can be No, Slave_Pos, or             |                   |\n|               | Current_Pos).                         |                   |\n+---------------+---------------------------------------+-------------------+\n| Gtid_IO_Pos   | Current global transaction ID value.  |                   |\n+---------------+---------------------------------------+-------------------+\n| Retried_trans | Number of retried transactions for    |                   |\n| ctions        | this connection. Returned with SHOW   |                   |\n|               | ALL SLAVES STATUS only.               |                   |\n+---------------+---------------------------------------+-------------------+\n| Max_relay_log | Max relay log size for this           |                   |\n| size          | connection. Returned with SHOW ALL    |                   |\n|               | SLAVES STATUS only.                   |                   |\n+---------------+---------------------------------------+-------------------+\n| Executed_log_ | How many log entries the replica has  |                   |\n| ntries        | executed. Returned with SHOW ALL      |                   |\n|               | SLAVES STATUS only.                   |                   |\n+---------------+---------------------------------------+-------------------+\n| Slave_receive | How many heartbeats we have got from  |                   |\n| _heartbeats   | the master. Returned with SHOW ALL    |                   |\n|               | SLAVES STATUS only.                   |                   |\n+---------------+---------------------------------------+-------------------+\n| Slave_heartbe | How often to request a heartbeat      |                   |\n| t_period      | packet from the master (in seconds).  |                   |\n|               | Returned with SHOW ALL SLAVES STATUS  |                   |\n|               | only.                                 |                   |\n+---------------+---------------------------------------+-------------------+\n| Gtid_Slave_Po | GTID of the last event group          |                   |\n|               | replicated on a replica server, for   |                   |\n|               | each replication domain, as stored    |                   |\n|               | in the gtid_slave_pos system          |                   |\n|               | variable. Returned with SHOW ALL      |                   |\n|               | SLAVES STATUS only.                   |                   |\n+---------------+---------------------------------------+-------------------+\n| SQL_Delay     | Value specified by MASTER_DELAY in    | MariaDB 10.2.3    |\n|               | CHANGE MASTER (or 0 if none).         |                   |\n+---------------+---------------------------------------+-------------------+\n| SQL_Remaining | When the replica is delaying the      | MariaDB 10.2.3    |\n| Delay         | execution of an event due to          |                   |\n|               | MASTER_DELAY, this is the number of   |                   |\n|               | seconds of delay remaining before     |                   |\n|               | the event will be applied.            |                   |\n|               | Otherwise, the value is NULL.         |                   |\n+---------------+---------------------------------------+-------------------+\n| Slave_SQL_Run | The state of the SQL driver threads,  | MariaDB 10.2.3    |\n| ing_State     | same as in SHOW PROCESSLIST. When     |                   |\n|               | the replica is delaying the           |                   |\n|               | execution of an event due to          |                   |\n|               | MASTER_DELAY, this field displays:    |                   |\n|               | \"Waiting until MASTER_DELAY seconds   |                   |\n|               | after master executed event\".         |                   |\n+---------------+---------------------------------------+-------------------+\n| Slave_DDL_Gro | This status variable counts the       | MariaDB 10.3.7    |\n| ps            | occurrence of DDL statements.  This   |                   |\n|               | is a replica-side counter for         |                   |\n|               | optimistic parallel replication.      |                   |\n+---------------+---------------------------------------+-------------------+\n| Slave_Non_Tra | This status variable counts the       | MariaDB 10.3.7    |\n| sactional_Gro | occurrence of non-transactional       |                   |\n| ps            | event groups.  This is a              |                   |\n|               | replica-side counter for optimistic   |                   |\n|               | parallel replication.                 |                   |\n+---------------+---------------------------------------+-------------------+\n| Slave_Transac | This status variable counts the       | MariaDB 10.3.7    |\n| ional_Groups  | occurrence of transactional event     |                   |\n|               | groups.  This is a replica-side       |                   |\n|               | counter for optimistic parallel       |                   |\n|               | replication.                          |                   |\n+---------------+---------------------------------------+-------------------+\n\nSHOW REPLICA STATUS\n-------------------\n\nMariaDB starting with 10.5.1\n----------------------------\nSHOW REPLICA STATUS is an alias for SHOW SLAVE STATUS from MariaDB 10.5.1.\n\nExamples\n--------\n\nIf you issue this statement using the mysql client, you can use a \\G statement\nterminator rather than a semicolon to obtain a more readable vertical layout.\n\nSHOW SLAVE STATUS\\G\n*************************** 1. row ***************************\n       Slave_IO_State: Waiting for master to send event\n         Master_Host: db01.example.com\n         Master_User: replicant\n         Master_Port: 3306\n        Connect_Retry: 60\n       Master_Log_File: mariadb-bin.000010\n     Read_Master_Log_Pos: 548\n       Relay_Log_File: relay-bin.000004\n        Relay_Log_Pos: 837\n    Relay_Master_Log_File: mariadb-bin.000010\n      Slave_IO_Running: Yes\n      Slave_SQL_Running: Yes\n       Replicate_Do_DB:\n     Replicate_Ignore_DB:\n     Replicate_Do_Table:\n   Replicate_Ignore_Table:\n   Replicate_Wild_Do_Table:\n Replicate_Wild_Ignore_Table:\n         Last_Errno: 0\n         Last_Error:\n        Skip_Counter: 0\n     Exec_Master_Log_Pos: 548\n       Relay_Log_Space: 1497\n       Until_Condition: None\n       Until_Log_File:\n        Until_Log_Pos: 0\n     Master_SSL_Allowed: No\n     Master_SSL_CA_File:\n     Master_SSL_CA_Path:\n       Master_SSL_Cert:\n      Master_SSL_Cipher:\n       Master_SSL_Key:\n    Seconds_Behind_Master: 0\nMaster_SSL_Verify_Server_Cert: No\n        Last_IO_Errno: 0\n        Last_IO_Error:\n       Last_SQL_Errno: 0\n       Last_SQL_Error:\n Replicate_Ignore_Server_Ids:\n      Master_Server_Id: 101\n       Master_SSL_Crl:\n     Master_SSL_Crlpath:\n         Using_Gtid: No\n         Gtid_IO_Pos:\n\nSHOW ALL SLAVES STATUS\\G\n*************************** 1. row ***************************\n       Connection_name:\n       Slave_SQL_State: Slave has read all relay log; waiting for the\nslave I/O thread to update it\n       Slave_IO_State: Waiting for master to send event\n         Master_Host: db01.example.com\n         Master_User: replicant\n         Master_Port: 3306\n        Connect_Retry: 60\n       Master_Log_File: mariadb-bin.000010\n     Read_Master_Log_Pos: 3608\n       Relay_Log_File: relay-bin.000004\n        Relay_Log_Pos: 3897\n    Relay_Master_Log_File: mariadb-bin.000010\n      Slave_IO_Running: Yes\n      Slave_SQL_Running: Yes\n       Replicate_Do_DB:\n     Replicate_Ignore_DB:\n     Replicate_Do_Table:\n   Replicate_Ignore_Table:\n   Replicate_Wild_Do_Table:\n Replicate_Wild_Ignore_Table:\n         Last_Errno: 0\n         Last_Error:\n        Skip_Counter: 0\n     Exec_Master_Log_Pos: 3608\n       Relay_Log_Space: 4557\n       Until_Condition: None\n       Until_Log_File:\n        Until_Log_Pos: 0\n     Master_SSL_Allowed: No\n     Master_SSL_CA_File:\n     Master_SSL_CA_Path:\n       Master_SSL_Cert:\n      Master_SSL_Cipher:\n       Master_SSL_Key:\n    Seconds_Behind_Master: 0\nMaster_SSL_Verify_Server_Cert: No\n        Last_IO_Errno: 0\n        Last_IO_Error:\n       Last_SQL_Errno: 0\n       Last_SQL_Error:\n Replicate_Ignore_Server_Ids:\n      Master_Server_Id: 101\n       Master_SSL_Crl:\n     Master_SSL_Crlpath:\n         Using_Gtid: No\n         Gtid_IO_Pos:\n    Retried_transactions: 0\n     Max_relay_log_size: 104857600\n    Executed_log_entries: 40\n  Slave_received_heartbeats: 11\n   Slave_heartbeat_period: 1800.000\n       Gtid_Slave_Pos: 0-101-2320\n\nYou can also access some of the variables directly from status variables:\n\nSET @@default_master_connection=\"test\" ;\nshow status like \"%slave%\"\n\nVariable_name   Value\nCom_show_slave_hosts    0\nCom_show_slave_status   0\nCom_start_all_slaves    0\nCom_start_slave 0\nCom_stop_all_slaves     0\nCom_stop_slave  0\nRpl_semi_sync_slave_status      OFF\nSlave_connections       0\nSlave_heartbeat_period  1800.000\nSlave_open_temp_tables  0\nSlave_received_heartbeats       0\nSlave_retried_transactions      0\nSlave_running   OFF\nSlaves_connected        0\nSlaves_running  1\n\nURL: https://mariadb.com/kb/en/show-replica-status/','','https://mariadb.com/kb/en/show-replica-status/'),(351,'SET SQL_LOG_BIN',26,'Syntax\n------\n\nSET [SESSION] sql_log_bin = {0|1}\n\nDescription\n-----------\n\nSets the sql_log_bin system variable, which disables or enables binary logging\nfor the current connection, if the client has the SUPER privilege. The\nstatement is refused with an error if the client does not have that privilege.\n\nBefore MariaDB 5.5 and before MySQL 5.6 one could also set sql_log_bin as a\nglobal variable. This was disabled as this was too dangerous as it could\ndamage replication.\n\nURL: https://mariadb.com/kb/en/set-sql_log_bin/','','https://mariadb.com/kb/en/set-sql_log_bin/'),(387,'SHOW PROFILES',26,'Syntax\n------\n\nSHOW PROFILES\n\nDescription\n-----------\n\nThe SHOW PROFILES statement displays profiling information that indicates\nresource usage for statements executed during the course of the current\nsession. It is used together with SHOW PROFILE.\n\nURL: https://mariadb.com/kb/en/show-profiles/','','https://mariadb.com/kb/en/show-profiles/'),(388,'SHOW QUERY_RESPONSE_TIME',26,'It is possible to use SHOW QUERY_RESPONSE_TIME as an alternative for\nretrieving information from the QUERY_RESPONSE_TIME plugin.\n\nThis was introduced as part of the Information Schema plugin extension.\n\nURL: https://mariadb.com/kb/en/show-query_response_time/','','https://mariadb.com/kb/en/show-query_response_time/'),(389,'SHOW STATUS',26,'Syntax\n------\n\nSHOW [GLOBAL | SESSION] STATUS\n  [LIKE \'pattern\' | WHERE expr]\n\nDescription\n-----------\n\nSHOW STATUS provides server status information. This information also can be\nobtained using the mysqladmin extended-status command, or by querying the\nInformation Schema GLOBAL_STATUS and SESSION_STATUS tables. The LIKE clause,\nif present, indicates which variable names to match. The WHERE clause can be\ngiven to select rows using more general conditions.\n\nWith the GLOBAL modifier, SHOW STATUS displays the status values for all\nconnections to MariaDB. With SESSION, it displays the status values for the\ncurrent connection. If no modifier is present, the default is SESSION. LOCAL\nis a synonym for SESSION. If you see a lot of 0 values, the reason is probably\nthat