/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('be53ae86-9413-4117-9472-2ec4c39b546b','2025-12-04 10:00:50','2025-12-04 10:00:50',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','4808c51e-c5c4-46de-8636-de0836f16d89','2025-12-04 10:00:38','2025-12-04 10:00:38',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('4808c51e-c5c4-46de-8636-de0836f16d89','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2025-12-04 10:00:38','2025-12-04 10:00:38',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2025-12-04 10:00:35',NULL,NULL,0,1,'default','volumes',10),('2025-12-04 10:00:35',NULL,NULL,0,2,'default','snapshots',10),('2025-12-04 10:00:35',NULL,NULL,0,3,'default','gigabytes',1000),('2025-12-04 10:00:35',NULL,NULL,0,4,'default','consistencygroups',10),('2025-12-04 10:00:35',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2025-12-04 10:00:35',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2025-12-04 10:00:49','2025-12-04 11:06:21',NULL,0,1,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',389,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'816acded-31c4-4ed9-8127-1dc1df4c0d06'),('2025-12-04 10:34:01','2025-12-04 11:06:13',NULL,0,2,'cinder-backup-0','cinder-backup','cinder-backup',193,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'75874a3d-9a05-4dc7-93c4-3daa0031ecf7'),('2025-12-04 10:34:01','2025-12-04 11:06:13',NULL,0,3,'hostgroup@ceph','cinder-volume','cinder-volume',193,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'71782efe-35ac-44b8-9b80-c5855b99dad0');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2025-12-04 10:00:38','2025-12-04 10:00:38',NULL,0,'a21b607f-fcc8-4775-aa9f-20d1887ad5c8','__DEFAULT__',NULL,1,'Default Volume Type');
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2025-12-04 10:00:38','2025-12-04 10:00:38.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'4f44ddc0-cf4b-4878-80fa-aec9741814c6','rbd://f62c0b6f-1e98-5ab5-93ea-2f0cbb6d097d/images/4f44ddc0-cf4b-4878-80fa-aec9741814c6/snap','2025-12-04 10:38:52','2025-12-04 10:38:52',NULL,0,'{\"store\": \"default_backend\"}','active'),(2,'d8f467c1-aae7-4191-af6a-cc443665a504','rbd://f62c0b6f-1e98-5ab5-93ea-2f0cbb6d097d/images/d8f467c1-aae7-4191-af6a-cc443665a504/snap','2025-12-04 10:38:54','2025-12-04 10:38:54',NULL,0,'{\"store\": \"default_backend\"}','active');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'4f44ddc0-cf4b-4878-80fa-aec9741814c6','hw_rng_model','virtio','2025-12-04 10:38:49','2025-12-04 10:38:49',NULL,0),(2,'d8f467c1-aae7-4191-af6a-cc443665a504','hw_rng_model','virtio','2025-12-04 10:38:53','2025-12-04 10:38:53',NULL,0);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('4f44ddc0-cf4b-4878-80fa-aec9741814c6','cirros-0.6.2-x86_64-disk.img',21430272,'active','2025-12-04 10:38:49','2025-12-04 10:38:52',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','340d3ca308e046158ba89c94dd84cdec',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('d8f467c1-aae7-4191-af6a-cc443665a504','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2025-12-04 10:38:53','2025-12-04 10:38:54',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','340d3ca308e046158ba89c94dd84cdec',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b');
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2025-12-04 09:59:41',NULL),(1,2,'image','CIM_RASD_','2025-12-04 09:59:41',NULL),(1,3,NULL,'CIM_SASD_','2025-12-04 09:59:42',NULL),(1,9,'image','hw_','2025-12-04 09:59:42',NULL),(1,10,'image','hw_','2025-12-04 09:59:44',NULL),(1,14,'image',NULL,'2025-12-04 09:59:44',NULL),(1,19,'image','hw_','2025-12-04 09:59:44',NULL),(1,25,'image','hw_','2025-12-04 09:59:45',NULL),(1,29,'image',NULL,'2025-12-04 09:59:45',NULL),(1,30,'image',NULL,'2025-12-04 09:59:45',NULL),(1,31,'image',NULL,'2025-12-04 09:59:45',NULL),(1,32,'image',NULL,'2025-12-04 09:59:45',NULL),(2,1,NULL,'CIM_PASD_','2025-12-04 09:59:41',NULL),(2,8,NULL,'hw_','2025-12-04 09:59:42',NULL),(2,9,NULL,'hw_','2025-12-04 09:59:42',NULL),(2,10,NULL,'hw_','2025-12-04 09:59:44',NULL),(2,11,NULL,NULL,'2025-12-04 09:59:44',NULL),(2,13,NULL,NULL,'2025-12-04 09:59:44',NULL),(2,14,NULL,NULL,'2025-12-04 09:59:44',NULL),(2,15,NULL,NULL,'2025-12-04 09:59:44',NULL),(2,16,NULL,'hw_','2025-12-04 09:59:44',NULL),(2,19,NULL,'hw_','2025-12-04 09:59:44',NULL),(2,22,NULL,NULL,'2025-12-04 09:59:45',NULL),(2,23,NULL,'hw_','2025-12-04 09:59:45',NULL),(2,24,NULL,'traits:','2025-12-04 09:59:45',NULL),(2,25,NULL,'hw_','2025-12-04 09:59:45',NULL),(2,26,NULL,NULL,'2025-12-04 09:59:45',NULL),(2,28,NULL,NULL,'2025-12-04 09:59:45',NULL),(2,29,NULL,NULL,'2025-12-04 09:59:45',NULL),(2,30,NULL,NULL,'2025-12-04 09:59:45',NULL),(2,31,NULL,NULL,'2025-12-04 09:59:45',NULL),(2,32,NULL,NULL,'2025-12-04 09:59:45',NULL),(2,33,NULL,'cinder_','2025-12-04 09:59:45',NULL),(3,1,NULL,'CIM_PASD_','2025-12-04 09:59:41',NULL),(3,2,NULL,'CIM_RASD_','2025-12-04 09:59:41',NULL),(3,3,NULL,'CIM_SASD_','2025-12-04 09:59:42',NULL),(3,4,NULL,'CIM_VSSD_','2025-12-04 09:59:42',NULL),(3,5,NULL,NULL,'2025-12-04 09:59:42',NULL),(3,6,NULL,NULL,'2025-12-04 09:59:42',NULL),(3,7,NULL,NULL,'2025-12-04 09:59:42',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2025-12-04 09:59:44',NULL),(4,1,NULL,'CIM_PASD_','2025-12-04 09:59:41',NULL),(4,2,NULL,'CIM_RASD_','2025-12-04 09:59:41',NULL),(4,3,NULL,'CIM_SASD_','2025-12-04 09:59:42',NULL),(4,4,NULL,'CIM_VSSD_','2025-12-04 09:59:42',NULL),(4,8,NULL,'hw:','2025-12-04 09:59:42',NULL),(4,9,NULL,'hw:','2025-12-04 09:59:42',NULL),(4,10,NULL,'hw:','2025-12-04 09:59:43',NULL),(4,12,NULL,'capabilities:','2025-12-04 09:59:44',NULL),(4,16,NULL,'hw:','2025-12-04 09:59:44',NULL),(4,17,NULL,NULL,'2025-12-04 09:59:44',NULL),(4,18,NULL,NULL,'2025-12-04 09:59:44',NULL),(4,19,NULL,'hw:','2025-12-04 09:59:44',NULL),(4,20,NULL,NULL,'2025-12-04 09:59:44',NULL),(4,21,NULL,NULL,'2025-12-04 09:59:44',NULL),(4,23,NULL,'hw:','2025-12-04 09:59:45',NULL),(4,24,NULL,'traits:','2025-12-04 09:59:45',NULL),(4,25,NULL,'hw:','2025-12-04 09:59:45',NULL),(5,1,'scheduler_hints',NULL,'2025-12-04 09:59:41',NULL),(5,30,'metadata',NULL,'2025-12-04 09:59:45',NULL),(5,31,'metadata',NULL,'2025-12-04 09:59:45',NULL),(5,32,'metadata',NULL,'2025-12-04 09:59:45',NULL),(6,30,NULL,NULL,'2025-12-04 09:59:45',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2025-12-04 09:59:41',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2025-12-04 09:59:41',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2025-12-04 09:59:42',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2025-12-04 09:59:42',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-12-04 09:59:42',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-12-04 09:59:42',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2025-12-04 09:59:42',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2025-12-04 09:59:42',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2025-12-04 09:59:42',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2025-12-04 09:59:43',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2025-12-04 09:59:44',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2025-12-04 09:59:44',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2025-12-04 09:59:44',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2025-12-04 09:59:44',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-04 09:59:44',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-04 09:59:44',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-04 09:59:44',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2025-12-04 09:59:44',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2025-12-04 09:59:44',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-04 09:59:44',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-04 09:59:44',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-04 09:59:45',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2025-12-04 09:59:45',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2025-12-04 09:59:45',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-04 09:59:45',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-04 09:59:45',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2025-12-04 09:59:45',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2025-12-04 09:59:45',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2025-12-04 09:59:45',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2025-12-04 09:59:45',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2025-12-04 09:59:45',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2025-12-04 09:59:45',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2025-12-04 09:59:45',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2025-12-04 09:59:44',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2025-12-04 09:59:44',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2025-12-04 09:59:44',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2025-12-04 09:59:45',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2025-12-04 09:59:45',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2025-12-04 09:59:45',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2025-12-04 09:59:45',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-12-04 09:59:45',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-12-04 09:59:45',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-12-04 09:59:45',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-12-04 09:59:45',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-12-04 09:59:45',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2025-12-04 09:59:45',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2025-12-04 09:59:45',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2025-12-04 09:59:45',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2025-12-04 09:59:45',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2025-12-04 09:59:45',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2025-12-04 09:59:45',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2025-12-04 09:59:45',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2025-12-04 09:59:45',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-12-04 09:59:45',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-12-04 09:59:45',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-12-04 09:59:45',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2025-12-04 09:59:41',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2025-12-04 09:59:41',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2025-12-04 09:59:41',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2025-12-04 09:59:42',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2025-12-04 09:59:42',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-12-04 09:59:42',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2025-12-04 09:59:42',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-12-04 09:59:42',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2025-12-04 09:59:42',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2025-12-04 09:59:42',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2025-12-04 09:59:42',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2025-12-04 09:59:42',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2025-12-04 09:59:42',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2025-12-04 09:59:42',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2025-12-04 09:59:42',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2025-12-04 09:59:42',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2025-12-04 09:59:42',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2025-12-04 09:59:42',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2025-12-04 09:59:42',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2025-12-04 09:59:42',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2025-12-04 09:59:42',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2025-12-04 09:59:44',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-04 09:59:44',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2025-12-04 09:59:44',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2025-12-04 09:59:44',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2025-12-04 09:59:44',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-12-04 09:59:44',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-12-04 09:59:44',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-12-04 09:59:44',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2025-12-04 09:59:44',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2025-12-04 09:59:44',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2025-12-04 09:59:44',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2025-12-04 09:59:44',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-12-04 09:59:44',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-12-04 09:59:44',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-12-04 09:59:44',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2025-12-04 09:59:44',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2025-12-04 09:59:44',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2025-12-04 09:59:44',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2025-12-04 09:59:44',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2025-12-04 09:59:44',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-04 09:59:44',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2025-12-04 09:59:44',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2025-12-04 09:59:44',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2025-12-04 09:59:44',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-04 09:59:44',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-04 09:59:44',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-12-04 09:59:44',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2025-12-04 09:59:44',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-12-04 09:59:44',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-04 09:59:44',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-04 09:59:44',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-04 09:59:44',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2025-12-04 09:59:44',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2025-12-04 09:59:44',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2025-12-04 09:59:44',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-12-04 09:59:44',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-12-04 09:59:44',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-12-04 09:59:44',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-12-04 09:59:44',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-12-04 09:59:44',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-12-04 09:59:44',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2025-12-04 09:59:44',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2025-12-04 09:59:44',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-04 09:59:45',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-04 09:59:45',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2025-12-04 09:59:45',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2025-12-04 09:59:45',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2025-12-04 09:59:45',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2025-12-04 09:59:45',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2025-12-04 09:59:45',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-04 09:59:45',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2025-12-04 09:59:45',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-12-04 09:59:45',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-12-04 09:59:45',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2025-12-04 09:59:45',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2025-12-04 09:59:45',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2025-12-04 09:59:45',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2025-12-04 09:59:45',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2025-12-04 09:59:45',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2025-12-04 09:59:45',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-12-04 09:59:45',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2025-12-04 09:59:45',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-12-04 09:59:45',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2025-12-04 09:59:45',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2025-12-04 09:59:45',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2025-12-04 09:59:45',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2025-12-04 09:59:45',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2025-12-04 09:59:45',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2025-12-04 09:59:45',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2025-12-04 09:59:45',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-12-04 09:59:45',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-12-04 09:59:45',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2025-12-04 09:59:45',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2025-12-04 09:59:45',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2025-12-04 09:59:41',NULL),(2,'OS::Glance::Image',1,'2025-12-04 09:59:41',NULL),(3,'OS::Nova::Aggregate',1,'2025-12-04 09:59:41',NULL),(4,'OS::Nova::Flavor',1,'2025-12-04 09:59:41',NULL),(5,'OS::Nova::Server',1,'2025-12-04 09:59:41',NULL),(6,'OS::Trove::Instance',1,'2025-12-04 09:59:45',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `external_id` (`external_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','13628165e7c34f5a9fc6c22e6ad7df6a','ea40f2f13f88426fb1c95148fd181a8a','3dc7097f495c4326bb5e139c16eda3b7',0),('UserProject','13628165e7c34f5a9fc6c22e6ad7df6a','ea40f2f13f88426fb1c95148fd181a8a','5ee04bec4fb44b48ba9dc5d8d658545a',0),('UserProject','51febeb0ee20498daa811b8e86811996','ea40f2f13f88426fb1c95148fd181a8a','3dc7097f495c4326bb5e139c16eda3b7',0),('UserProject','51febeb0ee20498daa811b8e86811996','ea40f2f13f88426fb1c95148fd181a8a','5ee04bec4fb44b48ba9dc5d8d658545a',0),('UserProject','82cf8b8d11e24e72bab909e5bec2fb52','ea40f2f13f88426fb1c95148fd181a8a','3dc7097f495c4326bb5e139c16eda3b7',0),('UserProject','82cf8b8d11e24e72bab909e5bec2fb52','ea40f2f13f88426fb1c95148fd181a8a','5ee04bec4fb44b48ba9dc5d8d658545a',0),('UserProject','83090f1ccf4c4b5da60e1183fb6bdeea','ea40f2f13f88426fb1c95148fd181a8a','3dc7097f495c4326bb5e139c16eda3b7',0),('UserProject','83090f1ccf4c4b5da60e1183fb6bdeea','ea40f2f13f88426fb1c95148fd181a8a','5ee04bec4fb44b48ba9dc5d8d658545a',0),('UserProject','980a47b7ce444ce7b14f5c207a8a920d','ea40f2f13f88426fb1c95148fd181a8a','3dc7097f495c4326bb5e139c16eda3b7',0),('UserProject','980a47b7ce444ce7b14f5c207a8a920d','ea40f2f13f88426fb1c95148fd181a8a','5ee04bec4fb44b48ba9dc5d8d658545a',0),('UserProject','9837648dfbdf4c418f2d618a6fdb1f6c','ea40f2f13f88426fb1c95148fd181a8a','3dc7097f495c4326bb5e139c16eda3b7',0),('UserProject','9837648dfbdf4c418f2d618a6fdb1f6c','ea40f2f13f88426fb1c95148fd181a8a','b695b2f22c054ea4b7c079a49fc84ef4',0),('UserProject','a4b8cd4cc3ed49f488aae8af8459583a','340d3ca308e046158ba89c94dd84cdec','3dc7097f495c4326bb5e139c16eda3b7',0),('UserProject','a4b8cd4cc3ed49f488aae8af8459583a','340d3ca308e046158ba89c94dd84cdec','430b7dc0b61948618f534b7486d1eda7',0),('UserProject','a4b8cd4cc3ed49f488aae8af8459583a','90c8915aaa744ae28c66e512906ce123','3dc7097f495c4326bb5e139c16eda3b7',0),('UserProject','c3a0e2b72cc14d37a16facc5852e392f','ea40f2f13f88426fb1c95148fd181a8a','3dc7097f495c4326bb5e139c16eda3b7',0),('UserProject','c3a0e2b72cc14d37a16facc5852e392f','ea40f2f13f88426fb1c95148fd181a8a','5ee04bec4fb44b48ba9dc5d8d658545a',0),('UserProject','cf3992c797794094a4873cffdf7dc794','ea40f2f13f88426fb1c95148fd181a8a','3dc7097f495c4326bb5e139c16eda3b7',0),('UserProject','cf3992c797794094a4873cffdf7dc794','ea40f2f13f88426fb1c95148fd181a8a','5ee04bec4fb44b48ba9dc5d8d658545a',0),('UserProject','e31e56da99da4198ac4b2cb8bd09056a','ea40f2f13f88426fb1c95148fd181a8a','3dc7097f495c4326bb5e139c16eda3b7',0),('UserProject','e31e56da99da4198ac4b2cb8bd09056a','ea40f2f13f88426fb1c95148fd181a8a','5ee04bec4fb44b48ba9dc5d8d658545a',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('02a5f67e0c8e4116ad4971e1a5666f69',NULL,'internal','10266f9cf0e34cebb18449e7c8730b55','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('0387d229270f447998f6c7b9cac0e12d',NULL,'internal','72291d9228c24a96a69ad63f6dd8cd55','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('0672705ec24a48fa833dc3b817fc16be',NULL,'public','1197957fdc48457e832ecca8ff1e4461','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('1b98ab8bf9e54ad2ba3236ec105e883e',NULL,'public','91ddd8cac73246699ca6aae716bb9eee','https://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('3d4450160cca44af9558208c98d78b1c',NULL,'public','10266f9cf0e34cebb18449e7c8730b55','https://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('604a0c89a1b144e2b1246e676b172bd2',NULL,'public','b95bf9ec100a4da3ae167888c86fa6dd','https://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('72320afffc334b3ca9afd7b88550d063',NULL,'internal','b95bf9ec100a4da3ae167888c86fa6dd','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('75c8f29da460471a8c7d444b9abbc935',NULL,'internal','b1ea2bf2f2a34cb28a7272de54792982','https://manila-internal.openstack.svc:8786/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('83473d7650ab45aaa3a2333ae618b539',NULL,'public','72291d9228c24a96a69ad63f6dd8cd55','https://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('96dc35f2a9894a7e801e1b302db0a70f',NULL,'internal','1197957fdc48457e832ecca8ff1e4461','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('a3b5b986b7654c538147eb203a09930d',NULL,'public','a7f4cb7113174449aca12b9f730549ea','https://manila-public-openstack.apps-crc.testing/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('b1fe00aeccd84b668c4ccca979f5bc85',NULL,'internal','3337ae972c494c3a8d53a433bcbcb3a9','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('c230b3799e1345d990a6bad64fadffba',NULL,'public','3337ae972c494c3a8d53a433bcbcb3a9','https://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('c34cc76260344f2b8740c7f26656caf0',NULL,'public','810f818c810544ee825d2ff10046f01d','https://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('c856b1f6c2f142e5b44081724ca10585',NULL,'public','214124d60fd54c2f95e61e7616d3566b','https://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('d5ea625d68a34d689a063ac9c21a14ac',NULL,'internal','a7f4cb7113174449aca12b9f730549ea','https://manila-internal.openstack.svc:8786/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('edc6ed2680584d91981f625079e9679a',NULL,'internal','810f818c810544ee825d2ff10046f01d','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('f67742e470cc42d6bffab3aec2cdc3d4',NULL,'internal','214124d60fd54c2f95e61e7616d3566b','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('f8cba6f022004b098da237842d7b98c9',NULL,'public','b1ea2bf2f2a34cb28a7272de54792982','https://manila-public-openstack.apps-crc.testing/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('f9011b92c914439db75ebc6cf3d518d2',NULL,'internal','91ddd8cac73246699ca6aae716bb9eee','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('3dc7097f495c4326bb5e139c16eda3b7','b695b2f22c054ea4b7c079a49fc84ef4'),('b695b2f22c054ea4b7c079a49fc84ef4','8889089b795d4d1ca0158f8e23730c87');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=233 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'a4b8cd4cc3ed49f488aae8af8459583a','default','admin',0,NULL),(2,'e31e56da99da4198ac4b2cb8bd09056a','default','cinder',0,NULL),(3,'83090f1ccf4c4b5da60e1183fb6bdeea','default','neutron',0,NULL),(4,'82cf8b8d11e24e72bab909e5bec2fb52','default','ceilometer',0,NULL),(5,'980a47b7ce444ce7b14f5c207a8a920d','default','barbican',0,NULL),(6,'51febeb0ee20498daa811b8e86811996','default','glance',0,NULL),(7,'13628165e7c34f5a9fc6c22e6ad7df6a','default','nova',0,NULL),(8,'c3a0e2b72cc14d37a16facc5852e392f','default','placement',0,NULL),(9,'9837648dfbdf4c418f2d618a6fdb1f6c','default','swift',0,NULL),(10,'cf3992c797794094a4873cffdf7dc794','default','manila',0,NULL),(11,'aa0def65fa3946bb8b5e317de1de094b','default','demo_tempestconf',0,NULL),(12,'2f144470043148368f03c90445795d57','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=233 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$NeyBxl2QZjZw7.hGgLu9QeTeilHlfb4YEvRS4MVeQU.mwofBs9YqO',1764842397500474,NULL,'2025-12-04 09:59:57'),(2,2,NULL,0,'$2b$12$oSYSYsK18vWH8.kUW0W4EOXq51p543jK8hFZ7tTYnyR0ArlgooMfK',1764842461140646,NULL,'2025-12-04 10:01:01'),(3,3,NULL,0,'$2b$12$rwI8DsJyPPMj2BnfDQY/6ewyKbIapsL5muSRVCDOSEWxTwyDq2rnm',1764842464161813,NULL,'2025-12-04 10:01:04'),(4,4,NULL,0,'$2b$12$eTQ11TlwNcGQ7SMWDP/Um.7Z1SfMxGFHTPw4QMQWM7iqyt7z7tJ9S',1764842468230655,NULL,'2025-12-04 10:01:08'),(5,5,NULL,0,'$2b$12$p3TE4aZGuFVUX/tBxasIreBWsaZFxT5yhF6ypNcS9yAjCHXncqHx6',1764842471358764,NULL,'2025-12-04 10:01:11'),(6,6,NULL,0,'$2b$12$JSKteYp5SrOtP2cE82LnHeHkUEKniimrST96R5AlFI6QIJKxAbb3W',1764842475662151,NULL,'2025-12-04 10:01:15'),(7,7,NULL,0,'$2b$12$fLf0JRtI7KQfxIm.iBTMluRTYDIK5voRwG8CSR8ZKOIMD0IpWpivC',1764842481268663,NULL,'2025-12-04 10:01:21'),(8,8,NULL,0,'$2b$12$Ru4CDf0e2xHYpNVX2vpp3uR6MXBcWBjrxq3BzoSRwibMImGinddFi',1764842498989967,NULL,'2025-12-04 10:01:38'),(9,9,NULL,0,'$2b$12$wgez2Y/wWn7T6vnGJNDak.n2j/PUYEog0GxPXe6Kgai6rbgIWaTfS',1764843428078046,NULL,'2025-12-04 10:17:08'),(10,10,NULL,0,'$2b$12$0dlKUWxc./2pest/Zjf5wO4DKHJpqg4uEZTJ6bgbIAJRpBXBuu6ea',1764844474976010,NULL,'2025-12-04 10:34:34'),(11,11,NULL,0,'$2b$12$DxVYWLgk1g89/W3Yw23dx.rEv0KzqbxDy.xITohHbp5EL8S3Ukmra',1764844623995445,NULL,'2025-12-04 10:37:03'),(12,12,NULL,0,'$2b$12$MNlv9Q1mUFgpgv8YnaMyU.RoaDnUXNcDrr6EXA/DONi0wfW5zYPCq',1764844624586544,NULL,'2025-12-04 10:37:04');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('340d3ca308e046158ba89c94dd84cdec','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0),('90c8915aaa744ae28c66e512906ce123','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('a7bed21799f741228b463bd71941d41b','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1),('ea40f2f13f88426fb1c95148fd181a8a','service','{}','service',1,'default','default',0);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=395 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,'ab8b6150eab8422894aa75366280f019',NULL,NULL,NULL,NULL,'2025-12-04 10:39:11',NULL,'2025-12-04 10:39:11',NULL,NULL),(2,NULL,'ed36a29ea66a4affa0c1458ef20d5230',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:39:12',NULL,'2025-12-04 10:39:12',NULL,NULL),(3,NULL,NULL,'31b541b915ad4deaa54fe1a9812b6c97',NULL,NULL,NULL,NULL,'2025-12-04 10:39:14',NULL,'2025-12-04 10:39:14',NULL,NULL),(4,NULL,NULL,'8a3dd58d2971456fbbdc0abb58d4e444',NULL,NULL,NULL,NULL,'2025-12-04 10:39:14',NULL,'2025-12-04 10:39:14',NULL,NULL),(5,NULL,NULL,'17188fe9719c4748a7b5c54f179e862e',NULL,NULL,NULL,NULL,'2025-12-04 10:39:14',NULL,'2025-12-04 10:39:14',NULL,NULL),(6,NULL,NULL,'911f12746e3740b88cfecc603bc40708',NULL,NULL,NULL,NULL,'2025-12-04 10:39:14',NULL,'2025-12-04 10:39:14',NULL,NULL),(7,NULL,NULL,'bd528ab0f2af42a2a417b12d338c83bb',NULL,NULL,NULL,NULL,'2025-12-04 10:39:14',NULL,'2025-12-04 10:39:14',NULL,NULL),(8,NULL,'ed5fab467b134923b42b172e8ad33187',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:39:16',NULL,'2025-12-04 10:39:16',NULL,NULL),(9,NULL,'e7d49da174db4545933686aeba278b36',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:39:16',NULL,'2025-12-04 10:39:16',NULL,NULL),(10,NULL,'1d3c6316cd2e48e28bc4ed86601bd5ba',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:39:17',NULL,'2025-12-04 10:39:17',NULL,NULL),(11,NULL,NULL,'0947339ec56f41dd8fbe696cd12f665e',NULL,NULL,NULL,NULL,'2025-12-04 10:39:18',NULL,'2025-12-04 10:39:18',NULL,NULL),(12,NULL,'346c57a887ae496e8ac99370705dd19f',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:39:18',NULL,'2025-12-04 10:39:18',NULL,NULL),(13,NULL,'ade5d625307343a1a1e4dba551a9315f',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:39:21',NULL,'2025-12-04 10:39:21',NULL,NULL),(14,NULL,NULL,'17e16ffdedeb47bd958fd395eea94622',NULL,NULL,NULL,NULL,'2025-12-04 10:39:22',NULL,'2025-12-04 10:39:22',NULL,NULL),(15,NULL,NULL,'e31fb225b6cd47a186e2e09122371b5d',NULL,NULL,NULL,NULL,'2025-12-04 10:39:22',NULL,'2025-12-04 10:39:22',NULL,NULL),(16,NULL,'a2423f38025c44f3b065edbcc1fceea4',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:39:23',NULL,'2025-12-04 10:39:23',NULL,NULL),(17,NULL,NULL,'b24761be6514489da34b88366c2287b5',NULL,NULL,NULL,NULL,'2025-12-04 10:39:29',NULL,'2025-12-04 10:39:29',NULL,NULL),(18,NULL,NULL,'284247c096ba4ac79ddb3fc8e328f9ae',NULL,NULL,NULL,NULL,'2025-12-04 10:39:29',NULL,'2025-12-04 10:39:29',NULL,NULL),(19,NULL,NULL,'28d021876b6d47e6bb3cbf1d91fe3cfc',NULL,NULL,NULL,NULL,'2025-12-04 10:39:29',NULL,'2025-12-04 10:39:29',NULL,NULL),(20,NULL,'7b35e8ea73b04f24a9a6583c58631c6f',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:39:31',NULL,'2025-12-04 10:39:31',NULL,NULL),(21,NULL,'fdf8cc9e5d484c87979d04086aa3299b',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:39:32',NULL,'2025-12-04 10:39:32',NULL,NULL),(22,NULL,'5b4ee8b2c4b546acba9890978d6e1e5d',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:39:33',NULL,'2025-12-04 10:39:33',NULL,NULL),(23,NULL,NULL,'faddeb6a56b44d20b26f6b1fa515a38e',NULL,NULL,NULL,NULL,'2025-12-04 10:39:33',NULL,'2025-12-04 10:39:33',NULL,NULL),(24,NULL,NULL,'d5e60781409f4f1b9d332f396d212886',NULL,NULL,NULL,NULL,'2025-12-04 10:39:35',NULL,'2025-12-04 10:39:35',NULL,NULL),(25,NULL,'53b0a2a7108349629752e2fe20ef0254',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:39:36',NULL,'2025-12-04 10:39:36',NULL,NULL),(26,NULL,NULL,'55c61a4ee35046c9bd8e7b0e9fb09c68',NULL,NULL,NULL,NULL,'2025-12-04 10:39:37',NULL,'2025-12-04 10:39:37',NULL,NULL),(27,NULL,NULL,'d18d1d574fec4595874ef21ae913c140',NULL,NULL,NULL,NULL,'2025-12-04 10:39:37',NULL,'2025-12-04 10:39:37',NULL,NULL),(28,NULL,NULL,'9565e2931ca045c2aff04912e5c4ba5b',NULL,NULL,NULL,NULL,'2025-12-04 10:39:38',NULL,'2025-12-04 10:39:38',NULL,NULL),(29,NULL,NULL,'04172bb222c9413f9af86ad29b01500b',NULL,NULL,NULL,NULL,'2025-12-04 10:39:39',NULL,'2025-12-04 10:39:39',NULL,NULL),(30,NULL,'a0e02e0e62364d9a86c7e7040e755187',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:39:39',NULL,'2025-12-04 10:39:39',NULL,NULL),(31,NULL,'7692e7a0934a439f8766d50b7c1d88bc',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:39:41',NULL,'2025-12-04 10:39:41',NULL,NULL),(32,NULL,'825ac19e7877463999979d222d2f3af8',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:39:41',NULL,'2025-12-04 10:39:41',NULL,NULL),(33,NULL,'0c03876879cb4e5fa73d645159785ebf',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:39:43',NULL,'2025-12-04 10:39:43',NULL,NULL),(34,NULL,NULL,'7dcf4d30f5a14e2c8d1d5edb6d17a4e6',NULL,NULL,NULL,NULL,'2025-12-04 10:39:44',NULL,'2025-12-04 10:39:44',NULL,NULL),(35,NULL,'fc5813d2099c46418bea085034b9f9f4',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:39:47',NULL,'2025-12-04 10:39:47',NULL,NULL),(36,NULL,NULL,'0e926f1ae8f7463f81e054a468057f92',NULL,NULL,NULL,NULL,'2025-12-04 10:39:49',NULL,'2025-12-04 10:39:49',NULL,NULL),(37,NULL,'8854eb3e385d4d628a66d0ac36e95f6b',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:39:50',NULL,'2025-12-04 10:39:50',NULL,NULL),(38,NULL,NULL,'a8548caf0609455e8b561de274fb1b8e',NULL,NULL,NULL,NULL,'2025-12-04 10:39:53',NULL,'2025-12-04 10:39:53',NULL,NULL),(39,NULL,NULL,'30def06ddfcb4491be841cb17e5f182e',NULL,NULL,NULL,NULL,'2025-12-04 10:39:54',NULL,'2025-12-04 10:39:54',NULL,NULL),(40,NULL,NULL,'045d5e64586a450cb2f94b31c74861bb',NULL,NULL,NULL,NULL,'2025-12-04 10:39:54',NULL,'2025-12-04 10:39:54',NULL,NULL),(41,NULL,NULL,'d28f5388f03544e5b9d2f6f23bccbc28',NULL,NULL,NULL,NULL,'2025-12-04 10:39:54',NULL,'2025-12-04 10:39:54',NULL,NULL),(42,NULL,'05c8461a124b4addbb681e5898e482e5',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:39:56',NULL,'2025-12-04 10:39:56',NULL,NULL),(43,NULL,'e0213a7506cd441c98a9105a7643c92f',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:39:56',NULL,'2025-12-04 10:39:56',NULL,NULL),(44,NULL,'246f1169a6af4a34902c2aa68c00782b',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:39:57',NULL,'2025-12-04 10:39:57',NULL,NULL),(45,NULL,NULL,'9382d7467f084a7daaf3852289dd7e55',NULL,NULL,NULL,NULL,'2025-12-04 10:40:02',NULL,'2025-12-04 10:40:02',NULL,NULL),(46,NULL,'1a11c9942929435599f0a51c3f690b44',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:40:04',NULL,'2025-12-04 10:40:04',NULL,NULL),(47,NULL,NULL,'653b899d0d2d4f9da22ac5ed95232a18',NULL,NULL,NULL,NULL,'2025-12-04 10:40:04',NULL,'2025-12-04 10:40:04',NULL,NULL),(48,NULL,NULL,'9dadecef09b64fd7b0d5a1f08d303cf6',NULL,NULL,NULL,NULL,'2025-12-04 10:40:05',NULL,'2025-12-04 10:40:05',NULL,NULL),(49,NULL,NULL,'465b52bff5224619842c02309dd14583',NULL,NULL,NULL,NULL,'2025-12-04 10:40:05',NULL,'2025-12-04 10:40:05',NULL,NULL),(50,NULL,NULL,'6d6fbd8e2ccf412e9be5d8d208e321b0',NULL,NULL,NULL,NULL,'2025-12-04 10:40:05',NULL,'2025-12-04 10:40:05',NULL,NULL),(51,NULL,'df29c61dd1a741b88b73f99f2c1ffcee',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:40:06',NULL,'2025-12-04 10:40:06',NULL,NULL),(52,NULL,'645ccb67893c4098829ba3a0e1dc688f',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:40:07',NULL,'2025-12-04 10:40:07',NULL,NULL),(53,NULL,'80ab8867ba7149a792086574bd88bada',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:40:09',NULL,'2025-12-04 10:40:09',NULL,NULL),(54,NULL,NULL,'b0b74817f28a40638632c34de45c4b3a',NULL,NULL,NULL,NULL,'2025-12-04 10:40:14',NULL,'2025-12-04 10:40:14',NULL,NULL),(55,NULL,'ee36120fd1ef45478778db2f213d6c09',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:40:17',NULL,'2025-12-04 10:40:17',NULL,NULL),(56,NULL,NULL,'4450ef386c064ec8865c3f5640993885',NULL,NULL,NULL,NULL,'2025-12-04 10:40:28',NULL,'2025-12-04 10:40:28',NULL,NULL),(57,NULL,'bc4567fbe8fa43ebb22d7433659a15be',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:40:29',NULL,'2025-12-04 10:40:29',NULL,NULL),(58,NULL,NULL,'eac8e7ba5c9944b095324567871b92c4',NULL,NULL,NULL,NULL,'2025-12-04 10:40:35',NULL,'2025-12-04 10:40:35',NULL,NULL),(59,NULL,'d921f25618ff456d914dc2a7d8e37197',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:40:36',NULL,'2025-12-04 10:40:36',NULL,NULL),(60,NULL,NULL,'74c4687e9ade4a6382ce5c54f9bae971',NULL,NULL,NULL,NULL,'2025-12-04 10:40:38',NULL,'2025-12-04 10:40:38',NULL,NULL),(61,NULL,'45b18e29190f4379945421b01e7eb293',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:40:40',NULL,'2025-12-04 10:40:40',NULL,NULL),(62,NULL,NULL,'12a4ef9475d44830a5ae0f6ec0df9b51',NULL,NULL,NULL,NULL,'2025-12-04 10:40:42',NULL,'2025-12-04 10:40:42',NULL,NULL),(63,NULL,NULL,'a8ce0e9c3b1244659a5746807a574b35',NULL,NULL,NULL,NULL,'2025-12-04 10:40:42',NULL,'2025-12-04 10:40:42',NULL,NULL),(64,NULL,NULL,'d2380cdaae7840a7aa1016a0c2242ad2',NULL,NULL,NULL,NULL,'2025-12-04 10:40:43',NULL,'2025-12-04 10:40:43',NULL,NULL),(65,NULL,'2f919a11d9264254a1fe102f60c00e0f',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:40:44',NULL,'2025-12-04 10:40:44',NULL,NULL),(66,NULL,'421364ebc3e041b392bf764a127cfda4',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:40:45',NULL,'2025-12-04 10:40:45',NULL,NULL),(67,NULL,'30e995746f0346cc925a4e4d291b4b4b',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:40:45',NULL,'2025-12-04 10:40:45',NULL,NULL),(68,NULL,NULL,'432be7864c2d41508547058364b0ef80',NULL,NULL,NULL,NULL,'2025-12-04 10:40:49',NULL,'2025-12-04 10:40:49',NULL,NULL),(69,NULL,'2b21e3f6c24d4eb39e6fedb5f78ec003',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:40:51',NULL,'2025-12-04 10:40:51',NULL,NULL),(70,NULL,NULL,'b63958fc65d3484eb87ddfe00fea032e',NULL,NULL,NULL,NULL,'2025-12-04 10:40:52',NULL,'2025-12-04 10:40:52',NULL,NULL),(71,NULL,'88b113a805fc4761b61e4c70fab446cc',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:40:53',NULL,'2025-12-04 10:40:53',NULL,NULL),(72,NULL,NULL,'ab38505352004a06b66e46adfcbe64f7',NULL,NULL,NULL,NULL,'2025-12-04 10:40:56',NULL,'2025-12-04 10:40:56',NULL,NULL),(73,NULL,NULL,'4ed802651d844c4a8ea2823553799d68',NULL,NULL,NULL,NULL,'2025-12-04 10:40:57',NULL,'2025-12-04 10:40:57',NULL,NULL),(74,NULL,'e8035dbc7b114d409de88c24e421168d',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:40:58',NULL,'2025-12-04 10:40:58',NULL,NULL),(75,NULL,NULL,'bc56c050813b40b0bbf9c4e291fcfb81',NULL,NULL,NULL,NULL,'2025-12-04 10:41:00',NULL,'2025-12-04 10:41:00',NULL,NULL),(76,NULL,NULL,'d7f3d6fed2e3488f9e565f0a28463385',NULL,NULL,NULL,NULL,'2025-12-04 10:41:02',NULL,'2025-12-04 10:41:02',NULL,NULL),(77,NULL,NULL,'996fce2cd05b4217b0228d40717bd448',NULL,NULL,NULL,NULL,'2025-12-04 10:41:02',NULL,'2025-12-04 10:41:02',NULL,NULL),(78,NULL,NULL,'d62cbbb064cd4277b18c062e7f02e202',NULL,NULL,NULL,NULL,'2025-12-04 10:41:02',NULL,'2025-12-04 10:41:02',NULL,NULL),(79,NULL,'90bddf2946cb4fe9a232cb54a1f8c7b2',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:02',NULL,'2025-12-04 10:41:02',NULL,NULL),(80,NULL,'f6c223a076bd42bd958c3294b89dc763',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:04',NULL,'2025-12-04 10:41:04',NULL,NULL),(81,NULL,NULL,'5fb91cf0998d43dab1e95931b51c44f7',NULL,NULL,NULL,NULL,'2025-12-04 10:41:04',NULL,'2025-12-04 10:41:04',NULL,NULL),(82,NULL,'b4b7161d67c0404cb0870edde77a7421',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:06',NULL,'2025-12-04 10:41:06',NULL,NULL),(83,NULL,'d58a8b2ebba9443a9ede78de383107fc',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:06',NULL,'2025-12-04 10:41:06',NULL,NULL),(84,NULL,'3004719a2c6f424eb998557857a6817d',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:07',NULL,'2025-12-04 10:41:07',NULL,NULL),(85,NULL,NULL,'55e072428b4e4b0db75a74ad7aa0b577',NULL,NULL,NULL,NULL,'2025-12-04 10:41:09',NULL,'2025-12-04 10:41:09',NULL,NULL),(86,NULL,'bf3ddd781c6a4426aa41c25d2e08c448',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:10',NULL,'2025-12-04 10:41:10',NULL,NULL),(87,NULL,NULL,'157dc8f660d248838f2ea190772a2bb5',NULL,NULL,NULL,NULL,'2025-12-04 10:41:12',NULL,'2025-12-04 10:41:12',NULL,NULL),(88,NULL,NULL,'80ac26d193c44d7da1f7abc5dc89e971',NULL,NULL,NULL,NULL,'2025-12-04 10:41:12',NULL,'2025-12-04 10:41:12',NULL,NULL),(89,NULL,NULL,'b5d23f7e91694629931517a6c40efbe5',NULL,NULL,NULL,NULL,'2025-12-04 10:41:13',NULL,'2025-12-04 10:41:13',NULL,NULL),(90,NULL,NULL,'366051a463644fa2ba7de8d32c76de9d',NULL,NULL,NULL,NULL,'2025-12-04 10:41:13',NULL,'2025-12-04 10:41:13',NULL,NULL),(91,NULL,'2a04f16eac7a4e94a295facee3130df9',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:14',NULL,'2025-12-04 10:41:14',NULL,NULL),(92,NULL,NULL,'448ccac3b5a54c36a8a46450300663c2',NULL,NULL,NULL,NULL,'2025-12-04 10:41:14',NULL,'2025-12-04 10:41:14',NULL,NULL),(93,NULL,'54f365c11f8e40988b5a964504f91dd7',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:15',NULL,'2025-12-04 10:41:15',NULL,NULL),(94,NULL,'71c5ea52207041eead8a56ff6ce331bd',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:16',NULL,'2025-12-04 10:41:16',NULL,NULL),(95,NULL,NULL,'346d2a3ba5e24df2a1417033f75e866e',NULL,NULL,NULL,NULL,'2025-12-04 10:41:17',NULL,'2025-12-04 10:41:17',NULL,NULL),(96,NULL,'2f579711d8984e69a3e40f345ebdb109',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:17',NULL,'2025-12-04 10:41:17',NULL,NULL),(97,NULL,NULL,'d51b7a30524f47938c2dc020500a8f0c',NULL,NULL,NULL,NULL,'2025-12-04 10:41:18',NULL,'2025-12-04 10:41:18',NULL,NULL),(98,NULL,'de70f6413fb248c6a07e498350f7a8e3',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:18',NULL,'2025-12-04 10:41:18',NULL,NULL),(99,NULL,'9ca7ed9bc2e0496aa23ff15053339a5d',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:19',NULL,'2025-12-04 10:41:19',NULL,NULL),(100,NULL,NULL,'92f18a8cb60445b391d9a474656ae27b',NULL,NULL,NULL,NULL,'2025-12-04 10:41:20',NULL,'2025-12-04 10:41:20',NULL,NULL),(101,NULL,'dbfbf75395394096bb3ce6c192bcbcdd',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:22',NULL,'2025-12-04 10:41:22',NULL,NULL),(102,NULL,NULL,'a65d76254dd14af887e7c9d783c5712d',NULL,NULL,NULL,NULL,'2025-12-04 10:41:24',NULL,'2025-12-04 10:41:24',NULL,NULL),(103,NULL,'65e3a528a63140f6831a0dccbe68dcbf',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:25',NULL,'2025-12-04 10:41:25',NULL,NULL),(104,NULL,NULL,'fe35f9070a7e4080b4a30329a68b9d07',NULL,NULL,NULL,NULL,'2025-12-04 10:41:25',NULL,'2025-12-04 10:41:25',NULL,NULL),(105,NULL,NULL,'817a4c568a3f44a095eda8342ee02082',NULL,NULL,NULL,NULL,'2025-12-04 10:41:26',NULL,'2025-12-04 10:41:26',NULL,NULL),(106,NULL,NULL,'574ddc79ccf944438aed86464cbcf829',NULL,NULL,NULL,NULL,'2025-12-04 10:41:26',NULL,'2025-12-04 10:41:26',NULL,NULL),(107,NULL,NULL,'3d9a4ff0070e46578b473da1d085cea0',NULL,NULL,NULL,NULL,'2025-12-04 10:41:26',NULL,'2025-12-04 10:41:26',NULL,NULL),(108,NULL,NULL,'e8dd553160c24571a120cca2b63a751a',NULL,NULL,NULL,NULL,'2025-12-04 10:41:27',NULL,'2025-12-04 10:41:27',NULL,NULL),(109,NULL,'11469fb6c7c940dfac7d9dc9bd035f03',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:28',NULL,'2025-12-04 10:41:28',NULL,NULL),(110,NULL,'1f2d055c8ea34aeca1ba61bef8655272',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:29',NULL,'2025-12-04 10:41:29',NULL,NULL),(111,NULL,'d3e2fbf9d0764ba3936a1bced3597f2c',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:29',NULL,'2025-12-04 10:41:29',NULL,NULL),(112,NULL,'b70f2135a2024b7883c0332077b753a2',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:30',NULL,'2025-12-04 10:41:30',NULL,NULL),(113,NULL,NULL,'9528c75b50b64af9ae47a829654d377e',NULL,NULL,NULL,NULL,'2025-12-04 10:41:32',NULL,'2025-12-04 10:41:32',NULL,NULL),(114,NULL,NULL,'10951d9a33444887b5b2016af936c8de',NULL,NULL,NULL,NULL,'2025-12-04 10:41:33',NULL,'2025-12-04 10:41:33',NULL,NULL),(115,NULL,'158bfdd2aac042c9859a4d9f47521a1f',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:34',NULL,'2025-12-04 10:41:34',NULL,NULL),(116,NULL,'9e44349c147f4eaebf8b7b3b7ef31210',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:34',NULL,'2025-12-04 10:41:34',NULL,NULL),(117,NULL,NULL,'dc92d8c1c1944b3ba2f33674c061a1c3',NULL,NULL,NULL,NULL,'2025-12-04 10:41:35',NULL,'2025-12-04 10:41:35',NULL,NULL),(118,NULL,NULL,'89d3354ddd9244ff8e81eab35fb80a7a',NULL,NULL,NULL,NULL,'2025-12-04 10:41:36',NULL,'2025-12-04 10:41:36',NULL,NULL),(119,NULL,'a729cc5ed83f4e87a020caa074604dc0',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:37',NULL,'2025-12-04 10:41:37',NULL,NULL),(120,NULL,NULL,'7da578f357d044d590ceb21b50653ba9',NULL,NULL,NULL,NULL,'2025-12-04 10:41:39',NULL,'2025-12-04 10:41:39',NULL,NULL),(121,NULL,NULL,'61a684b254e549dba92ffde9ca1327fd',NULL,NULL,NULL,NULL,'2025-12-04 10:41:39',NULL,'2025-12-04 10:41:39',NULL,NULL),(122,NULL,NULL,'7815eba62d394ae7a30281b5425fdf9a',NULL,NULL,NULL,NULL,'2025-12-04 10:41:39',NULL,'2025-12-04 10:41:39',NULL,NULL),(123,NULL,NULL,'8671c972f1804e8fb11263d097540a42',NULL,NULL,NULL,NULL,'2025-12-04 10:41:39',NULL,'2025-12-04 10:41:39',NULL,NULL),(124,NULL,NULL,'0a30f6a4158541c897abf56ecdb3e964',NULL,NULL,NULL,NULL,'2025-12-04 10:41:40',NULL,'2025-12-04 10:41:40',NULL,NULL),(125,NULL,NULL,'b08ba290c7af4658a5000b9809067d00',NULL,NULL,NULL,NULL,'2025-12-04 10:41:40',NULL,'2025-12-04 10:41:40',NULL,NULL),(126,NULL,NULL,'107d8cc9c8c946b9bd739149e6fab23c',NULL,NULL,NULL,NULL,'2025-12-04 10:41:40',NULL,'2025-12-04 10:41:40',NULL,NULL),(127,NULL,NULL,'39d4f01f2ffa4284bcd4ea2aba64a00e',NULL,NULL,NULL,NULL,'2025-12-04 10:41:41',NULL,'2025-12-04 10:41:41',NULL,NULL),(128,NULL,'77665fd6e8c24d77823f1cd3779bb758',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:41',NULL,'2025-12-04 10:41:41',NULL,NULL),(129,NULL,'209828455d3a419389bb0a731fac0513',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:41',NULL,'2025-12-04 10:41:41',NULL,NULL),(130,NULL,'6d9aa9e6ab2345809215a762b39be204',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:42',NULL,'2025-12-04 10:41:42',NULL,NULL),(131,NULL,'888a8770ae93481ba9412435a6d19704',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:42',NULL,'2025-12-04 10:41:42',NULL,NULL),(132,NULL,'ca368ad67db64f05b3c54e4dc93f0d39',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:43',NULL,'2025-12-04 10:41:43',NULL,NULL),(133,NULL,'db13917e34f3424f8fafd97256e1afca',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:43',NULL,'2025-12-04 10:41:43',NULL,NULL),(134,NULL,NULL,'db21872cbf8b4cfda8a4dc7959ad55a9',NULL,NULL,NULL,NULL,'2025-12-04 10:41:45',NULL,'2025-12-04 10:41:45',NULL,NULL),(135,NULL,'22a1b7b364424890977b5b0f6ecc0e79',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:46',NULL,'2025-12-04 10:41:46',NULL,NULL),(136,NULL,'59896c1e949f4e6bb322c0c44ee9cd38',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:47',NULL,'2025-12-04 10:41:47',NULL,NULL),(137,NULL,NULL,'06ac101638ca44c08713373adf2348e7',NULL,NULL,NULL,NULL,'2025-12-04 10:41:52',NULL,'2025-12-04 10:41:52',NULL,NULL),(138,NULL,NULL,'eec91ff0f45748a2b00715bd4a49ff90',NULL,NULL,NULL,NULL,'2025-12-04 10:41:52',NULL,'2025-12-04 10:41:52',NULL,NULL),(139,NULL,NULL,'08e00f2044dc48d9a2ad2d6d2ed41757',NULL,NULL,NULL,NULL,'2025-12-04 10:41:52',NULL,'2025-12-04 10:41:52',NULL,NULL),(140,NULL,NULL,'40e3a867228c45b88db4a5d9c75cb005',NULL,NULL,NULL,NULL,'2025-12-04 10:41:52',NULL,'2025-12-04 10:41:52',NULL,NULL),(141,NULL,'7427dc5221d9460e9bff65dc665a9db0',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:54',NULL,'2025-12-04 10:41:54',NULL,NULL),(142,NULL,'f6b7e67e5cba4b81824b218e9e920f8c',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:54',NULL,'2025-12-04 10:41:54',NULL,NULL),(143,NULL,'a45d93a7ecf34963a0c992cc1116c9b3',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:41:55',NULL,'2025-12-04 10:41:55',NULL,NULL),(144,NULL,NULL,'1947827f85dc4c4a96748979eeba5ae1',NULL,NULL,NULL,NULL,'2025-12-04 10:41:55',NULL,'2025-12-04 10:41:55',NULL,NULL),(145,NULL,NULL,'da3e0877a10947589d798531eb3d68af',NULL,NULL,NULL,NULL,'2025-12-04 10:41:59',NULL,'2025-12-04 10:41:59',NULL,NULL),(146,NULL,NULL,'8fd0be029efe4fbfbdc176de8796a32c',NULL,NULL,NULL,NULL,'2025-12-04 10:41:59',NULL,'2025-12-04 10:41:59',NULL,NULL),(147,NULL,NULL,'ebdbce19c170478db5c1f470f4d9bb47',NULL,NULL,NULL,NULL,'2025-12-04 10:42:00',NULL,'2025-12-04 10:42:00',NULL,NULL),(148,NULL,'ecc97bc6bfe546b6b2d42d386bafab9c',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:01',NULL,'2025-12-04 10:42:01',NULL,NULL),(149,NULL,'0046786a8365481e9339ec4368294906',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:03',NULL,'2025-12-04 10:42:03',NULL,NULL),(150,NULL,'8f8a959494f847bc807d975d21f7b605',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:04',NULL,'2025-12-04 10:42:04',NULL,NULL),(151,NULL,NULL,'a00dcb833955472f9531c1a3877f81f8',NULL,NULL,NULL,NULL,'2025-12-04 10:42:04',NULL,'2025-12-04 10:42:04',NULL,NULL),(152,NULL,NULL,'679de7854d754cd4a65795cfbc3c38f9',NULL,NULL,NULL,NULL,'2025-12-04 10:42:06',NULL,'2025-12-04 10:42:06',NULL,NULL),(153,NULL,NULL,'8efe39d31f594f7a99737ba2e0f2a448',NULL,NULL,NULL,NULL,'2025-12-04 10:42:07',NULL,'2025-12-04 10:42:07',NULL,NULL),(154,NULL,'6d6eeeb47c364d7691e1f2e81ebfe3c4',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:07',NULL,'2025-12-04 10:42:07',NULL,NULL),(155,NULL,NULL,'956c2a2425364bc58a945afb8a16635a',NULL,NULL,NULL,NULL,'2025-12-04 10:42:08',NULL,'2025-12-04 10:42:08',NULL,NULL),(156,NULL,NULL,'040cb288d4da426db7dc6df5ca77b112',NULL,NULL,NULL,NULL,'2025-12-04 10:42:08',NULL,'2025-12-04 10:42:08',NULL,NULL),(157,NULL,NULL,'093ebf95fc384b109e48f3f4807ec2b4',NULL,NULL,NULL,NULL,'2025-12-04 10:42:08',NULL,'2025-12-04 10:42:08',NULL,NULL),(158,NULL,'ff8d5c2814b748249a9f1c6aefb3d819',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:09',NULL,'2025-12-04 10:42:09',NULL,NULL),(159,NULL,'c60e97f09941468080000c9c9d5fc507',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:10',NULL,'2025-12-04 10:42:10',NULL,NULL),(160,NULL,'91320ee163cc40bc8f5c820635954e8f',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:11',NULL,'2025-12-04 10:42:11',NULL,NULL),(161,NULL,NULL,'0d46b6fa2b66489faa7b301d9c8f8d83',NULL,NULL,NULL,NULL,'2025-12-04 10:42:11',NULL,'2025-12-04 10:42:11',NULL,NULL),(162,NULL,NULL,'507c8db7b2164bd98f5556ae52f72fd0',NULL,NULL,NULL,NULL,'2025-12-04 10:42:11',NULL,'2025-12-04 10:42:11',NULL,NULL),(163,NULL,NULL,'83d2bc1ab3fd4cccb112492c5f3cf012',NULL,NULL,NULL,NULL,'2025-12-04 10:42:12',NULL,'2025-12-04 10:42:12',NULL,NULL),(164,NULL,NULL,'de759a3ec81642cd83d621173ab2bdb2',NULL,NULL,NULL,NULL,'2025-12-04 10:42:12',NULL,'2025-12-04 10:42:12',NULL,NULL),(165,NULL,NULL,'e1e4071eafc6418e822273981055f4bf',NULL,NULL,NULL,NULL,'2025-12-04 10:42:12',NULL,'2025-12-04 10:42:12',NULL,NULL),(166,NULL,NULL,'eea0eca27b9e43bda9b6244cfeb257d0',NULL,NULL,NULL,NULL,'2025-12-04 10:42:12',NULL,'2025-12-04 10:42:12',NULL,NULL),(167,NULL,NULL,'c44fab7e8e354248b26430399d5e77da',NULL,NULL,NULL,NULL,'2025-12-04 10:42:12',NULL,'2025-12-04 10:42:12',NULL,NULL),(168,NULL,NULL,'7a1243f5f30d48d181e14b5b01c2590b',NULL,NULL,NULL,NULL,'2025-12-04 10:42:12',NULL,'2025-12-04 10:42:12',NULL,NULL),(169,NULL,'829c39a80695492b897dbe32bb2a565c',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:13',NULL,'2025-12-04 10:42:13',NULL,NULL),(170,NULL,'3ff3b6556766470db222e5e719c9fcb8',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:13',NULL,'2025-12-04 10:42:13',NULL,NULL),(171,NULL,'b360544102ca4fec8e63a991bb967884',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:14',NULL,'2025-12-04 10:42:14',NULL,NULL),(172,NULL,'fe2c1db7485042bbb8acde903ece7cdc',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:14',NULL,'2025-12-04 10:42:14',NULL,NULL),(173,NULL,NULL,'c669d95ebe37448db49631213d03e5d1',NULL,NULL,NULL,NULL,'2025-12-04 10:42:14',NULL,'2025-12-04 10:42:14',NULL,NULL),(174,NULL,NULL,'8addd54f00bf4654a0c4de266363ca18',NULL,NULL,NULL,NULL,'2025-12-04 10:42:14',NULL,'2025-12-04 10:42:14',NULL,NULL),(175,NULL,'f409515d619a495bb7f5f1af15f8324a',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:14',NULL,'2025-12-04 10:42:14',NULL,NULL),(176,NULL,NULL,'88e5a16daca84b4896b3a4ca2f314a8b',NULL,NULL,NULL,NULL,'2025-12-04 10:42:15',NULL,'2025-12-04 10:42:15',NULL,NULL),(177,NULL,'b69654bd58cf43e290d4aaecb1b1993b',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:15',NULL,'2025-12-04 10:42:15',NULL,NULL),(178,NULL,'ae2330f34cee47599e079667ef8df8bd',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:16',NULL,'2025-12-04 10:42:16',NULL,NULL),(179,NULL,NULL,'1a5d0f7d91f64ed4be1a8ff587f3d5ae',NULL,NULL,NULL,NULL,'2025-12-04 10:42:17',NULL,'2025-12-04 10:42:17',NULL,NULL),(180,NULL,'7b27b50f18f347c2b4e7556dca3af731',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:17',NULL,'2025-12-04 10:42:17',NULL,NULL),(181,NULL,NULL,'2ee6d72a81b74f868cde21421f81deb4',NULL,NULL,NULL,NULL,'2025-12-04 10:42:17',NULL,'2025-12-04 10:42:17',NULL,NULL),(182,NULL,'30392a4e94124630b3ad880d990f000d',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:17',NULL,'2025-12-04 10:42:17',NULL,NULL),(183,NULL,'28a4fb243e9048868ab9fe5d55fe970b',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:18',NULL,'2025-12-04 10:42:18',NULL,NULL),(184,NULL,'f6b265218efe49abb5dff1c1f3cc54ac',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:19',NULL,'2025-12-04 10:42:19',NULL,NULL),(185,NULL,NULL,'c3fdf51b2b384c02a3f9bf19fc1abc93',NULL,NULL,NULL,NULL,'2025-12-04 10:42:20',NULL,'2025-12-04 10:42:20',NULL,NULL),(186,NULL,'84f7e7862136466c9d68067d9ce9b2e6',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:21',NULL,'2025-12-04 10:42:21',NULL,NULL),(187,NULL,NULL,'5713aa7f75b2432390ade9d1669c887a',NULL,NULL,NULL,NULL,'2025-12-04 10:42:27',NULL,'2025-12-04 10:42:27',NULL,NULL),(188,NULL,NULL,'d266eff9e7ae434291697f9a69cbed9c',NULL,NULL,NULL,NULL,'2025-12-04 10:42:28',NULL,'2025-12-04 10:42:28',NULL,NULL),(189,NULL,NULL,'21bbde75c67d4ac8bd1dc6cb91860e72',NULL,NULL,NULL,NULL,'2025-12-04 10:42:28',NULL,'2025-12-04 10:42:28',NULL,NULL),(190,NULL,NULL,'5c5654c14a734f04bc3192ff1aa70b39',NULL,NULL,NULL,NULL,'2025-12-04 10:42:28',NULL,'2025-12-04 10:42:28',NULL,NULL),(191,NULL,'3c64011320ce4465a3bd87aae6e28a3b',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:29',NULL,'2025-12-04 10:42:29',NULL,NULL),(192,NULL,'d20daf6316784d67855e97574e3eea4e',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:30',NULL,'2025-12-04 10:42:30',NULL,NULL),(193,NULL,NULL,'578e518b779843f997d32e3740b045f2',NULL,NULL,NULL,NULL,'2025-12-04 10:42:30',NULL,'2025-12-04 10:42:30',NULL,NULL),(194,NULL,'e5ed5896f5c141d08b886fe18ab11b56',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:31',NULL,'2025-12-04 10:42:31',NULL,NULL),(195,NULL,NULL,'b4135af5873346b3af7ec13dc431eef2',NULL,NULL,NULL,NULL,'2025-12-04 10:42:32',NULL,'2025-12-04 10:42:32',NULL,NULL),(196,NULL,NULL,'7605bb73352141a09e2e086f63926c01',NULL,NULL,NULL,NULL,'2025-12-04 10:42:33',NULL,'2025-12-04 10:42:33',NULL,NULL),(197,NULL,NULL,'ed2e48ca9d364ad1bdb99b9359ac6ea2',NULL,NULL,NULL,NULL,'2025-12-04 10:42:33',NULL,'2025-12-04 10:42:33',NULL,NULL),(198,NULL,NULL,'1b21526c55d74d058eff71ff5e523ab0',NULL,NULL,NULL,NULL,'2025-12-04 10:42:33',NULL,'2025-12-04 10:42:33',NULL,NULL),(199,NULL,'e9054e17b3ff43baa1b8d582090143ac',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:35',NULL,'2025-12-04 10:42:35',NULL,NULL),(200,NULL,NULL,'5b3c4d41adf24930807bcd56ebfc9708',NULL,NULL,NULL,NULL,'2025-12-04 10:42:35',NULL,'2025-12-04 10:42:35',NULL,NULL),(201,NULL,NULL,'494c3d8599d247c2a753b9601d15f037',NULL,NULL,NULL,NULL,'2025-12-04 10:42:35',NULL,'2025-12-04 10:42:35',NULL,NULL),(202,NULL,'4ac12c2f352948d990be1df2fc6c616b',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:35',NULL,'2025-12-04 10:42:35',NULL,NULL),(203,NULL,NULL,'a5ffc2f4e1234309b00fec54b2737b5d',NULL,NULL,NULL,NULL,'2025-12-04 10:42:35',NULL,'2025-12-04 10:42:35',NULL,NULL),(204,NULL,'27de3cb0faff4455b59d36a3f1a3c8e3',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:36',NULL,'2025-12-04 10:42:36',NULL,NULL),(205,NULL,'aa8671e4211445a3a2da8cc4fec4b3de',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:36',NULL,'2025-12-04 10:42:36',NULL,NULL),(206,NULL,'fdbfd5fcda2146c8b57a296bfa71a5ea',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:37',NULL,'2025-12-04 10:42:37',NULL,NULL),(207,NULL,'611be961954d4b5f9a55ccf8e0bae731',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:38',NULL,'2025-12-04 10:42:38',NULL,NULL),(208,NULL,NULL,'f9144ff4b1ab4d7fbd6dc1cebf6b3994',NULL,NULL,NULL,NULL,'2025-12-04 10:42:39',NULL,'2025-12-04 10:42:39',NULL,NULL),(209,NULL,NULL,'4326a45d529b409c82188bae1a9bcf09',NULL,NULL,NULL,NULL,'2025-12-04 10:42:39',NULL,'2025-12-04 10:42:39',NULL,NULL),(210,NULL,NULL,'ce3f5e635860433b9ae5cf25c8f7dc62',NULL,NULL,NULL,NULL,'2025-12-04 10:42:39',NULL,'2025-12-04 10:42:39',NULL,NULL),(211,NULL,NULL,'f4c88ba4d0844e04b5a52928ee368838',NULL,NULL,NULL,NULL,'2025-12-04 10:42:39',NULL,'2025-12-04 10:42:39',NULL,NULL),(212,NULL,NULL,'12041674bd1643df8ed21c92a30f1bf3',NULL,NULL,NULL,NULL,'2025-12-04 10:42:40',NULL,'2025-12-04 10:42:40',NULL,NULL),(213,NULL,'2d40ae03316045f1b24640181280b9a9',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:41',NULL,'2025-12-04 10:42:41',NULL,NULL),(214,NULL,'0e7cd20c7c5f494390b6038e3dd82cad',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:42',NULL,'2025-12-04 10:42:42',NULL,NULL),(215,NULL,'183c5b12527d40548e71ad59413fde67',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:42',NULL,'2025-12-04 10:42:42',NULL,NULL),(216,NULL,NULL,'6f392c11c69b4c6ea6da3b54ebf39a4e',NULL,NULL,NULL,NULL,'2025-12-04 10:42:43',NULL,'2025-12-04 10:42:43',NULL,NULL),(217,NULL,NULL,'2a3d04d11a564d028e47e58f90b4fbc9',NULL,NULL,NULL,NULL,'2025-12-04 10:42:43',NULL,'2025-12-04 10:42:43',NULL,NULL),(218,NULL,'c397907deea94da5b5064ec46843f491',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:43',NULL,'2025-12-04 10:42:43',NULL,NULL),(219,NULL,NULL,'c918657cf392413c961c5b242039d188',NULL,NULL,NULL,NULL,'2025-12-04 10:42:43',NULL,'2025-12-04 10:42:43',NULL,NULL),(220,NULL,NULL,'7858ae1c9ab44195948c926330e63529',NULL,NULL,NULL,NULL,'2025-12-04 10:42:44',NULL,'2025-12-04 10:42:44',NULL,NULL),(221,NULL,'cb875b7ddccb420a9625fa11560723ac',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:45',NULL,'2025-12-04 10:42:45',NULL,NULL),(222,NULL,'406941d6aa9d474f9bcd2154a1cda633',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:47',NULL,'2025-12-04 10:42:47',NULL,NULL),(223,NULL,'6fbbbbb1b6fd4de7b260f6ac870e9f2c',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:49',NULL,'2025-12-04 10:42:49',NULL,NULL),(224,NULL,NULL,'41aecd0ecf98487fbe142937d4ba99a2',NULL,NULL,NULL,NULL,'2025-12-04 10:42:54',NULL,'2025-12-04 10:42:54',NULL,NULL),(225,NULL,NULL,'1bb26f77770d4e0093ade4fe9d48231b',NULL,NULL,NULL,NULL,'2025-12-04 10:42:55',NULL,'2025-12-04 10:42:55',NULL,NULL),(226,NULL,NULL,'fb8bc0a45f9545de97526280cd88a1bc',NULL,NULL,NULL,NULL,'2025-12-04 10:42:55',NULL,'2025-12-04 10:42:55',NULL,NULL),(227,NULL,NULL,'ae80e002317e4e33b3754b66fb64e276',NULL,NULL,NULL,NULL,'2025-12-04 10:42:55',NULL,'2025-12-04 10:42:55',NULL,NULL),(228,NULL,'861ef911050d4b8ba35e89f01c620f89',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:57',NULL,'2025-12-04 10:42:57',NULL,NULL),(229,NULL,'e346e0a8722e4e2689c80b5c8c7842ce',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:58',NULL,'2025-12-04 10:42:58',NULL,NULL),(230,NULL,'51a9345abe3c4f898b40fc991438c735',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:42:58',NULL,'2025-12-04 10:42:58',NULL,NULL),(231,NULL,NULL,'01ac913806fd4ec1b8556a6894451d82',NULL,NULL,NULL,NULL,'2025-12-04 10:43:06',NULL,'2025-12-04 10:43:06',NULL,NULL),(232,NULL,NULL,'2a76d8ce1fb140f5bbbd61ac660038f7',NULL,NULL,NULL,NULL,'2025-12-04 10:43:07',NULL,'2025-12-04 10:43:07',NULL,NULL),(233,NULL,NULL,'cc2d2aa2bf214339974b91addb59a56b',NULL,NULL,NULL,NULL,'2025-12-04 10:43:07',NULL,'2025-12-04 10:43:07',NULL,NULL),(234,NULL,NULL,'b44d648de9df4c08b9ad6835aff49889',NULL,NULL,NULL,NULL,'2025-12-04 10:43:07',NULL,'2025-12-04 10:43:07',NULL,NULL),(235,NULL,'6df96f3f7888473c8c4020fd09afd972',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:43:08',NULL,'2025-12-04 10:43:08',NULL,NULL),(236,NULL,'96b71c6128fe44acb6c403c9f4d72177',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:43:09',NULL,'2025-12-04 10:43:09',NULL,NULL),(237,NULL,NULL,'5dd280f688a04c31ba4d9545343897db',NULL,NULL,NULL,NULL,'2025-12-04 10:43:09',NULL,'2025-12-04 10:43:09',NULL,NULL),(238,NULL,NULL,'a70fe8cd329045aea5fadbb81acb5c56',NULL,NULL,NULL,NULL,'2025-12-04 10:43:10',NULL,'2025-12-04 10:43:10',NULL,NULL),(239,NULL,'a1a048f97eaf42ee958119edc2eb2510',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:43:10',NULL,'2025-12-04 10:43:10',NULL,NULL),(240,NULL,NULL,'936c73f02b5847adbbe71630454de16e',NULL,NULL,NULL,NULL,'2025-12-04 10:43:10',NULL,'2025-12-04 10:43:10',NULL,NULL),(241,NULL,NULL,'7ed23c07662e4aa3aba63c327a652918',NULL,NULL,NULL,NULL,'2025-12-04 10:43:10',NULL,'2025-12-04 10:43:10',NULL,NULL),(242,NULL,'991152b6ddef4a77a0c0088882c63fa1',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:43:12',NULL,'2025-12-04 10:43:12',NULL,NULL),(243,NULL,'bf5ccaceeccc42cc87df11329a9d0159',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:43:13',NULL,'2025-12-04 10:43:13',NULL,NULL),(244,NULL,'1ed7f5e434f947609e67d197ff3a6e6e',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:43:13',NULL,'2025-12-04 10:43:13',NULL,NULL),(245,NULL,NULL,'dfa15db5106f4e12aa1cc5fe65f33085',NULL,NULL,NULL,NULL,'2025-12-04 10:43:22',NULL,'2025-12-04 10:43:22',NULL,NULL),(246,NULL,NULL,'6dceb286629d4077b6169f1f28ac6d6d',NULL,NULL,NULL,NULL,'2025-12-04 10:43:22',NULL,'2025-12-04 10:43:22',NULL,NULL),(247,NULL,NULL,'773b4eb8264840eaa23e8d78b6e954be',NULL,NULL,NULL,NULL,'2025-12-04 10:43:26',NULL,'2025-12-04 10:43:26',NULL,NULL),(248,NULL,NULL,'8b4c6480f293453d850328438bc66819',NULL,NULL,NULL,NULL,'2025-12-04 10:43:26',NULL,'2025-12-04 10:43:26',NULL,NULL),(249,NULL,NULL,'deebdee00c4548389517d229a17b26ad',NULL,NULL,NULL,NULL,'2025-12-04 10:43:27',NULL,'2025-12-04 10:43:27',NULL,NULL),(250,NULL,NULL,'0702700d81374633a4aede120897e0dd',NULL,NULL,NULL,NULL,'2025-12-04 10:43:27',NULL,'2025-12-04 10:43:27',NULL,NULL),(251,NULL,NULL,'d3c52ac6184348f5b9994127e3eeb5e5',NULL,NULL,NULL,NULL,'2025-12-04 10:43:27',NULL,'2025-12-04 10:43:27',NULL,NULL),(252,NULL,'fafe995d0d93450da236e390437a02ae',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:43:29',NULL,'2025-12-04 10:43:29',NULL,NULL),(253,NULL,'e2d34491d1094a9480aa03d0d203a852',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:43:29',NULL,'2025-12-04 10:43:29',NULL,NULL),(254,NULL,'a431e40dc1ca4ec39b49408556b73421',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:43:30',NULL,'2025-12-04 10:43:30',NULL,NULL),(255,NULL,'094a9e5adfae45769d099eaf0d4f598c',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:43:31',NULL,'2025-12-04 10:43:31',NULL,NULL),(256,NULL,NULL,'02070bf38c73498d9b030a6203229eab',NULL,NULL,NULL,NULL,'2025-12-04 10:43:33',NULL,'2025-12-04 10:43:33',NULL,NULL),(257,NULL,NULL,'1f200d4875424700a142f5fdbf0cf6b6',NULL,NULL,NULL,NULL,'2025-12-04 10:43:34',NULL,'2025-12-04 10:43:34',NULL,NULL),(258,NULL,NULL,'243975b075f1441496646852fec0e903',NULL,NULL,NULL,NULL,'2025-12-04 10:43:34',NULL,'2025-12-04 10:43:34',NULL,NULL),(259,NULL,'e884ccda0adb4fcfa58e4992410a7be8',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:43:35',NULL,'2025-12-04 10:43:35',NULL,NULL),(260,NULL,'e00977936c38452c9bc8e0df9d1a6f93',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:43:36',NULL,'2025-12-04 10:43:36',NULL,NULL),(261,NULL,'7616b444e24a42018c4c83d19b266c57',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:43:37',NULL,'2025-12-04 10:43:37',NULL,NULL),(262,NULL,NULL,'0a2c8ad17e4f48a69bfdd57bd0c664b0',NULL,NULL,NULL,NULL,'2025-12-04 10:43:43',NULL,'2025-12-04 10:43:43',NULL,NULL),(263,NULL,NULL,'e437186468c64469af3daf3d4d025221',NULL,NULL,NULL,NULL,'2025-12-04 10:43:44',NULL,'2025-12-04 10:43:44',NULL,NULL),(264,NULL,NULL,'056b73a057874ad587e7edd2cddec887',NULL,NULL,NULL,NULL,'2025-12-04 10:43:44',NULL,'2025-12-04 10:43:44',NULL,NULL),(265,NULL,NULL,'7bf9d5f49e7845cfabb5d166ed1488b8',NULL,NULL,NULL,NULL,'2025-12-04 10:43:44',NULL,'2025-12-04 10:43:44',NULL,NULL),(266,NULL,'5a53be95459f476babb3cf67445ae79e',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:43:46',NULL,'2025-12-04 10:43:46',NULL,NULL),(267,NULL,'e9dcd86172c54f1d8e5985d48730a1bb',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:43:46',NULL,'2025-12-04 10:43:46',NULL,NULL),(268,NULL,'1717f9a82def4c1d9d1aa469fceb1a06',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:43:47',NULL,'2025-12-04 10:43:47',NULL,NULL),(269,NULL,NULL,'67b8e3f2ec754e60ba528acd51937ee0',NULL,NULL,NULL,NULL,'2025-12-04 10:43:53',NULL,'2025-12-04 10:43:53',NULL,NULL),(270,NULL,NULL,'57fd5cd238bd4533a87ba15ab86ed747',NULL,NULL,NULL,NULL,'2025-12-04 10:43:54',NULL,'2025-12-04 10:43:54',NULL,NULL),(271,NULL,NULL,'4c579d8ef46542619c86f7d6ba0c6283',NULL,NULL,NULL,NULL,'2025-12-04 10:43:54',NULL,'2025-12-04 10:43:54',NULL,NULL),(272,NULL,NULL,'6923d418693d40eab51944a7fbf5f1a8',NULL,NULL,NULL,NULL,'2025-12-04 10:43:54',NULL,'2025-12-04 10:43:54',NULL,NULL),(273,NULL,NULL,'66d920ef9ee34953869dcbd200e5d34a',NULL,NULL,NULL,NULL,'2025-12-04 10:43:54',NULL,'2025-12-04 10:43:54',NULL,NULL),(274,NULL,'192620e929a241e398c53eff29f719b6',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:43:56',NULL,'2025-12-04 10:43:56',NULL,NULL),(275,NULL,'4af245f62b8b46c5ad378efc03734319',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:43:57',NULL,'2025-12-04 10:43:57',NULL,NULL),(276,NULL,NULL,'96fe23c86bd041028a1ccffe636b7da9',NULL,NULL,NULL,NULL,'2025-12-04 10:43:57',NULL,'2025-12-04 10:43:57',NULL,NULL),(277,NULL,NULL,'3a0aa33182f54961a56ea1d9a3a870d8',NULL,NULL,NULL,NULL,'2025-12-04 10:43:57',NULL,'2025-12-04 10:43:57',NULL,NULL),(278,NULL,'b0e23771bd1a4c3ea8b52092c2e5d69e',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:43:57',NULL,'2025-12-04 10:43:57',NULL,NULL),(279,NULL,NULL,'98e6661d4e8d4452a29859b7ea77dddf',NULL,NULL,NULL,NULL,'2025-12-04 10:43:57',NULL,'2025-12-04 10:43:57',NULL,NULL),(280,NULL,'2adab041d4624fab965e1d6cb9ef0784',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:43:59',NULL,'2025-12-04 10:43:59',NULL,NULL),(281,NULL,'e341fe53979c4ee99e85a326deff5230',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:44:00',NULL,'2025-12-04 10:44:00',NULL,NULL),(282,NULL,'7e0c9a3966b443c7bbb289ba33849550',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:44:00',NULL,'2025-12-04 10:44:00',NULL,NULL),(283,NULL,NULL,'2da105345c1b42e784ffe631e88fbe6a',NULL,NULL,NULL,NULL,'2025-12-04 10:44:09',NULL,'2025-12-04 10:44:09',NULL,NULL),(284,NULL,NULL,'cc8309c8aa2b47da966accf9ec753a0e',NULL,NULL,NULL,NULL,'2025-12-04 10:44:13',NULL,'2025-12-04 10:44:13',NULL,NULL),(285,NULL,NULL,'9159019b9d0f445785d7222cb7f1729b',NULL,NULL,NULL,NULL,'2025-12-04 10:44:14',NULL,'2025-12-04 10:44:14',NULL,NULL),(286,NULL,NULL,'03b8dfd6913c4569896ff3e7b46f954e',NULL,NULL,NULL,NULL,'2025-12-04 10:44:14',NULL,'2025-12-04 10:44:14',NULL,NULL),(287,NULL,'3ba683091e694bf1800f8fdcd57277cf',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:44:16',NULL,'2025-12-04 10:44:16',NULL,NULL),(288,NULL,'8bfc8033102c476aa11f3b4a52f397e8',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:44:17',NULL,'2025-12-04 10:44:17',NULL,NULL),(289,NULL,'1dd4050312e047a8a84963d987c4f270',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:44:18',NULL,'2025-12-04 10:44:18',NULL,NULL),(290,NULL,NULL,'2d5dffc7736b4e1e8483b5b9349b646c',NULL,NULL,NULL,NULL,'2025-12-04 10:44:21',NULL,'2025-12-04 10:44:21',NULL,NULL),(291,NULL,'0ad979736a1c47589d4dcfafc02dd386',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:44:22',NULL,'2025-12-04 10:44:22',NULL,NULL),(292,NULL,NULL,'76df54d9716d4f28b2004c61157a78b2',NULL,NULL,NULL,NULL,'2025-12-04 10:44:28',NULL,'2025-12-04 10:44:28',NULL,NULL),(293,NULL,NULL,'e27450e9f3ed432291edf47c7ee575a5',NULL,NULL,NULL,NULL,'2025-12-04 10:44:42',NULL,'2025-12-04 10:44:42',NULL,NULL),(294,NULL,NULL,'48ef94f1dc4447f08252015effc744b0',NULL,NULL,NULL,NULL,'2025-12-04 10:44:43',NULL,'2025-12-04 10:44:43',NULL,NULL),(295,NULL,NULL,'ac347d74fad64b0bbb495d6240c31d44',NULL,NULL,NULL,NULL,'2025-12-04 10:44:43',NULL,'2025-12-04 10:44:43',NULL,NULL),(296,NULL,NULL,'1795dfbea24a4a9b91c1a82726d5b507',NULL,NULL,NULL,NULL,'2025-12-04 10:44:43',NULL,'2025-12-04 10:44:43',NULL,NULL),(297,NULL,'c2e0964e5703431eab30fd7c235961ae',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:44:45',NULL,'2025-12-04 10:44:45',NULL,NULL),(298,NULL,'d831ca1755a740e7819c02d320ecd2a0',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:44:46',NULL,'2025-12-04 10:44:46',NULL,NULL),(299,NULL,NULL,'0ef0510443b848f1bfcd4a773578d114',NULL,NULL,NULL,NULL,'2025-12-04 10:44:47',NULL,'2025-12-04 10:44:47',NULL,NULL),(300,NULL,'f061fffe5d584025ab7facc0875a3612',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:44:47',NULL,'2025-12-04 10:44:47',NULL,NULL),(301,NULL,NULL,'4be9e283419a4deb8760868bde71e1d3',NULL,NULL,NULL,NULL,'2025-12-04 10:44:47',NULL,'2025-12-04 10:44:47',NULL,NULL),(302,NULL,NULL,'093b516bfaf248adbaf58a763ef2336a',NULL,NULL,NULL,NULL,'2025-12-04 10:44:47',NULL,'2025-12-04 10:44:47',NULL,NULL),(303,NULL,'80523a3ac20b4e8cb636cd704b18f878',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:44:49',NULL,'2025-12-04 10:44:49',NULL,NULL),(304,NULL,'82116bedd30e41338dd230f48de0f9fc',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:44:49',NULL,'2025-12-04 10:44:49',NULL,NULL),(305,NULL,'18048b8b581e48239e3a92c77164734b',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:44:50',NULL,'2025-12-04 10:44:50',NULL,NULL),(306,NULL,NULL,'bee3bf034a554f02ba42a200e53f540b',NULL,NULL,NULL,NULL,'2025-12-04 10:44:52',NULL,'2025-12-04 10:44:52',NULL,NULL),(307,NULL,NULL,'2d55a35a9fdf4d1e8a3bf8c0d8df3e8b',NULL,NULL,NULL,NULL,'2025-12-04 10:44:52',NULL,'2025-12-04 10:44:52',NULL,NULL),(308,NULL,NULL,'458e70e7b8dc4e3c80b6195b5fb428c4',NULL,NULL,NULL,NULL,'2025-12-04 10:44:52',NULL,'2025-12-04 10:44:52',NULL,NULL),(309,NULL,NULL,'74d6bc599d67495a9e2adc7d53e3ba9e',NULL,NULL,NULL,NULL,'2025-12-04 10:44:53',NULL,'2025-12-04 10:44:53',NULL,NULL),(310,NULL,'0ed845c07bef4513a85cd6ea4ae114ea',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:44:54',NULL,'2025-12-04 10:44:54',NULL,NULL),(311,NULL,'937c9f18b9584a6d84a6e39fec6f4dcb',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:44:56',NULL,'2025-12-04 10:44:56',NULL,NULL),(312,NULL,'a6cf97a45b60473395cffb0166d39e61',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:44:57',NULL,'2025-12-04 10:44:57',NULL,NULL),(313,NULL,NULL,'22ea2c4923594e4cb5626d4a09a7f6a1',NULL,NULL,NULL,NULL,'2025-12-04 10:45:02',NULL,'2025-12-04 10:45:02',NULL,NULL),(314,NULL,'a206b399e9d842ecbeb897b80e10c0fc',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:45:03',NULL,'2025-12-04 10:45:03',NULL,NULL),(315,NULL,NULL,'16670dcf6ff5402296c1e15149baf91c',NULL,NULL,NULL,NULL,'2025-12-04 10:45:24',NULL,'2025-12-04 10:45:24',NULL,NULL),(316,NULL,NULL,'16082b385ae54073bd230a6276db6494',NULL,NULL,NULL,NULL,'2025-12-04 10:45:38',NULL,'2025-12-04 10:45:38',NULL,NULL),(317,NULL,NULL,'3f33730791564b8080d03da1bf10e6d1',NULL,NULL,NULL,NULL,'2025-12-04 10:45:39',NULL,'2025-12-04 10:45:39',NULL,NULL),(318,NULL,NULL,'9066af761b52465f8fc8f1700108a59c',NULL,NULL,NULL,NULL,'2025-12-04 10:45:39',NULL,'2025-12-04 10:45:39',NULL,NULL),(319,NULL,'fc1dc55455c4455c8c74c6488671677d',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:45:41',NULL,'2025-12-04 10:45:41',NULL,NULL),(320,NULL,'3460108b1f8242d29c75f2fe2d92cb43',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:45:41',NULL,'2025-12-04 10:45:41',NULL,NULL),(321,NULL,'960bfa3026b1476c95fed0294173bb8c',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:45:42',NULL,'2025-12-04 10:45:42',NULL,NULL),(322,NULL,NULL,'b72cbbf259f644efaa02b3401bb9e124',NULL,NULL,NULL,NULL,'2025-12-04 10:45:48',NULL,'2025-12-04 10:45:48',NULL,NULL),(323,NULL,NULL,'09d3d9a773e3419f903ee8374b180f28',NULL,NULL,NULL,NULL,'2025-12-04 10:45:49',NULL,'2025-12-04 10:45:49',NULL,NULL),(324,NULL,NULL,'b7e7df55870c461bbd2492aac89f8321',NULL,NULL,NULL,NULL,'2025-12-04 10:45:49',NULL,'2025-12-04 10:45:49',NULL,NULL),(325,NULL,NULL,'b321754cf2ba434d86d94ecabe8ab5de',NULL,NULL,NULL,NULL,'2025-12-04 10:45:49',NULL,'2025-12-04 10:45:49',NULL,NULL),(326,NULL,'db6466d4270a4326b27b774f7f527b60',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:45:50',NULL,'2025-12-04 10:45:50',NULL,NULL),(327,NULL,'51fbd717b6964f96a28a691eb74f0828',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:45:51',NULL,'2025-12-04 10:45:51',NULL,NULL),(328,NULL,'21b889ef1e304b35864364d099ed9af3',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:45:51',NULL,'2025-12-04 10:45:51',NULL,NULL),(329,NULL,NULL,'f0eb931a4c904510beb8059689aba3eb',NULL,NULL,NULL,NULL,'2025-12-04 10:46:54',NULL,'2025-12-04 10:46:54',NULL,NULL),(330,NULL,NULL,'c8bddd1494604235b944287494725839',NULL,NULL,NULL,NULL,'2025-12-04 10:47:08',NULL,'2025-12-04 10:47:08',NULL,NULL),(331,NULL,NULL,'6e68386d0ad84c5ea01208ca892b09d0',NULL,NULL,NULL,NULL,'2025-12-04 10:47:08',NULL,'2025-12-04 10:47:08',NULL,NULL),(332,NULL,NULL,'e3d9ad61b62040d88c65419a2f637cdb',NULL,NULL,NULL,NULL,'2025-12-04 10:47:08',NULL,'2025-12-04 10:47:08',NULL,NULL),(333,NULL,'43bf9be636a04173856c5f93d7f6aeea',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:47:10',NULL,'2025-12-04 10:47:10',NULL,NULL),(334,NULL,'0c1bb472dd5a4231932cfd3ad676d25d',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:47:11',NULL,'2025-12-04 10:47:11',NULL,NULL),(335,NULL,'bdee1673bf874393ab80f7311782fc10',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:47:12',NULL,'2025-12-04 10:47:12',NULL,NULL),(336,NULL,NULL,'eba1bfb2c08f48948c7adc49d186e5f7',NULL,NULL,NULL,NULL,'2025-12-04 10:47:39',NULL,'2025-12-04 10:47:39',NULL,NULL),(337,NULL,NULL,'5279f5569370472ab0e4cd9ac0d1282a',NULL,NULL,NULL,NULL,'2025-12-04 10:47:40',NULL,'2025-12-04 10:47:40',NULL,NULL),(338,NULL,NULL,'7cbf92cc96924e4faa65304277a5028e',NULL,NULL,NULL,NULL,'2025-12-04 10:47:40',NULL,'2025-12-04 10:47:40',NULL,NULL),(339,NULL,NULL,'08d39615a7a349ae95f9c66ad6c00312',NULL,NULL,NULL,NULL,'2025-12-04 10:47:44',NULL,'2025-12-04 10:47:44',NULL,NULL),(340,NULL,NULL,'0a5bb071ea154977ba90f158e69b2496',NULL,NULL,NULL,NULL,'2025-12-04 10:47:44',NULL,'2025-12-04 10:47:44',NULL,NULL),(341,NULL,NULL,'f20498bb06e6423fa10568a8ab8a853d',NULL,NULL,NULL,NULL,'2025-12-04 10:47:44',NULL,'2025-12-04 10:47:44',NULL,NULL),(342,NULL,'7df6681d57a74b90abc5310588588b91',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:47:46',NULL,'2025-12-04 10:47:46',NULL,NULL),(343,NULL,NULL,'c99b07cc76794bbe865e84c99d719aec',NULL,NULL,NULL,NULL,'2025-12-04 10:47:47',NULL,'2025-12-04 10:47:47',NULL,NULL),(344,NULL,NULL,'633958209bb54fd2bd1cf779b9d7d53f',NULL,NULL,NULL,NULL,'2025-12-04 10:47:47',NULL,'2025-12-04 10:47:47',NULL,NULL),(345,NULL,'22f3bfa84694485daa5b46576511dee6',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:47:47',NULL,'2025-12-04 10:47:47',NULL,NULL),(346,NULL,NULL,'982b6e6527a14c51bbf05ad5cdbdee48',NULL,NULL,NULL,NULL,'2025-12-04 10:47:47',NULL,'2025-12-04 10:47:47',NULL,NULL),(347,NULL,'a31a9a1706a84eb0875d25bd9973857b',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:47:48',NULL,'2025-12-04 10:47:48',NULL,NULL),(348,NULL,'d3483cec568748fe8d530a73085a60d8',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:47:49',NULL,'2025-12-04 10:47:49',NULL,NULL),(349,NULL,'e945d04ef77b47cf95becdc87241ea77',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:47:49',NULL,'2025-12-04 10:47:49',NULL,NULL),(350,NULL,'b08d95dfcf5049b89d93e68ea13452d2',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:47:50',NULL,'2025-12-04 10:47:50',NULL,NULL),(351,NULL,NULL,'ef9b59c11def4bddacdaffd0374d4839',NULL,NULL,NULL,NULL,'2025-12-04 10:48:01',NULL,'2025-12-04 10:48:01',NULL,NULL),(352,NULL,NULL,'e527a5ee394d40f68ecf08bb9e8d5710',NULL,NULL,NULL,NULL,'2025-12-04 10:48:03',NULL,'2025-12-04 10:48:03',NULL,NULL),(353,NULL,NULL,'832dabe00e054a2db2a663d3bafcdafd',NULL,NULL,NULL,NULL,'2025-12-04 10:48:08',NULL,'2025-12-04 10:48:08',NULL,NULL),(354,NULL,NULL,'b5f260cc758e44b587f0cfd7d8a6de02',NULL,NULL,NULL,NULL,'2025-12-04 10:48:09',NULL,'2025-12-04 10:48:09',NULL,NULL),(355,NULL,NULL,'a6ad94e3cc974462bed755c8dd72052e',NULL,NULL,NULL,NULL,'2025-12-04 10:48:09',NULL,'2025-12-04 10:48:09',NULL,NULL),(356,NULL,'0f6052e15e7e46b590c74f0b17c5b51c',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:48:10',NULL,'2025-12-04 10:48:10',NULL,NULL),(357,NULL,NULL,'bd0c952b76bd4095a0ae18a8f5a049b2',NULL,NULL,NULL,NULL,'2025-12-04 10:48:10',NULL,'2025-12-04 10:48:10',NULL,NULL),(358,NULL,NULL,'cb8e8eb6bd5f4c2cb282256801d050cc',NULL,NULL,NULL,NULL,'2025-12-04 10:48:10',NULL,'2025-12-04 10:48:10',NULL,NULL),(359,NULL,NULL,'d8bc3f5a1d54489b9fed2eeaf36c5d0c',NULL,NULL,NULL,NULL,'2025-12-04 10:48:10',NULL,'2025-12-04 10:48:10',NULL,NULL),(360,NULL,'440666156b56403fabeabff6ee9b42d9',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:48:11',NULL,'2025-12-04 10:48:11',NULL,NULL),(361,NULL,'ec44081804d840cda29ddaec7a1fd227',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:48:13',NULL,'2025-12-04 10:48:13',NULL,NULL),(362,NULL,'063b90bfc86448709eb6958911a53f96',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:48:13',NULL,'2025-12-04 10:48:13',NULL,NULL),(363,NULL,'938b490c24114fc486cbc078962cb1ec',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:48:14',NULL,'2025-12-04 10:48:14',NULL,NULL),(364,NULL,'417f1eab31f6496385b23ad1780be9a1',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:48:14',NULL,'2025-12-04 10:48:14',NULL,NULL),(365,NULL,NULL,'fd22b0fd4edd470e84223819b5c5eb76',NULL,NULL,NULL,NULL,'2025-12-04 10:48:18',NULL,'2025-12-04 10:48:18',NULL,NULL),(366,NULL,NULL,'306b28a5906f488393c1e63cf93ebcdd',NULL,NULL,NULL,NULL,'2025-12-04 10:48:18',NULL,'2025-12-04 10:48:18',NULL,NULL),(367,NULL,NULL,'26777efde9cc4866aa22dbd7a80f917e',NULL,NULL,NULL,NULL,'2025-12-04 10:48:18',NULL,'2025-12-04 10:48:18',NULL,NULL),(368,NULL,NULL,'1b029f2e810f4c8cbd3e8a68648bc3ec',NULL,NULL,NULL,NULL,'2025-12-04 10:48:18',NULL,'2025-12-04 10:48:18',NULL,NULL),(369,NULL,'e7afb319dfb34ba7aac51373cfcecd12',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:48:20',NULL,'2025-12-04 10:48:20',NULL,NULL),(370,NULL,'6ad11bd9a4274dc58134aaa69e7af98f',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:48:21',NULL,'2025-12-04 10:48:21',NULL,NULL),(371,NULL,'25298ed084ca40ed8b40e91478315408',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:48:22',NULL,'2025-12-04 10:48:22',NULL,NULL),(372,NULL,NULL,'de4db57a4dde458ca59ef1effab03d64',NULL,NULL,NULL,NULL,'2025-12-04 10:48:27',NULL,'2025-12-04 10:48:27',NULL,NULL),(373,NULL,'d7b71786426443df9d7260a4c1f1ebd1',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:48:28',NULL,'2025-12-04 10:48:28',NULL,NULL),(374,NULL,NULL,'84fca940dad74554809663d054253c04',NULL,NULL,NULL,NULL,'2025-12-04 10:48:42',NULL,'2025-12-04 10:48:42',NULL,NULL),(375,NULL,NULL,'6a5ed276487046048473871a04475e75',NULL,NULL,NULL,NULL,'2025-12-04 10:48:42',NULL,'2025-12-04 10:48:42',NULL,NULL),(376,NULL,NULL,'a2fe02ca77fa464281ca7bfc2aa3bcad',NULL,NULL,NULL,NULL,'2025-12-04 10:48:43',NULL,'2025-12-04 10:48:43',NULL,NULL),(377,NULL,NULL,'2222c98a4f6944e5a633d67e1ecad29b',NULL,NULL,NULL,NULL,'2025-12-04 10:48:43',NULL,'2025-12-04 10:48:43',NULL,NULL),(378,NULL,'d032caebc82f4316b80d5189abf0103f',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:48:45',NULL,'2025-12-04 10:48:45',NULL,NULL),(379,NULL,'5808c2d9427a43ea9bded7fb30acca27',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:48:47',NULL,'2025-12-04 10:48:47',NULL,NULL),(380,NULL,'2ea0041cdb744233942b5aca40f96919',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:48:48',NULL,'2025-12-04 10:48:48',NULL,NULL),(381,NULL,NULL,'24a05e638c4244d588e207c12cf30416',NULL,NULL,NULL,NULL,'2025-12-04 10:50:39',NULL,'2025-12-04 10:50:39',NULL,NULL),(382,NULL,NULL,'a7cbfaccac8f48c1bc69fb83640618a5',NULL,NULL,NULL,NULL,'2025-12-04 10:50:40',NULL,'2025-12-04 10:50:40',NULL,NULL),(383,NULL,NULL,'c39353e3111f4eddb6d7fb68e0965074',NULL,NULL,NULL,NULL,'2025-12-04 10:50:40',NULL,'2025-12-04 10:50:40',NULL,NULL),(384,NULL,NULL,'b800e41f2a26454a9d35c5626057bbd8',NULL,NULL,NULL,NULL,'2025-12-04 10:50:40',NULL,'2025-12-04 10:50:40',NULL,NULL),(385,NULL,'2c40fb2875304a41b2368725937fd373',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:50:43',NULL,'2025-12-04 10:50:43',NULL,NULL),(386,NULL,'136d3078d84b47219283967e5b86c7d3',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:50:44',NULL,'2025-12-04 10:50:44',NULL,NULL),(387,NULL,'7d9f4bcde4d6459eb3c144c9a1b55b32',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:50:45',NULL,'2025-12-04 10:50:45',NULL,NULL),(388,NULL,NULL,'b25f66317ee84e778fdbf75b23c6c961',NULL,NULL,NULL,NULL,'2025-12-04 10:51:34',NULL,'2025-12-04 10:51:34',NULL,NULL),(389,NULL,NULL,'e318249fe70a4240a4a0e7ebc5c47a65',NULL,NULL,NULL,NULL,'2025-12-04 10:51:41',NULL,'2025-12-04 10:51:41',NULL,NULL),(390,NULL,NULL,'df165600628341918132a07ee4b9593d',NULL,NULL,NULL,NULL,'2025-12-04 10:51:41',NULL,'2025-12-04 10:51:41',NULL,NULL),(391,NULL,NULL,'b006ee8e24454c51b6d0fc1b94cbd9a7',NULL,NULL,NULL,NULL,'2025-12-04 10:51:42',NULL,'2025-12-04 10:51:42',NULL,NULL),(392,NULL,'1990cd137d2348228dbe4e163606ed4b',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:51:43',NULL,'2025-12-04 10:51:43',NULL,NULL),(393,NULL,'820126ba71664cbb9f6ba3ba5865299b',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:51:43',NULL,'2025-12-04 10:51:43',NULL,NULL),(394,NULL,'c3ea6486309b4dab9bf9d14f604bdce4',NULL,NULL,NULL,NULL,NULL,'2025-12-04 10:51:44',NULL,'2025-12-04 10:51:44',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('3dc7097f495c4326bb5e139c16eda3b7','admin','{}','<<null>>',NULL),('430b7dc0b61948618f534b7486d1eda7','swiftoperator','{}','<<null>>',NULL),('5ee04bec4fb44b48ba9dc5d8d658545a','service','{}','<<null>>',NULL),('8889089b795d4d1ca0158f8e23730c87','reader','{}','<<null>>',NULL),('b695b2f22c054ea4b7c079a49fc84ef4','member','{}','<<null>>',NULL),('c9b86b484d35449a96434f84e3787b46','ResellerAdmin','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('3dc7097f495c4326bb5e139c16eda3b7','IMMU','true'),('8889089b795d4d1ca0158f8e23730c87','IMMU','true'),('b695b2f22c054ea4b7c079a49fc84ef4','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('10266f9cf0e34cebb18449e7c8730b55','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('1197957fdc48457e832ecca8ff1e4461','object-store',1,'{\"name\": \"swift\", \"description\": \"OpenStack Object Storage\"}'),('214124d60fd54c2f95e61e7616d3566b','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('2aac1f53520243b8a49df99083740b25','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('3337ae972c494c3a8d53a433bcbcb3a9','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('72291d9228c24a96a69ad63f6dd8cd55','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('810f818c810544ee825d2ff10046f01d','identity',1,'{\"name\": \"keystone\"}'),('91ddd8cac73246699ca6aae716bb9eee','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('a7f4cb7113174449aca12b9f730549ea','sharev2',1,'{\"description\": \"Manila V2 Service\", \"name\": \"manilav2\"}'),('b1ea2bf2f2a34cb28a7272de54792982','share',1,'{\"description\": \"Manila V1 Service\", \"name\": \"manila\"}'),('b95bf9ec100a4da3ae167888c86fa6dd','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','a4b8cd4cc3ed49f488aae8af8459583a','system','3dc7097f495c4326bb5e139c16eda3b7',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_trust_id` (`trust_id`),
  KEY `ix_token_user_id` (`user_id`),
  KEY `ix_token_expires` (`expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('13628165e7c34f5a9fc6c22e6ad7df6a','{}',1,'ea40f2f13f88426fb1c95148fd181a8a','2025-12-04 10:01:21','2025-12-04','default'),('2f144470043148368f03c90445795d57','{\"tenantId\": \"a7bed21799f741228b463bd71941d41b\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2025-12-04 10:37:04',NULL,'default'),('51febeb0ee20498daa811b8e86811996','{}',1,'ea40f2f13f88426fb1c95148fd181a8a','2025-12-04 10:01:15','2025-12-04','default'),('82cf8b8d11e24e72bab909e5bec2fb52','{}',1,'ea40f2f13f88426fb1c95148fd181a8a','2025-12-04 10:01:08','2025-12-04','default'),('83090f1ccf4c4b5da60e1183fb6bdeea','{}',1,'ea40f2f13f88426fb1c95148fd181a8a','2025-12-04 10:01:04','2025-12-04','default'),('980a47b7ce444ce7b14f5c207a8a920d','{}',1,'ea40f2f13f88426fb1c95148fd181a8a','2025-12-04 10:01:11',NULL,'default'),('9837648dfbdf4c418f2d618a6fdb1f6c','{}',1,'ea40f2f13f88426fb1c95148fd181a8a','2025-12-04 10:17:08',NULL,'default'),('a4b8cd4cc3ed49f488aae8af8459583a','{}',1,NULL,'2025-12-04 09:59:57','2025-12-04','default'),('aa0def65fa3946bb8b5e317de1de094b','{\"tenantId\": \"90c8915aaa744ae28c66e512906ce123\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2025-12-04 10:37:04',NULL,'default'),('c3a0e2b72cc14d37a16facc5852e392f','{}',1,'ea40f2f13f88426fb1c95148fd181a8a','2025-12-04 10:01:39','2025-12-04','default'),('cf3992c797794094a4873cffdf7dc794','{}',1,'ea40f2f13f88426fb1c95148fd181a8a','2025-12-04 10:34:35','2025-12-04','default'),('e31e56da99da4198ac4b2cb8bd09056a','{}',1,'ea40f2f13f88426fb1c95148fd181a8a','2025-12-04 10:01:01','2025-12-04','default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `manila`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `manila` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `manila`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('aebe2a413e13');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `async_operation_data`
--

DROP TABLE IF EXISTS `async_operation_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `async_operation_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `async_operation_data`
--

LOCK TABLES `async_operation_data` WRITE;
/*!40000 ALTER TABLE `async_operation_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `async_operation_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `availability_zones`
--

DROP TABLE IF EXISTS `availability_zones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `availability_zones` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `az_name_uc` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `availability_zones`
--

LOCK TABLES `availability_zones` WRITE;
/*!40000 ALTER TABLE `availability_zones` DISABLE KEYS */;
INSERT INTO `availability_zones` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`) VALUES ('2025-12-04 10:34:36.436537',NULL,NULL,'False','f77ebe78-579a-4b46-8364-e2bff82f3947','nova');
/*!40000 ALTER TABLE `availability_zones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backend_info`
--

DROP TABLE IF EXISTS `backend_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backend_info` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `host` varchar(255) NOT NULL,
  `info_hash` varchar(255) NOT NULL,
  PRIMARY KEY (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backend_info`
--

LOCK TABLES `backend_info` WRITE;
/*!40000 ALTER TABLE `backend_info` DISABLE KEYS */;
INSERT INTO `backend_info` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `host`, `info_hash`) VALUES ('2025-12-04 10:34:44.810800',NULL,NULL,0,'hostgroup@cephfs','e66c0dfc0d422efa26af62f5a81dd60603e2d39a');
/*!40000 ALTER TABLE `backend_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `drivers_private_data`
--

DROP TABLE IF EXISTS `drivers_private_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `drivers_private_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `drivers_private_data`
--

LOCK TABLES `drivers_private_data` WRITE;
/*!40000 ALTER TABLE `drivers_private_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `drivers_private_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_id` varchar(36) DEFAULT NULL,
  `action_id` varchar(10) NOT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
INSERT INTO `messages` (`id`, `project_id`, `request_id`, `resource_type`, `resource_id`, `action_id`, `detail_id`, `message_level`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `expires_at`) VALUES ('0149cb02-86e1-48fc-9423-e4f48cf2fe70','54f365c11f8e40988b5a964504f91dd7','req-a47ae02e-011f-4b9c-b66e-1507d739f822','SHARE','b4cdc665-be17-46f3-a891-62bcda45f028','001','008','ERROR','2025-12-04 10:40:59.738759',NULL,NULL,'False','2026-01-03 10:40:59'),('05da90bc-ae2c-4848-909e-aac413b69181','54f365c11f8e40988b5a964504f91dd7','req-540a8b6b-1f6d-4728-baca-49ade84a0499','SHARE','c4b62a45-3848-4567-b3a2-b712c3febc47','001','008','ERROR','2025-12-04 10:40:55.472376',NULL,NULL,'False','2026-01-03 10:40:55'),('0b067791-8995-4c1b-ac8b-f0cc2168bc72','54f365c11f8e40988b5a964504f91dd7','req-d23539d8-75c1-49ef-975f-1a4c5173117e','SHARE','4dd303d7-6f90-41b6-af60-24e0e2cf4d18','001','008','ERROR','2025-12-04 10:40:51.284379',NULL,NULL,'False','2026-01-03 10:40:51'),('2df44321-4d07-48c9-907b-a2628b808f08','e2d34491d1094a9480aa03d0d203a852','req-890b5111-062a-438e-a69a-3bbe73a665fe','SHARE','a51b5720-8d25-430a-9757-2e06540ba073','001','008','ERROR','2025-12-04 10:42:45.511697',NULL,'2025-12-04 10:42:48.923038','2df44321-4d07-48c9-907b-a2628b808f08','2026-01-03 10:42:45'),('6dc800b6-746c-429b-981b-e06bfd281e64','e2d34491d1094a9480aa03d0d203a852','req-4e32a941-3090-480e-bbb4-e78d7917aaeb','SHARE','bc39a08c-bd07-4e7f-a89e-4e028e306a5d','001','008','ERROR','2025-12-04 10:43:17.658726',NULL,NULL,'False','2026-01-03 10:43:17'),('76e589f0-625c-4bcf-95fb-1a87ffb7c5fa','e2d34491d1094a9480aa03d0d203a852','req-b546ca2a-bff4-4b01-81c9-f428953a4a6e','SHARE','850b0fc4-18a5-4aa9-bf46-67bcab0819c7','001','008','ERROR','2025-12-04 10:43:09.037163',NULL,NULL,'False','2026-01-03 10:43:09'),('7f97ed44-c602-4f6e-8caa-1b4a89b272a5','e2d34491d1094a9480aa03d0d203a852','req-71c201ca-b22f-4bf2-9884-c6c65e951f43','SHARE','c493aaf0-71d0-4aa8-ab0a-56dba312b5e1','001','008','ERROR','2025-12-04 10:43:05.489223',NULL,NULL,'False','2026-01-03 10:43:05'),('90e437a6-d86c-4a30-9aa5-6baedd671bc2','e2d34491d1094a9480aa03d0d203a852','req-debdc621-5175-4e26-b537-39bd092ebced','SHARE','a654aa17-07c6-4343-ad06-34841716aced','001','008','ERROR','2025-12-04 10:43:21.797101',NULL,'2025-12-04 10:43:25.078455','90e437a6-d86c-4a30-9aa5-6baedd671bc2','2026-01-03 10:43:21'),('95f86d47-c1ae-450e-bf51-fb7474edf2d2','e2d34491d1094a9480aa03d0d203a852','req-de07a931-39d7-4ac7-ab53-7b13afaaff1a','SHARE','f802df4a-4841-44d6-885d-f5daf8f6bbe9','001','008','ERROR','2025-12-04 10:42:49.769825',NULL,NULL,'False','2026-01-03 10:42:49'),('a089cc16-505d-44f7-9935-77b9fcc433ef','54f365c11f8e40988b5a964504f91dd7','req-5451ab04-1655-451b-9663-0420e8833ac9','SHARE','3d37a571-abf6-466d-bed4-9732cbd34327','001','008','ERROR','2025-12-04 10:41:08.564439',NULL,NULL,'False','2026-01-03 10:41:08'),('a163de19-7f28-41e6-b8ed-703ee27f377f','e2d34491d1094a9480aa03d0d203a852','req-6d4255ae-6bd6-49ea-acf7-17aa339a5a6f','SHARE','406666a0-eb51-4632-8678-5b370b2d0962','001','008','ERROR','2025-12-04 10:43:01.889793',NULL,NULL,'False','2026-01-03 10:43:01'),('b489218c-b442-44d2-89c7-5dcab9a45159','e2d34491d1094a9480aa03d0d203a852','req-2c1d162d-c16f-489f-9f0a-fd631492208e','SHARE','a96491cf-ee64-4106-a162-8e6498f8325c','001','008','ERROR','2025-12-04 10:43:13.865535',NULL,NULL,'False','2026-01-03 10:43:13'),('b5869fe8-06f8-4ccb-9862-aeb3e3201adc','d831ca1755a740e7819c02d320ecd2a0','req-a9fb0c0b-bae8-4d05-bf85-aa77ecdfde2f','SHARE','51f18aea-3533-4ddd-9c2c-1452cdefca48','010','020','ERROR','2025-12-04 10:44:06.454148',NULL,NULL,'False','2026-01-03 10:44:06'),('c27afaa5-cd37-4750-9ca4-a0454e8b1dce','54f365c11f8e40988b5a964504f91dd7','req-253c5e50-cf6c-432e-a799-3a7e8d955cf7','SHARE','4a9b5b7f-52fb-4050-b6e1-34454246ed23','001','008','ERROR','2025-12-04 10:41:04.150746',NULL,NULL,'False','2026-01-03 10:41:04'),('ef480b05-fe18-4c9e-a008-cdf798099c75','e2d34491d1094a9480aa03d0d203a852','req-fd37740a-821c-4678-b559-fe6e5e1a592d','SHARE','50f6ffa5-e4d1-4eae-a0e2-fe753a678f28','001','008','ERROR','2025-12-04 10:42:57.601777',NULL,NULL,'False','2026-01-03 10:42:57'),('f6b50ecc-2078-4ebe-ae24-72e1f81726ec','e2d34491d1094a9480aa03d0d203a852','req-92782e7b-e84e-470c-93ad-edea2e8f2c27','SHARE','665b6605-004e-418d-b53a-1f17b68f6116','001','008','ERROR','2025-12-04 10:42:53.878969',NULL,NULL,'False','2026-01-03 10:42:53');
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `network_allocations`
--

DROP TABLE IF EXISTS `network_allocations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `network_allocations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ip_address` varchar(64) DEFAULT NULL,
  `mac_address` varchar(32) DEFAULT NULL,
  `share_server_id` varchar(36) NOT NULL,
  `label` varchar(255) DEFAULT 'user',
  `network_type` varchar(32) DEFAULT NULL,
  `segmentation_id` int(11) DEFAULT NULL,
  `ip_version` int(11) DEFAULT NULL,
  `cidr` varchar(64) DEFAULT NULL,
  `gateway` varchar(64) DEFAULT NULL,
  `mtu` int(11) DEFAULT NULL,
  `share_network_subnet_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_server_id` (`share_server_id`),
  KEY `fk_network_allocation_subnet_id_share_network_subnets` (`share_network_subnet_id`),
  CONSTRAINT `fk_network_allocation_subnet_id_share_network_subnets` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`),
  CONSTRAINT `network_allocations_ibfk_1` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `network_allocations`
--

LOCK TABLES `network_allocations` WRITE;
/*!40000 ALTER TABLE `network_allocations` DISABLE KEYS */;
/*!40000 ALTER TABLE `network_allocations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_share_type_quotas`
--

DROP TABLE IF EXISTS `project_share_type_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_share_type_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uc_quotas_per_share_types` (`share_type_id`,`resource`,`deleted`,`project_id`),
  CONSTRAINT `share_type_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_share_type_quotas`
--

LOCK TABLES `project_share_type_quotas` WRITE;
/*!40000 ALTER TABLE `project_share_type_quotas` DISABLE KEYS */;
INSERT INTO `project_share_type_quotas` (`id`, `project_id`, `resource`, `hard_limit`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_type_id`) VALUES (1,'bc4567fbe8fa43ebb22d7433659a15be','shares',2,'2025-12-04 10:39:53.812328',NULL,'2025-12-04 10:40:28.121069',1,'fbfa7e24-ec90-46ae-a6e9-92f64f43ac9c'),(2,'bc4567fbe8fa43ebb22d7433659a15be','gigabytes',4,'2025-12-04 10:39:53.823561',NULL,'2025-12-04 10:40:28.121069',2,'fbfa7e24-ec90-46ae-a6e9-92f64f43ac9c'),(3,'bc4567fbe8fa43ebb22d7433659a15be','shares',2,'2025-12-04 10:39:54.008785',NULL,'2025-12-04 10:40:27.987130',3,'110b6a77-eee0-4f8c-ab3d-25dd7aa6b52e'),(4,'bc4567fbe8fa43ebb22d7433659a15be','gigabytes',4,'2025-12-04 10:39:54.014236',NULL,'2025-12-04 10:40:27.987130',4,'110b6a77-eee0-4f8c-ab3d-25dd7aa6b52e'),(5,'bc4567fbe8fa43ebb22d7433659a15be','shares',53,'2025-12-04 10:40:10.473547',NULL,'2025-12-04 10:40:11.000106',5,'191e27b4-5709-4076-ad79-3de540ef30e0'),(6,'bc4567fbe8fa43ebb22d7433659a15be','snapshots',53,'2025-12-04 10:40:10.800806',NULL,'2025-12-04 10:40:11.000106',6,'191e27b4-5709-4076-ad79-3de540ef30e0'),(7,'bc4567fbe8fa43ebb22d7433659a15be','gigabytes',1003,'2025-12-04 10:40:10.805596',NULL,'2025-12-04 10:40:11.000106',7,'191e27b4-5709-4076-ad79-3de540ef30e0'),(8,'bc4567fbe8fa43ebb22d7433659a15be','snapshot_gigabytes',1003,'2025-12-04 10:40:10.810505',NULL,'2025-12-04 10:40:11.000106',8,'191e27b4-5709-4076-ad79-3de540ef30e0'),(9,'bc4567fbe8fa43ebb22d7433659a15be','share_replicas',103,'2025-12-04 10:40:10.820187',NULL,'2025-12-04 10:40:11.000106',9,'191e27b4-5709-4076-ad79-3de540ef30e0'),(10,'bc4567fbe8fa43ebb22d7433659a15be','replica_gigabytes',1003,'2025-12-04 10:40:10.827761',NULL,'2025-12-04 10:40:11.000106',10,'191e27b4-5709-4076-ad79-3de540ef30e0'),(11,'bc4567fbe8fa43ebb22d7433659a15be','shares',53,'2025-12-04 10:40:11.982015',NULL,'2025-12-04 10:40:12.301676',11,'9d03fc71-382b-4b0f-aac5-c7ab656d1abd'),(12,'bc4567fbe8fa43ebb22d7433659a15be','snapshots',53,'2025-12-04 10:40:11.987558',NULL,'2025-12-04 10:40:12.301676',12,'9d03fc71-382b-4b0f-aac5-c7ab656d1abd'),(13,'bc4567fbe8fa43ebb22d7433659a15be','gigabytes',1003,'2025-12-04 10:40:11.997852',NULL,'2025-12-04 10:40:12.301676',13,'9d03fc71-382b-4b0f-aac5-c7ab656d1abd'),(14,'bc4567fbe8fa43ebb22d7433659a15be','snapshot_gigabytes',1003,'2025-12-04 10:40:12.075752',NULL,'2025-12-04 10:40:12.301676',14,'9d03fc71-382b-4b0f-aac5-c7ab656d1abd'),(15,'bc4567fbe8fa43ebb22d7433659a15be','share_replicas',103,'2025-12-04 10:40:12.155099',NULL,'2025-12-04 10:40:12.301676',15,'9d03fc71-382b-4b0f-aac5-c7ab656d1abd'),(16,'bc4567fbe8fa43ebb22d7433659a15be','replica_gigabytes',1003,'2025-12-04 10:40:12.159394',NULL,'2025-12-04 10:40:12.301676',16,'9d03fc71-382b-4b0f-aac5-c7ab656d1abd'),(17,'bc4567fbe8fa43ebb22d7433659a15be','shares',12,'2025-12-04 10:40:13.393290',NULL,'2025-12-04 10:40:27.533255',17,'3c12f518-24ec-4873-8189-05dbe084f21b'),(18,'bc4567fbe8fa43ebb22d7433659a15be','shares',49,'2025-12-04 10:40:19.663246',NULL,'2025-12-04 10:40:27.389510',18,'f70b7b0a-e2e8-4f47-b25e-f69f046f57c1'),(19,'bc4567fbe8fa43ebb22d7433659a15be','gigabytes',999,'2025-12-04 10:40:19.785228',NULL,'2025-12-04 10:40:27.389510',19,'f70b7b0a-e2e8-4f47-b25e-f69f046f57c1'),(20,'bc4567fbe8fa43ebb22d7433659a15be','snapshots',49,'2025-12-04 10:40:19.884495',NULL,'2025-12-04 10:40:27.389510',20,'f70b7b0a-e2e8-4f47-b25e-f69f046f57c1'),(21,'bc4567fbe8fa43ebb22d7433659a15be','snapshot_gigabytes',999,'2025-12-04 10:40:20.033529',NULL,'2025-12-04 10:40:27.389510',21,'f70b7b0a-e2e8-4f47-b25e-f69f046f57c1'),(22,'bc4567fbe8fa43ebb22d7433659a15be','share_replicas',99,'2025-12-04 10:40:20.152024',NULL,'2025-12-04 10:40:27.389510',22,'f70b7b0a-e2e8-4f47-b25e-f69f046f57c1'),(23,'bc4567fbe8fa43ebb22d7433659a15be','replica_gigabytes',999,'2025-12-04 10:40:20.247404',NULL,'2025-12-04 10:40:27.389510',23,'f70b7b0a-e2e8-4f47-b25e-f69f046f57c1'),(24,'bc4567fbe8fa43ebb22d7433659a15be','shares',49,'2025-12-04 10:40:20.795735',NULL,'2025-12-04 10:40:27.240611',24,'4d4d71bc-9313-442c-b9a8-0ef05a123c28'),(25,'bc4567fbe8fa43ebb22d7433659a15be','gigabytes',999,'2025-12-04 10:40:20.911613',NULL,'2025-12-04 10:40:27.240611',25,'4d4d71bc-9313-442c-b9a8-0ef05a123c28'),(26,'bc4567fbe8fa43ebb22d7433659a15be','snapshots',49,'2025-12-04 10:40:21.034164',NULL,'2025-12-04 10:40:27.240611',26,'4d4d71bc-9313-442c-b9a8-0ef05a123c28'),(27,'bc4567fbe8fa43ebb22d7433659a15be','snapshot_gigabytes',999,'2025-12-04 10:40:21.140609',NULL,'2025-12-04 10:40:27.240611',27,'4d4d71bc-9313-442c-b9a8-0ef05a123c28'),(28,'bc4567fbe8fa43ebb22d7433659a15be','share_replicas',99,'2025-12-04 10:40:21.257812',NULL,'2025-12-04 10:40:27.240611',28,'4d4d71bc-9313-442c-b9a8-0ef05a123c28'),(29,'bc4567fbe8fa43ebb22d7433659a15be','replica_gigabytes',999,'2025-12-04 10:40:21.385813',NULL,'2025-12-04 10:40:27.240611',29,'4d4d71bc-9313-442c-b9a8-0ef05a123c28'),(30,'bc4567fbe8fa43ebb22d7433659a15be','shares',11,'2025-12-04 10:40:21.771073',NULL,'2025-12-04 10:40:27.072634',30,'7f3df988-8170-4466-8fee-f4434cfe05a1'),(31,'bc4567fbe8fa43ebb22d7433659a15be','shares',-1,'2025-12-04 10:40:22.154910',NULL,'2025-12-04 10:40:26.887810',31,'c4aacbb6-42ff-46f7-aea9-dfa997f3eabe');
/*!40000 ALTER TABLE `project_share_type_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_user_quotas`
--

DROP TABLE IF EXISTS `project_user_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_user_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `resource` varchar(25) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_user_quotas`
--

LOCK TABLES `project_user_quotas` WRITE;
/*!40000 ALTER TABLE `project_user_quotas` DISABLE KEYS */;
INSERT INTO `project_user_quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `user_id`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2025-12-04 10:39:53.559944',NULL,'2025-12-04 10:40:09.974490',1,'4450ef386c064ec8865c3f5640993885','bc4567fbe8fa43ebb22d7433659a15be','shares',2),(2,'2025-12-04 10:39:53.564957',NULL,'2025-12-04 10:40:09.974490',2,'4450ef386c064ec8865c3f5640993885','bc4567fbe8fa43ebb22d7433659a15be','gigabytes',7),(3,'2025-12-04 10:40:13.287096',NULL,'2025-12-04 10:40:13.466472',3,'4450ef386c064ec8865c3f5640993885','bc4567fbe8fa43ebb22d7433659a15be','shares',11),(4,'2025-12-04 10:40:15.828456',NULL,'2025-12-04 10:40:16.006851',4,'4450ef386c064ec8865c3f5640993885','bc4567fbe8fa43ebb22d7433659a15be','gigabytes',-1),(5,'2025-12-04 10:40:17.223348',NULL,'2025-12-04 10:40:17.444952',5,'4450ef386c064ec8865c3f5640993885','bc4567fbe8fa43ebb22d7433659a15be','share_replicas',-1),(6,'2025-12-04 10:40:17.570209',NULL,'2025-12-04 10:40:17.849711',6,'4450ef386c064ec8865c3f5640993885','bc4567fbe8fa43ebb22d7433659a15be','replica_gigabytes',-1),(7,'2025-12-04 10:40:18.022823',NULL,'2025-12-04 10:40:18.178225',7,'4450ef386c064ec8865c3f5640993885','bc4567fbe8fa43ebb22d7433659a15be','share_networks',-1),(8,'2025-12-04 10:40:18.285097',NULL,'2025-12-04 10:40:18.500016',8,'4450ef386c064ec8865c3f5640993885','bc4567fbe8fa43ebb22d7433659a15be','shares',-1),(9,'2025-12-04 10:40:18.762665',NULL,'2025-12-04 10:40:18.910205',9,'4450ef386c064ec8865c3f5640993885','bc4567fbe8fa43ebb22d7433659a15be','snapshot_gigabytes',-1),(10,'2025-12-04 10:40:19.041225',NULL,'2025-12-04 10:40:19.393788',10,'4450ef386c064ec8865c3f5640993885','bc4567fbe8fa43ebb22d7433659a15be','snapshots',-1),(11,'2025-12-04 10:40:23.500233',NULL,'2025-12-04 10:40:23.597031',11,'4450ef386c064ec8865c3f5640993885','bc4567fbe8fa43ebb22d7433659a15be','gigabytes',999),(12,'2025-12-04 10:40:24.043321',NULL,'2025-12-04 10:40:24.114157',12,'4450ef386c064ec8865c3f5640993885','bc4567fbe8fa43ebb22d7433659a15be','share_replicas',99),(13,'2025-12-04 10:40:24.530388',NULL,'2025-12-04 10:40:24.612985',13,'4450ef386c064ec8865c3f5640993885','bc4567fbe8fa43ebb22d7433659a15be','replica_gigabytes',999),(14,'2025-12-04 10:40:24.797188',NULL,'2025-12-04 10:40:24.863903',14,'4450ef386c064ec8865c3f5640993885','bc4567fbe8fa43ebb22d7433659a15be','share_networks',9),(15,'2025-12-04 10:40:25.058640',NULL,'2025-12-04 10:40:25.124485',15,'4450ef386c064ec8865c3f5640993885','bc4567fbe8fa43ebb22d7433659a15be','shares',49),(16,'2025-12-04 10:40:25.326430',NULL,'2025-12-04 10:40:25.421631',16,'4450ef386c064ec8865c3f5640993885','bc4567fbe8fa43ebb22d7433659a15be','snapshot_gigabytes',999),(17,'2025-12-04 10:40:25.657894',NULL,'2025-12-04 10:40:25.745771',17,'4450ef386c064ec8865c3f5640993885','bc4567fbe8fa43ebb22d7433659a15be','snapshots',49),(18,'2025-12-04 10:40:26.005015',NULL,'2025-12-04 10:40:26.098798',18,'4450ef386c064ec8865c3f5640993885','bc4567fbe8fa43ebb22d7433659a15be','shares',11),(19,'2025-12-04 10:40:26.419063',NULL,'2025-12-04 10:40:26.726303',19,'4450ef386c064ec8865c3f5640993885','bc4567fbe8fa43ebb22d7433659a15be','shares',-1);
/*!40000 ALTER TABLE `project_user_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_usages_project_id` (`project_id`)
) ENGINE=InnoDB AUTO_INCREMENT=270 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `share_type_id`) VALUES ('2025-12-04 10:39:12.212822','2025-12-04 10:40:39.793617',NULL,0,1,'d2380cdaae7840a7aa1016a0c2242ad2','30e995746f0346cc925a4e4d291b4b4b','shares',0,0,NULL,NULL),('2025-12-04 10:39:12.217996','2025-12-04 10:40:39.793621',NULL,0,2,'d2380cdaae7840a7aa1016a0c2242ad2','30e995746f0346cc925a4e4d291b4b4b','gigabytes',0,0,NULL,NULL),('2025-12-04 10:39:12.234207','2025-12-04 10:40:39.793623','2025-12-04 10:40:42.811036',3,3,NULL,'30e995746f0346cc925a4e4d291b4b4b','shares',0,0,NULL,'e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:12.237433','2025-12-04 10:40:39.793625','2025-12-04 10:40:42.811036',4,4,NULL,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',0,0,NULL,'e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:13.075688','2025-12-04 10:39:26.414550',NULL,0,5,'28d021876b6d47e6bb3cbf1d91fe3cfc','fdf8cc9e5d484c87979d04086aa3299b','gigabytes',0,0,NULL,NULL),('2025-12-04 10:39:13.079683','2025-12-04 10:39:26.414554',NULL,0,6,'28d021876b6d47e6bb3cbf1d91fe3cfc','fdf8cc9e5d484c87979d04086aa3299b','shares',0,0,NULL,NULL),('2025-12-04 10:39:13.095821','2025-12-04 10:39:26.414556','2025-12-04 10:39:29.332475',7,7,NULL,'fdf8cc9e5d484c87979d04086aa3299b','gigabytes',0,0,NULL,'703ba806-b6aa-4733-8c75-4e18892fffb1'),('2025-12-04 10:39:13.099492','2025-12-04 10:39:26.414558','2025-12-04 10:39:29.332475',8,8,NULL,'fdf8cc9e5d484c87979d04086aa3299b','shares',0,0,NULL,'703ba806-b6aa-4733-8c75-4e18892fffb1'),('2025-12-04 10:39:16.749433','2025-12-04 10:39:22.991968',NULL,0,9,'28d021876b6d47e6bb3cbf1d91fe3cfc','fdf8cc9e5d484c87979d04086aa3299b','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-04 10:39:16.752554','2025-12-04 10:39:22.991972',NULL,0,10,'28d021876b6d47e6bb3cbf1d91fe3cfc','fdf8cc9e5d484c87979d04086aa3299b','snapshots',0,0,NULL,NULL),('2025-12-04 10:39:16.762364','2025-12-04 10:39:22.991974','2025-12-04 10:39:29.332475',11,11,NULL,'fdf8cc9e5d484c87979d04086aa3299b','snapshot_gigabytes',0,0,NULL,'703ba806-b6aa-4733-8c75-4e18892fffb1'),('2025-12-04 10:39:16.765478','2025-12-04 10:39:22.991975','2025-12-04 10:39:29.332475',12,12,NULL,'fdf8cc9e5d484c87979d04086aa3299b','snapshots',0,0,NULL,'703ba806-b6aa-4733-8c75-4e18892fffb1'),('2025-12-04 10:39:23.824546','2025-12-04 10:39:23.889220','2025-12-04 10:39:27.504067',13,13,'9382d7467f084a7daaf3852289dd7e55','1a11c9942929435599f0a51c3f690b44','gigabytes',1,0,NULL,NULL),('2025-12-04 10:39:23.830032','2025-12-04 10:39:23.889222','2025-12-04 10:39:27.504067',14,14,'9382d7467f084a7daaf3852289dd7e55','1a11c9942929435599f0a51c3f690b44','shares',1,0,NULL,NULL),('2025-12-04 10:39:23.839745','2025-12-04 10:39:23.889224','2025-12-04 10:39:27.504067',15,15,NULL,'1a11c9942929435599f0a51c3f690b44','gigabytes',1,0,NULL,'f9c9ca5f-6992-4730-8113-73ad975de651'),('2025-12-04 10:39:23.845222','2025-12-04 10:39:23.889225','2025-12-04 10:39:27.504067',16,16,NULL,'1a11c9942929435599f0a51c3f690b44','shares',1,0,NULL,'f9c9ca5f-6992-4730-8113-73ad975de651'),('2025-12-04 10:39:27.722558','2025-12-04 10:39:28.141685','2025-12-04 10:39:35.877907',17,17,'9382d7467f084a7daaf3852289dd7e55','1a11c9942929435599f0a51c3f690b44','gigabytes',2,0,NULL,NULL),('2025-12-04 10:39:27.725468','2025-12-04 10:39:28.141689','2025-12-04 10:39:35.877907',18,18,'9382d7467f084a7daaf3852289dd7e55','1a11c9942929435599f0a51c3f690b44','shares',2,0,NULL,NULL),('2025-12-04 10:39:28.110914','2025-12-04 10:39:28.141690','2025-12-04 10:39:35.877907',19,19,NULL,'1a11c9942929435599f0a51c3f690b44','gigabytes',1,0,NULL,'fad6562a-6c8b-4475-a01e-8a7d1d4a728b'),('2025-12-04 10:39:28.115316','2025-12-04 10:39:28.141692','2025-12-04 10:39:35.877907',20,20,NULL,'1a11c9942929435599f0a51c3f690b44','shares',1,0,NULL,'fad6562a-6c8b-4475-a01e-8a7d1d4a728b'),('2025-12-04 10:39:28.206215','2025-12-04 10:39:34.467151',NULL,0,21,'9565e2931ca045c2aff04912e5c4ba5b','a0e02e0e62364d9a86c7e7040e755187','gigabytes',0,0,NULL,NULL),('2025-12-04 10:39:28.208804','2025-12-04 10:39:34.467157',NULL,0,22,'9565e2931ca045c2aff04912e5c4ba5b','a0e02e0e62364d9a86c7e7040e755187','shares',0,0,NULL,NULL),('2025-12-04 10:39:28.219874','2025-12-04 10:39:34.467159','2025-12-04 10:39:37.282582',23,23,NULL,'a0e02e0e62364d9a86c7e7040e755187','gigabytes',0,0,NULL,'c8b2d54e-9dae-4635-aff6-dcbbe64d4236'),('2025-12-04 10:39:28.222771','2025-12-04 10:39:34.467160','2025-12-04 10:39:37.282582',24,24,NULL,'a0e02e0e62364d9a86c7e7040e755187','shares',0,0,NULL,'c8b2d54e-9dae-4635-aff6-dcbbe64d4236'),('2025-12-04 10:39:31.737508','2025-12-04 10:39:31.912279','2025-12-04 10:39:35.877907',25,25,'9382d7467f084a7daaf3852289dd7e55','1a11c9942929435599f0a51c3f690b44','snapshots',1,0,NULL,NULL),('2025-12-04 10:39:31.740665','2025-12-04 10:39:31.912282','2025-12-04 10:39:35.877907',26,26,'9382d7467f084a7daaf3852289dd7e55','1a11c9942929435599f0a51c3f690b44','snapshot_gigabytes',1,0,NULL,NULL),('2025-12-04 10:39:31.761389','2025-12-04 10:39:31.912283','2025-12-04 10:39:35.877907',27,27,NULL,'1a11c9942929435599f0a51c3f690b44','snapshots',1,0,NULL,'fad6562a-6c8b-4475-a01e-8a7d1d4a728b'),('2025-12-04 10:39:31.766089','2025-12-04 10:39:31.912285','2025-12-04 10:39:35.877907',28,28,NULL,'1a11c9942929435599f0a51c3f690b44','snapshot_gigabytes',1,0,NULL,'fad6562a-6c8b-4475-a01e-8a7d1d4a728b'),('2025-12-04 10:39:50.360997','2025-12-04 10:40:35.688702',NULL,0,29,'d2380cdaae7840a7aa1016a0c2242ad2','30e995746f0346cc925a4e4d291b4b4b','snapshots',0,0,NULL,NULL),('2025-12-04 10:39:50.364250','2025-12-04 10:40:35.688706',NULL,0,30,'d2380cdaae7840a7aa1016a0c2242ad2','30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-04 10:39:50.379139','2025-12-04 10:40:35.688708','2025-12-04 10:40:42.811036',31,31,NULL,'30e995746f0346cc925a4e4d291b4b4b','snapshots',0,0,NULL,'e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:50.383075','2025-12-04 10:40:35.688709','2025-12-04 10:40:42.811036',32,32,NULL,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',0,0,NULL,'e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:50.637943','2025-12-04 10:39:54.037539',NULL,0,33,'30def06ddfcb4491be841cb17e5f182e','246f1169a6af4a34902c2aa68c00782b','share_networks',0,0,NULL,NULL),('2025-12-04 10:39:51.241102','2025-12-04 10:39:51.292676',NULL,0,34,'045d5e64586a450cb2f94b31c74861bb','05c8461a124b4addbb681e5898e482e5','share_networks',1,0,NULL,NULL),('2025-12-04 10:39:51.589599','2025-12-04 10:39:51.646458',NULL,0,35,'9382d7467f084a7daaf3852289dd7e55','1a11c9942929435599f0a51c3f690b44','snapshots',-1,0,NULL,NULL),('2025-12-04 10:39:51.597590','2025-12-04 10:39:51.646462',NULL,0,36,'9382d7467f084a7daaf3852289dd7e55','1a11c9942929435599f0a51c3f690b44','snapshot_gigabytes',-1,0,NULL,NULL),('2025-12-04 10:39:51.614730','2025-12-04 10:39:51.646464','2025-12-04 10:39:58.304336',37,37,NULL,'1a11c9942929435599f0a51c3f690b44','snapshots',-1,0,NULL,'fad6562a-6c8b-4475-a01e-8a7d1d4a728b'),('2025-12-04 10:39:51.619595','2025-12-04 10:39:51.646465','2025-12-04 10:39:58.304336',38,38,NULL,'1a11c9942929435599f0a51c3f690b44','snapshot_gigabytes',-1,0,NULL,'fad6562a-6c8b-4475-a01e-8a7d1d4a728b'),('2025-12-04 10:39:54.151407','2025-12-04 10:40:06.217343','2025-12-04 10:40:09.977234',39,39,'4450ef386c064ec8865c3f5640993885','bc4567fbe8fa43ebb22d7433659a15be','gigabytes',0,0,NULL,NULL),('2025-12-04 10:39:54.155401','2025-12-04 10:40:06.217345','2025-12-04 10:40:09.977234',40,40,'4450ef386c064ec8865c3f5640993885','bc4567fbe8fa43ebb22d7433659a15be','shares',0,0,NULL,NULL),('2025-12-04 10:39:54.165732','2025-12-04 10:40:02.674273','2025-12-04 10:40:10.109841',41,41,NULL,'bc4567fbe8fa43ebb22d7433659a15be','gigabytes',0,0,NULL,'fbfa7e24-ec90-46ae-a6e9-92f64f43ac9c'),('2025-12-04 10:39:54.167785','2025-12-04 10:40:02.674274','2025-12-04 10:40:10.109841',42,42,NULL,'bc4567fbe8fa43ebb22d7433659a15be','shares',0,0,NULL,'fbfa7e24-ec90-46ae-a6e9-92f64f43ac9c'),('2025-12-04 10:39:55.139151','2025-12-04 10:39:58.850229',NULL,0,43,'9382d7467f084a7daaf3852289dd7e55','1a11c9942929435599f0a51c3f690b44','shares',0,0,NULL,NULL),('2025-12-04 10:39:55.145358','2025-12-04 10:39:58.850232',NULL,0,44,'9382d7467f084a7daaf3852289dd7e55','1a11c9942929435599f0a51c3f690b44','gigabytes',0,0,NULL,NULL),('2025-12-04 10:39:55.163310','2025-12-04 10:39:55.187632','2025-12-04 10:39:58.304336',45,45,NULL,'1a11c9942929435599f0a51c3f690b44','shares',0,0,NULL,'fad6562a-6c8b-4475-a01e-8a7d1d4a728b'),('2025-12-04 10:39:55.169564','2025-12-04 10:39:55.187633','2025-12-04 10:39:58.304336',46,46,NULL,'1a11c9942929435599f0a51c3f690b44','gigabytes',0,0,NULL,'fad6562a-6c8b-4475-a01e-8a7d1d4a728b'),('2025-12-04 10:39:57.917863','2025-12-04 10:40:06.217347','2025-12-04 10:40:10.109841',47,47,NULL,'bc4567fbe8fa43ebb22d7433659a15be','shares',0,0,NULL,'110b6a77-eee0-4f8c-ab3d-25dd7aa6b52e'),('2025-12-04 10:39:57.922556','2025-12-04 10:40:06.217348','2025-12-04 10:40:10.109841',48,48,NULL,'bc4567fbe8fa43ebb22d7433659a15be','gigabytes',0,0,NULL,'110b6a77-eee0-4f8c-ab3d-25dd7aa6b52e'),('2025-12-04 10:39:58.832178','2025-12-04 10:39:58.850233','2025-12-04 10:40:02.252777',49,49,NULL,'1a11c9942929435599f0a51c3f690b44','shares',0,0,NULL,'f9c9ca5f-6992-4730-8113-73ad975de651'),('2025-12-04 10:39:58.835734','2025-12-04 10:39:58.850234','2025-12-04 10:40:02.252777',50,50,NULL,'1a11c9942929435599f0a51c3f690b44','gigabytes',0,0,NULL,'f9c9ca5f-6992-4730-8113-73ad975de651'),('2025-12-04 10:40:06.494834','2025-12-04 10:40:11.234659',NULL,0,51,'b0b74817f28a40638632c34de45c4b3a','ee36120fd1ef45478778db2f213d6c09','shares',0,0,NULL,NULL),('2025-12-04 10:40:06.497186','2025-12-04 10:40:11.234662',NULL,0,52,'b0b74817f28a40638632c34de45c4b3a','ee36120fd1ef45478778db2f213d6c09','gigabytes',0,0,NULL,NULL),('2025-12-04 10:40:06.510690','2025-12-04 10:40:11.234663','2025-12-04 10:40:14.132782',53,53,NULL,'ee36120fd1ef45478778db2f213d6c09','shares',0,0,NULL,'fbcd210b-f4b4-4f9a-b567-b1dd820eb42f'),('2025-12-04 10:40:06.513272','2025-12-04 10:40:11.234665','2025-12-04 10:40:14.132782',54,54,NULL,'ee36120fd1ef45478778db2f213d6c09','gigabytes',0,0,NULL,'fbcd210b-f4b4-4f9a-b567-b1dd820eb42f'),('2025-12-04 10:40:12.501618','2025-12-04 10:40:35.318669',NULL,0,55,'74c4687e9ade4a6382ce5c54f9bae971','45b18e29190f4379945421b01e7eb293','gigabytes',0,0,NULL,NULL),('2025-12-04 10:40:12.507803','2025-12-04 10:40:35.318673',NULL,0,56,'74c4687e9ade4a6382ce5c54f9bae971','45b18e29190f4379945421b01e7eb293','shares',0,0,NULL,NULL),('2025-12-04 10:40:12.524671','2025-12-04 10:40:35.318675','2025-12-04 10:40:38.551016',57,57,NULL,'45b18e29190f4379945421b01e7eb293','gigabytes',0,0,NULL,'4d11d944-cb21-4896-a25f-1f1bffe11b97'),('2025-12-04 10:40:12.527813','2025-12-04 10:40:35.318677','2025-12-04 10:40:38.551016',58,58,NULL,'45b18e29190f4379945421b01e7eb293','shares',0,0,NULL,'4d11d944-cb21-4896-a25f-1f1bffe11b97'),('2025-12-04 10:40:16.067496','2025-12-04 10:40:31.755945',NULL,0,59,'74c4687e9ade4a6382ce5c54f9bae971','45b18e29190f4379945421b01e7eb293','snapshots',0,0,NULL,NULL),('2025-12-04 10:40:16.072266','2025-12-04 10:40:31.755948',NULL,0,60,'74c4687e9ade4a6382ce5c54f9bae971','45b18e29190f4379945421b01e7eb293','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-04 10:40:17.137469','2025-12-04 10:40:31.755950','2025-12-04 10:40:38.551016',61,61,NULL,'45b18e29190f4379945421b01e7eb293','snapshots',0,0,NULL,'4d11d944-cb21-4896-a25f-1f1bffe11b97'),('2025-12-04 10:40:17.142830','2025-12-04 10:40:31.755951','2025-12-04 10:40:38.551016',62,62,NULL,'45b18e29190f4379945421b01e7eb293','snapshot_gigabytes',0,0,NULL,'4d11d944-cb21-4896-a25f-1f1bffe11b97'),('2025-12-04 10:40:19.831902','2025-12-04 10:40:39.637235',NULL,0,63,'a8ce0e9c3b1244659a5746807a574b35','421364ebc3e041b392bf764a127cfda4','gigabytes',0,0,NULL,NULL),('2025-12-04 10:40:19.834157','2025-12-04 10:40:39.637238',NULL,0,64,'a8ce0e9c3b1244659a5746807a574b35','421364ebc3e041b392bf764a127cfda4','shares',0,0,NULL,NULL),('2025-12-04 10:40:19.843577','2025-12-04 10:40:39.637239','2025-12-04 10:40:42.618022',65,65,NULL,'421364ebc3e041b392bf764a127cfda4','gigabytes',0,0,NULL,'9d536774-c83d-47c8-953e-f319caf6de44'),('2025-12-04 10:40:19.846351','2025-12-04 10:40:39.637240','2025-12-04 10:40:42.618022',66,66,NULL,'421364ebc3e041b392bf764a127cfda4','shares',0,0,NULL,'9d536774-c83d-47c8-953e-f319caf6de44'),('2025-12-04 10:40:23.345348','2025-12-04 10:40:35.834237',NULL,0,67,'a8ce0e9c3b1244659a5746807a574b35','421364ebc3e041b392bf764a127cfda4','snapshots',0,0,NULL,NULL),('2025-12-04 10:40:23.350487','2025-12-04 10:40:35.834240',NULL,0,68,'a8ce0e9c3b1244659a5746807a574b35','421364ebc3e041b392bf764a127cfda4','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-04 10:40:23.363412','2025-12-04 10:40:35.834242','2025-12-04 10:40:42.618022',69,69,NULL,'421364ebc3e041b392bf764a127cfda4','snapshots',0,0,NULL,'9d536774-c83d-47c8-953e-f319caf6de44'),('2025-12-04 10:40:23.366183','2025-12-04 10:40:35.834243','2025-12-04 10:40:42.618022',70,70,NULL,'421364ebc3e041b392bf764a127cfda4','snapshot_gigabytes',0,0,NULL,'9d536774-c83d-47c8-953e-f319caf6de44'),('2025-12-04 10:40:38.770561','2025-12-04 10:40:45.935589',NULL,0,71,'432be7864c2d41508547058364b0ef80','2b21e3f6c24d4eb39e6fedb5f78ec003','gigabytes',0,0,NULL,NULL),('2025-12-04 10:40:38.775597','2025-12-04 10:40:45.935594',NULL,0,72,'432be7864c2d41508547058364b0ef80','2b21e3f6c24d4eb39e6fedb5f78ec003','shares',0,0,NULL,NULL),('2025-12-04 10:40:38.785853','2025-12-04 10:40:45.935596','2025-12-04 10:40:49.293346',73,73,NULL,'2b21e3f6c24d4eb39e6fedb5f78ec003','gigabytes',0,0,NULL,'f246ccbd-b6cd-4308-8680-879f81fe8e7d'),('2025-12-04 10:40:38.788333','2025-12-04 10:40:45.935597','2025-12-04 10:40:49.293346',74,74,NULL,'2b21e3f6c24d4eb39e6fedb5f78ec003','shares',0,0,NULL,'f246ccbd-b6cd-4308-8680-879f81fe8e7d'),('2025-12-04 10:40:50.963041','2025-12-04 10:41:12.082742',NULL,0,75,'b5d23f7e91694629931517a6c40efbe5','54f365c11f8e40988b5a964504f91dd7','gigabytes',0,0,NULL,NULL),('2025-12-04 10:40:50.966281','2025-12-04 10:41:12.082746',NULL,0,76,'b5d23f7e91694629931517a6c40efbe5','54f365c11f8e40988b5a964504f91dd7','shares',0,0,NULL,NULL),('2025-12-04 10:40:51.001306','2025-12-04 10:40:54.990291','2025-12-04 10:41:13.535665',77,77,NULL,'54f365c11f8e40988b5a964504f91dd7','gigabytes',0,0,NULL,'d06feb78-408f-46b2-96af-3dfde13231d8'),('2025-12-04 10:40:51.003371','2025-12-04 10:40:54.990292','2025-12-04 10:41:13.535665',78,78,NULL,'54f365c11f8e40988b5a964504f91dd7','shares',0,0,NULL,'d06feb78-408f-46b2-96af-3dfde13231d8'),('2025-12-04 10:40:51.357605','2025-12-04 10:40:58.548541',NULL,0,79,'d62cbbb064cd4277b18c062e7f02e202','f6c223a076bd42bd958c3294b89dc763','shares',0,0,NULL,NULL),('2025-12-04 10:40:51.359339','2025-12-04 10:40:58.548545',NULL,0,80,'d62cbbb064cd4277b18c062e7f02e202','f6c223a076bd42bd958c3294b89dc763','gigabytes',0,0,NULL,NULL),('2025-12-04 10:40:51.373747','2025-12-04 10:40:58.548547','2025-12-04 10:41:01.741824',81,81,NULL,'f6c223a076bd42bd958c3294b89dc763','shares',0,0,NULL,'3d827517-5ff1-48c1-8133-89cd1d41e9bd'),('2025-12-04 10:40:51.376908','2025-12-04 10:40:58.548549','2025-12-04 10:41:01.741824',82,82,NULL,'f6c223a076bd42bd958c3294b89dc763','gigabytes',0,0,NULL,'3d827517-5ff1-48c1-8133-89cd1d41e9bd'),('2025-12-04 10:40:54.153561','2025-12-04 10:41:13.821838',NULL,0,83,'346d2a3ba5e24df2a1417033f75e866e','de70f6413fb248c6a07e498350f7a8e3','gigabytes',0,0,NULL,NULL),('2025-12-04 10:40:54.155410','2025-12-04 10:41:13.821841',NULL,0,84,'346d2a3ba5e24df2a1417033f75e866e','de70f6413fb248c6a07e498350f7a8e3','shares',0,0,NULL,NULL),('2025-12-04 10:40:54.203170','2025-12-04 10:41:13.821842','2025-12-04 10:41:16.848295',85,85,NULL,'de70f6413fb248c6a07e498350f7a8e3','gigabytes',0,0,NULL,'ec0655e6-90b3-4d12-b523-1f54eacdc7a3'),('2025-12-04 10:40:54.205426','2025-12-04 10:41:13.821843','2025-12-04 10:41:16.848295',86,86,NULL,'de70f6413fb248c6a07e498350f7a8e3','shares',0,0,NULL,'ec0655e6-90b3-4d12-b523-1f54eacdc7a3'),('2025-12-04 10:40:55.366268','2025-12-04 10:40:59.221846','2025-12-04 10:41:13.358026',87,87,NULL,'54f365c11f8e40988b5a964504f91dd7','gigabytes',0,0,NULL,'37563d7b-fcdb-4c5f-b9db-cf6680a53c05'),('2025-12-04 10:40:55.368277','2025-12-04 10:40:59.221848','2025-12-04 10:41:13.358026',88,88,NULL,'54f365c11f8e40988b5a964504f91dd7','shares',0,0,NULL,'37563d7b-fcdb-4c5f-b9db-cf6680a53c05'),('2025-12-04 10:40:59.558707','2025-12-04 10:41:03.609275','2025-12-04 10:41:13.180804',89,89,NULL,'54f365c11f8e40988b5a964504f91dd7','gigabytes',0,0,NULL,'329c3d8c-f588-46f8-a798-2f52b3017ff1'),('2025-12-04 10:40:59.560621','2025-12-04 10:41:03.609276','2025-12-04 10:41:13.180804',90,90,NULL,'54f365c11f8e40988b5a964504f91dd7','shares',0,0,NULL,'329c3d8c-f588-46f8-a798-2f52b3017ff1'),('2025-12-04 10:41:03.987407','2025-12-04 10:41:07.953486','2025-12-04 10:41:13.050200',91,91,NULL,'54f365c11f8e40988b5a964504f91dd7','shares',0,0,NULL,'010affb4-16b3-42ed-a4b9-506eedbbafdf'),('2025-12-04 10:41:03.991138','2025-12-04 10:41:07.953488','2025-12-04 10:41:13.050200',92,92,NULL,'54f365c11f8e40988b5a964504f91dd7','gigabytes',0,0,NULL,'010affb4-16b3-42ed-a4b9-506eedbbafdf'),('2025-12-04 10:41:08.359180','2025-12-04 10:41:12.082748','2025-12-04 10:41:12.800541',93,93,NULL,'54f365c11f8e40988b5a964504f91dd7','gigabytes',0,0,NULL,'9327d215-d4cc-4d4f-9783-f891100659fa'),('2025-12-04 10:41:08.361636','2025-12-04 10:41:12.082749','2025-12-04 10:41:12.800541',94,94,NULL,'54f365c11f8e40988b5a964504f91dd7','shares',0,0,NULL,'9327d215-d4cc-4d4f-9783-f891100659fa'),('2025-12-04 10:41:12.582381','2025-12-04 10:42:04.903596',NULL,0,95,'956c2a2425364bc58a945afb8a16635a','91320ee163cc40bc8f5c820635954e8f','gigabytes',0,0,NULL,NULL),('2025-12-04 10:41:12.584804','2025-12-04 10:42:04.903598',NULL,0,96,'956c2a2425364bc58a945afb8a16635a','91320ee163cc40bc8f5c820635954e8f','shares',0,0,NULL,NULL),('2025-12-04 10:41:12.614321','2025-12-04 10:42:04.903600','2025-12-04 10:42:08.063004',97,97,NULL,'91320ee163cc40bc8f5c820635954e8f','gigabytes',0,0,NULL,'0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:41:12.617505','2025-12-04 10:42:04.903601','2025-12-04 10:42:08.063004',98,98,NULL,'91320ee163cc40bc8f5c820635954e8f','shares',0,0,NULL,'0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:41:30.874694','2025-12-04 10:41:36.210008',NULL,0,99,'7da578f357d044d590ceb21b50653ba9','209828455d3a419389bb0a731fac0513','shares',0,0,NULL,NULL),('2025-12-04 10:41:30.876524','2025-12-04 10:41:36.210012',NULL,0,100,'7da578f357d044d590ceb21b50653ba9','209828455d3a419389bb0a731fac0513','gigabytes',0,0,NULL,NULL),('2025-12-04 10:41:30.884763','2025-12-04 10:41:36.210014','2025-12-04 10:41:39.446484',101,101,NULL,'209828455d3a419389bb0a731fac0513','shares',0,0,NULL,'2b8fd021-e19e-4963-9125-9f006d6d6090'),('2025-12-04 10:41:30.886587','2025-12-04 10:41:36.210016','2025-12-04 10:41:39.446484',102,102,NULL,'209828455d3a419389bb0a731fac0513','gigabytes',0,0,NULL,'2b8fd021-e19e-4963-9125-9f006d6d6090'),('2025-12-04 10:41:50.460855','2025-12-04 10:41:56.461237',NULL,0,103,'ebdbce19c170478db5c1f470f4d9bb47','ecc97bc6bfe546b6b2d42d386bafab9c','gigabytes',0,0,NULL,NULL),('2025-12-04 10:41:50.462809','2025-12-04 10:41:56.461240',NULL,0,104,'ebdbce19c170478db5c1f470f4d9bb47','ecc97bc6bfe546b6b2d42d386bafab9c','shares',0,0,NULL,NULL),('2025-12-04 10:41:50.470749','2025-12-04 10:41:56.461241','2025-12-04 10:41:59.590015',105,105,NULL,'ecc97bc6bfe546b6b2d42d386bafab9c','gigabytes',0,0,NULL,'2537e953-bb9f-4f01-aa9d-2ca546adc331'),('2025-12-04 10:41:50.472674','2025-12-04 10:41:56.461242','2025-12-04 10:41:59.590015',106,106,NULL,'ecc97bc6bfe546b6b2d42d386bafab9c','shares',0,0,NULL,'2537e953-bb9f-4f01-aa9d-2ca546adc331'),('2025-12-04 10:41:52.800593','2025-12-04 10:42:01.010243',NULL,0,107,'de759a3ec81642cd83d621173ab2bdb2','f409515d619a495bb7f5f1af15f8324a','gigabytes',0,0,NULL,NULL),('2025-12-04 10:41:52.803260','2025-12-04 10:42:01.010246',NULL,0,108,'de759a3ec81642cd83d621173ab2bdb2','f409515d619a495bb7f5f1af15f8324a','shares',0,0,NULL,NULL),('2025-12-04 10:41:52.818111','2025-12-04 10:42:01.010248','2025-12-04 10:42:11.776283',109,109,NULL,'f409515d619a495bb7f5f1af15f8324a','gigabytes',0,0,NULL,'e97a3463-125a-45ea-9b75-73d586ae1dd9'),('2025-12-04 10:41:52.821533','2025-12-04 10:42:01.010250','2025-12-04 10:42:11.776283',110,110,NULL,'f409515d619a495bb7f5f1af15f8324a','shares',0,0,NULL,'e97a3463-125a-45ea-9b75-73d586ae1dd9'),('2025-12-04 10:41:53.280221','2025-12-04 10:42:08.323053',NULL,0,111,'507c8db7b2164bd98f5556ae52f72fd0','829c39a80695492b897dbe32bb2a565c','shares',0,0,NULL,NULL),('2025-12-04 10:41:53.282111','2025-12-04 10:42:08.323056',NULL,0,112,'507c8db7b2164bd98f5556ae52f72fd0','829c39a80695492b897dbe32bb2a565c','gigabytes',0,0,NULL,NULL),('2025-12-04 10:41:53.292500','2025-12-04 10:42:08.323058','2025-12-04 10:42:11.776283',113,113,NULL,'829c39a80695492b897dbe32bb2a565c','shares',0,0,NULL,'e97a3463-125a-45ea-9b75-73d586ae1dd9'),('2025-12-04 10:41:53.296170','2025-12-04 10:42:08.323059','2025-12-04 10:42:11.776283',114,114,NULL,'829c39a80695492b897dbe32bb2a565c','gigabytes',0,0,NULL,'e97a3463-125a-45ea-9b75-73d586ae1dd9'),('2025-12-04 10:41:59.573426','2025-12-04 10:42:11.382782',NULL,0,115,'88e5a16daca84b4896b3a4ca2f314a8b','ae2330f34cee47599e079667ef8df8bd','gigabytes',0,0,NULL,NULL),('2025-12-04 10:41:59.576638','2025-12-04 10:42:11.382785',NULL,0,116,'88e5a16daca84b4896b3a4ca2f314a8b','ae2330f34cee47599e079667ef8df8bd','shares',0,0,NULL,NULL),('2025-12-04 10:41:59.590871','2025-12-04 10:42:11.382786','2025-12-04 10:42:14.568461',117,117,NULL,'ae2330f34cee47599e079667ef8df8bd','gigabytes',0,0,NULL,'3c978cf0-17b5-4fa5-bacb-dfcf70d53863'),('2025-12-04 10:41:59.593760','2025-12-04 10:42:11.382787','2025-12-04 10:42:14.568461',118,118,NULL,'ae2330f34cee47599e079667ef8df8bd','shares',0,0,NULL,'3c978cf0-17b5-4fa5-bacb-dfcf70d53863'),('2025-12-04 10:42:03.015240','2025-12-04 10:42:07.717721',NULL,0,119,'88e5a16daca84b4896b3a4ca2f314a8b','ae2330f34cee47599e079667ef8df8bd','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-04 10:42:03.017277','2025-12-04 10:42:07.717723',NULL,0,120,'88e5a16daca84b4896b3a4ca2f314a8b','ae2330f34cee47599e079667ef8df8bd','snapshots',0,0,NULL,NULL),('2025-12-04 10:42:03.035940','2025-12-04 10:42:07.717725','2025-12-04 10:42:14.568461',121,121,NULL,'ae2330f34cee47599e079667ef8df8bd','snapshot_gigabytes',0,0,NULL,'3c978cf0-17b5-4fa5-bacb-dfcf70d53863'),('2025-12-04 10:42:03.038480','2025-12-04 10:42:07.717726','2025-12-04 10:42:14.568461',122,122,NULL,'ae2330f34cee47599e079667ef8df8bd','snapshots',0,0,NULL,'3c978cf0-17b5-4fa5-bacb-dfcf70d53863'),('2025-12-04 10:42:16.544595','2025-12-04 10:43:23.252391',NULL,0,123,'8b4c6480f293453d850328438bc66819','094a9e5adfae45769d099eaf0d4f598c','shares',0,0,NULL,NULL),('2025-12-04 10:42:16.546774','2025-12-04 10:43:23.252394',NULL,0,124,'8b4c6480f293453d850328438bc66819','094a9e5adfae45769d099eaf0d4f598c','gigabytes',0,0,NULL,NULL),('2025-12-04 10:42:16.557387','2025-12-04 10:43:23.252395','2025-12-04 10:43:26.441783',125,125,NULL,'094a9e5adfae45769d099eaf0d4f598c','shares',0,0,NULL,'df88ce48-d3e8-48b4-aca4-3e96df85fd1c'),('2025-12-04 10:42:16.559117','2025-12-04 10:43:23.252396','2025-12-04 10:43:26.441783',126,126,NULL,'094a9e5adfae45769d099eaf0d4f598c','gigabytes',0,0,NULL,'df88ce48-d3e8-48b4-aca4-3e96df85fd1c'),('2025-12-04 10:42:23.391512','2025-12-04 10:42:28.152941',NULL,0,127,'d266eff9e7ae434291697f9a69cbed9c','e5ed5896f5c141d08b886fe18ab11b56','share_networks',0,0,NULL,NULL),('2025-12-04 10:42:35.589751','2025-12-04 10:42:38.181048',NULL,0,128,'4326a45d529b409c82188bae1a9bcf09','2d40ae03316045f1b24640181280b9a9','share_networks',1,0,NULL,NULL),('2025-12-04 10:42:45.183584','2025-12-04 10:43:25.304028',NULL,0,129,'d3c52ac6184348f5b9994127e3eeb5e5','e2d34491d1094a9480aa03d0d203a852','gigabytes',0,0,NULL,NULL),('2025-12-04 10:42:45.186074','2025-12-04 10:43:25.304031',NULL,0,130,'d3c52ac6184348f5b9994127e3eeb5e5','e2d34491d1094a9480aa03d0d203a852','shares',0,0,NULL,NULL),('2025-12-04 10:42:45.200691','2025-12-04 10:42:49.400201','2025-12-04 10:43:27.507775',131,131,NULL,'e2d34491d1094a9480aa03d0d203a852','gigabytes',0,0,NULL,'d20023e3-0d3f-4f8d-bc4b-35c7fd908150'),('2025-12-04 10:42:45.203322','2025-12-04 10:42:49.400203','2025-12-04 10:43:27.507775',132,132,NULL,'e2d34491d1094a9480aa03d0d203a852','shares',0,0,NULL,'d20023e3-0d3f-4f8d-bc4b-35c7fd908150'),('2025-12-04 10:42:49.583809','2025-12-04 10:42:55.030290',NULL,0,133,'1bb26f77770d4e0093ade4fe9d48231b','861ef911050d4b8ba35e89f01c620f89','share_networks',0,0,NULL,NULL),('2025-12-04 10:42:49.620514','2025-12-04 10:42:53.415115','2025-12-04 10:43:27.264147',134,134,NULL,'e2d34491d1094a9480aa03d0d203a852','gigabytes',0,0,NULL,'6689d307-ef56-40d7-ad85-62dddaf7d4ba'),('2025-12-04 10:42:49.622601','2025-12-04 10:42:53.415116','2025-12-04 10:43:27.264147',135,135,NULL,'e2d34491d1094a9480aa03d0d203a852','shares',0,0,NULL,'6689d307-ef56-40d7-ad85-62dddaf7d4ba'),('2025-12-04 10:42:53.750737','2025-12-04 10:43:01.541065','2025-12-04 10:43:26.919758',136,136,NULL,'e2d34491d1094a9480aa03d0d203a852','gigabytes',0,0,NULL,'bae4e5c8-4bd0-4aef-8463-ce3e493d8f98'),('2025-12-04 10:42:53.752635','2025-12-04 10:43:01.541066','2025-12-04 10:43:26.919758',137,137,NULL,'e2d34491d1094a9480aa03d0d203a852','shares',0,0,NULL,'bae4e5c8-4bd0-4aef-8463-ce3e493d8f98'),('2025-12-04 10:42:53.902968','2025-12-04 10:43:06.267186',NULL,0,138,'a70fe8cd329045aea5fadbb81acb5c56','991152b6ddef4a77a0c0088882c63fa1','gigabytes',1,0,NULL,NULL),('2025-12-04 10:42:53.905259','2025-12-04 10:43:06.267189',NULL,0,139,'a70fe8cd329045aea5fadbb81acb5c56','991152b6ddef4a77a0c0088882c63fa1','shares',1,0,NULL,NULL),('2025-12-04 10:42:53.919425','2025-12-04 10:43:06.267190','2025-12-04 10:43:10.119026',140,140,NULL,'991152b6ddef4a77a0c0088882c63fa1','gigabytes',1,0,NULL,'6f383b65-791c-4bc0-a865-8a8a9d0fd30c'),('2025-12-04 10:42:53.922359','2025-12-04 10:43:06.267191','2025-12-04 10:43:10.119026',141,141,NULL,'991152b6ddef4a77a0c0088882c63fa1','shares',1,0,NULL,'6f383b65-791c-4bc0-a865-8a8a9d0fd30c'),('2025-12-04 10:42:57.480427','2025-12-04 10:43:01.157577','2025-12-04 10:43:26.762305',142,142,NULL,'e2d34491d1094a9480aa03d0d203a852','gigabytes',0,0,NULL,'ce0f25d3-27ba-44eb-9b51-7c8fa400875f'),('2025-12-04 10:42:57.482774','2025-12-04 10:43:01.157579','2025-12-04 10:43:26.762305',143,143,NULL,'e2d34491d1094a9480aa03d0d203a852','shares',0,0,NULL,'ce0f25d3-27ba-44eb-9b51-7c8fa400875f'),('2025-12-04 10:42:57.811191','2025-12-04 10:42:58.756793',NULL,0,144,'936c73f02b5847adbbe71630454de16e','bf5ccaceeccc42cc87df11329a9d0159','gigabytes',0,0,NULL,NULL),('2025-12-04 10:42:57.812833','2025-12-04 10:42:58.756796',NULL,0,145,'936c73f02b5847adbbe71630454de16e','bf5ccaceeccc42cc87df11329a9d0159','shares',0,0,NULL,NULL),('2025-12-04 10:42:57.829460','2025-12-04 10:42:57.999992',NULL,0,146,'936c73f02b5847adbbe71630454de16e','991152b6ddef4a77a0c0088882c63fa1','gigabytes',-1,0,NULL,NULL),('2025-12-04 10:42:57.831036','2025-12-04 10:42:57.999998',NULL,0,147,'936c73f02b5847adbbe71630454de16e','991152b6ddef4a77a0c0088882c63fa1','shares',-1,0,NULL,NULL),('2025-12-04 10:42:58.743697','2025-12-04 10:42:58.756798','2025-12-04 10:43:10.119026',148,148,NULL,'bf5ccaceeccc42cc87df11329a9d0159','shares',0,0,NULL,'6f383b65-791c-4bc0-a865-8a8a9d0fd30c'),('2025-12-04 10:42:58.746814','2025-12-04 10:42:58.756799','2025-12-04 10:43:10.119026',149,149,NULL,'bf5ccaceeccc42cc87df11329a9d0159','gigabytes',0,0,NULL,'6f383b65-791c-4bc0-a865-8a8a9d0fd30c'),('2025-12-04 10:43:01.762409','2025-12-04 10:43:13.412714','2025-12-04 10:43:26.325049',150,150,NULL,'e2d34491d1094a9480aa03d0d203a852','gigabytes',0,0,NULL,'51dc31d5-ae2f-4cc3-99b0-d9bca2c752df'),('2025-12-04 10:43:01.764890','2025-12-04 10:43:13.412715','2025-12-04 10:43:26.325049',151,151,NULL,'e2d34491d1094a9480aa03d0d203a852','shares',0,0,NULL,'51dc31d5-ae2f-4cc3-99b0-d9bca2c752df'),('2025-12-04 10:43:03.369856','2025-12-04 10:43:05.284128',NULL,0,152,'2a76d8ce1fb140f5bbbd61ac660038f7','6df96f3f7888473c8c4020fd09afd972','share_networks',0,0,NULL,NULL),('2025-12-04 10:43:05.355767','2025-12-04 10:43:13.008071','2025-12-04 10:43:26.052527',153,153,NULL,'e2d34491d1094a9480aa03d0d203a852','gigabytes',0,0,NULL,'7793f738-7930-4537-9dfb-f37145dcc966'),('2025-12-04 10:43:05.359186','2025-12-04 10:43:13.008072','2025-12-04 10:43:26.052527',154,154,NULL,'e2d34491d1094a9480aa03d0d203a852','shares',0,0,NULL,'7793f738-7930-4537-9dfb-f37145dcc966'),('2025-12-04 10:43:08.924768','2025-12-04 10:43:12.674776','2025-12-04 10:43:25.902738',155,155,NULL,'e2d34491d1094a9480aa03d0d203a852','gigabytes',0,0,NULL,'6836a084-0716-44fd-a4c3-db6585ee754e'),('2025-12-04 10:43:08.926757','2025-12-04 10:43:12.674777','2025-12-04 10:43:25.902738',156,156,NULL,'e2d34491d1094a9480aa03d0d203a852','shares',0,0,NULL,'6836a084-0716-44fd-a4c3-db6585ee754e'),('2025-12-04 10:43:13.739131','2025-12-04 10:43:21.491071','2025-12-04 10:43:25.707963',157,157,NULL,'e2d34491d1094a9480aa03d0d203a852','shares',0,0,NULL,'515a821b-2c06-477c-82fe-373c817226c6'),('2025-12-04 10:43:13.743095','2025-12-04 10:43:21.491072','2025-12-04 10:43:25.707963',158,158,NULL,'e2d34491d1094a9480aa03d0d203a852','gigabytes',0,0,NULL,'515a821b-2c06-477c-82fe-373c817226c6'),('2025-12-04 10:43:17.388052','2025-12-04 10:43:21.242714','2025-12-04 10:43:25.548636',159,159,NULL,'e2d34491d1094a9480aa03d0d203a852','gigabytes',0,0,NULL,'4e0237cc-4b31-40b5-97b2-740edbe506d4'),('2025-12-04 10:43:17.390714','2025-12-04 10:43:21.242715','2025-12-04 10:43:25.548636',160,160,NULL,'e2d34491d1094a9480aa03d0d203a852','shares',0,0,NULL,'4e0237cc-4b31-40b5-97b2-740edbe506d4'),('2025-12-04 10:43:18.205755','2025-12-04 10:43:30.283052',NULL,0,161,'02070bf38c73498d9b030a6203229eab','e884ccda0adb4fcfa58e4992410a7be8','gigabytes',0,0,NULL,NULL),('2025-12-04 10:43:18.207910','2025-12-04 10:43:30.283055',NULL,0,162,'02070bf38c73498d9b030a6203229eab','e884ccda0adb4fcfa58e4992410a7be8','shares',0,0,NULL,NULL),('2025-12-04 10:43:18.221433','2025-12-04 10:43:30.283057','2025-12-04 10:43:33.545235',163,163,NULL,'e884ccda0adb4fcfa58e4992410a7be8','gigabytes',0,0,NULL,'10e75b0e-4372-4109-8731-61024b16f85c'),('2025-12-04 10:43:18.223396','2025-12-04 10:43:30.283059','2025-12-04 10:43:33.545235',164,164,NULL,'e884ccda0adb4fcfa58e4992410a7be8','shares',0,0,NULL,'10e75b0e-4372-4109-8731-61024b16f85c'),('2025-12-04 10:43:19.826988','2025-12-04 10:43:50.344357',NULL,0,165,'4c579d8ef46542619c86f7d6ba0c6283','b0e23771bd1a4c3ea8b52092c2e5d69e','gigabytes',0,0,NULL,NULL),('2025-12-04 10:43:19.828628','2025-12-04 10:43:50.344360',NULL,0,166,'4c579d8ef46542619c86f7d6ba0c6283','b0e23771bd1a4c3ea8b52092c2e5d69e','shares',0,0,NULL,NULL),('2025-12-04 10:43:19.836548','2025-12-04 10:43:50.344361','2025-12-04 10:43:54.340712',167,167,NULL,'b0e23771bd1a4c3ea8b52092c2e5d69e','gigabytes',0,0,NULL,'820e79dd-be75-4d91-aca0-04a50b785894'),('2025-12-04 10:43:19.838193','2025-12-04 10:43:50.344362','2025-12-04 10:43:54.340712',168,168,NULL,'b0e23771bd1a4c3ea8b52092c2e5d69e','shares',0,0,NULL,'820e79dd-be75-4d91-aca0-04a50b785894'),('2025-12-04 10:43:21.604821','2025-12-04 10:43:26.812394',NULL,0,169,'02070bf38c73498d9b030a6203229eab','e884ccda0adb4fcfa58e4992410a7be8','snapshots',0,0,NULL,NULL),('2025-12-04 10:43:21.607734','2025-12-04 10:43:26.812397',NULL,0,170,'02070bf38c73498d9b030a6203229eab','e884ccda0adb4fcfa58e4992410a7be8','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-04 10:43:21.623407','2025-12-04 10:43:26.812398','2025-12-04 10:43:33.545235',171,171,NULL,'e884ccda0adb4fcfa58e4992410a7be8','snapshots',0,0,NULL,'10e75b0e-4372-4109-8731-61024b16f85c'),('2025-12-04 10:43:21.626492','2025-12-04 10:43:26.812399','2025-12-04 10:43:33.545235',172,172,NULL,'e884ccda0adb4fcfa58e4992410a7be8','snapshot_gigabytes',0,0,NULL,'10e75b0e-4372-4109-8731-61024b16f85c'),('2025-12-04 10:43:21.659045','2025-12-04 10:43:25.304034','2025-12-04 10:43:25.383084',173,173,NULL,'e2d34491d1094a9480aa03d0d203a852','gigabytes',0,0,NULL,'a1ec9089-0fd2-48fb-bf6a-18efd8277aeb'),('2025-12-04 10:43:21.660993','2025-12-04 10:43:25.304035','2025-12-04 10:43:25.383084',174,174,NULL,'e2d34491d1094a9480aa03d0d203a852','shares',0,0,NULL,'a1ec9089-0fd2-48fb-bf6a-18efd8277aeb'),('2025-12-04 10:43:33.826095','2025-12-04 10:43:54.790252',NULL,0,175,'96fe23c86bd041028a1ccffe636b7da9','7e0c9a3966b443c7bbb289ba33849550','shares',0,0,NULL,NULL),('2025-12-04 10:43:33.828224','2025-12-04 10:43:54.790256',NULL,0,176,'96fe23c86bd041028a1ccffe636b7da9','7e0c9a3966b443c7bbb289ba33849550','gigabytes',0,0,NULL,NULL),('2025-12-04 10:43:33.837319','2025-12-04 10:43:54.790258','2025-12-04 10:43:57.433799',177,177,NULL,'7e0c9a3966b443c7bbb289ba33849550','shares',0,0,NULL,'670a24d3-016f-4e59-b59c-2a560b5418dd'),('2025-12-04 10:43:33.839733','2025-12-04 10:43:54.790259','2025-12-04 10:43:57.433799',178,178,NULL,'7e0c9a3966b443c7bbb289ba33849550','gigabytes',0,0,NULL,'670a24d3-016f-4e59-b59c-2a560b5418dd'),('2025-12-04 10:43:34.126064','2025-12-04 10:43:38.842705',NULL,0,179,'4c579d8ef46542619c86f7d6ba0c6283','b0e23771bd1a4c3ea8b52092c2e5d69e','share_groups',0,0,NULL,NULL),('2025-12-04 10:43:36.189646','2025-12-04 10:44:40.094734',NULL,0,180,'48ef94f1dc4447f08252015effc744b0','d831ca1755a740e7819c02d320ecd2a0','shares',0,0,NULL,NULL),('2025-12-04 10:43:36.193746','2025-12-04 10:44:40.094737',NULL,0,181,'48ef94f1dc4447f08252015effc744b0','d831ca1755a740e7819c02d320ecd2a0','gigabytes',0,0,NULL,NULL),('2025-12-04 10:43:36.204074','2025-12-04 10:44:40.094738','2025-12-04 10:44:42.841757',182,182,NULL,'d831ca1755a740e7819c02d320ecd2a0','shares',0,0,NULL,'4c300d44-f839-46b6-b125-41134ef8ee22'),('2025-12-04 10:43:36.206766','2025-12-04 10:44:40.094739','2025-12-04 10:44:42.841757',183,183,NULL,'d831ca1755a740e7819c02d320ecd2a0','gigabytes',0,0,NULL,'4c300d44-f839-46b6-b125-41134ef8ee22'),('2025-12-04 10:43:39.956257','2025-12-04 10:44:36.402647',NULL,0,184,NULL,'d831ca1755a740e7819c02d320ecd2a0','gigabytes',0,0,NULL,'a2f71277-9b7c-41be-ac23-94904d0c6314'),('2025-12-04 10:43:39.958981','2025-12-04 10:44:36.402648',NULL,0,185,NULL,'d831ca1755a740e7819c02d320ecd2a0','shares',0,0,NULL,'a2f71277-9b7c-41be-ac23-94904d0c6314'),('2025-12-04 10:43:44.096351','2025-12-04 10:44:32.720890',NULL,0,186,'ac347d74fad64b0bbb495d6240c31d44','c2e0964e5703431eab30fd7c235961ae','gigabytes',0,0,NULL,NULL),('2025-12-04 10:43:44.098390','2025-12-04 10:44:32.720893',NULL,0,187,'ac347d74fad64b0bbb495d6240c31d44','c2e0964e5703431eab30fd7c235961ae','shares',0,0,NULL,NULL),('2025-12-04 10:43:44.107202','2025-12-04 10:44:32.720894',NULL,0,188,NULL,'c2e0964e5703431eab30fd7c235961ae','gigabytes',0,0,NULL,'a2f71277-9b7c-41be-ac23-94904d0c6314'),('2025-12-04 10:43:44.109461','2025-12-04 10:44:32.720895',NULL,0,189,NULL,'c2e0964e5703431eab30fd7c235961ae','shares',0,0,NULL,'a2f71277-9b7c-41be-ac23-94904d0c6314'),('2025-12-04 10:43:52.648885','2025-12-04 10:44:44.229823',NULL,0,190,'0ef0510443b848f1bfcd4a773578d114','18048b8b581e48239e3a92c77164734b','shares',0,0,NULL,NULL),('2025-12-04 10:43:52.651707','2025-12-04 10:44:44.229828',NULL,0,191,'0ef0510443b848f1bfcd4a773578d114','18048b8b581e48239e3a92c77164734b','gigabytes',0,0,NULL,NULL),('2025-12-04 10:43:52.662248','2025-12-04 10:44:44.229830','2025-12-04 10:44:47.430303',192,192,NULL,'18048b8b581e48239e3a92c77164734b','shares',0,0,NULL,'8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:43:52.664559','2025-12-04 10:44:44.229832','2025-12-04 10:44:47.430303',193,193,NULL,'18048b8b581e48239e3a92c77164734b','gigabytes',0,0,NULL,'8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:43:56.326468','2025-12-04 10:44:43.363671',NULL,0,194,'0ef0510443b848f1bfcd4a773578d114','18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-04 10:43:56.329394','2025-12-04 10:44:43.363674',NULL,0,195,'0ef0510443b848f1bfcd4a773578d114','18048b8b581e48239e3a92c77164734b','snapshots',0,0,NULL,NULL),('2025-12-04 10:43:56.345633','2025-12-04 10:44:43.363676','2025-12-04 10:44:47.430303',196,196,NULL,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',0,0,NULL,'8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:43:56.348635','2025-12-04 10:44:43.363678','2025-12-04 10:44:47.430303',197,197,NULL,'18048b8b581e48239e3a92c77164734b','snapshots',0,0,NULL,'8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:05.545658','2025-12-04 10:44:10.928104',NULL,0,198,'cc8309c8aa2b47da966accf9ec753a0e','3ba683091e694bf1800f8fdcd57277cf','shares',0,0,NULL,NULL),('2025-12-04 10:44:05.547332','2025-12-04 10:44:10.928108',NULL,0,199,'cc8309c8aa2b47da966accf9ec753a0e','3ba683091e694bf1800f8fdcd57277cf','gigabytes',0,0,NULL,NULL),('2025-12-04 10:44:05.555348','2025-12-04 10:44:10.928110','2025-12-04 10:44:13.553381',200,200,NULL,'3ba683091e694bf1800f8fdcd57277cf','shares',0,0,NULL,'d2cb06dc-eba6-4fed-a094-61bf857c0e07'),('2025-12-04 10:44:05.556976','2025-12-04 10:44:10.928112','2025-12-04 10:44:13.553381',201,201,NULL,'3ba683091e694bf1800f8fdcd57277cf','gigabytes',0,0,NULL,'d2cb06dc-eba6-4fed-a094-61bf857c0e07'),('2025-12-04 10:44:13.483426','2025-12-04 10:44:28.954708','2025-12-04 10:44:42.841757',202,202,NULL,'c2e0964e5703431eab30fd7c235961ae','gigabytes',0,0,NULL,'4c300d44-f839-46b6-b125-41134ef8ee22'),('2025-12-04 10:44:13.486554','2025-12-04 10:44:28.954709','2025-12-04 10:44:42.841757',203,203,NULL,'c2e0964e5703431eab30fd7c235961ae','shares',0,0,NULL,'4c300d44-f839-46b6-b125-41134ef8ee22'),('2025-12-04 10:44:27.562029','2025-12-04 10:47:41.203746',NULL,0,204,'08d39615a7a349ae95f9c66ad6c00312','7df6681d57a74b90abc5310588588b91','gigabytes',0,0,NULL,NULL),('2025-12-04 10:44:27.564072','2025-12-04 10:47:41.203749',NULL,0,205,'08d39615a7a349ae95f9c66ad6c00312','7df6681d57a74b90abc5310588588b91','shares',0,0,NULL,NULL),('2025-12-04 10:44:27.574478','2025-12-04 10:47:41.203750',NULL,0,206,NULL,'7df6681d57a74b90abc5310588588b91','gigabytes',1,0,NULL,'b022472d-700d-41d8-9151-d06e86a7dc3f'),('2025-12-04 10:44:27.577404','2025-12-04 10:47:41.203752',NULL,0,207,NULL,'7df6681d57a74b90abc5310588588b91','shares',1,0,NULL,'b022472d-700d-41d8-9151-d06e86a7dc3f'),('2025-12-04 10:44:59.435557','2025-12-04 10:45:02.142452',NULL,0,208,'22ea2c4923594e4cb5626d4a09a7f6a1','a206b399e9d842ecbeb897b80e10c0fc','share_networks',0,0,NULL,NULL),('2025-12-04 10:45:08.050774','2025-12-04 10:45:35.794419',NULL,0,209,'16082b385ae54073bd230a6276db6494','fc1dc55455c4455c8c74c6488671677d','gigabytes',0,0,NULL,NULL),('2025-12-04 10:45:08.052828','2025-12-04 10:45:35.794422',NULL,0,210,'16082b385ae54073bd230a6276db6494','fc1dc55455c4455c8c74c6488671677d','shares',0,0,NULL,NULL),('2025-12-04 10:45:08.062019','2025-12-04 10:45:35.794424','2025-12-04 10:45:38.716733',211,211,NULL,'fc1dc55455c4455c8c74c6488671677d','gigabytes',0,0,NULL,'79086422-8620-41bb-ad72-d3d2e0f09707'),('2025-12-04 10:45:08.063908','2025-12-04 10:45:35.794425','2025-12-04 10:45:38.716733',212,212,NULL,'fc1dc55455c4455c8c74c6488671677d','shares',0,0,NULL,'79086422-8620-41bb-ad72-d3d2e0f09707'),('2025-12-04 10:45:56.386147','2025-12-04 10:47:05.420490',NULL,0,213,'c8bddd1494604235b944287494725839','bdee1673bf874393ab80f7311782fc10','shares',0,0,NULL,NULL),('2025-12-04 10:45:56.388126','2025-12-04 10:47:05.420492',NULL,0,214,'c8bddd1494604235b944287494725839','bdee1673bf874393ab80f7311782fc10','gigabytes',0,0,NULL,NULL),('2025-12-04 10:45:56.397724','2025-12-04 10:47:05.420494','2025-12-04 10:47:08.476379',215,215,NULL,'bdee1673bf874393ab80f7311782fc10','shares',0,0,NULL,'ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:45:56.399574','2025-12-04 10:47:05.420495','2025-12-04 10:47:08.476379',216,216,NULL,'bdee1673bf874393ab80f7311782fc10','gigabytes',0,0,NULL,'ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:45:59.806220','2025-12-04 10:47:02.060797',NULL,0,217,'c8bddd1494604235b944287494725839','bdee1673bf874393ab80f7311782fc10','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-04 10:45:59.809350','2025-12-04 10:47:02.060800',NULL,0,218,'c8bddd1494604235b944287494725839','bdee1673bf874393ab80f7311782fc10','snapshots',0,0,NULL,NULL),('2025-12-04 10:45:59.819576','2025-12-04 10:47:02.060802','2025-12-04 10:47:08.476379',219,219,NULL,'bdee1673bf874393ab80f7311782fc10','snapshot_gigabytes',0,0,NULL,'ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:45:59.821581','2025-12-04 10:47:02.060803','2025-12-04 10:47:08.476379',220,220,NULL,'bdee1673bf874393ab80f7311782fc10','snapshots',0,0,NULL,'ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:47:17.534484','2025-12-04 10:47:43.926758',NULL,0,221,'c99b07cc76794bbe865e84c99d719aec','b08d95dfcf5049b89d93e68ea13452d2','gigabytes',0,0,NULL,NULL),('2025-12-04 10:47:17.539397','2025-12-04 10:47:43.926761',NULL,0,222,'c99b07cc76794bbe865e84c99d719aec','b08d95dfcf5049b89d93e68ea13452d2','shares',0,0,NULL,NULL),('2025-12-04 10:47:17.653633','2025-12-04 10:47:43.926763','2025-12-04 10:47:47.375358',223,223,NULL,'b08d95dfcf5049b89d93e68ea13452d2','gigabytes',0,0,NULL,'7e2e54b3-9fc4-42f1-9682-dfd37ababbc9'),('2025-12-04 10:47:17.655603','2025-12-04 10:47:43.926765','2025-12-04 10:47:47.375358',224,224,NULL,'b08d95dfcf5049b89d93e68ea13452d2','shares',0,0,NULL,'7e2e54b3-9fc4-42f1-9682-dfd37ababbc9'),('2025-12-04 10:47:21.110486','2025-12-04 10:47:40.376546',NULL,0,225,'c99b07cc76794bbe865e84c99d719aec','b08d95dfcf5049b89d93e68ea13452d2','snapshots',0,0,NULL,NULL),('2025-12-04 10:47:21.117071','2025-12-04 10:47:40.376550',NULL,0,226,'c99b07cc76794bbe865e84c99d719aec','b08d95dfcf5049b89d93e68ea13452d2','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-04 10:47:21.134120','2025-12-04 10:47:40.376552','2025-12-04 10:47:47.375358',227,227,NULL,'b08d95dfcf5049b89d93e68ea13452d2','snapshots',0,0,NULL,'7e2e54b3-9fc4-42f1-9682-dfd37ababbc9'),('2025-12-04 10:47:21.138267','2025-12-04 10:47:40.376553','2025-12-04 10:47:47.375358',228,228,NULL,'b08d95dfcf5049b89d93e68ea13452d2','snapshot_gigabytes',0,0,NULL,'7e2e54b3-9fc4-42f1-9682-dfd37ababbc9'),('2025-12-04 10:47:25.702646','2025-12-04 10:47:25.926659',NULL,0,229,'7cbf92cc96924e4faa65304277a5028e','7df6681d57a74b90abc5310588588b91','shares',1,0,NULL,NULL),('2025-12-04 10:47:25.705880','2025-12-04 10:47:25.926661',NULL,0,230,'7cbf92cc96924e4faa65304277a5028e','7df6681d57a74b90abc5310588588b91','gigabytes',1,0,NULL,NULL),('2025-12-04 10:47:53.643190','2025-12-04 10:48:05.644120',NULL,0,231,'832dabe00e054a2db2a663d3bafcdafd','440666156b56403fabeabff6ee9b42d9','gigabytes',0,0,NULL,NULL),('2025-12-04 10:47:53.645778','2025-12-04 10:48:05.644123',NULL,0,232,'832dabe00e054a2db2a663d3bafcdafd','440666156b56403fabeabff6ee9b42d9','shares',0,0,NULL,NULL),('2025-12-04 10:47:53.655687','2025-12-04 10:48:05.644124','2025-12-04 10:48:08.683264',233,233,NULL,'440666156b56403fabeabff6ee9b42d9','gigabytes',0,0,NULL,'9f12719f-820d-45f8-8b37-c67efc69baf2'),('2025-12-04 10:47:53.657812','2025-12-04 10:48:05.644126','2025-12-04 10:48:08.683264',234,234,NULL,'440666156b56403fabeabff6ee9b42d9','shares',0,0,NULL,'9f12719f-820d-45f8-8b37-c67efc69baf2'),('2025-12-04 10:47:55.435625','2025-12-04 10:48:07.240112',NULL,0,235,'bd0c952b76bd4095a0ae18a8f5a049b2','063b90bfc86448709eb6958911a53f96','gigabytes',0,0,NULL,NULL),('2025-12-04 10:47:55.447113','2025-12-04 10:48:07.240115',NULL,0,236,'bd0c952b76bd4095a0ae18a8f5a049b2','063b90bfc86448709eb6958911a53f96','shares',0,0,NULL,NULL),('2025-12-04 10:47:55.456356','2025-12-04 10:48:07.240117','2025-12-04 10:48:10.335509',237,237,NULL,'063b90bfc86448709eb6958911a53f96','gigabytes',0,0,NULL,'c0d93c20-f27c-4fec-9d23-328c1d8e67c8'),('2025-12-04 10:47:55.458412','2025-12-04 10:48:07.240118','2025-12-04 10:48:10.335509',238,238,NULL,'063b90bfc86448709eb6958911a53f96','shares',0,0,NULL,'c0d93c20-f27c-4fec-9d23-328c1d8e67c8'),('2025-12-04 10:47:57.179354','2025-12-04 10:48:02.274570',NULL,0,239,'832dabe00e054a2db2a663d3bafcdafd','440666156b56403fabeabff6ee9b42d9','snapshots',0,0,NULL,NULL),('2025-12-04 10:47:57.181445','2025-12-04 10:48:02.274574',NULL,0,240,'832dabe00e054a2db2a663d3bafcdafd','440666156b56403fabeabff6ee9b42d9','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-04 10:47:57.191616','2025-12-04 10:48:02.274576','2025-12-04 10:48:08.683264',241,241,NULL,'440666156b56403fabeabff6ee9b42d9','snapshots',0,0,NULL,'9f12719f-820d-45f8-8b37-c67efc69baf2'),('2025-12-04 10:47:57.193739','2025-12-04 10:48:02.274578','2025-12-04 10:48:08.683264',242,242,NULL,'440666156b56403fabeabff6ee9b42d9','snapshot_gigabytes',0,0,NULL,'9f12719f-820d-45f8-8b37-c67efc69baf2'),('2025-12-04 10:47:58.822428','2025-12-04 10:48:03.840675',NULL,0,243,'bd0c952b76bd4095a0ae18a8f5a049b2','063b90bfc86448709eb6958911a53f96','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-04 10:47:58.824498','2025-12-04 10:48:03.840680',NULL,0,244,'bd0c952b76bd4095a0ae18a8f5a049b2','063b90bfc86448709eb6958911a53f96','snapshots',0,0,NULL,NULL),('2025-12-04 10:47:58.833256','2025-12-04 10:48:03.840681','2025-12-04 10:48:10.335509',245,245,NULL,'063b90bfc86448709eb6958911a53f96','snapshot_gigabytes',0,0,NULL,'c0d93c20-f27c-4fec-9d23-328c1d8e67c8'),('2025-12-04 10:47:58.835336','2025-12-04 10:48:03.840682','2025-12-04 10:48:10.335509',246,246,NULL,'063b90bfc86448709eb6958911a53f96','snapshots',0,0,NULL,'c0d93c20-f27c-4fec-9d23-328c1d8e67c8'),('2025-12-04 10:48:24.841257','2025-12-04 10:48:24.883116',NULL,0,247,'de4db57a4dde458ca59ef1effab03d64','d7b71786426443df9d7260a4c1f1ebd1','share_networks',1,0,NULL,NULL),('2025-12-04 10:48:54.405675','2025-12-04 10:50:35.684397',NULL,0,248,'a7cbfaccac8f48c1bc69fb83640618a5','2c40fb2875304a41b2368725937fd373','gigabytes',0,0,NULL,NULL),('2025-12-04 10:48:54.409857','2025-12-04 10:50:35.684400',NULL,0,249,'a7cbfaccac8f48c1bc69fb83640618a5','2c40fb2875304a41b2368725937fd373','shares',0,0,NULL,NULL),('2025-12-04 10:48:54.421385','2025-12-04 10:49:05.534518','2025-12-04 10:49:08.557124',250,250,NULL,'2c40fb2875304a41b2368725937fd373','gigabytes',0,0,NULL,'067e02e9-90fb-47d1-be2d-f4ea7d81904d'),('2025-12-04 10:48:54.424198','2025-12-04 10:49:05.534519','2025-12-04 10:49:08.557124',251,251,NULL,'2c40fb2875304a41b2368725937fd373','shares',0,0,NULL,'067e02e9-90fb-47d1-be2d-f4ea7d81904d'),('2025-12-04 10:48:57.844933','2025-12-04 10:50:32.240642',NULL,0,252,'a7cbfaccac8f48c1bc69fb83640618a5','2c40fb2875304a41b2368725937fd373','snapshots',0,0,NULL,NULL),('2025-12-04 10:48:57.847797','2025-12-04 10:50:32.240646',NULL,0,253,'a7cbfaccac8f48c1bc69fb83640618a5','2c40fb2875304a41b2368725937fd373','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-04 10:48:57.910000','2025-12-04 10:49:01.858043','2025-12-04 10:49:08.557124',254,254,NULL,'2c40fb2875304a41b2368725937fd373','snapshots',0,0,NULL,'067e02e9-90fb-47d1-be2d-f4ea7d81904d'),('2025-12-04 10:48:57.912213','2025-12-04 10:49:01.858044','2025-12-04 10:49:08.557124',255,255,NULL,'2c40fb2875304a41b2368725937fd373','snapshot_gigabytes',0,0,NULL,'067e02e9-90fb-47d1-be2d-f4ea7d81904d'),('2025-12-04 10:49:08.779207','2025-12-04 10:49:12.848832','2025-12-04 10:50:39.729581',256,256,NULL,'2c40fb2875304a41b2368725937fd373','gigabytes',0,0,NULL,'8446d21c-69f2-4851-933b-997effa49241'),('2025-12-04 10:49:08.785736','2025-12-04 10:49:12.848833','2025-12-04 10:50:39.729581',257,257,NULL,'2c40fb2875304a41b2368725937fd373','shares',0,0,NULL,'8446d21c-69f2-4851-933b-997effa49241'),('2025-12-04 10:49:15.888907','2025-12-04 10:50:35.684402','2025-12-04 10:50:38.651681',258,258,NULL,'2c40fb2875304a41b2368725937fd373','shares',0,0,NULL,'83cb9767-1df4-4921-a073-4398082b463f'),('2025-12-04 10:49:15.891336','2025-12-04 10:50:35.684403','2025-12-04 10:50:38.651681',259,259,NULL,'2c40fb2875304a41b2368725937fd373','gigabytes',0,0,NULL,'83cb9767-1df4-4921-a073-4398082b463f'),('2025-12-04 10:49:19.310243','2025-12-04 10:50:32.240648','2025-12-04 10:50:38.651681',260,260,NULL,'2c40fb2875304a41b2368725937fd373','snapshots',0,0,NULL,'83cb9767-1df4-4921-a073-4398082b463f'),('2025-12-04 10:49:19.312933','2025-12-04 10:50:32.240650','2025-12-04 10:50:38.651681',261,261,NULL,'2c40fb2875304a41b2368725937fd373','snapshot_gigabytes',0,0,NULL,'83cb9767-1df4-4921-a073-4398082b463f'),('2025-12-04 10:50:50.112545','2025-12-04 10:51:38.383644',NULL,0,262,'e318249fe70a4240a4a0e7ebc5c47a65','c3ea6486309b4dab9bf9d14f604bdce4','shares',0,0,NULL,NULL),('2025-12-04 10:50:50.117450','2025-12-04 10:51:38.383647',NULL,0,263,'e318249fe70a4240a4a0e7ebc5c47a65','c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',0,0,NULL,NULL),('2025-12-04 10:50:50.147835','2025-12-04 10:51:38.383648','2025-12-04 10:51:41.449556',264,264,NULL,'c3ea6486309b4dab9bf9d14f604bdce4','shares',0,0,NULL,'6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:50:50.151513','2025-12-04 10:51:38.383650','2025-12-04 10:51:41.449556',265,265,NULL,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',0,0,NULL,'6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:50:53.571069','2025-12-04 10:51:35.643385',NULL,0,266,'e318249fe70a4240a4a0e7ebc5c47a65','c3ea6486309b4dab9bf9d14f604bdce4','snapshots',0,0,NULL,NULL),('2025-12-04 10:50:53.572845','2025-12-04 10:51:35.643388',NULL,0,267,'e318249fe70a4240a4a0e7ebc5c47a65','c3ea6486309b4dab9bf9d14f604bdce4','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-04 10:50:53.582721','2025-12-04 10:51:35.643389','2025-12-04 10:51:41.449556',268,268,NULL,'c3ea6486309b4dab9bf9d14f604bdce4','snapshots',0,0,NULL,'6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:50:53.584738','2025-12-04 10:51:35.643391','2025-12-04 10:51:41.449556',269,269,NULL,'c3ea6486309b4dab9bf9d14f604bdce4','snapshot_gigabytes',0,0,NULL,'6a3c87d9-578e-441f-9691-5571c558f82e');
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
INSERT INTO `quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2025-12-04 10:39:27.320066',NULL,'2025-12-04 10:39:27.498799',1,'1a11c9942929435599f0a51c3f690b44','shares',1),(2,'2025-12-04 10:39:31.606195',NULL,'2025-12-04 10:39:35.874070',2,'1a11c9942929435599f0a51c3f690b44','snapshots',1),(3,'2025-12-04 10:39:47.084394',NULL,'2025-12-04 10:39:47.494015',3,'1a11c9942929435599f0a51c3f690b44','shares',10),(4,'2025-12-04 10:39:47.807855',NULL,'2025-12-04 10:39:48.093416',4,'1a11c9942929435599f0a51c3f690b44','shares',10),(5,'2025-12-04 10:39:53.408101',NULL,'2025-12-04 10:40:10.102402',5,'bc4567fbe8fa43ebb22d7433659a15be','shares',3),(6,'2025-12-04 10:39:53.414068',NULL,'2025-12-04 10:40:10.102402',6,'bc4567fbe8fa43ebb22d7433659a15be','gigabytes',10),(7,'2025-12-04 10:40:10.340205',NULL,'2025-12-04 10:40:11.304435',7,'bc4567fbe8fa43ebb22d7433659a15be','shares',55),(8,'2025-12-04 10:40:10.350498',NULL,'2025-12-04 10:40:11.304435',8,'bc4567fbe8fa43ebb22d7433659a15be','snapshots',55),(9,'2025-12-04 10:40:10.355146',NULL,'2025-12-04 10:40:11.304435',9,'bc4567fbe8fa43ebb22d7433659a15be','gigabytes',1005),(10,'2025-12-04 10:40:10.365885',NULL,'2025-12-04 10:40:11.304435',10,'bc4567fbe8fa43ebb22d7433659a15be','snapshot_gigabytes',1005),(11,'2025-12-04 10:40:10.369362',NULL,'2025-12-04 10:40:11.304435',11,'bc4567fbe8fa43ebb22d7433659a15be','share_replicas',105),(12,'2025-12-04 10:40:10.372717',NULL,'2025-12-04 10:40:11.304435',12,'bc4567fbe8fa43ebb22d7433659a15be','replica_gigabytes',1005),(13,'2025-12-04 10:40:11.749719',NULL,'2025-12-04 10:40:12.550165',13,'bc4567fbe8fa43ebb22d7433659a15be','shares',55),(14,'2025-12-04 10:40:11.759961',NULL,'2025-12-04 10:40:12.550165',14,'bc4567fbe8fa43ebb22d7433659a15be','snapshots',55),(15,'2025-12-04 10:40:11.766983',NULL,'2025-12-04 10:40:12.550165',15,'bc4567fbe8fa43ebb22d7433659a15be','gigabytes',1005),(16,'2025-12-04 10:40:11.775835',NULL,'2025-12-04 10:40:12.550165',16,'bc4567fbe8fa43ebb22d7433659a15be','snapshot_gigabytes',1005),(17,'2025-12-04 10:40:11.780995',NULL,'2025-12-04 10:40:12.550165',17,'bc4567fbe8fa43ebb22d7433659a15be','share_replicas',105),(18,'2025-12-04 10:40:11.785303',NULL,'2025-12-04 10:40:12.550165',18,'bc4567fbe8fa43ebb22d7433659a15be','replica_gigabytes',1005),(19,'2025-12-04 10:40:12.806721',NULL,'2025-12-04 10:40:12.936441',19,'bc4567fbe8fa43ebb22d7433659a15be','shares',52),(20,'2025-12-04 10:40:12.812193',NULL,'2025-12-04 10:40:12.936441',20,'bc4567fbe8fa43ebb22d7433659a15be','snapshots',52),(21,'2025-12-04 10:40:12.831055',NULL,'2025-12-04 10:40:12.936441',21,'bc4567fbe8fa43ebb22d7433659a15be','gigabytes',1002),(22,'2025-12-04 10:40:12.835718',NULL,'2025-12-04 10:40:12.936441',22,'bc4567fbe8fa43ebb22d7433659a15be','snapshot_gigabytes',1002),(23,'2025-12-04 10:40:12.840161',NULL,'2025-12-04 10:40:12.936441',23,'bc4567fbe8fa43ebb22d7433659a15be','share_networks',12),(24,'2025-12-04 10:40:12.846045',NULL,'2025-12-04 10:40:12.936441',24,'bc4567fbe8fa43ebb22d7433659a15be','share_replicas',102),(25,'2025-12-04 10:40:12.851188',NULL,'2025-12-04 10:40:12.936441',25,'bc4567fbe8fa43ebb22d7433659a15be','replica_gigabytes',1002),(26,'2025-12-04 10:40:13.187708',NULL,'2025-12-04 10:40:13.535662',26,'bc4567fbe8fa43ebb22d7433659a15be','shares',13),(27,'2025-12-04 10:40:13.621489',NULL,'2025-12-04 10:40:13.736481',27,'bc4567fbe8fa43ebb22d7433659a15be','gigabytes',-1),(28,'2025-12-04 10:40:13.818077',NULL,'2025-12-04 10:40:13.946311',28,'bc4567fbe8fa43ebb22d7433659a15be','share_replicas',-1),(29,'2025-12-04 10:40:14.030404',NULL,'2025-12-04 10:40:14.167231',29,'bc4567fbe8fa43ebb22d7433659a15be','replica_gigabytes',-1),(30,'2025-12-04 10:40:14.273652',NULL,'2025-12-04 10:40:14.494880',30,'bc4567fbe8fa43ebb22d7433659a15be','share_networks',-1),(31,'2025-12-04 10:40:14.605588',NULL,'2025-12-04 10:40:14.964027',31,'bc4567fbe8fa43ebb22d7433659a15be','shares',-1),(32,'2025-12-04 10:40:15.106141',NULL,'2025-12-04 10:40:15.236800',32,'bc4567fbe8fa43ebb22d7433659a15be','snapshot_gigabytes',-1),(33,'2025-12-04 10:40:15.457420',NULL,'2025-12-04 10:40:15.686409',33,'bc4567fbe8fa43ebb22d7433659a15be','snapshots',-1),(34,'2025-12-04 10:40:21.644488',NULL,'2025-12-04 10:40:21.847695',34,'bc4567fbe8fa43ebb22d7433659a15be','shares',10),(35,'2025-12-04 10:40:22.054188',NULL,'2025-12-04 10:40:22.220430',35,'bc4567fbe8fa43ebb22d7433659a15be','shares',10),(36,'2025-12-04 10:40:22.379855',NULL,'2025-12-04 10:40:22.436318',36,'bc4567fbe8fa43ebb22d7433659a15be','gigabytes',1002),(37,'2025-12-04 10:40:22.581957',NULL,'2025-12-04 10:40:22.640553',37,'bc4567fbe8fa43ebb22d7433659a15be','share_networks',12),(38,'2025-12-04 10:40:22.793015',NULL,'2025-12-04 10:40:22.877686',38,'bc4567fbe8fa43ebb22d7433659a15be','shares',52),(39,'2025-12-04 10:40:23.017014',NULL,'2025-12-04 10:40:23.081575',39,'bc4567fbe8fa43ebb22d7433659a15be','snapshot_gigabytes',1002),(40,'2025-12-04 10:40:23.241151',NULL,'2025-12-04 10:40:23.299391',40,'bc4567fbe8fa43ebb22d7433659a15be','snapshots',52),(41,'2025-12-04 10:40:23.781735',NULL,'2025-12-04 10:40:23.847985',41,'bc4567fbe8fa43ebb22d7433659a15be','share_replicas',99),(42,'2025-12-04 10:40:24.279235',NULL,'2025-12-04 10:40:24.362552',42,'bc4567fbe8fa43ebb22d7433659a15be','replica_gigabytes',999),(43,'2025-12-04 10:40:25.877325',NULL,'2025-12-04 10:40:26.168442',43,'bc4567fbe8fa43ebb22d7433659a15be','shares',10),(44,'2025-12-04 10:40:26.260822',NULL,'2025-12-04 10:40:26.790375',44,'bc4567fbe8fa43ebb22d7433659a15be','shares',10);
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `usage_id` (`usage_id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=976 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `share_type_id`) VALUES ('2025-12-04 10:39:12.221814',NULL,'2025-12-04 10:39:12.282225',1,1,'d2380cdaae7840a7aa1016a0c2242ad2','132fd5d4-024e-400b-a95a-48644e2524b7',1,'30e995746f0346cc925a4e4d291b4b4b','shares',1,'2025-12-05 10:39:12',NULL),('2025-12-04 10:39:12.224338',NULL,'2025-12-04 10:39:12.282225',2,2,'d2380cdaae7840a7aa1016a0c2242ad2','82db2f5d-507e-45fd-b184-968174ab16c9',2,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',1,'2025-12-05 10:39:12',NULL),('2025-12-04 10:39:12.239129',NULL,'2025-12-04 10:39:12.282225',3,3,NULL,'73889642-425e-4b97-9ea6-6bad69aaed27',3,'30e995746f0346cc925a4e4d291b4b4b','shares',1,'2025-12-05 10:39:12','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:12.240272',NULL,'2025-12-04 10:39:12.282225',4,4,NULL,'1f7c63d7-4323-4522-9cdc-c221d9edb78b',4,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',1,'2025-12-05 10:39:12','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:13.082011',NULL,'2025-12-04 10:39:13.133901',5,5,'28d021876b6d47e6bb3cbf1d91fe3cfc','34f75a96-d0c1-4829-ac17-ee502ae57e64',6,'fdf8cc9e5d484c87979d04086aa3299b','shares',1,'2025-12-05 10:39:13',NULL),('2025-12-04 10:39:13.084155',NULL,'2025-12-04 10:39:13.133901',6,6,'28d021876b6d47e6bb3cbf1d91fe3cfc','1029cfd2-9b65-4004-bf3b-52c6663ed873',5,'fdf8cc9e5d484c87979d04086aa3299b','gigabytes',1,'2025-12-05 10:39:13',NULL),('2025-12-04 10:39:13.101509',NULL,'2025-12-04 10:39:13.133901',7,7,NULL,'509324d1-ae64-45d7-84d8-597d465a3506',8,'fdf8cc9e5d484c87979d04086aa3299b','shares',1,'2025-12-05 10:39:13','703ba806-b6aa-4733-8c75-4e18892fffb1'),('2025-12-04 10:39:13.102714',NULL,'2025-12-04 10:39:13.133901',8,8,NULL,'36d83e02-7a0e-4ff1-b1ae-d48967a13225',7,'fdf8cc9e5d484c87979d04086aa3299b','gigabytes',1,'2025-12-05 10:39:13','703ba806-b6aa-4733-8c75-4e18892fffb1'),('2025-12-04 10:39:16.365969',NULL,'2025-12-04 10:39:16.399685',9,9,'d2380cdaae7840a7aa1016a0c2242ad2','788584fa-7de9-4d84-9728-5de22f583b55',1,'30e995746f0346cc925a4e4d291b4b4b','shares',1,'2025-12-05 10:39:16',NULL),('2025-12-04 10:39:16.367537',NULL,'2025-12-04 10:39:16.399685',10,10,'d2380cdaae7840a7aa1016a0c2242ad2','83f25033-a7b1-4083-a435-bf2202f5d2c4',2,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',1,'2025-12-05 10:39:16',NULL),('2025-12-04 10:39:16.377737',NULL,'2025-12-04 10:39:16.399685',11,11,NULL,'21996a00-8c98-480e-a904-2e09fe5ab532',3,'30e995746f0346cc925a4e4d291b4b4b','shares',1,'2025-12-05 10:39:16','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:16.378861',NULL,'2025-12-04 10:39:16.399685',12,12,NULL,'303e01bc-78af-4065-8073-a981fcdfed33',4,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',1,'2025-12-05 10:39:16','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:16.754570',NULL,'2025-12-04 10:39:16.874965',13,13,'28d021876b6d47e6bb3cbf1d91fe3cfc','60d7e4e8-0df9-417c-a4cc-4f7bed65dd5c',10,'fdf8cc9e5d484c87979d04086aa3299b','snapshots',1,'2025-12-05 10:39:16',NULL),('2025-12-04 10:39:16.756235',NULL,'2025-12-04 10:39:16.874965',14,14,'28d021876b6d47e6bb3cbf1d91fe3cfc','b80ccf64-3d58-4cd9-883d-5a706af0a604',9,'fdf8cc9e5d484c87979d04086aa3299b','snapshot_gigabytes',1,'2025-12-05 10:39:16',NULL),('2025-12-04 10:39:16.767364',NULL,'2025-12-04 10:39:16.874965',15,15,NULL,'ea69d2ae-3b9f-4a67-a242-668c77b4534a',12,'fdf8cc9e5d484c87979d04086aa3299b','snapshots',1,'2025-12-05 10:39:16','703ba806-b6aa-4733-8c75-4e18892fffb1'),('2025-12-04 10:39:16.768596',NULL,'2025-12-04 10:39:16.874965',16,16,NULL,'f287c6a0-18e5-4117-b5ab-0bc51bccee1b',11,'fdf8cc9e5d484c87979d04086aa3299b','snapshot_gigabytes',1,'2025-12-05 10:39:16','703ba806-b6aa-4733-8c75-4e18892fffb1'),('2025-12-04 10:39:20.566891',NULL,'2025-12-04 10:39:20.760409',17,17,'d2380cdaae7840a7aa1016a0c2242ad2','79de50c0-63a7-4201-942e-a7840edf2550',2,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',1,'2025-12-05 10:39:20',NULL),('2025-12-04 10:39:20.575807',NULL,'2025-12-04 10:39:20.760409',18,18,NULL,'e83bcb7e-ddb9-4c96-af5d-06ad417c83fb',4,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',1,'2025-12-05 10:39:20','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:22.303351',NULL,'2025-12-04 10:39:22.346403',19,19,'d2380cdaae7840a7aa1016a0c2242ad2','62ed9cb3-1a8d-456f-8583-5cf1f71af358',1,'30e995746f0346cc925a4e4d291b4b4b','shares',-1,'2025-12-05 10:39:22',NULL),('2025-12-04 10:39:22.308278',NULL,'2025-12-04 10:39:22.346403',20,20,'d2380cdaae7840a7aa1016a0c2242ad2','7e2feb0a-bd22-4cb2-9e21-3d63429dff6a',2,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',-2,'2025-12-05 10:39:22',NULL),('2025-12-04 10:39:22.324449',NULL,'2025-12-04 10:39:22.346403',21,21,NULL,'6e2593a3-d422-4ff7-8925-a9b9f6fa4bba',3,'30e995746f0346cc925a4e4d291b4b4b','shares',-1,'2025-12-05 10:39:22','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:22.328249',NULL,'2025-12-04 10:39:22.346403',22,22,NULL,'bd7c214e-15e8-4636-8963-f00c612f5ee1',4,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',-2,'2025-12-05 10:39:22','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:22.972581',NULL,'2025-12-04 10:39:22.990898',23,23,'28d021876b6d47e6bb3cbf1d91fe3cfc','8b7e71f3-b4ab-4a8b-b324-823ac932b5f2',10,'fdf8cc9e5d484c87979d04086aa3299b','snapshots',-1,'2025-12-05 10:39:22',NULL),('2025-12-04 10:39:22.973508',NULL,'2025-12-04 10:39:22.990898',24,24,'28d021876b6d47e6bb3cbf1d91fe3cfc','cb942eb8-08dc-4391-afcc-4a3b0a7c109b',9,'fdf8cc9e5d484c87979d04086aa3299b','snapshot_gigabytes',-1,'2025-12-05 10:39:22',NULL),('2025-12-04 10:39:22.982249',NULL,'2025-12-04 10:39:22.990898',25,25,NULL,'f98dfafa-4def-40eb-a57c-4408760b0f91',12,'fdf8cc9e5d484c87979d04086aa3299b','snapshots',-1,'2025-12-05 10:39:22','703ba806-b6aa-4733-8c75-4e18892fffb1'),('2025-12-04 10:39:22.983084',NULL,'2025-12-04 10:39:22.990898',26,26,NULL,'00c297d9-c949-41df-82ed-363fdb9a830b',11,'fdf8cc9e5d484c87979d04086aa3299b','snapshot_gigabytes',-1,'2025-12-05 10:39:22','703ba806-b6aa-4733-8c75-4e18892fffb1'),('2025-12-04 10:39:23.832190',NULL,'2025-12-04 10:39:23.888345',27,27,'9382d7467f084a7daaf3852289dd7e55','f517a4d4-cfbc-4a6f-b07e-6073b457f307',14,'1a11c9942929435599f0a51c3f690b44','shares',1,'2025-12-05 10:39:23',NULL),('2025-12-04 10:39:23.833524',NULL,'2025-12-04 10:39:23.888345',28,28,'9382d7467f084a7daaf3852289dd7e55','5f7096c1-8657-42ea-94b9-c010af4cbc6f',13,'1a11c9942929435599f0a51c3f690b44','gigabytes',1,'2025-12-05 10:39:23',NULL),('2025-12-04 10:39:23.850613',NULL,'2025-12-04 10:39:23.888345',29,29,NULL,'e2032a96-b47c-4957-965e-4e9a77e3f4a5',16,'1a11c9942929435599f0a51c3f690b44','shares',1,'2025-12-05 10:39:23','f9c9ca5f-6992-4730-8113-73ad975de651'),('2025-12-04 10:39:23.854971',NULL,'2025-12-04 10:39:23.888345',30,30,NULL,'7b93c812-413d-40aa-975d-55d0140c26a4',15,'1a11c9942929435599f0a51c3f690b44','gigabytes',1,'2025-12-05 10:39:23','f9c9ca5f-6992-4730-8113-73ad975de651'),('2025-12-04 10:39:25.510050',NULL,'2025-12-04 10:39:25.542993',31,31,'d2380cdaae7840a7aa1016a0c2242ad2','9028073b-dccc-4ab4-ba2e-39f344732770',1,'30e995746f0346cc925a4e4d291b4b4b','shares',1,'2025-12-05 10:39:25',NULL),('2025-12-04 10:39:25.511667',NULL,'2025-12-04 10:39:25.542993',32,32,'d2380cdaae7840a7aa1016a0c2242ad2','f35fc8e3-5e37-467d-93e3-d6dad96e7046',2,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',1,'2025-12-05 10:39:25',NULL),('2025-12-04 10:39:25.522154',NULL,'2025-12-04 10:39:25.542993',33,33,NULL,'a0691e82-6ec5-46ce-9c29-c01dccfc3ff3',3,'30e995746f0346cc925a4e4d291b4b4b','shares',1,'2025-12-05 10:39:25','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:25.523390',NULL,'2025-12-04 10:39:25.542993',34,34,NULL,'7a03ab2c-c6fb-4004-8d9b-3eb0d6585065',4,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',1,'2025-12-05 10:39:25','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:26.356927',NULL,'2025-12-04 10:39:26.413987',35,35,'28d021876b6d47e6bb3cbf1d91fe3cfc','e6ef0e83-cb18-4500-ae3b-d6041970fead',6,'fdf8cc9e5d484c87979d04086aa3299b','shares',-1,'2025-12-05 10:39:26',NULL),('2025-12-04 10:39:26.357652',NULL,'2025-12-04 10:39:26.413987',36,36,'28d021876b6d47e6bb3cbf1d91fe3cfc','ad2ec1cd-1bdd-4904-a622-8f12bde0b0c3',5,'fdf8cc9e5d484c87979d04086aa3299b','gigabytes',-1,'2025-12-05 10:39:26',NULL),('2025-12-04 10:39:26.383685',NULL,'2025-12-04 10:39:26.413987',37,37,NULL,'127eca18-fd1a-4acf-9c9f-776af4a13b71',8,'fdf8cc9e5d484c87979d04086aa3299b','shares',-1,'2025-12-05 10:39:26','703ba806-b6aa-4733-8c75-4e18892fffb1'),('2025-12-04 10:39:26.384393',NULL,'2025-12-04 10:39:26.413987',38,38,NULL,'164bd599-27bf-4340-9593-4a6c08db6e1f',7,'fdf8cc9e5d484c87979d04086aa3299b','gigabytes',-1,'2025-12-05 10:39:26','703ba806-b6aa-4733-8c75-4e18892fffb1'),('2025-12-04 10:39:28.073569',NULL,'2025-12-04 10:39:28.141190',39,39,'9382d7467f084a7daaf3852289dd7e55','113a451c-0c71-41a9-ac99-1d83af83a491',18,'1a11c9942929435599f0a51c3f690b44','shares',1,'2025-12-05 10:39:28',NULL),('2025-12-04 10:39:28.074712',NULL,'2025-12-04 10:39:28.141190',40,40,'9382d7467f084a7daaf3852289dd7e55','fbdfb2cd-385f-4402-9732-3d7abe060b55',17,'1a11c9942929435599f0a51c3f690b44','gigabytes',1,'2025-12-05 10:39:28',NULL),('2025-12-04 10:39:28.117439',NULL,'2025-12-04 10:39:28.141190',41,41,NULL,'ac86cc23-23d6-4780-adb4-fe8133aa3ffa',20,'1a11c9942929435599f0a51c3f690b44','shares',1,'2025-12-05 10:39:28','fad6562a-6c8b-4475-a01e-8a7d1d4a728b'),('2025-12-04 10:39:28.119020',NULL,'2025-12-04 10:39:28.141190',42,42,NULL,'ee6371f5-0377-4981-ba05-420f9386055b',19,'1a11c9942929435599f0a51c3f690b44','gigabytes',1,'2025-12-05 10:39:28','fad6562a-6c8b-4475-a01e-8a7d1d4a728b'),('2025-12-04 10:39:28.211119',NULL,'2025-12-04 10:39:28.255804',43,43,'9565e2931ca045c2aff04912e5c4ba5b','86300e3c-bf42-47e9-ad4c-57c2a7c28e38',22,'a0e02e0e62364d9a86c7e7040e755187','shares',1,'2025-12-05 10:39:28',NULL),('2025-12-04 10:39:28.212354',NULL,'2025-12-04 10:39:28.255804',44,44,'9565e2931ca045c2aff04912e5c4ba5b','1cfac3f8-595e-4936-aeb1-01dda8537e05',21,'a0e02e0e62364d9a86c7e7040e755187','gigabytes',1,'2025-12-05 10:39:28',NULL),('2025-12-04 10:39:28.226835',NULL,'2025-12-04 10:39:28.255804',45,45,NULL,'b74da85d-41cf-4e4d-8ce2-76f846efd5c4',24,'a0e02e0e62364d9a86c7e7040e755187','shares',1,'2025-12-05 10:39:28','c8b2d54e-9dae-4635-aff6-dcbbe64d4236'),('2025-12-04 10:39:28.231719',NULL,'2025-12-04 10:39:28.255804',46,46,NULL,'af201285-f0f7-4a41-8db4-1c79320a0dc4',23,'a0e02e0e62364d9a86c7e7040e755187','gigabytes',1,'2025-12-05 10:39:28','c8b2d54e-9dae-4635-aff6-dcbbe64d4236'),('2025-12-04 10:39:29.071079',NULL,'2025-12-04 10:39:29.438161',47,47,'d2380cdaae7840a7aa1016a0c2242ad2','2b11d520-dffc-4ba2-9ef4-39f9c8fdfaef',2,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',1,'2025-12-05 10:39:29',NULL),('2025-12-04 10:39:29.092889',NULL,'2025-12-04 10:39:29.438161',48,48,NULL,'9fe6dc63-d040-45bb-aafe-e41ea34fd31b',4,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',1,'2025-12-05 10:39:29','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:30.914570',NULL,'2025-12-04 10:39:30.948709',49,49,'d2380cdaae7840a7aa1016a0c2242ad2','5150b9f4-92ad-419a-a133-c3d7da8b5f56',1,'30e995746f0346cc925a4e4d291b4b4b','shares',-1,'2025-12-05 10:39:30',NULL),('2025-12-04 10:39:30.915352',NULL,'2025-12-04 10:39:30.948709',50,50,'d2380cdaae7840a7aa1016a0c2242ad2','9ee5e5de-0710-4e2f-80c2-c4d09a3ca7e1',2,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',-2,'2025-12-05 10:39:30',NULL),('2025-12-04 10:39:30.938360',NULL,'2025-12-04 10:39:30.948709',51,51,NULL,'9b6f78f6-2039-43ef-809a-3ead549eb61d',3,'30e995746f0346cc925a4e4d291b4b4b','shares',-1,'2025-12-05 10:39:30','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:30.939541',NULL,'2025-12-04 10:39:30.948709',52,52,NULL,'348f4197-2b2f-47bb-bd0b-c1d9df774d05',4,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',-2,'2025-12-05 10:39:30','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:31.742485',NULL,'2025-12-04 10:39:31.911809',53,53,'9382d7467f084a7daaf3852289dd7e55','443bade0-05e4-41b2-a5ac-441323554aec',25,'1a11c9942929435599f0a51c3f690b44','snapshots',1,'2025-12-05 10:39:31',NULL),('2025-12-04 10:39:31.743902',NULL,'2025-12-04 10:39:31.911809',54,54,'9382d7467f084a7daaf3852289dd7e55','50bd21b1-10db-4f43-8a35-63c888d75683',26,'1a11c9942929435599f0a51c3f690b44','snapshot_gigabytes',1,'2025-12-05 10:39:31',NULL),('2025-12-04 10:39:31.769140',NULL,'2025-12-04 10:39:31.911809',55,55,NULL,'2474c54a-c83c-4489-ad09-36d70c0ad3e2',27,'1a11c9942929435599f0a51c3f690b44','snapshots',1,'2025-12-05 10:39:31','fad6562a-6c8b-4475-a01e-8a7d1d4a728b'),('2025-12-04 10:39:31.770367',NULL,'2025-12-04 10:39:31.911809',56,56,NULL,'2a728168-0e72-4658-84ce-6098090bb753',28,'1a11c9942929435599f0a51c3f690b44','snapshot_gigabytes',1,'2025-12-05 10:39:31','fad6562a-6c8b-4475-a01e-8a7d1d4a728b'),('2025-12-04 10:39:33.930190',NULL,'2025-12-04 10:39:33.992474',57,57,'d2380cdaae7840a7aa1016a0c2242ad2','e2e3b84b-d163-4bd6-8236-e5ca57971045',1,'30e995746f0346cc925a4e4d291b4b4b','shares',1,'2025-12-05 10:39:33',NULL),('2025-12-04 10:39:33.932494',NULL,'2025-12-04 10:39:33.992474',58,58,'d2380cdaae7840a7aa1016a0c2242ad2','4593e52b-8ed5-4d96-8615-5cec672baefc',2,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',1,'2025-12-05 10:39:33',NULL),('2025-12-04 10:39:33.954696',NULL,'2025-12-04 10:39:33.992474',59,59,NULL,'0f98643c-ec78-4029-98eb-5116a25de1bf',3,'30e995746f0346cc925a4e4d291b4b4b','shares',1,'2025-12-05 10:39:33','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:33.956211',NULL,'2025-12-04 10:39:33.992474',60,60,NULL,'9a765e74-dc65-481e-b6ce-34737da1ab8c',4,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',1,'2025-12-05 10:39:33','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:34.227664',NULL,'2025-12-04 10:39:34.381983',61,61,'9565e2931ca045c2aff04912e5c4ba5b','eb320f3a-3912-4140-923b-dbda5c45fb99',22,'a0e02e0e62364d9a86c7e7040e755187','shares',-1,'2025-12-05 10:39:34',NULL),('2025-12-04 10:39:34.229307',NULL,'2025-12-04 10:39:34.381983',62,62,'9565e2931ca045c2aff04912e5c4ba5b','487a504c-a612-4753-855a-f1e1a1b5ecd5',21,'a0e02e0e62364d9a86c7e7040e755187','gigabytes',-1,'2025-12-05 10:39:34',NULL),('2025-12-04 10:39:34.243016',NULL,'2025-12-04 10:39:34.381983',63,63,NULL,'152344ce-851d-4abb-a060-b37a1c5050f9',24,'a0e02e0e62364d9a86c7e7040e755187','shares',-1,'2025-12-05 10:39:34','c8b2d54e-9dae-4635-aff6-dcbbe64d4236'),('2025-12-04 10:39:34.244437',NULL,'2025-12-04 10:39:34.381983',64,64,NULL,'af0d829d-11ce-495f-be88-1062f3226b99',23,'a0e02e0e62364d9a86c7e7040e755187','gigabytes',-1,'2025-12-05 10:39:34','c8b2d54e-9dae-4635-aff6-dcbbe64d4236'),('2025-12-04 10:39:38.362034',NULL,'2025-12-04 10:39:38.382899',65,65,'d2380cdaae7840a7aa1016a0c2242ad2','554d29bd-4414-421f-9cf9-e57cbb5f4d60',1,'30e995746f0346cc925a4e4d291b4b4b','shares',-1,'2025-12-05 10:39:38',NULL),('2025-12-04 10:39:38.362997',NULL,'2025-12-04 10:39:38.382899',66,66,'d2380cdaae7840a7aa1016a0c2242ad2','0515f612-7cca-4f5d-ae93-a6253c3a38b4',2,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',-1,'2025-12-05 10:39:38',NULL),('2025-12-04 10:39:38.371898',NULL,'2025-12-04 10:39:38.382899',67,67,NULL,'82d1fb36-2e56-4ed8-b829-00672f6aee84',3,'30e995746f0346cc925a4e4d291b4b4b','shares',-1,'2025-12-05 10:39:38','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:38.374508',NULL,'2025-12-04 10:39:38.382899',68,68,NULL,'ba792d95-6dee-4839-87d6-efa3297320e2',4,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',-1,'2025-12-05 10:39:38','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:41.481097',NULL,'2025-12-04 10:39:41.518383',69,69,'d2380cdaae7840a7aa1016a0c2242ad2','2dff76bc-a34f-49de-a046-cc051615fde8',1,'30e995746f0346cc925a4e4d291b4b4b','shares',1,'2025-12-05 10:39:41',NULL),('2025-12-04 10:39:41.485476',NULL,'2025-12-04 10:39:41.518383',70,70,'d2380cdaae7840a7aa1016a0c2242ad2','b329631e-0ddd-40c3-a57d-3fdd11af17f2',2,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',1,'2025-12-05 10:39:41',NULL),('2025-12-04 10:39:41.492884',NULL,'2025-12-04 10:39:41.518383',71,71,NULL,'6b1ad548-f1e3-4727-8220-7b508717b110',3,'30e995746f0346cc925a4e4d291b4b4b','shares',1,'2025-12-05 10:39:41','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:41.495965',NULL,'2025-12-04 10:39:41.518383',72,72,NULL,'bf8a0ef7-ddbb-4498-95b3-61a538e55589',4,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',1,'2025-12-05 10:39:41','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:46.997604',NULL,'2025-12-04 10:39:47.027911',73,73,'d2380cdaae7840a7aa1016a0c2242ad2','4fb8b7cd-fb15-4403-9b10-ba8f001affc7',1,'30e995746f0346cc925a4e4d291b4b4b','shares',-1,'2025-12-05 10:39:46',NULL),('2025-12-04 10:39:46.998410',NULL,'2025-12-04 10:39:47.027911',74,74,'d2380cdaae7840a7aa1016a0c2242ad2','c4020640-415f-4267-8f67-de3d04dbf040',2,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',-1,'2025-12-05 10:39:46',NULL),('2025-12-04 10:39:47.008456',NULL,'2025-12-04 10:39:47.027911',75,75,NULL,'d96d9f46-5e33-4e46-b4aa-8ea1f30066a2',3,'30e995746f0346cc925a4e4d291b4b4b','shares',-1,'2025-12-05 10:39:46','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:47.009347',NULL,'2025-12-04 10:39:47.027911',76,76,NULL,'de967713-a51a-492e-b169-65f87ff738fc',4,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',-1,'2025-12-05 10:39:46','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:50.366075',NULL,'2025-12-04 10:39:50.493655',77,77,'d2380cdaae7840a7aa1016a0c2242ad2','dc5a175e-1cf5-45a0-a80e-8fdf39662ea9',29,'30e995746f0346cc925a4e4d291b4b4b','snapshots',1,'2025-12-05 10:39:50',NULL),('2025-12-04 10:39:50.369793',NULL,'2025-12-04 10:39:50.493655',78,78,'d2380cdaae7840a7aa1016a0c2242ad2','392007ab-efa9-4be4-b649-132897d64220',30,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',1,'2025-12-05 10:39:50',NULL),('2025-12-04 10:39:50.387746',NULL,'2025-12-04 10:39:50.493655',79,79,NULL,'03e2ce5e-ac25-4fac-b110-9ddfbf30b45c',31,'30e995746f0346cc925a4e4d291b4b4b','snapshots',1,'2025-12-05 10:39:50','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:50.391131',NULL,'2025-12-04 10:39:50.493655',80,80,NULL,'379c226b-313e-4fe8-87bf-c83e4f95597c',32,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',1,'2025-12-05 10:39:50','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:50.640705',NULL,'2025-12-04 10:39:50.725895',81,81,'30def06ddfcb4491be841cb17e5f182e','33daa477-6308-402f-91ab-4de164ecb20a',33,'246f1169a6af4a34902c2aa68c00782b','share_networks',1,'2025-12-05 10:39:50',NULL),('2025-12-04 10:39:51.247524',NULL,'2025-12-04 10:39:51.292195',82,82,'045d5e64586a450cb2f94b31c74861bb','09e6d260-dc25-4b09-baf7-5cba94207c99',34,'05c8461a124b4addbb681e5898e482e5','share_networks',1,'2025-12-05 10:39:51',NULL),('2025-12-04 10:39:51.600117',NULL,'2025-12-04 10:39:51.645283',83,83,'9382d7467f084a7daaf3852289dd7e55','dec8c149-8064-4914-abdb-8386817aa579',35,'1a11c9942929435599f0a51c3f690b44','snapshots',-1,'2025-12-05 10:39:51',NULL),('2025-12-04 10:39:51.601329',NULL,'2025-12-04 10:39:51.645283',84,84,'9382d7467f084a7daaf3852289dd7e55','43048c16-aabd-4245-80b8-fff0587a44fb',36,'1a11c9942929435599f0a51c3f690b44','snapshot_gigabytes',-1,'2025-12-05 10:39:51',NULL),('2025-12-04 10:39:51.624889',NULL,'2025-12-04 10:39:51.645283',85,85,NULL,'ccf84540-12ce-498e-af1f-e05ac2fd4530',37,'1a11c9942929435599f0a51c3f690b44','snapshots',-1,'2025-12-05 10:39:51','fad6562a-6c8b-4475-a01e-8a7d1d4a728b'),('2025-12-04 10:39:51.626689',NULL,'2025-12-04 10:39:51.645283',86,86,NULL,'245ea375-507f-468d-b1dd-96a01de7e4a5',38,'1a11c9942929435599f0a51c3f690b44','snapshot_gigabytes',-1,'2025-12-05 10:39:51','fad6562a-6c8b-4475-a01e-8a7d1d4a728b'),('2025-12-04 10:39:51.751541',NULL,'2025-12-04 10:39:51.774047',87,87,'d2380cdaae7840a7aa1016a0c2242ad2','73b5ef80-8d1d-40f0-a27c-0ddd864581c2',29,'30e995746f0346cc925a4e4d291b4b4b','snapshots',-1,'2025-12-05 10:39:51',NULL),('2025-12-04 10:39:51.752651',NULL,'2025-12-04 10:39:51.774047',88,88,'d2380cdaae7840a7aa1016a0c2242ad2','195d8f4b-35a5-42b1-92f1-bb7efd8eb08d',30,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',-1,'2025-12-05 10:39:51',NULL),('2025-12-04 10:39:51.759548',NULL,'2025-12-04 10:39:51.774047',89,89,NULL,'1ae7895b-8116-4129-b9bb-c12bc1ad89ba',31,'30e995746f0346cc925a4e4d291b4b4b','snapshots',-1,'2025-12-05 10:39:51','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:51.762268',NULL,'2025-12-04 10:39:51.774047',90,90,NULL,'30e5484b-d396-4b86-941a-416902259ea9',32,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',-1,'2025-12-05 10:39:51','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:39:54.029695',NULL,'2025-12-04 10:39:54.036816',91,91,'30def06ddfcb4491be841cb17e5f182e','56b3b24a-43c9-4313-aa20-383bb86d1463',33,'246f1169a6af4a34902c2aa68c00782b','share_networks',-1,'2025-12-05 10:39:54',NULL),('2025-12-04 10:39:54.157193',NULL,'2025-12-04 10:39:54.197498',92,92,'4450ef386c064ec8865c3f5640993885','19392746-cd2c-4dbb-9cf9-931377c30fa1',40,'bc4567fbe8fa43ebb22d7433659a15be','shares',1,'2025-12-05 10:39:54',NULL),('2025-12-04 10:39:54.158365',NULL,'2025-12-04 10:39:54.197498',93,93,'4450ef386c064ec8865c3f5640993885','7e51a6ab-a804-4579-a750-10df64d09ff0',39,'bc4567fbe8fa43ebb22d7433659a15be','gigabytes',4,'2025-12-05 10:39:54',NULL),('2025-12-04 10:39:54.169633',NULL,'2025-12-04 10:39:54.197498',94,94,NULL,'591ce209-ba57-48f2-8c79-15be1233081b',42,'bc4567fbe8fa43ebb22d7433659a15be','shares',1,'2025-12-05 10:39:54','fbfa7e24-ec90-46ae-a6e9-92f64f43ac9c'),('2025-12-04 10:39:54.170968',NULL,'2025-12-04 10:39:54.197498',95,95,NULL,'073a6a9f-038c-4a63-8ab0-af7176711f25',41,'bc4567fbe8fa43ebb22d7433659a15be','gigabytes',4,'2025-12-05 10:39:54','fbfa7e24-ec90-46ae-a6e9-92f64f43ac9c'),('2025-12-04 10:39:55.150758',NULL,'2025-12-04 10:39:55.187012',96,96,'9382d7467f084a7daaf3852289dd7e55','e619e7f6-a020-4f3d-bf8f-15d7106df7ff',43,'1a11c9942929435599f0a51c3f690b44','shares',-1,'2025-12-05 10:39:55',NULL),('2025-12-04 10:39:55.151701',NULL,'2025-12-04 10:39:55.187012',97,97,'9382d7467f084a7daaf3852289dd7e55','004a7cd1-e518-4400-a23b-44f05827d9d0',44,'1a11c9942929435599f0a51c3f690b44','gigabytes',-1,'2025-12-05 10:39:55',NULL),('2025-12-04 10:39:55.175293',NULL,'2025-12-04 10:39:55.187012',98,98,NULL,'4bf556be-2577-4333-8dcc-2129f64f27be',45,'1a11c9942929435599f0a51c3f690b44','shares',-1,'2025-12-05 10:39:55','fad6562a-6c8b-4475-a01e-8a7d1d4a728b'),('2025-12-04 10:39:55.176210',NULL,'2025-12-04 10:39:55.187012',99,99,NULL,'5c432831-0a9d-4725-bb5f-4ddc619b39e9',46,'1a11c9942929435599f0a51c3f690b44','gigabytes',-1,'2025-12-05 10:39:55','fad6562a-6c8b-4475-a01e-8a7d1d4a728b'),('2025-12-04 10:39:57.671466',NULL,'2025-12-04 10:39:57.687840',100,100,'4450ef386c064ec8865c3f5640993885','168d0591-805d-452c-935b-0c897069353f',40,'bc4567fbe8fa43ebb22d7433659a15be','shares',1,'2025-12-05 10:39:57',NULL),('2025-12-04 10:39:57.676457',NULL,'2025-12-04 10:39:57.687840',101,101,'4450ef386c064ec8865c3f5640993885','89ef2a24-fb91-4496-b367-c9eea38e3596',39,'bc4567fbe8fa43ebb22d7433659a15be','gigabytes',3,'2025-12-05 10:39:57',NULL),('2025-12-04 10:39:57.905372',NULL,'2025-12-04 10:39:57.953452',102,102,'4450ef386c064ec8865c3f5640993885','a7591795-ec29-4c0a-8982-e29bce77eca9',40,'bc4567fbe8fa43ebb22d7433659a15be','shares',1,'2025-12-05 10:39:57',NULL),('2025-12-04 10:39:57.907063',NULL,'2025-12-04 10:39:57.953452',103,103,'4450ef386c064ec8865c3f5640993885','499ac2ba-c8fb-4644-a452-074aea339eeb',39,'bc4567fbe8fa43ebb22d7433659a15be','gigabytes',3,'2025-12-05 10:39:57',NULL),('2025-12-04 10:39:57.926573',NULL,'2025-12-04 10:39:57.953452',104,104,NULL,'b9b54c98-d0c3-46ea-bbef-48a9daa47161',47,'bc4567fbe8fa43ebb22d7433659a15be','shares',1,'2025-12-05 10:39:57','110b6a77-eee0-4f8c-ab3d-25dd7aa6b52e'),('2025-12-04 10:39:57.929062',NULL,'2025-12-04 10:39:57.953452',105,105,NULL,'d6e8f185-c6f9-4bc7-ad25-070c1aa80fe7',48,'bc4567fbe8fa43ebb22d7433659a15be','gigabytes',3,'2025-12-05 10:39:57','110b6a77-eee0-4f8c-ab3d-25dd7aa6b52e'),('2025-12-04 10:39:58.824481',NULL,'2025-12-04 10:39:58.849761',106,106,'9382d7467f084a7daaf3852289dd7e55','787e021f-f512-4a06-8427-45774db981bf',43,'1a11c9942929435599f0a51c3f690b44','shares',-1,'2025-12-05 10:39:58',NULL),('2025-12-04 10:39:58.825489',NULL,'2025-12-04 10:39:58.849761',107,107,'9382d7467f084a7daaf3852289dd7e55','afbc242d-1fa0-4b13-aa7a-594322d666e4',44,'1a11c9942929435599f0a51c3f690b44','gigabytes',-1,'2025-12-05 10:39:58',NULL),('2025-12-04 10:39:58.838559',NULL,'2025-12-04 10:39:58.849761',108,108,NULL,'9760fc28-85a7-4fb7-aade-e68484b2c229',49,'1a11c9942929435599f0a51c3f690b44','shares',-1,'2025-12-05 10:39:58','f9c9ca5f-6992-4730-8113-73ad975de651'),('2025-12-04 10:39:58.839190',NULL,'2025-12-04 10:39:58.849761',109,109,NULL,'6dfa4a52-bf20-4659-bb8e-5b4ee888b75d',50,'1a11c9942929435599f0a51c3f690b44','gigabytes',-1,'2025-12-05 10:39:58','f9c9ca5f-6992-4730-8113-73ad975de651'),('2025-12-04 10:40:00.203170',NULL,'2025-12-04 10:40:00.319178',110,110,'d2380cdaae7840a7aa1016a0c2242ad2','7b4d0238-8a2e-49e0-8b59-69ff326a74aa',29,'30e995746f0346cc925a4e4d291b4b4b','snapshots',1,'2025-12-05 10:40:00',NULL),('2025-12-04 10:40:00.205762',NULL,'2025-12-04 10:40:00.319178',111,111,'d2380cdaae7840a7aa1016a0c2242ad2','d3d0510a-4a25-43f6-a5b9-94c45eb427c3',30,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',1,'2025-12-05 10:40:00',NULL),('2025-12-04 10:40:00.221779',NULL,'2025-12-04 10:40:00.319178',112,112,NULL,'cc078140-cd9d-4324-9fe2-392af2ff351e',31,'30e995746f0346cc925a4e4d291b4b4b','snapshots',1,'2025-12-05 10:40:00','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:40:00.223360',NULL,'2025-12-04 10:40:00.319178',113,113,NULL,'3677c034-b223-44b0-af85-da6cdc0ebe30',32,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',1,'2025-12-05 10:40:00','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:40:02.506552',NULL,'2025-12-04 10:40:02.673737',114,114,'4450ef386c064ec8865c3f5640993885','e9cd7345-d14c-4a5c-83f4-596fbed1a171',40,'bc4567fbe8fa43ebb22d7433659a15be','shares',-1,'2025-12-05 10:40:02',NULL),('2025-12-04 10:40:02.507323',NULL,'2025-12-04 10:40:02.673737',115,115,'4450ef386c064ec8865c3f5640993885','3a6da09d-f48e-47a4-8cb4-5d9a25c55aee',39,'bc4567fbe8fa43ebb22d7433659a15be','gigabytes',-4,'2025-12-05 10:40:02',NULL),('2025-12-04 10:40:02.659167',NULL,'2025-12-04 10:40:02.673737',116,116,NULL,'abf63d3e-0611-456a-9153-de0e9ff29bf1',42,'bc4567fbe8fa43ebb22d7433659a15be','shares',-1,'2025-12-05 10:40:02','fbfa7e24-ec90-46ae-a6e9-92f64f43ac9c'),('2025-12-04 10:40:02.660260',NULL,'2025-12-04 10:40:02.673737',117,117,NULL,'5564d679-d1ff-4c66-a8ef-0d0d4458de07',41,'bc4567fbe8fa43ebb22d7433659a15be','gigabytes',-4,'2025-12-05 10:40:02','fbfa7e24-ec90-46ae-a6e9-92f64f43ac9c'),('2025-12-04 10:40:04.415396',NULL,'2025-12-04 10:40:04.503913',118,118,'d2380cdaae7840a7aa1016a0c2242ad2','abb42b51-a584-4c45-a1f1-f0f77cc84d83',29,'30e995746f0346cc925a4e4d291b4b4b','snapshots',1,'2025-12-05 10:40:04',NULL),('2025-12-04 10:40:04.416902',NULL,'2025-12-04 10:40:04.503913',119,119,'d2380cdaae7840a7aa1016a0c2242ad2','13047d33-ee7d-4f81-ad5f-b9f2a01d631e',30,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',1,'2025-12-05 10:40:04',NULL),('2025-12-04 10:40:04.427949',NULL,'2025-12-04 10:40:04.503913',120,120,NULL,'f6d399a5-e5b2-4f57-a115-bba16cb409cb',31,'30e995746f0346cc925a4e4d291b4b4b','snapshots',1,'2025-12-05 10:40:04','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:40:04.430312',NULL,'2025-12-04 10:40:04.503913',121,121,NULL,'b578ac7c-9753-444b-8669-2e1d6dbd119b',32,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',1,'2025-12-05 10:40:04','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:40:06.191655',NULL,'2025-12-04 10:40:06.216736',122,122,'4450ef386c064ec8865c3f5640993885','35835dc3-5b49-4507-8c5d-e5dd295bb037',40,'bc4567fbe8fa43ebb22d7433659a15be','shares',-1,'2025-12-05 10:40:06',NULL),('2025-12-04 10:40:06.194010',NULL,'2025-12-04 10:40:06.216736',123,123,'4450ef386c064ec8865c3f5640993885','743942a9-412d-4824-a890-f47ad0ff570c',39,'bc4567fbe8fa43ebb22d7433659a15be','gigabytes',-3,'2025-12-05 10:40:06',NULL),('2025-12-04 10:40:06.208184',NULL,'2025-12-04 10:40:06.216736',124,124,NULL,'56a0e7a2-7932-4ced-9374-fbb46d9946bf',47,'bc4567fbe8fa43ebb22d7433659a15be','shares',-1,'2025-12-05 10:40:06','110b6a77-eee0-4f8c-ab3d-25dd7aa6b52e'),('2025-12-04 10:40:06.209303',NULL,'2025-12-04 10:40:06.216736',125,125,NULL,'6d5ef5e0-e48e-4336-94c1-169543988e5e',48,'bc4567fbe8fa43ebb22d7433659a15be','gigabytes',-3,'2025-12-05 10:40:06','110b6a77-eee0-4f8c-ab3d-25dd7aa6b52e'),('2025-12-04 10:40:06.498725',NULL,'2025-12-04 10:40:06.535607',126,126,'b0b74817f28a40638632c34de45c4b3a','d7439e68-63e5-49d7-83fd-2f052a4cb894',51,'ee36120fd1ef45478778db2f213d6c09','shares',1,'2025-12-05 10:40:06',NULL),('2025-12-04 10:40:06.499853',NULL,'2025-12-04 10:40:06.535607',127,127,'b0b74817f28a40638632c34de45c4b3a','137a6838-0c96-450d-9f24-0f7ad0ec5c88',52,'ee36120fd1ef45478778db2f213d6c09','gigabytes',1,'2025-12-05 10:40:06',NULL),('2025-12-04 10:40:06.515238',NULL,'2025-12-04 10:40:06.535607',128,128,NULL,'a466f3f3-9ddd-4540-b1f8-ea30f9a8f38d',53,'ee36120fd1ef45478778db2f213d6c09','shares',1,'2025-12-05 10:40:06','fbcd210b-f4b4-4f9a-b567-b1dd820eb42f'),('2025-12-04 10:40:06.516602',NULL,'2025-12-04 10:40:06.535607',129,129,NULL,'a3dcdae0-d680-4782-8080-cd35f2fdfae5',54,'ee36120fd1ef45478778db2f213d6c09','gigabytes',1,'2025-12-05 10:40:06','fbcd210b-f4b4-4f9a-b567-b1dd820eb42f'),('2025-12-04 10:40:08.470615',NULL,'2025-12-04 10:40:08.860680',130,130,'d2380cdaae7840a7aa1016a0c2242ad2','0046f111-b8d4-49e3-bf62-20ce2c742561',29,'30e995746f0346cc925a4e4d291b4b4b','snapshots',1,'2025-12-05 10:40:08',NULL),('2025-12-04 10:40:08.471994',NULL,'2025-12-04 10:40:08.860680',131,131,'d2380cdaae7840a7aa1016a0c2242ad2','f63f2feb-0aca-4168-a8f3-87369c5bd788',30,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',1,'2025-12-05 10:40:08',NULL),('2025-12-04 10:40:08.712514',NULL,'2025-12-04 10:40:08.860680',132,132,NULL,'750ae237-7cf7-4755-aac3-149e3f64fd1e',31,'30e995746f0346cc925a4e4d291b4b4b','snapshots',1,'2025-12-05 10:40:08','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:40:08.713801',NULL,'2025-12-04 10:40:08.860680',133,133,NULL,'01cfe83e-194e-4abb-8f83-ba6c08be56c5',32,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',1,'2025-12-05 10:40:08','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:40:11.027274',NULL,'2025-12-04 10:40:11.234232',134,134,'b0b74817f28a40638632c34de45c4b3a','4e30e7e4-ee78-4c7c-a3c2-0a197f821e91',51,'ee36120fd1ef45478778db2f213d6c09','shares',-1,'2025-12-05 10:40:10',NULL),('2025-12-04 10:40:11.028117',NULL,'2025-12-04 10:40:11.234232',135,135,'b0b74817f28a40638632c34de45c4b3a','8e4a4c41-744e-4c31-bc52-d10e7dd6c02e',52,'ee36120fd1ef45478778db2f213d6c09','gigabytes',-1,'2025-12-05 10:40:10',NULL),('2025-12-04 10:40:11.149858',NULL,'2025-12-04 10:40:11.234232',136,136,NULL,'da28e7e0-bcaa-4b22-834d-1f724dfb1a9b',53,'ee36120fd1ef45478778db2f213d6c09','shares',-1,'2025-12-05 10:40:10','fbcd210b-f4b4-4f9a-b567-b1dd820eb42f'),('2025-12-04 10:40:11.150669',NULL,'2025-12-04 10:40:11.234232',137,137,NULL,'afdc03d1-f05b-4137-8059-70ee5d5dea6a',54,'ee36120fd1ef45478778db2f213d6c09','gigabytes',-1,'2025-12-05 10:40:10','fbcd210b-f4b4-4f9a-b567-b1dd820eb42f'),('2025-12-04 10:40:12.510606',NULL,'2025-12-04 10:40:12.575453',138,138,'74c4687e9ade4a6382ce5c54f9bae971','a4933a3e-3503-47ec-b8f3-d22ecb35a989',56,'45b18e29190f4379945421b01e7eb293','shares',1,'2025-12-05 10:40:12',NULL),('2025-12-04 10:40:12.511887',NULL,'2025-12-04 10:40:12.575453',139,139,'74c4687e9ade4a6382ce5c54f9bae971','75df75df-7da8-4f07-9399-381a1674b22f',55,'45b18e29190f4379945421b01e7eb293','gigabytes',1,'2025-12-05 10:40:12',NULL),('2025-12-04 10:40:12.529481',NULL,'2025-12-04 10:40:12.575453',140,140,NULL,'3b24d785-848c-4c19-814b-5e1c4dacb06a',58,'45b18e29190f4379945421b01e7eb293','shares',1,'2025-12-05 10:40:12','4d11d944-cb21-4896-a25f-1f1bffe11b97'),('2025-12-04 10:40:12.530701',NULL,'2025-12-04 10:40:12.575453',141,141,NULL,'d5ba2d34-85cb-46a2-adb1-61f933f0df49',57,'45b18e29190f4379945421b01e7eb293','gigabytes',1,'2025-12-05 10:40:12','4d11d944-cb21-4896-a25f-1f1bffe11b97'),('2025-12-04 10:40:12.769174',NULL,'2025-12-04 10:40:12.850384',142,142,'d2380cdaae7840a7aa1016a0c2242ad2','fa935913-4487-496c-a726-e818b84db702',29,'30e995746f0346cc925a4e4d291b4b4b','snapshots',1,'2025-12-05 10:40:12',NULL),('2025-12-04 10:40:12.770690',NULL,'2025-12-04 10:40:12.850384',143,143,'d2380cdaae7840a7aa1016a0c2242ad2','16a3413c-0192-4600-ba33-79288c610919',30,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',1,'2025-12-05 10:40:12',NULL),('2025-12-04 10:40:12.781625',NULL,'2025-12-04 10:40:12.850384',144,144,NULL,'d5510ae1-a2d3-4200-9dfa-e245bbd5d6c2',31,'30e995746f0346cc925a4e4d291b4b4b','snapshots',1,'2025-12-05 10:40:12','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:40:12.782833',NULL,'2025-12-04 10:40:12.850384',145,145,NULL,'6f1695ff-cb06-4cc7-b2c5-520981cfb85f',32,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',1,'2025-12-05 10:40:12','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:40:16.073985',NULL,'2025-12-04 10:40:17.443684',146,146,'74c4687e9ade4a6382ce5c54f9bae971','8227bb5f-20e0-4a7d-a265-9f06a4aede8b',59,'45b18e29190f4379945421b01e7eb293','snapshots',1,'2025-12-05 10:40:16',NULL),('2025-12-04 10:40:16.075458',NULL,'2025-12-04 10:40:17.443684',147,147,'74c4687e9ade4a6382ce5c54f9bae971','d2f7f3ad-1240-4129-b649-f5f40a92ec17',60,'45b18e29190f4379945421b01e7eb293','snapshot_gigabytes',1,'2025-12-05 10:40:16',NULL),('2025-12-04 10:40:17.148522',NULL,'2025-12-04 10:40:17.443684',148,148,NULL,'f799567c-a3d2-4beb-8fcb-374541a5d69f',61,'45b18e29190f4379945421b01e7eb293','snapshots',1,'2025-12-05 10:40:16','4d11d944-cb21-4896-a25f-1f1bffe11b97'),('2025-12-04 10:40:17.151128',NULL,'2025-12-04 10:40:17.443684',149,149,NULL,'9add5064-a634-4cd5-8f0a-c185af54384d',62,'45b18e29190f4379945421b01e7eb293','snapshot_gigabytes',1,'2025-12-05 10:40:16','4d11d944-cb21-4896-a25f-1f1bffe11b97'),('2025-12-04 10:40:17.647871',NULL,'2025-12-04 10:40:17.758519',150,150,'d2380cdaae7840a7aa1016a0c2242ad2','a6a912bd-bd9e-4b1a-b261-f3a35e7c4fea',29,'30e995746f0346cc925a4e4d291b4b4b','snapshots',1,'2025-12-05 10:40:17',NULL),('2025-12-04 10:40:17.649612',NULL,'2025-12-04 10:40:17.758519',151,151,'d2380cdaae7840a7aa1016a0c2242ad2','613bf2c9-13a6-4bcf-870e-bc6dbd3c41f5',30,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',1,'2025-12-05 10:40:17',NULL),('2025-12-04 10:40:17.682591',NULL,'2025-12-04 10:40:17.758519',152,152,NULL,'c1b1e680-9218-4479-aeda-97df5ca95cd7',31,'30e995746f0346cc925a4e4d291b4b4b','snapshots',1,'2025-12-05 10:40:17','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:40:17.683849',NULL,'2025-12-04 10:40:17.758519',153,153,NULL,'96a27d05-9294-4144-b935-8228089f12d5',32,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',1,'2025-12-05 10:40:17','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:40:19.835870',NULL,'2025-12-04 10:40:19.880598',154,154,'a8ce0e9c3b1244659a5746807a574b35','bc1fee2f-b7fe-485c-96e1-8f31c9a7f2d4',64,'421364ebc3e041b392bf764a127cfda4','shares',1,'2025-12-05 10:40:19',NULL),('2025-12-04 10:40:19.837053',NULL,'2025-12-04 10:40:19.880598',155,155,'a8ce0e9c3b1244659a5746807a574b35','405da781-62a7-4ba2-8dfe-aaf9a7bf7421',63,'421364ebc3e041b392bf764a127cfda4','gigabytes',1,'2025-12-05 10:40:19',NULL),('2025-12-04 10:40:19.849651',NULL,'2025-12-04 10:40:19.880598',156,156,NULL,'26638953-cb0f-4ede-bc91-997c158a5d4d',66,'421364ebc3e041b392bf764a127cfda4','shares',1,'2025-12-05 10:40:19','9d536774-c83d-47c8-953e-f319caf6de44'),('2025-12-04 10:40:19.851139',NULL,'2025-12-04 10:40:19.880598',157,157,NULL,'9e15a807-bece-42a9-87ff-466f044c92e7',65,'421364ebc3e041b392bf764a127cfda4','gigabytes',1,'2025-12-05 10:40:19','9d536774-c83d-47c8-953e-f319caf6de44'),('2025-12-04 10:40:21.110210',NULL,'2025-12-04 10:40:21.158400',158,158,'74c4687e9ade4a6382ce5c54f9bae971','d92b3200-6ce2-484e-93ca-4b1b808b79eb',56,'45b18e29190f4379945421b01e7eb293','shares',1,'2025-12-05 10:40:21',NULL),('2025-12-04 10:40:21.111306',NULL,'2025-12-04 10:40:21.158400',159,159,'74c4687e9ade4a6382ce5c54f9bae971','1af4356f-bd6c-4eaa-b738-860f2eda9a46',55,'45b18e29190f4379945421b01e7eb293','gigabytes',1,'2025-12-05 10:40:21',NULL),('2025-12-04 10:40:21.123015',NULL,'2025-12-04 10:40:21.158400',160,160,NULL,'79364308-b31b-4d19-a38a-5547581684e3',58,'45b18e29190f4379945421b01e7eb293','shares',1,'2025-12-05 10:40:21','4d11d944-cb21-4896-a25f-1f1bffe11b97'),('2025-12-04 10:40:21.127336',NULL,'2025-12-04 10:40:21.158400',161,161,NULL,'42fc7a06-43dd-4efa-949a-11077518f379',57,'45b18e29190f4379945421b01e7eb293','gigabytes',1,'2025-12-05 10:40:21','4d11d944-cb21-4896-a25f-1f1bffe11b97'),('2025-12-04 10:40:22.636146',NULL,'2025-12-04 10:40:22.659202',162,162,'d2380cdaae7840a7aa1016a0c2242ad2','229c9c70-a746-4607-8e3a-342562afa41d',29,'30e995746f0346cc925a4e4d291b4b4b','snapshots',-1,'2025-12-05 10:40:22',NULL),('2025-12-04 10:40:22.637181',NULL,'2025-12-04 10:40:22.659202',163,163,'d2380cdaae7840a7aa1016a0c2242ad2','4d1de7f5-eb12-48fa-86cf-48e342c4acf0',30,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',-1,'2025-12-05 10:40:22',NULL),('2025-12-04 10:40:22.644996',NULL,'2025-12-04 10:40:22.659202',164,164,NULL,'afa730e9-b1e4-4319-afec-56ec179c8bb2',31,'30e995746f0346cc925a4e4d291b4b4b','snapshots',-1,'2025-12-05 10:40:22','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:40:22.648874',NULL,'2025-12-04 10:40:22.659202',165,165,NULL,'feda57fa-7c57-410d-b77f-724050fe3b0c',32,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',-1,'2025-12-05 10:40:22','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:40:23.354535',NULL,'2025-12-04 10:40:23.473492',166,166,'a8ce0e9c3b1244659a5746807a574b35','566780d7-353b-4714-8341-57ee9c38ddb7',67,'421364ebc3e041b392bf764a127cfda4','snapshots',1,'2025-12-05 10:40:23',NULL),('2025-12-04 10:40:23.355687',NULL,'2025-12-04 10:40:23.473492',167,167,'a8ce0e9c3b1244659a5746807a574b35','b65f28c7-d46c-44ea-8da7-5338c292e72b',68,'421364ebc3e041b392bf764a127cfda4','snapshot_gigabytes',1,'2025-12-05 10:40:23',NULL),('2025-12-04 10:40:23.370259',NULL,'2025-12-04 10:40:23.473492',168,168,NULL,'118e097b-b71c-4ab1-b9c3-3a7e1c98e6dd',69,'421364ebc3e041b392bf764a127cfda4','snapshots',1,'2025-12-05 10:40:23','9d536774-c83d-47c8-953e-f319caf6de44'),('2025-12-04 10:40:23.371910',NULL,'2025-12-04 10:40:23.473492',169,169,NULL,'47d6293c-f989-46f7-adfc-a0479a1d7b66',70,'421364ebc3e041b392bf764a127cfda4','snapshot_gigabytes',1,'2025-12-05 10:40:23','9d536774-c83d-47c8-953e-f319caf6de44'),('2025-12-04 10:40:25.915425',NULL,'2025-12-04 10:40:25.932012',170,170,'d2380cdaae7840a7aa1016a0c2242ad2','67aa2f65-ca05-4170-a230-b50c8ccd2fc5',29,'30e995746f0346cc925a4e4d291b4b4b','snapshots',-1,'2025-12-05 10:40:25',NULL),('2025-12-04 10:40:25.916292',NULL,'2025-12-04 10:40:25.932012',171,171,'d2380cdaae7840a7aa1016a0c2242ad2','04ccfc98-5679-4e2d-8a02-c502a76a52e9',30,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',-1,'2025-12-05 10:40:25',NULL),('2025-12-04 10:40:25.922381',NULL,'2025-12-04 10:40:25.932012',172,172,NULL,'0d6de010-dfe9-4f37-89e6-df559dc9b07f',31,'30e995746f0346cc925a4e4d291b4b4b','snapshots',-1,'2025-12-05 10:40:25','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:40:25.923264',NULL,'2025-12-04 10:40:25.932012',173,173,NULL,'5fb7a39e-dfa0-4c3d-ac6b-96a989b78e30',32,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',-1,'2025-12-05 10:40:25','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:40:27.659149',NULL,'2025-12-04 10:40:27.883795',174,174,'a8ce0e9c3b1244659a5746807a574b35','6b9df7d7-6a8b-4210-ba9e-1579764d3646',67,'421364ebc3e041b392bf764a127cfda4','snapshots',1,'2025-12-05 10:40:27',NULL),('2025-12-04 10:40:27.660775',NULL,'2025-12-04 10:40:27.883795',175,175,'a8ce0e9c3b1244659a5746807a574b35','4d543b0a-fb31-454f-8315-07127eab9cda',68,'421364ebc3e041b392bf764a127cfda4','snapshot_gigabytes',1,'2025-12-05 10:40:27',NULL),('2025-12-04 10:40:27.670458',NULL,'2025-12-04 10:40:27.883795',176,176,NULL,'7ce0dc2d-a819-401d-ad72-260f886b9154',69,'421364ebc3e041b392bf764a127cfda4','snapshots',1,'2025-12-05 10:40:27','9d536774-c83d-47c8-953e-f319caf6de44'),('2025-12-04 10:40:27.672425',NULL,'2025-12-04 10:40:27.883795',177,177,NULL,'86dbb4f2-3f1b-41bc-8afa-ca5d8c768d07',70,'421364ebc3e041b392bf764a127cfda4','snapshot_gigabytes',1,'2025-12-05 10:40:27','9d536774-c83d-47c8-953e-f319caf6de44'),('2025-12-04 10:40:28.312912',NULL,'2025-12-04 10:40:28.330305',178,178,'74c4687e9ade4a6382ce5c54f9bae971','4fa0cfb3-7ac5-4036-889e-58b0cd2b418b',56,'45b18e29190f4379945421b01e7eb293','shares',-1,'2025-12-05 10:40:28',NULL),('2025-12-04 10:40:28.313676',NULL,'2025-12-04 10:40:28.330305',179,179,'74c4687e9ade4a6382ce5c54f9bae971','114e4fc3-2ece-4a62-ac25-2f8b022ea83a',55,'45b18e29190f4379945421b01e7eb293','gigabytes',-1,'2025-12-05 10:40:28',NULL),('2025-12-04 10:40:28.320884',NULL,'2025-12-04 10:40:28.330305',180,180,NULL,'49fa8b81-0864-4e4b-86e2-f011dcccac45',58,'45b18e29190f4379945421b01e7eb293','shares',-1,'2025-12-05 10:40:28','4d11d944-cb21-4896-a25f-1f1bffe11b97'),('2025-12-04 10:40:28.321551',NULL,'2025-12-04 10:40:28.330305',181,181,NULL,'c917200d-6e0f-4c5b-b574-be1e4229f0a4',57,'45b18e29190f4379945421b01e7eb293','gigabytes',-1,'2025-12-05 10:40:28','4d11d944-cb21-4896-a25f-1f1bffe11b97'),('2025-12-04 10:40:28.748555',NULL,'2025-12-04 10:40:28.764887',182,182,'d2380cdaae7840a7aa1016a0c2242ad2','9db90385-fe35-4fc5-aadf-e63b68407f82',29,'30e995746f0346cc925a4e4d291b4b4b','snapshots',-1,'2025-12-05 10:40:28',NULL),('2025-12-04 10:40:28.749350',NULL,'2025-12-04 10:40:28.764887',183,183,'d2380cdaae7840a7aa1016a0c2242ad2','63d3197a-152a-4ea9-8115-27d5cc0b2d6c',30,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',-1,'2025-12-05 10:40:28',NULL),('2025-12-04 10:40:28.755974',NULL,'2025-12-04 10:40:28.764887',184,184,NULL,'219127f1-b577-4326-8da9-65001b0b1ee5',31,'30e995746f0346cc925a4e4d291b4b4b','snapshots',-1,'2025-12-05 10:40:28','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:40:28.756840',NULL,'2025-12-04 10:40:28.764887',185,185,NULL,'4f1b9929-f4f0-4501-8856-866032e7fd5b',32,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',-1,'2025-12-05 10:40:28','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:40:31.739060',NULL,'2025-12-04 10:40:31.755477',186,186,'74c4687e9ade4a6382ce5c54f9bae971','24a00495-33b1-4585-9034-35fe9379a69a',59,'45b18e29190f4379945421b01e7eb293','snapshots',-1,'2025-12-05 10:40:31',NULL),('2025-12-04 10:40:31.740373',NULL,'2025-12-04 10:40:31.755477',187,187,'74c4687e9ade4a6382ce5c54f9bae971','390321e9-8c9d-42c9-bcb9-6703445104a9',60,'45b18e29190f4379945421b01e7eb293','snapshot_gigabytes',-1,'2025-12-05 10:40:31',NULL),('2025-12-04 10:40:31.746750',NULL,'2025-12-04 10:40:31.755477',188,188,NULL,'a64485a8-b396-46ff-9d42-bd40accf6589',61,'45b18e29190f4379945421b01e7eb293','snapshots',-1,'2025-12-05 10:40:31','4d11d944-cb21-4896-a25f-1f1bffe11b97'),('2025-12-04 10:40:31.747506',NULL,'2025-12-04 10:40:31.755477',189,189,NULL,'967999ee-c68e-4836-bc2f-e7d0bba34346',62,'45b18e29190f4379945421b01e7eb293','snapshot_gigabytes',-1,'2025-12-05 10:40:31','4d11d944-cb21-4896-a25f-1f1bffe11b97'),('2025-12-04 10:40:32.332013',NULL,'2025-12-04 10:40:32.357484',190,190,'d2380cdaae7840a7aa1016a0c2242ad2','0d9dec33-9962-49c4-bbec-2485aaec32c4',29,'30e995746f0346cc925a4e4d291b4b4b','snapshots',-1,'2025-12-05 10:40:32',NULL),('2025-12-04 10:40:32.333441',NULL,'2025-12-04 10:40:32.357484',191,191,'d2380cdaae7840a7aa1016a0c2242ad2','6a0ae243-3200-4653-9408-69efe9cf548c',30,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',-1,'2025-12-05 10:40:32',NULL),('2025-12-04 10:40:32.340901',NULL,'2025-12-04 10:40:32.369354',192,192,'a8ce0e9c3b1244659a5746807a574b35','e3fa87ca-dec0-4720-a0bc-9c692246c5ff',67,'421364ebc3e041b392bf764a127cfda4','snapshots',-1,'2025-12-05 10:40:32',NULL),('2025-12-04 10:40:32.344306',NULL,'2025-12-04 10:40:32.369354',193,193,'a8ce0e9c3b1244659a5746807a574b35','8ca4ed08-b784-4786-8e5b-e9f9bbf29dc3',68,'421364ebc3e041b392bf764a127cfda4','snapshot_gigabytes',-1,'2025-12-05 10:40:32',NULL),('2025-12-04 10:40:32.345434',NULL,'2025-12-04 10:40:32.357484',194,194,NULL,'c8157251-c910-4063-bb4e-76a4920ce556',31,'30e995746f0346cc925a4e4d291b4b4b','snapshots',-1,'2025-12-05 10:40:32','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:40:32.346443',NULL,'2025-12-04 10:40:32.357484',195,195,NULL,'1112c3bb-02bb-4d78-a8c5-8c7f14fbbf86',32,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',-1,'2025-12-05 10:40:32','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:40:32.356640',NULL,'2025-12-04 10:40:32.369354',196,196,NULL,'02ed3c42-b23c-41d8-b8f2-8a25d912904e',69,'421364ebc3e041b392bf764a127cfda4','snapshots',-1,'2025-12-05 10:40:32','9d536774-c83d-47c8-953e-f319caf6de44'),('2025-12-04 10:40:32.362373',NULL,'2025-12-04 10:40:32.369354',197,197,NULL,'c427251a-257c-4f7a-8315-24dfb61e700f',70,'421364ebc3e041b392bf764a127cfda4','snapshot_gigabytes',-1,'2025-12-05 10:40:32','9d536774-c83d-47c8-953e-f319caf6de44'),('2025-12-04 10:40:35.298712',NULL,'2025-12-04 10:40:35.318190',198,198,'74c4687e9ade4a6382ce5c54f9bae971','2dacfc3f-3853-4d71-98d5-70b0fab675ce',56,'45b18e29190f4379945421b01e7eb293','shares',-1,'2025-12-05 10:40:35',NULL),('2025-12-04 10:40:35.299513',NULL,'2025-12-04 10:40:35.318190',199,199,'74c4687e9ade4a6382ce5c54f9bae971','6521adb5-e5c4-4234-a283-5748d63d9cd9',55,'45b18e29190f4379945421b01e7eb293','gigabytes',-1,'2025-12-05 10:40:35',NULL),('2025-12-04 10:40:35.308083',NULL,'2025-12-04 10:40:35.318190',200,200,NULL,'39acb9ac-f1c8-4bba-aa40-2f535a625edd',58,'45b18e29190f4379945421b01e7eb293','shares',-1,'2025-12-05 10:40:35','4d11d944-cb21-4896-a25f-1f1bffe11b97'),('2025-12-04 10:40:35.309311',NULL,'2025-12-04 10:40:35.318190',201,201,NULL,'9abc89fb-2fdd-4ee3-9f6f-07547c2aeef2',57,'45b18e29190f4379945421b01e7eb293','gigabytes',-1,'2025-12-05 10:40:35','4d11d944-cb21-4896-a25f-1f1bffe11b97'),('2025-12-04 10:40:35.656821',NULL,'2025-12-04 10:40:35.688153',202,202,'d2380cdaae7840a7aa1016a0c2242ad2','d5772df2-c27d-4fc3-89cd-0611d9adac9b',29,'30e995746f0346cc925a4e4d291b4b4b','snapshots',-1,'2025-12-05 10:40:35',NULL),('2025-12-04 10:40:35.661794',NULL,'2025-12-04 10:40:35.688153',203,203,'d2380cdaae7840a7aa1016a0c2242ad2','128a60c8-7517-4552-aefa-88522c66f4ef',30,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',-1,'2025-12-05 10:40:35',NULL),('2025-12-04 10:40:35.670060',NULL,'2025-12-04 10:40:35.688153',204,204,NULL,'fe6b5ae7-e6f6-40ff-b581-3f7f521f0095',31,'30e995746f0346cc925a4e4d291b4b4b','snapshots',-1,'2025-12-05 10:40:35','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:40:35.673533',NULL,'2025-12-04 10:40:35.688153',205,205,NULL,'f3a626aa-48c9-4de7-9ca4-980158db4b0f',32,'30e995746f0346cc925a4e4d291b4b4b','snapshot_gigabytes',-1,'2025-12-05 10:40:35','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:40:35.811982',NULL,'2025-12-04 10:40:35.833771',206,206,'a8ce0e9c3b1244659a5746807a574b35','a92c1c96-e978-4627-aa21-b395cdc32d78',67,'421364ebc3e041b392bf764a127cfda4','snapshots',-1,'2025-12-05 10:40:35',NULL),('2025-12-04 10:40:35.812745',NULL,'2025-12-04 10:40:35.833771',207,207,'a8ce0e9c3b1244659a5746807a574b35','98845ae4-ae8b-4add-be9d-e8a150a5c534',68,'421364ebc3e041b392bf764a127cfda4','snapshot_gigabytes',-1,'2025-12-05 10:40:35',NULL),('2025-12-04 10:40:35.821790',NULL,'2025-12-04 10:40:35.833771',208,208,NULL,'0498d0e5-808c-471f-9ab5-86fc884a3061',69,'421364ebc3e041b392bf764a127cfda4','snapshots',-1,'2025-12-05 10:40:35','9d536774-c83d-47c8-953e-f319caf6de44'),('2025-12-04 10:40:35.822795',NULL,'2025-12-04 10:40:35.833771',209,209,NULL,'5b5ff0d2-f131-4d4e-960d-5e7382b506c3',70,'421364ebc3e041b392bf764a127cfda4','snapshot_gigabytes',-1,'2025-12-05 10:40:35','9d536774-c83d-47c8-953e-f319caf6de44'),('2025-12-04 10:40:38.777632',NULL,'2025-12-04 10:40:38.819353',210,210,'432be7864c2d41508547058364b0ef80','dd1347b5-e183-42ea-9fec-4396c8a098f9',72,'2b21e3f6c24d4eb39e6fedb5f78ec003','shares',1,'2025-12-05 10:40:38',NULL),('2025-12-04 10:40:38.779183',NULL,'2025-12-04 10:40:38.819353',211,211,'432be7864c2d41508547058364b0ef80','0ef5145f-fbc4-414a-b5c9-8765e0e37ed5',71,'2b21e3f6c24d4eb39e6fedb5f78ec003','gigabytes',1,'2025-12-05 10:40:38',NULL),('2025-12-04 10:40:38.790465',NULL,'2025-12-04 10:40:38.819353',212,212,NULL,'c7b484b9-3205-47cc-a4b3-ba8ff151a69c',74,'2b21e3f6c24d4eb39e6fedb5f78ec003','shares',1,'2025-12-05 10:40:38','f246ccbd-b6cd-4308-8680-879f81fe8e7d'),('2025-12-04 10:40:38.791792',NULL,'2025-12-04 10:40:38.819353',213,213,NULL,'400f25e7-4df6-4e13-858a-3f64333f4ed0',73,'2b21e3f6c24d4eb39e6fedb5f78ec003','gigabytes',1,'2025-12-05 10:40:38','f246ccbd-b6cd-4308-8680-879f81fe8e7d'),('2025-12-04 10:40:39.581874',NULL,'2025-12-04 10:40:39.636720',214,214,'a8ce0e9c3b1244659a5746807a574b35','3f5285fd-3c20-4555-a840-25a95fb6f35c',64,'421364ebc3e041b392bf764a127cfda4','shares',-1,'2025-12-05 10:40:39',NULL),('2025-12-04 10:40:39.583510',NULL,'2025-12-04 10:40:39.636720',215,215,'a8ce0e9c3b1244659a5746807a574b35','a182b937-f66c-4a44-87b6-88e0f25722ee',63,'421364ebc3e041b392bf764a127cfda4','gigabytes',-1,'2025-12-05 10:40:39',NULL),('2025-12-04 10:40:39.595189',NULL,'2025-12-04 10:40:39.636720',216,216,NULL,'56fd52b8-0ea8-40d5-99cc-921aa48c1168',66,'421364ebc3e041b392bf764a127cfda4','shares',-1,'2025-12-05 10:40:39','9d536774-c83d-47c8-953e-f319caf6de44'),('2025-12-04 10:40:39.596401',NULL,'2025-12-04 10:40:39.636720',217,217,NULL,'0305332e-d20d-4432-a0d2-48cdf8889c65',65,'421364ebc3e041b392bf764a127cfda4','gigabytes',-1,'2025-12-05 10:40:39','9d536774-c83d-47c8-953e-f319caf6de44'),('2025-12-04 10:40:39.723563',NULL,'2025-12-04 10:40:39.793121',218,218,'d2380cdaae7840a7aa1016a0c2242ad2','fbb9ef66-7f9a-4c16-ab20-1aff800245be',1,'30e995746f0346cc925a4e4d291b4b4b','shares',-1,'2025-12-05 10:40:39',NULL),('2025-12-04 10:40:39.724841',NULL,'2025-12-04 10:40:39.793121',219,219,'d2380cdaae7840a7aa1016a0c2242ad2','47c49a64-d2bd-4d81-836f-99f2ae6dd0ae',2,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',-1,'2025-12-05 10:40:39',NULL),('2025-12-04 10:40:39.733283',NULL,'2025-12-04 10:40:39.793121',220,220,NULL,'e700ecaa-289f-4c39-981e-2d508f9fb8a7',3,'30e995746f0346cc925a4e4d291b4b4b','shares',-1,'2025-12-05 10:40:39','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:40:39.734249',NULL,'2025-12-04 10:40:39.793121',221,221,NULL,'1c1336b9-16c2-4227-8671-f82d1e36508a',4,'30e995746f0346cc925a4e4d291b4b4b','gigabytes',-1,'2025-12-05 10:40:39','e25793d0-774e-4cdf-93f8-ead2edf48a79'),('2025-12-04 10:40:45.907040',NULL,'2025-12-04 10:40:45.934592',222,222,'432be7864c2d41508547058364b0ef80','f477f236-0d13-4097-a602-f9fc31a8585b',72,'2b21e3f6c24d4eb39e6fedb5f78ec003','shares',-1,'2025-12-05 10:40:45',NULL),('2025-12-04 10:40:45.907979',NULL,'2025-12-04 10:40:45.934592',223,223,'432be7864c2d41508547058364b0ef80','3a8e634e-7609-490e-a0e6-ff5b386c366f',71,'2b21e3f6c24d4eb39e6fedb5f78ec003','gigabytes',-1,'2025-12-05 10:40:45',NULL),('2025-12-04 10:40:45.924693',NULL,'2025-12-04 10:40:45.934592',224,224,NULL,'fd33f3ff-a9de-4e85-a03f-36713baf1618',74,'2b21e3f6c24d4eb39e6fedb5f78ec003','shares',-1,'2025-12-05 10:40:45','f246ccbd-b6cd-4308-8680-879f81fe8e7d'),('2025-12-04 10:40:45.925952',NULL,'2025-12-04 10:40:45.934592',225,225,NULL,'4d34a3f7-e19a-4ef0-b1e7-dcaf63f16527',73,'2b21e3f6c24d4eb39e6fedb5f78ec003','gigabytes',-1,'2025-12-05 10:40:45','f246ccbd-b6cd-4308-8680-879f81fe8e7d'),('2025-12-04 10:40:50.968789',NULL,'2025-12-04 10:40:51.050441',226,226,'b5d23f7e91694629931517a6c40efbe5','456f859d-2143-4272-8155-517fbfbfcee3',76,'54f365c11f8e40988b5a964504f91dd7','shares',1,'2025-12-05 10:40:50',NULL),('2025-12-04 10:40:50.970625',NULL,'2025-12-04 10:40:51.050441',227,227,'b5d23f7e91694629931517a6c40efbe5','a53624a9-1618-41a8-a0f4-c0b3717f71c4',75,'54f365c11f8e40988b5a964504f91dd7','gigabytes',1,'2025-12-05 10:40:50',NULL),('2025-12-04 10:40:51.005518',NULL,'2025-12-04 10:40:51.050441',228,228,NULL,'b168b57b-abe1-4202-b4c5-c87d8d6cf1bf',78,'54f365c11f8e40988b5a964504f91dd7','shares',1,'2025-12-05 10:40:50','d06feb78-408f-46b2-96af-3dfde13231d8'),('2025-12-04 10:40:51.006655',NULL,'2025-12-04 10:40:51.050441',229,229,NULL,'675728e1-c001-43f7-9a12-d98a5ed05e9f',77,'54f365c11f8e40988b5a964504f91dd7','gigabytes',1,'2025-12-05 10:40:50','d06feb78-408f-46b2-96af-3dfde13231d8'),('2025-12-04 10:40:51.361075',NULL,'2025-12-04 10:40:51.411308',230,230,'d62cbbb064cd4277b18c062e7f02e202','f0e8c888-e8e8-477d-950f-a22c0d1e5502',79,'f6c223a076bd42bd958c3294b89dc763','shares',1,'2025-12-05 10:40:51',NULL),('2025-12-04 10:40:51.362231',NULL,'2025-12-04 10:40:51.411308',231,231,'d62cbbb064cd4277b18c062e7f02e202','042d1ffb-4deb-46df-a2fd-7ef1d04352bb',80,'f6c223a076bd42bd958c3294b89dc763','gigabytes',1,'2025-12-05 10:40:51',NULL),('2025-12-04 10:40:51.379718',NULL,'2025-12-04 10:40:51.411308',232,232,NULL,'b39fc2a6-7deb-414b-8b31-e01e881af4a1',81,'f6c223a076bd42bd958c3294b89dc763','shares',1,'2025-12-05 10:40:51','3d827517-5ff1-48c1-8133-89cd1d41e9bd'),('2025-12-04 10:40:51.383311',NULL,'2025-12-04 10:40:51.411308',233,233,NULL,'f34c5d26-4bc0-4fd2-97a6-b520fc9c3f7c',82,'f6c223a076bd42bd958c3294b89dc763','gigabytes',1,'2025-12-05 10:40:51','3d827517-5ff1-48c1-8133-89cd1d41e9bd'),('2025-12-04 10:40:54.156954',NULL,'2025-12-04 10:40:54.230461',234,234,'346d2a3ba5e24df2a1417033f75e866e','61630e91-99df-4b1b-a707-657067ed2d5c',84,'de70f6413fb248c6a07e498350f7a8e3','shares',1,'2025-12-05 10:40:54',NULL),('2025-12-04 10:40:54.158048',NULL,'2025-12-04 10:40:54.230461',235,235,'346d2a3ba5e24df2a1417033f75e866e','cdd9d39f-6878-47c5-855f-ce53d1a311fd',83,'de70f6413fb248c6a07e498350f7a8e3','gigabytes',1,'2025-12-05 10:40:54',NULL),('2025-12-04 10:40:54.207092',NULL,'2025-12-04 10:40:54.230461',236,236,NULL,'12c02a74-36c4-45f0-9d42-521c894e12b8',86,'de70f6413fb248c6a07e498350f7a8e3','shares',1,'2025-12-05 10:40:54','ec0655e6-90b3-4d12-b523-1f54eacdc7a3'),('2025-12-04 10:40:54.208275',NULL,'2025-12-04 10:40:54.230461',237,237,NULL,'8f114efd-197e-4fdd-afd6-46524675db81',85,'de70f6413fb248c6a07e498350f7a8e3','gigabytes',1,'2025-12-05 10:40:54','ec0655e6-90b3-4d12-b523-1f54eacdc7a3'),('2025-12-04 10:40:54.967204',NULL,'2025-12-04 10:40:54.989513',238,238,'b5d23f7e91694629931517a6c40efbe5','d1dcb687-6f86-40bd-b18c-0b4dedcad813',76,'54f365c11f8e40988b5a964504f91dd7','shares',-1,'2025-12-05 10:40:54',NULL),('2025-12-04 10:40:54.968066',NULL,'2025-12-04 10:40:54.989513',239,239,'b5d23f7e91694629931517a6c40efbe5','33ddd491-4f52-4403-80a2-d22fd7ffdc88',75,'54f365c11f8e40988b5a964504f91dd7','gigabytes',-1,'2025-12-05 10:40:54',NULL),('2025-12-04 10:40:54.974144',NULL,'2025-12-04 10:40:54.989513',240,240,NULL,'bc651db7-7da8-4550-b5c2-5bdfd2a79098',78,'54f365c11f8e40988b5a964504f91dd7','shares',-1,'2025-12-05 10:40:54','d06feb78-408f-46b2-96af-3dfde13231d8'),('2025-12-04 10:40:54.974979',NULL,'2025-12-04 10:40:54.989513',241,241,NULL,'5a4d59d3-82fb-4249-9bde-0f90c7deff73',77,'54f365c11f8e40988b5a964504f91dd7','gigabytes',-1,'2025-12-05 10:40:54','d06feb78-408f-46b2-96af-3dfde13231d8'),('2025-12-04 10:40:55.359368',NULL,'2025-12-04 10:40:55.394216',242,242,'b5d23f7e91694629931517a6c40efbe5','6959afff-b71a-4610-85ed-b13a75b30d12',76,'54f365c11f8e40988b5a964504f91dd7','shares',1,'2025-12-05 10:40:55',NULL),('2025-12-04 10:40:55.360537',NULL,'2025-12-04 10:40:55.394216',243,243,'b5d23f7e91694629931517a6c40efbe5','9d9a74fe-e01e-476d-aec8-109318578a5c',75,'54f365c11f8e40988b5a964504f91dd7','gigabytes',1,'2025-12-05 10:40:55',NULL),('2025-12-04 10:40:55.369840',NULL,'2025-12-04 10:40:55.394216',244,244,NULL,'57fbb636-c799-4ca5-b63b-c7ea4a622ec5',88,'54f365c11f8e40988b5a964504f91dd7','shares',1,'2025-12-05 10:40:55','37563d7b-fcdb-4c5f-b9db-cf6680a53c05'),('2025-12-04 10:40:55.370865',NULL,'2025-12-04 10:40:55.394216',245,245,NULL,'f77bdb7a-09c3-4db3-946f-c2c7d4b9aaea',87,'54f365c11f8e40988b5a964504f91dd7','gigabytes',1,'2025-12-05 10:40:55','37563d7b-fcdb-4c5f-b9db-cf6680a53c05'),('2025-12-04 10:40:58.532403',NULL,'2025-12-04 10:40:58.548069',246,246,'d62cbbb064cd4277b18c062e7f02e202','e90850be-aa76-4778-af0f-fef17a9e9415',79,'f6c223a076bd42bd958c3294b89dc763','shares',-1,'2025-12-05 10:40:58',NULL),('2025-12-04 10:40:58.533376',NULL,'2025-12-04 10:40:58.548069',247,247,'d62cbbb064cd4277b18c062e7f02e202','ad5261d3-b776-48f0-94e7-8bc208a83fec',80,'f6c223a076bd42bd958c3294b89dc763','gigabytes',-1,'2025-12-05 10:40:58',NULL),('2025-12-04 10:40:58.540473',NULL,'2025-12-04 10:40:58.548069',248,248,NULL,'b825f5a4-1fc5-41be-978c-62e4890e14c4',81,'f6c223a076bd42bd958c3294b89dc763','shares',-1,'2025-12-05 10:40:58','3d827517-5ff1-48c1-8133-89cd1d41e9bd'),('2025-12-04 10:40:58.541226',NULL,'2025-12-04 10:40:58.548069',249,249,NULL,'70322689-0c48-46c6-bd2b-ce16a56dc7d0',82,'f6c223a076bd42bd958c3294b89dc763','gigabytes',-1,'2025-12-05 10:40:58','3d827517-5ff1-48c1-8133-89cd1d41e9bd'),('2025-12-04 10:40:59.200305',NULL,'2025-12-04 10:40:59.221095',250,250,'b5d23f7e91694629931517a6c40efbe5','a5bd4caa-8bdc-444f-8807-41bed4a5cd51',76,'54f365c11f8e40988b5a964504f91dd7','shares',-1,'2025-12-05 10:40:58',NULL),('2025-12-04 10:40:59.201113',NULL,'2025-12-04 10:40:59.221095',251,251,'b5d23f7e91694629931517a6c40efbe5','fc741b83-f226-4ac2-9bcd-bdfa0cad5d1b',75,'54f365c11f8e40988b5a964504f91dd7','gigabytes',-1,'2025-12-05 10:40:58',NULL),('2025-12-04 10:40:59.206913',NULL,'2025-12-04 10:40:59.221095',252,252,NULL,'53cc7f05-d651-4596-ad55-23aea8f017c4',88,'54f365c11f8e40988b5a964504f91dd7','shares',-1,'2025-12-05 10:40:58','37563d7b-fcdb-4c5f-b9db-cf6680a53c05'),('2025-12-04 10:40:59.207693',NULL,'2025-12-04 10:40:59.221095',253,253,NULL,'6260a616-347b-4fe2-93cc-dfd03e19ea84',87,'54f365c11f8e40988b5a964504f91dd7','gigabytes',-1,'2025-12-05 10:40:58','37563d7b-fcdb-4c5f-b9db-cf6680a53c05'),('2025-12-04 10:40:59.551496',NULL,'2025-12-04 10:40:59.593059',254,254,'b5d23f7e91694629931517a6c40efbe5','48d571a2-10d8-4242-b2b6-051f65dfb4f9',76,'54f365c11f8e40988b5a964504f91dd7','shares',1,'2025-12-05 10:40:59',NULL),('2025-12-04 10:40:59.552826',NULL,'2025-12-04 10:40:59.593059',255,255,'b5d23f7e91694629931517a6c40efbe5','52d7f7f4-6637-4f66-b959-fd1d8578e67c',75,'54f365c11f8e40988b5a964504f91dd7','gigabytes',1,'2025-12-05 10:40:59',NULL),('2025-12-04 10:40:59.562164',NULL,'2025-12-04 10:40:59.593059',256,256,NULL,'b374921f-1baa-4c09-9cea-59b4ee0b40b9',90,'54f365c11f8e40988b5a964504f91dd7','shares',1,'2025-12-05 10:40:59','329c3d8c-f588-46f8-a798-2f52b3017ff1'),('2025-12-04 10:40:59.563241',NULL,'2025-12-04 10:40:59.593059',257,257,NULL,'2ca1bc77-423a-4dc0-a7f0-8f8e810e3d5d',89,'54f365c11f8e40988b5a964504f91dd7','gigabytes',1,'2025-12-05 10:40:59','329c3d8c-f588-46f8-a798-2f52b3017ff1'),('2025-12-04 10:41:03.340260',NULL,'2025-12-04 10:41:03.607970',258,258,'b5d23f7e91694629931517a6c40efbe5','d787ad74-a238-4b87-9ec0-9f7542a2a2d6',76,'54f365c11f8e40988b5a964504f91dd7','shares',-1,'2025-12-05 10:41:03',NULL),('2025-12-04 10:41:03.341254',NULL,'2025-12-04 10:41:03.607970',259,259,'b5d23f7e91694629931517a6c40efbe5','47c6d438-d363-41c2-901c-f4aef9f0eed3',75,'54f365c11f8e40988b5a964504f91dd7','gigabytes',-1,'2025-12-05 10:41:03',NULL),('2025-12-04 10:41:03.521223',NULL,'2025-12-04 10:41:03.607970',260,260,NULL,'eef67a66-08bc-44ff-bccd-eb21d6a8f61e',90,'54f365c11f8e40988b5a964504f91dd7','shares',-1,'2025-12-05 10:41:03','329c3d8c-f588-46f8-a798-2f52b3017ff1'),('2025-12-04 10:41:03.522071',NULL,'2025-12-04 10:41:03.607970',261,261,NULL,'faf8c4e7-4761-4ebc-86bf-dbe37571c5de',89,'54f365c11f8e40988b5a964504f91dd7','gigabytes',-1,'2025-12-05 10:41:03','329c3d8c-f588-46f8-a798-2f52b3017ff1'),('2025-12-04 10:41:03.971221',NULL,'2025-12-04 10:41:04.047326',262,262,'b5d23f7e91694629931517a6c40efbe5','80c372d1-aa7e-4aa6-b63e-ef042010d302',76,'54f365c11f8e40988b5a964504f91dd7','shares',1,'2025-12-05 10:41:03',NULL),('2025-12-04 10:41:03.972576',NULL,'2025-12-04 10:41:04.047326',263,263,'b5d23f7e91694629931517a6c40efbe5','8fd21b78-4104-401d-b0df-3e0af2720091',75,'54f365c11f8e40988b5a964504f91dd7','gigabytes',1,'2025-12-05 10:41:03',NULL),('2025-12-04 10:41:03.993525',NULL,'2025-12-04 10:41:04.047326',264,264,NULL,'481ff69f-8d7e-47bf-9352-45358547408c',91,'54f365c11f8e40988b5a964504f91dd7','shares',1,'2025-12-05 10:41:03','010affb4-16b3-42ed-a4b9-506eedbbafdf'),('2025-12-04 10:41:03.995014',NULL,'2025-12-04 10:41:04.047326',265,265,NULL,'a25e8a05-bd78-46c5-8f96-5ae900a3f6f6',92,'54f365c11f8e40988b5a964504f91dd7','gigabytes',1,'2025-12-05 10:41:03','010affb4-16b3-42ed-a4b9-506eedbbafdf'),('2025-12-04 10:41:07.932893',NULL,'2025-12-04 10:41:07.952109',266,266,'b5d23f7e91694629931517a6c40efbe5','15cb7057-7209-4697-9174-8f2ebcfd3bcb',76,'54f365c11f8e40988b5a964504f91dd7','shares',-1,'2025-12-05 10:41:07',NULL),('2025-12-04 10:41:07.933754',NULL,'2025-12-04 10:41:07.952109',267,267,'b5d23f7e91694629931517a6c40efbe5','f6543d81-6d37-495a-9018-606df1b6ef39',75,'54f365c11f8e40988b5a964504f91dd7','gigabytes',-1,'2025-12-05 10:41:07',NULL),('2025-12-04 10:41:07.939131',NULL,'2025-12-04 10:41:07.952109',268,268,NULL,'10069579-eac4-4568-bbdb-6a8dbd810393',91,'54f365c11f8e40988b5a964504f91dd7','shares',-1,'2025-12-05 10:41:07','010affb4-16b3-42ed-a4b9-506eedbbafdf'),('2025-12-04 10:41:07.939830',NULL,'2025-12-04 10:41:07.952109',269,269,NULL,'e5bdf11a-de6f-428a-accd-374a54566120',92,'54f365c11f8e40988b5a964504f91dd7','gigabytes',-1,'2025-12-05 10:41:07','010affb4-16b3-42ed-a4b9-506eedbbafdf'),('2025-12-04 10:41:08.346424',NULL,'2025-12-04 10:41:08.424855',270,270,'b5d23f7e91694629931517a6c40efbe5','c61e14b4-d586-43c3-ab52-924e9de68ae3',76,'54f365c11f8e40988b5a964504f91dd7','shares',1,'2025-12-05 10:41:08',NULL),('2025-12-04 10:41:08.352966',NULL,'2025-12-04 10:41:08.424855',271,271,'b5d23f7e91694629931517a6c40efbe5','3d052cd0-ee10-477c-a51b-0abb34451985',75,'54f365c11f8e40988b5a964504f91dd7','gigabytes',1,'2025-12-05 10:41:08',NULL),('2025-12-04 10:41:08.365190',NULL,'2025-12-04 10:41:08.424855',272,272,NULL,'da2b13a1-20d0-4e11-ab3d-0fe0ed821c49',94,'54f365c11f8e40988b5a964504f91dd7','shares',1,'2025-12-05 10:41:08','9327d215-d4cc-4d4f-9783-f891100659fa'),('2025-12-04 10:41:08.376691',NULL,'2025-12-04 10:41:08.424855',273,273,NULL,'0fc5b510-b513-4d64-a726-cd5628eaf75f',93,'54f365c11f8e40988b5a964504f91dd7','gigabytes',1,'2025-12-05 10:41:08','9327d215-d4cc-4d4f-9783-f891100659fa'),('2025-12-04 10:41:12.058096',NULL,'2025-12-04 10:41:12.082221',274,274,'b5d23f7e91694629931517a6c40efbe5','f44104d4-f6ac-41c0-97c1-af3dbd6d0406',76,'54f365c11f8e40988b5a964504f91dd7','shares',-1,'2025-12-05 10:41:11',NULL),('2025-12-04 10:41:12.059010',NULL,'2025-12-04 10:41:12.082221',275,275,'b5d23f7e91694629931517a6c40efbe5','59f6d7e7-c87e-407f-86ab-acf7f5cffa91',75,'54f365c11f8e40988b5a964504f91dd7','gigabytes',-1,'2025-12-05 10:41:11',NULL),('2025-12-04 10:41:12.071294',NULL,'2025-12-04 10:41:12.082221',276,276,NULL,'bf453f61-c09f-4ac6-ba14-22909471db0f',94,'54f365c11f8e40988b5a964504f91dd7','shares',-1,'2025-12-05 10:41:11','9327d215-d4cc-4d4f-9783-f891100659fa'),('2025-12-04 10:41:12.072366',NULL,'2025-12-04 10:41:12.082221',277,277,NULL,'19190a76-0453-4d39-a002-c5e8218d6608',93,'54f365c11f8e40988b5a964504f91dd7','gigabytes',-1,'2025-12-05 10:41:11','9327d215-d4cc-4d4f-9783-f891100659fa'),('2025-12-04 10:41:12.588292',NULL,'2025-12-04 10:41:12.644755',278,278,'956c2a2425364bc58a945afb8a16635a','762edfe9-d4fc-4bb8-95af-7b9ce99f2595',96,'91320ee163cc40bc8f5c820635954e8f','shares',1,'2025-12-05 10:41:12',NULL),('2025-12-04 10:41:12.590012',NULL,'2025-12-04 10:41:12.644755',279,279,'956c2a2425364bc58a945afb8a16635a','f15ebe81-4cf9-477f-8315-cc92aef31336',95,'91320ee163cc40bc8f5c820635954e8f','gigabytes',1,'2025-12-05 10:41:12',NULL),('2025-12-04 10:41:12.619867',NULL,'2025-12-04 10:41:12.644755',280,280,NULL,'42660528-4bcd-4dc5-8d9e-4e98ba7e2adf',98,'91320ee163cc40bc8f5c820635954e8f','shares',1,'2025-12-05 10:41:12','0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:41:12.621589',NULL,'2025-12-04 10:41:12.644755',281,281,NULL,'8de4d4b0-c9fe-42b3-9441-275d0d960898',97,'91320ee163cc40bc8f5c820635954e8f','gigabytes',1,'2025-12-05 10:41:12','0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:41:13.805566',NULL,'2025-12-04 10:41:13.821469',282,282,'346d2a3ba5e24df2a1417033f75e866e','3e474c9e-e75f-41af-8246-3eadfacc8ea1',84,'de70f6413fb248c6a07e498350f7a8e3','shares',-1,'2025-12-05 10:41:13',NULL),('2025-12-04 10:41:13.806328',NULL,'2025-12-04 10:41:13.821469',283,283,'346d2a3ba5e24df2a1417033f75e866e','3f2058bc-45d1-4bb9-bcf9-1639f1d093af',83,'de70f6413fb248c6a07e498350f7a8e3','gigabytes',-1,'2025-12-05 10:41:13',NULL),('2025-12-04 10:41:13.811857',NULL,'2025-12-04 10:41:13.821469',284,284,NULL,'1014d9b5-5fc8-452f-90dc-73487e0ce0c7',86,'de70f6413fb248c6a07e498350f7a8e3','shares',-1,'2025-12-05 10:41:13','ec0655e6-90b3-4d12-b523-1f54eacdc7a3'),('2025-12-04 10:41:13.813277',NULL,'2025-12-04 10:41:13.821469',285,285,NULL,'0b9d5c1f-acfe-4f3f-b748-0bcab510194e',85,'de70f6413fb248c6a07e498350f7a8e3','gigabytes',-1,'2025-12-05 10:41:13','ec0655e6-90b3-4d12-b523-1f54eacdc7a3'),('2025-12-04 10:41:16.204212',NULL,'2025-12-04 10:41:16.372121',286,286,'956c2a2425364bc58a945afb8a16635a','ddc85f4a-83ee-488b-87dc-9b7a38de8842',96,'91320ee163cc40bc8f5c820635954e8f','shares',1,'2025-12-05 10:41:16',NULL),('2025-12-04 10:41:16.205695',NULL,'2025-12-04 10:41:16.372121',287,287,'956c2a2425364bc58a945afb8a16635a','05471b7d-4235-412b-b30d-c2b2207832ae',95,'91320ee163cc40bc8f5c820635954e8f','gigabytes',1,'2025-12-05 10:41:16',NULL),('2025-12-04 10:41:16.237368',NULL,'2025-12-04 10:41:16.372121',288,288,NULL,'76ebaeac-9da4-441f-aee2-e0703779b254',98,'91320ee163cc40bc8f5c820635954e8f','shares',1,'2025-12-05 10:41:16','0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:41:16.238904',NULL,'2025-12-04 10:41:16.372121',289,289,NULL,'1d830f33-18e1-486a-9acc-8371dd7d1674',97,'91320ee163cc40bc8f5c820635954e8f','gigabytes',1,'2025-12-05 10:41:16','0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:41:21.876091',NULL,'2025-12-04 10:41:21.901682',290,290,'956c2a2425364bc58a945afb8a16635a','93c8f64a-2730-4e4c-9566-e100bc34fe10',96,'91320ee163cc40bc8f5c820635954e8f','shares',-1,'2025-12-05 10:41:21',NULL),('2025-12-04 10:41:21.876975',NULL,'2025-12-04 10:41:21.901682',291,291,'956c2a2425364bc58a945afb8a16635a','f0735222-fc9e-4d74-bb20-434b93d3c87c',95,'91320ee163cc40bc8f5c820635954e8f','gigabytes',-1,'2025-12-05 10:41:21',NULL),('2025-12-04 10:41:21.882257',NULL,'2025-12-04 10:41:21.901682',292,292,NULL,'88a3a173-a545-498f-ac36-89709b43f51c',98,'91320ee163cc40bc8f5c820635954e8f','shares',-1,'2025-12-05 10:41:21','0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:41:21.883072',NULL,'2025-12-04 10:41:21.901682',293,293,NULL,'a89c1352-febd-47e0-9a14-606d3ec16320',97,'91320ee163cc40bc8f5c820635954e8f','gigabytes',-1,'2025-12-05 10:41:21','0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:41:24.919189',NULL,'2025-12-04 10:41:24.983510',294,294,'956c2a2425364bc58a945afb8a16635a','55c3111f-9412-4d15-bec3-9c172552d9a1',96,'91320ee163cc40bc8f5c820635954e8f','shares',1,'2025-12-05 10:41:24',NULL),('2025-12-04 10:41:24.920790',NULL,'2025-12-04 10:41:24.983510',295,295,'956c2a2425364bc58a945afb8a16635a','35655519-fe75-4603-aa0f-6f1bcdd8afdf',95,'91320ee163cc40bc8f5c820635954e8f','gigabytes',1,'2025-12-05 10:41:24',NULL),('2025-12-04 10:41:24.932546',NULL,'2025-12-04 10:41:24.983510',296,296,NULL,'378bd0cc-74e5-40de-93c8-b041ee4ae0c6',98,'91320ee163cc40bc8f5c820635954e8f','shares',1,'2025-12-05 10:41:24','0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:41:24.937503',NULL,'2025-12-04 10:41:24.983510',297,297,NULL,'7abced83-4719-4ed1-8120-0da85134e233',97,'91320ee163cc40bc8f5c820635954e8f','gigabytes',1,'2025-12-05 10:41:24','0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:41:30.719684',NULL,'2025-12-04 10:41:30.735995',298,298,'956c2a2425364bc58a945afb8a16635a','bd943524-7105-456f-970c-a72589a42e7b',96,'91320ee163cc40bc8f5c820635954e8f','shares',-1,'2025-12-05 10:41:30',NULL),('2025-12-04 10:41:30.720502',NULL,'2025-12-04 10:41:30.735995',299,299,'956c2a2425364bc58a945afb8a16635a','ebbb903c-3950-4e54-a94e-5eb791b6a32b',95,'91320ee163cc40bc8f5c820635954e8f','gigabytes',-1,'2025-12-05 10:41:30',NULL),('2025-12-04 10:41:30.726644',NULL,'2025-12-04 10:41:30.735995',300,300,NULL,'6dcbe3bd-1949-407a-a172-da8c2664ca26',98,'91320ee163cc40bc8f5c820635954e8f','shares',-1,'2025-12-05 10:41:30','0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:41:30.727328',NULL,'2025-12-04 10:41:30.735995',301,301,NULL,'c8e55ed8-7325-4658-94af-311f73939d79',97,'91320ee163cc40bc8f5c820635954e8f','gigabytes',-1,'2025-12-05 10:41:30','0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:41:30.878197',NULL,'2025-12-04 10:41:30.912008',302,302,'7da578f357d044d590ceb21b50653ba9','36e1dfaa-b79d-4494-873c-00ab25d83880',99,'209828455d3a419389bb0a731fac0513','shares',1,'2025-12-05 10:41:30',NULL),('2025-12-04 10:41:30.879280',NULL,'2025-12-04 10:41:30.912008',303,303,'7da578f357d044d590ceb21b50653ba9','30ed9415-1bbf-4c19-83b0-a7da9c1bc797',100,'209828455d3a419389bb0a731fac0513','gigabytes',1,'2025-12-05 10:41:30',NULL),('2025-12-04 10:41:30.888141',NULL,'2025-12-04 10:41:30.912008',304,304,NULL,'f2d159ee-2f00-42fe-8b9c-258d71cf0a6b',101,'209828455d3a419389bb0a731fac0513','shares',1,'2025-12-05 10:41:30','2b8fd021-e19e-4963-9125-9f006d6d6090'),('2025-12-04 10:41:30.889261',NULL,'2025-12-04 10:41:30.912008',305,305,NULL,'9bb83e92-ed30-4e32-b0da-303f7600b7ec',102,'209828455d3a419389bb0a731fac0513','gigabytes',1,'2025-12-05 10:41:30','2b8fd021-e19e-4963-9125-9f006d6d6090'),('2025-12-04 10:41:33.940691',NULL,'2025-12-04 10:41:33.976126',306,306,'956c2a2425364bc58a945afb8a16635a','48a72a09-782a-439c-8c48-9c0e78bcedbc',96,'91320ee163cc40bc8f5c820635954e8f','shares',1,'2025-12-05 10:41:33',NULL),('2025-12-04 10:41:33.942521',NULL,'2025-12-04 10:41:33.976126',307,307,'956c2a2425364bc58a945afb8a16635a','d56084bf-1862-4610-b686-1f0026f3adaa',95,'91320ee163cc40bc8f5c820635954e8f','gigabytes',1,'2025-12-05 10:41:33',NULL),('2025-12-04 10:41:33.948047',NULL,'2025-12-04 10:41:33.976126',308,308,NULL,'7ce8f097-4ee7-4aa1-bc1d-e67eb763ca3f',98,'91320ee163cc40bc8f5c820635954e8f','shares',1,'2025-12-05 10:41:33','0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:41:33.949075',NULL,'2025-12-04 10:41:33.976126',309,309,NULL,'456c3e0b-7ee1-4179-9b31-0186f6312f28',97,'91320ee163cc40bc8f5c820635954e8f','gigabytes',1,'2025-12-05 10:41:33','0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:41:36.193433',NULL,'2025-12-04 10:41:36.209332',310,310,'7da578f357d044d590ceb21b50653ba9','90108341-a225-4902-9693-7f8dffc1d32a',99,'209828455d3a419389bb0a731fac0513','shares',-1,'2025-12-05 10:41:36',NULL),('2025-12-04 10:41:36.194290',NULL,'2025-12-04 10:41:36.209332',311,311,'7da578f357d044d590ceb21b50653ba9','e21532b5-c149-4ac5-832c-2b8631b43b2f',100,'209828455d3a419389bb0a731fac0513','gigabytes',-1,'2025-12-05 10:41:36',NULL),('2025-12-04 10:41:36.200322',NULL,'2025-12-04 10:41:36.209332',312,312,NULL,'4d1f460b-a384-4ddd-a5c1-7ce77ee008d9',101,'209828455d3a419389bb0a731fac0513','shares',-1,'2025-12-05 10:41:36','2b8fd021-e19e-4963-9125-9f006d6d6090'),('2025-12-04 10:41:36.201066',NULL,'2025-12-04 10:41:36.209332',313,313,NULL,'20767cde-f507-40bf-a8fc-456c0cd2f595',102,'209828455d3a419389bb0a731fac0513','gigabytes',-1,'2025-12-05 10:41:36','2b8fd021-e19e-4963-9125-9f006d6d6090'),('2025-12-04 10:41:38.406508',NULL,'2025-12-04 10:41:38.422584',314,314,'956c2a2425364bc58a945afb8a16635a','60583b63-7237-4cef-b49a-3500deb91acd',96,'91320ee163cc40bc8f5c820635954e8f','shares',-1,'2025-12-05 10:41:38',NULL),('2025-12-04 10:41:38.407618',NULL,'2025-12-04 10:41:38.422584',315,315,'956c2a2425364bc58a945afb8a16635a','523db3c7-6ce6-44c3-8f02-2d15ebb5197f',95,'91320ee163cc40bc8f5c820635954e8f','gigabytes',-1,'2025-12-05 10:41:38',NULL),('2025-12-04 10:41:38.415050',NULL,'2025-12-04 10:41:38.422584',316,316,NULL,'8689385e-029f-40e3-88f0-429d8d7593af',98,'91320ee163cc40bc8f5c820635954e8f','shares',-1,'2025-12-05 10:41:38','0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:41:38.415845',NULL,'2025-12-04 10:41:38.422584',317,317,NULL,'9983800e-7e34-49e8-aead-6ebb4bb29498',97,'91320ee163cc40bc8f5c820635954e8f','gigabytes',-1,'2025-12-05 10:41:38','0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:41:41.738867',NULL,'2025-12-04 10:41:41.775462',318,318,'956c2a2425364bc58a945afb8a16635a','badaa80f-22ca-4713-9971-9cbd5aa06bd5',96,'91320ee163cc40bc8f5c820635954e8f','shares',1,'2025-12-05 10:41:41',NULL),('2025-12-04 10:41:41.740771',NULL,'2025-12-04 10:41:41.775462',319,319,'956c2a2425364bc58a945afb8a16635a','2f477070-063f-4244-9863-5c3b76315518',95,'91320ee163cc40bc8f5c820635954e8f','gigabytes',1,'2025-12-05 10:41:41',NULL),('2025-12-04 10:41:41.749003',NULL,'2025-12-04 10:41:41.775462',320,320,NULL,'c08823a3-8d00-4732-9c60-d850dcfd0cea',98,'91320ee163cc40bc8f5c820635954e8f','shares',1,'2025-12-05 10:41:41','0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:41:41.750284',NULL,'2025-12-04 10:41:41.775462',321,321,NULL,'000cbfb8-9d24-4d16-bfd5-290120042ead',97,'91320ee163cc40bc8f5c820635954e8f','gigabytes',1,'2025-12-05 10:41:41','0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:41:48.972382',NULL,'2025-12-04 10:41:49.000213',322,322,'956c2a2425364bc58a945afb8a16635a','230e2407-0f4f-4618-9264-7fb0044dbcb4',96,'91320ee163cc40bc8f5c820635954e8f','shares',-1,'2025-12-05 10:41:48',NULL),('2025-12-04 10:41:48.973264',NULL,'2025-12-04 10:41:49.000213',323,323,'956c2a2425364bc58a945afb8a16635a','4db13731-99be-4ad3-8d50-1c481ab278e0',95,'91320ee163cc40bc8f5c820635954e8f','gigabytes',-1,'2025-12-05 10:41:48',NULL),('2025-12-04 10:41:48.985355',NULL,'2025-12-04 10:41:49.000213',324,324,NULL,'f639927e-4155-4c88-8237-b919196ae16d',98,'91320ee163cc40bc8f5c820635954e8f','shares',-1,'2025-12-05 10:41:48','0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:41:48.986189',NULL,'2025-12-04 10:41:49.000213',325,325,NULL,'43b343af-f5dc-4f2e-bbe1-9f7b7a6d7ea5',97,'91320ee163cc40bc8f5c820635954e8f','gigabytes',-1,'2025-12-05 10:41:48','0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:41:50.464335',NULL,'2025-12-04 10:41:51.329585',326,326,'ebdbce19c170478db5c1f470f4d9bb47','144a9235-e9fa-4fae-b830-6fff86f4c190',104,'ecc97bc6bfe546b6b2d42d386bafab9c','shares',1,'2025-12-05 10:41:50',NULL),('2025-12-04 10:41:50.465406',NULL,'2025-12-04 10:41:51.329585',327,327,'ebdbce19c170478db5c1f470f4d9bb47','17b2468a-ca85-45ed-a10d-5bfb3c78b287',103,'ecc97bc6bfe546b6b2d42d386bafab9c','gigabytes',1,'2025-12-05 10:41:50',NULL),('2025-12-04 10:41:50.475112',NULL,'2025-12-04 10:41:51.329585',328,328,NULL,'d6e8818e-9dcb-4cd1-b145-199efd949b25',106,'ecc97bc6bfe546b6b2d42d386bafab9c','shares',1,'2025-12-05 10:41:50','2537e953-bb9f-4f01-aa9d-2ca546adc331'),('2025-12-04 10:41:50.476289',NULL,'2025-12-04 10:41:51.329585',329,329,NULL,'7c076e15-2228-4868-aaff-15c5a89ad67c',105,'ecc97bc6bfe546b6b2d42d386bafab9c','gigabytes',1,'2025-12-05 10:41:50','2537e953-bb9f-4f01-aa9d-2ca546adc331'),('2025-12-04 10:41:52.805787',NULL,'2025-12-04 10:41:52.863973',330,330,'de759a3ec81642cd83d621173ab2bdb2','ebad35e8-298b-46b0-ac34-81148ff92c98',108,'f409515d619a495bb7f5f1af15f8324a','shares',1,'2025-12-05 10:41:52',NULL),('2025-12-04 10:41:52.807586',NULL,'2025-12-04 10:41:52.863973',331,331,'de759a3ec81642cd83d621173ab2bdb2','b0697090-bc43-4be1-823d-c63ce923137c',107,'f409515d619a495bb7f5f1af15f8324a','gigabytes',1,'2025-12-05 10:41:52',NULL),('2025-12-04 10:41:52.827500',NULL,'2025-12-04 10:41:52.863973',332,332,NULL,'b9545497-40c5-430f-8a6e-cf78dafbb435',110,'f409515d619a495bb7f5f1af15f8324a','shares',1,'2025-12-05 10:41:52','e97a3463-125a-45ea-9b75-73d586ae1dd9'),('2025-12-04 10:41:52.829138',NULL,'2025-12-04 10:41:52.863973',333,333,NULL,'101598d0-b810-4ed6-ba74-80e2e7d55fbc',109,'f409515d619a495bb7f5f1af15f8324a','gigabytes',1,'2025-12-05 10:41:52','e97a3463-125a-45ea-9b75-73d586ae1dd9'),('2025-12-04 10:41:53.283768',NULL,'2025-12-04 10:41:53.332264',334,334,'507c8db7b2164bd98f5556ae52f72fd0','11c22ab0-f2d3-423f-a1c7-39175935fadb',111,'829c39a80695492b897dbe32bb2a565c','shares',1,'2025-12-05 10:41:53',NULL),('2025-12-04 10:41:53.285087',NULL,'2025-12-04 10:41:53.332264',335,335,'507c8db7b2164bd98f5556ae52f72fd0','c1a8157f-0878-47f1-bf71-64c39155e5dc',112,'829c39a80695492b897dbe32bb2a565c','gigabytes',1,'2025-12-05 10:41:53',NULL),('2025-12-04 10:41:53.301939',NULL,'2025-12-04 10:41:53.332264',336,336,NULL,'5405ad51-3436-4cb2-b09f-518764ef9b3c',113,'829c39a80695492b897dbe32bb2a565c','shares',1,'2025-12-05 10:41:53','e97a3463-125a-45ea-9b75-73d586ae1dd9'),('2025-12-04 10:41:53.303316',NULL,'2025-12-04 10:41:53.332264',337,337,NULL,'64eb49e6-df2e-4d48-81ff-270ebcb352d8',114,'829c39a80695492b897dbe32bb2a565c','gigabytes',1,'2025-12-05 10:41:53','e97a3463-125a-45ea-9b75-73d586ae1dd9'),('2025-12-04 10:41:53.724855',NULL,'2025-12-04 10:41:53.755368',338,338,'956c2a2425364bc58a945afb8a16635a','a406bd26-8659-4c69-be5c-c736fb2453ba',96,'91320ee163cc40bc8f5c820635954e8f','shares',1,'2025-12-05 10:41:53',NULL),('2025-12-04 10:41:53.726091',NULL,'2025-12-04 10:41:53.755368',339,339,'956c2a2425364bc58a945afb8a16635a','8bc9f3df-9d22-411c-ac9b-86c37b7c4075',95,'91320ee163cc40bc8f5c820635954e8f','gigabytes',1,'2025-12-05 10:41:53',NULL),('2025-12-04 10:41:53.734461',NULL,'2025-12-04 10:41:53.755368',340,340,NULL,'dc4017c5-7947-4c00-a15f-b23c143eed22',98,'91320ee163cc40bc8f5c820635954e8f','shares',1,'2025-12-05 10:41:53','0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:41:53.735739',NULL,'2025-12-04 10:41:53.755368',341,341,NULL,'8cb3552f-a9c4-4d53-8cce-c8fba2c0776b',97,'91320ee163cc40bc8f5c820635954e8f','gigabytes',1,'2025-12-05 10:41:53','0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:41:56.446824',NULL,'2025-12-04 10:41:56.460779',342,342,'ebdbce19c170478db5c1f470f4d9bb47','a6214b17-5c59-4695-a071-5873123a93bc',104,'ecc97bc6bfe546b6b2d42d386bafab9c','shares',-1,'2025-12-05 10:41:56',NULL),('2025-12-04 10:41:56.448319',NULL,'2025-12-04 10:41:56.460779',343,343,'ebdbce19c170478db5c1f470f4d9bb47','964a5db9-a74a-4239-b9be-b7800360ec32',103,'ecc97bc6bfe546b6b2d42d386bafab9c','gigabytes',-1,'2025-12-05 10:41:56',NULL),('2025-12-04 10:41:56.453601',NULL,'2025-12-04 10:41:56.460779',344,344,NULL,'551500f3-e4e4-4594-9e2e-ee925771e2d5',106,'ecc97bc6bfe546b6b2d42d386bafab9c','shares',-1,'2025-12-05 10:41:56','2537e953-bb9f-4f01-aa9d-2ca546adc331'),('2025-12-04 10:41:56.454296',NULL,'2025-12-04 10:41:56.460779',345,345,NULL,'d0e524cd-0461-488c-b526-1191a019b895',105,'ecc97bc6bfe546b6b2d42d386bafab9c','gigabytes',-1,'2025-12-05 10:41:56','2537e953-bb9f-4f01-aa9d-2ca546adc331'),('2025-12-04 10:41:57.235831',NULL,'2025-12-04 10:41:57.249141',346,346,'507c8db7b2164bd98f5556ae52f72fd0','29c4d8dd-a9af-49e8-8082-7240487b48ed',111,'829c39a80695492b897dbe32bb2a565c','shares',-1,'2025-12-05 10:41:57',NULL),('2025-12-04 10:41:57.236603',NULL,'2025-12-04 10:41:57.249141',347,347,'507c8db7b2164bd98f5556ae52f72fd0','7e7e1b0d-80b7-489f-b27e-5934ea75f77c',112,'829c39a80695492b897dbe32bb2a565c','gigabytes',-1,'2025-12-05 10:41:57',NULL),('2025-12-04 10:41:57.241768',NULL,'2025-12-04 10:41:57.249141',348,348,NULL,'88937d07-fe63-4228-b890-6079e5d9d15e',113,'829c39a80695492b897dbe32bb2a565c','shares',-1,'2025-12-05 10:41:57','e97a3463-125a-45ea-9b75-73d586ae1dd9'),('2025-12-04 10:41:57.242449',NULL,'2025-12-04 10:41:57.249141',349,349,NULL,'f150d8be-323d-4e5d-a9a5-73c7a1d7a83d',114,'829c39a80695492b897dbe32bb2a565c','gigabytes',-1,'2025-12-05 10:41:57','e97a3463-125a-45ea-9b75-73d586ae1dd9'),('2025-12-04 10:41:59.579322',NULL,'2025-12-04 10:41:59.592612',350,350,'956c2a2425364bc58a945afb8a16635a','ff69cdba-f0e8-46c6-905d-ec7883611837',96,'91320ee163cc40bc8f5c820635954e8f','shares',-1,'2025-12-05 10:41:59',NULL),('2025-12-04 10:41:59.580165',NULL,'2025-12-04 10:41:59.592612',351,351,'956c2a2425364bc58a945afb8a16635a','3c2883ef-d7a8-450e-ad0f-d348a686cbc5',95,'91320ee163cc40bc8f5c820635954e8f','gigabytes',-1,'2025-12-05 10:41:59',NULL),('2025-12-04 10:41:59.580121',NULL,'2025-12-04 10:41:59.624374',352,352,'88e5a16daca84b4896b3a4ca2f314a8b','92e56869-b464-4ecf-a1e4-ba81ef420696',116,'ae2330f34cee47599e079667ef8df8bd','shares',1,'2025-12-05 10:41:59',NULL),('2025-12-04 10:41:59.582118',NULL,'2025-12-04 10:41:59.624374',353,353,'88e5a16daca84b4896b3a4ca2f314a8b','8e6dd222-e032-4ccb-b982-e422d7f10d98',115,'ae2330f34cee47599e079667ef8df8bd','gigabytes',1,'2025-12-05 10:41:59',NULL),('2025-12-04 10:41:59.585477',NULL,'2025-12-04 10:41:59.592612',354,354,NULL,'bf8ea744-c91b-4ae4-ac26-999e05fe0dbc',98,'91320ee163cc40bc8f5c820635954e8f','shares',-1,'2025-12-05 10:41:59','0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:41:59.586063',NULL,'2025-12-04 10:41:59.592612',355,355,NULL,'ccfdcdcc-19e1-4091-9ac6-d63ff26b07e2',97,'91320ee163cc40bc8f5c820635954e8f','gigabytes',-1,'2025-12-05 10:41:59','0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:41:59.596631',NULL,'2025-12-04 10:41:59.624374',356,356,NULL,'5b32723d-b535-4a33-b684-7a8f70687e58',118,'ae2330f34cee47599e079667ef8df8bd','shares',1,'2025-12-05 10:41:59','3c978cf0-17b5-4fa5-bacb-dfcf70d53863'),('2025-12-04 10:41:59.598159',NULL,'2025-12-04 10:41:59.624374',357,357,NULL,'ce71ee7e-d303-4182-91d1-d60d73e739e5',117,'ae2330f34cee47599e079667ef8df8bd','gigabytes',1,'2025-12-05 10:41:59','3c978cf0-17b5-4fa5-bacb-dfcf70d53863'),('2025-12-04 10:42:00.991204',NULL,'2025-12-04 10:42:01.009618',358,358,'de759a3ec81642cd83d621173ab2bdb2','cfa4ce59-ba67-4d4a-8989-c2c2162921d2',108,'f409515d619a495bb7f5f1af15f8324a','shares',-1,'2025-12-05 10:42:00',NULL),('2025-12-04 10:42:00.992035',NULL,'2025-12-04 10:42:01.009618',359,359,'de759a3ec81642cd83d621173ab2bdb2','89f9790e-35ce-4500-9593-f2dc2aefbe42',107,'f409515d619a495bb7f5f1af15f8324a','gigabytes',-1,'2025-12-05 10:42:00',NULL),('2025-12-04 10:42:00.997818',NULL,'2025-12-04 10:42:01.009618',360,360,NULL,'05193e0b-8dc9-4ab2-a360-d07f01606508',110,'f409515d619a495bb7f5f1af15f8324a','shares',-1,'2025-12-05 10:42:00','e97a3463-125a-45ea-9b75-73d586ae1dd9'),('2025-12-04 10:42:00.998453',NULL,'2025-12-04 10:42:01.009618',361,361,NULL,'0b5b71e0-f542-4101-8bfb-a4ff0e126966',109,'f409515d619a495bb7f5f1af15f8324a','gigabytes',-1,'2025-12-05 10:42:00','e97a3463-125a-45ea-9b75-73d586ae1dd9'),('2025-12-04 10:42:03.019031',NULL,'2025-12-04 10:42:03.257725',362,362,'88e5a16daca84b4896b3a4ca2f314a8b','1dd34d3b-bac1-42cd-9daf-4695de6a4834',120,'ae2330f34cee47599e079667ef8df8bd','snapshots',1,'2025-12-05 10:42:02',NULL),('2025-12-04 10:42:03.020203',NULL,'2025-12-04 10:42:03.257725',363,363,'88e5a16daca84b4896b3a4ca2f314a8b','fcb79939-53ce-4ada-a832-d3939d5569b4',119,'ae2330f34cee47599e079667ef8df8bd','snapshot_gigabytes',1,'2025-12-05 10:42:02',NULL),('2025-12-04 10:42:03.043800',NULL,'2025-12-04 10:42:03.257725',364,364,NULL,'b3b3aaac-d9e9-47e7-a6d8-33af7e944815',122,'ae2330f34cee47599e079667ef8df8bd','snapshots',1,'2025-12-05 10:42:02','3c978cf0-17b5-4fa5-bacb-dfcf70d53863'),('2025-12-04 10:42:03.046148',NULL,'2025-12-04 10:42:03.257725',365,365,NULL,'3c38f897-885e-4c2c-88a0-dcba4e4ab28d',121,'ae2330f34cee47599e079667ef8df8bd','snapshot_gigabytes',1,'2025-12-05 10:42:02','3c978cf0-17b5-4fa5-bacb-dfcf70d53863'),('2025-12-04 10:42:04.030261',NULL,'2025-12-04 10:42:04.069618',366,366,'507c8db7b2164bd98f5556ae52f72fd0','8e769a21-b426-4482-b8ee-265f8a4aa8ff',111,'829c39a80695492b897dbe32bb2a565c','shares',1,'2025-12-05 10:42:04',NULL),('2025-12-04 10:42:04.031653',NULL,'2025-12-04 10:42:04.069618',367,367,'507c8db7b2164bd98f5556ae52f72fd0','29f1bdec-3f19-4510-b1b0-53cecfda619e',112,'829c39a80695492b897dbe32bb2a565c','gigabytes',1,'2025-12-05 10:42:04',NULL),('2025-12-04 10:42:04.040265',NULL,'2025-12-04 10:42:04.069618',368,368,NULL,'30486079-1991-47a2-82ac-1b9208ca363d',113,'829c39a80695492b897dbe32bb2a565c','shares',1,'2025-12-05 10:42:04','e97a3463-125a-45ea-9b75-73d586ae1dd9'),('2025-12-04 10:42:04.041834',NULL,'2025-12-04 10:42:04.069618',369,369,NULL,'c97e1367-9bf1-41a9-9ad4-a23b23bf2bd1',114,'829c39a80695492b897dbe32bb2a565c','gigabytes',1,'2025-12-05 10:42:04','e97a3463-125a-45ea-9b75-73d586ae1dd9'),('2025-12-04 10:42:04.885492',NULL,'2025-12-04 10:42:04.903204',370,370,'956c2a2425364bc58a945afb8a16635a','78ac87f5-f137-4f12-b260-cfc487d5c526',96,'91320ee163cc40bc8f5c820635954e8f','shares',-1,'2025-12-05 10:42:04',NULL),('2025-12-04 10:42:04.886197',NULL,'2025-12-04 10:42:04.903204',371,371,'956c2a2425364bc58a945afb8a16635a','5b2d0c8a-4c9a-4666-8876-52b0ab74149e',95,'91320ee163cc40bc8f5c820635954e8f','gigabytes',-1,'2025-12-05 10:42:04',NULL),('2025-12-04 10:42:04.890995',NULL,'2025-12-04 10:42:04.903204',372,372,NULL,'bde0b26c-61a4-4177-8d77-e3a00cd588c5',98,'91320ee163cc40bc8f5c820635954e8f','shares',-1,'2025-12-05 10:42:04','0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:42:04.893402',NULL,'2025-12-04 10:42:04.903204',373,373,NULL,'d6bf9ca3-a710-4e13-b1a0-9f4115a9be92',97,'91320ee163cc40bc8f5c820635954e8f','gigabytes',-1,'2025-12-05 10:42:04','0ccfda71-450e-4fde-bdbe-edefcab4d6c6'),('2025-12-04 10:42:07.691737',NULL,'2025-12-04 10:42:07.717368',374,374,'88e5a16daca84b4896b3a4ca2f314a8b','41d49b85-4220-41db-89a1-712be4479dab',120,'ae2330f34cee47599e079667ef8df8bd','snapshots',-1,'2025-12-05 10:42:07',NULL),('2025-12-04 10:42:07.693928',NULL,'2025-12-04 10:42:07.717368',375,375,'88e5a16daca84b4896b3a4ca2f314a8b','f39cf702-85fa-4e8d-a976-67b1bd6b7dcb',119,'ae2330f34cee47599e079667ef8df8bd','snapshot_gigabytes',-1,'2025-12-05 10:42:07',NULL),('2025-12-04 10:42:07.699535',NULL,'2025-12-04 10:42:07.717368',376,376,NULL,'b8185be1-9bd0-408b-b2e0-2e0f6235e367',122,'ae2330f34cee47599e079667ef8df8bd','snapshots',-1,'2025-12-05 10:42:07','3c978cf0-17b5-4fa5-bacb-dfcf70d53863'),('2025-12-04 10:42:07.700467',NULL,'2025-12-04 10:42:07.717368',377,377,NULL,'a1d6da6f-2283-4f25-9c6d-b8d1606726f7',121,'ae2330f34cee47599e079667ef8df8bd','snapshot_gigabytes',-1,'2025-12-05 10:42:07','3c978cf0-17b5-4fa5-bacb-dfcf70d53863'),('2025-12-04 10:42:08.307091',NULL,'2025-12-04 10:42:08.322268',378,378,'507c8db7b2164bd98f5556ae52f72fd0','4f69a9e4-2ffb-40c7-a5a7-b5ca0004d623',111,'829c39a80695492b897dbe32bb2a565c','shares',-1,'2025-12-05 10:42:08',NULL),('2025-12-04 10:42:08.308122',NULL,'2025-12-04 10:42:08.322268',379,379,'507c8db7b2164bd98f5556ae52f72fd0','da88f2c7-7a36-45d7-8367-47ad5cb41278',112,'829c39a80695492b897dbe32bb2a565c','gigabytes',-1,'2025-12-05 10:42:08',NULL),('2025-12-04 10:42:08.313940',NULL,'2025-12-04 10:42:08.322268',380,380,NULL,'1cb851de-f1e1-4fe7-ae64-508d77e8d527',113,'829c39a80695492b897dbe32bb2a565c','shares',-1,'2025-12-05 10:42:08','e97a3463-125a-45ea-9b75-73d586ae1dd9'),('2025-12-04 10:42:08.314751',NULL,'2025-12-04 10:42:08.322268',381,381,NULL,'565bf628-6cfa-45df-aa34-2fe219f92352',114,'829c39a80695492b897dbe32bb2a565c','gigabytes',-1,'2025-12-05 10:42:08','e97a3463-125a-45ea-9b75-73d586ae1dd9'),('2025-12-04 10:42:11.362020',NULL,'2025-12-04 10:42:11.382360',382,382,'88e5a16daca84b4896b3a4ca2f314a8b','c64b3333-2b78-4214-9d52-2a68ebb4161f',116,'ae2330f34cee47599e079667ef8df8bd','shares',-1,'2025-12-05 10:42:11',NULL),('2025-12-04 10:42:11.363578',NULL,'2025-12-04 10:42:11.382360',383,383,'88e5a16daca84b4896b3a4ca2f314a8b','2bd144d5-f102-4129-ab6b-c06fdb4cdc63',115,'ae2330f34cee47599e079667ef8df8bd','gigabytes',-1,'2025-12-05 10:42:11',NULL),('2025-12-04 10:42:11.374727',NULL,'2025-12-04 10:42:11.382360',384,384,NULL,'af35ed12-00ca-4d91-bb6a-da08c7c37865',118,'ae2330f34cee47599e079667ef8df8bd','shares',-1,'2025-12-05 10:42:11','3c978cf0-17b5-4fa5-bacb-dfcf70d53863'),('2025-12-04 10:42:11.375498',NULL,'2025-12-04 10:42:11.382360',385,385,NULL,'67b76ba3-20c4-4188-82d9-99d40d4219a3',117,'ae2330f34cee47599e079667ef8df8bd','gigabytes',-1,'2025-12-05 10:42:11','3c978cf0-17b5-4fa5-bacb-dfcf70d53863'),('2025-12-04 10:42:16.549501',NULL,'2025-12-04 10:42:16.586171',386,386,'8b4c6480f293453d850328438bc66819','f92ea8cf-9d89-4f44-a487-3eec721c46fa',123,'094a9e5adfae45769d099eaf0d4f598c','shares',1,'2025-12-05 10:42:16',NULL),('2025-12-04 10:42:16.550835',NULL,'2025-12-04 10:42:16.586171',387,387,'8b4c6480f293453d850328438bc66819','8786cda6-e056-4271-81d5-b32f45448fc2',124,'094a9e5adfae45769d099eaf0d4f598c','gigabytes',1,'2025-12-05 10:42:16',NULL),('2025-12-04 10:42:16.560711',NULL,'2025-12-04 10:42:16.586171',388,388,NULL,'b1283c68-6284-468d-bd69-ab6fd6a4f754',125,'094a9e5adfae45769d099eaf0d4f598c','shares',1,'2025-12-05 10:42:16','df88ce48-d3e8-48b4-aca4-3e96df85fd1c'),('2025-12-04 10:42:16.562211',NULL,'2025-12-04 10:42:16.586171',389,389,NULL,'3e809d54-15b1-47ea-87af-90b9ce65a541',126,'094a9e5adfae45769d099eaf0d4f598c','gigabytes',1,'2025-12-05 10:42:16','df88ce48-d3e8-48b4-aca4-3e96df85fd1c'),('2025-12-04 10:42:20.923002',NULL,'2025-12-04 10:42:20.959449',390,390,'8b4c6480f293453d850328438bc66819','d69e7b80-49b8-459d-9440-b55ce1d9ae64',123,'094a9e5adfae45769d099eaf0d4f598c','shares',1,'2025-12-05 10:42:20',NULL),('2025-12-04 10:42:20.925068',NULL,'2025-12-04 10:42:20.959449',391,391,'8b4c6480f293453d850328438bc66819','15483b1b-3a21-465d-912c-cee8d818e9ed',124,'094a9e5adfae45769d099eaf0d4f598c','gigabytes',1,'2025-12-05 10:42:20',NULL),('2025-12-04 10:42:20.935625',NULL,'2025-12-04 10:42:20.959449',392,392,NULL,'fde288c8-3c39-4276-8c0f-4cf30218c0b9',125,'094a9e5adfae45769d099eaf0d4f598c','shares',1,'2025-12-05 10:42:20','df88ce48-d3e8-48b4-aca4-3e96df85fd1c'),('2025-12-04 10:42:20.938203',NULL,'2025-12-04 10:42:20.959449',393,393,NULL,'74862f50-d375-4eeb-8f02-a082e5724b9f',126,'094a9e5adfae45769d099eaf0d4f598c','gigabytes',1,'2025-12-05 10:42:20','df88ce48-d3e8-48b4-aca4-3e96df85fd1c'),('2025-12-04 10:42:23.393995',NULL,'2025-12-04 10:42:23.444754',394,394,'d266eff9e7ae434291697f9a69cbed9c','9cd68762-a77b-4665-834b-9f09acfcb440',127,'e5ed5896f5c141d08b886fe18ab11b56','share_networks',1,'2025-12-05 10:42:23',NULL),('2025-12-04 10:42:24.752517',NULL,'2025-12-04 10:42:24.800943',395,395,'d266eff9e7ae434291697f9a69cbed9c','180aa5cf-e3ba-4259-a47e-7cc9908622a2',127,'e5ed5896f5c141d08b886fe18ab11b56','share_networks',1,'2025-12-05 10:42:24',NULL),('2025-12-04 10:42:25.533901',NULL,'2025-12-04 10:42:25.539390',396,396,'d266eff9e7ae434291697f9a69cbed9c','84aff64a-d017-4f9f-8c2f-d2fc4128426d',127,'e5ed5896f5c141d08b886fe18ab11b56','share_networks',-1,'2025-12-05 10:42:25',NULL),('2025-12-04 10:42:25.832975',NULL,'2025-12-04 10:42:25.883869',397,397,'d266eff9e7ae434291697f9a69cbed9c','539ee795-3a5c-4672-8dfb-8ca4f67757bc',127,'e5ed5896f5c141d08b886fe18ab11b56','share_networks',1,'2025-12-05 10:42:25',NULL),('2025-12-04 10:42:26.764047',NULL,'2025-12-04 10:42:26.777250',398,398,'d266eff9e7ae434291697f9a69cbed9c','9aea97be-b8d8-4073-842a-f59b59a4fdb2',127,'e5ed5896f5c141d08b886fe18ab11b56','share_networks',-1,'2025-12-05 10:42:26',NULL),('2025-12-04 10:42:28.145261',NULL,'2025-12-04 10:42:28.152436',399,399,'d266eff9e7ae434291697f9a69cbed9c','ef0ea1b6-ea21-49ec-87fd-7697c4d50a90',127,'e5ed5896f5c141d08b886fe18ab11b56','share_networks',-1,'2025-12-05 10:42:28',NULL),('2025-12-04 10:42:28.679831',NULL,'2025-12-04 10:42:28.712329',400,400,'8b4c6480f293453d850328438bc66819','9ef918fe-848c-43e4-b4fa-479aec8a625b',123,'094a9e5adfae45769d099eaf0d4f598c','shares',-1,'2025-12-05 10:42:28',NULL),('2025-12-04 10:42:28.680596',NULL,'2025-12-04 10:42:28.712329',401,401,'8b4c6480f293453d850328438bc66819','68a4de3c-b274-4834-a43a-ec359015e74a',124,'094a9e5adfae45769d099eaf0d4f598c','gigabytes',-1,'2025-12-05 10:42:28',NULL),('2025-12-04 10:42:28.692835',NULL,'2025-12-04 10:42:28.712329',402,402,NULL,'65dd77f1-8df8-497b-9536-cd902e237b3e',125,'094a9e5adfae45769d099eaf0d4f598c','shares',-1,'2025-12-05 10:42:28','df88ce48-d3e8-48b4-aca4-3e96df85fd1c'),('2025-12-04 10:42:28.696248',NULL,'2025-12-04 10:42:28.712329',403,403,NULL,'c5400830-fcdf-466b-adcf-4d6230243e04',126,'094a9e5adfae45769d099eaf0d4f598c','gigabytes',-1,'2025-12-05 10:42:28','df88ce48-d3e8-48b4-aca4-3e96df85fd1c'),('2025-12-04 10:42:31.523250',NULL,'2025-12-04 10:42:31.560109',404,404,'8b4c6480f293453d850328438bc66819','6a503d83-da52-47b3-ae62-8f6a0ee4ab5e',123,'094a9e5adfae45769d099eaf0d4f598c','shares',1,'2025-12-05 10:42:31',NULL),('2025-12-04 10:42:31.524988',NULL,'2025-12-04 10:42:31.560109',405,405,'8b4c6480f293453d850328438bc66819','60d0b159-7f85-47f1-bc8d-8536a81d23f5',124,'094a9e5adfae45769d099eaf0d4f598c','gigabytes',1,'2025-12-05 10:42:31',NULL),('2025-12-04 10:42:31.537653',NULL,'2025-12-04 10:42:31.560109',406,406,NULL,'5c983fbd-6201-40e4-ba20-3df4fad85093',125,'094a9e5adfae45769d099eaf0d4f598c','shares',1,'2025-12-05 10:42:31','df88ce48-d3e8-48b4-aca4-3e96df85fd1c'),('2025-12-04 10:42:31.539405',NULL,'2025-12-04 10:42:31.560109',407,407,NULL,'0acc04ef-117f-485a-bb6c-5bda2c0aff1a',126,'094a9e5adfae45769d099eaf0d4f598c','gigabytes',1,'2025-12-05 10:42:31','df88ce48-d3e8-48b4-aca4-3e96df85fd1c'),('2025-12-04 10:42:35.594786',NULL,'2025-12-04 10:42:35.632977',408,408,'4326a45d529b409c82188bae1a9bcf09','28a394a8-852d-43e3-a8ce-dd618742f845',128,'2d40ae03316045f1b24640181280b9a9','share_networks',1,'2025-12-05 10:42:35',NULL),('2025-12-04 10:42:35.914646',NULL,'2025-12-04 10:42:35.961666',409,409,'4326a45d529b409c82188bae1a9bcf09','5ca2a963-2c43-4296-a364-675525a70525',128,'2d40ae03316045f1b24640181280b9a9','share_networks',1,'2025-12-05 10:42:35',NULL),('2025-12-04 10:42:36.742477',NULL,'2025-12-04 10:42:36.753973',410,410,'4326a45d529b409c82188bae1a9bcf09','adaad5cd-6c67-4e29-a7b6-6c80ae5af44b',128,'2d40ae03316045f1b24640181280b9a9','share_networks',-1,'2025-12-05 10:42:36',NULL),('2025-12-04 10:42:37.093688',NULL,'2025-12-04 10:42:37.132297',411,411,'4326a45d529b409c82188bae1a9bcf09','023468fd-c643-4340-93d1-b30213ea4b21',128,'2d40ae03316045f1b24640181280b9a9','share_networks',1,'2025-12-05 10:42:37',NULL),('2025-12-04 10:42:38.160720',NULL,'2025-12-04 10:42:38.180548',412,412,'4326a45d529b409c82188bae1a9bcf09','fe009e00-4ce0-4177-abab-c8a5a12e99d7',128,'2d40ae03316045f1b24640181280b9a9','share_networks',-1,'2025-12-05 10:42:38',NULL),('2025-12-04 10:42:39.481644',NULL,'2025-12-04 10:42:39.497495',413,413,'8b4c6480f293453d850328438bc66819','7afaa0ac-4a41-48f8-8d9c-071565aadb48',123,'094a9e5adfae45769d099eaf0d4f598c','shares',-1,'2025-12-05 10:42:39',NULL),('2025-12-04 10:42:39.482661',NULL,'2025-12-04 10:42:39.497495',414,414,'8b4c6480f293453d850328438bc66819','955a1e2a-6d40-4eed-b15c-7c7e5712ba3c',124,'094a9e5adfae45769d099eaf0d4f598c','gigabytes',-1,'2025-12-05 10:42:39',NULL),('2025-12-04 10:42:39.489901',NULL,'2025-12-04 10:42:39.497495',415,415,NULL,'d5b5804a-2183-41c8-bdf0-a6d1ebc67bca',125,'094a9e5adfae45769d099eaf0d4f598c','shares',-1,'2025-12-05 10:42:39','df88ce48-d3e8-48b4-aca4-3e96df85fd1c'),('2025-12-04 10:42:39.490573',NULL,'2025-12-04 10:42:39.497495',416,416,NULL,'e1d96a4b-8c24-4d70-8aac-390770a7694a',126,'094a9e5adfae45769d099eaf0d4f598c','gigabytes',-1,'2025-12-05 10:42:39','df88ce48-d3e8-48b4-aca4-3e96df85fd1c'),('2025-12-04 10:42:42.159422',NULL,'2025-12-04 10:42:42.207401',417,417,'8b4c6480f293453d850328438bc66819','e959eb26-060d-4f72-979c-575c326b33f7',123,'094a9e5adfae45769d099eaf0d4f598c','shares',1,'2025-12-05 10:42:42',NULL),('2025-12-04 10:42:42.160691',NULL,'2025-12-04 10:42:42.207401',418,418,'8b4c6480f293453d850328438bc66819','286eb688-f4bf-4285-860b-891a07d947e1',124,'094a9e5adfae45769d099eaf0d4f598c','gigabytes',1,'2025-12-05 10:42:42',NULL),('2025-12-04 10:42:42.174102',NULL,'2025-12-04 10:42:42.207401',419,419,NULL,'ec8a525c-ace2-42b7-bcd9-096372c96daf',125,'094a9e5adfae45769d099eaf0d4f598c','shares',1,'2025-12-05 10:42:42','df88ce48-d3e8-48b4-aca4-3e96df85fd1c'),('2025-12-04 10:42:42.175734',NULL,'2025-12-04 10:42:42.207401',420,420,NULL,'dbf8262d-102d-4671-bcd3-5ff3e22b810a',126,'094a9e5adfae45769d099eaf0d4f598c','gigabytes',1,'2025-12-05 10:42:42','df88ce48-d3e8-48b4-aca4-3e96df85fd1c'),('2025-12-04 10:42:45.188781',NULL,'2025-12-04 10:42:45.248186',421,421,'d3c52ac6184348f5b9994127e3eeb5e5','4f6457e4-1998-47f0-ac73-4ce7c450bd7b',130,'e2d34491d1094a9480aa03d0d203a852','shares',1,'2025-12-05 10:42:45',NULL),('2025-12-04 10:42:45.191537',NULL,'2025-12-04 10:42:45.248186',422,422,'d3c52ac6184348f5b9994127e3eeb5e5','fd397545-9723-492b-b8f8-0c94c5c42588',129,'e2d34491d1094a9480aa03d0d203a852','gigabytes',1,'2025-12-05 10:42:45',NULL),('2025-12-04 10:42:45.205417',NULL,'2025-12-04 10:42:45.248186',423,423,NULL,'4d93198b-ab0c-4b2b-afd3-62c5ef780e41',132,'e2d34491d1094a9480aa03d0d203a852','shares',1,'2025-12-05 10:42:45','d20023e3-0d3f-4f8d-bc4b-35c7fd908150'),('2025-12-04 10:42:45.207309',NULL,'2025-12-04 10:42:45.248186',424,424,NULL,'ecef8140-14d7-46ea-9026-c293492d4541',131,'e2d34491d1094a9480aa03d0d203a852','gigabytes',1,'2025-12-05 10:42:45','d20023e3-0d3f-4f8d-bc4b-35c7fd908150'),('2025-12-04 10:42:49.384735',NULL,'2025-12-04 10:42:49.399792',425,425,'d3c52ac6184348f5b9994127e3eeb5e5','cc7ad770-b63e-471b-ae55-6c890f8b5418',130,'e2d34491d1094a9480aa03d0d203a852','shares',-1,'2025-12-05 10:42:49',NULL),('2025-12-04 10:42:49.385461',NULL,'2025-12-04 10:42:49.399792',426,426,'d3c52ac6184348f5b9994127e3eeb5e5','f6158f20-7e17-42f9-8019-094fc73cbf48',129,'e2d34491d1094a9480aa03d0d203a852','gigabytes',-1,'2025-12-05 10:42:49',NULL),('2025-12-04 10:42:49.392752',NULL,'2025-12-04 10:42:49.399792',427,427,NULL,'adf4e398-8497-4b73-99ab-c3f338495dd8',132,'e2d34491d1094a9480aa03d0d203a852','shares',-1,'2025-12-05 10:42:49','d20023e3-0d3f-4f8d-bc4b-35c7fd908150'),('2025-12-04 10:42:49.393451',NULL,'2025-12-04 10:42:49.399792',428,428,NULL,'2ca7564b-76c4-4ae4-a9fa-68fec94e5f91',131,'e2d34491d1094a9480aa03d0d203a852','gigabytes',-1,'2025-12-05 10:42:49','d20023e3-0d3f-4f8d-bc4b-35c7fd908150'),('2025-12-04 10:42:49.585906',NULL,'2025-12-04 10:42:49.639520',429,429,'1bb26f77770d4e0093ade4fe9d48231b','fc66cc07-be4d-4d1c-82e9-091e5fad2780',133,'861ef911050d4b8ba35e89f01c620f89','share_networks',1,'2025-12-05 10:42:49',NULL),('2025-12-04 10:42:49.606817',NULL,'2025-12-04 10:42:49.659453',430,430,'d3c52ac6184348f5b9994127e3eeb5e5','6c663be1-0fbb-432c-b68f-58849811a934',130,'e2d34491d1094a9480aa03d0d203a852','shares',1,'2025-12-05 10:42:49',NULL),('2025-12-04 10:42:49.608090',NULL,'2025-12-04 10:42:49.659453',431,431,'d3c52ac6184348f5b9994127e3eeb5e5','5d727b7d-2529-4b88-9380-81aac97a6630',129,'e2d34491d1094a9480aa03d0d203a852','gigabytes',1,'2025-12-05 10:42:49',NULL),('2025-12-04 10:42:49.624625',NULL,'2025-12-04 10:42:49.659453',432,432,NULL,'02b5330d-ee1d-454d-9696-d2bb71818229',135,'e2d34491d1094a9480aa03d0d203a852','shares',1,'2025-12-05 10:42:49','6689d307-ef56-40d7-ad85-62dddaf7d4ba'),('2025-12-04 10:42:49.625876',NULL,'2025-12-04 10:42:49.659453',433,433,NULL,'ccdd44ea-fa6c-4552-83b5-3118c0011ca0',134,'e2d34491d1094a9480aa03d0d203a852','gigabytes',1,'2025-12-05 10:42:49','6689d307-ef56-40d7-ad85-62dddaf7d4ba'),('2025-12-04 10:42:49.938338',NULL,'2025-12-04 10:42:49.977734',434,434,'1bb26f77770d4e0093ade4fe9d48231b','f1e30539-d789-4f80-88f0-d4a7b1c3033c',133,'861ef911050d4b8ba35e89f01c620f89','share_networks',1,'2025-12-05 10:42:49',NULL),('2025-12-04 10:42:50.136650',NULL,'2025-12-04 10:42:50.149728',435,435,'8b4c6480f293453d850328438bc66819','5058e65b-9128-4d18-883a-867d39704dd2',123,'094a9e5adfae45769d099eaf0d4f598c','shares',-1,'2025-12-05 10:42:50',NULL),('2025-12-04 10:42:50.137340',NULL,'2025-12-04 10:42:50.149728',436,436,'8b4c6480f293453d850328438bc66819','c99e93f5-eb74-4c62-9d54-8dc4ab085f11',124,'094a9e5adfae45769d099eaf0d4f598c','gigabytes',-1,'2025-12-05 10:42:50',NULL),('2025-12-04 10:42:50.142106',NULL,'2025-12-04 10:42:50.149728',437,437,NULL,'e6174210-ac2c-415c-9c43-a2886dd237e3',125,'094a9e5adfae45769d099eaf0d4f598c','shares',-1,'2025-12-05 10:42:50','df88ce48-d3e8-48b4-aca4-3e96df85fd1c'),('2025-12-04 10:42:50.142746',NULL,'2025-12-04 10:42:50.149728',438,438,NULL,'89eb121e-3bcc-45bd-902c-174d14b58631',126,'094a9e5adfae45769d099eaf0d4f598c','gigabytes',-1,'2025-12-05 10:42:50','df88ce48-d3e8-48b4-aca4-3e96df85fd1c'),('2025-12-04 10:42:50.277166',NULL,'2025-12-04 10:42:50.309246',439,439,'1bb26f77770d4e0093ade4fe9d48231b','1c3fe9f7-a797-4592-8e90-81581744aba8',133,'861ef911050d4b8ba35e89f01c620f89','share_networks',1,'2025-12-05 10:42:50',NULL),('2025-12-04 10:42:50.775935',NULL,'2025-12-04 10:42:50.780592',440,440,'1bb26f77770d4e0093ade4fe9d48231b','675ad665-d85d-4445-9345-4d83d90fe489',133,'861ef911050d4b8ba35e89f01c620f89','share_networks',-1,'2025-12-05 10:42:50',NULL),('2025-12-04 10:42:51.170501',NULL,'2025-12-04 10:42:51.202479',441,441,'1bb26f77770d4e0093ade4fe9d48231b','48e60c67-b425-4f09-aaf6-3983f8ead533',133,'861ef911050d4b8ba35e89f01c620f89','share_networks',1,'2025-12-05 10:42:51',NULL),('2025-12-04 10:42:51.303496',NULL,'2025-12-04 10:42:51.335439',442,442,'1bb26f77770d4e0093ade4fe9d48231b','eebaf29a-0833-4add-8623-086e571b4ef3',133,'861ef911050d4b8ba35e89f01c620f89','share_networks',1,'2025-12-05 10:42:51',NULL),('2025-12-04 10:42:51.489432',NULL,'2025-12-04 10:42:51.498945',443,443,'1bb26f77770d4e0093ade4fe9d48231b','391335e8-a4eb-4cb0-a384-cd806c123f1e',133,'861ef911050d4b8ba35e89f01c620f89','share_networks',-1,'2025-12-05 10:42:51',NULL),('2025-12-04 10:42:51.732316',NULL,'2025-12-04 10:42:51.749943',444,444,'1bb26f77770d4e0093ade4fe9d48231b','6bc3d56d-c829-42c7-a662-6b4ac3890962',133,'861ef911050d4b8ba35e89f01c620f89','share_networks',-1,'2025-12-05 10:42:51',NULL),('2025-12-04 10:42:52.805033',NULL,'2025-12-04 10:42:52.838238',445,445,'1bb26f77770d4e0093ade4fe9d48231b','4e0af6a6-6e3b-41f0-bcfb-2a96f310e40e',133,'861ef911050d4b8ba35e89f01c620f89','share_networks',1,'2025-12-05 10:42:52',NULL),('2025-12-04 10:42:53.074538',NULL,'2025-12-04 10:42:53.082592',446,446,'1bb26f77770d4e0093ade4fe9d48231b','c43df69a-7dc7-4fb9-9e5e-58c9e3506a7d',133,'861ef911050d4b8ba35e89f01c620f89','share_networks',-1,'2025-12-05 10:42:53',NULL),('2025-12-04 10:42:53.181591',NULL,'2025-12-04 10:42:53.231673',447,447,'1bb26f77770d4e0093ade4fe9d48231b','5d5a7454-f000-4b0e-92a0-1bfbd5810aae',133,'861ef911050d4b8ba35e89f01c620f89','share_networks',1,'2025-12-05 10:42:53',NULL),('2025-12-04 10:42:53.393536',NULL,'2025-12-04 10:42:53.414640',448,448,'d3c52ac6184348f5b9994127e3eeb5e5','d25ea0ac-3246-483b-939d-821a7df0f251',130,'e2d34491d1094a9480aa03d0d203a852','shares',-1,'2025-12-05 10:42:53',NULL),('2025-12-04 10:42:53.394359',NULL,'2025-12-04 10:42:53.414640',449,449,'d3c52ac6184348f5b9994127e3eeb5e5','726b4f20-e168-498f-b6ce-89b575520f4f',129,'e2d34491d1094a9480aa03d0d203a852','gigabytes',-1,'2025-12-05 10:42:53',NULL),('2025-12-04 10:42:53.404168',NULL,'2025-12-04 10:42:53.414640',450,450,NULL,'d6db5a8d-2e43-47bb-931f-f0c08d0c7436',135,'e2d34491d1094a9480aa03d0d203a852','shares',-1,'2025-12-05 10:42:53','6689d307-ef56-40d7-ad85-62dddaf7d4ba'),('2025-12-04 10:42:53.405372',NULL,'2025-12-04 10:42:53.414640',451,451,NULL,'1f58247e-a982-4cb6-856f-9d83fd2d929d',134,'e2d34491d1094a9480aa03d0d203a852','gigabytes',-1,'2025-12-05 10:42:53','6689d307-ef56-40d7-ad85-62dddaf7d4ba'),('2025-12-04 10:42:53.430521',NULL,'2025-12-04 10:42:53.438105',452,452,'1bb26f77770d4e0093ade4fe9d48231b','795925cd-8b3c-465d-9b86-704030026fdc',133,'861ef911050d4b8ba35e89f01c620f89','share_networks',-1,'2025-12-05 10:42:53',NULL),('2025-12-04 10:42:53.743045',NULL,'2025-12-04 10:42:53.781632',453,453,'d3c52ac6184348f5b9994127e3eeb5e5','7977d131-f653-4e27-b929-3d95a6bfa5d7',130,'e2d34491d1094a9480aa03d0d203a852','shares',1,'2025-12-05 10:42:53',NULL),('2025-12-04 10:42:53.744198',NULL,'2025-12-04 10:42:53.781632',454,454,'d3c52ac6184348f5b9994127e3eeb5e5','c0409ed4-e031-4f07-8591-7c5dd02d1963',129,'e2d34491d1094a9480aa03d0d203a852','gigabytes',1,'2025-12-05 10:42:53',NULL),('2025-12-04 10:42:53.754098',NULL,'2025-12-04 10:42:53.781632',455,455,NULL,'bc3386ea-e1ee-4ab0-838c-af5e8a6c06ae',137,'e2d34491d1094a9480aa03d0d203a852','shares',1,'2025-12-05 10:42:53','bae4e5c8-4bd0-4aef-8463-ce3e493d8f98'),('2025-12-04 10:42:53.755171',NULL,'2025-12-04 10:42:53.781632',456,456,NULL,'78db8c44-57f7-4c3a-b8c1-4d34dac844ad',136,'e2d34491d1094a9480aa03d0d203a852','gigabytes',1,'2025-12-05 10:42:53','bae4e5c8-4bd0-4aef-8463-ce3e493d8f98'),('2025-12-04 10:42:53.909526',NULL,'2025-12-04 10:42:53.960274',457,457,'a70fe8cd329045aea5fadbb81acb5c56','89cb976e-db4d-492c-93c4-72ff0060e261',139,'991152b6ddef4a77a0c0088882c63fa1','shares',1,'2025-12-05 10:42:53',NULL),('2025-12-04 10:42:53.912443',NULL,'2025-12-04 10:42:53.960274',458,458,'a70fe8cd329045aea5fadbb81acb5c56','6a0ebda0-ed53-4a23-bf7d-580b4593cb3e',138,'991152b6ddef4a77a0c0088882c63fa1','gigabytes',1,'2025-12-05 10:42:53',NULL),('2025-12-04 10:42:53.923949',NULL,'2025-12-04 10:42:53.960274',459,459,NULL,'92544efb-ff69-46df-ae4d-03c9f67682b5',141,'991152b6ddef4a77a0c0088882c63fa1','shares',1,'2025-12-05 10:42:53','6f383b65-791c-4bc0-a865-8a8a9d0fd30c'),('2025-12-04 10:42:53.925731',NULL,'2025-12-04 10:42:53.960274',460,460,NULL,'a221d015-40d7-4bea-a7db-987c4267f466',140,'991152b6ddef4a77a0c0088882c63fa1','gigabytes',1,'2025-12-05 10:42:53','6f383b65-791c-4bc0-a865-8a8a9d0fd30c'),('2025-12-04 10:42:54.727478',NULL,'2025-12-04 10:42:54.732413',461,461,'1bb26f77770d4e0093ade4fe9d48231b','ce44290b-27aa-4588-b516-738c611b5e81',133,'861ef911050d4b8ba35e89f01c620f89','share_networks',-1,'2025-12-05 10:42:54',NULL),('2025-12-04 10:42:55.022785',NULL,'2025-12-04 10:42:55.029891',462,462,'1bb26f77770d4e0093ade4fe9d48231b','98d5cc84-dd6f-4393-8cee-4bb5d177f444',133,'861ef911050d4b8ba35e89f01c620f89','share_networks',-1,'2025-12-05 10:42:55',NULL),('2025-12-04 10:42:57.470744',NULL,'2025-12-04 10:42:57.518492',463,463,'d3c52ac6184348f5b9994127e3eeb5e5','92fd872d-5ad4-430b-bcb2-9e8f2bfa42e9',130,'e2d34491d1094a9480aa03d0d203a852','shares',1,'2025-12-05 10:42:57',NULL),('2025-12-04 10:42:57.473661',NULL,'2025-12-04 10:42:57.518492',464,464,'d3c52ac6184348f5b9994127e3eeb5e5','7e7bc483-53c7-4249-a549-56729523484a',129,'e2d34491d1094a9480aa03d0d203a852','gigabytes',1,'2025-12-05 10:42:57',NULL),('2025-12-04 10:42:57.484532',NULL,'2025-12-04 10:42:57.518492',465,465,NULL,'fb0fa7b2-03d5-4958-8334-9aeae56bf8b4',143,'e2d34491d1094a9480aa03d0d203a852','shares',1,'2025-12-05 10:42:57','ce0f25d3-27ba-44eb-9b51-7c8fa400875f'),('2025-12-04 10:42:57.485600',NULL,'2025-12-04 10:42:57.518492',466,466,NULL,'0304417c-5f90-4afe-9896-d4f0ba33b3b6',142,'e2d34491d1094a9480aa03d0d203a852','gigabytes',1,'2025-12-05 10:42:57','ce0f25d3-27ba-44eb-9b51-7c8fa400875f'),('2025-12-04 10:42:57.814213',NULL,'2025-12-04 10:42:57.983108',467,467,'936c73f02b5847adbbe71630454de16e','3c0d4955-f65c-43ab-9ca2-0f1200d2c981',145,'bf5ccaceeccc42cc87df11329a9d0159','shares',1,'2025-12-05 10:42:57',NULL),('2025-12-04 10:42:57.815197',NULL,'2025-12-04 10:42:57.983108',468,468,'936c73f02b5847adbbe71630454de16e','49706e66-eb38-48fd-b415-7057175b6807',144,'bf5ccaceeccc42cc87df11329a9d0159','gigabytes',1,'2025-12-05 10:42:57',NULL),('2025-12-04 10:42:57.837074',NULL,'2025-12-04 10:42:57.998715',469,469,'936c73f02b5847adbbe71630454de16e','b438bd8d-f4bd-4f2d-b3c9-1116cf8efdd1',147,'991152b6ddef4a77a0c0088882c63fa1','shares',-1,'2025-12-05 10:42:57',NULL),('2025-12-04 10:42:57.837981',NULL,'2025-12-04 10:42:57.998715',470,470,'936c73f02b5847adbbe71630454de16e','f6dd1574-a26c-4cff-8757-61ed307ac3e0',146,'991152b6ddef4a77a0c0088882c63fa1','gigabytes',-1,'2025-12-05 10:42:57',NULL),('2025-12-04 10:42:58.735875',NULL,'2025-12-04 10:42:58.756360',471,471,'936c73f02b5847adbbe71630454de16e','bb369796-21d1-4203-8dd2-4bf229299c1e',145,'bf5ccaceeccc42cc87df11329a9d0159','shares',-1,'2025-12-05 10:42:58',NULL),('2025-12-04 10:42:58.736653',NULL,'2025-12-04 10:42:58.756360',472,472,'936c73f02b5847adbbe71630454de16e','f2313bfc-5964-430f-bb4e-167dc51d03d4',144,'bf5ccaceeccc42cc87df11329a9d0159','gigabytes',-1,'2025-12-05 10:42:58',NULL),('2025-12-04 10:42:58.749234',NULL,'2025-12-04 10:42:58.756360',473,473,NULL,'9627e4ba-dedf-415a-9753-15956297c976',148,'bf5ccaceeccc42cc87df11329a9d0159','shares',-1,'2025-12-05 10:42:58','6f383b65-791c-4bc0-a865-8a8a9d0fd30c'),('2025-12-04 10:42:58.749885',NULL,'2025-12-04 10:42:58.756360',474,474,NULL,'01b25961-77cb-4b8e-bf41-9f1eb3048102',149,'bf5ccaceeccc42cc87df11329a9d0159','gigabytes',-1,'2025-12-05 10:42:58','6f383b65-791c-4bc0-a865-8a8a9d0fd30c'),('2025-12-04 10:43:01.143043',NULL,'2025-12-04 10:43:01.157191',475,475,'d3c52ac6184348f5b9994127e3eeb5e5','59827805-ef92-4891-adf7-f033740384af',130,'e2d34491d1094a9480aa03d0d203a852','shares',-1,'2025-12-05 10:43:01',NULL),('2025-12-04 10:43:01.143724',NULL,'2025-12-04 10:43:01.157191',476,476,'d3c52ac6184348f5b9994127e3eeb5e5','773c8587-0747-4e4a-9ad0-202e69150afe',129,'e2d34491d1094a9480aa03d0d203a852','gigabytes',-1,'2025-12-05 10:43:01',NULL),('2025-12-04 10:43:01.149165',NULL,'2025-12-04 10:43:01.157191',477,477,NULL,'32095154-e755-48ad-b4f1-b3b29853df6c',143,'e2d34491d1094a9480aa03d0d203a852','shares',-1,'2025-12-05 10:43:01','ce0f25d3-27ba-44eb-9b51-7c8fa400875f'),('2025-12-04 10:43:01.149769',NULL,'2025-12-04 10:43:01.157191',478,478,NULL,'38e36e59-97ed-493b-8e8d-f4d8c1225452',142,'e2d34491d1094a9480aa03d0d203a852','gigabytes',-1,'2025-12-05 10:43:01','ce0f25d3-27ba-44eb-9b51-7c8fa400875f'),('2025-12-04 10:43:01.525963',NULL,'2025-12-04 10:43:01.540650',479,479,'d3c52ac6184348f5b9994127e3eeb5e5','4c918e6a-b769-4b02-9187-e01823bf713b',130,'e2d34491d1094a9480aa03d0d203a852','shares',-1,'2025-12-05 10:43:01',NULL),('2025-12-04 10:43:01.526851',NULL,'2025-12-04 10:43:01.540650',480,480,'d3c52ac6184348f5b9994127e3eeb5e5','1d7bc52e-85b1-46a5-8fe8-3c57f8211589',129,'e2d34491d1094a9480aa03d0d203a852','gigabytes',-1,'2025-12-05 10:43:01',NULL),('2025-12-04 10:43:01.533074',NULL,'2025-12-04 10:43:01.540650',481,481,NULL,'0200c0ec-6d6e-4203-a7be-f5e2c595c6c5',137,'e2d34491d1094a9480aa03d0d203a852','shares',-1,'2025-12-05 10:43:01','bae4e5c8-4bd0-4aef-8463-ce3e493d8f98'),('2025-12-04 10:43:01.533979',NULL,'2025-12-04 10:43:01.540650',482,482,NULL,'f10f80bb-66d9-4057-9a8e-d13c4bfacbdf',136,'e2d34491d1094a9480aa03d0d203a852','gigabytes',-1,'2025-12-05 10:43:01','bae4e5c8-4bd0-4aef-8463-ce3e493d8f98'),('2025-12-04 10:43:01.749743',NULL,'2025-12-04 10:43:01.792529',483,483,'d3c52ac6184348f5b9994127e3eeb5e5','9899568b-da79-4c6c-ab47-048dcb10cb01',130,'e2d34491d1094a9480aa03d0d203a852','shares',1,'2025-12-05 10:43:01',NULL),('2025-12-04 10:43:01.752560',NULL,'2025-12-04 10:43:01.792529',484,484,'d3c52ac6184348f5b9994127e3eeb5e5','34714e69-d5fd-4847-ab99-7fa80e4782c3',129,'e2d34491d1094a9480aa03d0d203a852','gigabytes',1,'2025-12-05 10:43:01',NULL),('2025-12-04 10:43:01.766638',NULL,'2025-12-04 10:43:01.792529',485,485,NULL,'cf79d10f-e2f7-49ed-8fa0-969707672976',151,'e2d34491d1094a9480aa03d0d203a852','shares',1,'2025-12-05 10:43:01','51dc31d5-ae2f-4cc3-99b0-d9bca2c752df'),('2025-12-04 10:43:01.767927',NULL,'2025-12-04 10:43:01.792529',486,486,NULL,'fe652cce-1f6b-4070-864b-271eeff0f485',150,'e2d34491d1094a9480aa03d0d203a852','gigabytes',1,'2025-12-05 10:43:01','51dc31d5-ae2f-4cc3-99b0-d9bca2c752df'),('2025-12-04 10:43:01.866879',NULL,'2025-12-04 10:43:01.908749',487,487,'a70fe8cd329045aea5fadbb81acb5c56','e8f7a270-049c-4c33-b162-64bf34915098',139,'991152b6ddef4a77a0c0088882c63fa1','shares',1,'2025-12-05 10:43:01',NULL),('2025-12-04 10:43:01.869148',NULL,'2025-12-04 10:43:01.908749',488,488,'a70fe8cd329045aea5fadbb81acb5c56','ba458e13-c8e9-46cf-8828-06fbebbe40aa',138,'991152b6ddef4a77a0c0088882c63fa1','gigabytes',1,'2025-12-05 10:43:01',NULL),('2025-12-04 10:43:01.874795',NULL,'2025-12-04 10:43:01.908749',489,489,NULL,'306df99f-a8fe-465c-b139-91e10d36bddc',141,'991152b6ddef4a77a0c0088882c63fa1','shares',1,'2025-12-05 10:43:01','6f383b65-791c-4bc0-a865-8a8a9d0fd30c'),('2025-12-04 10:43:01.875747',NULL,'2025-12-04 10:43:01.908749',490,490,NULL,'afe9425a-3fee-4d3d-9259-b5fe4c5cefb1',140,'991152b6ddef4a77a0c0088882c63fa1','gigabytes',1,'2025-12-05 10:43:01','6f383b65-791c-4bc0-a865-8a8a9d0fd30c'),('2025-12-04 10:43:03.371583',NULL,'2025-12-04 10:43:03.397045',491,491,'2a76d8ce1fb140f5bbbd61ac660038f7','c83ef535-b068-4c4b-9d15-55fed4803682',152,'6df96f3f7888473c8c4020fd09afd972','share_networks',1,'2025-12-05 10:43:03',NULL),('2025-12-04 10:43:03.634616',NULL,'2025-12-04 10:43:03.639458',492,492,'2a76d8ce1fb140f5bbbd61ac660038f7','6bec7fd3-bc12-4be7-b896-fcb5058b6fc3',152,'6df96f3f7888473c8c4020fd09afd972','share_networks',-1,'2025-12-05 10:43:03',NULL),('2025-12-04 10:43:03.898855',NULL,'2025-12-04 10:43:03.928539',493,493,'2a76d8ce1fb140f5bbbd61ac660038f7','18691e67-935c-40f1-a346-93562d86ec9f',152,'6df96f3f7888473c8c4020fd09afd972','share_networks',1,'2025-12-05 10:43:03',NULL),('2025-12-04 10:43:04.627000',NULL,'2025-12-04 10:43:04.634013',494,494,'2a76d8ce1fb140f5bbbd61ac660038f7','12944ad5-07d1-4fee-af19-4183aae932cb',152,'6df96f3f7888473c8c4020fd09afd972','share_networks',-1,'2025-12-05 10:43:04',NULL),('2025-12-04 10:43:05.070187',NULL,'2025-12-04 10:43:05.099744',495,495,'2a76d8ce1fb140f5bbbd61ac660038f7','864413a5-f20e-485b-a595-93422f586667',152,'6df96f3f7888473c8c4020fd09afd972','share_networks',1,'2025-12-05 10:43:05',NULL),('2025-12-04 10:43:05.275765',NULL,'2025-12-04 10:43:05.283625',496,496,'2a76d8ce1fb140f5bbbd61ac660038f7','6b9971a7-9e87-4533-b07d-c3c8a40dd330',152,'6df96f3f7888473c8c4020fd09afd972','share_networks',-1,'2025-12-05 10:43:05',NULL),('2025-12-04 10:43:05.344609',NULL,'2025-12-04 10:43:05.394509',497,497,'d3c52ac6184348f5b9994127e3eeb5e5','7d78fc63-cced-478b-9de9-da49d8deb7a4',130,'e2d34491d1094a9480aa03d0d203a852','shares',1,'2025-12-05 10:43:05',NULL),('2025-12-04 10:43:05.345993',NULL,'2025-12-04 10:43:05.394509',498,498,'d3c52ac6184348f5b9994127e3eeb5e5','4b175a9d-4309-4699-9b2e-42c684103498',129,'e2d34491d1094a9480aa03d0d203a852','gigabytes',1,'2025-12-05 10:43:05',NULL),('2025-12-04 10:43:05.365203',NULL,'2025-12-04 10:43:05.394509',499,499,NULL,'c7446bd3-20ef-46ca-84cd-9076ece35afa',154,'e2d34491d1094a9480aa03d0d203a852','shares',1,'2025-12-05 10:43:05','7793f738-7930-4537-9dfb-f37145dcc966'),('2025-12-04 10:43:05.367247',NULL,'2025-12-04 10:43:05.394509',500,500,NULL,'4d3f5f42-ee56-4b16-9321-2531f9634510',153,'e2d34491d1094a9480aa03d0d203a852','gigabytes',1,'2025-12-05 10:43:05','7793f738-7930-4537-9dfb-f37145dcc966'),('2025-12-04 10:43:06.241425',NULL,'2025-12-04 10:43:06.266745',501,501,'a70fe8cd329045aea5fadbb81acb5c56','a46b296f-c85c-4f57-a5e2-71806c0715bf',139,'991152b6ddef4a77a0c0088882c63fa1','shares',-1,'2025-12-05 10:43:06',NULL),('2025-12-04 10:43:06.242317',NULL,'2025-12-04 10:43:06.266745',502,502,'a70fe8cd329045aea5fadbb81acb5c56','f82c4aeb-da92-4caf-a481-e19deeb367cd',138,'991152b6ddef4a77a0c0088882c63fa1','gigabytes',-1,'2025-12-05 10:43:06',NULL),('2025-12-04 10:43:06.253977',NULL,'2025-12-04 10:43:06.266745',503,503,NULL,'d9a22a21-5509-4013-8eb9-7526cfa4735b',141,'991152b6ddef4a77a0c0088882c63fa1','shares',-1,'2025-12-05 10:43:06','6f383b65-791c-4bc0-a865-8a8a9d0fd30c'),('2025-12-04 10:43:06.255387',NULL,'2025-12-04 10:43:06.266745',504,504,NULL,'48c4c9ba-8aef-44a3-a812-47bcea51227f',140,'991152b6ddef4a77a0c0088882c63fa1','gigabytes',-1,'2025-12-05 10:43:06','6f383b65-791c-4bc0-a865-8a8a9d0fd30c'),('2025-12-04 10:43:08.918378',NULL,'2025-12-04 10:43:08.950866',505,505,'d3c52ac6184348f5b9994127e3eeb5e5','7118a2f8-8bfc-492a-b747-32d3ecbaf7a6',130,'e2d34491d1094a9480aa03d0d203a852','shares',1,'2025-12-05 10:43:08',NULL),('2025-12-04 10:43:08.919526',NULL,'2025-12-04 10:43:08.950866',506,506,'d3c52ac6184348f5b9994127e3eeb5e5','bfa7d2f0-d202-4b0a-8112-e0335ce697d4',129,'e2d34491d1094a9480aa03d0d203a852','gigabytes',1,'2025-12-05 10:43:08',NULL),('2025-12-04 10:43:08.928950',NULL,'2025-12-04 10:43:08.950866',507,507,NULL,'3b46b0f5-41f4-4116-9000-a6cfb545fd3e',156,'e2d34491d1094a9480aa03d0d203a852','shares',1,'2025-12-05 10:43:08','6836a084-0716-44fd-a4c3-db6585ee754e'),('2025-12-04 10:43:08.930629',NULL,'2025-12-04 10:43:08.950866',508,508,NULL,'5db89668-57cc-4ece-bfcb-bdb327928881',155,'e2d34491d1094a9480aa03d0d203a852','gigabytes',1,'2025-12-05 10:43:08','6836a084-0716-44fd-a4c3-db6585ee754e'),('2025-12-04 10:43:12.652845',NULL,'2025-12-04 10:43:12.674243',509,509,'d3c52ac6184348f5b9994127e3eeb5e5','a1c40ff9-edec-4136-afc5-597db70b1375',130,'e2d34491d1094a9480aa03d0d203a852','shares',-1,'2025-12-05 10:43:12',NULL),('2025-12-04 10:43:12.653700',NULL,'2025-12-04 10:43:12.674243',510,510,'d3c52ac6184348f5b9994127e3eeb5e5','66882546-7a50-466f-a948-1e8d16df80a7',129,'e2d34491d1094a9480aa03d0d203a852','gigabytes',-1,'2025-12-05 10:43:12',NULL),('2025-12-04 10:43:12.659610',NULL,'2025-12-04 10:43:12.674243',511,511,NULL,'b9b2f7ab-48f2-4c49-ba80-5cc0ea28445a',156,'e2d34491d1094a9480aa03d0d203a852','shares',-1,'2025-12-05 10:43:12','6836a084-0716-44fd-a4c3-db6585ee754e'),('2025-12-04 10:43:12.661577',NULL,'2025-12-04 10:43:12.674243',512,512,NULL,'56cc68fd-7af8-4288-8f20-41e525f446ad',155,'e2d34491d1094a9480aa03d0d203a852','gigabytes',-1,'2025-12-05 10:43:12','6836a084-0716-44fd-a4c3-db6585ee754e'),('2025-12-04 10:43:12.993166',NULL,'2025-12-04 10:43:13.007613',513,513,'d3c52ac6184348f5b9994127e3eeb5e5','9d45cdea-adda-4ada-9db8-cd0a97ecc3f3',130,'e2d34491d1094a9480aa03d0d203a852','shares',-1,'2025-12-05 10:43:12',NULL),('2025-12-04 10:43:12.993869',NULL,'2025-12-04 10:43:13.007613',514,514,'d3c52ac6184348f5b9994127e3eeb5e5','3c5c55ad-2f1d-408f-ac4b-c361f3ab7893',129,'e2d34491d1094a9480aa03d0d203a852','gigabytes',-1,'2025-12-05 10:43:12',NULL),('2025-12-04 10:43:13.000315',NULL,'2025-12-04 10:43:13.007613',515,515,NULL,'a68b2b69-94c1-406e-89a6-aa94d82a9b1d',154,'e2d34491d1094a9480aa03d0d203a852','shares',-1,'2025-12-05 10:43:12','7793f738-7930-4537-9dfb-f37145dcc966'),('2025-12-04 10:43:13.001000',NULL,'2025-12-04 10:43:13.007613',516,516,NULL,'a63d21e1-4cb0-4350-988a-55ebbc8dbcc2',153,'e2d34491d1094a9480aa03d0d203a852','gigabytes',-1,'2025-12-05 10:43:12','7793f738-7930-4537-9dfb-f37145dcc966'),('2025-12-04 10:43:13.379497',NULL,'2025-12-04 10:43:13.412207',517,517,'d3c52ac6184348f5b9994127e3eeb5e5','c795f76f-45c0-405d-abfc-d49e53018617',130,'e2d34491d1094a9480aa03d0d203a852','shares',-1,'2025-12-05 10:43:13',NULL),('2025-12-04 10:43:13.380703',NULL,'2025-12-04 10:43:13.412207',518,518,'d3c52ac6184348f5b9994127e3eeb5e5','d19ff773-1994-433d-aa39-4bff72d271ab',129,'e2d34491d1094a9480aa03d0d203a852','gigabytes',-1,'2025-12-05 10:43:13',NULL),('2025-12-04 10:43:13.392531',NULL,'2025-12-04 10:43:13.412207',519,519,NULL,'e6f30b6f-7187-4d4c-a6bd-a6481b9cecf2',151,'e2d34491d1094a9480aa03d0d203a852','shares',-1,'2025-12-05 10:43:13','51dc31d5-ae2f-4cc3-99b0-d9bca2c752df'),('2025-12-04 10:43:13.393393',NULL,'2025-12-04 10:43:13.412207',520,520,NULL,'f0ca95a7-19d6-40bb-a12a-ea90e35cc59a',150,'e2d34491d1094a9480aa03d0d203a852','gigabytes',-1,'2025-12-05 10:43:13','51dc31d5-ae2f-4cc3-99b0-d9bca2c752df'),('2025-12-04 10:43:13.723495',NULL,'2025-12-04 10:43:13.782252',521,521,'d3c52ac6184348f5b9994127e3eeb5e5','03cce33a-1cb7-4b70-bda8-bf42f6e8a5f3',130,'e2d34491d1094a9480aa03d0d203a852','shares',1,'2025-12-05 10:43:13',NULL),('2025-12-04 10:43:13.725055',NULL,'2025-12-04 10:43:13.782252',522,522,'d3c52ac6184348f5b9994127e3eeb5e5','00706c43-8d9e-4b26-b9ee-96fe59f4af0c',129,'e2d34491d1094a9480aa03d0d203a852','gigabytes',1,'2025-12-05 10:43:13',NULL),('2025-12-04 10:43:13.746595',NULL,'2025-12-04 10:43:13.782252',523,523,NULL,'0522ebdd-9d18-42d1-8b9f-24b46579568f',157,'e2d34491d1094a9480aa03d0d203a852','shares',1,'2025-12-05 10:43:13','515a821b-2c06-477c-82fe-373c817226c6'),('2025-12-04 10:43:13.748903',NULL,'2025-12-04 10:43:13.782252',524,524,NULL,'46ce5224-b756-4aca-ad3f-ea24166664a1',158,'e2d34491d1094a9480aa03d0d203a852','gigabytes',1,'2025-12-05 10:43:13','515a821b-2c06-477c-82fe-373c817226c6'),('2025-12-04 10:43:17.378099',NULL,'2025-12-04 10:43:17.417604',525,525,'d3c52ac6184348f5b9994127e3eeb5e5','d7c0a123-52d7-424e-8ca5-e2adcf19b1ac',130,'e2d34491d1094a9480aa03d0d203a852','shares',1,'2025-12-05 10:43:17',NULL),('2025-12-04 10:43:17.379290',NULL,'2025-12-04 10:43:17.417604',526,526,'d3c52ac6184348f5b9994127e3eeb5e5','bee3db00-71e8-48d4-9b1b-2c92edc04c92',129,'e2d34491d1094a9480aa03d0d203a852','gigabytes',1,'2025-12-05 10:43:17',NULL),('2025-12-04 10:43:17.392213',NULL,'2025-12-04 10:43:17.417604',527,527,NULL,'cfbf6d94-ff7b-4852-88db-daecc18ba7cb',160,'e2d34491d1094a9480aa03d0d203a852','shares',1,'2025-12-05 10:43:17','4e0237cc-4b31-40b5-97b2-740edbe506d4'),('2025-12-04 10:43:17.393326',NULL,'2025-12-04 10:43:17.417604',528,528,NULL,'43c7f30c-aebf-4615-ae87-ea417f13d7b7',159,'e2d34491d1094a9480aa03d0d203a852','gigabytes',1,'2025-12-05 10:43:17','4e0237cc-4b31-40b5-97b2-740edbe506d4'),('2025-12-04 10:43:18.210604',NULL,'2025-12-04 10:43:18.246567',529,529,'02070bf38c73498d9b030a6203229eab','9da0c6b7-637b-4acb-9397-661e05832902',162,'e884ccda0adb4fcfa58e4992410a7be8','shares',1,'2025-12-05 10:43:18',NULL),('2025-12-04 10:43:18.211970',NULL,'2025-12-04 10:43:18.246567',530,530,'02070bf38c73498d9b030a6203229eab','5ad0c039-d70a-4a7b-bc46-036970fb3829',161,'e884ccda0adb4fcfa58e4992410a7be8','gigabytes',1,'2025-12-05 10:43:18',NULL),('2025-12-04 10:43:18.224983',NULL,'2025-12-04 10:43:18.246567',531,531,NULL,'6a14d109-12bc-4615-ae4d-ee7c89f669b3',164,'e884ccda0adb4fcfa58e4992410a7be8','shares',1,'2025-12-05 10:43:18','10e75b0e-4372-4109-8731-61024b16f85c'),('2025-12-04 10:43:18.226071',NULL,'2025-12-04 10:43:18.246567',532,532,NULL,'177b1aaa-6562-4aeb-9836-0dc79bafbacb',163,'e884ccda0adb4fcfa58e4992410a7be8','gigabytes',1,'2025-12-05 10:43:18','10e75b0e-4372-4109-8731-61024b16f85c'),('2025-12-04 10:43:19.830210',NULL,'2025-12-04 10:43:19.858375',533,533,'4c579d8ef46542619c86f7d6ba0c6283','6f3a56cc-1ec3-4f47-b0ec-e906b11233be',166,'b0e23771bd1a4c3ea8b52092c2e5d69e','shares',1,'2025-12-05 10:43:19',NULL),('2025-12-04 10:43:19.831572',NULL,'2025-12-04 10:43:19.858375',534,534,'4c579d8ef46542619c86f7d6ba0c6283','bab52059-19f1-48f2-87a5-df26b5476977',165,'b0e23771bd1a4c3ea8b52092c2e5d69e','gigabytes',1,'2025-12-05 10:43:19',NULL),('2025-12-04 10:43:19.839684',NULL,'2025-12-04 10:43:19.858375',535,535,NULL,'846bf085-7bd5-4a5f-b052-178c2791a929',168,'b0e23771bd1a4c3ea8b52092c2e5d69e','shares',1,'2025-12-05 10:43:19','820e79dd-be75-4d91-aca0-04a50b785894'),('2025-12-04 10:43:19.840696',NULL,'2025-12-04 10:43:19.858375',536,536,NULL,'975e2886-5290-48de-9d5b-1d959e48a1fa',167,'b0e23771bd1a4c3ea8b52092c2e5d69e','gigabytes',1,'2025-12-05 10:43:19','820e79dd-be75-4d91-aca0-04a50b785894'),('2025-12-04 10:43:21.220135',NULL,'2025-12-04 10:43:21.242089',537,537,'d3c52ac6184348f5b9994127e3eeb5e5','39730a39-6491-4970-b980-4b2d78785165',130,'e2d34491d1094a9480aa03d0d203a852','shares',-1,'2025-12-05 10:43:21',NULL),('2025-12-04 10:43:21.220960',NULL,'2025-12-04 10:43:21.242089',538,538,'d3c52ac6184348f5b9994127e3eeb5e5','7db49618-2cd9-48f8-8895-05d4b70af6cc',129,'e2d34491d1094a9480aa03d0d203a852','gigabytes',-1,'2025-12-05 10:43:21',NULL),('2025-12-04 10:43:21.232234',NULL,'2025-12-04 10:43:21.242089',539,539,NULL,'4af23788-87f4-4fa8-95e4-973f0fc3558e',160,'e2d34491d1094a9480aa03d0d203a852','shares',-1,'2025-12-05 10:43:21','4e0237cc-4b31-40b5-97b2-740edbe506d4'),('2025-12-04 10:43:21.234030',NULL,'2025-12-04 10:43:21.242089',540,540,NULL,'aac1cdbf-c60a-4231-b7c9-316237de8a5b',159,'e2d34491d1094a9480aa03d0d203a852','gigabytes',-1,'2025-12-05 10:43:21','4e0237cc-4b31-40b5-97b2-740edbe506d4'),('2025-12-04 10:43:21.470904',NULL,'2025-12-04 10:43:21.490477',541,541,'d3c52ac6184348f5b9994127e3eeb5e5','21cbc378-e764-4528-bc2b-32011ad59c96',130,'e2d34491d1094a9480aa03d0d203a852','shares',-1,'2025-12-05 10:43:21',NULL),('2025-12-04 10:43:21.471721',NULL,'2025-12-04 10:43:21.490477',542,542,'d3c52ac6184348f5b9994127e3eeb5e5','d2867497-9351-463e-8584-26013053cd30',129,'e2d34491d1094a9480aa03d0d203a852','gigabytes',-1,'2025-12-05 10:43:21',NULL),('2025-12-04 10:43:21.476582',NULL,'2025-12-04 10:43:21.490477',543,543,NULL,'77ece88f-f1d6-4a2d-b89a-9fea38f93dbf',157,'e2d34491d1094a9480aa03d0d203a852','shares',-1,'2025-12-05 10:43:21','515a821b-2c06-477c-82fe-373c817226c6'),('2025-12-04 10:43:21.477677',NULL,'2025-12-04 10:43:21.490477',544,544,NULL,'3acb7865-d6dc-409e-a866-e3672b5b1485',158,'e2d34491d1094a9480aa03d0d203a852','gigabytes',-1,'2025-12-05 10:43:21','515a821b-2c06-477c-82fe-373c817226c6'),('2025-12-04 10:43:21.609783',NULL,'2025-12-04 10:43:21.701951',545,545,'02070bf38c73498d9b030a6203229eab','020a039f-7c64-4c09-b83b-e70b4cd5109a',169,'e884ccda0adb4fcfa58e4992410a7be8','snapshots',1,'2025-12-05 10:43:21',NULL),('2025-12-04 10:43:21.613509',NULL,'2025-12-04 10:43:21.701951',546,546,'02070bf38c73498d9b030a6203229eab','e54ee2f7-2f76-4506-8702-d2412decb88c',170,'e884ccda0adb4fcfa58e4992410a7be8','snapshot_gigabytes',1,'2025-12-05 10:43:21',NULL),('2025-12-04 10:43:21.628156',NULL,'2025-12-04 10:43:21.701951',547,547,NULL,'b9c94be6-582e-45a4-be5a-958138529910',171,'e884ccda0adb4fcfa58e4992410a7be8','snapshots',1,'2025-12-05 10:43:21','10e75b0e-4372-4109-8731-61024b16f85c'),('2025-12-04 10:43:21.629390',NULL,'2025-12-04 10:43:21.701951',548,548,NULL,'df9abfe6-0681-4904-9a84-74df98a42839',172,'e884ccda0adb4fcfa58e4992410a7be8','snapshot_gigabytes',1,'2025-12-05 10:43:21','10e75b0e-4372-4109-8731-61024b16f85c'),('2025-12-04 10:43:21.651887',NULL,'2025-12-04 10:43:21.693365',549,549,'d3c52ac6184348f5b9994127e3eeb5e5','7093123d-80ff-45cb-aaf6-acd329d7e17b',130,'e2d34491d1094a9480aa03d0d203a852','shares',1,'2025-12-05 10:43:21',NULL),('2025-12-04 10:43:21.653381',NULL,'2025-12-04 10:43:21.693365',550,550,'d3c52ac6184348f5b9994127e3eeb5e5','39a48a0d-4453-483a-868f-a406646e38a9',129,'e2d34491d1094a9480aa03d0d203a852','gigabytes',1,'2025-12-05 10:43:21',NULL),('2025-12-04 10:43:21.662672',NULL,'2025-12-04 10:43:21.693365',551,551,NULL,'38114c02-bd3c-495d-8cc1-dd94b23c38c6',174,'e2d34491d1094a9480aa03d0d203a852','shares',1,'2025-12-05 10:43:21','a1ec9089-0fd2-48fb-bf6a-18efd8277aeb'),('2025-12-04 10:43:21.663641',NULL,'2025-12-04 10:43:21.693365',552,552,NULL,'cc569c79-b65c-4ef8-9a44-1134b58b9506',173,'e2d34491d1094a9480aa03d0d203a852','gigabytes',1,'2025-12-05 10:43:21','a1ec9089-0fd2-48fb-bf6a-18efd8277aeb'),('2025-12-04 10:43:23.236769',NULL,'2025-12-04 10:43:23.251955',553,553,'8b4c6480f293453d850328438bc66819','bec958b4-2de0-47ac-9dd3-b95a4dc76f11',123,'094a9e5adfae45769d099eaf0d4f598c','shares',-1,'2025-12-05 10:43:23',NULL),('2025-12-04 10:43:23.237521',NULL,'2025-12-04 10:43:23.251955',554,554,'8b4c6480f293453d850328438bc66819','676ca26d-b2e7-4c9e-bfaf-e7dbae6fa5c8',124,'094a9e5adfae45769d099eaf0d4f598c','gigabytes',-1,'2025-12-05 10:43:23',NULL),('2025-12-04 10:43:23.244201',NULL,'2025-12-04 10:43:23.251955',555,555,NULL,'a6da9b69-3120-4da5-b0ac-4bfee4a9bcfe',125,'094a9e5adfae45769d099eaf0d4f598c','shares',-1,'2025-12-05 10:43:23','df88ce48-d3e8-48b4-aca4-3e96df85fd1c'),('2025-12-04 10:43:23.244998',NULL,'2025-12-04 10:43:23.251955',556,556,NULL,'3b7a8eb4-c241-4235-84a1-66706d306b59',126,'094a9e5adfae45769d099eaf0d4f598c','gigabytes',-1,'2025-12-05 10:43:23','df88ce48-d3e8-48b4-aca4-3e96df85fd1c'),('2025-12-04 10:43:23.273016',NULL,'2025-12-04 10:43:23.298724',557,557,'4c579d8ef46542619c86f7d6ba0c6283','59dcc863-5558-4914-ac8e-781406706ef6',166,'b0e23771bd1a4c3ea8b52092c2e5d69e','shares',1,'2025-12-05 10:43:23',NULL),('2025-12-04 10:43:23.274259',NULL,'2025-12-04 10:43:23.298724',558,558,'4c579d8ef46542619c86f7d6ba0c6283','f712c1b5-dd6e-4b1c-8ab1-dd2bf7b8094d',165,'b0e23771bd1a4c3ea8b52092c2e5d69e','gigabytes',1,'2025-12-05 10:43:23',NULL),('2025-12-04 10:43:23.279035',NULL,'2025-12-04 10:43:23.298724',559,559,NULL,'92069df0-c9e2-48ab-a2b6-57c74c43da46',168,'b0e23771bd1a4c3ea8b52092c2e5d69e','shares',1,'2025-12-05 10:43:23','820e79dd-be75-4d91-aca0-04a50b785894'),('2025-12-04 10:43:23.280024',NULL,'2025-12-04 10:43:23.298724',560,560,NULL,'6a01a31f-3e4a-46ae-9894-633a7f753387',167,'b0e23771bd1a4c3ea8b52092c2e5d69e','gigabytes',1,'2025-12-05 10:43:23','820e79dd-be75-4d91-aca0-04a50b785894'),('2025-12-04 10:43:25.290500',NULL,'2025-12-04 10:43:25.303520',561,561,'d3c52ac6184348f5b9994127e3eeb5e5','465b1093-6ad7-41bf-a01a-1e051af1033b',130,'e2d34491d1094a9480aa03d0d203a852','shares',-1,'2025-12-05 10:43:25',NULL),('2025-12-04 10:43:25.291181',NULL,'2025-12-04 10:43:25.303520',562,562,'d3c52ac6184348f5b9994127e3eeb5e5','704be36a-f28f-4006-b2a0-7573cb17186e',129,'e2d34491d1094a9480aa03d0d203a852','gigabytes',-1,'2025-12-05 10:43:25',NULL),('2025-12-04 10:43:25.295804',NULL,'2025-12-04 10:43:25.303520',563,563,NULL,'b246ec9a-484d-4d4f-9a7d-2dbfb321ade1',174,'e2d34491d1094a9480aa03d0d203a852','shares',-1,'2025-12-05 10:43:25','a1ec9089-0fd2-48fb-bf6a-18efd8277aeb'),('2025-12-04 10:43:25.296453',NULL,'2025-12-04 10:43:25.303520',564,564,NULL,'b5dff7b0-1881-4c0f-a355-4ad4653947cc',173,'e2d34491d1094a9480aa03d0d203a852','gigabytes',-1,'2025-12-05 10:43:25','a1ec9089-0fd2-48fb-bf6a-18efd8277aeb'),('2025-12-04 10:43:26.793312',NULL,'2025-12-04 10:43:26.811874',565,565,'02070bf38c73498d9b030a6203229eab','589598a4-6adb-450f-9a2e-aef7abcc38ed',169,'e884ccda0adb4fcfa58e4992410a7be8','snapshots',-1,'2025-12-05 10:43:26',NULL),('2025-12-04 10:43:26.794158',NULL,'2025-12-04 10:43:26.811874',566,566,'02070bf38c73498d9b030a6203229eab','c9518eed-09bb-4c21-841f-3643cfde2af4',170,'e884ccda0adb4fcfa58e4992410a7be8','snapshot_gigabytes',-1,'2025-12-05 10:43:26',NULL),('2025-12-04 10:43:26.800371',NULL,'2025-12-04 10:43:26.811874',567,567,NULL,'863951d4-5ac6-4252-959a-a75d202aac58',171,'e884ccda0adb4fcfa58e4992410a7be8','snapshots',-1,'2025-12-05 10:43:26','10e75b0e-4372-4109-8731-61024b16f85c'),('2025-12-04 10:43:26.801052',NULL,'2025-12-04 10:43:26.811874',568,568,NULL,'372a15f5-0779-4707-91e1-cb4943450e58',172,'e884ccda0adb4fcfa58e4992410a7be8','snapshot_gigabytes',-1,'2025-12-05 10:43:26','10e75b0e-4372-4109-8731-61024b16f85c'),('2025-12-04 10:43:27.053267',NULL,'2025-12-04 10:43:27.068091',569,569,'4c579d8ef46542619c86f7d6ba0c6283','1e59c978-ec79-4424-9152-50b9a0526e97',166,'b0e23771bd1a4c3ea8b52092c2e5d69e','shares',-1,'2025-12-05 10:43:27',NULL),('2025-12-04 10:43:27.054062',NULL,'2025-12-04 10:43:27.068091',570,570,'4c579d8ef46542619c86f7d6ba0c6283','7a1dab69-0817-4311-8a9a-6fb8741cd079',165,'b0e23771bd1a4c3ea8b52092c2e5d69e','gigabytes',-1,'2025-12-05 10:43:27',NULL),('2025-12-04 10:43:27.058760',NULL,'2025-12-04 10:43:27.068091',571,571,NULL,'aca5d1f2-4478-4df1-9afe-1b658c1297d5',168,'b0e23771bd1a4c3ea8b52092c2e5d69e','shares',-1,'2025-12-05 10:43:27','820e79dd-be75-4d91-aca0-04a50b785894'),('2025-12-04 10:43:27.059622',NULL,'2025-12-04 10:43:27.068091',572,572,NULL,'fbdedc9b-0ab2-49fa-9212-02ca51b581fd',167,'b0e23771bd1a4c3ea8b52092c2e5d69e','gigabytes',-1,'2025-12-05 10:43:27','820e79dd-be75-4d91-aca0-04a50b785894'),('2025-12-04 10:43:30.252515',NULL,'2025-12-04 10:43:30.282493',573,573,'02070bf38c73498d9b030a6203229eab','9a3fddd3-ea2f-4ab1-98c8-95f7e4d97f0e',162,'e884ccda0adb4fcfa58e4992410a7be8','shares',-1,'2025-12-05 10:43:30',NULL),('2025-12-04 10:43:30.255236',NULL,'2025-12-04 10:43:30.282493',574,574,'02070bf38c73498d9b030a6203229eab','3d61caad-0742-4d74-834d-6623e9dbe1fa',161,'e884ccda0adb4fcfa58e4992410a7be8','gigabytes',-1,'2025-12-05 10:43:30',NULL),('2025-12-04 10:43:30.266669',NULL,'2025-12-04 10:43:30.282493',575,575,NULL,'52e18718-dafe-4b57-b009-93bd85df9d0c',164,'e884ccda0adb4fcfa58e4992410a7be8','shares',-1,'2025-12-05 10:43:30','10e75b0e-4372-4109-8731-61024b16f85c'),('2025-12-04 10:43:30.267617',NULL,'2025-12-04 10:43:30.282493',576,576,NULL,'8216d31b-361b-4c12-941a-b881f4f8b01f',163,'e884ccda0adb4fcfa58e4992410a7be8','gigabytes',-1,'2025-12-05 10:43:30','10e75b0e-4372-4109-8731-61024b16f85c'),('2025-12-04 10:43:30.690304',NULL,'2025-12-04 10:43:30.705611',577,577,'4c579d8ef46542619c86f7d6ba0c6283','dba527f3-f775-4d1b-8fe3-61abef34c6ec',166,'b0e23771bd1a4c3ea8b52092c2e5d69e','shares',-1,'2025-12-05 10:43:30',NULL),('2025-12-04 10:43:30.691092',NULL,'2025-12-04 10:43:30.705611',578,578,'4c579d8ef46542619c86f7d6ba0c6283','ed12160d-e144-48f6-a533-a74a46ade3c0',165,'b0e23771bd1a4c3ea8b52092c2e5d69e','gigabytes',-1,'2025-12-05 10:43:30',NULL),('2025-12-04 10:43:30.697345',NULL,'2025-12-04 10:43:30.705611',579,579,NULL,'3321d31e-15e0-4c08-bb59-cb296e942445',168,'b0e23771bd1a4c3ea8b52092c2e5d69e','shares',-1,'2025-12-05 10:43:30','820e79dd-be75-4d91-aca0-04a50b785894'),('2025-12-04 10:43:30.698166',NULL,'2025-12-04 10:43:30.705611',580,580,NULL,'1c69935e-fd0c-4918-b161-d3984d0a6b32',167,'b0e23771bd1a4c3ea8b52092c2e5d69e','gigabytes',-1,'2025-12-05 10:43:30','820e79dd-be75-4d91-aca0-04a50b785894'),('2025-12-04 10:43:33.830013',NULL,'2025-12-04 10:43:33.867175',581,581,'96fe23c86bd041028a1ccffe636b7da9','fa0cc1f1-ecbd-4097-96be-47f164c6ea6c',175,'7e0c9a3966b443c7bbb289ba33849550','shares',1,'2025-12-05 10:43:33',NULL),('2025-12-04 10:43:33.831228',NULL,'2025-12-04 10:43:33.867175',582,582,'96fe23c86bd041028a1ccffe636b7da9','7972891c-88dd-4a25-bed1-a80528df2cad',176,'7e0c9a3966b443c7bbb289ba33849550','gigabytes',1,'2025-12-05 10:43:33',NULL),('2025-12-04 10:43:33.841530',NULL,'2025-12-04 10:43:33.867175',583,583,NULL,'c3787b19-0d28-4672-9ea1-c8f12fa662b9',177,'7e0c9a3966b443c7bbb289ba33849550','shares',1,'2025-12-05 10:43:33','670a24d3-016f-4e59-b59c-2a560b5418dd'),('2025-12-04 10:43:33.842782',NULL,'2025-12-04 10:43:33.867175',584,584,NULL,'79f0cc39-6948-435a-bd2a-94af49fcaf0b',178,'7e0c9a3966b443c7bbb289ba33849550','gigabytes',1,'2025-12-05 10:43:33','670a24d3-016f-4e59-b59c-2a560b5418dd'),('2025-12-04 10:43:34.128524',NULL,'2025-12-04 10:43:34.171067',585,585,'4c579d8ef46542619c86f7d6ba0c6283','2f108ae1-b4df-4f43-852a-8c60e3b13b3d',179,'b0e23771bd1a4c3ea8b52092c2e5d69e','share_groups',1,'2025-12-05 10:43:34',NULL),('2025-12-04 10:43:34.744704',NULL,'2025-12-04 10:43:34.760529',586,586,'4c579d8ef46542619c86f7d6ba0c6283','aa7a9202-9235-41af-95b4-c09a54ed1d5f',179,'b0e23771bd1a4c3ea8b52092c2e5d69e','share_groups',-1,'2025-12-05 10:43:34',NULL),('2025-12-04 10:43:35.308200',NULL,'2025-12-04 10:43:35.328436',587,587,'4c579d8ef46542619c86f7d6ba0c6283','9ea6613d-c335-4d2c-a80b-33a8b4d2c6dd',179,'b0e23771bd1a4c3ea8b52092c2e5d69e','share_groups',1,'2025-12-05 10:43:35',NULL),('2025-12-04 10:43:36.196384',NULL,'2025-12-04 10:43:36.237539',588,588,'48ef94f1dc4447f08252015effc744b0','8899343a-a370-44b6-8460-b53680e86790',180,'d831ca1755a740e7819c02d320ecd2a0','shares',1,'2025-12-05 10:43:36',NULL),('2025-12-04 10:43:36.197796',NULL,'2025-12-04 10:43:36.237539',589,589,'48ef94f1dc4447f08252015effc744b0','83276b18-373f-4cfb-ab04-6a3f66a2829e',181,'d831ca1755a740e7819c02d320ecd2a0','gigabytes',1,'2025-12-05 10:43:36',NULL),('2025-12-04 10:43:36.209042',NULL,'2025-12-04 10:43:36.237539',590,590,NULL,'3f59fbe9-69f2-4d5b-bcfb-b0981eeabaeb',182,'d831ca1755a740e7819c02d320ecd2a0','shares',1,'2025-12-05 10:43:36','4c300d44-f839-46b6-b125-41134ef8ee22'),('2025-12-04 10:43:36.210331',NULL,'2025-12-04 10:43:36.237539',591,591,NULL,'e36265f9-a4ad-40fd-a035-335c28fa36d2',183,'d831ca1755a740e7819c02d320ecd2a0','gigabytes',1,'2025-12-05 10:43:36','4c300d44-f839-46b6-b125-41134ef8ee22'),('2025-12-04 10:43:38.829544',NULL,'2025-12-04 10:43:38.842274',592,592,'4c579d8ef46542619c86f7d6ba0c6283','14edf547-fccf-4aef-99b4-aa1104664504',179,'b0e23771bd1a4c3ea8b52092c2e5d69e','share_groups',-1,'2025-12-05 10:43:38',NULL),('2025-12-04 10:43:39.114988',NULL,'2025-12-04 10:43:39.152482',593,593,'4c579d8ef46542619c86f7d6ba0c6283','cf99329b-96fd-408d-9a73-469ff426b303',166,'b0e23771bd1a4c3ea8b52092c2e5d69e','shares',1,'2025-12-05 10:43:39',NULL),('2025-12-04 10:43:39.119109',NULL,'2025-12-04 10:43:39.152482',594,594,'4c579d8ef46542619c86f7d6ba0c6283','b762e407-22db-444b-aadc-12f9d7bb0c3c',165,'b0e23771bd1a4c3ea8b52092c2e5d69e','gigabytes',1,'2025-12-05 10:43:39',NULL),('2025-12-04 10:43:39.133621',NULL,'2025-12-04 10:43:39.152482',595,595,NULL,'9e2bda97-25dd-4057-b57f-e61ec4121bd6',168,'b0e23771bd1a4c3ea8b52092c2e5d69e','shares',1,'2025-12-05 10:43:39','820e79dd-be75-4d91-aca0-04a50b785894'),('2025-12-04 10:43:39.134723',NULL,'2025-12-04 10:43:39.152482',596,596,NULL,'efb0d4ab-3b7e-48c8-825c-4a1de37315d1',167,'b0e23771bd1a4c3ea8b52092c2e5d69e','gigabytes',1,'2025-12-05 10:43:39','820e79dd-be75-4d91-aca0-04a50b785894'),('2025-12-04 10:43:39.942036',NULL,'2025-12-04 10:43:39.990878',597,597,'48ef94f1dc4447f08252015effc744b0','4bbb7cc0-7935-47f0-a144-140c6ac67646',180,'d831ca1755a740e7819c02d320ecd2a0','shares',1,'2025-12-05 10:43:39',NULL),('2025-12-04 10:43:39.945657',NULL,'2025-12-04 10:43:39.990878',598,598,'48ef94f1dc4447f08252015effc744b0','5852e5eb-1e4b-4491-9568-1ca8d451265d',181,'d831ca1755a740e7819c02d320ecd2a0','gigabytes',1,'2025-12-05 10:43:39',NULL),('2025-12-04 10:43:39.963108',NULL,'2025-12-04 10:43:39.990878',599,599,NULL,'96486690-5141-4a13-83cc-cff004323d53',185,'d831ca1755a740e7819c02d320ecd2a0','shares',1,'2025-12-05 10:43:39','a2f71277-9b7c-41be-ac23-94904d0c6314'),('2025-12-04 10:43:39.964737',NULL,'2025-12-04 10:43:39.990878',600,600,NULL,'1bc0d891-9b3b-4ab9-a538-06f21763f8e9',184,'d831ca1755a740e7819c02d320ecd2a0','gigabytes',1,'2025-12-05 10:43:39','a2f71277-9b7c-41be-ac23-94904d0c6314'),('2025-12-04 10:43:43.000761',NULL,'2025-12-04 10:43:43.017858',601,601,'4c579d8ef46542619c86f7d6ba0c6283','cf31e446-3c98-4577-9c7f-ce28a3df819e',166,'b0e23771bd1a4c3ea8b52092c2e5d69e','shares',-1,'2025-12-05 10:43:42',NULL),('2025-12-04 10:43:43.001632',NULL,'2025-12-04 10:43:43.017858',602,602,'4c579d8ef46542619c86f7d6ba0c6283','ecbfc373-b376-45ec-a485-629c1041534f',165,'b0e23771bd1a4c3ea8b52092c2e5d69e','gigabytes',-1,'2025-12-05 10:43:42',NULL),('2025-12-04 10:43:43.009686',NULL,'2025-12-04 10:43:43.017858',603,603,NULL,'082a1183-dbfc-42d2-8a2a-f726ae25e466',168,'b0e23771bd1a4c3ea8b52092c2e5d69e','shares',-1,'2025-12-05 10:43:42','820e79dd-be75-4d91-aca0-04a50b785894'),('2025-12-04 10:43:43.010564',NULL,'2025-12-04 10:43:43.017858',604,604,NULL,'ac354af8-05f2-4608-be28-3808139aebf1',167,'b0e23771bd1a4c3ea8b52092c2e5d69e','gigabytes',-1,'2025-12-05 10:43:42','820e79dd-be75-4d91-aca0-04a50b785894'),('2025-12-04 10:43:44.100171',NULL,'2025-12-04 10:43:44.135179',605,605,'ac347d74fad64b0bbb495d6240c31d44','40c7c096-d296-4bb0-b01d-333059f6a7fe',187,'c2e0964e5703431eab30fd7c235961ae','shares',1,'2025-12-05 10:43:44',NULL),('2025-12-04 10:43:44.101314',NULL,'2025-12-04 10:43:44.135179',606,606,'ac347d74fad64b0bbb495d6240c31d44','1cde6787-9eef-40d7-80d2-b8cb9343f36b',186,'c2e0964e5703431eab30fd7c235961ae','gigabytes',1,'2025-12-05 10:43:44',NULL),('2025-12-04 10:43:44.111508',NULL,'2025-12-04 10:43:44.135179',607,607,NULL,'952d069a-6e6d-4c4b-94ed-e07eb628fb47',189,'c2e0964e5703431eab30fd7c235961ae','shares',1,'2025-12-05 10:43:44','a2f71277-9b7c-41be-ac23-94904d0c6314'),('2025-12-04 10:43:44.112851',NULL,'2025-12-04 10:43:44.135179',608,608,NULL,'3ed9eb76-05f1-4a35-9d70-c372ae27710f',188,'c2e0964e5703431eab30fd7c235961ae','gigabytes',1,'2025-12-05 10:43:44','a2f71277-9b7c-41be-ac23-94904d0c6314'),('2025-12-04 10:43:46.267116',NULL,'2025-12-04 10:43:46.295299',609,609,'4c579d8ef46542619c86f7d6ba0c6283','002209b3-ede3-4ed4-b1eb-68669358bfd0',166,'b0e23771bd1a4c3ea8b52092c2e5d69e','shares',1,'2025-12-05 10:43:46',NULL),('2025-12-04 10:43:46.268672',NULL,'2025-12-04 10:43:46.295299',610,610,'4c579d8ef46542619c86f7d6ba0c6283','5215fce3-234e-4d9c-8210-66b5f702e8aa',165,'b0e23771bd1a4c3ea8b52092c2e5d69e','gigabytes',1,'2025-12-05 10:43:46',NULL),('2025-12-04 10:43:46.274500',NULL,'2025-12-04 10:43:46.295299',611,611,NULL,'bb17dcac-9890-47a7-bbb7-cd2629495759',168,'b0e23771bd1a4c3ea8b52092c2e5d69e','shares',1,'2025-12-05 10:43:46','820e79dd-be75-4d91-aca0-04a50b785894'),('2025-12-04 10:43:46.275560',NULL,'2025-12-04 10:43:46.295299',612,612,NULL,'3082d1dd-a579-497c-9f41-26d251ca7bb5',167,'b0e23771bd1a4c3ea8b52092c2e5d69e','gigabytes',1,'2025-12-05 10:43:46','820e79dd-be75-4d91-aca0-04a50b785894'),('2025-12-04 10:43:50.329412',NULL,'2025-12-04 10:43:50.344004',613,613,'4c579d8ef46542619c86f7d6ba0c6283','d50515d1-b8c4-4366-9acf-c7770403b9d1',166,'b0e23771bd1a4c3ea8b52092c2e5d69e','shares',-1,'2025-12-05 10:43:50',NULL),('2025-12-04 10:43:50.330114',NULL,'2025-12-04 10:43:50.344004',614,614,'4c579d8ef46542619c86f7d6ba0c6283','c9a989c9-a8fb-4cec-b0b4-dac598027da3',165,'b0e23771bd1a4c3ea8b52092c2e5d69e','gigabytes',-1,'2025-12-05 10:43:50',NULL),('2025-12-04 10:43:50.335907',NULL,'2025-12-04 10:43:50.344004',615,615,NULL,'ae341d81-41aa-4817-bdcb-b2fa3bf8c124',168,'b0e23771bd1a4c3ea8b52092c2e5d69e','shares',-1,'2025-12-05 10:43:50','820e79dd-be75-4d91-aca0-04a50b785894'),('2025-12-04 10:43:50.336807',NULL,'2025-12-04 10:43:50.344004',616,616,NULL,'94f27b4a-57c9-44fe-8ae9-e3ec9474b640',167,'b0e23771bd1a4c3ea8b52092c2e5d69e','gigabytes',-1,'2025-12-05 10:43:50','820e79dd-be75-4d91-aca0-04a50b785894'),('2025-12-04 10:43:52.653632',NULL,'2025-12-04 10:43:52.691267',617,617,'0ef0510443b848f1bfcd4a773578d114','6e20357e-bec8-4ab8-be56-fac03c57f86c',190,'18048b8b581e48239e3a92c77164734b','shares',1,'2025-12-05 10:43:52',NULL),('2025-12-04 10:43:52.654797',NULL,'2025-12-04 10:43:52.691267',618,618,'0ef0510443b848f1bfcd4a773578d114','f3e18cdc-2926-41c4-8320-98543c1ef5ad',191,'18048b8b581e48239e3a92c77164734b','gigabytes',1,'2025-12-05 10:43:52',NULL),('2025-12-04 10:43:52.668036',NULL,'2025-12-04 10:43:52.691267',619,619,NULL,'e281e475-047a-4951-ba16-5646b0f140d6',192,'18048b8b581e48239e3a92c77164734b','shares',1,'2025-12-05 10:43:52','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:43:52.669612',NULL,'2025-12-04 10:43:52.691267',620,620,NULL,'6ba33f92-7b8b-4fd9-9f01-1ad5d173def1',193,'18048b8b581e48239e3a92c77164734b','gigabytes',1,'2025-12-05 10:43:52','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:43:54.774193',NULL,'2025-12-04 10:43:54.789716',621,621,'96fe23c86bd041028a1ccffe636b7da9','4c1d6f17-e499-491c-bcb4-07c00da398a5',175,'7e0c9a3966b443c7bbb289ba33849550','shares',-1,'2025-12-05 10:43:54',NULL),('2025-12-04 10:43:54.775064',NULL,'2025-12-04 10:43:54.789716',622,622,'96fe23c86bd041028a1ccffe636b7da9','cf8709d8-726d-440e-841a-1e82fc23ff30',176,'7e0c9a3966b443c7bbb289ba33849550','gigabytes',-1,'2025-12-05 10:43:54',NULL),('2025-12-04 10:43:54.782192',NULL,'2025-12-04 10:43:54.789716',623,623,NULL,'5a2e2312-a95d-4362-9b2c-f87ca7fd1160',177,'7e0c9a3966b443c7bbb289ba33849550','shares',-1,'2025-12-05 10:43:54','670a24d3-016f-4e59-b59c-2a560b5418dd'),('2025-12-04 10:43:54.782893',NULL,'2025-12-04 10:43:54.789716',624,624,NULL,'9872503a-adf9-49c4-8349-02ce6b8429dc',178,'7e0c9a3966b443c7bbb289ba33849550','gigabytes',-1,'2025-12-05 10:43:54','670a24d3-016f-4e59-b59c-2a560b5418dd'),('2025-12-04 10:43:56.331485',NULL,'2025-12-04 10:43:56.423699',625,625,'0ef0510443b848f1bfcd4a773578d114','65db3ed7-dd89-4310-b93e-4eb74781c309',195,'18048b8b581e48239e3a92c77164734b','snapshots',1,'2025-12-05 10:43:56',NULL),('2025-12-04 10:43:56.332966',NULL,'2025-12-04 10:43:56.423699',626,626,'0ef0510443b848f1bfcd4a773578d114','8c1ac83b-aab9-48c5-a64b-bb8fcc952e81',194,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',1,'2025-12-05 10:43:56',NULL),('2025-12-04 10:43:56.350865',NULL,'2025-12-04 10:43:56.423699',627,627,NULL,'5b4c205c-c71d-48f4-a989-981944a35d2e',197,'18048b8b581e48239e3a92c77164734b','snapshots',1,'2025-12-05 10:43:56','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:43:56.353008',NULL,'2025-12-04 10:43:56.423699',628,628,NULL,'873bfe53-f342-4934-969a-0736949288e1',196,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',1,'2025-12-05 10:43:56','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:00.051176',NULL,'2025-12-04 10:44:00.138705',629,629,'0ef0510443b848f1bfcd4a773578d114','3b45908f-40d0-45a5-945e-0e9d4b4f68c8',195,'18048b8b581e48239e3a92c77164734b','snapshots',1,'2025-12-05 10:44:00',NULL),('2025-12-04 10:44:00.052572',NULL,'2025-12-04 10:44:00.138705',630,630,'0ef0510443b848f1bfcd4a773578d114','f4223835-e0a0-4d3e-a98f-e253d5b568f2',194,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',1,'2025-12-05 10:44:00',NULL),('2025-12-04 10:44:00.062580',NULL,'2025-12-04 10:44:00.138705',631,631,NULL,'b22f1565-8e61-4141-917d-e7cad48b71d0',197,'18048b8b581e48239e3a92c77164734b','snapshots',1,'2025-12-05 10:44:00','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:00.064093',NULL,'2025-12-04 10:44:00.138705',632,632,NULL,'25858b21-7280-45de-94a1-29212585f92d',196,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',1,'2025-12-05 10:44:00','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:01.993058',NULL,'2025-12-04 10:44:02.042602',633,633,'0ef0510443b848f1bfcd4a773578d114','ad620f66-09aa-458d-9995-3607079992dd',195,'18048b8b581e48239e3a92c77164734b','snapshots',-1,'2025-12-05 10:44:01',NULL),('2025-12-04 10:44:01.994935',NULL,'2025-12-04 10:44:02.042602',634,634,'0ef0510443b848f1bfcd4a773578d114','f575f3de-d0de-40ff-a990-9274cb12b251',194,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',-1,'2025-12-05 10:44:01',NULL),('2025-12-04 10:44:02.006204',NULL,'2025-12-04 10:44:02.042602',635,635,NULL,'1b9d187e-80fd-4cfc-bb0b-a2ecf61ab533',197,'18048b8b581e48239e3a92c77164734b','snapshots',-1,'2025-12-05 10:44:01','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:02.010270',NULL,'2025-12-04 10:44:02.042602',636,636,NULL,'75ab4a2e-1d2f-40bc-8946-6ceca484d9bf',196,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',-1,'2025-12-05 10:44:01','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:05.196308',NULL,'2025-12-04 10:44:05.271059',637,637,'0ef0510443b848f1bfcd4a773578d114','b4302031-689d-4286-9815-1c704c656269',195,'18048b8b581e48239e3a92c77164734b','snapshots',1,'2025-12-05 10:44:05',NULL),('2025-12-04 10:44:05.198602',NULL,'2025-12-04 10:44:05.271059',638,638,'0ef0510443b848f1bfcd4a773578d114','61d1430c-cda0-4140-8d20-86660fcb6957',194,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',1,'2025-12-05 10:44:05',NULL),('2025-12-04 10:44:05.207033',NULL,'2025-12-04 10:44:05.271059',639,639,NULL,'ab389de7-e936-4929-a869-4fd0770c736b',197,'18048b8b581e48239e3a92c77164734b','snapshots',1,'2025-12-05 10:44:05','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:05.208497',NULL,'2025-12-04 10:44:05.271059',640,640,NULL,'80b5e792-46eb-4a39-9213-f78b4690e142',196,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',1,'2025-12-05 10:44:05','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:05.548786',NULL,'2025-12-04 10:44:05.582717',641,641,'cc8309c8aa2b47da966accf9ec753a0e','309b61a6-e7b0-40c8-b76d-4a664685d79a',198,'3ba683091e694bf1800f8fdcd57277cf','shares',1,'2025-12-05 10:44:05',NULL),('2025-12-04 10:44:05.549751',NULL,'2025-12-04 10:44:05.582717',642,642,'cc8309c8aa2b47da966accf9ec753a0e','21cee0b4-2c9c-48ee-8e18-3748033cdc54',199,'3ba683091e694bf1800f8fdcd57277cf','gigabytes',1,'2025-12-05 10:44:05',NULL),('2025-12-04 10:44:05.558621',NULL,'2025-12-04 10:44:05.582717',643,643,NULL,'16c5583c-7374-4bc4-8d6b-d9479ab1386d',200,'3ba683091e694bf1800f8fdcd57277cf','shares',1,'2025-12-05 10:44:05','d2cb06dc-eba6-4fed-a094-61bf857c0e07'),('2025-12-04 10:44:05.559601',NULL,'2025-12-04 10:44:05.582717',644,644,NULL,'b7ece233-1850-4af9-8b3b-bfd3f8ee1f70',201,'3ba683091e694bf1800f8fdcd57277cf','gigabytes',1,'2025-12-05 10:44:05','d2cb06dc-eba6-4fed-a094-61bf857c0e07'),('2025-12-04 10:44:10.409937',NULL,'2025-12-04 10:44:10.441686',645,645,'0ef0510443b848f1bfcd4a773578d114','e49742c5-7cb9-41e6-bb9f-1eb661c9e834',195,'18048b8b581e48239e3a92c77164734b','snapshots',-1,'2025-12-05 10:44:10',NULL),('2025-12-04 10:44:10.411372',NULL,'2025-12-04 10:44:10.441686',646,646,'0ef0510443b848f1bfcd4a773578d114','ec9d51ff-b1cd-46af-ac7f-7d159bdaa85b',194,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',-1,'2025-12-05 10:44:10',NULL),('2025-12-04 10:44:10.428500',NULL,'2025-12-04 10:44:10.441686',647,647,NULL,'65445fa0-d0dc-45d6-81d4-68514ca5755f',197,'18048b8b581e48239e3a92c77164734b','snapshots',-1,'2025-12-05 10:44:10','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:10.429375',NULL,'2025-12-04 10:44:10.441686',648,648,NULL,'981d5f70-0246-4994-8e33-be1b046c7b92',196,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',-1,'2025-12-05 10:44:10','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:10.911682',NULL,'2025-12-04 10:44:10.927625',649,649,'cc8309c8aa2b47da966accf9ec753a0e','4de72bcb-a370-4706-b90d-e348b508e041',198,'3ba683091e694bf1800f8fdcd57277cf','shares',-1,'2025-12-05 10:44:10',NULL),('2025-12-04 10:44:10.912830',NULL,'2025-12-04 10:44:10.927625',650,650,'cc8309c8aa2b47da966accf9ec753a0e','544704e0-70d9-49bf-bacc-8f96849c7215',199,'3ba683091e694bf1800f8fdcd57277cf','gigabytes',-1,'2025-12-05 10:44:10',NULL),('2025-12-04 10:44:10.920209',NULL,'2025-12-04 10:44:10.927625',651,651,NULL,'9ecf1360-a39f-4c7d-8cc1-133abadcd522',200,'3ba683091e694bf1800f8fdcd57277cf','shares',-1,'2025-12-05 10:44:10','d2cb06dc-eba6-4fed-a094-61bf857c0e07'),('2025-12-04 10:44:10.921005',NULL,'2025-12-04 10:44:10.927625',652,652,NULL,'8a214be0-8552-45d9-bf1f-0958fcf2aa5e',201,'3ba683091e694bf1800f8fdcd57277cf','gigabytes',-1,'2025-12-05 10:44:10','d2cb06dc-eba6-4fed-a094-61bf857c0e07'),('2025-12-04 10:44:13.411290',NULL,'2025-12-04 10:44:13.506417',653,653,'0ef0510443b848f1bfcd4a773578d114','7bfd77a4-8325-4e10-afcb-2d6bd7ac6432',195,'18048b8b581e48239e3a92c77164734b','snapshots',1,'2025-12-05 10:44:13',NULL),('2025-12-04 10:44:13.412482',NULL,'2025-12-04 10:44:13.506417',654,654,'0ef0510443b848f1bfcd4a773578d114','b0426631-d426-4369-926a-f58609c03f39',194,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',1,'2025-12-05 10:44:13',NULL),('2025-12-04 10:44:13.419350',NULL,'2025-12-04 10:44:13.506417',655,655,NULL,'7535dd95-7509-472c-b3dd-b2f642319977',197,'18048b8b581e48239e3a92c77164734b','snapshots',1,'2025-12-05 10:44:13','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:13.420722',NULL,'2025-12-04 10:44:13.506417',656,656,NULL,'5aa47fc0-9ba9-4b68-b27b-e8ee43032123',196,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',1,'2025-12-05 10:44:13','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:13.470402',NULL,'2025-12-04 10:44:13.523410',657,657,'ac347d74fad64b0bbb495d6240c31d44','25020b25-06d6-4c55-8502-92a863a1598a',187,'c2e0964e5703431eab30fd7c235961ae','shares',1,'2025-12-05 10:44:13',NULL),('2025-12-04 10:44:13.472169',NULL,'2025-12-04 10:44:13.523410',658,658,'ac347d74fad64b0bbb495d6240c31d44','1aa34236-b48d-4516-b02e-ffde4f1dacbd',186,'c2e0964e5703431eab30fd7c235961ae','gigabytes',1,'2025-12-05 10:44:13',NULL),('2025-12-04 10:44:13.488858',NULL,'2025-12-04 10:44:13.523410',659,659,NULL,'9e31b66d-304c-4514-a0b7-060a53d0b95b',203,'c2e0964e5703431eab30fd7c235961ae','shares',1,'2025-12-05 10:44:13','4c300d44-f839-46b6-b125-41134ef8ee22'),('2025-12-04 10:44:13.490899',NULL,'2025-12-04 10:44:13.523410',660,660,NULL,'1d634f7e-ed65-4be6-bd21-a314d5c08cc6',202,'c2e0964e5703431eab30fd7c235961ae','gigabytes',1,'2025-12-05 10:44:13','4c300d44-f839-46b6-b125-41134ef8ee22'),('2025-12-04 10:44:17.651281',NULL,'2025-12-04 10:44:17.666956',661,661,'0ef0510443b848f1bfcd4a773578d114','20c2ede1-964f-41bb-b323-97db6806e286',195,'18048b8b581e48239e3a92c77164734b','snapshots',-1,'2025-12-05 10:44:17',NULL),('2025-12-04 10:44:17.652255',NULL,'2025-12-04 10:44:17.666956',662,662,'0ef0510443b848f1bfcd4a773578d114','6bd07519-eebb-423b-8697-cafcc72f6066',194,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',-1,'2025-12-05 10:44:17',NULL),('2025-12-04 10:44:17.658092',NULL,'2025-12-04 10:44:17.666956',663,663,NULL,'c2cdf412-5092-4759-a777-6bbd02c7bd41',197,'18048b8b581e48239e3a92c77164734b','snapshots',-1,'2025-12-05 10:44:17','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:17.658747',NULL,'2025-12-04 10:44:17.666956',664,664,NULL,'e68307b0-875b-414a-8bbb-0baaa3743b77',196,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',-1,'2025-12-05 10:44:17','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:20.924123',NULL,'2025-12-04 10:44:21.016393',665,665,'0ef0510443b848f1bfcd4a773578d114','915924fb-4323-4eb1-aa8c-f4d62104646d',195,'18048b8b581e48239e3a92c77164734b','snapshots',1,'2025-12-05 10:44:20',NULL),('2025-12-04 10:44:20.926870',NULL,'2025-12-04 10:44:21.016393',666,666,'0ef0510443b848f1bfcd4a773578d114','c0d3a04e-a840-4e8f-a154-9fd607a160d2',194,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',1,'2025-12-05 10:44:20',NULL),('2025-12-04 10:44:20.938832',NULL,'2025-12-04 10:44:21.016393',667,667,NULL,'4c5d344b-9a64-4ab5-8fb7-7fd0950d2129',197,'18048b8b581e48239e3a92c77164734b','snapshots',1,'2025-12-05 10:44:20','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:20.943127',NULL,'2025-12-04 10:44:21.016393',668,668,NULL,'202c93ee-ecec-48c3-a836-5a53ba5d4754',196,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',1,'2025-12-05 10:44:20','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:27.312987',NULL,'2025-12-04 10:44:27.328350',669,669,'0ef0510443b848f1bfcd4a773578d114','052fdccc-81a3-4063-9e2e-09650248c832',195,'18048b8b581e48239e3a92c77164734b','snapshots',-1,'2025-12-05 10:44:27',NULL),('2025-12-04 10:44:27.313707',NULL,'2025-12-04 10:44:27.328350',670,670,'0ef0510443b848f1bfcd4a773578d114','e2da2bdb-7d4f-4a5b-9a64-18418854a137',194,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',-1,'2025-12-05 10:44:27',NULL),('2025-12-04 10:44:27.319526',NULL,'2025-12-04 10:44:27.328350',671,671,NULL,'481863f3-edc9-4c36-97c3-1f976c02296c',197,'18048b8b581e48239e3a92c77164734b','snapshots',-1,'2025-12-05 10:44:27','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:27.320431',NULL,'2025-12-04 10:44:27.328350',672,672,NULL,'cd8e9227-2e95-420f-94b9-0d4e537d15fb',196,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',-1,'2025-12-05 10:44:27','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:27.565770',NULL,'2025-12-04 10:44:27.610771',673,673,'08d39615a7a349ae95f9c66ad6c00312','bacf4101-6e72-44ab-8a66-57e77eb5bc53',205,'7df6681d57a74b90abc5310588588b91','shares',1,'2025-12-05 10:44:27',NULL),('2025-12-04 10:44:27.567072',NULL,'2025-12-04 10:44:27.610771',674,674,'08d39615a7a349ae95f9c66ad6c00312','7124ba50-33e5-42cb-ad26-464ff3a4e211',204,'7df6681d57a74b90abc5310588588b91','gigabytes',1,'2025-12-05 10:44:27',NULL),('2025-12-04 10:44:27.579258',NULL,'2025-12-04 10:44:27.610771',675,675,NULL,'19ad95df-b312-4d10-aec2-8cbb28f55222',207,'7df6681d57a74b90abc5310588588b91','shares',1,'2025-12-05 10:44:27','b022472d-700d-41d8-9151-d06e86a7dc3f'),('2025-12-04 10:44:27.580425',NULL,'2025-12-04 10:44:27.610771',676,676,NULL,'17cf87d2-e7b6-4783-955d-0d3190dd4b09',206,'7df6681d57a74b90abc5310588588b91','gigabytes',1,'2025-12-05 10:44:27','b022472d-700d-41d8-9151-d06e86a7dc3f'),('2025-12-04 10:44:28.941375',NULL,'2025-12-04 10:44:28.954332',677,677,'ac347d74fad64b0bbb495d6240c31d44','fac06112-7106-4279-a6e7-5b161e557a4b',187,'c2e0964e5703431eab30fd7c235961ae','shares',-1,'2025-12-05 10:44:28',NULL),('2025-12-04 10:44:28.942035',NULL,'2025-12-04 10:44:28.954332',678,678,'ac347d74fad64b0bbb495d6240c31d44','1bd4e40f-3986-4af5-b32e-c2d44c3c9220',186,'c2e0964e5703431eab30fd7c235961ae','gigabytes',-1,'2025-12-05 10:44:28',NULL),('2025-12-04 10:44:28.946789',NULL,'2025-12-04 10:44:28.954332',679,679,NULL,'b7fbc137-4c29-431d-a2aa-8828e255903d',203,'c2e0964e5703431eab30fd7c235961ae','shares',-1,'2025-12-05 10:44:28','4c300d44-f839-46b6-b125-41134ef8ee22'),('2025-12-04 10:44:28.947422',NULL,'2025-12-04 10:44:28.954332',680,680,NULL,'5a254cd0-4be0-4a3e-9c81-1c74552090b3',202,'c2e0964e5703431eab30fd7c235961ae','gigabytes',-1,'2025-12-05 10:44:28','4c300d44-f839-46b6-b125-41134ef8ee22'),('2025-12-04 10:44:31.795746',NULL,'2025-12-04 10:44:31.863570',681,681,'0ef0510443b848f1bfcd4a773578d114','828199f1-7a89-47b6-af07-0a9ba7ee7ff2',195,'18048b8b581e48239e3a92c77164734b','snapshots',1,'2025-12-05 10:44:31',NULL),('2025-12-04 10:44:31.797082',NULL,'2025-12-04 10:44:31.863570',682,682,'0ef0510443b848f1bfcd4a773578d114','ca830433-555d-4dfb-a2ec-8eafb6de31cc',194,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',1,'2025-12-05 10:44:31',NULL),('2025-12-04 10:44:31.802475',NULL,'2025-12-04 10:44:31.863570',683,683,NULL,'b704b94b-f015-4a15-b624-2368e1865f24',197,'18048b8b581e48239e3a92c77164734b','snapshots',1,'2025-12-05 10:44:31','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:31.803544',NULL,'2025-12-04 10:44:31.863570',684,684,NULL,'33eaf124-3872-46f4-9e75-dda26be18794',196,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',1,'2025-12-05 10:44:31','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:32.704168',NULL,'2025-12-04 10:44:32.720454',685,685,'ac347d74fad64b0bbb495d6240c31d44','c11bf978-87ba-4d92-a665-5d0fe87b13c6',187,'c2e0964e5703431eab30fd7c235961ae','shares',-1,'2025-12-05 10:44:32',NULL),('2025-12-04 10:44:32.705113',NULL,'2025-12-04 10:44:32.720454',686,686,'ac347d74fad64b0bbb495d6240c31d44','222cbb92-1707-47ce-bfe1-cbdf8144c1fa',186,'c2e0964e5703431eab30fd7c235961ae','gigabytes',-1,'2025-12-05 10:44:32',NULL),('2025-12-04 10:44:32.712099',NULL,'2025-12-04 10:44:32.720454',687,687,NULL,'60c722cc-b4ee-40e6-91e8-000a2449ed4c',189,'c2e0964e5703431eab30fd7c235961ae','shares',-1,'2025-12-05 10:44:32','a2f71277-9b7c-41be-ac23-94904d0c6314'),('2025-12-04 10:44:32.712791',NULL,'2025-12-04 10:44:32.720454',688,688,NULL,'ac0735a8-37a7-49f9-902e-4d91658c1732',188,'c2e0964e5703431eab30fd7c235961ae','gigabytes',-1,'2025-12-05 10:44:32','a2f71277-9b7c-41be-ac23-94904d0c6314'),('2025-12-04 10:44:36.386028',NULL,'2025-12-04 10:44:36.402116',689,689,'48ef94f1dc4447f08252015effc744b0','dcd8d612-1647-4c58-b68a-56ba3051b29e',180,'d831ca1755a740e7819c02d320ecd2a0','shares',-1,'2025-12-05 10:44:36',NULL),('2025-12-04 10:44:36.386793',NULL,'2025-12-04 10:44:36.402116',690,690,'48ef94f1dc4447f08252015effc744b0','5db8da3a-fd8c-471c-abd8-f5725b7a1ff1',181,'d831ca1755a740e7819c02d320ecd2a0','gigabytes',-1,'2025-12-05 10:44:36',NULL),('2025-12-04 10:44:36.393171',NULL,'2025-12-04 10:44:36.402116',691,691,NULL,'13eff444-6476-45c0-aa0f-387d330e75c9',185,'d831ca1755a740e7819c02d320ecd2a0','shares',-1,'2025-12-05 10:44:36','a2f71277-9b7c-41be-ac23-94904d0c6314'),('2025-12-04 10:44:36.394302',NULL,'2025-12-04 10:44:36.402116',692,692,NULL,'b516c809-f42f-41cd-81a7-9efafb8c9aac',184,'d831ca1755a740e7819c02d320ecd2a0','gigabytes',-1,'2025-12-05 10:44:36','a2f71277-9b7c-41be-ac23-94904d0c6314'),('2025-12-04 10:44:37.529912',NULL,'2025-12-04 10:44:37.545744',693,693,'0ef0510443b848f1bfcd4a773578d114','4e1ab82f-e6d5-4e41-8c6e-a1c0a1e41911',195,'18048b8b581e48239e3a92c77164734b','snapshots',-1,'2025-12-05 10:44:37',NULL),('2025-12-04 10:44:37.530821',NULL,'2025-12-04 10:44:37.545744',694,694,'0ef0510443b848f1bfcd4a773578d114','03a62d6c-9fe9-4e3d-ae47-a8d9ff87c513',194,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',-1,'2025-12-05 10:44:37',NULL),('2025-12-04 10:44:37.536798',NULL,'2025-12-04 10:44:37.545744',695,695,NULL,'760076d8-d07f-4531-a850-470ddd7833ef',197,'18048b8b581e48239e3a92c77164734b','snapshots',-1,'2025-12-05 10:44:37','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:37.537753',NULL,'2025-12-04 10:44:37.545744',696,696,NULL,'0b206dd1-75ee-48bf-b686-d57ef5c0b527',196,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',-1,'2025-12-05 10:44:37','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:40.078656',NULL,'2025-12-04 10:44:40.094299',697,697,'48ef94f1dc4447f08252015effc744b0','df75e75c-d36a-4a60-9ead-c6e216b0e03a',180,'d831ca1755a740e7819c02d320ecd2a0','shares',-1,'2025-12-05 10:44:40',NULL),('2025-12-04 10:44:40.079459',NULL,'2025-12-04 10:44:40.094299',698,698,'48ef94f1dc4447f08252015effc744b0','f154d6fa-efdd-4c41-b5a6-ba01758719f9',181,'d831ca1755a740e7819c02d320ecd2a0','gigabytes',-1,'2025-12-05 10:44:40',NULL),('2025-12-04 10:44:40.085127',NULL,'2025-12-04 10:44:40.094299',699,699,NULL,'aeffd049-1887-4b58-9e99-e0e2481e1c2f',182,'d831ca1755a740e7819c02d320ecd2a0','shares',-1,'2025-12-05 10:44:40','4c300d44-f839-46b6-b125-41134ef8ee22'),('2025-12-04 10:44:40.085788',NULL,'2025-12-04 10:44:40.094299',700,700,NULL,'58f6cacc-9c52-48b5-8d0f-b765b1d61e50',183,'d831ca1755a740e7819c02d320ecd2a0','gigabytes',-1,'2025-12-05 10:44:40','4c300d44-f839-46b6-b125-41134ef8ee22'),('2025-12-04 10:44:43.347259',NULL,'2025-12-04 10:44:43.363172',701,701,'0ef0510443b848f1bfcd4a773578d114','558c1013-467d-49ea-b639-4dbc3c985153',195,'18048b8b581e48239e3a92c77164734b','snapshots',-1,'2025-12-05 10:44:43',NULL),('2025-12-04 10:44:43.348116',NULL,'2025-12-04 10:44:43.363172',702,702,'0ef0510443b848f1bfcd4a773578d114','20e3a8ce-6e55-4eab-bc31-a6e01aca8204',194,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',-1,'2025-12-05 10:44:43',NULL),('2025-12-04 10:44:43.354500',NULL,'2025-12-04 10:44:43.363172',703,703,NULL,'8e5fa7db-330f-46fb-bf97-037b9635092f',197,'18048b8b581e48239e3a92c77164734b','snapshots',-1,'2025-12-05 10:44:43','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:43.355319',NULL,'2025-12-04 10:44:43.363172',704,704,NULL,'d7c1a603-eb9e-4f70-9ac0-8d3a28f62a1d',196,'18048b8b581e48239e3a92c77164734b','snapshot_gigabytes',-1,'2025-12-05 10:44:43','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:44.207245',NULL,'2025-12-04 10:44:44.229173',705,705,'0ef0510443b848f1bfcd4a773578d114','ae951036-2ae0-4591-86bb-c589e1519e76',190,'18048b8b581e48239e3a92c77164734b','shares',-1,'2025-12-05 10:44:44',NULL),('2025-12-04 10:44:44.208285',NULL,'2025-12-04 10:44:44.229173',706,706,'0ef0510443b848f1bfcd4a773578d114','c3460b80-0fe2-45b6-b88f-4b2eb0f3f014',191,'18048b8b581e48239e3a92c77164734b','gigabytes',-1,'2025-12-05 10:44:44',NULL),('2025-12-04 10:44:44.217567',NULL,'2025-12-04 10:44:44.229173',707,707,NULL,'1b49fd7f-c6f4-4bc9-9c8a-7a4301835d07',192,'18048b8b581e48239e3a92c77164734b','shares',-1,'2025-12-05 10:44:44','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:44.219328',NULL,'2025-12-04 10:44:44.229173',708,708,NULL,'70cd6cf5-8667-409e-9b36-e910e559f21a',193,'18048b8b581e48239e3a92c77164734b','gigabytes',-1,'2025-12-05 10:44:44','8e1ebbba-1c74-478b-9238-956133ca0d56'),('2025-12-04 10:44:59.437803',NULL,'2025-12-04 10:44:59.486548',709,709,'22ea2c4923594e4cb5626d4a09a7f6a1','f29e19d7-b912-42b8-a2f2-ec8e37d16331',208,'a206b399e9d842ecbeb897b80e10c0fc','share_networks',1,'2025-12-05 10:44:59',NULL),('2025-12-04 10:45:00.330687',NULL,'2025-12-04 10:45:00.337394',710,710,'22ea2c4923594e4cb5626d4a09a7f6a1','cda755f6-3776-4042-8c3f-795f36771459',208,'a206b399e9d842ecbeb897b80e10c0fc','share_networks',-1,'2025-12-05 10:45:00',NULL),('2025-12-04 10:45:00.542138',NULL,'2025-12-04 10:45:00.573608',711,711,'22ea2c4923594e4cb5626d4a09a7f6a1','f40517b4-1f72-4af0-9543-9629b0d92ea3',208,'a206b399e9d842ecbeb897b80e10c0fc','share_networks',1,'2025-12-05 10:45:00',NULL),('2025-12-04 10:45:01.244510',NULL,'2025-12-04 10:45:01.254365',712,712,'22ea2c4923594e4cb5626d4a09a7f6a1','cdf1e015-7519-4933-80ac-759b5acc6b54',208,'a206b399e9d842ecbeb897b80e10c0fc','share_networks',-1,'2025-12-05 10:45:01',NULL),('2025-12-04 10:45:01.421115',NULL,'2025-12-04 10:45:01.459381',713,713,'22ea2c4923594e4cb5626d4a09a7f6a1','16577c30-23e5-4ebe-a8ac-8b5b57fec5fc',208,'a206b399e9d842ecbeb897b80e10c0fc','share_networks',1,'2025-12-05 10:45:01',NULL),('2025-12-04 10:45:02.123358',NULL,'2025-12-04 10:45:02.141829',714,714,'22ea2c4923594e4cb5626d4a09a7f6a1','25fbdcbb-42eb-4f10-ad00-d6bbe8582418',208,'a206b399e9d842ecbeb897b80e10c0fc','share_networks',-1,'2025-12-05 10:45:02',NULL),('2025-12-04 10:45:08.054621',NULL,'2025-12-04 10:45:08.084550',715,715,'16082b385ae54073bd230a6276db6494','c4717eeb-1e96-48fd-b777-91425c3660f5',210,'fc1dc55455c4455c8c74c6488671677d','shares',1,'2025-12-05 10:45:08',NULL),('2025-12-04 10:45:08.055722',NULL,'2025-12-04 10:45:08.084550',716,716,'16082b385ae54073bd230a6276db6494','efe1ea2e-0f1e-439e-af30-df2a5892a21d',209,'fc1dc55455c4455c8c74c6488671677d','gigabytes',1,'2025-12-05 10:45:08',NULL),('2025-12-04 10:45:08.065520',NULL,'2025-12-04 10:45:08.084550',717,717,NULL,'1e98e77c-00d1-4389-bef6-5a385bdd3523',212,'fc1dc55455c4455c8c74c6488671677d','shares',1,'2025-12-05 10:45:08','79086422-8620-41bb-ad72-d3d2e0f09707'),('2025-12-04 10:45:08.066648',NULL,'2025-12-04 10:45:08.084550',718,718,NULL,'529c1d82-b446-4e89-895c-9a2467520cc2',211,'fc1dc55455c4455c8c74c6488671677d','gigabytes',1,'2025-12-05 10:45:08','79086422-8620-41bb-ad72-d3d2e0f09707'),('2025-12-04 10:45:11.913724',NULL,'2025-12-04 10:45:11.945621',719,719,'16082b385ae54073bd230a6276db6494','0ac6691c-1bcc-4c48-a65f-5b9217cf07b1',210,'fc1dc55455c4455c8c74c6488671677d','shares',1,'2025-12-05 10:45:11',NULL),('2025-12-04 10:45:11.915037',NULL,'2025-12-04 10:45:11.945621',720,720,'16082b385ae54073bd230a6276db6494','155eef69-7e44-4c17-82c4-8d77805f3327',209,'fc1dc55455c4455c8c74c6488671677d','gigabytes',1,'2025-12-05 10:45:11',NULL),('2025-12-04 10:45:11.922272',NULL,'2025-12-04 10:45:11.945621',721,721,NULL,'b2638ff9-833d-449e-bb88-dbc94117c2b1',212,'fc1dc55455c4455c8c74c6488671677d','shares',1,'2025-12-05 10:45:11','79086422-8620-41bb-ad72-d3d2e0f09707'),('2025-12-04 10:45:11.923371',NULL,'2025-12-04 10:45:11.945621',722,722,NULL,'981a8636-595b-45db-815b-a6e8ca0c2825',211,'fc1dc55455c4455c8c74c6488671677d','gigabytes',1,'2025-12-05 10:45:11','79086422-8620-41bb-ad72-d3d2e0f09707'),('2025-12-04 10:45:15.931475',NULL,'2025-12-04 10:45:15.964191',723,723,'16082b385ae54073bd230a6276db6494','81f60270-bd6a-4a4e-9205-848007c5c199',210,'fc1dc55455c4455c8c74c6488671677d','shares',1,'2025-12-05 10:45:15',NULL),('2025-12-04 10:45:15.933244',NULL,'2025-12-04 10:45:15.964191',724,724,'16082b385ae54073bd230a6276db6494','d0f110c8-294d-4154-a910-9ef5f0b1752e',209,'fc1dc55455c4455c8c74c6488671677d','gigabytes',1,'2025-12-05 10:45:15',NULL),('2025-12-04 10:45:15.944094',NULL,'2025-12-04 10:45:15.964191',725,725,NULL,'45da44cd-cf08-40d0-9bf6-5397336ee0c5',212,'fc1dc55455c4455c8c74c6488671677d','shares',1,'2025-12-05 10:45:15','79086422-8620-41bb-ad72-d3d2e0f09707'),('2025-12-04 10:45:15.945434',NULL,'2025-12-04 10:45:15.964191',726,726,NULL,'0ebea2b7-35bb-4d99-bae8-4c18510d271c',211,'fc1dc55455c4455c8c74c6488671677d','gigabytes',1,'2025-12-05 10:45:15','79086422-8620-41bb-ad72-d3d2e0f09707'),('2025-12-04 10:45:19.958723',NULL,'2025-12-04 10:45:20.007540',727,727,'16082b385ae54073bd230a6276db6494','0177c8db-f970-4be9-aa1d-8db4a9fd4d2e',210,'fc1dc55455c4455c8c74c6488671677d','shares',1,'2025-12-05 10:45:19',NULL),('2025-12-04 10:45:19.963039',NULL,'2025-12-04 10:45:20.007540',728,728,'16082b385ae54073bd230a6276db6494','fc390dae-2a53-41d3-99e4-06f88371df3a',209,'fc1dc55455c4455c8c74c6488671677d','gigabytes',1,'2025-12-05 10:45:19',NULL),('2025-12-04 10:45:19.974867',NULL,'2025-12-04 10:45:20.007540',729,729,NULL,'a117dc6a-7066-403b-9ccb-c68eebdb32f9',212,'fc1dc55455c4455c8c74c6488671677d','shares',1,'2025-12-05 10:45:19','79086422-8620-41bb-ad72-d3d2e0f09707'),('2025-12-04 10:45:19.976294',NULL,'2025-12-04 10:45:20.007540',730,730,NULL,'6ea2b72b-9e5c-4de9-b3ff-79209e4d740b',211,'fc1dc55455c4455c8c74c6488671677d','gigabytes',1,'2025-12-05 10:45:19','79086422-8620-41bb-ad72-d3d2e0f09707'),('2025-12-04 10:45:25.101881',NULL,'2025-12-04 10:45:25.131338',731,731,'16082b385ae54073bd230a6276db6494','8d2c9e1a-9609-4947-a3f7-c7540633ab2b',210,'fc1dc55455c4455c8c74c6488671677d','shares',-1,'2025-12-05 10:45:25',NULL),('2025-12-04 10:45:25.103241',NULL,'2025-12-04 10:45:25.131338',732,732,'16082b385ae54073bd230a6276db6494','03ce93e4-c0d3-46e2-bfed-eb1b709ed4d3',209,'fc1dc55455c4455c8c74c6488671677d','gigabytes',-1,'2025-12-05 10:45:25',NULL),('2025-12-04 10:45:25.116250',NULL,'2025-12-04 10:45:25.131338',733,733,NULL,'70831624-fbcc-4db7-a6ed-06a2333df6bc',212,'fc1dc55455c4455c8c74c6488671677d','shares',-1,'2025-12-05 10:45:25','79086422-8620-41bb-ad72-d3d2e0f09707'),('2025-12-04 10:45:25.117420',NULL,'2025-12-04 10:45:25.131338',734,734,NULL,'59ba61f5-4068-496f-bbf7-bd99db353f40',211,'fc1dc55455c4455c8c74c6488671677d','gigabytes',-1,'2025-12-05 10:45:25','79086422-8620-41bb-ad72-d3d2e0f09707'),('2025-12-04 10:45:28.966557',NULL,'2025-12-04 10:45:29.002890',735,735,'16082b385ae54073bd230a6276db6494','477abc9c-9ddd-4b66-8b39-412a836cc9af',210,'fc1dc55455c4455c8c74c6488671677d','shares',-1,'2025-12-05 10:45:28',NULL),('2025-12-04 10:45:28.967795',NULL,'2025-12-04 10:45:29.002890',736,736,'16082b385ae54073bd230a6276db6494','f6927b24-ea30-4140-89e6-831f88640489',209,'fc1dc55455c4455c8c74c6488671677d','gigabytes',-1,'2025-12-05 10:45:28',NULL),('2025-12-04 10:45:28.988287',NULL,'2025-12-04 10:45:29.002890',737,737,NULL,'d6c60d87-5987-42ab-83b3-8538a80b83f3',212,'fc1dc55455c4455c8c74c6488671677d','shares',-1,'2025-12-05 10:45:28','79086422-8620-41bb-ad72-d3d2e0f09707'),('2025-12-04 10:45:28.989535',NULL,'2025-12-04 10:45:29.002890',738,738,NULL,'1c15708b-76ef-446a-af6f-5333a8c85030',211,'fc1dc55455c4455c8c74c6488671677d','gigabytes',-1,'2025-12-05 10:45:28','79086422-8620-41bb-ad72-d3d2e0f09707'),('2025-12-04 10:45:32.234179',NULL,'2025-12-04 10:45:32.275937',739,739,'16082b385ae54073bd230a6276db6494','97c07c19-e8cc-4358-85b9-8f5a4ab19209',210,'fc1dc55455c4455c8c74c6488671677d','shares',-1,'2025-12-05 10:45:32',NULL),('2025-12-04 10:45:32.235136',NULL,'2025-12-04 10:45:32.275937',740,740,'16082b385ae54073bd230a6276db6494','346a8462-2312-4847-af5a-9da42fe65adf',209,'fc1dc55455c4455c8c74c6488671677d','gigabytes',-1,'2025-12-05 10:45:32',NULL),('2025-12-04 10:45:32.258421',NULL,'2025-12-04 10:45:32.275937',741,741,NULL,'973f5df8-ea54-40dd-b873-5824c89b87f9',212,'fc1dc55455c4455c8c74c6488671677d','shares',-1,'2025-12-05 10:45:32','79086422-8620-41bb-ad72-d3d2e0f09707'),('2025-12-04 10:45:32.259344',NULL,'2025-12-04 10:45:32.275937',742,742,NULL,'0a11236b-5454-4ab5-8058-5604d848a777',211,'fc1dc55455c4455c8c74c6488671677d','gigabytes',-1,'2025-12-05 10:45:32','79086422-8620-41bb-ad72-d3d2e0f09707'),('2025-12-04 10:45:35.752381',NULL,'2025-12-04 10:45:35.793798',743,743,'16082b385ae54073bd230a6276db6494','c215d3f8-17f7-423d-98bc-73d28dd90277',210,'fc1dc55455c4455c8c74c6488671677d','shares',-1,'2025-12-05 10:45:35',NULL),('2025-12-04 10:45:35.753754',NULL,'2025-12-04 10:45:35.793798',744,744,'16082b385ae54073bd230a6276db6494','63698bd0-8b95-49ee-9f18-0e1d7154df2d',209,'fc1dc55455c4455c8c74c6488671677d','gigabytes',-1,'2025-12-05 10:45:35',NULL),('2025-12-04 10:45:35.770020',NULL,'2025-12-04 10:45:35.793798',745,745,NULL,'6edc1fa0-f7fa-48d3-b2fb-291b7af90805',212,'fc1dc55455c4455c8c74c6488671677d','shares',-1,'2025-12-05 10:45:35','79086422-8620-41bb-ad72-d3d2e0f09707'),('2025-12-04 10:45:35.771170',NULL,'2025-12-04 10:45:35.793798',746,746,NULL,'cacb2618-0b09-414d-8686-c75360dd9970',211,'fc1dc55455c4455c8c74c6488671677d','gigabytes',-1,'2025-12-05 10:45:35','79086422-8620-41bb-ad72-d3d2e0f09707'),('2025-12-04 10:45:56.389883',NULL,'2025-12-04 10:45:56.426165',747,747,'c8bddd1494604235b944287494725839','4ecdec09-1a8f-4a03-a4c5-f3eaf7b77de0',213,'bdee1673bf874393ab80f7311782fc10','shares',1,'2025-12-05 10:45:56',NULL),('2025-12-04 10:45:56.391084',NULL,'2025-12-04 10:45:56.426165',748,748,'c8bddd1494604235b944287494725839','b5d9c104-90c1-4801-9c10-72902c9d18ae',214,'bdee1673bf874393ab80f7311782fc10','gigabytes',1,'2025-12-05 10:45:56',NULL),('2025-12-04 10:45:56.401124',NULL,'2025-12-04 10:45:56.426165',749,749,NULL,'c39a9209-14c1-4d6b-b342-4d1c9698fdb3',215,'bdee1673bf874393ab80f7311782fc10','shares',1,'2025-12-05 10:45:56','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:45:56.402294',NULL,'2025-12-04 10:45:56.426165',750,750,NULL,'4d9f1774-6595-47eb-bfea-91ae0b45b7c2',216,'bdee1673bf874393ab80f7311782fc10','gigabytes',1,'2025-12-05 10:45:56','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:45:59.811262',NULL,'2025-12-04 10:45:59.905641',751,751,'c8bddd1494604235b944287494725839','8a6c5e57-a3ab-404e-93a3-2279e1a75fdd',218,'bdee1673bf874393ab80f7311782fc10','snapshots',1,'2025-12-05 10:45:59',NULL),('2025-12-04 10:45:59.812519',NULL,'2025-12-04 10:45:59.905641',752,752,'c8bddd1494604235b944287494725839','74fa723c-082f-4271-9c4b-687605e348f1',217,'bdee1673bf874393ab80f7311782fc10','snapshot_gigabytes',1,'2025-12-05 10:45:59',NULL),('2025-12-04 10:45:59.823268',NULL,'2025-12-04 10:45:59.905641',753,753,NULL,'9781a9a0-4de3-469e-9d26-bb75842d8c66',220,'bdee1673bf874393ab80f7311782fc10','snapshots',1,'2025-12-05 10:45:59','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:45:59.824394',NULL,'2025-12-04 10:45:59.905641',754,754,NULL,'1cba0dab-816a-4c84-b181-792b9d4aab9b',219,'bdee1673bf874393ab80f7311782fc10','snapshot_gigabytes',1,'2025-12-05 10:45:59','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:46:03.307380',NULL,'2025-12-04 10:46:03.351717',755,755,'c8bddd1494604235b944287494725839','3ab3773b-459c-4087-a055-b41d6cee3633',213,'bdee1673bf874393ab80f7311782fc10','shares',1,'2025-12-05 10:46:03',NULL),('2025-12-04 10:46:03.308612',NULL,'2025-12-04 10:46:03.351717',756,756,'c8bddd1494604235b944287494725839','ad8c4851-a870-4bf6-8578-7f5e59407054',214,'bdee1673bf874393ab80f7311782fc10','gigabytes',1,'2025-12-05 10:46:03',NULL),('2025-12-04 10:46:03.327403',NULL,'2025-12-04 10:46:03.351717',757,757,NULL,'5a48bbf9-4a61-4c45-8459-33fb912f4d8c',215,'bdee1673bf874393ab80f7311782fc10','shares',1,'2025-12-05 10:46:03','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:46:03.328692',NULL,'2025-12-04 10:46:03.351717',758,758,NULL,'d02b7626-8a3d-47b5-ba12-bc5ac56426ac',216,'bdee1673bf874393ab80f7311782fc10','gigabytes',1,'2025-12-05 10:46:03','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:46:25.143998',NULL,'2025-12-04 10:46:25.174737',759,759,'c8bddd1494604235b944287494725839','345fb79d-fab6-4319-9dbc-85a2015f4627',213,'bdee1673bf874393ab80f7311782fc10','shares',1,'2025-12-05 10:46:25',NULL),('2025-12-04 10:46:25.145374',NULL,'2025-12-04 10:46:25.174737',760,760,'c8bddd1494604235b944287494725839','e8d95776-2b3d-4de4-bf39-fa5c81ca2029',214,'bdee1673bf874393ab80f7311782fc10','gigabytes',1,'2025-12-05 10:46:25',NULL),('2025-12-04 10:46:25.152477',NULL,'2025-12-04 10:46:25.174737',761,761,NULL,'7293dfaa-76c8-4988-83b0-2a4414675931',215,'bdee1673bf874393ab80f7311782fc10','shares',1,'2025-12-05 10:46:25','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:46:25.153706',NULL,'2025-12-04 10:46:25.174737',762,762,NULL,'1a734ddd-6883-4148-a443-0ae516cfeee8',216,'bdee1673bf874393ab80f7311782fc10','gigabytes',1,'2025-12-05 10:46:25','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:46:28.685564',NULL,'2025-12-04 10:46:28.870120',763,763,'c8bddd1494604235b944287494725839','65d57210-c945-4881-8717-00fb2bf01468',214,'bdee1673bf874393ab80f7311782fc10','gigabytes',1,'2025-12-05 10:46:28',NULL),('2025-12-04 10:46:28.693675',NULL,'2025-12-04 10:46:28.870120',764,764,NULL,'0130bbff-f280-476e-a3b4-42c720bf581a',216,'bdee1673bf874393ab80f7311782fc10','gigabytes',1,'2025-12-05 10:46:28','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:46:32.520520',NULL,'2025-12-04 10:46:32.538407',765,765,'c8bddd1494604235b944287494725839','d94aa5e9-63e7-4cab-abee-3a022b133c85',213,'bdee1673bf874393ab80f7311782fc10','shares',-1,'2025-12-05 10:46:32',NULL),('2025-12-04 10:46:32.521347',NULL,'2025-12-04 10:46:32.538407',766,766,'c8bddd1494604235b944287494725839','f8015684-6815-4efb-9c18-8c4283b21b41',214,'bdee1673bf874393ab80f7311782fc10','gigabytes',-2,'2025-12-05 10:46:32',NULL),('2025-12-04 10:46:32.528421',NULL,'2025-12-04 10:46:32.538407',767,767,NULL,'e7c19625-2b25-4c23-bc20-48eee939c653',215,'bdee1673bf874393ab80f7311782fc10','shares',-1,'2025-12-05 10:46:32','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:46:32.529296',NULL,'2025-12-04 10:46:32.538407',768,768,NULL,'7a647e1c-03ab-44ca-b300-4a2cf2784085',216,'bdee1673bf874393ab80f7311782fc10','gigabytes',-2,'2025-12-05 10:46:32','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:46:39.970461',NULL,'2025-12-04 10:46:40.011770',769,769,'c8bddd1494604235b944287494725839','4d777d22-a1e1-4552-97b9-45b7f07e111c',213,'bdee1673bf874393ab80f7311782fc10','shares',1,'2025-12-05 10:46:39',NULL),('2025-12-04 10:46:39.972017',NULL,'2025-12-04 10:46:40.011770',770,770,'c8bddd1494604235b944287494725839','63e9b82e-eac7-4832-a6d3-b34a4e2e6189',214,'bdee1673bf874393ab80f7311782fc10','gigabytes',2,'2025-12-05 10:46:39',NULL),('2025-12-04 10:46:39.980304',NULL,'2025-12-04 10:46:40.011770',771,771,NULL,'5a3d68b1-42bf-49dc-b81b-a66ce3319b24',215,'bdee1673bf874393ab80f7311782fc10','shares',1,'2025-12-05 10:46:39','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:46:39.983265',NULL,'2025-12-04 10:46:40.011770',772,772,NULL,'62bf5be7-4091-4177-a4ce-e9fa66c59c43',216,'bdee1673bf874393ab80f7311782fc10','gigabytes',2,'2025-12-05 10:46:39','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:46:43.434279',NULL,'2025-12-04 10:46:43.470610',773,773,'c8bddd1494604235b944287494725839','6f265d8b-a56c-4e24-a7b8-269bc3abf499',214,'bdee1673bf874393ab80f7311782fc10','gigabytes',-1,'2025-12-05 10:46:43',NULL),('2025-12-04 10:46:43.442156',NULL,'2025-12-04 10:46:43.470610',774,774,NULL,'1546cd51-4a98-433d-bda4-6d44f5c0bf1d',216,'bdee1673bf874393ab80f7311782fc10','gigabytes',-1,'2025-12-05 10:46:43','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:46:47.117706',NULL,'2025-12-04 10:46:47.136130',775,775,'c8bddd1494604235b944287494725839','15fb7fcc-5908-4943-86f6-f05db35a9b51',213,'bdee1673bf874393ab80f7311782fc10','shares',-1,'2025-12-05 10:46:47',NULL),('2025-12-04 10:46:47.118642',NULL,'2025-12-04 10:46:47.136130',776,776,'c8bddd1494604235b944287494725839','e5836293-38ee-4d58-8dac-5ff0c0706520',214,'bdee1673bf874393ab80f7311782fc10','gigabytes',-1,'2025-12-05 10:46:47',NULL),('2025-12-04 10:46:47.125850',NULL,'2025-12-04 10:46:47.136130',777,777,NULL,'cbc50a5a-a48e-47b7-8d1d-c1cbf3a295b9',215,'bdee1673bf874393ab80f7311782fc10','shares',-1,'2025-12-05 10:46:47','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:46:47.126736',NULL,'2025-12-04 10:46:47.136130',778,778,NULL,'1442aaf2-cd07-478d-bfe3-65b68a8ba05c',216,'bdee1673bf874393ab80f7311782fc10','gigabytes',-1,'2025-12-05 10:46:47','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:46:50.054956',NULL,'2025-12-04 10:46:50.085849',779,779,'c8bddd1494604235b944287494725839','5bb1edb7-e9b8-46b8-8e6a-2dc9874416a3',213,'bdee1673bf874393ab80f7311782fc10','shares',1,'2025-12-05 10:46:50',NULL),('2025-12-04 10:46:50.056289',NULL,'2025-12-04 10:46:50.085849',780,780,'c8bddd1494604235b944287494725839','e97a74ee-29a2-4626-80dd-70209b666874',214,'bdee1673bf874393ab80f7311782fc10','gigabytes',1,'2025-12-05 10:46:50',NULL),('2025-12-04 10:46:50.062807',NULL,'2025-12-04 10:46:50.085849',781,781,NULL,'1487bf89-685d-4a8c-b064-8e5ad64b1d5e',215,'bdee1673bf874393ab80f7311782fc10','shares',1,'2025-12-05 10:46:50','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:46:50.063988',NULL,'2025-12-04 10:46:50.085849',782,782,NULL,'d1fad1d0-0f09-49ca-994e-3ff6f7087b54',216,'bdee1673bf874393ab80f7311782fc10','gigabytes',1,'2025-12-05 10:46:50','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:46:55.249653',NULL,'2025-12-04 10:46:55.265131',783,783,'c8bddd1494604235b944287494725839','f0e850b9-cc51-4589-bf93-e066fbf5d61f',213,'bdee1673bf874393ab80f7311782fc10','shares',-1,'2025-12-05 10:46:55',NULL),('2025-12-04 10:46:55.250607',NULL,'2025-12-04 10:46:55.265131',784,784,'c8bddd1494604235b944287494725839','95cd66cc-33cc-4127-abfd-7cd35f5940d3',214,'bdee1673bf874393ab80f7311782fc10','gigabytes',-1,'2025-12-05 10:46:55',NULL),('2025-12-04 10:46:55.256513',NULL,'2025-12-04 10:46:55.265131',785,785,NULL,'c25abc48-89ed-4fdb-b50a-424df8545831',215,'bdee1673bf874393ab80f7311782fc10','shares',-1,'2025-12-05 10:46:55','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:46:55.257439',NULL,'2025-12-04 10:46:55.265131',786,786,NULL,'c0fdcd3e-13af-4c3e-a6b0-a714e10cee88',216,'bdee1673bf874393ab80f7311782fc10','gigabytes',-1,'2025-12-05 10:46:55','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:46:58.601644',NULL,'2025-12-04 10:46:58.620384',787,787,'c8bddd1494604235b944287494725839','b12f6c7f-39e7-4a43-b8d9-e8fb4866617c',213,'bdee1673bf874393ab80f7311782fc10','shares',-1,'2025-12-05 10:46:58',NULL),('2025-12-04 10:46:58.602474',NULL,'2025-12-04 10:46:58.620384',788,788,'c8bddd1494604235b944287494725839','8199a449-e66f-44d6-a466-cde07c882597',214,'bdee1673bf874393ab80f7311782fc10','gigabytes',-1,'2025-12-05 10:46:58',NULL),('2025-12-04 10:46:58.610490',NULL,'2025-12-04 10:46:58.620384',789,789,NULL,'325013c6-3a09-410a-9a06-8ebe5f2a5f82',215,'bdee1673bf874393ab80f7311782fc10','shares',-1,'2025-12-05 10:46:58','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:46:58.611303',NULL,'2025-12-04 10:46:58.620384',790,790,NULL,'450a54e3-741a-4c50-89a6-aad01e74a0ca',216,'bdee1673bf874393ab80f7311782fc10','gigabytes',-1,'2025-12-05 10:46:58','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:47:02.035848',NULL,'2025-12-04 10:47:02.060305',791,791,'c8bddd1494604235b944287494725839','854bae3f-e683-479c-ba59-0704a299380e',218,'bdee1673bf874393ab80f7311782fc10','snapshots',-1,'2025-12-05 10:47:01',NULL),('2025-12-04 10:47:02.036970',NULL,'2025-12-04 10:47:02.060305',792,792,'c8bddd1494604235b944287494725839','4f14e336-6c19-46bc-8a5e-c34f10ab486a',217,'bdee1673bf874393ab80f7311782fc10','snapshot_gigabytes',-1,'2025-12-05 10:47:01',NULL),('2025-12-04 10:47:02.050263',NULL,'2025-12-04 10:47:02.060305',793,793,NULL,'3ee2471a-bd11-44cf-b8fe-4f206c299b0c',220,'bdee1673bf874393ab80f7311782fc10','snapshots',-1,'2025-12-05 10:47:01','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:47:02.051279',NULL,'2025-12-04 10:47:02.060305',794,794,NULL,'cbaf33f9-7ecd-47c1-a6f6-dca33f4d6ff2',219,'bdee1673bf874393ab80f7311782fc10','snapshot_gigabytes',-1,'2025-12-05 10:47:01','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:47:05.404082',NULL,'2025-12-04 10:47:05.420119',795,795,'c8bddd1494604235b944287494725839','70ca9cfc-070f-4062-80e2-5370e292579e',213,'bdee1673bf874393ab80f7311782fc10','shares',-1,'2025-12-05 10:47:05',NULL),('2025-12-04 10:47:05.404807',NULL,'2025-12-04 10:47:05.420119',796,796,'c8bddd1494604235b944287494725839','755f0a44-d8b6-4290-91fe-3173938c3a93',214,'bdee1673bf874393ab80f7311782fc10','gigabytes',-1,'2025-12-05 10:47:05',NULL),('2025-12-04 10:47:05.411965',NULL,'2025-12-04 10:47:05.420119',797,797,NULL,'a6d99eb0-4b6d-400a-97d7-c797dc92ded3',215,'bdee1673bf874393ab80f7311782fc10','shares',-1,'2025-12-05 10:47:05','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:47:05.412624',NULL,'2025-12-04 10:47:05.420119',798,798,NULL,'542f869a-8a90-49bb-a501-0f8d7cfdcbe9',216,'bdee1673bf874393ab80f7311782fc10','gigabytes',-1,'2025-12-05 10:47:05','ac7bd782-cd71-4f35-9fed-0f011ba5e09d'),('2025-12-04 10:47:17.637539',NULL,'2025-12-04 10:47:17.689176',799,799,'c99b07cc76794bbe865e84c99d719aec','db593e19-baed-4d7b-a4d8-c5cba0cd6763',222,'b08d95dfcf5049b89d93e68ea13452d2','shares',1,'2025-12-05 10:47:17',NULL),('2025-12-04 10:47:17.639012',NULL,'2025-12-04 10:47:17.689176',800,800,'c99b07cc76794bbe865e84c99d719aec','8ec2b55a-8097-4537-9e1a-311763845c5c',221,'b08d95dfcf5049b89d93e68ea13452d2','gigabytes',2,'2025-12-05 10:47:17',NULL),('2025-12-04 10:47:17.657081',NULL,'2025-12-04 10:47:17.689176',801,801,NULL,'a115a61c-a751-48bc-a172-0e2f5e35cd1a',224,'b08d95dfcf5049b89d93e68ea13452d2','shares',1,'2025-12-05 10:47:17','7e2e54b3-9fc4-42f1-9682-dfd37ababbc9'),('2025-12-04 10:47:17.658173',NULL,'2025-12-04 10:47:17.689176',802,802,NULL,'92820cce-4977-4ae8-82fa-d5c888d44022',223,'b08d95dfcf5049b89d93e68ea13452d2','gigabytes',2,'2025-12-05 10:47:17','7e2e54b3-9fc4-42f1-9682-dfd37ababbc9'),('2025-12-04 10:47:21.120439',NULL,'2025-12-04 10:47:21.235697',803,803,'c99b07cc76794bbe865e84c99d719aec','db86f53d-cf74-4621-b415-cc6a64857bd9',225,'b08d95dfcf5049b89d93e68ea13452d2','snapshots',1,'2025-12-05 10:47:21',NULL),('2025-12-04 10:47:21.122016',NULL,'2025-12-04 10:47:21.235697',804,804,'c99b07cc76794bbe865e84c99d719aec','12bc42b3-567b-4139-9a60-79a00c1e0656',226,'b08d95dfcf5049b89d93e68ea13452d2','snapshot_gigabytes',2,'2025-12-05 10:47:21',NULL),('2025-12-04 10:47:21.140611',NULL,'2025-12-04 10:47:21.235697',805,805,NULL,'34293ee4-d91b-469e-9463-2a521b137150',227,'b08d95dfcf5049b89d93e68ea13452d2','snapshots',1,'2025-12-05 10:47:21','7e2e54b3-9fc4-42f1-9682-dfd37ababbc9'),('2025-12-04 10:47:21.142068',NULL,'2025-12-04 10:47:21.235697',806,806,NULL,'8f9f72f3-11a7-42dc-9955-80358990d8f5',228,'b08d95dfcf5049b89d93e68ea13452d2','snapshot_gigabytes',2,'2025-12-05 10:47:21','7e2e54b3-9fc4-42f1-9682-dfd37ababbc9'),('2025-12-04 10:47:25.352683',NULL,'2025-12-04 10:47:25.372146',807,807,'c99b07cc76794bbe865e84c99d719aec','d208f0d5-9af0-4d4e-a9cc-c92ac2c1fb2b',225,'b08d95dfcf5049b89d93e68ea13452d2','snapshots',-1,'2025-12-05 10:47:25',NULL),('2025-12-04 10:47:25.353677',NULL,'2025-12-04 10:47:25.372146',808,808,'c99b07cc76794bbe865e84c99d719aec','6b8bccde-0d6c-4f0e-935a-e4105ec87b33',226,'b08d95dfcf5049b89d93e68ea13452d2','snapshot_gigabytes',-2,'2025-12-05 10:47:25',NULL),('2025-12-04 10:47:25.362003',NULL,'2025-12-04 10:47:25.372146',809,809,NULL,'855371d9-5d10-43a6-b7e9-fd75832241ab',227,'b08d95dfcf5049b89d93e68ea13452d2','snapshots',-1,'2025-12-05 10:47:25','7e2e54b3-9fc4-42f1-9682-dfd37ababbc9'),('2025-12-04 10:47:25.362749',NULL,'2025-12-04 10:47:25.372146',810,810,NULL,'1960f7e5-7261-4d27-add2-99c04ea68963',228,'b08d95dfcf5049b89d93e68ea13452d2','snapshot_gigabytes',-2,'2025-12-05 10:47:25','7e2e54b3-9fc4-42f1-9682-dfd37ababbc9'),('2025-12-04 10:47:25.708488',NULL,'2025-12-04 10:47:25.926034',811,811,'7cbf92cc96924e4faa65304277a5028e','08a2f320-7387-4b0b-82c4-9eb7a6b11bfc',229,'7df6681d57a74b90abc5310588588b91','shares',1,'2025-12-05 10:47:25',NULL),('2025-12-04 10:47:25.710095',NULL,'2025-12-04 10:47:25.926034',812,812,'7cbf92cc96924e4faa65304277a5028e','18a7a73b-db46-4768-b891-1680128d2a63',230,'7df6681d57a74b90abc5310588588b91','gigabytes',1,'2025-12-05 10:47:25',NULL),('2025-12-04 10:47:25.735901',NULL,'2025-12-04 10:47:25.926034',813,813,NULL,'f57f3096-9e30-4c12-9f0c-4ba89e47b2a0',207,'7df6681d57a74b90abc5310588588b91','shares',1,'2025-12-05 10:47:25','b022472d-700d-41d8-9151-d06e86a7dc3f'),('2025-12-04 10:47:25.740767',NULL,'2025-12-04 10:47:25.926034',814,814,NULL,'36fff9b3-3e25-4f4c-9cab-2dd4f8fc2e1d',206,'7df6681d57a74b90abc5310588588b91','gigabytes',1,'2025-12-05 10:47:25','b022472d-700d-41d8-9151-d06e86a7dc3f'),('2025-12-04 10:47:28.603405',NULL,'2025-12-04 10:47:28.645685',815,815,'c99b07cc76794bbe865e84c99d719aec','01e76df2-688e-494a-90a8-cce970bd507d',222,'b08d95dfcf5049b89d93e68ea13452d2','shares',-1,'2025-12-05 10:47:28',NULL),('2025-12-04 10:47:28.626640',NULL,'2025-12-04 10:47:28.645685',816,816,'c99b07cc76794bbe865e84c99d719aec','fcecb4f1-7ee4-4459-8cce-6f8030b3741a',221,'b08d95dfcf5049b89d93e68ea13452d2','gigabytes',-2,'2025-12-05 10:47:28',NULL),('2025-12-04 10:47:28.636629',NULL,'2025-12-04 10:47:28.645685',817,817,NULL,'c2867a4c-d31c-46f3-987f-4cb48760f861',224,'b08d95dfcf5049b89d93e68ea13452d2','shares',-1,'2025-12-05 10:47:28','7e2e54b3-9fc4-42f1-9682-dfd37ababbc9'),('2025-12-04 10:47:28.637738',NULL,'2025-12-04 10:47:28.645685',818,818,NULL,'c3263ad7-39ee-41c0-9122-c10e472d493f',223,'b08d95dfcf5049b89d93e68ea13452d2','gigabytes',-2,'2025-12-05 10:47:28','7e2e54b3-9fc4-42f1-9682-dfd37ababbc9'),('2025-12-04 10:47:31.661249',NULL,'2025-12-04 10:47:31.854836',819,819,'c99b07cc76794bbe865e84c99d719aec','42277a8a-05bf-43b8-b468-47af98a158ec',222,'b08d95dfcf5049b89d93e68ea13452d2','shares',1,'2025-12-05 10:47:31',NULL),('2025-12-04 10:47:31.662819',NULL,'2025-12-04 10:47:31.854836',820,820,'c99b07cc76794bbe865e84c99d719aec','f4cb07a7-1603-46b4-a23a-ee2e27495301',221,'b08d95dfcf5049b89d93e68ea13452d2','gigabytes',1,'2025-12-05 10:47:31',NULL),('2025-12-04 10:47:31.751046',NULL,'2025-12-04 10:47:31.854836',821,821,NULL,'e52d9824-0caa-49e5-bafd-dd0c5256bb04',224,'b08d95dfcf5049b89d93e68ea13452d2','shares',1,'2025-12-05 10:47:31','7e2e54b3-9fc4-42f1-9682-dfd37ababbc9'),('2025-12-04 10:47:31.752322',NULL,'2025-12-04 10:47:31.854836',822,822,NULL,'6f725dc0-a0af-42d0-b9c8-2da03ea9df1a',223,'b08d95dfcf5049b89d93e68ea13452d2','gigabytes',1,'2025-12-05 10:47:31','7e2e54b3-9fc4-42f1-9682-dfd37ababbc9'),('2025-12-04 10:47:35.303722',NULL,'2025-12-04 10:47:35.556555',823,823,'c99b07cc76794bbe865e84c99d719aec','b0f2450a-6ae6-41dd-be11-28967dc992d0',225,'b08d95dfcf5049b89d93e68ea13452d2','snapshots',1,'2025-12-05 10:47:35',NULL),('2025-12-04 10:47:35.305181',NULL,'2025-12-04 10:47:35.556555',824,824,'c99b07cc76794bbe865e84c99d719aec','c346bebf-0546-4481-a4c1-52898e78dea2',226,'b08d95dfcf5049b89d93e68ea13452d2','snapshot_gigabytes',1,'2025-12-05 10:47:35',NULL),('2025-12-04 10:47:35.355265',NULL,'2025-12-04 10:47:35.556555',825,825,NULL,'517fd42c-1560-4c10-ac75-6b5c4dfdab71',227,'b08d95dfcf5049b89d93e68ea13452d2','snapshots',1,'2025-12-05 10:47:35','7e2e54b3-9fc4-42f1-9682-dfd37ababbc9'),('2025-12-04 10:47:35.356658',NULL,'2025-12-04 10:47:35.556555',826,826,NULL,'6a67f002-bbae-4c39-8359-3bea8bd76630',228,'b08d95dfcf5049b89d93e68ea13452d2','snapshot_gigabytes',1,'2025-12-05 10:47:35','7e2e54b3-9fc4-42f1-9682-dfd37ababbc9'),('2025-12-04 10:47:40.355814',NULL,'2025-12-04 10:47:40.376006',827,827,'c99b07cc76794bbe865e84c99d719aec','a2bc2e1e-6250-4597-b867-86716420fd3a',225,'b08d95dfcf5049b89d93e68ea13452d2','snapshots',-1,'2025-12-05 10:47:40',NULL),('2025-12-04 10:47:40.356626',NULL,'2025-12-04 10:47:40.376006',828,828,'c99b07cc76794bbe865e84c99d719aec','31e9e952-b815-4abe-b0cb-a8d12dfef895',226,'b08d95dfcf5049b89d93e68ea13452d2','snapshot_gigabytes',-1,'2025-12-05 10:47:40',NULL),('2025-12-04 10:47:40.365791',NULL,'2025-12-04 10:47:40.376006',829,829,NULL,'31ecf042-d8ab-4322-ba3a-203deb02d36d',227,'b08d95dfcf5049b89d93e68ea13452d2','snapshots',-1,'2025-12-05 10:47:40','7e2e54b3-9fc4-42f1-9682-dfd37ababbc9'),('2025-12-04 10:47:40.366793',NULL,'2025-12-04 10:47:40.376006',830,830,NULL,'4f77985f-93fa-40bb-888a-e2c79114ed70',228,'b08d95dfcf5049b89d93e68ea13452d2','snapshot_gigabytes',-1,'2025-12-05 10:47:40','7e2e54b3-9fc4-42f1-9682-dfd37ababbc9'),('2025-12-04 10:47:41.111333',NULL,'2025-12-04 10:47:41.203203',831,831,'08d39615a7a349ae95f9c66ad6c00312','ad27e667-aac7-4a0f-b068-2479f0c7d498',205,'7df6681d57a74b90abc5310588588b91','shares',-1,'2025-12-05 10:47:41',NULL),('2025-12-04 10:47:41.112153',NULL,'2025-12-04 10:47:41.203203',832,832,'08d39615a7a349ae95f9c66ad6c00312','6aa561d1-3e63-4ff9-8c5f-b3170cb5178a',204,'7df6681d57a74b90abc5310588588b91','gigabytes',-1,'2025-12-05 10:47:41',NULL),('2025-12-04 10:47:41.120215',NULL,'2025-12-04 10:47:41.203203',833,833,NULL,'d0f36b3f-8a92-4bb6-9b46-77b317db2beb',207,'7df6681d57a74b90abc5310588588b91','shares',-1,'2025-12-05 10:47:41','b022472d-700d-41d8-9151-d06e86a7dc3f'),('2025-12-04 10:47:41.120897',NULL,'2025-12-04 10:47:41.203203',834,834,NULL,'c1deeb58-bd4d-4c05-a298-644533073e6e',206,'7df6681d57a74b90abc5310588588b91','gigabytes',-1,'2025-12-05 10:47:41','b022472d-700d-41d8-9151-d06e86a7dc3f'),('2025-12-04 10:47:43.910525',NULL,'2025-12-04 10:47:43.926314',835,835,'c99b07cc76794bbe865e84c99d719aec','a3de1e2f-4306-447f-b5d5-af94c79fbe39',222,'b08d95dfcf5049b89d93e68ea13452d2','shares',-1,'2025-12-05 10:47:43',NULL),('2025-12-04 10:47:43.911393',NULL,'2025-12-04 10:47:43.926314',836,836,'c99b07cc76794bbe865e84c99d719aec','0ab076d1-06a2-449d-ad12-dd8cc5ccc533',221,'b08d95dfcf5049b89d93e68ea13452d2','gigabytes',-1,'2025-12-05 10:47:43',NULL),('2025-12-04 10:47:43.918114',NULL,'2025-12-04 10:47:43.926314',837,837,NULL,'03834c7f-183b-4165-8bc3-3044f68fdf3f',224,'b08d95dfcf5049b89d93e68ea13452d2','shares',-1,'2025-12-05 10:47:43','7e2e54b3-9fc4-42f1-9682-dfd37ababbc9'),('2025-12-04 10:47:43.918796',NULL,'2025-12-04 10:47:43.926314',838,838,NULL,'471c50f2-2070-4230-ab75-07430b2dd359',223,'b08d95dfcf5049b89d93e68ea13452d2','gigabytes',-1,'2025-12-05 10:47:43','7e2e54b3-9fc4-42f1-9682-dfd37ababbc9'),('2025-12-04 10:47:53.647622',NULL,'2025-12-04 10:47:53.687161',839,839,'832dabe00e054a2db2a663d3bafcdafd','2b017b1a-ad91-410c-9fba-8c14a847b131',232,'440666156b56403fabeabff6ee9b42d9','shares',1,'2025-12-05 10:47:53',NULL),('2025-12-04 10:47:53.649158',NULL,'2025-12-04 10:47:53.687161',840,840,'832dabe00e054a2db2a663d3bafcdafd','5fcfba18-5b12-4032-8a14-55cb7f59d548',231,'440666156b56403fabeabff6ee9b42d9','gigabytes',1,'2025-12-05 10:47:53',NULL),('2025-12-04 10:47:53.659489',NULL,'2025-12-04 10:47:53.687161',841,841,NULL,'0c1b18a8-cc3a-4aca-9275-f1c978e1a4e5',234,'440666156b56403fabeabff6ee9b42d9','shares',1,'2025-12-05 10:47:53','9f12719f-820d-45f8-8b37-c67efc69baf2'),('2025-12-04 10:47:53.661052',NULL,'2025-12-04 10:47:53.687161',842,842,NULL,'f1dbf5b1-aee4-4405-8b03-17b6d71ef8d8',233,'440666156b56403fabeabff6ee9b42d9','gigabytes',1,'2025-12-05 10:47:53','9f12719f-820d-45f8-8b37-c67efc69baf2'),('2025-12-04 10:47:55.448955',NULL,'2025-12-04 10:47:55.486520',843,843,'bd0c952b76bd4095a0ae18a8f5a049b2','9dba4259-09d5-43ca-bcf1-a80fb37ddb43',236,'063b90bfc86448709eb6958911a53f96','shares',1,'2025-12-05 10:47:55',NULL),('2025-12-04 10:47:55.450145',NULL,'2025-12-04 10:47:55.486520',844,844,'bd0c952b76bd4095a0ae18a8f5a049b2','2a0d6f50-a2b4-42c3-8ee2-74c7d6089af5',235,'063b90bfc86448709eb6958911a53f96','gigabytes',1,'2025-12-05 10:47:55',NULL),('2025-12-04 10:47:55.460050',NULL,'2025-12-04 10:47:55.486520',845,845,NULL,'4247fc5a-0c78-4be8-bd25-8562869c7a75',238,'063b90bfc86448709eb6958911a53f96','shares',1,'2025-12-05 10:47:55','c0d93c20-f27c-4fec-9d23-328c1d8e67c8'),('2025-12-04 10:47:55.461177',NULL,'2025-12-04 10:47:55.486520',846,846,NULL,'c0496f23-8c44-4a4d-a1d4-bb25550c0dc2',237,'063b90bfc86448709eb6958911a53f96','gigabytes',1,'2025-12-05 10:47:55','c0d93c20-f27c-4fec-9d23-328c1d8e67c8'),('2025-12-04 10:47:57.183220',NULL,'2025-12-04 10:47:57.291119',847,847,'832dabe00e054a2db2a663d3bafcdafd','8b00bd54-77f1-448e-b837-568cfdf60108',239,'440666156b56403fabeabff6ee9b42d9','snapshots',1,'2025-12-05 10:47:57',NULL),('2025-12-04 10:47:57.184467',NULL,'2025-12-04 10:47:57.291119',848,848,'832dabe00e054a2db2a663d3bafcdafd','040ff2b7-5671-48a9-b2fe-72b4d58c91a2',240,'440666156b56403fabeabff6ee9b42d9','snapshot_gigabytes',1,'2025-12-05 10:47:57',NULL),('2025-12-04 10:47:57.195349',NULL,'2025-12-04 10:47:57.291119',849,849,NULL,'4c715e2f-d43f-4fba-a8de-ecfb3b15bcb6',241,'440666156b56403fabeabff6ee9b42d9','snapshots',1,'2025-12-05 10:47:57','9f12719f-820d-45f8-8b37-c67efc69baf2'),('2025-12-04 10:47:57.196511',NULL,'2025-12-04 10:47:57.291119',850,850,NULL,'fdcca0e5-4504-421b-a20f-64e010ef319a',242,'440666156b56403fabeabff6ee9b42d9','snapshot_gigabytes',1,'2025-12-05 10:47:57','9f12719f-820d-45f8-8b37-c67efc69baf2'),('2025-12-04 10:47:58.826155',NULL,'2025-12-04 10:47:58.897023',851,851,'bd0c952b76bd4095a0ae18a8f5a049b2','85d1249d-a5ec-451a-90b2-34789b92e737',244,'063b90bfc86448709eb6958911a53f96','snapshots',1,'2025-12-05 10:47:58',NULL),('2025-12-04 10:47:58.827471',NULL,'2025-12-04 10:47:58.897023',852,852,'bd0c952b76bd4095a0ae18a8f5a049b2','1433449b-da44-49cd-ab34-47a101d6dbc2',243,'063b90bfc86448709eb6958911a53f96','snapshot_gigabytes',1,'2025-12-05 10:47:58',NULL),('2025-12-04 10:47:58.836859',NULL,'2025-12-04 10:47:58.897023',853,853,NULL,'e026869b-c55b-4f08-ba93-8d4b07a304bb',246,'063b90bfc86448709eb6958911a53f96','snapshots',1,'2025-12-05 10:47:58','c0d93c20-f27c-4fec-9d23-328c1d8e67c8'),('2025-12-04 10:47:58.837870',NULL,'2025-12-04 10:47:58.897023',854,854,NULL,'165aa2df-e37f-409b-acee-d91894ab1e8d',245,'063b90bfc86448709eb6958911a53f96','snapshot_gigabytes',1,'2025-12-05 10:47:58','c0d93c20-f27c-4fec-9d23-328c1d8e67c8'),('2025-12-04 10:48:02.213159',NULL,'2025-12-04 10:48:02.273898',855,855,'832dabe00e054a2db2a663d3bafcdafd','c8634591-a73a-4e64-9cb0-ba3fb88643b9',239,'440666156b56403fabeabff6ee9b42d9','snapshots',-1,'2025-12-05 10:48:02',NULL),('2025-12-04 10:48:02.214188',NULL,'2025-12-04 10:48:02.273898',856,856,'832dabe00e054a2db2a663d3bafcdafd','e4a2ebe1-c700-4622-9dfe-22c697db6277',240,'440666156b56403fabeabff6ee9b42d9','snapshot_gigabytes',-1,'2025-12-05 10:48:02',NULL),('2025-12-04 10:48:02.249241',NULL,'2025-12-04 10:48:02.273898',857,857,NULL,'4ec5eb38-2167-4aef-a6ce-285c9bcd2a06',241,'440666156b56403fabeabff6ee9b42d9','snapshots',-1,'2025-12-05 10:48:02','9f12719f-820d-45f8-8b37-c67efc69baf2'),('2025-12-04 10:48:02.250255',NULL,'2025-12-04 10:48:02.273898',858,858,NULL,'6900b54b-4092-4d21-86ca-29bb0805bcf6',242,'440666156b56403fabeabff6ee9b42d9','snapshot_gigabytes',-1,'2025-12-05 10:48:02','9f12719f-820d-45f8-8b37-c67efc69baf2'),('2025-12-04 10:48:03.819223',NULL,'2025-12-04 10:48:03.840060',859,859,'bd0c952b76bd4095a0ae18a8f5a049b2','0de951cc-7eb9-4e04-b1c2-dbbb6ede9863',244,'063b90bfc86448709eb6958911a53f96','snapshots',-1,'2025-12-05 10:48:03',NULL),('2025-12-04 10:48:03.820050',NULL,'2025-12-04 10:48:03.840060',860,860,'bd0c952b76bd4095a0ae18a8f5a049b2','de033642-17ed-459a-bc48-df7bfafa1284',243,'063b90bfc86448709eb6958911a53f96','snapshot_gigabytes',-1,'2025-12-05 10:48:03',NULL),('2025-12-04 10:48:03.829014',NULL,'2025-12-04 10:48:03.840060',861,861,NULL,'f6c903a4-cf40-4b7b-a59b-aef475bce9da',246,'063b90bfc86448709eb6958911a53f96','snapshots',-1,'2025-12-05 10:48:03','c0d93c20-f27c-4fec-9d23-328c1d8e67c8'),('2025-12-04 10:48:03.829769',NULL,'2025-12-04 10:48:03.840060',862,862,NULL,'3ee9f43d-8423-407b-b34c-d6571f757a1a',245,'063b90bfc86448709eb6958911a53f96','snapshot_gigabytes',-1,'2025-12-05 10:48:03','c0d93c20-f27c-4fec-9d23-328c1d8e67c8'),('2025-12-04 10:48:05.620799',NULL,'2025-12-04 10:48:05.643533',863,863,'832dabe00e054a2db2a663d3bafcdafd','b5b78c51-23e2-438b-a292-faaf46b5524e',232,'440666156b56403fabeabff6ee9b42d9','shares',-1,'2025-12-05 10:48:05',NULL),('2025-12-04 10:48:05.622182',NULL,'2025-12-04 10:48:05.643533',864,864,'832dabe00e054a2db2a663d3bafcdafd','12cd6fe7-9353-47f6-bb56-a4c7fa878d16',231,'440666156b56403fabeabff6ee9b42d9','gigabytes',-1,'2025-12-05 10:48:05',NULL),('2025-12-04 10:48:05.633113',NULL,'2025-12-04 10:48:05.643533',865,865,NULL,'0711e59c-ce91-4732-bce5-513f2869c1a5',234,'440666156b56403fabeabff6ee9b42d9','shares',-1,'2025-12-05 10:48:05','9f12719f-820d-45f8-8b37-c67efc69baf2'),('2025-12-04 10:48:05.633963',NULL,'2025-12-04 10:48:05.643533',866,866,NULL,'f110380e-8db4-4f5e-8dc5-22a21ff24e62',233,'440666156b56403fabeabff6ee9b42d9','gigabytes',-1,'2025-12-05 10:48:05','9f12719f-820d-45f8-8b37-c67efc69baf2'),('2025-12-04 10:48:07.223961',NULL,'2025-12-04 10:48:07.239598',867,867,'bd0c952b76bd4095a0ae18a8f5a049b2','fb118d3b-d722-4a2a-917f-51aa34954d0a',236,'063b90bfc86448709eb6958911a53f96','shares',-1,'2025-12-05 10:48:07',NULL),('2025-12-04 10:48:07.224957',NULL,'2025-12-04 10:48:07.239598',868,868,'bd0c952b76bd4095a0ae18a8f5a049b2','ba5a1e64-1eda-4dfa-86bf-a2bb021a3528',235,'063b90bfc86448709eb6958911a53f96','gigabytes',-1,'2025-12-05 10:48:07',NULL),('2025-12-04 10:48:07.230277',NULL,'2025-12-04 10:48:07.239598',869,869,NULL,'b0385ce2-6bb3-4063-a479-80b9f8790cb9',238,'063b90bfc86448709eb6958911a53f96','shares',-1,'2025-12-05 10:48:07','c0d93c20-f27c-4fec-9d23-328c1d8e67c8'),('2025-12-04 10:48:07.231028',NULL,'2025-12-04 10:48:07.239598',870,870,NULL,'69c4982d-1c8d-461d-8f58-c96955427f26',237,'063b90bfc86448709eb6958911a53f96','gigabytes',-1,'2025-12-05 10:48:07','c0d93c20-f27c-4fec-9d23-328c1d8e67c8'),('2025-12-04 10:48:24.844451',NULL,'2025-12-04 10:48:24.882742',871,871,'de4db57a4dde458ca59ef1effab03d64','529be977-fd56-44b5-a5f9-bd86b69db931',247,'d7b71786426443df9d7260a4c1f1ebd1','share_networks',1,'2025-12-05 10:48:24',NULL),('2025-12-04 10:48:54.412257',NULL,'2025-12-04 10:48:54.462810',872,872,'a7cbfaccac8f48c1bc69fb83640618a5','f074210e-2f20-46bc-8e1e-4fc9b8b657a9',249,'2c40fb2875304a41b2368725937fd373','shares',1,'2025-12-05 10:48:54',NULL),('2025-12-04 10:48:54.413600',NULL,'2025-12-04 10:48:54.462810',873,873,'a7cbfaccac8f48c1bc69fb83640618a5','6163e819-c5d6-4716-987b-073db14f34d6',248,'2c40fb2875304a41b2368725937fd373','gigabytes',1,'2025-12-05 10:48:54',NULL),('2025-12-04 10:48:54.427174',NULL,'2025-12-04 10:48:54.462810',874,874,NULL,'d20e0999-a324-45ae-868f-7bac514c2d19',251,'2c40fb2875304a41b2368725937fd373','shares',1,'2025-12-05 10:48:54','067e02e9-90fb-47d1-be2d-f4ea7d81904d'),('2025-12-04 10:48:54.429221',NULL,'2025-12-04 10:48:54.462810',875,875,NULL,'585b7854-aa41-47fa-b7fc-5995d84ebef2',250,'2c40fb2875304a41b2368725937fd373','gigabytes',1,'2025-12-05 10:48:54','067e02e9-90fb-47d1-be2d-f4ea7d81904d'),('2025-12-04 10:48:57.850742',NULL,'2025-12-04 10:48:58.014686',876,876,'a7cbfaccac8f48c1bc69fb83640618a5','626dc475-33fb-4470-bd70-c6d1771f11ab',252,'2c40fb2875304a41b2368725937fd373','snapshots',1,'2025-12-05 10:48:57',NULL),('2025-12-04 10:48:57.853734',NULL,'2025-12-04 10:48:58.014686',877,877,'a7cbfaccac8f48c1bc69fb83640618a5','50b05001-716a-45d2-ad05-f74a7d0fb5b2',253,'2c40fb2875304a41b2368725937fd373','snapshot_gigabytes',1,'2025-12-05 10:48:57',NULL),('2025-12-04 10:48:57.914232',NULL,'2025-12-04 10:48:58.014686',878,878,NULL,'799a3037-20d0-4eb3-9628-eb0a7639465f',254,'2c40fb2875304a41b2368725937fd373','snapshots',1,'2025-12-05 10:48:57','067e02e9-90fb-47d1-be2d-f4ea7d81904d'),('2025-12-04 10:48:57.915414',NULL,'2025-12-04 10:48:58.014686',879,879,NULL,'f3425b39-12ce-4d96-a2ad-1733e45f5975',255,'2c40fb2875304a41b2368725937fd373','snapshot_gigabytes',1,'2025-12-05 10:48:57','067e02e9-90fb-47d1-be2d-f4ea7d81904d'),('2025-12-04 10:49:01.838567',NULL,'2025-12-04 10:49:01.857472',880,880,'a7cbfaccac8f48c1bc69fb83640618a5','554f4ad1-9402-4c12-a069-77d3d08d2ab1',252,'2c40fb2875304a41b2368725937fd373','snapshots',-1,'2025-12-05 10:49:01',NULL),('2025-12-04 10:49:01.839446',NULL,'2025-12-04 10:49:01.857472',881,881,'a7cbfaccac8f48c1bc69fb83640618a5','07e77974-fb6a-4773-ad0f-575e9bd2e1f4',253,'2c40fb2875304a41b2368725937fd373','snapshot_gigabytes',-1,'2025-12-05 10:49:01',NULL),('2025-12-04 10:49:01.847527',NULL,'2025-12-04 10:49:01.857472',882,882,NULL,'40bddfc4-8d1b-48b7-a523-f686485f6744',254,'2c40fb2875304a41b2368725937fd373','snapshots',-1,'2025-12-05 10:49:01','067e02e9-90fb-47d1-be2d-f4ea7d81904d'),('2025-12-04 10:49:01.848421',NULL,'2025-12-04 10:49:01.857472',883,883,NULL,'a50aeb58-31b0-4419-8c33-69a38d6fe35a',255,'2c40fb2875304a41b2368725937fd373','snapshot_gigabytes',-1,'2025-12-05 10:49:01','067e02e9-90fb-47d1-be2d-f4ea7d81904d'),('2025-12-04 10:49:05.520798',NULL,'2025-12-04 10:49:05.534124',884,884,'a7cbfaccac8f48c1bc69fb83640618a5','a071982c-bead-438e-a00c-e2531e2f66d1',249,'2c40fb2875304a41b2368725937fd373','shares',-1,'2025-12-05 10:49:05',NULL),('2025-12-04 10:49:05.521616',NULL,'2025-12-04 10:49:05.534124',885,885,'a7cbfaccac8f48c1bc69fb83640618a5','91d1cd29-a51c-4a00-a3de-9b8e53e290b6',248,'2c40fb2875304a41b2368725937fd373','gigabytes',-1,'2025-12-05 10:49:05',NULL),('2025-12-04 10:49:05.526360',NULL,'2025-12-04 10:49:05.534124',886,886,NULL,'e3e406e1-a930-490e-aefd-e004ef31adfc',251,'2c40fb2875304a41b2368725937fd373','shares',-1,'2025-12-05 10:49:05','067e02e9-90fb-47d1-be2d-f4ea7d81904d'),('2025-12-04 10:49:05.527064',NULL,'2025-12-04 10:49:05.534124',887,887,NULL,'49ec4ed0-d0dc-446d-9341-07d6f38adf31',250,'2c40fb2875304a41b2368725937fd373','gigabytes',-1,'2025-12-05 10:49:05','067e02e9-90fb-47d1-be2d-f4ea7d81904d'),('2025-12-04 10:49:08.753663',NULL,'2025-12-04 10:49:08.833596',888,888,'a7cbfaccac8f48c1bc69fb83640618a5','1587f3ea-117c-4b13-843f-f5effabbfba8',249,'2c40fb2875304a41b2368725937fd373','shares',1,'2025-12-05 10:49:08',NULL),('2025-12-04 10:49:08.756884',NULL,'2025-12-04 10:49:08.833596',889,889,'a7cbfaccac8f48c1bc69fb83640618a5','0ef56fe1-8690-4879-b6a4-60c8b778edec',248,'2c40fb2875304a41b2368725937fd373','gigabytes',1,'2025-12-05 10:49:08',NULL),('2025-12-04 10:49:08.788740',NULL,'2025-12-04 10:49:08.833596',890,890,NULL,'78b584e6-95ca-462f-b7f8-8d2300e07778',257,'2c40fb2875304a41b2368725937fd373','shares',1,'2025-12-05 10:49:08','8446d21c-69f2-4851-933b-997effa49241'),('2025-12-04 10:49:08.790143',NULL,'2025-12-04 10:49:08.833596',891,891,NULL,'a06c4ff7-d1aa-4bb2-aa98-7d11a7330f22',256,'2c40fb2875304a41b2368725937fd373','gigabytes',1,'2025-12-05 10:49:08','8446d21c-69f2-4851-933b-997effa49241'),('2025-12-04 10:49:12.802894',NULL,'2025-12-04 10:49:12.848433',892,892,'a7cbfaccac8f48c1bc69fb83640618a5','12660c66-7f01-424f-bd97-a592e9f9771b',249,'2c40fb2875304a41b2368725937fd373','shares',-1,'2025-12-05 10:49:12',NULL),('2025-12-04 10:49:12.803704',NULL,'2025-12-04 10:49:12.848433',893,893,'a7cbfaccac8f48c1bc69fb83640618a5','606ca1f0-ae37-4705-af7a-9a45ae58d06e',248,'2c40fb2875304a41b2368725937fd373','gigabytes',-1,'2025-12-05 10:49:12',NULL),('2025-12-04 10:49:12.840570',NULL,'2025-12-04 10:49:12.848433',894,894,NULL,'4fa4b9b2-040e-4500-8c6f-a04630953767',257,'2c40fb2875304a41b2368725937fd373','shares',-1,'2025-12-05 10:49:12','8446d21c-69f2-4851-933b-997effa49241'),('2025-12-04 10:49:12.841331',NULL,'2025-12-04 10:49:12.848433',895,895,NULL,'320464c3-31a1-4589-add1-d7d682f85a6f',256,'2c40fb2875304a41b2368725937fd373','gigabytes',-1,'2025-12-05 10:49:12','8446d21c-69f2-4851-933b-997effa49241'),('2025-12-04 10:49:15.881179',NULL,'2025-12-04 10:49:15.924281',896,896,'a7cbfaccac8f48c1bc69fb83640618a5','ab279d28-c79e-4a87-ac84-6ef141fc0b10',249,'2c40fb2875304a41b2368725937fd373','shares',1,'2025-12-05 10:49:15',NULL),('2025-12-04 10:49:15.882520',NULL,'2025-12-04 10:49:15.924281',897,897,'a7cbfaccac8f48c1bc69fb83640618a5','70477fa6-5db8-436d-97f4-a867c9d7fb38',248,'2c40fb2875304a41b2368725937fd373','gigabytes',1,'2025-12-05 10:49:15',NULL),('2025-12-04 10:49:15.893513',NULL,'2025-12-04 10:49:15.924281',898,898,NULL,'41302a0a-4aca-4307-b0d0-e4fb7b6b88c9',258,'2c40fb2875304a41b2368725937fd373','shares',1,'2025-12-05 10:49:15','83cb9767-1df4-4921-a073-4398082b463f'),('2025-12-04 10:49:15.894812',NULL,'2025-12-04 10:49:15.924281',899,899,NULL,'3c240e16-0c58-4ed8-8105-6c686aa9d878',259,'2c40fb2875304a41b2368725937fd373','gigabytes',1,'2025-12-05 10:49:15','83cb9767-1df4-4921-a073-4398082b463f'),('2025-12-04 10:49:19.300156',NULL,'2025-12-04 10:49:19.416427',900,900,'a7cbfaccac8f48c1bc69fb83640618a5','08787df8-bd40-42bf-ba8f-2fa9a4739b22',252,'2c40fb2875304a41b2368725937fd373','snapshots',1,'2025-12-05 10:49:19',NULL),('2025-12-04 10:49:19.301349',NULL,'2025-12-04 10:49:19.416427',901,901,'a7cbfaccac8f48c1bc69fb83640618a5','8c1b3e9b-7ab8-44a7-af2d-3406452f400c',253,'2c40fb2875304a41b2368725937fd373','snapshot_gigabytes',1,'2025-12-05 10:49:19',NULL),('2025-12-04 10:49:19.314965',NULL,'2025-12-04 10:49:19.416427',902,902,NULL,'7135fed6-e027-4086-9fe0-241cc66ff46c',260,'2c40fb2875304a41b2368725937fd373','snapshots',1,'2025-12-05 10:49:19','83cb9767-1df4-4921-a073-4398082b463f'),('2025-12-04 10:49:19.316280',NULL,'2025-12-04 10:49:19.416427',903,903,NULL,'7ecc0b76-c26b-4d85-8fa7-d5c715ec1672',261,'2c40fb2875304a41b2368725937fd373','snapshot_gigabytes',1,'2025-12-05 10:49:19','83cb9767-1df4-4921-a073-4398082b463f'),('2025-12-04 10:49:22.917409',NULL,'2025-12-04 10:49:22.964633',904,904,'a7cbfaccac8f48c1bc69fb83640618a5','2e4861ab-62e9-46c0-87a6-d38edb431aea',249,'2c40fb2875304a41b2368725937fd373','shares',1,'2025-12-05 10:49:22',NULL),('2025-12-04 10:49:22.918992',NULL,'2025-12-04 10:49:22.964633',905,905,'a7cbfaccac8f48c1bc69fb83640618a5','38e6f769-b531-4c95-a438-8812f8dce6e2',248,'2c40fb2875304a41b2368725937fd373','gigabytes',1,'2025-12-05 10:49:22',NULL),('2025-12-04 10:49:22.933033',NULL,'2025-12-04 10:49:22.964633',906,906,NULL,'f323b01c-bf15-4ffa-ade8-1ab870607acb',258,'2c40fb2875304a41b2368725937fd373','shares',1,'2025-12-05 10:49:22','83cb9767-1df4-4921-a073-4398082b463f'),('2025-12-04 10:49:22.934301',NULL,'2025-12-04 10:49:22.964633',907,907,NULL,'8afdc8cd-dfff-423e-b0ab-f0f984e4f650',259,'2c40fb2875304a41b2368725937fd373','gigabytes',1,'2025-12-05 10:49:22','83cb9767-1df4-4921-a073-4398082b463f'),('2025-12-04 10:50:29.352827',NULL,'2025-12-04 10:50:29.396718',908,908,'a7cbfaccac8f48c1bc69fb83640618a5','9545efdc-1706-4203-95a5-c49a4a063471',249,'2c40fb2875304a41b2368725937fd373','shares',-1,'2025-12-05 10:50:29',NULL),('2025-12-04 10:50:29.353640',NULL,'2025-12-04 10:50:29.396718',909,909,'a7cbfaccac8f48c1bc69fb83640618a5','0f2cac88-baea-40ab-be22-e1a3109ec98f',248,'2c40fb2875304a41b2368725937fd373','gigabytes',-1,'2025-12-05 10:50:29',NULL),('2025-12-04 10:50:29.387538',NULL,'2025-12-04 10:50:29.396718',910,910,NULL,'764a755a-9c10-40d7-a33a-e4b533b78154',258,'2c40fb2875304a41b2368725937fd373','shares',-1,'2025-12-05 10:50:29','83cb9767-1df4-4921-a073-4398082b463f'),('2025-12-04 10:50:29.388391',NULL,'2025-12-04 10:50:29.396718',911,911,NULL,'91776d4a-ee5b-49d3-9e0e-4f2122904558',259,'2c40fb2875304a41b2368725937fd373','gigabytes',-1,'2025-12-05 10:50:29','83cb9767-1df4-4921-a073-4398082b463f'),('2025-12-04 10:50:32.214045',NULL,'2025-12-04 10:50:32.240146',912,912,'a7cbfaccac8f48c1bc69fb83640618a5','117dabce-1fee-48cb-bc7c-693073b9ec08',252,'2c40fb2875304a41b2368725937fd373','snapshots',-1,'2025-12-05 10:50:32',NULL),('2025-12-04 10:50:32.214754',NULL,'2025-12-04 10:50:32.240146',913,913,'a7cbfaccac8f48c1bc69fb83640618a5','d1a12b71-9ca4-4532-9509-d1f78b8013dc',253,'2c40fb2875304a41b2368725937fd373','snapshot_gigabytes',-1,'2025-12-05 10:50:32',NULL),('2025-12-04 10:50:32.220415',NULL,'2025-12-04 10:50:32.240146',914,914,NULL,'65cb12e9-fe97-4cc3-bea4-fedd85b69633',260,'2c40fb2875304a41b2368725937fd373','snapshots',-1,'2025-12-05 10:50:32','83cb9767-1df4-4921-a073-4398082b463f'),('2025-12-04 10:50:32.221116',NULL,'2025-12-04 10:50:32.240146',915,915,NULL,'0725e01e-8379-4298-8228-f68115bc92d5',261,'2c40fb2875304a41b2368725937fd373','snapshot_gigabytes',-1,'2025-12-05 10:50:32','83cb9767-1df4-4921-a073-4398082b463f'),('2025-12-04 10:50:35.627952',NULL,'2025-12-04 10:50:35.682233',916,916,'a7cbfaccac8f48c1bc69fb83640618a5','70aa523a-dcf1-4250-88cc-cfcce9bcdccc',249,'2c40fb2875304a41b2368725937fd373','shares',-1,'2025-12-05 10:50:35',NULL),('2025-12-04 10:50:35.629019',NULL,'2025-12-04 10:50:35.682233',917,917,'a7cbfaccac8f48c1bc69fb83640618a5','df1b9249-b758-4541-b56f-186781414050',248,'2c40fb2875304a41b2368725937fd373','gigabytes',-1,'2025-12-05 10:50:35',NULL),('2025-12-04 10:50:35.668425',NULL,'2025-12-04 10:50:35.682233',918,918,NULL,'2915c19c-458e-4294-8d6d-a08041420e1a',258,'2c40fb2875304a41b2368725937fd373','shares',-1,'2025-12-05 10:50:35','83cb9767-1df4-4921-a073-4398082b463f'),('2025-12-04 10:50:35.669831',NULL,'2025-12-04 10:50:35.682233',919,919,NULL,'2edc9deb-231b-488b-ad02-4721c9a2f9c9',259,'2c40fb2875304a41b2368725937fd373','gigabytes',-1,'2025-12-05 10:50:35','83cb9767-1df4-4921-a073-4398082b463f'),('2025-12-04 10:50:50.120307',NULL,'2025-12-04 10:50:50.254543',920,920,'e318249fe70a4240a4a0e7ebc5c47a65','8b20cfdb-4bfc-4675-b6bf-34db06442695',262,'c3ea6486309b4dab9bf9d14f604bdce4','shares',1,'2025-12-05 10:50:50',NULL),('2025-12-04 10:50:50.121743',NULL,'2025-12-04 10:50:50.254543',921,921,'e318249fe70a4240a4a0e7ebc5c47a65','4691827d-7ec7-45d9-aab7-2133fa8744b5',263,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',1,'2025-12-05 10:50:50',NULL),('2025-12-04 10:50:50.154193',NULL,'2025-12-04 10:50:50.254543',922,922,NULL,'96ff14e2-adc7-44a4-862b-ee76e2a61270',264,'c3ea6486309b4dab9bf9d14f604bdce4','shares',1,'2025-12-05 10:50:50','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:50:50.155903',NULL,'2025-12-04 10:50:50.254543',923,923,NULL,'9cde438f-ed28-4d08-8e61-513d981001c9',265,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',1,'2025-12-05 10:50:50','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:50:53.574318',NULL,'2025-12-04 10:50:53.650375',924,924,'e318249fe70a4240a4a0e7ebc5c47a65','038ce249-8dd3-4508-8488-0ba24073d127',266,'c3ea6486309b4dab9bf9d14f604bdce4','snapshots',1,'2025-12-05 10:50:53',NULL),('2025-12-04 10:50:53.575431',NULL,'2025-12-04 10:50:53.650375',925,925,'e318249fe70a4240a4a0e7ebc5c47a65','f55d1862-e004-4665-9323-df6354303500',267,'c3ea6486309b4dab9bf9d14f604bdce4','snapshot_gigabytes',1,'2025-12-05 10:50:53',NULL),('2025-12-04 10:50:53.586425',NULL,'2025-12-04 10:50:53.650375',926,926,NULL,'f4995036-4ba8-4d0e-85bd-ddaeadb2dab1',268,'c3ea6486309b4dab9bf9d14f604bdce4','snapshots',1,'2025-12-05 10:50:53','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:50:53.587426',NULL,'2025-12-04 10:50:53.650375',927,927,NULL,'450ad23a-4ce7-4848-8096-6d0159f33588',269,'c3ea6486309b4dab9bf9d14f604bdce4','snapshot_gigabytes',1,'2025-12-05 10:50:53','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:50:57.995727',NULL,'2025-12-04 10:50:58.034508',928,928,'e318249fe70a4240a4a0e7ebc5c47a65','5d9a44e9-b1da-433f-9c71-f70cf25c1e0c',262,'c3ea6486309b4dab9bf9d14f604bdce4','shares',1,'2025-12-05 10:50:57',NULL),('2025-12-04 10:50:57.996870',NULL,'2025-12-04 10:50:58.034508',929,929,'e318249fe70a4240a4a0e7ebc5c47a65','6880210b-fd4f-4b4f-850b-4aabd3f0fcea',263,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',1,'2025-12-05 10:50:57',NULL),('2025-12-04 10:50:58.007034',NULL,'2025-12-04 10:50:58.034508',930,930,NULL,'3eac17f0-253a-43fd-9bae-66851b13be0e',264,'c3ea6486309b4dab9bf9d14f604bdce4','shares',1,'2025-12-05 10:50:57','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:50:58.008220',NULL,'2025-12-04 10:50:58.034508',931,931,NULL,'a465556a-4d54-458e-8ce9-2246b2c06cb5',265,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',1,'2025-12-05 10:50:57','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:51:02.124157',NULL,'2025-12-04 10:51:02.191439',932,932,'e318249fe70a4240a4a0e7ebc5c47a65','6e4e7898-4b6a-48b2-a245-95ff342e41f9',262,'c3ea6486309b4dab9bf9d14f604bdce4','shares',-1,'2025-12-05 10:51:02',NULL),('2025-12-04 10:51:02.124984',NULL,'2025-12-04 10:51:02.191439',933,933,'e318249fe70a4240a4a0e7ebc5c47a65','7e7928a2-d757-4696-ac5c-b5ada8fd5ee1',263,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',-1,'2025-12-05 10:51:02',NULL),('2025-12-04 10:51:02.139773',NULL,'2025-12-04 10:51:02.191439',934,934,NULL,'261c282a-efec-40e4-b767-82c83c446108',264,'c3ea6486309b4dab9bf9d14f604bdce4','shares',-1,'2025-12-05 10:51:02','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:51:02.140483',NULL,'2025-12-04 10:51:02.191439',935,935,NULL,'c2191d76-7027-4602-9c8b-d83ffd778ef1',265,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',-1,'2025-12-05 10:51:02','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:51:05.369755',NULL,'2025-12-04 10:51:05.631564',936,936,'e318249fe70a4240a4a0e7ebc5c47a65','88a1a911-856f-4562-9fa7-4c5b826f1e2e',262,'c3ea6486309b4dab9bf9d14f604bdce4','shares',1,'2025-12-05 10:51:05',NULL),('2025-12-04 10:51:05.371214',NULL,'2025-12-04 10:51:05.631564',937,937,'e318249fe70a4240a4a0e7ebc5c47a65','f8b2aadc-f186-4c92-9679-8c18e7e05bea',263,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',2,'2025-12-05 10:51:05',NULL),('2025-12-04 10:51:05.456173',NULL,'2025-12-04 10:51:05.631564',938,938,NULL,'f6cb601b-ee8f-4df3-b3f7-08849ff08835',264,'c3ea6486309b4dab9bf9d14f604bdce4','shares',1,'2025-12-05 10:51:05','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:51:05.458138',NULL,'2025-12-04 10:51:05.631564',939,939,NULL,'f2b5f852-0501-4476-b770-714556a4396a',265,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',2,'2025-12-05 10:51:05','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:51:09.795468',NULL,'2025-12-04 10:51:09.906999',940,940,'e318249fe70a4240a4a0e7ebc5c47a65','fbe9e3f8-6861-4aad-b8f7-c6767ccdd021',262,'c3ea6486309b4dab9bf9d14f604bdce4','shares',-1,'2025-12-05 10:51:09',NULL),('2025-12-04 10:51:09.796150',NULL,'2025-12-04 10:51:09.906999',941,941,'e318249fe70a4240a4a0e7ebc5c47a65','12b15fec-9a1c-46bf-b6ba-c9c6b608150e',263,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',-2,'2025-12-05 10:51:09',NULL),('2025-12-04 10:51:09.825001',NULL,'2025-12-04 10:51:09.906999',942,942,NULL,'c370592f-03a2-439a-bc96-a826589402a7',264,'c3ea6486309b4dab9bf9d14f604bdce4','shares',-1,'2025-12-05 10:51:09','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:51:09.825850',NULL,'2025-12-04 10:51:09.906999',943,943,NULL,'b57373a2-9cc9-46d6-afdc-e97ae5f2ec93',265,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',-2,'2025-12-05 10:51:09','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:51:12.803297',NULL,'2025-12-04 10:51:12.834842',944,944,'e318249fe70a4240a4a0e7ebc5c47a65','623d1e9f-346b-4dfb-9d4f-3d923add9fe8',262,'c3ea6486309b4dab9bf9d14f604bdce4','shares',1,'2025-12-05 10:51:12',NULL),('2025-12-04 10:51:12.804494',NULL,'2025-12-04 10:51:12.834842',945,945,'e318249fe70a4240a4a0e7ebc5c47a65','e40bb728-eb3d-4031-abcf-0f75f1f84692',263,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',1,'2025-12-05 10:51:12',NULL),('2025-12-04 10:51:12.812126',NULL,'2025-12-04 10:51:12.834842',946,946,NULL,'c7ad6cd1-3b4a-4a81-bb0b-f44e3772cb20',264,'c3ea6486309b4dab9bf9d14f604bdce4','shares',1,'2025-12-05 10:51:12','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:51:12.813125',NULL,'2025-12-04 10:51:12.834842',947,947,NULL,'4bcedef6-edbc-4abd-a2a7-b14e42927f40',265,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',1,'2025-12-05 10:51:12','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:51:16.472567',NULL,'2025-12-04 10:51:16.486012',948,948,'e318249fe70a4240a4a0e7ebc5c47a65','0457306b-dcf1-4b6b-a15e-29d53295f6a0',262,'c3ea6486309b4dab9bf9d14f604bdce4','shares',-1,'2025-12-05 10:51:16',NULL),('2025-12-04 10:51:16.473304',NULL,'2025-12-04 10:51:16.486012',949,949,'e318249fe70a4240a4a0e7ebc5c47a65','41c51ebe-2c03-48ef-a1f2-f46a31e21925',263,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',-1,'2025-12-05 10:51:16',NULL),('2025-12-04 10:51:16.478561',NULL,'2025-12-04 10:51:16.486012',950,950,NULL,'980e277d-e02d-40eb-bbfa-ff113eff0785',264,'c3ea6486309b4dab9bf9d14f604bdce4','shares',-1,'2025-12-05 10:51:16','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:51:16.479203',NULL,'2025-12-04 10:51:16.486012',951,951,NULL,'fb24acfb-2c83-4aa7-9b32-b3116e4a2ffd',265,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',-1,'2025-12-05 10:51:16','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:51:19.530561',NULL,'2025-12-04 10:51:19.583640',952,952,'e318249fe70a4240a4a0e7ebc5c47a65','cfed3d44-4cce-499b-99c9-be67d52378c3',262,'c3ea6486309b4dab9bf9d14f604bdce4','shares',1,'2025-12-05 10:51:19',NULL),('2025-12-04 10:51:19.531790',NULL,'2025-12-04 10:51:19.583640',953,953,'e318249fe70a4240a4a0e7ebc5c47a65','785e900b-7cee-48f6-af61-378eafb7d2c0',263,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',1,'2025-12-05 10:51:19',NULL),('2025-12-04 10:51:19.541725',NULL,'2025-12-04 10:51:19.583640',954,954,NULL,'c15fec90-8a45-4c91-ac08-0f708e382ab7',264,'c3ea6486309b4dab9bf9d14f604bdce4','shares',1,'2025-12-05 10:51:19','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:51:19.542818',NULL,'2025-12-04 10:51:19.583640',955,955,NULL,'051eeb64-38cf-4f99-b84e-34d49754abde',265,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',1,'2025-12-05 10:51:19','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:51:23.576826',NULL,'2025-12-04 10:51:23.617116',956,956,'e318249fe70a4240a4a0e7ebc5c47a65','d5d712aa-bb2a-43d8-ace6-74b1e05c3112',262,'c3ea6486309b4dab9bf9d14f604bdce4','shares',-1,'2025-12-05 10:51:23',NULL),('2025-12-04 10:51:23.577674',NULL,'2025-12-04 10:51:23.617116',957,957,'e318249fe70a4240a4a0e7ebc5c47a65','95af2b0f-0599-4ce3-ac62-dd7fb131f7a5',263,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',-1,'2025-12-05 10:51:23',NULL),('2025-12-04 10:51:23.585346',NULL,'2025-12-04 10:51:23.617116',958,958,NULL,'e3f269b0-7b52-445e-8f45-3235158d8b1f',264,'c3ea6486309b4dab9bf9d14f604bdce4','shares',-1,'2025-12-05 10:51:23','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:51:23.586108',NULL,'2025-12-04 10:51:23.617116',959,959,NULL,'e7d7f0a2-e4e0-4538-801a-913ed753788e',265,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',-1,'2025-12-05 10:51:23','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:51:26.637790',NULL,'2025-12-04 10:51:26.844729',960,960,'e318249fe70a4240a4a0e7ebc5c47a65','bcf8ea21-de1b-4bf3-a26c-4304d7462051',262,'c3ea6486309b4dab9bf9d14f604bdce4','shares',1,'2025-12-05 10:51:26',NULL),('2025-12-04 10:51:26.639259',NULL,'2025-12-04 10:51:26.844729',961,961,'e318249fe70a4240a4a0e7ebc5c47a65','d0933f99-83a3-47f8-aab2-cabbe3376691',263,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',1,'2025-12-05 10:51:26',NULL),('2025-12-04 10:51:26.706276',NULL,'2025-12-04 10:51:26.844729',962,962,NULL,'703d7217-b2ce-4169-9636-fe1502e50032',264,'c3ea6486309b4dab9bf9d14f604bdce4','shares',1,'2025-12-05 10:51:26','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:51:26.708953',NULL,'2025-12-04 10:51:26.844729',963,963,NULL,'79a1ece2-c28c-4690-a7ea-cb0191efe05a',265,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',1,'2025-12-05 10:51:26','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:51:30.783143',NULL,'2025-12-04 10:51:30.798081',964,964,'e318249fe70a4240a4a0e7ebc5c47a65','682803e7-3b4a-4308-8fc5-9c303ab5eb4b',262,'c3ea6486309b4dab9bf9d14f604bdce4','shares',-1,'2025-12-05 10:51:30',NULL),('2025-12-04 10:51:30.783872',NULL,'2025-12-04 10:51:30.798081',965,965,'e318249fe70a4240a4a0e7ebc5c47a65','69244a67-01f9-45d8-aad7-f07aa2d0a925',263,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',-1,'2025-12-05 10:51:30',NULL),('2025-12-04 10:51:30.789828',NULL,'2025-12-04 10:51:30.798081',966,966,NULL,'8cda1be4-7889-46c7-b089-0d7c7cd19b20',264,'c3ea6486309b4dab9bf9d14f604bdce4','shares',-1,'2025-12-05 10:51:30','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:51:30.790644',NULL,'2025-12-04 10:51:30.798081',967,967,NULL,'8c234c27-1946-4235-bf9b-973316d9a7c8',265,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',-1,'2025-12-05 10:51:30','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:51:35.620322',NULL,'2025-12-04 10:51:35.642960',968,968,'e318249fe70a4240a4a0e7ebc5c47a65','fea32aae-4c37-4e1f-8113-a742f9c9321e',266,'c3ea6486309b4dab9bf9d14f604bdce4','snapshots',-1,'2025-12-05 10:51:35',NULL),('2025-12-04 10:51:35.621169',NULL,'2025-12-04 10:51:35.642960',969,969,'e318249fe70a4240a4a0e7ebc5c47a65','aa495b26-a2cb-4288-885f-957576871f31',267,'c3ea6486309b4dab9bf9d14f604bdce4','snapshot_gigabytes',-1,'2025-12-05 10:51:35',NULL),('2025-12-04 10:51:35.630411',NULL,'2025-12-04 10:51:35.642960',970,970,NULL,'7f84af29-783b-401b-8148-9cb95f8fe8fe',268,'c3ea6486309b4dab9bf9d14f604bdce4','snapshots',-1,'2025-12-05 10:51:35','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:51:35.632027',NULL,'2025-12-04 10:51:35.642960',971,971,NULL,'52653b69-8321-454b-8bc6-54d721b18e9d',269,'c3ea6486309b4dab9bf9d14f604bdce4','snapshot_gigabytes',-1,'2025-12-05 10:51:35','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:51:38.367950',NULL,'2025-12-04 10:51:38.383046',972,972,'e318249fe70a4240a4a0e7ebc5c47a65','25bcdd0f-d4de-4416-aa38-517c4575f44e',262,'c3ea6486309b4dab9bf9d14f604bdce4','shares',-1,'2025-12-05 10:51:38',NULL),('2025-12-04 10:51:38.368688',NULL,'2025-12-04 10:51:38.383046',973,973,'e318249fe70a4240a4a0e7ebc5c47a65','53ee0ca7-8f21-44f9-a541-60234c73ef4b',263,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',-1,'2025-12-05 10:51:38',NULL),('2025-12-04 10:51:38.373365',NULL,'2025-12-04 10:51:38.383046',974,974,NULL,'8ce8bdc5-faa2-4013-ac72-c0bcca7c8f44',264,'c3ea6486309b4dab9bf9d14f604bdce4','shares',-1,'2025-12-05 10:51:38','6a3c87d9-578e-441f-9691-5571c558f82e'),('2025-12-04 10:51:38.373982',NULL,'2025-12-04 10:51:38.383046',975,975,NULL,'b29cff27-bc95-4f23-b8f6-46a7c3775d3f',265,'c3ea6486309b4dab9bf9d14f604bdce4','gigabytes',-1,'2025-12-05 10:51:38','6a3c87d9-578e-441f-9691-5571c558f82e');
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `security_services`
--

DROP TABLE IF EXISTS `security_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `security_services` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `type` varchar(32) NOT NULL,
  `dns_ip` varchar(64) DEFAULT NULL,
  `server` varchar(255) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `user` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `ou` varchar(255) DEFAULT NULL,
  `default_ad_site` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `security_services`
--

LOCK TABLES `security_services` WRITE;
/*!40000 ALTER TABLE `security_services` DISABLE KEYS */;
INSERT INTO `security_services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `type`, `dns_ip`, `server`, `domain`, `user`, `password`, `name`, `description`, `ou`, `default_ad_site`) VALUES ('2025-12-04 10:42:27.098644','2025-12-04 10:42:27.247732','2025-12-04 10:42:27.247332','02ddac91-6c34-4487-a353-bffff97ded50','02ddac91-6c34-4487-a353-bffff97ded50','e9054e17b3ff43baa1b8d582090143ac','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-12-04 10:41:23.802551','2025-12-04 10:41:24.021124','2025-12-04 10:41:24.020741','0ae683e9-48dc-47f0-ac73-5e6b7a17e0a9','0ae683e9-48dc-47f0-ac73-5e6b7a17e0a9','d3e2fbf9d0764ba3936a1bced3597f2c','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-12-04 10:42:29.264910','2025-12-04 10:42:29.593209','2025-12-04 10:42:29.592810','12cffc23-046c-4a57-b861-26f77ff4e75f','12cffc23-046c-4a57-b861-26f77ff4e75f','e9054e17b3ff43baa1b8d582090143ac','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-12-04 10:42:25.240601','2025-12-04 10:42:25.902148','2025-12-04 10:42:25.901821','15f2a684-ffcd-434f-8223-4a0eee2b9347','15f2a684-ffcd-434f-8223-4a0eee2b9347','e9054e17b3ff43baa1b8d582090143ac','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-12-04 10:42:26.147614','2025-12-04 10:42:26.595720','2025-12-04 10:42:26.595231','17b2fb93-d844-4c19-b821-320fea62655a','17b2fb93-d844-4c19-b821-320fea62655a','e9054e17b3ff43baa1b8d582090143ac','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2002-02-02 00:00:00.000000',NULL,NULL,'False','1d662a7d-13df-45a7-bd47-ed213cbc345c','861ef911050d4b8ba35e89f01c620f89','kerberos',NULL,NULL,NULL,NULL,NULL,'sn_with_ldap_ss','fake description',NULL,NULL),('2025-12-04 10:42:24.539667','2025-12-04 10:42:24.709157','2025-12-04 10:42:24.708782','203de723-34bd-4f4f-a12e-f11b7e335e2a','203de723-34bd-4f4f-a12e-f11b7e335e2a','e9054e17b3ff43baa1b8d582090143ac','ldap','203.0.113.69','203.0.113.100','tempest-ss-domain-1079120261','tempest-ss-user-205924801','tempest-ss-password-1615713429','tempest-ss-name-228596575','tempest-ss-desc-1531516903',NULL,NULL),('2025-12-04 10:42:28.811745','2025-12-04 10:42:29.109809','2025-12-04 10:42:29.109442','2739a7fc-61f4-4939-8a0a-1b5f080286ce','2739a7fc-61f4-4939-8a0a-1b5f080286ce','e9054e17b3ff43baa1b8d582090143ac','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-12-04 10:42:26.240043','2025-12-04 10:42:26.404154','2025-12-04 10:42:26.403753','34c6386e-e376-4c3f-88b4-e3f03ad4bc24','34c6386e-e376-4c3f-88b4-e3f03ad4bc24','e9054e17b3ff43baa1b8d582090143ac','ldap','203.0.113.100','203.0.113.90','tempest-ss-domain-1660130949','tempest-ss-user-221312732','tempest-ss-password-648903416','tempest-ss-name-304054226','tempest-ss-desc-2139671101','tempest-ss-ou-2002531898',NULL),('2025-12-04 10:41:26.290599','2025-12-04 10:41:26.700459','2025-12-04 10:41:26.700073','360a97a8-d3f1-41a3-a291-87735b5361d9','360a97a8-d3f1-41a3-a291-87735b5361d9','d3e2fbf9d0764ba3936a1bced3597f2c','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-12-04 10:42:25.291098','2025-12-04 10:42:25.650958','2025-12-04 10:42:25.650599','38fc4c21-488b-4f6b-aa93-8ca17c9929d7','38fc4c21-488b-4f6b-aa93-8ca17c9929d7','e9054e17b3ff43baa1b8d582090143ac','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-12-04 10:41:23.246495','2025-12-04 10:41:23.408509','2025-12-04 10:41:23.407479','39ef7000-2b05-459c-b0d3-41b55d4353b2','39ef7000-2b05-459c-b0d3-41b55d4353b2','d3e2fbf9d0764ba3936a1bced3597f2c','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-12-04 10:42:41.824274','2025-12-04 10:42:41.921787','2025-12-04 10:42:41.921435','3cff7e26-7b5f-488e-ab2b-1da816550c0e','3cff7e26-7b5f-488e-ab2b-1da816550c0e','cb875b7ddccb420a9625fa11560723ac','ldap','203.0.113.87','203.0.113.30','tempest-ss-domain-1273951239','tempest-ss-user-1904057144','tempest-ss-password-1617046971','tempest-ss-name-1493033080','tempest-ss-desc-1700047836',NULL,NULL),('2025-12-04 10:42:26.988203','2025-12-04 10:42:27.408124','2025-12-04 10:42:27.407760','43485c35-6316-41c6-afb5-62f46274b864','43485c35-6316-41c6-afb5-62f46274b864','e9054e17b3ff43baa1b8d582090143ac','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-12-04 10:42:22.574423','2025-12-04 10:42:23.526104','2025-12-04 10:42:23.525722','43a5d115-f3a4-4540-a50a-6ea61ea48985','43a5d115-f3a4-4540-a50a-6ea61ea48985','e9054e17b3ff43baa1b8d582090143ac','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-12-04 10:41:26.237816','2025-12-04 10:41:26.971118','2025-12-04 10:41:26.970730','48a0d1d8-629c-4f2d-af1f-53c8d1dc9dd5','48a0d1d8-629c-4f2d-af1f-53c8d1dc9dd5','d3e2fbf9d0764ba3936a1bced3597f2c','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-12-04 10:39:49.967179',NULL,NULL,'False','4deca5c9-3d6c-48fe-a6ff-d27912284d67','246f1169a6af4a34902c2aa68c00782b','ldap','203.0.113.51','203.0.113.101','tempest-ss-domain-1817174069','tempest-ss-user-2080306005','tempest-ss-password-1520618806','tempest-ss-name-369823337','tempest-ss-desc-1440807372',NULL,NULL),('2025-12-04 10:42:29.329775','2025-12-04 10:42:29.469596','2025-12-04 10:42:29.469196','5577d87b-758b-4a96-98a4-bf6932d78c04','5577d87b-758b-4a96-98a4-bf6932d78c04','e9054e17b3ff43baa1b8d582090143ac','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-12-04 10:45:01.571497',NULL,NULL,'False','56f1dac8-45d5-4ef4-86a2-ffaba344f8ad','a206b399e9d842ecbeb897b80e10c0fc','ldap','203.0.113.123','203.0.113.213','tempest-ss-domain-1949733803','tempest-ss-user-1793530191','tempest-ss-password-347377074','tempest-ss-name-598094441','tempest-ss-desc-175872119',NULL,NULL),('2025-12-04 10:41:25.241861','2025-12-04 10:41:25.299619','2025-12-04 10:41:25.299229','5a93d612-3c5b-4099-bc9b-264137ed5585','5a93d612-3c5b-4099-bc9b-264137ed5585','d3e2fbf9d0764ba3936a1bced3597f2c','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-12-04 10:41:24.444046','2025-12-04 10:41:24.997230','2025-12-04 10:41:24.996645','5b126d2d-b20c-4b7c-a4fd-4035bad3afac','5b126d2d-b20c-4b7c-a4fd-4035bad3afac','d3e2fbf9d0764ba3936a1bced3597f2c','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-12-04 10:42:22.931119','2025-12-04 10:42:23.005000','2025-12-04 10:42:23.004632','5c494bad-a76f-41b0-83c6-0dca61e7a9f6','5c494bad-a76f-41b0-83c6-0dca61e7a9f6','e9054e17b3ff43baa1b8d582090143ac','active_directory','203.0.113.187','203.0.113.77','tempest-ss-domain-1597369642','tempest-ss-user-1595578329','tempest-ss-password-1666268538','tempest-ss-name-804099572','tempest-ss-desc-1588029329',NULL,NULL),('2025-12-04 10:42:26.056897','2025-12-04 10:42:26.369119','2025-12-04 10:42:26.368801','6002934a-54ee-423f-923d-4e72d5350770','6002934a-54ee-423f-923d-4e72d5350770','e5ed5896f5c141d08b886fe18ab11b56','ldap','203.0.113.245','203.0.113.130','tempest-ss-domain-999033570','tempest-ss-user-134950598','tempest-ss-password-946713006','tempest-ss-name-1856129440','tempest-ss-desc-1652084460',NULL,NULL),('2025-12-04 10:42:30.209450','2025-12-04 10:42:30.603452','2025-12-04 10:42:30.603155','627e00b4-46be-4e23-912f-b64824646b83','627e00b4-46be-4e23-912f-b64824646b83','e9054e17b3ff43baa1b8d582090143ac','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-12-04 10:42:28.219895','2025-12-04 10:42:28.349315','2025-12-04 10:42:28.348963','63bf1473-32ee-4309-b2dc-cdd13f17abe1','63bf1473-32ee-4309-b2dc-cdd13f17abe1','e9054e17b3ff43baa1b8d582090143ac','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-12-04 10:42:29.773143','2025-12-04 10:42:29.969240','2025-12-04 10:42:29.968957','671d79cd-7e36-45dd-b67f-4cbd183fe181','671d79cd-7e36-45dd-b67f-4cbd183fe181','e9054e17b3ff43baa1b8d582090143ac','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-12-04 10:45:00.741905',NULL,NULL,'False','6bfffd63-7646-4e1e-8ec7-4329759ca6f9','a206b399e9d842ecbeb897b80e10c0fc','ldap','203.0.113.3','203.0.113.23','tempest-ss-domain-285107791','tempest-ss-user-386091815','tempest-ss-password-422237594','tempest-ss-name-904888272','tempest-ss-desc-470985914',NULL,NULL),('2025-12-04 10:41:27.312817','2025-12-04 10:41:27.438665','2025-12-04 10:41:27.438235','775d7728-88ab-4922-978b-b37240862129','775d7728-88ab-4922-978b-b37240862129','d3e2fbf9d0764ba3936a1bced3597f2c','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-12-04 10:42:31.650089','2025-12-04 10:42:32.538946','2025-12-04 10:42:32.538633','794f4f1e-9c5b-47da-9aa5-ed02a0f5e4d7','794f4f1e-9c5b-47da-9aa5-ed02a0f5e4d7','e9054e17b3ff43baa1b8d582090143ac','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-12-04 10:42:24.963272','2025-12-04 10:42:25.307725','2025-12-04 10:42:25.307248','81df3ade-a261-40cd-93a6-393dcbebf9b1','81df3ade-a261-40cd-93a6-393dcbebf9b1','e5ed5896f5c141d08b886fe18ab11b56','ldap','203.0.113.160','203.0.113.138','tempest-ss-domain-100075884','tempest-ss-user-829162522','tempest-ss-password-1421454796','tempest-ss-name-1042106920','tempest-ss-desc-882324479',NULL,NULL),('2025-12-04 10:41:22.291741','2025-12-04 10:41:22.811236','2025-12-04 10:41:22.810511','81fcb28d-9cc2-494d-bfdc-ee25271001e2','81fcb28d-9cc2-494d-bfdc-ee25271001e2','d3e2fbf9d0764ba3936a1bced3597f2c','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-12-04 10:42:27.630201','2025-12-04 10:42:28.001661','2025-12-04 10:42:28.001307','8a059210-5294-4cd2-912d-ccc90935cc45','8a059210-5294-4cd2-912d-ccc90935cc45','e9054e17b3ff43baa1b8d582090143ac','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-12-04 10:42:30.779456','2025-12-04 10:42:31.388177','2025-12-04 10:42:31.387616','94e08bd5-1a46-438a-a3d2-d4986193b5f0','94e08bd5-1a46-438a-a3d2-d4986193b5f0','e9054e17b3ff43baa1b8d582090143ac','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-12-04 10:42:31.770793','2025-12-04 10:42:32.199063','2025-12-04 10:42:32.198532','99a3b969-6062-41c6-9bb0-a6bcc340ec2b','99a3b969-6062-41c6-9bb0-a6bcc340ec2b','e9054e17b3ff43baa1b8d582090143ac','ldap','203.0.113.139','203.0.113.24','tempest-ss-domain-1513219473','tempest-ss-user-1594733347','tempest-ss-password-247880621','tempest-ss-name-608266271','tempest-ss-desc-1821723965','tempest-ss-ou-2074122276',NULL),('2025-12-04 10:41:24.682426','2025-12-04 10:41:24.854105','2025-12-04 10:41:24.853659','9a756d34-02b0-4755-804a-7b0610abf790','9a756d34-02b0-4755-804a-7b0610abf790','d3e2fbf9d0764ba3936a1bced3597f2c','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-12-04 10:42:25.358218','2025-12-04 10:42:25.492437','2025-12-04 10:42:25.492131','9b119223-ef89-4702-bde1-242317f2842d','9b119223-ef89-4702-bde1-242317f2842d','e9054e17b3ff43baa1b8d582090143ac','ldap','203.0.113.52','203.0.113.210','tempest-ss-domain-1783618021','tempest-ss-user-581035546','tempest-ss-password-364737821','tempest-ss-name-1891861898','tempest-ss-desc-1380449385','tempest-ss-ou-1288690027',NULL),('2025-12-04 10:42:26.073730','2025-12-04 10:42:26.784927','2025-12-04 10:42:26.784639','9c60b17b-555e-48b5-9d7f-c1742b5b7148','9c60b17b-555e-48b5-9d7f-c1742b5b7148','e9054e17b3ff43baa1b8d582090143ac','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-12-04 10:42:23.916074','2025-12-04 10:42:23.984794','2025-12-04 10:42:23.984495','9ca94fad-7d45-4f2d-94ac-f41030f915d8','9ca94fad-7d45-4f2d-94ac-f41030f915d8','e9054e17b3ff43baa1b8d582090143ac','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-12-04 10:42:49.476379',NULL,NULL,'False','a2f6c714-7b5b-4ed5-a0a2-f5fb64e5a1ba','861ef911050d4b8ba35e89f01c620f89','ldap','203.0.113.203','203.0.113.139','tempest-ss-domain-1870392228','tempest-ss-user-692140662','tempest-ss-password-1882857769','tempest-ss-name-1814882726','tempest-ss-desc-818318204',NULL,NULL),('2025-12-04 10:44:59.626484','2025-12-04 10:44:59.973315','2025-12-04 10:44:59.972844','a6e3c352-2941-4d53-8739-75d808443937','a6e3c352-2941-4d53-8739-75d808443937','a206b399e9d842ecbeb897b80e10c0fc','ldap','203.0.113.115','203.0.113.108','tempest-ss-domain-1413908311','tempest-ss-user-900779531','tempest-ss-password-1954023758','tempest-ss-name-225924655','tempest-ss-desc-780103257',NULL,NULL),('2025-12-04 10:41:23.749310','2025-12-04 10:41:24.136348','2025-12-04 10:41:24.136065','aa6ddc4b-39c3-4348-8954-859e5a423bd5','aa6ddc4b-39c3-4348-8954-859e5a423bd5','d3e2fbf9d0764ba3936a1bced3597f2c','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-12-04 10:42:30.899881','2025-12-04 10:42:31.194435','2025-12-04 10:42:31.194096','aad56b57-c44a-4b26-94ff-584019b198d3','aad56b57-c44a-4b26-94ff-584019b198d3','4ac12c2f352948d990be1df2fc6c616b','ldap','203.0.113.162','203.0.113.133','tempest-ss-domain-2008208972','tempest-ss-user-1775656300','tempest-ss-password-1441141121','tempest-ss-name-1598809419','tempest-ss-desc-1085726666',NULL,NULL),('2025-12-04 10:42:31.708013','2025-12-04 10:42:32.315165','2025-12-04 10:42:32.314501','ac88d9af-dcb4-4afa-bc7b-305218b8d2d8','ac88d9af-dcb4-4afa-bc7b-305218b8d2d8','e9054e17b3ff43baa1b8d582090143ac','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-12-04 10:41:22.358736','2025-12-04 10:41:22.657001','2025-12-04 10:41:22.656375','adfd0391-5f11-4f91-99eb-ed1d58e7db2a','adfd0391-5f11-4f91-99eb-ed1d58e7db2a','d3e2fbf9d0764ba3936a1bced3597f2c','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-12-04 10:41:25.850458','2025-12-04 10:41:26.001780','2025-12-04 10:41:26.001431','b5bdc4ce-2b33-4b13-836c-0062b2179619','b5bdc4ce-2b33-4b13-836c-0062b2179619','d3e2fbf9d0764ba3936a1bced3597f2c','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2025-12-04 10:42:24.253735','2025-12-04 10:42:25.013102','2025-12-04 10:42:25.012675','c4b42aa9-8f79-4407-a552-528c07ce3f79','c4b42aa9-8f79-4407-a552-528c07ce3f79','e9054e17b3ff43baa1b8d582090143ac','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-12-04 10:42:29.714878','2025-12-04 10:42:30.095082','2025-12-04 10:42:30.094708','c86e7710-f2e8-4ec7-8516-fbb0fa4668be','c86e7710-f2e8-4ec7-8516-fbb0fa4668be','e9054e17b3ff43baa1b8d582090143ac','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-12-04 10:42:22.448154','2025-12-04 10:42:23.649611','2025-12-04 10:42:23.649138','cb1ac3a6-2a41-4ca6-82bb-746666f68709','cb1ac3a6-2a41-4ca6-82bb-746666f68709','e9054e17b3ff43baa1b8d582090143ac','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-12-04 10:42:22.755754','2025-12-04 10:42:22.815300','2025-12-04 10:42:22.814955','d0c7a85c-0f74-44e1-a634-a64f990c85c6','d0c7a85c-0f74-44e1-a634-a64f990c85c6','e9054e17b3ff43baa1b8d582090143ac','kerberos','203.0.113.187','203.0.113.77','tempest-ss-domain-1597369642','tempest-ss-user-1595578329','tempest-ss-password-1666268538','tempest-ss-name-804099572','tempest-ss-desc-1588029329',NULL,NULL),('2025-12-04 10:41:27.251638','2025-12-04 10:41:27.573757','2025-12-04 10:41:27.573400','d23e6476-02ef-4e52-9b1e-87be9472ee35','d23e6476-02ef-4e52-9b1e-87be9472ee35','d3e2fbf9d0764ba3936a1bced3597f2c','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-12-04 10:42:27.718784','2025-12-04 10:42:27.847758','2025-12-04 10:42:27.847464','d42720d2-a976-4f1c-a671-ef53a81c83cb','d42720d2-a976-4f1c-a671-ef53a81c83cb','e9054e17b3ff43baa1b8d582090143ac','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-12-04 10:42:30.265315','2025-12-04 10:42:30.411673','2025-12-04 10:42:30.411307','d4594351-4034-495e-9eb9-325c2478eef9','d4594351-4034-495e-9eb9-325c2478eef9','e9054e17b3ff43baa1b8d582090143ac','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-12-04 10:42:28.930426','2025-12-04 10:42:28.990824','2025-12-04 10:42:28.990560','d4f89ff1-1be7-4b0e-9a13-d4659b70973b','d4f89ff1-1be7-4b0e-9a13-d4659b70973b','e9054e17b3ff43baa1b8d582090143ac','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2025-12-04 10:41:25.153831','2025-12-04 10:41:25.491342','2025-12-04 10:41:25.490903','d512fcfc-366d-4d43-9b8b-73ef3d85cbdc','d512fcfc-366d-4d43-9b8b-73ef3d85cbdc','d3e2fbf9d0764ba3936a1bced3597f2c','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-12-04 10:41:25.762323','2025-12-04 10:41:26.126459','2025-12-04 10:41:26.126172','ea2cb681-00bc-487e-9473-86aa9c947bdb','ea2cb681-00bc-487e-9473-86aa9c947bdb','d3e2fbf9d0764ba3936a1bced3597f2c','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-12-04 10:42:25.987956',NULL,NULL,'False','ee9e1f03-a770-4c7c-a183-a8e187a4e8d9','e5ed5896f5c141d08b886fe18ab11b56','ldap','203.0.113.248','203.0.113.249','tempest-ss-domain-634380884','tempest-ss-user-231409417','tempest-ss-password-1790679112','tempest-ss-name-375629750','tempest-ss-desc-939907029',NULL,NULL),('2025-12-04 10:42:23.578539',NULL,NULL,'False','eea23c65-8f8d-4784-b58e-cd8726e30dcb','e5ed5896f5c141d08b886fe18ab11b56','ldap',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:42:24.195654','2025-12-04 10:42:25.130499','2025-12-04 10:42:25.130215','eeeec659-f86b-471d-be6d-ac8eee14cfa5','eeeec659-f86b-471d-be6d-ac8eee14cfa5','e9054e17b3ff43baa1b8d582090143ac','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-12-04 10:42:22.636152','2025-12-04 10:42:22.704584','2025-12-04 10:42:22.704237','f1bb5007-2248-4120-ba63-e957defa6860','f1bb5007-2248-4120-ba63-e957defa6860','e9054e17b3ff43baa1b8d582090143ac','ldap','203.0.113.187','203.0.113.77','tempest-ss-domain-1597369642','tempest-ss-user-1595578329','tempest-ss-password-1666268538','tempest-ss-name-804099572','tempest-ss-desc-1588029329',NULL,NULL),('2002-02-02 00:00:00.000000',NULL,NULL,'False','f3f4fdec-ac61-4daf-af10-5ab1c27d2010','05c8461a124b4addbb681e5898e482e5','kerberos',NULL,NULL,NULL,NULL,NULL,'sn_with_ldap_ss','fake description',NULL,NULL),('2025-12-04 10:42:28.158059','2025-12-04 10:42:28.538686','2025-12-04 10:42:28.538303','f9f23ba7-6aa4-47f6-a914-c02e3d50b3bb','f9f23ba7-6aa4-47f6-a914-c02e3d50b3bb','e9054e17b3ff43baa1b8d582090143ac','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-12-04 10:42:30.721730','2025-12-04 10:42:31.528392','2025-12-04 10:42:31.528084','fc2cf322-8bc3-48fe-b00c-176683dc5ae7','fc2cf322-8bc3-48fe-b00c-176683dc5ae7','e9054e17b3ff43baa1b8d582090143ac','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2025-12-04 10:41:22.934566','2025-12-04 10:41:23.536812','2025-12-04 10:41:23.535809','ff5bff94-b9ed-40bd-99d0-284dce3bb453','ff5bff94-b9ed-40bd-99d0-284dce3bb453','d3e2fbf9d0764ba3936a1bced3597f2c','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2025-12-04 10:42:23.780265','2025-12-04 10:42:24.098391','2025-12-04 10:42:24.098081','ff9b45d3-888d-4710-9aed-77832b3ec964','ff9b45d3-888d-4710-9aed-77832b3ec964','e9054e17b3ff43baa1b8d582090143ac','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL);
/*!40000 ALTER TABLE `security_services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  `state` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `service_az_id_fk` (`availability_zone_id`),
  CONSTRAINT `service_az_id_fk` FOREIGN KEY (`availability_zone_id`) REFERENCES `availability_zones` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone_id`, `state`) VALUES ('2025-12-04 10:34:36.438173','2025-12-04 11:06:13.585908',NULL,0,1,'hostgroup','manila-scheduler','manila-scheduler',189,0,'f77ebe78-579a-4b46-8364-e2bff82f3947','up'),('2025-12-04 10:34:44.654423','2025-12-04 11:06:18.993209',NULL,0,2,'hostgroup@cephfs','manila-share','manila-share',188,0,'f77ebe78-579a-4b46-8364-e2bff82f3947','up');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_access_map`
--

DROP TABLE IF EXISTS `share_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_access_map` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `share_id` varchar(36) NOT NULL,
  `access_type` varchar(255) DEFAULT NULL,
  `access_to` varchar(255) DEFAULT NULL,
  `access_level` varchar(2) DEFAULT NULL,
  `access_key` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_id` (`share_id`),
  CONSTRAINT `share_access_map_ibfk_1` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_access_map`
--

LOCK TABLES `share_access_map` WRITE;
/*!40000 ALTER TABLE `share_access_map` DISABLE KEYS */;
INSERT INTO `share_access_map` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_id`, `access_type`, `access_to`, `access_level`, `access_key`) VALUES ('2025-12-04 10:43:07.968696','2025-12-04 10:43:11.953478','2025-12-04 10:43:23.206048','0187d42a-357e-4804-a0f0-40b47476db72','0187d42a-357e-4804-a0f0-40b47476db72','ad85dcc5-0d0d-4da4-81ed-bc7e8e2edbe7','cephx','tempest-cephx-id-195673542','rw','AQC8ZTFpc8TJERAAeovEXr+9v5OdddesmeWBoQ=='),('2025-12-04 10:46:31.210155','2025-12-04 10:46:34.806546','2025-12-04 10:47:41.031709','0eade9d1-05bb-4a8b-8b14-7c17c5653866','0eade9d1-05bb-4a8b-8b14-7c17c5653866','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','alice bob','ro','AQCHZjFpiirONBAA13/MuY0tzaJxlQDIODjLeA=='),('2025-12-04 10:44:52.814057','2025-12-04 10:44:56.720991','2025-12-04 10:47:41.031709','179af611-286e-42bc-8726-44739e474b22','179af611-286e-42bc-8726-44739e474b22','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','alice_bob','ro','AQAlZjFpgGWDBxAAqobJOHbN5BAVRkEc1E6eAQ=='),('2025-12-04 10:42:52.944991','2025-12-04 10:42:57.315907','2025-12-04 10:43:23.206048','19519135-2bdc-4eb2-a5f7-a1f826782508','19519135-2bdc-4eb2-a5f7-a1f826782508','ad85dcc5-0d0d-4da4-81ed-bc7e8e2edbe7','cephx','tempest-cephx-id-195673542','rw','AQCtZTFpTPQuEhAA8SPFLYCoCsLlsJe/5tElfQ=='),('2025-12-04 10:44:08.896861','2025-12-04 10:44:10.542482','2025-12-04 10:44:10.876961','1af71f55-bbd2-403a-b862-ed08df17ff9e','1af71f55-bbd2-403a-b862-ed08df17ff9e','b1336a38-1a5a-47a5-9b90-bf24f6a0a3a2','cephx','tempest-cephx-id-792738809','rw','AQD5ZTFpDl90EhAAFvf4zpXONZRI6VNIADhNbw=='),('2025-12-04 10:43:45.473506','2025-12-04 10:43:49.849808','2025-12-04 10:43:54.714052','222888c5-b890-43a9-a54d-41824c7ae9f7','222888c5-b890-43a9-a54d-41824c7ae9f7','ac64d4c6-95c7-42bd-ae98-ee18c21bfd68','cephx','eve47','rw','AQDhZTFpCfNWMBAAIEYtrCKB2X356QhtPrskaw=='),('2025-12-04 10:43:40.474256','2025-12-04 10:44:02.797812','2025-12-04 10:44:36.344102','27a61a56-4bd8-4ae5-a27e-0ca48566e1b2','27a61a56-4bd8-4ae5-a27e-0ca48566e1b2','2d436547-41b8-4122-9322-d7f521efcae8','cephx','Joe','rw','AQDcZTFpBwlKLBAA5zv7DlFoI0cV+Qi7l+GEzA=='),('2025-12-04 10:47:29.211710','2025-12-04 10:47:32.890287','2025-12-04 10:47:33.282981','320671f5-62a4-4895-a765-41b5179aafcb','320671f5-62a4-4895-a765-41b5179aafcb','a8f732d1-1b5d-49d8-8c55-52087c9cecb1','cephx','bob','rw','AQC5ZjFpKTRTJBAAKE/HBkKiJnq4SUSc46Uomg=='),('2025-12-04 10:43:34.503750','2025-12-04 10:43:54.257862','2025-12-04 10:43:54.714052','392ddae3-c12e-4e44-81ef-d8d21cc861bd','392ddae3-c12e-4e44-81ef-d8d21cc861bd','ac64d4c6-95c7-42bd-ae98-ee18c21bfd68','cephx','eve49','rw','AQDWZTFpm0/UMRAAOws4Hte3gJv7HOOZi6XcsQ=='),('2025-12-04 10:44:45.288062','2025-12-04 10:44:49.225839','2025-12-04 10:47:41.031709','404a2dc6-0e5e-4910-b559-e08f9db20061','404a2dc6-0e5e-4910-b559-e08f9db20061','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','alice_bob','rw','AQAdZjFpboI1JxAAw0Ux5mCz+Go5JIP0SvX7qw=='),('2025-12-04 10:47:14.214247','2025-12-04 10:47:18.103578','2025-12-04 10:47:41.031709','4d6d61cc-04ab-4a20-a9f4-2fd38dd855ca','4d6d61cc-04ab-4a20-a9f4-2fd38dd855ca','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','alice bob','ro','AQCyZjFpDLx5KhAASppmacBK5bXlLz0ohFUwjA=='),('2025-12-04 10:43:00.801872','2025-12-04 10:43:04.583594','2025-12-04 10:43:23.206048','5f0e66bd-a8b5-48d1-be05-b5cd202bb5a9','5f0e66bd-a8b5-48d1-be05-b5cd202bb5a9','ad85dcc5-0d0d-4da4-81ed-bc7e8e2edbe7','cephx','tempest-cephx-id-195673542','rw','AQC1ZTFphHNBDBAAKJXLN/ltv8pmSt8dq5opMQ=='),('2025-12-04 10:46:17.505550','2025-12-04 10:46:21.257817','2025-12-04 10:47:41.031709','62767153-548f-4ddf-a5f7-1eb6911b8a72','62767153-548f-4ddf-a5f7-1eb6911b8a72','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','alice_bob','ro','AQB5ZjFpEQw3MhAA0d3/JtI0QhVJvOakFH3fww=='),('2025-12-04 10:45:21.316193','2025-12-04 10:45:25.139624','2025-12-04 10:47:41.031709','66a79895-a0df-4393-88e9-8a1a359ecc60','66a79895-a0df-4393-88e9-8a1a359ecc60','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','alice','ro','AQBBZjFpxmKZJhAA/2XjjG/67XdwKSIq1omqig=='),('2025-12-04 10:46:38.013179','2025-12-04 10:46:41.698059','2025-12-04 10:47:41.031709','6a3d4785-17b6-403a-aa90-b3d369c848d7','6a3d4785-17b6-403a-aa90-b3d369c848d7','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','alice','rw','AQCOZjFpzl5rLBAAGfYmosPqZSf/i9FUV61tUw=='),('2025-12-04 10:43:51.739618','2025-12-04 10:43:59.107088','2025-12-04 10:44:32.661164','76908ed1-aea9-4916-8310-23ee6ffab6bd','76908ed1-aea9-4916-8310-23ee6ffab6bd','361a365f-e3ed-48f5-b726-d1c98f3a4186','cephx','tempest-cephx-id-1322111508','rw','AQDoZTFp0mGgAhAAV0A2HC1FWkv8knQhbnxqwA=='),('2025-12-04 10:44:06.179027','2025-12-04 10:44:39.689950','2025-12-04 10:44:40.049420','78cef830-277e-4cf0-8b9a-5bb87a36a61c','78cef830-277e-4cf0-8b9a-5bb87a36a61c','51f18aea-3533-4ddd-9c2c-1452cdefca48','cephx','admin','rw',NULL),('2025-12-04 10:44:31.173877','2025-12-04 10:44:34.897119','2025-12-04 10:47:41.031709','7a7645a7-c221-460c-b6a8-744f761a50f3','7a7645a7-c221-460c-b6a8-744f761a50f3','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','alice','rw','AQAPZjFpwxbbHhAA9aOGeHLoS+xnmwYp+BQ38A=='),('2025-12-04 10:47:21.205046','2025-12-04 10:47:36.347886','2025-12-04 10:47:41.031709','7bd22e8e-a946-4b2e-9c5a-f143dc090c7f','7bd22e8e-a946-4b2e-9c5a-f143dc090c7f','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','bob','rw','AQC5ZjFpKTRTJBAAKE/HBkKiJnq4SUSc46Uomg=='),('2025-12-04 10:46:44.869607','2025-12-04 10:46:49.324437','2025-12-04 10:47:41.031709','85ad15d7-ea37-4b9d-a666-7c362882198f','85ad15d7-ea37-4b9d-a666-7c362882198f','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','alice','ro','AQCWZjFpc8JuBBAAe039/Z51BeJeChF2XWNCdA=='),('2025-12-04 10:43:47.670764','2025-12-04 10:43:55.451095','2025-12-04 10:44:32.661164','87323139-bf41-47bf-8be6-7d1d05426406','87323139-bf41-47bf-8be6-7d1d05426406','361a365f-e3ed-48f5-b726-d1c98f3a4186','cephx','Joe','rw',NULL),('2025-12-04 10:44:38.063606','2025-12-04 10:44:42.021687','2025-12-04 10:47:41.031709','8b93ff6d-1de6-404b-bc23-4be8eabd02eb','8b93ff6d-1de6-404b-bc23-4be8eabd02eb','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','alice','ro','AQAWZjFpQqR/FRAASeIiHouTViNcb0rRulzyeQ=='),('2025-12-04 10:46:03.905640','2025-12-04 10:46:07.557630','2025-12-04 10:47:41.031709','97fe295a-688f-44fb-8000-b4af43141fac','97fe295a-688f-44fb-8000-b4af43141fac','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','alice','ro','AQBsZjFp6+kPJRAAicHhKyIqm4E4wtsGx7kr/w=='),('2025-12-04 10:45:57.142114','2025-12-04 10:46:00.743271','2025-12-04 10:47:41.031709','9e50609a-172e-4006-b256-9c85aa4b4291','9e50609a-172e-4006-b256-9c85aa4b4291','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','alice','rw','AQBlZjFpi7IsGRAAvcKWIVun5CUghLDxPPWsnw=='),('2025-12-04 10:44:09.912267','2025-12-04 10:44:24.556556','2025-12-04 10:44:40.049420','9f3532be-d28f-4e2e-88ec-a87519862a61','9f3532be-d28f-4e2e-88ec-a87519862a61','51f18aea-3533-4ddd-9c2c-1452cdefca48','cephx','david','rw','AQD6ZTFp8dC2EhAAaSv1W6HXMOE9V2mkRQKBHg=='),('2025-12-04 10:45:14.218204','2025-12-04 10:45:18.077555','2025-12-04 10:47:41.031709','a934361b-dbec-42f4-8b36-a55dfbd365ec','a934361b-dbec-42f4-8b36-a55dfbd365ec','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','alice','rw','AQA6ZjFp1G19HhAA6rtlkoEmBrQFZ2Njh/6hww=='),('2025-12-04 10:45:28.344979','2025-12-04 10:45:32.235571','2025-12-04 10:47:41.031709','aa834918-62c4-490d-a7b8-1ad8629dec6a','aa834918-62c4-490d-a7b8-1ad8629dec6a','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','alice_bob','rw','AQBIZjFpbqcLOBAANRAkhDpOXPVFPpUJFD/Duw=='),('2025-12-04 10:44:16.978191','2025-12-04 10:44:20.818842','2025-12-04 10:44:28.912311','aab30d19-e7f5-46f1-9a97-46b450851ca8','aab30d19-e7f5-46f1-9a97-46b450851ca8','d9c7ad6d-0886-4bc8-aeea-f4d0267bd9ea','cephx','david','rw',NULL),('2025-12-04 10:43:38.100065','2025-12-04 10:43:41.990344','2025-12-04 10:43:54.714052','ab60b685-ee2a-46f7-bb4b-02f76bcd8578','ab60b685-ee2a-46f7-bb4b-02f76bcd8578','ac64d4c6-95c7-42bd-ae98-ee18c21bfd68','cephx','eve48','rw','AQDaZTFps3Y7HxAA36FUgCyDrJljPY/67k7UhQ=='),('2025-12-04 10:44:59.958804','2025-12-04 10:45:03.990472','2025-12-04 10:47:41.031709','b2cec69b-0c39-43a5-bb78-19f421499c59','b2cec69b-0c39-43a5-bb78-19f421499c59','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','alice bob','rw','AQAsZjFpMicpGRAAGlWtEkMo80QSDo/p92roJA=='),('2025-12-04 10:46:52.528632','2025-12-04 10:46:56.851155','2025-12-04 10:47:41.031709','b36909f5-c106-483c-9378-6565e0f92084','b36909f5-c106-483c-9378-6565e0f92084','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','alice_bob','rw','AQCdZjFplidgCBAAX2NbyqIBxTXINsthwifSUA=='),('2025-12-04 10:47:00.092594','2025-12-04 10:47:03.866016','2025-12-04 10:47:41.031709','bf4510cc-5cad-4f37-9782-2f9cd4a8090e','bf4510cc-5cad-4f37-9782-2f9cd4a8090e','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','alice_bob','ro','AQCkZjFptr9ZHxAAWDvOwD3S5/MGkP1bNs0efQ=='),('2025-12-04 10:46:10.744753','2025-12-04 10:46:14.348647','2025-12-04 10:47:41.031709','cb25ef45-7a91-4965-9115-e43289ed30c7','cb25ef45-7a91-4965-9115-e43289ed30c7','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','alice_bob','rw','AQBzZjFp/vD0FBAADCyxV/3Yk6XzvTXWF5Wfwg=='),('2025-12-04 10:45:07.324311','2025-12-04 10:45:11.030345','2025-12-04 10:47:41.031709','d0fe5e99-b143-4569-bf58-5075df95daec','d0fe5e99-b143-4569-bf58-5075df95daec','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','alice bob','ro','AQAzZjFpGvdjIhAAACN6/yxkfosgmvoqNIz+nw=='),('2025-12-04 10:42:24.474157','2025-12-04 10:42:28.296093','2025-12-04 10:42:28.648630','d1768f4f-78d9-4490-94fd-74da927d5abb','d1768f4f-78d9-4490-94fd-74da927d5abb','5c089416-80f4-44d7-ae20-e3205c02b9f6','cephx','tempest-cephx-id-195673542','rw','AQCQZTFphXUkMRAAjslk7P1FBlCljBJUcgn7FQ=='),('2025-12-04 10:45:42.442336','2025-12-04 10:45:46.356399','2025-12-04 10:47:41.031709','d38395ee-baac-41b3-95a6-d2aa21cb3dcc','d38395ee-baac-41b3-95a6-d2aa21cb3dcc','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','alice bob','rw','AQBXZjFpMfYVABAAvwZXQvONhwum0jXLvKegbw=='),('2025-12-04 10:43:15.303556','2025-12-04 10:43:19.054517','2025-12-04 10:43:23.206048','d883969a-635e-4f02-a48a-473264b0c113','d883969a-635e-4f02-a48a-473264b0c113','ad85dcc5-0d0d-4da4-81ed-bc7e8e2edbe7','cephx','tempest-cephx-id-195673542','rw','AQDDZTFpV4MoJRAARjiRwEImMJktwBIiP7RO8g=='),('2025-12-04 10:42:34.940628','2025-12-04 10:42:38.810734','2025-12-04 10:42:39.441904','dacc3749-e14c-494a-8892-613a812e5e90','dacc3749-e14c-494a-8892-613a812e5e90','46a22168-c576-4b32-8268-3052b32d9157','cephx','tempest-cephx-id-195673542','rw','AQCbZTFpi4ZKEBAAqo9M0QDoScFX4k8FJyoucw=='),('2025-12-04 10:45:49.838153','2025-12-04 10:45:53.804323','2025-12-04 10:47:41.031709','e4a884a5-d6b7-4d28-bd04-70f1c4be306e','e4a884a5-d6b7-4d28-bd04-70f1c4be306e','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','alice bob','ro','AQBeZjFpxuC1DBAAWpnIPBp4kHdbIy7ShEQFkQ=='),('2025-12-04 10:42:45.807008','2025-12-04 10:42:49.694296','2025-12-04 10:42:50.109287','e5014762-4ac0-47d1-a08f-0c344e05238f','e5014762-4ac0-47d1-a08f-0c344e05238f','2ad065b7-ef88-4d1b-bf36-9dcd4fcd6071','cephx','tempest-cephx-id-195673542','rw','AQCmZTFp2vO1BhAAyU0BUvVQ2nvYrkbTEGRxYQ=='),('2025-12-04 10:46:24.406393','2025-12-04 10:46:28.033071','2025-12-04 10:47:41.031709','f0a7461a-ed49-41a8-b8ca-a3d05e065a3c','f0a7461a-ed49-41a8-b8ca-a3d05e065a3c','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','alice bob','rw','AQCAZjFpMk7DLRAASqqmG33MCu/fP09Oh4ZPUQ=='),('2025-12-04 10:47:07.091996','2025-12-04 10:47:10.921774','2025-12-04 10:47:41.031709','f3b7cbe8-718d-419b-95c9-522ab8df0dcb','f3b7cbe8-718d-419b-95c9-522ab8df0dcb','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','alice bob','rw','AQCrZjFpHVfMFhAAl2JfIPsv3SFlex/ZSitbHQ=='),('2025-12-04 10:45:35.392204','2025-12-04 10:45:39.067645','2025-12-04 10:47:41.031709','ff080207-2f9a-40fc-b123-48dbbf0e9ef7','ff080207-2f9a-40fc-b123-48dbbf0e9ef7','4b1855ba-c5e9-4793-a786-40a54e7585ef','cephx','alice_bob','ro','AQBPZjFpzqGYMhAABW8+oZC0Exd07xtOFQg6Tg==');
/*!40000 ALTER TABLE `share_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_access_rules_metadata`
--

DROP TABLE IF EXISTS `share_access_rules_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_access_rules_metadata` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `access_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `access_id` (`access_id`),
  CONSTRAINT `share_access_rules_metadata_ibfk_1` FOREIGN KEY (`access_id`) REFERENCES `share_access_map` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_access_rules_metadata`
--

LOCK TABLES `share_access_rules_metadata` WRITE;
/*!40000 ALTER TABLE `share_access_rules_metadata` DISABLE KEYS */;
INSERT INTO `share_access_rules_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `access_id`, `key`, `value`, `id`) VALUES ('2025-12-04 10:43:07.969710',NULL,'2025-12-04 10:43:12.215984','1','0187d42a-357e-4804-a0f0-40b47476db72','key1','v1',1),('2025-12-04 10:43:07.970115',NULL,'2025-12-04 10:43:12.215984','2','0187d42a-357e-4804-a0f0-40b47476db72','key2','v2',2),('2025-12-04 10:43:15.304784',NULL,'2025-12-04 10:43:19.264663','3','d883969a-635e-4f02-a48a-473264b0c113','key1','v1',3),('2025-12-04 10:43:15.305302',NULL,'2025-12-04 10:43:19.264663','4','d883969a-635e-4f02-a48a-473264b0c113','key2','v2',4),('2025-12-04 10:43:34.504782',NULL,'2025-12-04 10:43:54.547206','5','392ddae3-c12e-4e44-81ef-d8d21cc861bd','key1','value1',5),('2025-12-04 10:43:34.505296','2025-12-04 10:43:53.152560','2025-12-04 10:43:54.547206','6','392ddae3-c12e-4e44-81ef-d8d21cc861bd','key2','value6_new',6),('2025-12-04 10:43:38.100806',NULL,'2025-12-04 10:43:42.262945','7','ab60b685-ee2a-46f7-bb4b-02f76bcd8578','key3','v3',7),('2025-12-04 10:43:38.101160',NULL,'2025-12-04 10:43:42.262945','8','ab60b685-ee2a-46f7-bb4b-02f76bcd8578','key4','value4',8),('2025-12-04 10:43:45.474379','2025-12-04 10:43:49.207668','2025-12-04 10:43:50.195445','9','222888c5-b890-43a9-a54d-41824c7ae9f7','key1','vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv',9),('2025-12-04 10:43:45.474964','2025-12-04 10:43:49.342118','2025-12-04 10:43:50.195445','10','222888c5-b890-43a9-a54d-41824c7ae9f7','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value2',10),('2025-12-04 10:43:53.131761',NULL,'2025-12-04 10:43:54.547206','11','392ddae3-c12e-4e44-81ef-d8d21cc861bd','key7','value7',11),('2025-12-04 10:44:08.898755',NULL,'2025-12-04 10:44:10.767231','12','1af71f55-bbd2-403a-b862-ed08df17ff9e','key1','value1',12);
/*!40000 ALTER TABLE `share_access_rules_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_share_type_mappings`
--

DROP TABLE IF EXISTS `share_group_share_type_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_share_type_mappings` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_group_id` varchar(36) DEFAULT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_sgstm_share_group_id` (`share_group_id`),
  KEY `fk_sgstm_share_type_id` (`share_type_id`),
  CONSTRAINT `fk_sgstm_share_group_id` FOREIGN KEY (`share_group_id`) REFERENCES `share_groups` (`id`),
  CONSTRAINT `fk_sgstm_share_type_id` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_share_type_mappings`
--

LOCK TABLES `share_group_share_type_mappings` WRITE;
/*!40000 ALTER TABLE `share_group_share_type_mappings` DISABLE KEYS */;
INSERT INTO `share_group_share_type_mappings` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_group_id`, `share_type_id`) VALUES ('135bdb2d-5d6b-4022-94c2-a1d09c97ca6c','2025-12-04 10:43:34.136401',NULL,'2025-12-04 10:43:34.794783','135bdb2d-5d6b-4022-94c2-a1d09c97ca6c','cbe47551-19d7-448d-b120-9e300aa25c97','820e79dd-be75-4d91-aca0-04a50b785894'),('2a71c925-04a2-4f3a-b674-23d974a09096','2025-12-04 10:43:35.315281',NULL,'2025-12-04 10:43:38.874521','2a71c925-04a2-4f3a-b674-23d974a09096','a007c67c-4b9e-45ce-9f08-f1379750eb54','820e79dd-be75-4d91-aca0-04a50b785894');
/*!40000 ALTER TABLE `share_group_share_type_mappings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_snapshots`
--

DROP TABLE IF EXISTS `share_group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_snapshots` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `share_group_id` varchar(36) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_share_group_snapshots_share_group_id` (`share_group_id`),
  CONSTRAINT `fk_share_group_snapshots_share_group_id` FOREIGN KEY (`share_group_id`) REFERENCES `share_groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_snapshots`
--

LOCK TABLES `share_group_snapshots` WRITE;
/*!40000 ALTER TABLE `share_group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_type_projects`
--

DROP TABLE IF EXISTS `share_group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sgtp_project_id_uc` (`share_group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `sgtp_id_fk` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_type_projects`
--

LOCK TABLES `share_group_type_projects` WRITE;
/*!40000 ALTER TABLE `share_group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_type_share_type_mappings`
--

DROP TABLE IF EXISTS `share_group_type_share_type_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_type_share_type_mappings` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_group_type_id` varchar(36) NOT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sgtp_id_sgt_id_uc` (`share_group_type_id`),
  KEY `sgtp_id_st_id_uc` (`share_type_id`),
  CONSTRAINT `sgtp_id_sgt_id_uc` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`),
  CONSTRAINT `sgtp_id_st_id_uc` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_type_share_type_mappings`
--

LOCK TABLES `share_group_type_share_type_mappings` WRITE;
/*!40000 ALTER TABLE `share_group_type_share_type_mappings` DISABLE KEYS */;
INSERT INTO `share_group_type_share_type_mappings` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_group_type_id`, `share_type_id`) VALUES ('62c48fd2-2e9a-4c56-89c5-4fbba9e49d39','2025-12-04 10:45:47.607665',NULL,'2025-12-04 10:45:49.062359','62c48fd2-2e9a-4c56-89c5-4fbba9e49d39','b722d880-4583-4b91-ac1a-2ca39c0287d4','472be5b2-30dd-410b-8fb9-cb79a98551d9'),('eebeb670-863f-4189-859a-29d65ba4292e','2025-12-04 10:39:53.115103',NULL,'2025-12-04 10:40:28.256462','eebeb670-863f-4189-859a-29d65ba4292e','4ede7d7c-f719-4d75-a4ff-243414d14b0e','9c68edba-9905-4826-9020-f24a33ca4068'),('eedae250-2ccd-488f-a5c2-e4777d241649','2025-12-04 10:43:15.266441',NULL,'2025-12-04 10:43:54.189385','eedae250-2ccd-488f-a5c2-e4777d241649','42a41313-eb64-43c2-affa-37aad376e5b2','820e79dd-be75-4d91-aca0-04a50b785894'),('ef4700c9-ab7d-4536-802a-3795dc4a4d45','2025-12-04 10:39:23.669614',NULL,'2025-12-04 10:40:01.988979','ef4700c9-ab7d-4536-802a-3795dc4a4d45','31aa152a-b890-43b5-9d09-b759418d5bc7','f9c9ca5f-6992-4730-8113-73ad975de651');
/*!40000 ALTER TABLE `share_group_type_share_type_mappings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_type_specs`
--

DROP TABLE IF EXISTS `share_group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `spec_key` varchar(255) DEFAULT NULL,
  `spec_value` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sgtp_id_extra_specs_fk` (`share_group_type_id`),
  CONSTRAINT `sgtp_id_extra_specs_fk` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_type_specs`
--

LOCK TABLES `share_group_type_specs` WRITE;
/*!40000 ALTER TABLE `share_group_type_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_types`
--

DROP TABLE IF EXISTS `share_group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_types` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_share_group_type_name` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_types`
--

LOCK TABLES `share_group_types` WRITE;
/*!40000 ALTER TABLE `share_group_types` DISABLE KEYS */;
INSERT INTO `share_group_types` (`id`, `created_at`, `updated_at`, `deleted_at`, `is_public`, `name`, `deleted`) VALUES ('31aa152a-b890-43b5-9d09-b759418d5bc7','2025-12-04 10:39:23.668174',NULL,'2025-12-04 10:40:01.992701',1,'tempest-unique_sgtype_name-896744825','31aa152a-b890-43b5-9d09-b759418d5bc7'),('42a41313-eb64-43c2-affa-37aad376e5b2','2025-12-04 10:43:15.265894',NULL,'2025-12-04 10:43:54.192832',1,'tempest-unique_sgtype_name-1704811412','42a41313-eb64-43c2-affa-37aad376e5b2'),('4ede7d7c-f719-4d75-a4ff-243414d14b0e','2025-12-04 10:39:53.113906',NULL,'2025-12-04 10:40:28.259433',1,'tempest-unique_sgtype_name-1993091604','4ede7d7c-f719-4d75-a4ff-243414d14b0e'),('b722d880-4583-4b91-ac1a-2ca39c0287d4','2025-12-04 10:45:47.606653',NULL,'2025-12-04 10:45:49.064656',1,'tempest-unique_sgtype_name-1603199028','b722d880-4583-4b91-ac1a-2ca39c0287d4');
/*!40000 ALTER TABLE `share_group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_groups`
--

DROP TABLE IF EXISTS `share_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_groups` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `host` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `source_share_group_snapshot_id` varchar(36) DEFAULT NULL,
  `share_network_id` varchar(36) DEFAULT NULL,
  `share_server_id` varchar(36) DEFAULT NULL,
  `share_group_type_id` varchar(36) DEFAULT NULL,
  `consistent_snapshot_support` enum('pool','host') DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_share_group_share_network_id` (`share_network_id`),
  KEY `fk_share_group_share_server_id` (`share_server_id`),
  KEY `sgt_id_sg_id_uc` (`share_group_type_id`),
  CONSTRAINT `fk_share_group_share_network_id` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`),
  CONSTRAINT `fk_share_group_share_server_id` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`),
  CONSTRAINT `sgt_id_sg_id_uc` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_groups`
--

LOCK TABLES `share_groups` WRITE;
/*!40000 ALTER TABLE `share_groups` DISABLE KEYS */;
INSERT INTO `share_groups` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `user_id`, `project_id`, `host`, `name`, `description`, `status`, `source_share_group_snapshot_id`, `share_network_id`, `share_server_id`, `share_group_type_id`, `consistent_snapshot_support`, `availability_zone_id`) VALUES ('a007c67c-4b9e-45ce-9f08-f1379750eb54','2025-12-04 10:43:35.436279','2025-12-04 10:43:38.873086','2025-12-04 10:43:38.872416','a007c67c-4b9e-45ce-9f08-f1379750eb54','4c579d8ef46542619c86f7d6ba0c6283','b0e23771bd1a4c3ea8b52092c2e5d69e','hostgroup@cephfs#cephfs',NULL,NULL,'deleting',NULL,NULL,NULL,'42a41313-eb64-43c2-affa-37aad376e5b2',NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947'),('cbe47551-19d7-448d-b120-9e300aa25c97','2025-12-04 10:43:34.283776','2025-12-04 10:43:34.793504','2025-12-04 10:43:34.792626','cbe47551-19d7-448d-b120-9e300aa25c97','4c579d8ef46542619c86f7d6ba0c6283','b0e23771bd1a4c3ea8b52092c2e5d69e','hostgroup@cephfs#cephfs',NULL,NULL,'deleting',NULL,NULL,NULL,'42a41313-eb64-43c2-affa-37aad376e5b2',NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947');
/*!40000 ALTER TABLE `share_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instance_access_map`
--

DROP TABLE IF EXISTS `share_instance_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instance_access_map` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `share_instance_id` varchar(36) DEFAULT NULL,
  `access_id` varchar(36) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `siam_instance_fk` (`share_instance_id`),
  KEY `siam_access_fk` (`access_id`),
  CONSTRAINT `siam_access_fk` FOREIGN KEY (`access_id`) REFERENCES `share_access_map` (`id`),
  CONSTRAINT `siam_instance_fk` FOREIGN KEY (`share_instance_id`) REFERENCES `share_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instance_access_map`
--

LOCK TABLES `share_instance_access_map` WRITE;
/*!40000 ALTER TABLE `share_instance_access_map` DISABLE KEYS */;
INSERT INTO `share_instance_access_map` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_instance_id`, `access_id`, `state`) VALUES ('2025-12-04 10:46:03.940533','2025-12-04 10:46:07.779018','2025-12-04 10:46:07.778527','03a061e4-562f-48c2-9a9e-53ae17893f88','03a061e4-562f-48c2-9a9e-53ae17893f88','1de31656-5fa1-4344-818a-900ef388b939','97fe295a-688f-44fb-8000-b4af43141fac','deleted'),('2025-12-04 10:45:49.849946','2025-12-04 10:45:54.003613','2025-12-04 10:45:54.003184','0546df61-db46-4051-be08-8b23bb36213c','0546df61-db46-4051-be08-8b23bb36213c','1de31656-5fa1-4344-818a-900ef388b939','e4a884a5-d6b7-4d28-bd04-70f1c4be306e','deleted'),('2025-12-04 10:45:21.329209','2025-12-04 10:45:25.358853','2025-12-04 10:45:25.358371','07b75876-7564-4613-a0d6-c3e0bdc9d15d','07b75876-7564-4613-a0d6-c3e0bdc9d15d','1de31656-5fa1-4344-818a-900ef388b939','66a79895-a0df-4393-88e9-8a1a359ecc60','deleted'),('2025-12-04 10:47:14.226796','2025-12-04 10:47:18.319054','2025-12-04 10:47:18.318573','1e9221c0-2269-4cc4-a496-9f0c7f58b1d8','1e9221c0-2269-4cc4-a496-9f0c7f58b1d8','1de31656-5fa1-4344-818a-900ef388b939','4d6d61cc-04ab-4a20-a9f4-2fd38dd855ca','deleted'),('2025-12-04 10:45:07.336212','2025-12-04 10:45:11.279106','2025-12-04 10:45:11.278596','2b055a1e-4076-450b-960e-09b09f07313c','2b055a1e-4076-450b-960e-09b09f07313c','1de31656-5fa1-4344-818a-900ef388b939','d0fe5e99-b143-4569-bf58-5075df95daec','deleted'),('2025-12-04 10:46:10.758776','2025-12-04 10:46:14.547687','2025-12-04 10:46:14.547325','2d423a1f-3bf9-4c29-9bc2-7e3064b857cb','2d423a1f-3bf9-4c29-9bc2-7e3064b857cb','1de31656-5fa1-4344-818a-900ef388b939','cb25ef45-7a91-4965-9115-e43289ed30c7','deleted'),('2025-12-04 10:47:29.226340','2025-12-04 10:47:33.278553','2025-12-04 10:47:33.278019','2db80c29-6372-42f7-a25b-bfbf05a7ed56','2db80c29-6372-42f7-a25b-bfbf05a7ed56','e36f2012-530d-4132-9482-586618cf68e8','320671f5-62a4-4895-a765-41b5179aafcb','deleted'),('2025-12-04 10:45:57.164353','2025-12-04 10:46:01.032447','2025-12-04 10:46:01.031968','34609f29-e6bd-49de-b6da-29a1448f5fbb','34609f29-e6bd-49de-b6da-29a1448f5fbb','1de31656-5fa1-4344-818a-900ef388b939','9e50609a-172e-4006-b256-9c85aa4b4291','deleted'),('2025-12-04 10:44:09.927578','2025-12-04 10:44:24.820713','2025-12-04 10:44:24.820140','3904a871-87b5-4e7c-93d7-e87fec50ffa9','3904a871-87b5-4e7c-93d7-e87fec50ffa9','b590878f-f5a4-4c4c-97ac-af9c32c4449c','9f3532be-d28f-4e2e-88ec-a87519862a61','deleted'),('2025-12-04 10:46:24.420412','2025-12-04 10:46:28.206717','2025-12-04 10:46:28.206345','3aae0636-41e4-481c-a360-302b9657bc8f','3aae0636-41e4-481c-a360-302b9657bc8f','1de31656-5fa1-4344-818a-900ef388b939','f0a7461a-ed49-41a8-b8ca-a3d05e065a3c','deleted'),('2025-12-04 10:43:51.754609','2025-12-04 10:43:59.345502','2025-12-04 10:43:59.345129','3c843815-9d95-4cc6-b723-a98e9fa52ea8','3c843815-9d95-4cc6-b723-a98e9fa52ea8','187ec7c1-10e2-40cd-bd3e-105526ebd065','76908ed1-aea9-4916-8310-23ee6ffab6bd','deleted'),('2025-12-04 10:43:47.687784','2025-12-04 10:43:55.670124','2025-12-04 10:43:55.669473','414404fe-1558-41d5-8299-725f9d593eb9','414404fe-1558-41d5-8299-725f9d593eb9','187ec7c1-10e2-40cd-bd3e-105526ebd065','87323139-bf41-47bf-8be6-7d1d05426406','deleted'),('2025-12-04 10:45:42.458346','2025-12-04 10:45:46.610749','2025-12-04 10:45:46.610337','45ed7762-ed5a-498e-a0f5-a8226f244e69','45ed7762-ed5a-498e-a0f5-a8226f244e69','1de31656-5fa1-4344-818a-900ef388b939','d38395ee-baac-41b3-95a6-d2aa21cb3dcc','deleted'),('2025-12-04 10:46:38.030752','2025-12-04 10:46:41.893357','2025-12-04 10:46:41.892899','511bd8c3-bfa3-42dd-b39f-1c9b9d40f502','511bd8c3-bfa3-42dd-b39f-1c9b9d40f502','1de31656-5fa1-4344-818a-900ef388b939','6a3d4785-17b6-403a-aa90-b3d369c848d7','deleted'),('2025-12-04 10:44:16.991368','2025-12-04 10:44:21.035422','2025-12-04 10:44:21.035022','6bcb50f0-e2b8-4de3-a767-37d8c7e1598d','6bcb50f0-e2b8-4de3-a767-37d8c7e1598d','bd4b4cb5-5fca-4376-8188-5f69aab6c36d','aab30d19-e7f5-46f1-9a97-46b450851ca8','deleted'),('2025-12-04 10:47:07.103679','2025-12-04 10:47:11.120304','2025-12-04 10:47:11.119795','6d4eeb8f-16dd-4249-a8d6-cb28342a3944','6d4eeb8f-16dd-4249-a8d6-cb28342a3944','1de31656-5fa1-4344-818a-900ef388b939','f3b7cbe8-718d-419b-95c9-522ab8df0dcb','deleted'),('2025-12-04 10:45:35.405744','2025-12-04 10:45:39.277889','2025-12-04 10:45:39.277508','6deabb24-2374-40d3-82e3-2932070b65a4','6deabb24-2374-40d3-82e3-2932070b65a4','1de31656-5fa1-4344-818a-900ef388b939','ff080207-2f9a-40fc-b123-48dbbf0e9ef7','deleted'),('2025-12-04 10:43:34.519455','2025-12-04 10:43:54.543477','2025-12-04 10:43:54.543007','7042ee99-3e82-448a-b9ef-3c08e2266fa4','7042ee99-3e82-448a-b9ef-3c08e2266fa4','dec20aa6-db73-446c-9d5e-8597f7adaaa8','392ddae3-c12e-4e44-81ef-d8d21cc861bd','deleted'),('2025-12-04 10:45:14.231704','2025-12-04 10:45:18.311065','2025-12-04 10:45:18.310674','73685557-8a8e-4ada-a3f7-d40af129a492','73685557-8a8e-4ada-a3f7-d40af129a492','1de31656-5fa1-4344-818a-900ef388b939','a934361b-dbec-42f4-8b36-a55dfbd365ec','deleted'),('2025-12-04 10:44:08.908709','2025-12-04 10:44:10.765221','2025-12-04 10:44:10.764834','783ea366-9270-4c16-a101-41c3a07a8343','783ea366-9270-4c16-a101-41c3a07a8343','485981c2-4d65-44e2-a4c4-d55efb5d64b6','1af71f55-bbd2-403a-b862-ed08df17ff9e','deleted'),('2025-12-04 10:43:07.984033','2025-12-04 10:43:12.213640','2025-12-04 10:43:12.213184','79137443-f323-4d1f-9026-a66e61f1ad91','79137443-f323-4d1f-9026-a66e61f1ad91','ee821ced-1eec-43e8-af63-bd95973cd67b','0187d42a-357e-4804-a0f0-40b47476db72','deleted'),('2025-12-04 10:43:45.487435','2025-12-04 10:43:50.188245','2025-12-04 10:43:50.187787','7d544225-b9f0-42d9-a83f-7774cfb072f8','7d544225-b9f0-42d9-a83f-7774cfb072f8','dec20aa6-db73-446c-9d5e-8597f7adaaa8','222888c5-b890-43a9-a54d-41824c7ae9f7','deleted'),('2025-12-04 10:44:06.190532','2025-12-04 10:44:39.891031','2025-12-04 10:44:39.890523','7d5f4b86-3c7d-4d4e-891a-f64de9c7284c','7d5f4b86-3c7d-4d4e-891a-f64de9c7284c','b590878f-f5a4-4c4c-97ac-af9c32c4449c','78cef830-277e-4cf0-8b9a-5bb87a36a61c','deleted'),('2025-12-04 10:44:31.191593','2025-12-04 10:44:35.182171','2025-12-04 10:44:35.181763','82bad8f8-fce1-4788-922b-e407a2015b14','82bad8f8-fce1-4788-922b-e407a2015b14','1de31656-5fa1-4344-818a-900ef388b939','7a7645a7-c221-460c-b6a8-744f761a50f3','deleted'),('2025-12-04 10:44:38.076044','2025-12-04 10:44:42.256645','2025-12-04 10:44:42.256114','8545f93f-0d36-4e40-a26e-1a737b309a95','8545f93f-0d36-4e40-a26e-1a737b309a95','1de31656-5fa1-4344-818a-900ef388b939','8b93ff6d-1de6-404b-bc23-4be8eabd02eb','deleted'),('2025-12-04 10:44:45.298639','2025-12-04 10:44:49.444415','2025-12-04 10:44:49.444072','87a7dc90-a354-4cd0-9c48-a13a6bb5a4bb','87a7dc90-a354-4cd0-9c48-a13a6bb5a4bb','1de31656-5fa1-4344-818a-900ef388b939','404a2dc6-0e5e-4910-b559-e08f9db20061','deleted'),('2025-12-04 10:42:34.962303','2025-12-04 10:42:39.268349','2025-12-04 10:42:39.267966','880a0c06-cd2e-4559-a123-100556d1d574','880a0c06-cd2e-4559-a123-100556d1d574','c5da5d86-f585-431a-b524-b52c13853cdd','dacc3749-e14c-494a-8892-613a812e5e90','deleted'),('2025-12-04 10:45:28.359032','2025-12-04 10:45:32.448436','2025-12-04 10:45:32.448014','88c9290d-3095-4ba5-b374-9c9ac5cbedac','88c9290d-3095-4ba5-b374-9c9ac5cbedac','1de31656-5fa1-4344-818a-900ef388b939','aa834918-62c4-490d-a7b8-1ad8629dec6a','deleted'),('2025-12-04 10:43:38.112281','2025-12-04 10:43:42.259563','2025-12-04 10:43:42.259138','8b0ae66e-c7e9-4ff0-ab20-ea6b31933c27','8b0ae66e-c7e9-4ff0-ab20-ea6b31933c27','dec20aa6-db73-446c-9d5e-8597f7adaaa8','ab60b685-ee2a-46f7-bb4b-02f76bcd8578','deleted'),('2025-12-04 10:47:00.106287','2025-12-04 10:47:04.105416','2025-12-04 10:47:04.105030','9d8eb56c-5d16-4977-9ddb-011b42163205','9d8eb56c-5d16-4977-9ddb-011b42163205','1de31656-5fa1-4344-818a-900ef388b939','bf4510cc-5cad-4f37-9782-2f9cd4a8090e','deleted'),('2025-12-04 10:46:52.542570','2025-12-04 10:46:57.099998','2025-12-04 10:46:57.099550','a8863395-f19f-4bae-81c7-b06781678d4a','a8863395-f19f-4bae-81c7-b06781678d4a','1de31656-5fa1-4344-818a-900ef388b939','b36909f5-c106-483c-9378-6565e0f92084','deleted'),('2025-12-04 10:42:52.974588','2025-12-04 10:42:57.564537','2025-12-04 10:42:57.564090','b7399060-8d90-466e-ab48-7a6f5ff2fa65','b7399060-8d90-466e-ab48-7a6f5ff2fa65','ee821ced-1eec-43e8-af63-bd95973cd67b','19519135-2bdc-4eb2-a5f7-a1f826782508','deleted'),('2025-12-04 10:47:21.229057','2025-12-04 10:47:37.021567','2025-12-04 10:47:37.021054','baf9d802-d9cb-456d-83a5-9053d92bfd6d','baf9d802-d9cb-456d-83a5-9053d92bfd6d','1de31656-5fa1-4344-818a-900ef388b939','7bd22e8e-a946-4b2e-9c5a-f143dc090c7f','deleted'),('2025-12-04 10:46:31.226996','2025-12-04 10:46:35.319723','2025-12-04 10:46:35.319346','bce3affc-015f-4019-ab2c-0adf07274173','bce3affc-015f-4019-ab2c-0adf07274173','1de31656-5fa1-4344-818a-900ef388b939','0eade9d1-05bb-4a8b-8b14-7c17c5653866','deleted'),('2025-12-04 10:42:45.819694','2025-12-04 10:42:49.975460','2025-12-04 10:42:49.974859','c1defaab-6ee1-425e-b76c-646058d8693f','c1defaab-6ee1-425e-b76c-646058d8693f','d7ec0481-b957-40a8-acf9-4ac33a165908','e5014762-4ac0-47d1-a08f-0c344e05238f','deleted'),('2025-12-04 10:44:52.829886','2025-12-04 10:44:56.963640','2025-12-04 10:44:56.963264','cbf6c6ea-2d7a-4222-9bb1-6fa99fad409f','cbf6c6ea-2d7a-4222-9bb1-6fa99fad409f','1de31656-5fa1-4344-818a-900ef388b939','179af611-286e-42bc-8726-44739e474b22','deleted'),('2025-12-04 10:43:15.316010','2025-12-04 10:43:19.262538','2025-12-04 10:43:19.262104','cef08e73-0a1a-410a-befe-672e6b5dd2f2','cef08e73-0a1a-410a-befe-672e6b5dd2f2','ee821ced-1eec-43e8-af63-bd95973cd67b','d883969a-635e-4f02-a48a-473264b0c113','deleted'),('2025-12-04 10:42:24.498608','2025-12-04 10:42:28.528338','2025-12-04 10:42:28.527604','cf54d69f-eed1-46b6-9595-06aa6bcf7c19','cf54d69f-eed1-46b6-9595-06aa6bcf7c19','58ec2fca-4cd4-4393-9127-d135ebc9b908','d1768f4f-78d9-4490-94fd-74da927d5abb','deleted'),('2025-12-04 10:43:00.817519','2025-12-04 10:43:04.777540','2025-12-04 10:43:04.777191','e3992a29-5b38-4f98-b9e3-19fe415a20ea','e3992a29-5b38-4f98-b9e3-19fe415a20ea','ee821ced-1eec-43e8-af63-bd95973cd67b','5f0e66bd-a8b5-48d1-be05-b5cd202bb5a9','deleted'),('2025-12-04 10:43:40.488248','2025-12-04 10:44:03.037138','2025-12-04 10:44:03.036391','e5e231ca-047d-4208-94d5-ad10ca96da7c','e5e231ca-047d-4208-94d5-ad10ca96da7c','264f5d7d-c08e-42d9-b63c-55452b2c5eef','27a61a56-4bd8-4ae5-a27e-0ca48566e1b2','deleted'),('2025-12-04 10:44:59.973613','2025-12-04 10:45:04.199068','2025-12-04 10:45:04.198473','e6cec66e-01ee-4f3e-a05d-68c7b77b8832','e6cec66e-01ee-4f3e-a05d-68c7b77b8832','1de31656-5fa1-4344-818a-900ef388b939','b2cec69b-0c39-43a5-bb78-19f421499c59','deleted'),('2025-12-04 10:46:44.885257','2025-12-04 10:46:49.501318','2025-12-04 10:46:49.500759','eac54b2d-6a45-4168-bd3e-0672aaaf483d','eac54b2d-6a45-4168-bd3e-0672aaaf483d','1de31656-5fa1-4344-818a-900ef388b939','85ad15d7-ea37-4b9d-a666-7c362882198f','deleted'),('2025-12-04 10:46:17.515571','2025-12-04 10:46:21.508372','2025-12-04 10:46:21.508007','ed2a2d8c-82a7-421e-8ec6-b3e88ff09da7','ed2a2d8c-82a7-421e-8ec6-b3e88ff09da7','1de31656-5fa1-4344-818a-900ef388b939','62767153-548f-4ddf-a5f7-1eb6911b8a72','deleted');
/*!40000 ALTER TABLE `share_instance_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instance_export_locations`
--

DROP TABLE IF EXISTS `share_instance_export_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instance_export_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `path` varchar(2000) DEFAULT NULL,
  `share_instance_id` varchar(36) DEFAULT NULL,
  `is_admin_only` tinyint(1) DEFAULT NULL,
  `uuid` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `sel_instance_id_fk` (`share_instance_id`),
  CONSTRAINT `sel_instance_id_fk` FOREIGN KEY (`share_instance_id`) REFERENCES `share_instances` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instance_export_locations`
--

LOCK TABLES `share_instance_export_locations` WRITE;
/*!40000 ALTER TABLE `share_instance_export_locations` DISABLE KEYS */;
INSERT INTO `share_instance_export_locations` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `path`, `share_instance_id`, `is_admin_only`, `uuid`) VALUES (1,'2025-12-04 10:39:12.722245','2025-12-04 10:40:39.663544','2025-12-04 10:40:39.662611',1,'192.168.122.100:6789:/volumes/_nogroup/8589c6fa-15d7-4a25-a420-527b5f3ec7d3/dfcd5d86-8b04-4c9e-b7fc-a8b3dfe0eeb4','8589c6fa-15d7-4a25-a420-527b5f3ec7d3',0,'6185ccb0-bb8c-42df-a82b-bb22bac08a94'),(2,'2025-12-04 10:39:13.431345','2025-12-04 10:39:26.224521','2025-12-04 10:39:26.223440',2,'192.168.122.100:6789:/volumes/_nogroup/e2e2f6bb-d3cb-4e49-9c72-447ac26e9630/ded1c69d-60a5-4683-b853-47a6a2331bac','e2e2f6bb-d3cb-4e49-9c72-447ac26e9630',0,'031dd343-626a-4a8d-9b4a-ee166e92fa56'),(3,'2025-12-04 10:39:16.661955','2025-12-04 10:39:22.161948','2025-12-04 10:39:22.160703',3,'192.168.122.100:6789:/volumes/_nogroup/9a0126db-6550-44ce-a3c1-aa8acaa2b013/11e6b02f-a848-4901-a396-9e1375701b90','9a0126db-6550-44ce-a3c1-aa8acaa2b013',0,'8bbaa3a8-0187-41a7-9640-fc276a832c81'),(4,'2025-12-04 10:39:24.403677','2025-12-04 10:39:58.767814','2025-12-04 10:39:58.766805',4,'192.168.122.100:6789:/volumes/_nogroup/b67a5b53-5bfd-4560-8728-c671b5b695c4/f40d18bc-cd97-4fcd-8483-2659863f3efc','b67a5b53-5bfd-4560-8728-c671b5b695c4',0,'3a6b458a-04c5-4791-8c89-8812616e2b4a'),(5,'2025-12-04 10:39:25.943736','2025-12-04 10:39:30.691293','2025-12-04 10:39:30.690070',5,'192.168.122.100:6789:/volumes/_nogroup/b6f3ec2c-ea96-4c61-9d0a-ba594fe98997/80abc3c2-3b19-4345-a3c6-9ba9356fed24','b6f3ec2c-ea96-4c61-9d0a-ba594fe98997',0,'d2edb1f8-1437-49e0-bf7e-1140a94045af'),(6,'2025-12-04 10:39:28.554557','2025-12-04 10:39:55.065579','2025-12-04 10:39:55.063612',6,'192.168.122.100:6789:/volumes/_nogroup/c01d539d-f169-44cc-bc00-f705cd397a14/59d121f4-da85-41d2-a460-c3e50ff205a8','c01d539d-f169-44cc-bc00-f705cd397a14',0,'f6001d1c-90fb-4e1f-a2ed-3e1db475039d'),(7,'2025-12-04 10:39:28.652221','2025-12-04 10:39:34.120950','2025-12-04 10:39:34.111849',7,'192.168.122.100:6789:/volumes/_nogroup/eafbbd68-3ab6-43b4-96ac-e00e60922483/614ddf80-49a0-47e1-8a8b-70edadadb393','eafbbd68-3ab6-43b4-96ac-e00e60922483',0,'3777e335-d012-495b-aa04-fe7b56a2bc79'),(8,'2025-12-04 10:39:34.522177','2025-12-04 10:39:38.252248','2025-12-04 10:39:38.247089',8,'192.168.122.100:6789:/volumes/_nogroup/2dfe7d61-dd18-4df1-ba8a-2c28cc36210a/c5dc9c35-ebe8-41e2-8bb1-a722819e148b','2dfe7d61-dd18-4df1-ba8a-2c28cc36210a',0,'253f9d39-b7c8-4e3e-af96-5325f548b9b1'),(9,'2025-12-04 10:39:41.792783','2025-12-04 10:39:46.926559','2025-12-04 10:39:46.925112',9,'192.168.122.100:6789:/volumes/_nogroup/082afd37-c266-4ac4-8cb3-b2d98a4b42b6/9a8f2f78-2832-4ae7-987b-f210b3ecae09','082afd37-c266-4ac4-8cb3-b2d98a4b42b6',0,'e1da79dd-4f1d-4059-9d77-05fce76ab2a3'),(10,'2025-12-04 10:39:54.438988','2025-12-04 10:40:02.400615','2025-12-04 10:40:02.399519',10,'192.168.122.100:6789:/volumes/_nogroup/c6122866-729b-4644-a1c7-d8745b4ab929/69a6afba-83cb-47e6-956d-f0583049d7f7','c6122866-729b-4644-a1c7-d8745b4ab929',0,'079699ac-6f81-4f6f-a8e9-6f6412853ab0'),(11,'2025-12-04 10:39:58.299936','2025-12-04 10:40:06.115866','2025-12-04 10:40:06.114796',11,'192.168.122.100:6789:/volumes/_nogroup/bd99e196-9855-42c0-b3ab-7d9a58ace6f7/9fb477bd-f6d6-4a93-81fa-6fa31c946d8f','bd99e196-9855-42c0-b3ab-7d9a58ace6f7',0,'141f65ac-6607-4b1f-9c71-6d3833778606'),(12,'2025-12-04 10:40:06.817165','2025-12-04 10:40:10.958419','2025-12-04 10:40:10.956970',12,'192.168.122.100:6789:/volumes/_nogroup/b863b6ff-799e-4ddb-80e5-dee26b0df34e/2e820380-b271-4f3e-8b24-f787b9d60a68','b863b6ff-799e-4ddb-80e5-dee26b0df34e',0,'d207322d-6037-4216-bc35-d8e914c730fb'),(13,'2025-12-04 10:40:13.070036','2025-12-04 10:40:35.251123','2025-12-04 10:40:35.250083',13,'192.168.122.100:6789:/volumes/_nogroup/980cc482-537a-4856-a203-512899e0bf5c/185c6afc-9ae6-4332-b81a-975debb7627f','980cc482-537a-4856-a203-512899e0bf5c',0,'13aaa6a6-f035-4cff-8983-50587b628f61'),(14,'2025-12-04 10:40:20.437114','2025-12-04 10:40:39.399576','2025-12-04 10:40:39.398605',14,'192.168.122.100:6789:/volumes/_nogroup/86910b9a-b822-4f70-bcbf-6e5bf72bae29/11ab6c18-79c1-476e-b2f1-acdd14fba99c','86910b9a-b822-4f70-bcbf-6e5bf72bae29',0,'855a5035-8061-4036-a99d-4f68deca07da'),(15,'2025-12-04 10:40:22.798653','2025-12-04 10:40:28.257999','2025-12-04 10:40:28.257046',15,'192.168.122.100:6789:/volumes/_nogroup/7cfdcab3-2a40-4b85-9afc-15385e3510f9/3d262762-681b-471d-848e-05e9faf04c07','7cfdcab3-2a40-4b85-9afc-15385e3510f9',0,'7d6022fd-4dbe-475f-87a2-5baeea602933'),(16,'2025-12-04 10:40:39.284350','2025-12-04 10:40:45.815869','2025-12-04 10:40:45.814453',16,'192.168.122.100:6789:/volumes/_nogroup/369e894d-504a-4bdd-99b2-2e34e29db9b4/18a0c018-b882-484c-9916-531fa9d043b1','369e894d-504a-4bdd-99b2-2e34e29db9b4',0,'da3345e2-184d-494a-afc8-56df7a481086'),(17,'2025-12-04 10:40:51.943434','2025-12-04 10:40:58.457536','2025-12-04 10:40:58.456333',17,'192.168.122.100:6789:/volumes/_nogroup/d4a5cb54-f925-4ec3-ad46-31a41be6ac58/2101def7-9ea1-4e61-bdd7-4cd9a9dd7b54','d4a5cb54-f925-4ec3-ad46-31a41be6ac58',0,'73516d09-025c-4035-8d17-46692b81075a'),(18,'2025-12-04 10:40:54.736730','2025-12-04 10:41:13.735759','2025-12-04 10:41:13.734178',18,'192.168.122.100:6789:/volumes/_nogroup/8fa51969-52d7-4794-a864-cda7f0a42b93/869f5edd-b477-4fc8-89df-7313aed09736','8fa51969-52d7-4794-a864-cda7f0a42b93',0,'423e66f8-6351-4520-a32b-857e932b0502'),(19,'2025-12-04 10:41:12.924621','2025-12-04 10:42:04.845349','2025-12-04 10:42:04.844417',19,'192.168.122.100:6789:/volumes/_nogroup/e221725b-e6e8-4c35-9638-fa0fd11665ad/b30d8655-9d07-48f5-9b2a-5c00b9d7715b','e221725b-e6e8-4c35-9638-fa0fd11665ad',0,'79e4154a-0e97-4746-b2dc-dceb1432d77e'),(20,'2025-12-04 10:41:16.671557','2025-12-04 10:41:21.753266','2025-12-04 10:41:21.752230',20,'192.168.122.100:6789:/volumes/_nogroup/3a8de81a-77b5-415f-8412-5f7da4d28502/b0e8816f-0808-444b-8920-ec78ecd56640','3a8de81a-77b5-415f-8412-5f7da4d28502',0,'9412860c-3410-4a8c-a5de-14f44602b783'),(21,'2025-12-04 10:41:25.458749','2025-12-04 10:41:30.665809','2025-12-04 10:41:30.664707',21,'192.168.122.100:6789:/volumes/_nogroup/c1a650b0-8a39-49d0-8761-9a38bedfef6b/7ba28297-c9db-4f6b-88f7-45beda1e2ba0','c1a650b0-8a39-49d0-8761-9a38bedfef6b',0,'ae236ede-8b62-4613-91e8-e2c1c7327de4'),(22,'2025-12-04 10:41:31.141780','2025-12-04 10:41:36.146519','2025-12-04 10:41:36.145623',22,'192.168.122.100:6789:/volumes/_nogroup/8e063322-2225-425c-8041-94c64095457f/d8c06adf-7d8c-42f7-8e3d-861c1d60ede8','8e063322-2225-425c-8041-94c64095457f',0,'4919333b-b80a-4618-abb1-c6c914a6d2b4'),(23,'2025-12-04 10:41:34.232285','2025-12-04 10:41:38.358328','2025-12-04 10:41:38.357467',23,'192.168.122.100:6789:/volumes/_nogroup/b37d179f-5d92-4510-9538-6c9b03887871/37c965e6-b9df-4d0f-8913-3188a3bb9352','b37d179f-5d92-4510-9538-6c9b03887871',0,'daca1211-2cca-4697-a050-c9e4e3b6253b'),(24,'2025-12-04 10:41:42.127224','2025-12-04 10:41:48.758556','2025-12-04 10:41:48.757508',24,'192.168.122.100:6789:/volumes/_nogroup/9a5f4ecd-03b6-407a-8d82-15daa95b5ced/4710ae0a-ec4d-4e62-8fda-a8295c2f620f','9a5f4ecd-03b6-407a-8d82-15daa95b5ced',0,'222050cd-c1b6-452d-919f-e81a79dc4def'),(25,'2025-12-04 10:41:51.722698','2025-12-04 10:41:56.390356','2025-12-04 10:41:56.389289',25,'192.168.122.100:6789:/volumes/_nogroup/c54a12b3-b92e-4a09-81b2-2bfc280d4eaa/a99bfaa6-75dd-4a13-893b-da8b9b54dca0','c54a12b3-b92e-4a09-81b2-2bfc280d4eaa',0,'642b1c88-2bf6-488a-8a41-5116571eb94e'),(26,'2025-12-04 10:41:53.097595','2025-12-04 10:42:00.933523','2025-12-04 10:42:00.932069',26,'192.168.122.100:6789:/volumes/_nogroup/bdae8876-925e-4534-9c67-ead7c1879e8c/c8254e14-3b4f-4a93-a1ae-bdb20560cbeb','bdae8876-925e-4534-9c67-ead7c1879e8c',0,'73e0c241-a135-4a1b-925b-1c5ca81af681'),(27,'2025-12-04 10:41:53.558310','2025-12-04 10:41:57.192124','2025-12-04 10:41:57.191189',27,'192.168.122.100:6789:/volumes/_nogroup/cda2cc19-4836-4171-8f02-990e4046f802/6b0b7784-b07f-495c-ad5e-81986ac7be36','cda2cc19-4836-4171-8f02-990e4046f802',0,'79038a3f-4854-4b80-93a9-7cfb3663d8ff'),(28,'2025-12-04 10:41:54.046317','2025-12-04 10:41:59.534722','2025-12-04 10:41:59.533874',28,'192.168.122.100:6789:/volumes/_nogroup/b3f91f1e-db38-4937-881a-6c033198bb16/31f73d8a-d868-48e2-8b85-21117fdcc89e','b3f91f1e-db38-4937-881a-6c033198bb16',0,'716950e1-43b5-4b68-9d30-20d9249029ee'),(29,'2025-12-04 10:41:59.844697','2025-12-04 10:42:11.310000','2025-12-04 10:42:11.308854',29,'192.168.122.100:6789:/volumes/_nogroup/481aa727-f970-4ad9-94c6-ca9f61924fb8/c8609094-ece1-462b-9a3d-54c307953629','481aa727-f970-4ad9-94c6-ca9f61924fb8',0,'d59ec53d-6e0d-4ac2-8513-d4eb77e6e384'),(30,'2025-12-04 10:42:04.332765','2025-12-04 10:42:08.263277','2025-12-04 10:42:08.261801',30,'192.168.122.100:6789:/volumes/_nogroup/3d22f483-2196-4c24-a6e8-b6086bc6989e/1fa680d2-c7e3-4b92-8668-e87a35555293','3d22f483-2196-4c24-a6e8-b6086bc6989e',0,'bf8ba55e-3d2b-4569-9a69-ea821afc97e1'),(31,'2025-12-04 10:42:16.984938','2025-12-04 10:43:23.180422','2025-12-04 10:43:23.179189',31,'192.168.122.100:6789:/volumes/_nogroup/ee821ced-1eec-43e8-af63-bd95973cd67b/356d3e8a-f0f7-472b-9493-cce2a25c84e8','ee821ced-1eec-43e8-af63-bd95973cd67b',0,'1d96377c-e1c5-4261-9df0-761f4df4e333'),(32,'2025-12-04 10:42:21.240542','2025-12-04 10:42:28.624005','2025-12-04 10:42:28.622901',32,'192.168.122.100:6789:/volumes/_nogroup/58ec2fca-4cd4-4393-9127-d135ebc9b908/3339395c-7998-4a2a-83ee-2fce006949f8','58ec2fca-4cd4-4393-9127-d135ebc9b908',0,'c310fb14-3636-4701-846a-b8d5c50c46cc'),(33,'2025-12-04 10:42:31.817061','2025-12-04 10:42:39.411958','2025-12-04 10:42:39.410975',33,'192.168.122.100:6789:/volumes/_nogroup/c5da5d86-f585-431a-b524-b52c13853cdd/cf9e35a3-eae0-419f-8f76-2382b050c1d0','c5da5d86-f585-431a-b524-b52c13853cdd',0,'8e617b92-74fe-4adc-a26c-8904959e62eb'),(34,'2025-12-04 10:42:42.659941','2025-12-04 10:42:50.086308','2025-12-04 10:42:50.085246',34,'192.168.122.100:6789:/volumes/_nogroup/d7ec0481-b957-40a8-acf9-4ac33a165908/a565891a-3a2d-45ae-abea-99a7488506bf','d7ec0481-b957-40a8-acf9-4ac33a165908',0,'6c5b086c-04e8-43b4-bfcb-9053d1fe2838'),(35,'2025-12-04 10:42:54.187962','2025-12-04 10:42:58.668739','2025-12-04 10:42:58.667650',35,'192.168.122.100:6789:/volumes/_nogroup/24d9d739-98c3-41b3-9e91-5fbf698f4944/12901b2f-0604-4ca2-8ff9-99a77556cca5','24d9d739-98c3-41b3-9e91-5fbf698f4944',0,'17d434f8-967c-4695-9abe-8277fea9fe6d'),(36,'2025-12-04 10:43:02.151199','2025-12-04 10:43:06.187321','2025-12-04 10:43:06.186492',36,'192.168.122.100:6789:/volumes/_nogroup/97fc4d92-2e4d-40fb-86bf-ef965853aa37/9a911faf-043c-4c37-9142-455a2d8f4429','97fc4d92-2e4d-40fb-86bf-ef965853aa37',0,'56ed1ef8-2f3c-4f3d-a5e1-40cfb2f53423'),(37,'2025-12-04 10:43:18.479198','2025-12-04 10:43:30.179456','2025-12-04 10:43:30.178521',37,'192.168.122.100:6789:/volumes/_nogroup/1276f5c4-3479-4622-a6c1-a1fd0508feb3/e2160647-d792-4be6-83e3-0a77d5539fd0','1276f5c4-3479-4622-a6c1-a1fd0508feb3',0,'db2922df-a474-43d7-a503-6f750aa602bc'),(38,'2025-12-04 10:43:20.137453','2025-12-04 10:43:30.636560','2025-12-04 10:43:30.635382',38,'192.168.122.100:6789:/volumes/_nogroup/dba135ca-99df-42d3-a2b3-b27ad79995b7/a711eac5-4d18-4be8-8bdb-d9f7a5922442','dba135ca-99df-42d3-a2b3-b27ad79995b7',0,'e3cd5305-4843-4d4f-afc1-3dc84807ee19'),(39,'2025-12-04 10:43:23.511327','2025-12-04 10:43:26.998897','2025-12-04 10:43:26.997790',39,'192.168.122.100:6789:/volumes/_nogroup/efb32910-eddf-42fc-9d2f-7022478fa2af/251c0bc7-d836-4231-96c8-6099843232d7','efb32910-eddf-42fc-9d2f-7022478fa2af',0,'390310f7-bdff-4ce0-9fe9-5a8381b27444'),(40,'2025-12-04 10:43:34.156228','2025-12-04 10:43:54.662660','2025-12-04 10:43:54.661299',40,'192.168.122.100:6789:/volumes/_nogroup/dec20aa6-db73-446c-9d5e-8597f7adaaa8/051ecf4a-26e7-46f9-b39b-fbfcbd86270e','dec20aa6-db73-446c-9d5e-8597f7adaaa8',0,'e02ebb82-2f53-405f-9106-eb371b13c933'),(41,'2025-12-04 10:43:36.523202','2025-12-04 10:44:40.024752','2025-12-04 10:44:40.023729',41,'192.168.122.100:6789:/volumes/_nogroup/b590878f-f5a4-4c4c-97ac-af9c32c4449c/5260771a-3d40-48ec-b1ac-44fca9eeb9bd','b590878f-f5a4-4c4c-97ac-af9c32c4449c',0,'c4dfe309-f384-46eb-bd2c-81d4cd217ae3'),(42,'2025-12-04 10:43:39.371441','2025-12-04 10:43:42.941380','2025-12-04 10:43:42.939752',42,'192.168.122.100:6789:/volumes/_nogroup/376dc4db-618b-4da3-9877-daf0c0185878/cc465653-3416-44ed-bf17-d6453499d24f','376dc4db-618b-4da3-9877-daf0c0185878',0,'2c3fa68e-b6b3-41d2-9c13-bcff0aab1d32'),(43,'2025-12-04 10:43:40.286974','2025-12-04 10:44:36.314797','2025-12-04 10:44:36.312767',43,'192.168.122.100:6789:/volumes/_nogroup/264f5d7d-c08e-42d9-b63c-55452b2c5eef/3f2b93a1-903b-4a14-b59e-d107f0630d40','264f5d7d-c08e-42d9-b63c-55452b2c5eef',0,'0351e8bd-225b-41bf-a197-1b46b58e4b91'),(44,'2025-12-04 10:43:44.447517','2025-12-04 10:44:32.638025','2025-12-04 10:44:32.636828',44,'192.168.122.100:6789:/volumes/_nogroup/187ec7c1-10e2-40cd-bd3e-105526ebd065/e7c861f3-7356-4619-8b53-f507a1b986c5','187ec7c1-10e2-40cd-bd3e-105526ebd065',0,'c6b6e66b-5837-4640-8af5-a37a48cef4e9'),(45,'2025-12-04 10:43:46.551615','2025-12-04 10:43:50.207440','2025-12-04 10:43:50.205512',45,'192.168.122.100:6789:/volumes/_nogroup/66a8cb6b-a9ba-4b95-98a0-d3ae1eac9889/81816eed-4b43-43d9-9a2c-a8df9562f2c7','66a8cb6b-a9ba-4b95-98a0-d3ae1eac9889',0,'3cc695c7-8d52-47ed-8fda-01a7e3710de5'),(46,'2025-12-04 10:43:52.917256','2025-12-04 10:44:44.090988','2025-12-04 10:44:44.089204',46,'192.168.122.100:6789:/volumes/_nogroup/5260b088-bfa9-4f9a-adc0-a90d452dc12f/92c8c8fb-87d8-4b63-b6fb-001ecf8b1670','5260b088-bfa9-4f9a-adc0-a90d452dc12f',0,'2454f0d0-df7f-47d6-b58b-bc099f2425fb'),(47,'2025-12-04 10:44:06.053189','2025-12-04 10:44:10.847602','2025-12-04 10:44:10.846486',47,'192.168.122.100:6789:/volumes/_nogroup/485981c2-4d65-44e2-a4c4-d55efb5d64b6/f61733c8-f0e2-4864-8c3c-0403ba35205c','485981c2-4d65-44e2-a4c4-d55efb5d64b6',0,'60935b73-3ef4-4021-bf9e-d0bfb1371678'),(48,'2025-12-04 10:44:13.803711','2025-12-04 10:44:28.885747','2025-12-04 10:44:28.884412',48,'192.168.122.100:6789:/volumes/_nogroup/bd4b4cb5-5fca-4376-8188-5f69aab6c36d/06397792-300c-42d8-a6e6-8298e27470f5','bd4b4cb5-5fca-4376-8188-5f69aab6c36d',0,'89016226-4be6-4560-ac8b-d68401b0a339'),(49,'2025-12-04 10:44:28.129268','2025-12-04 10:47:41.000998','2025-12-04 10:47:40.999686',49,'192.168.122.100:6789:/volumes/_nogroup/1de31656-5fa1-4344-818a-900ef388b939/461ab4cd-86b6-4246-a5a8-55c5b0abe8ba','1de31656-5fa1-4344-818a-900ef388b939',0,'d3b38d25-a369-40fd-9e83-028bca42a153'),(50,'2025-12-04 10:45:08.321485','2025-12-04 10:45:35.663386','2025-12-04 10:45:35.661528',50,'192.168.122.100:6789:/volumes/_nogroup/ab4df956-bd5e-4998-a6ef-078628986afd/5793e533-143c-4fc0-b4e1-f51624f69c54','ab4df956-bd5e-4998-a6ef-078628986afd',0,'a1cb3c6c-ba03-4141-85ad-dd8cecb53b14'),(51,'2025-12-04 10:45:12.181467','2025-12-04 10:45:32.149143','2025-12-04 10:45:32.147881',51,'192.168.122.100:6789:/volumes/_nogroup/f4fd84f8-9ca9-412b-a602-9496343f58ed/85f48866-3ba8-4e88-a663-1bdf614917fb','f4fd84f8-9ca9-412b-a602-9496343f58ed',0,'74ac8ea2-f4b4-4a03-8590-1781c94e938b'),(52,'2025-12-04 10:45:16.250230','2025-12-04 10:45:28.811565','2025-12-04 10:45:28.808094',52,'192.168.122.100:6789:/volumes/_nogroup/51dacf2e-4d8f-4133-9ae7-8b2784f31cc5/6b3c2242-9930-48fe-b0aa-20deac217a1b','51dacf2e-4d8f-4133-9ae7-8b2784f31cc5',0,'bec7937c-8544-4edc-92c3-98613ecba433'),(53,'2025-12-04 10:45:20.373941','2025-12-04 10:45:24.987975','2025-12-04 10:45:24.986455',53,'192.168.122.100:6789:/volumes/_nogroup/f7c4e2c1-3b68-4928-815d-84ba9442cbf1/72cd89ce-4efe-4b85-aea5-dc01ea42bb59','f7c4e2c1-3b68-4928-815d-84ba9442cbf1',0,'ef9a5917-1ea4-47e4-aada-5ecd79fbadb2'),(54,'2025-12-04 10:45:56.759475','2025-12-04 10:47:05.337909','2025-12-04 10:47:05.336542',54,'192.168.122.100:6789:/volumes/_nogroup/134bada8-f9d1-4734-8cb9-4d8f094ffc02/709503a4-ece9-4e76-b07e-7f97746dfdf4','134bada8-f9d1-4734-8cb9-4d8f094ffc02',0,'7b921f3b-120f-4b70-aa85-45cddd995fa1'),(55,'2025-12-04 10:46:22.656381','2025-12-04 10:46:58.542815','2025-12-04 10:46:58.534146',55,'192.168.122.100:6789:/volumes/_nogroup/cbd234cb-faf5-4e19-a1b6-ca47791b1043/6434388b-13b0-44fd-9f14-bc4785113c76','cbd234cb-faf5-4e19-a1b6-ca47791b1043',0,'2c54fd8c-6fd6-494d-be67-e65c06dab262'),(56,'2025-12-04 10:46:25.422262','2025-12-04 10:46:32.466402','2025-12-04 10:46:32.464721',56,'192.168.122.100:6789:/volumes/_nogroup/fdc591ae-48a2-4089-a539-01382bacd19f/a2cad645-958b-479a-9a2c-83321704920d','fdc591ae-48a2-4089-a539-01382bacd19f',0,'adb2c51d-620a-4894-b1a5-911254704540'),(57,'2025-12-04 10:46:40.268789','2025-12-04 10:46:47.054887','2025-12-04 10:46:47.053440',57,'192.168.122.100:6789:/volumes/_nogroup/b3ac60cc-8acd-4ed9-b323-017b1c573a49/ef9ff5da-9de6-46b4-9a76-f26d18a22519','b3ac60cc-8acd-4ed9-b323-017b1c573a49',0,'7c9192ad-312d-4ddc-9b9f-ec7fb947bc18'),(58,'2025-12-04 10:46:50.370866','2025-12-04 10:46:55.200070','2025-12-04 10:46:55.198848',58,'192.168.122.100:6789:/volumes/_nogroup/1ae4ad25-1c0a-4f97-a54f-7e86dadb91cf/cf716c94-9722-4ff4-9497-36c129aaac2e','1ae4ad25-1c0a-4f97-a54f-7e86dadb91cf',0,'19eb4014-ba1b-4e09-bef1-4fc123732376'),(59,'2025-12-04 10:47:18.071431','2025-12-04 10:47:28.487874','2025-12-04 10:47:28.486775',59,'192.168.122.100:6789:/volumes/_nogroup/997ad407-3986-4029-acca-2f53511b4ff3/13d4aaa8-c75f-4995-b55e-e3eaac7e47b3','997ad407-3986-4029-acca-2f53511b4ff3',0,'f10dbe44-64fb-4272-bce1-b76e3d3cc9db'),(60,'2025-12-04 10:47:26.202264','2025-12-04 10:47:26.200642',NULL,0,'192.168.122.100:6789:/volumes/_nogroup/e36f2012-530d-4132-9482-586618cf68e8/db8ca860-bdb0-4174-90be-94c2d9735d77','e36f2012-530d-4132-9482-586618cf68e8',0,'672e9af8-612c-4ec4-80f9-e4a5686e1b51'),(61,'2025-12-04 10:47:32.291722','2025-12-04 10:47:43.857983','2025-12-04 10:47:43.856596',61,'192.168.122.100:6789:/volumes/_nogroup/002e05aa-0dc4-4f1b-ba53-39cac0015b96/d0dd193d-277f-49c2-89da-22c500b1172f','002e05aa-0dc4-4f1b-ba53-39cac0015b96',0,'c81b4844-4e96-4009-878e-8dbf233a8cc6'),(62,'2025-12-04 10:47:53.939857','2025-12-04 10:48:05.535593','2025-12-04 10:48:05.534625',62,'192.168.122.100:6789:/volumes/_nogroup/7de2ac86-d29c-49e9-b8b1-f1b9a7934340/8a0ffa48-f0a7-4f73-a336-ef0dc6937c97','7de2ac86-d29c-49e9-b8b1-f1b9a7934340',0,'b2549899-38ee-4fc2-801f-15f3e7a82488'),(63,'2025-12-04 10:47:57.186403','2025-12-04 10:48:07.165819','2025-12-04 10:48:07.164808',63,'192.168.122.100:6789:/volumes/_nogroup/59666e24-d766-4aa9-9e78-1be546c42532/1fd4480b-ac42-4524-a420-91fd304b251c','59666e24-d766-4aa9-9e78-1be546c42532',0,'4c711cc4-2721-4175-9db2-43e7c769dedf'),(64,'2025-12-04 10:48:54.732315','2025-12-04 10:49:05.411444','2025-12-04 10:49:05.410369',64,'192.168.122.100:6789:/volumes/_nogroup/1db2d22c-803f-4ebe-b241-8ba03a81e7dc/3c9b0285-3124-4ba7-b951-215aec98e0e4','1db2d22c-803f-4ebe-b241-8ba03a81e7dc',0,'af66301d-1df1-4a5c-8429-302c82e75e6e'),(65,'2025-12-04 10:49:09.163107','2025-12-04 10:49:12.646228','2025-12-04 10:49:12.644876',65,'192.168.122.100:6789:/volumes/_nogroup/7384c38f-046a-4732-911b-7fca953ef69a/16e840ce-ed12-467f-88c3-048d9d944422','7384c38f-046a-4732-911b-7fca953ef69a',0,'9aa6d832-c5d7-4c5a-b194-e6ee998b33ce'),(66,'2025-12-04 10:49:16.178410','2025-12-04 10:50:35.578260','2025-12-04 10:50:35.577052',66,'192.168.122.100:6789:/volumes/_nogroup/382512d2-4ae6-4a25-96be-5898161f749d/cb682cf0-c1e6-441d-935e-9c8f78e43725','382512d2-4ae6-4a25-96be-5898161f749d',0,'f9b90ca4-0170-4fb3-888d-0d552cddabff'),(67,'2025-12-04 10:50:26.479453','2025-12-04 10:50:29.305838','2025-12-04 10:50:29.304823',67,'192.168.122.100:6789:/volumes/_nogroup/98772187-8e17-49bc-bf03-9548a140f0f9/423a692f-d7d1-49c7-ba07-ce101229d3f2','98772187-8e17-49bc-bf03-9548a140f0f9',0,'48d76011-80c0-49c7-90c8-f5c4e0c6fba6'),(68,'2025-12-04 10:50:50.685984','2025-12-04 10:51:38.318085','2025-12-04 10:51:38.316830',68,'192.168.122.100:6789:/volumes/_nogroup/48e0e8d9-0ebb-4db4-a173-73e6b17560ed/67c71b68-b799-452e-b991-191544991adf','48e0e8d9-0ebb-4db4-a173-73e6b17560ed',0,'4b5d34a3-c5f8-464f-846c-1cb9a98d0934'),(69,'2025-12-04 10:50:58.716138','2025-12-04 10:51:01.992299','2025-12-04 10:51:01.991375',69,'192.168.122.100:6789:/volumes/_nogroup/9dada9dc-6e1e-4a21-96e0-c09b80328b04/2f8aed1d-7200-4215-967a-dbcd84383a27','9dada9dc-6e1e-4a21-96e0-c09b80328b04',0,'55128ada-5077-48b7-aba6-255f3ad9d147'),(70,'2025-12-04 10:51:06.636198','2025-12-04 10:51:09.659105','2025-12-04 10:51:09.658140',70,'192.168.122.100:6789:/volumes/_nogroup/ac41ff8b-3e5d-413c-842a-4731aa5fec9c/3a207827-d5fd-419f-acaa-6c76538172dc','ac41ff8b-3e5d-413c-842a-4731aa5fec9c',0,'61a71206-fea7-491c-ba18-573e0759be4f'),(71,'2025-12-04 10:51:13.091469','2025-12-04 10:51:16.429488','2025-12-04 10:51:16.428415',71,'192.168.122.100:6789:/volumes/_nogroup/1a25a2b9-950c-410a-9ad7-d3f8bbfb3687/d0d02848-9da1-4624-b31a-63cb7ff261f4','1a25a2b9-950c-410a-9ad7-d3f8bbfb3687',0,'16acd2c4-926e-46ee-a03a-109929e67693'),(72,'2025-12-04 10:51:20.180776','2025-12-04 10:51:23.529087','2025-12-04 10:51:23.528025',72,'192.168.122.100:6789:/volumes/_nogroup/22efd76f-f190-4877-9402-6f240297ffab/967bbf13-d2e7-4e83-a18f-dbf7bce7d877','22efd76f-f190-4877-9402-6f240297ffab',0,'4bdc7cba-464a-4cee-8134-92fe63056851'),(73,'2025-12-04 10:51:27.640640','2025-12-04 10:51:30.736536','2025-12-04 10:51:30.735655',73,'192.168.122.100:6789:/volumes/_nogroup/772141e6-25b5-4706-b9c3-ba13ee143838/e384d99e-5dac-4b84-8f41-b08a2fb8f434','772141e6-25b5-4706-b9c3-ba13ee143838',0,'7688df05-3e92-404e-a1f7-ab68fdc5e44c');
/*!40000 ALTER TABLE `share_instance_export_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instance_export_locations_metadata`
--

DROP TABLE IF EXISTS `share_instance_export_locations_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instance_export_locations_metadata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `export_location_id` int(11) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `elm_el_id_uc` (`export_location_id`,`key`,`deleted`),
  CONSTRAINT `elm_id_fk` FOREIGN KEY (`export_location_id`) REFERENCES `share_instance_export_locations` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instance_export_locations_metadata`
--

LOCK TABLES `share_instance_export_locations_metadata` WRITE;
/*!40000 ALTER TABLE `share_instance_export_locations_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_instance_export_locations_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instances`
--

DROP TABLE IF EXISTS `share_instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instances` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `share_id` varchar(36) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `share_network_id` varchar(36) DEFAULT NULL,
  `share_server_id` varchar(36) DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  `access_rules_status` varchar(255) DEFAULT NULL,
  `replica_state` varchar(255) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  `cast_rules_to_readonly` tinyint(1) NOT NULL,
  `progress` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `si_share_network_fk` (`share_network_id`),
  KEY `si_share_server_fk` (`share_server_id`),
  KEY `si_az_id_fk` (`availability_zone_id`),
  KEY `si_st_id_fk` (`share_type_id`),
  KEY `share_instances_share_id_idx` (`share_id`),
  CONSTRAINT `si_az_id_fk` FOREIGN KEY (`availability_zone_id`) REFERENCES `availability_zones` (`id`),
  CONSTRAINT `si_share_fk` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`),
  CONSTRAINT `si_share_network_fk` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`),
  CONSTRAINT `si_share_server_fk` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`),
  CONSTRAINT `si_st_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instances`
--

LOCK TABLES `share_instances` WRITE;
/*!40000 ALTER TABLE `share_instances` DISABLE KEYS */;
INSERT INTO `share_instances` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_id`, `host`, `status`, `scheduled_at`, `launched_at`, `terminated_at`, `share_network_id`, `share_server_id`, `availability_zone_id`, `access_rules_status`, `replica_state`, `share_type_id`, `cast_rules_to_readonly`, `progress`) VALUES ('2025-12-04 10:47:31.967389','2025-12-04 10:47:43.876187','2025-12-04 10:47:43.875479','002e05aa-0dc4-4f1b-ba53-39cac0015b96','002e05aa-0dc4-4f1b-ba53-39cac0015b96','170d65c2-589a-4713-bfa8-09af2cc4d8ad','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:47:32','2025-12-04 10:47:32','2025-12-04 10:47:43',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'7e2e54b3-9fc4-42f1-9682-dfd37ababbc9',0,'100%'),('2025-12-04 10:39:41.526639','2025-12-04 10:39:46.947276','2025-12-04 10:39:46.946608','082afd37-c266-4ac4-8cb3-b2d98a4b42b6','082afd37-c266-4ac4-8cb3-b2d98a4b42b6','2d13d7ce-5d9f-4b3a-afd3-e38005061d43','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:39:41','2025-12-04 10:39:41','2025-12-04 10:39:46',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'e25793d0-774e-4cdf-93f8-ead2edf48a79',0,'100%'),('2025-12-04 10:40:59.607819','2025-12-04 10:41:03.273937','2025-12-04 10:41:03.272616','125adf87-73b5-4488-b47c-8d2925228f89','125adf87-73b5-4488-b47c-8d2925228f89','b4cdc665-be17-46f3-a891-62bcda45f028','','deleted','2025-12-04 10:40:59',NULL,NULL,NULL,NULL,NULL,'active',NULL,'329c3d8c-f588-46f8-a798-2f52b3017ff1',0,NULL),('2025-12-04 10:43:18.256861','2025-12-04 10:43:30.197893','2025-12-04 10:43:30.197359','1276f5c4-3479-4622-a6c1-a1fd0508feb3','1276f5c4-3479-4622-a6c1-a1fd0508feb3','5c6aa58f-f371-4f67-bfaa-356abf09e311','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:43:18','2025-12-04 10:43:18','2025-12-04 10:43:30',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'10e75b0e-4372-4109-8731-61024b16f85c',0,'100%'),('2025-12-04 10:45:56.434088','2025-12-04 10:47:05.354727','2025-12-04 10:47:05.354121','134bada8-f9d1-4734-8cb9-4d8f094ffc02','134bada8-f9d1-4734-8cb9-4d8f094ffc02','54385428-bf5e-4ed6-8708-d0e0ea38cbf4','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:45:56','2025-12-04 10:45:56','2025-12-04 10:47:05',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'ac7bd782-cd71-4f35-9fed-0f011ba5e09d',0,'100%'),('2025-12-04 10:43:44.142281','2025-12-04 10:44:32.653092','2025-12-04 10:44:32.652402','187ec7c1-10e2-40cd-bd3e-105526ebd065','187ec7c1-10e2-40cd-bd3e-105526ebd065','361a365f-e3ed-48f5-b726-d1c98f3a4186','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:43:44','2025-12-04 10:43:44','2025-12-04 10:44:32',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'a2f71277-9b7c-41be-ac23-94904d0c6314',0,'100%'),('2025-12-04 10:51:12.840320','2025-12-04 10:51:16.441892','2025-12-04 10:51:16.441167','1a25a2b9-950c-410a-9ad7-d3f8bbfb3687','1a25a2b9-950c-410a-9ad7-d3f8bbfb3687','c2aec3be-39fc-42a2-8169-8562cab8274a','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:51:12','2025-12-04 10:51:13','2025-12-04 10:51:16',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'6a3c87d9-578e-441f-9691-5571c558f82e',0,'100%'),('2025-12-04 10:46:50.094662','2025-12-04 10:46:55.214206','2025-12-04 10:46:55.213551','1ae4ad25-1c0a-4f97-a54f-7e86dadb91cf','1ae4ad25-1c0a-4f97-a54f-7e86dadb91cf','efc77317-f625-4cff-bcbb-2ce3261acd01','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:46:50','2025-12-04 10:46:50','2025-12-04 10:46:55',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'ac7bd782-cd71-4f35-9fed-0f011ba5e09d',0,'100%'),('2025-12-04 10:48:54.470681','2025-12-04 10:49:05.475860','2025-12-04 10:49:05.475194','1db2d22c-803f-4ebe-b241-8ba03a81e7dc','1db2d22c-803f-4ebe-b241-8ba03a81e7dc','0ba0d9dd-53af-4b75-9763-be9978723501','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:48:54','2025-12-04 10:48:54','2025-12-04 10:49:05',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'067e02e9-90fb-47d1-be2d-f4ea7d81904d',0,'100%'),('2025-12-04 10:44:27.619732','2025-12-04 10:47:41.023791','2025-12-04 10:47:41.023209','1de31656-5fa1-4344-818a-900ef388b939','1de31656-5fa1-4344-818a-900ef388b939','4b1855ba-c5e9-4793-a786-40a54e7585ef','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:44:27','2025-12-04 10:44:28','2025-12-04 10:47:40',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'b022472d-700d-41d8-9151-d06e86a7dc3f',0,'100%'),('2025-12-04 10:51:19.592872','2025-12-04 10:51:23.546877','2025-12-04 10:51:23.546254','22efd76f-f190-4877-9402-6f240297ffab','22efd76f-f190-4877-9402-6f240297ffab','6da520eb-4b5b-4331-a85f-950a1ed4098d','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:51:19','2025-12-04 10:51:20','2025-12-04 10:51:23',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'6a3c87d9-578e-441f-9691-5571c558f82e',0,'100%'),('2025-12-04 10:42:53.966598','2025-12-04 10:42:58.685512','2025-12-04 10:42:58.684649','24d9d739-98c3-41b3-9e91-5fbf698f4944','24d9d739-98c3-41b3-9e91-5fbf698f4944','e4444d21-8f54-411b-8da5-816ca0c15999','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:42:54','2025-12-04 10:42:54','2025-12-04 10:42:58',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'6f383b65-791c-4bc0-a865-8a8a9d0fd30c',0,'100%'),('2025-12-04 10:43:39.998220','2025-12-04 10:44:36.335342','2025-12-04 10:44:36.334744','264f5d7d-c08e-42d9-b63c-55452b2c5eef','264f5d7d-c08e-42d9-b63c-55452b2c5eef','2d436547-41b8-4122-9322-d7f521efcae8','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:43:40','2025-12-04 10:43:40','2025-12-04 10:44:36',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'a2f71277-9b7c-41be-ac23-94904d0c6314',0,'100%'),('2025-12-04 10:39:34.001630','2025-12-04 10:39:38.272755','2025-12-04 10:39:38.271821','2dfe7d61-dd18-4df1-ba8a-2c28cc36210a','2dfe7d61-dd18-4df1-ba8a-2c28cc36210a','268eff16-31f2-495a-b5c6-eaa5c8496407','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:39:34','2025-12-04 10:39:34','2025-12-04 10:39:38',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'e25793d0-774e-4cdf-93f8-ead2edf48a79',0,'100%'),('2025-12-04 10:40:38.825754','2025-12-04 10:40:45.871850','2025-12-04 10:40:45.871303','369e894d-504a-4bdd-99b2-2e34e29db9b4','369e894d-504a-4bdd-99b2-2e34e29db9b4','13c32d00-efd3-469a-8dbb-16c65179e669','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:40:38','2025-12-04 10:40:39','2025-12-04 10:40:45',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'f246ccbd-b6cd-4308-8680-879f81fe8e7d',0,'100%'),('2025-12-04 10:43:39.159832','2025-12-04 10:43:42.963005','2025-12-04 10:43:42.962280','376dc4db-618b-4da3-9877-daf0c0185878','376dc4db-618b-4da3-9877-daf0c0185878','1c19ef78-a3f6-4cc2-849d-7c6974571b73','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:43:39','2025-12-04 10:43:39','2025-12-04 10:43:42',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'820e79dd-be75-4d91-aca0-04a50b785894',0,'100%'),('2025-12-04 10:49:15.931592','2025-12-04 10:50:35.595504','2025-12-04 10:50:35.594965','382512d2-4ae6-4a25-96be-5898161f749d','382512d2-4ae6-4a25-96be-5898161f749d','1914213e-cb38-47c5-bb81-b30cfa67ccaa','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:49:15','2025-12-04 10:49:16','2025-12-04 10:50:35',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'83cb9767-1df4-4921-a073-4398082b463f',0,'100%'),('2025-12-04 10:41:16.381547','2025-12-04 10:41:21.798505','2025-12-04 10:41:21.797979','3a8de81a-77b5-415f-8412-5f7da4d28502','3a8de81a-77b5-415f-8412-5f7da4d28502','a78f725b-6bc2-44e3-9d71-e7536577a76a','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:41:16','2025-12-04 10:41:16','2025-12-04 10:41:21',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'0ccfda71-450e-4fde-bdbe-edefcab4d6c6',0,'100%'),('2025-12-04 10:42:04.076766','2025-12-04 10:42:08.275816','2025-12-04 10:42:08.275295','3d22f483-2196-4c24-a6e8-b6086bc6989e','3d22f483-2196-4c24-a6e8-b6086bc6989e','fcacf240-d104-463d-a1f4-c5973b1e0799','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:42:04','2025-12-04 10:42:04','2025-12-04 10:42:08',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'e97a3463-125a-45ea-9b75-73d586ae1dd9',0,'100%'),('2025-12-04 10:43:05.406012','2025-12-04 10:43:12.956040','2025-12-04 10:43:12.955397','44e126a2-04b4-483c-a9db-129eb3e41e6f','44e126a2-04b4-483c-a9db-129eb3e41e6f','c493aaf0-71d0-4aa8-ab0a-56dba312b5e1','','deleted','2025-12-04 10:43:05',NULL,NULL,NULL,NULL,NULL,'active',NULL,'7793f738-7930-4537-9dfb-f37145dcc966',0,NULL),('2025-12-04 10:41:59.629778','2025-12-04 10:42:11.325490','2025-12-04 10:42:11.324731','481aa727-f970-4ad9-94c6-ca9f61924fb8','481aa727-f970-4ad9-94c6-ca9f61924fb8','d5438395-ae62-4999-9a2d-0118c28ba3a6','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:41:59','2025-12-04 10:41:59','2025-12-04 10:42:11',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'3c978cf0-17b5-4fa5-bacb-dfcf70d53863',0,'100%'),('2025-12-04 10:44:05.588247','2025-12-04 10:44:10.864611','2025-12-04 10:44:10.863852','485981c2-4d65-44e2-a4c4-d55efb5d64b6','485981c2-4d65-44e2-a4c4-d55efb5d64b6','b1336a38-1a5a-47a5-9b90-bf24f6a0a3a2','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:44:05','2025-12-04 10:44:06','2025-12-04 10:44:10',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'d2cb06dc-eba6-4fed-a094-61bf857c0e07',0,'100%'),('2025-12-04 10:50:50.261845','2025-12-04 10:51:38.333617','2025-12-04 10:51:38.332948','48e0e8d9-0ebb-4db4-a173-73e6b17560ed','48e0e8d9-0ebb-4db4-a173-73e6b17560ed','f654838a-e3cf-4ba9-9b3d-f1435cc8f327','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:50:50','2025-12-04 10:50:50','2025-12-04 10:51:38',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'6a3c87d9-578e-441f-9691-5571c558f82e',0,'100%'),('2025-12-04 10:45:15.974115','2025-12-04 10:45:28.843605','2025-12-04 10:45:28.842912','51dacf2e-4d8f-4133-9ae7-8b2784f31cc5','51dacf2e-4d8f-4133-9ae7-8b2784f31cc5','01fe9fef-080a-43fe-bf96-dd9da9f35c9c','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:45:16','2025-12-04 10:45:16','2025-12-04 10:45:28',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'79086422-8620-41bb-ad72-d3d2e0f09707',0,'100%'),('2025-12-04 10:43:52.697711','2025-12-04 10:44:44.126659','2025-12-04 10:44:44.125316','5260b088-bfa9-4f9a-adc0-a90d452dc12f','5260b088-bfa9-4f9a-adc0-a90d452dc12f','adeaaedd-d008-4461-9733-ff7478f34676','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:43:52','2025-12-04 10:43:52','2025-12-04 10:44:43',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'8e1ebbba-1c74-478b-9238-956133ca0d56',0,'100%'),('2025-12-04 10:40:51.059026','2025-12-04 10:40:54.913753','2025-12-04 10:40:54.912575','534dddad-7dc4-40ae-a2e1-46f518f24430','534dddad-7dc4-40ae-a2e1-46f518f24430','4dd303d7-6f90-41b6-af60-24e0e2cf4d18','','deleted','2025-12-04 10:40:51',NULL,NULL,NULL,NULL,NULL,'active',NULL,'d06feb78-408f-46b2-96af-3dfde13231d8',0,NULL),('2025-12-04 10:43:17.427253','2025-12-04 10:43:21.183282','2025-12-04 10:43:21.182709','53ab0263-411c-4a41-bbc3-dd2ddc0af503','53ab0263-411c-4a41-bbc3-dd2ddc0af503','bc39a08c-bd07-4e7f-a89e-4e028e306a5d','','deleted','2025-12-04 10:43:17',NULL,NULL,NULL,NULL,NULL,'active',NULL,'4e0237cc-4b31-40b5-97b2-740edbe506d4',0,NULL),('2025-12-04 10:42:20.970622','2025-12-04 10:42:28.639076','2025-12-04 10:42:28.638453','58ec2fca-4cd4-4393-9127-d135ebc9b908','58ec2fca-4cd4-4393-9127-d135ebc9b908','5c089416-80f4-44d7-ae20-e3205c02b9f6','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:42:21','2025-12-04 10:42:21','2025-12-04 10:42:28',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'df88ce48-d3e8-48b4-aca4-3e96df85fd1c',0,'100%'),('2025-12-04 10:47:55.492396','2025-12-04 10:48:07.189704','2025-12-04 10:48:07.188907','59666e24-d766-4aa9-9e78-1be546c42532','59666e24-d766-4aa9-9e78-1be546c42532','db12e16f-d9ac-495f-a35c-57eb35050f7a','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:47:55','2025-12-04 10:47:57','2025-12-04 10:48:06',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'c0d93c20-f27c-4fec-9d23-328c1d8e67c8',0,'100%'),('2025-12-04 10:41:04.056484','2025-12-04 10:41:07.876599','2025-12-04 10:41:07.875641','59e5c275-5074-4088-8332-e18366ac8123','59e5c275-5074-4088-8332-e18366ac8123','4a9b5b7f-52fb-4050-b6e1-34454246ed23','','deleted','2025-12-04 10:41:04',NULL,NULL,NULL,NULL,NULL,'active',NULL,'010affb4-16b3-42ed-a4b9-506eedbbafdf',0,NULL),('2025-12-04 10:43:01.799285','2025-12-04 10:43:13.335760','2025-12-04 10:43:13.335220','5bc95fe6-e3d9-4aa3-aa92-e59d673fd2c7','5bc95fe6-e3d9-4aa3-aa92-e59d673fd2c7','406666a0-eb51-4632-8678-5b370b2d0962','','deleted','2025-12-04 10:43:01',NULL,NULL,NULL,NULL,NULL,'active',NULL,'51dc31d5-ae2f-4cc3-99b0-d9bca2c752df',0,NULL),('2025-12-04 10:43:46.301637','2025-12-04 10:43:50.289884','2025-12-04 10:43:50.289397','66a8cb6b-a9ba-4b95-98a0-d3ae1eac9889','66a8cb6b-a9ba-4b95-98a0-d3ae1eac9889','12e6a6f6-79d8-47cd-b245-44f853987171','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:43:46','2025-12-04 10:43:46','2025-12-04 10:43:49',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'820e79dd-be75-4d91-aca0-04a50b785894',0,'100%'),('2025-12-04 10:49:08.840208','2025-12-04 10:49:12.675778','2025-12-04 10:49:12.675112','7384c38f-046a-4732-911b-7fca953ef69a','7384c38f-046a-4732-911b-7fca953ef69a','cb03e6de-1192-49e0-b2ea-604752a95429','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:49:08','2025-12-04 10:49:09','2025-12-04 10:49:12',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'8446d21c-69f2-4851-933b-997effa49241',0,'100%'),('2025-12-04 10:51:26.853577','2025-12-04 10:51:30.749783','2025-12-04 10:51:30.749093','772141e6-25b5-4706-b9c3-ba13ee143838','772141e6-25b5-4706-b9c3-ba13ee143838','4e1b7902-892b-4297-a889-3e157e63a171','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:51:26','2025-12-04 10:51:27','2025-12-04 10:51:30',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'6a3c87d9-578e-441f-9691-5571c558f82e',0,'100%'),('2025-12-04 10:43:13.791848','2025-12-04 10:43:21.435542','2025-12-04 10:43:21.434740','79999c51-846c-4a18-92e5-85290829b544','79999c51-846c-4a18-92e5-85290829b544','a96491cf-ee64-4106-a162-8e6498f8325c','','deleted','2025-12-04 10:43:13',NULL,NULL,NULL,NULL,NULL,'active',NULL,'515a821b-2c06-477c-82fe-373c817226c6',0,NULL),('2025-12-04 10:42:53.792329','2025-12-04 10:43:01.448701','2025-12-04 10:43:01.447983','7a77ecbe-cdac-4761-b431-718bf9ba20c5','7a77ecbe-cdac-4761-b431-718bf9ba20c5','665b6605-004e-418d-b53a-1f17b68f6116','','deleted','2025-12-04 10:42:53',NULL,NULL,NULL,NULL,NULL,'active',NULL,'bae4e5c8-4bd0-4aef-8463-ce3e493d8f98',0,NULL),('2025-12-04 10:40:21.176034','2025-12-04 10:40:28.274705','2025-12-04 10:40:28.274168','7cfdcab3-2a40-4b85-9afc-15385e3510f9','7cfdcab3-2a40-4b85-9afc-15385e3510f9','ce57662e-9b34-431b-a98a-70efbe1e2041','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:40:21','2025-12-04 10:40:21','2025-12-04 10:40:28',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'4d11d944-cb21-4896-a25f-1f1bffe11b97',0,'100%'),('2025-12-04 10:47:53.692979','2025-12-04 10:48:05.552222','2025-12-04 10:48:05.551533','7de2ac86-d29c-49e9-b8b1-f1b9a7934340','7de2ac86-d29c-49e9-b8b1-f1b9a7934340','9bd18f54-a7a7-4fe5-b491-e9720402156c','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:47:53','2025-12-04 10:47:53','2025-12-04 10:48:05',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'9f12719f-820d-45f8-8b37-c67efc69baf2',0,'100%'),('2025-12-04 10:39:12.291883','2025-12-04 10:40:39.682096','2025-12-04 10:40:39.681550','8589c6fa-15d7-4a25-a420-527b5f3ec7d3','8589c6fa-15d7-4a25-a420-527b5f3ec7d3','1dd0febb-2713-4235-8387-b1c1deadd402','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:39:12','2025-12-04 10:39:12','2025-12-04 10:40:39',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'e25793d0-774e-4cdf-93f8-ead2edf48a79',0,'100%'),('2025-12-04 10:40:19.887607','2025-12-04 10:40:39.504404','2025-12-04 10:40:39.503797','86910b9a-b822-4f70-bcbf-6e5bf72bae29','86910b9a-b822-4f70-bcbf-6e5bf72bae29','901520d5-7980-429a-b3c0-142b97356ff3','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:40:19','2025-12-04 10:40:20','2025-12-04 10:40:39',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'9d536774-c83d-47c8-953e-f319caf6de44',0,'100%'),('2025-12-04 10:41:30.918582','2025-12-04 10:41:36.161119','2025-12-04 10:41:36.160449','8e063322-2225-425c-8041-94c64095457f','8e063322-2225-425c-8041-94c64095457f','44395325-f4a7-46bd-9284-344f55b95b3e','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:41:30','2025-12-04 10:41:31','2025-12-04 10:41:35',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'2b8fd021-e19e-4963-9125-9f006d6d6090',0,'100%'),('2025-12-04 10:40:54.296065','2025-12-04 10:41:13.763891','2025-12-04 10:41:13.763058','8fa51969-52d7-4794-a864-cda7f0a42b93','8fa51969-52d7-4794-a864-cda7f0a42b93','f33036ec-7ba1-4fef-81d8-c51952f358ab','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:40:54','2025-12-04 10:40:54','2025-12-04 10:41:13',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'ec0655e6-90b3-4d12-b523-1f54eacdc7a3',0,'100%'),('2025-12-04 10:43:01.914121','2025-12-04 10:43:06.202810','2025-12-04 10:43:06.202201','97fc4d92-2e4d-40fb-86bf-ef965853aa37','97fc4d92-2e4d-40fb-86bf-ef965853aa37','0d26c116-5607-4a7f-87c1-6007280ba3d5','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:43:01','2025-12-04 10:43:02','2025-12-04 10:43:06',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'6f383b65-791c-4bc0-a865-8a8a9d0fd30c',0,'100%'),('2025-12-04 10:40:12.582710','2025-12-04 10:40:35.265755','2025-12-04 10:40:35.265174','980cc482-537a-4856-a203-512899e0bf5c','980cc482-537a-4856-a203-512899e0bf5c','532e3f15-999c-4216-a263-82e17255e7b7','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:40:12','2025-12-04 10:40:13','2025-12-04 10:40:34',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'4d11d944-cb21-4896-a25f-1f1bffe11b97',0,'100%'),('2025-12-04 10:49:22.977229','2025-12-04 10:50:29.321292','2025-12-04 10:50:29.320709','98772187-8e17-49bc-bf03-9548a140f0f9','98772187-8e17-49bc-bf03-9548a140f0f9','d1679b02-3e6b-4d87-bdfb-fde348e3e3f4','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:49:22','2025-12-04 10:49:23','2025-12-04 10:50:28',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'83cb9767-1df4-4921-a073-4398082b463f',0,'100%'),('2025-12-04 10:47:17.696990','2025-12-04 10:47:28.555906','2025-12-04 10:47:28.555297','997ad407-3986-4029-acca-2f53511b4ff3','997ad407-3986-4029-acca-2f53511b4ff3','65aad31d-e919-4d8f-8fd3-e6f5cb57e829','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:47:17','2025-12-04 10:47:18','2025-12-04 10:47:28',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'7e2e54b3-9fc4-42f1-9682-dfd37ababbc9',0,'100%'),('2025-12-04 10:39:16.405680','2025-12-04 10:39:22.181582','2025-12-04 10:39:22.180430','9a0126db-6550-44ce-a3c1-aa8acaa2b013','9a0126db-6550-44ce-a3c1-aa8acaa2b013','7a5b2716-25cd-4893-be6a-f0a300f15ed4','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:39:16','2025-12-04 10:39:16','2025-12-04 10:39:21',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'e25793d0-774e-4cdf-93f8-ead2edf48a79',0,'100%'),('2025-12-04 10:41:41.786781','2025-12-04 10:41:48.939640','2025-12-04 10:41:48.938100','9a5f4ecd-03b6-407a-8d82-15daa95b5ced','9a5f4ecd-03b6-407a-8d82-15daa95b5ced','dcb1d53e-5a72-4bbf-9851-74a087495374','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:41:41','2025-12-04 10:41:42','2025-12-04 10:41:48',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'0ccfda71-450e-4fde-bdbe-edefcab4d6c6',0,'100%'),('2025-12-04 10:50:58.049809','2025-12-04 10:51:02.088174','2025-12-04 10:51:02.087307','9dada9dc-6e1e-4a21-96e0-c09b80328b04','9dada9dc-6e1e-4a21-96e0-c09b80328b04','25c86dd0-9947-4fab-aeec-44acb1fe4a67','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:50:58','2025-12-04 10:50:58','2025-12-04 10:51:01',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'6a3c87d9-578e-441f-9691-5571c558f82e',0,'100%'),('2025-12-04 10:45:08.090165','2025-12-04 10:45:35.686389','2025-12-04 10:45:35.685794','ab4df956-bd5e-4998-a6ef-078628986afd','ab4df956-bd5e-4998-a6ef-078628986afd','94798190-fa7d-43ed-a870-3834bf6060ce','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:45:08','2025-12-04 10:45:08','2025-12-04 10:45:35',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'79086422-8620-41bb-ad72-d3d2e0f09707',0,'100%'),('2025-12-04 10:51:05.669601','2025-12-04 10:51:09.764686','2025-12-04 10:51:09.764147','ac41ff8b-3e5d-413c-842a-4731aa5fec9c','ac41ff8b-3e5d-413c-842a-4731aa5fec9c','33128045-ffb6-4396-a95d-a1eebcb0fa90','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:51:05','2025-12-04 10:51:06','2025-12-04 10:51:09',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'6a3c87d9-578e-441f-9691-5571c558f82e',0,'100%'),('2025-12-04 10:42:57.523864','2025-12-04 10:43:01.116552','2025-12-04 10:43:01.116004','afdd50cd-18be-417b-a444-9f2e9307ad99','afdd50cd-18be-417b-a444-9f2e9307ad99','50f6ffa5-e4d1-4eae-a0e2-fe753a678f28','','deleted','2025-12-04 10:42:57',NULL,NULL,NULL,NULL,NULL,'active',NULL,'ce0f25d3-27ba-44eb-9b51-7c8fa400875f',0,NULL),('2025-12-04 10:43:08.956108','2025-12-04 10:43:12.605524','2025-12-04 10:43:12.604657','b122ff6a-da87-4bf2-bf3d-bfd5d7fb8a6e','b122ff6a-da87-4bf2-bf3d-bfd5d7fb8a6e','850b0fc4-18a5-4aa9-bf46-67bcab0819c7','','deleted','2025-12-04 10:43:08',NULL,NULL,NULL,NULL,NULL,'active',NULL,'6836a084-0716-44fd-a4c3-db6585ee754e',0,NULL),('2025-12-04 10:42:45.257266','2025-12-04 10:42:49.350000','2025-12-04 10:42:49.349364','b2c3f58f-d672-4c0c-a145-c4989cd1d426','b2c3f58f-d672-4c0c-a145-c4989cd1d426','a51b5720-8d25-430a-9757-2e06540ba073','','deleted','2025-12-04 10:42:45',NULL,NULL,NULL,NULL,NULL,'active',NULL,'d20023e3-0d3f-4f8d-bc4b-35c7fd908150',0,NULL),('2025-12-04 10:41:33.990952','2025-12-04 10:41:38.370658','2025-12-04 10:41:38.369796','b37d179f-5d92-4510-9538-6c9b03887871','b37d179f-5d92-4510-9538-6c9b03887871','f5860a15-20fa-4790-a9e1-6bd3ffc4acfa','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:41:34','2025-12-04 10:41:34','2025-12-04 10:41:38',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'0ccfda71-450e-4fde-bdbe-edefcab4d6c6',0,'100%'),('2025-12-04 10:46:40.021245','2025-12-04 10:46:47.073632','2025-12-04 10:46:47.072669','b3ac60cc-8acd-4ed9-b323-017b1c573a49','b3ac60cc-8acd-4ed9-b323-017b1c573a49','0c16fde6-e8f2-4f39-bddb-65803e1ce106','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:46:40','2025-12-04 10:46:40','2025-12-04 10:46:46',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'ac7bd782-cd71-4f35-9fed-0f011ba5e09d',0,'100%'),('2025-12-04 10:41:53.762266','2025-12-04 10:41:59.547035','2025-12-04 10:41:59.546284','b3f91f1e-db38-4937-881a-6c033198bb16','b3f91f1e-db38-4937-881a-6c033198bb16','ecbda702-f36b-4198-aa8c-26a2f24dbd69','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:41:53','2025-12-04 10:41:54','2025-12-04 10:41:59',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'0ccfda71-450e-4fde-bdbe-edefcab4d6c6',0,'100%'),('2025-12-04 10:43:36.246543','2025-12-04 10:44:40.040019','2025-12-04 10:44:40.039381','b590878f-f5a4-4c4c-97ac-af9c32c4449c','b590878f-f5a4-4c4c-97ac-af9c32c4449c','51f18aea-3533-4ddd-9c2c-1452cdefca48','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:43:36','2025-12-04 10:43:36','2025-12-04 10:44:39',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'4c300d44-f839-46b6-b125-41134ef8ee22',0,'100%'),('2025-12-04 10:39:23.901838','2025-12-04 10:39:58.781718','2025-12-04 10:39:58.781145','b67a5b53-5bfd-4560-8728-c671b5b695c4','b67a5b53-5bfd-4560-8728-c671b5b695c4','9e93d3e8-16df-4d75-9974-bb27d5856c78','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:39:23','2025-12-04 10:39:24','2025-12-04 10:39:58',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'f9c9ca5f-6992-4730-8113-73ad975de651',0,'100%'),('2025-12-04 10:39:25.556101','2025-12-04 10:39:30.868724','2025-12-04 10:39:30.868081','b6f3ec2c-ea96-4c61-9d0a-ba594fe98997','b6f3ec2c-ea96-4c61-9d0a-ba594fe98997','e38a12c0-b894-428c-9c12-398ff2a4b8c5','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:39:25','2025-12-04 10:39:25','2025-12-04 10:39:30',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'e25793d0-774e-4cdf-93f8-ead2edf48a79',0,'100%'),('2025-12-04 10:40:06.547246','2025-12-04 10:40:10.975940','2025-12-04 10:40:10.975360','b863b6ff-799e-4ddb-80e5-dee26b0df34e','b863b6ff-799e-4ddb-80e5-dee26b0df34e','1f778e10-afb1-46f6-a83f-f19861ae9078','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:40:06','2025-12-04 10:40:06','2025-12-04 10:40:10',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'fbcd210b-f4b4-4f9a-b567-b1dd820eb42f',0,'100%'),('2025-12-04 10:44:13.539783','2025-12-04 10:44:28.902562','2025-12-04 10:44:28.901900','bd4b4cb5-5fca-4376-8188-5f69aab6c36d','bd4b4cb5-5fca-4376-8188-5f69aab6c36d','d9c7ad6d-0886-4bc8-aeea-f4d0267bd9ea','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:44:13','2025-12-04 10:44:13','2025-12-04 10:44:28',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'4c300d44-f839-46b6-b125-41134ef8ee22',0,'100%'),('2025-12-04 10:39:57.961183','2025-12-04 10:40:06.131218','2025-12-04 10:40:06.130396','bd99e196-9855-42c0-b3ab-7d9a58ace6f7','bd99e196-9855-42c0-b3ab-7d9a58ace6f7','b8a5d43b-f887-40e6-bb24-a6d455e76df6','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:39:58','2025-12-04 10:39:58','2025-12-04 10:40:05',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'110b6a77-eee0-4f8c-ab3d-25dd7aa6b52e',0,'100%'),('2025-12-04 10:41:52.870975','2025-12-04 10:42:00.953299','2025-12-04 10:42:00.952585','bdae8876-925e-4534-9c67-ead7c1879e8c','bdae8876-925e-4534-9c67-ead7c1879e8c','0a2752ac-2225-4560-a011-76c6043ebc6c','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:41:52','2025-12-04 10:41:53','2025-12-04 10:42:00',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'e97a3463-125a-45ea-9b75-73d586ae1dd9',0,'100%'),('2025-12-04 10:39:28.146693','2025-12-04 10:39:55.092220','2025-12-04 10:39:55.091624','c01d539d-f169-44cc-bc00-f705cd397a14','c01d539d-f169-44cc-bc00-f705cd397a14','dd36da1e-4dae-4e6b-ad72-3ba4034e7b70','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:39:28','2025-12-04 10:39:28','2025-12-04 10:39:54',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'fad6562a-6c8b-4475-a01e-8a7d1d4a728b',0,'100%'),('2025-12-04 10:41:24.996293','2025-12-04 10:41:30.681228','2025-12-04 10:41:30.680617','c1a650b0-8a39-49d0-8761-9a38bedfef6b','c1a650b0-8a39-49d0-8761-9a38bedfef6b','1829b41d-c21f-4aae-ad0b-d90348cd0d0a','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:41:25','2025-12-04 10:41:25','2025-12-04 10:41:30',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'0ccfda71-450e-4fde-bdbe-edefcab4d6c6',0,'100%'),('2025-12-04 10:43:21.700842','2025-12-04 10:43:25.259224','2025-12-04 10:43:25.258492','c544f2a5-0754-4e90-9d68-68c04979ec15','c544f2a5-0754-4e90-9d68-68c04979ec15','a654aa17-07c6-4343-ad06-34841716aced','','deleted','2025-12-04 10:43:21',NULL,NULL,NULL,NULL,NULL,'active',NULL,'a1ec9089-0fd2-48fb-bf6a-18efd8277aeb',0,NULL),('2025-12-04 10:41:51.350305','2025-12-04 10:41:56.408725','2025-12-04 10:41:56.408119','c54a12b3-b92e-4a09-81b2-2bfc280d4eaa','c54a12b3-b92e-4a09-81b2-2bfc280d4eaa','8fd99358-d8c7-47f6-afb5-e68a5184927e','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:41:51','2025-12-04 10:41:51','2025-12-04 10:41:56',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'2537e953-bb9f-4f01-aa9d-2ca546adc331',0,'100%'),('2025-12-04 10:42:31.567957','2025-12-04 10:42:39.432233','2025-12-04 10:42:39.431672','c5da5d86-f585-431a-b524-b52c13853cdd','c5da5d86-f585-431a-b524-b52c13853cdd','46a22168-c576-4b32-8268-3052b32d9157','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:42:31','2025-12-04 10:42:31','2025-12-04 10:42:38',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'df88ce48-d3e8-48b4-aca4-3e96df85fd1c',0,'100%'),('2025-12-04 10:39:54.206308','2025-12-04 10:40:02.453356','2025-12-04 10:40:02.452557','c6122866-729b-4644-a1c7-d8745b4ab929','c6122866-729b-4644-a1c7-d8745b4ab929','eb2f745a-806a-46cb-87a3-0e4e4c960116','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:39:54','2025-12-04 10:39:54','2025-12-04 10:40:02',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'fbfa7e24-ec90-46ae-a6e9-92f64f43ac9c',0,'100%'),('2025-12-04 10:46:03.362244','2025-12-04 10:46:58.559525','2025-12-04 10:46:58.558933','cbd234cb-faf5-4e19-a1b6-ca47791b1043','cbd234cb-faf5-4e19-a1b6-ca47791b1043','9f0837ec-6774-48b2-bb60-211b77035e24','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:46:03','2025-12-04 10:46:03','2025-12-04 10:46:58',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'ac7bd782-cd71-4f35-9fed-0f011ba5e09d',0,'100%'),('2025-12-04 10:41:53.341085','2025-12-04 10:41:57.204574','2025-12-04 10:41:57.203987','cda2cc19-4836-4171-8f02-990e4046f802','cda2cc19-4836-4171-8f02-990e4046f802','95690aab-70df-44f3-888e-5c2ff20d54d6','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:41:53','2025-12-04 10:41:53','2025-12-04 10:41:57',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'e97a3463-125a-45ea-9b75-73d586ae1dd9',0,'100%'),('2025-12-04 10:42:49.667679','2025-12-04 10:42:53.350209','2025-12-04 10:42:53.349348','cfac0d8d-8697-4735-9060-a38e66ea77c1','cfac0d8d-8697-4735-9060-a38e66ea77c1','f802df4a-4841-44d6-885d-f5daf8f6bbe9','','deleted','2025-12-04 10:42:49',NULL,NULL,NULL,NULL,NULL,'active',NULL,'6689d307-ef56-40d7-ad85-62dddaf7d4ba',0,NULL),('2025-12-04 10:40:51.421771','2025-12-04 10:40:58.480523','2025-12-04 10:40:58.479558','d4a5cb54-f925-4ec3-ad46-31a41be6ac58','d4a5cb54-f925-4ec3-ad46-31a41be6ac58','9b6a2356-1ed1-4c57-acd8-e2e725f1104a','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:40:51','2025-12-04 10:40:51','2025-12-04 10:40:58',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'3d827517-5ff1-48c1-8133-89cd1d41e9bd',0,'100%'),('2025-12-04 10:42:42.214523','2025-12-04 10:42:50.102735','2025-12-04 10:42:50.102145','d7ec0481-b957-40a8-acf9-4ac33a165908','d7ec0481-b957-40a8-acf9-4ac33a165908','2ad065b7-ef88-4d1b-bf36-9dcd4fcd6071','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:42:42','2025-12-04 10:42:42','2025-12-04 10:42:49',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'df88ce48-d3e8-48b4-aca4-3e96df85fd1c',0,'100%'),('2025-12-04 10:43:19.864278','2025-12-04 10:43:30.655116','2025-12-04 10:43:30.654558','dba135ca-99df-42d3-a2b3-b27ad79995b7','dba135ca-99df-42d3-a2b3-b27ad79995b7','2f1a8220-3e00-4f0a-9dac-fb3bda10481f','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:43:19','2025-12-04 10:43:20','2025-12-04 10:43:30',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'820e79dd-be75-4d91-aca0-04a50b785894',0,'100%'),('2025-12-04 10:43:33.876322','2025-12-04 10:43:54.696312','2025-12-04 10:43:54.695105','dec20aa6-db73-446c-9d5e-8597f7adaaa8','dec20aa6-db73-446c-9d5e-8597f7adaaa8','ac64d4c6-95c7-42bd-ae98-ee18c21bfd68','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:43:33','2025-12-04 10:43:34','2025-12-04 10:43:54',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'670a24d3-016f-4e59-b59c-2a560b5418dd',0,'100%'),('2025-12-04 10:41:08.433905','2025-12-04 10:41:11.985310','2025-12-04 10:41:11.984544','dfaeb6eb-2db2-4064-b867-146e1ecdc996','dfaeb6eb-2db2-4064-b867-146e1ecdc996','3d37a571-abf6-466d-bed4-9732cbd34327','','deleted','2025-12-04 10:41:08',NULL,NULL,NULL,NULL,NULL,'active',NULL,'9327d215-d4cc-4d4f-9783-f891100659fa',0,NULL),('2025-12-04 10:41:12.673894','2025-12-04 10:42:04.857753','2025-12-04 10:42:04.857282','e221725b-e6e8-4c35-9638-fa0fd11665ad','e221725b-e6e8-4c35-9638-fa0fd11665ad','6e8cdd4d-9cb6-49a2-984e-b1bc7db84e85','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:41:12','2025-12-04 10:41:12','2025-12-04 10:42:04',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'0ccfda71-450e-4fde-bdbe-edefcab4d6c6',0,'100%'),('2025-12-04 10:39:13.146218','2025-12-04 10:39:26.284117','2025-12-04 10:39:26.283407','e2e2f6bb-d3cb-4e49-9c72-447ac26e9630','e2e2f6bb-d3cb-4e49-9c72-447ac26e9630','5f478d7d-5f16-457c-9a2e-0a5b051814ba','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:39:13','2025-12-04 10:39:13','2025-12-04 10:39:26',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'703ba806-b6aa-4733-8c75-4e18892fffb1',0,'100%'),('2025-12-04 10:47:25.937327','2025-12-04 10:47:33.314022',NULL,'False','e36f2012-530d-4132-9482-586618cf68e8','a8f732d1-1b5d-49d8-8c55-52087c9cecb1','hostgroup@cephfs#cephfs','available','2025-12-04 10:47:25','2025-12-04 10:47:26',NULL,NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'b022472d-700d-41d8-9151-d06e86a7dc3f',0,'100%'),('2025-12-04 10:40:55.401391','2025-12-04 10:40:58.882289','2025-12-04 10:40:58.881412','eaa3a4a1-b567-48e6-ade6-1144dbcaddff','eaa3a4a1-b567-48e6-ade6-1144dbcaddff','c4b62a45-3848-4567-b3a2-b712c3febc47','','deleted','2025-12-04 10:40:55',NULL,NULL,NULL,NULL,NULL,'active',NULL,'37563d7b-fcdb-4c5f-b9db-cf6680a53c05',0,NULL),('2025-12-04 10:39:28.263079','2025-12-04 10:39:34.163149','2025-12-04 10:39:34.162496','eafbbd68-3ab6-43b4-96ac-e00e60922483','eafbbd68-3ab6-43b4-96ac-e00e60922483','ec689bc5-f578-4be4-b1e5-6942ec38d2cb','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:39:28','2025-12-04 10:39:28','2025-12-04 10:39:33',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'c8b2d54e-9dae-4635-aff6-dcbbe64d4236',0,'100%'),('2025-12-04 10:42:16.596429','2025-12-04 10:43:23.199193','2025-12-04 10:43:23.198628','ee821ced-1eec-43e8-af63-bd95973cd67b','ee821ced-1eec-43e8-af63-bd95973cd67b','ad85dcc5-0d0d-4da4-81ed-bc7e8e2edbe7','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:42:16','2025-12-04 10:42:17','2025-12-04 10:43:23',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'df88ce48-d3e8-48b4-aca4-3e96df85fd1c',0,'100%'),('2025-12-04 10:43:23.305454','2025-12-04 10:43:27.017272','2025-12-04 10:43:27.016571','efb32910-eddf-42fc-9d2f-7022478fa2af','efb32910-eddf-42fc-9d2f-7022478fa2af','af43a924-d75a-47d8-a62d-541b64ecb513','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:43:23','2025-12-04 10:43:23','2025-12-04 10:43:26',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'820e79dd-be75-4d91-aca0-04a50b785894',0,'100%'),('2025-12-04 10:45:11.952284','2025-12-04 10:45:32.175811','2025-12-04 10:45:32.175257','f4fd84f8-9ca9-412b-a602-9496343f58ed','f4fd84f8-9ca9-412b-a602-9496343f58ed','294ace96-b929-46cc-ba31-c3325815b6a3','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:45:12','2025-12-04 10:45:12','2025-12-04 10:45:31',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'79086422-8620-41bb-ad72-d3d2e0f09707',0,'100%'),('2025-12-04 10:45:20.026401','2025-12-04 10:45:25.011876','2025-12-04 10:45:25.010425','f7c4e2c1-3b68-4928-815d-84ba9442cbf1','f7c4e2c1-3b68-4928-815d-84ba9442cbf1','61860e1a-3994-4032-baac-83323e59c0a3','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:45:20','2025-12-04 10:45:20','2025-12-04 10:45:24',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'79086422-8620-41bb-ad72-d3d2e0f09707',0,'100%'),('2025-12-04 10:46:25.183152','2025-12-04 10:46:32.481880','2025-12-04 10:46:32.481200','fdc591ae-48a2-4089-a539-01382bacd19f','fdc591ae-48a2-4089-a539-01382bacd19f','25fe926c-9268-41b8-88c9-b70413a29311','hostgroup@cephfs#cephfs','deleted','2025-12-04 10:46:25','2025-12-04 10:46:25','2025-12-04 10:46:32',NULL,NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','active',NULL,'ac7bd782-cd71-4f35-9fed-0f011ba5e09d',0,'100%');
/*!40000 ALTER TABLE `share_instances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_metadata`
--

DROP TABLE IF EXISTS `share_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_metadata` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `share_id` (`share_id`),
  CONSTRAINT `share_metadata_ibfk_1` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=108 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_metadata`
--

LOCK TABLES `share_metadata` WRITE;
/*!40000 ALTER TABLE `share_metadata` DISABLE KEYS */;
INSERT INTO `share_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_id`, `key`, `value`) VALUES ('2025-12-04 10:39:12.696809',NULL,'2025-12-04 10:40:39.691944',1,1,'1dd0febb-2713-4235-8387-b1c1deadd402','__mount_options','fs=cephfs'),('2025-12-04 10:39:13.420835',NULL,'2025-12-04 10:39:26.309348',2,2,'5f478d7d-5f16-457c-9a2e-0a5b051814ba','__mount_options','fs=cephfs'),('2025-12-04 10:39:16.627634',NULL,'2025-12-04 10:39:22.243734',3,3,'7a5b2716-25cd-4893-be6a-f0a300f15ed4','__mount_options','fs=cephfs'),('2025-12-04 10:39:24.394506',NULL,'2025-12-04 10:39:58.795970',4,4,'9e93d3e8-16df-4d75-9974-bb27d5856c78','__mount_options','fs=cephfs'),('2025-12-04 10:39:25.920744',NULL,'2025-12-04 10:39:30.881074',5,5,'e38a12c0-b894-428c-9c12-398ff2a4b8c5','__mount_options','fs=cephfs'),('2025-12-04 10:39:28.512260',NULL,'2025-12-04 10:39:55.101744',6,6,'dd36da1e-4dae-4e6b-ad72-3ba4034e7b70','__mount_options','fs=cephfs'),('2025-12-04 10:39:28.639587',NULL,'2025-12-04 10:39:34.181713',7,7,'ec689bc5-f578-4be4-b1e5-6942ec38d2cb','__mount_options','fs=cephfs'),('2025-12-04 10:39:34.502240',NULL,'2025-12-04 10:39:38.295943',8,8,'268eff16-31f2-495a-b5c6-eaa5c8496407','__mount_options','fs=cephfs'),('2025-12-04 10:39:41.776658',NULL,'2025-12-04 10:39:46.967097',9,9,'2d13d7ce-5d9f-4b3a-afd3-e38005061d43','__mount_options','fs=cephfs'),('2025-12-04 10:39:54.426907',NULL,'2025-12-04 10:40:02.472954',10,10,'eb2f745a-806a-46cb-87a3-0e4e4c960116','__mount_options','fs=cephfs'),('2025-12-04 10:39:58.284313',NULL,'2025-12-04 10:40:06.143870',11,11,'b8a5d43b-f887-40e6-bb24-a6d455e76df6','__mount_options','fs=cephfs'),('2025-12-04 10:40:06.793834',NULL,'2025-12-04 10:40:10.989507',12,12,'1f778e10-afb1-46f6-a83f-f19861ae9078','__mount_options','fs=cephfs'),('2025-12-04 10:40:12.537671',NULL,'2025-12-04 10:40:35.275205',13,13,'532e3f15-999c-4216-a263-82e17255e7b7','foo_key_share_1','foo_value_share_1'),('2025-12-04 10:40:12.538191',NULL,'2025-12-04 10:40:35.275205',14,14,'532e3f15-999c-4216-a263-82e17255e7b7','bar_key_share_1','foo_value_share_1'),('2025-12-04 10:40:13.046643',NULL,'2025-12-04 10:40:35.275205',15,15,'532e3f15-999c-4216-a263-82e17255e7b7','__mount_options','fs=cephfs'),('2025-12-04 10:40:20.427905',NULL,'2025-12-04 10:40:39.520261',16,16,'901520d5-7980-429a-b3c0-142b97356ff3','__mount_options','fs=cephfs'),('2025-12-04 10:40:21.136703',NULL,'2025-12-04 10:40:28.288234',17,17,'ce57662e-9b34-431b-a98a-70efbe1e2041','foo_key_share_2','foo_value_share_2'),('2025-12-04 10:40:21.137290',NULL,'2025-12-04 10:40:28.288234',18,18,'ce57662e-9b34-431b-a98a-70efbe1e2041','bar_key_share_2','foo_value_share_2'),('2025-12-04 10:40:21.503242',NULL,'2025-12-04 10:40:28.288234',19,19,'ce57662e-9b34-431b-a98a-70efbe1e2041','__mount_options','fs=cephfs'),('2025-12-04 10:40:39.264298',NULL,'2025-12-04 10:40:45.880985',20,20,'13c32d00-efd3-469a-8dbb-16c65179e669','__mount_options','fs=cephfs'),('2025-12-04 10:40:51.932354',NULL,'2025-12-04 10:40:58.500164',21,21,'9b6a2356-1ed1-4c57-acd8-e2e725f1104a','__mount_options','fs=cephfs'),('2025-12-04 10:40:54.712607',NULL,'2025-12-04 10:41:13.775466',22,22,'f33036ec-7ba1-4fef-81d8-c51952f358ab','__mount_options','fs=cephfs'),('2025-12-04 10:41:12.912105',NULL,'2025-12-04 10:42:04.866427',23,23,'6e8cdd4d-9cb6-49a2-984e-b1bc7db84e85','__mount_options','fs=cephfs'),('2025-12-04 10:41:16.659665',NULL,'2025-12-04 10:41:21.806902',24,24,'a78f725b-6bc2-44e3-9d71-e7536577a76a','__mount_options','fs=cephfs'),('2025-12-04 10:41:20.153303',NULL,'2025-12-04 10:41:21.806902',25,25,'a78f725b-6bc2-44e3-9d71-e7536577a76a','key5','value5'),('2025-12-04 10:41:20.162223',NULL,'2025-12-04 10:41:21.806902',26,26,'a78f725b-6bc2-44e3-9d71-e7536577a76a','key6','value6'),('2025-12-04 10:41:20.753304',NULL,'2025-12-04 10:41:21.806902',27,27,'a78f725b-6bc2-44e3-9d71-e7536577a76a','key7','value7'),('2025-12-04 10:41:20.758781',NULL,'2025-12-04 10:41:21.806902',28,28,'a78f725b-6bc2-44e3-9d71-e7536577a76a','key8','value8'),('2025-12-04 10:41:25.428494',NULL,'2025-12-04 10:41:30.693829',29,29,'1829b41d-c21f-4aae-ad0b-d90348cd0d0a','__mount_options','fs=cephfs'),('2025-12-04 10:41:28.485553',NULL,'2025-12-04 10:41:30.693829',30,30,'1829b41d-c21f-4aae-ad0b-d90348cd0d0a','key3','value3'),('2025-12-04 10:41:28.489814',NULL,'2025-12-04 10:41:30.693829',31,31,'1829b41d-c21f-4aae-ad0b-d90348cd0d0a','key4','value4'),('2025-12-04 10:41:28.493115',NULL,'2025-12-04 10:41:30.693829',32,32,'1829b41d-c21f-4aae-ad0b-d90348cd0d0a','key.5.1','value.5'),('2025-12-04 10:41:31.130376',NULL,'2025-12-04 10:41:36.171491',33,33,'44395325-f4a7-46bd-9284-344f55b95b3e','__mount_options','fs=cephfs'),('2025-12-04 10:41:33.958741',NULL,'2025-12-04 10:41:38.381346',34,34,'f5860a15-20fa-4790-a9e1-6bd3ffc4acfa','key1','value1'),('2025-12-04 10:41:33.959120',NULL,'2025-12-04 10:41:38.381346',35,35,'f5860a15-20fa-4790-a9e1-6bd3ffc4acfa','key2','value2'),('2025-12-04 10:41:34.218948',NULL,'2025-12-04 10:41:38.381346',36,36,'f5860a15-20fa-4790-a9e1-6bd3ffc4acfa','__mount_options','fs=cephfs'),('2025-12-04 10:41:42.108969',NULL,'2025-12-04 10:41:48.950775',37,37,'dcb1d53e-5a72-4bbf-9851-74a087495374','__mount_options','fs=cephfs'),('2025-12-04 10:41:45.657560','2025-12-04 10:41:46.278685','2025-12-04 10:41:48.950775',38,38,'dcb1d53e-5a72-4bbf-9851-74a087495374','key9','value13'),('2025-12-04 10:41:45.661813',NULL,'2025-12-04 10:41:48.950775',39,39,'dcb1d53e-5a72-4bbf-9851-74a087495374','key10','value10'),('2025-12-04 10:41:46.292690',NULL,'2025-12-04 10:41:48.950775',40,40,'dcb1d53e-5a72-4bbf-9851-74a087495374','key11','value11'),('2025-12-04 10:41:50.484142',NULL,'2025-12-04 10:41:56.419997',41,41,'8fd99358-d8c7-47f6-afb5-e68a5184927e','key','value'),('2025-12-04 10:41:51.708686',NULL,'2025-12-04 10:41:56.419997',42,42,'8fd99358-d8c7-47f6-afb5-e68a5184927e','__mount_options','fs=cephfs'),('2025-12-04 10:41:52.216083',NULL,'2025-12-04 10:42:04.866427',43,43,'6e8cdd4d-9cb6-49a2-984e-b1bc7db84e85','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value'),('2025-12-04 10:41:52.498015','2025-12-04 10:41:53.498815','2025-12-04 10:42:04.866427',44,44,'6e8cdd4d-9cb6-49a2-984e-b1bc7db84e85','key','v'),('2025-12-04 10:41:53.082643',NULL,'2025-12-04 10:42:00.962839',45,45,'0a2752ac-2225-4560-a011-76c6043ebc6c','__mount_options','fs=cephfs'),('2025-12-04 10:41:53.162822',NULL,'2025-12-04 10:42:04.866427',46,46,'6e8cdd4d-9cb6-49a2-984e-b1bc7db84e85','k','value'),('2025-12-04 10:41:53.544481',NULL,'2025-12-04 10:41:57.215155',47,47,'95690aab-70df-44f3-888e-5c2ff20d54d6','__mount_options','fs=cephfs'),('2025-12-04 10:41:54.034177',NULL,'2025-12-04 10:41:59.559378',48,48,'ecbda702-f36b-4198-aa8c-26a2f24dbd69','__mount_options','fs=cephfs'),('2025-12-04 10:41:57.359587',NULL,'2025-12-04 10:41:59.559378',49,49,'ecbda702-f36b-4198-aa8c-26a2f24dbd69','key9','value9'),('2025-12-04 10:41:57.363303',NULL,'2025-12-04 10:41:59.559378',50,50,'ecbda702-f36b-4198-aa8c-26a2f24dbd69','key10','value10'),('2025-12-04 10:41:57.832897',NULL,'2025-12-04 10:41:59.559378',51,51,'ecbda702-f36b-4198-aa8c-26a2f24dbd69','key11','value11'),('2025-12-04 10:41:57.840227',NULL,'2025-12-04 10:41:59.559378',52,52,'ecbda702-f36b-4198-aa8c-26a2f24dbd69','key12','value12'),('2025-12-04 10:41:59.834046',NULL,'2025-12-04 10:42:11.339517',53,53,'d5438395-ae62-4999-9a2d-0118c28ba3a6','__mount_options','fs=cephfs'),('2025-12-04 10:42:02.895446',NULL,'2025-12-04 10:42:04.866427',54,54,'6e8cdd4d-9cb6-49a2-984e-b1bc7db84e85','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value'),('2025-12-04 10:42:03.274171',NULL,'2025-12-04 10:42:04.866427',55,55,'6e8cdd4d-9cb6-49a2-984e-b1bc7db84e85','key','vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv'),('2025-12-04 10:42:03.658575',NULL,'2025-12-04 10:42:04.866427',56,56,'6e8cdd4d-9cb6-49a2-984e-b1bc7db84e85','k','value'),('2025-12-04 10:42:04.081510',NULL,'2025-12-04 10:42:04.866427',57,57,'6e8cdd4d-9cb6-49a2-984e-b1bc7db84e85','key','v'),('2025-12-04 10:42:04.321677',NULL,'2025-12-04 10:42:08.285133',58,58,'fcacf240-d104-463d-a1f4-c5973b1e0799','__mount_options','fs=cephfs'),('2025-12-04 10:42:16.972384',NULL,'2025-12-04 10:43:23.209453',59,59,'ad85dcc5-0d0d-4da4-81ed-bc7e8e2edbe7','__mount_options','fs=cephfs'),('2025-12-04 10:42:21.222944',NULL,'2025-12-04 10:42:28.653985',60,60,'5c089416-80f4-44d7-ae20-e3205c02b9f6','__mount_options','fs=cephfs'),('2025-12-04 10:42:31.801058',NULL,'2025-12-04 10:42:39.455609',61,61,'46a22168-c576-4b32-8268-3052b32d9157','__mount_options','fs=cephfs'),('2025-12-04 10:42:42.638778',NULL,'2025-12-04 10:42:50.114131',62,62,'2ad065b7-ef88-4d1b-bf36-9dcd4fcd6071','__mount_options','fs=cephfs'),('2025-12-04 10:42:54.178316',NULL,'2025-12-04 10:42:58.697683',63,63,'e4444d21-8f54-411b-8da5-816ca0c15999','__mount_options','fs=cephfs'),('2025-12-04 10:43:02.125996',NULL,'2025-12-04 10:43:06.212888',64,64,'0d26c116-5607-4a7f-87c1-6007280ba3d5','__mount_options','fs=cephfs'),('2025-12-04 10:43:18.468200',NULL,'2025-12-04 10:43:30.218278',65,65,'5c6aa58f-f371-4f67-bfaa-356abf09e311','__mount_options','fs=cephfs'),('2025-12-04 10:43:20.063041',NULL,'2025-12-04 10:43:30.667508',66,66,'2f1a8220-3e00-4f0a-9dac-fb3bda10481f','__mount_options','fs=cephfs'),('2025-12-04 10:43:23.503196',NULL,'2025-12-04 10:43:27.027787',67,67,'af43a924-d75a-47d8-a62d-541b64ecb513','__mount_options','fs=cephfs'),('2025-12-04 10:43:34.144732',NULL,'2025-12-04 10:43:54.743108',68,68,'ac64d4c6-95c7-42bd-ae98-ee18c21bfd68','__mount_options','fs=cephfs'),('2025-12-04 10:43:36.509100',NULL,'2025-12-04 10:44:40.053500',69,69,'51f18aea-3533-4ddd-9c2c-1452cdefca48','__mount_options','fs=cephfs'),('2025-12-04 10:43:39.359321',NULL,'2025-12-04 10:43:42.973794',70,70,'1c19ef78-a3f6-4cc2-849d-7c6974571b73','__mount_options','fs=cephfs'),('2025-12-04 10:43:40.271761',NULL,'2025-12-04 10:44:36.349553',71,71,'2d436547-41b8-4122-9322-d7f521efcae8','__mount_options','fs=cephfs'),('2025-12-04 10:43:44.438462',NULL,'2025-12-04 10:44:32.678140',72,72,'361a365f-e3ed-48f5-b726-d1c98f3a4186','__mount_options','fs=cephfs'),('2025-12-04 10:43:46.542413',NULL,'2025-12-04 10:43:50.306555',73,73,'12e6a6f6-79d8-47cd-b245-44f853987171','__mount_options','fs=cephfs'),('2025-12-04 10:43:52.898842',NULL,'2025-12-04 10:44:44.157125',74,74,'adeaaedd-d008-4461-9733-ff7478f34676','__mount_options','fs=cephfs'),('2025-12-04 10:44:06.042775',NULL,'2025-12-04 10:44:10.883475',75,75,'b1336a38-1a5a-47a5-9b90-bf24f6a0a3a2','__mount_options','fs=cephfs'),('2025-12-04 10:44:13.790904',NULL,'2025-12-04 10:44:28.918198',76,76,'d9c7ad6d-0886-4bc8-aeea-f4d0267bd9ea','__mount_options','fs=cephfs'),('2025-12-04 10:44:28.024372',NULL,'2025-12-04 10:47:41.078597',77,77,'4b1855ba-c5e9-4793-a786-40a54e7585ef','__mount_options','fs=cephfs'),('2025-12-04 10:45:08.307474',NULL,'2025-12-04 10:45:35.699776',78,78,'94798190-fa7d-43ed-a870-3834bf6060ce','__mount_options','fs=cephfs'),('2025-12-04 10:45:12.171307',NULL,'2025-12-04 10:45:32.192046',79,79,'294ace96-b929-46cc-ba31-c3325815b6a3','__mount_options','fs=cephfs'),('2025-12-04 10:45:16.227501',NULL,'2025-12-04 10:45:28.861129',80,80,'01fe9fef-080a-43fe-bf96-dd9da9f35c9c','__mount_options','fs=cephfs'),('2025-12-04 10:45:20.360568',NULL,'2025-12-04 10:45:25.040020',81,81,'61860e1a-3994-4032-baac-83323e59c0a3','__mount_options','fs=cephfs'),('2025-12-04 10:45:56.408693',NULL,'2025-12-04 10:47:05.368533',82,82,'54385428-bf5e-4ed6-8708-d0e0ea38cbf4','foo_key_share_1','foo_value_share_1'),('2025-12-04 10:45:56.409213',NULL,'2025-12-04 10:47:05.368533',83,83,'54385428-bf5e-4ed6-8708-d0e0ea38cbf4','bar_key_share_1','foo_value_share_1'),('2025-12-04 10:45:56.747648',NULL,'2025-12-04 10:47:05.368533',84,84,'54385428-bf5e-4ed6-8708-d0e0ea38cbf4','__mount_options','fs=cephfs'),('2025-12-04 10:46:03.334588',NULL,'2025-12-04 10:46:58.572546',85,85,'9f0837ec-6774-48b2-bb60-211b77035e24','foo_key_share_2','foo_value_share_2'),('2025-12-04 10:46:03.335051',NULL,'2025-12-04 10:46:58.572546',86,86,'9f0837ec-6774-48b2-bb60-211b77035e24','bar_key_share_2','foo_value_share_2'),('2025-12-04 10:46:03.597364',NULL,'2025-12-04 10:46:58.572546',87,87,'9f0837ec-6774-48b2-bb60-211b77035e24','__mount_options','fs=cephfs'),('2025-12-04 10:46:25.412947',NULL,'2025-12-04 10:46:32.495490',88,88,'25fe926c-9268-41b8-88c9-b70413a29311','__mount_options','fs=cephfs'),('2025-12-04 10:46:40.256024',NULL,'2025-12-04 10:46:47.088755',89,89,'0c16fde6-e8f2-4f39-bddb-65803e1ce106','__mount_options','fs=cephfs'),('2025-12-04 10:46:50.357612',NULL,'2025-12-04 10:46:55.225600',90,90,'efc77317-f625-4cff-bcbb-2ce3261acd01','__mount_options','fs=cephfs'),('2025-12-04 10:47:18.050276',NULL,'2025-12-04 10:47:28.569261',91,91,'65aad31d-e919-4d8f-8fd3-e6f5cb57e829','__mount_options','fs=cephfs'),('2025-12-04 10:47:26.188216',NULL,NULL,0,92,'a8f732d1-1b5d-49d8-8c55-52087c9cecb1','__mount_options','fs=cephfs'),('2025-12-04 10:47:32.278691',NULL,'2025-12-04 10:47:43.887269',93,93,'170d65c2-589a-4713-bfa8-09af2cc4d8ad','__mount_options','fs=cephfs'),('2025-12-04 10:47:53.915233',NULL,'2025-12-04 10:48:05.574478',94,94,'9bd18f54-a7a7-4fe5-b491-e9720402156c','__mount_options','fs=cephfs'),('2025-12-04 10:47:55.466493',NULL,'2025-12-04 10:48:07.199895',95,95,'db12e16f-d9ac-495f-a35c-57eb35050f7a','foo_key_share_1','foo_value_share_1'),('2025-12-04 10:47:55.466979',NULL,'2025-12-04 10:48:07.199895',96,96,'db12e16f-d9ac-495f-a35c-57eb35050f7a','bar_key_share_1','foo_value_share_1'),('2025-12-04 10:47:57.173566',NULL,'2025-12-04 10:48:07.199895',97,97,'db12e16f-d9ac-495f-a35c-57eb35050f7a','__mount_options','fs=cephfs'),('2025-12-04 10:48:54.718059',NULL,'2025-12-04 10:49:05.487835',98,98,'0ba0d9dd-53af-4b75-9763-be9978723501','__mount_options','fs=cephfs'),('2025-12-04 10:49:09.081084',NULL,'2025-12-04 10:49:12.686169',99,99,'cb03e6de-1192-49e0-b2ea-604752a95429','__mount_options','fs=cephfs'),('2025-12-04 10:49:16.167935',NULL,'2025-12-04 10:50:35.605428',100,100,'1914213e-cb38-47c5-bb81-b30cfa67ccaa','__mount_options','fs=cephfs'),('2025-12-04 10:49:23.270160',NULL,'2025-12-04 10:50:29.330515',101,101,'d1679b02-3e6b-4d87-bdfb-fde348e3e3f4','__mount_options','fs=cephfs'),('2025-12-04 10:50:50.593936',NULL,'2025-12-04 10:51:38.346192',102,102,'f654838a-e3cf-4ba9-9b3d-f1435cc8f327','__mount_options','fs=cephfs'),('2025-12-04 10:50:58.679057',NULL,'2025-12-04 10:51:02.101829',103,103,'25c86dd0-9947-4fab-aeec-44acb1fe4a67','__mount_options','fs=cephfs'),('2025-12-04 10:51:06.584244',NULL,'2025-12-04 10:51:09.776079',104,104,'33128045-ffb6-4396-a95d-a1eebcb0fa90','__mount_options','fs=cephfs'),('2025-12-04 10:51:13.058415',NULL,'2025-12-04 10:51:16.451031',105,105,'c2aec3be-39fc-42a2-8169-8562cab8274a','__mount_options','fs=cephfs'),('2025-12-04 10:51:20.142270',NULL,'2025-12-04 10:51:23.555941',106,106,'6da520eb-4b5b-4331-a85f-950a1ed4098d','__mount_options','fs=cephfs'),('2025-12-04 10:51:27.629038',NULL,'2025-12-04 10:51:30.759872',107,107,'4e1b7902-892b-4297-a889-3e157e63a171','__mount_options','fs=cephfs');
/*!40000 ALTER TABLE `share_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_network_security_service_association`
--

DROP TABLE IF EXISTS `share_network_security_service_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_network_security_service_association` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_network_id` varchar(36) NOT NULL,
  `security_service_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `share_network_id` (`share_network_id`),
  KEY `security_service_id` (`security_service_id`),
  CONSTRAINT `share_network_security_service_association_ibfk_1` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`),
  CONSTRAINT `share_network_security_service_association_ibfk_2` FOREIGN KEY (`security_service_id`) REFERENCES `security_services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_network_security_service_association`
--

LOCK TABLES `share_network_security_service_association` WRITE;
/*!40000 ALTER TABLE `share_network_security_service_association` DISABLE KEYS */;
INSERT INTO `share_network_security_service_association` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_network_id`, `security_service_id`) VALUES ('2025-12-04 10:39:50.968051','2025-12-04 10:39:53.983368','2025-12-04 10:39:53.982511',1,1,'66c18b4e-93ea-4c3c-be0e-a349b20487a9','4deca5c9-3d6c-48fe-a6ff-d27912284d67'),('2025-12-04 10:39:51.476157',NULL,NULL,0,2,'fd87d7f2-42e9-457e-b674-70ecdd696426','f3f4fdec-ac61-4daf-af10-5ab1c27d2010'),('2025-12-04 10:42:24.198033','2025-12-04 10:42:28.095657','2025-12-04 10:42:28.094677',3,3,'6b542ad3-bae3-45d8-aa0d-76eaefb27a88','eea23c65-8f8d-4784-b58e-cd8726e30dcb'),('2025-12-04 10:42:25.081510','2025-12-04 10:42:25.244757','2025-12-04 10:42:25.243973',4,4,'4fa9169a-8f90-4eac-a4d1-406ecfe7ff43','81df3ade-a261-40cd-93a6-393dcbebf9b1'),('2025-12-04 10:42:26.184004','2025-12-04 10:42:26.721888','2025-12-04 10:42:26.721206',5,5,'81575925-8b99-47b6-92a3-14e1f999f2a9','ee9e1f03-a770-4c7c-a183-a8e187a4e8d9'),('2025-12-04 10:42:49.796237','2025-12-04 10:42:54.954056','2025-12-04 10:42:54.953591',6,6,'708a3c24-b9b9-4d77-9745-61c6cd0d81e4','a2f6c714-7b5b-4ed5-a0a2-f5fb64e5a1ba'),('2025-12-04 10:42:50.189994','2025-12-04 10:42:54.701514','2025-12-04 10:42:54.701220',7,7,'d4bcd15c-a2ba-420a-8ca1-3c695211774b','1d662a7d-13df-45a7-bd47-ed213cbc345c'),('2025-12-04 10:44:59.781772','2025-12-04 10:44:59.889784','2025-12-04 10:44:59.889467',8,8,'647397b2-da6e-4f28-964f-640d5b1f2c4f','a6e3c352-2941-4d53-8739-75d808443937'),('2025-12-04 10:45:00.902253','2025-12-04 10:45:01.208637','2025-12-04 10:45:01.208124',9,9,'9d43706b-62fa-4d48-8cb0-26e3c60009ff','6bfffd63-7646-4e1e-8ec7-4329759ca6f9'),('2025-12-04 10:45:01.662244','2025-12-04 10:45:01.773696','2025-12-04 10:45:01.773428',10,10,'2236c8c1-7eaa-4049-a5a6-541c7ffcf883','56f1dac8-45d5-4ef4-86a2-ffaba344f8ad'),('2025-12-04 10:45:01.877911','2025-12-04 10:45:02.056283','2025-12-04 10:45:02.055903',11,11,'2236c8c1-7eaa-4049-a5a6-541c7ffcf883','56f1dac8-45d5-4ef4-86a2-ffaba344f8ad');
/*!40000 ALTER TABLE `share_network_security_service_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_network_subnet_metadata`
--

DROP TABLE IF EXISTS `share_network_subnet_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_network_subnet_metadata` (
  `deleted` varchar(36) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_network_subnet_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `share_network_subnet_id` (`share_network_subnet_id`),
  CONSTRAINT `share_network_subnet_metadata_ibfk_1` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_network_subnet_metadata`
--

LOCK TABLES `share_network_subnet_metadata` WRITE;
/*!40000 ALTER TABLE `share_network_subnet_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_network_subnet_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_network_subnets`
--

DROP TABLE IF EXISTS `share_network_subnets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_network_subnets` (
  `id` varchar(36) NOT NULL,
  `neutron_net_id` varchar(36) DEFAULT NULL,
  `neutron_subnet_id` varchar(36) DEFAULT NULL,
  `network_type` varchar(32) DEFAULT NULL,
  `cidr` varchar(64) DEFAULT NULL,
  `segmentation_id` int(11) DEFAULT NULL,
  `gateway` varchar(64) DEFAULT NULL,
  `mtu` int(11) DEFAULT NULL,
  `share_network_id` varchar(36) DEFAULT NULL,
  `ip_version` int(11) DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_share_network_subnets_share_network_id_share_networks` (`share_network_id`),
  KEY `fk_share_network_subnets_availaility_zone_id_availability_zones` (`availability_zone_id`),
  CONSTRAINT `fk_share_network_subnets_availaility_zone_id_availability_zones` FOREIGN KEY (`availability_zone_id`) REFERENCES `availability_zones` (`id`),
  CONSTRAINT `fk_share_network_subnets_share_network_id_share_networks` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_network_subnets`
--

LOCK TABLES `share_network_subnets` WRITE;
/*!40000 ALTER TABLE `share_network_subnets` DISABLE KEYS */;
INSERT INTO `share_network_subnets` (`id`, `neutron_net_id`, `neutron_subnet_id`, `network_type`, `cidr`, `segmentation_id`, `gateway`, `mtu`, `share_network_id`, `ip_version`, `availability_zone_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES ('0861410b-8ab7-42ef-a785-9e64191eadfa','tempest-net-id-1653712907','tempest-subnet-id-823003767',NULL,NULL,NULL,NULL,NULL,'9d43706b-62fa-4d48-8cb0-26e3c60009ff',NULL,NULL,'2025-12-04 10:45:00.563611',NULL,NULL,'False'),('1fe8f3ea-4290-4c13-ba86-1189b417ea43','tempest-net-id-1066023500','tempest-subnet-id-692651269',NULL,NULL,NULL,NULL,NULL,'ac9b03cc-35be-4a94-9b63-7c285978aaf0',NULL,NULL,'2025-12-04 10:43:05.089437',NULL,NULL,'False'),('25e1ecd5-61db-456d-afd4-010d01bd064c',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'6b542ad3-bae3-45d8-aa0d-76eaefb27a88',NULL,NULL,'2025-12-04 10:42:23.417905',NULL,NULL,'False'),('2e37f69b-32ec-476e-85e2-77dd8c0f28bc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'fffd4bda-7694-4d52-8f10-87f336e999ef',NULL,NULL,'2025-12-04 10:42:37.122372',NULL,NULL,'False'),('37484061-b67f-4748-8e9f-3412875dd6ed','tempest-net-id-1288621729','tempest-subnet-id-1681984555',NULL,NULL,NULL,NULL,NULL,'647397b2-da6e-4f28-964f-640d5b1f2c4f',NULL,NULL,'2025-12-04 10:44:59.472841',NULL,NULL,'False'),('3a929408-1fb0-47ff-84ff-b210435f3828','tempest-net-id-179266841','tempest-subnet-id-974413000',NULL,NULL,NULL,NULL,NULL,'7637f145-f5bb-4d49-93e8-3811cecd857b',NULL,NULL,'2025-12-04 10:42:51.190418',NULL,NULL,'False'),('3d387675-3130-4d28-a555-450c9628620b','test net id','test subnet id','local','10.0.0.0/13',2000,NULL,NULL,'d4bcd15c-a2ba-420a-8ca1-3c695211774b',6,NULL,'2003-03-03 00:00:00.000000',NULL,NULL,'False'),('3da7ce25-55d8-44a6-a129-65e84f10e618','tempest-net-id-394851106','tempest-subnet-id-1946560037',NULL,NULL,NULL,NULL,NULL,'dbba4893-7860-4f59-9e47-20f40cf9bf41',NULL,NULL,'2025-12-04 10:42:50.296788',NULL,NULL,'False'),('3f2ffe54-d1c6-41e5-a7fd-29bb28ad3250','1111','2222','vlan','10.0.0.0/24',1000,NULL,NULL,'66c18b4e-93ea-4c3c-be0e-a349b20487a9',4,NULL,'2002-02-02 00:00:00.000000',NULL,NULL,'False'),('46ee6a0e-8842-466e-801e-3830964764c0','tempest-net-id-745115962','tempest-subnet-id-1619658412',NULL,NULL,NULL,NULL,NULL,'32eec387-9814-4952-8943-f4729d5dda2e',NULL,NULL,'2025-12-04 10:42:53.217477',NULL,NULL,'False'),('57e02531-f538-4d25-87fc-c52042c40f5a',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'e5e13f58-6fe7-4d9d-8444-c98f4b445b1f',NULL,NULL,'2025-12-04 10:43:03.388064',NULL,NULL,'False'),('5ccef406-7a59-4e9e-9cd0-da0251edc223','tempest-net-id-179266841','tempest-subnet-id-974413000',NULL,NULL,NULL,NULL,NULL,'589d25c1-8d76-4ed3-82e5-7da087703651',NULL,NULL,'2025-12-04 10:42:51.325004',NULL,NULL,'False'),('61a87793-cc4c-4988-bac5-8bcbabc12def','tempest-net-id-957683357','tempest-subnet-id-1811037892',NULL,NULL,NULL,NULL,NULL,'2236c8c1-7eaa-4049-a5a6-541c7ffcf883',NULL,NULL,'2025-12-04 10:45:01.449705',NULL,NULL,'False'),('6e752545-26e9-42dc-bf40-9bf051e81ad5','tempest-net-id-1441821372','tempest-subnet-id-1854604013','vlan','10.0.0.0/24',1000,NULL,NULL,'708a3c24-b9b9-4d77-9745-61c6cd0d81e4',4,NULL,'2002-02-02 00:00:00.000000','2025-12-04 10:42:53.869426',NULL,'False'),('6fe152a9-d053-43b7-883d-d2fb9b88ea5f',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'5d4695cd-9834-4abb-9268-13c1f59c0f48',NULL,NULL,'2025-12-04 10:42:35.938050',NULL,NULL,'False'),('7316ceb4-115b-4c36-8e07-40a4b97329a4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'c6a285b7-fa77-4343-827f-a620500bb4e4',NULL,NULL,'2025-12-04 10:48:24.873050',NULL,NULL,'False'),('7a84f819-2704-4291-906a-d8599a01da9f','test net id','test subnet id','local','10.0.0.0/13',2000,NULL,NULL,'fd87d7f2-42e9-457e-b674-70ecdd696426',6,NULL,'2003-03-03 00:00:00.000000',NULL,NULL,'False'),('81eaf93b-739c-4196-879c-99875ebc35fb','tempest-net-id-189209240','tempest-subnet-id-1228046569',NULL,NULL,NULL,NULL,NULL,'5d4695cd-9834-4abb-9268-13c1f59c0f48',NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','2025-12-04 10:42:36.366312','2025-12-04 10:42:36.491535','2025-12-04 10:42:36.490318','81eaf93b-739c-4196-879c-99875ebc35fb'),('a1922de0-6335-476b-bfe5-456826d35a44',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'f8f5c7fa-1630-4023-9a6d-b3fbc5320c94',NULL,NULL,'2025-12-04 10:42:35.618973',NULL,NULL,'False'),('b4ba28d6-5171-4e66-8b41-bbc970748564','tempest-net-id-865462510','tempest-subnet-id-1478703548',NULL,NULL,NULL,NULL,NULL,'81575925-8b99-47b6-92a3-14e1f999f2a9',NULL,NULL,'2025-12-04 10:42:25.864160',NULL,NULL,'False'),('b596d28f-a633-46ac-aca9-3a84fee11f44','tempest-net-id-1234722783','tempest-subnet-id-1416703900',NULL,NULL,NULL,NULL,NULL,'4fa9169a-8f90-4eac-a4d1-406ecfe7ff43',NULL,NULL,'2025-12-04 10:42:24.790995',NULL,NULL,'False'),('bb7ec39e-a660-4108-a5db-e4aefa012199','tempest-net-id-861859565','tempest-subnet-id-913128372',NULL,NULL,NULL,NULL,NULL,'8f163168-81de-40de-9edd-df3bc5bac1a0',NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','2025-12-04 10:43:04.094412','2025-12-04 10:43:04.316779','2025-12-04 10:43:04.316270','bb7ec39e-a660-4108-a5db-e4aefa012199'),('d4a81c66-3489-47eb-b482-9a85f7aa5b6e','tempest-net-id-745115962','tempest-subnet-id-1619658412',NULL,NULL,NULL,NULL,NULL,'a391d358-8978-47d8-8436-4aaa853117c2',NULL,NULL,'2025-12-04 10:42:52.822834',NULL,NULL,'False'),('ede6da79-66e9-488d-b5c2-f852756fe7ae','tempest-net-id-763521796','tempest-subnet-id-667409681',NULL,NULL,NULL,NULL,NULL,'c6a285b7-fa77-4343-827f-a620500bb4e4',NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','2025-12-04 10:48:25.801641','2025-12-04 10:48:25.993786','2025-12-04 10:48:25.993211','ede6da79-66e9-488d-b5c2-f852756fe7ae'),('f2837fac-21ca-4838-b8c9-c0cd305a2a20','tempest-net-id-1068276635','tempest-subnet-id-1686177490',NULL,NULL,NULL,NULL,NULL,'fffd4bda-7694-4d52-8f10-87f336e999ef',NULL,'f77ebe78-579a-4b46-8364-e2bff82f3947','2025-12-04 10:42:37.337028','2025-12-04 10:42:37.653862','2025-12-04 10:42:37.651822','f2837fac-21ca-4838-b8c9-c0cd305a2a20'),('f2fbbb16-e869-4a13-a3b1-6ba9532c3437',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'8f163168-81de-40de-9edd-df3bc5bac1a0',NULL,NULL,'2025-12-04 10:43:03.919201',NULL,NULL,'False');
/*!40000 ALTER TABLE `share_network_subnets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_networks`
--

DROP TABLE IF EXISTS `share_networks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_networks` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(36) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_networks`
--

LOCK TABLES `share_networks` WRITE;
/*!40000 ALTER TABLE `share_networks` DISABLE KEYS */;
INSERT INTO `share_networks` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `user_id`, `name`, `description`, `status`) VALUES ('2025-12-04 10:45:01.435256','2025-12-04 10:45:02.094345','2025-12-04 10:45:02.093863','2236c8c1-7eaa-4049-a5a6-541c7ffcf883','2236c8c1-7eaa-4049-a5a6-541c7ffcf883','a206b399e9d842ecbeb897b80e10c0fc','22ea2c4923594e4cb5626d4a09a7f6a1','tempest-sn-name-2142388001','tempest-sn-desc-984135286','active'),('2025-12-04 10:42:53.192130','2025-12-04 10:42:53.407491','2025-12-04 10:42:53.406904','32eec387-9814-4952-8943-f4729d5dda2e','32eec387-9814-4952-8943-f4729d5dda2e','861ef911050d4b8ba35e89f01c620f89','1bb26f77770d4e0093ade4fe9d48231b','tempest-sn-name-2118864860','tempest-sn-desc-179960039','active'),('2025-12-04 10:42:24.778446','2025-12-04 10:42:25.515357','2025-12-04 10:42:25.514556','4fa9169a-8f90-4eac-a4d1-406ecfe7ff43','4fa9169a-8f90-4eac-a4d1-406ecfe7ff43','e5ed5896f5c141d08b886fe18ab11b56','d266eff9e7ae434291697f9a69cbed9c','tempest-sn-name-2083168233','tempest-sn-desc-1040398952','active'),('2025-12-04 10:42:51.309448','2025-12-04 10:42:51.467618','2025-12-04 10:42:51.467173','589d25c1-8d76-4ed3-82e5-7da087703651','589d25c1-8d76-4ed3-82e5-7da087703651','861ef911050d4b8ba35e89f01c620f89','1bb26f77770d4e0093ade4fe9d48231b','tempest-sn-name-1780472244','tempest-sn-desc-928278172','active'),('2025-12-04 10:42:35.920620',NULL,NULL,'False','5d4695cd-9834-4abb-9268-13c1f59c0f48','2d40ae03316045f1b24640181280b9a9','4326a45d529b409c82188bae1a9bcf09',NULL,NULL,'active'),('2025-12-04 10:44:59.442810','2025-12-04 10:45:00.309268','2025-12-04 10:45:00.308656','647397b2-da6e-4f28-964f-640d5b1f2c4f','647397b2-da6e-4f28-964f-640d5b1f2c4f','a206b399e9d842ecbeb897b80e10c0fc','22ea2c4923594e4cb5626d4a09a7f6a1','tempest-sn-name-1922514020','tempest-sn-desc-1353481003','active'),('2002-02-02 00:00:00.000000','2025-12-04 10:39:53.999532','2025-12-04 10:39:53.997832','66c18b4e-93ea-4c3c-be0e-a349b20487a9','66c18b4e-93ea-4c3c-be0e-a349b20487a9','246f1169a6af4a34902c2aa68c00782b','30def06ddfcb4491be841cb17e5f182e','sn_with_ldap_ss','fake description','active'),('2025-12-04 10:42:23.398548','2025-12-04 10:42:28.111279','2025-12-04 10:42:28.110814','6b542ad3-bae3-45d8-aa0d-76eaefb27a88','6b542ad3-bae3-45d8-aa0d-76eaefb27a88','e5ed5896f5c141d08b886fe18ab11b56','d266eff9e7ae434291697f9a69cbed9c',NULL,NULL,'active'),('2002-02-02 00:00:00.000000','2025-12-04 10:42:54.994798','2025-12-04 10:42:54.994373','708a3c24-b9b9-4d77-9745-61c6cd0d81e4','708a3c24-b9b9-4d77-9745-61c6cd0d81e4','861ef911050d4b8ba35e89f01c620f89','1bb26f77770d4e0093ade4fe9d48231b','tempest-sn-name-557830035','tempest-sn-desc-410780304','active'),('2025-12-04 10:42:51.176513','2025-12-04 10:42:51.716268','2025-12-04 10:42:51.715793','7637f145-f5bb-4d49-93e8-3811cecd857b','7637f145-f5bb-4d49-93e8-3811cecd857b','861ef911050d4b8ba35e89f01c620f89','1bb26f77770d4e0093ade4fe9d48231b','tempest-sn-name-1780472244','tempest-sn-desc-928278172','active'),('2025-12-04 10:42:25.847009','2025-12-04 10:42:26.740887','2025-12-04 10:42:26.740075','81575925-8b99-47b6-92a3-14e1f999f2a9','81575925-8b99-47b6-92a3-14e1f999f2a9','e5ed5896f5c141d08b886fe18ab11b56','d266eff9e7ae434291697f9a69cbed9c','tempest-sn-name-1330343694','tempest-sn-desc-771984017','active'),('2025-12-04 10:43:03.904237','2025-12-04 10:43:04.610576','2025-12-04 10:43:04.609941','8f163168-81de-40de-9edd-df3bc5bac1a0','8f163168-81de-40de-9edd-df3bc5bac1a0','6df96f3f7888473c8c4020fd09afd972','2a76d8ce1fb140f5bbbd61ac660038f7',NULL,NULL,'active'),('2025-12-04 10:45:00.548148','2025-12-04 10:45:01.226095','2025-12-04 10:45:01.225581','9d43706b-62fa-4d48-8cb0-26e3c60009ff','9d43706b-62fa-4d48-8cb0-26e3c60009ff','a206b399e9d842ecbeb897b80e10c0fc','22ea2c4923594e4cb5626d4a09a7f6a1','tempest-sn-name-1622586672','tempest-sn-desc-1693929427','active'),('2025-12-04 10:42:52.810179','2025-12-04 10:42:53.045215','2025-12-04 10:42:53.044709','a391d358-8978-47d8-8436-4aaa853117c2','a391d358-8978-47d8-8436-4aaa853117c2','861ef911050d4b8ba35e89f01c620f89','1bb26f77770d4e0093ade4fe9d48231b','tempest-sn-name-2118864860','tempest-sn-desc-179960039','active'),('2025-12-04 10:43:05.075244','2025-12-04 10:43:05.253525','2025-12-04 10:43:05.253097','ac9b03cc-35be-4a94-9b63-7c285978aaf0','ac9b03cc-35be-4a94-9b63-7c285978aaf0','6df96f3f7888473c8c4020fd09afd972','2a76d8ce1fb140f5bbbd61ac660038f7','tempest-sn-name-918122032','tempest-sn-desc-37697144','active'),('2025-12-04 10:48:24.849616',NULL,NULL,'False','c6a285b7-fa77-4343-827f-a620500bb4e4','d7b71786426443df9d7260a4c1f1ebd1','de4db57a4dde458ca59ef1effab03d64',NULL,NULL,'active'),('2003-03-03 00:00:00.000000','2025-12-04 10:42:54.714453','2025-12-04 10:42:54.714080','d4bcd15c-a2ba-420a-8ca1-3c695211774b','d4bcd15c-a2ba-420a-8ca1-3c695211774b','861ef911050d4b8ba35e89f01c620f89','1bb26f77770d4e0093ade4fe9d48231b','sn_with_kerberos_ss','fake description','active'),('2025-12-04 10:42:50.281591','2025-12-04 10:42:50.717237','2025-12-04 10:42:50.716511','dbba4893-7860-4f59-9e47-20f40cf9bf41','dbba4893-7860-4f59-9e47-20f40cf9bf41','861ef911050d4b8ba35e89f01c620f89','1bb26f77770d4e0093ade4fe9d48231b','tempest-sn-name-310084699','tempest-sn-desc-1561777561','active'),('2025-12-04 10:43:03.375467','2025-12-04 10:43:03.619425','2025-12-04 10:43:03.619017','e5e13f58-6fe7-4d9d-8444-c98f4b445b1f','e5e13f58-6fe7-4d9d-8444-c98f4b445b1f','6df96f3f7888473c8c4020fd09afd972','2a76d8ce1fb140f5bbbd61ac660038f7',NULL,NULL,'active'),('2025-12-04 10:42:35.600481','2025-12-04 10:42:36.718735','2025-12-04 10:42:36.717847','f8f5c7fa-1630-4023-9a6d-b3fbc5320c94','f8f5c7fa-1630-4023-9a6d-b3fbc5320c94','2d40ae03316045f1b24640181280b9a9','4326a45d529b409c82188bae1a9bcf09',NULL,NULL,'active'),('2003-03-03 00:00:00.000000',NULL,NULL,'False','fd87d7f2-42e9-457e-b674-70ecdd696426','05c8461a124b4addbb681e5898e482e5','045d5e64586a450cb2f94b31c74861bb','sn_with_kerberos_ss','fake description','active'),('2025-12-04 10:42:37.099598','2025-12-04 10:42:37.984900','2025-12-04 10:42:37.984428','fffd4bda-7694-4d52-8f10-87f336e999ef','fffd4bda-7694-4d52-8f10-87f336e999ef','2d40ae03316045f1b24640181280b9a9','4326a45d529b409c82188bae1a9bcf09',NULL,NULL,'active');
/*!40000 ALTER TABLE `share_networks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_server_backend_details`
--

DROP TABLE IF EXISTS `share_server_backend_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_server_backend_details` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_server_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `share_server_id` (`share_server_id`),
  CONSTRAINT `share_server_backend_details_ibfk_1` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_server_backend_details`
--

LOCK TABLES `share_server_backend_details` WRITE;
/*!40000 ALTER TABLE `share_server_backend_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_server_backend_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_server_share_network_subnet_mappings`
--

DROP TABLE IF EXISTS `share_server_share_network_subnet_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_server_share_network_subnet_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_server_id` varchar(36) NOT NULL,
  `share_network_subnet_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_ss_sns_m_share_server_id_share_servers` (`share_server_id`),
  KEY `fk_ss_sns_m_share_network_subnet_id_share_network_subnets` (`share_network_subnet_id`),
  CONSTRAINT `fk_ss_sns_m_share_network_subnet_id_share_network_subnets` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`),
  CONSTRAINT `fk_ss_sns_m_share_server_id_share_servers` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_server_share_network_subnet_mappings`
--

LOCK TABLES `share_server_share_network_subnet_mappings` WRITE;
/*!40000 ALTER TABLE `share_server_share_network_subnet_mappings` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_server_share_network_subnet_mappings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_servers`
--

DROP TABLE IF EXISTS `share_servers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_servers` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `host` varchar(255) DEFAULT NULL,
  `status` varchar(32) DEFAULT NULL,
  `is_auto_deletable` tinyint(1) DEFAULT NULL,
  `identifier` varchar(255) DEFAULT NULL,
  `task_state` varchar(255) DEFAULT NULL,
  `source_share_server_id` varchar(36) DEFAULT NULL,
  `security_service_update_support` tinyint(1) NOT NULL DEFAULT 0,
  `network_allocation_update_support` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `fk_share_servers_source_share_server_id` (`source_share_server_id`),
  CONSTRAINT `fk_share_servers_source_share_server_id` FOREIGN KEY (`source_share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_servers`
--

LOCK TABLES `share_servers` WRITE;
/*!40000 ALTER TABLE `share_servers` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_servers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_access_map`
--

DROP TABLE IF EXISTS `share_snapshot_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_access_map` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_snapshot_id` varchar(36) DEFAULT NULL,
  `access_type` varchar(255) DEFAULT NULL,
  `access_to` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ssam_snapshot_fk` (`share_snapshot_id`),
  CONSTRAINT `ssam_snapshot_fk` FOREIGN KEY (`share_snapshot_id`) REFERENCES `share_snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_access_map`
--

LOCK TABLES `share_snapshot_access_map` WRITE;
/*!40000 ALTER TABLE `share_snapshot_access_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_instance_access_map`
--

DROP TABLE IF EXISTS `share_snapshot_instance_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_instance_access_map` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_snapshot_instance_id` varchar(36) DEFAULT NULL,
  `access_id` varchar(36) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ssiam_snapshot_instance_fk` (`share_snapshot_instance_id`),
  KEY `ssam_access_fk` (`access_id`),
  CONSTRAINT `ssam_access_fk` FOREIGN KEY (`access_id`) REFERENCES `share_snapshot_access_map` (`id`),
  CONSTRAINT `ssiam_snapshot_instance_fk` FOREIGN KEY (`share_snapshot_instance_id`) REFERENCES `share_snapshot_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_instance_access_map`
--

LOCK TABLES `share_snapshot_instance_access_map` WRITE;
/*!40000 ALTER TABLE `share_snapshot_instance_access_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_instance_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_instance_export_locations`
--

DROP TABLE IF EXISTS `share_snapshot_instance_export_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_instance_export_locations` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_snapshot_instance_id` varchar(36) DEFAULT NULL,
  `path` varchar(2000) DEFAULT NULL,
  `is_admin_only` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ssiel_snapshot_instance_fk` (`share_snapshot_instance_id`),
  CONSTRAINT `ssiel_snapshot_instance_fk` FOREIGN KEY (`share_snapshot_instance_id`) REFERENCES `share_snapshot_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_instance_export_locations`
--

LOCK TABLES `share_snapshot_instance_export_locations` WRITE;
/*!40000 ALTER TABLE `share_snapshot_instance_export_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_instance_export_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_instances`
--

DROP TABLE IF EXISTS `share_snapshot_instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_instances` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `share_instance_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `share_proto` varchar(255) DEFAULT NULL,
  `share_group_snapshot_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ssi_snapshot_fk` (`snapshot_id`),
  KEY `ssi_share_instance_fk` (`share_instance_id`),
  CONSTRAINT `ssi_share_instance_fk` FOREIGN KEY (`share_instance_id`) REFERENCES `share_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_instances`
--

LOCK TABLES `share_snapshot_instances` WRITE;
/*!40000 ALTER TABLE `share_snapshot_instances` DISABLE KEYS */;
INSERT INTO `share_snapshot_instances` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `snapshot_id`, `share_instance_id`, `status`, `progress`, `provider_location`, `user_id`, `project_id`, `size`, `share_proto`, `share_group_snapshot_id`) VALUES ('2025-12-04 10:40:04.455576','2025-12-04 10:40:32.098307','2025-12-04 10:40:32.097812','023fae40-59a0-48fc-a8f7-4e2554504fc0','023fae40-59a0-48fc-a8f7-4e2554504fc0','76e0aa1d-e6e6-4ec3-a58c-79587b9868cb','8589c6fa-15d7-4a25-a420-527b5f3ec7d3','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:47:58.858167','2025-12-04 10:48:03.766737','2025-12-04 10:48:03.766224','17447fd6-7690-4bc1-b036-20af66e1ccf6','17447fd6-7690-4bc1-b036-20af66e1ccf6','3b2ce6b0-6dfd-411c-99c6-17e1f8e0a030','59666e24-d766-4aa9-9e78-1be546c42532','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:44:20.970022','2025-12-04 10:44:27.270377','2025-12-04 10:44:27.269931','234ea353-60b9-4db4-8e91-5714a5b7ce6e','234ea353-60b9-4db4-8e91-5714a5b7ce6e','e2969563-45cb-4ab6-812a-aad69d2395d4','5260b088-bfa9-4f9a-adc0-a90d452dc12f','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:47:21.168459','2025-12-04 10:47:25.296137','2025-12-04 10:47:25.295433','2a65533f-01dd-4708-9c72-21da27bce3f8','2a65533f-01dd-4708-9c72-21da27bce3f8','04fc09fb-6351-40d6-a158-b6c8dd071066','997ad407-3986-4029-acca-2f53511b4ff3','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:45:59.846172','2025-12-04 10:47:01.968751','2025-12-04 10:47:01.968025','2d147d3e-2b60-4d32-b534-bde0f2f0f206','2d147d3e-2b60-4d32-b534-bde0f2f0f206','eb21836e-156d-4fd6-adb6-75fc9fe014e2','134bada8-f9d1-4734-8cb9-4d8f094ffc02','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:47:57.221961','2025-12-04 10:48:02.135508','2025-12-04 10:48:02.134997','33df231b-c8c4-45b8-9a3d-95830eea1273','33df231b-c8c4-45b8-9a3d-95830eea1273','6d026511-3379-4035-832a-6cafed93d0e8','7de2ac86-d29c-49e9-b8b1-f1b9a7934340','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:39:50.430751','2025-12-04 10:39:51.703179','2025-12-04 10:39:51.702601','3681d897-123a-4773-ade2-a9eef0b417b5','3681d897-123a-4773-ade2-a9eef0b417b5','706dbf68-b212-4a2b-9b03-317bdcefb564','8589c6fa-15d7-4a25-a420-527b5f3ec7d3','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:40:23.395318','2025-12-04 10:40:35.757279','2025-12-04 10:40:35.756707','36b818cb-a4e7-4cde-b290-576e92a76d22','36b818cb-a4e7-4cde-b290-576e92a76d22','ed47c747-af46-4672-ae2b-cea707990167','86910b9a-b822-4f70-bcbf-6e5bf72bae29','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:39:31.794729','2025-12-04 10:39:51.516629','2025-12-04 10:39:51.516084','38bff781-e943-4d39-a749-423f72e5abda','38bff781-e943-4d39-a749-423f72e5abda','44d67cb4-039f-4bcf-973c-10ef9d2a3949','c01d539d-f169-44cc-bc00-f705cd397a14','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:40:00.252987','2025-12-04 10:40:35.582307','2025-12-04 10:40:35.581743','3df864a0-f947-4289-aa56-ed58a988606b','3df864a0-f947-4289-aa56-ed58a988606b','82370328-067d-4dd3-9bef-3f2224bb43b9','8589c6fa-15d7-4a25-a420-527b5f3ec7d3','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:44:31.825642','2025-12-04 10:44:37.490634','2025-12-04 10:44:37.490175','408e5d3e-e739-41e2-98d0-543f56b49908','408e5d3e-e739-41e2-98d0-543f56b49908','7a27b9fe-c0b9-4c84-a258-8ecce5900f59','5260b088-bfa9-4f9a-adc0-a90d452dc12f','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:47:35.415439','2025-12-04 10:47:40.291988','2025-12-04 10:47:40.291394','446616cd-30c9-420e-848d-bee94a3551ec','446616cd-30c9-420e-848d-bee94a3551ec','42c259ed-af7d-41af-a5f2-bcfbeccb5eab','002e05aa-0dc4-4f1b-ba53-39cac0015b96','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:40:27.715909','2025-12-04 10:40:32.186420','2025-12-04 10:40:32.185892','528a732c-0e32-4483-b208-a88167d57126','528a732c-0e32-4483-b208-a88167d57126','bf6cd08b-18da-4eb1-b598-27dbb9cb5f7c','86910b9a-b822-4f70-bcbf-6e5bf72bae29','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:42:03.072705','2025-12-04 10:42:07.627571','2025-12-04 10:42:07.627000','67473b26-a211-4250-90a1-ca773f3435a0','67473b26-a211-4250-90a1-ca773f3435a0','5d3cb7a6-0d61-4ba5-bb06-6cd12e9e1f68','481aa727-f970-4ad9-94c6-ca9f61924fb8','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:44:00.090857','2025-12-04 10:44:01.950573','2025-12-04 10:44:01.950172','6f006936-30e9-49da-a729-8953c011f3e4','6f006936-30e9-49da-a729-8953c011f3e4','a2731753-2916-43b4-aaed-f178c8b9ed48','5260b088-bfa9-4f9a-adc0-a90d452dc12f','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:44:05.234132','2025-12-04 10:44:10.245357','2025-12-04 10:44:10.244787','7448b403-dc03-4f78-8d83-a6c5ad1ab7d7','7448b403-dc03-4f78-8d83-a6c5ad1ab7d7','eb780175-b147-4b28-95c7-37659a64381a','5260b088-bfa9-4f9a-adc0-a90d452dc12f','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:40:12.810548','2025-12-04 10:40:25.854258','2025-12-04 10:40:25.853608','83da3e77-2028-498b-a84c-b65dbead073b','83da3e77-2028-498b-a84c-b65dbead073b','994f41bf-ed68-4080-9c5f-d4c5df7f4273','8589c6fa-15d7-4a25-a420-527b5f3ec7d3','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:43:56.379818','2025-12-04 10:44:43.306475','2025-12-04 10:44:43.305973','9894221c-c337-4fa9-8995-71c106609676','9894221c-c337-4fa9-8995-71c106609676','342109e9-178b-44e5-bf68-2605580aac2c','5260b088-bfa9-4f9a-adc0-a90d452dc12f','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:40:08.805980','2025-12-04 10:40:28.674742','2025-12-04 10:40:28.674125','ac09cea8-b1d8-4db8-91c9-4bd4ac8f268a','ac09cea8-b1d8-4db8-91c9-4bd4ac8f268a','2080cf6d-717b-4750-a2b8-d93db758ab96','8589c6fa-15d7-4a25-a420-527b5f3ec7d3','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:49:19.358030','2025-12-04 10:50:32.169399','2025-12-04 10:50:32.168749','bdaceb62-36b9-4db0-b251-a4df98a35c4b','bdaceb62-36b9-4db0-b251-a4df98a35c4b','24077abd-b36a-49fd-87f6-98a6b2f3bbce','382512d2-4ae6-4a25-96be-5898161f749d','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:40:17.703801','2025-12-04 10:40:22.574439','2025-12-04 10:40:22.573963','c4d58189-d550-43b2-accd-301d015ec2f8','c4d58189-d550-43b2-accd-301d015ec2f8','7c725858-4362-45de-9321-14ab6b5f8ef0','8589c6fa-15d7-4a25-a420-527b5f3ec7d3','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:39:16.789256','2025-12-04 10:39:22.881158','2025-12-04 10:39:22.880184','cd44680f-beaa-44fb-858d-84098d409d42','cd44680f-beaa-44fb-858d-84098d409d42','aa7c34cc-89fa-4f37-ac23-f8e6d4d78142','e2e2f6bb-d3cb-4e49-9c72-447ac26e9630','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:44:13.456054','2025-12-04 10:44:17.602744','2025-12-04 10:44:17.602258','cf03a839-1ccb-4948-9c00-9441d759b0d0','cf03a839-1ccb-4948-9c00-9441d759b0d0','d30d966b-f15f-4cb7-9d33-c43bf788f74f','5260b088-bfa9-4f9a-adc0-a90d452dc12f','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:43:21.648198','2025-12-04 10:43:26.565551','2025-12-04 10:43:26.565044','d1f5a442-8701-446e-ae89-917b6794340b','d1f5a442-8701-446e-ae89-917b6794340b','6f1499c3-6375-4ad6-94a0-953306cf2d1f','1276f5c4-3479-4622-a6c1-a1fd0508feb3','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:50:53.606456','2025-12-04 10:51:35.557004','2025-12-04 10:51:35.556521','d4dcbd7c-4c46-40c4-8e22-44ffaaee1088','d4dcbd7c-4c46-40c4-8e22-44ffaaee1088','2c9f33a3-8987-4579-986d-04d3f23eb0e2','48e0e8d9-0ebb-4db4-a173-73e6b17560ed','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:48:57.950024','2025-12-04 10:49:01.789582','2025-12-04 10:49:01.789138','e1626f5c-e61a-4e5c-8eae-8ed43c8ee857','e1626f5c-e61a-4e5c-8eae-8ed43c8ee857','c8af7113-93d2-4d4c-9380-c06be20483a6','1db2d22c-803f-4ebe-b241-8ba03a81e7dc','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2025-12-04 10:40:17.275859','2025-12-04 10:40:31.695225','2025-12-04 10:40:31.694742','f0ef63cc-82f0-4e30-af39-c9b2aa8ae4cb','f0ef63cc-82f0-4e30-af39-c9b2aa8ae4cb','9dac2a63-84c3-4448-8251-c9b0776fc4fe','980cc482-537a-4856-a203-512899e0bf5c','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `share_snapshot_instances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_metadata`
--

DROP TABLE IF EXISTS `share_snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_metadata` (
  `deleted` varchar(36) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `share_snapshot_id` (`share_snapshot_id`),
  CONSTRAINT `share_snapshot_metadata_ibfk_1` FOREIGN KEY (`share_snapshot_id`) REFERENCES `share_snapshots` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_metadata`
--

LOCK TABLES `share_snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `share_snapshot_metadata` DISABLE KEYS */;
INSERT INTO `share_snapshot_metadata` (`deleted`, `created_at`, `updated_at`, `deleted_at`, `share_snapshot_id`, `key`, `value`, `id`) VALUES ('1','2025-12-04 10:44:00.530781','2025-12-04 10:44:00.924421','2025-12-04 10:44:01.966281','a2731753-2916-43b4-aaed-f178c8b9ed48','key5','value5',1),('2','2025-12-04 10:44:00.534972','2025-12-04 10:44:00.998750','2025-12-04 10:44:01.966281','a2731753-2916-43b4-aaed-f178c8b9ed48','key6','value6',2),('3','2025-12-04 10:44:01.028890',NULL,'2025-12-04 10:44:01.966281','a2731753-2916-43b4-aaed-f178c8b9ed48','key7','value7',3),('4','2025-12-04 10:44:01.030996',NULL,'2025-12-04 10:44:01.966281','a2731753-2916-43b4-aaed-f178c8b9ed48','key8','value8',4),('5','2025-12-04 10:44:08.656635','2025-12-04 10:44:09.300953','2025-12-04 10:44:10.273320','eb780175-b147-4b28-95c7-37659a64381a','key3','value3',5),('6','2025-12-04 10:44:08.661124','2025-12-04 10:44:09.494104','2025-12-04 10:44:10.273320','eb780175-b147-4b28-95c7-37659a64381a','key4','value4',6),('7','2025-12-04 10:44:08.663725','2025-12-04 10:44:09.643328','2025-12-04 10:44:10.273320','eb780175-b147-4b28-95c7-37659a64381a','key.5.1','value.5',7),('8','2025-12-04 10:44:13.454221',NULL,'2025-12-04 10:44:17.625671','d30d966b-f15f-4cb7-9d33-c43bf788f74f','key1','value1',8),('9','2025-12-04 10:44:13.454843',NULL,'2025-12-04 10:44:17.625671','d30d966b-f15f-4cb7-9d33-c43bf788f74f','key2','value2',9),('10','2025-12-04 10:44:24.672772','2025-12-04 10:44:26.167094','2025-12-04 10:44:27.284283','e2969563-45cb-4ab6-812a-aad69d2395d4','key9','value13',10),('11','2025-12-04 10:44:24.675896','2025-12-04 10:44:26.391464','2025-12-04 10:44:27.284283','e2969563-45cb-4ab6-812a-aad69d2395d4','key10','value10',11),('12','2025-12-04 10:44:25.372981','2025-12-04 10:44:26.800361','2025-12-04 10:44:27.284283','e2969563-45cb-4ab6-812a-aad69d2395d4','key11','value11',12),('13','2025-12-04 10:44:30.443255','2025-12-04 10:44:40.717345','2025-12-04 10:44:43.317968','342109e9-178b-44e5-bf68-2605580aac2c','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value',13),('14','2025-12-04 10:44:30.930429','2025-12-04 10:44:40.750769','2025-12-04 10:44:43.317968','342109e9-178b-44e5-bf68-2605580aac2c','key','v',14),('15','2025-12-04 10:44:31.268704','2025-12-04 10:44:40.792626','2025-12-04 10:44:43.317968','342109e9-178b-44e5-bf68-2605580aac2c','k','value',15),('16','2025-12-04 10:44:35.279251','2025-12-04 10:44:36.661638','2025-12-04 10:44:37.501092','7a27b9fe-c0b9-4c84-a258-8ecce5900f59','key9','value9',16),('17','2025-12-04 10:44:35.281346','2025-12-04 10:44:36.811970','2025-12-04 10:44:37.501092','7a27b9fe-c0b9-4c84-a258-8ecce5900f59','key10','value10',17),('18','2025-12-04 10:44:35.810654','2025-12-04 10:44:36.940027','2025-12-04 10:44:37.501092','7a27b9fe-c0b9-4c84-a258-8ecce5900f59','key11','value11',18),('19','2025-12-04 10:44:35.812892','2025-12-04 10:44:37.093314','2025-12-04 10:44:37.501092','7a27b9fe-c0b9-4c84-a258-8ecce5900f59','key12','value12',19),('20','2025-12-04 10:44:40.838671','2025-12-04 10:44:41.216386','2025-12-04 10:44:43.317968','342109e9-178b-44e5-bf68-2605580aac2c','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value',20),('21','2025-12-04 10:44:41.248785','2025-12-04 10:44:41.884565','2025-12-04 10:44:43.317968','342109e9-178b-44e5-bf68-2605580aac2c','key','vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv',21),('22','2025-12-04 10:44:41.918411','2025-12-04 10:44:42.278037','2025-12-04 10:44:43.317968','342109e9-178b-44e5-bf68-2605580aac2c','k','value',22),('23','2025-12-04 10:44:42.318810',NULL,'2025-12-04 10:44:43.317968','342109e9-178b-44e5-bf68-2605580aac2c','key','v',23);
/*!40000 ALTER TABLE `share_snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshots`
--

DROP TABLE IF EXISTS `share_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshots` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `share_id` varchar(36) NOT NULL,
  `size` int(11) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `share_size` int(11) DEFAULT NULL,
  `share_proto` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_id` (`share_id`),
  CONSTRAINT `share_snapshots_ibfk_1` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshots`
--

LOCK TABLES `share_snapshots` WRITE;
/*!40000 ALTER TABLE `share_snapshots` DISABLE KEYS */;
INSERT INTO `share_snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `share_id`, `size`, `display_name`, `display_description`, `share_size`, `share_proto`) VALUES ('2025-12-04 10:47:21.167203','2025-12-04 10:47:25.312888','2025-12-04 10:47:25.312040','04fc09fb-6351-40d6-a158-b6c8dd071066','04fc09fb-6351-40d6-a158-b6c8dd071066','c99b07cc76794bbe865e84c99d719aec','b08d95dfcf5049b89d93e68ea13452d2','65aad31d-e919-4d8f-8fd3-e6f5cb57e829',2,'tempest-tempest-created-share-snap-1626910851','Tempest\'s snapshot',2,'CEPHFS'),('2025-12-04 10:40:08.805083','2025-12-04 10:40:28.708414','2025-12-04 10:40:28.707834','2080cf6d-717b-4750-a2b8-d93db758ab96','2080cf6d-717b-4750-a2b8-d93db758ab96','d2380cdaae7840a7aa1016a0c2242ad2','30e995746f0346cc925a4e4d291b4b4b','1dd0febb-2713-4235-8387-b1c1deadd402',1,'tempest-tempest-created-share-snap-1399196316','Tempest\'s snapshot',1,'CEPHFS'),('2025-12-04 10:49:19.356623','2025-12-04 10:50:32.184436','2025-12-04 10:50:32.183843','24077abd-b36a-49fd-87f6-98a6b2f3bbce','24077abd-b36a-49fd-87f6-98a6b2f3bbce','a7cbfaccac8f48c1bc69fb83640618a5','2c40fb2875304a41b2368725937fd373','1914213e-cb38-47c5-bb81-b30cfa67ccaa',1,'tempest-tempest-created-share-snap-1593649562','Tempest\'s snapshot',1,'CEPHFS'),('2025-12-04 10:50:53.605229','2025-12-04 10:51:35.572704','2025-12-04 10:51:35.572314','2c9f33a3-8987-4579-986d-04d3f23eb0e2','2c9f33a3-8987-4579-986d-04d3f23eb0e2','e318249fe70a4240a4a0e7ebc5c47a65','c3ea6486309b4dab9bf9d14f604bdce4','f654838a-e3cf-4ba9-9b3d-f1435cc8f327',1,'tempest-tempest-snapshot-name-1991982056','tempest-tempest-snapshot-description-2025418933',1,'CEPHFS'),('2025-12-04 10:43:56.378565','2025-12-04 10:44:43.319801','2025-12-04 10:44:43.319252','342109e9-178b-44e5-bf68-2605580aac2c','342109e9-178b-44e5-bf68-2605580aac2c','0ef0510443b848f1bfcd4a773578d114','18048b8b581e48239e3a92c77164734b','adeaaedd-d008-4461-9733-ff7478f34676',1,'tempest-tempest-snapshot-name-1172022172','tempest-tempest-snapshot-description-1327414112',1,'CEPHFS'),('2025-12-04 10:47:58.857087','2025-12-04 10:48:03.784279','2025-12-04 10:48:03.783686','3b2ce6b0-6dfd-411c-99c6-17e1f8e0a030','3b2ce6b0-6dfd-411c-99c6-17e1f8e0a030','bd0c952b76bd4095a0ae18a8f5a049b2','063b90bfc86448709eb6958911a53f96','db12e16f-d9ac-495f-a35c-57eb35050f7a',1,'tempest-tempest-snapshot-name-1915715017','tempest-tempest-snapshot-description-226271664',1,'CEPHFS'),('2025-12-04 10:47:35.413695','2025-12-04 10:47:40.319011','2025-12-04 10:47:40.317996','42c259ed-af7d-41af-a5f2-bcfbeccb5eab','42c259ed-af7d-41af-a5f2-bcfbeccb5eab','c99b07cc76794bbe865e84c99d719aec','b08d95dfcf5049b89d93e68ea13452d2','170d65c2-589a-4713-bfa8-09af2cc4d8ad',1,'tempest-tempest-created-share-snap-881874568','Tempest\'s snapshot',1,'CEPHFS'),('2025-12-04 10:39:31.793148','2025-12-04 10:39:51.540634','2025-12-04 10:39:51.540071','44d67cb4-039f-4bcf-973c-10ef9d2a3949','44d67cb4-039f-4bcf-973c-10ef9d2a3949','9382d7467f084a7daaf3852289dd7e55','1a11c9942929435599f0a51c3f690b44','dd36da1e-4dae-4e6b-ad72-3ba4034e7b70',1,'tempest-tempest-created-share-snap-168046241','Tempest\'s snapshot',1,'CEPHFS'),('2025-12-04 10:42:03.071337','2025-12-04 10:42:07.640715','2025-12-04 10:42:07.639797','5d3cb7a6-0d61-4ba5-bb06-6cd12e9e1f68','5d3cb7a6-0d61-4ba5-bb06-6cd12e9e1f68','88e5a16daca84b4896b3a4ca2f314a8b','ae2330f34cee47599e079667ef8df8bd','d5438395-ae62-4999-9a2d-0118c28ba3a6',1,'tempest-tempest-created-share-snap-355063822','Tempest\'s snapshot',1,'CEPHFS'),('2025-12-04 10:47:57.220614','2025-12-04 10:48:02.149402','2025-12-04 10:48:02.149014','6d026511-3379-4035-832a-6cafed93d0e8','6d026511-3379-4035-832a-6cafed93d0e8','832dabe00e054a2db2a663d3bafcdafd','440666156b56403fabeabff6ee9b42d9','9bd18f54-a7a7-4fe5-b491-e9720402156c',1,'tempest-tempest-created-share-snap-1643987549','Tempest\'s snapshot',1,'CEPHFS'),('2025-12-04 10:43:21.647312','2025-12-04 10:43:26.590977','2025-12-04 10:43:26.584732','6f1499c3-6375-4ad6-94a0-953306cf2d1f','6f1499c3-6375-4ad6-94a0-953306cf2d1f','02070bf38c73498d9b030a6203229eab','e884ccda0adb4fcfa58e4992410a7be8','5c6aa58f-f371-4f67-bfaa-356abf09e311',1,'tempest-tempest-new-name-for-snapshot-1389774202','tempest-tempest-new-description-for-snapshot-905986445',1,'CEPHFS'),('2025-12-04 10:39:50.428841','2025-12-04 10:39:51.720265','2025-12-04 10:39:51.719740','706dbf68-b212-4a2b-9b03-317bdcefb564','706dbf68-b212-4a2b-9b03-317bdcefb564','d2380cdaae7840a7aa1016a0c2242ad2','30e995746f0346cc925a4e4d291b4b4b','1dd0febb-2713-4235-8387-b1c1deadd402',1,'tempest-tempest-created-share-snap-1381997535','Tempest\'s snapshot',1,'CEPHFS'),('2025-12-04 10:40:04.452554','2025-12-04 10:40:32.176708','2025-12-04 10:40:32.176312','76e0aa1d-e6e6-4ec3-a58c-79587b9868cb','76e0aa1d-e6e6-4ec3-a58c-79587b9868cb','d2380cdaae7840a7aa1016a0c2242ad2','30e995746f0346cc925a4e4d291b4b4b','1dd0febb-2713-4235-8387-b1c1deadd402',1,'tempest-tempest-created-share-snap-1629095460','Tempest\'s snapshot',1,'CEPHFS'),('2025-12-04 10:44:31.824466','2025-12-04 10:44:37.502681','2025-12-04 10:44:37.502195','7a27b9fe-c0b9-4c84-a258-8ecce5900f59','7a27b9fe-c0b9-4c84-a258-8ecce5900f59','0ef0510443b848f1bfcd4a773578d114','18048b8b581e48239e3a92c77164734b','adeaaedd-d008-4461-9733-ff7478f34676',1,'tempest-tempest-created-share-snap-1521171483','Tempest\'s snapshot',1,'CEPHFS'),('2025-12-04 10:40:17.702826','2025-12-04 10:40:22.588818','2025-12-04 10:40:22.588427','7c725858-4362-45de-9321-14ab6b5f8ef0','7c725858-4362-45de-9321-14ab6b5f8ef0','d2380cdaae7840a7aa1016a0c2242ad2','30e995746f0346cc925a4e4d291b4b4b','1dd0febb-2713-4235-8387-b1c1deadd402',1,'tempest-tempest-created-share-snap-1043171034','Tempest\'s snapshot',1,'CEPHFS'),('2025-12-04 10:40:00.251380','2025-12-04 10:40:35.607633','2025-12-04 10:40:35.607164','82370328-067d-4dd3-9bef-3f2224bb43b9','82370328-067d-4dd3-9bef-3f2224bb43b9','d2380cdaae7840a7aa1016a0c2242ad2','30e995746f0346cc925a4e4d291b4b4b','1dd0febb-2713-4235-8387-b1c1deadd402',1,'tempest-tempest-created-share-snap-2000092319','Tempest\'s snapshot',1,'CEPHFS'),('2025-12-04 10:40:12.809497','2025-12-04 10:40:25.870033','2025-12-04 10:40:25.869400','994f41bf-ed68-4080-9c5f-d4c5df7f4273','994f41bf-ed68-4080-9c5f-d4c5df7f4273','d2380cdaae7840a7aa1016a0c2242ad2','30e995746f0346cc925a4e4d291b4b4b','1dd0febb-2713-4235-8387-b1c1deadd402',1,'tempest-tempest-created-share-snap-942419843','Tempest\'s snapshot',1,'CEPHFS'),('2025-12-04 10:40:17.272973','2025-12-04 10:40:31.710006','2025-12-04 10:40:31.709486','9dac2a63-84c3-4448-8251-c9b0776fc4fe','9dac2a63-84c3-4448-8251-c9b0776fc4fe','74c4687e9ade4a6382ce5c54f9bae971','45b18e29190f4379945421b01e7eb293','532e3f15-999c-4216-a263-82e17255e7b7',1,'tempest-tempest-snapshot-name-1734526277','tempest-tempest-snapshot-description-1631971385',1,'CEPHFS'),('2025-12-04 10:44:00.087332','2025-12-04 10:44:01.968395','2025-12-04 10:44:01.967834','a2731753-2916-43b4-aaed-f178c8b9ed48','a2731753-2916-43b4-aaed-f178c8b9ed48','0ef0510443b848f1bfcd4a773578d114','18048b8b581e48239e3a92c77164734b','adeaaedd-d008-4461-9733-ff7478f34676',1,'tempest-tempest-created-share-snap-1961014370','Tempest\'s snapshot',1,'CEPHFS'),('2025-12-04 10:39:16.787580','2025-12-04 10:39:22.912050','2025-12-04 10:39:22.911055','aa7c34cc-89fa-4f37-ac23-f8e6d4d78142','aa7c34cc-89fa-4f37-ac23-f8e6d4d78142','28d021876b6d47e6bb3cbf1d91fe3cfc','fdf8cc9e5d484c87979d04086aa3299b','5f478d7d-5f16-457c-9a2e-0a5b051814ba',1,'tempest-tempest-created-share-snap-1789141723','Tempest\'s snapshot',1,'CEPHFS'),('2025-12-04 10:40:27.714051','2025-12-04 10:40:32.202901','2025-12-04 10:40:32.202495','bf6cd08b-18da-4eb1-b598-27dbb9cb5f7c','bf6cd08b-18da-4eb1-b598-27dbb9cb5f7c','a8ce0e9c3b1244659a5746807a574b35','421364ebc3e041b392bf764a127cfda4','901520d5-7980-429a-b3c0-142b97356ff3',1,'tempest-tempest-created-share-snap-2007736750','Tempest\'s snapshot',1,'CEPHFS'),('2025-12-04 10:48:57.948191','2025-12-04 10:49:01.804345','2025-12-04 10:49:01.803582','c8af7113-93d2-4d4c-9380-c06be20483a6','c8af7113-93d2-4d4c-9380-c06be20483a6','a7cbfaccac8f48c1bc69fb83640618a5','2c40fb2875304a41b2368725937fd373','0ba0d9dd-53af-4b75-9763-be9978723501',1,'tempest-tempest-created-share-snap-1507128154','Tempest\'s snapshot',1,'CEPHFS'),('2025-12-04 10:44:13.452025','2025-12-04 10:44:17.627479','2025-12-04 10:44:17.626972','d30d966b-f15f-4cb7-9d33-c43bf788f74f','d30d966b-f15f-4cb7-9d33-c43bf788f74f','0ef0510443b848f1bfcd4a773578d114','18048b8b581e48239e3a92c77164734b','adeaaedd-d008-4461-9733-ff7478f34676',1,'tempest-tempest-created-share-snap-1508519704','Tempest\'s snapshot',1,'CEPHFS'),('2025-12-04 10:44:20.968793','2025-12-04 10:44:27.286025','2025-12-04 10:44:27.285517','e2969563-45cb-4ab6-812a-aad69d2395d4','e2969563-45cb-4ab6-812a-aad69d2395d4','0ef0510443b848f1bfcd4a773578d114','18048b8b581e48239e3a92c77164734b','adeaaedd-d008-4461-9733-ff7478f34676',1,'tempest-tempest-created-share-snap-1663253792','Tempest\'s snapshot',1,'CEPHFS'),('2025-12-04 10:45:59.845132','2025-12-04 10:47:01.991707','2025-12-04 10:47:01.991148','eb21836e-156d-4fd6-adb6-75fc9fe014e2','eb21836e-156d-4fd6-adb6-75fc9fe014e2','c8bddd1494604235b944287494725839','bdee1673bf874393ab80f7311782fc10','54385428-bf5e-4ed6-8708-d0e0ea38cbf4',1,'tempest-tempest-snapshot-name-2143660758','tempest-tempest-snapshot-description-1730577192',1,'CEPHFS'),('2025-12-04 10:44:05.233003','2025-12-04 10:44:10.276241','2025-12-04 10:44:10.275759','eb780175-b147-4b28-95c7-37659a64381a','eb780175-b147-4b28-95c7-37659a64381a','0ef0510443b848f1bfcd4a773578d114','18048b8b581e48239e3a92c77164734b','adeaaedd-d008-4461-9733-ff7478f34676',1,'tempest-tempest-created-share-snap-2037111939','Tempest\'s snapshot',1,'CEPHFS'),('2025-12-04 10:40:23.393714','2025-12-04 10:40:35.780849','2025-12-04 10:40:35.780426','ed47c747-af46-4672-ae2b-cea707990167','ed47c747-af46-4672-ae2b-cea707990167','a8ce0e9c3b1244659a5746807a574b35','421364ebc3e041b392bf764a127cfda4','901520d5-7980-429a-b3c0-142b97356ff3',1,'tempest-tempest-created-share-snap-1013452244','Tempest\'s snapshot',1,'CEPHFS');
/*!40000 ALTER TABLE `share_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_type_extra_specs`
--

DROP TABLE IF EXISTS `share_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_type_extra_specs` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_type_id` varchar(36) NOT NULL,
  `spec_key` varchar(255) DEFAULT NULL,
  `spec_value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `st_id_fk` (`share_type_id`),
  CONSTRAINT `st_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=293 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_type_extra_specs`
--

LOCK TABLES `share_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `share_type_extra_specs` DISABLE KEYS */;
INSERT INTO `share_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_type_id`, `spec_key`, `spec_value`) VALUES ('2025-12-04 10:36:03.178707',NULL,NULL,0,1,'a2f71277-9b7c-41be-ac23-94904d0c6314','driver_handles_share_servers','False'),('2025-12-04 10:36:07.618534',NULL,NULL,0,2,'a2f71277-9b7c-41be-ac23-94904d0c6314','snapshot_support','True'),('2025-12-04 10:36:07.623460',NULL,NULL,0,3,'a2f71277-9b7c-41be-ac23-94904d0c6314','create_share_from_snapshot_support','True'),('2025-12-04 10:39:10.761626',NULL,'2025-12-04 10:40:42.794545',4,4,'e25793d0-774e-4cdf-93f8-ead2edf48a79','driver_handles_share_servers','False'),('2025-12-04 10:39:10.768417',NULL,'2025-12-04 10:40:42.794545',5,5,'e25793d0-774e-4cdf-93f8-ead2edf48a79','snapshot_support','True'),('2025-12-04 10:39:12.947051',NULL,'2025-12-04 10:39:29.313794',6,6,'703ba806-b6aa-4733-8c75-4e18892fffb1','driver_handles_share_servers','False'),('2025-12-04 10:39:12.947445',NULL,'2025-12-04 10:39:29.313794',7,7,'703ba806-b6aa-4733-8c75-4e18892fffb1','snapshot_support','True'),('2025-12-04 10:39:23.481415',NULL,'2025-12-04 10:40:02.238845',8,8,'f9c9ca5f-6992-4730-8113-73ad975de651','driver_handles_share_servers','False'),('2025-12-04 10:39:27.848383',NULL,'2025-12-04 10:39:58.295179',9,9,'fad6562a-6c8b-4475-a01e-8a7d1d4a728b','driver_handles_share_servers','False'),('2025-12-04 10:39:27.848889',NULL,'2025-12-04 10:39:58.295179',10,10,'fad6562a-6c8b-4475-a01e-8a7d1d4a728b','snapshot_support','True'),('2025-12-04 10:39:28.065412',NULL,'2025-12-04 10:39:37.272733',11,11,'c8b2d54e-9dae-4635-aff6-dcbbe64d4236','driver_handles_share_servers','False'),('2025-12-04 10:39:36.036812',NULL,'2025-12-04 10:39:50.961309',12,12,'d749ec11-bb5e-4217-b378-1e32ba8ce5ea','driver_handles_share_servers','False'),('2025-12-04 10:39:36.207068',NULL,'2025-12-04 10:39:50.777448',13,13,'34722b53-0fe5-4135-bbfc-07ed61ad89f8','driver_handles_share_servers','False'),('2025-12-04 10:39:36.328901',NULL,'2025-12-04 10:39:50.476738',14,14,'c8a5778a-de01-4b0f-9a2b-31d30765f08f','driver_handles_share_servers','False'),('2025-12-04 10:39:37.539542',NULL,'2025-12-04 10:39:50.285329',15,15,'e48f8a81-6ec9-4d8d-9855-5ca62580db14','driver_handles_share_servers','False'),('2025-12-04 10:39:37.983633',NULL,'2025-12-04 10:39:50.071393',16,16,'fcfa41e6-1dcb-4274-a61c-8f27b3dd6c5a','driver_handles_share_servers','False'),('2025-12-04 10:39:38.333712',NULL,'2025-12-04 10:39:49.685108',17,17,'a7212d2b-38e1-4ae3-a61c-8cc62c962d96','driver_handles_share_servers','False'),('2025-12-04 10:39:42.291476',NULL,'2025-12-04 10:39:49.483761',18,18,'66bcee1e-72cf-4a1d-968c-e38f1be18d29','driver_handles_share_servers','False'),('2025-12-04 10:39:42.652953',NULL,'2025-12-04 10:39:49.223860',19,19,'4a993c24-8255-423d-aa08-0e701435f516','driver_handles_share_servers','False'),('2025-12-04 10:39:42.954730',NULL,'2025-12-04 10:39:49.071721',20,20,'0d160c4e-28e1-4691-9d40-03bc882cd38a','driver_handles_share_servers','False'),('2025-12-04 10:39:43.323271',NULL,'2025-12-04 10:39:48.760119',21,21,'4430fee1-03ce-4bd4-8bdf-16d0edb16a5f','driver_handles_share_servers','False'),('2025-12-04 10:39:46.938804',NULL,'2025-12-04 10:39:48.465811',22,22,'12b751fb-da02-4535-b199-d99a9bed0ee8','driver_handles_share_servers','False'),('2025-12-04 10:39:47.584740',NULL,'2025-12-04 10:39:48.294482',23,23,'7d3d7c56-4d17-40d8-a262-f09a7a4b10f2','driver_handles_share_servers','False'),('2025-12-04 10:39:53.031707',NULL,'2025-12-04 10:40:28.393773',24,24,'9c68edba-9905-4826-9020-f24a33ca4068','driver_handles_share_servers','False'),('2025-12-04 10:39:53.032288',NULL,'2025-12-04 10:40:28.393773',25,25,'9c68edba-9905-4826-9020-f24a33ca4068','snapshot_support','True'),('2025-12-04 10:39:53.032791',NULL,'2025-12-04 10:40:28.393773',26,26,'9c68edba-9905-4826-9020-f24a33ca4068','create_share_from_snapshot_support','True'),('2025-12-04 10:39:53.201366',NULL,'2025-12-04 10:40:28.115107',27,27,'fbfa7e24-ec90-46ae-a6e9-92f64f43ac9c','driver_handles_share_servers','False'),('2025-12-04 10:39:53.296774',NULL,'2025-12-04 10:40:27.980990',28,28,'110b6a77-eee0-4f8c-ab3d-25dd7aa6b52e','driver_handles_share_servers','False'),('2025-12-04 10:40:06.367011',NULL,'2025-12-04 10:40:14.124756',29,29,'fbcd210b-f4b4-4f9a-b567-b1dd820eb42f','driver_handles_share_servers','False'),('2025-12-04 10:40:10.182157',NULL,'2025-12-04 10:40:27.831122',30,30,'191e27b4-5709-4076-ad79-3de540ef30e0','driver_handles_share_servers','False'),('2025-12-04 10:40:11.560131',NULL,'2025-12-04 10:40:27.691110',31,31,'9d03fc71-382b-4b0f-aac5-c7ab656d1abd','driver_handles_share_servers','False'),('2025-12-04 10:40:12.366735',NULL,'2025-12-04 10:40:38.521065',32,32,'4d11d944-cb21-4896-a25f-1f1bffe11b97','driver_handles_share_servers','False'),('2025-12-04 10:40:12.367491',NULL,'2025-12-04 10:40:38.521065',33,33,'4d11d944-cb21-4896-a25f-1f1bffe11b97','storage_protocol','cephfs'),('2025-12-04 10:40:12.368610',NULL,'2025-12-04 10:40:38.521065',34,34,'4d11d944-cb21-4896-a25f-1f1bffe11b97','snapshot_support','True'),('2025-12-04 10:40:12.369634',NULL,'2025-12-04 10:40:38.521065',35,35,'4d11d944-cb21-4896-a25f-1f1bffe11b97','create_share_from_snapshot_support','True'),('2025-12-04 10:40:13.094293',NULL,'2025-12-04 10:40:27.526278',36,36,'3c12f518-24ec-4873-8189-05dbe084f21b','driver_handles_share_servers','False'),('2025-12-04 10:40:19.484271',NULL,'2025-12-04 10:40:27.381397',37,37,'f70b7b0a-e2e8-4f47-b25e-f69f046f57c1','driver_handles_share_servers','False'),('2025-12-04 10:40:19.709115',NULL,'2025-12-04 10:40:42.596063',38,38,'9d536774-c83d-47c8-953e-f319caf6de44','driver_handles_share_servers','False'),('2025-12-04 10:40:19.712402',NULL,'2025-12-04 10:40:42.596063',39,39,'9d536774-c83d-47c8-953e-f319caf6de44','snapshot_support','True'),('2025-12-04 10:40:20.388145',NULL,'2025-12-04 10:40:27.228347',40,40,'4d4d71bc-9313-442c-b9a8-0ef05a123c28','driver_handles_share_servers','False'),('2025-12-04 10:40:21.551491',NULL,'2025-12-04 10:40:27.065843',41,41,'7f3df988-8170-4466-8fee-f4434cfe05a1','driver_handles_share_servers','False'),('2025-12-04 10:40:21.948064',NULL,'2025-12-04 10:40:26.880952',42,42,'c4aacbb6-42ff-46f7-aea9-dfa997f3eabe','driver_handles_share_servers','False'),('2025-12-04 10:40:32.334187',NULL,'2025-12-04 10:40:34.788201',43,43,'22948f26-d9b2-4056-a935-4694adb56088','driver_handles_share_servers','False'),('2025-12-04 10:40:32.476751',NULL,'2025-12-04 10:40:34.453820',44,44,'2f501245-f949-4929-956b-f9069247f7c4','driver_handles_share_servers','False'),('2025-12-04 10:40:32.600997',NULL,'2025-12-04 10:40:34.333509',45,45,'6dc56cc3-f611-489a-9625-b6c0aafee6b8','driver_handles_share_servers','False'),('2025-12-04 10:40:32.737646',NULL,'2025-12-04 10:40:34.127933',46,46,'04d19c7d-5976-4820-80a1-4380fa8ab1fa','driver_handles_share_servers','False'),('2025-12-04 10:40:32.862265',NULL,'2025-12-04 10:40:33.978269',47,47,'6645b788-0db4-4096-b733-db4481c666a3','driver_handles_share_servers','False'),('2025-12-04 10:40:32.862723',NULL,'2025-12-04 10:40:33.978269',48,48,'6645b788-0db4-4096-b733-db4481c666a3','share_backend_name','tempest-fake_name-955010111'),('2025-12-04 10:40:33.002134',NULL,'2025-12-04 10:40:33.731785',49,49,'408b1d4d-ab22-45e3-b850-512076343bda','driver_handles_share_servers','False'),('2025-12-04 10:40:33.002703',NULL,'2025-12-04 10:40:33.731785',50,50,'408b1d4d-ab22-45e3-b850-512076343bda','share_backend_name','tempest-fake_name-756932432'),('2025-12-04 10:40:33.138282',NULL,'2025-12-04 10:40:33.556581',51,51,'fd6797ea-a2bf-4f6d-b109-e59a52719cdf','driver_handles_share_servers','False'),('2025-12-04 10:40:33.138670',NULL,'2025-12-04 10:40:33.556581',52,52,'fd6797ea-a2bf-4f6d-b109-e59a52719cdf','share_backend_name','tempest-fake_name-518275674'),('2025-12-04 10:40:33.273504',NULL,'2025-12-04 10:40:33.414284',53,53,'fe481553-d35b-4315-87cd-2cadea2c74b9','driver_handles_share_servers','False'),('2025-12-04 10:40:33.274658',NULL,'2025-12-04 10:40:33.414284',54,54,'fe481553-d35b-4315-87cd-2cadea2c74b9','share_backend_name','tempest-fake_name-1168700998'),('2025-12-04 10:40:38.610059',NULL,'2025-12-04 10:40:49.243049',55,55,'f246ccbd-b6cd-4308-8680-879f81fe8e7d','driver_handles_share_servers','False'),('2025-12-04 10:40:47.533023',NULL,'2025-12-04 10:40:52.605645',56,56,'212e341a-acfc-41ea-b461-91c0c4a5791b','driver_handles_share_servers','False'),('2025-12-04 10:40:47.837634',NULL,'2025-12-04 10:40:48.358503',57,57,'212e341a-acfc-41ea-b461-91c0c4a5791b','key1','value1'),('2025-12-04 10:40:47.849018',NULL,'2025-12-04 10:40:52.605645',58,58,'212e341a-acfc-41ea-b461-91c0c4a5791b','key2','value2'),('2025-12-04 10:40:48.681927',NULL,'2025-12-04 10:40:52.381106',59,59,'6624f59f-aba9-41db-bd96-144dd4a39d12','driver_handles_share_servers','False'),('2025-12-04 10:40:48.927735',NULL,'2025-12-04 10:40:52.381106',60,60,'6624f59f-aba9-41db-bd96-144dd4a39d12','key1','value1'),('2025-12-04 10:40:48.929988',NULL,'2025-12-04 10:40:52.381106',61,61,'6624f59f-aba9-41db-bd96-144dd4a39d12','key2','value2'),('2025-12-04 10:40:49.213081',NULL,'2025-12-04 10:40:49.505954',62,62,'6624f59f-aba9-41db-bd96-144dd4a39d12','snapshot_support','True'),('2025-12-04 10:40:49.877324',NULL,'2025-12-04 10:40:52.228255',63,63,'ec6f4bbc-3430-47ed-b7c9-dd031528924a','driver_handles_share_servers','False'),('2025-12-04 10:40:50.069567',NULL,'2025-12-04 10:40:52.228255',64,64,'ec6f4bbc-3430-47ed-b7c9-dd031528924a','key1','value1'),('2025-12-04 10:40:50.079008',NULL,'2025-12-04 10:40:52.228255',65,65,'ec6f4bbc-3430-47ed-b7c9-dd031528924a','key2','value2'),('2025-12-04 10:40:50.182751',NULL,'2025-12-04 10:40:50.370686',66,66,'ec6f4bbc-3430-47ed-b7c9-dd031528924a','snapshot_support','True'),('2025-12-04 10:40:50.526740',NULL,'2025-12-04 10:40:52.061503',67,67,'e2eecd7f-8320-49bc-b526-b0735284c786','driver_handles_share_servers','False'),('2025-12-04 10:40:50.689045',NULL,'2025-12-04 10:41:13.526704',68,68,'d06feb78-408f-46b2-96af-3dfde13231d8','driver_handles_share_servers','False'),('2025-12-04 10:40:50.689562',NULL,'2025-12-04 10:41:13.526704',69,69,'d06feb78-408f-46b2-96af-3dfde13231d8','vendor_name','foobar'),('2025-12-04 10:40:50.708798',NULL,'2025-12-04 10:40:52.061503',70,70,'e2eecd7f-8320-49bc-b526-b0735284c786','key1','value1'),('2025-12-04 10:40:50.712945','2025-12-04 10:40:50.818624','2025-12-04 10:40:52.061503',71,71,'e2eecd7f-8320-49bc-b526-b0735284c786','key2','value2_updated'),('2025-12-04 10:40:51.011535',NULL,'2025-12-04 10:40:51.789256',72,72,'92b70af9-1a82-4277-a900-ceb78a5767d8','driver_handles_share_servers','False'),('2025-12-04 10:40:51.187808','2025-12-04 10:40:51.339786','2025-12-04 10:40:51.789256',73,73,'92b70af9-1a82-4277-a900-ceb78a5767d8','key1','fake_value1_updated'),('2025-12-04 10:40:51.189836',NULL,'2025-12-04 10:40:51.789256',74,74,'92b70af9-1a82-4277-a900-ceb78a5767d8','key2','value2'),('2025-12-04 10:40:51.197453',NULL,'2025-12-04 10:41:01.646156',75,75,'3d827517-5ff1-48c1-8133-89cd1d41e9bd','driver_handles_share_servers','False'),('2025-12-04 10:40:53.931543',NULL,'2025-12-04 10:41:16.839855',76,76,'ec0655e6-90b3-4d12-b523-1f54eacdc7a3','driver_handles_share_servers','False'),('2025-12-04 10:40:53.932043',NULL,'2025-12-04 10:41:16.839855',77,77,'ec0655e6-90b3-4d12-b523-1f54eacdc7a3','storage_protocol','cephfs'),('2025-12-04 10:40:55.223889',NULL,'2025-12-04 10:41:13.317016',78,78,'37563d7b-fcdb-4c5f-b9db-cf6680a53c05','driver_handles_share_servers','False'),('2025-12-04 10:40:55.224391',NULL,'2025-12-04 10:41:13.317016',79,79,'37563d7b-fcdb-4c5f-b9db-cf6680a53c05','vendor_name','foobar'),('2025-12-04 10:40:58.158678',NULL,'2025-12-04 10:41:13.183033',80,80,'de331f1b-754e-428f-a640-62eecf125b83','driver_handles_share_servers','False'),('2025-12-04 10:40:58.160565',NULL,'2025-12-04 10:41:13.183033',81,81,'de331f1b-754e-428f-a640-62eecf125b83','key','value'),('2025-12-04 10:40:58.898521',NULL,'2025-12-04 10:40:59.259260',82,82,'f23e1693-acba-4c2d-a938-c295eb662380','driver_handles_share_servers','False'),('2025-12-04 10:40:59.366359',NULL,'2025-12-04 10:41:13.171813',83,83,'329c3d8c-f588-46f8-a798-2f52b3017ff1','driver_handles_share_servers','False'),('2025-12-04 10:40:59.367190',NULL,'2025-12-04 10:41:13.171813',84,84,'329c3d8c-f588-46f8-a798-2f52b3017ff1','vendor_name','foobar'),('2025-12-04 10:40:59.566692',NULL,'2025-12-04 10:41:13.002678',85,85,'8cef8b7f-82d2-405e-8eb5-69781affc226','driver_handles_share_servers','False'),('2025-12-04 10:40:59.567138',NULL,'2025-12-04 10:41:13.002678',86,86,'8cef8b7f-82d2-405e-8eb5-69781affc226','key','value'),('2025-12-04 10:40:59.567662',NULL,'2025-12-04 10:41:13.002678',87,87,'8cef8b7f-82d2-405e-8eb5-69781affc226','snapshot_support','True'),('2025-12-04 10:40:59.724347',NULL,'2025-12-04 10:41:12.715691',88,88,'ea9ecce9-2731-4365-bfc5-72d48eb23393','driver_handles_share_servers','False'),('2025-12-04 10:40:59.725404',NULL,'2025-12-04 10:41:12.715691',89,89,'ea9ecce9-2731-4365-bfc5-72d48eb23393','key','value'),('2025-12-04 10:40:59.730374',NULL,'2025-12-04 10:41:12.715691',90,90,'ea9ecce9-2731-4365-bfc5-72d48eb23393','snapshot_support','True'),('2025-12-04 10:40:59.884197',NULL,'2025-12-04 10:41:12.498632',91,91,'629e5b04-50f9-405d-9aba-419cc4a3aa80','driver_handles_share_servers','False'),('2025-12-04 10:40:59.884782',NULL,'2025-12-04 10:41:12.498632',92,92,'629e5b04-50f9-405d-9aba-419cc4a3aa80','key','value'),('2025-12-04 10:40:59.885351',NULL,'2025-12-04 10:41:12.498632',93,93,'629e5b04-50f9-405d-9aba-419cc4a3aa80','snapshot_support','True'),('2025-12-04 10:41:00.192216',NULL,'2025-12-04 10:41:12.333014',94,94,'4af27250-2bae-4d04-9d56-2c96e68dfdf5','driver_handles_share_servers','False'),('2025-12-04 10:41:00.192624',NULL,'2025-12-04 10:41:12.333014',95,95,'4af27250-2bae-4d04-9d56-2c96e68dfdf5','key','value'),('2025-12-04 10:41:00.321674',NULL,'2025-12-04 10:41:11.992243',96,96,'c12dd575-4969-4307-8133-ff0ee608139d','driver_handles_share_servers','False'),('2025-12-04 10:41:00.322105',NULL,'2025-12-04 10:41:11.992243',97,97,'c12dd575-4969-4307-8133-ff0ee608139d','key','value'),('2025-12-04 10:41:00.472121',NULL,'2025-12-04 10:41:11.842026',98,98,'6e884e99-83a2-43e6-8d7f-5854891e8100','driver_handles_share_servers','False'),('2025-12-04 10:41:00.472630',NULL,'2025-12-04 10:41:11.842026',99,99,'6e884e99-83a2-43e6-8d7f-5854891e8100','snapshot_support','True'),('2025-12-04 10:41:00.984528',NULL,'2025-12-04 10:41:11.613620',100,100,'1db31cce-a42b-48b6-90e3-20d09e57d538','driver_handles_share_servers','False'),('2025-12-04 10:41:00.984933',NULL,'2025-12-04 10:41:11.613620',101,101,'1db31cce-a42b-48b6-90e3-20d09e57d538','snapshot_support','True'),('2025-12-04 10:41:01.339608',NULL,'2025-12-04 10:41:11.448154',102,102,'604c74e8-2a31-4eaa-873d-14dcdeafe735','driver_handles_share_servers','False'),('2025-12-04 10:41:01.340006',NULL,'2025-12-04 10:41:11.448154',103,103,'604c74e8-2a31-4eaa-873d-14dcdeafe735','snapshot_support','True'),('2025-12-04 10:41:01.519947',NULL,'2025-12-04 10:41:11.321275',104,104,'99340576-96be-443a-8ee2-c7fac7f652c9','driver_handles_share_servers','False'),('2025-12-04 10:41:01.758029',NULL,'2025-12-04 10:41:10.951734',105,105,'a464f9ed-c439-4119-8bf5-2bde4324f5bc','driver_handles_share_servers','False'),('2025-12-04 10:41:01.959212',NULL,'2025-12-04 10:41:10.677338',106,106,'30570b06-56b8-43ea-91fc-db662043bf14','driver_handles_share_servers','False'),('2025-12-04 10:41:02.310574',NULL,'2025-12-04 10:41:10.465338',107,107,'89e6ea60-b516-4fac-b0fc-a0b2e3c8f16e','driver_handles_share_servers','False'),('2025-12-04 10:41:02.849372',NULL,'2025-12-04 10:41:10.323319',108,108,'963dd198-ab7f-470b-ba96-705b8101f366','driver_handles_share_servers','False'),('2025-12-04 10:41:03.139231',NULL,'2025-12-04 10:41:10.175632',109,109,'4f9bc779-7b02-4d4b-b0c9-664a46fe13fe','driver_handles_share_servers','False'),('2025-12-04 10:41:03.139755',NULL,'2025-12-04 10:41:10.175632',110,110,'4f9bc779-7b02-4d4b-b0c9-664a46fe13fe','key','value'),('2025-12-04 10:41:03.604644',NULL,'2025-12-04 10:41:09.773660',111,111,'a50e875e-198a-44a1-a4a4-de589e219f6a','driver_handles_share_servers','False'),('2025-12-04 10:41:03.605883',NULL,'2025-12-04 10:41:09.773660',112,112,'a50e875e-198a-44a1-a4a4-de589e219f6a','key','value'),('2025-12-04 10:41:03.772998',NULL,'2025-12-04 10:41:13.039451',113,113,'010affb4-16b3-42ed-a4b9-506eedbbafdf','driver_handles_share_servers','False'),('2025-12-04 10:41:03.773391',NULL,'2025-12-04 10:41:13.039451',114,114,'010affb4-16b3-42ed-a4b9-506eedbbafdf','vendor_name','foobar'),('2025-12-04 10:41:03.928812',NULL,'2025-12-04 10:41:09.441697',115,115,'9b923cdf-5465-49d5-9f0c-b5e97c49f277','driver_handles_share_servers','False'),('2025-12-04 10:41:03.929464',NULL,'2025-12-04 10:41:09.441697',116,116,'9b923cdf-5465-49d5-9f0c-b5e97c49f277','key','value'),('2025-12-04 10:41:04.124492',NULL,'2025-12-04 10:41:09.208912',117,117,'c80bc07d-9348-4e0a-bc0e-7feeb9b53879','driver_handles_share_servers','False'),('2025-12-04 10:41:04.124970',NULL,'2025-12-04 10:41:09.208912',118,118,'c80bc07d-9348-4e0a-bc0e-7feeb9b53879','key','value'),('2025-12-04 10:41:04.527737',NULL,'2025-12-04 10:41:08.787448',119,119,'4ec71132-34e0-4de2-af91-0e2ef5040032','driver_handles_share_servers','False'),('2025-12-04 10:41:04.528184',NULL,'2025-12-04 10:41:08.787448',120,120,'4ec71132-34e0-4de2-af91-0e2ef5040032','key','value'),('2025-12-04 10:41:04.681400',NULL,'2025-12-04 10:41:08.538606',121,121,'09e85492-4a47-4ad8-b3f3-d1db807348e7','driver_handles_share_servers','False'),('2025-12-04 10:41:04.681824',NULL,'2025-12-04 10:41:08.538606',122,122,'09e85492-4a47-4ad8-b3f3-d1db807348e7','key','value'),('2025-12-04 10:41:04.810343',NULL,'2025-12-04 10:41:08.385946',123,123,'04d07f67-db5d-48cd-aeb2-c6ea9d17440c','driver_handles_share_servers','False'),('2025-12-04 10:41:04.810721',NULL,'2025-12-04 10:41:08.385946',124,124,'04d07f67-db5d-48cd-aeb2-c6ea9d17440c','key','value'),('2025-12-04 10:41:05.944565',NULL,'2025-12-04 10:41:08.052997',125,125,'1b09e7a7-6f78-44a1-a5f6-6a583f6beffe','driver_handles_share_servers','False'),('2025-12-04 10:41:05.945325',NULL,'2025-12-04 10:41:08.052997',126,126,'1b09e7a7-6f78-44a1-a5f6-6a583f6beffe','key','value'),('2025-12-04 10:41:06.237811',NULL,'2025-12-04 10:41:07.876467',127,127,'1f2ac325-01b8-49ec-b9b5-25ebcec4383a','driver_handles_share_servers','False'),('2025-12-04 10:41:06.238265',NULL,'2025-12-04 10:41:07.876467',128,128,'1f2ac325-01b8-49ec-b9b5-25ebcec4383a','key','value'),('2025-12-04 10:41:06.632945',NULL,'2025-12-04 10:41:07.742561',129,129,'726c179e-92d5-4308-9829-4e6d3685c219','driver_handles_share_servers','False'),('2025-12-04 10:41:06.633647',NULL,'2025-12-04 10:41:07.742561',130,130,'726c179e-92d5-4308-9829-4e6d3685c219','key','value'),('2025-12-04 10:41:06.823418',NULL,'2025-12-04 10:41:07.536461',131,131,'9d8197a3-3fdd-4768-98ff-cd5bcbada9d0','driver_handles_share_servers','False'),('2025-12-04 10:41:06.824142',NULL,'2025-12-04 10:41:07.536461',132,132,'9d8197a3-3fdd-4768-98ff-cd5bcbada9d0','key','value'),('2025-12-04 10:41:06.991501',NULL,'2025-12-04 10:41:07.262452',133,133,'814e893d-a20d-4500-a202-ee6d7977e040','driver_handles_share_servers','False'),('2025-12-04 10:41:06.992998',NULL,'2025-12-04 10:41:07.262452',134,134,'814e893d-a20d-4500-a202-ee6d7977e040','key','value'),('2025-12-04 10:41:08.073418',NULL,'2025-12-04 10:41:12.780895',135,135,'9327d215-d4cc-4d4f-9783-f891100659fa','driver_handles_share_servers','False'),('2025-12-04 10:41:08.074002',NULL,'2025-12-04 10:41:12.780895',136,136,'9327d215-d4cc-4d4f-9783-f891100659fa','vendor_name','foobar'),('2025-12-04 10:41:12.396849',NULL,'2025-12-04 10:42:08.052315',137,137,'0ccfda71-450e-4fde-bdbe-edefcab4d6c6','driver_handles_share_servers','False'),('2025-12-04 10:41:16.040474',NULL,'2025-12-04 10:41:17.821959',138,138,'8a45cfa7-fe06-4c16-ba8d-6057ad9efe75','driver_handles_share_servers','False'),('2025-12-04 10:41:16.551789',NULL,'2025-12-04 10:41:16.894632',139,139,'9147b0cd-51db-4bff-83a5-4e4b21f3582b','driver_handles_share_servers','False'),('2025-12-04 10:41:17.283128',NULL,'2025-12-04 10:41:17.612494',140,140,'8ff030ae-e094-4f81-beff-67c8fd1d2e6e','driver_handles_share_servers','False'),('2025-12-04 10:41:23.817780',NULL,'2025-12-04 10:41:26.239559',141,141,'5212c46c-5b78-4012-809b-0988bba38502','driver_handles_share_servers','False'),('2025-12-04 10:41:23.818195',NULL,'2025-12-04 10:41:26.239559',142,142,'5212c46c-5b78-4012-809b-0988bba38502','key','value'),('2025-12-04 10:41:24.434686',NULL,'2025-12-04 10:41:26.115819',143,143,'0b95dec1-3189-44fd-81fe-ee3d95bdd218','driver_handles_share_servers','False'),('2025-12-04 10:41:25.081613',NULL,'2025-12-04 10:41:25.972021',144,144,'a7d904f9-1270-48f1-a4d5-cc1bebdf9d35','driver_handles_share_servers','False'),('2025-12-04 10:41:25.081996',NULL,'2025-12-04 10:41:25.972021',145,145,'a7d904f9-1270-48f1-a4d5-cc1bebdf9d35','key','value'),('2025-12-04 10:41:25.266361',NULL,'2025-12-04 10:41:25.819404',146,146,'a4fb5023-31fe-4ccd-ad0a-bd4eb9b54575','driver_handles_share_servers','False'),('2025-12-04 10:41:25.267129',NULL,'2025-12-04 10:41:25.819404',147,147,'a4fb5023-31fe-4ccd-ad0a-bd4eb9b54575','key','value'),('2025-12-04 10:41:30.619462',NULL,'2025-12-04 10:41:39.434725',148,148,'2b8fd021-e19e-4963-9125-9f006d6d6090','driver_handles_share_servers','False'),('2025-12-04 10:41:50.258209',NULL,'2025-12-04 10:41:59.579425',149,149,'2537e953-bb9f-4f01-aa9d-2ca546adc331','driver_handles_share_servers','False'),('2025-12-04 10:41:52.600688',NULL,'2025-12-04 10:42:11.766202',150,150,'e97a3463-125a-45ea-9b75-73d586ae1dd9','driver_handles_share_servers','False'),('2025-12-04 10:41:59.471488',NULL,'2025-12-04 10:42:14.562771',151,151,'3c978cf0-17b5-4fa5-bacb-dfcf70d53863','driver_handles_share_servers','False'),('2025-12-04 10:41:59.472019',NULL,'2025-12-04 10:42:14.562771',152,152,'3c978cf0-17b5-4fa5-bacb-dfcf70d53863','snapshot_support','True'),('2025-12-04 10:42:16.380411',NULL,'2025-12-04 10:43:26.417510',153,153,'df88ce48-d3e8-48b4-aca4-3e96df85fd1c','driver_handles_share_servers','False'),('2025-12-04 10:42:19.821546',NULL,'2025-12-04 10:42:20.255067',154,154,'d147fb7e-ecc4-41e3-977e-fac235d2617b','driver_handles_share_servers','False'),('2025-12-04 10:42:20.000582',NULL,'2025-12-04 10:42:20.255067',155,155,'d147fb7e-ecc4-41e3-977e-fac235d2617b','key1','value1'),('2025-12-04 10:42:20.002893',NULL,'2025-12-04 10:42:20.255067',156,156,'d147fb7e-ecc4-41e3-977e-fac235d2617b','key2','value2'),('2025-12-04 10:42:22.288195',NULL,'2025-12-04 10:42:33.387772',157,157,'5d57a614-6f2f-4775-907b-bf29db46ccb8','driver_handles_share_servers','False'),('2025-12-04 10:42:23.714320',NULL,'2025-12-04 10:42:27.700977',158,158,'307d4b20-6837-45c5-a07c-5925c9c2b466','driver_handles_share_servers','False'),('2025-12-04 10:42:25.914081',NULL,'2025-12-04 10:42:35.449980',159,159,'f72daf9e-1243-47f4-b617-0e7bb264206a','driver_handles_share_servers','False'),('2025-12-04 10:42:25.914472',NULL,'2025-12-04 10:42:35.449980',160,160,'f72daf9e-1243-47f4-b617-0e7bb264206a','key','value'),('2025-12-04 10:42:26.151977',NULL,'2025-12-04 10:42:35.181761',161,161,'eb3a1c52-4113-42a1-8a22-2ba687b99d81','driver_handles_share_servers','False'),('2025-12-04 10:42:26.152396',NULL,'2025-12-04 10:42:35.181761',162,162,'eb3a1c52-4113-42a1-8a22-2ba687b99d81','key','value'),('2025-12-04 10:42:26.326084',NULL,'2025-12-04 10:42:34.920095',163,163,'1ebadedf-06f3-417e-890e-fe93d319ada3','driver_handles_share_servers','False'),('2025-12-04 10:42:26.326578',NULL,'2025-12-04 10:42:34.920095',164,164,'1ebadedf-06f3-417e-890e-fe93d319ada3','key','value'),('2025-12-04 10:42:26.724460',NULL,'2025-12-04 10:42:34.777028',165,165,'5861fbba-9a6c-4135-b508-b4e2548911be','driver_handles_share_servers','False'),('2025-12-04 10:42:26.724849',NULL,'2025-12-04 10:42:34.777028',166,166,'5861fbba-9a6c-4135-b508-b4e2548911be','key','value'),('2025-12-04 10:42:26.935074',NULL,'2025-12-04 10:42:34.615969',167,167,'ba7af4c1-42ef-4853-82d1-041b6a4ab72b','driver_handles_share_servers','False'),('2025-12-04 10:42:26.935524',NULL,'2025-12-04 10:42:34.615969',168,168,'ba7af4c1-42ef-4853-82d1-041b6a4ab72b','key','value'),('2025-12-04 10:42:27.107884',NULL,'2025-12-04 10:42:34.410217',169,169,'3e8d04d0-e4ee-40ec-b825-b1b6cf10d5bc','driver_handles_share_servers','False'),('2025-12-04 10:42:27.108281',NULL,'2025-12-04 10:42:34.410217',170,170,'3e8d04d0-e4ee-40ec-b825-b1b6cf10d5bc','key','value'),('2025-12-04 10:42:27.267984',NULL,'2025-12-04 10:42:34.202778',171,171,'4d669f46-efce-4f52-93db-a93d787af5ce','driver_handles_share_servers','False'),('2025-12-04 10:42:27.268485',NULL,'2025-12-04 10:42:34.202778',172,172,'4d669f46-efce-4f52-93db-a93d787af5ce','key','value'),('2025-12-04 10:42:27.475991',NULL,'2025-12-04 10:42:33.990217',173,173,'df2e8055-9b6a-47fd-b0b6-969c6c5cdfbe','driver_handles_share_servers','False'),('2025-12-04 10:42:27.477644',NULL,'2025-12-04 10:42:33.990217',174,174,'df2e8055-9b6a-47fd-b0b6-969c6c5cdfbe','key','value'),('2025-12-04 10:42:27.698204',NULL,'2025-12-04 10:42:33.634660',175,175,'93eca8ef-ad00-42c4-82aa-b200c99ba6dd','driver_handles_share_servers','False'),('2025-12-04 10:42:27.698744',NULL,'2025-12-04 10:42:33.634660',176,176,'93eca8ef-ad00-42c4-82aa-b200c99ba6dd','key','value'),('2025-12-04 10:42:27.832890',NULL,'2025-12-04 10:42:33.442767',177,177,'dfc64eec-c048-4030-b769-ae1f29ae5372','driver_handles_share_servers','False'),('2025-12-04 10:42:27.833365',NULL,'2025-12-04 10:42:33.442767',178,178,'dfc64eec-c048-4030-b769-ae1f29ae5372','key','value'),('2025-12-04 10:42:27.999227',NULL,'2025-12-04 10:42:33.023513',179,179,'bf0e9abc-e532-4c5c-b085-60c1a9fc9587','driver_handles_share_servers','False'),('2025-12-04 10:42:27.999975',NULL,'2025-12-04 10:42:33.023513',180,180,'bf0e9abc-e532-4c5c-b085-60c1a9fc9587','key','value'),('2025-12-04 10:42:28.316110',NULL,'2025-12-04 10:42:32.756696',181,181,'e649aa84-3900-4711-83ab-7b931bba4470','driver_handles_share_servers','False'),('2025-12-04 10:42:28.317414',NULL,'2025-12-04 10:42:32.756696',182,182,'e649aa84-3900-4711-83ab-7b931bba4470','key','value'),('2025-12-04 10:42:28.812972',NULL,'2025-12-04 10:42:32.603496',183,183,'ad8cd2b4-b922-4a63-a2cc-a1806d8de5c3','driver_handles_share_servers','False'),('2025-12-04 10:42:28.813361',NULL,'2025-12-04 10:42:32.603496',184,184,'ad8cd2b4-b922-4a63-a2cc-a1806d8de5c3','key','value'),('2025-12-04 10:42:29.034805',NULL,'2025-12-04 10:42:32.360544',185,185,'859e93a7-fb3c-44a1-bc2b-3a3deb617de8','driver_handles_share_servers','False'),('2025-12-04 10:42:29.035163',NULL,'2025-12-04 10:42:32.360544',186,186,'859e93a7-fb3c-44a1-bc2b-3a3deb617de8','key','value'),('2025-12-04 10:42:29.180938',NULL,'2025-12-04 10:42:32.230100',187,187,'20fca779-bfaf-4dad-9169-b3b69e818845','driver_handles_share_servers','False'),('2025-12-04 10:42:29.181301',NULL,'2025-12-04 10:42:32.230100',188,188,'20fca779-bfaf-4dad-9169-b3b69e818845','key','value'),('2025-12-04 10:42:29.327494',NULL,'2025-12-04 10:42:32.076836',189,189,'00cf4cb3-dbed-4ca2-a348-4299a8bca5b0','driver_handles_share_servers','False'),('2025-12-04 10:42:29.328214',NULL,'2025-12-04 10:42:32.076836',190,190,'00cf4cb3-dbed-4ca2-a348-4299a8bca5b0','key','value'),('2025-12-04 10:42:29.459177',NULL,'2025-12-04 10:42:31.888590',191,191,'56f5b527-aaed-40ea-9c75-95d7f22e5844','driver_handles_share_servers','False'),('2025-12-04 10:42:29.459532',NULL,'2025-12-04 10:42:31.888590',192,192,'56f5b527-aaed-40ea-9c75-95d7f22e5844','key','value'),('2025-12-04 10:42:29.639711',NULL,'2025-12-04 10:42:31.736489',193,193,'a6d5228e-c3e5-4d7a-b449-cf7714db4020','driver_handles_share_servers','False'),('2025-12-04 10:42:29.640120',NULL,'2025-12-04 10:42:31.736489',194,194,'a6d5228e-c3e5-4d7a-b449-cf7714db4020','key','value'),('2025-12-04 10:42:29.909759',NULL,'2025-12-04 10:42:31.594834',195,195,'43b54a32-5cc4-4b8b-a244-78c27efc6951','driver_handles_share_servers','False'),('2025-12-04 10:42:29.910197',NULL,'2025-12-04 10:42:31.594834',196,196,'43b54a32-5cc4-4b8b-a244-78c27efc6951','key','value'),('2025-12-04 10:42:30.082652',NULL,'2025-12-04 10:42:31.458645',197,197,'296c5458-c7e3-4719-af27-469b3f67b49a','driver_handles_share_servers','False'),('2025-12-04 10:42:30.083024',NULL,'2025-12-04 10:42:31.458645',198,198,'296c5458-c7e3-4719-af27-469b3f67b49a','key','value'),('2025-12-04 10:42:30.196981',NULL,'2025-12-04 10:42:31.269420',199,199,'ad721822-46df-4659-8f26-0211e20d869a','driver_handles_share_servers','False'),('2025-12-04 10:42:30.197376',NULL,'2025-12-04 10:42:31.269420',200,200,'ad721822-46df-4659-8f26-0211e20d869a','key','value'),('2025-12-04 10:42:30.566842',NULL,'2025-12-04 10:42:31.032281',201,201,'5bc47110-6480-415f-8d59-a13ef071a86e','driver_handles_share_servers','False'),('2025-12-04 10:42:30.567192',NULL,'2025-12-04 10:42:31.032281',202,202,'5bc47110-6480-415f-8d59-a13ef071a86e','key','value'),('2025-12-04 10:42:35.475767',NULL,'2025-12-04 10:42:39.369886',203,203,'7ba659d1-3dac-4fec-8f0a-7a23ca697aaf','driver_handles_share_servers','False'),('2025-12-04 10:42:41.606900',NULL,'2025-12-04 10:42:43.346177',204,204,'39d87728-bb9a-49dc-95c9-acd1467ff5e8','driver_handles_share_servers','False'),('2025-12-04 10:42:45.029639',NULL,'2025-12-04 10:43:27.500935',205,205,'d20023e3-0d3f-4f8d-bc4b-35c7fd908150','driver_handles_share_servers','False'),('2025-12-04 10:42:45.030076',NULL,'2025-12-04 10:43:27.500935',206,206,'d20023e3-0d3f-4f8d-bc4b-35c7fd908150','vendor_name','foobar'),('2025-12-04 10:42:49.271107',NULL,'2025-12-04 10:42:55.187466',207,207,'b2157044-5f23-4022-bef2-d9afb5418e95','driver_handles_share_servers','False'),('2025-12-04 10:42:49.487243',NULL,'2025-12-04 10:43:27.255869',208,208,'6689d307-ef56-40d7-ad85-62dddaf7d4ba','driver_handles_share_servers','False'),('2025-12-04 10:42:49.487603',NULL,'2025-12-04 10:43:27.255869',209,209,'6689d307-ef56-40d7-ad85-62dddaf7d4ba','vendor_name','foobar'),('2025-12-04 10:42:53.507578',NULL,'2025-12-04 10:43:26.901465',210,210,'bae4e5c8-4bd0-4aef-8463-ce3e493d8f98','driver_handles_share_servers','False'),('2025-12-04 10:42:53.509372',NULL,'2025-12-04 10:43:26.901465',211,211,'bae4e5c8-4bd0-4aef-8463-ce3e493d8f98','vendor_name','foobar'),('2025-12-04 10:42:53.730360',NULL,'2025-12-04 10:43:10.110896',212,212,'6f383b65-791c-4bc0-a865-8a8a9d0fd30c','driver_handles_share_servers','False'),('2025-12-04 10:42:57.367825',NULL,'2025-12-04 10:43:26.478551',213,213,'ce0f25d3-27ba-44eb-9b51-7c8fa400875f','driver_handles_share_servers','False'),('2025-12-04 10:42:57.368284',NULL,'2025-12-04 10:43:26.478551',214,214,'ce0f25d3-27ba-44eb-9b51-7c8fa400875f','vendor_name','foobar'),('2025-12-04 10:43:01.600603',NULL,'2025-12-04 10:43:26.317584',215,215,'51dc31d5-ae2f-4cc3-99b0-d9bca2c752df','driver_handles_share_servers','False'),('2025-12-04 10:43:01.601042',NULL,'2025-12-04 10:43:26.317584',216,216,'51dc31d5-ae2f-4cc3-99b0-d9bca2c752df','vendor_name','foobar'),('2025-12-04 10:43:03.230325',NULL,'2025-12-04 10:43:06.793649',217,217,'5fde03b2-931e-43c8-9d6a-a1879fc56bb8','driver_handles_share_servers','False'),('2025-12-04 10:43:05.237361',NULL,'2025-12-04 10:43:26.046078',218,218,'7793f738-7930-4537-9dfb-f37145dcc966','driver_handles_share_servers','False'),('2025-12-04 10:43:05.237825',NULL,'2025-12-04 10:43:26.046078',219,219,'7793f738-7930-4537-9dfb-f37145dcc966','vendor_name','foobar'),('2025-12-04 10:43:08.814792',NULL,'2025-12-04 10:43:25.895291',220,220,'6836a084-0716-44fd-a4c3-db6585ee754e','driver_handles_share_servers','False'),('2025-12-04 10:43:08.815197',NULL,'2025-12-04 10:43:25.895291',221,221,'6836a084-0716-44fd-a4c3-db6585ee754e','vendor_name','foobar'),('2025-12-04 10:43:13.591118',NULL,'2025-12-04 10:43:25.699040',222,222,'515a821b-2c06-477c-82fe-373c817226c6','driver_handles_share_servers','False'),('2025-12-04 10:43:13.591622',NULL,'2025-12-04 10:43:25.699040',223,223,'515a821b-2c06-477c-82fe-373c817226c6','vendor_name','foobar'),('2025-12-04 10:43:15.139009',NULL,'2025-12-04 10:43:54.333568',224,224,'820e79dd-be75-4d91-aca0-04a50b785894','driver_handles_share_servers','False'),('2025-12-04 10:43:15.524119',NULL,'2025-12-04 10:43:15.745389',225,225,'85426e32-7637-4a1f-88c0-7649ad3c01b1','driver_handles_share_servers','False'),('2025-12-04 10:43:15.524518',NULL,'2025-12-04 10:43:15.745389',226,226,'85426e32-7637-4a1f-88c0-7649ad3c01b1','availability_zones','az1,az2,az 3'),('2025-12-04 10:43:15.921964',NULL,'2025-12-04 10:43:16.148641',227,227,'1c2811e2-49ee-485a-90e5-994f0ca765af','driver_handles_share_servers','False'),('2025-12-04 10:43:15.922386',NULL,'2025-12-04 10:43:16.148641',228,228,'1c2811e2-49ee-485a-90e5-994f0ca765af','availability_zones','az1,az2,az 3'),('2025-12-04 10:43:16.297009',NULL,'2025-12-04 10:43:16.443054',229,229,'922b7553-fadd-44fa-9410-24acaa658017','driver_handles_share_servers','False'),('2025-12-04 10:43:16.297436',NULL,'2025-12-04 10:43:16.443054',230,230,'922b7553-fadd-44fa-9410-24acaa658017','availability_zones','az1,az2,az 3'),('2025-12-04 10:43:16.666405',NULL,'2025-12-04 10:43:17.108178',231,231,'e507717b-725c-422d-8dad-5d83efc6498f','driver_handles_share_servers','False'),('2025-12-04 10:43:16.666798',NULL,'2025-12-04 10:43:17.108178',232,232,'e507717b-725c-422d-8dad-5d83efc6498f','availability_zones','az1,az2,az 3'),('2025-12-04 10:43:16.731523',NULL,'2025-12-04 10:43:16.876022',233,233,'e8096e49-2096-4348-b476-0dbce41dc075','driver_handles_share_servers','False'),('2025-12-04 10:43:17.272449',NULL,'2025-12-04 10:43:25.541287',234,234,'4e0237cc-4b31-40b5-97b2-740edbe506d4','driver_handles_share_servers','False'),('2025-12-04 10:43:17.272947',NULL,'2025-12-04 10:43:25.541287',235,235,'4e0237cc-4b31-40b5-97b2-740edbe506d4','vendor_name','foobar'),('2025-12-04 10:43:17.279997',NULL,'2025-12-04 10:43:17.650713',236,236,'4ea962a5-2cbf-4150-b741-4cc52a0a7f4f','driver_handles_share_servers','False'),('2025-12-04 10:43:17.280418',NULL,'2025-12-04 10:43:17.650713',237,237,'4ea962a5-2cbf-4150-b741-4cc52a0a7f4f','availability_zones','az1,az2,az 3'),('2025-12-04 10:43:17.357040',NULL,'2025-12-04 10:43:17.502468',238,238,'f3abcc8e-2e4b-48f2-a41f-3b439e54d0f1','driver_handles_share_servers','False'),('2025-12-04 10:43:17.803396',NULL,'2025-12-04 10:43:18.212758',239,239,'b5792ae9-819b-4f80-81c1-34f733a0b652','driver_handles_share_servers','False'),('2025-12-04 10:43:17.803815',NULL,'2025-12-04 10:43:18.212758',240,240,'b5792ae9-819b-4f80-81c1-34f733a0b652','availability_zones','az1,az2,az 3'),('2025-12-04 10:43:17.870778',NULL,'2025-12-04 10:43:18.083307',241,241,'2b24de9d-b264-483b-be27-0096aedb0919','driver_handles_share_servers','False'),('2025-12-04 10:43:18.070894',NULL,'2025-12-04 10:43:33.532692',242,242,'10e75b0e-4372-4109-8731-61024b16f85c','driver_handles_share_servers','False'),('2025-12-04 10:43:18.072807',NULL,'2025-12-04 10:43:33.532692',243,243,'10e75b0e-4372-4109-8731-61024b16f85c','snapshot_support','True'),('2025-12-04 10:43:18.349674',NULL,'2025-12-04 10:43:18.673094',244,244,'700db3bc-2280-432f-a7da-e27cd9fe00d4','driver_handles_share_servers','False'),('2025-12-04 10:43:18.350213',NULL,'2025-12-04 10:43:18.673094',245,245,'700db3bc-2280-432f-a7da-e27cd9fe00d4','availability_zones','az1,az2,az 3'),('2025-12-04 10:43:18.409084',NULL,'2025-12-04 10:43:18.539231',246,246,'359cb958-946d-45c7-9777-86f75f4031db','driver_handles_share_servers','False'),('2025-12-04 10:43:18.801260',NULL,'2025-12-04 10:43:19.189492',247,247,'bf9bee7c-a7a7-4c96-bb5f-818014a7559f','driver_handles_share_servers','False'),('2025-12-04 10:43:18.801839',NULL,'2025-12-04 10:43:19.189492',248,248,'bf9bee7c-a7a7-4c96-bb5f-818014a7559f','availability_zones','az1,az2,az 3'),('2025-12-04 10:43:18.873335',NULL,'2025-12-04 10:43:19.049256',249,249,'4188ea25-67a7-4851-be4e-231958237070','driver_handles_share_servers','False'),('2025-12-04 10:43:19.299934',NULL,'2025-12-04 10:43:19.586641',250,250,'f8e08b5f-33ae-488c-b94b-b1dc3b67436e','driver_handles_share_servers','False'),('2025-12-04 10:43:19.300285',NULL,'2025-12-04 10:43:19.586641',251,251,'f8e08b5f-33ae-488c-b94b-b1dc3b67436e','availability_zones','az1,az2,az 3'),('2025-12-04 10:43:19.350869',NULL,'2025-12-04 10:43:19.468820',252,252,'6ed94a15-5358-49a0-b8ca-d05b2e35b074','driver_handles_share_servers','False'),('2025-12-04 10:43:19.713410','2025-12-04 10:43:33.894404','2025-12-04 10:43:54.333568',253,253,'820e79dd-be75-4d91-aca0-04a50b785894','availability_zones','nova'),('2025-12-04 10:43:21.564386',NULL,'2025-12-04 10:43:25.374367',254,254,'a1ec9089-0fd2-48fb-bf6a-18efd8277aeb','driver_handles_share_servers','False'),('2025-12-04 10:43:21.564841',NULL,'2025-12-04 10:43:25.374367',255,255,'a1ec9089-0fd2-48fb-bf6a-18efd8277aeb','vendor_name','foobar'),('2025-12-04 10:43:33.607960',NULL,'2025-12-04 10:43:57.422579',256,256,'670a24d3-016f-4e59-b59c-2a560b5418dd','driver_handles_share_servers','False'),('2025-12-04 10:43:36.017848',NULL,'2025-12-04 10:44:42.832978',257,257,'4c300d44-f839-46b6-b125-41134ef8ee22','driver_handles_share_servers','False'),('2025-12-04 10:43:42.036138',NULL,'2025-12-04 10:43:44.018525',258,258,'ba8ee9d1-82b5-4b99-b07c-ef1511a29010','driver_handles_share_servers','False'),('2025-12-04 10:43:42.096577',NULL,'2025-12-04 10:43:43.766418',259,259,'e5b9a05a-3938-4069-9c62-1d6a8427d47a','driver_handles_share_servers','False'),('2025-12-04 10:43:42.097026',NULL,'2025-12-04 10:43:43.766418',260,260,'e5b9a05a-3938-4069-9c62-1d6a8427d47a','provisioning:max_share_size','5'),('2025-12-04 10:43:42.097367',NULL,'2025-12-04 10:43:43.766418',261,261,'e5b9a05a-3938-4069-9c62-1d6a8427d47a','provisioning:min_share_size','2'),('2025-12-04 10:43:52.518686',NULL,'2025-12-04 10:44:47.419229',262,262,'8e1ebbba-1c74-478b-9238-956133ca0d56','driver_handles_share_servers','False'),('2025-12-04 10:43:52.519090',NULL,'2025-12-04 10:44:47.419229',263,263,'8e1ebbba-1c74-478b-9238-956133ca0d56','snapshot_support','True'),('2025-12-04 10:43:52.519800',NULL,'2025-12-04 10:44:47.419229',264,264,'8e1ebbba-1c74-478b-9238-956133ca0d56','create_share_from_snapshot_support','True'),('2025-12-04 10:44:05.411970',NULL,'2025-12-04 10:44:13.543596',265,265,'d2cb06dc-eba6-4fed-a094-61bf857c0e07','driver_handles_share_servers','False'),('2025-12-04 10:44:27.427729',NULL,NULL,0,266,'b022472d-700d-41d8-9151-d06e86a7dc3f','driver_handles_share_servers','False'),('2025-12-04 10:45:07.920106',NULL,'2025-12-04 10:45:38.703349',267,267,'79086422-8620-41bb-ad72-d3d2e0f09707','driver_handles_share_servers','False'),('2025-12-04 10:45:47.537589',NULL,'2025-12-04 10:45:49.216376',268,268,'472be5b2-30dd-410b-8fb9-cb79a98551d9','driver_handles_share_servers','False'),('2025-12-04 10:45:48.043811','2025-12-04 10:45:48.373430','2025-12-04 10:45:49.216376',269,269,'472be5b2-30dd-410b-8fb9-cb79a98551d9','availability_zones','az_that_doesnt_exist'),('2025-12-04 10:45:48.108439',NULL,'2025-12-04 10:45:48.245626',270,270,'68afadff-422b-4898-abfb-c2acbad1eeae','driver_handles_share_servers','False'),('2025-12-04 10:45:56.232566',NULL,'2025-12-04 10:47:08.468597',271,271,'ac7bd782-cd71-4f35-9fed-0f011ba5e09d','driver_handles_share_servers','False'),('2025-12-04 10:45:56.233023',NULL,'2025-12-04 10:47:08.468597',272,272,'ac7bd782-cd71-4f35-9fed-0f011ba5e09d','snapshot_support','True'),('2025-12-04 10:45:56.233400',NULL,'2025-12-04 10:47:08.468597',273,273,'ac7bd782-cd71-4f35-9fed-0f011ba5e09d','create_share_from_snapshot_support','True'),('2025-12-04 10:47:17.355691',NULL,'2025-12-04 10:47:47.309475',274,274,'7e2e54b3-9fc4-42f1-9682-dfd37ababbc9','driver_handles_share_servers','False'),('2025-12-04 10:47:17.357370',NULL,'2025-12-04 10:47:47.309475',275,275,'7e2e54b3-9fc4-42f1-9682-dfd37ababbc9','snapshot_support','True'),('2025-12-04 10:47:17.358015',NULL,'2025-12-04 10:47:47.309475',276,276,'7e2e54b3-9fc4-42f1-9682-dfd37ababbc9','create_share_from_snapshot_support','True'),('2025-12-04 10:47:53.471423',NULL,'2025-12-04 10:48:08.671903',277,277,'9f12719f-820d-45f8-8b37-c67efc69baf2','driver_handles_share_servers','False'),('2025-12-04 10:47:53.471847',NULL,'2025-12-04 10:48:08.671903',278,278,'9f12719f-820d-45f8-8b37-c67efc69baf2','snapshot_support','True'),('2025-12-04 10:47:55.284680',NULL,'2025-12-04 10:48:10.328224',279,279,'c0d93c20-f27c-4fec-9d23-328c1d8e67c8','driver_handles_share_servers','False'),('2025-12-04 10:47:55.285205',NULL,'2025-12-04 10:48:10.328224',280,280,'c0d93c20-f27c-4fec-9d23-328c1d8e67c8','snapshot_support','True'),('2025-12-04 10:47:55.285567',NULL,'2025-12-04 10:48:10.328224',281,281,'c0d93c20-f27c-4fec-9d23-328c1d8e67c8','create_share_from_snapshot_support','True'),('2025-12-04 10:48:24.993874',NULL,'2025-12-04 10:48:26.782638',282,282,'63fbdeba-d401-478e-befd-74ef3abe36dd','driver_handles_share_servers','False'),('2025-12-04 10:48:40.278858',NULL,'2025-12-04 10:48:42.657839',283,283,'465f3a3f-e54f-41a0-91ab-6aa0a218cbc4','driver_handles_share_servers','False'),('2025-12-04 10:48:40.424946',NULL,'2025-12-04 10:48:42.450780',284,284,'9959377b-cfad-492b-b92a-ef90c3b297f7','driver_handles_share_servers','False'),('2025-12-04 10:48:53.898273',NULL,'2025-12-04 10:50:39.714656',285,285,'8446d21c-69f2-4851-933b-997effa49241','driver_handles_share_servers','False'),('2025-12-04 10:48:53.977608',NULL,'2025-12-04 10:49:08.525357',286,286,'067e02e9-90fb-47d1-be2d-f4ea7d81904d','driver_handles_share_servers','False'),('2025-12-04 10:48:53.978265',NULL,'2025-12-04 10:49:08.525357',287,287,'067e02e9-90fb-47d1-be2d-f4ea7d81904d','snapshot_support','True'),('2025-12-04 10:49:15.732627',NULL,'2025-12-04 10:50:38.643968',288,288,'83cb9767-1df4-4921-a073-4398082b463f','driver_handles_share_servers','False'),('2025-12-04 10:49:15.733232',NULL,'2025-12-04 10:50:38.643968',289,289,'83cb9767-1df4-4921-a073-4398082b463f','snapshot_support','True'),('2025-12-04 10:49:15.740193',NULL,'2025-12-04 10:50:38.643968',290,290,'83cb9767-1df4-4921-a073-4398082b463f','create_share_from_snapshot_support','True'),('2025-12-04 10:50:49.950492',NULL,'2025-12-04 10:51:41.438850',291,291,'6a3c87d9-578e-441f-9691-5571c558f82e','driver_handles_share_servers','False'),('2025-12-04 10:50:49.950984',NULL,'2025-12-04 10:51:41.438850',292,292,'6a3c87d9-578e-441f-9691-5571c558f82e','snapshot_support','True');
/*!40000 ALTER TABLE `share_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_type_projects`
--

DROP TABLE IF EXISTS `share_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `stp_project_id_uc` (`share_type_id`,`project_id`,`deleted`),
  CONSTRAINT `stp_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_type_projects`
--

LOCK TABLES `share_type_projects` WRITE;
/*!40000 ALTER TABLE `share_type_projects` DISABLE KEYS */;
INSERT INTO `share_type_projects` (`id`, `created_at`, `updated_at`, `deleted_at`, `share_type_id`, `project_id`, `deleted`) VALUES (1,'2025-12-04 10:40:58.478572',NULL,'2025-12-04 10:40:58.682585','de331f1b-754e-428f-a640-62eecf125b83','de70f6413fb248c6a07e498350f7a8e3',1);
/*!40000 ALTER TABLE `share_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_types`
--

DROP TABLE IF EXISTS `share_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_types` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `st_name_uc` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_types`
--

LOCK TABLES `share_types` WRITE;
/*!40000 ALTER TABLE `share_types` DISABLE KEYS */;
INSERT INTO `share_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `is_public`, `description`) VALUES ('2025-12-04 10:42:29.326515',NULL,'2025-12-04 10:42:32.079235','00cf4cb3-dbed-4ca2-a348-4299a8bca5b0','00cf4cb3-dbed-4ca2-a348-4299a8bca5b0','tempest-typeshare-type-1576624239',1,NULL),('2025-12-04 10:41:03.772275',NULL,'2025-12-04 10:41:13.041972','010affb4-16b3-42ed-a4b9-506eedbbafdf','010affb4-16b3-42ed-a4b9-506eedbbafdf','tempest-share-type-228280591',1,NULL),('2025-12-04 10:41:04.809346','2025-12-04 10:41:05.342910','2025-12-04 10:41:08.388390','04d07f67-db5d-48cd-aeb2-c6ea9d17440c','04d07f67-db5d-48cd-aeb2-c6ea9d17440c','tempest-type_updated-364110747',1,'Description for share type'),('2025-12-04 10:40:32.736848',NULL,'2025-12-04 10:40:34.130125','04d19c7d-5976-4820-80a1-4380fa8ab1fa','04d19c7d-5976-4820-80a1-4380fa8ab1fa','tempest-typeshare-type-586062827',1,NULL),('2025-12-04 10:48:53.976709',NULL,'2025-12-04 10:49:08.527865','067e02e9-90fb-47d1-be2d-f4ea7d81904d','067e02e9-90fb-47d1-be2d-f4ea7d81904d','tempest-typeshare-type-370970166',1,NULL),('2025-12-04 10:41:04.680568','2025-12-04 10:41:04.749144','2025-12-04 10:41:08.541062','09e85492-4a47-4ad8-b3f3-d1db807348e7','09e85492-4a47-4ad8-b3f3-d1db807348e7','tempest-type_updated-1780902395',1,'description_updated'),('2025-12-04 10:41:24.434004',NULL,'2025-12-04 10:41:26.118117','0b95dec1-3189-44fd-81fe-ee3d95bdd218','0b95dec1-3189-44fd-81fe-ee3d95bdd218','tempest-share-type-662895476',0,NULL),('2025-12-04 10:41:12.396094',NULL,'2025-12-04 10:42:08.056317','0ccfda71-450e-4fde-bdbe-edefcab4d6c6','0ccfda71-450e-4fde-bdbe-edefcab4d6c6','tempest-typeshare-type-417381687',1,NULL),('2025-12-04 10:39:42.953486',NULL,'2025-12-04 10:39:49.077102','0d160c4e-28e1-4691-9d40-03bc882cd38a','0d160c4e-28e1-4691-9d40-03bc882cd38a','tempest-typeshare-type-1218711616',1,NULL),('2025-12-04 10:43:18.070039',NULL,'2025-12-04 10:43:33.537472','10e75b0e-4372-4109-8731-61024b16f85c','10e75b0e-4372-4109-8731-61024b16f85c','tempest-typeshare-type-55497825',1,NULL),('2025-12-04 10:39:53.295836',NULL,'2025-12-04 10:40:27.983745','110b6a77-eee0-4f8c-ab3d-25dd7aa6b52e','110b6a77-eee0-4f8c-ab3d-25dd7aa6b52e','tempest-typeshare-type-1152958478',1,NULL),('2025-12-04 10:39:46.937846',NULL,'2025-12-04 10:39:48.468334','12b751fb-da02-4535-b199-d99a9bed0ee8','12b751fb-da02-4535-b199-d99a9bed0ee8','tempest-typeshare-type-1415120703',1,NULL),('2025-12-04 10:40:10.181349',NULL,'2025-12-04 10:40:27.833829','191e27b4-5709-4076-ad79-3de540ef30e0','191e27b4-5709-4076-ad79-3de540ef30e0','tempest-typeshare-type-527185419',1,NULL),('2025-12-04 10:41:05.942796','2025-12-04 10:41:06.160416','2025-12-04 10:41:08.055740','1b09e7a7-6f78-44a1-a5f6-6a583f6beffe','1b09e7a7-6f78-44a1-a5f6-6a583f6beffe','tempest-tempest-manila-1915874250',1,'description_updated'),('2025-12-04 10:43:15.921197',NULL,'2025-12-04 10:43:16.150886','1c2811e2-49ee-485a-90e5-994f0ca765af','1c2811e2-49ee-485a-90e5-994f0ca765af','tempest-az_share_type-2047227208',1,NULL),('2025-12-04 10:41:00.983676',NULL,'2025-12-04 10:41:11.616080','1db31cce-a42b-48b6-90e3-20d09e57d538','1db31cce-a42b-48b6-90e3-20d09e57d538','tempest-tempest-manila-1709905779',1,NULL),('2025-12-04 10:42:26.325101',NULL,'2025-12-04 10:42:34.928223','1ebadedf-06f3-417e-890e-fe93d319ada3','1ebadedf-06f3-417e-890e-fe93d319ada3','tempest-typeshare-type-318546017',1,NULL),('2025-12-04 10:41:06.237150','2025-12-04 10:41:06.550893','2025-12-04 10:41:07.879191','1f2ac325-01b8-49ec-b9b5-25ebcec4383a','1f2ac325-01b8-49ec-b9b5-25ebcec4383a','tempest-tempest-manila-1659445324',1,'Description for share type'),('2025-12-04 10:42:29.180255',NULL,'2025-12-04 10:42:32.233514','20fca779-bfaf-4dad-9169-b3b69e818845','20fca779-bfaf-4dad-9169-b3b69e818845','tempest-typeshare-type-1960704976',1,NULL),('2025-12-04 10:40:47.529862',NULL,'2025-12-04 10:40:52.608673','212e341a-acfc-41ea-b461-91c0c4a5791b','212e341a-acfc-41ea-b461-91c0c4a5791b','tempest-share-type-561418493',1,NULL),('2025-12-04 10:40:32.333222',NULL,'2025-12-04 10:40:34.791150','22948f26-d9b2-4056-a935-4694adb56088','22948f26-d9b2-4056-a935-4694adb56088','tempest-typeshare-type-1617948518',1,NULL),('2025-12-04 10:41:50.257291',NULL,'2025-12-04 10:41:59.583265','2537e953-bb9f-4f01-aa9d-2ca546adc331','2537e953-bb9f-4f01-aa9d-2ca546adc331','tempest-typeshare-type-1917039939',1,NULL),('2025-12-04 10:42:30.081725',NULL,'2025-12-04 10:42:31.462674','296c5458-c7e3-4719-af27-469b3f67b49a','296c5458-c7e3-4719-af27-469b3f67b49a','tempest-typeshare-type-551771409',1,NULL),('2025-12-04 10:43:17.869838',NULL,'2025-12-04 10:43:18.086212','2b24de9d-b264-483b-be27-0096aedb0919','2b24de9d-b264-483b-be27-0096aedb0919','tempest-support_any_az_share_type-1551505525',1,NULL),('2025-12-04 10:41:30.618643',NULL,'2025-12-04 10:41:39.438101','2b8fd021-e19e-4963-9125-9f006d6d6090','2b8fd021-e19e-4963-9125-9f006d6d6090','tempest-typeshare-type-1119315165',1,NULL),('2025-12-04 10:40:32.476067',NULL,'2025-12-04 10:40:34.456472','2f501245-f949-4929-956b-f9069247f7c4','2f501245-f949-4929-956b-f9069247f7c4','tempest-typeshare-type-1737789109',1,NULL),('2025-12-04 10:41:01.958449',NULL,'2025-12-04 10:41:10.679709','30570b06-56b8-43ea-91fc-db662043bf14','30570b06-56b8-43ea-91fc-db662043bf14','tempest-tempest-manila-1562969691',1,NULL),('2025-12-04 10:42:23.711184',NULL,'2025-12-04 10:42:27.711872','307d4b20-6837-45c5-a07c-5925c9c2b466','307d4b20-6837-45c5-a07c-5925c9c2b466','tempest-typeshare-type-816401915',1,NULL),('2025-12-04 10:40:59.365538',NULL,'2025-12-04 10:41:13.174743','329c3d8c-f588-46f8-a798-2f52b3017ff1','329c3d8c-f588-46f8-a798-2f52b3017ff1','tempest-share-type-921833567',1,NULL),('2025-12-04 10:39:36.205875',NULL,'2025-12-04 10:39:50.781959','34722b53-0fe5-4135-bbfc-07ed61ad89f8','34722b53-0fe5-4135-bbfc-07ed61ad89f8','tempest-typeshare-type-496402054',1,NULL),('2025-12-04 10:43:18.408330',NULL,'2025-12-04 10:43:18.541657','359cb958-946d-45c7-9777-86f75f4031db','359cb958-946d-45c7-9777-86f75f4031db','tempest-support_any_az_share_type-346135586',1,NULL),('2025-12-04 10:40:55.223156',NULL,'2025-12-04 10:41:13.319718','37563d7b-fcdb-4c5f-b9db-cf6680a53c05','37563d7b-fcdb-4c5f-b9db-cf6680a53c05','tempest-share-type-1401346925',1,NULL),('2025-12-04 10:42:41.606298',NULL,'2025-12-04 10:42:43.350017','39d87728-bb9a-49dc-95c9-acd1467ff5e8','39d87728-bb9a-49dc-95c9-acd1467ff5e8','tempest-typeshare-type-752083302',1,NULL),('2025-12-04 10:40:13.093522',NULL,'2025-12-04 10:40:27.528771','3c12f518-24ec-4873-8189-05dbe084f21b','3c12f518-24ec-4873-8189-05dbe084f21b','tempest-typeshare-type-1617251882',1,NULL),('2025-12-04 10:41:59.470697',NULL,'2025-12-04 10:42:14.564898','3c978cf0-17b5-4fa5-bacb-dfcf70d53863','3c978cf0-17b5-4fa5-bacb-dfcf70d53863','tempest-typeshare-type-1236036858',1,NULL),('2025-12-04 10:40:51.196892',NULL,'2025-12-04 10:41:01.649748','3d827517-5ff1-48c1-8133-89cd1d41e9bd','3d827517-5ff1-48c1-8133-89cd1d41e9bd','tempest-typeshare-type-1815152009',1,NULL),('2025-12-04 10:42:27.107199',NULL,'2025-12-04 10:42:34.414522','3e8d04d0-e4ee-40ec-b825-b1b6cf10d5bc','3e8d04d0-e4ee-40ec-b825-b1b6cf10d5bc','tempest-typeshare-type-349653250',1,NULL),('2025-12-04 10:40:33.001247',NULL,'2025-12-04 10:40:33.738442','408b1d4d-ab22-45e3-b850-512076343bda','408b1d4d-ab22-45e3-b850-512076343bda','tempest-unique_st_name-860608970',1,NULL),('2025-12-04 10:43:18.872668',NULL,'2025-12-04 10:43:19.055585','4188ea25-67a7-4851-be4e-231958237070','4188ea25-67a7-4851-be4e-231958237070','tempest-support_any_az_share_type-1851689883',1,NULL),('2025-12-04 10:42:29.909002',NULL,'2025-12-04 10:42:31.599452','43b54a32-5cc4-4b8b-a244-78c27efc6951','43b54a32-5cc4-4b8b-a244-78c27efc6951','tempest-typeshare-type-1566345077',1,NULL),('2025-12-04 10:39:43.322545',NULL,'2025-12-04 10:39:48.764310','4430fee1-03ce-4bd4-8bdf-16d0edb16a5f','4430fee1-03ce-4bd4-8bdf-16d0edb16a5f','tempest-typeshare-type-1687541257',1,NULL),('2025-12-04 10:48:40.278064',NULL,'2025-12-04 10:48:42.664764','465f3a3f-e54f-41a0-91ab-6aa0a218cbc4','465f3a3f-e54f-41a0-91ab-6aa0a218cbc4','tempest-typeshare-type-829204965',1,NULL),('2025-12-04 10:45:47.536770',NULL,'2025-12-04 10:45:49.220764','472be5b2-30dd-410b-8fb9-cb79a98551d9','472be5b2-30dd-410b-8fb9-cb79a98551d9','tempest-typeshare-type-934708363',1,NULL),('2025-12-04 10:39:42.652242',NULL,'2025-12-04 10:39:49.226387','4a993c24-8255-423d-aa08-0e701435f516','4a993c24-8255-423d-aa08-0e701435f516','tempest-typeshare-type-1117872768',1,NULL),('2025-12-04 10:41:00.191104',NULL,'2025-12-04 10:41:12.335488','4af27250-2bae-4d04-9d56-2c96e68dfdf5','4af27250-2bae-4d04-9d56-2c96e68dfdf5','tempest-tempest-manila-695707115',1,NULL),('2025-12-04 10:43:36.017002',NULL,'2025-12-04 10:44:42.835345','4c300d44-f839-46b6-b125-41134ef8ee22','4c300d44-f839-46b6-b125-41134ef8ee22','tempest-typeshare-type-318434128',1,NULL),('2025-12-04 10:40:12.365984',NULL,'2025-12-04 10:40:38.523613','4d11d944-cb21-4896-a25f-1f1bffe11b97','4d11d944-cb21-4896-a25f-1f1bffe11b97','tempest-typeshare-type-2039669118',1,NULL),('2025-12-04 10:40:20.387371',NULL,'2025-12-04 10:40:27.236041','4d4d71bc-9313-442c-b9a8-0ef05a123c28','4d4d71bc-9313-442c-b9a8-0ef05a123c28','tempest-typeshare-type-2049035381',0,NULL),('2025-12-04 10:42:27.265811',NULL,'2025-12-04 10:42:34.205487','4d669f46-efce-4f52-93db-a93d787af5ce','4d669f46-efce-4f52-93db-a93d787af5ce','tempest-typeshare-type-110839581',1,NULL),('2025-12-04 10:43:17.270206',NULL,'2025-12-04 10:43:25.544130','4e0237cc-4b31-40b5-97b2-740edbe506d4','4e0237cc-4b31-40b5-97b2-740edbe506d4','tempest-share-type-2037646595',1,NULL),('2025-12-04 10:43:17.279284',NULL,'2025-12-04 10:43:17.655615','4ea962a5-2cbf-4150-b741-4cc52a0a7f4f','4ea962a5-2cbf-4150-b741-4cc52a0a7f4f','tempest-support_some_azs_share_type-1464502015',1,NULL),('2025-12-04 10:41:04.527118','2025-12-04 10:41:04.615803','2025-12-04 10:41:08.789884','4ec71132-34e0-4de2-af91-0e2ef5040032','4ec71132-34e0-4de2-af91-0e2ef5040032','tempest-tempest-manila-2100792374',0,'Description for share type'),('2025-12-04 10:41:03.138335','2025-12-04 10:41:03.392072','2025-12-04 10:41:10.177951','4f9bc779-7b02-4d4b-b0c9-664a46fe13fe','4f9bc779-7b02-4d4b-b0c9-664a46fe13fe','tempest-type_updated-1422169971',1,'description_updated'),('2025-12-04 10:43:13.590417',NULL,'2025-12-04 10:43:25.702431','515a821b-2c06-477c-82fe-373c817226c6','515a821b-2c06-477c-82fe-373c817226c6','tempest-share-type-737693970',1,NULL),('2025-12-04 10:43:01.599756',NULL,'2025-12-04 10:43:26.319821','51dc31d5-ae2f-4cc3-99b0-d9bca2c752df','51dc31d5-ae2f-4cc3-99b0-d9bca2c752df','tempest-share-type-1059000925',1,NULL),('2025-12-04 10:41:23.817053',NULL,'2025-12-04 10:41:26.241708','5212c46c-5b78-4012-809b-0988bba38502','5212c46c-5b78-4012-809b-0988bba38502','tempest-typeshare-type-656066023',1,NULL),('2025-12-04 10:42:29.458459',NULL,'2025-12-04 10:42:31.891327','56f5b527-aaed-40ea-9c75-95d7f22e5844','56f5b527-aaed-40ea-9c75-95d7f22e5844','tempest-typeshare-type-1715349719',1,NULL),('2025-12-04 10:42:26.723077',NULL,'2025-12-04 10:42:34.780798','5861fbba-9a6c-4135-b508-b4e2548911be','5861fbba-9a6c-4135-b508-b4e2548911be','tempest-typeshare-type-1954445330',1,NULL),('2025-12-04 10:42:30.566230',NULL,'2025-12-04 10:42:31.034756','5bc47110-6480-415f-8d59-a13ef071a86e','5bc47110-6480-415f-8d59-a13ef071a86e','tempest-typeshare-type-1781453373',1,NULL),('2025-12-04 10:42:22.287523',NULL,'2025-12-04 10:42:33.391396','5d57a614-6f2f-4775-907b-bf29db46ccb8','5d57a614-6f2f-4775-907b-bf29db46ccb8','tempest-typeshare-type-1073743510',1,NULL),('2025-12-04 10:43:03.229637',NULL,'2025-12-04 10:43:06.797801','5fde03b2-931e-43c8-9d6a-a1879fc56bb8','5fde03b2-931e-43c8-9d6a-a1879fc56bb8','tempest-typeshare-type-1417779085',1,NULL),('2025-12-04 10:41:01.338945',NULL,'2025-12-04 10:41:11.450661','604c74e8-2a31-4eaa-873d-14dcdeafe735','604c74e8-2a31-4eaa-873d-14dcdeafe735','tempest-tempest-manila-477709928',1,NULL),('2025-12-04 10:40:59.883207',NULL,'2025-12-04 10:41:12.502077','629e5b04-50f9-405d-9aba-419cc4a3aa80','629e5b04-50f9-405d-9aba-419cc4a3aa80','tempest-tempest-manila-1579169564',1,NULL),('2025-12-04 10:48:24.992054',NULL,'2025-12-04 10:48:26.785205','63fbdeba-d401-478e-befd-74ef3abe36dd','63fbdeba-d401-478e-befd-74ef3abe36dd','tempest-typeshare-type-1417411617',1,NULL),('2025-12-04 10:40:48.681194',NULL,'2025-12-04 10:40:52.384989','6624f59f-aba9-41db-bd96-144dd4a39d12','6624f59f-aba9-41db-bd96-144dd4a39d12','tempest-share-type-1146565360',1,NULL),('2025-12-04 10:40:32.861564',NULL,'2025-12-04 10:40:33.981231','6645b788-0db4-4096-b733-db4481c666a3','6645b788-0db4-4096-b733-db4481c666a3','tempest-unique_st_name-798770980',1,NULL),('2025-12-04 10:42:49.486500',NULL,'2025-12-04 10:43:27.258531','6689d307-ef56-40d7-ad85-62dddaf7d4ba','6689d307-ef56-40d7-ad85-62dddaf7d4ba','tempest-share-type-1325707021',1,NULL),('2025-12-04 10:39:42.290519',NULL,'2025-12-04 10:39:49.486050','66bcee1e-72cf-4a1d-968c-e38f1be18d29','66bcee1e-72cf-4a1d-968c-e38f1be18d29','tempest-typeshare-type-284825503',1,NULL),('2025-12-04 10:43:33.607206',NULL,'2025-12-04 10:43:57.426718','670a24d3-016f-4e59-b59c-2a560b5418dd','670a24d3-016f-4e59-b59c-2a560b5418dd','tempest-typeshare-type-1513494991',1,NULL),('2025-12-04 10:43:08.814110',NULL,'2025-12-04 10:43:25.898207','6836a084-0716-44fd-a4c3-db6585ee754e','6836a084-0716-44fd-a4c3-db6585ee754e','tempest-share-type-364194378',1,NULL),('2025-12-04 10:45:48.106093',NULL,'2025-12-04 10:45:48.247815','68afadff-422b-4898-abfb-c2acbad1eeae','68afadff-422b-4898-abfb-c2acbad1eeae','tempest-support_any_az_share_type-1995215753',1,NULL),('2025-12-04 10:50:49.949621',NULL,'2025-12-04 10:51:41.441887','6a3c87d9-578e-441f-9691-5571c558f82e','6a3c87d9-578e-441f-9691-5571c558f82e','tempest-typeshare-type-783677825',1,NULL),('2025-12-04 10:40:32.600290',NULL,'2025-12-04 10:40:34.335685','6dc56cc3-f611-489a-9625-b6c0aafee6b8','6dc56cc3-f611-489a-9625-b6c0aafee6b8','tempest-typeshare-type-81114091',1,NULL),('2025-12-04 10:41:00.471358',NULL,'2025-12-04 10:41:11.844527','6e884e99-83a2-43e6-8d7f-5854891e8100','6e884e99-83a2-43e6-8d7f-5854891e8100','tempest-tempest-manila-504421737',1,NULL),('2025-12-04 10:43:19.350221',NULL,'2025-12-04 10:43:19.471737','6ed94a15-5358-49a0-b8ca-d05b2e35b074','6ed94a15-5358-49a0-b8ca-d05b2e35b074','tempest-support_any_az_share_type-1785374030',1,NULL),('2025-12-04 10:42:53.728691',NULL,'2025-12-04 10:43:10.114017','6f383b65-791c-4bc0-a865-8a8a9d0fd30c','6f383b65-791c-4bc0-a865-8a8a9d0fd30c','tempest-typeshare-type-1063601353',1,NULL),('2025-12-04 10:43:18.348457',NULL,'2025-12-04 10:43:18.675398','700db3bc-2280-432f-a7da-e27cd9fe00d4','700db3bc-2280-432f-a7da-e27cd9fe00d4','tempest-support_some_azs_share_type-1069422522',1,NULL),('2025-12-04 10:39:12.946237',NULL,'2025-12-04 10:39:29.320138','703ba806-b6aa-4733-8c75-4e18892fffb1','703ba806-b6aa-4733-8c75-4e18892fffb1','tempest-typeshare-type-525558582',1,NULL),('2025-12-04 10:41:06.632122','2025-12-04 10:41:06.729496','2025-12-04 10:41:07.745322','726c179e-92d5-4308-9829-4e6d3685c219','726c179e-92d5-4308-9829-4e6d3685c219','tempest-tempest-manila-1816674121',0,'Description for share type'),('2025-12-04 10:43:05.236537',NULL,'2025-12-04 10:43:26.048586','7793f738-7930-4537-9dfb-f37145dcc966','7793f738-7930-4537-9dfb-f37145dcc966','tempest-share-type-526962127',1,NULL),('2025-12-04 10:45:07.918719',NULL,'2025-12-04 10:45:38.706804','79086422-8620-41bb-ad72-d3d2e0f09707','79086422-8620-41bb-ad72-d3d2e0f09707','tempest-typeshare-type-1144788267',1,NULL),('2025-12-04 10:42:35.474953',NULL,'2025-12-04 10:42:39.374819','7ba659d1-3dac-4fec-8f0a-7a23ca697aaf','7ba659d1-3dac-4fec-8f0a-7a23ca697aaf','tempest-typeshare-type-1457606313',1,NULL),('2025-12-04 10:39:47.583393',NULL,'2025-12-04 10:39:48.300505','7d3d7c56-4d17-40d8-a262-f09a7a4b10f2','7d3d7c56-4d17-40d8-a262-f09a7a4b10f2','tempest-typeshare-type-391886575',1,NULL),('2025-12-04 10:47:17.354724',NULL,'2025-12-04 10:47:47.313482','7e2e54b3-9fc4-42f1-9682-dfd37ababbc9','7e2e54b3-9fc4-42f1-9682-dfd37ababbc9','tempest-typeshare-type-1858074118',1,NULL),('2025-12-04 10:40:21.550670',NULL,'2025-12-04 10:40:27.068554','7f3df988-8170-4466-8fee-f4434cfe05a1','7f3df988-8170-4466-8fee-f4434cfe05a1','tempest-typeshare-type-543788837',1,NULL),('2025-12-04 10:41:06.989747','2025-12-04 10:41:07.173555','2025-12-04 10:41:07.264505','814e893d-a20d-4500-a202-ee6d7977e040','814e893d-a20d-4500-a202-ee6d7977e040','tempest-tempest-manila-1550189784',1,NULL),('2025-12-04 10:43:15.138203',NULL,'2025-12-04 10:43:54.335842','820e79dd-be75-4d91-aca0-04a50b785894','820e79dd-be75-4d91-aca0-04a50b785894','tempest-typeshare-type-1108556053',1,NULL),('2025-12-04 10:49:15.730777',NULL,'2025-12-04 10:50:38.646682','83cb9767-1df4-4921-a073-4398082b463f','83cb9767-1df4-4921-a073-4398082b463f','tempest-typeshare-type-310737172',1,NULL),('2025-12-04 10:48:53.897577',NULL,'2025-12-04 10:50:39.717655','8446d21c-69f2-4851-933b-997effa49241','8446d21c-69f2-4851-933b-997effa49241','tempest-typeshare-type-1633264222',1,NULL),('2025-12-04 10:43:15.523324',NULL,'2025-12-04 10:43:15.747693','85426e32-7637-4a1f-88c0-7649ad3c01b1','85426e32-7637-4a1f-88c0-7649ad3c01b1','tempest-az_share_type-777906204',1,NULL),('2025-12-04 10:42:29.034148',NULL,'2025-12-04 10:42:32.363375','859e93a7-fb3c-44a1-bc2b-3a3deb617de8','859e93a7-fb3c-44a1-bc2b-3a3deb617de8','tempest-typeshare-type-1318622089',1,NULL),('2025-12-04 10:41:02.309837',NULL,'2025-12-04 10:41:10.468358','89e6ea60-b516-4fac-b0fc-a0b2e3c8f16e','89e6ea60-b516-4fac-b0fc-a0b2e3c8f16e','tempest-tempest-manila-164468967',1,NULL),('2025-12-04 10:41:16.039712',NULL,'2025-12-04 10:41:17.825520','8a45cfa7-fe06-4c16-ba8d-6057ad9efe75','8a45cfa7-fe06-4c16-ba8d-6057ad9efe75','tempest-typeshare-type-1704531282',1,NULL),('2025-12-04 10:40:59.565500',NULL,'2025-12-04 10:41:13.004738','8cef8b7f-82d2-405e-8eb5-69781affc226','8cef8b7f-82d2-405e-8eb5-69781affc226','tempest-tempest-manila-999645568',1,NULL),('2025-12-04 10:43:52.517585',NULL,'2025-12-04 10:44:47.422259','8e1ebbba-1c74-478b-9238-956133ca0d56','8e1ebbba-1c74-478b-9238-956133ca0d56','tempest-typeshare-type-242608976',1,NULL),('2025-12-04 10:41:17.282383',NULL,'2025-12-04 10:41:17.614807','8ff030ae-e094-4f81-beff-67c8fd1d2e6e','8ff030ae-e094-4f81-beff-67c8fd1d2e6e','tempest-tempest-manila-1047438130',0,NULL),('2025-12-04 10:41:16.549516',NULL,'2025-12-04 10:41:16.897674','9147b0cd-51db-4bff-83a5-4e4b21f3582b','9147b0cd-51db-4bff-83a5-4e4b21f3582b','tempest-tempest-manila-1521851497',1,NULL),('2025-12-04 10:43:16.296283',NULL,'2025-12-04 10:43:16.445374','922b7553-fadd-44fa-9410-24acaa658017','922b7553-fadd-44fa-9410-24acaa658017','tempest-az_share_type-532775463',1,NULL),('2025-12-04 10:40:51.010885',NULL,'2025-12-04 10:40:51.792006','92b70af9-1a82-4277-a900-ceb78a5767d8','92b70af9-1a82-4277-a900-ceb78a5767d8','tempest-share-type-1473703132',1,NULL),('2025-12-04 10:41:08.072680',NULL,'2025-12-04 10:41:12.783888','9327d215-d4cc-4d4f-9783-f891100659fa','9327d215-d4cc-4d4f-9783-f891100659fa','tempest-share-type-306276434',1,NULL),('2025-12-04 10:42:27.697075',NULL,'2025-12-04 10:42:33.636833','93eca8ef-ad00-42c4-82aa-b200c99ba6dd','93eca8ef-ad00-42c4-82aa-b200c99ba6dd','tempest-typeshare-type-1238358300',1,NULL),('2025-12-04 10:41:02.848626',NULL,'2025-12-04 10:41:10.326632','963dd198-ab7f-470b-ba96-705b8101f366','963dd198-ab7f-470b-ba96-705b8101f366','tempest-tempest-manila-665767151',1,NULL),('2025-12-04 10:41:01.517726',NULL,'2025-12-04 10:41:11.323524','99340576-96be-443a-8ee2-c7fac7f652c9','99340576-96be-443a-8ee2-c7fac7f652c9','tempest-tempest-manila-674520059',1,NULL),('2025-12-04 10:48:40.423478',NULL,'2025-12-04 10:48:42.455755','9959377b-cfad-492b-b92a-ef90c3b297f7','9959377b-cfad-492b-b92a-ef90c3b297f7','tempest-typeshare-type-1852151205',1,NULL),('2025-12-04 10:41:03.927534','2025-12-04 10:41:04.010524','2025-12-04 10:41:09.444186','9b923cdf-5465-49d5-9f0c-b5e97c49f277','9b923cdf-5465-49d5-9f0c-b5e97c49f277','tempest-tempest-manila-2035575758',1,'description_updated'),('2025-12-04 10:39:53.030783',NULL,'2025-12-04 10:40:28.396298','9c68edba-9905-4826-9020-f24a33ca4068','9c68edba-9905-4826-9020-f24a33ca4068','tempest-typeshare-type-1634233559',1,NULL),('2025-12-04 10:40:11.559356',NULL,'2025-12-04 10:40:27.693398','9d03fc71-382b-4b0f-aac5-c7ab656d1abd','9d03fc71-382b-4b0f-aac5-c7ab656d1abd','tempest-typeshare-type-1455277305',0,NULL),('2025-12-04 10:40:19.707593',NULL,'2025-12-04 10:40:42.599106','9d536774-c83d-47c8-953e-f319caf6de44','9d536774-c83d-47c8-953e-f319caf6de44','tempest-typeshare-type-170133899',1,NULL),('2025-12-04 10:41:06.822646','2025-12-04 10:41:06.916042','2025-12-04 10:41:07.540884','9d8197a3-3fdd-4768-98ff-cd5bcbada9d0','9d8197a3-3fdd-4768-98ff-cd5bcbada9d0','tempest-tempest-manila-838553145',1,NULL),('2025-12-04 10:47:53.470591',NULL,'2025-12-04 10:48:08.675085','9f12719f-820d-45f8-8b37-c67efc69baf2','9f12719f-820d-45f8-8b37-c67efc69baf2','tempest-typeshare-type-1662006437',1,NULL),('2025-12-04 10:43:21.563456',NULL,'2025-12-04 10:43:25.377436','a1ec9089-0fd2-48fb-bf6a-18efd8277aeb','a1ec9089-0fd2-48fb-bf6a-18efd8277aeb','tempest-share-type-1012068311',1,NULL),('2025-12-04 10:36:03.177239',NULL,NULL,'False','a2f71277-9b7c-41be-ac23-94904d0c6314','default',1,NULL),('2025-12-04 10:41:01.753108',NULL,'2025-12-04 10:41:10.954744','a464f9ed-c439-4119-8bf5-2bde4324f5bc','a464f9ed-c439-4119-8bf5-2bde4324f5bc','tempest-tempest-manila-931327186',1,'Description for share type'),('2025-12-04 10:41:25.265684',NULL,'2025-12-04 10:41:25.823151','a4fb5023-31fe-4ccd-ad0a-bd4eb9b54575','a4fb5023-31fe-4ccd-ad0a-bd4eb9b54575','tempest-typeshare-type-1049986397',1,NULL),('2025-12-04 10:41:03.603240','2025-12-04 10:41:03.772683','2025-12-04 10:41:09.778091','a50e875e-198a-44a1-a4a4-de589e219f6a','a50e875e-198a-44a1-a4a4-de589e219f6a','tempest-type_updated-757366779',1,'Description for share type'),('2025-12-04 10:42:29.638786',NULL,'2025-12-04 10:42:31.738722','a6d5228e-c3e5-4d7a-b449-cf7714db4020','a6d5228e-c3e5-4d7a-b449-cf7714db4020','tempest-typeshare-type-69715584',1,NULL),('2025-12-04 10:39:38.332948',NULL,'2025-12-04 10:39:49.687586','a7212d2b-38e1-4ae3-a61c-8cc62c962d96','a7212d2b-38e1-4ae3-a61c-8cc62c962d96','tempest-typeshare-type-1414798932',1,NULL),('2025-12-04 10:41:25.080777',NULL,'2025-12-04 10:41:25.975591','a7d904f9-1270-48f1-a4d5-cc1bebdf9d35','a7d904f9-1270-48f1-a4d5-cc1bebdf9d35','tempest-typeshare-type-1949596002',1,NULL),('2025-12-04 10:45:56.231693',NULL,'2025-12-04 10:47:08.470817','ac7bd782-cd71-4f35-9fed-0f011ba5e09d','ac7bd782-cd71-4f35-9fed-0f011ba5e09d','tempest-typeshare-type-2118905014',1,NULL),('2025-12-04 10:42:30.196179',NULL,'2025-12-04 10:42:31.274248','ad721822-46df-4659-8f26-0211e20d869a','ad721822-46df-4659-8f26-0211e20d869a','tempest-typeshare-type-971182670',1,NULL),('2025-12-04 10:42:28.812009',NULL,'2025-12-04 10:42:32.605660','ad8cd2b4-b922-4a63-a2cc-a1806d8de5c3','ad8cd2b4-b922-4a63-a2cc-a1806d8de5c3','tempest-typeshare-type-1677200251',1,NULL),('2025-12-04 10:44:27.426737',NULL,NULL,'False','b022472d-700d-41d8-9151-d06e86a7dc3f','tempest-typeshare-type-1418487235',1,NULL),('2025-12-04 10:42:49.270368',NULL,'2025-12-04 10:42:55.189637','b2157044-5f23-4022-bef2-d9afb5418e95','b2157044-5f23-4022-bef2-d9afb5418e95','tempest-typeshare-type-2080003440',1,NULL),('2025-12-04 10:43:17.802578',NULL,'2025-12-04 10:43:18.215515','b5792ae9-819b-4f80-81c1-34f733a0b652','b5792ae9-819b-4f80-81c1-34f733a0b652','tempest-support_some_azs_share_type-1240736183',1,NULL),('2025-12-04 10:42:26.934298',NULL,'2025-12-04 10:42:34.618209','ba7af4c1-42ef-4853-82d1-041b6a4ab72b','ba7af4c1-42ef-4853-82d1-041b6a4ab72b','tempest-typeshare-type-994600743',1,NULL),('2025-12-04 10:43:42.034999',NULL,'2025-12-04 10:43:44.021204','ba8ee9d1-82b5-4b99-b07c-ef1511a29010','ba8ee9d1-82b5-4b99-b07c-ef1511a29010','tempest-typeshare-type-1552851030',1,NULL),('2025-12-04 10:42:53.506712',NULL,'2025-12-04 10:43:26.903936','bae4e5c8-4bd0-4aef-8463-ce3e493d8f98','bae4e5c8-4bd0-4aef-8463-ce3e493d8f98','tempest-share-type-1046073688',1,NULL),('2025-12-04 10:42:27.998017',NULL,'2025-12-04 10:42:33.028452','bf0e9abc-e532-4c5c-b085-60c1a9fc9587','bf0e9abc-e532-4c5c-b085-60c1a9fc9587','tempest-typeshare-type-935921496',1,NULL),('2025-12-04 10:43:18.800476',NULL,'2025-12-04 10:43:19.192217','bf9bee7c-a7a7-4c96-bb5f-818014a7559f','bf9bee7c-a7a7-4c96-bb5f-818014a7559f','tempest-support_some_azs_share_type-2045590902',1,NULL),('2025-12-04 10:47:55.283522',NULL,'2025-12-04 10:48:10.330457','c0d93c20-f27c-4fec-9d23-328c1d8e67c8','c0d93c20-f27c-4fec-9d23-328c1d8e67c8','tempest-typeshare-type-262238793',1,NULL),('2025-12-04 10:41:00.321053',NULL,'2025-12-04 10:41:11.994520','c12dd575-4969-4307-8133-ff0ee608139d','c12dd575-4969-4307-8133-ff0ee608139d','tempest-tempest-manila-930333021',1,'Description for share type'),('2025-12-04 10:40:21.947118',NULL,'2025-12-04 10:40:26.883546','c4aacbb6-42ff-46f7-aea9-dfa997f3eabe','c4aacbb6-42ff-46f7-aea9-dfa997f3eabe','tempest-typeshare-type-854030469',1,NULL),('2025-12-04 10:41:04.123632','2025-12-04 10:41:04.284043','2025-12-04 10:41:09.211100','c80bc07d-9348-4e0a-bc0e-7feeb9b53879','c80bc07d-9348-4e0a-bc0e-7feeb9b53879','tempest-tempest-manila-999602684',1,'Description for share type'),('2025-12-04 10:39:36.327783',NULL,'2025-12-04 10:39:50.479412','c8a5778a-de01-4b0f-9a2b-31d30765f08f','c8a5778a-de01-4b0f-9a2b-31d30765f08f','tempest-typeshare-type-1211539425',1,NULL),('2025-12-04 10:39:28.064737',NULL,'2025-12-04 10:39:37.276327','c8b2d54e-9dae-4635-aff6-dcbbe64d4236','c8b2d54e-9dae-4635-aff6-dcbbe64d4236','tempest-typeshare-type-2064842689',1,NULL),('2025-12-04 10:42:57.367092',NULL,'2025-12-04 10:43:26.482463','ce0f25d3-27ba-44eb-9b51-7c8fa400875f','ce0f25d3-27ba-44eb-9b51-7c8fa400875f','tempest-share-type-1820413862',1,NULL),('2025-12-04 10:40:50.688239',NULL,'2025-12-04 10:41:13.529613','d06feb78-408f-46b2-96af-3dfde13231d8','d06feb78-408f-46b2-96af-3dfde13231d8','tempest-share-type-602574401',1,NULL),('2025-12-04 10:42:19.820223',NULL,'2025-12-04 10:42:20.257378','d147fb7e-ecc4-41e3-977e-fac235d2617b','d147fb7e-ecc4-41e3-977e-fac235d2617b','tempest-share-type-250324901',1,NULL),('2025-12-04 10:42:45.028844',NULL,'2025-12-04 10:43:27.503072','d20023e3-0d3f-4f8d-bc4b-35c7fd908150','d20023e3-0d3f-4f8d-bc4b-35c7fd908150','tempest-share-type-1123295540',1,NULL),('2025-12-04 10:44:05.409898',NULL,'2025-12-04 10:44:13.546596','d2cb06dc-eba6-4fed-a094-61bf857c0e07','d2cb06dc-eba6-4fed-a094-61bf857c0e07','tempest-typeshare-type-1648810089',1,NULL),('2025-12-04 10:39:36.035892',NULL,'2025-12-04 10:39:50.965205','d749ec11-bb5e-4217-b378-1e32ba8ce5ea','d749ec11-bb5e-4217-b378-1e32ba8ce5ea','tempest-typeshare-type-356842484',1,NULL),('2025-12-04 10:40:58.157854',NULL,'2025-12-04 10:41:13.185292','de331f1b-754e-428f-a640-62eecf125b83','de331f1b-754e-428f-a640-62eecf125b83','tempest-tempest-manila-1247254107',0,NULL),('2025-12-04 10:42:27.475314',NULL,'2025-12-04 10:42:33.992325','df2e8055-9b6a-47fd-b0b6-969c6c5cdfbe','df2e8055-9b6a-47fd-b0b6-969c6c5cdfbe','tempest-typeshare-type-61212187',1,NULL),('2025-12-04 10:42:16.379516',NULL,'2025-12-04 10:43:26.420154','df88ce48-d3e8-48b4-aca4-3e96df85fd1c','df88ce48-d3e8-48b4-aca4-3e96df85fd1c','tempest-typeshare-type-2044367007',1,NULL),('2025-12-04 10:42:27.831457',NULL,'2025-12-04 10:42:33.444901','dfc64eec-c048-4030-b769-ae1f29ae5372','dfc64eec-c048-4030-b769-ae1f29ae5372','tempest-typeshare-type-1445354058',1,NULL),('2025-12-04 10:39:10.759066',NULL,'2025-12-04 10:40:42.798387','e25793d0-774e-4cdf-93f8-ead2edf48a79','e25793d0-774e-4cdf-93f8-ead2edf48a79','tempest-typeshare-type-73123990',1,NULL),('2025-12-04 10:40:50.526052',NULL,'2025-12-04 10:40:52.063907','e2eecd7f-8320-49bc-b526-b0735284c786','e2eecd7f-8320-49bc-b526-b0735284c786','tempest-share-type-1313753210',1,NULL),('2025-12-04 10:39:37.538048',NULL,'2025-12-04 10:39:50.289529','e48f8a81-6ec9-4d8d-9855-5ca62580db14','e48f8a81-6ec9-4d8d-9855-5ca62580db14','tempest-typeshare-type-19005752',1,NULL),('2025-12-04 10:43:16.665710',NULL,'2025-12-04 10:43:17.110622','e507717b-725c-422d-8dad-5d83efc6498f','e507717b-725c-422d-8dad-5d83efc6498f','tempest-support_some_azs_share_type-771408130',1,NULL),('2025-12-04 10:43:42.095806',NULL,'2025-12-04 10:43:43.768614','e5b9a05a-3938-4069-9c62-1d6a8427d47a','e5b9a05a-3938-4069-9c62-1d6a8427d47a','tempest-typeshare-type-1146239970',1,NULL),('2025-12-04 10:42:28.315280',NULL,'2025-12-04 10:42:32.759880','e649aa84-3900-4711-83ab-7b931bba4470','e649aa84-3900-4711-83ab-7b931bba4470','tempest-typeshare-type-611736584',1,NULL),('2025-12-04 10:43:16.730739',NULL,'2025-12-04 10:43:16.878707','e8096e49-2096-4348-b476-0dbce41dc075','e8096e49-2096-4348-b476-0dbce41dc075','tempest-support_any_az_share_type-541735751',1,NULL),('2025-12-04 10:41:52.599960',NULL,'2025-12-04 10:42:11.770737','e97a3463-125a-45ea-9b75-73d586ae1dd9','e97a3463-125a-45ea-9b75-73d586ae1dd9','tempest-typeshare-type-1255721918',1,NULL),('2025-12-04 10:40:59.720773',NULL,'2025-12-04 10:41:12.720540','ea9ecce9-2731-4365-bfc5-72d48eb23393','ea9ecce9-2731-4365-bfc5-72d48eb23393','tempest-tempest-manila-1626877533',1,NULL),('2025-12-04 10:42:26.151133',NULL,'2025-12-04 10:42:35.185084','eb3a1c52-4113-42a1-8a22-2ba687b99d81','eb3a1c52-4113-42a1-8a22-2ba687b99d81','tempest-typeshare-type-1875499272',1,NULL),('2025-12-04 10:40:53.930686',NULL,'2025-12-04 10:41:16.842312','ec0655e6-90b3-4d12-b523-1f54eacdc7a3','ec0655e6-90b3-4d12-b523-1f54eacdc7a3','tempest-share-type-604107131',1,NULL),('2025-12-04 10:40:49.876392',NULL,'2025-12-04 10:40:52.230441','ec6f4bbc-3430-47ed-b7c9-dd031528924a','ec6f4bbc-3430-47ed-b7c9-dd031528924a','tempest-share-type-1554092239',1,NULL),('2025-12-04 10:40:58.897308',NULL,'2025-12-04 10:40:59.262122','f23e1693-acba-4c2d-a938-c295eb662380','f23e1693-acba-4c2d-a938-c295eb662380','tempest-tempest-manila-2139066200',1,NULL),('2025-12-04 10:40:38.608603',NULL,'2025-12-04 10:40:49.246014','f246ccbd-b6cd-4308-8680-879f81fe8e7d','f246ccbd-b6cd-4308-8680-879f81fe8e7d','tempest-typeshare-type-8520486',1,NULL),('2025-12-04 10:43:17.356426',NULL,'2025-12-04 10:43:17.504790','f3abcc8e-2e4b-48f2-a41f-3b439e54d0f1','f3abcc8e-2e4b-48f2-a41f-3b439e54d0f1','tempest-support_any_az_share_type-23734679',1,NULL),('2025-12-04 10:40:19.483429',NULL,'2025-12-04 10:40:27.385259','f70b7b0a-e2e8-4f47-b25e-f69f046f57c1','f70b7b0a-e2e8-4f47-b25e-f69f046f57c1','tempest-typeshare-type-1715566090',1,NULL),('2025-12-04 10:42:25.913201',NULL,'2025-12-04 10:42:35.452878','f72daf9e-1243-47f4-b617-0e7bb264206a','f72daf9e-1243-47f4-b617-0e7bb264206a','tempest-typeshare-type-1760496711',1,NULL),('2025-12-04 10:43:19.299107',NULL,'2025-12-04 10:43:19.588839','f8e08b5f-33ae-488c-b94b-b1dc3b67436e','f8e08b5f-33ae-488c-b94b-b1dc3b67436e','tempest-support_some_azs_share_type-840755348',1,NULL),('2025-12-04 10:39:23.473017',NULL,'2025-12-04 10:40:02.245607','f9c9ca5f-6992-4730-8113-73ad975de651','f9c9ca5f-6992-4730-8113-73ad975de651','tempest-typeshare-type-833006453',1,NULL),('2025-12-04 10:39:27.846674',NULL,'2025-12-04 10:39:58.298179','fad6562a-6c8b-4475-a01e-8a7d1d4a728b','fad6562a-6c8b-4475-a01e-8a7d1d4a728b','tempest-typeshare-type-63328024',1,NULL),('2025-12-04 10:40:06.366171',NULL,'2025-12-04 10:40:14.127646','fbcd210b-f4b4-4f9a-b567-b1dd820eb42f','fbcd210b-f4b4-4f9a-b567-b1dd820eb42f','tempest-typeshare-type-1638040198',1,NULL),('2025-12-04 10:39:53.200373',NULL,'2025-12-04 10:40:28.117380','fbfa7e24-ec90-46ae-a6e9-92f64f43ac9c','fbfa7e24-ec90-46ae-a6e9-92f64f43ac9c','tempest-typeshare-type-678316427',1,NULL),('2025-12-04 10:39:37.982816',NULL,'2025-12-04 10:39:50.075420','fcfa41e6-1dcb-4274-a61c-8f27b3dd6c5a','fcfa41e6-1dcb-4274-a61c-8f27b3dd6c5a','tempest-typeshare-type-1648398038',1,NULL),('2025-12-04 10:40:33.137439',NULL,'2025-12-04 10:40:33.559154','fd6797ea-a2bf-4f6d-b109-e59a52719cdf','fd6797ea-a2bf-4f6d-b109-e59a52719cdf','tempest-unique_st_name-813703868',1,NULL),('2025-12-04 10:40:33.272824',NULL,'2025-12-04 10:40:33.417538','fe481553-d35b-4315-87cd-2cadea2c74b9','fe481553-d35b-4315-87cd-2cadea2c74b9','tempest-unique_st_name-64834120',1,NULL);
/*!40000 ALTER TABLE `share_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shares`
--

DROP TABLE IF EXISTS `shares`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shares` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `share_proto` varchar(255) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `snapshot_support` tinyint(1) DEFAULT NULL,
  `share_group_id` varchar(36) DEFAULT NULL,
  `source_share_group_snapshot_member_id` varchar(36) DEFAULT NULL,
  `task_state` varchar(255) DEFAULT NULL,
  `replication_type` varchar(255) DEFAULT NULL,
  `create_share_from_snapshot_support` tinyint(1) DEFAULT NULL,
  `revert_to_snapshot_support` tinyint(1) DEFAULT NULL,
  `mount_snapshot_support` tinyint(1) DEFAULT NULL,
  `is_soft_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `scheduled_to_be_deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_shares_share_group_id` (`share_group_id`),
  CONSTRAINT `fk_shares_share_group_id` FOREIGN KEY (`share_group_id`) REFERENCES `share_groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shares`
--

LOCK TABLES `shares` WRITE;
/*!40000 ALTER TABLE `shares` DISABLE KEYS */;
INSERT INTO `shares` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `size`, `display_name`, `display_description`, `snapshot_id`, `share_proto`, `is_public`, `snapshot_support`, `share_group_id`, `source_share_group_snapshot_member_id`, `task_state`, `replication_type`, `create_share_from_snapshot_support`, `revert_to_snapshot_support`, `mount_snapshot_support`, `is_soft_deleted`, `scheduled_to_be_deleted_at`) VALUES ('2025-12-04 10:45:15.950815','2025-12-04 10:45:28.863367','2025-12-04 10:45:28.862792','01fe9fef-080a-43fe-bf96-dd9da9f35c9c','01fe9fef-080a-43fe-bf96-dd9da9f35c9c','16082b385ae54073bd230a6276db6494','fc1dc55455c4455c8c74c6488671677d',1,'tempest-tempest-share-name-1498153446','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:41:52.838380','2025-12-04 10:42:00.964279','2025-12-04 10:42:00.963929','0a2752ac-2225-4560-a011-76c6043ebc6c','0a2752ac-2225-4560-a011-76c6043ebc6c','de759a3ec81642cd83d621173ab2bdb2','f409515d619a495bb7f5f1af15f8324a',1,'public_share - must be visible to all projects in the cloud','public_share_desc',NULL,'CEPHFS',1,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:48:54.438396','2025-12-04 10:49:05.489634','2025-12-04 10:49:05.489178','0ba0d9dd-53af-4b75-9763-be9978723501','0ba0d9dd-53af-4b75-9763-be9978723501','a7cbfaccac8f48c1bc69fb83640618a5','2c40fb2875304a41b2368725937fd373',1,'tempest-tempest-created-share-594640146','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:46:39.989223','2025-12-04 10:46:47.091144','2025-12-04 10:46:47.090591','0c16fde6-e8f2-4f39-bddb-65803e1ce106','0c16fde6-e8f2-4f39-bddb-65803e1ce106','c8bddd1494604235b944287494725839','bdee1673bf874393ab80f7311782fc10',1,'tempest-tempest-created-share-1139509559','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-12-04 10:43:01.879650','2025-12-04 10:43:06.214336','2025-12-04 10:43:06.213900','0d26c116-5607-4a7f-87c1-6007280ba3d5','0d26c116-5607-4a7f-87c1-6007280ba3d5','a70fe8cd329045aea5fadbb81acb5c56','991152b6ddef4a77a0c0088882c63fa1',1,'tempest-tempest-share-name-1446978110','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:43:46.279873','2025-12-04 10:43:50.308405','2025-12-04 10:43:50.308062','12e6a6f6-79d8-47cd-b245-44f853987171','12e6a6f6-79d8-47cd-b245-44f853987171','4c579d8ef46542619c86f7d6ba0c6283','b0e23771bd1a4c3ea8b52092c2e5d69e',1,'tempest-tempest-created-share-1264100403','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:40:38.796729','2025-12-04 10:40:45.882453','2025-12-04 10:40:45.882130','13c32d00-efd3-469a-8dbb-16c65179e669','13c32d00-efd3-469a-8dbb-16c65179e669','432be7864c2d41508547058364b0ef80','2b21e3f6c24d4eb39e6fedb5f78ec003',1,'tempest-tempest-created-share-1602154153','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:47:31.814052','2025-12-04 10:47:43.888829','2025-12-04 10:47:43.888381','170d65c2-589a-4713-bfa8-09af2cc4d8ad','170d65c2-589a-4713-bfa8-09af2cc4d8ad','c99b07cc76794bbe865e84c99d719aec','b08d95dfcf5049b89d93e68ea13452d2',1,'tempest-tempest-created-share-1939407134','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-12-04 10:41:24.950194','2025-12-04 10:41:30.695518','2025-12-04 10:41:30.695139','1829b41d-c21f-4aae-ad0b-d90348cd0d0a','1829b41d-c21f-4aae-ad0b-d90348cd0d0a','956c2a2425364bc58a945afb8a16635a','91320ee163cc40bc8f5c820635954e8f',1,'tempest-tempest-created-share-968908993','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:49:15.900418','2025-12-04 10:50:35.607171','2025-12-04 10:50:35.606695','1914213e-cb38-47c5-bb81-b30cfa67ccaa','1914213e-cb38-47c5-bb81-b30cfa67ccaa','a7cbfaccac8f48c1bc69fb83640618a5','2c40fb2875304a41b2368725937fd373',1,'tempest-tempest-created-share-219386286','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-12-04 10:43:39.138679','2025-12-04 10:43:42.976465','2025-12-04 10:43:42.975870','1c19ef78-a3f6-4cc2-849d-7c6974571b73','1c19ef78-a3f6-4cc2-849d-7c6974571b73','4c579d8ef46542619c86f7d6ba0c6283','b0e23771bd1a4c3ea8b52092c2e5d69e',1,'tempest-tempest-created-share-1759696903','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:39:12.246148','2025-12-04 10:40:39.693389','2025-12-04 10:40:39.692974','1dd0febb-2713-4235-8387-b1c1deadd402','1dd0febb-2713-4235-8387-b1c1deadd402','d2380cdaae7840a7aa1016a0c2242ad2','30e995746f0346cc925a4e4d291b4b4b',1,'tempest-tempest-created-share-722345584','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:40:06.520941','2025-12-04 10:40:10.994731','2025-12-04 10:40:10.994249','1f778e10-afb1-46f6-a83f-f19861ae9078','1f778e10-afb1-46f6-a83f-f19861ae9078','b0b74817f28a40638632c34de45c4b3a','ee36120fd1ef45478778db2f213d6c09',1,'tempest-tempest-created-share-812522319','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:50:58.013979','2025-12-04 10:51:02.103492','2025-12-04 10:51:02.103118','25c86dd0-9947-4fab-aeec-44acb1fe4a67','25c86dd0-9947-4fab-aeec-44acb1fe4a67','e318249fe70a4240a4a0e7ebc5c47a65','c3ea6486309b4dab9bf9d14f604bdce4',1,'tempest-tempest-created-share-1234290699','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:46:25.158439','2025-12-04 10:46:32.497376','2025-12-04 10:46:32.496953','25fe926c-9268-41b8-88c9-b70413a29311','25fe926c-9268-41b8-88c9-b70413a29311','c8bddd1494604235b944287494725839','bdee1673bf874393ab80f7311782fc10',2,'tempest-tempest-created-share-815598236','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-12-04 10:39:33.960838','2025-12-04 10:39:38.299099','2025-12-04 10:39:38.298648','268eff16-31f2-495a-b5c6-eaa5c8496407','268eff16-31f2-495a-b5c6-eaa5c8496407','d2380cdaae7840a7aa1016a0c2242ad2','30e995746f0346cc925a4e4d291b4b4b',1,'tempest-tempest-created-share-1988671960','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:45:11.927554','2025-12-04 10:45:32.193956','2025-12-04 10:45:32.193576','294ace96-b929-46cc-ba31-c3325815b6a3','294ace96-b929-46cc-ba31-c3325815b6a3','16082b385ae54073bd230a6276db6494','fc1dc55455c4455c8c74c6488671677d',1,'tempest-tempest-share-name-1926823459','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:42:42.191575','2025-12-04 10:42:50.115493','2025-12-04 10:42:50.115115','2ad065b7-ef88-4d1b-bf36-9dcd4fcd6071','2ad065b7-ef88-4d1b-bf36-9dcd4fcd6071','8b4c6480f293453d850328438bc66819','094a9e5adfae45769d099eaf0d4f598c',1,'tempest-tempest-created-share-1308322908','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:39:41.501091','2025-12-04 10:39:46.969135','2025-12-04 10:39:46.968680','2d13d7ce-5d9f-4b3a-afd3-e38005061d43','2d13d7ce-5d9f-4b3a-afd3-e38005061d43','d2380cdaae7840a7aa1016a0c2242ad2','30e995746f0346cc925a4e4d291b4b4b',1,'tempest-tempest-created-share-1312486743','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:43:39.969598','2025-12-04 10:44:36.351302','2025-12-04 10:44:36.350828','2d436547-41b8-4122-9322-d7f521efcae8','2d436547-41b8-4122-9322-d7f521efcae8','48ef94f1dc4447f08252015effc744b0','d831ca1755a740e7819c02d320ecd2a0',1,'tempest-tempest-created-share-203981140','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-12-04 10:43:19.844954','2025-12-04 10:43:30.669057','2025-12-04 10:43:30.668626','2f1a8220-3e00-4f0a-9dac-fb3bda10481f','2f1a8220-3e00-4f0a-9dac-fb3bda10481f','4c579d8ef46542619c86f7d6ba0c6283','b0e23771bd1a4c3ea8b52092c2e5d69e',1,'tempest-tempest-created-share-2049473546','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:51:05.500523','2025-12-04 10:51:09.777694','2025-12-04 10:51:09.777363','33128045-ffb6-4396-a95d-a1eebcb0fa90','33128045-ffb6-4396-a95d-a1eebcb0fa90','e318249fe70a4240a4a0e7ebc5c47a65','c3ea6486309b4dab9bf9d14f604bdce4',2,'tempest-tempest-created-share-1210049666','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:43:44.118399','2025-12-04 10:44:32.681057','2025-12-04 10:44:32.680490','361a365f-e3ed-48f5-b726-d1c98f3a4186','361a365f-e3ed-48f5-b726-d1c98f3a4186','ac347d74fad64b0bbb495d6240c31d44','c2e0964e5703431eab30fd7c235961ae',1,'tempest-tempest-created-share-224179889','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-12-04 10:41:08.399456','2025-12-04 10:41:11.997783','2025-12-04 10:41:11.997444','3d37a571-abf6-466d-bed4-9732cbd34327','3d37a571-abf6-466d-bed4-9732cbd34327','b5d23f7e91694629931517a6c40efbe5','54f365c11f8e40988b5a964504f91dd7',1,'tempest-tempest-created-share-934532404','tempest-tempest-created-share-desc-1103473475',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:43:01.772996','2025-12-04 10:43:13.353429','2025-12-04 10:43:13.352990','406666a0-eb51-4632-8678-5b370b2d0962','406666a0-eb51-4632-8678-5b370b2d0962','d3c52ac6184348f5b9994127e3eeb5e5','e2d34491d1094a9480aa03d0d203a852',1,'tempest-tempest-created-share-2067649703','tempest-tempest-created-share-desc-1632219388',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:41:30.894145','2025-12-04 10:41:36.172787','2025-12-04 10:41:36.172413','44395325-f4a7-46bd-9284-344f55b95b3e','44395325-f4a7-46bd-9284-344f55b95b3e','7da578f357d044d590ceb21b50653ba9','209828455d3a419389bb0a731fac0513',1,'tempest-tempest-created-share-619729992','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:42:31.544456','2025-12-04 10:42:39.459364','2025-12-04 10:42:39.458968','46a22168-c576-4b32-8268-3052b32d9157','46a22168-c576-4b32-8268-3052b32d9157','8b4c6480f293453d850328438bc66819','094a9e5adfae45769d099eaf0d4f598c',1,'tempest-tempest-created-share-384133460','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:41:04.008218','2025-12-04 10:41:07.911089','2025-12-04 10:41:07.910246','4a9b5b7f-52fb-4050-b6e1-34454246ed23','4a9b5b7f-52fb-4050-b6e1-34454246ed23','b5d23f7e91694629931517a6c40efbe5','54f365c11f8e40988b5a964504f91dd7',1,'tempest-tempest-created-share-1260332080','tempest-tempest-created-share-desc-526563290',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:44:27.585453','2025-12-04 10:47:41.080843','2025-12-04 10:47:41.080391','4b1855ba-c5e9-4793-a786-40a54e7585ef','4b1855ba-c5e9-4793-a786-40a54e7585ef','08d39615a7a349ae95f9c66ad6c00312','7df6681d57a74b90abc5310588588b91',1,'tempest-tempest-created-share-865015371','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:40:51.027243','2025-12-04 10:40:54.948106','2025-12-04 10:40:54.947376','4dd303d7-6f90-41b6-af60-24e0e2cf4d18','4dd303d7-6f90-41b6-af60-24e0e2cf4d18','b5d23f7e91694629931517a6c40efbe5','54f365c11f8e40988b5a964504f91dd7',1,'tempest-tempest-created-share-1656183068','tempest-tempest-created-share-desc-624519861',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:51:26.820625','2025-12-04 10:51:30.761879','2025-12-04 10:51:30.761481','4e1b7902-892b-4297-a889-3e157e63a171','4e1b7902-892b-4297-a889-3e157e63a171','e318249fe70a4240a4a0e7ebc5c47a65','c3ea6486309b4dab9bf9d14f604bdce4',1,'tempest-tempest-created-share-473898112','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:42:57.494614','2025-12-04 10:43:01.126349','2025-12-04 10:43:01.126066','50f6ffa5-e4d1-4eae-a0e2-fe753a678f28','50f6ffa5-e4d1-4eae-a0e2-fe753a678f28','d3c52ac6184348f5b9994127e3eeb5e5','e2d34491d1094a9480aa03d0d203a852',1,'tempest-tempest-created-share-1036876449','tempest-tempest-created-share-desc-1567962307',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:43:36.217220','2025-12-04 10:44:40.055171','2025-12-04 10:44:40.054748','51f18aea-3533-4ddd-9c2c-1452cdefca48','51f18aea-3533-4ddd-9c2c-1452cdefca48','48ef94f1dc4447f08252015effc744b0','d831ca1755a740e7819c02d320ecd2a0',1,'tempest-tempest-created-share-564120055','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:40:12.536382','2025-12-04 10:40:35.276726','2025-12-04 10:40:35.276345','532e3f15-999c-4216-a263-82e17255e7b7','532e3f15-999c-4216-a263-82e17255e7b7','74c4687e9ade4a6382ce5c54f9bae971','45b18e29190f4379945421b01e7eb293',1,'tempest-tempest-share-name-1548455948','tempest-tempest-share-description-279902377',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-12-04 10:45:56.407492','2025-12-04 10:47:05.370571','2025-12-04 10:47:05.370054','54385428-bf5e-4ed6-8708-d0e0ea38cbf4','54385428-bf5e-4ed6-8708-d0e0ea38cbf4','c8bddd1494604235b944287494725839','bdee1673bf874393ab80f7311782fc10',1,'tempest-tempest-share-name-1908788019','tempest-tempest-share-description-1595840345',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-12-04 10:42:20.943033','2025-12-04 10:42:28.655857','2025-12-04 10:42:28.655393','5c089416-80f4-44d7-ae20-e3205c02b9f6','5c089416-80f4-44d7-ae20-e3205c02b9f6','8b4c6480f293453d850328438bc66819','094a9e5adfae45769d099eaf0d4f598c',1,'tempest-tempest-created-share-436817336','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:43:18.229699','2025-12-04 10:43:30.223526','2025-12-04 10:43:30.223082','5c6aa58f-f371-4f67-bfaa-356abf09e311','5c6aa58f-f371-4f67-bfaa-356abf09e311','02070bf38c73498d9b030a6203229eab','e884ccda0adb4fcfa58e4992410a7be8',1,'tempest-tempest-new-name-936496833','tempest-tempest-new-description-790227542',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:39:13.108103','2025-12-04 10:39:26.317271','2025-12-04 10:39:26.315832','5f478d7d-5f16-457c-9a2e-0a5b051814ba','5f478d7d-5f16-457c-9a2e-0a5b051814ba','28d021876b6d47e6bb3cbf1d91fe3cfc','fdf8cc9e5d484c87979d04086aa3299b',1,'tempest-tempest-created-share-1876407122','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:45:19.981972','2025-12-04 10:45:25.043528','2025-12-04 10:45:25.042524','61860e1a-3994-4032-baac-83323e59c0a3','61860e1a-3994-4032-baac-83323e59c0a3','16082b385ae54073bd230a6276db6494','fc1dc55455c4455c8c74c6488671677d',1,'tempest-tempest-share-name-1769633598','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:47:17.662947','2025-12-04 10:47:28.570795','2025-12-04 10:47:28.570421','65aad31d-e919-4d8f-8fd3-e6f5cb57e829','65aad31d-e919-4d8f-8fd3-e6f5cb57e829','c99b07cc76794bbe865e84c99d719aec','b08d95dfcf5049b89d93e68ea13452d2',2,'tempest-tempest-created-share-1381345909','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-12-04 10:42:53.760554','2025-12-04 10:43:01.494964','2025-12-04 10:43:01.494363','665b6605-004e-418d-b53a-1f17b68f6116','665b6605-004e-418d-b53a-1f17b68f6116','d3c52ac6184348f5b9994127e3eeb5e5','e2d34491d1094a9480aa03d0d203a852',1,'tempest-tempest-created-share-976597651','tempest-tempest-created-share-desc-1011403433',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:51:19.546941','2025-12-04 10:51:23.557614','2025-12-04 10:51:23.557223','6da520eb-4b5b-4331-a85f-950a1ed4098d','6da520eb-4b5b-4331-a85f-950a1ed4098d','e318249fe70a4240a4a0e7ebc5c47a65','c3ea6486309b4dab9bf9d14f604bdce4',1,'tempest-tempest-created-share-748677719','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:41:12.626214','2025-12-04 10:42:04.867706','2025-12-04 10:42:04.867407','6e8cdd4d-9cb6-49a2-984e-b1bc7db84e85','6e8cdd4d-9cb6-49a2-984e-b1bc7db84e85','956c2a2425364bc58a945afb8a16635a','91320ee163cc40bc8f5c820635954e8f',1,'tempest-tempest-created-share-1252032549','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:39:16.383736','2025-12-04 10:39:22.248328','2025-12-04 10:39:22.247544','7a5b2716-25cd-4893-be6a-f0a300f15ed4','7a5b2716-25cd-4893-be6a-f0a300f15ed4','d2380cdaae7840a7aa1016a0c2242ad2','30e995746f0346cc925a4e4d291b4b4b',2,'tempest-tempest-created-share-1624463234','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:43:08.935048','2025-12-04 10:43:12.625489','2025-12-04 10:43:12.625094','850b0fc4-18a5-4aa9-bf46-67bcab0819c7','850b0fc4-18a5-4aa9-bf46-67bcab0819c7','d3c52ac6184348f5b9994127e3eeb5e5','e2d34491d1094a9480aa03d0d203a852',1,'tempest-tempest-created-share-284610586','tempest-tempest-created-share-desc-2073837355',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:41:50.483423','2025-12-04 10:41:56.422679','2025-12-04 10:41:56.422273','8fd99358-d8c7-47f6-afb5-e68a5184927e','8fd99358-d8c7-47f6-afb5-e68a5184927e','ebdbce19c170478db5c1f470f4d9bb47','ecc97bc6bfe546b6b2d42d386bafab9c',1,'public_share','public_share_desc',NULL,'CEPHFS',1,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:40:19.860842','2025-12-04 10:40:39.522125','2025-12-04 10:40:39.521689','901520d5-7980-429a-b3c0-142b97356ff3','901520d5-7980-429a-b3c0-142b97356ff3','a8ce0e9c3b1244659a5746807a574b35','421364ebc3e041b392bf764a127cfda4',1,'tempest-tempest-created-share-1410297665','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:45:08.070972','2025-12-04 10:45:35.701684','2025-12-04 10:45:35.701289','94798190-fa7d-43ed-a870-3834bf6060ce','94798190-fa7d-43ed-a870-3834bf6060ce','16082b385ae54073bd230a6276db6494','fc1dc55455c4455c8c74c6488671677d',1,'tempest-tempest-share-name-836248999','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:41:53.311413','2025-12-04 10:41:57.217116','2025-12-04 10:41:57.216658','95690aab-70df-44f3-888e-5c2ff20d54d6','95690aab-70df-44f3-888e-5c2ff20d54d6','507c8db7b2164bd98f5556ae52f72fd0','829c39a80695492b897dbe32bb2a565c',1,'private_share','private share in the primary user project',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:40:51.389681','2025-12-04 10:40:58.502882','2025-12-04 10:40:58.502002','9b6a2356-1ed1-4c57-acd8-e2e725f1104a','9b6a2356-1ed1-4c57-acd8-e2e725f1104a','d62cbbb064cd4277b18c062e7f02e202','f6c223a076bd42bd958c3294b89dc763',1,'tempest-tempest-created-share-741381335','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:47:53.667542','2025-12-04 10:48:05.577856','2025-12-04 10:48:05.577315','9bd18f54-a7a7-4fe5-b491-e9720402156c','9bd18f54-a7a7-4fe5-b491-e9720402156c','832dabe00e054a2db2a663d3bafcdafd','440666156b56403fabeabff6ee9b42d9',1,'tempest-tempest-created-share-1128626258','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:39:23.866172','2025-12-04 10:39:58.797936','2025-12-04 10:39:58.797437','9e93d3e8-16df-4d75-9974-bb27d5856c78','9e93d3e8-16df-4d75-9974-bb27d5856c78','9382d7467f084a7daaf3852289dd7e55','1a11c9942929435599f0a51c3f690b44',1,'tempest-tempest-created-share-1480178623','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:46:03.333572','2025-12-04 10:46:58.575747','2025-12-04 10:46:58.575008','9f0837ec-6774-48b2-bb60-211b77035e24','9f0837ec-6774-48b2-bb60-211b77035e24','c8bddd1494604235b944287494725839','bdee1673bf874393ab80f7311782fc10',1,'tempest-tempest-share-name-834601263','tempest-tempest-share-description-1721989573','eb21836e-156d-4fd6-adb6-75fc9fe014e2','CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-12-04 10:42:45.224601','2025-12-04 10:42:49.363148','2025-12-04 10:42:49.362818','a51b5720-8d25-430a-9757-2e06540ba073','a51b5720-8d25-430a-9757-2e06540ba073','d3c52ac6184348f5b9994127e3eeb5e5','e2d34491d1094a9480aa03d0d203a852',1,'tempest-tempest-created-share-1411576545','tempest-tempest-created-share-desc-754641292',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:43:21.668800','2025-12-04 10:43:25.273034','2025-12-04 10:43:25.272310','a654aa17-07c6-4343-ad06-34841716aced','a654aa17-07c6-4343-ad06-34841716aced','d3c52ac6184348f5b9994127e3eeb5e5','e2d34491d1094a9480aa03d0d203a852',1,'tempest-tempest-created-share-901971227','tempest-tempest-created-share-desc-821038364',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:41:16.350218','2025-12-04 10:41:21.853067','2025-12-04 10:41:21.852551','a78f725b-6bc2-44e3-9d71-e7536577a76a','a78f725b-6bc2-44e3-9d71-e7536577a76a','956c2a2425364bc58a945afb8a16635a','91320ee163cc40bc8f5c820635954e8f',1,'tempest-tempest-created-share-693469706','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:47:25.759448',NULL,NULL,'False','a8f732d1-1b5d-49d8-8c55-52087c9cecb1','7cbf92cc96924e4faa65304277a5028e','7df6681d57a74b90abc5310588588b91',1,'tempest-tempest-created-share-643302444','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:43:13.758718','2025-12-04 10:43:21.448736','2025-12-04 10:43:21.448012','a96491cf-ee64-4106-a162-8e6498f8325c','a96491cf-ee64-4106-a162-8e6498f8325c','d3c52ac6184348f5b9994127e3eeb5e5','e2d34491d1094a9480aa03d0d203a852',1,'tempest-tempest-created-share-1949082827','tempest-tempest-created-share-desc-2082432741',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:43:33.848132','2025-12-04 10:43:54.744959','2025-12-04 10:43:54.744526','ac64d4c6-95c7-42bd-ae98-ee18c21bfd68','ac64d4c6-95c7-42bd-ae98-ee18c21bfd68','96fe23c86bd041028a1ccffe636b7da9','7e0c9a3966b443c7bbb289ba33849550',1,'tempest-tempest-created-share-324334414','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:42:16.566574','2025-12-04 10:43:23.212034','2025-12-04 10:43:23.211663','ad85dcc5-0d0d-4da4-81ed-bc7e8e2edbe7','ad85dcc5-0d0d-4da4-81ed-bc7e8e2edbe7','8b4c6480f293453d850328438bc66819','094a9e5adfae45769d099eaf0d4f598c',1,'tempest-tempest-created-share-1267401428','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:43:52.674319','2025-12-04 10:44:44.167741','2025-12-04 10:44:44.166648','adeaaedd-d008-4461-9733-ff7478f34676','adeaaedd-d008-4461-9733-ff7478f34676','0ef0510443b848f1bfcd4a773578d114','18048b8b581e48239e3a92c77164734b',1,'tempest-tempest-share-name-1203011441','tempest-tempest-share-description-702738949',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-12-04 10:43:23.283988','2025-12-04 10:43:27.029653','2025-12-04 10:43:27.029272','af43a924-d75a-47d8-a62d-541b64ecb513','af43a924-d75a-47d8-a62d-541b64ecb513','4c579d8ef46542619c86f7d6ba0c6283','b0e23771bd1a4c3ea8b52092c2e5d69e',1,'tempest-tempest-created-share-1111905538','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:44:05.564082','2025-12-04 10:44:10.886183','2025-12-04 10:44:10.885664','b1336a38-1a5a-47a5-9b90-bf24f6a0a3a2','b1336a38-1a5a-47a5-9b90-bf24f6a0a3a2','cc8309c8aa2b47da966accf9ec753a0e','3ba683091e694bf1800f8fdcd57277cf',1,'tempest-tempest-created-share-933126302','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:40:59.567201','2025-12-04 10:41:03.313346','2025-12-04 10:41:03.312565','b4cdc665-be17-46f3-a891-62bcda45f028','b4cdc665-be17-46f3-a891-62bcda45f028','b5d23f7e91694629931517a6c40efbe5','54f365c11f8e40988b5a964504f91dd7',1,'tempest-tempest-created-share-877961411','tempest-tempest-created-share-desc-466778649',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:39:57.935116','2025-12-04 10:40:06.146861','2025-12-04 10:40:06.146450','b8a5d43b-f887-40e6-bb24-a6d455e76df6','b8a5d43b-f887-40e6-bb24-a6d455e76df6','4450ef386c064ec8865c3f5640993885','bc4567fbe8fa43ebb22d7433659a15be',3,'tempest-tempest-created-share-244173518','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:43:17.399524','2025-12-04 10:43:21.195663','2025-12-04 10:43:21.195212','bc39a08c-bd07-4e7f-a89e-4e028e306a5d','bc39a08c-bd07-4e7f-a89e-4e028e306a5d','d3c52ac6184348f5b9994127e3eeb5e5','e2d34491d1094a9480aa03d0d203a852',1,'tempest-tempest-created-share-1467593543','tempest-tempest-created-share-desc-690975371',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:51:12.818207','2025-12-04 10:51:16.452557','2025-12-04 10:51:16.452186','c2aec3be-39fc-42a2-8169-8562cab8274a','c2aec3be-39fc-42a2-8169-8562cab8274a','e318249fe70a4240a4a0e7ebc5c47a65','c3ea6486309b4dab9bf9d14f604bdce4',1,'tempest-tempest-created-share-1322179865','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:43:05.372214','2025-12-04 10:43:12.972943','2025-12-04 10:43:12.972366','c493aaf0-71d0-4aa8-ab0a-56dba312b5e1','c493aaf0-71d0-4aa8-ab0a-56dba312b5e1','d3c52ac6184348f5b9994127e3eeb5e5','e2d34491d1094a9480aa03d0d203a852',1,'tempest-tempest-created-share-137179708','tempest-tempest-created-share-desc-2049483621',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:40:55.374572','2025-12-04 10:40:58.925152','2025-12-04 10:40:58.924471','c4b62a45-3848-4567-b3a2-b712c3febc47','c4b62a45-3848-4567-b3a2-b712c3febc47','b5d23f7e91694629931517a6c40efbe5','54f365c11f8e40988b5a964504f91dd7',1,'tempest-tempest-created-share-704594203','tempest-tempest-created-share-desc-816756835',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:49:08.795341','2025-12-04 10:49:12.687981','2025-12-04 10:49:12.687589','cb03e6de-1192-49e0-b2ea-604752a95429','cb03e6de-1192-49e0-b2ea-604752a95429','a7cbfaccac8f48c1bc69fb83640618a5','2c40fb2875304a41b2368725937fd373',1,'tempest-tempest-created-share-995294895','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:40:21.133616','2025-12-04 10:40:28.291115','2025-12-04 10:40:28.290388','ce57662e-9b34-431b-a98a-70efbe1e2041','ce57662e-9b34-431b-a98a-70efbe1e2041','74c4687e9ade4a6382ce5c54f9bae971','45b18e29190f4379945421b01e7eb293',1,'tempest-tempest-share-name-755801045','tempest-tempest-share-description-919507793','9dac2a63-84c3-4448-8251-c9b0776fc4fe','CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-12-04 10:49:22.940693','2025-12-04 10:50:29.332003','2025-12-04 10:50:29.331628','d1679b02-3e6b-4d87-bdfb-fde348e3e3f4','d1679b02-3e6b-4d87-bdfb-fde348e3e3f4','a7cbfaccac8f48c1bc69fb83640618a5','2c40fb2875304a41b2368725937fd373',1,'tempest-tempest-created-share-1995582652','Tempest\'s share','24077abd-b36a-49fd-87f6-98a6b2f3bbce','CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-12-04 10:41:59.603400','2025-12-04 10:42:11.340993','2025-12-04 10:42:11.340575','d5438395-ae62-4999-9a2d-0118c28ba3a6','d5438395-ae62-4999-9a2d-0118c28ba3a6','88e5a16daca84b4896b3a4ca2f314a8b','ae2330f34cee47599e079667ef8df8bd',1,'tempest-tempest-created-share-1381220816','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:44:13.496249','2025-12-04 10:44:28.919791','2025-12-04 10:44:28.919408','d9c7ad6d-0886-4bc8-aeea-f4d0267bd9ea','d9c7ad6d-0886-4bc8-aeea-f4d0267bd9ea','ac347d74fad64b0bbb495d6240c31d44','c2e0964e5703431eab30fd7c235961ae',1,'tempest-tempest-created-share-766000190','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:47:55.465660','2025-12-04 10:48:07.201681','2025-12-04 10:48:07.201296','db12e16f-d9ac-495f-a35c-57eb35050f7a','db12e16f-d9ac-495f-a35c-57eb35050f7a','bd0c952b76bd4095a0ae18a8f5a049b2','063b90bfc86448709eb6958911a53f96',1,'tempest-tempest-share-name-504885780','tempest-tempest-share-description-1845547509',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-12-04 10:41:41.756934','2025-12-04 10:41:48.952317','2025-12-04 10:41:48.951940','dcb1d53e-5a72-4bbf-9851-74a087495374','dcb1d53e-5a72-4bbf-9851-74a087495374','956c2a2425364bc58a945afb8a16635a','91320ee163cc40bc8f5c820635954e8f',1,'tempest-tempest-created-share-781979615','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:39:28.124726','2025-12-04 10:39:55.103107','2025-12-04 10:39:55.102717','dd36da1e-4dae-4e6b-ad72-3ba4034e7b70','dd36da1e-4dae-4e6b-ad72-3ba4034e7b70','9382d7467f084a7daaf3852289dd7e55','1a11c9942929435599f0a51c3f690b44',1,'tempest-tempest-created-share-2047251740','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:39:25.527753','2025-12-04 10:39:30.883581','2025-12-04 10:39:30.882629','e38a12c0-b894-428c-9c12-398ff2a4b8c5','e38a12c0-b894-428c-9c12-398ff2a4b8c5','d2380cdaae7840a7aa1016a0c2242ad2','30e995746f0346cc925a4e4d291b4b4b',2,'tempest-tempest-created-share-1550685879','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:42:53.941259','2025-12-04 10:42:58.701372','2025-12-04 10:42:58.700900','e4444d21-8f54-411b-8da5-816ca0c15999','e4444d21-8f54-411b-8da5-816ca0c15999','936c73f02b5847adbbe71630454de16e','bf5ccaceeccc42cc87df11329a9d0159',1,'tempest-tempest-share-name-166870078','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:39:54.179862','2025-12-04 10:40:02.475214','2025-12-04 10:40:02.474632','eb2f745a-806a-46cb-87a3-0e4e4c960116','eb2f745a-806a-46cb-87a3-0e4e4c960116','4450ef386c064ec8865c3f5640993885','bc4567fbe8fa43ebb22d7433659a15be',4,'tempest-tempest-created-share-1812599665','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:39:28.236466','2025-12-04 10:39:34.184048','2025-12-04 10:39:34.183318','ec689bc5-f578-4be4-b1e5-6942ec38d2cb','ec689bc5-f578-4be4-b1e5-6942ec38d2cb','9565e2931ca045c2aff04912e5c4ba5b','a0e02e0e62364d9a86c7e7040e755187',1,'tempest-tempest-created-share-1392611369','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:41:53.740066','2025-12-04 10:41:59.560800','2025-12-04 10:41:59.560415','ecbda702-f36b-4198-aa8c-26a2f24dbd69','ecbda702-f36b-4198-aa8c-26a2f24dbd69','956c2a2425364bc58a945afb8a16635a','91320ee163cc40bc8f5c820635954e8f',1,'tempest-tempest-created-share-518930635','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:46:50.068025','2025-12-04 10:46:55.227403','2025-12-04 10:46:55.226802','efc77317-f625-4cff-bcbb-2ce3261acd01','efc77317-f625-4cff-bcbb-2ce3261acd01','c8bddd1494604235b944287494725839','bdee1673bf874393ab80f7311782fc10',1,'tempest-tempest-created-share-962162439','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2025-12-04 10:40:54.213378','2025-12-04 10:41:13.776868','2025-12-04 10:41:13.776505','f33036ec-7ba1-4fef-81d8-c51952f358ab','f33036ec-7ba1-4fef-81d8-c51952f358ab','346d2a3ba5e24df2a1417033f75e866e','de70f6413fb248c6a07e498350f7a8e3',1,'tempest-share-48029440','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:41:33.957438','2025-12-04 10:41:38.383158','2025-12-04 10:41:38.382525','f5860a15-20fa-4790-a9e1-6bd3ffc4acfa','f5860a15-20fa-4790-a9e1-6bd3ffc4acfa','956c2a2425364bc58a945afb8a16635a','91320ee163cc40bc8f5c820635954e8f',1,'tempest-tempest-created-share-2129023110','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:50:50.237025','2025-12-04 10:51:38.347609','2025-12-04 10:51:38.347248','f654838a-e3cf-4ba9-9b3d-f1435cc8f327','f654838a-e3cf-4ba9-9b3d-f1435cc8f327','e318249fe70a4240a4a0e7ebc5c47a65','c3ea6486309b4dab9bf9d14f604bdce4',1,'tempest-tempest-share-name-1099148215','tempest-tempest-share-description-1804987337',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:42:49.640379','2025-12-04 10:42:53.364587','2025-12-04 10:42:53.364217','f802df4a-4841-44d6-885d-f5daf8f6bbe9','f802df4a-4841-44d6-885d-f5daf8f6bbe9','d3c52ac6184348f5b9994127e3eeb5e5','e2d34491d1094a9480aa03d0d203a852',1,'tempest-tempest-created-share-1243729175','tempest-tempest-created-share-desc-853295335',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2025-12-04 10:42:04.049953','2025-12-04 10:42:08.286464','2025-12-04 10:42:08.286092','fcacf240-d104-463d-a1f4-c5973b1e0799','fcacf240-d104-463d-a1f4-c5973b1e0799','507c8db7b2164bd98f5556ae52f72fd0','829c39a80695492b897dbe32bb2a565c',1,'tempest-tempest-new-share-name-429865637','share is now updated',NULL,'CEPHFS',1,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL);
/*!40000 ALTER TABLE `shares` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `resource_id` varchar(36) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime(6) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
INSERT INTO `transfers` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `resource_id`, `resource_type`, `display_name`, `salt`, `crypt_hash`, `expires_at`, `source_project_id`, `destination_project_id`, `accepted`) VALUES ('12ed5f02-ed36-4263-bf46-b2c7f4fab186','2025-12-04 10:43:05.264009',NULL,'2025-12-04 10:43:05.577603','12ed5f02-ed36-4263-bf46-b2c7f4fab186','0d26c116-5607-4a7f-87c1-6007280ba3d5','share','tempest_share_transfer','0e2f9ffe','7b61ceebece1b8ed6e014e76dc7b29e62472588f87827e315e204cb95acb1ea8','2025-12-04 10:48:05.262631','991152b6ddef4a77a0c0088882c63fa1',NULL,0),('68fda70a-4850-4ef4-bf46-faa6e69f30e0','2025-12-04 10:42:57.444166','2025-12-04 10:42:57.963483','2025-12-04 10:42:57.963480','1','e4444d21-8f54-411b-8da5-816ca0c15999','share','tempest-tempest-created-share-transfer-1171015255','1695149b','fb849163a7d0181c652e742f77ab83baaae307b0de738d25ad6115200582f609','2025-12-04 10:47:57.442231','991152b6ddef4a77a0c0088882c63fa1','bf5ccaceeccc42cc87df11329a9d0159',1),('a8882176-7f67-4436-878a-845ab4b42301','2025-12-04 10:45:11.415565',NULL,'2025-12-04 10:45:11.736456','a8882176-7f67-4436-878a-845ab4b42301','94798190-fa7d-43ed-a870-3834bf6060ce','share','tempest-tempest-created-share-transfer-79495763','58130ae6','a7142f07d3a97aaa8083a1d01c6a78f163009d4b934c12f1a2be4261b4b1c571','2025-12-04 10:50:11.413742','fc1dc55455c4455c8c74c6488671677d',NULL,0),('c9d0faa2-18f8-4c7a-9ce0-f096e48ce5ac','2025-12-04 10:45:19.319259',NULL,'2025-12-04 10:45:19.643596','c9d0faa2-18f8-4c7a-9ce0-f096e48ce5ac','01fe9fef-080a-43fe-bf96-dd9da9f35c9c','share','tempest-tempest-created-share-transfer-1568918968','6e736798','c807995e0c2842a33792c212fdf8e407fdef451c67593c6f116b2c5fa250e956','2025-12-04 10:50:19.315774','fc1dc55455c4455c8c74c6488671677d',NULL,0),('d1b3b343-1f1d-4044-8c82-3ad75932485b','2025-12-04 10:45:15.261891',NULL,'2025-12-04 10:45:15.601832','d1b3b343-1f1d-4044-8c82-3ad75932485b','294ace96-b929-46cc-ba31-c3325815b6a3','share','tempest-tempest-created-share-transfer-1209999890','29cf068d','b84653d1d2c506961fd32e58ecacbcc16fa3409c29fd794bcf967d538c1218f1','2025-12-04 10:50:15.260091','fc1dc55455c4455c8c74c6488671677d',NULL,0),('dd9e7fe6-05a6-4eda-a2f3-c1df4262de07','2025-12-04 10:45:23.421423',NULL,'2025-12-04 10:45:23.797021','dd9e7fe6-05a6-4eda-a2f3-c1df4262de07','61860e1a-3994-4032-baac-83323e59c0a3','share','tempest-tempest-created-share-transfer-666488927','f97c8eed','db4827e21ec90453f5cf56c55605bb75745a74a310c59d1c9c20ee3af8650bf1','2025-12-04 10:50:23.420197','fc1dc55455c4455c8c74c6488671677d',NULL,0);
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','keystone','keystone_e236','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_e236','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','placement','placement_e29f','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_e29f','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','glance','glance_e717','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_e717','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_245b','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_245b','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_c65e','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_c65e','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_0a78','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_0a78','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_7211','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_7211','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_cda9','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_cda9','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','manila','manila_a778','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','manila','manila_a778','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1764842335}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1764842335}'),('localhost','keystone_e236','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*94A208D62EAD1A78079ED6599F1DFE6E8334ADA5\",\"password_last_changed\":1764842355}'),('%','keystone_e236','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*94A208D62EAD1A78079ED6599F1DFE6E8334ADA5\",\"password_last_changed\":1764842355}'),('localhost','placement_e29f','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*3B4A4BF75063B8ED6478EE810C63FE348AD43204\",\"password_last_changed\":1764842355}'),('%','placement_e29f','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*3B4A4BF75063B8ED6478EE810C63FE348AD43204\",\"password_last_changed\":1764842355}'),('localhost','glance_e717','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D8984534D3304491B38AFC1BE061CBC67F59278B\",\"password_last_changed\":1764842355}'),('%','glance_e717','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D8984534D3304491B38AFC1BE061CBC67F59278B\",\"password_last_changed\":1764842355}'),('localhost','barbican_245b','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*0C64D8F51481E94AFAE0C31160C859F44E21B4BE\",\"password_last_changed\":1764842376}'),('%','barbican_245b','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*0C64D8F51481E94AFAE0C31160C859F44E21B4BE\",\"password_last_changed\":1764842376}'),('localhost','neutron_c65e','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*2AB79DD804AA9222DD8B86C38A33806481A4C9A3\",\"password_last_changed\":1764842377}'),('%','neutron_c65e','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*2AB79DD804AA9222DD8B86C38A33806481A4C9A3\",\"password_last_changed\":1764842377}'),('localhost','cinder_0a78','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*FE17EFB69871976FA86CDAAC8791220803D47932\",\"password_last_changed\":1764842377}'),('%','cinder_0a78','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*FE17EFB69871976FA86CDAAC8791220803D47932\",\"password_last_changed\":1764842377}'),('localhost','nova_cell0_7211','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*56B3CEA9ECCE038C2ADE77E2FE7A62CFC69F2DE1\",\"password_last_changed\":1764842486}'),('%','nova_cell0_7211','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*56B3CEA9ECCE038C2ADE77E2FE7A62CFC69F2DE1\",\"password_last_changed\":1764842486}'),('localhost','nova_api_cda9','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*71DFE8C29656CDE4E6254A08A092604F6E8BDE4E\",\"password_last_changed\":1764842487}'),('%','nova_api_cda9','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*71DFE8C29656CDE4E6254A08A092604F6E8BDE4E\",\"password_last_changed\":1764842487}'),('localhost','manila_a778','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*230ED8074D3FA4D90707AEB8CA970700173DD951\",\"password_last_changed\":1764844436}'),('%','manila_a778','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*230ED8074D3FA4D90707AEB8CA970700173DD951\",\"password_last_changed\":1764844436}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mysql_plugin