/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('5c23c3b2-f4d7-476d-9595-7ade89cd29b8','2026-02-19 09:02:48','2026-02-19 09:02:48',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
INSERT INTO `encryption` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `cipher`, `control_location`, `key_size`, `provider`, `volume_type_id`, `encryption_id`) VALUES ('2026-02-19 09:31:59','2026-02-19 09:32:17','2026-02-19 09:32:17',1,'aes-cbc-essiv','front-end',256,'nova.volume.encryptors.luks.LuksEncryptor','1bf13480-93e7-4814-98c8-24eccb55c1b8','ed4a96e6-ee26-4bff-8c1a-df67621b5a2a');
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','3ace732d-8917-4b3b-99f9-312dba4bc1ad','2026-02-19 09:02:37','2026-02-19 09:02:37',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('3ace732d-8917-4b3b-99f9-312dba4bc1ad','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2026-02-19 09:02:37','2026-02-19 09:02:37',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2026-02-19 09:02:32',NULL,NULL,0,1,'default','volumes',10),('2026-02-19 09:02:32',NULL,NULL,0,2,'default','snapshots',10),('2026-02-19 09:02:32',NULL,NULL,0,3,'default','gigabytes',1000),('2026-02-19 09:02:32',NULL,NULL,0,4,'default','consistencygroups',10),('2026-02-19 09:02:32',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2026-02-19 09:02:32',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2026-02-19 09:02:49','2026-02-19 09:43:43',NULL,0,1,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',241,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'0010b0bd-745c-4ae5-a433-1b3075438d92');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2026-02-19 09:31:58',NULL,'2026-02-19 09:32:18',1,'1bf13480-93e7-4814-98c8-24eccb55c1b8','LUKS',NULL,1,NULL),('2026-02-19 09:02:37','2026-02-19 09:02:37',NULL,0,'6d62a32b-8c65-4138-a6ff-7487a9045cc8','__DEFAULT__',NULL,1,'Default Volume Type');
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2026-02-19 09:02:37','2026-02-19 09:02:37.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'68031c1f-102f-4c4c-96de-759cddbda0a0','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/68031c1f-102f-4c4c-96de-759cddbda0a0','2026-02-19 09:28:50','2026-02-19 09:28:50',NULL,0,'{\"store\": \"default_backend\"}','active'),(2,'9e6349ff-2e5d-47c2-8a9d-8f8105f773af','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/9e6349ff-2e5d-47c2-8a9d-8f8105f773af','2026-02-19 09:28:51','2026-02-19 09:28:51',NULL,0,'{\"store\": \"default_backend\"}','active');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'68031c1f-102f-4c4c-96de-759cddbda0a0','hw_rng_model','virtio','2026-02-19 09:28:49','2026-02-19 09:28:49',NULL,0),(2,'9e6349ff-2e5d-47c2-8a9d-8f8105f773af','hw_rng_model','virtio','2026-02-19 09:28:50','2026-02-19 09:28:50',NULL,0);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('68031c1f-102f-4c4c-96de-759cddbda0a0','cirros-0.6.2-x86_64-disk.img',21430272,'active','2026-02-19 09:28:49','2026-02-19 09:28:50',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','36500efc027a4965a43a690ab8c9df90',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('9e6349ff-2e5d-47c2-8a9d-8f8105f773af','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2026-02-19 09:28:50','2026-02-19 09:28:51',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','36500efc027a4965a43a690ab8c9df90',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b');
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2026-02-19 09:01:18',NULL),(1,2,'image','CIM_RASD_','2026-02-19 09:01:18',NULL),(1,3,NULL,'CIM_SASD_','2026-02-19 09:01:18',NULL),(1,9,'image','hw_','2026-02-19 09:01:19',NULL),(1,10,'image','hw_','2026-02-19 09:01:19',NULL),(1,14,'image',NULL,'2026-02-19 09:01:19',NULL),(1,19,'image','hw_','2026-02-19 09:01:19',NULL),(1,25,'image','hw_','2026-02-19 09:01:19',NULL),(1,29,'image',NULL,'2026-02-19 09:01:19',NULL),(1,30,'image',NULL,'2026-02-19 09:01:19',NULL),(1,31,'image',NULL,'2026-02-19 09:01:19',NULL),(1,32,'image',NULL,'2026-02-19 09:01:19',NULL),(2,1,NULL,'CIM_PASD_','2026-02-19 09:01:18',NULL),(2,8,NULL,'hw_','2026-02-19 09:01:18',NULL),(2,9,NULL,'hw_','2026-02-19 09:01:19',NULL),(2,10,NULL,'hw_','2026-02-19 09:01:19',NULL),(2,11,NULL,NULL,'2026-02-19 09:01:19',NULL),(2,13,NULL,NULL,'2026-02-19 09:01:19',NULL),(2,14,NULL,NULL,'2026-02-19 09:01:19',NULL),(2,15,NULL,NULL,'2026-02-19 09:01:19',NULL),(2,16,NULL,'hw_','2026-02-19 09:01:19',NULL),(2,19,NULL,'hw_','2026-02-19 09:01:19',NULL),(2,22,NULL,NULL,'2026-02-19 09:01:19',NULL),(2,23,NULL,'hw_','2026-02-19 09:01:19',NULL),(2,24,NULL,'traits:','2026-02-19 09:01:19',NULL),(2,25,NULL,'hw_','2026-02-19 09:01:19',NULL),(2,26,NULL,NULL,'2026-02-19 09:01:19',NULL),(2,28,NULL,NULL,'2026-02-19 09:01:19',NULL),(2,29,NULL,NULL,'2026-02-19 09:01:19',NULL),(2,30,NULL,NULL,'2026-02-19 09:01:19',NULL),(2,31,NULL,NULL,'2026-02-19 09:01:19',NULL),(2,32,NULL,NULL,'2026-02-19 09:01:19',NULL),(2,33,NULL,'cinder_','2026-02-19 09:01:19',NULL),(3,1,NULL,'CIM_PASD_','2026-02-19 09:01:18',NULL),(3,2,NULL,'CIM_RASD_','2026-02-19 09:01:18',NULL),(3,3,NULL,'CIM_SASD_','2026-02-19 09:01:18',NULL),(3,4,NULL,'CIM_VSSD_','2026-02-19 09:01:18',NULL),(3,5,NULL,NULL,'2026-02-19 09:01:18',NULL),(3,6,NULL,NULL,'2026-02-19 09:01:18',NULL),(3,7,NULL,NULL,'2026-02-19 09:01:18',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2026-02-19 09:01:19',NULL),(4,1,NULL,'CIM_PASD_','2026-02-19 09:01:18',NULL),(4,2,NULL,'CIM_RASD_','2026-02-19 09:01:18',NULL),(4,3,NULL,'CIM_SASD_','2026-02-19 09:01:18',NULL),(4,4,NULL,'CIM_VSSD_','2026-02-19 09:01:18',NULL),(4,8,NULL,'hw:','2026-02-19 09:01:18',NULL),(4,9,NULL,'hw:','2026-02-19 09:01:19',NULL),(4,10,NULL,'hw:','2026-02-19 09:01:19',NULL),(4,12,NULL,'capabilities:','2026-02-19 09:01:19',NULL),(4,16,NULL,'hw:','2026-02-19 09:01:19',NULL),(4,17,NULL,NULL,'2026-02-19 09:01:19',NULL),(4,18,NULL,NULL,'2026-02-19 09:01:19',NULL),(4,19,NULL,'hw:','2026-02-19 09:01:19',NULL),(4,20,NULL,NULL,'2026-02-19 09:01:19',NULL),(4,21,NULL,NULL,'2026-02-19 09:01:19',NULL),(4,23,NULL,'hw:','2026-02-19 09:01:19',NULL),(4,24,NULL,'traits:','2026-02-19 09:01:19',NULL),(4,25,NULL,'hw:','2026-02-19 09:01:19',NULL),(5,1,'scheduler_hints',NULL,'2026-02-19 09:01:18',NULL),(5,30,'metadata',NULL,'2026-02-19 09:01:19',NULL),(5,31,'metadata',NULL,'2026-02-19 09:01:19',NULL),(5,32,'metadata',NULL,'2026-02-19 09:01:19',NULL),(6,30,NULL,NULL,'2026-02-19 09:01:19',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2026-02-19 09:01:18',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2026-02-19 09:01:18',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2026-02-19 09:01:18',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2026-02-19 09:01:18',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-02-19 09:01:18',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-02-19 09:01:18',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2026-02-19 09:01:18',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2026-02-19 09:01:18',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2026-02-19 09:01:18',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2026-02-19 09:01:19',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2026-02-19 09:01:19',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2026-02-19 09:01:19',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2026-02-19 09:01:19',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2026-02-19 09:01:19',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-02-19 09:01:19',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-02-19 09:01:19',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-02-19 09:01:19',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2026-02-19 09:01:19',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2026-02-19 09:01:19',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-02-19 09:01:19',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-02-19 09:01:19',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-02-19 09:01:19',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2026-02-19 09:01:19',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2026-02-19 09:01:19',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-02-19 09:01:19',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-02-19 09:01:19',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2026-02-19 09:01:19',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2026-02-19 09:01:19',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2026-02-19 09:01:19',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2026-02-19 09:01:19',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2026-02-19 09:01:19',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2026-02-19 09:01:19',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2026-02-19 09:01:19',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2026-02-19 09:01:19',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2026-02-19 09:01:19',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2026-02-19 09:01:19',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2026-02-19 09:01:19',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2026-02-19 09:01:19',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2026-02-19 09:01:19',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2026-02-19 09:01:19',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-02-19 09:01:19',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-02-19 09:01:19',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-02-19 09:01:19',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-02-19 09:01:19',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-02-19 09:01:19',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2026-02-19 09:01:19',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2026-02-19 09:01:19',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2026-02-19 09:01:19',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2026-02-19 09:01:19',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2026-02-19 09:01:19',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2026-02-19 09:01:19',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2026-02-19 09:01:19',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2026-02-19 09:01:19',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-02-19 09:01:19',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-02-19 09:01:19',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-02-19 09:01:19',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2026-02-19 09:01:18',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2026-02-19 09:01:18',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2026-02-19 09:01:18',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2026-02-19 09:01:18',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2026-02-19 09:01:18',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-02-19 09:01:18',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2026-02-19 09:01:18',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-02-19 09:01:18',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2026-02-19 09:01:18',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2026-02-19 09:01:18',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2026-02-19 09:01:18',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2026-02-19 09:01:18',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2026-02-19 09:01:18',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2026-02-19 09:01:18',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2026-02-19 09:01:18',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2026-02-19 09:01:18',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2026-02-19 09:01:18',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2026-02-19 09:01:18',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2026-02-19 09:01:18',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2026-02-19 09:01:19',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2026-02-19 09:01:19',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2026-02-19 09:01:19',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2026-02-19 09:01:19',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2026-02-19 09:01:19',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2026-02-19 09:01:19',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2026-02-19 09:01:19',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-02-19 09:01:19',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-02-19 09:01:19',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-02-19 09:01:19',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2026-02-19 09:01:19',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2026-02-19 09:01:19',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2026-02-19 09:01:19',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2026-02-19 09:01:19',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-02-19 09:01:19',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-02-19 09:01:19',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-02-19 09:01:19',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2026-02-19 09:01:19',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2026-02-19 09:01:19',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2026-02-19 09:01:19',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2026-02-19 09:01:19',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2026-02-19 09:01:19',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2026-02-19 09:01:19',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2026-02-19 09:01:19',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2026-02-19 09:01:19',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2026-02-19 09:01:19',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-02-19 09:01:19',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-02-19 09:01:19',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-02-19 09:01:19',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2026-02-19 09:01:19',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-02-19 09:01:19',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2026-02-19 09:01:19',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-02-19 09:01:19',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-02-19 09:01:19',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2026-02-19 09:01:19',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2026-02-19 09:01:19',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2026-02-19 09:01:19',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-02-19 09:01:19',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-02-19 09:01:19',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-02-19 09:01:19',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-02-19 09:01:19',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-02-19 09:01:19',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-02-19 09:01:19',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2026-02-19 09:01:19',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2026-02-19 09:01:19',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2026-02-19 09:01:19',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2026-02-19 09:01:19',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2026-02-19 09:01:19',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2026-02-19 09:01:19',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2026-02-19 09:01:19',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2026-02-19 09:01:19',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2026-02-19 09:01:19',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-02-19 09:01:19',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2026-02-19 09:01:19',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-02-19 09:01:19',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-02-19 09:01:19',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2026-02-19 09:01:19',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2026-02-19 09:01:19',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2026-02-19 09:01:19',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2026-02-19 09:01:19',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2026-02-19 09:01:19',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2026-02-19 09:01:19',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-02-19 09:01:19',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2026-02-19 09:01:19',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-02-19 09:01:19',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2026-02-19 09:01:19',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2026-02-19 09:01:19',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2026-02-19 09:01:19',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2026-02-19 09:01:19',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2026-02-19 09:01:19',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2026-02-19 09:01:19',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2026-02-19 09:01:19',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-02-19 09:01:19',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-02-19 09:01:19',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2026-02-19 09:01:19',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2026-02-19 09:01:19',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2026-02-19 09:01:18',NULL),(2,'OS::Glance::Image',1,'2026-02-19 09:01:18',NULL),(3,'OS::Nova::Aggregate',1,'2026-02-19 09:01:18',NULL),(4,'OS::Nova::Flavor',1,'2026-02-19 09:01:18',NULL),(5,'OS::Nova::Server',1,'2026-02-19 09:01:18',NULL),(6,'OS::Trove::Instance',1,'2026-02-19 09:01:19',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `heat`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `heat` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `heat`;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `resource_action` varchar(255) DEFAULT NULL,
  `resource_status` varchar(255) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `physical_resource_id` varchar(255) DEFAULT NULL,
  `resource_status_reason` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_properties` blob DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `ev_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  CONSTRAINT `ev_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `event_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1493 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event`
--

LOCK TABLES `event` WRITE;
/*!40000 ALTER TABLE `event` DISABLE KEYS */;
INSERT INTO `event` (`id`, `uuid`, `stack_id`, `created_at`, `updated_at`, `resource_action`, `resource_status`, `resource_name`, `physical_resource_id`, `resource_status_reason`, `resource_type`, `resource_properties`, `rsrc_prop_data_id`) VALUES (1,'be17ce7b-28c4-44ce-a340-c22402380356','91314abe-2928-4fd4-8d26-a0e27ab69a92','2026-02-19 09:29:11',NULL,'CREATE','IN_PROGRESS','api-1206788375-rsrcstack','91314abe-2928-4fd4-8d26-a0e27ab69a92','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(2,'cef4fbb3-282b-44ff-aa5d-be080170b4b7','b2ad0b40-ebd0-43d3-bbd3-611445ea3ef1','2026-02-19 09:29:11',NULL,'CREATE','IN_PROGRESS','api-743921893-envstack','b2ad0b40-ebd0-43d3-bbd3-611445ea3ef1','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(3,'859ead76-1d8a-4e26-af96-4de4c76593ec','91314abe-2928-4fd4-8d26-a0e27ab69a92','2026-02-19 09:29:11',NULL,'CREATE','IN_PROGRESS','test','api-1206788375-rsrcstack-test-l6nhsyvb75bj','state changed','OS::Heat::TestResource',NULL,1),(4,'85589e92-3c6e-416c-a7e8-8c82a3418e8d','b2ad0b40-ebd0-43d3-bbd3-611445ea3ef1','2026-02-19 09:29:11',NULL,'CREATE','IN_PROGRESS','test','api-743921893-envstack-test-efurqn2lnwlj','state changed','OS::Heat::TestResource',NULL,2),(5,'93fa2f8f-b108-4ba2-a169-e3b0a1d04b5b','b2ad0b40-ebd0-43d3-bbd3-611445ea3ef1','2026-02-19 09:29:11',NULL,'CREATE','COMPLETE','test','api-743921893-envstack-test-efurqn2lnwlj','state changed','OS::Heat::TestResource',NULL,2),(6,'38de7195-8efe-46c8-aad6-80f35095c92a','91314abe-2928-4fd4-8d26-a0e27ab69a92','2026-02-19 09:29:11',NULL,'CREATE','COMPLETE','test','api-1206788375-rsrcstack-test-l6nhsyvb75bj','state changed','OS::Heat::TestResource',NULL,1),(7,'b95ab253-a442-46f4-8022-817c17bd8a4a','b2ad0b40-ebd0-43d3-bbd3-611445ea3ef1','2026-02-19 09:29:11',NULL,'CREATE','COMPLETE','api-743921893-envstack','b2ad0b40-ebd0-43d3-bbd3-611445ea3ef1','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(8,'3e2f44a2-95d6-4f71-ab02-62f97291863e','91314abe-2928-4fd4-8d26-a0e27ab69a92','2026-02-19 09:29:11',NULL,'CREATE','COMPLETE','api-1206788375-rsrcstack','91314abe-2928-4fd4-8d26-a0e27ab69a92','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(9,'d7c56ede-cfd2-4026-8f37-c6d329f86fca','c3c868ba-7067-4d77-b716-f0f6f519cdc9','2026-02-19 09:29:11',NULL,'CREATE','IN_PROGRESS','api-75184910-rsrcstack','c3c868ba-7067-4d77-b716-f0f6f519cdc9','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(10,'6b56dc79-cf12-456e-a78d-0cf04c873904','af870f05-44c9-4147-b4e9-134924cd9b5b','2026-02-19 09:29:12',NULL,'CREATE','IN_PROGRESS','api-26724205-envstack','af870f05-44c9-4147-b4e9-134924cd9b5b','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(11,'7d9f500a-5c28-4341-99dc-3a23470045e1','c3c868ba-7067-4d77-b716-f0f6f519cdc9','2026-02-19 09:29:12',NULL,'CREATE','IN_PROGRESS','test','api-75184910-rsrcstack-test-6nogkjzofj37','state changed','OS::Heat::TestResource',NULL,3),(12,'3e1928bb-0708-473a-ba8c-9d38d52a6a2e','af870f05-44c9-4147-b4e9-134924cd9b5b','2026-02-19 09:29:12',NULL,'CREATE','IN_PROGRESS','test','api-26724205-envstack-test-fx6rjdih7fti','state changed','OS::Heat::TestResource',NULL,4),(13,'eca6acae-24f9-4fa0-a567-5879fd557ad0','af870f05-44c9-4147-b4e9-134924cd9b5b','2026-02-19 09:29:12',NULL,'CREATE','COMPLETE','test','api-26724205-envstack-test-fx6rjdih7fti','state changed','OS::Heat::TestResource',NULL,4),(14,'ef4ca19c-4a50-4648-bd82-a5adb78ffc87','c3c868ba-7067-4d77-b716-f0f6f519cdc9','2026-02-19 09:29:12',NULL,'CREATE','COMPLETE','test','api-75184910-rsrcstack-test-6nogkjzofj37','state changed','OS::Heat::TestResource',NULL,3),(15,'9ad645c2-a9ec-4264-a92f-1d7632770c46','c3c868ba-7067-4d77-b716-f0f6f519cdc9','2026-02-19 09:29:12',NULL,'CREATE','COMPLETE','api-75184910-rsrcstack','c3c868ba-7067-4d77-b716-f0f6f519cdc9','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(16,'5ec75c10-efb2-407c-8013-ab4cd7e673fe','af870f05-44c9-4147-b4e9-134924cd9b5b','2026-02-19 09:29:12',NULL,'CREATE','COMPLETE','api-26724205-envstack','af870f05-44c9-4147-b4e9-134924cd9b5b','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(17,'afc75f83-2394-4d5f-8df6-98b75c9f13af','af870f05-44c9-4147-b4e9-134924cd9b5b','2026-02-19 09:29:14',NULL,'DELETE','IN_PROGRESS','api-26724205-envstack','af870f05-44c9-4147-b4e9-134924cd9b5b','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(18,'d4a644eb-5c63-46d6-9824-a07b35d65d2b','af870f05-44c9-4147-b4e9-134924cd9b5b','2026-02-19 09:29:14',NULL,'DELETE','IN_PROGRESS','test','api-26724205-envstack-test-fx6rjdih7fti','state changed','OS::Heat::TestResource',NULL,4),(19,'58617e7f-c40f-43f3-9093-04499c216c0a','af870f05-44c9-4147-b4e9-134924cd9b5b','2026-02-19 09:29:14',NULL,'DELETE','COMPLETE','test','api-26724205-envstack-test-fx6rjdih7fti','state changed','OS::Heat::TestResource',NULL,4),(20,'1051b4f2-f48e-4c67-b3f5-5aaeef1d08e6','af870f05-44c9-4147-b4e9-134924cd9b5b','2026-02-19 09:29:14',NULL,'DELETE','COMPLETE','api-26724205-envstack','af870f05-44c9-4147-b4e9-134924cd9b5b','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(21,'dd99dbbc-d1e4-4df1-bbae-e72acacdd652','c3c868ba-7067-4d77-b716-f0f6f519cdc9','2026-02-19 09:29:15',NULL,'CHECK','FAILED','test','api-75184910-rsrcstack-test-6nogkjzofj37','resource deleted','OS::Heat::TestResource',NULL,3),(22,'ae16a8b5-cf67-4075-8962-d0e628dacf43','91314abe-2928-4fd4-8d26-a0e27ab69a92','2026-02-19 09:29:16',NULL,'CHECK','FAILED','test','api-1206788375-rsrcstack-test-l6nhsyvb75bj','resource deleted','OS::Heat::TestResource',NULL,1),(23,'9a4d49f7-c937-44e3-b3f9-dd6482c66a49','6260f36c-df83-4820-8dd8-9cd9f6faa520','2026-02-19 09:29:16',NULL,'CREATE','IN_PROGRESS','api-26724205-rsrcstack','6260f36c-df83-4820-8dd8-9cd9f6faa520','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(24,'b642d6fd-553a-4f56-8c60-5ceed926255e','6260f36c-df83-4820-8dd8-9cd9f6faa520','2026-02-19 09:29:16',NULL,'CREATE','IN_PROGRESS','test','api-26724205-rsrcstack-test-nex3vzrmzysa','state changed','OS::Heat::TestResource',NULL,5),(25,'ec9dd9ec-8610-4b90-a77a-dcf87b52e872','6260f36c-df83-4820-8dd8-9cd9f6faa520','2026-02-19 09:29:16',NULL,'CREATE','COMPLETE','test','api-26724205-rsrcstack-test-nex3vzrmzysa','state changed','OS::Heat::TestResource',NULL,5),(26,'3894b4c6-af5a-4321-b4ef-ac50be55431d','6260f36c-df83-4820-8dd8-9cd9f6faa520','2026-02-19 09:29:16',NULL,'CREATE','COMPLETE','api-26724205-rsrcstack','6260f36c-df83-4820-8dd8-9cd9f6faa520','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(27,'d954fb09-0849-4cef-b0fe-fb9516b80813','91314abe-2928-4fd4-8d26-a0e27ab69a92','2026-02-19 09:29:17',NULL,'DELETE','IN_PROGRESS','api-1206788375-rsrcstack','91314abe-2928-4fd4-8d26-a0e27ab69a92','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(28,'503f6735-1406-4618-84a0-30a3ab30c63a','91314abe-2928-4fd4-8d26-a0e27ab69a92','2026-02-19 09:29:17',NULL,'DELETE','IN_PROGRESS','test','api-1206788375-rsrcstack-test-l6nhsyvb75bj','state changed','OS::Heat::TestResource',NULL,1),(29,'2f1e99d9-d406-47b8-a4f9-fe4c1386e1f7','91314abe-2928-4fd4-8d26-a0e27ab69a92','2026-02-19 09:29:17',NULL,'DELETE','COMPLETE','test','api-1206788375-rsrcstack-test-l6nhsyvb75bj','state changed','OS::Heat::TestResource',NULL,1),(30,'2d1667bc-0735-4a19-8706-f0563a365ba5','91314abe-2928-4fd4-8d26-a0e27ab69a92','2026-02-19 09:29:18',NULL,'DELETE','COMPLETE','api-1206788375-rsrcstack','91314abe-2928-4fd4-8d26-a0e27ab69a92','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(31,'53946426-9b03-4592-898a-6852f17ef884','859a1569-c5c8-4bc7-bae3-5eaed101840d','2026-02-19 09:29:20',NULL,'CREATE','IN_PROGRESS','api-743921893-empty','859a1569-c5c8-4bc7-bae3-5eaed101840d','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(32,'e9181644-c7fb-4365-8523-32a74f7649dc','859a1569-c5c8-4bc7-bae3-5eaed101840d','2026-02-19 09:29:21',NULL,'CREATE','COMPLETE','api-743921893-empty','859a1569-c5c8-4bc7-bae3-5eaed101840d','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(33,'77ee024b-5f73-497a-98fb-a57a4af3e040','741eb13e-6fc0-476d-9cbd-9ec69f18faa8','2026-02-19 09:29:21',NULL,'CREATE','IN_PROGRESS','api-75184910-empty','741eb13e-6fc0-476d-9cbd-9ec69f18faa8','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(34,'081c3700-9c2c-4881-9d62-91c8bc4f9130','741eb13e-6fc0-476d-9cbd-9ec69f18faa8','2026-02-19 09:29:21',NULL,'CREATE','COMPLETE','api-75184910-empty','741eb13e-6fc0-476d-9cbd-9ec69f18faa8','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(35,'6672b116-4d1a-4a64-88dc-7d55146ce645','741eb13e-6fc0-476d-9cbd-9ec69f18faa8','2026-02-19 09:29:22',NULL,'DELETE','IN_PROGRESS','api-75184910-empty','741eb13e-6fc0-476d-9cbd-9ec69f18faa8','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(36,'8cf7646c-d74c-4a26-bb6a-b2a897fdbfb7','741eb13e-6fc0-476d-9cbd-9ec69f18faa8','2026-02-19 09:29:22',NULL,'DELETE','COMPLETE','api-75184910-empty','741eb13e-6fc0-476d-9cbd-9ec69f18faa8','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(37,'fbf8ee81-ed78-40a9-aef9-7a99a584bd98','859a1569-c5c8-4bc7-bae3-5eaed101840d','2026-02-19 09:29:23',NULL,'DELETE','IN_PROGRESS','api-743921893-empty','859a1569-c5c8-4bc7-bae3-5eaed101840d','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(38,'72350ea2-b52d-40c2-914e-17f88e9c17d0','1eb57bcc-a4df-4905-aaa6-fb07c28c4592','2026-02-19 09:29:23',NULL,'CREATE','IN_PROGRESS','api-75184910-stack','1eb57bcc-a4df-4905-aaa6-fb07c28c4592','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(39,'81c3c010-7f34-4bf0-8030-9e64048f90a4','1ee7d6a3-2669-464c-883e-5edf8536c56c','2026-02-19 09:29:23',NULL,'CREATE','IN_PROGRESS','api-1206788375-empty','1ee7d6a3-2669-464c-883e-5edf8536c56c','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(40,'bb70e151-6b1b-4dd9-a28e-0bac8f6e8c3d','859a1569-c5c8-4bc7-bae3-5eaed101840d','2026-02-19 09:29:23',NULL,'DELETE','COMPLETE','api-743921893-empty','859a1569-c5c8-4bc7-bae3-5eaed101840d','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(41,'88a4c521-1fb7-4375-8ad5-29aa666534e0','1ee7d6a3-2669-464c-883e-5edf8536c56c','2026-02-19 09:29:23',NULL,'CREATE','COMPLETE','api-1206788375-empty','1ee7d6a3-2669-464c-883e-5edf8536c56c','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(42,'6e19e4e2-1c4b-40ca-9e57-cdc78c886023','1eb57bcc-a4df-4905-aaa6-fb07c28c4592','2026-02-19 09:29:23',NULL,'CREATE','IN_PROGRESS','test','api-75184910-stack-test-baecjnrnhogd','state changed','OS::Heat::TestResource',NULL,6),(43,'77da5dcb-9049-44b6-84aa-4ca9816f629b','1eb57bcc-a4df-4905-aaa6-fb07c28c4592','2026-02-19 09:29:24',NULL,'CREATE','COMPLETE','test','api-75184910-stack-test-baecjnrnhogd','state changed','OS::Heat::TestResource',NULL,6),(44,'4f4e4193-f1c7-438a-ad52-27fd5cf4d049','1eb57bcc-a4df-4905-aaa6-fb07c28c4592','2026-02-19 09:29:24',NULL,'CREATE','COMPLETE','api-75184910-stack','1eb57bcc-a4df-4905-aaa6-fb07c28c4592','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(45,'5b73d082-a38e-4770-bcc6-05425149dbee','1ee7d6a3-2669-464c-883e-5edf8536c56c','2026-02-19 09:29:24',NULL,'DELETE','IN_PROGRESS','api-1206788375-empty','1ee7d6a3-2669-464c-883e-5edf8536c56c','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(46,'7b007ab4-0a5f-4116-aad8-07d37a478df6','72aebcbb-816d-4920-ae38-282cae3fb0aa','2026-02-19 09:29:24',NULL,'CREATE','IN_PROGRESS','api-26724205-empty','72aebcbb-816d-4920-ae38-282cae3fb0aa','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(47,'319c510e-ad74-48f4-a493-8b038fe3d8f4','1ee7d6a3-2669-464c-883e-5edf8536c56c','2026-02-19 09:29:24',NULL,'DELETE','COMPLETE','api-1206788375-empty','1ee7d6a3-2669-464c-883e-5edf8536c56c','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(48,'5670f608-677a-479d-b8ce-88f370d048f2','72aebcbb-816d-4920-ae38-282cae3fb0aa','2026-02-19 09:29:24',NULL,'CREATE','COMPLETE','api-26724205-empty','72aebcbb-816d-4920-ae38-282cae3fb0aa','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(49,'41972bf7-18bd-4e6b-a6fb-eee272a14892','b746c133-ba4f-462f-804e-68f51e22d638','2026-02-19 09:29:24',NULL,'CREATE','IN_PROGRESS','api-743921893-stack','b746c133-ba4f-462f-804e-68f51e22d638','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(50,'fe99f85f-b36d-4e88-bb2d-0e24c16fca29','b746c133-ba4f-462f-804e-68f51e22d638','2026-02-19 09:29:25',NULL,'CREATE','IN_PROGRESS','test','api-743921893-stack-test-3wfsvjfz3ljt','state changed','OS::Heat::TestResource',NULL,7),(51,'2d428863-6d86-4227-baf9-eb8ec9c538f1','72aebcbb-816d-4920-ae38-282cae3fb0aa','2026-02-19 09:29:25',NULL,'DELETE','IN_PROGRESS','api-26724205-empty','72aebcbb-816d-4920-ae38-282cae3fb0aa','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(52,'0440d981-7b4e-4ab7-9e45-7534ce768f31','b746c133-ba4f-462f-804e-68f51e22d638','2026-02-19 09:29:25',NULL,'CREATE','COMPLETE','test','api-743921893-stack-test-3wfsvjfz3ljt','state changed','OS::Heat::TestResource',NULL,7),(53,'a91d5600-a1c7-4a24-9884-993004b3b930','72aebcbb-816d-4920-ae38-282cae3fb0aa','2026-02-19 09:29:25',NULL,'DELETE','COMPLETE','api-26724205-empty','72aebcbb-816d-4920-ae38-282cae3fb0aa','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(54,'16b317c4-6170-4aed-8d1f-851c5f45b31d','b746c133-ba4f-462f-804e-68f51e22d638','2026-02-19 09:29:25',NULL,'CREATE','COMPLETE','api-743921893-stack','b746c133-ba4f-462f-804e-68f51e22d638','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(55,'f4645af3-3d78-44ff-8990-7c375161f112','0cb91895-818b-45ce-96f9-becf071cce9e','2026-02-19 09:29:25',NULL,'CREATE','IN_PROGRESS','api-1206788375-stack','0cb91895-818b-45ce-96f9-becf071cce9e','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(56,'999bce29-81d8-407e-a875-8ea60211ce41','0cb91895-818b-45ce-96f9-becf071cce9e','2026-02-19 09:29:25',NULL,'CREATE','IN_PROGRESS','test','api-1206788375-stack-test-fm5mnclqlkrj','state changed','OS::Heat::TestResource',NULL,8),(57,'77361ea0-1030-4c08-b8f0-9f7e836afafd','0cb91895-818b-45ce-96f9-becf071cce9e','2026-02-19 09:29:25',NULL,'CREATE','COMPLETE','test','api-1206788375-stack-test-fm5mnclqlkrj','state changed','OS::Heat::TestResource',NULL,8),(58,'509c854d-7e5f-407a-8719-ddeea2a36583','0cb91895-818b-45ce-96f9-becf071cce9e','2026-02-19 09:29:25',NULL,'CREATE','COMPLETE','api-1206788375-stack','0cb91895-818b-45ce-96f9-becf071cce9e','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(59,'3bf68749-9e50-4dad-88c4-c618043afd1e','d979d597-3242-4254-a714-d7af6285e024','2026-02-19 09:29:26',NULL,'CREATE','IN_PROGRESS','api-26724205-stack','d979d597-3242-4254-a714-d7af6285e024','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(60,'21d3f608-212c-4e89-8d30-ebf3a8c2a106','d979d597-3242-4254-a714-d7af6285e024','2026-02-19 09:29:26',NULL,'CREATE','IN_PROGRESS','test','api-26724205-stack-test-slp5ozhrgomv','state changed','OS::Heat::TestResource',NULL,9),(61,'d2b18dd0-1893-4f8c-a0ee-ec655a05cd64','d979d597-3242-4254-a714-d7af6285e024','2026-02-19 09:29:26',NULL,'CREATE','COMPLETE','test','api-26724205-stack-test-slp5ozhrgomv','state changed','OS::Heat::TestResource',NULL,9),(62,'d92df204-6522-453a-a511-8dc50c2398ee','d979d597-3242-4254-a714-d7af6285e024','2026-02-19 09:29:26',NULL,'CREATE','COMPLETE','api-26724205-stack','d979d597-3242-4254-a714-d7af6285e024','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(63,'1e023f6c-99e6-43cc-a443-3f05b95b3c6c','0cb91895-818b-45ce-96f9-becf071cce9e','2026-02-19 09:29:26',NULL,'UPDATE','IN_PROGRESS','api-1206788375-stack','0cb91895-818b-45ce-96f9-becf071cce9e','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(64,'28645638-626a-4cfa-8fb8-f08ffa3c6702','1eb57bcc-a4df-4905-aaa6-fb07c28c4592','2026-02-19 09:29:27',NULL,'UPDATE','IN_PROGRESS','api-75184910-stack','1eb57bcc-a4df-4905-aaa6-fb07c28c4592','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(65,'73e69dfd-d873-4518-8aca-c8f161dc5f79','0cb91895-818b-45ce-96f9-becf071cce9e','2026-02-19 09:29:27',NULL,'UPDATE','IN_PROGRESS','test','api-1206788375-stack-test-fm5mnclqlkrj','state changed','OS::Heat::TestResource',NULL,8),(66,'72dc9f05-c6e4-4c06-b8e4-a5dd19ab82be','1eb57bcc-a4df-4905-aaa6-fb07c28c4592','2026-02-19 09:29:27',NULL,'UPDATE','IN_PROGRESS','test','api-75184910-stack-test-baecjnrnhogd','state changed','OS::Heat::TestResource',NULL,6),(67,'604a2543-8892-40b7-8251-68ede1539214','b746c133-ba4f-462f-804e-68f51e22d638','2026-02-19 09:29:28',NULL,'UPDATE','IN_PROGRESS','api-743921893-stack','b746c133-ba4f-462f-804e-68f51e22d638','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(68,'2ecceb05-ea09-443a-8392-500bd6b3c18d','d979d597-3242-4254-a714-d7af6285e024','2026-02-19 09:29:28',NULL,'UPDATE','IN_PROGRESS','api-26724205-stack','d979d597-3242-4254-a714-d7af6285e024','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(69,'023b758b-1664-4728-a724-ed5201381268','b746c133-ba4f-462f-804e-68f51e22d638','2026-02-19 09:29:28',NULL,'UPDATE','IN_PROGRESS','test','api-743921893-stack-test-3wfsvjfz3ljt','state changed','OS::Heat::TestResource',NULL,7),(70,'47995477-ef23-4412-9f46-1307cd9933c2','d979d597-3242-4254-a714-d7af6285e024','2026-02-19 09:29:28',NULL,'UPDATE','IN_PROGRESS','test','api-26724205-stack-test-slp5ozhrgomv','state changed','OS::Heat::TestResource',NULL,9),(71,'fd987454-bc36-45b9-a553-ef5064e43520','0cb91895-818b-45ce-96f9-becf071cce9e','2026-02-19 09:29:29',NULL,'UPDATE','COMPLETE','test','api-1206788375-stack-test-fm5mnclqlkrj','state changed','OS::Heat::TestResource',NULL,10),(72,'2e8b70a1-b811-4ba5-96e3-0f421d4df215','0cb91895-818b-45ce-96f9-becf071cce9e','2026-02-19 09:29:29',NULL,'UPDATE','COMPLETE','api-1206788375-stack','0cb91895-818b-45ce-96f9-becf071cce9e','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(73,'66c98d2d-fd3b-4d9a-b7ce-2f02a430277d','1eb57bcc-a4df-4905-aaa6-fb07c28c4592','2026-02-19 09:29:29',NULL,'UPDATE','COMPLETE','test','api-75184910-stack-test-baecjnrnhogd','state changed','OS::Heat::TestResource',NULL,11),(74,'ecb1ee1f-f9bb-4da9-8606-ba5cc9321c78','1eb57bcc-a4df-4905-aaa6-fb07c28c4592','2026-02-19 09:29:29',NULL,'UPDATE','COMPLETE','api-75184910-stack','1eb57bcc-a4df-4905-aaa6-fb07c28c4592','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(75,'1c2b96c6-71a5-4381-bbcc-1a70fb1e08e2','1601fa1c-8507-4fb1-90ce-120226b6b3af','2026-02-19 09:29:30',NULL,'CREATE','IN_PROGRESS','add_network','1601fa1c-8507-4fb1-90ce-120226b6b3af','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(76,'93ea27cb-afc2-42f1-8087-05a08f85b51b','1eb57bcc-a4df-4905-aaa6-fb07c28c4592','2026-02-19 09:29:30',NULL,'UPDATE','IN_PROGRESS','api-75184910-stack','1eb57bcc-a4df-4905-aaa6-fb07c28c4592','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(77,'23754017-08a0-411f-9665-a5d0ad8a0d36','1eb57bcc-a4df-4905-aaa6-fb07c28c4592','2026-02-19 09:29:30',NULL,'UPDATE','IN_PROGRESS','test','api-75184910-stack-test-baecjnrnhogd','state changed','OS::Heat::TestResource',NULL,11),(78,'fc45d647-0e02-48fa-9ec3-ad9bf829afe0','d979d597-3242-4254-a714-d7af6285e024','2026-02-19 09:29:30',NULL,'UPDATE','COMPLETE','test','api-26724205-stack-test-slp5ozhrgomv','state changed','OS::Heat::TestResource',NULL,13),(79,'045865be-5f1b-4224-a078-0dc76ada97f3','b746c133-ba4f-462f-804e-68f51e22d638','2026-02-19 09:29:30',NULL,'UPDATE','COMPLETE','test','api-743921893-stack-test-3wfsvjfz3ljt','state changed','OS::Heat::TestResource',NULL,12),(80,'77f439be-a309-4ae1-94f8-d6f176c77355','1601fa1c-8507-4fb1-90ce-120226b6b3af','2026-02-19 09:29:30',NULL,'CREATE','IN_PROGRESS','net','add_network-net-athrethozwut','state changed','OS::Neutron::Net',NULL,14),(81,'f64a4e7e-1420-46cc-ac36-832dffc2799a','b746c133-ba4f-462f-804e-68f51e22d638','2026-02-19 09:29:30',NULL,'UPDATE','COMPLETE','api-743921893-stack','b746c133-ba4f-462f-804e-68f51e22d638','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(82,'918dc996-d455-43fa-b6cc-82596feccd58','d979d597-3242-4254-a714-d7af6285e024','2026-02-19 09:29:30',NULL,'UPDATE','COMPLETE','api-26724205-stack','d979d597-3242-4254-a714-d7af6285e024','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(83,'4d398540-0095-491e-857e-23b23cf6ed13','d979d597-3242-4254-a714-d7af6285e024','2026-02-19 09:29:31',NULL,'UPDATE','IN_PROGRESS','api-26724205-stack','d979d597-3242-4254-a714-d7af6285e024','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(84,'9d13de7e-6baf-4c0c-b3b2-59841c026ca1','b746c133-ba4f-462f-804e-68f51e22d638','2026-02-19 09:29:31',NULL,'UPDATE','IN_PROGRESS','api-743921893-stack','b746c133-ba4f-462f-804e-68f51e22d638','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(85,'8f520d7c-5702-4dea-9ba5-63a70a55b073','d979d597-3242-4254-a714-d7af6285e024','2026-02-19 09:29:31',NULL,'UPDATE','IN_PROGRESS','test','api-26724205-stack-test-slp5ozhrgomv','state changed','OS::Heat::TestResource',NULL,13),(86,'c02a5b39-d90d-4d1a-8e2d-6a734d12c71e','b746c133-ba4f-462f-804e-68f51e22d638','2026-02-19 09:29:31',NULL,'UPDATE','IN_PROGRESS','test','api-743921893-stack-test-3wfsvjfz3ljt','state changed','OS::Heat::TestResource',NULL,12),(87,'4fec2e5c-1917-4a6a-95f8-7f2b4013cc87','1601fa1c-8507-4fb1-90ce-120226b6b3af','2026-02-19 09:29:31',NULL,'CREATE','COMPLETE','net','d3f8ccb8-f74e-4410-a98b-73844ec2995e','state changed','OS::Neutron::Net',NULL,14),(88,'bb845e08-7161-4979-a2d8-fa1b7cc01631','1601fa1c-8507-4fb1-90ce-120226b6b3af','2026-02-19 09:29:31',NULL,'CREATE','IN_PROGRESS','subnet','add_network-subnet-fbw5dhdoenxu','state changed','OS::Neutron::Subnet',NULL,15),(89,'fc4c65ec-8ad7-48a8-88fa-f5591a6df1ef','1eb57bcc-a4df-4905-aaa6-fb07c28c4592','2026-02-19 09:29:32',NULL,'UPDATE','COMPLETE','test','api-75184910-stack-test-baecjnrnhogd','state changed','OS::Heat::TestResource',NULL,16),(90,'20032e95-4e90-485a-b039-18c64fb663f7','1eb57bcc-a4df-4905-aaa6-fb07c28c4592','2026-02-19 09:29:32',NULL,'UPDATE','COMPLETE','api-75184910-stack','1eb57bcc-a4df-4905-aaa6-fb07c28c4592','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(91,'1c8293c2-c8be-4529-aeb8-785df672e4b1','1601fa1c-8507-4fb1-90ce-120226b6b3af','2026-02-19 09:29:33',NULL,'CREATE','COMPLETE','subnet','00944fb3-2710-426f-962d-ed30f172bd99','state changed','OS::Neutron::Subnet',NULL,15),(92,'577f94a8-1ea0-455c-836c-fb9d4993ae3c','1601fa1c-8507-4fb1-90ce-120226b6b3af','2026-02-19 09:29:33',NULL,'CREATE','IN_PROGRESS','server','add_network-server-suuxmxas5y5z','state changed','OS::Nova::Server',NULL,17),(93,'4f19c506-c861-4e11-839a-77f204105102','b746c133-ba4f-462f-804e-68f51e22d638','2026-02-19 09:29:34',NULL,'UPDATE','COMPLETE','test','api-743921893-stack-test-3wfsvjfz3ljt','state changed','OS::Heat::TestResource',NULL,18),(94,'de3f2bb3-31fe-4f7f-9a45-3f0feabea6aa','d979d597-3242-4254-a714-d7af6285e024','2026-02-19 09:29:34',NULL,'UPDATE','COMPLETE','test','api-26724205-stack-test-slp5ozhrgomv','state changed','OS::Heat::TestResource',NULL,19),(95,'6f3640de-b435-4a81-b479-cb9bcedc4949','b746c133-ba4f-462f-804e-68f51e22d638','2026-02-19 09:29:34',NULL,'UPDATE','COMPLETE','api-743921893-stack','b746c133-ba4f-462f-804e-68f51e22d638','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(96,'c3995875-be96-43e5-a61c-3f5c8d8236ff','d979d597-3242-4254-a714-d7af6285e024','2026-02-19 09:29:34',NULL,'UPDATE','COMPLETE','api-26724205-stack','d979d597-3242-4254-a714-d7af6285e024','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(97,'da7d8b55-2469-4657-abfd-ae0c8836880d','2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:35',NULL,'CREATE','IN_PROGRESS','UpdatePortTest-87839386','2dc61297-d308-4e67-b348-9de8b23a1406','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(98,'62a06a79-f08f-4279-bc16-ee9fd224e0b0','2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:35',NULL,'CREATE','IN_PROGRESS','net','UpdatePortTest-87839386-net-lrj5ac4xomft','state changed','OS::Neutron::Net',NULL,NULL),(99,'326ed454-8f0d-415c-a86b-42c3f4e3e30c','2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:37',NULL,'CREATE','COMPLETE','net','81e1a5bf-3dd5-4196-86b5-292648833de3','state changed','OS::Neutron::Net',NULL,NULL),(100,'d0309de1-2b75-4a0e-b1f0-e67f2c4e934b','2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:37',NULL,'CREATE','IN_PROGRESS','subnet','UpdatePortTest-87839386-subnet-bhfzebnmjn66','state changed','OS::Neutron::Subnet',NULL,20),(101,'74fb4ef3-297a-44f7-99ac-120b3e92f4b2','d979d597-3242-4254-a714-d7af6285e024','2026-02-19 09:29:38',NULL,'DELETE','IN_PROGRESS','api-26724205-stack','d979d597-3242-4254-a714-d7af6285e024','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(102,'76c9d3c2-3ef4-4c53-94e4-9c47941d0115','d979d597-3242-4254-a714-d7af6285e024','2026-02-19 09:29:38',NULL,'DELETE','IN_PROGRESS','test','api-26724205-stack-test-slp5ozhrgomv','state changed','OS::Heat::TestResource',NULL,19),(103,'a943a2d7-714c-4470-9036-44260a231aea','d979d597-3242-4254-a714-d7af6285e024','2026-02-19 09:29:38',NULL,'DELETE','COMPLETE','test','api-26724205-stack-test-slp5ozhrgomv','state changed','OS::Heat::TestResource',NULL,19),(104,'ce81eba8-7c18-41a8-9ca8-a1d18cbc6e19','d979d597-3242-4254-a714-d7af6285e024','2026-02-19 09:29:38',NULL,'DELETE','COMPLETE','api-26724205-stack','d979d597-3242-4254-a714-d7af6285e024','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(105,'e499dd73-23b1-42a7-b409-c13f425e0fc0','2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:39',NULL,'CREATE','COMPLETE','subnet','68e07baf-abba-423e-81ec-e6abc340063a','state changed','OS::Neutron::Subnet',NULL,20),(106,'de5604aa-360a-4702-b7b6-6bf0e0b4c996','2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:39',NULL,'CREATE','IN_PROGRESS','port','UpdatePortTest-87839386-port-drzyblp5kez5','state changed','OS::Neutron::Port',NULL,21),(107,'3baa1362-0052-4283-8905-09627fa6f54d','1651c197-0885-4bcd-9f9c-f427f0990477','2026-02-19 09:29:39',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-248403187','1651c197-0885-4bcd-9f9c-f427f0990477','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(108,'bbde619b-1969-433b-ba30-7914cce7c345','1651c197-0885-4bcd-9f9c-f427f0990477','2026-02-19 09:29:39',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-248403187-net-zlmpd34sue24','state changed','OS::Neutron::Net',NULL,NULL),(109,'b0cc25fc-09e1-4b98-9e8c-b013ce419656','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:40',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-1324056510','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(110,'62ab650f-e2a0-4d99-a42c-b26e7566968d','1651c197-0885-4bcd-9f9c-f427f0990477','2026-02-19 09:29:40',NULL,'CREATE','COMPLETE','net','4c4d2f91-9773-46c2-8d97-a1ff70ef2f15','state changed','OS::Neutron::Net',NULL,NULL),(111,'478df4e8-1fd7-47b5-89bd-b5888aef8eb4','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:40',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-1324056510-trunk_net_one-5bbqyt7nxcpa','state changed','OS::Neutron::Net',NULL,NULL),(112,'b3b38fc3-2524-4bde-a356-b295c4c1dbb0','2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:40',NULL,'CREATE','COMPLETE','port','3745b0d2-6bdc-4a30-a405-e763df859656','state changed','OS::Neutron::Port',NULL,21),(113,'f3aaa8d6-efbf-4df4-909b-22baa0280130','1651c197-0885-4bcd-9f9c-f427f0990477','2026-02-19 09:29:40',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-248403187-subnet-6vvm7azvuru5','state changed','OS::Neutron::Subnet',NULL,22),(114,'15aa09dd-119f-40dc-a393-eeee0a0a6745','2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:40',NULL,'CREATE','IN_PROGRESS','test','UpdatePortTest-87839386-test-qzmbmhvld7lz','state changed','OS::Heat::TestResource',NULL,24),(115,'be5f9487-2631-4543-a558-cbe827fafb7a','2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:41',NULL,'CREATE','COMPLETE','test','UpdatePortTest-87839386-test-qzmbmhvld7lz','state changed','OS::Heat::TestResource',NULL,24),(116,'79dd42a5-dd8a-48ef-8f51-085658c1ec82','2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:41',NULL,'CREATE','COMPLETE','UpdatePortTest-87839386','2dc61297-d308-4e67-b348-9de8b23a1406','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(117,'6421583d-8e07-4716-8ff6-aa2a583cafb8','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:41',NULL,'CREATE','COMPLETE','trunk_net_one','27a83bad-7b1d-42e7-8293-8aa2d626005a','state changed','OS::Neutron::Net',NULL,NULL),(118,'cfc46ef5-4752-4719-a503-24cd3f57fe08','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:41',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-1324056510-parent_net-piqtgz7gymme','state changed','OS::Neutron::Net',NULL,NULL),(119,'146a86e0-b22e-45ba-b7d5-c69c70018cff','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:41',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-1324056510-trunk_subnet_one-ze24hsoz57ri','state changed','OS::Neutron::Subnet',NULL,25),(120,'2fa1ecd2-8cd5-4762-a75f-0c2982c8c02a','1651c197-0885-4bcd-9f9c-f427f0990477','2026-02-19 09:29:42',NULL,'CREATE','COMPLETE','subnet','f2a3c84c-5d7c-441a-a74a-e48515e4aba2','state changed','OS::Neutron::Subnet',NULL,22),(121,'9a32612a-4370-4119-8317-db6d799e44d1','1651c197-0885-4bcd-9f9c-f427f0990477','2026-02-19 09:29:42',NULL,'CREATE','COMPLETE','UpdateSubnetTest-248403187','1651c197-0885-4bcd-9f9c-f427f0990477','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(122,'7cafdc78-7ede-40fb-bb39-9eb4cff3bd84','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:42',NULL,'CREATE','COMPLETE','parent_net','2dc13a72-f737-4eda-8ed1-9318c31a4c9c','state changed','OS::Neutron::Net',NULL,NULL),(123,'80ef4530-0813-4006-8ebd-92002ecc1b62','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:42',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-1324056510-parent_subnet-vh7el5sayuze','state changed','OS::Neutron::Subnet',NULL,26),(124,'28d5da64-dba5-4bd3-879c-1ad57b53ec16','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:42',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-1324056510-trunk_net_two-mmpmjhkqatb2','state changed','OS::Neutron::Net',NULL,NULL),(125,'160acd6e-815d-4c53-acc6-693995002c56','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:43',NULL,'CREATE','COMPLETE','trunk_subnet_one','61157604-cc82-4208-b0cc-269017e9ae8e','state changed','OS::Neutron::Subnet',NULL,25),(126,'3169614b-737b-4d80-bfed-1cc90c0caf4f','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:43',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-1324056510-sub_port_one-l2sivmavg3zo','state changed','OS::Neutron::Port',NULL,27),(127,'49e1ad8f-2dd3-4761-8425-8194bd1f41fe','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:44',NULL,'CREATE','COMPLETE','parent_subnet','f55d3a4c-d273-4b84-af3e-28c9ab4c3110','state changed','OS::Neutron::Subnet',NULL,26),(128,'eddea1c9-019e-403c-a941-3106d8dcca0c','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:44',NULL,'CREATE','COMPLETE','trunk_net_two','83284dc4-f44e-45fc-a382-31f09eae6bf9','state changed','OS::Neutron::Net',NULL,NULL),(129,'6033e41b-d85c-4829-bb7c-baa32fdbfc7b','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:44',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-1324056510-parent_port-rx3tjbzae5ru','state changed','OS::Neutron::Port',NULL,28),(130,'6381324b-e644-4f32-ac6e-52b5d508330f','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:44',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-1324056510-trunk_subnet_two-ss6vrzy63y5u','state changed','OS::Neutron::Subnet',NULL,29),(131,'e73d856a-35a1-459b-98b3-10fd38f30a67','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:44',NULL,'CREATE','COMPLETE','sub_port_one','51d34fe4-6477-46c0-9a29-9abdd8d0ec4d','state changed','OS::Neutron::Port',NULL,27),(132,'020b74a3-7820-4995-81be-5bb081ee9e7c','2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:44',NULL,'UPDATE','IN_PROGRESS','UpdatePortTest-87839386','2dc61297-d308-4e67-b348-9de8b23a1406','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(133,'a56f017a-8242-4bd4-a022-ff2e2cfa8e84','1651c197-0885-4bcd-9f9c-f427f0990477','2026-02-19 09:29:45',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-248403187','1651c197-0885-4bcd-9f9c-f427f0990477','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(134,'1567fdc5-1ae0-4b72-b9c3-51e3edaa7ccd','2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:45',NULL,'UPDATE','IN_PROGRESS','port','3745b0d2-6bdc-4a30-a405-e763df859656','state changed','OS::Neutron::Port',NULL,21),(135,'9978671e-3a17-4bd0-9f92-2de077ad9ce1','1651c197-0885-4bcd-9f9c-f427f0990477','2026-02-19 09:29:45',NULL,'UPDATE','IN_PROGRESS','subnet','f2a3c84c-5d7c-441a-a74a-e48515e4aba2','state changed','OS::Neutron::Subnet',NULL,22),(136,'82b56810-dcb4-4fd2-b6b2-7625f1228e61','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:46',NULL,'CREATE','COMPLETE','parent_port','dc937771-300b-41e7-b3af-c8c5c9d34017','state changed','OS::Neutron::Port',NULL,28),(137,'0b3420d5-cdcb-4e07-a18c-ff2036c9121e','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:46',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-1324056510-trunk-5gm5v2kl5r2v','state changed','OS::Neutron::Trunk',NULL,31),(138,'d2024386-d82d-43e8-ac58-bea371563516','1651c197-0885-4bcd-9f9c-f427f0990477','2026-02-19 09:29:46',NULL,'UPDATE','COMPLETE','subnet','f2a3c84c-5d7c-441a-a74a-e48515e4aba2','state changed','OS::Neutron::Subnet',NULL,32),(139,'e3137bbc-05d5-4f83-b9fc-725bbe4b9ed2','1651c197-0885-4bcd-9f9c-f427f0990477','2026-02-19 09:29:46',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-248403187','1651c197-0885-4bcd-9f9c-f427f0990477','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(140,'d6f09979-d3e8-4f97-a2ef-8a4203cc1f4f','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:46',NULL,'CREATE','COMPLETE','trunk_subnet_two','a85e90e3-5beb-40e4-8a92-31a477a0566c','state changed','OS::Neutron::Subnet',NULL,29),(141,'11aafbec-2711-42a8-828b-3a1a45c14944','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:46',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-1324056510-sub_port_two-y4bcooshcbvn','state changed','OS::Neutron::Port',NULL,33),(142,'484cca59-bf36-4f2c-bfaa-c9e41a7c2ee2','2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:48',NULL,'UPDATE','COMPLETE','port','3745b0d2-6bdc-4a30-a405-e763df859656','state changed','OS::Neutron::Port',NULL,34),(143,'ea58bb30-213d-4067-b6f7-ee034dfbdc97','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:48',NULL,'CREATE','COMPLETE','trunk','791b9ea4-ee2f-4dfe-be88-fe5f2e6ae387','state changed','OS::Neutron::Trunk',NULL,31),(144,'bc5298f8-659a-4e65-a0b4-a08437580e9b','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:48',NULL,'CREATE','COMPLETE','sub_port_two','f3c7254d-e8e9-4043-a418-f65f05656c4c','state changed','OS::Neutron::Port',NULL,33),(145,'41236978-1a41-45a4-b674-cd04e3ea15b7','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:48',NULL,'CREATE','COMPLETE','UpdateTrunkTest-1324056510','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(146,'8c868de6-abf6-44c9-9413-7766336fddc3','2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:48',NULL,'UPDATE','COMPLETE','UpdatePortTest-87839386','2dc61297-d308-4e67-b348-9de8b23a1406','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(147,'b76a6f4e-9b0a-469d-a351-d3fcc7b68897','2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:49',NULL,'DELETE','IN_PROGRESS','UpdatePortTest-87839386','2dc61297-d308-4e67-b348-9de8b23a1406','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(148,'d0204413-9573-4bef-930d-0ea0079f20bc','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:50',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-1324056510','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(149,'caaef0ae-0970-4b27-a86c-5e54955dfea5','2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:50',NULL,'DELETE','IN_PROGRESS','test','UpdatePortTest-87839386-test-qzmbmhvld7lz','state changed','OS::Heat::TestResource',NULL,24),(150,'771aa458-0aec-400e-9374-df18f8c5ee20','2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:50',NULL,'DELETE','COMPLETE','test','UpdatePortTest-87839386-test-qzmbmhvld7lz','state changed','OS::Heat::TestResource',NULL,24),(151,'fd251849-d511-4947-bf51-bb33904a4651','1651c197-0885-4bcd-9f9c-f427f0990477','2026-02-19 09:29:50',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-248403187','1651c197-0885-4bcd-9f9c-f427f0990477','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(152,'ef0c200d-f649-408e-838b-ef8431b30593','2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:50',NULL,'DELETE','IN_PROGRESS','port','3745b0d2-6bdc-4a30-a405-e763df859656','state changed','OS::Neutron::Port',NULL,34),(153,'793d39a3-27dc-4933-9b0f-fed1266f3768','1651c197-0885-4bcd-9f9c-f427f0990477','2026-02-19 09:29:50',NULL,'DELETE','IN_PROGRESS','subnet','f2a3c84c-5d7c-441a-a74a-e48515e4aba2','state changed','OS::Neutron::Subnet',NULL,32),(154,'29ec5bf1-d61d-4a67-83b9-e1d3612725c7','1651c197-0885-4bcd-9f9c-f427f0990477','2026-02-19 09:29:51',NULL,'DELETE','COMPLETE','subnet','f2a3c84c-5d7c-441a-a74a-e48515e4aba2','state changed','OS::Neutron::Subnet',NULL,32),(155,'032465c3-a5da-4461-8087-a3ebbb431cb8','1651c197-0885-4bcd-9f9c-f427f0990477','2026-02-19 09:29:51',NULL,'DELETE','IN_PROGRESS','net','4c4d2f91-9773-46c2-8d97-a1ff70ef2f15','state changed','OS::Neutron::Net',NULL,NULL),(156,'7781cfd7-82c4-4200-a72c-c1bfd68f7c4b','2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:51',NULL,'DELETE','COMPLETE','port','3745b0d2-6bdc-4a30-a405-e763df859656','state changed','OS::Neutron::Port',NULL,34),(157,'7258e5fe-f6ea-4fe0-a78f-61832fe303f8','2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:51',NULL,'DELETE','IN_PROGRESS','subnet','68e07baf-abba-423e-81ec-e6abc340063a','state changed','OS::Neutron::Subnet',NULL,20),(158,'32261465-d728-4fe5-8019-8a8201699749','2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:51',NULL,'DELETE','COMPLETE','subnet','68e07baf-abba-423e-81ec-e6abc340063a','state changed','OS::Neutron::Subnet',NULL,20),(159,'0267aa33-1d6f-43c0-8d8a-639fbdd76d33','2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:51',NULL,'DELETE','IN_PROGRESS','net','81e1a5bf-3dd5-4196-86b5-292648833de3','state changed','OS::Neutron::Net',NULL,NULL),(160,'6e4eb1b0-998e-45b8-833a-0969b20b694e','1651c197-0885-4bcd-9f9c-f427f0990477','2026-02-19 09:29:51',NULL,'DELETE','COMPLETE','net','4c4d2f91-9773-46c2-8d97-a1ff70ef2f15','state changed','OS::Neutron::Net',NULL,NULL),(161,'b8a1bbf2-d446-45bc-8e01-60802c9f45ab','1651c197-0885-4bcd-9f9c-f427f0990477','2026-02-19 09:29:52',NULL,'DELETE','COMPLETE','UpdateSubnetTest-248403187','1651c197-0885-4bcd-9f9c-f427f0990477','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(162,'49640abc-226d-4466-9c26-c15bd06a1e82','1601fa1c-8507-4fb1-90ce-120226b6b3af','2026-02-19 09:29:52',NULL,'CREATE','COMPLETE','server','d49ce4dc-fb3f-4754-bc8a-8fccbf968992','state changed','OS::Nova::Server',NULL,17),(163,'d8135642-6a57-48c5-b3a0-f0484399872b','1601fa1c-8507-4fb1-90ce-120226b6b3af','2026-02-19 09:29:52',NULL,'CREATE','COMPLETE','add_network','1601fa1c-8507-4fb1-90ce-120226b6b3af','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(164,'c015ae21-d54d-46c8-b5d2-762f1b74e440','2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:53',NULL,'DELETE','COMPLETE','net','81e1a5bf-3dd5-4196-86b5-292648833de3','state changed','OS::Neutron::Net',NULL,NULL),(165,'545b7f97-f9e2-4ed9-89c1-2863679841f9','2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:53',NULL,'DELETE','COMPLETE','UpdatePortTest-87839386','2dc61297-d308-4e67-b348-9de8b23a1406','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(166,'557a2821-a816-4d25-9fdf-cd39e7d51d4d','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:54',NULL,'UPDATE','IN_PROGRESS','trunk','791b9ea4-ee2f-4dfe-be88-fe5f2e6ae387','state changed','OS::Neutron::Trunk',NULL,31),(167,'6cb01cd0-bd6a-44bd-9bb1-49c5c441da31','1556fdcf-229b-4746-a5c9-ce25fea87ce2','2026-02-19 09:29:56',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-1483220816','1556fdcf-229b-4746-a5c9-ce25fea87ce2','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(168,'e1892543-28c2-4ea2-87cd-ee57b9125d0b','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:29:56',NULL,'CREATE','IN_PROGRESS','UpdatePortTest-795770163','b58680e1-d9a4-421a-9cce-0135c41a58d8','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(169,'8c62ef81-332b-414c-9f64-7324f319236d','1556fdcf-229b-4746-a5c9-ce25fea87ce2','2026-02-19 09:29:56',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-1483220816-net-rqjgow2nonwv','state changed','OS::Neutron::Net',NULL,NULL),(170,'965e8c0a-5dc6-40f4-a243-65922d3fe345','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:57',NULL,'UPDATE','COMPLETE','trunk','791b9ea4-ee2f-4dfe-be88-fe5f2e6ae387','state changed','OS::Neutron::Trunk',NULL,37),(171,'23bae5b6-9e18-429d-99e6-0903a2ad05e7','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:29:57',NULL,'CREATE','IN_PROGRESS','net','UpdatePortTest-795770163-net-krm5fr45beau','state changed','OS::Neutron::Net',NULL,NULL),(172,'ad68e7c2-56c9-499e-b9fb-4187c73ec52f','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:57',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-1324056510','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(173,'bc03c61e-0b81-4d88-846a-591f7a7834ac','1556fdcf-229b-4746-a5c9-ce25fea87ce2','2026-02-19 09:29:59',NULL,'CREATE','COMPLETE','net','33be70f0-a0e4-4678-b8af-adf133da5c1f','state changed','OS::Neutron::Net',NULL,NULL),(174,'c1ae603c-5298-4158-9c33-b6f391bbff0c','1601fa1c-8507-4fb1-90ce-120226b6b3af','2026-02-19 09:29:59',NULL,'UPDATE','IN_PROGRESS','add_network','1601fa1c-8507-4fb1-90ce-120226b6b3af','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(175,'78e1ab14-1bdb-408f-ba2b-fad5388bfb04','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:29:59',NULL,'CREATE','COMPLETE','net','bd35c0c6-dcef-4d81-8855-f3c6a95fba02','state changed','OS::Neutron::Net',NULL,NULL),(176,'756896a1-da2c-4299-9e1a-0c788ab4fd5b','1556fdcf-229b-4746-a5c9-ce25fea87ce2','2026-02-19 09:29:59',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-1483220816-subnet-dnkhvpg6iwwy','state changed','OS::Neutron::Subnet',NULL,39),(177,'35ca400c-7ece-42a9-aada-73f3ed942b37','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:29:59',NULL,'CREATE','IN_PROGRESS','subnet','UpdatePortTest-795770163-subnet-4zi3jcp2pw6t','state changed','OS::Neutron::Subnet',NULL,40),(178,'ea2df9d7-aacb-41f5-8adf-d2235c7cdf2b','1601fa1c-8507-4fb1-90ce-120226b6b3af','2026-02-19 09:30:01',NULL,'UPDATE','IN_PROGRESS','server','d49ce4dc-fb3f-4754-bc8a-8fccbf968992','state changed','OS::Nova::Server',NULL,17),(179,'da5dfe02-243f-4211-8ef4-5d55b07479a2','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:30:01',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-1324056510','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(180,'97b63a7c-11ef-45f7-8eb5-f7f99062e229','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:30:01',NULL,'CREATE','COMPLETE','subnet','f4d6ce03-c68e-4384-8054-fddbc8dfe92b','state changed','OS::Neutron::Subnet',NULL,40),(181,'7d67f271-2704-4b54-9b39-8fd4d5a49de7','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:30:01',NULL,'CREATE','IN_PROGRESS','port','UpdatePortTest-795770163-port-gks7gchelqlo','state changed','OS::Neutron::Port',NULL,42),(182,'a17dbc7d-449c-42cc-b97a-a39288f05473','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:30:01',NULL,'DELETE','IN_PROGRESS','trunk','791b9ea4-ee2f-4dfe-be88-fe5f2e6ae387','state changed','OS::Neutron::Trunk',NULL,37),(183,'bf0086c7-922a-46a8-a389-357ff072cb26','1556fdcf-229b-4746-a5c9-ce25fea87ce2','2026-02-19 09:30:02',NULL,'CREATE','COMPLETE','subnet','5fb71236-531c-48cd-bb00-32963d5bc94a','state changed','OS::Neutron::Subnet',NULL,39),(184,'38691dcd-b6a3-49ca-ba8c-c9b21c95da99','1556fdcf-229b-4746-a5c9-ce25fea87ce2','2026-02-19 09:30:02',NULL,'CREATE','COMPLETE','UpdateSubnetTest-1483220816','1556fdcf-229b-4746-a5c9-ce25fea87ce2','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(185,'c7f28251-b6c1-42c2-bb2d-ec8b5ad3bf87','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:30:02',NULL,'DELETE','COMPLETE','trunk','791b9ea4-ee2f-4dfe-be88-fe5f2e6ae387','state changed','OS::Neutron::Trunk',NULL,37),(186,'740065fe-7ea2-4a59-b99e-d1774dbe9f5c','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:30:02',NULL,'DELETE','IN_PROGRESS','parent_port','dc937771-300b-41e7-b3af-c8c5c9d34017','state changed','OS::Neutron::Port',NULL,28),(187,'5f262a65-ba76-49a5-aa93-b10e84490900','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:30:02',NULL,'DELETE','IN_PROGRESS','sub_port_one','51d34fe4-6477-46c0-9a29-9abdd8d0ec4d','state changed','OS::Neutron::Port',NULL,27),(188,'6a9317a0-d014-4791-a420-0a5e8b00a1b3','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:30:02',NULL,'DELETE','IN_PROGRESS','sub_port_two','f3c7254d-e8e9-4043-a418-f65f05656c4c','state changed','OS::Neutron::Port',NULL,33),(189,'d8585445-2f33-4193-b7d7-1c95373386d5','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:30:03',NULL,'CREATE','COMPLETE','port','1029c6fe-29f3-4c57-9c32-890d8098c97f','state changed','OS::Neutron::Port',NULL,42),(190,'c4b4259b-154f-46b8-b106-1a2ee61c7387','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:30:03',NULL,'CREATE','IN_PROGRESS','test','UpdatePortTest-795770163-test-vpqzup35uv6u','state changed','OS::Heat::TestResource',NULL,44),(191,'4ebd30a1-d3e6-4581-aaeb-8694c4c08978','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:30:03',NULL,'DELETE','COMPLETE','sub_port_one','51d34fe4-6477-46c0-9a29-9abdd8d0ec4d','state changed','OS::Neutron::Port',NULL,27),(192,'817261f9-0390-4802-82d7-2fe44123301e','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:30:03',NULL,'CREATE','COMPLETE','test','UpdatePortTest-795770163-test-vpqzup35uv6u','state changed','OS::Heat::TestResource',NULL,44),(193,'fe7113bf-7706-4d6e-acf2-1adc8ae840e3','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:30:03',NULL,'CREATE','COMPLETE','UpdatePortTest-795770163','b58680e1-d9a4-421a-9cce-0135c41a58d8','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(194,'7dae1643-0df8-4987-bd2e-83d6317032cc','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:30:03',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','61157604-cc82-4208-b0cc-269017e9ae8e','state changed','OS::Neutron::Subnet',NULL,25),(195,'2f65b5ba-abe2-4e7f-a04f-569fe1703c6d','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:30:03',NULL,'DELETE','COMPLETE','parent_port','dc937771-300b-41e7-b3af-c8c5c9d34017','state changed','OS::Neutron::Port',NULL,28),(196,'93c8f644-6892-4de1-a25f-220784bf708c','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:30:03',NULL,'DELETE','COMPLETE','sub_port_two','f3c7254d-e8e9-4043-a418-f65f05656c4c','state changed','OS::Neutron::Port',NULL,33),(197,'b8ab27d3-fb63-42c6-a405-3e5c2de31241','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:30:03',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','a85e90e3-5beb-40e4-8a92-31a477a0566c','state changed','OS::Neutron::Subnet',NULL,29),(198,'27c17f9a-4b3e-43b7-b659-5e810244391e','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:30:03',NULL,'DELETE','IN_PROGRESS','parent_subnet','f55d3a4c-d273-4b84-af3e-28c9ab4c3110','state changed','OS::Neutron::Subnet',NULL,26),(199,'166059ab-d802-4245-9ad3-a89b08620526','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:30:04',NULL,'DELETE','COMPLETE','trunk_subnet_one','61157604-cc82-4208-b0cc-269017e9ae8e','state changed','OS::Neutron::Subnet',NULL,25),(200,'7fc1e3d9-6dca-40ae-a221-7fb0d07c8efe','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:30:04',NULL,'DELETE','IN_PROGRESS','trunk_net_one','27a83bad-7b1d-42e7-8293-8aa2d626005a','state changed','OS::Neutron::Net',NULL,NULL),(201,'f139a7ad-1db0-4f61-969e-309e09b847c6','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:30:04',NULL,'DELETE','COMPLETE','parent_subnet','f55d3a4c-d273-4b84-af3e-28c9ab4c3110','state changed','OS::Neutron::Subnet',NULL,26),(202,'44fb38bb-4aa7-4bfa-93d0-32aa09038a77','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:30:04',NULL,'DELETE','COMPLETE','trunk_subnet_two','a85e90e3-5beb-40e4-8a92-31a477a0566c','state changed','OS::Neutron::Subnet',NULL,29),(203,'a712cce8-da64-4770-b8c6-950c25172f04','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:30:04',NULL,'DELETE','IN_PROGRESS','trunk_net_two','83284dc4-f44e-45fc-a382-31f09eae6bf9','state changed','OS::Neutron::Net',NULL,NULL),(204,'5f460b5b-fc19-49d9-9ec1-7b400fa3668d','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:30:04',NULL,'DELETE','IN_PROGRESS','parent_net','2dc13a72-f737-4eda-8ed1-9318c31a4c9c','state changed','OS::Neutron::Net',NULL,NULL),(205,'9bad1c8f-faf3-4b45-8c0f-cab016155c9d','1601fa1c-8507-4fb1-90ce-120226b6b3af','2026-02-19 09:30:05',NULL,'UPDATE','COMPLETE','server','d49ce4dc-fb3f-4754-bc8a-8fccbf968992','state changed','OS::Nova::Server',NULL,45),(206,'198dc693-023c-4ea1-a054-e4ede80df04a','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:30:05',NULL,'DELETE','COMPLETE','parent_net','2dc13a72-f737-4eda-8ed1-9318c31a4c9c','state changed','OS::Neutron::Net',NULL,NULL),(207,'266c8c36-4eff-4b5a-953b-9e910dc1dc99','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:30:05',NULL,'DELETE','COMPLETE','trunk_net_one','27a83bad-7b1d-42e7-8293-8aa2d626005a','state changed','OS::Neutron::Net',NULL,NULL),(208,'92e1ff1d-21cb-40ca-a880-8798089f8b48','1601fa1c-8507-4fb1-90ce-120226b6b3af','2026-02-19 09:30:05',NULL,'UPDATE','COMPLETE','add_network','1601fa1c-8507-4fb1-90ce-120226b6b3af','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(209,'f8be4d37-11f9-47db-8915-86a50e3cf0d1','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:30:05',NULL,'DELETE','COMPLETE','trunk_net_two','83284dc4-f44e-45fc-a382-31f09eae6bf9','state changed','OS::Neutron::Net',NULL,NULL),(210,'2e7057e4-4aaf-4730-8873-f2cfe2ed8771','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:30:05',NULL,'DELETE','COMPLETE','UpdateTrunkTest-1324056510','c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(211,'bc30e874-fb8c-46e1-ac3a-7de7733fdfd8','1556fdcf-229b-4746-a5c9-ce25fea87ce2','2026-02-19 09:30:07',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-1483220816','1556fdcf-229b-4746-a5c9-ce25fea87ce2','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(212,'cb712f17-45cc-4a53-a624-1b7cc316b809','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:30:07',NULL,'UPDATE','IN_PROGRESS','UpdatePortTest-795770163','b58680e1-d9a4-421a-9cce-0135c41a58d8','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(213,'b552377e-3564-4832-8be8-e84f53945d44','1556fdcf-229b-4746-a5c9-ce25fea87ce2','2026-02-19 09:30:07',NULL,'UPDATE','IN_PROGRESS','subnet','5fb71236-531c-48cd-bb00-32963d5bc94a','state changed','OS::Neutron::Subnet',NULL,39),(214,'f48d71b9-dad6-44e6-8a21-5aa137b4015b','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:30:08',NULL,'UPDATE','IN_PROGRESS','port','1029c6fe-29f3-4c57-9c32-890d8098c97f','state changed','OS::Neutron::Port',NULL,42),(215,'7b80d1fc-873e-42e7-9f25-54f988f59fce','1556fdcf-229b-4746-a5c9-ce25fea87ce2','2026-02-19 09:30:08',NULL,'UPDATE','COMPLETE','subnet','5fb71236-531c-48cd-bb00-32963d5bc94a','state changed','OS::Neutron::Subnet',NULL,47),(216,'baa15f48-3282-4199-8c3b-7ffe819d9326','1556fdcf-229b-4746-a5c9-ce25fea87ce2','2026-02-19 09:30:08',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-1483220816','1556fdcf-229b-4746-a5c9-ce25fea87ce2','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(217,'118843aa-8d1b-45fc-8fa0-79d4d9cf3b7d','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:30:09',NULL,'UPDATE','COMPLETE','port','1029c6fe-29f3-4c57-9c32-890d8098c97f','The Resource port requires replacement.','OS::Neutron::Port',NULL,42),(218,'2e44e876-a412-4bf0-8cd4-b2e62df34a7d','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:30:09',NULL,'CREATE','IN_PROGRESS','port','UpdatePortTest-795770163-port-ka4ejhigcape','state changed','OS::Neutron::Port',NULL,49),(219,'265b64a6-0efb-4085-9408-30a9ae1e6b66','1601fa1c-8507-4fb1-90ce-120226b6b3af','2026-02-19 09:30:10',NULL,'DELETE','IN_PROGRESS','add_network','1601fa1c-8507-4fb1-90ce-120226b6b3af','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(220,'3523fd36-5958-4f6a-9e5a-676522ea3f2a','1601fa1c-8507-4fb1-90ce-120226b6b3af','2026-02-19 09:30:10',NULL,'DELETE','IN_PROGRESS','server','d49ce4dc-fb3f-4754-bc8a-8fccbf968992','state changed','OS::Nova::Server',NULL,45),(221,'d1a5edfc-ecca-47c7-a48e-30897799b222','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:30:11',NULL,'CREATE','COMPLETE','port','d719b3ef-ffcf-47ee-9bbd-2c87695fab97','state changed','OS::Neutron::Port',NULL,49),(222,'1e1ba73d-8be4-4f5d-ad56-c32b8931f76d','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:30:11',NULL,'DELETE','IN_PROGRESS','port','1029c6fe-29f3-4c57-9c32-890d8098c97f','state changed','OS::Neutron::Port',NULL,42),(223,'474358b4-6744-4d19-b197-b51c7d17463f','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:11',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-611057247','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(224,'efab2cb8-c7cd-40ec-807e-8d587f16a3d5','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:12',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-611057247-parent_net-e4pjwr2zoztc','state changed','OS::Neutron::Net',NULL,NULL),(225,'59d6076e-d590-496a-9667-b8d2cdf27c46','1556fdcf-229b-4746-a5c9-ce25fea87ce2','2026-02-19 09:30:12',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-1483220816','1556fdcf-229b-4746-a5c9-ce25fea87ce2','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(226,'a162ba25-78a5-4fc8-a95f-bf4a811d412a','1556fdcf-229b-4746-a5c9-ce25fea87ce2','2026-02-19 09:30:12',NULL,'DELETE','IN_PROGRESS','subnet','5fb71236-531c-48cd-bb00-32963d5bc94a','state changed','OS::Neutron::Subnet',NULL,47),(227,'95441d38-5a23-4888-be3c-1d37314d713a','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:30:12',NULL,'DELETE','COMPLETE','port','1029c6fe-29f3-4c57-9c32-890d8098c97f','state changed','OS::Neutron::Port',NULL,42),(228,'a927cd09-a79c-4afb-807b-7f11ba47f1ff','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:30:12',NULL,'UPDATE','COMPLETE','UpdatePortTest-795770163','b58680e1-d9a4-421a-9cce-0135c41a58d8','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(229,'5110775d-41c9-483a-8061-1c80bad26b29','1601fa1c-8507-4fb1-90ce-120226b6b3af','2026-02-19 09:30:12',NULL,'DELETE','COMPLETE','server','d49ce4dc-fb3f-4754-bc8a-8fccbf968992','state changed','OS::Nova::Server',NULL,45),(230,'db191e12-1b66-48e2-84ca-25e5b06d401b','1601fa1c-8507-4fb1-90ce-120226b6b3af','2026-02-19 09:30:13',NULL,'DELETE','IN_PROGRESS','subnet','00944fb3-2710-426f-962d-ed30f172bd99','state changed','OS::Neutron::Subnet',NULL,15),(231,'cc4d84e7-0bf0-4609-8d4d-1913f3562de4','1556fdcf-229b-4746-a5c9-ce25fea87ce2','2026-02-19 09:30:13',NULL,'DELETE','COMPLETE','subnet','5fb71236-531c-48cd-bb00-32963d5bc94a','state changed','OS::Neutron::Subnet',NULL,47),(232,'d50569c5-850a-4178-981a-6a8ea3986206','1556fdcf-229b-4746-a5c9-ce25fea87ce2','2026-02-19 09:30:13',NULL,'DELETE','IN_PROGRESS','net','33be70f0-a0e4-4678-b8af-adf133da5c1f','state changed','OS::Neutron::Net',NULL,NULL),(233,'58e12e51-2725-4422-aaac-9be1d6c2b36e','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:13',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-611057247-trunk_net_two-jacq7i7pgwk6','state changed','OS::Neutron::Net',NULL,NULL),(234,'3b4bd92e-3a6b-4ab1-8be1-541f397a359c','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:13',NULL,'CREATE','COMPLETE','parent_net','7d5a5c8c-ab95-4edc-ad95-178c4ccba055','state changed','OS::Neutron::Net',NULL,NULL),(235,'9176324b-8c5d-4e97-9590-22729e157c93','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:13',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-611057247-parent_subnet-vrmdkoefcsyu','state changed','OS::Neutron::Subnet',NULL,52),(236,'9804cce6-f777-4d92-8fab-cf2fc42af056','1601fa1c-8507-4fb1-90ce-120226b6b3af','2026-02-19 09:30:13',NULL,'DELETE','COMPLETE','subnet','00944fb3-2710-426f-962d-ed30f172bd99','state changed','OS::Neutron::Subnet',NULL,15),(237,'fc4e6239-c6a6-499a-8357-3fdd45cce8fa','1601fa1c-8507-4fb1-90ce-120226b6b3af','2026-02-19 09:30:13',NULL,'DELETE','IN_PROGRESS','net','d3f8ccb8-f74e-4410-a98b-73844ec2995e','state changed','OS::Neutron::Net',NULL,14),(238,'023ac229-2389-4e94-988c-731156d3806c','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:14',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-611057247-trunk_net_one-7wtewi6uubto','state changed','OS::Neutron::Net',NULL,NULL),(239,'246ff297-9e21-42d7-9bb7-c1cf44c0b449','1556fdcf-229b-4746-a5c9-ce25fea87ce2','2026-02-19 09:30:14',NULL,'DELETE','COMPLETE','net','33be70f0-a0e4-4678-b8af-adf133da5c1f','state changed','OS::Neutron::Net',NULL,NULL),(240,'7f84f7a3-dd82-4fab-b022-1a523d12138d','1556fdcf-229b-4746-a5c9-ce25fea87ce2','2026-02-19 09:30:14',NULL,'DELETE','COMPLETE','UpdateSubnetTest-1483220816','1556fdcf-229b-4746-a5c9-ce25fea87ce2','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(241,'ad991ada-1642-4fe7-b207-c6fb03e6ff70','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:14',NULL,'CREATE','COMPLETE','trunk_net_two','56f89fc5-e9f8-411e-994b-caf3914c479b','state changed','OS::Neutron::Net',NULL,NULL),(242,'cb441318-4174-4423-b1a6-e24ed09e4c63','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:14',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-611057247-trunk_subnet_two-5fwnvceugjgb','state changed','OS::Neutron::Subnet',NULL,53),(243,'a77dd002-cb65-4f1b-9141-a008096f2264','1601fa1c-8507-4fb1-90ce-120226b6b3af','2026-02-19 09:30:14',NULL,'DELETE','COMPLETE','net','d3f8ccb8-f74e-4410-a98b-73844ec2995e','state changed','OS::Neutron::Net',NULL,14),(244,'bddb15dd-5c75-4bce-8c03-b26439739afc','1601fa1c-8507-4fb1-90ce-120226b6b3af','2026-02-19 09:30:14',NULL,'DELETE','COMPLETE','add_network','1601fa1c-8507-4fb1-90ce-120226b6b3af','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(245,'f6e4e804-a7f2-4bcf-b256-5a5643357287','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:15',NULL,'CREATE','COMPLETE','parent_subnet','c73de785-7dd9-4720-b3f9-15db2e8ae0be','state changed','OS::Neutron::Subnet',NULL,52),(246,'71b8cc80-6b34-4199-a34f-36aa3b147c95','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:15',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-611057247-parent_port-qn3sfmsan47e','state changed','OS::Neutron::Port',NULL,54),(247,'604aaa2b-a86d-45c8-a0e3-ca9c94d1b558','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:15',NULL,'CREATE','COMPLETE','trunk_net_one','5d36cec2-1bb6-476b-866a-cf484e50a4b8','state changed','OS::Neutron::Net',NULL,NULL),(248,'b68f4b73-39d0-49b8-9958-f96ac6cccce3','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:15',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-611057247-trunk_subnet_one-ohg2cnvnlpfz','state changed','OS::Neutron::Subnet',NULL,55),(249,'f17f5c65-3068-4793-b943-5a99d509b105','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:16',NULL,'CREATE','COMPLETE','trunk_subnet_two','81177806-10d5-4881-b026-b7a6cd0524ea','state changed','OS::Neutron::Subnet',NULL,53),(250,'6cf89cba-28d8-4d84-aca8-b9f6e5609b6f','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:16',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-611057247-sub_port_two-oaaghcmgiiq2','state changed','OS::Neutron::Port',NULL,56),(251,'34668fe2-8dde-4efb-a1ac-87335adb1f38','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:30:16',NULL,'DELETE','IN_PROGRESS','UpdatePortTest-795770163','b58680e1-d9a4-421a-9cce-0135c41a58d8','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(252,'857df795-967d-4efb-b6ac-81fa39035b40','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:16',NULL,'CREATE','COMPLETE','parent_port','3dcbf980-d272-47a6-8703-d7210965e20b','state changed','OS::Neutron::Port',NULL,54),(253,'b4633e6a-9dbd-4234-8ae3-27a38380ccae','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:30:16',NULL,'DELETE','IN_PROGRESS','test','UpdatePortTest-795770163-test-vpqzup35uv6u','state changed','OS::Heat::TestResource',NULL,44),(254,'300a63e2-d5ca-4c2c-a963-40bccc9f1a41','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:30:17',NULL,'DELETE','COMPLETE','test','UpdatePortTest-795770163-test-vpqzup35uv6u','state changed','OS::Heat::TestResource',NULL,44),(255,'c3148e71-eb7b-4fee-84af-34684ab904e8','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:17',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-611057247-trunk-4b56bmtfiieb','state changed','OS::Neutron::Trunk',NULL,57),(256,'b06d3fc0-c830-4e8d-a71a-c8311cd0ef82','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:17',NULL,'CREATE','COMPLETE','trunk_subnet_one','21df2491-eb80-4013-b808-4bea86ea0f4d','state changed','OS::Neutron::Subnet',NULL,55),(257,'7b801c3a-fcd4-446e-a5f7-b556052917b1','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:17',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-611057247-sub_port_one-bdtlwhalzj6q','state changed','OS::Neutron::Port',NULL,58),(258,'558dadfe-cf9a-4601-baf0-074e579c759d','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:17',NULL,'CREATE','COMPLETE','trunk','75051b28-5ec5-4ff2-ad22-639be6d4a1cb','state changed','OS::Neutron::Trunk',NULL,57),(259,'22799a41-1680-44f4-8519-35d7e65fb39c','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:17',NULL,'CREATE','COMPLETE','sub_port_two','500ae168-7e94-4338-842a-adf0ae048470','state changed','OS::Neutron::Port',NULL,56),(260,'8f27757e-04c4-48c9-849c-40d4ab871f79','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:30:17',NULL,'DELETE','IN_PROGRESS','port','d719b3ef-ffcf-47ee-9bbd-2c87695fab97','state changed','OS::Neutron::Port',NULL,49),(261,'daddaed4-02db-4385-aaef-2b98a07c1a0d','fd49aaf5-6751-4be5-bad9-b211c5399bad','2026-02-19 09:30:18',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-1737812987','fd49aaf5-6751-4be5-bad9-b211c5399bad','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(262,'bd86ae95-af6c-49d0-a103-9def54659caa','fd49aaf5-6751-4be5-bad9-b211c5399bad','2026-02-19 09:30:18',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-1737812987-net-w4bhqsl3a6ny','state changed','OS::Neutron::Net',NULL,NULL),(263,'4c0f02aa-c3f4-43c0-a40a-f51d3c18a3a0','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:19',NULL,'CREATE','COMPLETE','sub_port_one','b342f1dd-6d64-4a86-b111-773b296bc979','state changed','OS::Neutron::Port',NULL,58),(264,'89c13675-37a3-47a3-bb04-c5a0c9b914c1','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:19',NULL,'CREATE','COMPLETE','UpdateTrunkTest-611057247','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(265,'51fb4bb8-49c5-474c-aa72-65db016edcbc','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:30:19',NULL,'DELETE','COMPLETE','port','d719b3ef-ffcf-47ee-9bbd-2c87695fab97','state changed','OS::Neutron::Port',NULL,49),(266,'8ef4aa99-9548-40e1-b93c-df2ea420b8f4','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:30:19',NULL,'DELETE','IN_PROGRESS','subnet','f4d6ce03-c68e-4384-8054-fddbc8dfe92b','state changed','OS::Neutron::Subnet',NULL,40),(267,'055d73cf-9d4b-441f-93a1-d5ff7c48c397','fd49aaf5-6751-4be5-bad9-b211c5399bad','2026-02-19 09:30:19',NULL,'CREATE','COMPLETE','net','a05b7cab-039e-4a1d-a5f4-bcc927c0d924','state changed','OS::Neutron::Net',NULL,NULL),(268,'7b5c83c8-137c-4021-a387-48516962f1d0','fd49aaf5-6751-4be5-bad9-b211c5399bad','2026-02-19 09:30:19',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-1737812987-subnet-tri3z7egcjn3','state changed','OS::Neutron::Subnet',NULL,59),(269,'d81cad1e-8848-4fdf-a5ea-f7e734c7df63','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:30:19',NULL,'DELETE','COMPLETE','subnet','f4d6ce03-c68e-4384-8054-fddbc8dfe92b','state changed','OS::Neutron::Subnet',NULL,40),(270,'321eabc6-7d9a-4bfa-a983-056b820cb061','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:30:20',NULL,'DELETE','IN_PROGRESS','net','bd35c0c6-dcef-4d81-8855-f3c6a95fba02','state changed','OS::Neutron::Net',NULL,NULL),(271,'14c82173-3b88-4b6e-8160-14e99a502a73','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:30:20',NULL,'DELETE','COMPLETE','net','bd35c0c6-dcef-4d81-8855-f3c6a95fba02','state changed','OS::Neutron::Net',NULL,NULL),(272,'483d1b5c-d3f2-4153-8e7d-f34d9acbe296','b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:30:20',NULL,'DELETE','COMPLETE','UpdatePortTest-795770163','b58680e1-d9a4-421a-9cce-0135c41a58d8','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(273,'6cc5fa16-c204-4268-b939-92c980a942ee','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:21',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-611057247','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(274,'b301905a-db2d-417d-931b-2a40ac624014','fd49aaf5-6751-4be5-bad9-b211c5399bad','2026-02-19 09:30:21',NULL,'CREATE','COMPLETE','subnet','049db160-590e-425f-ae96-308f8d93cfa7','state changed','OS::Neutron::Subnet',NULL,59),(275,'cbce18b2-8f6d-4681-b285-5058e31b69f8','fd49aaf5-6751-4be5-bad9-b211c5399bad','2026-02-19 09:30:21',NULL,'CREATE','COMPLETE','UpdateSubnetTest-1737812987','fd49aaf5-6751-4be5-bad9-b211c5399bad','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(276,'eed532ab-92a4-4e70-bb5b-488e8755824d','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','2026-02-19 09:30:21',NULL,'CREATE','IN_PROGRESS','same_fixed_ip','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(277,'68052076-18e0-4f24-afdc-7f1a14d96810','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','2026-02-19 09:30:21',NULL,'CREATE','IN_PROGRESS','net','same_fixed_ip-net-n2tzurzxwkzi','state changed','OS::Neutron::Net',NULL,60),(278,'03280ce3-2dd2-46fe-922f-7d53af128898','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','2026-02-19 09:30:22',NULL,'CREATE','COMPLETE','net','6b6fc2f7-d426-4acf-8b1f-e10c1ee0bd83','state changed','OS::Neutron::Net',NULL,60),(279,'dc6f8db1-7eca-4c89-83f0-4ec64be7ac33','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','2026-02-19 09:30:22',NULL,'CREATE','IN_PROGRESS','subnet','same_fixed_ip-subnet-4w4bjikhwkm6','state changed','OS::Neutron::Subnet',NULL,61),(280,'e41989ac-00ad-4a9c-abe7-e5774188450f','fd49aaf5-6751-4be5-bad9-b211c5399bad','2026-02-19 09:30:25',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-1737812987','fd49aaf5-6751-4be5-bad9-b211c5399bad','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(281,'ce3db871-d382-49e8-a6d4-f62b3f3f092e','fd49aaf5-6751-4be5-bad9-b211c5399bad','2026-02-19 09:30:25',NULL,'UPDATE','IN_PROGRESS','subnet','049db160-590e-425f-ae96-308f8d93cfa7','state changed','OS::Neutron::Subnet',NULL,59),(282,'b4424bd7-eef9-4ad7-a295-a769bdb5772e','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:25',NULL,'UPDATE','IN_PROGRESS','trunk','75051b28-5ec5-4ff2-ad22-639be6d4a1cb','state changed','OS::Neutron::Trunk',NULL,57),(283,'966ec1dc-2f88-4189-b92f-0cadeeeb9ecb','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','2026-02-19 09:30:25',NULL,'CREATE','COMPLETE','subnet','59ad7ea4-d005-4a1f-9f6b-c32a47840545','state changed','OS::Neutron::Subnet',NULL,61),(284,'ce98718b-6b8f-4847-91cd-c68fb6101528','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','2026-02-19 09:30:26',NULL,'CREATE','IN_PROGRESS','server','same_fixed_ip-server-zg3za2wzya4n','state changed','OS::Nova::Server',NULL,63),(285,'6439d760-5c37-49dd-b3b1-77ba9c2a217a','fd49aaf5-6751-4be5-bad9-b211c5399bad','2026-02-19 09:30:27',NULL,'UPDATE','COMPLETE','subnet','049db160-590e-425f-ae96-308f8d93cfa7','state changed','OS::Neutron::Subnet',NULL,64),(286,'190d386b-32db-41d7-b028-361cd155a79c','fd49aaf5-6751-4be5-bad9-b211c5399bad','2026-02-19 09:30:27',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-1737812987','fd49aaf5-6751-4be5-bad9-b211c5399bad','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(287,'15c82f9b-cdf8-4267-bb2b-f30e82d6f4b6','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:27',NULL,'UPDATE','COMPLETE','trunk','75051b28-5ec5-4ff2-ad22-639be6d4a1cb','state changed','OS::Neutron::Trunk',NULL,65),(288,'dd5894ed-52fb-4e92-9213-c328131f8574','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:27',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-611057247','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(289,'c4c1b760-809a-4742-9fdc-63edebb2c6cb','6bd86a81-afb8-46ea-a818-b15647fc62fa','2026-02-19 09:30:28',NULL,'CREATE','IN_PROGRESS','server_with_port','6bd86a81-afb8-46ea-a818-b15647fc62fa','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(290,'db3bbfe7-3e12-41f7-9ab9-20e4e8d1c9e7','6bd86a81-afb8-46ea-a818-b15647fc62fa','2026-02-19 09:30:28',NULL,'CREATE','IN_PROGRESS','net','server_with_port-net-tjcb2n5gbbtm','state changed','OS::Neutron::Net',NULL,66),(291,'e7f41228-4c52-490f-94d9-c0dd1ec45770','6bd86a81-afb8-46ea-a818-b15647fc62fa','2026-02-19 09:30:29',NULL,'CREATE','COMPLETE','net','d3965991-db72-4e1f-85ce-4cc5d54834de','state changed','OS::Neutron::Net',NULL,66),(292,'d41a9a5f-ca96-4add-9e8e-c2014095f757','6bd86a81-afb8-46ea-a818-b15647fc62fa','2026-02-19 09:30:29',NULL,'CREATE','IN_PROGRESS','subnet','server_with_port-subnet-2zt6elhjpj6k','state changed','OS::Neutron::Subnet',NULL,67),(293,'cb566873-62ce-440a-a96b-9828a47d19e5','fd49aaf5-6751-4be5-bad9-b211c5399bad','2026-02-19 09:30:31',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-1737812987','fd49aaf5-6751-4be5-bad9-b211c5399bad','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(294,'bbd698df-44a0-4521-830a-dce8b9d20ea9','fd49aaf5-6751-4be5-bad9-b211c5399bad','2026-02-19 09:30:31',NULL,'DELETE','IN_PROGRESS','subnet','049db160-590e-425f-ae96-308f8d93cfa7','state changed','OS::Neutron::Subnet',NULL,64),(295,'93c878c5-63f6-4500-b525-23d367b0386b','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:31',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-611057247','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(296,'f4a9fc25-ec96-4f92-9531-d20c8b70a1b4','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:32',NULL,'DELETE','IN_PROGRESS','trunk','75051b28-5ec5-4ff2-ad22-639be6d4a1cb','state changed','OS::Neutron::Trunk',NULL,65),(297,'4bddce11-2004-4d56-96f6-56f13e545b2a','fd49aaf5-6751-4be5-bad9-b211c5399bad','2026-02-19 09:30:32',NULL,'DELETE','COMPLETE','subnet','049db160-590e-425f-ae96-308f8d93cfa7','state changed','OS::Neutron::Subnet',NULL,64),(298,'deb6842d-69e4-42ed-99c1-ff4f4ac45d4d','fd49aaf5-6751-4be5-bad9-b211c5399bad','2026-02-19 09:30:32',NULL,'DELETE','IN_PROGRESS','net','a05b7cab-039e-4a1d-a5f4-bcc927c0d924','state changed','OS::Neutron::Net',NULL,NULL),(299,'088a94d6-442c-4a54-bd1c-e795a6c3d789','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:32',NULL,'DELETE','COMPLETE','trunk','75051b28-5ec5-4ff2-ad22-639be6d4a1cb','state changed','OS::Neutron::Trunk',NULL,65),(300,'67f7c3d9-343b-43ff-91c3-3b7871e083cd','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:32',NULL,'DELETE','IN_PROGRESS','sub_port_one','b342f1dd-6d64-4a86-b111-773b296bc979','state changed','OS::Neutron::Port',NULL,58),(301,'4f695d96-a1b2-4d33-935d-6c8d5b465ed3','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:33',NULL,'DELETE','IN_PROGRESS','parent_port','3dcbf980-d272-47a6-8703-d7210965e20b','state changed','OS::Neutron::Port',NULL,54),(302,'e08e73e9-ecb6-47ad-ac25-f23f117e1e2e','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:33',NULL,'DELETE','IN_PROGRESS','sub_port_two','500ae168-7e94-4338-842a-adf0ae048470','state changed','OS::Neutron::Port',NULL,56),(303,'1b7851bc-d962-417e-b6af-e09550b0a182','6bd86a81-afb8-46ea-a818-b15647fc62fa','2026-02-19 09:30:33',NULL,'CREATE','COMPLETE','subnet','d46beca2-89cd-4c69-b425-8c9e2e1bbb9e','state changed','OS::Neutron::Subnet',NULL,67),(304,'8b2661b3-1956-4162-879e-34077c9d5670','6bd86a81-afb8-46ea-a818-b15647fc62fa','2026-02-19 09:30:33',NULL,'CREATE','IN_PROGRESS','port','server_with_port-port-4lp67x3rwzga','state changed','OS::Neutron::Port',NULL,70),(305,'092e66c8-68ed-440c-8cab-f89b21cabc35','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:34',NULL,'DELETE','COMPLETE','sub_port_two','500ae168-7e94-4338-842a-adf0ae048470','state changed','OS::Neutron::Port',NULL,56),(306,'d44415db-050f-4d39-9a29-6f6ccd86ad8e','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:34',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','81177806-10d5-4881-b026-b7a6cd0524ea','state changed','OS::Neutron::Subnet',NULL,53),(307,'b94ab8ae-9f02-4e8d-b5b9-89b07a53cbbc','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:34',NULL,'DELETE','COMPLETE','parent_port','3dcbf980-d272-47a6-8703-d7210965e20b','state changed','OS::Neutron::Port',NULL,54),(308,'2675152d-fcc0-47f0-a85d-3dc739f4d0e1','fd49aaf5-6751-4be5-bad9-b211c5399bad','2026-02-19 09:30:34',NULL,'DELETE','COMPLETE','net','a05b7cab-039e-4a1d-a5f4-bcc927c0d924','state changed','OS::Neutron::Net',NULL,NULL),(309,'d63cbece-1676-4bee-9481-39be5ab27efa','fd49aaf5-6751-4be5-bad9-b211c5399bad','2026-02-19 09:30:34',NULL,'DELETE','COMPLETE','UpdateSubnetTest-1737812987','fd49aaf5-6751-4be5-bad9-b211c5399bad','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(310,'0d4ec194-cc56-4fd2-91ae-0b76bba70e3e','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:34',NULL,'DELETE','COMPLETE','sub_port_one','b342f1dd-6d64-4a86-b111-773b296bc979','state changed','OS::Neutron::Port',NULL,58),(311,'26c3db40-539c-47f4-bb00-4c44fa106c09','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:34',NULL,'DELETE','IN_PROGRESS','parent_subnet','c73de785-7dd9-4720-b3f9-15db2e8ae0be','state changed','OS::Neutron::Subnet',NULL,52),(312,'322f53c3-a419-4e96-84ed-d005a6386ef6','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:34',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','21df2491-eb80-4013-b808-4bea86ea0f4d','state changed','OS::Neutron::Subnet',NULL,55),(313,'9078b2ec-dee4-43c9-a659-988c800ff35c','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:34',NULL,'DELETE','COMPLETE','trunk_subnet_two','81177806-10d5-4881-b026-b7a6cd0524ea','state changed','OS::Neutron::Subnet',NULL,53),(314,'c714ad46-b53b-4e66-b66b-a0fd76411f0f','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:34',NULL,'DELETE','IN_PROGRESS','trunk_net_two','56f89fc5-e9f8-411e-994b-caf3914c479b','state changed','OS::Neutron::Net',NULL,NULL),(315,'a76c1d57-62b4-42a5-b351-dc8e1f2ba98a','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:34',NULL,'DELETE','COMPLETE','trunk_subnet_one','21df2491-eb80-4013-b808-4bea86ea0f4d','state changed','OS::Neutron::Subnet',NULL,55),(316,'f0927653-92a7-4769-a076-caef4bd81fd5','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:34',NULL,'DELETE','IN_PROGRESS','trunk_net_one','5d36cec2-1bb6-476b-866a-cf484e50a4b8','state changed','OS::Neutron::Net',NULL,NULL),(317,'57faab86-85f3-4265-986a-b34140941393','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:35',NULL,'DELETE','COMPLETE','parent_subnet','c73de785-7dd9-4720-b3f9-15db2e8ae0be','state changed','OS::Neutron::Subnet',NULL,52),(318,'bf4f2178-5486-48f0-a09a-f197a500e2a7','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:35',NULL,'DELETE','IN_PROGRESS','parent_net','7d5a5c8c-ab95-4edc-ad95-178c4ccba055','state changed','OS::Neutron::Net',NULL,NULL),(319,'8e971513-f958-4130-aef2-8f7f8f2a6bb8','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:35',NULL,'DELETE','COMPLETE','trunk_net_two','56f89fc5-e9f8-411e-994b-caf3914c479b','state changed','OS::Neutron::Net',NULL,NULL),(320,'73f2a359-3a63-4624-8ab5-60a6193f3855','6bd86a81-afb8-46ea-a818-b15647fc62fa','2026-02-19 09:30:36',NULL,'CREATE','COMPLETE','port','4ee2933f-0452-4250-bee4-97ced09c50f1','state changed','OS::Neutron::Port',NULL,70),(321,'f0493cbf-d385-4f74-8a55-9f9234dbe6d8','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:36',NULL,'DELETE','COMPLETE','parent_net','7d5a5c8c-ab95-4edc-ad95-178c4ccba055','state changed','OS::Neutron::Net',NULL,NULL),(322,'302fbedd-202b-4826-9418-f3f353b8189e','6bd86a81-afb8-46ea-a818-b15647fc62fa','2026-02-19 09:30:36',NULL,'CREATE','IN_PROGRESS','server','server_with_port-server-f7dvwxoivx4j','state changed','OS::Nova::Server',NULL,71),(323,'f8ea5fed-b23b-42ab-a2d7-9cf96e582dea','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:36',NULL,'DELETE','COMPLETE','trunk_net_one','5d36cec2-1bb6-476b-866a-cf484e50a4b8','state changed','OS::Neutron::Net',NULL,NULL),(324,'041fbb81-1743-40c4-8de8-93c259ecc3c8','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:36',NULL,'DELETE','COMPLETE','UpdateTrunkTest-611057247','66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(325,'5d6917e2-c410-4867-8613-9c57944c5546','f2e71c33-6e82-4cc3-887c-792b3fa2acfb','2026-02-19 09:30:37',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-1100360100','f2e71c33-6e82-4cc3-887c-792b3fa2acfb','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(326,'50db7962-6551-4d57-9fe4-d9f33b8960a5','f2e71c33-6e82-4cc3-887c-792b3fa2acfb','2026-02-19 09:30:37',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-1100360100-net-na5sajhkc3ln','state changed','OS::Neutron::Net',NULL,NULL),(327,'3b012d17-6c1a-4428-8172-667bb78fb45d','f2e71c33-6e82-4cc3-887c-792b3fa2acfb','2026-02-19 09:30:40',NULL,'CREATE','COMPLETE','net','c7cd1c81-f22a-4851-9190-e037e1e65f02','state changed','OS::Neutron::Net',NULL,NULL),(328,'9afada7c-e920-4d26-b4ae-50c53a4193c8','f2e71c33-6e82-4cc3-887c-792b3fa2acfb','2026-02-19 09:30:40',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-1100360100-subnet-o4lcichszyaj','state changed','OS::Neutron::Subnet',NULL,72),(329,'f88b7df2-ea66-410f-bb18-941085fa7ea2','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:30:42',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-858033391','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(330,'0b2d01fa-b397-4197-b366-d27aaca3dbf0','f2e71c33-6e82-4cc3-887c-792b3fa2acfb','2026-02-19 09:30:42',NULL,'CREATE','COMPLETE','subnet','b057dd7a-1337-4073-8b27-122b20db7f12','state changed','OS::Neutron::Subnet',NULL,72),(331,'d279905c-29a5-4e6b-8f2a-362c034c0e40','f2e71c33-6e82-4cc3-887c-792b3fa2acfb','2026-02-19 09:30:42',NULL,'CREATE','COMPLETE','UpdateSubnetTest-1100360100','f2e71c33-6e82-4cc3-887c-792b3fa2acfb','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(332,'cf70d76f-51a8-4a45-8405-a06fb71f5c51','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:30:42',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-858033391-trunk_net_one-b5vbxfw2az52','state changed','OS::Neutron::Net',NULL,NULL),(333,'8e40e2a1-5eab-43f3-943b-3a0a05d1a545','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','2026-02-19 09:30:42',NULL,'CREATE','COMPLETE','server','5807a82d-b125-489c-8d66-776555e1f310','state changed','OS::Nova::Server',NULL,63),(334,'b5264618-32dc-4ee3-9a4e-40fb98914192','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','2026-02-19 09:30:43',NULL,'CREATE','COMPLETE','same_fixed_ip','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(335,'cb6dda66-3ef0-4298-9764-9a0b4d01fb1b','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:30:43',NULL,'CREATE','COMPLETE','trunk_net_one','9a972901-c4f8-41ab-a469-6a773d4526d1','state changed','OS::Neutron::Net',NULL,NULL),(336,'a88b578b-4c10-47af-810c-e71e8c9aa7a8','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:30:43',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-858033391-trunk_subnet_one-zn7cuqcnsqs6','state changed','OS::Neutron::Subnet',NULL,74),(337,'89d73790-7f64-4449-90fe-22ff7c84b21d','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:30:43',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-858033391-parent_net-57feuut3rplk','state changed','OS::Neutron::Net',NULL,NULL),(338,'24ef322f-60b2-47bf-b4fc-51da5663fcc5','f2e71c33-6e82-4cc3-887c-792b3fa2acfb','2026-02-19 09:30:44',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-1100360100','f2e71c33-6e82-4cc3-887c-792b3fa2acfb','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(339,'97a9cf0d-8ae8-4f21-9027-81a8af7f5463','f2e71c33-6e82-4cc3-887c-792b3fa2acfb','2026-02-19 09:30:44',NULL,'UPDATE','IN_PROGRESS','subnet','b057dd7a-1337-4073-8b27-122b20db7f12','state changed','OS::Neutron::Subnet',NULL,72),(340,'6c6598e3-7ac2-4710-b704-f7ad202a4231','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:30:44',NULL,'CREATE','COMPLETE','parent_net','6e7555c5-4cd8-4bf3-81cd-7e064d90ce10','state changed','OS::Neutron::Net',NULL,NULL),(341,'3466bab3-8f66-400a-93a2-602226196369','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:30:44',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-858033391-parent_subnet-7tedltaafqbw','state changed','OS::Neutron::Subnet',NULL,75),(342,'4abf5296-89c2-40c5-80c1-7b117f009963','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:30:44',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-858033391-trunk_net_two-eg7zu3efseer','state changed','OS::Neutron::Net',NULL,NULL),(343,'dfe9a33f-239d-4d23-8737-86e7977d4a54','f2e71c33-6e82-4cc3-887c-792b3fa2acfb','2026-02-19 09:30:45',NULL,'UPDATE','COMPLETE','subnet','b057dd7a-1337-4073-8b27-122b20db7f12','state changed','OS::Neutron::Subnet',NULL,77),(344,'0abbe717-7dde-4c71-b6bd-2cd6de1e28f7','f2e71c33-6e82-4cc3-887c-792b3fa2acfb','2026-02-19 09:30:45',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-1100360100','f2e71c33-6e82-4cc3-887c-792b3fa2acfb','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(345,'9b227d65-234d-4532-b132-4fb3f5ca1f41','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:30:45',NULL,'CREATE','COMPLETE','trunk_subnet_one','f9777f34-317c-47a7-a2fa-24f6d1afcbc9','state changed','OS::Neutron::Subnet',NULL,74),(346,'13016729-ea7b-48a8-968d-f18f5d6f35a4','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:30:45',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-858033391-sub_port_one-vtvphnfpuafr','state changed','OS::Neutron::Port',NULL,78),(347,'61a5aa78-f61d-4eeb-bb67-d3e6c9697f00','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:30:45',NULL,'CREATE','COMPLETE','trunk_net_two','54ca7c22-baf7-45c7-bc91-8b7d6b51a77f','state changed','OS::Neutron::Net',NULL,NULL),(348,'0b5dd569-cc4d-4437-b781-4bc15b3fd47d','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:30:46',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-858033391-trunk_subnet_two-oyhnxifay52q','state changed','OS::Neutron::Subnet',NULL,79),(349,'4190bf0e-9991-4d58-9c00-a2256791010d','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','2026-02-19 09:30:46',NULL,'UPDATE','IN_PROGRESS','same_fixed_ip','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(350,'01bd74fe-8a13-4b05-b99c-add29baa4c02','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','2026-02-19 09:30:46',NULL,'UPDATE','IN_PROGRESS','server','5807a82d-b125-489c-8d66-776555e1f310','state changed','OS::Nova::Server',NULL,63),(351,'ae2327cd-a04f-4fba-b547-63ee2b1d5079','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:30:46',NULL,'CREATE','COMPLETE','parent_subnet','cef2212e-ee4d-4ce6-944b-453ea82489f5','state changed','OS::Neutron::Subnet',NULL,75),(352,'0fdadc8c-1cfb-4644-9fc7-72f8412eb7ec','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:30:46',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-858033391-parent_port-5g2g7lqfvo67','state changed','OS::Neutron::Port',NULL,80),(353,'a2d57f22-313f-4b05-a162-0364458acbf6','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:30:47',NULL,'CREATE','COMPLETE','sub_port_one','0c0d4a40-f969-4e21-8f7b-a04e0db01748','state changed','OS::Neutron::Port',NULL,78),(354,'aa50e43f-95ab-4fcf-a103-65ff65d386ea','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:30:47',NULL,'CREATE','COMPLETE','trunk_subnet_two','fd7b7b40-4c76-41da-ac18-d072229910ce','state changed','OS::Neutron::Subnet',NULL,79),(355,'a52b74ee-935d-4d44-aefc-dbb09c2be4d1','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:30:47',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-858033391-sub_port_two-szvq4ruone3g','state changed','OS::Neutron::Port',NULL,81),(356,'6492fcfe-28f6-47e5-a8df-7f5e1e8b7ed2','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:30:48',NULL,'CREATE','COMPLETE','parent_port','dbe99737-74ad-43fe-9c19-925a04728f12','state changed','OS::Neutron::Port',NULL,80),(357,'b038e7fb-19ec-4569-b926-afabc0250f67','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:30:48',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-858033391-trunk-lp6c6yhlfqpz','state changed','OS::Neutron::Trunk',NULL,82),(358,'5f9060ee-4473-486e-abd2-008e297af0e6','f2e71c33-6e82-4cc3-887c-792b3fa2acfb','2026-02-19 09:30:49',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-1100360100','f2e71c33-6e82-4cc3-887c-792b3fa2acfb','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(359,'fff580d7-f12c-4724-b2c1-5ccb684ca7d8','f2e71c33-6e82-4cc3-887c-792b3fa2acfb','2026-02-19 09:30:50',NULL,'DELETE','IN_PROGRESS','subnet','b057dd7a-1337-4073-8b27-122b20db7f12','state changed','OS::Neutron::Subnet',NULL,77),(360,'47d10e7d-5d20-4963-9bc0-7797ea35bcd0','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:30:50',NULL,'CREATE','COMPLETE','sub_port_two','742680cf-ff8a-4908-84a9-b0cb69720b85','state changed','OS::Neutron::Port',NULL,81),(361,'96a9c389-32b0-4472-93d9-bb282998b306','6bd86a81-afb8-46ea-a818-b15647fc62fa','2026-02-19 09:30:50',NULL,'CREATE','COMPLETE','server','8a8595e7-5ab1-42e1-8a9a-dff440eafb3d','state changed','OS::Nova::Server',NULL,71),(362,'16d6aa48-b15e-4f0c-b6a3-7e0df4d81ca0','6bd86a81-afb8-46ea-a818-b15647fc62fa','2026-02-19 09:30:50',NULL,'CREATE','COMPLETE','server_with_port','6bd86a81-afb8-46ea-a818-b15647fc62fa','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(363,'3960e212-941f-49c5-ae7b-baa042810ff0','f2e71c33-6e82-4cc3-887c-792b3fa2acfb','2026-02-19 09:30:51',NULL,'DELETE','COMPLETE','subnet','b057dd7a-1337-4073-8b27-122b20db7f12','state changed','OS::Neutron::Subnet',NULL,77),(364,'9f7f45de-ac4c-40f2-9ac8-ad7d0c77ceb9','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','2026-02-19 09:30:51',NULL,'UPDATE','COMPLETE','server','5807a82d-b125-489c-8d66-776555e1f310','state changed','OS::Nova::Server',NULL,84),(365,'8f969cc7-31ba-471a-ba0f-f136c31b5ea0','f2e71c33-6e82-4cc3-887c-792b3fa2acfb','2026-02-19 09:30:52',NULL,'DELETE','IN_PROGRESS','net','c7cd1c81-f22a-4851-9190-e037e1e65f02','state changed','OS::Neutron::Net',NULL,NULL),(366,'7c0b3c91-87af-4364-a481-16de0aaea166','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:30:52',NULL,'CREATE','COMPLETE','trunk','5b7dd5e0-aaba-48ba-9da4-1ec23440eb6b','state changed','OS::Neutron::Trunk',NULL,82),(367,'b26c1718-e058-4f5a-b4d9-151fbf8e6bc6','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:30:52',NULL,'CREATE','COMPLETE','UpdateTrunkTest-858033391','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(368,'a3fa00ac-1aec-4f79-a4ed-f2590efe7f12','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','2026-02-19 09:30:52',NULL,'UPDATE','COMPLETE','same_fixed_ip','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(369,'a2edbb68-e858-48d7-8b63-9d41de7bc1d6','f2e71c33-6e82-4cc3-887c-792b3fa2acfb','2026-02-19 09:30:52',NULL,'DELETE','COMPLETE','net','c7cd1c81-f22a-4851-9190-e037e1e65f02','state changed','OS::Neutron::Net',NULL,NULL),(370,'b292faa6-71c0-446e-9ed3-18be8323fefb','f2e71c33-6e82-4cc3-887c-792b3fa2acfb','2026-02-19 09:30:52',NULL,'DELETE','COMPLETE','UpdateSubnetTest-1100360100','f2e71c33-6e82-4cc3-887c-792b3fa2acfb','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(371,'c2340cd0-8fbf-4e32-85a5-2e5f968f6f77','6bd86a81-afb8-46ea-a818-b15647fc62fa','2026-02-19 09:30:58',NULL,'DELETE','IN_PROGRESS','server_with_port','6bd86a81-afb8-46ea-a818-b15647fc62fa','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(372,'ad9d63a4-d719-4024-b017-95da448c35fa','6bd86a81-afb8-46ea-a818-b15647fc62fa','2026-02-19 09:30:58',NULL,'DELETE','IN_PROGRESS','server','8a8595e7-5ab1-42e1-8a9a-dff440eafb3d','state changed','OS::Nova::Server',NULL,71),(373,'00731ddd-69e2-4a12-9583-d1f72006b7f2','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:30:58',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-858033391','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(374,'c4f6f7e1-f742-4b42-9aac-9db0e7e6fc81','31b6a150-764e-4f4d-a7bb-2e2257018426','2026-02-19 09:30:58',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-502651509','31b6a150-764e-4f4d-a7bb-2e2257018426','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(375,'43452c5b-be83-4839-8953-c0e4a272c433','31b6a150-764e-4f4d-a7bb-2e2257018426','2026-02-19 09:30:59',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-502651509-net-kf6qf6axxj3z','state changed','OS::Neutron::Net',NULL,NULL),(376,'e0f3c805-0316-4b10-a469-11ae604bfeb4','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','2026-02-19 09:31:00',NULL,'DELETE','IN_PROGRESS','same_fixed_ip','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(377,'ce6b674c-e937-4d45-98a2-f8421d3b44bd','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','2026-02-19 09:31:00',NULL,'DELETE','IN_PROGRESS','server','5807a82d-b125-489c-8d66-776555e1f310','state changed','OS::Nova::Server',NULL,84),(378,'5a66083c-1c27-45ff-b5ff-1f2d6ad6898b','31b6a150-764e-4f4d-a7bb-2e2257018426','2026-02-19 09:31:00',NULL,'CREATE','COMPLETE','net','9f07f690-aeb4-434b-8db3-f6dd3052fb7c','state changed','OS::Neutron::Net',NULL,NULL),(379,'4e1d3f8b-d8d4-44a2-9a5c-c7202bf023f9','31b6a150-764e-4f4d-a7bb-2e2257018426','2026-02-19 09:31:00',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-502651509-subnet-gpql5b5vq6q4','state changed','OS::Neutron::Subnet',NULL,86),(380,'5c1ec4f4-da7e-486f-bd15-1c7cb02f922d','6bd86a81-afb8-46ea-a818-b15647fc62fa','2026-02-19 09:31:01',NULL,'DELETE','COMPLETE','server','8a8595e7-5ab1-42e1-8a9a-dff440eafb3d','state changed','OS::Nova::Server',NULL,71),(381,'8a976a20-37b1-47e0-ac72-7a5a569a4fc9','6bd86a81-afb8-46ea-a818-b15647fc62fa','2026-02-19 09:31:01',NULL,'DELETE','IN_PROGRESS','port','4ee2933f-0452-4250-bee4-97ced09c50f1','state changed','OS::Neutron::Port',NULL,70),(382,'b4a32442-65f0-4054-b1d2-b75da28cb667','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:02',NULL,'UPDATE','IN_PROGRESS','trunk','5b7dd5e0-aaba-48ba-9da4-1ec23440eb6b','state changed','OS::Neutron::Trunk',NULL,82),(383,'06c649b4-dc28-41d2-a113-043c82d9526c','6bd86a81-afb8-46ea-a818-b15647fc62fa','2026-02-19 09:31:02',NULL,'DELETE','COMPLETE','port','4ee2933f-0452-4250-bee4-97ced09c50f1','state changed','OS::Neutron::Port',NULL,70),(384,'852fd296-595d-4247-aa8e-2b331c96e758','6bd86a81-afb8-46ea-a818-b15647fc62fa','2026-02-19 09:31:02',NULL,'DELETE','IN_PROGRESS','subnet','d46beca2-89cd-4c69-b425-8c9e2e1bbb9e','state changed','OS::Neutron::Subnet',NULL,67),(385,'59dd9c46-835a-4114-9b33-d9cba673246e','6bd86a81-afb8-46ea-a818-b15647fc62fa','2026-02-19 09:31:02',NULL,'DELETE','COMPLETE','subnet','d46beca2-89cd-4c69-b425-8c9e2e1bbb9e','state changed','OS::Neutron::Subnet',NULL,67),(386,'310e71a9-fcee-4666-8c80-457205ff7bf1','6bd86a81-afb8-46ea-a818-b15647fc62fa','2026-02-19 09:31:02',NULL,'DELETE','IN_PROGRESS','net','d3965991-db72-4e1f-85ce-4cc5d54834de','state changed','OS::Neutron::Net',NULL,66),(387,'47af4037-ff1e-4a60-9221-e602f00cc3ba','31b6a150-764e-4f4d-a7bb-2e2257018426','2026-02-19 09:31:03',NULL,'CREATE','COMPLETE','subnet','e669ec75-f84f-467e-be99-79e4e7a4e757','state changed','OS::Neutron::Subnet',NULL,86),(388,'2468460a-03d4-44ca-bf37-16559b1fe060','31b6a150-764e-4f4d-a7bb-2e2257018426','2026-02-19 09:31:03',NULL,'CREATE','COMPLETE','UpdateSubnetTest-502651509','31b6a150-764e-4f4d-a7bb-2e2257018426','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(389,'060b5402-e988-4607-a92a-aea5e76960e0','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:03',NULL,'UPDATE','COMPLETE','trunk','5b7dd5e0-aaba-48ba-9da4-1ec23440eb6b','state changed','OS::Neutron::Trunk',NULL,87),(390,'7f3c053a-d099-4120-82e3-d4b55c3e58ab','6bd86a81-afb8-46ea-a818-b15647fc62fa','2026-02-19 09:31:03',NULL,'DELETE','COMPLETE','net','d3965991-db72-4e1f-85ce-4cc5d54834de','state changed','OS::Neutron::Net',NULL,66),(391,'5d9ff821-55ae-4613-a992-374aad9066f6','6bd86a81-afb8-46ea-a818-b15647fc62fa','2026-02-19 09:31:03',NULL,'DELETE','COMPLETE','server_with_port','6bd86a81-afb8-46ea-a818-b15647fc62fa','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(392,'80a00426-e370-4da2-8a9a-90238296a997','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','2026-02-19 09:31:03',NULL,'DELETE','COMPLETE','server','5807a82d-b125-489c-8d66-776555e1f310','state changed','OS::Nova::Server',NULL,84),(393,'559374ce-fe56-4591-be66-d993eda4db74','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:03',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-858033391','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(394,'d4286346-38d9-4693-8a56-202699224d2e','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','2026-02-19 09:31:03',NULL,'DELETE','IN_PROGRESS','subnet','59ad7ea4-d005-4a1f-9f6b-c32a47840545','state changed','OS::Neutron::Subnet',NULL,61),(395,'bf10f38a-c031-4c97-accb-b5fca86e1060','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','2026-02-19 09:31:04',NULL,'DELETE','COMPLETE','subnet','59ad7ea4-d005-4a1f-9f6b-c32a47840545','state changed','OS::Neutron::Subnet',NULL,61),(396,'d8e14414-26ee-48b8-b705-9005fedbbfd6','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','2026-02-19 09:31:04',NULL,'DELETE','IN_PROGRESS','net','6b6fc2f7-d426-4acf-8b1f-e10c1ee0bd83','state changed','OS::Neutron::Net',NULL,60),(397,'669496cc-75f5-459c-bb85-e94b3c356745','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','2026-02-19 09:31:04',NULL,'DELETE','COMPLETE','net','6b6fc2f7-d426-4acf-8b1f-e10c1ee0bd83','state changed','OS::Neutron::Net',NULL,60),(398,'ed26f607-be59-4ac7-8116-b564aa5d80cc','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','2026-02-19 09:31:04',NULL,'DELETE','COMPLETE','same_fixed_ip','b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(399,'9156bd77-228c-4344-8c37-01f55625257e','31b6a150-764e-4f4d-a7bb-2e2257018426','2026-02-19 09:31:09',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-502651509','31b6a150-764e-4f4d-a7bb-2e2257018426','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(400,'93dca155-d015-46c0-a649-18375bca3e6f','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:09',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-858033391','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(401,'8622c9d3-4379-488c-9a31-f56c89d0d42a','31b6a150-764e-4f4d-a7bb-2e2257018426','2026-02-19 09:31:09',NULL,'UPDATE','IN_PROGRESS','subnet','e669ec75-f84f-467e-be99-79e4e7a4e757','state changed','OS::Neutron::Subnet',NULL,86),(402,'cfb7985e-5af2-40b5-8633-84b92a930fcf','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:10',NULL,'DELETE','IN_PROGRESS','sub_port_two','742680cf-ff8a-4908-84a9-b0cb69720b85','state changed','OS::Neutron::Port',NULL,81),(403,'41de8b3b-0b71-48e2-a8dc-2192dd6f404a','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:10',NULL,'DELETE','COMPLETE','sub_port_two','742680cf-ff8a-4908-84a9-b0cb69720b85','state changed','OS::Neutron::Port',NULL,81),(404,'de4d6129-590c-476f-b9b6-20b8cfc5060c','f7546ed3-d586-454f-94de-6aaeb0f311ce','2026-02-19 09:31:10',NULL,'CREATE','IN_PROGRESS','server_with_sub_ip','f7546ed3-d586-454f-94de-6aaeb0f311ce','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(405,'b9414927-26d9-4335-bcc2-53488034d180','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:10',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','fd7b7b40-4c76-41da-ac18-d072229910ce','state changed','OS::Neutron::Subnet',NULL,79),(406,'8d62b1c2-350e-47f5-9934-d03d476cf0e0','31b6a150-764e-4f4d-a7bb-2e2257018426','2026-02-19 09:31:10',NULL,'UPDATE','COMPLETE','subnet','e669ec75-f84f-467e-be99-79e4e7a4e757','state changed','OS::Neutron::Subnet',NULL,90),(407,'d522f69b-f881-4e48-ba9c-fa2d14a28171','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','2026-02-19 09:31:10',NULL,'CREATE','IN_PROGRESS','add_subnet','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(408,'a538c393-64a8-4180-ae16-c8b2fdb6853d','31b6a150-764e-4f4d-a7bb-2e2257018426','2026-02-19 09:31:10',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-502651509','31b6a150-764e-4f4d-a7bb-2e2257018426','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(409,'fa39adc5-d615-4c1f-9c25-c7f93412252f','f7546ed3-d586-454f-94de-6aaeb0f311ce','2026-02-19 09:31:10',NULL,'CREATE','IN_PROGRESS','net','server_with_sub_ip-net-iw56xncilbso','state changed','OS::Neutron::Net',NULL,91),(410,'7f3fee0e-80d8-46b4-bb56-f09c42991225','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','2026-02-19 09:31:10',NULL,'CREATE','IN_PROGRESS','net','add_subnet-net-l5if47iwwcnh','state changed','OS::Neutron::Net',NULL,92),(411,'c262e0ac-9d48-48a2-877f-5d95910923c8','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:11',NULL,'DELETE','IN_PROGRESS','sub_port_one','0c0d4a40-f969-4e21-8f7b-a04e0db01748','state changed','OS::Neutron::Port',NULL,78),(412,'cd43cc2a-af09-40f6-bd6d-55e324beaa8e','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:11',NULL,'DELETE','COMPLETE','trunk_subnet_two','fd7b7b40-4c76-41da-ac18-d072229910ce','state changed','OS::Neutron::Subnet',NULL,79),(413,'68723a7a-1efb-4287-8b8a-6c57239b833a','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:11',NULL,'DELETE','IN_PROGRESS','trunk_net_two','54ca7c22-baf7-45c7-bc91-8b7d6b51a77f','state changed','OS::Neutron::Net',NULL,NULL),(414,'5b7e7dd0-9cba-4322-ad9c-669130d2d6bc','f7546ed3-d586-454f-94de-6aaeb0f311ce','2026-02-19 09:31:11',NULL,'CREATE','IN_PROGRESS','security_group','server_with_sub_ip-security_group-ycvmvv7vpqot','state changed','OS::Neutron::SecurityGroup',NULL,93),(415,'0c18f61d-72f7-4a3c-a716-e0f017b70b0b','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:12',NULL,'DELETE','IN_PROGRESS','trunk','5b7dd5e0-aaba-48ba-9da4-1ec23440eb6b','state changed','OS::Neutron::Trunk',NULL,87),(416,'16474950-3baf-41a1-994e-a231c6643b75','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:12',NULL,'DELETE','COMPLETE','trunk','5b7dd5e0-aaba-48ba-9da4-1ec23440eb6b','state changed','OS::Neutron::Trunk',NULL,87),(417,'30ffe967-8a90-4fe1-9f45-b14e85f7264e','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:12',NULL,'DELETE','COMPLETE','sub_port_one','0c0d4a40-f969-4e21-8f7b-a04e0db01748','state changed','OS::Neutron::Port',NULL,78),(418,'60dd4448-808a-4ffc-8fe0-d7be54ddd9c9','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:12',NULL,'DELETE','IN_PROGRESS','parent_port','dbe99737-74ad-43fe-9c19-925a04728f12','state changed','OS::Neutron::Port',NULL,80),(419,'ffc6f162-7c7d-4c7c-a9b1-d63e35f776d7','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:12',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','f9777f34-317c-47a7-a2fa-24f6d1afcbc9','state changed','OS::Neutron::Subnet',NULL,74),(420,'592f2c35-034d-4307-96ac-2486cf87a07a','f7546ed3-d586-454f-94de-6aaeb0f311ce','2026-02-19 09:31:12',NULL,'CREATE','COMPLETE','net','7bfde64a-56fe-42d9-8513-03e68785e3c3','state changed','OS::Neutron::Net',NULL,91),(421,'db01caee-205a-4d44-aeab-23675f94f135','f7546ed3-d586-454f-94de-6aaeb0f311ce','2026-02-19 09:31:12',NULL,'CREATE','IN_PROGRESS','subnet','server_with_sub_ip-subnet-xvkulvl7p6gq','state changed','OS::Neutron::Subnet',NULL,94),(422,'eb56afb3-c304-4f2b-8172-2e3ff5b3f095','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','2026-02-19 09:31:12',NULL,'CREATE','COMPLETE','net','870477bf-2ce4-4f05-8ece-c8a7ce8af7d5','state changed','OS::Neutron::Net',NULL,92),(423,'a9a02662-1e78-4694-80ff-460f7d85d21e','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','2026-02-19 09:31:12',NULL,'CREATE','IN_PROGRESS','subnet','add_subnet-subnet-sck5cpwqxtxu','state changed','OS::Neutron::Subnet',NULL,95),(424,'d91749ee-b325-411e-8f28-9c5f89b9dbce','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:12',NULL,'DELETE','COMPLETE','trunk_net_two','54ca7c22-baf7-45c7-bc91-8b7d6b51a77f','state changed','OS::Neutron::Net',NULL,NULL),(425,'403cd225-8a05-48ff-ad1b-028fbd2698c4','f7546ed3-d586-454f-94de-6aaeb0f311ce','2026-02-19 09:31:12',NULL,'CREATE','COMPLETE','security_group','704c0be3-eae5-4441-8015-21602f90d2ca','state changed','OS::Neutron::SecurityGroup',NULL,93),(426,'58089742-e813-4f7b-ab62-12b7f681b338','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:13',NULL,'DELETE','COMPLETE','trunk_subnet_one','f9777f34-317c-47a7-a2fa-24f6d1afcbc9','state changed','OS::Neutron::Subnet',NULL,74),(427,'bee4b04e-8fb5-4421-9a4f-228688986704','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:13',NULL,'DELETE','IN_PROGRESS','trunk_net_one','9a972901-c4f8-41ab-a469-6a773d4526d1','state changed','OS::Neutron::Net',NULL,NULL),(428,'7a1c48ff-d037-4aab-baf5-9e5bb27a5e54','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:13',NULL,'DELETE','COMPLETE','parent_port','dbe99737-74ad-43fe-9c19-925a04728f12','state changed','OS::Neutron::Port',NULL,80),(429,'8bd62540-91c1-47c4-a29f-149b81148deb','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:14',NULL,'DELETE','IN_PROGRESS','parent_subnet','cef2212e-ee4d-4ce6-944b-453ea82489f5','state changed','OS::Neutron::Subnet',NULL,75),(430,'be4e7ed7-f758-4375-af07-e9cf9ccfc409','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:14',NULL,'DELETE','COMPLETE','trunk_net_one','9a972901-c4f8-41ab-a469-6a773d4526d1','state changed','OS::Neutron::Net',NULL,NULL),(431,'3f3ad66d-0c41-4394-af5e-432591213b70','31b6a150-764e-4f4d-a7bb-2e2257018426','2026-02-19 09:31:14',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-502651509','31b6a150-764e-4f4d-a7bb-2e2257018426','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(432,'a967a2da-b4b0-405b-b889-dba0c936a090','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:14',NULL,'DELETE','COMPLETE','parent_subnet','cef2212e-ee4d-4ce6-944b-453ea82489f5','state changed','OS::Neutron::Subnet',NULL,75),(433,'311887b9-1d05-483e-95b3-cf5b84df3bcb','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:15',NULL,'DELETE','IN_PROGRESS','parent_net','6e7555c5-4cd8-4bf3-81cd-7e064d90ce10','state changed','OS::Neutron::Net',NULL,NULL),(434,'7a29d410-1e4c-4d45-850e-950b7811be28','31b6a150-764e-4f4d-a7bb-2e2257018426','2026-02-19 09:31:15',NULL,'DELETE','IN_PROGRESS','subnet','e669ec75-f84f-467e-be99-79e4e7a4e757','state changed','OS::Neutron::Subnet',NULL,90),(435,'adb691c7-0ead-4bd7-af93-8402091dbe76','f7546ed3-d586-454f-94de-6aaeb0f311ce','2026-02-19 09:31:16',NULL,'CREATE','COMPLETE','subnet','eb623eec-c298-4cc7-a178-138c3739db1d','state changed','OS::Neutron::Subnet',NULL,94),(436,'eafeecfd-03df-42f8-b210-f08ddd1069a7','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','2026-02-19 09:31:16',NULL,'CREATE','COMPLETE','subnet','7ad77ec4-1ef2-4641-aaf0-abe5d4b155f2','state changed','OS::Neutron::Subnet',NULL,95),(437,'e6b2b680-0e59-4141-9ccd-68d662e80685','f7546ed3-d586-454f-94de-6aaeb0f311ce','2026-02-19 09:31:16',NULL,'CREATE','IN_PROGRESS','server','server_with_sub_ip-server-j7bcblerk6di','state changed','OS::Nova::Server',NULL,97),(438,'fc0e581a-6ce7-425f-bd42-0d9db9b149ba','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','2026-02-19 09:31:16',NULL,'CREATE','IN_PROGRESS','server','add_subnet-server-a4m2bw7upd52','state changed','OS::Nova::Server',NULL,98),(439,'3c3da998-c999-4998-9d3c-71de1f0f24cd','31b6a150-764e-4f4d-a7bb-2e2257018426','2026-02-19 09:31:16',NULL,'DELETE','COMPLETE','subnet','e669ec75-f84f-467e-be99-79e4e7a4e757','state changed','OS::Neutron::Subnet',NULL,90),(440,'d3e0a2bc-5db3-4dba-8995-1de8878c3e2e','31b6a150-764e-4f4d-a7bb-2e2257018426','2026-02-19 09:31:16',NULL,'DELETE','IN_PROGRESS','net','9f07f690-aeb4-434b-8db3-f6dd3052fb7c','state changed','OS::Neutron::Net',NULL,NULL),(441,'6e9b0147-0015-42f4-82a0-49e21cb5e415','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:16',NULL,'DELETE','COMPLETE','parent_net','6e7555c5-4cd8-4bf3-81cd-7e064d90ce10','state changed','OS::Neutron::Net',NULL,NULL),(442,'5ae4cc75-a7e8-4c7b-b82c-d9a5fb6a066e','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:31:16',NULL,'DELETE','COMPLETE','UpdateTrunkTest-858033391','92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(443,'9a193a3a-b388-4301-9bef-f357f0843aba','31b6a150-764e-4f4d-a7bb-2e2257018426','2026-02-19 09:31:17',NULL,'DELETE','COMPLETE','net','9f07f690-aeb4-434b-8db3-f6dd3052fb7c','state changed','OS::Neutron::Net',NULL,NULL),(444,'dec65b5f-4148-43fb-a443-6bc36fab1fd8','31b6a150-764e-4f4d-a7bb-2e2257018426','2026-02-19 09:31:17',NULL,'DELETE','COMPLETE','UpdateSubnetTest-502651509','31b6a150-764e-4f4d-a7bb-2e2257018426','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(445,'67a8d97f-cd70-4c77-93eb-e11eb9838bfd','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:20',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-1757635903','a500cc63-f05a-4887-9edb-ad51b4523a54','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(446,'6d4e7afb-bce1-4538-9b6e-d724b35c34fe','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:20',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-1757635903-trunk_net_one-jivguu4abton','state changed','OS::Neutron::Net',NULL,NULL),(447,'b03a65e5-a5de-43ae-9d3b-4ca22e27c714','2fd08ce8-a5d1-401d-b36c-26c15a3c46ec','2026-02-19 09:31:21',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-1182422141','2fd08ce8-a5d1-401d-b36c-26c15a3c46ec','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(448,'f8a96d7d-d29e-42e8-9566-f2a5d0a25d70','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:21',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-1757635903-parent_net-xp2hyx47lrnx','state changed','OS::Neutron::Net',NULL,NULL),(449,'e12684ef-0ca8-44d5-a517-a4e7b9f214f5','2fd08ce8-a5d1-401d-b36c-26c15a3c46ec','2026-02-19 09:31:21',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-1182422141-net-q3bfdqttbbjc','state changed','OS::Neutron::Net',NULL,NULL),(450,'37a90f7d-4acb-487c-924a-ff293847d900','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:22',NULL,'CREATE','COMPLETE','trunk_net_one','c6e30417-9a3a-4c74-a16d-5dd354e75e00','state changed','OS::Neutron::Net',NULL,NULL),(451,'893dea9a-4f21-4479-b8cd-2f0df3fb00ec','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:22',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-1757635903-trunk_subnet_one-7k2qqijmemx5','state changed','OS::Neutron::Subnet',NULL,99),(452,'a12f0e97-fe77-4f70-adae-e22d205794c4','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:22',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-1757635903-trunk_net_two-phhk53qj3kks','state changed','OS::Neutron::Net',NULL,NULL),(453,'c37ebc69-534a-4505-a5de-b1a877287a7d','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:23',NULL,'CREATE','COMPLETE','parent_net','1ddae126-c1b8-4742-af18-9f351d597fdf','state changed','OS::Neutron::Net',NULL,NULL),(454,'f01f9001-40a1-455b-9310-6ddd52f649b5','2fd08ce8-a5d1-401d-b36c-26c15a3c46ec','2026-02-19 09:31:23',NULL,'CREATE','COMPLETE','net','4f6f1151-cce4-4948-bcb1-f1ef37798a49','state changed','OS::Neutron::Net',NULL,NULL),(455,'27ecf300-2d91-4e53-a0b1-a21b489188a0','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:23',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-1757635903-parent_subnet-uk2jumgyex4s','state changed','OS::Neutron::Subnet',NULL,100),(456,'0bf2c124-d078-4c51-bad7-4bbdbbde5a2e','2fd08ce8-a5d1-401d-b36c-26c15a3c46ec','2026-02-19 09:31:23',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-1182422141-subnet-r44vnqwu3on7','state changed','OS::Neutron::Subnet',NULL,101),(457,'e26bbb4e-800b-4a8b-9496-05afd8e11a52','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:24',NULL,'CREATE','COMPLETE','trunk_net_two','e8debed6-4f2e-4ae4-a6fc-6d4fa63a8fe3','state changed','OS::Neutron::Net',NULL,NULL),(458,'78bdc66e-6f15-4739-991c-db618e833dfd','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:24',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-1757635903-trunk_subnet_two-k4xw7wjbnjue','state changed','OS::Neutron::Subnet',NULL,102),(459,'8b849ccc-f339-4ef1-a9e0-878cfad7e605','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:24',NULL,'CREATE','COMPLETE','trunk_subnet_one','101e3461-0074-4607-8e4d-bb484b1c9c31','state changed','OS::Neutron::Subnet',NULL,99),(460,'42b9fc01-c25b-49a8-a0e8-9a388b58196f','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:24',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-1757635903-sub_port_one-ijstedm6d7t6','state changed','OS::Neutron::Port',NULL,103),(461,'4d1d4d95-0ca1-4655-ba33-a4b253f1923e','2fd08ce8-a5d1-401d-b36c-26c15a3c46ec','2026-02-19 09:31:25',NULL,'CREATE','COMPLETE','subnet','b24a5255-6f89-498c-88e5-c0cb6b024ae8','state changed','OS::Neutron::Subnet',NULL,101),(462,'a0bd4bf4-5c11-4678-8e89-47a1581efb67','2fd08ce8-a5d1-401d-b36c-26c15a3c46ec','2026-02-19 09:31:25',NULL,'CREATE','COMPLETE','UpdateSubnetTest-1182422141','2fd08ce8-a5d1-401d-b36c-26c15a3c46ec','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(463,'98f65f07-57f7-41fa-b4df-7bd77563ad79','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:25',NULL,'CREATE','COMPLETE','parent_subnet','0367095d-eebe-4908-8ede-a078767c6f4b','state changed','OS::Neutron::Subnet',NULL,100),(464,'a6f29914-262b-453f-aa67-0db3c592dd40','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:25',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-1757635903-parent_port-6tegae6w7fp7','state changed','OS::Neutron::Port',NULL,104),(465,'025cfb66-1c89-4e5d-9edd-b1c4328e4dc7','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:26',NULL,'CREATE','COMPLETE','sub_port_one','94f7c2ef-87f9-4778-a307-4c660255a0c0','state changed','OS::Neutron::Port',NULL,103),(466,'630888f8-e9dc-4d9d-927e-fd84b139e0a6','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:26',NULL,'CREATE','COMPLETE','parent_port','c201661c-6cd6-4de3-af15-aaddcd44d6c4','state changed','OS::Neutron::Port',NULL,104),(467,'9bdfbd76-3580-4bb4-8d10-e7a080e532fc','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:26',NULL,'CREATE','COMPLETE','trunk_subnet_two','a4e94b06-16b8-4946-b649-dd53b632d2be','state changed','OS::Neutron::Subnet',NULL,102),(468,'0361c16a-105c-4fe5-a667-8ed7d98ffb2d','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:26',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-1757635903-sub_port_two-7jzqxnpbcndx','state changed','OS::Neutron::Port',NULL,105),(469,'c8721e64-51dc-4ce1-bdf5-61bfacacee13','2fd08ce8-a5d1-401d-b36c-26c15a3c46ec','2026-02-19 09:31:27',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-1182422141','2fd08ce8-a5d1-401d-b36c-26c15a3c46ec','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(470,'ddc07c0c-a840-421c-aac8-453feecad157','2fd08ce8-a5d1-401d-b36c-26c15a3c46ec','2026-02-19 09:31:27',NULL,'UPDATE','IN_PROGRESS','subnet','b24a5255-6f89-498c-88e5-c0cb6b024ae8','state changed','OS::Neutron::Subnet',NULL,101),(471,'eb486036-ce0e-4280-912f-404a552263d7','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:27',NULL,'CREATE','COMPLETE','sub_port_two','41795aca-0917-46c6-a14e-f2e14e78756b','state changed','OS::Neutron::Port',NULL,105),(472,'ff2c7dc1-1ea5-422f-9de0-083118f9276c','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:27',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-1757635903-trunk-uypnxlzeuihr','state changed','OS::Neutron::Trunk',NULL,107),(473,'01193d66-3b46-47be-a4c6-b9da38e948e7','2fd08ce8-a5d1-401d-b36c-26c15a3c46ec','2026-02-19 09:31:28',NULL,'UPDATE','COMPLETE','subnet','b24a5255-6f89-498c-88e5-c0cb6b024ae8','state changed','OS::Neutron::Subnet',NULL,108),(474,'c55ea5a8-4a4a-462e-bc43-32f9c3ee0b6d','2fd08ce8-a5d1-401d-b36c-26c15a3c46ec','2026-02-19 09:31:28',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-1182422141','2fd08ce8-a5d1-401d-b36c-26c15a3c46ec','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(475,'e7d97420-b4ed-46fb-806c-2ac0183df59c','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','2026-02-19 09:31:28',NULL,'CREATE','COMPLETE','server','09495ff3-9c41-4cd6-a850-d174c43e2f22','state changed','OS::Nova::Server',NULL,98),(476,'b1ea48ce-a550-4e71-8f78-50b68628028b','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','2026-02-19 09:31:29',NULL,'CREATE','COMPLETE','add_subnet','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(477,'0ac3e1e0-60ae-422f-b325-8f2c0f96ff24','f7546ed3-d586-454f-94de-6aaeb0f311ce','2026-02-19 09:31:30',NULL,'CREATE','COMPLETE','server','68d32da3-a9b0-4e78-a2ca-8e684e4fc246','state changed','OS::Nova::Server',NULL,97),(478,'4fc9457d-49d8-4b1e-b95f-97278531d014','f7546ed3-d586-454f-94de-6aaeb0f311ce','2026-02-19 09:31:30',NULL,'CREATE','COMPLETE','server_with_sub_ip','f7546ed3-d586-454f-94de-6aaeb0f311ce','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(479,'2367d879-7163-4014-8553-afd9f8ba4c0f','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:30',NULL,'CREATE','COMPLETE','trunk','382c8141-accb-4e07-b914-aaf549cd4c54','state changed','OS::Neutron::Trunk',NULL,107),(480,'5b4dfac2-c4f3-4925-bfa2-a366329a7a13','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:30',NULL,'CREATE','COMPLETE','UpdateTrunkTest-1757635903','a500cc63-f05a-4887-9edb-ad51b4523a54','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(481,'1c0d35b7-9561-46a5-b987-5316c6bafd39','2fd08ce8-a5d1-401d-b36c-26c15a3c46ec','2026-02-19 09:31:31',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-1182422141','2fd08ce8-a5d1-401d-b36c-26c15a3c46ec','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(482,'e9f4cba4-aa91-4a1d-b5c9-5da3e5bfe185','2fd08ce8-a5d1-401d-b36c-26c15a3c46ec','2026-02-19 09:31:32',NULL,'DELETE','IN_PROGRESS','subnet','b24a5255-6f89-498c-88e5-c0cb6b024ae8','state changed','OS::Neutron::Subnet',NULL,108),(483,'8e02d1fc-95ca-4611-aa0c-be0c1e3c8b91','2fd08ce8-a5d1-401d-b36c-26c15a3c46ec','2026-02-19 09:31:32',NULL,'DELETE','COMPLETE','subnet','b24a5255-6f89-498c-88e5-c0cb6b024ae8','state changed','OS::Neutron::Subnet',NULL,108),(484,'21c0ea68-efe5-483e-8b70-6ab5cd5b19c8','2fd08ce8-a5d1-401d-b36c-26c15a3c46ec','2026-02-19 09:31:32',NULL,'DELETE','IN_PROGRESS','net','4f6f1151-cce4-4948-bcb1-f1ef37798a49','state changed','OS::Neutron::Net',NULL,NULL),(485,'33cae9f0-0d51-4bc9-a16f-dd531a20e6a4','2fd08ce8-a5d1-401d-b36c-26c15a3c46ec','2026-02-19 09:31:33',NULL,'DELETE','COMPLETE','net','4f6f1151-cce4-4948-bcb1-f1ef37798a49','state changed','OS::Neutron::Net',NULL,NULL),(486,'a36650d2-fbfa-40ae-81b5-c0c78530cc27','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:33',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-1757635903','a500cc63-f05a-4887-9edb-ad51b4523a54','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(487,'a439a717-bc7d-4b4b-a4e0-0437f79d6711','2fd08ce8-a5d1-401d-b36c-26c15a3c46ec','2026-02-19 09:31:33',NULL,'DELETE','COMPLETE','UpdateSubnetTest-1182422141','2fd08ce8-a5d1-401d-b36c-26c15a3c46ec','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(488,'55bad556-55a1-4642-ad3c-94a2b996d9b6','f7546ed3-d586-454f-94de-6aaeb0f311ce','2026-02-19 09:31:34',NULL,'DELETE','IN_PROGRESS','server_with_sub_ip','f7546ed3-d586-454f-94de-6aaeb0f311ce','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(489,'672d15c7-2b04-48bd-91c3-9503ae366289','f7546ed3-d586-454f-94de-6aaeb0f311ce','2026-02-19 09:31:34',NULL,'DELETE','IN_PROGRESS','server','68d32da3-a9b0-4e78-a2ca-8e684e4fc246','state changed','OS::Nova::Server',NULL,97),(490,'d723bd0b-d241-4d73-8d91-303b9e22a345','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','2026-02-19 09:31:34',NULL,'UPDATE','IN_PROGRESS','add_subnet','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(491,'9548c64a-7fc3-4a4d-997a-c2485841d10a','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','2026-02-19 09:31:35',NULL,'UPDATE','IN_PROGRESS','server','09495ff3-9c41-4cd6-a850-d174c43e2f22','state changed','OS::Nova::Server',NULL,98),(492,'49e6db4b-8128-4f30-a076-277c37649328','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:37',NULL,'UPDATE','IN_PROGRESS','trunk','382c8141-accb-4e07-b914-aaf549cd4c54','state changed','OS::Neutron::Trunk',NULL,107),(493,'787cf4b4-236e-4a16-a2fb-2052209c0889','f7546ed3-d586-454f-94de-6aaeb0f311ce','2026-02-19 09:31:38',NULL,'DELETE','COMPLETE','server','68d32da3-a9b0-4e78-a2ca-8e684e4fc246','state changed','OS::Nova::Server',NULL,97),(494,'0859da1f-18a3-47b2-83d4-12ea02a893fc','5da86ba1-1131-4371-9678-174588891d52','2026-02-19 09:31:38',NULL,'CREATE','IN_PROGRESS','EncryptedParametersTest-1466683732','5da86ba1-1131-4371-9678-174588891d52','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(495,'354c6b5c-c037-43ad-a54f-b0dab3cfa987','f7546ed3-d586-454f-94de-6aaeb0f311ce','2026-02-19 09:31:38',NULL,'DELETE','IN_PROGRESS','security_group','704c0be3-eae5-4441-8015-21602f90d2ca','state changed','OS::Neutron::SecurityGroup',NULL,93),(496,'40167d70-b245-4da4-83f9-bb511a889623','f7546ed3-d586-454f-94de-6aaeb0f311ce','2026-02-19 09:31:38',NULL,'DELETE','IN_PROGRESS','subnet','eb623eec-c298-4cc7-a178-138c3739db1d','state changed','OS::Neutron::Subnet',NULL,94),(497,'c54335e1-97d6-417e-b300-03fe404a8a7b','5da86ba1-1131-4371-9678-174588891d52','2026-02-19 09:31:38',NULL,'CREATE','IN_PROGRESS','server_with_encrypted_property','En-683732-server_with_encrypted_property-mey5lu4wa7ts','state changed','OS::Nova::Server',NULL,112),(498,'ad8a6077-00c0-499f-830b-c4b32177667c','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','2026-02-19 09:31:38',NULL,'UPDATE','COMPLETE','server','09495ff3-9c41-4cd6-a850-d174c43e2f22','state changed','OS::Nova::Server',NULL,113),(499,'5f5e724f-04d6-4109-a504-925092225226','f7546ed3-d586-454f-94de-6aaeb0f311ce','2026-02-19 09:31:38',NULL,'DELETE','COMPLETE','subnet','eb623eec-c298-4cc7-a178-138c3739db1d','state changed','OS::Neutron::Subnet',NULL,94),(500,'66106245-879c-4de7-b89f-f5ca594b4d01','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','2026-02-19 09:31:38',NULL,'UPDATE','COMPLETE','add_subnet','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(501,'6a8fe5b8-8ca0-41f2-9d9e-1db1ceba9646','f7546ed3-d586-454f-94de-6aaeb0f311ce','2026-02-19 09:31:38',NULL,'DELETE','IN_PROGRESS','net','7bfde64a-56fe-42d9-8513-03e68785e3c3','state changed','OS::Neutron::Net',NULL,91),(502,'6d27620a-e9d4-47e4-ade9-2c6bfacbfc7f','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:39',NULL,'UPDATE','COMPLETE','trunk','382c8141-accb-4e07-b914-aaf549cd4c54','state changed','OS::Neutron::Trunk',NULL,114),(503,'a004b537-c512-4b60-ab1e-2752bb97173c','f7546ed3-d586-454f-94de-6aaeb0f311ce','2026-02-19 09:31:39',NULL,'DELETE','COMPLETE','net','7bfde64a-56fe-42d9-8513-03e68785e3c3','state changed','OS::Neutron::Net',NULL,91),(504,'30fe0464-9c3b-48c8-95de-9683ff8fdb06','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:40',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-1757635903','a500cc63-f05a-4887-9edb-ad51b4523a54','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(505,'20f03522-9128-434e-82a2-d7b9b34c770d','f7546ed3-d586-454f-94de-6aaeb0f311ce','2026-02-19 09:31:40',NULL,'DELETE','COMPLETE','security_group','704c0be3-eae5-4441-8015-21602f90d2ca','state changed','OS::Neutron::SecurityGroup',NULL,93),(506,'5504b0d2-b434-40d6-ad9a-0fa87a2055a7','f7546ed3-d586-454f-94de-6aaeb0f311ce','2026-02-19 09:31:40',NULL,'DELETE','COMPLETE','server_with_sub_ip','f7546ed3-d586-454f-94de-6aaeb0f311ce','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(507,'03480527-1064-47ab-bbcb-a0a66557c719','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','2026-02-19 09:31:43',NULL,'DELETE','IN_PROGRESS','add_subnet','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(508,'f18f48fd-1270-42cf-9892-43c18249476f','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','2026-02-19 09:31:43',NULL,'DELETE','IN_PROGRESS','server','09495ff3-9c41-4cd6-a850-d174c43e2f22','state changed','OS::Nova::Server',NULL,113),(509,'341218cc-40c4-4717-a251-9e1970851614','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:43',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-1757635903','a500cc63-f05a-4887-9edb-ad51b4523a54','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(510,'36466b82-36ce-4a7d-86bb-dc693c08db87','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:44',NULL,'DELETE','IN_PROGRESS','sub_port_two','41795aca-0917-46c6-a14e-f2e14e78756b','state changed','OS::Neutron::Port',NULL,105),(511,'9cd78841-6ba5-4e25-922d-93b8e115be44','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:45',NULL,'DELETE','COMPLETE','sub_port_two','41795aca-0917-46c6-a14e-f2e14e78756b','state changed','OS::Neutron::Port',NULL,105),(512,'47d812ff-f74e-46e0-89b2-e670e49a0bb7','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:45',NULL,'DELETE','IN_PROGRESS','trunk','382c8141-accb-4e07-b914-aaf549cd4c54','state changed','OS::Neutron::Trunk',NULL,114),(513,'ad25d125-c22a-426e-8252-4e537cdf6ecf','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:45',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','a4e94b06-16b8-4946-b649-dd53b632d2be','state changed','OS::Neutron::Subnet',NULL,102),(514,'61a4c7f9-86d6-4940-9ca6-4c7f37671385','dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:31:45',NULL,'CREATE','IN_PROGRESS','create_server_with_sub_ip','dcecf177-9a5d-42ec-8995-39a797c82f48','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(515,'76c84721-1906-4557-b251-85a4b78107ba','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','2026-02-19 09:31:46',NULL,'DELETE','COMPLETE','server','09495ff3-9c41-4cd6-a850-d174c43e2f22','state changed','OS::Nova::Server',NULL,113),(516,'ef548ca7-a167-4812-ac4a-1b4620fe53d4','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:46',NULL,'DELETE','COMPLETE','trunk','382c8141-accb-4e07-b914-aaf549cd4c54','state changed','OS::Neutron::Trunk',NULL,114),(517,'475667df-066e-4843-b4b3-e47d1aa1042e','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:46',NULL,'DELETE','IN_PROGRESS','parent_port','c201661c-6cd6-4de3-af15-aaddcd44d6c4','state changed','OS::Neutron::Port',NULL,104),(518,'03068f37-3033-4eb2-8543-e849d91011e1','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','2026-02-19 09:31:46',NULL,'DELETE','IN_PROGRESS','subnet','7ad77ec4-1ef2-4641-aaf0-abe5d4b155f2','state changed','OS::Neutron::Subnet',NULL,95),(519,'cac115b9-b317-4faf-8a03-525deacb2e38','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:46',NULL,'DELETE','IN_PROGRESS','sub_port_one','94f7c2ef-87f9-4778-a307-4c660255a0c0','state changed','OS::Neutron::Port',NULL,103),(520,'c5d6f04e-a8f9-4358-84a9-5c05a7890a2b','dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:31:46',NULL,'CREATE','IN_PROGRESS','net','create_server_with_sub_ip-net-btc6h2xtjnwe','state changed','OS::Neutron::Net',NULL,117),(521,'42810d10-07f8-41de-ad23-3b949f85a91d','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:46',NULL,'DELETE','COMPLETE','trunk_subnet_two','a4e94b06-16b8-4946-b649-dd53b632d2be','state changed','OS::Neutron::Subnet',NULL,102),(522,'2ba09bfd-3478-47af-8fb8-d6bfe44a91c5','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:46',NULL,'DELETE','IN_PROGRESS','trunk_net_two','e8debed6-4f2e-4ae4-a6fc-6d4fa63a8fe3','state changed','OS::Neutron::Net',NULL,NULL),(523,'3ecd314e-f4ad-414e-a84b-ad6b73fdcd97','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','2026-02-19 09:31:46',NULL,'DELETE','COMPLETE','subnet','7ad77ec4-1ef2-4641-aaf0-abe5d4b155f2','state changed','OS::Neutron::Subnet',NULL,95),(524,'41c9185a-ddfa-442d-a218-5efa4015c914','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','2026-02-19 09:31:46',NULL,'DELETE','IN_PROGRESS','net','870477bf-2ce4-4f05-8ece-c8a7ce8af7d5','state changed','OS::Neutron::Net',NULL,92),(525,'a479f249-f0c7-49f5-b398-07b5489e73d0','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:47',NULL,'DELETE','COMPLETE','sub_port_one','94f7c2ef-87f9-4778-a307-4c660255a0c0','state changed','OS::Neutron::Port',NULL,103),(526,'04044497-edf6-40fa-b1a4-2d61b82f3576','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:47',NULL,'DELETE','COMPLETE','parent_port','c201661c-6cd6-4de3-af15-aaddcd44d6c4','state changed','OS::Neutron::Port',NULL,104),(527,'911eb7be-a0e4-4f11-8626-18d3394565b2','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:47',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','101e3461-0074-4607-8e4d-bb484b1c9c31','state changed','OS::Neutron::Subnet',NULL,99),(528,'e810e1f1-ad21-4a04-baee-fd040b6091e3','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:47',NULL,'DELETE','IN_PROGRESS','parent_subnet','0367095d-eebe-4908-8ede-a078767c6f4b','state changed','OS::Neutron::Subnet',NULL,100),(529,'174b017c-edc0-4c30-9910-c34c06568d22','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:47',NULL,'DELETE','COMPLETE','trunk_net_two','e8debed6-4f2e-4ae4-a6fc-6d4fa63a8fe3','state changed','OS::Neutron::Net',NULL,NULL),(530,'9e8fc021-6a78-46bb-aaf8-d73de7cc4a1e','dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:31:47',NULL,'CREATE','COMPLETE','net','142e7724-18ff-41de-99db-8890fdaf3355','state changed','OS::Neutron::Net',NULL,117),(531,'3269dae3-c605-489b-abb0-979591f7c713','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:47',NULL,'DELETE','COMPLETE','trunk_subnet_one','101e3461-0074-4607-8e4d-bb484b1c9c31','state changed','OS::Neutron::Subnet',NULL,99),(532,'85791bac-0852-4bfa-9055-3568a822cf11','dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:31:47',NULL,'CREATE','IN_PROGRESS','subnet_a','create_server_with_sub_ip-subnet_a-2fnw72w7ebo7','state changed','OS::Neutron::Subnet',NULL,118),(533,'6b029617-1634-4d9b-8c06-cee28a58bc8d','dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:31:47',NULL,'CREATE','IN_PROGRESS','subnet_b','create_server_with_sub_ip-subnet_b-6kn7fdbdpolm','state changed','OS::Neutron::Subnet',NULL,119),(534,'8dca00a3-e2ed-4bd7-926b-96ca88fcb676','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:47',NULL,'DELETE','IN_PROGRESS','trunk_net_one','c6e30417-9a3a-4c74-a16d-5dd354e75e00','state changed','OS::Neutron::Net',NULL,NULL),(535,'22361ce5-de98-48d3-9c12-85a92d951ebc','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:48',NULL,'DELETE','COMPLETE','parent_subnet','0367095d-eebe-4908-8ede-a078767c6f4b','state changed','OS::Neutron::Subnet',NULL,100),(536,'ea51e457-e18f-4780-a4d6-5b4708698518','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:48',NULL,'DELETE','IN_PROGRESS','parent_net','1ddae126-c1b8-4742-af18-9f351d597fdf','state changed','OS::Neutron::Net',NULL,NULL),(537,'56467e2e-d6b5-498f-8437-515917b451d4','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','2026-02-19 09:31:48',NULL,'DELETE','COMPLETE','net','870477bf-2ce4-4f05-8ece-c8a7ce8af7d5','state changed','OS::Neutron::Net',NULL,92),(538,'030fb898-9e49-4d3a-9f40-f67bd3a22a73','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','2026-02-19 09:31:48',NULL,'DELETE','COMPLETE','add_subnet','1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(539,'f151dcbf-881e-43a1-9c94-50c495b8333c','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:48',NULL,'DELETE','COMPLETE','trunk_net_one','c6e30417-9a3a-4c74-a16d-5dd354e75e00','state changed','OS::Neutron::Net',NULL,NULL),(540,'6edb5941-fca2-4364-9058-98fece9b7c50','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:49',NULL,'DELETE','COMPLETE','parent_net','1ddae126-c1b8-4742-af18-9f351d597fdf','state changed','OS::Neutron::Net',NULL,NULL),(541,'d069d205-309f-406b-a69d-e41e779b495d','a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:49',NULL,'DELETE','COMPLETE','UpdateTrunkTest-1757635903','a500cc63-f05a-4887-9edb-ad51b4523a54','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(542,'dcd95df4-8ab3-4d87-b814-d00a7499a65f','dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:31:49',NULL,'CREATE','COMPLETE','subnet_a','e70d6dec-9961-430e-a1dd-4042133c661a','state changed','OS::Neutron::Subnet',NULL,118),(543,'c3a793ff-eae9-42b7-9ad2-df31f0f10ffc','5da86ba1-1131-4371-9678-174588891d52','2026-02-19 09:31:49',NULL,'CREATE','COMPLETE','server_with_encrypted_property','8584ac11-ffbb-44db-ae9d-fcc8d43826ef','state changed','OS::Nova::Server',NULL,112),(544,'e412c6b6-381c-492f-aa83-e7406c4858d8','5da86ba1-1131-4371-9678-174588891d52','2026-02-19 09:31:49',NULL,'CREATE','COMPLETE','EncryptedParametersTest-1466683732','5da86ba1-1131-4371-9678-174588891d52','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(545,'ac5fb497-2fb8-4080-bb64-5803ed468333','dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:31:50',NULL,'CREATE','COMPLETE','subnet_b','89393055-b1c3-4676-8038-3fa35e005d6d','state changed','OS::Neutron::Subnet',NULL,119),(546,'8450168f-c8c3-4733-b56b-4b6d0f16d094','dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:31:50',NULL,'CREATE','IN_PROGRESS','server','create_server_with_sub_ip-server-bpalkkfzxl2c','state changed','OS::Nova::Server',NULL,120),(547,'ed958a60-8366-45d0-801d-0ba513a82635','5da86ba1-1131-4371-9678-174588891d52','2026-02-19 09:31:52',NULL,'DELETE','IN_PROGRESS','EncryptedParametersTest-1466683732','5da86ba1-1131-4371-9678-174588891d52','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(548,'2fd78249-cacc-4047-88a2-e51dbce3364c','5da86ba1-1131-4371-9678-174588891d52','2026-02-19 09:31:52',NULL,'DELETE','IN_PROGRESS','server_with_encrypted_property','8584ac11-ffbb-44db-ae9d-fcc8d43826ef','state changed','OS::Nova::Server',NULL,112),(549,'2d82855c-2f0d-4998-a9b0-488888cd4815','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:31:53',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-2117912408','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(550,'a4534134-ceb1-4936-adaa-b77f20652fbb','7323f31a-d82a-42dc-80d9-c7fc49532448','2026-02-19 09:31:53',NULL,'CREATE','IN_PROGRESS','multi_networks_swaps','7323f31a-d82a-42dc-80d9-c7fc49532448','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(551,'6f8fde11-c2ce-42a4-b15a-3700ec6e0357','7323f31a-d82a-42dc-80d9-c7fc49532448','2026-02-19 09:31:54',NULL,'CREATE','IN_PROGRESS','net','multi_networks_swaps-net-zcpu74saa6h7','state changed','OS::Neutron::Net',NULL,121),(552,'d61691ff-1181-47ab-8a5c-9558e8102182','5da86ba1-1131-4371-9678-174588891d52','2026-02-19 09:31:54',NULL,'DELETE','COMPLETE','server_with_encrypted_property','8584ac11-ffbb-44db-ae9d-fcc8d43826ef','state changed','OS::Nova::Server',NULL,112),(553,'1c04c10c-259e-48b5-983d-7b9abbf91df5','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:31:54',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-2117912408-trunk_net_two-koysv333qpb3','state changed','OS::Neutron::Net',NULL,NULL),(554,'7e0da6c8-3b8e-400b-a9ee-47f5b113ab94','5da86ba1-1131-4371-9678-174588891d52','2026-02-19 09:31:54',NULL,'DELETE','COMPLETE','EncryptedParametersTest-1466683732','5da86ba1-1131-4371-9678-174588891d52','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(555,'666bcbdb-7c00-4ca6-aa72-f2a7cb255f9c','7323f31a-d82a-42dc-80d9-c7fc49532448','2026-02-19 09:31:55',NULL,'CREATE','COMPLETE','net','2c14d05b-1d30-4166-84b9-d2eaeb7b7f74','state changed','OS::Neutron::Net',NULL,121),(556,'aee99721-877a-434f-9690-e6da19b904f4','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:31:55',NULL,'CREATE','COMPLETE','trunk_net_two','8278727d-06ae-4cb2-b7c6-c6215bd7a092','state changed','OS::Neutron::Net',NULL,NULL),(557,'fafbe16e-b102-44aa-a2c7-83daa54daff7','7323f31a-d82a-42dc-80d9-c7fc49532448','2026-02-19 09:31:55',NULL,'CREATE','IN_PROGRESS','subnet','multi_networks_swaps-subnet-lfpt7tlmkine','state changed','OS::Neutron::Subnet',NULL,122),(558,'7570d002-3ec4-48ba-bf75-134279c38c5b','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:31:55',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-2117912408-trunk_subnet_two-oizramzlviau','state changed','OS::Neutron::Subnet',NULL,123),(559,'bb4cfaa1-25ce-45e8-b990-f201d58344db','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:31:55',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-2117912408-trunk_net_one-my7pvyuid6so','state changed','OS::Neutron::Net',NULL,NULL),(560,'85578c48-db7c-4103-bcea-2c9d26d2bd3d','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:31:56',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-2117912408-parent_net-wm4ff5teaazo','state changed','OS::Neutron::Net',NULL,NULL),(561,'eca2e2b7-6781-4eb4-876e-87382dfce34e','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:31:57',NULL,'CREATE','COMPLETE','trunk_net_one','aee25574-65a9-414a-a811-de7c4b4f23a7','state changed','OS::Neutron::Net',NULL,NULL),(562,'a5c6df61-c3b6-417d-ab58-b946ce7daa2f','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:31:57',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-2117912408-trunk_subnet_one-nqlvyw7kgl5p','state changed','OS::Neutron::Subnet',NULL,124),(563,'7d6fe88d-90b6-4b6e-9a37-ae758e99b4df','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:31:57',NULL,'CREATE','COMPLETE','parent_net','aae99c7f-c152-44ab-a24d-6d9a6bd00941','state changed','OS::Neutron::Net',NULL,NULL),(564,'26adaae2-6966-4fbb-965d-69eb703ea095','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:31:57',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-2117912408-parent_subnet-kkg4gql3rsmh','state changed','OS::Neutron::Subnet',NULL,125),(565,'85d59b2c-617b-48a1-801c-b94ece4227ad','7323f31a-d82a-42dc-80d9-c7fc49532448','2026-02-19 09:31:57',NULL,'CREATE','COMPLETE','subnet','2d98b57b-4341-40ad-8740-02b95084c37f','state changed','OS::Neutron::Subnet',NULL,122),(566,'bada3d80-6d7e-4a42-b889-a34eabd675ae','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:31:57',NULL,'CREATE','COMPLETE','trunk_subnet_two','bf4e30f3-4e95-4a40-8762-f75c4d59574a','state changed','OS::Neutron::Subnet',NULL,123),(567,'775c18bc-6885-4f70-9b4d-42c038209bc5','7323f31a-d82a-42dc-80d9-c7fc49532448','2026-02-19 09:31:57',NULL,'CREATE','IN_PROGRESS','server','multi_networks_swaps-server-wvcxsojiuorq','state changed','OS::Nova::Server',NULL,126),(568,'6209ddc6-9dd6-459d-9324-da4e926dd578','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:31:58',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-2117912408-sub_port_two-f7djfetkkybk','state changed','OS::Neutron::Port',NULL,127),(569,'1a000749-18b1-49ea-a06e-6f12bbd0c013','bf321c86-ead0-4108-9cd7-b2c200eb143f','2026-02-19 09:31:58',NULL,'CREATE','IN_PROGRESS','EncryptionVolTypeTest-395158397','bf321c86-ead0-4108-9cd7-b2c200eb143f','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(570,'b31b1bf7-44e5-43dc-bf9c-592a07d5300e','bf321c86-ead0-4108-9cd7-b2c200eb143f','2026-02-19 09:31:58',NULL,'CREATE','IN_PROGRESS','my_volume_type','EncryptionVolTypeTest-395158397-my_volume_type-5fmbhq7bcuo7','state changed','OS::Cinder::VolumeType',NULL,128),(571,'183fbb5f-7c59-419f-b13c-a2217102a14a','bf321c86-ead0-4108-9cd7-b2c200eb143f','2026-02-19 09:31:58',NULL,'CREATE','COMPLETE','my_volume_type','1bf13480-93e7-4814-98c8-24eccb55c1b8','state changed','OS::Cinder::VolumeType',NULL,128),(572,'fc09e061-61e7-4a9d-ae32-c15cf84c0e23','bf321c86-ead0-4108-9cd7-b2c200eb143f','2026-02-19 09:31:58',NULL,'CREATE','IN_PROGRESS','my_encrypted_vol_type','EncryptionVolTypeTest-395158397-my_encrypted_vol_type-7eygtbuhskj6','state changed','OS::Cinder::EncryptedVolumeType',NULL,129),(573,'71856705-a213-4cd8-967d-76da2e1a9929','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:31:59',NULL,'CREATE','COMPLETE','trunk_subnet_one','9c4e524a-c8cd-4770-a75b-9af2277dd453','state changed','OS::Neutron::Subnet',NULL,124),(574,'801c05d3-f6ee-4ca1-ab50-ca3c35d3b82b','bf321c86-ead0-4108-9cd7-b2c200eb143f','2026-02-19 09:31:59',NULL,'CREATE','COMPLETE','my_encrypted_vol_type','1bf13480-93e7-4814-98c8-24eccb55c1b8','state changed','OS::Cinder::EncryptedVolumeType',NULL,129),(575,'afa97197-f818-4de0-b44f-b6c7a91d5e8f','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:31:59',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-2117912408-sub_port_one-l2hzxhjurnte','state changed','OS::Neutron::Port',NULL,130),(576,'f81aba67-dd8c-4d7e-af03-2a66211d1429','bf321c86-ead0-4108-9cd7-b2c200eb143f','2026-02-19 09:31:59',NULL,'CREATE','COMPLETE','EncryptionVolTypeTest-395158397','bf321c86-ead0-4108-9cd7-b2c200eb143f','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(577,'d6be1ac7-6f86-43ca-b763-26eabf4809eb','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:31:59',NULL,'CREATE','COMPLETE','sub_port_two','007437f5-9abd-4c0d-a418-e94b07d2896d','state changed','OS::Neutron::Port',NULL,127),(578,'c68dd4b4-0adb-4b57-81ac-54659f7057c7','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:00',NULL,'CREATE','COMPLETE','parent_subnet','5be3c10a-09cf-4a33-a75a-4847a413e50e','state changed','OS::Neutron::Subnet',NULL,125),(579,'a4d602e5-84a4-494c-8a6e-f5992e5983db','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:00',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-2117912408-parent_port-3lipm347u6w5','state changed','OS::Neutron::Port',NULL,131),(580,'5a340769-e0a0-48ef-8d6d-fee36dc56084','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:00',NULL,'CREATE','COMPLETE','sub_port_one','32215bec-6ee2-4f88-948a-b268899ad4cd','state changed','OS::Neutron::Port',NULL,130),(581,'a77b1229-0309-4ab0-b418-b361a1fd1eaf','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:01',NULL,'CREATE','COMPLETE','parent_port','ed50e680-fefb-400f-97d8-aa104c7582c7','state changed','OS::Neutron::Port',NULL,131),(582,'0a92c756-256d-4e6f-8675-2a06c4bf1588','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:03',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-2117912408-trunk-uymoesopvuva','state changed','OS::Neutron::Trunk',NULL,132),(583,'b46b9ad4-1184-4e93-a9b2-9ea162432a1b','bf321c86-ead0-4108-9cd7-b2c200eb143f','2026-02-19 09:32:06',NULL,'UPDATE','IN_PROGRESS','EncryptionVolTypeTest-395158397','bf321c86-ead0-4108-9cd7-b2c200eb143f','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(584,'8472d76d-7036-4278-940e-9abea1ec2b48','bf321c86-ead0-4108-9cd7-b2c200eb143f','2026-02-19 09:32:09',NULL,'UPDATE','IN_PROGRESS','my_encrypted_vol_type','1bf13480-93e7-4814-98c8-24eccb55c1b8','state changed','OS::Cinder::EncryptedVolumeType',NULL,129),(585,'3224de9e-cf77-4ef6-9009-86f9d9736b11','bf321c86-ead0-4108-9cd7-b2c200eb143f','2026-02-19 09:32:10',NULL,'UPDATE','COMPLETE','my_encrypted_vol_type','1bf13480-93e7-4814-98c8-24eccb55c1b8','state changed','OS::Cinder::EncryptedVolumeType',NULL,133),(586,'b3a4bc2a-d36a-4017-bfbe-7551d3f93d74','bf321c86-ead0-4108-9cd7-b2c200eb143f','2026-02-19 09:32:12',NULL,'UPDATE','COMPLETE','EncryptionVolTypeTest-395158397','bf321c86-ead0-4108-9cd7-b2c200eb143f','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(587,'6bc33e89-e63e-46cc-a448-edb3689eef38','dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:32:12',NULL,'CREATE','COMPLETE','server','56274c13-444f-48da-a899-812efb43b2ff','state changed','OS::Nova::Server',NULL,120),(588,'bdae4f23-c0b5-4741-bf4c-310e0ebc94f9','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:12',NULL,'CREATE','COMPLETE','trunk','682d0865-9354-46f5-8b1d-4ca008e1b022','state changed','OS::Neutron::Trunk',NULL,132),(589,'48b41b2c-b442-4be5-ac0d-732ef25d0461','dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:32:13',NULL,'CREATE','COMPLETE','create_server_with_sub_ip','dcecf177-9a5d-42ec-8995-39a797c82f48','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(590,'369ce2ef-6cdb-4146-ba08-bc36a5e2aaec','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:13',NULL,'CREATE','COMPLETE','UpdateTrunkTest-2117912408','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(591,'c6c9e4b1-6a0f-4f72-9ea4-029ded9f0d13','bf321c86-ead0-4108-9cd7-b2c200eb143f','2026-02-19 09:32:17',NULL,'DELETE','IN_PROGRESS','EncryptionVolTypeTest-395158397','bf321c86-ead0-4108-9cd7-b2c200eb143f','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(592,'759a93fa-d22f-4231-938f-ad376ccc6540','bf321c86-ead0-4108-9cd7-b2c200eb143f','2026-02-19 09:32:17',NULL,'DELETE','IN_PROGRESS','my_encrypted_vol_type','1bf13480-93e7-4814-98c8-24eccb55c1b8','state changed','OS::Cinder::EncryptedVolumeType',NULL,133),(593,'65381b34-ff83-467b-9512-d75b8054f215','bf321c86-ead0-4108-9cd7-b2c200eb143f','2026-02-19 09:32:17',NULL,'DELETE','COMPLETE','my_encrypted_vol_type','1bf13480-93e7-4814-98c8-24eccb55c1b8','state changed','OS::Cinder::EncryptedVolumeType',NULL,133),(594,'19a75bf2-361a-4ea0-bd91-0e4d65e7a94c','bf321c86-ead0-4108-9cd7-b2c200eb143f','2026-02-19 09:32:18',NULL,'DELETE','IN_PROGRESS','my_volume_type','1bf13480-93e7-4814-98c8-24eccb55c1b8','state changed','OS::Cinder::VolumeType',NULL,128),(595,'56d926ba-b1be-4382-83d3-aacc68365910','bf321c86-ead0-4108-9cd7-b2c200eb143f','2026-02-19 09:32:18',NULL,'DELETE','COMPLETE','my_volume_type','1bf13480-93e7-4814-98c8-24eccb55c1b8','state changed','OS::Cinder::VolumeType',NULL,128),(596,'797e84fe-56f8-458c-9b38-becf30aee8d2','bf321c86-ead0-4108-9cd7-b2c200eb143f','2026-02-19 09:32:18',NULL,'DELETE','COMPLETE','EncryptionVolTypeTest-395158397','bf321c86-ead0-4108-9cd7-b2c200eb143f','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(597,'f8eb7f92-2425-4112-9cad-9ffb4040afab','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:19',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-2117912408','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(598,'11b92612-f033-42e6-a38b-e17f263c262e','dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:32:20',NULL,'UPDATE','IN_PROGRESS','create_server_with_sub_ip','dcecf177-9a5d-42ec-8995-39a797c82f48','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(599,'77e4945b-7ac7-48d8-80a4-d04dfa3aae7e','dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:32:21',NULL,'UPDATE','IN_PROGRESS','server','56274c13-444f-48da-a899-812efb43b2ff','state changed','OS::Nova::Server',NULL,120),(600,'4f2bda75-0170-4201-b490-587f31460477','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:23',NULL,'UPDATE','IN_PROGRESS','trunk','682d0865-9354-46f5-8b1d-4ca008e1b022','state changed','OS::Neutron::Trunk',NULL,132),(601,'7831c394-1c5a-43be-9287-32fd159d3716','c9b6315e-8c70-41d3-9ebc-50fc528cc8fa','2026-02-19 09:32:24',NULL,'CREATE','IN_PROGRESS','ExternalReferencesTest-1782684685','c9b6315e-8c70-41d3-9ebc-50fc528cc8fa','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(602,'44a770d4-4088-45f5-8231-f2968fddbca1','c9b6315e-8c70-41d3-9ebc-50fc528cc8fa','2026-02-19 09:32:25',NULL,'ADOPT','IN_PROGRESS','test1','ExternalReferencesTest-1782684685-test1-gbxqkkfvurkx','state changed','OS::Heat::TestResource',NULL,NULL),(603,'55e41689-0a75-4b8e-9a91-1b417e6bde11','c9b6315e-8c70-41d3-9ebc-50fc528cc8fa','2026-02-19 09:32:25',NULL,'ADOPT','COMPLETE','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(604,'f3b60e48-ecee-4af6-a66b-d1c3ff2703b2','c9b6315e-8c70-41d3-9ebc-50fc528cc8fa','2026-02-19 09:32:26',NULL,'CHECK','COMPLETE','test1','foobar','CHECK not supported for OS::Heat::TestResource','OS::Heat::TestResource',NULL,NULL),(605,'8bfa9a73-3268-4902-8771-50a9c0b5c81d','c9b6315e-8c70-41d3-9ebc-50fc528cc8fa','2026-02-19 09:32:26',NULL,'CREATE','COMPLETE','ExternalReferencesTest-1782684685','c9b6315e-8c70-41d3-9ebc-50fc528cc8fa','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(606,'ac32a0e3-0973-4c43-94ce-af2a2605d641','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:27',NULL,'UPDATE','COMPLETE','trunk','682d0865-9354-46f5-8b1d-4ca008e1b022','state changed','OS::Neutron::Trunk',NULL,135),(607,'5ab90a69-6303-49b9-ad8d-97521eb95e61','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:29',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-2117912408','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(608,'2dfa4c55-a87b-4904-9914-eaddfa10d740','c9b6315e-8c70-41d3-9ebc-50fc528cc8fa','2026-02-19 09:32:30',NULL,'DELETE','IN_PROGRESS','ExternalReferencesTest-1782684685','c9b6315e-8c70-41d3-9ebc-50fc528cc8fa','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(609,'718201a9-d8b6-4b38-82d4-5ee0504b4243','c9b6315e-8c70-41d3-9ebc-50fc528cc8fa','2026-02-19 09:32:31',NULL,'DELETE','IN_PROGRESS','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(610,'b69fb8e6-4026-4401-909b-ad8281599316','c9b6315e-8c70-41d3-9ebc-50fc528cc8fa','2026-02-19 09:32:31',NULL,'DELETE','COMPLETE','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(611,'20e830ad-5b5b-4d27-9074-f20095f1b1f1','c9b6315e-8c70-41d3-9ebc-50fc528cc8fa','2026-02-19 09:32:31',NULL,'DELETE','COMPLETE','ExternalReferencesTest-1782684685','c9b6315e-8c70-41d3-9ebc-50fc528cc8fa','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(612,'cbf2db8b-91b5-47ee-b68a-f8c949783e10','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:32',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-2117912408','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(613,'4535ff5e-d95d-4903-aeca-714d9509f186','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:33',NULL,'DELETE','IN_PROGRESS','trunk','682d0865-9354-46f5-8b1d-4ca008e1b022','state changed','OS::Neutron::Trunk',NULL,135),(614,'45394f47-1f06-4401-a22c-b8d842813ce1','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:33',NULL,'DELETE','COMPLETE','trunk','682d0865-9354-46f5-8b1d-4ca008e1b022','state changed','OS::Neutron::Trunk',NULL,135),(615,'55543647-cf04-4541-bd7f-01391e1b3c33','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:33',NULL,'DELETE','IN_PROGRESS','sub_port_one','32215bec-6ee2-4f88-948a-b268899ad4cd','state changed','OS::Neutron::Port',NULL,130),(616,'ce898bcd-9524-41c7-ab3d-777539a81a0b','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:33',NULL,'DELETE','IN_PROGRESS','parent_port','ed50e680-fefb-400f-97d8-aa104c7582c7','state changed','OS::Neutron::Port',NULL,131),(617,'09b9d237-6551-4397-8292-bfd34acb5f68','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:34',NULL,'DELETE','IN_PROGRESS','sub_port_two','007437f5-9abd-4c0d-a418-e94b07d2896d','state changed','OS::Neutron::Port',NULL,127),(618,'adf33dfb-2988-4644-9f63-839cdf4aada8','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:34',NULL,'DELETE','COMPLETE','sub_port_one','32215bec-6ee2-4f88-948a-b268899ad4cd','state changed','OS::Neutron::Port',NULL,130),(619,'a825f056-ddbb-4fa5-904a-9b7ab869f429','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:34',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','9c4e524a-c8cd-4770-a75b-9af2277dd453','state changed','OS::Neutron::Subnet',NULL,124),(620,'20dfedd6-70e2-4483-a7e9-75e7c31d8fce','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:34',NULL,'DELETE','COMPLETE','parent_port','ed50e680-fefb-400f-97d8-aa104c7582c7','state changed','OS::Neutron::Port',NULL,131),(621,'64d7779a-9b28-44df-916a-e549149401c7','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:34',NULL,'DELETE','IN_PROGRESS','parent_subnet','5be3c10a-09cf-4a33-a75a-4847a413e50e','state changed','OS::Neutron::Subnet',NULL,125),(622,'b8557288-7330-404a-a4ec-4f0cff025234','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:34',NULL,'DELETE','COMPLETE','trunk_subnet_one','9c4e524a-c8cd-4770-a75b-9af2277dd453','state changed','OS::Neutron::Subnet',NULL,124),(623,'a0ca3902-5138-4926-a900-8872a6e87e07','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:35',NULL,'DELETE','IN_PROGRESS','trunk_net_one','aee25574-65a9-414a-a811-de7c4b4f23a7','state changed','OS::Neutron::Net',NULL,NULL),(624,'5fa9693f-e5ef-4eb8-bfb5-de19c45e19e1','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:35',NULL,'DELETE','COMPLETE','sub_port_two','007437f5-9abd-4c0d-a418-e94b07d2896d','state changed','OS::Neutron::Port',NULL,127),(625,'b7b7220b-921b-4f53-931e-f67cd84beded','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:35',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','bf4e30f3-4e95-4a40-8762-f75c4d59574a','state changed','OS::Neutron::Subnet',NULL,123),(626,'b2f24175-9ed1-46ad-9e49-e93bc30d937b','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:35',NULL,'DELETE','COMPLETE','parent_subnet','5be3c10a-09cf-4a33-a75a-4847a413e50e','state changed','OS::Neutron::Subnet',NULL,125),(627,'f1553526-a089-4759-a14f-7a2bedef3791','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:35',NULL,'DELETE','IN_PROGRESS','parent_net','aae99c7f-c152-44ab-a24d-6d9a6bd00941','state changed','OS::Neutron::Net',NULL,NULL),(628,'1faa9064-9fdb-4081-ad1f-906ad08aae12','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:35',NULL,'DELETE','COMPLETE','trunk_subnet_two','bf4e30f3-4e95-4a40-8762-f75c4d59574a','state changed','OS::Neutron::Subnet',NULL,123),(629,'bfffa739-645b-4cd4-876b-9f0fad07b5bc','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:36',NULL,'DELETE','IN_PROGRESS','trunk_net_two','8278727d-06ae-4cb2-b7c6-c6215bd7a092','state changed','OS::Neutron::Net',NULL,NULL),(630,'51a595a3-b1ec-475b-ad43-557407a8f67b','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:36',NULL,'DELETE','COMPLETE','parent_net','aae99c7f-c152-44ab-a24d-6d9a6bd00941','state changed','OS::Neutron::Net',NULL,NULL),(631,'1758021a-a97f-44fb-a674-8d584f4e206a','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:36',NULL,'DELETE','COMPLETE','trunk_net_one','aee25574-65a9-414a-a811-de7c4b4f23a7','state changed','OS::Neutron::Net',NULL,NULL),(632,'abdec0fa-5869-4550-879f-2d79a888beea','4b7dda8f-12b4-49ca-b8c6-0126791cca78','2026-02-19 09:32:36',NULL,'CREATE','IN_PROGRESS','ExternalReferencesTest-1417404992','4b7dda8f-12b4-49ca-b8c6-0126791cca78','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(633,'377d5a0f-00d6-4ce6-8694-100bedf34b78','4b7dda8f-12b4-49ca-b8c6-0126791cca78','2026-02-19 09:32:37',NULL,'ADOPT','IN_PROGRESS','test1','ExternalReferencesTest-1417404992-test1-vhqwo7xmxivy','state changed','OS::Heat::TestResource',NULL,NULL),(634,'e6707883-77cd-4f17-bab9-980e17b413c4','4b7dda8f-12b4-49ca-b8c6-0126791cca78','2026-02-19 09:32:37',NULL,'ADOPT','COMPLETE','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(635,'2515edcf-0c5f-4746-8d7d-c87a9053215a','4b7dda8f-12b4-49ca-b8c6-0126791cca78','2026-02-19 09:32:37',NULL,'CHECK','COMPLETE','test1','foobar','CHECK not supported for OS::Heat::TestResource','OS::Heat::TestResource',NULL,NULL),(636,'1ad59e3f-0763-4255-9da7-669187eb93a5','4b7dda8f-12b4-49ca-b8c6-0126791cca78','2026-02-19 09:32:37',NULL,'CREATE','COMPLETE','ExternalReferencesTest-1417404992','4b7dda8f-12b4-49ca-b8c6-0126791cca78','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(637,'6b2cc1f7-98cc-43bf-89ad-26c57d013a29','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:37',NULL,'DELETE','COMPLETE','trunk_net_two','8278727d-06ae-4cb2-b7c6-c6215bd7a092','state changed','OS::Neutron::Net',NULL,NULL),(638,'075f28ae-c110-4dde-b991-3c9d7d294df0','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:32:37',NULL,'DELETE','COMPLETE','UpdateTrunkTest-2117912408','a76e09bc-b9fe-4d77-872d-ab05e616a7bb','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(639,'a65dde2c-3cbc-4899-b591-2a65c1760901','7323f31a-d82a-42dc-80d9-c7fc49532448','2026-02-19 09:32:37',NULL,'CREATE','COMPLETE','server','da2cb226-e0b7-4b62-a66b-af0370401938','state changed','OS::Nova::Server',NULL,126),(640,'c7d2f962-e333-4d9c-aafc-6609d0dd0caa','7323f31a-d82a-42dc-80d9-c7fc49532448','2026-02-19 09:32:37',NULL,'CREATE','COMPLETE','multi_networks_swaps','7323f31a-d82a-42dc-80d9-c7fc49532448','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(641,'96a6bc3b-e4fc-4510-a178-753a39ddf0d9','4b7dda8f-12b4-49ca-b8c6-0126791cca78','2026-02-19 09:32:38',NULL,'UPDATE','IN_PROGRESS','ExternalReferencesTest-1417404992','4b7dda8f-12b4-49ca-b8c6-0126791cca78','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(642,'3511b740-796f-4b18-a017-e7d67a60a3e0','4b7dda8f-12b4-49ca-b8c6-0126791cca78','2026-02-19 09:32:38',NULL,'UPDATE','COMPLETE','ExternalReferencesTest-1417404992','4b7dda8f-12b4-49ca-b8c6-0126791cca78','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(643,'ffc62fcb-8428-4147-983b-fc43e5f28809','4b7dda8f-12b4-49ca-b8c6-0126791cca78','2026-02-19 09:32:38',NULL,'DELETE','IN_PROGRESS','ExternalReferencesTest-1417404992','4b7dda8f-12b4-49ca-b8c6-0126791cca78','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(644,'3bcec583-1c61-4984-bac6-0feee0c18b48','4b7dda8f-12b4-49ca-b8c6-0126791cca78','2026-02-19 09:32:38',NULL,'DELETE','IN_PROGRESS','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(645,'385463b4-1fed-4620-b353-5f6e81fb2905','4b7dda8f-12b4-49ca-b8c6-0126791cca78','2026-02-19 09:32:38',NULL,'DELETE','COMPLETE','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(646,'b2c6af07-dd38-4668-8dfb-ab099389ffe4','4b7dda8f-12b4-49ca-b8c6-0126791cca78','2026-02-19 09:32:38',NULL,'DELETE','COMPLETE','ExternalReferencesTest-1417404992','4b7dda8f-12b4-49ca-b8c6-0126791cca78','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(647,'0e58a84b-ab49-4849-9d67-9fa5f61cb055','dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:32:41',NULL,'UPDATE','COMPLETE','server','56274c13-444f-48da-a899-812efb43b2ff','state changed','OS::Nova::Server',NULL,137),(648,'81c2214a-d985-4553-8646-9d45584220f2','dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:32:41',NULL,'UPDATE','COMPLETE','create_server_with_sub_ip','dcecf177-9a5d-42ec-8995-39a797c82f48','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(649,'df6d2b42-3063-41b4-8b9d-c2ecf030a56f','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:32:43',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-412893611','d0090fba-5a2b-4393-9536-c7a5457432aa','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(650,'dd306840-45b9-4b40-8d12-34f9786d5b56','dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:32:44',NULL,'DELETE','IN_PROGRESS','create_server_with_sub_ip','dcecf177-9a5d-42ec-8995-39a797c82f48','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(651,'1271a8c4-382e-4440-80db-d19b9c8c28fb','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:32:44',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-412893611-trunk_net_two-cheqrkblcd5s','state changed','OS::Neutron::Net',NULL,NULL),(652,'7bf38331-a5f4-4bce-baed-123d799b6a67','7323f31a-d82a-42dc-80d9-c7fc49532448','2026-02-19 09:32:44',NULL,'UPDATE','IN_PROGRESS','multi_networks_swaps','7323f31a-d82a-42dc-80d9-c7fc49532448','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(653,'eea18592-498d-407e-9e80-90f490b5c32d','dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:32:44',NULL,'DELETE','IN_PROGRESS','server','56274c13-444f-48da-a899-812efb43b2ff','state changed','OS::Nova::Server',NULL,137),(654,'a365274b-bb36-42bb-a435-620be2738cd5','f6f7f2b1-53ad-4d71-8123-4172e2d859f3','2026-02-19 09:32:44',NULL,'CREATE','IN_PROGRESS','ExternalReferencesTest-1470144968','f6f7f2b1-53ad-4d71-8123-4172e2d859f3','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(655,'e72266c2-5293-40ef-907e-8faee39a73cf','f6f7f2b1-53ad-4d71-8123-4172e2d859f3','2026-02-19 09:32:45',NULL,'CREATE','IN_PROGRESS','test1','ExternalReferencesTest-1470144968-test1-aubaels33wfb','state changed','OS::Heat::TestResource',NULL,NULL),(656,'83f751bb-6255-4f9b-a2f4-bf2549a4c057','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:32:45',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-412893611-trunk_net_one-jw2jmge6xsh4','state changed','OS::Neutron::Net',NULL,NULL),(657,'69f79f88-5240-40da-8a6d-40d2c49ab016','7323f31a-d82a-42dc-80d9-c7fc49532448','2026-02-19 09:32:45',NULL,'UPDATE','IN_PROGRESS','server','da2cb226-e0b7-4b62-a66b-af0370401938','state changed','OS::Nova::Server',NULL,126),(658,'2c0694de-a9bf-46a6-86bd-6f4cc81fa1c8','f6f7f2b1-53ad-4d71-8123-4172e2d859f3','2026-02-19 09:32:45',NULL,'CREATE','COMPLETE','test1','ExternalReferencesTest-1470144968-test1-aubaels33wfb','state changed','OS::Heat::TestResource',NULL,NULL),(659,'8b1bd269-f7c2-4e31-b407-c7e70a338f7e','f6f7f2b1-53ad-4d71-8123-4172e2d859f3','2026-02-19 09:32:45',NULL,'CREATE','COMPLETE','ExternalReferencesTest-1470144968','f6f7f2b1-53ad-4d71-8123-4172e2d859f3','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(660,'d772dd0f-5f17-4396-ae0d-2c5f3d756e43','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:32:45',NULL,'CREATE','COMPLETE','trunk_net_two','29978b17-0ee6-40d5-9957-2718ac3d637e','state changed','OS::Neutron::Net',NULL,NULL),(661,'c43a1c77-567d-4e9b-bbd7-9081d5242d4d','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:32:45',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-412893611-trunk_subnet_two-7kbc35qvmbn6','state changed','OS::Neutron::Subnet',NULL,140),(662,'2a28743a-b887-4270-a274-6426f71d47c6','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:32:46',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-412893611-parent_net-n6xrm4fpv7lo','state changed','OS::Neutron::Net',NULL,NULL),(663,'6c9e71f3-279a-445d-8ca8-044f91d8924a','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:32:47',NULL,'CREATE','COMPLETE','trunk_net_one','6a112068-5b31-4c27-8155-1e2cba5bf681','state changed','OS::Neutron::Net',NULL,NULL),(664,'149bab11-e8fb-4c1e-a8b9-784ee4a0b0d3','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:32:47',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-412893611-trunk_subnet_one-oa7pwmhpgpaa','state changed','OS::Neutron::Subnet',NULL,141),(665,'193c9155-fd2d-488a-9aa8-47690ad91204','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:32:47',NULL,'CREATE','COMPLETE','parent_net','69f27366-3e75-4fa2-ae6c-b4eee1ae97db','state changed','OS::Neutron::Net',NULL,NULL),(666,'8864a31a-a115-4671-a5de-0e1cab9df200','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:32:47',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-412893611-parent_subnet-o24jn5ho4bg2','state changed','OS::Neutron::Subnet',NULL,142),(667,'4b79b123-9f05-41e5-87a5-03910c579c1d','dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:32:48',NULL,'DELETE','COMPLETE','server','56274c13-444f-48da-a899-812efb43b2ff','state changed','OS::Nova::Server',NULL,137),(668,'fa7bc3e0-c53b-46e6-b8c6-e13116af1b03','dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:32:49',NULL,'DELETE','IN_PROGRESS','subnet_b','89393055-b1c3-4676-8038-3fa35e005d6d','state changed','OS::Neutron::Subnet',NULL,119),(669,'c245686d-a0e4-48f4-bb20-adee49271f61','dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:32:49',NULL,'DELETE','IN_PROGRESS','subnet_a','e70d6dec-9961-430e-a1dd-4042133c661a','state changed','OS::Neutron::Subnet',NULL,118),(670,'2d4151af-fd06-4b18-8849-457b4c6f6571','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:32:50',NULL,'CREATE','COMPLETE','trunk_subnet_two','e0f4b6e3-243d-4394-9a03-384cd788d95b','state changed','OS::Neutron::Subnet',NULL,140),(671,'b9c4b368-2902-4e73-b486-adbb377eab13','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:32:50',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-412893611-sub_port_two-7gdv2is5qgnz','state changed','OS::Neutron::Port',NULL,143),(672,'ed99957a-0e45-4397-bd1d-4051cf1ce235','dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:32:50',NULL,'DELETE','COMPLETE','subnet_a','e70d6dec-9961-430e-a1dd-4042133c661a','state changed','OS::Neutron::Subnet',NULL,118),(673,'039c49cd-55d9-4452-9b06-cfc459b2e65e','f6f7f2b1-53ad-4d71-8123-4172e2d859f3','2026-02-19 09:32:50',NULL,'UPDATE','IN_PROGRESS','ExternalReferencesTest-1470144968','f6f7f2b1-53ad-4d71-8123-4172e2d859f3','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(674,'22e527d9-5eba-43b5-be87-63536de3d987','dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:32:50',NULL,'DELETE','COMPLETE','subnet_b','89393055-b1c3-4676-8038-3fa35e005d6d','state changed','OS::Neutron::Subnet',NULL,119),(675,'925e1252-a38b-4788-bf52-7e2e707e0784','f6f7f2b1-53ad-4d71-8123-4172e2d859f3','2026-02-19 09:32:50',NULL,'UPDATE','FAILED','ExternalReferencesTest-1470144968','f6f7f2b1-53ad-4d71-8123-4172e2d859f3','Resource UPDATE failed: NotSupported: resources.test1: Update to property external_id of test1 (OS::Heat::TestResource) is not supported.','OS::Heat::Stack',NULL,NULL),(676,'5472cc18-b09d-405b-ba87-d308e3944c41','dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:32:50',NULL,'DELETE','IN_PROGRESS','net','142e7724-18ff-41de-99db-8890fdaf3355','state changed','OS::Neutron::Net',NULL,117),(677,'c3ea6284-9aa7-4cea-9b4f-72bfc22d952d','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:32:50',NULL,'CREATE','COMPLETE','trunk_subnet_one','a4402840-4493-4c38-bf96-ebcf8e01f1d8','state changed','OS::Neutron::Subnet',NULL,141),(678,'8bfb92e0-4ead-44be-b270-bf6cf610210d','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:32:50',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-412893611-sub_port_one-uorjgoymi4cj','state changed','OS::Neutron::Port',NULL,144),(679,'20440203-c599-4787-85ca-f6ae9c70a011','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:32:50',NULL,'CREATE','COMPLETE','parent_subnet','1ec11d97-c4e5-4adf-bb60-9656226df5f6','state changed','OS::Neutron::Subnet',NULL,142),(680,'2499ad84-d3d4-408b-a360-9aef32baedca','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:32:51',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-412893611-parent_port-u7bmf2k7qpv3','state changed','OS::Neutron::Port',NULL,145),(681,'18b1632a-d3b1-4cdd-aa8e-5931d07260e8','dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:32:51',NULL,'DELETE','COMPLETE','net','142e7724-18ff-41de-99db-8890fdaf3355','state changed','OS::Neutron::Net',NULL,117),(682,'186bb7f1-3fb5-4726-acea-1eeff2bf4f91','dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:32:51',NULL,'DELETE','COMPLETE','create_server_with_sub_ip','dcecf177-9a5d-42ec-8995-39a797c82f48','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(683,'427a0072-b24f-4880-9cae-e5d8db50c72a','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:32:51',NULL,'CREATE','COMPLETE','sub_port_two','e8b7f092-df49-48ba-b637-27d21113a956','state changed','OS::Neutron::Port',NULL,143),(684,'ec47a022-5978-47d7-acbb-2972121449b3','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:32:52',NULL,'CREATE','COMPLETE','sub_port_one','47db5fe4-baf2-4522-9c80-b8dd6d17888b','state changed','OS::Neutron::Port',NULL,144),(685,'7151de24-7ca6-42a9-9a64-59b8a7f06a61','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:32:52',NULL,'CREATE','COMPLETE','parent_port','daa9ab07-668f-4041-936c-fba01d6f012a','state changed','OS::Neutron::Port',NULL,145),(686,'0fce4da8-37b2-4bb7-be73-4beb8587785f','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:32:52',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-412893611-trunk-zo6wgucsruiw','state changed','OS::Neutron::Trunk',NULL,146),(687,'2105d6a7-e498-499a-8fb2-326875b013c0','7323f31a-d82a-42dc-80d9-c7fc49532448','2026-02-19 09:32:52',NULL,'UPDATE','COMPLETE','server','da2cb226-e0b7-4b62-a66b-af0370401938','state changed','OS::Nova::Server',NULL,147),(688,'e7c0aa0e-65a2-44cc-af74-d8ffc5ec28b2','7323f31a-d82a-42dc-80d9-c7fc49532448','2026-02-19 09:32:53',NULL,'UPDATE','COMPLETE','multi_networks_swaps','7323f31a-d82a-42dc-80d9-c7fc49532448','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(689,'6fddadda-2a51-4ff4-a232-8b02e3b7024d','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:32:53',NULL,'CREATE','COMPLETE','trunk','743bfdfa-ce4d-4f4e-9a01-27640abf40ba','state changed','OS::Neutron::Trunk',NULL,146),(690,'ee11ea9e-0340-4a20-9de5-4db04e4d8b76','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:32:53',NULL,'CREATE','COMPLETE','UpdateTrunkTest-412893611','d0090fba-5a2b-4393-9536-c7a5457432aa','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(691,'6d818048-dc6e-4188-9c2c-1122c7b15b9f','f6f7f2b1-53ad-4d71-8123-4172e2d859f3','2026-02-19 09:32:54',NULL,'DELETE','IN_PROGRESS','ExternalReferencesTest-1470144968','f6f7f2b1-53ad-4d71-8123-4172e2d859f3','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(692,'4d805865-a5c9-452a-b8b8-b734d38a092e','f6f7f2b1-53ad-4d71-8123-4172e2d859f3','2026-02-19 09:32:54',NULL,'DELETE','IN_PROGRESS','test1','ExternalReferencesTest-1470144968-test1-aubaels33wfb','state changed','OS::Heat::TestResource',NULL,NULL),(693,'ff744ec4-7e15-484e-aac5-5c87e9ae2302','f6f7f2b1-53ad-4d71-8123-4172e2d859f3','2026-02-19 09:32:54',NULL,'DELETE','COMPLETE','test1','ExternalReferencesTest-1470144968-test1-aubaels33wfb','state changed','OS::Heat::TestResource',NULL,NULL),(694,'a022bf15-57e3-4abe-b035-d6f3fe4fc811','f6f7f2b1-53ad-4d71-8123-4172e2d859f3','2026-02-19 09:32:55',NULL,'DELETE','COMPLETE','ExternalReferencesTest-1470144968','f6f7f2b1-53ad-4d71-8123-4172e2d859f3','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(695,'9b5ce9bf-7e50-4c46-a545-b0925fdd5d85','81e3280b-9726-4fff-bd50-94f8552f6a30','2026-02-19 09:32:55',NULL,'CREATE','IN_PROGRESS','ResourcesList-413939034','81e3280b-9726-4fff-bd50-94f8552f6a30','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(696,'bc004748-b524-4224-a484-31b11d4f9bcd','81e3280b-9726-4fff-bd50-94f8552f6a30','2026-02-19 09:32:55',NULL,'CREATE','IN_PROGRESS','test1','ResourcesList-413939034-test1-xvqyh32g7vep','state changed','OS::Heat::TestResource',NULL,148),(697,'b4e5002d-0315-497f-990b-659382b0174f','81e3280b-9726-4fff-bd50-94f8552f6a30','2026-02-19 09:32:55',NULL,'CREATE','COMPLETE','test1','ResourcesList-413939034-test1-xvqyh32g7vep','state changed','OS::Heat::TestResource',NULL,148),(698,'27445edc-9d0c-4fd1-9787-05c0df12864c','81e3280b-9726-4fff-bd50-94f8552f6a30','2026-02-19 09:32:55',NULL,'CREATE','IN_PROGRESS','test2','ResourcesList-413939034-test2-cvnl5wyzmjhr','state changed','OS::Heat::TestResource',NULL,149),(699,'afdad2d6-a6ed-45b3-80df-5053e5e0ed97','81e3280b-9726-4fff-bd50-94f8552f6a30','2026-02-19 09:32:55',NULL,'CREATE','COMPLETE','test2','ResourcesList-413939034-test2-cvnl5wyzmjhr','state changed','OS::Heat::TestResource',NULL,149),(700,'2b219a92-f85f-4031-bb99-a6fcd5b4d457','81e3280b-9726-4fff-bd50-94f8552f6a30','2026-02-19 09:32:55',NULL,'CREATE','COMPLETE','ResourcesList-413939034','81e3280b-9726-4fff-bd50-94f8552f6a30','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(701,'8e74d7bf-1dfb-4fd8-96fd-ec489bdcfa0d','81e3280b-9726-4fff-bd50-94f8552f6a30','2026-02-19 09:32:56',NULL,'DELETE','IN_PROGRESS','ResourcesList-413939034','81e3280b-9726-4fff-bd50-94f8552f6a30','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(702,'18109ebe-96c2-4c22-9382-ca39e22bd493','81e3280b-9726-4fff-bd50-94f8552f6a30','2026-02-19 09:32:56',NULL,'DELETE','IN_PROGRESS','test2','ResourcesList-413939034-test2-cvnl5wyzmjhr','state changed','OS::Heat::TestResource',NULL,149),(703,'d3915965-b0ca-4157-8fbf-af672036e6c0','81e3280b-9726-4fff-bd50-94f8552f6a30','2026-02-19 09:32:56',NULL,'DELETE','COMPLETE','test2','ResourcesList-413939034-test2-cvnl5wyzmjhr','state changed','OS::Heat::TestResource',NULL,149),(704,'60272081-2cb3-4f6b-8ae3-2cbb382ecb14','81e3280b-9726-4fff-bd50-94f8552f6a30','2026-02-19 09:32:56',NULL,'DELETE','IN_PROGRESS','test1','ResourcesList-413939034-test1-xvqyh32g7vep','state changed','OS::Heat::TestResource',NULL,148),(705,'b762cc81-6674-4710-897d-ee6648780b74','81e3280b-9726-4fff-bd50-94f8552f6a30','2026-02-19 09:32:56',NULL,'DELETE','COMPLETE','test1','ResourcesList-413939034-test1-xvqyh32g7vep','state changed','OS::Heat::TestResource',NULL,148),(706,'59085264-2b0a-40bd-bc5e-0a9b48bcbcb9','81e3280b-9726-4fff-bd50-94f8552f6a30','2026-02-19 09:32:56',NULL,'DELETE','COMPLETE','ResourcesList-413939034','81e3280b-9726-4fff-bd50-94f8552f6a30','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(707,'384b21fe-e86d-41f2-98fd-d4fee3aa2920','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:32:57',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-412893611','d0090fba-5a2b-4393-9536-c7a5457432aa','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(708,'9f85dc77-816a-4a52-885a-2f95f118bf5e','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:02',NULL,'UPDATE','IN_PROGRESS','trunk','743bfdfa-ce4d-4f4e-9a01-27640abf40ba','state changed','OS::Neutron::Trunk',NULL,146),(709,'d4b34c78-6da4-4d6e-8859-e877b82e9eeb','467c15a2-e4fa-4f46-8d34-5ef117eb7d87','2026-02-19 09:33:02',NULL,'CREATE','IN_PROGRESS','ResourcesList-659869602','467c15a2-e4fa-4f46-8d34-5ef117eb7d87','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(710,'4c97b0a7-3450-4d05-9711-1250303b0536','467c15a2-e4fa-4f46-8d34-5ef117eb7d87','2026-02-19 09:33:02',NULL,'CREATE','IN_PROGRESS','test1','ResourcesList-659869602-test1-bzsp3bx4b6oq','state changed','OS::Heat::TestResource',NULL,151),(711,'f83fa508-2e27-46ec-b292-9e6a551af5cb','467c15a2-e4fa-4f46-8d34-5ef117eb7d87','2026-02-19 09:33:02',NULL,'CREATE','COMPLETE','test1','ResourcesList-659869602-test1-bzsp3bx4b6oq','state changed','OS::Heat::TestResource',NULL,151),(712,'839bf89a-c3b8-4886-9f2c-1cca512097e8','467c15a2-e4fa-4f46-8d34-5ef117eb7d87','2026-02-19 09:33:02',NULL,'CREATE','IN_PROGRESS','test2','ResourcesList-659869602-test2-vubmucsvsfbn','state changed','OS::Heat::TestResource',NULL,152),(713,'3081e244-9481-4355-85b2-ce7755476c2c','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:02',NULL,'UPDATE','COMPLETE','trunk','743bfdfa-ce4d-4f4e-9a01-27640abf40ba','state changed','OS::Neutron::Trunk',NULL,153),(714,'ea6f0fc9-0fe5-4fe8-8f60-15c26a760016','467c15a2-e4fa-4f46-8d34-5ef117eb7d87','2026-02-19 09:33:02',NULL,'CREATE','COMPLETE','test2','ResourcesList-659869602-test2-vubmucsvsfbn','state changed','OS::Heat::TestResource',NULL,152),(715,'e0faa8e4-2817-41a7-bb82-b95e0ed6482a','467c15a2-e4fa-4f46-8d34-5ef117eb7d87','2026-02-19 09:33:02',NULL,'CREATE','COMPLETE','ResourcesList-659869602','467c15a2-e4fa-4f46-8d34-5ef117eb7d87','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(716,'865c59c5-f9c3-4238-8045-b42385172426','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:03',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-412893611','d0090fba-5a2b-4393-9536-c7a5457432aa','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(717,'6f38f38c-c248-4775-83c3-1b2676c88593','7323f31a-d82a-42dc-80d9-c7fc49532448','2026-02-19 09:33:03',NULL,'DELETE','IN_PROGRESS','multi_networks_swaps','7323f31a-d82a-42dc-80d9-c7fc49532448','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(718,'6e7c6da7-c6e4-4cbb-83b9-628ea5fa0280','7323f31a-d82a-42dc-80d9-c7fc49532448','2026-02-19 09:33:03',NULL,'DELETE','IN_PROGRESS','server','da2cb226-e0b7-4b62-a66b-af0370401938','state changed','OS::Nova::Server',NULL,147),(719,'f75c16fd-81cf-4901-b262-59e83a197581','6e86c2dd-aa09-4c1c-ada0-61c6f399a3fe','2026-02-19 09:33:04',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-1569728035','6e86c2dd-aa09-4c1c-ada0-61c6f399a3fe','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(720,'f3ad1398-2216-445c-a690-a320ab5a862f','6e86c2dd-aa09-4c1c-ada0-61c6f399a3fe','2026-02-19 09:33:04',NULL,'CREATE','IN_PROGRESS','random1','RemoteStackTest-1569728035-random1-qml435dw2vyo','state changed','OS::Heat::RandomString',NULL,NULL),(721,'e5417212-3687-4f1f-b91c-1eb729e2cc75','6e86c2dd-aa09-4c1c-ada0-61c6f399a3fe','2026-02-19 09:33:04',NULL,'CREATE','COMPLETE','random1','RemoteStackTest-1569728035-random1-qml435dw2vyo','state changed','OS::Heat::RandomString',NULL,NULL),(722,'9bdca17e-1970-4a9d-b87e-e2ec614af08a','6e86c2dd-aa09-4c1c-ada0-61c6f399a3fe','2026-02-19 09:33:04',NULL,'CREATE','COMPLETE','RemoteStackTest-1569728035','6e86c2dd-aa09-4c1c-ada0-61c6f399a3fe','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(723,'26e3d976-2926-4ca7-bbd6-9ee105ed630a','6e86c2dd-aa09-4c1c-ada0-61c6f399a3fe','2026-02-19 09:33:05',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-1569728035','6e86c2dd-aa09-4c1c-ada0-61c6f399a3fe','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(724,'ae4cb803-1105-45fe-b207-052e848a9af3','6e86c2dd-aa09-4c1c-ada0-61c6f399a3fe','2026-02-19 09:33:05',NULL,'DELETE','IN_PROGRESS','random1','RemoteStackTest-1569728035-random1-qml435dw2vyo','state changed','OS::Heat::RandomString',NULL,NULL),(725,'69688027-a6f5-4554-8a7d-9555aa71db0e','6e86c2dd-aa09-4c1c-ada0-61c6f399a3fe','2026-02-19 09:33:05',NULL,'DELETE','COMPLETE','random1','RemoteStackTest-1569728035-random1-qml435dw2vyo','state changed','OS::Heat::RandomString',NULL,NULL),(726,'ddfe0955-7f6d-4e5d-a244-92fc35455567','6e86c2dd-aa09-4c1c-ada0-61c6f399a3fe','2026-02-19 09:33:05',NULL,'DELETE','COMPLETE','RemoteStackTest-1569728035','6e86c2dd-aa09-4c1c-ada0-61c6f399a3fe','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(727,'6dc94f24-255d-43b7-810a-83e465a2c78d','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:07',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-412893611','d0090fba-5a2b-4393-9536-c7a5457432aa','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(728,'7b51ab73-4d78-40f2-a6f7-7fc8139f2f0c','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:07',NULL,'DELETE','IN_PROGRESS','trunk','743bfdfa-ce4d-4f4e-9a01-27640abf40ba','state changed','OS::Neutron::Trunk',NULL,153),(729,'93725d9a-cb9b-4bc6-aa10-d6aa0b0c81fe','467c15a2-e4fa-4f46-8d34-5ef117eb7d87','2026-02-19 09:33:07',NULL,'DELETE','IN_PROGRESS','ResourcesList-659869602','467c15a2-e4fa-4f46-8d34-5ef117eb7d87','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(730,'ea03ef11-355f-4672-8f37-3ee09f081fc7','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:08',NULL,'DELETE','COMPLETE','trunk','743bfdfa-ce4d-4f4e-9a01-27640abf40ba','state changed','OS::Neutron::Trunk',NULL,153),(731,'84db8bd4-3c08-4cc5-97ba-31f30ffb603f','467c15a2-e4fa-4f46-8d34-5ef117eb7d87','2026-02-19 09:33:08',NULL,'DELETE','IN_PROGRESS','test2','ResourcesList-659869602-test2-vubmucsvsfbn','state changed','OS::Heat::TestResource',NULL,152),(732,'8890ffc6-a21d-45b4-979a-d3ec2e1466f6','467c15a2-e4fa-4f46-8d34-5ef117eb7d87','2026-02-19 09:33:08',NULL,'DELETE','COMPLETE','test2','ResourcesList-659869602-test2-vubmucsvsfbn','state changed','OS::Heat::TestResource',NULL,152),(733,'74cfcaaa-bc31-4d81-b774-e8c3de9a793b','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:08',NULL,'DELETE','IN_PROGRESS','parent_port','daa9ab07-668f-4041-936c-fba01d6f012a','state changed','OS::Neutron::Port',NULL,145),(734,'fdf5dddb-1a4d-4bec-8506-71c550fae83d','467c15a2-e4fa-4f46-8d34-5ef117eb7d87','2026-02-19 09:33:08',NULL,'DELETE','IN_PROGRESS','test1','ResourcesList-659869602-test1-bzsp3bx4b6oq','state changed','OS::Heat::TestResource',NULL,151),(735,'c5136fa8-2746-410b-8697-4763d8be9a23','467c15a2-e4fa-4f46-8d34-5ef117eb7d87','2026-02-19 09:33:08',NULL,'DELETE','COMPLETE','test1','ResourcesList-659869602-test1-bzsp3bx4b6oq','state changed','OS::Heat::TestResource',NULL,151),(736,'f6883e17-7739-4e71-9490-be7dacbc28ab','467c15a2-e4fa-4f46-8d34-5ef117eb7d87','2026-02-19 09:33:08',NULL,'DELETE','COMPLETE','ResourcesList-659869602','467c15a2-e4fa-4f46-8d34-5ef117eb7d87','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(737,'55c5e2ad-1295-4792-8748-75f03b07d7f9','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:09',NULL,'DELETE','IN_PROGRESS','sub_port_one','47db5fe4-baf2-4522-9c80-b8dd6d17888b','state changed','OS::Neutron::Port',NULL,144),(738,'8c99fd08-5124-41f6-8aab-dad134fe39b1','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:09',NULL,'DELETE','COMPLETE','parent_port','daa9ab07-668f-4041-936c-fba01d6f012a','state changed','OS::Neutron::Port',NULL,145),(739,'b8ffbb9a-080a-4385-b2a1-8714f0a888b5','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:09',NULL,'DELETE','IN_PROGRESS','parent_subnet','1ec11d97-c4e5-4adf-bb60-9656226df5f6','state changed','OS::Neutron::Subnet',NULL,142),(740,'eaaf0e6a-e915-40eb-bfef-cc6b0f0356bf','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:09',NULL,'DELETE','COMPLETE','sub_port_one','47db5fe4-baf2-4522-9c80-b8dd6d17888b','state changed','OS::Neutron::Port',NULL,144),(741,'dd0d5774-2f57-4f55-8947-98ab3cda6631','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:09',NULL,'DELETE','IN_PROGRESS','sub_port_two','e8b7f092-df49-48ba-b637-27d21113a956','state changed','OS::Neutron::Port',NULL,143),(742,'cd47cef8-2594-4b8e-97f0-ae6888d2a1ec','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:10',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','a4402840-4493-4c38-bf96-ebcf8e01f1d8','state changed','OS::Neutron::Subnet',NULL,141),(743,'48bd01a5-3b7e-4545-aecc-86e96d1f641b','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:10',NULL,'DELETE','COMPLETE','trunk_subnet_one','a4402840-4493-4c38-bf96-ebcf8e01f1d8','state changed','OS::Neutron::Subnet',NULL,141),(744,'8d40b847-4d46-4c25-b450-2222b15a4706','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:11',NULL,'DELETE','COMPLETE','parent_subnet','1ec11d97-c4e5-4adf-bb60-9656226df5f6','state changed','OS::Neutron::Subnet',NULL,142),(745,'9de0be34-18b6-4d11-a0b2-f19c17fd53ea','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:11',NULL,'DELETE','IN_PROGRESS','trunk_net_one','6a112068-5b31-4c27-8155-1e2cba5bf681','state changed','OS::Neutron::Net',NULL,NULL),(746,'f9b1db9f-c335-4d9f-90c8-af9937d71bf9','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:11',NULL,'DELETE','IN_PROGRESS','parent_net','69f27366-3e75-4fa2-ae6c-b4eee1ae97db','state changed','OS::Neutron::Net',NULL,NULL),(747,'7ee00143-8586-4cfd-8bc1-4ae4401dfe1b','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:11',NULL,'DELETE','COMPLETE','sub_port_two','e8b7f092-df49-48ba-b637-27d21113a956','state changed','OS::Neutron::Port',NULL,143),(748,'004899ad-9593-45c8-a59c-7e786fd0fda2','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:11',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','e0f4b6e3-243d-4394-9a03-384cd788d95b','state changed','OS::Neutron::Subnet',NULL,140),(749,'57057dac-80b3-4c0c-b43d-b337dba3f235','7397f5ae-bf96-4fc7-97e0-112eef907291','2026-02-19 09:33:11',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-1611783987','7397f5ae-bf96-4fc7-97e0-112eef907291','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(750,'75c5a0e1-9e1a-430f-a48e-6cbf5e8170a4','7397f5ae-bf96-4fc7-97e0-112eef907291','2026-02-19 09:33:11',NULL,'CREATE','IN_PROGRESS','my_stack','RemoteStackTest-1611783987-my_stack-bkgc3xi3zp5s','state changed','OS::Heat::Stack',NULL,155),(751,'76ade0c5-6f4c-42d7-9318-20b9a69b9066','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:11',NULL,'DELETE','COMPLETE','trunk_net_one','6a112068-5b31-4c27-8155-1e2cba5bf681','state changed','OS::Neutron::Net',NULL,NULL),(752,'1399a73c-0bb1-44b2-98b3-bcaa59f021b2','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:11',NULL,'DELETE','COMPLETE','trunk_subnet_two','e0f4b6e3-243d-4394-9a03-384cd788d95b','state changed','OS::Neutron::Subnet',NULL,140),(753,'8fe410f5-91df-4dbd-a948-ca43ce877be1','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:11',NULL,'DELETE','COMPLETE','parent_net','69f27366-3e75-4fa2-ae6c-b4eee1ae97db','state changed','OS::Neutron::Net',NULL,NULL),(754,'2aec729c-31bd-4172-853d-9caa388e12f1','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:11',NULL,'DELETE','IN_PROGRESS','trunk_net_two','29978b17-0ee6-40d5-9957-2718ac3d637e','state changed','OS::Neutron::Net',NULL,NULL),(755,'5ac9d65d-0181-4f23-b2c8-3b60a7c28aab','7323f31a-d82a-42dc-80d9-c7fc49532448','2026-02-19 09:33:12',NULL,'DELETE','COMPLETE','server','da2cb226-e0b7-4b62-a66b-af0370401938','state changed','OS::Nova::Server',NULL,147),(756,'6d6242e5-225a-4c6c-9227-2da07a9e19ef','7323f31a-d82a-42dc-80d9-c7fc49532448','2026-02-19 09:33:12',NULL,'DELETE','IN_PROGRESS','subnet','2d98b57b-4341-40ad-8740-02b95084c37f','state changed','OS::Neutron::Subnet',NULL,122),(757,'5e5a2447-d619-4d62-936b-b66bc4a73ef1','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:12',NULL,'DELETE','COMPLETE','trunk_net_two','29978b17-0ee6-40d5-9957-2718ac3d637e','state changed','OS::Neutron::Net',NULL,NULL),(758,'f49550ae-1ec9-4528-955a-5f529f37ecf1','d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:33:12',NULL,'DELETE','COMPLETE','UpdateTrunkTest-412893611','d0090fba-5a2b-4393-9536-c7a5457432aa','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(759,'6ac4828f-11ea-405f-9125-21c7a8af90a4','7323f31a-d82a-42dc-80d9-c7fc49532448','2026-02-19 09:33:12',NULL,'DELETE','COMPLETE','subnet','2d98b57b-4341-40ad-8740-02b95084c37f','state changed','OS::Neutron::Subnet',NULL,122),(760,'345e6b55-2ef5-4fc9-8335-0f1c613e79ae','7323f31a-d82a-42dc-80d9-c7fc49532448','2026-02-19 09:33:13',NULL,'DELETE','IN_PROGRESS','net','2c14d05b-1d30-4166-84b9-d2eaeb7b7f74','state changed','OS::Neutron::Net',NULL,121),(761,'e14cda62-ed92-4530-82b3-725f82766178','172ec054-588f-4068-8103-446353791256','2026-02-19 09:33:13',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-1611783987-my_stack-bkgc3xi3zp5s','172ec054-588f-4068-8103-446353791256','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(762,'c71df255-f049-4744-836c-da823a330b14','172ec054-588f-4068-8103-446353791256','2026-02-19 09:33:13',NULL,'CREATE','IN_PROGRESS','random1','RemoteStackTest-1611783987-my_stack-bkgc3xi3zp5s-random1-fen6qthyhg4t','state changed','OS::Heat::RandomString',NULL,NULL),(763,'8ca5dc9e-0ae5-4415-80c0-aeb0619995a0','172ec054-588f-4068-8103-446353791256','2026-02-19 09:33:13',NULL,'CREATE','COMPLETE','random1','RemoteStackTest-1611783987-my_stack-bkgc3xi3zp5s-random1-fen6qthyhg4t','state changed','OS::Heat::RandomString',NULL,NULL),(764,'4d82d2ad-93b4-4f6b-860e-fe40dd256b66','172ec054-588f-4068-8103-446353791256','2026-02-19 09:33:13',NULL,'CREATE','COMPLETE','RemoteStackTest-1611783987-my_stack-bkgc3xi3zp5s','172ec054-588f-4068-8103-446353791256','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(765,'29a06bca-509b-4e64-aa4f-7e03f07c6fdc','7397f5ae-bf96-4fc7-97e0-112eef907291','2026-02-19 09:33:13',NULL,'CREATE','COMPLETE','my_stack','172ec054-588f-4068-8103-446353791256','state changed','OS::Heat::Stack',NULL,155),(766,'83e38a03-5680-4209-901b-9a2c4ae894a7','7397f5ae-bf96-4fc7-97e0-112eef907291','2026-02-19 09:33:13',NULL,'CREATE','COMPLETE','RemoteStackTest-1611783987','7397f5ae-bf96-4fc7-97e0-112eef907291','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(767,'830edb58-1e38-4d7d-907e-63d867a72193','7323f31a-d82a-42dc-80d9-c7fc49532448','2026-02-19 09:33:13',NULL,'DELETE','COMPLETE','net','2c14d05b-1d30-4166-84b9-d2eaeb7b7f74','state changed','OS::Neutron::Net',NULL,121),(768,'9369a93b-ccd4-49a0-97b1-9c9910037d72','7323f31a-d82a-42dc-80d9-c7fc49532448','2026-02-19 09:33:13',NULL,'DELETE','COMPLETE','multi_networks_swaps','7323f31a-d82a-42dc-80d9-c7fc49532448','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(769,'ec2348d8-407e-490e-8056-fa710c9eccab','43ef9cc5-bc6f-4c49-babc-34c1c1fc0058','2026-02-19 09:33:14',NULL,'CREATE','IN_PROGRESS','StackOutputsTest-74234904','43ef9cc5-bc6f-4c49-babc-34c1c1fc0058','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(770,'e4a11c98-3205-4fbf-b3e9-96ebb81ee4c2','43ef9cc5-bc6f-4c49-babc-34c1c1fc0058','2026-02-19 09:33:14',NULL,'CREATE','IN_PROGRESS','parent','StackOutputsTest-74234904-parent-tuicwa24b5zf','state changed','1.yaml',NULL,NULL),(771,'e90b7996-3015-4a4f-a173-7186db1ceef2','05ac412c-ee47-41e6-93ca-a9f4afdf5119','2026-02-19 09:33:14',NULL,'CREATE','IN_PROGRESS','StackOutputsTest-74234904-parent-tuicwa24b5zf','05ac412c-ee47-41e6-93ca-a9f4afdf5119','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(772,'5ec7dc48-8063-4fbd-b2f8-146e620a82c4','05ac412c-ee47-41e6-93ca-a9f4afdf5119','2026-02-19 09:33:14',NULL,'CREATE','IN_PROGRESS','test_resource_a','StackOutputsTest-74234904-parent-tuicwa24b5zf-test_resource_a-rd7tlvlhbke3','state changed','OS::Heat::TestResource',NULL,156),(773,'ae0a54e6-1248-4561-8aa5-37ced0be980c','05ac412c-ee47-41e6-93ca-a9f4afdf5119','2026-02-19 09:33:14',NULL,'CREATE','COMPLETE','test_resource_a','StackOutputsTest-74234904-parent-tuicwa24b5zf-test_resource_a-rd7tlvlhbke3','state changed','OS::Heat::TestResource',NULL,156),(774,'9a285cfb-f68b-49c1-9978-151654e6e185','05ac412c-ee47-41e6-93ca-a9f4afdf5119','2026-02-19 09:33:16',NULL,'CREATE','IN_PROGRESS','test_resource_b','StackOutputsTest-74234904-parent-tuicwa24b5zf-test_resource_b-yinex62cqd4o','state changed','OS::Heat::TestResource',NULL,157),(775,'f31f586f-4740-4da5-938c-b8cdd9ec469a','05ac412c-ee47-41e6-93ca-a9f4afdf5119','2026-02-19 09:33:16',NULL,'CREATE','COMPLETE','test_resource_b','StackOutputsTest-74234904-parent-tuicwa24b5zf-test_resource_b-yinex62cqd4o','state changed','OS::Heat::TestResource',NULL,157),(776,'4b902331-8c4b-4557-ba22-941e8ff75fe5','05ac412c-ee47-41e6-93ca-a9f4afdf5119','2026-02-19 09:33:16',NULL,'CREATE','COMPLETE','StackOutputsTest-74234904-parent-tuicwa24b5zf','05ac412c-ee47-41e6-93ca-a9f4afdf5119','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(777,'76728166-b172-400b-8ad2-9a6b69bff62c','43ef9cc5-bc6f-4c49-babc-34c1c1fc0058','2026-02-19 09:33:17',NULL,'CREATE','COMPLETE','parent','05ac412c-ee47-41e6-93ca-a9f4afdf5119','state changed','1.yaml',NULL,NULL),(778,'1b88c667-a0c1-4481-9989-99b91e675f28','43ef9cc5-bc6f-4c49-babc-34c1c1fc0058','2026-02-19 09:33:17',NULL,'CREATE','COMPLETE','StackOutputsTest-74234904','43ef9cc5-bc6f-4c49-babc-34c1c1fc0058','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(779,'b27d2579-0dd4-4ea0-b619-f04a2a334d99','2955e463-ae36-41c5-be8c-13191c354c04','2026-02-19 09:33:18',NULL,'CREATE','IN_PROGRESS','HooksTest-1107949938','2955e463-ae36-41c5-be8c-13191c354c04','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(780,'e58bd37a-27b4-4d1a-8e1d-4d5596e0330f','2955e463-ae36-41c5-be8c-13191c354c04','2026-02-19 09:33:18',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-1107949938-foo_step1-zeyh2nwolg26','state changed','OS::Heat::RandomString',NULL,NULL),(781,'0d110d0c-46c3-4f87-b608-54852c42d7c9','2955e463-ae36-41c5-be8c-13191c354c04','2026-02-19 09:33:18',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-1107949938-foo_step1-zeyh2nwolg26','state changed','OS::Heat::RandomString',NULL,NULL),(782,'84181d50-eb5c-442e-a8f0-b12d4c23326e','2955e463-ae36-41c5-be8c-13191c354c04','2026-02-19 09:33:18',NULL,'INIT','COMPLETE','foo_step2',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(783,'ef7e1e6d-b837-42fd-a990-bab47d7d22f6','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','2026-02-19 09:33:18',NULL,'CREATE','IN_PROGRESS','swap_network_port','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(784,'4ab52f97-1e8b-4d59-bd9e-fcc4ed7cec72','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','2026-02-19 09:33:19',NULL,'CREATE','IN_PROGRESS','net','swap_network_port-net-4vo4ngnxdzxg','state changed','OS::Neutron::Net',NULL,159),(785,'f29e47b5-e6e5-43c9-a82b-e71fdbdd6bf6','7397f5ae-bf96-4fc7-97e0-112eef907291','2026-02-19 09:33:20',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-1611783987','7397f5ae-bf96-4fc7-97e0-112eef907291','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(786,'e2986e5e-28fe-40f9-9ae9-fa6853e1ebb4','43ef9cc5-bc6f-4c49-babc-34c1c1fc0058','2026-02-19 09:33:20',NULL,'UPDATE','IN_PROGRESS','StackOutputsTest-74234904','43ef9cc5-bc6f-4c49-babc-34c1c1fc0058','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(787,'a00929ce-2baa-4cf7-8ea5-885262dadbfb','7397f5ae-bf96-4fc7-97e0-112eef907291','2026-02-19 09:33:20',NULL,'DELETE','IN_PROGRESS','my_stack','172ec054-588f-4068-8103-446353791256','state changed','OS::Heat::Stack',NULL,155),(788,'a27edaf7-5d36-4c22-a0ae-94a2e43fbb2e','43ef9cc5-bc6f-4c49-babc-34c1c1fc0058','2026-02-19 09:33:20',NULL,'UPDATE','IN_PROGRESS','parent','05ac412c-ee47-41e6-93ca-a9f4afdf5119','state changed','1.yaml',NULL,NULL),(789,'94177b49-3f61-4f54-98d2-18986cd417ee','2955e463-ae36-41c5-be8c-13191c354c04','2026-02-19 09:33:21',NULL,'INIT','COMPLETE','foo_step2',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(790,'285d8f85-77d8-4fbd-9cf4-07afc3f13b00','172ec054-588f-4068-8103-446353791256','2026-02-19 09:33:21',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-1611783987-my_stack-bkgc3xi3zp5s','172ec054-588f-4068-8103-446353791256','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(791,'75f97234-a5c0-4d7f-9be0-b2d040a427bb','2955e463-ae36-41c5-be8c-13191c354c04','2026-02-19 09:33:21',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-1107949938-foo_step2-5szrv7544rwr','state changed','OS::Heat::RandomString',NULL,NULL),(792,'3d763ce5-b4eb-4eda-9fcb-fbf75ed78fe1','172ec054-588f-4068-8103-446353791256','2026-02-19 09:33:21',NULL,'DELETE','IN_PROGRESS','random1','RemoteStackTest-1611783987-my_stack-bkgc3xi3zp5s-random1-fen6qthyhg4t','state changed','OS::Heat::RandomString',NULL,NULL),(793,'74106282-a3ea-4112-9b97-f46577260161','172ec054-588f-4068-8103-446353791256','2026-02-19 09:33:21',NULL,'DELETE','COMPLETE','random1','RemoteStackTest-1611783987-my_stack-bkgc3xi3zp5s-random1-fen6qthyhg4t','state changed','OS::Heat::RandomString',NULL,NULL),(794,'62f8717d-acb7-4c03-bdaf-e5318631013a','172ec054-588f-4068-8103-446353791256','2026-02-19 09:33:21',NULL,'DELETE','COMPLETE','RemoteStackTest-1611783987-my_stack-bkgc3xi3zp5s','172ec054-588f-4068-8103-446353791256','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(795,'568f3591-e2cc-4bfa-9804-bf886837744f','7397f5ae-bf96-4fc7-97e0-112eef907291','2026-02-19 09:33:22',NULL,'DELETE','COMPLETE','my_stack','172ec054-588f-4068-8103-446353791256','state changed','OS::Heat::Stack',NULL,155),(796,'784c97a7-61f6-4095-9aa0-38eae40f76c9','05ac412c-ee47-41e6-93ca-a9f4afdf5119','2026-02-19 09:33:22',NULL,'UPDATE','IN_PROGRESS','StackOutputsTest-74234904-parent-tuicwa24b5zf','05ac412c-ee47-41e6-93ca-a9f4afdf5119','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(797,'28510dfd-9e00-4cfa-819f-cc63bb802b07','7397f5ae-bf96-4fc7-97e0-112eef907291','2026-02-19 09:33:22',NULL,'DELETE','COMPLETE','RemoteStackTest-1611783987','7397f5ae-bf96-4fc7-97e0-112eef907291','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(798,'7ac6ea94-9c58-4350-beb1-6c2e960813bb','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','2026-02-19 09:33:22',NULL,'CREATE','COMPLETE','net','47628df4-6d10-4d31-b75f-72945071e617','state changed','OS::Neutron::Net',NULL,159),(799,'d60497a6-4352-4131-aadb-7d8f11b00ed8','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','2026-02-19 09:33:22',NULL,'CREATE','IN_PROGRESS','subnet','swap_network_port-subnet-imidpkw32zhn','state changed','OS::Neutron::Subnet',NULL,160),(800,'7e456267-7919-44f2-b40b-e61443f1b43d','2955e463-ae36-41c5-be8c-13191c354c04','2026-02-19 09:33:22',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1107949938-foo_step2-5szrv7544rwr','state changed','OS::Heat::RandomString',NULL,NULL),(801,'9c8530ff-d1ba-4d12-930f-b609a3cdf45d','2955e463-ae36-41c5-be8c-13191c354c04','2026-02-19 09:33:22',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-1107949938-foo_step3-vxxg3eqc2gho','state changed','OS::Heat::RandomString',NULL,NULL),(802,'078b057b-c799-47db-b9a0-785ee0dbec49','2955e463-ae36-41c5-be8c-13191c354c04','2026-02-19 09:33:22',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-1107949938-foo_step3-vxxg3eqc2gho','state changed','OS::Heat::RandomString',NULL,NULL),(803,'61b11977-aa65-48cf-b12b-05baf69cfeaa','2955e463-ae36-41c5-be8c-13191c354c04','2026-02-19 09:33:22',NULL,'CREATE','COMPLETE','HooksTest-1107949938','2955e463-ae36-41c5-be8c-13191c354c04','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(804,'a30b293d-1809-4d50-9a85-75360b6e486b','05ac412c-ee47-41e6-93ca-a9f4afdf5119','2026-02-19 09:33:23',NULL,'UPDATE','COMPLETE','StackOutputsTest-74234904-parent-tuicwa24b5zf','05ac412c-ee47-41e6-93ca-a9f4afdf5119','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(805,'05d034b1-308c-417d-b490-e89e6a29e29b','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','2026-02-19 09:33:23',NULL,'CREATE','COMPLETE','subnet','b3013267-d087-4693-91f3-43bf5756a66f','state changed','OS::Neutron::Subnet',NULL,160),(806,'04f0cac1-17fb-4d00-afeb-5497433a6b6b','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','2026-02-19 09:33:23',NULL,'CREATE','IN_PROGRESS','server','swap_network_port-server-lpmscamvhq6t','state changed','OS::Nova::Server',NULL,161),(807,'26215741-a56e-425c-aaa7-83b19f6a4aad','43ef9cc5-bc6f-4c49-babc-34c1c1fc0058','2026-02-19 09:33:24',NULL,'UPDATE','COMPLETE','parent','05ac412c-ee47-41e6-93ca-a9f4afdf5119','state changed','1.yaml',NULL,NULL),(808,'4df63d0c-3093-4bfb-9364-fa32af61c19b','43ef9cc5-bc6f-4c49-babc-34c1c1fc0058','2026-02-19 09:33:24',NULL,'UPDATE','COMPLETE','StackOutputsTest-74234904','43ef9cc5-bc6f-4c49-babc-34c1c1fc0058','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(809,'3b0fc8f9-0fd8-4e15-b89d-b53defb74280','43ef9cc5-bc6f-4c49-babc-34c1c1fc0058','2026-02-19 09:33:25',NULL,'DELETE','IN_PROGRESS','StackOutputsTest-74234904','43ef9cc5-bc6f-4c49-babc-34c1c1fc0058','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(810,'3f7eee97-3af4-4e04-9661-ca9c808cc136','43ef9cc5-bc6f-4c49-babc-34c1c1fc0058','2026-02-19 09:33:25',NULL,'DELETE','IN_PROGRESS','parent','05ac412c-ee47-41e6-93ca-a9f4afdf5119','state changed','1.yaml',NULL,NULL),(811,'d33fbfb9-4523-4010-b78b-aee751089367','05ac412c-ee47-41e6-93ca-a9f4afdf5119','2026-02-19 09:33:25',NULL,'DELETE','IN_PROGRESS','StackOutputsTest-74234904-parent-tuicwa24b5zf','05ac412c-ee47-41e6-93ca-a9f4afdf5119','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(812,'e0a44256-d31b-44dc-9580-1c39316ed145','05ac412c-ee47-41e6-93ca-a9f4afdf5119','2026-02-19 09:33:25',NULL,'DELETE','IN_PROGRESS','test_resource_b','StackOutputsTest-74234904-parent-tuicwa24b5zf-test_resource_b-yinex62cqd4o','state changed','OS::Heat::TestResource',NULL,157),(813,'3326c0f3-ecf4-4043-8e6c-d745f3e522bf','05ac412c-ee47-41e6-93ca-a9f4afdf5119','2026-02-19 09:33:25',NULL,'DELETE','COMPLETE','test_resource_b','StackOutputsTest-74234904-parent-tuicwa24b5zf-test_resource_b-yinex62cqd4o','state changed','OS::Heat::TestResource',NULL,157),(814,'57556335-f9cf-49c1-a2ca-21df589f7d62','2955e463-ae36-41c5-be8c-13191c354c04','2026-02-19 09:33:26',NULL,'DELETE','IN_PROGRESS','HooksTest-1107949938','2955e463-ae36-41c5-be8c-13191c354c04','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(815,'ca855e2b-1701-480b-9030-904b05410926','2955e463-ae36-41c5-be8c-13191c354c04','2026-02-19 09:33:26',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-1107949938-foo_step3-vxxg3eqc2gho','state changed','OS::Heat::RandomString',NULL,NULL),(816,'bcee5e10-c07c-45fe-bd02-48dd8e2b9104','2955e463-ae36-41c5-be8c-13191c354c04','2026-02-19 09:33:26',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-1107949938-foo_step3-vxxg3eqc2gho','state changed','OS::Heat::RandomString',NULL,NULL),(817,'a219ce42-0e21-4b7e-bb21-2114f6f468d8','2955e463-ae36-41c5-be8c-13191c354c04','2026-02-19 09:33:26',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-1107949938-foo_step2-5szrv7544rwr','state changed','OS::Heat::RandomString',NULL,NULL),(818,'6c85fa49-5a05-4ecc-8706-6cac167f925b','2955e463-ae36-41c5-be8c-13191c354c04','2026-02-19 09:33:26',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-1107949938-foo_step2-5szrv7544rwr','state changed','OS::Heat::RandomString',NULL,NULL),(819,'6255b7ca-856c-488b-9f3b-29e0bccce675','05ac412c-ee47-41e6-93ca-a9f4afdf5119','2026-02-19 09:33:26',NULL,'DELETE','IN_PROGRESS','test_resource_a','StackOutputsTest-74234904-parent-tuicwa24b5zf-test_resource_a-rd7tlvlhbke3','state changed','OS::Heat::TestResource',NULL,156),(820,'e5506b3d-7f01-4c19-9cf0-c647a5f385ca','05ac412c-ee47-41e6-93ca-a9f4afdf5119','2026-02-19 09:33:26',NULL,'DELETE','COMPLETE','test_resource_a','StackOutputsTest-74234904-parent-tuicwa24b5zf-test_resource_a-rd7tlvlhbke3','state changed','OS::Heat::TestResource',NULL,156),(821,'32f033a6-2ac6-447c-9642-3f7bf482094c','2955e463-ae36-41c5-be8c-13191c354c04','2026-02-19 09:33:26',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-1107949938-foo_step1-zeyh2nwolg26','state changed','OS::Heat::RandomString',NULL,NULL),(822,'92a1b743-9b60-4a6e-b513-ef3450a5d685','2955e463-ae36-41c5-be8c-13191c354c04','2026-02-19 09:33:26',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-1107949938-foo_step1-zeyh2nwolg26','state changed','OS::Heat::RandomString',NULL,NULL),(823,'5683292b-807c-4288-b16f-5a8ef4b4e55f','05ac412c-ee47-41e6-93ca-a9f4afdf5119','2026-02-19 09:33:26',NULL,'DELETE','COMPLETE','StackOutputsTest-74234904-parent-tuicwa24b5zf','05ac412c-ee47-41e6-93ca-a9f4afdf5119','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(824,'fb02fbf0-9f87-4930-ab92-873ed09b5529','2955e463-ae36-41c5-be8c-13191c354c04','2026-02-19 09:33:26',NULL,'DELETE','COMPLETE','HooksTest-1107949938','2955e463-ae36-41c5-be8c-13191c354c04','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(825,'1ceb557a-7b94-4f1d-ae10-11825b4c7c7d','43ef9cc5-bc6f-4c49-babc-34c1c1fc0058','2026-02-19 09:33:27',NULL,'DELETE','COMPLETE','parent','05ac412c-ee47-41e6-93ca-a9f4afdf5119','state changed','1.yaml',NULL,NULL),(826,'4a39dc06-16dd-4cb4-b7b0-be933ddc1f27','43ef9cc5-bc6f-4c49-babc-34c1c1fc0058','2026-02-19 09:33:27',NULL,'DELETE','COMPLETE','StackOutputsTest-74234904','43ef9cc5-bc6f-4c49-babc-34c1c1fc0058','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(827,'6bd5a3d0-76e5-4b11-ad05-a9e8ac1b6eee','581b72a8-3d44-4e63-801f-c5a65bc03985','2026-02-19 09:33:28',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-2136910817','581b72a8-3d44-4e63-801f-c5a65bc03985','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(828,'21d165fc-f00e-41bc-b761-b83ef9556f12','581b72a8-3d44-4e63-801f-c5a65bc03985','2026-02-19 09:33:28',NULL,'CREATE','IN_PROGRESS','my_stack','RemoteStackTest-2136910817-my_stack-55nl6c6j3mfa','state changed','OS::Heat::Stack',NULL,163),(829,'d76ff6e5-99b1-4754-996d-c968fe2751a1','d237f286-5dda-4a43-ad25-882528fa8c69','2026-02-19 09:33:29',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-2136910817-my_stack-55nl6c6j3mfa','d237f286-5dda-4a43-ad25-882528fa8c69','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(830,'f1e1f8e4-43be-465b-91a1-d0c32cddedb6','d237f286-5dda-4a43-ad25-882528fa8c69','2026-02-19 09:33:29',NULL,'CREATE','IN_PROGRESS','random1','RemoteStackTest-2136910817-my_stack-55nl6c6j3mfa-random1-wvosq44iizhq','state changed','OS::Heat::RandomString',NULL,NULL),(831,'ec497087-0882-4c06-a018-6fc149cb1101','d237f286-5dda-4a43-ad25-882528fa8c69','2026-02-19 09:33:29',NULL,'CREATE','COMPLETE','random1','RemoteStackTest-2136910817-my_stack-55nl6c6j3mfa-random1-wvosq44iizhq','state changed','OS::Heat::RandomString',NULL,NULL),(832,'a4a2ff3e-3b97-42eb-b6bc-fd0029541f04','d237f286-5dda-4a43-ad25-882528fa8c69','2026-02-19 09:33:29',NULL,'CREATE','COMPLETE','RemoteStackTest-2136910817-my_stack-55nl6c6j3mfa','d237f286-5dda-4a43-ad25-882528fa8c69','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(833,'7b82e48b-406e-47c1-a6ee-76c827eeb4a1','581b72a8-3d44-4e63-801f-c5a65bc03985','2026-02-19 09:33:30',NULL,'CREATE','COMPLETE','my_stack','d237f286-5dda-4a43-ad25-882528fa8c69','state changed','OS::Heat::Stack',NULL,163),(834,'de23a565-5dbc-4906-b9f5-77e166014004','581b72a8-3d44-4e63-801f-c5a65bc03985','2026-02-19 09:33:30',NULL,'CREATE','COMPLETE','RemoteStackTest-2136910817','581b72a8-3d44-4e63-801f-c5a65bc03985','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(835,'15a5c90d-faa4-46fc-92bd-4daf0bef8d8d','839083b9-29fa-4e62-9f9f-465e9b9fb990','2026-02-19 09:33:31',NULL,'CREATE','IN_PROGRESS','StackOutputsTest-1998979152','839083b9-29fa-4e62-9f9f-465e9b9fb990','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(836,'3fc89f78-a222-4505-8790-41e8d1c75856','839083b9-29fa-4e62-9f9f-465e9b9fb990','2026-02-19 09:33:31',NULL,'CREATE','IN_PROGRESS','test_resource_b','StackOutputsTest-1998979152-test_resource_b-vcakx55l2yhb','state changed','OS::Heat::TestResource',NULL,164),(837,'c41acd4f-ad94-4ea7-a039-9e50b62c4ab5','839083b9-29fa-4e62-9f9f-465e9b9fb990','2026-02-19 09:33:31',NULL,'CREATE','COMPLETE','test_resource_b','StackOutputsTest-1998979152-test_resource_b-vcakx55l2yhb','state changed','OS::Heat::TestResource',NULL,164),(838,'4005dbcd-2124-4ec0-811a-0c2e69101cb5','ddf85b97-ba1f-45cf-b661-2799a3ceda32','2026-02-19 09:33:32',NULL,'CREATE','IN_PROGRESS','HooksTest-172485013','ddf85b97-ba1f-45cf-b661-2799a3ceda32','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(839,'4ae149a2-4a5e-4361-82f3-1bdd43ba7678','ddf85b97-ba1f-45cf-b661-2799a3ceda32','2026-02-19 09:33:32',NULL,'CREATE','IN_PROGRESS','nested','HooksTest-172485013-nested-eskijeswsq5y','state changed','nested.yaml',NULL,NULL),(840,'1a66fc1b-8649-44be-8a3d-fd5b7d1038c7','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','2026-02-19 09:33:32',NULL,'CREATE','IN_PROGRESS','HooksTest-172485013-nested-eskijeswsq5y','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(841,'9a74322d-75b1-419d-9bc9-d058fe944ebe','839083b9-29fa-4e62-9f9f-465e9b9fb990','2026-02-19 09:33:32',NULL,'CREATE','IN_PROGRESS','test_resource_a','StackOutputsTest-1998979152-test_resource_a-aoukd4e4hkbg','state changed','OS::Heat::TestResource',NULL,165),(842,'256321b8-d9fd-4311-ab65-e5e67443dac3','839083b9-29fa-4e62-9f9f-465e9b9fb990','2026-02-19 09:33:32',NULL,'CREATE','COMPLETE','test_resource_a','StackOutputsTest-1998979152-test_resource_a-aoukd4e4hkbg','state changed','OS::Heat::TestResource',NULL,165),(843,'bcc04c7f-1681-4bd3-a986-4a19c2e2b9ab','839083b9-29fa-4e62-9f9f-465e9b9fb990','2026-02-19 09:33:32',NULL,'CREATE','COMPLETE','StackOutputsTest-1998979152','839083b9-29fa-4e62-9f9f-465e9b9fb990','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(844,'d92e53dd-f8e9-49fe-bc63-c1a446d7bbac','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','2026-02-19 09:33:32',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-172485013-nested-eskijeswsq5y-foo_step1-fje4xsghu3xb','state changed','OS::Heat::RandomString',NULL,NULL),(845,'6d4f9df7-d09c-4618-ac90-80ce06b97560','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','2026-02-19 09:33:32',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-172485013-nested-eskijeswsq5y-foo_step1-fje4xsghu3xb','state changed','OS::Heat::RandomString',NULL,NULL),(846,'de39dcfa-d3f7-4391-abe3-4cb72092190f','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','2026-02-19 09:33:32',NULL,'INIT','COMPLETE','foo_step2',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(847,'b522331d-7146-4f65-b1f0-db1d1c8e2afc','581b72a8-3d44-4e63-801f-c5a65bc03985','2026-02-19 09:33:33',NULL,'SUSPEND','IN_PROGRESS','RemoteStackTest-2136910817','581b72a8-3d44-4e63-801f-c5a65bc03985','Stack SUSPEND started','OS::Heat::Stack',NULL,NULL),(848,'f508d721-2795-4c54-989d-d10b9cc080a1','581b72a8-3d44-4e63-801f-c5a65bc03985','2026-02-19 09:33:33',NULL,'SUSPEND','IN_PROGRESS','my_stack','d237f286-5dda-4a43-ad25-882528fa8c69','state changed','OS::Heat::Stack',NULL,163),(849,'a2414883-f843-4bb8-a6dd-ed4927a33231','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','2026-02-19 09:33:33',NULL,'CREATE','COMPLETE','server','5451f05b-3841-4619-956a-ca4f5d6fbf4c','state changed','OS::Nova::Server',NULL,161),(850,'8e2251ed-4fcc-40b7-b174-6e99affa442e','d237f286-5dda-4a43-ad25-882528fa8c69','2026-02-19 09:33:33',NULL,'SUSPEND','IN_PROGRESS','RemoteStackTest-2136910817-my_stack-55nl6c6j3mfa','d237f286-5dda-4a43-ad25-882528fa8c69','Stack SUSPEND started','OS::Heat::Stack',NULL,NULL),(851,'6e92e0e0-f91e-44ab-ba1e-fa11c45c9c1f','d237f286-5dda-4a43-ad25-882528fa8c69','2026-02-19 09:33:33',NULL,'SUSPEND','IN_PROGRESS','random1','RemoteStackTest-2136910817-my_stack-55nl6c6j3mfa-random1-wvosq44iizhq','state changed','OS::Heat::RandomString',NULL,NULL),(852,'0d67e19d-60e2-4959-acab-b66008a54940','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','2026-02-19 09:33:33',NULL,'CREATE','COMPLETE','swap_network_port','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(853,'e26bb9a0-7709-4d6d-bb67-7b51c7f942a8','d237f286-5dda-4a43-ad25-882528fa8c69','2026-02-19 09:33:33',NULL,'SUSPEND','COMPLETE','random1','RemoteStackTest-2136910817-my_stack-55nl6c6j3mfa-random1-wvosq44iizhq','state changed','OS::Heat::RandomString',NULL,NULL),(854,'3e57d1ec-5a1a-4945-8505-8a634619354e','d237f286-5dda-4a43-ad25-882528fa8c69','2026-02-19 09:33:33',NULL,'SUSPEND','COMPLETE','RemoteStackTest-2136910817-my_stack-55nl6c6j3mfa','d237f286-5dda-4a43-ad25-882528fa8c69','Stack SUSPEND completed successfully','OS::Heat::Stack',NULL,NULL),(855,'89a58f0a-5153-4000-b393-a037bca7b3d0','581b72a8-3d44-4e63-801f-c5a65bc03985','2026-02-19 09:33:34',NULL,'SUSPEND','COMPLETE','my_stack','d237f286-5dda-4a43-ad25-882528fa8c69','state changed','OS::Heat::Stack',NULL,163),(856,'f6a02a2e-8c6a-442d-a9cf-62927ebb79b3','581b72a8-3d44-4e63-801f-c5a65bc03985','2026-02-19 09:33:34',NULL,'SUSPEND','COMPLETE','RemoteStackTest-2136910817','581b72a8-3d44-4e63-801f-c5a65bc03985','Stack SUSPEND completed successfully','OS::Heat::Stack',NULL,NULL),(857,'ad602f60-4111-4fd1-b833-adbb867aff99','839083b9-29fa-4e62-9f9f-465e9b9fb990','2026-02-19 09:33:36',NULL,'DELETE','IN_PROGRESS','StackOutputsTest-1998979152','839083b9-29fa-4e62-9f9f-465e9b9fb990','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(858,'56d92239-0432-4320-901b-84aa85abb074','839083b9-29fa-4e62-9f9f-465e9b9fb990','2026-02-19 09:33:36',NULL,'DELETE','IN_PROGRESS','test_resource_a','StackOutputsTest-1998979152-test_resource_a-aoukd4e4hkbg','state changed','OS::Heat::TestResource',NULL,165),(859,'45093888-d7da-4899-858c-81b81827740f','839083b9-29fa-4e62-9f9f-465e9b9fb990','2026-02-19 09:33:36',NULL,'DELETE','COMPLETE','test_resource_a','StackOutputsTest-1998979152-test_resource_a-aoukd4e4hkbg','state changed','OS::Heat::TestResource',NULL,165),(860,'098f7dd5-4cc0-4dd4-9f58-8c944541c92b','839083b9-29fa-4e62-9f9f-465e9b9fb990','2026-02-19 09:33:41',NULL,'DELETE','IN_PROGRESS','test_resource_b','StackOutputsTest-1998979152-test_resource_b-vcakx55l2yhb','state changed','OS::Heat::TestResource',NULL,164),(861,'6f80d2db-590a-4f5e-95df-9ae5d0795f26','839083b9-29fa-4e62-9f9f-465e9b9fb990','2026-02-19 09:33:42',NULL,'DELETE','COMPLETE','test_resource_b','StackOutputsTest-1998979152-test_resource_b-vcakx55l2yhb','state changed','OS::Heat::TestResource',NULL,164),(862,'0607d79e-5344-4ea2-ab26-325b686c4a29','839083b9-29fa-4e62-9f9f-465e9b9fb990','2026-02-19 09:33:43',NULL,'DELETE','COMPLETE','StackOutputsTest-1998979152','839083b9-29fa-4e62-9f9f-465e9b9fb990','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(863,'80e49120-d973-45ad-b132-396a011a306b','581b72a8-3d44-4e63-801f-c5a65bc03985','2026-02-19 09:33:43',NULL,'RESUME','IN_PROGRESS','RemoteStackTest-2136910817','581b72a8-3d44-4e63-801f-c5a65bc03985','Stack RESUME started','OS::Heat::Stack',NULL,NULL),(864,'8f4a84ea-e9d6-4da6-bb20-22ca80267ab3','581b72a8-3d44-4e63-801f-c5a65bc03985','2026-02-19 09:33:44',NULL,'RESUME','IN_PROGRESS','my_stack','d237f286-5dda-4a43-ad25-882528fa8c69','state changed','OS::Heat::Stack',NULL,163),(865,'7d5b058b-f705-4a0c-97be-50abb5b79cbc','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','2026-02-19 09:33:45',NULL,'INIT','COMPLETE','foo_step2',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(866,'f8826fae-a3c2-45d0-8690-674285b2041d','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','2026-02-19 09:33:45',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-172485013-nested-eskijeswsq5y-foo_step2-tjf2jssik7pf','state changed','OS::Heat::RandomString',NULL,NULL),(867,'9e2033eb-ab10-4444-b2b6-d5f241f8af21','d237f286-5dda-4a43-ad25-882528fa8c69','2026-02-19 09:33:45',NULL,'RESUME','IN_PROGRESS','RemoteStackTest-2136910817-my_stack-55nl6c6j3mfa','d237f286-5dda-4a43-ad25-882528fa8c69','Stack RESUME started','OS::Heat::Stack',NULL,NULL),(868,'447fec69-f3ee-4e49-b8ef-2329fdafa545','d237f286-5dda-4a43-ad25-882528fa8c69','2026-02-19 09:33:45',NULL,'RESUME','IN_PROGRESS','random1','RemoteStackTest-2136910817-my_stack-55nl6c6j3mfa-random1-wvosq44iizhq','state changed','OS::Heat::RandomString',NULL,NULL),(869,'982f9a31-ab9d-4409-8569-2cf2676482fc','d237f286-5dda-4a43-ad25-882528fa8c69','2026-02-19 09:33:45',NULL,'RESUME','COMPLETE','random1','RemoteStackTest-2136910817-my_stack-55nl6c6j3mfa-random1-wvosq44iizhq','state changed','OS::Heat::RandomString',NULL,NULL),(870,'5fb42a2f-161d-4988-a140-d5989e88665c','d237f286-5dda-4a43-ad25-882528fa8c69','2026-02-19 09:33:45',NULL,'RESUME','COMPLETE','RemoteStackTest-2136910817-my_stack-55nl6c6j3mfa','d237f286-5dda-4a43-ad25-882528fa8c69','Stack RESUME completed successfully','OS::Heat::Stack',NULL,NULL),(871,'671a2241-a783-4710-a8d2-612029c64722','581b72a8-3d44-4e63-801f-c5a65bc03985','2026-02-19 09:33:45',NULL,'RESUME','COMPLETE','my_stack','d237f286-5dda-4a43-ad25-882528fa8c69','state changed','OS::Heat::Stack',NULL,163),(872,'1ea76a7d-aa99-4a63-80d5-892e24e09463','581b72a8-3d44-4e63-801f-c5a65bc03985','2026-02-19 09:33:45',NULL,'RESUME','COMPLETE','RemoteStackTest-2136910817','581b72a8-3d44-4e63-801f-c5a65bc03985','Stack RESUME completed successfully','OS::Heat::Stack',NULL,NULL),(873,'386ffe4c-ec05-4582-b0c3-07d7f4abadd9','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','2026-02-19 09:33:46',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-172485013-nested-eskijeswsq5y-foo_step2-tjf2jssik7pf','state changed','OS::Heat::RandomString',NULL,NULL),(874,'cd71e3cb-456e-46f1-8d42-478876852e5e','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','2026-02-19 09:33:46',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-172485013-nested-eskijeswsq5y-foo_step3-gwmqisu4noox','state changed','OS::Heat::RandomString',NULL,NULL),(875,'771ad057-fc73-46df-a4c9-8c82ea559fcb','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','2026-02-19 09:33:46',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-172485013-nested-eskijeswsq5y-foo_step3-gwmqisu4noox','state changed','OS::Heat::RandomString',NULL,NULL),(876,'f5b4da06-0f47-41d8-be2e-fa7530e4057f','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','2026-02-19 09:33:46',NULL,'CREATE','COMPLETE','HooksTest-172485013-nested-eskijeswsq5y','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(877,'40cbf09e-b041-4260-9210-f4c733e60ffd','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','2026-02-19 09:33:47',NULL,'UPDATE','IN_PROGRESS','swap_network_port','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(878,'f217d79d-d911-41b9-bfac-98539179369b','ddf85b97-ba1f-45cf-b661-2799a3ceda32','2026-02-19 09:33:47',NULL,'CREATE','COMPLETE','nested','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','state changed','nested.yaml',NULL,NULL),(879,'9ac43ae7-a1fd-46ff-9f3f-1072ada8febd','ddf85b97-ba1f-45cf-b661-2799a3ceda32','2026-02-19 09:33:48',NULL,'CREATE','COMPLETE','HooksTest-172485013','ddf85b97-ba1f-45cf-b661-2799a3ceda32','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(880,'eccccdcb-b3d4-4e14-9550-946a5e2e6fd9','4ef52f85-9b3e-4d6a-a863-b1a613b430af','2026-02-19 09:33:49',NULL,'CREATE','IN_PROGRESS','StackOutputsTest-653190073','4ef52f85-9b3e-4d6a-a863-b1a613b430af','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(881,'69cd1f94-cad2-44e3-a657-b16fac6925b8','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','2026-02-19 09:33:49',NULL,'UPDATE','IN_PROGRESS','server','5451f05b-3841-4619-956a-ca4f5d6fbf4c','state changed','OS::Nova::Server',NULL,161),(882,'ac5cb1d0-6ed6-4d08-940b-ea9c55713df3','4ef52f85-9b3e-4d6a-a863-b1a613b430af','2026-02-19 09:33:50',NULL,'CREATE','IN_PROGRESS','test_resource_a','StackOutputsTest-653190073-test_resource_a-ijuepyypn7xr','state changed','OS::Heat::TestResource',NULL,167),(883,'1cd4f140-29a7-499d-968e-9f938e14c0a0','ddf85b97-ba1f-45cf-b661-2799a3ceda32','2026-02-19 09:33:50',NULL,'DELETE','IN_PROGRESS','HooksTest-172485013','ddf85b97-ba1f-45cf-b661-2799a3ceda32','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(884,'74bba83c-432d-4561-969d-4d522d0c5abc','4ef52f85-9b3e-4d6a-a863-b1a613b430af','2026-02-19 09:33:50',NULL,'CREATE','COMPLETE','test_resource_a','StackOutputsTest-653190073-test_resource_a-ijuepyypn7xr','state changed','OS::Heat::TestResource',NULL,167),(885,'e997d18e-2c11-4338-97c8-ccc401687eb2','4ef52f85-9b3e-4d6a-a863-b1a613b430af','2026-02-19 09:33:51',NULL,'CREATE','COMPLETE','StackOutputsTest-653190073','4ef52f85-9b3e-4d6a-a863-b1a613b430af','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(886,'03308c17-8d31-4bfb-bbd9-3b3676bfd5f8','581b72a8-3d44-4e63-801f-c5a65bc03985','2026-02-19 09:33:51',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-2136910817','581b72a8-3d44-4e63-801f-c5a65bc03985','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(887,'9ad90a79-3775-4f67-81c4-a154df85ab84','ddf85b97-ba1f-45cf-b661-2799a3ceda32','2026-02-19 09:33:51',NULL,'DELETE','IN_PROGRESS','nested','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','state changed','nested.yaml',NULL,NULL),(888,'af555fa6-a9d5-4685-88f3-2a697e863140','581b72a8-3d44-4e63-801f-c5a65bc03985','2026-02-19 09:33:51',NULL,'DELETE','IN_PROGRESS','my_stack','d237f286-5dda-4a43-ad25-882528fa8c69','state changed','OS::Heat::Stack',NULL,163),(889,'859a8cbb-c7f4-4b28-afcf-6ecc91f05f75','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','2026-02-19 09:33:51',NULL,'DELETE','IN_PROGRESS','HooksTest-172485013-nested-eskijeswsq5y','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(890,'41e59a7a-6619-4ba6-b497-786ae18b443c','d237f286-5dda-4a43-ad25-882528fa8c69','2026-02-19 09:33:52',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-2136910817-my_stack-55nl6c6j3mfa','d237f286-5dda-4a43-ad25-882528fa8c69','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(891,'c193584b-7ef3-4c42-b900-2fce642b10c7','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','2026-02-19 09:33:52',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-172485013-nested-eskijeswsq5y-foo_step3-gwmqisu4noox','state changed','OS::Heat::RandomString',NULL,NULL),(892,'31430504-57b0-46ac-8151-430b45973833','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','2026-02-19 09:33:52',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-172485013-nested-eskijeswsq5y-foo_step3-gwmqisu4noox','state changed','OS::Heat::RandomString',NULL,NULL),(893,'7c1700e3-aa0a-4642-9966-b3701250db20','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','2026-02-19 09:33:52',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-172485013-nested-eskijeswsq5y-foo_step2-tjf2jssik7pf','state changed','OS::Heat::RandomString',NULL,NULL),(894,'85a88820-3bf2-47d7-b704-b7d091df1f82','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','2026-02-19 09:33:52',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-172485013-nested-eskijeswsq5y-foo_step2-tjf2jssik7pf','state changed','OS::Heat::RandomString',NULL,NULL),(895,'8f211f5e-45db-42cf-94dd-b746c923d3c7','d237f286-5dda-4a43-ad25-882528fa8c69','2026-02-19 09:33:53',NULL,'DELETE','IN_PROGRESS','random1','RemoteStackTest-2136910817-my_stack-55nl6c6j3mfa-random1-wvosq44iizhq','state changed','OS::Heat::RandomString',NULL,NULL),(896,'ddd17098-4135-440b-b06d-9a3ee874ef9d','d237f286-5dda-4a43-ad25-882528fa8c69','2026-02-19 09:33:53',NULL,'DELETE','COMPLETE','random1','RemoteStackTest-2136910817-my_stack-55nl6c6j3mfa-random1-wvosq44iizhq','state changed','OS::Heat::RandomString',NULL,NULL),(897,'f22106e2-77e1-4879-a407-5a8b2d1323f5','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','2026-02-19 09:33:53',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-172485013-nested-eskijeswsq5y-foo_step1-fje4xsghu3xb','state changed','OS::Heat::RandomString',NULL,NULL),(898,'5596ceb9-9a22-49f9-a652-2a78cf7759f8','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','2026-02-19 09:33:53',NULL,'UPDATE','COMPLETE','server','5451f05b-3841-4619-956a-ca4f5d6fbf4c','state changed','OS::Nova::Server',NULL,168),(899,'ab80e630-5465-4fcf-a1de-eb8f5cf716d9','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','2026-02-19 09:33:53',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-172485013-nested-eskijeswsq5y-foo_step1-fje4xsghu3xb','state changed','OS::Heat::RandomString',NULL,NULL),(900,'b0c870d3-bbd1-4086-b757-e32f4c8f25c0','d237f286-5dda-4a43-ad25-882528fa8c69','2026-02-19 09:33:53',NULL,'DELETE','COMPLETE','RemoteStackTest-2136910817-my_stack-55nl6c6j3mfa','d237f286-5dda-4a43-ad25-882528fa8c69','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(901,'d5be85de-e5a1-46eb-8892-b5641f3fae8d','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','2026-02-19 09:33:54',NULL,'DELETE','COMPLETE','HooksTest-172485013-nested-eskijeswsq5y','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(902,'48176cc0-89a6-4403-83df-cb9cc35a4b1e','581b72a8-3d44-4e63-801f-c5a65bc03985','2026-02-19 09:33:54',NULL,'DELETE','COMPLETE','my_stack','d237f286-5dda-4a43-ad25-882528fa8c69','state changed','OS::Heat::Stack',NULL,163),(903,'2be4212a-7451-4be5-b1a8-4086221957a5','581b72a8-3d44-4e63-801f-c5a65bc03985','2026-02-19 09:33:54',NULL,'DELETE','COMPLETE','RemoteStackTest-2136910817','581b72a8-3d44-4e63-801f-c5a65bc03985','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(904,'5122d8b5-2671-4e2d-80c3-4e754916142d','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','2026-02-19 09:33:54',NULL,'UPDATE','COMPLETE','swap_network_port','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(905,'4df48393-37cc-4750-9f75-1f9318aa7900','ddf85b97-ba1f-45cf-b661-2799a3ceda32','2026-02-19 09:33:55',NULL,'DELETE','COMPLETE','nested','0ccb8343-ef74-46de-92f4-1c45ee6e8d95','state changed','nested.yaml',NULL,NULL),(906,'41e7e466-55a3-4b8a-9f45-2674e9df46e3','ddf85b97-ba1f-45cf-b661-2799a3ceda32','2026-02-19 09:33:55',NULL,'DELETE','COMPLETE','HooksTest-172485013','ddf85b97-ba1f-45cf-b661-2799a3ceda32','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(907,'aebffdcd-96b3-4e0b-ba2e-4a9fa09792f8','4ef52f85-9b3e-4d6a-a863-b1a613b430af','2026-02-19 09:33:55',NULL,'UPDATE','IN_PROGRESS','StackOutputsTest-653190073','4ef52f85-9b3e-4d6a-a863-b1a613b430af','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(908,'5776b6de-1c2f-474c-93d3-0a21f646b618','4ef52f85-9b3e-4d6a-a863-b1a613b430af','2026-02-19 09:33:56',NULL,'CREATE','IN_PROGRESS','test_resource_b','StackOutputsTest-653190073-test_resource_b-ggecpgoz3cpy','state changed','OS::Heat::TestResource',NULL,169),(909,'a99e2a11-75d5-49ca-a8cd-6255b1e193f3','4ef52f85-9b3e-4d6a-a863-b1a613b430af','2026-02-19 09:33:56',NULL,'CREATE','COMPLETE','test_resource_b','StackOutputsTest-653190073-test_resource_b-ggecpgoz3cpy','state changed','OS::Heat::TestResource',NULL,169),(910,'1c091ef4-1168-4217-9334-32a8f4af0ba7','4ef52f85-9b3e-4d6a-a863-b1a613b430af','2026-02-19 09:33:56',NULL,'UPDATE','COMPLETE','StackOutputsTest-653190073','4ef52f85-9b3e-4d6a-a863-b1a613b430af','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(911,'3a786781-7021-4512-a0f2-957236338f06','7ae00ead-58fc-4920-93c1-618cdd82799a','2026-02-19 09:33:57',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-937856821','7ae00ead-58fc-4920-93c1-618cdd82799a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(912,'4f964c82-b73b-4e00-be78-9f2b901473ad','7ae00ead-58fc-4920-93c1-618cdd82799a','2026-02-19 09:33:57',NULL,'CREATE','IN_PROGRESS','my_stack','RemoteStackTest-937856821-my_stack-4b4byldarnik','state changed','OS::Heat::Stack',NULL,170),(913,'30e5630b-32f5-4d63-9d97-ba41d2549d19','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','2026-02-19 09:33:58',NULL,'DELETE','IN_PROGRESS','swap_network_port','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(914,'3d23f0c9-a350-4de3-9fd3-4802fd36bf0e','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','2026-02-19 09:33:58',NULL,'DELETE','IN_PROGRESS','server','5451f05b-3841-4619-956a-ca4f5d6fbf4c','state changed','OS::Nova::Server',NULL,168),(915,'ae3d58d5-531a-4582-95f8-2e973d3cdc7c','7f177449-04e2-4f00-bb40-f790914383df','2026-02-19 09:33:58',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-937856821-my_stack-4b4byldarnik','7f177449-04e2-4f00-bb40-f790914383df','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(916,'d72ceef1-d27e-4c4b-80c5-2ca061817721','7f177449-04e2-4f00-bb40-f790914383df','2026-02-19 09:33:59',NULL,'CREATE','IN_PROGRESS','random1','RemoteStackTest-937856821-my_stack-4b4byldarnik-random1-xskr24yvwvuu','state changed','OS::Heat::RandomString',NULL,NULL),(917,'23979a7f-457a-437c-9368-01acb24597ec','7f177449-04e2-4f00-bb40-f790914383df','2026-02-19 09:33:59',NULL,'CREATE','COMPLETE','random1','RemoteStackTest-937856821-my_stack-4b4byldarnik-random1-xskr24yvwvuu','state changed','OS::Heat::RandomString',NULL,NULL),(918,'4ef6719e-5ec9-4b69-b4d0-1e317c15a674','7f177449-04e2-4f00-bb40-f790914383df','2026-02-19 09:33:59',NULL,'CREATE','COMPLETE','RemoteStackTest-937856821-my_stack-4b4byldarnik','7f177449-04e2-4f00-bb40-f790914383df','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(919,'a0c59871-f244-4c2a-9994-214cd5538093','4ef52f85-9b3e-4d6a-a863-b1a613b430af','2026-02-19 09:34:00',NULL,'DELETE','IN_PROGRESS','StackOutputsTest-653190073','4ef52f85-9b3e-4d6a-a863-b1a613b430af','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(920,'4cf501ed-9680-4a6d-ad25-f0089d2d42ca','4ef52f85-9b3e-4d6a-a863-b1a613b430af','2026-02-19 09:34:00',NULL,'DELETE','IN_PROGRESS','test_resource_b','StackOutputsTest-653190073-test_resource_b-ggecpgoz3cpy','state changed','OS::Heat::TestResource',NULL,169),(921,'f668a476-a5be-451a-8e81-248d007d89af','4ef52f85-9b3e-4d6a-a863-b1a613b430af','2026-02-19 09:34:00',NULL,'DELETE','COMPLETE','test_resource_b','StackOutputsTest-653190073-test_resource_b-ggecpgoz3cpy','state changed','OS::Heat::TestResource',NULL,169),(922,'28655f4e-e1f1-4b75-b768-f3b373e893ce','4ef52f85-9b3e-4d6a-a863-b1a613b430af','2026-02-19 09:34:00',NULL,'DELETE','IN_PROGRESS','test_resource_a','StackOutputsTest-653190073-test_resource_a-ijuepyypn7xr','state changed','OS::Heat::TestResource',NULL,167),(923,'e4dc7607-46e9-4a5f-9924-482e0149cb1f','4ef52f85-9b3e-4d6a-a863-b1a613b430af','2026-02-19 09:34:00',NULL,'DELETE','COMPLETE','test_resource_a','StackOutputsTest-653190073-test_resource_a-ijuepyypn7xr','state changed','OS::Heat::TestResource',NULL,167),(924,'4873a9cc-13a2-4c71-8fab-130f44ff9b12','4ef52f85-9b3e-4d6a-a863-b1a613b430af','2026-02-19 09:34:00',NULL,'DELETE','COMPLETE','StackOutputsTest-653190073','4ef52f85-9b3e-4d6a-a863-b1a613b430af','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(925,'f27ed05a-aa4d-44db-bcc9-bab254f76495','7ae00ead-58fc-4920-93c1-618cdd82799a','2026-02-19 09:34:00',NULL,'CREATE','COMPLETE','my_stack','7f177449-04e2-4f00-bb40-f790914383df','state changed','OS::Heat::Stack',NULL,170),(926,'f8f04c19-962e-4cf0-a620-5c9264a28b51','7ae00ead-58fc-4920-93c1-618cdd82799a','2026-02-19 09:34:00',NULL,'CREATE','COMPLETE','RemoteStackTest-937856821','7ae00ead-58fc-4920-93c1-618cdd82799a','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(927,'df83121b-35ef-436f-b1d7-2ba6a8e50202','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','2026-02-19 09:34:01',NULL,'DELETE','COMPLETE','server','5451f05b-3841-4619-956a-ca4f5d6fbf4c','state changed','OS::Nova::Server',NULL,168),(928,'b8bef8e2-38da-4158-8e7b-2faad6fe8162','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','2026-02-19 09:34:01',NULL,'DELETE','IN_PROGRESS','subnet','b3013267-d087-4693-91f3-43bf5756a66f','state changed','OS::Neutron::Subnet',NULL,160),(929,'fbe1aa9a-1175-485a-a7fc-0bd0af16c2fc','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','2026-02-19 09:34:01',NULL,'CREATE','IN_PROGRESS','HooksTest-1281521189','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(930,'bfe34f1f-780c-4bad-bb09-72594ae6c8dc','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','2026-02-19 09:34:01',NULL,'INIT','COMPLETE','foo_step1',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(931,'d2865134-6956-44c4-bb03-4adff8063f76','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','2026-02-19 09:34:03',NULL,'DELETE','COMPLETE','subnet','b3013267-d087-4693-91f3-43bf5756a66f','state changed','OS::Neutron::Subnet',NULL,160),(932,'24c3bef0-7dfe-4f53-900c-d49dfd83e960','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','2026-02-19 09:34:03',NULL,'DELETE','IN_PROGRESS','net','47628df4-6d10-4d31-b75f-72945071e617','state changed','OS::Neutron::Net',NULL,159),(933,'f206e1d5-9a55-4037-bafb-46a4638aa068','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','2026-02-19 09:34:04',NULL,'DELETE','COMPLETE','net','47628df4-6d10-4d31-b75f-72945071e617','state changed','OS::Neutron::Net',NULL,159),(934,'ddaeaf20-f68c-4a22-9d9b-3d8b88548798','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','2026-02-19 09:34:04',NULL,'INIT','COMPLETE','foo_step1',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(935,'567f46fe-a66d-4171-9843-ee8740c78a20','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','2026-02-19 09:34:04',NULL,'DELETE','COMPLETE','swap_network_port','d157adbf-2234-4f21-9bc8-1e0b6f362fdc','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(936,'56cdba43-187a-4c39-b80d-b47d084cbd2a','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','2026-02-19 09:34:04',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-1281521189-foo_step1-2hcytgv2wgsx','state changed','OS::Heat::RandomString',NULL,NULL),(937,'3942bae2-066a-479f-a175-ff84bd1d8239','7ae00ead-58fc-4920-93c1-618cdd82799a','2026-02-19 09:34:04',NULL,'UPDATE','IN_PROGRESS','RemoteStackTest-937856821','7ae00ead-58fc-4920-93c1-618cdd82799a','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(938,'9e632012-0ded-4e79-8889-e817e9facd40','7ae00ead-58fc-4920-93c1-618cdd82799a','2026-02-19 09:34:05',NULL,'UPDATE','IN_PROGRESS','my_stack','7f177449-04e2-4f00-bb40-f790914383df','state changed','OS::Heat::Stack',NULL,170),(939,'4a5f9128-8e37-42fa-9822-bf5d7e43342d','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','2026-02-19 09:34:05',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-1281521189-foo_step1-2hcytgv2wgsx','state changed','OS::Heat::RandomString',NULL,NULL),(940,'88807f13-a4ac-4bc8-a580-44fe7b8f211b','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','2026-02-19 09:34:06',NULL,'INIT','COMPLETE','foo_step2',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(941,'29b0de79-fbf9-4b56-b6ec-7cd4fc7a89ef','7f177449-04e2-4f00-bb40-f790914383df','2026-02-19 09:34:06',NULL,'UPDATE','IN_PROGRESS','RemoteStackTest-937856821-my_stack-4b4byldarnik','7f177449-04e2-4f00-bb40-f790914383df','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(942,'17cab68c-22ed-48c7-b30a-3585c2daae22','7f177449-04e2-4f00-bb40-f790914383df','2026-02-19 09:34:06',NULL,'DELETE','IN_PROGRESS','random1','RemoteStackTest-937856821-my_stack-4b4byldarnik-random1-xskr24yvwvuu','state changed','OS::Heat::RandomString',NULL,NULL),(943,'874342ca-9e83-468a-93f0-c78ef58aafa7','7f177449-04e2-4f00-bb40-f790914383df','2026-02-19 09:34:06',NULL,'DELETE','COMPLETE','random1','RemoteStackTest-937856821-my_stack-4b4byldarnik-random1-xskr24yvwvuu','state changed','OS::Heat::RandomString',NULL,NULL),(944,'3bd99c10-1ad5-4fcc-ba18-2be991adfbe8','7f177449-04e2-4f00-bb40-f790914383df','2026-02-19 09:34:07',NULL,'CREATE','IN_PROGRESS','random2','RemoteStackTest-937856821-my_stack-4b4byldarnik-random2-kk5qcpuq7yyy','state changed','OS::Heat::RandomString',NULL,NULL),(945,'78bf6ce7-3c5c-47a4-b2f9-2f20e4a4d548','297f0560-b15e-4d4b-929f-27ee3d3c4db8','2026-02-19 09:34:07',NULL,'CREATE','IN_PROGRESS','StackUnicodeTemplateTest-1464728206','297f0560-b15e-4d4b-929f-27ee3d3c4db8','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(946,'77232c85-ec44-4801-ae37-b936c64b11d3','7f177449-04e2-4f00-bb40-f790914383df','2026-02-19 09:34:07',NULL,'CREATE','COMPLETE','random2','RemoteStackTest-937856821-my_stack-4b4byldarnik-random2-kk5qcpuq7yyy','state changed','OS::Heat::RandomString',NULL,NULL),(947,'f4fe2954-6e99-4830-92db-eab12905b950','7f177449-04e2-4f00-bb40-f790914383df','2026-02-19 09:34:07',NULL,'UPDATE','COMPLETE','RemoteStackTest-937856821-my_stack-4b4byldarnik','7f177449-04e2-4f00-bb40-f790914383df','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(948,'2e164661-b7a3-497a-b8cb-86d54af0fe95','297f0560-b15e-4d4b-929f-27ee3d3c4db8','2026-02-19 09:34:07',NULL,'CREATE','IN_PROGRESS','资源','StackUnicodeTemplateTest-1464728206-资源-r4vcy5oxlzxp','state changed','OS::Heat::RandomString',NULL,172),(949,'e19bc8bd-db0b-4626-a68d-d1a5aa1cc27c','297f0560-b15e-4d4b-929f-27ee3d3c4db8','2026-02-19 09:34:07',NULL,'CREATE','COMPLETE','资源','StackUnicodeTemplateTest-1464728206-资源-r4vcy5oxlzxp','state changed','OS::Heat::RandomString',NULL,172),(950,'05cb2ca0-22f9-4985-8d82-a11ec782fcc4','297f0560-b15e-4d4b-929f-27ee3d3c4db8','2026-02-19 09:34:08',NULL,'CREATE','COMPLETE','StackUnicodeTemplateTest-1464728206','297f0560-b15e-4d4b-929f-27ee3d3c4db8','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(951,'9e70c0b4-a98a-40e0-9b2a-2ad1da3935dc','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','2026-02-19 09:34:09',NULL,'INIT','COMPLETE','foo_step2',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(952,'7ee87bfe-3d20-4e36-950d-243e472dc9ba','7ae00ead-58fc-4920-93c1-618cdd82799a','2026-02-19 09:34:09',NULL,'UPDATE','COMPLETE','my_stack','7f177449-04e2-4f00-bb40-f790914383df','state changed','OS::Heat::Stack',NULL,173),(953,'846bb113-5132-4736-938a-5be9ac88fa72','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','2026-02-19 09:34:09',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-1281521189-foo_step2-f2ip3g7ncqrq','state changed','OS::Heat::RandomString',NULL,NULL),(954,'43a49fa6-8036-44b6-bf40-05e3ee0a2281','7ae00ead-58fc-4920-93c1-618cdd82799a','2026-02-19 09:34:09',NULL,'UPDATE','COMPLETE','RemoteStackTest-937856821','7ae00ead-58fc-4920-93c1-618cdd82799a','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(955,'5e4b8162-7c6d-4ce0-bfcc-bd0f1aca879b','297f0560-b15e-4d4b-929f-27ee3d3c4db8','2026-02-19 09:34:10',NULL,'DELETE','IN_PROGRESS','StackUnicodeTemplateTest-1464728206','297f0560-b15e-4d4b-929f-27ee3d3c4db8','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(956,'5381aac6-ec94-44fa-ae4f-3b95a5d18084','297f0560-b15e-4d4b-929f-27ee3d3c4db8','2026-02-19 09:34:10',NULL,'DELETE','IN_PROGRESS','资源','StackUnicodeTemplateTest-1464728206-资源-r4vcy5oxlzxp','state changed','OS::Heat::RandomString',NULL,172),(957,'f4bbf488-8241-43fb-9a7b-be8b23e90cf0','297f0560-b15e-4d4b-929f-27ee3d3c4db8','2026-02-19 09:34:10',NULL,'DELETE','COMPLETE','资源','StackUnicodeTemplateTest-1464728206-资源-r4vcy5oxlzxp','state changed','OS::Heat::RandomString',NULL,172),(958,'4b138c58-6596-4849-9505-68c6334bf315','297f0560-b15e-4d4b-929f-27ee3d3c4db8','2026-02-19 09:34:10',NULL,'DELETE','COMPLETE','StackUnicodeTemplateTest-1464728206','297f0560-b15e-4d4b-929f-27ee3d3c4db8','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(959,'b4893ea3-97cd-48f8-a107-51109639a4bb','12fa5b7d-6b14-45f3-80c6-c4e49206d895','2026-02-19 09:34:10',NULL,'CREATE','IN_PROGRESS','swap_network_subnet','12fa5b7d-6b14-45f3-80c6-c4e49206d895','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(960,'fa3be0db-a443-4180-9ee8-bcf362a004ad','12fa5b7d-6b14-45f3-80c6-c4e49206d895','2026-02-19 09:34:10',NULL,'CREATE','IN_PROGRESS','net','swap_network_subnet-net-m6pwsdbrpddy','state changed','OS::Neutron::Net',NULL,174),(961,'156ecc5b-7628-4137-ae3b-599bccf60660','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','2026-02-19 09:34:10',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1281521189-foo_step2-f2ip3g7ncqrq','state changed','OS::Heat::RandomString',NULL,NULL),(962,'7da82346-6448-4334-9a56-0d5952e49099','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','2026-02-19 09:34:10',NULL,'INIT','COMPLETE','foo_step3',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(963,'886c34d6-0d48-4522-b49e-7938c660a5e5','12fa5b7d-6b14-45f3-80c6-c4e49206d895','2026-02-19 09:34:11',NULL,'CREATE','COMPLETE','net','c43bbf59-e369-449b-91c1-cae55365c3db','state changed','OS::Neutron::Net',NULL,174),(964,'f30a625a-8d0f-492b-bb05-2c0ba4c052f7','12fa5b7d-6b14-45f3-80c6-c4e49206d895','2026-02-19 09:34:12',NULL,'CREATE','IN_PROGRESS','subnet','swap_network_subnet-subnet-g46lobtn4lal','state changed','OS::Neutron::Subnet',NULL,175),(965,'4be3d4b7-671b-443c-8712-972c4c9adcb2','12fa5b7d-6b14-45f3-80c6-c4e49206d895','2026-02-19 09:34:14',NULL,'CREATE','COMPLETE','subnet','89bf4205-a158-4d44-ad82-5da52b19d23b','state changed','OS::Neutron::Subnet',NULL,175),(966,'64d1a4e2-0897-4565-bdd6-c4fb376ff5ed','12fa5b7d-6b14-45f3-80c6-c4e49206d895','2026-02-19 09:34:14',NULL,'CREATE','IN_PROGRESS','server','swap_network_subnet-server-3mkiqbxbpmq4','state changed','OS::Nova::Server',NULL,176),(967,'5b1d5d45-599b-4f37-a7cd-d05997bb4b29','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','2026-02-19 09:34:15',NULL,'INIT','COMPLETE','foo_step3',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(968,'cd4bb5b4-8e61-4e85-8851-065d6b81dba0','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','2026-02-19 09:34:15',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-1281521189-foo_step3-ge6wyetiw55g','state changed','OS::Heat::RandomString',NULL,NULL),(969,'d54b1fe3-89ad-457c-bb81-290d8642c705','7ae00ead-58fc-4920-93c1-618cdd82799a','2026-02-19 09:34:15',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-937856821','7ae00ead-58fc-4920-93c1-618cdd82799a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(970,'ff77c847-c1a5-4c95-bb43-f5a767ac6f87','7ae00ead-58fc-4920-93c1-618cdd82799a','2026-02-19 09:34:15',NULL,'DELETE','IN_PROGRESS','my_stack','7f177449-04e2-4f00-bb40-f790914383df','state changed','OS::Heat::Stack',NULL,173),(971,'7a38036c-6475-4faa-ac6a-6bfa581fd582','7f177449-04e2-4f00-bb40-f790914383df','2026-02-19 09:34:15',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-937856821-my_stack-4b4byldarnik','7f177449-04e2-4f00-bb40-f790914383df','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(972,'66c2cbff-6f0d-4d16-8df1-abc490063a35','7f177449-04e2-4f00-bb40-f790914383df','2026-02-19 09:34:16',NULL,'DELETE','IN_PROGRESS','random2','RemoteStackTest-937856821-my_stack-4b4byldarnik-random2-kk5qcpuq7yyy','state changed','OS::Heat::RandomString',NULL,NULL),(973,'fd41b7dd-905a-4dc0-9d62-c100b15be936','7f177449-04e2-4f00-bb40-f790914383df','2026-02-19 09:34:16',NULL,'DELETE','COMPLETE','random2','RemoteStackTest-937856821-my_stack-4b4byldarnik-random2-kk5qcpuq7yyy','state changed','OS::Heat::RandomString',NULL,NULL),(974,'86d8e249-e49a-4eeb-a6c6-ff8d3fc10283','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','2026-02-19 09:34:16',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-1281521189-foo_step3-ge6wyetiw55g','state changed','OS::Heat::RandomString',NULL,NULL),(975,'78b33f24-c17c-4af7-95dd-1a7d28c38c49','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','2026-02-19 09:34:16',NULL,'CREATE','COMPLETE','HooksTest-1281521189','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(976,'ccc45aef-693d-4f26-a9ae-0a1c7cfca814','7f177449-04e2-4f00-bb40-f790914383df','2026-02-19 09:34:16',NULL,'DELETE','COMPLETE','RemoteStackTest-937856821-my_stack-4b4byldarnik','7f177449-04e2-4f00-bb40-f790914383df','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(977,'bea86413-ed73-4ce8-8d08-1b75fa3fc0a2','7ae00ead-58fc-4920-93c1-618cdd82799a','2026-02-19 09:34:16',NULL,'DELETE','COMPLETE','my_stack','7f177449-04e2-4f00-bb40-f790914383df','state changed','OS::Heat::Stack',NULL,173),(978,'7055e2b8-c0d5-488b-a4bf-e6dd8ef193fa','7ae00ead-58fc-4920-93c1-618cdd82799a','2026-02-19 09:34:16',NULL,'DELETE','COMPLETE','RemoteStackTest-937856821','7ae00ead-58fc-4920-93c1-618cdd82799a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(979,'ae0a005d-409c-4f6b-ac4e-82896fbf9df0','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','2026-02-19 09:34:20',NULL,'DELETE','IN_PROGRESS','HooksTest-1281521189','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(980,'e50de9f0-fd95-45ef-be63-98db35660b6e','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','2026-02-19 09:34:20',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-1281521189-foo_step3-ge6wyetiw55g','state changed','OS::Heat::RandomString',NULL,NULL),(981,'6303bd6a-ebb0-42ae-815e-401d9e8df57e','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','2026-02-19 09:34:20',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-1281521189-foo_step3-ge6wyetiw55g','state changed','OS::Heat::RandomString',NULL,NULL),(982,'7b454271-46bb-4203-9771-9756a0e566c8','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','2026-02-19 09:34:20',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-1281521189-foo_step2-f2ip3g7ncqrq','state changed','OS::Heat::RandomString',NULL,NULL),(983,'16380852-e881-4a7b-8ef7-0488015d6822','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','2026-02-19 09:34:20',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-1281521189-foo_step2-f2ip3g7ncqrq','state changed','OS::Heat::RandomString',NULL,NULL),(984,'da9afa1d-d6e9-47e9-9db4-01ef1b97da06','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','2026-02-19 09:34:20',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-1281521189-foo_step1-2hcytgv2wgsx','state changed','OS::Heat::RandomString',NULL,NULL),(985,'37870052-4dca-4fc7-ad1e-8c02ed9dde85','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','2026-02-19 09:34:20',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-1281521189-foo_step1-2hcytgv2wgsx','state changed','OS::Heat::RandomString',NULL,NULL),(986,'85844469-86a3-4cb1-827c-443843d76c9b','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','2026-02-19 09:34:20',NULL,'DELETE','COMPLETE','HooksTest-1281521189','04897519-b5d1-418c-bc9f-23e9aa6b1d7b','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(987,'69a4f96c-638e-495f-b501-c7f15d507d6d','26fc6e76-721b-4eba-b18b-72e33d99f823','2026-02-19 09:34:21',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-500642542','26fc6e76-721b-4eba-b18b-72e33d99f823','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(988,'cc851318-7c67-42ce-b3d6-c0b37dbc4835','26fc6e76-721b-4eba-b18b-72e33d99f823','2026-02-19 09:34:21',NULL,'CREATE','IN_PROGRESS','server','ParallelDeploymentsTest-500642542-server-acfxzzmnxkfu','state changed','OS::Nova::Server',NULL,177),(989,'e3f25be3-e1c0-4ff9-b07e-e705dd22d2bd','12fa5b7d-6b14-45f3-80c6-c4e49206d895','2026-02-19 09:34:24',NULL,'CREATE','COMPLETE','server','a96c4e1e-6bb4-4c44-9315-4e5642ad55b6','state changed','OS::Nova::Server',NULL,176),(990,'ed7e7ed1-5bb8-4a41-a01b-cc34826a3fd7','12fa5b7d-6b14-45f3-80c6-c4e49206d895','2026-02-19 09:34:24',NULL,'CREATE','COMPLETE','swap_network_subnet','12fa5b7d-6b14-45f3-80c6-c4e49206d895','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(991,'5889e97f-8e9d-4d31-a903-49a6971429b0','a713f099-5dfc-4239-9373-516638aa5612','2026-02-19 09:34:25',NULL,'CREATE','IN_PROGRESS','HooksTest-208371421','a713f099-5dfc-4239-9373-516638aa5612','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(992,'32bf01dd-03b9-47d1-95b8-012a9984420a','a713f099-5dfc-4239-9373-516638aa5612','2026-02-19 09:34:26',NULL,'CREATE','IN_PROGRESS','rg','HooksTest-208371421-rg-uwcvkphq6eel','state changed','OS::Heat::ResourceGroup',NULL,178),(993,'1889c5f4-0422-4f34-811e-67791188e296','61ee8ab3-6226-4da0-9482-e41441f2a322','2026-02-19 09:34:26',NULL,'CREATE','IN_PROGRESS','HooksTest-208371421-rg-uwcvkphq6eel','61ee8ab3-6226-4da0-9482-e41441f2a322','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(994,'899e5740-1901-4314-a1de-7e68a11f04c7','61ee8ab3-6226-4da0-9482-e41441f2a322','2026-02-19 09:34:26',NULL,'CREATE','IN_PROGRESS','0','HooksTest-208371421-rg-uwcvkphq6eel-0-pspa4ua2yfpr','state changed','OS::Heat::RandomString',NULL,NULL),(995,'90f351e5-ccf9-4b98-9576-60a6f7b60af8','61ee8ab3-6226-4da0-9482-e41441f2a322','2026-02-19 09:34:26',NULL,'CREATE','COMPLETE','0','HooksTest-208371421-rg-uwcvkphq6eel-0-pspa4ua2yfpr','state changed','OS::Heat::RandomString',NULL,NULL),(996,'a69dcdcd-2427-49c2-af8f-d773936a0a94','61ee8ab3-6226-4da0-9482-e41441f2a322','2026-02-19 09:34:26',NULL,'CREATE','COMPLETE','HooksTest-208371421-rg-uwcvkphq6eel','61ee8ab3-6226-4da0-9482-e41441f2a322','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(997,'5366d680-0b0a-4c93-a056-f56ae7b28824','a713f099-5dfc-4239-9373-516638aa5612','2026-02-19 09:34:27',NULL,'CREATE','COMPLETE','rg','61ee8ab3-6226-4da0-9482-e41441f2a322','state changed','OS::Heat::ResourceGroup',NULL,178),(998,'8b5c3016-cb4e-407d-87a5-405adb3dd7bf','a713f099-5dfc-4239-9373-516638aa5612','2026-02-19 09:34:27',NULL,'CREATE','COMPLETE','HooksTest-208371421','a713f099-5dfc-4239-9373-516638aa5612','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(999,'372c6d55-4048-4d4b-95dd-ba3cb6e6de04','12fa5b7d-6b14-45f3-80c6-c4e49206d895','2026-02-19 09:34:30',NULL,'UPDATE','IN_PROGRESS','swap_network_subnet','12fa5b7d-6b14-45f3-80c6-c4e49206d895','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1000,'f337f4c0-4a8c-4dc3-92ca-6eadd4eb3017','a713f099-5dfc-4239-9373-516638aa5612','2026-02-19 09:34:31',NULL,'UPDATE','IN_PROGRESS','HooksTest-208371421','a713f099-5dfc-4239-9373-516638aa5612','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1001,'d9d2da06-9c8c-4735-a874-115023d4a69c','a713f099-5dfc-4239-9373-516638aa5612','2026-02-19 09:34:31',NULL,'CREATE','COMPLETE','rg','61ee8ab3-6226-4da0-9482-e41441f2a322','UPDATE paused until Hook pre-update is cleared','OS::Heat::ResourceGroup',NULL,178),(1002,'3c3f6da5-60d3-4325-8d06-60e338344790','12fa5b7d-6b14-45f3-80c6-c4e49206d895','2026-02-19 09:34:31',NULL,'UPDATE','IN_PROGRESS','server','a96c4e1e-6bb4-4c44-9315-4e5642ad55b6','state changed','OS::Nova::Server',NULL,176),(1003,'a04b8f5d-7b2e-4c48-b3e9-fbc1651a34a5','a713f099-5dfc-4239-9373-516638aa5612','2026-02-19 09:34:32',NULL,'CREATE','COMPLETE','rg','61ee8ab3-6226-4da0-9482-e41441f2a322','Hook pre-update is cleared','OS::Heat::ResourceGroup',NULL,178),(1004,'e5de1fbb-b832-4ac8-892c-e6f218213257','a713f099-5dfc-4239-9373-516638aa5612','2026-02-19 09:34:32',NULL,'UPDATE','IN_PROGRESS','rg','61ee8ab3-6226-4da0-9482-e41441f2a322','state changed','OS::Heat::ResourceGroup',NULL,178),(1005,'30a16e6d-bc13-4eec-878b-2eebd361e59e','61ee8ab3-6226-4da0-9482-e41441f2a322','2026-02-19 09:34:33',NULL,'UPDATE','IN_PROGRESS','HooksTest-208371421-rg-uwcvkphq6eel','61ee8ab3-6226-4da0-9482-e41441f2a322','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1006,'3cfa87cd-05cb-440a-8ec4-f5d8aca7b52b','12fa5b7d-6b14-45f3-80c6-c4e49206d895','2026-02-19 09:34:34',NULL,'UPDATE','COMPLETE','server','a96c4e1e-6bb4-4c44-9315-4e5642ad55b6','state changed','OS::Nova::Server',NULL,180),(1007,'a15979b7-e74b-4306-9573-1327b5c38791','61ee8ab3-6226-4da0-9482-e41441f2a322','2026-02-19 09:34:34',NULL,'CREATE','IN_PROGRESS','1','HooksTest-208371421-rg-uwcvkphq6eel-1-rcgz3c5wzkpq','state changed','OS::Heat::RandomString',NULL,NULL),(1008,'dffc9d45-aa3d-4c65-bfb0-488127c4ee8e','61ee8ab3-6226-4da0-9482-e41441f2a322','2026-02-19 09:34:34',NULL,'CREATE','COMPLETE','1','HooksTest-208371421-rg-uwcvkphq6eel-1-rcgz3c5wzkpq','state changed','OS::Heat::RandomString',NULL,NULL),(1009,'9c1f2fa7-f5a6-4109-a1f7-4bf2952cc1e4','61ee8ab3-6226-4da0-9482-e41441f2a322','2026-02-19 09:34:34',NULL,'UPDATE','COMPLETE','HooksTest-208371421-rg-uwcvkphq6eel','61ee8ab3-6226-4da0-9482-e41441f2a322','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1010,'d59b2a76-0f5a-4df5-98fd-568d0ef75a44','12fa5b7d-6b14-45f3-80c6-c4e49206d895','2026-02-19 09:34:34',NULL,'UPDATE','COMPLETE','swap_network_subnet','12fa5b7d-6b14-45f3-80c6-c4e49206d895','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1011,'66c4daaf-efcf-410f-8ed8-de1a825626fe','26fc6e76-721b-4eba-b18b-72e33d99f823','2026-02-19 09:34:35',NULL,'CREATE','COMPLETE','server','79f5e76f-7099-456a-a2e9-cf91dd45d6d8','state changed','OS::Nova::Server',NULL,177),(1012,'47384ac2-e0cd-4686-92b0-d6c93688f9ce','26fc6e76-721b-4eba-b18b-72e33d99f823','2026-02-19 09:34:35',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-500642542','26fc6e76-721b-4eba-b18b-72e33d99f823','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1013,'5da24952-6deb-4685-89ed-02aa4fce72cd','a713f099-5dfc-4239-9373-516638aa5612','2026-02-19 09:34:35',NULL,'UPDATE','COMPLETE','rg','61ee8ab3-6226-4da0-9482-e41441f2a322','state changed','OS::Heat::ResourceGroup',NULL,181),(1014,'09e216d9-1c15-464b-ba43-75130b2533da','a713f099-5dfc-4239-9373-516638aa5612','2026-02-19 09:34:35',NULL,'UPDATE','COMPLETE','HooksTest-208371421','a713f099-5dfc-4239-9373-516638aa5612','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1015,'b557e9ae-a19c-45ee-9e46-46d57dc46967','12fa5b7d-6b14-45f3-80c6-c4e49206d895','2026-02-19 09:34:36',NULL,'DELETE','IN_PROGRESS','swap_network_subnet','12fa5b7d-6b14-45f3-80c6-c4e49206d895','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1016,'5a8beb2d-2d52-48bb-a113-357a6c69445b','12fa5b7d-6b14-45f3-80c6-c4e49206d895','2026-02-19 09:34:36',NULL,'DELETE','IN_PROGRESS','server','a96c4e1e-6bb4-4c44-9315-4e5642ad55b6','state changed','OS::Nova::Server',NULL,180),(1017,'14ef183d-cff6-49cf-80fb-0917c23616fa','a713f099-5dfc-4239-9373-516638aa5612','2026-02-19 09:34:37',NULL,'DELETE','IN_PROGRESS','HooksTest-208371421','a713f099-5dfc-4239-9373-516638aa5612','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1018,'af2c6947-8107-4c09-b8e3-00784622ea96','a713f099-5dfc-4239-9373-516638aa5612','2026-02-19 09:34:37',NULL,'DELETE','IN_PROGRESS','rg','61ee8ab3-6226-4da0-9482-e41441f2a322','state changed','OS::Heat::ResourceGroup',NULL,181),(1019,'ae316ffc-da64-4c00-8b10-b30cedc78d6b','61ee8ab3-6226-4da0-9482-e41441f2a322','2026-02-19 09:34:37',NULL,'DELETE','IN_PROGRESS','HooksTest-208371421-rg-uwcvkphq6eel','61ee8ab3-6226-4da0-9482-e41441f2a322','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1020,'c57ef259-f95f-444e-bb32-fb823326c04d','61ee8ab3-6226-4da0-9482-e41441f2a322','2026-02-19 09:34:37',NULL,'DELETE','IN_PROGRESS','0','HooksTest-208371421-rg-uwcvkphq6eel-0-pspa4ua2yfpr','state changed','OS::Heat::RandomString',NULL,NULL),(1021,'63c95302-63c3-48fd-9752-489616e065a4','61ee8ab3-6226-4da0-9482-e41441f2a322','2026-02-19 09:34:37',NULL,'DELETE','COMPLETE','0','HooksTest-208371421-rg-uwcvkphq6eel-0-pspa4ua2yfpr','state changed','OS::Heat::RandomString',NULL,NULL),(1022,'a9533c07-df6d-42f0-a92a-66f3bb405369','61ee8ab3-6226-4da0-9482-e41441f2a322','2026-02-19 09:34:38',NULL,'DELETE','IN_PROGRESS','1','HooksTest-208371421-rg-uwcvkphq6eel-1-rcgz3c5wzkpq','state changed','OS::Heat::RandomString',NULL,NULL),(1023,'585e7c73-f616-446a-9d2f-d98f0c2c35ad','61ee8ab3-6226-4da0-9482-e41441f2a322','2026-02-19 09:34:38',NULL,'DELETE','COMPLETE','1','HooksTest-208371421-rg-uwcvkphq6eel-1-rcgz3c5wzkpq','state changed','OS::Heat::RandomString',NULL,NULL),(1024,'279bba93-11bd-4844-89df-399ab1d6af82','61ee8ab3-6226-4da0-9482-e41441f2a322','2026-02-19 09:34:38',NULL,'DELETE','COMPLETE','HooksTest-208371421-rg-uwcvkphq6eel','61ee8ab3-6226-4da0-9482-e41441f2a322','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1025,'77f93f66-aeb5-4c0d-982e-5a67c1af136b','12fa5b7d-6b14-45f3-80c6-c4e49206d895','2026-02-19 09:34:38',NULL,'DELETE','COMPLETE','server','a96c4e1e-6bb4-4c44-9315-4e5642ad55b6','state changed','OS::Nova::Server',NULL,180),(1026,'09c878d1-4ba0-4f52-8c48-98f0aa231500','12fa5b7d-6b14-45f3-80c6-c4e49206d895','2026-02-19 09:34:38',NULL,'DELETE','IN_PROGRESS','subnet','89bf4205-a158-4d44-ad82-5da52b19d23b','state changed','OS::Neutron::Subnet',NULL,175),(1027,'5f4a2d0c-8589-403d-8b0d-71158ee133cf','12fa5b7d-6b14-45f3-80c6-c4e49206d895','2026-02-19 09:34:39',NULL,'DELETE','COMPLETE','subnet','89bf4205-a158-4d44-ad82-5da52b19d23b','state changed','OS::Neutron::Subnet',NULL,175),(1028,'591b4d69-fe94-40e5-a36c-b0b2631fade2','12fa5b7d-6b14-45f3-80c6-c4e49206d895','2026-02-19 09:34:39',NULL,'DELETE','IN_PROGRESS','net','c43bbf59-e369-449b-91c1-cae55365c3db','state changed','OS::Neutron::Net',NULL,174),(1029,'f5db62d5-b79d-43a5-8cdb-31fa602680ec','a713f099-5dfc-4239-9373-516638aa5612','2026-02-19 09:34:39',NULL,'DELETE','COMPLETE','rg','61ee8ab3-6226-4da0-9482-e41441f2a322','state changed','OS::Heat::ResourceGroup',NULL,181),(1030,'7a6d95c0-0db7-4136-acb4-c1b4ace966b3','a713f099-5dfc-4239-9373-516638aa5612','2026-02-19 09:34:39',NULL,'DELETE','COMPLETE','HooksTest-208371421','a713f099-5dfc-4239-9373-516638aa5612','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1031,'2abdbffc-549a-4a3f-9854-e08d475e4f2e','12fa5b7d-6b14-45f3-80c6-c4e49206d895','2026-02-19 09:34:39',NULL,'DELETE','COMPLETE','net','c43bbf59-e369-449b-91c1-cae55365c3db','state changed','OS::Neutron::Net',NULL,174),(1032,'6e928c71-86f2-44ab-ac90-6b7cff818757','12fa5b7d-6b14-45f3-80c6-c4e49206d895','2026-02-19 09:34:39',NULL,'DELETE','COMPLETE','swap_network_subnet','12fa5b7d-6b14-45f3-80c6-c4e49206d895','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1033,'8ff2591e-118f-4e53-bc2c-d5da171e5271','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:34:40',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-614175552','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1034,'4f860944-87bf-4439-99ad-33b8fdfb6d91','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:34:40',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-614175552-config-vc3wofj6xlwd','state changed','OS::Heat::SoftwareConfig',NULL,183),(1035,'16096c67-7548-4006-82c7-03a1768b7790','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:34:40',NULL,'CREATE','COMPLETE','config','d9922bcf-9430-4ec8-9d5b-3a0b446f5d4d','state changed','OS::Heat::SoftwareConfig',NULL,183),(1036,'a92c692d-b44c-4514-a017-97958d9220e3','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:34:40',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-614175552-dep_2-ul2frflp772c','state changed','OS::Heat::SoftwareDeployments',NULL,184),(1037,'aac02a47-fa6a-4b78-b89b-0e4f8289d5ec','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:34:40',NULL,'CREATE','IN_PROGRESS','dep_3','ParallelDeploymentsTest-614175552-dep_3-pgcfpvugjbpb','state changed','OS::Heat::SoftwareDeployments',NULL,185),(1038,'6358b6ba-a3fc-4693-b4ed-c5864cb5e8ba','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:34:40',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-614175552-dep_1-r7q3uuzjc3pn','state changed','OS::Heat::SoftwareDeployments',NULL,186),(1039,'f72bdf6c-f50d-4048-b242-4b21732fc5fe','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:34:40',NULL,'CREATE','IN_PROGRESS','dep_4','ParallelDeploymentsTest-614175552-dep_4-vllpksuhb3q2','state changed','OS::Heat::SoftwareDeployments',NULL,187),(1040,'fe9cc830-9b60-4033-9e69-73e277890673','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:34:40',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-614175552-dep_0-y3rth3wuhf4a','state changed','OS::Heat::SoftwareDeployments',NULL,188),(1041,'f97f65bf-72e5-45c6-8de3-fe11b381f9bb','0b1dfe63-062f-406d-b725-3604ca41ab05','2026-02-19 09:34:40',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-614175552-dep_2-ul2frflp772c','0b1dfe63-062f-406d-b725-3604ca41ab05','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1042,'e4df45ac-19ed-4496-9250-daa33ff5400d','dde52115-d860-4b44-bc89-5a2453d6b2b6','2026-02-19 09:34:40',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-614175552-dep_3-pgcfpvugjbpb','dde52115-d860-4b44-bc89-5a2453d6b2b6','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1043,'07ed33bf-86d8-4705-ba7c-a38bead6833d','96845e67-548c-4233-98e6-ad5a9dd8c127','2026-02-19 09:34:40',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-614175552-dep_1-r7q3uuzjc3pn','96845e67-548c-4233-98e6-ad5a9dd8c127','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1044,'05957c5c-1721-4664-9370-7cce79e968e6','898d8a4d-2d18-4d50-8fbf-0c8feae1f848','2026-02-19 09:34:40',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-614175552-dep_4-vllpksuhb3q2','898d8a4d-2d18-4d50-8fbf-0c8feae1f848','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1045,'397e0b95-a10b-4b39-8a3c-5611e854aca4','9431b106-3940-4d80-922b-c86e1d165555','2026-02-19 09:34:40',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-614175552-dep_0-y3rth3wuhf4a','9431b106-3940-4d80-922b-c86e1d165555','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1046,'9d2318f8-c6cd-4552-9319-1e2dc1e1b088','0b1dfe63-062f-406d-b725-3604ca41ab05','2026-02-19 09:34:40',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-614175552-dep_2-ul2frflp772c-0-ttxknglch3yo','state changed','OS::Heat::SoftwareDeployment',NULL,189),(1047,'9c0ade93-d864-4cc9-a478-84ba481d93eb','dde52115-d860-4b44-bc89-5a2453d6b2b6','2026-02-19 09:34:40',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-614175552-dep_3-pgcfpvugjbpb-0-vrtprfhi6c74','state changed','OS::Heat::SoftwareDeployment',NULL,190),(1048,'44227ae1-9913-46bf-89c4-066540d1e234','96845e67-548c-4233-98e6-ad5a9dd8c127','2026-02-19 09:34:40',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-614175552-dep_1-r7q3uuzjc3pn-0-i5dtlntdfhry','state changed','OS::Heat::SoftwareDeployment',NULL,191),(1049,'d8b962cf-9117-4e6c-9709-2c0a09003fbc','9431b106-3940-4d80-922b-c86e1d165555','2026-02-19 09:34:40',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-614175552-dep_0-y3rth3wuhf4a-0-gf7puqkzvxso','state changed','OS::Heat::SoftwareDeployment',NULL,192),(1050,'9c038231-6397-40e1-ade8-b87a957e6e02','898d8a4d-2d18-4d50-8fbf-0c8feae1f848','2026-02-19 09:34:40',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-614175552-dep_4-vllpksuhb3q2-0-xgwabcsf2bjb','state changed','OS::Heat::SoftwareDeployment',NULL,193),(1051,'ab7276ae-8a69-47db-93a6-5aba028fb9fd','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:34:42',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-825460174','9fa13249-8716-4b7e-921d-22f54f1897b0','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1052,'23510405-4fe1-436c-a699-60c4e3d2dc52','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:34:42',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-825460174-config-lkejvr5rnaau','state changed','OS::Heat::SoftwareConfig',NULL,194),(1053,'f6ec521a-f687-415f-a5b5-a418b1bf02f2','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:34:42',NULL,'CREATE','COMPLETE','config','a657aaa3-d0f7-4a4b-81b9-1b11d719c06c','state changed','OS::Heat::SoftwareConfig',NULL,194),(1054,'0ebc677d-4aa1-452f-8a27-3fb9e8a4bff9','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:34:42',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-825460174-dep_2-66sur23t33uk','state changed','OS::Heat::SoftwareDeployments',NULL,195),(1055,'2c43e6b8-1d5a-4ced-b4fc-26034c742790','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:34:42',NULL,'CREATE','IN_PROGRESS','dep_3','ParallelDeploymentsTest-825460174-dep_3-s3ukplefd4zu','state changed','OS::Heat::SoftwareDeployments',NULL,196),(1056,'30498f88-a389-4ee9-b1fe-d55f94a76345','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:34:42',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-825460174-dep_1-yactjmgm6apr','state changed','OS::Heat::SoftwareDeployments',NULL,197),(1057,'a28b3ae1-f78f-4bc8-bb58-78e915e0bdcd','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:34:42',NULL,'CREATE','IN_PROGRESS','dep_4','ParallelDeploymentsTest-825460174-dep_4-nro7tyxzkysk','state changed','OS::Heat::SoftwareDeployments',NULL,198),(1058,'36bb64a6-06c3-435a-84a7-a107bdeb416e','f85a03e0-c171-490b-900d-2a307dabee57','2026-02-19 09:34:42',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-825460174-dep_2-66sur23t33uk','f85a03e0-c171-490b-900d-2a307dabee57','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1059,'d9bd8ba0-0fb8-4299-9754-c7cc02e09562','b351f81f-e135-45c3-9d01-f6221b7745a1','2026-02-19 09:34:42',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-825460174-dep_3-s3ukplefd4zu','b351f81f-e135-45c3-9d01-f6221b7745a1','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1060,'57c59b42-22b7-4ac4-a800-01fbbc4a90f8','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:34:42',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-825460174-dep_0-3wfxqlizneo3','state changed','OS::Heat::SoftwareDeployments',NULL,199),(1061,'3db78fd4-7b62-46fb-9f47-9bd538273bed','d6c8c06b-afb4-4471-8ed4-887be29d705d','2026-02-19 09:34:42',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-825460174-dep_1-yactjmgm6apr','d6c8c06b-afb4-4471-8ed4-887be29d705d','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1062,'92354e69-9976-4662-b046-d1e69ecb166b','452981e1-c3cc-4fa7-b9a3-53ce27bddcd3','2026-02-19 09:34:42',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-825460174-dep_4-nro7tyxzkysk','452981e1-c3cc-4fa7-b9a3-53ce27bddcd3','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1063,'4d0d9524-2aca-4a7c-a7d8-9acc88a48647','f85a03e0-c171-490b-900d-2a307dabee57','2026-02-19 09:34:42',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-825460174-dep_2-66sur23t33uk-0-c56kbs4e2sqy','state changed','OS::Heat::SoftwareDeployment',NULL,200),(1064,'1b39d86a-ca54-43dd-aa4d-bdb41b6cdb33','d030df58-eeb9-47ec-98c9-61b455b3e0d4','2026-02-19 09:34:42',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-825460174-dep_0-3wfxqlizneo3','d030df58-eeb9-47ec-98c9-61b455b3e0d4','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1065,'86b739c5-18a2-4c05-a44d-1b643df0563c','b351f81f-e135-45c3-9d01-f6221b7745a1','2026-02-19 09:34:42',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-825460174-dep_3-s3ukplefd4zu-0-xcz6in234qmw','state changed','OS::Heat::SoftwareDeployment',NULL,201),(1066,'eb6939d9-d915-429d-8555-b60312ec8ccb','d6c8c06b-afb4-4471-8ed4-887be29d705d','2026-02-19 09:34:43',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-825460174-dep_1-yactjmgm6apr-0-mrgyxy7hfiwn','state changed','OS::Heat::SoftwareDeployment',NULL,202),(1067,'0bb49f3a-be9e-4191-a4e1-82a9554ccc16','452981e1-c3cc-4fa7-b9a3-53ce27bddcd3','2026-02-19 09:34:43',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-825460174-dep_4-nro7tyxzkysk-0-zwftqsprg7ms','state changed','OS::Heat::SoftwareDeployment',NULL,203),(1068,'6ffde8dc-34fc-4c7b-ae78-ee85d444d120','d030df58-eeb9-47ec-98c9-61b455b3e0d4','2026-02-19 09:34:43',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-825460174-dep_0-3wfxqlizneo3-0-kafzowzapgwo','state changed','OS::Heat::SoftwareDeployment',NULL,204),(1069,'6c4bf303-e705-4fe4-915a-dcf19de18671','3b04657b-376e-4603-ba97-51104a2af738','2026-02-19 09:34:44',NULL,'CREATE','IN_PROGRESS','swap_subnet_network','3b04657b-376e-4603-ba97-51104a2af738','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1070,'38f1f625-ced6-41fc-948a-0cd93eaba993','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','2026-02-19 09:34:44',NULL,'CREATE','IN_PROGRESS','HooksTest-1791753119','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1071,'7d3431d5-e2c5-4e92-9795-cf995bc039b1','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','2026-02-19 09:34:46',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-1791753119-foo_step1-auwdovhzyw2u','state changed','OS::Heat::RandomString',NULL,NULL),(1072,'adef8d58-3ad1-424d-8258-80a30d43a1cd','3b04657b-376e-4603-ba97-51104a2af738','2026-02-19 09:34:46',NULL,'CREATE','IN_PROGRESS','net','swap_subnet_network-net-wtogpkvtm6ar','state changed','OS::Neutron::Net',NULL,205),(1073,'b80b11cf-d87a-434a-874a-cd5161284ee9','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','2026-02-19 09:34:46',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-1791753119-foo_step1-auwdovhzyw2u','state changed','OS::Heat::RandomString',NULL,NULL),(1074,'a4a448a5-397e-4af1-9f48-e512259a9456','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','2026-02-19 09:34:47',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-1791753119-foo_step2-i5l6jbopr6bf','state changed','OS::Heat::RandomString',NULL,NULL),(1075,'71a7f9f2-363b-443e-a948-f7ca13feced1','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','2026-02-19 09:34:47',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1791753119-foo_step2-i5l6jbopr6bf','state changed','OS::Heat::RandomString',NULL,NULL),(1076,'62930f1a-21fd-41b6-8721-5c23749a6942','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','2026-02-19 09:34:49',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-1791753119-foo_step3-pk26eys54gms','state changed','OS::Heat::RandomString',NULL,NULL),(1077,'7396184e-72f3-46ac-bd0c-75609e8ca916','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','2026-02-19 09:34:50',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-1791753119-foo_step3-pk26eys54gms','state changed','OS::Heat::RandomString',NULL,NULL),(1078,'b9f0310c-6e49-4760-8b54-5496a3f86c6c','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','2026-02-19 09:34:50',NULL,'CREATE','COMPLETE','HooksTest-1791753119','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1079,'84681577-6ac5-465c-a27e-7b2b1aebee52','3b04657b-376e-4603-ba97-51104a2af738','2026-02-19 09:34:50',NULL,'CREATE','COMPLETE','net','19805626-6f29-4186-83ca-8b5a4f3c5a73','state changed','OS::Neutron::Net',NULL,205),(1080,'0db57732-83f8-47a1-b999-ce3c928aa934','3b04657b-376e-4603-ba97-51104a2af738','2026-02-19 09:34:50',NULL,'CREATE','IN_PROGRESS','subnet','swap_subnet_network-subnet-gujecwzdtuhr','state changed','OS::Neutron::Subnet',NULL,206),(1081,'9e72016e-e40c-4f81-a548-8e1cd2f6f07a','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','2026-02-19 09:34:52',NULL,'UPDATE','IN_PROGRESS','HooksTest-1791753119','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1082,'ab17ae15-074e-478a-b8df-32fc8f8e46d0','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','2026-02-19 09:34:53',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1791753119-foo_step2-i5l6jbopr6bf','UPDATE paused until Hook pre-update is cleared','OS::Heat::RandomString',NULL,NULL),(1083,'18563b11-b652-4d63-822e-ae92008250f1','3b04657b-376e-4603-ba97-51104a2af738','2026-02-19 09:34:53',NULL,'CREATE','COMPLETE','subnet','73f8bb89-d1dc-4554-940b-631d92cb5128','state changed','OS::Neutron::Subnet',NULL,206),(1084,'67dfceac-f11f-4227-8c25-a1dd1698f4da','3b04657b-376e-4603-ba97-51104a2af738','2026-02-19 09:34:53',NULL,'CREATE','IN_PROGRESS','server','swap_subnet_network-server-amunapr5gck6','state changed','OS::Nova::Server',NULL,207),(1085,'35ab01a5-aefb-4550-aaa8-cabf7870539a','4ed35a8c-642e-4763-8389-c7148eaf292c','2026-02-19 09:34:53',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1864767498','4ed35a8c-642e-4763-8389-c7148eaf292c','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1086,'dbbc087e-1de9-42e8-b47a-5e90652d41f8','4ed35a8c-642e-4763-8389-c7148eaf292c','2026-02-19 09:34:54',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-1864767498-config-uytlznkemltd','state changed','OS::Heat::SoftwareConfig',NULL,208),(1087,'cd4c78fd-eec1-44ce-9101-715ae3fb04ba','4ed35a8c-642e-4763-8389-c7148eaf292c','2026-02-19 09:34:54',NULL,'CREATE','COMPLETE','config','89191f4e-ce86-45da-b669-c08cce44cee8','state changed','OS::Heat::SoftwareConfig',NULL,208),(1088,'c9f243b7-8811-4daa-80f7-748621f61e2a','4ed35a8c-642e-4763-8389-c7148eaf292c','2026-02-19 09:34:54',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-1864767498-dep_0-khwzne6zbzlh','state changed','OS::Heat::SoftwareDeployments',NULL,209),(1089,'ae8d5ee9-8780-4dbb-9139-f6b3db8097d1','4ed35a8c-642e-4763-8389-c7148eaf292c','2026-02-19 09:34:54',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-1864767498-dep_1-jeip62xpeid3','state changed','OS::Heat::SoftwareDeployments',NULL,210),(1090,'de07627e-754f-4220-bd21-0765264eb7fd','4ed35a8c-642e-4763-8389-c7148eaf292c','2026-02-19 09:34:54',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-1864767498-dep_2-rgyaphd5dp2l','state changed','OS::Heat::SoftwareDeployments',NULL,211),(1091,'c77a3028-bd6e-47de-af49-1b02dba9c16a','e1c8d1f5-3f1e-40c6-aab0-fa49073f9153','2026-02-19 09:34:54',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1864767498-dep_1-jeip62xpeid3','e1c8d1f5-3f1e-40c6-aab0-fa49073f9153','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1092,'9a59ce3e-c593-4918-8522-98cbdbb80e5a','39b754ea-2fb5-4e80-a0a0-c0b67163b1f4','2026-02-19 09:34:54',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1864767498-dep_0-khwzne6zbzlh','39b754ea-2fb5-4e80-a0a0-c0b67163b1f4','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1093,'613c7e07-6ff3-41f0-9ad3-22e6675b15e7','68a6a357-ff37-4b82-9ceb-ffcf88ae3a85','2026-02-19 09:34:54',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1864767498-dep_2-rgyaphd5dp2l','68a6a357-ff37-4b82-9ceb-ffcf88ae3a85','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1094,'e0fddde1-4c6b-4d0c-8db5-6414dd9dc998','e1c8d1f5-3f1e-40c6-aab0-fa49073f9153','2026-02-19 09:34:54',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1864767498-dep_1-jeip62xpeid3-0-phtprpxkasku','state changed','OS::Heat::SoftwareDeployment',NULL,212),(1095,'f4425ade-a0b4-4871-94ec-6263194616bb','39b754ea-2fb5-4e80-a0a0-c0b67163b1f4','2026-02-19 09:34:54',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1864767498-dep_0-khwzne6zbzlh-0-4ifryx7nygxu','state changed','OS::Heat::SoftwareDeployment',NULL,213),(1096,'2be5a514-8427-428a-97d5-0259a006edca','68a6a357-ff37-4b82-9ceb-ffcf88ae3a85','2026-02-19 09:34:54',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1864767498-dep_2-rgyaphd5dp2l-0-qairrbuaqqid','state changed','OS::Heat::SoftwareDeployment',NULL,214),(1097,'06446eb0-7f4d-48ac-a3d5-1db10c7b6cf0','6a4f464f-6f93-4c05-9f4d-1520e9778a71','2026-02-19 09:34:55',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1410556822','6a4f464f-6f93-4c05-9f4d-1520e9778a71','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1098,'e05dfcd5-f831-43d4-a731-807961e21fe2','6a4f464f-6f93-4c05-9f4d-1520e9778a71','2026-02-19 09:34:55',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-1410556822-config-lhvxwmuaemea','state changed','OS::Heat::SoftwareConfig',NULL,215),(1099,'4aadf53e-2f8c-4c3c-8db1-21c0968d00f5','6a4f464f-6f93-4c05-9f4d-1520e9778a71','2026-02-19 09:34:55',NULL,'CREATE','COMPLETE','config','843caaf1-a1b1-4ff8-b665-996aacf85dce','state changed','OS::Heat::SoftwareConfig',NULL,215),(1100,'df7da344-699a-4cef-a284-12f148339ef2','6a4f464f-6f93-4c05-9f4d-1520e9778a71','2026-02-19 09:34:56',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-1410556822-dep_1-tu5adhlvokhw','state changed','OS::Heat::SoftwareDeployments',NULL,216),(1101,'8aab1a95-0f0e-4426-960e-ad3e7802eb8f','6a4f464f-6f93-4c05-9f4d-1520e9778a71','2026-02-19 09:34:56',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-1410556822-dep_2-6jtmimpikcgr','state changed','OS::Heat::SoftwareDeployments',NULL,217),(1102,'bba97a2c-cd15-4b9d-9957-c1409ef87f57','6a4f464f-6f93-4c05-9f4d-1520e9778a71','2026-02-19 09:34:56',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-1410556822-dep_0-jk6x72auoxdp','state changed','OS::Heat::SoftwareDeployments',NULL,218),(1103,'5e11d49f-706f-4a8f-b6d9-a88c15b5bab7','3349a8b8-4459-48c0-b6ce-993640def0c1','2026-02-19 09:34:56',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1410556822-dep_1-tu5adhlvokhw','3349a8b8-4459-48c0-b6ce-993640def0c1','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1104,'b593619f-c447-4de7-9124-730187b419b5','3cd4e73d-0495-4d25-a6e6-97180bc46b74','2026-02-19 09:34:56',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1410556822-dep_2-6jtmimpikcgr','3cd4e73d-0495-4d25-a6e6-97180bc46b74','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1105,'62430b96-6fcf-4b06-93d6-142b168bfd45','79892d56-0422-4f3a-ae6c-27fbcdab44c4','2026-02-19 09:34:56',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1410556822-dep_0-jk6x72auoxdp','79892d56-0422-4f3a-ae6c-27fbcdab44c4','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1106,'58b40ccb-ad8d-42b8-a546-d4bbcdde72f5','3cd4e73d-0495-4d25-a6e6-97180bc46b74','2026-02-19 09:34:56',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1410556822-dep_2-6jtmimpikcgr-0-hg4zlgn4ufak','state changed','OS::Heat::SoftwareDeployment',NULL,219),(1107,'52041b0b-179e-40bc-b079-100510f1b117','3349a8b8-4459-48c0-b6ce-993640def0c1','2026-02-19 09:34:56',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1410556822-dep_1-tu5adhlvokhw-0-k33t7erpivyk','state changed','OS::Heat::SoftwareDeployment',NULL,220),(1108,'0166fcad-dede-43a1-9309-33e3649d1207','79892d56-0422-4f3a-ae6c-27fbcdab44c4','2026-02-19 09:34:56',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1410556822-dep_0-jk6x72auoxdp-0-rb5gjy3krxc6','state changed','OS::Heat::SoftwareDeployment',NULL,221),(1109,'dfaa9aa1-0f73-42ae-af7b-e1c29464d4fa','18c48800-76e2-47ab-8134-7fab4ec386f0','2026-02-19 09:34:57',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-317615709','18c48800-76e2-47ab-8134-7fab4ec386f0','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1110,'eed56d73-7a55-4afa-bf6a-4effee8ef19e','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','2026-02-19 09:34:58',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1791753119-foo_step2-i5l6jbopr6bf','Hook pre-update is cleared','OS::Heat::RandomString',NULL,NULL),(1111,'8ffbfd24-b580-48cf-9199-4df9a1b41b87','18c48800-76e2-47ab-8134-7fab4ec386f0','2026-02-19 09:34:58',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-317615709-config-n6sq3v3xsog3','state changed','OS::Heat::SoftwareConfig',NULL,222),(1112,'f00a7f70-0ad5-4de3-90d1-078c01e9b87c','18c48800-76e2-47ab-8134-7fab4ec386f0','2026-02-19 09:34:58',NULL,'CREATE','COMPLETE','config','2981258c-dfb0-42bf-8160-f414567f8986','state changed','OS::Heat::SoftwareConfig',NULL,222),(1113,'b5a4c756-05fc-48f1-a6dc-8b8d31f4fdb5','18c48800-76e2-47ab-8134-7fab4ec386f0','2026-02-19 09:34:58',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-317615709-dep_2-heywnavye66z','state changed','OS::Heat::SoftwareDeployments',NULL,223),(1114,'f56dc9de-f022-4bf8-a0f6-7cfc48914d3a','18c48800-76e2-47ab-8134-7fab4ec386f0','2026-02-19 09:34:58',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-317615709-dep_0-kcpo3kgmif5f','state changed','OS::Heat::SoftwareDeployments',NULL,224),(1115,'820911f8-edd0-48d6-8c52-ebc0edbe339b','18c48800-76e2-47ab-8134-7fab4ec386f0','2026-02-19 09:34:58',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-317615709-dep_1-mnl43z36sp7l','state changed','OS::Heat::SoftwareDeployments',NULL,225),(1116,'a25e259d-d386-47e4-a1d0-99e5d2bfeefe','e3887d7f-9336-436e-a13e-5ad7b54026f0','2026-02-19 09:35:00',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-317615709-dep_2-heywnavye66z','e3887d7f-9336-436e-a13e-5ad7b54026f0','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1117,'f688d45f-a45b-4833-a024-5c867ea39432','b3b98c6e-4be1-459d-b2cf-bc6432e71203','2026-02-19 09:35:01',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-317615709-dep_1-mnl43z36sp7l','b3b98c6e-4be1-459d-b2cf-bc6432e71203','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1118,'0ae02133-11b5-4ecc-830c-6ea8b8d7e787','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','2026-02-19 09:35:01',NULL,'UPDATE','COMPLETE','HooksTest-1791753119','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1119,'7b562a0b-c8a8-46c5-a28c-f67091a89528','7161156d-d594-4d7e-939f-0f38f838800d','2026-02-19 09:35:01',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-317615709-dep_0-kcpo3kgmif5f','7161156d-d594-4d7e-939f-0f38f838800d','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1120,'aaaddf57-217c-4045-b25c-f3095c4850fa','e3887d7f-9336-436e-a13e-5ad7b54026f0','2026-02-19 09:35:01',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-317615709-dep_2-heywnavye66z-0-xna6ugwxu6gk','state changed','OS::Heat::SoftwareDeployment',NULL,226),(1121,'603d11fe-1903-4bd9-b15a-127865e2e5b5','b3b98c6e-4be1-459d-b2cf-bc6432e71203','2026-02-19 09:35:01',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-317615709-dep_1-mnl43z36sp7l-0-qxwt6x6rqy54','state changed','OS::Heat::SoftwareDeployment',NULL,227),(1122,'964b50ae-3b24-413d-b22f-8bf31de215e6','7161156d-d594-4d7e-939f-0f38f838800d','2026-02-19 09:35:01',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-317615709-dep_0-kcpo3kgmif5f-0-642gkmdkw2xt','state changed','OS::Heat::SoftwareDeployment',NULL,228),(1123,'bffc28dc-1f94-4da9-bb96-01faa487e994','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','2026-02-19 09:35:03',NULL,'DELETE','IN_PROGRESS','HooksTest-1791753119','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1124,'96a2a4ed-cc70-4f1d-a28f-0bc081e47758','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','2026-02-19 09:35:03',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-1791753119-foo_step3-pk26eys54gms','state changed','OS::Heat::RandomString',NULL,NULL),(1125,'27647153-f184-4567-a6a0-f042f7f2a642','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','2026-02-19 09:35:03',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-1791753119-foo_step3-pk26eys54gms','state changed','OS::Heat::RandomString',NULL,NULL),(1126,'7fbd208f-78e9-4932-be44-a7d829163f72','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','2026-02-19 09:35:03',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-1791753119-foo_step2-i5l6jbopr6bf','state changed','OS::Heat::RandomString',NULL,NULL),(1127,'9ee25d8e-1c3d-40f4-a93e-c48d26b35246','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','2026-02-19 09:35:03',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-1791753119-foo_step2-i5l6jbopr6bf','state changed','OS::Heat::RandomString',NULL,NULL),(1128,'f5704001-ae05-4e57-8ac3-a2b4eeca0aa0','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','2026-02-19 09:35:03',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-1791753119-foo_step1-auwdovhzyw2u','state changed','OS::Heat::RandomString',NULL,NULL),(1129,'217971a5-f607-43a8-8dcb-796d5be7b7d9','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','2026-02-19 09:35:03',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-1791753119-foo_step1-auwdovhzyw2u','state changed','OS::Heat::RandomString',NULL,NULL),(1130,'37e49610-ff60-4cd8-ad6e-3c5549c44abb','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','2026-02-19 09:35:03',NULL,'DELETE','COMPLETE','HooksTest-1791753119','859d9730-c8f1-4b5d-9048-a8f4b117fbd0','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1131,'207034cd-8b63-4486-b1b3-8d1c1b3fd36e','18c48800-76e2-47ab-8134-7fab4ec386f0','2026-02-19 09:35:08',NULL,'CREATE','FAILED','ParallelDeploymentsTest-317615709','18c48800-76e2-47ab-8134-7fab4ec386f0','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1132,'524859ac-9aa4-4b65-a0c4-fadb99af17ab','7161156d-d594-4d7e-939f-0f38f838800d','2026-02-19 09:35:08',NULL,'CREATE','FAILED','ParallelDeploymentsTest-317615709-dep_0-kcpo3kgmif5f','7161156d-d594-4d7e-939f-0f38f838800d','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1133,'f2f1c45f-a2db-46cc-bdc2-7a8bc76845b5','18c48800-76e2-47ab-8134-7fab4ec386f0','2026-02-19 09:35:08',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-317615709','18c48800-76e2-47ab-8134-7fab4ec386f0','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1134,'6ea75508-021f-4dc0-b83a-ab924faacd37','18c48800-76e2-47ab-8134-7fab4ec386f0','2026-02-19 09:35:09',NULL,'CREATE','FAILED','dep_2','e3887d7f-9336-436e-a13e-5ad7b54026f0','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployments',NULL,223),(1135,'3455edad-9a3c-4c62-b5c7-a4f76e0fad6d','e3887d7f-9336-436e-a13e-5ad7b54026f0','2026-02-19 09:35:09',NULL,'CREATE','FAILED','ParallelDeploymentsTest-317615709-dep_2-heywnavye66z','e3887d7f-9336-436e-a13e-5ad7b54026f0','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1136,'5a4a56ca-2f9a-454a-85aa-9b596585560c','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:09',NULL,'CREATE','IN_PROGRESS','HooksTest-1803794222','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1137,'9a4cfa59-1fde-41fa-bac0-aa7847adb471','18c48800-76e2-47ab-8134-7fab4ec386f0','2026-02-19 09:35:09',NULL,'CREATE','FAILED','dep_0','7161156d-d594-4d7e-939f-0f38f838800d','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployments',NULL,224),(1138,'c7acf52d-3f4b-472d-8ae6-8e4fa93dbab7','18c48800-76e2-47ab-8134-7fab4ec386f0','2026-02-19 09:35:09',NULL,'CREATE','FAILED','dep_1','b3b98c6e-4be1-459d-b2cf-bc6432e71203','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployments',NULL,225),(1139,'0cfbff98-c367-42ba-ba0a-6b2f5af2b70f','b3b98c6e-4be1-459d-b2cf-bc6432e71203','2026-02-19 09:35:10',NULL,'CREATE','FAILED','ParallelDeploymentsTest-317615709-dep_1-mnl43z36sp7l','b3b98c6e-4be1-459d-b2cf-bc6432e71203','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1140,'22d08f7e-a058-487f-b69d-62b338f1f930','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:10',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-1803794222-foo_step1-mfjkppdfdpdu','state changed','OS::Heat::RandomString',NULL,NULL),(1141,'ccaaa3b2-1625-441a-829f-2beda8c1bfae','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:10',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-1803794222-foo_step1-mfjkppdfdpdu','state changed','OS::Heat::RandomString',NULL,NULL),(1142,'b6251fdf-bb2a-400a-b0e4-9de9c22b9c96','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:10',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-1803794222-foo_step2-s66vjczpf747','state changed','OS::Heat::RandomString',NULL,NULL),(1143,'0ece2164-be71-414d-97c3-aeb2f3d663da','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:10',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1803794222-foo_step2-s66vjczpf747','state changed','OS::Heat::RandomString',NULL,NULL),(1144,'2c920121-72e6-4c30-9b7f-1a6ac752c9af','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:10',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-1803794222-foo_step3-5glpez3it7ih','state changed','OS::Heat::RandomString',NULL,NULL),(1145,'b6a2563a-481d-4935-934e-67a29f440087','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:10',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-1803794222-foo_step3-5glpez3it7ih','state changed','OS::Heat::RandomString',NULL,NULL),(1146,'ca0c2799-2880-4b7a-83c4-bd332941792c','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:10',NULL,'CREATE','COMPLETE','HooksTest-1803794222','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1147,'4b0362c3-4a0b-4842-9a7c-de38b4b99bbb','18c48800-76e2-47ab-8134-7fab4ec386f0','2026-02-19 09:35:14',NULL,'DELETE','IN_PROGRESS','dep_2','e3887d7f-9336-436e-a13e-5ad7b54026f0','state changed','OS::Heat::SoftwareDeployments',NULL,223),(1148,'f662b9d6-5d76-4d9a-96f8-fe11c2dcaea8','e3887d7f-9336-436e-a13e-5ad7b54026f0','2026-02-19 09:35:14',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-317615709-dep_2-heywnavye66z','e3887d7f-9336-436e-a13e-5ad7b54026f0','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1149,'3a803b7b-d38e-48c8-8688-b21605bfd7a1','3b04657b-376e-4603-ba97-51104a2af738','2026-02-19 09:35:14',NULL,'CREATE','COMPLETE','server','806fd438-e612-492f-9397-e9b9da340904','state changed','OS::Nova::Server',NULL,207),(1150,'631dd2ca-6c6b-4911-82ce-2b69c44442d4','3b04657b-376e-4603-ba97-51104a2af738','2026-02-19 09:35:14',NULL,'CREATE','COMPLETE','swap_subnet_network','3b04657b-376e-4603-ba97-51104a2af738','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1151,'aed6ee0f-9fb3-413c-99a9-2955c7d2ef2c','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:15',NULL,'UPDATE','IN_PROGRESS','HooksTest-1803794222','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1152,'f4c1e343-c83e-47cd-9d04-8bd1172e93c5','18c48800-76e2-47ab-8134-7fab4ec386f0','2026-02-19 09:35:15',NULL,'DELETE','IN_PROGRESS','dep_0','7161156d-d594-4d7e-939f-0f38f838800d','state changed','OS::Heat::SoftwareDeployments',NULL,224),(1153,'e9970f89-6727-4fad-b17c-76d4d75955af','e3887d7f-9336-436e-a13e-5ad7b54026f0','2026-02-19 09:35:15',NULL,'CREATE','FAILED','0','2fb40507-9e5d-41b3-bfb3-5e62f97059cd','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployment',NULL,226),(1154,'d2524d9a-96f5-4bb4-a2f1-6b7dc21de318','7161156d-d594-4d7e-939f-0f38f838800d','2026-02-19 09:35:16',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-317615709-dep_0-kcpo3kgmif5f','7161156d-d594-4d7e-939f-0f38f838800d','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1155,'6f5ad8eb-6f31-4490-ac7e-b175029c7fda','18c48800-76e2-47ab-8134-7fab4ec386f0','2026-02-19 09:35:16',NULL,'DELETE','IN_PROGRESS','dep_1','b3b98c6e-4be1-459d-b2cf-bc6432e71203','state changed','OS::Heat::SoftwareDeployments',NULL,225),(1156,'fa0daee7-fe67-489e-8599-76962d02506c','b3b98c6e-4be1-459d-b2cf-bc6432e71203','2026-02-19 09:35:17',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-317615709-dep_1-mnl43z36sp7l','b3b98c6e-4be1-459d-b2cf-bc6432e71203','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1157,'abb480ca-472c-4671-bd24-96b133dac5f1','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:17',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1803794222-foo_step2-s66vjczpf747','UPDATE paused until Hook pre-update is cleared','OS::Heat::RandomString',NULL,NULL),(1158,'b5c3c1cb-bcb8-455f-bc5a-2d7a986d0216','7161156d-d594-4d7e-939f-0f38f838800d','2026-02-19 09:35:17',NULL,'CREATE','FAILED','0','5b8ce621-c180-4e1f-b041-6f057fa6227e','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployment',NULL,228),(1159,'a28287e1-9db4-40ac-86a5-b1e95aa4a158','b3b98c6e-4be1-459d-b2cf-bc6432e71203','2026-02-19 09:35:18',NULL,'CREATE','FAILED','0','9cd5cb42-7a9e-46de-9afc-c3481fc8cf41','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployment',NULL,227),(1160,'374df7ad-77e7-47da-9912-6413f8cd5e90','3b04657b-376e-4603-ba97-51104a2af738','2026-02-19 09:35:19',NULL,'UPDATE','IN_PROGRESS','swap_subnet_network','3b04657b-376e-4603-ba97-51104a2af738','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1161,'e9d5abe9-2c72-46fc-ae06-681ff490b80c','e3887d7f-9336-436e-a13e-5ad7b54026f0','2026-02-19 09:35:19',NULL,'DELETE','IN_PROGRESS','0','2fb40507-9e5d-41b3-bfb3-5e62f97059cd','state changed','OS::Heat::SoftwareDeployment',NULL,226),(1162,'f059fe9a-cd77-4f57-a0f4-a22fbf604f8a','3b04657b-376e-4603-ba97-51104a2af738','2026-02-19 09:35:20',NULL,'UPDATE','IN_PROGRESS','server','806fd438-e612-492f-9397-e9b9da340904','state changed','OS::Nova::Server',NULL,207),(1163,'dbb6cea4-d181-42fa-be54-c81eec2a254c','e3887d7f-9336-436e-a13e-5ad7b54026f0','2026-02-19 09:35:21',NULL,'DELETE','COMPLETE','0','2fb40507-9e5d-41b3-bfb3-5e62f97059cd','state changed','OS::Heat::SoftwareDeployment',NULL,226),(1164,'3d399d98-8058-4254-897a-767146c1627f','e3887d7f-9336-436e-a13e-5ad7b54026f0','2026-02-19 09:35:21',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-317615709-dep_2-heywnavye66z','e3887d7f-9336-436e-a13e-5ad7b54026f0','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1165,'593b1ef5-a828-40e7-ab94-5f9baeddf8a1','18c48800-76e2-47ab-8134-7fab4ec386f0','2026-02-19 09:35:21',NULL,'DELETE','COMPLETE','dep_2','e3887d7f-9336-436e-a13e-5ad7b54026f0','state changed','OS::Heat::SoftwareDeployments',NULL,223),(1166,'702d3f2c-bc77-44f4-926f-815d19b2bb2c','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:22',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1803794222-foo_step2-s66vjczpf747','Hook pre-update is cleared','OS::Heat::RandomString',NULL,NULL),(1167,'fe54905e-8a88-4703-81f4-81290467e4eb','7161156d-d594-4d7e-939f-0f38f838800d','2026-02-19 09:35:22',NULL,'DELETE','IN_PROGRESS','0','5b8ce621-c180-4e1f-b041-6f057fa6227e','state changed','OS::Heat::SoftwareDeployment',NULL,228),(1168,'2ab607c9-b1af-4924-9b5a-bc7ebc9311b1','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:22',NULL,'UPDATE','IN_PROGRESS','foo_step2','HooksTest-1803794222-foo_step2-s66vjczpf747','state changed','OS::Heat::RandomString',NULL,NULL),(1169,'35687d63-159d-47ff-ac32-c259c720840e','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:22',NULL,'UPDATE','COMPLETE','foo_step2','HooksTest-1803794222-foo_step2-s66vjczpf747','The Resource foo_step2 requires replacement.','OS::Heat::RandomString',NULL,NULL),(1170,'5119c925-a54c-466f-a102-e0188b865807','b3b98c6e-4be1-459d-b2cf-bc6432e71203','2026-02-19 09:35:23',NULL,'DELETE','IN_PROGRESS','0','9cd5cb42-7a9e-46de-9afc-c3481fc8cf41','state changed','OS::Heat::SoftwareDeployment',NULL,227),(1171,'2768cd60-2b1a-4e52-ba3b-a4782da6c375','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:23',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-1803794222-foo_step2-bs46fheiu2l6','state changed','OS::Heat::RandomString',NULL,230),(1172,'ae52831b-3d6d-4f0d-bddc-837dfad9b688','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:23',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1803794222-foo_step2-bs46fheiu2l6','state changed','OS::Heat::RandomString',NULL,230),(1173,'be84f00c-1792-482b-83be-b0f1d030aa54','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:23',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-1803794222-foo_step2-s66vjczpf747','state changed','OS::Heat::RandomString',NULL,NULL),(1174,'476452f5-68bc-4546-9af7-375fc40f4e4c','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:23',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-1803794222-foo_step2-s66vjczpf747','state changed','OS::Heat::RandomString',NULL,NULL),(1175,'a4431d3c-3f1a-43d1-ba33-0cd3fde1cdf2','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:23',NULL,'UPDATE','COMPLETE','HooksTest-1803794222','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1176,'adc622a1-8907-4762-b36b-67e0d29095ef','7161156d-d594-4d7e-939f-0f38f838800d','2026-02-19 09:35:24',NULL,'DELETE','COMPLETE','0','5b8ce621-c180-4e1f-b041-6f057fa6227e','state changed','OS::Heat::SoftwareDeployment',NULL,228),(1177,'b324e7b7-7490-44a4-b49d-f0c9a7ea051a','7161156d-d594-4d7e-939f-0f38f838800d','2026-02-19 09:35:24',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-317615709-dep_0-kcpo3kgmif5f','7161156d-d594-4d7e-939f-0f38f838800d','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1178,'87617f4e-0979-4737-86bc-06b98a7bbc1c','b3b98c6e-4be1-459d-b2cf-bc6432e71203','2026-02-19 09:35:24',NULL,'DELETE','COMPLETE','0','9cd5cb42-7a9e-46de-9afc-c3481fc8cf41','state changed','OS::Heat::SoftwareDeployment',NULL,227),(1179,'93acb3e1-f53e-4169-9a13-363cb9f197a5','b3b98c6e-4be1-459d-b2cf-bc6432e71203','2026-02-19 09:35:24',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-317615709-dep_1-mnl43z36sp7l','b3b98c6e-4be1-459d-b2cf-bc6432e71203','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1180,'e0cb0e97-e8da-4a24-9493-3ea2133dfd2e','18c48800-76e2-47ab-8134-7fab4ec386f0','2026-02-19 09:35:24',NULL,'DELETE','COMPLETE','dep_1','b3b98c6e-4be1-459d-b2cf-bc6432e71203','state changed','OS::Heat::SoftwareDeployments',NULL,225),(1181,'d05e3930-29e6-43a6-b8c7-0a6e30335487','18c48800-76e2-47ab-8134-7fab4ec386f0','2026-02-19 09:35:24',NULL,'DELETE','COMPLETE','dep_0','7161156d-d594-4d7e-939f-0f38f838800d','state changed','OS::Heat::SoftwareDeployments',NULL,224),(1182,'c4c81e86-ac0c-48e0-9ae0-6eda928640a9','18c48800-76e2-47ab-8134-7fab4ec386f0','2026-02-19 09:35:24',NULL,'DELETE','IN_PROGRESS','config','2981258c-dfb0-42bf-8160-f414567f8986','state changed','OS::Heat::SoftwareConfig',NULL,222),(1183,'97d61d72-12d0-4759-a4d6-3c0bf6792cb4','18c48800-76e2-47ab-8134-7fab4ec386f0','2026-02-19 09:35:24',NULL,'DELETE','COMPLETE','config','2981258c-dfb0-42bf-8160-f414567f8986','state changed','OS::Heat::SoftwareConfig',NULL,222),(1184,'d20d3ada-1e11-4af7-b022-bb8f835a8360','18c48800-76e2-47ab-8134-7fab4ec386f0','2026-02-19 09:35:24',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-317615709','18c48800-76e2-47ab-8134-7fab4ec386f0','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1185,'35f5c3a6-4ebd-4353-be9a-b9d99355681b','3b04657b-376e-4603-ba97-51104a2af738','2026-02-19 09:35:25',NULL,'UPDATE','COMPLETE','server','806fd438-e612-492f-9397-e9b9da340904','state changed','OS::Nova::Server',NULL,231),(1186,'ec6593ea-08f2-47a2-a807-0041e8eaa7b7','3b04657b-376e-4603-ba97-51104a2af738','2026-02-19 09:35:25',NULL,'UPDATE','COMPLETE','swap_subnet_network','3b04657b-376e-4603-ba97-51104a2af738','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1187,'3d0f28a2-b566-44b8-acb3-d992f110e896','6a4f464f-6f93-4c05-9f4d-1520e9778a71','2026-02-19 09:35:28',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1410556822','6a4f464f-6f93-4c05-9f4d-1520e9778a71','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1188,'c8fc2987-7de0-42ef-a31e-54f84728e4a9','3349a8b8-4459-48c0-b6ce-993640def0c1','2026-02-19 09:35:28',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1410556822-dep_1-tu5adhlvokhw','3349a8b8-4459-48c0-b6ce-993640def0c1','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1189,'e812b482-e771-4584-8bb9-8bee8fd991d9','6a4f464f-6f93-4c05-9f4d-1520e9778a71','2026-02-19 09:35:29',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1410556822','6a4f464f-6f93-4c05-9f4d-1520e9778a71','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1190,'65688417-e886-4dd4-afc2-86b3c68b878a','6a4f464f-6f93-4c05-9f4d-1520e9778a71','2026-02-19 09:35:29',NULL,'CREATE','FAILED','dep_1','3349a8b8-4459-48c0-b6ce-993640def0c1','resources.dep_1: Stack CREATE cancelled','OS::Heat::SoftwareDeployments',NULL,216),(1191,'e91987d6-f1c8-490d-8949-243b3584dad6','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:29',NULL,'DELETE','IN_PROGRESS','HooksTest-1803794222','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1192,'619caea2-da2b-4f2f-961a-0560b2484828','6a4f464f-6f93-4c05-9f4d-1520e9778a71','2026-02-19 09:35:29',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1410556822','6a4f464f-6f93-4c05-9f4d-1520e9778a71','Resource CREATE failed: resources.dep_1: Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1193,'6d64a96c-de0f-4c6d-8ee6-08f790414d6e','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:30',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-1803794222-foo_step3-5glpez3it7ih','state changed','OS::Heat::RandomString',NULL,NULL),(1194,'89e3c666-13c0-4dfe-b27d-462584de5620','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:30',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-1803794222-foo_step3-5glpez3it7ih','state changed','OS::Heat::RandomString',NULL,NULL),(1195,'80660b61-7486-4bc0-a60c-5965e12669ec','6a4f464f-6f93-4c05-9f4d-1520e9778a71','2026-02-19 09:35:30',NULL,'CREATE','FAILED','dep_0','79892d56-0422-4f3a-ae6c-27fbcdab44c4','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployments',NULL,218),(1196,'ac5d6a95-0bbf-4c70-9c10-8da2ce18ac47','79892d56-0422-4f3a-ae6c-27fbcdab44c4','2026-02-19 09:35:30',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1410556822-dep_0-jk6x72auoxdp','79892d56-0422-4f3a-ae6c-27fbcdab44c4','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1197,'e6d688ae-6a5a-45b9-a4d7-bd64d0cfba7d','6a4f464f-6f93-4c05-9f4d-1520e9778a71','2026-02-19 09:35:30',NULL,'CREATE','FAILED','dep_2','3cd4e73d-0495-4d25-a6e6-97180bc46b74','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployments',NULL,217),(1198,'3d7f9412-997a-4351-9911-d02832f88de0','3cd4e73d-0495-4d25-a6e6-97180bc46b74','2026-02-19 09:35:30',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1410556822-dep_2-6jtmimpikcgr','3cd4e73d-0495-4d25-a6e6-97180bc46b74','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1199,'1f5d6f2a-5299-4d90-a8e6-945d6d56f8c6','3b04657b-376e-4603-ba97-51104a2af738','2026-02-19 09:35:31',NULL,'DELETE','IN_PROGRESS','swap_subnet_network','3b04657b-376e-4603-ba97-51104a2af738','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1200,'f8ee6806-bd67-4009-b532-c390b0f03cd8','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:31',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-1803794222-foo_step2-bs46fheiu2l6','state changed','OS::Heat::RandomString',NULL,230),(1201,'1eb855b5-c300-4d6d-90ac-82b7a807c98d','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:31',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-1803794222-foo_step2-bs46fheiu2l6','state changed','OS::Heat::RandomString',NULL,230),(1202,'c4b92cd7-1edc-478f-91c1-df7a3917678f','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:31',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-1803794222-foo_step1-mfjkppdfdpdu','state changed','OS::Heat::RandomString',NULL,NULL),(1203,'2a598f9d-a67b-4a42-bd09-5892dbbb7c10','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:31',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-1803794222-foo_step1-mfjkppdfdpdu','state changed','OS::Heat::RandomString',NULL,NULL),(1204,'10794ff4-9b4a-434f-9f0d-9710c1b27949','3b04657b-376e-4603-ba97-51104a2af738','2026-02-19 09:35:31',NULL,'DELETE','IN_PROGRESS','server','806fd438-e612-492f-9397-e9b9da340904','state changed','OS::Nova::Server',NULL,231),(1205,'da8a6866-5d66-4719-ae68-b2a7ed51a658','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:31',NULL,'DELETE','COMPLETE','HooksTest-1803794222','c46b4a05-f25d-4aa5-9a1e-26acd484ef92','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1206,'e5e066e6-5d7d-40f4-8696-b712d3938627','6a4f464f-6f93-4c05-9f4d-1520e9778a71','2026-02-19 09:35:34',NULL,'DELETE','IN_PROGRESS','dep_1','3349a8b8-4459-48c0-b6ce-993640def0c1','state changed','OS::Heat::SoftwareDeployments',NULL,216),(1207,'68e57712-cd2a-474a-8794-ad4e5bd3718a','3349a8b8-4459-48c0-b6ce-993640def0c1','2026-02-19 09:35:35',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1410556822-dep_1-tu5adhlvokhw','3349a8b8-4459-48c0-b6ce-993640def0c1','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1208,'08fe94ea-4f71-4647-9a24-9366e66f762e','3349a8b8-4459-48c0-b6ce-993640def0c1','2026-02-19 09:35:35',NULL,'CREATE','FAILED','0','fe0186ca-0de8-4df2-be7b-d4a46074770a','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployment',NULL,220),(1209,'ab1e3888-c115-46b5-ba3d-8cda8b6592a4','3b04657b-376e-4603-ba97-51104a2af738','2026-02-19 09:35:35',NULL,'DELETE','COMPLETE','server','806fd438-e612-492f-9397-e9b9da340904','state changed','OS::Nova::Server',NULL,231),(1210,'6c56c027-5602-453a-b9f4-aed9929b0c6f','3b04657b-376e-4603-ba97-51104a2af738','2026-02-19 09:35:35',NULL,'DELETE','IN_PROGRESS','subnet','73f8bb89-d1dc-4554-940b-631d92cb5128','state changed','OS::Neutron::Subnet',NULL,206),(1211,'883f9e05-ab47-42ca-abe1-eb3019104eb1','267e404a-4237-45f3-8727-7c300d5f4de6','2026-02-19 09:35:35',NULL,'CREATE','IN_PROGRESS','StackEventsTest-549012179','267e404a-4237-45f3-8727-7c300d5f4de6','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1212,'5881c444-9dec-4335-a30a-09ce7c89bef2','267e404a-4237-45f3-8727-7c300d5f4de6','2026-02-19 09:35:36',NULL,'CREATE','IN_PROGRESS','test_resource','StackEventsTest-549012179-test_resource-ujathesd76fo','state changed','OS::Heat::TestResource',NULL,233),(1213,'4f89ac45-a470-425e-b352-a06fb9a75e2b','6a4f464f-6f93-4c05-9f4d-1520e9778a71','2026-02-19 09:35:36',NULL,'DELETE','IN_PROGRESS','dep_2','3cd4e73d-0495-4d25-a6e6-97180bc46b74','state changed','OS::Heat::SoftwareDeployments',NULL,217),(1214,'5fd5b4fc-bbff-485a-834d-bf0acd28299e','267e404a-4237-45f3-8727-7c300d5f4de6','2026-02-19 09:35:36',NULL,'CREATE','COMPLETE','test_resource','StackEventsTest-549012179-test_resource-ujathesd76fo','state changed','OS::Heat::TestResource',NULL,233),(1215,'5dbedda5-017b-4631-8cc8-167cfe3872fa','3cd4e73d-0495-4d25-a6e6-97180bc46b74','2026-02-19 09:35:36',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1410556822-dep_2-6jtmimpikcgr','3cd4e73d-0495-4d25-a6e6-97180bc46b74','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1216,'3b64c857-8d0d-49ad-9b97-b30898ed0448','267e404a-4237-45f3-8727-7c300d5f4de6','2026-02-19 09:35:36',NULL,'CREATE','COMPLETE','StackEventsTest-549012179','267e404a-4237-45f3-8727-7c300d5f4de6','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1217,'e7428b7b-7da6-437d-b7c2-4e020d29806a','3b04657b-376e-4603-ba97-51104a2af738','2026-02-19 09:35:36',NULL,'DELETE','COMPLETE','subnet','73f8bb89-d1dc-4554-940b-631d92cb5128','state changed','OS::Neutron::Subnet',NULL,206),(1218,'5f3fc445-c343-4e5d-95c6-5c644ce04f0b','3cd4e73d-0495-4d25-a6e6-97180bc46b74','2026-02-19 09:35:36',NULL,'CREATE','FAILED','0','5a98ddad-d997-4559-a439-f8b56988ba40','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployment',NULL,219),(1219,'4dce2924-e63c-4cb6-b16d-4d5950443c21','3b04657b-376e-4603-ba97-51104a2af738','2026-02-19 09:35:36',NULL,'DELETE','IN_PROGRESS','net','19805626-6f29-4186-83ca-8b5a4f3c5a73','state changed','OS::Neutron::Net',NULL,205),(1220,'cb7e4272-b7b8-42bb-9be1-1da134feec60','6a4f464f-6f93-4c05-9f4d-1520e9778a71','2026-02-19 09:35:36',NULL,'DELETE','IN_PROGRESS','dep_0','79892d56-0422-4f3a-ae6c-27fbcdab44c4','state changed','OS::Heat::SoftwareDeployments',NULL,218),(1221,'b51f98a1-d1e9-4fcf-8a89-c8eb6ae3d4fc','79892d56-0422-4f3a-ae6c-27fbcdab44c4','2026-02-19 09:35:37',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1410556822-dep_0-jk6x72auoxdp','79892d56-0422-4f3a-ae6c-27fbcdab44c4','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1222,'832d1cfc-aad8-4b05-88e1-d487b535dabf','3b04657b-376e-4603-ba97-51104a2af738','2026-02-19 09:35:37',NULL,'DELETE','COMPLETE','net','19805626-6f29-4186-83ca-8b5a4f3c5a73','state changed','OS::Neutron::Net',NULL,205),(1223,'b3056b8a-7f72-40e1-b7c2-def716c50ba0','3b04657b-376e-4603-ba97-51104a2af738','2026-02-19 09:35:37',NULL,'DELETE','COMPLETE','swap_subnet_network','3b04657b-376e-4603-ba97-51104a2af738','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1224,'41176324-0584-4cf3-874f-d6691a16767d','79892d56-0422-4f3a-ae6c-27fbcdab44c4','2026-02-19 09:35:37',NULL,'CREATE','FAILED','0','fb33438e-45fd-41fd-8387-ca11cc0c3b92','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployment',NULL,221),(1225,'66ed71be-ddd3-477d-8b3a-89c307b35483','267e404a-4237-45f3-8727-7c300d5f4de6','2026-02-19 09:35:38',NULL,'DELETE','IN_PROGRESS','StackEventsTest-549012179','267e404a-4237-45f3-8727-7c300d5f4de6','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1226,'5401404b-964c-4dac-b67a-5cea0aa671aa','267e404a-4237-45f3-8727-7c300d5f4de6','2026-02-19 09:35:38',NULL,'DELETE','IN_PROGRESS','test_resource','StackEventsTest-549012179-test_resource-ujathesd76fo','state changed','OS::Heat::TestResource',NULL,233),(1227,'6d616242-bf8e-4d96-a0d4-36caf274bfa5','267e404a-4237-45f3-8727-7c300d5f4de6','2026-02-19 09:35:38',NULL,'DELETE','COMPLETE','test_resource','StackEventsTest-549012179-test_resource-ujathesd76fo','state changed','OS::Heat::TestResource',NULL,233),(1228,'f86a6de7-d859-4ffc-8e32-6643fc19172f','267e404a-4237-45f3-8727-7c300d5f4de6','2026-02-19 09:35:38',NULL,'DELETE','COMPLETE','StackEventsTest-549012179','267e404a-4237-45f3-8727-7c300d5f4de6','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1229,'7c179cf2-974d-4158-9c59-6516bc64e6e1','3349a8b8-4459-48c0-b6ce-993640def0c1','2026-02-19 09:35:40',NULL,'DELETE','IN_PROGRESS','0','fe0186ca-0de8-4df2-be7b-d4a46074770a','state changed','OS::Heat::SoftwareDeployment',NULL,220),(1230,'db1c102b-63cb-42fd-a233-d27a2f97aeea','3cd4e73d-0495-4d25-a6e6-97180bc46b74','2026-02-19 09:35:41',NULL,'DELETE','IN_PROGRESS','0','5a98ddad-d997-4559-a439-f8b56988ba40','state changed','OS::Heat::SoftwareDeployment',NULL,219),(1231,'6df3ff61-5f75-455a-b97c-a0d966330246','3349a8b8-4459-48c0-b6ce-993640def0c1','2026-02-19 09:35:41',NULL,'DELETE','COMPLETE','0','fe0186ca-0de8-4df2-be7b-d4a46074770a','state changed','OS::Heat::SoftwareDeployment',NULL,220),(1232,'2b35daa9-c2ad-45ee-bf86-7a3ee86abd07','3349a8b8-4459-48c0-b6ce-993640def0c1','2026-02-19 09:35:41',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1410556822-dep_1-tu5adhlvokhw','3349a8b8-4459-48c0-b6ce-993640def0c1','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1233,'37ad305e-1346-4520-abd5-aa2f062f1c05','79892d56-0422-4f3a-ae6c-27fbcdab44c4','2026-02-19 09:35:42',NULL,'DELETE','IN_PROGRESS','0','fb33438e-45fd-41fd-8387-ca11cc0c3b92','state changed','OS::Heat::SoftwareDeployment',NULL,221),(1234,'8a589993-e31e-42c7-8514-42049b2d4eca','3cd4e73d-0495-4d25-a6e6-97180bc46b74','2026-02-19 09:35:42',NULL,'DELETE','COMPLETE','0','5a98ddad-d997-4559-a439-f8b56988ba40','state changed','OS::Heat::SoftwareDeployment',NULL,219),(1235,'51a55bf4-0456-40b7-89db-c454fc4aa57a','3cd4e73d-0495-4d25-a6e6-97180bc46b74','2026-02-19 09:35:42',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1410556822-dep_2-6jtmimpikcgr','3cd4e73d-0495-4d25-a6e6-97180bc46b74','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1236,'0e3f178d-8941-4130-be94-218db2d57576','6a4f464f-6f93-4c05-9f4d-1520e9778a71','2026-02-19 09:35:42',NULL,'DELETE','COMPLETE','dep_1','3349a8b8-4459-48c0-b6ce-993640def0c1','state changed','OS::Heat::SoftwareDeployments',NULL,216),(1237,'b83ac5ad-90b5-4064-bfed-393e174af631','79892d56-0422-4f3a-ae6c-27fbcdab44c4','2026-02-19 09:35:43',NULL,'DELETE','COMPLETE','0','fb33438e-45fd-41fd-8387-ca11cc0c3b92','state changed','OS::Heat::SoftwareDeployment',NULL,221),(1238,'df821dd1-5fa1-4c0e-820f-4f8c6be70805','79892d56-0422-4f3a-ae6c-27fbcdab44c4','2026-02-19 09:35:43',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1410556822-dep_0-jk6x72auoxdp','79892d56-0422-4f3a-ae6c-27fbcdab44c4','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1239,'d1ae4aec-6aa6-49f3-9029-3c64042c0a49','6a4f464f-6f93-4c05-9f4d-1520e9778a71','2026-02-19 09:35:43',NULL,'DELETE','COMPLETE','dep_2','3cd4e73d-0495-4d25-a6e6-97180bc46b74','state changed','OS::Heat::SoftwareDeployments',NULL,217),(1240,'b702ce57-eb3d-4b85-8edd-4bc5fbb563b5','6a4f464f-6f93-4c05-9f4d-1520e9778a71','2026-02-19 09:35:43',NULL,'DELETE','COMPLETE','dep_0','79892d56-0422-4f3a-ae6c-27fbcdab44c4','state changed','OS::Heat::SoftwareDeployments',NULL,218),(1241,'15a6d38e-6b5e-4f63-82a3-27d582bd8192','6a4f464f-6f93-4c05-9f4d-1520e9778a71','2026-02-19 09:35:43',NULL,'DELETE','IN_PROGRESS','config','843caaf1-a1b1-4ff8-b665-996aacf85dce','state changed','OS::Heat::SoftwareConfig',NULL,215),(1242,'7e45a8f6-3e41-4ab4-a916-45ac4eddcabf','6a4f464f-6f93-4c05-9f4d-1520e9778a71','2026-02-19 09:35:43',NULL,'DELETE','COMPLETE','config','843caaf1-a1b1-4ff8-b665-996aacf85dce','state changed','OS::Heat::SoftwareConfig',NULL,215),(1243,'26500c29-8562-4546-a8e9-5d86650205f1','6a4f464f-6f93-4c05-9f4d-1520e9778a71','2026-02-19 09:35:43',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1410556822','6a4f464f-6f93-4c05-9f4d-1520e9778a71','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1244,'38d52ec8-60ca-4efb-8278-7a3759fe233e','bb5e89c3-c837-4b24-8b6e-1d83a34bd967','2026-02-19 09:35:44',NULL,'CREATE','IN_PROGRESS','StackTagTest-1821210739','bb5e89c3-c837-4b24-8b6e-1d83a34bd967','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1245,'d45d3564-6f8d-4341-98a4-9a25a2617d81','bb5e89c3-c837-4b24-8b6e-1d83a34bd967','2026-02-19 09:35:44',NULL,'CREATE','IN_PROGRESS','not-used','StackTagTest-1821210739-not-used-gbf5g6zsluh6','state changed','OS::Heat::TestResource',NULL,234),(1246,'c028915c-2a03-4ebb-b0ab-d0cbc5f4f572','bb5e89c3-c837-4b24-8b6e-1d83a34bd967','2026-02-19 09:35:47',NULL,'CREATE','COMPLETE','not-used','StackTagTest-1821210739-not-used-gbf5g6zsluh6','state changed','OS::Heat::TestResource',NULL,234),(1247,'26e47809-f35f-41e6-a70f-c9de90bc3cee','bb5e89c3-c837-4b24-8b6e-1d83a34bd967','2026-02-19 09:35:47',NULL,'CREATE','COMPLETE','StackTagTest-1821210739','bb5e89c3-c837-4b24-8b6e-1d83a34bd967','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1248,'ca8752fb-e787-4c1a-a181-6ae672abc20d','4ed35a8c-642e-4763-8389-c7148eaf292c','2026-02-19 09:35:48',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1864767498','4ed35a8c-642e-4763-8389-c7148eaf292c','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1249,'44114134-e17b-4f48-b7a0-2613a8b3509f','39b754ea-2fb5-4e80-a0a0-c0b67163b1f4','2026-02-19 09:35:48',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1864767498-dep_0-khwzne6zbzlh','39b754ea-2fb5-4e80-a0a0-c0b67163b1f4','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1250,'d97b61b0-32ff-40db-8669-35fbc151d760','4ed35a8c-642e-4763-8389-c7148eaf292c','2026-02-19 09:35:48',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1864767498','4ed35a8c-642e-4763-8389-c7148eaf292c','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1251,'57e56db0-0f8f-4e28-8fbb-f01c20178d2c','4ed35a8c-642e-4763-8389-c7148eaf292c','2026-02-19 09:35:49',NULL,'CREATE','FAILED','dep_0','39b754ea-2fb5-4e80-a0a0-c0b67163b1f4','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployments',NULL,209),(1252,'e11cb76a-8394-44fb-beca-6ec689f1c561','68a6a357-ff37-4b82-9ceb-ffcf88ae3a85','2026-02-19 09:35:49',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1864767498-dep_2-rgyaphd5dp2l','68a6a357-ff37-4b82-9ceb-ffcf88ae3a85','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1253,'47182cce-2485-48cf-9a77-063cff19a951','4ed35a8c-642e-4763-8389-c7148eaf292c','2026-02-19 09:35:49',NULL,'CREATE','FAILED','dep_2','68a6a357-ff37-4b82-9ceb-ffcf88ae3a85','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployments',NULL,211),(1254,'5468f993-205b-4a7a-8f6f-84757c6df727','e1c8d1f5-3f1e-40c6-aab0-fa49073f9153','2026-02-19 09:35:49',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1864767498-dep_1-jeip62xpeid3','e1c8d1f5-3f1e-40c6-aab0-fa49073f9153','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1255,'baefc99d-cba5-4a65-bd51-8f4b215993cb','4ed35a8c-642e-4763-8389-c7148eaf292c','2026-02-19 09:35:49',NULL,'CREATE','FAILED','dep_1','e1c8d1f5-3f1e-40c6-aab0-fa49073f9153','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployments',NULL,210),(1256,'d65c5376-58e1-4f38-8e07-dfe4a31c181b','bb5e89c3-c837-4b24-8b6e-1d83a34bd967','2026-02-19 09:35:50',NULL,'DELETE','IN_PROGRESS','StackTagTest-1821210739','bb5e89c3-c837-4b24-8b6e-1d83a34bd967','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1257,'44861e3b-40b9-482c-b2bd-56f033d0e3df','bb5e89c3-c837-4b24-8b6e-1d83a34bd967','2026-02-19 09:35:50',NULL,'DELETE','IN_PROGRESS','not-used','StackTagTest-1821210739-not-used-gbf5g6zsluh6','state changed','OS::Heat::TestResource',NULL,234),(1258,'bea8c5fd-4bfc-4677-a213-6b7f220c8ba8','bb5e89c3-c837-4b24-8b6e-1d83a34bd967','2026-02-19 09:35:53',NULL,'DELETE','COMPLETE','not-used','StackTagTest-1821210739-not-used-gbf5g6zsluh6','state changed','OS::Heat::TestResource',NULL,234),(1259,'23764b3d-b517-4aa4-b56d-0382d10dd1c0','bb5e89c3-c837-4b24-8b6e-1d83a34bd967','2026-02-19 09:35:53',NULL,'DELETE','COMPLETE','StackTagTest-1821210739','bb5e89c3-c837-4b24-8b6e-1d83a34bd967','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1260,'68c41683-a961-4d0f-b06c-56fbe146701f','4ed35a8c-642e-4763-8389-c7148eaf292c','2026-02-19 09:35:55',NULL,'DELETE','IN_PROGRESS','dep_0','39b754ea-2fb5-4e80-a0a0-c0b67163b1f4','state changed','OS::Heat::SoftwareDeployments',NULL,209),(1261,'d60a4305-b313-4c7f-8833-b06a9d2224a9','4ed35a8c-642e-4763-8389-c7148eaf292c','2026-02-19 09:35:55',NULL,'DELETE','IN_PROGRESS','dep_1','e1c8d1f5-3f1e-40c6-aab0-fa49073f9153','state changed','OS::Heat::SoftwareDeployments',NULL,210),(1262,'11dd8783-0043-4cfe-9a8a-b6717e2cdebe','39b754ea-2fb5-4e80-a0a0-c0b67163b1f4','2026-02-19 09:35:55',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1864767498-dep_0-khwzne6zbzlh','39b754ea-2fb5-4e80-a0a0-c0b67163b1f4','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1263,'b5981f21-c76c-4076-8528-18442b95ffd6','e1c8d1f5-3f1e-40c6-aab0-fa49073f9153','2026-02-19 09:35:56',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1864767498-dep_1-jeip62xpeid3','e1c8d1f5-3f1e-40c6-aab0-fa49073f9153','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1264,'9ec742bd-0485-4b28-86bc-f46642df0b39','4ed35a8c-642e-4763-8389-c7148eaf292c','2026-02-19 09:35:57',NULL,'DELETE','IN_PROGRESS','dep_2','68a6a357-ff37-4b82-9ceb-ffcf88ae3a85','state changed','OS::Heat::SoftwareDeployments',NULL,211),(1265,'bc9ed2fd-cdd4-4ed8-8ac5-6ec092ec5bb2','70a70d1e-b0fb-4f77-83b9-54a270931092','2026-02-19 09:35:57',NULL,'CREATE','IN_PROGRESS','StackTagTest-775093476','70a70d1e-b0fb-4f77-83b9-54a270931092','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1266,'37f6c78d-e163-426b-8554-8eac406e3a6d','e1c8d1f5-3f1e-40c6-aab0-fa49073f9153','2026-02-19 09:35:57',NULL,'CREATE','FAILED','0','de5b5104-2fa2-46d8-ab5c-9ddd88f30785','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployment',NULL,212),(1267,'aa9c4132-4153-4ffd-abc4-6628b8226100','39b754ea-2fb5-4e80-a0a0-c0b67163b1f4','2026-02-19 09:35:57',NULL,'CREATE','FAILED','0','672718cf-632e-4dcf-af52-c8d74a986e4a','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployment',NULL,213),(1268,'c6af05ea-f0fa-4875-b5f0-048aba0c0b20','68a6a357-ff37-4b82-9ceb-ffcf88ae3a85','2026-02-19 09:35:57',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1864767498-dep_2-rgyaphd5dp2l','68a6a357-ff37-4b82-9ceb-ffcf88ae3a85','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1269,'8c3c4dfa-de5b-42bd-b089-1faeffdc4dda','70a70d1e-b0fb-4f77-83b9-54a270931092','2026-02-19 09:35:57',NULL,'CREATE','IN_PROGRESS','not-used','StackTagTest-775093476-not-used-tcgrlrlohbdg','state changed','OS::Heat::TestResource',NULL,235),(1270,'95884b04-de17-4f21-9bcd-fc189638338c','68a6a357-ff37-4b82-9ceb-ffcf88ae3a85','2026-02-19 09:35:58',NULL,'CREATE','FAILED','0','cd394c1b-f830-4a50-8608-33dd97295f70','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployment',NULL,214),(1271,'8431ebac-ec23-4c86-8876-e89d6faeb17d','70a70d1e-b0fb-4f77-83b9-54a270931092','2026-02-19 09:35:59',NULL,'CREATE','COMPLETE','not-used','StackTagTest-775093476-not-used-tcgrlrlohbdg','state changed','OS::Heat::TestResource',NULL,235),(1272,'2b51ffc8-ffee-4276-ac71-5370c83ab4a3','70a70d1e-b0fb-4f77-83b9-54a270931092','2026-02-19 09:35:59',NULL,'CREATE','COMPLETE','StackTagTest-775093476','70a70d1e-b0fb-4f77-83b9-54a270931092','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1273,'5d452af8-93cb-4055-a079-f617a016feaf','68a6a357-ff37-4b82-9ceb-ffcf88ae3a85','2026-02-19 09:36:02',NULL,'DELETE','IN_PROGRESS','0','cd394c1b-f830-4a50-8608-33dd97295f70','state changed','OS::Heat::SoftwareDeployment',NULL,214),(1274,'9f0b6b4f-bd53-4f72-a161-1f81ca8f09bf','e1c8d1f5-3f1e-40c6-aab0-fa49073f9153','2026-02-19 09:36:02',NULL,'DELETE','IN_PROGRESS','0','de5b5104-2fa2-46d8-ab5c-9ddd88f30785','state changed','OS::Heat::SoftwareDeployment',NULL,212),(1275,'66dd2b3f-ff86-478d-9d03-18415db8edbf','39b754ea-2fb5-4e80-a0a0-c0b67163b1f4','2026-02-19 09:36:02',NULL,'DELETE','IN_PROGRESS','0','672718cf-632e-4dcf-af52-c8d74a986e4a','state changed','OS::Heat::SoftwareDeployment',NULL,213),(1276,'4a965af4-c43c-45c6-9d91-b541849875f3','70a70d1e-b0fb-4f77-83b9-54a270931092','2026-02-19 09:36:03',NULL,'UPDATE','IN_PROGRESS','StackTagTest-775093476','70a70d1e-b0fb-4f77-83b9-54a270931092','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1277,'2f1f7205-b307-4dbb-bcd9-d50cc7cfaf1c','70a70d1e-b0fb-4f77-83b9-54a270931092','2026-02-19 09:36:03',NULL,'UPDATE','IN_PROGRESS','not-used','StackTagTest-775093476-not-used-tcgrlrlohbdg','state changed','OS::Heat::TestResource',NULL,235),(1278,'35b01738-2c51-42e6-b311-1942f768527d','68a6a357-ff37-4b82-9ceb-ffcf88ae3a85','2026-02-19 09:36:03',NULL,'DELETE','COMPLETE','0','cd394c1b-f830-4a50-8608-33dd97295f70','state changed','OS::Heat::SoftwareDeployment',NULL,214),(1279,'98a51702-a2ff-4d38-9ba7-2fc5ab47bf8d','68a6a357-ff37-4b82-9ceb-ffcf88ae3a85','2026-02-19 09:36:03',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1864767498-dep_2-rgyaphd5dp2l','68a6a357-ff37-4b82-9ceb-ffcf88ae3a85','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1280,'36af1d0a-8be7-4640-bda9-c2d04f2a625a','4ed35a8c-642e-4763-8389-c7148eaf292c','2026-02-19 09:36:04',NULL,'DELETE','COMPLETE','dep_2','68a6a357-ff37-4b82-9ceb-ffcf88ae3a85','state changed','OS::Heat::SoftwareDeployments',NULL,211),(1281,'67ca388b-7a90-4930-a3af-49d104b50902','39b754ea-2fb5-4e80-a0a0-c0b67163b1f4','2026-02-19 09:36:04',NULL,'DELETE','COMPLETE','0','672718cf-632e-4dcf-af52-c8d74a986e4a','state changed','OS::Heat::SoftwareDeployment',NULL,213),(1282,'5f4b0a2b-7290-4a65-9a3e-5d58fe20bb48','39b754ea-2fb5-4e80-a0a0-c0b67163b1f4','2026-02-19 09:36:04',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1864767498-dep_0-khwzne6zbzlh','39b754ea-2fb5-4e80-a0a0-c0b67163b1f4','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1283,'4148c09b-0f20-4024-a8d0-023ddd40a9c2','e1c8d1f5-3f1e-40c6-aab0-fa49073f9153','2026-02-19 09:36:04',NULL,'DELETE','COMPLETE','0','de5b5104-2fa2-46d8-ab5c-9ddd88f30785','state changed','OS::Heat::SoftwareDeployment',NULL,212),(1284,'37f04418-2633-489a-81b6-a37c972011c6','e1c8d1f5-3f1e-40c6-aab0-fa49073f9153','2026-02-19 09:36:04',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1864767498-dep_1-jeip62xpeid3','e1c8d1f5-3f1e-40c6-aab0-fa49073f9153','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1285,'80d64fac-a2d4-47e3-9192-476d247063a6','4ed35a8c-642e-4763-8389-c7148eaf292c','2026-02-19 09:36:04',NULL,'DELETE','COMPLETE','dep_1','e1c8d1f5-3f1e-40c6-aab0-fa49073f9153','state changed','OS::Heat::SoftwareDeployments',NULL,210),(1286,'445d36eb-03d7-42d1-a4b6-6501ddc81bab','4ed35a8c-642e-4763-8389-c7148eaf292c','2026-02-19 09:36:06',NULL,'DELETE','COMPLETE','dep_0','39b754ea-2fb5-4e80-a0a0-c0b67163b1f4','state changed','OS::Heat::SoftwareDeployments',NULL,209),(1287,'2b0e913f-bfb8-4b7a-a50d-fdf5dd30cab4','70a70d1e-b0fb-4f77-83b9-54a270931092','2026-02-19 09:36:06',NULL,'UPDATE','COMPLETE','not-used','StackTagTest-775093476-not-used-tcgrlrlohbdg','state changed','OS::Heat::TestResource',NULL,236),(1288,'0aaa1a1b-ca86-4aac-adb7-96c6342bf659','4ed35a8c-642e-4763-8389-c7148eaf292c','2026-02-19 09:36:06',NULL,'DELETE','IN_PROGRESS','config','89191f4e-ce86-45da-b669-c08cce44cee8','state changed','OS::Heat::SoftwareConfig',NULL,208),(1289,'9f650373-df81-4d50-a5c6-3c74642ea551','70a70d1e-b0fb-4f77-83b9-54a270931092','2026-02-19 09:36:06',NULL,'UPDATE','COMPLETE','StackTagTest-775093476','70a70d1e-b0fb-4f77-83b9-54a270931092','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1290,'04b9c975-0ac1-4dc0-8656-595a480e93c5','4ed35a8c-642e-4763-8389-c7148eaf292c','2026-02-19 09:36:06',NULL,'DELETE','COMPLETE','config','89191f4e-ce86-45da-b669-c08cce44cee8','state changed','OS::Heat::SoftwareConfig',NULL,208),(1291,'019fb85d-426c-4f18-ac92-6715dc81ec22','4ed35a8c-642e-4763-8389-c7148eaf292c','2026-02-19 09:36:06',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1864767498','4ed35a8c-642e-4763-8389-c7148eaf292c','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1292,'ec9fc9ad-f6b7-42a4-8f53-bde354c5e80f','70a70d1e-b0fb-4f77-83b9-54a270931092','2026-02-19 09:36:10',NULL,'UPDATE','IN_PROGRESS','StackTagTest-775093476','70a70d1e-b0fb-4f77-83b9-54a270931092','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1293,'bd3c1912-d355-4aa4-ac21-028365e4ced8','70a70d1e-b0fb-4f77-83b9-54a270931092','2026-02-19 09:36:11',NULL,'UPDATE','IN_PROGRESS','not-used','StackTagTest-775093476-not-used-tcgrlrlohbdg','state changed','OS::Heat::TestResource',NULL,236),(1294,'2c30f953-7691-42b6-a511-b14dcb81170d','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:36:13',NULL,'CREATE','FAILED','ParallelDeploymentsTest-825460174','9fa13249-8716-4b7e-921d-22f54f1897b0','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1295,'ca753fab-df92-4828-b472-5d8300bdcad9','452981e1-c3cc-4fa7-b9a3-53ce27bddcd3','2026-02-19 09:36:13',NULL,'CREATE','FAILED','ParallelDeploymentsTest-825460174-dep_4-nro7tyxzkysk','452981e1-c3cc-4fa7-b9a3-53ce27bddcd3','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1296,'8050b7ce-fd3e-41f9-93fa-6fa6e4978112','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:36:13',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-825460174','9fa13249-8716-4b7e-921d-22f54f1897b0','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1297,'1fb6df90-dee4-487f-92d3-d97328228a42','70a70d1e-b0fb-4f77-83b9-54a270931092','2026-02-19 09:36:14',NULL,'UPDATE','COMPLETE','not-used','StackTagTest-775093476-not-used-tcgrlrlohbdg','state changed','OS::Heat::TestResource',NULL,237),(1298,'5c97b477-a756-400c-a49d-e0a74171e5bb','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:36:14',NULL,'CREATE','FAILED','dep_4','452981e1-c3cc-4fa7-b9a3-53ce27bddcd3','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployments',NULL,198),(1299,'038af75d-45f6-4ffb-b159-b6e6e339174c','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:36:14',NULL,'CREATE','FAILED','dep_1','d6c8c06b-afb4-4471-8ed4-887be29d705d','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployments',NULL,197),(1300,'524747eb-1e3b-4a57-88c0-f010853e1bd6','d6c8c06b-afb4-4471-8ed4-887be29d705d','2026-02-19 09:36:14',NULL,'CREATE','FAILED','ParallelDeploymentsTest-825460174-dep_1-yactjmgm6apr','d6c8c06b-afb4-4471-8ed4-887be29d705d','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1301,'6519efb2-c59a-443c-a415-bb42991e4e81','b351f81f-e135-45c3-9d01-f6221b7745a1','2026-02-19 09:36:14',NULL,'CREATE','FAILED','ParallelDeploymentsTest-825460174-dep_3-s3ukplefd4zu','b351f81f-e135-45c3-9d01-f6221b7745a1','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1302,'76b021e2-e8e1-4b12-a9b8-8a90207cf480','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:36:14',NULL,'CREATE','FAILED','dep_3','b351f81f-e135-45c3-9d01-f6221b7745a1','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployments',NULL,196),(1303,'84fc0317-34fd-4aa5-8f37-3d04a40aeb0d','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:36:14',NULL,'CREATE','FAILED','dep_0','d030df58-eeb9-47ec-98c9-61b455b3e0d4','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployments',NULL,199),(1304,'479b3817-ddb7-4ce7-b995-49421e7a42bc','f85a03e0-c171-490b-900d-2a307dabee57','2026-02-19 09:36:14',NULL,'CREATE','FAILED','ParallelDeploymentsTest-825460174-dep_2-66sur23t33uk','f85a03e0-c171-490b-900d-2a307dabee57','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1305,'b2d0106d-fd18-43f1-b580-613893ecae04','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:36:14',NULL,'CREATE','FAILED','dep_2','f85a03e0-c171-490b-900d-2a307dabee57','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployments',NULL,195),(1306,'14794136-6a65-4f85-9e8f-568ceb64c12a','d030df58-eeb9-47ec-98c9-61b455b3e0d4','2026-02-19 09:36:14',NULL,'CREATE','FAILED','ParallelDeploymentsTest-825460174-dep_0-3wfxqlizneo3','d030df58-eeb9-47ec-98c9-61b455b3e0d4','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1307,'4f4f55b6-8dcc-444f-bad9-32b5fa0f1331','70a70d1e-b0fb-4f77-83b9-54a270931092','2026-02-19 09:36:14',NULL,'UPDATE','COMPLETE','StackTagTest-775093476','70a70d1e-b0fb-4f77-83b9-54a270931092','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1308,'37bde96c-0217-48bc-b4c7-93e96545c820','70a70d1e-b0fb-4f77-83b9-54a270931092','2026-02-19 09:36:16',NULL,'DELETE','IN_PROGRESS','StackTagTest-775093476','70a70d1e-b0fb-4f77-83b9-54a270931092','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1309,'00d0cfb5-afb4-4ad3-ac8e-e9eedb4f76d9','70a70d1e-b0fb-4f77-83b9-54a270931092','2026-02-19 09:36:17',NULL,'DELETE','IN_PROGRESS','not-used','StackTagTest-775093476-not-used-tcgrlrlohbdg','state changed','OS::Heat::TestResource',NULL,237),(1310,'4c0d4d91-d6d3-41fd-b485-25fbfc6c4bd3','70a70d1e-b0fb-4f77-83b9-54a270931092','2026-02-19 09:36:20',NULL,'DELETE','COMPLETE','not-used','StackTagTest-775093476-not-used-tcgrlrlohbdg','state changed','OS::Heat::TestResource',NULL,237),(1311,'fede0045-a12e-4b48-a0c3-61e536098ab9','70a70d1e-b0fb-4f77-83b9-54a270931092','2026-02-19 09:36:21',NULL,'DELETE','COMPLETE','StackTagTest-775093476','70a70d1e-b0fb-4f77-83b9-54a270931092','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1312,'e854e8ab-3047-4644-883f-e4fe32a2c813','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:36:21',NULL,'DELETE','IN_PROGRESS','dep_2','f85a03e0-c171-490b-900d-2a307dabee57','state changed','OS::Heat::SoftwareDeployments',NULL,195),(1313,'02be7da5-225f-448a-a681-460dd0c40ae4','f85a03e0-c171-490b-900d-2a307dabee57','2026-02-19 09:36:21',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-825460174-dep_2-66sur23t33uk','f85a03e0-c171-490b-900d-2a307dabee57','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1314,'e683dbfd-666d-4743-8f9f-93ca4a0b6e26','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:36:23',NULL,'DELETE','IN_PROGRESS','dep_4','452981e1-c3cc-4fa7-b9a3-53ce27bddcd3','state changed','OS::Heat::SoftwareDeployments',NULL,198),(1315,'00c67208-1b60-4f53-82ab-3c869df2d19e','f85a03e0-c171-490b-900d-2a307dabee57','2026-02-19 09:36:23',NULL,'CREATE','FAILED','0','a19f1b94-e2ef-476c-8cb8-97319b3fd040','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployment',NULL,200),(1316,'367f5f08-b72d-4db1-b063-86c155dd7f5b','452981e1-c3cc-4fa7-b9a3-53ce27bddcd3','2026-02-19 09:36:23',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-825460174-dep_4-nro7tyxzkysk','452981e1-c3cc-4fa7-b9a3-53ce27bddcd3','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1317,'69794332-cdc6-482b-84aa-1245ca7be433','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:36:24',NULL,'DELETE','IN_PROGRESS','dep_3','b351f81f-e135-45c3-9d01-f6221b7745a1','state changed','OS::Heat::SoftwareDeployments',NULL,196),(1318,'844cb30a-7fea-429d-a269-46d5ed7081fa','b351f81f-e135-45c3-9d01-f6221b7745a1','2026-02-19 09:36:24',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-825460174-dep_3-s3ukplefd4zu','b351f81f-e135-45c3-9d01-f6221b7745a1','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1319,'6fe4efb6-f1a9-4eb8-88eb-6fd2a2158638','452981e1-c3cc-4fa7-b9a3-53ce27bddcd3','2026-02-19 09:36:24',NULL,'CREATE','FAILED','0','3ff2b654-f601-4f48-b371-d8c665f8d690','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployment',NULL,203),(1320,'4123d5f1-1928-4497-b55d-d8108f1cf1bf','b351f81f-e135-45c3-9d01-f6221b7745a1','2026-02-19 09:36:24',NULL,'CREATE','FAILED','0','164466aa-557d-4146-aabd-61460822a26f','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployment',NULL,201),(1321,'b53a6290-303b-475c-8925-8012271f018b','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:36:25',NULL,'DELETE','IN_PROGRESS','dep_0','d030df58-eeb9-47ec-98c9-61b455b3e0d4','state changed','OS::Heat::SoftwareDeployments',NULL,199),(1322,'2f695b9f-c56e-482b-b242-f08eb0e84437','d030df58-eeb9-47ec-98c9-61b455b3e0d4','2026-02-19 09:36:25',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-825460174-dep_0-3wfxqlizneo3','d030df58-eeb9-47ec-98c9-61b455b3e0d4','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1323,'1c13824d-23a5-46df-88f5-250ac3ccd146','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:36:26',NULL,'DELETE','IN_PROGRESS','dep_1','d6c8c06b-afb4-4471-8ed4-887be29d705d','state changed','OS::Heat::SoftwareDeployments',NULL,197),(1324,'66ba58b4-cf80-4d32-96e7-a8b5fd6811b4','d6c8c06b-afb4-4471-8ed4-887be29d705d','2026-02-19 09:36:26',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-825460174-dep_1-yactjmgm6apr','d6c8c06b-afb4-4471-8ed4-887be29d705d','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1325,'2b842182-aafa-4847-ab37-ac4e09c99f55','d030df58-eeb9-47ec-98c9-61b455b3e0d4','2026-02-19 09:36:26',NULL,'CREATE','FAILED','0','f005ccc0-1e93-4154-bd38-79f6e7349f0d','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployment',NULL,204),(1326,'ca3d6006-0ab9-41aa-a67c-e9a1b01bf4e3','f85a03e0-c171-490b-900d-2a307dabee57','2026-02-19 09:36:27',NULL,'DELETE','IN_PROGRESS','0','a19f1b94-e2ef-476c-8cb8-97319b3fd040','state changed','OS::Heat::SoftwareDeployment',NULL,200),(1327,'cad0ad26-ef7b-4ac4-9981-15ddcd05c783','d6c8c06b-afb4-4471-8ed4-887be29d705d','2026-02-19 09:36:27',NULL,'CREATE','FAILED','0','b4e2a327-4a4a-4b5f-b10f-ee6400e4b303','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployment',NULL,202),(1328,'e3e9ed3c-149f-4b21-be3d-bd2e583d27d6','452981e1-c3cc-4fa7-b9a3-53ce27bddcd3','2026-02-19 09:36:28',NULL,'DELETE','IN_PROGRESS','0','3ff2b654-f601-4f48-b371-d8c665f8d690','state changed','OS::Heat::SoftwareDeployment',NULL,203),(1329,'83b6a7d2-74e8-4697-9027-d80e7fbd849a','758f8a8d-3940-4fa1-9d2a-108388d9899f','2026-02-19 09:36:28',NULL,'CREATE','IN_PROGRESS','TemplateAPITest-1259790094','758f8a8d-3940-4fa1-9d2a-108388d9899f','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1330,'1d49d164-21a8-474b-9ffe-2a638cceddb3','758f8a8d-3940-4fa1-9d2a-108388d9899f','2026-02-19 09:36:29',NULL,'CREATE','IN_PROGRESS','test1','TemplateAPITest-1259790094-test1-sh7n4b3dbwc3','state changed','OS::Heat::TestResource',NULL,238),(1331,'79673559-8a86-4a1b-9c78-04e35df2546e','f85a03e0-c171-490b-900d-2a307dabee57','2026-02-19 09:36:29',NULL,'DELETE','COMPLETE','0','a19f1b94-e2ef-476c-8cb8-97319b3fd040','state changed','OS::Heat::SoftwareDeployment',NULL,200),(1332,'d454f4bf-9548-431a-9f62-585d498e26a4','f85a03e0-c171-490b-900d-2a307dabee57','2026-02-19 09:36:29',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-825460174-dep_2-66sur23t33uk','f85a03e0-c171-490b-900d-2a307dabee57','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1333,'c571282d-3d04-44b7-b98e-f3e9fe459a1c','758f8a8d-3940-4fa1-9d2a-108388d9899f','2026-02-19 09:36:29',NULL,'CREATE','COMPLETE','test1','TemplateAPITest-1259790094-test1-sh7n4b3dbwc3','state changed','OS::Heat::TestResource',NULL,238),(1334,'8be2a433-6f5e-4986-90d7-25d5170e5258','758f8a8d-3940-4fa1-9d2a-108388d9899f','2026-02-19 09:36:29',NULL,'CREATE','COMPLETE','TemplateAPITest-1259790094','758f8a8d-3940-4fa1-9d2a-108388d9899f','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1335,'4c1ad28f-6fcf-45d1-a8ed-b65769f1aa67','452981e1-c3cc-4fa7-b9a3-53ce27bddcd3','2026-02-19 09:36:29',NULL,'DELETE','COMPLETE','0','3ff2b654-f601-4f48-b371-d8c665f8d690','state changed','OS::Heat::SoftwareDeployment',NULL,203),(1336,'f219f9e3-f9f3-406a-a052-3f07e1f440a8','b351f81f-e135-45c3-9d01-f6221b7745a1','2026-02-19 09:36:29',NULL,'DELETE','IN_PROGRESS','0','164466aa-557d-4146-aabd-61460822a26f','state changed','OS::Heat::SoftwareDeployment',NULL,201),(1337,'a7712641-1a6f-4b2b-97e3-5e06585c84e7','452981e1-c3cc-4fa7-b9a3-53ce27bddcd3','2026-02-19 09:36:29',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-825460174-dep_4-nro7tyxzkysk','452981e1-c3cc-4fa7-b9a3-53ce27bddcd3','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1338,'2246843c-cb8a-4fe4-bd61-50085222cef7','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:36:29',NULL,'DELETE','COMPLETE','dep_4','452981e1-c3cc-4fa7-b9a3-53ce27bddcd3','state changed','OS::Heat::SoftwareDeployments',NULL,198),(1339,'df8c0d50-169f-4062-b0c7-6e31422208ca','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:36:29',NULL,'DELETE','COMPLETE','dep_2','f85a03e0-c171-490b-900d-2a307dabee57','state changed','OS::Heat::SoftwareDeployments',NULL,195),(1340,'0c67b560-627c-4159-adf8-a64e288e590c','758f8a8d-3940-4fa1-9d2a-108388d9899f','2026-02-19 09:36:30',NULL,'DELETE','IN_PROGRESS','TemplateAPITest-1259790094','758f8a8d-3940-4fa1-9d2a-108388d9899f','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1341,'e063a645-0c04-4f77-b1f4-2879188e7b6e','d030df58-eeb9-47ec-98c9-61b455b3e0d4','2026-02-19 09:36:31',NULL,'DELETE','IN_PROGRESS','0','f005ccc0-1e93-4154-bd38-79f6e7349f0d','state changed','OS::Heat::SoftwareDeployment',NULL,204),(1342,'840783e3-2f9a-42e6-882e-434cc22fd699','758f8a8d-3940-4fa1-9d2a-108388d9899f','2026-02-19 09:36:31',NULL,'DELETE','IN_PROGRESS','test1','TemplateAPITest-1259790094-test1-sh7n4b3dbwc3','state changed','OS::Heat::TestResource',NULL,238),(1343,'c180c026-3548-489a-801e-8e87200181d5','758f8a8d-3940-4fa1-9d2a-108388d9899f','2026-02-19 09:36:31',NULL,'DELETE','COMPLETE','test1','TemplateAPITest-1259790094-test1-sh7n4b3dbwc3','state changed','OS::Heat::TestResource',NULL,238),(1344,'067f86e8-372b-49e9-8f7a-3f96bc8d7135','758f8a8d-3940-4fa1-9d2a-108388d9899f','2026-02-19 09:36:32',NULL,'DELETE','COMPLETE','TemplateAPITest-1259790094','758f8a8d-3940-4fa1-9d2a-108388d9899f','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1345,'8a2b42de-b51e-49da-a063-a80cdb2cb5a8','d6c8c06b-afb4-4471-8ed4-887be29d705d','2026-02-19 09:36:32',NULL,'DELETE','IN_PROGRESS','0','b4e2a327-4a4a-4b5f-b10f-ee6400e4b303','state changed','OS::Heat::SoftwareDeployment',NULL,202),(1346,'5df5f17d-6bb6-4ffb-8961-f4cbb589e61e','b351f81f-e135-45c3-9d01-f6221b7745a1','2026-02-19 09:36:32',NULL,'DELETE','COMPLETE','0','164466aa-557d-4146-aabd-61460822a26f','state changed','OS::Heat::SoftwareDeployment',NULL,201),(1347,'821f61fb-d692-4224-89dd-4c968a43fd35','b351f81f-e135-45c3-9d01-f6221b7745a1','2026-02-19 09:36:33',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-825460174-dep_3-s3ukplefd4zu','b351f81f-e135-45c3-9d01-f6221b7745a1','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1348,'3ee63de1-a43b-45c3-87ba-beb5c75b9b8c','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:36:34',NULL,'DELETE','COMPLETE','dep_3','b351f81f-e135-45c3-9d01-f6221b7745a1','state changed','OS::Heat::SoftwareDeployments',NULL,196),(1349,'cd320626-aa2b-4c76-8e4a-97e98d6bbd5b','d030df58-eeb9-47ec-98c9-61b455b3e0d4','2026-02-19 09:36:34',NULL,'DELETE','COMPLETE','0','f005ccc0-1e93-4154-bd38-79f6e7349f0d','state changed','OS::Heat::SoftwareDeployment',NULL,204),(1350,'6b1ae8c4-b1bc-4266-9d9d-e79b0de8e594','d030df58-eeb9-47ec-98c9-61b455b3e0d4','2026-02-19 09:36:34',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-825460174-dep_0-3wfxqlizneo3','d030df58-eeb9-47ec-98c9-61b455b3e0d4','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1351,'b6a4af04-74d6-4589-9f11-d54ca9d8b86a','d6c8c06b-afb4-4471-8ed4-887be29d705d','2026-02-19 09:36:34',NULL,'DELETE','COMPLETE','0','b4e2a327-4a4a-4b5f-b10f-ee6400e4b303','state changed','OS::Heat::SoftwareDeployment',NULL,202),(1352,'365f3077-5b25-4eed-91bb-c31dac9a44f1','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:36:35',NULL,'DELETE','COMPLETE','dep_0','d030df58-eeb9-47ec-98c9-61b455b3e0d4','state changed','OS::Heat::SoftwareDeployments',NULL,199),(1353,'3e43dace-3c61-4e9b-b0da-5e1ee08eb8e6','d6c8c06b-afb4-4471-8ed4-887be29d705d','2026-02-19 09:36:35',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-825460174-dep_1-yactjmgm6apr','d6c8c06b-afb4-4471-8ed4-887be29d705d','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1354,'ad979786-6cbd-4b77-9048-1c6580602f04','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:36:36',NULL,'DELETE','COMPLETE','dep_1','d6c8c06b-afb4-4471-8ed4-887be29d705d','state changed','OS::Heat::SoftwareDeployments',NULL,197),(1355,'b4e4cab8-8000-4a8b-9fbb-1a9692f860af','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:36:36',NULL,'DELETE','IN_PROGRESS','config','a657aaa3-d0f7-4a4b-81b9-1b11d719c06c','state changed','OS::Heat::SoftwareConfig',NULL,194),(1356,'f4816815-ecb7-4b0e-a71a-19e4c4d569d0','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:36:36',NULL,'DELETE','COMPLETE','config','a657aaa3-d0f7-4a4b-81b9-1b11d719c06c','state changed','OS::Heat::SoftwareConfig',NULL,194),(1357,'eec576c7-8227-4fe3-b3d0-71497ba0f347','9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:36:36',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-825460174','9fa13249-8716-4b7e-921d-22f54f1897b0','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1358,'f93922b3-ac18-4456-aef8-27438e654165','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:36:41',NULL,'CREATE','FAILED','ParallelDeploymentsTest-614175552','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1359,'95a079df-9693-4d37-b49e-782ac54bec4a','0b1dfe63-062f-406d-b725-3604ca41ab05','2026-02-19 09:36:42',NULL,'CREATE','FAILED','ParallelDeploymentsTest-614175552-dep_2-ul2frflp772c','0b1dfe63-062f-406d-b725-3604ca41ab05','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1360,'3d10f982-23f6-4c2a-a527-1fe72dbcc58f','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:36:42',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-614175552','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1361,'af5eb8ab-c7c9-4bfd-aac7-ccd73ab66b7f','b334fbda-f3b5-4d28-9dbd-c08785fa4ea4','2026-02-19 09:36:43',NULL,'CREATE','IN_PROGRESS','RemoteDeeplyNestedStackTest-453210323','b334fbda-f3b5-4d28-9dbd-c08785fa4ea4','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1362,'55084f85-e57e-47fb-8fb1-f23bb8aad46d','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:36:43',NULL,'CREATE','FAILED','dep_1','96845e67-548c-4233-98e6-ad5a9dd8c127','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployments',NULL,186),(1363,'af4b40d6-1932-4eb6-a844-de50a876bdc6','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:36:43',NULL,'CREATE','FAILED','dep_4','898d8a4d-2d18-4d50-8fbf-0c8feae1f848','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployments',NULL,187),(1364,'0c338552-4167-4f10-b8b7-99792c377b0e','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:36:43',NULL,'CREATE','FAILED','dep_3','dde52115-d860-4b44-bc89-5a2453d6b2b6','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployments',NULL,185),(1365,'1b640c7d-1d0f-4135-b353-7a0323e8a640','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:36:43',NULL,'CREATE','FAILED','dep_2','0b1dfe63-062f-406d-b725-3604ca41ab05','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployments',NULL,184),(1366,'d69f5c5f-9e95-4e25-9752-ef623d3da86e','96845e67-548c-4233-98e6-ad5a9dd8c127','2026-02-19 09:36:43',NULL,'CREATE','FAILED','ParallelDeploymentsTest-614175552-dep_1-r7q3uuzjc3pn','96845e67-548c-4233-98e6-ad5a9dd8c127','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1367,'1d90ee5f-5ba3-425e-8753-6b53deb868d8','dde52115-d860-4b44-bc89-5a2453d6b2b6','2026-02-19 09:36:43',NULL,'CREATE','FAILED','ParallelDeploymentsTest-614175552-dep_3-pgcfpvugjbpb','dde52115-d860-4b44-bc89-5a2453d6b2b6','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1368,'3f3babe1-7f8c-414d-8ef4-e39e6de483c2','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:36:43',NULL,'CREATE','FAILED','dep_0','9431b106-3940-4d80-922b-c86e1d165555','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployments',NULL,188),(1369,'aa2b624a-93b3-4926-96b3-ef0724e33158','898d8a4d-2d18-4d50-8fbf-0c8feae1f848','2026-02-19 09:36:43',NULL,'CREATE','FAILED','ParallelDeploymentsTest-614175552-dep_4-vllpksuhb3q2','898d8a4d-2d18-4d50-8fbf-0c8feae1f848','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1370,'ab90cb55-2210-4646-a3e5-d4d3742aebbd','9431b106-3940-4d80-922b-c86e1d165555','2026-02-19 09:36:43',NULL,'CREATE','FAILED','ParallelDeploymentsTest-614175552-dep_0-y3rth3wuhf4a','9431b106-3940-4d80-922b-c86e1d165555','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1371,'5d14e8ab-b026-4a3f-a349-14684a3f6a5e','b334fbda-f3b5-4d28-9dbd-c08785fa4ea4','2026-02-19 09:36:44',NULL,'CREATE','IN_PROGRESS','network_stack','RemoteDeeplyNestedStackTest-453210323-network_stack-64nqnjbrxece','state changed','OS::Heat::Stack',NULL,239),(1372,'5ffd9d62-f8c8-4ecb-a235-91cb50b5b15b','263c66be-8d82-4da8-8c0a-70f4e3744ac2','2026-02-19 09:36:46',NULL,'CREATE','IN_PROGRESS','RemoteDeeplyNestedStackTest-453210323-network_stack-64nqnjbrxece','263c66be-8d82-4da8-8c0a-70f4e3744ac2','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1373,'03e2d37d-52c6-49cf-90ca-f807ec5c243a','263c66be-8d82-4da8-8c0a-70f4e3744ac2','2026-02-19 09:36:46',NULL,'CREATE','IN_PROGRESS','network_stack_as_custom_type','RemoteDeeplyNestedStackTest-453210323-network_stack-64nqnjbrxece-network_stack_as_custom_type-iuwqg4pynpj4','state changed','file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml',NULL,240),(1374,'e48c4cdd-a636-4f04-8828-ba27a57e14a0','0b006a64-5d9f-44a7-97c2-05d67e7f567a','2026-02-19 09:36:46',NULL,'CREATE','IN_PROGRESS','RemoteDeeplyNestedStackTest-453210323-network_stack-64nqnjbrxece-network_stack_as_custom_type-iuwqg4pynpj4','0b006a64-5d9f-44a7-97c2-05d67e7f567a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1375,'d420d69c-a5c8-4b68-a81b-20c16b3aa20e','0b006a64-5d9f-44a7-97c2-05d67e7f567a','2026-02-19 09:36:46',NULL,'CREATE','IN_PROGRESS','router','RemoteDeeplyNestedStackTest-453210323-network_stack-64nqnjbrxece-network_stack_as_custom_type-iuwqg4pynpj4-router-jd5egyxcmzlo','state changed','OS::Neutron::Router',NULL,241),(1376,'eb3d38a6-b2a8-4f0f-9954-7ba20ee53938','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:36:49',NULL,'DELETE','IN_PROGRESS','dep_1','96845e67-548c-4233-98e6-ad5a9dd8c127','state changed','OS::Heat::SoftwareDeployments',NULL,186),(1377,'3adb143f-98ef-4f0f-ad70-7da90321bcb1','96845e67-548c-4233-98e6-ad5a9dd8c127','2026-02-19 09:36:50',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-614175552-dep_1-r7q3uuzjc3pn','96845e67-548c-4233-98e6-ad5a9dd8c127','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1378,'8e94745d-c617-4a5d-8501-e28c02c08b82','0b006a64-5d9f-44a7-97c2-05d67e7f567a','2026-02-19 09:36:50',NULL,'CREATE','COMPLETE','router','e6e625df-cda4-4c16-8736-bf24cd3d8bdd','state changed','OS::Neutron::Router',NULL,241),(1379,'873646a9-8bd2-4f73-a765-f44675d0afc4','0b006a64-5d9f-44a7-97c2-05d67e7f567a','2026-02-19 09:36:50',NULL,'CREATE','COMPLETE','RemoteDeeplyNestedStackTest-453210323-network_stack-64nqnjbrxece-network_stack_as_custom_type-iuwqg4pynpj4','0b006a64-5d9f-44a7-97c2-05d67e7f567a','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1380,'88d00af8-9e2c-4ac1-a970-e8406af3180d','263c66be-8d82-4da8-8c0a-70f4e3744ac2','2026-02-19 09:36:51',NULL,'CREATE','COMPLETE','network_stack_as_custom_type','0b006a64-5d9f-44a7-97c2-05d67e7f567a','state changed','file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml',NULL,240),(1381,'e5a797d4-555f-490b-8fe9-898feaff72fe','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:36:51',NULL,'DELETE','IN_PROGRESS','dep_3','dde52115-d860-4b44-bc89-5a2453d6b2b6','state changed','OS::Heat::SoftwareDeployments',NULL,185),(1382,'24f572bd-fb1f-4112-96b3-4d9997d0ca5b','263c66be-8d82-4da8-8c0a-70f4e3744ac2','2026-02-19 09:36:51',NULL,'CREATE','COMPLETE','RemoteDeeplyNestedStackTest-453210323-network_stack-64nqnjbrxece','263c66be-8d82-4da8-8c0a-70f4e3744ac2','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1383,'d50ea53d-285a-4f17-aceb-019083d30b4e','96845e67-548c-4233-98e6-ad5a9dd8c127','2026-02-19 09:36:51',NULL,'CREATE','FAILED','0','49a9f74b-9723-4eb7-9b5c-48cbf0fb3cae','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployment',NULL,191),(1384,'ca5cecad-7515-45a9-ab88-eece56d6df46','dde52115-d860-4b44-bc89-5a2453d6b2b6','2026-02-19 09:36:51',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-614175552-dep_3-pgcfpvugjbpb','dde52115-d860-4b44-bc89-5a2453d6b2b6','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1385,'0495dba8-98dd-41f4-a7df-847caf988c10','b334fbda-f3b5-4d28-9dbd-c08785fa4ea4','2026-02-19 09:36:51',NULL,'CREATE','COMPLETE','network_stack','263c66be-8d82-4da8-8c0a-70f4e3744ac2','state changed','OS::Heat::Stack',NULL,239),(1386,'38072998-0df0-4a55-bd8e-532dc27f8e05','b334fbda-f3b5-4d28-9dbd-c08785fa4ea4','2026-02-19 09:36:52',NULL,'CREATE','COMPLETE','RemoteDeeplyNestedStackTest-453210323','b334fbda-f3b5-4d28-9dbd-c08785fa4ea4','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1387,'f5581d48-2cb1-4af2-8a73-1dc9b09de724','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:36:52',NULL,'DELETE','IN_PROGRESS','dep_0','9431b106-3940-4d80-922b-c86e1d165555','state changed','OS::Heat::SoftwareDeployments',NULL,188),(1388,'e8df4e17-1a75-464c-be71-1142c043a069','9431b106-3940-4d80-922b-c86e1d165555','2026-02-19 09:36:52',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-614175552-dep_0-y3rth3wuhf4a','9431b106-3940-4d80-922b-c86e1d165555','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1389,'37891144-d1ba-487a-b859-756471ae21bb','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:36:53',NULL,'DELETE','IN_PROGRESS','dep_2','0b1dfe63-062f-406d-b725-3604ca41ab05','state changed','OS::Heat::SoftwareDeployments',NULL,184),(1390,'d80dacf7-33a9-404e-9b64-06876f00bf37','9431b106-3940-4d80-922b-c86e1d165555','2026-02-19 09:36:53',NULL,'CREATE','FAILED','0','9c422220-aebf-4064-addc-72f30b5e29c1','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployment',NULL,192),(1391,'2fb5db4f-ca58-4d48-8f05-77bf395ac54c','dde52115-d860-4b44-bc89-5a2453d6b2b6','2026-02-19 09:36:53',NULL,'CREATE','FAILED','0','82490c56-39fb-4d5b-9313-c0ffd07453a9','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployment',NULL,190),(1392,'7bc6d35f-9c4b-4226-9375-7a18365a6fb2','0b1dfe63-062f-406d-b725-3604ca41ab05','2026-02-19 09:36:53',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-614175552-dep_2-ul2frflp772c','0b1dfe63-062f-406d-b725-3604ca41ab05','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1393,'c122b29f-a3eb-49b0-8fd8-089f83ca445c','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:36:54',NULL,'DELETE','IN_PROGRESS','dep_4','898d8a4d-2d18-4d50-8fbf-0c8feae1f848','state changed','OS::Heat::SoftwareDeployments',NULL,187),(1394,'d9d1b7cb-0a86-4592-8724-fa556cfbe56a','898d8a4d-2d18-4d50-8fbf-0c8feae1f848','2026-02-19 09:36:54',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-614175552-dep_4-vllpksuhb3q2','898d8a4d-2d18-4d50-8fbf-0c8feae1f848','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1395,'d5d5c2a6-8594-43e0-af3f-9f697d444b43','898d8a4d-2d18-4d50-8fbf-0c8feae1f848','2026-02-19 09:36:54',NULL,'CREATE','FAILED','0','2316c0c2-67fa-41b3-b9b2-82db78493993','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployment',NULL,193),(1396,'f5033882-15d2-4281-b23b-46f7375fad36','0b1dfe63-062f-406d-b725-3604ca41ab05','2026-02-19 09:36:54',NULL,'CREATE','FAILED','0','bedf6cb8-6728-46ef-9f90-ebfce2880387','CREATE aborted (user triggered cancel)','OS::Heat::SoftwareDeployment',NULL,189),(1397,'40a0deb5-2075-44f5-b5d0-de86c7861592','b334fbda-f3b5-4d28-9dbd-c08785fa4ea4','2026-02-19 09:36:54',NULL,'DELETE','IN_PROGRESS','RemoteDeeplyNestedStackTest-453210323','b334fbda-f3b5-4d28-9dbd-c08785fa4ea4','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1398,'6ce0e6bb-f47c-42d4-a0d5-87b1a1455c4b','b334fbda-f3b5-4d28-9dbd-c08785fa4ea4','2026-02-19 09:36:54',NULL,'DELETE','IN_PROGRESS','network_stack','263c66be-8d82-4da8-8c0a-70f4e3744ac2','state changed','OS::Heat::Stack',NULL,239),(1399,'13752ed9-9637-4034-bfca-887e0c240768','96845e67-548c-4233-98e6-ad5a9dd8c127','2026-02-19 09:36:55',NULL,'DELETE','IN_PROGRESS','0','49a9f74b-9723-4eb7-9b5c-48cbf0fb3cae','state changed','OS::Heat::SoftwareDeployment',NULL,191),(1400,'acadb674-9ada-4af9-aefc-2eec307a7d81','263c66be-8d82-4da8-8c0a-70f4e3744ac2','2026-02-19 09:36:56',NULL,'DELETE','IN_PROGRESS','RemoteDeeplyNestedStackTest-453210323-network_stack-64nqnjbrxece','263c66be-8d82-4da8-8c0a-70f4e3744ac2','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1401,'120decd5-83b8-4b33-83e3-63789bb5f511','263c66be-8d82-4da8-8c0a-70f4e3744ac2','2026-02-19 09:36:56',NULL,'DELETE','IN_PROGRESS','network_stack_as_custom_type','0b006a64-5d9f-44a7-97c2-05d67e7f567a','state changed','file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml',NULL,240),(1402,'d3bc309a-a705-44de-94b9-a1d49eb0ea80','0b006a64-5d9f-44a7-97c2-05d67e7f567a','2026-02-19 09:36:56',NULL,'DELETE','IN_PROGRESS','RemoteDeeplyNestedStackTest-453210323-network_stack-64nqnjbrxece-network_stack_as_custom_type-iuwqg4pynpj4','0b006a64-5d9f-44a7-97c2-05d67e7f567a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1403,'e3ab019a-bf6c-4a85-bf17-9f4f36aa14c2','0b006a64-5d9f-44a7-97c2-05d67e7f567a','2026-02-19 09:36:56',NULL,'DELETE','IN_PROGRESS','router','e6e625df-cda4-4c16-8736-bf24cd3d8bdd','state changed','OS::Neutron::Router',NULL,241),(1404,'6245b670-e253-4908-9db8-b32a6343eb27','dde52115-d860-4b44-bc89-5a2453d6b2b6','2026-02-19 09:36:57',NULL,'DELETE','IN_PROGRESS','0','82490c56-39fb-4d5b-9313-c0ffd07453a9','state changed','OS::Heat::SoftwareDeployment',NULL,190),(1405,'3f9ed86e-ce66-4910-81de-511216a06e2b','96845e67-548c-4233-98e6-ad5a9dd8c127','2026-02-19 09:36:57',NULL,'DELETE','COMPLETE','0','49a9f74b-9723-4eb7-9b5c-48cbf0fb3cae','state changed','OS::Heat::SoftwareDeployment',NULL,191),(1406,'ac1a7702-07b1-45e5-b6de-d3ae91628ba3','96845e67-548c-4233-98e6-ad5a9dd8c127','2026-02-19 09:36:57',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-614175552-dep_1-r7q3uuzjc3pn','96845e67-548c-4233-98e6-ad5a9dd8c127','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1407,'2f455550-8e55-4fcc-a422-2b03de9b04f0','9431b106-3940-4d80-922b-c86e1d165555','2026-02-19 09:36:57',NULL,'DELETE','IN_PROGRESS','0','9c422220-aebf-4064-addc-72f30b5e29c1','state changed','OS::Heat::SoftwareDeployment',NULL,192),(1408,'04f20e45-d857-4963-89b8-d749040fb74a','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:36:57',NULL,'DELETE','COMPLETE','dep_1','96845e67-548c-4233-98e6-ad5a9dd8c127','state changed','OS::Heat::SoftwareDeployments',NULL,186),(1409,'7fd1304e-5c4a-4e74-9103-8f146d389442','9431b106-3940-4d80-922b-c86e1d165555','2026-02-19 09:36:58',NULL,'DELETE','COMPLETE','0','9c422220-aebf-4064-addc-72f30b5e29c1','state changed','OS::Heat::SoftwareDeployment',NULL,192),(1410,'0e471ae5-ff6e-4855-abff-e7463e8e41b6','9431b106-3940-4d80-922b-c86e1d165555','2026-02-19 09:36:58',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-614175552-dep_0-y3rth3wuhf4a','9431b106-3940-4d80-922b-c86e1d165555','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1411,'3cf3d552-d731-4e44-86da-a069979d51be','dde52115-d860-4b44-bc89-5a2453d6b2b6','2026-02-19 09:36:58',NULL,'DELETE','COMPLETE','0','82490c56-39fb-4d5b-9313-c0ffd07453a9','state changed','OS::Heat::SoftwareDeployment',NULL,190),(1412,'3f66e79f-f74c-475c-968e-33aecd9ea063','dde52115-d860-4b44-bc89-5a2453d6b2b6','2026-02-19 09:36:58',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-614175552-dep_3-pgcfpvugjbpb','dde52115-d860-4b44-bc89-5a2453d6b2b6','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1413,'bfe77005-069b-4181-a69e-54882cc29274','0b006a64-5d9f-44a7-97c2-05d67e7f567a','2026-02-19 09:36:58',NULL,'DELETE','COMPLETE','router','e6e625df-cda4-4c16-8736-bf24cd3d8bdd','state changed','OS::Neutron::Router',NULL,241),(1414,'2e13436c-2a1d-454f-9d3f-cfcbeba3d48e','0b006a64-5d9f-44a7-97c2-05d67e7f567a','2026-02-19 09:36:58',NULL,'DELETE','COMPLETE','RemoteDeeplyNestedStackTest-453210323-network_stack-64nqnjbrxece-network_stack_as_custom_type-iuwqg4pynpj4','0b006a64-5d9f-44a7-97c2-05d67e7f567a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1415,'0663379b-8169-4563-9978-06c2ccf4b7ab','0b1dfe63-062f-406d-b725-3604ca41ab05','2026-02-19 09:36:58',NULL,'DELETE','IN_PROGRESS','0','bedf6cb8-6728-46ef-9f90-ebfce2880387','state changed','OS::Heat::SoftwareDeployment',NULL,189),(1416,'566a1f95-2719-41bb-81b9-6eef8621468b','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:36:58',NULL,'DELETE','COMPLETE','dep_3','dde52115-d860-4b44-bc89-5a2453d6b2b6','state changed','OS::Heat::SoftwareDeployments',NULL,185),(1417,'b09272a4-10e8-436e-a0c4-cbd40253f076','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:36:58',NULL,'DELETE','COMPLETE','dep_0','9431b106-3940-4d80-922b-c86e1d165555','state changed','OS::Heat::SoftwareDeployments',NULL,188),(1418,'98e8fc76-5f86-4075-9e84-d5033851bc11','263c66be-8d82-4da8-8c0a-70f4e3744ac2','2026-02-19 09:36:58',NULL,'DELETE','COMPLETE','network_stack_as_custom_type','0b006a64-5d9f-44a7-97c2-05d67e7f567a','state changed','file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml',NULL,240),(1419,'bb99379f-3a60-47d9-9ad5-40564a83af67','263c66be-8d82-4da8-8c0a-70f4e3744ac2','2026-02-19 09:36:58',NULL,'DELETE','COMPLETE','RemoteDeeplyNestedStackTest-453210323-network_stack-64nqnjbrxece','263c66be-8d82-4da8-8c0a-70f4e3744ac2','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1420,'7414d2f4-bc41-490a-b013-0f25233d71c6','0b1dfe63-062f-406d-b725-3604ca41ab05','2026-02-19 09:36:59',NULL,'DELETE','COMPLETE','0','bedf6cb8-6728-46ef-9f90-ebfce2880387','state changed','OS::Heat::SoftwareDeployment',NULL,189),(1421,'5f7bc241-81f4-430a-84e4-8aad3d75480f','0b1dfe63-062f-406d-b725-3604ca41ab05','2026-02-19 09:36:59',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-614175552-dep_2-ul2frflp772c','0b1dfe63-062f-406d-b725-3604ca41ab05','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1422,'e04e3768-85ec-49ed-8e17-79eba2fb4500','898d8a4d-2d18-4d50-8fbf-0c8feae1f848','2026-02-19 09:36:59',NULL,'DELETE','IN_PROGRESS','0','2316c0c2-67fa-41b3-b9b2-82db78493993','state changed','OS::Heat::SoftwareDeployment',NULL,193),(1423,'883d21eb-af79-4696-a7e2-d54de21fbf4b','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:36:59',NULL,'DELETE','COMPLETE','dep_2','0b1dfe63-062f-406d-b725-3604ca41ab05','state changed','OS::Heat::SoftwareDeployments',NULL,184),(1424,'b2479bc6-54e6-4f32-95b6-ac77f29955f2','b334fbda-f3b5-4d28-9dbd-c08785fa4ea4','2026-02-19 09:36:59',NULL,'DELETE','COMPLETE','network_stack','263c66be-8d82-4da8-8c0a-70f4e3744ac2','state changed','OS::Heat::Stack',NULL,239),(1425,'f0a0ce6f-9bfc-4595-98f1-219e5495cc58','b334fbda-f3b5-4d28-9dbd-c08785fa4ea4','2026-02-19 09:36:59',NULL,'DELETE','COMPLETE','RemoteDeeplyNestedStackTest-453210323','b334fbda-f3b5-4d28-9dbd-c08785fa4ea4','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1426,'83cc6c1d-cea7-4cb6-a0b7-52bd193af0c7','898d8a4d-2d18-4d50-8fbf-0c8feae1f848','2026-02-19 09:37:00',NULL,'DELETE','COMPLETE','0','2316c0c2-67fa-41b3-b9b2-82db78493993','state changed','OS::Heat::SoftwareDeployment',NULL,193),(1427,'05d8ff7c-f3fd-4539-b7d6-0cdf7d12c1ff','898d8a4d-2d18-4d50-8fbf-0c8feae1f848','2026-02-19 09:37:00',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-614175552-dep_4-vllpksuhb3q2','898d8a4d-2d18-4d50-8fbf-0c8feae1f848','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1428,'1136dd04-c4b6-4f03-a187-6d8a31a5711d','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:37:00',NULL,'DELETE','COMPLETE','dep_4','898d8a4d-2d18-4d50-8fbf-0c8feae1f848','state changed','OS::Heat::SoftwareDeployments',NULL,187),(1429,'7b2327a9-e70f-4593-bb60-ba96d83ccb3c','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:37:00',NULL,'DELETE','IN_PROGRESS','config','d9922bcf-9430-4ec8-9d5b-3a0b446f5d4d','state changed','OS::Heat::SoftwareConfig',NULL,183),(1430,'fc09089e-6364-44ce-b136-c4d41ecb37bb','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:37:00',NULL,'DELETE','COMPLETE','config','d9922bcf-9430-4ec8-9d5b-3a0b446f5d4d','state changed','OS::Heat::SoftwareConfig',NULL,183),(1431,'07e41da0-617b-40e8-b726-122f28c04ba7','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:37:00',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-614175552','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1432,'30dce48e-7da7-45c1-b88c-160cb46e148a','26fc6e76-721b-4eba-b18b-72e33d99f823','2026-02-19 09:37:05',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-500642542','26fc6e76-721b-4eba-b18b-72e33d99f823','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1433,'18e5a69a-de80-4364-a72b-d738d6880d76','26fc6e76-721b-4eba-b18b-72e33d99f823','2026-02-19 09:37:05',NULL,'DELETE','IN_PROGRESS','server','79f5e76f-7099-456a-a2e9-cf91dd45d6d8','state changed','OS::Nova::Server',NULL,177),(1434,'0939a52e-236d-44b1-a9c6-7b6ea289afee','26fc6e76-721b-4eba-b18b-72e33d99f823','2026-02-19 09:37:08',NULL,'DELETE','COMPLETE','server','79f5e76f-7099-456a-a2e9-cf91dd45d6d8','state changed','OS::Nova::Server',NULL,177),(1435,'b1182138-b9d6-4fe4-8811-9f00973e6121','26fc6e76-721b-4eba-b18b-72e33d99f823','2026-02-19 09:37:08',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-500642542','26fc6e76-721b-4eba-b18b-72e33d99f823','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1436,'a8f797ad-9740-4be3-ba43-c0ca246be002','cbe062ff-5793-4db9-8520-c53c852ef6f6','2026-02-19 09:37:13',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1674731843','cbe062ff-5793-4db9-8520-c53c852ef6f6','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1437,'607cc774-7eed-43ca-8acd-c8ba50a87944','cbe062ff-5793-4db9-8520-c53c852ef6f6','2026-02-19 09:37:13',NULL,'CREATE','IN_PROGRESS','server','Pa-llelDeploymentsTest-1674731843-server-wpjeq55vpbgw','state changed','OS::Nova::Server',NULL,244),(1438,'e4ef4971-15d4-4602-a52a-73bc51305a5c','cbe062ff-5793-4db9-8520-c53c852ef6f6','2026-02-19 09:37:29',NULL,'CREATE','COMPLETE','server','bae50c94-735e-4a77-9dda-720a67eccc04','state changed','OS::Nova::Server',NULL,244),(1439,'8ae71e05-b88d-47af-8234-a12acf67a557','cbe062ff-5793-4db9-8520-c53c852ef6f6','2026-02-19 09:37:29',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1674731843','cbe062ff-5793-4db9-8520-c53c852ef6f6','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1440,'62c6e495-3fd2-454a-be43-c13c55aa0106','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','2026-02-19 09:37:33',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1835728659','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1441,'6324c346-ed60-4c6e-bd9a-52f379028896','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','2026-02-19 09:37:33',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-1835728659-config-mer7fgzhiwo2','state changed','OS::Heat::SoftwareConfig',NULL,245),(1442,'42d00321-798a-4346-a511-7e7f662b7420','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','2026-02-19 09:37:33',NULL,'CREATE','COMPLETE','config','dfc6b4a2-6363-463e-b577-57f7bafde91d','state changed','OS::Heat::SoftwareConfig',NULL,245),(1443,'ebcf5ac9-f801-407c-af72-a0a37bcd30c1','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','2026-02-19 09:37:33',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-1835728659-dep_0-wdc4fp5bilga','state changed','OS::Heat::SoftwareDeployments',NULL,247),(1444,'505ffc88-3f3c-4d1e-ab21-db6118e7e6c4','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','2026-02-19 09:37:33',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-1835728659-dep_2-zwdckbfn73nh','state changed','OS::Heat::SoftwareDeployments',NULL,246),(1445,'904a041d-e395-4fd0-998d-64ce5b7caf5a','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','2026-02-19 09:37:33',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-1835728659-dep_1-xbamgrqddcn2','state changed','OS::Heat::SoftwareDeployments',NULL,248),(1446,'801d6c3f-63ae-4aba-9f6b-5bda4684a37a','1d1726b4-d6e6-4d37-a2ec-f352e094251f','2026-02-19 09:37:34',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1835728659-dep_0-wdc4fp5bilga','1d1726b4-d6e6-4d37-a2ec-f352e094251f','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1447,'57269435-e7a9-4b47-ac81-0caffea1cc7d','422f5827-e986-447e-a5a8-f6976e110842','2026-02-19 09:37:34',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1835728659-dep_2-zwdckbfn73nh','422f5827-e986-447e-a5a8-f6976e110842','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1448,'8a086356-414b-4989-bdcc-ff470adf86f8','b149dd07-d961-4e1e-89b8-766cfb699627','2026-02-19 09:37:34',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1835728659-dep_1-xbamgrqddcn2','b149dd07-d961-4e1e-89b8-766cfb699627','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1449,'59629e4e-c100-426d-9c4c-7f2f49c2462a','422f5827-e986-447e-a5a8-f6976e110842','2026-02-19 09:37:34',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1835728659-dep_2-zwdckbfn73nh-0-gcdyyft2ze3x','state changed','OS::Heat::SoftwareDeployment',NULL,249),(1450,'5dc34bf7-7c23-4f05-b01e-bf304de1086f','1d1726b4-d6e6-4d37-a2ec-f352e094251f','2026-02-19 09:37:34',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1835728659-dep_0-wdc4fp5bilga-0-sdp6p4t6kttp','state changed','OS::Heat::SoftwareDeployment',NULL,250),(1451,'1fc7b3d3-25a1-473f-b98a-a1110a0aa3a7','b149dd07-d961-4e1e-89b8-766cfb699627','2026-02-19 09:37:34',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1835728659-dep_1-xbamgrqddcn2-0-bdxtqiimaguc','state changed','OS::Heat::SoftwareDeployment',NULL,251),(1452,'44863ca1-22df-4852-b76f-df72a252e147','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','2026-02-19 09:38:34',NULL,'CREATE','FAILED','dep_0','1d1726b4-d6e6-4d37-a2ec-f352e094251f','CREATE aborted (Task create from SoftwareDeployments \"dep_0\" Stack \"ParallelDeploymentsTest-1835728659\" [c6a6f087-3aaf-4b90-8bf0-7ebb26df0984] Timed out)','OS::Heat::SoftwareDeployments',NULL,247),(1453,'182bb72b-7e41-4376-81a6-c770d0154482','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','2026-02-19 09:38:34',NULL,'CREATE','FAILED','dep_1','b149dd07-d961-4e1e-89b8-766cfb699627','CREATE aborted (Task create from SoftwareDeployments \"dep_1\" Stack \"ParallelDeploymentsTest-1835728659\" [c6a6f087-3aaf-4b90-8bf0-7ebb26df0984] Timed out)','OS::Heat::SoftwareDeployments',NULL,248),(1454,'9fde0330-d5f0-4530-bf54-121111a473e0','b149dd07-d961-4e1e-89b8-766cfb699627','2026-02-19 09:38:34',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1835728659-dep_1-xbamgrqddcn2','b149dd07-d961-4e1e-89b8-766cfb699627','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1455,'83e2a628-2b1f-42d6-b86d-6fee8fe59e46','1d1726b4-d6e6-4d37-a2ec-f352e094251f','2026-02-19 09:38:34',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1835728659-dep_0-wdc4fp5bilga','1d1726b4-d6e6-4d37-a2ec-f352e094251f','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1456,'2e0a92fa-b887-4953-a7cf-75037af8ac5c','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','2026-02-19 09:38:34',NULL,'CREATE','FAILED','dep_2','422f5827-e986-447e-a5a8-f6976e110842','CREATE aborted (Task create from SoftwareDeployments \"dep_2\" Stack \"ParallelDeploymentsTest-1835728659\" [c6a6f087-3aaf-4b90-8bf0-7ebb26df0984] Timed out)','OS::Heat::SoftwareDeployments',NULL,246),(1457,'d7f26062-31a3-40be-bcaa-80ba792e0471','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','2026-02-19 09:38:34',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1835728659','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','Timed out','OS::Heat::Stack',NULL,NULL),(1458,'d1783355-c097-45c9-89a9-a01691d552a0','422f5827-e986-447e-a5a8-f6976e110842','2026-02-19 09:38:34',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1835728659-dep_2-zwdckbfn73nh','422f5827-e986-447e-a5a8-f6976e110842','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1459,'852d94a3-984c-4ba9-90ff-d662ed1d6bde','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','2026-02-19 09:38:34',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1835728659','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','Timed out','OS::Heat::Stack',NULL,NULL),(1460,'efccc98c-926c-4c94-bf88-5ffcd2e4a949','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','2026-02-19 09:38:34',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1835728659','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','Timed out','OS::Heat::Stack',NULL,NULL),(1461,'ecd9e32f-15d1-4b00-9573-3d3346961406','422f5827-e986-447e-a5a8-f6976e110842','2026-02-19 09:38:34',NULL,'CREATE','FAILED','0','7d66f7ab-ac98-4ba1-bfed-7b03d3b1a2b8','CREATE aborted (Task create from SoftwareDeployment \"0\" Stack \"ParallelDeploymentsTest-1835728659-dep_2-zwdckbfn73nh\" [422f5827-e986-447e-a5a8-f6976e110842] Timed out)','OS::Heat::SoftwareDeployment',NULL,249),(1462,'535d96d9-43e0-4ee0-a50e-9f77253fbfce','b149dd07-d961-4e1e-89b8-766cfb699627','2026-02-19 09:38:34',NULL,'CREATE','FAILED','0','30b7648d-b1ec-4fb9-89ae-a85952d35b05','CREATE aborted (Task create from SoftwareDeployment \"0\" Stack \"ParallelDeploymentsTest-1835728659-dep_1-xbamgrqddcn2\" [b149dd07-d961-4e1e-89b8-766cfb699627] Timed out)','OS::Heat::SoftwareDeployment',NULL,251),(1463,'c4de7bea-fb07-43ab-bfe2-52e525aa1db2','1d1726b4-d6e6-4d37-a2ec-f352e094251f','2026-02-19 09:38:34',NULL,'CREATE','FAILED','0','42d65df8-2f53-490f-96d1-04457c23b956','CREATE aborted (Task create from SoftwareDeployment \"0\" Stack \"ParallelDeploymentsTest-1835728659-dep_0-wdc4fp5bilga\" [1d1726b4-d6e6-4d37-a2ec-f352e094251f] Timed out)','OS::Heat::SoftwareDeployment',NULL,250),(1464,'9bebdb72-caab-4d3a-8aac-a0cc1d43d0e4','422f5827-e986-447e-a5a8-f6976e110842','2026-02-19 09:38:34',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1835728659-dep_2-zwdckbfn73nh','422f5827-e986-447e-a5a8-f6976e110842','Timed out','OS::Heat::Stack',NULL,NULL),(1465,'4a0e729d-719c-45a5-9991-a34a5b0ea1a7','b149dd07-d961-4e1e-89b8-766cfb699627','2026-02-19 09:38:34',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1835728659-dep_1-xbamgrqddcn2','b149dd07-d961-4e1e-89b8-766cfb699627','Timed out','OS::Heat::Stack',NULL,NULL),(1466,'17cdec21-e98a-491d-92d7-475f060ce02e','1d1726b4-d6e6-4d37-a2ec-f352e094251f','2026-02-19 09:38:34',NULL,'CREATE','FAILED','ParallelDeploymentsTest-1835728659-dep_0-wdc4fp5bilga','1d1726b4-d6e6-4d37-a2ec-f352e094251f','Timed out','OS::Heat::Stack',NULL,NULL),(1467,'6a9d855e-b17b-4aab-aaf8-67b0939ae9c8','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','2026-02-19 09:38:39',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1835728659','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1468,'c3459f87-4594-4002-812e-a6258462e34b','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','2026-02-19 09:38:39',NULL,'DELETE','IN_PROGRESS','dep_0','1d1726b4-d6e6-4d37-a2ec-f352e094251f','state changed','OS::Heat::SoftwareDeployments',NULL,247),(1469,'94b06d6e-1906-4840-bc6e-b8421f16484f','1d1726b4-d6e6-4d37-a2ec-f352e094251f','2026-02-19 09:38:39',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1835728659-dep_0-wdc4fp5bilga','1d1726b4-d6e6-4d37-a2ec-f352e094251f','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1470,'1e5d4235-7b1f-4946-9b04-d57cdb9533c4','1d1726b4-d6e6-4d37-a2ec-f352e094251f','2026-02-19 09:38:39',NULL,'DELETE','IN_PROGRESS','0','42d65df8-2f53-490f-96d1-04457c23b956','state changed','OS::Heat::SoftwareDeployment',NULL,250),(1471,'a82c4d0d-0fb4-446f-baad-3f7da60e2040','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','2026-02-19 09:38:40',NULL,'DELETE','IN_PROGRESS','dep_1','b149dd07-d961-4e1e-89b8-766cfb699627','state changed','OS::Heat::SoftwareDeployments',NULL,248),(1472,'8646638c-32af-4256-94f3-598287417e54','b149dd07-d961-4e1e-89b8-766cfb699627','2026-02-19 09:38:40',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1835728659-dep_1-xbamgrqddcn2','b149dd07-d961-4e1e-89b8-766cfb699627','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1473,'fa120dee-ecde-4ece-b295-cce7b1de9d00','1d1726b4-d6e6-4d37-a2ec-f352e094251f','2026-02-19 09:38:40',NULL,'DELETE','COMPLETE','0','42d65df8-2f53-490f-96d1-04457c23b956','state changed','OS::Heat::SoftwareDeployment',NULL,250),(1474,'ded7d061-203c-473f-997d-da462095eeab','1d1726b4-d6e6-4d37-a2ec-f352e094251f','2026-02-19 09:38:40',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1835728659-dep_0-wdc4fp5bilga','1d1726b4-d6e6-4d37-a2ec-f352e094251f','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1475,'3e47719f-2b5d-4d1a-b4f9-dee6e2b2961f','b149dd07-d961-4e1e-89b8-766cfb699627','2026-02-19 09:38:40',NULL,'DELETE','IN_PROGRESS','0','30b7648d-b1ec-4fb9-89ae-a85952d35b05','state changed','OS::Heat::SoftwareDeployment',NULL,251),(1476,'661119e1-af31-44b3-b1c5-5acc81179fb5','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','2026-02-19 09:38:41',NULL,'DELETE','IN_PROGRESS','dep_2','422f5827-e986-447e-a5a8-f6976e110842','state changed','OS::Heat::SoftwareDeployments',NULL,246),(1477,'faff967d-30df-4ae9-bb43-2dc26375d7ed','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','2026-02-19 09:38:41',NULL,'DELETE','COMPLETE','dep_0','1d1726b4-d6e6-4d37-a2ec-f352e094251f','state changed','OS::Heat::SoftwareDeployments',NULL,247),(1478,'a135e963-3c8d-4dde-97e9-7adeff8b3d6d','422f5827-e986-447e-a5a8-f6976e110842','2026-02-19 09:38:41',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1835728659-dep_2-zwdckbfn73nh','422f5827-e986-447e-a5a8-f6976e110842','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1479,'ff750f77-5bda-4579-a561-125742632716','422f5827-e986-447e-a5a8-f6976e110842','2026-02-19 09:38:41',NULL,'DELETE','IN_PROGRESS','0','7d66f7ab-ac98-4ba1-bfed-7b03d3b1a2b8','state changed','OS::Heat::SoftwareDeployment',NULL,249),(1480,'9193db11-ee45-4f28-bae3-4bfdd5fc4123','b149dd07-d961-4e1e-89b8-766cfb699627','2026-02-19 09:38:41',NULL,'DELETE','COMPLETE','0','30b7648d-b1ec-4fb9-89ae-a85952d35b05','state changed','OS::Heat::SoftwareDeployment',NULL,251),(1481,'9a2aa6a4-efb3-4ebe-85c7-43e1be74a230','b149dd07-d961-4e1e-89b8-766cfb699627','2026-02-19 09:38:41',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1835728659-dep_1-xbamgrqddcn2','b149dd07-d961-4e1e-89b8-766cfb699627','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1482,'fa6234a8-01fd-42ac-9a43-2eb6e14c7350','422f5827-e986-447e-a5a8-f6976e110842','2026-02-19 09:38:42',NULL,'DELETE','COMPLETE','0','7d66f7ab-ac98-4ba1-bfed-7b03d3b1a2b8','state changed','OS::Heat::SoftwareDeployment',NULL,249),(1483,'c15f8253-3efe-4b12-80a7-de300fad0295','422f5827-e986-447e-a5a8-f6976e110842','2026-02-19 09:38:42',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1835728659-dep_2-zwdckbfn73nh','422f5827-e986-447e-a5a8-f6976e110842','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1484,'ca3a3568-9a86-45dd-8052-a0e5bf5c9371','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','2026-02-19 09:38:42',NULL,'DELETE','COMPLETE','dep_1','b149dd07-d961-4e1e-89b8-766cfb699627','state changed','OS::Heat::SoftwareDeployments',NULL,248),(1485,'35331d05-9feb-437a-88ff-659dde1c5aea','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','2026-02-19 09:38:42',NULL,'DELETE','COMPLETE','dep_2','422f5827-e986-447e-a5a8-f6976e110842','state changed','OS::Heat::SoftwareDeployments',NULL,246),(1486,'f32eabc3-6fe1-419a-9ff4-8a4965658854','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','2026-02-19 09:38:42',NULL,'DELETE','IN_PROGRESS','config','dfc6b4a2-6363-463e-b577-57f7bafde91d','state changed','OS::Heat::SoftwareConfig',NULL,245),(1487,'a543baf7-8024-4664-af4b-dd53e9460798','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','2026-02-19 09:38:42',NULL,'DELETE','COMPLETE','config','dfc6b4a2-6363-463e-b577-57f7bafde91d','state changed','OS::Heat::SoftwareConfig',NULL,245),(1488,'a26febc6-351b-43cc-b64d-9df592b9e7ae','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','2026-02-19 09:38:42',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1835728659','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1489,'4690b1dc-9840-43d4-bc1e-2c7162ca3ea2','cbe062ff-5793-4db9-8520-c53c852ef6f6','2026-02-19 09:38:44',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1674731843','cbe062ff-5793-4db9-8520-c53c852ef6f6','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1490,'7367ab3e-356c-4c3e-bda3-d392a98226f8','cbe062ff-5793-4db9-8520-c53c852ef6f6','2026-02-19 09:38:44',NULL,'DELETE','IN_PROGRESS','server','bae50c94-735e-4a77-9dda-720a67eccc04','state changed','OS::Nova::Server',NULL,244),(1491,'5254d6c9-7afc-402c-a530-a3538ccfd18d','cbe062ff-5793-4db9-8520-c53c852ef6f6','2026-02-19 09:38:50',NULL,'DELETE','COMPLETE','server','bae50c94-735e-4a77-9dda-720a67eccc04','state changed','OS::Nova::Server',NULL,244),(1492,'10cf1b43-9266-434b-abaa-f9dd0112c5c6','cbe062ff-5793-4db9-8520-c53c852ef6f6','2026-02-19 09:38:50',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1674731843','cbe062ff-5793-4db9-8520-c53c852ef6f6','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL);
/*!40000 ALTER TABLE `event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('heat','/usr/lib/python3.9/site-packages/heat/db/sqlalchemy/migrate_repo',86);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template`
--

DROP TABLE IF EXISTS `raw_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `template` longtext DEFAULT NULL,
  `files` longtext DEFAULT NULL,
  `environment` longtext DEFAULT NULL,
  `files_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_tmpl_files_fkey_ref` (`files_id`),
  CONSTRAINT `raw_tmpl_files_fkey_ref` FOREIGN KEY (`files_id`) REFERENCES `raw_template_files` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=240 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template`
--

LOCK TABLES `raw_template` WRITE;
/*!40000 ALTER TABLE `raw_template` DISABLE KEYS */;
INSERT INTO `raw_template` (`id`, `created_at`, `updated_at`, `template`, `files`, `environment`, `files_id`) VALUES (1,'2026-02-19 09:29:10',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"test\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(4,'2026-02-19 09:29:11',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(5,'2026-02-19 09:29:14',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"test\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(6,'2026-02-19 09:29:15',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(7,'2026-02-19 09:29:17',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(10,'2026-02-19 09:29:22',NULL,'{\"heat_template_version\": \"2016-04-08\"}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(14,'2026-02-19 09:29:23',NULL,'{\"heat_template_version\": \"2016-04-08\"}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(16,'2026-02-19 09:29:24',NULL,'{\"heat_template_version\": \"2016-04-08\"}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(18,'2026-02-19 09:29:25',NULL,'{\"heat_template_version\": \"2016-04-08\"}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(20,'2026-02-19 09:29:26',NULL,'{\"heat_template_version\": \"pike\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}, \"action_wait_secs\": {\"update\": 1}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"new_value\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(25,'2026-02-19 09:29:30',NULL,'{\"heat_template_version\": \"pike\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}, \"action_wait_secs\": {\"update\": 1}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"new_patched_value\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(27,'2026-02-19 09:29:31',NULL,'{\"heat_template_version\": \"pike\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}, \"action_wait_secs\": {\"update\": 1}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"new_patched_value\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(29,'2026-02-19 09:29:38',NULL,'{\"heat_template_version\": \"pike\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"new_patched_value\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(34,'2026-02-19 09:29:49',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create port wit ip_address.\", \"parameters\": {\"mac\": {\"type\": \"string\", \"default\": \"00-00-00-00-BB-BB\"}}, \"resources\": {}, \"outputs\": {\"port_ip\": {\"value\": {\"get_attr\": [\"port\", \"fixed_ips\", 0, \"ip_address\"]}}, \"mac_address\": {\"value\": {\"get_attr\": [\"port\", \"mac_address\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(36,'2026-02-19 09:29:50',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(40,'2026-02-19 09:30:01',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(43,'2026-02-19 09:30:10',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(45,'2026-02-19 09:30:12',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(46,'2026-02-19 09:30:16',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create port wit ip_address.\", \"parameters\": {\"mac\": {\"type\": \"string\", \"default\": \"00-00-00-00-BB-BB\"}}, \"resources\": {}, \"outputs\": {\"port_ip\": {\"value\": {\"get_attr\": [\"port\", \"fixed_ips\", 0, \"ip_address\"]}}, \"mac_address\": {\"value\": {\"get_attr\": [\"port\", \"mac_address\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"mac\": \"00-00-00-00-AA-AA\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(52,'2026-02-19 09:30:31',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(53,'2026-02-19 09:30:31',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(58,'2026-02-19 09:30:49',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(59,'2026-02-19 09:30:55',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server with port.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(62,'2026-02-19 09:31:00',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(65,'2026-02-19 09:31:09',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(67,'2026-02-19 09:31:14',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(71,'2026-02-19 09:31:31',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(73,'2026-02-19 09:31:34',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server with subnet and fixed_ip.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"networks\": {\"value\": {\"get_attr\": [\"server\", \"networks\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(76,'2026-02-19 09:31:42',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(77,'2026-02-19 09:31:43',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(79,'2026-02-19 09:31:51',NULL,'{\"heat_template_version\": \"2014-10-16\", \"parameters\": {\"image\": {\"type\": \"string\"}, \"flavor\": {\"type\": \"string\"}, \"network\": {\"type\": \"string\"}, \"foo\": {\"type\": \"string\", \"description\": \"parameter with encryption turned on\", \"hidden\": true, \"default\": \"secret\"}}, \"resources\": {}, \"outputs\": {\"encrypted_foo_param\": {\"description\": \"encrypted param\", \"value\": {\"get_param\": \"foo\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\", \"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"network\": \"heat_tempestconf_network\", \"foo\": \"my_encrypted_foo\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(84,'2026-02-19 09:32:17',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create encryption volume type.\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(88,'2026-02-19 09:32:30',NULL,'{\"heat_template_version\": \"2016-10-14\", \"resources\": {}, \"outputs\": {\"str\": {\"value\": {\"get_resource\": \"test1\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(89,'2026-02-19 09:32:32',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(92,'2026-02-19 09:32:38',NULL,'{\"heat_template_version\": \"2016-10-14\", \"resources\": {}, \"outputs\": {\"str\": {\"value\": {\"get_resource\": \"test1\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(94,'2026-02-19 09:32:43',NULL,'{\"heat_template_version\": \"2016-10-14\", \"resources\": {\"test1\": {\"type\": \"OS::Heat::TestResource\"}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(95,'2026-02-19 09:32:43',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"networks\": {\"value\": {\"get_attr\": [\"server\", \"networks\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(99,'2026-02-19 09:32:54',NULL,'{\"heat_template_version\": \"2016-10-14\", \"resources\": {}, \"outputs\": {\"str\": {\"value\": {\"get_resource\": \"test1\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(100,'2026-02-19 09:32:56',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(104,'2026-02-19 09:33:03',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(105,'2026-02-19 09:33:04',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"remote_key\": {\"value\": {\"get_attr\": [\"random1\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(106,'2026-02-19 09:33:07',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(107,'2026-02-19 09:33:07',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(114,'2026-02-19 09:33:19',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"key\": {\"value\": {\"get_attr\": [\"my_stack\", \"outputs\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',1),(117,'2026-02-19 09:33:21',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"remote_key\": {\"value\": {\"get_attr\": [\"random1\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',2),(118,'2026-02-19 09:33:25',NULL,'{\"heat_template_version\": \"2015-10-15\", \"resources\": {}, \"outputs\": {\"resource_output_a\": {\"value\": {\"get_attr\": [\"parent\", \"resource_output_a\"]}, \"description\": \"parent a\"}, \"resource_output_b\": {\"value\": {\"get_attr\": [\"parent\", \"resource_output_b\"]}, \"description\": \"parent b\"}}}','null','{\"resource_registry\": {\"resources\": {}, \"1.yaml\": \"1.yaml\"}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',4),(119,'2026-02-19 09:33:25',NULL,'{\"heat_template_version\": \"2015-10-15\", \"resources\": {}, \"outputs\": {\"resource_output_a\": {\"description\": \"Output of resource a\", \"value\": {\"get_attr\": [\"test_resource_a\", \"output\"]}}, \"resource_output_b\": {\"description\": \"Output of resource b\", \"value\": {\"get_param\": \"foo\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',4),(120,'2026-02-19 09:33:26',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_step2\": {\"hooks\": \"pre-create\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(126,'2026-02-19 09:33:36',NULL,'{\"heat_template_version\": \"2015-10-15\", \"resources\": {}, \"outputs\": {\"resource_output_a\": {\"description\": \"Output of resource a\", \"value\": {\"get_attr\": [\"test_resource_a\", \"output\"]}}, \"resource_output_b\": {\"description\": \"Output of resource b\", \"value\": {\"get_attr\": [\"test_resource_b\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(129,'2026-02-19 09:33:50',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"nested\": {\"foo_step2\": {\"hooks\": \"pre-create\"}}}, \"nested.yaml\": \"nested.yaml\"}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',7),(130,'2026-02-19 09:33:51',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"key\": {\"value\": {\"get_attr\": [\"my_stack\", \"outputs\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',5),(131,'2026-02-19 09:33:51',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_step2\": {\"hooks\": \"pre-create\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',7),(132,'2026-02-19 09:33:52',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"remote_key\": {\"value\": {\"get_attr\": [\"random1\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',6),(136,'2026-02-19 09:33:58',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(137,'2026-02-19 09:34:00',NULL,'{\"heat_template_version\": \"2015-10-15\", \"resources\": {}, \"outputs\": {\"output_value\": {\"description\": \"Output of resource b\", \"value\": {\"get_attr\": [\"test_resource_b\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(143,'2026-02-19 09:34:09',NULL,'{\"heat_template_version\": \"2014-10-16\", \"description\": \"\\u8fd9\\u662f\\u4e00\\u4e2a\\u63cf\\u8ff0\", \"parameters\": {\"\\u53c2\\u6570\": {\"type\": \"number\", \"default\": 10, \"label\": \"\\u6807\\u7b7e\", \"description\": \"\\u8fd9\\u662f\\u4e00\\u4e2a\\u63cf\\u8ff0\"}}, \"resources\": {}, \"outputs\": {\"\\u8f93\\u51fa\": {\"description\": \"\\u8fd9\\u662f\\u4e00\\u4e2a\\u63cf\\u8ff0\", \"value\": {\"get_attr\": [\"\\u8d44\\u6e90\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(144,'2026-02-19 09:34:15',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"key\": {\"value\": {\"get_attr\": [\"my_stack\", \"outputs\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',10),(145,'2026-02-19 09:34:15',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"remote_key\": {\"value\": {\"get_attr\": [\"random2\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',11),(146,'2026-02-19 09:34:20',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_*\": {\"hooks\": \"pre-create\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(153,'2026-02-19 09:34:36',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(154,'2026-02-19 09:34:37',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"rg\": {\"hooks\": \"pre-update\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(155,'2026-02-19 09:34:37',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}, \"outputs\": {\"refs_map\": {\"value\": {\"0\": {\"get_resource\": \"0\"}, \"1\": {\"get_resource\": \"1\"}}}}}','null','{\"resource_registry\": {\"resources\": {\"hooks\": \"pre-update\"}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(183,'2026-02-19 09:35:03',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_step2\": {\"hooks\": \"pre-update\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(185,'2026-02-19 09:35:08',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(186,'2026-02-19 09:35:14',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(188,'2026-02-19 09:35:15',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(189,'2026-02-19 09:35:16',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(191,'2026-02-19 09:35:29',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(192,'2026-02-19 09:35:29',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_step2\": {\"hooks\": \"pre-update\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(193,'2026-02-19 09:35:31',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(195,'2026-02-19 09:35:34',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(196,'2026-02-19 09:35:36',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(197,'2026-02-19 09:35:37',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(198,'2026-02-19 09:35:38',NULL,'{\"heat_template_version\": \"2014-10-16\", \"parameters\": null, \"resources\": {}, \"outputs\": {\"resource_id\": {\"description\": \"ID of resource\", \"value\": {\"get_resource\": \"test_resource\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(200,'2026-02-19 09:35:48',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(201,'2026-02-19 09:35:50',NULL,'{\"heat_template_version\": \"2014-10-16\", \"description\": \"foo\", \"parameters\": {\"input\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(202,'2026-02-19 09:35:55',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(203,'2026-02-19 09:35:55',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(205,'2026-02-19 09:35:57',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(208,'2026-02-19 09:36:13',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(209,'2026-02-19 09:36:16',NULL,'{\"heat_template_version\": \"2014-10-16\", \"description\": \"foo\", \"parameters\": {\"input\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"input\": \"none\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(210,'2026-02-19 09:36:21',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(211,'2026-02-19 09:36:23',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(212,'2026-02-19 09:36:24',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(213,'2026-02-19 09:36:25',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(214,'2026-02-19 09:36:26',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(216,'2026-02-19 09:36:29',NULL,'{\"heat_template_version\": \"2014-10-16\", \"description\": \"Test Template APIs\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(218,'2026-02-19 09:36:42',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(221,'2026-02-19 09:36:50',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(222,'2026-02-19 09:36:51',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(223,'2026-02-19 09:36:52',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(224,'2026-02-19 09:36:53',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(225,'2026-02-19 09:36:54',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(226,'2026-02-19 09:36:54',NULL,'{\"description\": \"The root stack (containing a remote stack) for the deeply-nested remote\\nstack test.\\n\", \"heat_template_version\": \"2015-10-15\", \"outputs\": {\"router\": {\"value\": {\"get_attr\": [\"network_stack\", \"outputs\", \"router\"]}}}, \"parameters\": {\"name\": {\"constraints\": [{\"allowed_pattern\": \"[a-z][a-z0-9-]{1,}\"}], \"description\": \"Name of the router\", \"type\": \"string\"}, \"network_name\": {\"constraints\": [{\"custom_constraint\": \"neutron.network\"}], \"description\": \"The public network to connect to\", \"type\": \"string\"}, \"region\": {\"default\": \"RegionOne\", \"description\": \"The region in which to create the remote stack\", \"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"name\": \"remote-nested\", \"network_name\": \"public\", \"region\": \"regionOne\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',12),(227,'2026-02-19 09:36:55',NULL,'{\"heat_template_version\": \"2015-10-15\", \"description\": \"The intermediate stack (containing a local nested stack) to be instantiated\\nremotely in the remote deeply-nested stack test.\\n\", \"parameters\": {\"name\": {\"type\": \"string\", \"description\": \"Name of the router\", \"constraints\": [{\"allowed_pattern\": \"[a-z][a-z0-9-]{1,}\"}]}, \"network_name\": {\"type\": \"string\", \"description\": \"The public network to connect to\", \"constraints\": [{\"custom_constraint\": \"neutron.network\"}]}}, \"resources\": {}, \"outputs\": {\"router\": {\"value\": {\"get_attr\": [\"network_stack_as_custom_type\", \"router\"]}}}}','null','{\"resource_registry\": {\"resources\": {}, \"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\": \"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\"}, \"parameters\": {\"name\": \"remote-nested\", \"network_name\": \"public\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',13),(228,'2026-02-19 09:36:56',NULL,'{\"heat_template_version\": \"2015-10-15\", \"description\": \"The base stack (containing an actual resource) for the remote deeply-nested\\nstack test.\\n\", \"parameters\": {\"name\": {\"type\": \"string\", \"description\": \"Name of the router\", \"constraints\": [{\"allowed_pattern\": \"[a-z][a-z0-9-]{1,}\"}]}, \"network_name\": {\"type\": \"string\", \"description\": \"The network to connect to\", \"constraints\": [{\"custom_constraint\": \"neutron.network\"}]}}, \"resources\": {}, \"outputs\": {\"router\": {\"value\": {\"get_resource\": \"router\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"name\": \"remote-nested\", \"network_name\": \"public\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',13),(229,'2026-02-19 09:37:05',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}, \"network\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"server\": {\"value\": {\"get_resource\": \"server\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"network\": \"heat_tempestconf_network\", \"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(235,'2026-02-19 09:38:39',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"bae50c94-735e-4a77-9dda-720a67eccc04\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(236,'2026-02-19 09:38:39',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(237,'2026-02-19 09:38:40',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(238,'2026-02-19 09:38:41',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(239,'2026-02-19 09:38:44',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}, \"network\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"server\": {\"value\": {\"get_resource\": \"server\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"network\": \"heat_tempestconf_network\", \"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL);
/*!40000 ALTER TABLE `raw_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template_files`
--

DROP TABLE IF EXISTS `raw_template_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `files` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template_files`
--

LOCK TABLES `raw_template_files` WRITE;
/*!40000 ALTER TABLE `raw_template_files` DISABLE KEYS */;
INSERT INTO `raw_template_files` (`id`, `files`, `created_at`, `updated_at`) VALUES (1,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}','2026-02-19 09:33:10',NULL),(2,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}','2026-02-19 09:33:12',NULL),(4,'{\"1.yaml\": \"\\nheat_template_version: 2015-10-15\\nresources:\\n  test_resource_a:\\n    type: OS::Heat::TestResource\\n    properties:\\n      value: \'a\'\\n  test_resource_b:\\n    type: OS::Heat::TestResource\\n    properties:\\n      value: \'b\'\\noutputs:\\n  resource_output_a:\\n    description: \'Output of resource a\'\\n    value: { get_attr: [test_resource_a, output] }\\n  resource_output_b:\\n    description: \'Output of resource b\'\\n    value: { get_param: foo }\\n\"}','2026-02-19 09:33:20',NULL),(5,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}','2026-02-19 09:33:27',NULL),(6,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}','2026-02-19 09:33:28',NULL),(7,'{\"nested.yaml\": \"heat_template_version: \'2014-10-16\'\\nresources:\\n  foo_step1:\\n    type: OS::Heat::RandomString\\n  foo_step2:\\n    depends_on: foo_step1\\n    type: OS::Heat::RandomString\\n  foo_step3:\\n    depends_on: foo_step2\\n    type: OS::Heat::RandomString\\n\"}','2026-02-19 09:33:31',NULL),(10,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random2:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random2, value]}\\n\"}','2026-02-19 09:34:04',NULL),(11,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random2:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random2, value]}\\n\"}','2026-02-19 09:34:06',NULL),(12,'{\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The base stack (containing an actual resource) for the remote deeply-nested\\\\nstack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"router\\\": {\\\"type\\\": \\\"OS::Neutron::Router\\\", \\\"properties\\\": {\\\"name\\\": {\\\"list_join\\\": [\\\"-\\\", [{\\\"get_param\\\": \\\"name\\\"}, \\\"router\\\"]]}, \\\"external_gateway_info\\\": {\\\"network\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_resource\\\": \\\"router\\\"}}}}\", \"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_intermediate.yaml\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The intermediate stack (containing a local nested stack) to be instantiated\\\\nremotely in the remote deeply-nested stack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The public network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"network_stack_as_custom_type\\\": {\\\"type\\\": \\\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\\\", \\\"properties\\\": {\\\"name\\\": {\\\"get_param\\\": \\\"name\\\"}, \\\"network_name\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_attr\\\": [\\\"network_stack_as_custom_type\\\", \\\"router\\\"]}}}}\"}','2026-02-19 09:36:41',NULL),(13,'{\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The base stack (containing an actual resource) for the remote deeply-nested\\\\nstack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"router\\\": {\\\"type\\\": \\\"OS::Neutron::Router\\\", \\\"properties\\\": {\\\"name\\\": {\\\"list_join\\\": [\\\"-\\\", [{\\\"get_param\\\": \\\"name\\\"}, \\\"router\\\"]]}, \\\"external_gateway_info\\\": {\\\"network\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_resource\\\": \\\"router\\\"}}}}\", \"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_intermediate.yaml\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The intermediate stack (containing a local nested stack) to be instantiated\\\\nremotely in the remote deeply-nested stack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The public network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"network_stack_as_custom_type\\\": {\\\"type\\\": \\\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\\\", \\\"properties\\\": {\\\"name\\\": {\\\"get_param\\\": \\\"name\\\"}, \\\"network_name\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_attr\\\": [\\\"network_stack_as_custom_type\\\", \\\"router\\\"]}}}}\"}','2026-02-19 09:36:44',NULL);
/*!40000 ALTER TABLE `raw_template_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource`
--

DROP TABLE IF EXISTS `resource`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `nova_instance` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `rsrc_metadata` longtext DEFAULT NULL,
  `properties_data` longtext DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  `atomic_key` int(11) DEFAULT NULL,
  `needed_by` longtext DEFAULT NULL,
  `requires` longtext DEFAULT NULL,
  `replaces` int(11) DEFAULT NULL,
  `replaced_by` int(11) DEFAULT NULL,
  `current_template_id` int(11) DEFAULT NULL,
  `properties_data_encrypted` tinyint(1) DEFAULT NULL,
  `root_stack_id` varchar(36) DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  `attr_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `current_template_id` (`current_template_id`),
  KEY `ix_resource_root_stack_id` (`root_stack_id`),
  KEY `rsrc_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  KEY `rsrc_attr_data_ref` (`attr_data_id`),
  CONSTRAINT `resource_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`),
  CONSTRAINT `resource_ibfk_2` FOREIGN KEY (`current_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `rsrc_attr_data_ref` FOREIGN KEY (`attr_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `rsrc_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=229 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource`
--

LOCK TABLES `resource` WRITE;
/*!40000 ALTER TABLE `resource` DISABLE KEYS */;
INSERT INTO `resource` (`id`, `uuid`, `nova_instance`, `name`, `created_at`, `updated_at`, `action`, `status`, `status_reason`, `stack_id`, `rsrc_metadata`, `properties_data`, `engine_id`, `atomic_key`, `needed_by`, `requires`, `replaces`, `replaced_by`, `current_template_id`, `properties_data_encrypted`, `root_stack_id`, `rsrc_prop_data_id`, `attr_data_id`) VALUES (2,'74b6d969-9183-4216-ad47-c01313e3aef1','api-743921893-envstack-test-efurqn2lnwlj','test','2026-02-19 09:29:11',NULL,'CREATE','COMPLETE','state changed','b2ad0b40-ebd0-43d3-bbd3-611445ea3ef1','{}','null',NULL,2,'[]','[]',NULL,NULL,1,NULL,'b2ad0b40-ebd0-43d3-bbd3-611445ea3ef1',2,NULL),(3,'72e2a77f-c652-4f35-9a09-a2ab89d132f0','api-75184910-rsrcstack-test-6nogkjzofj37','test','2026-02-19 09:29:12',NULL,'CHECK','FAILED','resource deleted','c3c868ba-7067-4d77-b716-f0f6f519cdc9','{}','null',NULL,4,'[]','[]',NULL,NULL,4,NULL,'c3c868ba-7067-4d77-b716-f0f6f519cdc9',3,NULL),(5,'62cce240-fbae-4692-9015-945cf8b7878b','api-26724205-rsrcstack-test-nex3vzrmzysa','test','2026-02-19 09:29:16',NULL,'CREATE','COMPLETE','state changed','6260f36c-df83-4820-8dd8-9cd9f6faa520','{}','null',NULL,2,'[]','[]',NULL,NULL,6,NULL,'6260f36c-df83-4820-8dd8-9cd9f6faa520',5,NULL),(6,'62d3b8c3-824b-4080-99e7-7a215a971eb1','api-75184910-stack-test-baecjnrnhogd','test','2026-02-19 09:29:23','2026-02-19 09:29:30','UPDATE','COMPLETE','state changed','1eb57bcc-a4df-4905-aaa6-fb07c28c4592','{}','null',NULL,6,'[]','[]',NULL,NULL,25,NULL,'1eb57bcc-a4df-4905-aaa6-fb07c28c4592',16,NULL),(7,'4b9dad33-b2aa-4dd8-8499-db9f058af2f8','api-743921893-stack-test-3wfsvjfz3ljt','test','2026-02-19 09:29:24','2026-02-19 09:29:31','UPDATE','COMPLETE','state changed','b746c133-ba4f-462f-804e-68f51e22d638','{}','null',NULL,6,'[]','[]',NULL,NULL,27,NULL,'b746c133-ba4f-462f-804e-68f51e22d638',18,NULL),(8,'9705aa29-ac68-42b3-9060-595d6bcaaaef','api-1206788375-stack-test-fm5mnclqlkrj','test','2026-02-19 09:29:25','2026-02-19 09:29:27','UPDATE','COMPLETE','state changed','0cb91895-818b-45ce-96f9-becf071cce9e','{}','null',NULL,4,'[]','[]',NULL,NULL,20,NULL,'0cb91895-818b-45ce-96f9-becf071cce9e',10,NULL);
/*!40000 ALTER TABLE `resource` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_data`
--

DROP TABLE IF EXISTS `resource_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  `redact` tinyint(1) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `resource_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_resource_id` (`resource_id`),
  CONSTRAINT `fk_resource_id` FOREIGN KEY (`resource_id`) REFERENCES `resource` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=206 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_data`
--

LOCK TABLES `resource_data` WRITE;
/*!40000 ALTER TABLE `resource_data` DISABLE KEYS */;
INSERT INTO `resource_data` (`id`, `created_at`, `updated_at`, `key`, `value`, `redact`, `decrypt_method`, `resource_id`) VALUES (1,'2026-02-19 09:29:11',NULL,'value','test',0,'',2),(3,'2026-02-19 09:29:12',NULL,'value','test',0,'',3),(5,'2026-02-19 09:29:16',NULL,'value','test',0,'',5),(6,'2026-02-19 09:29:24','2026-02-19 09:29:30','value','new_patched_value',0,'',6),(7,'2026-02-19 09:29:25','2026-02-19 09:29:31','value','new_patched_value',0,'',7),(8,'2026-02-19 09:29:25','2026-02-19 09:29:27','value','new_value',0,'',8);
/*!40000 ALTER TABLE `resource_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_properties_data`
--

DROP TABLE IF EXISTS `resource_properties_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_properties_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `data` longtext DEFAULT NULL,
  `encrypted` tinyint(1) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=252 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_properties_data`
--

LOCK TABLES `resource_properties_data` WRITE;
/*!40000 ALTER TABLE `resource_properties_data` DISABLE KEYS */;
INSERT INTO `resource_properties_data` (`id`, `data`, `encrypted`, `created_at`, `updated_at`) VALUES (1,'{\"value\": \"test\"}',0,'2026-02-19 09:29:11',NULL),(2,'{\"value\": \"test\"}',0,'2026-02-19 09:29:11',NULL),(3,'{\"value\": \"test\"}',0,'2026-02-19 09:29:12',NULL),(4,'{\"value\": \"test\"}',0,'2026-02-19 09:29:12',NULL),(5,'{\"value\": \"test\"}',0,'2026-02-19 09:29:16',NULL),(6,'{\"value\": \"value\"}',0,'2026-02-19 09:29:23',NULL),(7,'{\"value\": \"value\"}',0,'2026-02-19 09:29:25',NULL),(8,'{\"value\": \"value\"}',0,'2026-02-19 09:29:25',NULL),(9,'{\"value\": \"value\"}',0,'2026-02-19 09:29:26',NULL),(10,'{\"value\": \"new_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2026-02-19 09:29:29',NULL),(11,'{\"value\": \"new_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2026-02-19 09:29:29',NULL),(12,'{\"value\": \"new_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2026-02-19 09:29:30',NULL),(13,'{\"value\": \"new_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2026-02-19 09:29:30',NULL),(14,'{\"name\": \"the_net\"}',0,'2026-02-19 09:29:30',NULL),(15,'{\"name\": \"the_subnet\", \"network\": \"d3f8ccb8-f74e-4410-a98b-73844ec2995e\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-02-19 09:29:31',NULL),(16,'{\"value\": \"new_patched_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2026-02-19 09:29:32',NULL),(17,'{\"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\", \"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"networks\": [{\"subnet\": \"00944fb3-2710-426f-962d-ed30f172bd99\"}]}',0,'2026-02-19 09:29:33',NULL),(18,'{\"value\": \"new_patched_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2026-02-19 09:29:34',NULL),(19,'{\"value\": \"new_patched_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2026-02-19 09:29:34',NULL),(20,'{\"enable_dhcp\": false, \"network\": \"81e1a5bf-3dd5-4196-86b5-292648833de3\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-02-19 09:29:37',NULL),(21,'{\"network\": \"81e1a5bf-3dd5-4196-86b5-292648833de3\", \"mac_address\": \"00-00-00-00-BB-BB\", \"fixed_ips\": [{\"subnet\": \"68e07baf-abba-423e-81ec-e6abc340063a\", \"ip_address\": \"11.11.11.11\"}]}',0,'2026-02-19 09:29:39',NULL),(22,'{\"network\": \"4c4d2f91-9773-46c2-8d97-a1ff70ef2f15\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-02-19 09:29:40',NULL),(24,'{\"value\": \"Test1\", \"fail\": false}',0,'2026-02-19 09:29:40',NULL),(25,'{\"cidr\": \"10.10.0.0/16\", \"network\": \"27a83bad-7b1d-42e7-8293-8aa2d626005a\"}',0,'2026-02-19 09:29:41',NULL),(26,'{\"cidr\": \"10.0.0.0/16\", \"network\": \"2dc13a72-f737-4eda-8ed1-9318c31a4c9c\"}',0,'2026-02-19 09:29:42',NULL),(27,'{\"name\": \"trunk_sub_port_one\", \"network\": \"27a83bad-7b1d-42e7-8293-8aa2d626005a\"}',0,'2026-02-19 09:29:43',NULL),(28,'{\"name\": \"trunk_parent_port\", \"network\": \"2dc13a72-f737-4eda-8ed1-9318c31a4c9c\"}',0,'2026-02-19 09:29:44',NULL),(29,'{\"cidr\": \"10.20.0.0/16\", \"network\": \"83284dc4-f44e-45fc-a382-31f09eae6bf9\"}',0,'2026-02-19 09:29:44',NULL),(31,'{\"name\": \"test_trunk\", \"port\": \"dc937771-300b-41e7-b3af-c8c5c9d34017\", \"sub_ports\": [{\"port\": \"51d34fe4-6477-46c0-9a29-9abdd8d0ec4d\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2026-02-19 09:29:46',NULL),(32,'{\"network\": \"4c4d2f91-9773-46c2-8d97-a1ff70ef2f15\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.100\"}]}',0,'2026-02-19 09:29:46',NULL),(33,'{\"name\": \"trunk_sub_port_two\", \"network\": \"83284dc4-f44e-45fc-a382-31f09eae6bf9\"}',0,'2026-02-19 09:29:46',NULL),(34,'{\"network\": \"81e1a5bf-3dd5-4196-86b5-292648833de3\", \"mac_address\": \"00-00-00-00-BB-BB\", \"fixed_ips\": [{\"subnet\": \"68e07baf-abba-423e-81ec-e6abc340063a\"}]}',0,'2026-02-19 09:29:48',NULL),(37,'{\"name\": \"test_trunk\", \"port\": \"dc937771-300b-41e7-b3af-c8c5c9d34017\", \"sub_ports\": [{\"port\": \"51d34fe4-6477-46c0-9a29-9abdd8d0ec4d\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}, {\"port\": \"f3c7254d-e8e9-4043-a418-f65f05656c4c\", \"segmentation_id\": 20, \"segmentation_type\": \"vlan\"}]}',0,'2026-02-19 09:29:57',NULL),(39,'{\"network\": \"33be70f0-a0e4-4678-b8af-adf133da5c1f\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-02-19 09:29:59',NULL),(40,'{\"enable_dhcp\": false, \"network\": \"bd35c0c6-dcef-4d81-8855-f3c6a95fba02\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-02-19 09:29:59',NULL),(42,'{\"network\": \"bd35c0c6-dcef-4d81-8855-f3c6a95fba02\", \"mac_address\": \"00-00-00-00-BB-BB\", \"fixed_ips\": [{\"subnet\": \"f4d6ce03-c68e-4384-8054-fddbc8dfe92b\", \"ip_address\": \"11.11.11.11\"}]}',0,'2026-02-19 09:30:01',NULL),(44,'{\"value\": \"Test1\", \"fail\": false}',0,'2026-02-19 09:30:03',NULL),(45,'{\"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\", \"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"networks\": [{\"network\": \"d3f8ccb8-f74e-4410-a98b-73844ec2995e\", \"subnet\": \"00944fb3-2710-426f-962d-ed30f172bd99\"}]}',0,'2026-02-19 09:30:05',NULL),(47,'{\"network\": \"33be70f0-a0e4-4678-b8af-adf133da5c1f\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": []}',0,'2026-02-19 09:30:08',NULL),(49,'{\"network\": \"bd35c0c6-dcef-4d81-8855-f3c6a95fba02\", \"mac_address\": \"00-00-00-00-AA-AA\", \"fixed_ips\": [{\"subnet\": \"f4d6ce03-c68e-4384-8054-fddbc8dfe92b\", \"ip_address\": \"11.11.11.11\"}]}',0,'2026-02-19 09:30:09',NULL),(52,'{\"network\": \"7d5a5c8c-ab95-4edc-ad95-178c4ccba055\", \"cidr\": \"10.0.0.0/16\"}',0,'2026-02-19 09:30:13',NULL),(53,'{\"network\": \"56f89fc5-e9f8-411e-994b-caf3914c479b\", \"cidr\": \"10.20.0.0/16\"}',0,'2026-02-19 09:30:14',NULL),(54,'{\"network\": \"7d5a5c8c-ab95-4edc-ad95-178c4ccba055\", \"name\": \"trunk_parent_port\"}',0,'2026-02-19 09:30:15',NULL),(55,'{\"network\": \"5d36cec2-1bb6-476b-866a-cf484e50a4b8\", \"cidr\": \"10.10.0.0/16\"}',0,'2026-02-19 09:30:15',NULL),(56,'{\"network\": \"56f89fc5-e9f8-411e-994b-caf3914c479b\", \"name\": \"trunk_sub_port_two\"}',0,'2026-02-19 09:30:16',NULL),(57,'{\"name\": \"test_trunk\", \"port\": \"3dcbf980-d272-47a6-8703-d7210965e20b\", \"sub_ports\": null}',0,'2026-02-19 09:30:17',NULL),(58,'{\"network\": \"5d36cec2-1bb6-476b-866a-cf484e50a4b8\", \"name\": \"trunk_sub_port_one\"}',0,'2026-02-19 09:30:17',NULL),(59,'{\"network\": \"a05b7cab-039e-4a1d-a5f4-bcc927c0d924\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-02-19 09:30:19',NULL),(60,'{\"name\": \"the_net\"}',0,'2026-02-19 09:30:21',NULL),(61,'{\"name\": \"the_subnet\", \"network\": \"6b6fc2f7-d426-4acf-8b1f-e10c1ee0bd83\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-02-19 09:30:22',NULL),(63,'{\"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\", \"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"networks\": [{\"network\": \"6b6fc2f7-d426-4acf-8b1f-e10c1ee0bd83\"}]}',0,'2026-02-19 09:30:26',NULL),(64,'{\"network\": \"a05b7cab-039e-4a1d-a5f4-bcc927c0d924\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.9\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-02-19 09:30:27',NULL),(65,'{\"name\": \"test_trunk\", \"port\": \"3dcbf980-d272-47a6-8703-d7210965e20b\", \"sub_ports\": [{\"port\": \"b342f1dd-6d64-4a86-b111-773b296bc979\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2026-02-19 09:30:27',NULL),(66,'{\"name\": \"server_with_port_net\"}',0,'2026-02-19 09:30:28',NULL),(67,'{\"network\": \"d3965991-db72-4e1f-85ce-4cc5d54834de\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-02-19 09:30:29',NULL),(70,'{\"network\": \"d3965991-db72-4e1f-85ce-4cc5d54834de\", \"fixed_ips\": [{\"subnet\": \"d46beca2-89cd-4c69-b425-8c9e2e1bbb9e\", \"ip_address\": \"11.11.11.11\"}]}',0,'2026-02-19 09:30:33',NULL),(71,'{\"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\", \"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"networks\": [{\"port\": \"4ee2933f-0452-4250-bee4-97ced09c50f1\"}]}',0,'2026-02-19 09:30:36',NULL),(72,'{\"network\": \"c7cd1c81-f22a-4851-9190-e037e1e65f02\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-02-19 09:30:40',NULL),(74,'{\"cidr\": \"10.10.0.0/16\", \"network\": \"9a972901-c4f8-41ab-a469-6a773d4526d1\"}',0,'2026-02-19 09:30:43',NULL),(75,'{\"cidr\": \"10.0.0.0/16\", \"network\": \"6e7555c5-4cd8-4bf3-81cd-7e064d90ce10\"}',0,'2026-02-19 09:30:44',NULL),(77,'{\"network\": \"c7cd1c81-f22a-4851-9190-e037e1e65f02\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": null, \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-02-19 09:30:45',NULL),(78,'{\"name\": \"trunk_sub_port_one\", \"network\": \"9a972901-c4f8-41ab-a469-6a773d4526d1\"}',0,'2026-02-19 09:30:45',NULL),(79,'{\"cidr\": \"10.20.0.0/16\", \"network\": \"54ca7c22-baf7-45c7-bc91-8b7d6b51a77f\"}',0,'2026-02-19 09:30:46',NULL),(80,'{\"name\": \"trunk_parent_port\", \"network\": \"6e7555c5-4cd8-4bf3-81cd-7e064d90ce10\"}',0,'2026-02-19 09:30:46',NULL),(81,'{\"name\": \"trunk_sub_port_two\", \"network\": \"54ca7c22-baf7-45c7-bc91-8b7d6b51a77f\"}',0,'2026-02-19 09:30:47',NULL),(82,'{\"name\": \"test_trunk\", \"port\": \"dbe99737-74ad-43fe-9c19-925a04728f12\", \"sub_ports\": [{\"port\": \"0c0d4a40-f969-4e21-8f7b-a04e0db01748\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2026-02-19 09:30:48',NULL),(84,'{\"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\", \"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"networks\": [{\"network\": \"6b6fc2f7-d426-4acf-8b1f-e10c1ee0bd83\", \"fixed_ip\": \"11.11.11.199\"}]}',0,'2026-02-19 09:30:50',NULL),(86,'{\"network\": \"9f07f690-aeb4-434b-8db3-f6dd3052fb7c\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-02-19 09:31:00',NULL),(87,'{\"name\": \"test_trunk\", \"port\": \"dbe99737-74ad-43fe-9c19-925a04728f12\", \"sub_ports\": []}',0,'2026-02-19 09:31:03',NULL),(90,'{\"network\": \"9f07f690-aeb4-434b-8db3-f6dd3052fb7c\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\"}',0,'2026-02-19 09:31:10',NULL),(91,'{\"name\": \"my_net\"}',0,'2026-02-19 09:31:10',NULL),(92,'{\"name\": \"the_net\"}',0,'2026-02-19 09:31:10',NULL),(93,'{\"name\": \"the_sg\", \"description\": \"Ping and SSH\", \"rules\": [{\"protocol\": \"icmp\"}, {\"protocol\": \"tcp\", \"port_range_min\": 22, \"port_range_max\": 22}]}',0,'2026-02-19 09:31:11',NULL),(94,'{\"network\": \"7bfde64a-56fe-42d9-8513-03e68785e3c3\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-02-19 09:31:12',NULL),(95,'{\"name\": \"the_subnet\", \"network\": \"870477bf-2ce4-4f05-8ece-c8a7ce8af7d5\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-02-19 09:31:12',NULL),(97,'{\"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\", \"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"networks\": [{\"subnet\": \"eb623eec-c298-4cc7-a178-138c3739db1d\", \"fixed_ip\": \"11.11.11.11\"}], \"security_groups\": [\"704c0be3-eae5-4441-8015-21602f90d2ca\"]}',0,'2026-02-19 09:31:16',NULL),(98,'{\"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\", \"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"networks\": [{\"network\": \"870477bf-2ce4-4f05-8ece-c8a7ce8af7d5\"}]}',0,'2026-02-19 09:31:16',NULL),(99,'{\"cidr\": \"10.10.0.0/16\", \"network\": \"c6e30417-9a3a-4c74-a16d-5dd354e75e00\"}',0,'2026-02-19 09:31:22',NULL),(100,'{\"cidr\": \"10.0.0.0/16\", \"network\": \"1ddae126-c1b8-4742-af18-9f351d597fdf\"}',0,'2026-02-19 09:31:23',NULL),(101,'{\"network\": \"4f6f1151-cce4-4948-bcb1-f1ef37798a49\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-02-19 09:31:23',NULL),(102,'{\"cidr\": \"10.20.0.0/16\", \"network\": \"e8debed6-4f2e-4ae4-a6fc-6d4fa63a8fe3\"}',0,'2026-02-19 09:31:24',NULL),(103,'{\"name\": \"trunk_sub_port_one\", \"network\": \"c6e30417-9a3a-4c74-a16d-5dd354e75e00\"}',0,'2026-02-19 09:31:24',NULL),(104,'{\"name\": \"trunk_parent_port\", \"network\": \"1ddae126-c1b8-4742-af18-9f351d597fdf\"}',0,'2026-02-19 09:31:25',NULL),(105,'{\"name\": \"trunk_sub_port_two\", \"network\": \"e8debed6-4f2e-4ae4-a6fc-6d4fa63a8fe3\"}',0,'2026-02-19 09:31:26',NULL),(107,'{\"name\": \"test_trunk\", \"port\": \"c201661c-6cd6-4de3-af15-aaddcd44d6c4\", \"sub_ports\": [{\"port\": \"94f7c2ef-87f9-4778-a307-4c660255a0c0\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}, {\"port\": \"41795aca-0917-46c6-a14e-f2e14e78756b\", \"segmentation_id\": 20, \"segmentation_type\": \"vlan\"}]}',0,'2026-02-19 09:31:27',NULL),(108,'{\"network\": \"4f6f1151-cce4-4948-bcb1-f1ef37798a49\", \"cidr\": \"11.11.11.0/24\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-02-19 09:31:28',NULL),(112,'{\"name\": \"my_encrypted_foo\", \"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\", \"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"networks\": [{\"network\": \"heat_tempestconf_network\"}]}',0,'2026-02-19 09:31:38',NULL),(113,'{\"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\", \"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"networks\": [{\"network\": \"870477bf-2ce4-4f05-8ece-c8a7ce8af7d5\", \"subnet\": \"7ad77ec4-1ef2-4641-aaf0-abe5d4b155f2\"}]}',0,'2026-02-19 09:31:38',NULL),(114,'{\"name\": \"test_trunk\", \"port\": \"c201661c-6cd6-4de3-af15-aaddcd44d6c4\", \"sub_ports\": [{\"port\": \"94f7c2ef-87f9-4778-a307-4c660255a0c0\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2026-02-19 09:31:39',NULL),(117,'{\"name\": \"the_net\"}',0,'2026-02-19 09:31:46',NULL),(118,'{\"network\": \"142e7724-18ff-41de-99db-8890fdaf3355\", \"cidr\": \"11.11.11.0/24\", \"name\": \"subnet_a\"}',0,'2026-02-19 09:31:47',NULL),(119,'{\"network\": \"142e7724-18ff-41de-99db-8890fdaf3355\", \"cidr\": \"12.12.12.0/24\", \"name\": \"subnet_b\"}',0,'2026-02-19 09:31:47',NULL),(120,'{\"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\", \"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"networks\": [{\"subnet\": \"e70d6dec-9961-430e-a1dd-4042133c661a\"}]}',0,'2026-02-19 09:31:50',NULL),(121,'{\"name\": \"the_net\"}',0,'2026-02-19 09:31:54',NULL),(122,'{\"name\": \"the_subnet\", \"network\": \"2c14d05b-1d30-4166-84b9-d2eaeb7b7f74\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-02-19 09:31:55',NULL),(123,'{\"cidr\": \"10.20.0.0/16\", \"network\": \"8278727d-06ae-4cb2-b7c6-c6215bd7a092\"}',0,'2026-02-19 09:31:55',NULL),(124,'{\"cidr\": \"10.10.0.0/16\", \"network\": \"aee25574-65a9-414a-a811-de7c4b4f23a7\"}',0,'2026-02-19 09:31:57',NULL),(125,'{\"cidr\": \"10.0.0.0/16\", \"network\": \"aae99c7f-c152-44ab-a24d-6d9a6bd00941\"}',0,'2026-02-19 09:31:57',NULL),(126,'{\"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\", \"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"networks\": [{\"network\": \"2c14d05b-1d30-4166-84b9-d2eaeb7b7f74\"}, {\"network\": \"2c14d05b-1d30-4166-84b9-d2eaeb7b7f74\", \"fixed_ip\": \"11.11.11.33\"}, {\"subnet\": \"2d98b57b-4341-40ad-8740-02b95084c37f\"}]}',0,'2026-02-19 09:31:57',NULL),(127,'{\"name\": \"trunk_sub_port_two\", \"network\": \"8278727d-06ae-4cb2-b7c6-c6215bd7a092\"}',0,'2026-02-19 09:31:58',NULL),(128,'{\"name\": \"LUKS\"}',0,'2026-02-19 09:31:58',NULL),(129,'{\"provider\": \"nova.volume.encryptors.luks.LuksEncryptor\", \"control_location\": \"front-end\", \"cipher\": \"aes-xts-plain64\", \"key_size\": 512, \"volume_type\": \"1bf13480-93e7-4814-98c8-24eccb55c1b8\"}',0,'2026-02-19 09:31:58',NULL),(130,'{\"name\": \"trunk_sub_port_one\", \"network\": \"aee25574-65a9-414a-a811-de7c4b4f23a7\"}',0,'2026-02-19 09:31:59',NULL),(131,'{\"name\": \"trunk_parent_port\", \"network\": \"aae99c7f-c152-44ab-a24d-6d9a6bd00941\"}',0,'2026-02-19 09:32:00',NULL),(132,'{\"name\": \"test_trunk\", \"port\": \"ed50e680-fefb-400f-97d8-aa104c7582c7\", \"sub_ports\": [{\"port\": \"32215bec-6ee2-4f88-948a-b268899ad4cd\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2026-02-19 09:32:03',NULL),(133,'{\"provider\": \"nova.volume.encryptors.luks.LuksEncryptor\", \"control_location\": \"front-end\", \"cipher\": \"aes-cbc-essiv\", \"key_size\": 256, \"volume_type\": \"1bf13480-93e7-4814-98c8-24eccb55c1b8\"}',0,'2026-02-19 09:32:10',NULL),(135,'{\"name\": \"test_trunk\", \"port\": \"ed50e680-fefb-400f-97d8-aa104c7582c7\", \"sub_ports\": [{\"port\": \"32215bec-6ee2-4f88-948a-b268899ad4cd\", \"segmentation_id\": 99, \"segmentation_type\": \"vlan\"}]}',0,'2026-02-19 09:32:27',NULL),(137,'{\"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\", \"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"networks\": [{\"subnet\": \"89393055-b1c3-4676-8038-3fa35e005d6d\"}]}',0,'2026-02-19 09:32:41',NULL),(140,'{\"network\": \"29978b17-0ee6-40d5-9957-2718ac3d637e\", \"cidr\": \"10.20.0.0/16\"}',0,'2026-02-19 09:32:45',NULL),(141,'{\"network\": \"6a112068-5b31-4c27-8155-1e2cba5bf681\", \"cidr\": \"10.10.0.0/16\"}',0,'2026-02-19 09:32:47',NULL),(142,'{\"network\": \"69f27366-3e75-4fa2-ae6c-b4eee1ae97db\", \"cidr\": \"10.0.0.0/16\"}',0,'2026-02-19 09:32:47',NULL),(143,'{\"network\": \"29978b17-0ee6-40d5-9957-2718ac3d637e\", \"name\": \"trunk_sub_port_two\"}',0,'2026-02-19 09:32:50',NULL),(144,'{\"network\": \"6a112068-5b31-4c27-8155-1e2cba5bf681\", \"name\": \"trunk_sub_port_one\"}',0,'2026-02-19 09:32:50',NULL),(145,'{\"network\": \"69f27366-3e75-4fa2-ae6c-b4eee1ae97db\", \"name\": \"trunk_parent_port\"}',0,'2026-02-19 09:32:50',NULL),(146,'{\"name\": \"test_trunk\", \"port\": \"daa9ab07-668f-4041-936c-fba01d6f012a\", \"sub_ports\": null}',0,'2026-02-19 09:32:52',NULL),(147,'{\"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\", \"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"networks\": [{\"subnet\": \"2d98b57b-4341-40ad-8740-02b95084c37f\"}, {\"network\": \"2c14d05b-1d30-4166-84b9-d2eaeb7b7f74\"}, {\"network\": \"2c14d05b-1d30-4166-84b9-d2eaeb7b7f74\", \"subnet\": \"2d98b57b-4341-40ad-8740-02b95084c37f\"}]}',0,'2026-02-19 09:32:52',NULL),(148,'{\"value\": \"Test1\"}',0,'2026-02-19 09:32:55',NULL),(149,'{\"value\": \"Test2\"}',0,'2026-02-19 09:32:55',NULL),(151,'{\"value\": \"Test1\"}',0,'2026-02-19 09:33:02',NULL),(152,'{\"value\": \"Test2\"}',0,'2026-02-19 09:33:02',NULL),(153,'{\"description\": \"This is a test trunk\", \"name\": \"pineapple\", \"port\": \"daa9ab07-668f-4041-936c-fba01d6f012a\", \"sub_ports\": null}',0,'2026-02-19 09:33:02',NULL),(155,'{\"context\": {\"region_name\": \"regionOne\"}, \"template\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}',0,'2026-02-19 09:33:11',NULL),(156,'{\"value\": \"a\"}',0,'2026-02-19 09:33:14',NULL),(157,'{\"value\": \"b\"}',0,'2026-02-19 09:33:16',NULL),(159,'{\"name\": \"the_net\"}',0,'2026-02-19 09:33:19',NULL),(160,'{\"name\": \"the_subnet\", \"network\": \"47628df4-6d10-4d31-b75f-72945071e617\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-02-19 09:33:22',NULL),(161,'{\"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\", \"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"networks\": [{\"network\": \"47628df4-6d10-4d31-b75f-72945071e617\"}]}',0,'2026-02-19 09:33:23',NULL),(163,'{\"context\": {\"region_name\": \"regionOne\"}, \"template\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}',0,'2026-02-19 09:33:28',NULL),(164,'{\"value\": \"b\"}',0,'2026-02-19 09:33:31',NULL),(165,'{\"value\": \"a\"}',0,'2026-02-19 09:33:32',NULL),(167,'{\"value\": \"foo\"}',0,'2026-02-19 09:33:50',NULL),(168,'{\"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\", \"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"networks\": [{\"port\": \"e4783493-3f82-465c-b9c2-5f464772b801\"}]}',0,'2026-02-19 09:33:53',NULL),(169,'{\"value\": \"foo\"}',0,'2026-02-19 09:33:56',NULL),(170,'{\"context\": {\"region_name\": \"regionOne\"}, \"template\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}',0,'2026-02-19 09:33:57',NULL),(172,'{\"length\": 10}',0,'2026-02-19 09:34:07',NULL),(173,'{\"context\": {\"region_name\": \"regionOne\"}, \"template\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random2:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random2, value]}\\n\"}',0,'2026-02-19 09:34:09',NULL),(174,'{\"name\": \"the_net\"}',0,'2026-02-19 09:34:10',NULL),(175,'{\"name\": \"the_subnet\", \"network\": \"c43bbf59-e369-449b-91c1-cae55365c3db\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-02-19 09:34:12',NULL),(176,'{\"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\", \"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"networks\": [{\"network\": \"c43bbf59-e369-449b-91c1-cae55365c3db\"}]}',0,'2026-02-19 09:34:14',NULL),(177,'{\"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\", \"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"user_data_format\": \"SOFTWARE_CONFIG\", \"networks\": [{\"network\": \"heat_tempestconf_network\"}]}',0,'2026-02-19 09:34:21',NULL),(178,'{\"count\": 1, \"resource_def\": {\"type\": \"OS::Heat::RandomString\"}}',0,'2026-02-19 09:34:26',NULL),(180,'{\"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\", \"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"networks\": [{\"subnet\": \"89bf4205-a158-4d44-ad82-5da52b19d23b\"}]}',0,'2026-02-19 09:34:34',NULL),(181,'{\"count\": 2, \"resource_def\": {\"type\": \"OS::Heat::RandomString\"}}',0,'2026-02-19 09:34:35',NULL),(183,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2026-02-19 09:34:40',NULL),(184,'{\"config\": \"d9922bcf-9430-4ec8-9d5b-3a0b446f5d4d\", \"servers\": {\"0\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}}',0,'2026-02-19 09:34:40',NULL),(185,'{\"config\": \"d9922bcf-9430-4ec8-9d5b-3a0b446f5d4d\", \"servers\": {\"0\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}}',0,'2026-02-19 09:34:40',NULL),(186,'{\"config\": \"d9922bcf-9430-4ec8-9d5b-3a0b446f5d4d\", \"servers\": {\"0\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}}',0,'2026-02-19 09:34:40',NULL),(187,'{\"config\": \"d9922bcf-9430-4ec8-9d5b-3a0b446f5d4d\", \"servers\": {\"0\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}}',0,'2026-02-19 09:34:40',NULL),(188,'{\"config\": \"d9922bcf-9430-4ec8-9d5b-3a0b446f5d4d\", \"servers\": {\"0\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}}',0,'2026-02-19 09:34:40',NULL),(189,'{\"config\": \"d9922bcf-9430-4ec8-9d5b-3a0b446f5d4d\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"HEAT_SIGNAL\", \"server\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}',0,'2026-02-19 09:34:40',NULL),(190,'{\"config\": \"d9922bcf-9430-4ec8-9d5b-3a0b446f5d4d\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"HEAT_SIGNAL\", \"server\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}',0,'2026-02-19 09:34:40',NULL),(191,'{\"config\": \"d9922bcf-9430-4ec8-9d5b-3a0b446f5d4d\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"HEAT_SIGNAL\", \"server\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}',0,'2026-02-19 09:34:40',NULL),(192,'{\"config\": \"d9922bcf-9430-4ec8-9d5b-3a0b446f5d4d\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"HEAT_SIGNAL\", \"server\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}',0,'2026-02-19 09:34:40',NULL),(193,'{\"config\": \"d9922bcf-9430-4ec8-9d5b-3a0b446f5d4d\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"HEAT_SIGNAL\", \"server\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}',0,'2026-02-19 09:34:40',NULL),(194,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2026-02-19 09:34:42',NULL),(195,'{\"config\": \"a657aaa3-d0f7-4a4b-81b9-1b11d719c06c\", \"servers\": {\"0\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}}',0,'2026-02-19 09:34:42',NULL),(196,'{\"config\": \"a657aaa3-d0f7-4a4b-81b9-1b11d719c06c\", \"servers\": {\"0\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}}',0,'2026-02-19 09:34:42',NULL),(197,'{\"config\": \"a657aaa3-d0f7-4a4b-81b9-1b11d719c06c\", \"servers\": {\"0\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}}',0,'2026-02-19 09:34:42',NULL),(198,'{\"config\": \"a657aaa3-d0f7-4a4b-81b9-1b11d719c06c\", \"servers\": {\"0\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}}',0,'2026-02-19 09:34:42',NULL),(199,'{\"config\": \"a657aaa3-d0f7-4a4b-81b9-1b11d719c06c\", \"servers\": {\"0\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}}',0,'2026-02-19 09:34:42',NULL),(200,'{\"config\": \"a657aaa3-d0f7-4a4b-81b9-1b11d719c06c\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"HEAT_SIGNAL\", \"server\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}',0,'2026-02-19 09:34:42',NULL),(201,'{\"config\": \"a657aaa3-d0f7-4a4b-81b9-1b11d719c06c\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"HEAT_SIGNAL\", \"server\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}',0,'2026-02-19 09:34:42',NULL),(202,'{\"config\": \"a657aaa3-d0f7-4a4b-81b9-1b11d719c06c\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"HEAT_SIGNAL\", \"server\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}',0,'2026-02-19 09:34:42',NULL),(203,'{\"config\": \"a657aaa3-d0f7-4a4b-81b9-1b11d719c06c\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"HEAT_SIGNAL\", \"server\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}',0,'2026-02-19 09:34:43',NULL),(204,'{\"config\": \"a657aaa3-d0f7-4a4b-81b9-1b11d719c06c\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"HEAT_SIGNAL\", \"server\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}',0,'2026-02-19 09:34:43',NULL),(205,'{\"name\": \"the_net\"}',0,'2026-02-19 09:34:46',NULL),(206,'{\"name\": \"the_subnet\", \"network\": \"19805626-6f29-4186-83ca-8b5a4f3c5a73\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-02-19 09:34:50',NULL),(207,'{\"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\", \"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"networks\": [{\"subnet\": \"73f8bb89-d1dc-4554-940b-631d92cb5128\"}]}',0,'2026-02-19 09:34:53',NULL),(208,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2026-02-19 09:34:54',NULL),(209,'{\"config\": \"89191f4e-ce86-45da-b669-c08cce44cee8\", \"servers\": {\"0\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}}',0,'2026-02-19 09:34:54',NULL),(210,'{\"config\": \"89191f4e-ce86-45da-b669-c08cce44cee8\", \"servers\": {\"0\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}}',0,'2026-02-19 09:34:54',NULL),(211,'{\"config\": \"89191f4e-ce86-45da-b669-c08cce44cee8\", \"servers\": {\"0\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}}',0,'2026-02-19 09:34:54',NULL),(212,'{\"config\": \"89191f4e-ce86-45da-b669-c08cce44cee8\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"HEAT_SIGNAL\", \"server\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}',0,'2026-02-19 09:34:54',NULL),(213,'{\"config\": \"89191f4e-ce86-45da-b669-c08cce44cee8\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"HEAT_SIGNAL\", \"server\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}',0,'2026-02-19 09:34:54',NULL),(214,'{\"config\": \"89191f4e-ce86-45da-b669-c08cce44cee8\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"HEAT_SIGNAL\", \"server\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}',0,'2026-02-19 09:34:54',NULL),(215,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2026-02-19 09:34:55',NULL),(216,'{\"config\": \"843caaf1-a1b1-4ff8-b665-996aacf85dce\", \"servers\": {\"0\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}}',0,'2026-02-19 09:34:56',NULL),(217,'{\"config\": \"843caaf1-a1b1-4ff8-b665-996aacf85dce\", \"servers\": {\"0\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}}',0,'2026-02-19 09:34:56',NULL),(218,'{\"config\": \"843caaf1-a1b1-4ff8-b665-996aacf85dce\", \"servers\": {\"0\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}}',0,'2026-02-19 09:34:56',NULL),(219,'{\"config\": \"843caaf1-a1b1-4ff8-b665-996aacf85dce\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"HEAT_SIGNAL\", \"server\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}',0,'2026-02-19 09:34:56',NULL),(220,'{\"config\": \"843caaf1-a1b1-4ff8-b665-996aacf85dce\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"HEAT_SIGNAL\", \"server\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}',0,'2026-02-19 09:34:56',NULL),(221,'{\"config\": \"843caaf1-a1b1-4ff8-b665-996aacf85dce\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"HEAT_SIGNAL\", \"server\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}',0,'2026-02-19 09:34:56',NULL),(222,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2026-02-19 09:34:58',NULL),(223,'{\"config\": \"2981258c-dfb0-42bf-8160-f414567f8986\", \"servers\": {\"0\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}}',0,'2026-02-19 09:34:58',NULL),(224,'{\"config\": \"2981258c-dfb0-42bf-8160-f414567f8986\", \"servers\": {\"0\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}}',0,'2026-02-19 09:34:58',NULL),(225,'{\"config\": \"2981258c-dfb0-42bf-8160-f414567f8986\", \"servers\": {\"0\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}}',0,'2026-02-19 09:34:58',NULL),(226,'{\"config\": \"2981258c-dfb0-42bf-8160-f414567f8986\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"HEAT_SIGNAL\", \"server\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}',0,'2026-02-19 09:35:01',NULL),(227,'{\"config\": \"2981258c-dfb0-42bf-8160-f414567f8986\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"HEAT_SIGNAL\", \"server\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}',0,'2026-02-19 09:35:01',NULL),(228,'{\"config\": \"2981258c-dfb0-42bf-8160-f414567f8986\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"HEAT_SIGNAL\", \"server\": \"79f5e76f-7099-456a-a2e9-cf91dd45d6d8\"}',0,'2026-02-19 09:35:01',NULL),(230,'{\"length\": 10}',0,'2026-02-19 09:35:23',NULL),(231,'{\"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\", \"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"networks\": [{\"network\": \"19805626-6f29-4186-83ca-8b5a4f3c5a73\"}]}',0,'2026-02-19 09:35:25',NULL),(233,'{\"value\": \"test1\", \"fail\": false, \"update_replace\": false, \"wait_secs\": 0}',0,'2026-02-19 09:35:35',NULL),(234,'{\"wait_secs\": 1, \"value\": \"test\"}',0,'2026-02-19 09:35:44',NULL),(235,'{\"wait_secs\": 1, \"value\": \"test\"}',0,'2026-02-19 09:35:57',NULL),(236,'{\"wait_secs\": 1, \"value\": \"next\"}',0,'2026-02-19 09:36:05',NULL),(237,'{\"wait_secs\": 1, \"value\": \"none\"}',0,'2026-02-19 09:36:14',NULL),(238,'{\"update_replace\": false, \"wait_secs\": 0, \"value\": \"Test1\", \"fail\": false}',0,'2026-02-19 09:36:29',NULL),(239,'{\"context\": {\"region_name\": \"regionOne\"}, \"parameters\": {\"name\": \"remote-nested\", \"network_name\": \"public\"}, \"template\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The intermediate stack (containing a local nested stack) to be instantiated\\\\nremotely in the remote deeply-nested stack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The public network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"network_stack_as_custom_type\\\": {\\\"type\\\": \\\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\\\", \\\"properties\\\": {\\\"name\\\": {\\\"get_param\\\": \\\"name\\\"}, \\\"network_name\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_attr\\\": [\\\"network_stack_as_custom_type\\\", \\\"router\\\"]}}}}\"}',0,'2026-02-19 09:36:44',NULL),(240,'{\"name\": \"remote-nested\", \"network_name\": \"public\"}',0,'2026-02-19 09:36:46',NULL),(241,'{\"name\": \"remote-nested-router\", \"external_gateway_info\": {\"network\": \"public\"}}',0,'2026-02-19 09:36:46',NULL),(244,'{\"image\": \"68031c1f-102f-4c4c-96de-759cddbda0a0\", \"flavor\": \"b720c72a-35cc-4b07-9a05-26b6287c0f45\", \"user_data_format\": \"SOFTWARE_CONFIG\", \"networks\": [{\"network\": \"heat_tempestconf_network\"}]}',0,'2026-02-19 09:37:13',NULL),(245,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2026-02-19 09:37:33',NULL),(246,'{\"config\": \"dfc6b4a2-6363-463e-b577-57f7bafde91d\", \"servers\": {\"0\": \"bae50c94-735e-4a77-9dda-720a67eccc04\"}}',0,'2026-02-19 09:37:33',NULL),(247,'{\"config\": \"dfc6b4a2-6363-463e-b577-57f7bafde91d\", \"servers\": {\"0\": \"bae50c94-735e-4a77-9dda-720a67eccc04\"}}',0,'2026-02-19 09:37:33',NULL),(248,'{\"config\": \"dfc6b4a2-6363-463e-b577-57f7bafde91d\", \"servers\": {\"0\": \"bae50c94-735e-4a77-9dda-720a67eccc04\"}}',0,'2026-02-19 09:37:33',NULL),(249,'{\"config\": \"dfc6b4a2-6363-463e-b577-57f7bafde91d\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"HEAT_SIGNAL\", \"server\": \"bae50c94-735e-4a77-9dda-720a67eccc04\"}',0,'2026-02-19 09:37:34',NULL),(250,'{\"config\": \"dfc6b4a2-6363-463e-b577-57f7bafde91d\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"HEAT_SIGNAL\", \"server\": \"bae50c94-735e-4a77-9dda-720a67eccc04\"}',0,'2026-02-19 09:37:34',NULL),(251,'{\"config\": \"dfc6b4a2-6363-463e-b577-57f7bafde91d\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"HEAT_SIGNAL\", \"server\": \"bae50c94-735e-4a77-9dda-720a67eccc04\"}',0,'2026-02-19 09:37:34',NULL);
/*!40000 ALTER TABLE `resource_properties_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(36) NOT NULL,
  `engine_id` varchar(36) NOT NULL,
  `host` varchar(255) NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `topic` varchar(255) NOT NULL,
  `report_interval` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `engine_id`, `host`, `hostname`, `binary`, `topic`, `report_interval`, `created_at`, `updated_at`, `deleted_at`) VALUES ('3a5ee13b-d147-496e-8b8c-e534d08ea7b6','133463b9-e776-4e2b-9f6b-450d2593fa06','heat-engine-69f6799bd7-ht4q2','heat-engine-69f6799bd7-ht4q2','heat-engine','engine',60,'2026-02-19 09:03:49','2026-02-19 09:42:50',NULL),('3d5f2c1e-5a6d-4abd-95db-c21069ff9d01','bb185aa7-d271-4819-9d82-0a89acd041d4','heat-engine-69f6799bd7-ht4q2','heat-engine-69f6799bd7-ht4q2','heat-engine','engine',60,'2026-02-19 09:03:49','2026-02-19 09:42:50',NULL),('5a1cce69-d1be-4be6-8ca5-ce1deee6c484','f88f264b-a0cb-4cf0-a86a-3c2188778516','heat-engine-69f6799bd7-ht4q2','heat-engine-69f6799bd7-ht4q2','heat-engine','engine',60,'2026-02-19 09:03:49','2026-02-19 09:42:50',NULL),('b7894da3-05e5-479d-97f6-4d933aa379b1','75d3c57f-d320-4a4a-8cc8-e5dcac02e3a5','heat-engine-5b7d4466df-8w62q','heat-engine-5b7d4466df-8w62q','heat-engine','engine',60,'2026-02-19 09:03:33','2026-02-19 09:04:08','2026-02-19 09:04:08'),('bd6a0421-144c-4512-b9c8-2765ab9a7f40','ac1a4954-49a7-47f7-a64a-1cac5fb20f28','heat-engine-5b7d4466df-8w62q','heat-engine-5b7d4466df-8w62q','heat-engine','engine',60,'2026-02-19 09:03:33','2026-02-19 09:04:08','2026-02-19 09:04:08'),('c5cf0d15-c563-4725-9bd7-a8a150731fad','d9813b20-fa56-4f2e-afef-95278ee75512','heat-engine-69f6799bd7-ht4q2','heat-engine-69f6799bd7-ht4q2','heat-engine','engine',60,'2026-02-19 09:03:49','2026-02-19 09:42:50',NULL),('d7a30b93-aa68-423c-9585-f9f17c999166','d401b63d-bbff-48c7-ae2d-cbb2b95066d0','heat-engine-5b7d4466df-8w62q','heat-engine-5b7d4466df-8w62q','heat-engine','engine',60,'2026-02-19 09:03:33','2026-02-19 09:04:08','2026-02-19 09:04:08'),('e144628f-b52a-49c3-be57-aaeffa960ebf','ac613845-b4d5-4b11-84df-0e45b8517485','heat-engine-5b7d4466df-8w62q','heat-engine-5b7d4466df-8w62q','heat-engine','engine',60,'2026-02-19 09:03:33','2026-02-19 09:04:08','2026-02-19 09:04:08');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot`
--

DROP TABLE IF EXISTS `snapshot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot` (
  `id` varchar(36) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` varchar(255) DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  KEY `ix_snapshot_tenant` (`tenant`),
  CONSTRAINT `snapshot_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot`
--

LOCK TABLES `snapshot` WRITE;
/*!40000 ALTER TABLE `snapshot` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_config`
--

DROP TABLE IF EXISTS `software_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_config` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `group` varchar(255) DEFAULT NULL,
  `config` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_software_config_tenant` (`tenant`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_config`
--

LOCK TABLES `software_config` WRITE;
/*!40000 ALTER TABLE `software_config` DISABLE KEYS */;
INSERT INTO `software_config` (`id`, `created_at`, `updated_at`, `name`, `group`, `config`, `tenant`) VALUES ('09a9ad1a-73d7-4355-9e7d-cb22243887dc','2026-02-19 09:29:17',NULL,'api-75184910-config','script','{\"inputs\": [], \"outputs\": [], \"options\": {}, \"config\": \"#!/bin/sh -x\\\\necho hello\"}','93437950a15445e8843848fe3d1336e9'),('2219852d-1e70-4e37-a489-d48fec6509f9','2026-02-19 09:29:20',NULL,'api-26724205-config','script','{\"inputs\": [], \"outputs\": [], \"options\": {}, \"config\": \"#!/bin/sh -x\\\\necho hello\"}','93437950a15445e8843848fe3d1336e9'),('227ffd29-d076-4998-b89f-942aba86ff22','2026-02-19 09:29:15',NULL,'api-743921893-config','script','{\"inputs\": [], \"outputs\": [], \"options\": {}, \"config\": \"#!/bin/sh -x\\\\necho hello\"}','93437950a15445e8843848fe3d1336e9');
/*!40000 ALTER TABLE `software_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_deployment`
--

DROP TABLE IF EXISTS `software_deployment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_deployment` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `server_id` varchar(36) NOT NULL,
  `config_id` varchar(36) NOT NULL,
  `input_values` longtext DEFAULT NULL,
  `output_values` longtext DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `config_id` (`config_id`),
  KEY `ix_software_deployment_created_at` (`created_at`),
  KEY `ix_software_deployment_tenant` (`tenant`),
  KEY `ix_software_deployment_server_id` (`server_id`),
  CONSTRAINT `software_deployment_ibfk_1` FOREIGN KEY (`config_id`) REFERENCES `software_config` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_deployment`
--

LOCK TABLES `software_deployment` WRITE;
/*!40000 ALTER TABLE `software_deployment` DISABLE KEYS */;
INSERT INTO `software_deployment` (`id`, `created_at`, `updated_at`, `server_id`, `config_id`, `input_values`, `output_values`, `action`, `status`, `status_reason`, `tenant`, `stack_user_project_id`) VALUES ('2db95f96-ebce-4263-a6be-93e6c68c762b','2026-02-19 09:29:18','2026-02-19 09:29:19','dummy_server','09a9ad1a-73d7-4355-9e7d-cb22243887dc','{}','null','ACTION1','COMPLETE','completed','93437950a15445e8843848fe3d1336e9',NULL),('fd748e7e-6085-4f3f-9e56-6cb0595e9d54','2026-02-19 09:29:21','2026-02-19 09:29:21','dummy_server','2219852d-1e70-4e37-a489-d48fec6509f9','{}','null','ACTION1','COMPLETE','completed','93437950a15445e8843848fe3d1336e9',NULL);
/*!40000 ALTER TABLE `software_deployment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack`
--

DROP TABLE IF EXISTS `stack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `raw_template_id` int(11) NOT NULL,
  `prev_raw_template_id` int(11) DEFAULT NULL,
  `user_creds_id` int(11) DEFAULT NULL,
  `username` varchar(256) DEFAULT NULL,
  `owner_id` varchar(36) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `timeout` int(11) DEFAULT NULL,
  `tenant` varchar(256) DEFAULT NULL,
  `disable_rollback` tinyint(1) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  `backup` tinyint(1) DEFAULT NULL,
  `nested_depth` int(11) DEFAULT NULL,
  `convergence` tinyint(1) DEFAULT NULL,
  `current_traversal` varchar(36) DEFAULT NULL,
  `current_deps` longtext DEFAULT NULL,
  `parent_resource_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_template_id` (`raw_template_id`),
  KEY `prev_raw_template_id` (`prev_raw_template_id`),
  KEY `user_creds_id` (`user_creds_id`),
  KEY `ix_stack_owner_id` (`owner_id`),
  KEY `ix_stack_name` (`name`),
  KEY `ix_stack_tenant` (`tenant`(255)),
  CONSTRAINT `stack_ibfk_1` FOREIGN KEY (`raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_2` FOREIGN KEY (`prev_raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_3` FOREIGN KEY (`user_creds_id`) REFERENCES `user_creds` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack`
--

LOCK TABLES `stack` WRITE;
/*!40000 ALTER TABLE `stack` DISABLE KEYS */;
INSERT INTO `stack` (`id`, `created_at`, `updated_at`, `deleted_at`, `name`, `raw_template_id`, `prev_raw_template_id`, `user_creds_id`, `username`, `owner_id`, `action`, `status`, `status_reason`, `timeout`, `tenant`, `disable_rollback`, `stack_user_project_id`, `backup`, `nested_depth`, `convergence`, `current_traversal`, `current_deps`, `parent_resource_name`) VALUES ('04897519-b5d1-418c-bc9f-23e9aa6b1d7b','2026-02-19 09:34:00','2026-02-19 09:34:20','2026-02-19 09:34:21','HooksTest-1281521189',146,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'ead5248fe3ca4c9f95dcad4ab6277756',0,0,1,'c2573edf-f9a1-45dd-b6e1-bfae6c5f0727','{\"edges\": [[[150, false], [149, false]], [[151, false], [150, false]]]}',NULL),('05ac412c-ee47-41e6-93ca-a9f4afdf5119','2026-02-19 09:33:14','2026-02-19 09:33:25','2026-02-19 09:33:26','StackOutputsTest-74234904-parent-tuicwa24b5zf',119,NULL,NULL,'demo_tempestconf','43ef9cc5-bc6f-4c49-babc-34c1c1fc0058','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'a5f12e4d54254596877f89079324f4c3',0,1,1,'be380ac4-edd8-4c0f-b4d3-5039cb3b7718','{\"edges\": [[[129, false], null], [[130, false], null]]}','parent'),('0b006a64-5d9f-44a7-97c2-05d67e7f567a','2026-02-19 09:36:46','2026-02-19 09:36:56','2026-02-19 09:36:58','RemoteDeeplyNestedStackTest-453210323-network_stack-64nqnjbrxece-network_stack_as_custom_type-iuwqg4pynpj4',228,NULL,NULL,'demo_tempestconf','263c66be-8d82-4da8-8c0a-70f4e3744ac2','DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'93437950a15445e8843848fe3d1336e9',1,'748cbc2b930d4c4497d794f7e42cf9c5',0,1,1,'56561520-3be7-4b5e-8ea7-b46d8d49d57f','{\"edges\": [[[220, false], null]]}','network_stack_as_custom_type'),('0b1dfe63-062f-406d-b725-3604ca41ab05','2026-02-19 09:34:40','2026-02-19 09:36:53','2026-02-19 09:36:59','ParallelDeploymentsTest-614175552-dep_2-ul2frflp772c',224,NULL,NULL,'demo_tempestconf','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'126762f8222749628bae104cd11bb1ab',0,1,1,'fbc287c5-d363-471b-8bca-66e84fb0a129','{\"edges\": [[[167, false], null]]}','dep_2'),('0cb91895-818b-45ce-96f9-becf071cce9e','2026-02-19 09:29:25','2026-02-19 09:29:26',NULL,'api-1206788375-stack',20,NULL,12,'demo_tempestconf',NULL,'UPDATE','COMPLETE','Stack UPDATE completed successfully',NULL,'93437950a15445e8843848fe3d1336e9',1,'1d2ada14d79d4762b37fcb533272a8e7',0,0,1,'a0416652-668b-4bf9-ac60-82e13e6f0019','{\"edges\": [[[8, false], [8, true]]]}',NULL),('0ccb8343-ef74-46de-92f4-1c45ee6e8d95','2026-02-19 09:33:32','2026-02-19 09:33:51','2026-02-19 09:33:54','HooksTest-172485013-nested-eskijeswsq5y',131,NULL,NULL,'demo_tempestconf','ddf85b97-ba1f-45cf-b661-2799a3ceda32','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'d6149514b5994bb79b8a26c14d46f702',0,1,1,'8192af8e-acbb-402a-8d66-85c15aa666fe','{\"edges\": [[[143, false], [142, false]], [[144, false], [143, false]]]}','nested'),('12fa5b7d-6b14-45f3-80c6-c4e49206d895','2026-02-19 09:34:10','2026-02-19 09:34:36','2026-02-19 09:34:40','swap_network_subnet',153,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'859c53443b264f45914085ad5fdfcc93',0,0,1,'08d233e3-e107-4c58-a8c9-770d488d917e','{\"edges\": [[[155, false], [154, false]], [[156, false], [155, false]]]}',NULL),('1556fdcf-229b-4746-a5c9-ce25fea87ce2','2026-02-19 09:29:56','2026-02-19 09:30:12','2026-02-19 09:30:15','UpdateSubnetTest-1483220816',45,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'e73c318d73c846d1af2ab55122037830',0,0,1,'396c0a12-8903-47c7-b04c-02b495594d66','{\"edges\": [[[30, false], [29, false]]]}',NULL),('1601fa1c-8507-4fb1-90ce-120226b6b3af','2026-02-19 09:29:29','2026-02-19 09:30:10','2026-02-19 09:30:15','add_network',43,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'26935c0c363443179e033af35551faf5',0,0,1,'3dc057bb-2e92-4981-99b3-d336c98d30fc','{\"edges\": [[[12, false], [10, false]], [[12, false], [11, false]], [[11, false], [10, false]]]}',NULL),('1651c197-0885-4bcd-9f9c-f427f0990477','2026-02-19 09:29:39','2026-02-19 09:29:50','2026-02-19 09:29:53','UpdateSubnetTest-248403187',36,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'329149b21fbc44439530999e4f87705a',0,0,1,'8c00665c-fc8e-4f4b-91b6-a712f7ba872f','{\"edges\": [[[18, false], [17, false]]]}',NULL),('172ec054-588f-4068-8103-446353791256','2026-02-19 09:33:12','2026-02-19 09:33:21','2026-02-19 09:33:22','RemoteStackTest-1611783987-my_stack-bkgc3xi3zp5s',117,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'93437950a15445e8843848fe3d1336e9',1,'b3afbba6b576448fb632431ea2672c36',0,0,1,'308309e2-1694-4399-8abf-83fcf2dd37cc','{\"edges\": [[[127, false], null]]}',NULL),('18c48800-76e2-47ab-8134-7fab4ec386f0','2026-02-19 09:34:57','2026-02-19 09:35:08','2026-02-19 09:35:25','ParallelDeploymentsTest-317615709',185,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'5f030bfe49b047b687b6eaffbecb2b4a',0,0,1,'2c85e2c4-6de5-4d53-af98-f565083484c7','{\"edges\": [[[206, false], [204, false]], [[206, false], [205, false]], [[206, false], [203, false]]]}',NULL),('1d1726b4-d6e6-4d37-a2ec-f352e094251f','2026-02-19 09:37:34','2026-02-19 09:38:39','2026-02-19 09:38:40','ParallelDeploymentsTest-1835728659-dep_0-wdc4fp5bilga',236,NULL,NULL,'demo_tempestconf','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','DELETE','COMPLETE','Stack DELETE completed successfully',1,'93437950a15445e8843848fe3d1336e9',1,'abe58cc9071e47d2a3444fe76310fc22',0,1,1,'06c70f37-10b7-4c96-9351-e05edc943bca','{\"edges\": [[[226, false], null]]}','dep_0'),('1e2a1734-1cd7-4b61-8ca1-5580c61f4e37','2026-02-19 09:31:10','2026-02-19 09:31:42','2026-02-19 09:31:48','add_subnet',76,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'15ec61c141934351a5daba9400f6fe1a',0,0,1,'b689a672-72e9-4c48-ad49-ec3756314108','{\"edges\": [[[75, false], [74, false]], [[75, false], [73, false]], [[74, false], [73, false]]]}',NULL),('1eb57bcc-a4df-4905-aaa6-fb07c28c4592','2026-02-19 09:29:23','2026-02-19 09:29:30',NULL,'api-75184910-stack',25,NULL,9,'demo_tempestconf',NULL,'UPDATE','COMPLETE','Stack UPDATE completed successfully',NULL,'93437950a15445e8843848fe3d1336e9',1,'305a6cf8a1eb4a25bed011dfabf38b34',0,0,1,'ac64947c-4cf2-4d9d-a9a6-de2c5079e98c','{\"edges\": [[[6, false], [6, true]]]}',NULL),('1ee7d6a3-2669-464c-883e-5edf8536c56c','2026-02-19 09:29:23','2026-02-19 09:29:24','2026-02-19 09:29:25','api-1206788375-empty',16,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'93437950a15445e8843848fe3d1336e9',1,'087d453519c442cd93d50f294da76195',0,0,1,'8bbbb26d-4053-4472-838e-7e81c3b8645b','{\"edges\": []}',NULL),('263c66be-8d82-4da8-8c0a-70f4e3744ac2','2026-02-19 09:36:45','2026-02-19 09:36:55','2026-02-19 09:36:59','RemoteDeeplyNestedStackTest-453210323-network_stack-64nqnjbrxece',227,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'93437950a15445e8843848fe3d1336e9',1,'748cbc2b930d4c4497d794f7e42cf9c5',0,0,1,'e1c3d26f-a8b0-47b8-9f1b-e140ec3896dd','{\"edges\": [[[219, false], null]]}',NULL),('267e404a-4237-45f3-8727-7c300d5f4de6','2026-02-19 09:35:35','2026-02-19 09:35:38','2026-02-19 09:35:39','StackEventsTest-549012179',198,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'537fcae0608c4e6cbcdb019fbc564e32',0,0,1,'0ebe988c-3fc4-483e-ba5d-ef4f136f22a2','{\"edges\": [[[214, false], null]]}',NULL),('26fc6e76-721b-4eba-b18b-72e33d99f823','2026-02-19 09:34:21','2026-02-19 09:37:05','2026-02-19 09:37:09','ParallelDeploymentsTest-500642542',229,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'e1ce563280024959bff0d3b565264f86',0,0,1,'a994fc58-643d-48b3-97ea-ed8e1d44eb44','{\"edges\": [[[157, false], null]]}',NULL),('2955e463-ae36-41c5-be8c-13191c354c04','2026-02-19 09:33:18','2026-02-19 09:33:26','2026-02-19 09:33:27','HooksTest-1107949938',120,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'b1938b1b91404a5e957d12140cd80715',0,0,1,'f1e41109-ba93-40be-9336-6e238cdec6b2','{\"edges\": [[[132, false], [131, false]], [[133, false], [132, false]]]}',NULL),('297f0560-b15e-4d4b-929f-27ee3d3c4db8','2026-02-19 09:34:06','2026-02-19 09:34:09','2026-02-19 09:34:10','StackUnicodeTemplateTest-1464728206',143,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'538cd036bc9d400ba774fd3817f63e2c',0,0,1,'d5c815fc-145e-4718-9d1c-ff9db6a0bcec','{\"edges\": [[[153, false], null]]}',NULL),('2dc61297-d308-4e67-b348-9de8b23a1406','2026-02-19 09:29:34','2026-02-19 09:29:49','2026-02-19 09:29:54','UpdatePortTest-87839386',34,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'a67c01a3d68540288819b1991d2d56f1',0,0,1,'6009adef-1e0a-4089-856c-a5ea8d872abe','{\"edges\": [[[14, false], [13, false]], [[16, false], [15, false]], [[16, false], [14, false]], [[15, false], [14, false]]]}',NULL),('2fd08ce8-a5d1-401d-b36c-26c15a3c46ec','2026-02-19 09:31:21','2026-02-19 09:31:31','2026-02-19 09:31:34','UpdateSubnetTest-1182422141',71,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'8f32e2fcdffc44a28f5ad4aa95add6cf',0,0,1,'aed7e716-9755-41cf-8ba6-8a4d4b2d092a','{\"edges\": [[[87, false], [86, false]]]}',NULL),('31b6a150-764e-4f4d-a7bb-2e2257018426','2026-02-19 09:30:58','2026-02-19 09:31:14','2026-02-19 09:31:18','UpdateSubnetTest-502651509',67,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'eac2a755dcfd4d468409b89dfb5bac55',0,0,1,'71037e49-c282-4497-9783-7992d5e54683','{\"edges\": [[[68, false], [67, false]]]}',NULL),('3349a8b8-4459-48c0-b6ce-993640def0c1','2026-02-19 09:34:56','2026-02-19 09:35:34','2026-02-19 09:35:41','ParallelDeploymentsTest-1410556822-dep_1-tu5adhlvokhw',195,NULL,NULL,'demo_tempestconf','6a4f464f-6f93-4c05-9f4d-1520e9778a71','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'0aeeb8b1ff2b40ef95809ab674c46204',0,1,1,'74105e3b-57f0-4973-b3ca-3ac5ba77af64','{\"edges\": [[[200, false], null]]}','dep_1'),('39b754ea-2fb5-4e80-a0a0-c0b67163b1f4','2026-02-19 09:34:54','2026-02-19 09:35:55','2026-02-19 09:36:04','ParallelDeploymentsTest-1864767498-dep_0-khwzne6zbzlh',202,NULL,NULL,'demo_tempestconf','4ed35a8c-642e-4763-8389-c7148eaf292c','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'4fe22a7f62654cdd8b00dcf161c89b73',0,1,1,'28502bf5-3872-4335-aff5-06e1825943ce','{\"edges\": [[[194, false], null]]}','dep_0'),('3b04657b-376e-4603-ba97-51104a2af738','2026-02-19 09:34:43','2026-02-19 09:35:31','2026-02-19 09:35:38','swap_subnet_network',193,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'51f75f5301264591a6dde21d8bb9ba40',0,0,1,'2d6d0a39-a92a-4a9e-8be4-f9085d9d7e3c','{\"edges\": [[[188, false], [186, false]], [[188, false], [184, false]], [[186, false], [184, false]]]}',NULL),('3cd4e73d-0495-4d25-a6e6-97180bc46b74','2026-02-19 09:34:56','2026-02-19 09:35:36','2026-02-19 09:35:42','ParallelDeploymentsTest-1410556822-dep_2-6jtmimpikcgr',196,NULL,NULL,'demo_tempestconf','6a4f464f-6f93-4c05-9f4d-1520e9778a71','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'0aeeb8b1ff2b40ef95809ab674c46204',0,1,1,'ff7717ca-f131-4085-a6a3-cfa7bdf413c1','{\"edges\": [[[201, false], null]]}','dep_2'),('422f5827-e986-447e-a5a8-f6976e110842','2026-02-19 09:37:34','2026-02-19 09:38:41','2026-02-19 09:38:42','ParallelDeploymentsTest-1835728659-dep_2-zwdckbfn73nh',238,NULL,NULL,'demo_tempestconf','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','DELETE','COMPLETE','Stack DELETE completed successfully',1,'93437950a15445e8843848fe3d1336e9',1,'abe58cc9071e47d2a3444fe76310fc22',0,1,1,'cad9ed4b-5dfa-498a-aa9a-58abe52c2d91','{\"edges\": [[[227, false], null]]}','dep_2'),('43ef9cc5-bc6f-4c49-babc-34c1c1fc0058','2026-02-19 09:33:13','2026-02-19 09:33:25','2026-02-19 09:33:28','StackOutputsTest-74234904',118,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'a5f12e4d54254596877f89079324f4c3',0,0,1,'9c301d0f-bdff-4887-8d80-4324e9abb518','{\"edges\": [[[128, false], null]]}',NULL),('452981e1-c3cc-4fa7-b9a3-53ce27bddcd3','2026-02-19 09:34:42','2026-02-19 09:36:23','2026-02-19 09:36:29','ParallelDeploymentsTest-825460174-dep_4-nro7tyxzkysk',211,NULL,NULL,'demo_tempestconf','9fa13249-8716-4b7e-921d-22f54f1897b0','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'c4ffe1190c1d433692a00e684fcd500c',0,1,1,'40583b96-50ce-4c15-a9c9-cc7e536f4e35','{\"edges\": [[[181, false], null]]}','dep_4'),('467c15a2-e4fa-4f46-8d34-5ef117eb7d87','2026-02-19 09:33:02','2026-02-19 09:33:07','2026-02-19 09:33:09','ResourcesList-659869602',107,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'9b6c81e6b672418f8459544037d49ad9',0,0,1,'e08dce1f-c9f6-4976-aed0-630cdefbe1d4','{\"edges\": [[[124, false], [123, false]]]}',NULL),('4b7dda8f-12b4-49ca-b8c6-0126791cca78','2026-02-19 09:32:36','2026-02-19 09:32:38','2026-02-19 09:32:39','ExternalReferencesTest-1417404992',92,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'c1aa8c29ce1e403c8918fa5045ce5e0e',0,0,1,'716b7a33-983a-4cd6-8007-efde88e85b2e','{\"edges\": [[[109, false], null]]}',NULL),('4ed35a8c-642e-4763-8389-c7148eaf292c','2026-02-19 09:34:53','2026-02-19 09:35:48','2026-02-19 09:36:08','ParallelDeploymentsTest-1864767498',200,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'4fe22a7f62654cdd8b00dcf161c89b73',0,0,1,'e01a3260-acde-4c23-a252-55e2701b95c4','{\"edges\": [[[192, false], [191, false]], [[192, false], [189, false]], [[192, false], [190, false]]]}',NULL),('4ef52f85-9b3e-4d6a-a863-b1a613b430af','2026-02-19 09:33:48','2026-02-19 09:34:00','2026-02-19 09:34:01','StackOutputsTest-653190073',137,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'af12d13646a24ca8a93202824eede662',0,0,1,'d044aa50-eac3-467f-87c1-cd6f7848d56c','{\"edges\": [[[145, false], [146, false]]]}',NULL),('581b72a8-3d44-4e63-801f-c5a65bc03985','2026-02-19 09:33:27','2026-02-19 09:33:51','2026-02-19 09:33:55','RemoteStackTest-2136910817',130,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'9a368ad9b2ed4a35aeb1d1c8d7ba5454',0,0,1,'d6fbdb6a-d5a5-4705-95d2-aa812e4b620c','{\"edges\": [[[137, false], null]]}',NULL),('5da86ba1-1131-4371-9678-174588891d52','2026-02-19 09:31:37','2026-02-19 09:31:51','2026-02-19 09:31:55','EncryptedParametersTest-1466683732',79,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'91d6192b9fea44deaffa04a0cd7a03c2',0,0,1,'da069ba3-34dd-463e-9744-ee1cbd00dad3','{\"edges\": [[[88, false], null]]}',NULL),('61ee8ab3-6226-4da0-9482-e41441f2a322','2026-02-19 09:34:26','2026-02-19 09:34:37','2026-02-19 09:34:38','HooksTest-208371421-rg-uwcvkphq6eel',155,NULL,NULL,'demo_tempestconf','a713f099-5dfc-4239-9373-516638aa5612','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'f9f36817d68d400d9d0e3525263574f7',0,1,1,'cc9c2512-868b-45d0-a2af-bb37738fdf95','{\"edges\": [[[159, false], null], [[160, false], null]]}','rg'),('6260f36c-df83-4820-8dd8-9cd9f6faa520','2026-02-19 09:29:16',NULL,NULL,'api-26724205-rsrcstack',6,NULL,5,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'93437950a15445e8843848fe3d1336e9',1,'2f060ffe0e4f4d0b89392e1573f74a20',0,0,1,'5f109a0e-fee7-4027-ab02-cb90b2f41981','{\"edges\": [[[5, true], null]]}',NULL),('66cdfd5f-7e53-4d66-8dc0-a5d87ddfa1ed','2026-02-19 09:30:11','2026-02-19 09:30:31','2026-02-19 09:30:37','UpdateTrunkTest-611057247',53,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'6f58e5ff817142738223fd89100a391c',0,0,1,'a76cbb7e-77fd-45f8-a959-8f79b567067c','{\"edges\": [[[40, false], [36, false]], [[37, false], [36, false]], [[39, false], [37, false]], [[39, false], [38, false]], [[38, false], [37, false]], [[42, false], [40, false]], [[42, false], [41, false]], [[41, false], [40, false]], [[45, false], [44, false]], [[45, false], [43, false]], [[44, false], [43, false]]]}',NULL),('68a6a357-ff37-4b82-9ceb-ffcf88ae3a85','2026-02-19 09:34:54','2026-02-19 09:35:57','2026-02-19 09:36:03','ParallelDeploymentsTest-1864767498-dep_2-rgyaphd5dp2l',205,NULL,NULL,'demo_tempestconf','4ed35a8c-642e-4763-8389-c7148eaf292c','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'4fe22a7f62654cdd8b00dcf161c89b73',0,1,1,'d70e2d57-e9bd-4b8a-958c-15a925870a8c','{\"edges\": [[[195, false], null]]}','dep_2'),('6a4f464f-6f93-4c05-9f4d-1520e9778a71','2026-02-19 09:34:54','2026-02-19 09:35:29','2026-02-19 09:35:43','ParallelDeploymentsTest-1410556822',191,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'0aeeb8b1ff2b40ef95809ab674c46204',0,0,1,'798549f3-c2dc-45bf-bf4d-e27e08d82e11','{\"edges\": [[[199, false], [196, false]], [[199, false], [197, false]], [[199, false], [198, false]]]}',NULL),('6bd86a81-afb8-46ea-a818-b15647fc62fa','2026-02-19 09:30:27','2026-02-19 09:30:55','2026-02-19 09:31:04','server_with_port',59,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'bb2140f589c843a3846494a81181bb97',0,0,1,'7720a515-82f5-4aed-b6b5-71fedcb6177b','{\"edges\": [[[53, false], [51, false]], [[53, false], [52, false]], [[52, false], [51, false]], [[54, false], [53, false]], [[54, false], [52, false]]]}',NULL),('6d836b74-5ae0-48ff-b84f-dabfd9503e0c','2026-02-19 09:34:39','2026-02-19 09:36:42','2026-02-19 09:37:01','ParallelDeploymentsTest-614175552',218,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'126762f8222749628bae104cd11bb1ab',0,0,1,'b14832dc-1684-4367-bcaa-75dda626e6aa','{\"edges\": [[[166, false], [161, false]], [[166, false], [164, false]], [[166, false], [163, false]], [[166, false], [165, false]], [[166, false], [162, false]]]}',NULL),('6e86c2dd-aa09-4c1c-ada0-61c6f399a3fe','2026-02-19 09:33:03','2026-02-19 09:33:04','2026-02-19 09:33:06','RemoteStackTest-1569728035',105,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'a4084caaecb74e6c95529c40c40b7737',0,0,1,'08280aee-e71d-4b20-b433-99759bf24b96','{\"edges\": [[[125, false], null]]}',NULL),('70a70d1e-b0fb-4f77-83b9-54a270931092','2026-02-19 09:35:56','2026-02-19 09:36:16','2026-02-19 09:36:22','StackTagTest-775093476',209,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'1650377cea0f4d94a482de9c52bcb705',0,0,1,'9f5404d1-9976-462d-bc64-daf36e7d3770','{\"edges\": [[[216, false], null]]}',NULL),('7161156d-d594-4d7e-939f-0f38f838800d','2026-02-19 09:35:00','2026-02-19 09:35:15','2026-02-19 09:35:24','ParallelDeploymentsTest-317615709-dep_0-kcpo3kgmif5f',188,NULL,NULL,'demo_tempestconf','18c48800-76e2-47ab-8134-7fab4ec386f0','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'5f030bfe49b047b687b6eaffbecb2b4a',0,1,1,'b13db25f-3f3a-4f68-8682-a28459ce1540','{\"edges\": [[[209, false], null]]}','dep_0'),('72aebcbb-816d-4920-ae38-282cae3fb0aa','2026-02-19 09:29:24','2026-02-19 09:29:25','2026-02-19 09:29:26','api-26724205-empty',18,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'93437950a15445e8843848fe3d1336e9',1,'217e36110c3646419ffef3d8b66d2d9b',0,0,1,'36e0c4dc-4c20-46ed-b16a-1749a39a786a','{\"edges\": []}',NULL),('7323f31a-d82a-42dc-80d9-c7fc49532448','2026-02-19 09:31:53','2026-02-19 09:33:03','2026-02-19 09:33:14','multi_networks_swaps',104,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'e8c53492f3104efcbcdc29712d5d52fe',0,0,1,'1cecdece-2ca7-43b2-926e-629cee3761c2','{\"edges\": [[[95, false], [94, false]], [[95, false], [93, false]], [[94, false], [93, false]]]}',NULL),('7397f5ae-bf96-4fc7-97e0-112eef907291','2026-02-19 09:33:11','2026-02-19 09:33:19','2026-02-19 09:33:23','RemoteStackTest-1611783987',114,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'98b86629d0d44b1faf134a417ac2d1d8',0,0,1,'fad37c88-1ca5-40e5-8803-a6bbf179e2db','{\"edges\": [[[126, false], null]]}',NULL),('741eb13e-6fc0-476d-9cbd-9ec69f18faa8','2026-02-19 09:29:21','2026-02-19 09:29:22','2026-02-19 09:29:23','api-75184910-empty',10,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'93437950a15445e8843848fe3d1336e9',1,'011b52bdfbbc4502a242a821a168c2bc',0,0,1,'1413b079-27b2-4ad5-9958-669980cc2a0e','{\"edges\": []}',NULL),('758f8a8d-3940-4fa1-9d2a-108388d9899f','2026-02-19 09:36:28','2026-02-19 09:36:29','2026-02-19 09:36:34','TemplateAPITest-1259790094',216,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'03bf221e1a954f9c842dc6087b77e814',0,0,1,'fecab8f6-be07-4397-8460-ccee70841eb1','{\"edges\": [[[217, false], null]]}',NULL),('79892d56-0422-4f3a-ae6c-27fbcdab44c4','2026-02-19 09:34:56','2026-02-19 09:35:37','2026-02-19 09:35:43','ParallelDeploymentsTest-1410556822-dep_0-jk6x72auoxdp',197,NULL,NULL,'demo_tempestconf','6a4f464f-6f93-4c05-9f4d-1520e9778a71','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'0aeeb8b1ff2b40ef95809ab674c46204',0,1,1,'2a9b7ebe-135f-40b5-af24-01dd84d163f2','{\"edges\": [[[202, false], null]]}','dep_0'),('7ae00ead-58fc-4920-93c1-618cdd82799a','2026-02-19 09:33:57','2026-02-19 09:34:15','2026-02-19 09:34:17','RemoteStackTest-937856821',144,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'d97e22108a4344e5a7f697ef08985068',0,0,1,'61b148ee-1fb2-4acb-98a3-5eed702e523b','{\"edges\": [[[147, false], null]]}',NULL),('7f177449-04e2-4f00-bb40-f790914383df','2026-02-19 09:33:58','2026-02-19 09:34:15','2026-02-19 09:34:17','RemoteStackTest-937856821-my_stack-4b4byldarnik',145,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'93437950a15445e8843848fe3d1336e9',1,'68fc02fbaf7f42fcb47cc2bf10e52db2',0,0,1,'3bc779bb-bea8-4f15-b533-dd7c096d38e5','{\"edges\": [[[152, false], null]]}',NULL),('81e3280b-9726-4fff-bd50-94f8552f6a30','2026-02-19 09:32:54','2026-02-19 09:32:56','2026-02-19 09:32:57','ResourcesList-413939034',100,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'3ef2bea20db3493b96efdaec31be763a',0,0,1,'5064750d-ae25-4b2a-bf00-5a6603c1be1a','{\"edges\": [[[122, false], [121, false]]]}',NULL),('839083b9-29fa-4e62-9f9f-465e9b9fb990','2026-02-19 09:33:30','2026-02-19 09:33:36','2026-02-19 09:33:45','StackOutputsTest-1998979152',126,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'f2c958339e824459aa2c817a479ab858',0,0,1,'45d7811d-7a6f-41ec-ba22-455b9043bddf','{\"edges\": [[[139, false], null], [[140, false], null]]}',NULL),('859a1569-c5c8-4bc7-bae3-5eaed101840d','2026-02-19 09:29:20','2026-02-19 09:29:23','2026-02-19 09:29:24','api-743921893-empty',14,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'93437950a15445e8843848fe3d1336e9',1,'dcdbe5e4c0a346bd924e8faadc14b8f9',0,0,1,'ba7adf39-31f7-4a02-a4b4-b721847bf2ff','{\"edges\": []}',NULL),('859d9730-c8f1-4b5d-9048-a8f4b117fbd0','2026-02-19 09:34:43','2026-02-19 09:35:03','2026-02-19 09:35:04','HooksTest-1791753119',183,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'c6685fd8b8ec4af992f9ebc80951dd9e',0,0,1,'8b703fb8-f36c-4fa2-9d28-39fbcda362b7','{\"edges\": [[[185, false], [183, false]], [[187, false], [185, false]]]}',NULL),('898d8a4d-2d18-4d50-8fbf-0c8feae1f848','2026-02-19 09:34:40','2026-02-19 09:36:54','2026-02-19 09:37:00','ParallelDeploymentsTest-614175552-dep_4-vllpksuhb3q2',225,NULL,NULL,'demo_tempestconf','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'126762f8222749628bae104cd11bb1ab',0,1,1,'d6ea97df-e2ed-4ca3-85fc-09cc93d3f203','{\"edges\": [[[169, false], null]]}','dep_4'),('91314abe-2928-4fd4-8d26-a0e27ab69a92','2026-02-19 09:29:11','2026-02-19 09:29:17','2026-02-19 09:29:20','api-1206788375-rsrcstack',7,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'93437950a15445e8843848fe3d1336e9',1,'bbb22fb469d94113ad624a33b5dc5290',0,0,1,'5cc4824f-72b1-4595-b455-c8b46e68bfec','{\"edges\": [[[1, false], null]]}',NULL),('92c8c1c8-aff1-41ff-949f-54ce1eaf1cfe','2026-02-19 09:30:42','2026-02-19 09:31:09','2026-02-19 09:31:17','UpdateTrunkTest-858033391',65,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'40bcb493e12f4df19c9a0ab4a3311a53',0,0,1,'35fcef70-881f-4378-ac3f-9233302fd42f','{\"edges\": [[[58, false], [57, false]], [[61, false], [58, false]], [[61, false], [60, false]], [[60, false], [58, false]], [[66, false], [59, false]], [[66, false], [65, false]], [[65, false], [59, false]], [[64, false], [63, false]], [[64, false], [62, false]], [[63, false], [62, false]]]}',NULL),('9431b106-3940-4d80-922b-c86e1d165555','2026-02-19 09:34:40','2026-02-19 09:36:52','2026-02-19 09:36:58','ParallelDeploymentsTest-614175552-dep_0-y3rth3wuhf4a',223,NULL,NULL,'demo_tempestconf','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'126762f8222749628bae104cd11bb1ab',0,1,1,'cac1400c-3418-46da-b741-4f1d7ff22e6c','{\"edges\": [[[171, false], null]]}','dep_0'),('96845e67-548c-4233-98e6-ad5a9dd8c127','2026-02-19 09:34:40','2026-02-19 09:36:50','2026-02-19 09:36:57','ParallelDeploymentsTest-614175552-dep_1-r7q3uuzjc3pn',221,NULL,NULL,'demo_tempestconf','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'126762f8222749628bae104cd11bb1ab',0,1,1,'9d3b1c1f-2457-4c34-b0e5-2742c30e680e','{\"edges\": [[[170, false], null]]}','dep_1'),('9fa13249-8716-4b7e-921d-22f54f1897b0','2026-02-19 09:34:41','2026-02-19 09:36:13','2026-02-19 09:36:38','ParallelDeploymentsTest-825460174',208,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'c4ffe1190c1d433692a00e684fcd500c',0,0,1,'bcf67afa-c94f-44ce-ae12-d55d287da004','{\"edges\": [[[177, false], [172, false]], [[177, false], [175, false]], [[177, false], [173, false]], [[177, false], [176, false]], [[177, false], [174, false]]]}',NULL),('a500cc63-f05a-4887-9edb-ad51b4523a54','2026-02-19 09:31:19','2026-02-19 09:31:43','2026-02-19 09:31:49','UpdateTrunkTest-1757635903',77,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'d468ed84929346faa1b8453fead450c2',0,0,1,'432b6914-82f1-444a-bf4b-897747b19af9','{\"edges\": [[[79, false], [76, false]], [[77, false], [76, false]], [[83, false], [77, false]], [[83, false], [82, false]], [[82, false], [77, false]], [[81, false], [80, false]], [[81, false], [78, false]], [[80, false], [78, false]], [[85, false], [84, false]], [[85, false], [79, false]], [[84, false], [79, false]]]}',NULL),('a713f099-5dfc-4239-9373-516638aa5612','2026-02-19 09:34:25','2026-02-19 09:34:37','2026-02-19 09:34:40','HooksTest-208371421',154,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'f9f36817d68d400d9d0e3525263574f7',0,0,1,'aad762fe-332f-47c1-a669-c50c9761beb5','{\"edges\": [[[158, false], null]]}',NULL),('a76e09bc-b9fe-4d77-872d-ab05e616a7bb','2026-02-19 09:31:53','2026-02-19 09:32:32','2026-02-19 09:32:37','UpdateTrunkTest-2117912408',89,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'ecc7d44993b34940b17606e084803a5a',0,0,1,'1f7ead58-ec84-489a-bbfa-f9edc88a1c18','{\"edges\": [[[98, false], [96, false]], [[97, false], [96, false]], [[100, false], [99, false]], [[100, false], [97, false]], [[99, false], [97, false]], [[105, false], [104, false]], [[105, false], [98, false]], [[104, false], [98, false]], [[103, false], [102, false]], [[103, false], [101, false]], [[102, false], [101, false]]]}',NULL),('af870f05-44c9-4147-b4e9-134924cd9b5b','2026-02-19 09:29:11','2026-02-19 09:29:14','2026-02-19 09:29:16','api-26724205-envstack',5,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'93437950a15445e8843848fe3d1336e9',1,'940e23e09dbe44be8796a86e829cb717',0,0,1,'4cd2061a-5f7e-473d-abf2-ee5eba1f8134','{\"edges\": [[[4, false], null]]}',NULL),('b149dd07-d961-4e1e-89b8-766cfb699627','2026-02-19 09:37:34','2026-02-19 09:38:40','2026-02-19 09:38:41','ParallelDeploymentsTest-1835728659-dep_1-xbamgrqddcn2',237,NULL,NULL,'demo_tempestconf','c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','DELETE','COMPLETE','Stack DELETE completed successfully',1,'93437950a15445e8843848fe3d1336e9',1,'abe58cc9071e47d2a3444fe76310fc22',0,1,1,'eb0e4aeb-b7ff-4025-941a-26465d52dacb','{\"edges\": [[[228, false], null]]}','dep_1'),('b2ad0b40-ebd0-43d3-bbd3-611445ea3ef1','2026-02-19 09:29:11',NULL,NULL,'api-743921893-envstack',1,NULL,2,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'93437950a15445e8843848fe3d1336e9',1,'18dbeaf20ea84dd285deaf14397f09ee',0,0,1,'6d25e393-426b-484f-b730-5511dde204c1','{\"edges\": [[[2, true], null]]}',NULL),('b2e6d3e5-af11-4b68-8a44-ce63d940fd3f','2026-02-19 09:30:20','2026-02-19 09:31:00','2026-02-19 09:31:05','same_fixed_ip',62,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'7f1f8b80afaf4a31addbfbd68f1ea80d',0,0,1,'4d35a36f-2d29-40a9-b9da-d55d4b036758','{\"edges\": [[[50, false], [48, false]], [[50, false], [49, false]], [[49, false], [48, false]]]}',NULL),('b334fbda-f3b5-4d28-9dbd-c08785fa4ea4','2026-02-19 09:36:42','2026-02-19 09:36:54','2026-02-19 09:37:00','RemoteDeeplyNestedStackTest-453210323',226,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'6b866c7e036e4152aa23709023bcfcc7',0,0,1,'35a55f69-69a4-4c81-9793-03589e5d17fb','{\"edges\": [[[218, false], null]]}',NULL),('b351f81f-e135-45c3-9d01-f6221b7745a1','2026-02-19 09:34:42','2026-02-19 09:36:24','2026-02-19 09:36:33','ParallelDeploymentsTest-825460174-dep_3-s3ukplefd4zu',212,NULL,NULL,'demo_tempestconf','9fa13249-8716-4b7e-921d-22f54f1897b0','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'c4ffe1190c1d433692a00e684fcd500c',0,1,1,'a9024df4-b4f7-4a27-993b-d34e327a6ad2','{\"edges\": [[[179, false], null]]}','dep_3'),('b3b98c6e-4be1-459d-b2cf-bc6432e71203','2026-02-19 09:35:01','2026-02-19 09:35:16','2026-02-19 09:35:24','ParallelDeploymentsTest-317615709-dep_1-mnl43z36sp7l',189,NULL,NULL,'demo_tempestconf','18c48800-76e2-47ab-8134-7fab4ec386f0','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'5f030bfe49b047b687b6eaffbecb2b4a',0,1,1,'7dc0fa14-dbe1-4ba7-86fd-cbbfc9f31fe9','{\"edges\": [[[208, false], null]]}','dep_1'),('b58680e1-d9a4-421a-9cce-0135c41a58d8','2026-02-19 09:29:56','2026-02-19 09:30:16','2026-02-19 09:30:21','UpdatePortTest-795770163',46,NULL,NULL,'admin',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'36500efc027a4965a43a690ab8c9df90',1,'64ace0d977314cf7bfc1efd255ce31c7',0,0,1,'854c9e04-5823-493e-b92f-0d8b5a02f39a','{\"edges\": [[[31, false], null], [[33, false], [35, false]], [[34, false], [33, false]], [[34, false], [35, false]]]}',NULL),('b746c133-ba4f-462f-804e-68f51e22d638','2026-02-19 09:29:24','2026-02-19 09:29:31',NULL,'api-743921893-stack',27,NULL,11,'demo_tempestconf',NULL,'UPDATE','COMPLETE','Stack UPDATE completed successfully',NULL,'93437950a15445e8843848fe3d1336e9',1,'5ca71d816d404779a4b44e2c0bdc1a75',0,0,1,'8abfdf32-86a5-419a-8d7c-0bb8ae5a3d19','{\"edges\": [[[7, false], [7, true]]]}',NULL),('bb5e89c3-c837-4b24-8b6e-1d83a34bd967','2026-02-19 09:35:44','2026-02-19 09:35:50','2026-02-19 09:35:54','StackTagTest-1821210739',201,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'23f40b0b1adc4071b0f02ac359393f7d',0,0,1,'44560e65-c0b4-4d6a-90cd-1d388db076fd','{\"edges\": [[[215, false], null]]}',NULL),('bf321c86-ead0-4108-9cd7-b2c200eb143f','2026-02-19 09:31:57','2026-02-19 09:32:17','2026-02-19 09:32:19','EncryptionVolTypeTest-395158397',84,NULL,NULL,'admin',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'36500efc027a4965a43a690ab8c9df90',1,'cf1f28aad3f742d2a5afb61f7cd30616',0,0,1,'3be9f2e1-a523-4245-87e8-70803b3cdbc1','{\"edges\": [[[107, false], [106, false]]]}',NULL),('c3c868ba-7067-4d77-b716-f0f6f519cdc9','2026-02-19 09:29:11',NULL,NULL,'api-75184910-rsrcstack',4,NULL,4,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'93437950a15445e8843848fe3d1336e9',1,'edc6a2cd42ca4322bcecbc3106b46306',0,0,1,'aaa1982a-5f6e-4927-a832-aabb77212ddf','{\"edges\": [[[3, true], null]]}',NULL),('c46b4a05-f25d-4aa5-9a1e-26acd484ef92','2026-02-19 09:35:09','2026-02-19 09:35:29','2026-02-19 09:35:32','HooksTest-1803794222',192,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'35c9ee59d5984f129825e62afe8e8e54',0,0,1,'9d6fe863-8f66-498a-85ce-99935d976060','{\"edges\": [[[210, false], null], [[212, false], [213, false]]]}',NULL),('c4d41f4d-be9b-4c9f-80db-bfba782c2eb0','2026-02-19 09:29:39','2026-02-19 09:30:01','2026-02-19 09:30:06','UpdateTrunkTest-1324056510',40,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'f69c6efa4f8349208fdc65a103fb2e91',0,0,1,'2f7dd738-d2f2-4101-ac54-8e8a8401bb28','{\"edges\": [[[24, false], [19, false]], [[21, false], [19, false]], [[20, false], [19, false]], [[23, false], [20, false]], [[23, false], [22, false]], [[22, false], [20, false]], [[28, false], [21, false]], [[28, false], [27, false]], [[27, false], [21, false]], [[26, false], [25, false]], [[26, false], [24, false]], [[25, false], [24, false]]]}',NULL),('c6a6f087-3aaf-4b90-8bf0-7ebb26df0984','2026-02-19 09:37:32','2026-02-19 09:38:39','2026-02-19 09:38:43','ParallelDeploymentsTest-1835728659',235,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1,'93437950a15445e8843848fe3d1336e9',1,'abe58cc9071e47d2a3444fe76310fc22',0,0,1,'a2df0e95-03f9-436e-914b-5707ca1254d8','{\"edges\": [[[225, false], [224, false]], [[225, false], [222, false]], [[225, false], [223, false]]]}',NULL),('c9b6315e-8c70-41d3-9ebc-50fc528cc8fa','2026-02-19 09:32:23','2026-02-19 09:32:30','2026-02-19 09:32:32','ExternalReferencesTest-1782684685',88,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'36957296fb8c4544ac468f07b7bb4473',0,0,1,'f0f5e2c6-e772-4844-9ec3-87bed22a63f7','{\"edges\": [[[108, false], null]]}',NULL),('cbe062ff-5793-4db9-8520-c53c852ef6f6','2026-02-19 09:37:13','2026-02-19 09:38:44','2026-02-19 09:38:50','ParallelDeploymentsTest-1674731843',239,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'9b7135b4f0cb44129443db5913c15085',0,0,1,'fe5bb8a2-c167-4b07-ba0d-e20b478c5a23','{\"edges\": [[[221, false], null]]}',NULL),('d0090fba-5a2b-4393-9536-c7a5457432aa','2026-02-19 09:32:43','2026-02-19 09:33:07','2026-02-19 09:33:13','UpdateTrunkTest-412893611',106,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'5ee5e9e0d80342dc9c0b53a807109522',0,0,1,'2976575d-fb02-436c-a238-6c96f1ec9c1b','{\"edges\": [[[111, false], [110, false]], [[113, false], [112, false]], [[113, false], [111, false]], [[112, false], [111, false]], [[116, false], [115, false]], [[116, false], [114, false]], [[115, false], [114, false]], [[119, false], [118, false]], [[119, false], [117, false]], [[118, false], [117, false]]]}',NULL),('d030df58-eeb9-47ec-98c9-61b455b3e0d4','2026-02-19 09:34:42','2026-02-19 09:36:25','2026-02-19 09:36:35','ParallelDeploymentsTest-825460174-dep_0-3wfxqlizneo3',213,NULL,NULL,'demo_tempestconf','9fa13249-8716-4b7e-921d-22f54f1897b0','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'c4ffe1190c1d433692a00e684fcd500c',0,1,1,'7fb7ef41-a665-4882-9ac2-3a9f3dbe8bbb','{\"edges\": [[[182, false], null]]}','dep_0'),('d157adbf-2234-4f21-9bc8-1e0b6f362fdc','2026-02-19 09:33:18','2026-02-19 09:33:58','2026-02-19 09:34:05','swap_network_port',136,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'7d90d016768449e183079752072c9cd2',0,0,1,'c2e46ed7-b893-4e8c-8bc0-b1f063ab312f','{\"edges\": [[[135, false], [134, false]], [[136, false], [135, false]]]}',NULL),('d237f286-5dda-4a43-ad25-882528fa8c69','2026-02-19 09:33:29','2026-02-19 09:33:52','2026-02-19 09:33:55','RemoteStackTest-2136910817-my_stack-55nl6c6j3mfa',132,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'93437950a15445e8843848fe3d1336e9',1,'ebab2dfcc2814249a44d54771af45306',0,0,1,'9874de38-b091-4011-b636-316256b602fb','{\"edges\": [[[138, false], null]]}',NULL),('d6c8c06b-afb4-4471-8ed4-887be29d705d','2026-02-19 09:34:42','2026-02-19 09:36:26','2026-02-19 09:36:35','ParallelDeploymentsTest-825460174-dep_1-yactjmgm6apr',214,NULL,NULL,'demo_tempestconf','9fa13249-8716-4b7e-921d-22f54f1897b0','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'c4ffe1190c1d433692a00e684fcd500c',0,1,1,'6cd256bd-eaa1-44e2-b4bf-8f0464aab44c','{\"edges\": [[[180, false], null]]}','dep_1'),('d979d597-3242-4254-a714-d7af6285e024','2026-02-19 09:29:26','2026-02-19 09:29:38','2026-02-19 09:29:39','api-26724205-stack',29,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'93437950a15445e8843848fe3d1336e9',1,'2b62b63c6526468f817fb697ca635576',0,0,1,'e08c06ea-69cb-4b08-b999-1f323a4f6027','{\"edges\": [[[9, false], null]]}',NULL),('dcecf177-9a5d-42ec-8995-39a797c82f48','2026-02-19 09:31:44','2026-02-19 09:32:43','2026-02-19 09:32:52','create_server_with_sub_ip',95,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'1f2032fe27594c45a56bf9f14df99b0c',0,0,1,'bf4c881e-5aec-49d0-a040-1ecce155d66d','{\"edges\": [[[91, false], [89, false]], [[90, false], [89, false]], [[92, false], [91, false]], [[92, false], [90, false]]]}',NULL),('dde52115-d860-4b44-bc89-5a2453d6b2b6','2026-02-19 09:34:40','2026-02-19 09:36:51','2026-02-19 09:36:58','ParallelDeploymentsTest-614175552-dep_3-pgcfpvugjbpb',222,NULL,NULL,'demo_tempestconf','6d836b74-5ae0-48ff-b84f-dabfd9503e0c','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'126762f8222749628bae104cd11bb1ab',0,1,1,'206211d1-d2ee-4d7d-b8c5-3ad8bed86296','{\"edges\": [[[168, false], null]]}','dep_3'),('ddf85b97-ba1f-45cf-b661-2799a3ceda32','2026-02-19 09:33:31','2026-02-19 09:33:50','2026-02-19 09:33:56','HooksTest-172485013',129,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'d6149514b5994bb79b8a26c14d46f702',0,0,1,'0d6796da-66e6-4561-a86c-c327a2c31aeb','{\"edges\": [[[141, false], null]]}',NULL),('e1c8d1f5-3f1e-40c6-aab0-fa49073f9153','2026-02-19 09:34:54','2026-02-19 09:35:55','2026-02-19 09:36:04','ParallelDeploymentsTest-1864767498-dep_1-jeip62xpeid3',203,NULL,NULL,'demo_tempestconf','4ed35a8c-642e-4763-8389-c7148eaf292c','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'4fe22a7f62654cdd8b00dcf161c89b73',0,1,1,'c3856ccc-c445-4399-9dec-e80042d70753','{\"edges\": [[[193, false], null]]}','dep_1'),('e3887d7f-9336-436e-a13e-5ad7b54026f0','2026-02-19 09:34:58','2026-02-19 09:35:14','2026-02-19 09:35:21','ParallelDeploymentsTest-317615709-dep_2-heywnavye66z',186,NULL,NULL,'demo_tempestconf','18c48800-76e2-47ab-8134-7fab4ec386f0','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'5f030bfe49b047b687b6eaffbecb2b4a',0,1,1,'9c48a40c-8c7b-4c6f-a435-4a611fb4d545','{\"edges\": [[[207, false], null]]}','dep_2'),('f2e71c33-6e82-4cc3-887c-792b3fa2acfb','2026-02-19 09:30:37','2026-02-19 09:30:49','2026-02-19 09:30:54','UpdateSubnetTest-1100360100',58,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'84fd98c7da634d639c570cd000f5ce7b',0,0,1,'a50f0d3f-a707-4a57-aa05-1fab5b0c1d1d','{\"edges\": [[[56, false], [55, false]]]}',NULL),('f6f7f2b1-53ad-4d71-8123-4172e2d859f3','2026-02-19 09:32:43','2026-02-19 09:32:54','2026-02-19 09:32:55','ExternalReferencesTest-1470144968',99,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'d38b437ac3c043809499bb89738edc4e',0,0,1,'f689067e-4d38-4f11-8004-75baf002fc82','{\"edges\": [[[120, false], null]]}',NULL),('f7546ed3-d586-454f-94de-6aaeb0f311ce','2026-02-19 09:31:10','2026-02-19 09:31:34','2026-02-19 09:31:42','server_with_sub_ip',73,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'c97da4e331b44931a9f251ec9fe5a02a',0,0,1,'715109c9-ce60-4c46-be07-08e40ca24ed3','{\"edges\": [[[72, false], [69, false]], [[70, false], [69, false]], [[71, false], [70, false]]]}',NULL),('f85a03e0-c171-490b-900d-2a307dabee57','2026-02-19 09:34:42','2026-02-19 09:36:21','2026-02-19 09:36:29','ParallelDeploymentsTest-825460174-dep_2-66sur23t33uk',210,NULL,NULL,'demo_tempestconf','9fa13249-8716-4b7e-921d-22f54f1897b0','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'c4ffe1190c1d433692a00e684fcd500c',0,1,1,'c986e1fa-a885-42b0-8910-5cad4c13b3db','{\"edges\": [[[178, false], null]]}','dep_2'),('fd49aaf5-6751-4be5-bad9-b211c5399bad','2026-02-19 09:30:17','2026-02-19 09:30:31','2026-02-19 09:30:35','UpdateSubnetTest-1737812987',52,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'93437950a15445e8843848fe3d1336e9',1,'008a491121274ff19703b8728247dacf',0,0,1,'dd3d5f5a-9581-4ec2-bf47-a52e98639d6d','{\"edges\": [[[47, false], [46, false]]]}',NULL);
/*!40000 ALTER TABLE `stack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_lock`
--

DROP TABLE IF EXISTS `stack_lock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_lock` (
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`stack_id`),
  CONSTRAINT `stack_lock_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_lock`
--

LOCK TABLES `stack_lock` WRITE;
/*!40000 ALTER TABLE `stack_lock` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack_lock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_tag`
--

DROP TABLE IF EXISTS `stack_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `tag` varchar(80) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  CONSTRAINT `stack_tag_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_tag`
--

LOCK TABLES `stack_tag` WRITE;
/*!40000 ALTER TABLE `stack_tag` DISABLE KEYS */;
INSERT INTO `stack_tag` (`id`, `created_at`, `updated_at`, `tag`, `stack_id`) VALUES (1,'2026-02-19 09:35:44',NULL,'foo','bb5e89c3-c837-4b24-8b6e-1d83a34bd967'),(2,'2026-02-19 09:35:44',NULL,'data-processing-cluster','bb5e89c3-c837-4b24-8b6e-1d83a34bd967');
/*!40000 ALTER TABLE `stack_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_point`
--

DROP TABLE IF EXISTS `sync_point`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sync_point` (
  `entity_id` varchar(36) NOT NULL,
  `traversal_id` varchar(36) NOT NULL,
  `is_update` tinyint(1) NOT NULL,
  `atomic_key` int(11) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `input_data` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`traversal_id`,`is_update`),
  KEY `fk_stack_id` (`stack_id`),
  CONSTRAINT `fk_stack_id` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_point`
--

LOCK TABLES `sync_point` WRITE;
/*!40000 ALTER TABLE `sync_point` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_point` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_creds`
--

DROP TABLE IF EXISTS `user_creds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_creds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `region_name` varchar(255) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `tenant` varchar(1024) DEFAULT NULL,
  `auth_url` text DEFAULT NULL,
  `tenant_id` varchar(256) DEFAULT NULL,
  `trust_id` varchar(255) DEFAULT NULL,
  `trustor_user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=76 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_creds`
--

LOCK TABLES `user_creds` WRITE;
/*!40000 ALTER TABLE `user_creds` DISABLE KEYS */;
INSERT INTO `user_creds` (`id`, `created_at`, `updated_at`, `username`, `password`, `region_name`, `decrypt_method`, `tenant`, `auth_url`, `tenant_id`, `trust_id`, `trustor_user_id`) VALUES (2,'2026-02-19 09:29:11',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','93437950a15445e8843848fe3d1336e9','gAAAAABpltfnxtGRwMW7JLQk6Rx7ATGIE_pWkTr-tE6RV5C6ARVxVI613gh8YkSTn3wgzIeiJiwqLc7fYCqe5EH796ZeoGu5PR6opGneLDtjVtQVce-2YG719P7K_sba8pP7iSma9nzv','da63d65ec0a1494aabbda731e00918ab'),(4,'2026-02-19 09:29:11',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','93437950a15445e8843848fe3d1336e9','gAAAAABpltfnOZzN7FGkxHOSziPhNXDqG_ZjWZp-BIPr2wQE-lAOLu06-I2-yvy6KVoIVl7kUYytZW4BvLf5KyDeim2GgnA-SOGArp7zMX4g8wvIgFBR__SAqXfpbuFo7E3mJMRW6ki2','da63d65ec0a1494aabbda731e00918ab'),(5,'2026-02-19 09:29:16',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','93437950a15445e8843848fe3d1336e9','gAAAAABpltfsLjUjZ9DDsJgoiK5sQoEuFthmWr9SUZMKGp7O9YgZfWVjacoXQTBD_fbYhJz0jy6hM5bpSqOtELRFdvKMt4gVnSslwETJzT3m9jP2SgbL_fnZpBZU9VAeCy9eRL9DE2WP','da63d65ec0a1494aabbda731e00918ab'),(9,'2026-02-19 09:29:23',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','93437950a15445e8843848fe3d1336e9','gAAAAABpltfzwqbyCtKR32OawR7hv7Ys6uYGUiG72rwTYWJ79pHz9fnKdUQEup6c1PME6xlWAgVPm4X4mva7cXA5hm8nmvCIM9nRgQo6EkHB8sKZ0UQF53y9XSCkBSR-6La__tWhoIwR','da63d65ec0a1494aabbda731e00918ab'),(11,'2026-02-19 09:29:24',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','93437950a15445e8843848fe3d1336e9','gAAAAABpltf0cVU3KukCzgI8JuCsjJEgAZuJvol840koOOhNxrUTa0Uj2oblfKl5wvhg74cy4_YiIlwSAc8H8_f9d6zHIACWXj8gx3pOVMXrZV9pNYFfLIqiw8qSB_zfznVFt6VhOYaY','da63d65ec0a1494aabbda731e00918ab'),(12,'2026-02-19 09:29:25',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','93437950a15445e8843848fe3d1336e9','gAAAAABpltf1BqlCXh2Bvb6YsH8kA4oIX0TMHXWjrXo6fVbg0evbqdc4PHXSoL9WcFKIa4isuWe5zmsP-rgLezifzkJUTj19s8yODx1u65ZFx5aEY62NKAOiAVhozNUokACHakxnKzsO','da63d65ec0a1494aabbda731e00918ab');
/*!40000 ALTER TABLE `user_creds` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `user_id` (`user_id`),
  KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','16808460159f42828023b199a4c3a6b1','57e340cf13ed49439edf5a13879d16b9','058de4416c964001a4279726263a2d10',0),('UserProject','16808460159f42828023b199a4c3a6b1','57e340cf13ed49439edf5a13879d16b9','6d6f6e5e5a184e0db9e303dee3db9e65',0),('UserProject','37c67ac801574c38b9866c4f7c3d6511','36500efc027a4965a43a690ab8c9df90','058de4416c964001a4279726263a2d10',0),('UserProject','37c67ac801574c38b9866c4f7c3d6511','93437950a15445e8843848fe3d1336e9','058de4416c964001a4279726263a2d10',0),('UserProject','6912a5864acc43c38ae28082a64b7db4','57e340cf13ed49439edf5a13879d16b9','058de4416c964001a4279726263a2d10',0),('UserProject','6912a5864acc43c38ae28082a64b7db4','57e340cf13ed49439edf5a13879d16b9','6d6f6e5e5a184e0db9e303dee3db9e65',0),('UserProject','6b8943f1b87d4d2e98016273885505cb','57e340cf13ed49439edf5a13879d16b9','058de4416c964001a4279726263a2d10',0),('UserProject','6b8943f1b87d4d2e98016273885505cb','57e340cf13ed49439edf5a13879d16b9','6d6f6e5e5a184e0db9e303dee3db9e65',0),('UserProject','b2ac073e05ab4933bc1576296ea3c972','57e340cf13ed49439edf5a13879d16b9','058de4416c964001a4279726263a2d10',0),('UserProject','b2ac073e05ab4933bc1576296ea3c972','57e340cf13ed49439edf5a13879d16b9','6d6f6e5e5a184e0db9e303dee3db9e65',0),('UserProject','c2838cf908fd4ff0a4284ecdc84615aa','57e340cf13ed49439edf5a13879d16b9','058de4416c964001a4279726263a2d10',0),('UserProject','c2838cf908fd4ff0a4284ecdc84615aa','57e340cf13ed49439edf5a13879d16b9','6d6f6e5e5a184e0db9e303dee3db9e65',0),('UserProject','d0b1ef089d954346aa5038c67a96687c','57e340cf13ed49439edf5a13879d16b9','058de4416c964001a4279726263a2d10',0),('UserProject','d0b1ef089d954346aa5038c67a96687c','57e340cf13ed49439edf5a13879d16b9','6d6f6e5e5a184e0db9e303dee3db9e65',0),('UserProject','d49b4bb3b2b0495890a850f14f236d6f','57e340cf13ed49439edf5a13879d16b9','058de4416c964001a4279726263a2d10',0),('UserProject','d49b4bb3b2b0495890a850f14f236d6f','57e340cf13ed49439edf5a13879d16b9','25fbeac817574c62a53a4bb2d75ef16b',0),('UserProject','d49b4bb3b2b0495890a850f14f236d6f','57e340cf13ed49439edf5a13879d16b9','6d6f6e5e5a184e0db9e303dee3db9e65',0),('UserProject','da63d65ec0a1494aabbda731e00918ab','93437950a15445e8843848fe3d1336e9','6309c915b52a4916be4d7ca7a2d20e1d',0),('UserProject','e149acefe43d4ca3b3d5ba653d9b7122','57e340cf13ed49439edf5a13879d16b9','058de4416c964001a4279726263a2d10',0),('UserProject','e149acefe43d4ca3b3d5ba653d9b7122','57e340cf13ed49439edf5a13879d16b9','6d6f6e5e5a184e0db9e303dee3db9e65',0),('UserProject','fd47ff942d744d7db62a74fc0da3ceac','57e340cf13ed49439edf5a13879d16b9','058de4416c964001a4279726263a2d10',0),('UserProject','fd47ff942d744d7db62a74fc0da3ceac','57e340cf13ed49439edf5a13879d16b9','6d6f6e5e5a184e0db9e303dee3db9e65',0),('UserDomain','4d4293ae62374cb8ac0be9bad2f617eb','4ee5a380c4124051a28464fd6435d39a','058de4416c964001a4279726263a2d10',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('05a6308958ba4af48928266cdf342d29',NULL,'internal','8377aa4a3d634628936591e1ce51bbe0','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('1b6a81f63f074b3fb8d2e52a7f213639',NULL,'internal','25fed5e82ed745a8b060547d41a7921b','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('367acf2e1a2a4b74a7d016e6413826c4',NULL,'public','8377aa4a3d634628936591e1ce51bbe0','https://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('37d0f69f68df45fd8d344892d232507a',NULL,'public','25fed5e82ed745a8b060547d41a7921b','https://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('429fa67156194e0b865f334efa32c58c',NULL,'public','3a6fa37370564070ae13817f5211710d','https://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('46e0bac1109a4c9495ad72f8c5a058dc',NULL,'public','e1a78ecd6e6043da81e38f895587ec7d','https://heat-api-public-openstack.apps-crc.testing/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('50177db564d847fba646a84ec8b99d2b',NULL,'internal','d98e6e400fd6407297998a0d41374734','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('56e8c7149f3e40db8b69a81e991d1da6',NULL,'internal','ec581c10a1424798859b0477d68845ea','https://heat-cfnapi-internal.openstack.svc:8000/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('577858b1b67944b9b954f5081cd9f180',NULL,'internal','3379f76e48af4eb4b06894e91e7219e9','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('69abd2918adc484595778e79870261fc',NULL,'public','dc9d9e8ab85e45159dac50ee1f94c80c','https://swift-public-openstack.apps-crc.testing/v1/AUTH_%(tenant_id)s','{\"name\": \"swift\"}',1,'regionOne'),('6b0f361ebd574ec992a55ffd3807b22d',NULL,'internal','e1a78ecd6e6043da81e38f895587ec7d','https://heat-api-internal.openstack.svc:8004/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('8365188fadb34abeb29902d659512c35',NULL,'public','3379f76e48af4eb4b06894e91e7219e9','https://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('9626c3a1a2334b3c839d01f32ff80f48',NULL,'internal','dbb66774be1e416781e8f4d99c8b9e1d','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('99c58ddf1e0b4cbfa29efe9a47b9bffd',NULL,'internal','1259045fb03d4301aaa0e34a86aadcc6','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('9dd8496fc95f4b0e9d47e8c392c1ee84',NULL,'public','ec581c10a1424798859b0477d68845ea','https://heat-cfnapi-public-openstack.apps-crc.testing/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('a8b64b6107b24abe9c149a8828f63045',NULL,'public','dbb66774be1e416781e8f4d99c8b9e1d','https://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('a9f5c513941245ea85ed151c6112351b',NULL,'public','d98e6e400fd6407297998a0d41374734','https://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('afb3a984017d4302a6953014fef7c23a',NULL,'public','1259045fb03d4301aaa0e34a86aadcc6','https://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('c6b4445f0e0b4f9fafbb71a141a2c665',NULL,'internal','dc9d9e8ab85e45159dac50ee1f94c80c','https://swift-internal.openstack.svc:8080/v1/AUTH_%(tenant_id)s','{\"name\": \"swift\"}',1,'regionOne'),('db73cfbcfdc644349f7414a90435397e',NULL,'internal','3a6fa37370564070ae13817f5211710d','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('058de4416c964001a4279726263a2d10','6309c915b52a4916be4d7ca7a2d20e1d'),('6309c915b52a4916be4d7ca7a2d20e1d','43725660f26d45798b3251b23ea9f377');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'37c67ac801574c38b9866c4f7c3d6511','default','admin',0,NULL),(2,'d49b4bb3b2b0495890a850f14f236d6f','default','ceilometer',0,NULL),(3,'c2838cf908fd4ff0a4284ecdc84615aa','default','barbican',0,NULL),(4,'16808460159f42828023b199a4c3a6b1','default','glance',0,NULL),(5,'fd47ff942d744d7db62a74fc0da3ceac','default','neutron',0,NULL),(6,'b2ac073e05ab4933bc1576296ea3c972','default','nova',0,NULL),(7,'6912a5864acc43c38ae28082a64b7db4','default','cinder',0,NULL),(8,'4d4293ae62374cb8ac0be9bad2f617eb','4ee5a380c4124051a28464fd6435d39a','heat_stack_domain_admin',0,NULL),(9,'e149acefe43d4ca3b3d5ba653d9b7122','default','swift',0,NULL),(10,'d0b1ef089d954346aa5038c67a96687c','default','placement',0,NULL),(11,'6b8943f1b87d4d2e98016273885505cb','default','heat',0,NULL),(12,'da63d65ec0a1494aabbda731e00918ab','default','demo_tempestconf',0,NULL),(13,'76a011a687974006ae00f335ff21a4ea','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$rKsE3xPs97BAnUal9hQDiO1HI5nKYkKMQB64eK7dnB/XD4GjfrBZ.',1771491704562118,NULL,'2026-02-19 09:01:44'),(2,2,NULL,0,'$2b$12$CE/HGYKtFwsPGLVkHUzfC.ZJzjQIxVR3Eo/.7F1k.wJWnR3lGDx62',1771491787947158,NULL,'2026-02-19 09:03:07'),(3,3,NULL,0,'$2b$12$9jDHXluS3wxIbQC9rjvHmetNpnTZyaLjl8TMWSGLiO79ZQ84gY1rS',1771491791882382,NULL,'2026-02-19 09:03:11'),(4,4,NULL,0,'$2b$12$PBxIamMfhli6gd8.u5kcmueOgxStr53ovWOKibAQY88uusnLOReza',1771491795117151,NULL,'2026-02-19 09:03:15'),(5,5,NULL,0,'$2b$12$ZdNg5oQ5CgByFqUJMu.kmOMoSlgD1EyBfOOPRlMFagJHEEDCs5CVS',1771491797392272,NULL,'2026-02-19 09:03:17'),(6,6,NULL,0,'$2b$12$CD7Jlmw1jclxZ.kkkr5rDe/8KghJXA/eUUV/GqIZ7DOk8i2p9rMYG',1771491800662059,NULL,'2026-02-19 09:03:20'),(7,7,NULL,0,'$2b$12$.iVfvnh0NLe/emzvMNnnl.7jIrH2CSvgXQ3P9Ms75.mpY5rlKgfWq',1771491804547517,NULL,'2026-02-19 09:03:24'),(8,8,NULL,0,'$2b$12$pqHhG//aFkSMkynZVeQohONiT5zJiVd1JO2LE79oKHu/g5S7RSMZS',1771491805218397,NULL,'2026-02-19 09:03:25'),(9,9,NULL,0,'$2b$12$aOQK96uTWjZR7H7cGkqASusDKN0u3VtmrpA0rXyXE/BR5/JVb8P4i',1771491812866661,NULL,'2026-02-19 09:03:32'),(10,10,NULL,0,'$2b$12$W6eBAOzxRVkGNwj7nwTjFeQrHYKqXjEmrTFlBAgpD8WerGM8uFuOy',1771491836214915,NULL,'2026-02-19 09:03:56'),(11,11,NULL,0,'$2b$12$xaYxWHG.nBCrkEq7IzBJ8ORdrxk9a1qWi05iMEBoKo1GN2rbAUYvq',1771491847197276,NULL,'2026-02-19 09:04:07'),(12,12,NULL,0,'$2b$12$IJkbiCQ6zk/g5K63BNh7aOFvovUGLGCsR0cugnOSgE/uvuE2nInS2',1771493280960558,NULL,'2026-02-19 09:28:00'),(13,13,NULL,0,'$2b$12$OlLOpe/GPMktChnxQlIENeCTjAwBCXYnl5/SnylyhuaNKpVkhjt0G',1771493281390002,NULL,'2026-02-19 09:28:01');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('18dbeaf20ea84dd285deaf14397f09ee','93437950a15445e8843848fe3d1336e9-b2ad0b40-ebd0-43d3-bbd3-611445e','{}','Heat stack user project',1,'4ee5a380c4124051a28464fd6435d39a','4ee5a380c4124051a28464fd6435d39a',0),('1d2ada14d79d4762b37fcb533272a8e7','93437950a15445e8843848fe3d1336e9-0cb91895-818b-45ce-96f9-becf071','{}','Heat stack user project',1,'4ee5a380c4124051a28464fd6435d39a','4ee5a380c4124051a28464fd6435d39a',0),('2f060ffe0e4f4d0b89392e1573f74a20','93437950a15445e8843848fe3d1336e9-6260f36c-df83-4820-8dd8-9cd9f6f','{}','Heat stack user project',1,'4ee5a380c4124051a28464fd6435d39a','4ee5a380c4124051a28464fd6435d39a',0),('305a6cf8a1eb4a25bed011dfabf38b34','93437950a15445e8843848fe3d1336e9-1eb57bcc-a4df-4905-aaa6-fb07c28','{}','Heat stack user project',1,'4ee5a380c4124051a28464fd6435d39a','4ee5a380c4124051a28464fd6435d39a',0),('36500efc027a4965a43a690ab8c9df90','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0),('4ee5a380c4124051a28464fd6435d39a','heat_stack','{}','Domain for Heat stacks',1,'<<keystone.domain.root>>',NULL,1),('57e340cf13ed49439edf5a13879d16b9','service','{}','service',1,'default','default',0),('5ca71d816d404779a4b44e2c0bdc1a75','93437950a15445e8843848fe3d1336e9-b746c133-ba4f-462f-804e-68f51e2','{}','Heat stack user project',1,'4ee5a380c4124051a28464fd6435d39a','4ee5a380c4124051a28464fd6435d39a',0),('7f1fbf0bef52488a975f00adb98e6b90','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('93437950a15445e8843848fe3d1336e9','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1),('edc6a2cd42ca4322bcecbc3106b46306','93437950a15445e8843848fe3d1336e9-c3c868ba-7067-4d77-b716-f0f6f51','{}','Heat stack user project',1,'4ee5a380c4124051a28464fd6435d39a','4ee5a380c4124051a28464fd6435d39a',0);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=163 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,NULL,NULL,'375fdf3bc1814ecdbb8f6a0b1aab77ad',NULL,NULL,'2026-02-19 09:29:14',NULL,'2026-02-19 09:29:14',NULL,NULL),(2,NULL,'940e23e09dbe44be8796a86e829cb717',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:29:16',NULL,'2026-02-19 09:29:16',NULL,NULL),(3,NULL,NULL,NULL,NULL,'b64e50c9063a483dbcf45e9d27b1eb37',NULL,NULL,'2026-02-19 09:29:18',NULL,'2026-02-19 09:29:18',NULL,NULL),(4,NULL,'bbb22fb469d94113ad624a33b5dc5290',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:29:20',NULL,'2026-02-19 09:29:20',NULL,NULL),(5,NULL,NULL,NULL,NULL,'62b991f5c10b485cbf9c272bbe33d513',NULL,NULL,'2026-02-19 09:29:22',NULL,'2026-02-19 09:29:22',NULL,NULL),(6,NULL,'011b52bdfbbc4502a242a821a168c2bc',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:29:23',NULL,'2026-02-19 09:29:23',NULL,NULL),(7,NULL,NULL,NULL,NULL,'a116758ba72a43dab3b6e962eade117f',NULL,NULL,'2026-02-19 09:29:24',NULL,'2026-02-19 09:29:24',NULL,NULL),(8,NULL,'dcdbe5e4c0a346bd924e8faadc14b8f9',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:29:24',NULL,'2026-02-19 09:29:24',NULL,NULL),(9,NULL,NULL,NULL,NULL,'7f0aee0b4cf14b658eba1511e4586d2b',NULL,NULL,'2026-02-19 09:29:24',NULL,'2026-02-19 09:29:24',NULL,NULL),(10,NULL,'087d453519c442cd93d50f294da76195',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:29:25',NULL,'2026-02-19 09:29:25',NULL,NULL),(11,NULL,NULL,NULL,NULL,'c7e11a7d506e4141803bcfa564453583',NULL,NULL,'2026-02-19 09:29:25',NULL,'2026-02-19 09:29:25',NULL,NULL),(12,NULL,'217e36110c3646419ffef3d8b66d2d9b',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:29:26',NULL,'2026-02-19 09:29:26',NULL,NULL),(13,NULL,NULL,NULL,NULL,'59285af7db7447a290965e94ca5246aa',NULL,NULL,'2026-02-19 09:29:38',NULL,'2026-02-19 09:29:38',NULL,NULL),(14,NULL,'2b62b63c6526468f817fb697ca635576',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:29:39',NULL,'2026-02-19 09:29:39',NULL,NULL),(15,NULL,NULL,NULL,NULL,'00698d8e4b70433c9ab9372b44064462',NULL,NULL,'2026-02-19 09:29:52',NULL,'2026-02-19 09:29:52',NULL,NULL),(16,NULL,'329149b21fbc44439530999e4f87705a',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:29:53',NULL,'2026-02-19 09:29:53',NULL,NULL),(17,NULL,NULL,NULL,NULL,'81454a23c80d40bfa9cf1848a6c96751',NULL,NULL,'2026-02-19 09:29:53',NULL,'2026-02-19 09:29:53',NULL,NULL),(18,NULL,'a67c01a3d68540288819b1991d2d56f1',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:29:54',NULL,'2026-02-19 09:29:54',NULL,NULL),(19,NULL,NULL,NULL,NULL,'a69372df9bb646d4af9134b745253ecc',NULL,NULL,'2026-02-19 09:30:05',NULL,'2026-02-19 09:30:05',NULL,NULL),(20,NULL,'f69c6efa4f8349208fdc65a103fb2e91',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:30:06',NULL,'2026-02-19 09:30:06',NULL,NULL),(21,NULL,NULL,NULL,NULL,'fc0dc2c7d8ec422f9f9ab7abfa0613dd',NULL,NULL,'2026-02-19 09:30:14',NULL,'2026-02-19 09:30:14',NULL,NULL),(22,NULL,NULL,NULL,NULL,'c341389aeaa8414f8bc510798853aa9c',NULL,NULL,'2026-02-19 09:30:15',NULL,'2026-02-19 09:30:15',NULL,NULL),(23,NULL,'e73c318d73c846d1af2ab55122037830',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:30:15',NULL,'2026-02-19 09:30:15',NULL,NULL),(24,NULL,'26935c0c363443179e033af35551faf5',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:30:15',NULL,'2026-02-19 09:30:15',NULL,NULL),(25,NULL,NULL,NULL,NULL,'770f17025fdc4a1987edab8a5566b9e3',NULL,NULL,'2026-02-19 09:30:21',NULL,'2026-02-19 09:30:21',NULL,NULL),(26,NULL,'64ace0d977314cf7bfc1efd255ce31c7',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:30:21',NULL,'2026-02-19 09:30:21',NULL,NULL),(27,NULL,NULL,NULL,NULL,'86cc7847bdc847aaa6437aa999f87003',NULL,NULL,'2026-02-19 09:30:34',NULL,'2026-02-19 09:30:34',NULL,NULL),(28,NULL,'008a491121274ff19703b8728247dacf',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:30:35',NULL,'2026-02-19 09:30:35',NULL,NULL),(29,NULL,NULL,NULL,NULL,'f4be31cdfe2040be911c110d2ebef6e6',NULL,NULL,'2026-02-19 09:30:37',NULL,'2026-02-19 09:30:37',NULL,NULL),(30,NULL,'6f58e5ff817142738223fd89100a391c',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:30:37',NULL,'2026-02-19 09:30:37',NULL,NULL),(31,NULL,NULL,NULL,NULL,'c25746ba144a4f0fab5ad352a2031660',NULL,NULL,'2026-02-19 09:30:53',NULL,'2026-02-19 09:30:53',NULL,NULL),(32,NULL,'84fd98c7da634d639c570cd000f5ce7b',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:30:53',NULL,'2026-02-19 09:30:53',NULL,NULL),(33,NULL,NULL,NULL,NULL,'abbac6f7cf2345d6aa928d2545357535',NULL,NULL,'2026-02-19 09:31:03',NULL,'2026-02-19 09:31:03',NULL,NULL),(34,NULL,'bb2140f589c843a3846494a81181bb97',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:31:04',NULL,'2026-02-19 09:31:04',NULL,NULL),(35,NULL,NULL,NULL,NULL,'19113fa0444e4ea5aaa98ed071c68265',NULL,NULL,'2026-02-19 09:31:04',NULL,'2026-02-19 09:31:04',NULL,NULL),(36,NULL,'7f1f8b80afaf4a31addbfbd68f1ea80d',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:31:05',NULL,'2026-02-19 09:31:05',NULL,NULL),(37,NULL,NULL,NULL,NULL,'eef9764b4eb64d27b0010845c10195de',NULL,NULL,'2026-02-19 09:31:17',NULL,'2026-02-19 09:31:17',NULL,NULL),(38,NULL,'40bcb493e12f4df19c9a0ab4a3311a53',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:31:17',NULL,'2026-02-19 09:31:17',NULL,NULL),(39,NULL,NULL,NULL,NULL,'cf90d861e93b428e93e6e65dab16b7f0',NULL,NULL,'2026-02-19 09:31:17',NULL,'2026-02-19 09:31:17',NULL,NULL),(40,NULL,'eac2a755dcfd4d468409b89dfb5bac55',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:31:18',NULL,'2026-02-19 09:31:18',NULL,NULL),(41,NULL,NULL,NULL,NULL,'7a7db74f72ec4373aa2ffb81a367076d',NULL,NULL,'2026-02-19 09:31:33',NULL,'2026-02-19 09:31:33',NULL,NULL),(42,NULL,'8f32e2fcdffc44a28f5ad4aa95add6cf',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:31:34',NULL,'2026-02-19 09:31:34',NULL,NULL),(43,NULL,NULL,NULL,NULL,'200ecaab8973457596bcc6e41a491a84',NULL,NULL,'2026-02-19 09:31:40',NULL,'2026-02-19 09:31:40',NULL,NULL),(44,NULL,'c97da4e331b44931a9f251ec9fe5a02a',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:31:42',NULL,'2026-02-19 09:31:42',NULL,NULL),(45,NULL,NULL,NULL,NULL,'e5caeb771f8940bbb7345de197b6e867',NULL,NULL,'2026-02-19 09:31:48',NULL,'2026-02-19 09:31:48',NULL,NULL),(46,NULL,'15ec61c141934351a5daba9400f6fe1a',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:31:48',NULL,'2026-02-19 09:31:48',NULL,NULL),(47,NULL,NULL,NULL,NULL,'8b539010b7a149298dc3421d4be4b192',NULL,NULL,'2026-02-19 09:31:49',NULL,'2026-02-19 09:31:49',NULL,NULL),(48,NULL,'d468ed84929346faa1b8453fead450c2',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:31:49',NULL,'2026-02-19 09:31:49',NULL,NULL),(49,NULL,NULL,NULL,NULL,'f021f2536ca24c6c941d8fe72825245a',NULL,NULL,'2026-02-19 09:31:54',NULL,'2026-02-19 09:31:54',NULL,NULL),(50,NULL,'91d6192b9fea44deaffa04a0cd7a03c2',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:31:55',NULL,'2026-02-19 09:31:55',NULL,NULL),(51,NULL,NULL,NULL,NULL,'54a446a160f040318a26248e1cedb629',NULL,NULL,'2026-02-19 09:32:19',NULL,'2026-02-19 09:32:19',NULL,NULL),(52,NULL,'cf1f28aad3f742d2a5afb61f7cd30616',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:32:19',NULL,'2026-02-19 09:32:19',NULL,NULL),(53,NULL,NULL,NULL,NULL,'66e58a787eeb4669b0caf2cc934dd429',NULL,NULL,'2026-02-19 09:32:32',NULL,'2026-02-19 09:32:32',NULL,NULL),(54,NULL,'36957296fb8c4544ac468f07b7bb4473',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:32:32',NULL,'2026-02-19 09:32:32',NULL,NULL),(55,NULL,NULL,NULL,NULL,'2540a086154e43f993a1875ba3bf9101',NULL,NULL,'2026-02-19 09:32:37',NULL,'2026-02-19 09:32:37',NULL,NULL),(56,NULL,'ecc7d44993b34940b17606e084803a5a',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:32:37',NULL,'2026-02-19 09:32:37',NULL,NULL),(57,NULL,NULL,NULL,NULL,'ee1bfc393abe40d6b8c9d1783ff94198',NULL,NULL,'2026-02-19 09:32:38',NULL,'2026-02-19 09:32:38',NULL,NULL),(58,NULL,'c1aa8c29ce1e403c8918fa5045ce5e0e',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:32:39',NULL,'2026-02-19 09:32:39',NULL,NULL),(59,NULL,NULL,NULL,NULL,'5730faf83c1746aebe2fd961ebc8e126',NULL,NULL,'2026-02-19 09:32:51',NULL,'2026-02-19 09:32:51',NULL,NULL),(60,NULL,'1f2032fe27594c45a56bf9f14df99b0c',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:32:52',NULL,'2026-02-19 09:32:52',NULL,NULL),(61,NULL,NULL,NULL,NULL,'873f2689003543c29dd2d510453e2b26',NULL,NULL,'2026-02-19 09:32:55',NULL,'2026-02-19 09:32:55',NULL,NULL),(62,NULL,'d38b437ac3c043809499bb89738edc4e',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:32:55',NULL,'2026-02-19 09:32:55',NULL,NULL),(63,NULL,NULL,NULL,NULL,'c0b2a740726149b599afd836b993d368',NULL,NULL,'2026-02-19 09:32:56',NULL,'2026-02-19 09:32:56',NULL,NULL),(64,NULL,'3ef2bea20db3493b96efdaec31be763a',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:32:57',NULL,'2026-02-19 09:32:57',NULL,NULL),(65,NULL,NULL,NULL,NULL,'b80241b203d84e2ea7012afb8ce310ea',NULL,NULL,'2026-02-19 09:33:05',NULL,'2026-02-19 09:33:05',NULL,NULL),(66,NULL,'a4084caaecb74e6c95529c40c40b7737',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:33:06',NULL,'2026-02-19 09:33:06',NULL,NULL),(67,NULL,NULL,NULL,NULL,'f89a4c34be904eb89e1fb048dac6d98f',NULL,NULL,'2026-02-19 09:33:09',NULL,'2026-02-19 09:33:09',NULL,NULL),(68,NULL,'9b6c81e6b672418f8459544037d49ad9',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:33:09',NULL,'2026-02-19 09:33:09',NULL,NULL),(69,NULL,NULL,NULL,NULL,'47c0d116b8954c94a05c836db4eed82b',NULL,NULL,'2026-02-19 09:33:12',NULL,'2026-02-19 09:33:12',NULL,NULL),(70,NULL,'5ee5e9e0d80342dc9c0b53a807109522',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:33:13',NULL,'2026-02-19 09:33:13',NULL,NULL),(71,NULL,NULL,NULL,NULL,'06e740475be24bc19949cd70b6787d52',NULL,NULL,'2026-02-19 09:33:13',NULL,'2026-02-19 09:33:13',NULL,NULL),(72,NULL,'e8c53492f3104efcbcdc29712d5d52fe',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:33:14',NULL,'2026-02-19 09:33:14',NULL,NULL),(73,NULL,NULL,NULL,NULL,'8e159279661d4c9da45bf15fb85d0e2b',NULL,NULL,'2026-02-19 09:33:22',NULL,'2026-02-19 09:33:22',NULL,NULL),(74,NULL,NULL,NULL,NULL,'446df1758ab54403bc5cfe4c93f42955',NULL,NULL,'2026-02-19 09:33:22',NULL,'2026-02-19 09:33:22',NULL,NULL),(75,NULL,'b3afbba6b576448fb632431ea2672c36',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:33:22',NULL,'2026-02-19 09:33:22',NULL,NULL),(76,NULL,'98b86629d0d44b1faf134a417ac2d1d8',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:33:23',NULL,'2026-02-19 09:33:23',NULL,NULL),(77,NULL,NULL,NULL,NULL,'dd4170a376cb4cbf950a90942fa9b23d',NULL,NULL,'2026-02-19 09:33:27',NULL,'2026-02-19 09:33:27',NULL,NULL),(78,NULL,'b1938b1b91404a5e957d12140cd80715',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:33:27',NULL,'2026-02-19 09:33:27',NULL,NULL),(79,NULL,NULL,NULL,NULL,'e456eae8226a4a9991f140f71cecd0ae',NULL,NULL,'2026-02-19 09:33:27',NULL,'2026-02-19 09:33:27',NULL,NULL),(80,NULL,'a5f12e4d54254596877f89079324f4c3',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:33:28',NULL,'2026-02-19 09:33:28',NULL,NULL),(81,NULL,NULL,NULL,NULL,'1847c3dc156c4d8a9681e4ff5912f768',NULL,NULL,'2026-02-19 09:33:43',NULL,'2026-02-19 09:33:43',NULL,NULL),(82,NULL,'f2c958339e824459aa2c817a479ab858',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:33:44',NULL,'2026-02-19 09:33:44',NULL,NULL),(83,NULL,NULL,NULL,NULL,'6d12769990d24a238ef659c9296fbd49',NULL,NULL,'2026-02-19 09:33:54',NULL,'2026-02-19 09:33:54',NULL,NULL),(84,NULL,NULL,NULL,NULL,'86ec1e7d80c54acb9c167762f8ac6db1',NULL,NULL,'2026-02-19 09:33:54',NULL,'2026-02-19 09:33:54',NULL,NULL),(85,NULL,'ebab2dfcc2814249a44d54771af45306',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:33:55',NULL,'2026-02-19 09:33:55',NULL,NULL),(86,NULL,'9a368ad9b2ed4a35aeb1d1c8d7ba5454',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:33:55',NULL,'2026-02-19 09:33:55',NULL,NULL),(87,NULL,NULL,NULL,NULL,'86949bb4b1114eda8981a6f40d33e6ea',NULL,NULL,'2026-02-19 09:33:55',NULL,'2026-02-19 09:33:55',NULL,NULL),(88,NULL,'d6149514b5994bb79b8a26c14d46f702',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:33:56',NULL,'2026-02-19 09:33:56',NULL,NULL),(89,NULL,NULL,NULL,NULL,'663a1c23dad244ae9c52d9e9b4ff3882',NULL,NULL,'2026-02-19 09:34:00',NULL,'2026-02-19 09:34:00',NULL,NULL),(90,NULL,'af12d13646a24ca8a93202824eede662',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:34:01',NULL,'2026-02-19 09:34:01',NULL,NULL),(91,NULL,NULL,NULL,NULL,'aa0f91957040412b9683ecdcc2767ed9',NULL,NULL,'2026-02-19 09:34:04',NULL,'2026-02-19 09:34:04',NULL,NULL),(92,NULL,'7d90d016768449e183079752072c9cd2',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:34:04',NULL,'2026-02-19 09:34:04',NULL,NULL),(93,NULL,NULL,NULL,NULL,'af0a76c3f5a84227b87e311a6c55fda3',NULL,NULL,'2026-02-19 09:34:10',NULL,'2026-02-19 09:34:10',NULL,NULL),(94,NULL,'538cd036bc9d400ba774fd3817f63e2c',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:34:10',NULL,'2026-02-19 09:34:10',NULL,NULL),(95,NULL,NULL,NULL,NULL,'35a33a36d64e427895606642298888b1',NULL,NULL,'2026-02-19 09:34:16',NULL,'2026-02-19 09:34:16',NULL,NULL),(96,NULL,NULL,NULL,NULL,'4ae483d621594cd99de8be6ef83b1933',NULL,NULL,'2026-02-19 09:34:16',NULL,'2026-02-19 09:34:16',NULL,NULL),(97,NULL,'68fc02fbaf7f42fcb47cc2bf10e52db2',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:34:17',NULL,'2026-02-19 09:34:17',NULL,NULL),(98,NULL,'d97e22108a4344e5a7f697ef08985068',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:34:17',NULL,'2026-02-19 09:34:17',NULL,NULL),(99,NULL,NULL,NULL,NULL,'4742ef226d3c42a1abaaec903f032e72',NULL,NULL,'2026-02-19 09:34:20',NULL,'2026-02-19 09:34:20',NULL,NULL),(100,NULL,'ead5248fe3ca4c9f95dcad4ab6277756',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:34:21',NULL,'2026-02-19 09:34:21',NULL,NULL),(101,NULL,NULL,NULL,NULL,'9391336e287a4ef1a43d987d5b15855b',NULL,NULL,'2026-02-19 09:34:39',NULL,'2026-02-19 09:34:39',NULL,NULL),(102,NULL,NULL,NULL,NULL,'918907ad18b24a098b0a01d978a1cd7e',NULL,NULL,'2026-02-19 09:34:39',NULL,'2026-02-19 09:34:39',NULL,NULL),(103,NULL,'f9f36817d68d400d9d0e3525263574f7',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:34:40',NULL,'2026-02-19 09:34:40',NULL,NULL),(104,NULL,'859c53443b264f45914085ad5fdfcc93',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:34:40',NULL,'2026-02-19 09:34:40',NULL,NULL),(105,NULL,NULL,NULL,NULL,'103803e239fd4e4b9c85070ed8e3f149',NULL,NULL,'2026-02-19 09:35:03',NULL,'2026-02-19 09:35:03',NULL,NULL),(106,NULL,'c6685fd8b8ec4af992f9ebc80951dd9e',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:35:04',NULL,'2026-02-19 09:35:04',NULL,NULL),(107,NULL,NULL,'57974c373d99413abb12e3575956960c',NULL,NULL,NULL,NULL,'2026-02-19 09:35:20',NULL,'2026-02-19 09:35:20',NULL,NULL),(108,NULL,NULL,'a8bbbc3b22774a93bdd443274dfa7640',NULL,NULL,NULL,NULL,'2026-02-19 09:35:24',NULL,'2026-02-19 09:35:24',NULL,NULL),(109,NULL,NULL,'4f904c73997f49faa28be7fc9294a124',NULL,NULL,NULL,NULL,'2026-02-19 09:35:24',NULL,'2026-02-19 09:35:24',NULL,NULL),(110,NULL,NULL,NULL,NULL,'663a6796b2e14ab0beeafcd1e70d79ba',NULL,NULL,'2026-02-19 09:35:25',NULL,'2026-02-19 09:35:25',NULL,NULL),(111,NULL,'5f030bfe49b047b687b6eaffbecb2b4a',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:35:25',NULL,'2026-02-19 09:35:25',NULL,NULL),(112,NULL,NULL,NULL,NULL,'5a36446aefcd46a2acf1ddb2b9dbe56f',NULL,NULL,'2026-02-19 09:35:31',NULL,'2026-02-19 09:35:31',NULL,NULL),(113,NULL,'35c9ee59d5984f129825e62afe8e8e54',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:35:32',NULL,'2026-02-19 09:35:32',NULL,NULL),(114,NULL,NULL,NULL,NULL,'f37aa35d0d284b69958c99ad71e9cf59',NULL,NULL,'2026-02-19 09:35:37',NULL,'2026-02-19 09:35:37',NULL,NULL),(115,NULL,'51f75f5301264591a6dde21d8bb9ba40',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:35:38',NULL,'2026-02-19 09:35:38',NULL,NULL),(116,NULL,NULL,NULL,NULL,'9c7f488629f044e68966f814f33c0dc8',NULL,NULL,'2026-02-19 09:35:38',NULL,'2026-02-19 09:35:38',NULL,NULL),(117,NULL,'537fcae0608c4e6cbcdb019fbc564e32',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:35:39',NULL,'2026-02-19 09:35:39',NULL,NULL),(118,NULL,NULL,'4672fbf5727c4c41b3e5755df9c30060',NULL,NULL,NULL,NULL,'2026-02-19 09:35:41',NULL,'2026-02-19 09:35:41',NULL,NULL),(119,NULL,NULL,'dfb22852af9b4103bce5dd10114082de',NULL,NULL,NULL,NULL,'2026-02-19 09:35:42',NULL,'2026-02-19 09:35:42',NULL,NULL),(120,NULL,NULL,'3139c04184134a90a20e1d6d66e5d9eb',NULL,NULL,NULL,NULL,'2026-02-19 09:35:43',NULL,'2026-02-19 09:35:43',NULL,NULL),(121,NULL,NULL,NULL,NULL,'190050de752847c2b4dfc4ce870e9256',NULL,NULL,'2026-02-19 09:35:43',NULL,'2026-02-19 09:35:43',NULL,NULL),(122,NULL,'0aeeb8b1ff2b40ef95809ab674c46204',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:35:43',NULL,'2026-02-19 09:35:43',NULL,NULL),(123,NULL,NULL,NULL,NULL,'8b8a2bd787fa4f358af97fb4f7b76aa4',NULL,NULL,'2026-02-19 09:35:53',NULL,'2026-02-19 09:35:53',NULL,NULL),(124,NULL,'23f40b0b1adc4071b0f02ac359393f7d',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:35:54',NULL,'2026-02-19 09:35:54',NULL,NULL),(125,NULL,NULL,'10e9999c79204ed9ae0369127412851f',NULL,NULL,NULL,NULL,'2026-02-19 09:36:03',NULL,'2026-02-19 09:36:03',NULL,NULL),(126,NULL,NULL,'24dba7f0dc204f3ab4ad22d01ad2084a',NULL,NULL,NULL,NULL,'2026-02-19 09:36:03',NULL,'2026-02-19 09:36:03',NULL,NULL),(127,NULL,NULL,'70e2b0cf8dc14b609251c7401cc92ed1',NULL,NULL,NULL,NULL,'2026-02-19 09:36:04',NULL,'2026-02-19 09:36:04',NULL,NULL),(128,NULL,NULL,NULL,NULL,'7156bb246f364d9f96d1e2472bfa3d45',NULL,NULL,'2026-02-19 09:36:07',NULL,'2026-02-19 09:36:07',NULL,NULL),(129,NULL,'4fe22a7f62654cdd8b00dcf161c89b73',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:36:08',NULL,'2026-02-19 09:36:08',NULL,NULL),(130,NULL,NULL,NULL,NULL,'7be7021a3ed947abaf541db5e6d53940',NULL,NULL,'2026-02-19 09:36:22',NULL,'2026-02-19 09:36:22',NULL,NULL),(131,NULL,'1650377cea0f4d94a482de9c52bcb705',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:36:22',NULL,'2026-02-19 09:36:22',NULL,NULL),(132,NULL,NULL,'2d8ba95767fe498a8285b73d83fef7c8',NULL,NULL,NULL,NULL,'2026-02-19 09:36:29',NULL,'2026-02-19 09:36:29',NULL,NULL),(133,NULL,NULL,'482981a92c604b3f8ecb241c637cc03e',NULL,NULL,NULL,NULL,'2026-02-19 09:36:29',NULL,'2026-02-19 09:36:29',NULL,NULL),(134,NULL,NULL,'39d2d7dd568f4746ba5fffc90c3c6e68',NULL,NULL,NULL,NULL,'2026-02-19 09:36:32',NULL,'2026-02-19 09:36:32',NULL,NULL),(135,NULL,NULL,NULL,NULL,'aecb7ddb450947879ef0087a89117685',NULL,NULL,'2026-02-19 09:36:33',NULL,'2026-02-19 09:36:33',NULL,NULL),(136,NULL,'03bf221e1a954f9c842dc6087b77e814',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:36:34',NULL,'2026-02-19 09:36:34',NULL,NULL),(137,NULL,NULL,'bfc566c9c01846c6b88a546a2fa38a50',NULL,NULL,NULL,NULL,'2026-02-19 09:36:34',NULL,'2026-02-19 09:36:34',NULL,NULL),(138,NULL,NULL,'54cc136675d148a097fbd27a9f4bc92c',NULL,NULL,NULL,NULL,'2026-02-19 09:36:34',NULL,'2026-02-19 09:36:34',NULL,NULL),(139,NULL,NULL,NULL,NULL,'75ef65a95b4947038e9bb00f6f0a7bdf',NULL,NULL,'2026-02-19 09:36:37',NULL,'2026-02-19 09:36:37',NULL,NULL),(140,NULL,'c4ffe1190c1d433692a00e684fcd500c',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:36:37',NULL,'2026-02-19 09:36:37',NULL,NULL),(141,NULL,NULL,'02a6bc19892c4d439d30f7330c9d2afc',NULL,NULL,NULL,NULL,'2026-02-19 09:36:57',NULL,'2026-02-19 09:36:57',NULL,NULL),(142,NULL,NULL,'3dc46c05b6fd4d849c38059f81ac8758',NULL,NULL,NULL,NULL,'2026-02-19 09:36:58',NULL,'2026-02-19 09:36:58',NULL,NULL),(143,NULL,NULL,'f8636ee7757d407e9a309fc45490b475',NULL,NULL,NULL,NULL,'2026-02-19 09:36:58',NULL,'2026-02-19 09:36:58',NULL,NULL),(144,NULL,NULL,NULL,NULL,'79353b38c73147b9b4a443bc31626b61',NULL,NULL,'2026-02-19 09:36:59',NULL,'2026-02-19 09:36:59',NULL,NULL),(145,NULL,NULL,'0bebf4e446464f6a92c94e9d346dcc5c',NULL,NULL,NULL,NULL,'2026-02-19 09:36:59',NULL,'2026-02-19 09:36:59',NULL,NULL),(146,NULL,'748cbc2b930d4c4497d794f7e42cf9c5',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:36:59',NULL,'2026-02-19 09:36:59',NULL,NULL),(147,NULL,NULL,NULL,NULL,'d06cc21d25c14754844e7458f64c4fc1',NULL,NULL,'2026-02-19 09:37:00',NULL,'2026-02-19 09:37:00',NULL,NULL),(148,NULL,NULL,'6a091c43ff054bc399002d3dae61030c',NULL,NULL,NULL,NULL,'2026-02-19 09:37:00',NULL,'2026-02-19 09:37:00',NULL,NULL),(149,NULL,'6b866c7e036e4152aa23709023bcfcc7',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:37:00',NULL,'2026-02-19 09:37:00',NULL,NULL),(150,NULL,NULL,NULL,NULL,'63c879aabc6944aaa4506b568c2c8809',NULL,NULL,'2026-02-19 09:37:01',NULL,'2026-02-19 09:37:01',NULL,NULL),(151,NULL,'126762f8222749628bae104cd11bb1ab',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:37:01',NULL,'2026-02-19 09:37:01',NULL,NULL),(152,NULL,NULL,'441bcc21defe4cae80755d773ad12987',NULL,NULL,NULL,NULL,'2026-02-19 09:37:05',NULL,'2026-02-19 09:37:05',NULL,NULL),(153,NULL,NULL,NULL,NULL,'587232af15dd4efd8937a44d197816aa',NULL,NULL,'2026-02-19 09:37:08',NULL,'2026-02-19 09:37:08',NULL,NULL),(154,NULL,'e1ce563280024959bff0d3b565264f86',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:37:09',NULL,'2026-02-19 09:37:09',NULL,NULL),(155,NULL,NULL,'b71861bfe80c403085d0cbf7f3c7fb52',NULL,NULL,NULL,NULL,'2026-02-19 09:38:40',NULL,'2026-02-19 09:38:40',NULL,NULL),(156,NULL,NULL,'7a1f5e31e5a94b18a1a5c0d1263f7d01',NULL,NULL,NULL,NULL,'2026-02-19 09:38:41',NULL,'2026-02-19 09:38:41',NULL,NULL),(157,NULL,NULL,'86eb9b7c838f4db39da20c942bc42f8b',NULL,NULL,NULL,NULL,'2026-02-19 09:38:42',NULL,'2026-02-19 09:38:42',NULL,NULL),(158,NULL,NULL,NULL,NULL,'8838ee515b974230806d1d24d942950f',NULL,NULL,'2026-02-19 09:38:43',NULL,'2026-02-19 09:38:43',NULL,NULL),(159,NULL,'abe58cc9071e47d2a3444fe76310fc22',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:38:43',NULL,'2026-02-19 09:38:43',NULL,NULL),(160,NULL,NULL,'cf333b1534754a2ea8ac9d2bce8693c1',NULL,NULL,NULL,NULL,'2026-02-19 09:38:45',NULL,'2026-02-19 09:38:45',NULL,NULL),(161,NULL,NULL,NULL,NULL,'f679f3fc7ddf47458076aba3f12400cb',NULL,NULL,'2026-02-19 09:38:50',NULL,'2026-02-19 09:38:50',NULL,NULL),(162,NULL,'9b7135b4f0cb44129443db5913c15085',NULL,NULL,NULL,NULL,NULL,'2026-02-19 09:38:50',NULL,'2026-02-19 09:38:50',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('058de4416c964001a4279726263a2d10','admin','{}','<<null>>',NULL),('25fbeac817574c62a53a4bb2d75ef16b','SwiftSystemReader','{}','<<null>>',NULL),('43725660f26d45798b3251b23ea9f377','reader','{}','<<null>>',NULL),('4b48b50db03845ac95a08f099d4bfd61','swiftoperator','{}','<<null>>',NULL),('5908ea7cd8934b11a6ceff609d332c1a','heat_stack_user','{}','<<null>>',NULL),('60319f91e66248b5840a4848ad3bde8c','SwiftProjectReader','{}','<<null>>',NULL),('6309c915b52a4916be4d7ca7a2d20e1d','member','{}','<<null>>',NULL),('6d6f6e5e5a184e0db9e303dee3db9e65','service','{}','<<null>>',NULL),('c827c448135c47f5bf95d8edef2e35fc','ResellerAdmin','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('058de4416c964001a4279726263a2d10','IMMU','true'),('43725660f26d45798b3251b23ea9f377','IMMU','true'),('6309c915b52a4916be4d7ca7a2d20e1d','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('1259045fb03d4301aaa0e34a86aadcc6','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('15b5105960844a22a345dac866c17e02','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('25fed5e82ed745a8b060547d41a7921b','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('3379f76e48af4eb4b06894e91e7219e9','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('3a6fa37370564070ae13817f5211710d','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('8377aa4a3d634628936591e1ce51bbe0','identity',1,'{\"name\": \"keystone\"}'),('d98e6e400fd6407297998a0d41374734','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('dbb66774be1e416781e8f4d99c8b9e1d','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('dc9d9e8ab85e45159dac50ee1f94c80c','object-store',1,'{\"description\": \"Swift Object Storage\", \"name\": \"swift\"}'),('e1a78ecd6e6043da81e38f895587ec7d','orchestration',1,'{\"description\": \"Heat API service\", \"name\": \"heat\"}'),('ec581c10a1424798859b0477d68845ea','cloudformation',1,'{\"description\": \"Heat Cloudformation API service\", \"name\": \"heat-cfn\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','37c67ac801574c38b9866c4f7c3d6511','system','058de4416c964001a4279726263a2d10',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_user_id` (`user_id`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_trust_id` (`trust_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
INSERT INTO `trust` (`id`, `trustor_user_id`, `trustee_user_id`, `project_id`, `impersonation`, `deleted_at`, `expires_at`, `remaining_uses`, `extra`, `expires_at_int`, `redelegated_trust_id`, `redelegation_count`) VALUES ('00698d8e4b70433c9ab9372b44064462','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:29:52',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('06e740475be24bc19949cd70b6787d52','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:33:13',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('103803e239fd4e4b9c85070ed8e3f149','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:35:03',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('1847c3dc156c4d8a9681e4ff5912f768','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:33:43',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('190050de752847c2b4dfc4ce870e9256','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:35:43',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('19113fa0444e4ea5aaa98ed071c68265','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:31:04',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('200ecaab8973457596bcc6e41a491a84','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:31:40',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('2540a086154e43f993a1875ba3bf9101','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:32:37',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('35a33a36d64e427895606642298888b1','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:34:16',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('375fdf3bc1814ecdbb8f6a0b1aab77ad','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:29:14',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('436395f48a9d48dd91027a29c8514979','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('439e3a8b7f384529b5805566ff78200c','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('446df1758ab54403bc5cfe4c93f42955','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:33:22',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('4742ef226d3c42a1abaaec903f032e72','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:34:20',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('47c0d116b8954c94a05c836db4eed82b','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:33:12',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('4ae483d621594cd99de8be6ef83b1933','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:34:16',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('54a446a160f040318a26248e1cedb629','37c67ac801574c38b9866c4f7c3d6511','6b8943f1b87d4d2e98016273885505cb','36500efc027a4965a43a690ab8c9df90',1,'2026-02-19 09:32:19',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"058de4416c964001a4279726263a2d10\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('5730faf83c1746aebe2fd961ebc8e126','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:32:51',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('587232af15dd4efd8937a44d197816aa','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:37:08',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('5914af70c88c404a80bc8e9a2cb4b802','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('59285af7db7447a290965e94ca5246aa','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:29:38',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('5a36446aefcd46a2acf1ddb2b9dbe56f','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:35:31',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('62b991f5c10b485cbf9c272bbe33d513','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:29:22',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('63c879aabc6944aaa4506b568c2c8809','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:37:01',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('663a1c23dad244ae9c52d9e9b4ff3882','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:34:00',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('663a6796b2e14ab0beeafcd1e70d79ba','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:35:25',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('66e58a787eeb4669b0caf2cc934dd429','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:32:31',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('6d12769990d24a238ef659c9296fbd49','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:33:54',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('7156bb246f364d9f96d1e2472bfa3d45','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:36:07',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('75ef65a95b4947038e9bb00f6f0a7bdf','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:36:37',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('770f17025fdc4a1987edab8a5566b9e3','37c67ac801574c38b9866c4f7c3d6511','6b8943f1b87d4d2e98016273885505cb','36500efc027a4965a43a690ab8c9df90',1,'2026-02-19 09:30:21',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"058de4416c964001a4279726263a2d10\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('79353b38c73147b9b4a443bc31626b61','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:36:59',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('7a7db74f72ec4373aa2ffb81a367076d','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:31:33',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('7be7021a3ed947abaf541db5e6d53940','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:36:22',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('7f0aee0b4cf14b658eba1511e4586d2b','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:29:24',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('80e1aa6973ab4fc0be0587483029c696','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('81454a23c80d40bfa9cf1848a6c96751','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:29:53',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('86949bb4b1114eda8981a6f40d33e6ea','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:33:55',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('86cc7847bdc847aaa6437aa999f87003','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:30:34',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('86ec1e7d80c54acb9c167762f8ac6db1','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:33:54',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('873f2689003543c29dd2d510453e2b26','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:32:55',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('8838ee515b974230806d1d24d942950f','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:38:43',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('88795a42b5c641bf838e638686c5b03f','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('8b539010b7a149298dc3421d4be4b192','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:31:49',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('8b8a2bd787fa4f358af97fb4f7b76aa4','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:35:53',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('8e159279661d4c9da45bf15fb85d0e2b','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:33:22',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('918907ad18b24a098b0a01d978a1cd7e','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:34:39',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('9391336e287a4ef1a43d987d5b15855b','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:34:39',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('9c7f488629f044e68966f814f33c0dc8','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:35:38',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('a116758ba72a43dab3b6e962eade117f','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:29:24',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('a69372df9bb646d4af9134b745253ecc','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:30:05',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('aa0f91957040412b9683ecdcc2767ed9','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:34:04',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('abbac6f7cf2345d6aa928d2545357535','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:31:03',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('aecb7ddb450947879ef0087a89117685','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:36:33',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('af0a76c3f5a84227b87e311a6c55fda3','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:34:10',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('b64e50c9063a483dbcf45e9d27b1eb37','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:29:18',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('b80241b203d84e2ea7012afb8ce310ea','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:33:05',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('c0b2a740726149b599afd836b993d368','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:32:56',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('c2057e5eca664e1e939ffdaf084e35d9','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('c25746ba144a4f0fab5ad352a2031660','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:30:53',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('c341389aeaa8414f8bc510798853aa9c','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:30:15',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('c7e11a7d506e4141803bcfa564453583','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:29:25',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('cf90d861e93b428e93e6e65dab16b7f0','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:31:17',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('d06cc21d25c14754844e7458f64c4fc1','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:37:00',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('dd4170a376cb4cbf950a90942fa9b23d','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:33:27',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('e456eae8226a4a9991f140f71cecd0ae','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:33:27',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('e5caeb771f8940bbb7345de197b6e867','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:31:48',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('ee1bfc393abe40d6b8c9d1783ff94198','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:32:38',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('eef9764b4eb64d27b0010845c10195de','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:31:17',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('f021f2536ca24c6c941d8fe72825245a','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:31:54',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('f37aa35d0d284b69958c99ad71e9cf59','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:35:37',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('f4be31cdfe2040be911c110d2ebef6e6','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:30:37',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('f679f3fc7ddf47458076aba3f12400cb','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:38:50',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('f89a4c34be904eb89e1fb048dac6d98f','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:33:09',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0),('fc0dc2c7d8ec422f9f9ab7abfa0613dd','da63d65ec0a1494aabbda731e00918ab','6b8943f1b87d4d2e98016273885505cb','93437950a15445e8843848fe3d1336e9',1,'2026-02-19 09:30:14',NULL,NULL,'{\"roles\": [{\"id\": \"6309c915b52a4916be4d7ca7a2d20e1d\"}, {\"id\": \"43725660f26d45798b3251b23ea9f377\"}]}',NULL,NULL,0);
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
INSERT INTO `trust_role` (`trust_id`, `role_id`) VALUES ('00698d8e4b70433c9ab9372b44064462','43725660f26d45798b3251b23ea9f377'),('00698d8e4b70433c9ab9372b44064462','6309c915b52a4916be4d7ca7a2d20e1d'),('06e740475be24bc19949cd70b6787d52','43725660f26d45798b3251b23ea9f377'),('06e740475be24bc19949cd70b6787d52','6309c915b52a4916be4d7ca7a2d20e1d'),('103803e239fd4e4b9c85070ed8e3f149','43725660f26d45798b3251b23ea9f377'),('103803e239fd4e4b9c85070ed8e3f149','6309c915b52a4916be4d7ca7a2d20e1d'),('1847c3dc156c4d8a9681e4ff5912f768','43725660f26d45798b3251b23ea9f377'),('1847c3dc156c4d8a9681e4ff5912f768','6309c915b52a4916be4d7ca7a2d20e1d'),('190050de752847c2b4dfc4ce870e9256','43725660f26d45798b3251b23ea9f377'),('190050de752847c2b4dfc4ce870e9256','6309c915b52a4916be4d7ca7a2d20e1d'),('19113fa0444e4ea5aaa98ed071c68265','43725660f26d45798b3251b23ea9f377'),('19113fa0444e4ea5aaa98ed071c68265','6309c915b52a4916be4d7ca7a2d20e1d'),('200ecaab8973457596bcc6e41a491a84','43725660f26d45798b3251b23ea9f377'),('200ecaab8973457596bcc6e41a491a84','6309c915b52a4916be4d7ca7a2d20e1d'),('2540a086154e43f993a1875ba3bf9101','43725660f26d45798b3251b23ea9f377'),('2540a086154e43f993a1875ba3bf9101','6309c915b52a4916be4d7ca7a2d20e1d'),('35a33a36d64e427895606642298888b1','43725660f26d45798b3251b23ea9f377'),('35a33a36d64e427895606642298888b1','6309c915b52a4916be4d7ca7a2d20e1d'),('375fdf3bc1814ecdbb8f6a0b1aab77ad','43725660f26d45798b3251b23ea9f377'),('375fdf3bc1814ecdbb8f6a0b1aab77ad','6309c915b52a4916be4d7ca7a2d20e1d'),('436395f48a9d48dd91027a29c8514979','43725660f26d45798b3251b23ea9f377'),('436395f48a9d48dd91027a29c8514979','6309c915b52a4916be4d7ca7a2d20e1d'),('439e3a8b7f384529b5805566ff78200c','43725660f26d45798b3251b23ea9f377'),('439e3a8b7f384529b5805566ff78200c','6309c915b52a4916be4d7ca7a2d20e1d'),('446df1758ab54403bc5cfe4c93f42955','43725660f26d45798b3251b23ea9f377'),('446df1758ab54403bc5cfe4c93f42955','6309c915b52a4916be4d7ca7a2d20e1d'),('4742ef226d3c42a1abaaec903f032e72','43725660f26d45798b3251b23ea9f377'),('4742ef226d3c42a1abaaec903f032e72','6309c915b52a4916be4d7ca7a2d20e1d'),('47c0d116b8954c94a05c836db4eed82b','43725660f26d45798b3251b23ea9f377'),('47c0d116b8954c94a05c836db4eed82b','6309c915b52a4916be4d7ca7a2d20e1d'),('4ae483d621594cd99de8be6ef83b1933','43725660f26d45798b3251b23ea9f377'),('4ae483d621594cd99de8be6ef83b1933','6309c915b52a4916be4d7ca7a2d20e1d'),('54a446a160f040318a26248e1cedb629','058de4416c964001a4279726263a2d10'),('54a446a160f040318a26248e1cedb629','43725660f26d45798b3251b23ea9f377'),('54a446a160f040318a26248e1cedb629','6309c915b52a4916be4d7ca7a2d20e1d'),('5730faf83c1746aebe2fd961ebc8e126','43725660f26d45798b3251b23ea9f377'),('5730faf83c1746aebe2fd961ebc8e126','6309c915b52a4916be4d7ca7a2d20e1d'),('587232af15dd4efd8937a44d197816aa','43725660f26d45798b3251b23ea9f377'),('587232af15dd4efd8937a44d197816aa','6309c915b52a4916be4d7ca7a2d20e1d'),('5914af70c88c404a80bc8e9a2cb4b802','43725660f26d45798b3251b23ea9f377'),('5914af70c88c404a80bc8e9a2cb4b802','6309c915b52a4916be4d7ca7a2d20e1d'),('59285af7db7447a290965e94ca5246aa','43725660f26d45798b3251b23ea9f377'),('59285af7db7447a290965e94ca5246aa','6309c915b52a4916be4d7ca7a2d20e1d'),('5a36446aefcd46a2acf1ddb2b9dbe56f','43725660f26d45798b3251b23ea9f377'),('5a36446aefcd46a2acf1ddb2b9dbe56f','6309c915b52a4916be4d7ca7a2d20e1d'),('62b991f5c10b485cbf9c272bbe33d513','43725660f26d45798b3251b23ea9f377'),('62b991f5c10b485cbf9c272bbe33d513','6309c915b52a4916be4d7ca7a2d20e1d'),('63c879aabc6944aaa4506b568c2c8809','43725660f26d45798b3251b23ea9f377'),('63c879aabc6944aaa4506b568c2c8809','6309c915b52a4916be4d7ca7a2d20e1d'),('663a1c23dad244ae9c52d9e9b4ff3882','43725660f26d45798b3251b23ea9f377'),('663a1c23dad244ae9c52d9e9b4ff3882','6309c915b52a4916be4d7ca7a2d20e1d'),('663a6796b2e14ab0beeafcd1e70d79ba','43725660f26d45798b3251b23ea9f377'),('663a6796b2e14ab0beeafcd1e70d79ba','6309c915b52a4916be4d7ca7a2d20e1d'),('66e58a787eeb4669b0caf2cc934dd429','43725660f26d45798b3251b23ea9f377'),('66e58a787eeb4669b0caf2cc934dd429','6309c915b52a4916be4d7ca7a2d20e1d'),('6d12769990d24a238ef659c9296fbd49','43725660f26d45798b3251b23ea9f377'),('6d12769990d24a238ef659c9296fbd49','6309c915b52a4916be4d7ca7a2d20e1d'),('7156bb246f364d9f96d1e2472bfa3d45','43725660f26d45798b3251b23ea9f377'),('7156bb246f364d9f96d1e2472bfa3d45','6309c915b52a4916be4d7ca7a2d20e1d'),('75ef65a95b4947038e9bb00f6f0a7bdf','43725660f26d45798b3251b23ea9f377'),('75ef65a95b4947038e9bb00f6f0a7bdf','6309c915b52a4916be4d7ca7a2d20e1d'),('770f17025fdc4a1987edab8a5566b9e3','058de4416c964001a4279726263a2d10'),('770f17025fdc4a1987edab8a5566b9e3','43725660f26d45798b3251b23ea9f377'),('770f17025fdc4a1987edab8a5566b9e3','6309c915b52a4916be4d7ca7a2d20e1d'),('79353b38c73147b9b4a443bc31626b61','43725660f26d45798b3251b23ea9f377'),('79353b38c73147b9b4a443bc31626b61','6309c915b52a4916be4d7ca7a2d20e1d'),('7a7db74f72ec4373aa2ffb81a367076d','43725660f26d45798b3251b23ea9f377'),('7a7db74f72ec4373aa2ffb81a367076d','6309c915b52a4916be4d7ca7a2d20e1d'),('7be7021a3ed947abaf541db5e6d53940','43725660f26d45798b3251b23ea9f377'),('7be7021a3ed947abaf541db5e6d53940','6309c915b52a4916be4d7ca7a2d20e1d'),('7f0aee0b4cf14b658eba1511e4586d2b','43725660f26d45798b3251b23ea9f377'),('7f0aee0b4cf14b658eba1511e4586d2b','6309c915b52a4916be4d7ca7a2d20e1d'),('80e1aa6973ab4fc0be0587483029c696','43725660f26d45798b3251b23ea9f377'),('80e1aa6973ab4fc0be0587483029c696','6309c915b52a4916be4d7ca7a2d20e1d'),('81454a23c80d40bfa9cf1848a6c96751','43725660f26d45798b3251b23ea9f377'),('81454a23c80d40bfa9cf1848a6c96751','6309c915b52a4916be4d7ca7a2d20e1d'),('86949bb4b1114eda8981a6f40d33e6ea','43725660f26d45798b3251b23ea9f377'),('86949bb4b1114eda8981a6f40d33e6ea','6309c915b52a4916be4d7ca7a2d20e1d'),('86cc7847bdc847aaa6437aa999f87003','43725660f26d45798b3251b23ea9f377'),('86cc7847bdc847aaa6437aa999f87003','6309c915b52a4916be4d7ca7a2d20e1d'),('86ec1e7d80c54acb9c167762f8ac6db1','43725660f26d45798b3251b23ea9f377'),('86ec1e7d80c54acb9c167762f8ac6db1','6309c915b52a4916be4d7ca7a2d20e1d'),('873f2689003543c29dd2d510453e2b26','43725660f26d45798b3251b23ea9f377'),('873f2689003543c29dd2d510453e2b26','6309c915b52a4916be4d7ca7a2d20e1d'),('8838ee515b974230806d1d24d942950f','43725660f26d45798b3251b23ea9f377'),('8838ee515b974230806d1d24d942950f','6309c915b52a4916be4d7ca7a2d20e1d'),('88795a42b5c641bf838e638686c5b03f','43725660f26d45798b3251b23ea9f377'),('88795a42b5c641bf838e638686c5b03f','6309c915b52a4916be4d7ca7a2d20e1d'),('8b539010b7a149298dc3421d4be4b192','43725660f26d45798b3251b23ea9f377'),('8b539010b7a149298dc3421d4be4b192','6309c915b52a4916be4d7ca7a2d20e1d'),('8b8a2bd787fa4f358af97fb4f7b76aa4','43725660f26d45798b3251b23ea9f377'),('8b8a2bd787fa4f358af97fb4f7b76aa4','6309c915b52a4916be4d7ca7a2d20e1d'),('8e159279661d4c9da45bf15fb85d0e2b','43725660f26d45798b3251b23ea9f377'),('8e159279661d4c9da45bf15fb85d0e2b','6309c915b52a4916be4d7ca7a2d20e1d'),('918907ad18b24a098b0a01d978a1cd7e','43725660f26d45798b3251b23ea9f377'),('918907ad18b24a098b0a01d978a1cd7e','6309c915b52a4916be4d7ca7a2d20e1d'),('9391336e287a4ef1a43d987d5b15855b','43725660f26d45798b3251b23ea9f377'),('9391336e287a4ef1a43d987d5b15855b','6309c915b52a4916be4d7ca7a2d20e1d'),('9c7f488629f044e68966f814f33c0dc8','43725660f26d45798b3251b23ea9f377'),('9c7f488629f044e68966f814f33c0dc8','6309c915b52a4916be4d7ca7a2d20e1d'),('a116758ba72a43dab3b6e962eade117f','43725660f26d45798b3251b23ea9f377'),('a116758ba72a43dab3b6e962eade117f','6309c915b52a4916be4d7ca7a2d20e1d'),('a69372df9bb646d4af9134b745253ecc','43725660f26d45798b3251b23ea9f377'),('a69372df9bb646d4af9134b745253ecc','6309c915b52a4916be4d7ca7a2d20e1d'),('aa0f91957040412b9683ecdcc2767ed9','43725660f26d45798b3251b23ea9f377'),('aa0f91957040412b9683ecdcc2767ed9','6309c915b52a4916be4d7ca7a2d20e1d'),('abbac6f7cf2345d6aa928d2545357535','43725660f26d45798b3251b23ea9f377'),('abbac6f7cf2345d6aa928d2545357535','6309c915b52a4916be4d7ca7a2d20e1d'),('aecb7ddb450947879ef0087a89117685','43725660f26d45798b3251b23ea9f377'),('aecb7ddb450947879ef0087a89117685','6309c915b52a4916be4d7ca7a2d20e1d'),('af0a76c3f5a84227b87e311a6c55fda3','43725660f26d45798b3251b23ea9f377'),('af0a76c3f5a84227b87e311a6c55fda3','6309c915b52a4916be4d7ca7a2d20e1d'),('b64e50c9063a483dbcf45e9d27b1eb37','43725660f26d45798b3251b23ea9f377'),('b64e50c9063a483dbcf45e9d27b1eb37','6309c915b52a4916be4d7ca7a2d20e1d'),('b80241b203d84e2ea7012afb8ce310ea','43725660f26d45798b3251b23ea9f377'),('b80241b203d84e2ea7012afb8ce310ea','6309c915b52a4916be4d7ca7a2d20e1d'),('c0b2a740726149b599afd836b993d368','43725660f26d45798b3251b23ea9f377'),('c0b2a740726149b599afd836b993d368','6309c915b52a4916be4d7ca7a2d20e1d'),('c2057e5eca664e1e939ffdaf084e35d9','43725660f26d45798b3251b23ea9f377'),('c2057e5eca664e1e939ffdaf084e35d9','6309c915b52a4916be4d7ca7a2d20e1d'),('c25746ba144a4f0fab5ad352a2031660','43725660f26d45798b3251b23ea9f377'),('c25746ba144a4f0fab5ad352a2031660','6309c915b52a4916be4d7ca7a2d20e1d'),('c341389aeaa8414f8bc510798853aa9c','43725660f26d45798b3251b23ea9f377'),('c341389aeaa8414f8bc510798853aa9c','6309c915b52a4916be4d7ca7a2d20e1d'),('c7e11a7d506e4141803bcfa564453583','43725660f26d45798b3251b23ea9f377'),('c7e11a7d506e4141803bcfa564453583','6309c915b52a4916be4d7ca7a2d20e1d'),('cf90d861e93b428e93e6e65dab16b7f0','43725660f26d45798b3251b23ea9f377'),('cf90d861e93b428e93e6e65dab16b7f0','6309c915b52a4916be4d7ca7a2d20e1d'),('d06cc21d25c14754844e7458f64c4fc1','43725660f26d45798b3251b23ea9f377'),('d06cc21d25c14754844e7458f64c4fc1','6309c915b52a4916be4d7ca7a2d20e1d'),('dd4170a376cb4cbf950a90942fa9b23d','43725660f26d45798b3251b23ea9f377'),('dd4170a376cb4cbf950a90942fa9b23d','6309c915b52a4916be4d7ca7a2d20e1d'),('e456eae8226a4a9991f140f71cecd0ae','43725660f26d45798b3251b23ea9f377'),('e456eae8226a4a9991f140f71cecd0ae','6309c915b52a4916be4d7ca7a2d20e1d'),('e5caeb771f8940bbb7345de197b6e867','43725660f26d45798b3251b23ea9f377'),('e5caeb771f8940bbb7345de197b6e867','6309c915b52a4916be4d7ca7a2d20e1d'),('ee1bfc393abe40d6b8c9d1783ff94198','43725660f26d45798b3251b23ea9f377'),('ee1bfc393abe40d6b8c9d1783ff94198','6309c915b52a4916be4d7ca7a2d20e1d'),('eef9764b4eb64d27b0010845c10195de','43725660f26d45798b3251b23ea9f377'),('eef9764b4eb64d27b0010845c10195de','6309c915b52a4916be4d7ca7a2d20e1d'),('f021f2536ca24c6c941d8fe72825245a','43725660f26d45798b3251b23ea9f377'),('f021f2536ca24c6c941d8fe72825245a','6309c915b52a4916be4d7ca7a2d20e1d'),('f37aa35d0d284b69958c99ad71e9cf59','43725660f26d45798b3251b23ea9f377'),('f37aa35d0d284b69958c99ad71e9cf59','6309c915b52a4916be4d7ca7a2d20e1d'),('f4be31cdfe2040be911c110d2ebef6e6','43725660f26d45798b3251b23ea9f377'),('f4be31cdfe2040be911c110d2ebef6e6','6309c915b52a4916be4d7ca7a2d20e1d'),('f679f3fc7ddf47458076aba3f12400cb','43725660f26d45798b3251b23ea9f377'),('f679f3fc7ddf47458076aba3f12400cb','6309c915b52a4916be4d7ca7a2d20e1d'),('f89a4c34be904eb89e1fb048dac6d98f','43725660f26d45798b3251b23ea9f377'),('f89a4c34be904eb89e1fb048dac6d98f','6309c915b52a4916be4d7ca7a2d20e1d'),('fc0dc2c7d8ec422f9f9ab7abfa0613dd','43725660f26d45798b3251b23ea9f377'),('fc0dc2c7d8ec422f9f9ab7abfa0613dd','6309c915b52a4916be4d7ca7a2d20e1d');
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('16808460159f42828023b199a4c3a6b1','{}',1,'57e340cf13ed49439edf5a13879d16b9','2026-02-19 09:03:15','2026-02-19','default'),('37c67ac801574c38b9866c4f7c3d6511','{}',1,NULL,'2026-02-19 09:01:44','2026-02-19','default'),('4d4293ae62374cb8ac0be9bad2f617eb','{}',1,NULL,'2026-02-19 09:03:25','2026-02-19','4ee5a380c4124051a28464fd6435d39a'),('6912a5864acc43c38ae28082a64b7db4','{}',1,'57e340cf13ed49439edf5a13879d16b9','2026-02-19 09:03:24','2026-02-19','default'),('6b8943f1b87d4d2e98016273885505cb','{}',1,'57e340cf13ed49439edf5a13879d16b9','2026-02-19 09:04:07','2026-02-19','default'),('76a011a687974006ae00f335ff21a4ea','{\"tenantId\": \"7f1fbf0bef52488a975f00adb98e6b90\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2026-02-19 09:28:01',NULL,'default'),('b2ac073e05ab4933bc1576296ea3c972','{}',1,'57e340cf13ed49439edf5a13879d16b9','2026-02-19 09:03:20','2026-02-19','default'),('c2838cf908fd4ff0a4284ecdc84615aa','{}',1,'57e340cf13ed49439edf5a13879d16b9','2026-02-19 09:03:12',NULL,'default'),('d0b1ef089d954346aa5038c67a96687c','{}',1,'57e340cf13ed49439edf5a13879d16b9','2026-02-19 09:03:56','2026-02-19','default'),('d49b4bb3b2b0495890a850f14f236d6f','{}',1,'57e340cf13ed49439edf5a13879d16b9','2026-02-19 09:03:08','2026-02-19','default'),('da63d65ec0a1494aabbda731e00918ab','{\"tenantId\": \"93437950a15445e8843848fe3d1336e9\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2026-02-19 09:28:01','2026-02-19','default'),('e149acefe43d4ca3b3d5ba653d9b7122','{}',1,'57e340cf13ed49439edf5a13879d16b9','2026-02-19 09:03:33','2026-02-19','default'),('fd47ff942d744d7db62a74fc0da3ceac','{}',1,'57e340cf13ed49439edf5a13879d16b9','2026-02-19 09:03:17','2026-02-19','default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','keystone','keystone_ab60','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','placement','placement_4f7d','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_ab60','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_4f7d','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','glance','glance_1d7e','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_1d7e','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_fbfe','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_fbfe','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','heat','heat_07bb','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','heat','heat_07bb','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_0317','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_0317','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_b159','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_b159','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_d128','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_d128','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_9025','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_9025','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1771491650}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1771491650}'),('localhost','keystone_ab60','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*DC9BCCF76EFFAC2F980366D7499065EC67B4D0CC\",\"password_last_changed\":1771491643}'),('localhost','placement_4f7d','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*250C130767C5257FC60CF78982A0FCE6F82823D3\",\"password_last_changed\":1771491643}'),('%','keystone_ab60','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*DC9BCCF76EFFAC2F980366D7499065EC67B4D0CC\",\"password_last_changed\":1771491643}'),('%','placement_4f7d','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*250C130767C5257FC60CF78982A0FCE6F82823D3\",\"password_last_changed\":1771491643}'),('localhost','glance_1d7e','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*2D8F3825834443A46FA2917381609C5571AB9BB6\",\"password_last_changed\":1771491650}'),('%','glance_1d7e','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*2D8F3825834443A46FA2917381609C5571AB9BB6\",\"password_last_changed\":1771491650}'),('localhost','cinder_fbfe','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*4344F74089358A312425AFFC8BA1AD7AB26651C1\",\"password_last_changed\":1771491688}'),('%','cinder_fbfe','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*4344F74089358A312425AFFC8BA1AD7AB26651C1\",\"password_last_changed\":1771491688}'),('localhost','heat_07bb','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*77D3E79E8AF75A9DB968C42C2FE1E97550F42C55\",\"password_last_changed\":1771491688}'),('%','heat_07bb','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*77D3E79E8AF75A9DB968C42C2FE1E97550F42C55\",\"password_last_changed\":1771491688}'),('localhost','neutron_0317','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B90F719D07C408D458530685C52C3686503C2D46\",\"password_last_changed\":1771491688}'),('%','neutron_0317','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B90F719D07C408D458530685C52C3686503C2D46\",\"password_last_changed\":1771491688}'),('localhost','barbican_b159','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*1F8B95B3B12C906D22BBAD98E21906748A5F8AD5\",\"password_last_changed\":1771491689}'),('%','barbican_b159','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*1F8B95B3B12C906D22BBAD98E21906748A5F8AD5\",\"password_last_changed\":1771491689}'),('localhost','nova_api_d128','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*6A0145DEC4F3D58B902387A45E7E7F73E2588054\",\"password_last_changed\":1771491803}'),('%','nova_api_d128','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*6A0145DEC4F3D58B902387A45E7E7F73E2588054\",\"password_last_changed\":1771491803}'),('localhost','nova_cell0_9025','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*1EDDAD59821FCACC7FE5AC9C02F511E7770B4B63\",\"password_last_changed\":1771491804}'),('%','nova_cell0_9025','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*1EDDAD59821FCACC7FE5AC9C02F511E7770B4B63\",\"password_last_changed\":1771491804}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mysql_plugin\n-------------------------------------\n\nA plugin can be installed with the mysql_plugin utility if the server is\ncompletely offline.\n\nThe syntax is:\n\nmysql_plugin [options] <plugin> ENABLE|DISABLE\n\nFor example, to install the server_audit audit plugin, you could execute the\nfollowing:\n\nmysql_plugin server_audit ENABLE\n\nIf a plugin is installed with this utility, then a record will be added to the\nmysql.plugins table for the plugin. This means that the plugin will\nautomatically be loaded every time the server restarts, unless specifically\nuninstalled or deactivated.\n\nConfiguring the Plugin Directory\n--------------------------------\n\nWhen a plugin is being installed, the server looks for the plugin\'s library in\nthe server\'s plugin directory. This directory is configured by the plugin_dir\nsystem variable. This can be specified as a command-line argument to mysqld or\nit can be specified in a relevant server option group in an option file. For\nexample:\n\n[mariadb]\n...\nplugin_dir = /usr/lib64/mysql/plugin\n\nConfiguring the Minimum Plugin Maturity\n---------------------------------------\n\nWhen a plugin is being installed, the server compares the plugin\'s maturity\nlevel against the server\'s minimum allowed plugin maturity. This can help\nprevent users from using unstable plugins on production servers. This minimum\nplugin maturity is configured by the plugin_maturity system variable. This can\nbe specified as a command-line argument to mysqld or it can be specified in a\nrelevant server option group in an option file. For example:\n\n[mariadb]\n...\nplugin_maturity = stable\n\nConfiguring Plugin Activation at Server Startup\n-----------------------------------------------\n\nA plugin will be loaded by default when the server starts if:\n\n* The plugin was installed with the INSTALL SONAME statement.\n* The plugin was installed with the INSTALL PLUGIN statement.\n* The plugin was installed with the mysql_plugin utility.\n* The server is configured to load the plugin with the --plugin-load-add\noption.\n* The server is configured to load the plugin with the --plugin-load option.\n\nThis behavior can be changed with special options that take the form\n--plugin-name. For example, for the server_audit audit plugin, the special\noption is called --server-audit.\n\nThe possible values for these special options are:\n\n+---------------------------------------+------------------------------------+\n| Option Value                          | Description                        |\n+---------------------------------------+------------------------------------+\n| OFF                                   | Disables the plugin without        |\n|                                       | removing it from the               |\n|                                       | mysql.plugins table.               |\n+---------------------------------------+------------------------------------+\n| ON                                    | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will still continue         |\n|                                       | starting up, but the plugin will   |\n|                                       | be disabled.                       |\n+---------------------------------------+------------------------------------+\n| FORCE                                 | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error.                             |\n+---------------------------------------+------------------------------------+\n| FORCE_PLUS_PERMANENT                  | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error. In addition, the plugin     |\n|                                       | cannot be uninstalled with         |\n|                                       | UNINSTALL SONAME or UNINSTALL      |\n|                                       | PLUGIN while the server is         |\n|                                       | running.                           |\n+---------------------------------------+------------------------------------+\n\nA plugin\'s status can be found by looking at the PLUGIN_STATUS column of the\ninformation_schema.PLUGINS table.\n\nUninstalling Plugins\n--------------------\n\nPlugins that are found in the mysql.plugin table, that is those that were\ninstalled with INSTALL SONAME, INSTALL PLUGIN or mysql_plugin can be\nuninstalled in one of two ways:\n\n* The UNINSTALL SONAME or the UNINSTALL PLUGIN statement while the server is\nrunning\n* With mysql_plugin while the server is offline.\n\nPlugins that were enabled as a --plugin-load option do not need to be\nuninstalled. If --plugin-load is omitted the next time the server starts, or\nthe plugin is not listed as one of the --plugin-load entries, the plugin will\nnot be loaded.\n\nUNINSTALL PLUGIN uninstalls a single installed plugin, while UNINSTALL SONAME\nuninstalls all plugins belonging to a given library.\n\nURL: https://mariadb.com/kb/en/plugin-overview/','','https://mariadb.com/kb/en/plugin-overview/'),(79,'MBR Definition',6,'Description\n-----------\n\nThe MBR (Minimum Bounding Rectangle), or Envelope is the bounding geometry,\nformed by the minimum and maximum (X,Y) coordinates:\n\nExamples\n--------\n\n((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nURL: https://mariadb.com/kb/en/mbr-definition/','','https://mariadb.com/kb/en/mbr-definition/'),(80,'MBRContains',6,'Syntax\n------\n\nMBRContains(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\ncontains the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\n\nSET @g2 = GeomFromText(\'Point(1 1)\');\n\nSELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n+----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrcontains/','','https://mariadb.com/kb/en/mbrcontains/'),(82,'MBREqual',6,'Syntax\n------\n\nMBREqual(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are the same.\n\nExamples\n--------\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 2)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 2, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 3)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 4, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 0 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/mbrequal/','','https://mariadb.com/kb/en/mbrequal/'),(86,'MBRWithin',6,'Syntax\n------\n\nMBRWithin(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1 is\nwithin the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRContains().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nSELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n\nURL: https://mariadb.com/kb/en/mbrwithin/','','https://mariadb.com/kb/en/mbrwithin/'),(75,'UNINSTALL PLUGIN',5,'Syntax\n------\n\nUNINSTALL PLUGIN [IF EXISTS] plugin_name\n\nDescription\n-----------\n\nThis statement removes a single installed plugin. To uninstall the whole\nlibrary which contains the plugin, use UNINSTALL SONAME. You cannot uninstall\na plugin if any table that uses it is open.\n\nplugin_name must be the name of some plugin that is listed in the mysql.plugin\ntable. The server executes the plugin\'s deinitialization function and removes\nthe row for the plugin from the mysql.plugin table, so that subsequent server\nrestarts will not load and initialize the plugin. UNINSTALL PLUGIN does not\nremove the plugin\'s shared library file.\n\nTo use UNINSTALL PLUGIN, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nUNINSTALL PLUGIN example;\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------+\n| Level | Code | Message                       |\n+-------+------+-------------------------------+\n| Note  | 1305 | PLUGIN example does not exist |\n+-------+------+-------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-plugin/','','https://mariadb.com/kb/en/uninstall-plugin/'),(76,'INSTALL SONAME',5,'Syntax\n------\n\nINSTALL SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of INSTALL PLUGIN. It installs all plugins from a\ngiven plugin_library. See INSTALL PLUGIN for details.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL SONAME adds one or more lines to the mysql.plugin table that describes\nthe plugin. This table contains the plugin name and library file name.\n\nINSTALL SONAME causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL SONAME also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL SONAME, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nSONAME only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nIf you need to install only one plugin from a library, use the INSTALL PLUGIN\nstatement.\n\nExamples\n--------\n\nTo load the XtraDB storage engine and all of its information_schema tables\nwith one statement, use\n\nINSTALL SONAME \'ha_xtradb\';\n\nThis statement can be used instead of INSTALL PLUGIN even when the library\ncontains only one plugin:\n\nINSTALL SONAME \'ha_sequence\';\n\nURL: https://mariadb.com/kb/en/install-soname/','','https://mariadb.com/kb/en/install-soname/'),(77,'UNINSTALL SONAME',5,'Syntax\n------\n\nUNINSTALL SONAME  [IF EXISTS] \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of UNINSTALL PLUGIN statement, that removes all\nplugins belonging to a specified plugin_library. See UNINSTALL PLUGIN for\ndetails.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nTo use UNINSTALL SONAME, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin library does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nTo uninstall the XtraDB plugin and all of its information_schema tables with\none statement, use\n\nUNINSTALL SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------------+\n| Level | Code | Message                             |\n+-------+------+-------------------------------------+\n| Note  | 1305 | SONAME ha_example.so does not exist |\n+-------+------+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-soname/','','https://mariadb.com/kb/en/uninstall-soname/'),(90,'NULLIF',7,'Syntax\n------\n\nNULLIF(expr1,expr2)\n\nDescription\n-----------\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is the\nsame as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nExamples\n--------\n\nSELECT NULLIF(1,1);\n+-------------+\n| NULLIF(1,1) |\n+-------------+\n|        NULL |\n+-------------+\n\nSELECT NULLIF(1,2);\n+-------------+\n| NULLIF(1,2) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/nullif/','','https://mariadb.com/kb/en/nullif/'),(91,'NVL',7,'MariaDB starting with 10.3\n--------------------------\nFrom MariaDB 10.3, NVL is a synonym for IFNULL.\n\nURL: https://mariadb.com/kb/en/nvl/','','https://mariadb.com/kb/en/nvl/'),(92,'NVL2',7,'MariaDB starting with 10.3\n--------------------------\nThe NLV2 function was introduced in MariaDB 10.3.0.\n\nSyntax\n------\n\nNVL2(expr1,expr2,expr3)\n\nDescription\n-----------\n\nThe NVL2 function returns a value based on whether a specified expression is\nNULL or not. If expr1 is not NULL, then NVL2 returns expr2. If expr1 is NULL,\nthen NVL2 returns expr3.\n\nExamples\n--------\n\nSELECT NVL2(NULL,1,2);\n+----------------+\n| NVL2(NULL,1,2) |\n+----------------+\n|              2 |\n+----------------+\n\nSELECT NVL2(\'x\',1,2);\n+---------------+\n| NVL2(\'x\',1,2) |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/nvl2/','','https://mariadb.com/kb/en/nvl2/'),(81,'MBRDisjoint',6,'Syntax\n------\n\nMBRDisjoint(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are disjoint. Two geometries are disjoint if they do not\nintersect, that is touch or overlap.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECTmbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrdisjoint/','','https://mariadb.com/kb/en/mbrdisjoint/'),(83,'MBRIntersects',6,'Syntax\n------\n\nMBRIntersects(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 intersect.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      1 |\n+------------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      0 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/mbrintersects/','','https://mariadb.com/kb/en/mbrintersects/'),(84,'MBROverlaps',6,'Syntax\n------\n\nMBROverlaps(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 overlap. The term spatially overlaps is used if two\ngeometries intersect and their intersection results in a geometry of the same\ndimension but not equal to either of the given geometries.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbroverlaps/','','https://mariadb.com/kb/en/mbroverlaps/'),(85,'MBRTouches',6,'Syntax\n------\n\nMBRTouches(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 touch. Two geometries spatially touch if the interiors of\nthe geometries do not intersect, but the boundary of one of the geometries\nintersects either the boundary or the interior of the other.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   1 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/mbrtouches/','','https://mariadb.com/kb/en/mbrtouches/'),(87,'CASE OPERATOR',7,'Syntax\n------\n\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nDescription\n-----------\n\nThe first version returns the result where value=compare_value. The second\nversion returns the result for the first condition that is true. If there was\nno matching result value, the result after ELSE is returned, or NULL if there\nis no ELSE part.\n\nThere is also a CASE statement, which differs from the CASE operator described\nhere.\n\nExamples\n--------\n\nSELECT CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END;\n+------------------------------------------------------------+\n| CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END |\n+------------------------------------------------------------+\n| one                                                        |\n+------------------------------------------------------------+\n\nSELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n+--------------------------------------------+\n| CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END |\n+--------------------------------------------+\n| true                                       |\n+--------------------------------------------+\n\nSELECT CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n+-----------------------------------------------------+\n| CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END |\n+-----------------------------------------------------+\n|                                                NULL |\n+-----------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/case-operator/','','https://mariadb.com/kb/en/case-operator/'),(101,'UNLOCK TABLES',8,'Syntax\n------\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\nSee LOCK TABLES for more information.\n\nIn addition to releasing table locks acquired by the LOCK TABLES statement,\nthe UNLOCK TABLES statement also releases the global read lock acquired by the\nFLUSH TABLES WITH READ LOCK statement. The FLUSH TABLES WITH READ LOCK\nstatement is very useful for performing backups. See FLUSH for more\ninformation about FLUSH TABLES WITH READ LOCK.\n\nURL: https://mariadb.com/kb/en/transactions-unlock-tables/','','https://mariadb.com/kb/en/transactions-unlock-tables/'),(103,'XA Transactions',8,'Overview\n--------\n\nThe MariaDB XA implementation is based on the X/Open CAE document Distributed\nTransaction Processing: The XA Specification. This document is published by\nThe Open Group and available at\nhttp://www.opengroup.org/public/pubs/catalog/c193.htm.\n\nXA transactions are designed to allow distributed transactions, where a\ntransaction manager (the application) controls a transaction which involves\nmultiple resources. Such resources are usually DBMSs, but could be resources\nof any type. The whole set of required transactional operations is called a\nglobal transaction. Each subset of operations which involve a single resource\nis called a local transaction. XA used a 2-phases commit (2PC). With the first\ncommit, the transaction manager tells each resource to prepare an effective\ncommit, and waits for a confirm message. The changes are not still made\neffective at this point. If any of the resources encountered an error, the\ntransaction manager will rollback the global transaction. If all resources\ncommunicate that the first commit is successful, the transaction manager can\nrequire a second commit, which makes the changes effective.\n\nIn MariaDB, XA transactions can only be used with storage engines that support\nthem. At least InnoDB, TokuDB, SPIDER and MyRocks support them. For InnoDB,\nuntil MariaDB 10.2, XA transactions can be disabled by setting the\ninnodb_support_xa server system variable to 0. From MariaDB 10.3, XA\ntransactions are always supported.\n\nLike regular transactions, XA transactions create metadata locks on accessed\ntables.\n\nXA transactions require REPEATABLE READ as a minimum isolation level. However,\ndistributed transactions should always use SERIALIZABLE.\n\nTrying to start more than one XA transaction at the same time produces a 1400\nerror (SQLSTATE \'XAE09\'). The same error is produced when attempting to start\nan XA transaction while a regular transaction is in effect. Trying to start a\nregular transaction while an XA transaction is in effect produces a 1399 error\n(SQLSTATE \'XAE07\').\n\nThe statements that cause an implicit C