/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
INSERT INTO `encrypted_data` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `content_type`, `secret_id`, `kek_id`, `cypher_text`, `kek_meta_extended`) VALUES ('6a5160b7-4ba9-468f-bcb3-7c57ac41dfaa','2026-01-23 10:50:40','2026-01-23 10:52:10','2026-01-23 10:52:10',1,'ACTIVE','application/octet-stream','70457a1c-4b64-474d-8489-dd7f91885f60','9dbbaead-4074-4fcd-abd3-47ee4d6459f1','Z0FBQUFBQnBjMUtBUUJXZm5lZndFRG9yUEd1UDhvMnRyZDdiNVB1Rm1FLTlxd193dmIxc2twLUpfSncwNEZvZDNqSVE2Yjh5OU1Sa1BwMkNJd2swUmZjbjQ1UnhNa3QxUlV0RWpnZDIzV2x0OGlzWm1sWnVKOUE0aGFybHBJOUowbVZ1Tl9pYzIwdEc=',NULL),('c2552c4c-8143-488c-b992-3bcbd42ce3ee','2026-01-23 10:40:27','2026-01-23 10:41:10','2026-01-23 10:41:10',1,'ACTIVE','application/octet-stream','d0a00c7e-e16a-4a37-9cd5-b0d2539f706b','af6eb267-78ee-4108-8f49-1a3e8cc95e1b','Z0FBQUFBQnBjMUFiYmFGay10UVZJWTVrN1pSYVo1TWwtbXRJOGNmSl9BOEE1SDZJc2pIUkZBUG5qNFBRNU1kdEtwQnl4ZldtWTJ1RVRHME9OZklYSmFpQU5KOGkzc0JlU0RJcmJRUEJlLTQzODZCZXlwb3BYR3ExRW1Zb3hoaWFEVHFtVGV1eTJFSlg=',NULL);
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
INSERT INTO `kek_data` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `plugin_name`, `kek_label`, `project_id`, `active`, `bind_completed`, `algorithm`, `bit_length`, `mode`, `plugin_meta`) VALUES ('9dbbaead-4074-4fcd-abd3-47ee4d6459f1','2026-01-23 10:50:40','2026-01-23 10:52:23','2026-01-23 10:52:23',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-9533be9d361246bdb0a7c1bd3015db66-key-9c58e4b0-d63a-4435-a432-b2d54cd446bf','900f27d6-5f17-4b7b-aa00-9458bc8d1f87',1,1,'aes',128,'cbc','gAAAAABpc1KATsrm5ALLp2eq66SmnVRW4FTtbvDxwe6J2z9h0Xf9PXK3ARRO5Agqtdt9Kwxay8QMQaDWbmgFGO2J81R2x2fzV03NTsBIxoWchhr5fvRYOt2ftHTD1jTCyhlnqyQSD-8X'),('af6eb267-78ee-4108-8f49-1a3e8cc95e1b','2026-01-23 10:40:26','2026-01-23 10:48:31','2026-01-23 10:48:31',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-d27c5465284b48a5818ef931d6251c43-key-c86d2aaa-83eb-464d-8a95-6696b9cb2b2d','eeaa6915-ee2a-412d-a998-e717558f529d',1,1,'aes',128,'cbc','gAAAAABpc1Ab6Wdsz5R0-MGZ0drdxMH_Y5wX9CyLtNMy3QhOk7OSrtaNcYu-DXdLXFhQkvSsNcQNaRtkila14qPIOQLBnoysClnPoEmvdNJMKNYHVivbpbM3DRPA4HGdXmuW4EuT4TEv');
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
INSERT INTO `orders` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `type`, `project_id`, `error_status_code`, `error_reason`, `meta`, `secret_id`, `container_id`, `sub_status`, `sub_status_message`, `creator_id`) VALUES ('6cb8ce47-2021-4bb0-a73c-3155e8ab05d4','2026-01-23 10:50:40','2026-01-23 10:50:40',NULL,0,'ACTIVE','key','900f27d6-5f17-4b7b-aa00-9458bc8d1f87',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','70457a1c-4b64-474d-8489-dd7f91885f60',NULL,'Unknown','Unknown','7d7e6f562c9d4d81bf1f8d5462870e30'),('c5b78106-93ca-417a-a0ea-4d357eef029c','2026-01-23 10:40:26','2026-01-23 10:40:27',NULL,0,'ACTIVE','key','eeaa6915-ee2a-412d-a998-e717558f529d',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','d0a00c7e-e16a-4a37-9cd5-b0d2539f706b',NULL,'Unknown','Unknown','eb70c3aee8b64273a1930c0c2c231aff');
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
INSERT INTO `projects` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `external_id`) VALUES ('900f27d6-5f17-4b7b-aa00-9458bc8d1f87','2026-01-23 10:50:40','2026-01-23 10:52:23','2026-01-23 10:52:23',1,'ACTIVE','9533be9d361246bdb0a7c1bd3015db66'),('eeaa6915-ee2a-412d-a998-e717558f529d','2026-01-23 10:40:26','2026-01-23 10:48:31','2026-01-23 10:48:31',1,'ACTIVE','d27c5465284b48a5818ef931d6251c43');
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
INSERT INTO `secret_store_metadata` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `key`, `value`, `secret_id`) VALUES ('754a55cf-00f9-4b80-9451-5e129c3e1f28','2026-01-23 10:50:40','2026-01-23 10:52:10','2026-01-23 10:52:10',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','70457a1c-4b64-474d-8489-dd7f91885f60'),('7ba3dbb9-1cfa-4ece-bbd0-08129292b0dc','2026-01-23 10:40:27','2026-01-23 10:41:10','2026-01-23 10:41:10',1,'PENDING','content_type','application/octet-stream','d0a00c7e-e16a-4a37-9cd5-b0d2539f706b'),('864dff36-48ca-46b4-b10e-0b964265eb56','2026-01-23 10:40:27','2026-01-23 10:41:10','2026-01-23 10:41:10',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','d0a00c7e-e16a-4a37-9cd5-b0d2539f706b'),('c13c8191-3d1f-4ef8-ad4d-52e23ad29d62','2026-01-23 10:50:40','2026-01-23 10:52:10','2026-01-23 10:52:10',1,'PENDING','content_type','application/octet-stream','70457a1c-4b64-474d-8489-dd7f91885f60');
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('b7ed8fab-cdf9-4817-921a-b72e26ec26da','2026-01-23 08:45:07','2026-01-23 08:45:07',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
INSERT INTO `secrets` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `name`, `secret_type`, `expiration`, `algorithm`, `bit_length`, `mode`, `creator_id`, `project_id`) VALUES ('70457a1c-4b64-474d-8489-dd7f91885f60','2026-01-23 10:50:40','2026-01-23 10:52:10','2026-01-23 10:52:10',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'7d7e6f562c9d4d81bf1f8d5462870e30','900f27d6-5f17-4b7b-aa00-9458bc8d1f87'),('d0a00c7e-e16a-4a37-9cd5-b0d2539f706b','2026-01-23 10:40:27','2026-01-23 10:41:10','2026-01-23 10:41:09',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'eb70c3aee8b64273a1930c0c2c231aff','eeaa6915-ee2a-412d-a998-e717558f529d');
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
INSERT INTO `backups` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `host`, `availability_zone`, `display_name`, `display_description`, `container`, `status`, `fail_reason`, `service_metadata`, `service`, `size`, `object_count`, `parent_id`, `temp_volume_id`, `temp_snapshot_id`, `num_dependent_backups`, `snapshot_id`, `data_timestamp`, `restore_volume_id`, `encryption_key_id`) VALUES ('2026-01-23 10:38:26','2026-01-23 10:39:32','2026-01-23 10:39:33',1,'b54f4406-f31d-49c0-9f6f-68fb7ec2c289','c5ce5b98-2b3d-4d0d-be73-68e3c174a3f2','9609ee98328640299138fa34258ef48f','95243c9b3c544aff8e9ee6043bb6f522','cinder-backup-0',NULL,'tempest-TestVolumeBackupRestore-backup-1696674545',NULL,'backups','deleted',NULL,'{\"base\": \"volume-c5ce5b98-2b3d-4d0d-be73-68e3c174a3f2.backup.b54f4406-f31d-49c0-9f6f-68fb7ec2c289\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:38:26','abf07740-6e5f-44bf-b631-41bec916b9fe',NULL);
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
INSERT INTO `encryption` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `cipher`, `control_location`, `key_size`, `provider`, `volume_type_id`, `encryption_id`) VALUES ('2026-01-23 10:40:25',NULL,'2026-01-23 10:41:11',1,'aes-xts-plain64','front-end',256,'luks','3f7f137e-c525-48d6-86f7-3c39c5a7bfe7','b8aa954a-485a-4ab1-9fd3-7760d9e6210c'),('2026-01-23 10:50:39',NULL,'2026-01-23 10:52:12',1,'aes-xts-plain64','front-end',256,'luks','5aae1df8-11ba-4d19-82a2-3f94199799e6','bfb668dc-e4bb-4e4e-b0e6-1a5767946f34');
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','996408b8-68ec-4202-b77d-344b1d7a1eab','2026-01-23 08:44:47','2026-01-23 08:44:47',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('996408b8-68ec-4202-b77d-344b1d7a1eab','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2026-01-23 08:44:47','2026-01-23 08:44:47',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2026-01-23 08:44:31',NULL,NULL,0,1,'default','volumes',10),('2026-01-23 08:44:31',NULL,NULL,0,2,'default','snapshots',10),('2026-01-23 08:44:31',NULL,NULL,0,3,'default','gigabytes',1000),('2026-01-23 08:44:31',NULL,NULL,0,4,'default','consistencygroups',10),('2026-01-23 08:44:31',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2026-01-23 08:44:31',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=147 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `race_preventer`) VALUES ('2026-01-23 09:29:04','2026-01-23 09:30:12',NULL,0,1,'649cf144e93c4123b8f11cac66308419','volumes',0,0,NULL,1),('2026-01-23 09:29:04','2026-01-23 09:30:12',NULL,0,2,'649cf144e93c4123b8f11cac66308419','gigabytes',0,0,NULL,1),('2026-01-23 09:29:04','2026-01-23 09:30:12',NULL,0,3,'649cf144e93c4123b8f11cac66308419','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 09:29:04','2026-01-23 09:30:12',NULL,0,4,'649cf144e93c4123b8f11cac66308419','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 09:31:39','2026-01-23 09:33:19',NULL,0,5,'c56e53b3339e4e4db30b7a9d330bc380','volumes',0,0,NULL,1),('2026-01-23 09:31:39','2026-01-23 09:33:19',NULL,0,6,'c56e53b3339e4e4db30b7a9d330bc380','gigabytes',0,0,NULL,1),('2026-01-23 09:31:39','2026-01-23 09:33:19',NULL,0,7,'c56e53b3339e4e4db30b7a9d330bc380','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 09:31:39','2026-01-23 09:33:19',NULL,0,8,'c56e53b3339e4e4db30b7a9d330bc380','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 09:36:59','2026-01-23 09:38:26',NULL,0,9,'d0dce6e339c349d4ab97cee5e49fff3a','volumes',0,0,NULL,1),('2026-01-23 09:36:59','2026-01-23 09:38:26',NULL,0,10,'d0dce6e339c349d4ab97cee5e49fff3a','gigabytes',0,0,NULL,1),('2026-01-23 09:36:59','2026-01-23 09:38:26',NULL,0,11,'d0dce6e339c349d4ab97cee5e49fff3a','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 09:36:59','2026-01-23 09:38:26',NULL,0,12,'d0dce6e339c349d4ab97cee5e49fff3a','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 09:37:20','2026-01-23 09:37:56',NULL,0,13,'9f68f8c2203944c9a6e44a6756c8b4b9','volumes',0,0,NULL,1),('2026-01-23 09:37:20','2026-01-23 09:37:56',NULL,0,14,'9f68f8c2203944c9a6e44a6756c8b4b9','gigabytes',0,0,NULL,1),('2026-01-23 09:37:20','2026-01-23 09:37:56',NULL,0,15,'9f68f8c2203944c9a6e44a6756c8b4b9','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 09:37:20','2026-01-23 09:37:56',NULL,0,16,'9f68f8c2203944c9a6e44a6756c8b4b9','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 09:41:43','2026-01-23 09:43:49',NULL,0,17,'4fd9229340ed4bf3a3a72baa6985a3e3','volumes',0,0,NULL,1),('2026-01-23 09:41:43','2026-01-23 09:43:49',NULL,0,18,'4fd9229340ed4bf3a3a72baa6985a3e3','gigabytes',0,0,NULL,1),('2026-01-23 09:41:43','2026-01-23 09:43:49',NULL,0,19,'4fd9229340ed4bf3a3a72baa6985a3e3','volumes_multiattach',0,0,NULL,1),('2026-01-23 09:41:43','2026-01-23 09:43:49',NULL,0,20,'4fd9229340ed4bf3a3a72baa6985a3e3','gigabytes_multiattach',0,0,NULL,1),('2026-01-23 09:42:25','2026-01-23 09:42:45',NULL,0,21,'7bb32481db2547b49bc4f3a10883baef','volumes',0,0,NULL,1),('2026-01-23 09:42:25','2026-01-23 09:42:45',NULL,0,22,'7bb32481db2547b49bc4f3a10883baef','gigabytes',0,0,NULL,1),('2026-01-23 09:42:25','2026-01-23 09:42:45',NULL,0,23,'7bb32481db2547b49bc4f3a10883baef','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 09:42:25','2026-01-23 09:42:45',NULL,0,24,'7bb32481db2547b49bc4f3a10883baef','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 09:42:29','2026-01-23 09:43:37',NULL,0,25,'2e0529ecec18434aa4fe09ac251ff46f','volumes',0,0,NULL,1),('2026-01-23 09:42:29','2026-01-23 09:43:37',NULL,0,26,'2e0529ecec18434aa4fe09ac251ff46f','gigabytes',0,0,NULL,1),('2026-01-23 09:42:29','2026-01-23 09:43:37',NULL,0,27,'2e0529ecec18434aa4fe09ac251ff46f','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 09:42:29','2026-01-23 09:43:37',NULL,0,28,'2e0529ecec18434aa4fe09ac251ff46f','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 09:47:43','2026-01-23 09:49:20',NULL,0,29,'15c7fbc4d6794364830639a1fee9ecf0','volumes',0,0,NULL,1),('2026-01-23 09:47:43','2026-01-23 09:49:20',NULL,0,30,'15c7fbc4d6794364830639a1fee9ecf0','gigabytes',0,0,NULL,1),('2026-01-23 09:47:43','2026-01-23 09:49:20',NULL,0,31,'15c7fbc4d6794364830639a1fee9ecf0','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 09:47:43','2026-01-23 09:49:20',NULL,0,32,'15c7fbc4d6794364830639a1fee9ecf0','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 09:50:54','2026-01-23 09:55:38',NULL,0,33,'61df91981c55482fa5c9a64686c79f9e','volumes',0,0,NULL,1),('2026-01-23 09:50:54','2026-01-23 09:55:38',NULL,0,34,'61df91981c55482fa5c9a64686c79f9e','gigabytes',0,0,NULL,1),('2026-01-23 09:50:54','2026-01-23 09:55:38',NULL,0,35,'61df91981c55482fa5c9a64686c79f9e','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 09:50:54','2026-01-23 09:55:38',NULL,0,36,'61df91981c55482fa5c9a64686c79f9e','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 09:52:39','2026-01-23 09:56:22',NULL,0,37,'9bc2d47d48c446c7ae1fc44cd9c32878','volumes',0,0,NULL,1),('2026-01-23 09:52:39','2026-01-23 09:56:22',NULL,0,38,'9bc2d47d48c446c7ae1fc44cd9c32878','gigabytes',0,0,NULL,1),('2026-01-23 09:52:39','2026-01-23 09:56:22',NULL,0,39,'9bc2d47d48c446c7ae1fc44cd9c32878','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 09:52:39','2026-01-23 09:56:22',NULL,0,40,'9bc2d47d48c446c7ae1fc44cd9c32878','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 09:56:40','2026-01-23 10:01:01',NULL,0,41,'8924c80a71a94fdeb114c6bdbdb2939c','volumes',0,0,NULL,1),('2026-01-23 09:56:40','2026-01-23 10:01:01',NULL,0,42,'8924c80a71a94fdeb114c6bdbdb2939c','gigabytes',0,0,NULL,1),('2026-01-23 09:56:40','2026-01-23 10:01:01',NULL,0,43,'8924c80a71a94fdeb114c6bdbdb2939c','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 09:56:40','2026-01-23 10:01:01',NULL,0,44,'8924c80a71a94fdeb114c6bdbdb2939c','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:03:21','2026-01-23 10:07:08',NULL,0,45,'8c16cd713fa74a88b43e4edf01c273bd','volumes',0,0,NULL,1),('2026-01-23 10:03:21','2026-01-23 10:07:08',NULL,0,46,'8c16cd713fa74a88b43e4edf01c273bd','gigabytes',0,0,NULL,1),('2026-01-23 10:03:21','2026-01-23 10:07:08',NULL,0,47,'8c16cd713fa74a88b43e4edf01c273bd','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:03:21','2026-01-23 10:07:08',NULL,0,48,'8c16cd713fa74a88b43e4edf01c273bd','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:07:47','2026-01-23 10:11:25',NULL,0,49,'924f976bcbb74ec195730b68eebe1f2a','volumes',0,0,NULL,1),('2026-01-23 10:07:47','2026-01-23 10:11:25',NULL,0,50,'924f976bcbb74ec195730b68eebe1f2a','gigabytes',0,0,NULL,1),('2026-01-23 10:07:47','2026-01-23 10:11:25',NULL,0,51,'924f976bcbb74ec195730b68eebe1f2a','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:07:47','2026-01-23 10:11:25',NULL,0,52,'924f976bcbb74ec195730b68eebe1f2a','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:08:45','2026-01-23 10:11:57',NULL,0,53,'746ea02b745c4e21ace4cb49c193899d','volumes',0,0,NULL,1),('2026-01-23 10:08:45','2026-01-23 10:11:57',NULL,0,54,'746ea02b745c4e21ace4cb49c193899d','gigabytes',0,0,NULL,1),('2026-01-23 10:08:45','2026-01-23 10:11:57',NULL,0,55,'746ea02b745c4e21ace4cb49c193899d','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:08:45','2026-01-23 10:11:57',NULL,0,56,'746ea02b745c4e21ace4cb49c193899d','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:11:30','2026-01-23 10:15:27',NULL,0,57,'9dd869ce76e44fc8a82b8bbee1654d33','volumes',0,0,NULL,1),('2026-01-23 10:11:30','2026-01-23 10:15:27',NULL,0,58,'9dd869ce76e44fc8a82b8bbee1654d33','gigabytes',0,0,NULL,1),('2026-01-23 10:11:30','2026-01-23 10:15:27',NULL,0,59,'9dd869ce76e44fc8a82b8bbee1654d33','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:11:30','2026-01-23 10:15:27',NULL,0,60,'9dd869ce76e44fc8a82b8bbee1654d33','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:11:39','2026-01-23 10:11:42',NULL,0,61,'7c9246f4d92c4dfbbb8111cfef809201','volumes',0,0,NULL,1),('2026-01-23 10:11:39','2026-01-23 10:11:42',NULL,0,62,'7c9246f4d92c4dfbbb8111cfef809201','gigabytes',0,0,NULL,1),('2026-01-23 10:11:39','2026-01-23 10:11:42',NULL,0,63,'7c9246f4d92c4dfbbb8111cfef809201','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:11:39','2026-01-23 10:11:42',NULL,0,64,'7c9246f4d92c4dfbbb8111cfef809201','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:13:35','2026-01-23 10:16:21',NULL,0,65,'0a6ba16c4b9d49d3bc24cd7b44935d1f','volumes',0,0,NULL,1),('2026-01-23 10:13:35','2026-01-23 10:16:21',NULL,0,66,'0a6ba16c4b9d49d3bc24cd7b44935d1f','gigabytes',0,0,NULL,1),('2026-01-23 10:13:35','2026-01-23 10:16:21',NULL,0,67,'0a6ba16c4b9d49d3bc24cd7b44935d1f','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:13:35','2026-01-23 10:16:21',NULL,0,68,'0a6ba16c4b9d49d3bc24cd7b44935d1f','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:14:19','2026-01-23 10:18:41',NULL,0,69,'3ae621f21a8e438fb95152309b38cee5','volumes',0,0,NULL,1),('2026-01-23 10:14:19','2026-01-23 10:18:41',NULL,0,70,'3ae621f21a8e438fb95152309b38cee5','gigabytes',0,0,NULL,1),('2026-01-23 10:14:19','2026-01-23 10:17:49',NULL,0,71,'3ae621f21a8e438fb95152309b38cee5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1036888469-1438475917',0,0,NULL,1),('2026-01-23 10:14:19','2026-01-23 10:17:49',NULL,0,72,'3ae621f21a8e438fb95152309b38cee5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1036888469-1438475917',0,0,NULL,1),('2026-01-23 10:14:19','2026-01-23 10:17:54',NULL,0,73,'3ae621f21a8e438fb95152309b38cee5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-968827984-727097193',0,0,NULL,1),('2026-01-23 10:14:19','2026-01-23 10:17:54',NULL,0,74,'3ae621f21a8e438fb95152309b38cee5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-968827984-727097193',0,0,NULL,1),('2026-01-23 10:14:22','2026-01-23 10:18:41',NULL,0,75,'3ae621f21a8e438fb95152309b38cee5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1177848314-496428426',0,0,NULL,1),('2026-01-23 10:14:22','2026-01-23 10:18:41',NULL,0,76,'3ae621f21a8e438fb95152309b38cee5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1177848314-496428426',0,0,NULL,1),('2026-01-23 10:16:26','2026-01-23 10:18:40',NULL,0,77,'59cfb6a6a5ea438fb4b12029b4fcea0f','volumes',0,0,NULL,1),('2026-01-23 10:16:26','2026-01-23 10:18:40',NULL,0,78,'59cfb6a6a5ea438fb4b12029b4fcea0f','gigabytes',0,0,NULL,1),('2026-01-23 10:16:26','2026-01-23 10:18:40',NULL,0,79,'59cfb6a6a5ea438fb4b12029b4fcea0f','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:16:26','2026-01-23 10:18:40',NULL,0,80,'59cfb6a6a5ea438fb4b12029b4fcea0f','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:21:10','2026-01-23 10:25:11',NULL,0,81,'b976daabc8124a99814954633f99ed7b','volumes',0,0,NULL,1),('2026-01-23 10:21:10','2026-01-23 10:25:11',NULL,0,82,'b976daabc8124a99814954633f99ed7b','gigabytes',0,0,NULL,1),('2026-01-23 10:21:10','2026-01-23 10:25:11',NULL,0,83,'b976daabc8124a99814954633f99ed7b','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:21:10','2026-01-23 10:25:11',NULL,0,84,'b976daabc8124a99814954633f99ed7b','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:21:21','2026-01-23 10:22:14',NULL,0,85,'b976daabc8124a99814954633f99ed7b','snapshots',0,0,NULL,1),('2026-01-23 10:21:21','2026-01-23 10:22:14',NULL,0,86,'b976daabc8124a99814954633f99ed7b','snapshots___DEFAULT__',0,0,NULL,1),('2026-01-23 10:24:10','2026-01-23 10:27:25',NULL,0,87,'c7c25c6bb33b41bf9cd8febb8259fd87','volumes',0,0,NULL,1),('2026-01-23 10:24:10','2026-01-23 10:27:25',NULL,0,88,'c7c25c6bb33b41bf9cd8febb8259fd87','gigabytes',0,0,NULL,1),('2026-01-23 10:24:10','2026-01-23 10:27:25',NULL,0,89,'c7c25c6bb33b41bf9cd8febb8259fd87','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:24:10','2026-01-23 10:27:25',NULL,0,90,'c7c25c6bb33b41bf9cd8febb8259fd87','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:24:21','2026-01-23 10:26:46',NULL,0,91,'5c27429e1d8f433a8a67ddb76f8798f1','volumes',2,0,NULL,1),('2026-01-23 10:24:21','2026-01-23 10:26:46',NULL,0,92,'5c27429e1d8f433a8a67ddb76f8798f1','gigabytes',2,0,NULL,1),('2026-01-23 10:24:21','2026-01-23 10:26:46',NULL,0,93,'5c27429e1d8f433a8a67ddb76f8798f1','volumes___DEFAULT__',2,0,NULL,1),('2026-01-23 10:24:21','2026-01-23 10:26:46',NULL,0,94,'5c27429e1d8f433a8a67ddb76f8798f1','gigabytes___DEFAULT__',2,0,NULL,1),('2026-01-23 10:33:47','2026-01-23 10:36:13',NULL,0,95,'815b71acf60d4ed8933ebd05228fa0c0','volumes',0,0,NULL,1),('2026-01-23 10:33:47','2026-01-23 10:36:13',NULL,0,96,'815b71acf60d4ed8933ebd05228fa0c0','gigabytes',0,0,NULL,1),('2026-01-23 10:33:47','2026-01-23 10:36:13',NULL,0,97,'815b71acf60d4ed8933ebd05228fa0c0','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:33:47','2026-01-23 10:36:13',NULL,0,98,'815b71acf60d4ed8933ebd05228fa0c0','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:34:58','2026-01-23 10:37:26',NULL,0,99,'d59dad6496894352a2f4c7eb66ca1914','volumes',0,0,NULL,1),('2026-01-23 10:34:58','2026-01-23 10:37:26',NULL,0,100,'d59dad6496894352a2f4c7eb66ca1914','gigabytes',0,0,NULL,1),('2026-01-23 10:34:58','2026-01-23 10:37:26',NULL,0,101,'d59dad6496894352a2f4c7eb66ca1914','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:34:58','2026-01-23 10:37:26',NULL,0,102,'d59dad6496894352a2f4c7eb66ca1914','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:35:48','2026-01-23 10:37:20',NULL,0,103,'d59dad6496894352a2f4c7eb66ca1914','snapshots',0,0,NULL,1),('2026-01-23 10:35:48','2026-01-23 10:37:20',NULL,0,104,'d59dad6496894352a2f4c7eb66ca1914','snapshots___DEFAULT__',0,0,NULL,1),('2026-01-23 10:37:56','2026-01-23 10:44:33',NULL,0,105,'6e762fca3b634c7aa1d994314c059c54','volumes',0,0,NULL,1),('2026-01-23 10:37:56','2026-01-23 10:44:33',NULL,0,106,'6e762fca3b634c7aa1d994314c059c54','gigabytes',0,0,NULL,1),('2026-01-23 10:37:56','2026-01-23 10:44:33',NULL,0,107,'6e762fca3b634c7aa1d994314c059c54','volumes_multiattach',0,0,NULL,1),('2026-01-23 10:37:56','2026-01-23 10:44:33',NULL,0,108,'6e762fca3b634c7aa1d994314c059c54','gigabytes_multiattach',0,0,NULL,1),('2026-01-23 10:38:15','2026-01-23 10:39:33',NULL,0,109,'95243c9b3c544aff8e9ee6043bb6f522','volumes',0,0,NULL,1),('2026-01-23 10:38:15','2026-01-23 10:39:33',NULL,0,110,'95243c9b3c544aff8e9ee6043bb6f522','gigabytes',0,0,NULL,1),('2026-01-23 10:38:15','2026-01-23 10:39:33',NULL,0,111,'95243c9b3c544aff8e9ee6043bb6f522','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:38:15','2026-01-23 10:39:33',NULL,0,112,'95243c9b3c544aff8e9ee6043bb6f522','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:38:26','2026-01-23 10:39:34',NULL,0,113,'95243c9b3c544aff8e9ee6043bb6f522','backups',0,0,NULL,1),('2026-01-23 10:38:26','2026-01-23 10:39:34',NULL,0,114,'95243c9b3c544aff8e9ee6043bb6f522','backup_gigabytes',0,0,NULL,1),('2026-01-23 10:40:27','2026-01-23 10:48:14',NULL,0,115,'d27c5465284b48a5818ef931d6251c43','volumes',0,0,NULL,1),('2026-01-23 10:40:27','2026-01-23 10:48:14',NULL,0,116,'d27c5465284b48a5818ef931d6251c43','gigabytes',0,0,NULL,1),('2026-01-23 10:40:27','2026-01-23 10:41:11',NULL,0,117,'d27c5465284b48a5818ef931d6251c43','volumes_tempest-scenario-type-luks-987783221',0,0,NULL,1),('2026-01-23 10:40:27','2026-01-23 10:41:11',NULL,0,118,'d27c5465284b48a5818ef931d6251c43','gigabytes_tempest-scenario-type-luks-987783221',0,0,NULL,1),('2026-01-23 10:41:13','2026-01-23 10:48:14',NULL,0,119,'d27c5465284b48a5818ef931d6251c43','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:41:13','2026-01-23 10:48:14',NULL,0,120,'d27c5465284b48a5818ef931d6251c43','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:41:33','2026-01-23 10:48:01',NULL,0,121,'d27c5465284b48a5818ef931d6251c43','snapshots',0,0,NULL,1),('2026-01-23 10:41:34','2026-01-23 10:48:01',NULL,0,122,'d27c5465284b48a5818ef931d6251c43','snapshots___DEFAULT__',0,0,NULL,1),('2026-01-23 10:43:37','2026-01-23 10:43:47',NULL,0,123,'6e762fca3b634c7aa1d994314c059c54','snapshots',0,0,NULL,1),('2026-01-23 10:43:37','2026-01-23 10:43:47',NULL,0,124,'6e762fca3b634c7aa1d994314c059c54','snapshots_multiattach',0,0,NULL,1),('2026-01-23 10:45:55','2026-01-23 10:49:13',NULL,0,125,'36d7e7c7ddbd4cf785fafd0d35b0a2d8','volumes',0,0,NULL,1),('2026-01-23 10:45:55','2026-01-23 10:49:13',NULL,0,126,'36d7e7c7ddbd4cf785fafd0d35b0a2d8','gigabytes',0,0,NULL,1),('2026-01-23 10:45:55','2026-01-23 10:49:13',NULL,0,127,'36d7e7c7ddbd4cf785fafd0d35b0a2d8','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:45:55','2026-01-23 10:49:13',NULL,0,128,'36d7e7c7ddbd4cf785fafd0d35b0a2d8','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:49:39','2026-01-23 10:49:44',NULL,0,129,'23776559930d49e8ade3d5f91aa5dfe4','volumes',0,0,NULL,1),('2026-01-23 10:49:39','2026-01-23 10:49:44',NULL,0,130,'23776559930d49e8ade3d5f91aa5dfe4','gigabytes',0,0,NULL,1),('2026-01-23 10:49:39','2026-01-23 10:49:44',NULL,0,131,'23776559930d49e8ade3d5f91aa5dfe4','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:49:39','2026-01-23 10:49:44',NULL,0,132,'23776559930d49e8ade3d5f91aa5dfe4','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:49:40','2026-01-23 10:49:42',NULL,0,133,'23776559930d49e8ade3d5f91aa5dfe4','snapshots',0,0,NULL,1),('2026-01-23 10:49:40','2026-01-23 10:49:42',NULL,0,134,'23776559930d49e8ade3d5f91aa5dfe4','snapshots___DEFAULT__',0,0,NULL,1),('2026-01-23 10:49:53','2026-01-23 10:50:06',NULL,0,135,'47c668e58db64e6a9121fb429d3bb9aa','volumes',0,0,NULL,1),('2026-01-23 10:49:53','2026-01-23 10:50:06',NULL,0,136,'47c668e58db64e6a9121fb429d3bb9aa','gigabytes',0,0,NULL,1),('2026-01-23 10:49:53','2026-01-23 10:50:06',NULL,0,137,'47c668e58db64e6a9121fb429d3bb9aa','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:49:53','2026-01-23 10:50:06',NULL,0,138,'47c668e58db64e6a9121fb429d3bb9aa','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-23 10:50:41','2026-01-23 10:52:11',NULL,0,139,'9533be9d361246bdb0a7c1bd3015db66','volumes',0,0,NULL,1),('2026-01-23 10:50:41','2026-01-23 10:52:11',NULL,0,140,'9533be9d361246bdb0a7c1bd3015db66','gigabytes',0,0,NULL,1),('2026-01-23 10:50:41','2026-01-23 10:52:11',NULL,0,141,'9533be9d361246bdb0a7c1bd3015db66','volumes_tempest-scenario-type-luks-1600364038',0,0,NULL,1),('2026-01-23 10:50:41','2026-01-23 10:52:11',NULL,0,142,'9533be9d361246bdb0a7c1bd3015db66','gigabytes_tempest-scenario-type-luks-1600364038',0,0,NULL,1),('2026-01-23 11:14:18','2026-01-23 11:16:52',NULL,0,143,'3a245f7970f14fffa60af2ff972b4bfd','volumes',0,0,NULL,1),('2026-01-23 11:14:18','2026-01-23 11:16:52',NULL,0,144,'3a245f7970f14fffa60af2ff972b4bfd','gigabytes',0,0,NULL,1),('2026-01-23 11:14:18','2026-01-23 11:16:52',NULL,0,145,'3a245f7970f14fffa60af2ff972b4bfd','volumes___DEFAULT__',0,0,NULL,1),('2026-01-23 11:14:18','2026-01-23 11:16:52',NULL,0,146,'3a245f7970f14fffa60af2ff972b4bfd','gigabytes___DEFAULT__',0,0,NULL,1);
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=605 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `allocated_id`) VALUES ('2026-01-23 09:29:04','2026-01-23 09:29:04','2026-01-23 09:29:04',1,1,'a99e15c9-1249-42d5-a955-2147fccfdb77',1,'649cf144e93c4123b8f11cac66308419','volumes',1,'2026-01-24 09:29:04',NULL),('2026-01-23 09:29:04','2026-01-23 09:29:04','2026-01-23 09:29:04',1,2,'996cf16d-2bff-47dc-b6d0-a73d8b817d98',2,'649cf144e93c4123b8f11cac66308419','gigabytes',1,'2026-01-24 09:29:04',NULL),('2026-01-23 09:29:04','2026-01-23 09:29:04','2026-01-23 09:29:04',1,3,'f9bd264d-b690-4d18-8d70-f1f5a8840c37',3,'649cf144e93c4123b8f11cac66308419','volumes___DEFAULT__',1,'2026-01-24 09:29:04',NULL),('2026-01-23 09:29:04','2026-01-23 09:29:04','2026-01-23 09:29:04',1,4,'a086a1a8-4516-472f-b574-a85e27322ac1',4,'649cf144e93c4123b8f11cac66308419','gigabytes___DEFAULT__',1,'2026-01-24 09:29:04',NULL),('2026-01-23 09:30:12','2026-01-23 09:30:12','2026-01-23 09:30:12',1,5,'5fa63884-b2bb-4b32-9c08-1054c4034a28',1,'649cf144e93c4123b8f11cac66308419','volumes',-1,'2026-01-24 09:30:12',NULL),('2026-01-23 09:30:12','2026-01-23 09:30:12','2026-01-23 09:30:12',1,6,'bfccec77-79dd-4b01-bbc1-c3ab1b484b3d',2,'649cf144e93c4123b8f11cac66308419','gigabytes',-1,'2026-01-24 09:30:12',NULL),('2026-01-23 09:30:12','2026-01-23 09:30:12','2026-01-23 09:30:12',1,7,'21c49295-67d7-4773-8c76-ca4a33a920fb',3,'649cf144e93c4123b8f11cac66308419','volumes___DEFAULT__',-1,'2026-01-24 09:30:12',NULL),('2026-01-23 09:30:12','2026-01-23 09:30:12','2026-01-23 09:30:12',1,8,'5caac390-5388-4d2e-809c-b9c24fd163b5',4,'649cf144e93c4123b8f11cac66308419','gigabytes___DEFAULT__',-1,'2026-01-24 09:30:12',NULL),('2026-01-23 09:31:39','2026-01-23 09:31:39','2026-01-23 09:31:39',1,9,'7bd00687-da17-4daa-9dff-1265ebf929be',5,'c56e53b3339e4e4db30b7a9d330bc380','volumes',1,'2026-01-24 09:31:39',NULL),('2026-01-23 09:31:39','2026-01-23 09:31:39','2026-01-23 09:31:39',1,10,'e25bc52c-0863-4024-a887-3ab88fade9ef',6,'c56e53b3339e4e4db30b7a9d330bc380','gigabytes',1,'2026-01-24 09:31:39',NULL),('2026-01-23 09:31:39','2026-01-23 09:31:39','2026-01-23 09:31:39',1,11,'cc65f0f8-a276-4cf0-920b-83f6c9cf7140',7,'c56e53b3339e4e4db30b7a9d330bc380','volumes___DEFAULT__',1,'2026-01-24 09:31:39',NULL),('2026-01-23 09:31:39','2026-01-23 09:31:39','2026-01-23 09:31:39',1,12,'1575b163-3def-42af-adb4-ffa4d6ab0911',8,'c56e53b3339e4e4db30b7a9d330bc380','gigabytes___DEFAULT__',1,'2026-01-24 09:31:39',NULL),('2026-01-23 09:33:19','2026-01-23 09:33:19','2026-01-23 09:33:19',1,13,'55609331-4391-4f68-9b35-2065043848d3',5,'c56e53b3339e4e4db30b7a9d330bc380','volumes',-1,'2026-01-24 09:33:19',NULL),('2026-01-23 09:33:19','2026-01-23 09:33:19','2026-01-23 09:33:19',1,14,'b757090b-721b-4d41-896d-38fa73375812',6,'c56e53b3339e4e4db30b7a9d330bc380','gigabytes',-1,'2026-01-24 09:33:19',NULL),('2026-01-23 09:33:19','2026-01-23 09:33:19','2026-01-23 09:33:19',1,15,'2f1aa093-2d2d-4fff-a169-1c8281594906',7,'c56e53b3339e4e4db30b7a9d330bc380','volumes___DEFAULT__',-1,'2026-01-24 09:33:19',NULL),('2026-01-23 09:33:19','2026-01-23 09:33:19','2026-01-23 09:33:19',1,16,'cb03f819-4170-42b0-8a12-f3e9cf488bda',8,'c56e53b3339e4e4db30b7a9d330bc380','gigabytes___DEFAULT__',-1,'2026-01-24 09:33:19',NULL),('2026-01-23 09:36:59','2026-01-23 09:36:59','2026-01-23 09:36:59',1,17,'2ec2394b-a772-4164-a044-40c256ded7a5',9,'d0dce6e339c349d4ab97cee5e49fff3a','volumes',1,'2026-01-24 09:36:59',NULL),('2026-01-23 09:36:59','2026-01-23 09:36:59','2026-01-23 09:36:59',1,18,'4b174d55-dd57-487a-bc93-76505cdceb3a',10,'d0dce6e339c349d4ab97cee5e49fff3a','gigabytes',1,'2026-01-24 09:36:59',NULL),('2026-01-23 09:36:59','2026-01-23 09:36:59','2026-01-23 09:36:59',1,19,'f787db8d-fb72-4251-827b-d07010a3a11a',11,'d0dce6e339c349d4ab97cee5e49fff3a','volumes___DEFAULT__',1,'2026-01-24 09:36:59',NULL),('2026-01-23 09:36:59','2026-01-23 09:36:59','2026-01-23 09:36:59',1,20,'d7b09084-e2c0-4233-99b3-7bbb5480f3ad',12,'d0dce6e339c349d4ab97cee5e49fff3a','gigabytes___DEFAULT__',1,'2026-01-24 09:36:59',NULL),('2026-01-23 09:37:20','2026-01-23 09:37:20','2026-01-23 09:37:20',1,21,'3a1bb582-b972-4dd3-999f-eaf3ac6f2368',13,'9f68f8c2203944c9a6e44a6756c8b4b9','volumes',1,'2026-01-24 09:37:20',NULL),('2026-01-23 09:37:20','2026-01-23 09:37:20','2026-01-23 09:37:20',1,22,'c5dcf702-e0d6-4683-bdcf-a16c4373e766',14,'9f68f8c2203944c9a6e44a6756c8b4b9','gigabytes',1,'2026-01-24 09:37:20',NULL),('2026-01-23 09:37:20','2026-01-23 09:37:20','2026-01-23 09:37:20',1,23,'a3ad7422-5ca5-4714-96d6-ab01c0a05d9e',15,'9f68f8c2203944c9a6e44a6756c8b4b9','volumes___DEFAULT__',1,'2026-01-24 09:37:20',NULL),('2026-01-23 09:37:20','2026-01-23 09:37:20','2026-01-23 09:37:20',1,24,'abfee8b3-e1ad-4cca-bdc2-af9a6bd03c38',16,'9f68f8c2203944c9a6e44a6756c8b4b9','gigabytes___DEFAULT__',1,'2026-01-24 09:37:20',NULL),('2026-01-23 09:37:48','2026-01-23 09:37:48','2026-01-23 09:37:48',1,25,'4136597f-06c1-4837-9510-94570223c94b',13,'9f68f8c2203944c9a6e44a6756c8b4b9','volumes',1,'2026-01-24 09:37:48',NULL),('2026-01-23 09:37:48','2026-01-23 09:37:48','2026-01-23 09:37:48',1,26,'1732b75c-ccfd-4451-8cf1-509de24243c7',14,'9f68f8c2203944c9a6e44a6756c8b4b9','gigabytes',1,'2026-01-24 09:37:48',NULL),('2026-01-23 09:37:48','2026-01-23 09:37:48','2026-01-23 09:37:48',1,27,'28956b4a-6651-4dcd-abf9-a54783a060ef',15,'9f68f8c2203944c9a6e44a6756c8b4b9','volumes___DEFAULT__',1,'2026-01-24 09:37:48',NULL),('2026-01-23 09:37:48','2026-01-23 09:37:48','2026-01-23 09:37:48',1,28,'0e5cdc96-61ee-4355-a1e2-0f0b7b097353',16,'9f68f8c2203944c9a6e44a6756c8b4b9','gigabytes___DEFAULT__',1,'2026-01-24 09:37:48',NULL),('2026-01-23 09:37:51','2026-01-23 09:37:51','2026-01-23 09:37:51',1,29,'a186861a-63f9-472c-a786-88ee052473a8',13,'9f68f8c2203944c9a6e44a6756c8b4b9','volumes',-1,'2026-01-24 09:37:51',NULL),('2026-01-23 09:37:51','2026-01-23 09:37:51','2026-01-23 09:37:51',1,30,'c5e8affc-91fb-4d18-90a9-50c66152fdcb',14,'9f68f8c2203944c9a6e44a6756c8b4b9','gigabytes',-1,'2026-01-24 09:37:51',NULL),('2026-01-23 09:37:51','2026-01-23 09:37:51','2026-01-23 09:37:51',1,31,'76bf2b44-a15c-46c4-bb56-ae414b5326b7',15,'9f68f8c2203944c9a6e44a6756c8b4b9','volumes___DEFAULT__',-1,'2026-01-24 09:37:51',NULL),('2026-01-23 09:37:51','2026-01-23 09:37:51','2026-01-23 09:37:51',1,32,'67ddad70-43e0-4063-b434-8115405a195a',16,'9f68f8c2203944c9a6e44a6756c8b4b9','gigabytes___DEFAULT__',-1,'2026-01-24 09:37:51',NULL),('2026-01-23 09:37:56','2026-01-23 09:37:56','2026-01-23 09:37:56',1,33,'0fba3a8b-33bc-46a9-b306-97e4bafdd384',13,'9f68f8c2203944c9a6e44a6756c8b4b9','volumes',-1,'2026-01-24 09:37:56',NULL),('2026-01-23 09:37:56','2026-01-23 09:37:56','2026-01-23 09:37:56',1,34,'339ed1d9-98b4-4250-bcee-90d3a8d28fde',14,'9f68f8c2203944c9a6e44a6756c8b4b9','gigabytes',-1,'2026-01-24 09:37:56',NULL),('2026-01-23 09:37:56','2026-01-23 09:37:56','2026-01-23 09:37:56',1,35,'d5ecd400-e709-4703-8fdb-baa2528c2868',15,'9f68f8c2203944c9a6e44a6756c8b4b9','volumes___DEFAULT__',-1,'2026-01-24 09:37:56',NULL),('2026-01-23 09:37:56','2026-01-23 09:37:56','2026-01-23 09:37:56',1,36,'6527c72a-7dd0-47ba-9037-80d36cea2a37',16,'9f68f8c2203944c9a6e44a6756c8b4b9','gigabytes___DEFAULT__',-1,'2026-01-24 09:37:56',NULL),('2026-01-23 09:38:25','2026-01-23 09:38:26','2026-01-23 09:38:26',1,37,'8968e621-465a-4bcb-9629-5000cad0ff51',9,'d0dce6e339c349d4ab97cee5e49fff3a','volumes',-1,'2026-01-24 09:38:25',NULL),('2026-01-23 09:38:25','2026-01-23 09:38:26','2026-01-23 09:38:26',1,38,'6ffc4392-2e07-48f3-acc6-c4c4b753ed4b',10,'d0dce6e339c349d4ab97cee5e49fff3a','gigabytes',-1,'2026-01-24 09:38:25',NULL),('2026-01-23 09:38:25','2026-01-23 09:38:26','2026-01-23 09:38:26',1,39,'010fca81-05fa-4c2c-9689-a5e32a7be57d',11,'d0dce6e339c349d4ab97cee5e49fff3a','volumes___DEFAULT__',-1,'2026-01-24 09:38:25',NULL),('2026-01-23 09:38:25','2026-01-23 09:38:26','2026-01-23 09:38:26',1,40,'cd28e731-b6db-4fdf-a0a1-c807db39b1f4',12,'d0dce6e339c349d4ab97cee5e49fff3a','gigabytes___DEFAULT__',-1,'2026-01-24 09:38:25',NULL),('2026-01-23 09:41:43','2026-01-23 09:41:43','2026-01-23 09:41:43',1,41,'cde8958f-fc84-4075-909f-f2c3dedf0d32',17,'4fd9229340ed4bf3a3a72baa6985a3e3','volumes',1,'2026-01-24 09:41:43',NULL),('2026-01-23 09:41:43','2026-01-23 09:41:43','2026-01-23 09:41:43',1,42,'b1615eb0-d6fb-4ab9-aac0-244ecb330d36',18,'4fd9229340ed4bf3a3a72baa6985a3e3','gigabytes',1,'2026-01-24 09:41:43',NULL),('2026-01-23 09:41:43','2026-01-23 09:41:43','2026-01-23 09:41:43',1,43,'7e0b96f7-8ace-4dd2-91f9-b2a8a82ff099',19,'4fd9229340ed4bf3a3a72baa6985a3e3','volumes_multiattach',1,'2026-01-24 09:41:43',NULL),('2026-01-23 09:41:43','2026-01-23 09:41:43','2026-01-23 09:41:43',1,44,'99460402-8b34-438f-8649-446ef0f425fe',20,'4fd9229340ed4bf3a3a72baa6985a3e3','gigabytes_multiattach',1,'2026-01-24 09:41:43',NULL),('2026-01-23 09:41:44','2026-01-23 09:41:45','2026-01-23 09:41:45',1,45,'8801ce74-dd19-47f9-b147-004da51babf1',17,'4fd9229340ed4bf3a3a72baa6985a3e3','volumes',1,'2026-01-24 09:41:44',NULL),('2026-01-23 09:41:44','2026-01-23 09:41:45','2026-01-23 09:41:45',1,46,'fa315b17-1bbb-4277-b396-1de4e66b47b7',18,'4fd9229340ed4bf3a3a72baa6985a3e3','gigabytes',1,'2026-01-24 09:41:44',NULL),('2026-01-23 09:41:44','2026-01-23 09:41:45','2026-01-23 09:41:45',1,47,'ef4e6a1c-5025-40f1-b005-a2ed509432de',19,'4fd9229340ed4bf3a3a72baa6985a3e3','volumes_multiattach',1,'2026-01-24 09:41:44',NULL),('2026-01-23 09:41:44','2026-01-23 09:41:45','2026-01-23 09:41:45',1,48,'309f17d1-e29d-4492-83b4-70e93398158c',20,'4fd9229340ed4bf3a3a72baa6985a3e3','gigabytes_multiattach',1,'2026-01-24 09:41:44',NULL),('2026-01-23 09:42:25','2026-01-23 09:42:25','2026-01-23 09:42:25',1,49,'511e7580-3bd7-47e2-a365-5f03dfa169b8',21,'7bb32481db2547b49bc4f3a10883baef','volumes',1,'2026-01-24 09:42:25',NULL),('2026-01-23 09:42:25','2026-01-23 09:42:25','2026-01-23 09:42:25',1,50,'d0f4e4d6-073c-4bfa-b4ce-e404bf024b97',22,'7bb32481db2547b49bc4f3a10883baef','gigabytes',1,'2026-01-24 09:42:25',NULL),('2026-01-23 09:42:25','2026-01-23 09:42:25','2026-01-23 09:42:25',1,51,'75b64002-91b5-45a3-bc41-b0ba4b643726',23,'7bb32481db2547b49bc4f3a10883baef','volumes___DEFAULT__',1,'2026-01-24 09:42:25',NULL),('2026-01-23 09:42:25','2026-01-23 09:42:25','2026-01-23 09:42:25',1,52,'0e24e14d-4182-4a67-9fc0-71d78420f67a',24,'7bb32481db2547b49bc4f3a10883baef','gigabytes___DEFAULT__',1,'2026-01-24 09:42:25',NULL),('2026-01-23 09:42:29','2026-01-23 09:42:29','2026-01-23 09:42:29',1,53,'4e1f028a-e577-46ee-899e-d632357ef85e',25,'2e0529ecec18434aa4fe09ac251ff46f','volumes',1,'2026-01-24 09:42:29',NULL),('2026-01-23 09:42:29','2026-01-23 09:42:29','2026-01-23 09:42:29',1,54,'8e6c782b-c95c-4908-aa43-24ebb94979e7',26,'2e0529ecec18434aa4fe09ac251ff46f','gigabytes',1,'2026-01-24 09:42:29',NULL),('2026-01-23 09:42:29','2026-01-23 09:42:29','2026-01-23 09:42:29',1,55,'f756f6c4-71bd-4284-807b-dddd8ef47c2c',27,'2e0529ecec18434aa4fe09ac251ff46f','volumes___DEFAULT__',1,'2026-01-24 09:42:29',NULL),('2026-01-23 09:42:29','2026-01-23 09:42:29','2026-01-23 09:42:29',1,56,'6005d104-02b1-4b30-b9f5-93f651c873fc',28,'2e0529ecec18434aa4fe09ac251ff46f','gigabytes___DEFAULT__',1,'2026-01-24 09:42:29',NULL),('2026-01-23 09:42:45','2026-01-23 09:42:45','2026-01-23 09:42:45',1,57,'9bcafad6-0836-4ab2-855f-36ed04b30b8b',21,'7bb32481db2547b49bc4f3a10883baef','volumes',-1,'2026-01-24 09:42:44',NULL),('2026-01-23 09:42:45','2026-01-23 09:42:45','2026-01-23 09:42:45',1,58,'7b20c233-949d-4a59-a397-64516821aeff',22,'7bb32481db2547b49bc4f3a10883baef','gigabytes',-1,'2026-01-24 09:42:44',NULL),('2026-01-23 09:42:45','2026-01-23 09:42:45','2026-01-23 09:42:45',1,59,'b5306036-d4fc-4a48-a6ce-de9d5a183350',23,'7bb32481db2547b49bc4f3a10883baef','volumes___DEFAULT__',-1,'2026-01-24 09:42:44',NULL),('2026-01-23 09:42:45','2026-01-23 09:42:45','2026-01-23 09:42:45',1,60,'09f39e81-b08c-451a-b113-ef65a0185782',24,'7bb32481db2547b49bc4f3a10883baef','gigabytes___DEFAULT__',-1,'2026-01-24 09:42:44',NULL),('2026-01-23 09:43:36','2026-01-23 09:43:37','2026-01-23 09:43:37',1,61,'1adae723-759e-4657-82d7-6e4d22086ac9',25,'2e0529ecec18434aa4fe09ac251ff46f','volumes',-1,'2026-01-24 09:43:36',NULL),('2026-01-23 09:43:36','2026-01-23 09:43:37','2026-01-23 09:43:37',1,62,'c837361a-3611-4da2-9657-8f0829a8f81e',26,'2e0529ecec18434aa4fe09ac251ff46f','gigabytes',-1,'2026-01-24 09:43:36',NULL),('2026-01-23 09:43:37','2026-01-23 09:43:37','2026-01-23 09:43:37',1,63,'ba2f86fc-2369-43d1-a4d5-3115b7d9fbb0',27,'2e0529ecec18434aa4fe09ac251ff46f','volumes___DEFAULT__',-1,'2026-01-24 09:43:36',NULL),('2026-01-23 09:43:37','2026-01-23 09:43:37','2026-01-23 09:43:37',1,64,'44fa8246-f17b-4166-ad65-16a4191b60e0',28,'2e0529ecec18434aa4fe09ac251ff46f','gigabytes___DEFAULT__',-1,'2026-01-24 09:43:36',NULL),('2026-01-23 09:43:46','2026-01-23 09:43:47','2026-01-23 09:43:47',1,65,'6c9670f2-d1e7-47f2-827a-dea3044f6daa',17,'4fd9229340ed4bf3a3a72baa6985a3e3','volumes',-1,'2026-01-24 09:43:46',NULL),('2026-01-23 09:43:46','2026-01-23 09:43:47','2026-01-23 09:43:47',1,66,'88baa655-b9c7-4cc0-9f0a-2a4c0fe371ed',18,'4fd9229340ed4bf3a3a72baa6985a3e3','gigabytes',-1,'2026-01-24 09:43:46',NULL),('2026-01-23 09:43:46','2026-01-23 09:43:47','2026-01-23 09:43:47',1,67,'a9fd32a1-8f0c-4f55-b2f8-f22b86413bb0',19,'4fd9229340ed4bf3a3a72baa6985a3e3','volumes_multiattach',-1,'2026-01-24 09:43:46',NULL),('2026-01-23 09:43:46','2026-01-23 09:43:47','2026-01-23 09:43:47',1,68,'66bc6141-baeb-4280-ad6f-13061a6bca25',20,'4fd9229340ed4bf3a3a72baa6985a3e3','gigabytes_multiattach',-1,'2026-01-24 09:43:46',NULL),('2026-01-23 09:43:48','2026-01-23 09:43:49','2026-01-23 09:43:49',1,69,'67f33cd2-626f-4bb7-868e-16dfacb61bd8',17,'4fd9229340ed4bf3a3a72baa6985a3e3','volumes',-1,'2026-01-24 09:43:48',NULL),('2026-01-23 09:43:48','2026-01-23 09:43:49','2026-01-23 09:43:49',1,70,'517dbb2c-c584-4eee-8256-e47320e845f4',18,'4fd9229340ed4bf3a3a72baa6985a3e3','gigabytes',-1,'2026-01-24 09:43:48',NULL),('2026-01-23 09:43:48','2026-01-23 09:43:49','2026-01-23 09:43:49',1,71,'2188d293-c38d-45be-baff-4a0de4f99e55',19,'4fd9229340ed4bf3a3a72baa6985a3e3','volumes_multiattach',-1,'2026-01-24 09:43:48',NULL),('2026-01-23 09:43:48','2026-01-23 09:43:49','2026-01-23 09:43:49',1,72,'ce7ca7ac-5eda-4db0-b5ab-f3e2e76401a2',20,'4fd9229340ed4bf3a3a72baa6985a3e3','gigabytes_multiattach',-1,'2026-01-24 09:43:48',NULL),('2026-01-23 09:47:43','2026-01-23 09:47:44','2026-01-23 09:47:44',1,73,'88c96e94-7454-43b0-ac5c-dd975d679787',29,'15c7fbc4d6794364830639a1fee9ecf0','volumes',1,'2026-01-24 09:47:43',NULL),('2026-01-23 09:47:43','2026-01-23 09:47:44','2026-01-23 09:47:44',1,74,'1ea09462-2398-4dc7-bb39-2342c928f18d',30,'15c7fbc4d6794364830639a1fee9ecf0','gigabytes',1,'2026-01-24 09:47:43',NULL),('2026-01-23 09:47:43','2026-01-23 09:47:44','2026-01-23 09:47:44',1,75,'717f0d84-978a-46d3-b15b-8e93472a14fb',31,'15c7fbc4d6794364830639a1fee9ecf0','volumes___DEFAULT__',1,'2026-01-24 09:47:43',NULL),('2026-01-23 09:47:43','2026-01-23 09:47:44','2026-01-23 09:47:44',1,76,'c67ecafa-50e5-426c-a536-af50161ffd30',32,'15c7fbc4d6794364830639a1fee9ecf0','gigabytes___DEFAULT__',1,'2026-01-24 09:47:43',NULL),('2026-01-23 09:49:20','2026-01-23 09:49:20','2026-01-23 09:49:20',1,77,'d2d60237-98c4-4e94-aba5-fe15b4724e34',29,'15c7fbc4d6794364830639a1fee9ecf0','volumes',-1,'2026-01-24 09:49:20',NULL),('2026-01-23 09:49:20','2026-01-23 09:49:20','2026-01-23 09:49:20',1,78,'9512db34-5193-41d2-aa96-4b0016b1850c',30,'15c7fbc4d6794364830639a1fee9ecf0','gigabytes',-1,'2026-01-24 09:49:20',NULL),('2026-01-23 09:49:20','2026-01-23 09:49:20','2026-01-23 09:49:20',1,79,'83e78eab-e882-4a5a-a872-36c5a80a74ae',31,'15c7fbc4d6794364830639a1fee9ecf0','volumes___DEFAULT__',-1,'2026-01-24 09:49:20',NULL),('2026-01-23 09:49:20','2026-01-23 09:49:20','2026-01-23 09:49:20',1,80,'7121f8e5-69c5-455d-b47d-463016b94986',32,'15c7fbc4d6794364830639a1fee9ecf0','gigabytes___DEFAULT__',-1,'2026-01-24 09:49:20',NULL),('2026-01-23 09:50:54','2026-01-23 09:50:54','2026-01-23 09:50:54',1,81,'a4656d3d-4923-4260-bd23-3c225cd1839c',33,'61df91981c55482fa5c9a64686c79f9e','volumes',1,'2026-01-24 09:50:54',NULL),('2026-01-23 09:50:54','2026-01-23 09:50:54','2026-01-23 09:50:54',1,82,'3287f15c-d28d-47c8-9b73-389df9c39517',34,'61df91981c55482fa5c9a64686c79f9e','gigabytes',1,'2026-01-24 09:50:54',NULL),('2026-01-23 09:50:54','2026-01-23 09:50:54','2026-01-23 09:50:54',1,83,'aa5719b0-7aeb-4c56-b922-e9b8d9e0dad0',35,'61df91981c55482fa5c9a64686c79f9e','volumes___DEFAULT__',1,'2026-01-24 09:50:54',NULL),('2026-01-23 09:50:54','2026-01-23 09:50:54','2026-01-23 09:50:54',1,84,'7a8d9231-64a4-4448-aca5-7c05196b477d',36,'61df91981c55482fa5c9a64686c79f9e','gigabytes___DEFAULT__',1,'2026-01-24 09:50:54',NULL),('2026-01-23 09:52:39','2026-01-23 09:52:39','2026-01-23 09:52:39',1,85,'694edcf5-43f8-40fb-b044-78d38cdfedcf',37,'9bc2d47d48c446c7ae1fc44cd9c32878','volumes',1,'2026-01-24 09:52:39',NULL),('2026-01-23 09:52:39','2026-01-23 09:52:39','2026-01-23 09:52:39',1,86,'64462694-525e-4296-98f1-b3e40e20cc4b',38,'9bc2d47d48c446c7ae1fc44cd9c32878','gigabytes',1,'2026-01-24 09:52:39',NULL),('2026-01-23 09:52:39','2026-01-23 09:52:39','2026-01-23 09:52:39',1,87,'be0689d8-568e-4555-a9fd-ec8064699fd3',39,'9bc2d47d48c446c7ae1fc44cd9c32878','volumes___DEFAULT__',1,'2026-01-24 09:52:39',NULL),('2026-01-23 09:52:39','2026-01-23 09:52:39','2026-01-23 09:52:39',1,88,'0479b8b5-01c6-4db8-bc19-14650d08ea87',40,'9bc2d47d48c446c7ae1fc44cd9c32878','gigabytes___DEFAULT__',1,'2026-01-24 09:52:39',NULL),('2026-01-23 09:52:58','2026-01-23 09:52:59','2026-01-23 09:52:58',1,89,'ffad3510-54fd-48c2-a1cf-9d65a0be5d69',37,'9bc2d47d48c446c7ae1fc44cd9c32878','volumes',1,'2026-01-24 09:52:58',NULL),('2026-01-23 09:52:58','2026-01-23 09:52:58','2026-01-23 09:52:58',1,90,'217861ff-33a7-4b00-abae-4da135e11dda',38,'9bc2d47d48c446c7ae1fc44cd9c32878','gigabytes',1,'2026-01-24 09:52:58',NULL),('2026-01-23 09:52:58','2026-01-23 09:52:58','2026-01-23 09:52:58',1,91,'58fe30dc-5dc9-49cb-abe4-d91f7d32312a',39,'9bc2d47d48c446c7ae1fc44cd9c32878','volumes___DEFAULT__',1,'2026-01-24 09:52:58',NULL),('2026-01-23 09:52:58','2026-01-23 09:52:58','2026-01-23 09:52:58',1,92,'9c81a21a-7a96-4c76-a394-5b8660b2045b',40,'9bc2d47d48c446c7ae1fc44cd9c32878','gigabytes___DEFAULT__',1,'2026-01-24 09:52:58',NULL),('2026-01-23 09:53:01','2026-01-23 09:53:01','2026-01-23 09:53:01',1,93,'8dbc2d46-49dd-4ac7-99ec-7960497d454e',37,'9bc2d47d48c446c7ae1fc44cd9c32878','volumes',1,'2026-01-24 09:53:01',NULL),('2026-01-23 09:53:01','2026-01-23 09:53:01','2026-01-23 09:53:01',1,94,'224ad978-1c13-4afc-b038-349201a3c99c',38,'9bc2d47d48c446c7ae1fc44cd9c32878','gigabytes',1,'2026-01-24 09:53:01',NULL),('2026-01-23 09:53:01','2026-01-23 09:53:01','2026-01-23 09:53:01',1,95,'fa266f39-2976-4907-80df-b1822d723abb',39,'9bc2d47d48c446c7ae1fc44cd9c32878','volumes___DEFAULT__',1,'2026-01-24 09:53:01',NULL),('2026-01-23 09:53:01','2026-01-23 09:53:01','2026-01-23 09:53:01',1,96,'14a576b4-2f79-45ca-8f19-9eccabd68603',40,'9bc2d47d48c446c7ae1fc44cd9c32878','gigabytes___DEFAULT__',1,'2026-01-24 09:53:01',NULL),('2026-01-23 09:55:38','2026-01-23 09:55:38','2026-01-23 09:55:38',1,97,'df8163fc-bff8-4bec-9b9a-3d03fcf8e3a1',33,'61df91981c55482fa5c9a64686c79f9e','volumes',-1,'2026-01-24 09:55:38',NULL),('2026-01-23 09:55:38','2026-01-23 09:55:38','2026-01-23 09:55:38',1,98,'ce5edce6-5e06-4c21-b9e8-00db2732f1e8',34,'61df91981c55482fa5c9a64686c79f9e','gigabytes',-1,'2026-01-24 09:55:38',NULL),('2026-01-23 09:55:38','2026-01-23 09:55:38','2026-01-23 09:55:38',1,99,'71772d69-e5a2-445f-aa33-fb4a4c2bf1c5',35,'61df91981c55482fa5c9a64686c79f9e','volumes___DEFAULT__',-1,'2026-01-24 09:55:38',NULL),('2026-01-23 09:55:38','2026-01-23 09:55:38','2026-01-23 09:55:38',1,100,'0ae5cda3-22ff-43b8-9dd5-3c2a9c34a28a',36,'61df91981c55482fa5c9a64686c79f9e','gigabytes___DEFAULT__',-1,'2026-01-24 09:55:38',NULL),('2026-01-23 09:56:19','2026-01-23 09:56:19','2026-01-23 09:56:19',1,101,'bad1759a-6c80-44c3-99df-359bdde46605',37,'9bc2d47d48c446c7ae1fc44cd9c32878','volumes',-1,'2026-01-24 09:56:19',NULL),('2026-01-23 09:56:19','2026-01-23 09:56:19','2026-01-23 09:56:19',1,102,'4588dc72-ad5e-456f-a3d8-24178d72338f',38,'9bc2d47d48c446c7ae1fc44cd9c32878','gigabytes',-1,'2026-01-24 09:56:19',NULL),('2026-01-23 09:56:19','2026-01-23 09:56:19','2026-01-23 09:56:19',1,103,'4e2b2fcf-dd70-4975-9fee-8b739b3c6ea5',39,'9bc2d47d48c446c7ae1fc44cd9c32878','volumes___DEFAULT__',-1,'2026-01-24 09:56:19',NULL),('2026-01-23 09:56:19','2026-01-23 09:56:19','2026-01-23 09:56:19',1,104,'9efc8ab6-70f4-4018-84bd-45754d78feb6',40,'9bc2d47d48c446c7ae1fc44cd9c32878','gigabytes___DEFAULT__',-1,'2026-01-24 09:56:19',NULL),('2026-01-23 09:56:20','2026-01-23 09:56:21','2026-01-23 09:56:21',1,105,'e076934a-6212-4166-9021-dcf750498869',37,'9bc2d47d48c446c7ae1fc44cd9c32878','volumes',-1,'2026-01-24 09:56:20',NULL),('2026-01-23 09:56:20','2026-01-23 09:56:21','2026-01-23 09:56:21',1,106,'54aa6946-d42c-4420-a7e3-59eb692a0616',38,'9bc2d47d48c446c7ae1fc44cd9c32878','gigabytes',-1,'2026-01-24 09:56:20',NULL),('2026-01-23 09:56:20','2026-01-23 09:56:21','2026-01-23 09:56:21',1,107,'4ad05a7b-44a4-48fe-adcb-12d80d30e2c6',39,'9bc2d47d48c446c7ae1fc44cd9c32878','volumes___DEFAULT__',-1,'2026-01-24 09:56:20',NULL),('2026-01-23 09:56:20','2026-01-23 09:56:21','2026-01-23 09:56:21',1,108,'b85297f2-1291-4ec6-ac1e-288379a625fb',40,'9bc2d47d48c446c7ae1fc44cd9c32878','gigabytes___DEFAULT__',-1,'2026-01-24 09:56:20',NULL),('2026-01-23 09:56:22','2026-01-23 09:56:22','2026-01-23 09:56:22',1,109,'72d17919-a5e9-41af-a303-c4bd7eaab018',37,'9bc2d47d48c446c7ae1fc44cd9c32878','volumes',-1,'2026-01-24 09:56:22',NULL),('2026-01-23 09:56:22','2026-01-23 09:56:22','2026-01-23 09:56:22',1,110,'7d0fd3be-a065-4937-87ce-79c5ed212d23',38,'9bc2d47d48c446c7ae1fc44cd9c32878','gigabytes',-1,'2026-01-24 09:56:22',NULL),('2026-01-23 09:56:22','2026-01-23 09:56:22','2026-01-23 09:56:22',1,111,'42c53f64-950f-4470-9e7e-73501a6f03ca',39,'9bc2d47d48c446c7ae1fc44cd9c32878','volumes___DEFAULT__',-1,'2026-01-24 09:56:22',NULL),('2026-01-23 09:56:22','2026-01-23 09:56:23','2026-01-23 09:56:22',1,112,'eb09ecf8-11f5-44ed-a740-b5e43f3845ae',40,'9bc2d47d48c446c7ae1fc44cd9c32878','gigabytes___DEFAULT__',-1,'2026-01-24 09:56:22',NULL),('2026-01-23 09:56:40','2026-01-23 09:56:40','2026-01-23 09:56:40',1,113,'6ccf266b-9e5f-4c2c-96be-3851419c89e2',41,'8924c80a71a94fdeb114c6bdbdb2939c','volumes',1,'2026-01-24 09:56:40',NULL),('2026-01-23 09:56:40','2026-01-23 09:56:40','2026-01-23 09:56:40',1,114,'221a2feb-358a-4301-be9b-828b65c3bf51',42,'8924c80a71a94fdeb114c6bdbdb2939c','gigabytes',1,'2026-01-24 09:56:40',NULL),('2026-01-23 09:56:40','2026-01-23 09:56:40','2026-01-23 09:56:40',1,115,'3b9ad710-8457-4b01-9389-4176c53a1df3',43,'8924c80a71a94fdeb114c6bdbdb2939c','volumes___DEFAULT__',1,'2026-01-24 09:56:40',NULL),('2026-01-23 09:56:40','2026-01-23 09:56:40','2026-01-23 09:56:40',1,116,'a024e7a7-1f94-4075-a749-49884f09615f',44,'8924c80a71a94fdeb114c6bdbdb2939c','gigabytes___DEFAULT__',1,'2026-01-24 09:56:40',NULL),('2026-01-23 09:56:54','2026-01-23 09:56:54','2026-01-23 09:56:54',1,117,'2ee08e10-b399-4913-a51e-f343fd358ffd',41,'8924c80a71a94fdeb114c6bdbdb2939c','volumes',1,'2026-01-24 09:56:54',NULL),('2026-01-23 09:56:54','2026-01-23 09:56:54','2026-01-23 09:56:54',1,118,'f9382e4e-b5df-4783-89a0-47b6fb755328',42,'8924c80a71a94fdeb114c6bdbdb2939c','gigabytes',1,'2026-01-24 09:56:54',NULL),('2026-01-23 09:56:54','2026-01-23 09:56:54','2026-01-23 09:56:54',1,119,'43633d4c-9097-4a6b-bb24-669c5b9ea406',43,'8924c80a71a94fdeb114c6bdbdb2939c','volumes___DEFAULT__',1,'2026-01-24 09:56:54',NULL),('2026-01-23 09:56:54','2026-01-23 09:56:54','2026-01-23 09:56:54',1,120,'e0c1ca98-6439-4b32-bed2-97924a0cce6e',44,'8924c80a71a94fdeb114c6bdbdb2939c','gigabytes___DEFAULT__',1,'2026-01-24 09:56:54',NULL),('2026-01-23 09:56:57','2026-01-23 09:56:57','2026-01-23 09:56:57',1,121,'a973386e-b933-4cf8-8a96-4c986b59bb8a',41,'8924c80a71a94fdeb114c6bdbdb2939c','volumes',1,'2026-01-24 09:56:57',NULL),('2026-01-23 09:56:57','2026-01-23 09:56:57','2026-01-23 09:56:57',1,122,'c88c825f-99cb-4fa0-84c6-e4736725220d',42,'8924c80a71a94fdeb114c6bdbdb2939c','gigabytes',1,'2026-01-24 09:56:57',NULL),('2026-01-23 09:56:57','2026-01-23 09:56:57','2026-01-23 09:56:57',1,123,'ca37842e-c540-48c1-ac62-e3f34a0d7c21',43,'8924c80a71a94fdeb114c6bdbdb2939c','volumes___DEFAULT__',1,'2026-01-24 09:56:57',NULL),('2026-01-23 09:56:57','2026-01-23 09:56:57','2026-01-23 09:56:57',1,124,'ef0479c7-ec3a-428e-8cc2-739453c38e37',44,'8924c80a71a94fdeb114c6bdbdb2939c','gigabytes___DEFAULT__',1,'2026-01-24 09:56:57',NULL),('2026-01-23 10:00:56','2026-01-23 10:00:56','2026-01-23 10:00:56',1,125,'a8625f5f-c92e-4dcc-b8f0-fed5c9dc0928',41,'8924c80a71a94fdeb114c6bdbdb2939c','volumes',-1,'2026-01-24 10:00:56',NULL),('2026-01-23 10:00:56','2026-01-23 10:00:56','2026-01-23 10:00:56',1,126,'55228795-df69-4e1a-858d-36a150d6234b',42,'8924c80a71a94fdeb114c6bdbdb2939c','gigabytes',-1,'2026-01-24 10:00:56',NULL),('2026-01-23 10:00:56','2026-01-23 10:00:56','2026-01-23 10:00:56',1,127,'6dad7009-8158-4929-833f-57617d528afa',43,'8924c80a71a94fdeb114c6bdbdb2939c','volumes___DEFAULT__',-1,'2026-01-24 10:00:56',NULL),('2026-01-23 10:00:56','2026-01-23 10:00:56','2026-01-23 10:00:56',1,128,'c42cb60b-b042-4a99-9237-d5d4be297933',44,'8924c80a71a94fdeb114c6bdbdb2939c','gigabytes___DEFAULT__',-1,'2026-01-24 10:00:56',NULL),('2026-01-23 10:00:58','2026-01-23 10:00:58','2026-01-23 10:00:58',1,129,'b691a261-4d0a-4e6d-8736-4a63cfaabf72',41,'8924c80a71a94fdeb114c6bdbdb2939c','volumes',-1,'2026-01-24 10:00:58',NULL),('2026-01-23 10:00:58','2026-01-23 10:00:58','2026-01-23 10:00:58',1,130,'9127c5aa-4812-4549-8553-66b4f7161dfc',42,'8924c80a71a94fdeb114c6bdbdb2939c','gigabytes',-1,'2026-01-24 10:00:58',NULL),('2026-01-23 10:00:58','2026-01-23 10:00:58','2026-01-23 10:00:58',1,131,'02a17f7e-f5a0-4542-873a-46b457f62888',43,'8924c80a71a94fdeb114c6bdbdb2939c','volumes___DEFAULT__',-1,'2026-01-24 10:00:58',NULL),('2026-01-23 10:00:58','2026-01-23 10:00:58','2026-01-23 10:00:58',1,132,'cbf06a12-a88e-4929-ad78-732f48ba0c4e',44,'8924c80a71a94fdeb114c6bdbdb2939c','gigabytes___DEFAULT__',-1,'2026-01-24 10:00:58',NULL),('2026-01-23 10:01:01','2026-01-23 10:01:01','2026-01-23 10:01:01',1,133,'7810cff0-d2cb-4331-b480-3396f297bb1d',41,'8924c80a71a94fdeb114c6bdbdb2939c','volumes',-1,'2026-01-24 10:01:01',NULL),('2026-01-23 10:01:01','2026-01-23 10:01:01','2026-01-23 10:01:01',1,134,'f1fac2a9-7c4b-4820-b0b0-5feacbaa3314',42,'8924c80a71a94fdeb114c6bdbdb2939c','gigabytes',-1,'2026-01-24 10:01:01',NULL),('2026-01-23 10:01:01','2026-01-23 10:01:01','2026-01-23 10:01:01',1,135,'811188a8-8238-4b41-bdfa-585f5ef149d0',43,'8924c80a71a94fdeb114c6bdbdb2939c','volumes___DEFAULT__',-1,'2026-01-24 10:01:01',NULL),('2026-01-23 10:01:01','2026-01-23 10:01:01','2026-01-23 10:01:01',1,136,'23138849-276a-4d9d-8d46-45cc0275721e',44,'8924c80a71a94fdeb114c6bdbdb2939c','gigabytes___DEFAULT__',-1,'2026-01-24 10:01:01',NULL),('2026-01-23 10:03:21','2026-01-23 10:03:21','2026-01-23 10:03:21',1,137,'5e6ffb03-b40e-4607-bbd6-9358f9eee5cc',45,'8c16cd713fa74a88b43e4edf01c273bd','volumes',1,'2026-01-24 10:03:21',NULL),('2026-01-23 10:03:21','2026-01-23 10:03:21','2026-01-23 10:03:21',1,138,'583ae230-5e68-4ceb-a8ce-4c601ec5755b',46,'8c16cd713fa74a88b43e4edf01c273bd','gigabytes',1,'2026-01-24 10:03:21',NULL),('2026-01-23 10:03:21','2026-01-23 10:03:21','2026-01-23 10:03:21',1,139,'a5ae6631-6b50-452c-b3cb-33183af9c0c3',47,'8c16cd713fa74a88b43e4edf01c273bd','volumes___DEFAULT__',1,'2026-01-24 10:03:21',NULL),('2026-01-23 10:03:21','2026-01-23 10:03:21','2026-01-23 10:03:21',1,140,'2d65d99d-3f1f-4159-b3d6-61dcd74d3436',48,'8c16cd713fa74a88b43e4edf01c273bd','gigabytes___DEFAULT__',1,'2026-01-24 10:03:21',NULL),('2026-01-23 10:05:18','2026-01-23 10:05:18','2026-01-23 10:05:18',1,141,'f595dc68-22c6-41b8-a57b-4fefeac53bc8',45,'8c16cd713fa74a88b43e4edf01c273bd','volumes',1,'2026-01-24 10:05:18',NULL),('2026-01-23 10:05:18','2026-01-23 10:05:18','2026-01-23 10:05:18',1,142,'a4cc8242-21f2-4757-8673-7e3a3ace8727',46,'8c16cd713fa74a88b43e4edf01c273bd','gigabytes',1,'2026-01-24 10:05:18',NULL),('2026-01-23 10:05:18','2026-01-23 10:05:18','2026-01-23 10:05:18',1,143,'e94cd023-18b6-42b5-b3b9-4404a2da948a',47,'8c16cd713fa74a88b43e4edf01c273bd','volumes___DEFAULT__',1,'2026-01-24 10:05:18',NULL),('2026-01-23 10:05:18','2026-01-23 10:05:18','2026-01-23 10:05:18',1,144,'7b39aeb1-749a-4295-af00-80557e2516a4',48,'8c16cd713fa74a88b43e4edf01c273bd','gigabytes___DEFAULT__',1,'2026-01-24 10:05:18',NULL),('2026-01-23 10:07:01','2026-01-23 10:07:01','2026-01-23 10:07:01',1,145,'83c69372-8966-4303-8cc2-b3c34f6df1df',45,'8c16cd713fa74a88b43e4edf01c273bd','volumes',-1,'2026-01-24 10:07:01',NULL),('2026-01-23 10:07:01','2026-01-23 10:07:01','2026-01-23 10:07:01',1,146,'3a7199dd-2e37-4d2a-a524-643636fd0452',46,'8c16cd713fa74a88b43e4edf01c273bd','gigabytes',-1,'2026-01-24 10:07:01',NULL),('2026-01-23 10:07:01','2026-01-23 10:07:01','2026-01-23 10:07:01',1,147,'77438d25-b01c-48ed-97c5-38d05846ed7c',47,'8c16cd713fa74a88b43e4edf01c273bd','volumes___DEFAULT__',-1,'2026-01-24 10:07:01',NULL),('2026-01-23 10:07:01','2026-01-23 10:07:01','2026-01-23 10:07:01',1,148,'1f40da1b-af1f-4659-aff2-6105e8a05d61',48,'8c16cd713fa74a88b43e4edf01c273bd','gigabytes___DEFAULT__',-1,'2026-01-24 10:07:01',NULL),('2026-01-23 10:07:08','2026-01-23 10:07:08','2026-01-23 10:07:08',1,149,'ceb23881-dd0b-4da1-9395-c9eb209bdb10',45,'8c16cd713fa74a88b43e4edf01c273bd','volumes',-1,'2026-01-24 10:07:08',NULL),('2026-01-23 10:07:08','2026-01-23 10:07:08','2026-01-23 10:07:08',1,150,'d842a4e6-089f-4186-bcf1-d9b942122dcd',46,'8c16cd713fa74a88b43e4edf01c273bd','gigabytes',-1,'2026-01-24 10:07:08',NULL),('2026-01-23 10:07:08','2026-01-23 10:07:08','2026-01-23 10:07:08',1,151,'c6c9aefc-d249-4187-838b-2cb2f570b9cd',47,'8c16cd713fa74a88b43e4edf01c273bd','volumes___DEFAULT__',-1,'2026-01-24 10:07:08',NULL),('2026-01-23 10:07:08','2026-01-23 10:07:08','2026-01-23 10:07:08',1,152,'739c45c1-6c69-42e3-b4b5-e86ae992b898',48,'8c16cd713fa74a88b43e4edf01c273bd','gigabytes___DEFAULT__',-1,'2026-01-24 10:07:08',NULL),('2026-01-23 10:07:47','2026-01-23 10:07:47','2026-01-23 10:07:47',1,153,'2c5da369-da0b-47dd-8223-8f1ac05c83d5',49,'924f976bcbb74ec195730b68eebe1f2a','volumes',1,'2026-01-24 10:07:47',NULL),('2026-01-23 10:07:47','2026-01-23 10:07:47','2026-01-23 10:07:47',1,154,'1031925a-4e1c-4884-a2e6-09f94b687943',50,'924f976bcbb74ec195730b68eebe1f2a','gigabytes',1,'2026-01-24 10:07:47',NULL),('2026-01-23 10:07:47','2026-01-23 10:07:47','2026-01-23 10:07:47',1,155,'a4923fe3-2d68-4097-8308-b392c9bcc1d5',51,'924f976bcbb74ec195730b68eebe1f2a','volumes___DEFAULT__',1,'2026-01-24 10:07:47',NULL),('2026-01-23 10:07:47','2026-01-23 10:07:47','2026-01-23 10:07:47',1,156,'b960ab88-8e93-4045-a7b4-55a9508bd47b',52,'924f976bcbb74ec195730b68eebe1f2a','gigabytes___DEFAULT__',1,'2026-01-24 10:07:47',NULL),('2026-01-23 10:08:45','2026-01-23 10:08:45','2026-01-23 10:08:45',1,157,'bdfbdd24-ee1b-4721-8adc-5f980462a99b',53,'746ea02b745c4e21ace4cb49c193899d','volumes',1,'2026-01-24 10:08:45',NULL),('2026-01-23 10:08:45','2026-01-23 10:08:45','2026-01-23 10:08:45',1,158,'21c9ce5d-2118-4e3e-8eff-e3119f581917',54,'746ea02b745c4e21ace4cb49c193899d','gigabytes',1,'2026-01-24 10:08:45',NULL),('2026-01-23 10:08:45','2026-01-23 10:08:45','2026-01-23 10:08:45',1,159,'6b5b9b1d-6586-47ff-942b-b44ea4998bb8',55,'746ea02b745c4e21ace4cb49c193899d','volumes___DEFAULT__',1,'2026-01-24 10:08:45',NULL),('2026-01-23 10:08:45','2026-01-23 10:08:45','2026-01-23 10:08:45',1,160,'1b8475e3-912d-465b-a968-abcc982dbabc',56,'746ea02b745c4e21ace4cb49c193899d','gigabytes___DEFAULT__',1,'2026-01-24 10:08:45',NULL),('2026-01-23 10:08:51','2026-01-23 10:08:51','2026-01-23 10:08:51',1,161,'06f18089-5cfa-4332-8ca6-c33fcd599439',53,'746ea02b745c4e21ace4cb49c193899d','volumes',1,'2026-01-24 10:08:51',NULL),('2026-01-23 10:08:51','2026-01-23 10:08:51','2026-01-23 10:08:51',1,162,'4e54a938-8158-427b-a5a7-02218e3b5c63',54,'746ea02b745c4e21ace4cb49c193899d','gigabytes',1,'2026-01-24 10:08:51',NULL),('2026-01-23 10:08:51','2026-01-23 10:08:51','2026-01-23 10:08:51',1,163,'fd6048a1-538d-4560-9665-83820b0577ec',55,'746ea02b745c4e21ace4cb49c193899d','volumes___DEFAULT__',1,'2026-01-24 10:08:51',NULL),('2026-01-23 10:08:51','2026-01-23 10:08:51','2026-01-23 10:08:51',1,164,'553bec25-5482-4805-8d31-dac541f98227',56,'746ea02b745c4e21ace4cb49c193899d','gigabytes___DEFAULT__',1,'2026-01-24 10:08:51',NULL),('2026-01-23 10:09:55','2026-01-23 10:09:55','2026-01-23 10:09:55',1,165,'c721337a-9100-412a-804b-b89ed17ece9f',49,'924f976bcbb74ec195730b68eebe1f2a','volumes',1,'2026-01-24 10:09:55',NULL),('2026-01-23 10:09:55','2026-01-23 10:09:55','2026-01-23 10:09:55',1,166,'5df950f7-bc17-4f0a-b6b7-8e4f8ebe77f9',50,'924f976bcbb74ec195730b68eebe1f2a','gigabytes',1,'2026-01-24 10:09:55',NULL),('2026-01-23 10:09:55','2026-01-23 10:09:55','2026-01-23 10:09:55',1,167,'dc8e01c4-0556-4d34-bc67-73ef697bd5b6',51,'924f976bcbb74ec195730b68eebe1f2a','volumes___DEFAULT__',1,'2026-01-24 10:09:55',NULL),('2026-01-23 10:09:55','2026-01-23 10:09:55','2026-01-23 10:09:55',1,168,'15915850-41b3-4784-890a-9cea87050d2e',52,'924f976bcbb74ec195730b68eebe1f2a','gigabytes___DEFAULT__',1,'2026-01-24 10:09:55',NULL),('2026-01-23 10:10:56','2026-01-23 10:10:56','2026-01-23 10:10:56',1,169,'0d6141f5-c43e-4050-9c64-fe7cb6e025b1',49,'924f976bcbb74ec195730b68eebe1f2a','volumes',1,'2026-01-24 10:10:56',NULL),('2026-01-23 10:10:56','2026-01-23 10:10:56','2026-01-23 10:10:56',1,170,'bb4b9539-16f4-4d29-a8f0-1f055ec6b1cd',50,'924f976bcbb74ec195730b68eebe1f2a','gigabytes',1,'2026-01-24 10:10:56',NULL),('2026-01-23 10:10:56','2026-01-23 10:10:56','2026-01-23 10:10:56',1,171,'e0981452-d151-4a2c-9380-9f64a14d69bd',51,'924f976bcbb74ec195730b68eebe1f2a','volumes___DEFAULT__',1,'2026-01-24 10:10:56',NULL),('2026-01-23 10:10:56','2026-01-23 10:10:56','2026-01-23 10:10:56',1,172,'0a143687-afc2-427f-9112-c954c1a27c0c',52,'924f976bcbb74ec195730b68eebe1f2a','gigabytes___DEFAULT__',1,'2026-01-24 10:10:56',NULL),('2026-01-23 10:11:16','2026-01-23 10:11:16','2026-01-23 10:11:16',1,173,'186c7ae6-b23b-4f48-ab8e-867f610d6ce3',49,'924f976bcbb74ec195730b68eebe1f2a','volumes',-1,'2026-01-24 10:11:16',NULL),('2026-01-23 10:11:16','2026-01-23 10:11:16','2026-01-23 10:11:16',1,174,'cd638834-0e55-44a0-9f4c-60eecae1736d',50,'924f976bcbb74ec195730b68eebe1f2a','gigabytes',-1,'2026-01-24 10:11:16',NULL),('2026-01-23 10:11:16','2026-01-23 10:11:16','2026-01-23 10:11:16',1,175,'f1f819a4-d11e-4453-a4cd-5780cdb4ab45',51,'924f976bcbb74ec195730b68eebe1f2a','volumes___DEFAULT__',-1,'2026-01-24 10:11:16',NULL),('2026-01-23 10:11:16','2026-01-23 10:11:16','2026-01-23 10:11:16',1,176,'1f249f0f-6898-4db6-b799-5da2b5858005',52,'924f976bcbb74ec195730b68eebe1f2a','gigabytes___DEFAULT__',-1,'2026-01-24 10:11:16',NULL),('2026-01-23 10:11:21','2026-01-23 10:11:22','2026-01-23 10:11:22',1,177,'12f4eb5b-3ce5-4240-b67f-ccc752de2b19',49,'924f976bcbb74ec195730b68eebe1f2a','volumes',-1,'2026-01-24 10:11:21',NULL),('2026-01-23 10:11:21','2026-01-23 10:11:22','2026-01-23 10:11:22',1,178,'7d256e10-7cac-4ac4-88d6-7c98d6205b75',50,'924f976bcbb74ec195730b68eebe1f2a','gigabytes',-1,'2026-01-24 10:11:21',NULL),('2026-01-23 10:11:21','2026-01-23 10:11:22','2026-01-23 10:11:22',1,179,'9fd1a8a7-437f-4f70-8be2-a332a927482a',51,'924f976bcbb74ec195730b68eebe1f2a','volumes___DEFAULT__',-1,'2026-01-24 10:11:21',NULL),('2026-01-23 10:11:21','2026-01-23 10:11:22','2026-01-23 10:11:22',1,180,'6aafaf7b-dee8-4d52-8ff6-c979729ba599',52,'924f976bcbb74ec195730b68eebe1f2a','gigabytes___DEFAULT__',-1,'2026-01-24 10:11:21',NULL),('2026-01-23 10:11:24','2026-01-23 10:11:25','2026-01-23 10:11:25',1,181,'8aba6001-91a6-45ea-9d2b-8447f19f7659',49,'924f976bcbb74ec195730b68eebe1f2a','volumes',-1,'2026-01-24 10:11:24',NULL),('2026-01-23 10:11:24','2026-01-23 10:11:25','2026-01-23 10:11:25',1,182,'6ab64e19-94f6-4556-8de1-bfc3976cee94',50,'924f976bcbb74ec195730b68eebe1f2a','gigabytes',-1,'2026-01-24 10:11:24',NULL),('2026-01-23 10:11:24','2026-01-23 10:11:25','2026-01-23 10:11:25',1,183,'3449e130-b66b-4c01-9916-66014732700c',51,'924f976bcbb74ec195730b68eebe1f2a','volumes___DEFAULT__',-1,'2026-01-24 10:11:24',NULL),('2026-01-23 10:11:24','2026-01-23 10:11:25','2026-01-23 10:11:25',1,184,'92cf9518-f65a-402e-96b1-85c5bfa57c8f',52,'924f976bcbb74ec195730b68eebe1f2a','gigabytes___DEFAULT__',-1,'2026-01-24 10:11:24',NULL),('2026-01-23 10:11:30','2026-01-23 10:11:30','2026-01-23 10:11:30',1,185,'b381c952-e44a-48bc-b824-1119bc611a79',57,'9dd869ce76e44fc8a82b8bbee1654d33','volumes',1,'2026-01-24 10:11:30',NULL),('2026-01-23 10:11:30','2026-01-23 10:11:30','2026-01-23 10:11:30',1,186,'59cb318d-564c-4c3f-8a89-e84e2b080c3b',58,'9dd869ce76e44fc8a82b8bbee1654d33','gigabytes',1,'2026-01-24 10:11:30',NULL),('2026-01-23 10:11:30','2026-01-23 10:11:30','2026-01-23 10:11:30',1,187,'6716c19d-1ab5-4fe9-bb74-5d721ec16923',59,'9dd869ce76e44fc8a82b8bbee1654d33','volumes___DEFAULT__',1,'2026-01-24 10:11:30',NULL),('2026-01-23 10:11:30','2026-01-23 10:11:30','2026-01-23 10:11:30',1,188,'3f412a4d-8ba7-4e85-a83b-523fc51fa702',60,'9dd869ce76e44fc8a82b8bbee1654d33','gigabytes___DEFAULT__',1,'2026-01-24 10:11:30',NULL),('2026-01-23 10:11:39','2026-01-23 10:11:39','2026-01-23 10:11:39',1,189,'0f554055-a63f-4254-afdb-64b5953d7c74',61,'7c9246f4d92c4dfbbb8111cfef809201','volumes',1,'2026-01-24 10:11:39',NULL),('2026-01-23 10:11:39','2026-01-23 10:11:39','2026-01-23 10:11:39',1,190,'1e7c706a-5211-499e-9cd6-d3bed237f613',62,'7c9246f4d92c4dfbbb8111cfef809201','gigabytes',1,'2026-01-24 10:11:39',NULL),('2026-01-23 10:11:39','2026-01-23 10:11:39','2026-01-23 10:11:39',1,191,'252a4ef7-55fc-40a3-83eb-7339313b7865',63,'7c9246f4d92c4dfbbb8111cfef809201','volumes___DEFAULT__',1,'2026-01-24 10:11:39',NULL),('2026-01-23 10:11:39','2026-01-23 10:11:39','2026-01-23 10:11:39',1,192,'c54df903-db49-470b-a639-6345691c0dff',64,'7c9246f4d92c4dfbbb8111cfef809201','gigabytes___DEFAULT__',1,'2026-01-24 10:11:39',NULL),('2026-01-23 10:11:42','2026-01-23 10:11:42','2026-01-23 10:11:42',1,193,'f7ce8372-68e0-4f8d-8d49-e1630564fe81',61,'7c9246f4d92c4dfbbb8111cfef809201','volumes',-1,'2026-01-24 10:11:42',NULL),('2026-01-23 10:11:42','2026-01-23 10:11:42','2026-01-23 10:11:42',1,194,'dbee61d8-0c06-4ced-8e7d-7ac884a90b21',62,'7c9246f4d92c4dfbbb8111cfef809201','gigabytes',-1,'2026-01-24 10:11:42',NULL),('2026-01-23 10:11:42','2026-01-23 10:11:42','2026-01-23 10:11:42',1,195,'10f5be64-3d61-4f8c-9b8c-dc23f8eef24b',63,'7c9246f4d92c4dfbbb8111cfef809201','volumes___DEFAULT__',-1,'2026-01-24 10:11:42',NULL),('2026-01-23 10:11:42','2026-01-23 10:11:42','2026-01-23 10:11:42',1,196,'f77f9f26-b335-4ea9-9c29-e519390ee564',64,'7c9246f4d92c4dfbbb8111cfef809201','gigabytes___DEFAULT__',-1,'2026-01-24 10:11:42',NULL),('2026-01-23 10:11:53','2026-01-23 10:11:53','2026-01-23 10:11:53',1,197,'e2341d66-05e5-4c6b-b6f5-12bba131cefd',53,'746ea02b745c4e21ace4cb49c193899d','volumes',-1,'2026-01-24 10:11:53',NULL),('2026-01-23 10:11:53','2026-01-23 10:11:53','2026-01-23 10:11:53',1,198,'fc855198-ced8-46e7-9ce6-e8a01230892e',54,'746ea02b745c4e21ace4cb49c193899d','gigabytes',-1,'2026-01-24 10:11:53',NULL),('2026-01-23 10:11:53','2026-01-23 10:11:53','2026-01-23 10:11:53',1,199,'dd9a6876-5b96-456d-8cba-3f25004ace91',55,'746ea02b745c4e21ace4cb49c193899d','volumes___DEFAULT__',-1,'2026-01-24 10:11:53',NULL),('2026-01-23 10:11:53','2026-01-23 10:11:53','2026-01-23 10:11:53',1,200,'929839b3-0e7f-4018-b193-1909183d78a9',56,'746ea02b745c4e21ace4cb49c193899d','gigabytes___DEFAULT__',-1,'2026-01-24 10:11:53',NULL),('2026-01-23 10:11:57','2026-01-23 10:11:57','2026-01-23 10:11:57',1,201,'6fc13cfd-a00a-41e3-ba98-c8ad2ad3067a',53,'746ea02b745c4e21ace4cb49c193899d','volumes',-1,'2026-01-24 10:11:57',NULL),('2026-01-23 10:11:57','2026-01-23 10:11:57','2026-01-23 10:11:57',1,202,'15dbca2a-1ad6-4e9f-b8a4-43ffa8a94840',54,'746ea02b745c4e21ace4cb49c193899d','gigabytes',-1,'2026-01-24 10:11:57',NULL),('2026-01-23 10:11:57','2026-01-23 10:11:57','2026-01-23 10:11:57',1,203,'cd863ddc-247e-4636-93d2-69e8314d423b',55,'746ea02b745c4e21ace4cb49c193899d','volumes___DEFAULT__',-1,'2026-01-24 10:11:57',NULL),('2026-01-23 10:11:57','2026-01-23 10:11:57','2026-01-23 10:11:57',1,204,'bb2d8329-351d-48e4-a7e8-6673c221dfbc',56,'746ea02b745c4e21ace4cb49c193899d','gigabytes___DEFAULT__',-1,'2026-01-24 10:11:57',NULL),('2026-01-23 10:13:35','2026-01-23 10:13:35','2026-01-23 10:13:35',1,205,'d2e3338d-aae9-4566-aac5-da382f149356',65,'0a6ba16c4b9d49d3bc24cd7b44935d1f','volumes',1,'2026-01-24 10:13:35',NULL),('2026-01-23 10:13:35','2026-01-23 10:13:35','2026-01-23 10:13:35',1,206,'6ede0c8c-4c40-4cd8-bfbd-ad7562fa60fd',66,'0a6ba16c4b9d49d3bc24cd7b44935d1f','gigabytes',1,'2026-01-24 10:13:35',NULL),('2026-01-23 10:13:35','2026-01-23 10:13:35','2026-01-23 10:13:35',1,207,'85be2975-e72e-4e91-8595-9237a1e54a7b',67,'0a6ba16c4b9d49d3bc24cd7b44935d1f','volumes___DEFAULT__',1,'2026-01-24 10:13:35',NULL),('2026-01-23 10:13:35','2026-01-23 10:13:35','2026-01-23 10:13:35',1,208,'c5d4c58f-657c-47e0-9499-e21b0cbd1087',68,'0a6ba16c4b9d49d3bc24cd7b44935d1f','gigabytes___DEFAULT__',1,'2026-01-24 10:13:35',NULL),('2026-01-23 10:14:07','2026-01-23 10:14:07','2026-01-23 10:14:07',1,209,'ffab6299-2451-4698-94dd-0e5a3000c04f',65,'0a6ba16c4b9d49d3bc24cd7b44935d1f','volumes',1,'2026-01-24 10:14:07',NULL),('2026-01-23 10:14:07','2026-01-23 10:14:07','2026-01-23 10:14:07',1,210,'8bab4148-49bb-4f03-a03f-1ff3b90b5da2',66,'0a6ba16c4b9d49d3bc24cd7b44935d1f','gigabytes',1,'2026-01-24 10:14:07',NULL),('2026-01-23 10:14:07','2026-01-23 10:14:07','2026-01-23 10:14:07',1,211,'5249ae5b-11cc-4462-87f6-c559b0df3733',67,'0a6ba16c4b9d49d3bc24cd7b44935d1f','volumes___DEFAULT__',1,'2026-01-24 10:14:07',NULL),('2026-01-23 10:14:07','2026-01-23 10:14:07','2026-01-23 10:14:07',1,212,'56fffd5b-9912-48ec-9d28-ceb868133739',68,'0a6ba16c4b9d49d3bc24cd7b44935d1f','gigabytes___DEFAULT__',1,'2026-01-24 10:14:07',NULL),('2026-01-23 10:14:19','2026-01-23 10:14:19','2026-01-23 10:14:19',1,213,'1a275358-09da-4e7f-a7d0-4415f5322ef4',69,'3ae621f21a8e438fb95152309b38cee5','volumes',1,'2026-01-24 10:14:19',NULL),('2026-01-23 10:14:19','2026-01-23 10:14:19','2026-01-23 10:14:19',1,214,'3c176489-f928-44fa-b8da-01d88f908c77',70,'3ae621f21a8e438fb95152309b38cee5','gigabytes',1,'2026-01-24 10:14:19',NULL),('2026-01-23 10:14:19','2026-01-23 10:14:19','2026-01-23 10:14:19',1,215,'80655640-1840-4fbd-9b49-d87ab3c94d81',71,'3ae621f21a8e438fb95152309b38cee5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1036888469-1438475917',1,'2026-01-24 10:14:19',NULL),('2026-01-23 10:14:19','2026-01-23 10:14:19','2026-01-23 10:14:19',1,216,'1048199b-523c-41db-be30-f0635e67c5f5',72,'3ae621f21a8e438fb95152309b38cee5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1036888469-1438475917',1,'2026-01-24 10:14:19',NULL),('2026-01-23 10:14:19','2026-01-23 10:14:20','2026-01-23 10:14:20',1,217,'25c37020-cf26-4d57-b80e-b015d4839633',69,'3ae621f21a8e438fb95152309b38cee5','volumes',1,'2026-01-24 10:14:19',NULL),('2026-01-23 10:14:19','2026-01-23 10:14:20','2026-01-23 10:14:20',1,218,'adcedb4d-8366-4412-b5d9-b9e91ac07ffa',70,'3ae621f21a8e438fb95152309b38cee5','gigabytes',1,'2026-01-24 10:14:19',NULL),('2026-01-23 10:14:19','2026-01-23 10:14:20','2026-01-23 10:14:20',1,219,'ad3e5a0a-7b8e-4fd0-8166-a208c0268853',73,'3ae621f21a8e438fb95152309b38cee5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-968827984-727097193',1,'2026-01-24 10:14:19',NULL),('2026-01-23 10:14:19','2026-01-23 10:14:20','2026-01-23 10:14:20',1,220,'a488ea95-57bc-429b-b70a-d4f28b18db26',74,'3ae621f21a8e438fb95152309b38cee5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-968827984-727097193',1,'2026-01-24 10:14:19',NULL),('2026-01-23 10:14:20','2026-01-23 10:14:20','2026-01-23 10:14:20',1,221,'41144208-c451-4576-87d2-eb1046892ac9',69,'3ae621f21a8e438fb95152309b38cee5','volumes',1,'2026-01-24 10:14:20',NULL),('2026-01-23 10:14:20','2026-01-23 10:14:20','2026-01-23 10:14:20',1,222,'d5d67247-83ab-432c-b936-ae26c86e478f',70,'3ae621f21a8e438fb95152309b38cee5','gigabytes',1,'2026-01-24 10:14:20',NULL),('2026-01-23 10:14:20','2026-01-23 10:14:20','2026-01-23 10:14:20',1,223,'7570f63e-e658-4dfe-9d9f-1bab947dc271',71,'3ae621f21a8e438fb95152309b38cee5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1036888469-1438475917',1,'2026-01-24 10:14:20',NULL),('2026-01-23 10:14:20','2026-01-23 10:14:20','2026-01-23 10:14:20',1,224,'6d27da43-7377-4baf-a042-4c3a9f04f2c4',72,'3ae621f21a8e438fb95152309b38cee5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1036888469-1438475917',1,'2026-01-24 10:14:20',NULL),('2026-01-23 10:14:20','2026-01-23 10:14:20','2026-01-23 10:14:20',1,225,'4214b32d-4d20-4999-b11e-3bff20059121',69,'3ae621f21a8e438fb95152309b38cee5','volumes',1,'2026-01-24 10:14:20',NULL),('2026-01-23 10:14:20','2026-01-23 10:14:20','2026-01-23 10:14:20',1,226,'e70527a4-fbbd-416c-806e-38722b85577e',70,'3ae621f21a8e438fb95152309b38cee5','gigabytes',1,'2026-01-24 10:14:20',NULL),('2026-01-23 10:14:20','2026-01-23 10:14:20','2026-01-23 10:14:20',1,227,'18ac6653-7fa6-47d8-9466-a5c9d8f7fc32',73,'3ae621f21a8e438fb95152309b38cee5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-968827984-727097193',1,'2026-01-24 10:14:20',NULL),('2026-01-23 10:14:20','2026-01-23 10:14:20','2026-01-23 10:14:20',1,228,'f70e4d6b-3b57-46e3-81dd-31d87f52c00b',74,'3ae621f21a8e438fb95152309b38cee5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-968827984-727097193',1,'2026-01-24 10:14:20',NULL),('2026-01-23 10:14:20','2026-01-23 10:14:20','2026-01-23 10:14:20',1,229,'4c4bd281-4372-475d-b3f5-470618278ba2',69,'3ae621f21a8e438fb95152309b38cee5','volumes',1,'2026-01-24 10:14:20',NULL),('2026-01-23 10:14:20','2026-01-23 10:14:20','2026-01-23 10:14:20',1,230,'79a7b22e-1138-4f62-bb9c-20c6c0f05ab0',70,'3ae621f21a8e438fb95152309b38cee5','gigabytes',1,'2026-01-24 10:14:20',NULL),('2026-01-23 10:14:20','2026-01-23 10:14:20','2026-01-23 10:14:20',1,231,'66940aa6-f386-47e2-a58b-db6db792b822',71,'3ae621f21a8e438fb95152309b38cee5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1036888469-1438475917',1,'2026-01-24 10:14:20',NULL),('2026-01-23 10:14:20','2026-01-23 10:14:20','2026-01-23 10:14:20',1,232,'294b6f91-d997-4cb5-a6af-37eab1f41cea',72,'3ae621f21a8e438fb95152309b38cee5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1036888469-1438475917',1,'2026-01-24 10:14:20',NULL),('2026-01-23 10:14:21','2026-01-23 10:14:21','2026-01-23 10:14:21',1,233,'bb74bf75-1401-491d-b126-c6d4b4d862c5',69,'3ae621f21a8e438fb95152309b38cee5','volumes',1,'2026-01-24 10:14:21',NULL),('2026-01-23 10:14:21','2026-01-23 10:14:21','2026-01-23 10:14:21',1,234,'60d7a86e-cd59-40a9-b730-cf4aefb6cd13',70,'3ae621f21a8e438fb95152309b38cee5','gigabytes',1,'2026-01-24 10:14:21',NULL),('2026-01-23 10:14:21','2026-01-23 10:14:21','2026-01-23 10:14:21',1,235,'86dd4b42-09ca-4342-8ee9-91fb894a2a0e',73,'3ae621f21a8e438fb95152309b38cee5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-968827984-727097193',1,'2026-01-24 10:14:21',NULL),('2026-01-23 10:14:21','2026-01-23 10:14:21','2026-01-23 10:14:21',1,236,'c3f054bd-52dd-4146-a5b2-b8e21b1af410',74,'3ae621f21a8e438fb95152309b38cee5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-968827984-727097193',1,'2026-01-24 10:14:21',NULL),('2026-01-23 10:14:22','2026-01-23 10:14:23','2026-01-23 10:14:23',1,237,'02cc8c54-51d9-47b9-b1fe-810e6fd0ed20',69,'3ae621f21a8e438fb95152309b38cee5','volumes',1,'2026-01-24 10:14:22',NULL),('2026-01-23 10:14:22','2026-01-23 10:14:23','2026-01-23 10:14:23',1,238,'f8e86601-c398-4ce8-add9-2e7e7fd0b566',70,'3ae621f21a8e438fb95152309b38cee5','gigabytes',1,'2026-01-24 10:14:22',NULL),('2026-01-23 10:14:22','2026-01-23 10:14:23','2026-01-23 10:14:23',1,239,'49483a77-5270-44e2-9707-c8ef0315242b',75,'3ae621f21a8e438fb95152309b38cee5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1177848314-496428426',1,'2026-01-24 10:14:22',NULL),('2026-01-23 10:14:22','2026-01-23 10:14:23','2026-01-23 10:14:23',1,240,'54b5392c-4d3d-438b-922f-62a645366082',76,'3ae621f21a8e438fb95152309b38cee5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1177848314-496428426',1,'2026-01-24 10:14:22',NULL),('2026-01-23 10:14:31','2026-01-23 10:14:33','2026-01-23 10:14:33',1,241,'d2129ad1-603d-4721-92dd-d84e65bc9e24',69,'3ae621f21a8e438fb95152309b38cee5','volumes',1,'2026-01-24 10:14:31',NULL),('2026-01-23 10:14:31','2026-01-23 10:14:33','2026-01-23 10:14:33',1,242,'e8291355-76d5-431f-804f-0f4fa37b4b8f',70,'3ae621f21a8e438fb95152309b38cee5','gigabytes',1,'2026-01-24 10:14:31',NULL),('2026-01-23 10:14:31','2026-01-23 10:14:33','2026-01-23 10:14:33',1,243,'2aaa9856-a6f3-4a83-8d6c-cbb826320cbc',75,'3ae621f21a8e438fb95152309b38cee5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1177848314-496428426',1,'2026-01-24 10:14:31',NULL),('2026-01-23 10:14:31','2026-01-23 10:14:33','2026-01-23 10:14:33',1,244,'a397a70c-5ff3-4422-8d4a-bd6a97c9546d',76,'3ae621f21a8e438fb95152309b38cee5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1177848314-496428426',1,'2026-01-24 10:14:31',NULL),('2026-01-23 10:14:35','2026-01-23 10:14:35','2026-01-23 10:14:35',1,245,'1dfb14b4-93f9-4b69-8dc4-ec16dd3e3b06',69,'3ae621f21a8e438fb95152309b38cee5','volumes',1,'2026-01-24 10:14:35',NULL),('2026-01-23 10:14:35','2026-01-23 10:14:35','2026-01-23 10:14:35',1,246,'e92013f9-bc6b-4912-9554-0387ab2e1d8e',70,'3ae621f21a8e438fb95152309b38cee5','gigabytes',1,'2026-01-24 10:14:35',NULL),('2026-01-23 10:14:35','2026-01-23 10:14:35','2026-01-23 10:14:35',1,247,'a97830c7-72f5-4aaf-9c72-53c38b0ee8c6',75,'3ae621f21a8e438fb95152309b38cee5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1177848314-496428426',1,'2026-01-24 10:14:35',NULL),('2026-01-23 10:14:35','2026-01-23 10:14:35','2026-01-23 10:14:35',1,248,'e73d5fc6-3117-490c-9d3d-20c01b9b16fb',76,'3ae621f21a8e438fb95152309b38cee5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1177848314-496428426',1,'2026-01-24 10:14:35',NULL),('2026-01-23 10:15:27','2026-01-23 10:15:27','2026-01-23 10:15:27',1,249,'05a8af79-f470-4b24-b455-562998ec79c3',57,'9dd869ce76e44fc8a82b8bbee1654d33','volumes',-1,'2026-01-24 10:15:27',NULL),('2026-01-23 10:15:27','2026-01-23 10:15:27','2026-01-23 10:15:27',1,250,'9e857c32-14c9-4d2d-81a3-c0f4087d48d0',58,'9dd869ce76e44fc8a82b8bbee1654d33','gigabytes',-1,'2026-01-24 10:15:27',NULL),('2026-01-23 10:15:27','2026-01-23 10:15:27','2026-01-23 10:15:27',1,251,'46a24cff-a973-4295-a51c-c373bda895cf',59,'9dd869ce76e44fc8a82b8bbee1654d33','volumes___DEFAULT__',-1,'2026-01-24 10:15:27',NULL),('2026-01-23 10:15:27','2026-01-23 10:15:27','2026-01-23 10:15:27',1,252,'ec7e7127-29c3-4b93-afb2-9be59a4eeec2',60,'9dd869ce76e44fc8a82b8bbee1654d33','gigabytes___DEFAULT__',-1,'2026-01-24 10:15:27',NULL),('2026-01-23 10:15:49','2026-01-23 10:15:49','2026-01-23 10:15:49',1,253,'f95396ed-8a5c-41e8-8b38-06b94a5f385c',69,'3ae621f21a8e438fb95152309b38cee5','volumes',-1,'2026-01-24 10:15:49',NULL),('2026-01-23 10:15:49','2026-01-23 10:15:49','2026-01-23 10:15:49',1,254,'68152bae-0122-439d-86b5-492d7f3eab2a',70,'3ae621f21a8e438fb95152309b38cee5','gigabytes',-1,'2026-01-24 10:15:49',NULL),('2026-01-23 10:15:49','2026-01-23 10:15:49','2026-01-23 10:15:49',1,255,'55fbd8d9-33dc-426d-a3ce-ac06d0dfc773',71,'3ae621f21a8e438fb95152309b38cee5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1036888469-1438475917',-1,'2026-01-24 10:15:49',NULL),('2026-01-23 10:15:49','2026-01-23 10:15:49','2026-01-23 10:15:49',1,256,'94862022-3b77-49cb-9dbb-5ce72ee0c097',72,'3ae621f21a8e438fb95152309b38cee5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1036888469-1438475917',-1,'2026-01-24 10:15:49',NULL),('2026-01-23 10:15:55','2026-01-23 10:15:55','2026-01-23 10:15:55',1,257,'f4a50709-7d9c-424a-b581-c35279af2e19',69,'3ae621f21a8e438fb95152309b38cee5','volumes',-1,'2026-01-24 10:15:55',NULL),('2026-01-23 10:15:55','2026-01-23 10:15:55','2026-01-23 10:15:55',1,258,'e270b97b-e175-4d49-981f-2b4310e71008',70,'3ae621f21a8e438fb95152309b38cee5','gigabytes',-1,'2026-01-24 10:15:55',NULL),('2026-01-23 10:15:55','2026-01-23 10:15:55','2026-01-23 10:15:55',1,259,'d0243f51-f2c4-40c9-85df-ae60a7eb13ff',73,'3ae621f21a8e438fb95152309b38cee5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-968827984-727097193',-1,'2026-01-24 10:15:55',NULL),('2026-01-23 10:15:55','2026-01-23 10:15:55','2026-01-23 10:15:55',1,260,'bc45e8d2-d39f-49f5-8442-85ba1988e6b2',74,'3ae621f21a8e438fb95152309b38cee5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-968827984-727097193',-1,'2026-01-24 10:15:55',NULL),('2026-01-23 10:16:19','2026-01-23 10:16:19','2026-01-23 10:16:19',1,261,'5c59e759-e1e2-46a2-8348-1f056658d1bc',65,'0a6ba16c4b9d49d3bc24cd7b44935d1f','volumes',-1,'2026-01-24 10:16:19',NULL),('2026-01-23 10:16:19','2026-01-23 10:16:19','2026-01-23 10:16:19',1,262,'2c7a3bf0-4856-4ead-954e-d9b397845934',66,'0a6ba16c4b9d49d3bc24cd7b44935d1f','gigabytes',-1,'2026-01-24 10:16:19',NULL),('2026-01-23 10:16:19','2026-01-23 10:16:20','2026-01-23 10:16:19',1,263,'3b1caa59-d6a3-4ac9-b193-08283078dd1b',67,'0a6ba16c4b9d49d3bc24cd7b44935d1f','volumes___DEFAULT__',-1,'2026-01-24 10:16:19',NULL),('2026-01-23 10:16:19','2026-01-23 10:16:20','2026-01-23 10:16:20',1,264,'c2639ed3-3969-4ea7-a631-bbeca82981c5',68,'0a6ba16c4b9d49d3bc24cd7b44935d1f','gigabytes___DEFAULT__',-1,'2026-01-24 10:16:19',NULL),('2026-01-23 10:16:21','2026-01-23 10:16:21','2026-01-23 10:16:21',1,265,'6997f162-44fa-4249-95eb-cd123d315df9',65,'0a6ba16c4b9d49d3bc24cd7b44935d1f','volumes',-1,'2026-01-24 10:16:21',NULL),('2026-01-23 10:16:21','2026-01-23 10:16:21','2026-01-23 10:16:21',1,266,'e5d71843-157f-4d08-89c2-cdedf6b2781a',66,'0a6ba16c4b9d49d3bc24cd7b44935d1f','gigabytes',-1,'2026-01-24 10:16:21',NULL),('2026-01-23 10:16:21','2026-01-23 10:16:21','2026-01-23 10:16:21',1,267,'9e25677e-12af-407c-a436-eca2c19548f4',67,'0a6ba16c4b9d49d3bc24cd7b44935d1f','volumes___DEFAULT__',-1,'2026-01-24 10:16:21',NULL),('2026-01-23 10:16:21','2026-01-23 10:16:21','2026-01-23 10:16:21',1,268,'649d1e38-3b9b-4eeb-9e1c-61169af76d89',68,'0a6ba16c4b9d49d3bc24cd7b44935d1f','gigabytes___DEFAULT__',-1,'2026-01-24 10:16:21',NULL),('2026-01-23 10:16:26','2026-01-23 10:16:26','2026-01-23 10:16:26',1,269,'523f8ea5-91a4-4d06-bc48-439a17a69ab5',77,'59cfb6a6a5ea438fb4b12029b4fcea0f','volumes',1,'2026-01-24 10:16:26',NULL),('2026-01-23 10:16:26','2026-01-23 10:16:26','2026-01-23 10:16:26',1,270,'3fe28f95-c995-472c-9819-89a062210a37',78,'59cfb6a6a5ea438fb4b12029b4fcea0f','gigabytes',1,'2026-01-24 10:16:26',NULL),('2026-01-23 10:16:26','2026-01-23 10:16:26','2026-01-23 10:16:26',1,271,'73056ae0-351f-441b-b73a-0f1881996126',79,'59cfb6a6a5ea438fb4b12029b4fcea0f','volumes___DEFAULT__',1,'2026-01-24 10:16:26',NULL),('2026-01-23 10:16:26','2026-01-23 10:16:26','2026-01-23 10:16:26',1,272,'c5ecb19f-ac28-4d03-a48f-5b52496705af',80,'59cfb6a6a5ea438fb4b12029b4fcea0f','gigabytes___DEFAULT__',1,'2026-01-24 10:16:26',NULL),('2026-01-23 10:16:47','2026-01-23 10:16:49','2026-01-23 10:16:49',1,273,'4726e3ac-4fdb-4a51-94f8-007723d38704',69,'3ae621f21a8e438fb95152309b38cee5','volumes',-1,'2026-01-24 10:16:47',NULL),('2026-01-23 10:16:47','2026-01-23 10:16:49','2026-01-23 10:16:49',1,274,'fec8f3da-4314-48dc-b7e9-d35a5f525c56',70,'3ae621f21a8e438fb95152309b38cee5','gigabytes',-1,'2026-01-24 10:16:47',NULL),('2026-01-23 10:16:47','2026-01-23 10:16:49','2026-01-23 10:16:49',1,275,'cb782f96-be76-4ba1-b9bc-dcb2c380ea76',71,'3ae621f21a8e438fb95152309b38cee5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1036888469-1438475917',-1,'2026-01-24 10:16:47',NULL),('2026-01-23 10:16:47','2026-01-23 10:16:49','2026-01-23 10:16:49',1,276,'f00efbc0-83d0-4d5b-8ae9-1d5d3b8b11b5',72,'3ae621f21a8e438fb95152309b38cee5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1036888469-1438475917',-1,'2026-01-24 10:16:47',NULL),('2026-01-23 10:16:55','2026-01-23 10:17:03','2026-01-23 10:17:03',1,277,'790685cb-5093-4fa8-bb15-a8ee10840d24',69,'3ae621f21a8e438fb95152309b38cee5','volumes',-1,'2026-01-24 10:16:55',NULL),('2026-01-23 10:16:55','2026-01-23 10:17:03','2026-01-23 10:17:03',1,278,'64d0527f-0e19-4a64-8211-efa0231c4f11',70,'3ae621f21a8e438fb95152309b38cee5','gigabytes',-1,'2026-01-24 10:16:55',NULL),('2026-01-23 10:16:55','2026-01-23 10:17:03','2026-01-23 10:17:03',1,279,'128ede33-c4bf-4a8d-95f6-a5ed417bfd1c',73,'3ae621f21a8e438fb95152309b38cee5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-968827984-727097193',-1,'2026-01-24 10:16:55',NULL),('2026-01-23 10:16:55','2026-01-23 10:17:03','2026-01-23 10:17:03',1,280,'e6ce2194-3a7b-4a52-96e3-9486110feb76',74,'3ae621f21a8e438fb95152309b38cee5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-968827984-727097193',-1,'2026-01-24 10:16:55',NULL),('2026-01-23 10:17:49','2026-01-23 10:17:49','2026-01-23 10:17:49',1,281,'6e8c9c62-5332-4ec8-910d-22fa3f304c9b',69,'3ae621f21a8e438fb95152309b38cee5','volumes',-1,'2026-01-24 10:17:49',NULL),('2026-01-23 10:17:49','2026-01-23 10:17:49','2026-01-23 10:17:49',1,282,'8d4db9ec-4b58-479d-97f4-399f3309edbe',70,'3ae621f21a8e438fb95152309b38cee5','gigabytes',-1,'2026-01-24 10:17:49',NULL),('2026-01-23 10:17:49','2026-01-23 10:17:49','2026-01-23 10:17:49',1,283,'6ea7e86f-3b6a-4259-8beb-7878987de5f7',71,'3ae621f21a8e438fb95152309b38cee5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1036888469-1438475917',-1,'2026-01-24 10:17:49',NULL),('2026-01-23 10:17:49','2026-01-23 10:17:49','2026-01-23 10:17:49',1,284,'312a8f6e-7fe5-4709-9d6f-89982570b19a',72,'3ae621f21a8e438fb95152309b38cee5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1036888469-1438475917',-1,'2026-01-24 10:17:49',NULL),('2026-01-23 10:17:54','2026-01-23 10:17:54','2026-01-23 10:17:54',1,285,'0f4b6583-0055-46ed-8c52-a622d6406416',69,'3ae621f21a8e438fb95152309b38cee5','volumes',-1,'2026-01-24 10:17:54',NULL),('2026-01-23 10:17:54','2026-01-23 10:17:54','2026-01-23 10:17:54',1,286,'b5c334c1-b2ad-4648-bc09-257db368729c',70,'3ae621f21a8e438fb95152309b38cee5','gigabytes',-1,'2026-01-24 10:17:54',NULL),('2026-01-23 10:17:54','2026-01-23 10:17:54','2026-01-23 10:17:54',1,287,'715f592c-b165-44ac-bd13-42025cd2d1ff',73,'3ae621f21a8e438fb95152309b38cee5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-968827984-727097193',-1,'2026-01-24 10:17:54',NULL),('2026-01-23 10:17:54','2026-01-23 10:17:54','2026-01-23 10:17:54',1,288,'52c283c0-d01b-496a-9d1e-29927df88d31',74,'3ae621f21a8e438fb95152309b38cee5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-968827984-727097193',-1,'2026-01-24 10:17:54',NULL),('2026-01-23 10:18:37','2026-01-23 10:18:37','2026-01-23 10:18:37',1,289,'1cf02624-4a89-47c7-b5ae-c7f774c50315',69,'3ae621f21a8e438fb95152309b38cee5','volumes',-1,'2026-01-24 10:18:37',NULL),('2026-01-23 10:18:37','2026-01-23 10:18:37','2026-01-23 10:18:37',1,290,'7690c81f-dd1e-42a9-b603-3aef0d5fda9b',70,'3ae621f21a8e438fb95152309b38cee5','gigabytes',-1,'2026-01-24 10:18:37',NULL),('2026-01-23 10:18:37','2026-01-23 10:18:37','2026-01-23 10:18:37',1,291,'d430c487-8ed4-40b3-b076-e0852dd7104b',75,'3ae621f21a8e438fb95152309b38cee5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1177848314-496428426',-1,'2026-01-24 10:18:37',NULL),('2026-01-23 10:18:37','2026-01-23 10:18:37','2026-01-23 10:18:37',1,292,'8f54aa8a-5dbf-4cb7-ba63-fbd8a5e23d79',76,'3ae621f21a8e438fb95152309b38cee5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1177848314-496428426',-1,'2026-01-24 10:18:37',NULL),('2026-01-23 10:18:39','2026-01-23 10:18:39','2026-01-23 10:18:39',1,293,'a2eec853-6006-4960-96e1-210989d342fe',69,'3ae621f21a8e438fb95152309b38cee5','volumes',-1,'2026-01-24 10:18:39',NULL),('2026-01-23 10:18:39','2026-01-23 10:18:39','2026-01-23 10:18:39',1,294,'993e4035-c96e-4ce6-a1fb-d48b40209968',70,'3ae621f21a8e438fb95152309b38cee5','gigabytes',-1,'2026-01-24 10:18:39',NULL),('2026-01-23 10:18:39','2026-01-23 10:18:39','2026-01-23 10:18:39',1,295,'ecba0446-104a-4df1-bfd2-29523e468f18',75,'3ae621f21a8e438fb95152309b38cee5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1177848314-496428426',-1,'2026-01-24 10:18:39',NULL),('2026-01-23 10:18:39','2026-01-23 10:18:39','2026-01-23 10:18:39',1,296,'ee96cbec-a29a-4609-a4af-81d6a6ef2d89',76,'3ae621f21a8e438fb95152309b38cee5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1177848314-496428426',-1,'2026-01-24 10:18:39',NULL),('2026-01-23 10:18:40','2026-01-23 10:18:40','2026-01-23 10:18:40',1,297,'7ad4c85a-44fb-4722-bda7-c968c468d341',77,'59cfb6a6a5ea438fb4b12029b4fcea0f','volumes',-1,'2026-01-24 10:18:40',NULL),('2026-01-23 10:18:40','2026-01-23 10:18:40','2026-01-23 10:18:40',1,298,'57e3f5a7-5725-4ce8-8149-cc907f652d12',78,'59cfb6a6a5ea438fb4b12029b4fcea0f','gigabytes',-1,'2026-01-24 10:18:40',NULL),('2026-01-23 10:18:40','2026-01-23 10:18:40','2026-01-23 10:18:40',1,299,'929a6901-99a1-4fdd-8fc1-dde27218242f',79,'59cfb6a6a5ea438fb4b12029b4fcea0f','volumes___DEFAULT__',-1,'2026-01-24 10:18:40',NULL),('2026-01-23 10:18:40','2026-01-23 10:18:40','2026-01-23 10:18:40',1,300,'ff63a347-ec2f-4376-86ab-398f6f9a2225',80,'59cfb6a6a5ea438fb4b12029b4fcea0f','gigabytes___DEFAULT__',-1,'2026-01-24 10:18:40',NULL),('2026-01-23 10:18:41','2026-01-23 10:18:41','2026-01-23 10:18:41',1,301,'916030dd-2065-459f-bd32-cfe9e9ad54e7',69,'3ae621f21a8e438fb95152309b38cee5','volumes',-1,'2026-01-24 10:18:41',NULL),('2026-01-23 10:18:41','2026-01-23 10:18:41','2026-01-23 10:18:41',1,302,'93b65446-2915-482c-aec2-9f4aa3bcec8a',70,'3ae621f21a8e438fb95152309b38cee5','gigabytes',-1,'2026-01-24 10:18:41',NULL),('2026-01-23 10:18:41','2026-01-23 10:18:41','2026-01-23 10:18:41',1,303,'b7a109a6-8c8c-464f-9e04-b68e3c0fe1b2',75,'3ae621f21a8e438fb95152309b38cee5','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1177848314-496428426',-1,'2026-01-24 10:18:41',NULL),('2026-01-23 10:18:41','2026-01-23 10:18:41','2026-01-23 10:18:41',1,304,'c3cbca96-acb9-4e48-926b-c78531312f3f',76,'3ae621f21a8e438fb95152309b38cee5','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1177848314-496428426',-1,'2026-01-24 10:18:41',NULL),('2026-01-23 10:21:11','2026-01-23 10:21:12','2026-01-23 10:21:12',1,305,'2e75a705-1349-41a0-af7e-f654cd2b5091',81,'b976daabc8124a99814954633f99ed7b','volumes',1,'2026-01-24 10:21:10',NULL),('2026-01-23 10:21:11','2026-01-23 10:21:12','2026-01-23 10:21:12',1,306,'f8ce4d99-8248-4916-8312-5bc87e2f2bbd',82,'b976daabc8124a99814954633f99ed7b','gigabytes',1,'2026-01-24 10:21:10',NULL),('2026-01-23 10:21:11','2026-01-23 10:21:12','2026-01-23 10:21:12',1,307,'0cc1e831-f75e-44f3-aa2e-5344619e0798',83,'b976daabc8124a99814954633f99ed7b','volumes___DEFAULT__',1,'2026-01-24 10:21:10',NULL),('2026-01-23 10:21:11','2026-01-23 10:21:12','2026-01-23 10:21:12',1,308,'9a80fe9b-e8fb-4183-8812-8909beb6ff58',84,'b976daabc8124a99814954633f99ed7b','gigabytes___DEFAULT__',1,'2026-01-24 10:21:10',NULL),('2026-01-23 10:21:22','2026-01-23 10:21:22','2026-01-23 10:21:22',1,309,'99e68612-2fce-4d02-bb42-ecd93b1aecfe',85,'b976daabc8124a99814954633f99ed7b','snapshots',1,'2026-01-24 10:21:21',NULL),('2026-01-23 10:21:22','2026-01-23 10:21:22','2026-01-23 10:21:22',1,310,'677a6088-dda5-4960-9c2f-4e78b698ab63',82,'b976daabc8124a99814954633f99ed7b','gigabytes',1,'2026-01-24 10:21:21',NULL),('2026-01-23 10:21:22','2026-01-23 10:21:22','2026-01-23 10:21:22',1,311,'07603f10-185c-4567-8141-3e53e257e5e9',84,'b976daabc8124a99814954633f99ed7b','gigabytes___DEFAULT__',1,'2026-01-24 10:21:21',NULL),('2026-01-23 10:21:22','2026-01-23 10:21:22','2026-01-23 10:21:22',1,312,'f3daffb6-cfa7-43c7-bc5e-f10c51826133',86,'b976daabc8124a99814954633f99ed7b','snapshots___DEFAULT__',1,'2026-01-24 10:21:21',NULL),('2026-01-23 10:22:14','2026-01-23 10:22:14','2026-01-23 10:22:14',1,313,'accb2d4d-68bf-4b3a-8935-fb5ecc053e14',85,'b976daabc8124a99814954633f99ed7b','snapshots',-1,'2026-01-24 10:22:14',NULL),('2026-01-23 10:22:14','2026-01-23 10:22:14','2026-01-23 10:22:14',1,314,'efd97421-812b-416a-a907-904191db495a',82,'b976daabc8124a99814954633f99ed7b','gigabytes',-1,'2026-01-24 10:22:14',NULL),('2026-01-23 10:22:14','2026-01-23 10:22:14','2026-01-23 10:22:14',1,315,'64c30c4e-fbf0-4338-a16b-a6fba02a70df',84,'b976daabc8124a99814954633f99ed7b','gigabytes___DEFAULT__',-1,'2026-01-24 10:22:14',NULL),('2026-01-23 10:22:14','2026-01-23 10:22:14','2026-01-23 10:22:14',1,316,'313ad0df-4d95-4f39-a808-235a7dddf552',86,'b976daabc8124a99814954633f99ed7b','snapshots___DEFAULT__',-1,'2026-01-24 10:22:14',NULL),('2026-01-23 10:23:09','2026-01-23 10:23:09','2026-01-23 10:23:09',1,317,'d355828f-50c0-48e9-9649-5342b91f2b2f',81,'b976daabc8124a99814954633f99ed7b','volumes',-1,'2026-01-24 10:23:09',NULL),('2026-01-23 10:23:09','2026-01-23 10:23:09','2026-01-23 10:23:09',1,318,'266a7c35-9e87-4073-91ea-208ad066046d',82,'b976daabc8124a99814954633f99ed7b','gigabytes',-1,'2026-01-24 10:23:09',NULL),('2026-01-23 10:23:09','2026-01-23 10:23:09','2026-01-23 10:23:09',1,319,'406c29fa-d081-4428-a065-62726c0f01ec',83,'b976daabc8124a99814954633f99ed7b','volumes___DEFAULT__',-1,'2026-01-24 10:23:09',NULL),('2026-01-23 10:23:09','2026-01-23 10:23:09','2026-01-23 10:23:09',1,320,'cd4ec731-fa3b-4c60-be4a-3c295230c54a',84,'b976daabc8124a99814954633f99ed7b','gigabytes___DEFAULT__',-1,'2026-01-24 10:23:09',NULL),('2026-01-23 10:23:42','2026-01-23 10:23:42','2026-01-23 10:23:42',1,321,'cf96dffd-6c4b-472f-83e1-af95cee50813',81,'b976daabc8124a99814954633f99ed7b','volumes',1,'2026-01-24 10:23:42',NULL),('2026-01-23 10:23:42','2026-01-23 10:23:42','2026-01-23 10:23:42',1,322,'76dbaab6-c25e-400b-b96b-aed38debc287',82,'b976daabc8124a99814954633f99ed7b','gigabytes',1,'2026-01-24 10:23:42',NULL),('2026-01-23 10:23:42','2026-01-23 10:23:42','2026-01-23 10:23:42',1,323,'3b849c11-6325-4c71-b636-14fc1ea62234',83,'b976daabc8124a99814954633f99ed7b','volumes___DEFAULT__',1,'2026-01-24 10:23:42',NULL),('2026-01-23 10:23:42','2026-01-23 10:23:42','2026-01-23 10:23:42',1,324,'7419ba15-d4f0-489f-b200-0aa780a2fed1',84,'b976daabc8124a99814954633f99ed7b','gigabytes___DEFAULT__',1,'2026-01-24 10:23:42',NULL),('2026-01-23 10:24:10','2026-01-23 10:24:10','2026-01-23 10:24:10',1,325,'5f6fbda6-88c9-4304-be73-fe0ea45b831f',87,'c7c25c6bb33b41bf9cd8febb8259fd87','volumes',1,'2026-01-24 10:24:10',NULL),('2026-01-23 10:24:10','2026-01-23 10:24:10','2026-01-23 10:24:10',1,326,'cb9cb9d5-c646-4e93-9b24-cc3847726efa',88,'c7c25c6bb33b41bf9cd8febb8259fd87','gigabytes',1,'2026-01-24 10:24:10',NULL),('2026-01-23 10:24:10','2026-01-23 10:24:10','2026-01-23 10:24:10',1,327,'3367a997-eda6-48df-bd54-bc05cf18da51',89,'c7c25c6bb33b41bf9cd8febb8259fd87','volumes___DEFAULT__',1,'2026-01-24 10:24:10',NULL),('2026-01-23 10:24:10','2026-01-23 10:24:10','2026-01-23 10:24:10',1,328,'310268fd-b02b-4eb7-ad7a-cc3ac8cf21e8',90,'c7c25c6bb33b41bf9cd8febb8259fd87','gigabytes___DEFAULT__',1,'2026-01-24 10:24:10',NULL),('2026-01-23 10:24:21','2026-01-23 10:24:21','2026-01-23 10:24:21',1,329,'a6bcce3a-bf9b-4174-a464-1236a9db144a',91,'5c27429e1d8f433a8a67ddb76f8798f1','volumes',1,'2026-01-24 10:24:21',NULL),('2026-01-23 10:24:21','2026-01-23 10:24:21','2026-01-23 10:24:21',1,330,'379cd172-8852-4d7b-85eb-2fd09cd9c86d',92,'5c27429e1d8f433a8a67ddb76f8798f1','gigabytes',1,'2026-01-24 10:24:21',NULL),('2026-01-23 10:24:21','2026-01-23 10:24:21','2026-01-23 10:24:21',1,331,'bc0c1732-bd18-45df-ac5f-0fb6fe5b8784',93,'5c27429e1d8f433a8a67ddb76f8798f1','volumes___DEFAULT__',1,'2026-01-24 10:24:21',NULL),('2026-01-23 10:24:21','2026-01-23 10:24:21','2026-01-23 10:24:21',1,332,'c1a6a0a5-c359-4a18-81fc-ad1d315e5317',94,'5c27429e1d8f433a8a67ddb76f8798f1','gigabytes___DEFAULT__',1,'2026-01-24 10:24:21',NULL),('2026-01-23 10:25:11','2026-01-23 10:25:11','2026-01-23 10:25:11',1,333,'28c7d017-4da1-4b84-8cca-1b79b38a28a1',81,'b976daabc8124a99814954633f99ed7b','volumes',-1,'2026-01-24 10:25:11',NULL),('2026-01-23 10:25:11','2026-01-23 10:25:11','2026-01-23 10:25:11',1,334,'984749a6-57d1-49fa-a141-79b13ecbc2b2',82,'b976daabc8124a99814954633f99ed7b','gigabytes',-1,'2026-01-24 10:25:11',NULL),('2026-01-23 10:25:11','2026-01-23 10:25:11','2026-01-23 10:25:11',1,335,'e11d5516-d0af-49f3-8b1b-c01094324996',83,'b976daabc8124a99814954633f99ed7b','volumes___DEFAULT__',-1,'2026-01-24 10:25:11',NULL),('2026-01-23 10:25:11','2026-01-23 10:25:11','2026-01-23 10:25:11',1,336,'3d1c28c8-c7cf-4225-b310-1dfc41274093',84,'b976daabc8124a99814954633f99ed7b','gigabytes___DEFAULT__',-1,'2026-01-24 10:25:11',NULL),('2026-01-23 10:26:39','2026-01-23 10:26:40','2026-01-23 10:26:40',1,337,'57750717-5219-43cb-9316-72645d041f3b',87,'c7c25c6bb33b41bf9cd8febb8259fd87','volumes',1,'2026-01-24 10:26:39',NULL),('2026-01-23 10:26:39','2026-01-23 10:26:40','2026-01-23 10:26:40',1,338,'ffee282b-5c32-4e49-81ce-03bb677189d2',88,'c7c25c6bb33b41bf9cd8febb8259fd87','gigabytes',1,'2026-01-24 10:26:39',NULL),('2026-01-23 10:26:39','2026-01-23 10:26:40','2026-01-23 10:26:40',1,339,'c5363375-790c-4af8-afe2-fb49d53576e0',89,'c7c25c6bb33b41bf9cd8febb8259fd87','volumes___DEFAULT__',1,'2026-01-24 10:26:39',NULL),('2026-01-23 10:26:39','2026-01-23 10:26:40','2026-01-23 10:26:40',1,340,'d27c55f6-f0fa-4923-ac0d-58ee50259965',90,'c7c25c6bb33b41bf9cd8febb8259fd87','gigabytes___DEFAULT__',1,'2026-01-24 10:26:39',NULL),('2026-01-23 10:26:45','2026-01-23 10:26:45','2026-01-23 10:26:45',1,341,'d68d716a-39f6-48ef-9d14-7d1e669299e1',87,'c7c25c6bb33b41bf9cd8febb8259fd87','volumes',1,'2026-01-24 10:26:45',NULL),('2026-01-23 10:26:45','2026-01-23 10:26:45','2026-01-23 10:26:45',1,342,'e8ae5618-9542-4ff0-b4c5-3ad2fc6c2c54',88,'c7c25c6bb33b41bf9cd8febb8259fd87','gigabytes',1,'2026-01-24 10:26:45',NULL),('2026-01-23 10:26:45','2026-01-23 10:26:45','2026-01-23 10:26:45',1,343,'492fb5a9-53e3-4149-9ee7-bafb2f2c1edd',89,'c7c25c6bb33b41bf9cd8febb8259fd87','volumes___DEFAULT__',1,'2026-01-24 10:26:45',NULL),('2026-01-23 10:26:45','2026-01-23 10:26:45','2026-01-23 10:26:45',1,344,'d4cbbc59-ef6a-48d0-bbc2-2a94d04c0a14',90,'c7c25c6bb33b41bf9cd8febb8259fd87','gigabytes___DEFAULT__',1,'2026-01-24 10:26:45',NULL),('2026-01-23 10:26:46','2026-01-23 10:26:46','2026-01-23 10:26:46',1,345,'ebb6080b-17b0-4d24-a3fc-e0ad7a3bc94e',91,'5c27429e1d8f433a8a67ddb76f8798f1','volumes',1,'2026-01-24 10:26:46',NULL),('2026-01-23 10:26:46','2026-01-23 10:26:46','2026-01-23 10:26:46',1,346,'8f56a5c9-4141-4a16-83ea-9731dce86efd',92,'5c27429e1d8f433a8a67ddb76f8798f1','gigabytes',1,'2026-01-24 10:26:46',NULL),('2026-01-23 10:26:46','2026-01-23 10:26:46','2026-01-23 10:26:46',1,347,'1de7f838-82c0-44b3-8dd3-02e6b5f41e11',93,'5c27429e1d8f433a8a67ddb76f8798f1','volumes___DEFAULT__',1,'2026-01-24 10:26:46',NULL),('2026-01-23 10:26:46','2026-01-23 10:26:46','2026-01-23 10:26:46',1,348,'022f4a8b-e375-4400-afed-0824357c0f78',94,'5c27429e1d8f433a8a67ddb76f8798f1','gigabytes___DEFAULT__',1,'2026-01-24 10:26:46',NULL),('2026-01-23 10:27:18','2026-01-23 10:27:19','2026-01-23 10:27:19',1,349,'59052c21-c9de-4ffb-829d-967f451c2e35',87,'c7c25c6bb33b41bf9cd8febb8259fd87','volumes',-1,'2026-01-24 10:27:18',NULL),('2026-01-23 10:27:18','2026-01-23 10:27:19','2026-01-23 10:27:19',1,350,'419a2b86-c3d1-4321-aa6e-b72f841af186',88,'c7c25c6bb33b41bf9cd8febb8259fd87','gigabytes',-1,'2026-01-24 10:27:18',NULL),('2026-01-23 10:27:18','2026-01-23 10:27:19','2026-01-23 10:27:19',1,351,'0c0dea5b-002c-41fe-b05c-37bf0602ca26',89,'c7c25c6bb33b41bf9cd8febb8259fd87','volumes___DEFAULT__',-1,'2026-01-24 10:27:18',NULL),('2026-01-23 10:27:18','2026-01-23 10:27:19','2026-01-23 10:27:19',1,352,'2324eb39-fd82-4e3a-b45d-a159fb660517',90,'c7c25c6bb33b41bf9cd8febb8259fd87','gigabytes___DEFAULT__',-1,'2026-01-24 10:27:18',NULL),('2026-01-23 10:27:22','2026-01-23 10:27:22','2026-01-23 10:27:22',1,353,'2495b40e-642d-4076-aa38-387c00032c9c',87,'c7c25c6bb33b41bf9cd8febb8259fd87','volumes',-1,'2026-01-24 10:27:22',NULL),('2026-01-23 10:27:22','2026-01-23 10:27:22','2026-01-23 10:27:22',1,354,'edc830f1-859b-4a20-95f8-683e256a42f1',88,'c7c25c6bb33b41bf9cd8febb8259fd87','gigabytes',-1,'2026-01-24 10:27:22',NULL),('2026-01-23 10:27:22','2026-01-23 10:27:22','2026-01-23 10:27:22',1,355,'6a96077b-cd13-4f0c-abc8-2e3f2dfb52ad',89,'c7c25c6bb33b41bf9cd8febb8259fd87','volumes___DEFAULT__',-1,'2026-01-24 10:27:22',NULL),('2026-01-23 10:27:22','2026-01-23 10:27:22','2026-01-23 10:27:22',1,356,'30600070-22c6-420d-bbad-513775676b67',90,'c7c25c6bb33b41bf9cd8febb8259fd87','gigabytes___DEFAULT__',-1,'2026-01-24 10:27:22',NULL),('2026-01-23 10:27:25','2026-01-23 10:27:25','2026-01-23 10:27:25',1,357,'f5b0284e-cb24-4d03-93e5-6f1c922e796b',87,'c7c25c6bb33b41bf9cd8febb8259fd87','volumes',-1,'2026-01-24 10:27:25',NULL),('2026-01-23 10:27:25','2026-01-23 10:27:25','2026-01-23 10:27:25',1,358,'cc2fb2b0-58ea-46cc-9d6a-d45fe01bc290',88,'c7c25c6bb33b41bf9cd8febb8259fd87','gigabytes',-1,'2026-01-24 10:27:25',NULL),('2026-01-23 10:27:25','2026-01-23 10:27:25','2026-01-23 10:27:25',1,359,'8e64c32a-be4d-4ca3-b97f-4e6d3d7d4ace',89,'c7c25c6bb33b41bf9cd8febb8259fd87','volumes___DEFAULT__',-1,'2026-01-24 10:27:25',NULL),('2026-01-23 10:27:25','2026-01-23 10:27:25','2026-01-23 10:27:25',1,360,'1857c6d9-1b86-47e5-a7ee-886f6b1ee5a4',90,'c7c25c6bb33b41bf9cd8febb8259fd87','gigabytes___DEFAULT__',-1,'2026-01-24 10:27:25',NULL),('2026-01-23 10:33:47','2026-01-23 10:33:47','2026-01-23 10:33:47',1,361,'2d9d3306-9716-47a5-bf76-e0603552887f',95,'815b71acf60d4ed8933ebd05228fa0c0','volumes',1,'2026-01-24 10:33:47',NULL),('2026-01-23 10:33:47','2026-01-23 10:33:47','2026-01-23 10:33:47',1,362,'4626f3f0-c58b-41d6-a5a8-75cb0b8fc874',96,'815b71acf60d4ed8933ebd05228fa0c0','gigabytes',1,'2026-01-24 10:33:47',NULL),('2026-01-23 10:33:47','2026-01-23 10:33:47','2026-01-23 10:33:47',1,363,'6e17db2e-be11-4c6e-8701-98224e576c3b',97,'815b71acf60d4ed8933ebd05228fa0c0','volumes___DEFAULT__',1,'2026-01-24 10:33:47',NULL),('2026-01-23 10:33:47','2026-01-23 10:33:47','2026-01-23 10:33:47',1,364,'9d0cc64a-3614-48ea-962a-1e1de03a7e1b',98,'815b71acf60d4ed8933ebd05228fa0c0','gigabytes___DEFAULT__',1,'2026-01-24 10:33:47',NULL),('2026-01-23 10:34:58','2026-01-23 10:34:58','2026-01-23 10:34:58',1,365,'5b4835cf-8962-4a6e-865c-fafc02f1faab',99,'d59dad6496894352a2f4c7eb66ca1914','volumes',1,'2026-01-24 10:34:58',NULL),('2026-01-23 10:34:58','2026-01-23 10:34:58','2026-01-23 10:34:58',1,366,'960836a7-c282-4d84-9d55-a9c2acde11da',100,'d59dad6496894352a2f4c7eb66ca1914','gigabytes',1,'2026-01-24 10:34:58',NULL),('2026-01-23 10:34:58','2026-01-23 10:34:58','2026-01-23 10:34:58',1,367,'518c8cc4-ed1f-4502-8142-36b6ae4fc4ee',101,'d59dad6496894352a2f4c7eb66ca1914','volumes___DEFAULT__',1,'2026-01-24 10:34:58',NULL),('2026-01-23 10:34:58','2026-01-23 10:34:58','2026-01-23 10:34:58',1,368,'2747c10c-d669-405c-bb86-7feb9679b8ad',102,'d59dad6496894352a2f4c7eb66ca1914','gigabytes___DEFAULT__',1,'2026-01-24 10:34:58',NULL),('2026-01-23 10:35:48','2026-01-23 10:35:48','2026-01-23 10:35:48',1,369,'61829528-6cd8-4d89-a956-e2015a4d9582',103,'d59dad6496894352a2f4c7eb66ca1914','snapshots',1,'2026-01-24 10:35:48',NULL),('2026-01-23 10:35:48','2026-01-23 10:35:48','2026-01-23 10:35:48',1,370,'8182107a-9e3d-444f-b423-415f40b4770e',100,'d59dad6496894352a2f4c7eb66ca1914','gigabytes',1,'2026-01-24 10:35:48',NULL),('2026-01-23 10:35:48','2026-01-23 10:35:48','2026-01-23 10:35:48',1,371,'d4365104-1233-485b-86b8-6dc055e416a0',102,'d59dad6496894352a2f4c7eb66ca1914','gigabytes___DEFAULT__',1,'2026-01-24 10:35:48',NULL),('2026-01-23 10:35:48','2026-01-23 10:35:48','2026-01-23 10:35:48',1,372,'2cf47dee-c555-4923-9b0c-3318416d6f8b',104,'d59dad6496894352a2f4c7eb66ca1914','snapshots___DEFAULT__',1,'2026-01-24 10:35:48',NULL),('2026-01-23 10:36:04','2026-01-23 10:36:04','2026-01-23 10:36:04',1,373,'0d9f09c3-863a-4c5d-922f-cba1e22c0898',99,'d59dad6496894352a2f4c7eb66ca1914','volumes',1,'2026-01-24 10:36:04',NULL),('2026-01-23 10:36:04','2026-01-23 10:36:04','2026-01-23 10:36:04',1,374,'c2f1727a-b3a4-4a0e-b21b-6d8f1513c05b',100,'d59dad6496894352a2f4c7eb66ca1914','gigabytes',1,'2026-01-24 10:36:04',NULL),('2026-01-23 10:36:04','2026-01-23 10:36:04','2026-01-23 10:36:04',1,375,'15099288-3c7a-4656-9254-c20e6c81b556',101,'d59dad6496894352a2f4c7eb66ca1914','volumes___DEFAULT__',1,'2026-01-24 10:36:04',NULL),('2026-01-23 10:36:04','2026-01-23 10:36:04','2026-01-23 10:36:04',1,376,'2ed1c9e0-b6ce-4180-b16c-1fedaa41374a',102,'d59dad6496894352a2f4c7eb66ca1914','gigabytes___DEFAULT__',1,'2026-01-24 10:36:04',NULL),('2026-01-23 10:36:12','2026-01-23 10:36:13','2026-01-23 10:36:13',1,377,'be01189e-1986-4a2c-894f-a3740386c218',95,'815b71acf60d4ed8933ebd05228fa0c0','volumes',-1,'2026-01-24 10:36:12',NULL),('2026-01-23 10:36:12','2026-01-23 10:36:13','2026-01-23 10:36:13',1,378,'fc5b4997-c560-437c-94d4-7ba2bd13057f',96,'815b71acf60d4ed8933ebd05228fa0c0','gigabytes',-1,'2026-01-24 10:36:12',NULL),('2026-01-23 10:36:12','2026-01-23 10:36:13','2026-01-23 10:36:13',1,379,'9590e639-3c1b-42c3-abad-3ee99beb7140',97,'815b71acf60d4ed8933ebd05228fa0c0','volumes___DEFAULT__',-1,'2026-01-24 10:36:12',NULL),('2026-01-23 10:36:12','2026-01-23 10:36:13','2026-01-23 10:36:13',1,380,'2e83626e-8202-45b9-a00e-001b4b228e66',98,'815b71acf60d4ed8933ebd05228fa0c0','gigabytes___DEFAULT__',-1,'2026-01-24 10:36:12',NULL),('2026-01-23 10:37:18','2026-01-23 10:37:18','2026-01-23 10:37:18',1,381,'b9b49cce-3a9f-4f60-a598-fb7af1b71e65',99,'d59dad6496894352a2f4c7eb66ca1914','volumes',-1,'2026-01-24 10:37:18',NULL),('2026-01-23 10:37:18','2026-01-23 10:37:18','2026-01-23 10:37:18',1,382,'518f09e2-4b48-4d0f-928e-b18e525107b4',100,'d59dad6496894352a2f4c7eb66ca1914','gigabytes',-1,'2026-01-24 10:37:18',NULL),('2026-01-23 10:37:18','2026-01-23 10:37:18','2026-01-23 10:37:18',1,383,'bcf05e47-3110-4caf-83ed-c400456f3955',101,'d59dad6496894352a2f4c7eb66ca1914','volumes___DEFAULT__',-1,'2026-01-24 10:37:18',NULL),('2026-01-23 10:37:18','2026-01-23 10:37:18','2026-01-23 10:37:18',1,384,'3889e63e-a8cc-4b0e-9c41-8eccfec3f5dd',102,'d59dad6496894352a2f4c7eb66ca1914','gigabytes___DEFAULT__',-1,'2026-01-24 10:37:18',NULL),('2026-01-23 10:37:20','2026-01-23 10:37:20','2026-01-23 10:37:20',1,385,'047e7b75-b215-4315-9877-658b926e8a0f',103,'d59dad6496894352a2f4c7eb66ca1914','snapshots',-1,'2026-01-24 10:37:20',NULL),('2026-01-23 10:37:20','2026-01-23 10:37:20','2026-01-23 10:37:20',1,386,'f4fb13e1-8c15-4b0d-b1c1-3a6db6036bff',100,'d59dad6496894352a2f4c7eb66ca1914','gigabytes',-1,'2026-01-24 10:37:20',NULL),('2026-01-23 10:37:20','2026-01-23 10:37:20','2026-01-23 10:37:20',1,387,'1b6fb97e-2ac6-4fa2-982d-3fdbee685523',102,'d59dad6496894352a2f4c7eb66ca1914','gigabytes___DEFAULT__',-1,'2026-01-24 10:37:20',NULL),('2026-01-23 10:37:20','2026-01-23 10:37:20','2026-01-23 10:37:20',1,388,'a73f0f1e-8e1a-4ca8-aed8-4d44ca9935ad',104,'d59dad6496894352a2f4c7eb66ca1914','snapshots___DEFAULT__',-1,'2026-01-24 10:37:20',NULL),('2026-01-23 10:37:26','2026-01-23 10:37:26','2026-01-23 10:37:26',1,389,'2185de74-faca-4ba4-9519-19aa5326b333',99,'d59dad6496894352a2f4c7eb66ca1914','volumes',-1,'2026-01-24 10:37:26',NULL),('2026-01-23 10:37:26','2026-01-23 10:37:26','2026-01-23 10:37:26',1,390,'519af2ce-ecec-4d2a-9017-5c3b1363bd8e',100,'d59dad6496894352a2f4c7eb66ca1914','gigabytes',-1,'2026-01-24 10:37:26',NULL),('2026-01-23 10:37:26','2026-01-23 10:37:26','2026-01-23 10:37:26',1,391,'831d6419-f393-4839-9868-1f4c93ff45eb',101,'d59dad6496894352a2f4c7eb66ca1914','volumes___DEFAULT__',-1,'2026-01-24 10:37:26',NULL),('2026-01-23 10:37:26','2026-01-23 10:37:26','2026-01-23 10:37:26',1,392,'17c8903e-786d-4b45-aa1e-12ab289b5171',102,'d59dad6496894352a2f4c7eb66ca1914','gigabytes___DEFAULT__',-1,'2026-01-24 10:37:26',NULL),('2026-01-23 10:37:56','2026-01-23 10:37:56','2026-01-23 10:37:56',1,393,'1730085a-cda8-4243-921a-ea5523ad75b1',105,'6e762fca3b634c7aa1d994314c059c54','volumes',1,'2026-01-24 10:37:56',NULL),('2026-01-23 10:37:56','2026-01-23 10:37:56','2026-01-23 10:37:56',1,394,'de220ae7-4a2a-4326-a107-11d2fd6c94c3',106,'6e762fca3b634c7aa1d994314c059c54','gigabytes',1,'2026-01-24 10:37:56',NULL),('2026-01-23 10:37:56','2026-01-23 10:37:56','2026-01-23 10:37:56',1,395,'d90c4aa3-86fb-4e99-9f49-d6cdd4eef05c',107,'6e762fca3b634c7aa1d994314c059c54','volumes_multiattach',1,'2026-01-24 10:37:56',NULL),('2026-01-23 10:37:56','2026-01-23 10:37:56','2026-01-23 10:37:56',1,396,'5faf7081-3ec0-4e0f-945d-c6d9ea6cf926',108,'6e762fca3b634c7aa1d994314c059c54','gigabytes_multiattach',1,'2026-01-24 10:37:56',NULL),('2026-01-23 10:38:15','2026-01-23 10:38:15','2026-01-23 10:38:15',1,397,'0b23db92-0706-44b6-9e11-4f11d7a633cc',109,'95243c9b3c544aff8e9ee6043bb6f522','volumes',1,'2026-01-24 10:38:15',NULL),('2026-01-23 10:38:15','2026-01-23 10:38:15','2026-01-23 10:38:15',1,398,'eb248d93-8a1d-4be8-b798-f9779768de8c',110,'95243c9b3c544aff8e9ee6043bb6f522','gigabytes',1,'2026-01-24 10:38:15',NULL),('2026-01-23 10:38:15','2026-01-23 10:38:15','2026-01-23 10:38:15',1,399,'ea0d1aea-a7ed-4f02-aec2-d9468d97db1f',111,'95243c9b3c544aff8e9ee6043bb6f522','volumes___DEFAULT__',1,'2026-01-24 10:38:15',NULL),('2026-01-23 10:38:15','2026-01-23 10:38:15','2026-01-23 10:38:15',1,400,'7003f45b-fbf8-4c18-b6f0-2ee3630ddae8',112,'95243c9b3c544aff8e9ee6043bb6f522','gigabytes___DEFAULT__',1,'2026-01-24 10:38:15',NULL),('2026-01-23 10:38:26','2026-01-23 10:38:26','2026-01-23 10:38:26',1,401,'c20893a7-4b0a-4347-b0b2-540f392b76ee',113,'95243c9b3c544aff8e9ee6043bb6f522','backups',1,'2026-01-24 10:38:26',NULL),('2026-01-23 10:38:26','2026-01-23 10:38:26','2026-01-23 10:38:26',1,402,'5cc9af86-4273-4d97-8de5-b9ab9466e927',114,'95243c9b3c544aff8e9ee6043bb6f522','backup_gigabytes',1,'2026-01-24 10:38:26',NULL),('2026-01-23 10:38:35','2026-01-23 10:38:35','2026-01-23 10:38:35',1,403,'2a823687-bb89-45af-a437-c48054858cb2',109,'95243c9b3c544aff8e9ee6043bb6f522','volumes',1,'2026-01-24 10:38:35',NULL),('2026-01-23 10:38:35','2026-01-23 10:38:35','2026-01-23 10:38:35',1,404,'e46ee8a3-3122-45ba-80a3-7c42ce92aeaf',110,'95243c9b3c544aff8e9ee6043bb6f522','gigabytes',1,'2026-01-24 10:38:35',NULL),('2026-01-23 10:38:35','2026-01-23 10:38:35','2026-01-23 10:38:35',1,405,'f1193f67-c7b2-4307-91a2-e3d51a4e941c',111,'95243c9b3c544aff8e9ee6043bb6f522','volumes___DEFAULT__',1,'2026-01-24 10:38:35',NULL),('2026-01-23 10:38:35','2026-01-23 10:38:35','2026-01-23 10:38:35',1,406,'bf132ad9-d8f7-4feb-9491-0fedc32fa30c',112,'95243c9b3c544aff8e9ee6043bb6f522','gigabytes___DEFAULT__',1,'2026-01-24 10:38:35',NULL),('2026-01-23 10:39:18','2026-01-23 10:39:20','2026-01-23 10:39:20',1,407,'6ca8029f-1785-488c-a64b-7f07e493346a',105,'6e762fca3b634c7aa1d994314c059c54','volumes',1,'2026-01-24 10:39:18',NULL),('2026-01-23 10:39:18','2026-01-23 10:39:20','2026-01-23 10:39:20',1,408,'20358fcc-7507-49cb-b9c6-3ebdf5b51aff',106,'6e762fca3b634c7aa1d994314c059c54','gigabytes',1,'2026-01-24 10:39:18',NULL),('2026-01-23 10:39:18','2026-01-23 10:39:20','2026-01-23 10:39:20',1,409,'0b3640e9-7ab0-4170-af32-664831341025',107,'6e762fca3b634c7aa1d994314c059c54','volumes_multiattach',1,'2026-01-24 10:39:18',NULL),('2026-01-23 10:39:18','2026-01-23 10:39:20','2026-01-23 10:39:20',1,410,'6391d915-61b2-4432-be32-4ca20787af3e',108,'6e762fca3b634c7aa1d994314c059c54','gigabytes_multiattach',1,'2026-01-24 10:39:18',NULL),('2026-01-23 10:39:33','2026-01-23 10:39:33','2026-01-23 10:39:33',1,411,'2803d977-a9b9-4ba4-96f2-180c31a3cc83',109,'95243c9b3c544aff8e9ee6043bb6f522','volumes',-1,'2026-01-24 10:39:33',NULL),('2026-01-23 10:39:33','2026-01-23 10:39:33','2026-01-23 10:39:33',1,412,'0f1c148b-2e5c-4183-a2f7-546aaa0e45ac',110,'95243c9b3c544aff8e9ee6043bb6f522','gigabytes',-1,'2026-01-24 10:39:33',NULL),('2026-01-23 10:39:33','2026-01-23 10:39:33','2026-01-23 10:39:33',1,413,'d5bdfdd0-d486-4465-b8cf-280cb03ef096',111,'95243c9b3c544aff8e9ee6043bb6f522','volumes___DEFAULT__',-1,'2026-01-24 10:39:33',NULL),('2026-01-23 10:39:33','2026-01-23 10:39:33','2026-01-23 10:39:33',1,414,'3fae8620-b149-4627-958c-68078a916c14',112,'95243c9b3c544aff8e9ee6043bb6f522','gigabytes___DEFAULT__',-1,'2026-01-24 10:39:33',NULL),('2026-01-23 10:39:33','2026-01-23 10:39:33','2026-01-23 10:39:33',1,415,'4fae269c-e2b5-4bba-b8ee-116335cf07dd',109,'95243c9b3c544aff8e9ee6043bb6f522','volumes',-1,'2026-01-24 10:39:33',NULL),('2026-01-23 10:39:33','2026-01-23 10:39:33','2026-01-23 10:39:33',1,416,'b516d09d-419b-4b39-bb09-7f6e2722810c',110,'95243c9b3c544aff8e9ee6043bb6f522','gigabytes',-1,'2026-01-24 10:39:33',NULL),('2026-01-23 10:39:33','2026-01-23 10:39:33','2026-01-23 10:39:33',1,417,'19753e88-7902-4050-934f-bac2995683a1',111,'95243c9b3c544aff8e9ee6043bb6f522','volumes___DEFAULT__',-1,'2026-01-24 10:39:33',NULL),('2026-01-23 10:39:33','2026-01-23 10:39:33','2026-01-23 10:39:33',1,418,'d99a8f49-c6b9-44a6-abef-15238ef064a8',112,'95243c9b3c544aff8e9ee6043bb6f522','gigabytes___DEFAULT__',-1,'2026-01-24 10:39:33',NULL),('2026-01-23 10:39:33','2026-01-23 10:39:34','2026-01-23 10:39:34',1,419,'e709693e-8e7a-4821-9a01-21ed6d84d3bd',113,'95243c9b3c544aff8e9ee6043bb6f522','backups',-1,'2026-01-24 10:39:33',NULL),('2026-01-23 10:39:33','2026-01-23 10:39:34','2026-01-23 10:39:34',1,420,'82d550b7-1338-49d9-8d03-b0fec1fbefe5',114,'95243c9b3c544aff8e9ee6043bb6f522','backup_gigabytes',-1,'2026-01-24 10:39:33',NULL),('2026-01-23 10:40:24','2026-01-23 10:40:24','2026-01-23 10:40:24',1,421,'c2c66f75-1be0-4b99-8253-59fb3f7fe17f',105,'6e762fca3b634c7aa1d994314c059c54','volumes',1,'2026-01-24 10:40:24',NULL),('2026-01-23 10:40:24','2026-01-23 10:40:24','2026-01-23 10:40:24',1,422,'bdfa03a6-ffe9-4d2c-9e5c-494ff33a9c63',106,'6e762fca3b634c7aa1d994314c059c54','gigabytes',1,'2026-01-24 10:40:24',NULL),('2026-01-23 10:40:24','2026-01-23 10:40:24','2026-01-23 10:40:24',1,423,'7e9e7930-67ca-4d0e-85e7-3defff40ca93',107,'6e762fca3b634c7aa1d994314c059c54','volumes_multiattach',1,'2026-01-24 10:40:24',NULL),('2026-01-23 10:40:24','2026-01-23 10:40:24','2026-01-23 10:40:24',1,424,'fe34f9d2-8ec6-43e6-96f5-651220a42878',108,'6e762fca3b634c7aa1d994314c059c54','gigabytes_multiattach',1,'2026-01-24 10:40:24',NULL),('2026-01-23 10:40:27','2026-01-23 10:40:27','2026-01-23 10:40:27',1,425,'f7cec68c-e2af-4a3c-8caa-1a88385c261e',115,'d27c5465284b48a5818ef931d6251c43','volumes',1,'2026-01-24 10:40:27',NULL),('2026-01-23 10:40:27','2026-01-23 10:40:27','2026-01-23 10:40:27',1,426,'7f01d892-d887-49c0-9fb0-0d662969fda8',116,'d27c5465284b48a5818ef931d6251c43','gigabytes',1,'2026-01-24 10:40:27',NULL),('2026-01-23 10:40:27','2026-01-23 10:40:27','2026-01-23 10:40:27',1,427,'e43cabed-8732-4d26-ad16-0d6b4a13e9dd',117,'d27c5465284b48a5818ef931d6251c43','volumes_tempest-scenario-type-luks-987783221',1,'2026-01-24 10:40:27',NULL),('2026-01-23 10:40:27','2026-01-23 10:40:27','2026-01-23 10:40:27',1,428,'46d2cb5b-0fa8-4e77-990b-30183d4b81bb',118,'d27c5465284b48a5818ef931d6251c43','gigabytes_tempest-scenario-type-luks-987783221',1,'2026-01-24 10:40:27',NULL),('2026-01-23 10:41:11','2026-01-23 10:41:11','2026-01-23 10:41:11',1,429,'be84a7d0-a902-4703-b50a-682473eeeb1b',115,'d27c5465284b48a5818ef931d6251c43','volumes',-1,'2026-01-24 10:41:11',NULL),('2026-01-23 10:41:11','2026-01-23 10:41:11','2026-01-23 10:41:11',1,430,'7d528358-0c9c-402a-8554-cff4811ecc7f',116,'d27c5465284b48a5818ef931d6251c43','gigabytes',-1,'2026-01-24 10:41:11',NULL),('2026-01-23 10:41:11','2026-01-23 10:41:11','2026-01-23 10:41:11',1,431,'c524d776-bf19-435a-86a1-ff61f274ba0a',117,'d27c5465284b48a5818ef931d6251c43','volumes_tempest-scenario-type-luks-987783221',-1,'2026-01-24 10:41:11',NULL),('2026-01-23 10:41:11','2026-01-23 10:41:11','2026-01-23 10:41:11',1,432,'01d856f2-02a8-4506-bf4f-68ab49bc0076',118,'d27c5465284b48a5818ef931d6251c43','gigabytes_tempest-scenario-type-luks-987783221',-1,'2026-01-24 10:41:11',NULL),('2026-01-23 10:41:14','2026-01-23 10:41:14','2026-01-23 10:41:14',1,433,'ee0f509d-600a-49fd-aa2e-d67012d22644',115,'d27c5465284b48a5818ef931d6251c43','volumes',1,'2026-01-24 10:41:13',NULL),('2026-01-23 10:41:14','2026-01-23 10:41:14','2026-01-23 10:41:14',1,434,'c6c8b783-fb9a-4a54-ac2f-797cf3120c7f',116,'d27c5465284b48a5818ef931d6251c43','gigabytes',1,'2026-01-24 10:41:13',NULL),('2026-01-23 10:41:14','2026-01-23 10:41:15','2026-01-23 10:41:14',1,435,'0d734888-dab4-4584-bc61-100e6a2e6382',119,'d27c5465284b48a5818ef931d6251c43','volumes___DEFAULT__',1,'2026-01-24 10:41:13',NULL),('2026-01-23 10:41:14','2026-01-23 10:41:15','2026-01-23 10:41:15',1,436,'1cb697c9-9eb6-48cb-a64f-ff92c42ad4bf',120,'d27c5465284b48a5818ef931d6251c43','gigabytes___DEFAULT__',1,'2026-01-24 10:41:13',NULL),('2026-01-23 10:41:34','2026-01-23 10:41:35','2026-01-23 10:41:35',1,437,'b55f0035-0009-4363-b70a-1e498f56a5d5',121,'d27c5465284b48a5818ef931d6251c43','snapshots',1,'2026-01-24 10:41:33',NULL),('2026-01-23 10:41:34','2026-01-23 10:41:35','2026-01-23 10:41:35',1,438,'72b600db-0076-4dce-86d1-426d4b2d77fa',116,'d27c5465284b48a5818ef931d6251c43','gigabytes',1,'2026-01-24 10:41:33',NULL),('2026-01-23 10:41:34','2026-01-23 10:41:35','2026-01-23 10:41:35',1,439,'12df13d7-7cf0-4785-99a4-f9b6045246ab',120,'d27c5465284b48a5818ef931d6251c43','gigabytes___DEFAULT__',1,'2026-01-24 10:41:33',NULL),('2026-01-23 10:41:34','2026-01-23 10:41:35','2026-01-23 10:41:35',1,440,'cef4248c-9541-4038-893c-343b4cbcc030',122,'d27c5465284b48a5818ef931d6251c43','snapshots___DEFAULT__',1,'2026-01-24 10:41:33',NULL),('2026-01-23 10:41:45','2026-01-23 10:41:45','2026-01-23 10:41:45',1,441,'aba03820-5df3-4ecd-9425-ea513e39d1f7',115,'d27c5465284b48a5818ef931d6251c43','volumes',1,'2026-01-24 10:41:45',NULL),('2026-01-23 10:41:45','2026-01-23 10:41:46','2026-01-23 10:41:45',1,442,'329d45f0-9678-47ef-b043-4cb85299c655',116,'d27c5465284b48a5818ef931d6251c43','gigabytes',1,'2026-01-24 10:41:45',NULL),('2026-01-23 10:41:45','2026-01-23 10:41:46','2026-01-23 10:41:46',1,443,'0f5de153-f7e4-4d47-8717-8d8dacd00b12',119,'d27c5465284b48a5818ef931d6251c43','volumes___DEFAULT__',1,'2026-01-24 10:41:45',NULL),('2026-01-23 10:41:45','2026-01-23 10:41:46','2026-01-23 10:41:46',1,444,'603be74e-4df9-423f-a8b4-f465a2293ca4',120,'d27c5465284b48a5818ef931d6251c43','gigabytes___DEFAULT__',1,'2026-01-24 10:41:45',NULL),('2026-01-23 10:42:04','2026-01-23 10:42:04','2026-01-23 10:42:04',1,445,'699feced-a005-4b53-8d3e-ab08b7e9e936',115,'d27c5465284b48a5818ef931d6251c43','volumes',-1,'2026-01-24 10:42:04',NULL),('2026-01-23 10:42:04','2026-01-23 10:42:04','2026-01-23 10:42:04',1,446,'f5d2bb2c-9728-43e2-a9be-1404642a9db3',116,'d27c5465284b48a5818ef931d6251c43','gigabytes',-1,'2026-01-24 10:42:04',NULL),('2026-01-23 10:42:04','2026-01-23 10:42:04','2026-01-23 10:42:04',1,447,'80d5d335-69f3-4530-810d-b02be7639d86',119,'d27c5465284b48a5818ef931d6251c43','volumes___DEFAULT__',-1,'2026-01-24 10:42:04',NULL),('2026-01-23 10:42:04','2026-01-23 10:42:04','2026-01-23 10:42:04',1,448,'114c0c06-e293-4a23-bf3c-ccfa61487b1e',120,'d27c5465284b48a5818ef931d6251c43','gigabytes___DEFAULT__',-1,'2026-01-24 10:42:04',NULL),('2026-01-23 10:42:07','2026-01-23 10:42:08','2026-01-23 10:42:08',1,449,'ecbd2e80-8bc8-4e72-a64a-4251fec8ebd5',121,'d27c5465284b48a5818ef931d6251c43','snapshots',-1,'2026-01-24 10:42:07',NULL),('2026-01-23 10:42:07','2026-01-23 10:42:08','2026-01-23 10:42:08',1,450,'05fff274-090a-45a0-88fb-88cef82807ac',116,'d27c5465284b48a5818ef931d6251c43','gigabytes',-1,'2026-01-24 10:42:07',NULL),('2026-01-23 10:42:07','2026-01-23 10:42:08','2026-01-23 10:42:08',1,451,'aca7188d-aa28-4045-9621-6fc3b75ff646',120,'d27c5465284b48a5818ef931d6251c43','gigabytes___DEFAULT__',-1,'2026-01-24 10:42:07',NULL),('2026-01-23 10:42:07','2026-01-23 10:42:08','2026-01-23 10:42:08',1,452,'647a0eea-b30f-4a19-8b43-8fa511c3c934',122,'d27c5465284b48a5818ef931d6251c43','snapshots___DEFAULT__',-1,'2026-01-24 10:42:07',NULL),('2026-01-23 10:42:09','2026-01-23 10:42:09','2026-01-23 10:42:09',1,453,'29294ca6-c5d1-486d-b7e2-0389ec4d1b56',115,'d27c5465284b48a5818ef931d6251c43','volumes',-1,'2026-01-24 10:42:09',NULL),('2026-01-23 10:42:09','2026-01-23 10:42:09','2026-01-23 10:42:09',1,454,'1991eed0-d74f-48d7-89cd-70e6f6ea3567',116,'d27c5465284b48a5818ef931d6251c43','gigabytes',-1,'2026-01-24 10:42:09',NULL),('2026-01-23 10:42:09','2026-01-23 10:42:09','2026-01-23 10:42:09',1,455,'00d94870-9da5-44b2-afe4-659b1d2ed6b8',119,'d27c5465284b48a5818ef931d6251c43','volumes___DEFAULT__',-1,'2026-01-24 10:42:09',NULL),('2026-01-23 10:42:09','2026-01-23 10:42:09','2026-01-23 10:42:09',1,456,'e71fd0e6-3bab-4748-8ed3-0423f688a191',120,'d27c5465284b48a5818ef931d6251c43','gigabytes___DEFAULT__',-1,'2026-01-24 10:42:09',NULL),('2026-01-23 10:42:11','2026-01-23 10:42:11','2026-01-23 10:42:11',1,457,'31eddf2a-27f0-4823-976f-eebc8520579d',115,'d27c5465284b48a5818ef931d6251c43','volumes',1,'2026-01-24 10:42:11',NULL),('2026-01-23 10:42:11','2026-01-23 10:42:11','2026-01-23 10:42:11',1,458,'dba0d1cf-e649-48de-92df-6cc2f5fa8395',116,'d27c5465284b48a5818ef931d6251c43','gigabytes',1,'2026-01-24 10:42:11',NULL),('2026-01-23 10:42:11','2026-01-23 10:42:11','2026-01-23 10:42:11',1,459,'82144612-0099-4235-91d0-5b06ce1f70b5',119,'d27c5465284b48a5818ef931d6251c43','volumes___DEFAULT__',1,'2026-01-24 10:42:11',NULL),('2026-01-23 10:42:11','2026-01-23 10:42:11','2026-01-23 10:42:11',1,460,'edcc109b-a989-4275-bed6-4356edb93b55',120,'d27c5465284b48a5818ef931d6251c43','gigabytes___DEFAULT__',1,'2026-01-24 10:42:11',NULL),('2026-01-23 10:42:30','2026-01-23 10:42:30','2026-01-23 10:42:30',1,461,'15b10df9-dcb5-4323-b52b-e1d0316d7243',105,'6e762fca3b634c7aa1d994314c059c54','volumes',1,'2026-01-24 10:42:30',NULL),('2026-01-23 10:42:30','2026-01-23 10:42:30','2026-01-23 10:42:30',1,462,'c704910b-c6d8-4b93-a44c-37a97177d8f0',106,'6e762fca3b634c7aa1d994314c059c54','gigabytes',1,'2026-01-24 10:42:30',NULL),('2026-01-23 10:42:30','2026-01-23 10:42:30','2026-01-23 10:42:30',1,463,'fd3b860f-db04-4791-99ad-04a12b2eeecd',107,'6e762fca3b634c7aa1d994314c059c54','volumes_multiattach',1,'2026-01-24 10:42:30',NULL),('2026-01-23 10:42:30','2026-01-23 10:42:30','2026-01-23 10:42:30',1,464,'a4b4952c-4914-483c-b78a-20be717a228e',108,'6e762fca3b634c7aa1d994314c059c54','gigabytes_multiattach',1,'2026-01-24 10:42:30',NULL),('2026-01-23 10:43:13','2026-01-23 10:43:15','2026-01-23 10:43:15',1,465,'3502bee4-0f73-4485-ad02-d80d985bf282',121,'d27c5465284b48a5818ef931d6251c43','snapshots',1,'2026-01-24 10:43:13',NULL),('2026-01-23 10:43:13','2026-01-23 10:43:15','2026-01-23 10:43:15',1,466,'8269a7c1-df39-4ca8-8592-b93a908a9c9b',116,'d27c5465284b48a5818ef931d6251c43','gigabytes',1,'2026-01-24 10:43:13',NULL),('2026-01-23 10:43:13','2026-01-23 10:43:15','2026-01-23 10:43:15',1,467,'971d9215-7e0c-4df0-8425-914afbbd7812',120,'d27c5465284b48a5818ef931d6251c43','gigabytes___DEFAULT__',1,'2026-01-24 10:43:13',NULL),('2026-01-23 10:43:13','2026-01-23 10:43:15','2026-01-23 10:43:15',1,468,'f4449475-563e-40b0-9036-7af7e4268c74',122,'d27c5465284b48a5818ef931d6251c43','snapshots___DEFAULT__',1,'2026-01-24 10:43:13',NULL),('2026-01-23 10:43:36','2026-01-23 10:43:37','2026-01-23 10:43:37',1,469,'b62108f2-3b03-48d9-ace2-7c9ea29ae04f',115,'d27c5465284b48a5818ef931d6251c43','volumes',1,'2026-01-24 10:43:36',NULL),('2026-01-23 10:43:36','2026-01-23 10:43:37','2026-01-23 10:43:37',1,470,'6a83d2a0-b3e9-41b1-85f6-3a152bb143cf',116,'d27c5465284b48a5818ef931d6251c43','gigabytes',1,'2026-01-24 10:43:36',NULL),('2026-01-23 10:43:36','2026-01-23 10:43:37','2026-01-23 10:43:37',1,471,'9ae11e4a-7d1c-48f4-a92e-4adabc80c448',119,'d27c5465284b48a5818ef931d6251c43','volumes___DEFAULT__',1,'2026-01-24 10:43:36',NULL),('2026-01-23 10:43:36','2026-01-23 10:43:37','2026-01-23 10:43:37',1,472,'5cebdbc7-24ec-4213-b44f-a09ccf63cf3f',120,'d27c5465284b48a5818ef931d6251c43','gigabytes___DEFAULT__',1,'2026-01-24 10:43:36',NULL),('2026-01-23 10:43:37','2026-01-23 10:43:37','2026-01-23 10:43:37',1,473,'cabeff1e-3643-4038-a864-b73ca14b9833',123,'6e762fca3b634c7aa1d994314c059c54','snapshots',1,'2026-01-24 10:43:37',NULL),('2026-01-23 10:43:37','2026-01-23 10:43:37','2026-01-23 10:43:37',1,474,'6796af9a-15de-4864-a750-8f6d61c2f4c4',106,'6e762fca3b634c7aa1d994314c059c54','gigabytes',1,'2026-01-24 10:43:37',NULL),('2026-01-23 10:43:37','2026-01-23 10:43:37','2026-01-23 10:43:37',1,475,'9c9da9fa-85fb-46e8-96c0-098f9044f1bb',108,'6e762fca3b634c7aa1d994314c059c54','gigabytes_multiattach',1,'2026-01-24 10:43:37',NULL),('2026-01-23 10:43:37','2026-01-23 10:43:37','2026-01-23 10:43:37',1,476,'080eeeeb-79d1-4a24-bc52-0890fc066c62',124,'6e762fca3b634c7aa1d994314c059c54','snapshots_multiattach',1,'2026-01-24 10:43:37',NULL),('2026-01-23 10:43:47','2026-01-23 10:43:47','2026-01-23 10:43:47',1,477,'02cb6c12-67ff-4434-95b3-6a1b3701c388',123,'6e762fca3b634c7aa1d994314c059c54','snapshots',-1,'2026-01-24 10:43:46',NULL),('2026-01-23 10:43:47','2026-01-23 10:43:47','2026-01-23 10:43:47',1,478,'cfc4de43-8587-4471-b060-39c7d854eef2',106,'6e762fca3b634c7aa1d994314c059c54','gigabytes',-1,'2026-01-24 10:43:46',NULL),('2026-01-23 10:43:47','2026-01-23 10:43:47','2026-01-23 10:43:47',1,479,'e40bba2a-dca2-48d0-85c6-96ee0526b214',108,'6e762fca3b634c7aa1d994314c059c54','gigabytes_multiattach',-1,'2026-01-24 10:43:46',NULL),('2026-01-23 10:43:47','2026-01-23 10:43:47','2026-01-23 10:43:47',1,480,'3cdeb011-85b8-4ed0-90b4-c1b262f122aa',124,'6e762fca3b634c7aa1d994314c059c54','snapshots_multiattach',-1,'2026-01-24 10:43:46',NULL),('2026-01-23 10:43:47','2026-01-23 10:43:47','2026-01-23 10:43:47',1,481,'3d184f1a-7809-489e-b86c-876daf9a2928',105,'6e762fca3b634c7aa1d994314c059c54','volumes',-1,'2026-01-24 10:43:47',NULL),('2026-01-23 10:43:47','2026-01-23 10:43:47','2026-01-23 10:43:47',1,482,'080c2762-8b01-4071-a998-f2bb034a0277',106,'6e762fca3b634c7aa1d994314c059c54','gigabytes',-1,'2026-01-24 10:43:47',NULL),('2026-01-23 10:43:47','2026-01-23 10:43:47','2026-01-23 10:43:47',1,483,'6cdce472-f278-4161-b8a0-19e1b2f1f0ff',107,'6e762fca3b634c7aa1d994314c059c54','volumes_multiattach',-1,'2026-01-24 10:43:47',NULL),('2026-01-23 10:43:47','2026-01-23 10:43:47','2026-01-23 10:43:47',1,484,'86413adc-1220-4db5-bb4f-c876a1b9b3d6',108,'6e762fca3b634c7aa1d994314c059c54','gigabytes_multiattach',-1,'2026-01-24 10:43:47',NULL),('2026-01-23 10:43:51','2026-01-23 10:43:51','2026-01-23 10:43:51',1,485,'b7e922a2-59d3-47eb-8b45-1fafbff121fc',105,'6e762fca3b634c7aa1d994314c059c54','volumes',-1,'2026-01-24 10:43:51',NULL),('2026-01-23 10:43:51','2026-01-23 10:43:51','2026-01-23 10:43:51',1,486,'209ee402-0eab-4eff-9aca-2ca2efff99da',106,'6e762fca3b634c7aa1d994314c059c54','gigabytes',-1,'2026-01-24 10:43:51',NULL),('2026-01-23 10:43:51','2026-01-23 10:43:51','2026-01-23 10:43:51',1,487,'f93febd0-2a9c-4363-93c0-39c0b83b62d3',107,'6e762fca3b634c7aa1d994314c059c54','volumes_multiattach',-1,'2026-01-24 10:43:51',NULL),('2026-01-23 10:43:51','2026-01-23 10:43:51','2026-01-23 10:43:51',1,488,'0617be49-96f8-4145-9f82-cf31745b3088',108,'6e762fca3b634c7aa1d994314c059c54','gigabytes_multiattach',-1,'2026-01-24 10:43:51',NULL),('2026-01-23 10:44:05','2026-01-23 10:44:05','2026-01-23 10:44:05',1,489,'a3caa45e-a778-408b-8583-968dfb74efee',105,'6e762fca3b634c7aa1d994314c059c54','volumes',-1,'2026-01-24 10:44:05',NULL),('2026-01-23 10:44:05','2026-01-23 10:44:05','2026-01-23 10:44:05',1,490,'10e5292d-c02b-4e53-b267-027afc98686d',106,'6e762fca3b634c7aa1d994314c059c54','gigabytes',-1,'2026-01-24 10:44:05',NULL),('2026-01-23 10:44:05','2026-01-23 10:44:05','2026-01-23 10:44:05',1,491,'a93ccc19-1026-4b17-b0e8-0848a26085f1',107,'6e762fca3b634c7aa1d994314c059c54','volumes_multiattach',-1,'2026-01-24 10:44:05',NULL),('2026-01-23 10:44:05','2026-01-23 10:44:05','2026-01-23 10:44:05',1,492,'e2a6caee-a1e6-451e-8a42-1073f3d2d3e0',108,'6e762fca3b634c7aa1d994314c059c54','gigabytes_multiattach',-1,'2026-01-24 10:44:05',NULL),('2026-01-23 10:44:28','2026-01-23 10:44:28','2026-01-23 10:44:28',1,493,'626c5b86-76a0-4b40-bfed-69500ffb41c5',115,'d27c5465284b48a5818ef931d6251c43','volumes',-1,'2026-01-24 10:44:28',NULL),('2026-01-23 10:44:28','2026-01-23 10:44:28','2026-01-23 10:44:28',1,494,'9c44201f-ca40-4814-8087-903325b1452d',116,'d27c5465284b48a5818ef931d6251c43','gigabytes',-1,'2026-01-24 10:44:28',NULL),('2026-01-23 10:44:28','2026-01-23 10:44:28','2026-01-23 10:44:28',1,495,'cec09523-58b3-4359-91eb-d4b9fbd6188a',119,'d27c5465284b48a5818ef931d6251c43','volumes___DEFAULT__',-1,'2026-01-24 10:44:28',NULL),('2026-01-23 10:44:28','2026-01-23 10:44:28','2026-01-23 10:44:28',1,496,'e0e06048-ba81-4f78-ba91-5b4177cde3d1',120,'d27c5465284b48a5818ef931d6251c43','gigabytes___DEFAULT__',-1,'2026-01-24 10:44:28',NULL),('2026-01-23 10:44:30','2026-01-23 10:44:33','2026-01-23 10:44:33',1,497,'1e5618b7-7ae5-4777-a5ce-a31a01b1401d',121,'d27c5465284b48a5818ef931d6251c43','snapshots',-1,'2026-01-24 10:44:30',NULL),('2026-01-23 10:44:30','2026-01-23 10:44:33','2026-01-23 10:44:33',1,498,'ed3efcf7-8c3b-4eba-903a-de9e4e553347',116,'d27c5465284b48a5818ef931d6251c43','gigabytes',-1,'2026-01-24 10:44:30',NULL),('2026-01-23 10:44:30','2026-01-23 10:44:33','2026-01-23 10:44:33',1,499,'418d5e55-e808-4cd2-83fa-52603dab58f9',120,'d27c5465284b48a5818ef931d6251c43','gigabytes___DEFAULT__',-1,'2026-01-24 10:44:30',NULL),('2026-01-23 10:44:30','2026-01-23 10:44:33','2026-01-23 10:44:33',1,500,'698228bc-d3c6-42f3-9768-7e9e10af4614',122,'d27c5465284b48a5818ef931d6251c43','snapshots___DEFAULT__',-1,'2026-01-24 10:44:30',NULL),('2026-01-23 10:44:32','2026-01-23 10:44:33','2026-01-23 10:44:33',1,501,'be158733-58d7-4512-9587-dff1f30103e1',105,'6e762fca3b634c7aa1d994314c059c54','volumes',-1,'2026-01-24 10:44:32',NULL),('2026-01-23 10:44:32','2026-01-23 10:44:33','2026-01-23 10:44:33',1,502,'865c96b2-182e-40d0-b3eb-1befd95c07be',106,'6e762fca3b634c7aa1d994314c059c54','gigabytes',-1,'2026-01-24 10:44:32',NULL),('2026-01-23 10:44:32','2026-01-23 10:44:33','2026-01-23 10:44:33',1,503,'61b7dc39-7630-48bb-919a-1d65aa2c5aea',107,'6e762fca3b634c7aa1d994314c059c54','volumes_multiattach',-1,'2026-01-24 10:44:32',NULL),('2026-01-23 10:44:32','2026-01-23 10:44:33','2026-01-23 10:44:33',1,504,'33943b00-b70c-4f29-bf74-feb6400b8b13',108,'6e762fca3b634c7aa1d994314c059c54','gigabytes_multiattach',-1,'2026-01-24 10:44:32',NULL),('2026-01-23 10:44:45','2026-01-23 10:44:49','2026-01-23 10:44:48',1,505,'ce2e3646-306c-4993-8f04-a89658e6e8eb',115,'d27c5465284b48a5818ef931d6251c43','volumes',-1,'2026-01-24 10:44:45',NULL),('2026-01-23 10:44:45','2026-01-23 10:44:49','2026-01-23 10:44:49',1,506,'a92908ff-dc78-4f6a-8510-ddbbf6000d5d',116,'d27c5465284b48a5818ef931d6251c43','gigabytes',-1,'2026-01-24 10:44:45',NULL),('2026-01-23 10:44:45','2026-01-23 10:44:49','2026-01-23 10:44:49',1,507,'7bfd95ce-d969-450b-9240-8a0561bfb359',119,'d27c5465284b48a5818ef931d6251c43','volumes___DEFAULT__',-1,'2026-01-24 10:44:45',NULL),('2026-01-23 10:44:45','2026-01-23 10:44:49','2026-01-23 10:44:49',1,508,'f995c47a-df97-4586-9352-7b012d93d2ef',120,'d27c5465284b48a5818ef931d6251c43','gigabytes___DEFAULT__',-1,'2026-01-24 10:44:45',NULL),('2026-01-23 10:45:04','2026-01-23 10:45:04','2026-01-23 10:45:04',1,509,'ea562ba4-15d9-4644-88a7-5e19427823f9',115,'d27c5465284b48a5818ef931d6251c43','volumes',1,'2026-01-24 10:45:04',NULL),('2026-01-23 10:45:04','2026-01-23 10:45:04','2026-01-23 10:45:04',1,510,'d42a0636-1f50-4adb-9a68-e1ee59e6bf8a',116,'d27c5465284b48a5818ef931d6251c43','gigabytes',1,'2026-01-24 10:45:04',NULL),('2026-01-23 10:45:04','2026-01-23 10:45:04','2026-01-23 10:45:04',1,511,'479bb912-7314-4ef1-aee2-2fc8200fafcd',119,'d27c5465284b48a5818ef931d6251c43','volumes___DEFAULT__',1,'2026-01-24 10:45:04',NULL),('2026-01-23 10:45:04','2026-01-23 10:45:04','2026-01-23 10:45:04',1,512,'e4bd2a22-ca55-4abc-ab46-5c4b906f74e8',120,'d27c5465284b48a5818ef931d6251c43','gigabytes___DEFAULT__',1,'2026-01-24 10:45:04',NULL),('2026-01-23 10:45:55','2026-01-23 10:45:55','2026-01-23 10:45:55',1,513,'cdf3cdeb-7362-4f53-8917-0f77903bb58b',125,'36d7e7c7ddbd4cf785fafd0d35b0a2d8','volumes',1,'2026-01-24 10:45:55',NULL),('2026-01-23 10:45:55','2026-01-23 10:45:55','2026-01-23 10:45:55',1,514,'4221860f-75bb-4e75-8894-b3164e400150',126,'36d7e7c7ddbd4cf785fafd0d35b0a2d8','gigabytes',1,'2026-01-24 10:45:55',NULL),('2026-01-23 10:45:55','2026-01-23 10:45:55','2026-01-23 10:45:55',1,515,'9e561d5d-9064-47f9-a34f-73f4fb0c5f03',127,'36d7e7c7ddbd4cf785fafd0d35b0a2d8','volumes___DEFAULT__',1,'2026-01-24 10:45:55',NULL),('2026-01-23 10:45:55','2026-01-23 10:45:55','2026-01-23 10:45:55',1,516,'d7c78f0e-10da-4b81-ad6a-f0f82c2383c5',128,'36d7e7c7ddbd4cf785fafd0d35b0a2d8','gigabytes___DEFAULT__',1,'2026-01-24 10:45:55',NULL),('2026-01-23 10:46:49','2026-01-23 10:46:49','2026-01-23 10:46:49',1,517,'fb65998a-8439-44ad-bd07-10b040468e66',121,'d27c5465284b48a5818ef931d6251c43','snapshots',1,'2026-01-24 10:46:49',NULL),('2026-01-23 10:46:49','2026-01-23 10:46:49','2026-01-23 10:46:49',1,518,'e7ccc8a5-f727-429f-9d2d-91dd6bc580d6',116,'d27c5465284b48a5818ef931d6251c43','gigabytes',1,'2026-01-24 10:46:49',NULL),('2026-01-23 10:46:49','2026-01-23 10:46:49','2026-01-23 10:46:49',1,519,'4d515a55-e15e-4987-bffe-968e205302b0',120,'d27c5465284b48a5818ef931d6251c43','gigabytes___DEFAULT__',1,'2026-01-24 10:46:49',NULL),('2026-01-23 10:46:49','2026-01-23 10:46:49','2026-01-23 10:46:49',1,520,'5601171a-07d2-4084-88e8-7d72ccd2b927',122,'d27c5465284b48a5818ef931d6251c43','snapshots___DEFAULT__',1,'2026-01-24 10:46:49',NULL),('2026-01-23 10:46:51','2026-01-23 10:46:51','2026-01-23 10:46:51',1,521,'d6d5ac4e-3707-413d-a26a-b89562efe106',115,'d27c5465284b48a5818ef931d6251c43','volumes',1,'2026-01-24 10:46:51',NULL),('2026-01-23 10:46:51','2026-01-23 10:46:51','2026-01-23 10:46:51',1,522,'20366a98-e5c2-4334-93b8-16f038aebd60',116,'d27c5465284b48a5818ef931d6251c43','gigabytes',1,'2026-01-24 10:46:51',NULL),('2026-01-23 10:46:51','2026-01-23 10:46:51','2026-01-23 10:46:51',1,523,'2bff674c-c56c-46ef-8602-1898eff2320b',119,'d27c5465284b48a5818ef931d6251c43','volumes___DEFAULT__',1,'2026-01-24 10:46:51',NULL),('2026-01-23 10:46:51','2026-01-23 10:46:51','2026-01-23 10:46:51',1,524,'c51675a8-5468-45d0-81b2-90fe1a53984f',120,'d27c5465284b48a5818ef931d6251c43','gigabytes___DEFAULT__',1,'2026-01-24 10:46:51',NULL),('2026-01-23 10:47:59','2026-01-23 10:47:59','2026-01-23 10:47:59',1,525,'e18f4ef5-115a-4079-833f-9c04c7fee278',115,'d27c5465284b48a5818ef931d6251c43','volumes',-1,'2026-01-24 10:47:59',NULL),('2026-01-23 10:47:59','2026-01-23 10:47:59','2026-01-23 10:47:59',1,526,'5028160c-2996-474f-9964-8648c8b91fc6',116,'d27c5465284b48a5818ef931d6251c43','gigabytes',-1,'2026-01-24 10:47:59',NULL),('2026-01-23 10:47:59','2026-01-23 10:47:59','2026-01-23 10:47:59',1,527,'f2bb7a17-6178-4f70-b41e-10a9aaada458',119,'d27c5465284b48a5818ef931d6251c43','volumes___DEFAULT__',-1,'2026-01-24 10:47:59',NULL),('2026-01-23 10:47:59','2026-01-23 10:47:59','2026-01-23 10:47:59',1,528,'ebd5de98-962b-4298-b497-aef5bc4c976d',120,'d27c5465284b48a5818ef931d6251c43','gigabytes___DEFAULT__',-1,'2026-01-24 10:47:59',NULL),('2026-01-23 10:48:01','2026-01-23 10:48:01','2026-01-23 10:48:01',1,529,'96d7b7f6-6949-410a-b64a-3ff45ac0f910',121,'d27c5465284b48a5818ef931d6251c43','snapshots',-1,'2026-01-24 10:48:01',NULL),('2026-01-23 10:48:01','2026-01-23 10:48:01','2026-01-23 10:48:01',1,530,'fdeee549-e45a-4c93-8d0a-bb504b95cb68',116,'d27c5465284b48a5818ef931d6251c43','gigabytes',-1,'2026-01-24 10:48:01',NULL),('2026-01-23 10:48:01','2026-01-23 10:48:01','2026-01-23 10:48:01',1,531,'74a519a9-9e05-4362-bc34-35bdd08b0b79',120,'d27c5465284b48a5818ef931d6251c43','gigabytes___DEFAULT__',-1,'2026-01-24 10:48:01',NULL),('2026-01-23 10:48:01','2026-01-23 10:48:01','2026-01-23 10:48:01',1,532,'1c89ab13-3b5f-47d7-8f49-f00805d96dd6',122,'d27c5465284b48a5818ef931d6251c43','snapshots___DEFAULT__',-1,'2026-01-24 10:48:01',NULL),('2026-01-23 10:48:01','2026-01-23 10:48:01','2026-01-23 10:48:01',1,533,'b52ebadb-9177-4476-9dbb-6b3c2b344862',125,'36d7e7c7ddbd4cf785fafd0d35b0a2d8','volumes',1,'2026-01-24 10:48:01',NULL),('2026-01-23 10:48:01','2026-01-23 10:48:01','2026-01-23 10:48:01',1,534,'014a31a3-6e71-4b05-ad6b-3ee5e633defe',126,'36d7e7c7ddbd4cf785fafd0d35b0a2d8','gigabytes',1,'2026-01-24 10:48:01',NULL),('2026-01-23 10:48:01','2026-01-23 10:48:01','2026-01-23 10:48:01',1,535,'f20369fd-1bdc-4290-8e9d-964bbb01ad65',127,'36d7e7c7ddbd4cf785fafd0d35b0a2d8','volumes___DEFAULT__',1,'2026-01-24 10:48:01',NULL),('2026-01-23 10:48:01','2026-01-23 10:48:01','2026-01-23 10:48:01',1,536,'108b18fa-4d7f-4439-a876-edb11347fc7d',128,'36d7e7c7ddbd4cf785fafd0d35b0a2d8','gigabytes___DEFAULT__',1,'2026-01-24 10:48:01',NULL),('2026-01-23 10:48:14','2026-01-23 10:48:14','2026-01-23 10:48:14',1,537,'091498f2-a01b-4798-901f-76cbb7daf544',115,'d27c5465284b48a5818ef931d6251c43','volumes',-1,'2026-01-24 10:48:14',NULL),('2026-01-23 10:48:14','2026-01-23 10:48:14','2026-01-23 10:48:14',1,538,'0b0eac59-96d6-43b7-8cd9-4f56ee6ca17e',116,'d27c5465284b48a5818ef931d6251c43','gigabytes',-1,'2026-01-24 10:48:14',NULL),('2026-01-23 10:48:14','2026-01-23 10:48:14','2026-01-23 10:48:14',1,539,'dd1d40e1-b7fd-4bd2-bea6-c654d7034b0d',119,'d27c5465284b48a5818ef931d6251c43','volumes___DEFAULT__',-1,'2026-01-24 10:48:14',NULL),('2026-01-23 10:48:14','2026-01-23 10:48:14','2026-01-23 10:48:14',1,540,'6c14d390-9368-4360-95cc-88674daf2fb7',120,'d27c5465284b48a5818ef931d6251c43','gigabytes___DEFAULT__',-1,'2026-01-24 10:48:14',NULL),('2026-01-23 10:49:11','2026-01-23 10:49:11','2026-01-23 10:49:11',1,541,'b3d2896a-83e0-4fa4-bfe4-a77a39760db7',125,'36d7e7c7ddbd4cf785fafd0d35b0a2d8','volumes',-1,'2026-01-24 10:49:11',NULL),('2026-01-23 10:49:11','2026-01-23 10:49:11','2026-01-23 10:49:11',1,542,'964e7fe4-134c-4f7e-bcd6-bf3454b5b043',126,'36d7e7c7ddbd4cf785fafd0d35b0a2d8','gigabytes',-1,'2026-01-24 10:49:11',NULL),('2026-01-23 10:49:11','2026-01-23 10:49:11','2026-01-23 10:49:11',1,543,'29f580ac-6a69-48e6-9d08-725cce8624ae',127,'36d7e7c7ddbd4cf785fafd0d35b0a2d8','volumes___DEFAULT__',-1,'2026-01-24 10:49:11',NULL),('2026-01-23 10:49:11','2026-01-23 10:49:11','2026-01-23 10:49:11',1,544,'770036a9-3c87-4ebd-903f-1b3d0d23a9d1',128,'36d7e7c7ddbd4cf785fafd0d35b0a2d8','gigabytes___DEFAULT__',-1,'2026-01-24 10:49:11',NULL),('2026-01-23 10:49:13','2026-01-23 10:49:13','2026-01-23 10:49:13',1,545,'bd8e4784-a610-41bf-86a3-2753aa8b7b3d',125,'36d7e7c7ddbd4cf785fafd0d35b0a2d8','volumes',-1,'2026-01-24 10:49:13',NULL),('2026-01-23 10:49:13','2026-01-23 10:49:13','2026-01-23 10:49:13',1,546,'48f66a7d-9136-4b30-8d18-8395e385e737',126,'36d7e7c7ddbd4cf785fafd0d35b0a2d8','gigabytes',-1,'2026-01-24 10:49:13',NULL),('2026-01-23 10:49:13','2026-01-23 10:49:13','2026-01-23 10:49:13',1,547,'ee5f6213-1430-4b16-b338-ba1005e0af17',127,'36d7e7c7ddbd4cf785fafd0d35b0a2d8','volumes___DEFAULT__',-1,'2026-01-24 10:49:13',NULL),('2026-01-23 10:49:13','2026-01-23 10:49:13','2026-01-23 10:49:13',1,548,'1204c9db-2bd2-4bd6-a40e-5b6e76784c54',128,'36d7e7c7ddbd4cf785fafd0d35b0a2d8','gigabytes___DEFAULT__',-1,'2026-01-24 10:49:13',NULL),('2026-01-23 10:49:39','2026-01-23 10:49:39','2026-01-23 10:49:39',1,549,'55a88ce7-e0c3-4609-8854-dcf1b73e3e92',129,'23776559930d49e8ade3d5f91aa5dfe4','volumes',1,'2026-01-24 10:49:39',NULL),('2026-01-23 10:49:39','2026-01-23 10:49:39','2026-01-23 10:49:39',1,550,'90a371a8-3a74-467f-a87c-0489f3c6ede7',130,'23776559930d49e8ade3d5f91aa5dfe4','gigabytes',1,'2026-01-24 10:49:39',NULL),('2026-01-23 10:49:39','2026-01-23 10:49:39','2026-01-23 10:49:39',1,551,'7a81b674-e820-4f66-8aab-2195d4be4137',131,'23776559930d49e8ade3d5f91aa5dfe4','volumes___DEFAULT__',1,'2026-01-24 10:49:39',NULL),('2026-01-23 10:49:39','2026-01-23 10:49:39','2026-01-23 10:49:39',1,552,'f1aa49be-7270-48b1-9496-1b3f188e16f4',132,'23776559930d49e8ade3d5f91aa5dfe4','gigabytes___DEFAULT__',1,'2026-01-24 10:49:39',NULL),('2026-01-23 10:49:40','2026-01-23 10:49:40','2026-01-23 10:49:40',1,553,'ceda9694-de17-43f4-957c-699bc447f118',133,'23776559930d49e8ade3d5f91aa5dfe4','snapshots',1,'2026-01-24 10:49:40',NULL),('2026-01-23 10:49:40','2026-01-23 10:49:40','2026-01-23 10:49:40',1,554,'6c24865e-856e-4788-892a-60615994ab3f',130,'23776559930d49e8ade3d5f91aa5dfe4','gigabytes',1,'2026-01-24 10:49:40',NULL),('2026-01-23 10:49:40','2026-01-23 10:49:40','2026-01-23 10:49:40',1,555,'dd18ac15-1162-4843-99c8-87b33a7002a9',132,'23776559930d49e8ade3d5f91aa5dfe4','gigabytes___DEFAULT__',1,'2026-01-24 10:49:40',NULL),('2026-01-23 10:49:40','2026-01-23 10:49:40','2026-01-23 10:49:40',1,556,'bcf43dc5-adbe-43c8-bea0-500cb0ba6294',134,'23776559930d49e8ade3d5f91aa5dfe4','snapshots___DEFAULT__',1,'2026-01-24 10:49:40',NULL),('2026-01-23 10:49:42','2026-01-23 10:49:42','2026-01-23 10:49:42',1,557,'f9a73aee-1343-4c53-8ff6-67291664054a',133,'23776559930d49e8ade3d5f91aa5dfe4','snapshots',-1,'2026-01-24 10:49:42',NULL),('2026-01-23 10:49:42','2026-01-23 10:49:42','2026-01-23 10:49:42',1,558,'451e5865-ebe0-4815-8ab3-bb0c0f876d31',130,'23776559930d49e8ade3d5f91aa5dfe4','gigabytes',-1,'2026-01-24 10:49:42',NULL),('2026-01-23 10:49:42','2026-01-23 10:49:42','2026-01-23 10:49:42',1,559,'e544ded4-b976-41cd-af3e-f7527ed1310c',132,'23776559930d49e8ade3d5f91aa5dfe4','gigabytes___DEFAULT__',-1,'2026-01-24 10:49:42',NULL),('2026-01-23 10:49:42','2026-01-23 10:49:42','2026-01-23 10:49:42',1,560,'cd3a505c-9223-4626-94d8-65106cd57dd9',134,'23776559930d49e8ade3d5f91aa5dfe4','snapshots___DEFAULT__',-1,'2026-01-24 10:49:42',NULL),('2026-01-23 10:49:44','2026-01-23 10:49:44','2026-01-23 10:49:44',1,561,'d5f6a0d7-4d32-4240-bb40-885da0763492',129,'23776559930d49e8ade3d5f91aa5dfe4','volumes',-1,'2026-01-24 10:49:44',NULL),('2026-01-23 10:49:44','2026-01-23 10:49:44','2026-01-23 10:49:44',1,562,'978e7523-fd4e-49fc-8d95-688d892e86f8',130,'23776559930d49e8ade3d5f91aa5dfe4','gigabytes',-1,'2026-01-24 10:49:44',NULL),('2026-01-23 10:49:44','2026-01-23 10:49:44','2026-01-23 10:49:44',1,563,'39006f48-a90c-406b-8880-d4ef09a1cb67',131,'23776559930d49e8ade3d5f91aa5dfe4','volumes___DEFAULT__',-1,'2026-01-24 10:49:44',NULL),('2026-01-23 10:49:44','2026-01-23 10:49:44','2026-01-23 10:49:44',1,564,'e1c65123-5dbd-4b7b-927a-f4955862a994',132,'23776559930d49e8ade3d5f91aa5dfe4','gigabytes___DEFAULT__',-1,'2026-01-24 10:49:44',NULL),('2026-01-23 10:49:53','2026-01-23 10:49:53','2026-01-23 10:49:53',1,565,'af87b942-2c31-471e-9da2-7cd33ab1efbc',135,'47c668e58db64e6a9121fb429d3bb9aa','volumes',1,'2026-01-24 10:49:53',NULL),('2026-01-23 10:49:53','2026-01-23 10:49:53','2026-01-23 10:49:53',1,566,'b4a20bc0-3e54-4599-a43c-2c5828a90ac4',136,'47c668e58db64e6a9121fb429d3bb9aa','gigabytes',1,'2026-01-24 10:49:53',NULL),('2026-01-23 10:49:53','2026-01-23 10:49:53','2026-01-23 10:49:53',1,567,'72ff2823-d76f-41a3-881a-741a7ed42d65',137,'47c668e58db64e6a9121fb429d3bb9aa','volumes___DEFAULT__',1,'2026-01-24 10:49:53',NULL),('2026-01-23 10:49:53','2026-01-23 10:49:53','2026-01-23 10:49:53',1,568,'484ab48a-dbcc-4ba1-b634-83fdc3d9d651',138,'47c668e58db64e6a9121fb429d3bb9aa','gigabytes___DEFAULT__',1,'2026-01-24 10:49:53',NULL),('2026-01-23 10:49:55','2026-01-23 10:49:55','2026-01-23 10:49:55',1,569,'0139a3ed-b9d4-4b69-bf7b-dde4202d8a38',135,'47c668e58db64e6a9121fb429d3bb9aa','volumes',1,'2026-01-24 10:49:55',NULL),('2026-01-23 10:49:55','2026-01-23 10:49:55','2026-01-23 10:49:55',1,570,'5e5cb83f-0cec-4855-9f13-be0f75390284',136,'47c668e58db64e6a9121fb429d3bb9aa','gigabytes',1,'2026-01-24 10:49:55',NULL),('2026-01-23 10:49:55','2026-01-23 10:49:55','2026-01-23 10:49:55',1,571,'784439ac-d812-42ec-a879-885b55875579',137,'47c668e58db64e6a9121fb429d3bb9aa','volumes___DEFAULT__',1,'2026-01-24 10:49:55',NULL),('2026-01-23 10:49:55','2026-01-23 10:49:55','2026-01-23 10:49:55',1,572,'56683e43-19c3-4ad2-ac97-22b9733b11be',138,'47c668e58db64e6a9121fb429d3bb9aa','gigabytes___DEFAULT__',1,'2026-01-24 10:49:55',NULL),('2026-01-23 10:49:57','2026-01-23 10:49:57','2026-01-23 10:49:57',1,573,'747bb257-9d7c-4aa7-bc70-dce4513478d6',135,'47c668e58db64e6a9121fb429d3bb9aa','volumes',1,'2026-01-24 10:49:57',NULL),('2026-01-23 10:49:57','2026-01-23 10:49:57','2026-01-23 10:49:57',1,574,'f0071a11-a29d-4b39-b761-acc6863c415f',136,'47c668e58db64e6a9121fb429d3bb9aa','gigabytes',1,'2026-01-24 10:49:57',NULL),('2026-01-23 10:49:57','2026-01-23 10:49:57','2026-01-23 10:49:57',1,575,'f88f9070-8d3f-4eb1-a729-d7fb32791ea6',137,'47c668e58db64e6a9121fb429d3bb9aa','volumes___DEFAULT__',1,'2026-01-24 10:49:57',NULL),('2026-01-23 10:49:57','2026-01-23 10:49:57','2026-01-23 10:49:57',1,576,'1261b274-edc0-4371-a37d-73e554b64fad',138,'47c668e58db64e6a9121fb429d3bb9aa','gigabytes___DEFAULT__',1,'2026-01-24 10:49:57',NULL),('2026-01-23 10:50:03','2026-01-23 10:50:03','2026-01-23 10:50:03',1,577,'6aef36db-0a5f-48d7-a7af-016ff3f7d82c',135,'47c668e58db64e6a9121fb429d3bb9aa','volumes',-1,'2026-01-24 10:50:03',NULL),('2026-01-23 10:50:03','2026-01-23 10:50:03','2026-01-23 10:50:03',1,578,'7db87a05-c53a-45c1-80e4-971560abc75a',136,'47c668e58db64e6a9121fb429d3bb9aa','gigabytes',-1,'2026-01-24 10:50:03',NULL),('2026-01-23 10:50:03','2026-01-23 10:50:03','2026-01-23 10:50:03',1,579,'065343e2-d231-484c-9130-7175e0a8a7ec',137,'47c668e58db64e6a9121fb429d3bb9aa','volumes___DEFAULT__',-1,'2026-01-24 10:50:03',NULL),('2026-01-23 10:50:03','2026-01-23 10:50:03','2026-01-23 10:50:03',1,580,'e6af136b-3422-4b50-a802-cba68c6873fd',138,'47c668e58db64e6a9121fb429d3bb9aa','gigabytes___DEFAULT__',-1,'2026-01-24 10:50:03',NULL),('2026-01-23 10:50:05','2026-01-23 10:50:05','2026-01-23 10:50:05',1,581,'14a1c347-b653-4f80-a9a3-3ba1df70fca8',135,'47c668e58db64e6a9121fb429d3bb9aa','volumes',-1,'2026-01-24 10:50:05',NULL),('2026-01-23 10:50:05','2026-01-23 10:50:05','2026-01-23 10:50:05',1,582,'e4fe6f9b-a31e-4925-a4d6-d7ff1b18e5c0',136,'47c668e58db64e6a9121fb429d3bb9aa','gigabytes',-1,'2026-01-24 10:50:05',NULL),('2026-01-23 10:50:05','2026-01-23 10:50:05','2026-01-23 10:50:05',1,583,'82e4bcc8-8b9a-4905-af8a-a06318384b89',137,'47c668e58db64e6a9121fb429d3bb9aa','volumes___DEFAULT__',-1,'2026-01-24 10:50:05',NULL),('2026-01-23 10:50:05','2026-01-23 10:50:05','2026-01-23 10:50:05',1,584,'efe9c830-7023-4fd9-9f44-8ba3fae3c4b2',138,'47c668e58db64e6a9121fb429d3bb9aa','gigabytes___DEFAULT__',-1,'2026-01-24 10:50:05',NULL),('2026-01-23 10:50:06','2026-01-23 10:50:06','2026-01-23 10:50:06',1,585,'b929b09f-4d85-4faa-9cff-a1fc841fa2ee',135,'47c668e58db64e6a9121fb429d3bb9aa','volumes',-1,'2026-01-24 10:50:06',NULL),('2026-01-23 10:50:06','2026-01-23 10:50:06','2026-01-23 10:50:06',1,586,'17c2da57-8073-4a1e-8328-956a276d5597',136,'47c668e58db64e6a9121fb429d3bb9aa','gigabytes',-1,'2026-01-24 10:50:06',NULL),('2026-01-23 10:50:06','2026-01-23 10:50:06','2026-01-23 10:50:06',1,587,'c77deeb2-ae83-4a92-bc65-f185ef80a7fd',137,'47c668e58db64e6a9121fb429d3bb9aa','volumes___DEFAULT__',-1,'2026-01-24 10:50:06',NULL),('2026-01-23 10:50:06','2026-01-23 10:50:06','2026-01-23 10:50:06',1,588,'1c9e0860-aea8-4b40-afe2-3510f99a7e5f',138,'47c668e58db64e6a9121fb429d3bb9aa','gigabytes___DEFAULT__',-1,'2026-01-24 10:50:06',NULL),('2026-01-23 10:50:41','2026-01-23 10:50:41','2026-01-23 10:50:41',1,589,'81ab0fae-277e-4ea4-9039-225bf65a2969',139,'9533be9d361246bdb0a7c1bd3015db66','volumes',1,'2026-01-24 10:50:41',NULL),('2026-01-23 10:50:41','2026-01-23 10:50:41','2026-01-23 10:50:41',1,590,'37b62c77-6e5d-456f-a680-53880b111f74',140,'9533be9d361246bdb0a7c1bd3015db66','gigabytes',1,'2026-01-24 10:50:41',NULL),('2026-01-23 10:50:41','2026-01-23 10:50:41','2026-01-23 10:50:41',1,591,'fd865c10-8c5c-4caa-bb16-606c182e3b4b',141,'9533be9d361246bdb0a7c1bd3015db66','volumes_tempest-scenario-type-luks-1600364038',1,'2026-01-24 10:50:41',NULL),('2026-01-23 10:50:41','2026-01-23 10:50:41','2026-01-23 10:50:41',1,592,'c651bffa-1012-469c-aac0-6d82e7e68e39',142,'9533be9d361246bdb0a7c1bd3015db66','gigabytes_tempest-scenario-type-luks-1600364038',1,'2026-01-24 10:50:41',NULL),('2026-01-23 10:52:11','2026-01-23 10:52:11','2026-01-23 10:52:11',1,593,'8e1d0014-1e22-41fc-9dce-6b269d43dc44',139,'9533be9d361246bdb0a7c1bd3015db66','volumes',-1,'2026-01-24 10:52:11',NULL),('2026-01-23 10:52:11','2026-01-23 10:52:11','2026-01-23 10:52:11',1,594,'beea3d40-f402-4b88-8f35-f815af0bb17f',140,'9533be9d361246bdb0a7c1bd3015db66','gigabytes',-1,'2026-01-24 10:52:11',NULL),('2026-01-23 10:52:11','2026-01-23 10:52:11','2026-01-23 10:52:11',1,595,'74deac9b-16d2-4738-98ab-b6eaf863eb8a',141,'9533be9d361246bdb0a7c1bd3015db66','volumes_tempest-scenario-type-luks-1600364038',-1,'2026-01-24 10:52:11',NULL),('2026-01-23 10:52:11','2026-01-23 10:52:11','2026-01-23 10:52:11',1,596,'c724fc58-04d5-4bb8-877d-6acaf97c4c02',142,'9533be9d361246bdb0a7c1bd3015db66','gigabytes_tempest-scenario-type-luks-1600364038',-1,'2026-01-24 10:52:11',NULL),('2026-01-23 11:14:18','2026-01-23 11:14:18','2026-01-23 11:14:18',1,597,'8918accd-af5a-47d0-a2d3-fc0cb2f42e7b',143,'3a245f7970f14fffa60af2ff972b4bfd','volumes',1,'2026-01-24 11:14:18',NULL),('2026-01-23 11:14:18','2026-01-23 11:14:18','2026-01-23 11:14:18',1,598,'35b06a36-8255-4413-a4e7-57141c3b5121',144,'3a245f7970f14fffa60af2ff972b4bfd','gigabytes',1,'2026-01-24 11:14:18',NULL),('2026-01-23 11:14:18','2026-01-23 11:14:18','2026-01-23 11:14:18',1,599,'fc8637ee-9b05-4bd9-b5b4-c95436558446',145,'3a245f7970f14fffa60af2ff972b4bfd','volumes___DEFAULT__',1,'2026-01-24 11:14:18',NULL),('2026-01-23 11:14:18','2026-01-23 11:14:18','2026-01-23 11:14:18',1,600,'9b825fa4-3901-4256-83cc-4d46f21f4353',146,'3a245f7970f14fffa60af2ff972b4bfd','gigabytes___DEFAULT__',1,'2026-01-24 11:14:18',NULL),('2026-01-23 11:16:52','2026-01-23 11:16:52','2026-01-23 11:16:52',1,601,'63dc593b-46d1-45ba-9d43-353eaf96f4b1',143,'3a245f7970f14fffa60af2ff972b4bfd','volumes',-1,'2026-01-24 11:16:52',NULL),('2026-01-23 11:16:52','2026-01-23 11:16:52','2026-01-23 11:16:52',1,602,'7433cb55-2de8-4bee-836d-ec180f2a3303',144,'3a245f7970f14fffa60af2ff972b4bfd','gigabytes',-1,'2026-01-24 11:16:52',NULL),('2026-01-23 11:16:52','2026-01-23 11:16:52','2026-01-23 11:16:52',1,603,'7e83db66-c192-40ab-b384-a9c76dd4d08b',145,'3a245f7970f14fffa60af2ff972b4bfd','volumes___DEFAULT__',-1,'2026-01-24 11:16:52',NULL),('2026-01-23 11:16:52','2026-01-23 11:16:52','2026-01-23 11:16:52',1,604,'b4d1f85b-2981-4dc6-8e7f-10f045d2534c',146,'3a245f7970f14fffa60af2ff972b4bfd','gigabytes___DEFAULT__',-1,'2026-01-24 11:16:52',NULL);
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2026-01-23 08:45:06','2026-01-23 11:26:48',NULL,0,1,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',965,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'ed5b9728-ba17-4f16-9fcd-d39bfb9702c3'),('2026-01-23 09:23:29','2026-01-23 11:26:41',NULL,0,2,'cinder-backup-0','cinder-backup','cinder-backup',738,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'b2c62333-b9a8-494a-8092-b67c353c783e'),('2026-01-23 09:23:31','2026-01-23 11:26:41',NULL,0,3,'hostgroup@ceph','cinder-volume','cinder-volume',738,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
INSERT INTO `snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `status`, `progress`, `volume_size`, `scheduled_at`, `display_name`, `display_description`, `provider_location`, `encryption_key_id`, `volume_type_id`, `cgsnapshot_id`, `provider_id`, `provider_auth`, `group_snapshot_id`, `use_quota`) VALUES ('2026-01-23 10:43:37','2026-01-23 10:43:46','2026-01-23 10:43:47',1,'3033136a-603a-44e6-bb60-ea116fce16b7','d8ca748e-6bb8-4ae2-9729-d2be77ce520f','93cd560e84264023877c47122b5919de','6e762fca3b634c7aa1d994314c059c54','deleted','100%',1,NULL,'snapshot for multiattach-snapshot',NULL,NULL,NULL,'6c54b639-a8d0-4bdb-a3a9-96eb9a3c5b86',NULL,NULL,NULL,NULL,1),('2026-01-23 10:21:22','2026-01-23 10:22:12','2026-01-23 10:22:14',1,'55b68394-c909-4591-83f4-4097e41c3b4b','7857fc75-1658-465f-a6a1-40f608f6408e','c041da0a601a4260b29fc9c65719597f','b976daabc8124a99814954633f99ed7b','deleted','100%',1,NULL,'tempest-TestMinimumBasicScenario-snapshot-613354480',NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,NULL,NULL,NULL,1),('2026-01-23 10:41:35','2026-01-23 10:42:05','2026-01-23 10:42:08',1,'56abda02-64b9-4403-a75d-7c77cd557d3a','1bf4eab6-ff85-4f56-89e4-e9a95b31e4e7','eb70c3aee8b64273a1930c0c2c231aff','d27c5465284b48a5818ef931d6251c43','deleted','100%',1,NULL,'tempest-TestVolumeBootPattern-snapshot-416289812',NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,NULL,NULL,NULL,1),('2026-01-23 10:46:49','2026-01-23 10:48:00','2026-01-23 10:48:01',1,'7275b587-5973-4959-aa03-e3382419cbac','e5e1339d-ae3b-4104-9429-034d0ceea4fd','eb70c3aee8b64273a1930c0c2c231aff','d27c5465284b48a5818ef931d6251c43','deleted','100%',1,NULL,'tempest-TestVolumeBootPattern-snapshot-1176361873',NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,NULL,NULL,NULL,1),('2026-01-23 10:49:40','2026-01-23 10:49:42','2026-01-23 10:49:42',1,'7db35753-b7ce-4240-8917-9f6cf1ee9654','11c7a636-49ff-4a67-a9cc-e1355415865f','31e408829d1a48ab9abdfcd623b2c8b6','23776559930d49e8ade3d5f91aa5dfe4','deleted','100%',1,NULL,'tempest-VolumesSnapshotsTestJSON-Snapshot-1370138506',NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,NULL,NULL,NULL,1),('2026-01-23 10:35:48','2026-01-23 10:37:20','2026-01-23 10:37:20',1,'8cf5af55-5afb-410e-a9c9-3cb0a111ab6f','cc391f04-6d6d-4c9d-866a-f0d2a56a62fb','9a8ce4c88e8b46c5806ada5e3a6cdbbf','d59dad6496894352a2f4c7eb66ca1914','deleted','100%',1,NULL,'tempest-TestStampPattern-snapshot-550347398',NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,NULL,NULL,NULL,1),('2026-01-23 10:43:15','2026-01-23 10:44:29','2026-01-23 10:44:30',1,'aad073c6-3850-4a37-969d-b73d0ec7219a','d77d9325-542a-4716-94b2-e66e8ceab532','eb70c3aee8b64273a1930c0c2c231aff','d27c5465284b48a5818ef931d6251c43','deleted','100%',1,NULL,'snapshot for tempest-TestVolumeBootPatternsnapshot-349323527',NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,NULL,NULL,NULL,1);
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
INSERT INTO `volume_attachment` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `attached_host`, `instance_uuid`, `mountpoint`, `attach_time`, `detach_time`, `attach_mode`, `attach_status`, `connection_info`, `connector`) VALUES ('2026-01-23 10:21:17','2026-01-23 10:23:06','2026-01-23 10:23:06',1,'0c773f34-5811-4b94-875c-528e61a6d7b2','7857fc75-1658-465f-a6a1-40f608f6408e','compute-2.ctlplane.example.com','a00a5042-ce71-4ecf-ab8f-d9e596d48035','/dev/vdb','2026-01-23 10:21:19','2026-01-23 10:23:06','rw','detached','{\"name\": \"volumes/volume-7857fc75-1658-465f-a6a1-40f608f6408e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"7857fc75-1658-465f-a6a1-40f608f6408e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"0c773f34-5811-4b94-875c-528e61a6d7b2\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 10:46:02','2026-01-23 10:48:08','2026-01-23 10:48:08',1,'0cae7e16-8cc7-4dcc-82f1-3e66046ac933','e5e1339d-ae3b-4104-9429-034d0ceea4fd','compute-0.ctlplane.example.com','28049b58-a86b-4eeb-8faa-239ab046508b','/dev/vda','2026-01-23 10:46:06','2026-01-23 10:48:08','rw','detached','{\"name\": \"volumes/volume-e5e1339d-ae3b-4104-9429-034d0ceea4fd\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"e5e1339d-ae3b-4104-9429-034d0ceea4fd\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"0cae7e16-8cc7-4dcc-82f1-3e66046ac933\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:c6473626b456\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"ebc95db9-b389-4cf6-b3a5-7ae0afc322d2\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 09:32:00','2026-01-23 09:32:38','2026-01-23 09:32:38',1,'0f3f1f70-9837-4df7-bac9-a17bfd4c3a5f','2c9770c1-d351-43fa-b18d-aaf9291801fe','compute-1.ctlplane.example.com','54a1ad4e-6fc9-42dc-aa4c-99d3f1297520','/dev/vda','2026-01-23 09:32:12','2026-01-23 09:32:38','rw','detached','{\"name\": \"volumes/volume-2c9770c1-d351-43fa-b18d-aaf9291801fe\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"2c9770c1-d351-43fa-b18d-aaf9291801fe\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"0f3f1f70-9837-4df7-bac9-a17bfd4c3a5f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:6b3426e5528c\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"5e159ac4-110b-464c-8264-d020fcde6246\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 09:43:15','2026-01-23 09:43:28','2026-01-23 09:43:28',1,'1008aa32-dd0a-418d-a127-644d0bbd6028','99bccbe9-de42-409d-aa8f-e509f6080e7b','compute-0.ctlplane.example.com','a1208de2-efde-4618-8388-2acfab37582a','/dev/vdb','2026-01-23 09:43:16','2026-01-23 09:43:28','rw','detached','{\"name\": \"volumes/volume-99bccbe9-de42-409d-aa8f-e509f6080e7b\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"99bccbe9-de42-409d-aa8f-e509f6080e7b\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"1008aa32-dd0a-418d-a127-644d0bbd6028\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:c6473626b456\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"ebc95db9-b389-4cf6-b3a5-7ae0afc322d2\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 09:37:12','2026-01-23 09:37:45','2026-01-23 09:37:45',1,'157a81cb-fd76-48d4-abf5-e6fb564e20a5','b06791ec-66fd-4114-8448-7ea0b7f88f25','compute-2.ctlplane.example.com','261ab1ec-f79b-4867-bcb6-1c1d7491120e','/dev/vda','2026-01-23 09:37:16','2026-01-23 09:37:45','rw','detached','{\"name\": \"volumes/volume-b06791ec-66fd-4114-8448-7ea0b7f88f25\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"b06791ec-66fd-4114-8448-7ea0b7f88f25\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"157a81cb-fd76-48d4-abf5-e6fb564e20a5\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 09:42:41','2026-01-23 09:43:35','2026-01-23 09:43:35',1,'1b16e998-3fac-40f5-b6f7-4f1cd4125dc9','113a804f-8abc-47f6-b4ca-e098579996e7','compute-0.ctlplane.example.com','9b1cd8b8-1ac9-441e-961f-17dc56cb555c','/dev/vda','2026-01-23 09:42:44','2026-01-23 09:43:35','rw','detached','{\"name\": \"volumes/volume-113a804f-8abc-47f6-b4ca-e098579996e7\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"113a804f-8abc-47f6-b4ca-e098579996e7\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"1b16e998-3fac-40f5-b6f7-4f1cd4125dc9\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:c6473626b456\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"ebc95db9-b389-4cf6-b3a5-7ae0afc322d2\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 11:14:29','2026-01-23 11:15:38','2026-01-23 11:15:38',1,'1cb3b49f-526a-4fbc-a093-9feffe2c7d1e','525f185e-d0f4-4a0b-bd48-9219445747c5','compute-2.ctlplane.example.com','ed71c532-711c-49b9-b0d5-eaf409f0bc76','/dev/vda','2026-01-23 11:14:32','2026-01-23 11:15:38','rw','detached','{\"name\": \"volumes/volume-525f185e-d0f4-4a0b-bd48-9219445747c5\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"525f185e-d0f4-4a0b-bd48-9219445747c5\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"1cb3b49f-526a-4fbc-a093-9feffe2c7d1e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 09:37:39','2026-01-23 09:38:04','2026-01-23 09:38:04',1,'1efcf993-49fb-4692-9e1a-35930d237781','b06791ec-66fd-4114-8448-7ea0b7f88f25','compute-0.ctlplane.example.com','261ab1ec-f79b-4867-bcb6-1c1d7491120e','/dev/vda','2026-01-23 09:37:40','2026-01-23 09:38:04','null','detached','{\"name\": \"volumes/volume-b06791ec-66fd-4114-8448-7ea0b7f88f25\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"b06791ec-66fd-4114-8448-7ea0b7f88f25\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"1efcf993-49fb-4692-9e1a-35930d237781\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:c6473626b456\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"ebc95db9-b389-4cf6-b3a5-7ae0afc322d2\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2026-01-23 10:40:47','2026-01-23 10:42:23','2026-01-23 10:42:23',1,'1f8ab79e-6332-4cd6-979a-3a7c8fade811','4393c992-1666-40a0-ab11-4cc66bdcd721','compute-0.ctlplane.example.com','0888913c-71a6-45fe-97bf-9dddd2b7b521','/dev/vdb','2026-01-23 10:40:58','2026-01-23 10:42:23','rw','detached','{\"name\": \"volumes/volume-4393c992-1666-40a0-ab11-4cc66bdcd721\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"4393c992-1666-40a0-ab11-4cc66bdcd721\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"1f8ab79e-6332-4cd6-979a-3a7c8fade811\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:c6473626b456\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"ebc95db9-b389-4cf6-b3a5-7ae0afc322d2\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 09:32:30','2026-01-23 09:33:03','2026-01-23 09:33:03',1,'27ad6cc5-03f7-4ff3-b319-d6a2b0f2119f','2c9770c1-d351-43fa-b18d-aaf9291801fe','compute-0.ctlplane.example.com','54a1ad4e-6fc9-42dc-aa4c-99d3f1297520','/dev/vda','2026-01-23 09:32:31','2026-01-23 09:33:03','null','detached','{\"name\": \"volumes/volume-2c9770c1-d351-43fa-b18d-aaf9291801fe\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"2c9770c1-d351-43fa-b18d-aaf9291801fe\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"27ad6cc5-03f7-4ff3-b319-d6a2b0f2119f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:c6473626b456\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"ebc95db9-b389-4cf6-b3a5-7ae0afc322d2\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2026-01-23 10:51:56','2026-01-23 10:52:04','2026-01-23 10:52:04',1,'2ee11420-b20b-4205-8376-172c18b34b0d','fe67c9d0-617c-4383-b125-c4c25cee2e92','compute-2.ctlplane.example.com','cad430d0-9af9-46f1-ad8b-38438fc2030b','/dev/vdb','2026-01-23 10:51:58','2026-01-23 10:52:04','rw','detached','{\"name\": \"volumes/volume-fe67c9d0-617c-4383-b125-c4c25cee2e92\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"fe67c9d0-617c-4383-b125-c4c25cee2e92\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": true, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"2ee11420-b20b-4205-8376-172c18b34b0d\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 10:14:47','2026-01-23 10:18:30','2026-01-23 10:18:30',1,'32d7d55a-4143-403b-9980-a3decf26d208','3bbb4d6e-08b6-40cf-b719-94bd5e591c16','compute-1.ctlplane.example.com','fd9d9b93-c87f-40e9-9b2d-1e40b9a74a78','/dev/vda','2026-01-23 10:14:50','2026-01-23 10:18:30','rw','detached','{\"name\": \"volumes/volume-3bbb4d6e-08b6-40cf-b719-94bd5e591c16\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"3bbb4d6e-08b6-40cf-b719-94bd5e591c16\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"32d7d55a-4143-403b-9980-a3decf26d208\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:6b3426e5528c\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"5e159ac4-110b-464c-8264-d020fcde6246\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 10:41:48','2026-01-23 10:42:28','2026-01-23 10:42:28',1,'366ccb94-0e1f-4db2-ac2b-26a36302f406','4393c992-1666-40a0-ab11-4cc66bdcd721','compute-0.ctlplane.example.com','f34f1af9-6c51-42ec-97f8-fb5bb146aeb6','/dev/vdb','2026-01-23 10:41:54','2026-01-23 10:42:28','rw','detached','{\"name\": \"volumes/volume-4393c992-1666-40a0-ab11-4cc66bdcd721\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"4393c992-1666-40a0-ab11-4cc66bdcd721\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"366ccb94-0e1f-4db2-ac2b-26a36302f406\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:c6473626b456\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"ebc95db9-b389-4cf6-b3a5-7ae0afc322d2\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 10:07:49','2026-01-23 10:08:51','2026-01-23 10:08:51',1,'37519fcc-265f-48cd-92f5-8f40812f1365','509947fc-76b8-4398-98d1-07609c1b5d35','compute-0.ctlplane.example.com','6e5889e0-b5b3-442c-b7dd-0434b1da7c96','/dev/vdb','2026-01-23 10:07:51','2026-01-23 10:08:51','rw','detached','{\"name\": \"volumes/volume-509947fc-76b8-4398-98d1-07609c1b5d35\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"509947fc-76b8-4398-98d1-07609c1b5d35\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"37519fcc-265f-48cd-92f5-8f40812f1365\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:c6473626b456\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"ebc95db9-b389-4cf6-b3a5-7ae0afc322d2\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 09:37:57','2026-01-23 09:38:24','2026-01-23 09:38:24',1,'37c89e72-cbd9-4048-848e-3a796554acb8','b06791ec-66fd-4114-8448-7ea0b7f88f25','compute-2.ctlplane.example.com','261ab1ec-f79b-4867-bcb6-1c1d7491120e','/dev/vda','2026-01-23 09:37:58','2026-01-23 09:38:24','null','detached','{\"name\": \"volumes/volume-b06791ec-66fd-4114-8448-7ea0b7f88f25\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"b06791ec-66fd-4114-8448-7ea0b7f88f25\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"37c89e72-cbd9-4048-848e-3a796554acb8\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2026-01-23 10:10:59','2026-01-23 10:11:04','2026-01-23 10:11:04',1,'383ed606-3757-4f5e-bb69-b98b5ca72de4','809049fe-43c3-4fd2-a846-ff41c8b09a79','compute-1.ctlplane.example.com','1b7661cc-4a60-4a80-967f-f9243a031c9f','/dev/vdb','2026-01-23 10:11:00','2026-01-23 10:11:04','rw','detached','{\"name\": \"volumes/volume-809049fe-43c3-4fd2-a846-ff41c8b09a79\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"809049fe-43c3-4fd2-a846-ff41c8b09a79\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"383ed606-3757-4f5e-bb69-b98b5ca72de4\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:6b3426e5528c\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"5e159ac4-110b-464c-8264-d020fcde6246\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 09:50:56','2026-01-23 09:51:03','2026-01-23 09:51:03',1,'38765fd5-b063-42f9-92b7-1b569932cb85','97e56534-c8f3-4b8d-bb6b-37ecd5ac131a','compute-1.ctlplane.example.com','463b029c-94eb-4160-9199-43759bb23b61','/dev/vdb','2026-01-23 09:50:57','2026-01-23 09:51:03','rw','detached','{\"name\": \"volumes/volume-97e56534-c8f3-4b8d-bb6b-37ecd5ac131a\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"97e56534-c8f3-4b8d-bb6b-37ecd5ac131a\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"38765fd5-b063-42f9-92b7-1b569932cb85\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:6b3426e5528c\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"5e159ac4-110b-464c-8264-d020fcde6246\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 09:37:22','2026-01-23 09:37:27','2026-01-23 09:37:27',1,'3ca13d06-d1a5-443f-8d44-c57d0ef6d59b','8bf8b5e1-14c0-4be1-9734-e2610e0b9950','compute-1.ctlplane.example.com','f8b984c8-aa93-48e5-b6c5-15c6b22ca3cc','/dev/vdb','2026-01-23 09:37:24','2026-01-23 09:37:27','rw','detached','{\"name\": \"volumes/volume-8bf8b5e1-14c0-4be1-9734-e2610e0b9950\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"8bf8b5e1-14c0-4be1-9734-e2610e0b9950\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"3ca13d06-d1a5-443f-8d44-c57d0ef6d59b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:6b3426e5528c\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"5e159ac4-110b-464c-8264-d020fcde6246\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 10:46:17','2026-01-23 10:47:05','2026-01-23 10:47:05',1,'3d2ac2a0-6592-42ab-ad7e-3983e01cbe98','183950c6-1381-47bd-9def-115173b33253','compute-2.ctlplane.example.com','fb31c535-476a-4f92-866e-664b8b25e0fc','/dev/vdc','2026-01-23 10:46:21','2026-01-23 10:47:05','rw','detached','{\"name\": \"volumes/volume-183950c6-1381-47bd-9def-115173b33253\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"183950c6-1381-47bd-9def-115173b33253\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"3d2ac2a0-6592-42ab-ad7e-3983e01cbe98\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-23 10:17:19','2026-01-23 10:17:52','2026-01-23 10:17:52',1,'44675786-87de-4130-a118-01a6f88fed0a','b016d51c-9f03-4ca0-86e5-02cc8ca5059f','compute-0.ctlplane.example.com','ccd07f55-529f-4dbb-989c-2cdbdd393a0b','/dev/vdc','2026-01-23 10:17:21','2026-01-23 10:17:52','rw','detached','{\"name\": \"volumes/volume-b016d51c-9f03-4ca0-86e5-02cc8ca5059f\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"b016d51c-9f03-4ca0-86e5-02cc8ca5059f\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"44675786-87de-4130-a118-01a6f88fed0a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:c6473626b456\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"ebc95db9-b389-4cf6-b3a5-7ae0afc322d2\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-23 10:34:52','2026-01-23 10:35:50','2026-01-23 10:35:50',1,'47071b21-d18c-49d3-b6b7-352b220eac3d','c35b89da-3ccd-4fac-ae16-afc4a62713b5','compute-0.ctlplane.example.com','5d42acd2-a3c4-40d2-b1c7-0dd7920671fe','/dev/vdb','2026-01-23 10:34:54','2026-01-23 10:35:50','rw','detached','{\"name\": \"volumes/volume-c35b89da-3ccd-4fac-ae16-afc4a62713b5\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"c35b89da-3ccd-4fac-ae16-afc4a62713b5\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"47071b21-d18c-49d3-b6b7-352b220eac3d\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:c6473626b456\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"ebc95db9-b389-4cf6-b3a5-7ae0afc322d2\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 10:14:57','2026-01-23 10:15:46','2026-01-23 10:15:46',1,'4746c25b-1702-4d42-aee7-aa52d6e3ff92','06664261-bdf3-44c1-9f40-a29c0039b070','compute-2.ctlplane.example.com','633b85ea-a47c-4be0-b06d-388aa421728b','/dev/vdb','2026-01-23 10:15:02','2026-01-23 10:15:46','rw','detached','{\"name\": \"volumes/volume-06664261-bdf3-44c1-9f40-a29c0039b070\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"06664261-bdf3-44c1-9f40-a29c0039b070\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"4746c25b-1702-4d42-aee7-aa52d6e3ff92\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 10:06:08','2026-01-23 10:07:00','2026-01-23 10:07:00',1,'4b5e30a1-7a86-47bd-b514-be1adeaa07a1','1337690c-8061-4b7e-bb70-8cbfeecc77ac','compute-2.ctlplane.example.com','483afeac-561b-48ff-89d6-d02d1b615fc9','/dev/vda','2026-01-23 10:06:31','2026-01-23 10:07:00','rw','detached','{\"name\": \"volumes/volume-1337690c-8061-4b7e-bb70-8cbfeecc77ac\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"1337690c-8061-4b7e-bb70-8cbfeecc77ac\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"4b5e30a1-7a86-47bd-b514-be1adeaa07a1\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 10:16:12','2026-01-23 10:16:52','2026-01-23 10:16:52',1,'4b6ed06c-49b5-4410-93b2-ea6b20f8212b','e7ae8c2b-16eb-4a7d-ae1d-2b336c442dfa','compute-1.ctlplane.example.com','fd9d9b93-c87f-40e9-9b2d-1e40b9a74a78','/dev/vdc','2026-01-23 10:16:14','2026-01-23 10:16:52','rw','detached','{\"name\": \"volumes/volume-e7ae8c2b-16eb-4a7d-ae1d-2b336c442dfa\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"e7ae8c2b-16eb-4a7d-ae1d-2b336c442dfa\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"4b6ed06c-49b5-4410-93b2-ea6b20f8212b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:6b3426e5528c\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"5e159ac4-110b-464c-8264-d020fcde6246\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-23 09:29:58','2026-01-23 09:30:07','2026-01-23 09:30:07',1,'4d42beb6-235a-4153-a3c8-6aab60d72429','3dc5fcfb-69eb-4c5b-a254-b3c8a59b23ea','compute-2.ctlplane.example.com','872939ff-8eb8-4a0a-a32d-f1268af38264','/dev/vdb','2026-01-23 09:30:02','2026-01-23 09:30:07','rw','detached','{\"name\": \"volumes/volume-3dc5fcfb-69eb-4c5b-a254-b3c8a59b23ea\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"3dc5fcfb-69eb-4c5b-a254-b3c8a59b23ea\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"4d42beb6-235a-4153-a3c8-6aab60d72429\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 10:24:13','2026-01-23 10:25:01','2026-01-23 10:25:01',1,'4db92ede-8dc6-42ee-bc0a-820c8697f507','127a1e1e-4b4f-4404-b522-315ba62689fa','compute-2.ctlplane.example.com','bd0fc955-63ff-41a4-b31b-369c2b584544','/dev/vdb','2026-01-23 10:24:14','2026-01-23 10:25:01','rw','detached','{\"name\": \"volumes/volume-127a1e1e-4b4f-4404-b522-315ba62689fa\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"127a1e1e-4b4f-4404-b522-315ba62689fa\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"4db92ede-8dc6-42ee-bc0a-820c8697f507\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 10:16:47','2026-01-23 10:17:45','2026-01-23 10:17:45',1,'4e2d473b-0246-4a58-9f58-5de378436645','aee959cd-89dc-45e7-ba7b-58dc8568e292','compute-2.ctlplane.example.com','59fbb9c5-c8a9-4238-be6a-07598275a158','/dev/vda','2026-01-23 10:17:05','2026-01-23 10:17:45','rw','detached','{\"name\": \"volumes/volume-aee959cd-89dc-45e7-ba7b-58dc8568e292\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"aee959cd-89dc-45e7-ba7b-58dc8568e292\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"4e2d473b-0246-4a58-9f58-5de378436645\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 10:39:30','2026-01-23 10:39:38','2026-01-23 10:39:38',1,'531ec09e-2927-4dbd-8de1-6fdc7aac4fcc','6fd77dfa-97fc-4041-84a2-c8fe6e49c5d5','compute-2.ctlplane.example.com','d0cea430-15ec-471d-963b-41fd4fa4777c','/dev/vdb','2026-01-23 10:39:31','2026-01-23 10:39:38','rw','detached','{\"name\": \"volumes/volume-6fd77dfa-97fc-4041-84a2-c8fe6e49c5d5\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"6fd77dfa-97fc-4041-84a2-c8fe6e49c5d5\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"531ec09e-2927-4dbd-8de1-6fdc7aac4fcc\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 10:04:03','2026-01-23 10:04:13','2026-01-23 10:04:13',1,'5460fba2-e37d-4d8c-838a-3cf4add6ce02','bcbb40c5-2718-4ca8-8327-19725d9ddd5d','compute-0.ctlplane.example.com','40ae15fe-e324-4fc4-b6ee-df051fcbea8f','/dev/vdb','2026-01-23 10:04:05','2026-01-23 10:04:13','rw','detached','{\"name\": \"volumes/volume-bcbb40c5-2718-4ca8-8327-19725d9ddd5d\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"bcbb40c5-2718-4ca8-8327-19725d9ddd5d\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"5460fba2-e37d-4d8c-838a-3cf4add6ce02\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:c6473626b456\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"ebc95db9-b389-4cf6-b3a5-7ae0afc322d2\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 09:57:51','2026-01-23 10:00:28','2026-01-23 10:00:28',1,'59e30594-12a6-4ea0-9446-9cd96f4d4dd0','4c100131-c84f-4546-b7f0-7e22ffc499a0','compute-1.ctlplane.example.com','6d680830-de0e-445d-9d57-b3b0724cb5a8','/dev/vdc','2026-01-23 09:58:08','2026-01-23 10:00:28','rw','detached','{\"name\": \"volumes/volume-4c100131-c84f-4546-b7f0-7e22ffc499a0\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"4c100131-c84f-4546-b7f0-7e22ffc499a0\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"59e30594-12a6-4ea0-9446-9cd96f4d4dd0\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:6b3426e5528c\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"5e159ac4-110b-464c-8264-d020fcde6246\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-23 10:17:43','2026-01-23 10:18:39','2026-01-23 10:18:39',1,'5e83a544-6ca3-4c1e-beb8-65d5969306e7','aee959cd-89dc-45e7-ba7b-58dc8568e292','compute-2.ctlplane.example.com','59fbb9c5-c8a9-4238-be6a-07598275a158','/dev/vda','2026-01-23 10:17:57','2026-01-23 10:18:39','rw','detached','{\"name\": \"volumes/volume-aee959cd-89dc-45e7-ba7b-58dc8568e292\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"aee959cd-89dc-45e7-ba7b-58dc8568e292\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"5e83a544-6ca3-4c1e-beb8-65d5969306e7\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 10:45:17','2026-01-23 10:45:58','2026-01-23 10:45:58',1,'60c75f9e-eb69-4216-83bb-d164765eef16','e5e1339d-ae3b-4104-9429-034d0ceea4fd','compute-0.ctlplane.example.com','b0f3c685-d13a-41b8-925b-67b144c237b8','/dev/vda','2026-01-23 10:45:24','2026-01-23 10:45:58','rw','detached','{\"name\": \"volumes/volume-e5e1339d-ae3b-4104-9429-034d0ceea4fd\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"e5e1339d-ae3b-4104-9429-034d0ceea4fd\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"60c75f9e-eb69-4216-83bb-d164765eef16\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:c6473626b456\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"ebc95db9-b389-4cf6-b3a5-7ae0afc322d2\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 10:26:47','2026-01-23 10:26:54','2026-01-23 10:26:54',1,'612a1775-2755-4c28-b014-c749b2705287','bc9f2ac6-a45e-44ec-92bc-8e8e9f030cb1','compute-2.ctlplane.example.com','12b37be9-93a2-4e10-9056-68a743ed2673','/dev/vdc','2026-01-23 10:26:48','2026-01-23 10:26:54','rw','detached','{\"name\": \"volumes/volume-bc9f2ac6-a45e-44ec-92bc-8e8e9f030cb1\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"bc9f2ac6-a45e-44ec-92bc-8e8e9f030cb1\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"612a1775-2755-4c28-b014-c749b2705287\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-23 10:17:15','2026-01-23 10:17:48','2026-01-23 10:17:48',1,'617bc764-5592-42ac-9132-d7451ff7bd3b','23e1c9da-11aa-46ec-90eb-aa0b6ee150dc','compute-0.ctlplane.example.com','ccd07f55-529f-4dbb-989c-2cdbdd393a0b','/dev/vdb','2026-01-23 10:17:17','2026-01-23 10:17:48','rw','detached','{\"name\": \"volumes/volume-23e1c9da-11aa-46ec-90eb-aa0b6ee150dc\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"23e1c9da-11aa-46ec-90eb-aa0b6ee150dc\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"617bc764-5592-42ac-9132-d7451ff7bd3b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:c6473626b456\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"ebc95db9-b389-4cf6-b3a5-7ae0afc322d2\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 10:11:35','2026-01-23 10:11:52','2026-01-23 10:11:52',1,'639ff627-f484-487d-bfbf-d7cfb9061a31','649f8ce8-126a-4838-b42c-047bd1f41e67','compute-2.ctlplane.example.com','a4f2647f-5c8b-4e7d-bbf2-eb149db4db2c','/dev/vdb','2026-01-23 10:11:36','2026-01-23 10:11:52','rw','detached','{\"name\": \"volumes/volume-649f8ce8-126a-4838-b42c-047bd1f41e67\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"649f8ce8-126a-4838-b42c-047bd1f41e67\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"639ff627-f484-487d-bfbf-d7cfb9061a31\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 09:42:27','2026-01-23 09:42:32','2026-01-23 09:42:32',1,'65001924-ce89-4e0f-8d35-4ab6801db4ec','5bcdefce-ec76-4a6c-b618-d67828743aff','compute-2.ctlplane.example.com','a8411989-0134-41c7-85e7-36173b393043','/dev/sdc','2026-01-23 09:42:28','2026-01-23 09:42:32','rw','detached','{\"name\": \"volumes/volume-5bcdefce-ec76-4a6c-b618-d67828743aff\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"5bcdefce-ec76-4a6c-b618-d67828743aff\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"65001924-ce89-4e0f-8d35-4ab6801db4ec\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/sdc\"}'),('2026-01-23 10:12:08','2026-01-23 10:12:25','2026-01-23 10:12:25',1,'68e12a79-6f68-4607-ab84-fa22faab90a9','649f8ce8-126a-4838-b42c-047bd1f41e67','compute-2.ctlplane.example.com','a4f2647f-5c8b-4e7d-bbf2-eb149db4db2c','/dev/vdb','2026-01-23 10:12:15','2026-01-23 10:12:25','rw','detached','{\"name\": \"volumes/volume-649f8ce8-126a-4838-b42c-047bd1f41e67\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"649f8ce8-126a-4838-b42c-047bd1f41e67\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"68e12a79-6f68-4607-ab84-fa22faab90a9\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 10:04:12','2026-01-23 10:04:28','2026-01-23 10:04:28',1,'71bbc3e7-40bf-4373-9460-ce9cc1fb072a','bcbb40c5-2718-4ca8-8327-19725d9ddd5d','compute-0.ctlplane.example.com','40ae15fe-e324-4fc4-b6ee-df051fcbea8f','/dev/vdb','2026-01-23 10:04:16','2026-01-23 10:04:28','rw','detached','{\"name\": \"volumes/volume-bcbb40c5-2718-4ca8-8327-19725d9ddd5d\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"bcbb40c5-2718-4ca8-8327-19725d9ddd5d\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"71bbc3e7-40bf-4373-9460-ce9cc1fb072a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:c6473626b456\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"ebc95db9-b389-4cf6-b3a5-7ae0afc322d2\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 10:11:52','2026-01-23 10:12:09','2026-01-23 10:12:09',1,'78bf6722-1b89-4063-a036-3b0e1fd729ac','649f8ce8-126a-4838-b42c-047bd1f41e67','compute-0.ctlplane.example.com','a4f2647f-5c8b-4e7d-bbf2-eb149db4db2c','/dev/vdb','2026-01-23 10:11:59','2026-01-23 10:12:09','rw','detached','{\"name\": \"volumes/volume-649f8ce8-126a-4838-b42c-047bd1f41e67\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"649f8ce8-126a-4838-b42c-047bd1f41e67\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"78bf6722-1b89-4063-a036-3b0e1fd729ac\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:c6473626b456\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"ebc95db9-b389-4cf6-b3a5-7ae0afc322d2\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 10:24:25','2026-01-23 10:28:44','2026-01-23 10:28:44',1,'791794f9-87d4-4aa0-a262-f6adf41498a4','890430a6-e7b9-4647-b7ef-49be14bad5fe','compute-0.ctlplane.example.com','ae979986-7780-443a-afbc-6b4be8f71da1','/dev/vda','2026-01-23 10:24:27','2026-01-23 10:28:44','rw','detached','{\"name\": \"volumes/volume-890430a6-e7b9-4647-b7ef-49be14bad5fe\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"890430a6-e7b9-4647-b7ef-49be14bad5fe\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"791794f9-87d4-4aa0-a262-f6adf41498a4\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:c6473626b456\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"ebc95db9-b389-4cf6-b3a5-7ae0afc322d2\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 10:14:42','2026-01-23 10:18:34','2026-01-23 10:18:34',1,'7b54bc93-9572-4745-82ec-cfb9dba6b408','bdfc6219-716c-481a-916d-78de375d66c3','compute-2.ctlplane.example.com','633b85ea-a47c-4be0-b06d-388aa421728b','/dev/vda','2026-01-23 10:14:47','2026-01-23 10:18:34','rw','detached','{\"name\": \"volumes/volume-bdfc6219-716c-481a-916d-78de375d66c3\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"bdfc6219-716c-481a-916d-78de375d66c3\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"7b54bc93-9572-4745-82ec-cfb9dba6b408\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 10:26:42','2026-01-23 10:26:51','2026-01-23 10:26:51',1,'7bf13d07-b8cd-4849-8619-87436191ce4e','fd29228e-f2b9-4bc3-af15-5ec512d8169b','compute-2.ctlplane.example.com','12b37be9-93a2-4e10-9056-68a743ed2673','/dev/vdb','2026-01-23 10:26:43','2026-01-23 10:26:51','rw','detached','{\"name\": \"volumes/volume-fd29228e-f2b9-4bc3-af15-5ec512d8169b\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"fd29228e-f2b9-4bc3-af15-5ec512d8169b\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"7bf13d07-b8cd-4849-8619-87436191ce4e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 09:57:51','2026-01-23 10:00:27','2026-01-23 10:00:27',1,'7cf3deb7-daa6-4dca-9273-14482997f86b','3fa8e844-6545-43af-a18d-ac7dfc7d2071','compute-1.ctlplane.example.com','6d680830-de0e-445d-9d57-b3b0724cb5a8','/dev/vdb','2026-01-23 09:58:05','2026-01-23 10:00:27','rw','detached','{\"name\": \"volumes/volume-3fa8e844-6545-43af-a18d-ac7dfc7d2071\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"3fa8e844-6545-43af-a18d-ac7dfc7d2071\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"7cf3deb7-daa6-4dca-9273-14482997f86b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:6b3426e5528c\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"5e159ac4-110b-464c-8264-d020fcde6246\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 10:40:42','2026-01-23 10:41:06','2026-01-23 10:41:06',1,'7fcd26fc-1269-44d4-9f00-2b865b7fa8ba','98d92b88-169d-4578-860b-b4af33fc6e51','compute-2.ctlplane.example.com','6b2d76e8-0aab-4760-b64e-0097520255ce','/dev/vda','2026-01-23 10:40:45','2026-01-23 10:41:06','rw','detached','{\"name\": \"volumes/volume-98d92b88-169d-4578-860b-b4af33fc6e51\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"98d92b88-169d-4578-860b-b4af33fc6e51\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": true, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"7fcd26fc-1269-44d4-9f00-2b865b7fa8ba\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 10:39:23','2026-01-23 10:39:34','2026-01-23 10:39:34',1,'86b46c56-c46e-4e27-91fe-49fe600d4821','6fd77dfa-97fc-4041-84a2-c8fe6e49c5d5','compute-1.ctlplane.example.com','0a916952-341a-4caf-bf6f-6abe504830f9','/dev/vdb','2026-01-23 10:39:27','2026-01-23 10:39:34','rw','detached','{\"name\": \"volumes/volume-6fd77dfa-97fc-4041-84a2-c8fe6e49c5d5\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"6fd77dfa-97fc-4041-84a2-c8fe6e49c5d5\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"86b46c56-c46e-4e27-91fe-49fe600d4821\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:6b3426e5528c\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"5e159ac4-110b-464c-8264-d020fcde6246\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 10:43:04','2026-01-23 10:43:43','2026-01-23 10:43:43',1,'89187d7b-afed-4e1f-b3ab-486c0472db38','d8ca748e-6bb8-4ae2-9729-d2be77ce520f','compute-0.ctlplane.example.com','9ae9a99b-039d-46f8-a3ca-42ee68bae3e8','/dev/vda','2026-01-23 10:43:19','2026-01-23 10:43:43','rw','detached','{\"name\": \"volumes/volume-d8ca748e-6bb8-4ae2-9729-d2be77ce520f\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"d8ca748e-6bb8-4ae2-9729-d2be77ce520f\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"89187d7b-afed-4e1f-b3ab-486c0472db38\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:c6473626b456\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"ebc95db9-b389-4cf6-b3a5-7ae0afc322d2\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 10:37:04','2026-01-23 10:37:08','2026-01-23 10:37:08',1,'8dda7496-20b2-4bc6-8d18-61807f6209d4','8bbabf32-b7e7-4da1-b195-dac1294e522d','compute-0.ctlplane.example.com','9f8603a4-2f28-496b-91b4-e30cc94657b4','/dev/vdb','2026-01-23 10:37:05','2026-01-23 10:37:08','rw','detached','{\"name\": \"volumes/volume-8bbabf32-b7e7-4da1-b195-dac1294e522d\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"8bbabf32-b7e7-4da1-b195-dac1294e522d\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"8dda7496-20b2-4bc6-8d18-61807f6209d4\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:c6473626b456\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"ebc95db9-b389-4cf6-b3a5-7ae0afc322d2\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 10:15:09','2026-01-23 10:15:53','2026-01-23 10:15:53',1,'90f1549a-989c-45d3-941a-597a1c413490','eb20e12a-5d9c-4034-8e50-a0b613fd5f3d','compute-2.ctlplane.example.com','633b85ea-a47c-4be0-b06d-388aa421728b','/dev/vdc','2026-01-23 10:15:12','2026-01-23 10:15:53','rw','detached','{\"name\": \"volumes/volume-eb20e12a-5d9c-4034-8e50-a0b613fd5f3d\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"eb20e12a-5d9c-4034-8e50-a0b613fd5f3d\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"90f1549a-989c-45d3-941a-597a1c413490\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-23 10:16:08','2026-01-23 10:16:46','2026-01-23 10:16:46',1,'95eb8608-e2ba-4ce0-9d64-d3d14c8f5c8d','3d24b1fa-0276-448e-a73a-1cba237d818c','compute-1.ctlplane.example.com','fd9d9b93-c87f-40e9-9b2d-1e40b9a74a78','/dev/vdb','2026-01-23 10:16:09','2026-01-23 10:16:46','rw','detached','{\"name\": \"volumes/volume-3d24b1fa-0276-448e-a73a-1cba237d818c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"3d24b1fa-0276-448e-a73a-1cba237d818c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"95eb8608-e2ba-4ce0-9d64-d3d14c8f5c8d\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:6b3426e5528c\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"5e159ac4-110b-464c-8264-d020fcde6246\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 10:48:25','2026-01-23 10:48:27','2026-01-23 10:48:27',1,'9aa9dc7f-045c-4179-97d6-64f0dae80081','4053b4fd-d368-4ca6-9fc3-047b541c90d6',NULL,'1f16f1e6-2ac3-4547-84bf-103e4be39e3a',NULL,NULL,'2026-01-23 10:48:27','null','detached','{}',NULL),('2026-01-23 10:09:57','2026-01-23 10:10:01','2026-01-23 10:10:01',1,'9b24b8a4-e157-403f-89a0-2131fd1bc2bb','b0abb614-0c00-40fa-9977-96c7edfc0c3c','compute-0.ctlplane.example.com','d843365b-283f-47da-ba45-e68489a5fbdd','/dev/vdb','2026-01-23 10:09:58','2026-01-23 10:10:01','rw','detached','{\"name\": \"volumes/volume-b0abb614-0c00-40fa-9977-96c7edfc0c3c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"b0abb614-0c00-40fa-9977-96c7edfc0c3c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"9b24b8a4-e157-403f-89a0-2131fd1bc2bb\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:c6473626b456\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"ebc95db9-b389-4cf6-b3a5-7ae0afc322d2\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 11:15:37','2026-01-23 11:16:49','2026-01-23 11:16:49',1,'b5f73267-3591-4cf8-9f14-9564a497d0cd','525f185e-d0f4-4a0b-bd48-9219445747c5','compute-1.ctlplane.example.com','ed71c532-711c-49b9-b0d5-eaf409f0bc76','/dev/vda','2026-01-23 11:15:45','2026-01-23 11:16:49','rw','detached','{\"name\": \"volumes/volume-525f185e-d0f4-4a0b-bd48-9219445747c5\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"525f185e-d0f4-4a0b-bd48-9219445747c5\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b5f73267-3591-4cf8-9f14-9564a497d0cd\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:6b3426e5528c\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"5e159ac4-110b-464c-8264-d020fcde6246\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 10:23:44','2026-01-23 10:25:06','2026-01-23 10:25:06',1,'b92e1ba0-b3c1-47fa-971f-c2b351690c32','006fb8d9-c6d3-441f-993c-5b105d3e9681','compute-1.ctlplane.example.com','c5c48cf7-dc8c-42fe-bc7e-4a85b6fc2f65','/dev/vdb','2026-01-23 10:23:46','2026-01-23 10:25:06','rw','detached','{\"name\": \"volumes/volume-006fb8d9-c6d3-441f-993c-5b105d3e9681\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"006fb8d9-c6d3-441f-993c-5b105d3e9681\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b92e1ba0-b3c1-47fa-971f-c2b351690c32\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:6b3426e5528c\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"5e159ac4-110b-464c-8264-d020fcde6246\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 10:40:27','2026-01-23 10:40:48','2026-01-23 10:40:48',1,'b975d685-7101-4c02-9d08-f95e23de2674','4393c992-1666-40a0-ab11-4cc66bdcd721','compute-0.ctlplane.example.com','0888913c-71a6-45fe-97bf-9dddd2b7b521','/dev/vdb','2026-01-23 10:40:28','2026-01-23 10:40:48','rw','detached','{\"name\": \"volumes/volume-4393c992-1666-40a0-ab11-4cc66bdcd721\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"4393c992-1666-40a0-ab11-4cc66bdcd721\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b975d685-7101-4c02-9d08-f95e23de2674\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:c6473626b456\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"ebc95db9-b389-4cf6-b3a5-7ae0afc322d2\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 10:40:31','2026-01-23 10:41:49','2026-01-23 10:41:49',1,'bb54dc99-5583-479d-bf3a-45ee4e2d4c5a','4393c992-1666-40a0-ab11-4cc66bdcd721','compute-1.ctlplane.example.com','f34f1af9-6c51-42ec-97f8-fb5bb146aeb6','/dev/vdb','2026-01-23 10:40:33','2026-01-23 10:41:49','rw','detached','{\"name\": \"volumes/volume-4393c992-1666-40a0-ab11-4cc66bdcd721\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"4393c992-1666-40a0-ab11-4cc66bdcd721\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"bb54dc99-5583-479d-bf3a-45ee4e2d4c5a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:6b3426e5528c\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"5e159ac4-110b-464c-8264-d020fcde6246\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 09:43:18','2026-01-23 09:43:25','2026-01-23 09:43:25',1,'bd199762-e898-4cb0-8325-dc78f5aba525','99bccbe9-de42-409d-aa8f-e509f6080e7b','compute-2.ctlplane.example.com','4ef48fbd-b990-487c-94a4-0149ee9204c9','/dev/vdb','2026-01-23 09:43:19','2026-01-23 09:43:25','rw','detached','{\"name\": \"volumes/volume-99bccbe9-de42-409d-aa8f-e509f6080e7b\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"99bccbe9-de42-409d-aa8f-e509f6080e7b\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"bd199762-e898-4cb0-8325-dc78f5aba525\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 10:15:02','2026-01-23 10:16:08','2026-01-23 10:16:08',1,'be7f16e3-d7f9-4185-88d3-6fc36f851537','c633bb7d-c04b-4d7b-a574-1649ca824520','compute-1.ctlplane.example.com','cca30801-d289-4e95-89b2-afcc3d0199a7','/dev/vdb','2026-01-23 10:15:07','2026-01-23 10:16:08','rw','detached','{\"name\": \"volumes/volume-c633bb7d-c04b-4d7b-a574-1649ca824520\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"c633bb7d-c04b-4d7b-a574-1649ca824520\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"be7f16e3-d7f9-4185-88d3-6fc36f851537\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:6b3426e5528c\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"5e159ac4-110b-464c-8264-d020fcde6246\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 09:53:47','2026-01-23 09:55:59','2026-01-23 09:55:59',1,'c1e3e9d5-4d6c-4f1c-8c02-ec0d787ca865','98b96f14-bdc2-414c-aaaf-7d1dfaafbfd2','compute-1.ctlplane.example.com','c4100b68-be14-4cd7-8243-2c9a793caa5f','/dev/vda','2026-01-23 09:54:00','2026-01-23 09:55:59','rw','detached','{\"name\": \"volumes/volume-98b96f14-bdc2-414c-aaaf-7d1dfaafbfd2\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"98b96f14-bdc2-414c-aaaf-7d1dfaafbfd2\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"c1e3e9d5-4d6c-4f1c-8c02-ec0d787ca865\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:6b3426e5528c\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"5e159ac4-110b-464c-8264-d020fcde6246\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 09:57:51','2026-01-23 10:00:26','2026-01-23 10:00:26',1,'c67fc8c9-4438-4662-915a-db444ba9c2e4','d7d5138e-60ed-44f2-b4e5-1e53de5cf442','compute-1.ctlplane.example.com','6d680830-de0e-445d-9d57-b3b0724cb5a8','/dev/vda','2026-01-23 09:58:02','2026-01-23 10:00:26','rw','detached','{\"name\": \"volumes/volume-d7d5138e-60ed-44f2-b4e5-1e53de5cf442\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"d7d5138e-60ed-44f2-b4e5-1e53de5cf442\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"c67fc8c9-4438-4662-915a-db444ba9c2e4\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:6b3426e5528c\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"5e159ac4-110b-464c-8264-d020fcde6246\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 10:05:29','2026-01-23 10:06:12','2026-01-23 10:06:12',1,'c9f69558-2b13-4139-a49d-3adea9b4e794','1337690c-8061-4b7e-bb70-8cbfeecc77ac','compute-0.ctlplane.example.com','483afeac-561b-48ff-89d6-d02d1b615fc9','/dev/vda','2026-01-23 10:05:33','2026-01-23 10:06:12','rw','detached','{\"name\": \"volumes/volume-1337690c-8061-4b7e-bb70-8cbfeecc77ac\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"1337690c-8061-4b7e-bb70-8cbfeecc77ac\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"c9f69558-2b13-4139-a49d-3adea9b4e794\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:c6473626b456\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"ebc95db9-b389-4cf6-b3a5-7ae0afc322d2\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 10:38:18','2026-01-23 10:44:27','2026-01-23 10:44:27',1,'cacaf0b8-fb4a-4f74-8db8-fa08eb2c8eae','707d7a47-dd85-4006-890f-724df1ffbdae','compute-2.ctlplane.example.com','307f203d-cfc0-45a9-a0cd-3acee0ef7133','/dev/vda','2026-01-23 10:38:21','2026-01-23 10:44:27','rw','detached','{\"name\": \"volumes/volume-707d7a47-dd85-4006-890f-724df1ffbdae\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"707d7a47-dd85-4006-890f-724df1ffbdae\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"cacaf0b8-fb4a-4f74-8db8-fa08eb2c8eae\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 10:46:56','2026-01-23 10:47:53','2026-01-23 10:47:53',1,'d54e8e76-7777-400a-a968-2fa448f2339a','5e6f1d6f-902b-4bb5-b9af-c82516af3452','compute-1.ctlplane.example.com','5fde5da5-03bb-4c07-bd48-b634468000ac','/dev/vda','2026-01-23 10:47:00','2026-01-23 10:47:53','rw','detached','{\"name\": \"volumes/volume-5e6f1d6f-902b-4bb5-b9af-c82516af3452\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"5e6f1d6f-902b-4bb5-b9af-c82516af3452\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"d54e8e76-7777-400a-a968-2fa448f2339a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:6b3426e5528c\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"5e159ac4-110b-464c-8264-d020fcde6246\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 09:53:47','2026-01-23 09:56:00','2026-01-23 09:56:00',1,'dc578d3b-e60d-48b6-bc26-fe33ec917aaf','0c57b335-8fff-4dae-ab58-3a6c060df2a2','compute-1.ctlplane.example.com','c4100b68-be14-4cd7-8243-2c9a793caa5f','/dev/vdc','2026-01-23 09:54:07','2026-01-23 09:56:00','rw','detached','{\"name\": \"volumes/volume-0c57b335-8fff-4dae-ab58-3a6c060df2a2\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"0c57b335-8fff-4dae-ab58-3a6c060df2a2\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"dc578d3b-e60d-48b6-bc26-fe33ec917aaf\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:6b3426e5528c\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"5e159ac4-110b-464c-8264-d020fcde6246\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-23 10:42:32','2026-01-23 10:44:41','2026-01-23 10:44:41',1,'dc799e24-6978-49e0-b450-6019c423c769','d77d9325-542a-4716-94b2-e66e8ceab532','compute-1.ctlplane.example.com','b23e0eb3-82ec-4c33-aedd-b815e9513866','/dev/vda','2026-01-23 10:42:37','2026-01-23 10:44:41','rw','detached','{\"name\": \"volumes/volume-d77d9325-542a-4716-94b2-e66e8ceab532\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"d77d9325-542a-4716-94b2-e66e8ceab532\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"dc799e24-6978-49e0-b450-6019c423c769\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:6b3426e5528c\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"5e159ac4-110b-464c-8264-d020fcde6246\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 10:27:00','2026-01-23 10:28:28','2026-01-23 10:28:28',1,'e4c73434-a994-4a1d-92e4-1fe78b682693','03c13a28-044c-43b3-8aa2-67640721a086','compute-1.ctlplane.example.com','87859c15-e250-4a5d-aab0-8bc67aae1bc3','/dev/vda','2026-01-23 10:27:03','2026-01-23 10:28:28','rw','detached','{\"name\": \"volumes/volume-03c13a28-044c-43b3-8aa2-67640721a086\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"03c13a28-044c-43b3-8aa2-67640721a086\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e4c73434-a994-4a1d-92e4-1fe78b682693\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:6b3426e5528c\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"5e159ac4-110b-464c-8264-d020fcde6246\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 10:41:49','2026-01-23 10:42:03','2026-01-23 10:42:03',1,'e4fd0a83-1264-4516-b2ab-863aaa086214','53917a40-f345-4f87-a3c1-5297194341d6','compute-2.ctlplane.example.com','875a53a5-020f-4a4e-a0cf-bcfd254ba895','/dev/vda','2026-01-23 10:41:50','2026-01-23 10:42:03','rw','detached','{\"name\": \"volumes/volume-53917a40-f345-4f87-a3c1-5297194341d6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"53917a40-f345-4f87-a3c1-5297194341d6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e4fd0a83-1264-4516-b2ab-863aaa086214\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 10:38:51','2026-01-23 10:39:30','2026-01-23 10:39:30',1,'e578a84a-b1f5-4de5-81cd-7fbcde412aeb','abf07740-6e5f-44bf-b631-41bec916b9fe','compute-0.ctlplane.example.com','c664bd16-8380-4052-abce-702c782ec7b0','/dev/vda','2026-01-23 10:38:54','2026-01-23 10:39:30','rw','detached','{\"name\": \"volumes/volume-abf07740-6e5f-44bf-b631-41bec916b9fe\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"abf07740-6e5f-44bf-b631-41bec916b9fe\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e578a84a-b1f5-4de5-81cd-7fbcde412aeb\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:c6473626b456\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"ebc95db9-b389-4cf6-b3a5-7ae0afc322d2\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 09:53:47','2026-01-23 09:56:00','2026-01-23 09:56:00',1,'e5a6dd94-0880-4555-a334-033e3156a797','a5f913c6-cfb1-486f-bcd3-8b5237feb9b1','compute-1.ctlplane.example.com','c4100b68-be14-4cd7-8243-2c9a793caa5f','/dev/vdb','2026-01-23 09:54:03','2026-01-23 09:56:00','rw','detached','{\"name\": \"volumes/volume-a5f913c6-cfb1-486f-bcd3-8b5237feb9b1\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"a5f913c6-cfb1-486f-bcd3-8b5237feb9b1\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e5a6dd94-0880-4555-a334-033e3156a797\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:6b3426e5528c\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"5e159ac4-110b-464c-8264-d020fcde6246\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 09:32:55','2026-01-23 09:33:19','2026-01-23 09:33:19',1,'e76d53d7-92f8-4350-b59b-a5908f1e2420','2c9770c1-d351-43fa-b18d-aaf9291801fe','compute-1.ctlplane.example.com','54a1ad4e-6fc9-42dc-aa4c-99d3f1297520','/dev/vda','2026-01-23 09:32:56','2026-01-23 09:33:19','null','detached','{\"name\": \"volumes/volume-2c9770c1-d351-43fa-b18d-aaf9291801fe\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"2c9770c1-d351-43fa-b18d-aaf9291801fe\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e76d53d7-92f8-4350-b59b-a5908f1e2420\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:6b3426e5528c\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"5e159ac4-110b-464c-8264-d020fcde6246\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2026-01-23 10:14:50','2026-01-23 10:18:20','2026-01-23 10:18:20',1,'ee693baf-e89b-42e6-a9cb-a114c373e1a2','0bf60c43-104e-4a31-b83b-9fcea380005d','compute-0.ctlplane.example.com','ccd07f55-529f-4dbb-989c-2cdbdd393a0b','/dev/vda','2026-01-23 10:14:55','2026-01-23 10:18:20','rw','detached','{\"name\": \"volumes/volume-0bf60c43-104e-4a31-b83b-9fcea380005d\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"0bf60c43-104e-4a31-b83b-9fcea380005d\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"ee693baf-e89b-42e6-a9cb-a114c373e1a2\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:c6473626b456\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"ebc95db9-b389-4cf6-b3a5-7ae0afc322d2\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 10:43:40','2026-01-23 10:44:27','2026-01-23 10:44:27',1,'efe8287a-fffc-4b9f-aac5-bcbdcffec9ef','837a8189-567b-4aae-b83b-e7aa7a4ff9a7','compute-1.ctlplane.example.com','c23f23ba-4d94-44c7-9460-bcce38d2bd70','/dev/vda','2026-01-23 10:43:42','2026-01-23 10:44:27','rw','detached','{\"name\": \"volumes/volume-837a8189-567b-4aae-b83b-e7aa7a4ff9a7\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"837a8189-567b-4aae-b83b-e7aa7a4ff9a7\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"efe8287a-fffc-4b9f-aac5-bcbdcffec9ef\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:6b3426e5528c\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"5e159ac4-110b-464c-8264-d020fcde6246\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-23 10:35:40','2026-01-23 10:35:47','2026-01-23 10:35:47',1,'f57c1c19-8996-4f32-9cf2-f3df971a579b','cc391f04-6d6d-4c9d-866a-f0d2a56a62fb','compute-2.ctlplane.example.com','6673e062-5d99-4c31-a3e0-673f55438d6e','/dev/vdb','2026-01-23 10:35:41','2026-01-23 10:35:47','rw','detached','{\"name\": \"volumes/volume-cc391f04-6d6d-4c9d-866a-f0d2a56a62fb\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"cc391f04-6d6d-4c9d-866a-f0d2a56a62fb\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"f57c1c19-8996-4f32-9cf2-f3df971a579b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e6da4ae895b4\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"3e200bf7-7634-42a0-8184-2372f58672f7\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-23 09:48:57','2026-01-23 09:49:03','2026-01-23 09:49:03',1,'ff522077-4963-4ea6-b2b7-f4bf6bc6f3ba','2a5f9051-d3ab-46f9-b4f7-644aa73bccd4','compute-0.ctlplane.example.com','9fd1f64a-4b5b-4638-9411-04027230851c','/dev/vdb','2026-01-23 09:48:58','2026-01-23 09:49:03','rw','detached','{\"name\": \"volumes/volume-2a5f9051-d3ab-46f9-b4f7-644aa73bccd4\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"e1533653-0a5a-584c-b34b-8689f0d32e77\", \"volume_id\": \"2a5f9051-d3ab-46f9-b4f7-644aa73bccd4\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"ff522077-4963-4ea6-b2b7-f4bf6bc6f3ba\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:c6473626b456\", \"do_local_attach\": false, \"nvme_hostid\": \"5350774e-8b5e-4dba-80a9-92d405981c1d\", \"system uuid\": \"ebc95db9-b389-4cf6-b3a5-7ae0afc322d2\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:5350774e-8b5e-4dba-80a9-92d405981c1d\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}');
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=267 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
INSERT INTO `volume_glance_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `snapshot_id`, `key`, `value`) VALUES ('2026-01-23 09:31:47',NULL,'2026-01-23 09:33:19',1,1,'2c9770c1-d351-43fa-b18d-aaf9291801fe',NULL,'signature_verified','False'),('2026-01-23 09:31:55',NULL,'2026-01-23 09:33:19',1,2,'2c9770c1-d351-43fa-b18d-aaf9291801fe',NULL,'hw_rng_model','virtio'),('2026-01-23 09:31:55',NULL,'2026-01-23 09:33:19',1,3,'2c9770c1-d351-43fa-b18d-aaf9291801fe',NULL,'image_id','84c0ef19-7f67-4bd3-95d8-507c3e0942ed'),('2026-01-23 09:31:55',NULL,'2026-01-23 09:33:19',1,4,'2c9770c1-d351-43fa-b18d-aaf9291801fe',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-23 09:31:55',NULL,'2026-01-23 09:33:19',1,5,'2c9770c1-d351-43fa-b18d-aaf9291801fe',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 09:31:55',NULL,'2026-01-23 09:33:19',1,6,'2c9770c1-d351-43fa-b18d-aaf9291801fe',NULL,'container_format','bare'),('2026-01-23 09:31:55',NULL,'2026-01-23 09:33:19',1,7,'2c9770c1-d351-43fa-b18d-aaf9291801fe',NULL,'disk_format','qcow2'),('2026-01-23 09:31:55',NULL,'2026-01-23 09:33:19',1,8,'2c9770c1-d351-43fa-b18d-aaf9291801fe',NULL,'min_disk','0'),('2026-01-23 09:31:55',NULL,'2026-01-23 09:33:19',1,9,'2c9770c1-d351-43fa-b18d-aaf9291801fe',NULL,'min_ram','0'),('2026-01-23 09:31:55',NULL,'2026-01-23 09:33:19',1,10,'2c9770c1-d351-43fa-b18d-aaf9291801fe',NULL,'size','21430272'),('2026-01-23 09:37:03',NULL,'2026-01-23 09:38:25',1,11,'b06791ec-66fd-4114-8448-7ea0b7f88f25',NULL,'signature_verified','False'),('2026-01-23 09:37:09',NULL,'2026-01-23 09:38:25',1,12,'b06791ec-66fd-4114-8448-7ea0b7f88f25',NULL,'hw_rng_model','virtio'),('2026-01-23 09:37:09',NULL,'2026-01-23 09:38:25',1,13,'b06791ec-66fd-4114-8448-7ea0b7f88f25',NULL,'image_id','84c0ef19-7f67-4bd3-95d8-507c3e0942ed'),('2026-01-23 09:37:09',NULL,'2026-01-23 09:38:25',1,14,'b06791ec-66fd-4114-8448-7ea0b7f88f25',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-23 09:37:09',NULL,'2026-01-23 09:38:25',1,15,'b06791ec-66fd-4114-8448-7ea0b7f88f25',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 09:37:09',NULL,'2026-01-23 09:38:25',1,16,'b06791ec-66fd-4114-8448-7ea0b7f88f25',NULL,'container_format','bare'),('2026-01-23 09:37:09',NULL,'2026-01-23 09:38:25',1,17,'b06791ec-66fd-4114-8448-7ea0b7f88f25',NULL,'disk_format','qcow2'),('2026-01-23 09:37:09',NULL,'2026-01-23 09:38:25',1,18,'b06791ec-66fd-4114-8448-7ea0b7f88f25',NULL,'min_disk','0'),('2026-01-23 09:37:09',NULL,'2026-01-23 09:38:25',1,19,'b06791ec-66fd-4114-8448-7ea0b7f88f25',NULL,'min_ram','0'),('2026-01-23 09:37:09',NULL,'2026-01-23 09:38:25',1,20,'b06791ec-66fd-4114-8448-7ea0b7f88f25',NULL,'size','21430272'),('2026-01-23 09:42:33',NULL,'2026-01-23 09:43:37',1,21,'113a804f-8abc-47f6-b4ca-e098579996e7',NULL,'signature_verified','False'),('2026-01-23 09:42:38',NULL,'2026-01-23 09:43:37',1,22,'113a804f-8abc-47f6-b4ca-e098579996e7',NULL,'hw_rng_model','virtio'),('2026-01-23 09:42:38',NULL,'2026-01-23 09:43:37',1,23,'113a804f-8abc-47f6-b4ca-e098579996e7',NULL,'image_id','84c0ef19-7f67-4bd3-95d8-507c3e0942ed'),('2026-01-23 09:42:38',NULL,'2026-01-23 09:43:37',1,24,'113a804f-8abc-47f6-b4ca-e098579996e7',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-23 09:42:38',NULL,'2026-01-23 09:43:37',1,25,'113a804f-8abc-47f6-b4ca-e098579996e7',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 09:42:38',NULL,'2026-01-23 09:43:37',1,26,'113a804f-8abc-47f6-b4ca-e098579996e7',NULL,'container_format','bare'),('2026-01-23 09:42:38',NULL,'2026-01-23 09:43:37',1,27,'113a804f-8abc-47f6-b4ca-e098579996e7',NULL,'disk_format','qcow2'),('2026-01-23 09:42:38',NULL,'2026-01-23 09:43:37',1,28,'113a804f-8abc-47f6-b4ca-e098579996e7',NULL,'min_disk','0'),('2026-01-23 09:42:38',NULL,'2026-01-23 09:43:37',1,29,'113a804f-8abc-47f6-b4ca-e098579996e7',NULL,'min_ram','0'),('2026-01-23 09:42:38',NULL,'2026-01-23 09:43:37',1,30,'113a804f-8abc-47f6-b4ca-e098579996e7',NULL,'size','21430272'),('2026-01-23 09:52:46',NULL,'2026-01-23 09:56:22',1,31,'98b96f14-bdc2-414c-aaaf-7d1dfaafbfd2',NULL,'signature_verified','False'),('2026-01-23 09:52:57',NULL,'2026-01-23 09:56:22',1,32,'98b96f14-bdc2-414c-aaaf-7d1dfaafbfd2',NULL,'hw_rng_model','virtio'),('2026-01-23 09:52:57',NULL,'2026-01-23 09:56:22',1,33,'98b96f14-bdc2-414c-aaaf-7d1dfaafbfd2',NULL,'image_id','84c0ef19-7f67-4bd3-95d8-507c3e0942ed'),('2026-01-23 09:52:57',NULL,'2026-01-23 09:56:22',1,34,'98b96f14-bdc2-414c-aaaf-7d1dfaafbfd2',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-23 09:52:57',NULL,'2026-01-23 09:56:22',1,35,'98b96f14-bdc2-414c-aaaf-7d1dfaafbfd2',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 09:52:57',NULL,'2026-01-23 09:56:22',1,36,'98b96f14-bdc2-414c-aaaf-7d1dfaafbfd2',NULL,'container_format','bare'),('2026-01-23 09:52:57',NULL,'2026-01-23 09:56:22',1,37,'98b96f14-bdc2-414c-aaaf-7d1dfaafbfd2',NULL,'disk_format','qcow2'),('2026-01-23 09:52:57',NULL,'2026-01-23 09:56:22',1,38,'98b96f14-bdc2-414c-aaaf-7d1dfaafbfd2',NULL,'min_disk','0'),('2026-01-23 09:52:57',NULL,'2026-01-23 09:56:22',1,39,'98b96f14-bdc2-414c-aaaf-7d1dfaafbfd2',NULL,'min_ram','0'),('2026-01-23 09:52:57',NULL,'2026-01-23 09:56:22',1,40,'98b96f14-bdc2-414c-aaaf-7d1dfaafbfd2',NULL,'size','21430272'),('2026-01-23 09:56:45',NULL,'2026-01-23 10:01:01',1,41,'d7d5138e-60ed-44f2-b4e5-1e53de5cf442',NULL,'signature_verified','False'),('2026-01-23 09:56:52',NULL,'2026-01-23 10:01:01',1,42,'d7d5138e-60ed-44f2-b4e5-1e53de5cf442',NULL,'hw_rng_model','virtio'),('2026-01-23 09:56:52',NULL,'2026-01-23 10:01:01',1,43,'d7d5138e-60ed-44f2-b4e5-1e53de5cf442',NULL,'image_id','84c0ef19-7f67-4bd3-95d8-507c3e0942ed'),('2026-01-23 09:56:52',NULL,'2026-01-23 10:01:01',1,44,'d7d5138e-60ed-44f2-b4e5-1e53de5cf442',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-23 09:56:52',NULL,'2026-01-23 10:01:01',1,45,'d7d5138e-60ed-44f2-b4e5-1e53de5cf442',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 09:56:52',NULL,'2026-01-23 10:01:01',1,46,'d7d5138e-60ed-44f2-b4e5-1e53de5cf442',NULL,'container_format','bare'),('2026-01-23 09:56:52',NULL,'2026-01-23 10:01:01',1,47,'d7d5138e-60ed-44f2-b4e5-1e53de5cf442',NULL,'disk_format','qcow2'),('2026-01-23 09:56:52',NULL,'2026-01-23 10:01:01',1,48,'d7d5138e-60ed-44f2-b4e5-1e53de5cf442',NULL,'min_disk','0'),('2026-01-23 09:56:52',NULL,'2026-01-23 10:01:01',1,49,'d7d5138e-60ed-44f2-b4e5-1e53de5cf442',NULL,'min_ram','0'),('2026-01-23 09:56:52',NULL,'2026-01-23 10:01:01',1,50,'d7d5138e-60ed-44f2-b4e5-1e53de5cf442',NULL,'size','21430272'),('2026-01-23 10:05:22',NULL,'2026-01-23 10:07:01',1,51,'1337690c-8061-4b7e-bb70-8cbfeecc77ac',NULL,'signature_verified','False'),('2026-01-23 10:05:27',NULL,'2026-01-23 10:07:01',1,52,'1337690c-8061-4b7e-bb70-8cbfeecc77ac',NULL,'hw_rng_model','virtio'),('2026-01-23 10:05:27',NULL,'2026-01-23 10:07:01',1,53,'1337690c-8061-4b7e-bb70-8cbfeecc77ac',NULL,'image_id','84c0ef19-7f67-4bd3-95d8-507c3e0942ed'),('2026-01-23 10:05:27',NULL,'2026-01-23 10:07:01',1,54,'1337690c-8061-4b7e-bb70-8cbfeecc77ac',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-23 10:05:27',NULL,'2026-01-23 10:07:01',1,55,'1337690c-8061-4b7e-bb70-8cbfeecc77ac',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 10:05:27',NULL,'2026-01-23 10:07:01',1,56,'1337690c-8061-4b7e-bb70-8cbfeecc77ac',NULL,'container_format','bare'),('2026-01-23 10:05:27',NULL,'2026-01-23 10:07:01',1,57,'1337690c-8061-4b7e-bb70-8cbfeecc77ac',NULL,'disk_format','qcow2'),('2026-01-23 10:05:27',NULL,'2026-01-23 10:07:01',1,58,'1337690c-8061-4b7e-bb70-8cbfeecc77ac',NULL,'min_disk','0'),('2026-01-23 10:05:27',NULL,'2026-01-23 10:07:01',1,59,'1337690c-8061-4b7e-bb70-8cbfeecc77ac',NULL,'min_ram','0'),('2026-01-23 10:05:27',NULL,'2026-01-23 10:07:01',1,60,'1337690c-8061-4b7e-bb70-8cbfeecc77ac',NULL,'size','21430272'),('2026-01-23 10:14:32',NULL,'2026-01-23 10:18:41',1,61,'bdfc6219-716c-481a-916d-78de375d66c3',NULL,'signature_verified','False'),('2026-01-23 10:14:37',NULL,'2026-01-23 10:18:39',1,62,'3bbb4d6e-08b6-40cf-b719-94bd5e591c16',NULL,'signature_verified','False'),('2026-01-23 10:14:38',NULL,'2026-01-23 10:18:41',1,63,'bdfc6219-716c-481a-916d-78de375d66c3',NULL,'image_id','5e615da5-21b7-41e6-bf0a-0f222139b158'),('2026-01-23 10:14:38',NULL,'2026-01-23 10:18:41',1,64,'bdfc6219-716c-481a-916d-78de375d66c3',NULL,'image_name','tempest-scenario-img--669154225'),('2026-01-23 10:14:38',NULL,'2026-01-23 10:18:41',1,65,'bdfc6219-716c-481a-916d-78de375d66c3',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 10:14:38',NULL,'2026-01-23 10:18:41',1,66,'bdfc6219-716c-481a-916d-78de375d66c3',NULL,'container_format','bare'),('2026-01-23 10:14:38',NULL,'2026-01-23 10:18:41',1,67,'bdfc6219-716c-481a-916d-78de375d66c3',NULL,'disk_format','qcow2'),('2026-01-23 10:14:38',NULL,'2026-01-23 10:18:41',1,68,'bdfc6219-716c-481a-916d-78de375d66c3',NULL,'min_disk','0'),('2026-01-23 10:14:38',NULL,'2026-01-23 10:18:41',1,69,'bdfc6219-716c-481a-916d-78de375d66c3',NULL,'min_ram','0'),('2026-01-23 10:14:38',NULL,'2026-01-23 10:18:41',1,70,'bdfc6219-716c-481a-916d-78de375d66c3',NULL,'size','21430272'),('2026-01-23 10:14:39',NULL,'2026-01-23 10:18:37',1,71,'0bf60c43-104e-4a31-b83b-9fcea380005d',NULL,'signature_verified','False'),('2026-01-23 10:14:42',NULL,'2026-01-23 10:18:39',1,72,'3bbb4d6e-08b6-40cf-b719-94bd5e591c16',NULL,'image_id','5e615da5-21b7-41e6-bf0a-0f222139b158'),('2026-01-23 10:14:42',NULL,'2026-01-23 10:18:39',1,73,'3bbb4d6e-08b6-40cf-b719-94bd5e591c16',NULL,'image_name','tempest-scenario-img--669154225'),('2026-01-23 10:14:42',NULL,'2026-01-23 10:18:39',1,74,'3bbb4d6e-08b6-40cf-b719-94bd5e591c16',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 10:14:42',NULL,'2026-01-23 10:18:39',1,75,'3bbb4d6e-08b6-40cf-b719-94bd5e591c16',NULL,'container_format','bare'),('2026-01-23 10:14:42',NULL,'2026-01-23 10:18:39',1,76,'3bbb4d6e-08b6-40cf-b719-94bd5e591c16',NULL,'disk_format','qcow2'),('2026-01-23 10:14:42',NULL,'2026-01-23 10:18:39',1,77,'3bbb4d6e-08b6-40cf-b719-94bd5e591c16',NULL,'min_disk','0'),('2026-01-23 10:14:42',NULL,'2026-01-23 10:18:39',1,78,'3bbb4d6e-08b6-40cf-b719-94bd5e591c16',NULL,'min_ram','0'),('2026-01-23 10:14:42',NULL,'2026-01-23 10:18:39',1,79,'3bbb4d6e-08b6-40cf-b719-94bd5e591c16',NULL,'size','21430272'),('2026-01-23 10:14:44',NULL,'2026-01-23 10:18:37',1,80,'0bf60c43-104e-4a31-b83b-9fcea380005d',NULL,'image_id','5e615da5-21b7-41e6-bf0a-0f222139b158'),('2026-01-23 10:14:44',NULL,'2026-01-23 10:18:37',1,81,'0bf60c43-104e-4a31-b83b-9fcea380005d',NULL,'image_name','tempest-scenario-img--669154225'),('2026-01-23 10:14:44',NULL,'2026-01-23 10:18:37',1,82,'0bf60c43-104e-4a31-b83b-9fcea380005d',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 10:14:44',NULL,'2026-01-23 10:18:37',1,83,'0bf60c43-104e-4a31-b83b-9fcea380005d',NULL,'container_format','bare'),('2026-01-23 10:14:44',NULL,'2026-01-23 10:18:37',1,84,'0bf60c43-104e-4a31-b83b-9fcea380005d',NULL,'disk_format','qcow2'),('2026-01-23 10:14:44',NULL,'2026-01-23 10:18:37',1,85,'0bf60c43-104e-4a31-b83b-9fcea380005d',NULL,'min_disk','0'),('2026-01-23 10:14:44',NULL,'2026-01-23 10:18:37',1,86,'0bf60c43-104e-4a31-b83b-9fcea380005d',NULL,'min_ram','0'),('2026-01-23 10:14:44',NULL,'2026-01-23 10:18:37',1,87,'0bf60c43-104e-4a31-b83b-9fcea380005d',NULL,'size','21430272'),('2026-01-23 10:16:32',NULL,'2026-01-23 10:17:55',1,88,'aee959cd-89dc-45e7-ba7b-58dc8568e292',NULL,'signature_verified','False'),('2026-01-23 10:16:40',NULL,'2026-01-23 10:17:55',1,89,'aee959cd-89dc-45e7-ba7b-58dc8568e292',NULL,'hw_rng_model','virtio'),('2026-01-23 10:16:40',NULL,'2026-01-23 10:17:55',1,90,'aee959cd-89dc-45e7-ba7b-58dc8568e292',NULL,'image_id','84c0ef19-7f67-4bd3-95d8-507c3e0942ed'),('2026-01-23 10:16:40',NULL,'2026-01-23 10:17:55',1,91,'aee959cd-89dc-45e7-ba7b-58dc8568e292',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-23 10:16:40',NULL,'2026-01-23 10:17:55',1,92,'aee959cd-89dc-45e7-ba7b-58dc8568e292',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 10:16:40',NULL,'2026-01-23 10:17:55',1,93,'aee959cd-89dc-45e7-ba7b-58dc8568e292',NULL,'container_format','bare'),('2026-01-23 10:16:40',NULL,'2026-01-23 10:17:55',1,94,'aee959cd-89dc-45e7-ba7b-58dc8568e292',NULL,'disk_format','qcow2'),('2026-01-23 10:16:40',NULL,'2026-01-23 10:17:55',1,95,'aee959cd-89dc-45e7-ba7b-58dc8568e292',NULL,'min_disk','0'),('2026-01-23 10:16:40',NULL,'2026-01-23 10:17:55',1,96,'aee959cd-89dc-45e7-ba7b-58dc8568e292',NULL,'min_ram','0'),('2026-01-23 10:16:40',NULL,'2026-01-23 10:17:55',1,97,'aee959cd-89dc-45e7-ba7b-58dc8568e292',NULL,'size','21430272'),('2026-01-23 10:17:55',NULL,'2026-01-23 10:18:40',1,98,'aee959cd-89dc-45e7-ba7b-58dc8568e292',NULL,'hw_rng_model','virtio'),('2026-01-23 10:17:55',NULL,'2026-01-23 10:18:40',1,99,'aee959cd-89dc-45e7-ba7b-58dc8568e292',NULL,'image_id','ae1f9e37-418c-462f-81d1-3599a6d89de9'),('2026-01-23 10:17:55',NULL,'2026-01-23 10:18:40',1,100,'aee959cd-89dc-45e7-ba7b-58dc8568e292',NULL,'image_name','cirros-0.6.2-x86_64-disk.img_alt'),('2026-01-23 10:17:55',NULL,'2026-01-23 10:18:40',1,101,'aee959cd-89dc-45e7-ba7b-58dc8568e292',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 10:17:55',NULL,'2026-01-23 10:18:40',1,102,'aee959cd-89dc-45e7-ba7b-58dc8568e292',NULL,'container_format','bare'),('2026-01-23 10:17:55',NULL,'2026-01-23 10:18:40',1,103,'aee959cd-89dc-45e7-ba7b-58dc8568e292',NULL,'disk_format','qcow2'),('2026-01-23 10:17:55',NULL,'2026-01-23 10:18:40',1,104,'aee959cd-89dc-45e7-ba7b-58dc8568e292',NULL,'min_disk','0'),('2026-01-23 10:17:55',NULL,'2026-01-23 10:18:40',1,105,'aee959cd-89dc-45e7-ba7b-58dc8568e292',NULL,'min_ram','0'),('2026-01-23 10:17:55',NULL,'2026-01-23 10:18:40',1,106,'aee959cd-89dc-45e7-ba7b-58dc8568e292',NULL,'size','21430272'),('2026-01-23 10:26:50',NULL,NULL,0,107,'03c13a28-044c-43b3-8aa2-67640721a086',NULL,'signature_verified','False'),('2026-01-23 10:26:59',NULL,NULL,0,108,'03c13a28-044c-43b3-8aa2-67640721a086',NULL,'hw_rng_model','virtio'),('2026-01-23 10:26:59',NULL,NULL,0,109,'03c13a28-044c-43b3-8aa2-67640721a086',NULL,'image_id','84c0ef19-7f67-4bd3-95d8-507c3e0942ed'),('2026-01-23 10:26:59',NULL,NULL,0,110,'03c13a28-044c-43b3-8aa2-67640721a086',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-23 10:26:59',NULL,NULL,0,111,'03c13a28-044c-43b3-8aa2-67640721a086',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 10:26:59',NULL,NULL,0,112,'03c13a28-044c-43b3-8aa2-67640721a086',NULL,'container_format','bare'),('2026-01-23 10:26:59',NULL,NULL,0,113,'03c13a28-044c-43b3-8aa2-67640721a086',NULL,'disk_format','qcow2'),('2026-01-23 10:26:59',NULL,NULL,0,114,'03c13a28-044c-43b3-8aa2-67640721a086',NULL,'min_disk','0'),('2026-01-23 10:26:59',NULL,NULL,0,115,'03c13a28-044c-43b3-8aa2-67640721a086',NULL,'min_ram','0'),('2026-01-23 10:26:59',NULL,NULL,0,116,'03c13a28-044c-43b3-8aa2-67640721a086',NULL,'size','21430272'),('2026-01-23 10:38:01',NULL,'2026-01-23 10:44:33',1,117,'707d7a47-dd85-4006-890f-724df1ffbdae',NULL,'signature_verified','False'),('2026-01-23 10:38:12',NULL,'2026-01-23 10:44:33',1,118,'707d7a47-dd85-4006-890f-724df1ffbdae',NULL,'hw_rng_model','virtio'),('2026-01-23 10:38:12',NULL,'2026-01-23 10:44:33',1,119,'707d7a47-dd85-4006-890f-724df1ffbdae',NULL,'image_id','84c0ef19-7f67-4bd3-95d8-507c3e0942ed'),('2026-01-23 10:38:13',NULL,'2026-01-23 10:44:33',1,120,'707d7a47-dd85-4006-890f-724df1ffbdae',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-23 10:38:13',NULL,'2026-01-23 10:44:33',1,121,'707d7a47-dd85-4006-890f-724df1ffbdae',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 10:38:13',NULL,'2026-01-23 10:44:33',1,122,'707d7a47-dd85-4006-890f-724df1ffbdae',NULL,'container_format','bare'),('2026-01-23 10:38:13',NULL,'2026-01-23 10:44:33',1,123,'707d7a47-dd85-4006-890f-724df1ffbdae',NULL,'disk_format','qcow2'),('2026-01-23 10:38:13',NULL,'2026-01-23 10:44:33',1,124,'707d7a47-dd85-4006-890f-724df1ffbdae',NULL,'min_disk','0'),('2026-01-23 10:38:13',NULL,'2026-01-23 10:44:33',1,125,'707d7a47-dd85-4006-890f-724df1ffbdae',NULL,'min_ram','0'),('2026-01-23 10:38:13',NULL,'2026-01-23 10:44:33',1,126,'707d7a47-dd85-4006-890f-724df1ffbdae',NULL,'size','21430272'),('2026-01-23 10:38:19',NULL,'2026-01-23 10:39:33',1,127,'c5ce5b98-2b3d-4d0d-be73-68e3c174a3f2',NULL,'signature_verified','False'),('2026-01-23 10:38:26',NULL,'2026-01-23 10:39:33',1,128,'c5ce5b98-2b3d-4d0d-be73-68e3c174a3f2',NULL,'hw_rng_model','virtio'),('2026-01-23 10:38:26',NULL,'2026-01-23 10:39:33',1,129,'c5ce5b98-2b3d-4d0d-be73-68e3c174a3f2',NULL,'image_id','84c0ef19-7f67-4bd3-95d8-507c3e0942ed'),('2026-01-23 10:38:26',NULL,'2026-01-23 10:39:33',1,130,'c5ce5b98-2b3d-4d0d-be73-68e3c174a3f2',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-23 10:38:26',NULL,'2026-01-23 10:39:33',1,131,'c5ce5b98-2b3d-4d0d-be73-68e3c174a3f2',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 10:38:26',NULL,'2026-01-23 10:39:33',1,132,'c5ce5b98-2b3d-4d0d-be73-68e3c174a3f2',NULL,'container_format','bare'),('2026-01-23 10:38:26',NULL,'2026-01-23 10:39:33',1,133,'c5ce5b98-2b3d-4d0d-be73-68e3c174a3f2',NULL,'disk_format','qcow2'),('2026-01-23 10:38:26',NULL,'2026-01-23 10:39:33',1,134,'c5ce5b98-2b3d-4d0d-be73-68e3c174a3f2',NULL,'min_disk','0'),('2026-01-23 10:38:26',NULL,'2026-01-23 10:39:33',1,135,'c5ce5b98-2b3d-4d0d-be73-68e3c174a3f2',NULL,'min_ram','0'),('2026-01-23 10:38:26',NULL,'2026-01-23 10:39:33',1,136,'c5ce5b98-2b3d-4d0d-be73-68e3c174a3f2',NULL,'size','21430272'),('2026-01-23 10:38:40',NULL,'2026-01-23 10:39:33',1,137,'abf07740-6e5f-44bf-b631-41bec916b9fe',NULL,'signature_verified','False'),('2026-01-23 10:38:40',NULL,'2026-01-23 10:39:33',1,138,'abf07740-6e5f-44bf-b631-41bec916b9fe',NULL,'hw_rng_model','virtio'),('2026-01-23 10:38:40',NULL,'2026-01-23 10:39:33',1,139,'abf07740-6e5f-44bf-b631-41bec916b9fe',NULL,'image_id','84c0ef19-7f67-4bd3-95d8-507c3e0942ed'),('2026-01-23 10:38:40',NULL,'2026-01-23 10:39:33',1,140,'abf07740-6e5f-44bf-b631-41bec916b9fe',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-23 10:38:40',NULL,'2026-01-23 10:39:33',1,141,'abf07740-6e5f-44bf-b631-41bec916b9fe',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 10:38:40',NULL,'2026-01-23 10:39:33',1,142,'abf07740-6e5f-44bf-b631-41bec916b9fe',NULL,'container_format','bare'),('2026-01-23 10:38:40',NULL,'2026-01-23 10:39:33',1,143,'abf07740-6e5f-44bf-b631-41bec916b9fe',NULL,'disk_format','qcow2'),('2026-01-23 10:38:40',NULL,'2026-01-23 10:39:33',1,144,'abf07740-6e5f-44bf-b631-41bec916b9fe',NULL,'min_disk','0'),('2026-01-23 10:38:40',NULL,'2026-01-23 10:39:33',1,145,'abf07740-6e5f-44bf-b631-41bec916b9fe',NULL,'min_ram','0'),('2026-01-23 10:38:40',NULL,'2026-01-23 10:39:33',1,146,'abf07740-6e5f-44bf-b631-41bec916b9fe',NULL,'size','21430272'),('2026-01-23 10:41:20',NULL,'2026-01-23 10:42:09',1,147,'1bf4eab6-ff85-4f56-89e4-e9a95b31e4e7',NULL,'signature_verified','False'),('2026-01-23 10:41:31',NULL,'2026-01-23 10:42:09',1,148,'1bf4eab6-ff85-4f56-89e4-e9a95b31e4e7',NULL,'hw_rng_model','virtio'),('2026-01-23 10:41:31',NULL,'2026-01-23 10:42:09',1,149,'1bf4eab6-ff85-4f56-89e4-e9a95b31e4e7',NULL,'image_id','84c0ef19-7f67-4bd3-95d8-507c3e0942ed'),('2026-01-23 10:41:31',NULL,'2026-01-23 10:42:09',1,150,'1bf4eab6-ff85-4f56-89e4-e9a95b31e4e7',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-23 10:41:31',NULL,'2026-01-23 10:42:09',1,151,'1bf4eab6-ff85-4f56-89e4-e9a95b31e4e7',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 10:41:31',NULL,'2026-01-23 10:42:09',1,152,'1bf4eab6-ff85-4f56-89e4-e9a95b31e4e7',NULL,'container_format','bare'),('2026-01-23 10:41:31',NULL,'2026-01-23 10:42:09',1,153,'1bf4eab6-ff85-4f56-89e4-e9a95b31e4e7',NULL,'disk_format','qcow2'),('2026-01-23 10:41:31',NULL,'2026-01-23 10:42:09',1,154,'1bf4eab6-ff85-4f56-89e4-e9a95b31e4e7',NULL,'min_disk','0'),('2026-01-23 10:41:31',NULL,'2026-01-23 10:42:09',1,155,'1bf4eab6-ff85-4f56-89e4-e9a95b31e4e7',NULL,'min_ram','0'),('2026-01-23 10:41:31',NULL,'2026-01-23 10:42:09',1,156,'1bf4eab6-ff85-4f56-89e4-e9a95b31e4e7',NULL,'size','21430272'),('2026-01-23 10:41:39',NULL,'2026-01-23 10:42:08',1,157,NULL,'56abda02-64b9-4403-a75d-7c77cd557d3a','signature_verified','False'),('2026-01-23 10:41:39',NULL,'2026-01-23 10:42:08',1,158,NULL,'56abda02-64b9-4403-a75d-7c77cd557d3a','hw_rng_model','virtio'),('2026-01-23 10:41:39',NULL,'2026-01-23 10:42:08',1,159,NULL,'56abda02-64b9-4403-a75d-7c77cd557d3a','image_id','84c0ef19-7f67-4bd3-95d8-507c3e0942ed'),('2026-01-23 10:41:39',NULL,'2026-01-23 10:42:08',1,160,NULL,'56abda02-64b9-4403-a75d-7c77cd557d3a','image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-23 10:41:39',NULL,'2026-01-23 10:42:08',1,161,NULL,'56abda02-64b9-4403-a75d-7c77cd557d3a','checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 10:41:39',NULL,'2026-01-23 10:42:08',1,162,NULL,'56abda02-64b9-4403-a75d-7c77cd557d3a','container_format','bare'),('2026-01-23 10:41:39',NULL,'2026-01-23 10:42:08',1,163,NULL,'56abda02-64b9-4403-a75d-7c77cd557d3a','disk_format','qcow2'),('2026-01-23 10:41:39',NULL,'2026-01-23 10:42:08',1,164,NULL,'56abda02-64b9-4403-a75d-7c77cd557d3a','min_disk','0'),('2026-01-23 10:41:39',NULL,'2026-01-23 10:42:08',1,165,NULL,'56abda02-64b9-4403-a75d-7c77cd557d3a','min_ram','0'),('2026-01-23 10:41:39',NULL,'2026-01-23 10:42:08',1,166,NULL,'56abda02-64b9-4403-a75d-7c77cd557d3a','size','21430272'),('2026-01-23 10:41:46',NULL,'2026-01-23 10:42:04',1,167,'53917a40-f345-4f87-a3c1-5297194341d6',NULL,'signature_verified','False'),('2026-01-23 10:41:46',NULL,'2026-01-23 10:42:04',1,168,'53917a40-f345-4f87-a3c1-5297194341d6',NULL,'hw_rng_model','virtio'),('2026-01-23 10:41:46',NULL,'2026-01-23 10:42:04',1,169,'53917a40-f345-4f87-a3c1-5297194341d6',NULL,'image_id','84c0ef19-7f67-4bd3-95d8-507c3e0942ed'),('2026-01-23 10:41:46',NULL,'2026-01-23 10:42:04',1,170,'53917a40-f345-4f87-a3c1-5297194341d6',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-23 10:41:46',NULL,'2026-01-23 10:42:04',1,171,'53917a40-f345-4f87-a3c1-5297194341d6',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 10:41:46',NULL,'2026-01-23 10:42:04',1,172,'53917a40-f345-4f87-a3c1-5297194341d6',NULL,'container_format','bare'),('2026-01-23 10:41:46',NULL,'2026-01-23 10:42:04',1,173,'53917a40-f345-4f87-a3c1-5297194341d6',NULL,'disk_format','qcow2'),('2026-01-23 10:41:46',NULL,'2026-01-23 10:42:04',1,174,'53917a40-f345-4f87-a3c1-5297194341d6',NULL,'min_disk','0'),('2026-01-23 10:41:46',NULL,'2026-01-23 10:42:04',1,175,'53917a40-f345-4f87-a3c1-5297194341d6',NULL,'min_ram','0'),('2026-01-23 10:41:46',NULL,'2026-01-23 10:42:04',1,176,'53917a40-f345-4f87-a3c1-5297194341d6',NULL,'size','21430272'),('2026-01-23 10:42:14',NULL,'2026-01-23 10:44:47',1,177,'d77d9325-542a-4716-94b2-e66e8ceab532',NULL,'signature_verified','False'),('2026-01-23 10:42:19',NULL,'2026-01-23 10:44:47',1,178,'d77d9325-542a-4716-94b2-e66e8ceab532',NULL,'hw_rng_model','virtio'),('2026-01-23 10:42:19',NULL,'2026-01-23 10:44:47',1,179,'d77d9325-542a-4716-94b2-e66e8ceab532',NULL,'image_id','84c0ef19-7f67-4bd3-95d8-507c3e0942ed'),('2026-01-23 10:42:19',NULL,'2026-01-23 10:44:47',1,180,'d77d9325-542a-4716-94b2-e66e8ceab532',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-23 10:42:19',NULL,'2026-01-23 10:44:47',1,181,'d77d9325-542a-4716-94b2-e66e8ceab532',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 10:42:19',NULL,'2026-01-23 10:44:47',1,182,'d77d9325-542a-4716-94b2-e66e8ceab532',NULL,'container_format','bare'),('2026-01-23 10:42:19',NULL,'2026-01-23 10:44:47',1,183,'d77d9325-542a-4716-94b2-e66e8ceab532',NULL,'disk_format','qcow2'),('2026-01-23 10:42:19',NULL,'2026-01-23 10:44:47',1,184,'d77d9325-542a-4716-94b2-e66e8ceab532',NULL,'min_disk','0'),('2026-01-23 10:42:19',NULL,'2026-01-23 10:44:47',1,185,'d77d9325-542a-4716-94b2-e66e8ceab532',NULL,'min_ram','0'),('2026-01-23 10:42:19',NULL,'2026-01-23 10:44:47',1,186,'d77d9325-542a-4716-94b2-e66e8ceab532',NULL,'size','21430272'),('2026-01-23 10:42:33',NULL,'2026-01-23 10:43:47',1,187,'d8ca748e-6bb8-4ae2-9729-d2be77ce520f',NULL,'signature_verified','False'),('2026-01-23 10:42:56',NULL,'2026-01-23 10:43:47',1,188,'d8ca748e-6bb8-4ae2-9729-d2be77ce520f',NULL,'hw_rng_model','virtio'),('2026-01-23 10:42:56',NULL,'2026-01-23 10:43:47',1,189,'d8ca748e-6bb8-4ae2-9729-d2be77ce520f',NULL,'image_id','84c0ef19-7f67-4bd3-95d8-507c3e0942ed'),('2026-01-23 10:42:56',NULL,'2026-01-23 10:43:47',1,190,'d8ca748e-6bb8-4ae2-9729-d2be77ce520f',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-23 10:42:56',NULL,'2026-01-23 10:43:47',1,191,'d8ca748e-6bb8-4ae2-9729-d2be77ce520f',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 10:42:56',NULL,'2026-01-23 10:43:47',1,192,'d8ca748e-6bb8-4ae2-9729-d2be77ce520f',NULL,'container_format','bare'),('2026-01-23 10:42:56',NULL,'2026-01-23 10:43:47',1,193,'d8ca748e-6bb8-4ae2-9729-d2be77ce520f',NULL,'disk_format','qcow2'),('2026-01-23 10:42:56',NULL,'2026-01-23 10:43:47',1,194,'d8ca748e-6bb8-4ae2-9729-d2be77ce520f',NULL,'min_disk','0'),('2026-01-23 10:42:56',NULL,'2026-01-23 10:43:47',1,195,'d8ca748e-6bb8-4ae2-9729-d2be77ce520f',NULL,'min_ram','0'),('2026-01-23 10:42:56',NULL,'2026-01-23 10:43:47',1,196,'d8ca748e-6bb8-4ae2-9729-d2be77ce520f',NULL,'size','21430272'),('2026-01-23 10:43:16',NULL,'2026-01-23 10:44:30',1,197,NULL,'aad073c6-3850-4a37-969d-b73d0ec7219a','signature_verified','False'),('2026-01-23 10:43:16',NULL,'2026-01-23 10:44:30',1,198,NULL,'aad073c6-3850-4a37-969d-b73d0ec7219a','hw_rng_model','virtio'),('2026-01-23 10:43:16',NULL,'2026-01-23 10:44:30',1,199,NULL,'aad073c6-3850-4a37-969d-b73d0ec7219a','image_id','84c0ef19-7f67-4bd3-95d8-507c3e0942ed'),('2026-01-23 10:43:16',NULL,'2026-01-23 10:44:30',1,200,NULL,'aad073c6-3850-4a37-969d-b73d0ec7219a','image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-23 10:43:16',NULL,'2026-01-23 10:44:30',1,201,NULL,'aad073c6-3850-4a37-969d-b73d0ec7219a','checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 10:43:16',NULL,'2026-01-23 10:44:30',1,202,NULL,'aad073c6-3850-4a37-969d-b73d0ec7219a','container_format','bare'),('2026-01-23 10:43:16',NULL,'2026-01-23 10:44:30',1,203,NULL,'aad073c6-3850-4a37-969d-b73d0ec7219a','disk_format','qcow2'),('2026-01-23 10:43:16',NULL,'2026-01-23 10:44:30',1,204,NULL,'aad073c6-3850-4a37-969d-b73d0ec7219a','min_disk','0'),('2026-01-23 10:43:16',NULL,'2026-01-23 10:44:30',1,205,NULL,'aad073c6-3850-4a37-969d-b73d0ec7219a','min_ram','0'),('2026-01-23 10:43:16',NULL,'2026-01-23 10:44:30',1,206,NULL,'aad073c6-3850-4a37-969d-b73d0ec7219a','size','21430272'),('2026-01-23 10:43:37',NULL,'2026-01-23 10:43:47',1,207,NULL,'3033136a-603a-44e6-bb60-ea116fce16b7','signature_verified','False'),('2026-01-23 10:43:37',NULL,'2026-01-23 10:43:47',1,208,NULL,'3033136a-603a-44e6-bb60-ea116fce16b7','hw_rng_model','virtio'),('2026-01-23 10:43:37',NULL,'2026-01-23 10:43:47',1,209,NULL,'3033136a-603a-44e6-bb60-ea116fce16b7','image_id','84c0ef19-7f67-4bd3-95d8-507c3e0942ed'),('2026-01-23 10:43:37',NULL,'2026-01-23 10:43:47',1,210,NULL,'3033136a-603a-44e6-bb60-ea116fce16b7','image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-23 10:43:37',NULL,'2026-01-23 10:43:47',1,211,NULL,'3033136a-603a-44e6-bb60-ea116fce16b7','checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 10:43:37',NULL,'2026-01-23 10:43:47',1,212,NULL,'3033136a-603a-44e6-bb60-ea116fce16b7','container_format','bare'),('2026-01-23 10:43:37',NULL,'2026-01-23 10:43:47',1,213,NULL,'3033136a-603a-44e6-bb60-ea116fce16b7','disk_format','qcow2'),('2026-01-23 10:43:37',NULL,'2026-01-23 10:43:47',1,214,NULL,'3033136a-603a-44e6-bb60-ea116fce16b7','min_disk','0'),('2026-01-23 10:43:37',NULL,'2026-01-23 10:43:47',1,215,NULL,'3033136a-603a-44e6-bb60-ea116fce16b7','min_ram','0'),('2026-01-23 10:43:37',NULL,'2026-01-23 10:43:47',1,216,NULL,'3033136a-603a-44e6-bb60-ea116fce16b7','size','21430272'),('2026-01-23 10:43:37',NULL,'2026-01-23 10:44:28',1,217,'837a8189-567b-4aae-b83b-e7aa7a4ff9a7',NULL,'signature_verified','False'),('2026-01-23 10:43:37',NULL,'2026-01-23 10:44:28',1,218,'837a8189-567b-4aae-b83b-e7aa7a4ff9a7',NULL,'hw_rng_model','virtio'),('2026-01-23 10:43:37',NULL,'2026-01-23 10:44:28',1,219,'837a8189-567b-4aae-b83b-e7aa7a4ff9a7',NULL,'image_id','84c0ef19-7f67-4bd3-95d8-507c3e0942ed'),('2026-01-23 10:43:37',NULL,'2026-01-23 10:44:28',1,220,'837a8189-567b-4aae-b83b-e7aa7a4ff9a7',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-23 10:43:37',NULL,'2026-01-23 10:44:28',1,221,'837a8189-567b-4aae-b83b-e7aa7a4ff9a7',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 10:43:37',NULL,'2026-01-23 10:44:28',1,222,'837a8189-567b-4aae-b83b-e7aa7a4ff9a7',NULL,'container_format','bare'),('2026-01-23 10:43:37',NULL,'2026-01-23 10:44:28',1,223,'837a8189-567b-4aae-b83b-e7aa7a4ff9a7',NULL,'disk_format','qcow2'),('2026-01-23 10:43:37',NULL,'2026-01-23 10:44:28',1,224,'837a8189-567b-4aae-b83b-e7aa7a4ff9a7',NULL,'min_disk','0'),('2026-01-23 10:43:37',NULL,'2026-01-23 10:44:28',1,225,'837a8189-567b-4aae-b83b-e7aa7a4ff9a7',NULL,'min_ram','0'),('2026-01-23 10:43:37',NULL,'2026-01-23 10:44:28',1,226,'837a8189-567b-4aae-b83b-e7aa7a4ff9a7',NULL,'size','21430272'),('2026-01-23 10:45:07',NULL,'2026-01-23 10:48:14',1,227,'e5e1339d-ae3b-4104-9429-034d0ceea4fd',NULL,'signature_verified','False'),('2026-01-23 10:45:12',NULL,'2026-01-23 10:48:14',1,228,'e5e1339d-ae3b-4104-9429-034d0ceea4fd',NULL,'hw_rng_model','virtio'),('2026-01-23 10:45:12',NULL,'2026-01-23 10:48:14',1,229,'e5e1339d-ae3b-4104-9429-034d0ceea4fd',NULL,'image_id','84c0ef19-7f67-4bd3-95d8-507c3e0942ed'),('2026-01-23 10:45:12',NULL,'2026-01-23 10:48:14',1,230,'e5e1339d-ae3b-4104-9429-034d0ceea4fd',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-23 10:45:12',NULL,'2026-01-23 10:48:14',1,231,'e5e1339d-ae3b-4104-9429-034d0ceea4fd',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 10:45:12',NULL,'2026-01-23 10:48:14',1,232,'e5e1339d-ae3b-4104-9429-034d0ceea4fd',NULL,'container_format','bare'),('2026-01-23 10:45:12',NULL,'2026-01-23 10:48:14',1,233,'e5e1339d-ae3b-4104-9429-034d0ceea4fd',NULL,'disk_format','qcow2'),('2026-01-23 10:45:12',NULL,'2026-01-23 10:48:14',1,234,'e5e1339d-ae3b-4104-9429-034d0ceea4fd',NULL,'min_disk','0'),('2026-01-23 10:45:12',NULL,'2026-01-23 10:48:14',1,235,'e5e1339d-ae3b-4104-9429-034d0ceea4fd',NULL,'min_ram','0'),('2026-01-23 10:45:12',NULL,'2026-01-23 10:48:14',1,236,'e5e1339d-ae3b-4104-9429-034d0ceea4fd',NULL,'size','21430272'),('2026-01-23 10:46:50',NULL,'2026-01-23 10:48:01',1,237,NULL,'7275b587-5973-4959-aa03-e3382419cbac','signature_verified','False'),('2026-01-23 10:46:50',NULL,'2026-01-23 10:48:01',1,238,NULL,'7275b587-5973-4959-aa03-e3382419cbac','hw_rng_model','virtio'),('2026-01-23 10:46:50',NULL,'2026-01-23 10:48:01',1,239,NULL,'7275b587-5973-4959-aa03-e3382419cbac','image_id','84c0ef19-7f67-4bd3-95d8-507c3e0942ed'),('2026-01-23 10:46:50',NULL,'2026-01-23 10:48:01',1,240,NULL,'7275b587-5973-4959-aa03-e3382419cbac','image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-23 10:46:50',NULL,'2026-01-23 10:48:01',1,241,NULL,'7275b587-5973-4959-aa03-e3382419cbac','checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 10:46:50',NULL,'2026-01-23 10:48:01',1,242,NULL,'7275b587-5973-4959-aa03-e3382419cbac','container_format','bare'),('2026-01-23 10:46:50',NULL,'2026-01-23 10:48:01',1,243,NULL,'7275b587-5973-4959-aa03-e3382419cbac','disk_format','qcow2'),('2026-01-23 10:46:50',NULL,'2026-01-23 10:48:01',1,244,NULL,'7275b587-5973-4959-aa03-e3382419cbac','min_disk','0'),('2026-01-23 10:46:50',NULL,'2026-01-23 10:48:01',1,245,NULL,'7275b587-5973-4959-aa03-e3382419cbac','min_ram','0'),('2026-01-23 10:46:50',NULL,'2026-01-23 10:48:01',1,246,NULL,'7275b587-5973-4959-aa03-e3382419cbac','size','21430272'),('2026-01-23 10:46:51',NULL,'2026-01-23 10:47:59',1,247,'5e6f1d6f-902b-4bb5-b9af-c82516af3452',NULL,'signature_verified','False'),('2026-01-23 10:46:51',NULL,'2026-01-23 10:47:59',1,248,'5e6f1d6f-902b-4bb5-b9af-c82516af3452',NULL,'hw_rng_model','virtio'),('2026-01-23 10:46:51',NULL,'2026-01-23 10:47:59',1,249,'5e6f1d6f-902b-4bb5-b9af-c82516af3452',NULL,'image_id','84c0ef19-7f67-4bd3-95d8-507c3e0942ed'),('2026-01-23 10:46:51',NULL,'2026-01-23 10:47:59',1,250,'5e6f1d6f-902b-4bb5-b9af-c82516af3452',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-23 10:46:51',NULL,'2026-01-23 10:47:59',1,251,'5e6f1d6f-902b-4bb5-b9af-c82516af3452',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 10:46:51',NULL,'2026-01-23 10:47:59',1,252,'5e6f1d6f-902b-4bb5-b9af-c82516af3452',NULL,'container_format','bare'),('2026-01-23 10:46:51',NULL,'2026-01-23 10:47:59',1,253,'5e6f1d6f-902b-4bb5-b9af-c82516af3452',NULL,'disk_format','qcow2'),('2026-01-23 10:46:51',NULL,'2026-01-23 10:47:59',1,254,'5e6f1d6f-902b-4bb5-b9af-c82516af3452',NULL,'min_disk','0'),('2026-01-23 10:46:51',NULL,'2026-01-23 10:47:59',1,255,'5e6f1d6f-902b-4bb5-b9af-c82516af3452',NULL,'min_ram','0'),('2026-01-23 10:46:51',NULL,'2026-01-23 10:47:59',1,256,'5e6f1d6f-902b-4bb5-b9af-c82516af3452',NULL,'size','21430272'),('2026-01-23 11:14:20',NULL,'2026-01-23 11:16:52',1,257,'525f185e-d0f4-4a0b-bd48-9219445747c5',NULL,'signature_verified','False'),('2026-01-23 11:14:26',NULL,'2026-01-23 11:16:52',1,258,'525f185e-d0f4-4a0b-bd48-9219445747c5',NULL,'hw_rng_model','virtio'),('2026-01-23 11:14:26',NULL,'2026-01-23 11:16:52',1,259,'525f185e-d0f4-4a0b-bd48-9219445747c5',NULL,'image_id','84c0ef19-7f67-4bd3-95d8-507c3e0942ed'),('2026-01-23 11:14:26',NULL,'2026-01-23 11:16:52',1,260,'525f185e-d0f4-4a0b-bd48-9219445747c5',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-23 11:14:26',NULL,'2026-01-23 11:16:52',1,261,'525f185e-d0f4-4a0b-bd48-9219445747c5',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-23 11:14:26',NULL,'2026-01-23 11:16:52',1,262,'525f185e-d0f4-4a0b-bd48-9219445747c5',NULL,'container_format','bare'),('2026-01-23 11:14:26',NULL,'2026-01-23 11:16:52',1,263,'525f185e-d0f4-4a0b-bd48-9219445747c5',NULL,'disk_format','qcow2'),('2026-01-23 11:14:26',NULL,'2026-01-23 11:16:52',1,264,'525f185e-d0f4-4a0b-bd48-9219445747c5',NULL,'min_disk','0'),('2026-01-23 11:14:26',NULL,'2026-01-23 11:16:52',1,265,'525f185e-d0f4-4a0b-bd48-9219445747c5',NULL,'min_ram','0'),('2026-01-23 11:14:26',NULL,'2026-01-23 11:16:52',1,266,'525f185e-d0f4-4a0b-bd48-9219445747c5',NULL,'size','21430272');
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
INSERT INTO `volume_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `key`, `value`) VALUES ('2026-01-23 10:11:39',NULL,'2026-01-23 10:11:42',1,1,'17af6355-71ef-4ce9-ab64-40187aa12325','Type','work'),('2026-01-23 10:38:41',NULL,'2026-01-23 10:39:33',1,2,'abf07740-6e5f-44bf-b631-41bec916b9fe','src_backup_id','b54f4406-f31d-49c0-9f6f-68fb7ec2c289'),('2026-01-23 10:49:53',NULL,'2026-01-23 10:50:06',1,3,'e76f95fa-8733-479f-962c-39310ea25061','Type','work'),('2026-01-23 10:49:55',NULL,'2026-01-23 10:50:05',1,4,'a2753e65-d45d-47f6-9d20-5e4e36ca8a63','Type','work'),('2026-01-23 10:49:57',NULL,'2026-01-23 10:50:03',1,5,'aaf3200f-c36a-4d55-9406-8d435a37e41f','Type','work');
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
INSERT INTO `volume_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_type_id`, `key`, `value`) VALUES ('2026-01-23 09:26:17',NULL,NULL,0,1,'6c54b639-a8d0-4bdb-a3a9-96eb9a3c5b86','multiattach','<is> True');
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2026-01-23 10:14:19',NULL,'2026-01-23 10:18:44',1,'0150ade1-a0b3-4e34-a94a-07b87669ac2f','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1036888469-1438475917',NULL,1,NULL),('2026-01-23 10:40:24',NULL,'2026-01-23 10:41:11',1,'3f7f137e-c525-48d6-86f7-3c39c5a7bfe7','tempest-scenario-type-luks-987783221',NULL,1,NULL),('2026-01-23 10:50:39',NULL,'2026-01-23 10:52:12',1,'5aae1df8-11ba-4d19-82a2-3f94199799e6','tempest-scenario-type-luks-1600364038',NULL,1,NULL),('2026-01-23 09:26:12',NULL,NULL,0,'6c54b639-a8d0-4bdb-a3a9-96eb9a3c5b86','multiattach',NULL,1,NULL),('2026-01-23 08:44:47','2026-01-23 08:44:47',NULL,0,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3','__DEFAULT__',NULL,1,'Default Volume Type'),('2026-01-23 10:14:16',NULL,'2026-01-23 10:18:47',1,'a00c6425-7526-4fff-bb9b-9014a31551bc','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1177848314-496428426',NULL,1,NULL),('2026-01-23 10:14:19',NULL,'2026-01-23 10:18:43',1,'da61f832-7e99-4954-bb87-db7e35da9fdc','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-968827984-727097193',NULL,1,NULL);
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
INSERT INTO `volumes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `ec2_id`, `user_id`, `project_id`, `host`, `size`, `availability_zone`, `status`, `attach_status`, `scheduled_at`, `launched_at`, `terminated_at`, `display_name`, `display_description`, `provider_location`, `provider_auth`, `snapshot_id`, `volume_type_id`, `source_volid`, `bootable`, `provider_geometry`, `_name_id`, `encryption_key_id`, `migration_status`, `replication_status`, `replication_extended_status`, `replication_driver_data`, `consistencygroup_id`, `provider_id`, `multiattach`, `previous_status`, `cluster_name`, `group_id`, `service_uuid`, `shared_targets`, `use_quota`) VALUES ('2026-01-23 10:23:42','2026-01-23 10:25:10','2026-01-23 10:25:11',1,'006fb8d9-c6d3-441f-993c-5b105d3e9681',NULL,'c041da0a601a4260b29fc9c65719597f','b976daabc8124a99814954633f99ed7b','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:23:42','2026-01-23 10:23:42','2026-01-23 10:25:10','tempest-TestMinimumBasicScenario-volume-1307633705',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:26:46','2026-01-23 10:28:28',NULL,0,'03c13a28-044c-43b3-8aa2-67640721a086',NULL,'0d6a628e0dcb441fa41457bf719e65a0','5c27429e1d8f433a8a67ddb76f8798f1','hostgroup@ceph#ceph',1,'nova','available','detached','2026-01-23 10:26:46','2026-01-23 10:26:59',NULL,'','',NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:14:19','2026-01-23 10:15:47','2026-01-23 10:15:49',1,'06664261-bdf3-44c1-9f40-a29c0039b070',NULL,'95ac13194f0940128d42af3d45d130fa','3ae621f21a8e438fb95152309b38cee5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:14:19','2026-01-23 10:14:20','2026-01-23 10:15:47','tempest-TestInstancesWithCinderVolumes-volume-577243340',NULL,NULL,NULL,NULL,'0150ade1-a0b3-4e34-a94a-07b87669ac2f',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:08:45','2026-01-23 10:11:53','2026-01-23 10:11:57',1,'07c29e39-8d73-42fe-8301-b38e2875d2cc',NULL,'cde472cc8af0464992006a69d047d0d4','746ea02b745c4e21ace4cb49c193899d','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:08:45','2026-01-23 10:08:45','2026-01-23 10:11:53','tempest-ServersNegativeTestJSON-volume-1797659918',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:14:35','2026-01-23 10:18:36','2026-01-23 10:18:37',1,'0bf60c43-104e-4a31-b83b-9fcea380005d',NULL,'95ac13194f0940128d42af3d45d130fa','3ae621f21a8e438fb95152309b38cee5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:14:35','2026-01-23 10:14:44','2026-01-23 10:18:36','tempest-TestInstancesWithCinderVolumes-volume-1474948489',NULL,NULL,NULL,NULL,'a00c6425-7526-4fff-bb9b-9014a31551bc',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 09:37:48','2026-01-23 09:37:50','2026-01-23 09:37:51',1,'0c4e8174-8048-4034-b226-8ebc7cf08337',NULL,'726bd44b7ec443a0a4b8b632b06c622e','9f68f8c2203944c9a6e44a6756c8b4b9','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 09:37:48','2026-01-23 09:37:48','2026-01-23 09:37:50','tempest-VolumesAdminNegativeTest-volume-1196142920',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 09:53:01','2026-01-23 09:56:18','2026-01-23 09:56:19',1,'0c57b335-8fff-4dae-ab58-3a6c060df2a2',NULL,'d512838ce2b44554b0566fdbb3c702b4','9bc2d47d48c446c7ae1fc44cd9c32878','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 09:53:01','2026-01-23 09:53:01','2026-01-23 09:56:18','tempest-TaggedBootDevicesTest-volume-2068557686',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 09:42:29','2026-01-23 09:43:36','2026-01-23 09:43:37',1,'113a804f-8abc-47f6-b4ca-e098579996e7',NULL,'83b4563d24244490b58764ee8525c26d','2e0529ecec18434aa4fe09ac251ff46f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 09:42:30','2026-01-23 09:42:38','2026-01-23 09:43:36','tempest-tempest.common.compute-volume-810716175',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:49:39','2026-01-23 10:49:44','2026-01-23 10:49:44',1,'11c7a636-49ff-4a67-a9cc-e1355415865f',NULL,'31e408829d1a48ab9abdfcd623b2c8b6','23776559930d49e8ade3d5f91aa5dfe4','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:49:39','2026-01-23 10:49:40','2026-01-23 10:49:44','tempest-VolumesSnapshotsTestJSON-volume-232971716',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:24:10','2026-01-23 10:27:24','2026-01-23 10:27:25',1,'127a1e1e-4b4f-4404-b522-315ba62689fa',NULL,'01b7396ecc574dd6ba2df2f406921223','c7c25c6bb33b41bf9cd8febb8259fd87','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:24:10','2026-01-23 10:24:10','2026-01-23 10:27:24','tempest-AttachVolumeTestJSON-volume-1035466718',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:05:18','2026-01-23 10:07:00','2026-01-23 10:07:01',1,'1337690c-8061-4b7e-bb70-8cbfeecc77ac',NULL,'29710db389c842df836944048225740f','8c16cd713fa74a88b43e4edf01c273bd','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:05:18','2026-01-23 10:05:27','2026-01-23 10:07:00','tempest-tempest.common.compute-volume-452936852',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:11:39','2026-01-23 10:11:41','2026-01-23 10:11:42',1,'17af6355-71ef-4ce9-ab64-40187aa12325',NULL,'49d8a70549b8459da0d7483fc06dfde1','7c9246f4d92c4dfbbb8111cfef809201','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:11:39','2026-01-23 10:11:40','2026-01-23 10:11:41','tempest-VolumesGetTestJSON-Volume-527829741',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:45:55','2026-01-23 10:49:12','2026-01-23 10:49:13',1,'183950c6-1381-47bd-9def-115173b33253',NULL,'296341ffca2441dc807d285fa14c966d','36d7e7c7ddbd4cf785fafd0d35b0a2d8','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:45:55','2026-01-23 10:45:55','2026-01-23 10:49:12','tempest-AttachVolumeShelveTestJSON-volume-1180482315',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:41:14','2026-01-23 10:42:08','2026-01-23 10:42:09',1,'1bf4eab6-ff85-4f56-89e4-e9a95b31e4e7',NULL,'eb70c3aee8b64273a1930c0c2c231aff','d27c5465284b48a5818ef931d6251c43','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:41:15','2026-01-23 10:41:31','2026-01-23 10:42:08','tempest-TestVolumeBootPattern-volume-origin-1580408887',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:14:20','2026-01-23 10:17:48','2026-01-23 10:17:49',1,'23e1c9da-11aa-46ec-90eb-aa0b6ee150dc',NULL,'95ac13194f0940128d42af3d45d130fa','3ae621f21a8e438fb95152309b38cee5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:14:21','2026-01-23 10:14:21','2026-01-23 10:17:48','tempest-TestInstancesWithCinderVolumes-volume-736804077',NULL,NULL,NULL,NULL,'0150ade1-a0b3-4e34-a94a-07b87669ac2f',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:13:35','2026-01-23 10:16:20','2026-01-23 10:16:21',1,'25911eef-6039-44d2-8f6d-44618f9ed23c',NULL,'fae914e59ec54f6b80928ef3cc68dbdb','0a6ba16c4b9d49d3bc24cd7b44935d1f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:13:36','2026-01-23 10:13:36','2026-01-23 10:16:20','tempest-ServerRescueNegativeTestJSON-volume-1774380986',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 09:47:44','2026-01-23 09:49:19','2026-01-23 09:49:20',1,'2a5f9051-d3ab-46f9-b4f7-644aa73bccd4',NULL,'8d814ef2afe04103bb6aa24724d61b11','15c7fbc4d6794364830639a1fee9ecf0','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 09:47:44','2026-01-23 09:47:45','2026-01-23 09:49:19','tempest-TaggedAttachmentsTest-volume-1064848539',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 09:31:39','2026-01-23 09:33:19','2026-01-23 09:33:19',1,'2c9770c1-d351-43fa-b18d-aaf9291801fe',NULL,'a43b680a6019491aafe42c0a10e648df','c56e53b3339e4e4db30b7a9d330bc380','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 09:31:40','2026-01-23 09:31:55','2026-01-23 09:33:19','tempest-tempest.common.compute-volume-1297474962',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:14:32','2026-01-23 10:18:37','2026-01-23 10:18:39',1,'3bbb4d6e-08b6-40cf-b719-94bd5e591c16',NULL,'95ac13194f0940128d42af3d45d130fa','3ae621f21a8e438fb95152309b38cee5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:14:34','2026-01-23 10:14:42','2026-01-23 10:18:37','tempest-TestInstancesWithCinderVolumes-volume-343129254',NULL,NULL,NULL,NULL,'a00c6425-7526-4fff-bb9b-9014a31551bc',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:14:20','2026-01-23 10:16:46','2026-01-23 10:16:48',1,'3d24b1fa-0276-448e-a73a-1cba237d818c',NULL,'95ac13194f0940128d42af3d45d130fa','3ae621f21a8e438fb95152309b38cee5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:14:20','2026-01-23 10:14:20','2026-01-23 10:16:46','tempest-TestInstancesWithCinderVolumes-volume-1049192460',NULL,NULL,NULL,NULL,'0150ade1-a0b3-4e34-a94a-07b87669ac2f',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 09:29:04','2026-01-23 09:30:09','2026-01-23 09:30:12',1,'3dc5fcfb-69eb-4c5b-a254-b3c8a59b23ea',NULL,'7490603c6c014277a3f2b3aa497d32a4','649cf144e93c4123b8f11cac66308419','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 09:29:04','2026-01-23 09:29:06','2026-01-23 09:30:09','tempest-VolumesAssistedSnapshotsTest-volume-1372929209',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 09:56:54','2026-01-23 10:00:57','2026-01-23 10:00:58',1,'3fa8e844-6545-43af-a18d-ac7dfc7d2071',NULL,'35b29e4a06884f7d88683d00f85d4630','8924c80a71a94fdeb114c6bdbdb2939c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 09:56:55','2026-01-23 09:56:55','2026-01-23 10:00:57','tempest-TaggedBootDevicesTest_v242-volume-1488760609',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:48:01','2026-01-23 10:49:10','2026-01-23 10:49:11',1,'4053b4fd-d368-4ca6-9fc3-047b541c90d6',NULL,'296341ffca2441dc807d285fa14c966d','36d7e7c7ddbd4cf785fafd0d35b0a2d8','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:48:01','2026-01-23 10:48:01','2026-01-23 10:49:10','tempest-AttachVolumeShelveTestJSON-volume-355662697',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:40:24','2026-01-23 10:43:50','2026-01-23 10:43:51',1,'4393c992-1666-40a0-ab11-4cc66bdcd721',NULL,'93cd560e84264023877c47122b5919de','6e762fca3b634c7aa1d994314c059c54','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:40:24','2026-01-23 10:40:25','2026-01-23 10:43:50','tempest-AttachVolumeMultiAttachTest-volume-1041863898',NULL,'{\"saved_features\":61}',NULL,NULL,'6c54b639-a8d0-4bdb-a3a9-96eb9a3c5b86',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 09:56:57','2026-01-23 10:00:46','2026-01-23 10:00:56',1,'4c100131-c84f-4546-b7f0-7e22ffc499a0',NULL,'35b29e4a06884f7d88683d00f85d4630','8924c80a71a94fdeb114c6bdbdb2939c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 09:56:58','2026-01-23 09:56:59','2026-01-23 10:00:46','tempest-TaggedBootDevicesTest_v242-volume-1408018487',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:07:47','2026-01-23 10:11:23','2026-01-23 10:11:25',1,'509947fc-76b8-4398-98d1-07609c1b5d35',NULL,'c99d09acd2e849a69846a6ccda1e0bc7','924f976bcbb74ec195730b68eebe1f2a','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:07:47','2026-01-23 10:07:47','2026-01-23 10:11:23','tempest-AttachVolumeNegativeTest-volume-1036621020',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 11:14:18','2026-01-23 11:16:50','2026-01-23 11:16:52',1,'525f185e-d0f4-4a0b-bd48-9219445747c5',NULL,'5d6a458f5d9345379b05f0cdb69a7b0f','3a245f7970f14fffa60af2ff972b4bfd','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 11:14:18','2026-01-23 11:14:26','2026-01-23 11:16:50','tempest-tempest.common.compute-volume-79732562',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:41:45','2026-01-23 10:42:03','2026-01-23 10:42:04',1,'53917a40-f345-4f87-a3c1-5297194341d6',NULL,'eb70c3aee8b64273a1930c0c2c231aff','d27c5465284b48a5818ef931d6251c43','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:41:46','2026-01-23 10:41:46','2026-01-23 10:42:03','','',NULL,NULL,'56abda02-64b9-4403-a75d-7c77cd557d3a','94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 09:42:25','2026-01-23 09:42:44','2026-01-23 09:42:45',1,'5bcdefce-ec76-4a6c-b618-d67828743aff',NULL,'9a4618f86429416889ef239f4b21bacc','7bb32481db2547b49bc4f3a10883baef','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 09:42:25','2026-01-23 09:42:25','2026-01-23 09:42:44','tempest-AttachSCSIVolumeTestJSON-volume-981018740',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:46:51','2026-01-23 10:47:56','2026-01-23 10:47:59',1,'5e6f1d6f-902b-4bb5-b9af-c82516af3452',NULL,'eb70c3aee8b64273a1930c0c2c231aff','d27c5465284b48a5818ef931d6251c43','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:46:51','2026-01-23 10:46:51','2026-01-23 10:47:56','tempest-TestVolumeBootPattern-volume-2132652429',NULL,NULL,NULL,'7275b587-5973-4959-aa03-e3382419cbac','94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:11:30','2026-01-23 10:15:26','2026-01-23 10:15:27',1,'649f8ce8-126a-4838-b42c-047bd1f41e67',NULL,'aca3cab576d641d3b89e7dddf155d467','9dd869ce76e44fc8a82b8bbee1654d33','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:11:30','2026-01-23 10:11:30','2026-01-23 10:15:26','tempest-ServerActionsTestOtherB-volume-171613097',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:39:19','2026-01-23 10:44:04','2026-01-23 10:44:05',1,'6fd77dfa-97fc-4041-84a2-c8fe6e49c5d5',NULL,'93cd560e84264023877c47122b5919de','6e762fca3b634c7aa1d994314c059c54','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:39:20','2026-01-23 10:39:20','2026-01-23 10:44:04','tempest-AttachVolumeMultiAttachTest-volume-789925278',NULL,'{\"saved_features\":61}',NULL,NULL,'6c54b639-a8d0-4bdb-a3a9-96eb9a3c5b86',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:37:56','2026-01-23 10:44:28','2026-01-23 10:44:33',1,'707d7a47-dd85-4006-890f-724df1ffbdae',NULL,'93cd560e84264023877c47122b5919de','6e762fca3b634c7aa1d994314c059c54','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:37:57','2026-01-23 10:38:13','2026-01-23 10:44:28','tempest-AttachVolumeMultiAttachTest-volume-1785813624',NULL,'{\"saved_features\":61}',NULL,NULL,'6c54b639-a8d0-4bdb-a3a9-96eb9a3c5b86',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:21:12','2026-01-23 10:23:09','2026-01-23 10:23:09',1,'7857fc75-1658-465f-a6a1-40f608f6408e',NULL,'c041da0a601a4260b29fc9c65719597f','b976daabc8124a99814954633f99ed7b','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:21:13','2026-01-23 10:21:14','2026-01-23 10:23:09','tempest-TestMinimumBasicScenario-volume-1308236035',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:10:56','2026-01-23 10:11:15','2026-01-23 10:11:16',1,'809049fe-43c3-4fd2-a846-ff41c8b09a79',NULL,'c99d09acd2e849a69846a6ccda1e0bc7','924f976bcbb74ec195730b68eebe1f2a','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:10:56','2026-01-23 10:10:57','2026-01-23 10:11:15','tempest-AttachVolumeNegativeTest-volume-572009712',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:43:36','2026-01-23 10:44:27','2026-01-23 10:44:28',1,'837a8189-567b-4aae-b83b-e7aa7a4ff9a7',NULL,'eb70c3aee8b64273a1930c0c2c231aff','d27c5465284b48a5818ef931d6251c43','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:43:37','2026-01-23 10:43:37','2026-01-23 10:44:27','','',NULL,NULL,'aad073c6-3850-4a37-969d-b73d0ec7219a','94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:24:21','2026-01-23 10:28:44',NULL,0,'890430a6-e7b9-4647-b7ef-49be14bad5fe',NULL,'0d6a628e0dcb441fa41457bf719e65a0','5c27429e1d8f433a8a67ddb76f8798f1','hostgroup@ceph#ceph',1,'nova','available','detached','2026-01-23 10:24:21','2026-01-23 10:24:23',NULL,'ae979986-7780-443a-afbc-6b4be8f71da1-blank-vol','',NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:36:04','2026-01-23 10:37:17','2026-01-23 10:37:18',1,'8bbabf32-b7e7-4da1-b195-dac1294e522d',NULL,'9a8ce4c88e8b46c5806ada5e3a6cdbbf','d59dad6496894352a2f4c7eb66ca1914','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:36:04','2026-01-23 10:36:05','2026-01-23 10:37:17','tempest-TestStampPattern-volume-595107919',NULL,NULL,NULL,'8cf5af55-5afb-410e-a9c9-3cb0a111ab6f','94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 09:37:20','2026-01-23 09:37:55','2026-01-23 09:37:56',1,'8bf8b5e1-14c0-4be1-9734-e2610e0b9950',NULL,'726bd44b7ec443a0a4b8b632b06c622e','9f68f8c2203944c9a6e44a6756c8b4b9','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 09:37:20','2026-01-23 09:37:20','2026-01-23 09:37:55','tempest-VolumesAdminNegativeTest-volume-1537257038',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 09:50:54','2026-01-23 09:55:36','2026-01-23 09:55:38',1,'97e56534-c8f3-4b8d-bb6b-37ecd5ac131a',NULL,'28a7a778c8ab486fb586e81bb84113be','61df91981c55482fa5c9a64686c79f9e','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 09:50:54','2026-01-23 09:50:54','2026-01-23 09:55:36','tempest-DeleteServersTestJSON-volume-1207767648',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 09:52:39','2026-01-23 09:56:21','2026-01-23 09:56:22',1,'98b96f14-bdc2-414c-aaaf-7d1dfaafbfd2',NULL,'d512838ce2b44554b0566fdbb3c702b4','9bc2d47d48c446c7ae1fc44cd9c32878','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 09:52:40','2026-01-23 09:52:57','2026-01-23 09:56:21','tempest-TaggedBootDevicesTest-volume-1179343578',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:40:27','2026-01-23 10:41:09','2026-01-23 10:41:11',1,'98d92b88-169d-4578-860b-b4af33fc6e51',NULL,'eb70c3aee8b64273a1930c0c2c231aff','d27c5465284b48a5818ef931d6251c43','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:40:27','2026-01-23 10:40:38','2026-01-23 10:41:09','tempest-TestVolumeBootPattern-volume-1731104112',NULL,NULL,NULL,NULL,'3f7f137e-c525-48d6-86f7-3c39c5a7bfe7',NULL,1,NULL,NULL,'d0a00c7e-e16a-4a37-9cd5-b0d2539f706b',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 09:41:43','2026-01-23 09:43:48','2026-01-23 09:43:48',1,'99bccbe9-de42-409d-aa8f-e509f6080e7b',NULL,'187ce0cedde344a3b09ca4560410580e','4fd9229340ed4bf3a3a72baa6985a3e3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 09:41:43','2026-01-23 09:41:44','2026-01-23 09:43:48','tempest-UpdateMultiattachVolumeNegativeTest-volume-1289937063',NULL,'{\"saved_features\":61}',NULL,NULL,'6c54b639-a8d0-4bdb-a3a9-96eb9a3c5b86',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:49:55','2026-01-23 10:50:03','2026-01-23 10:50:05',1,'a2753e65-d45d-47f6-9d20-5e4e36ca8a63',NULL,'a1f4ff4112314d79bcd0d5e13b082652','47c668e58db64e6a9121fb429d3bb9aa','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:49:55','2026-01-23 10:49:55','2026-01-23 10:50:03','tempest-VolumesTestJSON-volume-649925824',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 09:52:58','2026-01-23 09:56:20','2026-01-23 09:56:21',1,'a5f913c6-cfb1-486f-bcd3-8b5237feb9b1',NULL,'d512838ce2b44554b0566fdbb3c702b4','9bc2d47d48c446c7ae1fc44cd9c32878','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 09:52:59','2026-01-23 09:52:59','2026-01-23 09:56:20','tempest-TaggedBootDevicesTest-volume-717658595',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:49:57','2026-01-23 10:50:02','2026-01-23 10:50:03',1,'aaf3200f-c36a-4d55-9406-8d435a37e41f',NULL,'a1f4ff4112314d79bcd0d5e13b082652','47c668e58db64e6a9121fb429d3bb9aa','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:49:57','2026-01-23 10:49:57','2026-01-23 10:50:02','tempest-VolumesTestJSON-volume-1308216226',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:38:35','2026-01-23 10:39:32','2026-01-23 10:39:33',1,'abf07740-6e5f-44bf-b631-41bec916b9fe',NULL,'9609ee98328640299138fa34258ef48f','95243c9b3c544aff8e9ee6043bb6f522','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:38:35','2026-01-23 10:38:36','2026-01-23 10:39:32','tempest-TestVolumeBackupRestore-volume-2109210541',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:16:26','2026-01-23 10:18:39','2026-01-23 10:18:40',1,'aee959cd-89dc-45e7-ba7b-58dc8568e292',NULL,'18f5dbf0e00d41b2b913cc1a517bc922','59cfb6a6a5ea438fb4b12029b4fcea0f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:16:26','2026-01-23 10:16:40','2026-01-23 10:18:39','tempest-tempest.common.compute-volume-327000476',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'reserved',NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:14:21','2026-01-23 10:17:53','2026-01-23 10:17:54',1,'b016d51c-9f03-4ca0-86e5-02cc8ca5059f',NULL,'95ac13194f0940128d42af3d45d130fa','3ae621f21a8e438fb95152309b38cee5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:14:21','2026-01-23 10:14:21','2026-01-23 10:17:53','tempest-TestInstancesWithCinderVolumes-volume-1214017868',NULL,NULL,NULL,NULL,'da61f832-7e99-4954-bb87-db7e35da9fdc',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 09:36:59','2026-01-23 09:38:24','2026-01-23 09:38:25',1,'b06791ec-66fd-4114-8448-7ea0b7f88f25',NULL,'4f72965e950c4761bfedd99fdc411a83','d0dce6e339c349d4ab97cee5e49fff3a','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 09:36:59','2026-01-23 09:37:09','2026-01-23 09:38:24','tempest-tempest.common.compute-volume-530259424',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:09:55','2026-01-23 10:11:18','2026-01-23 10:11:21',1,'b0abb614-0c00-40fa-9977-96c7edfc0c3c',NULL,'c99d09acd2e849a69846a6ccda1e0bc7','924f976bcbb74ec195730b68eebe1f2a','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:09:55','2026-01-23 10:09:55','2026-01-23 10:11:18','tempest-AttachVolumeNegativeTest-volume-953877424',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:26:45','2026-01-23 10:27:15','2026-01-23 10:27:18',1,'bc9f2ac6-a45e-44ec-92bc-8e8e9f030cb1',NULL,'01b7396ecc574dd6ba2df2f406921223','c7c25c6bb33b41bf9cd8febb8259fd87','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:26:45','2026-01-23 10:26:45','2026-01-23 10:27:15','tempest-AttachVolumeTestJSON-volume-1161089478',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:03:21','2026-01-23 10:07:07','2026-01-23 10:07:08',1,'bcbb40c5-2718-4ca8-8327-19725d9ddd5d',NULL,'29710db389c842df836944048225740f','8c16cd713fa74a88b43e4edf01c273bd','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:03:21','2026-01-23 10:03:21','2026-01-23 10:07:07','tempest-ServerActionsTestOtherA-volume-1104693380',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:14:22','2026-01-23 10:18:40','2026-01-23 10:18:41',1,'bdfc6219-716c-481a-916d-78de375d66c3',NULL,'95ac13194f0940128d42af3d45d130fa','3ae621f21a8e438fb95152309b38cee5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:14:23','2026-01-23 10:14:39','2026-01-23 10:18:40','tempest-TestInstancesWithCinderVolumes-volume-1583788472',NULL,NULL,NULL,NULL,'a00c6425-7526-4fff-bb9b-9014a31551bc',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:33:47','2026-01-23 10:36:10','2026-01-23 10:36:12',1,'c35b89da-3ccd-4fac-ae16-afc4a62713b5',NULL,'e1629a4b14764dddaabcadd16f3e1c1c','815b71acf60d4ed8933ebd05228fa0c0','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:33:47','2026-01-23 10:33:47','2026-01-23 10:36:10','tempest-ServerStableDeviceRescueTest-volume-1674014557',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:38:15','2026-01-23 10:39:32','2026-01-23 10:39:33',1,'c5ce5b98-2b3d-4d0d-be73-68e3c174a3f2',NULL,'9609ee98328640299138fa34258ef48f','95243c9b3c544aff8e9ee6043bb6f522','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:38:15','2026-01-23 10:38:26','2026-01-23 10:39:32','tempest-TestVolumeBackupRestore-volume-2109210541',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:14:07','2026-01-23 10:16:19','2026-01-23 10:16:19',1,'c633bb7d-c04b-4d7b-a574-1649ca824520',NULL,'fae914e59ec54f6b80928ef3cc68dbdb','0a6ba16c4b9d49d3bc24cd7b44935d1f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:14:07','2026-01-23 10:14:07','2026-01-23 10:16:19','tempest-ServerRescueNegativeTestJSON-volume-409915709',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:34:58','2026-01-23 10:37:26','2026-01-23 10:37:26',1,'cc391f04-6d6d-4c9d-866a-f0d2a56a62fb',NULL,'9a8ce4c88e8b46c5806ada5e3a6cdbbf','d59dad6496894352a2f4c7eb66ca1914','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:34:58','2026-01-23 10:34:58','2026-01-23 10:37:26','tempest-TestStampPattern-volume-394362343',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 09:41:45','2026-01-23 09:43:45','2026-01-23 09:43:46',1,'d45c600e-79eb-459a-b830-f8c8755c51e5',NULL,'187ce0cedde344a3b09ca4560410580e','4fd9229340ed4bf3a3a72baa6985a3e3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 09:41:45','2026-01-23 09:41:45','2026-01-23 09:43:45','tempest-UpdateMultiattachVolumeNegativeTest-volume-30953746',NULL,'{\"saved_features\":61}',NULL,NULL,'6c54b639-a8d0-4bdb-a3a9-96eb9a3c5b86',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:42:11','2026-01-23 10:44:42','2026-01-23 10:44:47',1,'d77d9325-542a-4716-94b2-e66e8ceab532',NULL,'eb70c3aee8b64273a1930c0c2c231aff','d27c5465284b48a5818ef931d6251c43','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:42:11','2026-01-23 10:42:19','2026-01-23 10:44:42','tempest-TestVolumeBootPattern-volume-origin-1094365002',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 09:56:40','2026-01-23 10:00:59','2026-01-23 10:01:01',1,'d7d5138e-60ed-44f2-b4e5-1e53de5cf442',NULL,'35b29e4a06884f7d88683d00f85d4630','8924c80a71a94fdeb114c6bdbdb2939c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 09:56:41','2026-01-23 09:56:52','2026-01-23 10:00:59','tempest-TaggedBootDevicesTest_v242-volume-1042844002',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:42:30','2026-01-23 10:43:46','2026-01-23 10:43:47',1,'d8ca748e-6bb8-4ae2-9729-d2be77ce520f',NULL,'93cd560e84264023877c47122b5919de','6e762fca3b634c7aa1d994314c059c54','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:42:30','2026-01-23 10:42:57','2026-01-23 10:43:46','tempest-AttachVolumeMultiAttachTest-volume-1713107603',NULL,'{\"saved_features\":61}',NULL,NULL,'6c54b639-a8d0-4bdb-a3a9-96eb9a3c5b86',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:08:51','2026-01-23 10:11:52','2026-01-23 10:11:53',1,'db8ae376-e052-4e46-9542-eddb1ef0b3ba',NULL,'cde472cc8af0464992006a69d047d0d4','746ea02b745c4e21ace4cb49c193899d','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:08:51','2026-01-23 10:08:51','2026-01-23 10:11:52','tempest-ServersNegativeTestJSON-volume-1749200970',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:45:04','2026-01-23 10:48:12','2026-01-23 10:48:14',1,'e5e1339d-ae3b-4104-9429-034d0ceea4fd',NULL,'eb70c3aee8b64273a1930c0c2c231aff','d27c5465284b48a5818ef931d6251c43','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:45:04','2026-01-23 10:45:12','2026-01-23 10:48:12','tempest-TestVolumeBootPattern-volume-origin-819536278',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:49:53','2026-01-23 10:50:05','2026-01-23 10:50:06',1,'e76f95fa-8733-479f-962c-39310ea25061',NULL,'a1f4ff4112314d79bcd0d5e13b082652','47c668e58db64e6a9121fb429d3bb9aa','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:49:53','2026-01-23 10:49:53','2026-01-23 10:50:05','tempest-VolumesTestJSON-volume-1985701293',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:14:20','2026-01-23 10:16:54','2026-01-23 10:17:00',1,'e7ae8c2b-16eb-4a7d-ae1d-2b336c442dfa',NULL,'95ac13194f0940128d42af3d45d130fa','3ae621f21a8e438fb95152309b38cee5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:14:20','2026-01-23 10:14:20','2026-01-23 10:16:54','tempest-TestInstancesWithCinderVolumes-volume-806098492',NULL,NULL,NULL,NULL,'da61f832-7e99-4954-bb87-db7e35da9fdc',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:14:20','2026-01-23 10:15:54','2026-01-23 10:15:55',1,'eb20e12a-5d9c-4034-8e50-a0b613fd5f3d',NULL,'95ac13194f0940128d42af3d45d130fa','3ae621f21a8e438fb95152309b38cee5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:14:20','2026-01-23 10:14:20','2026-01-23 10:15:54','tempest-TestInstancesWithCinderVolumes-volume-77300014',NULL,NULL,NULL,NULL,'da61f832-7e99-4954-bb87-db7e35da9fdc',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:26:39','2026-01-23 10:27:20','2026-01-23 10:27:22',1,'fd29228e-f2b9-4bc3-af15-5ec512d8169b',NULL,'01b7396ecc574dd6ba2df2f406921223','c7c25c6bb33b41bf9cd8febb8259fd87','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:26:40','2026-01-23 10:26:40','2026-01-23 10:27:20','tempest-AttachVolumeTestJSON-volume-1716935589',NULL,NULL,NULL,NULL,'94fdc3d1-d1e7-4ba7-9a59-70b4c16b4bf3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1),('2026-01-23 10:50:41','2026-01-23 10:52:10','2026-01-23 10:52:11',1,'fe67c9d0-617c-4383-b125-c4c25cee2e92',NULL,'7d7e6f562c9d4d81bf1f8d5462870e30','9533be9d361246bdb0a7c1bd3015db66','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-23 10:50:41','2026-01-23 10:50:50','2026-01-23 10:52:10','tempest-TestEncryptedCinderVolumes-volume-1485530549',NULL,NULL,NULL,NULL,'5aae1df8-11ba-4d19-82a2-3f94199799e6',NULL,0,NULL,NULL,'70457a1c-4b64-474d-8489-dd7f91885f60',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'58851732-2df3-4494-a34c-fef78c441513',0,1);
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=145 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2026-01-23 08:44:47','2026-01-23 08:44:47.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'84c0ef19-7f67-4bd3-95d8-507c3e0942ed','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/84c0ef19-7f67-4bd3-95d8-507c3e0942ed/snap','2026-01-23 09:27:30','2026-01-23 09:27:30',NULL,0,'{\"store\": \"default_backend\"}','active'),(2,'ae1f9e37-418c-462f-81d1-3599a6d89de9','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/ae1f9e37-418c-462f-81d1-3599a6d89de9/snap','2026-01-23 09:27:34','2026-01-23 09:27:34',NULL,0,'{\"store\": \"default_backend\"}','active'),(3,'317c5b81-1ed5-4e60-8bf3-e997901e644f','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/317c5b81-1ed5-4e60-8bf3-e997901e644f/snap','2026-01-23 09:34:02','2026-01-23 09:34:38','2026-01-23 09:34:38',1,'{\"store\": \"default_backend\"}','deleted'),(4,'cb273736-b860-41f6-b2fe-c26bfa105d90','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/cb273736-b860-41f6-b2fe-c26bfa105d90/snap','2026-01-23 09:35:02','2026-01-23 09:35:19','2026-01-23 09:35:19',1,'{\"store\": \"default_backend\"}','deleted'),(5,'7055985e-6eb0-4085-98fc-7fd821a237a3','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/7055985e-6eb0-4085-98fc-7fd821a237a3/snap','2026-01-23 09:36:44','2026-01-23 09:36:50','2026-01-23 09:36:50',1,'{\"store\": \"default_backend\"}','deleted'),(6,'beba0087-1685-43d4-bbc2-b6ca28939286','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/beba0087-1685-43d4-bbc2-b6ca28939286/snap','2026-01-23 09:37:01','2026-01-23 09:37:26','2026-01-23 09:37:26',1,'{\"store\": \"default_backend\"}','deleted'),(7,'cb2aa1fa-520b-4509-8a21-f3e422b84e79','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/cb2aa1fa-520b-4509-8a21-f3e422b84e79/snap','2026-01-23 09:41:00','2026-01-23 09:41:05','2026-01-23 09:41:05',1,'{\"store\": \"default_backend\"}','deleted'),(8,'de0f1f21-0106-4885-a7ac-14a7ec714eff','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/de0f1f21-0106-4885-a7ac-14a7ec714eff/snap','2026-01-23 09:41:22','2026-01-23 09:42:44','2026-01-23 09:42:44',1,'{\"store\": \"default_backend\"}','deleted'),(9,'8acf0d1a-47cb-44fb-a780-075c7b86547c','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/8acf0d1a-47cb-44fb-a780-075c7b86547c/snap','2026-01-23 09:42:08','2026-01-23 09:42:14','2026-01-23 09:42:14',1,'{\"store\": \"default_backend\"}','deleted'),(10,'565ba31d-24d7-44f1-ba74-58e1935b27b9','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/565ba31d-24d7-44f1-ba74-58e1935b27b9/snap','2026-01-23 09:42:41','2026-01-23 09:42:45','2026-01-23 09:42:45',1,'{\"store\": \"default_backend\"}','deleted'),(11,'b5a73d98-c27b-4745-95e1-6675f24e35ae','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/b5a73d98-c27b-4745-95e1-6675f24e35ae/snap','2026-01-23 09:43:11','2026-01-23 09:43:37','2026-01-23 09:43:37',1,'{\"store\": \"default_backend\"}','deleted'),(12,'985f1d15-bd4f-4eb9-b8ae-0616b8fcb8b9','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/985f1d15-bd4f-4eb9-b8ae-0616b8fcb8b9/snap','2026-01-23 09:45:15','2026-01-23 09:45:20','2026-01-23 09:45:20',1,'{\"store\": \"default_backend\"}','deleted'),(13,'975acd30-ef25-4077-8c73-a70095688223','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/975acd30-ef25-4077-8c73-a70095688223/snap','2026-01-23 09:45:28','2026-01-23 09:45:37','2026-01-23 09:45:37',1,'{\"store\": \"default_backend\"}','deleted'),(14,'44868dcf-53c3-4c3b-a7d9-2c19db7927f7','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/44868dcf-53c3-4c3b-a7d9-2c19db7927f7/snap','2026-01-23 09:45:49','2026-01-23 09:47:34','2026-01-23 09:47:34',1,'{\"store\": \"default_backend\"}','deleted'),(15,'6e41c4a9-ec96-4eb1-836b-48623204cfef','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/6e41c4a9-ec96-4eb1-836b-48623204cfef/snap','2026-01-23 09:45:53','2026-01-23 09:47:30','2026-01-23 09:47:30',1,'{\"store\": \"default_backend\"}','deleted'),(16,'beab1a9d-47f6-4028-af41-d72bcd3dcf45','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/beab1a9d-47f6-4028-af41-d72bcd3dcf45/snap','2026-01-23 09:45:58','2026-01-23 09:47:28','2026-01-23 09:47:28',1,'{\"store\": \"default_backend\"}','deleted'),(17,'a6dd6735-2531-476a-84da-d320f253f8a3','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/a6dd6735-2531-476a-84da-d320f253f8a3/snap','2026-01-23 09:46:41','2026-01-23 09:47:20','2026-01-23 09:47:20',1,'{\"store\": \"default_backend\"}','deleted'),(18,'b6586179-6c6b-4cff-8136-eeb31a27eb50','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/b6586179-6c6b-4cff-8136-eeb31a27eb50/snap','2026-01-23 09:46:52','2026-01-23 09:47:18','2026-01-23 09:47:18',1,'{\"store\": \"default_backend\"}','deleted'),(19,'8f15c480-cf5d-4aa4-933d-ac81e0da506c','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/8f15c480-cf5d-4aa4-933d-ac81e0da506c/snap','2026-01-23 09:47:02','2026-01-23 09:47:15','2026-01-23 09:47:15',1,'{\"store\": \"default_backend\"}','deleted'),(20,'1f42e74d-2b40-42bc-b3a7-8f4aab6f6bdd','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/1f42e74d-2b40-42bc-b3a7-8f4aab6f6bdd/snap','2026-01-23 09:52:28','2026-01-23 09:52:43','2026-01-23 09:52:43',1,'{\"store\": \"default_backend\"}','deleted'),(21,'c895afcd-4576-403b-b7a1-afa282118258','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/c895afcd-4576-403b-b7a1-afa282118258/snap','2026-01-23 10:08:45','2026-01-23 10:09:11','2026-01-23 10:09:11',1,'{\"store\": \"default_backend\"}','deleted'),(22,'1751577e-a4ac-4cf5-912a-f31cdff15a23','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/1751577e-a4ac-4cf5-912a-f31cdff15a23/snap','2026-01-23 10:08:55','2026-01-23 10:09:18','2026-01-23 10:09:18',1,'{\"store\": \"default_backend\"}','deleted'),(23,'6bbc8a2d-8fd2-4651-865b-0da5b89043d8','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/6bbc8a2d-8fd2-4651-865b-0da5b89043d8/snap','2026-01-23 10:09:06','2026-01-23 10:09:15','2026-01-23 10:09:15',1,'{\"store\": \"default_backend\"}','deleted'),(24,'034d6719-9097-4197-9373-c0b4b83dfc98','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/034d6719-9097-4197-9373-c0b4b83dfc98/snap','2026-01-23 10:10:29','2026-01-23 10:11:09','2026-01-23 10:11:09',1,'{\"store\": \"default_backend\"}','deleted'),(25,'6bd0071a-f3ee-4720-bcc3-909d56e7c877','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/6bd0071a-f3ee-4720-bcc3-909d56e7c877/snap','2026-01-23 10:13:38','2026-01-23 10:14:58','2026-01-23 10:14:58',1,'{\"store\": \"default_backend\"}','deleted'),(26,'91667598-4041-4c0e-ba8d-b3a19e535259','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/91667598-4041-4c0e-ba8d-b3a19e535259/snap','2026-01-23 10:14:12','2026-01-23 10:14:51','2026-01-23 10:14:51',1,'{\"store\": \"default_backend\"}','deleted'),(27,'5e615da5-21b7-41e6-bf0a-0f222139b158','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/5e615da5-21b7-41e6-bf0a-0f222139b158/snap','2026-01-23 10:14:18','2026-01-23 10:18:46','2026-01-23 10:18:46',1,'{\"store\": \"default_backend\"}','deleted'),(28,'bba8f8ac-6563-4b96-a735-670d31b1818b','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/bba8f8ac-6563-4b96-a735-670d31b1818b/snap','2026-01-23 10:19:57','2026-01-23 10:23:17','2026-01-23 10:23:17',1,'{\"store\": \"default_backend\"}','deleted'),(29,'4e1fa467-77ba-4764-82a0-700986e94bbd','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/4e1fa467-77ba-4764-82a0-700986e94bbd/snap','2026-01-23 10:23:19','2026-01-23 10:25:23','2026-01-23 10:25:23',1,'{\"store\": \"default_backend\"}','deleted'),(30,'a891f488-4cba-4fea-b482-6ac469142f81','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/a891f488-4cba-4fea-b482-6ac469142f81/snap','2026-01-23 10:24:14','2026-01-23 10:28:49','2026-01-23 10:28:49',1,'{\"store\": \"default_backend\"}','deleted'),(31,'468a5657-114a-42e3-900b-a72cd304261c','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/468a5657-114a-42e3-900b-a72cd304261c/snap','2026-01-23 10:26:38','2026-01-23 10:28:34','2026-01-23 10:28:34',1,'{\"store\": \"default_backend\"}','deleted'),(32,'81a92860-f94f-4274-aba5-1ec35fd1f681','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/81a92860-f94f-4274-aba5-1ec35fd1f681/snap','2026-01-23 10:30:29','2026-01-23 10:32:01','2026-01-23 10:32:01',1,'{\"store\": \"default_backend\"}','deleted'),(33,'33bd8321-22af-4ee8-875d-6188b12bef8e','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/33bd8321-22af-4ee8-875d-6188b12bef8e/snap','2026-01-23 10:30:39','2026-01-23 10:36:37','2026-01-23 10:36:37',1,'{\"store\": \"default_backend\"}','deleted'),(34,'45316771-2c9a-4201-a1b6-cc39488f10bc','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/45316771-2c9a-4201-a1b6-cc39488f10bc/snap','2026-01-23 10:31:44','2026-01-23 10:31:47','2026-01-23 10:31:47',1,'{\"store\": \"default_backend\"}','deleted'),(35,'e43f34d9-2c82-4fa9-94ac-56998bf2dd4a','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/e43f34d9-2c82-4fa9-94ac-56998bf2dd4a/snap','2026-01-23 10:32:04','2026-01-23 10:36:29','2026-01-23 10:36:29',1,'{\"store\": \"default_backend\"}','deleted'),(36,'562f5b35-ce71-43ca-99f2-1c1231b35c14','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/562f5b35-ce71-43ca-99f2-1c1231b35c14/snap','2026-01-23 10:33:20','2026-01-23 10:36:16','2026-01-23 10:36:16',1,'{\"store\": \"default_backend\"}','deleted'),(37,'e01877f1-023b-4adf-9357-0984581d9119','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/e01877f1-023b-4adf-9357-0984581d9119/snap','2026-01-23 10:34:46','2026-01-23 10:35:57','2026-01-23 10:35:57',1,'{\"store\": \"default_backend\"}','deleted'),(38,'60e9525a-9f0e-4c80-9c46-e7936c55e48b','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/60e9525a-9f0e-4c80-9c46-e7936c55e48b/snap','2026-01-23 10:36:03','2026-01-23 10:37:19','2026-01-23 10:37:19',1,'{\"store\": \"default_backend\"}','deleted'),(39,'a757e68d-9be5-4d20-8679-fbaf68ed4300','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/a757e68d-9be5-4d20-8679-fbaf68ed4300/snap','2026-01-23 10:43:23','2026-01-23 10:44:53','2026-01-23 10:44:53',1,'{\"store\": \"default_backend\"}','deleted'),(40,'13dd300f-265a-4d77-8204-968f335a1387','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/13dd300f-265a-4d77-8204-968f335a1387/snap','2026-01-23 10:43:38','2026-01-23 10:43:49','2026-01-23 10:43:49',1,'{\"store\": \"default_backend\"}','deleted'),(41,'a565646f-e62e-4f36-81a3-989264b3b2c8','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/a565646f-e62e-4f36-81a3-989264b3b2c8/snap','2026-01-23 10:46:09','2026-01-23 10:46:30','2026-01-23 10:46:30',1,'{\"store\": \"default_backend\"}','deleted'),(42,'2958e5e7-f8c1-4f81-af25-87197bff4d89','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/2958e5e7-f8c1-4f81-af25-87197bff4d89/snap','2026-01-23 10:48:18','2026-01-23 10:48:45','2026-01-23 10:48:45',1,'{\"store\": \"default_backend\"}','deleted'),(43,'7da2f187-f7de-4714-b817-454a50a6b19a','rbd://e1533653-0a5a-584c-b34b-8689f0d32e77/images/7da2f187-f7de-4714-b817-454a50a6b19a/snap','2026-01-23 11:13:10','2026-01-23 11:13:36','2026-01-23 11:13:36',1,'{\"store\": \"default_backend\"}','deleted');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=661 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'84c0ef19-7f67-4bd3-95d8-507c3e0942ed','hw_rng_model','virtio','2026-01-23 09:27:25','2026-01-23 09:27:25',NULL,0),(2,'ae1f9e37-418c-462f-81d1-3599a6d89de9','hw_rng_model','virtio','2026-01-23 09:27:31','2026-01-23 09:27:31',NULL,0),(3,'317c5b81-1ed5-4e60-8bf3-e997901e644f','hw_rng_model','virtio','2026-01-23 09:33:38','2026-01-23 09:34:39','2026-01-23 09:34:39',1),(4,'317c5b81-1ed5-4e60-8bf3-e997901e644f','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 09:33:38','2026-01-23 09:34:39','2026-01-23 09:34:39',1),(5,'317c5b81-1ed5-4e60-8bf3-e997901e644f','owner_user_name','tempest-UnshelveToHostMultiNodesTest-1879363435-project-member','2026-01-23 09:33:38','2026-01-23 09:34:39','2026-01-23 09:34:39',1),(6,'317c5b81-1ed5-4e60-8bf3-e997901e644f','owner_project_name','tempest-UnshelveToHostMultiNodesTest-1879363435','2026-01-23 09:33:40','2026-01-23 09:34:39','2026-01-23 09:34:39',1),(7,'317c5b81-1ed5-4e60-8bf3-e997901e644f','boot_roles','member,reader','2026-01-23 09:33:40','2026-01-23 09:34:39','2026-01-23 09:34:39',1),(8,'317c5b81-1ed5-4e60-8bf3-e997901e644f','hw_machine_type','q35','2026-01-23 09:33:40','2026-01-23 09:34:39','2026-01-23 09:34:39',1),(9,'317c5b81-1ed5-4e60-8bf3-e997901e644f','hw_cdrom_bus','sata','2026-01-23 09:33:40','2026-01-23 09:34:39','2026-01-23 09:34:39',1),(10,'317c5b81-1ed5-4e60-8bf3-e997901e644f','hw_disk_bus','virtio','2026-01-23 09:33:40','2026-01-23 09:34:39','2026-01-23 09:34:39',1),(11,'317c5b81-1ed5-4e60-8bf3-e997901e644f','hw_input_bus','usb','2026-01-23 09:33:40','2026-01-23 09:34:39','2026-01-23 09:34:39',1),(12,'317c5b81-1ed5-4e60-8bf3-e997901e644f','hw_pointer_model','usbtablet','2026-01-23 09:33:40','2026-01-23 09:34:39','2026-01-23 09:34:39',1),(13,'317c5b81-1ed5-4e60-8bf3-e997901e644f','hw_video_model','virtio','2026-01-23 09:33:40','2026-01-23 09:34:39','2026-01-23 09:34:39',1),(14,'317c5b81-1ed5-4e60-8bf3-e997901e644f','hw_vif_model','virtio','2026-01-23 09:33:40','2026-01-23 09:34:39','2026-01-23 09:34:39',1),(15,'317c5b81-1ed5-4e60-8bf3-e997901e644f','instance_uuid','641f6008-576e-4221-a1d8-33ddfca6d069','2026-01-23 09:33:40','2026-01-23 09:34:39','2026-01-23 09:34:39',1),(16,'317c5b81-1ed5-4e60-8bf3-e997901e644f','user_id','5874ba32b4a94f68aaa43252721d2fb0','2026-01-23 09:33:40','2026-01-23 09:34:39','2026-01-23 09:34:39',1),(17,'317c5b81-1ed5-4e60-8bf3-e997901e644f','image_type','snapshot','2026-01-23 09:33:40','2026-01-23 09:34:39','2026-01-23 09:34:39',1),(18,'317c5b81-1ed5-4e60-8bf3-e997901e644f','image_state','available','2026-01-23 09:33:59','2026-01-23 09:34:39','2026-01-23 09:34:39',1),(19,'317c5b81-1ed5-4e60-8bf3-e997901e644f','owner_id','307173cd6ebb4dd5ad3883dedac0271e','2026-01-23 09:33:59','2026-01-23 09:34:39','2026-01-23 09:34:39',1),(20,'317c5b81-1ed5-4e60-8bf3-e997901e644f','image_location','snapshot','2026-01-23 09:33:59','2026-01-23 09:34:39','2026-01-23 09:34:39',1),(21,'cb273736-b860-41f6-b2fe-c26bfa105d90','hw_rng_model','virtio','2026-01-23 09:34:42','2026-01-23 09:35:19','2026-01-23 09:35:19',1),(22,'cb273736-b860-41f6-b2fe-c26bfa105d90','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 09:34:42','2026-01-23 09:35:19','2026-01-23 09:35:19',1),(23,'cb273736-b860-41f6-b2fe-c26bfa105d90','owner_user_name','tempest-UnshelveToHostMultiNodesTest-1879363435-project-member','2026-01-23 09:34:42','2026-01-23 09:35:19','2026-01-23 09:35:19',1),(24,'cb273736-b860-41f6-b2fe-c26bfa105d90','owner_project_name','tempest-UnshelveToHostMultiNodesTest-1879363435','2026-01-23 09:34:42','2026-01-23 09:35:19','2026-01-23 09:35:19',1),(25,'cb273736-b860-41f6-b2fe-c26bfa105d90','boot_roles','member,reader','2026-01-23 09:34:42','2026-01-23 09:35:19','2026-01-23 09:35:19',1),(26,'cb273736-b860-41f6-b2fe-c26bfa105d90','hw_machine_type','q35','2026-01-23 09:34:42','2026-01-23 09:35:19','2026-01-23 09:35:19',1),(27,'cb273736-b860-41f6-b2fe-c26bfa105d90','hw_cdrom_bus','sata','2026-01-23 09:34:42','2026-01-23 09:35:19','2026-01-23 09:35:19',1),(28,'cb273736-b860-41f6-b2fe-c26bfa105d90','hw_disk_bus','virtio','2026-01-23 09:34:42','2026-01-23 09:35:19','2026-01-23 09:35:19',1),(29,'cb273736-b860-41f6-b2fe-c26bfa105d90','hw_input_bus','usb','2026-01-23 09:34:42','2026-01-23 09:35:19','2026-01-23 09:35:19',1),(30,'cb273736-b860-41f6-b2fe-c26bfa105d90','hw_pointer_model','usbtablet','2026-01-23 09:34:42','2026-01-23 09:35:19','2026-01-23 09:35:19',1),(31,'cb273736-b860-41f6-b2fe-c26bfa105d90','hw_video_model','virtio','2026-01-23 09:34:42','2026-01-23 09:35:19','2026-01-23 09:35:19',1),(32,'cb273736-b860-41f6-b2fe-c26bfa105d90','hw_vif_model','virtio','2026-01-23 09:34:42','2026-01-23 09:35:19','2026-01-23 09:35:19',1),(33,'cb273736-b860-41f6-b2fe-c26bfa105d90','clean_attempts','1','2026-01-23 09:34:42','2026-01-23 09:35:19','2026-01-23 09:35:19',1),(34,'cb273736-b860-41f6-b2fe-c26bfa105d90','instance_uuid','641f6008-576e-4221-a1d8-33ddfca6d069','2026-01-23 09:34:42','2026-01-23 09:35:19','2026-01-23 09:35:19',1),(35,'cb273736-b860-41f6-b2fe-c26bfa105d90','user_id','5874ba32b4a94f68aaa43252721d2fb0','2026-01-23 09:34:42','2026-01-23 09:35:19','2026-01-23 09:35:19',1),(36,'cb273736-b860-41f6-b2fe-c26bfa105d90','image_type','snapshot','2026-01-23 09:34:42','2026-01-23 09:35:19','2026-01-23 09:35:19',1),(37,'cb273736-b860-41f6-b2fe-c26bfa105d90','image_state','available','2026-01-23 09:35:01','2026-01-23 09:35:19','2026-01-23 09:35:19',1),(38,'cb273736-b860-41f6-b2fe-c26bfa105d90','owner_id','307173cd6ebb4dd5ad3883dedac0271e','2026-01-23 09:35:01','2026-01-23 09:35:19','2026-01-23 09:35:19',1),(39,'cb273736-b860-41f6-b2fe-c26bfa105d90','image_location','snapshot','2026-01-23 09:35:01','2026-01-23 09:35:19','2026-01-23 09:35:19',1),(40,'beba0087-1685-43d4-bbc2-b6ca28939286','os_version','alt1','2026-01-23 09:37:03','2026-01-23 09:37:26','2026-01-23 09:37:26',1),(41,'beba0087-1685-43d4-bbc2-b6ca28939286','os_distro','value2','2026-01-23 09:37:03','2026-01-23 09:37:26','2026-01-23 09:37:26',1),(42,'beba0087-1685-43d4-bbc2-b6ca28939286','architecture','value3','2026-01-23 09:37:15','2026-01-23 09:37:26','2026-01-23 09:37:26',1),(43,'cb2aa1fa-520b-4509-8a21-f3e422b84e79','hw_rng_model','virtio','2026-01-23 09:40:52','2026-01-23 09:41:05','2026-01-23 09:41:05',1),(44,'cb2aa1fa-520b-4509-8a21-f3e422b84e79','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 09:40:52','2026-01-23 09:41:05','2026-01-23 09:41:05',1),(45,'cb2aa1fa-520b-4509-8a21-f3e422b84e79','owner_user_name','tempest-ImagesTestJSON-1507872051-project-member','2026-01-23 09:40:52','2026-01-23 09:41:05','2026-01-23 09:41:05',1),(46,'cb2aa1fa-520b-4509-8a21-f3e422b84e79','owner_project_name','tempest-ImagesTestJSON-1507872051','2026-01-23 09:40:52','2026-01-23 09:41:05','2026-01-23 09:41:05',1),(47,'cb2aa1fa-520b-4509-8a21-f3e422b84e79','boot_roles','reader,member','2026-01-23 09:40:52','2026-01-23 09:41:05','2026-01-23 09:41:05',1),(48,'cb2aa1fa-520b-4509-8a21-f3e422b84e79','hw_machine_type','q35','2026-01-23 09:40:52','2026-01-23 09:41:05','2026-01-23 09:41:05',1),(49,'cb2aa1fa-520b-4509-8a21-f3e422b84e79','hw_cdrom_bus','sata','2026-01-23 09:40:52','2026-01-23 09:41:05','2026-01-23 09:41:05',1),(50,'cb2aa1fa-520b-4509-8a21-f3e422b84e79','hw_disk_bus','virtio','2026-01-23 09:40:52','2026-01-23 09:41:05','2026-01-23 09:41:05',1),(51,'cb2aa1fa-520b-4509-8a21-f3e422b84e79','hw_input_bus','usb','2026-01-23 09:40:52','2026-01-23 09:41:05','2026-01-23 09:41:05',1),(52,'cb2aa1fa-520b-4509-8a21-f3e422b84e79','hw_pointer_model','usbtablet','2026-01-23 09:40:52','2026-01-23 09:41:05','2026-01-23 09:41:05',1),(53,'cb2aa1fa-520b-4509-8a21-f3e422b84e79','hw_video_model','virtio','2026-01-23 09:40:52','2026-01-23 09:41:05','2026-01-23 09:41:05',1),(54,'cb2aa1fa-520b-4509-8a21-f3e422b84e79','hw_vif_model','virtio','2026-01-23 09:40:52','2026-01-23 09:41:05','2026-01-23 09:41:05',1),(55,'cb2aa1fa-520b-4509-8a21-f3e422b84e79','instance_uuid','2bf89ff4-cf8b-4ecb-ac65-d948b5039556','2026-01-23 09:40:52','2026-01-23 09:41:05','2026-01-23 09:41:05',1),(56,'cb2aa1fa-520b-4509-8a21-f3e422b84e79','user_id','56da68482e3a4fb582dcccad45f8f71b','2026-01-23 09:40:52','2026-01-23 09:41:05','2026-01-23 09:41:05',1),(57,'cb2aa1fa-520b-4509-8a21-f3e422b84e79','image_type','snapshot','2026-01-23 09:40:52','2026-01-23 09:41:05','2026-01-23 09:41:05',1),(58,'cb2aa1fa-520b-4509-8a21-f3e422b84e79','owner_id','05bc71a77710455e8b34ead7fec81a31','2026-01-23 09:40:59','2026-01-23 09:41:05','2026-01-23 09:41:05',1),(59,'cb2aa1fa-520b-4509-8a21-f3e422b84e79','image_state','available','2026-01-23 09:40:59','2026-01-23 09:41:05','2026-01-23 09:41:05',1),(60,'cb2aa1fa-520b-4509-8a21-f3e422b84e79','image_location','snapshot','2026-01-23 09:40:59','2026-01-23 09:41:05','2026-01-23 09:41:05',1),(61,'de0f1f21-0106-4885-a7ac-14a7ec714eff','hw_scsi_model','virtio-scsi','2026-01-23 09:41:16','2026-01-23 09:42:44','2026-01-23 09:42:44',1),(62,'de0f1f21-0106-4885-a7ac-14a7ec714eff','hw_disk_bus','scsi','2026-01-23 09:41:16','2026-01-23 09:42:44','2026-01-23 09:42:44',1),(63,'de0f1f21-0106-4885-a7ac-14a7ec714eff','hw_cdrom_bus','scsi','2026-01-23 09:41:16','2026-01-23 09:42:44','2026-01-23 09:42:44',1),(64,'8acf0d1a-47cb-44fb-a780-075c7b86547c','hw_rng_model','virtio','2026-01-23 09:42:00','2026-01-23 09:42:14','2026-01-23 09:42:14',1),(65,'8acf0d1a-47cb-44fb-a780-075c7b86547c','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 09:42:00','2026-01-23 09:42:14','2026-01-23 09:42:14',1),(66,'8acf0d1a-47cb-44fb-a780-075c7b86547c','owner_user_name','tempest-ImagesTestJSON-1507872051-project-member','2026-01-23 09:42:00','2026-01-23 09:42:14','2026-01-23 09:42:14',1),(67,'8acf0d1a-47cb-44fb-a780-075c7b86547c','owner_project_name','tempest-ImagesTestJSON-1507872051','2026-01-23 09:42:00','2026-01-23 09:42:14','2026-01-23 09:42:14',1),(68,'8acf0d1a-47cb-44fb-a780-075c7b86547c','boot_roles','member,reader','2026-01-23 09:42:00','2026-01-23 09:42:14','2026-01-23 09:42:14',1),(69,'8acf0d1a-47cb-44fb-a780-075c7b86547c','hw_machine_type','q35','2026-01-23 09:42:00','2026-01-23 09:42:14','2026-01-23 09:42:14',1),(70,'8acf0d1a-47cb-44fb-a780-075c7b86547c','hw_cdrom_bus','sata','2026-01-23 09:42:00','2026-01-23 09:42:14','2026-01-23 09:42:14',1),(71,'8acf0d1a-47cb-44fb-a780-075c7b86547c','hw_disk_bus','virtio','2026-01-23 09:42:00','2026-01-23 09:42:14','2026-01-23 09:42:14',1),(72,'8acf0d1a-47cb-44fb-a780-075c7b86547c','hw_input_bus','usb','2026-01-23 09:42:00','2026-01-23 09:42:14','2026-01-23 09:42:14',1),(73,'8acf0d1a-47cb-44fb-a780-075c7b86547c','hw_pointer_model','usbtablet','2026-01-23 09:42:00','2026-01-23 09:42:14','2026-01-23 09:42:14',1),(74,'8acf0d1a-47cb-44fb-a780-075c7b86547c','hw_video_model','virtio','2026-01-23 09:42:00','2026-01-23 09:42:14','2026-01-23 09:42:14',1),(75,'8acf0d1a-47cb-44fb-a780-075c7b86547c','hw_vif_model','virtio','2026-01-23 09:42:00','2026-01-23 09:42:14','2026-01-23 09:42:14',1),(76,'8acf0d1a-47cb-44fb-a780-075c7b86547c','instance_uuid','029c50ac-8221-4aa1-ab0f-92693d5d4d44','2026-01-23 09:42:00','2026-01-23 09:42:14','2026-01-23 09:42:14',1),(77,'8acf0d1a-47cb-44fb-a780-075c7b86547c','user_id','56da68482e3a4fb582dcccad45f8f71b','2026-01-23 09:42:00','2026-01-23 09:42:14','2026-01-23 09:42:14',1),(78,'8acf0d1a-47cb-44fb-a780-075c7b86547c','image_type','snapshot','2026-01-23 09:42:00','2026-01-23 09:42:14','2026-01-23 09:42:14',1),(79,'8acf0d1a-47cb-44fb-a780-075c7b86547c','image_state','available','2026-01-23 09:42:07','2026-01-23 09:42:14','2026-01-23 09:42:14',1),(80,'8acf0d1a-47cb-44fb-a780-075c7b86547c','owner_id','05bc71a77710455e8b34ead7fec81a31','2026-01-23 09:42:07','2026-01-23 09:42:14','2026-01-23 09:42:14',1),(81,'8acf0d1a-47cb-44fb-a780-075c7b86547c','image_location','snapshot','2026-01-23 09:42:07','2026-01-23 09:42:14','2026-01-23 09:42:14',1),(82,'565ba31d-24d7-44f1-ba74-58e1935b27b9','hw_rng_model','virtio','2026-01-23 09:42:33','2026-01-23 09:42:45','2026-01-23 09:42:45',1),(83,'565ba31d-24d7-44f1-ba74-58e1935b27b9','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 09:42:33','2026-01-23 09:42:45','2026-01-23 09:42:45',1),(84,'565ba31d-24d7-44f1-ba74-58e1935b27b9','owner_user_name','tempest-ImagesTestJSON-1507872051-project-member','2026-01-23 09:42:33','2026-01-23 09:42:45','2026-01-23 09:42:45',1),(85,'565ba31d-24d7-44f1-ba74-58e1935b27b9','owner_project_name','tempest-ImagesTestJSON-1507872051','2026-01-23 09:42:33','2026-01-23 09:42:45','2026-01-23 09:42:45',1),(86,'565ba31d-24d7-44f1-ba74-58e1935b27b9','boot_roles','member,reader','2026-01-23 09:42:33','2026-01-23 09:42:45','2026-01-23 09:42:45',1),(87,'565ba31d-24d7-44f1-ba74-58e1935b27b9','hw_machine_type','q35','2026-01-23 09:42:33','2026-01-23 09:42:45','2026-01-23 09:42:45',1),(88,'565ba31d-24d7-44f1-ba74-58e1935b27b9','hw_cdrom_bus','sata','2026-01-23 09:42:33','2026-01-23 09:42:45','2026-01-23 09:42:45',1),(89,'565ba31d-24d7-44f1-ba74-58e1935b27b9','hw_disk_bus','virtio','2026-01-23 09:42:33','2026-01-23 09:42:45','2026-01-23 09:42:45',1),(90,'565ba31d-24d7-44f1-ba74-58e1935b27b9','hw_input_bus','usb','2026-01-23 09:42:33','2026-01-23 09:42:45','2026-01-23 09:42:45',1),(91,'565ba31d-24d7-44f1-ba74-58e1935b27b9','hw_pointer_model','usbtablet','2026-01-23 09:42:33','2026-01-23 09:42:45','2026-01-23 09:42:45',1),(92,'565ba31d-24d7-44f1-ba74-58e1935b27b9','hw_video_model','virtio','2026-01-23 09:42:33','2026-01-23 09:42:45','2026-01-23 09:42:45',1),(93,'565ba31d-24d7-44f1-ba74-58e1935b27b9','hw_vif_model','virtio','2026-01-23 09:42:33','2026-01-23 09:42:45','2026-01-23 09:42:45',1),(94,'565ba31d-24d7-44f1-ba74-58e1935b27b9','old_vm_state','active','2026-01-23 09:42:33','2026-01-23 09:42:45','2026-01-23 09:42:45',1),(95,'565ba31d-24d7-44f1-ba74-58e1935b27b9','instance_uuid','9ec28845-a80d-489b-84e9-5d38da983cdc','2026-01-23 09:42:33','2026-01-23 09:42:45','2026-01-23 09:42:45',1),(96,'565ba31d-24d7-44f1-ba74-58e1935b27b9','user_id','56da68482e3a4fb582dcccad45f8f71b','2026-01-23 09:42:33','2026-01-23 09:42:45','2026-01-23 09:42:45',1),(97,'565ba31d-24d7-44f1-ba74-58e1935b27b9','image_type','snapshot','2026-01-23 09:42:33','2026-01-23 09:42:45','2026-01-23 09:42:45',1),(98,'565ba31d-24d7-44f1-ba74-58e1935b27b9','owner_id','05bc71a77710455e8b34ead7fec81a31','2026-01-23 09:42:40','2026-01-23 09:42:45','2026-01-23 09:42:45',1),(99,'565ba31d-24d7-44f1-ba74-58e1935b27b9','image_state','available','2026-01-23 09:42:40','2026-01-23 09:42:45','2026-01-23 09:42:45',1),(100,'565ba31d-24d7-44f1-ba74-58e1935b27b9','image_location','snapshot','2026-01-23 09:42:40','2026-01-23 09:42:45','2026-01-23 09:42:45',1),(101,'b5a73d98-c27b-4745-95e1-6675f24e35ae','hw_rng_model','virtio','2026-01-23 09:43:04','2026-01-23 09:43:37','2026-01-23 09:43:37',1),(102,'b5a73d98-c27b-4745-95e1-6675f24e35ae','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 09:43:04','2026-01-23 09:43:37','2026-01-23 09:43:37',1),(103,'b5a73d98-c27b-4745-95e1-6675f24e35ae','owner_user_name','tempest-ImagesTestJSON-1507872051-project-member','2026-01-23 09:43:04','2026-01-23 09:43:37','2026-01-23 09:43:37',1),(104,'b5a73d98-c27b-4745-95e1-6675f24e35ae','owner_project_name','tempest-ImagesTestJSON-1507872051','2026-01-23 09:43:04','2026-01-23 09:43:37','2026-01-23 09:43:37',1),(105,'b5a73d98-c27b-4745-95e1-6675f24e35ae','boot_roles','member,reader','2026-01-23 09:43:04','2026-01-23 09:43:37','2026-01-23 09:43:37',1),(106,'b5a73d98-c27b-4745-95e1-6675f24e35ae','hw_machine_type','q35','2026-01-23 09:43:04','2026-01-23 09:43:37','2026-01-23 09:43:37',1),(107,'b5a73d98-c27b-4745-95e1-6675f24e35ae','hw_cdrom_bus','sata','2026-01-23 09:43:04','2026-01-23 09:43:37','2026-01-23 09:43:37',1),(108,'b5a73d98-c27b-4745-95e1-6675f24e35ae','hw_disk_bus','virtio','2026-01-23 09:43:04','2026-01-23 09:43:37','2026-01-23 09:43:37',1),(109,'b5a73d98-c27b-4745-95e1-6675f24e35ae','hw_input_bus','usb','2026-01-23 09:43:04','2026-01-23 09:43:37','2026-01-23 09:43:37',1),(110,'b5a73d98-c27b-4745-95e1-6675f24e35ae','hw_pointer_model','usbtablet','2026-01-23 09:43:04','2026-01-23 09:43:37','2026-01-23 09:43:37',1),(111,'b5a73d98-c27b-4745-95e1-6675f24e35ae','hw_video_model','virtio','2026-01-23 09:43:04','2026-01-23 09:43:37','2026-01-23 09:43:37',1),(112,'b5a73d98-c27b-4745-95e1-6675f24e35ae','hw_vif_model','virtio','2026-01-23 09:43:04','2026-01-23 09:43:37','2026-01-23 09:43:37',1),(113,'b5a73d98-c27b-4745-95e1-6675f24e35ae','instance_uuid','47eda3a7-c47a-48cc-8381-a702e2e27bfc','2026-01-23 09:43:04','2026-01-23 09:43:37','2026-01-23 09:43:37',1),(114,'b5a73d98-c27b-4745-95e1-6675f24e35ae','user_id','56da68482e3a4fb582dcccad45f8f71b','2026-01-23 09:43:04','2026-01-23 09:43:37','2026-01-23 09:43:37',1),(115,'b5a73d98-c27b-4745-95e1-6675f24e35ae','image_type','snapshot','2026-01-23 09:43:04','2026-01-23 09:43:37','2026-01-23 09:43:37',1),(116,'b5a73d98-c27b-4745-95e1-6675f24e35ae','owner_id','05bc71a77710455e8b34ead7fec81a31','2026-01-23 09:43:10','2026-01-23 09:43:37','2026-01-23 09:43:37',1),(117,'b5a73d98-c27b-4745-95e1-6675f24e35ae','image_state','available','2026-01-23 09:43:10','2026-01-23 09:43:37','2026-01-23 09:43:37',1),(118,'b5a73d98-c27b-4745-95e1-6675f24e35ae','image_location','snapshot','2026-01-23 09:43:10','2026-01-23 09:43:37','2026-01-23 09:43:37',1),(119,'4a8fa58a-d2a5-4de0-8047-4939888c3f46','hw_rng_model','virtio','2026-01-23 09:44:02','2026-01-23 09:44:03','2026-01-23 09:44:03',1),(120,'4a8fa58a-d2a5-4de0-8047-4939888c3f46','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 09:44:02','2026-01-23 09:44:03','2026-01-23 09:44:03',1),(121,'4a8fa58a-d2a5-4de0-8047-4939888c3f46','owner_user_name','tempest-ImagesTestJSON-1507872051-project-member','2026-01-23 09:44:02','2026-01-23 09:44:03','2026-01-23 09:44:03',1),(122,'4a8fa58a-d2a5-4de0-8047-4939888c3f46','owner_project_name','tempest-ImagesTestJSON-1507872051','2026-01-23 09:44:02','2026-01-23 09:44:03','2026-01-23 09:44:03',1),(123,'4a8fa58a-d2a5-4de0-8047-4939888c3f46','boot_roles','member,reader','2026-01-23 09:44:02','2026-01-23 09:44:03','2026-01-23 09:44:03',1),(124,'4a8fa58a-d2a5-4de0-8047-4939888c3f46','hw_machine_type','q35','2026-01-23 09:44:02','2026-01-23 09:44:03','2026-01-23 09:44:03',1),(125,'4a8fa58a-d2a5-4de0-8047-4939888c3f46','hw_cdrom_bus','sata','2026-01-23 09:44:02','2026-01-23 09:44:03','2026-01-23 09:44:03',1),(126,'4a8fa58a-d2a5-4de0-8047-4939888c3f46','hw_disk_bus','virtio','2026-01-23 09:44:02','2026-01-23 09:44:03','2026-01-23 09:44:03',1),(127,'4a8fa58a-d2a5-4de0-8047-4939888c3f46','hw_input_bus','usb','2026-01-23 09:44:02','2026-01-23 09:44:03','2026-01-23 09:44:03',1),(128,'4a8fa58a-d2a5-4de0-8047-4939888c3f46','hw_pointer_model','usbtablet','2026-01-23 09:44:02','2026-01-23 09:44:03','2026-01-23 09:44:03',1),(129,'4a8fa58a-d2a5-4de0-8047-4939888c3f46','hw_video_model','virtio','2026-01-23 09:44:02','2026-01-23 09:44:03','2026-01-23 09:44:03',1),(130,'4a8fa58a-d2a5-4de0-8047-4939888c3f46','hw_vif_model','virtio','2026-01-23 09:44:02','2026-01-23 09:44:03','2026-01-23 09:44:03',1),(131,'4a8fa58a-d2a5-4de0-8047-4939888c3f46','instance_uuid','52f4c5ec-125c-4f64-86ef-2e4af50dbd4c','2026-01-23 09:44:02','2026-01-23 09:44:03','2026-01-23 09:44:03',1),(132,'4a8fa58a-d2a5-4de0-8047-4939888c3f46','user_id','56da68482e3a4fb582dcccad45f8f71b','2026-01-23 09:44:02','2026-01-23 09:44:03','2026-01-23 09:44:03',1),(133,'4a8fa58a-d2a5-4de0-8047-4939888c3f46','image_type','snapshot','2026-01-23 09:44:02','2026-01-23 09:44:03','2026-01-23 09:44:03',1),(134,'985f1d15-bd4f-4eb9-b8ae-0616b8fcb8b9','hw_rng_model','virtio','2026-01-23 09:45:09','2026-01-23 09:45:20','2026-01-23 09:45:20',1),(135,'985f1d15-bd4f-4eb9-b8ae-0616b8fcb8b9','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 09:45:09','2026-01-23 09:45:20','2026-01-23 09:45:20',1),(136,'985f1d15-bd4f-4eb9-b8ae-0616b8fcb8b9','owner_user_name','tempest-ImagesOneServerTestJSON-2122530602-project-member','2026-01-23 09:45:09','2026-01-23 09:45:20','2026-01-23 09:45:20',1),(137,'985f1d15-bd4f-4eb9-b8ae-0616b8fcb8b9','owner_project_name','tempest-ImagesOneServerTestJSON-2122530602','2026-01-23 09:45:09','2026-01-23 09:45:20','2026-01-23 09:45:20',1),(138,'985f1d15-bd4f-4eb9-b8ae-0616b8fcb8b9','boot_roles','reader,member','2026-01-23 09:45:09','2026-01-23 09:45:20','2026-01-23 09:45:20',1),(139,'985f1d15-bd4f-4eb9-b8ae-0616b8fcb8b9','hw_machine_type','q35','2026-01-23 09:45:09','2026-01-23 09:45:20','2026-01-23 09:45:20',1),(140,'985f1d15-bd4f-4eb9-b8ae-0616b8fcb8b9','hw_cdrom_bus','sata','2026-01-23 09:45:09','2026-01-23 09:45:20','2026-01-23 09:45:20',1),(141,'985f1d15-bd4f-4eb9-b8ae-0616b8fcb8b9','hw_disk_bus','virtio','2026-01-23 09:45:09','2026-01-23 09:45:20','2026-01-23 09:45:20',1),(142,'985f1d15-bd4f-4eb9-b8ae-0616b8fcb8b9','hw_input_bus','usb','2026-01-23 09:45:09','2026-01-23 09:45:20','2026-01-23 09:45:20',1),(143,'985f1d15-bd4f-4eb9-b8ae-0616b8fcb8b9','hw_pointer_model','usbtablet','2026-01-23 09:45:09','2026-01-23 09:45:20','2026-01-23 09:45:20',1),(144,'985f1d15-bd4f-4eb9-b8ae-0616b8fcb8b9','hw_video_model','virtio','2026-01-23 09:45:09','2026-01-23 09:45:20','2026-01-23 09:45:20',1),(145,'985f1d15-bd4f-4eb9-b8ae-0616b8fcb8b9','hw_vif_model','virtio','2026-01-23 09:45:09','2026-01-23 09:45:20','2026-01-23 09:45:20',1),(146,'985f1d15-bd4f-4eb9-b8ae-0616b8fcb8b9','instance_uuid','1608bb7b-ae4b-40c1-b404-16dabe957e37','2026-01-23 09:45:09','2026-01-23 09:45:20','2026-01-23 09:45:20',1),(147,'985f1d15-bd4f-4eb9-b8ae-0616b8fcb8b9','user_id','e2eb5d0826b74d23b502201e3cd116a3','2026-01-23 09:45:09','2026-01-23 09:45:20','2026-01-23 09:45:20',1),(148,'985f1d15-bd4f-4eb9-b8ae-0616b8fcb8b9','image_type','test','2026-01-23 09:45:09','2026-01-23 09:45:20','2026-01-23 09:45:20',1),(149,'985f1d15-bd4f-4eb9-b8ae-0616b8fcb8b9','image_state','available','2026-01-23 09:45:14','2026-01-23 09:45:20','2026-01-23 09:45:20',1),(150,'985f1d15-bd4f-4eb9-b8ae-0616b8fcb8b9','image_location','snapshot','2026-01-23 09:45:14','2026-01-23 09:45:20','2026-01-23 09:45:20',1),(151,'985f1d15-bd4f-4eb9-b8ae-0616b8fcb8b9','owner_id','24b47af7a3f745a7bc14b9a64c920144','2026-01-23 09:45:14','2026-01-23 09:45:20','2026-01-23 09:45:20',1),(152,'975acd30-ef25-4077-8c73-a70095688223','hw_rng_model','virtio','2026-01-23 09:45:22','2026-01-23 09:45:37','2026-01-23 09:45:37',1),(153,'975acd30-ef25-4077-8c73-a70095688223','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 09:45:22','2026-01-23 09:45:37','2026-01-23 09:45:37',1),(154,'975acd30-ef25-4077-8c73-a70095688223','owner_user_name','tempest-ImagesOneServerTestJSON-2122530602-project-member','2026-01-23 09:45:22','2026-01-23 09:45:37','2026-01-23 09:45:37',1),(155,'975acd30-ef25-4077-8c73-a70095688223','owner_project_name','tempest-ImagesOneServerTestJSON-2122530602','2026-01-23 09:45:22','2026-01-23 09:45:37','2026-01-23 09:45:37',1),(156,'975acd30-ef25-4077-8c73-a70095688223','boot_roles','reader,member','2026-01-23 09:45:22','2026-01-23 09:45:37','2026-01-23 09:45:37',1),(157,'975acd30-ef25-4077-8c73-a70095688223','hw_machine_type','q35','2026-01-23 09:45:22','2026-01-23 09:45:37','2026-01-23 09:45:37',1),(158,'975acd30-ef25-4077-8c73-a70095688223','hw_cdrom_bus','sata','2026-01-23 09:45:22','2026-01-23 09:45:37','2026-01-23 09:45:37',1),(159,'975acd30-ef25-4077-8c73-a70095688223','hw_disk_bus','virtio','2026-01-23 09:45:22','2026-01-23 09:45:37','2026-01-23 09:45:37',1),(160,'975acd30-ef25-4077-8c73-a70095688223','hw_input_bus','usb','2026-01-23 09:45:22','2026-01-23 09:45:37','2026-01-23 09:45:37',1),(161,'975acd30-ef25-4077-8c73-a70095688223','hw_pointer_model','usbtablet','2026-01-23 09:45:22','2026-01-23 09:45:37','2026-01-23 09:45:37',1),(162,'975acd30-ef25-4077-8c73-a70095688223','hw_video_model','virtio','2026-01-23 09:45:22','2026-01-23 09:45:37','2026-01-23 09:45:37',1),(163,'975acd30-ef25-4077-8c73-a70095688223','hw_vif_model','virtio','2026-01-23 09:45:22','2026-01-23 09:45:37','2026-01-23 09:45:37',1),(164,'975acd30-ef25-4077-8c73-a70095688223','instance_uuid','1608bb7b-ae4b-40c1-b404-16dabe957e37','2026-01-23 09:45:22','2026-01-23 09:45:37','2026-01-23 09:45:37',1),(165,'975acd30-ef25-4077-8c73-a70095688223','user_id','e2eb5d0826b74d23b502201e3cd116a3','2026-01-23 09:45:22','2026-01-23 09:45:37','2026-01-23 09:45:37',1),(166,'975acd30-ef25-4077-8c73-a70095688223','image_type','snapshot','2026-01-23 09:45:22','2026-01-23 09:45:37','2026-01-23 09:45:37',1),(167,'975acd30-ef25-4077-8c73-a70095688223','image_state','available','2026-01-23 09:45:27','2026-01-23 09:45:37','2026-01-23 09:45:37',1),(168,'975acd30-ef25-4077-8c73-a70095688223','image_location','snapshot','2026-01-23 09:45:27','2026-01-23 09:45:37','2026-01-23 09:45:37',1),(169,'975acd30-ef25-4077-8c73-a70095688223','owner_id','24b47af7a3f745a7bc14b9a64c920144','2026-01-23 09:45:27','2026-01-23 09:45:37','2026-01-23 09:45:37',1),(170,'a6dd6735-2531-476a-84da-d320f253f8a3','hw_rng_model','virtio','2026-01-23 09:46:34','2026-01-23 09:47:20','2026-01-23 09:47:20',1),(171,'a6dd6735-2531-476a-84da-d320f253f8a3','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 09:46:34','2026-01-23 09:47:20','2026-01-23 09:47:20',1),(172,'a6dd6735-2531-476a-84da-d320f253f8a3','owner_user_name','tempest-ListImageFiltersTestJSON-1689583115-project-member','2026-01-23 09:46:34','2026-01-23 09:47:20','2026-01-23 09:47:20',1),(173,'a6dd6735-2531-476a-84da-d320f253f8a3','owner_project_name','tempest-ListImageFiltersTestJSON-1689583115','2026-01-23 09:46:34','2026-01-23 09:47:20','2026-01-23 09:47:20',1),(174,'a6dd6735-2531-476a-84da-d320f253f8a3','boot_roles','reader,member','2026-01-23 09:46:34','2026-01-23 09:47:20','2026-01-23 09:47:20',1),(175,'a6dd6735-2531-476a-84da-d320f253f8a3','hw_machine_type','q35','2026-01-23 09:46:34','2026-01-23 09:47:20','2026-01-23 09:47:20',1),(176,'a6dd6735-2531-476a-84da-d320f253f8a3','hw_cdrom_bus','sata','2026-01-23 09:46:34','2026-01-23 09:47:20','2026-01-23 09:47:20',1),(177,'a6dd6735-2531-476a-84da-d320f253f8a3','hw_disk_bus','virtio','2026-01-23 09:46:34','2026-01-23 09:47:20','2026-01-23 09:47:20',1),(178,'a6dd6735-2531-476a-84da-d320f253f8a3','hw_input_bus','usb','2026-01-23 09:46:34','2026-01-23 09:47:20','2026-01-23 09:47:20',1),(179,'a6dd6735-2531-476a-84da-d320f253f8a3','hw_pointer_model','usbtablet','2026-01-23 09:46:34','2026-01-23 09:47:20','2026-01-23 09:47:20',1),(180,'a6dd6735-2531-476a-84da-d320f253f8a3','hw_video_model','virtio','2026-01-23 09:46:34','2026-01-23 09:47:20','2026-01-23 09:47:20',1),(181,'a6dd6735-2531-476a-84da-d320f253f8a3','hw_vif_model','virtio','2026-01-23 09:46:34','2026-01-23 09:47:20','2026-01-23 09:47:20',1),(182,'a6dd6735-2531-476a-84da-d320f253f8a3','instance_uuid','37d4741e-a7c3-49a4-ad2e-c54789bff05f','2026-01-23 09:46:34','2026-01-23 09:47:20','2026-01-23 09:47:20',1),(183,'a6dd6735-2531-476a-84da-d320f253f8a3','user_id','8d1d7c58442749759ba7dc3a19799796','2026-01-23 09:46:34','2026-01-23 09:47:20','2026-01-23 09:47:20',1),(184,'a6dd6735-2531-476a-84da-d320f253f8a3','image_type','snapshot','2026-01-23 09:46:34','2026-01-23 09:47:20','2026-01-23 09:47:20',1),(185,'a6dd6735-2531-476a-84da-d320f253f8a3','image_state','available','2026-01-23 09:46:40','2026-01-23 09:47:20','2026-01-23 09:47:20',1),(186,'a6dd6735-2531-476a-84da-d320f253f8a3','owner_id','5d69aaa276f94de98e4011fa17428b40','2026-01-23 09:46:40','2026-01-23 09:47:20','2026-01-23 09:47:20',1),(187,'a6dd6735-2531-476a-84da-d320f253f8a3','image_location','snapshot','2026-01-23 09:46:40','2026-01-23 09:47:20','2026-01-23 09:47:20',1),(188,'b6586179-6c6b-4cff-8136-eeb31a27eb50','hw_rng_model','virtio','2026-01-23 09:46:45','2026-01-23 09:47:18','2026-01-23 09:47:18',1),(189,'b6586179-6c6b-4cff-8136-eeb31a27eb50','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 09:46:45','2026-01-23 09:47:18','2026-01-23 09:47:18',1),(190,'b6586179-6c6b-4cff-8136-eeb31a27eb50','owner_user_name','tempest-ListImageFiltersTestJSON-1689583115-project-member','2026-01-23 09:46:45','2026-01-23 09:47:18','2026-01-23 09:47:18',1),(191,'b6586179-6c6b-4cff-8136-eeb31a27eb50','owner_project_name','tempest-ListImageFiltersTestJSON-1689583115','2026-01-23 09:46:45','2026-01-23 09:47:18','2026-01-23 09:47:18',1),(192,'b6586179-6c6b-4cff-8136-eeb31a27eb50','boot_roles','reader,member','2026-01-23 09:46:45','2026-01-23 09:47:18','2026-01-23 09:47:18',1),(193,'b6586179-6c6b-4cff-8136-eeb31a27eb50','hw_machine_type','q35','2026-01-23 09:46:45','2026-01-23 09:47:18','2026-01-23 09:47:18',1),(194,'b6586179-6c6b-4cff-8136-eeb31a27eb50','hw_cdrom_bus','sata','2026-01-23 09:46:45','2026-01-23 09:47:18','2026-01-23 09:47:18',1),(195,'b6586179-6c6b-4cff-8136-eeb31a27eb50','hw_disk_bus','virtio','2026-01-23 09:46:45','2026-01-23 09:47:18','2026-01-23 09:47:18',1),(196,'b6586179-6c6b-4cff-8136-eeb31a27eb50','hw_input_bus','usb','2026-01-23 09:46:45','2026-01-23 09:47:18','2026-01-23 09:47:18',1),(197,'b6586179-6c6b-4cff-8136-eeb31a27eb50','hw_pointer_model','usbtablet','2026-01-23 09:46:45','2026-01-23 09:47:18','2026-01-23 09:47:18',1),(198,'b6586179-6c6b-4cff-8136-eeb31a27eb50','hw_video_model','virtio','2026-01-23 09:46:45','2026-01-23 09:47:18','2026-01-23 09:47:18',1),(199,'b6586179-6c6b-4cff-8136-eeb31a27eb50','hw_vif_model','virtio','2026-01-23 09:46:45','2026-01-23 09:47:18','2026-01-23 09:47:18',1),(200,'b6586179-6c6b-4cff-8136-eeb31a27eb50','instance_uuid','14f26d33-78bc-4b9c-9b73-f660998601ab','2026-01-23 09:46:45','2026-01-23 09:47:18','2026-01-23 09:47:18',1),(201,'b6586179-6c6b-4cff-8136-eeb31a27eb50','user_id','8d1d7c58442749759ba7dc3a19799796','2026-01-23 09:46:45','2026-01-23 09:47:18','2026-01-23 09:47:18',1),(202,'b6586179-6c6b-4cff-8136-eeb31a27eb50','image_type','snapshot','2026-01-23 09:46:45','2026-01-23 09:47:18','2026-01-23 09:47:18',1),(203,'b6586179-6c6b-4cff-8136-eeb31a27eb50','owner_id','5d69aaa276f94de98e4011fa17428b40','2026-01-23 09:46:51','2026-01-23 09:47:18','2026-01-23 09:47:18',1),(204,'b6586179-6c6b-4cff-8136-eeb31a27eb50','image_state','available','2026-01-23 09:46:51','2026-01-23 09:47:18','2026-01-23 09:47:18',1),(205,'b6586179-6c6b-4cff-8136-eeb31a27eb50','image_location','snapshot','2026-01-23 09:46:51','2026-01-23 09:47:18','2026-01-23 09:47:18',1),(206,'8f15c480-cf5d-4aa4-933d-ac81e0da506c','hw_rng_model','virtio','2026-01-23 09:46:56','2026-01-23 09:47:15','2026-01-23 09:47:15',1),(207,'8f15c480-cf5d-4aa4-933d-ac81e0da506c','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 09:46:56','2026-01-23 09:47:15','2026-01-23 09:47:15',1),(208,'8f15c480-cf5d-4aa4-933d-ac81e0da506c','owner_user_name','tempest-ListImageFiltersTestJSON-1689583115-project-member','2026-01-23 09:46:56','2026-01-23 09:47:15','2026-01-23 09:47:15',1),(209,'8f15c480-cf5d-4aa4-933d-ac81e0da506c','owner_project_name','tempest-ListImageFiltersTestJSON-1689583115','2026-01-23 09:46:56','2026-01-23 09:47:16','2026-01-23 09:47:16',1),(210,'8f15c480-cf5d-4aa4-933d-ac81e0da506c','boot_roles','reader,member','2026-01-23 09:46:56','2026-01-23 09:47:16','2026-01-23 09:47:16',1),(211,'8f15c480-cf5d-4aa4-933d-ac81e0da506c','hw_machine_type','q35','2026-01-23 09:46:56','2026-01-23 09:47:16','2026-01-23 09:47:16',1),(212,'8f15c480-cf5d-4aa4-933d-ac81e0da506c','hw_cdrom_bus','sata','2026-01-23 09:46:56','2026-01-23 09:47:16','2026-01-23 09:47:16',1),(213,'8f15c480-cf5d-4aa4-933d-ac81e0da506c','hw_disk_bus','virtio','2026-01-23 09:46:56','2026-01-23 09:47:16','2026-01-23 09:47:16',1),(214,'8f15c480-cf5d-4aa4-933d-ac81e0da506c','hw_input_bus','usb','2026-01-23 09:46:56','2026-01-23 09:47:16','2026-01-23 09:47:16',1),(215,'8f15c480-cf5d-4aa4-933d-ac81e0da506c','hw_pointer_model','usbtablet','2026-01-23 09:46:56','2026-01-23 09:47:16','2026-01-23 09:47:16',1),(216,'8f15c480-cf5d-4aa4-933d-ac81e0da506c','hw_video_model','virtio','2026-01-23 09:46:56','2026-01-23 09:47:16','2026-01-23 09:47:16',1),(217,'8f15c480-cf5d-4aa4-933d-ac81e0da506c','hw_vif_model','virtio','2026-01-23 09:46:56','2026-01-23 09:47:16','2026-01-23 09:47:16',1),(218,'8f15c480-cf5d-4aa4-933d-ac81e0da506c','instance_uuid','37d4741e-a7c3-49a4-ad2e-c54789bff05f','2026-01-23 09:46:56','2026-01-23 09:47:16','2026-01-23 09:47:16',1),(219,'8f15c480-cf5d-4aa4-933d-ac81e0da506c','user_id','8d1d7c58442749759ba7dc3a19799796','2026-01-23 09:46:56','2026-01-23 09:47:16','2026-01-23 09:47:16',1),(220,'8f15c480-cf5d-4aa4-933d-ac81e0da506c','image_type','snapshot','2026-01-23 09:46:56','2026-01-23 09:47:16','2026-01-23 09:47:16',1),(221,'8f15c480-cf5d-4aa4-933d-ac81e0da506c','image_state','available','2026-01-23 09:47:02','2026-01-23 09:47:16','2026-01-23 09:47:16',1),(222,'8f15c480-cf5d-4aa4-933d-ac81e0da506c','owner_id','5d69aaa276f94de98e4011fa17428b40','2026-01-23 09:47:02','2026-01-23 09:47:16','2026-01-23 09:47:16',1),(223,'8f15c480-cf5d-4aa4-933d-ac81e0da506c','image_location','snapshot','2026-01-23 09:47:02','2026-01-23 09:47:16','2026-01-23 09:47:16',1),(224,'6bf97b3a-7532-45e6-8ddf-ceec1bcd88c6','hw_rng_model','virtio','2026-01-23 09:47:12','2026-01-23 09:47:12','2026-01-23 09:47:12',1),(225,'6bf97b3a-7532-45e6-8ddf-ceec1bcd88c6','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 09:47:12','2026-01-23 09:47:12','2026-01-23 09:47:12',1),(226,'6bf97b3a-7532-45e6-8ddf-ceec1bcd88c6','owner_user_name','tempest-ImagesOneServerNegativeTestJSON-1870050002-project-member','2026-01-23 09:47:12','2026-01-23 09:47:12','2026-01-23 09:47:12',1),(227,'6bf97b3a-7532-45e6-8ddf-ceec1bcd88c6','owner_project_name','tempest-ImagesOneServerNegativeTestJSON-1870050002','2026-01-23 09:47:12','2026-01-23 09:47:12','2026-01-23 09:47:12',1),(228,'6bf97b3a-7532-45e6-8ddf-ceec1bcd88c6','boot_roles','reader,member','2026-01-23 09:47:12','2026-01-23 09:47:12','2026-01-23 09:47:12',1),(229,'6bf97b3a-7532-45e6-8ddf-ceec1bcd88c6','hw_machine_type','q35','2026-01-23 09:47:12','2026-01-23 09:47:12','2026-01-23 09:47:12',1),(230,'6bf97b3a-7532-45e6-8ddf-ceec1bcd88c6','hw_cdrom_bus','sata','2026-01-23 09:47:12','2026-01-23 09:47:12','2026-01-23 09:47:12',1),(231,'6bf97b3a-7532-45e6-8ddf-ceec1bcd88c6','hw_disk_bus','virtio','2026-01-23 09:47:12','2026-01-23 09:47:12','2026-01-23 09:47:12',1),(232,'6bf97b3a-7532-45e6-8ddf-ceec1bcd88c6','hw_input_bus','usb','2026-01-23 09:47:12','2026-01-23 09:47:12','2026-01-23 09:47:12',1),(233,'6bf97b3a-7532-45e6-8ddf-ceec1bcd88c6','hw_pointer_model','usbtablet','2026-01-23 09:47:12','2026-01-23 09:47:12','2026-01-23 09:47:12',1),(234,'6bf97b3a-7532-45e6-8ddf-ceec1bcd88c6','hw_video_model','virtio','2026-01-23 09:47:12','2026-01-23 09:47:12','2026-01-23 09:47:12',1),(235,'6bf97b3a-7532-45e6-8ddf-ceec1bcd88c6','hw_vif_model','virtio','2026-01-23 09:47:12','2026-01-23 09:47:12','2026-01-23 09:47:12',1),(236,'6bf97b3a-7532-45e6-8ddf-ceec1bcd88c6','instance_uuid','ccb9c4ce-3766-49d2-94e5-88a46bcc07b6','2026-01-23 09:47:12','2026-01-23 09:47:12','2026-01-23 09:47:12',1),(237,'6bf97b3a-7532-45e6-8ddf-ceec1bcd88c6','user_id','ae77ac206ed246b49262982455564c01','2026-01-23 09:47:12','2026-01-23 09:47:12','2026-01-23 09:47:12',1),(238,'6bf97b3a-7532-45e6-8ddf-ceec1bcd88c6','image_type','snapshot','2026-01-23 09:47:12','2026-01-23 09:47:12','2026-01-23 09:47:12',1),(239,'4741efb0-ac27-4eb3-af8a-63929f9ec3e2','hw_rng_model','virtio','2026-01-23 09:47:53','2026-01-23 09:47:53','2026-01-23 09:47:53',1),(240,'4741efb0-ac27-4eb3-af8a-63929f9ec3e2','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 09:47:53','2026-01-23 09:47:53','2026-01-23 09:47:53',1),(241,'4741efb0-ac27-4eb3-af8a-63929f9ec3e2','owner_user_name','tempest-ImagesOneServerNegativeTestJSON-1870050002-project-member','2026-01-23 09:47:53','2026-01-23 09:47:53','2026-01-23 09:47:53',1),(242,'4741efb0-ac27-4eb3-af8a-63929f9ec3e2','owner_project_name','tempest-ImagesOneServerNegativeTestJSON-1870050002','2026-01-23 09:47:53','2026-01-23 09:47:53','2026-01-23 09:47:53',1),(243,'4741efb0-ac27-4eb3-af8a-63929f9ec3e2','boot_roles','reader,member','2026-01-23 09:47:53','2026-01-23 09:47:54','2026-01-23 09:47:54',1),(244,'4741efb0-ac27-4eb3-af8a-63929f9ec3e2','hw_machine_type','q35','2026-01-23 09:47:53','2026-01-23 09:47:54','2026-01-23 09:47:54',1),(245,'4741efb0-ac27-4eb3-af8a-63929f9ec3e2','hw_cdrom_bus','sata','2026-01-23 09:47:53','2026-01-23 09:47:54','2026-01-23 09:47:54',1),(246,'4741efb0-ac27-4eb3-af8a-63929f9ec3e2','hw_disk_bus','virtio','2026-01-23 09:47:53','2026-01-23 09:47:54','2026-01-23 09:47:54',1),(247,'4741efb0-ac27-4eb3-af8a-63929f9ec3e2','hw_input_bus','usb','2026-01-23 09:47:53','2026-01-23 09:47:54','2026-01-23 09:47:54',1),(248,'4741efb0-ac27-4eb3-af8a-63929f9ec3e2','hw_pointer_model','usbtablet','2026-01-23 09:47:53','2026-01-23 09:47:54','2026-01-23 09:47:54',1),(249,'4741efb0-ac27-4eb3-af8a-63929f9ec3e2','hw_video_model','virtio','2026-01-23 09:47:53','2026-01-23 09:47:54','2026-01-23 09:47:54',1),(250,'4741efb0-ac27-4eb3-af8a-63929f9ec3e2','hw_vif_model','virtio','2026-01-23 09:47:53','2026-01-23 09:47:54','2026-01-23 09:47:54',1),(251,'4741efb0-ac27-4eb3-af8a-63929f9ec3e2','instance_uuid','98913b45-a388-4bef-ad03-aed41edbdb44','2026-01-23 09:47:53','2026-01-23 09:47:54','2026-01-23 09:47:54',1),(252,'4741efb0-ac27-4eb3-af8a-63929f9ec3e2','user_id','ae77ac206ed246b49262982455564c01','2026-01-23 09:47:53','2026-01-23 09:47:54','2026-01-23 09:47:54',1),(253,'4741efb0-ac27-4eb3-af8a-63929f9ec3e2','image_type','snapshot','2026-01-23 09:47:53','2026-01-23 09:47:54','2026-01-23 09:47:54',1),(254,'1f42e74d-2b40-42bc-b3a7-8f4aab6f6bdd','hw_rng_model','virtio','2026-01-23 09:52:03','2026-01-23 09:52:44','2026-01-23 09:52:44',1),(255,'1f42e74d-2b40-42bc-b3a7-8f4aab6f6bdd','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 09:52:03','2026-01-23 09:52:44','2026-01-23 09:52:44',1),(256,'1f42e74d-2b40-42bc-b3a7-8f4aab6f6bdd','owner_user_name','tempest-DeleteServersTestJSON-944070453-project-member','2026-01-23 09:52:03','2026-01-23 09:52:44','2026-01-23 09:52:44',1),(257,'1f42e74d-2b40-42bc-b3a7-8f4aab6f6bdd','owner_project_name','tempest-DeleteServersTestJSON-944070453','2026-01-23 09:52:03','2026-01-23 09:52:44','2026-01-23 09:52:44',1),(258,'1f42e74d-2b40-42bc-b3a7-8f4aab6f6bdd','boot_roles','reader,member','2026-01-23 09:52:03','2026-01-23 09:52:44','2026-01-23 09:52:44',1),(259,'1f42e74d-2b40-42bc-b3a7-8f4aab6f6bdd','hw_machine_type','q35','2026-01-23 09:52:03','2026-01-23 09:52:44','2026-01-23 09:52:44',1),(260,'1f42e74d-2b40-42bc-b3a7-8f4aab6f6bdd','hw_cdrom_bus','sata','2026-01-23 09:52:03','2026-01-23 09:52:44','2026-01-23 09:52:44',1),(261,'1f42e74d-2b40-42bc-b3a7-8f4aab6f6bdd','hw_disk_bus','virtio','2026-01-23 09:52:03','2026-01-23 09:52:44','2026-01-23 09:52:44',1),(262,'1f42e74d-2b40-42bc-b3a7-8f4aab6f6bdd','hw_input_bus','usb','2026-01-23 09:52:03','2026-01-23 09:52:44','2026-01-23 09:52:44',1),(263,'1f42e74d-2b40-42bc-b3a7-8f4aab6f6bdd','hw_pointer_model','usbtablet','2026-01-23 09:52:03','2026-01-23 09:52:44','2026-01-23 09:52:44',1),(264,'1f42e74d-2b40-42bc-b3a7-8f4aab6f6bdd','hw_video_model','virtio','2026-01-23 09:52:03','2026-01-23 09:52:44','2026-01-23 09:52:44',1),(265,'1f42e74d-2b40-42bc-b3a7-8f4aab6f6bdd','hw_vif_model','virtio','2026-01-23 09:52:03','2026-01-23 09:52:44','2026-01-23 09:52:44',1),(266,'1f42e74d-2b40-42bc-b3a7-8f4aab6f6bdd','instance_uuid','2821a66b-54cd-4ffc-9b8f-317909716a0c','2026-01-23 09:52:03','2026-01-23 09:52:44','2026-01-23 09:52:44',1),(267,'1f42e74d-2b40-42bc-b3a7-8f4aab6f6bdd','user_id','28a7a778c8ab486fb586e81bb84113be','2026-01-23 09:52:03','2026-01-23 09:52:44','2026-01-23 09:52:44',1),(268,'1f42e74d-2b40-42bc-b3a7-8f4aab6f6bdd','image_type','snapshot','2026-01-23 09:52:03','2026-01-23 09:52:44','2026-01-23 09:52:44',1),(269,'1f42e74d-2b40-42bc-b3a7-8f4aab6f6bdd','owner_id','61df91981c55482fa5c9a64686c79f9e','2026-01-23 09:52:27','2026-01-23 09:52:44','2026-01-23 09:52:44',1),(270,'1f42e74d-2b40-42bc-b3a7-8f4aab6f6bdd','image_state','available','2026-01-23 09:52:27','2026-01-23 09:52:44','2026-01-23 09:52:44',1),(271,'1f42e74d-2b40-42bc-b3a7-8f4aab6f6bdd','image_location','snapshot','2026-01-23 09:52:27','2026-01-23 09:52:44','2026-01-23 09:52:44',1),(272,'282072bc-dd1c-4ade-92e2-a8e019b5132d','hw_rng_model','virtio','2026-01-23 10:03:36','2026-01-23 10:03:37','2026-01-23 10:03:37',1),(273,'282072bc-dd1c-4ade-92e2-a8e019b5132d','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 10:03:36','2026-01-23 10:03:37','2026-01-23 10:03:37',1),(274,'282072bc-dd1c-4ade-92e2-a8e019b5132d','owner_user_name','tempest-ServersAaction247Test-1955277360-project-member','2026-01-23 10:03:36','2026-01-23 10:03:37','2026-01-23 10:03:37',1),(275,'282072bc-dd1c-4ade-92e2-a8e019b5132d','owner_project_name','tempest-ServersAaction247Test-1955277360','2026-01-23 10:03:36','2026-01-23 10:03:37','2026-01-23 10:03:37',1),(276,'282072bc-dd1c-4ade-92e2-a8e019b5132d','boot_roles','reader,member','2026-01-23 10:03:36','2026-01-23 10:03:37','2026-01-23 10:03:37',1),(277,'282072bc-dd1c-4ade-92e2-a8e019b5132d','hw_machine_type','q35','2026-01-23 10:03:36','2026-01-23 10:03:37','2026-01-23 10:03:37',1),(278,'282072bc-dd1c-4ade-92e2-a8e019b5132d','hw_cdrom_bus','sata','2026-01-23 10:03:36','2026-01-23 10:03:37','2026-01-23 10:03:37',1),(279,'282072bc-dd1c-4ade-92e2-a8e019b5132d','hw_disk_bus','virtio','2026-01-23 10:03:36','2026-01-23 10:03:37','2026-01-23 10:03:37',1),(280,'282072bc-dd1c-4ade-92e2-a8e019b5132d','hw_input_bus','usb','2026-01-23 10:03:36','2026-01-23 10:03:37','2026-01-23 10:03:37',1),(281,'282072bc-dd1c-4ade-92e2-a8e019b5132d','hw_pointer_model','usbtablet','2026-01-23 10:03:36','2026-01-23 10:03:37','2026-01-23 10:03:37',1),(282,'282072bc-dd1c-4ade-92e2-a8e019b5132d','hw_video_model','virtio','2026-01-23 10:03:36','2026-01-23 10:03:37','2026-01-23 10:03:37',1),(283,'282072bc-dd1c-4ade-92e2-a8e019b5132d','hw_vif_model','virtio','2026-01-23 10:03:36','2026-01-23 10:03:37','2026-01-23 10:03:37',1),(284,'282072bc-dd1c-4ade-92e2-a8e019b5132d','instance_uuid','a145fd79-f99f-49e9-9e3e-bb7605cb8e1e','2026-01-23 10:03:36','2026-01-23 10:03:37','2026-01-23 10:03:37',1),(285,'282072bc-dd1c-4ade-92e2-a8e019b5132d','user_id','175c8371597942d18b2ec02e7010ddbf','2026-01-23 10:03:36','2026-01-23 10:03:37','2026-01-23 10:03:37',1),(286,'282072bc-dd1c-4ade-92e2-a8e019b5132d','image_type','backup','2026-01-23 10:03:36','2026-01-23 10:03:37','2026-01-23 10:03:37',1),(287,'282072bc-dd1c-4ade-92e2-a8e019b5132d','backup_type','daily','2026-01-23 10:03:36','2026-01-23 10:03:37','2026-01-23 10:03:37',1),(288,'c895afcd-4576-403b-b7a1-afa282118258','hw_rng_model','virtio','2026-01-23 10:08:38','2026-01-23 10:09:11','2026-01-23 10:09:11',1),(289,'c895afcd-4576-403b-b7a1-afa282118258','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 10:08:38','2026-01-23 10:09:11','2026-01-23 10:09:11',1),(290,'c895afcd-4576-403b-b7a1-afa282118258','owner_user_name','tempest-ServerActionsTestOtherB-1052932467-project-member','2026-01-23 10:08:38','2026-01-23 10:09:11','2026-01-23 10:09:11',1),(291,'c895afcd-4576-403b-b7a1-afa282118258','owner_project_name','tempest-ServerActionsTestOtherB-1052932467','2026-01-23 10:08:38','2026-01-23 10:09:11','2026-01-23 10:09:11',1),(292,'c895afcd-4576-403b-b7a1-afa282118258','boot_roles','member,reader','2026-01-23 10:08:38','2026-01-23 10:09:11','2026-01-23 10:09:11',1),(293,'c895afcd-4576-403b-b7a1-afa282118258','hw_machine_type','q35','2026-01-23 10:08:38','2026-01-23 10:09:11','2026-01-23 10:09:11',1),(294,'c895afcd-4576-403b-b7a1-afa282118258','hw_cdrom_bus','sata','2026-01-23 10:08:38','2026-01-23 10:09:11','2026-01-23 10:09:11',1),(295,'c895afcd-4576-403b-b7a1-afa282118258','hw_disk_bus','virtio','2026-01-23 10:08:38','2026-01-23 10:09:11','2026-01-23 10:09:11',1),(296,'c895afcd-4576-403b-b7a1-afa282118258','hw_input_bus','usb','2026-01-23 10:08:38','2026-01-23 10:09:11','2026-01-23 10:09:11',1),(297,'c895afcd-4576-403b-b7a1-afa282118258','hw_pointer_model','usbtablet','2026-01-23 10:08:38','2026-01-23 10:09:11','2026-01-23 10:09:11',1),(298,'c895afcd-4576-403b-b7a1-afa282118258','hw_video_model','virtio','2026-01-23 10:08:38','2026-01-23 10:09:11','2026-01-23 10:09:11',1),(299,'c895afcd-4576-403b-b7a1-afa282118258','hw_vif_model','virtio','2026-01-23 10:08:38','2026-01-23 10:09:11','2026-01-23 10:09:11',1),(300,'c895afcd-4576-403b-b7a1-afa282118258','instance_uuid','81a8be01-ddd9-4fd2-91a1-886e7f47bfa3','2026-01-23 10:08:38','2026-01-23 10:09:11','2026-01-23 10:09:11',1),(301,'c895afcd-4576-403b-b7a1-afa282118258','user_id','aca3cab576d641d3b89e7dddf155d467','2026-01-23 10:08:38','2026-01-23 10:09:11','2026-01-23 10:09:11',1),(302,'c895afcd-4576-403b-b7a1-afa282118258','image_type','backup','2026-01-23 10:08:38','2026-01-23 10:09:11','2026-01-23 10:09:11',1),(303,'c895afcd-4576-403b-b7a1-afa282118258','backup_type','daily','2026-01-23 10:08:38','2026-01-23 10:09:11','2026-01-23 10:09:11',1),(304,'c895afcd-4576-403b-b7a1-afa282118258','image_state','available','2026-01-23 10:08:43','2026-01-23 10:09:11','2026-01-23 10:09:11',1),(305,'c895afcd-4576-403b-b7a1-afa282118258','owner_id','9dd869ce76e44fc8a82b8bbee1654d33','2026-01-23 10:08:43','2026-01-23 10:09:11','2026-01-23 10:09:11',1),(306,'c895afcd-4576-403b-b7a1-afa282118258','image_location','snapshot','2026-01-23 10:08:43','2026-01-23 10:09:11','2026-01-23 10:09:11',1),(307,'1751577e-a4ac-4cf5-912a-f31cdff15a23','hw_rng_model','virtio','2026-01-23 10:08:48','2026-01-23 10:09:18','2026-01-23 10:09:18',1),(308,'1751577e-a4ac-4cf5-912a-f31cdff15a23','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 10:08:48','2026-01-23 10:09:18','2026-01-23 10:09:18',1),(309,'1751577e-a4ac-4cf5-912a-f31cdff15a23','owner_user_name','tempest-ServerActionsTestOtherB-1052932467-project-member','2026-01-23 10:08:48','2026-01-23 10:09:18','2026-01-23 10:09:18',1),(310,'1751577e-a4ac-4cf5-912a-f31cdff15a23','owner_project_name','tempest-ServerActionsTestOtherB-1052932467','2026-01-23 10:08:48','2026-01-23 10:09:18','2026-01-23 10:09:18',1),(311,'1751577e-a4ac-4cf5-912a-f31cdff15a23','boot_roles','member,reader','2026-01-23 10:08:48','2026-01-23 10:09:18','2026-01-23 10:09:18',1),(312,'1751577e-a4ac-4cf5-912a-f31cdff15a23','hw_machine_type','q35','2026-01-23 10:08:48','2026-01-23 10:09:18','2026-01-23 10:09:18',1),(313,'1751577e-a4ac-4cf5-912a-f31cdff15a23','hw_cdrom_bus','sata','2026-01-23 10:08:48','2026-01-23 10:09:18','2026-01-23 10:09:18',1),(314,'1751577e-a4ac-4cf5-912a-f31cdff15a23','hw_disk_bus','virtio','2026-01-23 10:08:48','2026-01-23 10:09:18','2026-01-23 10:09:18',1),(315,'1751577e-a4ac-4cf5-912a-f31cdff15a23','hw_input_bus','usb','2026-01-23 10:08:48','2026-01-23 10:09:18','2026-01-23 10:09:18',1),(316,'1751577e-a4ac-4cf5-912a-f31cdff15a23','hw_pointer_model','usbtablet','2026-01-23 10:08:48','2026-01-23 10:09:18','2026-01-23 10:09:18',1),(317,'1751577e-a4ac-4cf5-912a-f31cdff15a23','hw_video_model','virtio','2026-01-23 10:08:48','2026-01-23 10:09:18','2026-01-23 10:09:18',1),(318,'1751577e-a4ac-4cf5-912a-f31cdff15a23','hw_vif_model','virtio','2026-01-23 10:08:48','2026-01-23 10:09:18','2026-01-23 10:09:18',1),(319,'1751577e-a4ac-4cf5-912a-f31cdff15a23','instance_uuid','81a8be01-ddd9-4fd2-91a1-886e7f47bfa3','2026-01-23 10:08:48','2026-01-23 10:09:18','2026-01-23 10:09:18',1),(320,'1751577e-a4ac-4cf5-912a-f31cdff15a23','user_id','aca3cab576d641d3b89e7dddf155d467','2026-01-23 10:08:48','2026-01-23 10:09:18','2026-01-23 10:09:18',1),(321,'1751577e-a4ac-4cf5-912a-f31cdff15a23','image_type','backup','2026-01-23 10:08:48','2026-01-23 10:09:18','2026-01-23 10:09:18',1),(322,'1751577e-a4ac-4cf5-912a-f31cdff15a23','backup_type','daily','2026-01-23 10:08:48','2026-01-23 10:09:18','2026-01-23 10:09:18',1),(323,'1751577e-a4ac-4cf5-912a-f31cdff15a23','image_state','available','2026-01-23 10:08:52','2026-01-23 10:09:18','2026-01-23 10:09:18',1),(324,'1751577e-a4ac-4cf5-912a-f31cdff15a23','owner_id','9dd869ce76e44fc8a82b8bbee1654d33','2026-01-23 10:08:52','2026-01-23 10:09:18','2026-01-23 10:09:18',1),(325,'1751577e-a4ac-4cf5-912a-f31cdff15a23','image_location','snapshot','2026-01-23 10:08:52','2026-01-23 10:09:18','2026-01-23 10:09:18',1),(326,'6bbc8a2d-8fd2-4651-865b-0da5b89043d8','hw_rng_model','virtio','2026-01-23 10:08:58','2026-01-23 10:09:15','2026-01-23 10:09:15',1),(327,'6bbc8a2d-8fd2-4651-865b-0da5b89043d8','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 10:08:58','2026-01-23 10:09:15','2026-01-23 10:09:15',1),(328,'6bbc8a2d-8fd2-4651-865b-0da5b89043d8','owner_user_name','tempest-ServerActionsTestOtherB-1052932467-project-member','2026-01-23 10:08:58','2026-01-23 10:09:15','2026-01-23 10:09:15',1),(329,'6bbc8a2d-8fd2-4651-865b-0da5b89043d8','owner_project_name','tempest-ServerActionsTestOtherB-1052932467','2026-01-23 10:08:58','2026-01-23 10:09:15','2026-01-23 10:09:15',1),(330,'6bbc8a2d-8fd2-4651-865b-0da5b89043d8','boot_roles','member,reader','2026-01-23 10:08:58','2026-01-23 10:09:15','2026-01-23 10:09:15',1),(331,'6bbc8a2d-8fd2-4651-865b-0da5b89043d8','hw_machine_type','q35','2026-01-23 10:08:58','2026-01-23 10:09:15','2026-01-23 10:09:15',1),(332,'6bbc8a2d-8fd2-4651-865b-0da5b89043d8','hw_cdrom_bus','sata','2026-01-23 10:08:58','2026-01-23 10:09:15','2026-01-23 10:09:15',1),(333,'6bbc8a2d-8fd2-4651-865b-0da5b89043d8','hw_disk_bus','virtio','2026-01-23 10:08:58','2026-01-23 10:09:15','2026-01-23 10:09:15',1),(334,'6bbc8a2d-8fd2-4651-865b-0da5b89043d8','hw_input_bus','usb','2026-01-23 10:08:58','2026-01-23 10:09:15','2026-01-23 10:09:15',1),(335,'6bbc8a2d-8fd2-4651-865b-0da5b89043d8','hw_pointer_model','usbtablet','2026-01-23 10:08:58','2026-01-23 10:09:15','2026-01-23 10:09:15',1),(336,'6bbc8a2d-8fd2-4651-865b-0da5b89043d8','hw_video_model','virtio','2026-01-23 10:08:58','2026-01-23 10:09:15','2026-01-23 10:09:15',1),(337,'6bbc8a2d-8fd2-4651-865b-0da5b89043d8','hw_vif_model','virtio','2026-01-23 10:08:58','2026-01-23 10:09:15','2026-01-23 10:09:15',1),(338,'6bbc8a2d-8fd2-4651-865b-0da5b89043d8','instance_uuid','81a8be01-ddd9-4fd2-91a1-886e7f47bfa3','2026-01-23 10:08:58','2026-01-23 10:09:15','2026-01-23 10:09:15',1),(339,'6bbc8a2d-8fd2-4651-865b-0da5b89043d8','user_id','aca3cab576d641d3b89e7dddf155d467','2026-01-23 10:08:58','2026-01-23 10:09:15','2026-01-23 10:09:15',1),(340,'6bbc8a2d-8fd2-4651-865b-0da5b89043d8','image_type','backup','2026-01-23 10:08:58','2026-01-23 10:09:15','2026-01-23 10:09:15',1),(341,'6bbc8a2d-8fd2-4651-865b-0da5b89043d8','backup_type','daily','2026-01-23 10:08:58','2026-01-23 10:09:15','2026-01-23 10:09:15',1),(342,'6bbc8a2d-8fd2-4651-865b-0da5b89043d8','image_state','available','2026-01-23 10:09:05','2026-01-23 10:09:15','2026-01-23 10:09:15',1),(343,'6bbc8a2d-8fd2-4651-865b-0da5b89043d8','owner_id','9dd869ce76e44fc8a82b8bbee1654d33','2026-01-23 10:09:05','2026-01-23 10:09:15','2026-01-23 10:09:15',1),(344,'6bbc8a2d-8fd2-4651-865b-0da5b89043d8','image_location','snapshot','2026-01-23 10:09:05','2026-01-23 10:09:15','2026-01-23 10:09:15',1),(345,'034d6719-9097-4197-9373-c0b4b83dfc98','hw_rng_model','virtio','2026-01-23 10:10:20','2026-01-23 10:11:10','2026-01-23 10:11:10',1),(346,'034d6719-9097-4197-9373-c0b4b83dfc98','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 10:10:20','2026-01-23 10:11:10','2026-01-23 10:11:10',1),(347,'034d6719-9097-4197-9373-c0b4b83dfc98','owner_user_name','tempest-ServersNegativeTestJSON-623507515-project-member','2026-01-23 10:10:20','2026-01-23 10:11:10','2026-01-23 10:11:10',1),(348,'034d6719-9097-4197-9373-c0b4b83dfc98','owner_project_name','tempest-ServersNegativeTestJSON-623507515','2026-01-23 10:10:20','2026-01-23 10:11:10','2026-01-23 10:11:10',1),(349,'034d6719-9097-4197-9373-c0b4b83dfc98','boot_roles','reader,member','2026-01-23 10:10:20','2026-01-23 10:11:10','2026-01-23 10:11:10',1),(350,'034d6719-9097-4197-9373-c0b4b83dfc98','hw_machine_type','q35','2026-01-23 10:10:20','2026-01-23 10:11:10','2026-01-23 10:11:10',1),(351,'034d6719-9097-4197-9373-c0b4b83dfc98','hw_cdrom_bus','sata','2026-01-23 10:10:20','2026-01-23 10:11:10','2026-01-23 10:11:10',1),(352,'034d6719-9097-4197-9373-c0b4b83dfc98','hw_disk_bus','virtio','2026-01-23 10:10:20','2026-01-23 10:11:10','2026-01-23 10:11:10',1),(353,'034d6719-9097-4197-9373-c0b4b83dfc98','hw_input_bus','usb','2026-01-23 10:10:20','2026-01-23 10:11:10','2026-01-23 10:11:10',1),(354,'034d6719-9097-4197-9373-c0b4b83dfc98','hw_pointer_model','usbtablet','2026-01-23 10:10:20','2026-01-23 10:11:10','2026-01-23 10:11:10',1),(355,'034d6719-9097-4197-9373-c0b4b83dfc98','hw_video_model','virtio','2026-01-23 10:10:20','2026-01-23 10:11:10','2026-01-23 10:11:10',1),(356,'034d6719-9097-4197-9373-c0b4b83dfc98','hw_vif_model','virtio','2026-01-23 10:10:20','2026-01-23 10:11:10','2026-01-23 10:11:10',1),(357,'034d6719-9097-4197-9373-c0b4b83dfc98','instance_uuid','91cc1048-141a-4a20-b148-991a883adfa9','2026-01-23 10:10:20','2026-01-23 10:11:10','2026-01-23 10:11:10',1),(358,'034d6719-9097-4197-9373-c0b4b83dfc98','user_id','cde472cc8af0464992006a69d047d0d4','2026-01-23 10:10:20','2026-01-23 10:11:10','2026-01-23 10:11:10',1),(359,'034d6719-9097-4197-9373-c0b4b83dfc98','image_type','snapshot','2026-01-23 10:10:20','2026-01-23 10:11:10','2026-01-23 10:11:10',1),(360,'034d6719-9097-4197-9373-c0b4b83dfc98','owner_id','746ea02b745c4e21ace4cb49c193899d','2026-01-23 10:10:28','2026-01-23 10:11:10','2026-01-23 10:11:10',1),(361,'034d6719-9097-4197-9373-c0b4b83dfc98','image_state','available','2026-01-23 10:10:28','2026-01-23 10:11:10','2026-01-23 10:11:10',1),(362,'034d6719-9097-4197-9373-c0b4b83dfc98','image_location','snapshot','2026-01-23 10:10:28','2026-01-23 10:11:10','2026-01-23 10:11:10',1),(363,'6bd0071a-f3ee-4720-bcc3-909d56e7c877','hw_rng_model','virtio','2026-01-23 10:13:32','2026-01-23 10:14:59','2026-01-23 10:14:59',1),(364,'6bd0071a-f3ee-4720-bcc3-909d56e7c877','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 10:13:32','2026-01-23 10:14:59','2026-01-23 10:14:59',1),(365,'6bd0071a-f3ee-4720-bcc3-909d56e7c877','owner_user_name','tempest-ServerActionsTestOtherB-1052932467-project-member','2026-01-23 10:13:32','2026-01-23 10:14:59','2026-01-23 10:14:59',1),(366,'6bd0071a-f3ee-4720-bcc3-909d56e7c877','owner_project_name','tempest-ServerActionsTestOtherB-1052932467','2026-01-23 10:13:32','2026-01-23 10:14:59','2026-01-23 10:14:59',1),(367,'6bd0071a-f3ee-4720-bcc3-909d56e7c877','boot_roles','reader,member','2026-01-23 10:13:32','2026-01-23 10:14:59','2026-01-23 10:14:59',1),(368,'6bd0071a-f3ee-4720-bcc3-909d56e7c877','hw_machine_type','q35','2026-01-23 10:13:32','2026-01-23 10:14:59','2026-01-23 10:14:59',1),(369,'6bd0071a-f3ee-4720-bcc3-909d56e7c877','hw_cdrom_bus','sata','2026-01-23 10:13:32','2026-01-23 10:14:59','2026-01-23 10:14:59',1),(370,'6bd0071a-f3ee-4720-bcc3-909d56e7c877','hw_disk_bus','virtio','2026-01-23 10:13:32','2026-01-23 10:14:59','2026-01-23 10:14:59',1),(371,'6bd0071a-f3ee-4720-bcc3-909d56e7c877','hw_input_bus','usb','2026-01-23 10:13:32','2026-01-23 10:14:59','2026-01-23 10:14:59',1),(372,'6bd0071a-f3ee-4720-bcc3-909d56e7c877','hw_pointer_model','usbtablet','2026-01-23 10:13:32','2026-01-23 10:14:59','2026-01-23 10:14:59',1),(373,'6bd0071a-f3ee-4720-bcc3-909d56e7c877','hw_video_model','virtio','2026-01-23 10:13:32','2026-01-23 10:14:59','2026-01-23 10:14:59',1),(374,'6bd0071a-f3ee-4720-bcc3-909d56e7c877','hw_vif_model','virtio','2026-01-23 10:13:32','2026-01-23 10:14:59','2026-01-23 10:14:59',1),(375,'6bd0071a-f3ee-4720-bcc3-909d56e7c877','instance_uuid','74fc0ca6-968a-48e2-8496-f53ebb50daf0','2026-01-23 10:13:32','2026-01-23 10:14:59','2026-01-23 10:14:59',1),(376,'6bd0071a-f3ee-4720-bcc3-909d56e7c877','user_id','aca3cab576d641d3b89e7dddf155d467','2026-01-23 10:13:32','2026-01-23 10:14:59','2026-01-23 10:14:59',1),(377,'6bd0071a-f3ee-4720-bcc3-909d56e7c877','image_type','snapshot','2026-01-23 10:13:32','2026-01-23 10:14:59','2026-01-23 10:14:59',1),(378,'6bd0071a-f3ee-4720-bcc3-909d56e7c877','image_state','available','2026-01-23 10:13:38','2026-01-23 10:14:59','2026-01-23 10:14:59',1),(379,'6bd0071a-f3ee-4720-bcc3-909d56e7c877','owner_id','9dd869ce76e44fc8a82b8bbee1654d33','2026-01-23 10:13:38','2026-01-23 10:14:59','2026-01-23 10:14:59',1),(380,'6bd0071a-f3ee-4720-bcc3-909d56e7c877','image_location','snapshot','2026-01-23 10:13:38','2026-01-23 10:14:59','2026-01-23 10:14:59',1),(381,'91667598-4041-4c0e-ba8d-b3a19e535259','hw_rng_model','virtio','2026-01-23 10:14:03','2026-01-23 10:14:51','2026-01-23 10:14:51',1),(382,'91667598-4041-4c0e-ba8d-b3a19e535259','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 10:14:03','2026-01-23 10:14:51','2026-01-23 10:14:51',1),(383,'91667598-4041-4c0e-ba8d-b3a19e535259','owner_user_name','tempest-ServerActionsTestOtherB-1052932467-project-member','2026-01-23 10:14:03','2026-01-23 10:14:51','2026-01-23 10:14:51',1),(384,'91667598-4041-4c0e-ba8d-b3a19e535259','owner_project_name','tempest-ServerActionsTestOtherB-1052932467','2026-01-23 10:14:03','2026-01-23 10:14:51','2026-01-23 10:14:51',1),(385,'91667598-4041-4c0e-ba8d-b3a19e535259','boot_roles','reader,member','2026-01-23 10:14:03','2026-01-23 10:14:51','2026-01-23 10:14:51',1),(386,'91667598-4041-4c0e-ba8d-b3a19e535259','hw_machine_type','q35','2026-01-23 10:14:03','2026-01-23 10:14:51','2026-01-23 10:14:51',1),(387,'91667598-4041-4c0e-ba8d-b3a19e535259','hw_cdrom_bus','sata','2026-01-23 10:14:03','2026-01-23 10:14:51','2026-01-23 10:14:51',1),(388,'91667598-4041-4c0e-ba8d-b3a19e535259','hw_disk_bus','virtio','2026-01-23 10:14:03','2026-01-23 10:14:51','2026-01-23 10:14:51',1),(389,'91667598-4041-4c0e-ba8d-b3a19e535259','hw_input_bus','usb','2026-01-23 10:14:03','2026-01-23 10:14:51','2026-01-23 10:14:51',1),(390,'91667598-4041-4c0e-ba8d-b3a19e535259','hw_pointer_model','usbtablet','2026-01-23 10:14:03','2026-01-23 10:14:51','2026-01-23 10:14:51',1),(391,'91667598-4041-4c0e-ba8d-b3a19e535259','hw_video_model','virtio','2026-01-23 10:14:03','2026-01-23 10:14:51','2026-01-23 10:14:51',1),(392,'91667598-4041-4c0e-ba8d-b3a19e535259','hw_vif_model','virtio','2026-01-23 10:14:03','2026-01-23 10:14:51','2026-01-23 10:14:51',1),(393,'91667598-4041-4c0e-ba8d-b3a19e535259','instance_uuid','33559028-00d9-4918-9015-26172db3d00c','2026-01-23 10:14:03','2026-01-23 10:14:51','2026-01-23 10:14:51',1),(394,'91667598-4041-4c0e-ba8d-b3a19e535259','user_id','aca3cab576d641d3b89e7dddf155d467','2026-01-23 10:14:03','2026-01-23 10:14:51','2026-01-23 10:14:51',1),(395,'91667598-4041-4c0e-ba8d-b3a19e535259','image_type','snapshot','2026-01-23 10:14:03','2026-01-23 10:14:51','2026-01-23 10:14:51',1),(396,'91667598-4041-4c0e-ba8d-b3a19e535259','image_state','available','2026-01-23 10:14:11','2026-01-23 10:14:51','2026-01-23 10:14:51',1),(397,'91667598-4041-4c0e-ba8d-b3a19e535259','image_location','snapshot','2026-01-23 10:14:11','2026-01-23 10:14:51','2026-01-23 10:14:51',1),(398,'91667598-4041-4c0e-ba8d-b3a19e535259','owner_id','9dd869ce76e44fc8a82b8bbee1654d33','2026-01-23 10:14:11','2026-01-23 10:14:51','2026-01-23 10:14:51',1),(399,'a891f488-4cba-4fea-b482-6ac469142f81','hw_rng_model','virtio','2026-01-23 10:24:08','2026-01-23 10:28:49','2026-01-23 10:28:49',1),(400,'a891f488-4cba-4fea-b482-6ac469142f81','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 10:24:08','2026-01-23 10:28:49','2026-01-23 10:28:49',1),(401,'a891f488-4cba-4fea-b482-6ac469142f81','owner_user_name','tempest-ServerBootFromVolumeStableRescueTest-1351337832-project-member','2026-01-23 10:24:08','2026-01-23 10:28:49','2026-01-23 10:28:49',1),(402,'a891f488-4cba-4fea-b482-6ac469142f81','owner_project_name','tempest-ServerBootFromVolumeStableRescueTest-1351337832','2026-01-23 10:24:08','2026-01-23 10:28:49','2026-01-23 10:28:49',1),(403,'a891f488-4cba-4fea-b482-6ac469142f81','boot_roles','reader,member','2026-01-23 10:24:08','2026-01-23 10:28:49','2026-01-23 10:28:49',1),(404,'a891f488-4cba-4fea-b482-6ac469142f81','hw_machine_type','q35','2026-01-23 10:24:08','2026-01-23 10:28:49','2026-01-23 10:28:49',1),(405,'a891f488-4cba-4fea-b482-6ac469142f81','hw_cdrom_bus','sata','2026-01-23 10:24:08','2026-01-23 10:28:49','2026-01-23 10:28:49',1),(406,'a891f488-4cba-4fea-b482-6ac469142f81','hw_disk_bus','virtio','2026-01-23 10:24:08','2026-01-23 10:28:49','2026-01-23 10:28:49',1),(407,'a891f488-4cba-4fea-b482-6ac469142f81','hw_input_bus','usb','2026-01-23 10:24:08','2026-01-23 10:28:49','2026-01-23 10:28:49',1),(408,'a891f488-4cba-4fea-b482-6ac469142f81','hw_pointer_model','usbtablet','2026-01-23 10:24:08','2026-01-23 10:28:49','2026-01-23 10:28:49',1),(409,'a891f488-4cba-4fea-b482-6ac469142f81','hw_video_model','virtio','2026-01-23 10:24:08','2026-01-23 10:28:49','2026-01-23 10:28:49',1),(410,'a891f488-4cba-4fea-b482-6ac469142f81','hw_vif_model','virtio','2026-01-23 10:24:08','2026-01-23 10:28:49','2026-01-23 10:28:49',1),(411,'a891f488-4cba-4fea-b482-6ac469142f81','instance_uuid','4b43bf7c-8fc3-4ea4-9401-283826c9ed39','2026-01-23 10:24:08','2026-01-23 10:28:49','2026-01-23 10:28:49',1),(412,'a891f488-4cba-4fea-b482-6ac469142f81','user_id','0d6a628e0dcb441fa41457bf719e65a0','2026-01-23 10:24:08','2026-01-23 10:28:49','2026-01-23 10:28:49',1),(413,'a891f488-4cba-4fea-b482-6ac469142f81','image_type','snapshot','2026-01-23 10:24:08','2026-01-23 10:28:49','2026-01-23 10:28:49',1),(414,'a891f488-4cba-4fea-b482-6ac469142f81','owner_id','5c27429e1d8f433a8a67ddb76f8798f1','2026-01-23 10:24:13','2026-01-23 10:28:49','2026-01-23 10:28:49',1),(415,'a891f488-4cba-4fea-b482-6ac469142f81','image_state','available','2026-01-23 10:24:13','2026-01-23 10:28:49','2026-01-23 10:28:49',1),(416,'a891f488-4cba-4fea-b482-6ac469142f81','image_location','snapshot','2026-01-23 10:24:13','2026-01-23 10:28:49','2026-01-23 10:28:49',1),(417,'a891f488-4cba-4fea-b482-6ac469142f81','hw_rescue_bus','virtio','2026-01-23 10:24:43','2026-01-23 10:28:49','2026-01-23 10:28:49',1),(418,'a891f488-4cba-4fea-b482-6ac469142f81','hw_rescue_device','disk','2026-01-23 10:24:44','2026-01-23 10:28:49','2026-01-23 10:28:49',1),(419,'468a5657-114a-42e3-900b-a72cd304261c','hw_rng_model','virtio','2026-01-23 10:26:32','2026-01-23 10:28:34','2026-01-23 10:28:34',1),(420,'468a5657-114a-42e3-900b-a72cd304261c','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 10:26:32','2026-01-23 10:28:34','2026-01-23 10:28:34',1),(421,'468a5657-114a-42e3-900b-a72cd304261c','owner_user_name','tempest-ServerBootFromVolumeStableRescueTest-1351337832-project-member','2026-01-23 10:26:32','2026-01-23 10:28:34','2026-01-23 10:28:34',1),(422,'468a5657-114a-42e3-900b-a72cd304261c','owner_project_name','tempest-ServerBootFromVolumeStableRescueTest-1351337832','2026-01-23 10:26:32','2026-01-23 10:28:34','2026-01-23 10:28:34',1),(423,'468a5657-114a-42e3-900b-a72cd304261c','boot_roles','member,reader','2026-01-23 10:26:32','2026-01-23 10:28:34','2026-01-23 10:28:34',1),(424,'468a5657-114a-42e3-900b-a72cd304261c','hw_machine_type','q35','2026-01-23 10:26:32','2026-01-23 10:28:34','2026-01-23 10:28:34',1),(425,'468a5657-114a-42e3-900b-a72cd304261c','hw_cdrom_bus','sata','2026-01-23 10:26:32','2026-01-23 10:28:34','2026-01-23 10:28:34',1),(426,'468a5657-114a-42e3-900b-a72cd304261c','hw_disk_bus','virtio','2026-01-23 10:26:32','2026-01-23 10:28:34','2026-01-23 10:28:34',1),(427,'468a5657-114a-42e3-900b-a72cd304261c','hw_input_bus','usb','2026-01-23 10:26:32','2026-01-23 10:28:34','2026-01-23 10:28:34',1),(428,'468a5657-114a-42e3-900b-a72cd304261c','hw_pointer_model','usbtablet','2026-01-23 10:26:32','2026-01-23 10:28:34','2026-01-23 10:28:34',1),(429,'468a5657-114a-42e3-900b-a72cd304261c','hw_video_model','virtio','2026-01-23 10:26:32','2026-01-23 10:28:34','2026-01-23 10:28:34',1),(430,'468a5657-114a-42e3-900b-a72cd304261c','hw_vif_model','virtio','2026-01-23 10:26:32','2026-01-23 10:28:34','2026-01-23 10:28:34',1),(431,'468a5657-114a-42e3-900b-a72cd304261c','instance_uuid','da8fd4b4-46c3-412e-aeeb-499a3fec1bc5','2026-01-23 10:26:32','2026-01-23 10:28:34','2026-01-23 10:28:34',1),(432,'468a5657-114a-42e3-900b-a72cd304261c','user_id','0d6a628e0dcb441fa41457bf719e65a0','2026-01-23 10:26:32','2026-01-23 10:28:34','2026-01-23 10:28:34',1),(433,'468a5657-114a-42e3-900b-a72cd304261c','image_type','snapshot','2026-01-23 10:26:32','2026-01-23 10:28:34','2026-01-23 10:28:34',1),(434,'468a5657-114a-42e3-900b-a72cd304261c','image_state','available','2026-01-23 10:26:38','2026-01-23 10:28:34','2026-01-23 10:28:34',1),(435,'468a5657-114a-42e3-900b-a72cd304261c','owner_id','5c27429e1d8f433a8a67ddb76f8798f1','2026-01-23 10:26:38','2026-01-23 10:28:34','2026-01-23 10:28:34',1),(436,'468a5657-114a-42e3-900b-a72cd304261c','image_location','snapshot','2026-01-23 10:26:38','2026-01-23 10:28:34','2026-01-23 10:28:34',1),(437,'468a5657-114a-42e3-900b-a72cd304261c','hw_rescue_bus','virtio','2026-01-23 10:27:19','2026-01-23 10:28:34','2026-01-23 10:28:34',1),(438,'468a5657-114a-42e3-900b-a72cd304261c','hw_rescue_device','disk','2026-01-23 10:27:19','2026-01-23 10:28:34','2026-01-23 10:28:34',1),(439,'81a92860-f94f-4274-aba5-1ec35fd1f681','hw_rng_model','virtio','2026-01-23 10:30:19','2026-01-23 10:32:02','2026-01-23 10:32:02',1),(440,'81a92860-f94f-4274-aba5-1ec35fd1f681','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 10:30:19','2026-01-23 10:32:02','2026-01-23 10:32:02',1),(441,'81a92860-f94f-4274-aba5-1ec35fd1f681','owner_user_name','tempest-TestSnapshotPattern-428739353-project-member','2026-01-23 10:30:19','2026-01-23 10:32:02','2026-01-23 10:32:02',1),(442,'81a92860-f94f-4274-aba5-1ec35fd1f681','owner_project_name','tempest-TestSnapshotPattern-428739353','2026-01-23 10:30:19','2026-01-23 10:32:02','2026-01-23 10:32:02',1),(443,'81a92860-f94f-4274-aba5-1ec35fd1f681','boot_roles','reader,member','2026-01-23 10:30:19','2026-01-23 10:32:02','2026-01-23 10:32:02',1),(444,'81a92860-f94f-4274-aba5-1ec35fd1f681','hw_machine_type','q35','2026-01-23 10:30:19','2026-01-23 10:32:02','2026-01-23 10:32:02',1),(445,'81a92860-f94f-4274-aba5-1ec35fd1f681','hw_cdrom_bus','sata','2026-01-23 10:30:19','2026-01-23 10:32:02','2026-01-23 10:32:02',1),(446,'81a92860-f94f-4274-aba5-1ec35fd1f681','hw_disk_bus','virtio','2026-01-23 10:30:19','2026-01-23 10:32:02','2026-01-23 10:32:02',1),(447,'81a92860-f94f-4274-aba5-1ec35fd1f681','hw_input_bus','usb','2026-01-23 10:30:19','2026-01-23 10:32:02','2026-01-23 10:32:02',1),(448,'81a92860-f94f-4274-aba5-1ec35fd1f681','hw_pointer_model','usbtablet','2026-01-23 10:30:19','2026-01-23 10:32:02','2026-01-23 10:32:02',1),(449,'81a92860-f94f-4274-aba5-1ec35fd1f681','hw_video_model','virtio','2026-01-23 10:30:19','2026-01-23 10:32:02','2026-01-23 10:32:02',1),(450,'81a92860-f94f-4274-aba5-1ec35fd1f681','hw_vif_model','virtio','2026-01-23 10:30:19','2026-01-23 10:32:02','2026-01-23 10:32:02',1),(451,'81a92860-f94f-4274-aba5-1ec35fd1f681','instance_uuid','713eba08-716b-48ed-866e-e231d09ebfaf','2026-01-23 10:30:19','2026-01-23 10:32:02','2026-01-23 10:32:02',1),(452,'81a92860-f94f-4274-aba5-1ec35fd1f681','user_id','8e1f41f21f79408d8dff1331cfd1e0db','2026-01-23 10:30:19','2026-01-23 10:32:02','2026-01-23 10:32:02',1),(453,'81a92860-f94f-4274-aba5-1ec35fd1f681','image_type','snapshot','2026-01-23 10:30:19','2026-01-23 10:32:02','2026-01-23 10:32:02',1),(454,'81a92860-f94f-4274-aba5-1ec35fd1f681','image_state','available','2026-01-23 10:30:28','2026-01-23 10:32:02','2026-01-23 10:32:02',1),(455,'81a92860-f94f-4274-aba5-1ec35fd1f681','owner_id','7be5cb5abaf44b0a9c0c307d348d8f75','2026-01-23 10:30:28','2026-01-23 10:32:02','2026-01-23 10:32:02',1),(456,'81a92860-f94f-4274-aba5-1ec35fd1f681','image_location','snapshot','2026-01-23 10:30:28','2026-01-23 10:32:02','2026-01-23 10:32:02',1),(457,'33bd8321-22af-4ee8-875d-6188b12bef8e','hw_rng_model','virtio','2026-01-23 10:30:30','2026-01-23 10:36:38','2026-01-23 10:36:38',1),(458,'33bd8321-22af-4ee8-875d-6188b12bef8e','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 10:30:30','2026-01-23 10:36:38','2026-01-23 10:36:38',1),(459,'33bd8321-22af-4ee8-875d-6188b12bef8e','owner_user_name','tempest-ServerStableDeviceRescueTest-1802220041-project-member','2026-01-23 10:30:30','2026-01-23 10:36:38','2026-01-23 10:36:38',1),(460,'33bd8321-22af-4ee8-875d-6188b12bef8e','owner_project_name','tempest-ServerStableDeviceRescueTest-1802220041','2026-01-23 10:30:30','2026-01-23 10:36:38','2026-01-23 10:36:38',1),(461,'33bd8321-22af-4ee8-875d-6188b12bef8e','boot_roles','member,reader','2026-01-23 10:30:30','2026-01-23 10:36:38','2026-01-23 10:36:38',1),(462,'33bd8321-22af-4ee8-875d-6188b12bef8e','hw_machine_type','q35','2026-01-23 10:30:30','2026-01-23 10:36:38','2026-01-23 10:36:38',1),(463,'33bd8321-22af-4ee8-875d-6188b12bef8e','hw_cdrom_bus','sata','2026-01-23 10:30:30','2026-01-23 10:36:38','2026-01-23 10:36:38',1),(464,'33bd8321-22af-4ee8-875d-6188b12bef8e','hw_disk_bus','virtio','2026-01-23 10:30:30','2026-01-23 10:36:38','2026-01-23 10:36:38',1),(465,'33bd8321-22af-4ee8-875d-6188b12bef8e','hw_input_bus','usb','2026-01-23 10:30:31','2026-01-23 10:36:38','2026-01-23 10:36:38',1),(466,'33bd8321-22af-4ee8-875d-6188b12bef8e','hw_pointer_model','usbtablet','2026-01-23 10:30:31','2026-01-23 10:36:38','2026-01-23 10:36:38',1),(467,'33bd8321-22af-4ee8-875d-6188b12bef8e','hw_video_model','virtio','2026-01-23 10:30:31','2026-01-23 10:36:38','2026-01-23 10:36:38',1),(468,'33bd8321-22af-4ee8-875d-6188b12bef8e','hw_vif_model','virtio','2026-01-23 10:30:31','2026-01-23 10:36:38','2026-01-23 10:36:38',1),(469,'33bd8321-22af-4ee8-875d-6188b12bef8e','instance_uuid','64ccc062-b11b-4cbc-96ba-620e43dfdb20','2026-01-23 10:30:31','2026-01-23 10:36:38','2026-01-23 10:36:38',1),(470,'33bd8321-22af-4ee8-875d-6188b12bef8e','user_id','e1629a4b14764dddaabcadd16f3e1c1c','2026-01-23 10:30:31','2026-01-23 10:36:38','2026-01-23 10:36:38',1),(471,'33bd8321-22af-4ee8-875d-6188b12bef8e','image_type','snapshot','2026-01-23 10:30:31','2026-01-23 10:36:38','2026-01-23 10:36:38',1),(472,'81a92860-f94f-4274-aba5-1ec35fd1f681','version','8.0','2026-01-23 10:30:31','2026-01-23 10:32:02','2026-01-23 10:32:02',1),(473,'33bd8321-22af-4ee8-875d-6188b12bef8e','image_state','available','2026-01-23 10:30:36','2026-01-23 10:36:38','2026-01-23 10:36:38',1),(474,'33bd8321-22af-4ee8-875d-6188b12bef8e','image_location','snapshot','2026-01-23 10:30:36','2026-01-23 10:36:38','2026-01-23 10:36:38',1),(475,'33bd8321-22af-4ee8-875d-6188b12bef8e','owner_id','815b71acf60d4ed8933ebd05228fa0c0','2026-01-23 10:30:36','2026-01-23 10:36:38','2026-01-23 10:36:38',1),(476,'33bd8321-22af-4ee8-875d-6188b12bef8e','hw_rescue_bus','scsi','2026-01-23 10:30:43','2026-01-23 10:36:38','2026-01-23 10:36:38',1),(477,'33bd8321-22af-4ee8-875d-6188b12bef8e','hw_rescue_device','disk','2026-01-23 10:30:44','2026-01-23 10:36:38','2026-01-23 10:36:38',1),(478,'45316771-2c9a-4201-a1b6-cc39488f10bc','hw_rng_model','virtio','2026-01-23 10:31:34','2026-01-23 10:31:47','2026-01-23 10:31:47',1),(479,'45316771-2c9a-4201-a1b6-cc39488f10bc','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 10:31:34','2026-01-23 10:31:47','2026-01-23 10:31:47',1),(480,'45316771-2c9a-4201-a1b6-cc39488f10bc','owner_user_name','tempest-TestSnapshotPattern-428739353-project-member','2026-01-23 10:31:34','2026-01-23 10:31:47','2026-01-23 10:31:47',1),(481,'45316771-2c9a-4201-a1b6-cc39488f10bc','owner_project_name','tempest-TestSnapshotPattern-428739353','2026-01-23 10:31:34','2026-01-23 10:31:47','2026-01-23 10:31:47',1),(482,'45316771-2c9a-4201-a1b6-cc39488f10bc','boot_roles','reader,member','2026-01-23 10:31:34','2026-01-23 10:31:47','2026-01-23 10:31:47',1),(483,'45316771-2c9a-4201-a1b6-cc39488f10bc','hw_machine_type','q35','2026-01-23 10:31:34','2026-01-23 10:31:47','2026-01-23 10:31:47',1),(484,'45316771-2c9a-4201-a1b6-cc39488f10bc','hw_cdrom_bus','sata','2026-01-23 10:31:34','2026-01-23 10:31:47','2026-01-23 10:31:47',1),(485,'45316771-2c9a-4201-a1b6-cc39488f10bc','hw_disk_bus','virtio','2026-01-23 10:31:34','2026-01-23 10:31:47','2026-01-23 10:31:47',1),(486,'45316771-2c9a-4201-a1b6-cc39488f10bc','hw_input_bus','usb','2026-01-23 10:31:34','2026-01-23 10:31:47','2026-01-23 10:31:47',1),(487,'45316771-2c9a-4201-a1b6-cc39488f10bc','hw_pointer_model','usbtablet','2026-01-23 10:31:34','2026-01-23 10:31:47','2026-01-23 10:31:47',1),(488,'45316771-2c9a-4201-a1b6-cc39488f10bc','hw_video_model','virtio','2026-01-23 10:31:34','2026-01-23 10:31:47','2026-01-23 10:31:47',1),(489,'45316771-2c9a-4201-a1b6-cc39488f10bc','hw_vif_model','virtio','2026-01-23 10:31:34','2026-01-23 10:31:47','2026-01-23 10:31:47',1),(490,'45316771-2c9a-4201-a1b6-cc39488f10bc','instance_uuid','6ed27eef-aee3-4b7d-a31f-8b7d753a25b9','2026-01-23 10:31:34','2026-01-23 10:31:47','2026-01-23 10:31:47',1),(491,'45316771-2c9a-4201-a1b6-cc39488f10bc','user_id','8e1f41f21f79408d8dff1331cfd1e0db','2026-01-23 10:31:34','2026-01-23 10:31:47','2026-01-23 10:31:47',1),(492,'45316771-2c9a-4201-a1b6-cc39488f10bc','image_type','snapshot','2026-01-23 10:31:34','2026-01-23 10:31:47','2026-01-23 10:31:47',1),(493,'45316771-2c9a-4201-a1b6-cc39488f10bc','image_state','available','2026-01-23 10:31:34','2026-01-23 10:31:47','2026-01-23 10:31:47',1),(494,'45316771-2c9a-4201-a1b6-cc39488f10bc','owner_id','7be5cb5abaf44b0a9c0c307d348d8f75','2026-01-23 10:31:34','2026-01-23 10:31:47','2026-01-23 10:31:47',1),(495,'45316771-2c9a-4201-a1b6-cc39488f10bc','image_location','snapshot','2026-01-23 10:31:34','2026-01-23 10:31:47','2026-01-23 10:31:47',1),(496,'45316771-2c9a-4201-a1b6-cc39488f10bc','version','8.0','2026-01-23 10:31:34','2026-01-23 10:31:47','2026-01-23 10:31:47',1),(497,'e43f34d9-2c82-4fa9-94ac-56998bf2dd4a','hw_rng_model','virtio','2026-01-23 10:31:52','2026-01-23 10:36:29','2026-01-23 10:36:29',1),(498,'e43f34d9-2c82-4fa9-94ac-56998bf2dd4a','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 10:31:52','2026-01-23 10:36:29','2026-01-23 10:36:29',1),(499,'e43f34d9-2c82-4fa9-94ac-56998bf2dd4a','owner_user_name','tempest-ServerStableDeviceRescueTest-1802220041-project-member','2026-01-23 10:31:52','2026-01-23 10:36:29','2026-01-23 10:36:29',1),(500,'e43f34d9-2c82-4fa9-94ac-56998bf2dd4a','owner_project_name','tempest-ServerStableDeviceRescueTest-1802220041','2026-01-23 10:31:52','2026-01-23 10:36:29','2026-01-23 10:36:29',1),(501,'e43f34d9-2c82-4fa9-94ac-56998bf2dd4a','boot_roles','member,reader','2026-01-23 10:31:52','2026-01-23 10:36:29','2026-01-23 10:36:29',1),(502,'e43f34d9-2c82-4fa9-94ac-56998bf2dd4a','hw_machine_type','q35','2026-01-23 10:31:52','2026-01-23 10:36:29','2026-01-23 10:36:29',1),(503,'e43f34d9-2c82-4fa9-94ac-56998bf2dd4a','hw_cdrom_bus','sata','2026-01-23 10:31:52','2026-01-23 10:36:29','2026-01-23 10:36:29',1),(504,'e43f34d9-2c82-4fa9-94ac-56998bf2dd4a','hw_disk_bus','virtio','2026-01-23 10:31:52','2026-01-23 10:36:29','2026-01-23 10:36:29',1),(505,'e43f34d9-2c82-4fa9-94ac-56998bf2dd4a','hw_input_bus','usb','2026-01-23 10:31:52','2026-01-23 10:36:29','2026-01-23 10:36:29',1),(506,'e43f34d9-2c82-4fa9-94ac-56998bf2dd4a','hw_pointer_model','usbtablet','2026-01-23 10:31:52','2026-01-23 10:36:29','2026-01-23 10:36:29',1),(507,'e43f34d9-2c82-4fa9-94ac-56998bf2dd4a','hw_video_model','virtio','2026-01-23 10:31:52','2026-01-23 10:36:29','2026-01-23 10:36:29',1),(508,'e43f34d9-2c82-4fa9-94ac-56998bf2dd4a','hw_vif_model','virtio','2026-01-23 10:31:52','2026-01-23 10:36:29','2026-01-23 10:36:29',1),(509,'e43f34d9-2c82-4fa9-94ac-56998bf2dd4a','instance_uuid','23f7c54d-ed5d-404f-8517-b5cd21d0c282','2026-01-23 10:31:52','2026-01-23 10:36:29','2026-01-23 10:36:29',1),(510,'e43f34d9-2c82-4fa9-94ac-56998bf2dd4a','user_id','e1629a4b14764dddaabcadd16f3e1c1c','2026-01-23 10:31:52','2026-01-23 10:36:29','2026-01-23 10:36:29',1),(511,'e43f34d9-2c82-4fa9-94ac-56998bf2dd4a','image_type','snapshot','2026-01-23 10:31:52','2026-01-23 10:36:29','2026-01-23 10:36:29',1),(512,'e43f34d9-2c82-4fa9-94ac-56998bf2dd4a','owner_id','815b71acf60d4ed8933ebd05228fa0c0','2026-01-23 10:32:01','2026-01-23 10:36:29','2026-01-23 10:36:29',1),(513,'e43f34d9-2c82-4fa9-94ac-56998bf2dd4a','image_state','available','2026-01-23 10:32:01','2026-01-23 10:36:29','2026-01-23 10:36:29',1),(514,'e43f34d9-2c82-4fa9-94ac-56998bf2dd4a','image_location','snapshot','2026-01-23 10:32:01','2026-01-23 10:36:29','2026-01-23 10:36:29',1),(515,'e43f34d9-2c82-4fa9-94ac-56998bf2dd4a','hw_rescue_bus','usb','2026-01-23 10:32:11','2026-01-23 10:36:29','2026-01-23 10:36:29',1),(516,'e43f34d9-2c82-4fa9-94ac-56998bf2dd4a','hw_rescue_device','disk','2026-01-23 10:32:12','2026-01-23 10:36:29','2026-01-23 10:36:29',1),(517,'562f5b35-ce71-43ca-99f2-1c1231b35c14','hw_rng_model','virtio','2026-01-23 10:33:14','2026-01-23 10:36:17','2026-01-23 10:36:17',1),(518,'562f5b35-ce71-43ca-99f2-1c1231b35c14','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 10:33:14','2026-01-23 10:36:17','2026-01-23 10:36:17',1),(519,'562f5b35-ce71-43ca-99f2-1c1231b35c14','owner_user_name','tempest-ServerStableDeviceRescueTest-1802220041-project-member','2026-01-23 10:33:14','2026-01-23 10:36:17','2026-01-23 10:36:17',1),(520,'562f5b35-ce71-43ca-99f2-1c1231b35c14','owner_project_name','tempest-ServerStableDeviceRescueTest-1802220041','2026-01-23 10:33:14','2026-01-23 10:36:17','2026-01-23 10:36:17',1),(521,'562f5b35-ce71-43ca-99f2-1c1231b35c14','boot_roles','member,reader','2026-01-23 10:33:14','2026-01-23 10:36:17','2026-01-23 10:36:17',1),(522,'562f5b35-ce71-43ca-99f2-1c1231b35c14','hw_machine_type','q35','2026-01-23 10:33:14','2026-01-23 10:36:17','2026-01-23 10:36:17',1),(523,'562f5b35-ce71-43ca-99f2-1c1231b35c14','hw_cdrom_bus','sata','2026-01-23 10:33:14','2026-01-23 10:36:17','2026-01-23 10:36:17',1),(524,'562f5b35-ce71-43ca-99f2-1c1231b35c14','hw_disk_bus','virtio','2026-01-23 10:33:14','2026-01-23 10:36:17','2026-01-23 10:36:17',1),(525,'562f5b35-ce71-43ca-99f2-1c1231b35c14','hw_input_bus','usb','2026-01-23 10:33:14','2026-01-23 10:36:17','2026-01-23 10:36:17',1),(526,'562f5b35-ce71-43ca-99f2-1c1231b35c14','hw_pointer_model','usbtablet','2026-01-23 10:33:14','2026-01-23 10:36:17','2026-01-23 10:36:17',1),(527,'562f5b35-ce71-43ca-99f2-1c1231b35c14','hw_video_model','virtio','2026-01-23 10:33:14','2026-01-23 10:36:17','2026-01-23 10:36:17',1),(528,'562f5b35-ce71-43ca-99f2-1c1231b35c14','hw_vif_model','virtio','2026-01-23 10:33:14','2026-01-23 10:36:17','2026-01-23 10:36:17',1),(529,'562f5b35-ce71-43ca-99f2-1c1231b35c14','instance_uuid','1114ae68-dab9-46b3-abab-53f135df78d8','2026-01-23 10:33:14','2026-01-23 10:36:17','2026-01-23 10:36:17',1),(530,'562f5b35-ce71-43ca-99f2-1c1231b35c14','user_id','e1629a4b14764dddaabcadd16f3e1c1c','2026-01-23 10:33:14','2026-01-23 10:36:17','2026-01-23 10:36:17',1),(531,'562f5b35-ce71-43ca-99f2-1c1231b35c14','image_type','snapshot','2026-01-23 10:33:14','2026-01-23 10:36:17','2026-01-23 10:36:17',1),(532,'562f5b35-ce71-43ca-99f2-1c1231b35c14','image_state','available','2026-01-23 10:33:19','2026-01-23 10:36:17','2026-01-23 10:36:17',1),(533,'562f5b35-ce71-43ca-99f2-1c1231b35c14','image_location','snapshot','2026-01-23 10:33:19','2026-01-23 10:36:17','2026-01-23 10:36:17',1),(534,'562f5b35-ce71-43ca-99f2-1c1231b35c14','owner_id','815b71acf60d4ed8933ebd05228fa0c0','2026-01-23 10:33:19','2026-01-23 10:36:17','2026-01-23 10:36:17',1),(535,'562f5b35-ce71-43ca-99f2-1c1231b35c14','hw_rescue_bus','virtio','2026-01-23 10:33:23','2026-01-23 10:36:17','2026-01-23 10:36:17',1),(536,'562f5b35-ce71-43ca-99f2-1c1231b35c14','hw_rescue_device','disk','2026-01-23 10:33:23','2026-01-23 10:36:17','2026-01-23 10:36:17',1),(537,'e01877f1-023b-4adf-9357-0984581d9119','hw_rng_model','virtio','2026-01-23 10:34:40','2026-01-23 10:35:57','2026-01-23 10:35:57',1),(538,'e01877f1-023b-4adf-9357-0984581d9119','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 10:34:40','2026-01-23 10:35:57','2026-01-23 10:35:57',1),(539,'e01877f1-023b-4adf-9357-0984581d9119','owner_user_name','tempest-ServerStableDeviceRescueTest-1802220041-project-member','2026-01-23 10:34:40','2026-01-23 10:35:57','2026-01-23 10:35:57',1),(540,'e01877f1-023b-4adf-9357-0984581d9119','owner_project_name','tempest-ServerStableDeviceRescueTest-1802220041','2026-01-23 10:34:40','2026-01-23 10:35:57','2026-01-23 10:35:57',1),(541,'e01877f1-023b-4adf-9357-0984581d9119','boot_roles','member,reader','2026-01-23 10:34:40','2026-01-23 10:35:57','2026-01-23 10:35:57',1),(542,'e01877f1-023b-4adf-9357-0984581d9119','hw_machine_type','q35','2026-01-23 10:34:40','2026-01-23 10:35:57','2026-01-23 10:35:57',1),(543,'e01877f1-023b-4adf-9357-0984581d9119','hw_cdrom_bus','sata','2026-01-23 10:34:40','2026-01-23 10:35:57','2026-01-23 10:35:57',1),(544,'e01877f1-023b-4adf-9357-0984581d9119','hw_disk_bus','virtio','2026-01-23 10:34:40','2026-01-23 10:35:57','2026-01-23 10:35:57',1),(545,'e01877f1-023b-4adf-9357-0984581d9119','hw_input_bus','usb','2026-01-23 10:34:40','2026-01-23 10:35:57','2026-01-23 10:35:57',1),(546,'e01877f1-023b-4adf-9357-0984581d9119','hw_pointer_model','usbtablet','2026-01-23 10:34:40','2026-01-23 10:35:57','2026-01-23 10:35:57',1),(547,'e01877f1-023b-4adf-9357-0984581d9119','hw_video_model','virtio','2026-01-23 10:34:40','2026-01-23 10:35:57','2026-01-23 10:35:57',1),(548,'e01877f1-023b-4adf-9357-0984581d9119','hw_vif_model','virtio','2026-01-23 10:34:40','2026-01-23 10:35:57','2026-01-23 10:35:57',1),(549,'e01877f1-023b-4adf-9357-0984581d9119','instance_uuid','5d42acd2-a3c4-40d2-b1c7-0dd7920671fe','2026-01-23 10:34:40','2026-01-23 10:35:57','2026-01-23 10:35:57',1),(550,'e01877f1-023b-4adf-9357-0984581d9119','user_id','e1629a4b14764dddaabcadd16f3e1c1c','2026-01-23 10:34:40','2026-01-23 10:35:57','2026-01-23 10:35:57',1),(551,'e01877f1-023b-4adf-9357-0984581d9119','image_type','snapshot','2026-01-23 10:34:40','2026-01-23 10:35:57','2026-01-23 10:35:57',1),(552,'e01877f1-023b-4adf-9357-0984581d9119','image_state','available','2026-01-23 10:34:45','2026-01-23 10:35:57','2026-01-23 10:35:57',1),(553,'e01877f1-023b-4adf-9357-0984581d9119','owner_id','815b71acf60d4ed8933ebd05228fa0c0','2026-01-23 10:34:45','2026-01-23 10:35:57','2026-01-23 10:35:57',1),(554,'e01877f1-023b-4adf-9357-0984581d9119','image_location','snapshot','2026-01-23 10:34:45','2026-01-23 10:35:57','2026-01-23 10:35:57',1),(555,'e01877f1-023b-4adf-9357-0984581d9119','hw_rescue_bus','virtio','2026-01-23 10:34:49','2026-01-23 10:35:57','2026-01-23 10:35:57',1),(556,'e01877f1-023b-4adf-9357-0984581d9119','hw_rescue_device','disk','2026-01-23 10:34:49','2026-01-23 10:35:57','2026-01-23 10:35:57',1),(557,'60e9525a-9f0e-4c80-9c46-e7936c55e48b','hw_rng_model','virtio','2026-01-23 10:35:53','2026-01-23 10:37:19','2026-01-23 10:37:19',1),(558,'60e9525a-9f0e-4c80-9c46-e7936c55e48b','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 10:35:53','2026-01-23 10:37:19','2026-01-23 10:37:19',1),(559,'60e9525a-9f0e-4c80-9c46-e7936c55e48b','owner_user_name','tempest-TestStampPattern-1763690147-project-member','2026-01-23 10:35:53','2026-01-23 10:37:19','2026-01-23 10:37:19',1),(560,'60e9525a-9f0e-4c80-9c46-e7936c55e48b','owner_project_name','tempest-TestStampPattern-1763690147','2026-01-23 10:35:53','2026-01-23 10:37:19','2026-01-23 10:37:19',1),(561,'60e9525a-9f0e-4c80-9c46-e7936c55e48b','boot_roles','reader,member','2026-01-23 10:35:53','2026-01-23 10:37:19','2026-01-23 10:37:19',1),(562,'60e9525a-9f0e-4c80-9c46-e7936c55e48b','hw_machine_type','q35','2026-01-23 10:35:53','2026-01-23 10:37:19','2026-01-23 10:37:19',1),(563,'60e9525a-9f0e-4c80-9c46-e7936c55e48b','hw_cdrom_bus','sata','2026-01-23 10:35:53','2026-01-23 10:37:19','2026-01-23 10:37:19',1),(564,'60e9525a-9f0e-4c80-9c46-e7936c55e48b','hw_disk_bus','virtio','2026-01-23 10:35:53','2026-01-23 10:37:19','2026-01-23 10:37:19',1),(565,'60e9525a-9f0e-4c80-9c46-e7936c55e48b','hw_input_bus','usb','2026-01-23 10:35:53','2026-01-23 10:37:19','2026-01-23 10:37:19',1),(566,'60e9525a-9f0e-4c80-9c46-e7936c55e48b','hw_pointer_model','usbtablet','2026-01-23 10:35:53','2026-01-23 10:37:19','2026-01-23 10:37:19',1),(567,'60e9525a-9f0e-4c80-9c46-e7936c55e48b','hw_video_model','virtio','2026-01-23 10:35:53','2026-01-23 10:37:19','2026-01-23 10:37:19',1),(568,'60e9525a-9f0e-4c80-9c46-e7936c55e48b','hw_vif_model','virtio','2026-01-23 10:35:53','2026-01-23 10:37:19','2026-01-23 10:37:19',1),(569,'60e9525a-9f0e-4c80-9c46-e7936c55e48b','instance_uuid','6673e062-5d99-4c31-a3e0-673f55438d6e','2026-01-23 10:35:53','2026-01-23 10:37:19','2026-01-23 10:37:19',1),(570,'60e9525a-9f0e-4c80-9c46-e7936c55e48b','user_id','9a8ce4c88e8b46c5806ada5e3a6cdbbf','2026-01-23 10:35:53','2026-01-23 10:37:19','2026-01-23 10:37:19',1),(571,'60e9525a-9f0e-4c80-9c46-e7936c55e48b','image_type','snapshot','2026-01-23 10:35:53','2026-01-23 10:37:19','2026-01-23 10:37:19',1),(572,'60e9525a-9f0e-4c80-9c46-e7936c55e48b','image_state','available','2026-01-23 10:36:00','2026-01-23 10:37:19','2026-01-23 10:37:19',1),(573,'60e9525a-9f0e-4c80-9c46-e7936c55e48b','image_location','snapshot','2026-01-23 10:36:00','2026-01-23 10:37:19','2026-01-23 10:37:19',1),(574,'60e9525a-9f0e-4c80-9c46-e7936c55e48b','owner_id','d59dad6496894352a2f4c7eb66ca1914','2026-01-23 10:36:00','2026-01-23 10:37:19','2026-01-23 10:37:19',1),(575,'a757e68d-9be5-4d20-8679-fbaf68ed4300','signature_verified','False','2026-01-23 10:43:16','2026-01-23 10:44:53','2026-01-23 10:44:53',1),(576,'a757e68d-9be5-4d20-8679-fbaf68ed4300','hw_rng_model','virtio','2026-01-23 10:43:16','2026-01-23 10:44:53','2026-01-23 10:44:53',1),(577,'a757e68d-9be5-4d20-8679-fbaf68ed4300','base_image_ref','','2026-01-23 10:43:16','2026-01-23 10:44:53','2026-01-23 10:44:53',1),(578,'a757e68d-9be5-4d20-8679-fbaf68ed4300','owner_user_name','tempest-TestVolumeBootPattern-2139361132-project-member','2026-01-23 10:43:16','2026-01-23 10:44:53','2026-01-23 10:44:53',1),(579,'a757e68d-9be5-4d20-8679-fbaf68ed4300','owner_project_name','tempest-TestVolumeBootPattern-2139361132','2026-01-23 10:43:16','2026-01-23 10:44:53','2026-01-23 10:44:53',1),(580,'a757e68d-9be5-4d20-8679-fbaf68ed4300','boot_roles','reader,member','2026-01-23 10:43:16','2026-01-23 10:44:53','2026-01-23 10:44:53',1),(581,'a757e68d-9be5-4d20-8679-fbaf68ed4300','hw_machine_type','q35','2026-01-23 10:43:16','2026-01-23 10:44:53','2026-01-23 10:44:53',1),(582,'a757e68d-9be5-4d20-8679-fbaf68ed4300','hw_cdrom_bus','sata','2026-01-23 10:43:16','2026-01-23 10:44:53','2026-01-23 10:44:53',1),(583,'a757e68d-9be5-4d20-8679-fbaf68ed4300','hw_disk_bus','virtio','2026-01-23 10:43:16','2026-01-23 10:44:53','2026-01-23 10:44:53',1),(584,'a757e68d-9be5-4d20-8679-fbaf68ed4300','hw_input_bus','usb','2026-01-23 10:43:16','2026-01-23 10:44:53','2026-01-23 10:44:53',1),(585,'a757e68d-9be5-4d20-8679-fbaf68ed4300','hw_pointer_model','usbtablet','2026-01-23 10:43:16','2026-01-23 10:44:53','2026-01-23 10:44:53',1),(586,'a757e68d-9be5-4d20-8679-fbaf68ed4300','hw_video_model','virtio','2026-01-23 10:43:16','2026-01-23 10:44:53','2026-01-23 10:44:53',1),(587,'a757e68d-9be5-4d20-8679-fbaf68ed4300','hw_vif_model','virtio','2026-01-23 10:43:16','2026-01-23 10:44:53','2026-01-23 10:44:53',1),(588,'a757e68d-9be5-4d20-8679-fbaf68ed4300','root_device_name','/dev/vda','2026-01-23 10:43:16','2026-01-23 10:44:53','2026-01-23 10:44:53',1),(589,'a757e68d-9be5-4d20-8679-fbaf68ed4300','block_device_mapping','[{\"boot_index\": 0, \"snapshot_id\": \"aad073c6-3850-4a37-969d-b73d0ec7219a\", \"guest_format\": null, \"device_name\": \"/dev/vda\", \"source_type\": \"snapshot\", \"encrypted\": null, \"delete_on_termination\": true, \"volume_id\": null, \"no_device\": null, \"volume_size\": 1, \"image_id\": null, \"encryption_options\": null, \"device_type\": \"disk\", \"tag\": null, \"encryption_secret_uuid\": null, \"encryption_format\": null, \"destination_type\": \"volume\", \"disk_bus\": \"virtio\", \"volume_type\": null}]','2026-01-23 10:43:16','2026-01-23 10:44:53','2026-01-23 10:44:53',1),(590,'a757e68d-9be5-4d20-8679-fbaf68ed4300','bdm_v2','True','2026-01-23 10:43:16','2026-01-23 10:44:53','2026-01-23 10:44:53',1),(591,'13dd300f-265a-4d77-8204-968f335a1387','signature_verified','False','2026-01-23 10:43:37','2026-01-23 10:43:49','2026-01-23 10:43:49',1),(592,'13dd300f-265a-4d77-8204-968f335a1387','hw_rng_model','virtio','2026-01-23 10:43:37','2026-01-23 10:43:49','2026-01-23 10:43:49',1),(593,'13dd300f-265a-4d77-8204-968f335a1387','base_image_ref','','2026-01-23 10:43:37','2026-01-23 10:43:49','2026-01-23 10:43:49',1),(594,'13dd300f-265a-4d77-8204-968f335a1387','owner_user_name','tempest-AttachVolumeMultiAttachTest-63035580-project-member','2026-01-23 10:43:37','2026-01-23 10:43:49','2026-01-23 10:43:49',1),(595,'13dd300f-265a-4d77-8204-968f335a1387','owner_project_name','tempest-AttachVolumeMultiAttachTest-63035580','2026-01-23 10:43:37','2026-01-23 10:43:49','2026-01-23 10:43:49',1),(596,'13dd300f-265a-4d77-8204-968f335a1387','boot_roles','reader,member','2026-01-23 10:43:37','2026-01-23 10:43:49','2026-01-23 10:43:49',1),(597,'13dd300f-265a-4d77-8204-968f335a1387','hw_machine_type','q35','2026-01-23 10:43:37','2026-01-23 10:43:49','2026-01-23 10:43:49',1),(598,'13dd300f-265a-4d77-8204-968f335a1387','hw_cdrom_bus','sata','2026-01-23 10:43:37','2026-01-23 10:43:49','2026-01-23 10:43:49',1),(599,'13dd300f-265a-4d77-8204-968f335a1387','hw_disk_bus','virtio','2026-01-23 10:43:37','2026-01-23 10:43:49','2026-01-23 10:43:49',1),(600,'13dd300f-265a-4d77-8204-968f335a1387','hw_input_bus','usb','2026-01-23 10:43:37','2026-01-23 10:43:49','2026-01-23 10:43:49',1),(601,'13dd300f-265a-4d77-8204-968f335a1387','hw_pointer_model','usbtablet','2026-01-23 10:43:37','2026-01-23 10:43:49','2026-01-23 10:43:49',1),(602,'13dd300f-265a-4d77-8204-968f335a1387','hw_video_model','virtio','2026-01-23 10:43:37','2026-01-23 10:43:49','2026-01-23 10:43:49',1),(603,'13dd300f-265a-4d77-8204-968f335a1387','hw_vif_model','virtio','2026-01-23 10:43:37','2026-01-23 10:43:49','2026-01-23 10:43:49',1),(604,'13dd300f-265a-4d77-8204-968f335a1387','root_device_name','/dev/vda','2026-01-23 10:43:37','2026-01-23 10:43:49','2026-01-23 10:43:49',1),(605,'13dd300f-265a-4d77-8204-968f335a1387','block_device_mapping','[{\"boot_index\": 0, \"snapshot_id\": \"3033136a-603a-44e6-bb60-ea116fce16b7\", \"guest_format\": null, \"device_name\": \"/dev/vda\", \"source_type\": \"snapshot\", \"encrypted\": null, \"delete_on_termination\": false, \"volume_id\": null, \"no_device\": null, \"volume_size\": 1, \"image_id\": null, \"encryption_options\": null, \"device_type\": \"disk\", \"tag\": null, \"encryption_secret_uuid\": null, \"encryption_format\": null, \"destination_type\": \"volume\", \"disk_bus\": \"virtio\", \"volume_type\": null}]','2026-01-23 10:43:37','2026-01-23 10:43:49','2026-01-23 10:43:49',1),(606,'13dd300f-265a-4d77-8204-968f335a1387','bdm_v2','True','2026-01-23 10:43:37','2026-01-23 10:43:49','2026-01-23 10:43:49',1),(607,'a565646f-e62e-4f36-81a3-989264b3b2c8','hw_rng_model','virtio','2026-01-23 10:45:57','2026-01-23 10:46:30','2026-01-23 10:46:30',1),(608,'a565646f-e62e-4f36-81a3-989264b3b2c8','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 10:45:57','2026-01-23 10:46:30','2026-01-23 10:46:30',1),(609,'a565646f-e62e-4f36-81a3-989264b3b2c8','owner_user_name','tempest-AttachVolumeShelveTestJSON-2030135659-project-member','2026-01-23 10:45:57','2026-01-23 10:46:30','2026-01-23 10:46:30',1),(610,'a565646f-e62e-4f36-81a3-989264b3b2c8','owner_project_name','tempest-AttachVolumeShelveTestJSON-2030135659','2026-01-23 10:45:57','2026-01-23 10:46:30','2026-01-23 10:46:30',1),(611,'a565646f-e62e-4f36-81a3-989264b3b2c8','boot_roles','reader,member','2026-01-23 10:45:57','2026-01-23 10:46:30','2026-01-23 10:46:30',1),(612,'a565646f-e62e-4f36-81a3-989264b3b2c8','hw_machine_type','q35','2026-01-23 10:45:57','2026-01-23 10:46:30','2026-01-23 10:46:30',1),(613,'a565646f-e62e-4f36-81a3-989264b3b2c8','hw_cdrom_bus','sata','2026-01-23 10:45:57','2026-01-23 10:46:30','2026-01-23 10:46:30',1),(614,'a565646f-e62e-4f36-81a3-989264b3b2c8','hw_disk_bus','virtio','2026-01-23 10:45:57','2026-01-23 10:46:30','2026-01-23 10:46:30',1),(615,'a565646f-e62e-4f36-81a3-989264b3b2c8','hw_input_bus','usb','2026-01-23 10:45:57','2026-01-23 10:46:30','2026-01-23 10:46:30',1),(616,'a565646f-e62e-4f36-81a3-989264b3b2c8','hw_pointer_model','usbtablet','2026-01-23 10:45:57','2026-01-23 10:46:30','2026-01-23 10:46:30',1),(617,'a565646f-e62e-4f36-81a3-989264b3b2c8','hw_video_model','virtio','2026-01-23 10:45:57','2026-01-23 10:46:30','2026-01-23 10:46:30',1),(618,'a565646f-e62e-4f36-81a3-989264b3b2c8','hw_vif_model','virtio','2026-01-23 10:45:57','2026-01-23 10:46:30','2026-01-23 10:46:30',1),(619,'a565646f-e62e-4f36-81a3-989264b3b2c8','instance_uuid','fb31c535-476a-4f92-866e-664b8b25e0fc','2026-01-23 10:45:57','2026-01-23 10:46:30','2026-01-23 10:46:30',1),(620,'a565646f-e62e-4f36-81a3-989264b3b2c8','user_id','296341ffca2441dc807d285fa14c966d','2026-01-23 10:45:57','2026-01-23 10:46:30','2026-01-23 10:46:30',1),(621,'a565646f-e62e-4f36-81a3-989264b3b2c8','image_type','snapshot','2026-01-23 10:45:57','2026-01-23 10:46:30','2026-01-23 10:46:30',1),(622,'a565646f-e62e-4f36-81a3-989264b3b2c8','image_state','available','2026-01-23 10:46:08','2026-01-23 10:46:30','2026-01-23 10:46:30',1),(623,'a565646f-e62e-4f36-81a3-989264b3b2c8','image_location','snapshot','2026-01-23 10:46:08','2026-01-23 10:46:30','2026-01-23 10:46:30',1),(624,'a565646f-e62e-4f36-81a3-989264b3b2c8','owner_id','36d7e7c7ddbd4cf785fafd0d35b0a2d8','2026-01-23 10:46:08','2026-01-23 10:46:30','2026-01-23 10:46:30',1),(625,'2958e5e7-f8c1-4f81-af25-87197bff4d89','hw_rng_model','virtio','2026-01-23 10:48:03','2026-01-23 10:48:45','2026-01-23 10:48:45',1),(626,'2958e5e7-f8c1-4f81-af25-87197bff4d89','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 10:48:03','2026-01-23 10:48:45','2026-01-23 10:48:45',1),(627,'2958e5e7-f8c1-4f81-af25-87197bff4d89','owner_user_name','tempest-AttachVolumeShelveTestJSON-2030135659-project-member','2026-01-23 10:48:03','2026-01-23 10:48:45','2026-01-23 10:48:45',1),(628,'2958e5e7-f8c1-4f81-af25-87197bff4d89','owner_project_name','tempest-AttachVolumeShelveTestJSON-2030135659','2026-01-23 10:48:03','2026-01-23 10:48:45','2026-01-23 10:48:45',1),(629,'2958e5e7-f8c1-4f81-af25-87197bff4d89','boot_roles','reader,member','2026-01-23 10:48:03','2026-01-23 10:48:45','2026-01-23 10:48:45',1),(630,'2958e5e7-f8c1-4f81-af25-87197bff4d89','hw_machine_type','q35','2026-01-23 10:48:03','2026-01-23 10:48:45','2026-01-23 10:48:45',1),(631,'2958e5e7-f8c1-4f81-af25-87197bff4d89','hw_cdrom_bus','sata','2026-01-23 10:48:03','2026-01-23 10:48:45','2026-01-23 10:48:45',1),(632,'2958e5e7-f8c1-4f81-af25-87197bff4d89','hw_disk_bus','virtio','2026-01-23 10:48:03','2026-01-23 10:48:45','2026-01-23 10:48:45',1),(633,'2958e5e7-f8c1-4f81-af25-87197bff4d89','hw_input_bus','usb','2026-01-23 10:48:03','2026-01-23 10:48:45','2026-01-23 10:48:45',1),(634,'2958e5e7-f8c1-4f81-af25-87197bff4d89','hw_pointer_model','usbtablet','2026-01-23 10:48:03','2026-01-23 10:48:45','2026-01-23 10:48:45',1),(635,'2958e5e7-f8c1-4f81-af25-87197bff4d89','hw_video_model','virtio','2026-01-23 10:48:03','2026-01-23 10:48:45','2026-01-23 10:48:45',1),(636,'2958e5e7-f8c1-4f81-af25-87197bff4d89','hw_vif_model','virtio','2026-01-23 10:48:03','2026-01-23 10:48:45','2026-01-23 10:48:45',1),(637,'2958e5e7-f8c1-4f81-af25-87197bff4d89','instance_uuid','1f16f1e6-2ac3-4547-84bf-103e4be39e3a','2026-01-23 10:48:03','2026-01-23 10:48:45','2026-01-23 10:48:45',1),(638,'2958e5e7-f8c1-4f81-af25-87197bff4d89','user_id','296341ffca2441dc807d285fa14c966d','2026-01-23 10:48:03','2026-01-23 10:48:45','2026-01-23 10:48:45',1),(639,'2958e5e7-f8c1-4f81-af25-87197bff4d89','image_type','snapshot','2026-01-23 10:48:03','2026-01-23 10:48:45','2026-01-23 10:48:45',1),(640,'2958e5e7-f8c1-4f81-af25-87197bff4d89','image_state','available','2026-01-23 10:48:17','2026-01-23 10:48:45','2026-01-23 10:48:45',1),(641,'2958e5e7-f8c1-4f81-af25-87197bff4d89','image_location','snapshot','2026-01-23 10:48:17','2026-01-23 10:48:45','2026-01-23 10:48:45',1),(642,'2958e5e7-f8c1-4f81-af25-87197bff4d89','owner_id','36d7e7c7ddbd4cf785fafd0d35b0a2d8','2026-01-23 10:48:17','2026-01-23 10:48:45','2026-01-23 10:48:45',1),(643,'7da2f187-f7de-4714-b817-454a50a6b19a','hw_rng_model','virtio','2026-01-23 11:12:59','2026-01-23 11:13:36','2026-01-23 11:13:36',1),(644,'7da2f187-f7de-4714-b817-454a50a6b19a','base_image_ref','84c0ef19-7f67-4bd3-95d8-507c3e0942ed','2026-01-23 11:12:59','2026-01-23 11:13:36','2026-01-23 11:13:36',1),(645,'7da2f187-f7de-4714-b817-454a50a6b19a','owner_user_name','tempest-TestShelveInstance-869807080-project-member','2026-01-23 11:12:59','2026-01-23 11:13:36','2026-01-23 11:13:36',1),(646,'7da2f187-f7de-4714-b817-454a50a6b19a','owner_project_name','tempest-TestShelveInstance-869807080','2026-01-23 11:12:59','2026-01-23 11:13:36','2026-01-23 11:13:36',1),(647,'7da2f187-f7de-4714-b817-454a50a6b19a','boot_roles','reader,member','2026-01-23 11:12:59','2026-01-23 11:13:36','2026-01-23 11:13:36',1),(648,'7da2f187-f7de-4714-b817-454a50a6b19a','hw_machine_type','q35','2026-01-23 11:12:59','2026-01-23 11:13:36','2026-01-23 11:13:36',1),(649,'7da2f187-f7de-4714-b817-454a50a6b19a','hw_cdrom_bus','sata','2026-01-23 11:12:59','2026-01-23 11:13:36','2026-01-23 11:13:36',1),(650,'7da2f187-f7de-4714-b817-454a50a6b19a','hw_disk_bus','virtio','2026-01-23 11:12:59','2026-01-23 11:13:36','2026-01-23 11:13:36',1),(651,'7da2f187-f7de-4714-b817-454a50a6b19a','hw_input_bus','usb','2026-01-23 11:12:59','2026-01-23 11:13:36','2026-01-23 11:13:36',1),(652,'7da2f187-f7de-4714-b817-454a50a6b19a','hw_pointer_model','usbtablet','2026-01-23 11:12:59','2026-01-23 11:13:36','2026-01-23 11:13:36',1),(653,'7da2f187-f7de-4714-b817-454a50a6b19a','hw_video_model','virtio','2026-01-23 11:12:59','2026-01-23 11:13:36','2026-01-23 11:13:36',1),(654,'7da2f187-f7de-4714-b817-454a50a6b19a','hw_vif_model','virtio','2026-01-23 11:12:59','2026-01-23 11:13:36','2026-01-23 11:13:36',1),(655,'7da2f187-f7de-4714-b817-454a50a6b19a','instance_uuid','d4c75524-52b8-4c2b-b0cb-18d94089013b','2026-01-23 11:12:59','2026-01-23 11:13:36','2026-01-23 11:13:36',1),(656,'7da2f187-f7de-4714-b817-454a50a6b19a','user_id','5d6a458f5d9345379b05f0cdb69a7b0f','2026-01-23 11:12:59','2026-01-23 11:13:36','2026-01-23 11:13:36',1),(657,'7da2f187-f7de-4714-b817-454a50a6b19a','image_type','snapshot','2026-01-23 11:13:00','2026-01-23 11:13:36','2026-01-23 11:13:36',1),(658,'7da2f187-f7de-4714-b817-454a50a6b19a','image_state','available','2026-01-23 11:13:09','2026-01-23 11:13:36','2026-01-23 11:13:36',1),(659,'7da2f187-f7de-4714-b817-454a50a6b19a','owner_id','3a245f7970f14fffa60af2ff972b4bfd','2026-01-23 11:13:09','2026-01-23 11:13:36','2026-01-23 11:13:36',1),(660,'7da2f187-f7de-4714-b817-454a50a6b19a','image_location','snapshot','2026-01-23 11:13:09','2026-01-23 11:13:36','2026-01-23 11:13:36',1);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('034d6719-9097-4197-9373-c0b4b83dfc98','tempest-ServersNegativeTestJSON-server-980180187-shelved',1073741824,'deleted','2026-01-23 10:10:20','2026-01-23 10:11:10','2026-01-23 10:11:10',1,'raw','bare',NULL,'746ea02b745c4e21ace4cb49c193899d',1,0,0,NULL,'private',0,NULL,NULL),('13dd300f-265a-4d77-8204-968f335a1387','multiattach-snapshot',0,'deleted','2026-01-23 10:43:37','2026-01-23 10:43:49','2026-01-23 10:43:49',1,'qcow2','bare','d41d8cd98f00b204e9800998ecf8427e','6e762fca3b634c7aa1d994314c059c54',1,0,0,NULL,'private',0,'sha512','cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e'),('1751577e-a4ac-4cf5-912a-f31cdff15a23','tempest-backup-2-2128270305',1073741824,'deleted','2026-01-23 10:08:48','2026-01-23 10:09:18','2026-01-23 10:09:18',1,'raw','bare',NULL,'9dd869ce76e44fc8a82b8bbee1654d33',1,0,0,NULL,'private',0,NULL,NULL),('1f42e74d-2b40-42bc-b3a7-8f4aab6f6bdd','tempest-DeleteServersTestJSON-server-840112235-shelved',1073741824,'deleted','2026-01-23 09:52:03','2026-01-23 09:52:44','2026-01-23 09:52:44',1,'raw','bare',NULL,'61df91981c55482fa5c9a64686c79f9e',1,0,0,NULL,'private',0,NULL,NULL),('282072bc-dd1c-4ade-92e2-a8e019b5132d','tempest-backup-1-134592579',NULL,'deleted','2026-01-23 10:03:36','2026-01-23 10:03:37','2026-01-23 10:03:37',1,'qcow2','bare',NULL,'fc506511c3ec4a89b6bdb7d64fa0df08',1,0,0,NULL,'private',0,NULL,NULL),('2958e5e7-f8c1-4f81-af25-87197bff4d89','tempest-AttachVolumeShelveTestJSON-server-1083202157-shelved',1073741824,'deleted','2026-01-23 10:48:03','2026-01-23 10:48:45','2026-01-23 10:48:45',1,'raw','bare',NULL,'36d7e7c7ddbd4cf785fafd0d35b0a2d8',1,0,0,NULL,'private',0,NULL,NULL),('317c5b81-1ed5-4e60-8bf3-e997901e644f','tempest-UnshelveToHostMultiNodesTest-server-1701597104-shelved',1073741824,'deleted','2026-01-23 09:33:38','2026-01-23 09:34:39','2026-01-23 09:34:39',1,'raw','bare',NULL,'307173cd6ebb4dd5ad3883dedac0271e',1,0,0,NULL,'private',0,NULL,NULL),('33bd8321-22af-4ee8-875d-6188b12bef8e','tempest-ServerStableDeviceRescueTest-image-1360320013',1073741824,'deleted','2026-01-23 10:30:30','2026-01-23 10:36:38','2026-01-23 10:36:38',1,'raw','bare',NULL,'815b71acf60d4ed8933ebd05228fa0c0',1,0,0,NULL,'private',0,NULL,NULL),('44868dcf-53c3-4c3b-a7d9-2c19db7927f7','tempest-ListImageFiltersTestJSON-image-1134412097',1024,'deleted','2026-01-23 09:45:46','2026-01-23 09:47:34','2026-01-23 09:47:34',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','5d69aaa276f94de98e4011fa17428b40',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('45316771-2c9a-4201-a1b6-cc39488f10bc','tempest-TestSnapshotPatternsnapshot-318098312',1073741824,'deleted','2026-01-23 10:31:34','2026-01-23 10:31:47','2026-01-23 10:31:47',1,'raw','bare',NULL,'7be5cb5abaf44b0a9c0c307d348d8f75',1,0,0,NULL,'private',0,NULL,NULL),('468a5657-114a-42e3-900b-a72cd304261c','tempest-ServerBootFromVolumeStableRescueTest-image-1103553599',1073741824,'deleted','2026-01-23 10:26:32','2026-01-23 10:28:35','2026-01-23 10:28:35',1,'raw','bare',NULL,'5c27429e1d8f433a8a67ddb76f8798f1',1,0,0,NULL,'private',0,NULL,NULL),('4741efb0-ac27-4eb3-af8a-63929f9ec3e2','tempest-ImagesOneServerNegativeTestJSON-image-1691087855',NULL,'deleted','2026-01-23 09:47:53','2026-01-23 09:47:54','2026-01-23 09:47:54',1,NULL,NULL,NULL,'6ff15972efaf47c1a5483927aa058ee1',1,0,0,NULL,'private',0,NULL,NULL),('4a8fa58a-d2a5-4de0-8047-4939888c3f46','tempest-test-snap-212894139',NULL,'deleted','2026-01-23 09:44:01','2026-01-23 09:44:03','2026-01-23 09:44:03',1,NULL,NULL,NULL,'05bc71a77710455e8b34ead7fec81a31',1,0,0,NULL,'private',0,NULL,NULL),('4e1fa467-77ba-4764-82a0-700986e94bbd','tempest-scenario-img--1164200911',21430272,'deleted','2026-01-23 10:23:17','2026-01-23 10:25:24','2026-01-23 10:25:24',1,'qcow2','bare','c8fc807773e5354afe61636071771906','b976daabc8124a99814954633f99ed7b',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('562f5b35-ce71-43ca-99f2-1c1231b35c14','tempest-ServerStableDeviceRescueTest-image-1607234615',1073741824,'deleted','2026-01-23 10:33:14','2026-01-23 10:36:17','2026-01-23 10:36:17',1,'raw','bare',NULL,'815b71acf60d4ed8933ebd05228fa0c0',1,0,0,NULL,'private',0,NULL,NULL),('565ba31d-24d7-44f1-ba74-58e1935b27b9','tempest-test-snap-959987409',1073741824,'deleted','2026-01-23 09:42:33','2026-01-23 09:42:45','2026-01-23 09:42:45',1,'raw','bare',NULL,'05bc71a77710455e8b34ead7fec81a31',1,0,0,NULL,'private',0,NULL,NULL),('5e615da5-21b7-41e6-bf0a-0f222139b158','tempest-scenario-img--669154225',21430272,'deleted','2026-01-23 10:14:16','2026-01-23 10:18:47','2026-01-23 10:18:47',1,'qcow2','bare','c8fc807773e5354afe61636071771906','3ae621f21a8e438fb95152309b38cee5',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('60e9525a-9f0e-4c80-9c46-e7936c55e48b','tempest-TestStampPatternsnapshot-447735217',1073741824,'deleted','2026-01-23 10:35:53','2026-01-23 10:37:19','2026-01-23 10:37:19',1,'raw','bare',NULL,'d59dad6496894352a2f4c7eb66ca1914',1,0,0,NULL,'private',0,NULL,NULL),('6bbc8a2d-8fd2-4651-865b-0da5b89043d8','tempest-backup-3-2062889401',1073741824,'deleted','2026-01-23 10:08:58','2026-01-23 10:09:15','2026-01-23 10:09:15',1,'raw','bare',NULL,'9dd869ce76e44fc8a82b8bbee1654d33',1,0,0,NULL,'private',0,NULL,NULL),('6bd0071a-f3ee-4720-bcc3-909d56e7c877','tempest-ServerActionsTestOtherB-server-256866531-shelved',1073741824,'deleted','2026-01-23 10:13:32','2026-01-23 10:14:59','2026-01-23 10:14:59',1,'raw','bare',NULL,'9dd869ce76e44fc8a82b8bbee1654d33',1,0,0,NULL,'private',0,NULL,NULL),('6bf97b3a-7532-45e6-8ddf-ceec1bcd88c6','tempest-ImagesOneServerNegativeTestJSON-image-1465320519',NULL,'deleted','2026-01-23 09:47:12','2026-01-23 09:47:12','2026-01-23 09:47:12',1,NULL,NULL,NULL,'6ff15972efaf47c1a5483927aa058ee1',1,0,0,NULL,'private',0,NULL,NULL),('6e41c4a9-ec96-4eb1-836b-48623204cfef','tempest-ListImageFiltersTestJSON-image-1539507045',1024,'deleted','2026-01-23 09:45:51','2026-01-23 09:47:31','2026-01-23 09:47:31',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','5d69aaa276f94de98e4011fa17428b40',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('7055985e-6eb0-4085-98fc-7fd821a237a3','tempest-image-2067638511',1154,'deleted','2026-01-23 09:36:43','2026-01-23 09:36:50','2026-01-23 09:36:50',1,'qcow2','bare','12c1eb4d7e161cad5e1f29a15070f4df','b8bc65ca925248089a5fa186d8bbfb0e',0,129,0,NULL,'private',0,'sha512','ddcf5f4f16672c25c382451970169a7ae30a4504592b599453c83bfec5be2e4cee0689a52644f2423b5c295071ec23f76d469725ec24a776b054e6b1992bb85a'),('7da2f187-f7de-4714-b817-454a50a6b19a','tempest-TestShelveInstance-server-926357377-shelved',1073741824,'deleted','2026-01-23 11:12:59','2026-01-23 11:13:36','2026-01-23 11:13:36',1,'raw','bare',NULL,'3a245f7970f14fffa60af2ff972b4bfd',1,0,0,NULL,'private',0,NULL,NULL),('81a92860-f94f-4274-aba5-1ec35fd1f681','tempest-TestSnapshotPatternsnapshot-1660473649',1073741824,'deleted','2026-01-23 10:30:19','2026-01-23 10:32:02','2026-01-23 10:32:02',1,'raw','bare',NULL,'7be5cb5abaf44b0a9c0c307d348d8f75',1,0,0,NULL,'private',0,NULL,NULL),('84c0ef19-7f67-4bd3-95d8-507c3e0942ed','cirros-0.6.2-x86_64-disk.img',21430272,'active','2026-01-23 09:27:25','2026-01-23 09:27:30',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','7ace0d3e1d354841bc1ddea0c12699d6',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('8acf0d1a-47cb-44fb-a780-075c7b86547c','tempest-test-snap-664599502',1073741824,'deleted','2026-01-23 09:42:00','2026-01-23 09:42:14','2026-01-23 09:42:14',1,'raw','bare',NULL,'05bc71a77710455e8b34ead7fec81a31',1,0,0,NULL,'private',0,NULL,NULL),('8f15c480-cf5d-4aa4-933d-ac81e0da506c','tempest-ListImageFiltersTestJSON-image-1741504637',1073741824,'deleted','2026-01-23 09:46:56','2026-01-23 09:47:16','2026-01-23 09:47:16',1,'raw','bare',NULL,'5d69aaa276f94de98e4011fa17428b40',1,0,0,NULL,'private',0,NULL,NULL),('91667598-4041-4c0e-ba8d-b3a19e535259','tempest-ServerActionsTestOtherB-server-1716094682-shelved',1073741824,'deleted','2026-01-23 10:14:03','2026-01-23 10:14:51','2026-01-23 10:14:51',1,'raw','bare',NULL,'9dd869ce76e44fc8a82b8bbee1654d33',1,0,0,NULL,'private',0,NULL,NULL),('975acd30-ef25-4077-8c73-a70095688223','tempest-₡-1220329036',1073741824,'deleted','2026-01-23 09:45:22','2026-01-23 09:45:37','2026-01-23 09:45:37',1,'raw','bare',NULL,'24b47af7a3f745a7bc14b9a64c920144',1,0,0,NULL,'private',0,NULL,NULL),('985f1d15-bd4f-4eb9-b8ae-0616b8fcb8b9','tempest-image-673361421',1073741824,'deleted','2026-01-23 09:45:09','2026-01-23 09:45:20','2026-01-23 09:45:20',1,'raw','bare',NULL,'24b47af7a3f745a7bc14b9a64c920144',1,0,0,NULL,'private',0,NULL,NULL),('a565646f-e62e-4f36-81a3-989264b3b2c8','tempest-AttachVolumeShelveTestJSON-server-548177853-shelved',1073741824,'deleted','2026-01-23 10:45:57','2026-01-23 10:46:30','2026-01-23 10:46:30',1,'raw','bare',NULL,'36d7e7c7ddbd4cf785fafd0d35b0a2d8',1,0,0,NULL,'private',0,NULL,NULL),('a6dd6735-2531-476a-84da-d320f253f8a3','tempest-ListImageFiltersTestJSON-image-2026004787',1073741824,'deleted','2026-01-23 09:46:34','2026-01-23 09:47:20','2026-01-23 09:47:20',1,'raw','bare',NULL,'5d69aaa276f94de98e4011fa17428b40',1,0,0,NULL,'private',0,NULL,NULL),('a757e68d-9be5-4d20-8679-fbaf68ed4300','tempest-TestVolumeBootPatternsnapshot-349323527',0,'deleted','2026-01-23 10:43:16','2026-01-23 10:44:53','2026-01-23 10:44:53',1,'qcow2','bare','d41d8cd98f00b204e9800998ecf8427e','d27c5465284b48a5818ef931d6251c43',1,0,0,NULL,'private',0,'sha512','cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e'),('a891f488-4cba-4fea-b482-6ac469142f81','tempest-ServerBootFromVolumeStableRescueTest-image-442914945',1073741824,'deleted','2026-01-23 10:24:08','2026-01-23 10:28:49','2026-01-23 10:28:49',1,'raw','bare',NULL,'5c27429e1d8f433a8a67ddb76f8798f1',1,0,0,NULL,'private',0,NULL,NULL),('ae1f9e37-418c-462f-81d1-3599a6d89de9','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2026-01-23 09:27:31','2026-01-23 09:27:34',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','7ace0d3e1d354841bc1ddea0c12699d6',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('b5a73d98-c27b-4745-95e1-6675f24e35ae','tempest-test-snap-903138486',1073741824,'deleted','2026-01-23 09:43:04','2026-01-23 09:43:39','2026-01-23 09:43:39',1,'raw','bare',NULL,'05bc71a77710455e8b34ead7fec81a31',1,0,0,NULL,'private',0,NULL,NULL),('b6586179-6c6b-4cff-8136-eeb31a27eb50','tempest-ListImageFiltersTestJSON-image-762057219',1073741824,'deleted','2026-01-23 09:46:45','2026-01-23 09:47:18','2026-01-23 09:47:18',1,'raw','bare',NULL,'5d69aaa276f94de98e4011fa17428b40',1,0,0,NULL,'private',0,NULL,NULL),('bba8f8ac-6563-4b96-a735-670d31b1818b','tempest-scenario-img--131466346',21430272,'deleted','2026-01-23 10:19:54','2026-01-23 10:23:17','2026-01-23 10:23:17',1,'qcow2','bare','c8fc807773e5354afe61636071771906','b976daabc8124a99814954633f99ed7b',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('beab1a9d-47f6-4028-af41-d72bcd3dcf45','tempest-ListImageFiltersTestJSON-image-887776649',1024,'deleted','2026-01-23 09:45:55','2026-01-23 09:47:28','2026-01-23 09:47:28',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','5d69aaa276f94de98e4011fa17428b40',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('beba0087-1685-43d4-bbc2-b6ca28939286','tempest-image-1277617692',1024,'deleted','2026-01-23 09:37:00','2026-01-23 09:37:26','2026-01-23 09:37:26',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','a15816917a264c0d8046e42ed99e102c',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('c895afcd-4576-403b-b7a1-afa282118258','tempest-backup-1-246696990',1073741824,'deleted','2026-01-23 10:08:37','2026-01-23 10:09:11','2026-01-23 10:09:11',1,'raw','bare',NULL,'9dd869ce76e44fc8a82b8bbee1654d33',1,0,0,NULL,'private',0,NULL,NULL),('cb273736-b860-41f6-b2fe-c26bfa105d90','tempest-UnshelveToHostMultiNodesTest-server-1701597104-shelved',1073741824,'deleted','2026-01-23 09:34:42','2026-01-23 09:35:20','2026-01-23 09:35:20',1,'raw','bare',NULL,'307173cd6ebb4dd5ad3883dedac0271e',1,0,0,NULL,'private',0,NULL,NULL),('cb2aa1fa-520b-4509-8a21-f3e422b84e79','tempest-test-snap-2134110834',1073741824,'deleted','2026-01-23 09:40:52','2026-01-23 09:41:05','2026-01-23 09:41:05',1,'raw','bare',NULL,'05bc71a77710455e8b34ead7fec81a31',1,0,0,NULL,'private',0,NULL,NULL),('de0f1f21-0106-4885-a7ac-14a7ec714eff',NULL,21430272,'deleted','2026-01-23 09:41:16','2026-01-23 09:42:44','2026-01-23 09:42:44',1,'qcow2','bare','c8fc807773e5354afe61636071771906','bfaf98c50275412bb160829c8fe02fe3',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('e01877f1-023b-4adf-9357-0984581d9119','tempest-ServerStableDeviceRescueTest-image-1128985539',1073741824,'deleted','2026-01-23 10:34:40','2026-01-23 10:35:58','2026-01-23 10:35:58',1,'raw','bare',NULL,'815b71acf60d4ed8933ebd05228fa0c0',1,0,0,NULL,'private',0,NULL,NULL),('e43f34d9-2c82-4fa9-94ac-56998bf2dd4a','tempest-ServerStableDeviceRescueTest-image-1311648740',1073741824,'deleted','2026-01-23 10:31:52','2026-01-23 10:36:29','2026-01-23 10:36:29',1,'raw','bare',NULL,'815b71acf60d4ed8933ebd05228fa0c0',1,0,0,NULL,'private',0,NULL,NULL);
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2026-01-23 08:42:55',NULL),(1,2,'image','CIM_RASD_','2026-01-23 08:42:56',NULL),(1,3,NULL,'CIM_SASD_','2026-01-23 08:43:03',NULL),(1,9,'image','hw_','2026-01-23 08:43:04',NULL),(1,10,'image','hw_','2026-01-23 08:43:04',NULL),(1,14,'image',NULL,'2026-01-23 08:43:04',NULL),(1,19,'image','hw_','2026-01-23 08:43:05',NULL),(1,25,'image','hw_','2026-01-23 08:43:06',NULL),(1,29,'image',NULL,'2026-01-23 08:43:06',NULL),(1,30,'image',NULL,'2026-01-23 08:43:06',NULL),(1,31,'image',NULL,'2026-01-23 08:43:06',NULL),(1,32,'image',NULL,'2026-01-23 08:43:06',NULL),(2,1,NULL,'CIM_PASD_','2026-01-23 08:42:55',NULL),(2,8,NULL,'hw_','2026-01-23 08:43:04',NULL),(2,9,NULL,'hw_','2026-01-23 08:43:04',NULL),(2,10,NULL,'hw_','2026-01-23 08:43:04',NULL),(2,11,NULL,NULL,'2026-01-23 08:43:04',NULL),(2,13,NULL,NULL,'2026-01-23 08:43:04',NULL),(2,14,NULL,NULL,'2026-01-23 08:43:04',NULL),(2,15,NULL,NULL,'2026-01-23 08:43:04',NULL),(2,16,NULL,'hw_','2026-01-23 08:43:05',NULL),(2,19,NULL,'hw_','2026-01-23 08:43:05',NULL),(2,22,NULL,NULL,'2026-01-23 08:43:05',NULL),(2,23,NULL,'hw_','2026-01-23 08:43:06',NULL),(2,24,NULL,'traits:','2026-01-23 08:43:06',NULL),(2,25,NULL,'hw_','2026-01-23 08:43:06',NULL),(2,26,NULL,NULL,'2026-01-23 08:43:06',NULL),(2,28,NULL,NULL,'2026-01-23 08:43:06',NULL),(2,29,NULL,NULL,'2026-01-23 08:43:06',NULL),(2,30,NULL,NULL,'2026-01-23 08:43:06',NULL),(2,31,NULL,NULL,'2026-01-23 08:43:06',NULL),(2,32,NULL,NULL,'2026-01-23 08:43:06',NULL),(2,33,NULL,'cinder_','2026-01-23 08:43:07',NULL),(3,1,NULL,'CIM_PASD_','2026-01-23 08:42:55',NULL),(3,2,NULL,'CIM_RASD_','2026-01-23 08:42:56',NULL),(3,3,NULL,'CIM_SASD_','2026-01-23 08:43:03',NULL),(3,4,NULL,'CIM_VSSD_','2026-01-23 08:43:04',NULL),(3,5,NULL,NULL,'2026-01-23 08:43:04',NULL),(3,6,NULL,NULL,'2026-01-23 08:43:04',NULL),(3,7,NULL,NULL,'2026-01-23 08:43:04',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2026-01-23 08:43:04',NULL),(4,1,NULL,'CIM_PASD_','2026-01-23 08:42:55',NULL),(4,2,NULL,'CIM_RASD_','2026-01-23 08:42:56',NULL),(4,3,NULL,'CIM_SASD_','2026-01-23 08:43:03',NULL),(4,4,NULL,'CIM_VSSD_','2026-01-23 08:43:04',NULL),(4,8,NULL,'hw:','2026-01-23 08:43:04',NULL),(4,9,NULL,'hw:','2026-01-23 08:43:04',NULL),(4,10,NULL,'hw:','2026-01-23 08:43:04',NULL),(4,12,NULL,'capabilities:','2026-01-23 08:43:04',NULL),(4,16,NULL,'hw:','2026-01-23 08:43:05',NULL),(4,17,NULL,NULL,'2026-01-23 08:43:05',NULL),(4,18,NULL,NULL,'2026-01-23 08:43:05',NULL),(4,19,NULL,'hw:','2026-01-23 08:43:05',NULL),(4,20,NULL,NULL,'2026-01-23 08:43:05',NULL),(4,21,NULL,NULL,'2026-01-23 08:43:05',NULL),(4,23,NULL,'hw:','2026-01-23 08:43:06',NULL),(4,24,NULL,'traits:','2026-01-23 08:43:06',NULL),(4,25,NULL,'hw:','2026-01-23 08:43:06',NULL),(5,1,'scheduler_hints',NULL,'2026-01-23 08:42:56',NULL),(5,30,'metadata',NULL,'2026-01-23 08:43:06',NULL),(5,31,'metadata',NULL,'2026-01-23 08:43:06',NULL),(5,32,'metadata',NULL,'2026-01-23 08:43:07',NULL),(6,30,NULL,NULL,'2026-01-23 08:43:06',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2026-01-23 08:42:55',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2026-01-23 08:42:56',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2026-01-23 08:43:03',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2026-01-23 08:43:04',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-01-23 08:43:04',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-01-23 08:43:04',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2026-01-23 08:43:04',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2026-01-23 08:43:04',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2026-01-23 08:43:04',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2026-01-23 08:43:04',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2026-01-23 08:43:04',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2026-01-23 08:43:04',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2026-01-23 08:43:04',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2026-01-23 08:43:04',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-23 08:43:04',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-23 08:43:05',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-23 08:43:05',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2026-01-23 08:43:05',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2026-01-23 08:43:05',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-23 08:43:05',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-23 08:43:05',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-23 08:43:05',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2026-01-23 08:43:06',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2026-01-23 08:43:06',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-23 08:43:06',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-23 08:43:06',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2026-01-23 08:43:06',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2026-01-23 08:43:06',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2026-01-23 08:43:06',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2026-01-23 08:43:06',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2026-01-23 08:43:06',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2026-01-23 08:43:06',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2026-01-23 08:43:07',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2026-01-23 08:43:05',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2026-01-23 08:43:05',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2026-01-23 08:43:05',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2026-01-23 08:43:06',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2026-01-23 08:43:06',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2026-01-23 08:43:06',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2026-01-23 08:43:06',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-23 08:43:06',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-23 08:43:06',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-01-23 08:43:06',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-01-23 08:43:06',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-23 08:43:06',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2026-01-23 08:43:06',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2026-01-23 08:43:06',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2026-01-23 08:43:06',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2026-01-23 08:43:06',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2026-01-23 08:43:06',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2026-01-23 08:43:06',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2026-01-23 08:43:06',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2026-01-23 08:43:06',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-23 08:43:07',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-23 08:43:07',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-23 08:43:07',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2026-01-23 08:42:56',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2026-01-23 08:42:56',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2026-01-23 08:42:56',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2026-01-23 08:42:56',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2026-01-23 08:42:56',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2026-01-23 08:42:56',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2026-01-23 08:42:56',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2026-01-23 08:42:57',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-01-23 08:42:58',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2026-01-23 08:42:58',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2026-01-23 08:42:58',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2026-01-23 08:42:58',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2026-01-23 08:42:58',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2026-01-23 08:42:58',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2026-01-23 08:42:58',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2026-01-23 08:42:58',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-01-23 08:42:59',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2026-01-23 08:43:03',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-01-23 08:43:03',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2026-01-23 08:43:03',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2026-01-23 08:43:03',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2026-01-23 08:43:03',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2026-01-23 08:43:03',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2026-01-23 08:43:04',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2026-01-23 08:43:04',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2026-01-23 08:43:04',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2026-01-23 08:43:04',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2026-01-23 08:43:04',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2026-01-23 08:43:04',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2026-01-23 08:43:04',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2026-01-23 08:43:04',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2026-01-23 08:43:04',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2026-01-23 08:43:04',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2026-01-23 08:43:04',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-23 08:43:04',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2026-01-23 08:43:04',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2026-01-23 08:43:04',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2026-01-23 08:43:04',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-23 08:43:04',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-23 08:43:04',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-23 08:43:04',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2026-01-23 08:43:04',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2026-01-23 08:43:04',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2026-01-23 08:43:04',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2026-01-23 08:43:04',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-23 08:43:04',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-01-23 08:43:04',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-01-23 08:43:04',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2026-01-23 08:43:04',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2026-01-23 08:43:04',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2026-01-23 08:43:04',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2026-01-23 08:43:04',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2026-01-23 08:43:04',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-23 08:43:05',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2026-01-23 08:43:05',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2026-01-23 08:43:05',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2026-01-23 08:43:05',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-23 08:43:05',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-23 08:43:05',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-23 08:43:05',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2026-01-23 08:43:05',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-23 08:43:05',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-23 08:43:05',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-23 08:43:05',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-23 08:43:05',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2026-01-23 08:43:05',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2026-01-23 08:43:05',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2026-01-23 08:43:05',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-01-23 08:43:05',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-01-23 08:43:05',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-01-23 08:43:05',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-01-23 08:43:05',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-01-23 08:43:05',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-01-23 08:43:05',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2026-01-23 08:43:05',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2026-01-23 08:43:05',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-23 08:43:05',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-23 08:43:05',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2026-01-23 08:43:06',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2026-01-23 08:43:06',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2026-01-23 08:43:06',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2026-01-23 08:43:06',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2026-01-23 08:43:06',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-23 08:43:06',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2026-01-23 08:43:06',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-01-23 08:43:06',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-01-23 08:43:06',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2026-01-23 08:43:06',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2026-01-23 08:43:06',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2026-01-23 08:43:06',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2026-01-23 08:43:06',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2026-01-23 08:43:06',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2026-01-23 08:43:06',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-01-23 08:43:06',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2026-01-23 08:43:06',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-01-23 08:43:06',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2026-01-23 08:43:06',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2026-01-23 08:43:06',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2026-01-23 08:43:06',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2026-01-23 08:43:06',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2026-01-23 08:43:06',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2026-01-23 08:43:06',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2026-01-23 08:43:06',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-01-23 08:43:06',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-01-23 08:43:06',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2026-01-23 08:43:06',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2026-01-23 08:43:07',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2026-01-23 08:42:55',NULL),(2,'OS::Glance::Image',1,'2026-01-23 08:42:55',NULL),(3,'OS::Nova::Aggregate',1,'2026-01-23 08:42:55',NULL),(4,'OS::Nova::Flavor',1,'2026-01-23 08:42:55',NULL),(5,'OS::Nova::Server',1,'2026-01-23 08:42:55',NULL),(6,'OS::Trove::Instance',1,'2026-01-23 08:43:06',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `external_id` (`external_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','010960fbe58245b384c2cbebe84d3b1f','87ac1761717c4b48bea28f65374beaf8','3311fa0e186143a4a015d25f26ec01a9',0),('UserProject','010960fbe58245b384c2cbebe84d3b1f','87ac1761717c4b48bea28f65374beaf8','8b525a8536444d9a8ebf8067466a1298',0),('UserProject','0c4dd3f894a44f1691bb7a108671da2d','87ac1761717c4b48bea28f65374beaf8','8b525a8536444d9a8ebf8067466a1298',0),('UserProject','0c4dd3f894a44f1691bb7a108671da2d','87ac1761717c4b48bea28f65374beaf8','974b3745f983413dae6fc1870fa3ca58',0),('UserProject','25decd7ec424425c805ac1fe9eb80508','87ac1761717c4b48bea28f65374beaf8','3311fa0e186143a4a015d25f26ec01a9',0),('UserProject','25decd7ec424425c805ac1fe9eb80508','87ac1761717c4b48bea28f65374beaf8','8b525a8536444d9a8ebf8067466a1298',0),('UserProject','56391f81dbdc4570a9c80a65db98922d','87ac1761717c4b48bea28f65374beaf8','3311fa0e186143a4a015d25f26ec01a9',0),('UserProject','56391f81dbdc4570a9c80a65db98922d','87ac1761717c4b48bea28f65374beaf8','8b525a8536444d9a8ebf8067466a1298',0),('UserProject','8d2e978b0d054070a423c0c49b4df797','87ac1761717c4b48bea28f65374beaf8','3311fa0e186143a4a015d25f26ec01a9',0),('UserProject','8d2e978b0d054070a423c0c49b4df797','87ac1761717c4b48bea28f65374beaf8','8b525a8536444d9a8ebf8067466a1298',0),('UserProject','b87c018838734572bbff755bb1e7e142','87ac1761717c4b48bea28f65374beaf8','3311fa0e186143a4a015d25f26ec01a9',0),('UserProject','b87c018838734572bbff755bb1e7e142','87ac1761717c4b48bea28f65374beaf8','8b525a8536444d9a8ebf8067466a1298',0),('UserProject','cdedd065d03042aba376dfbe7952b778','87ac1761717c4b48bea28f65374beaf8','3311fa0e186143a4a015d25f26ec01a9',0),('UserProject','cdedd065d03042aba376dfbe7952b778','87ac1761717c4b48bea28f65374beaf8','8b525a8536444d9a8ebf8067466a1298',0),('UserProject','d8b13965b8db4fbca536b19106251c75','87ac1761717c4b48bea28f65374beaf8','3311fa0e186143a4a015d25f26ec01a9',0),('UserProject','d8b13965b8db4fbca536b19106251c75','87ac1761717c4b48bea28f65374beaf8','8b525a8536444d9a8ebf8067466a1298',0),('UserProject','e0b076c501e34ec29c113b8323ed3983','7ace0d3e1d354841bc1ddea0c12699d6','8b525a8536444d9a8ebf8067466a1298',0),('UserProject','e0b076c501e34ec29c113b8323ed3983','7ace0d3e1d354841bc1ddea0c12699d6','b349e1844d2e446ba746217aa1146951',0),('UserProject','e0b076c501e34ec29c113b8323ed3983','bc78e4a8c7c949df9a4140600519abf2','8b525a8536444d9a8ebf8067466a1298',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('0a1a2b8594af42d3aa9d0d7f3c06792f',NULL,'internal','f9c4b01da3bb434e806d0d08c3ea4d29','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('248b3e0620954eefbcb3d11d4076729f',NULL,'public','ce614f88de40472894aa1c09d07733cd','https://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('28815cca029446228010e05f79d1040f',NULL,'public','f9c4b01da3bb434e806d0d08c3ea4d29','https://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('528436404ffb42fd8b188b905b7212a4',NULL,'public','6506fb6e27014c43928ca80e906569c3','https://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('57de1778b35e4fe097618cfe960b984d',NULL,'public','724df532bf804cf0b49dc0347ebcb9e9','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('8dc9326a81534eb49e930acd9c3d328e',NULL,'public','3bd709bcfad84dd1b9277b156ec44b3f','https://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('9e6ed4fc6dcc41ae82dc7c9376b48ab7',NULL,'public','82a42f07436f46b19a416b3923f1deca','https://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('a6df2a05b5f34c578f718d91129d0fb7',NULL,'internal','982014c814994ba1817da598e0e701fb','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('b0229371a0194fd09bb18712a993d539',NULL,'internal','82a42f07436f46b19a416b3923f1deca','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('b0ab461bce0141409a61eb561e7c4632',NULL,'public','982014c814994ba1817da598e0e701fb','https://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('bd2247d567604ee59d36dfb64e245fd9',NULL,'public','890cbc16a61f4e33b5fd917a54a5eac0','https://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('c15c276c79ea4159b7bb2718ad4ee303',NULL,'internal','3bd709bcfad84dd1b9277b156ec44b3f','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('dd9cefdcc6cc4a25a7a8ee8bff2bb73b',NULL,'internal','6506fb6e27014c43928ca80e906569c3','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('ee90700b7d8842ae970f7bbdf7da723e',NULL,'internal','724df532bf804cf0b49dc0347ebcb9e9','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('f8ca87f27de74b3c894491f989a8838f',NULL,'internal','ce614f88de40472894aa1c09d07733cd','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('fb3e49923a2248b096d5ab402e08fbdd',NULL,'internal','890cbc16a61f4e33b5fd917a54a5eac0','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('8b525a8536444d9a8ebf8067466a1298','974b3745f983413dae6fc1870fa3ca58'),('974b3745f983413dae6fc1870fa3ca58','2e4ec25400b34de793304abcabfadcea');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'e0b076c501e34ec29c113b8323ed3983','default','admin',0,NULL),(2,'8d2e978b0d054070a423c0c49b4df797','default','glance',0,NULL),(3,'d8b13965b8db4fbca536b19106251c75','default','nova',0,NULL),(4,'56391f81dbdc4570a9c80a65db98922d','default','cinder',0,NULL),(5,'cdedd065d03042aba376dfbe7952b778','default','ceilometer',0,NULL),(6,'010960fbe58245b384c2cbebe84d3b1f','default','neutron',0,NULL),(7,'b87c018838734572bbff755bb1e7e142','default','barbican',0,NULL),(8,'25decd7ec424425c805ac1fe9eb80508','default','placement',0,NULL),(9,'0c4dd3f894a44f1691bb7a108671da2d','default','swift',0,NULL),(10,'c96ecbdd7a6d4696bee2b6374a5f7cd5','default','demo_tempestconf',0,NULL),(11,'fa2eca15e17149aeace6846252a9a28f','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$cOaa1u1QwcJWZgzmjuZTDeZM6J.oLWo50/xhUC5iPAQjKfElPTMRu',1769157845510262,NULL,'2026-01-23 08:44:05'),(2,2,NULL,0,'$2b$12$JnsV2ibmNSQNk9OD3viRH.dQxaKpWdQ8Mf4SGfNSxuaVEEAcSUO4W',1769157914440945,NULL,'2026-01-23 08:45:14'),(3,3,NULL,0,'$2b$12$xYSxktD6VywOozG/lXqI0OrDwM5stJZ4ykvzlM7GBCAJ5LYmqmA6W',1769157921969812,NULL,'2026-01-23 08:45:21'),(4,4,NULL,0,'$2b$12$3zouY5srVxi1cdTW1OKlhu4Wqn3z6T2MZRVKDZi3hTUyz6s5tmNvm',1769157926530261,NULL,'2026-01-23 08:45:26'),(5,5,NULL,0,'$2b$12$u2irySqpy9fiu9u8s.9GOODk0AdyO9.0l/zrkhEMVXqpfVNrB8W6e',1769157932109967,NULL,'2026-01-23 08:45:32'),(6,6,NULL,0,'$2b$12$bJkqsFMu98/1cCTbtMsuGen0hHoZiRPmj484zJ7m6buDywzTa3QL6',1769157941356140,NULL,'2026-01-23 08:45:41'),(7,7,NULL,0,'$2b$12$coworLL8NNVQB/pLl3csKO9gOJKc3nNY6RNTejJEPL5wqvn3RhShq',1769157955990023,NULL,'2026-01-23 08:45:55'),(8,8,NULL,0,'$2b$12$X59.zxOSckkVLdwnHW0vxu93RB6eI8vZJZklvGa32ZZImPxU0dvHe',1769157986681215,NULL,'2026-01-23 08:46:26'),(9,9,NULL,0,'$2b$12$0QnTbBoG7/8ugVUyAiFs/OxSFrKDtPYWst43/9lc1TqyrV2rD0kOG',1769159003187071,NULL,'2026-01-23 09:03:23'),(10,10,NULL,0,'$2b$12$nrPtdhjSB5UMtHGpt0N9C.MKBIzo7ZjobdAkoDr2Wl448yj0fXSha',1769160434974366,NULL,'2026-01-23 09:27:14'),(11,11,NULL,0,'$2b$12$SqjlZbHvS38sfsTRGN.CBu7HScUv554K.LfeEIzdoTyKHlG3pTdj2',1769160435817485,NULL,'2026-01-23 09:27:15');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('7ace0d3e1d354841bc1ddea0c12699d6','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0),('87ac1761717c4b48bea28f65374beaf8','service','{}','service',1,'default','default',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('a20fbdc4289e465092b7d7e6a8dc286b','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('bc78e4a8c7c949df9a4140600519abf2','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=482 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (282,NULL,NULL,'8d1d7c58442749759ba7dc3a19799796',NULL,NULL,NULL,NULL,'2026-01-23 09:47:34',NULL,'2026-01-23 09:47:34',NULL,NULL),(283,NULL,'5d69aaa276f94de98e4011fa17428b40',NULL,NULL,NULL,NULL,NULL,'2026-01-23 09:47:36',NULL,'2026-01-23 09:47:36',NULL,NULL),(284,NULL,NULL,'a551525951294e80842b27c064648397',NULL,NULL,NULL,NULL,'2026-01-23 09:47:40',NULL,'2026-01-23 09:47:40',NULL,NULL),(285,NULL,'8abe1ee616494e8d824c1fbc14065cf2',NULL,NULL,NULL,NULL,NULL,'2026-01-23 09:47:45',NULL,'2026-01-23 09:47:45',NULL,NULL),(286,NULL,NULL,'24e721a36de94215b497d067d43f49a0',NULL,NULL,NULL,NULL,'2026-01-23 09:47:50',NULL,'2026-01-23 09:47:50',NULL,NULL),(287,NULL,'9854a162b3d048a48b6c14693b5859d7',NULL,NULL,NULL,NULL,NULL,'2026-01-23 09:47:52',NULL,'2026-01-23 09:47:52',NULL,NULL),(288,NULL,NULL,'23b74e9badfb47168460616e95b5036a',NULL,NULL,NULL,NULL,'2026-01-23 09:48:17',NULL,'2026-01-23 09:48:17',NULL,NULL),(289,NULL,'0a273593b52449cb8606900e7185b1bc',NULL,NULL,NULL,NULL,NULL,'2026-01-23 09:48:21',NULL,'2026-01-23 09:48:21',NULL,NULL),(290,NULL,NULL,'ae77ac206ed246b49262982455564c01',NULL,NULL,NULL,NULL,'2026-01-23 09:48:53',NULL,'2026-01-23 09:48:53',NULL,NULL),(291,NULL,'6ff15972efaf47c1a5483927aa058ee1',NULL,NULL,NULL,NULL,NULL,'2026-01-23 09:48:54',NULL,'2026-01-23 09:48:54',NULL,NULL),(292,NULL,NULL,'e5f8c8d68a94461e9579b3d25ef42e13',NULL,NULL,NULL,NULL,'2026-01-23 09:48:57',NULL,'2026-01-23 09:48:57',NULL,NULL),(293,NULL,'8f2a0c693d2e44208962d6ef210f8f9c',NULL,NULL,NULL,NULL,NULL,'2026-01-23 09:48:59',NULL,'2026-01-23 09:48:59',NULL,NULL),(294,NULL,NULL,'e1860c3b097a4c63a2f260ce7009b92d',NULL,NULL,NULL,NULL,'2026-01-23 09:49:04',NULL,'2026-01-23 09:49:04',NULL,NULL),(295,NULL,'10d5ca3058e143aaafdac91aa6d4d484',NULL,NULL,NULL,NULL,NULL,'2026-01-23 09:49:05',NULL,'2026-01-23 09:49:05',NULL,NULL),(296,NULL,NULL,'deace84b7e09475d8d5c83d51f8309b5',NULL,NULL,NULL,NULL,'2026-01-23 09:49:44',NULL,'2026-01-23 09:49:44',NULL,NULL),(297,NULL,NULL,'8d814ef2afe04103bb6aa24724d61b11',NULL,NULL,NULL,NULL,'2026-01-23 09:49:46',NULL,'2026-01-23 09:49:46',NULL,NULL),(298,NULL,NULL,'a4e0bbe71647486f9b3a5ab404ef4b81',NULL,NULL,NULL,NULL,'2026-01-23 09:49:46',NULL,'2026-01-23 09:49:46',NULL,NULL),(299,NULL,'9aca988de81c4bb08a3d641f83b7a61a',NULL,NULL,NULL,NULL,NULL,'2026-01-23 09:49:46',NULL,'2026-01-23 09:49:46',NULL,NULL),(300,NULL,'15c7fbc4d6794364830639a1fee9ecf0',NULL,NULL,NULL,NULL,NULL,'2026-01-23 09:49:47',NULL,'2026-01-23 09:49:47',NULL,NULL),(301,NULL,'8bc1cfa58cf64be68d66c193cf393e80',NULL,NULL,NULL,NULL,NULL,'2026-01-23 09:49:49',NULL,'2026-01-23 09:49:49',NULL,NULL),(302,NULL,NULL,'4cb83b8ddd0644f898d4be1f7de0b930',NULL,NULL,NULL,NULL,'2026-01-23 09:51:38',NULL,'2026-01-23 09:51:38',NULL,NULL),(303,NULL,'b8b9b5c378f24327912b08252b3c9636',NULL,NULL,NULL,NULL,NULL,'2026-01-23 09:51:40',NULL,'2026-01-23 09:51:40',NULL,NULL),(304,NULL,NULL,'77cda1e9a0404425a06c34637e696603',NULL,NULL,NULL,NULL,'2026-01-23 09:53:22',NULL,'2026-01-23 09:53:22',NULL,NULL),(305,NULL,'390d19f683334995a5268cf9b4d5e464',NULL,NULL,NULL,NULL,NULL,'2026-01-23 09:53:23',NULL,'2026-01-23 09:53:23',NULL,NULL),(306,NULL,NULL,'040257fcfb8e485989e95807791e25f6',NULL,NULL,NULL,NULL,'2026-01-23 09:55:39',NULL,'2026-01-23 09:55:39',NULL,NULL),(307,NULL,'bf8efe4dc7e34393b5cd5a5ef2735ecf',NULL,NULL,NULL,NULL,NULL,'2026-01-23 09:55:42',NULL,'2026-01-23 09:55:42',NULL,NULL),(308,NULL,NULL,'0cfac2191989448ead77e75ca3910ac4',NULL,NULL,NULL,NULL,'2026-01-23 09:55:42',NULL,'2026-01-23 09:55:42',NULL,NULL),(309,NULL,NULL,'f580e77983594afe8e89c5e22cbd6453',NULL,NULL,NULL,NULL,'2026-01-23 09:55:45',NULL,'2026-01-23 09:55:45',NULL,NULL),(310,NULL,'86d938c8e2bb41a79012befd500d1088',NULL,NULL,NULL,NULL,NULL,'2026-01-23 09:55:46',NULL,'2026-01-23 09:55:46',NULL,NULL),(311,NULL,'f47fa2be148e454a8783a4d22de075fe',NULL,NULL,NULL,NULL,NULL,'2026-01-23 09:55:49',NULL,'2026-01-23 09:55:49',NULL,NULL),(312,NULL,NULL,'28a7a778c8ab486fb586e81bb84113be',NULL,NULL,NULL,NULL,'2026-01-23 09:55:50',NULL,'2026-01-23 09:55:50',NULL,NULL),(313,NULL,'61df91981c55482fa5c9a64686c79f9e',NULL,NULL,NULL,NULL,NULL,'2026-01-23 09:55:51',NULL,'2026-01-23 09:55:51',NULL,NULL),(314,NULL,NULL,'d512838ce2b44554b0566fdbb3c702b4',NULL,NULL,NULL,NULL,'2026-01-23 09:56:46',NULL,'2026-01-23 09:56:46',NULL,NULL),(315,NULL,NULL,'1f9a2b2f57d7421a8546d68f5302b9ea',NULL,NULL,NULL,NULL,'2026-01-23 09:56:46',NULL,'2026-01-23 09:56:46',NULL,NULL),(316,NULL,'415cd4c6cfb94b7496855b8d8f55421e',NULL,NULL,NULL,NULL,NULL,'2026-01-23 09:56:48',NULL,'2026-01-23 09:56:48',NULL,NULL),(317,NULL,'9bc2d47d48c446c7ae1fc44cd9c32878',NULL,NULL,NULL,NULL,NULL,'2026-01-23 09:56:52',NULL,'2026-01-23 09:56:52',NULL,NULL),(318,NULL,NULL,'0c18a146d425428f8ba82d37fcdb9c02',NULL,NULL,NULL,NULL,'2026-01-23 09:57:02',NULL,'2026-01-23 09:57:02',NULL,NULL),(319,NULL,'75a27ed7c12e4bfba34376ef35a14d04',NULL,NULL,NULL,NULL,NULL,'2026-01-23 09:57:09',NULL,'2026-01-23 09:57:09',NULL,NULL),(320,NULL,NULL,'e3fbf576a49e4d37ac2a826cce5ae7c8',NULL,NULL,NULL,NULL,'2026-01-23 09:57:32',NULL,'2026-01-23 09:57:32',NULL,NULL),(321,NULL,'18d7959ce7f646d6a690e5976ef97cb3',NULL,NULL,NULL,NULL,NULL,'2026-01-23 09:57:35',NULL,'2026-01-23 09:57:35',NULL,NULL),(322,NULL,NULL,'fb7d106814e948feb72555b92cb0bce7',NULL,NULL,NULL,NULL,'2026-01-23 09:58:04',NULL,'2026-01-23 09:58:04',NULL,NULL),(323,NULL,'49fe499c3ed341249456b8cc11ae8483',NULL,NULL,NULL,NULL,NULL,'2026-01-23 09:58:05',NULL,'2026-01-23 09:58:05',NULL,NULL),(324,NULL,NULL,'2ba9c41274b44742bd852accd5d8cbe1',NULL,NULL,NULL,NULL,'2026-01-23 09:58:14',NULL,'2026-01-23 09:58:14',NULL,NULL),(325,NULL,'a591b57bf4334172b3794e4e70d83016',NULL,NULL,NULL,NULL,NULL,'2026-01-23 09:58:18',NULL,'2026-01-23 09:58:18',NULL,NULL),(326,NULL,NULL,'d83df80213fd40f99fdc68c146fe9a2a',NULL,NULL,NULL,NULL,'2026-01-23 10:00:22',NULL,'2026-01-23 10:00:22',NULL,NULL),(327,NULL,'c288779980de4f03be20b7eed343b775',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:00:24',NULL,'2026-01-23 10:00:24',NULL,NULL),(328,NULL,NULL,'57e3c530deab46758172af6777c8c108',NULL,NULL,NULL,NULL,'2026-01-23 10:01:14',NULL,'2026-01-23 10:01:14',NULL,NULL),(329,NULL,'d557095954714e01b800ed2898d27593',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:01:16',NULL,'2026-01-23 10:01:16',NULL,NULL),(330,NULL,NULL,'35b29e4a06884f7d88683d00f85d4630',NULL,NULL,NULL,NULL,'2026-01-23 10:01:28',NULL,'2026-01-23 10:01:28',NULL,NULL),(331,NULL,NULL,'f1da473b15f64a69960d53e1c1856b38',NULL,NULL,NULL,NULL,'2026-01-23 10:01:29',NULL,'2026-01-23 10:01:29',NULL,NULL),(332,NULL,'8924c80a71a94fdeb114c6bdbdb2939c',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:01:33',NULL,'2026-01-23 10:01:33',NULL,NULL),(333,NULL,'fe54987731bb47a7b39421e163751893',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:01:39',NULL,'2026-01-23 10:01:39',NULL,NULL),(334,NULL,NULL,'9127d08a3bf5404e8cb8c84ed7152834',NULL,NULL,NULL,NULL,'2026-01-23 10:03:20',NULL,'2026-01-23 10:03:20',NULL,NULL),(335,NULL,'449f402258804f41b10f91a13da1176d',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:03:21',NULL,'2026-01-23 10:03:21',NULL,NULL),(336,NULL,NULL,'c09e682996b940dc97c866f9e4f1e74e',NULL,NULL,NULL,NULL,'2026-01-23 10:03:23',NULL,'2026-01-23 10:03:23',NULL,NULL),(337,NULL,'0f5ca0233c1a490aa2d596b88a0ec503',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:03:24',NULL,'2026-01-23 10:03:24',NULL,NULL),(338,NULL,NULL,'b2c0adbb294b4045ae506bd05ff2de94',NULL,NULL,NULL,NULL,'2026-01-23 10:03:26',NULL,'2026-01-23 10:03:26',NULL,NULL),(339,NULL,'d14f274b3072435898b796befa231463',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:03:27',NULL,'2026-01-23 10:03:27',NULL,NULL),(340,NULL,NULL,'175c8371597942d18b2ec02e7010ddbf',NULL,NULL,NULL,NULL,'2026-01-23 10:03:39',NULL,'2026-01-23 10:03:39',NULL,NULL),(341,NULL,'fc506511c3ec4a89b6bdb7d64fa0df08',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:03:42',NULL,'2026-01-23 10:03:42',NULL,NULL),(342,NULL,NULL,'fdaabb8d5b2d4e7caa209f6918f24078',NULL,NULL,NULL,NULL,'2026-01-23 10:04:14',NULL,'2026-01-23 10:04:14',NULL,NULL),(343,NULL,'b6678355ecf9441c916291536c42c2cd',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:04:16',NULL,'2026-01-23 10:04:16',NULL,NULL),(344,NULL,NULL,'faad005151bd403e905a16eb7b539f14',NULL,NULL,NULL,NULL,'2026-01-23 10:04:25',NULL,'2026-01-23 10:04:25',NULL,NULL),(345,NULL,'115a816b885b44c3956744176af911f2',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:04:28',NULL,'2026-01-23 10:04:28',NULL,NULL),(346,NULL,NULL,'7fc54d7ba4d1442d956e0d30350325a2',NULL,NULL,NULL,NULL,'2026-01-23 10:05:25',NULL,'2026-01-23 10:05:25',NULL,NULL),(347,NULL,'ddad636b2dd940bf9c024a1ac19616e1',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:05:26',NULL,'2026-01-23 10:05:26',NULL,NULL),(348,NULL,NULL,'878babe1fbab428f98092e314b2ae0b1',NULL,NULL,NULL,NULL,'2026-01-23 10:05:59',NULL,'2026-01-23 10:05:59',NULL,NULL),(349,NULL,'ca1cc631a7d348a5ad176273e81495bb',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:06:04',NULL,'2026-01-23 10:06:04',NULL,NULL),(350,NULL,NULL,'1a65ac354e8a4e2b965a34382f0645d2',NULL,NULL,NULL,NULL,'2026-01-23 10:06:12',NULL,'2026-01-23 10:06:12',NULL,NULL),(351,NULL,'f418c2e5b22b4eeb9d97365ab71edb23',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:06:18',NULL,'2026-01-23 10:06:18',NULL,NULL),(352,NULL,NULL,'e795a83b4ed54f349fc91be35127621a',NULL,NULL,NULL,NULL,'2026-01-23 10:06:27',NULL,'2026-01-23 10:06:27',NULL,NULL),(353,NULL,'1ab728283a2c4030b3d420c40c877724',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:06:34',NULL,'2026-01-23 10:06:34',NULL,NULL),(354,NULL,NULL,'9d4a5c201efa4992a9ef57d8abdc1675',NULL,NULL,NULL,NULL,'2026-01-23 10:07:11',NULL,'2026-01-23 10:07:11',NULL,NULL),(355,NULL,'74c5c1d0762242f29a5d26033efd9f6d',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:07:13',NULL,'2026-01-23 10:07:13',NULL,NULL),(356,NULL,NULL,'e0fe7d252cd04174840bdf8dfefa3510',NULL,NULL,NULL,NULL,'2026-01-23 10:07:14',NULL,'2026-01-23 10:07:14',NULL,NULL),(357,NULL,NULL,'35542adc40724a44b6569469b5f85951',NULL,NULL,NULL,NULL,'2026-01-23 10:07:14',NULL,'2026-01-23 10:07:14',NULL,NULL),(358,NULL,'3ecb2c0cafc441fd9457198fe09cc97b',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:07:18',NULL,'2026-01-23 10:07:18',NULL,NULL),(359,NULL,NULL,'29710db389c842df836944048225740f',NULL,NULL,NULL,NULL,'2026-01-23 10:07:27',NULL,'2026-01-23 10:07:27',NULL,NULL),(360,NULL,'8c16cd713fa74a88b43e4edf01c273bd',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:07:29',NULL,'2026-01-23 10:07:29',NULL,NULL),(361,NULL,NULL,'0cae28d3746642598ee191045d7c2970',NULL,NULL,NULL,NULL,'2026-01-23 10:08:03',NULL,'2026-01-23 10:08:03',NULL,NULL),(362,NULL,'64e70435945f4186b0e2ab8143c69d80',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:08:04',NULL,'2026-01-23 10:08:04',NULL,NULL),(363,NULL,NULL,'1958f81a58b2424fb1b948199935ef1f',NULL,NULL,NULL,NULL,'2026-01-23 10:08:46',NULL,'2026-01-23 10:08:46',NULL,NULL),(364,NULL,'fdfdb75e86fb49b5b6412f801266e0b2',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:08:47',NULL,'2026-01-23 10:08:47',NULL,NULL),(365,NULL,NULL,'11cb5a7c448c4cb5b509c29925463448',NULL,NULL,NULL,NULL,'2026-01-23 10:09:49',NULL,'2026-01-23 10:09:49',NULL,NULL),(366,NULL,'5b1dffee0b924f70840ddadf2a893b31',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:09:50',NULL,'2026-01-23 10:09:50',NULL,NULL),(367,NULL,NULL,'c99d09acd2e849a69846a6ccda1e0bc7',NULL,NULL,NULL,NULL,'2026-01-23 10:11:34',NULL,'2026-01-23 10:11:34',NULL,NULL),(368,NULL,'924f976bcbb74ec195730b68eebe1f2a',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:11:35',NULL,'2026-01-23 10:11:35',NULL,NULL),(369,NULL,NULL,'49d8a70549b8459da0d7483fc06dfde1',NULL,NULL,NULL,NULL,'2026-01-23 10:11:43',NULL,'2026-01-23 10:11:43',NULL,NULL),(370,NULL,'7c9246f4d92c4dfbbb8111cfef809201',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:11:47',NULL,'2026-01-23 10:11:47',NULL,NULL),(371,NULL,NULL,'ac1d70a837b045eb9d31250d9b662d75',NULL,NULL,NULL,NULL,'2026-01-23 10:11:51',NULL,'2026-01-23 10:11:51',NULL,NULL),(372,NULL,'3cdb1eb123614f588a7b2836ba4fdd1d',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:11:52',NULL,'2026-01-23 10:11:52',NULL,NULL),(373,NULL,NULL,'eb500aabc93044e380f4bc905205803d',NULL,NULL,NULL,NULL,'2026-01-23 10:12:07',NULL,'2026-01-23 10:12:07',NULL,NULL),(374,NULL,'f00cc6e26e5c435b902306c6421e146d',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:12:08',NULL,'2026-01-23 10:12:08',NULL,NULL),(375,NULL,NULL,'cde472cc8af0464992006a69d047d0d4',NULL,NULL,NULL,NULL,'2026-01-23 10:12:08',NULL,'2026-01-23 10:12:08',NULL,NULL),(376,NULL,'746ea02b745c4e21ace4cb49c193899d',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:12:10',NULL,'2026-01-23 10:12:10',NULL,NULL),(377,NULL,NULL,'e1d2dc288e284cfdb76abe73a933efa5',NULL,NULL,NULL,NULL,'2026-01-23 10:13:37',NULL,'2026-01-23 10:13:37',NULL,NULL),(378,NULL,NULL,'16769d78f53d4d82930f098375f374a3',NULL,NULL,NULL,NULL,'2026-01-23 10:13:37',NULL,'2026-01-23 10:13:37',NULL,NULL),(379,NULL,'2353af0cf8d5454eb7611f611cec5a05',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:13:38',NULL,'2026-01-23 10:13:38',NULL,NULL),(380,NULL,'e99c72126dba46b88cfbe88e0099bf72',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:13:39',NULL,'2026-01-23 10:13:39',NULL,NULL),(381,NULL,NULL,'aca3cab576d641d3b89e7dddf155d467',NULL,NULL,NULL,NULL,'2026-01-23 10:15:49',NULL,'2026-01-23 10:15:49',NULL,NULL),(382,NULL,'9dd869ce76e44fc8a82b8bbee1654d33',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:15:51',NULL,'2026-01-23 10:15:51',NULL,NULL),(383,NULL,NULL,'fae914e59ec54f6b80928ef3cc68dbdb',NULL,NULL,NULL,NULL,'2026-01-23 10:16:54',NULL,'2026-01-23 10:16:54',NULL,NULL),(384,NULL,'0a6ba16c4b9d49d3bc24cd7b44935d1f',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:17:09',NULL,'2026-01-23 10:17:09',NULL,NULL),(385,NULL,NULL,'18f5dbf0e00d41b2b913cc1a517bc922',NULL,NULL,NULL,NULL,'2026-01-23 10:18:53',NULL,'2026-01-23 10:18:53',NULL,NULL),(386,NULL,'59cfb6a6a5ea438fb4b12029b4fcea0f',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:18:54',NULL,'2026-01-23 10:18:54',NULL,NULL),(387,NULL,NULL,'95ac13194f0940128d42af3d45d130fa',NULL,NULL,NULL,NULL,'2026-01-23 10:19:03',NULL,'2026-01-23 10:19:03',NULL,NULL),(388,NULL,NULL,'6d0f672c49fc4216b45e3d28e20f10aa',NULL,NULL,NULL,NULL,'2026-01-23 10:19:03',NULL,'2026-01-23 10:19:03',NULL,NULL),(389,NULL,'3ae621f21a8e438fb95152309b38cee5',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:19:04',NULL,'2026-01-23 10:19:04',NULL,NULL),(390,NULL,'a44f4e08c03a46a4b1d369ad6bcb465c',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:19:06',NULL,'2026-01-23 10:19:06',NULL,NULL),(391,NULL,NULL,'c2c5617ce3104251a0aaf4950da1708c',NULL,NULL,NULL,NULL,'2026-01-23 10:20:39',NULL,'2026-01-23 10:20:39',NULL,NULL),(392,NULL,'363e1e6f82e8475f84a35d534d110de1',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:20:46',NULL,'2026-01-23 10:20:46',NULL,NULL),(393,NULL,NULL,'558050347cf24d20a73a9a6d08d4c242',NULL,NULL,NULL,NULL,'2026-01-23 10:22:35',NULL,'2026-01-23 10:22:35',NULL,NULL),(394,NULL,'a6757124292b484abb7a27e68cab3408',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:22:39',NULL,'2026-01-23 10:22:39',NULL,NULL),(395,NULL,NULL,'ec99ae7c69d0438280441e0434374cbf',NULL,NULL,NULL,NULL,'2026-01-23 10:22:55',NULL,'2026-01-23 10:22:55',NULL,NULL),(396,NULL,NULL,'ccff3a2123dd4e849d17cae9e0c33da0',NULL,NULL,NULL,NULL,'2026-01-23 10:22:55',NULL,'2026-01-23 10:22:55',NULL,NULL),(397,NULL,'c59351a1b59c4cc9ad389dff900935f2',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:22:57',NULL,'2026-01-23 10:22:57',NULL,NULL),(398,NULL,NULL,'5052efa70ff64d65823352596a1b77a1',NULL,NULL,NULL,NULL,'2026-01-23 10:23:07',NULL,'2026-01-23 10:23:07',NULL,NULL),(399,NULL,'d432006349684e868003c5be806a0d86',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:23:07',NULL,'2026-01-23 10:23:07',NULL,NULL),(400,NULL,NULL,'aa27656b542b4a53946634e2dc3b7925',NULL,NULL,NULL,NULL,'2026-01-23 10:23:10',NULL,'2026-01-23 10:23:10',NULL,NULL),(401,NULL,'52cb1fa4f2ef4ebb9300c2ffb71921b5',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:23:13',NULL,'2026-01-23 10:23:13',NULL,NULL),(402,NULL,NULL,'ac37a02e35ca45168d217a1444415569',NULL,NULL,NULL,NULL,'2026-01-23 10:23:24',NULL,'2026-01-23 10:23:24',NULL,NULL),(403,NULL,'aa744bcb00cc46deb672354c357387d4',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:23:25',NULL,'2026-01-23 10:23:25',NULL,NULL),(404,NULL,NULL,'c041da0a601a4260b29fc9c65719597f',NULL,NULL,NULL,NULL,'2026-01-23 10:25:45',NULL,'2026-01-23 10:25:45',NULL,NULL),(405,NULL,NULL,'7239d92802914cbe86703080f5ab29fc',NULL,NULL,NULL,NULL,'2026-01-23 10:25:45',NULL,'2026-01-23 10:25:45',NULL,NULL),(406,NULL,'b976daabc8124a99814954633f99ed7b',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:25:46',NULL,'2026-01-23 10:25:46',NULL,NULL),(407,NULL,'457c6412153947258c628c9a3bf90a58',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:25:46',NULL,'2026-01-23 10:25:46',NULL,NULL),(408,NULL,NULL,'01b7396ecc574dd6ba2df2f406921223',NULL,NULL,NULL,NULL,'2026-01-23 10:27:35',NULL,'2026-01-23 10:27:35',NULL,NULL),(409,NULL,'c7c25c6bb33b41bf9cd8febb8259fd87',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:27:37',NULL,'2026-01-23 10:27:37',NULL,NULL),(410,NULL,NULL,'0d6a628e0dcb441fa41457bf719e65a0',NULL,NULL,NULL,NULL,'2026-01-23 10:29:34',NULL,'2026-01-23 10:29:34',NULL,NULL),(411,NULL,'5c27429e1d8f433a8a67ddb76f8798f1',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:29:35',NULL,'2026-01-23 10:29:35',NULL,NULL),(412,NULL,NULL,'8e1f41f21f79408d8dff1331cfd1e0db',NULL,NULL,NULL,NULL,'2026-01-23 10:32:44',NULL,'2026-01-23 10:32:44',NULL,NULL),(413,NULL,NULL,'18f20b0f7363412ca8a209dbd6a7f98a',NULL,NULL,NULL,NULL,'2026-01-23 10:32:45',NULL,'2026-01-23 10:32:45',NULL,NULL),(414,NULL,'ea49d7e87f1d45cc9b3235d577c20104',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:32:49',NULL,'2026-01-23 10:32:49',NULL,NULL),(415,NULL,'7be5cb5abaf44b0a9c0c307d348d8f75',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:32:52',NULL,'2026-01-23 10:32:52',NULL,NULL),(416,NULL,NULL,'faf3ad4d844b47b2a686c53b0a4fc766',NULL,NULL,NULL,NULL,'2026-01-23 10:33:26',NULL,'2026-01-23 10:33:26',NULL,NULL),(417,NULL,NULL,'96e38c086042403786f2a2317d6d31d7',NULL,NULL,NULL,NULL,'2026-01-23 10:33:27',NULL,'2026-01-23 10:33:27',NULL,NULL),(418,NULL,'3dc2c9070a0543c4997d12694e515cab',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:33:28',NULL,'2026-01-23 10:33:28',NULL,NULL),(419,NULL,NULL,'60291ce86b6946629a2e48f6680312cb',NULL,NULL,NULL,NULL,'2026-01-23 10:34:07',NULL,'2026-01-23 10:34:07',NULL,NULL),(420,NULL,NULL,'84ceb246f1934891b9b12db8732cb158',NULL,NULL,NULL,NULL,'2026-01-23 10:34:08',NULL,'2026-01-23 10:34:08',NULL,NULL),(421,NULL,'99547eb325d243078514792200e3a7d8',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:34:11',NULL,'2026-01-23 10:34:11',NULL,NULL),(422,NULL,'98c94577fcdb4c3d893898ede79ea2d4',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:34:13',NULL,'2026-01-23 10:34:13',NULL,NULL),(423,NULL,NULL,'e1629a4b14764dddaabcadd16f3e1c1c',NULL,NULL,NULL,NULL,'2026-01-23 10:36:50',NULL,'2026-01-23 10:36:50',NULL,NULL),(424,NULL,'815b71acf60d4ed8933ebd05228fa0c0',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:36:51',NULL,'2026-01-23 10:36:51',NULL,NULL),(425,NULL,NULL,'b0867528d6b94b2eafd8a5565390a984',NULL,NULL,NULL,NULL,'2026-01-23 10:36:54',NULL,'2026-01-23 10:36:54',NULL,NULL),(426,NULL,NULL,'fd5d90103d184bdb861730f2f5ddbe17',NULL,NULL,NULL,NULL,'2026-01-23 10:36:54',NULL,'2026-01-23 10:36:54',NULL,NULL),(427,NULL,'ae62e47099014bac89901be6fa0509f3',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:36:55',NULL,'2026-01-23 10:36:55',NULL,NULL),(428,NULL,NULL,'4016f133f441491ab245d0b8e9d6d7f5',NULL,NULL,NULL,NULL,'2026-01-23 10:37:29',NULL,'2026-01-23 10:37:29',NULL,NULL),(429,NULL,'b6db0c8b5ec04031aaacc904f210c5dd',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:37:31',NULL,'2026-01-23 10:37:31',NULL,NULL),(430,NULL,NULL,'71ba9dd1a5164962bdf87c95321cd1a1',NULL,NULL,NULL,NULL,'2026-01-23 10:37:33',NULL,'2026-01-23 10:37:33',NULL,NULL),(431,NULL,'362214aef10f4c6fac731e77970a3794',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:37:37',NULL,'2026-01-23 10:37:37',NULL,NULL),(432,NULL,NULL,'9a8ce4c88e8b46c5806ada5e3a6cdbbf',NULL,NULL,NULL,NULL,'2026-01-23 10:37:39',NULL,'2026-01-23 10:37:39',NULL,NULL),(433,NULL,NULL,'0506b1ddfe5c4cce9c2cd0105cb207ec',NULL,NULL,NULL,NULL,'2026-01-23 10:37:40',NULL,'2026-01-23 10:37:40',NULL,NULL),(434,NULL,'bb8def59144947b4a6c6cab5a35aeafa',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:37:41',NULL,'2026-01-23 10:37:41',NULL,NULL),(435,NULL,'d59dad6496894352a2f4c7eb66ca1914',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:37:42',NULL,'2026-01-23 10:37:42',NULL,NULL),(436,NULL,NULL,'a3cd8c3758e14f9c8e4ad1a9a94a9995',NULL,NULL,NULL,NULL,'2026-01-23 10:38:13',NULL,'2026-01-23 10:38:13',NULL,NULL),(437,NULL,NULL,'3c17acb50b0d49d4b062d68aa88d1f7f',NULL,NULL,NULL,NULL,'2026-01-23 10:38:14',NULL,'2026-01-23 10:38:14',NULL,NULL),(438,NULL,NULL,'3718469f9f4d487c8ea41070edd380c2',NULL,NULL,NULL,NULL,'2026-01-23 10:38:14',NULL,'2026-01-23 10:38:14',NULL,NULL),(439,NULL,'b27af793a8cc42259216fbeaa302ba03',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:38:17',NULL,'2026-01-23 10:38:17',NULL,NULL),(440,NULL,'974d993ac5554138956190507a74f4fc',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:38:18',NULL,'2026-01-23 10:38:18',NULL,NULL),(441,NULL,'d8887855ebd545a6bdab3b6a18c19dd9',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:38:19',NULL,'2026-01-23 10:38:19',NULL,NULL),(442,NULL,NULL,'9609ee98328640299138fa34258ef48f',NULL,NULL,NULL,NULL,'2026-01-23 10:39:49',NULL,'2026-01-23 10:39:49',NULL,NULL),(443,NULL,NULL,'e31ceb803cb146feabfc6399ebf2570e',NULL,NULL,NULL,NULL,'2026-01-23 10:39:49',NULL,'2026-01-23 10:39:49',NULL,NULL),(444,NULL,'1e1db35d2f4c4fc2ac353ea033ff2412',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:39:51',NULL,'2026-01-23 10:39:51',NULL,NULL),(445,NULL,'95243c9b3c544aff8e9ee6043bb6f522',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:39:52',NULL,'2026-01-23 10:39:52',NULL,NULL),(446,NULL,NULL,'a9d677e04372453aaea353af3361fe80',NULL,NULL,NULL,NULL,'2026-01-23 10:40:15',NULL,'2026-01-23 10:40:15',NULL,NULL),(447,NULL,NULL,'a25d10a5d9e04913a35317f5c3b187c7',NULL,NULL,NULL,NULL,'2026-01-23 10:40:16',NULL,'2026-01-23 10:40:16',NULL,NULL),(448,NULL,'ecd453e6632f42749f93ba49369d62a6',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:40:19',NULL,'2026-01-23 10:40:19',NULL,NULL),(449,NULL,'bf5c481b3a08473bbe31f699fba4e08f',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:40:21',NULL,'2026-01-23 10:40:21',NULL,NULL),(450,NULL,NULL,'93cd560e84264023877c47122b5919de',NULL,NULL,NULL,NULL,'2026-01-23 10:44:51',NULL,'2026-01-23 10:44:51',NULL,NULL),(451,NULL,'6e762fca3b634c7aa1d994314c059c54',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:44:52',NULL,'2026-01-23 10:44:52',NULL,NULL),(452,NULL,NULL,'eb70c3aee8b64273a1930c0c2c231aff',NULL,NULL,NULL,NULL,'2026-01-23 10:48:27',NULL,'2026-01-23 10:48:27',NULL,NULL),(453,NULL,NULL,'7b2876de04d54d54b8537ddfcf0184f8',NULL,NULL,NULL,NULL,'2026-01-23 10:48:28',NULL,'2026-01-23 10:48:28',NULL,NULL),(454,NULL,'b045f2cc08da45bb8db0540a0bab8013',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:48:29',NULL,'2026-01-23 10:48:29',NULL,NULL),(455,NULL,'d27c5465284b48a5818ef931d6251c43',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:48:30',NULL,'2026-01-23 10:48:30',NULL,NULL),(456,NULL,NULL,'296341ffca2441dc807d285fa14c966d',NULL,NULL,NULL,NULL,'2026-01-23 10:49:30',NULL,'2026-01-23 10:49:30',NULL,NULL),(457,NULL,'36d7e7c7ddbd4cf785fafd0d35b0a2d8',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:49:32',NULL,'2026-01-23 10:49:32',NULL,NULL),(458,NULL,NULL,'31e408829d1a48ab9abdfcd623b2c8b6',NULL,NULL,NULL,NULL,'2026-01-23 10:49:46',NULL,'2026-01-23 10:49:46',NULL,NULL),(459,NULL,'23776559930d49e8ade3d5f91aa5dfe4',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:49:50',NULL,'2026-01-23 10:49:50',NULL,NULL),(460,NULL,NULL,'a1f4ff4112314d79bcd0d5e13b082652',NULL,NULL,NULL,NULL,'2026-01-23 10:50:06',NULL,'2026-01-23 10:50:06',NULL,NULL),(461,NULL,'47c668e58db64e6a9121fb429d3bb9aa',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:50:08',NULL,'2026-01-23 10:50:08',NULL,NULL),(462,NULL,NULL,'7d7e6f562c9d4d81bf1f8d5462870e30',NULL,NULL,NULL,NULL,'2026-01-23 10:52:22',NULL,'2026-01-23 10:52:22',NULL,NULL),(463,NULL,NULL,'e171c2bcad744aa9bf212495cf0d1c03',NULL,NULL,NULL,NULL,'2026-01-23 10:52:22',NULL,'2026-01-23 10:52:22',NULL,NULL),(464,NULL,'9533be9d361246bdb0a7c1bd3015db66',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:52:23',NULL,'2026-01-23 10:52:23',NULL,NULL),(465,NULL,'b6649a1d223341519a4c49560c6b5140',NULL,NULL,NULL,NULL,NULL,'2026-01-23 10:52:24',NULL,'2026-01-23 10:52:24',NULL,NULL),(466,NULL,NULL,'420c366dc5dc45a48da4e0b18c93043f',NULL,NULL,NULL,NULL,'2026-01-23 11:08:53',NULL,'2026-01-23 11:08:53',NULL,NULL),(467,NULL,NULL,'22656a4d33784250b8f522a77dc0909d',NULL,NULL,NULL,NULL,'2026-01-23 11:08:53',NULL,'2026-01-23 11:08:53',NULL,NULL),(468,NULL,'eac31b2500aa40729c9ae6441d1a3f2e',NULL,NULL,NULL,NULL,NULL,'2026-01-23 11:08:55',NULL,'2026-01-23 11:08:55',NULL,NULL),(469,NULL,'c06f98b51aeb48de91d116fda54a161f',NULL,NULL,NULL,NULL,NULL,'2026-01-23 11:08:56',NULL,'2026-01-23 11:08:56',NULL,NULL),(470,NULL,NULL,'1768560f7fe74b5284d84f78d3da759b',NULL,NULL,NULL,NULL,'2026-01-23 11:09:55',NULL,'2026-01-23 11:09:55',NULL,NULL),(471,NULL,NULL,'71869dbc0ba44ab6918c8d7088c84d37',NULL,NULL,NULL,NULL,'2026-01-23 11:09:55',NULL,'2026-01-23 11:09:55',NULL,NULL),(472,NULL,'6dfc80710a6b4e6385f114bbc1c309b2',NULL,NULL,NULL,NULL,NULL,'2026-01-23 11:09:57',NULL,'2026-01-23 11:09:57',NULL,NULL),(473,NULL,'2df647e356a849a08d3fbb00caa201f1',NULL,NULL,NULL,NULL,NULL,'2026-01-23 11:09:58',NULL,'2026-01-23 11:09:58',NULL,NULL),(474,NULL,NULL,'ef851bc79aae46408ca97fb0b85e7125',NULL,NULL,NULL,NULL,'2026-01-23 11:11:37',NULL,'2026-01-23 11:11:37',NULL,NULL),(475,NULL,NULL,'ac51edf400184ec0b11ee5acc335ff21',NULL,NULL,NULL,NULL,'2026-01-23 11:11:37',NULL,'2026-01-23 11:11:37',NULL,NULL),(476,NULL,'76608d1b79f84e2385a2dcadacaea9f3',NULL,NULL,NULL,NULL,NULL,'2026-01-23 11:11:39',NULL,'2026-01-23 11:11:39',NULL,NULL),(477,NULL,'d4691e06029a4b11bbda2856a451bd88',NULL,NULL,NULL,NULL,NULL,'2026-01-23 11:11:40',NULL,'2026-01-23 11:11:40',NULL,NULL),(478,NULL,NULL,'5d6a458f5d9345379b05f0cdb69a7b0f',NULL,NULL,NULL,NULL,'2026-01-23 11:17:09',NULL,'2026-01-23 11:17:09',NULL,NULL),(479,NULL,NULL,'17b27e3888fa4048bfa48056b91a2da6',NULL,NULL,NULL,NULL,'2026-01-23 11:17:10',NULL,'2026-01-23 11:17:10',NULL,NULL),(480,NULL,'3a245f7970f14fffa60af2ff972b4bfd',NULL,NULL,NULL,NULL,NULL,'2026-01-23 11:17:14',NULL,'2026-01-23 11:17:14',NULL,NULL),(481,NULL,'000377f3b8de425db948ee5c0f3d4ca3',NULL,NULL,NULL,NULL,NULL,'2026-01-23 11:17:16',NULL,'2026-01-23 11:17:16',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('2e4ec25400b34de793304abcabfadcea','reader','{}','<<null>>',NULL),('3311fa0e186143a4a015d25f26ec01a9','service','{}','<<null>>',NULL),('6e7bfe1542674e018b27678daa547908','ResellerAdmin','{}','<<null>>',NULL),('8b525a8536444d9a8ebf8067466a1298','admin','{}','<<null>>',NULL),('974b3745f983413dae6fc1870fa3ca58','member','{}','<<null>>',NULL),('b349e1844d2e446ba746217aa1146951','swiftoperator','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('2e4ec25400b34de793304abcabfadcea','IMMU','true'),('8b525a8536444d9a8ebf8067466a1298','IMMU','true'),('974b3745f983413dae6fc1870fa3ca58','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('3bd709bcfad84dd1b9277b156ec44b3f','identity',1,'{\"name\": \"keystone\"}'),('50bff91cb7e0447bb9a75178e53b62b8','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('6506fb6e27014c43928ca80e906569c3','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('724df532bf804cf0b49dc0347ebcb9e9','object-store',1,'{\"name\": \"swift\", \"description\": \"OpenStack Object Storage\"}'),('82a42f07436f46b19a416b3923f1deca','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('890cbc16a61f4e33b5fd917a54a5eac0','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('982014c814994ba1817da598e0e701fb','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('ce614f88de40472894aa1c09d07733cd','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('f9c4b01da3bb434e806d0d08c3ea4d29','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','e0b076c501e34ec29c113b8323ed3983','system','8b525a8536444d9a8ebf8067466a1298',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_trust_id` (`trust_id`),
  KEY `ix_token_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('010960fbe58245b384c2cbebe84d3b1f','{}',1,'87ac1761717c4b48bea28f65374beaf8','2026-01-23 08:45:41','2026-01-23','default'),('0c4dd3f894a44f1691bb7a108671da2d','{}',1,'87ac1761717c4b48bea28f65374beaf8','2026-01-23 09:03:23',NULL,'default'),('25decd7ec424425c805ac1fe9eb80508','{}',1,'87ac1761717c4b48bea28f65374beaf8','2026-01-23 08:46:26','2026-01-23','default'),('56391f81dbdc4570a9c80a65db98922d','{}',1,'87ac1761717c4b48bea28f65374beaf8','2026-01-23 08:45:26','2026-01-23','default'),('8d2e978b0d054070a423c0c49b4df797','{}',1,'87ac1761717c4b48bea28f65374beaf8','2026-01-23 08:45:14','2026-01-23','default'),('b87c018838734572bbff755bb1e7e142','{}',1,'87ac1761717c4b48bea28f65374beaf8','2026-01-23 08:45:56','2026-01-23','default'),('c96ecbdd7a6d4696bee2b6374a5f7cd5','{\"tenantId\": \"bc78e4a8c7c949df9a4140600519abf2\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2026-01-23 09:27:15',NULL,'default'),('cdedd065d03042aba376dfbe7952b778','{}',1,'87ac1761717c4b48bea28f65374beaf8','2026-01-23 08:45:32','2026-01-23','default'),('d8b13965b8db4fbca536b19106251c75','{}',1,'87ac1761717c4b48bea28f65374beaf8','2026-01-23 08:45:22','2026-01-23','default'),('e0b076c501e34ec29c113b8323ed3983','{}',1,NULL,'2026-01-23 08:44:05','2026-01-23','default'),('fa2eca15e17149aeace6846252a9a28f','{\"tenantId\": \"a20fbdc4289e465092b7d7e6a8dc286b\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2026-01-23 09:27:16',NULL,'default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','glance','glance_354f','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_354f','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','keystone','keystone_cc0e','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_cc0e','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','placement','placement_2559','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_2559','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_a875','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_17b4','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_39a2','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_a875','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_17b4','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_39a2','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_0bb7','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_0bb7','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_1b57','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_1b57','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1769157742}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1769157742}'),('localhost','glance_354f','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B9106FBFFDA0D018FFE065A0DF50C11012CF7DE9\",\"password_last_changed\":1769157741}'),('%','glance_354f','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B9106FBFFDA0D018FFE065A0DF50C11012CF7DE9\",\"password_last_changed\":1769157741}'),('localhost','keystone_cc0e','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*49900B484BED2CE144A7F1EB810B97A62239258C\",\"password_last_changed\":1769157745}'),('%','keystone_cc0e','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*49900B484BED2CE144A7F1EB810B97A62239258C\",\"password_last_changed\":1769157745}'),('localhost','placement_2559','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*C9F26A9A28C4A07A6D19C70155595BDFF3D007DB\",\"password_last_changed\":1769157746}'),('%','placement_2559','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*C9F26A9A28C4A07A6D19C70155595BDFF3D007DB\",\"password_last_changed\":1769157746}'),('localhost','neutron_a875','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*DF7B33E943F29B7A3569594B0A67A94F31D74382\",\"password_last_changed\":1769157810}'),('localhost','barbican_17b4','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*BE342ED22132407001126ED75457A2D1F084047C\",\"password_last_changed\":1769157810}'),('localhost','cinder_39a2','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*DDEA7258C5453C23AADFFF8FFB3FB34880674D84\",\"password_last_changed\":1769157811}'),('%','neutron_a875','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*DF7B33E943F29B7A3569594B0A67A94F31D74382\",\"password_last_changed\":1769157812}'),('%','barbican_17b4','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*BE342ED22132407001126ED75457A2D1F084047C\",\"password_last_changed\":1769157812}'),('%','cinder_39a2','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*DDEA7258C5453C23AADFFF8FFB3FB34880674D84\",\"password_last_changed\":1769157812}'),('localhost','nova_api_0bb7','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B3B8737F2C3F8CB42FDFFF784FFBB3E5A7A302E3\",\"password_last_changed\":1769157928}'),('%','nova_api_0bb7','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B3B8737F2C3F8CB42FDFFF784FFBB3E5A7A302E3\",\"password_last_changed\":1769157928}'),('localhost','nova_cell0_1b57','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*12AFAE9A104DA6EF285DF5D610C6C771F3D2FC9E\",\"password_last_changed\":1769157928}'),('%','nova_cell0_1b57','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*12AFAE9A104DA6EF285DF5D610C6C771F3D2FC9E\",\"password_last_changed\":1769157928}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mysql_plugin\n-------------------------------------\n\nA plugin can be installed with the mysql_plugin utility if the server is\ncompletely offline.\n\nThe syntax is:\n\nmysql_plugin [options] <plugin> ENABLE|DISABLE\n\nFor example, to install the server_audit audit plugin, you could execute the\nfollowing:\n\nmysql_plugin server_audit ENABLE\n\nIf a plugin is installed with this utility, then a record will be added to the\nmysql.plugins table for the plugin. This means that the plugin will\nautomatically be loaded every time the server restarts, unless specifically\nuninstalled or deactivated.\n\nConfiguring the Plugin Directory\n--------------------------------\n\nWhen a plugin is being installed, the server looks for the plugin\'s library in\nthe server\'s plugin directory. This directory is configured by the plugin_dir\nsystem variable. This can be specified as a command-line argument to mysqld or\nit can be specified in a relevant server option group in an option file. For\nexample:\n\n[mariadb]\n...\nplugin_dir = /usr/lib64/mysql/plugin\n\nConfiguring the Minimum Plugin Maturity\n---------------------------------------\n\nWhen a plugin is being installed, the server compares the plugin\'s maturity\nlevel against the server\'s minimum allowed plugin maturity. This can help\nprevent users from using unstable plugins on production servers. This minimum\nplugin maturity is configured by the plugin_maturity system variable. This can\nbe specified as a command-line argument to mysqld or it can be specified in a\nrelevant server option group in an option file. For example:\n\n[mariadb]\n...\nplugin_maturity = stable\n\nConfiguring Plugin Activation at Server Startup\n-----------------------------------------------\n\nA plugin will be loaded by default when the server starts if:\n\n* The plugin was installed with the INSTALL SONAME statement.\n* The plugin was installed with the INSTALL PLUGIN statement.\n* The plugin was installed with the mysql_plugin utility.\n* The server is configured to load the plugin with the --plugin-load-add\noption.\n* The server is configured to load the plugin with the --plugin-load option.\n\nThis behavior can be changed with special options that take the form\n--plugin-name. For example, for the server_audit audit plugin, the special\noption is called --server-audit.\n\nThe possible values for these special options are:\n\n+---------------------------------------+------------------------------------+\n| Option Value                          | Description                        |\n+---------------------------------------+------------------------------------+\n| OFF                                   | Disables the plugin without        |\n|                                       | removing it from the               |\n|                                       | mysql.plugins table.               |\n+---------------------------------------+------------------------------------+\n| ON                                    | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will still continue         |\n|                                       | starting up, but the plugin will   |\n|                                       | be disabled.                       |\n+---------------------------------------+------------------------------------+\n| FORCE                                 | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error.                             |\n+---------------------------------------+------------------------------------+\n| FORCE_PLUS_PERMANENT                  | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error. In addition, the plugin     |\n|                                       | cannot be uninstalled with         |\n|                                       | UNINSTALL SONAME or UNINSTALL      |\n|                                       | PLUGIN while the server is         |\n|                                       | running.                           |\n+---------------------------------------+------------------------------------+\n\nA plugin\'s status can be found by looking at the PLUGIN_STATUS column of the\ninformation_schema.PLUGINS table.\n\nUninstalling Plugins\n--------------------\n\nPlugins that are found in the mysql.plugin table, that is those that were\ninstalled with INSTALL SONAME, INSTALL PLUGIN or mysql_plugin can be\nuninstalled in one of two ways:\n\n* The UNINSTALL SONAME or the UNINSTALL PLUGIN statement while the server is\nrunning\n* With mysql_plugin while the server is offline.\n\nPlugins that were enabled as a --plugin-load option do not need to be\nuninstalled. If --plugin-load is omitted the next time the server starts, or\nthe plugin is not listed as one of the --plugin-load entries, the plugin will\nnot be loaded.\n\nUNINSTALL PLUGIN uninstalls a single installed plugin, while UNINSTALL SONAME\nuninstalls all plugins belonging to a given library.\n\nURL: https://mariadb.com/kb/en/plugin-overview/','','https://mariadb.com/kb/en/plugin-overview/'),(79,'MBR Definition',6,'Description\n-----------\n\nThe MBR (Minimum Bounding Rectangle), or Envelope is the bounding geometry,\nformed by the minimum and maximum (X,Y) coordinates:\n\nExamples\n--------\n\n((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nURL: https://mariadb.com/kb/en/mbr-definition/','','https://mariadb.com/kb/en/mbr-definition/'),(80,'MBRContains',6,'Syntax\n------\n\nMBRContains(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\ncontains the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\n\nSET @g2 = GeomFromText(\'Point(1 1)\');\n\nSELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n+----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrcontains/','','https://mariadb.com/kb/en/mbrcontains/'),(82,'MBREqual',6,'Syntax\n------\n\nMBREqual(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are the same.\n\nExamples\n--------\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 2)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 2, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 3)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 4, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 0 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/mbrequal/','','https://mariadb.com/kb/en/mbrequal/'),(86,'MBRWithin',6,'Syntax\n------\n\nMBRWithin(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1 is\nwithin the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRContains().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nSELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n\nURL: https://mariadb.com/kb/en/mbrwithin/','','https://mariadb.com/kb/en/mbrwithin/'),(75,'UNINSTALL PLUGIN',5,'Syntax\n------\n\nUNINSTALL PLUGIN [IF EXISTS] plugin_name\n\nDescription\n-----------\n\nThis statement removes a single installed plugin. To uninstall the whole\nlibrary which contains the plugin, use UNINSTALL SONAME. You cannot uninstall\na plugin if any table that uses it is open.\n\nplugin_name must be the name of some plugin that is listed in the mysql.plugin\ntable. The server executes the plugin\'s deinitialization function and removes\nthe row for the plugin from the mysql.plugin table, so that subsequent server\nrestarts will not load and initialize the plugin. UNINSTALL PLUGIN does not\nremove the plugin\'s shared library file.\n\nTo use UNINSTALL PLUGIN, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nUNINSTALL PLUGIN example;\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------+\n| Level | Code | Message                       |\n+-------+------+-------------------------------+\n| Note  | 1305 | PLUGIN example does not exist |\n+-------+------+-------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-plugin/','','https://mariadb.com/kb/en/uninstall-plugin/'),(76,'INSTALL SONAME',5,'Syntax\n------\n\nINSTALL SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of INSTALL PLUGIN. It installs all plugins from a\ngiven plugin_library. See INSTALL PLUGIN for details.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL SONAME adds one or more lines to the mysql.plugin table that describes\nthe plugin. This table contains the plugin name and library file name.\n\nINSTALL SONAME causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL SONAME also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL SONAME, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nSONAME only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nIf you need to install only one plugin from a library, use the INSTALL PLUGIN\nstatement.\n\nExamples\n--------\n\nTo load the XtraDB storage engine and all of its information_schema tables\nwith one statement, use\n\nINSTALL SONAME \'ha_xtradb\';\n\nThis statement can be used instead of INSTALL PLUGIN even when the library\ncontains only one plugin:\n\nINSTALL SONAME \'ha_sequence\';\n\nURL: https://mariadb.com/kb/en/install-soname/','','https://mariadb.com/kb/en/install-soname/'),(77,'UNINSTALL SONAME',5,'Syntax\n------\n\nUNINSTALL SONAME  [IF EXISTS] \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of UNINSTALL PLUGIN statement, that removes all\nplugins belonging to a specified plugin_library. See UNINSTALL PLUGIN for\ndetails.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nTo use UNINSTALL SONAME, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin library does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nTo uninstall the XtraDB plugin and all of its information_schema tables with\none statement, use\n\nUNINSTALL SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------------+\n| Level | Code | Message                             |\n+-------+------+-------------------------------------+\n| Note  | 1305 | SONAME ha_example.so does not exist |\n+-------+------+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-soname/','','https://mariadb.com/kb/en/uninstall-soname/'),(90,'NULLIF',7,'Syntax\n------\n\nNULLIF(expr1,expr2)\n\nDescription\n-----------\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is the\nsame as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nExamples\n--------\n\nSELECT NULLIF(1,1);\n+-------------+\n| NULLIF(1,1) |\n+-------------+\n|        NULL |\n+-------------+\n\nSELECT NULLIF(1,2);\n+-------------+\n| NULLIF(1,2) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/nullif/','','https://mariadb.com/kb/en/nullif/'),(91,'NVL',7,'MariaDB starting with 10.3\n--------------------------\nFrom MariaDB 10.3, NVL is a synonym for IFNULL.\n\nURL: https://mariadb.com/kb/en/nvl/','','https://mariadb.com/kb/en/nvl/'),(92,'NVL2',7,'MariaDB starting with 10.3\n--------------------------\nThe NLV2 function was introduced in MariaDB 10.3.0.\n\nSyntax\n------\n\nNVL2(expr1,expr2,expr3)\n\nDescription\n-----------\n\nThe NVL2 function returns a value based on whether a specified expression is\nNULL or not. If expr1 is not NULL, then NVL2 returns expr2. If expr1 is NULL,\nthen NVL2 returns expr3.\n\nExamples\n--------\n\nSELECT NVL2(NULL,1,2);\n+----------------+\n| NVL2(NULL,1,2) |\n+----------------+\n|              2 |\n+----------------+\n\nSELECT NVL2(\'x\',1,2);\n+---------------+\n| NVL2(\'x\',1,2) |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/nvl2/','','https://mariadb.com/kb/en/nvl2/'),(81,'MBRDisjoint',6,'Syntax\n------\n\nMBRDisjoint(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are disjoint. Two geometries are disjoint if they do not\nintersect, that is touch or overlap.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECTmbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrdisjoint/','','https://mariadb.com/kb/en/mbrdisjoint/'),(83,'MBRIntersects',6,'Syntax\n------\n\nMBRIntersects(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 intersect.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      1 |\n+------------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      0 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/mbrintersects/','','https://mariadb.com/kb/en/mbrintersects/'),(84,'MBROverlaps',6,'Syntax\n------\n\nMBROverlaps(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 overlap. The term spatially overlaps is used if two\ngeometries intersect and their intersection results in a geometry of the same\ndimension but not equal to either of the given geometries.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbroverlaps/','','https://mariadb.com/kb/en/mbroverlaps/'),(85,'MBRTouches',6,'Syntax\n------\n\nMBRTouches(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 touch. Two geometries spatially touch if the interiors of\nthe geometries do not intersect, but the boundary of one of the geometries\nintersects either the boundary or the interior of the other.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   1 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/mbrtouches/','','https://mariadb.com/kb/en/mbrtouches/'),(87,'CASE OPERATOR',7,'Syntax\n------\n\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nDescription\n-----------\n\nThe first version returns the result where value=compare_value. The second\nversion returns the result for the first condition that is true. If there was\nno matching result value, the result after ELSE is returned, or NULL if there\nis no ELSE part.\n\nThere is also a CASE statement, which differs from the CASE operator described\nhere.\n\nExamples\n--------\n\nSELECT CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END;\n+------------------------------------------------------------+\n| CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END |\n+------------------------------------------------------------+\n| one                                                        |\n+------------------------------------------------------------+\n\nSELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n+--------------------------------------------+\n| CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END |\n+--------------------------------------------+\n| true                                       |\n+--------------------------------------------+\n\nSELECT CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n+-----------------------------------------------------+\n| CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END |\n+-----------------------------------------------------+\n|                                                NULL |\n+-----------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/case-operator/','','https://mariadb.com/kb/en/case-operator/'),(101,'UNLOCK TABLES',8,'Syntax\n------\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\nSee LOCK TABLES for more information.\n\nIn addition to releasing table locks acquired by the LOCK TABLES statement,\nthe UNLOCK TABLES statement also releases the global read lock acquired by the\nFLUSH TABLES WITH READ LOCK statement. The FLUSH TABLES WITH READ LOCK\nstatement is very useful for performing backups. See FLUSH for more\ninformation about FLUSH TABLES WITH READ LOCK.\n\nURL: https://mariadb.com/kb/en/transactions-unlock-tables/','','https://mariadb.com/kb/en/transactions-unlock-tables/'),(103,'XA Transactions',8,'Overview\n--------\n\nThe MariaDB XA implementation is based on the X/Open CAE document Distributed\nTransaction Processing: The XA Specification. This document is published by\nThe Open Group and available at\nhttp://www.opengroup.org/public/pubs/catalog/c193.htm.\n\nXA transactions are designed to allow distributed transactions, where a\ntransaction manager (the application) controls a transaction which involves\nmultiple resources. Such resources are usually DBMSs, but could be resources\nof any type. The whole set of required transactional operations is called a\nglobal transaction. Each subset of operations which involve a single resource\nis called a local transaction. XA used a 2-phases commit (2PC). With the first\ncommit, the transaction manager tells each resource to prepare an effective\ncommit, and waits for a confirm message. The changes are not still made\neffective at this point. If any of the resources encountered an error, the\ntransaction manager will rollback the global transaction. If all resources\ncommunicate that the first commit is successful, the transaction manager can\nrequire a second commit, which makes the changes effective.\n\nIn MariaDB, XA transactions can only be used with storage engines that support\nthem. At least InnoDB, TokuDB, SPIDER and MyRocks support them. For InnoDB,\nuntil MariaDB 10.2, XA transactions can be disabled by setting the\ninnodb_support_xa server system variable to 0. From MariaDB 10.3, XA\ntransactions are always supported.\n\nLike regular transactions, XA transactions create metadata locks on accessed\ntables.\n\nXA transactions require REPEATABLE READ as a minimum isolation level. However,\ndistributed transactions should always use SERIALIZABLE.\n\nTrying to start more than one XA transaction at the same time produces a 1400\nerror (SQLSTATE \'XAE09\'). The same error is produced when attempting to start\nan XA transaction while a regular transaction is in effect. Trying to start a\nregular transaction while an XA transaction is in effect produces a 1399 error\n(SQLSTATE \'XAE07\').\n\nThe statements that cause an implicit COMMIT for regular transactions produce\na 1400 error (SQLSTATE \'XAE09\') if a XA transaction is in effect.\n\nInternal XA vs External XA\n--------------------------\n\nXA transactions are an overloaded term in MariaDB. If a storage engine is\nXA-capable, it can mean one or both of these:\n\n* It supports MariaDB\'s internal two-phase commit API. This is transparent to\nthe user. Sometimes this is called \"internal XA\", since MariaDB\'s internal\ntransaction coordinator log can handle coordinating these transactions.\n\n* It supports XA transactions, with the XA START, XA PREPARE, XA COMMIT, etc.\nstatements. Sometimes this is called \"external XA\", since it requires the use\nof an external transaction coordinator to use this feature properly.\n\nTransaction Coordinator Log\n---------------------------\n\nIf you have two or more XA-capable storage engines enabled, then a transaction\ncoordinator log must be available.\n\nThere are currently two implementations of the transaction coordinator log:\n\n* Binary log-based transaction coordinator log\n* Memory-mapped file-based transaction coordinator log\n\nIf the binary log is enabled on a server, then the server will use the binary\nlog-based transaction coordinator log. Otherwise, it will use the\nmemory-mapped file-based transaction coordinator log.\n\nSee Transaction Coordinator Log for more information.\n\nSyntax\n------\n\nXA {START|BEGIN} xid [JOIN|RESUME]\n\nXA END xid [SUSPEND [FOR MIGRATE]]\n\nXA PREPARE xid\n\nXA COMMIT xid [ONE PHASE]\n\nXA ROLLBACK xid\n\nXA RECOVER [FORMAT=[\'RAW\'|\'SQL\']]\n\nxid: gtrid [, bqual [, formatID ]]\n\nThe interface to XA transactions is a set of SQL statements starting with XA.\nEach statement changes a transaction\'s state, determining which actions it can\nperform. A transaction which does not exist is in the NON-EXISTING state.\n\nXA START (or BEGIN) starts a transaction and defines its xid (a transaction\nidentifier). The JOIN or RESUME keywords have no effect. The new transaction\nwill be in ACTIVE state.\n\nThe xid can have 3 components, though only the first one is mandatory. gtrid\nis a quoted string representing a global transaction identifier. bqual is a\nquoted string representing a local transaction identifier. formatID is an\nunsigned integer indicating the format used for the first two components; if\nnot specified, defaults to 1. MariaDB does not interpret in any way these\ncomponents, and only uses them to identify a transaction. xids of transactions\nin effect must be unique.\n\nXA END declares that the specified ACTIVE transaction is finished and it\nchanges its state to IDLE. SUSPEND [FOR MIGRATE] has no effect.\n\nXA PREPARE prepares an IDLE transaction for commit, changing its state to\nPREPARED. This is the first commit.\n\nXA COMMIT definitely commits and terminates a transaction which has already\nbeen PREPARED. If the ONE PHASE clause is specified, this statements performs\na 1-phase commit on an IDLE transaction.\n\nXA ROLLBACK rolls back and terminates an IDLE or PREPARED transaction.\n\nXA RECOVER shows information about all PREPARED transactions.\n\nWhen trying to execute an operation which is not allowed for the transaction\'s\ncurrent state, an error is produced:\n\nXA COMMIT \'test\' ONE PHASE;\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  ACTIVE state\n\nXA COMMIT \'test2\';\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  NON-EXISTING state\n\nXA RECOVER\n----------\n\nThe XA RECOVER statement shows information about all transactions which are in\nthe PREPARED state. It does not matter which connection created the\ntransaction: if it has been PREPARED, it appears. But this does not mean that\na connection can commit or rollback a transaction which was started by another\nconnection. Note that transactions using a 1-phase commit are never in the\nPREPARED state, so they cannot be shown by XA RECOVER.\n\nXA RECOVER produces four columns:\n\nXA RECOVER;\n+----------+--------------+--------------+------+\n| formatID | gtrid_length | bqual_length | data |\n+----------+--------------+--------------+------+\n|        1 |            4 |            0 | test |\n+----------+--------------+--------------+------+\n\nMariaDB starting with 10.3.3\n----------------------------\nYou can use XA RECOVER FORMAT=\'SQL\' to get the data in a human readable form\nthat can be directly copy-pasted into XA COMMIT or XA ROLLBACK. This is\nparticularly useful for binary xid generated by some transaction coordinators.\n\nformatID is the formatID part of xid.\n\ndata are the gtrid and bqual parts of xid, concatenated.\n\ngtrid_length and bqual_length are the lengths of gtrid and bqual, respectevely.\n\nExamples\n--------\n\n2-phases commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA PREPARE \'test\';\n\nXA COMMIT \'test\';\n\n1-phase commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA COMMIT \'test\' ONE PHASE;\n\nHuman-readable:\n\nxa start \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\ninsert t1 values (40);\n\nxa end \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa prepare \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa recover format=\'RAW\';\n+----------+--------------+--------------+--------------------+\n| formatID | gtrid_length | bqual_length | data               |\n+----------+--------------+--------------+--------------------+\n34      67v78abc       11 |            7 | 12\ndef |\n+----------+--------------+--------------+--------------------+\n\nxa recover format=\'SQL\';\n+----------+--------------+--------------+-------------------------------------\n---------+\n| formatID | gtrid_length | bqual_length | data                               \n     |\n+----------+--------------+--------------+-------------------------------------\n---------+\n|        3 |           11 |            7 |\nX\'31320d3334093637763738\',X\'6162630a646566\',3 |\n+----------+--------------+--------------+-------------------------------------\n---------+\n\nxa rollback X\'31320d3334093637763738\',X\'6162630a646566\',3;\n\nKnown Issues\n------------\n\nMariaDB Galera Cluster\n----------------------\n\nMariaDB Galera Cluster does not support XA transactions.\n\nHowever, MariaDB Galera Cluster builds include a built-in plugin called wsrep.\nPrior to MariaDB 10.4.3, this plugin was internally considered an XA-capable\nstorage engine. Consequently, these MariaDB Galera Cluster builds have\nmultiple XA-capable storage engines by default, even if the only \"real\"\nstorage engine that supports external XA transactions enabled on these builds\nby default is InnoDB. Therefore, when using one these builds MariaDB would be\nforced to use a transaction coordinator log by default, which could have\nperformance implications.\n\nSee Transaction Coordinator Log Overview: MariaDB Galera Cluster for more\ninformation.\n\nURL: https://mariadb.com/kb/en/xa-transactions/','','https://mariadb.com/kb/en/xa-transactions/'),(104,'CREATE USER',10,'Syntax\n------\n\nCREATE [OR REPLACE] USER [IF NOT EXISTS] \n user_specification [,user_specification ...] \n [REQUIRE {NONE | tls_option [[AND] tls_option ...] }]\n [WITH resource_option [resource_option ...] ]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe CREATE USER statement creates new MariaDB accounts. To use it, you must\nhave the global CREATE USER privilege or the INSERT privilege for the mysql\ndatabase. For each account, CREATE USER creates a new row in mysql.user (until\nMariaDB 10.3 this is a table, from MariaDB 10.4 it\'s a view) or\nmysql.global_priv_table (from MariaDB 10.4) that has no privileges.\n\nIf any of the specified accounts, or any permissions for the specified\naccounts, already exist, then the server returns ERROR 1396 (HY000). If an\nerror occurs, CREATE USER will still create the accounts that do not result in\nan error. Only one error is produced for all users which have not been created:\n\nERROR 1396 (HY000): \n Operation CREATE USER failed for \'u1\'@\'%\',\'u2\'@\'%\'\n\nCREATE USER, DROP USER, CREATE ROLE, and DROP ROLE all produce the same error\ncode when they fail.\n\nSee Account Names below for details on how account names are specified.\n\nOR REPLACE\n----------\n\nIf the optional OR REPLACE clause is used, it is basically a shortcut for:\n\nDROP USER IF EXISTS name;\nCREATE USER name ...;\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE OR REPLACE USER foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected (0.00 sec)\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified user already exists.\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE USER IF NOT EXISTS foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+----------------------------------------------------+\n| Level | Code | Message                                            |\n+-------+------+----------------------------------------------------+\n| Note  | 1973 | Can\'t create user \'foo2\'@\'test\'; it already exists |\n+-------+------+----------------------------------------------------+\n\nAuthentication Options\n----------------------\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored in the\nmysql.user/mysql.global_priv_table table.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nCREATE USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored in the\nmysql.user/mysql.global_priv_table table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nCREATE USER foo2@test IDENTIFIED BY PASSWORD\n\'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nCREATE USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nCREATE USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\') OR\nunix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nCREATE USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to create a user with resource limits:\n\nCREATE USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nAccount Names\n-------------\n\nAccount names have both a user name component and a host name component, and\nare specified as \'user_name\'@\'host_name\'.\n\nThe user name and host name may be unquoted, quoted as strings using double\nquotes (\") or single quotes (\'), or quoted as identifiers using backticks (`).\nYou must use quotes when using special characters (such as a hyphen) or\nwildcard characters. If you quote, you must quote the user name and host name\nseparately (for example \'user_name\'@\'host_name\').\n\nHost Name Component\n-------------------\n\nIf the host name is not provided, it is assumed to be \'%\'.\n\nHost names may contain the wildcard characters % and _. They are matched as if\nby the LIKE clause. If you need to use a wildcard character literally (for\nexample, to match a domain name with an underscore), prefix the character with\na backslash. See LIKE for more information on escaping wildcard characters.\n\nHost name matches are case-insensitive. Host names can match either domain\nnames or IP addresses. Use \'localhost\' as the host name to allow only local\nclient connections.\n\nYou can use a netmask to match a range of IP addresses using \'base_ip/netmask\'\nas the host name. A user with an IP address ip_addr will be allowed to connect\nif the following condition is true:\n\nip_addr & netmask = base_ip\n\nFor example, given a user:\n\nCREATE USER \'maria\'@\'247.150.130.0/255.255.255.0\';\n\nthe IP addresses satisfying this condition range from 247.150.130.0 to\n247.150.130.255.\n\nUsing 255.255.255.255 is equivalent to not using a netmask at all. Netmasks\ncannot be used for IPv6 addresses.\n\nNote that the credentials added when creating a user with the \'%\' wildcard\nhost will not grant access in all cases. For example, some systems come with\nan anonymous localhost user, and when connecting from localhost this will take\nprecedence.\n\nBefore MariaDB 10.6, the host name component could be up to 60 characters in\nlength. Starting from MariaDB 10.6, it can be up to 255 characters.\n\nUser Name Component\n-------------------\n\nUser names must match exactly, including case. A user name that is empty is\nknown as an anonymous account and is allowed to match a login attempt with any\nuser name component. These are described more in the next section.\n\nFor valid identifiers to use as user names, see Identifier Names.\n\nIt is possible for more than one account to match when a user connects.\nMariaDB selects the first matching account after sorting according to the\nfollowing criteria:\n\n* Accounts with an exact host name are sorted before accounts using a wildcard\nin the\nhost name. Host names using a netmask are considered to be exact for sorting.\n* Accounts with a wildcard in the host name are sorted according to the\nposition of\nthe first wildcard character. Those with a wildcard character later in the\nhost name\nsort before those with a wildcard character earlier in the host name.\n* Accounts with a non-empty user name sort before accounts with an empty user\nname.\n* Accounts with an empty user name are sorted last. As mentioned previously,\nthese are known as anonymous accounts. These are described more in the next\nsection.\n\nThe following table shows a list of example account as sorted by these\ncriteria:\n\n+---------+-------------+\n| User    | Host        |\n+---------+-------------+\n| joffrey | 192.168.0.3 |\n|         | 192.168.0.% |\n| joffrey | 192.168.%   |\n|         | 192.168.%   |\n+---------+-------------+\n\nOnce connected, you only have the privileges granted to the account that\nmatched, not all accounts that could have matched. For example, consider the\nfollowing commands:\n\nCREATE USER \'joffrey\'@\'192.168.0.3\';\nCREATE USER \'joffrey\'@\'%\';\nGRANT SELECT ON test.t1 to \'joffrey\'@\'192.168.0.3\';\nGRANT SELECT ON test.t2 to \'joffrey\'@\'%\';\n\nIf you connect as joffrey from 192.168.0.3, you will have the SELECT privilege\non the table test.t1, but not on the table test.t2. If you connect as joffrey\nfrom any other IP address, you will have the SELECT privilege on the table\ntest.t2, but not on the table test.t1.\n\nUsernames can be up to 80 characters long before 10.6 and starting from 10.6\nit can be 128 characters long.\n\nAnonymous Accounts\n------------------\n\nAnonymous accounts are accounts where the user name portion of the account\nname is empty. These accounts act as special catch-all accounts. If a user\nattempts to log into the system from a host, and an anonymous account exists\nwith a host name portion that matches the user\'s host, then the user will log\nin as the anonymous account if there is no more specific account match for the\nuser name that the user entered.\n\nFor example, here are some anonymous accounts:\n\nCREATE USER \'\'@\'localhost\';\nCREATE USER \'\'@\'192.168.0.3\';\n\nFixing a Legacy Default Anonymous Account\n-----------------------------------------\n\nOn some systems, the mysql.db table has some entries for the \'\'@\'%\' anonymous\naccount by default. Unfortunately, there is no matching entry in the\nmysql.user/mysql.global_priv_table table, which means that this anonymous\naccount doesn\'t exactly exist, but it does have privileges--usually on the\ndefault test database created by mysql_install_db. These account-less\nprivileges are a legacy that is leftover from a time when MySQL\'s privilege\nsystem was less advanced.\n\nThis situation means that you will run into errors if you try to create a\n\'\'@\'%\' account. For example:\n\nCREATE USER \'\'@\'%\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'\'@\'%\'\n\nThe fix is to DELETE the row in the mysql.db table and then execute FLUSH\nPRIVILEGES:\n\nDELETE FROM mysql.db WHERE User=\'\' AND Host=\'%\';\nFLUSH PRIVILEGES;\n\nAnd then the account can be created:\n\nCREATE USER \'\'@\'%\';\nQuery OK, 0 rows affected (0.01 sec)\n\nSee MDEV-13486 for more information.\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nCREATE USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/create-user/','','https://mariadb.com/kb/en/create-user/'),(105,'ALTER USER',10,'Syntax\n------\n\nALTER USER [IF EXISTS] \n user_specification [,user_specification] ...\n [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n [WITH resource_option [resource_option] ...]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule] ...\n\nauthentication_rule:\n authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe ALTER USER statement modifies existing MariaDB accounts. To use it, you\nmust have the global CREATE USER privilege or the UPDATE privilege for the\nmysql database. The global SUPER privilege is also required if the read_only\nsystem variable is enabled.\n\nIf any of the specified user accounts do not yet exist, an error results. If\nan error occurs, ALTER USER will still modify the accounts that do not result\nin an error. Only one error is produced for all users which have not been\nmodified.\n\nIF EXISTS\n---------\n\nWhen the IF EXISTS clause is used, MariaDB will return a warning instead of an\nerror for each specified user that does not exist.\n\nAccount Names\n-------------\n\nFor ALTER USER statements, account names are specified as the username\nargument in the same way as they are for CREATE USER statements. See account\nnames from the CREATE USER page for details on how account names are specified.\n\nCURRENT_USER or CURRENT_USER() can also be used to alter the account logged\ninto the current session. For example, to change the current user\'s password\nto mariadb:\n\nALTER USER CURRENT_USER() IDENTIFIED BY \'mariadb\';\n\nAuthentication Options\n----------------------\n\nMariaDB starting with 10.4\n--------------------------\nFrom MariaDB 10.4, it is possible to use more than one authentication plugin\nfor each user account. For example, this can be useful to slowly migrate users\nto the more secure ed25519 authentication plugin over time, while allowing the\nold mysql_native_password authentication plugin as an alternative for the\ntransitional period. See Authentication from MariaDB 10.4 for more.\n\nWhen running ALTER USER, not specifying an authentication option in the\nIDENTIFIED VIA clause will remove that authentication method. (However this\nwas not the case before MariaDB 10.4.13, see MDEV-21928)\n\nFor example, a user is created with the ability to authenticate via both a\npassword and unix_socket:\n\nCREATE USER \'bob\'@\'localhost\' \n IDENTIFIED VIA mysql_native_password USING PASSWORD(\'pwd\')\n OR unix_socket;\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED VIA mysql_native_password\n USING \'*975B2CD4FF9AE554FE8AD33168FBFC326D2021DD\'\n OR unix_socket\n\nIf the user\'s password is updated, but unix_socket authentication is not\nspecified in the IDENTIFIED VIA clause, unix_socket authentication will no\nlonger be permitted.\n\nALTER USER \'bob\'@\'localhost\' IDENTIFIED VIA mysql_native_password \n USING PASSWORD(\'pwd2\');\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED BY PASSWORD \'*38366FDA01695B6A5A9DD4E428D9FB8F7EB75512\'\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored to the mysql.user table.\n\nFor example, if our password is mariadb, then we can set the account\'s\npassword with:\n\nALTER USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD#function. It will be stored to the\nmysql.user table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n\nAnd then we can set an account\'s password with the hash:\n\nALTER USER foo2@test \n IDENTIFIED BY PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nALTER USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nALTER USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nIn MariaDB 10.4 and later, the USING or AS keyword can also be used to provide\na plain-text password to a plugin if it\'s provided as an argument to the\nPASSWORD() function. This is only valid for authentication plugins that have\nimplemented a hook for the PASSWORD() function. For example, the ed25519\nauthentication plugin supports this:\n\nALTER USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can alter a user account to require these TLS options with\nthe following:\n\nALTER USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\' AND\n ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+------------------------------------+---------------------------------------+\n| Limit Type                         | Description                           |\n+------------------------------------+---------------------------------------+\n| MAX_QUERIES_PER_HOUR               | Number of statements that the         |\n|                                    | account can issue per hour            |\n|                                    | (including updates)                   |\n+------------------------------------+---------------------------------------+\n| MAX_UPDATES_PER_HOUR               | Number of updates (not queries) that  |\n|                                    | the account can issue per hour        |\n+------------------------------------+---------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR           | Number of connections that the        |\n|                                    | account can start per hour            |\n+------------------------------------+---------------------------------------+\n| MAX_USER_CONNECTIONS               | Number of simultaneous connections    |\n|                                    | that can be accepted from the same    |\n|                                    | account; if it is 0, max_connections  |\n|                                    | will be used instead; if              |\n|                                    | max_connections is 0, there is no     |\n|                                    | limit for this account\'s              |\n|                                    | simultaneous connections.             |\n+------------------------------------+---------------------------------------+\n| MAX_STATEMENT_TIME                 | Timeout, in seconds, for statements   |\n|                                    | executed by the user. See also        |\n|                                    | Aborting Statements that Exceed a     |\n|                                    | Certain Time to Execute.              |\n+------------------------------------+---------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to set an account\'s resource limits:\n\nALTER USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nALTER USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/alter-user/','','https://mariadb.com/kb/en/alter-user/'),(107,'GRANT',10,'Syntax\n------\n\nGRANT\n  priv_type [(column_list)]\n   [, priv_type [(column_list)]] ...\n  ON [object_type] priv_level\n  TO user_specification [ user_options ...]\n\nuser_specification:\n username [authentication_option]\n | PUBLIC\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\nGRANT PROXY ON username\n  TO user_specification [, user_specification ...]\n  [WITH GRANT OPTION]\n\nGRANT rolename TO grantee [, grantee ...]\n  [WITH ADMIN OPTION]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nuser_options:\n  [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n  [WITH with_option [with_option] ...]\n\nobject_type:\n  TABLE\n | FUNCTION\n | PROCEDURE\n | PACKAGE\n\npriv_level:\n  *\n | *.*\n | db_name.*\n | db_name.tbl_name\n | tbl_name\n | db_name.routine_name\n\nwith_option:\n  GRANT OPTION\n | resource_option\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nDescription\n-----------\n\nThe GRANT statement allows you to grant privileges or roles to accounts. To\nuse GRANT, you must have the GRANT OPTION privilege, and you must have the\nprivileges that you are granting.\n\nUse the REVOKE statement to revoke privileges granted with the GRANT statement.\n\nUse the SHOW GRANTS statement to determine what privileges an account has.\n\nAccount Names\n-------------\n\nFor GRANT statements, account names are specified as the username argument in\nthe same way as they are for CREATE USER statements. See account names from\nthe CREATE USER page for details on how account names are specified.\n\nImplicit Account Creation\n-------------------------\n\nThe GRANT statement also allows you to implicitly create accounts in some\ncases.\n\nIf the account does not yet exist, then GRANT can implicitly create it. To\nimplicitly create an account with GRANT, a user is required to have the same\nprivileges that would be required to explicitly create the account with the\nCREATE USER statement.\n\nIf the NO_AUTO_CREATE_USER SQL_MODE is set, then accounts can only be created\nif authentication information is specified, or with a CREATE USER statement.\nIf no authentication information is provided, GRANT will produce an error when\nthe specified account does not exist, for example:\n\nshow variables like \'%sql_mode%\' ;\n+---------------+--------------------------------------------+\n| Variable_name | Value                                      |\n+---------------+--------------------------------------------+\n| sql_mode      | NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n+---------------+--------------------------------------------+\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' IDENTIFIED BY \'\';\nERROR 1133 (28000): Can\'t find any matching row in the user table\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' \n IDENTIFIED VIA PAM using \'mariadb\' require ssl ;\nQuery OK, 0 rows affected (0.00 sec)\n\nselect host, user from mysql.user where user=\'user123\' ;\n\n+------+----------+\n| host | user     |\n+------+----------+\n| %    | user123 |\n+------+----------+\n\nPrivilege Levels\n----------------\n\nPrivileges can be set globally, for an entire database, for a table or\nroutine, or for individual columns in a table. Certain privileges can only be\nset at certain levels.\n\n* Global privileges priv_type are granted using *.* for\npriv_level. Global privileges include privileges to administer the database\nand manage user accounts, as well as privileges for all tables, functions, and\nprocedures. Global privileges are stored in the mysql.user table prior to\nMariaDB 10.4, and in  mysql.global_priv table afterwards.\n* Database privileges priv_type are granted using db_name.*\nfor priv_level, or using just * to use default database. Database\nprivileges include privileges to create tables and functions, as well as\nprivileges for all tables, functions, and procedures in the database. Database\nprivileges are stored in the mysql.db table.\n* Table privileges priv_type are granted using db_name.tbl_name\nfor priv_level, or using just tbl_name to specify a table in the default\ndatabase. The TABLE keyword is optional. Table privileges include the\nability to select and change data in the table. Certain table privileges can\nbe granted for individual columns.\n* Column privileges priv_type are granted by specifying a table for\npriv_level and providing a column list after the privilege type. They allow\nyou to control exactly which columns in a table users can select and change.\n* Function privileges priv_type are granted using FUNCTION db_name.routine_name\nfor priv_level, or using just  FUNCTION routine_name to specify a function\nin the default database.\n* Procedure privileges priv_type are granted using PROCEDURE\ndb_name.routine_name\nfor priv_level, or using just PROCEDURE routine_name to specify a procedure\nin the default database.\n\nThe USAGE Privilege\n-------------------\n\nThe USAGE privilege grants no real privileges. The SHOW GRANTS statement will\nshow a global USAGE privilege for a newly-created user. You can use USAGE with\nthe GRANT statement to change options like GRANT OPTION and\nMAX_USER_CONNECTIONS without changing any account privileges.\n\nThe ALL PRIVILEGES Privilege\n----------------------------\n\nThe ALL PRIVILEGES privilege grants all available privileges. Granting all\nprivileges only affects the given privilege level. For example, granting all\nprivileges on a table does not grant any privileges on the database or\nglobally.\n\nUsing ALL PRIVILEGES does not grant the special GRANT OPTION privilege.\n\nYou can use ALL instead of ALL PRIVILEGES.\n\nThe GRANT OPTION Privilege\n--------------------------\n\nUse the WITH GRANT OPTION clause to give users the ability to grant privileges\nto other users at the given privilege level. Users with the GRANT OPTION\nprivilege can only grant privileges they have. They cannot grant privileges at\na higher privilege level than they have the GRANT OPTION privilege.\n\nThe GRANT OPTION privilege cannot be set for individual columns. If you use\nWITH GRANT OPTION when specifying column privileges, the GRANT OPTION\nprivilege will be granted for the entire table.\n\nUsing the WITH GRANT OPTION clause is equivalent to listing GRANT OPTION as a\nprivilege.\n\nGlobal Privileges\n-----------------\n\nThe following table lists the privileges that can be granted globally. You can\nalso grant all database, table, and function privileges globally. When granted\nglobally, these privileges apply to all databases, tables, or functions,\nincluding those created later.\n\nTo set a global privilege, use *.* for priv_level.\n\nBINLOG ADMIN\n------------\n\nEnables administration of the binary log, including the PURGE BINARY LOGS\nstatement and setting the system variables:\n\n* binlog_annotate_row_events\n* binlog_cache_size\n* binlog_commit_wait_count\n* binlog_commit_wait_usec\n* binlog_direct_non_transactional_updates\n* binlog_expire_logs_seconds\n* binlog_file_cache_size\n* binlog_format\n* binlog_row_image\n* binlog_row_metadata\n* binlog_stmt_cache_size\n* expire_logs_days\n* log_bin_compress\n* log_bin_compress_min_len\n* log_bin_trust_function_creators\n* max_binlog_cache_size\n* max_binlog_size\n* max_binlog_stmt_cache_size\n* sql_log_bin and\n* sync_binlog.\n\nAdded in MariaDB 10.5.2.\n\nBINLOG MONITOR\n--------------\n\nNew name for REPLICATION CLIENT from MariaDB 10.5.2, (REPLICATION CLIENT still\nsupported as an alias for compatibility purposes). Permits running SHOW\ncommands related to the binary log, in particular the SHOW BINLOG STATUS and\nSHOW BINARY LOGS statements. Unlike REPLICATION CLIENT prior to MariaDB 10.5,\nSHOW REPLICA STATUS isn\'t included in this privilege, and REPLICA MONITOR is\nrequired.\n\nBINLOG REPLAY\n-------------\n\nEnables replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), executing SET timestamp when secure_timestamp is set to\nreplication, and setting the session values of system variables usually\nincluded in BINLOG output, in particular:\n\n* gtid_domain_id\n* gtid_seq_no\n* pseudo_thread_id\n* server_id.\n\nAdded in MariaDB 10.5.2\n\nCONNECTION ADMIN\n----------------\n\nEnables administering connection resource limit options. This includes\nignoring the limits specified by:\n\n* max_connections\n* max_user_connections and\n* max_password_errors.\n\nThe statements specified in init_connect are not executed, killing connections\nand queries owned by other users is permitted. The following\nconnection-related system variables can be changed:\n\n* connect_timeout\n* disconnect_on_expired_password\n* extra_max_connections\n* init_connect\n* max_connections\n* max_connect_errors\n* max_password_errors\n* proxy_protocol_networks\n* secure_auth\n* slow_launch_time\n* thread_pool_exact_stats\n* thread_pool_dedicated_listener\n* thread_pool_idle_timeout\n* thread_pool_max_threads\n* thread_pool_min_threads\n* thread_pool_oversubscribe\n* thread_pool_prio_kickup_timer\n* thread_pool_priority\n* thread_pool_size, and\n* thread_pool_stall_limit.\n\nAdded in MariaDB 10.5.2.\n\nCREATE USER\n-----------\n\nCreate a user using the CREATE USER statement, or implicitly create a user\nwith the GRANT statement.\n\nFEDERATED ADMIN\n---------------\n\nExecute CREATE SERVER, ALTER SERVER, and DROP SERVER statements. Added in\nMariaDB 10.5.2.\n\nFILE\n----\n\nRead and write files on the server, using statements like LOAD DATA INFILE or\nfunctions like LOAD_FILE(). Also needed to create CONNECT outward tables.\nMariaDB server must have the permissions to access those files.\n\nGRANT OPTION\n------------\n\nGrant global privileges. You can only grant privileges that you have.\n\nPROCESS\n-------\n\nShow information about the active processes, for example via SHOW PROCESSLIST\nor mysqladmin processlist. If you have the PROCESS privilege, you can see all\nthreads. Otherwise, you can see only your own threads (that is, threads\nassociated with the MariaDB account that you are using).\n\nREAD_ONLY ADMIN\n---------------\n\nUser can set the read_only system variable and allows the user to perform\nwrite operations, even when the read_only option is active. Added in MariaDB\n10.5.2.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nRELOAD\n------\n\nExecute FLUSH statements or equivalent mariadb-admin/mysqladmin commands.\n\nREPLICATION CLIENT\n------------------\n\nExecute SHOW MASTER STATUS and SHOW BINARY LOGS informative statements.\nRenamed to BINLOG MONITOR in MariaDB 10.5.2 (but still supported as an alias\nfor compatibility reasons). SHOW SLAVE STATUS was part of REPLICATION CLIENT\nprior to MariaDB 10.5.\n\nREPLICATION MASTER ADMIN\n------------------------\n\nPermits administration of primary servers, including the SHOW REPLICA HOSTS\nstatement, and setting the gtid_binlog_state, gtid_domain_id,\nmaster_verify_checksum and server_id system variables. Added in MariaDB 10.5.2.\n\nREPLICA MONITOR\n---------------\n\nPermit SHOW REPLICA STATUS and SHOW RELAYLOG EVENTS. From MariaDB 10.5.9.\n\nWhen a user would upgrade from an older major release to a MariaDB 10.5 minor\nrelease prior to MariaDB 10.5.9, certain user accounts would lose\ncapabilities. For example, a user account that had the REPLICATION CLIENT\nprivilege in older major releases could run SHOW REPLICA STATUS, but after\nupgrading to a MariaDB 10.5 minor release prior to MariaDB 10.5.9, they could\nno longer run SHOW REPLICA STATUS, because that statement was changed to\nrequire the REPLICATION REPLICA ADMIN privilege.\n\nThis issue is fixed in MariaDB 10.5.9 with this new privilege, which now\ngrants the user the ability to execute SHOW [ALL] (SLAVE | REPLICA) STATUS.\n\nWhen a database is upgraded from an older major release to MariaDB Server\n10.5.9 or later, any user accounts with the REPLICATION CLIENT or REPLICATION\nSLAVE privileges will automatically be granted the new REPLICA MONITOR\nprivilege. The privilege fix occurs when the server is started up, not when\nmariadb-upgrade is performed.\n\nHowever, when a database is upgraded from an early 10.5 minor release to\n10.5.9 and later, the user will have to fix any user account privileges\nmanually.\n\nREPLICATION REPLICA\n-------------------\n\nSynonym for REPLICATION SLAVE. From MariaDB 10.5.1.\n\nREPLICATION SLAVE\n-----------------\n\nAccounts used by replica servers on the primary need this privilege. This is\nneeded to get the updates made on the master. From MariaDB 10.5.1, REPLICATION\nREPLICA is an alias for REPLICATION SLAVE.\n\nREPLICATION SLAVE ADMIN\n-----------------------\n\nPermits administering replica servers, including START REPLICA/SLAVE, STOP\nREPLICA/SLAVE, CHANGE MASTER, SHOW REPLICA/SLAVE STATUS, SHOW RELAYLOG EVENTS\nstatements, replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), and setting the system variables:\n\n* gtid_cleanup_batch_size\n* gtid_ignore_duplicates\n* gtid_pos_auto_engines\n* gtid_slave_pos\n* gtid_strict_mode\n* init_slave\n* read_binlog_speed_limit\n* relay_log_purge\n* relay_log_recovery\n* replicate_do_db\n* replicate_do_table\n* replicate_events_marked_for_skip\n* replicate_ignore_db\n* replicate_ignore_table\n* replicate_wild_do_table\n* replicate_wild_ignore_table\n* slave_compressed_protocol\n* slave_ddl_exec_mode\n* slave_domain_parallel_threads\n* slave_exec_mode\n* slave_max_allowed_packet\n* slave_net_timeout\n* slave_parallel_max_queued\n* slave_parallel_mode\n* slave_parallel_threads\n* slave_parallel_workers\n* slave_run_triggers_for_rbr\n* slave_sql_verify_checksum\n* slave_transaction_retry_interval\n* slave_type_conversions\n* sync_master_info\n* sync_relay_log, and\n* sync_relay_log_info.\n\nAdded in MariaDB 10.5.2.\n\nSET USER\n--------\n\nEnables setting the DEFINER when creating triggers, views, stored functions\nand stored procedures. Added in MariaDB 10.5.2.\n\nSHOW DATABASES\n--------------\n\nList all databases using the SHOW DATABASES statement. Without the SHOW\nDATABASES privilege, you can still issue the SHOW DATABASES statement, but it\nwill only list databases containing tables on which you have privileges.\n\nSHUTDOWN\n--------\n\nShut down the server using SHUTDOWN or the mysqladmin shutdown command.\n\nSUPER\n-----\n\nExecute superuser statements: CHANGE MASTER TO, KILL (users who do not have\nthis privilege can only KILL their own threads), PURGE LOGS, SET global system\nvariables, or the mysqladmin debug command. Also, this permission allows the\nuser to write data even if the read_only startup option is set, enable or\ndisable logging, enable or disable replication on replica, specify a DEFINER\nfor statements that support that clause, connect once reaching the\nMAX_CONNECTIONS. If a statement has been specified for the init-connect mysqld\noption, that command will not be executed when a user with SUPER privileges\nconnects to the server.\n\nThe SUPER privilege has been split into multiple smaller privileges from\nMariaDB 10.5.2 to allow for more fine-grained privileges, although it remains\nan alias for these smaller privileges.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nDatabase Privileges\n-------------------\n\nThe following table lists the privileges that can be granted at the database\nlevel. You can also grant all table and function privileges at the database\nlevel. Table and function privileges on a database apply to all tables or\nfunctions in that database, including those created later.\n\nTo set a privilege for a database, specify the database using db_name.* for\npriv_level, or just use * to specify the default database.\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a database using the CREATE      |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. You can      |\n|                                  | grant the CREATE privilege on           |\n|                                  | databases that do not yet exist. This   |\n|                                  | also grants the CREATE privilege on     |\n|                                  | all tables in the database.             |\n+----------------------------------+-----------------------------------------+\n| CREATE ROUTINE                   | Create Stored Programs using the        |\n|                                  | CREATE PROCEDURE and CREATE FUNCTION    |\n|                                  | statements.                             |\n+----------------------------------+-----------------------------------------+\n| CREATE TEMPORARY TABLES          | Create temporary tables with the        |\n|                                  | CREATE TEMPORARY TABLE statement. This  |\n|                                  | privilege enable writing and dropping   |\n|                                  | those temporary tables                  |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a database using the DROP          |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. This also    |\n|                                  | grants the DROP privilege on all        |\n|                                  | tables in the database.                 |\n+----------------------------------+-----------------------------------------+\n| EVENT                            | Create, drop and alter EVENTs.          |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant database privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n| LOCK TABLES                      | Acquire explicit locks using the LOCK   |\n|                                  | TABLES statement; you also need to      |\n|                                  | have the SELECT privilege on a table,   |\n|                                  | in order to lock it.                    |\n+----------------------------------+-----------------------------------------+\n\nTable Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER                            | Change the structure of an existing     |\n|                                  | table using the ALTER TABLE statement.  |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a table using the CREATE TABLE   |\n|                                  | statement.  You can grant the CREATE    |\n|                                  | privilege on tables that do not yet     |\n|                                  | exist.                                  |\n+----------------------------------+-----------------------------------------+\n| CREATE VIEW                      | Create a view using the CREATE_VIEW     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| DELETE                           | Remove rows from a table using the      |\n|                                  | DELETE statement.                       |\n+----------------------------------+-----------------------------------------+\n| DELETE HISTORY                   | Remove historical rows from a table     |\n|                                  | using the DELETE HISTORY statement.     |\n|                                  | Displays as DELETE VERSIONING ROWS      |\n|                                  | when running SHOW GRANTS until MariaDB  |\n|                                  | 10.3.15 and until MariaDB 10.4.5        |\n|                                  | (MDEV-17655), or when running SHOW      |\n|                                  | PRIVILEGES until MariaDB 10.5.2,        |\n|                                  | MariaDB 10.4.13 and MariaDB 10.3.23     |\n|                                  | (MDEV-20382). From MariaDB 10.3.4.      |\n|                                  | From MariaDB 10.3.5, if a user has the  |\n|                                  | SUPER privilege but not this            |\n|                                  | privilege, running mysql_upgrade will   |\n|                                  | grant this privilege as well.           |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a table using the DROP TABLE       |\n|                                  | statement or a view using the DROP      |\n|                                  | VIEW statement. Also required to        |\n|                                  | execute the TRUNCATE TABLE statement.   |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant table privileges. You can only    |\n|                                  | grant privileges that you have.         |\n+----------------------------------+-----------------------------------------+\n| INDEX                            | Create an index on a table using the    |\n|                                  | CREATE INDEX statement. Without the     |\n|                                  | INDEX privilege, you can still create   |\n|                                  | indexes when creating a table using     |\n|                                  | the CREATE TABLE statement if the you   |\n|                                  | have the CREATE privilege, and you can  |\n|                                  | create indexes using the ALTER TABLE    |\n|                                  | statement if you have the ALTER         |\n|                                  | privilege.                              |\n+----------------------------------+-----------------------------------------+\n| INSERT                           | Add rows to a table using the INSERT    |\n|                                  | statement.  The INSERT privilege can    |\n|                                  | also be set on individual columns; see  |\n|                                  | Column Privileges below for details.    |\n+----------------------------------+-----------------------------------------+\n| REFERENCES                       | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT                           | Read data from a table using the        |\n|                                  | SELECT statement. The SELECT privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n| SHOW VIEW                        | Show the CREATE VIEW statement to       |\n|                                  | create a view using the SHOW CREATE     |\n|                                  | VIEW statement.                         |\n+----------------------------------+-----------------------------------------+\n| TRIGGER                          | Execute triggers associated to tables   |\n|                                  | you update, execute the CREATE TRIGGER  |\n|                                  | and DROP TRIGGER statements. You will   |\n|                                  | still be able to see triggers.          |\n+----------------------------------+-----------------------------------------+\n| UPDATE                           | Update existing rows in a table using   |\n|                                  | the UPDATE statement. UPDATE            |\n|                                  | statements usually include a WHERE      |\n|                                  | clause to update only certain rows.     |\n|                                  | You must have SELECT privileges on the  |\n|                                  | table or the appropriate columns for    |\n|                                  | the WHERE clause. The UPDATE privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n\nColumn Privileges\n-----------------\n\nSome table privileges can be set for individual columns of a table. To use\ncolumn privileges, specify the table explicitly and provide a list of column\nnames after the privilege type. For example, the following statement would\nallow the user to read the names and positions of employees, but not other\ninformation from the same table, such as salaries.\n\nGRANT SELECT (name, position) on Employee to \'jeffrey\'@\'localhost\';\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| INSERT (column_list)             | Add rows specifying values in columns   |\n|                                  | using the INSERT statement. If you      |\n|                                  | only have column-level INSERT           |\n|                                  | privileges, you must specify the        |\n|                                  | columns you are setting in the INSERT   |\n|                                  | statement. All other columns will be    |\n|                                  | set to their default values, or NULL.   |\n+----------------------------------+-----------------------------------------+\n| REFERENCES (column_list)         | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT (column_list)             | Read values in columns using the        |\n|                                  | SELECT statement. You cannot access or  |\n|                                  | query any columns for which you do not  |\n|                                  | have SELECT privileges, including in    |\n|                                  | WHERE, ON, GROUP BY, and ORDER BY       |\n|                                  | clauses.                                |\n+----------------------------------+-----------------------------------------+\n| UPDATE (column_list)             | Update values in columns of existing    |\n|                                  | rows using the UPDATE statement.        |\n|                                  | UPDATE statements usually include a     |\n|                                  | WHERE clause to update only certain     |\n|                                  | rows. You must have SELECT privileges   |\n|                                  | on the table or the appropriate         |\n|                                  | columns for the WHERE clause.           |\n+----------------------------------+-----------------------------------------+\n\nFunction Privileges\n-------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | function using the ALTER FUNCTION       |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Use a stored function. You need SELECT  |\n|                                  | privileges for any tables or columns    |\n|                                  | accessed by the function.               |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant function privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nProcedure Privileges\n--------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | procedure using the ALTER PROCEDURE     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Execute a stored procedure using the    |\n|                                  | CALL statement. The privilege to call   |\n|                                  | a procedure may allow you to perform    |\n|                                  | actions you wouldn\'t otherwise be able  |\n|                                  | to do, such as insert rows into a       |\n|                                  | table.                                  |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant procedure privileges. You can     |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nGRANT EXECUTE ON PROCEDURE mysql.create_db TO maintainer;\n\nProxy Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| PROXY                            | Permits one user to be a proxy for      |\n|                                  | another.                                |\n+----------------------------------+-----------------------------------------+\n\nThe PROXY privilege allows one user to proxy as another user, which means\ntheir privileges change to that of the proxy user, and the CURRENT_USER()\nfunction returns the user name of the proxy user.\n\nThe PROXY privilege only works with authentication plugins that support it.\nThe default mysql_native_password authentication plugin does not support proxy\nusers.\n\nThe pam authentication plugin is the only plugin included with MariaDB that\ncurrently supports proxy users. The PROXY privilege is commonly used with the\npam authentication plugin to enable user and group mapping with PAM.\n\nFor example, to grant the PROXY privilege to an anonymous account that\nauthenticates with the pam authentication plugin, you could execute the\nfollowing:\n\nCREATE USER \'dba\'@\'%\' IDENTIFIED BY \'strongpassword\';\nGRANT ALL PRIVILEGES ON *.* TO \'dba\'@\'%\' ;\n\nCREATE USER \'\'@\'%\' IDENTIFIED VIA pam USING \'mariadb\';\nGRANT PROXY ON \'dba\'@\'%\' TO \'\'@\'%\';\n\nA user account can only grant the PROXY privilege for a specific user account\nif the granter also has the PROXY privilege for that specific user account,\nand if that privilege is defined WITH GRANT OPTION. For example, the following\nexample fails because the granter does not have the PROXY privilege for that\nspecific user account at all:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nAnd the following example fails because the granter does have the PROXY\nprivilege for that specific user account, but it is not defined WITH GRANT\nOPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\'                     \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nBut the following example succeeds because the granter does have the PROXY\nprivilege for that specific user account, and it is defined WITH GRANT OPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\' WITH GRANT OPTION   \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\n\nA user account can grant the PROXY privilege for any other user account if the\ngranter has the PROXY privilege for the \'\'@\'%\' anonymous user account, like\nthis:\n\nGRANT PROXY ON \'\'@\'%\' TO \'dba\'@\'localhost\' WITH GRANT OPTION;\n\nFor example, the following example succeeds because the user can grant the\nPROXY privilege for any other user account:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'\'@\'%\' TO \'alice\'@\'localhost\' WITH GRANT OPTION              \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'app1_dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nGRANT PROXY ON \'app2_dba\'@\'localhost\' TO \'carol\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nThe default root user accounts created by mysql_install_db have this\nprivilege. For example:\n\nGRANT ALL PRIVILEGES ON *.* TO \'root\'@\'localhost\' WITH GRANT OPTION;\nGRANT PROXY ON \'\'@\'%\' TO \'root\'@\'localhost\' WITH GRANT OPTION;\n\nThis allows the default root user accounts to grant the PROXY privilege for\nany other user account, and it also allows the default root user accounts to\ngrant others the privilege to do the same.\n\nAuthentication Options\n----------------------\n\nThe authentication options for the GRANT statement are the same as those for\nthe CREATE USER statement.\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \n PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\') OR unix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nTo set resource limits for an account, if you do not want to change that\naccount\'s privileges, you can issue a GRANT statement with the USAGE\nprivilege, which has no meaning. The statement can name some or all limit\ntypes, in any order.\n\nHere is an example showing how to set resource limits:\n\nGRANT USAGE ON *.* TO \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 0\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nUsers with the CONNECTION ADMIN privilege (in MariaDB 10.5.2 and later) or the\nSUPER privilege are not restricted by max_user_connections, max_connections,\nor max_password_errors.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nGRANT USAGE ON *.* TO \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nRoles\n-----\n\nSyntax\n------\n\nGRANT role TO grantee [, grantee ... ]\n[ WITH ADMIN OPTION ]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nThe GRANT statement is also used to grant the use of a role to one or more\nusers or other roles. In order to be able to grant a role, the grantor doing\nso must have permission to do so (see WITH ADMIN in the CREATE ROLE article).\n\nSpecifying the WITH ADMIN OPTION permits the grantee to in turn grant the role\nto another.\n\nFor example, the following commands show how to grant the same role to a\ncouple different users.\n\nGRANT journalist TO hulda;\n\nGRANT journalist TO berengar WITH ADMIN OPTION;\n\nIf a user has been granted a role, they do not automatically obtain all\npermissions associated with that role. These permissions are only in use when\nthe user activates the role with the SET ROLE statement.\n\nTO PUBLIC\n---------\n\nMariaDB starting with 10.11\n---------------------------\n\nSyntax\n------\n\nGRANT <privilege> ON <database>.<object> TO PUBLIC;\nREVOKE <privilege> ON <database>.<object> FROM PUBLIC;\n\nGRANT ... TO PUBLIC grants privileges to all users with access to the server.\nThe privileges also apply to users created after the privileges are granted.\nThis can be useful when one only wants to state once that all users need to\nhave a certain set of privileges.\n\nWhen running SHOW GRANTS, a user will also see all privileges inherited from\nPUBLIC. SHOW GRANTS FOR PUBLIC will only show TO PUBLIC grants.\n\nGrant Examples\n--------------\n\nGranting Root-like Privileges\n-----------------------------\n\nYou can create a user that has privileges similar to the default root accounts\nby executing the following:\n\nCREATE USER \'alexander\'@\'localhost\';\nGRANT ALL PRIVILEGES ON  *.* to \'alexander\'@\'localhost\' WITH GRANT OPTION;\n\nURL: https://mariadb.com/kb/en/grant/','','https://mariadb.com/kb/en/grant/'),(117,'Authentication from MariaDB 10.4',10,'MariaDB starting with 10.4\n--------------------------\nMariaDB 10.4 introduced a number of changes to the authentication process,\nintended to make things easier and more intuitive.\n\nOverview\n--------\n\nThere are four new main features in 10.4 relating to authentication:\n\n* It is possible to use more than one authentication plugin for each user\naccount. For example, this can be useful to slowly migrate users to the more\nsecure ed25519 authentication plugin over time, while allowing the old\nmysql_native_password authentication plugin as an alternative for the\ntransitional period.\n* The root@localhost user account created by mysql_install_db is created with\nthe ability to use two authentication plugins.\nFirst, it is configured to try to use the unix_socket authentication plugin.\nThis allows the root@localhost user to login without a password via the local\nUnix socket file defined by the socket system variable, as long as the login\nis attempted from a process owned by the operating system root user account.\nSecond, if authentication fails with the unix_socket authentication plugin,\nthen it is configured to try to use the mysql_native_password authentication\nplugin. However, an invalid password is initially set, so in order to\nauthenticate this way, a password must be set with SET PASSWORD.\nHowever, just using the unix_socket authentication plugin may be fine for many\nusers, and it is very secure. You may want to try going without password\nauthentication to see how well it works for you. Remember, the best way to\nkeep your password safe is not to have one!\n\n* All user accounts, passwords, and global privileges are now stored in the\nmysql.global_priv table. The mysql.user table still exists and has exactly the\nsame set of columns as before, but it’s now a view that references the\nmysql.global_priv table. Tools that analyze the mysql.user table should\ncontinue to work as before. From MariaDB 10.4.13, the dedicated mariadb.sys\nuser is created as the definer of this view. Previously root was the definer,\nwhich resulted in privilege problems when this username was changed.\n* MariaDB 10.4 adds supports for User Password Expiry, which is not active by\ndefault.\n\nDescription\n-----------\n\nAs a result of the above changes, the open-for-everyone all-powerful root\naccount is finally gone. And installation scripts will no longer demand that\nyou \"PLEASE REMEMBER TO SET A PASSWORD FOR THE MariaDB root USER !\", because\nthe root account is securely created automatically.\n\nTwo all-powerful accounts are created by default — root and the OS user that\nowns the data directory, typically mysql. They are created as:\n\nCREATE USER root@localhost IDENTIFIED VIA unix_socket OR mysql_native_password\nUSING \'invalid\'\nCREATE USER mysql@localhost IDENTIFIED VIA unix_socket OR\nmysql_native_password USING \'invalid\'\n\nUsing unix_socket means that if you are the system root user, you can login as\nroot@locahost without a password. This technique was pioneered by Otto\nKekäläinen in Debian MariaDB packages and has been successfully used in Debian\nsince as early as MariaDB 10.0.\n\nIt is based on a simple fact that asking the system root for a password adds\nno extra security — root has full access to all the data files and all process\nmemory anyway. But not asking for a password means, there is no root password\nto forget (no need for the numerous tutorials on \"how to reset MariaDB root\npassword\"). And if you want to script some tedious database work, there is no\nneed to store the root password in plain text for the script to use (no need\nfor debian-sys-maint user).\n\nStill, some users may wish to log in as MariaDB root without using sudo. Hence\nthe old authentication method — conventional MariaDB password — is still\navailable. By default it is disabled (\"invalid\" is not a valid password hash),\nbut one can set the password with a usual SET PASSWORD statement. And still\nretain the password-less access via sudo.\n\nIf you install MariaDB locally (say from a tarball), you would not want to use\nsudo to be able to login. This is why MariaDB creates a second all-powerful\nuser with the same name as a system user that owns the data directory. In\nlocal (not system-wide) installations, this will be the user who installed\nMariaDB — they automatically get convenient password-less root-like access,\nbecause they can access all the data files anyway.\n\nEven if MariaDB is installed system-wide, you may not want to run your\ndatabase maintenance scripts as system root — now you can run them as system\nmysql user. And you will know that they will never destroy your entire system,\neven if you make a typo in a shell script.\n\nHowever, seasoned MariaDB DBAs who are used to the old ways do need to make\nsome changes. See the examples below for common tasks.\n\nCookbook\n--------\n\nAfter installing MariaDB system-wide the first thing you’ve got used to doing\nis logging in into the unprotected root account and protecting it, that is,\nsetting the root password:\n\n$ sudo dnf install MariaDB-server\n$ mysql -uroot\n...\nMariaDB> set password = password(\"XH4VmT3_jt\");\n\nThis is not only unnecessary now, it will simply not work — there is no\nunprotected root account. To login as root use\n\n$ sudo dnf install MariaDB-server\n$ sudo mysql\n\nNote that it implies you are connecting via the unix socket, not tcp. If you\nhappen to have protocol=tcp in a system-wide /etc/my.cnf file, use sudo mysql\n--protocol=socket.\n\nAfter installing MariaDB locally you’ve also used to connect to the\nunprotected root account using mysql -uroot. This will not work either, simply\nuse mysql without specifying a username.\n\nIf you\'ve forgotten your root password, no problem — you can still connect\nusing sudo and change the password. And if you\'ve also removed unix_socket\nauthentication, to restore access do as follows:\n\n* restart MariaDB with --skip-grant-tables\n* login into the unprotected server\n* run FLUSH PRIVILEGES (note, before 10.4 this would’ve been the last step,\nnot anymore). This disables --skip-grant-tables and allows you to change the\nstored authentication method\n* run SET PASSWORD FOR root@localhost to change the root password.\n\nTo view inside privilege tables, the old mysql.user table still exists. You\ncan select from it as before, although you cannot update it anymore. It\ndoesn’t show alternative authentication plugins and this was one of the\nreasons for switching to the mysql.global_priv table — complex authentication\nrules did not fit into rigid structure of a relational table. You can select\nfrom the new table, for example:\n\nselect concat(user, \'@\', host, \' => \', json_detailed(priv)) from\nmysql.global_priv;\n\nReverting to the Previous Authentication Method for root@localhost\n------------------------------------------------------------------\n\nIf you don\'t want the root@localhost user account created by mysql_install_db\nto use unix_socket authentication by default, then there are a few ways to\nrevert to the previous mysql_native_password authentication method for this\nuser account.\n\nConfiguring mysql_install_db to Revert to the Previous Authentication Method\n----------------------------------------------------------------------------\n\nOne way to revert to the previous mysql_native_password authentication method\nfor the root@localhost user account is to execute mysql_install_db with a\nspecial option. If mysql_install_db is executed while\n--auth-root-authentication-method=normal is specified, then it will create the\ndefault user accounts using the default behavior of MariaDB 10.3 and before.\n\nThis means that the root@localhost user account will use mysql_native_password\nauthentication by default. There are some other differences as well. See\nmysql_install_db: User Accounts Created by Default for more information.\n\nFor example, the option can be set on the command-line while running\nmysql_install_db:\n\nmysql_install_db --user=mysql --datadir=/var/lib/mysql\n--auth-root-authentication-method=normal\n\nThe option can also be set in an option file in an option group supported by\nmysql_install_db. For example:\n\n[mysql_install_db]\nauth_root_authentication_method=normal\n\nIf the option is set in an option file and if mysql_install_db is executed,\nthen mysql_install_db will read this option from the option file, and it will\nautomatically set this option.\n\nAltering the User Account to Revert to the Previous Authentication Method\n-------------------------------------------------------------------------\n\nIf you have already installed MariaDB, and if the root@localhost user account\nis already using unix_socket authentication, then you can revert to the old\nmysql_native_password authentication method for the user account by executing\nthe following:\n\nALTER USER root@localhost IDENTIFIED VIA mysql_native_password USING\nPASSWORD(\"verysecret\")\n\nURL: https://mariadb.com/kb/en/authentication-from-mariadb-104/','','https://mariadb.com/kb/en/authentication-from-mariadb-104/'),(119,'ST_X',11,'Syntax\n------\n\nST_X(p)\nX(p)\n\nDescription\n-----------\n\nReturns the X-coordinate value for the point p as a double-precision number.\n\nST_X() and X() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT X(GeomFromText(@pt));\n+----------------------+\n| X(GeomFromText(@pt)) |\n+----------------------+\n|                 56.7 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_x/','','https://mariadb.com/kb/en/st_x/'),(88,'IF Function',7,'Syntax\n------\n\nIF(expr1,expr2,expr3)\n\nDescription\n-----------\n\nIf expr1 is TRUE (expr1 <> 0 and expr1 <> NULL) then IF() returns expr2;\notherwise it returns expr3. IF() returns a numeric or string value, depending\non the context in which it is used.\n\nNote: There is also an IF statement which differs from the IF() function\ndescribed here.\n\nExamples\n--------\n\nSELECT IF(1>2,2,3);\n+-------------+\n| IF(1>2,2,3) |\n+-------------+\n|           3 |\n+-------------+\n\nSELECT IF(1<2,\'yes\',\'no\');\n+--------------------+\n| IF(1<2,\'yes\',\'no\') |\n+--------------------+\n| yes                |\n+--------------------+\n\nSELECT IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\');\n+---------------------------------------+\n| IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\') |\n+---------------------------------------+\n| no                                    |\n+---------------------------------------+\n\nURL: https://mariadb.com/kb/en/if-function/','','https://mariadb.com/kb/en/if-function/'),(89,'IFNULL',7,'Syntax\n------\n\nIFNULL(expr1,expr2)\nNVL(expr1,expr2)\n\nDescription\n-----------\n\nIf expr1 is not NULL, IFNULL() returns expr1; otherwise it returns expr2.\nIFNULL() returns a numeric or string value, depending on the context in which\nit is used.\n\nFrom MariaDB 10.3, NVL() is an alias for IFNULL().\n\nExamples\n--------\n\nSELECT IFNULL(1,0); \n+-------------+\n| IFNULL(1,0) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT IFNULL(NULL,10);\n+-----------------+\n| IFNULL(NULL,10) |\n+-----------------+\n|              10 |\n+-----------------+\n\nSELECT IFNULL(1/0,10);\n+----------------+\n| IFNULL(1/0,10) |\n+----------------+\n|        10.0000 |\n+----------------+\n\nSELECT IFNULL(1/0,\'yes\');\n+-------------------+\n| IFNULL(1/0,\'yes\') |\n+-------------------+\n| yes               |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/ifnull/','','https://mariadb.com/kb/en/ifnull/'),(94,'START TRANSACTION',8,'Syntax\n------\n\nSTART TRANSACTION [transaction_property [, transaction_property] ...] | BEGIN\n[WORK]\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nROLLBACK [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nSET autocommit = {0 | 1}\n\ntransaction_property:\n  WITH CONSISTENT SNAPSHOT\n | READ WRITE\n | READ ONLY\n\nDescription\n-----------\n\nThe START TRANSACTION or BEGIN statement begins a new transaction. COMMIT\ncommits the current transaction, making its changes permanent. ROLLBACK rolls\nback the current transaction, canceling its changes. The SET autocommit\nstatement disables or enables the default autocommit mode for the current\nsession.\n\nSTART TRANSACTION and SET autocommit = 1 implicitly commit the current\ntransaction, if any.\n\nThe optional WORK keyword is supported for COMMIT and ROLLBACK, as are the\nCHAIN and RELEASE clauses. CHAIN and RELEASE can be used for additional\ncontrol over transaction completion. The value of the completion_type system\nvariable determines the default completion behavior.\n\nThe AND CHAIN clause causes a new transaction to begin as soon as the current\none ends, and the new transaction has the same isolation level as the\njust-terminated transaction. The RELEASE clause causes the server to\ndisconnect the current client session after terminating the current\ntransaction. Including the NO keyword suppresses CHAIN or RELEASE completion,\nwhich can be useful if the completion_type system variable is set to cause\nchaining or release completion by default.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can perform DDL\nstatements on temporary tables.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the SET TRANSACTION\nstatement, in which case the specified mode is valid for all sessions, or for\nall subsequent transaction used by the current session.\n\nautocommit\n----------\n\nBy default, MariaDB runs with autocommit mode enabled. This means that as soon\nas you execute a statement that updates (modifies) a table, MariaDB stores the\nupdate on disk to make it permanent. To disable autocommit mode, use the\nfollowing statement:\n\nSET autocommit=0;\n\nAfter disabling autocommit mode by setting the autocommit variable to zero,\nchanges to transaction-safe tables (such as those for InnoDB or NDBCLUSTER)\nare not made permanent immediately. You must use COMMIT to store your changes\nto disk or ROLLBACK to ignore the changes.\n\nTo disable autocommit mode for a single series of statements, use the START\nTRANSACTION statement.\n\nDDL Statements\n--------------\n\nDDL statements (CREATE, ALTER, DROP) and administrative statements (FLUSH,\nRESET, OPTIMIZE, ANALYZE, CHECK, REPAIR, CACHE INDEX), transaction management\nstatements (BEGIN, START TRANSACTION) and LOAD DATA INFILE, cause an implicit\nCOMMIT and start a new transaction. An exception to this rule are the DDL that\noperate on temporary tables: you can CREATE, ALTER and DROP them without\ncausing any COMMIT, but those actions cannot be rolled back. This means that\nif you call ROLLBACK, the temporary tables you created in the transaction will\nremain, while the rest of the transaction will be rolled back.\n\nTransactions cannot be used in Stored Functions or Triggers. In Stored\nProcedures and Events BEGIN is not allowed, so you should use START\nTRANSACTION instead.\n\nA transaction acquires a metadata lock on every table it accesses to prevent\nother connections from altering their structure. The lock is released at the\nend of the transaction. This happens even with non-transactional storage\nengines (like MEMORY or CONNECT), so it makes sense to use transactions with\nnon-transactional tables.\n\nin_transaction\n--------------\n\nThe in_transaction system variable is a session-only, read-only variable that\nreturns 1 inside a transaction, and 0 if not in a transaction.\n\nWITH CONSISTENT SNAPSHOT\n------------------------\n\nThe WITH CONSISTENT SNAPSHOT option starts a consistent read for storage\nengines such as InnoDB that can do so, the same as if a START TRANSACTION\nfollowed by a SELECT from any InnoDB table was issued.\n\nSee Enhancements for START TRANSACTION WITH CONSISTENT SNAPSHOT.\n\nExamples\n--------\n\nSTART TRANSACTION;\nSELECT @A:=SUM(salary) FROM table1 WHERE type=1;\nUPDATE table2 SET summary=@A WHERE type=1;\nCOMMIT;\n\nURL: https://mariadb.com/kb/en/start-transaction/','','https://mariadb.com/kb/en/start-transaction/'),(120,'ST_Y',11,'Syntax\n------\n\nST_Y(p)\nY(p)\n\nDescription\n-----------\n\nReturns the Y-coordinate value for the point p as a double-precision number.\n\nST_Y() and Y() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT Y(GeomFromText(@pt));\n+----------------------+\n| Y(GeomFromText(@pt)) |\n+----------------------+\n|                53.34 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_y/','','https://mariadb.com/kb/en/st_y/'),(121,'X',11,'A synonym for ST_X.\n\nURL: https://mariadb.com/kb/en/point-properties-x/','','https://mariadb.com/kb/en/point-properties-x/'),(122,'Y',11,'A synonym for ST_Y.\n\nURL: https://mariadb.com/kb/en/point-properties-y/','','https://mariadb.com/kb/en/point-properties-y/'),(125,'DECODE_ORACLE',12,'MariaDB starting with 10.3.2\n----------------------------\nDECODE_ORACLE is a synonym for the Oracle mode version of the DECODE function,\nand is available in all modes.\n\nURL: https://mariadb.com/kb/en/decode_oracle/','','https://mariadb.com/kb/en/decode_oracle/'),(93,'SET TRANSACTION',8,'Syntax\n------\n\nSET [GLOBAL | SESSION] TRANSACTION\n  transaction_property [, transaction_property] ...\n\ntransaction_property:\n  ISOLATION LEVEL level\n | READ WRITE\n | READ ONLY\n\nlevel:\n  REPEATABLE READ\n | READ COMMITTED\n | READ UNCOMMITTED\n | SERIALIZABLE\n\nDescription\n-----------\n\nThis statement sets the transaction isolation level or the transaction access\nmode globally, for the current session, or for the next transaction:\n\n* With the GLOBAL keyword, the statement sets the default\n transaction level globally for all subsequent sessions. Existing sessions are\n unaffected.\n* With the SESSION keyword, the statement sets the default\n transaction level for all subsequent transactions performed within the\n current session.\n* Without any SESSION or GLOBAL keyword,\n the statement sets the isolation level for the next (not started) transaction\n performed within the current session.\n\nA change to the global default isolation level requires the SUPER privilege.\nAny session is free to change its session isolation level (even in the middle\nof a transaction), or the isolation level for its next transaction.\n\nIsolation Level\n---------------\n\nTo set the global default isolation level at server startup, use the\n--transaction-isolation=level option on the command line or in an option file.\nValues of level for this option use dashes rather than spaces, so the\nallowable values are READ-UNCOMMITTED, READ-COMMITTED, REPEATABLE-READ, or\nSERIALIZABLE. For example, to set the default isolation level to REPEATABLE\nREAD, use these lines in the [mysqld] section of an option file:\n\n[mysqld]\ntransaction-isolation = REPEATABLE-READ\nTo determine the global and session transaction isolation levels at runtime,\ncheck the value of the tx_isolation system variable:\n\nSELECT @@GLOBAL.tx_isolation, @@tx_isolation;\n\nInnoDB supports each of the translation isolation levels described here using\ndifferent locking strategies. The default level is REPEATABLE READ. For\nadditional information about InnoDB record-level locks and how it uses them to\nexecute various types of statements, see InnoDB Lock Modes, and\nhttp://dev.mysql.com/doc/refman/en/innodb-locks-set.html.\n\nIsolation Levels\n----------------\n\nThe following sections describe how MariaDB supports the different transaction\nlevels.\n\nREAD UNCOMMITTED\n----------------\n\nSELECT statements are performed in a non-locking fashion, but a possible\nearlier version of a row might be used. Thus, using this isolation level, such\nreads are not consistent. This is also called a \"dirty read.\" Otherwise, this\nisolation level works like READ COMMITTED.\n\nREAD COMMITTED\n--------------\n\nA somewhat Oracle-like isolation level with respect to consistent\n(non-locking) reads: Each consistent read, even within the same transaction,\nsets and reads its own fresh snapshot. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), InnoDB locks\nonly index records, not the gaps before them, and thus allows the free\ninsertion of new records next to locked records. For UPDATE and DELETE\nstatements, locking depends on whether the statement uses a unique index with\na unique search condition (such as WHERE id = 100), or a range-type search\ncondition (such as WHERE id > 100). For a unique index with a unique search\ncondition, InnoDB locks only the index record found, not the gap before it.\nFor range-type searches, InnoDB locks the index range scanned, using gap locks\nor next-key (gap plus index-record) locks to block insertions by other\nsessions into the gaps covered by the range. This is necessary because\n\"phantom rows\" must be blocked for MySQL replication and recovery to work.\n\nNote: If the READ COMMITTED isolation level is used or the\ninnodb_locks_unsafe_for_binlog system variable is enabled, there is no InnoDB\ngap locking except for foreign-key constraint checking and duplicate-key\nchecking. Also, record locks for non-matching rows are released after MariaDB\nhas evaluated the WHERE condition.If you use READ COMMITTED or enable\ninnodb_locks_unsafe_for_binlog, you must use row-based binary logging.\n\nREPEATABLE READ\n---------------\n\nThis is the default isolation level for InnoDB. For consistent reads, there is\nan important difference from the READ COMMITTED isolation level: All\nconsistent reads within the same transaction read the snapshot established by\nthe first read. This convention means that if you issue several plain\n(non-locking) SELECT statements within the same transaction, these SELECT\nstatements are consistent also with respect to each other. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), UPDATE, and\nDELETE statements, locking depends on whether the statement uses a unique\nindex with a unique search condition, or a range-type search condition. For a\nunique index with a unique search condition, InnoDB locks only the index\nrecord found, not the gap before it. For other search conditions, InnoDB locks\nthe index range scanned, using gap locks or next-key (gap plus index-record)\nlocks to block insertions by other sessions into the gaps covered by the range.\n\nThis is the minimum isolation level for non-distributed XA transactions.\n\nSERIALIZABLE\n------------\n\nThis level is like REPEATABLE READ, but InnoDB implicitly converts all plain\nSELECT statements to SELECT ... LOCK IN SHARE MODE if autocommit is disabled.\nIf autocommit is enabled, the SELECT is its own transaction. It therefore is\nknown to be read only and can be serialized if performed as a consistent\n(non-locking) read and need not block for other transactions. (This means that\nto force a plain SELECT to block if other transactions have modified the\nselected rows, you should disable autocommit.)\n\nDistributed XA transactions should always use this isolation level.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can perform DDL\nstatements on temporary tables.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the START TRANSACTION\nstatement, in which case the specified mode is only valid for one transaction.\n\nExamples\n--------\n\nSET GLOBAL TRANSACTION ISOLATION LEVEL SERIALIZABLE;\n\nAttempting to set the isolation level within an existing transaction without\nspecifying GLOBAL or SESSION.\n\nSTART TRANSACTION;\n\nSET TRANSACTION ISOLATION LEVEL SERIALIZABLE;\nERROR 1568 (25001): Transaction characteristics can\'t be changed while a\ntransaction is in progress\n\nURL: https://mariadb.com/kb/en/set-transaction/','','https://mariadb.com/kb/en/set-transaction/'),(126,'AES_DECRYPT',12,'Syntax\n------\n\nAES_DECRYPT(crypt_str,key_str)\n\nDescription\n-----------\n\nThis function allows decryption of data using the official AES (Advanced\nEncryption Standard) algorithm. For more information, see the description of\nAES_ENCRYPT().\n\nURL: https://mariadb.com/kb/en/aes_decrypt/','','https://mariadb.com/kb/en/aes_decrypt/'),(133,'MD5',12,'Syntax\n------\n\nMD5(str)\n\nDescription\n-----------\n\nCalculates an MD5 128-bit checksum for the string.\n\nThe return value is a 32-hex digit string, and as of MariaDB 5.5, is a\nnonbinary string in the connection character set and collation, determined by\nthe values of the character_set_connection and collation_connection system\nvariables. Before 5.5, the return value was a binary string.\n\nNULL is returned if the argument was NULL.\n\nExamples\n--------\n\nSELECT MD5(\'testing\');\n+----------------------------------+\n| MD5(\'testing\')                   |\n+----------------------------------+\n| ae2b1fca515949e5d54fb22b8ed95575 |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/md5/','','https://mariadb.com/kb/en/md5/'),(95,'COMMIT',8,'The COMMIT statement ends a transaction, saving any changes to the data so\nthat they become visible to subsequent transactions. Also, unlocks metadata\nchanged by current transaction. If autocommit is set to 1, an implicit commit\nis performed after each statement. Otherwise, all transactions which don\'t end\nwith an explicit COMMIT are implicitly rollbacked and the changes are lost.\nThe ROLLBACK statement can be used to do this explicitly.\n\nThe required syntax for the COMMIT statement is as follows:\n\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\n\nCOMMIT is the more important transaction terminator, as well as the more\ninteresting one. The basic form of the COMMIT statement is simply the keyword\nCOMMIT (the keyword WORK is simply noise and can be omitted without changing\nthe effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated.\n\nRELEASE tells the server to disconnect the client immediately after the\ncurrent transaction.\n\nThere are NO RELEASE and AND NO CHAIN options. By default, commits do not\nRELEASE or CHAIN, but it\'s possible to change this default behavior with the\ncompletion_type server system variable. In this case, the AND NO CHAIN and NO\nRELEASE options override the server default.\n\nURL: https://mariadb.com/kb/en/commit/','','https://mariadb.com/kb/en/commit/'),(96,'ROLLBACK',8,'The ROLLBACK statement rolls back (ends) a transaction, destroying any changes\nto SQL-data so that they never become visible to subsequent transactions. The\nrequired syntax for the ROLLBACK statement is as follows.\n\nROLLBACK [ WORK ] [ AND [ NO ] CHAIN ] \n[ TO [ SAVEPOINT ] {<savepoint name> | <simple target specification>} ]\n\nThe ROLLBACK statement will either end a transaction, destroying all data\nchanges that happened during any of the transaction, or it will just destroy\nany data changes that happened since you established a savepoint. The basic\nform of the ROLLBACK statement is just the keyword ROLLBACK (the keyword WORK\nis simply noise and can be omitted without changing the effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated. The AND NO CHAIN option just tells your DBMS to end the\ntransaction — that is, these four SQL statements are equivalent:\n\nROLLBACK; \nROLLBACK WORK; \nROLLBACK AND NO CHAIN; \nROLLBACK WORK AND NO CHAIN;\n\nAll of them end a transaction without saving any transaction characteristics.\nThe only other options, the equivalent statements:\n\nROLLBACK AND CHAIN;\nROLLBACK WORK AND CHAIN;\n\nboth tell your DBMS to end a transaction, but to save that transaction\'s\ncharacteristics for the next transaction.\n\nROLLBACK is much simpler than COMMIT: it may involve no more than a few\ndeletions (of Cursors, locks, prepared SQL statements and log-file entries).\nIt\'s usually assumed that ROLLBACK can\'t fail, although such a thing is\nconceivable (for example, an encompassing transaction might reject an attempt\nto ROLLBACK because it\'s lining up for a COMMIT).\n\nROLLBACK cancels all effects of a transaction. It does not cancel effects on\nobjects outside the DBMS\'s control (for example the values in host program\nvariables or the settings made by some SQL/CLI function calls). But in\ngeneral, it is a convenient statement for those situations when you say \"oops,\nthis isn\'t working\" or when you simply don\'t care whether your temporary work\nbecomes permanent or not.\n\nHere is a moot question. If all you\'ve been doing is SELECTs, so that there\nhave been no data changes, should you end the transaction with ROLLBACK or\nCOMMIT? It shouldn\'t really matter because both ROLLBACK and COMMIT do the\nsame transaction-terminating job. However, the popular conception is that\nROLLBACK implies failure, so after a successful series of SELECT statements\nthe convention is to end the transaction with COMMIT rather than ROLLBACK.\n\nMariaDB (and most other DBMSs) supports rollback of SQL-data change\nstatements, but not of SQL-Schema statements. This means that if you use any\nof CREATE, ALTER, DROP, GRANT, REVOKE, you are implicitly committing at\nexecution time.\n\nINSERT INTO Table_2 VALUES(5); \nDROP TABLE Table_3 CASCADE; \nROLLBACK;\n\nThe result will be that both the INSERT and the DROP will go through as\nseparate transactions so the ROLLBACK will have no effect.\n\nURL: https://mariadb.com/kb/en/rollback/','','https://mariadb.com/kb/en/rollback/'),(138,'ENDPOINT',13,'A synonym for ST_ENDPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-endpoint/','','https://mariadb.com/kb/en/linestring-properties-endpoint/'),(139,'GLENGTH',13,'Syntax\n------\n\nGLength(ls)\n\nDescription\n-----------\n\nReturns as a double-precision number the length of the LineString value ls in\nits associated spatial reference.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT GLength(GeomFromText(@ls));\n+----------------------------+\n| GLength(GeomFromText(@ls)) |\n+----------------------------+\n|           2.82842712474619 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/glength/','','https://mariadb.com/kb/en/glength/'),(140,'NumPoints',13,'A synonym for ST_NumPoints.\n\nURL: https://mariadb.com/kb/en/linestring-properties-numpoints/','','https://mariadb.com/kb/en/linestring-properties-numpoints/'),(141,'PointN',13,'A synonym for ST_PointN.\n\nURL: https://mariadb.com/kb/en/linestring-properties-pointn/','','https://mariadb.com/kb/en/linestring-properties-pointn/'),(142,'STARTPOINT',13,'A synonym for ST_STARTPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-startpoint/','','https://mariadb.com/kb/en/linestring-properties-startpoint/'),(143,'ST_ENDPOINT',13,'Syntax\n------\n\nST_EndPoint(ls)\nEndPoint(ls)\n\nDescription\n-----------\n\nReturns the Point that is the endpoint of the LineString value ls.\n\nST_EndPoint() and EndPoint() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(EndPoint(GeomFromText(@ls)));\n+-------------------------------------+\n| AsText(EndPoint(GeomFromText(@ls))) |\n+-------------------------------------+\n| POINT(3 3)                          |\n+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_endpoint/','','https://mariadb.com/kb/en/st_endpoint/'),(144,'ST_NUMPOINTS',13,'Syntax\n------\n\nST_NumPoints(ls)\nNumPoints(ls)\n\nDescription\n-----------\n\nReturns the number of Point objects in the LineString value ls.\n\nST_NumPoints() and NumPoints() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT NumPoints(GeomFromText(@ls));\n+------------------------------+\n| NumPoints(GeomFromText(@ls)) |\n+------------------------------+\n|                            3 |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/st_numpoints/','','https://mariadb.com/kb/en/st_numpoints/'),(97,'LOCK TABLES',8,'Syntax\n------\n\nLOCK TABLE[S]\n  tbl_name [[AS] alias] lock_type\n  [, tbl_name [[AS] alias] lock_type] ...\n  [WAIT n|NOWAIT]\n\nlock_type:\n  READ [LOCAL]\n | [LOW_PRIORITY] WRITE\n | WRITE CONCURRENT\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nThe lock_type can be one of:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| READ                      | Read lock, no writes allowed                   |\n+---------------------------+------------------------------------------------+\n| READ LOCAL                | Read lock, but allow concurrent inserts        |\n+---------------------------+------------------------------------------------+\n| WRITE                     | Exclusive write lock. No other connections     |\n|                           | can read or write to this table                |\n+---------------------------+------------------------------------------------+\n| LOW_PRIORITY WRITE        | Exclusive write lock, but allow new read       |\n|                           | locks on the table until we get the write      |\n|                           | lock.                                          |\n+---------------------------+------------------------------------------------+\n| WRITE CONCURRENT          | Exclusive write lock, but allow READ LOCAL     |\n|                           | locks to the table.                            |\n+---------------------------+------------------------------------------------+\n\nMariaDB enables client sessions to acquire table locks explicitly for the\npurpose of cooperating with other sessions for access to tables, or to prevent\nother sessions from modifying tables during periods when a session requires\nexclusive access to them. A session can acquire or release locks only for\nitself. One session cannot acquire locks for another session or release locks\nheld by another session.\n\nLocks may be used to emulate transactions or to get more speed when updating\ntables.\n\nLOCK TABLES explicitly acquires table locks for the current client session.\nTable locks can be acquired for base tables or views. To use LOCK TABLES, you\nmust have the LOCK TABLES privilege, and the SELECT privilege for each object\nto be locked. See GRANT\n\nFor view locking, LOCK TABLES adds all base tables used in the view to the set\nof tables to be locked and locks them automatically. If you lock a table\nexplicitly with LOCK TABLES, any tables used in triggers are also locked\nimplicitly, as described in Triggers and Implicit Locks.\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\n\nMariaDB starting with 10.3.0\n----------------------------\n\nWAIT/NOWAIT\n-----------\n\nSet the lock wait timeout. See WAIT and NOWAIT.\n\nLimitations\n-----------\n\n* LOCK TABLES doesn\'t work when using Galera cluster.   You may experience\ncrashes or locks when used with Galera.\n* LOCK TABLES works on XtraDB/InnoDB tables only if the innodb_table_locks\nsystem variable is set to 1 (the default) and autocommit is set to 0 (1 is\ndefault). Please note that no error message will be returned on LOCK TABLES\nwith innodb_table_locks = 0.\n* LOCK TABLES implicitly commits the active transaction, if any. Also,\nstarting a transaction always releases all table locks acquired with LOCK\nTABLES. This means that there is no way to have table locks and an active\ntransaction at the same time. The only exceptions are the transactions in\nautocommit mode. To preserve the data integrity between transactional and\nnon-transactional tables, the GET_LOCK() function can be used.\n* When using LOCK TABLES on a TEMPORARY table, it will always be locked with a\nWRITE lock.\n* While a connection holds an explicit read lock on a table, it cannot modify\nit. If you try, the following error will be produced:\n\nERROR 1099 (HY000): Table \'tab_name\' was locked with a READ lock and can\'t be\nupdated\n\n* While a connection holds an explicit lock on a table, it cannot access a\nnon-locked table. If you try, the following error will be produced:\n\nERROR 1100 (HY000): Table \'tab_name\' was not locked with LOCK TABLES\n\n* While a connection holds an explicit lock on a table, it cannot issue the\nfollowing: INSERT DELAYED, CREATE TABLE, CREATE TABLE ... LIKE, and DDL\nstatements involving stored programs and views (except for triggers). If you\ntry, the following error will be produced:\n\nERROR 1192 (HY000): Can\'t execute the given command because you have active\nlocked tables or an active transaction\n\n* LOCK TABLES can not be used in stored routines - if you try, the following\nerror will be produced on creation. This restriction was removed in MariaDB\n10.6.2:\n\nERROR 1314 (0A000): LOCK is not allowed in stored procedures\n\nURL: https://mariadb.com/kb/en/lock-tables/','','https://mariadb.com/kb/en/lock-tables/'),(145,'ST_POINTN',13,'Syntax\n------\n\nST_PointN(ls,N)\nPointN(ls,N)\n\nDescription\n-----------\n\nReturns the N-th Point in the LineString value ls. Points are numbered\nbeginning with 1.\n\nST_PointN() and PointN() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(PointN(GeomFromText(@ls),2));\n+-------------------------------------+\n| AsText(PointN(GeomFromText(@ls),2)) |\n+-------------------------------------+\n| POINT(2 2)                          |\n+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_pointn/','','https://mariadb.com/kb/en/st_pointn/'),(146,'ST_STARTPOINT',13,'Syntax\n------\n\nST_StartPoint(ls)\nStartPoint(ls)\n\nDescription\n-----------\n\nReturns the Point that is the start point of the LineString value ls.\n\nST_StartPoint() and StartPoint() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(StartPoint(GeomFromText(@ls)));\n+---------------------------------------+\n| AsText(StartPoint(GeomFromText(@ls))) |\n+---------------------------------------+\n| POINT(1 1)                            |\n+---------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_startpoint/','','https://mariadb.com/kb/en/st_startpoint/'),(150,'INET_ATON',14,'Syntax\n------\n\nINET_ATON(expr)\n\nDescription\n-----------\n\nGiven the dotted-quad representation of an IPv4 network address as a string,\nreturns an integer that represents the numeric value of the address. Addresses\nmay be 4- or 8-byte addresses.\n\nReturns NULL if the argument is not understood.\n\nExamples\n--------\n\nSELECT INET_ATON(\'192.168.1.1\');\n+--------------------------+\n| INET_ATON(\'192.168.1.1\') |\n+--------------------------+\n|               3232235777 |\n+--------------------------+\n\nThis is calculated as follows: 192 x 2563 + 168 x 256 2 + 1 x 256 + 1\n\nURL: https://mariadb.com/kb/en/inet_aton/','','https://mariadb.com/kb/en/inet_aton/'),(151,'INET_NTOA',14,'Syntax\n------\n\nINET_NTOA(expr)\n\nDescription\n-----------\n\nGiven a numeric IPv4 network address in network byte order (4 or 8 byte),\nreturns the dotted-quad representation of the address as a string.\n\nExamples\n--------\n\nSELECT INET_NTOA(3232235777);\n+-----------------------+\n| INET_NTOA(3232235777) |\n+-----------------------+\n| 192.168.1.1           |\n+-----------------------+\n\n192.168.1.1 corresponds to 3232235777 since 192 x 2563 + 168 x 256 2 + 1 x 256\n+ 1 = 3232235777\n\nURL: https://mariadb.com/kb/en/inet_ntoa/','','https://mariadb.com/kb/en/inet_ntoa/'),(98,'SAVEPOINT',8,'Syntax\n------\n\nSAVEPOINT identifier\nROLLBACK [WORK] TO [SAVEPOINT] identifier\nRELEASE SAVEPOINT identifier\n\nDescription\n-----------\n\nInnoDB supports the SQL statements SAVEPOINT, ROLLBACK TO SAVEPOINT, RELEASE\nSAVEPOINT and the optional WORK keyword for ROLLBACK.\n\nEach savepoint must have a legal MariaDB identifier. A savepoint is a named\nsub-transaction.\n\nNormally ROLLBACK undoes the changes performed by the whole transaction. When\nused with the TO clause, it undoes the changes performed after the specified\nsavepoint, and erases all subsequent savepoints. However, all locks that have\nbeen acquired after the save point will survive. RELEASE SAVEPOINT does not\nrollback or commit any changes, but removes the specified savepoint.\n\nWhen the execution of a trigger or a stored function begins, it is not\npossible to use statements which reference a savepoint which was defined from\nout of that stored program.\n\nWhen a COMMIT (including implicit commits) or a ROLLBACK statement (with no TO\nclause) is performed, they act on the whole transaction, and all savepoints\nare removed.\n\nErrors\n------\n\nIf COMMIT or ROLLBACK is issued and no transaction was started, no error is\nreported.\n\nIf SAVEPOINT is issued and no transaction was started, no error is reported\nbut no savepoint is created. When ROLLBACK TO SAVEPOINT or RELEASE SAVEPOINT\nis called for a savepoint that does not exist, an error like this is issued:\n\nERROR 1305 (42000): SAVEPOINT svp_name does not exist\n\nURL: https://mariadb.com/kb/en/savepoint/','','https://mariadb.com/kb/en/savepoint/'),(99,'Metadata Locking',8,'MariaDB supports metadata locking. This means that when a transaction\n(including XA transactions) uses a table, it locks its metadata until the end\nof transaction. Non-transactional tables are also locked, as well as views and\nobjects which are related to locked tables/views (stored functions, triggers,\netc). When a connection tries to use a DDL statement (like an ALTER TABLE)\nwhich modifies a table that is locked, that connection is queued, and has to\nwait until it\'s unlocked. Using savepoints and performing a partial rollback\ndoes not release metadata locks.\n\nLOCK TABLES ... WRITE are also queued. Some wrong statements which produce an\nerror may not need to wait for the lock to be freed.\n\nThe metadata lock\'s timeout is determined by the value of the\nlock_wait_timeout server system variable (in seconds). However, note that its\ndefault value is 31536000 (1 year, MariaDB <= 10.2.3), or 86400 (1 day,\nMariaDB >= 10.2.4). If this timeout is exceeded, the following error is\nreturned:\n\nERROR 1205 (HY000): Lock wait timeout exceeded; try restarting transaction\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table stores information about existing metadata locks.\n\nMariaDB starting with 10.5.2\n----------------------------\nFrom MariaDB 10.5, the Performance Schema metadata_locks table contains\nmetadata lock information.\n\nExample\n-------\n\nLet\'s use the following MEMORY (non-transactional) table:\n\nCREATE TABLE t (a INT) ENGINE = MEMORY;\n\nConnection 1 starts a transaction, and INSERTs a row into t:\n\nSTART TRANSACTION;\n\nINSERT INTO t SET a=1;\n\nt\'s metadata is now locked by connection 1. Connection 2 tries to alter t, but\nhas to wait:\n\nALTER TABLE t ADD COLUMN b INT;\n\nConnection 2\'s prompt is blocked now.\n\nNow connection 1 ends the transaction:\n\nCOMMIT;\n\n...and connection 2 finally gets the output of its command:\n\nQuery OK, 1 row affected (35.23 sec)\nRecords: 1  Duplicates: 0  Warnings: 0\n\nURL: https://mariadb.com/kb/en/metadata-locking/','','https://mariadb.com/kb/en/metadata-locking/'),(100,'Transaction Timeouts',8,'MariaDB has always had the wait_timeout and interactive_timeout settings,\nwhich close connections after a certain period of inactivity.\n\nHowever, these are by default set to a long wait period. In situations where\ntransactions may be started, but not committed or rolled back, more granular\ncontrol and a shorter timeout may be desirable so as to avoid locks being held\nfor too long.\n\nMariaDB 10.3 introduced three new variables to handle this situation.\n\n* idle_transaction_timeout (all transactions)\n* idle_write_transaction_timeout (write transactions - called\nidle_readwrite_transaction_timeout until MariaDB 10.3.2)\n* idle_readonly_transaction_timeout (read transactions)\n\nThese accept a time in seconds to time out, by closing the connection,\ntransactions that are idle for longer than this period. By default all are set\nto zero, or no timeout.\n\nidle_transaction_timeout affects all transactions,\nidle_write_transaction_timeout affects write transactions only and\nidle_readonly_transaction_timeout affects read transactions only. The latter\ntwo variables work independently. However, if either is set along with\nidle_transaction_timeout, the settings for idle_write_transaction_timeout or\nidle_readonly_transaction_timeout will take precedence.\n\nExamples\n--------\n\nSET SESSION idle_transaction_timeout=2;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 3 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nSET SESSION idle_write_transaction_timeout=2;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 3 seconds\nSELECT * FROM t;\nEmpty set (0.000 sec)\nINSERT INTO t VALUES(1);\n## wait 3 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nSET SESSION idle_transaction_timeout=2, SESSION\nidle_readonly_transaction_timeout=10;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n ## wait 3 seconds\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 11 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nURL: https://mariadb.com/kb/en/transaction-timeouts/','','https://mariadb.com/kb/en/transaction-timeouts/'),(152,'IS_FREE_LOCK',14,'Syntax\n------\n\nIS_FREE_LOCK(str)\n\nDescription\n-----------\n\nChecks whether the lock named str is free to use (that is, not locked).\nReturns 1 if the lock is free (no one is using the lock), 0 if the lock is in\nuse, and NULL if an error occurs (such as an incorrect argument, like an empty\nstring or NULL). str is case insensitive.\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table contains information about locks of this kind (as\nwell as metadata locks).\n\nStatements using the IS_FREE_LOCK function are not safe for statement-based\nreplication.\n\nURL: https://mariadb.com/kb/en/is_free_lock/','','https://mariadb.com/kb/en/is_free_lock/'),(156,'IS_IPV6',14,'Syntax\n------\n\nIS_IPV6(expr)\n\nDescription\n-----------\n\nReturns 1 if the expression is a valid IPv6 address specified as a string,\notherwise returns 0. Does not consider IPv4 addresses to be valid IPv6\naddresses.\n\nExamples\n--------\n\nSELECT IS_IPV6(\'48f3::d432:1431:ba23:846f\');\n+--------------------------------------+\n| IS_IPV6(\'48f3::d432:1431:ba23:846f\') |\n+--------------------------------------+\n|                                    1 |\n+--------------------------------------+\n1 row in set (0.02 sec)\n\nSELECT IS_IPV6(\'10.0.1.1\');\n+---------------------+\n| IS_IPV6(\'10.0.1.1\') |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/is_ipv6/','','https://mariadb.com/kb/en/is_ipv6/'),(157,'IS_USED_LOCK',14,'Syntax\n------\n\nIS_USED_LOCK(str)\n\nDescription\n-----------\n\nChecks whether the lock named str is in use (that is, locked). If so, it\nreturns the connection identifier of the client that holds the lock.\nOtherwise, it returns NULL. str is case insensitive.\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table contains information about locks of this kind (as\nwell as metadata locks).\n\nStatements using the IS_USED_LOCK function are not safe for statement-based\nreplication.\n\nURL: https://mariadb.com/kb/en/is_used_lock/','','https://mariadb.com/kb/en/is_used_lock/'),(102,'WAIT and NOWAIT',8,'MariaDB starting with 10.3.0\n----------------------------\nMariaDB 10.3.0 introduced extended syntax so that it is possible to set\ninnodb_lock_wait_timeout and lock_wait_timeout for the following statements:\n\nSyntax\n------\n\nALTER TABLE tbl_name [WAIT n|NOWAIT] ...\nCREATE ... INDEX ON tbl_name (index_col_name, ...) [WAIT n|NOWAIT] ...\nDROP INDEX ... [WAIT n|NOWAIT]\nDROP TABLE tbl_name [WAIT n|NOWAIT] ...\nLOCK TABLE ... [WAIT n|NOWAIT]\nOPTIMIZE TABLE tbl_name [WAIT n|NOWAIT]\nRENAME TABLE tbl_name [WAIT n|NOWAIT] ...\nSELECT ... FOR UPDATE [WAIT n|NOWAIT]\nSELECT ... LOCK IN SHARE MODE [WAIT n|NOWAIT]\nTRUNCATE TABLE tbl_name [WAIT n|NOWAIT]\n\nDescription\n-----------\n\nThe lock wait timeout can be explicitly set in the statement by using either\nWAIT n (to set the wait in seconds) or NOWAIT, in which case the statement\nwill immediately fail if the lock cannot be obtained. WAIT 0 is equivalent to\nNOWAIT.\n\nURL: https://mariadb.com/kb/en/wait-and-nowait/','','https://mariadb.com/kb/en/wait-and-nowait/'),(106,'DROP USER',10,'Syntax\n------\n\nDROP USER [IF EXISTS] user_name [, user_name] ...\n\nDescription\n-----------\n\nThe DROP USER statement removes one or more MariaDB accounts. It removes\nprivilege rows for the account from all grant tables. To use this statement,\nyou must have the global CREATE USER privilege or the DELETE privilege for the\nmysql database. Each account is named using the same format as for the CREATE\nUSER statement; for example, \'jeffrey\'@\'localhost\'. If you specify only the\nuser name part of the account name, a host name part of \'%\' is used. For\nadditional information about specifying account names, see CREATE USER.\n\nNote that, if you specify an account that is currently connected, it will not\nbe deleted until the connection is closed. The connection will not be\nautomatically closed.\n\nIf any of the specified user accounts do not exist, ERROR 1396 (HY000)\nresults. If an error occurs, DROP USER will still drop the accounts that do\nnot result in an error. Only one error is produced for all users which have\nnot been dropped:\n\nERROR 1396 (HY000): Operation DROP USER failed for \'u1\'@\'%\',\'u2\'@\'%\'\n\nFailed CREATE or DROP operations, for both users and roles, produce the same\nerror code.\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the user does not exist.\n\nExamples\n--------\n\nDROP USER bob;\n\nDROP USER foo2@localhost,foo2@\'127.%\';\n\nIF EXISTS:\n\nDROP USER bob;\nERROR 1396 (HY000): Operation DROP USER failed for \'bob\'@\'%\'\n\nDROP USER IF EXISTS bob;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+---------------------------------------------+\n| Level | Code | Message                                     |\n+-------+------+---------------------------------------------+\n| Note  | 1974 | Can\'t drop user \'bob\'@\'%\'; it doesn\'t exist |\n+-------+------+---------------------------------------------+\n\nURL: https://mariadb.com/kb/en/drop-user/','','https://mariadb.com/kb/en/drop-user/'),(108,'RENAME USER',10,'Syntax\n------\n\nRENAME USER old_user TO new_user\n  [, old_user TO new_user] ...\n\nDescription\n-----------\n\nThe RENAME USER statement renames existing MariaDB accounts. To use it, you\nmust have the global CREATE USER privilege or the UPDATE privilege for the\nmysql database. Each account is named using the same format as for the CREATE\nUSER statement; for example, \'jeffrey\'@\'localhost\'. If you specify only the\nuser name part of the account name, a host name part of \'%\' is used.\n\nIf any of the old user accounts do not exist or any of the new user accounts\nalready exist, ERROR 1396 (HY000) results. If an error occurs, RENAME USER\nwill still rename the accounts that do not result in an error.\n\nExamples\n--------\n\nCREATE USER \'donald\', \'mickey\';\nRENAME USER \'donald\' TO \'duck\'@\'localhost\', \'mickey\' TO \'mouse\'@\'localhost\';\n\nURL: https://mariadb.com/kb/en/rename-user/','','https://mariadb.com/kb/en/rename-user/'),(109,'REVOKE',10,'Privileges\n----------\n\nSyntax\n------\n\nREVOKE \n  priv_type [(column_list)]\n   [, priv_type [(column_list)]] ...\n  ON [object_type] priv_level\n  FROM user [, user] ...\n\nREVOKE ALL PRIVILEGES, GRANT OPTION\n  FROM user [, user] ...\n\nDescription\n-----------\n\nThe REVOKE statement enables system administrators to revoke privileges (or\nroles - see section below) from MariaDB accounts. Each account is named using\nthe same format as for the GRANT statement; for example,\n\'jeffrey\'@\'localhost\'. If you specify only the user name part of the account\nname, a host name part of \'%\' is used. For details on the levels at which\nprivileges exist, the allowable priv_type and priv_level values, and the\nsyntax for specifying users and passwords, see GRANT.\n\nTo use the first REVOKE syntax, you must have the GRANT OPTION privilege, and\nyou must have the privileges that you are revoking.\n\nTo revoke all privileges, use the second syntax, which drops all global,\ndatabase, table, column, and routine privileges for the named user or users:\n\nREVOKE ALL PRIVILEGES, GRANT OPTION FROM user [, user] ...\n\nTo use this REVOKE syntax, you must have the global CREATE USER privilege or\nthe UPDATE privilege for the mysql database. See GRANT.\n\nExamples\n--------\n\nREVOKE SUPER ON *.* FROM \'alexander\'@\'localhost\';\n\nRoles\n-----\n\nSyntax\n------\n\nREVOKE role  [, role ...]\n  FROM grantee [, grantee2 ... ]\n\nREVOKE ADMIN OPTION FOR role FROM grantee [, grantee2]\n\nDescription\n-----------\n\nREVOKE is also used to remove a role from a user or another role that it\'s\npreviously been assigned to. If a role has previously been set as a default\nrole, REVOKE does not remove the record of the default role from the\nmysql.user table. If the role is subsequently granted again, it will again be\nthe user\'s default. Use SET DEFAULT ROLE NONE to explicitly remove this.\n\nBefore MariaDB 10.1.13, the REVOKE role statement was not permitted in\nprepared statements.\n\nExample\n-------\n\nREVOKE journalist FROM hulda\n\nURL: https://mariadb.com/kb/en/revoke/','','https://mariadb.com/kb/en/revoke/'),(160,'NAME_CONST',14,'Syntax\n------\n\nNAME_CONST(name,value)\n\nDescription\n-----------\n\nReturns the given value. When used to produce a result set column,\nNAME_CONST() causes the column to have the given name. The arguments should be\nconstants.\n\nThis function is used internally when replicating stored procedures. It makes\nlittle sense to use it explicitly in SQL statements, and it was not supposed\nto be used like that.\n\nSELECT NAME_CONST(\'myname\', 14);\n+--------+\n| myname |\n+--------+\n|     14 |\n+--------+\n\nURL: https://mariadb.com/kb/en/name_const/','','https://mariadb.com/kb/en/name_const/'),(163,'SLEEP',14,'Syntax\n------\n\nSLEEP(duration)\n\nDescription\n-----------\n\nSleeps (pauses) for the number of seconds given by the duration argument, then\nreturns 0. If SLEEP() is interrupted, it returns 1. The duration may have a\nfractional part given in microseconds.\n\nStatements using the SLEEP() function are not safe for replication.\n\nExample\n-------\n\nSELECT SLEEP(5.5);\n+------------+\n| SLEEP(5.5) |\n+------------+\n|          0 |\n+------------+\n1 row in set (5.50 sec)\n\nURL: https://mariadb.com/kb/en/sleep/','','https://mariadb.com/kb/en/sleep/'),(167,'!',15,'Syntax\n------\n\nNOT, !\n\nDescription\n-----------\n\nLogical NOT. Evaluates to 1 if the operand is 0, to 0 if the operand is\nnon-zero, and NOT NULL returns NULL.\n\nBy default, the ! operator has a higher precedence. If the HIGH_NOT_PRECEDENCE\nSQL_MODE flag is set, NOT and ! have the same precedence.\n\nExamples\n--------\n\nSELECT NOT 10;\n+--------+\n| NOT 10 |\n+--------+\n|      0 |\n+--------+\n\nSELECT NOT 0;\n+-------+\n| NOT 0 |\n+-------+\n|     1 |\n+-------+\n\nSELECT NOT NULL;\n+----------+\n| NOT NULL |\n+----------+\n|     NULL |\n+----------+\n\nSELECT ! (1+1);\n+---------+\n| ! (1+1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ! 1+1;\n+-------+\n| ! 1+1 |\n+-------+\n|     1 |\n+-------+\n\nURL: https://mariadb.com/kb/en/not/','','https://mariadb.com/kb/en/not/'),(110,'SET PASSWORD',10,'Syntax\n------\n\nSET PASSWORD [FOR user] =\n  {\n    PASSWORD(\'some password\')\n   | OLD_PASSWORD(\'some password\')\n   | \'encrypted password\'\n  }\n\nDescription\n-----------\n\nThe SET PASSWORD statement assigns a password to an existing MariaDB user\naccount.\n\nIf the password is specified using the PASSWORD() or OLD_PASSWORD() function,\nthe literal text of the password should be given. If the password is specified\nwithout using either function, the password should be the already-encrypted\npassword value as returned by PASSWORD().\n\nOLD_PASSWORD() should only be used if your MariaDB/MySQL clients are very old\n(< 4.0.0).\n\nWith no FOR clause, this statement sets the password for the current user. Any\nclient that has connected to the server using a non-anonymous account can\nchange the password for that account.\n\nWith a FOR clause, this statement sets the password for a specific account on\nthe current server host. Only clients that have the UPDATE privilege for the\nmysql database can do this. The user value should be given in\nuser_name@host_name format, where user_name and host_name are exactly as they\nare listed in the User and Host columns of the mysql.user table (or view in\nMariaDB-10.4 onwards) entry.\n\nThe argument to PASSWORD() and the password given to MariaDB clients can be of\narbitrary length.\n\nAuthentication Plugin Support\n-----------------------------\n\nMariaDB starting with 10.4\n--------------------------\nIn MariaDB 10.4 and later, SET PASSWORD (with or without PASSWORD()) works for\naccounts authenticated via any authentication plugin that supports passwords\nstored in the mysql.global_priv table.\n\nThe ed25519, mysql_native_password, and mysql_old_password authentication\nplugins store passwords in the mysql.global_priv table.\n\nIf you run SET PASSWORD on an account that authenticates with one of these\nauthentication plugins that stores passwords in the mysql.global_priv table,\nthen the PASSWORD() function is evaluated by the specific authentication\nplugin used by the account. The authentication plugin hashes the password with\na method that is compatible with that specific authentication plugin.\n\nThe unix_socket, named_pipe, gssapi, and pam authentication plugins do not\nstore passwords in the mysql.global_priv table. These authentication plugins\nrely on other methods to authenticate the user.\n\nIf you attempt to run SET PASSWORD on an account that authenticates with one\nof these authentication plugins that doesn\'t store a password in the\nmysql.global_priv table, then MariaDB Server will raise a warning like the\nfollowing:\n\nSET PASSWORD is ignored for users authenticating via unix_socket plugin\n\nSee Authentication from MariaDB 10.4 for an overview of authentication changes\nin MariaDB 10.4.\n\nMariaDB until 10.3\n------------------\nIn MariaDB 10.3 and before, SET PASSWORD (with or without PASSWORD()) only\nworks for accounts authenticated via mysql_native_password or\nmysql_old_password authentication plugins\n\nPasswordless User Accounts\n--------------------------\n\nUser accounts do not always require passwords to login.\n\nThe unix_socket , named_pipe and gssapi authentication plugins do not require\na password to authenticate the user.\n\nThe pam authentication plugin may or may not require a password to\nauthenticate the user, depending on the specific configuration.\n\nThe mysql_native_password and mysql_old_password authentication plugins\nrequire passwords for authentication, but the password can be blank. In that\ncase, no password is required.\n\nIf you provide a password while attempting to log into the server as an\naccount that doesn\'t require a password, then MariaDB server will simply\nignore the password.\n\nMariaDB starting with 10.4\n--------------------------\nIn MariaDB 10.4 and later, a user account can be defined to use multiple\nauthentication plugins in a specific order of preference. This specific\nscenario may be more noticeable in these versions, since an account could be\nassociated with some authentication plugins that require a password, and some\nthat do not.\n\nExample\n-------\n\nFor example, if you had an entry with User and Host column values of \'bob\' and\n\'%.loc.gov\', you would write the statement like this:\n\nSET PASSWORD FOR \'bob\'@\'%.loc.gov\' = PASSWORD(\'newpass\');\n\nIf you want to delete a password for a user, you would do:\n\nSET PASSWORD FOR \'bob\'@localhost = PASSWORD(\"\");\n\nURL: https://mariadb.com/kb/en/set-password/','','https://mariadb.com/kb/en/set-password/'),(112,'DROP ROLE',10,'Syntax\n------\n\nDROP ROLE [IF EXISTS] role_name [,role_name ...]\n\nDescription\n-----------\n\nThe DROP ROLE statement removes one or more MariaDB roles. To use this\nstatement, you must have the global CREATE USER privilege or the DELETE\nprivilege for the mysql database.\n\nDROP ROLE does not disable roles for connections which selected them with SET\nROLE. If a role has previously been set as a default role, DROP ROLE does not\nremove the record of the default role from the mysql.user table. If the role\nis subsequently recreated and granted, it will again be the user\'s default.\nUse SET DEFAULT ROLE NONE to explicitly remove this.\n\nIf any of the specified user accounts do not exist, ERROR 1396 (HY000)\nresults. If an error occurs, DROP ROLE will still drop the roles that do not\nresult in an error. Only one error is produced for all roles which have not\nbeen dropped:\n\nERROR 1396 (HY000): Operation DROP ROLE failed for \'a\',\'b\',\'c\'\n\nFailed CREATE or DROP operations, for both users and roles, produce the same\nerror code.\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a warning instead of an\nerror if the role does not exist.\n\nExamples\n--------\n\nDROP ROLE journalist;\n\nThe same thing using the optional IF EXISTS clause:\n\nDROP ROLE journalist;\nERROR 1396 (HY000): Operation DROP ROLE failed for \'journalist\'\n\nDROP ROLE IF EXISTS journalist;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nNote (Code 1975): Can\'t drop role \'journalist\'; it doesn\'t exist\n\nURL: https://mariadb.com/kb/en/drop-role/','','https://mariadb.com/kb/en/drop-role/'),(168,'&&',15,'Syntax\n------\n\nAND, &&\n\nDescription\n-----------\n\nLogical AND. Evaluates to 1 if all operands are non-zero and not NULL, to 0 if\none or more operands are 0, otherwise NULL is returned.\n\nFor this operator, short-circuit evaluation can be used.\n\nExamples\n--------\n\nSELECT 1 && 1;\n+--------+\n| 1 && 1 |\n+--------+\n|      1 |\n+--------+\n\nSELECT 1 && 0;\n+--------+\n| 1 && 0 |\n+--------+\n|      0 |\n+--------+\n\nSELECT 1 && NULL;\n+-----------+\n| 1 && NULL |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT 0 && NULL;\n+-----------+\n| 0 && NULL |\n+-----------+\n|         0 |\n+-----------+\n\nSELECT NULL && 0;\n+-----------+\n| NULL && 0 |\n+-----------+\n|         0 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/and/','','https://mariadb.com/kb/en/and/'),(169,'XOR',15,'Syntax\n------\n\nXOR\n\nDescription\n-----------\n\nXOR stands for eXclusive OR. Returns NULL if either operand is NULL. For\nnon-NULL operands, evaluates to 1 if an odd number of operands is non-zero,\notherwise 0 is returned.\n\nExamples\n--------\n\nSELECT 1 XOR 1;\n+---------+\n| 1 XOR 1 |\n+---------+\n|       0 |\n+---------+\n\nSELECT 1 XOR 0;\n+---------+\n| 1 XOR 0 |\n+---------+\n|       1 |\n+---------+\n\nSELECT 1 XOR NULL;\n+------------+\n| 1 XOR NULL |\n+------------+\n|       NULL |\n+------------+\n\nIn the following example, the right 1 XOR 1 is evaluated first, and returns 0.\nThen, 1 XOR 0 is evaluated, and 1 is returned.\n\nSELECT 1 XOR 1 XOR 1;\n+---------------+\n| 1 XOR 1 XOR 1 |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/xor/','','https://mariadb.com/kb/en/xor/'),(111,'CREATE ROLE',10,'Syntax\n------\n\nCREATE [OR REPLACE] ROLE [IF NOT EXISTS] role \n [WITH ADMIN\n  {CURRENT_USER | CURRENT_ROLE | user | role}]\n\nDescription\n-----------\n\nThe CREATE ROLE statement creates one or more MariaDB roles. To use it, you\nmust have the global CREATE USER privilege or the INSERT privilege for the\nmysql database. For each account, CREATE ROLE creates a new row in the\nmysql.user table that has no privileges, and with the corresponding is_role\nfield set to Y. It also creates a record in the mysql.roles_mapping table.\n\nIf any of the specified roles already exist, ERROR 1396 (HY000) results. If an\nerror occurs, CREATE ROLE will still create the roles that do not result in an\nerror. The maximum length for a role is 128 characters. Role names can be\nquoted, as explained in the Identifier names page. Only one error is produced\nfor all roles which have not been created:\n\nERROR 1396 (HY000): Operation CREATE ROLE failed for \'a\',\'b\',\'c\'\n\nFailed CREATE or DROP operations, for both users and roles, produce the same\nerror code.\n\nPUBLIC and NONE are reserved, and cannot be used as role names. NONE is used\nto unset a role and PUBLIC has a special use in other systems, such as Oracle,\nso is reserved for compatibility purposes.\n\nFor valid identifiers to use as role names, see Identifier Names.\n\nWITH ADMIN\n----------\n\nThe optional WITH ADMIN clause determines whether the current user, the\ncurrent role or another user or role has use of the newly created role. If the\nclause is omitted, WITH ADMIN CURRENT_USER is treated as the default, which\nmeans that the current user will be able to GRANT this role to users.\n\nOR REPLACE\n----------\n\nIf the optional OR REPLACE clause is used, it acts as a shortcut for:\n\nDROP ROLE IF EXISTS name;\nCREATE ROLE name ...;\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified role already exists. Cannot be used together with\nthe OR REPLACE clause.\n\nExamples\n--------\n\nCREATE ROLE journalist;\n\nCREATE ROLE developer WITH ADMIN lorinda@localhost;\n\nGranting the role to another user. Only user lorinda@localhost has permission\nto grant the developer role:\n\nSELECT USER();\n+-------------------+\n| USER()            |\n+-------------------+\n| henning@localhost |\n+-------------------+\n...\nGRANT developer TO ian@localhost;\nAccess denied for user \'henning\'@\'localhost\'\n\nSELECT USER();\n+-------------------+\n| USER()            |\n+-------------------+\n| lorinda@localhost |\n+-------------------+\n\nGRANT m_role TO ian@localhost;\n\nThe OR REPLACE and IF NOT EXISTS clauses. The journalist role already exists:\n\nCREATE ROLE journalist;\nERROR 1396 (HY000): Operation CREATE ROLE failed for \'journalist\'\n\nCREATE OR REPLACE ROLE journalist;\nQuery OK, 0 rows affected (0.00 sec)\n\nCREATE ROLE IF NOT EXISTS journalist;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+---------------------------------------------------+\n| Level | Code | Message                                           |\n+-------+------+---------------------------------------------------+\n| Note  | 1975 | Can\'t create role \'journalist\'; it already exists |\n+-------+------+---------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/create-role/','','https://mariadb.com/kb/en/create-role/'),(113,'SET ROLE',10,'Syntax\n------\n\nSET ROLE { role | NONE }\n\nDescription\n-----------\n\nThe SET ROLE statement enables a role, along with all of its associated\npermissions, for the current session. To unset a role, use NONE .\n\nIf a role that doesn\'t exist, or to which the user has not been assigned, is\nspecified, an ERROR 1959 (OP000): Invalid role specification error occurs.\n\nAn automatic SET ROLE is implicitly performed when a user connects if that\nuser has been assigned a default role. See SET DEFAULT ROLE.\n\nExample\n-------\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n|