/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
INSERT INTO `encrypted_data` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `content_type`, `secret_id`, `kek_id`, `cypher_text`, `kek_meta_extended`) VALUES ('4da45cfc-e1a1-4841-a0f6-658e407c0e44','2026-01-22 00:07:02','2026-01-22 00:07:18','2026-01-22 00:07:18',1,'ACTIVE','application/octet-stream','19b367bd-45f7-4f68-81d1-e2fe3c4261a2','bd7b571c-7bef-40d9-a8cc-99b63554414d','Z0FBQUFBQnBjV29tMGFJZWthM252U1NHWWRFVFBaSDRGTXc2SFFIeklZcnJNMnFOcHF1Y0hQQUtZZ1lKUEg0MWF3VGN3QUJEMzFWOTJIdEJ4b3J1N0lvMi00dEptVVZGdzNnNGV1MnBUbWZHY2RRZEFUeHVQY1J4MWt2WV91R1kyMzlxRFpFcXFEQWU=',NULL),('f09d9847-1004-4b27-8328-f42ab79be534','2026-01-22 00:02:46','2026-01-22 00:07:55','2026-01-22 00:07:55',1,'ACTIVE','application/octet-stream','ee393725-9bb8-43df-9bbc-06594f158361','ce13ce1e-026a-4e27-9fc1-4fa456a92dd8','Z0FBQUFBQnBjV2ttM1p4Mm00bW5lQ1JsMEVjVnVMNlRBUGE0Q3RsSW5lUFlsY0RBZ0FYYVRjUEFqYkZBSTBtZ3h3ZXNkM3ZjWDFSMGhSa1hka3RXa3R2WVRRNFVjUl9lb1RMZG50Z2R4OFVWVG81TWF3bjdVTjBtay0xLVNNajJhbzAzVDBGXzR1QlY=',NULL);
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
INSERT INTO `kek_data` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `plugin_name`, `kek_label`, `project_id`, `active`, `bind_completed`, `algorithm`, `bit_length`, `mode`, `plugin_meta`) VALUES ('bd7b571c-7bef-40d9-a8cc-99b63554414d','2026-01-22 00:07:02','2026-01-22 00:08:35','2026-01-22 00:08:35',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-4bee9cd6c46a408cababd9be760cc6ae-key-76266b57-a9df-4aca-8690-8eb21e0451a4','53ec41ab-09ee-4730-b250-9ed15e75ef28',1,1,'aes',128,'cbc','gAAAAABpcWoma8I937YUW8cmcYwruI8J1jKkCiyQ1GlRkBVM4qGhibuvb4fKF7oKs5Y9zFBAhLGgG9iuEXqqSIh01kdtsXmzfQdVuJYOc-DQ-f9yWb3PDh-8SS-8Ar5fi_wacs5jNcPL'),('ce13ce1e-026a-4e27-9fc1-4fa456a92dd8','2026-01-22 00:02:46','2026-01-22 00:08:08','2026-01-22 00:08:08',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-fc3cab1b1a7b4d81a2c0183f45084908-key-18d10bf5-00ef-4bc6-84c7-2387103df567','300485a8-85d0-4e81-b554-5c06031d5841',1,1,'aes',128,'cbc','gAAAAABpcWkmKLH7sfHnXSmvxYxV2CfcMwnVOS0E8LVhH8fIFEjOJxWD0RM4Gpk-yHbGByts0r-tVxdmR2ZBf_3l1zd-J1gIkvc4cz96S9Lh3fTXeM7vGrONrRah6G20anf5sVu7ZUuB');
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
INSERT INTO `orders` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `type`, `project_id`, `error_status_code`, `error_reason`, `meta`, `secret_id`, `container_id`, `sub_status`, `sub_status_message`, `creator_id`) VALUES ('54a1b916-c093-4c4f-bf03-cf8aeaffa3ab','2026-01-22 00:07:01','2026-01-22 00:07:02',NULL,0,'ACTIVE','key','53ec41ab-09ee-4730-b250-9ed15e75ef28',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','19b367bd-45f7-4f68-81d1-e2fe3c4261a2',NULL,'Unknown','Unknown','19bb72c07b004b2cbc9628e145ed9a06'),('f998caaa-3538-4340-ad4c-8f6f2fcd99f1','2026-01-22 00:02:45','2026-01-22 00:02:46',NULL,0,'ACTIVE','key','300485a8-85d0-4e81-b554-5c06031d5841',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','ee393725-9bb8-43df-9bbc-06594f158361',NULL,'Unknown','Unknown','08ab0fd4f3074df0a1ae55943c5c34e4');
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
INSERT INTO `projects` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `external_id`) VALUES ('300485a8-85d0-4e81-b554-5c06031d5841','2026-01-22 00:02:45','2026-01-22 00:08:08','2026-01-22 00:08:08',1,'ACTIVE','fc3cab1b1a7b4d81a2c0183f45084908'),('53ec41ab-09ee-4730-b250-9ed15e75ef28','2026-01-22 00:07:01','2026-01-22 00:08:35','2026-01-22 00:08:35',1,'ACTIVE','4bee9cd6c46a408cababd9be760cc6ae');
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
INSERT INTO `secret_store_metadata` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `key`, `value`, `secret_id`) VALUES ('466fed02-9d89-4693-b26b-275d252b7308','2026-01-22 00:07:02','2026-01-22 00:07:18','2026-01-22 00:07:18',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','19b367bd-45f7-4f68-81d1-e2fe3c4261a2'),('4e44acc6-79c4-483b-a6f5-a8399200ba8d','2026-01-22 00:07:02','2026-01-22 00:07:18','2026-01-22 00:07:18',1,'PENDING','content_type','application/octet-stream','19b367bd-45f7-4f68-81d1-e2fe3c4261a2'),('6422531f-3cc0-44b1-ab8d-19a00476fb45','2026-01-22 00:02:46','2026-01-22 00:07:55','2026-01-22 00:07:55',1,'PENDING','content_type','application/octet-stream','ee393725-9bb8-43df-9bbc-06594f158361'),('e880c7ea-af17-4079-9d51-f86c5fe84e12','2026-01-22 00:02:46','2026-01-22 00:07:55','2026-01-22 00:07:55',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','ee393725-9bb8-43df-9bbc-06594f158361');
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('099d9a90-21c3-47b5-8d7b-92b4407a0aaf','2026-01-21 23:10:11','2026-01-21 23:10:11',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
INSERT INTO `secrets` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `name`, `secret_type`, `expiration`, `algorithm`, `bit_length`, `mode`, `creator_id`, `project_id`) VALUES ('19b367bd-45f7-4f68-81d1-e2fe3c4261a2','2026-01-22 00:07:02','2026-01-22 00:07:18','2026-01-22 00:07:18',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'19bb72c07b004b2cbc9628e145ed9a06','53ec41ab-09ee-4730-b250-9ed15e75ef28'),('ee393725-9bb8-43df-9bbc-06594f158361','2026-01-22 00:02:46','2026-01-22 00:07:55','2026-01-22 00:07:55',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'08ab0fd4f3074df0a1ae55943c5c34e4','300485a8-85d0-4e81-b554-5c06031d5841');
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
INSERT INTO `backups` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `host`, `availability_zone`, `display_name`, `display_description`, `container`, `status`, `fail_reason`, `service_metadata`, `service`, `size`, `object_count`, `parent_id`, `temp_volume_id`, `temp_snapshot_id`, `num_dependent_backups`, `snapshot_id`, `data_timestamp`, `restore_volume_id`, `encryption_key_id`) VALUES ('2026-01-22 00:05:59','2026-01-22 00:06:21','2026-01-22 00:06:22',1,'915cdce8-bec7-4728-b4ec-7d06e11f78f1','1b53ddbf-cb53-4678-99d5-3024c177fdb2','aab8583f35614558ae6a40b50d3119df','4655fadafba24b5db7b30502b0c37b50','cinder-backup-0',NULL,'tempest-TestVolumeBackupRestore-backup-1693646049',NULL,'backups','deleted',NULL,'{\"base\": \"volume-1b53ddbf-cb53-4678-99d5-3024c177fdb2.backup.915cdce8-bec7-4728-b4ec-7d06e11f78f1\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:05:59','299c203d-11ab-455f-a2ab-440a60c73aa4',NULL);
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
INSERT INTO `encryption` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `cipher`, `control_location`, `key_size`, `provider`, `volume_type_id`, `encryption_id`) VALUES ('2026-01-22 00:02:45',NULL,'2026-01-22 00:07:56',1,'aes-xts-plain64','front-end',256,'luks','8b0d1340-f291-4657-af28-940f963260f9','700bcc3c-dcf7-4a62-8e50-cb239199af82'),('2026-01-22 00:07:01',NULL,'2026-01-22 00:07:20',1,'aes-xts-plain64','front-end',256,'luks','ea16beeb-b577-4f09-a766-a8346746350a','70befb4a-ba52-430d-93d5-ea60978bb889');
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','2598f81b-c887-4afc-82f5-e55cb537d778','2026-01-21 23:09:57','2026-01-21 23:09:57',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('2598f81b-c887-4afc-82f5-e55cb537d778','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2026-01-21 23:09:57','2026-01-21 23:09:57',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2026-01-21 23:09:54',NULL,NULL,0,1,'default','volumes',10),('2026-01-21 23:09:54',NULL,NULL,0,2,'default','snapshots',10),('2026-01-21 23:09:54',NULL,NULL,0,3,'default','gigabytes',1000),('2026-01-21 23:09:54',NULL,NULL,0,4,'default','consistencygroups',10),('2026-01-21 23:09:54',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2026-01-21 23:09:54',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=93 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `race_preventer`) VALUES ('2026-01-21 23:49:18','2026-01-21 23:49:31',NULL,0,1,'f09c3054aeb04ea296a3876ff84b6316','volumes',0,0,NULL,1),('2026-01-21 23:49:18','2026-01-21 23:49:31',NULL,0,2,'f09c3054aeb04ea296a3876ff84b6316','gigabytes',0,0,NULL,1),('2026-01-21 23:49:18','2026-01-21 23:49:31',NULL,0,3,'f09c3054aeb04ea296a3876ff84b6316','volumes___DEFAULT__',0,0,NULL,1),('2026-01-21 23:49:18','2026-01-21 23:49:31',NULL,0,4,'f09c3054aeb04ea296a3876ff84b6316','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-21 23:49:58','2026-01-21 23:50:17',NULL,0,5,'b9269179afa746c5b390503d0c04dd80','volumes',0,0,NULL,1),('2026-01-21 23:49:58','2026-01-21 23:50:17',NULL,0,6,'b9269179afa746c5b390503d0c04dd80','gigabytes',0,0,NULL,1),('2026-01-21 23:49:58','2026-01-21 23:50:17',NULL,0,7,'b9269179afa746c5b390503d0c04dd80','volumes___DEFAULT__',0,0,NULL,1),('2026-01-21 23:49:58','2026-01-21 23:50:17',NULL,0,8,'b9269179afa746c5b390503d0c04dd80','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-21 23:51:07','2026-01-21 23:51:27',NULL,0,9,'782d762725a142abb32555887d980fa1','volumes',0,0,NULL,1),('2026-01-21 23:51:07','2026-01-21 23:51:27',NULL,0,10,'782d762725a142abb32555887d980fa1','gigabytes',0,0,NULL,1),('2026-01-21 23:51:07','2026-01-21 23:51:27',NULL,0,11,'782d762725a142abb32555887d980fa1','volumes___DEFAULT__',0,0,NULL,1),('2026-01-21 23:51:07','2026-01-21 23:51:27',NULL,0,12,'782d762725a142abb32555887d980fa1','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-21 23:54:49','2026-01-21 23:55:03',NULL,0,13,'3c0b858da02441efbb8876e157eb10b4','volumes',0,0,NULL,1),('2026-01-21 23:54:49','2026-01-21 23:55:03',NULL,0,14,'3c0b858da02441efbb8876e157eb10b4','gigabytes',0,0,NULL,1),('2026-01-21 23:54:49','2026-01-21 23:55:03',NULL,0,15,'3c0b858da02441efbb8876e157eb10b4','volumes_multiattach',0,0,NULL,1),('2026-01-21 23:54:49','2026-01-21 23:55:03',NULL,0,16,'3c0b858da02441efbb8876e157eb10b4','gigabytes_multiattach',0,0,NULL,1),('2026-01-21 23:55:44','2026-01-21 23:56:29',NULL,0,17,'81d7a22e83d04172a9b390c93900a4ae','volumes',0,0,NULL,1),('2026-01-21 23:55:44','2026-01-21 23:56:29',NULL,0,18,'81d7a22e83d04172a9b390c93900a4ae','gigabytes',0,0,NULL,1),('2026-01-21 23:55:44','2026-01-21 23:56:29',NULL,0,19,'81d7a22e83d04172a9b390c93900a4ae','volumes___DEFAULT__',0,0,NULL,1),('2026-01-21 23:55:44','2026-01-21 23:56:29',NULL,0,20,'81d7a22e83d04172a9b390c93900a4ae','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-21 23:55:55','2026-01-21 23:56:39',NULL,0,21,'21775db7e3b84b63abb602ffdda5d1e4','volumes',0,0,NULL,1),('2026-01-21 23:55:55','2026-01-21 23:56:39',NULL,0,22,'21775db7e3b84b63abb602ffdda5d1e4','gigabytes',0,0,NULL,1),('2026-01-21 23:55:55','2026-01-21 23:56:39',NULL,0,23,'21775db7e3b84b63abb602ffdda5d1e4','volumes___DEFAULT__',0,0,NULL,1),('2026-01-21 23:55:55','2026-01-21 23:56:39',NULL,0,24,'21775db7e3b84b63abb602ffdda5d1e4','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-21 23:56:48','2026-01-21 23:57:00',NULL,0,25,'8c5ea42ea1864d26b26844a38a374b68','volumes',0,0,NULL,1),('2026-01-21 23:56:48','2026-01-21 23:57:00',NULL,0,26,'8c5ea42ea1864d26b26844a38a374b68','gigabytes',0,0,NULL,1),('2026-01-21 23:56:48','2026-01-21 23:57:00',NULL,0,27,'8c5ea42ea1864d26b26844a38a374b68','volumes___DEFAULT__',0,0,NULL,1),('2026-01-21 23:56:48','2026-01-21 23:57:00',NULL,0,28,'8c5ea42ea1864d26b26844a38a374b68','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-21 23:58:26','2026-01-21 23:58:45',NULL,0,29,'aa97ea95e1574468927ccc2f34c15d68','volumes',0,0,NULL,1),('2026-01-21 23:58:26','2026-01-21 23:58:45',NULL,0,30,'aa97ea95e1574468927ccc2f34c15d68','gigabytes',0,0,NULL,1),('2026-01-21 23:58:26','2026-01-21 23:58:45',NULL,0,31,'aa97ea95e1574468927ccc2f34c15d68','volumes___DEFAULT__',0,0,NULL,1),('2026-01-21 23:58:26','2026-01-21 23:58:45',NULL,0,32,'aa97ea95e1574468927ccc2f34c15d68','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-21 23:59:36','2026-01-21 23:59:50',NULL,0,33,'73ffcc946ec547e083dfcfdf46b651b4','volumes',0,0,NULL,1),('2026-01-21 23:59:36','2026-01-21 23:59:50',NULL,0,34,'73ffcc946ec547e083dfcfdf46b651b4','gigabytes',0,0,NULL,1),('2026-01-21 23:59:36','2026-01-21 23:59:50',NULL,0,35,'73ffcc946ec547e083dfcfdf46b651b4','volumes___DEFAULT__',0,0,NULL,1),('2026-01-21 23:59:36','2026-01-21 23:59:50',NULL,0,36,'73ffcc946ec547e083dfcfdf46b651b4','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-21 23:59:46','2026-01-21 23:59:57',NULL,0,37,'800b6c2954574115ad5fd60e98505ca3','volumes',0,0,NULL,1),('2026-01-21 23:59:46','2026-01-21 23:59:57',NULL,0,38,'800b6c2954574115ad5fd60e98505ca3','gigabytes',0,0,NULL,1),('2026-01-21 23:59:46','2026-01-21 23:59:57',NULL,0,39,'800b6c2954574115ad5fd60e98505ca3','volumes___DEFAULT__',0,0,NULL,1),('2026-01-21 23:59:46','2026-01-21 23:59:57',NULL,0,40,'800b6c2954574115ad5fd60e98505ca3','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-22 00:01:13','2026-01-22 00:01:19',NULL,0,41,'5e0f215651654ea9a021d1711425ddc1','volumes',0,0,NULL,1),('2026-01-22 00:01:13','2026-01-22 00:01:19',NULL,0,42,'5e0f215651654ea9a021d1711425ddc1','gigabytes',0,0,NULL,1),('2026-01-22 00:01:13','2026-01-22 00:01:19',NULL,0,43,'5e0f215651654ea9a021d1711425ddc1','volumes___DEFAULT__',0,0,NULL,1),('2026-01-22 00:01:13','2026-01-22 00:01:19',NULL,0,44,'5e0f215651654ea9a021d1711425ddc1','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-22 00:01:14','2026-01-22 00:01:17',NULL,0,45,'5e0f215651654ea9a021d1711425ddc1','snapshots',0,0,NULL,1),('2026-01-22 00:01:14','2026-01-22 00:01:17',NULL,0,46,'5e0f215651654ea9a021d1711425ddc1','snapshots___DEFAULT__',0,0,NULL,1),('2026-01-22 00:01:19','2026-01-22 00:02:14',NULL,0,47,'f7ad93b5bdd64340ac516ee93f273edf','volumes',0,0,NULL,1),('2026-01-22 00:01:19','2026-01-22 00:02:14',NULL,0,48,'f7ad93b5bdd64340ac516ee93f273edf','gigabytes',0,0,NULL,1),('2026-01-22 00:01:19','2026-01-22 00:02:14',NULL,0,49,'f7ad93b5bdd64340ac516ee93f273edf','volumes_multiattach',0,0,NULL,1),('2026-01-22 00:01:19','2026-01-22 00:02:14',NULL,0,50,'f7ad93b5bdd64340ac516ee93f273edf','gigabytes_multiattach',0,0,NULL,1),('2026-01-22 00:01:25','2026-01-22 00:01:38',NULL,0,51,'c636ee9dad5d4178ac7648a6bc112ebd','volumes',0,0,NULL,1),('2026-01-22 00:01:25','2026-01-22 00:01:38',NULL,0,52,'c636ee9dad5d4178ac7648a6bc112ebd','gigabytes',0,0,NULL,1),('2026-01-22 00:01:25','2026-01-22 00:01:38',NULL,0,53,'c636ee9dad5d4178ac7648a6bc112ebd','volumes___DEFAULT__',0,0,NULL,1),('2026-01-22 00:01:25','2026-01-22 00:01:38',NULL,0,54,'c636ee9dad5d4178ac7648a6bc112ebd','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-22 00:02:12','2026-01-22 00:03:15',NULL,0,55,'bbe0bf0f5fe14d60832efdaf845b5237','volumes',0,0,NULL,1),('2026-01-22 00:02:12','2026-01-22 00:03:15',NULL,0,56,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes',0,0,NULL,1),('2026-01-22 00:02:12','2026-01-22 00:03:16',NULL,0,57,'bbe0bf0f5fe14d60832efdaf845b5237','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1853888473-1807305321',0,0,NULL,1),('2026-01-22 00:02:12','2026-01-22 00:03:16',NULL,0,58,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1853888473-1807305321',0,0,NULL,1),('2026-01-22 00:02:13','2026-01-22 00:03:14',NULL,0,59,'bbe0bf0f5fe14d60832efdaf845b5237','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-530949306-658160424',0,0,NULL,1),('2026-01-22 00:02:13','2026-01-22 00:03:14',NULL,0,60,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-530949306-658160424',0,0,NULL,1),('2026-01-22 00:02:17','2026-01-22 00:02:58',NULL,0,61,'bbe0bf0f5fe14d60832efdaf845b5237','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-378911499-1275883078',0,0,NULL,1),('2026-01-22 00:02:17','2026-01-22 00:02:58',NULL,0,62,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-378911499-1275883078',0,0,NULL,1),('2026-01-22 00:02:46','2026-01-22 00:07:55',NULL,0,63,'fc3cab1b1a7b4d81a2c0183f45084908','volumes',0,0,NULL,1),('2026-01-22 00:02:46','2026-01-22 00:07:55',NULL,0,64,'fc3cab1b1a7b4d81a2c0183f45084908','gigabytes',0,0,NULL,1),('2026-01-22 00:02:46','2026-01-22 00:07:55',NULL,0,65,'fc3cab1b1a7b4d81a2c0183f45084908','volumes_tempest-scenario-type-luks-1960913990',0,0,NULL,1),('2026-01-22 00:02:46','2026-01-22 00:07:55',NULL,0,66,'fc3cab1b1a7b4d81a2c0183f45084908','gigabytes_tempest-scenario-type-luks-1960913990',0,0,NULL,1),('2026-01-22 00:03:06','2026-01-22 00:03:13',NULL,0,67,'b242b61b3b8d48e6a99b3b1a5818ce85','volumes',0,0,NULL,1),('2026-01-22 00:03:06','2026-01-22 00:03:13',NULL,0,68,'b242b61b3b8d48e6a99b3b1a5818ce85','gigabytes',0,0,NULL,1),('2026-01-22 00:03:06','2026-01-22 00:03:13',NULL,0,69,'b242b61b3b8d48e6a99b3b1a5818ce85','volumes___DEFAULT__',0,0,NULL,1),('2026-01-22 00:03:06','2026-01-22 00:03:13',NULL,0,70,'b242b61b3b8d48e6a99b3b1a5818ce85','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-22 00:05:09','2026-01-22 00:05:21',NULL,0,71,'389a3216514a4d6b88242b36af5ccbd7','volumes',0,0,NULL,1),('2026-01-22 00:05:09','2026-01-22 00:05:21',NULL,0,72,'389a3216514a4d6b88242b36af5ccbd7','gigabytes',0,0,NULL,1),('2026-01-22 00:05:09','2026-01-22 00:05:21',NULL,0,73,'389a3216514a4d6b88242b36af5ccbd7','volumes___DEFAULT__',0,0,NULL,1),('2026-01-22 00:05:09','2026-01-22 00:05:21',NULL,0,74,'389a3216514a4d6b88242b36af5ccbd7','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-22 00:05:52','2026-01-22 00:06:22',NULL,0,75,'4655fadafba24b5db7b30502b0c37b50','volumes',0,0,NULL,1),('2026-01-22 00:05:52','2026-01-22 00:06:22',NULL,0,76,'4655fadafba24b5db7b30502b0c37b50','gigabytes',0,0,NULL,1),('2026-01-22 00:05:52','2026-01-22 00:06:22',NULL,0,77,'4655fadafba24b5db7b30502b0c37b50','volumes___DEFAULT__',0,0,NULL,1),('2026-01-22 00:05:52','2026-01-22 00:06:22',NULL,0,78,'4655fadafba24b5db7b30502b0c37b50','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-22 00:05:59','2026-01-22 00:06:22',NULL,0,79,'4655fadafba24b5db7b30502b0c37b50','backups',0,0,NULL,1),('2026-01-22 00:05:59','2026-01-22 00:06:22',NULL,0,80,'4655fadafba24b5db7b30502b0c37b50','backup_gigabytes',0,0,NULL,1),('2026-01-22 00:07:02','2026-01-22 00:08:22',NULL,0,81,'4bee9cd6c46a408cababd9be760cc6ae','volumes',0,0,NULL,1),('2026-01-22 00:07:02','2026-01-22 00:08:22',NULL,0,82,'4bee9cd6c46a408cababd9be760cc6ae','gigabytes',0,0,NULL,1),('2026-01-22 00:07:02','2026-01-22 00:07:19',NULL,0,83,'4bee9cd6c46a408cababd9be760cc6ae','volumes_tempest-scenario-type-luks-1422391033',0,0,NULL,1),('2026-01-22 00:07:02','2026-01-22 00:07:19',NULL,0,84,'4bee9cd6c46a408cababd9be760cc6ae','gigabytes_tempest-scenario-type-luks-1422391033',0,0,NULL,1),('2026-01-22 00:07:22','2026-01-22 00:08:22',NULL,0,85,'4bee9cd6c46a408cababd9be760cc6ae','volumes___DEFAULT__',0,0,NULL,1),('2026-01-22 00:07:22','2026-01-22 00:08:22',NULL,0,86,'4bee9cd6c46a408cababd9be760cc6ae','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-22 00:07:30','2026-01-22 00:07:40',NULL,0,87,'4bee9cd6c46a408cababd9be760cc6ae','snapshots',0,0,NULL,1),('2026-01-22 00:07:30','2026-01-22 00:07:40',NULL,0,88,'4bee9cd6c46a408cababd9be760cc6ae','snapshots___DEFAULT__',0,0,NULL,1),('2026-01-22 00:14:46','2026-01-22 00:14:53',NULL,0,89,'e2f0b6c9b06543ee9aa50a06847cbf17','volumes',0,0,NULL,1),('2026-01-22 00:14:46','2026-01-22 00:14:53',NULL,0,90,'e2f0b6c9b06543ee9aa50a06847cbf17','gigabytes',0,0,NULL,1),('2026-01-22 00:14:46','2026-01-22 00:14:53',NULL,0,91,'e2f0b6c9b06543ee9aa50a06847cbf17','volumes___DEFAULT__',0,0,NULL,1),('2026-01-22 00:14:46','2026-01-22 00:14:53',NULL,0,92,'e2f0b6c9b06543ee9aa50a06847cbf17','gigabytes___DEFAULT__',0,0,NULL,1);
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=341 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `allocated_id`) VALUES ('2026-01-21 23:49:18','2026-01-21 23:49:18','2026-01-21 23:49:18',1,1,'0e1068ae-5f49-43b2-8e99-5dd48cb4d8dd',1,'f09c3054aeb04ea296a3876ff84b6316','volumes',1,'2026-01-22 23:49:18',NULL),('2026-01-21 23:49:18','2026-01-21 23:49:18','2026-01-21 23:49:18',1,2,'19d9eac3-61b8-43eb-975f-b10c7ff68bca',2,'f09c3054aeb04ea296a3876ff84b6316','gigabytes',1,'2026-01-22 23:49:18',NULL),('2026-01-21 23:49:18','2026-01-21 23:49:18','2026-01-21 23:49:18',1,3,'9d9b6cef-e714-446c-ba82-163c962f4a70',3,'f09c3054aeb04ea296a3876ff84b6316','volumes___DEFAULT__',1,'2026-01-22 23:49:18',NULL),('2026-01-21 23:49:18','2026-01-21 23:49:18','2026-01-21 23:49:18',1,4,'d7377fb6-8e3b-48e9-84a2-22319ed6ee50',4,'f09c3054aeb04ea296a3876ff84b6316','gigabytes___DEFAULT__',1,'2026-01-22 23:49:18',NULL),('2026-01-21 23:49:31','2026-01-21 23:49:31','2026-01-21 23:49:31',1,5,'09d98093-e89e-41b8-8b82-09f6939ab50b',1,'f09c3054aeb04ea296a3876ff84b6316','volumes',-1,'2026-01-22 23:49:30',NULL),('2026-01-21 23:49:31','2026-01-21 23:49:31','2026-01-21 23:49:31',1,6,'e004a60a-d701-4784-bcd8-65e9cc87e257',2,'f09c3054aeb04ea296a3876ff84b6316','gigabytes',-1,'2026-01-22 23:49:30',NULL),('2026-01-21 23:49:31','2026-01-21 23:49:31','2026-01-21 23:49:31',1,7,'8df603b2-04da-4b14-9c24-04dcabee3dbc',3,'f09c3054aeb04ea296a3876ff84b6316','volumes___DEFAULT__',-1,'2026-01-22 23:49:30',NULL),('2026-01-21 23:49:31','2026-01-21 23:49:31','2026-01-21 23:49:31',1,8,'53c35da8-7458-4b5b-a724-b956a2e08ad9',4,'f09c3054aeb04ea296a3876ff84b6316','gigabytes___DEFAULT__',-1,'2026-01-22 23:49:30',NULL),('2026-01-21 23:49:58','2026-01-21 23:49:58','2026-01-21 23:49:58',1,9,'d8e05068-3db8-4926-bc34-7c0cdea99773',5,'b9269179afa746c5b390503d0c04dd80','volumes',1,'2026-01-22 23:49:58',NULL),('2026-01-21 23:49:58','2026-01-21 23:49:58','2026-01-21 23:49:58',1,10,'f0be01a6-4ff8-4a32-973a-56855e4520be',6,'b9269179afa746c5b390503d0c04dd80','gigabytes',1,'2026-01-22 23:49:58',NULL),('2026-01-21 23:49:58','2026-01-21 23:49:58','2026-01-21 23:49:58',1,11,'531a591c-24f3-4885-a7cd-2d4e63ae4701',7,'b9269179afa746c5b390503d0c04dd80','volumes___DEFAULT__',1,'2026-01-22 23:49:58',NULL),('2026-01-21 23:49:58','2026-01-21 23:49:58','2026-01-21 23:49:58',1,12,'1a00fc45-ebc9-4f0d-a916-ecfad835d8bf',8,'b9269179afa746c5b390503d0c04dd80','gigabytes___DEFAULT__',1,'2026-01-22 23:49:58',NULL),('2026-01-21 23:50:17','2026-01-21 23:50:17','2026-01-21 23:50:17',1,13,'1c708695-0033-4470-834c-59f988ff147d',5,'b9269179afa746c5b390503d0c04dd80','volumes',-1,'2026-01-22 23:50:17',NULL),('2026-01-21 23:50:17','2026-01-21 23:50:17','2026-01-21 23:50:17',1,14,'e462c0a9-08a9-491f-a484-ab0f3fa1910b',6,'b9269179afa746c5b390503d0c04dd80','gigabytes',-1,'2026-01-22 23:50:17',NULL),('2026-01-21 23:50:17','2026-01-21 23:50:17','2026-01-21 23:50:17',1,15,'5857196e-d569-4e66-bbcd-f6bcf6a4f290',7,'b9269179afa746c5b390503d0c04dd80','volumes___DEFAULT__',-1,'2026-01-22 23:50:17',NULL),('2026-01-21 23:50:17','2026-01-21 23:50:17','2026-01-21 23:50:17',1,16,'4d558713-5ec3-4cdf-a965-e0fe41f7d887',8,'b9269179afa746c5b390503d0c04dd80','gigabytes___DEFAULT__',-1,'2026-01-22 23:50:17',NULL),('2026-01-21 23:51:07','2026-01-21 23:51:07','2026-01-21 23:51:07',1,17,'61e23e1b-7395-49db-af98-a3d9edf2fd03',9,'782d762725a142abb32555887d980fa1','volumes',1,'2026-01-22 23:51:07',NULL),('2026-01-21 23:51:07','2026-01-21 23:51:07','2026-01-21 23:51:07',1,18,'ed0efb74-3e16-43f2-9df7-c67331802798',10,'782d762725a142abb32555887d980fa1','gigabytes',1,'2026-01-22 23:51:07',NULL),('2026-01-21 23:51:07','2026-01-21 23:51:07','2026-01-21 23:51:07',1,19,'65137d52-014b-4fb1-ab32-1a66f684138b',11,'782d762725a142abb32555887d980fa1','volumes___DEFAULT__',1,'2026-01-22 23:51:07',NULL),('2026-01-21 23:51:07','2026-01-21 23:51:07','2026-01-21 23:51:07',1,20,'0a143905-90b3-4239-a5c6-1aaaf5a68a42',12,'782d762725a142abb32555887d980fa1','gigabytes___DEFAULT__',1,'2026-01-22 23:51:07',NULL),('2026-01-21 23:51:27','2026-01-21 23:51:27','2026-01-21 23:51:27',1,21,'26053171-b18d-4b16-b3e3-71734fa1be81',9,'782d762725a142abb32555887d980fa1','volumes',-1,'2026-01-22 23:51:27',NULL),('2026-01-21 23:51:27','2026-01-21 23:51:27','2026-01-21 23:51:27',1,22,'f567b1d1-9cb0-4db6-80c3-dd48b3e6fd53',10,'782d762725a142abb32555887d980fa1','gigabytes',-1,'2026-01-22 23:51:27',NULL),('2026-01-21 23:51:27','2026-01-21 23:51:27','2026-01-21 23:51:27',1,23,'952a5051-0dcd-4be4-b5d9-7a348e116430',11,'782d762725a142abb32555887d980fa1','volumes___DEFAULT__',-1,'2026-01-22 23:51:27',NULL),('2026-01-21 23:51:27','2026-01-21 23:51:27','2026-01-21 23:51:27',1,24,'5a8f7fd7-6cb1-48aa-8ec1-ca0694fe2780',12,'782d762725a142abb32555887d980fa1','gigabytes___DEFAULT__',-1,'2026-01-22 23:51:27',NULL),('2026-01-21 23:54:49','2026-01-21 23:54:49','2026-01-21 23:54:49',1,25,'43e81d91-7f54-4dc1-8c28-2895e1f606f6',13,'3c0b858da02441efbb8876e157eb10b4','volumes',1,'2026-01-22 23:54:49',NULL),('2026-01-21 23:54:49','2026-01-21 23:54:49','2026-01-21 23:54:49',1,26,'d0a9c33f-f628-4781-931e-be3d38de1332',14,'3c0b858da02441efbb8876e157eb10b4','gigabytes',1,'2026-01-22 23:54:49',NULL),('2026-01-21 23:54:49','2026-01-21 23:54:49','2026-01-21 23:54:49',1,27,'7dbce5fc-ca38-41f7-999d-3946194ad97c',15,'3c0b858da02441efbb8876e157eb10b4','volumes_multiattach',1,'2026-01-22 23:54:49',NULL),('2026-01-21 23:54:49','2026-01-21 23:54:49','2026-01-21 23:54:49',1,28,'6c0eae34-485a-4b46-847e-f7d715f8fe36',16,'3c0b858da02441efbb8876e157eb10b4','gigabytes_multiattach',1,'2026-01-22 23:54:49',NULL),('2026-01-21 23:54:51','2026-01-21 23:54:51','2026-01-21 23:54:51',1,29,'b78d53ed-d6ad-4e5e-a33e-c6b6277c525b',13,'3c0b858da02441efbb8876e157eb10b4','volumes',1,'2026-01-22 23:54:51',NULL),('2026-01-21 23:54:51','2026-01-21 23:54:51','2026-01-21 23:54:51',1,30,'d3c78b11-69d7-4b8a-9d64-7a9925577ad5',14,'3c0b858da02441efbb8876e157eb10b4','gigabytes',1,'2026-01-22 23:54:51',NULL),('2026-01-21 23:54:51','2026-01-21 23:54:51','2026-01-21 23:54:51',1,31,'04383f1c-e197-4d76-b025-0b222686c957',15,'3c0b858da02441efbb8876e157eb10b4','volumes_multiattach',1,'2026-01-22 23:54:51',NULL),('2026-01-21 23:54:51','2026-01-21 23:54:51','2026-01-21 23:54:51',1,32,'4669dc13-1a06-4fb8-b9bf-7f6164d89d46',16,'3c0b858da02441efbb8876e157eb10b4','gigabytes_multiattach',1,'2026-01-22 23:54:51',NULL),('2026-01-21 23:55:01','2026-01-21 23:55:01','2026-01-21 23:55:01',1,33,'f07b7ce4-260c-4295-8e11-c5a41d582719',13,'3c0b858da02441efbb8876e157eb10b4','volumes',-1,'2026-01-22 23:55:01',NULL),('2026-01-21 23:55:01','2026-01-21 23:55:01','2026-01-21 23:55:01',1,34,'55733b90-fe43-4774-a356-15fdf8b19c47',14,'3c0b858da02441efbb8876e157eb10b4','gigabytes',-1,'2026-01-22 23:55:01',NULL),('2026-01-21 23:55:01','2026-01-21 23:55:01','2026-01-21 23:55:01',1,35,'266e1493-2005-47d9-9c7d-1ac37e4b13f5',15,'3c0b858da02441efbb8876e157eb10b4','volumes_multiattach',-1,'2026-01-22 23:55:01',NULL),('2026-01-21 23:55:01','2026-01-21 23:55:01','2026-01-21 23:55:01',1,36,'9905dbe4-a96b-4091-8312-79b774ff57bc',16,'3c0b858da02441efbb8876e157eb10b4','gigabytes_multiattach',-1,'2026-01-22 23:55:01',NULL),('2026-01-21 23:55:03','2026-01-21 23:55:03','2026-01-21 23:55:03',1,37,'d28510d7-7e6a-43d7-9cf8-e5e3a55dbcd8',13,'3c0b858da02441efbb8876e157eb10b4','volumes',-1,'2026-01-22 23:55:03',NULL),('2026-01-21 23:55:03','2026-01-21 23:55:03','2026-01-21 23:55:03',1,38,'dc2b2eed-40d2-4848-9375-058c9bfa6f4b',14,'3c0b858da02441efbb8876e157eb10b4','gigabytes',-1,'2026-01-22 23:55:03',NULL),('2026-01-21 23:55:03','2026-01-21 23:55:03','2026-01-21 23:55:03',1,39,'f56ac9c0-db29-4445-8fad-3eb9ff2a1ba7',15,'3c0b858da02441efbb8876e157eb10b4','volumes_multiattach',-1,'2026-01-22 23:55:03',NULL),('2026-01-21 23:55:03','2026-01-21 23:55:03','2026-01-21 23:55:03',1,40,'901ad869-458e-4916-9099-7d74c5bb3795',16,'3c0b858da02441efbb8876e157eb10b4','gigabytes_multiattach',-1,'2026-01-22 23:55:03',NULL),('2026-01-21 23:55:44','2026-01-21 23:55:44','2026-01-21 23:55:44',1,41,'c65b432f-af16-4423-ae08-1930a88c7857',17,'81d7a22e83d04172a9b390c93900a4ae','volumes',1,'2026-01-22 23:55:44',NULL),('2026-01-21 23:55:44','2026-01-21 23:55:44','2026-01-21 23:55:44',1,42,'6295fcde-9c1f-4bcc-82ae-254ed197dea8',18,'81d7a22e83d04172a9b390c93900a4ae','gigabytes',1,'2026-01-22 23:55:44',NULL),('2026-01-21 23:55:44','2026-01-21 23:55:44','2026-01-21 23:55:44',1,43,'d4c3905b-bd58-48b3-92c3-426dec664632',19,'81d7a22e83d04172a9b390c93900a4ae','volumes___DEFAULT__',1,'2026-01-22 23:55:44',NULL),('2026-01-21 23:55:44','2026-01-21 23:55:44','2026-01-21 23:55:44',1,44,'8944d4b0-d198-465b-a46e-f205942d01c1',20,'81d7a22e83d04172a9b390c93900a4ae','gigabytes___DEFAULT__',1,'2026-01-22 23:55:44',NULL),('2026-01-21 23:55:53','2026-01-21 23:55:53','2026-01-21 23:55:53',1,45,'9ac66a27-7659-4f1b-8bf5-e894f8634a83',17,'81d7a22e83d04172a9b390c93900a4ae','volumes',1,'2026-01-22 23:55:53',NULL),('2026-01-21 23:55:53','2026-01-21 23:55:53','2026-01-21 23:55:53',1,46,'dc164595-175e-4685-9432-b112716663f2',18,'81d7a22e83d04172a9b390c93900a4ae','gigabytes',1,'2026-01-22 23:55:53',NULL),('2026-01-21 23:55:53','2026-01-21 23:55:53','2026-01-21 23:55:53',1,47,'f37dfa47-da43-49e0-a119-12b5573e662a',19,'81d7a22e83d04172a9b390c93900a4ae','volumes___DEFAULT__',1,'2026-01-22 23:55:53',NULL),('2026-01-21 23:55:53','2026-01-21 23:55:53','2026-01-21 23:55:53',1,48,'e4f8d8b7-8fd4-4e25-aed9-3e010fd35e04',20,'81d7a22e83d04172a9b390c93900a4ae','gigabytes___DEFAULT__',1,'2026-01-22 23:55:53',NULL),('2026-01-21 23:55:55','2026-01-21 23:55:55','2026-01-21 23:55:55',1,49,'2ef2eeee-802c-44f5-a6cd-8314d5007e79',21,'21775db7e3b84b63abb602ffdda5d1e4','volumes',1,'2026-01-22 23:55:55',NULL),('2026-01-21 23:55:55','2026-01-21 23:55:55','2026-01-21 23:55:55',1,50,'8b95f0b3-89a8-4d73-b22d-fbeefe8c992d',22,'21775db7e3b84b63abb602ffdda5d1e4','gigabytes',1,'2026-01-22 23:55:55',NULL),('2026-01-21 23:55:55','2026-01-21 23:55:55','2026-01-21 23:55:55',1,51,'da1cb3c8-c2ef-4498-926f-9f967757baf1',23,'21775db7e3b84b63abb602ffdda5d1e4','volumes___DEFAULT__',1,'2026-01-22 23:55:55',NULL),('2026-01-21 23:55:55','2026-01-21 23:55:55','2026-01-21 23:55:55',1,52,'0052f92e-d62b-45d4-a3e1-5ffd46f09a9b',24,'21775db7e3b84b63abb602ffdda5d1e4','gigabytes___DEFAULT__',1,'2026-01-22 23:55:55',NULL),('2026-01-21 23:55:55','2026-01-21 23:55:55','2026-01-21 23:55:55',1,53,'435a789c-d7cd-4450-b1e6-61a373fa3e0a',17,'81d7a22e83d04172a9b390c93900a4ae','volumes',1,'2026-01-22 23:55:55',NULL),('2026-01-21 23:55:55','2026-01-21 23:55:55','2026-01-21 23:55:55',1,54,'d6179d0e-3943-4a4b-9f14-eb43d5f2c9b0',18,'81d7a22e83d04172a9b390c93900a4ae','gigabytes',1,'2026-01-22 23:55:55',NULL),('2026-01-21 23:55:55','2026-01-21 23:55:55','2026-01-21 23:55:55',1,55,'f711d553-2e4d-4dc8-af8c-a078094b2593',19,'81d7a22e83d04172a9b390c93900a4ae','volumes___DEFAULT__',1,'2026-01-22 23:55:55',NULL),('2026-01-21 23:55:55','2026-01-21 23:55:55','2026-01-21 23:55:55',1,56,'c1622b39-ae5f-4267-9275-17db07284336',20,'81d7a22e83d04172a9b390c93900a4ae','gigabytes___DEFAULT__',1,'2026-01-22 23:55:55',NULL),('2026-01-21 23:56:04','2026-01-21 23:56:04','2026-01-21 23:56:04',1,57,'e711d50f-3a9c-434a-809f-d8994821ca0f',21,'21775db7e3b84b63abb602ffdda5d1e4','volumes',1,'2026-01-22 23:56:04',NULL),('2026-01-21 23:56:04','2026-01-21 23:56:04','2026-01-21 23:56:04',1,58,'887182fe-1426-44a3-b73a-319af3dbde2b',22,'21775db7e3b84b63abb602ffdda5d1e4','gigabytes',1,'2026-01-22 23:56:04',NULL),('2026-01-21 23:56:04','2026-01-21 23:56:04','2026-01-21 23:56:04',1,59,'f3b9d0fd-4d85-4e4a-b65f-a364a66d1413',23,'21775db7e3b84b63abb602ffdda5d1e4','volumes___DEFAULT__',1,'2026-01-22 23:56:04',NULL),('2026-01-21 23:56:04','2026-01-21 23:56:04','2026-01-21 23:56:04',1,60,'61ea3adf-f0c1-421a-899b-1efc77544234',24,'21775db7e3b84b63abb602ffdda5d1e4','gigabytes___DEFAULT__',1,'2026-01-22 23:56:04',NULL),('2026-01-21 23:56:06','2026-01-21 23:56:06','2026-01-21 23:56:06',1,61,'b7b112b7-e268-4e8d-9682-eb73e5d908da',21,'21775db7e3b84b63abb602ffdda5d1e4','volumes',1,'2026-01-22 23:56:06',NULL),('2026-01-21 23:56:06','2026-01-21 23:56:06','2026-01-21 23:56:06',1,62,'31f331d0-5b72-4283-bd15-f61939ed8440',22,'21775db7e3b84b63abb602ffdda5d1e4','gigabytes',1,'2026-01-22 23:56:06',NULL),('2026-01-21 23:56:06','2026-01-21 23:56:06','2026-01-21 23:56:06',1,63,'34ef5e69-2708-4b9a-be1d-e4f594f31e94',23,'21775db7e3b84b63abb602ffdda5d1e4','volumes___DEFAULT__',1,'2026-01-22 23:56:06',NULL),('2026-01-21 23:56:06','2026-01-21 23:56:06','2026-01-21 23:56:06',1,64,'38bd0c12-4eb5-4de2-9884-5afed269c0ce',24,'21775db7e3b84b63abb602ffdda5d1e4','gigabytes___DEFAULT__',1,'2026-01-22 23:56:06',NULL),('2026-01-21 23:56:26','2026-01-21 23:56:26','2026-01-21 23:56:26',1,65,'26cf4b07-0b0a-47a6-addf-833b7e7cbd9a',17,'81d7a22e83d04172a9b390c93900a4ae','volumes',-1,'2026-01-22 23:56:26',NULL),('2026-01-21 23:56:26','2026-01-21 23:56:26','2026-01-21 23:56:26',1,66,'22d30296-2066-406e-818b-565a1a8e5f1f',18,'81d7a22e83d04172a9b390c93900a4ae','gigabytes',-1,'2026-01-22 23:56:26',NULL),('2026-01-21 23:56:26','2026-01-21 23:56:26','2026-01-21 23:56:26',1,67,'1ba81ed8-aecc-4a4a-97c0-31debfa7723a',19,'81d7a22e83d04172a9b390c93900a4ae','volumes___DEFAULT__',-1,'2026-01-22 23:56:26',NULL),('2026-01-21 23:56:26','2026-01-21 23:56:26','2026-01-21 23:56:26',1,68,'1b80aa14-5d09-4817-8991-dd0d0bca7905',20,'81d7a22e83d04172a9b390c93900a4ae','gigabytes___DEFAULT__',-1,'2026-01-22 23:56:26',NULL),('2026-01-21 23:56:27','2026-01-21 23:56:27','2026-01-21 23:56:27',1,69,'6654a76f-8135-4759-93ef-055b239a5f8e',17,'81d7a22e83d04172a9b390c93900a4ae','volumes',-1,'2026-01-22 23:56:27',NULL),('2026-01-21 23:56:27','2026-01-21 23:56:27','2026-01-21 23:56:27',1,70,'7503dd00-c1f1-47c3-a221-8d82033530cd',18,'81d7a22e83d04172a9b390c93900a4ae','gigabytes',-1,'2026-01-22 23:56:27',NULL),('2026-01-21 23:56:27','2026-01-21 23:56:27','2026-01-21 23:56:27',1,71,'d78a2db3-284d-4d77-8c0b-09c0d06f5db6',19,'81d7a22e83d04172a9b390c93900a4ae','volumes___DEFAULT__',-1,'2026-01-22 23:56:27',NULL),('2026-01-21 23:56:27','2026-01-21 23:56:27','2026-01-21 23:56:27',1,72,'b513d985-e61d-40af-b040-ae26291cd48e',20,'81d7a22e83d04172a9b390c93900a4ae','gigabytes___DEFAULT__',-1,'2026-01-22 23:56:27',NULL),('2026-01-21 23:56:29','2026-01-21 23:56:29','2026-01-21 23:56:29',1,73,'5bb65d81-3ee2-4c2a-9d8b-a4f2771422ea',17,'81d7a22e83d04172a9b390c93900a4ae','volumes',-1,'2026-01-22 23:56:29',NULL),('2026-01-21 23:56:29','2026-01-21 23:56:29','2026-01-21 23:56:29',1,74,'6caa569a-9067-439f-8948-d86980608dd8',18,'81d7a22e83d04172a9b390c93900a4ae','gigabytes',-1,'2026-01-22 23:56:29',NULL),('2026-01-21 23:56:29','2026-01-21 23:56:29','2026-01-21 23:56:29',1,75,'de900096-e0c6-4e39-b973-d5f0f3ffdb91',19,'81d7a22e83d04172a9b390c93900a4ae','volumes___DEFAULT__',-1,'2026-01-22 23:56:29',NULL),('2026-01-21 23:56:29','2026-01-21 23:56:29','2026-01-21 23:56:29',1,76,'fe8fb9cd-bbce-4802-9a75-f04f3c063916',20,'81d7a22e83d04172a9b390c93900a4ae','gigabytes___DEFAULT__',-1,'2026-01-22 23:56:29',NULL),('2026-01-21 23:56:37','2026-01-21 23:56:37','2026-01-21 23:56:37',1,77,'c5e9008d-87a2-43dc-aa3b-92574eb24b08',21,'21775db7e3b84b63abb602ffdda5d1e4','volumes',-1,'2026-01-22 23:56:37',NULL),('2026-01-21 23:56:37','2026-01-21 23:56:37','2026-01-21 23:56:37',1,78,'0f70bbe7-fb40-4bac-b76e-f5cf8df96aa1',22,'21775db7e3b84b63abb602ffdda5d1e4','gigabytes',-1,'2026-01-22 23:56:37',NULL),('2026-01-21 23:56:37','2026-01-21 23:56:37','2026-01-21 23:56:37',1,79,'467108c7-07f4-405a-979f-375dd30278ae',23,'21775db7e3b84b63abb602ffdda5d1e4','volumes___DEFAULT__',-1,'2026-01-22 23:56:37',NULL),('2026-01-21 23:56:37','2026-01-21 23:56:37','2026-01-21 23:56:37',1,80,'63c72ecf-a3db-4542-8a11-2f8d2afcf064',24,'21775db7e3b84b63abb602ffdda5d1e4','gigabytes___DEFAULT__',-1,'2026-01-22 23:56:37',NULL),('2026-01-21 23:56:38','2026-01-21 23:56:38','2026-01-21 23:56:38',1,81,'d47a0521-2dd8-41fd-bec9-f81a963a688d',21,'21775db7e3b84b63abb602ffdda5d1e4','volumes',-1,'2026-01-22 23:56:38',NULL),('2026-01-21 23:56:38','2026-01-21 23:56:38','2026-01-21 23:56:38',1,82,'72dfeaf7-3d94-4e3b-926c-c6b6f4bdcdbd',22,'21775db7e3b84b63abb602ffdda5d1e4','gigabytes',-1,'2026-01-22 23:56:38',NULL),('2026-01-21 23:56:38','2026-01-21 23:56:38','2026-01-21 23:56:38',1,83,'ac5a5e9e-9bc2-40b5-8f8d-26a164eb735a',23,'21775db7e3b84b63abb602ffdda5d1e4','volumes___DEFAULT__',-1,'2026-01-22 23:56:38',NULL),('2026-01-21 23:56:38','2026-01-21 23:56:38','2026-01-21 23:56:38',1,84,'9ed13828-a2e5-4d86-95ce-e54a003fe7a6',24,'21775db7e3b84b63abb602ffdda5d1e4','gigabytes___DEFAULT__',-1,'2026-01-22 23:56:38',NULL),('2026-01-21 23:56:39','2026-01-21 23:56:39','2026-01-21 23:56:39',1,85,'fba7e1dd-2426-4196-9e94-ac7f9509714b',21,'21775db7e3b84b63abb602ffdda5d1e4','volumes',-1,'2026-01-22 23:56:39',NULL),('2026-01-21 23:56:39','2026-01-21 23:56:39','2026-01-21 23:56:39',1,86,'f90ab95e-25a5-401d-aa1e-9188d11c1ec5',22,'21775db7e3b84b63abb602ffdda5d1e4','gigabytes',-1,'2026-01-22 23:56:39',NULL),('2026-01-21 23:56:39','2026-01-21 23:56:39','2026-01-21 23:56:39',1,87,'3832496c-c17a-452c-9950-66685dc3fd71',23,'21775db7e3b84b63abb602ffdda5d1e4','volumes___DEFAULT__',-1,'2026-01-22 23:56:39',NULL),('2026-01-21 23:56:39','2026-01-21 23:56:39','2026-01-21 23:56:39',1,88,'3a705606-a047-42a6-9ee2-4e6d3e4f3ec7',24,'21775db7e3b84b63abb602ffdda5d1e4','gigabytes___DEFAULT__',-1,'2026-01-22 23:56:39',NULL),('2026-01-21 23:56:48','2026-01-21 23:56:48','2026-01-21 23:56:48',1,89,'ea05281c-a3b5-4f47-80f8-d868cdac2df2',25,'8c5ea42ea1864d26b26844a38a374b68','volumes',1,'2026-01-22 23:56:48',NULL),('2026-01-21 23:56:48','2026-01-21 23:56:48','2026-01-21 23:56:48',1,90,'7a6fe7db-23b6-4804-83b8-cc8c9bfe78fc',26,'8c5ea42ea1864d26b26844a38a374b68','gigabytes',1,'2026-01-22 23:56:48',NULL),('2026-01-21 23:56:48','2026-01-21 23:56:48','2026-01-21 23:56:48',1,91,'b6abee98-4f6e-4019-aa5a-b52cd37f87d8',27,'8c5ea42ea1864d26b26844a38a374b68','volumes___DEFAULT__',1,'2026-01-22 23:56:48',NULL),('2026-01-21 23:56:48','2026-01-21 23:56:48','2026-01-21 23:56:48',1,92,'1804f05c-9550-43d6-b884-b6da5b5217b2',28,'8c5ea42ea1864d26b26844a38a374b68','gigabytes___DEFAULT__',1,'2026-01-22 23:56:48',NULL),('2026-01-21 23:57:00','2026-01-21 23:57:00','2026-01-21 23:57:00',1,93,'fe3c04ca-e289-466b-a517-4ebdcfca13b4',25,'8c5ea42ea1864d26b26844a38a374b68','volumes',-1,'2026-01-22 23:57:00',NULL),('2026-01-21 23:57:00','2026-01-21 23:57:00','2026-01-21 23:57:00',1,94,'e3f863bd-ffd6-463a-bb69-b8b07b76d940',26,'8c5ea42ea1864d26b26844a38a374b68','gigabytes',-1,'2026-01-22 23:57:00',NULL),('2026-01-21 23:57:00','2026-01-21 23:57:00','2026-01-21 23:57:00',1,95,'f16d62bd-b9d5-424b-b60f-5cc73eb2f1a7',27,'8c5ea42ea1864d26b26844a38a374b68','volumes___DEFAULT__',-1,'2026-01-22 23:57:00',NULL),('2026-01-21 23:57:00','2026-01-21 23:57:00','2026-01-21 23:57:00',1,96,'1bf0fa01-5db3-448e-9428-dd0ec2c63aa2',28,'8c5ea42ea1864d26b26844a38a374b68','gigabytes___DEFAULT__',-1,'2026-01-22 23:57:00',NULL),('2026-01-21 23:58:26','2026-01-21 23:58:26','2026-01-21 23:58:26',1,97,'f19a17aa-ea6a-448b-919e-3a1f36d532d0',29,'aa97ea95e1574468927ccc2f34c15d68','volumes',1,'2026-01-22 23:58:26',NULL),('2026-01-21 23:58:26','2026-01-21 23:58:26','2026-01-21 23:58:26',1,98,'92d3d649-f73f-4992-adc7-bbede81a0abe',30,'aa97ea95e1574468927ccc2f34c15d68','gigabytes',1,'2026-01-22 23:58:26',NULL),('2026-01-21 23:58:26','2026-01-21 23:58:26','2026-01-21 23:58:26',1,99,'585a2710-1a58-4121-952a-5beed6e034a1',31,'aa97ea95e1574468927ccc2f34c15d68','volumes___DEFAULT__',1,'2026-01-22 23:58:26',NULL),('2026-01-21 23:58:26','2026-01-21 23:58:26','2026-01-21 23:58:26',1,100,'381d0aff-79e9-4191-afba-9065f28872b6',32,'aa97ea95e1574468927ccc2f34c15d68','gigabytes___DEFAULT__',1,'2026-01-22 23:58:26',NULL),('2026-01-21 23:58:45','2026-01-21 23:58:45','2026-01-21 23:58:45',1,101,'47a37d66-0164-4971-baee-bf99369b64d8',29,'aa97ea95e1574468927ccc2f34c15d68','volumes',-1,'2026-01-22 23:58:45',NULL),('2026-01-21 23:58:45','2026-01-21 23:58:45','2026-01-21 23:58:45',1,102,'1843d5ea-f12b-45c8-b943-ee3d2cefb7fa',30,'aa97ea95e1574468927ccc2f34c15d68','gigabytes',-1,'2026-01-22 23:58:45',NULL),('2026-01-21 23:58:45','2026-01-21 23:58:45','2026-01-21 23:58:45',1,103,'644914f9-1a5f-49e1-b8e9-eed033f75428',31,'aa97ea95e1574468927ccc2f34c15d68','volumes___DEFAULT__',-1,'2026-01-22 23:58:45',NULL),('2026-01-21 23:58:45','2026-01-21 23:58:45','2026-01-21 23:58:45',1,104,'7cc84ca9-354e-4a25-bb74-ded6222aa14e',32,'aa97ea95e1574468927ccc2f34c15d68','gigabytes___DEFAULT__',-1,'2026-01-22 23:58:45',NULL),('2026-01-21 23:59:36','2026-01-21 23:59:36','2026-01-21 23:59:36',1,105,'07efc11e-2073-4c28-b7f6-9b199fde7878',33,'73ffcc946ec547e083dfcfdf46b651b4','volumes',1,'2026-01-22 23:59:36',NULL),('2026-01-21 23:59:36','2026-01-21 23:59:36','2026-01-21 23:59:36',1,106,'5102a1c2-12b5-4fc1-abe7-5a7f3969f5f1',34,'73ffcc946ec547e083dfcfdf46b651b4','gigabytes',1,'2026-01-22 23:59:36',NULL),('2026-01-21 23:59:36','2026-01-21 23:59:36','2026-01-21 23:59:36',1,107,'5910586a-5021-4e6e-ae38-867d62c01b9b',35,'73ffcc946ec547e083dfcfdf46b651b4','volumes___DEFAULT__',1,'2026-01-22 23:59:36',NULL),('2026-01-21 23:59:36','2026-01-21 23:59:36','2026-01-21 23:59:36',1,108,'a1066273-8739-4c7b-b8f6-4ae6eae2c83f',36,'73ffcc946ec547e083dfcfdf46b651b4','gigabytes___DEFAULT__',1,'2026-01-22 23:59:36',NULL),('2026-01-21 23:59:46','2026-01-21 23:59:46','2026-01-21 23:59:46',1,109,'752f747f-263e-4805-872f-0485427c4049',37,'800b6c2954574115ad5fd60e98505ca3','volumes',1,'2026-01-22 23:59:46',NULL),('2026-01-21 23:59:46','2026-01-21 23:59:46','2026-01-21 23:59:46',1,110,'29609192-8965-4d4c-b165-c55ffdd45f77',38,'800b6c2954574115ad5fd60e98505ca3','gigabytes',1,'2026-01-22 23:59:46',NULL),('2026-01-21 23:59:46','2026-01-21 23:59:46','2026-01-21 23:59:46',1,111,'ef5ec829-f89d-41ac-9bf8-6b7eef71a71b',39,'800b6c2954574115ad5fd60e98505ca3','volumes___DEFAULT__',1,'2026-01-22 23:59:46',NULL),('2026-01-21 23:59:46','2026-01-21 23:59:46','2026-01-21 23:59:46',1,112,'93c61761-db92-4c19-83d9-525891f039b2',40,'800b6c2954574115ad5fd60e98505ca3','gigabytes___DEFAULT__',1,'2026-01-22 23:59:46',NULL),('2026-01-21 23:59:50','2026-01-21 23:59:50','2026-01-21 23:59:50',1,113,'2b4fc021-89f2-44ca-bb9e-16efedd4a8b3',33,'73ffcc946ec547e083dfcfdf46b651b4','volumes',-1,'2026-01-22 23:59:50',NULL),('2026-01-21 23:59:50','2026-01-21 23:59:50','2026-01-21 23:59:50',1,114,'5a7283d1-f8d7-4aa2-a120-3d14e73ca10d',34,'73ffcc946ec547e083dfcfdf46b651b4','gigabytes',-1,'2026-01-22 23:59:50',NULL),('2026-01-21 23:59:50','2026-01-21 23:59:50','2026-01-21 23:59:50',1,115,'32841430-3c77-4b01-9801-6b771ede94ff',35,'73ffcc946ec547e083dfcfdf46b651b4','volumes___DEFAULT__',-1,'2026-01-22 23:59:50',NULL),('2026-01-21 23:59:50','2026-01-21 23:59:50','2026-01-21 23:59:50',1,116,'b577729b-6cd4-4440-9cf3-ad716b2b9827',36,'73ffcc946ec547e083dfcfdf46b651b4','gigabytes___DEFAULT__',-1,'2026-01-22 23:59:50',NULL),('2026-01-21 23:59:57','2026-01-21 23:59:57','2026-01-21 23:59:57',1,117,'6d2d5a12-64ed-4cc8-9b60-9ee885da51c5',37,'800b6c2954574115ad5fd60e98505ca3','volumes',-1,'2026-01-22 23:59:57',NULL),('2026-01-21 23:59:57','2026-01-21 23:59:57','2026-01-21 23:59:57',1,118,'da9ed25d-2b5a-4bbd-9ebb-9b5355e36a07',38,'800b6c2954574115ad5fd60e98505ca3','gigabytes',-1,'2026-01-22 23:59:57',NULL),('2026-01-21 23:59:57','2026-01-21 23:59:57','2026-01-21 23:59:57',1,119,'01a9560b-02b1-4e4b-ab2f-5a23522d6648',39,'800b6c2954574115ad5fd60e98505ca3','volumes___DEFAULT__',-1,'2026-01-22 23:59:57',NULL),('2026-01-21 23:59:57','2026-01-21 23:59:57','2026-01-21 23:59:57',1,120,'8f86303c-9f34-4755-84df-1dc0b39a2785',40,'800b6c2954574115ad5fd60e98505ca3','gigabytes___DEFAULT__',-1,'2026-01-22 23:59:57',NULL),('2026-01-22 00:01:13','2026-01-22 00:01:13','2026-01-22 00:01:13',1,121,'135eb82d-43bf-447f-ae05-c483071645d5',41,'5e0f215651654ea9a021d1711425ddc1','volumes',1,'2026-01-23 00:01:13',NULL),('2026-01-22 00:01:13','2026-01-22 00:01:13','2026-01-22 00:01:13',1,122,'e706c685-3713-4df7-8b66-68a5ce660c3c',42,'5e0f215651654ea9a021d1711425ddc1','gigabytes',1,'2026-01-23 00:01:13',NULL),('2026-01-22 00:01:13','2026-01-22 00:01:13','2026-01-22 00:01:13',1,123,'2cfe7d72-f124-43b7-b46c-b7c9b49872cc',43,'5e0f215651654ea9a021d1711425ddc1','volumes___DEFAULT__',1,'2026-01-23 00:01:13',NULL),('2026-01-22 00:01:13','2026-01-22 00:01:13','2026-01-22 00:01:13',1,124,'d834f551-5f22-452e-905b-93734476bb5b',44,'5e0f215651654ea9a021d1711425ddc1','gigabytes___DEFAULT__',1,'2026-01-23 00:01:13',NULL),('2026-01-22 00:01:14','2026-01-22 00:01:14','2026-01-22 00:01:14',1,125,'99a9f662-934f-430b-8422-95a027200e11',45,'5e0f215651654ea9a021d1711425ddc1','snapshots',1,'2026-01-23 00:01:14',NULL),('2026-01-22 00:01:14','2026-01-22 00:01:14','2026-01-22 00:01:14',1,126,'6f61763d-fb32-4e55-9498-38d1e857ace0',42,'5e0f215651654ea9a021d1711425ddc1','gigabytes',1,'2026-01-23 00:01:14',NULL),('2026-01-22 00:01:14','2026-01-22 00:01:14','2026-01-22 00:01:14',1,127,'865fada7-357e-46ca-bd1e-ce30813806ef',44,'5e0f215651654ea9a021d1711425ddc1','gigabytes___DEFAULT__',1,'2026-01-23 00:01:14',NULL),('2026-01-22 00:01:14','2026-01-22 00:01:14','2026-01-22 00:01:14',1,128,'ca197fc2-c02a-4414-a80d-e2660af05a6e',46,'5e0f215651654ea9a021d1711425ddc1','snapshots___DEFAULT__',1,'2026-01-23 00:01:14',NULL),('2026-01-22 00:01:17','2026-01-22 00:01:17','2026-01-22 00:01:17',1,129,'504793a5-e9df-4555-896d-f5f66fd9190c',45,'5e0f215651654ea9a021d1711425ddc1','snapshots',-1,'2026-01-23 00:01:17',NULL),('2026-01-22 00:01:17','2026-01-22 00:01:17','2026-01-22 00:01:17',1,130,'cfc7022b-df23-4fcb-9cd3-5f15729bb934',42,'5e0f215651654ea9a021d1711425ddc1','gigabytes',-1,'2026-01-23 00:01:17',NULL),('2026-01-22 00:01:17','2026-01-22 00:01:17','2026-01-22 00:01:17',1,131,'f4d31679-194a-465b-80bf-037706bad6e8',44,'5e0f215651654ea9a021d1711425ddc1','gigabytes___DEFAULT__',-1,'2026-01-23 00:01:17',NULL),('2026-01-22 00:01:17','2026-01-22 00:01:17','2026-01-22 00:01:17',1,132,'c0bbea66-88e4-4cf4-9430-a898971e72de',46,'5e0f215651654ea9a021d1711425ddc1','snapshots___DEFAULT__',-1,'2026-01-23 00:01:17',NULL),('2026-01-22 00:01:19','2026-01-22 00:01:19','2026-01-22 00:01:19',1,133,'c40210ca-bceb-4868-90b9-63964952de18',41,'5e0f215651654ea9a021d1711425ddc1','volumes',-1,'2026-01-23 00:01:19',NULL),('2026-01-22 00:01:19','2026-01-22 00:01:19','2026-01-22 00:01:19',1,134,'f0b27f62-ec88-42ca-b77b-ecd130646664',42,'5e0f215651654ea9a021d1711425ddc1','gigabytes',-1,'2026-01-23 00:01:19',NULL),('2026-01-22 00:01:19','2026-01-22 00:01:19','2026-01-22 00:01:19',1,135,'dfdd4d18-8167-4632-8a4f-3795e7f74060',43,'5e0f215651654ea9a021d1711425ddc1','volumes___DEFAULT__',-1,'2026-01-23 00:01:19',NULL),('2026-01-22 00:01:19','2026-01-22 00:01:19','2026-01-22 00:01:19',1,136,'7f90807f-8904-4868-83f4-6e82e9a4fe29',44,'5e0f215651654ea9a021d1711425ddc1','gigabytes___DEFAULT__',-1,'2026-01-23 00:01:19',NULL),('2026-01-22 00:01:19','2026-01-22 00:01:19','2026-01-22 00:01:19',1,137,'248846dd-f244-4ecd-accf-1cfb9b0d4069',47,'f7ad93b5bdd64340ac516ee93f273edf','volumes',1,'2026-01-23 00:01:19',NULL),('2026-01-22 00:01:19','2026-01-22 00:01:19','2026-01-22 00:01:19',1,138,'9898c931-edc0-4b02-b89c-a8db39a4dbea',48,'f7ad93b5bdd64340ac516ee93f273edf','gigabytes',1,'2026-01-23 00:01:19',NULL),('2026-01-22 00:01:19','2026-01-22 00:01:20','2026-01-22 00:01:20',1,139,'d623a0c8-edbf-4444-b2a2-50c0c0bb4b2e',49,'f7ad93b5bdd64340ac516ee93f273edf','volumes_multiattach',1,'2026-01-23 00:01:19',NULL),('2026-01-22 00:01:19','2026-01-22 00:01:20','2026-01-22 00:01:20',1,140,'595c8505-abba-44e2-828d-d3d88aa54ebc',50,'f7ad93b5bdd64340ac516ee93f273edf','gigabytes_multiattach',1,'2026-01-23 00:01:19',NULL),('2026-01-22 00:01:25','2026-01-22 00:01:25','2026-01-22 00:01:25',1,141,'4c4824f8-8caa-4bbd-ac86-dca3800f09b5',51,'c636ee9dad5d4178ac7648a6bc112ebd','volumes',1,'2026-01-23 00:01:25',NULL),('2026-01-22 00:01:25','2026-01-22 00:01:25','2026-01-22 00:01:25',1,142,'7d39c58e-ef93-45d0-82a1-7c7941d60317',52,'c636ee9dad5d4178ac7648a6bc112ebd','gigabytes',1,'2026-01-23 00:01:25',NULL),('2026-01-22 00:01:25','2026-01-22 00:01:25','2026-01-22 00:01:25',1,143,'32219dd9-9888-4f93-a2f8-e953d40837f0',53,'c636ee9dad5d4178ac7648a6bc112ebd','volumes___DEFAULT__',1,'2026-01-23 00:01:25',NULL),('2026-01-22 00:01:25','2026-01-22 00:01:25','2026-01-22 00:01:25',1,144,'c8e4ccc9-6073-4a17-8085-9640b4d2aa4d',54,'c636ee9dad5d4178ac7648a6bc112ebd','gigabytes___DEFAULT__',1,'2026-01-23 00:01:25',NULL),('2026-01-22 00:01:27','2026-01-22 00:01:28','2026-01-22 00:01:28',1,145,'5bd614e1-ed0b-472c-8dae-cf3783e4df3c',51,'c636ee9dad5d4178ac7648a6bc112ebd','volumes',1,'2026-01-23 00:01:27',NULL),('2026-01-22 00:01:27','2026-01-22 00:01:28','2026-01-22 00:01:28',1,146,'7f82df5d-e1fe-4d6f-832c-a0fd2b57e7de',52,'c636ee9dad5d4178ac7648a6bc112ebd','gigabytes',1,'2026-01-23 00:01:27',NULL),('2026-01-22 00:01:27','2026-01-22 00:01:28','2026-01-22 00:01:28',1,147,'6d8f43cb-84a5-4fa7-8db4-6508a9196c59',53,'c636ee9dad5d4178ac7648a6bc112ebd','volumes___DEFAULT__',1,'2026-01-23 00:01:27',NULL),('2026-01-22 00:01:27','2026-01-22 00:01:28','2026-01-22 00:01:28',1,148,'2be291b8-95cb-4c5f-94df-5b0f529fc7af',54,'c636ee9dad5d4178ac7648a6bc112ebd','gigabytes___DEFAULT__',1,'2026-01-23 00:01:27',NULL),('2026-01-22 00:01:30','2026-01-22 00:01:30','2026-01-22 00:01:30',1,149,'c508f18e-41d7-4fc5-9bde-068f15234cf7',51,'c636ee9dad5d4178ac7648a6bc112ebd','volumes',1,'2026-01-23 00:01:30',NULL),('2026-01-22 00:01:30','2026-01-22 00:01:30','2026-01-22 00:01:30',1,150,'49f12eee-d122-4844-8137-4b2358ae1db8',52,'c636ee9dad5d4178ac7648a6bc112ebd','gigabytes',1,'2026-01-23 00:01:30',NULL),('2026-01-22 00:01:30','2026-01-22 00:01:30','2026-01-22 00:01:30',1,151,'17327f39-d6a2-4a92-a88a-1e03d827c887',53,'c636ee9dad5d4178ac7648a6bc112ebd','volumes___DEFAULT__',1,'2026-01-23 00:01:30',NULL),('2026-01-22 00:01:30','2026-01-22 00:01:30','2026-01-22 00:01:30',1,152,'7eee9c6a-0122-408a-bff0-2cb3e12507ad',54,'c636ee9dad5d4178ac7648a6bc112ebd','gigabytes___DEFAULT__',1,'2026-01-23 00:01:30',NULL),('2026-01-22 00:01:35','2026-01-22 00:01:35','2026-01-22 00:01:35',1,153,'62302c8c-bad1-408b-920b-4f01139a8cb9',51,'c636ee9dad5d4178ac7648a6bc112ebd','volumes',-1,'2026-01-23 00:01:35',NULL),('2026-01-22 00:01:35','2026-01-22 00:01:35','2026-01-22 00:01:35',1,154,'68f62f28-f8d0-4572-b8f7-c896ee86327a',52,'c636ee9dad5d4178ac7648a6bc112ebd','gigabytes',-1,'2026-01-23 00:01:35',NULL),('2026-01-22 00:01:35','2026-01-22 00:01:35','2026-01-22 00:01:35',1,155,'6deb9d24-7a3c-4e60-a1e8-d389ab5bef44',53,'c636ee9dad5d4178ac7648a6bc112ebd','volumes___DEFAULT__',-1,'2026-01-23 00:01:35',NULL),('2026-01-22 00:01:35','2026-01-22 00:01:35','2026-01-22 00:01:35',1,156,'4a1c67e7-d761-4dfb-9dcc-ae033fbb27a3',54,'c636ee9dad5d4178ac7648a6bc112ebd','gigabytes___DEFAULT__',-1,'2026-01-23 00:01:35',NULL),('2026-01-22 00:01:37','2026-01-22 00:01:37','2026-01-22 00:01:37',1,157,'d467587d-371e-4273-906f-fddf298692fa',51,'c636ee9dad5d4178ac7648a6bc112ebd','volumes',-1,'2026-01-23 00:01:37',NULL),('2026-01-22 00:01:37','2026-01-22 00:01:37','2026-01-22 00:01:37',1,158,'bacda942-c461-4c7d-b989-38a2ce08ee50',52,'c636ee9dad5d4178ac7648a6bc112ebd','gigabytes',-1,'2026-01-23 00:01:37',NULL),('2026-01-22 00:01:37','2026-01-22 00:01:37','2026-01-22 00:01:37',1,159,'a6455c19-ad67-4a6b-8533-596b14425a14',53,'c636ee9dad5d4178ac7648a6bc112ebd','volumes___DEFAULT__',-1,'2026-01-23 00:01:37',NULL),('2026-01-22 00:01:37','2026-01-22 00:01:37','2026-01-22 00:01:37',1,160,'e8f5c162-5c48-4e77-ae91-4314365b7a3d',54,'c636ee9dad5d4178ac7648a6bc112ebd','gigabytes___DEFAULT__',-1,'2026-01-23 00:01:37',NULL),('2026-01-22 00:01:38','2026-01-22 00:01:38','2026-01-22 00:01:38',1,161,'81a55c11-f801-46b2-bac2-c9e9d8318f6c',51,'c636ee9dad5d4178ac7648a6bc112ebd','volumes',-1,'2026-01-23 00:01:38',NULL),('2026-01-22 00:01:38','2026-01-22 00:01:38','2026-01-22 00:01:38',1,162,'1605e153-2a60-403d-a30c-9254819e986e',52,'c636ee9dad5d4178ac7648a6bc112ebd','gigabytes',-1,'2026-01-23 00:01:38',NULL),('2026-01-22 00:01:38','2026-01-22 00:01:38','2026-01-22 00:01:38',1,163,'3c2e4b67-1212-450d-a3ff-a7e5cdd841b7',53,'c636ee9dad5d4178ac7648a6bc112ebd','volumes___DEFAULT__',-1,'2026-01-23 00:01:38',NULL),('2026-01-22 00:01:38','2026-01-22 00:01:38','2026-01-22 00:01:38',1,164,'99800480-d2a6-43b3-b87b-45fff4b8358e',54,'c636ee9dad5d4178ac7648a6bc112ebd','gigabytes___DEFAULT__',-1,'2026-01-23 00:01:38',NULL),('2026-01-22 00:01:50','2026-01-22 00:01:50','2026-01-22 00:01:50',1,165,'17316d66-1232-426d-95e5-3ba7c3d55a15',47,'f7ad93b5bdd64340ac516ee93f273edf','volumes',1,'2026-01-23 00:01:50',NULL),('2026-01-22 00:01:50','2026-01-22 00:01:50','2026-01-22 00:01:50',1,166,'b847d24b-6d9a-42f0-bc23-473bf3c5aed8',48,'f7ad93b5bdd64340ac516ee93f273edf','gigabytes',1,'2026-01-23 00:01:50',NULL),('2026-01-22 00:01:50','2026-01-22 00:01:50','2026-01-22 00:01:50',1,167,'15429ae1-0e04-45ce-bc60-99f5fbf53ee6',49,'f7ad93b5bdd64340ac516ee93f273edf','volumes_multiattach',1,'2026-01-23 00:01:50',NULL),('2026-01-22 00:01:50','2026-01-22 00:01:50','2026-01-22 00:01:50',1,168,'784e2cba-0f8d-44f2-a388-de0041bd51d2',50,'f7ad93b5bdd64340ac516ee93f273edf','gigabytes_multiattach',1,'2026-01-23 00:01:50',NULL),('2026-01-22 00:02:09','2026-01-22 00:02:09','2026-01-22 00:02:09',1,169,'e39ee48f-44d8-43f1-a922-70648151ec58',47,'f7ad93b5bdd64340ac516ee93f273edf','volumes',-1,'2026-01-23 00:02:09',NULL),('2026-01-22 00:02:09','2026-01-22 00:02:09','2026-01-22 00:02:09',1,170,'7af91a76-c6b4-4479-adea-3649008d4047',48,'f7ad93b5bdd64340ac516ee93f273edf','gigabytes',-1,'2026-01-23 00:02:09',NULL),('2026-01-22 00:02:09','2026-01-22 00:02:09','2026-01-22 00:02:09',1,171,'0f919cb9-0d5f-49c3-a2b2-54f7fdf3e41c',49,'f7ad93b5bdd64340ac516ee93f273edf','volumes_multiattach',-1,'2026-01-23 00:02:09',NULL),('2026-01-22 00:02:09','2026-01-22 00:02:09','2026-01-22 00:02:09',1,172,'5f676381-a369-44a3-a249-53d0d9f7452f',50,'f7ad93b5bdd64340ac516ee93f273edf','gigabytes_multiattach',-1,'2026-01-23 00:02:09',NULL),('2026-01-22 00:02:12','2026-01-22 00:02:12','2026-01-22 00:02:12',1,173,'2d28b837-67bd-4a66-8f4a-fb3b20b433b0',55,'bbe0bf0f5fe14d60832efdaf845b5237','volumes',1,'2026-01-23 00:02:12',NULL),('2026-01-22 00:02:12','2026-01-22 00:02:12','2026-01-22 00:02:12',1,174,'832081c6-e9e7-45c3-85ca-0cc01b5f5b82',56,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes',1,'2026-01-23 00:02:12',NULL),('2026-01-22 00:02:12','2026-01-22 00:02:12','2026-01-22 00:02:12',1,175,'581bdcde-3b31-4015-bb13-240a9e79251d',57,'bbe0bf0f5fe14d60832efdaf845b5237','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1853888473-1807305321',1,'2026-01-23 00:02:12',NULL),('2026-01-22 00:02:12','2026-01-22 00:02:12','2026-01-22 00:02:12',1,176,'9ba8fcf9-5836-4bfe-99a5-2d9686205bc8',58,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1853888473-1807305321',1,'2026-01-23 00:02:12',NULL),('2026-01-22 00:02:13','2026-01-22 00:02:13','2026-01-22 00:02:13',1,177,'dbcc03ab-5a05-49f8-b8c0-0669c9f88964',55,'bbe0bf0f5fe14d60832efdaf845b5237','volumes',1,'2026-01-23 00:02:13',NULL),('2026-01-22 00:02:13','2026-01-22 00:02:13','2026-01-22 00:02:13',1,178,'3a1ea6a2-bce2-42a5-806f-f1b533aa5518',56,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes',1,'2026-01-23 00:02:13',NULL),('2026-01-22 00:02:13','2026-01-22 00:02:13','2026-01-22 00:02:13',1,179,'eb45b929-7892-45e4-bc2a-34187698b4ea',59,'bbe0bf0f5fe14d60832efdaf845b5237','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-530949306-658160424',1,'2026-01-23 00:02:13',NULL),('2026-01-22 00:02:13','2026-01-22 00:02:13','2026-01-22 00:02:13',1,180,'0c81aa75-05af-4480-8af3-a754ebe77994',60,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-530949306-658160424',1,'2026-01-23 00:02:13',NULL),('2026-01-22 00:02:13','2026-01-22 00:02:13','2026-01-22 00:02:13',1,181,'9d64eb21-629d-456d-81f7-265ada59c3e6',55,'bbe0bf0f5fe14d60832efdaf845b5237','volumes',1,'2026-01-23 00:02:13',NULL),('2026-01-22 00:02:13','2026-01-22 00:02:13','2026-01-22 00:02:13',1,182,'5154b80e-dc81-47af-ba75-5db21a38e823',56,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes',1,'2026-01-23 00:02:13',NULL),('2026-01-22 00:02:13','2026-01-22 00:02:13','2026-01-22 00:02:13',1,183,'fd206998-7d20-4ff2-a9f8-9f875e04207b',57,'bbe0bf0f5fe14d60832efdaf845b5237','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1853888473-1807305321',1,'2026-01-23 00:02:13',NULL),('2026-01-22 00:02:13','2026-01-22 00:02:13','2026-01-22 00:02:13',1,184,'a2b6a4eb-4688-47fe-8a12-fb14352d4b3c',58,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1853888473-1807305321',1,'2026-01-23 00:02:13',NULL),('2026-01-22 00:02:13','2026-01-22 00:02:13','2026-01-22 00:02:13',1,185,'24e597b7-e237-4dc5-997d-14d9b4cc59f9',55,'bbe0bf0f5fe14d60832efdaf845b5237','volumes',1,'2026-01-23 00:02:13',NULL),('2026-01-22 00:02:13','2026-01-22 00:02:13','2026-01-22 00:02:13',1,186,'04665c2c-cdca-4b85-94d4-7c4231948333',56,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes',1,'2026-01-23 00:02:13',NULL),('2026-01-22 00:02:13','2026-01-22 00:02:13','2026-01-22 00:02:13',1,187,'fd2b04c2-1288-4dbe-9d96-1cbb7b5fcdc4',59,'bbe0bf0f5fe14d60832efdaf845b5237','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-530949306-658160424',1,'2026-01-23 00:02:13',NULL),('2026-01-22 00:02:13','2026-01-22 00:02:13','2026-01-22 00:02:13',1,188,'1d7f8bc8-5b6f-4aaa-b5d1-e6a38df03b5f',60,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-530949306-658160424',1,'2026-01-23 00:02:13',NULL),('2026-01-22 00:02:14','2026-01-22 00:02:14','2026-01-22 00:02:14',1,189,'30560f8d-9d2d-432b-848e-05ba406dd1b2',55,'bbe0bf0f5fe14d60832efdaf845b5237','volumes',1,'2026-01-23 00:02:14',NULL),('2026-01-22 00:02:14','2026-01-22 00:02:14','2026-01-22 00:02:14',1,190,'6607b20c-9eea-47c3-b926-8a4b0009fd1c',56,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes',1,'2026-01-23 00:02:14',NULL),('2026-01-22 00:02:14','2026-01-22 00:02:14','2026-01-22 00:02:14',1,191,'84c3ca44-77b2-4043-a95f-d680ba83a3af',57,'bbe0bf0f5fe14d60832efdaf845b5237','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1853888473-1807305321',1,'2026-01-23 00:02:14',NULL),('2026-01-22 00:02:14','2026-01-22 00:02:14','2026-01-22 00:02:14',1,192,'bed58adc-1c2d-447d-9c3c-50b047e0e056',58,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1853888473-1807305321',1,'2026-01-23 00:02:14',NULL),('2026-01-22 00:02:14','2026-01-22 00:02:14','2026-01-22 00:02:14',1,193,'8af28175-8075-40ff-a299-84ce1357eede',55,'bbe0bf0f5fe14d60832efdaf845b5237','volumes',1,'2026-01-23 00:02:14',NULL),('2026-01-22 00:02:14','2026-01-22 00:02:14','2026-01-22 00:02:14',1,194,'3d8b7c93-3903-4e3e-9f17-9af59dafa2ea',56,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes',1,'2026-01-23 00:02:14',NULL),('2026-01-22 00:02:14','2026-01-22 00:02:14','2026-01-22 00:02:14',1,195,'70ea0c2d-4e7f-4a58-b3cd-27befd4d6650',59,'bbe0bf0f5fe14d60832efdaf845b5237','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-530949306-658160424',1,'2026-01-23 00:02:14',NULL),('2026-01-22 00:02:14','2026-01-22 00:02:14','2026-01-22 00:02:14',1,196,'0fa19b85-ad2c-4b3a-b9f9-e67cac33ae2e',60,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-530949306-658160424',1,'2026-01-23 00:02:14',NULL),('2026-01-22 00:02:14','2026-01-22 00:02:14','2026-01-22 00:02:14',1,197,'a4fffaa8-e08a-42f9-a775-16b27c871bf6',47,'f7ad93b5bdd64340ac516ee93f273edf','volumes',-1,'2026-01-23 00:02:14',NULL),('2026-01-22 00:02:14','2026-01-22 00:02:14','2026-01-22 00:02:14',1,198,'a6174382-9ce4-48b1-884a-bf23844bb34d',48,'f7ad93b5bdd64340ac516ee93f273edf','gigabytes',-1,'2026-01-23 00:02:14',NULL),('2026-01-22 00:02:14','2026-01-22 00:02:14','2026-01-22 00:02:14',1,199,'1489fb03-d19e-4409-895b-b84a14de6d68',49,'f7ad93b5bdd64340ac516ee93f273edf','volumes_multiattach',-1,'2026-01-23 00:02:14',NULL),('2026-01-22 00:02:14','2026-01-22 00:02:14','2026-01-22 00:02:14',1,200,'70bbda4f-1a1c-4d89-a714-f575db5cd520',50,'f7ad93b5bdd64340ac516ee93f273edf','gigabytes_multiattach',-1,'2026-01-23 00:02:14',NULL),('2026-01-22 00:02:17','2026-01-22 00:02:17','2026-01-22 00:02:17',1,201,'ca16de3a-d7a3-4109-aa84-1d2ed18a2fa7',55,'bbe0bf0f5fe14d60832efdaf845b5237','volumes',1,'2026-01-23 00:02:17',NULL),('2026-01-22 00:02:17','2026-01-22 00:02:17','2026-01-22 00:02:17',1,202,'b43b0e0c-abd7-4c47-a93a-dc9b7ea89836',56,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes',1,'2026-01-23 00:02:17',NULL),('2026-01-22 00:02:17','2026-01-22 00:02:17','2026-01-22 00:02:17',1,203,'67ab3ecb-ae7d-4560-af49-52445d4437ab',61,'bbe0bf0f5fe14d60832efdaf845b5237','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-378911499-1275883078',1,'2026-01-23 00:02:17',NULL),('2026-01-22 00:02:17','2026-01-22 00:02:17','2026-01-22 00:02:17',1,204,'77a875c5-3187-4d20-a4e0-084d7b7085ba',62,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-378911499-1275883078',1,'2026-01-23 00:02:17',NULL),('2026-01-22 00:02:19','2026-01-22 00:02:19','2026-01-22 00:02:19',1,205,'c5968d3b-a3b2-4083-a746-5f68de0b5d25',55,'bbe0bf0f5fe14d60832efdaf845b5237','volumes',1,'2026-01-23 00:02:19',NULL),('2026-01-22 00:02:19','2026-01-22 00:02:19','2026-01-22 00:02:19',1,206,'eaec4788-d69a-4691-81a9-0a9d4bb9a91c',56,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes',1,'2026-01-23 00:02:19',NULL),('2026-01-22 00:02:19','2026-01-22 00:02:19','2026-01-22 00:02:19',1,207,'3b9cc133-82c3-4a7b-90c0-bb08c8db485a',61,'bbe0bf0f5fe14d60832efdaf845b5237','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-378911499-1275883078',1,'2026-01-23 00:02:19',NULL),('2026-01-22 00:02:19','2026-01-22 00:02:19','2026-01-22 00:02:19',1,208,'3df30b18-87e5-407d-b79b-79383e8ba3e5',62,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-378911499-1275883078',1,'2026-01-23 00:02:19',NULL),('2026-01-22 00:02:22','2026-01-22 00:02:22','2026-01-22 00:02:22',1,209,'b01a1338-9ae1-45cc-9e98-59ae2b294d61',55,'bbe0bf0f5fe14d60832efdaf845b5237','volumes',1,'2026-01-23 00:02:22',NULL),('2026-01-22 00:02:22','2026-01-22 00:02:22','2026-01-22 00:02:22',1,210,'5946321c-17bc-4581-bfdd-f0810c08c9a1',56,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes',1,'2026-01-23 00:02:22',NULL),('2026-01-22 00:02:22','2026-01-22 00:02:22','2026-01-22 00:02:22',1,211,'5fdc8f34-1ca6-4dfe-b86d-eda9b3f6ec1c',61,'bbe0bf0f5fe14d60832efdaf845b5237','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-378911499-1275883078',1,'2026-01-23 00:02:22',NULL),('2026-01-22 00:02:22','2026-01-22 00:02:22','2026-01-22 00:02:22',1,212,'51d56fc3-544a-4c5c-8193-e9727210d2c2',62,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-378911499-1275883078',1,'2026-01-23 00:02:22',NULL),('2026-01-22 00:02:46','2026-01-22 00:02:46','2026-01-22 00:02:46',1,213,'9838bb93-d727-4885-8bbf-cae34ac22748',63,'fc3cab1b1a7b4d81a2c0183f45084908','volumes',1,'2026-01-23 00:02:46',NULL),('2026-01-22 00:02:46','2026-01-22 00:02:46','2026-01-22 00:02:46',1,214,'6e2e18e0-f3b9-41ed-8174-9d8ebbd62e35',64,'fc3cab1b1a7b4d81a2c0183f45084908','gigabytes',1,'2026-01-23 00:02:46',NULL),('2026-01-22 00:02:46','2026-01-22 00:02:46','2026-01-22 00:02:46',1,215,'d5a9edf5-31dd-439b-802e-8bd3e818d2db',65,'fc3cab1b1a7b4d81a2c0183f45084908','volumes_tempest-scenario-type-luks-1960913990',1,'2026-01-23 00:02:46',NULL),('2026-01-22 00:02:46','2026-01-22 00:02:46','2026-01-22 00:02:46',1,216,'2adcf208-1605-409a-ae24-9b8e584fe276',66,'fc3cab1b1a7b4d81a2c0183f45084908','gigabytes_tempest-scenario-type-luks-1960913990',1,'2026-01-23 00:02:46',NULL),('2026-01-22 00:02:50','2026-01-22 00:02:50','2026-01-22 00:02:50',1,217,'52fc1295-4260-45f2-9eab-824150682944',55,'bbe0bf0f5fe14d60832efdaf845b5237','volumes',-1,'2026-01-23 00:02:50',NULL),('2026-01-22 00:02:50','2026-01-22 00:02:50','2026-01-22 00:02:50',1,218,'6126024d-97a9-43c6-ae68-6516e51d3b6b',56,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes',-1,'2026-01-23 00:02:50',NULL),('2026-01-22 00:02:50','2026-01-22 00:02:50','2026-01-22 00:02:50',1,219,'8fcba234-188c-4268-a1f8-893c7b61a3ac',61,'bbe0bf0f5fe14d60832efdaf845b5237','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-378911499-1275883078',-1,'2026-01-23 00:02:50',NULL),('2026-01-22 00:02:50','2026-01-22 00:02:50','2026-01-22 00:02:50',1,220,'d1df5851-6108-437a-960b-09b5fbe6f980',62,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-378911499-1275883078',-1,'2026-01-23 00:02:50',NULL),('2026-01-22 00:02:53','2026-01-22 00:02:53','2026-01-22 00:02:53',1,221,'88f910c2-b0da-4e0b-bf79-7aad28b94ba0',55,'bbe0bf0f5fe14d60832efdaf845b5237','volumes',-1,'2026-01-23 00:02:53',NULL),('2026-01-22 00:02:53','2026-01-22 00:02:53','2026-01-22 00:02:53',1,222,'287e4973-59b3-4d79-8988-e9e2fe33e01b',56,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes',-1,'2026-01-23 00:02:53',NULL),('2026-01-22 00:02:53','2026-01-22 00:02:53','2026-01-22 00:02:53',1,223,'0378580f-6422-4fa7-8004-793479c33075',61,'bbe0bf0f5fe14d60832efdaf845b5237','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-378911499-1275883078',-1,'2026-01-23 00:02:53',NULL),('2026-01-22 00:02:53','2026-01-22 00:02:53','2026-01-22 00:02:53',1,224,'d84b43cb-5246-46c7-9b40-7403e2539675',62,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-378911499-1275883078',-1,'2026-01-23 00:02:53',NULL),('2026-01-22 00:02:58','2026-01-22 00:02:58','2026-01-22 00:02:58',1,225,'8ac8eac4-38b2-49cd-a499-a9ccb5f334c1',55,'bbe0bf0f5fe14d60832efdaf845b5237','volumes',-1,'2026-01-23 00:02:58',NULL),('2026-01-22 00:02:58','2026-01-22 00:02:58','2026-01-22 00:02:58',1,226,'ff75682e-75a9-4dae-9ace-8a7907aa6ea1',56,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes',-1,'2026-01-23 00:02:58',NULL),('2026-01-22 00:02:58','2026-01-22 00:02:58','2026-01-22 00:02:58',1,227,'8a75524b-49dc-4bd4-9e68-b1df05b9aa8c',61,'bbe0bf0f5fe14d60832efdaf845b5237','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-378911499-1275883078',-1,'2026-01-23 00:02:58',NULL),('2026-01-22 00:02:58','2026-01-22 00:02:58','2026-01-22 00:02:58',1,228,'77015910-8b17-4738-819f-d7dbf80d54ff',62,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-378911499-1275883078',-1,'2026-01-23 00:02:58',NULL),('2026-01-22 00:03:02','2026-01-22 00:03:02','2026-01-22 00:03:02',1,229,'e37449da-d3cc-4209-89bd-08e2a2a24502',55,'bbe0bf0f5fe14d60832efdaf845b5237','volumes',-1,'2026-01-23 00:03:02',NULL),('2026-01-22 00:03:02','2026-01-22 00:03:02','2026-01-22 00:03:02',1,230,'f0658bf1-0031-4e03-9e47-ddc21abd9d27',56,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes',-1,'2026-01-23 00:03:02',NULL),('2026-01-22 00:03:02','2026-01-22 00:03:02','2026-01-22 00:03:02',1,231,'34b76c3f-8375-49ed-91c2-5a00a04353ff',59,'bbe0bf0f5fe14d60832efdaf845b5237','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-530949306-658160424',-1,'2026-01-23 00:03:02',NULL),('2026-01-22 00:03:02','2026-01-22 00:03:02','2026-01-22 00:03:02',1,232,'995d933a-95a3-4503-b7ef-3d28ea16a7ea',60,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-530949306-658160424',-1,'2026-01-23 00:03:02',NULL),('2026-01-22 00:03:05','2026-01-22 00:03:05','2026-01-22 00:03:05',1,233,'646e06e8-45b6-4409-9e63-e1ceb27560fa',55,'bbe0bf0f5fe14d60832efdaf845b5237','volumes',-1,'2026-01-23 00:03:05',NULL),('2026-01-22 00:03:05','2026-01-22 00:03:05','2026-01-22 00:03:05',1,234,'74ec6a6f-37fa-43db-ac45-9d27cc03cd8a',56,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes',-1,'2026-01-23 00:03:05',NULL),('2026-01-22 00:03:05','2026-01-22 00:03:05','2026-01-22 00:03:05',1,235,'a14945d5-8839-4759-b633-cb9389826f32',57,'bbe0bf0f5fe14d60832efdaf845b5237','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1853888473-1807305321',-1,'2026-01-23 00:03:05',NULL),('2026-01-22 00:03:05','2026-01-22 00:03:05','2026-01-22 00:03:05',1,236,'4f5d25af-3d79-4a0d-80d8-419a498e27d1',58,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1853888473-1807305321',-1,'2026-01-23 00:03:05',NULL),('2026-01-22 00:03:06','2026-01-22 00:03:07','2026-01-22 00:03:07',1,237,'2d4296bc-9502-4bee-a2b7-3be867a185b7',67,'b242b61b3b8d48e6a99b3b1a5818ce85','volumes',1,'2026-01-23 00:03:06',NULL),('2026-01-22 00:03:06','2026-01-22 00:03:07','2026-01-22 00:03:07',1,238,'0976c331-19f7-4a6a-b7eb-fdc8e27a6f72',68,'b242b61b3b8d48e6a99b3b1a5818ce85','gigabytes',1,'2026-01-23 00:03:06',NULL),('2026-01-22 00:03:07','2026-01-22 00:03:07','2026-01-22 00:03:07',1,239,'baf0f638-5106-4561-a2ec-870668514d65',69,'b242b61b3b8d48e6a99b3b1a5818ce85','volumes___DEFAULT__',1,'2026-01-23 00:03:06',NULL),('2026-01-22 00:03:07','2026-01-22 00:03:07','2026-01-22 00:03:07',1,240,'859f55b2-7261-45f9-9b3f-296b3180bcec',70,'b242b61b3b8d48e6a99b3b1a5818ce85','gigabytes___DEFAULT__',1,'2026-01-23 00:03:06',NULL),('2026-01-22 00:03:07','2026-01-22 00:03:07','2026-01-22 00:03:07',1,241,'36ad8949-20a5-4962-a158-1669c09ae51e',55,'bbe0bf0f5fe14d60832efdaf845b5237','volumes',-1,'2026-01-23 00:03:07',NULL),('2026-01-22 00:03:07','2026-01-22 00:03:07','2026-01-22 00:03:07',1,242,'dd02fd38-13a3-42da-8e21-7a1309b04936',56,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes',-1,'2026-01-23 00:03:07',NULL),('2026-01-22 00:03:07','2026-01-22 00:03:07','2026-01-22 00:03:07',1,243,'e8497f0e-0845-4f1d-93b7-4a30102b51b6',59,'bbe0bf0f5fe14d60832efdaf845b5237','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-530949306-658160424',-1,'2026-01-23 00:03:07',NULL),('2026-01-22 00:03:07','2026-01-22 00:03:07','2026-01-22 00:03:07',1,244,'c05bd60c-b293-456b-b440-18abab1a0f59',60,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-530949306-658160424',-1,'2026-01-23 00:03:07',NULL),('2026-01-22 00:03:12','2026-01-22 00:03:12','2026-01-22 00:03:12',1,245,'8399c69c-def2-4989-a693-27b4374b8fbf',55,'bbe0bf0f5fe14d60832efdaf845b5237','volumes',-1,'2026-01-23 00:03:12',NULL),('2026-01-22 00:03:12','2026-01-22 00:03:12','2026-01-22 00:03:12',1,246,'839a5394-b232-4cf6-b3d3-fb00f2983f76',56,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes',-1,'2026-01-23 00:03:12',NULL),('2026-01-22 00:03:12','2026-01-22 00:03:12','2026-01-22 00:03:12',1,247,'9f34f3d8-4372-4a02-af3a-8186a8720b6c',57,'bbe0bf0f5fe14d60832efdaf845b5237','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1853888473-1807305321',-1,'2026-01-23 00:03:12',NULL),('2026-01-22 00:03:12','2026-01-22 00:03:12','2026-01-22 00:03:12',1,248,'423ca99f-1ba2-46aa-bb38-47fc38205a81',58,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1853888473-1807305321',-1,'2026-01-23 00:03:12',NULL),('2026-01-22 00:03:13','2026-01-22 00:03:13','2026-01-22 00:03:13',1,249,'0815201d-85e1-4684-9c21-12c843ab81cd',67,'b242b61b3b8d48e6a99b3b1a5818ce85','volumes',-1,'2026-01-23 00:03:13',NULL),('2026-01-22 00:03:13','2026-01-22 00:03:13','2026-01-22 00:03:13',1,250,'a6023d15-07fe-4a62-9419-ad00aadae072',68,'b242b61b3b8d48e6a99b3b1a5818ce85','gigabytes',-1,'2026-01-23 00:03:13',NULL),('2026-01-22 00:03:13','2026-01-22 00:03:13','2026-01-22 00:03:13',1,251,'8c407b62-976c-433c-9259-6449c6fd7a48',69,'b242b61b3b8d48e6a99b3b1a5818ce85','volumes___DEFAULT__',-1,'2026-01-23 00:03:13',NULL),('2026-01-22 00:03:13','2026-01-22 00:03:13','2026-01-22 00:03:13',1,252,'892538fb-cc54-4097-957d-c1c316ce90f8',70,'b242b61b3b8d48e6a99b3b1a5818ce85','gigabytes___DEFAULT__',-1,'2026-01-23 00:03:13',NULL),('2026-01-22 00:03:14','2026-01-22 00:03:14','2026-01-22 00:03:14',1,253,'bbfb410b-ed36-4bcf-b603-e53b2c055875',55,'bbe0bf0f5fe14d60832efdaf845b5237','volumes',-1,'2026-01-23 00:03:14',NULL),('2026-01-22 00:03:14','2026-01-22 00:03:14','2026-01-22 00:03:14',1,254,'b6e81671-df6c-4581-a363-a408a965689b',56,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes',-1,'2026-01-23 00:03:14',NULL),('2026-01-22 00:03:14','2026-01-22 00:03:14','2026-01-22 00:03:14',1,255,'fd810d91-da91-44a9-8f09-e5f2a324fe80',59,'bbe0bf0f5fe14d60832efdaf845b5237','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-530949306-658160424',-1,'2026-01-23 00:03:14',NULL),('2026-01-22 00:03:14','2026-01-22 00:03:14','2026-01-22 00:03:14',1,256,'a72a6d3e-1b7d-4f07-a1d6-904c1a83c564',60,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-530949306-658160424',-1,'2026-01-23 00:03:14',NULL),('2026-01-22 00:03:15','2026-01-22 00:03:15','2026-01-22 00:03:15',1,257,'058d2311-698e-4f8c-80c0-2da0a4aa6cb0',55,'bbe0bf0f5fe14d60832efdaf845b5237','volumes',-1,'2026-01-23 00:03:15',NULL),('2026-01-22 00:03:15','2026-01-22 00:03:15','2026-01-22 00:03:15',1,258,'86ffa555-1432-415b-b6b5-5177dd1a8e36',56,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes',-1,'2026-01-23 00:03:15',NULL),('2026-01-22 00:03:15','2026-01-22 00:03:16','2026-01-22 00:03:16',1,259,'37f493cf-36e8-4ded-878e-98fb0941d7e5',57,'bbe0bf0f5fe14d60832efdaf845b5237','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1853888473-1807305321',-1,'2026-01-23 00:03:15',NULL),('2026-01-22 00:03:15','2026-01-22 00:03:16','2026-01-22 00:03:16',1,260,'b6d9b86b-235e-4a16-a8f2-cab487ab16c3',58,'bbe0bf0f5fe14d60832efdaf845b5237','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1853888473-1807305321',-1,'2026-01-23 00:03:15',NULL),('2026-01-22 00:05:09','2026-01-22 00:05:09','2026-01-22 00:05:09',1,261,'c57869e8-a9ca-4aaa-89b4-f02a1296d4b9',71,'389a3216514a4d6b88242b36af5ccbd7','volumes',1,'2026-01-23 00:05:09',NULL),('2026-01-22 00:05:09','2026-01-22 00:05:09','2026-01-22 00:05:09',1,262,'7af18887-bf88-4442-a4d1-6273534605ad',72,'389a3216514a4d6b88242b36af5ccbd7','gigabytes',1,'2026-01-23 00:05:09',NULL),('2026-01-22 00:05:09','2026-01-22 00:05:09','2026-01-22 00:05:09',1,263,'f5e4fd76-dd6a-4675-aa8c-6490669a7aa1',73,'389a3216514a4d6b88242b36af5ccbd7','volumes___DEFAULT__',1,'2026-01-23 00:05:09',NULL),('2026-01-22 00:05:09','2026-01-22 00:05:09','2026-01-22 00:05:09',1,264,'55f08081-8e3d-48f2-9414-58f74c98f52d',74,'389a3216514a4d6b88242b36af5ccbd7','gigabytes___DEFAULT__',1,'2026-01-23 00:05:09',NULL),('2026-01-22 00:05:21','2026-01-22 00:05:21','2026-01-22 00:05:21',1,265,'5844cba7-8749-4d63-8666-7d9c7e15b527',71,'389a3216514a4d6b88242b36af5ccbd7','volumes',-1,'2026-01-23 00:05:21',NULL),('2026-01-22 00:05:21','2026-01-22 00:05:21','2026-01-22 00:05:21',1,266,'0cd60612-7c73-41e5-b1a6-0f19252423f5',72,'389a3216514a4d6b88242b36af5ccbd7','gigabytes',-1,'2026-01-23 00:05:21',NULL),('2026-01-22 00:05:21','2026-01-22 00:05:21','2026-01-22 00:05:21',1,267,'5b4f6f0b-c7c6-455f-81aa-92b2b26693f8',73,'389a3216514a4d6b88242b36af5ccbd7','volumes___DEFAULT__',-1,'2026-01-23 00:05:21',NULL),('2026-01-22 00:05:21','2026-01-22 00:05:21','2026-01-22 00:05:21',1,268,'4ad46b9a-4689-4334-8cf4-02823b72d618',74,'389a3216514a4d6b88242b36af5ccbd7','gigabytes___DEFAULT__',-1,'2026-01-23 00:05:21',NULL),('2026-01-22 00:05:52','2026-01-22 00:05:52','2026-01-22 00:05:52',1,269,'f721341e-99b9-440d-a3d8-dffe747b8d13',75,'4655fadafba24b5db7b30502b0c37b50','volumes',1,'2026-01-23 00:05:52',NULL),('2026-01-22 00:05:52','2026-01-22 00:05:52','2026-01-22 00:05:52',1,270,'355b43d1-e5ad-4777-83af-f9ffa478ab46',76,'4655fadafba24b5db7b30502b0c37b50','gigabytes',1,'2026-01-23 00:05:52',NULL),('2026-01-22 00:05:52','2026-01-22 00:05:52','2026-01-22 00:05:52',1,271,'3faead61-578e-4d84-a818-939abc80c354',77,'4655fadafba24b5db7b30502b0c37b50','volumes___DEFAULT__',1,'2026-01-23 00:05:52',NULL),('2026-01-22 00:05:52','2026-01-22 00:05:52','2026-01-22 00:05:52',1,272,'c5d324ab-3c08-42d4-a66b-583bacc853a0',78,'4655fadafba24b5db7b30502b0c37b50','gigabytes___DEFAULT__',1,'2026-01-23 00:05:52',NULL),('2026-01-22 00:05:59','2026-01-22 00:05:59','2026-01-22 00:05:59',1,273,'7c0de839-d7a9-4ec8-ae33-f734f2a6abac',79,'4655fadafba24b5db7b30502b0c37b50','backups',1,'2026-01-23 00:05:59',NULL),('2026-01-22 00:05:59','2026-01-22 00:05:59','2026-01-22 00:05:59',1,274,'33833305-6f33-459f-a868-9087f1be6741',80,'4655fadafba24b5db7b30502b0c37b50','backup_gigabytes',1,'2026-01-23 00:05:59',NULL),('2026-01-22 00:06:06','2026-01-22 00:06:06','2026-01-22 00:06:06',1,275,'fe307f64-0d2f-4900-b323-efca21ab0df0',75,'4655fadafba24b5db7b30502b0c37b50','volumes',1,'2026-01-23 00:06:06',NULL),('2026-01-22 00:06:06','2026-01-22 00:06:06','2026-01-22 00:06:06',1,276,'2bc6780b-f472-483c-aeee-6aada4d6a91c',76,'4655fadafba24b5db7b30502b0c37b50','gigabytes',1,'2026-01-23 00:06:06',NULL),('2026-01-22 00:06:06','2026-01-22 00:06:06','2026-01-22 00:06:06',1,277,'6ab17921-87cb-43d6-b728-e0cb8c2fa363',77,'4655fadafba24b5db7b30502b0c37b50','volumes___DEFAULT__',1,'2026-01-23 00:06:06',NULL),('2026-01-22 00:06:06','2026-01-22 00:06:06','2026-01-22 00:06:06',1,278,'79185bc6-8786-415e-8aa7-72186106a1b9',78,'4655fadafba24b5db7b30502b0c37b50','gigabytes___DEFAULT__',1,'2026-01-23 00:06:06',NULL),('2026-01-22 00:06:22','2026-01-22 00:06:22','2026-01-22 00:06:22',1,279,'c468bb8b-67fc-4b77-a4bb-f5ac1046d6a1',79,'4655fadafba24b5db7b30502b0c37b50','backups',-1,'2026-01-23 00:06:22',NULL),('2026-01-22 00:06:22','2026-01-22 00:06:22','2026-01-22 00:06:22',1,280,'462fd5ed-3266-4512-adc1-ce926774e72e',80,'4655fadafba24b5db7b30502b0c37b50','backup_gigabytes',-1,'2026-01-23 00:06:22',NULL),('2026-01-22 00:06:22','2026-01-22 00:06:22','2026-01-22 00:06:22',1,281,'e9ab42ec-9132-42f6-9ffa-02cd56cbed20',75,'4655fadafba24b5db7b30502b0c37b50','volumes',-1,'2026-01-23 00:06:22',NULL),('2026-01-22 00:06:22','2026-01-22 00:06:22','2026-01-22 00:06:22',1,282,'26d54a88-3b55-42c8-ac3c-2269e6fef118',76,'4655fadafba24b5db7b30502b0c37b50','gigabytes',-1,'2026-01-23 00:06:22',NULL),('2026-01-22 00:06:22','2026-01-22 00:06:22','2026-01-22 00:06:22',1,283,'4959611e-cfee-441b-a7b0-3574041a2a5a',77,'4655fadafba24b5db7b30502b0c37b50','volumes___DEFAULT__',-1,'2026-01-23 00:06:22',NULL),('2026-01-22 00:06:22','2026-01-22 00:06:22','2026-01-22 00:06:22',1,284,'1e82b9e0-eb0d-4276-9952-2e29d28cb6f0',78,'4655fadafba24b5db7b30502b0c37b50','gigabytes___DEFAULT__',-1,'2026-01-23 00:06:22',NULL),('2026-01-22 00:06:22','2026-01-22 00:06:22','2026-01-22 00:06:22',1,285,'6e7b97d3-fafb-4f6b-9d80-afd4d24bf2bd',75,'4655fadafba24b5db7b30502b0c37b50','volumes',-1,'2026-01-23 00:06:22',NULL),('2026-01-22 00:06:22','2026-01-22 00:06:22','2026-01-22 00:06:22',1,286,'359b2891-8166-460f-b96f-d9641c3b914c',76,'4655fadafba24b5db7b30502b0c37b50','gigabytes',-1,'2026-01-23 00:06:22',NULL),('2026-01-22 00:06:22','2026-01-22 00:06:22','2026-01-22 00:06:22',1,287,'ac621aab-c339-4568-ba55-3f085b7d0618',77,'4655fadafba24b5db7b30502b0c37b50','volumes___DEFAULT__',-1,'2026-01-23 00:06:22',NULL),('2026-01-22 00:06:22','2026-01-22 00:06:22','2026-01-22 00:06:22',1,288,'0d1e4c2a-d478-49da-a96e-30c39c42342f',78,'4655fadafba24b5db7b30502b0c37b50','gigabytes___DEFAULT__',-1,'2026-01-23 00:06:22',NULL),('2026-01-22 00:07:03','2026-01-22 00:07:03','2026-01-22 00:07:03',1,289,'b9dbd69e-86de-48c0-9721-58a7604c061f',81,'4bee9cd6c46a408cababd9be760cc6ae','volumes',1,'2026-01-23 00:07:02',NULL),('2026-01-22 00:07:03','2026-01-22 00:07:03','2026-01-22 00:07:03',1,290,'23c5ccdd-1ccc-490b-8ec6-895042fba5bb',82,'4bee9cd6c46a408cababd9be760cc6ae','gigabytes',1,'2026-01-23 00:07:02',NULL),('2026-01-22 00:07:03','2026-01-22 00:07:03','2026-01-22 00:07:03',1,291,'a6cc8370-c553-431c-8864-ee7ba905e644',83,'4bee9cd6c46a408cababd9be760cc6ae','volumes_tempest-scenario-type-luks-1422391033',1,'2026-01-23 00:07:02',NULL),('2026-01-22 00:07:03','2026-01-22 00:07:03','2026-01-22 00:07:03',1,292,'c721680a-ae85-44f4-8c47-c3ad816e60aa',84,'4bee9cd6c46a408cababd9be760cc6ae','gigabytes_tempest-scenario-type-luks-1422391033',1,'2026-01-23 00:07:02',NULL),('2026-01-22 00:07:19','2026-01-22 00:07:19','2026-01-22 00:07:19',1,293,'3658d6df-41f6-4be6-8027-813186b0928d',81,'4bee9cd6c46a408cababd9be760cc6ae','volumes',-1,'2026-01-23 00:07:19',NULL),('2026-01-22 00:07:19','2026-01-22 00:07:19','2026-01-22 00:07:19',1,294,'2ac1d265-c771-4745-b36f-00b9d75cbc28',82,'4bee9cd6c46a408cababd9be760cc6ae','gigabytes',-1,'2026-01-23 00:07:19',NULL),('2026-01-22 00:07:19','2026-01-22 00:07:19','2026-01-22 00:07:19',1,295,'2a57237b-f079-456b-953c-b788fab49ee8',83,'4bee9cd6c46a408cababd9be760cc6ae','volumes_tempest-scenario-type-luks-1422391033',-1,'2026-01-23 00:07:19',NULL),('2026-01-22 00:07:19','2026-01-22 00:07:19','2026-01-22 00:07:19',1,296,'bb052e59-f816-4a90-88a4-2a426ded994b',84,'4bee9cd6c46a408cababd9be760cc6ae','gigabytes_tempest-scenario-type-luks-1422391033',-1,'2026-01-23 00:07:19',NULL),('2026-01-22 00:07:22','2026-01-22 00:07:22','2026-01-22 00:07:22',1,297,'2a6da2de-5d74-4ac8-99ba-4eabff268817',81,'4bee9cd6c46a408cababd9be760cc6ae','volumes',1,'2026-01-23 00:07:22',NULL),('2026-01-22 00:07:22','2026-01-22 00:07:22','2026-01-22 00:07:22',1,298,'932c6a46-7699-4eb8-9080-901211562996',82,'4bee9cd6c46a408cababd9be760cc6ae','gigabytes',1,'2026-01-23 00:07:22',NULL),('2026-01-22 00:07:22','2026-01-22 00:07:22','2026-01-22 00:07:22',1,299,'5d16362a-3d0c-4b76-8e62-2aa96dbcc3cd',85,'4bee9cd6c46a408cababd9be760cc6ae','volumes___DEFAULT__',1,'2026-01-23 00:07:22',NULL),('2026-01-22 00:07:22','2026-01-22 00:07:22','2026-01-22 00:07:22',1,300,'3a1e46ec-e598-4f36-a47b-d980a04fe26c',86,'4bee9cd6c46a408cababd9be760cc6ae','gigabytes___DEFAULT__',1,'2026-01-23 00:07:22',NULL),('2026-01-22 00:07:30','2026-01-22 00:07:30','2026-01-22 00:07:30',1,301,'09dd3387-c1cd-4af4-b8c9-3ef74ee04e0a',87,'4bee9cd6c46a408cababd9be760cc6ae','snapshots',1,'2026-01-23 00:07:30',NULL),('2026-01-22 00:07:30','2026-01-22 00:07:30','2026-01-22 00:07:30',1,302,'1945b5de-7c00-4605-8286-53784a9551c4',82,'4bee9cd6c46a408cababd9be760cc6ae','gigabytes',1,'2026-01-23 00:07:30',NULL),('2026-01-22 00:07:30','2026-01-22 00:07:30','2026-01-22 00:07:30',1,303,'65966ca2-c570-47bc-b00b-59b40cfe48c6',86,'4bee9cd6c46a408cababd9be760cc6ae','gigabytes___DEFAULT__',1,'2026-01-23 00:07:30',NULL),('2026-01-22 00:07:30','2026-01-22 00:07:30','2026-01-22 00:07:30',1,304,'a4f80649-805b-45b8-b47e-df434358e690',88,'4bee9cd6c46a408cababd9be760cc6ae','snapshots___DEFAULT__',1,'2026-01-23 00:07:30',NULL),('2026-01-22 00:07:40','2026-01-22 00:07:40','2026-01-22 00:07:40',1,305,'a2cb4fe1-a2f9-4dc0-90ff-e6b72e71f269',87,'4bee9cd6c46a408cababd9be760cc6ae','snapshots',-1,'2026-01-23 00:07:40',NULL),('2026-01-22 00:07:40','2026-01-22 00:07:40','2026-01-22 00:07:40',1,306,'651ac971-4e62-43d5-85d1-b7437307f6cc',82,'4bee9cd6c46a408cababd9be760cc6ae','gigabytes',-1,'2026-01-23 00:07:40',NULL),('2026-01-22 00:07:40','2026-01-22 00:07:40','2026-01-22 00:07:40',1,307,'352cb831-c832-455b-a95e-4b253000af8a',86,'4bee9cd6c46a408cababd9be760cc6ae','gigabytes___DEFAULT__',-1,'2026-01-23 00:07:40',NULL),('2026-01-22 00:07:40','2026-01-22 00:07:40','2026-01-22 00:07:40',1,308,'af2c2a07-1ab5-4be4-9ceb-458f63b518cf',88,'4bee9cd6c46a408cababd9be760cc6ae','snapshots___DEFAULT__',-1,'2026-01-23 00:07:40',NULL),('2026-01-22 00:07:42','2026-01-22 00:07:42','2026-01-22 00:07:42',1,309,'0b700cfc-7212-466f-a690-ef20e6b4050e',81,'4bee9cd6c46a408cababd9be760cc6ae','volumes',-1,'2026-01-23 00:07:42',NULL),('2026-01-22 00:07:42','2026-01-22 00:07:42','2026-01-22 00:07:42',1,310,'cccf527e-d284-4ae4-a652-0a0ba6289628',82,'4bee9cd6c46a408cababd9be760cc6ae','gigabytes',-1,'2026-01-23 00:07:42',NULL),('2026-01-22 00:07:42','2026-01-22 00:07:42','2026-01-22 00:07:42',1,311,'19b8996b-c8b6-4d7f-85f7-c8988bac7c1f',85,'4bee9cd6c46a408cababd9be760cc6ae','volumes___DEFAULT__',-1,'2026-01-23 00:07:42',NULL),('2026-01-22 00:07:42','2026-01-22 00:07:42','2026-01-22 00:07:42',1,312,'50f31ec7-5012-4e57-84be-f0193b6ae44a',86,'4bee9cd6c46a408cababd9be760cc6ae','gigabytes___DEFAULT__',-1,'2026-01-23 00:07:42',NULL),('2026-01-22 00:07:44','2026-01-22 00:07:44','2026-01-22 00:07:44',1,313,'051ba7fc-8c04-45ec-ac5d-126116b4ba37',81,'4bee9cd6c46a408cababd9be760cc6ae','volumes',1,'2026-01-23 00:07:44',NULL),('2026-01-22 00:07:44','2026-01-22 00:07:44','2026-01-22 00:07:44',1,314,'ae52488b-c689-433e-bae8-2db46cf02fe2',82,'4bee9cd6c46a408cababd9be760cc6ae','gigabytes',1,'2026-01-23 00:07:44',NULL),('2026-01-22 00:07:44','2026-01-22 00:07:44','2026-01-22 00:07:44',1,315,'c447ef53-a086-43b3-8299-1604009921f1',85,'4bee9cd6c46a408cababd9be760cc6ae','volumes___DEFAULT__',1,'2026-01-23 00:07:44',NULL),('2026-01-22 00:07:44','2026-01-22 00:07:44','2026-01-22 00:07:44',1,316,'f56a0a93-317e-41d9-8780-1842f5bf39f0',86,'4bee9cd6c46a408cababd9be760cc6ae','gigabytes___DEFAULT__',1,'2026-01-23 00:07:44',NULL),('2026-01-22 00:07:55','2026-01-22 00:07:55','2026-01-22 00:07:55',1,317,'d2b647fd-0504-4975-a815-5bb012da3ac0',63,'fc3cab1b1a7b4d81a2c0183f45084908','volumes',-1,'2026-01-23 00:07:55',NULL),('2026-01-22 00:07:55','2026-01-22 00:07:55','2026-01-22 00:07:55',1,318,'be311f66-c65c-465f-98a0-ded78739013c',64,'fc3cab1b1a7b4d81a2c0183f45084908','gigabytes',-1,'2026-01-23 00:07:55',NULL),('2026-01-22 00:07:55','2026-01-22 00:07:55','2026-01-22 00:07:55',1,319,'86c9ce3f-196f-4376-ac6c-bb6f5420f872',65,'fc3cab1b1a7b4d81a2c0183f45084908','volumes_tempest-scenario-type-luks-1960913990',-1,'2026-01-23 00:07:55',NULL),('2026-01-22 00:07:55','2026-01-22 00:07:55','2026-01-22 00:07:55',1,320,'a6f04252-cca3-4f14-9461-50148dc890e7',66,'fc3cab1b1a7b4d81a2c0183f45084908','gigabytes_tempest-scenario-type-luks-1960913990',-1,'2026-01-23 00:07:55',NULL),('2026-01-22 00:08:00','2026-01-22 00:08:01','2026-01-22 00:08:00',1,321,'621db533-d486-44fa-8d05-bd0623ef88c7',81,'4bee9cd6c46a408cababd9be760cc6ae','volumes',-1,'2026-01-23 00:08:00',NULL),('2026-01-22 00:08:00','2026-01-22 00:08:01','2026-01-22 00:08:01',1,322,'2bc37868-3dac-4c66-a852-90d29a0356ef',82,'4bee9cd6c46a408cababd9be760cc6ae','gigabytes',-1,'2026-01-23 00:08:00',NULL),('2026-01-22 00:08:00','2026-01-22 00:08:01','2026-01-22 00:08:01',1,323,'4ef04352-7b79-4077-a049-c8aeccc16900',85,'4bee9cd6c46a408cababd9be760cc6ae','volumes___DEFAULT__',-1,'2026-01-23 00:08:00',NULL),('2026-01-22 00:08:00','2026-01-22 00:08:01','2026-01-22 00:08:01',1,324,'6ae98f0c-1cc4-4613-9787-b1a0b46dc78b',86,'4bee9cd6c46a408cababd9be760cc6ae','gigabytes___DEFAULT__',-1,'2026-01-23 00:08:00',NULL),('2026-01-22 00:08:07','2026-01-22 00:08:07','2026-01-22 00:08:07',1,325,'0fa93a3d-91bd-4fb9-940b-12388c09e5b6',81,'4bee9cd6c46a408cababd9be760cc6ae','volumes',1,'2026-01-23 00:08:07',NULL),('2026-01-22 00:08:07','2026-01-22 00:08:07','2026-01-22 00:08:07',1,326,'15b6ccdd-df47-4ec1-82e2-70dd5fee70d3',82,'4bee9cd6c46a408cababd9be760cc6ae','gigabytes',1,'2026-01-23 00:08:07',NULL),('2026-01-22 00:08:07','2026-01-22 00:08:07','2026-01-22 00:08:07',1,327,'1b8f4608-db42-4e19-83b1-ae0fed6ddc22',85,'4bee9cd6c46a408cababd9be760cc6ae','volumes___DEFAULT__',1,'2026-01-23 00:08:07',NULL),('2026-01-22 00:08:07','2026-01-22 00:08:07','2026-01-22 00:08:07',1,328,'f7702ef5-7370-4ebe-9225-2a6d54def9f5',86,'4bee9cd6c46a408cababd9be760cc6ae','gigabytes___DEFAULT__',1,'2026-01-23 00:08:07',NULL),('2026-01-22 00:08:22','2026-01-22 00:08:22','2026-01-22 00:08:22',1,329,'cf74f950-3b0a-4f2e-9b5d-a0c4831a39de',81,'4bee9cd6c46a408cababd9be760cc6ae','volumes',-1,'2026-01-23 00:08:22',NULL),('2026-01-22 00:08:22','2026-01-22 00:08:22','2026-01-22 00:08:22',1,330,'c0ce45af-c04e-4297-a4c4-33668543e4c1',82,'4bee9cd6c46a408cababd9be760cc6ae','gigabytes',-1,'2026-01-23 00:08:22',NULL),('2026-01-22 00:08:22','2026-01-22 00:08:22','2026-01-22 00:08:22',1,331,'81b5fad9-e70b-40ca-ac8c-00fa16bab91f',85,'4bee9cd6c46a408cababd9be760cc6ae','volumes___DEFAULT__',-1,'2026-01-23 00:08:22',NULL),('2026-01-22 00:08:22','2026-01-22 00:08:22','2026-01-22 00:08:22',1,332,'337f06ff-f2f1-405d-b2f3-188c5ab2a8ef',86,'4bee9cd6c46a408cababd9be760cc6ae','gigabytes___DEFAULT__',-1,'2026-01-23 00:08:22',NULL),('2026-01-22 00:14:46','2026-01-22 00:14:46','2026-01-22 00:14:46',1,333,'ebf4e58c-cace-4935-b588-a50c943bbae0',89,'e2f0b6c9b06543ee9aa50a06847cbf17','volumes',1,'2026-01-23 00:14:46',NULL),('2026-01-22 00:14:46','2026-01-22 00:14:46','2026-01-22 00:14:46',1,334,'ce7424b3-225c-4f7f-86af-2db55564a1c0',90,'e2f0b6c9b06543ee9aa50a06847cbf17','gigabytes',1,'2026-01-23 00:14:46',NULL),('2026-01-22 00:14:46','2026-01-22 00:14:46','2026-01-22 00:14:46',1,335,'ac18d669-6ead-4522-bc6c-b9b286e3bf7b',91,'e2f0b6c9b06543ee9aa50a06847cbf17','volumes___DEFAULT__',1,'2026-01-23 00:14:46',NULL),('2026-01-22 00:14:46','2026-01-22 00:14:46','2026-01-22 00:14:46',1,336,'2c3186b8-d65e-4a5c-9dda-ba0c3c6b5727',92,'e2f0b6c9b06543ee9aa50a06847cbf17','gigabytes___DEFAULT__',1,'2026-01-23 00:14:46',NULL),('2026-01-22 00:14:53','2026-01-22 00:14:53','2026-01-22 00:14:53',1,337,'6bc7ea9a-5f4b-4c3d-9626-60267853dd0f',89,'e2f0b6c9b06543ee9aa50a06847cbf17','volumes',-1,'2026-01-23 00:14:53',NULL),('2026-01-22 00:14:53','2026-01-22 00:14:53','2026-01-22 00:14:53',1,338,'b0f49997-cecf-4662-b13d-90c010c5585a',90,'e2f0b6c9b06543ee9aa50a06847cbf17','gigabytes',-1,'2026-01-23 00:14:53',NULL),('2026-01-22 00:14:53','2026-01-22 00:14:53','2026-01-22 00:14:53',1,339,'51c7eee7-2b77-4af6-bc8b-6306a8904bd5',91,'e2f0b6c9b06543ee9aa50a06847cbf17','volumes___DEFAULT__',-1,'2026-01-23 00:14:53',NULL),('2026-01-22 00:14:53','2026-01-22 00:14:53','2026-01-22 00:14:53',1,340,'28ff1e84-ecb6-4ad3-a4bc-09b0e7401405',92,'e2f0b6c9b06543ee9aa50a06847cbf17','gigabytes___DEFAULT__',-1,'2026-01-23 00:14:53',NULL);
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2026-01-21 23:10:09','2026-01-22 00:29:24',NULL,0,1,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',471,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'d19139ad-b1cb-46d1-b548-a69e3d1bab82'),('2026-01-21 23:45:37','2026-01-22 00:29:20',NULL,0,2,'cinder-backup-0','cinder-backup','cinder-backup',262,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'bfc95959-684e-426a-9702-4b5cd6fd0cd2'),('2026-01-21 23:45:38','2026-01-22 00:29:20',NULL,0,3,'hostgroup@ceph','cinder-volume','cinder-volume',262,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
INSERT INTO `snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `status`, `progress`, `volume_size`, `scheduled_at`, `display_name`, `display_description`, `provider_location`, `encryption_key_id`, `volume_type_id`, `cgsnapshot_id`, `provider_id`, `provider_auth`, `group_snapshot_id`, `use_quota`) VALUES ('2026-01-22 00:07:30','2026-01-22 00:07:39','2026-01-22 00:07:40',1,'806da366-9169-4400-9181-1157518c39e9','560bd419-127b-4686-80cf-a3c8668e203d','19bb72c07b004b2cbc9628e145ed9a06','4bee9cd6c46a408cababd9be760cc6ae','deleted','100%',1,NULL,'tempest-TestVolumeBootPattern-snapshot-1315684650',NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,NULL,NULL,NULL,1),('2026-01-22 00:01:14','2026-01-22 00:01:16','2026-01-22 00:01:17',1,'c95c4674-c29c-4fb0-89cc-c0752d6ff7d1','49cf2089-e0c6-4e70-b80a-404cf80d26e9','5a45e446f069408b88ee65709a88105d','5e0f215651654ea9a021d1711425ddc1','deleted','100%',1,NULL,'tempest-VolumesSnapshotsTestJSON-Snapshot-626479821',NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,NULL,NULL,NULL,1);
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
INSERT INTO `volume_attachment` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `attached_host`, `instance_uuid`, `mountpoint`, `attach_time`, `detach_time`, `attach_mode`, `attach_status`, `connection_info`, `connector`) VALUES ('2026-01-21 23:58:41','2026-01-21 23:58:44','2026-01-21 23:58:44',1,'2cfccb55-a43c-4130-b0d9-2b5207d77a2d','8401d3a2-9ced-4cf5-8a9c-dcf4b5a57517',NULL,'23fe5bcd-17ef-4c3e-a05c-3d8e3d23d9be',NULL,NULL,'2026-01-21 23:58:44','null','detached','{}',NULL),('2026-01-22 00:08:18','2026-01-22 00:08:21','2026-01-22 00:08:21',1,'349d5a91-0c4b-4bb4-9dac-7acad7c5c1d7','b553e317-111b-4cb9-b2db-497dba69a2e3',NULL,'683a861a-2aa0-4a90-a891-ac841cec8c4f',NULL,NULL,'2026-01-22 00:08:21','null','detached','{}',NULL),('2026-01-21 23:56:16','2026-01-21 23:56:21','2026-01-21 23:56:21',1,'37c8524d-9185-4465-a3c1-c129db54a1b2','86f4517c-ad82-452c-96df-b6ee1ad3c96b',NULL,'b9043680-6539-49de-89bf-f132a3ef4e07',NULL,NULL,'2026-01-21 23:56:21','null','detached','{}',NULL),('2026-01-21 23:50:13','2026-01-21 23:50:16','2026-01-21 23:50:16',1,'492b32f8-9794-4e45-aa29-9286f812429d','6e7d1e95-0cfa-471f-b8b3-064f757ba735',NULL,'42844d15-3a14-488f-b8a8-587f803df081',NULL,NULL,'2026-01-21 23:50:16','null','detached','{}',NULL),('2026-01-22 00:06:16','2026-01-22 00:06:19','2026-01-22 00:06:19',1,'608ae002-2125-48a0-97fd-8a70eb01a644','299c203d-11ab-455f-a2ab-440a60c73aa4',NULL,'4c7906c0-2633-4b36-8df8-44064f259869',NULL,NULL,'2026-01-22 00:06:19','null','detached','{}',NULL),('2026-01-21 23:56:15','2026-01-21 23:56:21','2026-01-21 23:56:21',1,'638e0a76-850b-46e9-9365-9143aa52ee98','95bca597-be76-4f83-8cc7-50373ee57ee7',NULL,'b9043680-6539-49de-89bf-f132a3ef4e07',NULL,NULL,'2026-01-21 23:56:21','null','detached','{}',NULL),('2026-01-22 00:01:32','2026-01-22 00:01:35','2026-01-22 00:01:35',1,'64bc3ec5-95e6-47fc-96c0-70dad13fcd97','b98e6b93-0295-4524-9a35-11be3d47fdc9',NULL,'7b896797-0f0d-49ce-bf86-7b80dccb65b7',NULL,NULL,'2026-01-22 00:01:35','null','detached','{}',NULL),('2026-01-21 23:51:22','2026-01-21 23:51:26','2026-01-21 23:51:26',1,'70094124-b0e4-49e9-b901-3209d87e7194','4a7885fc-abb4-4f6b-ad8b-5a311b24c68d',NULL,'1c3d0d49-44bb-4afe-addc-cd17f6b54b06',NULL,NULL,'2026-01-21 23:51:26','null','detached','{}',NULL),('2026-01-22 00:02:02','2026-01-22 00:02:05','2026-01-22 00:02:05',1,'7338dfc7-c660-4f4c-8978-0a7a9d0c5534','fbffa57f-e323-41ac-942b-520c4b30e0ce',NULL,'147f5112-4d89-4a28-8e6e-da36763675a0',NULL,NULL,'2026-01-22 00:02:05','null','detached','{}',NULL),('2026-01-22 00:02:41','2026-01-22 00:02:44','2026-01-22 00:02:44',1,'7ff091cc-b30e-43f4-aa3e-0f4cada28f26','116a1db6-2b66-4afb-886a-3d2c956867f4',NULL,'61a365f9-80f1-49d0-9cf8-dd13878364d5',NULL,NULL,'2026-01-22 00:02:44','null','detached','{}',NULL),('2026-01-21 23:56:25','2026-01-21 23:56:30','2026-01-21 23:56:30',1,'82d4f632-e46e-4a31-a843-fb0f1a301e6d','af8899d7-c591-492d-bb7a-ae745a21af51',NULL,'4359bd81-5e55-499b-a1d6-4380a94ac418',NULL,NULL,'2026-01-21 23:56:30','null','detached','{}',NULL),('2026-01-21 23:56:24','2026-01-21 23:56:30','2026-01-21 23:56:30',1,'8e82147f-2a73-472a-a00c-3c230fc12d33','1e6a9045-f2a3-408e-9f8d-933c31562860',NULL,'4359bd81-5e55-499b-a1d6-4380a94ac418',NULL,NULL,'2026-01-21 23:56:30','null','detached','{}',NULL),('2026-01-21 23:56:16','2026-01-21 23:56:21','2026-01-21 23:56:21',1,'a2d7cd84-6793-4b5d-a5b9-9e653a439edd','c7ac44c0-1bc4-4e7e-9dd6-e1b2dda64d85',NULL,'b9043680-6539-49de-89bf-f132a3ef4e07',NULL,NULL,'2026-01-21 23:56:21','null','detached','{}',NULL),('2026-01-22 00:07:57','2026-01-22 00:08:00','2026-01-22 00:08:00',1,'a34c3960-a7dc-48fd-8846-24ab56c4faae','b36d6bda-8790-410a-93e2-60bf7b01c67a',NULL,'4ba2faed-321f-4f0c-b51f-0a9d1191e484',NULL,NULL,'2026-01-22 00:08:00','null','detached','{}',NULL),('2026-01-22 00:02:37','2026-01-22 00:02:45','2026-01-22 00:02:45',1,'bb535f58-86b1-4f00-ba32-e4a895a94217','baf0f41d-78fe-4b02-ac69-b2ac582ee4b6',NULL,'1ee37a62-670c-499c-93cd-a802e4aa89f8',NULL,NULL,'2026-01-22 00:02:45','null','detached','{}',NULL),('2026-01-22 00:07:15','2026-01-22 00:07:18','2026-01-22 00:07:18',1,'c50c6ee2-03e6-48f3-80a4-406a0362c77f','108261c4-7c9a-4900-aea6-77a89199108f',NULL,'03e452a2-7146-4aec-989f-63b145e67b24',NULL,NULL,'2026-01-22 00:07:18','null','detached','{}',NULL),('2026-01-21 23:59:47','2026-01-21 23:59:50','2026-01-21 23:59:50',1,'c5a3eb2a-cff6-4a9a-b0df-ecfb0b271fb7','11d93e0f-0920-43f1-9a0b-ceac3a4c80c1',NULL,'d68fe78c-aed5-478d-8dc5-a1e4593c3211',NULL,NULL,'2026-01-21 23:59:50','null','detached','{}',NULL),('2026-01-22 00:05:18','2026-01-22 00:05:20','2026-01-22 00:05:20',1,'d46611d3-d8f1-4dcc-b249-42ba665cb7b6','c803697a-6647-4aed-ad44-f61ef3779f97',NULL,'7e1cf87a-965c-4652-9f6a-a40860957001',NULL,NULL,'2026-01-22 00:05:20','null','detached','{}',NULL),('2026-01-22 00:02:33','2026-01-22 00:02:46','2026-01-22 00:02:46',1,'de565d7e-adfa-4166-949d-485540332fba','15d1a7fe-e5cd-4a26-b59f-8769b3e04c34',NULL,'74bdb2eb-c6e1-4be4-995e-5b06c6a0b791',NULL,NULL,'2026-01-22 00:02:46','null','detached','{}',NULL),('2026-01-21 23:56:24','2026-01-21 23:56:30','2026-01-21 23:56:30',1,'fe8c176a-c51b-4f5c-b780-a09f0e5193c4','ded57726-55d3-47a6-bbea-8d9c14ec92ef',NULL,'4359bd81-5e55-499b-a1d6-4380a94ac418',NULL,NULL,'2026-01-21 23:56:30','null','detached','{}',NULL);
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=178 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
INSERT INTO `volume_glance_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `snapshot_id`, `key`, `value`) VALUES ('2026-01-21 23:50:05',NULL,'2026-01-21 23:50:17',1,1,'6e7d1e95-0cfa-471f-b8b3-064f757ba735',NULL,'signature_verified','False'),('2026-01-21 23:50:09',NULL,'2026-01-21 23:50:17',1,2,'6e7d1e95-0cfa-471f-b8b3-064f757ba735',NULL,'hw_rng_model','virtio'),('2026-01-21 23:50:09',NULL,'2026-01-21 23:50:17',1,3,'6e7d1e95-0cfa-471f-b8b3-064f757ba735',NULL,'image_id','612899ae-3852-48be-a8e3-ea7634c05e74'),('2026-01-21 23:50:09',NULL,'2026-01-21 23:50:17',1,4,'6e7d1e95-0cfa-471f-b8b3-064f757ba735',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-21 23:50:09',NULL,'2026-01-21 23:50:17',1,5,'6e7d1e95-0cfa-471f-b8b3-064f757ba735',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-21 23:50:09',NULL,'2026-01-21 23:50:17',1,6,'6e7d1e95-0cfa-471f-b8b3-064f757ba735',NULL,'container_format','bare'),('2026-01-21 23:50:09',NULL,'2026-01-21 23:50:17',1,7,'6e7d1e95-0cfa-471f-b8b3-064f757ba735',NULL,'disk_format','qcow2'),('2026-01-21 23:50:09',NULL,'2026-01-21 23:50:17',1,8,'6e7d1e95-0cfa-471f-b8b3-064f757ba735',NULL,'min_disk','0'),('2026-01-21 23:50:09',NULL,'2026-01-21 23:50:17',1,9,'6e7d1e95-0cfa-471f-b8b3-064f757ba735',NULL,'min_ram','0'),('2026-01-21 23:50:09',NULL,'2026-01-21 23:50:17',1,10,'6e7d1e95-0cfa-471f-b8b3-064f757ba735',NULL,'size','21430272'),('2026-01-21 23:51:12',NULL,'2026-01-21 23:51:27',1,11,'4a7885fc-abb4-4f6b-ad8b-5a311b24c68d',NULL,'signature_verified','False'),('2026-01-21 23:51:18',NULL,'2026-01-21 23:51:27',1,12,'4a7885fc-abb4-4f6b-ad8b-5a311b24c68d',NULL,'hw_rng_model','virtio'),('2026-01-21 23:51:18',NULL,'2026-01-21 23:51:27',1,13,'4a7885fc-abb4-4f6b-ad8b-5a311b24c68d',NULL,'image_id','612899ae-3852-48be-a8e3-ea7634c05e74'),('2026-01-21 23:51:18',NULL,'2026-01-21 23:51:27',1,14,'4a7885fc-abb4-4f6b-ad8b-5a311b24c68d',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-21 23:51:18',NULL,'2026-01-21 23:51:27',1,15,'4a7885fc-abb4-4f6b-ad8b-5a311b24c68d',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-21 23:51:18',NULL,'2026-01-21 23:51:27',1,16,'4a7885fc-abb4-4f6b-ad8b-5a311b24c68d',NULL,'container_format','bare'),('2026-01-21 23:51:18',NULL,'2026-01-21 23:51:27',1,17,'4a7885fc-abb4-4f6b-ad8b-5a311b24c68d',NULL,'disk_format','qcow2'),('2026-01-21 23:51:18',NULL,'2026-01-21 23:51:27',1,18,'4a7885fc-abb4-4f6b-ad8b-5a311b24c68d',NULL,'min_disk','0'),('2026-01-21 23:51:18',NULL,'2026-01-21 23:51:27',1,19,'4a7885fc-abb4-4f6b-ad8b-5a311b24c68d',NULL,'min_ram','0'),('2026-01-21 23:51:18',NULL,'2026-01-21 23:51:27',1,20,'4a7885fc-abb4-4f6b-ad8b-5a311b24c68d',NULL,'size','21430272'),('2026-01-21 23:55:48',NULL,'2026-01-21 23:56:29',1,21,'95bca597-be76-4f83-8cc7-50373ee57ee7',NULL,'signature_verified','False'),('2026-01-21 23:55:52',NULL,'2026-01-21 23:56:29',1,22,'95bca597-be76-4f83-8cc7-50373ee57ee7',NULL,'hw_rng_model','virtio'),('2026-01-21 23:55:52',NULL,'2026-01-21 23:56:29',1,23,'95bca597-be76-4f83-8cc7-50373ee57ee7',NULL,'image_id','612899ae-3852-48be-a8e3-ea7634c05e74'),('2026-01-21 23:55:52',NULL,'2026-01-21 23:56:29',1,24,'95bca597-be76-4f83-8cc7-50373ee57ee7',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-21 23:55:52',NULL,'2026-01-21 23:56:29',1,25,'95bca597-be76-4f83-8cc7-50373ee57ee7',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-21 23:55:52',NULL,'2026-01-21 23:56:29',1,26,'95bca597-be76-4f83-8cc7-50373ee57ee7',NULL,'container_format','bare'),('2026-01-21 23:55:52',NULL,'2026-01-21 23:56:29',1,27,'95bca597-be76-4f83-8cc7-50373ee57ee7',NULL,'disk_format','qcow2'),('2026-01-21 23:55:52',NULL,'2026-01-21 23:56:29',1,28,'95bca597-be76-4f83-8cc7-50373ee57ee7',NULL,'min_disk','0'),('2026-01-21 23:55:52',NULL,'2026-01-21 23:56:29',1,29,'95bca597-be76-4f83-8cc7-50373ee57ee7',NULL,'min_ram','0'),('2026-01-21 23:55:52',NULL,'2026-01-21 23:56:29',1,30,'95bca597-be76-4f83-8cc7-50373ee57ee7',NULL,'size','21430272'),('2026-01-21 23:55:58',NULL,'2026-01-21 23:56:39',1,31,'1e6a9045-f2a3-408e-9f8d-933c31562860',NULL,'signature_verified','False'),('2026-01-21 23:56:02',NULL,'2026-01-21 23:56:39',1,32,'1e6a9045-f2a3-408e-9f8d-933c31562860',NULL,'hw_rng_model','virtio'),('2026-01-21 23:56:02',NULL,'2026-01-21 23:56:39',1,33,'1e6a9045-f2a3-408e-9f8d-933c31562860',NULL,'image_id','612899ae-3852-48be-a8e3-ea7634c05e74'),('2026-01-21 23:56:02',NULL,'2026-01-21 23:56:39',1,34,'1e6a9045-f2a3-408e-9f8d-933c31562860',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-21 23:56:02',NULL,'2026-01-21 23:56:39',1,35,'1e6a9045-f2a3-408e-9f8d-933c31562860',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-21 23:56:02',NULL,'2026-01-21 23:56:39',1,36,'1e6a9045-f2a3-408e-9f8d-933c31562860',NULL,'container_format','bare'),('2026-01-21 23:56:02',NULL,'2026-01-21 23:56:39',1,37,'1e6a9045-f2a3-408e-9f8d-933c31562860',NULL,'disk_format','qcow2'),('2026-01-21 23:56:02',NULL,'2026-01-21 23:56:39',1,38,'1e6a9045-f2a3-408e-9f8d-933c31562860',NULL,'min_disk','0'),('2026-01-21 23:56:02',NULL,'2026-01-21 23:56:39',1,39,'1e6a9045-f2a3-408e-9f8d-933c31562860',NULL,'min_ram','0'),('2026-01-21 23:56:02',NULL,'2026-01-21 23:56:39',1,40,'1e6a9045-f2a3-408e-9f8d-933c31562860',NULL,'size','21430272'),('2026-01-21 23:58:31',NULL,'2026-01-21 23:58:45',1,41,'8401d3a2-9ced-4cf5-8a9c-dcf4b5a57517',NULL,'signature_verified','False'),('2026-01-21 23:58:36',NULL,'2026-01-21 23:58:45',1,42,'8401d3a2-9ced-4cf5-8a9c-dcf4b5a57517',NULL,'hw_rng_model','virtio'),('2026-01-21 23:58:36',NULL,'2026-01-21 23:58:45',1,43,'8401d3a2-9ced-4cf5-8a9c-dcf4b5a57517',NULL,'image_id','612899ae-3852-48be-a8e3-ea7634c05e74'),('2026-01-21 23:58:36',NULL,'2026-01-21 23:58:45',1,44,'8401d3a2-9ced-4cf5-8a9c-dcf4b5a57517',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-21 23:58:36',NULL,'2026-01-21 23:58:45',1,45,'8401d3a2-9ced-4cf5-8a9c-dcf4b5a57517',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-21 23:58:36',NULL,'2026-01-21 23:58:45',1,46,'8401d3a2-9ced-4cf5-8a9c-dcf4b5a57517',NULL,'container_format','bare'),('2026-01-21 23:58:36',NULL,'2026-01-21 23:58:45',1,47,'8401d3a2-9ced-4cf5-8a9c-dcf4b5a57517',NULL,'disk_format','qcow2'),('2026-01-21 23:58:36',NULL,'2026-01-21 23:58:45',1,48,'8401d3a2-9ced-4cf5-8a9c-dcf4b5a57517',NULL,'min_disk','0'),('2026-01-21 23:58:36',NULL,'2026-01-21 23:58:45',1,49,'8401d3a2-9ced-4cf5-8a9c-dcf4b5a57517',NULL,'min_ram','0'),('2026-01-21 23:58:36',NULL,'2026-01-21 23:58:45',1,50,'8401d3a2-9ced-4cf5-8a9c-dcf4b5a57517',NULL,'size','21430272'),('2026-01-21 23:59:39',NULL,'2026-01-21 23:59:50',1,51,'11d93e0f-0920-43f1-9a0b-ceac3a4c80c1',NULL,'signature_verified','False'),('2026-01-21 23:59:43',NULL,'2026-01-21 23:59:50',1,52,'11d93e0f-0920-43f1-9a0b-ceac3a4c80c1',NULL,'hw_rng_model','virtio'),('2026-01-21 23:59:43',NULL,'2026-01-21 23:59:50',1,53,'11d93e0f-0920-43f1-9a0b-ceac3a4c80c1',NULL,'image_id','612899ae-3852-48be-a8e3-ea7634c05e74'),('2026-01-21 23:59:43',NULL,'2026-01-21 23:59:50',1,54,'11d93e0f-0920-43f1-9a0b-ceac3a4c80c1',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-21 23:59:43',NULL,'2026-01-21 23:59:50',1,55,'11d93e0f-0920-43f1-9a0b-ceac3a4c80c1',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-21 23:59:43',NULL,'2026-01-21 23:59:50',1,56,'11d93e0f-0920-43f1-9a0b-ceac3a4c80c1',NULL,'container_format','bare'),('2026-01-21 23:59:43',NULL,'2026-01-21 23:59:50',1,57,'11d93e0f-0920-43f1-9a0b-ceac3a4c80c1',NULL,'disk_format','qcow2'),('2026-01-21 23:59:43',NULL,'2026-01-21 23:59:50',1,58,'11d93e0f-0920-43f1-9a0b-ceac3a4c80c1',NULL,'min_disk','0'),('2026-01-21 23:59:43',NULL,'2026-01-21 23:59:50',1,59,'11d93e0f-0920-43f1-9a0b-ceac3a4c80c1',NULL,'min_ram','0'),('2026-01-21 23:59:43',NULL,'2026-01-21 23:59:50',1,60,'11d93e0f-0920-43f1-9a0b-ceac3a4c80c1',NULL,'size','21430272'),('2026-01-22 00:01:23',NULL,'2026-01-22 00:02:14',1,61,'b98e6b93-0295-4524-9a35-11be3d47fdc9',NULL,'signature_verified','False'),('2026-01-22 00:01:28',NULL,'2026-01-22 00:02:14',1,62,'b98e6b93-0295-4524-9a35-11be3d47fdc9',NULL,'hw_rng_model','virtio'),('2026-01-22 00:01:28',NULL,'2026-01-22 00:02:14',1,63,'b98e6b93-0295-4524-9a35-11be3d47fdc9',NULL,'image_id','612899ae-3852-48be-a8e3-ea7634c05e74'),('2026-01-22 00:01:28',NULL,'2026-01-22 00:02:14',1,64,'b98e6b93-0295-4524-9a35-11be3d47fdc9',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-22 00:01:28',NULL,'2026-01-22 00:02:14',1,65,'b98e6b93-0295-4524-9a35-11be3d47fdc9',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-22 00:01:28',NULL,'2026-01-22 00:02:14',1,66,'b98e6b93-0295-4524-9a35-11be3d47fdc9',NULL,'container_format','bare'),('2026-01-22 00:01:28',NULL,'2026-01-22 00:02:14',1,67,'b98e6b93-0295-4524-9a35-11be3d47fdc9',NULL,'disk_format','qcow2'),('2026-01-22 00:01:28',NULL,'2026-01-22 00:02:14',1,68,'b98e6b93-0295-4524-9a35-11be3d47fdc9',NULL,'min_disk','0'),('2026-01-22 00:01:28',NULL,'2026-01-22 00:02:14',1,69,'b98e6b93-0295-4524-9a35-11be3d47fdc9',NULL,'min_ram','0'),('2026-01-22 00:01:28',NULL,'2026-01-22 00:02:14',1,70,'b98e6b93-0295-4524-9a35-11be3d47fdc9',NULL,'size','21430272'),('2026-01-22 00:01:54',NULL,'2026-01-22 00:02:09',1,71,'fbffa57f-e323-41ac-942b-520c4b30e0ce',NULL,'signature_verified','False'),('2026-01-22 00:01:58',NULL,'2026-01-22 00:02:09',1,72,'fbffa57f-e323-41ac-942b-520c4b30e0ce',NULL,'hw_rng_model','virtio'),('2026-01-22 00:01:58',NULL,'2026-01-22 00:02:09',1,73,'fbffa57f-e323-41ac-942b-520c4b30e0ce',NULL,'image_id','612899ae-3852-48be-a8e3-ea7634c05e74'),('2026-01-22 00:01:58',NULL,'2026-01-22 00:02:09',1,74,'fbffa57f-e323-41ac-942b-520c4b30e0ce',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-22 00:01:58',NULL,'2026-01-22 00:02:09',1,75,'fbffa57f-e323-41ac-942b-520c4b30e0ce',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-22 00:01:58',NULL,'2026-01-22 00:02:09',1,76,'fbffa57f-e323-41ac-942b-520c4b30e0ce',NULL,'container_format','bare'),('2026-01-22 00:01:58',NULL,'2026-01-22 00:02:09',1,77,'fbffa57f-e323-41ac-942b-520c4b30e0ce',NULL,'disk_format','qcow2'),('2026-01-22 00:01:58',NULL,'2026-01-22 00:02:09',1,78,'fbffa57f-e323-41ac-942b-520c4b30e0ce',NULL,'min_disk','0'),('2026-01-22 00:01:58',NULL,'2026-01-22 00:02:09',1,79,'fbffa57f-e323-41ac-942b-520c4b30e0ce',NULL,'min_ram','0'),('2026-01-22 00:01:58',NULL,'2026-01-22 00:02:09',1,80,'fbffa57f-e323-41ac-942b-520c4b30e0ce',NULL,'size','21430272'),('2026-01-22 00:02:21',NULL,'2026-01-22 00:02:58',1,81,'15d1a7fe-e5cd-4a26-b59f-8769b3e04c34',NULL,'signature_verified','False'),('2026-01-22 00:02:24',NULL,'2026-01-22 00:02:53',1,82,'baf0f41d-78fe-4b02-ac69-b2ac582ee4b6',NULL,'signature_verified','False'),('2026-01-22 00:02:26',NULL,'2026-01-22 00:02:50',1,83,'116a1db6-2b66-4afb-886a-3d2c956867f4',NULL,'signature_verified','False'),('2026-01-22 00:02:30',NULL,'2026-01-22 00:02:58',1,84,'15d1a7fe-e5cd-4a26-b59f-8769b3e04c34',NULL,'image_id','e02f287e-32da-459a-a861-1ec342441330'),('2026-01-22 00:02:30',NULL,'2026-01-22 00:02:58',1,85,'15d1a7fe-e5cd-4a26-b59f-8769b3e04c34',NULL,'image_name','tempest-scenario-img--1518198378'),('2026-01-22 00:02:30',NULL,'2026-01-22 00:02:58',1,86,'15d1a7fe-e5cd-4a26-b59f-8769b3e04c34',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-22 00:02:30',NULL,'2026-01-22 00:02:58',1,87,'15d1a7fe-e5cd-4a26-b59f-8769b3e04c34',NULL,'container_format','bare'),('2026-01-22 00:02:30',NULL,'2026-01-22 00:02:58',1,88,'15d1a7fe-e5cd-4a26-b59f-8769b3e04c34',NULL,'disk_format','qcow2'),('2026-01-22 00:02:30',NULL,'2026-01-22 00:02:58',1,89,'15d1a7fe-e5cd-4a26-b59f-8769b3e04c34',NULL,'min_disk','0'),('2026-01-22 00:02:30',NULL,'2026-01-22 00:02:58',1,90,'15d1a7fe-e5cd-4a26-b59f-8769b3e04c34',NULL,'min_ram','0'),('2026-01-22 00:02:30',NULL,'2026-01-22 00:02:58',1,91,'15d1a7fe-e5cd-4a26-b59f-8769b3e04c34',NULL,'size','21430272'),('2026-01-22 00:02:32',NULL,'2026-01-22 00:02:53',1,92,'baf0f41d-78fe-4b02-ac69-b2ac582ee4b6',NULL,'image_id','e02f287e-32da-459a-a861-1ec342441330'),('2026-01-22 00:02:32',NULL,'2026-01-22 00:02:53',1,93,'baf0f41d-78fe-4b02-ac69-b2ac582ee4b6',NULL,'image_name','tempest-scenario-img--1518198378'),('2026-01-22 00:02:32',NULL,'2026-01-22 00:02:53',1,94,'baf0f41d-78fe-4b02-ac69-b2ac582ee4b6',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-22 00:02:32',NULL,'2026-01-22 00:02:53',1,95,'baf0f41d-78fe-4b02-ac69-b2ac582ee4b6',NULL,'container_format','bare'),('2026-01-22 00:02:32',NULL,'2026-01-22 00:02:53',1,96,'baf0f41d-78fe-4b02-ac69-b2ac582ee4b6',NULL,'disk_format','qcow2'),('2026-01-22 00:02:32',NULL,'2026-01-22 00:02:53',1,97,'baf0f41d-78fe-4b02-ac69-b2ac582ee4b6',NULL,'min_disk','0'),('2026-01-22 00:02:32',NULL,'2026-01-22 00:02:53',1,98,'baf0f41d-78fe-4b02-ac69-b2ac582ee4b6',NULL,'min_ram','0'),('2026-01-22 00:02:32',NULL,'2026-01-22 00:02:53',1,99,'baf0f41d-78fe-4b02-ac69-b2ac582ee4b6',NULL,'size','21430272'),('2026-01-22 00:02:33',NULL,'2026-01-22 00:02:50',1,100,'116a1db6-2b66-4afb-886a-3d2c956867f4',NULL,'image_id','e02f287e-32da-459a-a861-1ec342441330'),('2026-01-22 00:02:33',NULL,'2026-01-22 00:02:50',1,101,'116a1db6-2b66-4afb-886a-3d2c956867f4',NULL,'image_name','tempest-scenario-img--1518198378'),('2026-01-22 00:02:33',NULL,'2026-01-22 00:02:50',1,102,'116a1db6-2b66-4afb-886a-3d2c956867f4',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-22 00:02:33',NULL,'2026-01-22 00:02:50',1,103,'116a1db6-2b66-4afb-886a-3d2c956867f4',NULL,'container_format','bare'),('2026-01-22 00:02:33',NULL,'2026-01-22 00:02:50',1,104,'116a1db6-2b66-4afb-886a-3d2c956867f4',NULL,'disk_format','qcow2'),('2026-01-22 00:02:33',NULL,'2026-01-22 00:02:50',1,105,'116a1db6-2b66-4afb-886a-3d2c956867f4',NULL,'min_disk','0'),('2026-01-22 00:02:33',NULL,'2026-01-22 00:02:50',1,106,'116a1db6-2b66-4afb-886a-3d2c956867f4',NULL,'min_ram','0'),('2026-01-22 00:02:33',NULL,'2026-01-22 00:02:50',1,107,'116a1db6-2b66-4afb-886a-3d2c956867f4',NULL,'size','21430272'),('2026-01-22 00:05:12',NULL,'2026-01-22 00:05:21',1,108,'c803697a-6647-4aed-ad44-f61ef3779f97',NULL,'signature_verified','False'),('2026-01-22 00:05:16',NULL,'2026-01-22 00:05:21',1,109,'c803697a-6647-4aed-ad44-f61ef3779f97',NULL,'hw_rng_model','virtio'),('2026-01-22 00:05:16',NULL,'2026-01-22 00:05:21',1,110,'c803697a-6647-4aed-ad44-f61ef3779f97',NULL,'image_id','612899ae-3852-48be-a8e3-ea7634c05e74'),('2026-01-22 00:05:16',NULL,'2026-01-22 00:05:21',1,111,'c803697a-6647-4aed-ad44-f61ef3779f97',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-22 00:05:16',NULL,'2026-01-22 00:05:21',1,112,'c803697a-6647-4aed-ad44-f61ef3779f97',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-22 00:05:16',NULL,'2026-01-22 00:05:21',1,113,'c803697a-6647-4aed-ad44-f61ef3779f97',NULL,'container_format','bare'),('2026-01-22 00:05:16',NULL,'2026-01-22 00:05:21',1,114,'c803697a-6647-4aed-ad44-f61ef3779f97',NULL,'disk_format','qcow2'),('2026-01-22 00:05:16',NULL,'2026-01-22 00:05:21',1,115,'c803697a-6647-4aed-ad44-f61ef3779f97',NULL,'min_disk','0'),('2026-01-22 00:05:16',NULL,'2026-01-22 00:05:21',1,116,'c803697a-6647-4aed-ad44-f61ef3779f97',NULL,'min_ram','0'),('2026-01-22 00:05:16',NULL,'2026-01-22 00:05:21',1,117,'c803697a-6647-4aed-ad44-f61ef3779f97',NULL,'size','21430272'),('2026-01-22 00:05:54',NULL,'2026-01-22 00:06:22',1,118,'1b53ddbf-cb53-4678-99d5-3024c177fdb2',NULL,'signature_verified','False'),('2026-01-22 00:05:58',NULL,'2026-01-22 00:06:22',1,119,'1b53ddbf-cb53-4678-99d5-3024c177fdb2',NULL,'hw_rng_model','virtio'),('2026-01-22 00:05:58',NULL,'2026-01-22 00:06:22',1,120,'1b53ddbf-cb53-4678-99d5-3024c177fdb2',NULL,'image_id','612899ae-3852-48be-a8e3-ea7634c05e74'),('2026-01-22 00:05:58',NULL,'2026-01-22 00:06:22',1,121,'1b53ddbf-cb53-4678-99d5-3024c177fdb2',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-22 00:05:58',NULL,'2026-01-22 00:06:22',1,122,'1b53ddbf-cb53-4678-99d5-3024c177fdb2',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-22 00:05:58',NULL,'2026-01-22 00:06:22',1,123,'1b53ddbf-cb53-4678-99d5-3024c177fdb2',NULL,'container_format','bare'),('2026-01-22 00:05:58',NULL,'2026-01-22 00:06:22',1,124,'1b53ddbf-cb53-4678-99d5-3024c177fdb2',NULL,'disk_format','qcow2'),('2026-01-22 00:05:58',NULL,'2026-01-22 00:06:22',1,125,'1b53ddbf-cb53-4678-99d5-3024c177fdb2',NULL,'min_disk','0'),('2026-01-22 00:05:58',NULL,'2026-01-22 00:06:22',1,126,'1b53ddbf-cb53-4678-99d5-3024c177fdb2',NULL,'min_ram','0'),('2026-01-22 00:05:58',NULL,'2026-01-22 00:06:22',1,127,'1b53ddbf-cb53-4678-99d5-3024c177fdb2',NULL,'size','21430272'),('2026-01-22 00:06:10',NULL,'2026-01-22 00:06:22',1,128,'299c203d-11ab-455f-a2ab-440a60c73aa4',NULL,'signature_verified','False'),('2026-01-22 00:06:10',NULL,'2026-01-22 00:06:22',1,129,'299c203d-11ab-455f-a2ab-440a60c73aa4',NULL,'hw_rng_model','virtio'),('2026-01-22 00:06:10',NULL,'2026-01-22 00:06:22',1,130,'299c203d-11ab-455f-a2ab-440a60c73aa4',NULL,'image_id','612899ae-3852-48be-a8e3-ea7634c05e74'),('2026-01-22 00:06:10',NULL,'2026-01-22 00:06:22',1,131,'299c203d-11ab-455f-a2ab-440a60c73aa4',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-22 00:06:10',NULL,'2026-01-22 00:06:22',1,132,'299c203d-11ab-455f-a2ab-440a60c73aa4',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-22 00:06:10',NULL,'2026-01-22 00:06:22',1,133,'299c203d-11ab-455f-a2ab-440a60c73aa4',NULL,'container_format','bare'),('2026-01-22 00:06:10',NULL,'2026-01-22 00:06:22',1,134,'299c203d-11ab-455f-a2ab-440a60c73aa4',NULL,'disk_format','qcow2'),('2026-01-22 00:06:10',NULL,'2026-01-22 00:06:22',1,135,'299c203d-11ab-455f-a2ab-440a60c73aa4',NULL,'min_disk','0'),('2026-01-22 00:06:10',NULL,'2026-01-22 00:06:22',1,136,'299c203d-11ab-455f-a2ab-440a60c73aa4',NULL,'min_ram','0'),('2026-01-22 00:06:10',NULL,'2026-01-22 00:06:22',1,137,'299c203d-11ab-455f-a2ab-440a60c73aa4',NULL,'size','21430272'),('2026-01-22 00:07:25',NULL,'2026-01-22 00:07:42',1,138,'560bd419-127b-4686-80cf-a3c8668e203d',NULL,'signature_verified','False'),('2026-01-22 00:07:29',NULL,'2026-01-22 00:07:42',1,139,'560bd419-127b-4686-80cf-a3c8668e203d',NULL,'hw_rng_model','virtio'),('2026-01-22 00:07:29',NULL,'2026-01-22 00:07:42',1,140,'560bd419-127b-4686-80cf-a3c8668e203d',NULL,'image_id','612899ae-3852-48be-a8e3-ea7634c05e74'),('2026-01-22 00:07:29',NULL,'2026-01-22 00:07:42',1,141,'560bd419-127b-4686-80cf-a3c8668e203d',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-22 00:07:29',NULL,'2026-01-22 00:07:42',1,142,'560bd419-127b-4686-80cf-a3c8668e203d',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-22 00:07:29',NULL,'2026-01-22 00:07:42',1,143,'560bd419-127b-4686-80cf-a3c8668e203d',NULL,'container_format','bare'),('2026-01-22 00:07:29',NULL,'2026-01-22 00:07:42',1,144,'560bd419-127b-4686-80cf-a3c8668e203d',NULL,'disk_format','qcow2'),('2026-01-22 00:07:29',NULL,'2026-01-22 00:07:42',1,145,'560bd419-127b-4686-80cf-a3c8668e203d',NULL,'min_disk','0'),('2026-01-22 00:07:29',NULL,'2026-01-22 00:07:42',1,146,'560bd419-127b-4686-80cf-a3c8668e203d',NULL,'min_ram','0'),('2026-01-22 00:07:29',NULL,'2026-01-22 00:07:42',1,147,'560bd419-127b-4686-80cf-a3c8668e203d',NULL,'size','21430272'),('2026-01-22 00:07:32',NULL,'2026-01-22 00:07:40',1,148,NULL,'806da366-9169-4400-9181-1157518c39e9','signature_verified','False'),('2026-01-22 00:07:32',NULL,'2026-01-22 00:07:40',1,149,NULL,'806da366-9169-4400-9181-1157518c39e9','hw_rng_model','virtio'),('2026-01-22 00:07:32',NULL,'2026-01-22 00:07:40',1,150,NULL,'806da366-9169-4400-9181-1157518c39e9','image_id','612899ae-3852-48be-a8e3-ea7634c05e74'),('2026-01-22 00:07:32',NULL,'2026-01-22 00:07:40',1,151,NULL,'806da366-9169-4400-9181-1157518c39e9','image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-22 00:07:32',NULL,'2026-01-22 00:07:40',1,152,NULL,'806da366-9169-4400-9181-1157518c39e9','checksum','c8fc807773e5354afe61636071771906'),('2026-01-22 00:07:32',NULL,'2026-01-22 00:07:40',1,153,NULL,'806da366-9169-4400-9181-1157518c39e9','container_format','bare'),('2026-01-22 00:07:32',NULL,'2026-01-22 00:07:40',1,154,NULL,'806da366-9169-4400-9181-1157518c39e9','disk_format','qcow2'),('2026-01-22 00:07:32',NULL,'2026-01-22 00:07:40',1,155,NULL,'806da366-9169-4400-9181-1157518c39e9','min_disk','0'),('2026-01-22 00:07:32',NULL,'2026-01-22 00:07:40',1,156,NULL,'806da366-9169-4400-9181-1157518c39e9','min_ram','0'),('2026-01-22 00:07:32',NULL,'2026-01-22 00:07:40',1,157,NULL,'806da366-9169-4400-9181-1157518c39e9','size','21430272'),('2026-01-22 00:07:47',NULL,'2026-01-22 00:08:00',1,158,'b36d6bda-8790-410a-93e2-60bf7b01c67a',NULL,'signature_verified','False'),('2026-01-22 00:07:51',NULL,'2026-01-22 00:08:00',1,159,'b36d6bda-8790-410a-93e2-60bf7b01c67a',NULL,'hw_rng_model','virtio'),('2026-01-22 00:07:51',NULL,'2026-01-22 00:08:00',1,160,'b36d6bda-8790-410a-93e2-60bf7b01c67a',NULL,'image_id','612899ae-3852-48be-a8e3-ea7634c05e74'),('2026-01-22 00:07:51',NULL,'2026-01-22 00:08:00',1,161,'b36d6bda-8790-410a-93e2-60bf7b01c67a',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-22 00:07:51',NULL,'2026-01-22 00:08:00',1,162,'b36d6bda-8790-410a-93e2-60bf7b01c67a',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-22 00:07:51',NULL,'2026-01-22 00:08:00',1,163,'b36d6bda-8790-410a-93e2-60bf7b01c67a',NULL,'container_format','bare'),('2026-01-22 00:07:51',NULL,'2026-01-22 00:08:00',1,164,'b36d6bda-8790-410a-93e2-60bf7b01c67a',NULL,'disk_format','qcow2'),('2026-01-22 00:07:51',NULL,'2026-01-22 00:08:00',1,165,'b36d6bda-8790-410a-93e2-60bf7b01c67a',NULL,'min_disk','0'),('2026-01-22 00:07:51',NULL,'2026-01-22 00:08:00',1,166,'b36d6bda-8790-410a-93e2-60bf7b01c67a',NULL,'min_ram','0'),('2026-01-22 00:07:51',NULL,'2026-01-22 00:08:00',1,167,'b36d6bda-8790-410a-93e2-60bf7b01c67a',NULL,'size','21430272'),('2026-01-22 00:08:11',NULL,'2026-01-22 00:08:22',1,168,'b553e317-111b-4cb9-b2db-497dba69a2e3',NULL,'signature_verified','False'),('2026-01-22 00:08:15',NULL,'2026-01-22 00:08:22',1,169,'b553e317-111b-4cb9-b2db-497dba69a2e3',NULL,'hw_rng_model','virtio'),('2026-01-22 00:08:15',NULL,'2026-01-22 00:08:22',1,170,'b553e317-111b-4cb9-b2db-497dba69a2e3',NULL,'image_id','612899ae-3852-48be-a8e3-ea7634c05e74'),('2026-01-22 00:08:15',NULL,'2026-01-22 00:08:22',1,171,'b553e317-111b-4cb9-b2db-497dba69a2e3',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-22 00:08:15',NULL,'2026-01-22 00:08:22',1,172,'b553e317-111b-4cb9-b2db-497dba69a2e3',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-22 00:08:15',NULL,'2026-01-22 00:08:22',1,173,'b553e317-111b-4cb9-b2db-497dba69a2e3',NULL,'container_format','bare'),('2026-01-22 00:08:15',NULL,'2026-01-22 00:08:22',1,174,'b553e317-111b-4cb9-b2db-497dba69a2e3',NULL,'disk_format','qcow2'),('2026-01-22 00:08:15',NULL,'2026-01-22 00:08:22',1,175,'b553e317-111b-4cb9-b2db-497dba69a2e3',NULL,'min_disk','0'),('2026-01-22 00:08:15',NULL,'2026-01-22 00:08:22',1,176,'b553e317-111b-4cb9-b2db-497dba69a2e3',NULL,'min_ram','0'),('2026-01-22 00:08:15',NULL,'2026-01-22 00:08:22',1,177,'b553e317-111b-4cb9-b2db-497dba69a2e3',NULL,'size','21430272');
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
INSERT INTO `volume_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `key`, `value`) VALUES ('2026-01-22 00:01:25',NULL,'2026-01-22 00:01:38',1,1,'7b3528f6-4789-4996-affe-f79d6d5910d7','Type','work'),('2026-01-22 00:01:27',NULL,'2026-01-22 00:01:37',1,2,'4c6eb488-79e4-4356-9d95-b4b94a311286','Type','work'),('2026-01-22 00:01:30',NULL,'2026-01-22 00:01:35',1,3,'5d64cfaf-a503-45a1-9d25-9e62734ae149','Type','work'),('2026-01-22 00:03:07',NULL,'2026-01-22 00:03:13',1,4,'8076897f-05b9-4297-af0e-48bb0cecf478','Type','work'),('2026-01-22 00:06:10',NULL,'2026-01-22 00:06:22',1,5,'299c203d-11ab-455f-a2ab-440a60c73aa4','src_backup_id','915cdce8-bec7-4728-b4ec-7d06e11f78f1');
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
INSERT INTO `volume_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_type_id`, `key`, `value`) VALUES ('2026-01-21 23:47:34',NULL,NULL,0,1,'3c404802-6af4-4748-9c04-b9f61d0e9050','multiattach','<is> True');
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2026-01-22 00:02:09',NULL,'2026-01-22 00:03:21',1,'2aaab34e-dd2a-4e17-887c-85baa8846773','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-378911499-1275883078',NULL,1,NULL),('2026-01-22 00:02:12',NULL,'2026-01-22 00:03:17',1,'3b8d99ff-e418-436b-8af6-d0a04f22371e','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1853888473-1807305321',NULL,1,NULL),('2026-01-21 23:47:32',NULL,NULL,0,'3c404802-6af4-4748-9c04-b9f61d0e9050','multiattach',NULL,1,NULL),('2026-01-22 00:02:44',NULL,'2026-01-22 00:07:56',1,'8b0d1340-f291-4657-af28-940f963260f9','tempest-scenario-type-luks-1960913990',NULL,1,NULL),('2026-01-21 23:09:57','2026-01-21 23:09:57',NULL,0,'c43622f9-d3cb-487a-a4f2-3a477dd15c98','__DEFAULT__',NULL,1,'Default Volume Type'),('2026-01-22 00:07:01',NULL,'2026-01-22 00:07:20',1,'ea16beeb-b577-4f09-a766-a8346746350a','tempest-scenario-type-luks-1422391033',NULL,1,NULL),('2026-01-22 00:02:12',NULL,'2026-01-22 00:03:17',1,'f9b5fd0c-0121-40bd-8092-c1cf3884e07d','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-530949306-658160424',NULL,1,NULL);
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
INSERT INTO `volumes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `ec2_id`, `user_id`, `project_id`, `host`, `size`, `availability_zone`, `status`, `attach_status`, `scheduled_at`, `launched_at`, `terminated_at`, `display_name`, `display_description`, `provider_location`, `provider_auth`, `snapshot_id`, `volume_type_id`, `source_volid`, `bootable`, `provider_geometry`, `_name_id`, `encryption_key_id`, `migration_status`, `replication_status`, `replication_extended_status`, `replication_driver_data`, `consistencygroup_id`, `provider_id`, `multiattach`, `previous_status`, `cluster_name`, `group_id`, `service_uuid`, `shared_targets`, `use_quota`) VALUES ('2026-01-22 00:02:46','2026-01-22 00:07:54','2026-01-22 00:07:55',1,'044beefe-4c9c-442d-80f5-77df810ad8c7',NULL,'08ab0fd4f3074df0a1ae55943c5c34e4','fc3cab1b1a7b4d81a2c0183f45084908','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:02:46','2026-01-22 00:02:58','2026-01-22 00:07:54','tempest-TestEncryptedCinderVolumes-volume-195767514',NULL,NULL,NULL,NULL,'8b0d1340-f291-4657-af28-940f963260f9',NULL,0,NULL,NULL,'ee393725-9bb8-43df-9bbc-06594f158361',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-22 00:07:03','2026-01-22 00:07:18','2026-01-22 00:07:19',1,'108261c4-7c9a-4900-aea6-77a89199108f',NULL,'19bb72c07b004b2cbc9628e145ed9a06','4bee9cd6c46a408cababd9be760cc6ae','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:07:04','2026-01-22 00:07:13','2026-01-22 00:07:18','tempest-TestVolumeBootPattern-volume-262849274',NULL,NULL,NULL,NULL,'ea16beeb-b577-4f09-a766-a8346746350a',NULL,1,NULL,NULL,'19b367bd-45f7-4f68-81d1-e2fe3c4261a2',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-22 00:02:22','2026-01-22 00:02:46','2026-01-22 00:02:50',1,'116a1db6-2b66-4afb-886a-3d2c956867f4',NULL,'e236ac2d6ac04b7797df4ae37dfce81b','bbe0bf0f5fe14d60832efdaf845b5237','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:02:22','2026-01-22 00:02:33','2026-01-22 00:02:46','tempest-TestInstancesWithCinderVolumes-volume-1369041780',NULL,NULL,NULL,NULL,'2aaab34e-dd2a-4e17-887c-85baa8846773',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-21 23:59:36','2026-01-21 23:59:50','2026-01-21 23:59:50',1,'11d93e0f-0920-43f1-9a0b-ceac3a4c80c1',NULL,'961497b27fd845c298796f7987dff8bb','73ffcc946ec547e083dfcfdf46b651b4','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-21 23:59:36','2026-01-21 23:59:43','2026-01-21 23:59:50','tempest-tempest.common.compute-volume-1636178452',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-22 00:02:17','2026-01-22 00:02:54','2026-01-22 00:02:58',1,'15d1a7fe-e5cd-4a26-b59f-8769b3e04c34',NULL,'e236ac2d6ac04b7797df4ae37dfce81b','bbe0bf0f5fe14d60832efdaf845b5237','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:02:17','2026-01-22 00:02:30','2026-01-22 00:02:54','tempest-TestInstancesWithCinderVolumes-volume-1308447540',NULL,NULL,NULL,NULL,'2aaab34e-dd2a-4e17-887c-85baa8846773',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-22 00:05:52','2026-01-22 00:06:21','2026-01-22 00:06:22',1,'1b53ddbf-cb53-4678-99d5-3024c177fdb2',NULL,'aab8583f35614558ae6a40b50d3119df','4655fadafba24b5db7b30502b0c37b50','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:05:52','2026-01-22 00:05:58','2026-01-22 00:06:21','tempest-TestVolumeBackupRestore-volume-146092509',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-21 23:49:18','2026-01-21 23:49:30','2026-01-21 23:49:31',1,'1d69e97a-fd1a-4f28-b091-1180a3e99085',NULL,'e67a084bd1924025a89bd90ae70e090a','f09c3054aeb04ea296a3876ff84b6316','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-21 23:49:18','2026-01-21 23:49:20','2026-01-21 23:49:30','tempest-VolumesAssistedSnapshotsTest-volume-276050665',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-21 23:55:55','2026-01-21 23:56:39','2026-01-21 23:56:39',1,'1e6a9045-f2a3-408e-9f8d-933c31562860',NULL,'341cf855e25942e992347243a54663a1','21775db7e3b84b63abb602ffdda5d1e4','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-21 23:55:55','2026-01-21 23:56:02','2026-01-21 23:56:39','tempest-TaggedBootDevicesTest_v242-volume-764827468',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-21 23:56:48','2026-01-21 23:56:59','2026-01-21 23:57:00',1,'20aff7ec-a0ae-4a87-b01e-ab46af38f8f5',NULL,'b565ceb84ab64ff7a7976188ff0aac51','8c5ea42ea1864d26b26844a38a374b68','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-21 23:56:48','2026-01-21 23:56:49','2026-01-21 23:56:59','tempest-TaggedAttachmentsTest-volume-1776382832',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-22 00:06:06','2026-01-22 00:06:21','2026-01-22 00:06:22',1,'299c203d-11ab-455f-a2ab-440a60c73aa4',NULL,'aab8583f35614558ae6a40b50d3119df','4655fadafba24b5db7b30502b0c37b50','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:06:06','2026-01-22 00:06:06','2026-01-22 00:06:21','tempest-TestVolumeBackupRestore-volume-146092509',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-21 23:54:51','2026-01-21 23:55:00','2026-01-21 23:55:01',1,'316154e4-e67d-49b5-bf04-0287dd6b0569',NULL,'6e4ba27ae66d494ea7d2a0e335e05458','3c0b858da02441efbb8876e157eb10b4','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-21 23:54:51','2026-01-21 23:54:51','2026-01-21 23:55:00','tempest-UpdateMultiattachVolumeNegativeTest-volume-1005373515',NULL,'{\"saved_features\":61}',NULL,NULL,'3c404802-6af4-4748-9c04-b9f61d0e9050',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-22 00:02:13','2026-01-22 00:03:08','2026-01-22 00:03:12',1,'36db83cb-ed79-4c00-83af-4c65f0049e1e',NULL,'e236ac2d6ac04b7797df4ae37dfce81b','bbe0bf0f5fe14d60832efdaf845b5237','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:02:13','2026-01-22 00:02:14','2026-01-22 00:03:08','tempest-TestInstancesWithCinderVolumes-volume-1954500579',NULL,NULL,NULL,NULL,'3b8d99ff-e418-436b-8af6-d0a04f22371e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-22 00:01:13','2026-01-22 00:01:18','2026-01-22 00:01:19',1,'49cf2089-e0c6-4e70-b80a-404cf80d26e9',NULL,'5a45e446f069408b88ee65709a88105d','5e0f215651654ea9a021d1711425ddc1','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:01:13','2026-01-22 00:01:14','2026-01-22 00:01:18','tempest-VolumesSnapshotsTestJSON-volume-609284966',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-21 23:51:07','2026-01-21 23:51:26','2026-01-21 23:51:27',1,'4a7885fc-abb4-4f6b-ad8b-5a311b24c68d',NULL,'3a39b367b793455e84c7ab95ffb8d231','782d762725a142abb32555887d980fa1','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-21 23:51:07','2026-01-21 23:51:18','2026-01-21 23:51:26','tempest-tempest.common.compute-volume-1541056554',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-22 00:01:27','2026-01-22 00:01:36','2026-01-22 00:01:37',1,'4c6eb488-79e4-4356-9d95-b4b94a311286',NULL,'0dcfaf0f82ba4d3d895ee8ed5108e548','c636ee9dad5d4178ac7648a6bc112ebd','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:01:28','2026-01-22 00:01:28','2026-01-22 00:01:36','tempest-VolumesTestJSON-volume-1379745345',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-22 00:07:22','2026-01-22 00:07:41','2026-01-22 00:07:42',1,'560bd419-127b-4686-80cf-a3c8668e203d',NULL,'19bb72c07b004b2cbc9628e145ed9a06','4bee9cd6c46a408cababd9be760cc6ae','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:07:22','2026-01-22 00:07:29','2026-01-22 00:07:41','tempest-TestVolumeBootPattern-volume-origin-447631921',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-22 00:01:30','2026-01-22 00:01:35','2026-01-22 00:01:35',1,'5d64cfaf-a503-45a1-9d25-9e62734ae149',NULL,'0dcfaf0f82ba4d3d895ee8ed5108e548','c636ee9dad5d4178ac7648a6bc112ebd','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:01:30','2026-01-22 00:01:30','2026-01-22 00:01:35','tempest-VolumesTestJSON-volume-1844204118',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-21 23:49:58','2026-01-21 23:50:16','2026-01-21 23:50:17',1,'6e7d1e95-0cfa-471f-b8b3-064f757ba735',NULL,'5cb56cbfc87844d8a6b1a931c687082a','b9269179afa746c5b390503d0c04dd80','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-21 23:49:58','2026-01-21 23:50:09','2026-01-21 23:50:16','tempest-tempest.common.compute-volume-1518168685',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-22 00:01:25','2026-01-22 00:01:37','2026-01-22 00:01:38',1,'7b3528f6-4789-4996-affe-f79d6d5910d7',NULL,'0dcfaf0f82ba4d3d895ee8ed5108e548','c636ee9dad5d4178ac7648a6bc112ebd','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:01:26','2026-01-22 00:01:26','2026-01-22 00:01:37','tempest-VolumesTestJSON-volume-518160633',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-22 00:14:46','2026-01-22 00:14:53','2026-01-22 00:14:53',1,'7fe50d17-3248-4c8e-9596-4baf94bd0ed2',NULL,'dbe6aab9c30c468fab4abab80c152360','e2f0b6c9b06543ee9aa50a06847cbf17','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:14:46','2026-01-22 00:14:46','2026-01-22 00:14:53','tempest-TestStampPattern-volume-775998363',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-22 00:03:07','2026-01-22 00:03:09','2026-01-22 00:03:13',1,'8076897f-05b9-4297-af0e-48bb0cecf478',NULL,'f434281656404b9db7b0d333753976e4','b242b61b3b8d48e6a99b3b1a5818ce85','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:03:07','2026-01-22 00:03:07','2026-01-22 00:03:09','tempest-VolumesGetTestJSON-Volume-578197390',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-21 23:58:26','2026-01-21 23:58:44','2026-01-21 23:58:45',1,'8401d3a2-9ced-4cf5-8a9c-dcf4b5a57517',NULL,'4852cc9cbe2f451f94416dcfbff2ed99','aa97ea95e1574468927ccc2f34c15d68','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-21 23:58:26','2026-01-21 23:58:36','2026-01-21 23:58:44','tempest-tempest.common.compute-volume-1975297458',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-21 23:55:53','2026-01-21 23:56:27','2026-01-21 23:56:27',1,'86f4517c-ad82-452c-96df-b6ee1ad3c96b',NULL,'cee7f8b8ecc84d35a92b4836c51b1b73','81d7a22e83d04172a9b390c93900a4ae','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-21 23:55:53','2026-01-21 23:55:54','2026-01-21 23:56:27','tempest-TaggedBootDevicesTest-volume-1908994832',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-21 23:55:44','2026-01-21 23:56:28','2026-01-21 23:56:29',1,'95bca597-be76-4f83-8cc7-50373ee57ee7',NULL,'cee7f8b8ecc84d35a92b4836c51b1b73','81d7a22e83d04172a9b390c93900a4ae','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-21 23:55:44','2026-01-21 23:55:52','2026-01-21 23:56:28','tempest-TaggedBootDevicesTest-volume-788945559',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-22 00:02:13','2026-01-22 00:03:13','2026-01-22 00:03:14',1,'a1433500-06d1-4e31-a57c-1c6680bef47b',NULL,'e236ac2d6ac04b7797df4ae37dfce81b','bbe0bf0f5fe14d60832efdaf845b5237','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:02:13','2026-01-22 00:02:13','2026-01-22 00:03:13','tempest-TestInstancesWithCinderVolumes-volume-1144702626',NULL,NULL,NULL,NULL,'f9b5fd0c-0121-40bd-8092-c1cf3884e07d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-21 23:59:46','2026-01-21 23:59:56','2026-01-21 23:59:57',1,'ac422bea-73d6-4334-bcaa-e51489147b0e',NULL,'991f8e1a8d70451aa56d6d6f688389a4','800b6c2954574115ad5fd60e98505ca3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-21 23:59:46','2026-01-21 23:59:47','2026-01-21 23:59:56','tempest-ServerStableDeviceRescueTest-volume-497807342',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-22 00:02:12','2026-01-22 00:03:14','2026-01-22 00:03:15',1,'ade897bc-3c85-4fb5-ace1-178b3eed5366',NULL,'e236ac2d6ac04b7797df4ae37dfce81b','bbe0bf0f5fe14d60832efdaf845b5237','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:02:13','2026-01-22 00:02:13','2026-01-22 00:03:14','tempest-TestInstancesWithCinderVolumes-volume-1707546549',NULL,NULL,NULL,NULL,'3b8d99ff-e418-436b-8af6-d0a04f22371e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-21 23:56:06','2026-01-21 23:56:36','2026-01-21 23:56:37',1,'af8899d7-c591-492d-bb7a-ae745a21af51',NULL,'341cf855e25942e992347243a54663a1','21775db7e3b84b63abb602ffdda5d1e4','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-21 23:56:06','2026-01-21 23:56:06','2026-01-21 23:56:36','tempest-TaggedBootDevicesTest_v242-volume-1807131247',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-22 00:07:44','2026-01-22 00:08:00','2026-01-22 00:08:00',1,'b36d6bda-8790-410a-93e2-60bf7b01c67a',NULL,'19bb72c07b004b2cbc9628e145ed9a06','4bee9cd6c46a408cababd9be760cc6ae','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:07:44','2026-01-22 00:07:51','2026-01-22 00:08:00','tempest-TestVolumeBootPattern-volume-origin-653465029',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-22 00:08:07','2026-01-22 00:08:21','2026-01-22 00:08:22',1,'b553e317-111b-4cb9-b2db-497dba69a2e3',NULL,'19bb72c07b004b2cbc9628e145ed9a06','4bee9cd6c46a408cababd9be760cc6ae','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:08:07','2026-01-22 00:08:15','2026-01-22 00:08:21','tempest-TestVolumeBootPattern-volume-origin-862349110',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-22 00:02:14','2026-01-22 00:02:58','2026-01-22 00:03:02',1,'b60902a9-a908-4cb6-82de-7b88bb688e7c',NULL,'e236ac2d6ac04b7797df4ae37dfce81b','bbe0bf0f5fe14d60832efdaf845b5237','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:02:14','2026-01-22 00:02:14','2026-01-22 00:02:58','tempest-TestInstancesWithCinderVolumes-volume-647664762',NULL,NULL,NULL,NULL,'f9b5fd0c-0121-40bd-8092-c1cf3884e07d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-21 23:54:49','2026-01-21 23:55:02','2026-01-21 23:55:03',1,'b75c120b-de09-47f4-8357-c1d1cbb61088',NULL,'6e4ba27ae66d494ea7d2a0e335e05458','3c0b858da02441efbb8876e157eb10b4','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-21 23:54:49','2026-01-21 23:54:50','2026-01-21 23:55:02','tempest-UpdateMultiattachVolumeNegativeTest-volume-1429289297',NULL,'{\"saved_features\":61}',NULL,NULL,'3c404802-6af4-4748-9c04-b9f61d0e9050',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-22 00:01:19','2026-01-22 00:02:12','2026-01-22 00:02:14',1,'b98e6b93-0295-4524-9a35-11be3d47fdc9',NULL,'689263f2bb1e4fb8bec8c4e9842e8941','f7ad93b5bdd64340ac516ee93f273edf','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:01:20','2026-01-22 00:01:28','2026-01-22 00:02:12','tempest-AttachVolumeMultiAttachTest-volume-442730121',NULL,'{\"saved_features\":61}',NULL,NULL,'3c404802-6af4-4748-9c04-b9f61d0e9050',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-22 00:02:19','2026-01-22 00:02:50','2026-01-22 00:02:53',1,'baf0f41d-78fe-4b02-ac69-b2ac582ee4b6',NULL,'e236ac2d6ac04b7797df4ae37dfce81b','bbe0bf0f5fe14d60832efdaf845b5237','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:02:19','2026-01-22 00:02:32','2026-01-22 00:02:50','tempest-TestInstancesWithCinderVolumes-volume-606388599',NULL,NULL,NULL,NULL,'2aaab34e-dd2a-4e17-887c-85baa8846773',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-21 23:55:55','2026-01-21 23:56:25','2026-01-21 23:56:26',1,'c7ac44c0-1bc4-4e7e-9dd6-e1b2dda64d85',NULL,'cee7f8b8ecc84d35a92b4836c51b1b73','81d7a22e83d04172a9b390c93900a4ae','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-21 23:55:55','2026-01-21 23:55:55','2026-01-21 23:56:25','tempest-TaggedBootDevicesTest-volume-355704163',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-22 00:05:09','2026-01-22 00:05:20','2026-01-22 00:05:21',1,'c803697a-6647-4aed-ad44-f61ef3779f97',NULL,'1c13f653a95c42b4b57576f90a7703e5','389a3216514a4d6b88242b36af5ccbd7','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:05:09','2026-01-22 00:05:16','2026-01-22 00:05:20','tempest-tempest.common.compute-volume-1236734548',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-22 00:02:13','2026-01-22 00:03:05','2026-01-22 00:03:07',1,'cc03badf-89df-4160-b7cb-28cd5c492e1b',NULL,'e236ac2d6ac04b7797df4ae37dfce81b','bbe0bf0f5fe14d60832efdaf845b5237','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:02:13','2026-01-22 00:02:14','2026-01-22 00:03:05','tempest-TestInstancesWithCinderVolumes-volume-1846954483',NULL,NULL,NULL,NULL,'f9b5fd0c-0121-40bd-8092-c1cf3884e07d',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-21 23:56:04','2026-01-21 23:56:37','2026-01-21 23:56:38',1,'ded57726-55d3-47a6-bbea-8d9c14ec92ef',NULL,'341cf855e25942e992347243a54663a1','21775db7e3b84b63abb602ffdda5d1e4','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-21 23:56:04','2026-01-21 23:56:04','2026-01-21 23:56:37','tempest-TaggedBootDevicesTest_v242-volume-458822910',NULL,NULL,NULL,NULL,'c43622f9-d3cb-487a-a4f2-3a477dd15c98',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-22 00:02:14','2026-01-22 00:03:03','2026-01-22 00:03:05',1,'e630859c-ee9c-4ab0-a253-5b95f1225858',NULL,'e236ac2d6ac04b7797df4ae37dfce81b','bbe0bf0f5fe14d60832efdaf845b5237','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:02:14','2026-01-22 00:02:14','2026-01-22 00:03:03','tempest-TestInstancesWithCinderVolumes-volume-171008272',NULL,NULL,NULL,NULL,'3b8d99ff-e418-436b-8af6-d0a04f22371e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1),('2026-01-22 00:01:50','2026-01-22 00:02:07','2026-01-22 00:02:09',1,'fbffa57f-e323-41ac-942b-520c4b30e0ce',NULL,'689263f2bb1e4fb8bec8c4e9842e8941','f7ad93b5bdd64340ac516ee93f273edf','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-22 00:01:50','2026-01-22 00:01:58','2026-01-22 00:02:07','tempest-AttachVolumeMultiAttachTest-volume-1111837157',NULL,'{\"saved_features\":61}',NULL,NULL,'3c404802-6af4-4748-9c04-b9f61d0e9050',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'733c7d2c-44b9-460c-9e95-63f152150f7a',0,1);
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2026-01-21 23:09:57','2026-01-21 23:09:57.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'612899ae-3852-48be-a8e3-ea7634c05e74','rbd://3759241a-7f1c-520d-ba17-879943ee2f00/images/612899ae-3852-48be-a8e3-ea7634c05e74/snap','2026-01-21 23:48:36','2026-01-21 23:48:36',NULL,0,'{\"store\": \"default_backend\"}','active'),(2,'06fc4968-440f-4479-9bfd-6800c8c1bb19','rbd://3759241a-7f1c-520d-ba17-879943ee2f00/images/06fc4968-440f-4479-9bfd-6800c8c1bb19/snap','2026-01-21 23:48:39','2026-01-21 23:48:39',NULL,0,'{\"store\": \"default_backend\"}','active'),(3,'17874750-5353-4b16-9767-24700c30b54a','rbd://3759241a-7f1c-520d-ba17-879943ee2f00/images/17874750-5353-4b16-9767-24700c30b54a/snap','2026-01-21 23:52:06','2026-01-21 23:52:30','2026-01-21 23:52:30',1,'{\"store\": \"default_backend\"}','deleted'),(4,'f4c12fd8-fcc6-4d48-8e4c-10477755ae09','rbd://3759241a-7f1c-520d-ba17-879943ee2f00/images/f4c12fd8-fcc6-4d48-8e4c-10477755ae09/snap','2026-01-21 23:52:08','2026-01-21 23:52:20','2026-01-21 23:52:20',1,'{\"store\": \"default_backend\"}','deleted'),(5,'6b2b318d-6478-493f-9af0-42b59f979eed','rbd://3759241a-7f1c-520d-ba17-879943ee2f00/images/6b2b318d-6478-493f-9af0-42b59f979eed/snap','2026-01-21 23:52:19','2026-01-21 23:52:22','2026-01-21 23:52:22',1,'{\"store\": \"default_backend\"}','deleted'),(6,'4541315c-146b-4da7-9d61-c6269d1cfbe1','rbd://3759241a-7f1c-520d-ba17-879943ee2f00/images/4541315c-146b-4da7-9d61-c6269d1cfbe1/snap','2026-01-21 23:53:40','2026-01-21 23:54:03','2026-01-21 23:54:03',1,'{\"store\": \"default_backend\"}','deleted'),(7,'0223d961-91ee-4365-bd6b-6373d4597205','rbd://3759241a-7f1c-520d-ba17-879943ee2f00/images/0223d961-91ee-4365-bd6b-6373d4597205/snap','2026-01-21 23:53:45','2026-01-21 23:54:01','2026-01-21 23:54:01',1,'{\"store\": \"default_backend\"}','deleted'),(8,'8a41e3a7-c872-4ebf-b06d-8bf06bec57b3','rbd://3759241a-7f1c-520d-ba17-879943ee2f00/images/8a41e3a7-c872-4ebf-b06d-8bf06bec57b3/snap','2026-01-21 23:53:49','2026-01-21 23:54:00','2026-01-21 23:54:00',1,'{\"store\": \"default_backend\"}','deleted'),(9,'e02f287e-32da-459a-a861-1ec342441330','rbd://3759241a-7f1c-520d-ba17-879943ee2f00/images/e02f287e-32da-459a-a861-1ec342441330/snap','2026-01-22 00:02:12','2026-01-22 00:03:20','2026-01-22 00:03:20',1,'{\"store\": \"default_backend\"}','deleted'),(10,'7b83b343-1bad-484c-bee1-5aa891cc60c7','rbd://3759241a-7f1c-520d-ba17-879943ee2f00/images/7b83b343-1bad-484c-bee1-5aa891cc60c7/snap','2026-01-22 00:04:10','2026-01-22 00:04:17','2026-01-22 00:04:17',1,'{\"store\": \"default_backend\"}','deleted'),(11,'2b03f14e-90d2-426a-90e5-bc530e44e33e','rbd://3759241a-7f1c-520d-ba17-879943ee2f00/images/2b03f14e-90d2-426a-90e5-bc530e44e33e/snap','2026-01-22 00:04:19','2026-01-22 00:04:25','2026-01-22 00:04:25',1,'{\"store\": \"default_backend\"}','deleted');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'612899ae-3852-48be-a8e3-ea7634c05e74','hw_rng_model','virtio','2026-01-21 23:48:33','2026-01-21 23:48:33',NULL,0),(2,'06fc4968-440f-4479-9bfd-6800c8c1bb19','hw_rng_model','virtio','2026-01-21 23:48:37','2026-01-21 23:48:37',NULL,0),(3,'f4c12fd8-fcc6-4d48-8e4c-10477755ae09','hw_scsi_model','virtio-scsi','2026-01-21 23:52:07','2026-01-21 23:52:20','2026-01-21 23:52:20',1),(4,'f4c12fd8-fcc6-4d48-8e4c-10477755ae09','hw_disk_bus','scsi','2026-01-21 23:52:07','2026-01-21 23:52:20','2026-01-21 23:52:20',1),(5,'f4c12fd8-fcc6-4d48-8e4c-10477755ae09','hw_cdrom_bus','scsi','2026-01-21 23:52:07','2026-01-21 23:52:20','2026-01-21 23:52:20',1),(6,'17874750-5353-4b16-9767-24700c30b54a','os_version','alt1','2026-01-21 23:52:09','2026-01-21 23:52:30','2026-01-21 23:52:30',1),(7,'17874750-5353-4b16-9767-24700c30b54a','os_distro','value2','2026-01-21 23:52:09','2026-01-21 23:52:30','2026-01-21 23:52:30',1),(8,'17874750-5353-4b16-9767-24700c30b54a','architecture','value3','2026-01-21 23:52:20','2026-01-21 23:52:30','2026-01-21 23:52:30',1);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('0223d961-91ee-4365-bd6b-6373d4597205','tempest-ListImageFiltersTestJSON-image-110958562',1024,'deleted','2026-01-21 23:53:42','2026-01-21 23:54:02','2026-01-21 23:54:02',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','5100157e7fb64e589ed94092969e7abc',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('06fc4968-440f-4479-9bfd-6800c8c1bb19','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2026-01-21 23:48:37','2026-01-21 23:48:39',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','e5a9114b36bd46cc91c9326bf301943f',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('17874750-5353-4b16-9767-24700c30b54a','tempest-image-180636518',1024,'deleted','2026-01-21 23:52:05','2026-01-21 23:52:30','2026-01-21 23:52:30',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','9c7e59283e67440690d322a7bae0772f',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('2b03f14e-90d2-426a-90e5-bc530e44e33e','tempest-scenario-img--1027861216',21430272,'deleted','2026-01-22 00:04:17','2026-01-22 00:04:26','2026-01-22 00:04:26',1,'qcow2','bare','c8fc807773e5354afe61636071771906','b6116f0e36cf47abb510495dbee8f036',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('4541315c-146b-4da7-9d61-c6269d1cfbe1','tempest-ListImageFiltersTestJSON-image-1565320249',1024,'deleted','2026-01-21 23:53:37','2026-01-21 23:54:03','2026-01-21 23:54:03',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','5100157e7fb64e589ed94092969e7abc',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('612899ae-3852-48be-a8e3-ea7634c05e74','cirros-0.6.2-x86_64-disk.img',21430272,'active','2026-01-21 23:48:33','2026-01-21 23:48:36',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','e5a9114b36bd46cc91c9326bf301943f',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('6b2b318d-6478-493f-9af0-42b59f979eed','tempest-image-694008553',1575,'deleted','2026-01-21 23:52:18','2026-01-21 23:52:22','2026-01-21 23:52:22',1,'qcow2','bare','0ac1a9c5eea42bb7577d9e5a13c9a067','a6d95c41b2d94359a49f0b054a2a0901',0,129,0,NULL,'private',0,'sha512','7b3c0452d5b91a7d32882f1f44cbc0276f7c8b58957a312abe0cb4131e6d704aff200b9d24306ddfc2b4022bb48743867d6da2cb5ce63e65fe821917ece2629a'),('7b83b343-1bad-484c-bee1-5aa891cc60c7','tempest-scenario-img--431322070',21430272,'deleted','2026-01-22 00:04:09','2026-01-22 00:04:17','2026-01-22 00:04:17',1,'qcow2','bare','c8fc807773e5354afe61636071771906','b6116f0e36cf47abb510495dbee8f036',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('8a41e3a7-c872-4ebf-b06d-8bf06bec57b3','tempest-ListImageFiltersTestJSON-image-1482847278',1024,'deleted','2026-01-21 23:53:47','2026-01-21 23:54:00','2026-01-21 23:54:00',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','5100157e7fb64e589ed94092969e7abc',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('e02f287e-32da-459a-a861-1ec342441330','tempest-scenario-img--1518198378',21430272,'deleted','2026-01-22 00:02:09','2026-01-22 00:03:20','2026-01-22 00:03:20',1,'qcow2','bare','c8fc807773e5354afe61636071771906','bbe0bf0f5fe14d60832efdaf845b5237',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('f4c12fd8-fcc6-4d48-8e4c-10477755ae09',NULL,21430272,'deleted','2026-01-21 23:52:07','2026-01-21 23:52:20','2026-01-21 23:52:20',1,'qcow2','bare','c8fc807773e5354afe61636071771906','4bfcf66655924076b027b4f638fbc758',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b');
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2026-01-21 23:09:00',NULL),(1,2,'image','CIM_RASD_','2026-01-21 23:09:00',NULL),(1,3,NULL,'CIM_SASD_','2026-01-21 23:09:01',NULL),(1,9,'image','hw_','2026-01-21 23:09:01',NULL),(1,10,'image','hw_','2026-01-21 23:09:01',NULL),(1,14,'image',NULL,'2026-01-21 23:09:01',NULL),(1,19,'image','hw_','2026-01-21 23:09:01',NULL),(1,25,'image','hw_','2026-01-21 23:09:02',NULL),(1,29,'image',NULL,'2026-01-21 23:09:02',NULL),(1,30,'image',NULL,'2026-01-21 23:09:02',NULL),(1,31,'image',NULL,'2026-01-21 23:09:02',NULL),(1,32,'image',NULL,'2026-01-21 23:09:02',NULL),(2,1,NULL,'CIM_PASD_','2026-01-21 23:09:00',NULL),(2,8,NULL,'hw_','2026-01-21 23:09:01',NULL),(2,9,NULL,'hw_','2026-01-21 23:09:01',NULL),(2,10,NULL,'hw_','2026-01-21 23:09:01',NULL),(2,11,NULL,NULL,'2026-01-21 23:09:01',NULL),(2,13,NULL,NULL,'2026-01-21 23:09:01',NULL),(2,14,NULL,NULL,'2026-01-21 23:09:01',NULL),(2,15,NULL,NULL,'2026-01-21 23:09:01',NULL),(2,16,NULL,'hw_','2026-01-21 23:09:01',NULL),(2,19,NULL,'hw_','2026-01-21 23:09:01',NULL),(2,22,NULL,NULL,'2026-01-21 23:09:01',NULL),(2,23,NULL,'hw_','2026-01-21 23:09:01',NULL),(2,24,NULL,'traits:','2026-01-21 23:09:01',NULL),(2,25,NULL,'hw_','2026-01-21 23:09:01',NULL),(2,26,NULL,NULL,'2026-01-21 23:09:02',NULL),(2,28,NULL,NULL,'2026-01-21 23:09:02',NULL),(2,29,NULL,NULL,'2026-01-21 23:09:02',NULL),(2,30,NULL,NULL,'2026-01-21 23:09:02',NULL),(2,31,NULL,NULL,'2026-01-21 23:09:02',NULL),(2,32,NULL,NULL,'2026-01-21 23:09:02',NULL),(2,33,NULL,'cinder_','2026-01-21 23:09:02',NULL),(3,1,NULL,'CIM_PASD_','2026-01-21 23:09:00',NULL),(3,2,NULL,'CIM_RASD_','2026-01-21 23:09:00',NULL),(3,3,NULL,'CIM_SASD_','2026-01-21 23:09:01',NULL),(3,4,NULL,'CIM_VSSD_','2026-01-21 23:09:01',NULL),(3,5,NULL,NULL,'2026-01-21 23:09:01',NULL),(3,6,NULL,NULL,'2026-01-21 23:09:01',NULL),(3,7,NULL,NULL,'2026-01-21 23:09:01',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2026-01-21 23:09:01',NULL),(4,1,NULL,'CIM_PASD_','2026-01-21 23:09:00',NULL),(4,2,NULL,'CIM_RASD_','2026-01-21 23:09:00',NULL),(4,3,NULL,'CIM_SASD_','2026-01-21 23:09:01',NULL),(4,4,NULL,'CIM_VSSD_','2026-01-21 23:09:01',NULL),(4,8,NULL,'hw:','2026-01-21 23:09:01',NULL),(4,9,NULL,'hw:','2026-01-21 23:09:01',NULL),(4,10,NULL,'hw:','2026-01-21 23:09:01',NULL),(4,12,NULL,'capabilities:','2026-01-21 23:09:01',NULL),(4,16,NULL,'hw:','2026-01-21 23:09:01',NULL),(4,17,NULL,NULL,'2026-01-21 23:09:01',NULL),(4,18,NULL,NULL,'2026-01-21 23:09:01',NULL),(4,19,NULL,'hw:','2026-01-21 23:09:01',NULL),(4,20,NULL,NULL,'2026-01-21 23:09:01',NULL),(4,21,NULL,NULL,'2026-01-21 23:09:01',NULL),(4,23,NULL,'hw:','2026-01-21 23:09:01',NULL),(4,24,NULL,'traits:','2026-01-21 23:09:01',NULL),(4,25,NULL,'hw:','2026-01-21 23:09:02',NULL),(5,1,'scheduler_hints',NULL,'2026-01-21 23:09:00',NULL),(5,30,'metadata',NULL,'2026-01-21 23:09:02',NULL),(5,31,'metadata',NULL,'2026-01-21 23:09:02',NULL),(5,32,'metadata',NULL,'2026-01-21 23:09:02',NULL),(6,30,NULL,NULL,'2026-01-21 23:09:02',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2026-01-21 23:09:00',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2026-01-21 23:09:00',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2026-01-21 23:09:01',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2026-01-21 23:09:01',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-01-21 23:09:01',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-01-21 23:09:01',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2026-01-21 23:09:01',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2026-01-21 23:09:01',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2026-01-21 23:09:01',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2026-01-21 23:09:01',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2026-01-21 23:09:01',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2026-01-21 23:09:01',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2026-01-21 23:09:01',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2026-01-21 23:09:01',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-21 23:09:01',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-21 23:09:01',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-21 23:09:01',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2026-01-21 23:09:01',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2026-01-21 23:09:01',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-21 23:09:01',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-21 23:09:01',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-21 23:09:01',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2026-01-21 23:09:01',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2026-01-21 23:09:01',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-21 23:09:01',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-21 23:09:02',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2026-01-21 23:09:02',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2026-01-21 23:09:02',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2026-01-21 23:09:02',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2026-01-21 23:09:02',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2026-01-21 23:09:02',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2026-01-21 23:09:02',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2026-01-21 23:09:02',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2026-01-21 23:09:01',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2026-01-21 23:09:01',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2026-01-21 23:09:01',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2026-01-21 23:09:02',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2026-01-21 23:09:02',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2026-01-21 23:09:02',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2026-01-21 23:09:02',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-21 23:09:02',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-21 23:09:02',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-01-21 23:09:02',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-01-21 23:09:02',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-21 23:09:02',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2026-01-21 23:09:02',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2026-01-21 23:09:02',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2026-01-21 23:09:02',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2026-01-21 23:09:02',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2026-01-21 23:09:02',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2026-01-21 23:09:02',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2026-01-21 23:09:02',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2026-01-21 23:09:02',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-21 23:09:02',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-21 23:09:02',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-21 23:09:02',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2026-01-21 23:09:00',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2026-01-21 23:09:00',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2026-01-21 23:09:00',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2026-01-21 23:09:00',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2026-01-21 23:09:00',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2026-01-21 23:09:00',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2026-01-21 23:09:00',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2026-01-21 23:09:00',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-01-21 23:09:00',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2026-01-21 23:09:00',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2026-01-21 23:09:00',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2026-01-21 23:09:00',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2026-01-21 23:09:00',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2026-01-21 23:09:00',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-01-21 23:09:01',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2026-01-21 23:09:01',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2026-01-21 23:09:01',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2026-01-21 23:09:01',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2026-01-21 23:09:01',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2026-01-21 23:09:01',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2026-01-21 23:09:01',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2026-01-21 23:09:01',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2026-01-21 23:09:01',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2026-01-21 23:09:01',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2026-01-21 23:09:01',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2026-01-21 23:09:01',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2026-01-21 23:09:01',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-21 23:09:01',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2026-01-21 23:09:01',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2026-01-21 23:09:01',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2026-01-21 23:09:01',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-21 23:09:01',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-21 23:09:01',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-21 23:09:01',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2026-01-21 23:09:01',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2026-01-21 23:09:01',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2026-01-21 23:09:01',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2026-01-21 23:09:01',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-21 23:09:01',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-01-21 23:09:01',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-01-21 23:09:01',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2026-01-21 23:09:01',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2026-01-21 23:09:01',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2026-01-21 23:09:01',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2026-01-21 23:09:01',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-21 23:09:01',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2026-01-21 23:09:01',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2026-01-21 23:09:01',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-21 23:09:01',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-21 23:09:01',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-21 23:09:01',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2026-01-21 23:09:01',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-21 23:09:01',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-21 23:09:01',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-21 23:09:01',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-21 23:09:01',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2026-01-21 23:09:01',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2026-01-21 23:09:01',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2026-01-21 23:09:01',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-01-21 23:09:01',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-01-21 23:09:01',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-01-21 23:09:01',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-01-21 23:09:01',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-01-21 23:09:01',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-01-21 23:09:01',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2026-01-21 23:09:01',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2026-01-21 23:09:01',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-21 23:09:01',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-21 23:09:01',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2026-01-21 23:09:01',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2026-01-21 23:09:01',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2026-01-21 23:09:01',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2026-01-21 23:09:01',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2026-01-21 23:09:01',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-21 23:09:01',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2026-01-21 23:09:01',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-01-21 23:09:01',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-01-21 23:09:01',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2026-01-21 23:09:02',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2026-01-21 23:09:02',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2026-01-21 23:09:02',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2026-01-21 23:09:02',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2026-01-21 23:09:02',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2026-01-21 23:09:02',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-01-21 23:09:02',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2026-01-21 23:09:02',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-01-21 23:09:02',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2026-01-21 23:09:02',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2026-01-21 23:09:02',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2026-01-21 23:09:02',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2026-01-21 23:09:02',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2026-01-21 23:09:02',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2026-01-21 23:09:02',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2026-01-21 23:09:02',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-01-21 23:09:02',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-01-21 23:09:02',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2026-01-21 23:09:02',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2026-01-21 23:09:02',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2026-01-21 23:09:00',NULL),(2,'OS::Glance::Image',1,'2026-01-21 23:09:00',NULL),(3,'OS::Nova::Aggregate',1,'2026-01-21 23:09:00',NULL),(4,'OS::Nova::Flavor',1,'2026-01-21 23:09:00',NULL),(5,'OS::Nova::Server',1,'2026-01-21 23:09:00',NULL),(6,'OS::Trove::Instance',1,'2026-01-21 23:09:02',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `external_id` (`external_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','0228906e289f49ac86000f5d8be7b934','3e8e30a1ae274ce9b972eec5113440da','6dfeff807890451d950a600b521661b9',0),('UserProject','0228906e289f49ac86000f5d8be7b934','3e8e30a1ae274ce9b972eec5113440da','8e681675670548328c4ae3e21eb5df72',0),('UserProject','6d0028a6ebcc4a34b205c0a27de00597','3e8e30a1ae274ce9b972eec5113440da','6dfeff807890451d950a600b521661b9',0),('UserProject','6d0028a6ebcc4a34b205c0a27de00597','3e8e30a1ae274ce9b972eec5113440da','6e90bbc0e8b94ddcab2a0b0041ad6d6e',0),('UserProject','8c6a7500640f40b1af71d3803c3a85dc','3e8e30a1ae274ce9b972eec5113440da','6dfeff807890451d950a600b521661b9',0),('UserProject','8c6a7500640f40b1af71d3803c3a85dc','3e8e30a1ae274ce9b972eec5113440da','6e90bbc0e8b94ddcab2a0b0041ad6d6e',0),('UserProject','9161a0e438fd43c1a6f2614e7947727f','3e8e30a1ae274ce9b972eec5113440da','6dfeff807890451d950a600b521661b9',0),('UserProject','9161a0e438fd43c1a6f2614e7947727f','3e8e30a1ae274ce9b972eec5113440da','6e90bbc0e8b94ddcab2a0b0041ad6d6e',0),('UserProject','a8a5722f544c4e1b9905e91d63b82d96','3e8e30a1ae274ce9b972eec5113440da','6dfeff807890451d950a600b521661b9',0),('UserProject','a8a5722f544c4e1b9905e91d63b82d96','3e8e30a1ae274ce9b972eec5113440da','6e90bbc0e8b94ddcab2a0b0041ad6d6e',0),('UserProject','ac7c110b3bf94315958af6a870517373','a2ff6353fc4a495895f6769c710dd0f5','6dfeff807890451d950a600b521661b9',0),('UserProject','ac7c110b3bf94315958af6a870517373','e5a9114b36bd46cc91c9326bf301943f','6dfeff807890451d950a600b521661b9',0),('UserProject','ac7c110b3bf94315958af6a870517373','e5a9114b36bd46cc91c9326bf301943f','92ebb9c9566b4e1cb24f3f9d1deabfdd',0),('UserProject','c6dd2f2905824c17b8a204db256c15be','3e8e30a1ae274ce9b972eec5113440da','6dfeff807890451d950a600b521661b9',0),('UserProject','c6dd2f2905824c17b8a204db256c15be','3e8e30a1ae274ce9b972eec5113440da','6e90bbc0e8b94ddcab2a0b0041ad6d6e',0),('UserProject','eb4862c0e23948f4ba99072c812b54c2','3e8e30a1ae274ce9b972eec5113440da','6dfeff807890451d950a600b521661b9',0),('UserProject','eb4862c0e23948f4ba99072c812b54c2','3e8e30a1ae274ce9b972eec5113440da','6e90bbc0e8b94ddcab2a0b0041ad6d6e',0),('UserProject','f81ebd55cbf14f05ba753a6d9e0ebd6e','3e8e30a1ae274ce9b972eec5113440da','6dfeff807890451d950a600b521661b9',0),('UserProject','f81ebd55cbf14f05ba753a6d9e0ebd6e','3e8e30a1ae274ce9b972eec5113440da','6e90bbc0e8b94ddcab2a0b0041ad6d6e',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('089e655609ef4e8c8e765ce1b6f2c16a',NULL,'public','9628e0b3c48a43c9a28a2067bb180a8c','https://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('099eae7730254e97ab43ac60ed35419c',NULL,'internal','3c853f309bc44f0f877a4217b3af5019','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('178e4dfc1f964081b29cbf26e1455360',NULL,'public','f713c86201d14330abcb99f86caa5734','https://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('20c4810db19245d5a00d0988ccd1fa6a',NULL,'internal','9df97733489048c08c2eca494189a569','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('235fb00d8f1643db9ce8a6bbd7654090',NULL,'public','9df97733489048c08c2eca494189a569','https://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('30e38a4cffa64f47847df59dda972f0e',NULL,'internal','4852131d560d4d558ec29a60dba761be','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('35b5547513ad4a96900188e483bdac0f',NULL,'internal','c1746ec304274dbbb5c009b751d15a1e','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('376bf632510c4057bc78a282131e70c6',NULL,'public','59b5067377f24de8b9da7b1826366170','https://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('85cb72450997422bacd31c1619484464',NULL,'internal','9628e0b3c48a43c9a28a2067bb180a8c','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('a0fedee3d8cc47648c5a5a21e63578c7',NULL,'internal','59b5067377f24de8b9da7b1826366170','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('b2ab02c2515e40b5a40ea73793091ed1',NULL,'public','c1746ec304274dbbb5c009b751d15a1e','https://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('bb0cad10db954618aa2dc17aa1311173',NULL,'public','3c853f309bc44f0f877a4217b3af5019','https://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('c731ada9b9e54f6c8dd4539b87d3c807',NULL,'public','4852131d560d4d558ec29a60dba761be','https://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('e5b5c1a8b55c4c4791eef692b947a23a',NULL,'internal','4f54e216d34b4ba48069381c90ee33ac','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('ef12886f573443c785f931ebe90ac6c6',NULL,'internal','f713c86201d14330abcb99f86caa5734','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('f1b27f89acb94726b78d066df20d0207',NULL,'public','4f54e216d34b4ba48069381c90ee33ac','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('6dfeff807890451d950a600b521661b9','8e681675670548328c4ae3e21eb5df72'),('8e681675670548328c4ae3e21eb5df72','2b5ffe180a2e4fe0b1de66b638c9c85b');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'ac7c110b3bf94315958af6a870517373','default','admin',0,NULL),(2,'8c6a7500640f40b1af71d3803c3a85dc','default','neutron',0,NULL),(3,'9161a0e438fd43c1a6f2614e7947727f','default','glance',0,NULL),(4,'6d0028a6ebcc4a34b205c0a27de00597','default','nova',0,NULL),(5,'c6dd2f2905824c17b8a204db256c15be','default','barbican',0,NULL),(6,'a8a5722f544c4e1b9905e91d63b82d96','default','cinder',0,NULL),(7,'f81ebd55cbf14f05ba753a6d9e0ebd6e','default','ceilometer',0,NULL),(8,'eb4862c0e23948f4ba99072c812b54c2','default','placement',0,NULL),(9,'0228906e289f49ac86000f5d8be7b934','default','swift',0,NULL),(10,'ce87e1d35e2a46ff864dd81d9706ca6b','default','demo_tempestconf',0,NULL),(11,'33b86325be15482cbc486b553260f94c','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$7Rs4zkvjNFCkSbJBkaDo3OLVdGSLoI3qlU94k/FkPehV8C6b2ziKm',1769036971559524,NULL,'2026-01-21 23:09:31'),(2,2,NULL,0,'$2b$12$9lKJndUbVMj8MyvznctYU.ncOPgLLQ6rbKZb.d9AdQPhLxQL3Lr2W',1769037033024187,NULL,'2026-01-21 23:10:33'),(3,3,NULL,0,'$2b$12$.9QpnZEDctruItMydIwDNeKhBvePlckMGML/IKSX2KgPuPEVGl0de',1769037035111072,NULL,'2026-01-21 23:10:35'),(4,4,NULL,0,'$2b$12$aHJSikRzm3nMYq5tG.E6mOL0MrYL0RTy8/Tc8gB6i1kn6U2slEQ9q',1769037038003346,NULL,'2026-01-21 23:10:38'),(5,5,NULL,0,'$2b$12$XWj5W.3QJrY7dNOUY5cGB.8aPgHqGJbPXXWQEzCyOm5fcZ5uHVkoy',1769037041192188,NULL,'2026-01-21 23:10:41'),(6,6,NULL,0,'$2b$12$Ux5RDD3AQCYG5p3.I0F5Fe0TM0PqFz3kgX.1kYHNdoTbCRUAL6T.6',1769037046308617,NULL,'2026-01-21 23:10:46'),(7,7,NULL,0,'$2b$12$u5w5z6LlOCHEbTqdRqw88uUHu9muGorZvKIw/3kLHfepT0qD7SYqO',1769037055696005,NULL,'2026-01-21 23:10:55'),(8,8,NULL,0,'$2b$12$w6LkM74l5MzwTm1PP0mTRO9mNnKUl9Ij.Y2VR4m0fAnf2GlJFHtni',1769037059565273,NULL,'2026-01-21 23:10:59'),(9,9,NULL,0,'$2b$12$id0fpjXh4YbTJQRMKCfRaebbGMA4pAMjfdg/52DGDPkiQY6PtkOw2',1769038016485901,NULL,'2026-01-21 23:26:56'),(10,10,NULL,0,'$2b$12$Nlah.ppK.cyf5gW23j/zIeJ0.q6viOUCaZMA3conrxEYEwgJ0QCEC',1769039305595199,NULL,'2026-01-21 23:48:25'),(11,11,NULL,0,'$2b$12$Y34idazYaoNvHCwpqIbon.bR2t7l/oRZ5M.QXY2lTz7Q8oY1xct.e',1769039306165195,NULL,'2026-01-21 23:48:26');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('3e8e30a1ae274ce9b972eec5113440da','service','{}','service',1,'default','default',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('a2ff6353fc4a495895f6769c710dd0f5','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('c3b2aee15e7f48af8c36b6e6a547eada','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1),('e5a9114b36bd46cc91c9326bf301943f','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=482 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,'e5aa35b2ff3242c3ac3fb9e7c3cd01f4',NULL,NULL,NULL,NULL,'2026-01-21 23:48:56',NULL,'2026-01-21 23:48:56',NULL,NULL),(2,NULL,NULL,'187cca70a4874031ba7f6ea5b84fdc84',NULL,NULL,NULL,NULL,'2026-01-21 23:48:57',NULL,'2026-01-21 23:48:57',NULL,NULL),(3,NULL,'f77db394cd3c4f839b052a3608a07e27',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:48:58',NULL,'2026-01-21 23:48:58',NULL,NULL),(4,NULL,'7dc32682473b4ce2993573383981b1c5',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:48:59',NULL,'2026-01-21 23:48:59',NULL,NULL),(5,NULL,NULL,'cbb8dbc0e36c41279975f13b19d4df38',NULL,NULL,NULL,NULL,'2026-01-21 23:49:02',NULL,'2026-01-21 23:49:02',NULL,NULL),(6,NULL,NULL,'3a757a96edc74249931bcf97a20c67ae',NULL,NULL,NULL,NULL,'2026-01-21 23:49:02',NULL,'2026-01-21 23:49:02',NULL,NULL),(7,NULL,NULL,'ae6a7ba7e0ab41e4baae2848ff2a9056',NULL,NULL,NULL,NULL,'2026-01-21 23:49:03',NULL,'2026-01-21 23:49:03',NULL,NULL),(8,NULL,NULL,'787f8789c0d6429699fbf697265c37d2',NULL,NULL,NULL,NULL,'2026-01-21 23:49:03',NULL,'2026-01-21 23:49:03',NULL,NULL),(9,NULL,'7daddc44be7f4ca4b36e74835d6d7378',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:03',NULL,'2026-01-21 23:49:03',NULL,NULL),(10,NULL,'b2b52ca121e04ba8b099667cfd556b2d',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:04',NULL,'2026-01-21 23:49:04',NULL,NULL),(11,NULL,'f26a44ae25264906bf680de0ebee16af',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:04',NULL,'2026-01-21 23:49:04',NULL,NULL),(12,NULL,'19e6d6772de148d9841addc123171a20',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:06',NULL,'2026-01-21 23:49:06',NULL,NULL),(13,NULL,NULL,'b4a1b3e1aaa84e91a8f8f0810839c8dd',NULL,NULL,NULL,NULL,'2026-01-21 23:49:09',NULL,'2026-01-21 23:49:09',NULL,NULL),(14,NULL,NULL,'0825159e67a44083b0cbe850e98cc8c2',NULL,NULL,NULL,NULL,'2026-01-21 23:49:09',NULL,'2026-01-21 23:49:09',NULL,NULL),(15,NULL,NULL,'806b7c1d34704e89a33e329d3bbe5960',NULL,NULL,NULL,NULL,'2026-01-21 23:49:10',NULL,'2026-01-21 23:49:10',NULL,NULL),(16,NULL,NULL,'f403f4dab2404496b0d27184bd3066f9',NULL,NULL,NULL,NULL,'2026-01-21 23:49:10',NULL,'2026-01-21 23:49:10',NULL,NULL),(17,NULL,NULL,'557f45e9e9b94bf5bf0d2714f43d7acc',NULL,NULL,NULL,NULL,'2026-01-21 23:49:11',NULL,'2026-01-21 23:49:11',NULL,NULL),(18,NULL,'67edcd3f4ad54a59aeba4e90c8dee6ec',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:11',NULL,'2026-01-21 23:49:11',NULL,NULL),(19,NULL,'ab9a2f256bf24a92abc314e5b9217778',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:12',NULL,'2026-01-21 23:49:12',NULL,NULL),(20,NULL,'d19dab6ce657449daba06dff1d38b236',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:13',NULL,'2026-01-21 23:49:13',NULL,NULL),(21,NULL,'86fdade7989945bd8323e26c66bed681',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:13',NULL,'2026-01-21 23:49:13',NULL,NULL),(22,NULL,'db7d815a06c8468489c0a407ad741b53',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:14',NULL,'2026-01-21 23:49:14',NULL,NULL),(23,NULL,NULL,'4ccfd2c6aee643edac54fa9e1c4fe03e',NULL,NULL,NULL,NULL,'2026-01-21 23:49:16',NULL,'2026-01-21 23:49:16',NULL,NULL),(24,NULL,NULL,'e77b3eb0808b4683b63a73d6fcb3d2c0',NULL,NULL,NULL,NULL,'2026-01-21 23:49:17',NULL,'2026-01-21 23:49:17',NULL,NULL),(25,NULL,NULL,'0e1fc73b9d264ea498b20903e1e0a911',NULL,NULL,NULL,NULL,'2026-01-21 23:49:18',NULL,'2026-01-21 23:49:18',NULL,NULL),(26,NULL,NULL,'c1b890a0dabc4db8b775a35064af2d2e',NULL,NULL,NULL,NULL,'2026-01-21 23:49:18',NULL,'2026-01-21 23:49:18',NULL,NULL),(27,NULL,'f79fd119b49244c5bf216f70104ee2d6',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:18',NULL,'2026-01-21 23:49:18',NULL,NULL),(28,NULL,NULL,'1e005ccb7d8e437aa01d994dae85a8f2',NULL,NULL,NULL,NULL,'2026-01-21 23:49:19',NULL,'2026-01-21 23:49:19',NULL,NULL),(29,NULL,NULL,'c18b414179b74b94a12349ab5057938b',NULL,NULL,NULL,NULL,'2026-01-21 23:49:19',NULL,'2026-01-21 23:49:19',NULL,NULL),(30,NULL,'2ade8571870b4c0fb5202c08227d1f68',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:19',NULL,'2026-01-21 23:49:19',NULL,NULL),(31,NULL,'fb8a8927f8d947ddbc3544022648b9a3',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:19',NULL,'2026-01-21 23:49:19',NULL,NULL),(32,NULL,'9454505f017e43d9bddf53a059184b4b',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:20',NULL,'2026-01-21 23:49:20',NULL,NULL),(33,NULL,'6cd3ff8867af4badaafccfa54494efb2',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:20',NULL,'2026-01-21 23:49:20',NULL,NULL),(34,NULL,'3a6f3b95386b490eb958ed78a8348693',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:21',NULL,'2026-01-21 23:49:21',NULL,NULL),(35,NULL,NULL,'fdbe8dd5dc3446649a00500b470a6738',NULL,NULL,NULL,NULL,'2026-01-21 23:49:35',NULL,'2026-01-21 23:49:35',NULL,NULL),(36,NULL,NULL,'781d79a883b645229b61af8477325652',NULL,NULL,NULL,NULL,'2026-01-21 23:49:35',NULL,'2026-01-21 23:49:35',NULL,NULL),(37,NULL,'c6fc7bac3da74113a0460df238dbdf10',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:37',NULL,'2026-01-21 23:49:37',NULL,NULL),(38,NULL,'49bc6606f9a44bf8bd4b3c0031adc3a1',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:39',NULL,'2026-01-21 23:49:39',NULL,NULL),(39,NULL,NULL,'4a39e8c45ab9400f9db69b6b26da118d',NULL,NULL,NULL,NULL,'2026-01-21 23:49:44',NULL,'2026-01-21 23:49:44',NULL,NULL),(40,NULL,'eba9589aaf244032a7c172471c8eca4a',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:44',NULL,'2026-01-21 23:49:44',NULL,NULL),(41,NULL,NULL,'01da7b58ee464dc3a119a31bdcb7a961',NULL,NULL,NULL,NULL,'2026-01-21 23:49:44',NULL,'2026-01-21 23:49:44',NULL,NULL),(42,NULL,NULL,'50e2c26ce696407f930175cb8bd6a88c',NULL,NULL,NULL,NULL,'2026-01-21 23:49:44',NULL,'2026-01-21 23:49:44',NULL,NULL),(43,NULL,'714b5d58c02b4b469934e310e4a7cf57',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:47',NULL,'2026-01-21 23:49:47',NULL,NULL),(44,NULL,'2a2cc4ef35004864a95cd02c6933f36f',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:48',NULL,'2026-01-21 23:49:48',NULL,NULL),(45,NULL,NULL,'1e177466e6f54034be1e2f4c453061fa',NULL,NULL,NULL,NULL,'2026-01-21 23:49:49',NULL,'2026-01-21 23:49:49',NULL,NULL),(46,NULL,NULL,'e67a084bd1924025a89bd90ae70e090a',NULL,NULL,NULL,NULL,'2026-01-21 23:49:49',NULL,'2026-01-21 23:49:49',NULL,NULL),(47,NULL,NULL,'b66dfbf9952a436289a5846dd49f8325',NULL,NULL,NULL,NULL,'2026-01-21 23:49:50',NULL,'2026-01-21 23:49:50',NULL,NULL),(48,NULL,'54721d28ff2040c7bfc9fe6e859be4da',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:50',NULL,'2026-01-21 23:49:50',NULL,NULL),(49,NULL,'f09c3054aeb04ea296a3876ff84b6316',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:51',NULL,'2026-01-21 23:49:51',NULL,NULL),(50,NULL,'1ef9c18b98334fb48e710316dce1301e',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:52',NULL,'2026-01-21 23:49:52',NULL,NULL),(51,NULL,NULL,'cb11f539f5ba4bee96b2334323afc36b',NULL,NULL,NULL,NULL,'2026-01-21 23:49:53',NULL,'2026-01-21 23:49:53',NULL,NULL),(52,NULL,'2e70d2389f3b40ffbd2aa8a5c834ec36',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:53',NULL,'2026-01-21 23:49:53',NULL,NULL),(53,NULL,NULL,'83e282e9d3574bf9bb7aeda35d1945b9',NULL,NULL,NULL,NULL,'2026-01-21 23:49:53',NULL,'2026-01-21 23:49:53',NULL,NULL),(54,NULL,NULL,'aeccc508f8bc4aaeae8b40f74a247ca5',NULL,NULL,NULL,NULL,'2026-01-21 23:49:53',NULL,'2026-01-21 23:49:53',NULL,NULL),(55,NULL,'76face7b21164a008d0487bf9f98d5db',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:55',NULL,'2026-01-21 23:49:55',NULL,NULL),(56,NULL,NULL,'01c0c0b21f2a447ba08c9bca17560c5f',NULL,NULL,NULL,NULL,'2026-01-21 23:49:55',NULL,'2026-01-21 23:49:55',NULL,NULL),(57,NULL,NULL,'17c6505b5efb4b908fd4d4bf2b7666f3',NULL,NULL,NULL,NULL,'2026-01-21 23:49:55',NULL,'2026-01-21 23:49:55',NULL,NULL),(58,NULL,'05622ef0e3c3436b9123560b83631c08',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:56',NULL,'2026-01-21 23:49:56',NULL,NULL),(59,NULL,'7036ad194f5f4a3fae77f096c10620b0',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:58',NULL,'2026-01-21 23:49:58',NULL,NULL),(60,NULL,'6922ef154ff24c8dbd3a8c18d865fb23',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:49:59',NULL,'2026-01-21 23:49:59',NULL,NULL),(61,NULL,NULL,'bebcc2ce4397403ab2066e78f973315b',NULL,NULL,NULL,NULL,'2026-01-21 23:50:01',NULL,'2026-01-21 23:50:01',NULL,NULL),(62,NULL,NULL,'56c7424307014dfb9130b7f29b58eee8',NULL,NULL,NULL,NULL,'2026-01-21 23:50:01',NULL,'2026-01-21 23:50:01',NULL,NULL),(63,NULL,'4b3f85ffa20c40dab11faa1dd37f6e05',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:02',NULL,'2026-01-21 23:50:02',NULL,NULL),(64,NULL,'f9942a70ab484e56a6a0e1a21e8865ee',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:03',NULL,'2026-01-21 23:50:03',NULL,NULL),(65,NULL,NULL,'06926d85b7894a23898ab9591ac7af5e',NULL,NULL,NULL,NULL,'2026-01-21 23:50:03',NULL,'2026-01-21 23:50:03',NULL,NULL),(66,NULL,NULL,'44982736446641e8a99b9285a8bc77fa',NULL,NULL,NULL,NULL,'2026-01-21 23:50:03',NULL,'2026-01-21 23:50:03',NULL,NULL),(67,NULL,'5cb4e9c7da9e48889e5e92d69fb17452',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:05',NULL,'2026-01-21 23:50:05',NULL,NULL),(68,NULL,'b0c200f5eb3640e8b163b0887cfe6193',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:06',NULL,'2026-01-21 23:50:06',NULL,NULL),(69,NULL,NULL,'42663f6fc192486cadc5258195e57698',NULL,NULL,NULL,NULL,'2026-01-21 23:50:13',NULL,'2026-01-21 23:50:13',NULL,NULL),(70,NULL,NULL,'0ef0fba86aa840b591fe7dcbd396404c',NULL,NULL,NULL,NULL,'2026-01-21 23:50:13',NULL,'2026-01-21 23:50:13',NULL,NULL),(71,NULL,NULL,'dbf9a69e610e40ec9e39c6e08b09a92e',NULL,NULL,NULL,NULL,'2026-01-21 23:50:15',NULL,'2026-01-21 23:50:15',NULL,NULL),(72,NULL,NULL,'b3063c42bce54a9f978a45ec835c9348',NULL,NULL,NULL,NULL,'2026-01-21 23:50:15',NULL,'2026-01-21 23:50:15',NULL,NULL),(73,NULL,'180be447d59a4e9a89a1641b5db7e4f5',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:15',NULL,'2026-01-21 23:50:15',NULL,NULL),(74,NULL,NULL,'f9c10327cf764fc5ae4fb224c74d5174',NULL,NULL,NULL,NULL,'2026-01-21 23:50:15',NULL,'2026-01-21 23:50:15',NULL,NULL),(75,NULL,NULL,'83fac5fe336b452ea2b974ffcbec8a7b',NULL,NULL,NULL,NULL,'2026-01-21 23:50:16',NULL,'2026-01-21 23:50:16',NULL,NULL),(76,NULL,'e3e2ab140ff747d9816d7e95288ff5db',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:16',NULL,'2026-01-21 23:50:16',NULL,NULL),(77,NULL,'252caa899bdd43f4b900433afd9a49a9',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:16',NULL,'2026-01-21 23:50:16',NULL,NULL),(78,NULL,'318bed01b8fb4b88a5dc792c00646fa5',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:17',NULL,'2026-01-21 23:50:17',NULL,NULL),(79,NULL,'e0251a3bf6da45c6b85f031747aa5ff6',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:17',NULL,'2026-01-21 23:50:17',NULL,NULL),(80,NULL,'f484d90f8a9a4d1db7a678920221f8fc',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:19',NULL,'2026-01-21 23:50:19',NULL,NULL),(81,NULL,NULL,'e1173f2af8e0461a9cd52998f8781797',NULL,NULL,NULL,NULL,'2026-01-21 23:50:23',NULL,'2026-01-21 23:50:23',NULL,NULL),(82,NULL,NULL,'f5da32373e1844aeb8770fdbd9ae344e',NULL,NULL,NULL,NULL,'2026-01-21 23:50:24',NULL,'2026-01-21 23:50:24',NULL,NULL),(83,NULL,NULL,'57ae61cb3d184bcf926aa8c601f4839a',NULL,NULL,NULL,NULL,'2026-01-21 23:50:25',NULL,'2026-01-21 23:50:25',NULL,NULL),(84,NULL,NULL,'580111388ba14d1799e467fbbf5ca76e',NULL,NULL,NULL,NULL,'2026-01-21 23:50:25',NULL,'2026-01-21 23:50:25',NULL,NULL),(85,NULL,'89aa24ddadc845bdb593e2d6681f8569',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:27',NULL,'2026-01-21 23:50:27',NULL,NULL),(86,NULL,'338ab1b7c109480ab0a60a8cf9066cf2',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:27',NULL,'2026-01-21 23:50:27',NULL,NULL),(87,NULL,'d5adc6b785c34d0f84316e97930b4e08',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:28',NULL,'2026-01-21 23:50:28',NULL,NULL),(88,NULL,'8018259dea354d2b9fdb38f42fda8dc5',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:28',NULL,'2026-01-21 23:50:28',NULL,NULL),(89,NULL,NULL,'eada0875d0c84fa0a8b75ff9613be779',NULL,NULL,NULL,NULL,'2026-01-21 23:50:31',NULL,'2026-01-21 23:50:31',NULL,NULL),(90,NULL,NULL,'a3a6f8f9e5834453b99f2d5edf668b3a',NULL,NULL,NULL,NULL,'2026-01-21 23:50:32',NULL,'2026-01-21 23:50:32',NULL,NULL),(91,NULL,NULL,'8b0858462a434e4db20be7429c2cb904',NULL,NULL,NULL,NULL,'2026-01-21 23:50:32',NULL,'2026-01-21 23:50:32',NULL,NULL),(92,NULL,NULL,'5cb56cbfc87844d8a6b1a931c687082a',NULL,NULL,NULL,NULL,'2026-01-21 23:50:32',NULL,'2026-01-21 23:50:32',NULL,NULL),(93,NULL,NULL,'c0cd895fa98a4f1ba44c27fbf52aff6a',NULL,NULL,NULL,NULL,'2026-01-21 23:50:32',NULL,'2026-01-21 23:50:32',NULL,NULL),(94,NULL,NULL,'83e442b63a9d48898250c6cdd9543203',NULL,NULL,NULL,NULL,'2026-01-21 23:50:32',NULL,'2026-01-21 23:50:32',NULL,NULL),(95,NULL,NULL,'d8bda42aad3845f2881745244b2252fd',NULL,NULL,NULL,NULL,'2026-01-21 23:50:33',NULL,'2026-01-21 23:50:33',NULL,NULL),(96,NULL,'b9269179afa746c5b390503d0c04dd80',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:33',NULL,'2026-01-21 23:50:33',NULL,NULL),(97,NULL,'c22d5843855c4640929acbd6f89b4d6e',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:33',NULL,'2026-01-21 23:50:33',NULL,NULL),(98,NULL,'47b9eb44546d4bf7857fe7b94b709128',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:34',NULL,'2026-01-21 23:50:34',NULL,NULL),(99,NULL,'eea19f4b9780410e81dc67e037a8452f',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:34',NULL,'2026-01-21 23:50:34',NULL,NULL),(100,NULL,'99ccab2c01d74ff8b2ab56fb47cfa2ac',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:35',NULL,'2026-01-21 23:50:35',NULL,NULL),(101,NULL,'48484e20353e470f90768bf1d4554395',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:35',NULL,'2026-01-21 23:50:35',NULL,NULL),(102,NULL,'e24bfc7332054ae7b7c7894edcb645d9',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:37',NULL,'2026-01-21 23:50:37',NULL,NULL),(103,NULL,NULL,'de60d74bdbda4a86a4c4a10b77d31f6a',NULL,NULL,NULL,NULL,'2026-01-21 23:50:39',NULL,'2026-01-21 23:50:39',NULL,NULL),(104,NULL,NULL,'13a5fa70179143f5947877b3c4e008da',NULL,NULL,NULL,NULL,'2026-01-21 23:50:39',NULL,'2026-01-21 23:50:39',NULL,NULL),(105,NULL,'a178cff777cc4f5c98c8bb399a2d8f86',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:41',NULL,'2026-01-21 23:50:41',NULL,NULL),(106,NULL,NULL,'ebdfa8fe3bac4e2ba461c85419dd1d21',NULL,NULL,NULL,NULL,'2026-01-21 23:50:41',NULL,'2026-01-21 23:50:41',NULL,NULL),(107,NULL,NULL,'692ea149302f4324915d6af8dbaf161c',NULL,NULL,NULL,NULL,'2026-01-21 23:50:41',NULL,'2026-01-21 23:50:41',NULL,NULL),(108,NULL,'3d73f0d0f0034ee984f2322dbbc9bdf3',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:42',NULL,'2026-01-21 23:50:42',NULL,NULL),(109,NULL,'b071f65cd4714184af6359424ecb5ba7',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:43',NULL,'2026-01-21 23:50:43',NULL,NULL),(110,NULL,'427067a6266a49c1a6c4ca24998456e4',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:44',NULL,'2026-01-21 23:50:44',NULL,NULL),(111,NULL,NULL,'ebe9e5f229d74cba9c6bbbe6571190b4',NULL,NULL,NULL,NULL,'2026-01-21 23:50:46',NULL,'2026-01-21 23:50:46',NULL,NULL),(112,NULL,NULL,'a3e7182a276543e5a4e55fcbf6a7cf7b',NULL,NULL,NULL,NULL,'2026-01-21 23:50:46',NULL,'2026-01-21 23:50:46',NULL,NULL),(113,NULL,'0eafdb75317b42f28521a5cb4a42f752',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:48',NULL,'2026-01-21 23:50:48',NULL,NULL),(114,NULL,'e853dc2973a94f97854b18d4e49de8e9',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:49',NULL,'2026-01-21 23:50:49',NULL,NULL),(115,NULL,NULL,'86c676c1404747b7a0836ec1c270fc74',NULL,NULL,NULL,NULL,'2026-01-21 23:50:49',NULL,'2026-01-21 23:50:49',NULL,NULL),(116,NULL,NULL,'5997ab93d8c141fb8fcf79b78fa9a58a',NULL,NULL,NULL,NULL,'2026-01-21 23:50:49',NULL,'2026-01-21 23:50:49',NULL,NULL),(117,NULL,'39ea7b35b2b943708e66e5ff2cd1e620',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:50',NULL,'2026-01-21 23:50:50',NULL,NULL),(118,NULL,'23334fbf021c4c278520ce772d7484a7',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:52',NULL,'2026-01-21 23:50:52',NULL,NULL),(119,NULL,NULL,'49dad4ea6c06492fae494248eb0a4491',NULL,NULL,NULL,NULL,'2026-01-21 23:50:53',NULL,'2026-01-21 23:50:53',NULL,NULL),(120,NULL,NULL,'ee22f145ff034e66a0c9c1b11eb6092c',NULL,NULL,NULL,NULL,'2026-01-21 23:50:53',NULL,'2026-01-21 23:50:53',NULL,NULL),(121,NULL,'19fee3fa9fc644ca96d30729cefa1fa9',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:55',NULL,'2026-01-21 23:50:55',NULL,NULL),(122,NULL,'8576e8f9e80340659f92487f827c68fc',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:56',NULL,'2026-01-21 23:50:56',NULL,NULL),(123,NULL,NULL,'f0d2c105e50a4d3ca721aa9834533fdf',NULL,NULL,NULL,NULL,'2026-01-21 23:50:56',NULL,'2026-01-21 23:50:56',NULL,NULL),(124,NULL,NULL,'c9d13a69d987490597669549c7007571',NULL,NULL,NULL,NULL,'2026-01-21 23:50:56',NULL,'2026-01-21 23:50:56',NULL,NULL),(125,NULL,'b411d5db326945289c308b4a091eeea5',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:58',NULL,'2026-01-21 23:50:58',NULL,NULL),(126,NULL,'5df26b5e945d4eb1a355fa7e23efa66f',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:50:59',NULL,'2026-01-21 23:50:59',NULL,NULL),(127,NULL,NULL,'98ba74df934d4882a7f762fe2d250455',NULL,NULL,NULL,NULL,'2026-01-21 23:51:00',NULL,'2026-01-21 23:51:00',NULL,NULL),(128,NULL,NULL,'1e028caf451e4be0a6b2fa06a11b357b',NULL,NULL,NULL,NULL,'2026-01-21 23:51:00',NULL,'2026-01-21 23:51:00',NULL,NULL),(129,NULL,'c435c145f53444349cf846ffbc59f444',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:01',NULL,'2026-01-21 23:51:01',NULL,NULL),(130,NULL,'f8390878030a44f1b4d15b4676b91822',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:02',NULL,'2026-01-21 23:51:02',NULL,NULL),(131,NULL,NULL,'7485c1eba8464de0a932d3f037dce554',NULL,NULL,NULL,NULL,'2026-01-21 23:51:04',NULL,'2026-01-21 23:51:04',NULL,NULL),(132,NULL,NULL,'f297ee92da7345b8b96661faf004b574',NULL,NULL,NULL,NULL,'2026-01-21 23:51:04',NULL,'2026-01-21 23:51:04',NULL,NULL),(133,NULL,'46ac619b03954fc384e5cb9f18b65e56',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:06',NULL,'2026-01-21 23:51:06',NULL,NULL),(134,NULL,NULL,'5c2ffd060b484f9ea7675c807e27290a',NULL,NULL,NULL,NULL,'2026-01-21 23:51:06',NULL,'2026-01-21 23:51:06',NULL,NULL),(135,NULL,NULL,'63049f82ad90448da22fbe0dab27e217',NULL,NULL,NULL,NULL,'2026-01-21 23:51:06',NULL,'2026-01-21 23:51:06',NULL,NULL),(136,NULL,'983f50e3ca54417da8cb8e8a88170767',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:07',NULL,'2026-01-21 23:51:07',NULL,NULL),(137,NULL,'47f43fa0c59440e8b3dce25aecefcbfe',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:08',NULL,'2026-01-21 23:51:08',NULL,NULL),(138,NULL,'918baa2f100e48d4bef65a9e12b6701e',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:09',NULL,'2026-01-21 23:51:09',NULL,NULL),(139,NULL,NULL,'9bebceabe0184c23aaa30066c16630e8',NULL,NULL,NULL,NULL,'2026-01-21 23:51:13',NULL,'2026-01-21 23:51:13',NULL,NULL),(140,NULL,NULL,'45f9d3ab18ab4fdb9d7e440eb9b8ce8e',NULL,NULL,NULL,NULL,'2026-01-21 23:51:13',NULL,'2026-01-21 23:51:13',NULL,NULL),(141,NULL,NULL,'75a0213c9f2c42e1b64ea4754293cd41',NULL,NULL,NULL,NULL,'2026-01-21 23:51:14',NULL,'2026-01-21 23:51:14',NULL,NULL),(142,NULL,NULL,'0936e921b3404f2a89266598c556803a',NULL,NULL,NULL,NULL,'2026-01-21 23:51:14',NULL,'2026-01-21 23:51:14',NULL,NULL),(143,NULL,'d3c3f5f8d1414f6582f81bac6b200ba4',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:16',NULL,'2026-01-21 23:51:16',NULL,NULL),(144,NULL,'45c2c21100f244b2ba1be64e17b0b015',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:17',NULL,'2026-01-21 23:51:17',NULL,NULL),(145,NULL,'842035d2b1814df79a2698e3ba22e61f',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:18',NULL,'2026-01-21 23:51:18',NULL,NULL),(146,NULL,'e8cfe96ca9154ca58d2958aaf3765bc6',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:18',NULL,'2026-01-21 23:51:18',NULL,NULL),(147,NULL,NULL,'ee2f02dc6e754824bcc610ce347e8ee1',NULL,NULL,NULL,NULL,'2026-01-21 23:51:23',NULL,'2026-01-21 23:51:23',NULL,NULL),(148,NULL,NULL,'13b59c7986f44a0ab83dd538b8a09bf7',NULL,NULL,NULL,NULL,'2026-01-21 23:51:23',NULL,'2026-01-21 23:51:23',NULL,NULL),(149,NULL,NULL,'c7e33a5a59734fc2b08ea7527464bf9b',NULL,NULL,NULL,NULL,'2026-01-21 23:51:24',NULL,'2026-01-21 23:51:24',NULL,NULL),(150,NULL,NULL,'1b3235d2c1574de3a4924c18ca9d53a2',NULL,NULL,NULL,NULL,'2026-01-21 23:51:24',NULL,'2026-01-21 23:51:24',NULL,NULL),(151,NULL,'7ff375a5e5394cbabe19c2ce5f48e235',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:26',NULL,'2026-01-21 23:51:26',NULL,NULL),(152,NULL,'d74bf996881140fa8b55fc9243d0fa46',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:26',NULL,'2026-01-21 23:51:26',NULL,NULL),(153,NULL,'21b2428264134dddac11b0fee2c242c7',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:28',NULL,'2026-01-21 23:51:28',NULL,NULL),(154,NULL,'1a1a4999bd3640c9a0cef767e07b6447',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:28',NULL,'2026-01-21 23:51:28',NULL,NULL),(155,NULL,NULL,'c32f8c83c7ff4391bf99dd1d3d5fd702',NULL,NULL,NULL,NULL,'2026-01-21 23:51:33',NULL,'2026-01-21 23:51:33',NULL,NULL),(156,NULL,NULL,'59d4aa7dbe36465cb1ae2a9dc87c710e',NULL,NULL,NULL,NULL,'2026-01-21 23:51:33',NULL,'2026-01-21 23:51:33',NULL,NULL),(157,NULL,'4546401978d1459d9ad3822c70fd3324',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:35',NULL,'2026-01-21 23:51:35',NULL,NULL),(158,NULL,'9e852888651842959f230cf25e779c1e',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:36',NULL,'2026-01-21 23:51:36',NULL,NULL),(159,NULL,NULL,'6086cf404f7840aca149721187aa52a6',NULL,NULL,NULL,NULL,'2026-01-21 23:51:39',NULL,'2026-01-21 23:51:39',NULL,NULL),(160,NULL,NULL,'01edd3de5cd2464ab2f6252cc21ccfbe',NULL,NULL,NULL,NULL,'2026-01-21 23:51:39',NULL,'2026-01-21 23:51:39',NULL,NULL),(161,NULL,NULL,'ac4dbeffd30447159c908075fbcdf7c5',NULL,NULL,NULL,NULL,'2026-01-21 23:51:39',NULL,'2026-01-21 23:51:39',NULL,NULL),(162,NULL,NULL,'c4a65f174a3f43888e96a80e4134fb87',NULL,NULL,NULL,NULL,'2026-01-21 23:51:41',NULL,'2026-01-21 23:51:41',NULL,NULL),(163,NULL,NULL,'3a39b367b793455e84c7ab95ffb8d231',NULL,NULL,NULL,NULL,'2026-01-21 23:51:41',NULL,'2026-01-21 23:51:41',NULL,NULL),(164,NULL,'76ddd5b92fcb43308306dead5ea9a045',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:42',NULL,'2026-01-21 23:51:42',NULL,NULL),(165,NULL,NULL,'3f7745d58d75429fb8234b25ef643e45',NULL,NULL,NULL,NULL,'2026-01-21 23:51:42',NULL,'2026-01-21 23:51:42',NULL,NULL),(166,NULL,NULL,'a193fad2041f4d868727e4be87de6c14',NULL,NULL,NULL,NULL,'2026-01-21 23:51:42',NULL,'2026-01-21 23:51:42',NULL,NULL),(167,NULL,NULL,'73f16a047b564ec7b4f2818ab70ed2c2',NULL,NULL,NULL,NULL,'2026-01-21 23:51:44',NULL,'2026-01-21 23:51:44',NULL,NULL),(168,NULL,'782d762725a142abb32555887d980fa1',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:44',NULL,'2026-01-21 23:51:44',NULL,NULL),(169,NULL,'2c507ade62484c2390a38cd291975399',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:44',NULL,'2026-01-21 23:51:44',NULL,NULL),(170,NULL,'634e555228a443a68e4fcf6963da3880',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:45',NULL,'2026-01-21 23:51:45',NULL,NULL),(171,NULL,'6331f5936b8c4dabae57ecf21f3a6709',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:45',NULL,'2026-01-21 23:51:45',NULL,NULL),(172,NULL,'4a977e070ff14574af74363c9f8797d5',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:46',NULL,'2026-01-21 23:51:46',NULL,NULL),(173,NULL,'dc93a7be3d8e4d65b8aafbe21f78da4a',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:46',NULL,'2026-01-21 23:51:46',NULL,NULL),(174,NULL,'026f727cf782476cbc5491d15ff66ca7',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:46',NULL,'2026-01-21 23:51:46',NULL,NULL),(175,NULL,NULL,'f44098f807c34a2daa4949209374b6cf',NULL,NULL,NULL,NULL,'2026-01-21 23:51:54',NULL,'2026-01-21 23:51:54',NULL,NULL),(176,NULL,NULL,'9bc8fd87389c4678b1f19c9aac5bd4e6',NULL,NULL,NULL,NULL,'2026-01-21 23:51:55',NULL,'2026-01-21 23:51:55',NULL,NULL),(177,NULL,'cd63e660d9e64dd890a680d0fc4c754b',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:57',NULL,'2026-01-21 23:51:57',NULL,NULL),(178,NULL,'f3d5093213e547ea89e64535f0bea035',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:51:58',NULL,'2026-01-21 23:51:58',NULL,NULL),(179,NULL,NULL,'1ae433d7b90e4dff847a080ad09ccc91',NULL,NULL,NULL,NULL,'2026-01-21 23:52:01',NULL,'2026-01-21 23:52:01',NULL,NULL),(180,NULL,'39d32515bedc4c99926d872714f9cc28',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:52:02',NULL,'2026-01-21 23:52:02',NULL,NULL),(181,NULL,NULL,'fd3bd1dedbdd44f7abaeafde90c66c27',NULL,NULL,NULL,NULL,'2026-01-21 23:52:06',NULL,'2026-01-21 23:52:06',NULL,NULL),(182,NULL,NULL,'f4bbe0323eda411d812c3e60e98a2490',NULL,NULL,NULL,NULL,'2026-01-21 23:52:06',NULL,'2026-01-21 23:52:06',NULL,NULL),(183,NULL,'ede11e48dc474e588e81f5b26f04c9ee',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:52:08',NULL,'2026-01-21 23:52:08',NULL,NULL),(184,NULL,'8216b878f1dd42b4bc3c13bf00a0d57e',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:52:09',NULL,'2026-01-21 23:52:09',NULL,NULL),(185,NULL,NULL,'641f9372d6c042aeab4def0df9355ae3',NULL,NULL,NULL,NULL,'2026-01-21 23:52:11',NULL,'2026-01-21 23:52:11',NULL,NULL),(186,NULL,NULL,'d43e47ea555d4a58876ad4a0eb943a44',NULL,NULL,NULL,NULL,'2026-01-21 23:52:12',NULL,'2026-01-21 23:52:12',NULL,NULL),(187,NULL,NULL,'58d32a07f4be49bb81508b449e3a1b05',NULL,NULL,NULL,NULL,'2026-01-21 23:52:13',NULL,'2026-01-21 23:52:13',NULL,NULL),(188,NULL,NULL,'1e9030c35e1449118e157e35eac8abad',NULL,NULL,NULL,NULL,'2026-01-21 23:52:13',NULL,'2026-01-21 23:52:13',NULL,NULL),(189,NULL,'fc9c14bc418040c7a6bf4ab25926ac99',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:52:13',NULL,'2026-01-21 23:52:13',NULL,NULL),(190,NULL,'042a0c8614274391bbdc4638bd572d26',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:52:14',NULL,'2026-01-21 23:52:14',NULL,NULL),(191,NULL,'66dfa820fd004cff90d2c70a6c487dd0',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:52:14',NULL,'2026-01-21 23:52:14',NULL,NULL),(192,NULL,'28cf3cbb58234de8976209d46f1d21ac',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:52:16',NULL,'2026-01-21 23:52:16',NULL,NULL),(193,NULL,'f0206668ea34453fb01cdc10cb57a77a',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:52:18',NULL,'2026-01-21 23:52:18',NULL,NULL),(194,NULL,NULL,'201e7e3dd0a14f53bdbcf9f24472ae91',NULL,NULL,NULL,NULL,'2026-01-21 23:52:20',NULL,'2026-01-21 23:52:20',NULL,NULL),(195,NULL,'abac6b00b5c048bca21ef08a130a7c51',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:52:21',NULL,'2026-01-21 23:52:21',NULL,NULL),(196,NULL,NULL,'b9f29828ed7b427f96154c17e1aa6e52',NULL,NULL,NULL,NULL,'2026-01-21 23:52:22',NULL,'2026-01-21 23:52:22',NULL,NULL),(197,NULL,NULL,'fdc5924bc051430f965faba26785459e',NULL,NULL,NULL,NULL,'2026-01-21 23:52:22',NULL,'2026-01-21 23:52:22',NULL,NULL),(198,NULL,NULL,'3ac5c5d6cc464cc89b001cff07ddced4',NULL,NULL,NULL,NULL,'2026-01-21 23:52:23',NULL,'2026-01-21 23:52:23',NULL,NULL),(199,NULL,'d067d2825ecf47849f98db8542f84cc9',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:52:23',NULL,'2026-01-21 23:52:23',NULL,NULL),(200,NULL,'a6d95c41b2d94359a49f0b054a2a0901',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:52:24',NULL,'2026-01-21 23:52:24',NULL,NULL),(201,NULL,'1bde73aa15ee4a258a85ccb7672b8a68',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:52:25',NULL,'2026-01-21 23:52:25',NULL,NULL),(202,NULL,NULL,'5829d2329205490292b4ec1ed6165243',NULL,NULL,NULL,NULL,'2026-01-21 23:52:28',NULL,'2026-01-21 23:52:28',NULL,NULL),(203,NULL,NULL,'2ac61abe1d754afc8c0a355adfcc943e',NULL,NULL,NULL,NULL,'2026-01-21 23:52:28',NULL,'2026-01-21 23:52:28',NULL,NULL),(204,NULL,'3e99c623d47a479d9e32cf13f13a764b',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:52:29',NULL,'2026-01-21 23:52:29',NULL,NULL),(205,NULL,'4bfcf66655924076b027b4f638fbc758',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:52:30',NULL,'2026-01-21 23:52:30',NULL,NULL),(206,NULL,NULL,'3aeab27e60bd43f59aea72a95fe2afba',NULL,NULL,NULL,NULL,'2026-01-21 23:52:30',NULL,'2026-01-21 23:52:30',NULL,NULL),(207,NULL,'9c7e59283e67440690d322a7bae0772f',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:52:32',NULL,'2026-01-21 23:52:32',NULL,NULL),(208,NULL,NULL,'4726b7e3ff9b415d9f8abf4841ee0828',NULL,NULL,NULL,NULL,'2026-01-21 23:52:34',NULL,'2026-01-21 23:52:34',NULL,NULL),(209,NULL,'b8f7fb1898ab4663b7ef9155c5dc3eb8',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:52:35',NULL,'2026-01-21 23:52:35',NULL,NULL),(210,NULL,NULL,'8264c2c07fbd4dccabd22ac7681fa6ec',NULL,NULL,NULL,NULL,'2026-01-21 23:52:37',NULL,'2026-01-21 23:52:37',NULL,NULL),(211,NULL,NULL,'75a8cb09cca0402590a91f9990b6a4ff',NULL,NULL,NULL,NULL,'2026-01-21 23:52:37',NULL,'2026-01-21 23:52:37',NULL,NULL),(212,NULL,'91a374805c93486abd0e8e298c386716',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:52:38',NULL,'2026-01-21 23:52:38',NULL,NULL),(213,NULL,'9b587be313b04dc898780d39e59b97a3',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:52:40',NULL,'2026-01-21 23:52:40',NULL,NULL),(214,NULL,NULL,'5bc889dc142f4c12af6775f0b8098b71',NULL,NULL,NULL,NULL,'2026-01-21 23:52:42',NULL,'2026-01-21 23:52:42',NULL,NULL),(215,NULL,'a2012b4530da4cffafda17e7a52e49a1',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:52:43',NULL,'2026-01-21 23:52:43',NULL,NULL),(216,NULL,NULL,'3563df7b8d36421b80d61525f4cfec02',NULL,NULL,NULL,NULL,'2026-01-21 23:52:43',NULL,'2026-01-21 23:52:43',NULL,NULL),(217,NULL,NULL,'a83b1fd7ea5b425ca13636ecb7c9bdca',NULL,NULL,NULL,NULL,'2026-01-21 23:52:43',NULL,'2026-01-21 23:52:43',NULL,NULL),(218,NULL,'f4c093f3187b42fdb77fbea1465b6168',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:52:44',NULL,'2026-01-21 23:52:44',NULL,NULL),(219,NULL,'840288873e5e44eb8301c9d78bfc0811',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:52:45',NULL,'2026-01-21 23:52:45',NULL,NULL),(220,NULL,NULL,'917d4f094f2649e6ad4a2e253a2020ee',NULL,NULL,NULL,NULL,'2026-01-21 23:53:02',NULL,'2026-01-21 23:53:02',NULL,NULL),(221,NULL,NULL,'65645d5099ed4c1eb4c985a6b035c761',NULL,NULL,NULL,NULL,'2026-01-21 23:53:02',NULL,'2026-01-21 23:53:02',NULL,NULL),(222,NULL,NULL,'2b047c72bc7d433baf8634f282a1ebe6',NULL,NULL,NULL,NULL,'2026-01-21 23:53:03',NULL,'2026-01-21 23:53:03',NULL,NULL),(223,NULL,'719b96c744824aa98a2a31a0f18595f5',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:53:04',NULL,'2026-01-21 23:53:04',NULL,NULL),(224,NULL,'5ef356591b4e4f7aae1212c6e36ca744',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:53:05',NULL,'2026-01-21 23:53:05',NULL,NULL),(225,NULL,'5c0e2341007d44938353a84716b090e0',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:53:06',NULL,'2026-01-21 23:53:06',NULL,NULL),(226,NULL,NULL,'4f1af95ffa9443c1bf9395710157222e',NULL,NULL,NULL,NULL,'2026-01-21 23:53:17',NULL,'2026-01-21 23:53:17',NULL,NULL),(227,NULL,NULL,'7e5ee52da213479b809423f0a3bad255',NULL,NULL,NULL,NULL,'2026-01-21 23:53:18',NULL,'2026-01-21 23:53:18',NULL,NULL),(228,NULL,'0beaaaabaeb246a682e2f524e0c8e4a1',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:53:18',NULL,'2026-01-21 23:53:18',NULL,NULL),(229,NULL,'75394440e1db45649779f711b9925c50',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:53:18',NULL,'2026-01-21 23:53:18',NULL,NULL),(230,NULL,NULL,'c9345ec3c7e44ad5b9fc9c87801a4dbc',NULL,NULL,NULL,NULL,'2026-01-21 23:53:23',NULL,'2026-01-21 23:53:23',NULL,NULL),(231,NULL,'f478468aa40447e0b2f549c22704c127',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:53:24',NULL,'2026-01-21 23:53:24',NULL,NULL),(232,NULL,NULL,'00d3d51f76004e5ca386dd5eaf9d2daa',NULL,NULL,NULL,NULL,'2026-01-21 23:53:34',NULL,'2026-01-21 23:53:34',NULL,NULL),(233,NULL,'789fe1b8a0574f90998101067ca32134',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:53:35',NULL,'2026-01-21 23:53:35',NULL,NULL),(234,NULL,NULL,'b840a64776b74691b058295c8385a92e',NULL,NULL,NULL,NULL,'2026-01-21 23:53:38',NULL,'2026-01-21 23:53:38',NULL,NULL),(235,NULL,'f9733debcda842599e76fbebb4c4632c',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:53:39',NULL,'2026-01-21 23:53:39',NULL,NULL),(236,NULL,NULL,'fc38a9c643264fa4a040c624b88bdfd7',NULL,NULL,NULL,NULL,'2026-01-21 23:53:41',NULL,'2026-01-21 23:53:41',NULL,NULL),(237,NULL,NULL,'d2b49c5cc1e243078d9aa4af5675d146',NULL,NULL,NULL,NULL,'2026-01-21 23:53:41',NULL,'2026-01-21 23:53:41',NULL,NULL),(238,NULL,NULL,'5af3354eeb5c4bb08853bf9182d3d3e1',NULL,NULL,NULL,NULL,'2026-01-21 23:53:43',NULL,'2026-01-21 23:53:43',NULL,NULL),(239,NULL,'6a01539a8de24bfda4d96906a18c58ab',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:53:44',NULL,'2026-01-21 23:53:44',NULL,NULL),(240,NULL,'7219a2c6fd194af88fc9ce39dfae9387',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:53:47',NULL,'2026-01-21 23:53:47',NULL,NULL),(241,NULL,'e6ba5e33bca74c069acae7745e8b726c',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:53:47',NULL,'2026-01-21 23:53:47',NULL,NULL),(242,NULL,NULL,'697bc89b72a544a2b4a02e9a0e8df347',NULL,NULL,NULL,NULL,'2026-01-21 23:53:47',NULL,'2026-01-21 23:53:47',NULL,NULL),(243,NULL,'ee244ba71d214b9b9191e7b21ba26227',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:53:48',NULL,'2026-01-21 23:53:48',NULL,NULL),(244,NULL,NULL,'3b740cf5780b4291a3ee5d41195fc1e8',NULL,NULL,NULL,NULL,'2026-01-21 23:53:54',NULL,'2026-01-21 23:53:54',NULL,NULL),(245,NULL,NULL,'dafe619f8f75412ab3c6a83641dcc54e',NULL,NULL,NULL,NULL,'2026-01-21 23:53:55',NULL,'2026-01-21 23:53:55',NULL,NULL),(246,NULL,'3e48bbb0d1754302800def25e306b0de',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:53:56',NULL,'2026-01-21 23:53:56',NULL,NULL),(247,NULL,'9cd3bc2b1434437bbf0587c554f8bdae',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:53:57',NULL,'2026-01-21 23:53:57',NULL,NULL),(248,NULL,NULL,'ac9b898e98d3460daf5366d4e0891591',NULL,NULL,NULL,NULL,'2026-01-21 23:54:03',NULL,'2026-01-21 23:54:03',NULL,NULL),(249,NULL,'5100157e7fb64e589ed94092969e7abc',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:54:04',NULL,'2026-01-21 23:54:04',NULL,NULL),(250,NULL,NULL,'020cd0815b334e90b8f58b72d1a30ba5',NULL,NULL,NULL,NULL,'2026-01-21 23:54:04',NULL,'2026-01-21 23:54:04',NULL,NULL),(251,NULL,NULL,'b40b3876afcd47b7a295d11c6971910d',NULL,NULL,NULL,NULL,'2026-01-21 23:54:05',NULL,'2026-01-21 23:54:05',NULL,NULL),(252,NULL,'deadfff237534b3b9a91b54f6d35a859',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:54:06',NULL,'2026-01-21 23:54:06',NULL,NULL),(253,NULL,'f351610e5520410bb6df109e27880dc0',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:54:07',NULL,'2026-01-21 23:54:07',NULL,NULL),(254,NULL,NULL,'e61d8a63ad1d480ca4dcb28d24901933',NULL,NULL,NULL,NULL,'2026-01-21 23:54:08',NULL,'2026-01-21 23:54:08',NULL,NULL),(255,NULL,'15871199cf494fb1a313bcd4ebc56848',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:54:10',NULL,'2026-01-21 23:54:10',NULL,NULL),(256,NULL,NULL,'7fa0c3479b0a4543a9becdff93dced75',NULL,NULL,NULL,NULL,'2026-01-21 23:54:12',NULL,'2026-01-21 23:54:12',NULL,NULL),(257,NULL,NULL,'d7ab129f2fbb4ae09773bce5372ac966',NULL,NULL,NULL,NULL,'2026-01-21 23:54:12',NULL,'2026-01-21 23:54:12',NULL,NULL),(258,NULL,NULL,'b1be3ed9a96e4c05aa91604d5c9df451',NULL,NULL,NULL,NULL,'2026-01-21 23:54:13',NULL,'2026-01-21 23:54:13',NULL,NULL),(259,NULL,'67bec9f4bebe41ae824c463eb0a2498f',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:54:13',NULL,'2026-01-21 23:54:13',NULL,NULL),(260,NULL,'e257a85b1b8e4285b2fa24c4dc474c00',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:54:14',NULL,'2026-01-21 23:54:14',NULL,NULL),(261,NULL,'835833b6420647c18f7b162c91590cc5',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:54:14',NULL,'2026-01-21 23:54:14',NULL,NULL),(262,NULL,NULL,'e5a64a34d33d4373b0133ce20b46ebc5',NULL,NULL,NULL,NULL,'2026-01-21 23:54:16',NULL,'2026-01-21 23:54:16',NULL,NULL),(263,NULL,NULL,'e42f4e668af64daeaa813ec6373d9340',NULL,NULL,NULL,NULL,'2026-01-21 23:54:17',NULL,'2026-01-21 23:54:17',NULL,NULL),(264,NULL,'9ede9440e4624b23a0c328ef13e7a51d',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:54:17',NULL,'2026-01-21 23:54:17',NULL,NULL),(265,NULL,'68d44910531a46818a770f154564b1ce',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:54:18',NULL,'2026-01-21 23:54:18',NULL,NULL),(266,NULL,NULL,'37d63488b982446bbcf4fee7fcc649e9',NULL,NULL,NULL,NULL,'2026-01-21 23:54:19',NULL,'2026-01-21 23:54:19',NULL,NULL),(267,NULL,'f78ad87faee54168a3ad92c60fb8c2c5',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:54:19',NULL,'2026-01-21 23:54:19',NULL,NULL),(268,NULL,NULL,'0fb4fdbd8ffb4cf1ad5b3db5c5f84a4f',NULL,NULL,NULL,NULL,'2026-01-21 23:54:22',NULL,'2026-01-21 23:54:22',NULL,NULL),(269,NULL,'1cac358e6258439b958a2f4fb60a4489',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:54:23',NULL,'2026-01-21 23:54:23',NULL,NULL),(270,NULL,NULL,'eaa3cb0328c6489eaa7469b950080951',NULL,NULL,NULL,NULL,'2026-01-21 23:54:23',NULL,'2026-01-21 23:54:23',NULL,NULL),(271,NULL,NULL,'d9dbe55890624a52b28e89a621734718',NULL,NULL,NULL,NULL,'2026-01-21 23:54:24',NULL,'2026-01-21 23:54:24',NULL,NULL),(272,NULL,'0a23911e37db4ff98d2ef4ec3239a1df',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:54:25',NULL,'2026-01-21 23:54:25',NULL,NULL),(273,NULL,'6565f1fdb39d406e90ec3c4bbc5d2b61',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:54:26',NULL,'2026-01-21 23:54:26',NULL,NULL),(274,NULL,NULL,'3125e033502f49fb9eb1e3038d5b6294',NULL,NULL,NULL,NULL,'2026-01-21 23:54:34',NULL,'2026-01-21 23:54:34',NULL,NULL),(275,NULL,'740bb796dc2543cabdc4a09e34210737',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:54:35',NULL,'2026-01-21 23:54:35',NULL,NULL),(276,NULL,NULL,'b60f2f50517a4af0945061efff1806b6',NULL,NULL,NULL,NULL,'2026-01-21 23:54:47',NULL,'2026-01-21 23:54:47',NULL,NULL),(277,NULL,'b4effc2cceaa4f758ba04a5cd850e90c',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:54:48',NULL,'2026-01-21 23:54:48',NULL,NULL),(278,NULL,NULL,'12ea8966d6fd48b9bbf888569e981b9c',NULL,NULL,NULL,NULL,'2026-01-21 23:55:00',NULL,'2026-01-21 23:55:00',NULL,NULL),(279,NULL,'81b65270b36f425680a062e941448d35',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:55:01',NULL,'2026-01-21 23:55:01',NULL,NULL),(280,NULL,NULL,'0d397b53b1e145fa839a4ee4b7fc85dd',NULL,NULL,NULL,NULL,'2026-01-21 23:55:06',NULL,'2026-01-21 23:55:06',NULL,NULL),(281,NULL,'42eeff0bf46544a5907fc2a55b109fb0',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:55:07',NULL,'2026-01-21 23:55:07',NULL,NULL),(282,NULL,NULL,'6e4ba27ae66d494ea7d2a0e335e05458',NULL,NULL,NULL,NULL,'2026-01-21 23:55:13',NULL,'2026-01-21 23:55:13',NULL,NULL),(283,NULL,NULL,'05618355dc7d48da8366afced40067f6',NULL,NULL,NULL,NULL,'2026-01-21 23:55:13',NULL,'2026-01-21 23:55:13',NULL,NULL),(284,NULL,NULL,'59468c1aadbc4719aa18ebadd82ecb41',NULL,NULL,NULL,NULL,'2026-01-21 23:55:13',NULL,'2026-01-21 23:55:13',NULL,NULL),(285,NULL,'9a537f18a4d0413097539de50bec7d49',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:55:16',NULL,'2026-01-21 23:55:16',NULL,NULL),(286,NULL,'5b20020842e64d038d673129dc039514',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:55:17',NULL,'2026-01-21 23:55:17',NULL,NULL),(287,NULL,'3c0b858da02441efbb8876e157eb10b4',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:55:21',NULL,'2026-01-21 23:55:21',NULL,NULL),(288,NULL,NULL,'83cc1e10cf9a44fc8cffc90690533427',NULL,NULL,NULL,NULL,'2026-01-21 23:55:28',NULL,'2026-01-21 23:55:28',NULL,NULL),(289,NULL,'7c6a31455ba44140aaea31f816940e37',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:55:34',NULL,'2026-01-21 23:55:34',NULL,NULL),(290,NULL,NULL,'b8e9024e332f4196a3049b565e753acd',NULL,NULL,NULL,NULL,'2026-01-21 23:55:39',NULL,'2026-01-21 23:55:39',NULL,NULL),(291,NULL,'6cd12c54ffe44edcb6f25e007e2ede16',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:55:41',NULL,'2026-01-21 23:55:41',NULL,NULL),(292,NULL,NULL,'12ba83af61c743299cf728b6192caab9',NULL,NULL,NULL,NULL,'2026-01-21 23:55:46',NULL,'2026-01-21 23:55:46',NULL,NULL),(293,NULL,'1e5ed2b6262141599eaf84e2c6e095b8',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:55:49',NULL,'2026-01-21 23:55:49',NULL,NULL),(294,NULL,NULL,'37ee044f7e9149f59473a5fba5abdd37',NULL,NULL,NULL,NULL,'2026-01-21 23:55:55',NULL,'2026-01-21 23:55:55',NULL,NULL),(295,NULL,'6ce6de738b624647b3fecea5fcc987bd',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:55:57',NULL,'2026-01-21 23:55:57',NULL,NULL),(296,NULL,NULL,'29a756d24888402c806c8b239ba00587',NULL,NULL,NULL,NULL,'2026-01-21 23:56:01',NULL,'2026-01-21 23:56:01',NULL,NULL),(297,NULL,'838f21cee499487e91b9143371c6019a',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:56:03',NULL,'2026-01-21 23:56:03',NULL,NULL),(298,NULL,NULL,'56e68213f8c84d0d9b835af0486b9a60',NULL,NULL,NULL,NULL,'2026-01-21 23:56:26',NULL,'2026-01-21 23:56:26',NULL,NULL),(299,NULL,'cdf2c274348142cdac0655b7d0d70823',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:56:26',NULL,'2026-01-21 23:56:26',NULL,NULL),(300,NULL,NULL,'cee7f8b8ecc84d35a92b4836c51b1b73',NULL,NULL,NULL,NULL,'2026-01-21 23:56:39',NULL,'2026-01-21 23:56:39',NULL,NULL),(301,NULL,NULL,'82a5c3777bfb48f3940fcef320ef58f6',NULL,NULL,NULL,NULL,'2026-01-21 23:56:39',NULL,'2026-01-21 23:56:39',NULL,NULL),(302,NULL,'c4e46b0ccc0741739f0dd0b7fecbc6d3',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:56:41',NULL,'2026-01-21 23:56:41',NULL,NULL),(303,NULL,'81d7a22e83d04172a9b390c93900a4ae',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:56:41',NULL,'2026-01-21 23:56:41',NULL,NULL),(304,NULL,NULL,'33fb3b6af56947aa846f5b08c59f7c41',NULL,NULL,NULL,NULL,'2026-01-21 23:56:46',NULL,'2026-01-21 23:56:46',NULL,NULL),(305,NULL,'9e018edf5eef49d881ee7f554dfa5592',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:56:47',NULL,'2026-01-21 23:56:47',NULL,NULL),(306,NULL,NULL,'341cf855e25942e992347243a54663a1',NULL,NULL,NULL,NULL,'2026-01-21 23:56:49',NULL,'2026-01-21 23:56:49',NULL,NULL),(307,NULL,NULL,'3cf56ad72bb1454d96f0d6ffbd6bea06',NULL,NULL,NULL,NULL,'2026-01-21 23:56:49',NULL,'2026-01-21 23:56:49',NULL,NULL),(308,NULL,'21775db7e3b84b63abb602ffdda5d1e4',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:56:49',NULL,'2026-01-21 23:56:49',NULL,NULL),(309,NULL,'981d26a62bf94ff3977655e295040d0e',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:56:50',NULL,'2026-01-21 23:56:50',NULL,NULL),(310,NULL,NULL,'90b4e390eb444a4fa9c58c33f6728bcc',NULL,NULL,NULL,NULL,'2026-01-21 23:56:59',NULL,'2026-01-21 23:56:59',NULL,NULL),(311,NULL,'dc1c11b9f67847739a99e49f88407017',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:57:00',NULL,'2026-01-21 23:57:00',NULL,NULL),(312,NULL,NULL,'b565ceb84ab64ff7a7976188ff0aac51',NULL,NULL,NULL,NULL,'2026-01-21 23:57:08',NULL,'2026-01-21 23:57:08',NULL,NULL),(313,NULL,NULL,'d531b12d570d4690b6e32e0fe937dad4',NULL,NULL,NULL,NULL,'2026-01-21 23:57:08',NULL,'2026-01-21 23:57:08',NULL,NULL),(314,NULL,'8c5ea42ea1864d26b26844a38a374b68',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:57:10',NULL,'2026-01-21 23:57:10',NULL,NULL),(315,NULL,'a685d83de19946f783491ef465dafaa8',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:57:10',NULL,'2026-01-21 23:57:10',NULL,NULL),(316,NULL,NULL,'a76cd0663b504037a4f28ab4491f1450',NULL,NULL,NULL,NULL,'2026-01-21 23:57:23',NULL,'2026-01-21 23:57:23',NULL,NULL),(317,NULL,'fde79a1a3cc04b94a7caa2b4e8fea75e',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:57:24',NULL,'2026-01-21 23:57:24',NULL,NULL),(318,NULL,NULL,'1ea75395232c4d118862282649bcbf77',NULL,NULL,NULL,NULL,'2026-01-21 23:57:25',NULL,'2026-01-21 23:57:25',NULL,NULL),(319,NULL,'35df7cadc33f4b21a9cc32895fb012b9',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:57:26',NULL,'2026-01-21 23:57:26',NULL,NULL),(320,NULL,NULL,'13de49fea7194d5791c95e0e4bca2cc3',NULL,NULL,NULL,NULL,'2026-01-21 23:57:26',NULL,'2026-01-21 23:57:26',NULL,NULL),(321,NULL,'1cfcc6ec957a44b4b60d45489eb879f1',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:57:27',NULL,'2026-01-21 23:57:27',NULL,NULL),(322,NULL,NULL,'4f96656e9b624432a2c6e21d566073ee',NULL,NULL,NULL,NULL,'2026-01-21 23:57:34',NULL,'2026-01-21 23:57:34',NULL,NULL),(323,NULL,'4a15798b433c43d4bf36f707c1637498',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:57:36',NULL,'2026-01-21 23:57:36',NULL,NULL),(324,NULL,NULL,'0c92b433d2644000ab211302e9753b5c',NULL,NULL,NULL,NULL,'2026-01-21 23:58:01',NULL,'2026-01-21 23:58:01',NULL,NULL),(325,NULL,'374e19b4eb4744c786cfa397b1c1097c',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:58:02',NULL,'2026-01-21 23:58:02',NULL,NULL),(326,NULL,NULL,'9af57bd909c84d828eb422d5022ae6f9',NULL,NULL,NULL,NULL,'2026-01-21 23:58:03',NULL,'2026-01-21 23:58:03',NULL,NULL),(327,NULL,NULL,'216eecd3673c43fd90b5d2241e7c244a',NULL,NULL,NULL,NULL,'2026-01-21 23:58:04',NULL,'2026-01-21 23:58:04',NULL,NULL),(328,NULL,'5e466c57b3a0473cb3260c643fe35ba7',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:58:04',NULL,'2026-01-21 23:58:04',NULL,NULL),(329,NULL,'7cae93b095d8409bb846b01f70862ad3',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:58:06',NULL,'2026-01-21 23:58:06',NULL,NULL),(330,NULL,NULL,'b391c31fd0ba48e1a1dc0adf524bb436',NULL,NULL,NULL,NULL,'2026-01-21 23:58:12',NULL,'2026-01-21 23:58:12',NULL,NULL),(331,NULL,'11dc4fafaa094482bdd633e28ffb3668',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:58:13',NULL,'2026-01-21 23:58:13',NULL,NULL),(332,NULL,NULL,'37ef6c4538334b6b8da9ba81f7cd62b7',NULL,NULL,NULL,NULL,'2026-01-21 23:58:26',NULL,'2026-01-21 23:58:26',NULL,NULL),(333,NULL,'78ace3730c024c47a61229b5f7ef877c',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:58:27',NULL,'2026-01-21 23:58:27',NULL,NULL),(334,NULL,NULL,'1c4cf2edc7c04b008dc19960f37ea8c2',NULL,NULL,NULL,NULL,'2026-01-21 23:58:34',NULL,'2026-01-21 23:58:34',NULL,NULL),(335,NULL,'ebb537f18e1d4f3fbfe82606baef2b84',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:58:36',NULL,'2026-01-21 23:58:36',NULL,NULL),(336,NULL,NULL,'f065c1a5453a44b5bc8a7159688033e7',NULL,NULL,NULL,NULL,'2026-01-21 23:58:50',NULL,'2026-01-21 23:58:50',NULL,NULL),(337,NULL,NULL,'ab324910e54f4bbcb4d1cf8f6c64616f',NULL,NULL,NULL,NULL,'2026-01-21 23:58:51',NULL,'2026-01-21 23:58:51',NULL,NULL),(338,NULL,'9f23669939634e6ea2e01c367000552b',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:58:52',NULL,'2026-01-21 23:58:52',NULL,NULL),(339,NULL,NULL,'4852cc9cbe2f451f94416dcfbff2ed99',NULL,NULL,NULL,NULL,'2026-01-21 23:58:52',NULL,'2026-01-21 23:58:52',NULL,NULL),(340,NULL,'9fea1e614ab04351a2b6bc42351c405d',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:58:53',NULL,'2026-01-21 23:58:53',NULL,NULL),(341,NULL,'aa97ea95e1574468927ccc2f34c15d68',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:58:53',NULL,'2026-01-21 23:58:53',NULL,NULL),(342,NULL,NULL,'1ad61b4c804142b2849ab0f691ffe649',NULL,NULL,NULL,NULL,'2026-01-21 23:58:57',NULL,'2026-01-21 23:58:57',NULL,NULL),(343,NULL,'424ea76d74e64db48b194fd9b63bb548',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:58:58',NULL,'2026-01-21 23:58:58',NULL,NULL),(344,NULL,NULL,'ba8d85879cae43abaf1810848fce5e66',NULL,NULL,NULL,NULL,'2026-01-21 23:59:08',NULL,'2026-01-21 23:59:08',NULL,NULL),(345,NULL,'b0f0f884a591426cb2fbc03a230a3468',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:59:09',NULL,'2026-01-21 23:59:09',NULL,NULL),(346,NULL,NULL,'06c36b1ac0ec4b8196a24e07918d9a10',NULL,NULL,NULL,NULL,'2026-01-21 23:59:16',NULL,'2026-01-21 23:59:16',NULL,NULL),(347,NULL,'480e04e494ca42909b19a18fcb1580db',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:59:17',NULL,'2026-01-21 23:59:17',NULL,NULL),(348,NULL,NULL,'597a0792673d42ec81e7414ac4dfbc3a',NULL,NULL,NULL,NULL,'2026-01-21 23:59:20',NULL,'2026-01-21 23:59:20',NULL,NULL),(349,NULL,'e9627d90d3cd45659eeb177d719fb91c',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:59:21',NULL,'2026-01-21 23:59:21',NULL,NULL),(350,NULL,NULL,'23aa3abc68ec4345a5dcfb0208d12051',NULL,NULL,NULL,NULL,'2026-01-21 23:59:21',NULL,'2026-01-21 23:59:21',NULL,NULL),(351,NULL,'aba2e4109c3f49c29dfae96d5a7466be',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:59:22',NULL,'2026-01-21 23:59:22',NULL,NULL),(352,NULL,NULL,'5da73703bfaf4a6883de47380eeed9a7',NULL,NULL,NULL,NULL,'2026-01-21 23:59:29',NULL,'2026-01-21 23:59:29',NULL,NULL),(353,NULL,'4a4e08ad01be4b5789520bd51e6135e0',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:59:30',NULL,'2026-01-21 23:59:30',NULL,NULL),(354,NULL,NULL,'7a2eb1fa7b64440495a6e40aaafc1136',NULL,NULL,NULL,NULL,'2026-01-21 23:59:52',NULL,'2026-01-21 23:59:52',NULL,NULL),(355,NULL,'c6e8c86e18ca43d3804bfa2cdccfc365',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:59:53',NULL,'2026-01-21 23:59:53',NULL,NULL),(356,NULL,NULL,'71632c3a75c045e6bd55164c3ce2c91b',NULL,NULL,NULL,NULL,'2026-01-21 23:59:55',NULL,'2026-01-21 23:59:55',NULL,NULL),(357,NULL,'ae7c0db62353420eac7f802d8fe0d9f1',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:59:56',NULL,'2026-01-21 23:59:56',NULL,NULL),(358,NULL,NULL,'961497b27fd845c298796f7987dff8bb',NULL,NULL,NULL,NULL,'2026-01-21 23:59:56',NULL,'2026-01-21 23:59:56',NULL,NULL),(359,NULL,'73ffcc946ec547e083dfcfdf46b651b4',NULL,NULL,NULL,NULL,NULL,'2026-01-21 23:59:57',NULL,'2026-01-21 23:59:57',NULL,NULL),(360,NULL,NULL,'434e8a0183ec4a89bc6e227b73d6663a',NULL,NULL,NULL,NULL,'2026-01-22 00:00:00',NULL,'2026-01-22 00:00:00',NULL,NULL),(361,NULL,'7c8023338b9c4ff286e3d1f883ec3aea',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:00:02',NULL,'2026-01-22 00:00:02',NULL,NULL),(362,NULL,NULL,'991f8e1a8d70451aa56d6d6f688389a4',NULL,NULL,NULL,NULL,'2026-01-22 00:00:04',NULL,'2026-01-22 00:00:04',NULL,NULL),(363,NULL,'800b6c2954574115ad5fd60e98505ca3',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:00:05',NULL,'2026-01-22 00:00:05',NULL,NULL),(364,NULL,NULL,'f7fc1b6d111e4deb9ab3d83bc042e8b3',NULL,NULL,NULL,NULL,'2026-01-22 00:00:22',NULL,'2026-01-22 00:00:22',NULL,NULL),(365,NULL,'76db3735ea8a470a8c766e021103f598',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:00:22',NULL,'2026-01-22 00:00:22',NULL,NULL),(366,NULL,NULL,'bb2687dd37fc4aaa96b2bd4b3d4bcedb',NULL,NULL,NULL,NULL,'2026-01-22 00:00:25',NULL,'2026-01-22 00:00:25',NULL,NULL),(367,NULL,NULL,'17bc26b08ece48289725dc7d1fb14c90',NULL,NULL,NULL,NULL,'2026-01-22 00:00:25',NULL,'2026-01-22 00:00:25',NULL,NULL),(368,NULL,'33e4e5635cf84271bdc38a16691829ac',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:00:26',NULL,'2026-01-22 00:00:26',NULL,NULL),(369,NULL,'bb0ce88171eb4c3aa605f85d8a5d92c8',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:00:27',NULL,'2026-01-22 00:00:27',NULL,NULL),(370,NULL,NULL,'34b562aab4ef4e89b44f9bd128364ddd',NULL,NULL,NULL,NULL,'2026-01-22 00:00:33',NULL,'2026-01-22 00:00:33',NULL,NULL),(371,NULL,'b0775e424416402eb145de5b72b0bdd2',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:00:34',NULL,'2026-01-22 00:00:34',NULL,NULL),(372,NULL,NULL,'04cf14c021c2422a936487c26396fc21',NULL,NULL,NULL,NULL,'2026-01-22 00:00:36',NULL,'2026-01-22 00:00:36',NULL,NULL),(373,NULL,'c7e90bae99044dfb9e4f63820327e844',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:00:38',NULL,'2026-01-22 00:00:38',NULL,NULL),(374,NULL,NULL,'2fb008172d0f4bd8a60a85bb20963fb6',NULL,NULL,NULL,NULL,'2026-01-22 00:00:44',NULL,'2026-01-22 00:00:44',NULL,NULL),(375,NULL,'bcbe89f80e4a4672990d06f84d76bfb7',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:00:46',NULL,'2026-01-22 00:00:46',NULL,NULL),(376,NULL,NULL,'c992aa432a574bd6a8820d14819fe226',NULL,NULL,NULL,NULL,'2026-01-22 00:00:47',NULL,'2026-01-22 00:00:47',NULL,NULL),(377,NULL,NULL,'05082ca6a9e447feb8e4fe9853bb23e5',NULL,NULL,NULL,NULL,'2026-01-22 00:00:47',NULL,'2026-01-22 00:00:47',NULL,NULL),(378,NULL,'5f854c59d4c6491d8588e363c1f8e361',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:00:48',NULL,'2026-01-22 00:00:48',NULL,NULL),(379,NULL,'de4468a477c640c6949856031c250924',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:00:48',NULL,'2026-01-22 00:00:48',NULL,NULL),(380,NULL,NULL,'cb800ec97dd749fe9c2eca72b4084e29',NULL,NULL,NULL,NULL,'2026-01-22 00:00:51',NULL,'2026-01-22 00:00:51',NULL,NULL),(381,NULL,NULL,'d577794ab0964292aa6341524097bb5e',NULL,NULL,NULL,NULL,'2026-01-22 00:00:51',NULL,'2026-01-22 00:00:51',NULL,NULL),(382,NULL,'c7f748ff8a13438c84f74342b071f773',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:00:53',NULL,'2026-01-22 00:00:53',NULL,NULL),(383,NULL,NULL,'5469f7b5243f438db026bf69cb3b3c54',NULL,NULL,NULL,NULL,'2026-01-22 00:00:56',NULL,'2026-01-22 00:00:56',NULL,NULL),(384,NULL,NULL,'ea1c42c146e64886ad9cd6e0c4a005d6',NULL,NULL,NULL,NULL,'2026-01-22 00:00:56',NULL,'2026-01-22 00:00:56',NULL,NULL),(385,NULL,'154bf3fb11c549c2a80d1311fa223a13',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:00:58',NULL,'2026-01-22 00:00:58',NULL,NULL),(386,NULL,NULL,'66fcec947ddb4d12ad0da2c239945b7a',NULL,NULL,NULL,NULL,'2026-01-22 00:01:03',NULL,'2026-01-22 00:01:03',NULL,NULL),(387,NULL,'af9a4eecef76433a88538390b734db91',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:01:04',NULL,'2026-01-22 00:01:04',NULL,NULL),(388,NULL,NULL,'c2a1b47a47e44453888544091e1f79a1',NULL,NULL,NULL,NULL,'2026-01-22 00:01:07',NULL,'2026-01-22 00:01:07',NULL,NULL),(389,NULL,'796ec348f15e42e589a59c3cd2bd7b28',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:01:08',NULL,'2026-01-22 00:01:08',NULL,NULL),(390,NULL,NULL,'d3e00d28f78d49e79c04c01ec55e13a7',NULL,NULL,NULL,NULL,'2026-01-22 00:01:10',NULL,'2026-01-22 00:01:10',NULL,NULL),(391,NULL,'1ccd4bcd4eaa444cb58fed8e1a4e23b7',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:01:11',NULL,'2026-01-22 00:01:11',NULL,NULL),(392,NULL,NULL,'9a8d77d99c25413c94ca2935571b3d8f',NULL,NULL,NULL,NULL,'2026-01-22 00:01:19',NULL,'2026-01-22 00:01:19',NULL,NULL),(393,NULL,NULL,'7d2daf4270484f9890f21190ed0f5c55',NULL,NULL,NULL,NULL,'2026-01-22 00:01:19',NULL,'2026-01-22 00:01:19',NULL,NULL),(394,NULL,'5059184765fd46e9b533c6cf011cfa6b',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:01:20',NULL,'2026-01-22 00:01:20',NULL,NULL),(395,NULL,NULL,'5a45e446f069408b88ee65709a88105d',NULL,NULL,NULL,NULL,'2026-01-22 00:01:21',NULL,'2026-01-22 00:01:21',NULL,NULL),(396,NULL,'eedfd992a5eb4e7abb9f466574cd960f',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:01:21',NULL,'2026-01-22 00:01:21',NULL,NULL),(397,NULL,'5e0f215651654ea9a021d1711425ddc1',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:01:23',NULL,'2026-01-22 00:01:23',NULL,NULL),(398,NULL,NULL,'f811db74ef084d3b961438d69b21bb47',NULL,NULL,NULL,NULL,'2026-01-22 00:01:28',NULL,'2026-01-22 00:01:28',NULL,NULL),(399,NULL,'624beb90cbb84c6a8b1440bc178c05e4',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:01:29',NULL,'2026-01-22 00:01:29',NULL,NULL),(400,NULL,NULL,'0dcfaf0f82ba4d3d895ee8ed5108e548',NULL,NULL,NULL,NULL,'2026-01-22 00:01:39',NULL,'2026-01-22 00:01:39',NULL,NULL),(401,NULL,'c636ee9dad5d4178ac7648a6bc112ebd',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:01:40',NULL,'2026-01-22 00:01:40',NULL,NULL),(402,NULL,NULL,'736fc6d29cc94587b2c244c5a2297dc5',NULL,NULL,NULL,NULL,'2026-01-22 00:01:42',NULL,'2026-01-22 00:01:42',NULL,NULL),(403,NULL,NULL,'47b03a4829394fa298d21277833f1fda',NULL,NULL,NULL,NULL,'2026-01-22 00:01:42',NULL,'2026-01-22 00:01:42',NULL,NULL),(404,NULL,'f582fdef10cd47ebaea666b2f5ec1635',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:01:43',NULL,'2026-01-22 00:01:43',NULL,NULL),(405,NULL,NULL,'b3a772817656417990a358d6a43010ac',NULL,NULL,NULL,NULL,'2026-01-22 00:01:44',NULL,'2026-01-22 00:01:44',NULL,NULL),(406,NULL,'d7259e72c1254f07aa94c83aa3302fcc',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:01:45',NULL,'2026-01-22 00:01:45',NULL,NULL),(407,NULL,NULL,'1a30a38097dd4974ba3ff385798e6394',NULL,NULL,NULL,NULL,'2026-01-22 00:01:49',NULL,'2026-01-22 00:01:49',NULL,NULL),(408,NULL,'ea9e8aa9c6214cbf8e91592a11aa29da',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:01:52',NULL,'2026-01-22 00:01:52',NULL,NULL),(409,NULL,NULL,'f13f58a48ffc4973a745887836486c49',NULL,NULL,NULL,NULL,'2026-01-22 00:02:03',NULL,'2026-01-22 00:02:03',NULL,NULL),(410,NULL,'84f4c68d21e74ea5a2a856a6bd55cbd6',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:02:05',NULL,'2026-01-22 00:02:05',NULL,NULL),(411,NULL,NULL,'41bd43e867a74150a57ef8018efcb555',NULL,NULL,NULL,NULL,'2026-01-22 00:02:13',NULL,'2026-01-22 00:02:13',NULL,NULL),(412,NULL,'1969cffbbc8b4eeca65bf35487f95256',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:02:14',NULL,'2026-01-22 00:02:14',NULL,NULL),(413,NULL,NULL,'55ab69503f1d49bc84a257403dc76dbd',NULL,NULL,NULL,NULL,'2026-01-22 00:02:18',NULL,'2026-01-22 00:02:18',NULL,NULL),(414,NULL,NULL,'689263f2bb1e4fb8bec8c4e9842e8941',NULL,NULL,NULL,NULL,'2026-01-22 00:02:19',NULL,'2026-01-22 00:02:19',NULL,NULL),(415,NULL,'95618d94a35c45ad92bda4fac9a85ef5',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:02:19',NULL,'2026-01-22 00:02:19',NULL,NULL),(416,NULL,'f7ad93b5bdd64340ac516ee93f273edf',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:02:20',NULL,'2026-01-22 00:02:20',NULL,NULL),(417,NULL,NULL,'33f4d64c1ded4b5fa95ad90c80d84a6a',NULL,NULL,NULL,NULL,'2026-01-22 00:03:03',NULL,'2026-01-22 00:03:03',NULL,NULL),(418,NULL,'d9e55d4b457d43af90c1ef0b72d76e7e',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:03:04',NULL,'2026-01-22 00:03:04',NULL,NULL),(419,NULL,NULL,'f434281656404b9db7b0d333753976e4',NULL,NULL,NULL,NULL,'2026-01-22 00:03:14',NULL,'2026-01-22 00:03:14',NULL,NULL),(420,NULL,'b242b61b3b8d48e6a99b3b1a5818ce85',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:03:15',NULL,'2026-01-22 00:03:15',NULL,NULL),(421,NULL,NULL,'365fee6f94a74413b24d18e7c182bfbc',NULL,NULL,NULL,NULL,'2026-01-22 00:03:33',NULL,'2026-01-22 00:03:33',NULL,NULL),(422,NULL,NULL,'997d89c4d7244cf99b9f97b814efc1b0',NULL,NULL,NULL,NULL,'2026-01-22 00:03:34',NULL,'2026-01-22 00:03:34',NULL,NULL),(423,NULL,'706dabf6f1a341c5b9d62495a46c274a',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:03:36',NULL,'2026-01-22 00:03:36',NULL,NULL),(424,NULL,NULL,'e236ac2d6ac04b7797df4ae37dfce81b',NULL,NULL,NULL,NULL,'2026-01-22 00:03:37',NULL,'2026-01-22 00:03:37',NULL,NULL),(425,NULL,NULL,'46161d6c946842d2a2f0e54378d64625',NULL,NULL,NULL,NULL,'2026-01-22 00:03:37',NULL,'2026-01-22 00:03:37',NULL,NULL),(426,NULL,'3e857247bd7c4613ae804c1a6b0a3cfe',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:03:37',NULL,'2026-01-22 00:03:37',NULL,NULL),(427,NULL,'64b58bef7b3545cea7e6d988c842a388',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:03:38',NULL,'2026-01-22 00:03:38',NULL,NULL),(428,NULL,'bbe0bf0f5fe14d60832efdaf845b5237',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:03:39',NULL,'2026-01-22 00:03:39',NULL,NULL),(429,NULL,NULL,'3207815879544c1ab7f98d2942ca3df9',NULL,NULL,NULL,NULL,'2026-01-22 00:04:30',NULL,'2026-01-22 00:04:30',NULL,NULL),(430,NULL,NULL,'f5867ef4a222484c89f52826a35f48a1',NULL,NULL,NULL,NULL,'2026-01-22 00:04:30',NULL,'2026-01-22 00:04:30',NULL,NULL),(431,NULL,'9a490e2a0aaf45cdbc2ecb10d7a9bfed',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:04:31',NULL,'2026-01-22 00:04:31',NULL,NULL),(432,NULL,'706fb3ddd452478a83e5c560fbf54782',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:04:32',NULL,'2026-01-22 00:04:32',NULL,NULL),(433,NULL,NULL,'2ea8ba2717154b40920e955813dff6b4',NULL,NULL,NULL,NULL,'2026-01-22 00:04:35',NULL,'2026-01-22 00:04:35',NULL,NULL),(434,NULL,NULL,'6ed7bf83d3aa4fe9b286e0011f45baa0',NULL,NULL,NULL,NULL,'2026-01-22 00:04:36',NULL,'2026-01-22 00:04:36',NULL,NULL),(435,NULL,'b6116f0e36cf47abb510495dbee8f036',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:04:36',NULL,'2026-01-22 00:04:36',NULL,NULL),(436,NULL,'124c09e1844d46eeaca9e876f3348d40',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:04:37',NULL,'2026-01-22 00:04:37',NULL,NULL),(437,NULL,NULL,'8917f72c193d4ac1b4826f26488817a7',NULL,NULL,NULL,NULL,'2026-01-22 00:05:03',NULL,'2026-01-22 00:05:03',NULL,NULL),(438,NULL,NULL,'fecea7b8a8594860898a94769bb2125d',NULL,NULL,NULL,NULL,'2026-01-22 00:05:03',NULL,'2026-01-22 00:05:03',NULL,NULL),(439,NULL,'cfcbf05850f3401a969f66582339818a',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:05:04',NULL,'2026-01-22 00:05:04',NULL,NULL),(440,NULL,NULL,'1c13f653a95c42b4b57576f90a7703e5',NULL,NULL,NULL,NULL,'2026-01-22 00:05:31',NULL,'2026-01-22 00:05:31',NULL,NULL),(441,NULL,NULL,'b29cb13a041b4d9d86532f76ddd34f4e',NULL,NULL,NULL,NULL,'2026-01-22 00:05:31',NULL,'2026-01-22 00:05:31',NULL,NULL),(442,NULL,'389a3216514a4d6b88242b36af5ccbd7',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:05:33',NULL,'2026-01-22 00:05:33',NULL,NULL),(443,NULL,'67b43a1d13ae4cb59e8abd0c296336a0',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:05:34',NULL,'2026-01-22 00:05:34',NULL,NULL),(444,NULL,NULL,'7b784e216d684b75891facc5ba1a06e1',NULL,NULL,NULL,NULL,'2026-01-22 00:05:36',NULL,'2026-01-22 00:05:36',NULL,NULL),(445,NULL,NULL,'6b74d1f05625426e8e6d85f4fb852785',NULL,NULL,NULL,NULL,'2026-01-22 00:05:36',NULL,'2026-01-22 00:05:36',NULL,NULL),(446,NULL,'bc70754384694819b334edc165eaa694',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:05:38',NULL,'2026-01-22 00:05:38',NULL,NULL),(447,NULL,'b006a602f3df4d51862bae68bf4d9599',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:05:39',NULL,'2026-01-22 00:05:39',NULL,NULL),(448,NULL,NULL,'aab8583f35614558ae6a40b50d3119df',NULL,NULL,NULL,NULL,'2026-01-22 00:06:31',NULL,'2026-01-22 00:06:31',NULL,NULL),(449,NULL,NULL,'c1865c0f44ed44d39fb5cd2b51910676',NULL,NULL,NULL,NULL,'2026-01-22 00:06:31',NULL,'2026-01-22 00:06:31',NULL,NULL),(450,NULL,'4655fadafba24b5db7b30502b0c37b50',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:06:32',NULL,'2026-01-22 00:06:32',NULL,NULL),(451,NULL,'166f272aa8344095942ee82fc0ed5cb5',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:06:32',NULL,'2026-01-22 00:06:32',NULL,NULL),(452,NULL,NULL,'dba5814649674fe9ad2558ee7f33f968',NULL,NULL,NULL,NULL,'2026-01-22 00:07:35',NULL,'2026-01-22 00:07:35',NULL,NULL),(453,NULL,NULL,'817e1b3660ca428c9fa8cf10e24a3deb',NULL,NULL,NULL,NULL,'2026-01-22 00:07:35',NULL,'2026-01-22 00:07:35',NULL,NULL),(454,NULL,NULL,'201aecc92a434ca6bba2ce84d5153d64',NULL,NULL,NULL,NULL,'2026-01-22 00:07:35',NULL,'2026-01-22 00:07:35',NULL,NULL),(455,NULL,'3e625f3492d844d5b7a412e61733a3d3',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:07:37',NULL,'2026-01-22 00:07:37',NULL,NULL),(456,NULL,'2f1c8b267c67410ab22540cc72729ac8',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:07:38',NULL,'2026-01-22 00:07:38',NULL,NULL),(457,NULL,'3261d24eeb6241c786505ff2c687e6e6',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:07:39',NULL,'2026-01-22 00:07:39',NULL,NULL),(458,NULL,NULL,'08ab0fd4f3074df0a1ae55943c5c34e4',NULL,NULL,NULL,NULL,'2026-01-22 00:08:06',NULL,'2026-01-22 00:08:06',NULL,NULL),(459,NULL,NULL,'b9385e84224d44d5bea12873cdfc7110',NULL,NULL,NULL,NULL,'2026-01-22 00:08:06',NULL,'2026-01-22 00:08:06',NULL,NULL),(460,NULL,'a61365deddf44af9af621477c10c5e62',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:08:07',NULL,'2026-01-22 00:08:07',NULL,NULL),(461,NULL,'fc3cab1b1a7b4d81a2c0183f45084908',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:08:08',NULL,'2026-01-22 00:08:08',NULL,NULL),(462,NULL,NULL,'6c9a96b8337044129367ce792b2ab8b5',NULL,NULL,NULL,NULL,'2026-01-22 00:08:19',NULL,'2026-01-22 00:08:19',NULL,NULL),(463,NULL,NULL,'5e49963c3896456a878ceb884eb8288e',NULL,NULL,NULL,NULL,'2026-01-22 00:08:19',NULL,'2026-01-22 00:08:19',NULL,NULL),(464,NULL,'cabf576d767b4494865fb4949a351473',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:08:20',NULL,'2026-01-22 00:08:20',NULL,NULL),(465,NULL,'0099e22592ef40e99b62b099b6902424',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:08:21',NULL,'2026-01-22 00:08:21',NULL,NULL),(466,NULL,NULL,'19bb72c07b004b2cbc9628e145ed9a06',NULL,NULL,NULL,NULL,'2026-01-22 00:08:34',NULL,'2026-01-22 00:08:34',NULL,NULL),(467,NULL,NULL,'28f9de5f686242bfb9513f8430feb8f8',NULL,NULL,NULL,NULL,'2026-01-22 00:08:34',NULL,'2026-01-22 00:08:34',NULL,NULL),(468,NULL,'4bee9cd6c46a408cababd9be760cc6ae',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:08:35',NULL,'2026-01-22 00:08:35',NULL,NULL),(469,NULL,'0273441b3ef54a0f90eb174678b36e90',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:08:37',NULL,'2026-01-22 00:08:37',NULL,NULL),(470,NULL,NULL,'02ea727293a94f409faa1da6217dedbd',NULL,NULL,NULL,NULL,'2026-01-22 00:08:59',NULL,'2026-01-22 00:08:59',NULL,NULL),(471,NULL,NULL,'f5b5cafdf5e34b19b54391f1b1c9a233',NULL,NULL,NULL,NULL,'2026-01-22 00:09:00',NULL,'2026-01-22 00:09:00',NULL,NULL),(472,NULL,'613f7338dada4fd3bd3137410d23e526',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:09:00',NULL,'2026-01-22 00:09:00',NULL,NULL),(473,NULL,'f94fceb0c5384e9ba9cd17e3a3a16734',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:09:04',NULL,'2026-01-22 00:09:04',NULL,NULL),(474,NULL,NULL,'7c4d32b01e1042dcbc3bbd13debea614',NULL,NULL,NULL,NULL,'2026-01-22 00:14:12',NULL,'2026-01-22 00:14:12',NULL,NULL),(475,NULL,NULL,'b274097907bf4c0f9ba83f180fbbe19f',NULL,NULL,NULL,NULL,'2026-01-22 00:14:12',NULL,'2026-01-22 00:14:12',NULL,NULL),(476,NULL,'7635a83e2cd346d588ac6887dd532927',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:14:13',NULL,'2026-01-22 00:14:13',NULL,NULL),(477,NULL,'82ee2d3124cb401892d929f189b6a966',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:14:14',NULL,'2026-01-22 00:14:14',NULL,NULL),(478,NULL,NULL,'dbe6aab9c30c468fab4abab80c152360',NULL,NULL,NULL,NULL,'2026-01-22 00:15:04',NULL,'2026-01-22 00:15:04',NULL,NULL),(479,NULL,NULL,'15e7b6bfc0a7462c97e47121de748d2e',NULL,NULL,NULL,NULL,'2026-01-22 00:15:04',NULL,'2026-01-22 00:15:04',NULL,NULL),(480,NULL,'0d3acfeae0054dc9a61738b444c36769',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:15:05',NULL,'2026-01-22 00:15:05',NULL,NULL),(481,NULL,'e2f0b6c9b06543ee9aa50a06847cbf17',NULL,NULL,NULL,NULL,NULL,'2026-01-22 00:15:06',NULL,'2026-01-22 00:15:06',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('2b5ffe180a2e4fe0b1de66b638c9c85b','reader','{}','<<null>>',NULL),('6dfeff807890451d950a600b521661b9','admin','{}','<<null>>',NULL),('6e90bbc0e8b94ddcab2a0b0041ad6d6e','service','{}','<<null>>',NULL),('8e681675670548328c4ae3e21eb5df72','member','{}','<<null>>',NULL),('92ebb9c9566b4e1cb24f3f9d1deabfdd','swiftoperator','{}','<<null>>',NULL),('c4f80839fe5b45b39750bac196a9e29d','ResellerAdmin','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('2b5ffe180a2e4fe0b1de66b638c9c85b','IMMU','true'),('6dfeff807890451d950a600b521661b9','IMMU','true'),('8e681675670548328c4ae3e21eb5df72','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('3c853f309bc44f0f877a4217b3af5019','identity',1,'{\"name\": \"keystone\"}'),('4852131d560d4d558ec29a60dba761be','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('4f54e216d34b4ba48069381c90ee33ac','object-store',1,'{\"name\": \"swift\", \"description\": \"OpenStack Object Storage\"}'),('59b5067377f24de8b9da7b1826366170','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('5ff6589e7d21439991d8cc17fe0cf038','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('9628e0b3c48a43c9a28a2067bb180a8c','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('9df97733489048c08c2eca494189a569','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('c1746ec304274dbbb5c009b751d15a1e','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('f713c86201d14330abcb99f86caa5734','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','ac7c110b3bf94315958af6a870517373','system','6dfeff807890451d950a600b521661b9',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_trust_id` (`trust_id`),
  KEY `ix_token_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('0228906e289f49ac86000f5d8be7b934','{}',1,'3e8e30a1ae274ce9b972eec5113440da','2026-01-21 23:26:56',NULL,'default'),('33b86325be15482cbc486b553260f94c','{\"tenantId\": \"c3b2aee15e7f48af8c36b6e6a547eada\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2026-01-21 23:48:26',NULL,'default'),('6d0028a6ebcc4a34b205c0a27de00597','{}',1,'3e8e30a1ae274ce9b972eec5113440da','2026-01-21 23:10:38','2026-01-22','default'),('8c6a7500640f40b1af71d3803c3a85dc','{}',1,'3e8e30a1ae274ce9b972eec5113440da','2026-01-21 23:10:33','2026-01-21','default'),('9161a0e438fd43c1a6f2614e7947727f','{}',1,'3e8e30a1ae274ce9b972eec5113440da','2026-01-21 23:10:35','2026-01-21','default'),('a8a5722f544c4e1b9905e91d63b82d96','{}',1,'3e8e30a1ae274ce9b972eec5113440da','2026-01-21 23:10:46','2026-01-22','default'),('ac7c110b3bf94315958af6a870517373','{}',1,NULL,'2026-01-21 23:09:31','2026-01-22','default'),('c6dd2f2905824c17b8a204db256c15be','{}',1,'3e8e30a1ae274ce9b972eec5113440da','2026-01-21 23:10:41','2026-01-22','default'),('ce87e1d35e2a46ff864dd81d9706ca6b','{\"tenantId\": \"a2ff6353fc4a495895f6769c710dd0f5\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2026-01-21 23:48:25',NULL,'default'),('eb4862c0e23948f4ba99072c812b54c2','{}',1,'3e8e30a1ae274ce9b972eec5113440da','2026-01-21 23:10:59','2026-01-21','default'),('f81ebd55cbf14f05ba753a6d9e0ebd6e','{}',1,'3e8e30a1ae274ce9b972eec5113440da','2026-01-21 23:10:55','2026-01-22','default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','glance','glance_4e98','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_4e98','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','keystone','keystone_778f','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','placement','placement_364f','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_778f','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_364f','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_9bb4','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_dcda','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_9bb4','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_dcda','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_cce9','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_cce9','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_6949','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_1ac6','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_6949','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_1ac6','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1769036928}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1769036928}'),('localhost','glance_4e98','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*2E95C13F425860EE0BEFB876C07AFC19A199A892\",\"password_last_changed\":1769036917}'),('%','glance_4e98','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*2E95C13F425860EE0BEFB876C07AFC19A199A892\",\"password_last_changed\":1769036917}'),('localhost','keystone_778f','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*1926944931C17DC2F611620FE5B03A25314F791B\",\"password_last_changed\":1769036921}'),('localhost','placement_364f','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*FBC8856DD2F5526872ACD860B10FCADC50B65306\",\"password_last_changed\":1769036921}'),('%','keystone_778f','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*1926944931C17DC2F611620FE5B03A25314F791B\",\"password_last_changed\":1769036921}'),('%','placement_364f','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*FBC8856DD2F5526872ACD860B10FCADC50B65306\",\"password_last_changed\":1769036921}'),('localhost','barbican_9bb4','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*4F1E322BBCD836F5E8EC49C4F9F4A700024B80AF\",\"password_last_changed\":1769036948}'),('localhost','cinder_dcda','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*DAC983BA9075A8E6129ECC79313FF370FB71C9B7\",\"password_last_changed\":1769036948}'),('%','barbican_9bb4','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*4F1E322BBCD836F5E8EC49C4F9F4A700024B80AF\",\"password_last_changed\":1769036948}'),('%','cinder_dcda','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*DAC983BA9075A8E6129ECC79313FF370FB71C9B7\",\"password_last_changed\":1769036948}'),('localhost','neutron_cce9','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*2799EB235BB29CF54ECE90E1801DA858FE715509\",\"password_last_changed\":1769036949}'),('%','neutron_cce9','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*2799EB235BB29CF54ECE90E1801DA858FE715509\",\"password_last_changed\":1769036949}'),('localhost','nova_cell0_6949','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*4BA6C470CA185BC9105EBC0399FFF4E0DE8AA661\",\"password_last_changed\":1769037045}'),('localhost','nova_api_1ac6','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*404683B2DAFF774DE53CB96CD9DA80E20A9BE9CA\",\"password_last_changed\":1769037045}'),('%','nova_cell0_6949','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*4BA6C470CA185BC9105EBC0399FFF4E0DE8AA661\",\"password_last_changed\":1769037045}'),('%','nova_api_1ac6','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*404683B2DAFF774DE53CB96CD9DA80E20A9BE9CA\",\"password_last_changed\":1769037045}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mysql_plugin\n-------------------------------------\n\nA plugin can be installed with the mysql_plugin utility if the server is\ncompletely offline.\n\nThe syntax is:\n\nmysql_plugin [options] <plugin> ENABLE|DISABLE\n\nFor example, to install the server_audit audit plugin, you could execute the\nfollowing:\n\nmysql_plugin server_audit ENABLE\n\nIf a plugin is installed with this utility, then a record will be added to the\nmysql.plugins table for the plugin. This means that the plugin will\nautomatically be loaded every time the server restarts, unless specifically\nuninstalled or deactivated.\n\nConfiguring the Plugin Directory\n--------------------------------\n\nWhen a plugin is being installed, the server looks for the plugin\'s library in\nthe server\'s plugin directory. This directory is configured by the plugin_dir\nsystem variable. This can be specified as a command-line argument to mysqld or\nit can be specified in a relevant server option group in an option file. For\nexample:\n\n[mariadb]\n...\nplugin_dir = /usr/lib64/mysql/plugin\n\nConfiguring the Minimum Plugin Maturity\n---------------------------------------\n\nWhen a plugin is being installed, the server compares the plugin\'s maturity\nlevel against the server\'s minimum allowed plugin maturity. This can help\nprevent users from using unstable plugins on production servers. This minimum\nplugin maturity is configured by the plugin_maturity system variable. This can\nbe specified as a command-line argument to mysqld or it can be specified in a\nrelevant server option group in an option file. For example:\n\n[mariadb]\n...\nplugin_maturity = stable\n\nConfiguring Plugin Activation at Server Startup\n-----------------------------------------------\n\nA plugin will be loaded by default when the server starts if:\n\n* The plugin was installed with the INSTALL SONAME statement.\n* The plugin was installed with the INSTALL PLUGIN statement.\n* The plugin was installed with the mysql_plugin utility.\n* The server is configured to load the plugin with the --plugin-load-add\noption.\n* The server is configured to load the plugin with the --plugin-load option.\n\nThis behavior can be changed with special options that take the form\n--plugin-name. For example, for the server_audit audit plugin, the special\noption is called --server-audit.\n\nThe possible values for these special options are:\n\n+---------------------------------------+------------------------------------+\n| Option Value                          | Description                        |\n+---------------------------------------+------------------------------------+\n| OFF                                   | Disables the plugin without        |\n|                                       | removing it from the               |\n|                                       | mysql.plugins table.               |\n+---------------------------------------+------------------------------------+\n| ON                                    | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will still continue         |\n|                                       | starting up, but the plugin will   |\n|                                       | be disabled.                       |\n+---------------------------------------+------------------------------------+\n| FORCE                                 | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error.                             |\n+---------------------------------------+------------------------------------+\n| FORCE_PLUS_PERMANENT                  | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error. In addition, the plugin     |\n|                                       | cannot be uninstalled with         |\n|                                       | UNINSTALL SONAME or UNINSTALL      |\n|                                       | PLUGIN while the server is         |\n|                                       | running.                           |\n+---------------------------------------+------------------------------------+\n\nA plugin\'s status can be found by looking at the PLUGIN_STATUS column of the\ninformation_schema.PLUGINS table.\n\nUninstalling Plugins\n--------------------\n\nPlugins that are found in the mysql.plugin table, that is those that were\ninstalled with INSTALL SONAME, INSTALL PLUGIN or mysql_plugin can be\nuninstalled in one of two ways:\n\n* The UNINSTALL SONAME or the UNINSTALL PLUGIN statement while the server is\nrunning\n* With mysql_plugin while the server is offline.\n\nPlugins that were enabled as a --plugin-load option do not need to be\nuninstalled. If --plugin-load is omitted the next time the server starts, or\nthe plugin is not listed as one of the --plugin-load entries, the plugin will\nnot be loaded.\n\nUNINSTALL PLUGIN uninstalls a single installed plugin, while UNINSTALL SONAME\nuninstalls all plugins belonging to a given library.\n\nURL: https://mariadb.com/kb/en/plugin-overview/','','https://mariadb.com/kb/en/plugin-overview/'),(79,'MBR Definition',6,'Description\n-----------\n\nThe MBR (Minimum Bounding Rectangle), or Envelope is the bounding geometry,\nformed by the minimum and maximum (X,Y) coordinates:\n\nExamples\n--------\n\n((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nURL: https://mariadb.com/kb/en/mbr-definition/','','https://mariadb.com/kb/en/mbr-definition/'),(80,'MBRContains',6,'Syntax\n------\n\nMBRContains(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\ncontains the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\n\nSET @g2 = GeomFromText(\'Point(1 1)\');\n\nSELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n+----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrcontains/','','https://mariadb.com/kb/en/mbrcontains/'),(82,'MBREqual',6,'Syntax\n------\n\nMBREqual(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are the same.\n\nExamples\n--------\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 2)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 2, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 3)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 4, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 0 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/mbrequal/','','https://mariadb.com/kb/en/mbrequal/'),(86,'MBRWithin',6,'Syntax\n------\n\nMBRWithin(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1 is\nwithin the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRContains().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nSELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n\nURL: https://mariadb.com/kb/en/mbrwithin/','','https://mariadb.com/kb/en/mbrwithin/'),(75,'UNINSTALL PLUGIN',5,'Syntax\n------\n\nUNINSTALL PLUGIN [IF EXISTS] plugin_name\n\nDescription\n-----------\n\nThis statement removes a single installed plugin. To uninstall the whole\nlibrary which contains the plugin, use UNINSTALL SONAME. You cannot uninstall\na plugin if any table that uses it is open.\n\nplugin_name must be the name of some plugin that is listed in the mysql.plugin\ntable. The server executes the plugin\'s deinitialization function and removes\nthe row for the plugin from the mysql.plugin table, so that subsequent server\nrestarts will not load and initialize the plugin. UNINSTALL PLUGIN does not\nremove the plugin\'s shared library file.\n\nTo use UNINSTALL PLUGIN, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nUNINSTALL PLUGIN example;\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------+\n| Level | Code | Message                       |\n+-------+------+-------------------------------+\n| Note  | 1305 | PLUGIN example does not exist |\n+-------+------+-------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-plugin/','','https://mariadb.com/kb/en/uninstall-plugin/'),(76,'INSTALL SONAME',5,'Syntax\n------\n\nINSTALL SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of INSTALL PLUGIN. It installs all plugins from a\ngiven plugin_library. See INSTALL PLUGIN for details.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL SONAME adds one or more lines to the mysql.plugin table that describes\nthe plugin. This table contains the plugin name and library file name.\n\nINSTALL SONAME causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL SONAME also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL SONAME, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nSONAME only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nIf you need to install only one plugin from a library, use the INSTALL PLUGIN\nstatement.\n\nExamples\n--------\n\nTo load the XtraDB storage engine and all of its information_schema tables\nwith one statement, use\n\nINSTALL SONAME \'ha_xtradb\';\n\nThis statement can be used instead of INSTALL PLUGIN even when the library\ncontains only one plugin:\n\nINSTALL SONAME \'ha_sequence\';\n\nURL: https://mariadb.com/kb/en/install-soname/','','https://mariadb.com/kb/en/install-soname/'),(77,'UNINSTALL SONAME',5,'Syntax\n------\n\nUNINSTALL SONAME  [IF EXISTS] \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of UNINSTALL PLUGIN statement, that removes all\nplugins belonging to a specified plugin_library. See UNINSTALL PLUGIN for\ndetails.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nTo use UNINSTALL SONAME, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin library does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nTo uninstall the XtraDB plugin and all of its information_schema tables with\none statement, use\n\nUNINSTALL SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------------+\n| Level | Code | Message                             |\n+-------+------+-------------------------------------+\n| Note  | 1305 | SONAME ha_example.so does not exist |\n+-------+------+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-soname/','','https://mariadb.com/kb/en/uninstall-soname/'),(90,'NULLIF',7,'Syntax\n------\n\nNULLIF(expr1,expr2)\n\nDescription\n-----------\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is the\nsame as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nExamples\n--------\n\nSELECT NULLIF(1,1);\n+-------------+\n| NULLIF(1,1) |\n+-------------+\n|        NULL |\n+-------------+\n\nSELECT NULLIF(1,2);\n+-------------+\n| NULLIF(1,2) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/nullif/','','https://mariadb.com/kb/en/nullif/'),(91,'NVL',7,'MariaDB starting with 10.3\n--------------------------\nFrom MariaDB 10.3, NVL is a synonym for IFNULL.\n\nURL: https://mariadb.com/kb/en/nvl/','','https://mariadb.com/kb/en/nvl/'),(92,'NVL2',7,'MariaDB starting with 10.3\n--------------------------\nThe NLV2 function was introduced in MariaDB 10.3.0.\n\nSyntax\n------\n\nNVL2(expr1,expr2,expr3)\n\nDescription\n-----------\n\nThe NVL2 function returns a value based on whether a specified expression is\nNULL or not. If expr1 is not NULL, then NVL2 returns expr2. If expr1 is NULL,\nthen NVL2 returns expr3.\n\nExamples\n--------\n\nSELECT NVL2(NULL,1,2);\n+----------------+\n| NVL2(NULL,1,2) |\n+----------------+\n|              2 |\n+----------------+\n\nSELECT NVL2(\'x\',1,2);\n+---------------+\n| NVL2(\'x\',1,2) |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/nvl2/','','https://mariadb.com/kb/en/nvl2/'),(81,'MBRDisjoint',6,'Syntax\n------\n\nMBRDisjoint(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are disjoint. Two geometries are disjoint if they do not\nintersect, that is touch or overlap.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECTmbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrdisjoint/','','https://mariadb.com/kb/en/mbrdisjoint/'),(83,'MBRIntersects',6,'Syntax\n------\n\nMBRIntersects(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 intersect.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      1 |\n+------------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      0 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/mbrintersects/','','https://mariadb.com/kb/en/mbrintersects/'),(84,'MBROverlaps',6,'Syntax\n------\n\nMBROverlaps(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 overlap. The term spatially overlaps is used if two\ngeometries intersect and their intersection results in a geometry of the same\ndimension but not equal to either of the given geometries.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbroverlaps/','','https://mariadb.com/kb/en/mbroverlaps/'),(85,'MBRTouches',6,'Syntax\n------\n\nMBRTouches(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 touch. Two geometries spatially touch if the interiors of\nthe geometries do not intersect, but the boundary of one of the geometries\nintersects either the boundary or the interior of the other.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   1 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/mbrtouches/','','https://mariadb.com/kb/en/mbrtouches/'),(87,'CASE OPERATOR',7,'Syntax\n------\n\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nDescription\n-----------\n\nThe first version returns the result where value=compare_value. The second\nversion returns the result for the first condition that is true. If there was\nno matching result value, the result after ELSE is returned, or NULL if there\nis no ELSE part.\n\nThere is also a CASE statement, which differs from the CASE operator described\nhere.\n\nExamples\n--------\n\nSELECT CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END;\n+------------------------------------------------------------+\n| CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END |\n+------------------------------------------------------------+\n| one                                                        |\n+------------------------------------------------------------+\n\nSELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n+--------------------------------------------+\n| CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END |\n+--------------------------------------------+\n| true                                       |\n+--------------------------------------------+\n\nSELECT CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n+-----------------------------------------------------+\n| CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END |\n+-----------------------------------------------------+\n|                                                NULL |\n+-----------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/case-operator/','','https://mariadb.com/kb/en/case-operator/'),(101,'UNLOCK TABLES',8,'Syntax\n------\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\nSee LOCK TABLES for more information.\n\nIn addition to releasing table locks acquired by the LOCK TABLES statement,\nthe UNLOCK TABLES statement also releases the global read lock acquired by the\nFLUSH TABLES WITH READ LOCK statement. The FLUSH TABLES WITH READ LOCK\nstatement is very useful for performing backups. See FLUSH for more\ninformation about FLUSH TABLES WITH READ LOCK.\n\nURL: https://mariadb.com/kb/en/transactions-unlock-tables/','','https://mariadb.com/kb/en/transactions-unlock-tables/'),(103,'XA Transactions',8,'Overview\n--------\n\nThe MariaDB XA implementation is based on the X/Open CAE document Distributed\nTransaction Processing: The XA Specification. This document is published by\nThe Open Group and available at\nhttp://www.opengroup.org/public/pubs/catalog/c193.htm.\n\nXA transactions are designed to allow distributed transactions, where a\ntransaction manager (the application) controls a transaction which involves\nmultiple resources. Such resources are usually DBMSs, but could be resources\nof any type. The whole set of required transactional operations is called a\nglobal transaction. Each subset of operations which involve a single resource\nis called a local transaction. XA used a 2-phases commit (2PC). With the first\ncommit, the transaction manager tells each resource to prepare an effective\ncommit, and waits for a confirm message. The changes are not still made\neffective at this point. If any of the resources encountered an error, the\ntransaction manager will rollback the global transaction. If all resources\ncommunicate that the first commit is successful, the transaction manager can\nrequire a second commit, which makes the changes effective.\n\nIn MariaDB, XA transactions can only be used with storage engines that support\nthem. At least InnoDB, TokuDB, SPIDER and MyRocks support them. For InnoDB,\nuntil MariaDB 10.2, XA transactions can be disabled by setting the\ninnodb_support_xa server system variable to 0. From MariaDB 10.3, XA\ntransactions are always supported.\n\nLike regular transactions, XA transactions create metadata locks on accessed\ntables.\n\nXA transactions require REPEATABLE READ as a minimum isolation level. However,\ndistributed transactions should always use SERIALIZABLE.\n\nTrying to start more than one XA transaction at the same time produces a 1400\nerror (SQLSTATE \'XAE09\'). The same error is produced when attempting to start\nan XA transaction while a regular transaction is in effect. Trying to start a\nregular transaction while an XA transaction is in effect produces a 1399 error\n(SQLSTATE \'XAE07\').\n\nThe statements that cause an implicit COMMIT for regular transactions produce\na 1400 error (SQLSTATE \'XAE09\') if a XA transaction is in effect.\n\nInternal XA vs External XA\n--------------------------\n\nXA transactions are an overloaded term in MariaDB. If a storage engine is\nXA-capable, it can mean one or both of these:\n\n* It supports MariaDB\'s internal two-phase commit API. This is transparent to\nthe user. Sometimes this is called \"internal XA\", since MariaDB\'s internal\ntransaction coordinator log can handle coordinating these transactions.\n\n* It supports XA transactions, with the XA START, XA PREPARE, XA COMMIT, etc.\nstatements. Sometimes this is called \"external XA\", since it requires the use\nof an external transaction coordinator to use this feature properly.\n\nTransaction Coordinator Log\n---------------------------\n\nIf you have two or more XA-capable storage engines enabled, then a transaction\ncoordinator log must be available.\n\nThere are currently two implementations of the transaction coordinator log:\n\n* Binary log-based transaction coordinator log\n* Memory-mapped file-based transaction coordinator log\n\nIf the binary log is enabled on a server, then the server will use the binary\nlog-based transaction coordinator log. Otherwise, it will use the\nmemory-mapped file-based transaction coordinator log.\n\nSee Transaction Coordinator Log for more information.\n\nSyntax\n------\n\nXA {START|BEGIN} xid [JOIN|RESUME]\n\nXA END xid [SUSPEND [FOR MIGRATE]]\n\nXA PREPARE xid\n\nXA COMMIT xid [ONE PHASE]\n\nXA ROLLBACK xid\n\nXA RECOVER [FORMAT=[\'RAW\'|\'SQL\']]\n\nxid: gtrid [, bqual [, formatID ]]\n\nThe interface to XA transactions is a set of SQL statements starting with XA.\nEach statement changes a transaction\'s state, determining which actions it can\nperform. A transaction which does not exist is in the NON-EXISTING state.\n\nXA START (or BEGIN) starts a transaction and defines its xid (a transaction\nidentifier). The JOIN or RESUME keywords have no effect. The new transaction\nwill be in ACTIVE state.\n\nThe xid can have 3 components, though only the first one is mandatory. gtrid\nis a quoted string representing a global transaction identifier. bqual is a\nquoted string representing a local transaction identifier. formatID is an\nunsigned integer indicating the format used for the first two components; if\nnot specified, defaults to 1. MariaDB does not interpret in any way these\ncomponents, and only uses them to identify a transaction. xids of transactions\nin effect must be unique.\n\nXA END declares that the specified ACTIVE transaction is finished and it\nchanges its state to IDLE. SUSPEND [FOR MIGRATE] has no effect.\n\nXA PREPARE prepares an IDLE transaction for commit, changing its state to\nPREPARED. This is the first commit.\n\nXA COMMIT definitely commits and terminates a transaction which has already\nbeen PREPARED. If the ONE PHASE clause is specified, this statements performs\na 1-phase commit on an IDLE transaction.\n\nXA ROLLBACK rolls back and terminates an IDLE or PREPARED transaction.\n\nXA RECOVER shows information about all PREPARED transactions.\n\nWhen trying to execute an operation which is not allowed for the transaction\'s\ncurrent state, an error is produced:\n\nXA COMMIT \'test\' ONE PHASE;\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  ACTIVE state\n\nXA COMMIT \'test2\';\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  NON-EXISTING state\n\nXA RECOVER\n----------\n\nThe XA RECOVER statement shows information about all transactions which are in\nthe PREPARED state. It does not matter which connection created the\ntransaction: if it has been PREPARED, it appears. But this does not mean that\na connection can commit or rollback a transaction which was started by another\nconnection. Note that transactions using a 1-phase commit are never in the\nPREPARED state, so they cannot be shown by XA RECOVER.\n\nXA RECOVER produces four columns:\n\nXA RECOVER;\n+----------+--------------+--------------+------+\n| formatID | gtrid_length | bqual_length | data |\n+----------+--------------+--------------+------+\n|        1 |            4 |            0 | test |\n+----------+--------------+--------------+------+\n\nMariaDB starting with 10.3.3\n----------------------------\nYou can use XA RECOVER FORMAT=\'SQL\' to get the data in a human readable form\nthat can be directly copy-pasted into XA COMMIT or XA ROLLBACK. This is\nparticularly useful for binary xid generated by some transaction coordinators.\n\nformatID is the formatID part of xid.\n\ndata are the gtrid and bqual parts of xid, concatenated.\n\ngtrid_length and bqual_length are the lengths of gtrid and bqual, respectevely.\n\nExamples\n--------\n\n2-phases commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA PREPARE \'test\';\n\nXA COMMIT \'test\';\n\n1-phase commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA COMMIT \'test\' ONE PHASE;\n\nHuman-readable:\n\nxa start \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\ninsert t1 values (40);\n\nxa end \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa prepare \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa recover format=\'RAW\';\n+----------+--------------+--------------+--------------------+\n| formatID | gtrid_length | bqual_length | data               |\n+----------+--------------+--------------+--------------------+\n34      67v78abc       11 |            7 | 12\ndef |\n+----------+--------------+--------------+--------------------+\n\nxa recover format=\'SQL\';\n+----------+--------------+--------------+-------------------------------------\n---------+\n| formatID | gtrid_length | bqual_length | data                               \n     |\n+----------+--------------+--------------+-------------------------------------\n---------+\n|        3 |           11 |            7 |\nX\'31320d3334093637763738\',X\'6162630a646566\',3 |\n+----------+--------------+--------------+-------------------------------------\n---------+\n\nxa rollback X\'31320d3334093637763738\',X\'6162630a646566\',3;\n\nKnown Issues\n------------\n\nMariaDB Galera Cluster\n----------------------\n\nMariaDB Galera Cluster does not support XA transactions.\n\nHowever, MariaDB Galera Cluster builds include a built-in plugin called wsrep.\nPrior to MariaDB 10.4.3, this plugin was internally considered an XA-capable\nstorage engine. Consequently, these MariaDB Galera Cluster builds have\nmultiple XA-capable storage engines by default, even if the only \"real\"\nstorage engine that supports external XA transactions enabled on these builds\nby default is InnoDB. Therefore, when using one these builds MariaDB would be\nforced to use a transaction coordinator log by default, which could have\nperformance implications.\n\nSee Transaction Coordinator Log Overview: MariaDB Galera Cluster for more\ninformation.\n\nURL: https://mariadb.com/kb/en/xa-transactions/','','https://mariadb.com/kb/en/xa-transactions/'),(104,'CREATE USER',10,'Syntax\n------\n\nCREATE [OR REPLACE] USER [IF NOT EXISTS] \n user_specification [,user_specification ...] \n [REQUIRE {NONE | tls_option [[AND] tls_option ...] }]\n [WITH resource_option [resource_option ...] ]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe CREATE USER statement creates new MariaDB accounts. To use it, you must\nhave the global CREATE USER privilege or the INSERT privilege for the mysql\ndatabase. For each account, CREATE USER creates a new row in mysql.user (until\nMariaDB 10.3 this is a table, from MariaDB 10.4 it\'s a view) or\nmysql.global_priv_table (from MariaDB 10.4) that has no privileges.\n\nIf any of the specified accounts, or any permissions for the specified\naccounts, already exist, then the server returns ERROR 1396 (HY000). If an\nerror occurs, CREATE USER will still create the accounts that do not result in\nan error. Only one error is produced for all users which have not been created:\n\nERROR 1396 (HY000): \n Operation CREATE USER failed for \'u1\'@\'%\',\'u2\'@\'%\'\n\nCREATE USER, DROP USER, CREATE ROLE, and DROP ROLE all produce the same error\ncode when they fail.\n\nSee Account Names below for details on how account names are specified.\n\nOR REPLACE\n----------\n\nIf the optional OR REPLACE clause is used, it is basically a shortcut for:\n\nDROP USER IF EXISTS name;\nCREATE USER name ...;\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE OR REPLACE USER foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected (0.00 sec)\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified user already exists.\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE USER IF NOT EXISTS foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+----------------------------------------------------+\n| Level | Code | Message                                            |\n+-------+------+----------------------------------------------------+\n| Note  | 1973 | Can\'t create user \'foo2\'@\'test\'; it already exists |\n+-------+------+----------------------------------------------------+\n\nAuthentication Options\n----------------------\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored in the\nmysql.user/mysql.global_priv_table table.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nCREATE USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored in the\nmysql.user/mysql.global_priv_table table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nCREATE USER foo2@test IDENTIFIED BY PASSWORD\n\'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nCREATE USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nCREATE USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\') OR\nunix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nCREATE USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to create a user with resource limits:\n\nCREATE USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nAccount Names\n-------------\n\nAccount names have both a user name component and a host name component, and\nare specified as \'user_name\'@\'host_name\'.\n\nThe user name and host name may be unquoted, quoted as strings using double\nquotes (\") or single quotes (\'), or quoted as identifiers using backticks (`).\nYou must use quotes when using special characters (such as a hyphen) or\nwildcard characters. If you quote, you must quote the user name and host name\nseparately (for example \'user_name\'@\'host_name\').\n\nHost Name Component\n-------------------\n\nIf the host name is not provided, it is assumed to be \'%\'.\n\nHost names may contain the wildcard characters % and _. They are matched as if\nby the LIKE clause. If you need to use a wildcard character literally (for\nexample, to match a domain name with an underscore), prefix the character with\na backslash. See LIKE for more information on escaping wildcard characters.\n\nHost name matches are case-insensitive. Host names can match either domain\nnames or IP addresses. Use \'localhost\' as the host name to allow only local\nclient connections.\n\nYou can use a netmask to match a range of IP addresses using \'base_ip/netmask\'\nas the host name. A user with an IP address ip_addr will be allowed to connect\nif the following condition is true:\n\nip_addr & netmask = base_ip\n\nFor example, given a user:\n\nCREATE USER \'maria\'@\'247.150.130.0/255.255.255.0\';\n\nthe IP addresses satisfying this condition range from 247.150.130.0 to\n247.150.130.255.\n\nUsing 255.255.255.255 is equivalent to not using a netmask at all. Netmasks\ncannot be used for IPv6 addresses.\n\nNote that the credentials added when creating a user with the \'%\' wildcard\nhost will not grant access in all cases. For example, some systems come with\nan anonymous localhost user, and when connecting from localhost this will take\nprecedence.\n\nBefore MariaDB 10.6, the host name component could be up to 60 characters in\nlength. Starting from MariaDB 10.6, it can be up to 255 characters.\n\nUser Name Component\n-------------------\n\nUser names must match exactly, including case. A user name that is empty is\nknown as an anonymous account and is allowed to match a login attempt with any\nuser name component. These are described more in the next section.\n\nFor valid identifiers to use as user names, see Identifier Names.\n\nIt is possible for more than one account to match when a user connects.\nMariaDB selects the first matching account after sorting according to the\nfollowing criteria:\n\n* Accounts with an exact host name are sorted before accounts using a wildcard\nin the\nhost name. Host names using a netmask are considered to be exact for sorting.\n* Accounts with a wildcard in the host name are sorted according to the\nposition of\nthe first wildcard character. Those with a wildcard character later in the\nhost name\nsort before those with a wildcard character earlier in the host name.\n* Accounts with a non-empty user name sort before accounts with an empty user\nname.\n* Accounts with an empty user name are sorted last. As mentioned previously,\nthese are known as anonymous accounts. These are described more in the next\nsection.\n\nThe following table shows a list of example account as sorted by these\ncriteria:\n\n+---------+-------------+\n| User    | Host        |\n+---------+-------------+\n| joffrey | 192.168.0.3 |\n|         | 192.168.0.% |\n| joffrey | 192.168.%   |\n|         | 192.168.%   |\n+---------+-------------+\n\nOnce connected, you only have the privileges granted to the account that\nmatched, not all accounts that could have matched. For example, consider the\nfollowing commands:\n\nCREATE USER \'joffrey\'@\'192.168.0.3\';\nCREATE USER \'joffrey\'@\'%\';\nGRANT SELECT ON test.t1 to \'joffrey\'@\'192.168.0.3\';\nGRANT SELECT ON test.t2 to \'joffrey\'@\'%\';\n\nIf you connect as joffrey from 192.168.0.3, you will have the SELECT privilege\non the table test.t1, but not on the table test.t2. If you connect as joffrey\nfrom any other IP address, you will have the SELECT privilege on the table\ntest.t2, but not on the table test.t1.\n\nUsernames can be up to 80 characters long before 10.6 and starting from 10.6\nit can be 128 characters long.\n\nAnonymous Accounts\n------------------\n\nAnonymous accounts are accounts where the user name portion of the account\nname is empty. These accounts act as special catch-all accounts. If a user\nattempts to log into the system from a host, and an anonymous account exists\nwith a host name portion that matches the user\'s host, then the user will log\nin as the anonymous account if there is no more specific account match for the\nuser name that the user entered.\n\nFor example, here are some anonymous accounts:\n\nCREATE USER \'\'@\'localhost\';\nCREATE USER \'\'@\'192.168.0.3\';\n\nFixing a Legacy Default Anonymous Account\n-----------------------------------------\n\nOn some systems, the mysql.db table has some entries for the \'\'@\'%\' anonymous\naccount by default. Unfortunately, there is no matching entry in the\nmysql.user/mysql.global_priv_table table, which means that this anonymous\naccount doesn\'t exactly exist, but it does have privileges--usually on the\ndefault test database created by mysql_install_db. These account-less\nprivileges are a legacy that is leftover from a time when MySQL\'s privilege\nsystem was less advanced.\n\nThis situation means that you will run into errors if you try to create a\n\'\'@\'%\' account. For example:\n\nCREATE USER \'\'@\'%\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'\'@\'%\'\n\nThe fix is to DELETE the row in the mysql.db table and then execute FLUSH\nPRIVILEGES:\n\nDELETE FROM mysql.db WHERE User=\'\' AND Host=\'%\';\nFLUSH PRIVILEGES;\n\nAnd then the account can be created:\n\nCREATE USER \'\'@\'%\';\nQuery OK, 0 rows affected (0.01 sec)\n\nSee MDEV-13486 for more information.\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nCREATE USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/create-user/','','https://mariadb.com/kb/en/create-user/'),(105,'ALTER USER',10,'Syntax\n------\n\nALTER USER [IF EXISTS] \n user_specification [,user_specification] ...\n [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n [WITH resource_option [resource_option] ...]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule] ...\n\nauthentication_rule:\n authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe ALTER USER statement modifies existing MariaDB accounts. To use it, you\nmust have the global CREATE USER privilege or the UPDATE privilege for the\nmysql database. The global SUPER privilege is also required if the read_only\nsystem variable is enabled.\n\nIf any of the specified user accounts do not yet exist, an error results. If\nan error occurs, ALTER USER will still modify the accounts that do not result\nin an error. Only one error is produced for all users which have not been\nmodified.\n\nIF EXISTS\n---------\n\nWhen the IF EXISTS clause is used, MariaDB will return a warning instead of an\nerror for each specified user that does not exist.\n\nAccount Names\n-------------\n\nFor ALTER USER statements, account names are specified as the username\nargument in the same way as they are for CREATE USER statements. See account\nnames from the CREATE USER page for details on how account names are specified.\n\nCURRENT_USER or CURRENT_USER() can also be used to alter the account logged\ninto the current session. For example, to change the current user\'s password\nto mariadb:\n\nALTER USER CURRENT_USER() IDENTIFIED BY \'mariadb\';\n\nAuthentication Options\n----------------------\n\nMariaDB starting with 10.4\n--------------------------\nFrom MariaDB 10.4, it is possible to use more than one authentication plugin\nfor each user account. For example, this can be useful to slowly migrate users\nto the more secure ed25519 authentication plugin over time, while allowing the\nold mysql_native_password authentication plugin as an alternative for the\ntransitional period. See Authentication from MariaDB 10.4 for more.\n\nWhen running ALTER USER, not specifying an authentication option in the\nIDENTIFIED VIA clause will remove that authentication method. (However this\nwas not the case before MariaDB 10.4.13, see MDEV-21928)\n\nFor example, a user is created with the ability to authenticate via both a\npassword and unix_socket:\n\nCREATE USER \'bob\'@\'localhost\' \n IDENTIFIED VIA mysql_native_password USING PASSWORD(\'pwd\')\n OR unix_socket;\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED VIA mysql_native_password\n USING \'*975B2CD4FF9AE554FE8AD33168FBFC326D2021DD\'\n OR unix_socket\n\nIf the user\'s password is updated, but unix_socket authentication is not\nspecified in the IDENTIFIED VIA clause, unix_socket authentication will no\nlonger be permitted.\n\nALTER USER \'bob\'@\'localhost\' IDENTIFIED VIA mysql_native_password \n USING PASSWORD(\'pwd2\');\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED BY PASSWORD \'*38366FDA01695B6A5A9DD4E428D9FB8F7EB75512\'\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored to the mysql.user table.\n\nFor example, if our password is mariadb, then we can set the account\'s\npassword with:\n\nALTER USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD#function. It will be stored to the\nmysql.user table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n\nAnd then we can set an account\'s password with the hash:\n\nALTER USER foo2@test \n IDENTIFIED BY PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nALTER USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nALTER USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nIn MariaDB 10.4 and later, the USING or AS keyword can also be used to provide\na plain-text password to a plugin if it\'s provided as an argument to the\nPASSWORD() function. This is only valid for authentication plugins that have\nimplemented a hook for the PASSWORD() function. For example, the ed25519\nauthentication plugin supports this:\n\nALTER USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can alter a user account to require these TLS options with\nthe following:\n\nALTER USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\' AND\n ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+------------------------------------+---------------------------------------+\n| Limit Type                         | Description                           |\n+------------------------------------+---------------------------------------+\n| MAX_QUERIES_PER_HOUR               | Number of statements that the         |\n|                                    | account can issue per hour            |\n|                                    | (including updates)                   |\n+------------------------------------+---------------------------------------+\n| MAX_UPDATES_PER_HOUR               | Number of updates (not queries) that  |\n|                                    | the account can issue per hour        |\n+------------------------------------+---------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR           | Number of connections that the        |\n|                                    | account can start per hour            |\n+------------------------------------+---------------------------------------+\n| MAX_USER_CONNECTIONS               | Number of simultaneous connections    |\n|                                    | that can be accepted from the same    |\n|                                    | account; if it is 0, max_connections  |\n|                                    | will be used instead; if              |\n|                                    | max_connections is 0, there is no     |\n|                                    | limit for this account\'s              |\n|                                    | simultaneous connections.             |\n+------------------------------------+---------------------------------------+\n| MAX_STATEMENT_TIME                 | Timeout, in seconds, for statements   |\n|                                    | executed by the user. See also        |\n|                                    | Aborting Statements that Exceed a     |\n|                                    | Certain Time to Execute.              |\n+------------------------------------+---------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to set an account\'s resource limits:\n\nALTER USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nALTER USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/alter-user/','','https://mariadb.com/kb/en/alter-user/'),(107,'GRANT',10,'Syntax\n------\n\nGRANT\n  priv_type [(column_list)]\n   [, priv_type [(column_list)]] ...\n  ON [object_type] priv_level\n  TO user_specification [ user_options ...]\n\nuser_specification:\n username [authentication_option]\n | PUBLIC\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\nGRANT PROXY ON username\n  TO user_specification [, user_specification ...]\n  [WITH GRANT OPTION]\n\nGRANT rolename TO grantee [, grantee ...]\n  [WITH ADMIN OPTION]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nuser_options:\n  [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n  [WITH with_option [with_option] ...]\n\nobject_type:\n  TABLE\n | FUNCTION\n | PROCEDURE\n | PACKAGE\n\npriv_level:\n  *\n | *.*\n | db_name.*\n | db_name.tbl_name\n | tbl_name\n | db_name.routine_name\n\nwith_option:\n  GRANT OPTION\n | resource_option\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nDescription\n-----------\n\nThe GRANT statement allows you to grant privileges or roles to accounts. To\nuse GRANT, you must have the GRANT OPTION privilege, and you must have the\nprivileges that you are granting.\n\nUse the REVOKE statement to revoke privileges granted with the GRANT statement.\n\nUse the SHOW GRANTS statement to determine what privileges an account has.\n\nAccount Names\n-------------\n\nFor GRANT statements, account names are specified as the username argument in\nthe same way as they are for CREATE USER statements. See account names from\nthe CREATE USER page for details on how account names are specified.\n\nImplicit Account Creation\n-------------------------\n\nThe GRANT statement also allows you to implicitly create accounts in some\ncases.\n\nIf the account does not yet exist, then GRANT can implicitly create it. To\nimplicitly create an account with GRANT, a user is required to have the same\nprivileges that would be required to explicitly create the account with the\nCREATE USER statement.\n\nIf the NO_AUTO_CREATE_USER SQL_MODE is set, then accounts can only be created\nif authentication information is specified, or with a CREATE USER statement.\nIf no authentication information is provided, GRANT will produce an error when\nthe specified account does not exist, for example:\n\nshow variables like \'%sql_mode%\' ;\n+---------------+--------------------------------------------+\n| Variable_name | Value                                      |\n+---------------+--------------------------------------------+\n| sql_mode      | NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n+---------------+--------------------------------------------+\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' IDENTIFIED BY \'\';\nERROR 1133 (28000): Can\'t find any matching row in the user table\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' \n IDENTIFIED VIA PAM using \'mariadb\' require ssl ;\nQuery OK, 0 rows affected (0.00 sec)\n\nselect host, user from mysql.user where user=\'user123\' ;\n\n+------+----------+\n| host | user     |\n+------+----------+\n| %    | user123 |\n+------+----------+\n\nPrivilege Levels\n----------------\n\nPrivileges can be set globally, for an entire database, for a table or\nroutine, or for individual columns in a table. Certain privileges can only be\nset at certain levels.\n\n* Global privileges priv_type are granted using *.* for\npriv_level. Global privileges include privileges to administer the database\nand manage user accounts, as well as privileges for all tables, functions, and\nprocedures. Global privileges are stored in the mysql.user table prior to\nMariaDB 10.4, and in  mysql.global_priv table afterwards.\n* Database privileges priv_type are granted using db_name.*\nfor priv_level, or using just * to use default database. Database\nprivileges include privileges to create tables and functions, as well as\nprivileges for all tables, functions, and procedures in the database. Database\nprivileges are stored in the mysql.db table.\n* Table privileges priv_type are granted using db_name.tbl_name\nfor priv_level, or using just tbl_name to specify a table in the default\ndatabase. The TABLE keyword is optional. Table privileges include the\nability to select and change data in the table. Certain table privileges can\nbe granted for individual columns.\n* Column privileges priv_type are granted by specifying a table for\npriv_level and providing a column list after the privilege type. They allow\nyou to control exactly which columns in a table users can select and change.\n* Function privileges priv_type are granted using FUNCTION db_name.routine_name\nfor priv_level, or using just  FUNCTION routine_name to specify a function\nin the default database.\n* Procedure privileges priv_type are granted using PROCEDURE\ndb_name.routine_name\nfor priv_level, or using just PROCEDURE routine_name to specify a procedure\nin the default database.\n\nThe USAGE Privilege\n-------------------\n\nThe USAGE privilege grants no real privileges. The SHOW GRANTS statement will\nshow a global USAGE privilege for a newly-created user. You can use USAGE with\nthe GRANT statement to change options like GRANT OPTION and\nMAX_USER_CONNECTIONS without changing any account privileges.\n\nThe ALL PRIVILEGES Privilege\n----------------------------\n\nThe ALL PRIVILEGES privilege grants all available privileges. Granting all\nprivileges only affects the given privilege level. For example, granting all\nprivileges on a table does not grant any privileges on the database or\nglobally.\n\nUsing ALL PRIVILEGES does not grant the special GRANT OPTION privilege.\n\nYou can use ALL instead of ALL PRIVILEGES.\n\nThe GRANT OPTION Privilege\n--------------------------\n\nUse the WITH GRANT OPTION clause to give users the ability to grant privileges\nto other users at the given privilege level. Users with the GRANT OPTION\nprivilege can only grant privileges they have. They cannot grant privileges at\na higher privilege level than they have the GRANT OPTION privilege.\n\nThe GRANT OPTION privilege cannot be set for individual columns. If you use\nWITH GRANT OPTION when specifying column privileges, the GRANT OPTION\nprivilege will be granted for the entire table.\n\nUsing the WITH GRANT OPTION clause is equivalent to listing GRANT OPTION as a\nprivilege.\n\nGlobal Privileges\n-----------------\n\nThe following table lists the privileges that can be granted globally. You can\nalso grant all database, table, and function privileges globally. When granted\nglobally, these privileges apply to all databases, tables, or functions,\nincluding those created later.\n\nTo set a global privilege, use *.* for priv_level.\n\nBINLOG ADMIN\n------------\n\nEnables administration of the binary log, including the PURGE BINARY LOGS\nstatement and setting the system variables:\n\n* binlog_annotate_row_events\n* binlog_cache_size\n* binlog_commit_wait_count\n* binlog_commit_wait_usec\n* binlog_direct_non_transactional_updates\n* binlog_expire_logs_seconds\n* binlog_file_cache_size\n* binlog_format\n* binlog_row_image\n* binlog_row_metadata\n* binlog_stmt_cache_size\n* expire_logs_days\n* log_bin_compress\n* log_bin_compress_min_len\n* log_bin_trust_function_creators\n* max_binlog_cache_size\n* max_binlog_size\n* max_binlog_stmt_cache_size\n* sql_log_bin and\n* sync_binlog.\n\nAdded in MariaDB 10.5.2.\n\nBINLOG MONITOR\n--------------\n\nNew name for REPLICATION CLIENT from MariaDB 10.5.2, (REPLICATION CLIENT still\nsupported as an alias for compatibility purposes). Permits running SHOW\ncommands related to the binary log, in particular the SHOW BINLOG STATUS and\nSHOW BINARY LOGS statements. Unlike REPLICATION CLIENT prior to MariaDB 10.5,\nSHOW REPLICA STATUS isn\'t included in this privilege, and REPLICA MONITOR is\nrequired.\n\nBINLOG REPLAY\n-------------\n\nEnables replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), executing SET timestamp when secure_timestamp is set to\nreplication, and setting the session values of system variables usually\nincluded in BINLOG output, in particular:\n\n* gtid_domain_id\n* gtid_seq_no\n* pseudo_thread_id\n* server_id.\n\nAdded in MariaDB 10.5.2\n\nCONNECTION ADMIN\n----------------\n\nEnables administering connection resource limit options. This includes\nignoring the limits specified by:\n\n* max_connections\n* max_user_connections and\n* max_password_errors.\n\nThe statements specified in init_connect are not executed, killing connections\nand queries owned by other users is permitted. The following\nconnection-related system variables can be changed:\n\n* connect_timeout\n* disconnect_on_expired_password\n* extra_max_connections\n* init_connect\n* max_connections\n* max_connect_errors\n* max_password_errors\n* proxy_protocol_networks\n* secure_auth\n* slow_launch_time\n* thread_pool_exact_stats\n* thread_pool_dedicated_listener\n* thread_pool_idle_timeout\n* thread_pool_max_threads\n* thread_pool_min_threads\n* thread_pool_oversubscribe\n* thread_pool_prio_kickup_timer\n* thread_pool_priority\n* thread_pool_size, and\n* thread_pool_stall_limit.\n\nAdded in MariaDB 10.5.2.\n\nCREATE USER\n-----------\n\nCreate a user using the CREATE USER statement, or implicitly create a user\nwith the GRANT statement.\n\nFEDERATED ADMIN\n---------------\n\nExecute CREATE SERVER, ALTER SERVER, and DROP SERVER statements. Added in\nMariaDB 10.5.2.\n\nFILE\n----\n\nRead and write files on the server, using statements like LOAD DATA INFILE or\nfunctions like LOAD_FILE(). Also needed to create CONNECT outward tables.\nMariaDB server must have the permissions to access those files.\n\nGRANT OPTION\n------------\n\nGrant global privileges. You can only grant privileges that you have.\n\nPROCESS\n-------\n\nShow information about the active processes, for example via SHOW PROCESSLIST\nor mysqladmin processlist. If you have the PROCESS privilege, you can see all\nthreads. Otherwise, you can see only your own threads (that is, threads\nassociated with the MariaDB account that you are using).\n\nREAD_ONLY ADMIN\n---------------\n\nUser can set the read_only system variable and allows the user to perform\nwrite operations, even when the read_only option is active. Added in MariaDB\n10.5.2.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nRELOAD\n------\n\nExecute FLUSH statements or equivalent mariadb-admin/mysqladmin commands.\n\nREPLICATION CLIENT\n------------------\n\nExecute SHOW MASTER STATUS and SHOW BINARY LOGS informative statements.\nRenamed to BINLOG MONITOR in MariaDB 10.5.2 (but still supported as an alias\nfor compatibility reasons). SHOW SLAVE STATUS was part of REPLICATION CLIENT\nprior to MariaDB 10.5.\n\nREPLICATION MASTER ADMIN\n------------------------\n\nPermits administration of primary servers, including the SHOW REPLICA HOSTS\nstatement, and setting the gtid_binlog_state, gtid_domain_id,\nmaster_verify_checksum and server_id system variables. Added in MariaDB 10.5.2.\n\nREPLICA MONITOR\n---------------\n\nPermit SHOW REPLICA STATUS and SHOW RELAYLOG EVENTS. From MariaDB 10.5.9.\n\nWhen a user would upgrade from an older major release to a MariaDB 10.5 minor\nrelease prior to MariaDB 10.5.9, certain user accounts would lose\ncapabilities. For example, a user account that had the REPLICATION CLIENT\nprivilege in older major releases could run SHOW REPLICA STATUS, but after\nupgrading to a MariaDB 10.5 minor release prior to MariaDB 10.5.9, they could\nno longer run SHOW REPLICA STATUS, because that statement was changed to\nrequire the REPLICATION REPLICA ADMIN privilege.\n\nThis issue is fixed in MariaDB 10.5.9 with this new privilege, which now\ngrants the user the ability to execute SHOW [ALL] (SLAVE | REPLICA) STATUS.\n\nWhen a database is upgraded from an older major release to MariaDB Server\n10.5.9 or later, any user accounts with the REPLICATION CLIENT or REPLICATION\nSLAVE privileges will automatically be granted the new REPLICA MONITOR\nprivilege. The privilege fix occurs when the server is started up, not when\nmariadb-upgrade is performed.\n\nHowever, when a database is upgraded from an early 10.5 minor release to\n10.5.9 and later, the user will have to fix any user account privileges\nmanually.\n\nREPLICATION REPLICA\n-------------------\n\nSynonym for REPLICATION SLAVE. From MariaDB 10.5.1.\n\nREPLICATION SLAVE\n-----------------\n\nAccounts used by replica servers on the primary need this privilege. This is\nneeded to get the updates made on the master. From MariaDB 10.5.1, REPLICATION\nREPLICA is an alias for REPLICATION SLAVE.\n\nREPLICATION SLAVE ADMIN\n-----------------------\n\nPermits administering replica servers, including START REPLICA/SLAVE, STOP\nREPLICA/SLAVE, CHANGE MASTER, SHOW REPLICA/SLAVE STATUS, SHOW RELAYLOG EVENTS\nstatements, replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), and setting the system variables:\n\n* gtid_cleanup_batch_size\n* gtid_ignore_duplicates\n* gtid_pos_auto_engines\n* gtid_slave_pos\n* gtid_strict_mode\n* init_slave\n* read_binlog_speed_limit\n* relay_log_purge\n* relay_log_recovery\n* replicate_do_db\n* replicate_do_table\n* replicate_events_marked_for_skip\n* replicate_ignore_db\n* replicate_ignore_table\n* replicate_wild_do_table\n* replicate_wild_ignore_table\n* slave_compressed_protocol\n* slave_ddl_exec_mode\n* slave_domain_parallel_threads\n* slave_exec_mode\n* slave_max_allowed_packet\n* slave_net_timeout\n* slave_parallel_max_queued\n* slave_parallel_mode\n* slave_parallel_threads\n* slave_parallel_workers\n* slave_run_triggers_for_rbr\n* slave_sql_verify_checksum\n* slave_transaction_retry_interval\n* slave_type_conversions\n* sync_master_info\n* sync_relay_log, and\n* sync_relay_log_info.\n\nAdded in MariaDB 10.5.2.\n\nSET USER\n--------\n\nEnables setting the DEFINER when creating triggers, views, stored functions\nand stored procedures. Added in MariaDB 10.5.2.\n\nSHOW DATABASES\n--------------\n\nList all databases using the SHOW DATABASES statement. Without the SHOW\nDATABASES privilege, you can still issue the SHOW DATABASES statement, but it\nwill only list databases containing tables on which you have privileges.\n\nSHUTDOWN\n--------\n\nShut down the server using SHUTDOWN or the mysqladmin shutdown command.\n\nSUPER\n-----\n\nExecute superuser statements: CHANGE MASTER TO, KILL (users who do not have\nthis privilege can only KILL their own threads), PURGE LOGS, SET global system\nvariables, or the mysqladmin debug command. Also, this permission allows the\nuser to write data even if the read_only startup option is set, enable or\ndisable logging, enable or disable replication on replica, specify a DEFINER\nfor statements that support that clause, connect once reaching the\nMAX_CONNECTIONS. If a statement has been specified for the init-connect mysqld\noption, that command will not be executed when a user with SUPER privileges\nconnects to the server.\n\nThe SUPER privilege has been split into multiple smaller privileges from\nMariaDB 10.5.2 to allow for more fine-grained privileges, although it remains\nan alias for these smaller privileges.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nDatabase Privileges\n-------------------\n\nThe following table lists the privileges that can be granted at the database\nlevel. You can also grant all table and function privileges at the database\nlevel. Table and function privileges on a database apply to all tables or\nfunctions in that database, including those created later.\n\nTo set a privilege for a database, specify the database using db_name.* for\npriv_level, or just use * to specify the default database.\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a database using the CREATE      |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. You can      |\n|                                  | grant the CREATE privilege on           |\n|                                  | databases that do not yet exist. This   |\n|                                  | also grants the CREATE privilege on     |\n|                                  | all tables in the database.             |\n+----------------------------------+-----------------------------------------+\n| CREATE ROUTINE                   | Create Stored Programs using the        |\n|                                  | CREATE PROCEDURE and CREATE FUNCTION    |\n|                                  | statements.                             |\n+----------------------------------+-----------------------------------------+\n| CREATE TEMPORARY TABLES          | Create temporary tables with the        |\n|                                  | CREATE TEMPORARY TABLE statement. This  |\n|                                  | privilege enable writing and dropping   |\n|                                  | those temporary tables                  |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a database using the DROP          |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. This also    |\n|                                  | grants the DROP privilege on all        |\n|                                  | tables in the database.                 |\n+----------------------------------+-----------------------------------------+\n| EVENT                            | Create, drop and alter EVENTs.          |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant database privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n| LOCK TABLES                      | Acquire explicit locks using the LOCK   |\n|                                  | TABLES statement; you also need to      |\n|                                  | have the SELECT privilege on a table,   |\n|                                  | in order to lock it.                    |\n+----------------------------------+-----------------------------------------+\n\nTable Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER                            | Change the structure of an existing     |\n|                                  | table using the ALTER TABLE statement.  |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a table using the CREATE TABLE   |\n|                                  | statement.  You can grant the CREATE    |\n|                                  | privilege on tables that do not yet     |\n|                                  | exist.                                  |\n+----------------------------------+-----------------------------------------+\n| CREATE VIEW                      | Create a view using the CREATE_VIEW     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| DELETE                           | Remove rows from a table using the      |\n|                                  | DELETE statement.                       |\n+----------------------------------+-----------------------------------------+\n| DELETE HISTORY                   | Remove historical rows from a table     |\n|                                  | using the DELETE HISTORY statement.     |\n|                                  | Displays as DELETE VERSIONING ROWS      |\n|                                  | when running SHOW GRANTS until MariaDB  |\n|                                  | 10.3.15 and until MariaDB 10.4.5        |\n|                                  | (MDEV-17655), or when running SHOW      |\n|                                  | PRIVILEGES until MariaDB 10.5.2,        |\n|                                  | MariaDB 10.4.13 and MariaDB 10.3.23     |\n|                                  | (MDEV-20382). From MariaDB 10.3.4.      |\n|                                  | From MariaDB 10.3.5, if a user has the  |\n|                                  | SUPER privilege but not this            |\n|                                  | privilege, running mysql_upgrade will   |\n|                                  | grant this privilege as well.           |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a table using the DROP TABLE       |\n|                                  | statement or a view using the DROP      |\n|                                  | VIEW statement. Also required to        |\n|                                  | execute the TRUNCATE TABLE statement.   |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant table privileges. You can only    |\n|                                  | grant privileges that you have.         |\n+----------------------------------+-----------------------------------------+\n| INDEX                            | Create an index on a table using the    |\n|                                  | CREATE INDEX statement. Without the     |\n|                                  | INDEX privilege, you can still create   |\n|                                  | indexes when creating a table using     |\n|                                  | the CREATE TABLE statement if the you   |\n|                                  | have the CREATE privilege, and you can  |\n|                                  | create indexes using the ALTER TABLE    |\n|                                  | statement if you have the ALTER         |\n|                                  | privilege.                              |\n+----------------------------------+-----------------------------------------+\n| INSERT                           | Add rows to a table using the INSERT    |\n|                                  | statement.  The INSERT privilege can    |\n|                                  | also be set on individual columns; see  |\n|                                  | Column Privileges below for details.    |\n+----------------------------------+-----------------------------------------+\n| REFERENCES                       | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT                           | Read data from a table using the        |\n|                                  | SELECT statement. The SELECT privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n| SHOW VIEW                        | Show the CREATE VIEW statement to       |\n|                                  | create a view using the SHOW CREATE     |\n|                                  | VIEW statement.                         |\n+----------------------------------+-----------------------------------------+\n| TRIGGER                          | Execute triggers associated to tables   |\n|                                  | you update, execute the CREATE TRIGGER  |\n|                                  | and DROP TRIGGER statements. You will   |\n|                                  | still be able to see triggers.          |\n+----------------------------------+-----------------------------------------+\n| UPDATE                           | Update existing rows in a table using   |\n|                                  | the UPDATE statement. UPDATE            |\n|                                  | statements usually include a WHERE      |\n|                                  | clause to update only certain rows.     |\n|                                  | You must have SELECT privileges on the  |\n|                                  | table or the appropriate columns for    |\n|                                  | the WHERE clause. The UPDATE privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n\nColumn Privileges\n-----------------\n\nSome table privileges can be set for individual columns of a table. To use\ncolumn privileges, specify the table explicitly and provide a list of column\nnames after the privilege type. For example, the following statement would\nallow the user to read the names and positions of employees, but not other\ninformation from the same table, such as salaries.\n\nGRANT SELECT (name, position) on Employee to \'jeffrey\'@\'localhost\';\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| INSERT (column_list)             | Add rows specifying values in columns   |\n|                                  | using the INSERT statement. If you      |\n|                                  | only have column-level INSERT           |\n|                                  | privileges, you must specify the        |\n|                                  | columns you are setting in the INSERT   |\n|                                  | statement. All other columns will be    |\n|                                  | set to their default values, or NULL.   |\n+----------------------------------+-----------------------------------------+\n| REFERENCES (column_list)         | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT (column_list)             | Read values in columns using the        |\n|                                  | SELECT statement. You cannot access or  |\n|                                  | query any columns for which you do not  |\n|                                  | have SELECT privileges, including in    |\n|                                  | WHERE, ON, GROUP BY, and ORDER BY       |\n|                                  | clauses.                                |\n+----------------------------------+-----------------------------------------+\n| UPDATE (column_list)             | Update values in columns of existing    |\n|                                  | rows using the UPDATE statement.        |\n|                                  | UPDATE statements usually include a     |\n|                                  | WHERE clause to update only certain     |\n|                                  | rows. You must have SELECT privileges   |\n|                                  | on the table or the appropriate         |\n|                                  | columns for the WHERE clause.           |\n+----------------------------------+-----------------------------------------+\n\nFunction Privileges\n-------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | function using the ALTER FUNCTION       |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Use a stored function. You need SELECT  |\n|                                  | privileges for any tables or columns    |\n|                                  | accessed by the function.               |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant function privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nProcedure Privileges\n--------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | procedure using the ALTER PROCEDURE     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Execute a stored procedure using the    |\n|                                  | CALL statement. The privilege to call   |\n|                                  | a procedure may allow you to perform    |\n|                                  | actions you wouldn\'t otherwise be able  |\n|                                  | to do, such as insert rows into a       |\n|                                  | table.                                  |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant procedure privileges. You can     |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nGRANT EXECUTE ON PROCEDURE mysql.create_db TO maintainer;\n\nProxy Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| PROXY                            | Permits one user to be a proxy for      |\n|                                  | another.                                |\n+----------------------------------+-----------------------------------------+\n\nThe PROXY privilege allows one user to proxy as another user, which means\ntheir privileges change to that of the proxy user, and the CURRENT_USER()\nfunction returns the user name of the proxy user.\n\nThe PROXY privilege only works with authentication plugins that support it.\nThe default mysql_native_password authentication plugin does not support proxy\nusers.\n\nThe pam authentication plugin is the only plugin included with MariaDB that\ncurrently supports proxy users. The PROXY privilege is commonly used with the\npam authentication plugin to enable user and group mapping with PAM.\n\nFor example, to grant the PROXY privilege to an anonymous account that\nauthenticates with the pam authentication plugin, you could execute the\nfollowing:\n\nCREATE USER \'dba\'@\'%\' IDENTIFIED BY \'strongpassword\';\nGRANT ALL PRIVILEGES ON *.* TO \'dba\'@\'%\' ;\n\nCREATE USER \'\'@\'%\' IDENTIFIED VIA pam USING \'mariadb\';\nGRANT PROXY ON \'dba\'@\'%\' TO \'\'@\'%\';\n\nA user account can only grant the PROXY privilege for a specific user account\nif the granter also has the PROXY privilege for that specific user account,\nand if that privilege is defined WITH GRANT OPTION. For example, the following\nexample fails because the granter does not have the PROXY privilege for that\nspecific user account at all:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nAnd the following example fails because the granter does have the PROXY\nprivilege for that specific user account, but it is not defined WITH GRANT\nOPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\'                     \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nBut the following example succeeds because the granter does have the PROXY\nprivilege for that specific user account, and it is defined WITH GRANT OPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\' WITH GRANT OPTION   \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\n\nA user account can grant the PROXY privilege for any other user account if the\ngranter has the PROXY privilege for the \'\'@\'%\' anonymous user account, like\nthis:\n\nGRANT PROXY ON \'\'@\'%\' TO \'dba\'@\'localhost\' WITH GRANT OPTION;\n\nFor example, the following example succeeds because the user can grant the\nPROXY privilege for any other user account:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'\'@\'%\' TO \'alice\'@\'localhost\' WITH GRANT OPTION              \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'app1_dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nGRANT PROXY ON \'app2_dba\'@\'localhost\' TO \'carol\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nThe default root user accounts created by mysql_install_db have this\nprivilege. For example:\n\nGRANT ALL PRIVILEGES ON *.* TO \'root\'@\'localhost\' WITH GRANT OPTION;\nGRANT PROXY ON \'\'@\'%\' TO \'root\'@\'localhost\' WITH GRANT OPTION;\n\nThis allows the default root user accounts to grant the PROXY privilege for\nany other user account, and it also allows the default root user accounts to\ngrant others the privilege to do the same.\n\nAuthentication Options\n----------------------\n\nThe authentication options for the GRANT statement are the same as those for\nthe CREATE USER statement.\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \n PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\') OR unix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nTo set resource limits for an account, if you do not want to change that\naccount\'s privileges, you can issue a GRANT statement with the USAGE\nprivilege, which has no meaning. The statement can name some or all limit\ntypes, in any order.\n\nHere is an example showing how to set resource limits:\n\nGRANT USAGE ON *.* TO \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 0\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nUsers with the CONNECTION ADMIN privilege (in MariaDB 10.5.2 and later) or the\nSUPER privilege are not restricted by max_user_connections, max_connections,\nor max_password_errors.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nGRANT USAGE ON *.* TO \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nRoles\n-----\n\nSyntax\n------\n\nGRANT role TO grantee [, grantee ... ]\n[ WITH ADMIN OPTION ]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nThe GRANT statement is also used to grant the use of a role to one or more\nusers or other roles. In order to be able to grant a role, the grantor doing\nso must have permission to do so (see WITH ADMIN in the CREATE ROLE article).\n\nSpecifying the WITH ADMIN OPTION permits the grantee to in turn grant the role\nto another.\n\nFor example, the following commands show how to grant the same role to a\ncouple different users.\n\nGRANT journalist TO hulda;\n\nGRANT journalist TO berengar WITH ADMIN OPTION;\n\nIf a user has been granted a role, they do not automatically obtain all\npermissions associated with that role. These permissions are only in use when\nthe user activates the role with the SET ROLE statement.\n\nTO PUBLIC\n---------\n\nMariaDB starting with 10.11\n---------------------------\n\nSyntax\n------\n\nGRANT <privilege> ON <database>.<object> TO PUBLIC;\nREVOKE <privilege> ON <database>.<object> FROM PUBLIC;\n\nGRANT ... TO PUBLIC grants privileges to all users with access to the server.\nThe privileges also apply to users created after the privileges are granted.\nThis can be useful when one only wants to state once that all users need to\nhave a certain set of privileges.\n\nWhen running SHOW GRANTS, a user will also see all privileges inherited from\nPUBLIC. SHOW GRANTS FOR PUBLIC will only show TO PUBLIC grants.\n\nGrant Examples\n--------------\n\nGranting Root-like Privileges\n-----------------------------\n\nYou can create a user that has privileges similar to the default root accounts\nby executing the following:\n\nCREATE USER \'alexander\'@\'localhost\';\nGRANT ALL PRIVILEGES ON  *.* to \'alexander\'@\'localhost\' WITH GRANT OPTION;\n\nURL: https://mariadb.com/kb/en/grant/','','https://mariadb.com/kb/en/grant/'),(117,'Authentication from MariaDB 10.4',10,'MariaDB starting with 10.4\n--------------------------\nMariaDB 10.4 introduced a number of changes to the authentication process,\nintended to make things easier and more intuitive.\n\nOverview\n--------\n\nThere are four new main features in 10.4 relating to authentication:\n\n* It is possible to use more than one authentication plugin for each user\naccount. For example, this can be useful to slowly migrate users to the more\nsecure ed25519 authentication plugin over time, while allowing the old\nmysql_native_password authentication plugin as an alternative for the\ntransitional period.\n* The root@localhost user account created by mysql_install_db is created with\nthe ability to use two authentication plugins.\nFirst, it is configured to try to use the unix_socket authentication plugin.\nThis allows the root@localhost user to login without a password via the local\nUnix socket file defined by the socket system variable, as long as the login\nis attempted from a process owned by the operating system root user account.\nSecond, if authentication fails with the unix_socket authentication plugin,\nthen it is configured to try to use the mysql_native_password authentication\nplugin. However, an invalid password is initially set, so in order to\nauthenticate this way, a password must be set with SET PASSWORD.\nHowever, just using the unix_socket authentication plugin may be fine for many\nusers, and it is very secure. You may want to try going without password\nauthentication to see how well it works for you. Remember, the best way to\nkeep your password safe is not to have one!\n\n* All user accounts, passwords, and global privileges are now stored in the\nmysql.global_priv table. The mysql.user table still exists and has exactly the\nsame set of columns as before, but it’s now a view that references the\nmysql.global_priv table. Tools that analyze the mysql.user table should\ncontinue to work as before. From MariaDB 10.4.13, the dedicated mariadb.sys\nuser is created as the definer of this view. Previously root was the definer,\nwhich resulted in privilege problems when this username was changed.\n* MariaDB 10.4 adds supports for User Password Expiry, which is not active by\ndefault.\n\nDescription\n-----------\n\nAs a result of the above changes, the open-for-everyone all-powerful root\naccount is finally gone. And installation scripts will no longer demand that\nyou \"PLEASE REMEMBER TO SET A PASSWORD FOR THE MariaDB root USER !\", because\nthe root account is securely created automatically.\n\nTwo all-powerful accounts are created by default — root and the OS user that\nowns the data directory, typically mysql. They are created as:\n\nCREATE USER root@localhost IDENTIFIED VIA unix_socket OR mysql_native_password\nUSING \'invalid\'\nCREATE USER mysql@localhost IDENTIFIED VIA unix_socket OR\nmysql_native_password USING \'invalid\'\n\nUsing unix_socket means that if you are the system root user, you can login as\nroot@locahost without a password. This technique was pioneered by Otto\nKekäläinen in Debian MariaDB packages and has been successfully used in Debian\nsince as early as MariaDB 10.0.\n\nIt is based on a simple fact that asking the system root for a password adds\nno extra security — root has full access to all the data files and all process\nmemory anyway. But not asking for a password means, there is no root password\nto forget (no need for the numerous tutorials on \"how to reset MariaDB root\npassword\"). And if you want to script some tedious database work, there is no\nneed to store the root password in plain text for the script to use (no need\nfor debian-sys-maint user).\n\nStill, some users may wish to log in as MariaDB root without using sudo. Hence\nthe old authentication method — conventional MariaDB password — is still\navailable. By default it is disabled (\"invalid\" is not a valid password hash),\nbut one can set the password with a usual SET PASSWORD statement. And still\nretain the password-less access via sudo.\n\nIf you install MariaDB locally (say from a tarball), you would not want to use\nsudo to be able to login. This is why MariaDB creates a second all-powerful\nuser with the same name as a system user that owns the data directory. In\nlocal (not system-wide) installations, this will be the user who installed\nMariaDB — they automatically get convenient password-less root-like access,\nbecause they can access all the data files anyway.\n\nEven if MariaDB is installed system-wide, you may not want to run your\ndatabase maintenance scripts as system root — now you can run them as system\nmysql user. And you will know that they will never destroy your entire system,\neven if you make a typo in a shell script.\n\nHowever, seasoned MariaDB DBAs who are used to the old ways do need to make\nsome changes. See the examples below for common tasks.\n\nCookbook\n--------\n\nAfter installing MariaDB system-wide the first thing you’ve got used to doing\nis logging in into the unprotected root account and protecting it, that is,\nsetting the root password:\n\n$ sudo dnf install MariaDB-server\n$ mysql -uroot\n...\nMariaDB> set password = password(\"XH4VmT3_jt\");\n\nThis is not only unnecessary now, it will simply not work — there is no\nunprotected root account. To login as root use\n\n$ sudo dnf install MariaDB-server\n$ sudo mysql\n\nNote that it implies you are connecting via the unix socket, not tcp. If you\nhappen to have protocol=tcp in a system-wide /etc/my.cnf file, use sudo mysql\n--protocol=socket.\n\nAfter installing MariaDB locally you’ve also used to connect to the\nunprotected root account using mysql -uroot. This will not work either, simply\nuse mysql without specifying a username.\n\nIf you\'ve forgotten your root password, no problem — you can still connect\nusing sudo and change the password. And if you\'ve also removed unix_socket\nauthentication, to restore access do as follows:\n\n* restart MariaDB with --skip-grant-tables\n* login into the unprotected server\n* run FLUSH PRIVILEGES (note, before 10.4 this would’ve been the last step,\nnot anymore). This disables --skip-grant-tables and allows you to change the\nstored authentication method\n* run SET PASSWORD FOR root@localhost to change the root password.\n\nTo view inside privilege tables, the old mysql.user table still exists. You\ncan select from it as before, although you cannot update it anymore. It\ndoesn’t show alternative authentication plugins and this was one of the\nreasons for switching to the mysql.global_priv table — complex authentication\nrules did not fit into rigid structure of a relational table. You can select\nfrom the new table, for example:\n\nselect concat(user, \'@\', host, \' => \', json_detailed(priv)) from\nmysql.global_priv;\n\nReverting to the Previous Authentication Method for root@localhost\n------------------------------------------------------------------\n\nIf you don\'t want the root@localhost user account created by mysql_install_db\nto use unix_socket authentication by default, then there are a few ways to\nrevert to the previous mysql_native_password authentication method for this\nuser account.\n\nConfiguring mysql_install_db to Revert to the Previous Authentication Method\n----------------------------------------------------------------------------\n\nOne way to revert to the previous mysql_native_password authentication method\nfor the root@localhost user account is to execute mysql_install_db with a\nspecial option. If mysql_install_db is executed while\n--auth-root-authentication-method=normal is specified, then it will create the\ndefault user accounts using the default behavior of MariaDB 10.3 and before.\n\nThis means that the root@localhost user account will use mysql_native_password\nauthentication by default. There are some other differences as well. See\nmysql_install_db: User Accounts Created by Default for more information.\n\nFor example, the option can be set on the command-line while running\nmysql_install_db:\n\nmysql_install_db --user=mysql --datadir=/var/lib/mysql\n--auth-root-authentication-method=normal\n\nThe option can also be set in an option file in an option group supported by\nmysql_install_db. For example:\n\n[mysql_install_db]\nauth_root_authentication_method=normal\n\nIf the option is set in an option file and if mysql_install_db is executed,\nthen mysql_install_db will read this option from the option file, and it will\nautomatically set this option.\n\nAltering the User Account to Revert to the Previous Authentication Method\n-------------------------------------------------------------------------\n\nIf you have already installed MariaDB, and if the root@localhost user account\nis already using unix_socket authentication, then you can revert to the old\nmysql_native_password authentication method for the user account by executing\nthe following:\n\nALTER USER root@localhost IDENTIFIED VIA mysql_native_password USING\nPASSWORD(\"verysecret\")\n\nURL: https://mariadb.com/kb/en/authentication-from-mariadb-104/','','https://mariadb.com/kb/en/authentication-from-mariadb-104/'),(119,'ST_X',11,'Syntax\n------\n\nST_X(p)\nX(p)\n\nDescription\n-----------\n\nReturns the X-coordinate value for the point p as a double-precision number.\n\nST_X() and X() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT X(GeomFromText(@pt));\n+----------------------+\n| X(GeomFromText(@pt)) |\n+----------------------+\n|                 56.7 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_x/','','https://mariadb.com/kb/en/st_x/'),(88,'IF Function',7,'Syntax\n------\n\nIF(expr1,expr2,expr3)\n\nDescription\n-----------\n\nIf expr1 is TRUE (expr1 <> 0 and expr1 <> NULL) then IF() returns expr2;\notherwise it returns expr3. IF() returns a numeric or string value, depending\non the context in which it is used.\n\nNote: There is also an IF statement which differs from the IF() function\ndescribed here.\n\nExamples\n--------\n\nSELECT IF(1>2,2,3);\n+-------------+\n| IF(1>2,2,3) |\n+-------------+\n|           3 |\n+-------------+\n\nSELECT IF(1<2,\'yes\',\'no\');\n+--------------------+\n| IF(1<2,\'yes\',\'no\') |\n+--------------------+\n| yes                |\n+--------------------+\n\nSELECT IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\');\n+---------------------------------------+\n| IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\') |\n+---------------------------------------+\n| no                                    |\n+---------------------------------------+\n\nURL: https://mariadb.com/kb/en/if-function/','','https://mariadb.com/kb/en/if-function/'),(89,'IFNULL',7,'Syntax\n------\n\nIFNULL(expr1,expr2)\nNVL(expr1,expr2)\n\nDescription\n-----------\n\nIf expr1 is not NULL, IFNULL() returns expr1; otherwise it returns expr2.\nIFNULL() returns a numeric or string value, depending on the context in which\nit is used.\n\nFrom MariaDB 10.3, NVL() is an alias for IFNULL().\n\nExamples\n--------\n\nSELECT IFNULL(1,0); \n+-------------+\n| IFNULL(1,0) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT IFNULL(NULL,10);\n+-----------------+\n| IFNULL(NULL,10) |\n+-----------------+\n|              10 |\n+-----------------+\n\nSELECT IFNULL(1/0,10);\n+----------------+\n| IFNULL(1/0,10) |\n+----------------+\n|        10.0000 |\n+----------------+\n\nSELECT IFNULL(1/0,\'yes\');\n+-------------------+\n| IFNULL(1/0,\'yes\') |\n+-------------------+\n| yes               |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/ifnull/','','https://mariadb.com/kb/en/ifnull/'),(94,'START TRANSACTION',8,'Syntax\n------\n\nSTART TRANSACTION [transaction_property [, transaction_property] ...] | BEGIN\n[WORK]\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nROLLBACK [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nSET autocommit = {0 | 1}\n\ntransaction_property:\n  WITH CONSISTENT SNAPSHOT\n | READ WRITE\n | READ ONLY\n\nDescription\n-----------\n\nThe START TRANSACTION or BEGIN statement begins a new transaction. COMMIT\ncommits the current transaction, making its changes permanent. ROLLBACK rolls\nback the current transaction, canceling its changes. The SET autocommit\nstatement disables or enables the default autocommit mode for the current\nsession.\n\nSTART TRANSACTION and SET autocommit = 1 implicitly commit the current\ntransaction, if any.\n\nThe optional WORK keyword is supported for COMMIT and ROLLBACK, as are the\nCHAIN and RELEASE clauses. CHAIN and RELEASE can be used for additional\ncontrol over transaction completion. The value of the completion_type system\nvariable determines the default completion behavior.\n\nThe AND CHAIN clause causes a new transaction to begin as soon as the current\none ends, and the new transaction has the same isolation level as the\njust-terminated transaction. The RELEASE clause causes the server to\ndisconnect the current client session after terminating the current\ntransaction. Including the NO keyword suppresses CHAIN or RELEASE completion,\nwhich can be useful if the completion_type system variable is set to cause\nchaining or release completion by default.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can perform DDL\nstatements on temporary tables.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the SET TRANSACTION\nstatement, in which case the specified mode is valid for all sessions, or for\nall subsequent transaction used by the current session.\n\nautocommit\n----------\n\nBy default, MariaDB runs with autocommit mode enabled. This means that as soon\nas you execute a statement that updates (modifies) a table, MariaDB stores the\nupdate on disk to make it permanent. To disable autocommit mode, use the\nfollowing statement:\n\nSET autocommit=0;\n\nAfter disabling autocommit mode by setting the autocommit variable to zero,\nchanges to transaction-safe tables (such as those for InnoDB or NDBCLUSTER)\nare not made permanent immediately. You must use COMMIT to store your changes\nto disk or ROLLBACK to ignore the changes.\n\nTo disable autocommit mode for a single series of statements, use the START\nTRANSACTION statement.\n\nDDL Statements\n--------------\n\nDDL statements (CREATE, ALTER, DROP) and administrative statements (FLUSH,\nRESET, OPTIMIZE, ANALYZE, CHECK, REPAIR, CACHE INDEX), transaction management\nstatements (BEGIN, START TRANSACTION) and LOAD DATA INFILE, cause an implicit\nCOMMIT and start a new transaction. An exception to this rule are the DDL that\noperate on temporary tables: you can CREATE, ALTER and DROP them without\ncausing any COMMIT, but those actions cannot be rolled back. This means that\nif you call ROLLBACK, the temporary tables you created in the transaction will\nremain, while the rest of the transaction will be rolled back.\n\nTransactions cannot be used in Stored Functions or Triggers. In Stored\nProcedures and Events BEGIN is not allowed, so you should use START\nTRANSACTION instead.\n\nA transaction acquires a metadata lock on every table it accesses to prevent\nother connections from altering their structure. The lock is released at the\nend of the transaction. This happens even with non-transactional storage\nengines (like MEMORY or CONNECT), so it makes sense to use transactions with\nnon-transactional tables.\n\nin_transaction\n--------------\n\nThe in_transaction system variable is a session-only, read-only variable that\nreturns 1 inside a transaction, and 0 if not in a transaction.\n\nWITH CONSISTENT SNAPSHOT\n------------------------\n\nThe WITH CONSISTENT SNAPSHOT option starts a consistent read for storage\nengines such as InnoDB that can do so, the same as if a START TRANSACTION\nfollowed by a SELECT from any InnoDB table was issued.\n\nSee Enhancements for START TRANSACTION WITH CONSISTENT SNAPSHOT.\n\nExamples\n--------\n\nSTART TRANSACTION;\nSELECT @A:=SUM(salary) FROM table1 WHERE type=1;\nUPDATE table2 SET summary=@A WHERE type=1;\nCOMMIT;\n\nURL: https://mariadb.com/kb/en/start-transaction/','','https://mariadb.com/kb/en/start-transaction/'),(120,'ST_Y',11,'Syntax\n------\n\nST_Y(p)\nY(p)\n\nDescription\n-----------\n\nReturns the Y-coordinate value for the point p as a double-precision number.\n\nST_Y() and Y() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT Y(GeomFromText(@pt));\n+----------------------+\n| Y(GeomFromText(@pt)) |\n+----------------------+\n|                53.34 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_y/','','https://mariadb.com/kb/en/st_y/'),(121,'X',11,'A synonym for ST_X.\n\nURL: https://mariadb.com/kb/en/point-properties-x/','','https://mariadb.com/kb/en/point-properties-x/'),(122,'Y',11,'A synonym for ST_Y.\n\nURL: https://mariadb.com/kb/en/point-properties-y/','','https://mariadb.com/kb/en/point-properties-y/'),(125,'DECODE_ORACLE',12,'MariaDB starting with 10.3.2\n----------------------------\nDECODE_ORACLE is a synonym for the Oracle mode version of the DECODE function,\nand is available in all modes.\n\nURL: https://mariadb.com/kb/en/decode_oracle/','','https://mariadb.com/kb/en/decode_oracle/'),(93,'SET TRANSACTION',8,'Syntax\n------\n\nSET [GLOBAL | SESSION] TRANSACTION\n  transaction_property [, transaction_property] ...\n\ntransaction_property:\n  ISOLATION LEVEL level\n | READ WRITE\n | READ ONLY\n\nlevel:\n  REPEATABLE READ\n | READ COMMITTED\n | READ UNCOMMITTED\n | SERIALIZABLE\n\nDescription\n-----------\n\nThis statement sets the transaction isolation level or the transaction access\nmode globally, for the current session, or for the next transaction:\n\n* With the GLOBAL keyword, the statement sets the default\n transaction level globally for all subsequent sessions. Existing sessions are\n unaffected.\n* With the SESSION keyword, the statement sets the default\n transaction level for all subsequent transactions performed within the\n current session.\n* Without any SESSION or GLOBAL keyword,\n the statement sets the isolation level for the next (not started) transaction\n performed within the current session.\n\nA change to the global default isolation level requires the SUPER privilege.\nAny session is free to change its session isolation level (even in the middle\nof a transaction), or the isolation level for its next transaction.\n\nIsolation Level\n---------------\n\nTo set the global default isolation level at server startup, use the\n--transaction-isolation=level option on the command line or in an option file.\nValues of level for this option use dashes rather than spaces, so the\nallowable values are READ-UNCOMMITTED, READ-COMMITTED, REPEATABLE-READ, or\nSERIALIZABLE. For example, to set the default isolation level to REPEATABLE\nREAD, use these lines in the [mysqld] section of an option file:\n\n[mysqld]\ntransaction-isolation = REPEATABLE-READ\nTo determine the global and session transaction isolation levels at runtime,\ncheck the value of the tx_isolation system variable:\n\nSELECT @@GLOBAL.tx_isolation, @@tx_isolation;\n\nInnoDB supports each of the translation isolation levels described here using\ndifferent locking strategies. The default level is REPEATABLE READ. For\nadditional information about InnoDB record-level locks and how it uses them to\nexecute various types of statements, see InnoDB Lock Modes, and\nhttp://dev.mysql.com/doc/refman/en/innodb-locks-set.html.\n\nIsolation Levels\n----------------\n\nThe following sections describe how MariaDB supports the different transaction\nlevels.\n\nREAD UNCOMMITTED\n----------------\n\nSELECT statements are performed in a non-locking fashion, but a possible\nearlier version of a row might be used. Thus, using this isolation level, such\nreads are not consistent. This is also called a \"dirty read.\" Otherwise, this\nisolation level works like READ COMMITTED.\n\nREAD COMMITTED\n--------------\n\nA somewhat Oracle-like isolation level with respect to consistent\n(non-locking) reads: Each consistent read, even within the same transaction,\nsets and reads its own fresh snapshot. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), InnoDB locks\nonly index records, not the gaps before them, and thus allows the free\ninsertion of new records next to locked records. For UPDATE and DELETE\nstatements, locking depends on whether the statement uses a unique index with\na unique search condition (such as WHERE id = 100), or a range-type search\ncondition (such as WHERE id > 100). For a unique index with a unique search\ncondition, InnoDB locks only the index record found, not the gap before it.\nFor range-type searches, InnoDB locks the index range scanned, using gap locks\nor next-key (gap plus index-record) locks to block insertions by other\nsessions into the gaps covered by the range. This is necessary because\n\"phantom rows\" must be blocked for MySQL replication and recovery to work.\n\nNote: If the READ COMMITTED isolation level is used or the\ninnodb_locks_unsafe_for_binlog system variable is enabled, there is no InnoDB\ngap locking except for foreign-key constraint checking and duplicate-key\nchecking. Also, record locks for non-matching rows are released after MariaDB\nhas evaluated the WHERE condition.If you use READ COMMITTED or enable\ninnodb_locks_unsafe_for_binlog, you must use row-based binary logging.\n\nREPEATABLE READ\n---------------\n\nThis is the default isolation level for InnoDB. For consistent reads, there is\nan important difference from the READ COMMITTED isolation level: All\nconsistent reads within the same transaction read the snapshot established by\nthe first read. This convention means that if you issue several plain\n(non-locking) SELECT statements within the same transaction, these SELECT\nstatements are consistent also with respect to each other. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), UPDATE, and\nDELETE statements, locking depends on whether the statement uses a unique\nindex with a unique search condition, or a range-type search condition. For a\nunique index with a unique search condition, InnoDB locks only the index\nrecord found, not the gap before it. For other search conditions, InnoDB locks\nthe index range scanned, using gap locks or next-key (gap plus index-record)\nlocks to block insertions by other sessions into the gaps covered by the range.\n\nThis is the minimum isolation level for non-distributed XA transactions.\n\nSERIALIZABLE\n------------\n\nThis level is like REPEATABLE READ, but InnoDB implicitly converts all plain\nSELECT statements to SELECT ... LOCK IN SHARE MODE if autocommit is disabled.\nIf autocommit is enabled, the SELECT is its own transaction. It therefore is\nknown to be read only and can be serialized if performed as a consistent\n(non-locking) read and need not block for other transactions. (This means that\nto force a plain SELECT to block if other transactions have modified the\nselected rows, you should disable autocommit.)\n\nDistributed XA transactions should always use this isolation level.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can perform DDL\nstatements on temporary tables.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the START TRANSACTION\nstatement, in which case the specified mode is only valid for one transaction.\n\nExamples\n--------\n\nSET GLOBAL TRANSACTION ISOLATION LEVEL SERIALIZABLE;\n\nAttempting to set the isolation level within an existing transaction without\nspecifying GLOBAL or SESSION.\n\nSTART TRANSACTION;\n\nSET TRANSACTION ISOLATION LEVEL SERIALIZABLE;\nERROR 1568 (25001): Transaction characteristics can\'t be changed while a\ntransaction is in progress\n\nURL: https://mariadb.com/kb/en/set-transaction/','','https://mariadb.com/kb/en/set-transaction/'),(126,'AES_DECRYPT',12,'Syntax\n------\n\nAES_DECRYPT(crypt_str,key_str)\n\nDescription\n-----------\n\nThis function allows decryption of data using the official AES (Advanced\nEncryption Standard) algorithm. For more information, see the description of\nAES_ENCRYPT().\n\nURL: https://mariadb.com/kb/en/aes_decrypt/','','https://mariadb.com/kb/en/aes_decrypt/'),(133,'MD5',12,'Syntax\n------\n\nMD5(str)\n\nDescription\n-----------\n\nCalculates an MD5 128-bit checksum for the string.\n\nThe return value is a 32-hex digit string, and as of MariaDB 5.5, is a\nnonbinary string in the connection character set and collation, determined by\nthe values of the character_set_connection and collation_connection system\nvariables. Before 5.5, the return value was a binary string.\n\nNULL is returned if the argument was NULL.\n\nExamples\n--------\n\nSELECT MD5(\'testing\');\n+----------------------------------+\n| MD5(\'testing\')                   |\n+----------------------------------+\n| ae2b1fca515949e5d54fb22b8ed95575 |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/md5/','','https://mariadb.com/kb/en/md5/'),(95,'COMMIT',8,'The COMMIT statement ends a transaction, saving any changes to the data so\nthat they become visible to subsequent transactions. Also, unlocks metadata\nchanged by current transaction. If autocommit is set to 1, an implicit commit\nis performed after each statement. Otherwise, all transactions which don\'t end\nwith an explicit COMMIT are implicitly rollbacked and the changes are lost.\nThe ROLLBACK statement can be used to do this explicitly.\n\nThe required syntax for the COMMIT statement is as follows:\n\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\n\nCOMMIT is the more important transaction terminator, as well as the more\ninteresting one. The basic form of the COMMIT statement is simply the keyword\nCOMMIT (the keyword WORK is simply noise and can be omitted without changing\nthe effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated.\n\nRELEASE tells the server to disconnect the client immediately after the\ncurrent transaction.\n\nThere are NO RELEASE and AND NO CHAIN options. By default, commits do not\nRELEASE or CHAIN, but it\'s possible to change this default behavior with the\ncompletion_type server system variable. In this case, the AND NO CHAIN and NO\nRELEASE options override the server default.\n\nURL: https://mariadb.com/kb/en/commit/','','https://mariadb.com/kb/en/commit/'),(96,'ROLLBACK',8,'The ROLLBACK statement rolls back (ends) a transaction, destroying any changes\nto SQL-data so that they never become visible to subsequent transactions. The\nrequired syntax for the ROLLBACK statement is as follows.\n\nROLLBACK [ WORK ] [ AND [ NO ] CHAIN ] \n[ TO [ SAVEPOINT ] {<savepoint name> | <simple target specification>} ]\n\nThe ROLLBACK statement will either end a transaction, destroying all data\nchanges that happened during any of the transaction, or it will just destroy\nany data changes that happened since you established a savepoint. The basic\nform of the ROLLBACK statement is just the keyword ROLLBACK (the keyword WORK\nis simply noise and can be omitted without changing the effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated. The AND NO CHAIN option just tells your DBMS to end the\ntransaction — that is, these four SQL statements are equivalent:\n\nROLLBACK; \nROLLBACK WORK; \nROLLBACK AND NO CHAIN; \nROLLBACK WORK AND NO CHAIN;\n\nAll of them end a transaction without saving any transaction characteristics.\nThe only other options, the equivalent statements:\n\nROLLBACK AND CHAIN;\nROLLBACK WORK AND CHAIN;\n\nboth tell your DBMS to end a transaction, but to save that transaction\'s\ncharacteristics for the next transaction.\n\nROLLBACK is much simpler than COMMIT: it may involve no more than a few\ndeletions (of Cursors, locks, prepared SQL statements and log-file entries).\nIt\'s usually assumed that ROLLBACK can\'t fail, although such a thing is\nconceivable (for example, an encompassing transaction might reject an attempt\nto ROLLBACK because it\'s lining up for a COMMIT).\n\nROLLBACK cancels all effects of a transaction. It does not cancel effects on\nobjects outside the DBMS\'s control (for example the values in host program\nvariables or the settings made by some SQL/CLI function calls). But in\ngeneral, it is a convenient statement for those situations when you say \"oops,\nthis isn\'t working\" or when you simply don\'t care whether your temporary work\nbecomes permanent or not.\n\nHere is a moot question. If all you\'ve been doing is SELECTs, so that there\nhave been no data changes, should you end the transaction with ROLLBACK or\nCOMMIT? It shouldn\'t really matter because both ROLLBACK and COMMIT do the\nsame transaction-terminating job. However, the popular conception is that\nROLLBACK implies failure, so after a successful series of SELECT statements\nthe convention is to end the transaction with COMMIT rather than ROLLBACK.\n\nMariaDB (and most other DBMSs) supports rollback of SQL-data change\nstatements, but not of SQL-Schema statements. This means that if you use any\nof CREATE, ALTER, DROP, GRANT, REVOKE, you are implicitly committing at\nexecution time.\n\nINSERT INTO Table_2 VALUES(5); \nDROP TABLE Table_3 CASCADE; \nROLLBACK;\n\nThe result will be that both the INSERT and the DROP will go through as\nseparate transactions so the ROLLBACK will have no effect.\n\nURL: https://mariadb.com/kb/en/rollback/','','https://mariadb.com/kb/en/rollback/'),(138,'ENDPOINT',13,'A synonym for ST_ENDPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-endpoint/','','https://mariadb.com/kb/en/linestring-properties-endpoint/'),(139,'GLENGTH',13,'Syntax\n------\n\nGLength(ls)\n\nDescription\n-----------\n\nReturns as a double-precision number the length of the LineString value ls in\nits associated spatial reference.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT GLength(GeomFromText(@ls));\n+----------------------------+\n| GLength(GeomFromText(@ls)) |\n+----------------------------+\n|           2.82842712474619 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/glength/','','https://mariadb.com/kb/en/glength/'),(140,'NumPoints',13,'A synonym for ST_NumPoints.\n\nURL: https://mariadb.com/kb/en/linestring-properties-numpoints/','','https://mariadb.com/kb/en/linestring-properties-numpoints/'),(141,'PointN',13,'A synonym for ST_PointN.\n\nURL: https://mariadb.com/kb/en/linestring-properties-pointn/','','https://mariadb.com/kb/en/linestring-properties-pointn/'),(142,'STARTPOINT',13,'A synonym for ST_STARTPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-startpoint/','','https://mariadb.com/kb/en/linestring-properties-startpoint/'),(143,'ST_ENDPOINT',13,'Syntax\n------\n\nST_EndPoint(ls)\nEndPoint(ls)\n\nDescription\n-----------\n\nReturns the Point that is the endpoint of the LineString value ls.\n\nST_EndPoint() and EndPoint() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(EndPoint(GeomFromText(@ls)));\n+-------------------------------------+\n| AsText(EndPoint(GeomFromText(@ls))) |\n+-------------------------------------+\n| POINT(3 3)                          |\n+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_endpoint/','','https://mariadb.com/kb/en/st_endpoint/'),(144,'ST_NUMPOINTS',13,'Syntax\n------\n\nST_NumPoints(ls)\nNumPoints(ls)\n\nDescription\n-----------\n\nReturns the number of Point objects in the LineString value ls.\n\nST_NumPoints() and NumPoints() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT NumPoints(GeomFromText(@ls));\n+------------------------------+\n| NumPoints(GeomFromText(@ls)) |\n+------------------------------+\n|                            3 |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/st_numpoints/','','https://mariadb.com/kb/en/st_numpoints/'),(97,'LOCK TABLES',8,'Syntax\n------\n\nLOCK TABLE[S]\n  tbl_name [[AS] alias] lock_type\n  [, tbl_name [[AS] alias] lock_type] ...\n  [WAIT n|NOWAIT]\n\nlock_type:\n  READ [LOCAL]\n | [LOW_PRIORITY] WRITE\n | WRITE CONCURRENT\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nThe lock_type can be one of:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| READ                      | Read lock, no writes allowed                   |\n+---------------------------+------------------------------------------------+\n| READ LOCAL                | Read lock, but allow concurrent inserts        |\n+---------------------------+------------------------------------------------+\n| WRITE                     | Exclusive write lock. No other connections     |\n|                           | can read or write to this table                |\n+---------------------------+------------------------------------------------+\n| LOW_PRIORITY WRITE        | Exclusive write lock, but allow new read       |\n|                           | locks on the table until we get the write      |\n|                           | lock.                                          |\n+---------------------------+------------------------------------------------+\n| WRITE CONCURRENT          | Exclusive write lock, but allow READ LOCAL     |\n|                           | locks to the table.                            |\n+---------------------------+------------------------------------------------+\n\nMariaDB enables client sessions to acquire table locks explicitly for the\npurpose of cooperating with other sessions for access to tables, or to prevent\nother sessions from modifying tables during periods when a session requires\nexclusive access to them. A session can acquire or release locks only for\nitself. One session cannot acquire locks for another session or release locks\nheld by another session.\n\nLocks may be used to emulate transactions or to get more speed when updating\ntables.\n\nLOCK TABLES explicitly acquires table locks for the current client session.\nTable locks can be acquired for base tables or views. To use LOCK TABLES, you\nmust have the LOCK TABLES privilege, and the SELECT privilege for each object\nto be locked. See GRANT\n\nFor view locking, LOCK TABLES adds all base tables used in the view to the set\nof tables to be locked and locks them automatically. If you lock a table\nexplicitly with LOCK TABLES, any tables used in triggers are also locked\nimplicitly, as described in Triggers and Implicit Locks.\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\n\nMariaDB starting with 10.3.0\n----------------------------\n\nWAIT/NOWAIT\n-----------\n\nSet the lock wait timeout. See WAIT and NOWAIT.\n\nLimitations\n-----------\n\n* LOCK TABLES doesn\'t work when using Galera cluster.   You may experience\ncrashes or locks when used with Galera.\n* LOCK TABLES works on XtraDB/InnoDB tables only if the innodb_table_locks\nsystem variable is set to 1 (the default) and autocommit is set to 0 (1 is\ndefault). Please note that no error message will be returned on LOCK TABLES\nwith innodb_table_locks = 0.\n* LOCK TABLES implicitly commits the active transaction, if any. Also,\nstarting a transaction always releases all table locks acquired with LOCK\nTABLES. This means that there is no way to have table locks and an active\ntransaction at the same time. The only exceptions are the transactions in\nautocommit mode. To preserve the data integrity between transactional and\nnon-transactional tables, the GET_LOCK() function can be used.\n* When using LOCK TABLES on a TEMPORARY table, it will always be locked with a\nWRITE lock.\n* While a connection holds an explicit read lock on a table, it cannot modify\nit. If you try, the following error will be produced:\n\nERROR 1099 (HY000): Table \'tab_name\' was locked with a READ lock and can\'t be\nupdated\n\n* While a connection holds an explicit lock on a table, it cannot access a\nnon-locked table. If you try, the following error will be produced:\n\nERROR 1100 (HY000): Table \'tab_name\' was not locked with LOCK TABLES\n\n* While a connection holds an explicit lock on a table, it cannot issue the\nfollowing: INSERT DELAYED, CREATE TABLE, CREATE TABLE ... LIKE, and DDL\nstatements involving stored programs and views (except for triggers). If you\ntry, the following error will be produced:\n\nERROR 1192 (HY000): Can\'t execute the given command because you have active\nlocked tables or an active transaction\n\n* LOCK TABLES can not be used in stored routines - if you try, the following\nerror will be produced on creation. This restriction was removed in MariaDB\n10.6.2:\n\nERROR 1314 (0A000): LOCK is not allowed in stored procedures\n\nURL: https://mariadb.com/kb/en/lock-tables/','','https://mariadb.com/kb/en/lock-tables/'),(145,'ST_POINTN',13,'Syntax\n------\n\nST_PointN(ls,N)\nPointN(ls,N)\n\nDescription\n-----------\n\nReturns the N-th Point in the LineString value ls. Points are numbered\nbeginning with 1.\n\nST_PointN() and PointN() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(PointN(GeomFromText(@ls),2));\n+-------------------------------------+\n| AsText(PointN(GeomFromText(@ls),2)) |\n+-------------------------------------+\n| POINT(2 2)                          |\n+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_pointn/','','https://mariadb.com/kb/en/st_pointn/'),(146,'ST_STARTPOINT',13,'Syntax\n------\n\nST_StartPoint(ls)\nStartPoint(ls)\n\nDescription\n-----------\n\nReturns the Point that is the start point of the LineString value ls.\n\nST_StartPoint() and StartPoint() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(StartPoint(GeomFromText(@ls)));\n+---------------------------------------+\n| AsText(StartPoint(GeomFromText(@ls))) |\n+---------------------------------------+\n| POINT(1 1)                            |\n+---------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_startpoint/','','https://mariadb.com/kb/en/st_startpoint/'),(150,'INET_ATON',14,'Syntax\n------\n\nINET_ATON(expr)\n\nDescription\n-----------\n\nGiven the dotted-quad representation of an IPv4 network address as a string,\nreturns an integer that represents the numeric value of the address. Addresses\nmay be 4- or 8-byte addresses.\n\nReturns NULL if the argument is not understood.\n\nExamples\n--------\n\nSELECT INET_ATON(\'192.168.1.1\');\n+--------------------------+\n| INET_ATON(\'192.168.1.1\') |\n+--------------------------+\n|               3232235777 |\n+--------------------------+\n\nThis is calculated as follows: 192 x 2563 + 168 x 256 2 + 1 x 256 + 1\n\nURL: https://mariadb.com/kb/en/inet_aton/','','https://mariadb.com/kb/en/inet_aton/'),(151,'INET_NTOA',14,'Syntax\n------\n\nINET_NTOA(expr)\n\nDescription\n-----------\n\nGiven a numeric IPv4 network address in network byte order (4 or 8 byte),\nreturns the dotted-quad representation of the address as a string.\n\nExamples\n--------\n\nSELECT INET_NTOA(3232235777);\n+-----------------------+\n| INET_NTOA(3232235777) |\n+-----------------------+\n| 192.168.1.1           |\n+-----------------------+\n\n192.168.1.1 corresponds to 3232235777 since 192 x 2563 + 168 x 256 2 + 1 x 256\n+ 1 = 3232235777\n\nURL: https://mariadb.com/kb/en/inet_ntoa/','','https://mariadb.com/kb/en/inet_ntoa/'),(98,'SAVEPOINT',8,'Syntax\n------\n\nSAVEPOINT identifier\nROLLBACK [WORK] TO [SAVEPOINT] identifier\nRELEASE SAVEPOINT identifier\n\nDescription\n-----------\n\nInnoDB supports the SQL statements SAVEPOINT, ROLLBACK TO SAVEPOINT, RELEASE\nSAVEPOINT and the optional WORK keyword for ROLLBACK.\n\nEach savepoint must have a legal MariaDB identifier. A savepoint is a named\nsub-transaction.\n\nNormally ROLLBACK undoes the changes performed by the whole transaction. When\nused with the TO clause, it undoes the changes performed after the specified\nsavepoint, and erases all subsequent savepoints. However, all locks that have\nbeen acquired after the save point will survive. RELEASE SAVEPOINT does not\nrollback or commit any changes, but removes the specified savepoint.\n\nWhen the execution of a trigger or a stored function begins, it is not\npossible to use statements which reference a savepoint which was defined from\nout of that stored program.\n\nWhen a COMMIT (including implicit commits) or a ROLLBACK statement (with no TO\nclause) is performed, they act on the whole transaction, and all savepoints\nare removed.\n\nErrors\n------\n\nIf COMMIT or ROLLBACK is issued and no transaction was started, no error is\nreported.\n\nIf SAVEPOINT is issued and no transaction was started, no error is reported\nbut no savepoint is created. When ROLLBACK TO SAVEPOINT or RELEASE SAVEPOINT\nis called for a savepoint that does not exist, an error like this is issued:\n\nERROR 1305 (42000): SAVEPOINT svp_name does not exist\n\nURL: https://mariadb.com/kb/en/savepoint/','','https://mariadb.com/kb/en/savepoint/'),(99,'Metadata Locking',8,'MariaDB supports metadata locking. This means that when a transaction\n(including XA transactions) uses a table, it locks its metadata until the end\nof transaction. Non-transactional tables are also locked, as well as views and\nobjects which are related to locked tables/views (stored functions, triggers,\netc). When a connection tries to use a DDL statement (like an ALTER TABLE)\nwhich modifies a table that is locked, that connection is queued, and has to\nwait until it\'s unlocked. Using savepoints and performing a partial rollback\ndoes not release metadata locks.\n\nLOCK TABLES ... WRITE are also queued. Some wrong statements which produce an\nerror may not need to wait for the lock to be freed.\n\nThe metadata lock\'s timeout is determined by the value of the\nlock_wait_timeout server system variable (in seconds). However, note that its\ndefault value is 31536000 (1 year, MariaDB <= 10.2.3), or 86400 (1 day,\nMariaDB >= 10.2.4). If this timeout is exceeded, the following error is\nreturned:\n\nERROR 1205 (HY000): Lock wait timeout exceeded; try restarting transaction\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table stores information about existing metadata locks.\n\nMariaDB starting with 10.5.2\n----------------------------\nFrom MariaDB 10.5, the Performance Schema metadata_locks table contains\nmetadata lock information.\n\nExample\n-------\n\nLet\'s use the following MEMORY (non-transactional) table:\n\nCREATE TABLE t (a INT) ENGINE = MEMORY;\n\nConnection 1 starts a transaction, and INSERTs a row into t:\n\nSTART TRANSACTION;\n\nINSERT INTO t SET a=1;\n\nt\'s metadata is now locked by connection 1. Connection 2 tries to alter t, but\nhas to wait:\n\nALTER TABLE t ADD COLUMN b INT;\n\nConnection 2\'s prompt is blocked now.\n\nNow connection 1 ends the transaction:\n\nCOMMIT;\n\n...and connection 2 finally gets the output of its command:\n\nQuery OK, 1 row affected (35.23 sec)\nRecords: 1  Duplicates: 0  Warnings: 0\n\nURL: https://mariadb.com/kb/en/metadata-locking/','','https://mariadb.com/kb/en/metadata-locking/'),(100,'Transaction Timeouts',8,'MariaDB has always had the wait_timeout and interactive_timeout settings,\nwhich close connections after a certain period of inactivity.\n\nHowever, these are by default set to a long wait period. In situations where\ntransactions may be started, but not committed or rolled back, more granular\ncontrol and a shorter timeout may be desirable so as to avoid locks being held\nfor too long.\n\nMariaDB 10.3 introduced three new variables to handle this situation.\n\n* idle_transaction_timeout (all transactions)\n* idle_write_transaction_timeout (write transactions - called\nidle_readwrite_transaction_timeout until MariaDB 10.3.2)\n* idle_readonly_transaction_timeout (read transactions)\n\nThese accept a time in seconds to time out, by closing the connection,\ntransactions that are idle for longer than this period. By default all are set\nto zero, or no timeout.\n\nidle_transaction_timeout affects all transactions,\nidle_write_transaction_timeout affects write transactions only and\nidle_readonly_transaction_timeout affects read transactions only. The latter\ntwo variables work independently. However, if either is set along with\nidle_transaction_timeout, the settings for idle_write_transaction_timeout or\nidle_readonly_transaction_timeout will take precedence.\n\nExamples\n--------\n\nSET SESSION idle_transaction_timeout=2;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 3 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nSET SESSION idle_write_transaction_timeout=2;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 3 seconds\nSELECT * FROM t;\nEmpty set (0.000 sec)\nINSERT INTO t VALUES(1);\n## wait 3 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nSET SESSION idle_transaction_timeout=2, SESSION\nidle_readonly_transaction_timeout=10;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n ## wait 3 seconds\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 11 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nURL: https://mariadb.com/kb/en/transaction-timeouts/','','https://mariadb.com/kb/en/transaction-timeouts/'),(152,'IS_FREE_LOCK',14,'Syntax\n------\n\nIS_FREE_LOCK(str)\n\nDescription\n-----------\n\nChecks whether the lock named str is free to use (that is, not locked).\nReturns 1 if the lock is free (no one is using the lock), 0 if the lock is in\nuse, and NULL if an error occurs (such as an incorrect argument, like an empty\nstring or NULL). str is case insensitive.\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table contains information about locks of this kind (as\nwell as metadata locks).\n\nStatements using the IS_FREE_LOCK function are not safe for statement-based\nreplication.\n\nURL: https://mariadb.com/kb/en/is_free_lock/','','https://mariadb.com/kb/en/is_free_lock/'),(156,'IS_IPV6',14,'Syntax\n------\n\nIS_IPV6(expr)\n\nDescription\n-----------\n\nReturns 1 if the expression is a valid IPv6 address specified as a string,\notherwise returns 0. Does not consider IPv4 addresses to be valid IPv6\naddresses.\n\nExamples\n--------\n\nSELECT IS_IPV6(\'48f3::d432:1431:ba23:846f\');\n+--------------------------------------+\n| IS_IPV6(\'48f3::d432:1431:ba23:846f\') |\n+--------------------------------------+\n|                                    1 |\n+--------------------------------------+\n1 row in set (0.02 sec)\n\nSELECT IS_IPV6(\'10.0.1.1\');\n+---------------------+\n| IS_IPV6(\'10.0.1.1\') |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/is_ipv6/','','https://mariadb.com/kb/en/is_ipv6/'),(157,'IS_USED_LOCK',14,'Syntax\n------\n\nIS_USED_LOCK(str)\n\nDescription\n-----------\n\nChecks whether the lock named str is in use (that is, locked). If so, it\nreturns the connection identifier of the client that holds the lock.\nOtherwise, it returns NULL. str is case insensitive.\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table contains information about locks of this kind (as\nwell as metadata locks).\n\nStatements using the IS_USED_LOCK function are not safe for statement-based\nreplication.\n\nURL: https://mariadb.com/kb/en/is_used_lock/','','https://mariadb.com/kb/en/is_used_lock/'),(102,'WAIT and NOWAIT',8,'MariaDB starting with 10.3.0\n----------------------------\nMariaDB 10.3.0 introduced extended syntax so that it is possible to set\ninnodb_lock_wait_timeout and lock_wait_timeout for the following statements:\n\nSyntax\n------\n\nALTER TABLE tbl_name [WAIT n|NOWAIT] ...\nCREATE ... INDEX ON tbl_name (index_col_name, ...) [WAIT n|NOWAIT] ...\nDROP INDEX ... [WAIT n|NOWAIT]\nDROP TABLE tbl_name [WAIT n|NOWAIT] ...\nLOCK TABLE ... [WAIT n|NOWAIT]\nOPTIMIZE TABLE tbl_name [WAIT n|NOWAIT]\nRENAME TABLE tbl_name [WAIT n|NOWAIT] ...\nSELECT ... FOR UPDATE [WAIT n|NOWAIT]\nSELECT ... LOCK IN SHARE MODE [WAIT n|NOWAIT]\nTRUNCATE TABLE tbl_name [WAIT n|NOWAIT]\n\nDescription\n-----------\n\nThe lock wait timeout can be explicitly set in the statement by using either\nWAIT n (to set the wait in seconds) or NOWAIT, in which case the statement\nwill immediately fail if the lock cannot be obtained. WAIT 0 is equivalent to\nNOWAIT.\n\nURL: https://mariadb.com/kb/en/wait-and-nowait/','','https://mariadb.com/kb/en/wait-and-nowait/'),(106,'DROP USER',10,'Syntax\n------\n\nDROP USER [IF EXISTS] user_name [, user_name] ...\n\nDescription\n-----------\n\nThe DROP USER statement removes one or more MariaDB accounts. It removes\nprivilege rows for the account from all grant tables. To use this statement,\nyou must have the global CREATE USER privilege or the DELETE privilege for the\nmysql database. Each account is named using the same format as for the CREATE\nUSER statement; for example, \'jeffrey\'@\'localhost\'. If you specify only the\nuser name part of the account name, a host name part of \'%\' is used. For\nadditional information about specifying account names, see CREATE USER.\n\nNote that, if you specify an account that is currently connected, it will not\nbe deleted until the connection is closed. The connection will not be\nautomatically closed.\n\nIf any of the specified user accounts do not exist, ERROR 1396 (HY000)\nresults. If an error occurs, DROP USER will still drop the accounts that do\nnot result in an error. Only one error is produced for all users which have\nnot been dropped:\n\nERROR 1396 (HY000): Operation DROP USER failed for \'u1\'@\'%\',\'u2\'@\'%\'\n\nFailed CREATE or DROP operations, for both users and roles, produce the same\nerror code.\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the user does not exist.\n\nExamples\n--------\n\nDROP USER bob;\n\nDROP USER foo2@localhost,foo2@\'127.%\';\n\nIF EXISTS:\n\nDROP USER bob;\nERROR 1396 (HY000): Operation DROP USER failed for \'bob\'@\'%\'\n\nDROP USER IF EXISTS bob;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+---------------------------------------------+\n| Level | Code | Message                                     |\n+-------+------+---------------------------------------------+\n| Note  | 1974 | Can\'t drop user \'bob\'@\'%\'; it doesn\'t exist |\n+-------+------+---------------------------------------------+\n\nURL: https://mariadb.com/kb/en/drop-user/','','https://mariadb.com/kb/en/drop-user/'),(108,'RENAME USER',10,'Syntax\n------\n\nRENAME USER old_user TO new_user\n  [, old_user TO new_user] ...\n\nDescription\n-----------\n\nThe RENAME USER statement renames existing MariaDB accounts. To use it, you\nmust have the global CREATE USER privilege or the UPDATE privilege for the\nmysql database. Each account is named using the same format as for the CREATE\nUSER statement; for example, \'jeffrey\'@\'localhost\'. If you specify only the\nuser name part of the account name, a host name part of \'%\' is used.\n\nIf any of the old user accounts do not exist or any of the new user accounts\nalready exist, ERROR 1396 (HY000) results. If an error occurs, RENAME USER\nwill still rename the accounts that do not result in an error.\n\nExamples\n--------\n\nCREATE USER \'donald\', \'mickey\';\nRENAME USER \'donald\' TO \'duck\'@\'localhost\', \'mickey\' TO \'mouse\'@\'localhost\';\n\nURL: https://mariadb.com/kb/en/rename-user/','','https://mariadb.com/kb/en/rename-user/'),(109,'REVOKE',10,'Privileges\n----------\n\nSyntax\n------\n\nREVOKE \n  priv_type [(column_list)]\n   [, priv_type [(column_list)]] ...\n  ON [object_type] priv_level\n  FROM user [, user] ...\n\nREVOKE ALL PRIVILEGES, GRANT OPTION\n  FROM user [, user] ...\n\nDescription\n-----------\n\nThe REVOKE statement enables system administrators to revoke privileges (or\nroles - see section below) from MariaDB accounts. Each account is named using\nthe same format as for the GRANT statement; for example,\n\'jeffrey\'@\'localhost\'. If you specify only the user name part of the account\nname, a host name part of \'%\' is used. For details on the levels at which\nprivileges exist, the allowable priv_type and priv_level values, and the\nsyntax for specifying users and passwords, see GRANT.\n\nTo use the first REVOKE syntax, you must have the GRANT OPTION privilege, and\nyou must have the privileges that you are revoking.\n\nTo revoke all privileges, use the second syntax, which drops all global,\ndatabase, table, column, and routine privileges for the named user or users:\n\nREVOKE ALL PRIVILEGES, GRANT OPTION FROM user [, user] ...\n\nTo use this REVOKE syntax, you must have the global CREATE USER privilege or\nthe UPDATE privilege for the mysql database. See GRANT.\n\nExamples\n--------\n\nREVOKE SUPER ON *.* FROM \'alexander\'@\'localhost\';\n\nRoles\n-----\n\nSyntax\n------\n\nREVOKE role  [, role ...]\n  FROM grantee [, grantee2 ... ]\n\nREVOKE ADMIN OPTION FOR role FROM grantee [, grantee2]\n\nDescription\n-----------\n\nREVOKE is also used to remove a role from a user or another role that it\'s\npreviously been assigned to. If a role has previously been set as a default\nrole, REVOKE does not remove the record of the default role from the\nmysql.user table. If the role is subsequently granted again, it will again be\nthe user\'s default. Use SET DEFAULT ROLE NONE to explicitly remove this.\n\nBefore MariaDB 10.1.13, the REVOKE role statement was not permitted in\nprepared statements.\n\nExample\n-------\n\nREVOKE journalist FROM hulda\n\nURL: https://mariadb.com/kb/en/revoke/','','https://mariadb.com/kb/en/revoke/'),(160,'NAME_CONST',14,'Syntax\n------\n\nNAME_CONST(name,value)\n\nDescription\n-----------\n\nReturns the given value. When used to produce a result set column,\nNAME_CONST() causes the column to have the given name. The arguments should be\nconstants.\n\nThis function is used internally when replicating stored procedures. It makes\nlittle sense to use it explicitly in SQL statements, and it was not supposed\nto be used like that.\n\nSELECT NAME_CONST(\'myname\', 14);\n+--------+\n| myname |\n+--------+\n|     14 |\n+--------+\n\nURL: https://mariadb.com/kb/en/name_const/','','https://mariadb.com/kb/en/name_const/'),(163,'SLEEP',14,'Syntax\n------\n\nSLEEP(duration)\n\nDescription\n-----------\n\nSleeps (pauses) for the number of seconds given by the duration argument, then\nreturns 0. If SLEEP() is interrupted, it returns 1. The duration may have a\nfractional part given in microseconds.\n\nStatements using the SLEEP() function are not safe for replication.\n\nExample\n-------\n\nSELECT SLEEP(5.5);\n+------------+\n| SLEEP(5.5) |\n+------------+\n|          0 |\n+------------+\n1 row in set (5.50 sec)\n\nURL: https://mariadb.com/kb/en/sleep/','','https://mariadb.com/kb/en/sleep/'),(167,'!',15,'Syntax\n------\n\nNOT, !\n\nDescription\n-----------\n\nLogical NOT. Evaluates to 1 if the operand is 0, to 0 if the operand is\nnon-zero, and NOT NULL returns NULL.\n\nBy default, the ! operator has a higher precedence. If the HIGH_NOT_PRECEDENCE\nSQL_MODE flag is set, NOT and ! have the same precedence.\n\nExamples\n--------\n\nSELECT NOT 10;\n+--------+\n| NOT 10 |\n+--------+\n|      0 |\n+--------+\n\nSELECT NOT 0;\n+-------+\n| NOT 0 |\n+-------+\n|     1 |\n+-------+\n\nSELECT NOT NULL;\n+----------+\n| NOT NULL |\n+----------+\n|     NULL |\n+----------+\n\nSELECT ! (1+1);\n+---------+\n| ! (1+1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ! 1+1;\n+-------+\n| ! 1+1 |\n+-------+\n|     1 |\n+-------+\n\nURL: https://mariadb.com/kb/en/not/','','https://mariadb.com/kb/en/not/'),(110,'SET PASSWORD',10,'Syntax\n------\n\nSET PASSWORD [FOR user] =\n  {\n    PASSWORD(\'some password\')\n   | OLD_PASSWORD(\'some password\')\n   | \'encrypted password\'\n  }\n\nDescription\n-----------\n\nThe SET PASSWORD statement assigns a password to an existing MariaDB user\naccount.\n\nIf the password is specified using the PASSWORD() or OLD_PASSWORD() function,\nthe literal text of the password should be given. If the password is specified\nwithout using either function, the password should be the already-encrypted\npassword value as returned by PASSWORD().\n\nOLD_PASSWORD() should only be used if your MariaDB/MySQL clients are very old\n(< 4.0.0).\n\nWith no FOR clause, this statement sets the password for the current user. Any\nclient that has connected to the server using a non-anonymous account can\nchange the password for that account.\n\nWith a FOR clause, this statement sets the password for a specific account on\nthe current server host. Only clients that have the UPDATE privilege for the\nmysql database can do this. The user value should be given in\nuser_name@host_name format, where user_name and host_name are exactly as they\nare listed in the User and Host columns of the mysql.user table (or view in\nMariaDB-10.4 onwards) entry.\n\nThe argument to PASSWORD() and the password given to MariaDB clients can be of\narbitrary length.\n\nAuthentication Plugin Support\n-----------------------------\n\nMariaDB starting with 10.4\n--------------------------\nIn MariaDB 10.4 and later, SET PASSWORD (with or without PASSWORD()) works for\naccounts authenticated via any authentication plugin that supports passwords\nstored in the mysql.global_priv table.\n\nThe ed25519, mysql_native_password, and mysql_old_password authentication\nplugins store passwords in the mysql.global_priv table.\n\nIf you run SET PASSWORD on an account that authenticates with one of these\nauthentication plugins that stores passwords in the mysql.global_priv table,\nthen the PASSWORD() function is evaluated by the specific authentication\nplugin used by the account. The authentication plugin hashes the password with\na method that is compatible with that specific authentication plugin.\n\nThe unix_socket, named_pipe, gssapi, and pam authentication plugins do not\nstore passwords in the mysql.global_priv table. These authentication plugins\nrely on other methods to authenticate the user.\n\nIf you attempt to run SET PASSWORD on an account that authenticates with one\nof these authentication plugins that doesn\'t store a password in the\nmysql.global_priv table, then MariaDB Server will raise a warning like the\nfollowing:\n\nSET PASSWORD is ignored for users authenticating via unix_socket plugin\n\nSee Authentication from MariaDB 10.4 for an overview of authentication changes\nin MariaDB 10.4.\n\nMariaDB until 10.3\n------------------\nIn MariaDB 10.3 and before, SET PASSWORD (with or without PASSWORD()) only\nworks for accounts authenticated via mysql_native_password or\nmysql_old_password authentication plugins\n\nPasswordless User Accounts\n--------------------------\n\nUser accounts do not always require passwords to login.\n\nThe unix_socket , named_pipe and gssapi authentication plugins do not require\na password to authenticate the user.\n\nThe pam authentication plugin may or may not require a password to\nauthenticate the user, depending on the specific configuration.\n\nThe mysql_native_password and mysql_old_password authentication plugins\nrequire passwords for authentication, but the password can be blank. In that\ncase, no password is required.\n\nIf you provide a password while attempting to log into the server as an\naccount that doesn\'t require a password, then MariaDB server will simply\nignore the password.\n\nMariaDB starting with 10.4\n--------------------------\nIn MariaDB 10.4 and later, a user account can be defined to use multiple\nauthentication plugins in a specific order of preference. This specific\nscenario may be more noticeable in these versions, since an account could be\nassociated with some authentication plugins that require a password, and some\nthat do not.\n\nExample\n-------\n\nFor example, if you had an entry with User and Host column values of \'bob\' and\n\'%.loc.gov\', you would write the statement like this:\n\nSET PASSWORD FOR \'bob\'@\'%.loc.gov\' = PASSWORD(\'newpass\');\n\nIf you want to delete a password for a user, you would do:\n\nSET PASSWORD FOR \'bob\'@localhost = PASSWORD(\"\");\n\nURL: https://mariadb.com/kb/en/set-password/','','https://mariadb.com/kb/en/set-password/'),(112,'DROP ROLE',10,'Syntax\n------\n\nDROP ROLE [IF EXISTS] role_name [,role_name ...]\n\nDescription\n-----------\n\nThe DROP ROLE statement removes one or more MariaDB roles. To use this\nstatement, you must have the global CREATE USER privilege or the DELETE\nprivilege for the mysql database.\n\nDROP ROLE does not disable roles for connections which selected them with SET\nROLE. If a role has previously been set as a default role, DROP ROLE does not\nremove the record of the default role from the mysql.user table. If the role\nis subsequently recreated and granted, it will again be the user\'s default.\nUse SET DEFAULT ROLE NONE to explicitly remove this.\n\nIf any of the specified user accounts do not exist, ERROR 1396 (HY000)\nresults. If an error occurs, DROP ROLE will still drop the roles that do not\nresult in an error. Only one error is produced for all roles which have not\nbeen dropped:\n\nERROR 1396 (HY000): Operation DROP ROLE failed for \'a\',\'b\',\'c\'\n\nFailed CREATE or DROP operations, for both users and roles, produce the same\nerror code.\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a warning instead of an\nerror if the role does not exist.\n\nExamples\n--------\n\nDROP ROLE journalist;\n\nThe same thing using the optional IF EXISTS clause:\n\nDROP ROLE journalist;\nERROR 1396 (HY000): Operation DROP ROLE failed for \'journalist\'\n\nDROP ROLE IF EXISTS journalist;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nNote (Code 1975): Can\'t drop role \'journalist\'; it doesn\'t exist\n\nURL: https://mariadb.com/kb/en/drop-role/','','https://mariadb.com/kb/en/drop-role/'),(168,'&&',15,'Syntax\n------\n\nAND, &&\n\nDescription\n-----------\n\nLogical AND. Evaluates to 1 if all operands are non-zero and not NULL, to 0 if\none or more operands are 0, otherwise NULL is returned.\n\nFor this operator, short-circuit evaluation can be used.\n\nExamples\n--------\n\nSELECT 1 && 1;\n+--------+\n| 1 && 1 |\n+--------+\n|      1 |\n+--------+\n\nSELECT 1 && 0;\n+--------+\n| 1 && 0 |\n+--------+\n|      0 |\n+--------+\n\nSELECT 1 && NULL;\n+-----------+\n| 1 && NULL |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT 0 && NULL;\n+-----------+\n| 0 && NULL |\n+-----------+\n|         0 |\n+-----------+\n\nSELECT NULL && 0;\n+-----------+\n| NULL && 0 |\n+-----------+\n|         0 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/and/','','https://mariadb.com/kb/en/and/'),(169,'XOR',15,'Syntax\n------\n\nXOR\n\nDescription\n-----------\n\nXOR stands for eXclusive OR. Returns NULL if either operand is NULL. For\nnon-NULL operands, evaluates to 1 if an odd number of operands is non-zero,\notherwise 0 is returned.\n\nExamples\n--------\n\nSELECT 1 XOR 1;\n+---------+\n| 1 XOR 1 |\n+---------+\n|       0 |\n+---------+\n\nSELECT 1 XOR 0;\n+---------+\n| 1 XOR 0 |\n+---------+\n|       1 |\n+---------+\n\nSELECT 1 XOR NULL;\n+------------+\n| 1 XOR NULL |\n+------------+\n|       NULL |\n+------------+\n\nIn the following example, the right 1 XOR 1 is evaluated first, and returns 0.\nThen, 1 XOR 0 is evaluated, and 1 is returned.\n\nSELECT 1 XOR 1 XOR 1;\n+---------------+\n| 1 XOR 1 XOR 1 |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/xor/','','https://mariadb.com/kb/en/xor/'),(111,'CREATE ROLE',10,'Syntax\n------\n\nCREATE [OR REPLACE] ROLE [IF NOT EXISTS] role \n [WITH ADMIN\n  {CURRENT_USER | CURRENT_ROLE | user | role}]\n\nDescription\n-----------\n\nThe CREATE ROLE statement creates one or more MariaDB roles. To use it, you\nmust have the global CREATE USER privilege or the INSERT privilege for the\nmysql database. For each account, CREATE ROLE creates a new row in the\nmysql.user table that has no privileges, and with the corresponding is_role\nfield set to Y. It also creates a record in the mysql.roles_mapping table.\n\nIf any of the specified roles already exist, ERROR 1396 (HY000) results. If an\nerror occurs, CREATE ROLE will still create the roles that do not result in an\nerror. The maximum length for a role is 128 characters. Role names can be\nquoted, as explained in the Identifier names page. Only one error is produced\nfor all roles which have not been created:\n\nERROR 1396 (HY000): Operation CREATE ROLE failed for \'a\',\'b\',\'c\'\n\nFailed CREATE or DROP operations, for both users and roles, produce the same\nerror code.\n\nPUBLIC and NONE are reserved, and cannot be used as role names. NONE is used\nto unset a role and PUBLIC has a special use in other systems, such as Oracle,\nso is reserved for compatibility purposes.\n\nFor valid identifiers to use as role names, see Identifier Names.\n\nWITH ADMIN\n----------\n\nThe optional WITH ADMIN clause determines whether the current user, the\ncurrent role or another user or role has use of the newly created role. If the\nclause is omitted, WITH ADMIN CURRENT_USER is treated as the default, which\nmeans that the current user will be able to GRANT this role to users.\n\nOR REPLACE\n----------\n\nIf the optional OR REPLACE clause is used, it acts as a shortcut for:\n\nDROP ROLE IF EXISTS name;\nCREATE ROLE name ...;\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified role already exists. Cannot be used together with\nthe OR REPLACE clause.\n\nExamples\n--------\n\nCREATE ROLE journalist;\n\nCREATE ROLE developer WITH ADMIN lorinda@localhost;\n\nGranting the role to another user. Only user lorinda@localhost has permission\nto grant the developer role:\n\nSELECT USER();\n+-------------------+\n| USER()            |\n+-------------------+\n| henning@localhost |\n+-------------------+\n...\nGRANT developer TO ian@localhost;\nAccess denied for user \'henning\'@\'localhost\'\n\nSELECT USER();\n+-------------------+\n| USER()            |\n+-------------------+\n| lorinda@localhost |\n+-------------------+\n\nGRANT m_role TO ian@localhost;\n\nThe OR REPLACE and IF NOT EXISTS clauses. The journalist role already exists:\n\nCREATE ROLE journalist;\nERROR 1396 (HY000): Operation CREATE ROLE failed for \'journalist\'\n\nCREATE OR REPLACE ROLE journalist;\nQuery OK, 0 rows affected (0.00 sec)\n\nCREATE ROLE IF NOT EXISTS journalist;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+---------------------------------------------------+\n| Level | Code | Message                                           |\n+-------+------+---------------------------------------------------+\n| Note  | 1975 | Can\'t create role \'journalist\'; it already exists |\n+-------+------+---------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/create-role/','','https://mariadb.com/kb/en/create-role/'),(113,'SET ROLE',10,'Syntax\n------\n\nSET ROLE { role | NONE }\n\nDescription\n-----------\n\nThe SET ROLE statement enables a role, along with all of its associated\npermissions, for the current session. To unset a role, use NONE .\n\nIf a role that doesn\'t exist, or to which the user has not been assigned, is\nspecified, an ERROR 1959 (OP000): Invalid role specification error occurs.\n\nAn automatic SET ROLE is implicitly performed when a user connects if that\nuser has been assigned a default role. See SET DEFAULT ROLE.\n\nExample\n-------\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| NULL         |\n+--------------+\n\nSET ROLE staff;\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| staff        |\n+--------------+\n\nSET ROLE NONE;\n\nSELECT CURRENT_ROLE();\n+----------------+\n| CURRENT_ROLE() |\n+----------------+\n| NULL           |\n+----------------+\n\nURL: https://mariadb.com/kb/en/set-role/','','https://mariadb.com/kb/en/set-role/'),(114,'SET DEFAULT ROLE',10,'Syntax\n------\n\nSET DEFAULT ROLE { role | NONE } [ FOR user@host ]\n\nDescription\n-----------\n\nThe SET DEFAULT ROLE statement sets a default role for a specified (or\ncurrent) user. A default role is automatically enabled when a user connects\n(an implicit SET ROLE statement is executed immediately after a connection is\nestablished).\n\nTo be able to set a role as a default, the role must already have been granted\nto that user, and one needs the privileges to enable this role (if you cannot\ndo SET ROLE X, you won\'t be able to do SET DEFAULT ROLE X). To set a default\nrole for another user one needs to have write access to the mysql database.\n\nTo remove a user\'s default role, use SET DEFAULT ROLE NONE [ FOR user@host ].\nThe record of the default role is not removed if the role is dropped or\nrevoked, so if the role is subsequently re-created or granted, it will again\nbe the user\'s default role.\n\nThe default role is stored in the default_role column in the mysql.user\ntable/view, as well as in the Information Schema APPLICABLE_ROLES table, so\nthese can be viewed to see which role has been assigned to a user as the\ndefault.\n\nExamples\n--------\n\nSetting a default role for the current user:\n\nSET DEFAULT ROLE journalist;\n\nRemoving a default role from the current user:\n\nSET DEFAULT ROLE NONE;\n\nSetting a default role for another user. The role has to have been granted to\nthe user before it can be set as default:\n\nCREATE ROLE journalist;\nCREATE USER taniel;\n\nSET DEFAULT ROLE journalist FOR taniel;\nERROR 1959 (OP000): Invalid role specification `journalist`\n\nGRANT journalist TO taniel;\nSET DEFAULT ROLE journalist FOR taniel;\n\nViewing mysql.user:\n\nselect * from mysql.user where user=\'taniel\'\\G\n*************************** 1. row ***************************\n         Host: %\n         User: taniel\n...\n       is_role: N\n     default_role: journalist\n...\n\nRemoving a default role for another user\n\nSET DEFAULT ROLE NONE FOR taniel;\n\nURL: https://mariadb.com/kb/en/set-default-role/','','https://mariadb.com/kb/en/set-default-role/'),(184,'STDDEV_SAMP',16,'Syntax\n------\n\nSTDDEV_SAMP(expr)\n\nDescription\n-----------\n\nReturns the sample standard deviation of expr (the square root of VAR_SAMP()).\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nSTDDEV_SAMP() can be used as a window function.\n\nSTDDEV_SAMP() returns NULL if there were no matching rows.\n\nURL: https://mariadb.com/kb/en/stddev_samp/','','https://mariadb.com/kb/en/stddev_samp/'),(189,'BENCHMARK',17,'Syntax\n------\n\nBENCHMARK(count,expr)\n\nDescription\n-----------\n\nThe BENCHMARK() function executes the expression expr repeatedly count times.\nIt may be used to time how quickly MariaDB processes the expression. The\nresult value is always 0. The intended use is from within the mysql client,\nwhich reports query execution times.\n\nExamples\n--------\n\nSELECT BENCHMARK(1000000,ENCODE(\'hello\',\'goodbye\'));\n+----------------------------------------------+\n| BENCHMARK(1000000,ENCODE(\'hello\',\'goodbye\')) |\n+----------------------------------------------+\n|                                            0 |\n+----------------------------------------------+\n1 row in set (0.21 sec)\n\nURL: https://mariadb.com/kb/en/benchmark/','','https://mariadb.com/kb/en/benchmark/'),(115,'Roles Overview',10,'Description\n-----------\n\nA role bundles a number of privileges together. It assists larger\norganizations where, typically, a number of users would have the same\nprivileges, and, previously, the only way to change the privileges for a group\nof users was by changing each user\'s privileges individually.\n\nAlternatively, multiple external users could have been assigned the same user,\nand there would have been no way to see which actual user was responsible for\nwhich action.\n\nWith roles, managing this is easy. For example, there could be a number of\nusers assigned to a journalist role, with identical privileges. Changing the\nprivileges for all the journalists is a matter of simply changing the role\'s\nprivileges, while the individual user is still linked with any changes that\ntake place.\n\nRoles are created with the CREATE ROLE statement, and dropped with the DROP\nROLE statement. Roles are then assigned to a user with an extension to the\nGRANT statement, while privileges are assigned to a role in the regular way\nwith GRANT. Similarly, the REVOKE statement can be used to both revoke a role\nfrom a user, or revoke a privilege from a role.\n\nOnce a user has connected, he can obtain all privileges associated with a role\nby setting a role with the SET ROLE statement. The CURRENT_ROLE function\nreturns the currently set role for the session, if any.\n\nOnly roles granted directly to a user can be set, roles granted to other roles\ncannot. Instead the privileges granted to a role, which is, in turn, granted\nto another role (grantee), will be immediately available to any user who sets\nthis second grantee role.\n\nThe SET DEFAULT ROLE statement allows one to set a default role for a user. A\ndefault role is automatically enabled when a user connects (an implicit SET\nROLE statement is executed immediately after a connection is established).\n\nRoles were implemented as a GSoC 2013 project by Vicentiu Ciorbaru.\n\nSystem Tables\n-------------\n\nInformation about roles and who they\'ve been granted to can be found in the\nInformation Schema APPLICABLE_ROLES table as well as the mysql.ROLES_MAPPING\ntable.\n\nThe Information Schema ENABLED_ROLES table shows the enabled roles for the\ncurrent session.\n\nExamples\n--------\n\nCreating a role and granting a privilege:\n\nCREATE ROLE journalist;\n\nGRANT SHOW DATABASES ON *.* TO journalist;\n\nGRANT journalist to hulda;\n\nNote, that hulda has no SHOW DATABASES privilege, even though she was granted\nthe journalist role. She needs to set the role first:\n\nSHOW DATABASES;\n+--------------------+\n| Database           |\n+--------------------+\n| information_schema |\n+--------------------+\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| NULL         |\n+--------------+\n\nSET ROLE journalist;\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| journalist   |\n+--------------+\n\nSHOW DATABASES;\n+--------------------+\n| Database           |\n+--------------------+\n| ...                |\n| information_schema |\n| mysql              |\n| performance_schema |\n| test               |\n| ...                |\n+--------------------+\n\nSET ROLE NONE;\n\nRoles can be granted to roles:\n\nCREATE ROLE writer;\n\nGRANT SELECT ON data.* TO writer;\n\nGRANT writer TO journalist;\n\nBut one does not need to set a role granted to a role. For example, hulda will\nautomatically get all writer privileges when she sets the journalist role:\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| NULL         |\n+--------------+\n\nSHOW TABLES FROM data;\nEmpty set (0.01 sec)\n\nSET ROLE journalist;\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| journalist   |\n+--------------+\n\nSHOW TABLES FROM data;\n+------------------------------+\n| Tables_in_data               |\n+------------------------------+\n| set1                         |\n| ...                          |\n+------------------------------+\n\nRoles and Views (and Stored Routines)\n-------------------------------------\n\nWhen a user sets a role, he, in a sense, has two identities with two\nassociated sets of privileges. But a view (or a stored routine) can have only\none definer. So, when a view (or a stored routine) is created with the SQL\nSECURITY DEFINER, one can specify whether the definer should be CURRENT_USER\n(and the view will have none of the privileges of the user\'s role) or\nCURRENT_ROLE (in this case, the view will use role\'s privileges, but none of\nthe user\'s privileges). As a result, sometimes one can create a view that is\nimpossible to use.\n\nCREATE ROLE r1;\n\nGRANT ALL ON db1.* TO r1;\n\nGRANT r1 TO foo@localhost;\n\nGRANT ALL ON db.* TO foo@localhost;\n\nSELECT CURRENT_USER\n+---------------+\n| current_user  |\n+---------------+\n| foo@localhost |\n+---------------+\n\nSET ROLE r1;\n\nCREATE TABLE db1.t1 (i int);\n\nCREATE VIEW db.v1 AS SELECT * FROM db1.t1;\n\nSHOW CREATE VIEW db.v1;\n+------+-----------------------------------------------------------------------\n------------------------------------------------------------------+------------\n---------+----------------------+\n| View | Create View                                                          \n                                 |\ncharacter_set_client | collation_connection |\n+------+-----------------------------------------------------------------------\n------------------------------------------------------------------+------------\n---------+----------------------+\n| v1   | CREATE ALGORITHM=UNDEFINED DEFINER=`foo`@`localhost` SQL SECURITY\nDEFINER VIEW `db`.`v1` AS SELECT `db1`.`t1`.`i` AS `i` from `db1`.`t1` | utf8 \n       | utf8_general_ci      |\n+------+-----------------------------------------------------------------------\n------------------------------------------------------------------+------------\n---------+----------------------+\n\nCREATE DEFINER=CURRENT_ROLE VIEW db.v2 AS SELECT * FROM db1.t1;\n\nSHOW CREATE VIEW db.b2;\n+------+-----------------------------------------------------------------------\n-----------------------------------------------------+----------------------+--\n-------------------+\n| View | Create View                                                          \n                           | character_set_client |\ncollation_connection |\n+------+-----------------------------------------------------------------------\n-----------------------------------------------------+----------------------+--\n-------------------+\n| v2   | CREATE ALGORITHM=UNDEFINED DEFINER=`r1` SQL SECURITY DEFINER VIEW\n`db`.`v2` AS select `db1`.`t1`.`a` AS `a` from `db1`.`t1` | utf8              \n | utf8_general_ci      |\n+------+-----------------------------------------------------------------------\n-----------------------------------------------------+----------------------+--\n-------------------+\n\nOther Resources\n---------------\n\n* Roles Review by Peter Gulutzan\n\nURL: https://mariadb.com/kb/en/roles_overview/','','https://mariadb.com/kb/en/roles_overview/'),(190,'BINLOG_GTID_POS',17,'Syntax\n------\n\nBINLOG_GTID_POS(binlog_filename,binlog_offset)\n\nDescription\n-----------\n\nThe BINLOG_GTID_POS() function takes as input an old-style binary log position\nin the form of a file name and a file offset. It looks up the position in the\ncurrent binlog, and returns a string representation of the corresponding GTID\nposition. If the position is not found in the current binlog, NULL is returned.\n\nExamples\n--------\n\nSELECT BINLOG_GTID_POS(\"master-bin.000001\", 600);\n\nURL: https://mariadb.com/kb/en/binlog_gtid_pos/','','https://mariadb.com/kb/en/binlog_gtid_pos/'),(116,'Account Locking',10,'MariaDB starting with 10.4.2\n----------------------------\nAccount locking was introduced in MariaDB 10.4.2.\n\nDescription\n-----------\n\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected).\n\nUser accounts can be locked at creation, with the CREATE USER statement, or\nmodified after creation with the ALTER USER statement. For example:\n\nCREATE USER \'lorin\'@\'localhost\' ACCOUNT LOCK;\n\nor\n\nALTER USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nThe server will return an ER_ACCOUNT_HAS_BEEN_LOCKED error when locked users\nattempt to connect:\n\nmysql -ulorin\n ERROR 4151 (HY000): Access denied, this account is locked\n\nThe ALTER USER statement is also used to unlock a user:\n\nALTER USER \'lorin\'@\'localhost\' ACCOUNT UNLOCK;\n\nThe SHOW CREATE USER statement will show whether the account is locked:\n\nSHOW CREATE USER \'marijn\'@\'localhost\';\n+-----------------------------------------------+\n| CREATE USER for marijn@localhost              |\n+-----------------------------------------------+\n| CREATE USER \'marijn\'@\'localhost\' ACCOUNT LOCK |\n+-----------------------------------------------+\n\nas well as querying the mysql.global_priv table:\n\nSELECT CONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv)) FROM\nmysql.global_priv \n WHERE user=\'marijn\';\n+------------------------------------------------------------------------------\n-------+\n| CONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv))                        \n    |\n+------------------------------------------------------------------------------\n-------+\n| marijn@localhost => {\n  \"access\": 0,\n  \"plugin\": \"mysql_native_password\",\n  \"authentication_string\": \"\",\n  \"account_locked\": true,\n  \"password_last_changed\": 1558017158\n} |\n+------------------------------------------------------------------------------\n-------+\n\nURL: https://mariadb.com/kb/en/account-locking/','','https://mariadb.com/kb/en/account-locking/'),(118,'User Password Expiry',10,'MariaDB starting with 10.4.3\n----------------------------\nUser password expiry was introduced in MariaDB 10.4.3.\n\nPassword expiry permits administrators to expire user passwords, either\nmanually or automatically.\n\nSystem Variables\n----------------\n\nThere are two system variables which affect password expiry:\ndefault_password_lifetime, which determines the amount of time between\nrequiring the user to change their password. 0, the default, means automatic\npassword expiry is not active.\n\nThe second variable, disconnect_on_expired_password determines whether a\nclient is permitted to connect if their password has expired, or whether they\nare permitted to connect in sandbox mode, able to perform a limited subset of\nqueries related to resetting the password, in particular SET PASSWORD and SET.\n\nSetting a Password Expiry Limit for a User\n------------------------------------------\n\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal using the CREATE USER or ALTER USER statements, for example:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nLimits can be disabled by use of the NEVER keyword, for example:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\n\nA manually set limit can be restored the system default by use of DEFAULT, for\nexample:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nSHOW CREATE USER\n----------------\n\nThe SHOW CREATE USER statement will display information about the password\nexpiry status of the user. Unlike MySQL, it will not display if the user is\nunlocked, or if the password expiry is set to default.\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\nCREATE USER \'konstantin\'@\'localhost\' PASSWORD EXPIRE NEVER;\nCREATE USER \'amse\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nSHOW CREATE USER \'monty\'@\'localhost\';\n+------------------------------------------------------------------+\n| CREATE USER for monty@localhost                                  |\n+------------------------------------------------------------------+\n| CREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY |\n+------------------------------------------------------------------+\n\nSHOW CREATE USER \'konstantin\'@\'localhost\';\n+------------------------------------------------------------+\n| CREATE USER for konstantin@localhost                       |\n+------------------------------------------------------------+\n| CREATE USER \'konstantin\'@\'localhost\' PASSWORD EXPIRE NEVER |\n+------------------------------------------------------------+\n\nSHOW CREATE USER \'amse\'@\'localhost\';\n+--------------------------------+\n| CREATE USER for amse@localhost |\n+--------------------------------+\n| CREATE USER \'amse\'@\'localhost\' |\n+--------------------------------+\n\nChecking When Passwords Expire\n------------------------------\n\nThe following query can be used to check when the current passwords expire for\nall users:\n\nWITH password_expiration_info AS (\n SELECT User, Host,\n IF(\n IFNULL(JSON_EXTRACT(Priv, \'$.password_lifetime\'), -1) = -1,\n @@global.default_password_lifetime,\n JSON_EXTRACT(Priv, \'$.password_lifetime\')\n ) AS password_lifetime,\n JSON_EXTRACT(Priv, \'$.password_last_changed\') AS password_last_changed\n FROM mysql.global_priv\n)\nSELECT pei.User, pei.Host,\n pei.password_lifetime,\n FROM_UNIXTIME(pei.password_last_changed) AS password_last_changed_datetime,\n FROM_UNIXTIME(\n pei.password_last_changed +\n (pei.password_lifetime * 60 * 60 * 24)\n ) AS password_expiration_datetime\n FROM password_expiration_info pei\n WHERE pei.password_lifetime != 0\n AND pei.password_last_changed IS NOT NULL\nUNION\nSELECT pei.User, pei.Host,\n pei.password_lifetime,\n FROM_UNIXTIME(pei.password_last_changed) AS password_last_changed_datetime,\n 0 AS password_expiration_datetime\n FROM password_expiration_info pei\n WHERE pei.password_lifetime = 0\n OR pei.password_last_changed IS NULL;\n\n--connect-expired-password Client Option\n----------------------------------------\n\nThe mysql client --connect-expired-password option notifies the server that\nthe client is prepared to handle expired password sandbox mode (even if the\n--batch option was specified).\n\nURL: https://mariadb.com/kb/en/user-password-expiry/','','https://mariadb.com/kb/en/user-password-expiry/'),(193,'COLLATION',17,'Syntax\n------\n\nCOLLATION(str)\n\nDescription\n-----------\n\nReturns the collation of the string argument. If str is not a string, it is\nconsidered as a binary string (so the function returns \'binary\'). This applies\nto NULL, too. The return value is a string in the utf8 character set.\n\nSee Character Sets and Collations.\n\nExamples\n--------\n\nSELECT COLLATION(\'abc\');\n+-------------------+\n| COLLATION(\'abc\')  |\n+-------------------+\n| latin1_swedish_ci |\n+-------------------+\n\nSELECT COLLATION(_utf8\'abc\');\n+-----------------------+\n| COLLATION(_utf8\'abc\') |\n+-----------------------+\n| utf8_general_ci       |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/collation/','','https://mariadb.com/kb/en/collation/'),(194,'CONNECTION_ID',17,'Syntax\n------\n\nCONNECTION_ID()\n\nDescription\n-----------\n\nReturns the connection ID for the connection. Every connection (including\nevents) has an ID that is unique among the set of currently connected clients.\n\nUntil MariaDB 10.3.1, returns MYSQL_TYPE_LONGLONG, or bigint(10), in all\ncases. From MariaDB 10.3.1, returns MYSQL_TYPE_LONG, or int(10), when the\nresult would fit within 32-bits.\n\nExamples\n--------\n\nSELECT CONNECTION_ID();\n+-----------------+\n| CONNECTION_ID() |\n+-----------------+\n|               3 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/connection_id/','','https://mariadb.com/kb/en/connection_id/'),(123,'UNCOMPRESS',12,'Syntax\n------\n\nUNCOMPRESS(string_to_uncompress)\n\nDescription\n-----------\n\nUncompresses a string compressed by the COMPRESS() function. If the argument\nis not a compressed value, the result is NULL. This function requires MariaDB\nto have been compiled with a compression library such as zlib. Otherwise, the\nreturn value is always NULL. The have_compress server system variable\nindicates whether a compression library is present.\n\nExamples\n--------\n\nSELECT UNCOMPRESS(COMPRESS(\'a string\'));\n+----------------------------------+\n| UNCOMPRESS(COMPRESS(\'a string\')) |\n+----------------------------------+\n| a string                         |\n+----------------------------------+\n\nSELECT UNCOMPRESS(\'a string\');\n+------------------------+\n| UNCOMPRESS(\'a string\') |\n+------------------------+\n| NULL                   |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/uncompress/','','https://mariadb.com/kb/en/uncompress/'),(124,'DECODE',12,'Syntax\n------\n\nDECODE(crypt_str,pass_str)\n\nIn Oracle mode from MariaDB 10.3.2:\n\nDECODE(expr, search_expr, result_expr [, search_expr2, result_expr2 ...]\n[default_expr])\n\nIn all modes from MariaDB 10.3.2:\n\nDECODE_ORACLE(expr, search_expr, result_expr [, search_expr2, result_expr2\n...] [default_expr])\n\nDescription\n-----------\n\nIn the default mode, DECODE decrypts the encrypted string crypt_str using\npass_str as the password. crypt_str should be a string returned from ENCODE().\nThe resulting string will be the original string only if pass_str is the same.\n\nIn Oracle mode from MariaDB 10.3.2, DECODE compares expr to the search\nexpressions, in order. If it finds a match, the corresponding result\nexpression is returned. If no matches are found, the default expression is\nreturned, or NULL if no default is provided.\n\nNULLs are treated as equivalent.\n\nDECODE_ORACLE is a synonym for the Oracle-mode version of the function, and is\navailable in all modes.\n\nExamples\n--------\n\nFrom MariaDB 10.3.2:\n\nSELECT DECODE_ORACLE(2+1,3*1,\'found1\',3*2,\'found2\',\'default\');\n+--------------------------------------------------------+\n| DECODE_ORACLE(2+1,3*1,\'found1\',3*2,\'found2\',\'default\') |\n+--------------------------------------------------------+\n| found1                                                 |\n+--------------------------------------------------------+\n\nSELECT DECODE_ORACLE(2+4,3*1,\'found1\',3*2,\'found2\',\'default\');\n+--------------------------------------------------------+\n| DECODE_ORACLE(2+4,3*1,\'found1\',3*2,\'found2\',\'default\') |\n+--------------------------------------------------------+\n| found2                                                 |\n+--------------------------------------------------------+\n\nSELECT DECODE_ORACLE(2+2,3*1,\'found1\',3*2,\'found2\',\'default\');\n+--------------------------------------------------------+\n| DECODE_ORACLE(2+2,3*1,\'found1\',3*2,\'found2\',\'default\') |\n+--------------------------------------------------------+\n| default                                                |\n+--------------------------------------------------------+\n\nNulls are treated as equivalent:\n\nSELECT DECODE_ORACLE(NULL,NULL,\'Nulls are equivalent\',\'Nulls are not\nequivalent\');\n+----------------------------------------------------------------------------+\n| DECODE_ORACLE(NULL,NULL,\'Nulls are equivalent\',\'Nulls are not equivalent\') |\n+----------------------------------------------------------------------------+\n| Nulls are equivalent                                                       |\n+----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/decode/','','https://mariadb.com/kb/en/decode/'),(127,'AES_ENCRYPT',12,'Syntax\n------\n\nAES_ENCRYPT(str,key_str)\n\nDescription\n-----------\n\nAES_ENCRYPT() and AES_DECRYPT() allow encryption and decryption of data using\nthe official AES (Advanced Encryption Standard) algorithm, previously known as\n\"Rijndael.\" Encoding with a 128-bit key length is used, but you can extend it\nup to 256 bits by modifying the source. We chose 128 bits because it is much\nfaster and it is secure enough for most purposes.\n\nAES_ENCRYPT() encrypts a string str using the key key_str, and returns a\nbinary string.\n\nAES_DECRYPT() decrypts the encrypted string and returns the original string.\n\nThe input arguments may be any length. If either argument is NULL, the result\nof this function is also NULL.\n\nBecause AES is a block-level algorithm, padding is used to encode uneven\nlength strings and so the result string length may be calculated using this\nformula:\n\n16 x (trunc(string_length / 16) + 1)\n\nIf AES_DECRYPT() detects invalid data or incorrect padding, it returns NULL.\nHowever, it is possible for AES_DECRYPT() to return a non-NULL value (possibly\ngarbage) if the input data or the key is invalid.\n\nExamples\n--------\n\nINSERT INTO t VALUES (AES_ENCRYPT(\'text\',SHA2(\'password\',512)));\n\nURL: https://mariadb.com/kb/en/aes_encrypt/','','https://mariadb.com/kb/en/aes_encrypt/'),(205,'SCHEMA',17,'Syntax\n------\n\nSCHEMA()\n\nDescription\n-----------\n\nThis function is a synonym for DATABASE().\n\nURL: https://mariadb.com/kb/en/schema/','','https://mariadb.com/kb/en/schema/'),(206,'SESSION_USER',17,'Syntax\n------\n\nSESSION_USER()\n\nDescription\n-----------\n\nSESSION_USER() is a synonym for USER().\n\nURL: https://mariadb.com/kb/en/session_user/','','https://mariadb.com/kb/en/session_user/'),(207,'SYSTEM_USER',17,'Syntax\n------\n\nSYSTEM_USER()\n\nDescription\n-----------\n\nSYSTEM_USER() is a synonym for USER().\n\nURL: https://mariadb.com/kb/en/system_user/','','https://mariadb.com/kb/en/system_user/'),(210,'Assignment Operator (:=)',18,'Syntax\n------\n\nvar_name := expr\n\nDescription\n-----------\n\nAssignment operator for assigning a value. The value on the right is assigned\nto the variable on left.\n\nUnlike the = operator, := can always be used to assign a value to a variable.\n\nThis operator works with both user-defined variables and local variables.\n\nWhen assigning the same value to several variables, LAST_VALUE() can be useful.\n\nExamples\n--------\n\nSELECT @x := 10;\n+----------+\n| @x := 10 |\n+----------+\n|       10 |\n+----------+\n\nSELECT @x, @y := @x;\n+------+----------+\n| @x   | @y := @x |\n+------+----------+\n|   10 |       10 |\n+------+----------+\n\nURL: https://mariadb.com/kb/en/assignment-operator/','','https://mariadb.com/kb/en/assignment-operator/'),(221,'GREATEST',19,'Syntax\n------\n\nGREATEST(value1,value2,...)\n\nDescription\n-----------\n\nWith two or more arguments, returns the largest (maximum-valued) argument. The\narguments are compared using the same rules as for LEAST().\n\nExamples\n--------\n\nSELECT GREATEST(2,0);\n+---------------+\n| GREATEST(2,0) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT GREATEST(34.0,3.0,5.0,767.0);\n+------------------------------+\n| GREATEST(34.0,3.0,5.0,767.0) |\n+------------------------------+\n|                        767.0 |\n+------------------------------+\n\nSELECT GREATEST(\'B\',\'A\',\'C\');\n+-----------------------+\n| GREATEST(\'B\',\'A\',\'C\') |\n+-----------------------+\n| C                     |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/greatest/','','https://mariadb.com/kb/en/greatest/'),(226,'IS NOT NULL',19,'Syntax\n------\n\nIS NOT NULL\n\nDescription\n-----------\n\nTests whether a value is not NULL. See also NULL Values in MariaDB.\n\nExamples\n--------\n\nSELECT 1 IS NOT NULL, 0 IS NOT NULL, NULL IS NOT NULL;\n+---------------+---------------+------------------+\n| 1 IS NOT NULL | 0 IS NOT NULL | NULL IS NOT NULL |\n+---------------+---------------+------------------+\n|             1 |             1 |                0 |\n+---------------+---------------+------------------+\n\nURL: https://mariadb.com/kb/en/is-not-null/','','https://mariadb.com/kb/en/is-not-null/'),(128,'COMPRESS',12,'Syntax\n------\n\nCOMPRESS(string_to_compress)\n\nDescription\n-----------\n\nCompresses a string and returns the result as a binary string. This function\nrequires MariaDB to have been compiled with a compression library such as\nzlib. Otherwise, the return value is always NULL. The compressed string can be\nuncompressed with UNCOMPRESS().\n\nThe have_compress server system variable indicates whether a compression\nlibrary is present.\n\nExamples\n--------\n\nSELECT LENGTH(COMPRESS(REPEAT(\'a\',1000)));\n+------------------------------------+\n| LENGTH(COMPRESS(REPEAT(\'a\',1000))) |\n+------------------------------------+\n|                                 21 |\n+------------------------------------+\n\nSELECT LENGTH(COMPRESS(\'\'));\n+----------------------+\n| LENGTH(COMPRESS(\'\')) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSELECT LENGTH(COMPRESS(\'a\'));\n+-----------------------+\n| LENGTH(COMPRESS(\'a\')) |\n+-----------------------+\n|                    13 |\n+-----------------------+\n\nSELECT LENGTH(COMPRESS(REPEAT(\'a\',16)));\n+----------------------------------+\n| LENGTH(COMPRESS(REPEAT(\'a\',16))) |\n+----------------------------------+\n|                               15 |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/compress/','','https://mariadb.com/kb/en/compress/'),(129,'DES_DECRYPT',12,'DES_DECRYPT has been deprecated from MariaDB 10.10.0, and will be removed in a\nfuture release.\n\nSyntax\n------\n\nDES_DECRYPT(crypt_str[,key_str])\n\nDescription\n-----------\n\nDecrypts a string encrypted with DES_ENCRYPT(). If an error occurs, this\nfunction returns NULL.\n\nThis function works only if MariaDB has been configured with TLS support.\n\nIf no key_str argument is given, DES_DECRYPT() examines the first byte of the\nencrypted string to determine the DES key number that was used to encrypt the\noriginal string, and then reads the key from the DES key file to decrypt the\nmessage. For this to work, the user must have the SUPER privilege. The key\nfile can be specified with the --des-key-file server option.\n\nIf you pass this function a key_str argument, that string is used as the key\nfor decrypting the message.\n\nIf the crypt_str argument does not appear to be an encrypted string, MariaDB\nreturns the given crypt_str.\n\nURL: https://mariadb.com/kb/en/des_decrypt/','','https://mariadb.com/kb/en/des_decrypt/'),(130,'DES_ENCRYPT',12,'DES_ENCRYPT has been deprecated from MariaDB 10.10.0, and will be removed in a\nfuture release.\n\nSyntax\n------\n\nDES_ENCRYPT(str[,{key_num|key_str}])\n\nDescription\n-----------\n\nEncrypts the string with the given key using the Triple-DES algorithm.\n\nThis function works only if MariaDB has been configured with TLS support.\n\nThe encryption key to use is chosen based on the second argument to\nDES_ENCRYPT(), if one was given. With no argument, the first key from the DES\nkey file is used. With a key_num argument, the given key number (0-9) from the\nDES key file is used. With a key_str argument, the given key string is used to\nencrypt str.\n\nThe key file can be specified with the --des-key-file server option.\n\nThe return string is a binary string where the first character is CHAR(128 |\nkey_num). If an error occurs, DES_ENCRYPT() returns NULL.\n\nThe 128 is added to make it easier to recognize an encrypted key. If you use a\nstring key, key_num is 127.\n\nThe string length for the result is given by this formula:\n\nnew_len = orig_len + (8 - (orig_len % 8)) + 1\n\nEach line in the DES key file has the following format:\n\nkey_num des_key_str\n\nEach key_num value must be a number in the range from 0 to 9. Lines in the\nfile may be in any order. des_key_str is the string that is used to encrypt\nthe message. There should be at least one space between the number and the\nkey. The first key is the default key that is used if you do not specify any\nkey argument to DES_ENCRYPT().\n\nYou can tell MariaDB to read new key values from the key file with the FLUSH\nDES_KEY_FILE statement. This requires the RELOAD privilege.\n\nOne benefit of having a set of default keys is that it gives applications a\nway to check for the existence of encrypted column values, without giving the\nend user the right to decrypt those values.\n\nExamples\n--------\n\nSELECT customer_address FROM customer_table \n WHERE crypted_credit_card = DES_ENCRYPT(\'credit_card_number\');\n\nURL: https://mariadb.com/kb/en/des_encrypt/','','https://mariadb.com/kb/en/des_encrypt/'),(131,'ENCODE',12,'Syntax\n------\n\nENCODE(str,pass_str)\n\nDescription\n-----------\n\nENCODE is not considered cryptographically secure, and should not be used for\npassword encryption.\n\nEncrypt str using pass_str as the password. To decrypt the result, use\nDECODE().\n\nThe result is a binary string of the same length as str.\n\nThe strength of the encryption is based on how good the random generator is.\n\nIt is not recommended to rely on the encryption performed by the ENCODE\nfunction. Using a salt value (changed when a password is updated) will improve\nmatters somewhat, but for storing passwords, consider a more cryptographically\nsecure function, such as SHA2().\n\nExamples\n--------\n\nENCODE(\'not so secret text\', CONCAT(\'random_salt\',\'password\'))\n\nURL: https://mariadb.com/kb/en/encode/','','https://mariadb.com/kb/en/encode/'),(228,'ISNULL',19,'Syntax\n------\n\nISNULL(expr)\n\nDescription\n-----------\n\nIf expr is NULL, ISNULL() returns 1, otherwise it returns 0.\n\nSee also NULL Values in MariaDB.\n\nExamples\n--------\n\nSELECT ISNULL(1+1);\n+-------------+\n| ISNULL(1+1) |\n+-------------+\n|           0 |\n+-------------+\n\nSELECT ISNULL(1/0);\n+-------------+\n| ISNULL(1/0) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/isnull/','','https://mariadb.com/kb/en/isnull/'),(232,'&',20,'Syntax\n------\n\n&\n\nDescription\n-----------\n\nBitwise AND. Converts the values to binary and compares bits. Only if both the\ncorresponding bits are 1 is the resulting bit also 1.\n\nSee also bitwise OR.\n\nExamples\n--------\n\nSELECT 2&1;\n+-----+\n| 2&1 |\n+-----+\n|   0 |\n+-----+\n\nSELECT 3&1;\n+-----+\n| 3&1 |\n+-----+\n|   1 |\n+-----+\n\nSELECT 29 & 15;\n+---------+\n| 29 & 15 |\n+---------+\n|      13 |\n+---------+\n\nURL: https://mariadb.com/kb/en/bitwise_and/','','https://mariadb.com/kb/en/bitwise_and/'),(233,'<<',20,'Syntax\n------\n\nvalue1 << value2\n\nDescription\n-----------\n\nConverts a longlong (BIGINT) number (value1) to binary and shifts value2 units\nto the left.\n\nExamples\n--------\n\nSELECT 1 << 2;\n+--------+\n| 1 << 2 |\n+--------+\n|      4 |\n+--------+\n\nURL: https://mariadb.com/kb/en/shift-left/','','https://mariadb.com/kb/en/shift-left/'),(234,'>>',20,'Syntax\n------\n\nvalue1 >> value2\n\nDescription\n-----------\n\nConverts a longlong (BIGINT) number (value1) to binary and shifts value2 units\nto the right.\n\nExamples\n--------\n\nSELECT 4 >> 2;\n+--------+\n| 4 >> 2 |\n+--------+\n|      1 |\n+--------+\n\nURL: https://mariadb.com/kb/en/shift-right/','','https://mariadb.com/kb/en/shift-right/'),(235,'BIT_COUNT',20,'Syntax\n------\n\nBIT_COUNT(N)\n\nDescription\n-----------\n\nReturns the number of bits that are set in the argument N.\n\nExamples\n--------\n\nSELECT BIT_COUNT(29), BIT_COUNT(b\'101010\');\n+---------------+----------------------+\n| BIT_COUNT(29) | BIT_COUNT(b\'101010\') |\n+---------------+----------------------+\n|             4 |                    3 |\n+---------------+----------------------+\n\nURL: https://mariadb.com/kb/en/bit_count/','','https://mariadb.com/kb/en/bit_count/'),(132,'ENCRYPT',12,'Syntax\n------\n\nENCRYPT(str[,salt])\n\nDescription\n-----------\n\nEncrypts a string using the Unix crypt() system call, returning an encrypted\nbinary string. The salt argument should be a string with at least two\ncharacters or the returned result will be NULL. If no salt argument is given,\na random value of sufficient length is used.\n\nIt is not recommended to use ENCRYPT() with utf16, utf32 or ucs2 multi-byte\ncharacter sets because the crypt() system call expects a string terminated\nwith a zero byte.\n\nNote that the underlying crypt() system call may have some limitations, such\nas ignoring all but the first eight characters.\n\nIf the have_crypt system variable is set to NO (because the crypt() system\ncall is not available), the ENCRYPT function will always return NULL.\n\nExamples\n--------\n\nSELECT ENCRYPT(\'encrypt me\');\n+-----------------------+\n| ENCRYPT(\'encrypt me\') |\n+-----------------------+\n| 4I5BsEx0lqTDk         |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/encrypt/','','https://mariadb.com/kb/en/encrypt/'),(134,'OLD_PASSWORD',12,'Syntax\n------\n\nOLD_PASSWORD(str)\n\nDescription\n-----------\n\nOLD_PASSWORD() was added to MySQL when the implementation of PASSWORD() was\nchanged to improve security. OLD_PASSWORD() returns the value of the old\n(pre-MySQL 4.1) implementation of PASSWORD() as a string, and is intended to\npermit you to reset passwords for any pre-4.1 clients that need to connect to\na more recent MySQL server version, or any version of MariaDB, without locking\nthem out.\n\nAs of MariaDB 5.5, the return value is a nonbinary string in the connection\ncharacter set and collation, determined by the values of the\ncharacter_set_connection and collation_connection system variables. Before\n5.5, the return value was a binary string.\n\nThe return value is 16 bytes in length, or NULL if the argument was NULL.\n\nURL: https://mariadb.com/kb/en/old_password/','','https://mariadb.com/kb/en/old_password/'),(135,'PASSWORD',12,'Syntax\n------\n\nPASSWORD(str)\n\nDescription\n-----------\n\nThe PASSWORD() function is used for hashing passwords for use in\nauthentication by the MariaDB server. It is not intended for use in other\napplications.\n\nCalculates and returns a hashed password string from the plaintext password\nstr. Returns an empty string (>= MariaDB 10.0.4) if the argument was NULL.\n\nThe return value is a nonbinary string in the connection character set and\ncollation, determined by the values of the character_set_connection and\ncollation_connection system variables.\n\nThis is the function that is used for hashing MariaDB passwords for storage in\nthe Password column of the user table (see privileges), usually used with the\nSET PASSWORD statement. It is not intended for use in other applications.\n\nUntil MariaDB 10.3, the return value is 41-bytes in length, and the first\ncharacter is always \'*\'. From MariaDB 10.4, the function takes into account\nthe authentication plugin where applicable (A CREATE USER or SET PASSWORD\nstatement). For example, when used in conjunction with a user authenticated by\nthe ed25519 plugin, the statement will create a longer hash:\n\nCREATE USER edtest@localhost IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nCREATE USER edtest2@localhost IDENTIFIED BY \'secret\';\n\nSELECT CONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv)) FROM\nmysql.global_priv\n WHERE user LIKE \'edtest%\'\\G\n*************************** 1. row ***************************\nCONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv)): edtest@localhost => {\n...\n  \"plugin\": \"ed25519\",\n  \"authentication_string\": \"ZIgUREUg5PVgQ6LskhXmO+eZLS0nC8be6HPjYWR4YJY\",\n...\n}\n*************************** 2. row ***************************\nCONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv)): edtest2@localhost => {\n...\n  \"plugin\": \"mysql_native_password\",\n  \"authentication_string\": \"*14E65567ABDB5135D0CFD9A70B3032C179A49EE7\",\n...\n}\n\nThe behavior of this function is affected by the value of the old_passwords\nsystem variable. If this is set to 1 (0 is default), MariaDB reverts to using\nthe mysql_old_password authentication plugin by default for newly created\nusers and passwords.\n\nExamples\n--------\n\nSELECT PASSWORD(\'notagoodpwd\');\n+-------------------------------------------+\n| PASSWORD(\'notagoodpwd\')                   |\n+-------------------------------------------+\n| *3A70EE9FC6594F88CE9E959CD51C5A1C002DC937 |\n+-------------------------------------------+\n\nSET PASSWORD FOR \'bob\'@\'%.loc.gov\' = PASSWORD(\'newpass\');\n\nURL: https://mariadb.com/kb/en/password/','','https://mariadb.com/kb/en/password/'),(136,'SHA1',12,'Syntax\n------\n\nSHA1(str), SHA(str)\n\nDescription\n-----------\n\nCalculates an SHA-1 160-bit checksum for the string str, as described in RFC\n3174 (Secure Hash Algorithm).\n\nThe value is returned as a string of 40 hex digits, or NULL if the argument\nwas NULL. As of MariaDB 5.5, the return value is a nonbinary string in the\nconnection character set and collation, determined by the values of the\ncharacter_set_connection and collation_connection system variables. Before\n5.5, the return value was a binary string.\n\nExamples\n--------\n\nSELECT SHA1(\'some boring text\');\n+------------------------------------------+\n| SHA1(\'some boring text\')                 |\n+------------------------------------------+\n| af969fc2085b1bb6d31e517d5c456def5cdd7093 |\n+------------------------------------------+\n\nURL: https://mariadb.com/kb/en/sha1/','','https://mariadb.com/kb/en/sha1/'),(236,'^',20,'Syntax\n------\n\n^\n\nDescription\n-----------\n\nBitwise XOR. Converts the values to binary and compares bits. If one (and only\none) of the corresponding bits is 1 is the resulting bit also 1.\n\nExamples\n--------\n\nSELECT 1 ^ 1;\n+-------+\n| 1 ^ 1 |\n+-------+\n|     0 |\n+-------+\n\nSELECT 1 ^ 0;\n+-------+\n| 1 ^ 0 |\n+-------+\n|     1 |\n+-------+\n\nSELECT 11 ^ 3;\n+--------+\n| 11 ^ 3 |\n+--------+\n|      8 |\n+--------+\n\nURL: https://mariadb.com/kb/en/bitwise-xor/','','https://mariadb.com/kb/en/bitwise-xor/'),(237,'|',20,'Syntax\n------\n\n|\n\nDescription\n-----------\n\nBitwise OR. Converts the values to binary and compares bits. If either of the\ncorresponding bits has a value of 1, the resulting bit is also 1.\n\nSee also bitwise AND.\n\nExamples\n--------\n\nSELECT 2|1;\n+-----+\n| 2|1 |\n+-----+\n|   3 |\n+-----+\n\nSELECT 29 | 15;\n+---------+\n| 29 | 15 |\n+---------+\n|      31 |\n+---------+\n\nURL: https://mariadb.com/kb/en/bitwise-or/','','https://mariadb.com/kb/en/bitwise-or/'),(238,'~',20,'Syntax\n------\n\n~\n\nDescription\n-----------\n\nBitwise NOT. Converts the value to 4 bytes binary and inverts all bits.\n\nExamples\n--------\n\nSELECT 3 & ~1;\n+--------+\n| 3 & ~1 |\n+--------+\n|      2 |\n+--------+\n\nSELECT 5 & ~1;\n+--------+\n| 5 & ~1 |\n+--------+\n|      4 |\n+--------+\n\nURL: https://mariadb.com/kb/en/bitwise-not/','','https://mariadb.com/kb/en/bitwise-not/'),(240,'TRUE FALSE',20,'Description\n-----------\n\nThe constants TRUE and FALSE evaluate to 1 and 0, respectively. The constant\nnames can be written in any lettercase.\n\nExamples\n--------\n\nSELECT TRUE, true, FALSE, false;\n+------+------+-------+-------+\n| TRUE | TRUE | FALSE | FALSE |\n+------+------+-------+-------+\n|    1 |    1 |     0 |     0 |\n+------+------+-------+-------+\n\nURL: https://mariadb.com/kb/en/true-false/','','https://mariadb.com/kb/en/true-false/'),(243,'CHECK VIEW',21,'Syntax\n------\n\nCHECK VIEW view_name\n\nDescription\n-----------\n\nThe CHECK VIEW statement was introduced in MariaDB 10.0.18 to assist with\nfixing MDEV-6916, an issue introduced in MariaDB 5.2 where the view algorithms\nwere swapped. It checks whether the view algorithm is correct. It is run as\npart of mysql_upgrade, and should not normally be required in regular use.\n\nURL: https://mariadb.com/kb/en/check-view/','','https://mariadb.com/kb/en/check-view/'),(137,'SHA2',12,'Syntax\n------\n\nSHA2(str,hash_len)\n\nDescription\n-----------\n\nGiven a string str, calculates an SHA-2 checksum, which is considered more\ncryptographically secure than its SHA-1 equivalent. The SHA-2 family includes\nSHA-224, SHA-256, SHA-384, and SHA-512, and the hash_len must correspond to\none of these, i.e. 224, 256, 384 or 512. 0 is equivalent to 256.\n\nThe return value is a nonbinary string in the connection character set and\ncollation, determined by the values of the character_set_connection and\ncollation_connection system variables.\n\nNULL is returned if the hash length is not valid, or the string str is NULL.\n\nSHA2 will only work if MariaDB was has been configured with TLS support.\n\nExamples\n--------\n\nSELECT SHA2(\'Maria\',224);\n+----------------------------------------------------------+\n| SHA2(\'Maria\',224)                                        |\n+----------------------------------------------------------+\n| 6cc67add32286412efcab9d0e1675a43a5c2ef3cec8879f81516ff83 |\n+----------------------------------------------------------+\n\nSELECT SHA2(\'Maria\',256);\n+------------------------------------------------------------------+\n| SHA2(\'Maria\',256)                                                |\n+------------------------------------------------------------------+\n| 9ff18ebe7449349f358e3af0b57cf7a032c1c6b2272cb2656ff85eb112232f16 |\n+------------------------------------------------------------------+\n\nSELECT SHA2(\'Maria\',0);\n+------------------------------------------------------------------+\n| SHA2(\'Maria\',0)                                                  |\n+------------------------------------------------------------------+\n| 9ff18ebe7449349f358e3af0b57cf7a032c1c6b2272cb2656ff85eb112232f16 |\n+------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/sha2/','','https://mariadb.com/kb/en/sha2/'),(148,'INET6_ATON',14,'Syntax\n------\n\nINET6_ATON(expr)\n\nDescription\n-----------\n\nGiven an IPv6 or IPv4 network address as a string, returns a binary string\nthat represents the numeric value of the address.\n\nNo trailing zone ID\'s or traling network masks are permitted. For IPv4\naddresses, or IPv6 addresses with IPv4 address parts, no classful addresses or\ntrailing port numbers are permitted and octal numbers are not supported.\n\nThe returned binary string will be VARBINARY(16) or VARBINARY(4) for IPv6 and\nIPv4 addresses respectively.\n\nReturns NULL if the argument is not understood.\n\nMariaDB starting with 10.5.0\n----------------------------\nFrom MariaDB 10.5.0, INET6_ATON can take INET6 as an argument.\n\nExamples\n--------\n\nSELECT HEX(INET6_ATON(\'10.0.1.1\'));\n+-----------------------------+\n| HEX(INET6_ATON(\'10.0.1.1\')) |\n+-----------------------------+\n| 0A000101                    |\n+-----------------------------+\n\nSELECT HEX(INET6_ATON(\'48f3::d432:1431:ba23:846f\'));\n+----------------------------------------------+\n| HEX(INET6_ATON(\'48f3::d432:1431:ba23:846f\')) |\n+----------------------------------------------+\n| 48F3000000000000D4321431BA23846F             |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/inet6_aton/','','https://mariadb.com/kb/en/inet6_aton/'),(149,'INET6_NTOA',14,'Syntax\n------\n\nINET6_NTOA(expr)\n\nDescription\n-----------\n\nGiven an IPv6 or IPv4 network address as a numeric binary string, returns the\naddress as a nonbinary string in the connection character set.\n\nThe return string is lowercase, and is platform independent, since it does not\nuse functions specific to the operating system. It has a maximum length of 39\ncharacters.\n\nReturns NULL if the argument is not understood.\n\nExamples\n--------\n\nSELECT INET6_NTOA(UNHEX(\'0A000101\'));\n+-------------------------------+\n| INET6_NTOA(UNHEX(\'0A000101\')) |\n+-------------------------------+\n| 10.0.1.1                      |\n+-------------------------------+\n\nSELECT INET6_NTOA(UNHEX(\'48F3000000000000D4321431BA23846F\'));\n+-------------------------------------------------------+\n| INET6_NTOA(UNHEX(\'48F3000000000000D4321431BA23846F\')) |\n+-------------------------------------------------------+\n| 48f3::d432:1431:ba23:846f                             |\n+-------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/inet6_ntoa/','','https://mariadb.com/kb/en/inet6_ntoa/'),(153,'IS_IPV4',14,'Syntax\n------\n\nIS_IPV4(expr)\n\nDescription\n-----------\n\nIf the expression is a valid IPv4 address, returns 1, otherwise returns 0.\n\nIS_IPV4() is stricter than INET_ATON(), but as strict as INET6_ATON(), in\ndetermining the validity of an IPv4 address. This implies that if IS_IPV4\nreturns 1, the same expression will always return a non-NULL result when\npassed to INET_ATON(), but that the reverse may not apply.\n\nExamples\n--------\n\nSELECT IS_IPV4(\'1110.0.1.1\');\n+-----------------------+\n| IS_IPV4(\'1110.0.1.1\') |\n+-----------------------+\n|                     0 |\n+-----------------------+\n\nSELECT IS_IPV4(\'48f3::d432:1431:ba23:846f\');\n+--------------------------------------+\n| IS_IPV4(\'48f3::d432:1431:ba23:846f\') |\n+--------------------------------------+\n|                                    0 |\n+--------------------------------------+\n\nURL: https://mariadb.com/kb/en/is_ipv4/','','https://mariadb.com/kb/en/is_ipv4/'),(270,'CHAR BYTE',23,'Description\n-----------\n\nThe CHAR BYTE data type is an alias for the BINARY data type. This is a\ncompatibility feature.\n\nURL: https://mariadb.com/kb/en/char-byte/','','https://mariadb.com/kb/en/char-byte/'),(272,'INET6',23,'MariaDB starting with 10.5.0\n----------------------------\nThe INET6 data type was added in MariaDB 10.5.0\n\nSyntax\n------\n\nINET6\n\nDescription\n-----------\n\nThe INET6 data type is intended for storage of IPv6 addresses, as well as IPv4\naddresses assuming conventional mapping of IPv4 addresses into IPv6 addresses.\n\nBoth short and long IPv6 notation are permitted, according to RFC-5952.\n\n* Values are stored as a 16-byte fixed length binary string, with most\nsignificant byte first.\n* Storage engines see INET6 as BINARY(16).\n* Clients see INET6 as CHAR(39) and get text representation on retrieval.\n\nThe IPv4-compatible notation is considered as deprecated. It is supported for\ncompatibility with the INET6_ATON function, which also understands this\nformat. It\'s recommended to use the mapped format to store IPv4 addresses in\nINET6.\n\nWhen an IPv4 mapped (or compatible) value is stored in INET6, it still\noccupies 16 bytes:\n\nRetrieval\n---------\n\nOn retrieval, in the client-server text protocol, INET6 values are converted\nto the short text representation, according to RFC-5952, that is with all\nleading zeroes in each group removed and with consequent zero groups\ncompressed.\n\nBesides creating one\'s own stored function, there is no a way to retrieve an\nINET6 value using long text representation.\n\nCasting\n-------\n\n* CAST from a character string to INET6 understands addresses in short or long\ntext notation (including IPv4 mapped and compatible addresses). NULL is\nreturned if the format is not understood.\n* CAST from a binary string to INET6 requires a 16-byte string as an argument.\nNULL is returned if the argument length is not equal to 16.\n* CAST from other data types to INET6 first converts data to a character\nstring, then CAST from character string to INET6 is applied.\n* CAST from INET6 to CHAR returns short text address notation.\n* CAST from INET6 to BINARY returns its 16-byte binary string representation.\n* CAST from INET6 to data types other than CHAR (e.g. SIGNED, UNSIGNED, TIME,\netc) returns an error.\n\nComparisons\n-----------\n\nAn INET6 expression can be compared to:\n\n* another INET6 expression\n* a character string expression with a text (short or long) address\nrepresentation:\n* a 16-byte binary string expression:\n\nAttempting to compare INET6 to an expression of any other data type returns an\nerror.\n\nMixing INET6 Values for Result\n------------------------------\n\nAn INET6 expression can be mixed for result (i.e. UNION, CASE..THEN, COALESCE\netc) with:\n\n* another INET6 expression. The resulting data type is INET6.\n* a character string in text (short or long) address representation. The\nresult data type is INET6. The character string counterpart is automatically\nconverted to INET6. If the string format is not understood, it\'s converted\nwith a warning to either NULL or to \'::\', depending on the NULL-ability of the\nresult.\n* a 16-byte binary string. The resulting data type is INET6. The binary string\ncounterpart is automatically converted to INET6. If the length of the binary\nstring is not equal to 16, it\'s converted with a warning to NULL or to \'::\'\ndepending on the NULL-ability of the result.\n\nAttempts to mix INET6 for result with other data types will return an error.\n\nMixing INET6 with other data types for LEAST and GREATEST, when mixing for\ncomparison and mixing for result are involved at the same time, uses the same\nrules with mixing for result, described in the previous paragraphs.\n\nFunctions and Operators\n-----------------------\n\n* HEX() with an INET6 argument returns a hexadecimal representation of the\nunderlying 16-byte binary string\n* Arithmetic operators (+,-,*,/,MOD,DIV) are not supported for INET6. This may\nchange in the future.\n* The INET6_ATON function now understands INET6 values as an argument\n* The prototypes of the IS_IPV4_COMPAT and IS_IPV4_MAPPED functions have\nchanged from a BINARY(16) to a INET6,\n* When the argument for these two functions is not INET6, automatic implicit\nCAST to INET6 is applied. As a consequence, both functions now understand\narguments in both text representation and binary(16) representation. Before\nMariaDB 10.5.0, these functions understood only binary(16) representation.\n\nPrepared Statement Parameters\n-----------------------------\n\nINET6 understands both text and binary(16) address representation in prepared\nstatement parameters (PREPARE..EXECUTE and EXECUTE IMMEDIATE statements).\n\nMigration between  BINARY(16) and INET6\n---------------------------------------\n\nBefore MariaDB 10.5.0, you may have used BINARY(16) as a storage for IPv6\ninternet addresses, in combination with INET6_ATON and INET6_NTOA to\nrespectively insert and retrieve data.\n\nFrom 10.5, you can ALTER BINARY(16) columns storing IPv6 addresses to INET6.\nAfter such an alter, there is no a need to use INET6_ATON() and INET6_NTOA().\nAddresses can be inserted and retrieved directly.\n\nIt is also possible to convert INET6 columns to BINARY(16) and continue using\nthe data in combination with INET6_NTOA() and INET6_ATON().\n\nExamples\n--------\n\nCREATE TABLE t1 (a INET6);\n\nInserting using short text address notation:\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n\nLong text address notation:\n\nINSERT INTO t1 VALUES (\'2001:0db8:0000:0000:0000:ff00:0042:8329\');\n\n16-byte binary string notation:\n\nINSERT INTO t1 VALUES (0x20010DB8000000000000FF0000428329);\nINSERT INTO t1 VALUES (UNHEX(\'20010DB8000000000000FF0000428329\'));\n\nIPv4 addresses, using IPv4-mapped and IPv4-compatible notations:\n\nINSERT INTO t1 VALUES (\'::ffff:192.0.2.128\'); -- mapped\nINSERT INTO t1 VALUES (\'::192.0.2.128\'); -- compatible\n\nSELECT * FROM t1;\n+------------------------+\n| a                      |\n+------------------------+\n| 2001:db8::ff00:42:8329 |\n| 2001:db8::ff00:42:8329 |\n| 2001:db8::ff00:42:8329 |\n| 2001:db8::ff00:42:8329 |\n| ::ffff:192.0.2.128     |\n| ::192.0.2.128          |\n+------------------------+\n\nIPv4 mapped (or compatible) values still occupy 16 bytes:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'::ffff:192.0.2.128\');\n\nSELECT * FROM t1;\n+--------------------+\n| a                  |\n+--------------------+\n| ::ffff:192.0.2.128 |\n+--------------------+\n\nSELECT HEX(a) FROM t1;\n+----------------------------------+\n| HEX(a)                           |\n+----------------------------------+\n| 00000000000000000000FFFFC0000280 |\n+----------------------------------+\n\nCasting from INET6 to anything other than CHAR returns an error:\n\nSELECT CAST(a AS DECIMAL) FROM t1;\n\nERROR 4079 (HY000): Illegal parameter data type inet6 for operation\n\'decimal_typecast\'\n\nComparison Examples\n-------------------\n\nComparison with another INET6 expression:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n  CREATE OR REPLACE TABLE t2 (a INET6);\n\nINSERT INTO t1 VALUES\n(\'2001:db8::ff00:42:8328\'),(\'2001:db8::ff00:42:8329\');\n  INSERT INTO t2 VALUES\n(\'2001:db8::ff00:42:832a\'),(\'2001:db8::ff00:42:8329\');\n\nSELECT t1.* FROM t1,t2 WHERE t1.a=t2.a;\n  +------------------------+\n  | a                      |\n  +------------------------+\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nWith a character string expression with a text (short or long) address\nrepresentation:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n\nSELECT * FROM t1 WHERE a=\'2001:db8::ff00:42:8329\';\n  +------------------------+\n  | a                      |\n  +------------------------+\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nWith a 16-byte binary string expression:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n\nSELECT * FROM t1 WHERE a=X\'20010DB8000000000000FF0000428329\';\n  +------------------------+\n  | a                      |\n  +------------------------+\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nWith an expression of another data type:\n\nSELECT * FROM t1 WHERE a=1;\nERROR 4078 (HY000): Illegal parameter data types inet6 and int for operation\n\'=\'\n\nMixing for Result Examples\n--------------------------\n\nMixed with another INET6 expression, returning an INET6 data type:\n\nCREATE OR REPLACE TABLE t1 (a INET6, b INET6);\n\nINSERT INTO t1 VALUES (NULL,\'2001:db8::ff00:42:8329\');\n\nSELECT a FROM t1 UNION SELECT b FROM t1;\n  +------------------------+\n  | a                      |\n  +------------------------+\n  | NULL                   |\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nSELECT COALESCE(a, b) FROM t1;\n  +------------------------+\n  | COALESCE(a, b)         |\n  +------------------------+\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nMixed with a character string in text (short or long) address representation:\n\nCREATE OR REPLACE TABLE t1 (a INET6, b VARCHAR(64));\n\nINSERT INTO t1 VALUES (NULL,\'2001:db8::ff00:42:8328\');\n\nINSERT INTO t1 VALUES (NULL,\'2001:db8::ff00:42:832a garbage\');\n\nSELECT COALESCE(a,b) FROM t1;\n  +------------------------+\n  | COALESCE(a,b)          |\n  +------------------------+\n  | 2001:db8::ff00:42:8328 |\n  | NULL                   |\n  +------------------------+\n  2 rows in set, 1 warning (0.001 sec)\n\nSHOW WARNINGS;\n\n+---------+------+---------------------------------------------------------+\n  | Level   | Code | Message\n|\n\n+---------+------+---------------------------------------------------------+\n  | Warning | 1292 | Incorrect inet6 value: \'2001:db8::ff00:42:832a garbage\'\n|\n\n+---------+------+---------------------------------------------------------+\n\nMixed with a 16-byte binary string:\n\nCREATE OR REPLACE TABLE t1 (a INET6, b VARBINARY(16));\n\nINSERT INTO t1 VALUES (NULL,CONCAT(0xFFFF,REPEAT(0x0000,6),0xFFFF));\n\nINSERT INTO t1 VALUES (NULL,0x00/*garbage*/);\n\nSELECT COALESCE(a,b) FROM t1;\n  +---------------+\n  | COALESCE(a,b) |\n  +---------------+\n  | ffff::ffff    |\n  | NULL          |\n  +---------------+\n  2 rows in set, 1 warning (0.001 sec)\n\nSHOW WARNINGS;\n  +---------+------+-------------------------------+\n  | Level   | Code | Message                       |\n  +---------+------+-------------------------------+\n  | Warning | 1292 | Incorrect inet6 value: \'\\x00\' |\n  +---------+------+-------------------------------+\n\nMixing with other data types:\n\nSELECT CAST(\'ffff::ffff\' AS INET6) UNION SELECT 1;\nERROR 4078 (HY000): Illegal parameter data types inet6 and int for operation\n\'UNION\'\n\nFunctions and Operators Examples\n--------------------------------\n\nHEX with an INET6 argument returning a hexadecimal representation:\n\nSELECT HEX(CAST(\'2001:db8::ff00:42:8329\' AS INET6));\n  +----------------------------------------------+\n  | HEX(CAST(\'2001:db8::ff00:42:8329\' AS INET6)) |\n  +----------------------------------------------+\n  | 20010DB8000000000000FF0000428329             |\n  +----------------------------------------------+\n\nINET6_ATON now understands INET6 values as an argument:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n\nSELECT a, HEX(INET6_ATON(a)) FROM t1;\n  +------------------------+----------------------------------+\n  | a                      | HEX(INET6_ATON(a))               |\n  +------------------------+----------------------------------+\n  | 2001:db8::ff00:42:8329 | 20010DB8000000000000FF0000428329 |\n  +------------------------+----------------------------------+\n\nIS_IPV4_COMPAT and IS_IPV4_MAPPED prototype now a BINARY(16)):\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n  INSERT INTO t1 VALUES (\'::ffff:192.168.0.1\');\n  INSERT INTO t1 VALUES (\'::192.168.0.1\');\n\nSELECT a, IS_IPV4_MAPPED(a), IS_IPV4_COMPAT(a) FROM t1;\n  +------------------------+-------------------+-------------------+\n  | a                      | IS_IPV4_MAPPED(a) | IS_IPV4_COMPAT(a) |\n  +------------------------+-------------------+-------------------+\n  | 2001:db8::ff00:42:8329 |                 0 |                 0 |\n  | ::ffff:192.168.0.1     |                 1 |                 0 |\n  | ::192.168.0.1          |                 0 |                 1 |\n  +------------------------+-------------------+-------------------+\n\nAutomatic implicit CAST to INET6:\n\nCREATE OR REPLACE TABLE t1 (\n   a INET6,\n   b VARCHAR(39) DEFAULT a\n  );\n\nINSERT INTO t1 (a) VALUES (\'ffff::ffff\'),(\'::ffff:192.168.0.1\');\n\nSELECT a, IS_IPV4_MAPPED(a), b, IS_IPV4_MAPPED(b) FROM t1;\n\n+--------------------+-------------------+--------------------+----------------\n--+\n  | a                  | IS_IPV4_MAPPED(a) | b                  |\nIS_IPV4_MAPPED(b) |\n\n+--------------------+-------------------+--------------------+----------------\n--+\n  | ffff::ffff         |                 0 | ffff::ffff         |\n  0 |\n  | ::ffff:192.168.0.1 |                 1 | ::ffff:192.168.0.1 |\n  1 |\n\n+--------------------+-------------------+--------------------+----------------\n--+\n\nCREATE OR REPLACE TABLE t1 (\n   a INET6,\n   b BINARY(16) DEFAULT UNHEX(HEX(a))\n  );\n\nINSERT INTO t1 (a) VALUES (\'ffff::ffff\'),(\'::ffff:192.168.0.1\');\n\nSELECT a, IS_IPV4_MAPPED(a), HEX(b), IS_IPV4_MAPPED(b) FROM t1;\n\n+--------------------+-------------------+----------------------------------+--\n----------------+\n  | a                  | IS_IPV4_MAPPED(a) | HEX(b)\n | IS_IPV4_MAPPED(b) |\n\n+--------------------+-------------------+----------------------------------+--\n----------------+\n  | ffff::ffff         |                 0 |\nFFFF000000000000000000000000FFFF |                 0 |\n  | ::ffff:192.168.0.1 |                 1 |\n00000000000000000000FFFFC0A80001 |                 1 |\n\n+--------------------+-------------------+----------------------------------+--\n----------------+\n\nPrepared Statement Parameters Examples\n--------------------------------------\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nEXECUTE IMMEDIATE \'INSERT INTO t1 VALUES (?)\' USING \'ffff::fffe\';\nEXECUTE IMMEDIATE \'INSERT INTO t1 VALUES (?)\' USING\nX\'FFFF000000000000000000000000FFFF\';\n\nSELECT * FROM t1;\n+------------+\n| a          |\n+------------+\n| ffff::fffe |\n| ffff::ffff |\n+------------+\n\nEXECUTE IMMEDIATE \'SELECT * FROM t1 WHERE a=?\' USING \'ffff::fffe\';\n+------------+\n| a          |\n+------------+\n| ffff::fffe |\n+------------+\n\nEXECUTE IMMEDIATE \'SELECT * FROM t1 WHERE a=?\' USING\nX\'FFFF000000000000000000000000FFFF\';\n+------------+\n| a          |\n+------------+\n| ffff::ffff |\n+------------+\n\nMigration between BINARY(16) and INET6 Examples\n-----------------------------------------------\n\nBefore MariaDB 10.5:\n\nCREATE OR REPLACE TABLE t1 (a BINARY(16));\n\nINSERT INTO t1 VALUES (INET6_ATON(\'ffff::ffff\'));\n\nSELECT INET6_NTOA(a) FROM t1;\n+---------------+\n| INET6_NTOA(a) |\n+---------------+\n| ffff::ffff    |\n+---------------+\n\nMigrating to INET6, from MariaDB 10.5:\n\nALTER TABLE t1 MODIFY a INET6;\n\nINSERT INTO t1 VALUES (\'ffff::fffe\');\n\nSELECT * FROM t1;\n+------------+\n| a          |\n+------------+\n| ffff::ffff |\n| ffff::fffe |\n+------------+\n\nMigration from INET6 to BINARY(16):\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\nINSERT INTO t1 VALUES (\'::ffff:192.168.0.1\');\nINSERT INTO t1 VALUES (\'::192.168.0.1\');\n\nALTER TABLE t1 MODIFY a BINARY(16);\n\nSELECT INET6_NTOA(a) FROM t1;\n+------------------------+\n| INET6_NTOA(a)          |\n+------------------------+\n| 2001:db8::ff00:42:8329 |\n| ::ffff:192.168.0.1     |\n| ::192.168.0.1          |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/inet6/','','https://mariadb.com/kb/en/inet6/'),(274,'MEDIUMBLOB',23,'Syntax\n------\n\nMEDIUMBLOB\n\nDescription\n-----------\n\nA BLOB column with a maximum length of 16,777,215 (224 - 1) bytes. Each\nMEDIUMBLOB value is stored using a three-byte length prefix that indicates the\nnumber of bytes in the value.\n\nURL: https://mariadb.com/kb/en/mediumblob/','','https://mariadb.com/kb/en/mediumblob/'),(275,'MEDIUMTEXT',23,'Syntax\n------\n\nMEDIUMTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nDescription\n-----------\n\nA TEXT column with a maximum length of 16,777,215 (224 - 1) characters. The\neffective maximum length is less if the value contains multi-byte characters.\nEach MEDIUMTEXT value is stored using a three-byte length prefix that\nindicates the number of bytes in the value.\n\nURL: https://mariadb.com/kb/en/mediumtext/','','https://mariadb.com/kb/en/mediumtext/'),(276,'LONGBLOB',23,'Syntax\n------\n\nLONGBLOB\n\nDescription\n-----------\n\nA BLOB column with a maximum length of 4,294,967,295 bytes or 4GB (232 - 1).\nThe effective maximum length of LONGBLOB columns depends on the configured\nmaximum packet size in the client/server protocol and available memory. Each\nLONGBLOB value is stored using a four-byte length prefix that indicates the\nnumber of bytes in the value.\n\nOracle Mode\n-----------\n\nMariaDB starting with 10.3\n--------------------------\nIn Oracle mode from MariaDB 10.3, BLOB is a synonym for LONGBLOB.\n\nURL: https://mariadb.com/kb/en/longblob/','','https://mariadb.com/kb/en/longblob/'),(280,'TINYBLOB',23,'Syntax\n------\n\nTINYBLOB\n\nDescription\n-----------\n\nA BLOB column with a maximum length of 255 (28 - 1) bytes. Each TINYBLOB value\nis stored using a one-byte length prefix that indicates the number of bytes in\nthe value.\n\nURL: https://mariadb.com/kb/en/tinyblob/','','https://mariadb.com/kb/en/tinyblob/'),(281,'TINYTEXT',23,'Syntax\n------\n\nTINYTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nDescription\n-----------\n\nA TEXT column with a maximum length of 255 (28 - 1) characters. The effective\nmaximum length is less if the value contains multi-byte characters. Each\nTINYTEXT value is stored using a one-byte length prefix that indicates the\nnumber of bytes in the value.\n\nURL: https://mariadb.com/kb/en/tinytext/','','https://mariadb.com/kb/en/tinytext/'),(147,'GET_LOCK',14,'Syntax\n------\n\nGET_LOCK(str,timeout)\n\nDescription\n-----------\n\nTries to obtain a lock with a name given by the string str, using a timeout of\ntimeout seconds. Returns 1 if the lock was obtained successfully, 0 if the\nattempt timed out (for example, because another client has previously locked\nthe name), or NULL if an error occurred (such as running out of memory or the\nthread was killed with mysqladmin kill).\n\nA lock is released with RELEASE_LOCK(), when the connection terminates (either\nnormally or abnormally). A connection can hold multiple locks at the same\ntime, so a lock that is no longer needed needs to be explicitly released.\n\nThe IS_FREE_LOCK function returns whether a specified lock a free or not, and\nthe IS_USED_LOCK whether the function is in use or not.\n\nLocks obtained with GET_LOCK() do not interact with transactions. That is,\ncommitting a transaction does not release any such locks obtained during the\ntransaction.\n\nIt is also possible to recursively set the same lock. If a lock with the same\nname is set n times, it needs to be released n times as well.\n\nstr is case insensitive for GET_LOCK() and related functions. If str is an\nempty string or NULL, GET_LOCK() returns NULL and does nothing. From MariaDB\n10.2.2, timeout supports microseconds. Before then, it was rounded to the\nclosest integer.\n\nIf the metadata_lock_info plugin is installed, locks acquired with this\nfunction are visible in the Information Schema METADATA_LOCK_INFO table.\n\nThis function can be used to implement application locks or to simulate record\nlocks. Names are locked on a server-wide basis. If a name has been locked by\none client, GET_LOCK() blocks any request by another client for a lock with\nthe same name. This allows clients that agree on a given lock name to use the\nname to perform cooperative advisory locking. But be aware that it also allows\na client that is not among the set of cooperating clients to lock a name,\neither inadvertently or deliberately, and thus prevent any of the cooperating\nclients from locking that name. One way to reduce the likelihood of this is to\nuse lock names that are database-specific or application-specific. For\nexample, use lock names of the form db_name.str or app_name.str.\n\nStatements using the GET_LOCK function are not safe for statement-based\nreplication.\n\nThe patch to permit multiple locks was contributed by Konstantin \"Kostja\"\nOsipov (MDEV-3917).\n\nExamples\n--------\n\nSELECT GET_LOCK(\'lock1\',10);\n+----------------------+\n| GET_LOCK(\'lock1\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT IS_FREE_LOCK(\'lock1\'), IS_USED_LOCK(\'lock1\');\n+-----------------------+-----------------------+\n| IS_FREE_LOCK(\'lock1\') | IS_USED_LOCK(\'lock1\') |\n+-----------------------+-----------------------+\n|                     0 |                    46 |\n+-----------------------+-----------------------+\n\nSELECT IS_FREE_LOCK(\'lock2\'), IS_USED_LOCK(\'lock2\');\n+-----------------------+-----------------------+\n| IS_FREE_LOCK(\'lock2\') | IS_USED_LOCK(\'lock2\') |\n+-----------------------+-----------------------+\n|                     1 |                  NULL |\n+-----------------------+-----------------------+\n\nMultiple locks can be held:\n\nSELECT GET_LOCK(\'lock2\',10);\n+----------------------+\n| GET_LOCK(\'lock2\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT IS_FREE_LOCK(\'lock1\'), IS_FREE_LOCK(\'lock2\');\n+-----------------------+-----------------------+\n| IS_FREE_LOCK(\'lock1\') | IS_FREE_LOCK(\'lock2\') |\n+-----------------------+-----------------------+\n|                     0 |                     0 |\n+-----------------------+-----------------------+\n\nSELECT RELEASE_LOCK(\'lock1\'), RELEASE_LOCK(\'lock2\');\n+-----------------------+-----------------------+\n| RELEASE_LOCK(\'lock1\') | RELEASE_LOCK(\'lock2\') |\n+-----------------------+-----------------------+\n|                     1 |                     1 |\n+-----------------------+-----------------------+\n\nIt is possible to hold the same lock recursively. This example is viewed using\nthe metadata_lock_info plugin:\n\nSELECT GET_LOCK(\'lock3\',10);\n+----------------------+\n| GET_LOCK(\'lock3\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT GET_LOCK(\'lock3\',10);\n+----------------------+\n| GET_LOCK(\'lock3\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n| THREAD_ID | LOCK_MODE           | LOCK_DURATION | LOCK_TYPE | TABLE_SCHEMA |\nTABLE_NAME |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n|        46 | MDL_SHARED_NO_WRITE | NULL          | User lock | lock3        |\n     |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n\nSELECT RELEASE_LOCK(\'lock3\');\n+-----------------------+\n| RELEASE_LOCK(\'lock3\') |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n| THREAD_ID | LOCK_MODE           | LOCK_DURATION | LOCK_TYPE | TABLE_SCHEMA |\nTABLE_NAME |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n|        46 | MDL_SHARED_NO_WRITE | NULL          | User lock | lock3        |\n     |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n\nSELECT RELEASE_LOCK(\'lock3\');\n+-----------------------+\n| RELEASE_LOCK(\'lock3\') |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\nEmpty set (0.000 sec)\n\nTimeout example: Connection 1:\n\nSELECT GET_LOCK(\'lock4\',10);\n+----------------------+\n| GET_LOCK(\'lock4\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 2:\n\nSELECT GET_LOCK(\'lock4\',10);\n\nAfter 10 seconds...\n\n+----------------------+\n| GET_LOCK(\'lock4\',10) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nDeadlocks are automatically detected and resolved. Connection 1:\n\nSELECT GET_LOCK(\'lock5\',10); \n+----------------------+\n| GET_LOCK(\'lock5\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 2:\n\nSELECT GET_LOCK(\'lock6\',10);\n+----------------------+\n| GET_LOCK(\'lock6\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 1:\n\nSELECT GET_LOCK(\'lock6\',10); \n+----------------------+\n| GET_LOCK(\'lock6\',10) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nConnection 2:\n\nSELECT GET_LOCK(\'lock5\',10);\nERROR 1213 (40001): Deadlock found when trying to get lock; try restarting\ntransaction\n\nURL: https://mariadb.com/kb/en/get_lock/','','https://mariadb.com/kb/en/get_lock/'),(284,'SET Data Type',23,'Syntax\n------\n\nSET(\'value1\',\'value2\',...) [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nDescription\n-----------\n\nA set. A string object that can have zero or more values, each of which must\nbe chosen from the list of values \'value1\', \'value2\', ... A SET column can\nhave a maximum of 64 members. SET values are represented internally as\nintegers.\n\nSET values cannot contain commas.\n\nIf a SET contains duplicate values, an error will be returned if strict mode\nis enabled, or a warning if strict mode is not enabled.\n\nURL: https://mariadb.com/kb/en/set-data-type/','','https://mariadb.com/kb/en/set-data-type/'),(154,'IS_IPV4_COMPAT',14,'Syntax\n------\n\nIS_IPV4_COMPAT(expr)\n\nDescription\n-----------\n\nReturns 1 if a given numeric binary string IPv6 address, such as returned by\nINET6_ATON(), is IPv4-compatible, otherwise returns 0.\n\nMariaDB starting with 10.5.0\n----------------------------\nFrom MariaDB 10.5.0, when the argument is not INET6, automatic implicit CAST\nto INET6 is applied. As a consequence, IS_IPV4_COMPAT now understands\narguments in both text representation and binary(16) representation. Before\nMariaDB 10.5.0, the function understood only binary(16) representation.\n\nExamples\n--------\n\nSELECT IS_IPV4_COMPAT(INET6_ATON(\'::10.0.1.1\'));\n+------------------------------------------+\n| IS_IPV4_COMPAT(INET6_ATON(\'::10.0.1.1\')) |\n+------------------------------------------+\n|                                        1 |\n+------------------------------------------+\n\nSELECT IS_IPV4_COMPAT(INET6_ATON(\'::48f3::d432:1431:ba23:846f\'));\n+-----------------------------------------------------------+\n| IS_IPV4_COMPAT(INET6_ATON(\'::48f3::d432:1431:ba23:846f\')) |\n+-----------------------------------------------------------+\n|                                                         0 |\n+-----------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/is_ipv4_compat/','','https://mariadb.com/kb/en/is_ipv4_compat/'),(155,'IS_IPV4_MAPPED',14,'Syntax\n------\n\nIS_IPV4_MAPPED(expr)\n\nDescription\n-----------\n\nReturns 1 if a given a numeric binary string IPv6 address, such as returned by\nINET6_ATON(), is a valid IPv4-mapped address, otherwise returns 0.\n\nMariaDB starting with 10.5.0\n----------------------------\nFrom MariaDB 10.5.0, when the argument is not INET6, automatic implicit CAST\nto INET6 is applied. As a consequence, IS_IPV4_MAPPED now understands\narguments in both text representation and binary(16) representation. Before\nMariaDB 10.5.0, the function understood only binary(16) representation.\n\nExamples\n--------\n\nSELECT IS_IPV4_MAPPED(INET6_ATON(\'::10.0.1.1\'));\n+------------------------------------------+\n| IS_IPV4_MAPPED(INET6_ATON(\'::10.0.1.1\')) |\n+------------------------------------------+\n|                                        0 |\n+------------------------------------------+\n\nSELECT IS_IPV4_MAPPED(INET6_ATON(\'::ffff:10.0.1.1\'));\n+-----------------------------------------------+\n| IS_IPV4_MAPPED(INET6_ATON(\'::ffff:10.0.1.1\')) |\n+-----------------------------------------------+\n|                                             1 |\n+-----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/is_ipv4_mapped/','','https://mariadb.com/kb/en/is_ipv4_mapped/'),(159,'MASTER_POS_WAIT',14,'Syntax\n------\n\nMASTER_POS_WAIT(log_name,log_pos[,timeout,[\"connection_name\"]])\n\nDescription\n-----------\n\nThis function is useful in replication for controlling primary/replica\nsynchronization. It blocks until the replica has read and applied all updates\nup to the specified position (log_name,log_pos) in the primary log. The return\nvalue is the number of log events the replica had to wait for to advance to\nthe specified position. The function returns NULL if the replica SQL thread is\nnot started, the replica\'s primary information is not initialized, the\narguments are incorrect, or an error occurs. It returns -1 if the timeout has\nbeen exceeded. If the replica SQL thread stops while MASTER_POS_WAIT() is\nwaiting, the function returns NULL. If the replica is past the specified\nposition, the function returns immediately.\n\nIf a timeout value is specified, MASTER_POS_WAIT() stops waiting when timeout\nseconds have elapsed. timeout must be greater than 0; a zero or negative\ntimeout means no timeout.\n\nThe connection_name is used when you are using multi-source-replication. If\nyou don\'t specify it, it\'s set to the value of the default_master_connection\nsystem variable.\n\nStatements using the MASTER_POS_WAIT() function are not safe for replication.\n\nURL: https://mariadb.com/kb/en/master_pos_wait/','','https://mariadb.com/kb/en/master_pos_wait/'),(161,'RELEASE_ALL_LOCKS',14,'MariaDB until 10.5.2\n--------------------\nRELEASE_ALL_LOCKS was added in MariaDB 10.5.2.\n\nSyntax\n------\n\nRELEASE_ALL_LOCKS()\n\nDescription\n-----------\n\nReleases all named locks held by the current session. Returns the number of\nlocks released, or 0 if none were held.\n\nStatements using the RELEASE_ALL_LOCKS function are not safe for\nstatement-based replication.\n\nExamples\n--------\n\nSELECT RELEASE_ALL_LOCKS();\n+---------------------+\n| RELEASE_ALL_LOCKS() | \n+---------------------+\n|                   0 |\n+---------------------+\n\nSELECT GET_LOCK(\'lock1\',10);\n+----------------------+\n| GET_LOCK(\'lock1\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT RELEASE_ALL_LOCKS();\n+---------------------+\n| RELEASE_ALL_LOCKS() | \n+---------------------+\n|                   1 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/release_all_locks/','','https://mariadb.com/kb/en/release_all_locks/'),(288,'TIMESTAMP',23,'Syntax\n------\n\nTIMESTAMP [(<microsecond precision)]\n\nDescription\n-----------\n\nA timestamp in the format YYYY-MM-DD HH:MM:SS.ffffff.\n\nThe timestamp field is generally used to define at which moment in time a row\nwas added or updated and by default will automatically be assigned the current\ndatetime when a record is inserted or updated. The automatic properties only\napply to the first TIMESTAMP in the record; subsequent TIMESTAMP columns will\nnot be changed.\n\nMariaDB includes the --mysql56-temporal-format option, on by default, which\nallows MariaDB to store TIMESTAMPs using the same low-level format MySQL 5.6\nuses.\n\nFor more information, see Internal Format.\n\nSupported Values\n----------------\n\nMariaDB stores values that use the TIMESTAMP data type as the number of\nseconds since \'1970-01-01 00:00:00\' (UTC). This means that the TIMESTAMP data\ntype can hold values between \'1970-01-01 00:00:01\' (UTC) and \'2038-01-19\n03:14:07\' (UTC).\n\nMariaDB can also store microseconds with a precision between 0 and 6. If no\nmicrosecond precision is specified, then 0 is used by default.\n\nAutomatic Values\n----------------\n\nMariaDB has special behavior for the first column that uses the TIMESTAMP data\ntype in a specific table. For the first column that uses the TIMESTAMP data\ntype in a specific table, MariaDB automatically assigns the following\nproperties to the column:\n\n* DEFAULT CURRENT_TIMESTAMP\n* ON UPDATE CURRENT_TIMESTAMP\n\nThis means that if the column is not explicitly assigned a value in an INSERT\nor UPDATE query, then MariaDB will automatically initialize the column\'s value\nwith the current date and time.\n\nThis automatic initialization for INSERT and UPDATE queries can also be\nexplicitly enabled for a column that uses the TIMESTAMP data type by\nspecifying the DEFAULT CURRENT_TIMESTAMP and ON UPDATE CURRENT_TIMESTAMP\nclauses for the column. In these clauses, any synonym of CURRENT_TIMESTAMP is\naccepted, including CURRENT_TIMESTAMP(), NOW(), LOCALTIME, LOCALTIME(),\nLOCALTIMESTAMP, and LOCALTIMESTAMP().\n\nThis automatic initialization for INSERT queries can also be explicitly\ndisabled for a column that uses the TIMESTAMP data type by specifying a\nconstant DEFAULT value. For example, DEFAULT 0.\n\nThis automatic initialization for UPDATE queries can also be explicitly\ndisabled for a column that uses the TIMESTAMP data type by specifying a\nDEFAULT clause for the column, but no ON UPDATE clause. If a DEFAULT clause is\nexplicitly specified for a column that uses the TIMESTAMP data type, but an ON\nUPDATE clause is not specified for the column, then the timestamp value will\nnot automatically change when an UPDATE statement is executed.\n\nMariaDB also has special behavior if NULL is assigned to column that uses the\nTIMESTAMP data type. If the column is assigned the NULL value in an INSERT or\nUPDATE query, then MariaDB will automatically initialize the column\'s value\nwith the current date and time. For details, see NULL values in MariaDB.\n\nThis automatic initialization for NULL values can also be explicitly disabled\nfor a column that uses the TIMESTAMP data type by specifying the NULL\nattribute for the column. In this case, if the column\'s value is set to NULL,\nthen the column\'s value will actually be set to NULL.\n\nTime Zones\n----------\n\nIf a column uses the TIMESTAMP data type, then any inserted values are\nconverted from the session\'s time zone to Coordinated Universal Time (UTC)\nwhen stored, and converted back to the session\'s time zone when retrieved.\n\nMariaDB does not currently store any time zone identifier with the value of\nthe TIMESTAMP data type. See MDEV-10018 for more information.\n\nMariaDB does not currently support time zone literals that contain time zone\nidentifiers. See MDEV-11829 for more information.\n\nLimitations\n-----------\n\n* Because the TIMESTAMP value is stored as Epoch Seconds, the timestamp value\n\'1970-01-01 00:00:00\' (UTC) is reserved since the second #0 is used to\nrepresent \'0000-00-00 00:00:00\'.\n* In MariaDB 5.5 and before there could only be one TIMESTAMP column per table\nthat had CURRENT_TIMESTAMP defined as its default value. This limit has no\nlonger applied since MariaDB 10.0.\n\nSQL_MODE=MAXDB\n--------------\n\nIf the SQL_MODE is set to MAXDB, TIMESTAMP fields will be silently converted\nto DATETIME.\n\nInternal Format\n---------------\n\nIn MariaDB 10.1.2 a new temporal format was introduced from MySQL 5.6 that\nalters how the TIME, DATETIME and TIMESTAMP columns operate at lower levels.\nThese changes allow these temporal data types to have fractional parts and\nnegative values. You can disable this feature using the\nmysql56_temporal_format system variable.\n\nTables that include TIMESTAMP values that were created on an older version of\nMariaDB or that were created while the mysql56_temporal_format system variable\nwas disabled continue to store data using the older data type format.\n\nIn order to update table columns from the older format to the newer format,\nexecute an ALTER TABLE... MODIFY COLUMN statement that changes the column to\nthe *same* data type. This change may be needed if you want to export the\ntable\'s tablespace and import it onto a server that has\nmysql56_temporal_format=ON set (see MDEV-15225).\n\nFor instance, if you have a TIMESTAMP column in your table:\n\nSHOW VARIABLES LIKE \'mysql56_temporal_format\';\n\n+-------------------------+-------+\n| Variable_name           | Value |\n+-------------------------+-------+\n| mysql56_temporal_format | ON    |\n+-------------------------+-------+\n\nALTER TABLE example_table MODIFY ts_col TIMESTAMP;\n\nWhen MariaDB executes the ALTER TABLE statement, it converts the data from the\nolder temporal format to the newer one.\n\nIn the event that you have several tables and columns using temporal data\ntypes that you want to switch over to the new format, make sure the system\nvariable is enabled, then perform a dump and restore using mysqldump. The\ncolumns using relevant temporal data types are restored using the new temporal\nformat.\n\nStarting from MariaDB 10.5.1 columns with old temporal formats are marked with\na /* mariadb-5.3 */ comment in the output of SHOW CREATE TABLE, SHOW COLUMNS,\nDESCRIBE statements, as well as in the COLUMN_TYPE column of the\nINFORMATION_SCHEMA.COLUMNS Table.\n\nSHOW CREATE TABLE mariadb5312_timestamp\\G\n*************************** 1. row ***************************\n   Table: mariadb5312_timestamp\nCreate Table: CREATE TABLE `mariadb5312_timestamp` (\n `ts0` timestamp /* mariadb-5.3 */ NOT NULL DEFAULT current_timestamp() ON\nUPDATE current_timestamp(),\n `ts6` timestamp(6) /* mariadb-5.3 */ NOT NULL DEFAULT \'0000-00-00\n00:00:00.000000\'\n) ENGINE=MyISAM DEFAULT CHARSET=latin1\n\nNote: Prior to MySQL 4.1 a different format for the TIMESTAMP datatype was\nused. This format is unsupported in MariaDB 5.1 and upwards.\n\nExamples\n--------\n\nCREATE TABLE t (id INT, ts TIMESTAMP);\n\nDESC t;\n+-------+-----------+------+-----+-------------------+-------------------------\n---+\n| Field | Type      | Null | Key | Default           | Extra                  \n  |\n+-------+-----------+------+-----+-------------------+-------------------------\n---+\n| id    | int(11)   | YES  |     | NULL              |                        \n  |\n| ts    | timestamp | NO   |     | CURRENT_TIMESTAMP | on update\nCURRENT_TIMESTAMP |\n+-------+-----------+------+-----+-------------------+-------------------------\n---+\n\nINSERT INTO t(id)  VALUES (1),(2);\n\nSELECT * FROM t;\n+------+---------------------+\n| id   | ts                  |\n+------+---------------------+\n|    1 | 2013-07-22 12:50:05 |\n|    2 | 2013-07-22 12:50:05 |\n+------+---------------------+\n\nINSERT INTO t  VALUES (3,NULL),(4,\'2001-07-22 12:12:12\');\n\nSELECT * FROM t;\n+------+---------------------+\n| id   | ts                  |\n+------+---------------------+\n|    1 | 2013-07-22 12:50:05 |\n|    2 | 2013-07-22 12:50:05 |\n|    3 | 2013-07-22 12:51:56 |\n|    4 | 2001-07-22 12:12:12 |\n+------+---------------------+\n\nConverting to Unix epoch:\n\nSELECT ts, UNIX_TIMESTAMP(ts) FROM t;\n+---------------------+--------------------+\n| ts                  | UNIX_TIMESTAMP(ts) |\n+---------------------+--------------------+\n| 2013-07-22 12:50:05 |         1374490205 |\n| 2013-07-22 12:50:05 |         1374490205 |\n| 2013-07-22 12:51:56 |         1374490316 |\n| 2001-07-22 12:12:12 |          995796732 |\n+---------------------+--------------------+\n\nUpdate also changes the timestamp:\n\nUPDATE t set id=5 WHERE id=1;\n\nSELECT * FROM t;\n+------+---------------------+\n| id   | ts                  |\n+------+---------------------+\n|    5 | 2013-07-22 14:52:33 |\n|    2 | 2013-07-22 12:50:05 |\n|    3 | 2013-07-22 12:51:56 |\n|    4 | 2001-07-22 12:12:12 |\n+------+---------------------+\n\nDefault NULL:\n\nCREATE TABLE t2 (id INT, ts TIMESTAMP NULL ON UPDATE CURRENT_TIMESTAMP);\n\nINSERT INTO t(id)  VALUES (1),(2);\n\nSELECT * FROM t2;\n\nINSERT INTO t2(id)  VALUES (1),(2);\n\nSELECT * FROM t2;\n+------+------+\n| id   | ts   |\n+------+------+\n|    1 | NULL |\n|    2 | NULL |\n+------+------+\n\nUPDATE t2 SET id=3 WHERE id=1;\n\nSELECT * FROM t2;\n+------+---------------------+\n| id   | ts                  |\n+------+---------------------+\n|    3 | 2013-07-22 15:32:22 |\n|    2 | NULL                |\n+------+---------------------+\n\nOnly the first timestamp is automatically inserted and updated:\n\nCREATE TABLE t3 (id INT, ts1 TIMESTAMP, ts2 TIMESTAMP);\n\nINSERT INTO t3(id)  VALUES (1),(2);\n\nSELECT * FROM t3;\n+------+---------------------+---------------------+\n| id   | ts1                 | ts2                 |\n+------+---------------------+---------------------+\n|    1 | 2013-07-22 15:35:07 | 0000-00-00 00:00:00 |\n|    2 | 2013-07-22 15:35:07 | 0000-00-00 00:00:00 |\n+------+---------------------+---------------------+\n\nDESC t3;\n+-------+-----------+------+-----+---------------------+-----------------------\n-----+\n| Field | Type      | Null | Key | Default             | Extra                \n   |\n+-------+-----------+------+-----+---------------------+-----------------------\n-----+\n| id    | int(11)   | YES  |     | NULL                |                      \n   |\n| ts1   | timestamp | NO   |     | CURRENT_TIMESTAMP   | on update\nCURRENT_TIMESTAMP |\n| ts2   | timestamp | NO   |     | 0000-00-00 00:00:00 |                      \n   |\n+-------+-----------+------+-----+---------------------+-----------------------\n-----+\n\nExplicitly setting a timestamp with the CURRENT_TIMESTAMP function:\n\nINSERT INTO t3(id,ts2)  VALUES (3,CURRENT_TIMESTAMP());\n\nSELECT * FROM t3;\n+------+---------------------+---------------------+\n| id   | ts1                 | ts2                 |\n+------+---------------------+---------------------+\n|    1 | 2013-07-22 15:35:07 | 0000-00-00 00:00:00 |\n|    2 | 2013-07-22 15:35:07 | 0000-00-00 00:00:00 |\n|    3 | 2013-07-22 15:38:52 | 2013-07-22 15:38:52 |\n+------+---------------------+---------------------+\n\nSpecifying the timestamp as NOT NULL:\n\nCREATE TABLE t4 (id INT, ts TIMESTAMP NOT NULL);\n\nINSERT INTO t4(id)  VALUES (1);\nSELECT SLEEP(1);\nINSERT INTO t4(id,ts) VALUES (2,NULL);\n\nSELECT * FROM t4;\n\nURL: https://mariadb.com/kb/en/timestamp/','','https://mariadb.com/kb/en/timestamp/'),(298,'GOTO',24,'MariaDB starting with 10.3\n--------------------------\nThe GOTO statement was introduced in MariaDB 10.3 for Oracle compatibility.\n\nSyntax\n------\n\nGOTO label\n\nDescription\n-----------\n\nThe GOTO statement causes the code to jump to the specified label, and\ncontinue operating from there. It is only accepted when in Oracle mode.\n\nExample\n-------\n\nSET sql_mode=ORACLE;\n\nDELIMITER //\n\nCREATE OR REPLACE PROCEDURE p1 AS\n\nBEGIN\n\nSELECT 1;\n GOTO label;\n SELECT 2;\n <<label>>\n SELECT 3;\n\nEND;\n\n//\n\nDELIMITER\n\ncall p1();\n+---+\n| 1 |\n+---+\n| 1 |\n+---+\n1 row in set (0.000 sec)\n\n+---+\n| 3 |\n+---+\n| 3 |\n+---+\n1 row in set (0.000 sec)\n\nURL: https://mariadb.com/kb/en/goto/','','https://mariadb.com/kb/en/goto/'),(299,'IF',24,'Syntax\n------\n\nIF search_condition THEN statement_list\n  [ELSEIF search_condition THEN statement_list] ...\n  [ELSE statement_list]\nEND IF;\n\nDescription\n-----------\n\nIF implements a basic conditional construct. If the search_condition evaluates\nto true, the corresponding SQL statement list is executed. If no\nsearch_condition matches, the statement list in the ELSE clause is executed.\nEach statement_list consists of one or more statements.\n\nURL: https://mariadb.com/kb/en/if/','','https://mariadb.com/kb/en/if/'),(303,'LOOP',24,'Syntax\n------\n\n[begin_label:] LOOP\n  statement_list\nEND LOOP [end_label]\n\nDescription\n-----------\n\nLOOP implements a simple loop construct, enabling repeated execution of the\nstatement list, which consists of one or more statements, each terminated by a\nsemicolon (i.e., ;) statement delimiter. The statements within the loop are\nrepeated until the loop is exited; usually this is accomplished with a LEAVE\nstatement.\n\nA LOOP statement can be labeled. end_label cannot be given unless begin_label\nalso is present. If both are present, they must be the same.\n\nSee Delimiters in the mysql client for more on delimiter usage in the client.\n\nURL: https://mariadb.com/kb/en/loop/','','https://mariadb.com/kb/en/loop/'),(306,'RETURN',24,'Syntax\n------\n\nRETURN expr\n\nThe RETURN statement terminates execution of a stored function and returns the\nvalue expr to the function caller. There must be at least one RETURN statement\nin a stored function. If the function has multiple exit points, all exit\npoints must have a RETURN.\n\nThis statement is not used in stored procedures, triggers, or events. LEAVE\ncan be used instead.\n\nThe following example shows that RETURN can return the result of a scalar\nsubquery:\n\nCREATE FUNCTION users_count() RETURNS BOOL\n READS SQL DATA\nBEGIN\n RETURN (SELECT COUNT(DISTINCT User) FROM mysql.user);\nEND;\n\nURL: https://mariadb.com/kb/en/return/','','https://mariadb.com/kb/en/return/'),(158,'MASTER_GTID_WAIT',14,'Syntax\n------\n\nMASTER_GTID_WAIT(gtid-list[, timeout)\n\nDescription\n-----------\n\nThis function takes a string containing a comma-separated list of global\ntransaction id\'s (similar to the value of, for example, gtid_binlog_pos). It\nwaits until the value of gtid_slave_pos has the same or higher seq_no within\nall replication domains specified in the gtid-list; in other words, it waits\nuntil the slave has reached the specified GTID position.\n\nAn optional second argument gives a timeout in seconds. If the timeout expires\nbefore the specified GTID position is reached, then the function returns -1.\nPassing NULL or a negative number for the timeout means no timeout, and the\nfunction will wait indefinitely.\n\nIf the wait completes without a timeout, 0 is returned. Passing NULL for the\ngtid-list makes the function return NULL immediately, without waiting.\n\nThe gtid-list may be the empty string, in which case MASTER_GTID_WAIT()\nreturns immediately. If the gtid-list contains fewer domains than\ngtid_slave_pos, then only those domains are waited upon. If gtid-list contains\na domain that is not present in @@gtid_slave_pos, then MASTER_GTID_WAIT() will\nwait until an event containing such domain_id arrives on the slave (or until\ntimed out or killed).\n\nMASTER_GTID_WAIT() can be useful to ensure that a slave has caught up to a\nmaster. Simply take the value of gtid_binlog_pos on the master, and use it in\na MASTER_GTID_WAIT() call on the slave; when the call completes, the slave\nwill have caught up with that master position.\n\nMASTER_GTID_WAIT() can also be used in client applications together with the\nlast_gtid session variable. This is useful in a read-scaleout replication\nsetup, where the application writes to a single master but divides the reads\nout to a number of slaves to distribute the load. In such a setup, there is a\nrisk that an application could first do an update on the master, and then a\nbit later do a read on a slave, and if the slave is not fast enough, the data\nread from the slave might not include the update just made, possibly confusing\nthe application and/or the end-user. One way to avoid this is to request the\nvalue of last_gtid on the master just after the update. Then before doing the\nread on the slave, do a MASTER_GTID_WAIT() on the value obtained from the\nmaster; this will ensure that the read is not performed until the slave has\nreplicated sufficiently far for the update to have become visible.\n\nNote that MASTER_GTID_WAIT() can be used even if the slave is configured not\nto use GTID for connections (CHANGE MASTER TO master_use_gtid=no). This is\nbecause from MariaDB 10, GTIDs are always logged on the master server, and\nalways recorded on the slave servers.\n\nDifferences to MASTER_POS_WAIT()\n--------------------------------\n\n* MASTER_GTID_WAIT() is global; it waits for any master connection to reach\n the specified GTID position. MASTER_POS_WAIT() works only against a\n specific connection. This also means that while MASTER_POS_WAIT() aborts if\n its master connection is terminated with STOP SLAVE or due to an error,\n MASTER_GTID_WAIT() continues to wait while slaves are stopped.\n\n* MASTER_GTID_WAIT() can take its timeout as a floating-point value, so a\n timeout in fractional seconds is supported, eg. MASTER_GTID_WAIT(\"0-1-100\",\n 0.5). (The minimum wait is one microsecond, 0.000001 seconds).\n\n* MASTER_GTID_WAIT() allows one to specify a timeout of zero in order to do a\n non-blocking check to see if the slaves have progressed to a specific GTID\nposition\n (MASTER_POS_WAIT() takes a zero timeout as meaning an infinite wait). To do\n an infinite MASTER_GTID_WAIT(), specify a negative timeout, or omit the\n timeout argument.\n\n* MASTER_GTID_WAIT() does not return the number of events executed since the\n wait started, nor does it return NULL if a slave thread is stopped. It\n always returns either 0 for successful wait completed, or -1 for timeout\n reached (or NULL if the specified gtid-pos is NULL).\n\nSince MASTER_GTID_WAIT() looks only at the seq_no part of the GTIDs, not the\nserver_id, care is needed if a slave becomes diverged from another server so\nthat two different GTIDs with the same seq_no (in the same domain) arrive at\nthe same server. This situation is in any case best avoided; setting\ngtid_strict_mode is recommended, as this will prevent any such out-of-order\nsequence numbers from ever being replicated on a slave.\n\nURL: https://mariadb.com/kb/en/master_gtid_wait/','','https://mariadb.com/kb/en/master_gtid_wait/'),(164,'UUID',14,'Syntax\n------\n\nUUID()\n\nDescription\n-----------\n\nReturns a Universally Unique Identifier (UUID).\n\nA UUID is designed as a number that is globally unique in space and time. Two\ncalls to UUID() are expected to generate two different values, even if these\ncalls are performed on two separate computers that are not connected to each\nother.\n\nUUID() results are intended to be unique, but cannot always be relied upon to\nunpredictable and unguessable, so should not be relied upon for these purposes.\n\nA UUID is a 128-bit number represented by a utf8 string of five hexadecimal\nnumbers in aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee format:\n\n* The first three numbers are generated from a timestamp.\n* The fourth number preserves temporal uniqueness in case the timestamp value\n loses monotonicity (for example, due to daylight saving time).\n* The fifth number is an IEEE 802 node number that provides spatial uniqueness.\n A random number is substituted if the latter is not available (for example,\n because the host computer has no Ethernet card, or we do not know how to find\n the hardware address of an interface on your operating system). In this case,\n spatial uniqueness cannot be guaranteed. Nevertheless, a collision should\n have very low probability.\n\nCurrently, the MAC address of an interface is taken into account only on\nFreeBSD and Linux. On other operating systems, MariaDB uses a randomly\ngenerated 48-bit number.\n\nStatements using the UUID() function are not safe for replication.\n\nThe results are generated according to the \"DCE 1.1:Remote Procedure Call\"\n(Appendix A) CAE (Common Applications Environment) Specifications published by\nThe Open Group in October 1997 (Document Number C706).\n\nExamples\n--------\n\nSELECT UUID();\n+--------------------------------------+\n| UUID()                               |\n+--------------------------------------+\n| cd41294a-afb0-11df-bc9b-00241dd75637 |\n+--------------------------------------+\n\nURL: https://mariadb.com/kb/en/uuid/','','https://mariadb.com/kb/en/uuid/'),(309,'WHILE',24,'Syntax\n------\n\n[begin_label:] WHILE search_condition DO\n  statement_list\nEND WHILE [end_label]\n\nDescription\n-----------\n\nThe statement list within a WHILE statement is repeated as long as the\nsearch_condition is true. statement_list consists of one or more statements.\nIf the loop must be executed at least once, REPEAT ... LOOP can be used\ninstead.\n\nA WHILE statement can be labeled. end_label cannot be given unless begin_label\nalso is present. If both are present, they must be the same.\n\nExamples\n--------\n\nCREATE PROCEDURE dowhile()\nBEGIN\n DECLARE v1 INT DEFAULT 5;\n\nWHILE v1 > 0 DO\n  ...\n  SET v1 = v1 - 1;\n END WHILE;\nEND\n\nURL: https://mariadb.com/kb/en/while/','','https://mariadb.com/kb/en/while/'),(312,'OPEN',24,'Syntax\n------\n\n<= MariaDB 10.2\n\nOPEN cursor_name\n\nFrom MariaDB 10.3\n\nOPEN cursor_name [expression[,...]];\n\nDescription\n-----------\n\nThis statement opens a cursor which was previously declared with DECLARE\nCURSOR.\n\nThe query associated to the DECLARE CURSOR is executed when OPEN is executed.\nIt is important to remember this if the query produces an error, or calls\nfunctions which have side effects.\n\nThis is necessary in order to FETCH rows from a cursor.\n\nSee Cursor Overview for an example.\n\nURL: https://mariadb.com/kb/en/open/','','https://mariadb.com/kb/en/open/'),(162,'RELEASE_LOCK',14,'Syntax\n------\n\nRELEASE_LOCK(str)\n\nDescription\n-----------\n\nReleases the lock named by the string str that was obtained with GET_LOCK().\nReturns 1 if the lock was released, 0 if the lock was not established by this\nthread (in which case the lock is not released), and NULL if the named lock\ndid not exist. The lock does not exist if it was never obtained by a call to\nGET_LOCK() or if it has previously been released.\n\nstr is case insensitive. If str is an empty string or NULL, RELEASE_LOCK()\nreturns NULL and does nothing.\n\nStatements using the RELEASE_LOCK() function are not safe for replication.\n\nThe DO statement is convenient to use with RELEASE_LOCK().\n\nExamples\n--------\n\nConnection1:\n\nSELECT GET_LOCK(\'lock1\',10);\n+----------------------+\n| GET_LOCK(\'lock1\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 2:\n\nSELECT GET_LOCK(\'lock2\',10);\n+----------------------+\n| GET_LOCK(\'lock2\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 1:\n\nSELECT RELEASE_LOCK(\'lock1\'), RELEASE_LOCK(\'lock2\'), RELEASE_LOCK(\'lock3\');\n+-----------------------+-----------------------+-----------------------+\n| RELEASE_LOCK(\'lock1\') | RELEASE_LOCK(\'lock2\') | RELEASE_LOCK(\'lock3\') |\n+-----------------------+-----------------------+-----------------------+\n|                     1 |                     0 |                  NULL |\n+-----------------------+-----------------------+-----------------------+\n\nFrom MariaDB 10.0.2, it is possible to hold the same lock recursively. This\nexample is viewed using the metadata_lock_info plugin:\n\nSELECT GET_LOCK(\'lock3\',10);\n+----------------------+\n| GET_LOCK(\'lock3\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT GET_LOCK(\'lock3\',10);\n+----------------------+\n| GET_LOCK(\'lock3\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n| THREAD_ID | LOCK_MODE           | LOCK_DURATION | LOCK_TYPE | TABLE_SCHEMA |\nTABLE_NAME |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n|        46 | MDL_SHARED_NO_WRITE | NULL          | User lock | lock3        |\n     |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n\nSELECT RELEASE_LOCK(\'lock3\');\n+-----------------------+\n| RELEASE_LOCK(\'lock3\') |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n| THREAD_ID | LOCK_MODE           | LOCK_DURATION | LOCK_TYPE | TABLE_SCHEMA |\nTABLE_NAME |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n|        46 | MDL_SHARED_NO_WRITE | NULL          | User lock | lock3        |\n     |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n\nSELECT RELEASE_LOCK(\'lock3\');\n+-----------------------+\n| RELEASE_LOCK(\'lock3\') |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\nEmpty set (0.000 sec)\n\nURL: https://mariadb.com/kb/en/release_lock/','','https://mariadb.com/kb/en/release_lock/'),(165,'UUID_SHORT',14,'Syntax\n------\n\nUUID_SHORT()\n\nDescription\n-----------\n\nReturns a \"short\" universally unique identifier as a 64-bit unsigned integer\n(rather than a string-form 128-bit identifier as returned by the UUID()\nfunction).\n\nThe value of UUID_SHORT() is guaranteed to be unique if the following\nconditions hold:\n\n* The server_id of the current host is unique among your set of master and\n slave servers\n* server_id is between 0 and 255\n* You don\'t set back your system time for your server between mysqld restarts\n* You do not invoke UUID_SHORT() on average more than 16\n million times per second between mysqld restarts\n\nThe UUID_SHORT() return value is constructed this way:\n\n(server_id & 255) << 56\n+ (server_startup_time_in_seconds << 24)\n+ incremented_variable++;\n\nStatements using the UUID_SHORT() function are not safe for statement-based\nreplication.\n\nExamples\n--------\n\nSELECT UUID_SHORT();\n+-------------------+\n| UUID_SHORT()      |\n+-------------------+\n| 21517162376069120 |\n+-------------------+\n\ncreate table t1 (a bigint unsigned default(uuid_short()) primary key);\ninsert into t1 values(),();\nselect * from t1;\n+-------------------+\n| a                 |\n+-------------------+\n| 98113699159474176 |\n| 98113699159474177 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/uuid_short/','','https://mariadb.com/kb/en/uuid_short/'),(166,'VALUES / VALUE',14,'Syntax\n------\n\nMariaDB starting with 10.3.3\n----------------------------\n\nVALUE(col_name)\n\nMariaDB until 10.3.2\n--------------------\n\nVALUES(col_name)\n\nDescription\n-----------\n\nIn an INSERT ... ON DUPLICATE KEY UPDATE statement, you can use the\nVALUES(col_name) function in the UPDATE clause to refer to column values from\nthe INSERT portion of the statement. In other words, VALUES(col_name) in the\nUPDATE clause refers to the value of col_name that would be inserted, had no\nduplicate-key conflict occurred. This function is especially useful in\nmultiple-row inserts.\n\nThe VALUES() function is meaningful only in INSERT ... ON DUPLICATE KEY UPDATE\nstatements and returns NULL otherwise.\n\nIn MariaDB 10.3.3 this function was renamed to VALUE(), because it\'s\nincompatible with the standard Table Value Constructors syntax, implemented in\nMariaDB 10.3.3.\n\nThe VALUES() function can still be used even from MariaDB 10.3.3, but only in\nINSERT ... ON DUPLICATE KEY UPDATE statements; it\'s a syntax error otherwise.\n\nExamples\n--------\n\nMariaDB starting with 10.3.3\n----------------------------\n\nINSERT INTO t (a,b,c) VALUES (1,2,3),(4,5,6)\n  ON DUPLICATE KEY UPDATE c=VALUE(a)+VALUE(b);\n\nMariaDB until 10.3.2\n--------------------\n\nINSERT INTO t (a,b,c) VALUES (1,2,3),(4,5,6)\n  ON DUPLICATE KEY UPDATE c=VALUES(a)+VALUES(b);\n\nURL: https://mariadb.com/kb/en/values-value/','','https://mariadb.com/kb/en/values-value/'),(313,'FETCH',24,'Syntax\n------\n\nFETCH cursor_name INTO var_name [, var_name] ...\n\nDescription\n-----------\n\nThis statement fetches the next row (if a row exists) using the specified open\ncursor, and advances the cursor pointer.\n\nvar_name can be a local variable, but not a user-defined variable.\n\nIf no more rows are available, a No Data condition occurs with SQLSTATE value\n02000. To detect this condition, you can set up a handler for it (or for a NOT\nFOUND condition).\n\nSee Cursor Overview for an example.\n\nURL: https://mariadb.com/kb/en/fetch/','','https://mariadb.com/kb/en/fetch/'),(314,'CLOSE',24,'Syntax\n------\n\nCLOSE cursor_name\n\nDescription\n-----------\n\nThis statement closes a previously opened cursor. The cursor must have been\npreviously opened or else an error occurs.\n\nIf not closed explicitly, a cursor is closed at the end of the compound\nstatement in which it was declared.\n\nSee Cursor Overview for an example.\n\nURL: https://mariadb.com/kb/en/close/','','https://mariadb.com/kb/en/close/'),(315,'BUFFER',25,'A synonym for ST_BUFFER.\n\nURL: https://mariadb.com/kb/en/buffer/','','https://mariadb.com/kb/en/buffer/'),(170,'||',15,'Syntax\n------\n\nOR, ||\n\nDescription\n-----------\n\nLogical OR. When both operands are non-NULL, the result is 1 if any operand is\nnon-zero, and 0 otherwise. With a NULL operand, the result is 1 if the other\noperand is non-zero, and NULL otherwise. If both operands are NULL, the result\nis NULL.\n\nFor this operator, short-circuit evaluation can be used.\n\nNote that, if the PIPES_AS_CONCAT SQL_MODE is set, || is used as a string\nconcatenation operator. This means that a || b is the same as CONCAT(a,b). See\nCONCAT() for details.\n\nOracle Mode\n-----------\n\nMariaDB starting with 10.3\n--------------------------\nIn Oracle mode from MariaDB 10.3, || ignores NULL.\n\nExamples\n--------\n\nSELECT 1 || 1;\n+--------+\n| 1 || 1 |\n+--------+\n|      1 |\n+--------+\n\nSELECT 1 || 0;\n+--------+\n| 1 || 0 |\n+--------+\n|      1 |\n+--------+\n\nSELECT 0 || 0;\n+--------+\n| 0 || 0 |\n+--------+\n|      0 |\n+--------+\n\nSELECT 0 || NULL;\n+-----------+\n| 0 || NULL |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT 1 || NULL;\n+-----------+\n| 1 || NULL |\n+-----------+\n|         1 |\n+-----------+\n\nIn Oracle mode, from MariaDB 10.3:\n\nSELECT 0 || NULL;\n+-----------+\n| 0 || NULL |\n+-----------+\n| 0         |\n+-----------+\n\nURL: https://mariadb.com/kb/en/or/','','https://mariadb.com/kb/en/or/'),(171,'Stored Aggregate Functions',16,'MariaDB starting with 10.3.3\n----------------------------\nThe ability to create stored aggregate functions was added in MariaDB 10.3.3.\n\nAggregate functions are functions that are computed over a sequence of rows\nand return one result for the sequence of rows.\n\nCreating a custom aggregate function is done using the CREATE FUNCTION\nstatement with two main differences:\n\n* The addition of the AGGREGATE keyword, so CREATE AGGREGATE FUNCTION\n* The FETCH GROUP NEXT ROW instruction inside the loop\n* Oracle PL/SQL compatibility using SQL/PL is provided\n\nStandard Syntax\n---------------\n\nCREATE AGGREGATE FUNCTION function_name (parameters) RETURNS return_type\nBEGIN\n   All types of declarations\n   DECLARE CONTINUE HANDLER FOR NOT FOUND RETURN return_val;\n   LOOP\n     FETCH GROUP NEXT ROW; // fetches next row from table\n     other instructions\n   END LOOP;\nEND\n\nStored aggregate functions were a 2016 Google Summer of Code project by Varun\nGupta.\n\nUsing SQL/PL\n------------\n\nSET sql_mode=Oracle;\nDELIMITER //\n\nCREATE AGGREGATE FUNCTION function_name (parameters) RETURN return_type\n declarations\nBEGIN\n LOOP\n   FETCH GROUP NEXT ROW; -- fetches next row from table\n   -- other instructions\n\nEND LOOP;\nEXCEPTION\n WHEN NO_DATA_FOUND THEN\n   RETURN return_val;\nEND //\n\nDELIMITER ;\n\nExamples\n--------\n\nFirst a simplified example:\n\nCREATE TABLE marks(stud_id INT, grade_count INT);\n\nINSERT INTO marks VALUES (1,6), (2,4), (3,7), (4,5), (5,8);\n\nSELECT * FROM marks;\n+---------+-------------+\n| stud_id | grade_count |\n+---------+-------------+\n|       1 |           6 |\n|       2 |           4 |\n|       3 |           7 |\n|       4 |           5 |\n|       5 |           8 |\n+---------+-------------+\n\nDELIMITER //\nCREATE AGGREGATE FUNCTION IF NOT EXISTS aggregate_count(x INT) RETURNS INT\nBEGIN\n DECLARE count_students INT DEFAULT 0;\n DECLARE CONTINUE HANDLER FOR NOT FOUND\n RETURN count_students;\n   LOOP\n     FETCH GROUP NEXT ROW;\n     IF x  THEN\n      SET count_students = count_students+1;\n     END IF;\n   END LOOP;\nEND //\nDELIMITER ;\n\nA non-trivial example that cannot easily be rewritten using existing functions:\n\nDELIMITER //\nCREATE AGGREGATE FUNCTION medi_int(x INT) RETURNS DOUBLE\nBEGIN\n DECLARE CONTINUE HANDLER FOR NOT FOUND\n  BEGIN\n   DECLARE res DOUBLE;\n   DECLARE cnt INT DEFAULT (SELECT COUNT(*) FROM tt);\n   DECLARE lim INT DEFAULT (cnt-1) DIV 2;\n   IF cnt % 2 = 0 THEN\n    SET res = (SELECT AVG(a) FROM (SELECT a FROM tt ORDER BY a LIMIT\nlim,2) ttt);\n   ELSE\n    SET res = (SELECT a FROM tt ORDER BY a LIMIT lim,1);\n   END IF;\n   DROP TEMPORARY TABLE tt;\n   RETURN res;\n  END;\n CREATE TEMPORARY TABLE tt (a INT);\n LOOP\n  FETCH GROUP NEXT ROW;\n  INSERT INTO tt VALUES (x);\n END LOOP;\nEND //\nDELIMITER ;\n\nSQL/PL Example\n--------------\n\nThis uses the same marks table as created above.\n\nSET sql_mode=Oracle;\nDELIMITER //\n\nCREATE AGGREGATE FUNCTION aggregate_count(x INT) RETURN INT AS count_students\nINT DEFAULT 0;\nBEGIN\n LOOP\n   FETCH GROUP NEXT ROW;\n   IF x  THEN\n    SET count_students := count_students+1;\n   END IF;\n END LOOP;\nEXCEPTION\n WHEN NO_DATA_FOUND THEN\n   RETURN count_students;\nEND aggregate_count //\nDELIMITER ;\n\nSELECT aggregate_count(stud_id) FROM marks;\n\nURL: https://mariadb.com/kb/en/stored-aggregate-functions/','','https://mariadb.com/kb/en/stored-aggregate-functions/'),(172,'AVG',16,'Syntax\n------\n\nAVG([DISTINCT] expr)\n\nDescription\n-----------\n\nReturns the average value of expr. The DISTINCT option can be used to return\nthe average of the distinct values of expr. NULL values are ignored. It is an\naggregate function, and so can be used with the GROUP BY clause.\n\nAVG() returns NULL if there were no matching rows.\n\nAVG() can be used as a window function.\n\nExamples\n--------\n\nCREATE TABLE sales (sales_value INT);\n\nINSERT INTO sales VALUES(10),(20),(20),(40);\n\nSELECT AVG(sales_value) FROM sales;\n+------------------+\n| AVG(sales_value) |\n+------------------+\n|          22.5000 |\n+------------------+\n\nSELECT AVG(DISTINCT(sales_value)) FROM sales;\n+----------------------------+\n| AVG(DISTINCT(sales_value)) |\n+----------------------------+\n|                    23.3333 |\n+----------------------------+\n\nCommonly, AVG() is used with a GROUP BY clause:\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT name, AVG(score) FROM student GROUP BY name;\n+---------+------------+\n| name    | AVG(score) |\n+---------+------------+\n| Chun    |    74.0000 |\n| Esben   |    37.0000 |\n| Kaolin  |    72.0000 |\n| Tatiana |    85.0000 |\n+---------+------------+\n\nBe careful to avoid this common mistake, not grouping correctly and returning\nmismatched data:\n\nSELECT name,test,AVG(score) FROM student;\n+------+------+------------+\n| name | test | MIN(score) |\n+------+------+------------+\n| Chun | SQL  |         31 |\n+------+------+------------+\n\nAs a window function:\n\nCREATE TABLE student_test (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT name, test, score, AVG(score) OVER (PARTITION BY test) \n  AS average_by_test FROM student_test;\n+---------+--------+-------+-----------------+\n| name    | test   | score | average_by_test |\n+---------+--------+-------+-----------------+\n| Chun    | SQL    |    75 |         65.2500 |\n| Chun    | Tuning |    73 |         68.7500 |\n| Esben   | SQL    |    43 |         65.2500 |\n| Esben   | Tuning |    31 |         68.7500 |\n| Kaolin  | SQL    |    56 |         65.2500 |\n| Kaolin  | Tuning |    88 |         68.7500 |\n| Tatiana | SQL    |    87 |         65.2500 |\n| Tatiana | Tuning |    83 |         68.7500 |\n+---------+--------+-------+-----------------+\n\nURL: https://mariadb.com/kb/en/avg/','','https://mariadb.com/kb/en/avg/'),(173,'BIT_AND',16,'Syntax\n------\n\nBIT_AND(expr) [over_clause]\n\nDescription\n-----------\n\nReturns the bitwise AND of all bits in expr. The calculation is performed with\n64-bit (BIGINT) precision. It is an aggregate function, and so can be used\nwith the GROUP BY clause.\n\nIf no rows match, BIT_AND will return a value with all bits set to 1. NULL\nvalues have no effect on the result unless all results are NULL, which is\ntreated as no match.\n\nBIT_AND can be used as a window function with the addition of the over_clause.\n\nExamples\n--------\n\nCREATE TABLE vals (x INT);\n\nINSERT INTO vals VALUES(111),(110),(100);\n\nSELECT BIT_AND(x), BIT_OR(x), BIT_XOR(x) FROM vals;\n+------------+-----------+------------+\n| BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+------------+-----------+------------+\n|        100 |       111 |        101 |\n+------------+-----------+------------+\n\nAs an aggregate function:\n\nCREATE TABLE vals2 (category VARCHAR(1), x INT);\n\nINSERT INTO vals2 VALUES\n (\'a\',111),(\'a\',110),(\'a\',100),\n (\'b\',\'000\'),(\'b\',001),(\'b\',011);\n\nSELECT category, BIT_AND(x), BIT_OR(x), BIT_XOR(x) \n FROM vals GROUP BY category;\n+----------+------------+-----------+------------+\n| category | BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+----------+------------+-----------+------------+\n| a        |        100 |       111 |        101 |\n| b        |          0 |        11 |         10 |\n+----------+------------+-----------+------------+\n\nNo match:\n\nSELECT BIT_AND(NULL);\n+----------------------+\n| BIT_AND(NULL)        |\n+----------------------+\n| 18446744073709551615 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/bit_and/','','https://mariadb.com/kb/en/bit_and/'),(174,'BIT_OR',16,'Syntax\n------\n\nBIT_OR(expr) [over_clause]\n\nDescription\n-----------\n\nReturns the bitwise OR of all bits in expr. The calculation is performed with\n64-bit (BIGINT) precision. It is an aggregate function, and so can be used\nwith the GROUP BY clause.\n\nIf no rows match, BIT_OR will return a value with all bits set to 0. NULL\nvalues have no effect on the result unless all results are NULL, which is\ntreated as no match.\n\nBIT_OR can be used as a window function with the addition of the over_clause.\n\nExamples\n--------\n\nCREATE TABLE vals (x INT);\n\nINSERT INTO vals VALUES(111),(110),(100);\n\nSELECT BIT_AND(x), BIT_OR(x), BIT_XOR(x) FROM vals;\n+------------+-----------+------------+\n| BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+------------+-----------+------------+\n|        100 |       111 |        101 |\n+------------+-----------+------------+\n\nAs an aggregate function:\n\nCREATE TABLE vals2 (category VARCHAR(1), x INT);\n\nINSERT INTO vals2 VALUES\n (\'a\',111),(\'a\',110),(\'a\',100),\n (\'b\',\'000\'),(\'b\',001),(\'b\',011);\n\nSELECT category, BIT_AND(x), BIT_OR(x), BIT_XOR(x) \n FROM vals GROUP BY category;\n+----------+------------+-----------+------------+\n| category | BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+----------+------------+-----------+------------+\n| a        |        100 |       111 |        101 |\n| b        |          0 |        11 |         10 |\n+----------+------------+-----------+------------+\n\nNo match:\n\nSELECT BIT_OR(NULL);\n+--------------+\n| BIT_OR(NULL) |\n+--------------+\n|            0 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/bit_or/','','https://mariadb.com/kb/en/bit_or/'),(175,'BIT_XOR',16,'Syntax\n------\n\nBIT_XOR(expr) [over_clause]\n\nDescription\n-----------\n\nReturns the bitwise XOR of all bits in expr. The calculation is performed with\n64-bit (BIGINT) precision. It is an aggregate function, and so can be used\nwith the GROUP BY clause.\n\nIf no rows match, BIT_XOR will return a value with all bits set to 0. NULL\nvalues have no effect on the result unless all results are NULL, which is\ntreated as no match.\n\nBIT_XOR can be used as a window function with the addition of the over_clause.\n\nExamples\n--------\n\nCREATE TABLE vals (x INT);\n\nINSERT INTO vals VALUES(111),(110),(100);\n\nSELECT BIT_AND(x), BIT_OR(x), BIT_XOR(x) FROM vals;\n+------------+-----------+------------+\n| BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+------------+-----------+------------+\n|        100 |       111 |        101 |\n+------------+-----------+------------+\n\nAs an aggregate function:\n\nCREATE TABLE vals2 (category VARCHAR(1), x INT);\n\nINSERT INTO vals2 VALUES\n (\'a\',111),(\'a\',110),(\'a\',100),\n (\'b\',\'000\'),(\'b\',001),(\'b\',011);\n\nSELECT category, BIT_AND(x), BIT_OR(x), BIT_XOR(x) \n FROM vals GROUP BY category;\n+----------+------------+-----------+------------+\n| category | BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+----------+------------+-----------+------------+\n| a        |        100 |       111 |        101 |\n| b        |          0 |        11 |         10 |\n+----------+------------+-----------+------------+\n\nNo match:\n\nSELECT BIT_XOR(NULL);\n+---------------+\n| BIT_XOR(NULL) |\n+---------------+\n|             0 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/bit_xor/','','https://mariadb.com/kb/en/bit_xor/'),(176,'COUNT',16,'Syntax\n------\n\nCOUNT(expr)\n\nDescription\n-----------\n\nReturns a count of the number of non-NULL values of expr in the rows retrieved\nby a SELECT statement. The result is a BIGINT value. It is an aggregate\nfunction, and so can be used with the GROUP BY clause.\n\nCOUNT(*) counts the total number of rows in a table.\n\nCOUNT() returns 0 if there were no matching rows.\n\nCOUNT() can be used as a window function.\n\nExamples\n--------\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT COUNT(*) FROM student;\n+----------+\n| COUNT(*) |\n+----------+\n|        8 |\n+----------+\n\nCOUNT(DISTINCT) example:\n\nSELECT COUNT(DISTINCT (name)) FROM student;\n+------------------------+\n| COUNT(DISTINCT (name)) |\n+------------------------+\n|                      4 |\n+------------------------+\n\nAs a window function\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, COUNT(score) OVER (PARTITION BY name) \n  AS tests_written FROM student_test;\n+---------+--------+-------+---------------+\n| name    | test   | score | tests_written |\n+---------+--------+-------+---------------+\n| Chun    | SQL    |    75 |             2 |\n| Chun    | Tuning |    73 |             2 |\n| Esben   | SQL    |    43 |             2 |\n| Esben   | Tuning |    31 |             2 |\n| Kaolin  | SQL    |    56 |             2 |\n| Kaolin  | Tuning |    88 |             2 |\n| Tatiana | SQL    |    87 |             1 |\n+---------+--------+-------+---------------+\n\nURL: https://mariadb.com/kb/en/count/','','https://mariadb.com/kb/en/count/'),(316,'CONVEXHULL',25,'A synonym for ST_CONVEXHULL.\n\nURL: https://mariadb.com/kb/en/convexhull/','','https://mariadb.com/kb/en/convexhull/'),(317,'GEOMETRYCOLLECTION',25,'Syntax\n------\n\nGeometryCollection(g1,g2,...)\n\nDescription\n-----------\n\nConstructs a WKB GeometryCollection. If any argument is not a well-formed WKB\nrepresentation of a geometry, the return value is NULL.\n\nExamples\n--------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/geometrycollection/','','https://mariadb.com/kb/en/geometrycollection/'),(177,'COUNT DISTINCT',16,'Syntax\n------\n\nCOUNT(DISTINCT expr,[expr...])\n\nDescription\n-----------\n\nReturns a count of the number of different non-NULL values.\n\nCOUNT(DISTINCT) returns 0 if there were no matching rows.\n\nAlthough, from MariaDB 10.2.0, COUNT can be used as a window function, COUNT\nDISTINCT cannot be.\n\nExamples\n--------\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT COUNT(*) FROM student;\n+----------+\n| COUNT(*) |\n+----------+\n|        8 |\n+----------+\n\nSELECT COUNT(DISTINCT (name)) FROM student;\n+------------------------+\n| COUNT(DISTINCT (name)) |\n+------------------------+\n|                      4 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/count-distinct/','','https://mariadb.com/kb/en/count-distinct/'),(178,'GROUP_CONCAT',16,'Syntax\n------\n\nGROUP_CONCAT(expr)\n\nDescription\n-----------\n\nThis function returns a string result with the concatenated non-NULL values\nfrom a group. It returns NULL if there are no non-NULL values.\n\nThe maximum returned length in bytes is determined by the group_concat_max_len\nserver system variable, which defaults to 1M (>= MariaDB 10.2.4) or 1K (<=\nMariaDB 10.2.3).\n\nIf group_concat_max_len <= 512, the return type is VARBINARY or VARCHAR;\notherwise, the return type is BLOB or TEXT. The choice between binary or\nnon-binary types depends from the input.\n\nThe full syntax is as follows:\n\nGROUP_CONCAT([DISTINCT] expr [,expr ...]\n      [ORDER BY {unsigned_integer | col_name | expr}\n        [ASC | DESC] [,col_name ...]]\n      [SEPARATOR str_val]\n      [LIMIT {[offset,] row_count | row_count OFFSET offset}])\n\nDISTINCT eliminates duplicate values from the output string.\n\nORDER BY determines the order of returned values.\n\nSEPARATOR specifies a separator between the values. The default separator is a\ncomma (,). It is possible to avoid using a separator by specifying an empty\nstring.\n\nLIMIT\n-----\n\nMariaDB starting with 10.3.3\n----------------------------\nUntil MariaDB 10.3.2, it was not possible to use the LIMIT clause with\nGROUP_CONCAT. This restriction was lifted in MariaDB 10.3.3.\n\nExamples\n--------\n\nSELECT student_name,\n   GROUP_CONCAT(test_score)\n   FROM student\n   GROUP BY student_name;\n\nGet a readable list of MariaDB users from the mysql.user table:\n\nSELECT GROUP_CONCAT(DISTINCT User ORDER BY User SEPARATOR \'\\n\')\n FROM mysql.user;\n\nIn the former example, DISTINCT is used because the same user may occur more\nthan once. The new line (\\n) used as a SEPARATOR makes the results easier to\nread.\n\nGet a readable list of hosts from which each user can connect:\n\nSELECT User, GROUP_CONCAT(Host ORDER BY Host SEPARATOR \', \') \n FROM mysql.user GROUP BY User ORDER BY User;\n\nThe former example shows the difference between the GROUP_CONCAT\'s ORDER BY\n(which sorts the concatenated hosts), and the SELECT\'s ORDER BY (which sorts\nthe rows).\n\nFrom MariaDB 10.3.3, LIMIT can be used with GROUP_CONCAT, so, for example,\ngiven the following table:\n\nCREATE TABLE d (dd DATE, cc INT);\n\nINSERT INTO d VALUES (\'2017-01-01\',1);\nINSERT INTO d VALUES (\'2017-01-02\',2);\nINSERT INTO d VALUES (\'2017-01-04\',3);\n\nthe following query:\n\nSELECT SUBSTRING_INDEX(GROUP_CONCAT(CONCAT_WS(\":\",dd,cc) ORDER BY cc\nDESC),\",\",1) FROM d;\n+----------------------------------------------------------------------------+\n| SUBSTRING_INDEX(GROUP_CONCAT(CONCAT_WS(\":\",dd,cc) ORDER BY cc DESC),\",\",1) |\n+----------------------------------------------------------------------------+\n| 2017-01-04:3                                                               |\n+----------------------------------------------------------------------------+\n\ncan be more simply rewritten as:\n\nSELECT GROUP_CONCAT(CONCAT_WS(\":\",dd,cc) ORDER BY cc DESC LIMIT 1) FROM d;\n+-------------------------------------------------------------+\n| GROUP_CONCAT(CONCAT_WS(\":\",dd,cc) ORDER BY cc DESC LIMIT 1) |\n+-------------------------------------------------------------+\n| 2017-01-04:3                                                |\n+-------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/group_concat/','','https://mariadb.com/kb/en/group_concat/'),(179,'MAX',16,'Syntax\n------\n\nMAX([DISTINCT] expr)\n\nDescription\n-----------\n\nReturns the largest, or maximum, value of expr. MAX() can also take a string\nargument in which case it returns the maximum string value. The DISTINCT\nkeyword can be used to find the maximum of the distinct values of expr,\nhowever, this produces the same result as omitting DISTINCT.\n\nNote that SET and ENUM fields are currently compared by their string value\nrather than their relative position in the set, so MAX() may produce a\ndifferent highest result than ORDER BY DESC.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nMAX() can be used as a window function.\n\nMAX() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT name, MAX(score) FROM student GROUP BY name;\n+---------+------------+\n| name    | MAX(score) |\n+---------+------------+\n| Chun    |         75 |\n| Esben   |         43 |\n| Kaolin  |         88 |\n| Tatiana |         87 |\n+---------+------------+\n\nMAX string:\n\nSELECT MAX(name) FROM student;\n+-----------+\n| MAX(name) |\n+-----------+\n| Tatiana   |\n+-----------+\n\nBe careful to avoid this common mistake, not grouping correctly and returning\nmismatched data:\n\nSELECT name,test,MAX(SCORE) FROM student;\n+------+------+------------+\n| name | test | MAX(SCORE) |\n+------+------+------------+\n| Chun | SQL  |         88 |\n+------+------+------------+\n\nDifference between ORDER BY DESC and MAX():\n\nCREATE TABLE student2(name CHAR(10),grade ENUM(\'b\',\'c\',\'a\'));\n\nINSERT INTO student2 VALUES(\'Chun\',\'b\'),(\'Esben\',\'c\'),(\'Kaolin\',\'a\');\n\nSELECT MAX(grade) FROM student2;\n+------------+\n| MAX(grade) |\n+------------+\n| c          |\n+------------+\n\nSELECT grade FROM student2 ORDER BY grade DESC LIMIT 1;\n+-------+\n| grade |\n+-------+\n| a     |\n+-------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, MAX(score) \n OVER (PARTITION BY name) AS highest_score FROM student_test;\n+---------+--------+-------+---------------+\n| name    | test   | score | highest_score |\n+---------+--------+-------+---------------+\n| Chun    | SQL    |    75 |            75 |\n| Chun    | Tuning |    73 |            75 |\n| Esben   | SQL    |    43 |            43 |\n| Esben   | Tuning |    31 |            43 |\n| Kaolin  | SQL    |    56 |            88 |\n| Kaolin  | Tuning |    88 |            88 |\n| Tatiana | SQL    |    87 |            87 |\n+---------+--------+-------+---------------+\n\nURL: https://mariadb.com/kb/en/max/','','https://mariadb.com/kb/en/max/'),(180,'MIN',16,'Syntax\n------\n\nMIN([DISTINCT] expr)\n\nDescription\n-----------\n\nReturns the minimum value of expr. MIN() may take a string argument, in which\ncase it returns the minimum string value. The DISTINCT keyword can be used to\nfind the minimum of the distinct values of expr, however, this produces the\nsame result as omitting DISTINCT.\n\nNote that SET and ENUM fields are currently compared by their string value\nrather than their relative position in the set, so MIN() may produce a\ndifferent lowest result than ORDER BY ASC.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nMIN() can be used as a window function.\n\nMIN() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT name, MIN(score) FROM student GROUP BY name;\n+---------+------------+\n| name    | MIN(score) |\n+---------+------------+\n| Chun    |         73 |\n| Esben   |         31 |\n| Kaolin  |         56 |\n| Tatiana |         83 |\n+---------+------------+\n\nMIN() with a string:\n\nSELECT MIN(name) FROM student;\n+-----------+\n| MIN(name) |\n+-----------+\n| Chun      |\n+-----------+\n\nBe careful to avoid this common mistake, not grouping correctly and returning\nmismatched data:\n\nSELECT name,test,MIN(score) FROM student;\n+------+------+------------+\n| name | test | MIN(score) |\n+------+------+------------+\n| Chun | SQL  |         31 |\n+------+------+------------+\n\nDifference between ORDER BY ASC and MIN():\n\nCREATE TABLE student2(name CHAR(10),grade ENUM(\'b\',\'c\',\'a\'));\n\nINSERT INTO student2 VALUES(\'Chun\',\'b\'),(\'Esben\',\'c\'),(\'Kaolin\',\'a\');\n\nSELECT MIN(grade) FROM student2;\n+------------+\n| MIN(grade) |\n+------------+\n| a          |\n+------------+\n\nSELECT grade FROM student2 ORDER BY grade ASC LIMIT 1;\n+-------+\n| grade |\n+-------+\n| b     |\n+-------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, MIN(score) \n OVER (PARTITION BY name) AS lowest_score FROM student_test;\n+---------+--------+-------+--------------+\n| name    | test   | score | lowest_score |\n+---------+--------+-------+--------------+\n| Chun    | SQL    |    75 |           73 |\n| Chun    | Tuning |    73 |           73 |\n| Esben   | SQL    |    43 |           31 |\n| Esben   | Tuning |    31 |           31 |\n| Kaolin  | SQL    |    56 |           56 |\n| Kaolin  | Tuning |    88 |           56 |\n| Tatiana | SQL    |    87 |           87 |\n+---------+--------+-------+--------------+\n\nURL: https://mariadb.com/kb/en/min/','','https://mariadb.com/kb/en/min/'),(181,'STD',16,'Syntax\n------\n\nSTD(expr)\n\nDescription\n-----------\n\nReturns the population standard deviation of expr. This is an extension to\nstandard SQL. The standard SQL function STDDEV_POP() can be used instead.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nSTD() can be used as a window function.\n\nThis function returns NULL if there were no matching rows.\n\nExamples\n--------\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, STDDEV_POP(score) \n OVER (PARTITION BY test) AS stddev_results FROM student_test;\n+---------+--------+-------+----------------+\n| name    | test   | score | stddev_results |\n+---------+--------+-------+----------------+\n| Chun    | SQL    |    75 |        16.9466 |\n| Chun    | Tuning |    73 |        24.1247 |\n| Esben   | SQL    |    43 |        16.9466 |\n| Esben   | Tuning |    31 |        24.1247 |\n| Kaolin  | SQL    |    56 |        16.9466 |\n| Kaolin  | Tuning |    88 |        24.1247 |\n| Tatiana | SQL    |    87 |        16.9466 |\n+---------+--------+-------+----------------+\n\nURL: https://mariadb.com/kb/en/std/','','https://mariadb.com/kb/en/std/'),(319,'MULTILINESTRING',25,'Syntax\n------\n\nMultiLineString(ls1,ls2,...)\n\nDescription\n-----------\n\nConstructs a WKB MultiLineString value using WKB LineString arguments. If any\nargument is not a WKB LineString, the return value is NULL.\n\nExample\n-------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nINSERT INTO gis_multi_line VALUES\n (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16 23,16\n48))\')),\n (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n (MLineFromWKB(AsWKB(MultiLineString(LineString(Point(1, 2), \n  Point(3, 5)), LineString(Point(2, 5),Point(5, 8),Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/multilinestring/','','https://mariadb.com/kb/en/multilinestring/'),(320,'MULTIPOINT',25,'Syntax\n------\n\nMultiPoint(pt1,pt2,...)\n\nDescription\n-----------\n\nConstructs a WKB MultiPoint value using WKB Point arguments. If any argument\nis not a WKB Point, the return value is NULL.\n\nExamples\n--------\n\nSET @g = ST_GEOMFROMTEXT(\'MultiPoint( 1 1, 2 2, 5 3, 7 2, 9 3, 8 4, 6 6, 6 9,\n4 9, 1 5 )\');\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/multipoint/','','https://mariadb.com/kb/en/multipoint/'),(322,'POINT',25,'Syntax\n------\n\nPoint(x,y)\n\nDescription\n-----------\n\nConstructs a WKB Point using the given coordinates.\n\nExamples\n--------\n\nSET @g = ST_GEOMFROMTEXT(\'Point(1 1)\');\n\nCREATE TABLE gis_point  (g POINT);\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/point/','','https://mariadb.com/kb/en/point/'),(323,'PointOnSurface',25,'A synonym for ST_PointOnSurface.\n\nURL: https://mariadb.com/kb/en/pointonsurface/','','https://mariadb.com/kb/en/pointonsurface/'),(327,'ST_INTERSECTION',25,'Syntax\n------\n\nST_INTERSECTION(g1,g2)\n\nDescription\n-----------\n\nReturns a geometry that is the intersection, or shared portion, of geometry g1\nand geometry g2.\n\nExamples\n--------\n\nSET @g1 = ST_GEOMFROMTEXT(\'POINT(2 1)\');\n\nSET @g2 = ST_GEOMFROMTEXT(\'LINESTRING(2 1, 0 2)\');\n\nSELECT ASTEXT(ST_INTERSECTION(@g1,@g2));\n+----------------------------------+\n| ASTEXT(ST_INTERSECTION(@g1,@g2)) |\n+----------------------------------+\n| POINT(2 1)                       |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/st_intersection/','','https://mariadb.com/kb/en/st_intersection/'),(182,'STDDEV',16,'Syntax\n------\n\nSTDDEV(expr)\n\nDescription\n-----------\n\nReturns the population standard deviation of expr. This function is provided\nfor compatibility with Oracle. The standard SQL function STDDEV_POP() can be\nused instead.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nSTDDEV() can be used as a window function.\n\nThis function returns NULL if there were no matching rows.\n\nExamples\n--------\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, STDDEV_POP(score) \n OVER (PARTITION BY test) AS stddev_results FROM student_test;\n+---------+--------+-------+----------------+\n| name    | test   | score | stddev_results |\n+---------+--------+-------+----------------+\n| Chun    | SQL    |    75 |        16.9466 |\n| Chun    | Tuning |    73 |        24.1247 |\n| Esben   | SQL    |    43 |        16.9466 |\n| Esben   | Tuning |    31 |        24.1247 |\n| Kaolin  | SQL    |    56 |        16.9466 |\n| Kaolin  | Tuning |    88 |        24.1247 |\n| Tatiana | SQL    |    87 |        16.9466 |\n+---------+--------+-------+----------------+\n\nURL: https://mariadb.com/kb/en/stddev/','','https://mariadb.com/kb/en/stddev/'),(183,'STDDEV_POP',16,'Syntax\n------\n\nSTDDEV_POP(expr)\n\nDescription\n-----------\n\nReturns the population standard deviation of expr (the square root of\nVAR_POP()). You can also use STD() or STDDEV(), which are equivalent but not\nstandard SQL.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nSTDDEV_POP() can be used as a window function.\n\nSTDDEV_POP() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, STDDEV_POP(score) \n OVER (PARTITION BY test) AS stddev_results FROM student_test;\n+---------+--------+-------+----------------+\n| name    | test   | score | stddev_results |\n+---------+--------+-------+----------------+\n| Chun    | SQL    |    75 |        16.9466 |\n| Chun    | Tuning |    73 |        24.1247 |\n| Esben   | SQL    |    43 |        16.9466 |\n| Esben   | Tuning |    31 |        24.1247 |\n| Kaolin  | SQL    |    56 |        16.9466 |\n| Kaolin  | Tuning |    88 |        24.1247 |\n| Tatiana | SQL    |    87 |        16.9466 |\n+---------+--------+-------+----------------+\n\nURL: https://mariadb.com/kb/en/stddev_pop/','','https://mariadb.com/kb/en/stddev_pop/'),(185,'SUM',16,'Syntax\n------\n\nSUM([DISTINCT] expr)\n\nDescription\n-----------\n\nReturns the sum of expr. If the return set has no rows, SUM() returns NULL.\nThe DISTINCT keyword can be used to sum only the distinct values of expr.\n\nSUM() can be used as a window function, although not with the DISTINCT\nspecifier.\n\nExamples\n--------\n\nCREATE TABLE sales (sales_value INT);\nINSERT INTO sales VALUES(10),(20),(20),(40);\n\nSELECT SUM(sales_value) FROM sales;\n+------------------+\n| SUM(sales_value) |\n+------------------+\n|               90 |\n+------------------+\n\nSELECT SUM(DISTINCT(sales_value)) FROM sales;\n+----------------------------+\n| SUM(DISTINCT(sales_value)) |\n+----------------------------+\n|                         70 |\n+----------------------------+\n\nCommonly, SUM is used with a GROUP BY clause:\n\nCREATE TABLE sales (name CHAR(10), month CHAR(10), units INT);\n\nINSERT INTO sales VALUES \n (\'Chun\', \'Jan\', 75), (\'Chun\', \'Feb\', 73),\n (\'Esben\', \'Jan\', 43), (\'Esben\', \'Feb\', 31),\n (\'Kaolin\', \'Jan\', 56), (\'Kaolin\', \'Feb\', 88),\n (\'Tatiana\', \'Jan\', 87), (\'Tatiana\', \'Feb\', 83);\n\nSELECT name, SUM(units) FROM sales GROUP BY name;\n+---------+------------+\n| name    | SUM(units) |\n+---------+------------+\n| Chun    |        148 |\n| Esben   |         74 |\n| Kaolin  |        144 |\n| Tatiana |        170 |\n+---------+------------+\n\nThe GROUP BY clause is required when using an aggregate function along with\nregular column data, otherwise the result will be a mismatch, as in the\nfollowing common type of mistake:\n\nSELECT name,SUM(units) FROM sales\n;+------+------------+\n| name | SUM(units) |\n+------+------------+\n| Chun |        536 |\n+------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, SUM(score) OVER (PARTITION BY name) AS total_score\nFROM student_test;\n+---------+--------+-------+-------------+\n| name    | test   | score | total_score |\n+---------+--------+-------+-------------+\n| Chun    | SQL    |    75 |         148 |\n| Chun    | Tuning |    73 |         148 |\n| Esben   | SQL    |    43 |          74 |\n| Esben   | Tuning |    31 |          74 |\n| Kaolin  | SQL    |    56 |         144 |\n| Kaolin  | Tuning |    88 |         144 |\n| Tatiana | SQL    |    87 |          87 |\n+---------+--------+-------+-------------+\n\nURL: https://mariadb.com/kb/en/sum/','','https://mariadb.com/kb/en/sum/'),(328,'ST_POINTONSURFACE',25,'MariaDB starting with 10.1.2\n----------------------------\nST_POINTONSURFACE() was introduced in MariaDB 10.1.2\n\nSyntax\n------\n\nST_PointOnSurface(g)\nPointOnSurface(g)\n\nDescription\n-----------\n\nGiven a geometry, returns a POINT guaranteed to intersect a surface. However,\nsee MDEV-7514.\n\nST_PointOnSurface() and PointOnSurface() are synonyms.\n\nURL: https://mariadb.com/kb/en/st_pointonsurface/','','https://mariadb.com/kb/en/st_pointonsurface/'),(339,'FLUSH',26,'Syntax\n------\n\nFLUSH [NO_WRITE_TO_BINLOG | LOCAL]\n  flush_option [, flush_option] ...\n\nor when flushing tables:\n\nFLUSH [NO_WRITE_TO_BINLOG | LOCAL] TABLES [table_list]  [table_flush_option]\n\nwhere table_list is a list of tables separated by , (comma).\n\nDescription\n-----------\n\nThe FLUSH statement clears or reloads various internal caches used by MariaDB.\nTo execute FLUSH, you must have the RELOAD privilege. See GRANT.\n\nThe RESET statement is similar to FLUSH. See RESET.\n\nYou cannot issue a FLUSH statement from within a stored function or a trigger.\nDoing so within a stored procedure is permitted, as long as it is not called\nby a stored function or trigger. See Stored Routine Limitations, Stored\nFunction Limitations and Trigger Limitations.\n\nIf a listed table is a view, an error like the following will be produced:\n\nERROR 1347 (HY000): \'test.v\' is not BASE TABLE\n\nBy default, FLUSH statements are written to the binary log and will be\nreplicated. The NO_WRITE_TO_BINLOG keyword (LOCAL is an alias) will ensure the\nstatement is not written to the binary log.\n\nThe different flush options are:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| CHANGED_PAGE_BITMAPS      | XtraDB only. Internal command used for backup  |\n|                           | purposes. See the Information Schema           |\n|                           | CHANGED_PAGE_BITMAPS Table.                    |\n+---------------------------+------------------------------------------------+\n| CLIENT_STATISTICS         | Reset client statistics (see SHOW              |\n|                           | CLIENT_STATISTICS).                            |\n+---------------------------+------------------------------------------------+\n| DES_KEY_FILE              | Reloads the DES key file (Specified with the   |\n|                           | --des-key-file startup option).                |\n+---------------------------+------------------------------------------------+\n| HOSTS                     | Flush the hostname cache (used for converting  |\n|                           | ip to host names and for unblocking blocked    |\n|                           | hosts. See max_connect_errors and              |\n|                           | performance_schema.host_cache                  |\n+---------------------------+------------------------------------------------+\n| INDEX_STATISTICS          | Reset index statistics (see SHOW               |\n|                           | INDEX_STATISTICS).                             |\n+---------------------------+------------------------------------------------+\n| [ERROR | ENGINE |         | Close and reopen the specified log type, or    |\n| GENERAL | SLOW | BINARY   | all log types if none are specified. FLUSH     |\n| | RELAY] LOGS             | RELAY LOGS [connection-name] can be used to    |\n|                           | flush the relay logs for a specific            |\n|                           | connection. Only one connection can be         |\n|                           | specified per FLUSH command. See Multi-source  |\n|                           | replication. FLUSH ENGINE LOGS will delete     |\n|                           | all unneeded Aria redo logs. Since MariaDB     |\n|                           | 10.1.30 and MariaDB 10.2.11, FLUSH BINARY      |\n|                           | LOGS DELETE_DOMAIN_ID=(list-of-domains) can    |\n|                           | be used to discard obsolete GTID domains from  |\n|                           | the server\'s binary log state. In order for    |\n|                           | this to be successful, no event group from     |\n|                           | the listed GTID domains can be present in      |\n|                           | existing binary log files. If some still       |\n|                           | exist, then they must be purged prior to       |\n|                           | executing this command. If the command         |\n|                           | completes successfully, then it also rotates   |\n|                           | the binary log.                                |\n+---------------------------+------------------------------------------------+\n| MASTER                    | Deprecated option, use RESET MASTER instead.   |\n+---------------------------+------------------------------------------------+\n| PRIVILEGES                | Reload all privileges from the privilege       |\n|                           | tables in the mysql database. If the server    |\n|                           | is started with --skip-grant-table option,     |\n|                           | this will activate the privilege tables again. |\n+---------------------------+------------------------------------------------+\n| QUERY CACHE               | Defragment the query cache to better utilize   |\n|                           | its memory. If you want to reset the query     |\n|                           | cache, you can do it with RESET QUERY CACHE.   |\n+---------------------------+------------------------------------------------+\n| QUERY_RESPONSE_TIME       | See the QUERY_RESPONSE_TIME plugin.            |\n+---------------------------+------------------------------------------------+\n| SLAVE                     | Deprecated option, use RESET REPLICA or RESET  |\n|                           | SLAVE instead.                                 |\n+---------------------------+------------------------------------------------+\n| SSL                       | Used to dynamically reinitialize the server\'s  |\n|                           | TLS context by reloading the files defined by  |\n|                           | several TLS system variables. See FLUSH SSL    |\n|                           | for more information. This command was first   |\n|                           | added in MariaDB 10.4.1.                       |\n+---------------------------+------------------------------------------------+\n| STATUS                    | Resets all server status variables that can    |\n|                           | be reset to 0. Not all global status           |\n|                           | variables support this, so not all global      |\n|                           | values are reset. See FLUSH STATUS for more    |\n|                           | information.                                   |\n+---------------------------+------------------------------------------------+\n| TABLE                     | Close tables given as options or all open      |\n|                           | tables if no table list was used. From         |\n|                           | MariaDB 10.4.1, using without any table list   |\n|                           | will only close tables not in use, and tables  |\n|                           | not locked by the FLUSH TABLES connection. If  |\n|                           | there are no locked tables, FLUSH TABLES will  |\n|                           | be instant and will not cause any waits, as    |\n|                           | it no longer waits for tables in use. When a   |\n|                           | table list is provided, from MariaDB 10.4.1,   |\n|                           | the server will wait for the end of any        |\n|                           | transactions that are using the tables.        |\n|                           | Previously, FLUSH TABLES only waited for the   |\n|                           | statements to complete.                        |\n+---------------------------+------------------------------------------------+\n| TABLES                    | Same as FLUSH TABLE.                           |\n+---------------------------+------------------------------------------------+\n| TABLES ... FOR EXPORT     | For InnoDB tables, flushes table changes to    |\n|                           | disk to permit binary table copies while the   |\n|                           | server is running. See FLUSH TABLES ... FOR    |\n|                           | EXPORT for more.                               |\n+---------------------------+------------------------------------------------+\n| TABLES WITH READ LOCK     | Closes all open tables. New tables are only    |\n|                           | allowed to be opened with read locks until an  |\n|                           | UNLOCK TABLES is given.                        |\n+---------------------------+------------------------------------------------+\n| TABLES WITH READ LOCK     | As TABLES WITH READ LOCK but also disable all  |\n| AND DISABLE CHECKPOINT    | checkpoint writes by transactional table       |\n|                           | engines. This is useful when doing a disk      |\n|                           | snapshot of all tables.                        |\n+---------------------------+------------------------------------------------+\n| TABLE_STATISTICS          | Reset table statistics (see SHOW               |\n|                           | TABLE_STATISTICS).                             |\n+---------------------------+------------------------------------------------+\n| USER_RESOURCES            | Resets all per hour user resources. This       |\n|                           | enables clients that have exhausted their      |\n|                           | resources to connect again.                    |\n+---------------------------+------------------------------------------------+\n| USER_STATISTICS           | Reset user statistics (see SHOW                |\n|                           | USER_STATISTICS).                              |\n+---------------------------+------------------------------------------------+\n| USER_VARIABLES            | Reset user variables (see User-defined         |\n|                           | variables).                                    |\n+---------------------------+------------------------------------------------+\n\nYou can also use the mysqladmin client to flush things. Use mysqladmin --help\nto examine what flush commands it supports.\n\nFLUSH RELAY LOGS\n----------------\n\nFLUSH RELAY LOGS \'connection_name\';\n\nCompatibility with MySQL\n------------------------\n\nMariaDB starting with 10.7.0\n----------------------------\nThe FOR CHANNEL keyword was added for MySQL compatibility. This is identical\nas using the channel_name directly after the FLUSH command.\n\nFor example, one can now use:\n\nFLUSH RELAY LOGS FOR CHANNEL \'connection_name\';\n\nFLUSH STATUS\n------------\n\nServer status variables can be reset by executing the following:\n\nFLUSH STATUS;\n\nGlobal Status Variables that Support FLUSH STATUS\n-------------------------------------------------\n\nNot all global status variables support being reset by FLUSH STATUS.\nCurrently, the following status variables are reset by FLUSH STATUS:\n\n* Aborted_clients\n* Aborted_connects\n* Binlog_cache_disk_use\n* Binlog_cache_use\n* Binlog_stmt_cache_disk_use\n* Binlog_stmt_cache_use\n* Connection_errors_accept\n* Connection_errors_internal\n* Connection_errors_max_connections\n* Connection_errors_peer_address\n* Connection_errors_select\n* Connection_errors_tcpwrap\n* Created_tmp_files\n* Delayed_errors\n* Delayed_writes\n* Feature_check_constraint\n* Feature_delay_key_write\n* Max_used_connections\n* Opened_plugin_libraries\n* Performance_schema_accounts_lost\n* Performance_schema_cond_instances_lost\n* Performance_schema_digest_lost\n* Performance_schema_file_handles_lost\n* Performance_schema_file_instances_lost\n* Performance_schema_hosts_lost\n* Performance_schema_locker_lost\n* Performance_schema_mutex_instances_lost\n* Performance_schema_rwlock_instances_lost\n* Performance_schema_session_connect_attrs_lost\n* Performance_schema_socket_instances_lost\n* Performance_schema_stage_classes_lost\n* Performance_schema_statement_classes_lost\n* Performance_schema_table_handles_lost\n* Performance_schema_table_instances_lost\n* Performance_schema_thread_instances_lost\n* Performance_schema_users_lost\n* Qcache_hits\n* Qcache_inserts\n* Qcache_lowmem_prunes\n* Qcache_not_cached\n* Rpl_semi_sync_master_no_times\n* Rpl_semi_sync_master_no_tx\n* Rpl_semi_sync_master_timefunc_failures\n* Rpl_semi_sync_master_wait_pos_backtraverse\n* Rpl_semi_sync_master_yes_tx\n* Rpl_transactions_multi_engine\n* Server_audit_writes_failed\n* Slave_retried_transactions\n* Slow_launch_threads\n* Ssl_accept_renegotiates\n* Ssl_accepts\n* Ssl_callback_cache_hits\n* Ssl_client_connects\n* Ssl_connect_renegotiates\n* Ssl_ctx_verify_depth\n* Ssl_ctx_verify_mode\n* Ssl_finished_accepts\n* Ssl_finished_connects\n* Ssl_session_cache_hits\n* Ssl_session_cache_misses\n* Ssl_session_cache_overflows\n* Ssl_session_cache_size\n* Ssl_session_cache_timeouts\n* Ssl_sessions_reused\n* Ssl_used_session_cache_entries\n* Subquery_cache_hit\n* Subquery_cache_miss\n* Table_locks_immediate\n* Table_locks_waited\n* Tc_log_max_pages_used\n* Tc_log_page_waits\n* Transactions_gtid_foreign_engine\n* Transactions_multi_engine\n\nThe different usage of FLUSH TABLES\n-----------------------------------\n\nThe purpose of FLUSH TABLES\n---------------------------\n\nThe purpose of FLUSH TABLES is to clean up the open table cache and table\ndefinition cache from not in use tables. This frees up memory and file\ndescriptors. Normally this is not needed as the caches works on a FIFO bases,\nbut can be useful if the server seams to use up to much memory for some reason.\n\nThe purpose of FLUSH TABLES WITH READ LOCK \n-------------------------------------------\n\nFLUSH TABLES WITH READ LOCK is useful if you want to take a backup of some\ntables. When FLUSH TABLES WITH READ LOCK returns, all write access to tables\nare blocked and all tables are marked as \'properly closed\' on disk. The tables\ncan still be used for read operations.\n\nThe purpose of FLUSH TABLES table_list\n--------------------------------------\n\nFLUSH TABLES table_list is useful if you want to copy a table object/files to\nor from the server. This command puts a lock that stops new users of the table\nand will wait until everyone has stopped using the table. The table is then\nremoved from the table definition and table cache.\n\nNote that it\'s up to the user to ensure that no one is accessing the table\nbetween FLUSH TABLES and the table is copied to or from the server. This can\nbe secured by using LOCK TABLES.\n\nIf there are any tables locked by the connection that is using FLUSH TABLES\nall the locked tables will be closed as part of the flush and reopened and\nrelocked before FLUSH TABLES returns. This allows one to copy the table after\nFLUSH TABLES returns without having any writes on the table. For now this\nworks works with most tables, except InnoDB as InnoDB may do background purges\non the table even while it\'s write locked.\n\nThe purpose of FLUSH TABLES table_list WITH READ LOCK\n-----------------------------------------------------\n\nFLUSH TABLES table_list WITH READ LOCK should work as FLUSH TABLES WITH READ\nLOCK, but only those tables that are listed will be properly closed. However\nin practice this works exactly like FLUSH TABLES WITH READ LOCK as the FLUSH\ncommand has anyway to wait for all WRITE operations to end because we are\ndepending on a global read lock for this code. In the future we should\nconsider fixing this to instead use meta data locks.\n\nImplementation of FLUSH TABLES commands in MariaDB 10.4.8 and above\n-------------------------------------------------------------------\n\nImplementation of FLUSH TABLES\n------------------------------\n\n* Free memory and file descriptors not in use\n\nImplementation of FLUSH TABLES WITH READ LOCK\n---------------------------------------------\n\n* Lock all tables read only for simple old style backup.\n* All background writes are suspended and tables are marked as closed.\n* No statement requiring table changes are allowed for any user until UNLOCK\nTABLES.\n\nInstead of using FLUSH TABLE WITH READ LOCK one should in most cases instead\nuse BACKUP STAGE BLOCK_COMMIT.\n\nImplementation of FLUSH TABLES table_list\n-----------------------------------------\n\n* Free memory and file descriptors for tables not in use from table list.\n* Lock given tables as read only.\n* Wait until all translations has ended that uses any of the given tables.\n* Wait until all background writes are suspended and tables are marked as\nclosed.\n\nImplementation of FLUSH TABLES table_list FOR EXPORT\n----------------------------------------------------\n\n* Free memory and file descriptors for tables not in use from table list\n* Lock given tables as read.\n* Wait until all background writes are suspended and tables are marked as\nclosed.\n* Check that all tables supports FOR EXPORT\n* No changes to these tables allowed until UNLOCK TABLES\n\nThis is basically the same behavior as in old MariaDB version if one first\nlock the tables, then do FLUSH TABLES. The tables will be copyable until\nUNLOCK TABLES.\n\nFLUSH SSL\n---------\n\nMariaDB starting with 10.4\n--------------------------\nThe FLUSH SSL command was first added in MariaDB 10.4.\n\nIn MariaDB 10.4 and later, the FLUSH SSL command can be used to dynamically\nreinitialize the server\'s TLS context. This is most useful if you need to\nreplace a certificate that is about to expire without restarting the server.\n\nThis operation is performed by reloading the files defined by the following\nTLS system variables:\n\n* ssl_cert\n* ssl_key\n* ssl_ca\n* ssl_capath\n* ssl_crl\n* ssl_crlpath\n\nThese TLS system variables are not dynamic, so their values can not be changed\nwithout restarting the server.\n\nIf you want to dynamically reinitialize the server\'s TLS context, then you\nneed to change the certificate and key files at the relevant paths defined by\nthese TLS system variables, without actually changing the values of the\nvariables. See MDEV-19341 for more information.\n\nReducing Memory Usage\n---------------------\n\nTo flush some of the global caches that take up memory, you could execute the\nfollowing command:\n\nFLUSH LOCAL HOSTS,\n QUERY CACHE,\n TABLE_STATISTICS,\n INDEX_STATISTICS,\n USER_STATISTICS;\n\nURL: https://mariadb.com/kb/en/flush/','','https://mariadb.com/kb/en/flush/'),(340,'FLUSH QUERY CACHE',26,'Description\n-----------\n\nYou can defragment the query cache to better utilize its memory with the FLUSH\nQUERY CACHE statement. The statement does not remove any queries from the\ncache.\n\nThe RESET QUERY CACHE statement removes all query results from the query\ncache. The FLUSH TABLES statement also does this.\n\nURL: https://mariadb.com/kb/en/flush-query-cache/','','https://mariadb.com/kb/en/flush-query-cache/'),(186,'VARIANCE',16,'Syntax\n------\n\nVARIANCE(expr)\n\nDescription\n-----------\n\nReturns the population standard variance of expr. This is an extension to\nstandard SQL. The standard SQL function VAR_POP() can be used instead.\n\nVariance is calculated by\n\n* working out the mean for the set\n* for each number, subtracting the mean and squaring the result\n* calculate the average of the resulting differences\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nVARIANCE() can be used as a window function.\n\nVARIANCE() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nCREATE TABLE v(i tinyint);\n\nINSERT INTO v VALUES(101),(99);\n\nSELECT VARIANCE(i) FROM v;\n+-------------+\n| VARIANCE(i) |\n+-------------+\n|      1.0000 |\n+-------------+\n\nINSERT INTO v VALUES(120),(80);\n\nSELECT VARIANCE(i) FROM v;\n+-------------+\n| VARIANCE(i) |\n+-------------+\n|    200.5000 |\n+-------------+\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, VAR_POP(score) \n OVER (PARTITION BY test) AS variance_results FROM student_test;\n+---------+--------+-------+------------------+\n| name    | test   | score | variance_results |\n+---------+--------+-------+------------------+\n| Chun    | SQL    |    75 |         287.1875 |\n| Chun    | Tuning |    73 |         582.0000 |\n| Esben   | SQL    |    43 |         287.1875 |\n| Esben   | Tuning |    31 |         582.0000 |\n| Kaolin  | SQL    |    56 |         287.1875 |\n| Kaolin  | Tuning |    88 |         582.0000 |\n| Tatiana | SQL    |    87 |         287.1875 |\n+---------+--------+-------+------------------+\n\nURL: https://mariadb.com/kb/en/variance/','','https://mariadb.com/kb/en/variance/'),(187,'VAR_POP',16,'Syntax\n------\n\nVAR_POP(expr)\n\nDescription\n-----------\n\nReturns the population standard variance of expr. It considers rows as the\nwhole population, not as a sample, so it has the number of rows as the\ndenominator. You can also use VARIANCE(), which is equivalent but is not\nstandard SQL.\n\nVariance is calculated by\n\n* working out the mean for the set\n* for each number, subtracting the mean and squaring the result\n* calculate the average of the resulting differences\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nVAR_POP() can be used as a window function.\n\nVAR_POP() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nCREATE TABLE v(i tinyint);\n\nINSERT INTO v VALUES(101),(99);\n\nSELECT VAR_POP(i) FROM v;\n+------------+\n| VAR_POP(i) |\n+------------+\n|     1.0000 |\n+------------+\n\nINSERT INTO v VALUES(120),(80);\n\nSELECT VAR_POP(i) FROM v;\n+------------+\n| VAR_POP(i) |\n+------------+\n|   200.5000 |\n+------------+\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, VAR_POP(score) \n OVER (PARTITION BY test) AS variance_results FROM student_test;\n+---------+--------+-------+------------------+\n| name    | test   | score | variance_results |\n+---------+--------+-------+------------------+\n| Chun    | SQL    |    75 |         287.1875 |\n| Esben   | SQL    |    43 |         287.1875 |\n| Kaolin  | SQL    |    56 |         287.1875 |\n| Tatiana | SQL    |    87 |         287.1875 |\n| Chun    | Tuning |    73 |         582.0000 |\n| Esben   | Tuning |    31 |         582.0000 |\n| Kaolin  | Tuning |    88 |         582.0000 |\n+---------+--------+-------+------------------+\n\nURL: https://mariadb.com/kb/en/var_pop/','','https://mariadb.com/kb/en/var_pop/'),(343,'SHOW SLAVE STATUS',26,'Syntax\n------\n\nSHOW SLAVE [\"connection_name\"] STATUS [FOR CHANNEL \"connection_name\"]\nSHOW REPLICA [\"connection_name\"] STATUS -- From MariaDB 10.5.1\n\nor\n\nSHOW ALL SLAVES STATUS\nSHOW ALL REPLICAS STATUS -- From MariaDB 10.5.1\n\nDescription\n-----------\n\nThis statement is to be run on a replica and provides status information on\nessential parameters of the replica threads.\n\nThis statement requires the SUPER privilege, the REPLICATION_CLIENT privilege,\nor, from MariaDB 10.5.2, the REPLICATION SLAVE ADMIN privilege, or, from\nMariaDB 10.5.9, the REPLICA MONITOR privilege.\n\nMulti-Source\n------------\n\nThe ALL and \"connection_name\" options allow you to connect to many primaries\nat the same time.\n\nALL SLAVES (or ALL REPLICAS from MariaDB 10.5.1) gives you a list of all\nconnections to the primary nodes.\n\nThe rows will be sorted according to Connection_name.\n\nIf you specify a connection_name, you only get the information about that\nconnection. If connection_name is not used, then the name set by\ndefault_master_connection is used. If the connection name doesn\'t exist you\nwill get an error: There is no master connection for \'xxx\'.\n\nMariaDB starting with 10.7.0\n----------------------------\nThe FOR CHANNEL keyword was added for MySQL compatibility. This is identical\nas using the channel_name directly after SHOW SLAVE.\n\nColumn Descriptions\n-------------------\n\n+---------------+---------------------------------------+-------------------+\n| Name          | Description                           | Added             |\n+---------------+---------------------------------------+-------------------+\n| Connection_na | Name of the primary connection.       |                   |\n| e             | Returned with SHOW ALL SLAVES STATUS  |                   |\n|               | (or SHOW ALL REPLICAS STATUS from     |                   |\n|               | MariaDB 10.5.1) only.                 |                   |\n+---------------+---------------------------------------+-------------------+\n| Slave_SQL_Sta | State of SQL thread. Returned with    |                   |\n| e             | SHOW ALL SLAVES STATUS (or SHOW ALL   |                   |\n|               | REPLICAS STATUS from MariaDB 10.5.1)  |                   |\n|               | only. See Slave SQL Thread States.    |                   |\n+---------------+---------------------------------------+-------------------+\n| Slave_IO_Stat | State of I/O thread. See Slave I/O    |                   |\n|               | Thread States.                        |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_host   | Master host that the replica is       |                   |\n|               | connected to.                         |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_user   | Account user name being used to       |                   |\n|               | connect to the primary.               |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_port   | The port being used to connect to     |                   |\n|               | the primary.                          |                   |\n+---------------+---------------------------------------+-------------------+\n| Connect_Retry | Time in seconds between retries to    |                   |\n|               | connect. The default is 60. The       |                   |\n|               | CHANGE MASTER TO statement can set    |                   |\n|               | this. The master-retry-count option   |                   |\n|               | determines the maximum number of      |                   |\n|               | reconnection attempts.                |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_Log_Fi | Name of the primary binary log file   |                   |\n| e             | that the I/O thread is currently      |                   |\n|               | reading from.                         |                   |\n+---------------+---------------------------------------+-------------------+\n| Read_Master_L | Position up to which the I/O thread   |                   |\n| g_Pos         | has read in the current primary       |                   |\n|               | binary log file.                      |                   |\n+---------------+---------------------------------------+-------------------+\n| Relay_Log_Fil | Name of the relay log file that the   |                   |\n|               | SQL thread is currently processing.   |                   |\n+---------------+---------------------------------------+-------------------+\n| Relay_Log_Pos | Position up to which the SQL thread   |                   |\n|               | has finished processing in the        |                   |\n|               | current relay log file.               |                   |\n+---------------+---------------------------------------+-------------------+\n| Relay_Master_ | Name of the primary binary log file   |                   |\n| og_File       | that contains the most recent event   |                   |\n|               | executed by the SQL thread.           |                   |\n+---------------+---------------------------------------+-------------------+\n| Slave_IO_Runn | Whether the replica I/O thread is     |                   |\n| ng            | running and connected (Yes), running  |                   |\n|               | but not connected to a primary        |                   |\n|               | (Connecting) or not running (No).     |                   |\n+---------------+---------------------------------------+-------------------+\n| Slave_SQL_Run | Whether or not the SQL thread is      |                   |\n| ing           | running.                              |                   |\n+---------------+---------------------------------------+-------------------+\n| Replicate_Do_ | Databases specified for replicating   |                   |\n| B             | with the replicate_do_db option.      |                   |\n+---------------+---------------------------------------+-------------------+\n| Replicate_Ign | Databases specified for ignoring      |                   |\n| re_DB         | with the replicate_ignore_db option.  |                   |\n+---------------+---------------------------------------+-------------------+\n| Replicate_Do_ | Tables specified for replicating      |                   |\n| able          | with the replicate_do_table option.   |                   |\n+---------------+---------------------------------------+-------------------+\n| Replicate_Ign | Tables specified for ignoring with    |                   |\n| re_Table      | the replicate_ignore_table option.    |                   |\n+---------------+---------------------------------------+-------------------+\n| Replicate_Wil | Tables specified for replicating      |                   |\n| _Do_Table     | with the replicate_wild_do_table      |                   |\n|               | option.                               |                   |\n+---------------+---------------------------------------+-------------------+\n| Replicate_Wil | Tables specified for ignoring with    |                   |\n| _Ignore_Table | the replicate_wild_ignore_table       |                   |\n|               | option.                               |                   |\n+---------------+---------------------------------------+-------------------+\n| Last_Errno    | Alias for Last_SQL_Errno (see below)  |                   |\n+---------------+---------------------------------------+-------------------+\n| Last Error    | Alias for Last_SQL_Error (see below)  |                   |\n+---------------+---------------------------------------+-------------------+\n| Skip_Counter  | Number of events that a replica       |                   |\n|               | skips from the master, as recorded    |                   |\n|               | in the sql_slave_skip_counter system  |                   |\n|               | variable.                             |                   |\n+---------------+---------------------------------------+-------------------+\n| Exec_Master_L | Position up to which the SQL thread   |                   |\n| g_Pos         | has processed in the current master   |                   |\n|               | binary log file. Can be used to       |                   |\n|               | start a new replica from a current    |                   |\n|               | replica with the CHANGE MASTER TO     |                   |\n|               | ... MASTER_LOG_POS option.            |                   |\n+---------------+---------------------------------------+-------------------+\n| Relay_Log_Spa | Total size of all relay log files     |                   |\n| e             | combined.                             |                   |\n+---------------+---------------------------------------+-------------------+\n| Until_Conditi |                                       |                   |\n| n             |                                       |                   |\n+---------------+---------------------------------------+-------------------+\n| Until_Log_Fil | The MASTER_LOG_FILE value of the      |                   |\n|               | START SLAVE UNTIL condition.          |                   |\n+---------------+---------------------------------------+-------------------+\n| Until_Log_Pos | The MASTER_LOG_POS value of the       |                   |\n|               | START SLAVE UNTIL condition.          |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_SSL_Al | Whether an SSL connection is          |                   |\n| owed          | permitted (Yes), not permitted (No)   |                   |\n|               | or permitted but without the replica  |                   |\n|               | having SSL support enabled (Ignored)  |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_SSL_CA | The MASTER_SSL_CA option of the       |                   |\n| File          | CHANGE MASTER TO statement.           |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_SSL_CA | The MASTER_SSL_CAPATH option of the   |                   |\n| Path          | CHANGE MASTER TO statement.           |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_SSL_Ce | The MASTER_SSL_CERT option of the     |                   |\n| t             | CHANGE MASTER TO statement.           |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_SSL_Ci | The MASTER_SSL_CIPHER option of the   |                   |\n| her           | CHANGE MASTER TO statement.           |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_SSL_Ke | The MASTER_SSL_KEY option of the      |                   |\n|               | CHANGE MASTER TO statement.           |                   |\n+---------------+---------------------------------------+-------------------+\n| Seconds_Behin | Difference between the timestamp      |                   |\n| _Master       | logged on the master for the event    |                   |\n|               | that the replica is currently         |                   |\n|               | processing, and the current           |                   |\n|               | timestamp on the replica. Zero if     |                   |\n|               | the replica is not currently          |                   |\n|               | processing an event. With parallel    |                   |\n|               | replication, seconds_behind_master    |                   |\n|               | is updated only after transactions    |                   |\n|               | commit.                               |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_SSL_Ve | The MASTER_SSL_VERIFY_SERVER_CERT     |                   |\n| ify_Server_Ce | option of the CHANGE MASTER TO        |                   |\n| t             | statement.                            |                   |\n+---------------+---------------------------------------+-------------------+\n| Last_IO_Errno | Error code of the most recent error   |                   |\n|               | that caused the I/O thread to stop    |                   |\n|               | (also recorded in the replica\'s       |                   |\n|               | error log). 0 means no error. RESET   |                   |\n|               | SLAVE or RESET MASTER will reset      |                   |\n|               | this value.                           |                   |\n+---------------+---------------------------------------+-------------------+\n| Last_IO_Error | Error message of the most recent      |                   |\n|               | error that caused the I/O thread to   |                   |\n|               | stop (also recorded in the replica\'s  |                   |\n|               | error log). An empty string means no  |                   |\n|               | error. RESET SLAVE or RESET MASTER    |                   |\n|               | will reset this value.                |                   |\n+---------------+---------------------------------------+-------------------+\n| Last_SQL_Errn | Error code of the most recent error   |                   |\n|               | that caused the SQL thread to stop    |                   |\n|               | (also recorded in the replica\'s       |                   |\n|               | error log). 0 means no error. RESET   |                   |\n|               | SLAVE or RESET MASTER will reset      |                   |\n|               | this value.                           |                   |\n+---------------+---------------------------------------+-------------------+\n| Last_SQL_Erro | Error message of the most recent      |                   |\n|               | error that caused the SQL thread to   |                   |\n|               | stop (also recorded in the replica\'s  |                   |\n|               | error log). An empty string means no  |                   |\n|               | error. RESET SLAVE or RESET MASTER    |                   |\n|               | will reset this value.                |                   |\n+---------------+---------------------------------------+-------------------+\n| Replicate_Ign | List of server_ids that are           |                   |\n| re_Server_Ids | currently being ignored for           |                   |\n|               | replication purposes, or an empty     |                   |\n|               | string for none, as specified in the  |                   |\n|               | IGNORE_SERVER_IDS option of the       |                   |\n|               | CHANGE MASTER TO statement.           |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_Server | The master\'s server_id value.         |                   |\n| Id            |                                       |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_SSL_Cr | The MASTER_SSL_CRL option of the      |                   |\n|               | CHANGE MASTER TO statement.           |                   |\n+---------------+---------------------------------------+-------------------+\n| Master_SSL_Cr | The MASTER_SSL_CRLPATH option of the  |                   |\n| path          | CHANGE MASTER TO statement.           |                   |\n+---------------+---------------------------------------+-------------------+\n| Using_Gtid    | Whether or not global transaction     |                   |\n|               | ID\'s are being used for replication   |                   |\n|               | (can be No, Slave_Pos, or             |                   |\n|               | Current_Pos).                         |                   |\n+---------------+---------------------------------------+-------------------+\n| Gtid_IO_Pos   | Current global transaction ID value.  |                   |\n+---------------+---------------------------------------+-------------------+\n| Retried_trans | Number of retried transactions for    |                   |\n| ctions        | this connection. Returned with SHOW   |                   |\n|               | ALL SLAVES STATUS only.               |                   |\n+---------------+---------------------------------------+-------------------+\n| Max_relay_log | Max relay log size for this           |                   |\n| size          | connection. Returned with SHOW ALL    |                   |\n|               | SLAVES STATUS only.                   |                   |\n+---------------+---------------------------------------+-------------------+\n| Executed_log_ | How many log entries the replica has  |                   |\n| ntries        | executed. Returned with SHOW ALL      |                   |\n|               | SLAVES STATUS only.                   |                   |\n+---------------+---------------------------------------+-------------------+\n| Slave_receive | How many heartbeats we have got from  |                   |\n| _heartbeats   | the master. Returned with SHOW ALL    |                   |\n|               | SLAVES STATUS only.                   |                   |\n+---------------+---------------------------------------+-------------------+\n| Slave_heartbe | How often to request a heartbeat      |                   |\n| t_period      | packet from the master (in seconds).  |                   |\n|               | Returned with SHOW ALL SLAVES STATUS  |                   |\n|               | only.                                 |                   |\n+---------------+---------------------------------------+-------------------+\n| Gtid_Slave_Po | GTID of the last event group          |                   |\n|               | replicated on a replica server, for   |                   |\n|               | each replication domain, as stored    |                   |\n|               | in the gtid_slave_pos system          |                   |\n|               | variable. Returned with SHOW ALL      |                   |\n|               | SLAVES STATUS only.                   |                   |\n+---------------+---------------------------------------+-------------------+\n| SQL_Delay     | Value specified by MASTER_DELAY in    | MariaDB 10.2.3    |\n|               | CHANGE MASTER (or 0 if none).         |                   |\n+---------------+---------------------------------------+-------------------+\n| SQL_Remaining | When the replica is delaying the      | MariaDB 10.2.3    |\n| Delay         | execution of an event due to          |                   |\n|               | MASTER_DELAY, this is the number of   |                   |\n|               | seconds of delay remaining before     |                   |\n|               | the event will be applied.            |                   |\n|               | Otherwise, the value is NULL.         |                   |\n+---------------+---------------------------------------+-------------------+\n| Slave_SQL_Run | The state of the SQL driver threads,  | MariaDB 10.2.3    |\n| ing_State     | same as in SHOW PROCESSLIST. When     |                   |\n|               | the replica is delaying the           |                   |\n|               | execution of an event due to          |                   |\n|               | MASTER_DELAY, this field displays:    |                   |\n|               | \"Waiting until MASTER_DELAY seconds   |                   |\n|               | after master executed event\".         |                   |\n+---------------+---------------------------------------+-------------------+\n| Slave_DDL_Gro | This status variable counts the       | MariaDB 10.3.7    |\n| ps            | occurrence of DDL statements.  This   |                   |\n|               | is a replica-side counter for         |                   |\n|               | optimistic parallel replication.      |                   |\n+---------------+---------------------------------------+-------------------+\n| Slave_Non_Tra | This status variable counts the       | MariaDB 10.3.7    |\n| sactional_Gro | occurrence of non-transactional       |                   |\n| ps            | event groups.  This is a              |                   |\n|               | replica-side counter for optimistic   |                   |\n|               | parallel replication.                 |                   |\n+---------------+---------------------------------------+-------------------+\n| Slave_Transac | This status variable counts the       | MariaDB 10.3.7    |\n| ional_Groups  | occurrence of transactional event     |                   |\n|               | groups.  This is a replica-side       |                   |\n|               | counter for optimistic parallel       |                   |\n|               | replication.                          |                   |\n+---------------+---------------------------------------+-------------------+\n\nSHOW REPLICA STATUS\n-------------------\n\nMariaDB starting with 10.5.1\n----------------------------\nSHOW REPLICA STATUS is an alias for SHOW SLAVE STATUS from MariaDB 10.5.1.\n\nExamples\n--------\n\nIf you issue this statement using the mysql client, you can use a \\G statement\nterminator rather than a semicolon to obtain a more readable vertical layout.\n\nSHOW SLAVE STATUS\\G\n*************************** 1. row ***************************\n       Slave_IO_State: Waiting for master to send event\n         Master_Host: db01.example.com\n         Master_User: replicant\n         Master_Port: 3306\n        Connect_Retry: 60\n       Master_Log_File: mariadb-bin.000010\n     Read_Master_Log_Pos: 548\n       Relay_Log_File: relay-bin.000004\n        Relay_Log_Pos: 837\n    Relay_Master_Log_File: mariadb-bin.000010\n      Slave_IO_Running: Yes\n      Slave_SQL_Running: Yes\n       Replicate_Do_DB:\n     Replicate_Ignore_DB:\n     Replicate_Do_Table:\n   Replicate_Ignore_Table:\n   Replicate_Wild_Do_Table:\n Replicate_Wild_Ignore_Table:\n         Last_Errno: 0\n         Last_Error:\n        Skip_Counter: 0\n     Exec_Master_Log_Pos: 548\n       Relay_Log_Space: 1497\n       Until_Condition: None\n       Until_Log_File:\n        Until_Log_Pos: 0\n     Master_SSL_Allowed: No\n     Master_SSL_CA_File:\n     Master_SSL_CA_Path:\n       Master_SSL_Cert:\n      Master_SSL_Cipher:\n       Master_SSL_Key:\n    Seconds_Behind_Master: 0\nMaster_SSL_Verify_Server_Cert: No\n        Last_IO_Errno: 0\n        Last_IO_Error:\n       Last_SQL_Errno: 0\n       Last_SQL_Error:\n Replicate_Ignore_Server_Ids:\n      Master_Server_Id: 101\n       Master_SSL_Crl:\n     Master_SSL_Crlpath:\n         Using_Gtid: No\n         Gtid_IO_Pos:\n\nSHOW ALL SLAVES STATUS\\G\n*************************** 1. row ***************************\n       Connection_name:\n       Slave_SQL_State: Slave has read all relay log; waiting for the\nslave I/O thread to update it\n       Slave_IO_State: Waiting for master to send event\n         Master_Host: db01.example.com\n         Master_User: replicant\n         Master_Port: 3306\n        Connect_Retry: 60\n       Master_Log_File: mariadb-bin.000010\n     Read_Master_Log_Pos: 3608\n       Relay_Log_File: relay-bin.000004\n        Relay_Log_Pos: 3897\n    Relay_Master_Log_File: mariadb-bin.000010\n      Slave_IO_Running: Yes\n      Slave_SQL_Running: Yes\n       Replicate_Do_DB:\n     Replicate_Ignore_DB:\n     Replicate_Do_Table:\n   Replicate_Ignore_Table:\n   Replicate_Wild_Do_Table:\n Replicate_Wild_Ignore_Table:\n         Last_Errno: 0\n         Last_Error:\n        Skip_Counter: 0\n     Exec_Master_Log_Pos: 3608\n       Relay_Log_Space: 4557\n       Until_Condition: None\n       Until_Log_File:\n        Until_Log_Pos: 0\n     Master_SSL_Allowed: No\n     Master_SSL_CA_File:\n     Master_SSL_CA_Path:\n       Master_SSL_Cert:\n      Master_SSL_Cipher:\n       Master_SSL_Key:\n    Seconds_Behind_Master: 0\nMaster_SSL_Verify_Server_Cert: No\n        Last_IO_Errno: 0\n        Last_IO_Error:\n       Last_SQL_Errno: 0\n       Last_SQL_Error:\n Replicate_Ignore_Server_Ids:\n      Master_Server_Id: 101\n       Master_SSL_Crl:\n     Master_SSL_Crlpath:\n         Using_Gtid: No\n         Gtid_IO_Pos:\n    Retried_transactions: 0\n     Max_relay_log_size: 104857600\n    Executed_log_entries: 40\n  Slave_received_heartbeats: 11\n   Slave_heartbeat_period: 1800.000\n       Gtid_Slave_Pos: 0-101-2320\n\nYou can also access some of the variables directly from status variables:\n\nSET @@default_master_connection=\"test\" ;\nshow status like \"%slave%\"\n\nVariable_name   Value\nCom_show_slave_hosts    0\nCom_show_slave_status   0\nCom_start_all_slaves    0\nCom_start_slave 0\nCom_stop_all_slaves     0\nCom_stop_slave  0\nRpl_semi_sync_slave_status      OFF\nSlave_connections       0\nSlave_heartbeat_period  1800.000\nSlave_open_temp_tables  0\nSlave_received_heartbeats       0\nSlave_retried_transactions      0\nSlave_running   OFF\nSlaves_connected        0\nSlaves_running  1\n\nURL: https://mariadb.com/kb/en/show-replica-status/','','https://mariadb.com/kb/en/show-replica-status/'),(351,'SET SQL_LOG_BIN',26,'Syntax\n------\n\nSET [SESSION] sql_log_bin = {0|1}\n\nDescription\n-----------\n\nSets the sql_log_bin system variable, which disables or enables binary logging\nfor the current connection, if the client has the SUPER privilege. The\nstatement is refused with an error if the client does not have that privilege.\n\nBefore MariaDB 5.5 and before MySQL 5.6 one could also set sql_log_bin as a\nglobal variable. This was disabled as this was too dangerous as it could\ndamage replication.\n\nURL: https://mariadb.com/kb/en/set-sql_log_bin/','','https://mariadb.com/kb/en/set-sql_log_bin/'),(387,'SHOW PROFILES',26,'Syntax\n------\n\nSHOW PROFILES\n\nDescription\n-----------\n\nThe SHOW PROFILES statement displays profiling information that indicates\nresource usage for statements executed during the course of the current\nsession. It is used together with SHOW PROFILE.\n\nURL: https://mariadb.com/kb/en/show-profiles/','','https://mariadb.com/kb/en/show-profiles/'),(388,'SHOW QUERY_RESPONSE_TIME',26,'It is possible to use SHOW QUERY_RESPONSE_TIME as an alternative for\nretrieving information from the QUERY_RESPONSE_TIME plugin.\n\nThis was introduced as part of the Information Schema plugin extension.\n\nURL: https://mariadb.com/kb/en/show-query_response_time/','','https://mariadb.com/kb/en/show-query_response_time/'),(389,'SHOW STATUS',26,'Syntax\n------\n\nSHOW [GLOBAL | SESSION] STATUS\n  [LIKE \'pattern\' | WHERE expr]\n\nDescription\n-----------\n\nSHOW STATUS provides server status information. This information also can be\nobtained using the mysqladmin extended-status command, or by querying the\nInformation Schema GLOBAL_STATUS and SESSION_STATUS tables. The LIKE clause,\nif present, indicates which variable names to match. The WHERE clause can be\ngiven to select rows using more general conditions.\n\nWith the GLOBAL modifier, SHOW STATUS displays the status values for all\nconnections to MariaDB. With SESSION, it displays the status values for the\ncurrent connection. If no modifier is present, the default is SESSION. LOCAL\nis a synonym for SESSION. If you see a lot of 0 values, the reason is probably\nthat you have used SHOW STATUS with a new connection instead of SHOW GLOBAL\nSTATUS.\n\nSome status variables have only a global value. For these, you get the same\nvalue for both GLOBAL and SESSION.\n\nSee Server Status Variables for a full list, scope and description of the\nvariables that can be viewed with SHOW STATUS.\n\nThe LIKE clause, if present on its own, indicates which variable name to match.\n\nThe WHERE and LIKE clauses can be given to select rows using more general\nconditions, as discussed in Extended SHOW.\n\nExamples\n--------\n\nFull output from MariaDB 10.1.17:\n\nSHOW GLOBAL STATUS;\n+--------------------------------------------------------------+---------------\n------------------------+\n| Variable_name                                                | Value        \n            |\n+--------------------------------------------------------------+---------------\n------------------------+\n| Aborted_clients                                              | 0            \n            |\n| Aborted_connects                                             | 0            \n            |\n| Access_denied_errors                                         | 0            \n            |\n| Acl_column_grants                                            | 0            \n            |\n| Acl_database_grants                                          | 2            \n            |\n| Acl_function_grants                                          | 0            \n            |\n| Acl_procedure_grants                                         | 0            \n            |\n| Acl_proxy_users                                              | 2            \n            |\n| Acl_role_grants                                              | 0            \n            |\n| Acl_roles                                                    | 0            \n            |\n| Acl_table_grants                                             | 0            \n            |\n| Acl_users                                                    | 6            \n            |\n| Aria_pagecache_blocks_not_flushed                            | 0            \n            |\n| Aria_pagecache_blocks_unused                                 | 15706        \n            |\n| Aria_pagecache_blocks_used                                   | 0            \n            |\n| Aria_pagecache_read_requests                                 | 0            \n            |\n| Aria_pagecache_reads                                         | 0            \n            |\n| Aria_pagecache_write_requests                                | 0            \n            |\n| Aria_pagecache_writes                                        | 0            \n            |\n| Aria_transaction_log_syncs                                   | 0            \n            |\n| Binlog_commits                                               | 0            \n            |\n| Binlog_group_commits                                         | 0            \n            |\n| Binlog_group_commit_trigger_count                            | 0            \n            |\n| Binlog_group_commit_trigger_lock_wait                        | 0            \n            |\n| Binlog_group_commit_trigger_timeout                          | 0            \n            |\n| Binlog_snapshot_file                                         |              \n            |\n| Binlog_snapshot_position                                     | 0            \n            |\n| Binlog_bytes_written                                         | 0            \n            |\n| Binlog_cache_disk_use                                        | 0            \n            |\n| Binlog_cache_use                                             | 0            \n            |\n| Binlog_stmt_cache_disk_use                                   | 0            \n            |\n| Binlog_stmt_cache_use                                        | 0            \n            |\n| Busy_time                                                    | 0.000000     \n            |\n| Bytes_received                                               | 432          \n            |\n| Bytes_sent                                                   | 15183        \n            |\n| Com_admin_commands                                           | 1            \n            |\n| Com_alter_db                                                 | 0            \n            |\n| Com_alter_db_upgrade                                         | 0            \n            |\n| Com_alter_event                                              | 0            \n            |\n| Com_alter_function                                           | 0            \n            |\n| Com_alter_procedure                                          | 0            \n            |\n| Com_alter_server                                             | 0            \n            |\n| Com_alter_table                                              | 0            \n            |\n| Com_alter_tablespace                                         | 0            \n            |\n| Com_analyze                                                  | 0            \n            |\n| Com_assign_to_keycache                                       | 0            \n            |\n| Com_begin                                                    | 0            \n            |\n| Com_binlog                                                   | 0            \n            |\n| Com_call_procedure                                           | 0            \n            |\n| Com_change_db                                                | 0            \n            |\n| Com_change_master                                            | 0            \n            |\n| Com_check                                                    | 0            \n            |\n| Com_checksum                                                 | 0            \n            |\n| Com_commit                                                   | 0            \n            |\n| Com_compound_sql                                             | 0            \n            |\n| Com_create_db                                                | 0            \n            |\n| Com_create_event                                             | 0            \n            |\n| Com_create_function                                          | 0            \n            |\n| Com_create_index                                             | 0            \n            |\n| Com_create_procedure                                         | 0            \n            |\n| Com_create_role                                              | 0            \n            |\n| Com_create_server                                            | 0            \n            |\n| Com_create_table                                             | 0            \n            |\n| Com_create_temporary_table                                   | 0            \n            |\n| Com_create_trigger                                           | 0            \n            |\n| Com_create_udf                                               | 0            \n            |\n| Com_create_user                                              | 0            \n            |\n| Com_create_view                                              | 0            \n            |\n| Com_dealloc_sql                                              | 0            \n            |\n| Com_delete                                                   | 0            \n            |\n| Com_delete_multi                                             | 0            \n            |\n| Com_do                                                       | 0            \n            |\n| Com_drop_db                                                  | 0            \n            |\n| Com_drop_event                                               | 0            \n            |\n| Com_drop_function                                            | 0            \n            |\n| Com_drop_index                                               | 0            \n            |\n| Com_drop_procedure                                           | 0            \n            |\n| Com_drop_role                                                | 0            \n            |\n| Com_drop_server                                              | 0            \n            |\n| Com_drop_table                                               | 0            \n            |\n| Com_drop_temporary_table                                     | 0            \n            |\n| Com_drop_trigger                                             | 0            \n            |\n| Com_drop_user                                                | 0            \n            |\n| Com_drop_view                                                | 0            \n            |\n| Com_empty_query                                              | 0            \n            |\n| Com_execute_sql                                              | 0            \n            |\n| Com_flush                                                    | 0            \n            |\n| Com_get_diagnostics                                          | 0            \n            |\n| Com_grant                                                    | 0            \n            |\n| Com_grant_role                                               | 0            \n            |\n| Com_ha_close                                                 | 0            \n            |\n| Com_ha_open                                                  | 0            \n            |\n| Com_ha_read                                                  | 0            \n            |\n| Com_help                                                     | 0            \n            |\n| Com_insert                                                   | 0            \n            |\n| Com_insert_select                                            | 0            \n            |\n| Com_install_plugin                                           | 0            \n            |\n| Com_kill                                                     | 0            \n            |\n| Com_load                                                     | 0            \n            |\n| Com_lock_tables                                              | 0            \n            |\n| Com_optimize                                                 | 0            \n            |\n| Com_preload_keys                                             | 0            \n            |\n| Com_prepare_sql                                              | 0            \n            |\n| Com_purge                                                    | 0            \n            |\n| Com_purge_before_date                                        | 0            \n            |\n| Com_release_savepoint                                        | 0            \n            |\n| Com_rename_table                                             | 0            \n            |\n| Com_rename_user                                              | 0            \n            |\n| Com_repair                                                   | 0            \n            |\n| Com_replace                                                  | 0            \n            |\n| Com_replace_select                                           | 0            \n            |\n| Com_reset                                                    | 0            \n            |\n| Com_resignal                                                 | 0            \n            |\n| Com_revoke                                                   | 0            \n            |\n| Com_revoke_all                                               | 0            \n            |\n| Com_revoke_role                                              | 0            \n            |\n| Com_rollback                                                 | 0            \n            |\n| Com_rollback_to_savepoint                                    | 0            \n            |\n| Com_savepoint                                                | 0            \n            |\n| Com_select                                                   | 1            \n            |\n| Com_set_option                                               | 0            \n            |\n| Com_show_authors                                             | 0            \n            |\n| Com_show_binlog_events                                       | 0            \n            |\n| Com_show_binlogs                                             | 0            \n            |\n| Com_show_charsets                                            | 0            \n            |\n| Com_show_collations                                          | 0            \n            |\n| Com_show_contributors                                        | 0            \n            |\n| Com_show_create_db                                           | 0            \n            |\n| Com_show_create_event                                        | 0            \n            |\n| Com_show_create_func                                         | 0            \n            |\n| Com_show_create_proc                                         | 0            \n            |\n| Com_show_create_table                                        | 0            \n            |\n| Com_show_create_trigger                                      | 0            \n            |\n| Com_show_databases                                           | 0            \n            |\n| Com_show_engine_logs                                         | 0            \n            |\n| Com_show_engine_mutex                                        | 0            \n            |\n| Com_show_engine_status                                       | 0            \n            |\n| Com_show_errors                                              | 0            \n            |\n| Com_show_events                                              | 0            \n            |\n| Com_show_explain                                             | 0            \n            |\n| Com_show_fields                                              | 0            \n            |\n| Com_show_function_status                                     | 0            \n            |\n| Com_show_generic                                             | 0            \n            |\n| Com_show_grants                                              | 0            \n            |\n| Com_show_keys                                                | 0            \n            |\n| Com_show_master_status                                       | 0            \n            |\n| Com_show_open_tables                                         | 0            \n            |\n| Com_show_plugins                                             | 0            \n            |\n| Com_show_privileges                                          | 0            \n            |\n| Com_show_procedure_status                                    | 0            \n            |\n| Com_show_processlist                                         | 0            \n            |\n| Com_show_profile                                             | 0            \n            |\n| Com_show_profiles                                            | 0            \n            |\n| Com_show_relaylog_events                                     | 0            \n            |\n| Com_show_slave_hosts                                         | 0            \n            |\n| Com_show_slave_status                                        | 0            \n            |\n| Com_show_status                                              | 2            \n            |\n| Com_show_storage_engines                                     | 0            \n            |\n| Com_show_table_status                                        | 0            \n            |\n| Com_show_tables                                              | 0            \n            |\n| Com_show_triggers                                            | 0            \n            |\n| Com_show_variables                                           | 0            \n            |\n| Com_show_warnings                                            | 0            \n            |\n| Com_shutdown                                                 | 0            \n            |\n| Com_signal                                                   | 0            \n            |\n| Com_start_all_slaves                                         | 0            \n            |\n| Com_start_slave                                              | 0            \n            |\n| Com_stmt_close                                               | 0            \n            |\n| Com_stmt_execute                                             | 0            \n            |\n| Com_stmt_fetch                                               | 0            \n            |\n| Com_stmt_prepare                                             | 0            \n            |\n| Com_stmt_reprepare                                           | 0            \n            |\n| Com_stmt_reset                                               | 0            \n            |\n| Com_stmt_send_long_data                                      | 0            \n            |\n| Com_stop_all_slaves                                          | 0            \n            |\n| Com_stop_slave                                               | 0            \n            |\n| Com_truncate                                                 | 0            \n            |\n| Com_uninstall_plugin                                         | 0            \n            |\n| Com_unlock_tables                                            | 0            \n            |\n| Com_update                                                   | 0            \n            |\n| Com_update_multi                                             | 0            \n            |\n| Com_xa_commit                                                | 0            \n            |\n| Com_xa_end                                                   | 0            \n            |\n| Com_xa_prepare                                               | 0            \n            |\n| Com_xa_recover                                               | 0            \n            |\n| Com_xa_rollback                                              | 0            \n            |\n| Com_xa_start                                                 | 0            \n            |\n| Compression                                                  | OFF          \n            |\n| Connection_errors_accept                                     | 0            \n            |\n| Connection_errors_internal                                   | 0            \n            |\n| Connection_errors_max_connections                            | 0            \n            |\n| Connection_errors_peer_address                               | 0            \n            |\n| Connection_errors_select                                     | 0            \n            |\n| Connection_errors_tcpwrap                                    | 0            \n            |\n| Connections                                                  | 4            \n            |\n| Cpu_time                                                     | 0.000000     \n            |\n| Created_tmp_disk_tables                                      | 0            \n            |\n| Created_tmp_files                                            | 6            \n            |\n| Created_tmp_tables                                           | 2            \n            |\n| Delayed_errors                                               | 0            \n            |\n| Delayed_insert_threads                                       | 0            \n            |\n| Delayed_writes                                               | 0            \n            |\n| Delete_scan                                                  | 0            \n            |\n| Empty_queries                                                | 0            \n            |\n| Executed_events                                              | 0            \n            |\n| Executed_triggers                                            | 0            \n            |\n| Feature_delay_key_write                                      | 0            \n            |\n| Feature_dynamic_columns                                      | 0            \n            |\n| Feature_fulltext                                             | 0            \n            |\n| Feature_gis                                                  | 0            \n            |\n| Feature_locale                                               | 0            \n            |\n| Feature_subquery                                             | 0            \n            |\n| Feature_timezone                                             | 0            \n            |\n| Feature_trigger                                              | 0            \n            |\n| Feature_xml                                                  | 0            \n            |\n| Flush_commands                                               | 1            \n            |\n| Handler_commit                                               | 1            \n            |\n| Handler_delete                                               | 0            \n            |\n| Handler_discover                                             | 0            \n            |\n| Handler_external_lock                                        | 0            \n            |\n| Handler_icp_attempts                                         | 0            \n            |\n| Handler_icp_match                                            | 0            \n            |\n| Handler_mrr_init                                             | 0            \n            |\n| Handler_mrr_key_refills                                      | 0            \n            |\n| Handler_mrr_rowid_refills                                    | 0            \n            |\n| Handler_prepare                                              | 0            \n            |\n| Handler_read_first                                           | 3            \n            |\n| Handler_read_key                                             | 0            \n            |\n| Handler_read_last                                            | 0            \n            |\n| Handler_read_next                                            | 0            \n            |\n| Handler_read_prev                                            | 0            \n            |\n| Handler_read_retry                                           | 0            \n            |\n| Handler_read_rnd                                             | 0            \n            |\n| Handler_read_rnd_deleted                                     | 0            \n            |\n| Handler_read_rnd_next                                        | 537          \n            |\n| Handler_rollback                                             | 0            \n            |\n| Handler_savepoint                                            | 0            \n            |\n| Handler_savepoint_rollback                                   | 0            \n            |\n| Handler_tmp_update                                           | 0            \n            |\n| Handler_tmp_write                                            | 516          \n            |\n| Handler_update                                               | 0            \n            |\n| Handler_write                                                | 0            \n            |\n| Innodb_available_undo_logs                                   | 128          \n            |\n| Innodb_background_log_sync                                   | 222          \n            |\n| Innodb_buffer_pool_bytes_data                                | 2523136      \n            |\n| Innodb_buffer_pool_bytes_dirty                               | 0            \n            |\n| Innodb_buffer_pool_dump_status                               | Dumping\nbuffer pool(s) not yet started |\n| Innodb_buffer_pool_load_status                               | Loading\nbuffer pool(s) not yet started |\n| Innodb_buffer_pool_pages_data                                | 154          \n            |\n| Innodb_buffer_pool_pages_dirty                               | 0            \n            |\n| Innodb_buffer_pool_pages_flushed                             | 1            \n            |\n| Innodb_buffer_pool_pages_free                                | 8037         \n            |\n| Innodb_buffer_pool_pages_lru_flushed                         | 0            \n            |\n| Innodb_buffer_pool_pages_made_not_young                      | 0            \n            |\n| Innodb_buffer_pool_pages_made_young                          | 0            \n            |\n| Innodb_buffer_pool_pages_misc                                | 0            \n            |\n| Innodb_buffer_pool_pages_old                                 | 0            \n            |\n| Innodb_buffer_pool_pages_total                               | 8191         \n            |\n| Innodb_buffer_pool_read_ahead                                | 0            \n            |\n| Innodb_buffer_pool_read_ahead_evicted                        | 0            \n            |\n| Innodb_buffer_pool_read_ahead_rnd                            | 0            \n            |\n| Innodb_buffer_pool_read_requests                             | 558          \n            |\n| Innodb_buffer_pool_reads                                     | 155          \n            |\n| Innodb_buffer_pool_wait_free                                 | 0            \n            |\n| Innodb_buffer_pool_write_requests                            | 1            \n            |\n| Innodb_checkpoint_age                                        | 0            \n            |\n| Innodb_checkpoint_max_age                                    | 80826164     \n            |\n| Innodb_data_fsyncs                                           | 5            \n            |\n| Innodb_data_pending_fsyncs                                   | 0            \n            |\n| Innodb_data_pending_reads                                    | 0            \n            |\n| Innodb_data_pending_writes                                   | 0            \n            |\n| Innodb_data_read                                             | 2609664      \n            |\n| Innodb_data_reads                                            | 172          \n            |\n| Innodb_data_writes                                           | 5            \n            |\n| Innodb_data_written                                          | 34304        \n            |\n| Innodb_dblwr_pages_written                                   | 1            \n            |\n| Innodb_dblwr_writes                                          | 1            \n            |\n| Innodb_deadlocks                                             | 0            \n            |\n| Innodb_have_atomic_builtins                                  | ON           \n            |\n| Innodb_history_list_length                                   | 0            \n            |\n| Innodb_ibuf_discarded_delete_marks                           | 0            \n            |\n| Innodb_ibuf_discarded_deletes                                | 0            \n            |\n| Innodb_ibuf_discarded_inserts                                | 0            \n            |\n| Innodb_ibuf_free_list                                        | 0            \n            |\n| Innodb_ibuf_merged_delete_marks                              | 0            \n            |\n| Innodb_ibuf_merged_deletes                                   | 0            \n            |\n| Innodb_ibuf_merged_inserts                                   | 0            \n            |\n| Innodb_ibuf_merges                                           | 0            \n            |\n| Innodb_ibuf_segment_size                                     | 2            \n            |\n| Innodb_ibuf_size                                             | 1            \n            |\n| Innodb_log_waits                                             | 0            \n            |\n| Innodb_log_write_requests                                    | 0            \n            |\n| Innodb_log_writes                                            | 1            \n            |\n| Innodb_lsn_current                                           | 1616829      \n            |\n| Innodb_lsn_flushed                                           | 1616829      \n            |\n| Innodb_lsn_last_checkpoint                                   | 1616829      \n            |\n| Innodb_master_thread_active_loops                            | 0            \n            |\n| Innodb_master_thread_idle_loops                              | 222          \n            |\n| Innodb_max_trx_id                                            | 2308         \n            |\n| Innodb_mem_adaptive_hash                                     | 2217568      \n            |\n| Innodb_mem_dictionary                                        | 630703       \n            |\n| Innodb_mem_total                                             | 140771328    \n            |\n| Innodb_mutex_os_waits                                        | 1            \n            |\n| Innodb_mutex_spin_rounds                                     | 30           \n            |\n| Innodb_mutex_spin_waits                                      | 1            \n            |\n| Innodb_oldest_view_low_limit_trx_id                          | 0            \n            |\n| Innodb_os_log_fsyncs                                         | 3            \n            |\n| Innodb_os_log_pending_fsyncs                                 | 0            \n            |\n| Innodb_os_log_pending_writes                                 | 0            \n            |\n| Innodb_os_log_written                                        | 512          \n            |\n| Innodb_page_size                                             | 16384        \n            |\n| Innodb_pages_created                                         | 0            \n            |\n| Innodb_pages_read                                            | 154          \n            |\n| Innodb_pages_written                                         | 1            \n            |\n| Innodb_purge_trx_id                                          | 0            \n            |\n| Innodb_purge_undo_no                                         | 0            \n            |\n| Innodb_read_views_memory                                     | 88           \n            |\n| Innodb_row_lock_current_waits                                | 0            \n            |\n| Innodb_row_lock_time                                         | 0            \n            |\n| Innodb_row_lock_time_avg                                     | 0            \n            |\n| Innodb_row_lock_time_max                                     | 0            \n            |\n| Innodb_row_lock_waits                                        | 0            \n            |\n| Innodb_rows_deleted                                          | 0            \n            |\n| Innodb_rows_inserted                                         | 0            \n            |\n| Innodb_rows_read                                             | 0            \n            |\n| Innodb_rows_updated                                          | 0            \n            |\n| Innodb_system_rows_deleted                                   | 0            \n            |\n| Innodb_system_rows_inserted                                  | 0            \n            |\n| Innodb_system_rows_read                                      | 0            \n            |\n| Innodb_system_rows_updated                                   | 0            \n            |\n| Innodb_s_lock_os_waits                                       | 2            \n            |\n| Innodb_s_lock_spin_rounds                                    | 60           \n            |\n| Innodb_s_lock_spin_waits                                     | 2            \n            |\n| Innodb_truncated_status_writes                               | 0            \n            |\n| Innodb_x_lock_os_waits                                       | 0            \n            |\n| Innodb_x_lock_spin_rounds                                    | 0            \n            |\n| Innodb_x_lock_spin_waits                                     | 0            \n            |\n| Innodb_page_compression_saved                                | 0            \n            |\n| Innodb_page_compression_trim_sect512                         | 0            \n            |\n| Innodb_page_compression_trim_sect1024                        | 0            \n            |\n| Innodb_page_compression_trim_sect2048                        | 0            \n            |\n| Innodb_page_compression_trim_sect4096                        | 0            \n            |\n| Innodb_page_compression_trim_sect8192                        | 0            \n            |\n| Innodb_page_compression_trim_sect16384                       | 0            \n            |\n| Innodb_page_compression_trim_sect32768                       | 0            \n            |\n| Innodb_num_index_pages_written                               | 0            \n            |\n| Innodb_num_non_index_pages_written                           | 5            \n            |\n| Innodb_num_pages_page_compressed                             | 0            \n            |\n| Innodb_num_page_compressed_trim_op                           | 0            \n            |\n| Innodb_num_page_compressed_trim_op_saved                     | 0            \n            |\n| Innodb_num_pages_page_decompressed                           | 0            \n            |\n| Innodb_num_pages_page_compression_error                      | 0            \n            |\n| Innodb_num_pages_encrypted                                   | 0            \n            |\n| Innodb_num_pages_decrypted                                   | 0            \n            |\n| Innodb_have_lz4                                              | OFF          \n            |\n| Innodb_have_lzo                                              | OFF          \n            |\n| Innodb_have_lzma                                             | OFF          \n            |\n| Innodb_have_bzip2                                            | OFF          \n            |\n| Innodb_have_snappy                                           | OFF          \n            |\n| Innodb_defragment_compression_failures                       | 0            \n            |\n| Innodb_defragment_failures                                   | 0            \n            |\n| Innodb_defragment_count                                      | 0            \n            |\n| Innodb_onlineddl_rowlog_rows                                 | 0            \n            |\n| Innodb_onlineddl_rowlog_pct_used                             | 0            \n            |\n| Innodb_onlineddl_pct_progress                                | 0            \n            |\n| Innodb_secondary_index_triggered_cluster_reads               | 0            \n            |\n| Innodb_secondary_index_triggered_cluster_reads_avoided       | 0            \n            |\n| Innodb_encryption_rotation_pages_read_from_cache             | 0            \n            |\n| Innodb_encryption_rotation_pages_read_from_disk              | 0            \n            |\n| Innodb_encryption_rotation_pages_modified                    | 0            \n            |\n| Innodb_encryption_rotation_pages_flushed                     | 0            \n            |\n| Innodb_encryption_rotation_estimated_iops                    | 0            \n            |\n| Innodb_scrub_background_page_reorganizations                 | 0            \n            |\n| Innodb_scrub_background_page_splits                          | 0            \n            |\n| Innodb_scrub_background_page_split_failures_underflow        | 0            \n            |\n| Innodb_scrub_background_page_split_failures_out_of_filespace | 0            \n            |\n| Innodb_scrub_background_page_split_failures_missing_index    | 0            \n            |\n| Innodb_scrub_background_page_split_failures_unknown          | 0            \n            |\n| Key_blocks_not_flushed                                       | 0            \n            |\n| Key_blocks_unused                                            | 107163       \n            |\n| Key_blocks_used                                              | 0            \n            |\n| Key_blocks_warm                                              | 0            \n            |\n| Key_read_requests                                            | 0            \n            |\n| Key_reads                                                    | 0            \n            |\n| Key_write_requests                                           | 0            \n            |\n| Key_writes                                                   | 0            \n            |\n| Last_query_cost                                              | 0.000000     \n            |\n| Master_gtid_wait_count                                       | 0            \n            |\n| Master_gtid_wait_time                                        | 0            \n            |\n| Master_gtid_wait_timeouts                                    | 0            \n            |\n| Max_statement_time_exceeded                                  | 0            \n            |\n| Max_used_connections                                         | 1            \n            |\n| Memory_used                                                  | 273614696    \n            |\n| Not_flushed_delayed_rows                                     | 0            \n            |\n| Open_files                                                   | 25           \n            |\n| Open_streams                                                 | 0            \n            |\n| Open_table_definitions                                       | 18           \n            |\n| Open_tables                                                  | 11           \n            |\n| Opened_files                                                 | 77           \n            |\n| Opened_plugin_libraries                                      | 0            \n            |\n| Opened_table_definitions                                     | 18           \n            |\n| Opened_tables                                                | 18           \n            |\n| Opened_views                                                 | 0            \n            |\n| Performance_schema_accounts_lost                             | 0            \n            |\n| Performance_schema_cond_classes_lost                         | 0            \n            |\n| Performance_schema_cond_instances_lost                       | 0            \n            |\n| Performance_schema_digest_lost                               | 0            \n            |\n| Performance_schema_file_classes_lost                         | 0            \n            |\n| Performance_schema_file_handles_lost                         | 0            \n            |\n| Performance_schema_file_instances_lost                       | 0            \n            |\n| Performance_schema_hosts_lost                                | 0            \n            |\n| Performance_schema_locker_lost                               | 0            \n            |\n| Performance_schema_mutex_classes_lost                        | 0            \n            |\n| Performance_schema_mutex_instances_lost                      | 0            \n            |\n| Performance_schema_rwlock_classes_lost                       | 0            \n            |\n| Performance_schema_rwlock_instances_lost                     | 0            \n            |\n| Performance_schema_session_connect_attrs_lost                | 0            \n            |\n| Performance_schema_socket_classes_lost                       | 0            \n            |\n| Performance_schema_socket_instances_lost                     | 0            \n            |\n| Performance_schema_stage_classes_lost                        | 0            \n            |\n| Performance_schema_statement_classes_lost                    | 0            \n            |\n| Performance_schema_table_handles_lost                        | 0            \n            |\n| Performance_schema_table_instances_lost                      | 0            \n            |\n| Performance_schema_thread_classes_lost                       | 0            \n            |\n| Performance_schema_thread_instances_lost                     | 0            \n            |\n| Performance_schema_users_lost                                | 0            \n            |\n| Prepared_stmt_count                                          | 0            \n            |\n| Qcache_free_blocks                                           | 1            \n            |\n| Qcache_free_memory                                           | 1031336      \n            |\n| Qcache_hits                                                  | 0            \n            |\n| Qcache_inserts                                               | 0            \n            |\n| Qcache_lowmem_prunes                                         | 0            \n            |\n| Qcache_not_cached                                            | 0            \n            |\n| Qcache_queries_in_cache                                      | 0            \n            |\n| Qcache_total_blocks                                          | 1            \n            |\n| Queries                                                      | 4            \n            |\n| Questions                                                    | 4            \n            |\n| Rows_read                                                    | 10           \n            |\n| Rows_sent                                                    | 517          \n            |\n| Rows_tmp_read                                                | 516          \n            |\n| Rpl_status                                                   | AUTH_MASTER  \n            |\n| Select_full_join                                             | 0            \n            |\n| Select_full_range_join                                       | 0            \n            |\n| Select_range                                                 | 0            \n            |\n| Select_range_check                                           | 0            \n            |\n| Select_scan                                                  | 2            \n            |\n| Slave_connections                                            | 0            \n            |\n| Slave_heartbeat_period                                       | 0.000        \n            |\n| Slave_open_temp_tables                                       | 0            \n            |\n| Slave_received_heartbeats                                    | 0            \n            |\n| Slave_retried_transactions                                   | 0            \n            |\n| Slave_running                                                | OFF          \n            |\n| Slave_skipped_errors                                         | 0            \n            |\n| Slaves_connected                                             | 0            \n            |\n| Slaves_running                                               | 0            \n            |\n| Slow_launch_threads                                          | 0            \n            |\n| Slow_queries                                                 | 0            \n            |\n| Sort_merge_passes                                            | 0            \n            |\n| Sort_priority_queue_sorts                                    | 0            \n            |\n| Sort_range                                                   | 0            \n            |\n| Sort_rows                                                    | 0            \n            |\n| Sort_scan                                                    | 0            \n            |\n| Ssl_accept_renegotiates                                      | 0            \n            |\n| Ssl_accepts                                                  | 0            \n            |\n| Ssl_callback_cache_hits                                      | 0            \n            |\n| Ssl_cipher                                                   |              \n            |\n| Ssl_cipher_list                                              |              \n            |\n| Ssl_client_connects                                          | 0            \n            |\n| Ssl_connect_renegotiates                                     | 0            \n            |\n| Ssl_ctx_verify_depth                                         | 0            \n            |\n| Ssl_ctx_verify_mode                                          | 0            \n            |\n| Ssl_default_timeout                                          | 0            \n            |\n| Ssl_finished_accepts                                         | 0            \n            |\n| Ssl_finished_connects                                        | 0            \n            |\n| Ssl_server_not_after                                         |              \n            |\n| Ssl_server_not_before                                        |              \n            |\n| Ssl_session_cache_hits                                       | 0            \n            |\n| Ssl_session_cache_misses                                     | 0            \n            |\n| Ssl_session_cache_mode                                       | NONE         \n            |\n| Ssl_session_cache_overflows                                  | 0            \n            |\n| Ssl_session_cache_size                                       | 0            \n            |\n| Ssl_session_cache_timeouts                                   | 0            \n            |\n| Ssl_sessions_reused                                          | 0            \n            |\n| Ssl_used_session_cache_entries                               | 0            \n            |\n| Ssl_verify_depth                                             | 0            \n            |\n| Ssl_verify_mode                                              | 0            \n            |\n| Ssl_version                                                  |              \n            |\n| Subquery_cache_hit                                           | 0            \n            |\n| Subquery_cache_miss                                          | 0            \n            |\n| Syncs                                                        | 2            \n            |\n| Table_locks_immediate                                        | 21           \n            |\n| Table_locks_waited                                           | 0            \n            |\n| Tc_log_max_pages_used                                        | 0            \n            |\n| Tc_log_page_size                                             | 4096         \n            |\n| Tc_log_page_waits                                            | 0            \n            |\n| Threadpool_idle_threads                                      | 0            \n            |\n| Threadpool_threads                                           | 0            \n            |\n| Threads_cached                                               | 0            \n            |\n| Threads_connected                                            | 1            \n            |\n| Threads_created                                              | 2            \n            |\n| Threads_running                                              | 1            \n            |\n| Update_scan                                                  | 0            \n            |\n| Uptime                                                       | 223          \n            |\n| Uptime_since_flush_status                                    | 223          \n            |\n| wsrep_cluster_conf_id                                        |\n18446744073709551615                   |\n| wsrep_cluster_size                                           | 0            \n            |\n| wsrep_cluster_state_uuid                                     |              \n            |\n| wsrep_cluster_status                                         | Disconnected \n            |\n| wsrep_connected                                              | OFF          \n            |\n| wsrep_local_bf_aborts                                        | 0            \n            |\n| wsrep_local_index                                            |\n18446744073709551615                   |\n| wsrep_provider_name                                          |              \n            |\n| wsrep_provider_vendor                                        |              \n            |\n| wsrep_provider_version                                       |              \n            |\n| wsrep_ready                                                  | OFF          \n            |\n| wsrep_thread_count                                           | 0            \n            |\n+--------------------------------------------------------------+---------------\n------------------------+\n516 rows in set (0.00 sec)\n\nExample of filtered output:\n\nSHOW STATUS LIKE \'Key%\';\n+------------------------+--------+\n| Variable_name          | Value  |\n+------------------------+--------+\n| Key_blocks_not_flushed | 0      |\n| Key_blocks_unused      | 107163 |\n| Key_blocks_used        | 0      |\n| Key_blocks_warm        | 0      |\n| Key_read_requests      | 0      |\n| Key_reads              | 0      |\n| Key_write_requests     | 0      |\n| Key_writes             | 0      |\n+------------------------+--------+\n8 rows in set (0.00 sec)\n\nURL: https://mariadb.com/kb/en/show-status/','','https://mariadb.com/kb/en/show-status/'),(399,'BINLOG',26,'Syntax\n------\n\nBINLOG \'str\'\n\nDescription\n-----------\n\nBINLOG is an internal-use statement. It is generated by the\nmariadb-binlog/mysqlbinlog program as the printable representation of certain\nevents in binary log files. The \'str\' value is a base 64-encoded string the\nthat server decodes to determine the data change indicated by the\ncorresponding event. This statement requires the SUPER privilege (<= MariaDB\n10.5.1) or theBINLOG REPLAY privilege (>= MariaDB 10.5.2).\n\nURL: https://mariadb.com/kb/en/binlog/','','https://mariadb.com/kb/en/binlog/'),(404,'LOAD INDEX',26,'Syntax\n------\n\nLOAD INDEX INTO CACHE\n tbl_index_list [, tbl_index_list] ...\n\ntbl_index_list:\n tbl_name\n  [[INDEX|KEY] (index_name[, index_name] ...)]\n  [IGNORE LEAVES]\n\nDescription\n-----------\n\nThe LOAD INDEX INTO CACHE statement preloads a table index into the key cache\nto which it has been assigned by an explicit CACHE INDEX statement, or into\nthe default key cache otherwise. LOAD INDEX INTO CACHE is used only for MyISAM\nor Aria tables.\n\nThe IGNORE LEAVES modifier causes only blocks for the nonleaf nodes of the\nindex to be preloaded.\n\nURL: https://mariadb.com/kb/en/load-index/','','https://mariadb.com/kb/en/load-index/'),(188,'VAR_SAMP',16,'Syntax\n------\n\nVAR_SAMP(expr)\n\nDescription\n-----------\n\nReturns the sample variance of expr. That is, the denominator is the number of\nrows minus one.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nVAR_SAMP() can be used as a window function.\n\nVAR_SAMP() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, VAR_SAMP(score) \n OVER (PARTITION BY test) AS variance_results FROM student_test;\n+---------+--------+-------+------------------+\n| name    | test   | score | variance_results |\n+---------+--------+-------+------------------+\n| Chun    | SQL    |    75 |         382.9167 |\n| Chun    | Tuning |    73 |         873.0000 |\n| Esben   | SQL    |    43 |         382.9167 |\n| Esben   | Tuning |    31 |         873.0000 |\n| Kaolin  | SQL    |    56 |         382.9167 |\n| Kaolin  | Tuning |    88 |         873.0000 |\n| Tatiana | SQL    |    87 |         382.9167 |\n+---------+--------+-------+------------------+\n\nURL: https://mariadb.com/kb/en/var_samp/','','https://mariadb.com/kb/en/var_samp/'),(191,'CHARSET',17,'Syntax\n------\n\nCHARSET(str)\n\nDescription\n-----------\n\nReturns the character set of the string argument. If str is not a string, it\nis considered as a binary string (so the function returns \'binary\'). This\napplies to NULL, too. The return value is a string in the utf8 character set.\n\nExamples\n--------\n\nSELECT CHARSET(\'abc\');\n+----------------+\n| CHARSET(\'abc\') |\n+----------------+\n| latin1         |\n+----------------+\n\nSELECT CHARSET(CONVERT(\'abc\' USING utf8));\n+------------------------------------+\n| CHARSET(CONVERT(\'abc\' USING utf8)) |\n+------------------------------------+\n| utf8                               |\n+------------------------------------+\n\nSELECT CHARSET(USER());\n+-----------------+\n| CHARSET(USER()) |\n+-----------------+\n| utf8            |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/charset/','','https://mariadb.com/kb/en/charset/'),(192,'COERCIBILITY',17,'Syntax\n------\n\nCOERCIBILITY(str)\n\nDescription\n-----------\n\nReturns the collation coercibility value of the string argument. Coercibility\ndefines what will be converted to what in case of collation conflict, with an\nexpression with higher coercibility being converted to the collation of an\nexpression with lower coercibility.\n\n+-----------------------------+---------------------------+------------------+\n| Coercibility                | Description               | Example          |\n+-----------------------------+---------------------------+------------------+\n| 0                           | Explicit                  | Value using a    |\n|                             |                           | COLLATE clause   |\n+-----------------------------+---------------------------+------------------+\n| 1                           | No collation              | Concatenated     |\n|                             |                           | strings using    |\n|                             |                           | different        |\n|                             |                           | collations       |\n+-----------------------------+---------------------------+------------------+\n| 2                           | Implicit                  | Column value     |\n+-----------------------------+---------------------------+------------------+\n| 3                           | Constant                  | USER() return    |\n|                             |                           | value            |\n+-----------------------------+---------------------------+------------------+\n| 4                           | Coercible                 | Literal string   |\n+-----------------------------+---------------------------+------------------+\n| 5                           | Ignorable                 | NULL or derived  |\n|                             |                           | from NULL        |\n+-----------------------------+---------------------------+------------------+\n\nExamples\n--------\n\nSELECT COERCIBILITY(\'abc\' COLLATE latin1_swedish_ci);\n+-----------------------------------------------+\n| COERCIBILITY(\'abc\' COLLATE latin1_swedish_ci) |\n+-----------------------------------------------+\n|                                             0 |\n+-----------------------------------------------+\n\nSELECT COERCIBILITY(USER());\n+----------------------+\n| COERCIBILITY(USER()) |\n+----------------------+\n|                    3 |\n+----------------------+\n\nSELECT COERCIBILITY(\'abc\');\n+---------------------+\n| COERCIBILITY(\'abc\') |\n+---------------------+\n|                   4 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/coercibility/','','https://mariadb.com/kb/en/coercibility/'),(407,'USE',26,'Syntax\n------\n\nUSE db_name\n\nDescription\n-----------\n\nThe \'USE db_name\' statement tells MariaDB to use the db_name database as the\ndefault (current) database for subsequent statements. The database remains the\ndefault until the end of the session or another USE statement is issued:\n\nUSE db1;\nSELECT COUNT(*) FROM mytable;   # selects from db1.mytable\nUSE db2;\nSELECT COUNT(*) FROM mytable;   # selects from db2.mytable\n\nThe DATABASE() function (SCHEMA() is a synonym) returns the default database.\n\nAnother way to set the default database is specifying its name at mysql\ncommand line client startup.\n\nURL: https://mariadb.com/kb/en/use/','','https://mariadb.com/kb/en/use/'),(408,'SHOW FUNCTION CODE',26,'Syntax\n------\n\nSHOW FUNCTION CODE func_name\n\nDescription\n-----------\n\nSHOW FUNCTION CODE shows a representation of the internal implementation of\nthe stored function.\n\nIt is similar to SHOW PROCEDURE CODE but for stored functions.\n\nURL: https://mariadb.com/kb/en/show-function-code/','','https://mariadb.com/kb/en/show-function-code/'),(438,'LOCK IN SHARE MODE',27,'InnoDB supports row-level locking. Selected rows can be locked using LOCK IN\nSHARE MODE or FOR UPDATE. In both cases, a lock is acquired on the rows read\nby the query, and it will be released when the current transaction is\ncommitted.\n\nWhen LOCK IN SHARE MODE is specified in a SELECT statement, MariaDB will wait\nuntil all transactions that have modified the rows are committed. Then, a\nwrite lock is acquired. All transactions can read the rows, but if they want\nto modify them, they have to wait until your transaction is committed.\n\nIf autocommit is set to 1, the LOCK IN SHARE MODE and FOR UPDATE clauses have\nno effect.\n\nURL: https://mariadb.com/kb/en/lock-in-share-mode/','','https://mariadb.com/kb/en/lock-in-share-mode/'),(195,'CURRENT_ROLE',17,'Syntax\n------\n\nCURRENT_ROLE, CURRENT_ROLE()\n\nDescription\n-----------\n\nReturns the current role name. This determines your access privileges. The\nreturn value is a string in the utf8 character set.\n\nIf there is no current role, NULL is returned.\n\nThe output of SELECT CURRENT_ROLE is equivalent to the contents of the\nENABLED_ROLES Information Schema table.\n\nUSER() returns the combination of user and host used to login. CURRENT_USER()\nreturns the account used to determine current connection\'s privileges.\n\nExamples\n--------\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| NULL         |\n+--------------+\n\nSET ROLE staff;\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| staff        |\n+--------------+\n\nURL: https://mariadb.com/kb/en/current_role/','','https://mariadb.com/kb/en/current_role/'),(196,'CURRENT_USER',17,'Syntax\n------\n\nCURRENT_USER, CURRENT_USER()\n\nDescription\n-----------\n\nReturns the user name and host name combination for the MariaDB account that\nthe server used to authenticate the current client. This account determines\nyour access privileges. The return value is a string in the utf8 character set.\n\nThe value of CURRENT_USER() can differ from the value of USER().\nCURRENT_ROLE() returns the current active role.\n\nExamples\n--------\n\nshell> mysql --user=\"anonymous\"\n\nselect user(),current_user();\n+---------------------+----------------+\n| user()              | current_user() |\n+---------------------+----------------+\n| anonymous@localhost | @localhost     |\n+---------------------+----------------+\n\nWhen calling CURRENT_USER() in a stored procedure, it returns the owner of the\nstored procedure, as defined with DEFINER.\n\nURL: https://mariadb.com/kb/en/current_user/','','https://mariadb.com/kb/en/current_user/'),(197,'DATABASE',17,'Syntax\n------\n\nDATABASE()\n\nDescription\n-----------\n\nReturns the default (current) database name as a string in the utf8 character\nset. If there is no default database, DATABASE() returns NULL. Within a stored\nroutine, the default database is the database that the routine is associated\nwith, wh