/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
INSERT INTO `encrypted_data` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `content_type`, `secret_id`, `kek_id`, `cypher_text`, `kek_meta_extended`) VALUES ('6d452e1d-35c7-477c-9cfa-e00f01eaf210','2025-11-29 09:07:16','2025-11-29 09:08:01','2025-11-29 09:08:01',1,'ACTIVE','application/octet-stream','d358f63b-9db0-4a4f-856d-06365a5bcd6e','3468d818-5a35-4425-849a-b51a975ea1d3','Z0FBQUFBQnBLcmZFZU5KbzVLNVZtV2d4Rkx3NXJ2eUtmbldjMEJwR01YWFJQa1pfNE5PTU5KdUpjRWVKam5URm9ISEw5aGlzR1FWdU9KV2RObUJfQmJrMnJUa3RuNHdUd2ZPeVVJSHFMVU96LXJqVkhaNWtwb09PRllOSVZPd0E4Z1pFTldGQmR4dVQ=',NULL),('f3ec0122-b189-4b17-b153-20112362b602','2025-11-29 08:36:05','2025-11-29 08:37:31','2025-11-29 08:37:31',1,'ACTIVE','application/octet-stream','bdf77128-7c64-47d2-ba44-8cc8070a1d1f','6b3650e4-c606-4642-b332-2a22f8b611bb','Z0FBQUFBQnBLckIxUEVGdWx1T1NsLXZ4eF9ocHlEcDhJRHZ3RElfd1lDdjhFWGNIRlNid2VnMzFoQm4wTFJvYlJfTEY0MUd2VVU1U1ZvNU94Y3dsUUZJMUJHeHpIQlpxMEpEVXVDaDZha3lwTFMteXVyYjdqUEp3RUhkMXZsVFJseGFKdFJ4TlRxUS0=',NULL);
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
INSERT INTO `kek_data` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `plugin_name`, `kek_label`, `project_id`, `active`, `bind_completed`, `algorithm`, `bit_length`, `mode`, `plugin_meta`) VALUES ('3468d818-5a35-4425-849a-b51a975ea1d3','2025-11-29 09:07:16','2025-11-29 09:16:25','2025-11-29 09:16:25',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-51af0a2ee11a460ab825a484e5c6f4a3-key-b11cfc38-9049-428d-9bf2-c7ddb8ef55cd','80819acc-701a-4e31-ad4e-102caccbcc52',1,1,'aes',128,'cbc','gAAAAABpKrfErWTnTFLnVFgJjs2_INxaRVZ2CObShUgz2qkqf7xC2E9-kcbDXgYQaulnZI2l15U-BUmPpOfs8YWyoWNeBQ9dBT3OzwewMPIOQ30ZD9Rp98qp1b-NJbp5UpQyZrq4mOes'),('6b3650e4-c606-4642-b332-2a22f8b611bb','2025-11-29 08:36:05','2025-11-29 08:37:58','2025-11-29 08:37:58',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-3827b5eea76e4810b48ea1733ae5edc4-key-657fb092-d4ff-40a6-95b5-1d4e54a064b7','1e722ce4-4868-4aba-92f2-7e2b9f3bcee6',1,1,'aes',128,'cbc','gAAAAABpKrB1uu6Ta-bsKVgEAKx89dd3EysTtdtHYRRpGUIZY-Wb9XJRTZBfWa3t0Ie4bBUqXv7ouaWOsDWehll2kBDqlXUqhGU6AA8vaAoibw76xFJhrKoSJPNWuNWIFqT97gn0YrtG');
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
INSERT INTO `orders` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `type`, `project_id`, `error_status_code`, `error_reason`, `meta`, `secret_id`, `container_id`, `sub_status`, `sub_status_message`, `creator_id`) VALUES ('a3815ad2-ad52-4074-b550-5289b05cf12e','2025-11-29 09:07:16','2025-11-29 09:07:16',NULL,0,'ACTIVE','key','80819acc-701a-4e31-ad4e-102caccbcc52',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','d358f63b-9db0-4a4f-856d-06365a5bcd6e',NULL,'Unknown','Unknown','5ff561a95dc44b9fb9f7fd8fee80f589'),('b404a5ed-c7fa-43c4-9a66-662f1fba228c','2025-11-29 08:36:04','2025-11-29 08:36:05',NULL,0,'ACTIVE','key','1e722ce4-4868-4aba-92f2-7e2b9f3bcee6',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','bdf77128-7c64-47d2-ba44-8cc8070a1d1f',NULL,'Unknown','Unknown','6126044d5f7d49d19e3feffbc3034024');
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
INSERT INTO `projects` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `external_id`) VALUES ('1e722ce4-4868-4aba-92f2-7e2b9f3bcee6','2025-11-29 08:36:04','2025-11-29 08:37:58','2025-11-29 08:37:58',1,'ACTIVE','3827b5eea76e4810b48ea1733ae5edc4'),('80819acc-701a-4e31-ad4e-102caccbcc52','2025-11-29 09:07:16','2025-11-29 09:16:25','2025-11-29 09:16:25',1,'ACTIVE','51af0a2ee11a460ab825a484e5c6f4a3');
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
INSERT INTO `secret_store_metadata` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `key`, `value`, `secret_id`) VALUES ('47ba925a-1f9f-4fb6-8366-53a69f0bbdee','2025-11-29 08:36:05','2025-11-29 08:37:31','2025-11-29 08:37:31',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','bdf77128-7c64-47d2-ba44-8cc8070a1d1f'),('a35efca7-b761-4b2e-9f63-a75face47a6f','2025-11-29 09:07:16','2025-11-29 09:08:01','2025-11-29 09:08:01',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','d358f63b-9db0-4a4f-856d-06365a5bcd6e'),('ab5d93f3-ffd7-47d3-8cf2-30ead8ec71b3','2025-11-29 09:07:16','2025-11-29 09:08:01','2025-11-29 09:08:01',1,'PENDING','content_type','application/octet-stream','d358f63b-9db0-4a4f-856d-06365a5bcd6e'),('cb73c4af-d115-4b59-8cc1-93dd73a57f4c','2025-11-29 08:36:05','2025-11-29 08:37:31','2025-11-29 08:37:31',1,'PENDING','content_type','application/octet-stream','bdf77128-7c64-47d2-ba44-8cc8070a1d1f');
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('49ea6b1b-33e9-4ba8-9ecf-f05239beb4d0','2025-11-29 06:50:28','2025-11-29 06:50:28',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
INSERT INTO `secrets` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `name`, `secret_type`, `expiration`, `algorithm`, `bit_length`, `mode`, `creator_id`, `project_id`) VALUES ('bdf77128-7c64-47d2-ba44-8cc8070a1d1f','2025-11-29 08:36:05','2025-11-29 08:37:31','2025-11-29 08:37:31',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'6126044d5f7d49d19e3feffbc3034024','1e722ce4-4868-4aba-92f2-7e2b9f3bcee6'),('d358f63b-9db0-4a4f-856d-06365a5bcd6e','2025-11-29 09:07:16','2025-11-29 09:08:01','2025-11-29 09:08:01',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'5ff561a95dc44b9fb9f7fd8fee80f589','80819acc-701a-4e31-ad4e-102caccbcc52');
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
INSERT INTO `backups` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `host`, `availability_zone`, `display_name`, `display_description`, `container`, `status`, `fail_reason`, `service_metadata`, `service`, `size`, `object_count`, `parent_id`, `temp_volume_id`, `temp_snapshot_id`, `num_dependent_backups`, `snapshot_id`, `data_timestamp`, `restore_volume_id`, `encryption_key_id`) VALUES ('2025-11-29 08:33:36','2025-11-29 08:34:43','2025-11-29 08:34:47',1,'d46c2eeb-0144-42cf-aec5-bcf37c5ac2c7','5e1ce939-d473-4e65-8abb-4ac38bce6fd1','2ad82d69b01a4929b20a4d3c4dbe0135','340d97a89c434bedbead3110819c581d','cinder-backup-0',NULL,'tempest-TestVolumeBackupRestore-backup-1475901970',NULL,'backups','deleted',NULL,'{\"base\": \"volume-5e1ce939-d473-4e65-8abb-4ac38bce6fd1.backup.d46c2eeb-0144-42cf-aec5-bcf37c5ac2c7\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:33:36','f3c8b389-36e8-459a-b7d9-3ed0e65767ad',NULL);
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
INSERT INTO `encryption` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `cipher`, `control_location`, `key_size`, `provider`, `volume_type_id`, `encryption_id`) VALUES ('2025-11-29 09:07:15',NULL,'2025-11-29 09:08:03',1,'aes-xts-plain64','front-end',256,'luks','f3ae0dbc-1b77-4398-94d6-14cb420f7706','17b78385-49b8-4c96-9826-8ceaab832c08'),('2025-11-29 08:36:03',NULL,'2025-11-29 08:37:38',1,'aes-xts-plain64','front-end',256,'luks','0cbc8e68-2aad-4320-92d6-590295f50ec1','a2ffffc6-dfd1-464f-ad88-8bd2083f5109');
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','023c10e8-8226-4d21-bc27-70ade9890f83','2025-11-29 06:50:10','2025-11-29 06:50:10',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('023c10e8-8226-4d21-bc27-70ade9890f83','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2025-11-29 06:50:10','2025-11-29 06:50:10',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_host` (`host`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2025-11-29 06:47:03',NULL,NULL,0,1,'default','volumes',10),('2025-11-29 06:47:03',NULL,NULL,0,2,'default','snapshots',10),('2025-11-29 06:47:03',NULL,NULL,0,3,'default','gigabytes',1000),('2025-11-29 06:47:03',NULL,NULL,0,4,'default','consistencygroups',10),('2025-11-29 06:47:03',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2025-11-29 06:47:03',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=147 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `race_preventer`) VALUES ('2025-11-29 07:42:11','2025-11-29 07:44:45',NULL,0,1,'e5fa0a96b3534909a4900e2989849968','volumes',0,0,NULL,1),('2025-11-29 07:42:11','2025-11-29 07:44:45',NULL,0,2,'e5fa0a96b3534909a4900e2989849968','gigabytes',0,0,NULL,1),('2025-11-29 07:42:11','2025-11-29 07:44:45',NULL,0,3,'e5fa0a96b3534909a4900e2989849968','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 07:42:11','2025-11-29 07:44:45',NULL,0,4,'e5fa0a96b3534909a4900e2989849968','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 07:47:39','2025-11-29 07:49:23',NULL,0,5,'f3f16345721743ccb9afb374deec67b5','volumes',0,0,NULL,1),('2025-11-29 07:47:39','2025-11-29 07:49:23',NULL,0,6,'f3f16345721743ccb9afb374deec67b5','gigabytes',0,0,NULL,1),('2025-11-29 07:47:39','2025-11-29 07:49:23',NULL,0,7,'f3f16345721743ccb9afb374deec67b5','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 07:47:39','2025-11-29 07:49:23',NULL,0,8,'f3f16345721743ccb9afb374deec67b5','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 07:48:44','2025-11-29 07:51:06',NULL,0,9,'b2c58ae2e706424fa3147694fc571db0','volumes',0,0,NULL,1),('2025-11-29 07:48:44','2025-11-29 07:51:06',NULL,0,10,'b2c58ae2e706424fa3147694fc571db0','gigabytes',0,0,NULL,1),('2025-11-29 07:48:44','2025-11-29 07:51:06',NULL,0,11,'b2c58ae2e706424fa3147694fc571db0','volumes_multiattach',0,0,NULL,1),('2025-11-29 07:48:45','2025-11-29 07:51:06',NULL,0,12,'b2c58ae2e706424fa3147694fc571db0','gigabytes_multiattach',0,0,NULL,1),('2025-11-29 07:50:58','2025-11-29 07:53:00',NULL,0,13,'73f3d0f2c9aa4ba29984fc9e6a7ed869','volumes',0,0,NULL,1),('2025-11-29 07:50:58','2025-11-29 07:53:00',NULL,0,14,'73f3d0f2c9aa4ba29984fc9e6a7ed869','gigabytes',0,0,NULL,1),('2025-11-29 07:50:58','2025-11-29 07:53:00',NULL,0,15,'73f3d0f2c9aa4ba29984fc9e6a7ed869','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 07:50:58','2025-11-29 07:53:00',NULL,0,16,'73f3d0f2c9aa4ba29984fc9e6a7ed869','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 07:53:40','2025-11-29 07:54:17',NULL,0,17,'800c0f050e95457384eee582d6da0afa','volumes',0,0,NULL,1),('2025-11-29 07:53:40','2025-11-29 07:54:17',NULL,0,18,'800c0f050e95457384eee582d6da0afa','gigabytes',0,0,NULL,1),('2025-11-29 07:53:40','2025-11-29 07:54:17',NULL,0,19,'800c0f050e95457384eee582d6da0afa','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 07:53:40','2025-11-29 07:54:17',NULL,0,20,'800c0f050e95457384eee582d6da0afa','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 07:55:25','2025-11-29 07:55:52',NULL,0,21,'666052d32183417982e59c456a19c744','volumes',0,0,NULL,1),('2025-11-29 07:55:25','2025-11-29 07:55:52',NULL,0,22,'666052d32183417982e59c456a19c744','gigabytes',0,0,NULL,1),('2025-11-29 07:55:25','2025-11-29 07:55:52',NULL,0,23,'666052d32183417982e59c456a19c744','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 07:55:25','2025-11-29 07:55:52',NULL,0,24,'666052d32183417982e59c456a19c744','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 07:59:20','2025-11-29 08:00:17',NULL,0,25,'19b3dc1655684be39c6d284805874456','volumes',0,0,NULL,1),('2025-11-29 07:59:20','2025-11-29 08:00:17',NULL,0,26,'19b3dc1655684be39c6d284805874456','gigabytes',0,0,NULL,1),('2025-11-29 07:59:20','2025-11-29 08:00:17',NULL,0,27,'19b3dc1655684be39c6d284805874456','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 07:59:20','2025-11-29 08:00:17',NULL,0,28,'19b3dc1655684be39c6d284805874456','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:02:24','2025-11-29 08:05:17',NULL,0,29,'faa91146f75c46ebbcd15bb2222a8545','volumes',0,0,NULL,1),('2025-11-29 08:02:24','2025-11-29 08:05:17',NULL,0,30,'faa91146f75c46ebbcd15bb2222a8545','gigabytes',0,0,NULL,1),('2025-11-29 08:02:24','2025-11-29 08:05:17',NULL,0,31,'faa91146f75c46ebbcd15bb2222a8545','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:02:24','2025-11-29 08:05:17',NULL,0,32,'faa91146f75c46ebbcd15bb2222a8545','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:03:15','2025-11-29 08:06:41',NULL,0,33,'f8bc2a2616a34ba1a18b3211e406993f','volumes',0,0,NULL,1),('2025-11-29 08:03:15','2025-11-29 08:06:41',NULL,0,34,'f8bc2a2616a34ba1a18b3211e406993f','gigabytes',0,0,NULL,1),('2025-11-29 08:03:15','2025-11-29 08:06:41',NULL,0,35,'f8bc2a2616a34ba1a18b3211e406993f','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:03:15','2025-11-29 08:06:41',NULL,0,36,'f8bc2a2616a34ba1a18b3211e406993f','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:06:15','2025-11-29 08:08:43',NULL,0,37,'e61a0774e90545289bd82e4a71650bde','volumes',0,0,NULL,1),('2025-11-29 08:06:15','2025-11-29 08:08:43',NULL,0,38,'e61a0774e90545289bd82e4a71650bde','gigabytes',0,0,NULL,1),('2025-11-29 08:06:15','2025-11-29 08:08:43',NULL,0,39,'e61a0774e90545289bd82e4a71650bde','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:06:15','2025-11-29 08:08:43',NULL,0,40,'e61a0774e90545289bd82e4a71650bde','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:07:26','2025-11-29 08:08:34',NULL,0,41,'a6104c57e0814f16958b14707debf843','volumes',0,0,NULL,1),('2025-11-29 08:07:26','2025-11-29 08:08:34',NULL,0,42,'a6104c57e0814f16958b14707debf843','gigabytes',0,0,NULL,1),('2025-11-29 08:07:26','2025-11-29 08:08:34',NULL,0,43,'a6104c57e0814f16958b14707debf843','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:07:26','2025-11-29 08:08:34',NULL,0,44,'a6104c57e0814f16958b14707debf843','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:11:44','2025-11-29 08:14:04',NULL,0,45,'146c65131f5b423287d348b351399c4e','volumes',0,0,NULL,1),('2025-11-29 08:11:44','2025-11-29 08:14:04',NULL,0,46,'146c65131f5b423287d348b351399c4e','gigabytes',0,0,NULL,1),('2025-11-29 08:11:44','2025-11-29 08:14:04',NULL,0,47,'146c65131f5b423287d348b351399c4e','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:11:44','2025-11-29 08:14:04',NULL,0,48,'146c65131f5b423287d348b351399c4e','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:12:38','2025-11-29 08:15:59',NULL,0,49,'250671461f27498d9f6b4476c7b69533','volumes',0,0,NULL,1),('2025-11-29 08:12:38','2025-11-29 08:15:59',NULL,0,50,'250671461f27498d9f6b4476c7b69533','gigabytes',0,0,NULL,1),('2025-11-29 08:12:38','2025-11-29 08:15:59',NULL,0,51,'250671461f27498d9f6b4476c7b69533','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:12:38','2025-11-29 08:15:59',NULL,0,52,'250671461f27498d9f6b4476c7b69533','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:13:46','2025-11-29 08:16:33',NULL,0,53,'ba867fac17034bb28fe2cdb0fff3af2b','volumes',0,0,NULL,1),('2025-11-29 08:13:46','2025-11-29 08:16:33',NULL,0,54,'ba867fac17034bb28fe2cdb0fff3af2b','gigabytes',0,0,NULL,1),('2025-11-29 08:13:46','2025-11-29 08:16:33',NULL,0,55,'ba867fac17034bb28fe2cdb0fff3af2b','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:13:46','2025-11-29 08:16:33',NULL,0,56,'ba867fac17034bb28fe2cdb0fff3af2b','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:18:09','2025-11-29 08:20:09',NULL,0,57,'b9d4c81989d641678300c7a1c173a2c2','volumes',2,0,NULL,1),('2025-11-29 08:18:09','2025-11-29 08:20:09',NULL,0,58,'b9d4c81989d641678300c7a1c173a2c2','gigabytes',2,0,NULL,1),('2025-11-29 08:18:09','2025-11-29 08:20:09',NULL,0,59,'b9d4c81989d641678300c7a1c173a2c2','volumes___DEFAULT__',2,0,NULL,1),('2025-11-29 08:18:09','2025-11-29 08:20:09',NULL,0,60,'b9d4c81989d641678300c7a1c173a2c2','gigabytes___DEFAULT__',2,0,NULL,1),('2025-11-29 08:20:02','2025-11-29 08:23:28',NULL,0,61,'61d8d3b6b31f4b36b5749db9c550c696','volumes',0,0,NULL,1),('2025-11-29 08:20:02','2025-11-29 08:23:28',NULL,0,62,'61d8d3b6b31f4b36b5749db9c550c696','gigabytes',0,0,NULL,1),('2025-11-29 08:20:02','2025-11-29 08:23:28',NULL,0,63,'61d8d3b6b31f4b36b5749db9c550c696','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:20:02','2025-11-29 08:23:28',NULL,0,64,'61d8d3b6b31f4b36b5749db9c550c696','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:20:49','2025-11-29 08:22:56',NULL,0,65,'358970eca7ad4b05b70f43e5507ac052','volumes',0,0,NULL,1),('2025-11-29 08:20:49','2025-11-29 08:22:56',NULL,0,66,'358970eca7ad4b05b70f43e5507ac052','gigabytes',0,0,NULL,1),('2025-11-29 08:20:49','2025-11-29 08:22:56',NULL,0,67,'358970eca7ad4b05b70f43e5507ac052','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:20:49','2025-11-29 08:22:56',NULL,0,68,'358970eca7ad4b05b70f43e5507ac052','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:23:53','2025-11-29 08:24:10',NULL,0,69,'1e7450dd88894243affe67274f9cceb0','volumes',0,0,NULL,1),('2025-11-29 08:23:53','2025-11-29 08:24:10',NULL,0,70,'1e7450dd88894243affe67274f9cceb0','gigabytes',0,0,NULL,1),('2025-11-29 08:23:53','2025-11-29 08:24:10',NULL,0,71,'1e7450dd88894243affe67274f9cceb0','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:23:53','2025-11-29 08:24:10',NULL,0,72,'1e7450dd88894243affe67274f9cceb0','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:23:54','2025-11-29 08:30:17',NULL,0,73,'23450c2eaf4442459dec94c6d29f0412','volumes',0,0,NULL,1),('2025-11-29 08:23:54','2025-11-29 08:30:17',NULL,0,74,'23450c2eaf4442459dec94c6d29f0412','gigabytes',0,0,NULL,1),('2025-11-29 08:23:54','2025-11-29 08:30:17',NULL,0,75,'23450c2eaf4442459dec94c6d29f0412','volumes_multiattach',0,0,NULL,1),('2025-11-29 08:23:54','2025-11-29 08:30:17',NULL,0,76,'23450c2eaf4442459dec94c6d29f0412','gigabytes_multiattach',0,0,NULL,1),('2025-11-29 08:23:58','2025-11-29 08:24:07',NULL,0,77,'1e7450dd88894243affe67274f9cceb0','snapshots',0,0,NULL,1),('2025-11-29 08:23:58','2025-11-29 08:24:07',NULL,0,78,'1e7450dd88894243affe67274f9cceb0','snapshots___DEFAULT__',0,0,NULL,1),('2025-11-29 08:24:17','2025-11-29 08:27:31',NULL,0,79,'d9406fbc6fef486fa5b0e79549e78d00','volumes',0,0,NULL,1),('2025-11-29 08:24:17','2025-11-29 08:27:31',NULL,0,80,'d9406fbc6fef486fa5b0e79549e78d00','gigabytes',0,0,NULL,1),('2025-11-29 08:24:17','2025-11-29 08:27:31',NULL,0,81,'d9406fbc6fef486fa5b0e79549e78d00','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:24:17','2025-11-29 08:27:32',NULL,0,82,'d9406fbc6fef486fa5b0e79549e78d00','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:24:17','2025-11-29 08:24:44',NULL,0,83,'c1fc65ff70ce460c924739eae21e2b49','volumes',0,0,NULL,1),('2025-11-29 08:24:17','2025-11-29 08:24:44',NULL,0,84,'c1fc65ff70ce460c924739eae21e2b49','gigabytes',0,0,NULL,1),('2025-11-29 08:24:17','2025-11-29 08:24:44',NULL,0,85,'c1fc65ff70ce460c924739eae21e2b49','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:24:17','2025-11-29 08:24:44',NULL,0,86,'c1fc65ff70ce460c924739eae21e2b49','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:25:13','2025-11-29 08:27:39',NULL,0,87,'09cc8c3182d845f597dda064f9013941','volumes',0,0,NULL,1),('2025-11-29 08:25:13','2025-11-29 08:27:39',NULL,0,88,'09cc8c3182d845f597dda064f9013941','gigabytes',0,0,NULL,1),('2025-11-29 08:25:13','2025-11-29 08:27:39',NULL,0,89,'09cc8c3182d845f597dda064f9013941','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:25:13','2025-11-29 08:27:39',NULL,0,90,'09cc8c3182d845f597dda064f9013941','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:25:57','2025-11-29 08:29:27',NULL,0,91,'f9a9decdabb1480da8f7d039e8b3d414','volumes',0,0,NULL,1),('2025-11-29 08:25:57','2025-11-29 08:29:27',NULL,0,92,'f9a9decdabb1480da8f7d039e8b3d414','gigabytes',0,0,NULL,1),('2025-11-29 08:25:57','2025-11-29 08:29:27',NULL,0,93,'f9a9decdabb1480da8f7d039e8b3d414','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:25:57','2025-11-29 08:29:27',NULL,0,94,'f9a9decdabb1480da8f7d039e8b3d414','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:26:02','2025-11-29 08:26:30',NULL,0,95,'f9a9decdabb1480da8f7d039e8b3d414','snapshots',0,0,NULL,1),('2025-11-29 08:26:02','2025-11-29 08:26:30',NULL,0,96,'f9a9decdabb1480da8f7d039e8b3d414','snapshots___DEFAULT__',0,0,NULL,1),('2025-11-29 08:28:23','2025-11-29 08:31:42',NULL,0,97,'527c6a274d1e478eadfe67139e121185','volumes',0,0,NULL,1),('2025-11-29 08:28:23','2025-11-29 08:31:42',NULL,0,98,'527c6a274d1e478eadfe67139e121185','gigabytes',0,0,NULL,1),('2025-11-29 08:28:23','2025-11-29 08:30:52',NULL,0,99,'527c6a274d1e478eadfe67139e121185','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1215813445-983297764',0,0,NULL,1),('2025-11-29 08:28:23','2025-11-29 08:30:52',NULL,0,100,'527c6a274d1e478eadfe67139e121185','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1215813445-983297764',0,0,NULL,1),('2025-11-29 08:28:23','2025-11-29 08:30:59',NULL,0,101,'527c6a274d1e478eadfe67139e121185','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-138997613-1010843264',0,0,NULL,1),('2025-11-29 08:28:23','2025-11-29 08:30:59',NULL,0,102,'527c6a274d1e478eadfe67139e121185','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-138997613-1010843264',0,0,NULL,1),('2025-11-29 08:28:26','2025-11-29 08:31:42',NULL,0,103,'527c6a274d1e478eadfe67139e121185','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1807121858-762180852',0,0,NULL,1),('2025-11-29 08:28:26','2025-11-29 08:31:42',NULL,0,104,'527c6a274d1e478eadfe67139e121185','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1807121858-762180852',0,0,NULL,1),('2025-11-29 08:29:02','2025-11-29 08:32:35',NULL,0,105,'eb0810bf6f5b4eb59638b7a2cf59ed5b','volumes',0,0,NULL,1),('2025-11-29 08:29:02','2025-11-29 08:32:35',NULL,0,106,'eb0810bf6f5b4eb59638b7a2cf59ed5b','gigabytes',0,0,NULL,1),('2025-11-29 08:29:02','2025-11-29 08:32:35',NULL,0,107,'eb0810bf6f5b4eb59638b7a2cf59ed5b','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:29:02','2025-11-29 08:32:35',NULL,0,108,'eb0810bf6f5b4eb59638b7a2cf59ed5b','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:29:40','2025-11-29 08:29:52',NULL,0,109,'23450c2eaf4442459dec94c6d29f0412','snapshots',0,0,NULL,1),('2025-11-29 08:29:40','2025-11-29 08:29:52',NULL,0,110,'23450c2eaf4442459dec94c6d29f0412','snapshots_multiattach',0,0,NULL,1),('2025-11-29 08:30:15','2025-11-29 08:32:44',NULL,0,111,'7e8e7407a7c44208a503e8225c1cf518','volumes',0,0,NULL,1),('2025-11-29 08:30:15','2025-11-29 08:32:44',NULL,0,112,'7e8e7407a7c44208a503e8225c1cf518','gigabytes',0,0,NULL,1),('2025-11-29 08:30:15','2025-11-29 08:32:44',NULL,0,113,'7e8e7407a7c44208a503e8225c1cf518','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:30:15','2025-11-29 08:32:44',NULL,0,114,'7e8e7407a7c44208a503e8225c1cf518','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:31:00','2025-11-29 08:32:34',NULL,0,115,'7e8e7407a7c44208a503e8225c1cf518','snapshots',0,0,NULL,1),('2025-11-29 08:31:00','2025-11-29 08:32:34',NULL,0,116,'7e8e7407a7c44208a503e8225c1cf518','snapshots___DEFAULT__',0,0,NULL,1),('2025-11-29 08:31:13','2025-11-29 08:35:03',NULL,0,117,'37972b49ddde4c519c6523d2ea1569b5','volumes',0,0,NULL,1),('2025-11-29 08:31:13','2025-11-29 08:35:03',NULL,0,118,'37972b49ddde4c519c6523d2ea1569b5','gigabytes',0,0,NULL,1),('2025-11-29 08:31:13','2025-11-29 08:35:03',NULL,0,119,'37972b49ddde4c519c6523d2ea1569b5','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:31:13','2025-11-29 08:35:03',NULL,0,120,'37972b49ddde4c519c6523d2ea1569b5','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:32:47','2025-11-29 08:32:48',NULL,0,121,'12fcca7596944721afda13c50e6de05c','volumes',0,0,NULL,1),('2025-11-29 08:32:47','2025-11-29 08:32:48',NULL,0,122,'12fcca7596944721afda13c50e6de05c','gigabytes',0,0,NULL,1),('2025-11-29 08:32:47','2025-11-29 08:32:48',NULL,0,123,'12fcca7596944721afda13c50e6de05c','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:32:47','2025-11-29 08:32:48',NULL,0,124,'12fcca7596944721afda13c50e6de05c','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:33:24','2025-11-29 08:34:45',NULL,0,125,'340d97a89c434bedbead3110819c581d','volumes',0,0,NULL,1),('2025-11-29 08:33:24','2025-11-29 08:34:45',NULL,0,126,'340d97a89c434bedbead3110819c581d','gigabytes',0,0,NULL,1),('2025-11-29 08:33:24','2025-11-29 08:34:45',NULL,0,127,'340d97a89c434bedbead3110819c581d','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:33:24','2025-11-29 08:34:45',NULL,0,128,'340d97a89c434bedbead3110819c581d','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:33:36','2025-11-29 08:34:47',NULL,0,129,'340d97a89c434bedbead3110819c581d','backups',0,0,NULL,1),('2025-11-29 08:33:36','2025-11-29 08:34:47',NULL,0,130,'340d97a89c434bedbead3110819c581d','backup_gigabytes',0,0,NULL,1),('2025-11-29 08:36:05','2025-11-29 08:37:37',NULL,0,131,'3827b5eea76e4810b48ea1733ae5edc4','volumes',0,0,NULL,1),('2025-11-29 08:36:05','2025-11-29 08:37:37',NULL,0,132,'3827b5eea76e4810b48ea1733ae5edc4','gigabytes',0,0,NULL,1),('2025-11-29 08:36:05','2025-11-29 08:37:37',NULL,0,133,'3827b5eea76e4810b48ea1733ae5edc4','volumes_tempest-scenario-type-luks-596546322',0,0,NULL,1),('2025-11-29 08:36:05','2025-11-29 08:37:37',NULL,0,134,'3827b5eea76e4810b48ea1733ae5edc4','gigabytes_tempest-scenario-type-luks-596546322',0,0,NULL,1),('2025-11-29 08:48:55','2025-11-29 08:50:38',NULL,0,135,'c5e836f8387a492c8119be72f1fb9980','volumes',0,0,NULL,1),('2025-11-29 08:48:55','2025-11-29 08:50:38',NULL,0,136,'c5e836f8387a492c8119be72f1fb9980','gigabytes',0,0,NULL,1),('2025-11-29 08:48:55','2025-11-29 08:50:38',NULL,0,137,'c5e836f8387a492c8119be72f1fb9980','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 08:48:55','2025-11-29 08:50:38',NULL,0,138,'c5e836f8387a492c8119be72f1fb9980','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 09:07:16','2025-11-29 09:16:08',NULL,0,139,'51af0a2ee11a460ab825a484e5c6f4a3','volumes',0,0,NULL,1),('2025-11-29 09:07:16','2025-11-29 09:16:08',NULL,0,140,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes',0,0,NULL,1),('2025-11-29 09:07:16','2025-11-29 09:08:02',NULL,0,141,'51af0a2ee11a460ab825a484e5c6f4a3','volumes_tempest-scenario-type-luks-827233183',0,0,NULL,1),('2025-11-29 09:07:16','2025-11-29 09:08:02',NULL,0,142,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes_tempest-scenario-type-luks-827233183',0,0,NULL,1),('2025-11-29 09:08:06','2025-11-29 09:16:08',NULL,0,143,'51af0a2ee11a460ab825a484e5c6f4a3','volumes___DEFAULT__',0,0,NULL,1),('2025-11-29 09:08:06','2025-11-29 09:16:08',NULL,0,144,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes___DEFAULT__',0,0,NULL,1),('2025-11-29 09:09:11','2025-11-29 09:16:01',NULL,0,145,'51af0a2ee11a460ab825a484e5c6f4a3','snapshots',0,0,NULL,1),('2025-11-29 09:09:11','2025-11-29 09:16:01',NULL,0,146,'51af0a2ee11a460ab825a484e5c6f4a3','snapshots___DEFAULT__',0,0,NULL,1);
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  KEY `ix_reservations_project_id` (`project_id`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=605 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `allocated_id`) VALUES ('2025-11-29 07:42:11','2025-11-29 07:42:11','2025-11-29 07:42:11',1,1,'a5e87d3d-bacb-4a89-a008-41e5afa84625',1,'e5fa0a96b3534909a4900e2989849968','volumes',1,'2025-11-30 07:42:11',NULL),('2025-11-29 07:42:11','2025-11-29 07:42:11','2025-11-29 07:42:11',1,2,'cedcc010-4537-4db2-a58c-1a8d82aaadaa',2,'e5fa0a96b3534909a4900e2989849968','gigabytes',1,'2025-11-30 07:42:11',NULL),('2025-11-29 07:42:11','2025-11-29 07:42:11','2025-11-29 07:42:11',1,3,'35e82fb9-15fc-4394-bdfe-b931e445e9b2',3,'e5fa0a96b3534909a4900e2989849968','volumes___DEFAULT__',1,'2025-11-30 07:42:11',NULL),('2025-11-29 07:42:11','2025-11-29 07:42:11','2025-11-29 07:42:11',1,4,'b1126373-ebb1-4ebd-8fc7-1eb899b10151',4,'e5fa0a96b3534909a4900e2989849968','gigabytes___DEFAULT__',1,'2025-11-30 07:42:11',NULL),('2025-11-29 07:44:45','2025-11-29 07:44:45','2025-11-29 07:44:45',1,5,'dced9737-ef25-4d84-987f-1bc779623e70',1,'e5fa0a96b3534909a4900e2989849968','volumes',-1,'2025-11-30 07:44:45',NULL),('2025-11-29 07:44:45','2025-11-29 07:44:45','2025-11-29 07:44:45',1,6,'eccfa82e-c928-4f35-8802-054c3f75695a',2,'e5fa0a96b3534909a4900e2989849968','gigabytes',-1,'2025-11-30 07:44:45',NULL),('2025-11-29 07:44:45','2025-11-29 07:44:45','2025-11-29 07:44:45',1,7,'2311cbb8-ee1b-4f2b-8e07-56370530a972',3,'e5fa0a96b3534909a4900e2989849968','volumes___DEFAULT__',-1,'2025-11-30 07:44:45',NULL),('2025-11-29 07:44:45','2025-11-29 07:44:45','2025-11-29 07:44:45',1,8,'20d6a07e-2652-43a2-bda8-bae411a9f91b',4,'e5fa0a96b3534909a4900e2989849968','gigabytes___DEFAULT__',-1,'2025-11-30 07:44:45',NULL),('2025-11-29 07:47:39','2025-11-29 07:47:39','2025-11-29 07:47:39',1,9,'8948fed8-1331-46b4-a603-2a3f1f1fc0b2',5,'f3f16345721743ccb9afb374deec67b5','volumes',1,'2025-11-30 07:47:38',NULL),('2025-11-29 07:47:39','2025-11-29 07:47:39','2025-11-29 07:47:39',1,10,'6ed814a3-2316-4d5b-bc36-a11dfece16de',6,'f3f16345721743ccb9afb374deec67b5','gigabytes',1,'2025-11-30 07:47:38',NULL),('2025-11-29 07:47:39','2025-11-29 07:47:39','2025-11-29 07:47:39',1,11,'4db0ad4d-3347-4929-9b7d-027350e4f317',7,'f3f16345721743ccb9afb374deec67b5','volumes___DEFAULT__',1,'2025-11-30 07:47:38',NULL),('2025-11-29 07:47:39','2025-11-29 07:47:39','2025-11-29 07:47:39',1,12,'95893057-52f1-4750-bb3b-2e637d6792b6',8,'f3f16345721743ccb9afb374deec67b5','gigabytes___DEFAULT__',1,'2025-11-30 07:47:38',NULL),('2025-11-29 07:48:45','2025-11-29 07:48:45','2025-11-29 07:48:45',1,13,'013c80e9-b2c2-463a-baa6-f81d0553c4da',9,'b2c58ae2e706424fa3147694fc571db0','volumes',1,'2025-11-30 07:48:44',NULL),('2025-11-29 07:48:45','2025-11-29 07:48:45','2025-11-29 07:48:45',1,14,'96d786c4-7a73-4d1f-9468-3d9cf119975e',10,'b2c58ae2e706424fa3147694fc571db0','gigabytes',1,'2025-11-30 07:48:44',NULL),('2025-11-29 07:48:45','2025-11-29 07:48:45','2025-11-29 07:48:45',1,15,'95bf35e7-cfeb-4220-9fe0-c3a73074fe63',11,'b2c58ae2e706424fa3147694fc571db0','volumes_multiattach',1,'2025-11-30 07:48:44',NULL),('2025-11-29 07:48:45','2025-11-29 07:48:45','2025-11-29 07:48:45',1,16,'d948d3d9-8f8c-4239-b441-d49edb4b9500',12,'b2c58ae2e706424fa3147694fc571db0','gigabytes_multiattach',1,'2025-11-30 07:48:44',NULL),('2025-11-29 07:48:50','2025-11-29 07:48:50','2025-11-29 07:48:50',1,17,'d6183ecd-12c0-4861-8782-2da3113db6f2',9,'b2c58ae2e706424fa3147694fc571db0','volumes',1,'2025-11-30 07:48:50',NULL),('2025-11-29 07:48:50','2025-11-29 07:48:50','2025-11-29 07:48:50',1,18,'6bd01306-3fcb-4a39-8dab-5e1a1deb00cb',10,'b2c58ae2e706424fa3147694fc571db0','gigabytes',1,'2025-11-30 07:48:50',NULL),('2025-11-29 07:48:50','2025-11-29 07:48:50','2025-11-29 07:48:50',1,19,'b299831e-0f8b-4fef-adda-24e0a258c186',11,'b2c58ae2e706424fa3147694fc571db0','volumes_multiattach',1,'2025-11-30 07:48:50',NULL),('2025-11-29 07:48:50','2025-11-29 07:48:50','2025-11-29 07:48:50',1,20,'305b2001-8a92-4d8b-a2b6-169ad37e2351',12,'b2c58ae2e706424fa3147694fc571db0','gigabytes_multiattach',1,'2025-11-30 07:48:50',NULL),('2025-11-29 07:49:23','2025-11-29 07:49:23','2025-11-29 07:49:23',1,21,'665e9c76-d1b6-4886-a35c-1e42974cf65f',5,'f3f16345721743ccb9afb374deec67b5','volumes',-1,'2025-11-30 07:49:23',NULL),('2025-11-29 07:49:23','2025-11-29 07:49:23','2025-11-29 07:49:23',1,22,'cd682f6f-4157-40ce-b864-ad6944ec255a',6,'f3f16345721743ccb9afb374deec67b5','gigabytes',-1,'2025-11-30 07:49:23',NULL),('2025-11-29 07:49:23','2025-11-29 07:49:23','2025-11-29 07:49:23',1,23,'4d8735be-c198-4288-97f2-115eb95d8c48',7,'f3f16345721743ccb9afb374deec67b5','volumes___DEFAULT__',-1,'2025-11-30 07:49:23',NULL),('2025-11-29 07:49:23','2025-11-29 07:49:23','2025-11-29 07:49:23',1,24,'b9e9a1cb-acd1-4cb4-9249-c51ae023deda',8,'f3f16345721743ccb9afb374deec67b5','gigabytes___DEFAULT__',-1,'2025-11-30 07:49:23',NULL),('2025-11-29 07:50:58','2025-11-29 07:50:58','2025-11-29 07:50:58',1,25,'0e08364a-bceb-48ca-b5ff-80671c9f1c0c',13,'73f3d0f2c9aa4ba29984fc9e6a7ed869','volumes',1,'2025-11-30 07:50:58',NULL),('2025-11-29 07:50:58','2025-11-29 07:50:58','2025-11-29 07:50:58',1,26,'867d3daf-5de6-408f-bf73-942f6b82e6db',14,'73f3d0f2c9aa4ba29984fc9e6a7ed869','gigabytes',1,'2025-11-30 07:50:58',NULL),('2025-11-29 07:50:58','2025-11-29 07:50:58','2025-11-29 07:50:58',1,27,'b69ddd67-57ed-4748-aa59-3552d91073a4',15,'73f3d0f2c9aa4ba29984fc9e6a7ed869','volumes___DEFAULT__',1,'2025-11-30 07:50:58',NULL),('2025-11-29 07:50:58','2025-11-29 07:50:58','2025-11-29 07:50:58',1,28,'2d7743c4-3726-4fc8-bb6d-b4db8d8e6733',16,'73f3d0f2c9aa4ba29984fc9e6a7ed869','gigabytes___DEFAULT__',1,'2025-11-30 07:50:58',NULL),('2025-11-29 07:51:01','2025-11-29 07:51:02','2025-11-29 07:51:02',1,29,'b10bf53b-46b5-4d34-bfd4-b6ad2d7fe78e',9,'b2c58ae2e706424fa3147694fc571db0','volumes',-1,'2025-11-30 07:51:01',NULL),('2025-11-29 07:51:01','2025-11-29 07:51:02','2025-11-29 07:51:02',1,30,'8d3e961a-3e7b-411d-8a80-c89043b32540',10,'b2c58ae2e706424fa3147694fc571db0','gigabytes',-1,'2025-11-30 07:51:01',NULL),('2025-11-29 07:51:01','2025-11-29 07:51:02','2025-11-29 07:51:02',1,31,'a220cf6a-d084-433f-9091-74dd08fd66b7',11,'b2c58ae2e706424fa3147694fc571db0','volumes_multiattach',-1,'2025-11-30 07:51:01',NULL),('2025-11-29 07:51:01','2025-11-29 07:51:02','2025-11-29 07:51:02',1,32,'3bb16f55-ce80-49aa-8fd7-623f0bb5c0b8',12,'b2c58ae2e706424fa3147694fc571db0','gigabytes_multiattach',-1,'2025-11-30 07:51:01',NULL),('2025-11-29 07:51:06','2025-11-29 07:51:06','2025-11-29 07:51:06',1,33,'d4e758c8-82ea-4edf-ac8d-d14080f8e27f',9,'b2c58ae2e706424fa3147694fc571db0','volumes',-1,'2025-11-30 07:51:05',NULL),('2025-11-29 07:51:06','2025-11-29 07:51:06','2025-11-29 07:51:06',1,34,'257c652e-bab2-4309-96fc-76f92cf5982e',10,'b2c58ae2e706424fa3147694fc571db0','gigabytes',-1,'2025-11-30 07:51:05',NULL),('2025-11-29 07:51:06','2025-11-29 07:51:06','2025-11-29 07:51:06',1,35,'2e6833c1-d6fc-42a9-be8a-62e7eb7a1baa',11,'b2c58ae2e706424fa3147694fc571db0','volumes_multiattach',-1,'2025-11-30 07:51:05',NULL),('2025-11-29 07:51:06','2025-11-29 07:51:06','2025-11-29 07:51:06',1,36,'33f696b4-4e73-4cb6-a42f-bf95420cd4c7',12,'b2c58ae2e706424fa3147694fc571db0','gigabytes_multiattach',-1,'2025-11-30 07:51:05',NULL),('2025-11-29 07:53:00','2025-11-29 07:53:00','2025-11-29 07:53:00',1,37,'bcf5bfc8-1830-4e37-ad07-5bed7a2bdb79',13,'73f3d0f2c9aa4ba29984fc9e6a7ed869','volumes',-1,'2025-11-30 07:53:00',NULL),('2025-11-29 07:53:00','2025-11-29 07:53:00','2025-11-29 07:53:00',1,38,'07dda1e3-7ad2-4fb2-8eae-4e05e98f8ab1',14,'73f3d0f2c9aa4ba29984fc9e6a7ed869','gigabytes',-1,'2025-11-30 07:53:00',NULL),('2025-11-29 07:53:00','2025-11-29 07:53:00','2025-11-29 07:53:00',1,39,'b66037ad-4e78-42f3-8ab7-62a1449bfc3e',15,'73f3d0f2c9aa4ba29984fc9e6a7ed869','volumes___DEFAULT__',-1,'2025-11-30 07:53:00',NULL),('2025-11-29 07:53:00','2025-11-29 07:53:00','2025-11-29 07:53:00',1,40,'6af7b382-fc17-470e-8a7f-844658ef46e7',16,'73f3d0f2c9aa4ba29984fc9e6a7ed869','gigabytes___DEFAULT__',-1,'2025-11-30 07:53:00',NULL),('2025-11-29 07:53:40','2025-11-29 07:53:40','2025-11-29 07:53:40',1,41,'66587a77-6ecc-4b27-ab55-daefe8bbc497',17,'800c0f050e95457384eee582d6da0afa','volumes',1,'2025-11-30 07:53:40',NULL),('2025-11-29 07:53:40','2025-11-29 07:53:40','2025-11-29 07:53:40',1,42,'adb9afce-4622-4197-be66-f16b838b30cb',18,'800c0f050e95457384eee582d6da0afa','gigabytes',1,'2025-11-30 07:53:40',NULL),('2025-11-29 07:53:40','2025-11-29 07:53:40','2025-11-29 07:53:40',1,43,'fe523bef-8ce8-423d-bcbb-1f0ad9fd34b2',19,'800c0f050e95457384eee582d6da0afa','volumes___DEFAULT__',1,'2025-11-30 07:53:40',NULL),('2025-11-29 07:53:40','2025-11-29 07:53:40','2025-11-29 07:53:40',1,44,'ee9099cd-4b5d-4ab7-a2e2-b72058276a42',20,'800c0f050e95457384eee582d6da0afa','gigabytes___DEFAULT__',1,'2025-11-30 07:53:40',NULL),('2025-11-29 07:54:06','2025-11-29 07:54:06','2025-11-29 07:54:06',1,45,'45c31944-59ff-40a3-968f-1af3863fcf27',17,'800c0f050e95457384eee582d6da0afa','volumes',1,'2025-11-30 07:54:06',NULL),('2025-11-29 07:54:06','2025-11-29 07:54:06','2025-11-29 07:54:06',1,46,'c7e85773-6e52-4939-bc11-92a0c933f35f',18,'800c0f050e95457384eee582d6da0afa','gigabytes',1,'2025-11-30 07:54:06',NULL),('2025-11-29 07:54:06','2025-11-29 07:54:06','2025-11-29 07:54:06',1,47,'26ac5646-4148-4937-ac05-6713a3d21cde',19,'800c0f050e95457384eee582d6da0afa','volumes___DEFAULT__',1,'2025-11-30 07:54:06',NULL),('2025-11-29 07:54:06','2025-11-29 07:54:06','2025-11-29 07:54:06',1,48,'f9fc2b9b-3fe2-47b4-8d9a-ba4d21f253d0',20,'800c0f050e95457384eee582d6da0afa','gigabytes___DEFAULT__',1,'2025-11-30 07:54:06',NULL),('2025-11-29 07:54:10','2025-11-29 07:54:10','2025-11-29 07:54:10',1,49,'5d900d30-27bd-489f-8aee-00bdc96beebc',17,'800c0f050e95457384eee582d6da0afa','volumes',-1,'2025-11-30 07:54:10',NULL),('2025-11-29 07:54:10','2025-11-29 07:54:10','2025-11-29 07:54:10',1,50,'c6eb3dbf-3358-48b8-bb43-2b854d5f72f8',18,'800c0f050e95457384eee582d6da0afa','gigabytes',-1,'2025-11-30 07:54:10',NULL),('2025-11-29 07:54:10','2025-11-29 07:54:10','2025-11-29 07:54:10',1,51,'16e9dd74-99c8-4ea9-913b-af6ed7fc5ed9',19,'800c0f050e95457384eee582d6da0afa','volumes___DEFAULT__',-1,'2025-11-30 07:54:10',NULL),('2025-11-29 07:54:10','2025-11-29 07:54:10','2025-11-29 07:54:10',1,52,'78614a78-73f4-401e-b85f-af8c2c3064cb',20,'800c0f050e95457384eee582d6da0afa','gigabytes___DEFAULT__',-1,'2025-11-30 07:54:10',NULL),('2025-11-29 07:54:17','2025-11-29 07:54:17','2025-11-29 07:54:17',1,53,'af55019c-ced2-4e85-971e-2f792c59252d',17,'800c0f050e95457384eee582d6da0afa','volumes',-1,'2025-11-30 07:54:17',NULL),('2025-11-29 07:54:17','2025-11-29 07:54:17','2025-11-29 07:54:17',1,54,'241a1afb-78ef-4a0d-9e69-b1c18ad11706',18,'800c0f050e95457384eee582d6da0afa','gigabytes',-1,'2025-11-30 07:54:17',NULL),('2025-11-29 07:54:17','2025-11-29 07:54:17','2025-11-29 07:54:17',1,55,'692caf3e-dc3f-47bc-918d-7dee215e50be',19,'800c0f050e95457384eee582d6da0afa','volumes___DEFAULT__',-1,'2025-11-30 07:54:17',NULL),('2025-11-29 07:54:17','2025-11-29 07:54:17','2025-11-29 07:54:17',1,56,'7c8f7da4-308e-4821-9309-4f8d83ffb4a3',20,'800c0f050e95457384eee582d6da0afa','gigabytes___DEFAULT__',-1,'2025-11-30 07:54:17',NULL),('2025-11-29 07:55:25','2025-11-29 07:55:25','2025-11-29 07:55:25',1,57,'c0851e46-b128-4598-9838-a2e2b616a694',21,'666052d32183417982e59c456a19c744','volumes',1,'2025-11-30 07:55:25',NULL),('2025-11-29 07:55:25','2025-11-29 07:55:25','2025-11-29 07:55:25',1,58,'2e1d7a83-4f77-4284-b52c-178a088a2b23',22,'666052d32183417982e59c456a19c744','gigabytes',1,'2025-11-30 07:55:25',NULL),('2025-11-29 07:55:25','2025-11-29 07:55:25','2025-11-29 07:55:25',1,59,'de12a785-708b-4fd5-b5c6-7d01b8fc6639',23,'666052d32183417982e59c456a19c744','volumes___DEFAULT__',1,'2025-11-30 07:55:25',NULL),('2025-11-29 07:55:25','2025-11-29 07:55:25','2025-11-29 07:55:25',1,60,'4a50f913-dda1-4ffe-9963-399c7ee7218e',24,'666052d32183417982e59c456a19c744','gigabytes___DEFAULT__',1,'2025-11-30 07:55:25',NULL),('2025-11-29 07:55:52','2025-11-29 07:55:52','2025-11-29 07:55:52',1,61,'188042b8-d83c-4173-b950-e8338e2836d4',21,'666052d32183417982e59c456a19c744','volumes',-1,'2025-11-30 07:55:52',NULL),('2025-11-29 07:55:52','2025-11-29 07:55:52','2025-11-29 07:55:52',1,62,'3b2e54ab-3b14-464f-b965-2aa0d03ad840',22,'666052d32183417982e59c456a19c744','gigabytes',-1,'2025-11-30 07:55:52',NULL),('2025-11-29 07:55:52','2025-11-29 07:55:52','2025-11-29 07:55:52',1,63,'cfdef594-12bf-46bc-be85-adf5665444e7',23,'666052d32183417982e59c456a19c744','volumes___DEFAULT__',-1,'2025-11-30 07:55:52',NULL),('2025-11-29 07:55:52','2025-11-29 07:55:52','2025-11-29 07:55:52',1,64,'be5129ab-4450-4957-b009-33d9b51427b9',24,'666052d32183417982e59c456a19c744','gigabytes___DEFAULT__',-1,'2025-11-30 07:55:52',NULL),('2025-11-29 07:59:20','2025-11-29 07:59:21','2025-11-29 07:59:21',1,65,'72edceea-f20f-4610-9156-e1debbd3b2ad',25,'19b3dc1655684be39c6d284805874456','volumes',1,'2025-11-30 07:59:20',NULL),('2025-11-29 07:59:20','2025-11-29 07:59:21','2025-11-29 07:59:21',1,66,'df2ddf70-3325-44b1-a8cb-7fb27413595f',26,'19b3dc1655684be39c6d284805874456','gigabytes',1,'2025-11-30 07:59:20',NULL),('2025-11-29 07:59:20','2025-11-29 07:59:21','2025-11-29 07:59:21',1,67,'3f2216ee-19d6-4774-9292-182b018a2062',27,'19b3dc1655684be39c6d284805874456','volumes___DEFAULT__',1,'2025-11-30 07:59:20',NULL),('2025-11-29 07:59:20','2025-11-29 07:59:21','2025-11-29 07:59:21',1,68,'03af6423-e4cb-45cf-9239-6e5d68b730e7',28,'19b3dc1655684be39c6d284805874456','gigabytes___DEFAULT__',1,'2025-11-30 07:59:20',NULL),('2025-11-29 08:00:17','2025-11-29 08:00:17','2025-11-29 08:00:17',1,69,'7df453b0-974c-415e-babd-eca45118852c',25,'19b3dc1655684be39c6d284805874456','volumes',-1,'2025-11-30 08:00:17',NULL),('2025-11-29 08:00:17','2025-11-29 08:00:17','2025-11-29 08:00:17',1,70,'2f5e588a-11cb-46ed-b97e-ed8b9fac1892',26,'19b3dc1655684be39c6d284805874456','gigabytes',-1,'2025-11-30 08:00:17',NULL),('2025-11-29 08:00:17','2025-11-29 08:00:17','2025-11-29 08:00:17',1,71,'ca2ef76e-1833-4e28-ba4f-2851a51e21b4',27,'19b3dc1655684be39c6d284805874456','volumes___DEFAULT__',-1,'2025-11-30 08:00:17',NULL),('2025-11-29 08:00:17','2025-11-29 08:00:17','2025-11-29 08:00:17',1,72,'072ea487-e2fa-4c02-9ef8-d0a4a7eb8345',28,'19b3dc1655684be39c6d284805874456','gigabytes___DEFAULT__',-1,'2025-11-30 08:00:17',NULL),('2025-11-29 08:02:24','2025-11-29 08:02:24','2025-11-29 08:02:24',1,73,'630ab7cf-c319-42ca-bcad-a42155386ead',29,'faa91146f75c46ebbcd15bb2222a8545','volumes',1,'2025-11-30 08:02:24',NULL),('2025-11-29 08:02:24','2025-11-29 08:02:24','2025-11-29 08:02:24',1,74,'4f3bbbf5-ed12-418e-9809-8c553722b631',30,'faa91146f75c46ebbcd15bb2222a8545','gigabytes',1,'2025-11-30 08:02:24',NULL),('2025-11-29 08:02:24','2025-11-29 08:02:24','2025-11-29 08:02:24',1,75,'728b64ac-c9f6-4276-9c93-41906524517e',31,'faa91146f75c46ebbcd15bb2222a8545','volumes___DEFAULT__',1,'2025-11-30 08:02:24',NULL),('2025-11-29 08:02:24','2025-11-29 08:02:24','2025-11-29 08:02:24',1,76,'e6c3d39f-f17b-487b-8369-6f82f4803d83',32,'faa91146f75c46ebbcd15bb2222a8545','gigabytes___DEFAULT__',1,'2025-11-30 08:02:24',NULL),('2025-11-29 08:02:36','2025-11-29 08:02:36','2025-11-29 08:02:36',1,77,'7c464f0a-0ee2-4611-be66-4d6cd3e2dff8',29,'faa91146f75c46ebbcd15bb2222a8545','volumes',1,'2025-11-30 08:02:36',NULL),('2025-11-29 08:02:36','2025-11-29 08:02:36','2025-11-29 08:02:36',1,78,'d639d460-49a6-403d-9f5f-36688b9a8d13',30,'faa91146f75c46ebbcd15bb2222a8545','gigabytes',1,'2025-11-30 08:02:36',NULL),('2025-11-29 08:02:36','2025-11-29 08:02:36','2025-11-29 08:02:36',1,79,'3c8c091a-35d2-44f9-8514-da8aee59323a',31,'faa91146f75c46ebbcd15bb2222a8545','volumes___DEFAULT__',1,'2025-11-30 08:02:36',NULL),('2025-11-29 08:02:36','2025-11-29 08:02:36','2025-11-29 08:02:36',1,80,'719c3ae7-a71f-40e1-9681-bdcc09fcf42f',32,'faa91146f75c46ebbcd15bb2222a8545','gigabytes___DEFAULT__',1,'2025-11-30 08:02:36',NULL),('2025-11-29 08:02:38','2025-11-29 08:02:39','2025-11-29 08:02:39',1,81,'8794e0ba-8e7a-4dd8-a828-80f2a551de3d',29,'faa91146f75c46ebbcd15bb2222a8545','volumes',1,'2025-11-30 08:02:38',NULL),('2025-11-29 08:02:38','2025-11-29 08:02:39','2025-11-29 08:02:39',1,82,'551b8d03-a78b-42af-8d5c-385c3b259f47',30,'faa91146f75c46ebbcd15bb2222a8545','gigabytes',1,'2025-11-30 08:02:38',NULL),('2025-11-29 08:02:38','2025-11-29 08:02:39','2025-11-29 08:02:39',1,83,'8f201410-775b-4c70-8577-d74224e036de',31,'faa91146f75c46ebbcd15bb2222a8545','volumes___DEFAULT__',1,'2025-11-30 08:02:38',NULL),('2025-11-29 08:02:38','2025-11-29 08:02:39','2025-11-29 08:02:39',1,84,'dc797507-ddc6-4e09-93da-ef78e5e5b810',32,'faa91146f75c46ebbcd15bb2222a8545','gigabytes___DEFAULT__',1,'2025-11-30 08:02:38',NULL),('2025-11-29 08:03:15','2025-11-29 08:03:15','2025-11-29 08:03:15',1,85,'86daffac-9c06-4a58-9fd0-85410e72121b',33,'f8bc2a2616a34ba1a18b3211e406993f','volumes',1,'2025-11-30 08:03:15',NULL),('2025-11-29 08:03:15','2025-11-29 08:03:15','2025-11-29 08:03:15',1,86,'ac01c187-214d-40c8-af00-f4926d2a5fd4',34,'f8bc2a2616a34ba1a18b3211e406993f','gigabytes',1,'2025-11-30 08:03:15',NULL),('2025-11-29 08:03:15','2025-11-29 08:03:15','2025-11-29 08:03:15',1,87,'7f7ccfd8-19ed-41e4-85bf-9ed8270f7e4a',35,'f8bc2a2616a34ba1a18b3211e406993f','volumes___DEFAULT__',1,'2025-11-30 08:03:15',NULL),('2025-11-29 08:03:15','2025-11-29 08:03:15','2025-11-29 08:03:15',1,88,'45c7b3d8-74c4-4b9a-a2f2-ee4f5ad9c9aa',36,'f8bc2a2616a34ba1a18b3211e406993f','gigabytes___DEFAULT__',1,'2025-11-30 08:03:15',NULL),('2025-11-29 08:05:14','2025-11-29 08:05:14','2025-11-29 08:05:14',1,89,'10ea301f-b22c-4b6f-a3bd-6e9466b6955e',29,'faa91146f75c46ebbcd15bb2222a8545','volumes',-1,'2025-11-30 08:05:14',NULL),('2025-11-29 08:05:14','2025-11-29 08:05:14','2025-11-29 08:05:14',1,90,'24b1458e-1a5c-40c7-9a2a-f47dbd9594b1',30,'faa91146f75c46ebbcd15bb2222a8545','gigabytes',-1,'2025-11-30 08:05:14',NULL),('2025-11-29 08:05:14','2025-11-29 08:05:14','2025-11-29 08:05:14',1,91,'d38ee6cb-db71-47c2-a891-ab9e9a8a1ebc',31,'faa91146f75c46ebbcd15bb2222a8545','volumes___DEFAULT__',-1,'2025-11-30 08:05:14',NULL),('2025-11-29 08:05:14','2025-11-29 08:05:14','2025-11-29 08:05:14',1,92,'d6a05007-ab04-4e04-aa3d-66816da719ed',32,'faa91146f75c46ebbcd15bb2222a8545','gigabytes___DEFAULT__',-1,'2025-11-30 08:05:14',NULL),('2025-11-29 08:05:15','2025-11-29 08:05:15','2025-11-29 08:05:15',1,93,'2a21147c-a734-4ced-a63f-314f51a02e2b',29,'faa91146f75c46ebbcd15bb2222a8545','volumes',-1,'2025-11-30 08:05:15',NULL),('2025-11-29 08:05:15','2025-11-29 08:05:15','2025-11-29 08:05:15',1,94,'19571eec-04e4-42f0-bffa-c525f14f813c',30,'faa91146f75c46ebbcd15bb2222a8545','gigabytes',-1,'2025-11-30 08:05:15',NULL),('2025-11-29 08:05:15','2025-11-29 08:05:15','2025-11-29 08:05:15',1,95,'0f2f2015-02f9-4730-920a-e63b73db6664',31,'faa91146f75c46ebbcd15bb2222a8545','volumes___DEFAULT__',-1,'2025-11-30 08:05:15',NULL),('2025-11-29 08:05:15','2025-11-29 08:05:15','2025-11-29 08:05:15',1,96,'1ffac035-aecb-434e-bf46-e59af95ecece',32,'faa91146f75c46ebbcd15bb2222a8545','gigabytes___DEFAULT__',-1,'2025-11-30 08:05:15',NULL),('2025-11-29 08:05:17','2025-11-29 08:05:17','2025-11-29 08:05:17',1,97,'220dfea0-aa26-4399-aa4d-15038b0f7dcb',29,'faa91146f75c46ebbcd15bb2222a8545','volumes',-1,'2025-11-30 08:05:17',NULL),('2025-11-29 08:05:17','2025-11-29 08:05:17','2025-11-29 08:05:17',1,98,'9c15a4fc-80ad-4650-b1ab-5e62f3af26f5',30,'faa91146f75c46ebbcd15bb2222a8545','gigabytes',-1,'2025-11-30 08:05:17',NULL),('2025-11-29 08:05:17','2025-11-29 08:05:17','2025-11-29 08:05:17',1,99,'e51a0460-917c-42f6-9ff5-cfa77f88ee60',31,'faa91146f75c46ebbcd15bb2222a8545','volumes___DEFAULT__',-1,'2025-11-30 08:05:17',NULL),('2025-11-29 08:05:17','2025-11-29 08:05:17','2025-11-29 08:05:17',1,100,'cfa4ab7d-2b41-48f0-9d1e-b65f436414a9',32,'faa91146f75c46ebbcd15bb2222a8545','gigabytes___DEFAULT__',-1,'2025-11-30 08:05:17',NULL),('2025-11-29 08:06:15','2025-11-29 08:06:15','2025-11-29 08:06:15',1,101,'52f20073-63c3-4f19-8d9d-18ac8400e1a6',37,'e61a0774e90545289bd82e4a71650bde','volumes',1,'2025-11-30 08:06:15',NULL),('2025-11-29 08:06:15','2025-11-29 08:06:15','2025-11-29 08:06:15',1,102,'6f90f86f-e8db-412b-8e3e-ec7278500e75',38,'e61a0774e90545289bd82e4a71650bde','gigabytes',1,'2025-11-30 08:06:15',NULL),('2025-11-29 08:06:15','2025-11-29 08:06:15','2025-11-29 08:06:15',1,103,'77926959-ca1a-4ab0-b59c-385eabdee2fb',39,'e61a0774e90545289bd82e4a71650bde','volumes___DEFAULT__',1,'2025-11-30 08:06:15',NULL),('2025-11-29 08:06:15','2025-11-29 08:06:15','2025-11-29 08:06:15',1,104,'6b95c300-8cf3-4c1e-af82-44ede476246a',40,'e61a0774e90545289bd82e4a71650bde','gigabytes___DEFAULT__',1,'2025-11-30 08:06:15',NULL),('2025-11-29 08:06:22','2025-11-29 08:06:22','2025-11-29 08:06:22',1,105,'48fe3ff3-0e76-43b8-8dcb-483cfe481106',37,'e61a0774e90545289bd82e4a71650bde','volumes',1,'2025-11-30 08:06:22',NULL),('2025-11-29 08:06:22','2025-11-29 08:06:22','2025-11-29 08:06:22',1,106,'308939ac-88fe-424f-a837-34ea0d511692',38,'e61a0774e90545289bd82e4a71650bde','gigabytes',1,'2025-11-30 08:06:22',NULL),('2025-11-29 08:06:22','2025-11-29 08:06:22','2025-11-29 08:06:22',1,107,'f865b19f-d04b-4341-84a3-9aed8c6889b2',39,'e61a0774e90545289bd82e4a71650bde','volumes___DEFAULT__',1,'2025-11-30 08:06:22',NULL),('2025-11-29 08:06:22','2025-11-29 08:06:22','2025-11-29 08:06:22',1,108,'a4d16b5e-fc04-4d28-921a-ccbf66a3fd94',40,'e61a0774e90545289bd82e4a71650bde','gigabytes___DEFAULT__',1,'2025-11-30 08:06:22',NULL),('2025-11-29 08:06:24','2025-11-29 08:06:24','2025-11-29 08:06:24',1,109,'58682c7d-25e0-46d5-bbe5-176aa95beb5a',37,'e61a0774e90545289bd82e4a71650bde','volumes',1,'2025-11-30 08:06:24',NULL),('2025-11-29 08:06:24','2025-11-29 08:06:24','2025-11-29 08:06:24',1,110,'fda3534a-1f32-454d-91c5-16ba1edcc9ac',38,'e61a0774e90545289bd82e4a71650bde','gigabytes',1,'2025-11-30 08:06:24',NULL),('2025-11-29 08:06:24','2025-11-29 08:06:24','2025-11-29 08:06:24',1,111,'8eaeec5c-31b0-4032-95d9-4252f9962f2e',39,'e61a0774e90545289bd82e4a71650bde','volumes___DEFAULT__',1,'2025-11-30 08:06:24',NULL),('2025-11-29 08:06:24','2025-11-29 08:06:24','2025-11-29 08:06:24',1,112,'3392b85b-fec4-4e40-98af-2b4735e5ab34',40,'e61a0774e90545289bd82e4a71650bde','gigabytes___DEFAULT__',1,'2025-11-30 08:06:24',NULL),('2025-11-29 08:06:41','2025-11-29 08:06:41','2025-11-29 08:06:41',1,113,'9174d4ea-f959-4126-8f83-07b86a70971a',33,'f8bc2a2616a34ba1a18b3211e406993f','volumes',-1,'2025-11-30 08:06:41',NULL),('2025-11-29 08:06:41','2025-11-29 08:06:41','2025-11-29 08:06:41',1,114,'afc584ff-0f34-4dfd-b65a-1b73e365f909',34,'f8bc2a2616a34ba1a18b3211e406993f','gigabytes',-1,'2025-11-30 08:06:41',NULL),('2025-11-29 08:06:41','2025-11-29 08:06:41','2025-11-29 08:06:41',1,115,'f623bf04-6fcb-4e86-a277-b7de44676cab',35,'f8bc2a2616a34ba1a18b3211e406993f','volumes___DEFAULT__',-1,'2025-11-30 08:06:41',NULL),('2025-11-29 08:06:41','2025-11-29 08:06:41','2025-11-29 08:06:41',1,116,'1b4cab00-e42d-4467-b340-3b23e385308c',36,'f8bc2a2616a34ba1a18b3211e406993f','gigabytes___DEFAULT__',-1,'2025-11-30 08:06:41',NULL),('2025-11-29 08:07:26','2025-11-29 08:07:26','2025-11-29 08:07:26',1,117,'81ce45cb-514d-4b44-8e9c-b6152913dfee',41,'a6104c57e0814f16958b14707debf843','volumes',1,'2025-11-30 08:07:26',NULL),('2025-11-29 08:07:26','2025-11-29 08:07:26','2025-11-29 08:07:26',1,118,'24287b37-a163-4eac-bf3a-98f86d7da451',42,'a6104c57e0814f16958b14707debf843','gigabytes',1,'2025-11-30 08:07:26',NULL),('2025-11-29 08:07:26','2025-11-29 08:07:26','2025-11-29 08:07:26',1,119,'038a7208-d82e-483c-adef-be921d9a4937',43,'a6104c57e0814f16958b14707debf843','volumes___DEFAULT__',1,'2025-11-30 08:07:26',NULL),('2025-11-29 08:07:26','2025-11-29 08:07:26','2025-11-29 08:07:26',1,120,'4db63224-b270-46fc-bbba-cd6280b5cd2d',44,'a6104c57e0814f16958b14707debf843','gigabytes___DEFAULT__',1,'2025-11-30 08:07:26',NULL),('2025-11-29 08:08:34','2025-11-29 08:08:34','2025-11-29 08:08:34',1,121,'0af9f577-64f6-4c4e-ac7c-2ab407d7d309',41,'a6104c57e0814f16958b14707debf843','volumes',-1,'2025-11-30 08:08:34',NULL),('2025-11-29 08:08:34','2025-11-29 08:08:34','2025-11-29 08:08:34',1,122,'ff8ba5d3-a68a-4cb4-80a5-843da3b2d6ba',42,'a6104c57e0814f16958b14707debf843','gigabytes',-1,'2025-11-30 08:08:34',NULL),('2025-11-29 08:08:34','2025-11-29 08:08:34','2025-11-29 08:08:34',1,123,'e97d474f-b3ce-4870-8bfc-8d118bba7132',43,'a6104c57e0814f16958b14707debf843','volumes___DEFAULT__',-1,'2025-11-30 08:08:34',NULL),('2025-11-29 08:08:34','2025-11-29 08:08:34','2025-11-29 08:08:34',1,124,'db576809-e6f9-43c0-98ff-c3afa3aaccc9',44,'a6104c57e0814f16958b14707debf843','gigabytes___DEFAULT__',-1,'2025-11-30 08:08:34',NULL),('2025-11-29 08:08:40','2025-11-29 08:08:40','2025-11-29 08:08:40',1,125,'bb18b212-6f2a-4155-a795-b0729ad0ec15',37,'e61a0774e90545289bd82e4a71650bde','volumes',-1,'2025-11-30 08:08:40',NULL),('2025-11-29 08:08:40','2025-11-29 08:08:40','2025-11-29 08:08:40',1,126,'0ea2f393-590c-4a1a-83f8-e2598671cec6',38,'e61a0774e90545289bd82e4a71650bde','gigabytes',-1,'2025-11-30 08:08:40',NULL),('2025-11-29 08:08:40','2025-11-29 08:08:40','2025-11-29 08:08:40',1,127,'54fb63e6-3fd2-4138-bf5b-0c28e18d082c',39,'e61a0774e90545289bd82e4a71650bde','volumes___DEFAULT__',-1,'2025-11-30 08:08:40',NULL),('2025-11-29 08:08:40','2025-11-29 08:08:40','2025-11-29 08:08:40',1,128,'e9692f73-6130-42c1-804a-f379b5be4776',40,'e61a0774e90545289bd82e4a71650bde','gigabytes___DEFAULT__',-1,'2025-11-30 08:08:40',NULL),('2025-11-29 08:08:41','2025-11-29 08:08:41','2025-11-29 08:08:41',1,129,'be7319c6-abc7-424a-b07f-1f1d204f61fd',37,'e61a0774e90545289bd82e4a71650bde','volumes',-1,'2025-11-30 08:08:41',NULL),('2025-11-29 08:08:41','2025-11-29 08:08:41','2025-11-29 08:08:41',1,130,'5f789b6c-340d-48ba-aa3e-d86c5b370422',38,'e61a0774e90545289bd82e4a71650bde','gigabytes',-1,'2025-11-30 08:08:41',NULL),('2025-11-29 08:08:41','2025-11-29 08:08:41','2025-11-29 08:08:41',1,131,'feec2f2d-5123-41d1-b1ed-7720caac9c5a',39,'e61a0774e90545289bd82e4a71650bde','volumes___DEFAULT__',-1,'2025-11-30 08:08:41',NULL),('2025-11-29 08:08:41','2025-11-29 08:08:41','2025-11-29 08:08:41',1,132,'c72fa890-cd42-44e1-b299-9fa667d3dff4',40,'e61a0774e90545289bd82e4a71650bde','gigabytes___DEFAULT__',-1,'2025-11-30 08:08:41',NULL),('2025-11-29 08:08:43','2025-11-29 08:08:43','2025-11-29 08:08:43',1,133,'5ef1936b-e4e3-4358-88f0-85eb18276979',37,'e61a0774e90545289bd82e4a71650bde','volumes',-1,'2025-11-30 08:08:43',NULL),('2025-11-29 08:08:43','2025-11-29 08:08:43','2025-11-29 08:08:43',1,134,'52ddb9f3-f056-4654-b7a1-b8434fd03cf4',38,'e61a0774e90545289bd82e4a71650bde','gigabytes',-1,'2025-11-30 08:08:43',NULL),('2025-11-29 08:08:43','2025-11-29 08:08:43','2025-11-29 08:08:43',1,135,'c1ba7972-c0dd-48dd-9cf1-6648a1d82824',39,'e61a0774e90545289bd82e4a71650bde','volumes___DEFAULT__',-1,'2025-11-30 08:08:43',NULL),('2025-11-29 08:08:43','2025-11-29 08:08:43','2025-11-29 08:08:43',1,136,'010cd61b-10f4-43af-8275-f8cb4b3a880e',40,'e61a0774e90545289bd82e4a71650bde','gigabytes___DEFAULT__',-1,'2025-11-30 08:08:43',NULL),('2025-11-29 08:11:44','2025-11-29 08:11:44','2025-11-29 08:11:44',1,137,'2a8f1c9c-b980-4540-a9f6-345f2d98d8f1',45,'146c65131f5b423287d348b351399c4e','volumes',1,'2025-11-30 08:11:44',NULL),('2025-11-29 08:11:44','2025-11-29 08:11:44','2025-11-29 08:11:44',1,138,'d5bfb62b-ce78-4cbf-9def-eef4d14d381e',46,'146c65131f5b423287d348b351399c4e','gigabytes',1,'2025-11-30 08:11:44',NULL),('2025-11-29 08:11:44','2025-11-29 08:11:44','2025-11-29 08:11:44',1,139,'411d95c5-1613-45a6-8df8-458c77635460',47,'146c65131f5b423287d348b351399c4e','volumes___DEFAULT__',1,'2025-11-30 08:11:44',NULL),('2025-11-29 08:11:44','2025-11-29 08:11:44','2025-11-29 08:11:44',1,140,'11a7ff4b-8f27-414a-955d-e54733106eb9',48,'146c65131f5b423287d348b351399c4e','gigabytes___DEFAULT__',1,'2025-11-30 08:11:44',NULL),('2025-11-29 08:12:38','2025-11-29 08:12:38','2025-11-29 08:12:38',1,141,'12471eb1-d244-409f-a934-f1799f176fcb',49,'250671461f27498d9f6b4476c7b69533','volumes',1,'2025-11-30 08:12:38',NULL),('2025-11-29 08:12:38','2025-11-29 08:12:38','2025-11-29 08:12:38',1,142,'4fb28fba-72df-49d3-a20e-b7a57cefe520',50,'250671461f27498d9f6b4476c7b69533','gigabytes',1,'2025-11-30 08:12:38',NULL),('2025-11-29 08:12:38','2025-11-29 08:12:38','2025-11-29 08:12:38',1,143,'84064b8b-37bd-42f8-bbd5-bfe745b2e002',51,'250671461f27498d9f6b4476c7b69533','volumes___DEFAULT__',1,'2025-11-30 08:12:38',NULL),('2025-11-29 08:12:38','2025-11-29 08:12:38','2025-11-29 08:12:38',1,144,'c450cdec-0198-4cbb-a33e-c10f0ca3256e',52,'250671461f27498d9f6b4476c7b69533','gigabytes___DEFAULT__',1,'2025-11-30 08:12:38',NULL),('2025-11-29 08:13:46','2025-11-29 08:13:46','2025-11-29 08:13:46',1,145,'6b9d9ca0-22b7-45aa-bd22-528084cc0452',53,'ba867fac17034bb28fe2cdb0fff3af2b','volumes',1,'2025-11-30 08:13:46',NULL),('2025-11-29 08:13:46','2025-11-29 08:13:46','2025-11-29 08:13:46',1,146,'b0d9776b-02fd-411d-a998-036511f970a0',54,'ba867fac17034bb28fe2cdb0fff3af2b','gigabytes',1,'2025-11-30 08:13:46',NULL),('2025-11-29 08:13:46','2025-11-29 08:13:46','2025-11-29 08:13:46',1,147,'ab37b0b0-f018-40e0-8ab7-3b5fde71d62b',55,'ba867fac17034bb28fe2cdb0fff3af2b','volumes___DEFAULT__',1,'2025-11-30 08:13:46',NULL),('2025-11-29 08:13:46','2025-11-29 08:13:46','2025-11-29 08:13:46',1,148,'639b8b44-52af-4f2f-8654-2f1c99849287',56,'ba867fac17034bb28fe2cdb0fff3af2b','gigabytes___DEFAULT__',1,'2025-11-30 08:13:46',NULL),('2025-11-29 08:14:04','2025-11-29 08:14:04','2025-11-29 08:14:04',1,149,'3819a4c2-7158-4654-af01-29233863abad',45,'146c65131f5b423287d348b351399c4e','volumes',-1,'2025-11-30 08:14:04',NULL),('2025-11-29 08:14:04','2025-11-29 08:14:04','2025-11-29 08:14:04',1,150,'4e5ceca2-737e-4fcd-942f-96f0d8caefa2',46,'146c65131f5b423287d348b351399c4e','gigabytes',-1,'2025-11-30 08:14:04',NULL),('2025-11-29 08:14:04','2025-11-29 08:14:04','2025-11-29 08:14:04',1,151,'17d6db70-f74a-400b-8c90-071bab69f5f8',47,'146c65131f5b423287d348b351399c4e','volumes___DEFAULT__',-1,'2025-11-30 08:14:04',NULL),('2025-11-29 08:14:04','2025-11-29 08:14:04','2025-11-29 08:14:04',1,152,'2d637929-be9c-4038-9238-7f34daf5e7c7',48,'146c65131f5b423287d348b351399c4e','gigabytes___DEFAULT__',-1,'2025-11-30 08:14:04',NULL),('2025-11-29 08:14:34','2025-11-29 08:14:34','2025-11-29 08:14:34',1,153,'79a798a7-01b1-4f27-af52-49050c9f6228',49,'250671461f27498d9f6b4476c7b69533','volumes',1,'2025-11-30 08:14:34',NULL),('2025-11-29 08:14:34','2025-11-29 08:14:34','2025-11-29 08:14:34',1,154,'bb173419-5b69-4c5d-be91-208e8db43362',50,'250671461f27498d9f6b4476c7b69533','gigabytes',1,'2025-11-30 08:14:34',NULL),('2025-11-29 08:14:34','2025-11-29 08:14:34','2025-11-29 08:14:34',1,155,'0251599f-fc10-4ca5-9364-8e8a02744147',51,'250671461f27498d9f6b4476c7b69533','volumes___DEFAULT__',1,'2025-11-30 08:14:34',NULL),('2025-11-29 08:14:34','2025-11-29 08:14:34','2025-11-29 08:14:34',1,156,'233a7002-aff7-45d8-943a-25bcfac67638',52,'250671461f27498d9f6b4476c7b69533','gigabytes___DEFAULT__',1,'2025-11-30 08:14:34',NULL),('2025-11-29 08:15:55','2025-11-29 08:15:55','2025-11-29 08:15:55',1,157,'651f1be1-1beb-4e6f-803c-cc5327066b48',49,'250671461f27498d9f6b4476c7b69533','volumes',-1,'2025-11-30 08:15:55',NULL),('2025-11-29 08:15:55','2025-11-29 08:15:55','2025-11-29 08:15:55',1,158,'0432a840-123a-4394-868e-b26634d3d5e3',50,'250671461f27498d9f6b4476c7b69533','gigabytes',-1,'2025-11-30 08:15:55',NULL),('2025-11-29 08:15:55','2025-11-29 08:15:55','2025-11-29 08:15:55',1,159,'7b57ce51-716d-4f6f-a03c-fe20163ea5eb',51,'250671461f27498d9f6b4476c7b69533','volumes___DEFAULT__',-1,'2025-11-30 08:15:55',NULL),('2025-11-29 08:15:55','2025-11-29 08:15:55','2025-11-29 08:15:55',1,160,'7a8d9e05-7582-4c2d-9d0a-56b360e30cf6',52,'250671461f27498d9f6b4476c7b69533','gigabytes___DEFAULT__',-1,'2025-11-30 08:15:55',NULL),('2025-11-29 08:15:59','2025-11-29 08:15:59','2025-11-29 08:15:59',1,161,'a7143a71-ce73-4226-a645-5c2c2bdc07ab',49,'250671461f27498d9f6b4476c7b69533','volumes',-1,'2025-11-30 08:15:59',NULL),('2025-11-29 08:15:59','2025-11-29 08:15:59','2025-11-29 08:15:59',1,162,'a8869cf4-8785-418f-b98c-da807b258835',50,'250671461f27498d9f6b4476c7b69533','gigabytes',-1,'2025-11-30 08:15:59',NULL),('2025-11-29 08:15:59','2025-11-29 08:15:59','2025-11-29 08:15:59',1,163,'e2a2a25f-908d-4454-9d5f-c7dde77b7e8c',51,'250671461f27498d9f6b4476c7b69533','volumes___DEFAULT__',-1,'2025-11-30 08:15:59',NULL),('2025-11-29 08:15:59','2025-11-29 08:15:59','2025-11-29 08:15:59',1,164,'9d5cc856-4c9a-4c3f-88ac-7aef2fe101b5',52,'250671461f27498d9f6b4476c7b69533','gigabytes___DEFAULT__',-1,'2025-11-30 08:15:59',NULL),('2025-11-29 08:16:33','2025-11-29 08:16:33','2025-11-29 08:16:33',1,165,'3fd52647-e82c-4a58-9b9f-041d334a4348',53,'ba867fac17034bb28fe2cdb0fff3af2b','volumes',-1,'2025-11-30 08:16:33',NULL),('2025-11-29 08:16:33','2025-11-29 08:16:33','2025-11-29 08:16:33',1,166,'d3e0146c-3cd0-4aa2-aa75-1d9f36804b39',54,'ba867fac17034bb28fe2cdb0fff3af2b','gigabytes',-1,'2025-11-30 08:16:33',NULL),('2025-11-29 08:16:33','2025-11-29 08:16:33','2025-11-29 08:16:33',1,167,'28194ff1-23b3-49b6-812c-2293572834b9',55,'ba867fac17034bb28fe2cdb0fff3af2b','volumes___DEFAULT__',-1,'2025-11-30 08:16:33',NULL),('2025-11-29 08:16:33','2025-11-29 08:16:33','2025-11-29 08:16:33',1,168,'9081aab8-15d9-4800-b5f8-1320310ecea0',56,'ba867fac17034bb28fe2cdb0fff3af2b','gigabytes___DEFAULT__',-1,'2025-11-30 08:16:33',NULL),('2025-11-29 08:18:09','2025-11-29 08:18:09','2025-11-29 08:18:09',1,169,'ec70780a-6126-465c-96cc-4476babe999d',57,'b9d4c81989d641678300c7a1c173a2c2','volumes',1,'2025-11-30 08:18:09',NULL),('2025-11-29 08:18:09','2025-11-29 08:18:09','2025-11-29 08:18:09',1,170,'a99286a9-4a15-4920-9edd-9316e829457b',58,'b9d4c81989d641678300c7a1c173a2c2','gigabytes',1,'2025-11-30 08:18:09',NULL),('2025-11-29 08:18:09','2025-11-29 08:18:09','2025-11-29 08:18:09',1,171,'d7caf9ae-a0af-49f3-990d-bfac24f29dcf',59,'b9d4c81989d641678300c7a1c173a2c2','volumes___DEFAULT__',1,'2025-11-30 08:18:09',NULL),('2025-11-29 08:18:09','2025-11-29 08:18:09','2025-11-29 08:18:09',1,172,'20d2194d-81ec-44e9-bed8-779b27cda43c',60,'b9d4c81989d641678300c7a1c173a2c2','gigabytes___DEFAULT__',1,'2025-11-30 08:18:09',NULL),('2025-11-29 08:20:02','2025-11-29 08:20:02','2025-11-29 08:20:02',1,173,'88029fd3-aeaa-4a49-8f47-de6d1ac11e0b',61,'61d8d3b6b31f4b36b5749db9c550c696','volumes',1,'2025-11-30 08:20:02',NULL),('2025-11-29 08:20:02','2025-11-29 08:20:02','2025-11-29 08:20:02',1,174,'0a756652-4337-43bd-8cb9-e5945abf2996',62,'61d8d3b6b31f4b36b5749db9c550c696','gigabytes',1,'2025-11-30 08:20:02',NULL),('2025-11-29 08:20:02','2025-11-29 08:20:02','2025-11-29 08:20:02',1,175,'8eb7db12-74ad-4893-bd60-181e57889300',63,'61d8d3b6b31f4b36b5749db9c550c696','volumes___DEFAULT__',1,'2025-11-30 08:20:02',NULL),('2025-11-29 08:20:02','2025-11-29 08:20:02','2025-11-29 08:20:02',1,176,'da70035a-aad0-43c7-b142-cb2b6d4a2c19',64,'61d8d3b6b31f4b36b5749db9c550c696','gigabytes___DEFAULT__',1,'2025-11-30 08:20:02',NULL),('2025-11-29 08:20:09','2025-11-29 08:20:09','2025-11-29 08:20:09',1,177,'35723ebd-b70d-4175-84c9-dda2131b591a',57,'b9d4c81989d641678300c7a1c173a2c2','volumes',1,'2025-11-30 08:20:09',NULL),('2025-11-29 08:20:09','2025-11-29 08:20:09','2025-11-29 08:20:09',1,178,'35e877bf-5f1c-4bd8-a37c-4259ab11afc6',58,'b9d4c81989d641678300c7a1c173a2c2','gigabytes',1,'2025-11-30 08:20:09',NULL),('2025-11-29 08:20:09','2025-11-29 08:20:09','2025-11-29 08:20:09',1,179,'86a21825-8f40-4345-ab9b-a0e9d339a1a9',59,'b9d4c81989d641678300c7a1c173a2c2','volumes___DEFAULT__',1,'2025-11-30 08:20:09',NULL),('2025-11-29 08:20:09','2025-11-29 08:20:09','2025-11-29 08:20:09',1,180,'1bdd58f7-feaf-4692-9898-22f765bf5623',60,'b9d4c81989d641678300c7a1c173a2c2','gigabytes___DEFAULT__',1,'2025-11-30 08:20:09',NULL),('2025-11-29 08:20:49','2025-11-29 08:20:49','2025-11-29 08:20:49',1,181,'168c3985-34d0-43f3-a313-9be7edec0f10',65,'358970eca7ad4b05b70f43e5507ac052','volumes',1,'2025-11-30 08:20:49',NULL),('2025-11-29 08:20:49','2025-11-29 08:20:49','2025-11-29 08:20:49',1,182,'68e80b52-ce60-4bd5-a845-c69651d011c2',66,'358970eca7ad4b05b70f43e5507ac052','gigabytes',1,'2025-11-30 08:20:49',NULL),('2025-11-29 08:20:49','2025-11-29 08:20:49','2025-11-29 08:20:49',1,183,'abe3a55f-7499-4f30-9ceb-b01894b90df9',67,'358970eca7ad4b05b70f43e5507ac052','volumes___DEFAULT__',1,'2025-11-30 08:20:49',NULL),('2025-11-29 08:20:49','2025-11-29 08:20:49','2025-11-29 08:20:49',1,184,'392e6b73-4eb1-4b5f-aa5b-4b5e24535d80',68,'358970eca7ad4b05b70f43e5507ac052','gigabytes___DEFAULT__',1,'2025-11-30 08:20:49',NULL),('2025-11-29 08:22:09','2025-11-29 08:22:09','2025-11-29 08:22:09',1,185,'a8c0fefb-3540-438b-82c6-09dc7f26f052',61,'61d8d3b6b31f4b36b5749db9c550c696','volumes',1,'2025-11-30 08:22:09',NULL),('2025-11-29 08:22:09','2025-11-29 08:22:09','2025-11-29 08:22:09',1,186,'95f64760-5b07-4b03-b0b1-90a40357521a',62,'61d8d3b6b31f4b36b5749db9c550c696','gigabytes',1,'2025-11-30 08:22:09',NULL),('2025-11-29 08:22:09','2025-11-29 08:22:09','2025-11-29 08:22:09',1,187,'642e1923-7e69-438a-a9cf-a56b303fafbb',63,'61d8d3b6b31f4b36b5749db9c550c696','volumes___DEFAULT__',1,'2025-11-30 08:22:09',NULL),('2025-11-29 08:22:09','2025-11-29 08:22:09','2025-11-29 08:22:09',1,188,'4a574c52-042e-4ed5-9c94-eb06fe5249f8',64,'61d8d3b6b31f4b36b5749db9c550c696','gigabytes___DEFAULT__',1,'2025-11-30 08:22:09',NULL),('2025-11-29 08:22:56','2025-11-29 08:22:56','2025-11-29 08:22:56',1,189,'84efe7f6-5e8b-47e2-9c35-d6e06960dbe3',65,'358970eca7ad4b05b70f43e5507ac052','volumes',-1,'2025-11-30 08:22:56',NULL),('2025-11-29 08:22:56','2025-11-29 08:22:56','2025-11-29 08:22:56',1,190,'dea8e366-3798-4900-b695-9c9042488a6b',66,'358970eca7ad4b05b70f43e5507ac052','gigabytes',-1,'2025-11-30 08:22:56',NULL),('2025-11-29 08:22:56','2025-11-29 08:22:56','2025-11-29 08:22:56',1,191,'8697834b-ef25-40ce-9d92-d93c1a3b3a7e',67,'358970eca7ad4b05b70f43e5507ac052','volumes___DEFAULT__',-1,'2025-11-30 08:22:56',NULL),('2025-11-29 08:22:56','2025-11-29 08:22:56','2025-11-29 08:22:56',1,192,'25b6c5c2-b131-4f4b-a0c6-20732ea38dc6',68,'358970eca7ad4b05b70f43e5507ac052','gigabytes___DEFAULT__',-1,'2025-11-30 08:22:56',NULL),('2025-11-29 08:23:04','2025-11-29 08:23:04','2025-11-29 08:23:04',1,193,'f2f7ad3c-964f-4d41-bc34-d51c238bb516',61,'61d8d3b6b31f4b36b5749db9c550c696','volumes',1,'2025-11-30 08:23:04',NULL),('2025-11-29 08:23:04','2025-11-29 08:23:04','2025-11-29 08:23:04',1,194,'d7d091c5-07aa-475d-9dee-64ba767fdce3',62,'61d8d3b6b31f4b36b5749db9c550c696','gigabytes',1,'2025-11-30 08:23:04',NULL),('2025-11-29 08:23:04','2025-11-29 08:23:04','2025-11-29 08:23:04',1,195,'86c4a42f-7109-4b74-9425-49f826e5ef00',63,'61d8d3b6b31f4b36b5749db9c550c696','volumes___DEFAULT__',1,'2025-11-30 08:23:04',NULL),('2025-11-29 08:23:04','2025-11-29 08:23:04','2025-11-29 08:23:04',1,196,'3fe31ba4-1f56-4b5a-a7c2-e747f54fe89d',64,'61d8d3b6b31f4b36b5749db9c550c696','gigabytes___DEFAULT__',1,'2025-11-30 08:23:04',NULL),('2025-11-29 08:23:20','2025-11-29 08:23:20','2025-11-29 08:23:20',1,197,'2eefb335-f69e-432e-bedf-702f0dd9a419',61,'61d8d3b6b31f4b36b5749db9c550c696','volumes',-1,'2025-11-30 08:23:20',NULL),('2025-11-29 08:23:20','2025-11-29 08:23:20','2025-11-29 08:23:20',1,198,'2f4ecdc4-88e3-4e33-9610-62700e546ab2',62,'61d8d3b6b31f4b36b5749db9c550c696','gigabytes',-1,'2025-11-30 08:23:20',NULL),('2025-11-29 08:23:20','2025-11-29 08:23:20','2025-11-29 08:23:20',1,199,'6dbba4bf-6845-46fa-8152-dce8b70eca8c',63,'61d8d3b6b31f4b36b5749db9c550c696','volumes___DEFAULT__',-1,'2025-11-30 08:23:20',NULL),('2025-11-29 08:23:20','2025-11-29 08:23:20','2025-11-29 08:23:20',1,200,'1dd1b3a7-bc0c-4ee1-a838-dad445f57627',64,'61d8d3b6b31f4b36b5749db9c550c696','gigabytes___DEFAULT__',-1,'2025-11-30 08:23:20',NULL),('2025-11-29 08:23:25','2025-11-29 08:23:25','2025-11-29 08:23:25',1,201,'f64c074f-73fa-4e47-8fc2-0389e70b1a87',61,'61d8d3b6b31f4b36b5749db9c550c696','volumes',-1,'2025-11-30 08:23:24',NULL),('2025-11-29 08:23:25','2025-11-29 08:23:25','2025-11-29 08:23:25',1,202,'5c43511a-cb74-4a86-aa12-799d51d48b08',62,'61d8d3b6b31f4b36b5749db9c550c696','gigabytes',-1,'2025-11-30 08:23:24',NULL),('2025-11-29 08:23:25','2025-11-29 08:23:25','2025-11-29 08:23:25',1,203,'c8987e63-074b-4743-acc4-12ffb637936a',63,'61d8d3b6b31f4b36b5749db9c550c696','volumes___DEFAULT__',-1,'2025-11-30 08:23:24',NULL),('2025-11-29 08:23:25','2025-11-29 08:23:25','2025-11-29 08:23:25',1,204,'f4f8787b-ba1a-4244-9e38-676123a8f175',64,'61d8d3b6b31f4b36b5749db9c550c696','gigabytes___DEFAULT__',-1,'2025-11-30 08:23:24',NULL),('2025-11-29 08:23:28','2025-11-29 08:23:28','2025-11-29 08:23:28',1,205,'74249590-262c-4686-969c-6a2059886bc0',61,'61d8d3b6b31f4b36b5749db9c550c696','volumes',-1,'2025-11-30 08:23:28',NULL),('2025-11-29 08:23:28','2025-11-29 08:23:28','2025-11-29 08:23:28',1,206,'7d519cf1-0dbf-4c44-91bc-abdebb97e023',62,'61d8d3b6b31f4b36b5749db9c550c696','gigabytes',-1,'2025-11-30 08:23:28',NULL),('2025-11-29 08:23:28','2025-11-29 08:23:28','2025-11-29 08:23:28',1,207,'2011599f-2728-4fd2-adfa-7ecc724c3dae',63,'61d8d3b6b31f4b36b5749db9c550c696','volumes___DEFAULT__',-1,'2025-11-30 08:23:28',NULL),('2025-11-29 08:23:28','2025-11-29 08:23:28','2025-11-29 08:23:28',1,208,'561208bf-e9e0-40d3-9cae-d78e54721e4a',64,'61d8d3b6b31f4b36b5749db9c550c696','gigabytes___DEFAULT__',-1,'2025-11-30 08:23:28',NULL),('2025-11-29 08:23:53','2025-11-29 08:23:53','2025-11-29 08:23:53',1,209,'2287df8f-2aa4-4af0-8fdf-94425a42df79',69,'1e7450dd88894243affe67274f9cceb0','volumes',1,'2025-11-30 08:23:53',NULL),('2025-11-29 08:23:53','2025-11-29 08:23:53','2025-11-29 08:23:53',1,210,'c4eeb500-05ed-474d-b90b-5c29d23f328d',70,'1e7450dd88894243affe67274f9cceb0','gigabytes',1,'2025-11-30 08:23:53',NULL),('2025-11-29 08:23:53','2025-11-29 08:23:53','2025-11-29 08:23:53',1,211,'39f49bb9-5bad-4a19-a79f-b5ae7db3b775',71,'1e7450dd88894243affe67274f9cceb0','volumes___DEFAULT__',1,'2025-11-30 08:23:53',NULL),('2025-11-29 08:23:53','2025-11-29 08:23:53','2025-11-29 08:23:53',1,212,'ec986a8f-ab10-447e-a7cb-2b4b23bec3c6',72,'1e7450dd88894243affe67274f9cceb0','gigabytes___DEFAULT__',1,'2025-11-30 08:23:53',NULL),('2025-11-29 08:23:54','2025-11-29 08:23:54','2025-11-29 08:23:54',1,213,'b55fd8a7-3134-4c05-a811-26f7c71d3e2b',73,'23450c2eaf4442459dec94c6d29f0412','volumes',1,'2025-11-30 08:23:54',NULL),('2025-11-29 08:23:54','2025-11-29 08:23:54','2025-11-29 08:23:54',1,214,'5bbd2038-33d5-4ca3-b75c-67eae0ed0edb',74,'23450c2eaf4442459dec94c6d29f0412','gigabytes',1,'2025-11-30 08:23:54',NULL),('2025-11-29 08:23:54','2025-11-29 08:23:54','2025-11-29 08:23:54',1,215,'d61aecfc-c729-46d8-897c-7999129c8159',75,'23450c2eaf4442459dec94c6d29f0412','volumes_multiattach',1,'2025-11-30 08:23:54',NULL),('2025-11-29 08:23:54','2025-11-29 08:23:54','2025-11-29 08:23:54',1,216,'07e7afdd-28f0-4229-9639-c40d2d50da0d',76,'23450c2eaf4442459dec94c6d29f0412','gigabytes_multiattach',1,'2025-11-30 08:23:54',NULL),('2025-11-29 08:23:59','2025-11-29 08:23:59','2025-11-29 08:23:59',1,217,'f25223a9-8fd8-4ddb-add0-190913e56017',77,'1e7450dd88894243affe67274f9cceb0','snapshots',1,'2025-11-30 08:23:58',NULL),('2025-11-29 08:23:59','2025-11-29 08:23:59','2025-11-29 08:23:59',1,218,'26c629bb-90c5-4cdb-a1b3-f674df8c05b4',70,'1e7450dd88894243affe67274f9cceb0','gigabytes',1,'2025-11-30 08:23:58',NULL),('2025-11-29 08:23:59','2025-11-29 08:23:59','2025-11-29 08:23:59',1,219,'886e0e37-b346-4a52-baba-b8fe2a7ee7aa',72,'1e7450dd88894243affe67274f9cceb0','gigabytes___DEFAULT__',1,'2025-11-30 08:23:58',NULL),('2025-11-29 08:23:59','2025-11-29 08:23:59','2025-11-29 08:23:59',1,220,'c1cff28c-eac3-4efb-80d8-3e9f96844a42',78,'1e7450dd88894243affe67274f9cceb0','snapshots___DEFAULT__',1,'2025-11-30 08:23:58',NULL),('2025-11-29 08:24:06','2025-11-29 08:24:07','2025-11-29 08:24:07',1,221,'dd953def-29e1-47b7-8073-664395adc830',77,'1e7450dd88894243affe67274f9cceb0','snapshots',-1,'2025-11-30 08:24:06',NULL),('2025-11-29 08:24:06','2025-11-29 08:24:07','2025-11-29 08:24:07',1,222,'a0c42d8c-a81c-498c-9bc3-6f9e756b7bec',70,'1e7450dd88894243affe67274f9cceb0','gigabytes',-1,'2025-11-30 08:24:06',NULL),('2025-11-29 08:24:06','2025-11-29 08:24:07','2025-11-29 08:24:07',1,223,'c65fb715-b045-413e-ac29-a7c1a4ef28e0',72,'1e7450dd88894243affe67274f9cceb0','gigabytes___DEFAULT__',-1,'2025-11-30 08:24:06',NULL),('2025-11-29 08:24:06','2025-11-29 08:24:07','2025-11-29 08:24:07',1,224,'77ce5dff-bbdd-41ce-8790-8378e74ec804',78,'1e7450dd88894243affe67274f9cceb0','snapshots___DEFAULT__',-1,'2025-11-30 08:24:06',NULL),('2025-11-29 08:24:10','2025-11-29 08:24:10','2025-11-29 08:24:10',1,225,'1989e616-23b3-4824-bdc6-2d31349c141b',69,'1e7450dd88894243affe67274f9cceb0','volumes',-1,'2025-11-30 08:24:10',NULL),('2025-11-29 08:24:10','2025-11-29 08:24:10','2025-11-29 08:24:10',1,226,'e7c3625b-cc07-4a7d-9cb3-ad7461c2a012',70,'1e7450dd88894243affe67274f9cceb0','gigabytes',-1,'2025-11-30 08:24:10',NULL),('2025-11-29 08:24:10','2025-11-29 08:24:10','2025-11-29 08:24:10',1,227,'7a2c6dd6-a557-4589-bb1c-11e83bd7259d',71,'1e7450dd88894243affe67274f9cceb0','volumes___DEFAULT__',-1,'2025-11-30 08:24:10',NULL),('2025-11-29 08:24:10','2025-11-29 08:24:10','2025-11-29 08:24:10',1,228,'0dddb568-f95e-4353-9c66-e29caec802c0',72,'1e7450dd88894243affe67274f9cceb0','gigabytes___DEFAULT__',-1,'2025-11-30 08:24:10',NULL),('2025-11-29 08:24:17','2025-11-29 08:24:17','2025-11-29 08:24:17',1,229,'b24ef8ff-5abc-4430-9898-af3941e3299b',79,'d9406fbc6fef486fa5b0e79549e78d00','volumes',1,'2025-11-30 08:24:17',NULL),('2025-11-29 08:24:17','2025-11-29 08:24:17','2025-11-29 08:24:17',1,230,'9b5dac29-1ed0-4ba0-8552-3f8d92e0c602',80,'d9406fbc6fef486fa5b0e79549e78d00','gigabytes',1,'2025-11-30 08:24:17',NULL),('2025-11-29 08:24:17','2025-11-29 08:24:17','2025-11-29 08:24:17',1,231,'9d0bbc6e-c45f-4272-a3a5-05bf03755cc8',81,'d9406fbc6fef486fa5b0e79549e78d00','volumes___DEFAULT__',1,'2025-11-30 08:24:17',NULL),('2025-11-29 08:24:17','2025-11-29 08:24:17','2025-11-29 08:24:17',1,232,'f687bec8-aa5f-4bb2-8522-7c376e8cfccf',82,'d9406fbc6fef486fa5b0e79549e78d00','gigabytes___DEFAULT__',1,'2025-11-30 08:24:17',NULL),('2025-11-29 08:24:17','2025-11-29 08:24:18','2025-11-29 08:24:18',1,233,'83f47f2a-ea81-4e3d-bc0f-b77eaaae04d9',83,'c1fc65ff70ce460c924739eae21e2b49','volumes',1,'2025-11-30 08:24:17',NULL),('2025-11-29 08:24:17','2025-11-29 08:24:18','2025-11-29 08:24:18',1,234,'33ff32cf-600f-46a1-aaa4-553533dd3910',84,'c1fc65ff70ce460c924739eae21e2b49','gigabytes',1,'2025-11-30 08:24:17',NULL),('2025-11-29 08:24:17','2025-11-29 08:24:18','2025-11-29 08:24:18',1,235,'f2c47dd4-3952-401c-9c6b-9f54e7a3bee1',85,'c1fc65ff70ce460c924739eae21e2b49','volumes___DEFAULT__',1,'2025-11-30 08:24:17',NULL),('2025-11-29 08:24:17','2025-11-29 08:24:18','2025-11-29 08:24:18',1,236,'43fa6c84-d084-4638-a0ba-171fa3c96317',86,'c1fc65ff70ce460c924739eae21e2b49','gigabytes___DEFAULT__',1,'2025-11-30 08:24:17',NULL),('2025-11-29 08:24:22','2025-11-29 08:24:22','2025-11-29 08:24:22',1,237,'758249af-4085-4f65-828a-4b98f356f624',83,'c1fc65ff70ce460c924739eae21e2b49','volumes',1,'2025-11-30 08:24:22',NULL),('2025-11-29 08:24:22','2025-11-29 08:24:22','2025-11-29 08:24:22',1,238,'d6fa7734-0065-4d73-b86f-d65ed16d14ca',84,'c1fc65ff70ce460c924739eae21e2b49','gigabytes',1,'2025-11-30 08:24:22',NULL),('2025-11-29 08:24:22','2025-11-29 08:24:22','2025-11-29 08:24:22',1,239,'aef9dc6b-df88-47b7-8973-e51d3560fc93',85,'c1fc65ff70ce460c924739eae21e2b49','volumes___DEFAULT__',1,'2025-11-30 08:24:22',NULL),('2025-11-29 08:24:22','2025-11-29 08:24:22','2025-11-29 08:24:22',1,240,'db2552ea-fb45-472c-9415-1966dc98e3b1',86,'c1fc65ff70ce460c924739eae21e2b49','gigabytes___DEFAULT__',1,'2025-11-30 08:24:22',NULL),('2025-11-29 08:24:24','2025-11-29 08:24:24','2025-11-29 08:24:24',1,241,'fc38b228-ab73-49d0-a283-e8160e573611',83,'c1fc65ff70ce460c924739eae21e2b49','volumes',1,'2025-11-30 08:24:24',NULL),('2025-11-29 08:24:24','2025-11-29 08:24:24','2025-11-29 08:24:24',1,242,'e3282c33-1529-42ea-b446-5151d2b6e3bc',84,'c1fc65ff70ce460c924739eae21e2b49','gigabytes',1,'2025-11-30 08:24:24',NULL),('2025-11-29 08:24:24','2025-11-29 08:24:24','2025-11-29 08:24:24',1,243,'96a40c3b-f94c-4ba3-ac2d-50309d580476',85,'c1fc65ff70ce460c924739eae21e2b49','volumes___DEFAULT__',1,'2025-11-30 08:24:24',NULL),('2025-11-29 08:24:24','2025-11-29 08:24:24','2025-11-29 08:24:24',1,244,'124c57b0-e259-4021-98da-d2c3e81d09d3',86,'c1fc65ff70ce460c924739eae21e2b49','gigabytes___DEFAULT__',1,'2025-11-30 08:24:24',NULL),('2025-11-29 08:24:24','2025-11-29 08:24:24','2025-11-29 08:24:24',1,245,'32e09d2a-138b-41b9-bb86-9120a04fb549',79,'d9406fbc6fef486fa5b0e79549e78d00','volumes',1,'2025-11-30 08:24:24',NULL),('2025-11-29 08:24:24','2025-11-29 08:24:24','2025-11-29 08:24:24',1,246,'2f3d6e11-432b-4b3e-8f53-3bd393818b4f',80,'d9406fbc6fef486fa5b0e79549e78d00','gigabytes',1,'2025-11-30 08:24:24',NULL),('2025-11-29 08:24:24','2025-11-29 08:24:24','2025-11-29 08:24:24',1,247,'ff3ca1c0-b434-4fba-905b-302e07f36396',81,'d9406fbc6fef486fa5b0e79549e78d00','volumes___DEFAULT__',1,'2025-11-30 08:24:24',NULL),('2025-11-29 08:24:24','2025-11-29 08:24:24','2025-11-29 08:24:24',1,248,'f9fb4a42-e9c2-42b2-b6ff-76e7086d27d3',82,'d9406fbc6fef486fa5b0e79549e78d00','gigabytes___DEFAULT__',1,'2025-11-30 08:24:24',NULL),('2025-11-29 08:24:40','2025-11-29 08:24:40','2025-11-29 08:24:40',1,249,'33a1a6ea-6deb-497d-9576-4d08b5e5c40a',83,'c1fc65ff70ce460c924739eae21e2b49','volumes',-1,'2025-11-30 08:24:40',NULL),('2025-11-29 08:24:40','2025-11-29 08:24:40','2025-11-29 08:24:40',1,250,'be6bf546-45c8-47fd-bb69-b7275f042cd3',84,'c1fc65ff70ce460c924739eae21e2b49','gigabytes',-1,'2025-11-30 08:24:40',NULL),('2025-11-29 08:24:40','2025-11-29 08:24:40','2025-11-29 08:24:40',1,251,'bf037eb9-def7-469f-b59a-8eea4053aa36',85,'c1fc65ff70ce460c924739eae21e2b49','volumes___DEFAULT__',-1,'2025-11-30 08:24:40',NULL),('2025-11-29 08:24:40','2025-11-29 08:24:40','2025-11-29 08:24:40',1,252,'f3d2c1e9-5bc8-415f-9479-ffb3e799915d',86,'c1fc65ff70ce460c924739eae21e2b49','gigabytes___DEFAULT__',-1,'2025-11-30 08:24:40',NULL),('2025-11-29 08:24:43','2025-11-29 08:24:43','2025-11-29 08:24:43',1,253,'cc6bad58-a565-4df1-99c6-e1ea61c2cfac',83,'c1fc65ff70ce460c924739eae21e2b49','volumes',-1,'2025-11-30 08:24:42',NULL),('2025-11-29 08:24:43','2025-11-29 08:24:43','2025-11-29 08:24:43',1,254,'fa0976b8-e016-4b53-b727-509c060675b5',84,'c1fc65ff70ce460c924739eae21e2b49','gigabytes',-1,'2025-11-30 08:24:42',NULL),('2025-11-29 08:24:43','2025-11-29 08:24:43','2025-11-29 08:24:43',1,255,'f5212f69-2416-4a34-8557-45cd3a4e7533',85,'c1fc65ff70ce460c924739eae21e2b49','volumes___DEFAULT__',-1,'2025-11-30 08:24:42',NULL),('2025-11-29 08:24:43','2025-11-29 08:24:43','2025-11-29 08:24:43',1,256,'b8365cd6-71ae-470a-95e6-ef22068c0902',86,'c1fc65ff70ce460c924739eae21e2b49','gigabytes___DEFAULT__',-1,'2025-11-30 08:24:42',NULL),('2025-11-29 08:24:44','2025-11-29 08:24:44','2025-11-29 08:24:44',1,257,'e55a6104-1486-4c8e-9240-d384f11c527a',83,'c1fc65ff70ce460c924739eae21e2b49','volumes',-1,'2025-11-30 08:24:44',NULL),('2025-11-29 08:24:44','2025-11-29 08:24:44','2025-11-29 08:24:44',1,258,'caae44b5-9672-4384-85a6-5371c0b55098',84,'c1fc65ff70ce460c924739eae21e2b49','gigabytes',-1,'2025-11-30 08:24:44',NULL),('2025-11-29 08:24:44','2025-11-29 08:24:44','2025-11-29 08:24:44',1,259,'ed2cabcd-f11a-4145-98bf-d82b36e6a4af',85,'c1fc65ff70ce460c924739eae21e2b49','volumes___DEFAULT__',-1,'2025-11-30 08:24:44',NULL),('2025-11-29 08:24:44','2025-11-29 08:24:44','2025-11-29 08:24:44',1,260,'62a52231-a121-4f69-bafe-85f2351eb57b',86,'c1fc65ff70ce460c924739eae21e2b49','gigabytes___DEFAULT__',-1,'2025-11-30 08:24:44',NULL),('2025-11-29 08:25:13','2025-11-29 08:25:23','2025-11-29 08:25:23',1,261,'18b2474f-dbb7-4000-8784-e41645d8cd7a',87,'09cc8c3182d845f597dda064f9013941','volumes',1,'2025-11-30 08:25:13',NULL),('2025-11-29 08:25:14','2025-11-29 08:25:23','2025-11-29 08:25:23',1,262,'687a02c4-04f6-42e7-b335-da36dd6bb0a9',88,'09cc8c3182d845f597dda064f9013941','gigabytes',1,'2025-11-30 08:25:13',NULL),('2025-11-29 08:25:18','2025-11-29 08:25:23','2025-11-29 08:25:23',1,263,'490ebf30-f708-4da5-a92c-b71538ce27f4',89,'09cc8c3182d845f597dda064f9013941','volumes___DEFAULT__',1,'2025-11-30 08:25:13',NULL),('2025-11-29 08:25:21','2025-11-29 08:25:23','2025-11-29 08:25:23',1,264,'1f6fbab4-87e4-466c-96f5-96d447165b1c',90,'09cc8c3182d845f597dda064f9013941','gigabytes___DEFAULT__',1,'2025-11-30 08:25:13',NULL),('2025-11-29 08:25:43','2025-11-29 08:25:43','2025-11-29 08:25:43',1,265,'134ea305-ea4a-4bfe-88b5-c43bcb6d3723',73,'23450c2eaf4442459dec94c6d29f0412','volumes',1,'2025-11-30 08:25:43',NULL),('2025-11-29 08:25:43','2025-11-29 08:25:43','2025-11-29 08:25:43',1,266,'42b7c3da-6779-4b64-8068-b922a7531f0f',74,'23450c2eaf4442459dec94c6d29f0412','gigabytes',1,'2025-11-30 08:25:43',NULL),('2025-11-29 08:25:43','2025-11-29 08:25:43','2025-11-29 08:25:43',1,267,'770249fb-b1f5-4049-b872-e089a87458c9',75,'23450c2eaf4442459dec94c6d29f0412','volumes_multiattach',1,'2025-11-30 08:25:43',NULL),('2025-11-29 08:25:43','2025-11-29 08:25:43','2025-11-29 08:25:43',1,268,'002370f0-a2d9-4f21-bc37-a9ee01441d02',76,'23450c2eaf4442459dec94c6d29f0412','gigabytes_multiattach',1,'2025-11-30 08:25:43',NULL),('2025-11-29 08:25:48','2025-11-29 08:25:48','2025-11-29 08:25:48',1,269,'1eb67205-2a6e-4f1d-a1f6-cb75916b1919',87,'09cc8c3182d845f597dda064f9013941','volumes',1,'2025-11-30 08:25:48',NULL),('2025-11-29 08:25:48','2025-11-29 08:25:48','2025-11-29 08:25:48',1,270,'0926f725-9244-43d2-a2e7-f91e89de04e1',88,'09cc8c3182d845f597dda064f9013941','gigabytes',1,'2025-11-30 08:25:48',NULL),('2025-11-29 08:25:48','2025-11-29 08:25:48','2025-11-29 08:25:48',1,271,'6bb496b3-95c4-49c3-a331-f6405296463b',89,'09cc8c3182d845f597dda064f9013941','volumes___DEFAULT__',1,'2025-11-30 08:25:48',NULL),('2025-11-29 08:25:48','2025-11-29 08:25:48','2025-11-29 08:25:48',1,272,'b2a02dc8-1cb8-4bc9-b303-ab0d6d6f277a',90,'09cc8c3182d845f597dda064f9013941','gigabytes___DEFAULT__',1,'2025-11-30 08:25:48',NULL),('2025-11-29 08:25:57','2025-11-29 08:25:57','2025-11-29 08:25:57',1,273,'05b65d66-ffa9-4d3f-820b-c9a31d68421b',91,'f9a9decdabb1480da8f7d039e8b3d414','volumes',1,'2025-11-30 08:25:57',NULL),('2025-11-29 08:25:57','2025-11-29 08:25:57','2025-11-29 08:25:57',1,274,'035466b4-2021-438e-a7ad-0673bade6d3a',92,'f9a9decdabb1480da8f7d039e8b3d414','gigabytes',1,'2025-11-30 08:25:57',NULL),('2025-11-29 08:25:57','2025-11-29 08:25:57','2025-11-29 08:25:57',1,275,'6fe3e509-e222-411e-bb28-f882469ab2a2',93,'f9a9decdabb1480da8f7d039e8b3d414','volumes___DEFAULT__',1,'2025-11-30 08:25:57',NULL),('2025-11-29 08:25:57','2025-11-29 08:25:57','2025-11-29 08:25:57',1,276,'843948f2-5ca8-4ef2-bbb6-05c3d41dc934',94,'f9a9decdabb1480da8f7d039e8b3d414','gigabytes___DEFAULT__',1,'2025-11-30 08:25:57',NULL),('2025-11-29 08:26:02','2025-11-29 08:26:02','2025-11-29 08:26:02',1,277,'19ec9323-5c0b-4da9-b786-11cc5ee60bd8',95,'f9a9decdabb1480da8f7d039e8b3d414','snapshots',1,'2025-11-30 08:26:02',NULL),('2025-11-29 08:26:02','2025-11-29 08:26:02','2025-11-29 08:26:02',1,278,'0854580d-2901-4349-a7d5-49ab70345902',92,'f9a9decdabb1480da8f7d039e8b3d414','gigabytes',1,'2025-11-30 08:26:02',NULL),('2025-11-29 08:26:02','2025-11-29 08:26:02','2025-11-29 08:26:02',1,279,'0f7b9a0c-db2b-46c5-86f8-463d910f983e',94,'f9a9decdabb1480da8f7d039e8b3d414','gigabytes___DEFAULT__',1,'2025-11-30 08:26:02',NULL),('2025-11-29 08:26:02','2025-11-29 08:26:02','2025-11-29 08:26:02',1,280,'a65c87e3-0f2d-4a0e-b7db-4597a8776639',96,'f9a9decdabb1480da8f7d039e8b3d414','snapshots___DEFAULT__',1,'2025-11-30 08:26:02',NULL),('2025-11-29 08:26:30','2025-11-29 08:26:30','2025-11-29 08:26:30',1,281,'d795491e-822c-44b7-99cd-30ada2ae0358',95,'f9a9decdabb1480da8f7d039e8b3d414','snapshots',-1,'2025-11-30 08:26:30',NULL),('2025-11-29 08:26:30','2025-11-29 08:26:30','2025-11-29 08:26:30',1,282,'c7c6cbae-6770-46f6-b923-be2143ff56fb',92,'f9a9decdabb1480da8f7d039e8b3d414','gigabytes',-1,'2025-11-30 08:26:30',NULL),('2025-11-29 08:26:30','2025-11-29 08:26:30','2025-11-29 08:26:30',1,283,'f612637c-69f2-4045-8621-c4ec83d7c855',94,'f9a9decdabb1480da8f7d039e8b3d414','gigabytes___DEFAULT__',-1,'2025-11-30 08:26:30',NULL),('2025-11-29 08:26:30','2025-11-29 08:26:30','2025-11-29 08:26:30',1,284,'f6d12d07-d730-4353-98df-4b73d4344971',96,'f9a9decdabb1480da8f7d039e8b3d414','snapshots___DEFAULT__',-1,'2025-11-30 08:26:30',NULL),('2025-11-29 08:26:50','2025-11-29 08:26:51','2025-11-29 08:26:51',1,285,'6b9dd886-a5de-42b6-b731-22c2d68c169b',73,'23450c2eaf4442459dec94c6d29f0412','volumes',1,'2025-11-30 08:26:50',NULL),('2025-11-29 08:26:50','2025-11-29 08:26:51','2025-11-29 08:26:51',1,286,'eab3297d-fe0b-47bf-a07f-5036ef078f00',74,'23450c2eaf4442459dec94c6d29f0412','gigabytes',1,'2025-11-30 08:26:50',NULL),('2025-11-29 08:26:50','2025-11-29 08:26:51','2025-11-29 08:26:51',1,287,'c53e3ba9-85d2-4ebf-b611-48791dd7afdb',75,'23450c2eaf4442459dec94c6d29f0412','volumes_multiattach',1,'2025-11-30 08:26:50',NULL),('2025-11-29 08:26:50','2025-11-29 08:26:51','2025-11-29 08:26:51',1,288,'532fe384-26e2-4e68-ab03-3b70e66d356d',76,'23450c2eaf4442459dec94c6d29f0412','gigabytes_multiattach',1,'2025-11-30 08:26:50',NULL),('2025-11-29 08:27:27','2025-11-29 08:27:28','2025-11-29 08:27:28',1,289,'0b2da75c-7c2e-4e3e-8fc9-0f80ed715516',91,'f9a9decdabb1480da8f7d039e8b3d414','volumes',-1,'2025-11-30 08:27:27',NULL),('2025-11-29 08:27:27','2025-11-29 08:27:28','2025-11-29 08:27:28',1,290,'de96b538-2317-4e70-ba39-24063d96bfe3',92,'f9a9decdabb1480da8f7d039e8b3d414','gigabytes',-1,'2025-11-30 08:27:27',NULL),('2025-11-29 08:27:27','2025-11-29 08:27:28','2025-11-29 08:27:28',1,291,'1581328c-b67a-41cf-b44e-c3ad695961bc',93,'f9a9decdabb1480da8f7d039e8b3d414','volumes___DEFAULT__',-1,'2025-11-30 08:27:27',NULL),('2025-11-29 08:27:27','2025-11-29 08:27:28','2025-11-29 08:27:28',1,292,'091a9e0b-3895-49f8-9a2d-e60c13b50b20',94,'f9a9decdabb1480da8f7d039e8b3d414','gigabytes___DEFAULT__',-1,'2025-11-30 08:27:27',NULL),('2025-11-29 08:27:30','2025-11-29 08:27:30','2025-11-29 08:27:30',1,293,'2ee600d6-c861-4502-b875-01bc61082cd9',79,'d9406fbc6fef486fa5b0e79549e78d00','volumes',-1,'2025-11-30 08:27:30',NULL),('2025-11-29 08:27:30','2025-11-29 08:27:30','2025-11-29 08:27:30',1,294,'c218159b-8886-4574-a56d-6cdeddb4f400',80,'d9406fbc6fef486fa5b0e79549e78d00','gigabytes',-1,'2025-11-30 08:27:30',NULL),('2025-11-29 08:27:30','2025-11-29 08:27:30','2025-11-29 08:27:30',1,295,'a15f0e8f-7299-438f-9993-83542326dfdf',81,'d9406fbc6fef486fa5b0e79549e78d00','volumes___DEFAULT__',-1,'2025-11-30 08:27:30',NULL),('2025-11-29 08:27:30','2025-11-29 08:27:30','2025-11-29 08:27:30',1,296,'6daef70c-fcf5-4d05-8ce0-fa6d8bfffbe2',82,'d9406fbc6fef486fa5b0e79549e78d00','gigabytes___DEFAULT__',-1,'2025-11-30 08:27:30',NULL),('2025-11-29 08:27:31','2025-11-29 08:27:31','2025-11-29 08:27:31',1,297,'7cd3b524-8d1d-4a8f-ad96-12ca773a62c9',79,'d9406fbc6fef486fa5b0e79549e78d00','volumes',-1,'2025-11-30 08:27:31',NULL),('2025-11-29 08:27:31','2025-11-29 08:27:31','2025-11-29 08:27:31',1,298,'e08a0a3c-25d0-4895-823c-087cf3355f4e',80,'d9406fbc6fef486fa5b0e79549e78d00','gigabytes',-1,'2025-11-30 08:27:31',NULL),('2025-11-29 08:27:31','2025-11-29 08:27:31','2025-11-29 08:27:31',1,299,'396c2c13-3591-41e6-bd97-341dbb4d37b6',81,'d9406fbc6fef486fa5b0e79549e78d00','volumes___DEFAULT__',-1,'2025-11-30 08:27:31',NULL),('2025-11-29 08:27:31','2025-11-29 08:27:32','2025-11-29 08:27:31',1,300,'55c60e30-7a90-4f95-9e2a-c01beb5a63f6',82,'d9406fbc6fef486fa5b0e79549e78d00','gigabytes___DEFAULT__',-1,'2025-11-30 08:27:31',NULL),('2025-11-29 08:27:38','2025-11-29 08:27:38','2025-11-29 08:27:38',1,301,'8bd9741b-1cfb-4a23-98bc-a4ac1e3a39a7',87,'09cc8c3182d845f597dda064f9013941','volumes',-1,'2025-11-30 08:27:38',NULL),('2025-11-29 08:27:38','2025-11-29 08:27:38','2025-11-29 08:27:38',1,302,'598f32b3-9341-4848-b467-36a2e7918dba',88,'09cc8c3182d845f597dda064f9013941','gigabytes',-1,'2025-11-30 08:27:38',NULL),('2025-11-29 08:27:38','2025-11-29 08:27:38','2025-11-29 08:27:38',1,303,'32b99fec-747b-4b6d-ac0a-3f86a6c87d7b',89,'09cc8c3182d845f597dda064f9013941','volumes___DEFAULT__',-1,'2025-11-30 08:27:38',NULL),('2025-11-29 08:27:38','2025-11-29 08:27:38','2025-11-29 08:27:38',1,304,'ecb4d8e0-8012-4fe2-8d68-e67dfc59b8d7',90,'09cc8c3182d845f597dda064f9013941','gigabytes___DEFAULT__',-1,'2025-11-30 08:27:38',NULL),('2025-11-29 08:27:39','2025-11-29 08:27:39','2025-11-29 08:27:39',1,305,'47a13f9f-a280-481c-9056-81e5f39b3772',87,'09cc8c3182d845f597dda064f9013941','volumes',-1,'2025-11-30 08:27:39',NULL),('2025-11-29 08:27:39','2025-11-29 08:27:39','2025-11-29 08:27:39',1,306,'f13d0a35-927f-4ec4-9c08-685424bd50d1',88,'09cc8c3182d845f597dda064f9013941','gigabytes',-1,'2025-11-30 08:27:39',NULL),('2025-11-29 08:27:39','2025-11-29 08:27:39','2025-11-29 08:27:39',1,307,'0d67747a-e618-47fe-a309-57e159672458',89,'09cc8c3182d845f597dda064f9013941','volumes___DEFAULT__',-1,'2025-11-30 08:27:39',NULL),('2025-11-29 08:27:39','2025-11-29 08:27:39','2025-11-29 08:27:39',1,308,'839977a5-234f-4488-8289-3e7e97e82914',90,'09cc8c3182d845f597dda064f9013941','gigabytes___DEFAULT__',-1,'2025-11-30 08:27:39',NULL),('2025-11-29 08:28:02','2025-11-29 08:28:02','2025-11-29 08:28:02',1,309,'c3d0bbbe-7917-41a4-99af-7bd8d714d478',91,'f9a9decdabb1480da8f7d039e8b3d414','volumes',1,'2025-11-30 08:28:02',NULL),('2025-11-29 08:28:02','2025-11-29 08:28:02','2025-11-29 08:28:02',1,310,'884d3458-87f6-4a69-abe8-64eff66c1567',92,'f9a9decdabb1480da8f7d039e8b3d414','gigabytes',1,'2025-11-30 08:28:02',NULL),('2025-11-29 08:28:02','2025-11-29 08:28:02','2025-11-29 08:28:02',1,311,'490626a6-2bfc-4a44-a6bb-4298ff120912',93,'f9a9decdabb1480da8f7d039e8b3d414','volumes___DEFAULT__',1,'2025-11-30 08:28:02',NULL),('2025-11-29 08:28:02','2025-11-29 08:28:02','2025-11-29 08:28:02',1,312,'33bd5c3d-1b6a-417e-8aa6-ad7db352a9a6',94,'f9a9decdabb1480da8f7d039e8b3d414','gigabytes___DEFAULT__',1,'2025-11-30 08:28:02',NULL),('2025-11-29 08:28:23','2025-11-29 08:28:23','2025-11-29 08:28:23',1,313,'9c266464-3d25-4d8e-8b32-f89c39b0b9a4',97,'527c6a274d1e478eadfe67139e121185','volumes',1,'2025-11-30 08:28:23',NULL),('2025-11-29 08:28:23','2025-11-29 08:28:23','2025-11-29 08:28:23',1,314,'a056c0a5-92bd-442c-b8c2-202ed722ef05',98,'527c6a274d1e478eadfe67139e121185','gigabytes',1,'2025-11-30 08:28:23',NULL),('2025-11-29 08:28:23','2025-11-29 08:28:23','2025-11-29 08:28:23',1,315,'76346cef-7e87-4615-92fc-09075f272518',99,'527c6a274d1e478eadfe67139e121185','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1215813445-983297764',1,'2025-11-30 08:28:23',NULL),('2025-11-29 08:28:23','2025-11-29 08:28:23','2025-11-29 08:28:23',1,316,'d5033375-8b5e-458e-83e8-2fe7ed0e19b3',100,'527c6a274d1e478eadfe67139e121185','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1215813445-983297764',1,'2025-11-30 08:28:23',NULL),('2025-11-29 08:28:23','2025-11-29 08:28:23','2025-11-29 08:28:23',1,317,'7db2371b-1726-4f65-9e0b-c4896c1d0eb8',97,'527c6a274d1e478eadfe67139e121185','volumes',1,'2025-11-30 08:28:23',NULL),('2025-11-29 08:28:23','2025-11-29 08:28:23','2025-11-29 08:28:23',1,318,'a9bfa4a5-7814-4a6e-ba40-132b069e90c1',98,'527c6a274d1e478eadfe67139e121185','gigabytes',1,'2025-11-30 08:28:23',NULL),('2025-11-29 08:28:23','2025-11-29 08:28:23','2025-11-29 08:28:23',1,319,'5af142a8-3a29-425b-8578-0122d299486b',101,'527c6a274d1e478eadfe67139e121185','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-138997613-1010843264',1,'2025-11-30 08:28:23',NULL),('2025-11-29 08:28:23','2025-11-29 08:28:23','2025-11-29 08:28:23',1,320,'bbc2db3f-d96a-4091-918c-56f50a06bdf4',102,'527c6a274d1e478eadfe67139e121185','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-138997613-1010843264',1,'2025-11-30 08:28:23',NULL),('2025-11-29 08:28:23','2025-11-29 08:28:23','2025-11-29 08:28:23',1,321,'f13bb0b8-b664-485e-966c-feb07ef1b335',97,'527c6a274d1e478eadfe67139e121185','volumes',1,'2025-11-30 08:28:23',NULL),('2025-11-29 08:28:23','2025-11-29 08:28:23','2025-11-29 08:28:23',1,322,'88bdd0fe-aa82-4b17-8ba2-c87ea55a0ae3',98,'527c6a274d1e478eadfe67139e121185','gigabytes',1,'2025-11-30 08:28:23',NULL),('2025-11-29 08:28:23','2025-11-29 08:28:23','2025-11-29 08:28:23',1,323,'5193a279-32cb-4c93-aea4-f2fcac66fa3c',99,'527c6a274d1e478eadfe67139e121185','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1215813445-983297764',1,'2025-11-30 08:28:23',NULL),('2025-11-29 08:28:23','2025-11-29 08:28:23','2025-11-29 08:28:23',1,324,'e0de8c31-0dfa-4449-831a-c85882486405',100,'527c6a274d1e478eadfe67139e121185','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1215813445-983297764',1,'2025-11-30 08:28:23',NULL),('2025-11-29 08:28:24','2025-11-29 08:28:24','2025-11-29 08:28:24',1,325,'6b6bd973-cb48-411d-aec8-79efba90b9f5',97,'527c6a274d1e478eadfe67139e121185','volumes',1,'2025-11-30 08:28:24',NULL),('2025-11-29 08:28:24','2025-11-29 08:28:24','2025-11-29 08:28:24',1,326,'8c05a1dd-7793-4b2e-96a7-58ede48d26d9',98,'527c6a274d1e478eadfe67139e121185','gigabytes',1,'2025-11-30 08:28:24',NULL),('2025-11-29 08:28:24','2025-11-29 08:28:24','2025-11-29 08:28:24',1,327,'4f76479a-2929-4a81-9f9d-9a2579149165',101,'527c6a274d1e478eadfe67139e121185','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-138997613-1010843264',1,'2025-11-30 08:28:24',NULL),('2025-11-29 08:28:24','2025-11-29 08:28:24','2025-11-29 08:28:24',1,328,'69f2c7de-53cb-452d-a090-dbc8a6f247ab',102,'527c6a274d1e478eadfe67139e121185','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-138997613-1010843264',1,'2025-11-30 08:28:24',NULL),('2025-11-29 08:28:24','2025-11-29 08:28:24','2025-11-29 08:28:24',1,329,'411b50d9-582a-42c0-94d7-188940baded9',97,'527c6a274d1e478eadfe67139e121185','volumes',1,'2025-11-30 08:28:24',NULL),('2025-11-29 08:28:24','2025-11-29 08:28:24','2025-11-29 08:28:24',1,330,'aeca306a-42ac-450d-aacc-f84313a25978',98,'527c6a274d1e478eadfe67139e121185','gigabytes',1,'2025-11-30 08:28:24',NULL),('2025-11-29 08:28:24','2025-11-29 08:28:24','2025-11-29 08:28:24',1,331,'fbd97beb-4f19-4b1f-b576-8767736b8346',99,'527c6a274d1e478eadfe67139e121185','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1215813445-983297764',1,'2025-11-30 08:28:24',NULL),('2025-11-29 08:28:24','2025-11-29 08:28:24','2025-11-29 08:28:24',1,332,'f477dae7-5a79-4b22-ae79-77be7810e0da',100,'527c6a274d1e478eadfe67139e121185','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1215813445-983297764',1,'2025-11-30 08:28:24',NULL),('2025-11-29 08:28:25','2025-11-29 08:28:25','2025-11-29 08:28:25',1,333,'7ce1c988-a5e4-476d-9039-702b4d6bf5a8',97,'527c6a274d1e478eadfe67139e121185','volumes',1,'2025-11-30 08:28:25',NULL),('2025-11-29 08:28:25','2025-11-29 08:28:25','2025-11-29 08:28:25',1,334,'4b5ebd5e-44df-48d6-bc98-64653aa024b9',98,'527c6a274d1e478eadfe67139e121185','gigabytes',1,'2025-11-30 08:28:25',NULL),('2025-11-29 08:28:25','2025-11-29 08:28:25','2025-11-29 08:28:25',1,335,'a09f7de0-c64f-4fa8-998f-04a38a7aeab2',101,'527c6a274d1e478eadfe67139e121185','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-138997613-1010843264',1,'2025-11-30 08:28:25',NULL),('2025-11-29 08:28:25','2025-11-29 08:28:25','2025-11-29 08:28:25',1,336,'70cb5f93-7202-486d-bc85-46363554b202',102,'527c6a274d1e478eadfe67139e121185','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-138997613-1010843264',1,'2025-11-30 08:28:25',NULL),('2025-11-29 08:28:26','2025-11-29 08:28:26','2025-11-29 08:28:26',1,337,'90625506-7969-4ad3-983c-d43a25750391',97,'527c6a274d1e478eadfe67139e121185','volumes',1,'2025-11-30 08:28:26',NULL),('2025-11-29 08:28:26','2025-11-29 08:28:26','2025-11-29 08:28:26',1,338,'61b33324-adbc-4f9c-b435-b73dc21be14a',98,'527c6a274d1e478eadfe67139e121185','gigabytes',1,'2025-11-30 08:28:26',NULL),('2025-11-29 08:28:26','2025-11-29 08:28:26','2025-11-29 08:28:26',1,339,'33c70e66-190f-41b1-a1fc-400f12b02760',103,'527c6a274d1e478eadfe67139e121185','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1807121858-762180852',1,'2025-11-30 08:28:26',NULL),('2025-11-29 08:28:26','2025-11-29 08:28:26','2025-11-29 08:28:26',1,340,'03662a19-90e3-4389-ba64-edf5249d32c8',104,'527c6a274d1e478eadfe67139e121185','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1807121858-762180852',1,'2025-11-30 08:28:26',NULL),('2025-11-29 08:28:27','2025-11-29 08:28:27','2025-11-29 08:28:27',1,341,'b72b1512-6b7b-4d75-ab51-312f3b74ec49',97,'527c6a274d1e478eadfe67139e121185','volumes',1,'2025-11-30 08:28:27',NULL),('2025-11-29 08:28:27','2025-11-29 08:28:27','2025-11-29 08:28:27',1,342,'4a88a431-926d-49c6-9846-8b4ea9c891bc',98,'527c6a274d1e478eadfe67139e121185','gigabytes',1,'2025-11-30 08:28:27',NULL),('2025-11-29 08:28:27','2025-11-29 08:28:27','2025-11-29 08:28:27',1,343,'1d407c09-23eb-48bb-90b9-3df7ca226800',103,'527c6a274d1e478eadfe67139e121185','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1807121858-762180852',1,'2025-11-30 08:28:27',NULL),('2025-11-29 08:28:27','2025-11-29 08:28:27','2025-11-29 08:28:27',1,344,'440e42ea-df4d-444d-8530-20e520db6d85',104,'527c6a274d1e478eadfe67139e121185','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1807121858-762180852',1,'2025-11-30 08:28:27',NULL),('2025-11-29 08:28:29','2025-11-29 08:28:29','2025-11-29 08:28:29',1,345,'09fea317-2682-4b47-8f46-903f15bac494',97,'527c6a274d1e478eadfe67139e121185','volumes',1,'2025-11-30 08:28:29',NULL),('2025-11-29 08:28:29','2025-11-29 08:28:29','2025-11-29 08:28:29',1,346,'605de8e6-ec2b-4ea0-81d5-99d721e21862',98,'527c6a274d1e478eadfe67139e121185','gigabytes',1,'2025-11-30 08:28:29',NULL),('2025-11-29 08:28:29','2025-11-29 08:28:29','2025-11-29 08:28:29',1,347,'97fb2f31-9386-4ceb-a6f5-3a989fe1ec5b',103,'527c6a274d1e478eadfe67139e121185','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1807121858-762180852',1,'2025-11-30 08:28:29',NULL),('2025-11-29 08:28:29','2025-11-29 08:28:29','2025-11-29 08:28:29',1,348,'146223cb-a958-4993-be8c-323f4fc7690f',104,'527c6a274d1e478eadfe67139e121185','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1807121858-762180852',1,'2025-11-30 08:28:29',NULL),('2025-11-29 08:28:45','2025-11-29 08:28:45','2025-11-29 08:28:45',1,349,'ad154b9e-3c76-46d4-bdda-b53d5e5fc1a4',73,'23450c2eaf4442459dec94c6d29f0412','volumes',1,'2025-11-30 08:28:45',NULL),('2025-11-29 08:28:45','2025-11-29 08:28:45','2025-11-29 08:28:45',1,350,'e0570832-1fd0-45c1-9071-47a429481a9f',74,'23450c2eaf4442459dec94c6d29f0412','gigabytes',1,'2025-11-30 08:28:45',NULL),('2025-11-29 08:28:45','2025-11-29 08:28:45','2025-11-29 08:28:45',1,351,'76eb23ef-a2b2-4582-b882-baebc3a704ff',75,'23450c2eaf4442459dec94c6d29f0412','volumes_multiattach',1,'2025-11-30 08:28:45',NULL),('2025-11-29 08:28:45','2025-11-29 08:28:45','2025-11-29 08:28:45',1,352,'c828ba65-b260-44a5-9c2b-9bdde198bbc2',76,'23450c2eaf4442459dec94c6d29f0412','gigabytes_multiattach',1,'2025-11-30 08:28:45',NULL),('2025-11-29 08:29:03','2025-11-29 08:29:04','2025-11-29 08:29:04',1,353,'9a0e5337-a504-4754-aab6-ad27b65ae4ea',105,'eb0810bf6f5b4eb59638b7a2cf59ed5b','volumes',1,'2025-11-30 08:29:02',NULL),('2025-11-29 08:29:03','2025-11-29 08:29:04','2025-11-29 08:29:04',1,354,'fd453a74-c48a-445a-9a0a-9024b6cb06b8',106,'eb0810bf6f5b4eb59638b7a2cf59ed5b','gigabytes',1,'2025-11-30 08:29:02',NULL),('2025-11-29 08:29:03','2025-11-29 08:29:04','2025-11-29 08:29:04',1,355,'a588ec2a-9030-4faa-82ed-2beb7dcd3606',107,'eb0810bf6f5b4eb59638b7a2cf59ed5b','volumes___DEFAULT__',1,'2025-11-30 08:29:02',NULL),('2025-11-29 08:29:03','2025-11-29 08:29:04','2025-11-29 08:29:04',1,356,'ef695c96-389c-440c-b198-ec9dee09e1b4',108,'eb0810bf6f5b4eb59638b7a2cf59ed5b','gigabytes___DEFAULT__',1,'2025-11-30 08:29:02',NULL),('2025-11-29 08:29:27','2025-11-29 08:29:27','2025-11-29 08:29:27',1,357,'557e8477-2758-4061-8eae-adb3e54c20b7',91,'f9a9decdabb1480da8f7d039e8b3d414','volumes',-1,'2025-11-30 08:29:26',NULL),('2025-11-29 08:29:27','2025-11-29 08:29:27','2025-11-29 08:29:27',1,358,'f5ffdd75-1b7c-4421-b797-1a10e5e4221b',92,'f9a9decdabb1480da8f7d039e8b3d414','gigabytes',-1,'2025-11-30 08:29:26',NULL),('2025-11-29 08:29:27','2025-11-29 08:29:27','2025-11-29 08:29:27',1,359,'eb2c80b7-b29e-4742-bb3f-3424fcb25b8b',93,'f9a9decdabb1480da8f7d039e8b3d414','volumes___DEFAULT__',-1,'2025-11-30 08:29:26',NULL),('2025-11-29 08:29:27','2025-11-29 08:29:27','2025-11-29 08:29:27',1,360,'f10a44ae-0974-4aae-b3e0-5a11434b9508',94,'f9a9decdabb1480da8f7d039e8b3d414','gigabytes___DEFAULT__',-1,'2025-11-30 08:29:26',NULL),('2025-11-29 08:29:40','2025-11-29 08:29:40','2025-11-29 08:29:40',1,361,'349e9873-b88c-4567-88a6-16349ee57e94',109,'23450c2eaf4442459dec94c6d29f0412','snapshots',1,'2025-11-30 08:29:40',NULL),('2025-11-29 08:29:40','2025-11-29 08:29:40','2025-11-29 08:29:40',1,362,'0aa3c9a9-8049-4aec-91b1-71b0c3c64a7d',74,'23450c2eaf4442459dec94c6d29f0412','gigabytes',1,'2025-11-30 08:29:40',NULL),('2025-11-29 08:29:40','2025-11-29 08:29:40','2025-11-29 08:29:40',1,363,'8f17a701-8e46-4b51-ade4-8f4fdeb2e85d',76,'23450c2eaf4442459dec94c6d29f0412','gigabytes_multiattach',1,'2025-11-30 08:29:40',NULL),('2025-11-29 08:29:40','2025-11-29 08:29:40','2025-11-29 08:29:40',1,364,'3b027b7c-949c-4707-be15-c7bfb14f5910',110,'23450c2eaf4442459dec94c6d29f0412','snapshots_multiattach',1,'2025-11-30 08:29:40',NULL),('2025-11-29 08:29:49','2025-11-29 08:29:49','2025-11-29 08:29:49',1,365,'a751ad2e-d368-4f05-83ec-8a923bd1a9ad',97,'527c6a274d1e478eadfe67139e121185','volumes',-1,'2025-11-30 08:29:49',NULL),('2025-11-29 08:29:49','2025-11-29 08:29:49','2025-11-29 08:29:49',1,366,'271f373a-3228-4113-b2dc-5bb3656651d6',98,'527c6a274d1e478eadfe67139e121185','gigabytes',-1,'2025-11-30 08:29:49',NULL),('2025-11-29 08:29:49','2025-11-29 08:29:50','2025-11-29 08:29:49',1,367,'beed5410-05a5-481a-af53-bc531f38374c',99,'527c6a274d1e478eadfe67139e121185','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1215813445-983297764',-1,'2025-11-30 08:29:49',NULL),('2025-11-29 08:29:49','2025-11-29 08:29:50','2025-11-29 08:29:50',1,368,'51fe0e01-2d64-45ac-a449-520618876c3b',100,'527c6a274d1e478eadfe67139e121185','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1215813445-983297764',-1,'2025-11-30 08:29:49',NULL),('2025-11-29 08:29:52','2025-11-29 08:29:52','2025-11-29 08:29:52',1,369,'59029982-1d4b-4432-a4b1-bd06d42bb9b9',109,'23450c2eaf4442459dec94c6d29f0412','snapshots',-1,'2025-11-30 08:29:52',NULL),('2025-11-29 08:29:52','2025-11-29 08:29:52','2025-11-29 08:29:52',1,370,'74d1ec4a-350c-4d27-aec9-e01315c1a81f',74,'23450c2eaf4442459dec94c6d29f0412','gigabytes',-1,'2025-11-30 08:29:52',NULL),('2025-11-29 08:29:52','2025-11-29 08:29:52','2025-11-29 08:29:52',1,371,'0dc9a8bf-9f00-4412-9a70-a180391b5b53',76,'23450c2eaf4442459dec94c6d29f0412','gigabytes_multiattach',-1,'2025-11-30 08:29:52',NULL),('2025-11-29 08:29:52','2025-11-29 08:29:52','2025-11-29 08:29:52',1,372,'55ffbf17-23fd-46e8-b79e-e61cad29cf18',110,'23450c2eaf4442459dec94c6d29f0412','snapshots_multiattach',-1,'2025-11-30 08:29:52',NULL),('2025-11-29 08:29:53','2025-11-29 08:29:53','2025-11-29 08:29:53',1,373,'4f9b288d-befc-4e47-b6e9-058f59fe3efb',73,'23450c2eaf4442459dec94c6d29f0412','volumes',-1,'2025-11-30 08:29:53',NULL),('2025-11-29 08:29:53','2025-11-29 08:29:53','2025-11-29 08:29:53',1,374,'8b1583d8-a879-476b-b445-93650040f203',74,'23450c2eaf4442459dec94c6d29f0412','gigabytes',-1,'2025-11-30 08:29:53',NULL),('2025-11-29 08:29:53','2025-11-29 08:29:53','2025-11-29 08:29:53',1,375,'9f5ef6df-27ff-47a7-84e0-78b3d6183755',75,'23450c2eaf4442459dec94c6d29f0412','volumes_multiattach',-1,'2025-11-30 08:29:53',NULL),('2025-11-29 08:29:53','2025-11-29 08:29:53','2025-11-29 08:29:53',1,376,'5f9a41b2-15a1-449b-af90-db05a2a94cd4',76,'23450c2eaf4442459dec94c6d29f0412','gigabytes_multiattach',-1,'2025-11-30 08:29:53',NULL),('2025-11-29 08:29:53','2025-11-29 08:29:54','2025-11-29 08:29:54',1,377,'addf4b95-8e96-440c-9bfa-22e7860018a6',97,'527c6a274d1e478eadfe67139e121185','volumes',-1,'2025-11-30 08:29:53',NULL),('2025-11-29 08:29:53','2025-11-29 08:29:54','2025-11-29 08:29:54',1,378,'95a4b963-6949-4122-a4da-065e859c88ef',98,'527c6a274d1e478eadfe67139e121185','gigabytes',-1,'2025-11-30 08:29:53',NULL),('2025-11-29 08:29:54','2025-11-29 08:29:54','2025-11-29 08:29:54',1,379,'a2e48682-3959-407c-9d4f-a9ac7e0b6d20',101,'527c6a274d1e478eadfe67139e121185','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-138997613-1010843264',-1,'2025-11-30 08:29:53',NULL),('2025-11-29 08:29:54','2025-11-29 08:29:54','2025-11-29 08:29:54',1,380,'8e82a7e8-782b-40c9-850a-0ccbd0e039c9',102,'527c6a274d1e478eadfe67139e121185','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-138997613-1010843264',-1,'2025-11-30 08:29:53',NULL),('2025-11-29 08:29:56','2025-11-29 08:29:56','2025-11-29 08:29:56',1,381,'bc6e2b05-6522-4a3f-b88c-03bef31ff218',73,'23450c2eaf4442459dec94c6d29f0412','volumes',-1,'2025-11-30 08:29:56',NULL),('2025-11-29 08:29:56','2025-11-29 08:29:56','2025-11-29 08:29:56',1,382,'93e7fb74-2587-4b55-bf53-a850d435d53d',74,'23450c2eaf4442459dec94c6d29f0412','gigabytes',-1,'2025-11-30 08:29:56',NULL),('2025-11-29 08:29:56','2025-11-29 08:29:56','2025-11-29 08:29:56',1,383,'a67652e3-63f9-4c0a-9abe-004a3c71dba1',75,'23450c2eaf4442459dec94c6d29f0412','volumes_multiattach',-1,'2025-11-30 08:29:56',NULL),('2025-11-29 08:29:56','2025-11-29 08:29:56','2025-11-29 08:29:56',1,384,'aaaf25a1-3366-42cc-91bb-aae1d9870fb3',76,'23450c2eaf4442459dec94c6d29f0412','gigabytes_multiattach',-1,'2025-11-30 08:29:56',NULL),('2025-11-29 08:30:03','2025-11-29 08:30:03','2025-11-29 08:30:03',1,385,'4e685d7d-cac7-4363-8b20-1f77a2d7c14d',73,'23450c2eaf4442459dec94c6d29f0412','volumes',-1,'2025-11-30 08:30:03',NULL),('2025-11-29 08:30:03','2025-11-29 08:30:03','2025-11-29 08:30:03',1,386,'c8cd8790-6edd-42b6-a8f5-4d8ae9d2069e',74,'23450c2eaf4442459dec94c6d29f0412','gigabytes',-1,'2025-11-30 08:30:03',NULL),('2025-11-29 08:30:03','2025-11-29 08:30:03','2025-11-29 08:30:03',1,387,'33970942-66e0-412b-a18d-88ea7317bb53',75,'23450c2eaf4442459dec94c6d29f0412','volumes_multiattach',-1,'2025-11-30 08:30:03',NULL),('2025-11-29 08:30:03','2025-11-29 08:30:03','2025-11-29 08:30:03',1,388,'875d6235-616a-41eb-b190-2bdc240404cf',76,'23450c2eaf4442459dec94c6d29f0412','gigabytes_multiattach',-1,'2025-11-30 08:30:03',NULL),('2025-11-29 08:30:15','2025-11-29 08:30:15','2025-11-29 08:30:15',1,389,'a27e975f-2f99-48f6-8a6e-4037383497f4',111,'7e8e7407a7c44208a503e8225c1cf518','volumes',1,'2025-11-30 08:30:15',NULL),('2025-11-29 08:30:15','2025-11-29 08:30:15','2025-11-29 08:30:15',1,390,'54af5662-9049-4337-a3b4-2ed8735c79e4',112,'7e8e7407a7c44208a503e8225c1cf518','gigabytes',1,'2025-11-30 08:30:15',NULL),('2025-11-29 08:30:15','2025-11-29 08:30:15','2025-11-29 08:30:15',1,391,'465bc3aa-aaeb-460e-a53a-5b0353ad59fa',113,'7e8e7407a7c44208a503e8225c1cf518','volumes___DEFAULT__',1,'2025-11-30 08:30:15',NULL),('2025-11-29 08:30:15','2025-11-29 08:30:15','2025-11-29 08:30:15',1,392,'9a90d8ac-b441-4282-a77a-257158426dc5',114,'7e8e7407a7c44208a503e8225c1cf518','gigabytes___DEFAULT__',1,'2025-11-30 08:30:15',NULL),('2025-11-29 08:30:16','2025-11-29 08:30:16','2025-11-29 08:30:16',1,393,'713a9f6a-5d91-473f-958c-4765adfc6e10',97,'527c6a274d1e478eadfe67139e121185','volumes',-1,'2025-11-30 08:30:16',NULL),('2025-11-29 08:30:16','2025-11-29 08:30:16','2025-11-29 08:30:16',1,394,'9e944a7f-9466-4e9d-b025-0908be8d027a',98,'527c6a274d1e478eadfe67139e121185','gigabytes',-1,'2025-11-30 08:30:16',NULL),('2025-11-29 08:30:16','2025-11-29 08:30:16','2025-11-29 08:30:16',1,395,'94627716-f575-40a6-bfb1-a09c8dc21aec',99,'527c6a274d1e478eadfe67139e121185','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1215813445-983297764',-1,'2025-11-30 08:30:16',NULL),('2025-11-29 08:30:16','2025-11-29 08:30:16','2025-11-29 08:30:16',1,396,'88fd671d-1d29-40e1-ab3a-51116433d2f4',100,'527c6a274d1e478eadfe67139e121185','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1215813445-983297764',-1,'2025-11-30 08:30:16',NULL),('2025-11-29 08:30:17','2025-11-29 08:30:17','2025-11-29 08:30:17',1,397,'e6cf3c29-bcd6-40e2-8c69-caa81ca85c10',73,'23450c2eaf4442459dec94c6d29f0412','volumes',-1,'2025-11-30 08:30:17',NULL),('2025-11-29 08:30:17','2025-11-29 08:30:17','2025-11-29 08:30:17',1,398,'5ca7f50f-cd3b-40b0-98c8-7e1b35a6c6b7',74,'23450c2eaf4442459dec94c6d29f0412','gigabytes',-1,'2025-11-30 08:30:17',NULL),('2025-11-29 08:30:17','2025-11-29 08:30:17','2025-11-29 08:30:17',1,399,'28919223-6f06-4279-ad69-232104cd13d6',75,'23450c2eaf4442459dec94c6d29f0412','volumes_multiattach',-1,'2025-11-30 08:30:17',NULL),('2025-11-29 08:30:17','2025-11-29 08:30:17','2025-11-29 08:30:17',1,400,'91c8ed98-9a0f-4cfc-9f6a-b51c9f14fd2b',76,'23450c2eaf4442459dec94c6d29f0412','gigabytes_multiattach',-1,'2025-11-30 08:30:17',NULL),('2025-11-29 08:30:20','2025-11-29 08:30:20','2025-11-29 08:30:20',1,401,'125a91de-49ed-41ae-af82-55e3921adb53',97,'527c6a274d1e478eadfe67139e121185','volumes',-1,'2025-11-30 08:30:20',NULL),('2025-11-29 08:30:20','2025-11-29 08:30:20','2025-11-29 08:30:20',1,402,'28b18c5a-99e7-44b3-9788-d9c38c958ffc',98,'527c6a274d1e478eadfe67139e121185','gigabytes',-1,'2025-11-30 08:30:20',NULL),('2025-11-29 08:30:20','2025-11-29 08:30:20','2025-11-29 08:30:20',1,403,'e8145daf-d10a-4003-88ef-964328f7af85',101,'527c6a274d1e478eadfe67139e121185','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-138997613-1010843264',-1,'2025-11-30 08:30:20',NULL),('2025-11-29 08:30:20','2025-11-29 08:30:20','2025-11-29 08:30:20',1,404,'a190f8f7-9b58-4c33-a597-40fce6a87f4d',102,'527c6a274d1e478eadfe67139e121185','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-138997613-1010843264',-1,'2025-11-30 08:30:20',NULL),('2025-11-29 08:30:52','2025-11-29 08:30:52','2025-11-29 08:30:52',1,405,'266fc6e2-fa72-4e3a-aa8b-24c1984a52ff',97,'527c6a274d1e478eadfe67139e121185','volumes',-1,'2025-11-30 08:30:52',NULL),('2025-11-29 08:30:52','2025-11-29 08:30:52','2025-11-29 08:30:52',1,406,'568a3115-a588-406e-9b50-ec1dd75ab6b9',98,'527c6a274d1e478eadfe67139e121185','gigabytes',-1,'2025-11-30 08:30:52',NULL),('2025-11-29 08:30:52','2025-11-29 08:30:52','2025-11-29 08:30:52',1,407,'43f6c86a-790f-46ac-9e32-822e9348bdec',99,'527c6a274d1e478eadfe67139e121185','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1215813445-983297764',-1,'2025-11-30 08:30:52',NULL),('2025-11-29 08:30:52','2025-11-29 08:30:52','2025-11-29 08:30:52',1,408,'56d6241d-5b0e-43b4-b15e-b4a53f5631f2',100,'527c6a274d1e478eadfe67139e121185','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1215813445-983297764',-1,'2025-11-30 08:30:52',NULL),('2025-11-29 08:30:59','2025-11-29 08:30:59','2025-11-29 08:30:59',1,409,'feff532f-e816-40a3-b3ec-16a54a124017',97,'527c6a274d1e478eadfe67139e121185','volumes',-1,'2025-11-30 08:30:59',NULL),('2025-11-29 08:30:59','2025-11-29 08:30:59','2025-11-29 08:30:59',1,410,'7572e304-bcb0-4f1e-aa07-b18bc53dc8a4',98,'527c6a274d1e478eadfe67139e121185','gigabytes',-1,'2025-11-30 08:30:59',NULL),('2025-11-29 08:30:59','2025-11-29 08:30:59','2025-11-29 08:30:59',1,411,'fba2ad95-a1b5-47c4-9a1f-c30dfedde248',101,'527c6a274d1e478eadfe67139e121185','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-138997613-1010843264',-1,'2025-11-30 08:30:59',NULL),('2025-11-29 08:30:59','2025-11-29 08:30:59','2025-11-29 08:30:59',1,412,'c2e88754-aaca-475f-a953-a5fd8b2aabaf',102,'527c6a274d1e478eadfe67139e121185','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-138997613-1010843264',-1,'2025-11-30 08:30:59',NULL),('2025-11-29 08:31:00','2025-11-29 08:31:00','2025-11-29 08:31:00',1,413,'6ffea093-869d-4d0b-8910-c070d93a9138',115,'7e8e7407a7c44208a503e8225c1cf518','snapshots',1,'2025-11-30 08:31:00',NULL),('2025-11-29 08:31:00','2025-11-29 08:31:00','2025-11-29 08:31:00',1,414,'6781654a-c087-4ffb-a90a-d139b4581b79',112,'7e8e7407a7c44208a503e8225c1cf518','gigabytes',1,'2025-11-30 08:31:00',NULL),('2025-11-29 08:31:00','2025-11-29 08:31:00','2025-11-29 08:31:00',1,415,'0e479bf1-25b5-477a-9272-f0a775da9452',114,'7e8e7407a7c44208a503e8225c1cf518','gigabytes___DEFAULT__',1,'2025-11-30 08:31:00',NULL),('2025-11-29 08:31:00','2025-11-29 08:31:00','2025-11-29 08:31:00',1,416,'ec07fcfb-b131-42ce-b509-ee034ea2ff3f',116,'7e8e7407a7c44208a503e8225c1cf518','snapshots___DEFAULT__',1,'2025-11-30 08:31:00',NULL),('2025-11-29 08:31:11','2025-11-29 08:31:11','2025-11-29 08:31:11',1,417,'43c06257-d478-4fc4-a45d-56fa4b9a3f03',111,'7e8e7407a7c44208a503e8225c1cf518','volumes',1,'2025-11-30 08:31:11',NULL),('2025-11-29 08:31:11','2025-11-29 08:31:11','2025-11-29 08:31:11',1,418,'9b5225f1-bf9f-455e-8687-b7e6efb54ee7',112,'7e8e7407a7c44208a503e8225c1cf518','gigabytes',1,'2025-11-30 08:31:11',NULL),('2025-11-29 08:31:11','2025-11-29 08:31:11','2025-11-29 08:31:11',1,419,'f547b7b7-7bd2-4587-89dc-f412da592f6c',113,'7e8e7407a7c44208a503e8225c1cf518','volumes___DEFAULT__',1,'2025-11-30 08:31:11',NULL),('2025-11-29 08:31:11','2025-11-29 08:31:11','2025-11-29 08:31:11',1,420,'38eb330f-c3b1-46f4-b0c9-75cb79d62fe5',114,'7e8e7407a7c44208a503e8225c1cf518','gigabytes___DEFAULT__',1,'2025-11-30 08:31:11',NULL),('2025-11-29 08:31:13','2025-11-29 08:31:14','2025-11-29 08:31:14',1,421,'488ad07c-05d9-415e-be04-a7dad7cd4056',117,'37972b49ddde4c519c6523d2ea1569b5','volumes',1,'2025-11-30 08:31:13',NULL),('2025-11-29 08:31:13','2025-11-29 08:31:14','2025-11-29 08:31:14',1,422,'e5f4da3f-ae2a-4afc-a5d5-550ba0d4005b',118,'37972b49ddde4c519c6523d2ea1569b5','gigabytes',1,'2025-11-30 08:31:13',NULL),('2025-11-29 08:31:13','2025-11-29 08:31:14','2025-11-29 08:31:14',1,423,'6b827151-1df5-4db1-852c-a841bfc06422',119,'37972b49ddde4c519c6523d2ea1569b5','volumes___DEFAULT__',1,'2025-11-30 08:31:13',NULL),('2025-11-29 08:31:14','2025-11-29 08:31:14','2025-11-29 08:31:14',1,424,'f97a8ec0-499c-4d7d-9d95-70292e0b7717',120,'37972b49ddde4c519c6523d2ea1569b5','gigabytes___DEFAULT__',1,'2025-11-30 08:31:13',NULL),('2025-11-29 08:31:39','2025-11-29 08:31:39','2025-11-29 08:31:39',1,425,'dc69b6a7-3c1a-4204-b939-ce7b86e32d0a',97,'527c6a274d1e478eadfe67139e121185','volumes',-1,'2025-11-30 08:31:39',NULL),('2025-11-29 08:31:39','2025-11-29 08:31:39','2025-11-29 08:31:39',1,426,'0c51fdf6-2bce-4fac-a70b-096eec578f8f',98,'527c6a274d1e478eadfe67139e121185','gigabytes',-1,'2025-11-30 08:31:39',NULL),('2025-11-29 08:31:39','2025-11-29 08:31:39','2025-11-29 08:31:39',1,427,'0f2eac50-5d65-4791-bdc2-7f44733184ea',103,'527c6a274d1e478eadfe67139e121185','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1807121858-762180852',-1,'2025-11-30 08:31:39',NULL),('2025-11-29 08:31:39','2025-11-29 08:31:39','2025-11-29 08:31:39',1,428,'d0d03515-5ae1-4732-863e-b4d8bcd3a6e2',104,'527c6a274d1e478eadfe67139e121185','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1807121858-762180852',-1,'2025-11-30 08:31:39',NULL),('2025-11-29 08:31:41','2025-11-29 08:31:41','2025-11-29 08:31:41',1,429,'683dc1fe-186c-4f7f-a787-1c3ae1e68eaa',97,'527c6a274d1e478eadfe67139e121185','volumes',-1,'2025-11-30 08:31:41',NULL),('2025-11-29 08:31:41','2025-11-29 08:31:41','2025-11-29 08:31:41',1,430,'62e0c095-d149-49be-8e36-5aa68628ce33',98,'527c6a274d1e478eadfe67139e121185','gigabytes',-1,'2025-11-30 08:31:41',NULL),('2025-11-29 08:31:41','2025-11-29 08:31:41','2025-11-29 08:31:41',1,431,'9f9cc56a-d963-46b4-b530-a333e03c1bb0',103,'527c6a274d1e478eadfe67139e121185','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1807121858-762180852',-1,'2025-11-30 08:31:41',NULL),('2025-11-29 08:31:41','2025-11-29 08:31:41','2025-11-29 08:31:41',1,432,'4d88347a-b72c-403f-9e0b-f2c7512c6629',104,'527c6a274d1e478eadfe67139e121185','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1807121858-762180852',-1,'2025-11-30 08:31:41',NULL),('2025-11-29 08:31:42','2025-11-29 08:31:42','2025-11-29 08:31:42',1,433,'da653c47-47a2-4121-9207-2fc1fbd0c823',97,'527c6a274d1e478eadfe67139e121185','volumes',-1,'2025-11-30 08:31:42',NULL),('2025-11-29 08:31:42','2025-11-29 08:31:42','2025-11-29 08:31:42',1,434,'dd29a59d-d828-496a-aabd-c0c4d93ba34d',98,'527c6a274d1e478eadfe67139e121185','gigabytes',-1,'2025-11-30 08:31:42',NULL),('2025-11-29 08:31:42','2025-11-29 08:31:42','2025-11-29 08:31:42',1,435,'a4129c4b-a691-43c5-9cb7-ee231578889c',103,'527c6a274d1e478eadfe67139e121185','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1807121858-762180852',-1,'2025-11-30 08:31:42',NULL),('2025-11-29 08:31:42','2025-11-29 08:31:42','2025-11-29 08:31:42',1,436,'e788510a-d068-4c8f-be36-50ffeaa850ad',104,'527c6a274d1e478eadfe67139e121185','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1807121858-762180852',-1,'2025-11-30 08:31:42',NULL),('2025-11-29 08:31:49','2025-11-29 08:31:50','2025-11-29 08:31:50',1,437,'b16e6b0c-21ac-45bb-bd34-aeef2fe30f04',105,'eb0810bf6f5b4eb59638b7a2cf59ed5b','volumes',1,'2025-11-30 08:31:49',NULL),('2025-11-29 08:31:49','2025-11-29 08:31:50','2025-11-29 08:31:50',1,438,'d506ad35-0ceb-4527-857e-628d21c24bf7',106,'eb0810bf6f5b4eb59638b7a2cf59ed5b','gigabytes',1,'2025-11-30 08:31:49',NULL),('2025-11-29 08:31:49','2025-11-29 08:31:50','2025-11-29 08:31:50',1,439,'7e43fd01-c4f5-45f2-aa10-bbb21761324f',107,'eb0810bf6f5b4eb59638b7a2cf59ed5b','volumes___DEFAULT__',1,'2025-11-30 08:31:49',NULL),('2025-11-29 08:31:49','2025-11-29 08:31:50','2025-11-29 08:31:50',1,440,'94e7d5eb-1203-4963-9d05-d3fbcb5a2093',108,'eb0810bf6f5b4eb59638b7a2cf59ed5b','gigabytes___DEFAULT__',1,'2025-11-30 08:31:49',NULL),('2025-11-29 08:32:04','2025-11-29 08:32:04','2025-11-29 08:32:04',1,441,'f91ed6f9-47f0-4187-906d-eef439b96f71',105,'eb0810bf6f5b4eb59638b7a2cf59ed5b','volumes',1,'2025-11-30 08:32:04',NULL),('2025-11-29 08:32:04','2025-11-29 08:32:04','2025-11-29 08:32:04',1,442,'3772fb63-ccdc-469c-b069-5bca55e69b3b',106,'eb0810bf6f5b4eb59638b7a2cf59ed5b','gigabytes',1,'2025-11-30 08:32:04',NULL),('2025-11-29 08:32:04','2025-11-29 08:32:04','2025-11-29 08:32:04',1,443,'e0350add-f39a-41dd-9e7f-570ce233b233',107,'eb0810bf6f5b4eb59638b7a2cf59ed5b','volumes___DEFAULT__',1,'2025-11-30 08:32:04',NULL),('2025-11-29 08:32:04','2025-11-29 08:32:04','2025-11-29 08:32:04',1,444,'049b6b0b-07df-47c5-9838-70f9489f8af1',108,'eb0810bf6f5b4eb59638b7a2cf59ed5b','gigabytes___DEFAULT__',1,'2025-11-30 08:32:04',NULL),('2025-11-29 08:32:28','2025-11-29 08:32:28','2025-11-29 08:32:28',1,445,'edbf99e4-ebfe-485f-a005-c7bdfe447231',111,'7e8e7407a7c44208a503e8225c1cf518','volumes',-1,'2025-11-30 08:32:28',NULL),('2025-11-29 08:32:28','2025-11-29 08:32:28','2025-11-29 08:32:28',1,446,'1ed1b182-b22a-410b-8b69-9bda6dd09b4a',112,'7e8e7407a7c44208a503e8225c1cf518','gigabytes',-1,'2025-11-30 08:32:28',NULL),('2025-11-29 08:32:28','2025-11-29 08:32:28','2025-11-29 08:32:28',1,447,'332039c9-e5d0-4812-9bc4-02406ed19bd0',113,'7e8e7407a7c44208a503e8225c1cf518','volumes___DEFAULT__',-1,'2025-11-30 08:32:28',NULL),('2025-11-29 08:32:28','2025-11-29 08:32:28','2025-11-29 08:32:28',1,448,'3fedb961-4ad4-4ef3-9f90-5c6e1155c11c',114,'7e8e7407a7c44208a503e8225c1cf518','gigabytes___DEFAULT__',-1,'2025-11-30 08:32:28',NULL),('2025-11-29 08:32:30','2025-11-29 08:32:30','2025-11-29 08:32:30',1,449,'06fc1dae-4876-4186-9353-b4c716bc5e2c',105,'eb0810bf6f5b4eb59638b7a2cf59ed5b','volumes',-1,'2025-11-30 08:32:30',NULL),('2025-11-29 08:32:30','2025-11-29 08:32:30','2025-11-29 08:32:30',1,450,'ad0d4695-9ca4-4d32-9fcb-52c98bfc9de1',106,'eb0810bf6f5b4eb59638b7a2cf59ed5b','gigabytes',-1,'2025-11-30 08:32:30',NULL),('2025-11-29 08:32:30','2025-11-29 08:32:30','2025-11-29 08:32:30',1,451,'7a5fdd1a-ea6a-4d63-81b1-b6d65f931352',107,'eb0810bf6f5b4eb59638b7a2cf59ed5b','volumes___DEFAULT__',-1,'2025-11-30 08:32:30',NULL),('2025-11-29 08:32:30','2025-11-29 08:32:30','2025-11-29 08:32:30',1,452,'a12fcbbc-0ad8-4cad-adf0-4a444e946734',108,'eb0810bf6f5b4eb59638b7a2cf59ed5b','gigabytes___DEFAULT__',-1,'2025-11-30 08:32:30',NULL),('2025-11-29 08:32:33','2025-11-29 08:32:33','2025-11-29 08:32:33',1,453,'2098194c-2083-4683-b82c-af5ebd1cf345',105,'eb0810bf6f5b4eb59638b7a2cf59ed5b','volumes',-1,'2025-11-30 08:32:33',NULL),('2025-11-29 08:32:33','2025-11-29 08:32:33','2025-11-29 08:32:33',1,454,'bfa87b3d-97b4-403c-a147-489ddf5754f0',106,'eb0810bf6f5b4eb59638b7a2cf59ed5b','gigabytes',-1,'2025-11-30 08:32:33',NULL),('2025-11-29 08:32:33','2025-11-29 08:32:33','2025-11-29 08:32:33',1,455,'a14da865-539e-4fc0-b08b-830382a08f9e',107,'eb0810bf6f5b4eb59638b7a2cf59ed5b','volumes___DEFAULT__',-1,'2025-11-30 08:32:33',NULL),('2025-11-29 08:32:33','2025-11-29 08:32:33','2025-11-29 08:32:33',1,456,'2890c084-35aa-4fba-9e9c-5f3f773bb6bb',108,'eb0810bf6f5b4eb59638b7a2cf59ed5b','gigabytes___DEFAULT__',-1,'2025-11-30 08:32:33',NULL),('2025-11-29 08:32:34','2025-11-29 08:32:34','2025-11-29 08:32:34',1,457,'590bd5ce-b373-437a-a777-e14bfbdd1ab6',115,'7e8e7407a7c44208a503e8225c1cf518','snapshots',-1,'2025-11-30 08:32:34',NULL),('2025-11-29 08:32:34','2025-11-29 08:32:34','2025-11-29 08:32:34',1,458,'7f93cee0-784a-480d-9984-3ea77aa1682b',112,'7e8e7407a7c44208a503e8225c1cf518','gigabytes',-1,'2025-11-30 08:32:34',NULL),('2025-11-29 08:32:34','2025-11-29 08:32:34','2025-11-29 08:32:34',1,459,'b60b1dc0-58b4-41c0-8d09-3790f77146b7',114,'7e8e7407a7c44208a503e8225c1cf518','gigabytes___DEFAULT__',-1,'2025-11-30 08:32:34',NULL),('2025-11-29 08:32:34','2025-11-29 08:32:34','2025-11-29 08:32:34',1,460,'91562465-58b3-4cd6-b3b5-30658cdbef83',116,'7e8e7407a7c44208a503e8225c1cf518','snapshots___DEFAULT__',-1,'2025-11-30 08:32:34',NULL),('2025-11-29 08:32:35','2025-11-29 08:32:35','2025-11-29 08:32:35',1,461,'18fb6f72-2962-4018-afc7-68eb7d45d397',105,'eb0810bf6f5b4eb59638b7a2cf59ed5b','volumes',-1,'2025-11-30 08:32:35',NULL),('2025-11-29 08:32:35','2025-11-29 08:32:35','2025-11-29 08:32:35',1,462,'7b18eabe-94a1-4b50-bd75-076d4ba0a974',106,'eb0810bf6f5b4eb59638b7a2cf59ed5b','gigabytes',-1,'2025-11-30 08:32:35',NULL),('2025-11-29 08:32:35','2025-11-29 08:32:35','2025-11-29 08:32:35',1,463,'623ac5c0-4613-4156-bd51-8d95e9657ad6',107,'eb0810bf6f5b4eb59638b7a2cf59ed5b','volumes___DEFAULT__',-1,'2025-11-30 08:32:35',NULL),('2025-11-29 08:32:35','2025-11-29 08:32:35','2025-11-29 08:32:35',1,464,'f9d7f8ea-ca2a-4e1f-bf0e-a0c0d1607faa',108,'eb0810bf6f5b4eb59638b7a2cf59ed5b','gigabytes___DEFAULT__',-1,'2025-11-30 08:32:35',NULL),('2025-11-29 08:32:44','2025-11-29 08:32:44','2025-11-29 08:32:44',1,465,'b05fe722-51ba-4cf2-b1f9-c5a9c5dca5a1',111,'7e8e7407a7c44208a503e8225c1cf518','volumes',-1,'2025-11-30 08:32:44',NULL),('2025-11-29 08:32:44','2025-11-29 08:32:44','2025-11-29 08:32:44',1,466,'126ebb70-adcb-4272-a34d-9efbf27691f8',112,'7e8e7407a7c44208a503e8225c1cf518','gigabytes',-1,'2025-11-30 08:32:44',NULL),('2025-11-29 08:32:44','2025-11-29 08:32:44','2025-11-29 08:32:44',1,467,'64b2b9f5-3d38-47e8-93ea-ff338d70441a',113,'7e8e7407a7c44208a503e8225c1cf518','volumes___DEFAULT__',-1,'2025-11-30 08:32:44',NULL),('2025-11-29 08:32:44','2025-11-29 08:32:44','2025-11-29 08:32:44',1,468,'dccac40b-e848-4d51-b1d5-9ae65262b6c7',114,'7e8e7407a7c44208a503e8225c1cf518','gigabytes___DEFAULT__',-1,'2025-11-30 08:32:44',NULL),('2025-11-29 08:32:47','2025-11-29 08:32:47','2025-11-29 08:32:47',1,469,'1cd04db0-ed06-414a-9c67-0ad6054c2550',121,'12fcca7596944721afda13c50e6de05c','volumes',1,'2025-11-30 08:32:47',NULL),('2025-11-29 08:32:47','2025-11-29 08:32:47','2025-11-29 08:32:47',1,470,'5db45703-9a37-4080-a61c-3d08e2864b69',122,'12fcca7596944721afda13c50e6de05c','gigabytes',1,'2025-11-30 08:32:47',NULL),('2025-11-29 08:32:47','2025-11-29 08:32:47','2025-11-29 08:32:47',1,471,'f106d110-7d97-4741-93e6-129d8ce044b6',123,'12fcca7596944721afda13c50e6de05c','volumes___DEFAULT__',1,'2025-11-30 08:32:47',NULL),('2025-11-29 08:32:47','2025-11-29 08:32:47','2025-11-29 08:32:47',1,472,'ebdf946b-2dcd-4b51-8185-c51bd65ea66e',124,'12fcca7596944721afda13c50e6de05c','gigabytes___DEFAULT__',1,'2025-11-30 08:32:47',NULL),('2025-11-29 08:32:48','2025-11-29 08:32:48','2025-11-29 08:32:48',1,473,'aceeadaa-332d-43e6-818e-78cb8300bc43',121,'12fcca7596944721afda13c50e6de05c','volumes',-1,'2025-11-30 08:32:48',NULL),('2025-11-29 08:32:48','2025-11-29 08:32:48','2025-11-29 08:32:48',1,474,'0e793dd5-2802-41bb-b26a-3dc33ea5d219',122,'12fcca7596944721afda13c50e6de05c','gigabytes',-1,'2025-11-30 08:32:48',NULL),('2025-11-29 08:32:48','2025-11-29 08:32:48','2025-11-29 08:32:48',1,475,'68bd5e8f-20ac-4d0a-b2a7-6c32b3ba04aa',123,'12fcca7596944721afda13c50e6de05c','volumes___DEFAULT__',-1,'2025-11-30 08:32:48',NULL),('2025-11-29 08:32:48','2025-11-29 08:32:48','2025-11-29 08:32:48',1,476,'f5aa283a-3c72-4a38-8622-18c1d4367e09',124,'12fcca7596944721afda13c50e6de05c','gigabytes___DEFAULT__',-1,'2025-11-30 08:32:48',NULL),('2025-11-29 08:33:24','2025-11-29 08:33:24','2025-11-29 08:33:24',1,477,'137eb942-4b43-42d9-ae67-9b7a663d3b90',125,'340d97a89c434bedbead3110819c581d','volumes',1,'2025-11-30 08:33:24',NULL),('2025-11-29 08:33:24','2025-11-29 08:33:24','2025-11-29 08:33:24',1,478,'8b05b215-7e0c-4ce4-9307-cc2a9d05889e',126,'340d97a89c434bedbead3110819c581d','gigabytes',1,'2025-11-30 08:33:24',NULL),('2025-11-29 08:33:24','2025-11-29 08:33:24','2025-11-29 08:33:24',1,479,'49e9d16c-63cf-4ea4-a36a-2d132d4a2e99',127,'340d97a89c434bedbead3110819c581d','volumes___DEFAULT__',1,'2025-11-30 08:33:24',NULL),('2025-11-29 08:33:24','2025-11-29 08:33:24','2025-11-29 08:33:24',1,480,'677938a1-12cd-4177-b2f4-4fbc21815bfe',128,'340d97a89c434bedbead3110819c581d','gigabytes___DEFAULT__',1,'2025-11-30 08:33:24',NULL),('2025-11-29 08:33:36','2025-11-29 08:33:36','2025-11-29 08:33:36',1,481,'53c017af-c2e3-4771-b6a9-35e9f10b44ea',129,'340d97a89c434bedbead3110819c581d','backups',1,'2025-11-30 08:33:36',NULL),('2025-11-29 08:33:36','2025-11-29 08:33:36','2025-11-29 08:33:36',1,482,'545775d6-84dc-4e97-9178-295da68efb7e',130,'340d97a89c434bedbead3110819c581d','backup_gigabytes',1,'2025-11-30 08:33:36',NULL),('2025-11-29 08:33:44','2025-11-29 08:33:44','2025-11-29 08:33:44',1,483,'fef5c932-4366-44c7-a095-f96de6723410',117,'37972b49ddde4c519c6523d2ea1569b5','volumes',1,'2025-11-30 08:33:43',NULL),('2025-11-29 08:33:44','2025-11-29 08:33:44','2025-11-29 08:33:44',1,484,'4b5ecbe6-d37b-4d98-aa54-2b3de093cb65',118,'37972b49ddde4c519c6523d2ea1569b5','gigabytes',1,'2025-11-30 08:33:43',NULL),('2025-11-29 08:33:44','2025-11-29 08:33:44','2025-11-29 08:33:44',1,485,'d238106c-c4d4-4b90-a560-a048a1954b78',119,'37972b49ddde4c519c6523d2ea1569b5','volumes___DEFAULT__',1,'2025-11-30 08:33:43',NULL),('2025-11-29 08:33:44','2025-11-29 08:33:44','2025-11-29 08:33:44',1,486,'e388fe4d-749a-40a2-8aaf-dc75ca579b36',120,'37972b49ddde4c519c6523d2ea1569b5','gigabytes___DEFAULT__',1,'2025-11-30 08:33:43',NULL),('2025-11-29 08:33:46','2025-11-29 08:33:47','2025-11-29 08:33:47',1,487,'39ba0ba5-b477-4776-8695-19ac4b87321d',125,'340d97a89c434bedbead3110819c581d','volumes',1,'2025-11-30 08:33:46',NULL),('2025-11-29 08:33:46','2025-11-29 08:33:47','2025-11-29 08:33:47',1,488,'3f13b139-6235-4507-91cd-200065e18e2d',126,'340d97a89c434bedbead3110819c581d','gigabytes',1,'2025-11-30 08:33:46',NULL),('2025-11-29 08:33:46','2025-11-29 08:33:47','2025-11-29 08:33:47',1,489,'2fdf2cc5-2992-4e24-b3fb-cd69986665e6',127,'340d97a89c434bedbead3110819c581d','volumes___DEFAULT__',1,'2025-11-30 08:33:46',NULL),('2025-11-29 08:33:46','2025-11-29 08:33:47','2025-11-29 08:33:47',1,490,'96017100-7293-4b13-b4f4-9e348d03428d',128,'340d97a89c434bedbead3110819c581d','gigabytes___DEFAULT__',1,'2025-11-30 08:33:46',NULL),('2025-11-29 08:34:45','2025-11-29 08:34:45','2025-11-29 08:34:45',1,491,'9eb28039-5af6-475c-99e0-f3aee4dcf6f5',125,'340d97a89c434bedbead3110819c581d','volumes',-1,'2025-11-30 08:34:45',NULL),('2025-11-29 08:34:45','2025-11-29 08:34:45','2025-11-29 08:34:45',1,492,'6301051a-bc91-42ed-9c73-7da9790ff11a',126,'340d97a89c434bedbead3110819c581d','gigabytes',-1,'2025-11-30 08:34:45',NULL),('2025-11-29 08:34:45','2025-11-29 08:34:45','2025-11-29 08:34:45',1,493,'0e07e6b3-8634-446a-9f15-26302d28ecc3',127,'340d97a89c434bedbead3110819c581d','volumes___DEFAULT__',-1,'2025-11-30 08:34:45',NULL),('2025-11-29 08:34:45','2025-11-29 08:34:45','2025-11-29 08:34:45',1,494,'8ab5ce65-372d-4b99-a35d-78509dfd4f84',128,'340d97a89c434bedbead3110819c581d','gigabytes___DEFAULT__',-1,'2025-11-30 08:34:45',NULL),('2025-11-29 08:34:45','2025-11-29 08:34:45','2025-11-29 08:34:45',1,495,'d0339e76-e930-46c1-89ec-f60bab319198',125,'340d97a89c434bedbead3110819c581d','volumes',-1,'2025-11-30 08:34:45',NULL),('2025-11-29 08:34:45','2025-11-29 08:34:45','2025-11-29 08:34:45',1,496,'025e330b-c88c-4a16-ae81-e03a8472f84e',126,'340d97a89c434bedbead3110819c581d','gigabytes',-1,'2025-11-30 08:34:45',NULL),('2025-11-29 08:34:45','2025-11-29 08:34:45','2025-11-29 08:34:45',1,497,'2486089d-8793-4cf4-b884-45dbe987f08a',127,'340d97a89c434bedbead3110819c581d','volumes___DEFAULT__',-1,'2025-11-30 08:34:45',NULL),('2025-11-29 08:34:45','2025-11-29 08:34:45','2025-11-29 08:34:45',1,498,'f67ab26f-43a6-48c6-b563-6c1c795e5d96',128,'340d97a89c434bedbead3110819c581d','gigabytes___DEFAULT__',-1,'2025-11-30 08:34:45',NULL),('2025-11-29 08:34:47','2025-11-29 08:34:47','2025-11-29 08:34:47',1,499,'9f60acdd-77e8-41f5-b2b5-52834a9f44fd',129,'340d97a89c434bedbead3110819c581d','backups',-1,'2025-11-30 08:34:47',NULL),('2025-11-29 08:34:47','2025-11-29 08:34:47','2025-11-29 08:34:47',1,500,'0e037d9e-5cb3-4f03-99df-4d1e2efa5ae5',130,'340d97a89c434bedbead3110819c581d','backup_gigabytes',-1,'2025-11-30 08:34:47',NULL),('2025-11-29 08:35:01','2025-11-29 08:35:01','2025-11-29 08:35:01',1,501,'be92ce9f-ddf2-4fbc-b620-9b3c1798a424',117,'37972b49ddde4c519c6523d2ea1569b5','volumes',-1,'2025-11-30 08:35:01',NULL),('2025-11-29 08:35:01','2025-11-29 08:35:01','2025-11-29 08:35:01',1,502,'64910039-1be1-4372-b450-b35689b1a598',118,'37972b49ddde4c519c6523d2ea1569b5','gigabytes',-1,'2025-11-30 08:35:01',NULL),('2025-11-29 08:35:01','2025-11-29 08:35:01','2025-11-29 08:35:01',1,503,'041dca47-9cca-4a38-881e-a4c3dc93e6b5',119,'37972b49ddde4c519c6523d2ea1569b5','volumes___DEFAULT__',-1,'2025-11-30 08:35:01',NULL),('2025-11-29 08:35:01','2025-11-29 08:35:01','2025-11-29 08:35:01',1,504,'dac89afc-1c0a-4156-b331-7a119a87cf89',120,'37972b49ddde4c519c6523d2ea1569b5','gigabytes___DEFAULT__',-1,'2025-11-30 08:35:01',NULL),('2025-11-29 08:35:03','2025-11-29 08:35:03','2025-11-29 08:35:03',1,505,'2ff973fc-77c3-4623-8823-0e7a3c68edae',117,'37972b49ddde4c519c6523d2ea1569b5','volumes',-1,'2025-11-30 08:35:03',NULL),('2025-11-29 08:35:03','2025-11-29 08:35:03','2025-11-29 08:35:03',1,506,'de265e2a-8428-4d28-91da-e11be695166e',118,'37972b49ddde4c519c6523d2ea1569b5','gigabytes',-1,'2025-11-30 08:35:03',NULL),('2025-11-29 08:35:03','2025-11-29 08:35:03','2025-11-29 08:35:03',1,507,'19a24474-3b05-4dd0-8037-2ca9e4f68aef',119,'37972b49ddde4c519c6523d2ea1569b5','volumes___DEFAULT__',-1,'2025-11-30 08:35:03',NULL),('2025-11-29 08:35:03','2025-11-29 08:35:03','2025-11-29 08:35:03',1,508,'994aaa06-5ac3-4b36-95c7-593343294d47',120,'37972b49ddde4c519c6523d2ea1569b5','gigabytes___DEFAULT__',-1,'2025-11-30 08:35:03',NULL),('2025-11-29 08:36:05','2025-11-29 08:36:05','2025-11-29 08:36:05',1,509,'2c682bf1-6318-4204-b7ca-98a479491a80',131,'3827b5eea76e4810b48ea1733ae5edc4','volumes',1,'2025-11-30 08:36:05',NULL),('2025-11-29 08:36:05','2025-11-29 08:36:05','2025-11-29 08:36:05',1,510,'a778a551-ead6-4b3d-a782-9f7191b2d1b0',132,'3827b5eea76e4810b48ea1733ae5edc4','gigabytes',1,'2025-11-30 08:36:05',NULL),('2025-11-29 08:36:05','2025-11-29 08:36:05','2025-11-29 08:36:05',1,511,'cde3f661-3ad7-4078-88e3-71c51c2ef5b7',133,'3827b5eea76e4810b48ea1733ae5edc4','volumes_tempest-scenario-type-luks-596546322',1,'2025-11-30 08:36:05',NULL),('2025-11-29 08:36:05','2025-11-29 08:36:05','2025-11-29 08:36:05',1,512,'245cdc6b-846e-4748-9063-cdcb650c26d9',134,'3827b5eea76e4810b48ea1733ae5edc4','gigabytes_tempest-scenario-type-luks-596546322',1,'2025-11-30 08:36:05',NULL),('2025-11-29 08:37:37','2025-11-29 08:37:37','2025-11-29 08:37:37',1,513,'bbb8f938-708a-4092-bb50-84369eb274ce',131,'3827b5eea76e4810b48ea1733ae5edc4','volumes',-1,'2025-11-30 08:37:37',NULL),('2025-11-29 08:37:37','2025-11-29 08:37:37','2025-11-29 08:37:37',1,514,'df734b31-246f-47c6-924b-3c36a20a7872',132,'3827b5eea76e4810b48ea1733ae5edc4','gigabytes',-1,'2025-11-30 08:37:37',NULL),('2025-11-29 08:37:37','2025-11-29 08:37:37','2025-11-29 08:37:37',1,515,'04226d3c-fbf1-4c9d-8a51-205aa62a8e39',133,'3827b5eea76e4810b48ea1733ae5edc4','volumes_tempest-scenario-type-luks-596546322',-1,'2025-11-30 08:37:37',NULL),('2025-11-29 08:37:37','2025-11-29 08:37:37','2025-11-29 08:37:37',1,516,'c82f3f95-c411-4b27-ac85-b246dd348584',134,'3827b5eea76e4810b48ea1733ae5edc4','gigabytes_tempest-scenario-type-luks-596546322',-1,'2025-11-30 08:37:37',NULL),('2025-11-29 08:48:55','2025-11-29 08:48:55','2025-11-29 08:48:55',1,517,'9fd1a675-66f0-405f-ad16-fe3ff2853e1e',135,'c5e836f8387a492c8119be72f1fb9980','volumes',1,'2025-11-30 08:48:55',NULL),('2025-11-29 08:48:55','2025-11-29 08:48:55','2025-11-29 08:48:55',1,518,'a4de523f-3f6a-49b9-8b3e-3a436f6ace3e',136,'c5e836f8387a492c8119be72f1fb9980','gigabytes',1,'2025-11-30 08:48:55',NULL),('2025-11-29 08:48:55','2025-11-29 08:48:55','2025-11-29 08:48:55',1,519,'4040e3a8-e6f2-4574-934e-6d6fbe5b5960',137,'c5e836f8387a492c8119be72f1fb9980','volumes___DEFAULT__',1,'2025-11-30 08:48:55',NULL),('2025-11-29 08:48:55','2025-11-29 08:48:55','2025-11-29 08:48:55',1,520,'6b7bbedf-a17f-4c8d-8afa-7d1ebf8abfb7',138,'c5e836f8387a492c8119be72f1fb9980','gigabytes___DEFAULT__',1,'2025-11-30 08:48:55',NULL),('2025-11-29 08:50:38','2025-11-29 08:50:38','2025-11-29 08:50:38',1,521,'520774da-a84f-4333-ac5c-7d4a97f414c8',135,'c5e836f8387a492c8119be72f1fb9980','volumes',-1,'2025-11-30 08:50:38',NULL),('2025-11-29 08:50:38','2025-11-29 08:50:38','2025-11-29 08:50:38',1,522,'29ba42b7-d56f-4cae-a8dc-95658b7fd83b',136,'c5e836f8387a492c8119be72f1fb9980','gigabytes',-1,'2025-11-30 08:50:38',NULL),('2025-11-29 08:50:38','2025-11-29 08:50:38','2025-11-29 08:50:38',1,523,'3eb4b8dc-7c61-4c64-a09f-5681c32a6ee6',137,'c5e836f8387a492c8119be72f1fb9980','volumes___DEFAULT__',-1,'2025-11-30 08:50:38',NULL),('2025-11-29 08:50:38','2025-11-29 08:50:38','2025-11-29 08:50:38',1,524,'25c04769-4535-4fcd-b380-ede46f25b375',138,'c5e836f8387a492c8119be72f1fb9980','gigabytes___DEFAULT__',-1,'2025-11-30 08:50:38',NULL),('2025-11-29 09:07:16','2025-11-29 09:07:16','2025-11-29 09:07:16',1,525,'7c70004b-b7ba-485f-94f3-8cb9e2658f6b',139,'51af0a2ee11a460ab825a484e5c6f4a3','volumes',1,'2025-11-30 09:07:16',NULL),('2025-11-29 09:07:16','2025-11-29 09:07:16','2025-11-29 09:07:16',1,526,'e19e27ba-f856-4dc4-b416-8a8bbec95a86',140,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes',1,'2025-11-30 09:07:16',NULL),('2025-11-29 09:07:16','2025-11-29 09:07:16','2025-11-29 09:07:16',1,527,'daf56da3-1d9c-470c-8fea-25f2424f4a97',141,'51af0a2ee11a460ab825a484e5c6f4a3','volumes_tempest-scenario-type-luks-827233183',1,'2025-11-30 09:07:16',NULL),('2025-11-29 09:07:16','2025-11-29 09:07:16','2025-11-29 09:07:16',1,528,'607b907d-ac63-4d69-bffc-760c928cee51',142,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes_tempest-scenario-type-luks-827233183',1,'2025-11-30 09:07:16',NULL),('2025-11-29 09:08:02','2025-11-29 09:08:02','2025-11-29 09:08:02',1,529,'36647dbb-4fa3-4298-af66-ffa9bec43bbc',139,'51af0a2ee11a460ab825a484e5c6f4a3','volumes',-1,'2025-11-30 09:08:02',NULL),('2025-11-29 09:08:02','2025-11-29 09:08:02','2025-11-29 09:08:02',1,530,'3c1f44df-e6d6-4289-a8f4-46a0c3bb1c4d',140,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes',-1,'2025-11-30 09:08:02',NULL),('2025-11-29 09:08:02','2025-11-29 09:08:02','2025-11-29 09:08:02',1,531,'01339b12-92d5-4710-a3d0-5f50a6a6f869',141,'51af0a2ee11a460ab825a484e5c6f4a3','volumes_tempest-scenario-type-luks-827233183',-1,'2025-11-30 09:08:02',NULL),('2025-11-29 09:08:02','2025-11-29 09:08:02','2025-11-29 09:08:02',1,532,'566f0857-759c-43ef-81f0-0c6eaef1fc1d',142,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes_tempest-scenario-type-luks-827233183',-1,'2025-11-30 09:08:02',NULL),('2025-11-29 09:08:06','2025-11-29 09:08:06','2025-11-29 09:08:06',1,533,'d5542981-b87c-4fc9-80f1-790c5eb911e4',139,'51af0a2ee11a460ab825a484e5c6f4a3','volumes',1,'2025-11-30 09:08:06',NULL),('2025-11-29 09:08:06','2025-11-29 09:08:06','2025-11-29 09:08:06',1,534,'c37b7197-20e4-420f-bbf1-c187e1bcb3ca',140,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes',1,'2025-11-30 09:08:06',NULL),('2025-11-29 09:08:06','2025-11-29 09:08:06','2025-11-29 09:08:06',1,535,'122f6ce9-01c6-43dd-9e8d-dd52c9068c84',143,'51af0a2ee11a460ab825a484e5c6f4a3','volumes___DEFAULT__',1,'2025-11-30 09:08:06',NULL),('2025-11-29 09:08:06','2025-11-29 09:08:06','2025-11-29 09:08:06',1,536,'0c6c1646-ab40-49a5-b659-65791860ba79',144,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes___DEFAULT__',1,'2025-11-30 09:08:06',NULL),('2025-11-29 09:09:15','2025-11-29 09:09:16','2025-11-29 09:09:16',1,537,'a0b430fa-6596-4b31-8541-14c3a7cc0a35',145,'51af0a2ee11a460ab825a484e5c6f4a3','snapshots',1,'2025-11-30 09:09:11',NULL),('2025-11-29 09:09:15','2025-11-29 09:09:16','2025-11-29 09:09:16',1,538,'8abf14d8-611f-430e-9f69-147666c48b5c',140,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes',1,'2025-11-30 09:09:11',NULL),('2025-11-29 09:09:15','2025-11-29 09:09:16','2025-11-29 09:09:16',1,539,'dbf9b082-e17e-4532-8f3d-2d323da2864f',144,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes___DEFAULT__',1,'2025-11-30 09:09:11',NULL),('2025-11-29 09:09:15','2025-11-29 09:09:16','2025-11-29 09:09:16',1,540,'a069f587-36dc-48e4-8f19-71bac61ae226',146,'51af0a2ee11a460ab825a484e5c6f4a3','snapshots___DEFAULT__',1,'2025-11-30 09:09:11',NULL),('2025-11-29 09:09:34','2025-11-29 09:09:40','2025-11-29 09:09:40',1,541,'3eeecc50-ade2-4918-add2-6ae4bc15413f',139,'51af0a2ee11a460ab825a484e5c6f4a3','volumes',1,'2025-11-30 09:09:34',NULL),('2025-11-29 09:09:34','2025-11-29 09:09:40','2025-11-29 09:09:40',1,542,'c114bfbb-2971-4e8c-8617-abe65fa155c5',140,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes',1,'2025-11-30 09:09:34',NULL),('2025-11-29 09:09:34','2025-11-29 09:09:40','2025-11-29 09:09:40',1,543,'dc3e38d0-4585-4aba-9a8e-ca3d0535c58a',143,'51af0a2ee11a460ab825a484e5c6f4a3','volumes___DEFAULT__',1,'2025-11-30 09:09:34',NULL),('2025-11-29 09:09:34','2025-11-29 09:09:40','2025-11-29 09:09:40',1,544,'9768626f-0de7-4e1e-a4c3-77eea231a1f3',144,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes___DEFAULT__',1,'2025-11-30 09:09:34',NULL),('2025-11-29 09:10:23','2025-11-29 09:10:23','2025-11-29 09:10:23',1,545,'f8218f26-3214-409c-9a52-dfff7cbd3f1c',139,'51af0a2ee11a460ab825a484e5c6f4a3','volumes',-1,'2025-11-30 09:10:23',NULL),('2025-11-29 09:10:23','2025-11-29 09:10:23','2025-11-29 09:10:23',1,546,'cf8506cf-a469-40bd-aea6-b817de43a92f',140,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes',-1,'2025-11-30 09:10:23',NULL),('2025-11-29 09:10:23','2025-11-29 09:10:23','2025-11-29 09:10:23',1,547,'b40509c6-1c33-4eb0-9f05-382b9c6dcbeb',143,'51af0a2ee11a460ab825a484e5c6f4a3','volumes___DEFAULT__',-1,'2025-11-30 09:10:23',NULL),('2025-11-29 09:10:23','2025-11-29 09:10:23','2025-11-29 09:10:23',1,548,'7ceb2889-bf94-4525-8815-88689111b4c9',144,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes___DEFAULT__',-1,'2025-11-30 09:10:23',NULL),('2025-11-29 09:10:26','2025-11-29 09:10:26','2025-11-29 09:10:26',1,549,'c7ab1f9e-5239-4cad-a120-6b883d0b74a1',145,'51af0a2ee11a460ab825a484e5c6f4a3','snapshots',-1,'2025-11-30 09:10:26',NULL),('2025-11-29 09:10:26','2025-11-29 09:10:26','2025-11-29 09:10:26',1,550,'26f89984-4aae-485a-99df-a5446d5e0bd6',140,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes',-1,'2025-11-30 09:10:26',NULL),('2025-11-29 09:10:26','2025-11-29 09:10:26','2025-11-29 09:10:26',1,551,'f8bd5e52-5d9e-4640-ba33-369bbf1330be',144,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes___DEFAULT__',-1,'2025-11-30 09:10:26',NULL),('2025-11-29 09:10:26','2025-11-29 09:10:26','2025-11-29 09:10:26',1,552,'ccd0c5e1-1f9f-4230-b835-6849834d0841',146,'51af0a2ee11a460ab825a484e5c6f4a3','snapshots___DEFAULT__',-1,'2025-11-30 09:10:26',NULL),('2025-11-29 09:10:28','2025-11-29 09:10:28','2025-11-29 09:10:28',1,553,'e36149fc-f516-4d3b-9693-8e35a38c17a9',139,'51af0a2ee11a460ab825a484e5c6f4a3','volumes',-1,'2025-11-30 09:10:28',NULL),('2025-11-29 09:10:28','2025-11-29 09:10:28','2025-11-29 09:10:28',1,554,'94fbcd07-e3a4-4ba0-bfd0-e5c1a9c924c7',140,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes',-1,'2025-11-30 09:10:28',NULL),('2025-11-29 09:10:28','2025-11-29 09:10:28','2025-11-29 09:10:28',1,555,'7ab12366-b0dc-4e2e-a22e-bfd3f3c5ceee',143,'51af0a2ee11a460ab825a484e5c6f4a3','volumes___DEFAULT__',-1,'2025-11-30 09:10:28',NULL),('2025-11-29 09:10:28','2025-11-29 09:10:28','2025-11-29 09:10:28',1,556,'69a07975-d2ff-42a5-bb23-b829f0310907',144,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes___DEFAULT__',-1,'2025-11-30 09:10:28',NULL),('2025-11-29 09:10:31','2025-11-29 09:10:31','2025-11-29 09:10:31',1,557,'abc13697-ef54-45a1-b8dc-9999335c6b5d',139,'51af0a2ee11a460ab825a484e5c6f4a3','volumes',1,'2025-11-30 09:10:31',NULL),('2025-11-29 09:10:31','2025-11-29 09:10:31','2025-11-29 09:10:31',1,558,'4ecc98dd-97a3-468d-8c85-f060e762c0c2',140,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes',1,'2025-11-30 09:10:31',NULL),('2025-11-29 09:10:31','2025-11-29 09:10:31','2025-11-29 09:10:31',1,559,'e358eed6-e703-4b22-8531-22453b74de68',143,'51af0a2ee11a460ab825a484e5c6f4a3','volumes___DEFAULT__',1,'2025-11-30 09:10:31',NULL),('2025-11-29 09:10:31','2025-11-29 09:10:31','2025-11-29 09:10:31',1,560,'e1e9a8ac-96da-4b10-9529-e54b25506b70',144,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes___DEFAULT__',1,'2025-11-30 09:10:31',NULL),('2025-11-29 09:11:36','2025-11-29 09:11:36','2025-11-29 09:11:36',1,561,'6f0b9788-fd51-450e-9161-65f8a9a9e077',145,'51af0a2ee11a460ab825a484e5c6f4a3','snapshots',1,'2025-11-30 09:11:36',NULL),('2025-11-29 09:11:36','2025-11-29 09:11:36','2025-11-29 09:11:36',1,562,'9c82b2ce-bfbc-4e07-a711-9adc34cbc6f7',140,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes',1,'2025-11-30 09:11:36',NULL),('2025-11-29 09:11:36','2025-11-29 09:11:36','2025-11-29 09:11:36',1,563,'2b083281-03d2-4c4e-b4f0-83da3295e92b',144,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes___DEFAULT__',1,'2025-11-30 09:11:36',NULL),('2025-11-29 09:11:36','2025-11-29 09:11:36','2025-11-29 09:11:36',1,564,'b4e06bda-fc2c-4466-9acc-892b05adfc81',146,'51af0a2ee11a460ab825a484e5c6f4a3','snapshots___DEFAULT__',1,'2025-11-30 09:11:36',NULL),('2025-11-29 09:11:48','2025-11-29 09:11:48','2025-11-29 09:11:48',1,565,'c40d1f01-1018-418d-b238-efd31c5b497e',139,'51af0a2ee11a460ab825a484e5c6f4a3','volumes',1,'2025-11-30 09:11:48',NULL),('2025-11-29 09:11:48','2025-11-29 09:11:48','2025-11-29 09:11:48',1,566,'4bbc5561-4f2e-47e2-8d2b-b79b4f504151',140,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes',1,'2025-11-30 09:11:48',NULL),('2025-11-29 09:11:48','2025-11-29 09:11:48','2025-11-29 09:11:48',1,567,'200b8e0d-6ab4-499a-adfb-28540be6d1fa',143,'51af0a2ee11a460ab825a484e5c6f4a3','volumes___DEFAULT__',1,'2025-11-30 09:11:48',NULL),('2025-11-29 09:11:48','2025-11-29 09:11:48','2025-11-29 09:11:48',1,568,'9d462023-7465-48b3-87a8-22518c78391f',144,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes___DEFAULT__',1,'2025-11-30 09:11:48',NULL),('2025-11-29 09:12:57','2025-11-29 09:12:57','2025-11-29 09:12:57',1,569,'22a63bb5-b9e3-4dd4-8ec3-9ffa897f02d8',139,'51af0a2ee11a460ab825a484e5c6f4a3','volumes',-1,'2025-11-30 09:12:57',NULL),('2025-11-29 09:12:57','2025-11-29 09:12:57','2025-11-29 09:12:57',1,570,'54e4188d-eab2-417c-ae4d-f21bf577498b',140,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes',-1,'2025-11-30 09:12:57',NULL),('2025-11-29 09:12:57','2025-11-29 09:12:57','2025-11-29 09:12:57',1,571,'9548b8cc-4fd3-495a-9767-7a1a4257a31a',143,'51af0a2ee11a460ab825a484e5c6f4a3','volumes___DEFAULT__',-1,'2025-11-30 09:12:57',NULL),('2025-11-29 09:12:57','2025-11-29 09:12:57','2025-11-29 09:12:57',1,572,'37395fec-3e95-4807-91ad-137fee0af1db',144,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes___DEFAULT__',-1,'2025-11-30 09:12:57',NULL),('2025-11-29 09:12:58','2025-11-29 09:12:58','2025-11-29 09:12:58',1,573,'bd338b0f-75da-4907-a95b-dbab48e3dfa7',145,'51af0a2ee11a460ab825a484e5c6f4a3','snapshots',-1,'2025-11-30 09:12:58',NULL),('2025-11-29 09:12:58','2025-11-29 09:12:58','2025-11-29 09:12:58',1,574,'bc5ea0d7-510b-46a2-8d10-10e32725c3a3',140,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes',-1,'2025-11-30 09:12:58',NULL),('2025-11-29 09:12:58','2025-11-29 09:12:58','2025-11-29 09:12:58',1,575,'1bb69f90-490e-45eb-89a9-f206cbb0b165',144,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes___DEFAULT__',-1,'2025-11-30 09:12:58',NULL),('2025-11-29 09:12:58','2025-11-29 09:12:58','2025-11-29 09:12:58',1,576,'6ee00f35-aae4-4a44-8ff2-02b0b2fc4a84',146,'51af0a2ee11a460ab825a484e5c6f4a3','snapshots___DEFAULT__',-1,'2025-11-30 09:12:58',NULL),('2025-11-29 09:13:06','2025-11-29 09:13:06','2025-11-29 09:13:06',1,577,'247b499b-84af-43f5-a786-87f57ab6a3fa',139,'51af0a2ee11a460ab825a484e5c6f4a3','volumes',-1,'2025-11-30 09:13:06',NULL),('2025-11-29 09:13:06','2025-11-29 09:13:06','2025-11-29 09:13:06',1,578,'b5b0c66a-7d9a-4e98-8923-707a86458865',140,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes',-1,'2025-11-30 09:13:06',NULL),('2025-11-29 09:13:06','2025-11-29 09:13:06','2025-11-29 09:13:06',1,579,'05f488fc-2629-4dab-934a-0b4a9654fc18',143,'51af0a2ee11a460ab825a484e5c6f4a3','volumes___DEFAULT__',-1,'2025-11-30 09:13:06',NULL),('2025-11-29 09:13:06','2025-11-29 09:13:06','2025-11-29 09:13:06',1,580,'7641dd42-dd9c-4875-ad78-641fadd9e5cc',144,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes___DEFAULT__',-1,'2025-11-30 09:13:06',NULL),('2025-11-29 09:13:21','2025-11-29 09:13:21','2025-11-29 09:13:21',1,581,'c2dc88f9-cca6-451d-aa6c-4f757204d1ac',139,'51af0a2ee11a460ab825a484e5c6f4a3','volumes',1,'2025-11-30 09:13:21',NULL),('2025-11-29 09:13:21','2025-11-29 09:13:21','2025-11-29 09:13:21',1,582,'7cbd757e-b414-46ee-aa91-454bc45253a7',140,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes',1,'2025-11-30 09:13:21',NULL),('2025-11-29 09:13:21','2025-11-29 09:13:21','2025-11-29 09:13:21',1,583,'c79333fb-9fd2-429b-a800-2fd140337f20',143,'51af0a2ee11a460ab825a484e5c6f4a3','volumes___DEFAULT__',1,'2025-11-30 09:13:21',NULL),('2025-11-29 09:13:21','2025-11-29 09:13:21','2025-11-29 09:13:21',1,584,'bcbaa175-bcbd-4482-9aa7-1655061ccd00',144,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes___DEFAULT__',1,'2025-11-30 09:13:21',NULL),('2025-11-29 09:15:00','2025-11-29 09:15:00','2025-11-29 09:15:00',1,585,'495a1eb9-a6d5-4f7e-bc47-505f6b6f4780',145,'51af0a2ee11a460ab825a484e5c6f4a3','snapshots',1,'2025-11-30 09:15:00',NULL),('2025-11-29 09:15:00','2025-11-29 09:15:00','2025-11-29 09:15:00',1,586,'2f79252f-8f9f-4881-ad71-c429b9748c07',140,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes',1,'2025-11-30 09:15:00',NULL),('2025-11-29 09:15:00','2025-11-29 09:15:00','2025-11-29 09:15:00',1,587,'a387e03d-9daf-4d9c-8f4f-59a08bd34165',144,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes___DEFAULT__',1,'2025-11-30 09:15:00',NULL),('2025-11-29 09:15:00','2025-11-29 09:15:00','2025-11-29 09:15:00',1,588,'b0d78656-d062-43a0-9d8d-ae4a7ca5bf14',146,'51af0a2ee11a460ab825a484e5c6f4a3','snapshots___DEFAULT__',1,'2025-11-30 09:15:00',NULL),('2025-11-29 09:15:02','2025-11-29 09:15:02','2025-11-29 09:15:02',1,589,'065def2d-68cd-4a72-b676-4f5afe6a7ca0',139,'51af0a2ee11a460ab825a484e5c6f4a3','volumes',1,'2025-11-30 09:15:02',NULL),('2025-11-29 09:15:02','2025-11-29 09:15:02','2025-11-29 09:15:02',1,590,'cb955ff0-ae06-48ef-b64c-7ab0aef70270',140,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes',1,'2025-11-30 09:15:02',NULL),('2025-11-29 09:15:02','2025-11-29 09:15:02','2025-11-29 09:15:02',1,591,'a614eb01-2563-4e15-8535-152710d6d475',143,'51af0a2ee11a460ab825a484e5c6f4a3','volumes___DEFAULT__',1,'2025-11-30 09:15:02',NULL),('2025-11-29 09:15:02','2025-11-29 09:15:02','2025-11-29 09:15:02',1,592,'bcc31142-d4d3-4d74-9992-656453144bf4',144,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes___DEFAULT__',1,'2025-11-30 09:15:02',NULL),('2025-11-29 09:16:00','2025-11-29 09:16:00','2025-11-29 09:16:00',1,593,'3101e004-3a22-4c57-a06c-f7dcda7a15a8',139,'51af0a2ee11a460ab825a484e5c6f4a3','volumes',-1,'2025-11-30 09:16:00',NULL),('2025-11-29 09:16:00','2025-11-29 09:16:00','2025-11-29 09:16:00',1,594,'d812fd1c-a212-4b1b-b4f0-a62750789ae3',140,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes',-1,'2025-11-30 09:16:00',NULL),('2025-11-29 09:16:00','2025-11-29 09:16:00','2025-11-29 09:16:00',1,595,'cebb2aea-80e9-4f96-9ba3-1ddfa14128ae',143,'51af0a2ee11a460ab825a484e5c6f4a3','volumes___DEFAULT__',-1,'2025-11-30 09:16:00',NULL),('2025-11-29 09:16:00','2025-11-29 09:16:00','2025-11-29 09:16:00',1,596,'3f71c739-3457-4137-a46d-442749289506',144,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes___DEFAULT__',-1,'2025-11-30 09:16:00',NULL),('2025-11-29 09:16:01','2025-11-29 09:16:01','2025-11-29 09:16:01',1,597,'5e1df27d-1d32-44f7-99cd-c89aaf24be3f',145,'51af0a2ee11a460ab825a484e5c6f4a3','snapshots',-1,'2025-11-30 09:16:01',NULL),('2025-11-29 09:16:01','2025-11-29 09:16:01','2025-11-29 09:16:01',1,598,'2c0d530a-1a10-430b-9f41-c356fc3801d6',140,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes',-1,'2025-11-30 09:16:01',NULL),('2025-11-29 09:16:01','2025-11-29 09:16:01','2025-11-29 09:16:01',1,599,'90367db3-acbd-40df-809f-d833007edbb9',144,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes___DEFAULT__',-1,'2025-11-30 09:16:01',NULL),('2025-11-29 09:16:01','2025-11-29 09:16:01','2025-11-29 09:16:01',1,600,'262cd91f-33a4-4bdf-846a-6dcde3e72869',146,'51af0a2ee11a460ab825a484e5c6f4a3','snapshots___DEFAULT__',-1,'2025-11-30 09:16:01',NULL),('2025-11-29 09:16:08','2025-11-29 09:16:08','2025-11-29 09:16:08',1,601,'99019a3b-8a9c-46e1-9e85-d89f12ea6b6d',139,'51af0a2ee11a460ab825a484e5c6f4a3','volumes',-1,'2025-11-30 09:16:08',NULL),('2025-11-29 09:16:08','2025-11-29 09:16:08','2025-11-29 09:16:08',1,602,'329258c9-cb6b-4276-aa79-5522ec395af7',140,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes',-1,'2025-11-30 09:16:08',NULL),('2025-11-29 09:16:08','2025-11-29 09:16:08','2025-11-29 09:16:08',1,603,'203164e6-f29d-4142-bf59-35c888ce5e4e',143,'51af0a2ee11a460ab825a484e5c6f4a3','volumes___DEFAULT__',-1,'2025-11-30 09:16:08',NULL),('2025-11-29 09:16:08','2025-11-29 09:16:08','2025-11-29 09:16:08',1,604,'df14d798-c6f1-42f7-9f3d-2117057fe444',144,'51af0a2ee11a460ab825a484e5c6f4a3','gigabytes___DEFAULT__',-1,'2025-11-30 09:16:08',NULL);
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2025-11-29 06:50:32','2025-11-29 09:28:08',NULL,0,1,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',939,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'cdc537ea-f2e9-4c25-8225-143a0f16b665'),('2025-11-29 07:36:51','2025-11-29 09:28:09',NULL,0,2,'cinder-backup-0','cinder-backup','cinder-backup',666,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'38fa3799-c1a4-4c46-b32b-fd97d1338eb0'),('2025-11-29 07:36:58','2025-11-29 09:28:03',NULL,0,3,'hostgroup@ceph','cinder-volume','cinder-volume',665,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
INSERT INTO `snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `status`, `progress`, `volume_size`, `scheduled_at`, `display_name`, `display_description`, `provider_location`, `encryption_key_id`, `volume_type_id`, `cgsnapshot_id`, `provider_id`, `provider_auth`, `group_snapshot_id`, `use_quota`) VALUES ('2025-11-29 09:09:15','2025-11-29 09:10:25','2025-11-29 09:10:26',1,'237d90f9-3af7-4b2e-a811-c8302a1ac7f7','87af2292-044f-4b27-b7cd-cbee4e63191c','5ff561a95dc44b9fb9f7fd8fee80f589','51af0a2ee11a460ab825a484e5c6f4a3','deleted','100%',1,NULL,'tempest-TestVolumeBootPattern-snapshot-371964411',NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,NULL,NULL,NULL,1),('2025-11-29 09:11:36','2025-11-29 09:12:57','2025-11-29 09:12:58',1,'30784891-c32c-4cd3-8120-4b3acd34934a','3367e57a-b6f9-477a-b507-12360b177bbc','5ff561a95dc44b9fb9f7fd8fee80f589','51af0a2ee11a460ab825a484e5c6f4a3','deleted','100%',1,NULL,'snapshot for tempest-TestVolumeBootPatternsnapshot-892575640',NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,NULL,NULL,NULL,1),('2025-11-29 09:15:00','2025-11-29 09:16:01','2025-11-29 09:16:01',1,'5517798e-501f-4fad-960d-c6e18fae7be5','5acb1bf0-7995-4ac2-84e2-62745b9cdce6','5ff561a95dc44b9fb9f7fd8fee80f589','51af0a2ee11a460ab825a484e5c6f4a3','deleted','100%',1,NULL,'tempest-TestVolumeBootPattern-snapshot-1331455388',NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,NULL,NULL,NULL,1),('2025-11-29 08:23:59','2025-11-29 08:24:03','2025-11-29 08:24:07',1,'606fa041-00cd-4b8d-a7d0-aec2de624884','49ec755a-0cd6-49ff-ad14-28979b5925a9','927e2238ca0c4d26830812effffe75ae','1e7450dd88894243affe67274f9cceb0','deleted','100%',1,NULL,'tempest-VolumesSnapshotsTestJSON-Snapshot-1578085434',NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,NULL,NULL,NULL,1),('2025-11-29 08:26:02','2025-11-29 08:26:29','2025-11-29 08:26:30',1,'8c76db47-2289-4011-a60d-9ede066d15e8','9a3eb32a-193c-49dc-a1e2-9c3bb4895a1a','0cbb3ac39ebd4876ad23f2a6d1c50166','f9a9decdabb1480da8f7d039e8b3d414','deleted','100%',1,NULL,'tempest-TestMinimumBasicScenario-snapshot-1372487112',NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,NULL,NULL,NULL,1),('2025-11-29 08:29:40','2025-11-29 08:29:50','2025-11-29 08:29:52',1,'92bf57c5-1776-41c3-84b4-e98f1bce6a3e','5fdf7d48-8c9e-4f5c-9e3e-276135ea4364','b4f4d28745dd46e586642c84c051db39','23450c2eaf4442459dec94c6d29f0412','deleted','100%',1,NULL,'snapshot for multiattach-snapshot',NULL,NULL,NULL,'866682fc-5086-4cb9-b799-71bc321825c2',NULL,NULL,NULL,NULL,1),('2025-11-29 08:31:00','2025-11-29 08:32:33','2025-11-29 08:32:34',1,'d7feff96-2862-4e90-a96d-90f4fdbdb766','d5b932e2-653b-46a6-9b2c-1d5019441709','d45f9a4a44664af3884c15ce0f5697e0','7e8e7407a7c44208a503e8225c1cf518','deleted','100%',1,NULL,'tempest-TestStampPattern-snapshot-1450204140',NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,NULL,NULL,NULL,1);
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
INSERT INTO `volume_attachment` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `attached_host`, `instance_uuid`, `mountpoint`, `attach_time`, `detach_time`, `attach_mode`, `attach_status`, `connection_info`, `connector`) VALUES ('2025-11-29 09:14:11','2025-11-29 09:16:05','2025-11-29 09:16:05',1,'02128a5d-2580-41d2-a022-994a8a38ebc5','5acb1bf0-7995-4ac2-84e2-62745b9cdce6','compute-0.ctlplane.example.com','ab760f9d-43e3-4bec-9987-df02dc30b9ef','/dev/vda','2025-11-29 09:14:15','2025-11-29 09:16:05','rw','detached','{\"name\": \"volumes/volume-5acb1bf0-7995-4ac2-84e2-62745b9cdce6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"5acb1bf0-7995-4ac2-84e2-62745b9cdce6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"02128a5d-2580-41d2-a022-994a8a38ebc5\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34daab51fdd\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9fe13708-3578-4487-abe9-9bea2dcb1209\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 07:48:19','2025-11-29 07:48:50','2025-11-29 07:48:50',1,'0293ab39-88ee-4fc9-98a5-4614a458bb2c','1c382493-5718-4c6c-93b8-8f2562c0a68a','compute-2.ctlplane.example.com','738ca4a4-91f6-4476-a500-4d85c8eb00ef','/dev/vda','2025-11-29 07:48:19','2025-11-29 07:48:50','null','detached','{\"name\": \"volumes/volume-1c382493-5718-4c6c-93b8-8f2562c0a68a\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"1c382493-5718-4c6c-93b8-8f2562c0a68a\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"0293ab39-88ee-4fc9-98a5-4614a458bb2c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0c9f057a05c\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"841b8909-9838-4df3-bf7c-bb9b0c2a4d0c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2025-11-29 08:06:53','2025-11-29 08:08:32','2025-11-29 08:08:32',1,'042726ed-a817-43fa-92f5-9f21f384a7e0','9a1b020a-829d-495d-928e-9016a22fe737','compute-2.ctlplane.example.com','9f70b4d6-e1a7-4709-8816-a19fb6569d7c','/dev/vdc','2025-11-29 08:07:04','2025-11-29 08:08:32','rw','detached','{\"name\": \"volumes/volume-9a1b020a-829d-495d-928e-9016a22fe737\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"9a1b020a-829d-495d-928e-9016a22fe737\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"042726ed-a817-43fa-92f5-9f21f384a7e0\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0c9f057a05c\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"841b8909-9838-4df3-bf7c-bb9b0c2a4d0c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-11-29 08:22:11','2025-11-29 08:22:17','2025-11-29 08:22:17',1,'0755f089-7b3e-4b7a-a3b7-2ae5d0750ae3','fe8a190c-eaa2-4117-ba27-c0ae9ce39d0e','compute-0.ctlplane.example.com','aa6d3201-d2d3-4001-9e68-bd07dcc23b11','/dev/vdb','2025-11-29 08:22:13','2025-11-29 08:22:17','rw','detached','{\"name\": \"volumes/volume-fe8a190c-eaa2-4117-ba27-c0ae9ce39d0e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"fe8a190c-eaa2-4117-ba27-c0ae9ce39d0e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"0755f089-7b3e-4b7a-a3b7-2ae5d0750ae3\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34daab51fdd\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9fe13708-3578-4487-abe9-9bea2dcb1209\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:13:41','2025-11-29 08:13:59','2025-11-29 08:13:59',1,'0cdc8dee-f076-425a-a988-c08db480dfc0','57626c0a-e0bf-45ee-90b0-ca7f160cc5ab','compute-0.ctlplane.example.com','d83d7773-fe1e-4ac9-b90c-74a74180acbe','/dev/vdb','2025-11-29 08:13:44','2025-11-29 08:13:59','rw','detached','{\"name\": \"volumes/volume-57626c0a-e0bf-45ee-90b0-ca7f160cc5ab\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"57626c0a-e0bf-45ee-90b0-ca7f160cc5ab\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"0cdc8dee-f076-425a-a988-c08db480dfc0\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34daab51fdd\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9fe13708-3578-4487-abe9-9bea2dcb1209\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:27:01','2025-11-29 08:28:04','2025-11-29 08:28:04',1,'0f03bc9a-d9ad-4c1d-889e-f5d227125924','ff1e082f-e768-4c5f-850b-5e8ce6b839d1','compute-2.ctlplane.example.com','78a00526-9c03-4c52-93a4-2275348b883a','/dev/vdb','2025-11-29 08:27:03','2025-11-29 08:28:04','rw','detached','{\"name\": \"volumes/volume-ff1e082f-e768-4c5f-850b-5e8ce6b839d1\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"ff1e082f-e768-4c5f-850b-5e8ce6b839d1\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"0f03bc9a-d9ad-4c1d-889e-f5d227125924\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0c9f057a05c\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"841b8909-9838-4df3-bf7c-bb9b0c2a4d0c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:06:53','2025-11-29 08:08:31','2025-11-29 08:08:31',1,'1395d964-f1da-4bec-a9a0-103e1e9e49fe','a58e04ca-51a8-451c-bfd9-cb5b176d93d9','compute-2.ctlplane.example.com','9f70b4d6-e1a7-4709-8816-a19fb6569d7c','/dev/vda','2025-11-29 08:07:00','2025-11-29 08:08:31','rw','detached','{\"name\": \"volumes/volume-a58e04ca-51a8-451c-bfd9-cb5b176d93d9\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"a58e04ca-51a8-451c-bfd9-cb5b176d93d9\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"1395d964-f1da-4bec-a9a0-103e1e9e49fe\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0c9f057a05c\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"841b8909-9838-4df3-bf7c-bb9b0c2a4d0c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:20:19','2025-11-29 08:20:56','2025-11-29 08:20:56',1,'172f1477-7658-4342-8952-216fa1d405a1','6e321817-b498-4ce5-ba72-237a6641f417','compute-1.ctlplane.example.com','837cb339-2f69-440f-b84e-6bcbd9bd81b9','/dev/vda','2025-11-29 08:20:21','2025-11-29 08:20:56','rw','detached','{\"name\": \"volumes/volume-6e321817-b498-4ce5-ba72-237a6641f417\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"6e321817-b498-4ce5-ba72-237a6641f417\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"172f1477-7658-4342-8952-216fa1d405a1\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:25:45','2025-11-29 08:25:54','2025-11-29 08:25:54',1,'1ac4d988-ef82-47a9-8e98-5d87ed245216','32b198ad-3a42-4de3-9995-b7e93d51e7ec','compute-0.ctlplane.example.com','5a603f26-2b4a-4025-8cc2-a31c8c89e652','/dev/vdb','2025-11-29 08:25:46','2025-11-29 08:25:54','rw','detached','{\"name\": \"volumes/volume-32b198ad-3a42-4de3-9995-b7e93d51e7ec\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"32b198ad-3a42-4de3-9995-b7e93d51e7ec\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"1ac4d988-ef82-47a9-8e98-5d87ed245216\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34daab51fdd\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9fe13708-3578-4487-abe9-9bea2dcb1209\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:49:44','2025-11-29 08:50:37','2025-11-29 08:50:37',1,'239afcdc-17d9-42ca-a2d9-92f2249f8377','60d0f33b-7946-4e21-ac67-19a83123d623','compute-1.ctlplane.example.com','8e875192-3bcb-45b5-b98e-ed3fcce55779','/dev/vda','2025-11-29 08:49:48','2025-11-29 08:50:37','rw','detached','{\"name\": \"volumes/volume-60d0f33b-7946-4e21-ac67-19a83123d623\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"60d0f33b-7946-4e21-ac67-19a83123d623\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"239afcdc-17d9-42ca-a2d9-92f2249f8377\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:06:53','2025-11-29 08:08:31','2025-11-29 08:08:31',1,'258684a8-57b8-4cfe-882e-0e47ea7bc6f7','919ec135-16e6-4c87-bbf5-1726533a5182','compute-2.ctlplane.example.com','9f70b4d6-e1a7-4709-8816-a19fb6569d7c','/dev/vdb','2025-11-29 08:07:02','2025-11-29 08:08:31','rw','detached','{\"name\": \"volumes/volume-919ec135-16e6-4c87-bbf5-1726533a5182\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"919ec135-16e6-4c87-bbf5-1726533a5182\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"258684a8-57b8-4cfe-882e-0e47ea7bc6f7\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0c9f057a05c\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"841b8909-9838-4df3-bf7c-bb9b0c2a4d0c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:37:02','2025-11-29 08:37:12','2025-11-29 08:37:12',1,'277dba60-c316-4d1d-8959-92dc5d0dcc4b','c7b25c31-f722-44d5-bbae-250821bb79df','compute-1.ctlplane.example.com','474b1011-d98c-4f65-b0c1-a27fa5964442','/dev/vdb','2025-11-29 08:37:03','2025-11-29 08:37:12','rw','detached','{\"name\": \"volumes/volume-c7b25c31-f722-44d5-bbae-250821bb79df\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"c7b25c31-f722-44d5-bbae-250821bb79df\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": true, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"277dba60-c316-4d1d-8959-92dc5d0dcc4b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:03:26','2025-11-29 08:05:03','2025-11-29 08:05:03',1,'32f80b3c-4f6a-4b33-bd61-accbf9121901','f07a118d-ea67-4113-8ddf-ed6afb5e3f24','compute-2.ctlplane.example.com','bb4e9fda-828d-4b2f-84a9-4fbbcb213650','/dev/vdc','2025-11-29 08:03:37','2025-11-29 08:05:03','rw','detached','{\"name\": \"volumes/volume-f07a118d-ea67-4113-8ddf-ed6afb5e3f24\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"f07a118d-ea67-4113-8ddf-ed6afb5e3f24\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"32f80b3c-4f6a-4b33-bd61-accbf9121901\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0c9f057a05c\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"841b8909-9838-4df3-bf7c-bb9b0c2a4d0c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-11-29 07:59:38','2025-11-29 08:00:16','2025-11-29 08:00:16',1,'344269a2-a2ff-4225-a493-789452434f2f','46608b98-4ab9-406c-9f99-bd236172e09a','compute-2.ctlplane.example.com','311dcf4c-2f7d-4167-89b8-38b38bc69a97','/dev/vda','2025-11-29 07:59:42','2025-11-29 08:00:16','rw','detached','{\"name\": \"volumes/volume-46608b98-4ab9-406c-9f99-bd236172e09a\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"46608b98-4ab9-406c-9f99-bd236172e09a\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"344269a2-a2ff-4225-a493-789452434f2f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0c9f057a05c\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"841b8909-9838-4df3-bf7c-bb9b0c2a4d0c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:29:07','2025-11-29 08:29:45','2025-11-29 08:29:45',1,'35525a09-f03f-43df-9c47-0609f1b58f18','e7fdb130-fae5-40cb-aa10-2d9145713cd5','compute-2.ctlplane.example.com','8d30dc23-4d84-4468-94cd-9f1300767585','/dev/vdb','2025-11-29 08:29:10','2025-11-29 08:29:45','rw','detached','{\"name\": \"volumes/volume-e7fdb130-fae5-40cb-aa10-2d9145713cd5\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"e7fdb130-fae5-40cb-aa10-2d9145713cd5\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"35525a09-f03f-43df-9c47-0609f1b58f18\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0c9f057a05c\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"841b8909-9838-4df3-bf7c-bb9b0c2a4d0c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:03:17','2025-11-29 08:03:23','2025-11-29 08:03:23',1,'3593a64a-a8f2-4d16-88e3-af3f4e7e2f68','1b84d2e0-dc4b-4e9d-96ef-b4698ba76935','compute-2.ctlplane.example.com','cbe783cf-d541-40ff-855f-81dee6d75a4f','/dev/vdb','2025-11-29 08:03:18','2025-11-29 08:03:23','rw','detached','{\"name\": \"volumes/volume-1b84d2e0-dc4b-4e9d-96ef-b4698ba76935\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"1b84d2e0-dc4b-4e9d-96ef-b4698ba76935\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"3593a64a-a8f2-4d16-88e3-af3f4e7e2f68\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0c9f057a05c\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"841b8909-9838-4df3-bf7c-bb9b0c2a4d0c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 07:48:42','2025-11-29 07:49:04','2025-11-29 07:49:04',1,'3abe7743-3c7c-4ad9-816c-7e5eceb82caf','1c382493-5718-4c6c-93b8-8f2562c0a68a','compute-0.ctlplane.example.com','738ca4a4-91f6-4476-a500-4d85c8eb00ef','/dev/vda','2025-11-29 07:48:43','2025-11-29 07:49:04','null','detached','{\"name\": \"volumes/volume-1c382493-5718-4c6c-93b8-8f2562c0a68a\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"1c382493-5718-4c6c-93b8-8f2562c0a68a\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"3abe7743-3c7c-4ad9-816c-7e5eceb82caf\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34daab51fdd\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9fe13708-3578-4487-abe9-9bea2dcb1209\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2025-11-29 09:10:53','2025-11-29 09:13:03','2025-11-29 09:13:03',1,'409b1012-f240-4088-ba56-c6946fd65938','3367e57a-b6f9-477a-b507-12360b177bbc','compute-0.ctlplane.example.com','98f7fc6b-a484-4f84-87e3-5cc3f25bb7c1','/dev/vda','2025-11-29 09:11:01','2025-11-29 09:13:03','rw','detached','{\"name\": \"volumes/volume-3367e57a-b6f9-477a-b507-12360b177bbc\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"3367e57a-b6f9-477a-b507-12360b177bbc\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"409b1012-f240-4088-ba56-c6946fd65938\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34daab51fdd\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9fe13708-3578-4487-abe9-9bea2dcb1209\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:03:26','2025-11-29 08:05:02','2025-11-29 08:05:02',1,'56865f30-877a-4878-a3a9-ca202c8b2d30','9f626c2c-bb56-4532-9935-1e7b39440d48','compute-2.ctlplane.example.com','bb4e9fda-828d-4b2f-84a9-4fbbcb213650','/dev/vda','2025-11-29 08:03:34','2025-11-29 08:05:02','rw','detached','{\"name\": \"volumes/volume-9f626c2c-bb56-4532-9935-1e7b39440d48\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"9f626c2c-bb56-4532-9935-1e7b39440d48\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"56865f30-877a-4878-a3a9-ca202c8b2d30\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0c9f057a05c\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"841b8909-9838-4df3-bf7c-bb9b0c2a4d0c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:20:04','2025-11-29 08:21:08','2025-11-29 08:21:08',1,'581f7330-fa73-443c-a7f3-7acb3a0698ab','ca617c97-cbed-42b4-9b83-01f6fe990ce2','compute-2.ctlplane.example.com','e1e8c40f-128e-4265-b740-9f793af39b26','/dev/vdb','2025-11-29 08:20:05','2025-11-29 08:21:08','rw','detached','{\"name\": \"volumes/volume-ca617c97-cbed-42b4-9b83-01f6fe990ce2\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"ca617c97-cbed-42b4-9b83-01f6fe990ce2\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"581f7330-fa73-443c-a7f3-7acb3a0698ab\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0c9f057a05c\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"841b8909-9838-4df3-bf7c-bb9b0c2a4d0c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 07:52:41','2025-11-29 07:52:59','2025-11-29 07:52:59',1,'5d2b81a1-650e-4df0-afd0-7a066480ade2','4a9f4928-146a-4c56-bbea-7dd9c7945b0c','compute-2.ctlplane.example.com','bae55d85-4263-4efe-895d-a762627b52ff','/dev/vda','2025-11-29 07:52:42','2025-11-29 07:52:59','null','detached','{\"name\": \"volumes/volume-4a9f4928-146a-4c56-bbea-7dd9c7945b0c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"4a9f4928-146a-4c56-bbea-7dd9c7945b0c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"5d2b81a1-650e-4df0-afd0-7a066480ade2\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0c9f057a05c\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"841b8909-9838-4df3-bf7c-bb9b0c2a4d0c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2025-11-29 08:28:38','2025-11-29 08:31:36','2025-11-29 08:31:36',1,'5e8c22c1-482f-464f-8b5d-9067afb4b6a5','2d68fb40-6374-433d-8236-b50acd6ca7f0','compute-2.ctlplane.example.com','8d30dc23-4d84-4468-94cd-9f1300767585','/dev/vda','2025-11-29 08:28:43','2025-11-29 08:31:36','rw','detached','{\"name\": \"volumes/volume-2d68fb40-6374-433d-8236-b50acd6ca7f0\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"2d68fb40-6374-433d-8236-b50acd6ca7f0\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"5e8c22c1-482f-464f-8b5d-9067afb4b6a5\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0c9f057a05c\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"841b8909-9838-4df3-bf7c-bb9b0c2a4d0c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:32:10','2025-11-29 08:32:17','2025-11-29 08:32:17',1,'5f58bd24-32fa-485e-9f3a-580b2e710da0','0176de29-c1f1-41e7-8476-91ff0e6c70a5','compute-0.ctlplane.example.com','9a93f858-81bf-4fad-bdc5-df74e4bb0c75','/dev/vdb','2025-11-29 08:32:12','2025-11-29 08:32:17','rw','detached','{\"name\": \"volumes/volume-0176de29-c1f1-41e7-8476-91ff0e6c70a5\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"0176de29-c1f1-41e7-8476-91ff0e6c70a5\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"5f58bd24-32fa-485e-9f3a-580b2e710da0\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34daab51fdd\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9fe13708-3578-4487-abe9-9bea2dcb1209\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:31:44','2025-11-29 08:32:41','2025-11-29 08:32:41',1,'5f84cb9a-07e0-4365-ac0c-cc6b4bd3e717','40fdec3a-4544-45a5-9bce-a1d84a8f5b1b','compute-2.ctlplane.example.com','4d6c236c-ba8a-44dc-8413-3d4bfc16ec56','/dev/vdc','2025-11-29 08:31:59','2025-11-29 08:32:41','rw','detached','{\"name\": \"volumes/volume-40fdec3a-4544-45a5-9bce-a1d84a8f5b1b\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"40fdec3a-4544-45a5-9bce-a1d84a8f5b1b\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"5f84cb9a-07e0-4365-ac0c-cc6b4bd3e717\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0c9f057a05c\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"841b8909-9838-4df3-bf7c-bb9b0c2a4d0c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-11-29 08:08:15','2025-11-29 08:08:20','2025-11-29 08:08:20',1,'622644a8-9365-4e62-b9e4-af2519635d95','b58f9fa1-0337-49a9-a381-b6da4150ee36','compute-1.ctlplane.example.com','14addc5e-27d3-46d3-a93f-b22b3f400873','/dev/vdb','2025-11-29 08:08:17','2025-11-29 08:08:20','rw','detached','{\"name\": \"volumes/volume-b58f9fa1-0337-49a9-a381-b6da4150ee36\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"b58f9fa1-0337-49a9-a381-b6da4150ee36\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"622644a8-9365-4e62-b9e4-af2519635d95\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:14:25','2025-11-29 08:14:41','2025-11-29 08:14:41',1,'626278eb-5fb9-4f71-963a-03aa253eabf0','e19fd9ae-371b-4152-b2b2-910bd950e653','compute-1.ctlplane.example.com','48a6ffaa-4f03-4048-bd19-c50aea2863cc','/dev/vdb','2025-11-29 08:14:30','2025-11-29 08:14:41','rw','detached','{\"name\": \"volumes/volume-e19fd9ae-371b-4152-b2b2-910bd950e653\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"e19fd9ae-371b-4152-b2b2-910bd950e653\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"626278eb-5fb9-4f71-963a-03aa253eabf0\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 09:15:06','2025-11-29 09:15:58','2025-11-29 09:15:58',1,'6c597563-06b9-465f-ad56-234cf0bf3a56','5a123e28-261c-472c-adab-73c89e0d557e','compute-2.ctlplane.example.com','994f08a3-185a-4f37-a457-a99f66bba646','/dev/vda','2025-11-29 09:15:12','2025-11-29 09:15:58','rw','detached','{\"name\": \"volumes/volume-5a123e28-261c-472c-adab-73c89e0d557e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"5a123e28-261c-472c-adab-73c89e0d557e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"6c597563-06b9-465f-ad56-234cf0bf3a56\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0c9f057a05c\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"841b8909-9838-4df3-bf7c-bb9b0c2a4d0c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:13:31','2025-11-29 08:13:42','2025-11-29 08:13:42',1,'6efb8ee1-9436-4e6f-9f72-23f6b5832f83','57626c0a-e0bf-45ee-90b0-ca7f160cc5ab','compute-0.ctlplane.example.com','d83d7773-fe1e-4ac9-b90c-74a74180acbe','/dev/vdb','2025-11-29 08:13:32','2025-11-29 08:13:42','rw','detached','{\"name\": \"volumes/volume-57626c0a-e0bf-45ee-90b0-ca7f160cc5ab\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"57626c0a-e0bf-45ee-90b0-ca7f160cc5ab\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"6efb8ee1-9436-4e6f-9f72-23f6b5832f83\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34daab51fdd\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9fe13708-3578-4487-abe9-9bea2dcb1209\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:28:41','2025-11-29 08:31:27','2025-11-29 08:31:27',1,'78dc1b6b-1941-4dff-8ea0-d8c64bc50d26','cedd0225-5008-4e7b-a363-38f002cf49fe','compute-0.ctlplane.example.com','e412f1ba-217f-4c10-b176-528b2ef6ed0e','/dev/vda','2025-11-29 08:28:45','2025-11-29 08:31:27','rw','detached','{\"name\": \"volumes/volume-cedd0225-5008-4e7b-a363-38f002cf49fe\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"cedd0225-5008-4e7b-a363-38f002cf49fe\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"78dc1b6b-1941-4dff-8ea0-d8c64bc50d26\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34daab51fdd\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9fe13708-3578-4487-abe9-9bea2dcb1209\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:30:27','2025-11-29 08:30:49','2025-11-29 08:30:49',1,'7990cef2-1b71-4efc-81a0-f7ba345cacb8','1c425827-5356-476a-a66c-a9193ddaa105','compute-1.ctlplane.example.com','ef2296eb-4538-4e04-8c0b-42370d9e5b12','/dev/vdb','2025-11-29 08:30:29','2025-11-29 08:30:49','rw','detached','{\"name\": \"volumes/volume-1c425827-5356-476a-a66c-a9193ddaa105\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"1c425827-5356-476a-a66c-a9193ddaa105\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"7990cef2-1b71-4efc-81a0-f7ba345cacb8\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 09:13:34','2025-11-29 09:14:07','2025-11-29 09:14:07',1,'7d4168cd-a49d-4fc0-b0d0-6a6d60954648','5acb1bf0-7995-4ac2-84e2-62745b9cdce6','compute-1.ctlplane.example.com','0d2ca216-c02c-4a51-9997-85652cee8fe5','/dev/vda','2025-11-29 09:13:39','2025-11-29 09:14:07','rw','detached','{\"name\": \"volumes/volume-5acb1bf0-7995-4ac2-84e2-62745b9cdce6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"5acb1bf0-7995-4ac2-84e2-62745b9cdce6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"7d4168cd-a49d-4fc0-b0d0-6a6d60954648\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:15:18','2025-11-29 08:15:54','2025-11-29 08:15:54',1,'7fe3516b-e843-4c3e-9990-524cf03c1787','ad74cad8-db25-41c6-a50a-ce4cad08c1ea','compute-1.ctlplane.example.com','bba0127d-6332-44fa-8fc1-c3d7321260fa','/dev/vda','2025-11-29 08:15:22','2025-11-29 08:15:54','rw','detached','{\"name\": \"volumes/volume-ad74cad8-db25-41c6-a50a-ce4cad08c1ea\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"ad74cad8-db25-41c6-a50a-ce4cad08c1ea\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"7fe3516b-e843-4c3e-9990-524cf03c1787\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:12:03','2025-11-29 08:12:59','2025-11-29 08:12:59',1,'81c4d29b-4c3b-43d9-b95f-1ef480e9bdc7','c5655890-57a1-4371-8ce4-c9179f1c49bb','compute-1.ctlplane.example.com','5575532e-65f8-4b29-bab0-a0f8e60d032c','/dev/vda','2025-11-29 08:12:16','2025-11-29 08:12:59','rw','detached','{\"name\": \"volumes/volume-c5655890-57a1-4371-8ce4-c9179f1c49bb\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"c5655890-57a1-4371-8ce4-c9179f1c49bb\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"81c4d29b-4c3b-43d9-b95f-1ef480e9bdc7\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:27:20','2025-11-29 08:28:40','2025-11-29 08:28:40',1,'8381dd59-919d-420e-91e1-715e31b5424c','ff1e082f-e768-4c5f-850b-5e8ce6b839d1','compute-0.ctlplane.example.com','554ea6a4-8de1-41bf-8772-b15e95a7fd05','/dev/vdb','2025-11-29 08:27:26','2025-11-29 08:28:40','rw','detached','{\"name\": \"volumes/volume-ff1e082f-e768-4c5f-850b-5e8ce6b839d1\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"ff1e082f-e768-4c5f-850b-5e8ce6b839d1\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"8381dd59-919d-420e-91e1-715e31b5424c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34daab51fdd\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9fe13708-3578-4487-abe9-9bea2dcb1209\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:25:48','2025-11-29 08:25:56','2025-11-29 08:25:56',1,'843f3731-2267-4517-b4a5-9d21bf265b1a','32b198ad-3a42-4de3-9995-b7e93d51e7ec','compute-0.ctlplane.example.com','df3ef43d-e67b-4d7f-8603-5cf61569ae1f','/dev/vdb','2025-11-29 08:25:50','2025-11-29 08:25:56','rw','detached','{\"name\": \"volumes/volume-32b198ad-3a42-4de3-9995-b7e93d51e7ec\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"32b198ad-3a42-4de3-9995-b7e93d51e7ec\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"843f3731-2267-4517-b4a5-9d21bf265b1a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34daab51fdd\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9fe13708-3578-4487-abe9-9bea2dcb1209\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:29:58','2025-11-29 08:30:15','2025-11-29 08:30:15',1,'855aa72f-32e8-47ca-ba06-7cf6d25d0d65','ab4cd0c8-adcb-470a-9b1a-e227da2d6280','compute-0.ctlplane.example.com','e412f1ba-217f-4c10-b176-528b2ef6ed0e','/dev/vdb','2025-11-29 08:29:59','2025-11-29 08:30:15','rw','detached','{\"name\": \"volumes/volume-ab4cd0c8-adcb-470a-9b1a-e227da2d6280\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"ab4cd0c8-adcb-470a-9b1a-e227da2d6280\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"855aa72f-32e8-47ca-ba06-7cf6d25d0d65\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34daab51fdd\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9fe13708-3578-4487-abe9-9bea2dcb1209\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:14:08','2025-11-29 08:14:25','2025-11-29 08:14:25',1,'85e84f2c-4d27-447a-9dfd-b50a30a9ab25','e19fd9ae-371b-4152-b2b2-910bd950e653','compute-0.ctlplane.example.com','48a6ffaa-4f03-4048-bd19-c50aea2863cc','/dev/vdb','2025-11-29 08:14:14','2025-11-29 08:14:25','rw','detached','{\"name\": \"volumes/volume-e19fd9ae-371b-4152-b2b2-910bd950e653\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"e19fd9ae-371b-4152-b2b2-910bd950e653\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"85e84f2c-4d27-447a-9dfd-b50a30a9ab25\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34daab51fdd\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9fe13708-3578-4487-abe9-9bea2dcb1209\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:32:09','2025-11-29 08:32:18','2025-11-29 08:32:18',1,'86294c41-53ca-46a2-b51c-d94e019aa3ed','8a0ffcae-e95b-4559-b222-b006f2a6a46d','compute-1.ctlplane.example.com','b4b22d90-9381-462a-bb31-7c87d8627c3b','/dev/vdc','2025-11-29 08:32:11','2025-11-29 08:32:18','rw','detached','{\"name\": \"volumes/volume-8a0ffcae-e95b-4559-b222-b006f2a6a46d\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"8a0ffcae-e95b-4559-b222-b006f2a6a46d\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"86294c41-53ca-46a2-b51c-d94e019aa3ed\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-11-29 08:28:05','2025-11-29 08:29:23','2025-11-29 08:29:23',1,'91f9fa53-1d75-4b68-a91b-2c4afb5002fb','d82be9cd-deee-4312-bbbb-bb9d0726ae5c','compute-2.ctlplane.example.com','21fbf4d2-7068-4308-a3fc-70637e7f52b7','/dev/vdb','2025-11-29 08:28:06','2025-11-29 08:29:23','rw','detached','{\"name\": \"volumes/volume-d82be9cd-deee-4312-bbbb-bb9d0726ae5c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"d82be9cd-deee-4312-bbbb-bb9d0726ae5c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"91f9fa53-1d75-4b68-a91b-2c4afb5002fb\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0c9f057a05c\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"841b8909-9838-4df3-bf7c-bb9b0c2a4d0c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:30:01','2025-11-29 08:30:18','2025-11-29 08:30:18',1,'955e5743-c138-41ae-9be8-124a391ca9f3','882d54a9-fd7e-41ac-9421-07a1ee6da4e8','compute-0.ctlplane.example.com','e412f1ba-217f-4c10-b176-528b2ef6ed0e','/dev/vdc','2025-11-29 08:30:02','2025-11-29 08:30:18','rw','detached','{\"name\": \"volumes/volume-882d54a9-fd7e-41ac-9421-07a1ee6da4e8\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"882d54a9-fd7e-41ac-9421-07a1ee6da4e8\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"955e5743-c138-41ae-9be8-124a391ca9f3\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34daab51fdd\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9fe13708-3578-4487-abe9-9bea2dcb1209\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-11-29 08:28:44','2025-11-29 08:31:15','2025-11-29 08:31:15',1,'9b787483-1583-4e61-9695-239723e19162','32bcf381-1196-418b-a68f-b868a3c26635','compute-1.ctlplane.example.com','ef2296eb-4538-4e04-8c0b-42370d9e5b12','/dev/vda','2025-11-29 08:28:53','2025-11-29 08:31:15','rw','detached','{\"name\": \"volumes/volume-32bcf381-1196-418b-a68f-b868a3c26635\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"32bcf381-1196-418b-a68f-b868a3c26635\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"9b787483-1583-4e61-9695-239723e19162\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:26:56','2025-11-29 08:27:20','2025-11-29 08:27:20',1,'9f8b0e94-930f-4b62-b242-de18df49f4d7','ff1e082f-e768-4c5f-850b-5e8ce6b839d1','compute-1.ctlplane.example.com','554ea6a4-8de1-41bf-8772-b15e95a7fd05','/dev/vdb','2025-11-29 08:26:58','2025-11-29 08:27:20','rw','detached','{\"name\": \"volumes/volume-ff1e082f-e768-4c5f-850b-5e8ce6b839d1\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"ff1e082f-e768-4c5f-850b-5e8ce6b839d1\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"9f8b0e94-930f-4b62-b242-de18df49f4d7\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:13:52','2025-11-29 08:14:08','2025-11-29 08:14:08',1,'a84ca83b-facb-4a2c-8046-34d303905b5e','e19fd9ae-371b-4152-b2b2-910bd950e653','compute-1.ctlplane.example.com','48a6ffaa-4f03-4048-bd19-c50aea2863cc','/dev/vdb','2025-11-29 08:13:53','2025-11-29 08:14:08','rw','detached','{\"name\": \"volumes/volume-e19fd9ae-371b-4152-b2b2-910bd950e653\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"e19fd9ae-371b-4152-b2b2-910bd950e653\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"a84ca83b-facb-4a2c-8046-34d303905b5e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:24:16','2025-11-29 08:30:15','2025-11-29 08:30:15',1,'ab08dc2a-c6fd-45ce-9480-8e15d0112313','a9f0bfef-3469-4919-82f4-bea2fb541eb3','compute-2.ctlplane.example.com','5d2af1c0-e1ed-48f9-beda-42cc37212de7','/dev/vda','2025-11-29 08:24:21','2025-11-29 08:30:15','rw','detached','{\"name\": \"volumes/volume-a9f0bfef-3469-4919-82f4-bea2fb541eb3\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"a9f0bfef-3469-4919-82f4-bea2fb541eb3\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"ab08dc2a-c6fd-45ce-9480-8e15d0112313\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0c9f057a05c\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"841b8909-9838-4df3-bf7c-bb9b0c2a4d0c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:29:17','2025-11-29 08:29:48','2025-11-29 08:29:48',1,'abe74d4b-45fe-467e-87cb-a4e0f8dc4dba','5fdf7d48-8c9e-4f5c-9e3e-276135ea4364','compute-1.ctlplane.example.com','841820bc-c4f3-4198-b22c-ddd672e9cc75','/dev/vda','2025-11-29 08:29:27','2025-11-29 08:29:48','rw','detached','{\"name\": \"volumes/volume-5fdf7d48-8c9e-4f5c-9e3e-276135ea4364\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"5fdf7d48-8c9e-4f5c-9e3e-276135ea4364\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"abe74d4b-45fe-467e-87cb-a4e0f8dc4dba\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:26:34','2025-11-29 08:27:28','2025-11-29 08:27:28',1,'b0077d42-4966-4605-bded-14c59e62917c','e575575a-0c17-43ef-9168-0fa9b5177df6','compute-2.ctlplane.example.com','c1118af2-2266-48e4-a246-9549c68ddaa4','/dev/vdb','2025-11-29 08:26:36','2025-11-29 08:27:28','rw','detached','{\"name\": \"volumes/volume-e575575a-0c17-43ef-9168-0fa9b5177df6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"e575575a-0c17-43ef-9168-0fa9b5177df6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b0077d42-4966-4605-bded-14c59e62917c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0c9f057a05c\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"841b8909-9838-4df3-bf7c-bb9b0c2a4d0c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:28:03','2025-11-29 08:28:42','2025-11-29 08:28:42',1,'b110837f-deba-41df-98b1-10fc2923f088','ff1e082f-e768-4c5f-850b-5e8ce6b839d1','compute-0.ctlplane.example.com','78a00526-9c03-4c52-93a4-2275348b883a','/dev/vdb','2025-11-29 08:28:08','2025-11-29 08:28:42','rw','detached','{\"name\": \"volumes/volume-ff1e082f-e768-4c5f-850b-5e8ce6b839d1\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"ff1e082f-e768-4c5f-850b-5e8ce6b839d1\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b110837f-deba-41df-98b1-10fc2923f088\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34daab51fdd\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9fe13708-3578-4487-abe9-9bea2dcb1209\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 07:51:13','2025-11-29 07:52:09','2025-11-29 07:52:09',1,'b199b9a2-3ce8-4c17-bca4-a1228e4d21e5','4a9f4928-146a-4c56-bbea-7dd9c7945b0c','compute-2.ctlplane.example.com','bae55d85-4263-4efe-895d-a762627b52ff','/dev/vda','2025-11-29 07:51:27','2025-11-29 07:52:09','rw','detached','{\"name\": \"volumes/volume-4a9f4928-146a-4c56-bbea-7dd9c7945b0c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"4a9f4928-146a-4c56-bbea-7dd9c7945b0c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b199b9a2-3ce8-4c17-bca4-a1228e4d21e5\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0c9f057a05c\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"841b8909-9838-4df3-bf7c-bb9b0c2a4d0c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:25:59','2025-11-29 08:27:25','2025-11-29 08:27:25',1,'b1ae05d8-ccb0-4b94-ac08-8333b1650f3f','9a3eb32a-193c-49dc-a1e2-9c3bb4895a1a','compute-1.ctlplane.example.com','b86b46f9-7d8f-414f-af87-3822510de392','/dev/vdb','2025-11-29 08:26:01','2025-11-29 08:27:25','rw','detached','{\"name\": \"volumes/volume-9a3eb32a-193c-49dc-a1e2-9c3bb4895a1a\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"9a3eb32a-193c-49dc-a1e2-9c3bb4895a1a\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b1ae05d8-ccb0-4b94-ac08-8333b1650f3f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:23:06','2025-11-29 08:23:10','2025-11-29 08:23:10',1,'b1e5438b-2408-4c69-b06b-5edd5f6c8ff6','e2fd498b-baaf-4a87-aa0b-3132c2eb32db','compute-0.ctlplane.example.com','c6849280-963f-4661-bac1-c3655d2dad57','/dev/vdb','2025-11-29 08:23:07','2025-11-29 08:23:10','rw','detached','{\"name\": \"volumes/volume-e2fd498b-baaf-4a87-aa0b-3132c2eb32db\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"e2fd498b-baaf-4a87-aa0b-3132c2eb32db\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b1e5438b-2408-4c69-b06b-5edd5f6c8ff6\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34daab51fdd\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9fe13708-3578-4487-abe9-9bea2dcb1209\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 09:07:28','2025-11-29 09:07:59','2025-11-29 09:07:59',1,'b2e14335-0515-425b-923e-a26445434c69','f02bbf94-8afe-4780-9c81-24b2a1512122','compute-0.ctlplane.example.com','15d81344-77fd-48da-8fd6-97b50ae519d8','/dev/vda','2025-11-29 09:07:35','2025-11-29 09:07:59','rw','detached','{\"name\": \"volumes/volume-f02bbf94-8afe-4780-9c81-24b2a1512122\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"f02bbf94-8afe-4780-9c81-24b2a1512122\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": true, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b2e14335-0515-425b-923e-a26445434c69\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34daab51fdd\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9fe13708-3578-4487-abe9-9bea2dcb1209\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:49:05','2025-11-29 08:49:44','2025-11-29 08:49:44',1,'b8cebea3-9148-49b3-8497-14fe79dc1eb6','60d0f33b-7946-4e21-ac67-19a83123d623','compute-0.ctlplane.example.com','8e875192-3bcb-45b5-b98e-ed3fcce55779','/dev/vda','2025-11-29 08:49:09','2025-11-29 08:49:44','rw','detached','{\"name\": \"volumes/volume-60d0f33b-7946-4e21-ac67-19a83123d623\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"60d0f33b-7946-4e21-ac67-19a83123d623\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b8cebea3-9148-49b3-8497-14fe79dc1eb6\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34daab51fdd\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9fe13708-3578-4487-abe9-9bea2dcb1209\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:03:26','2025-11-29 08:05:02','2025-11-29 08:05:02',1,'bc3d1f07-343f-4d19-bcf1-6f0f0bad5e87','905030d9-8042-49ed-9c6d-0283f1caf956','compute-2.ctlplane.example.com','bb4e9fda-828d-4b2f-84a9-4fbbcb213650','/dev/vdb','2025-11-29 08:03:35','2025-11-29 08:05:02','rw','detached','{\"name\": \"volumes/volume-905030d9-8042-49ed-9c6d-0283f1caf956\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"905030d9-8042-49ed-9c6d-0283f1caf956\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"bc3d1f07-343f-4d19-bcf1-6f0f0bad5e87\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0c9f057a05c\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"841b8909-9838-4df3-bf7c-bb9b0c2a4d0c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:29:09','2025-11-29 08:30:06','2025-11-29 08:30:06',1,'c0fa40c4-7c54-4de4-bf87-07d04de2570d','bd7644b6-0d0f-4a70-962b-b60c03d49643','compute-1.ctlplane.example.com','bf4c2292-18d7-4c4b-b97e-abb227923156','/dev/vdb','2025-11-29 08:29:11','2025-11-29 08:30:06','rw','detached','{\"name\": \"volumes/volume-bd7644b6-0d0f-4a70-962b-b60c03d49643\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"bd7644b6-0d0f-4a70-962b-b60c03d49643\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"c0fa40c4-7c54-4de4-bf87-07d04de2570d\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:21:41','2025-11-29 08:22:45','2025-11-29 08:22:45',1,'c29d86c2-8342-4189-a462-03b5e805cff6','5a96f9f0-c824-49b0-8c65-4dfade22f1c1','compute-1.ctlplane.example.com','63dba7cc-b3af-4fb3-bbe8-58d5a087af19','/dev/vdb','2025-11-29 08:21:42','2025-11-29 08:22:45','rw','detached','{\"name\": \"volumes/volume-5a96f9f0-c824-49b0-8c65-4dfade22f1c1\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"5a96f9f0-c824-49b0-8c65-4dfade22f1c1\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"c29d86c2-8342-4189-a462-03b5e805cff6\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:34:03','2025-11-29 08:34:04','2025-11-29 08:34:04',1,'c6ffe74f-8eda-4905-82db-589e88f18f40','05c725df-70ef-4bba-b7e1-f4c2c8652991',NULL,'f7256761-4dda-41d4-bd20-f34c7a8478ef',NULL,NULL,'2025-11-29 08:34:04','null','detached','{}',NULL),('2025-11-29 07:53:42','2025-11-29 07:53:48','2025-11-29 07:53:48',1,'cbda0dce-a2e1-4c0f-b024-7e17a581c64e','a6563453-509a-48d9-9889-41f32f7b7ce4','compute-0.ctlplane.example.com','17cfda51-18c0-426a-93a5-45208fdb5da2','/dev/vdb','2025-11-29 07:53:43','2025-11-29 07:53:48','rw','detached','{\"name\": \"volumes/volume-a6563453-509a-48d9-9889-41f32f7b7ce4\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"a6563453-509a-48d9-9889-41f32f7b7ce4\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"cbda0dce-a2e1-4c0f-b024-7e17a581c64e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34daab51fdd\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9fe13708-3578-4487-abe9-9bea2dcb1209\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:18:10','2025-11-29 08:21:10','2025-11-29 08:21:10',1,'cf6ba8d8-b1d6-4916-b30a-2c4b2c8f4ac1','5d21b16e-ab30-4101-bf21-01197c71cf99','compute-2.ctlplane.example.com','6c463a92-8698-4035-b4d0-b1d3db01a43b','/dev/vda','2025-11-29 08:18:11','2025-11-29 08:21:10','rw','detached','{\"name\": \"volumes/volume-5d21b16e-ab30-4101-bf21-01197c71cf99\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"5d21b16e-ab30-4101-bf21-01197c71cf99\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"cf6ba8d8-b1d6-4916-b30a-2c4b2c8f4ac1\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0c9f057a05c\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"841b8909-9838-4df3-bf7c-bb9b0c2a4d0c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:31:54','2025-11-29 08:32:15','2025-11-29 08:32:15',1,'d3a3c51b-829b-4ba0-ac37-21086c77f8ca','d568fd4b-b177-4a6f-a3fc-768d9d38f999','compute-1.ctlplane.example.com','b4b22d90-9381-462a-bb31-7c87d8627c3b','/dev/vdb','2025-11-29 08:32:01','2025-11-29 08:32:15','rw','detached','{\"name\": \"volumes/volume-d568fd4b-b177-4a6f-a3fc-768d9d38f999\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"d568fd4b-b177-4a6f-a3fc-768d9d38f999\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"d3a3c51b-829b-4ba0-ac37-21086c77f8ca\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 09:11:55','2025-11-29 09:12:56','2025-11-29 09:12:56',1,'dd9f2485-806a-4942-a348-1d7f2440bec1','74e740e5-5b5d-4c86-ad39-4e66e4082491','compute-1.ctlplane.example.com','06bed67f-1db5-4ea4-ad30-c92a6ac6d9c9','/dev/vda','2025-11-29 09:11:59','2025-11-29 09:12:56','rw','detached','{\"name\": \"volumes/volume-74e740e5-5b5d-4c86-ad39-4e66e4082491\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"74e740e5-5b5d-4c86-ad39-4e66e4082491\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"dd9f2485-806a-4942-a348-1d7f2440bec1\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:29:14','2025-11-29 08:29:52','2025-11-29 08:29:52',1,'e31be471-29a0-458d-a6b0-cbbc8cc7e47c','cf5c779b-adfb-4e81-aa81-44b14dc653ca','compute-2.ctlplane.example.com','8d30dc23-4d84-4468-94cd-9f1300767585','/dev/vdc','2025-11-29 08:29:21','2025-11-29 08:29:52','rw','detached','{\"name\": \"volumes/volume-cf5c779b-adfb-4e81-aa81-44b14dc653ca\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"cf5c779b-adfb-4e81-aa81-44b14dc653ca\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e31be471-29a0-458d-a6b0-cbbc8cc7e47c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0c9f057a05c\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"841b8909-9838-4df3-bf7c-bb9b0c2a4d0c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-11-29 08:33:59','2025-11-29 08:34:40','2025-11-29 08:34:40',1,'e38d3b87-65f2-4aa4-af13-d30b22c19194','f3c8b389-36e8-459a-b7d9-3ed0e65767ad','compute-0.ctlplane.example.com','6ba3ce9b-c4ad-471a-bba5-1755f9a9babd','/dev/vda','2025-11-29 08:34:02','2025-11-29 08:34:40','rw','detached','{\"name\": \"volumes/volume-f3c8b389-36e8-459a-b7d9-3ed0e65767ad\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"f3c8b389-36e8-459a-b7d9-3ed0e65767ad\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e38d3b87-65f2-4aa4-af13-d30b22c19194\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34daab51fdd\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9fe13708-3578-4487-abe9-9bea2dcb1209\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 07:44:18','2025-11-29 07:44:27','2025-11-29 07:44:27',1,'e54f4576-f0c3-43f6-97dd-4d95fdad8851','d78e902f-7aa0-49b0-b066-e2f250c5b234','compute-1.ctlplane.example.com','980ff2fe-9165-4009-82a9-3c3b2055f29a','/dev/vdb','2025-11-29 07:44:21','2025-11-29 07:44:27','rw','detached','{\"name\": \"volumes/volume-d78e902f-7aa0-49b0-b066-e2f250c5b234\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"d78e902f-7aa0-49b0-b066-e2f250c5b234\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e54f4576-f0c3-43f6-97dd-4d95fdad8851\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 07:50:32','2025-11-29 07:50:39','2025-11-29 07:50:39',1,'e78f34e7-94c4-464f-888d-fd7bd7eb66a4','3466633d-ae13-4d07-b35e-af08eaa91384','compute-2.ctlplane.example.com','8dccacdf-63b1-4789-b72a-763e95713f24','/dev/vdb','2025-11-29 07:50:33','2025-11-29 07:50:39','rw','detached','{\"name\": \"volumes/volume-3466633d-ae13-4d07-b35e-af08eaa91384\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"3466633d-ae13-4d07-b35e-af08eaa91384\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e78f34e7-94c4-464f-888d-fd7bd7eb66a4\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0c9f057a05c\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"841b8909-9838-4df3-bf7c-bb9b0c2a4d0c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 07:55:26','2025-11-29 07:55:34','2025-11-29 07:55:34',1,'e8680d66-168c-4035-83b3-eacfa77a6035','bd8dea43-45df-40f8-8674-dea0f07a1d34','compute-1.ctlplane.example.com','0fc06623-7a89-42ac-8120-3786201532b9','/dev/sdc','2025-11-29 07:55:28','2025-11-29 07:55:34','rw','detached','{\"name\": \"volumes/volume-bd8dea43-45df-40f8-8674-dea0f07a1d34\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"bd8dea43-45df-40f8-8674-dea0f07a1d34\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e8680d66-168c-4035-83b3-eacfa77a6035\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/sdc\"}'),('2025-11-29 07:47:54','2025-11-29 07:48:29','2025-11-29 07:48:29',1,'e8b3488f-f1e2-453e-93e6-a153b3c09a17','1c382493-5718-4c6c-93b8-8f2562c0a68a','compute-0.ctlplane.example.com','738ca4a4-91f6-4476-a500-4d85c8eb00ef','/dev/vda','2025-11-29 07:48:00','2025-11-29 07:48:29','rw','detached','{\"name\": \"volumes/volume-1c382493-5718-4c6c-93b8-8f2562c0a68a\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"1c382493-5718-4c6c-93b8-8f2562c0a68a\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e8b3488f-f1e2-453e-93e6-a153b3c09a17\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:b34daab51fdd\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"9fe13708-3578-4487-abe9-9bea2dcb1209\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 07:52:01','2025-11-29 07:52:48','2025-11-29 07:52:48',1,'e91a474d-25b3-4d61-89c1-080b5b4408d2','4a9f4928-146a-4c56-bbea-7dd9c7945b0c','compute-1.ctlplane.example.com','bae55d85-4263-4efe-895d-a762627b52ff','/dev/vda','2025-11-29 07:52:02','2025-11-29 07:52:48','null','detached','{\"name\": \"volumes/volume-4a9f4928-146a-4c56-bbea-7dd9c7945b0c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"4a9f4928-146a-4c56-bbea-7dd9c7945b0c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e91a474d-25b3-4d61-89c1-080b5b4408d2\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2025-11-29 08:30:32','2025-11-29 08:30:55','2025-11-29 08:30:55',1,'edcd20d2-5f69-47ab-8706-511c8119892f','2c994368-e80f-41ad-8820-f509c2008bb5','compute-1.ctlplane.example.com','ef2296eb-4538-4e04-8c0b-42370d9e5b12','/dev/vdc','2025-11-29 08:30:33','2025-11-29 08:30:55','rw','detached','{\"name\": \"volumes/volume-2c994368-e80f-41ad-8820-f509c2008bb5\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"2c994368-e80f-41ad-8820-f509c2008bb5\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"edcd20d2-5f69-47ab-8706-511c8119892f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-11-29 08:12:59','2025-11-29 08:14:02','2025-11-29 08:14:02',1,'eeb95054-dd7b-498a-83f2-fc2054b7cc15','c5655890-57a1-4371-8ce4-c9179f1c49bb','compute-1.ctlplane.example.com','5575532e-65f8-4b29-bab0-a0f8e60d032c','/dev/vda','2025-11-29 08:13:19','2025-11-29 08:14:02','rw','detached','{\"name\": \"volumes/volume-c5655890-57a1-4371-8ce4-c9179f1c49bb\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"c5655890-57a1-4371-8ce4-c9179f1c49bb\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"eeb95054-dd7b-498a-83f2-fc2054b7cc15\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 09:09:50','2025-11-29 09:10:17','2025-11-29 09:10:17',1,'f2156a7c-75e9-4ffe-a015-a4347592bf1a','42ac62ec-79ea-47f9-8105-4e6fd3447306','compute-1.ctlplane.example.com','d3c8c6ba-d88b-4170-9c9f-0aa03a6b0b4d','/dev/vda','2025-11-29 09:09:54','2025-11-29 09:10:17','rw','detached','{\"name\": \"volumes/volume-42ac62ec-79ea-47f9-8105-4e6fd3447306\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"42ac62ec-79ea-47f9-8105-4e6fd3447306\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"f2156a7c-75e9-4ffe-a015-a4347592bf1a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 08:30:51','2025-11-29 08:30:59','2025-11-29 08:30:59',1,'f2a15aac-a5f1-4d6c-92db-07db274f47ab','d5b932e2-653b-46a6-9b2c-1d5019441709','compute-2.ctlplane.example.com','dc8140a9-7bef-42f8-867c-13e29f022673','/dev/vdb','2025-11-29 08:30:53','2025-11-29 08:30:59','rw','detached','{\"name\": \"volumes/volume-d5b932e2-653b-46a6-9b2c-1d5019441709\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"d5b932e2-653b-46a6-9b2c-1d5019441709\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"f2a15aac-a5f1-4d6c-92db-07db274f47ab\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:e0c9f057a05c\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"841b8909-9838-4df3-bf7c-bb9b0c2a4d0c\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-11-29 08:14:45','2025-11-29 08:15:19','2025-11-29 08:15:19',1,'f431964f-554d-4d01-8f7b-7d775175bff1','ad74cad8-db25-41c6-a50a-ce4cad08c1ea','compute-1.ctlplane.example.com','bba0127d-6332-44fa-8fc1-c3d7321260fa','/dev/vda','2025-11-29 08:14:49','2025-11-29 08:15:19','rw','detached','{\"name\": \"volumes/volume-ad74cad8-db25-41c6-a50a-ce4cad08c1ea\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"ad74cad8-db25-41c6-a50a-ce4cad08c1ea\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"f431964f-554d-4d01-8f7b-7d775175bff1\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-11-29 07:50:28','2025-11-29 07:50:40','2025-11-29 07:50:40',1,'fe599284-9dea-4a95-aebc-ba8f7e86a4d9','3466633d-ae13-4d07-b35e-af08eaa91384','compute-1.ctlplane.example.com','55a96092-65f2-4612-a809-0f145c804f96','/dev/vdb','2025-11-29 07:50:29','2025-11-29 07:50:40','rw','detached','{\"name\": \"volumes/volume-3466633d-ae13-4d07-b35e-af08eaa91384\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"38a37ed2-442a-5e0d-a69a-881fdd186450\", \"volume_id\": \"3466633d-ae13-4d07-b35e-af08eaa91384\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"fe599284-9dea-4a95-aebc-ba8f7e86a4d9\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:d3b4384eec44\", \"do_local_attach\": false, \"nvme_hostid\": \"a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"system uuid\": \"2e858761-3292-4a17-b38f-a169c3064289\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:a5e1c538-e584-4a91-80ec-e9f1f28a5aed\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}');
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=267 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
INSERT INTO `volume_glance_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `snapshot_id`, `key`, `value`) VALUES ('2025-11-29 07:47:45',NULL,'2025-11-29 07:49:23',1,1,'1c382493-5718-4c6c-93b8-8f2562c0a68a',NULL,'signature_verified','False'),('2025-11-29 07:47:50',NULL,'2025-11-29 07:49:23',1,2,'1c382493-5718-4c6c-93b8-8f2562c0a68a',NULL,'hw_rng_model','virtio'),('2025-11-29 07:47:50',NULL,'2025-11-29 07:49:23',1,3,'1c382493-5718-4c6c-93b8-8f2562c0a68a',NULL,'image_id','1be11678-cfa4-4dee-b54c-6c7e547e5a6a'),('2025-11-29 07:47:50',NULL,'2025-11-29 07:49:23',1,4,'1c382493-5718-4c6c-93b8-8f2562c0a68a',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 07:47:50',NULL,'2025-11-29 07:49:23',1,5,'1c382493-5718-4c6c-93b8-8f2562c0a68a',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 07:47:50',NULL,'2025-11-29 07:49:23',1,6,'1c382493-5718-4c6c-93b8-8f2562c0a68a',NULL,'container_format','bare'),('2025-11-29 07:47:50',NULL,'2025-11-29 07:49:23',1,7,'1c382493-5718-4c6c-93b8-8f2562c0a68a',NULL,'disk_format','qcow2'),('2025-11-29 07:47:50',NULL,'2025-11-29 07:49:23',1,8,'1c382493-5718-4c6c-93b8-8f2562c0a68a',NULL,'min_disk','0'),('2025-11-29 07:47:50',NULL,'2025-11-29 07:49:23',1,9,'1c382493-5718-4c6c-93b8-8f2562c0a68a',NULL,'min_ram','0'),('2025-11-29 07:47:50',NULL,'2025-11-29 07:49:23',1,10,'1c382493-5718-4c6c-93b8-8f2562c0a68a',NULL,'size','21430272'),('2025-11-29 07:51:02',NULL,'2025-11-29 07:53:00',1,11,'4a9f4928-146a-4c56-bbea-7dd9c7945b0c',NULL,'signature_verified','False'),('2025-11-29 07:51:07',NULL,'2025-11-29 07:53:00',1,12,'4a9f4928-146a-4c56-bbea-7dd9c7945b0c',NULL,'hw_rng_model','virtio'),('2025-11-29 07:51:07',NULL,'2025-11-29 07:53:00',1,13,'4a9f4928-146a-4c56-bbea-7dd9c7945b0c',NULL,'image_id','1be11678-cfa4-4dee-b54c-6c7e547e5a6a'),('2025-11-29 07:51:07',NULL,'2025-11-29 07:53:00',1,14,'4a9f4928-146a-4c56-bbea-7dd9c7945b0c',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 07:51:07',NULL,'2025-11-29 07:53:00',1,15,'4a9f4928-146a-4c56-bbea-7dd9c7945b0c',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 07:51:07',NULL,'2025-11-29 07:53:00',1,16,'4a9f4928-146a-4c56-bbea-7dd9c7945b0c',NULL,'container_format','bare'),('2025-11-29 07:51:07',NULL,'2025-11-29 07:53:00',1,17,'4a9f4928-146a-4c56-bbea-7dd9c7945b0c',NULL,'disk_format','qcow2'),('2025-11-29 07:51:07',NULL,'2025-11-29 07:53:00',1,18,'4a9f4928-146a-4c56-bbea-7dd9c7945b0c',NULL,'min_disk','0'),('2025-11-29 07:51:07',NULL,'2025-11-29 07:53:00',1,19,'4a9f4928-146a-4c56-bbea-7dd9c7945b0c',NULL,'min_ram','0'),('2025-11-29 07:51:07',NULL,'2025-11-29 07:53:00',1,20,'4a9f4928-146a-4c56-bbea-7dd9c7945b0c',NULL,'size','21430272'),('2025-11-29 07:59:27',NULL,'2025-11-29 08:00:17',1,21,'46608b98-4ab9-406c-9f99-bd236172e09a',NULL,'signature_verified','False'),('2025-11-29 07:59:34',NULL,'2025-11-29 08:00:17',1,22,'46608b98-4ab9-406c-9f99-bd236172e09a',NULL,'hw_rng_model','virtio'),('2025-11-29 07:59:34',NULL,'2025-11-29 08:00:17',1,23,'46608b98-4ab9-406c-9f99-bd236172e09a',NULL,'image_id','1be11678-cfa4-4dee-b54c-6c7e547e5a6a'),('2025-11-29 07:59:34',NULL,'2025-11-29 08:00:17',1,24,'46608b98-4ab9-406c-9f99-bd236172e09a',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 07:59:34',NULL,'2025-11-29 08:00:17',1,25,'46608b98-4ab9-406c-9f99-bd236172e09a',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 07:59:34',NULL,'2025-11-29 08:00:17',1,26,'46608b98-4ab9-406c-9f99-bd236172e09a',NULL,'container_format','bare'),('2025-11-29 07:59:34',NULL,'2025-11-29 08:00:17',1,27,'46608b98-4ab9-406c-9f99-bd236172e09a',NULL,'disk_format','qcow2'),('2025-11-29 07:59:34',NULL,'2025-11-29 08:00:17',1,28,'46608b98-4ab9-406c-9f99-bd236172e09a',NULL,'min_disk','0'),('2025-11-29 07:59:34',NULL,'2025-11-29 08:00:17',1,29,'46608b98-4ab9-406c-9f99-bd236172e09a',NULL,'min_ram','0'),('2025-11-29 07:59:34',NULL,'2025-11-29 08:00:17',1,30,'46608b98-4ab9-406c-9f99-bd236172e09a',NULL,'size','21430272'),('2025-11-29 08:02:28',NULL,'2025-11-29 08:05:17',1,31,'9f626c2c-bb56-4532-9935-1e7b39440d48',NULL,'signature_verified','False'),('2025-11-29 08:02:35',NULL,'2025-11-29 08:05:17',1,32,'9f626c2c-bb56-4532-9935-1e7b39440d48',NULL,'hw_rng_model','virtio'),('2025-11-29 08:02:35',NULL,'2025-11-29 08:05:17',1,33,'9f626c2c-bb56-4532-9935-1e7b39440d48',NULL,'image_id','1be11678-cfa4-4dee-b54c-6c7e547e5a6a'),('2025-11-29 08:02:35',NULL,'2025-11-29 08:05:17',1,34,'9f626c2c-bb56-4532-9935-1e7b39440d48',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:02:35',NULL,'2025-11-29 08:05:17',1,35,'9f626c2c-bb56-4532-9935-1e7b39440d48',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:02:35',NULL,'2025-11-29 08:05:17',1,36,'9f626c2c-bb56-4532-9935-1e7b39440d48',NULL,'container_format','bare'),('2025-11-29 08:02:35',NULL,'2025-11-29 08:05:17',1,37,'9f626c2c-bb56-4532-9935-1e7b39440d48',NULL,'disk_format','qcow2'),('2025-11-29 08:02:35',NULL,'2025-11-29 08:05:17',1,38,'9f626c2c-bb56-4532-9935-1e7b39440d48',NULL,'min_disk','0'),('2025-11-29 08:02:35',NULL,'2025-11-29 08:05:17',1,39,'9f626c2c-bb56-4532-9935-1e7b39440d48',NULL,'min_ram','0'),('2025-11-29 08:02:35',NULL,'2025-11-29 08:05:17',1,40,'9f626c2c-bb56-4532-9935-1e7b39440d48',NULL,'size','21430272'),('2025-11-29 08:06:17',NULL,'2025-11-29 08:08:43',1,41,'a58e04ca-51a8-451c-bfd9-cb5b176d93d9',NULL,'signature_verified','False'),('2025-11-29 08:06:22',NULL,'2025-11-29 08:08:43',1,42,'a58e04ca-51a8-451c-bfd9-cb5b176d93d9',NULL,'hw_rng_model','virtio'),('2025-11-29 08:06:22',NULL,'2025-11-29 08:08:43',1,43,'a58e04ca-51a8-451c-bfd9-cb5b176d93d9',NULL,'image_id','1be11678-cfa4-4dee-b54c-6c7e547e5a6a'),('2025-11-29 08:06:22',NULL,'2025-11-29 08:08:43',1,44,'a58e04ca-51a8-451c-bfd9-cb5b176d93d9',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:06:22',NULL,'2025-11-29 08:08:43',1,45,'a58e04ca-51a8-451c-bfd9-cb5b176d93d9',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:06:22',NULL,'2025-11-29 08:08:43',1,46,'a58e04ca-51a8-451c-bfd9-cb5b176d93d9',NULL,'container_format','bare'),('2025-11-29 08:06:22',NULL,'2025-11-29 08:08:43',1,47,'a58e04ca-51a8-451c-bfd9-cb5b176d93d9',NULL,'disk_format','qcow2'),('2025-11-29 08:06:22',NULL,'2025-11-29 08:08:43',1,48,'a58e04ca-51a8-451c-bfd9-cb5b176d93d9',NULL,'min_disk','0'),('2025-11-29 08:06:22',NULL,'2025-11-29 08:08:43',1,49,'a58e04ca-51a8-451c-bfd9-cb5b176d93d9',NULL,'min_ram','0'),('2025-11-29 08:06:22',NULL,'2025-11-29 08:08:43',1,50,'a58e04ca-51a8-451c-bfd9-cb5b176d93d9',NULL,'size','21430272'),('2025-11-29 08:11:47',NULL,'2025-11-29 08:13:12',1,51,'c5655890-57a1-4371-8ce4-c9179f1c49bb',NULL,'signature_verified','False'),('2025-11-29 08:11:52',NULL,'2025-11-29 08:13:12',1,52,'c5655890-57a1-4371-8ce4-c9179f1c49bb',NULL,'hw_rng_model','virtio'),('2025-11-29 08:11:52',NULL,'2025-11-29 08:13:12',1,53,'c5655890-57a1-4371-8ce4-c9179f1c49bb',NULL,'image_id','1be11678-cfa4-4dee-b54c-6c7e547e5a6a'),('2025-11-29 08:11:52',NULL,'2025-11-29 08:13:12',1,54,'c5655890-57a1-4371-8ce4-c9179f1c49bb',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:11:52',NULL,'2025-11-29 08:13:12',1,55,'c5655890-57a1-4371-8ce4-c9179f1c49bb',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:11:52',NULL,'2025-11-29 08:13:12',1,56,'c5655890-57a1-4371-8ce4-c9179f1c49bb',NULL,'container_format','bare'),('2025-11-29 08:11:52',NULL,'2025-11-29 08:13:12',1,57,'c5655890-57a1-4371-8ce4-c9179f1c49bb',NULL,'disk_format','qcow2'),('2025-11-29 08:11:52',NULL,'2025-11-29 08:13:12',1,58,'c5655890-57a1-4371-8ce4-c9179f1c49bb',NULL,'min_disk','0'),('2025-11-29 08:11:52',NULL,'2025-11-29 08:13:12',1,59,'c5655890-57a1-4371-8ce4-c9179f1c49bb',NULL,'min_ram','0'),('2025-11-29 08:11:52',NULL,'2025-11-29 08:13:12',1,60,'c5655890-57a1-4371-8ce4-c9179f1c49bb',NULL,'size','21430272'),('2025-11-29 08:13:12',NULL,'2025-11-29 08:14:04',1,61,'c5655890-57a1-4371-8ce4-c9179f1c49bb',NULL,'hw_rng_model','virtio'),('2025-11-29 08:13:12',NULL,'2025-11-29 08:14:04',1,62,'c5655890-57a1-4371-8ce4-c9179f1c49bb',NULL,'image_id','ed489666-5fa2-4ea4-8005-7a7505ac1b78'),('2025-11-29 08:13:12',NULL,'2025-11-29 08:14:04',1,63,'c5655890-57a1-4371-8ce4-c9179f1c49bb',NULL,'image_name','cirros-0.6.2-x86_64-disk.img_alt'),('2025-11-29 08:13:12',NULL,'2025-11-29 08:14:04',1,64,'c5655890-57a1-4371-8ce4-c9179f1c49bb',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:13:12',NULL,'2025-11-29 08:14:04',1,65,'c5655890-57a1-4371-8ce4-c9179f1c49bb',NULL,'container_format','bare'),('2025-11-29 08:13:12',NULL,'2025-11-29 08:14:04',1,66,'c5655890-57a1-4371-8ce4-c9179f1c49bb',NULL,'disk_format','qcow2'),('2025-11-29 08:13:12',NULL,'2025-11-29 08:14:04',1,67,'c5655890-57a1-4371-8ce4-c9179f1c49bb',NULL,'min_disk','0'),('2025-11-29 08:13:12',NULL,'2025-11-29 08:14:04',1,68,'c5655890-57a1-4371-8ce4-c9179f1c49bb',NULL,'min_ram','0'),('2025-11-29 08:13:12',NULL,'2025-11-29 08:14:04',1,69,'c5655890-57a1-4371-8ce4-c9179f1c49bb',NULL,'size','21430272'),('2025-11-29 08:14:37',NULL,'2025-11-29 08:15:55',1,70,'ad74cad8-db25-41c6-a50a-ce4cad08c1ea',NULL,'signature_verified','False'),('2025-11-29 08:14:42',NULL,'2025-11-29 08:15:55',1,71,'ad74cad8-db25-41c6-a50a-ce4cad08c1ea',NULL,'hw_rng_model','virtio'),('2025-11-29 08:14:42',NULL,'2025-11-29 08:15:55',1,72,'ad74cad8-db25-41c6-a50a-ce4cad08c1ea',NULL,'image_id','1be11678-cfa4-4dee-b54c-6c7e547e5a6a'),('2025-11-29 08:14:42',NULL,'2025-11-29 08:15:55',1,73,'ad74cad8-db25-41c6-a50a-ce4cad08c1ea',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:14:42',NULL,'2025-11-29 08:15:55',1,74,'ad74cad8-db25-41c6-a50a-ce4cad08c1ea',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:14:42',NULL,'2025-11-29 08:15:55',1,75,'ad74cad8-db25-41c6-a50a-ce4cad08c1ea',NULL,'container_format','bare'),('2025-11-29 08:14:42',NULL,'2025-11-29 08:15:55',1,76,'ad74cad8-db25-41c6-a50a-ce4cad08c1ea',NULL,'disk_format','qcow2'),('2025-11-29 08:14:42',NULL,'2025-11-29 08:15:55',1,77,'ad74cad8-db25-41c6-a50a-ce4cad08c1ea',NULL,'min_disk','0'),('2025-11-29 08:14:42',NULL,'2025-11-29 08:15:55',1,78,'ad74cad8-db25-41c6-a50a-ce4cad08c1ea',NULL,'min_ram','0'),('2025-11-29 08:14:42',NULL,'2025-11-29 08:15:55',1,79,'ad74cad8-db25-41c6-a50a-ce4cad08c1ea',NULL,'size','21430272'),('2025-11-29 08:20:12',NULL,NULL,0,80,'6e321817-b498-4ce5-ba72-237a6641f417',NULL,'signature_verified','False'),('2025-11-29 08:20:16',NULL,NULL,0,81,'6e321817-b498-4ce5-ba72-237a6641f417',NULL,'hw_rng_model','virtio'),('2025-11-29 08:20:16',NULL,NULL,0,82,'6e321817-b498-4ce5-ba72-237a6641f417',NULL,'image_id','1be11678-cfa4-4dee-b54c-6c7e547e5a6a'),('2025-11-29 08:20:16',NULL,NULL,0,83,'6e321817-b498-4ce5-ba72-237a6641f417',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:20:16',NULL,NULL,0,84,'6e321817-b498-4ce5-ba72-237a6641f417',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:20:16',NULL,NULL,0,85,'6e321817-b498-4ce5-ba72-237a6641f417',NULL,'container_format','bare'),('2025-11-29 08:20:16',NULL,NULL,0,86,'6e321817-b498-4ce5-ba72-237a6641f417',NULL,'disk_format','qcow2'),('2025-11-29 08:20:16',NULL,NULL,0,87,'6e321817-b498-4ce5-ba72-237a6641f417',NULL,'min_disk','0'),('2025-11-29 08:20:16',NULL,NULL,0,88,'6e321817-b498-4ce5-ba72-237a6641f417',NULL,'min_ram','0'),('2025-11-29 08:20:16',NULL,NULL,0,89,'6e321817-b498-4ce5-ba72-237a6641f417',NULL,'size','21430272'),('2025-11-29 08:24:02',NULL,'2025-11-29 08:30:17',1,90,'a9f0bfef-3469-4919-82f4-bea2fb541eb3',NULL,'signature_verified','False'),('2025-11-29 08:24:11',NULL,'2025-11-29 08:30:17',1,91,'a9f0bfef-3469-4919-82f4-bea2fb541eb3',NULL,'hw_rng_model','virtio'),('2025-11-29 08:24:11',NULL,'2025-11-29 08:30:17',1,92,'a9f0bfef-3469-4919-82f4-bea2fb541eb3',NULL,'image_id','1be11678-cfa4-4dee-b54c-6c7e547e5a6a'),('2025-11-29 08:24:11',NULL,'2025-11-29 08:30:17',1,93,'a9f0bfef-3469-4919-82f4-bea2fb541eb3',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:24:11',NULL,'2025-11-29 08:30:17',1,94,'a9f0bfef-3469-4919-82f4-bea2fb541eb3',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:24:11',NULL,'2025-11-29 08:30:17',1,95,'a9f0bfef-3469-4919-82f4-bea2fb541eb3',NULL,'container_format','bare'),('2025-11-29 08:24:11',NULL,'2025-11-29 08:30:17',1,96,'a9f0bfef-3469-4919-82f4-bea2fb541eb3',NULL,'disk_format','qcow2'),('2025-11-29 08:24:11',NULL,'2025-11-29 08:30:17',1,97,'a9f0bfef-3469-4919-82f4-bea2fb541eb3',NULL,'min_disk','0'),('2025-11-29 08:24:11',NULL,'2025-11-29 08:30:17',1,98,'a9f0bfef-3469-4919-82f4-bea2fb541eb3',NULL,'min_ram','0'),('2025-11-29 08:24:11',NULL,'2025-11-29 08:30:17',1,99,'a9f0bfef-3469-4919-82f4-bea2fb541eb3',NULL,'size','21430272'),('2025-11-29 08:28:29',NULL,'2025-11-29 08:31:42',1,100,'2d68fb40-6374-433d-8236-b50acd6ca7f0',NULL,'signature_verified','False'),('2025-11-29 08:28:31',NULL,'2025-11-29 08:31:41',1,101,'cedd0225-5008-4e7b-a363-38f002cf49fe',NULL,'signature_verified','False'),('2025-11-29 08:28:31',NULL,'2025-11-29 08:31:39',1,102,'32bcf381-1196-418b-a68f-b868a3c26635',NULL,'signature_verified','False'),('2025-11-29 08:28:35',NULL,'2025-11-29 08:31:42',1,103,'2d68fb40-6374-433d-8236-b50acd6ca7f0',NULL,'image_id','da4d6473-f717-4c5a-9ebf-ff94b495aeb0'),('2025-11-29 08:28:35',NULL,'2025-11-29 08:31:42',1,104,'2d68fb40-6374-433d-8236-b50acd6ca7f0',NULL,'image_name','tempest-scenario-img--1390363549'),('2025-11-29 08:28:35',NULL,'2025-11-29 08:31:42',1,105,'2d68fb40-6374-433d-8236-b50acd6ca7f0',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:28:35',NULL,'2025-11-29 08:31:42',1,106,'2d68fb40-6374-433d-8236-b50acd6ca7f0',NULL,'container_format','bare'),('2025-11-29 08:28:35',NULL,'2025-11-29 08:31:42',1,107,'2d68fb40-6374-433d-8236-b50acd6ca7f0',NULL,'disk_format','qcow2'),('2025-11-29 08:28:35',NULL,'2025-11-29 08:31:42',1,108,'2d68fb40-6374-433d-8236-b50acd6ca7f0',NULL,'min_disk','0'),('2025-11-29 08:28:35',NULL,'2025-11-29 08:31:42',1,109,'2d68fb40-6374-433d-8236-b50acd6ca7f0',NULL,'min_ram','0'),('2025-11-29 08:28:35',NULL,'2025-11-29 08:31:42',1,110,'2d68fb40-6374-433d-8236-b50acd6ca7f0',NULL,'size','21430272'),('2025-11-29 08:28:38',NULL,'2025-11-29 08:31:41',1,111,'cedd0225-5008-4e7b-a363-38f002cf49fe',NULL,'image_id','da4d6473-f717-4c5a-9ebf-ff94b495aeb0'),('2025-11-29 08:28:38',NULL,'2025-11-29 08:31:41',1,112,'cedd0225-5008-4e7b-a363-38f002cf49fe',NULL,'image_name','tempest-scenario-img--1390363549'),('2025-11-29 08:28:38',NULL,'2025-11-29 08:31:41',1,113,'cedd0225-5008-4e7b-a363-38f002cf49fe',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:28:38',NULL,'2025-11-29 08:31:41',1,114,'cedd0225-5008-4e7b-a363-38f002cf49fe',NULL,'container_format','bare'),('2025-11-29 08:28:38',NULL,'2025-11-29 08:31:41',1,115,'cedd0225-5008-4e7b-a363-38f002cf49fe',NULL,'disk_format','qcow2'),('2025-11-29 08:28:38',NULL,'2025-11-29 08:31:41',1,116,'cedd0225-5008-4e7b-a363-38f002cf49fe',NULL,'min_disk','0'),('2025-11-29 08:28:38',NULL,'2025-11-29 08:31:41',1,117,'cedd0225-5008-4e7b-a363-38f002cf49fe',NULL,'min_ram','0'),('2025-11-29 08:28:38',NULL,'2025-11-29 08:31:41',1,118,'cedd0225-5008-4e7b-a363-38f002cf49fe',NULL,'size','21430272'),('2025-11-29 08:28:38',NULL,'2025-11-29 08:31:39',1,119,'32bcf381-1196-418b-a68f-b868a3c26635',NULL,'image_id','da4d6473-f717-4c5a-9ebf-ff94b495aeb0'),('2025-11-29 08:28:38',NULL,'2025-11-29 08:31:39',1,120,'32bcf381-1196-418b-a68f-b868a3c26635',NULL,'image_name','tempest-scenario-img--1390363549'),('2025-11-29 08:28:38',NULL,'2025-11-29 08:31:39',1,121,'32bcf381-1196-418b-a68f-b868a3c26635',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:28:38',NULL,'2025-11-29 08:31:39',1,122,'32bcf381-1196-418b-a68f-b868a3c26635',NULL,'container_format','bare'),('2025-11-29 08:28:38',NULL,'2025-11-29 08:31:39',1,123,'32bcf381-1196-418b-a68f-b868a3c26635',NULL,'disk_format','qcow2'),('2025-11-29 08:28:38',NULL,'2025-11-29 08:31:39',1,124,'32bcf381-1196-418b-a68f-b868a3c26635',NULL,'min_disk','0'),('2025-11-29 08:28:38',NULL,'2025-11-29 08:31:39',1,125,'32bcf381-1196-418b-a68f-b868a3c26635',NULL,'min_ram','0'),('2025-11-29 08:28:38',NULL,'2025-11-29 08:31:39',1,126,'32bcf381-1196-418b-a68f-b868a3c26635',NULL,'size','21430272'),('2025-11-29 08:28:50',NULL,'2025-11-29 08:29:53',1,127,'5fdf7d48-8c9e-4f5c-9e3e-276135ea4364',NULL,'signature_verified','False'),('2025-11-29 08:29:12',NULL,'2025-11-29 08:29:53',1,128,'5fdf7d48-8c9e-4f5c-9e3e-276135ea4364',NULL,'hw_rng_model','virtio'),('2025-11-29 08:29:12',NULL,'2025-11-29 08:29:53',1,129,'5fdf7d48-8c9e-4f5c-9e3e-276135ea4364',NULL,'image_id','1be11678-cfa4-4dee-b54c-6c7e547e5a6a'),('2025-11-29 08:29:12',NULL,'2025-11-29 08:29:53',1,130,'5fdf7d48-8c9e-4f5c-9e3e-276135ea4364',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:29:12',NULL,'2025-11-29 08:29:53',1,131,'5fdf7d48-8c9e-4f5c-9e3e-276135ea4364',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:29:12',NULL,'2025-11-29 08:29:53',1,132,'5fdf7d48-8c9e-4f5c-9e3e-276135ea4364',NULL,'container_format','bare'),('2025-11-29 08:29:12',NULL,'2025-11-29 08:29:53',1,133,'5fdf7d48-8c9e-4f5c-9e3e-276135ea4364',NULL,'disk_format','qcow2'),('2025-11-29 08:29:12',NULL,'2025-11-29 08:29:53',1,134,'5fdf7d48-8c9e-4f5c-9e3e-276135ea4364',NULL,'min_disk','0'),('2025-11-29 08:29:12',NULL,'2025-11-29 08:29:53',1,135,'5fdf7d48-8c9e-4f5c-9e3e-276135ea4364',NULL,'min_ram','0'),('2025-11-29 08:29:12',NULL,'2025-11-29 08:29:53',1,136,'5fdf7d48-8c9e-4f5c-9e3e-276135ea4364',NULL,'size','21430272'),('2025-11-29 08:29:41',NULL,'2025-11-29 08:29:52',1,137,NULL,'92bf57c5-1776-41c3-84b4-e98f1bce6a3e','signature_verified','False'),('2025-11-29 08:29:41',NULL,'2025-11-29 08:29:52',1,138,NULL,'92bf57c5-1776-41c3-84b4-e98f1bce6a3e','hw_rng_model','virtio'),('2025-11-29 08:29:41',NULL,'2025-11-29 08:29:52',1,139,NULL,'92bf57c5-1776-41c3-84b4-e98f1bce6a3e','image_id','1be11678-cfa4-4dee-b54c-6c7e547e5a6a'),('2025-11-29 08:29:41',NULL,'2025-11-29 08:29:52',1,140,NULL,'92bf57c5-1776-41c3-84b4-e98f1bce6a3e','image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:29:41',NULL,'2025-11-29 08:29:52',1,141,NULL,'92bf57c5-1776-41c3-84b4-e98f1bce6a3e','checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:29:41',NULL,'2025-11-29 08:29:52',1,142,NULL,'92bf57c5-1776-41c3-84b4-e98f1bce6a3e','container_format','bare'),('2025-11-29 08:29:41',NULL,'2025-11-29 08:29:52',1,143,NULL,'92bf57c5-1776-41c3-84b4-e98f1bce6a3e','disk_format','qcow2'),('2025-11-29 08:29:41',NULL,'2025-11-29 08:29:52',1,144,NULL,'92bf57c5-1776-41c3-84b4-e98f1bce6a3e','min_disk','0'),('2025-11-29 08:29:41',NULL,'2025-11-29 08:29:52',1,145,NULL,'92bf57c5-1776-41c3-84b4-e98f1bce6a3e','min_ram','0'),('2025-11-29 08:29:41',NULL,'2025-11-29 08:29:52',1,146,NULL,'92bf57c5-1776-41c3-84b4-e98f1bce6a3e','size','21430272'),('2025-11-29 08:33:29',NULL,'2025-11-29 08:34:45',1,147,'5e1ce939-d473-4e65-8abb-4ac38bce6fd1',NULL,'signature_verified','False'),('2025-11-29 08:33:35',NULL,'2025-11-29 08:34:45',1,148,'5e1ce939-d473-4e65-8abb-4ac38bce6fd1',NULL,'hw_rng_model','virtio'),('2025-11-29 08:33:35',NULL,'2025-11-29 08:34:45',1,149,'5e1ce939-d473-4e65-8abb-4ac38bce6fd1',NULL,'image_id','1be11678-cfa4-4dee-b54c-6c7e547e5a6a'),('2025-11-29 08:33:35',NULL,'2025-11-29 08:34:45',1,150,'5e1ce939-d473-4e65-8abb-4ac38bce6fd1',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:33:35',NULL,'2025-11-29 08:34:45',1,151,'5e1ce939-d473-4e65-8abb-4ac38bce6fd1',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:33:35',NULL,'2025-11-29 08:34:45',1,152,'5e1ce939-d473-4e65-8abb-4ac38bce6fd1',NULL,'container_format','bare'),('2025-11-29 08:33:35',NULL,'2025-11-29 08:34:45',1,153,'5e1ce939-d473-4e65-8abb-4ac38bce6fd1',NULL,'disk_format','qcow2'),('2025-11-29 08:33:35',NULL,'2025-11-29 08:34:45',1,154,'5e1ce939-d473-4e65-8abb-4ac38bce6fd1',NULL,'min_disk','0'),('2025-11-29 08:33:35',NULL,'2025-11-29 08:34:45',1,155,'5e1ce939-d473-4e65-8abb-4ac38bce6fd1',NULL,'min_ram','0'),('2025-11-29 08:33:35',NULL,'2025-11-29 08:34:45',1,156,'5e1ce939-d473-4e65-8abb-4ac38bce6fd1',NULL,'size','21430272'),('2025-11-29 08:33:51',NULL,'2025-11-29 08:34:45',1,157,'f3c8b389-36e8-459a-b7d9-3ed0e65767ad',NULL,'signature_verified','False'),('2025-11-29 08:33:51',NULL,'2025-11-29 08:34:45',1,158,'f3c8b389-36e8-459a-b7d9-3ed0e65767ad',NULL,'hw_rng_model','virtio'),('2025-11-29 08:33:51',NULL,'2025-11-29 08:34:45',1,159,'f3c8b389-36e8-459a-b7d9-3ed0e65767ad',NULL,'image_id','1be11678-cfa4-4dee-b54c-6c7e547e5a6a'),('2025-11-29 08:33:51',NULL,'2025-11-29 08:34:45',1,160,'f3c8b389-36e8-459a-b7d9-3ed0e65767ad',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:33:51',NULL,'2025-11-29 08:34:45',1,161,'f3c8b389-36e8-459a-b7d9-3ed0e65767ad',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:33:52',NULL,'2025-11-29 08:34:45',1,162,'f3c8b389-36e8-459a-b7d9-3ed0e65767ad',NULL,'container_format','bare'),('2025-11-29 08:33:52',NULL,'2025-11-29 08:34:45',1,163,'f3c8b389-36e8-459a-b7d9-3ed0e65767ad',NULL,'disk_format','qcow2'),('2025-11-29 08:33:52',NULL,'2025-11-29 08:34:45',1,164,'f3c8b389-36e8-459a-b7d9-3ed0e65767ad',NULL,'min_disk','0'),('2025-11-29 08:33:52',NULL,'2025-11-29 08:34:45',1,165,'f3c8b389-36e8-459a-b7d9-3ed0e65767ad',NULL,'min_ram','0'),('2025-11-29 08:33:52',NULL,'2025-11-29 08:34:45',1,166,'f3c8b389-36e8-459a-b7d9-3ed0e65767ad',NULL,'size','21430272'),('2025-11-29 08:48:58',NULL,'2025-11-29 08:50:38',1,167,'60d0f33b-7946-4e21-ac67-19a83123d623',NULL,'signature_verified','False'),('2025-11-29 08:49:02',NULL,'2025-11-29 08:50:38',1,168,'60d0f33b-7946-4e21-ac67-19a83123d623',NULL,'hw_rng_model','virtio'),('2025-11-29 08:49:02',NULL,'2025-11-29 08:50:38',1,169,'60d0f33b-7946-4e21-ac67-19a83123d623',NULL,'image_id','1be11678-cfa4-4dee-b54c-6c7e547e5a6a'),('2025-11-29 08:49:02',NULL,'2025-11-29 08:50:38',1,170,'60d0f33b-7946-4e21-ac67-19a83123d623',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 08:49:02',NULL,'2025-11-29 08:50:38',1,171,'60d0f33b-7946-4e21-ac67-19a83123d623',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 08:49:02',NULL,'2025-11-29 08:50:38',1,172,'60d0f33b-7946-4e21-ac67-19a83123d623',NULL,'container_format','bare'),('2025-11-29 08:49:02',NULL,'2025-11-29 08:50:38',1,173,'60d0f33b-7946-4e21-ac67-19a83123d623',NULL,'disk_format','qcow2'),('2025-11-29 08:49:02',NULL,'2025-11-29 08:50:38',1,174,'60d0f33b-7946-4e21-ac67-19a83123d623',NULL,'min_disk','0'),('2025-11-29 08:49:02',NULL,'2025-11-29 08:50:38',1,175,'60d0f33b-7946-4e21-ac67-19a83123d623',NULL,'min_ram','0'),('2025-11-29 08:49:02',NULL,'2025-11-29 08:50:38',1,176,'60d0f33b-7946-4e21-ac67-19a83123d623',NULL,'size','21430272'),('2025-11-29 09:08:35',NULL,'2025-11-29 09:10:28',1,177,'87af2292-044f-4b27-b7cd-cbee4e63191c',NULL,'signature_verified','False'),('2025-11-29 09:09:08',NULL,'2025-11-29 09:10:28',1,178,'87af2292-044f-4b27-b7cd-cbee4e63191c',NULL,'hw_rng_model','virtio'),('2025-11-29 09:09:08',NULL,'2025-11-29 09:10:28',1,179,'87af2292-044f-4b27-b7cd-cbee4e63191c',NULL,'image_id','1be11678-cfa4-4dee-b54c-6c7e547e5a6a'),('2025-11-29 09:09:08',NULL,'2025-11-29 09:10:28',1,180,'87af2292-044f-4b27-b7cd-cbee4e63191c',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 09:09:08',NULL,'2025-11-29 09:10:28',1,181,'87af2292-044f-4b27-b7cd-cbee4e63191c',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 09:09:08',NULL,'2025-11-29 09:10:28',1,182,'87af2292-044f-4b27-b7cd-cbee4e63191c',NULL,'container_format','bare'),('2025-11-29 09:09:08',NULL,'2025-11-29 09:10:28',1,183,'87af2292-044f-4b27-b7cd-cbee4e63191c',NULL,'disk_format','qcow2'),('2025-11-29 09:09:08',NULL,'2025-11-29 09:10:28',1,184,'87af2292-044f-4b27-b7cd-cbee4e63191c',NULL,'min_disk','0'),('2025-11-29 09:09:08',NULL,'2025-11-29 09:10:28',1,185,'87af2292-044f-4b27-b7cd-cbee4e63191c',NULL,'min_ram','0'),('2025-11-29 09:09:08',NULL,'2025-11-29 09:10:28',1,186,'87af2292-044f-4b27-b7cd-cbee4e63191c',NULL,'size','21430272'),('2025-11-29 09:09:17',NULL,'2025-11-29 09:10:26',1,187,NULL,'237d90f9-3af7-4b2e-a811-c8302a1ac7f7','signature_verified','False'),('2025-11-29 09:09:17',NULL,'2025-11-29 09:10:26',1,188,NULL,'237d90f9-3af7-4b2e-a811-c8302a1ac7f7','hw_rng_model','virtio'),('2025-11-29 09:09:17',NULL,'2025-11-29 09:10:26',1,189,NULL,'237d90f9-3af7-4b2e-a811-c8302a1ac7f7','image_id','1be11678-cfa4-4dee-b54c-6c7e547e5a6a'),('2025-11-29 09:09:17',NULL,'2025-11-29 09:10:26',1,190,NULL,'237d90f9-3af7-4b2e-a811-c8302a1ac7f7','image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 09:09:17',NULL,'2025-11-29 09:10:26',1,191,NULL,'237d90f9-3af7-4b2e-a811-c8302a1ac7f7','checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 09:09:17',NULL,'2025-11-29 09:10:26',1,192,NULL,'237d90f9-3af7-4b2e-a811-c8302a1ac7f7','container_format','bare'),('2025-11-29 09:09:17',NULL,'2025-11-29 09:10:26',1,193,NULL,'237d90f9-3af7-4b2e-a811-c8302a1ac7f7','disk_format','qcow2'),('2025-11-29 09:09:17',NULL,'2025-11-29 09:10:26',1,194,NULL,'237d90f9-3af7-4b2e-a811-c8302a1ac7f7','min_disk','0'),('2025-11-29 09:09:17',NULL,'2025-11-29 09:10:26',1,195,NULL,'237d90f9-3af7-4b2e-a811-c8302a1ac7f7','min_ram','0'),('2025-11-29 09:09:17',NULL,'2025-11-29 09:10:26',1,196,NULL,'237d90f9-3af7-4b2e-a811-c8302a1ac7f7','size','21430272'),('2025-11-29 09:09:48',NULL,'2025-11-29 09:10:23',1,197,'42ac62ec-79ea-47f9-8105-4e6fd3447306',NULL,'signature_verified','False'),('2025-11-29 09:09:48',NULL,'2025-11-29 09:10:23',1,198,'42ac62ec-79ea-47f9-8105-4e6fd3447306',NULL,'hw_rng_model','virtio'),('2025-11-29 09:09:48',NULL,'2025-11-29 09:10:23',1,199,'42ac62ec-79ea-47f9-8105-4e6fd3447306',NULL,'image_id','1be11678-cfa4-4dee-b54c-6c7e547e5a6a'),('2025-11-29 09:09:48',NULL,'2025-11-29 09:10:23',1,200,'42ac62ec-79ea-47f9-8105-4e6fd3447306',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 09:09:48',NULL,'2025-11-29 09:10:23',1,201,'42ac62ec-79ea-47f9-8105-4e6fd3447306',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 09:09:48',NULL,'2025-11-29 09:10:23',1,202,'42ac62ec-79ea-47f9-8105-4e6fd3447306',NULL,'container_format','bare'),('2025-11-29 09:09:48',NULL,'2025-11-29 09:10:23',1,203,'42ac62ec-79ea-47f9-8105-4e6fd3447306',NULL,'disk_format','qcow2'),('2025-11-29 09:09:48',NULL,'2025-11-29 09:10:23',1,204,'42ac62ec-79ea-47f9-8105-4e6fd3447306',NULL,'min_disk','0'),('2025-11-29 09:09:48',NULL,'2025-11-29 09:10:23',1,205,'42ac62ec-79ea-47f9-8105-4e6fd3447306',NULL,'min_ram','0'),('2025-11-29 09:09:48',NULL,'2025-11-29 09:10:23',1,206,'42ac62ec-79ea-47f9-8105-4e6fd3447306',NULL,'size','21430272'),('2025-11-29 09:10:34',NULL,'2025-11-29 09:13:06',1,207,'3367e57a-b6f9-477a-b507-12360b177bbc',NULL,'signature_verified','False'),('2025-11-29 09:10:39',NULL,'2025-11-29 09:13:06',1,208,'3367e57a-b6f9-477a-b507-12360b177bbc',NULL,'hw_rng_model','virtio'),('2025-11-29 09:10:39',NULL,'2025-11-29 09:13:06',1,209,'3367e57a-b6f9-477a-b507-12360b177bbc',NULL,'image_id','1be11678-cfa4-4dee-b54c-6c7e547e5a6a'),('2025-11-29 09:10:39',NULL,'2025-11-29 09:13:06',1,210,'3367e57a-b6f9-477a-b507-12360b177bbc',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 09:10:39',NULL,'2025-11-29 09:13:06',1,211,'3367e57a-b6f9-477a-b507-12360b177bbc',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 09:10:39',NULL,'2025-11-29 09:13:06',1,212,'3367e57a-b6f9-477a-b507-12360b177bbc',NULL,'container_format','bare'),('2025-11-29 09:10:39',NULL,'2025-11-29 09:13:06',1,213,'3367e57a-b6f9-477a-b507-12360b177bbc',NULL,'disk_format','qcow2'),('2025-11-29 09:10:39',NULL,'2025-11-29 09:13:06',1,214,'3367e57a-b6f9-477a-b507-12360b177bbc',NULL,'min_disk','0'),('2025-11-29 09:10:39',NULL,'2025-11-29 09:13:06',1,215,'3367e57a-b6f9-477a-b507-12360b177bbc',NULL,'min_ram','0'),('2025-11-29 09:10:39',NULL,'2025-11-29 09:13:06',1,216,'3367e57a-b6f9-477a-b507-12360b177bbc',NULL,'size','21430272'),('2025-11-29 09:11:38',NULL,'2025-11-29 09:12:58',1,217,NULL,'30784891-c32c-4cd3-8120-4b3acd34934a','signature_verified','False'),('2025-11-29 09:11:38',NULL,'2025-11-29 09:12:58',1,218,NULL,'30784891-c32c-4cd3-8120-4b3acd34934a','hw_rng_model','virtio'),('2025-11-29 09:11:38',NULL,'2025-11-29 09:12:58',1,219,NULL,'30784891-c32c-4cd3-8120-4b3acd34934a','image_id','1be11678-cfa4-4dee-b54c-6c7e547e5a6a'),('2025-11-29 09:11:38',NULL,'2025-11-29 09:12:58',1,220,NULL,'30784891-c32c-4cd3-8120-4b3acd34934a','image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 09:11:38',NULL,'2025-11-29 09:12:58',1,221,NULL,'30784891-c32c-4cd3-8120-4b3acd34934a','checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 09:11:38',NULL,'2025-11-29 09:12:58',1,222,NULL,'30784891-c32c-4cd3-8120-4b3acd34934a','container_format','bare'),('2025-11-29 09:11:38',NULL,'2025-11-29 09:12:58',1,223,NULL,'30784891-c32c-4cd3-8120-4b3acd34934a','disk_format','qcow2'),('2025-11-29 09:11:38',NULL,'2025-11-29 09:12:58',1,224,NULL,'30784891-c32c-4cd3-8120-4b3acd34934a','min_disk','0'),('2025-11-29 09:11:38',NULL,'2025-11-29 09:12:58',1,225,NULL,'30784891-c32c-4cd3-8120-4b3acd34934a','min_ram','0'),('2025-11-29 09:11:38',NULL,'2025-11-29 09:12:58',1,226,NULL,'30784891-c32c-4cd3-8120-4b3acd34934a','size','21430272'),('2025-11-29 09:11:52',NULL,'2025-11-29 09:12:57',1,227,'74e740e5-5b5d-4c86-ad39-4e66e4082491',NULL,'signature_verified','False'),('2025-11-29 09:11:52',NULL,'2025-11-29 09:12:57',1,228,'74e740e5-5b5d-4c86-ad39-4e66e4082491',NULL,'hw_rng_model','virtio'),('2025-11-29 09:11:52',NULL,'2025-11-29 09:12:57',1,229,'74e740e5-5b5d-4c86-ad39-4e66e4082491',NULL,'image_id','1be11678-cfa4-4dee-b54c-6c7e547e5a6a'),('2025-11-29 09:11:52',NULL,'2025-11-29 09:12:57',1,230,'74e740e5-5b5d-4c86-ad39-4e66e4082491',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 09:11:52',NULL,'2025-11-29 09:12:57',1,231,'74e740e5-5b5d-4c86-ad39-4e66e4082491',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 09:11:52',NULL,'2025-11-29 09:12:57',1,232,'74e740e5-5b5d-4c86-ad39-4e66e4082491',NULL,'container_format','bare'),('2025-11-29 09:11:52',NULL,'2025-11-29 09:12:57',1,233,'74e740e5-5b5d-4c86-ad39-4e66e4082491',NULL,'disk_format','qcow2'),('2025-11-29 09:11:52',NULL,'2025-11-29 09:12:57',1,234,'74e740e5-5b5d-4c86-ad39-4e66e4082491',NULL,'min_disk','0'),('2025-11-29 09:11:52',NULL,'2025-11-29 09:12:57',1,235,'74e740e5-5b5d-4c86-ad39-4e66e4082491',NULL,'min_ram','0'),('2025-11-29 09:11:52',NULL,'2025-11-29 09:12:57',1,236,'74e740e5-5b5d-4c86-ad39-4e66e4082491',NULL,'size','21430272'),('2025-11-29 09:13:24',NULL,'2025-11-29 09:16:08',1,237,'5acb1bf0-7995-4ac2-84e2-62745b9cdce6',NULL,'signature_verified','False'),('2025-11-29 09:13:31',NULL,'2025-11-29 09:16:08',1,238,'5acb1bf0-7995-4ac2-84e2-62745b9cdce6',NULL,'hw_rng_model','virtio'),('2025-11-29 09:13:31',NULL,'2025-11-29 09:16:08',1,239,'5acb1bf0-7995-4ac2-84e2-62745b9cdce6',NULL,'image_id','1be11678-cfa4-4dee-b54c-6c7e547e5a6a'),('2025-11-29 09:13:31',NULL,'2025-11-29 09:16:08',1,240,'5acb1bf0-7995-4ac2-84e2-62745b9cdce6',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 09:13:31',NULL,'2025-11-29 09:16:08',1,241,'5acb1bf0-7995-4ac2-84e2-62745b9cdce6',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 09:13:31',NULL,'2025-11-29 09:16:08',1,242,'5acb1bf0-7995-4ac2-84e2-62745b9cdce6',NULL,'container_format','bare'),('2025-11-29 09:13:31',NULL,'2025-11-29 09:16:08',1,243,'5acb1bf0-7995-4ac2-84e2-62745b9cdce6',NULL,'disk_format','qcow2'),('2025-11-29 09:13:31',NULL,'2025-11-29 09:16:08',1,244,'5acb1bf0-7995-4ac2-84e2-62745b9cdce6',NULL,'min_disk','0'),('2025-11-29 09:13:31',NULL,'2025-11-29 09:16:08',1,245,'5acb1bf0-7995-4ac2-84e2-62745b9cdce6',NULL,'min_ram','0'),('2025-11-29 09:13:31',NULL,'2025-11-29 09:16:08',1,246,'5acb1bf0-7995-4ac2-84e2-62745b9cdce6',NULL,'size','21430272'),('2025-11-29 09:15:01',NULL,'2025-11-29 09:16:01',1,247,NULL,'5517798e-501f-4fad-960d-c6e18fae7be5','signature_verified','False'),('2025-11-29 09:15:01',NULL,'2025-11-29 09:16:01',1,248,NULL,'5517798e-501f-4fad-960d-c6e18fae7be5','hw_rng_model','virtio'),('2025-11-29 09:15:01',NULL,'2025-11-29 09:16:01',1,249,NULL,'5517798e-501f-4fad-960d-c6e18fae7be5','image_id','1be11678-cfa4-4dee-b54c-6c7e547e5a6a'),('2025-11-29 09:15:01',NULL,'2025-11-29 09:16:01',1,250,NULL,'5517798e-501f-4fad-960d-c6e18fae7be5','image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 09:15:01',NULL,'2025-11-29 09:16:01',1,251,NULL,'5517798e-501f-4fad-960d-c6e18fae7be5','checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 09:15:01',NULL,'2025-11-29 09:16:01',1,252,NULL,'5517798e-501f-4fad-960d-c6e18fae7be5','container_format','bare'),('2025-11-29 09:15:01',NULL,'2025-11-29 09:16:01',1,253,NULL,'5517798e-501f-4fad-960d-c6e18fae7be5','disk_format','qcow2'),('2025-11-29 09:15:01',NULL,'2025-11-29 09:16:01',1,254,NULL,'5517798e-501f-4fad-960d-c6e18fae7be5','min_disk','0'),('2025-11-29 09:15:01',NULL,'2025-11-29 09:16:01',1,255,NULL,'5517798e-501f-4fad-960d-c6e18fae7be5','min_ram','0'),('2025-11-29 09:15:01',NULL,'2025-11-29 09:16:01',1,256,NULL,'5517798e-501f-4fad-960d-c6e18fae7be5','size','21430272'),('2025-11-29 09:15:02',NULL,'2025-11-29 09:16:00',1,257,'5a123e28-261c-472c-adab-73c89e0d557e',NULL,'signature_verified','False'),('2025-11-29 09:15:02',NULL,'2025-11-29 09:16:00',1,258,'5a123e28-261c-472c-adab-73c89e0d557e',NULL,'hw_rng_model','virtio'),('2025-11-29 09:15:02',NULL,'2025-11-29 09:16:00',1,259,'5a123e28-261c-472c-adab-73c89e0d557e',NULL,'image_id','1be11678-cfa4-4dee-b54c-6c7e547e5a6a'),('2025-11-29 09:15:02',NULL,'2025-11-29 09:16:00',1,260,'5a123e28-261c-472c-adab-73c89e0d557e',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-11-29 09:15:02',NULL,'2025-11-29 09:16:00',1,261,'5a123e28-261c-472c-adab-73c89e0d557e',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-11-29 09:15:02',NULL,'2025-11-29 09:16:00',1,262,'5a123e28-261c-472c-adab-73c89e0d557e',NULL,'container_format','bare'),('2025-11-29 09:15:02',NULL,'2025-11-29 09:16:00',1,263,'5a123e28-261c-472c-adab-73c89e0d557e',NULL,'disk_format','qcow2'),('2025-11-29 09:15:02',NULL,'2025-11-29 09:16:00',1,264,'5a123e28-261c-472c-adab-73c89e0d557e',NULL,'min_disk','0'),('2025-11-29 09:15:02',NULL,'2025-11-29 09:16:00',1,265,'5a123e28-261c-472c-adab-73c89e0d557e',NULL,'min_ram','0'),('2025-11-29 09:15:02',NULL,'2025-11-29 09:16:00',1,266,'5a123e28-261c-472c-adab-73c89e0d557e',NULL,'size','21430272');
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
INSERT INTO `volume_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `key`, `value`) VALUES ('2025-11-29 08:24:17',NULL,'2025-11-29 08:24:44',1,1,'4642767c-3e15-4a15-8b4b-c6aa05f816a6','Type','work'),('2025-11-29 08:24:22',NULL,'2025-11-29 08:24:43',1,2,'09c1d84d-094d-4a47-b606-d11316dd943e','Type','work'),('2025-11-29 08:24:24',NULL,'2025-11-29 08:24:40',1,3,'dd44c387-ecae-489f-a2df-d80c81e1dc90','Type','work'),('2025-11-29 08:32:47',NULL,'2025-11-29 08:32:48',1,4,'26bee3dd-af0c-4dbe-824e-2eec3dbf5793','Type','work'),('2025-11-29 08:33:52',NULL,'2025-11-29 08:34:45',1,5,'f3c8b389-36e8-459a-b7d9-3ed0e65767ad','src_backup_id','d46c2eeb-0144-42cf-aec5-bcf37c5ac2c7');
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
INSERT INTO `volume_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_type_id`, `key`, `value`) VALUES ('2025-11-29 07:38:52',NULL,NULL,0,1,'866682fc-5086-4cb9-b799-71bc321825c2','multiattach','<is> True');
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2025-11-29 08:36:03',NULL,'2025-11-29 08:37:38',1,'0cbc8e68-2aad-4320-92d6-590295f50ec1','tempest-scenario-type-luks-596546322',NULL,1,NULL),('2025-11-29 06:50:10','2025-11-29 06:50:10',NULL,0,'2457eade-b9ab-4ae6-b20e-11a119fa18fe','__DEFAULT__',NULL,1,'Default Volume Type'),('2025-11-29 08:28:23',NULL,'2025-11-29 08:31:44',1,'8322e89e-6d63-49a7-a1d7-1a80b80c806b','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-138997613-1010843264',NULL,1,NULL),('2025-11-29 07:38:49',NULL,NULL,0,'866682fc-5086-4cb9-b799-71bc321825c2','multiattach',NULL,1,NULL),('2025-11-29 08:28:23',NULL,'2025-11-29 08:31:44',1,'9457209b-5357-4555-bde8-00c3589693fa','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1215813445-983297764',NULL,1,NULL),('2025-11-29 08:28:20',NULL,'2025-11-29 08:31:46',1,'9949277b-be74-4808-9f98-4c3afb9ae395','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1807121858-762180852',NULL,1,NULL),('2025-11-29 09:07:15',NULL,'2025-11-29 09:08:03',1,'f3ae0dbc-1b77-4398-94d6-14cb420f7706','tempest-scenario-type-luks-827233183',NULL,1,NULL);
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
INSERT INTO `volumes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `ec2_id`, `user_id`, `project_id`, `host`, `size`, `availability_zone`, `status`, `attach_status`, `scheduled_at`, `launched_at`, `terminated_at`, `display_name`, `display_description`, `provider_location`, `provider_auth`, `snapshot_id`, `volume_type_id`, `source_volid`, `bootable`, `provider_geometry`, `_name_id`, `encryption_key_id`, `migration_status`, `replication_status`, `replication_extended_status`, `replication_driver_data`, `consistencygroup_id`, `provider_id`, `multiattach`, `previous_status`, `cluster_name`, `group_id`, `service_uuid`, `shared_targets`, `use_quota`) VALUES ('2025-11-29 08:31:11','2025-11-29 08:32:26','2025-11-29 08:32:28',1,'0176de29-c1f1-41e7-8476-91ff0e6c70a5',NULL,'d45f9a4a44664af3884c15ce0f5697e0','7e8e7407a7c44208a503e8225c1cf518','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:31:11','2025-11-29 08:31:13','2025-11-29 08:32:26','tempest-TestStampPattern-volume-1042923102',NULL,NULL,NULL,'d7feff96-2862-4e90-a96d-90f4fdbdb766','2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:33:44','2025-11-29 08:35:00','2025-11-29 08:35:01',1,'05c725df-70ef-4bba-b7e1-f4c2c8652991',NULL,'e6de0587a3794e30acefc687f435d388','37972b49ddde4c519c6523d2ea1569b5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:33:44','2025-11-29 08:33:44','2025-11-29 08:35:00','tempest-AttachVolumeShelveTestJSON-volume-852919261',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:24:22','2025-11-29 08:24:42','2025-11-29 08:24:43',1,'09c1d84d-094d-4a47-b606-d11316dd943e',NULL,'60088a0db74d464b8cbc442eae1f371c','c1fc65ff70ce460c924739eae21e2b49','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:24:22','2025-11-29 08:24:23','2025-11-29 08:24:41','tempest-VolumesTestJSON-volume-1367322989',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:03:15','2025-11-29 08:06:40','2025-11-29 08:06:41',1,'1b84d2e0-dc4b-4e9d-96ef-b4698ba76935',NULL,'ef8e9cc962eb4827954df3c42cc34798','f8bc2a2616a34ba1a18b3211e406993f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:03:15','2025-11-29 08:03:16','2025-11-29 08:06:40','tempest-DeleteServersTestJSON-volume-1324630419',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 07:47:39','2025-11-29 07:49:04','2025-11-29 07:49:23',1,'1c382493-5718-4c6c-93b8-8f2562c0a68a',NULL,'d15fa4897cba4410b8d341f62586c091','f3f16345721743ccb9afb374deec67b5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 07:47:39','2025-11-29 07:47:50','2025-11-29 07:49:04','tempest-tempest.common.compute-volume-937320165',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:28:24','2025-11-29 08:30:50','2025-11-29 08:30:52',1,'1c425827-5356-476a-a66c-a9193ddaa105',NULL,'d039e57f31de4717a235fc96ebd56559','527c6a274d1e478eadfe67139e121185','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:28:25','2025-11-29 08:28:25','2025-11-29 08:30:50','tempest-TestInstancesWithCinderVolumes-volume-1379754065',NULL,NULL,NULL,NULL,'9457209b-5357-4555-bde8-00c3589693fa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 07:54:06','2025-11-29 07:54:09','2025-11-29 07:54:10',1,'1dc739da-df11-4abd-a769-b673c4801c16',NULL,'8551065d65214410b616d2a71729df0a','800c0f050e95457384eee582d6da0afa','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 07:54:06','2025-11-29 07:54:07','2025-11-29 07:54:09','tempest-VolumesAdminNegativeTest-volume-2106418412',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:32:47','2025-11-29 08:32:48','2025-11-29 08:32:48',1,'26bee3dd-af0c-4dbe-824e-2eec3dbf5793',NULL,'03abb169dca3464984975a0ece422458','12fcca7596944721afda13c50e6de05c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:32:47','2025-11-29 08:32:47','2025-11-29 08:32:48','tempest-VolumesGetTestJSON-Volume-922495465',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:28:25','2025-11-29 08:30:55','2025-11-29 08:30:59',1,'2c994368-e80f-41ad-8820-f509c2008bb5',NULL,'d039e57f31de4717a235fc96ebd56559','527c6a274d1e478eadfe67139e121185','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:28:25','2025-11-29 08:28:25','2025-11-29 08:30:55','tempest-TestInstancesWithCinderVolumes-volume-703863106',NULL,NULL,NULL,NULL,'8322e89e-6d63-49a7-a1d7-1a80b80c806b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:28:26','2025-11-29 08:31:41','2025-11-29 08:31:42',1,'2d68fb40-6374-433d-8236-b50acd6ca7f0',NULL,'d039e57f31de4717a235fc96ebd56559','527c6a274d1e478eadfe67139e121185','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:28:26','2025-11-29 08:28:35','2025-11-29 08:31:41','tempest-TestInstancesWithCinderVolumes-volume-548064468',NULL,NULL,NULL,NULL,'9949277b-be74-4808-9f98-4c3afb9ae395',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:25:21','2025-11-29 08:27:38','2025-11-29 08:27:39',1,'319acffc-d080-434b-9f76-d4d23dd7827d',NULL,'dfcf2db50da745c09bffcf32ec016854','09cc8c3182d845f597dda064f9013941','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:25:25','2025-11-29 08:25:25','2025-11-29 08:27:38','tempest-ServerRescueNegativeTestJSON-volume-1662549552',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:25:43','2025-11-29 08:30:03','2025-11-29 08:30:03',1,'32b198ad-3a42-4de3-9995-b7e93d51e7ec',NULL,'b4f4d28745dd46e586642c84c051db39','23450c2eaf4442459dec94c6d29f0412','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:25:43','2025-11-29 08:25:43','2025-11-29 08:30:03','tempest-AttachVolumeMultiAttachTest-volume-246043438',NULL,'{\"saved_features\":61}',NULL,NULL,'866682fc-5086-4cb9-b799-71bc321825c2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:28:29','2025-11-29 08:31:38','2025-11-29 08:31:39',1,'32bcf381-1196-418b-a68f-b868a3c26635',NULL,'d039e57f31de4717a235fc96ebd56559','527c6a274d1e478eadfe67139e121185','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:28:29','2025-11-29 08:28:38','2025-11-29 08:31:38','tempest-TestInstancesWithCinderVolumes-volume-1555963302',NULL,NULL,NULL,NULL,'9949277b-be74-4808-9f98-4c3afb9ae395',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 09:10:31','2025-11-29 09:13:03','2025-11-29 09:13:06',1,'3367e57a-b6f9-477a-b507-12360b177bbc',NULL,'5ff561a95dc44b9fb9f7fd8fee80f589','51af0a2ee11a460ab825a484e5c6f4a3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 09:10:31','2025-11-29 09:10:39','2025-11-29 09:13:03','tempest-TestVolumeBootPattern-volume-origin-1912635863',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 07:48:45','2025-11-29 07:51:02','2025-11-29 07:51:06',1,'3466633d-ae13-4d07-b35e-af08eaa91384',NULL,'93506ec26b16451c91dc820b139e8707','b2c58ae2e706424fa3147694fc571db0','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 07:48:46','2025-11-29 07:48:49','2025-11-29 07:51:02','tempest-UpdateMultiattachVolumeNegativeTest-volume-1159748973',NULL,'{\"saved_features\":61}',NULL,NULL,'866682fc-5086-4cb9-b799-71bc321825c2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:31:14','2025-11-29 08:35:03','2025-11-29 08:35:03',1,'40fdec3a-4544-45a5-9bce-a1d84a8f5b1b',NULL,'e6de0587a3794e30acefc687f435d388','37972b49ddde4c519c6523d2ea1569b5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:31:14','2025-11-29 08:31:14','2025-11-29 08:35:03','tempest-AttachVolumeShelveTestJSON-volume-684256384',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 09:09:37','2025-11-29 09:10:17','2025-11-29 09:10:23',1,'42ac62ec-79ea-47f9-8105-4e6fd3447306',NULL,'5ff561a95dc44b9fb9f7fd8fee80f589','51af0a2ee11a460ab825a484e5c6f4a3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 09:09:40','2025-11-29 09:09:48','2025-11-29 09:10:17','','',NULL,NULL,'237d90f9-3af7-4b2e-a811-c8302a1ac7f7','2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:24:17','2025-11-29 08:24:43','2025-11-29 08:24:44',1,'4642767c-3e15-4a15-8b4b-c6aa05f816a6',NULL,'60088a0db74d464b8cbc442eae1f371c','c1fc65ff70ce460c924739eae21e2b49','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:24:18','2025-11-29 08:24:21','2025-11-29 08:24:43','tempest-VolumesTestJSON-volume-1632155133',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 07:59:20','2025-11-29 08:00:16','2025-11-29 08:00:17',1,'46608b98-4ab9-406c-9f99-bd236172e09a',NULL,'0cbc1fad0f0b481797ed6cafcd266d99','19b3dc1655684be39c6d284805874456','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 07:59:21','2025-11-29 07:59:34','2025-11-29 08:00:16','tempest-tempest.common.compute-volume-902079124',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:23:53','2025-11-29 08:24:09','2025-11-29 08:24:10',1,'49ec755a-0cd6-49ff-ad14-28979b5925a9',NULL,'927e2238ca0c4d26830812effffe75ae','1e7450dd88894243affe67274f9cceb0','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:23:53','2025-11-29 08:23:57','2025-11-29 08:24:09','tempest-VolumesSnapshotsTestJSON-volume-1115376721',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 07:50:58','2025-11-29 07:52:59','2025-11-29 07:53:00',1,'4a9f4928-146a-4c56-bbea-7dd9c7945b0c',NULL,'37531d9f927d40ecadd246429b5b598d','73f3d0f2c9aa4ba29984fc9e6a7ed869','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 07:50:58','2025-11-29 07:51:07','2025-11-29 07:52:59','tempest-tempest.common.compute-volume-128171534',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:24:24','2025-11-29 08:27:29','2025-11-29 08:27:30',1,'4fc44189-7371-4f9e-a927-7e7999edd06b',NULL,'3a37c720b9bb4273b66cd2dce30fbf48','d9406fbc6fef486fa5b0e79549e78d00','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:24:24','2025-11-29 08:24:34','2025-11-29 08:27:29','tempest-ServersNegativeTestJSON-volume-684462838',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:12:38','2025-11-29 08:15:59','2025-11-29 08:15:59',1,'57626c0a-e0bf-45ee-90b0-ca7f160cc5ab',NULL,'58625e4c2b5d43a1abbab05b98853a65','250671461f27498d9f6b4476c7b69533','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:12:39','2025-11-29 08:12:39','2025-11-29 08:15:59','tempest-ServerActionsTestOtherA-volume-792965142',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 09:15:02','2025-11-29 09:16:00','2025-11-29 09:16:00',1,'5a123e28-261c-472c-adab-73c89e0d557e',NULL,'5ff561a95dc44b9fb9f7fd8fee80f589','51af0a2ee11a460ab825a484e5c6f4a3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 09:15:02','2025-11-29 09:15:02','2025-11-29 09:16:00','tempest-TestVolumeBootPattern-volume-53644321',NULL,NULL,NULL,'5517798e-501f-4fad-960d-c6e18fae7be5','2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:20:49','2025-11-29 08:22:55','2025-11-29 08:22:56',1,'5a96f9f0-c824-49b0-8c65-4dfade22f1c1',NULL,'3b52040d601a4a56abcaf3f046f1e349','358970eca7ad4b05b70f43e5507ac052','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:20:49','2025-11-29 08:20:49','2025-11-29 08:22:55','tempest-ServerStableDeviceRescueTest-volume-1527183872',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 09:13:21','2025-11-29 09:16:08','2025-11-29 09:16:08',1,'5acb1bf0-7995-4ac2-84e2-62745b9cdce6',NULL,'5ff561a95dc44b9fb9f7fd8fee80f589','51af0a2ee11a460ab825a484e5c6f4a3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 09:13:21','2025-11-29 09:13:31','2025-11-29 09:16:08','tempest-TestVolumeBootPattern-volume-origin-1922793210',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:18:09','2025-11-29 08:21:10',NULL,0,'5d21b16e-ab30-4101-bf21-01197c71cf99',NULL,'504bc6adabad4f7d8c17b0438c4d9be7','b9d4c81989d641678300c7a1c173a2c2','hostgroup@ceph#ceph',1,'nova','available','detached','2025-11-29 08:18:09','2025-11-29 08:18:10',NULL,'6c463a92-8698-4035-b4d0-b1d3db01a43b-blank-vol','',NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:33:24','2025-11-29 08:34:43','2025-11-29 08:34:45',1,'5e1ce939-d473-4e65-8abb-4ac38bce6fd1',NULL,'2ad82d69b01a4929b20a4d3c4dbe0135','340d97a89c434bedbead3110819c581d','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:33:24','2025-11-29 08:33:35','2025-11-29 08:34:43','tempest-TestVolumeBackupRestore-volume-351912155',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:28:45','2025-11-29 08:29:50','2025-11-29 08:29:53',1,'5fdf7d48-8c9e-4f5c-9e3e-276135ea4364',NULL,'b4f4d28745dd46e586642c84c051db39','23450c2eaf4442459dec94c6d29f0412','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:28:45','2025-11-29 08:29:12','2025-11-29 08:29:50','tempest-AttachVolumeMultiAttachTest-volume-1688376811',NULL,'{\"saved_features\":61}',NULL,NULL,'866682fc-5086-4cb9-b799-71bc321825c2',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:48:55','2025-11-29 08:50:37','2025-11-29 08:50:38',1,'60d0f33b-7946-4e21-ac67-19a83123d623',NULL,'5dbbf4fd34004538ad08aa4aa6ab8096','c5e836f8387a492c8119be72f1fb9980','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:48:55','2025-11-29 08:49:02','2025-11-29 08:50:37','tempest-tempest.common.compute-volume-1679792362',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:20:09','2025-11-29 08:20:56',NULL,0,'6e321817-b498-4ce5-ba72-237a6641f417',NULL,'504bc6adabad4f7d8c17b0438c4d9be7','b9d4c81989d641678300c7a1c173a2c2','hostgroup@ceph#ceph',1,'nova','available','detached','2025-11-29 08:20:09','2025-11-29 08:20:16',NULL,'','',NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 09:11:48','2025-11-29 09:12:56','2025-11-29 09:12:57',1,'74e740e5-5b5d-4c86-ad39-4e66e4082491',NULL,'5ff561a95dc44b9fb9f7fd8fee80f589','51af0a2ee11a460ab825a484e5c6f4a3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 09:11:48','2025-11-29 09:11:53','2025-11-29 09:12:56','','',NULL,NULL,'30784891-c32c-4cd3-8120-4b3acd34934a','2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 09:08:06','2025-11-29 09:10:27','2025-11-29 09:10:28',1,'87af2292-044f-4b27-b7cd-cbee4e63191c',NULL,'5ff561a95dc44b9fb9f7fd8fee80f589','51af0a2ee11a460ab825a484e5c6f4a3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 09:08:06','2025-11-29 09:09:10','2025-11-29 09:10:27','tempest-TestVolumeBootPattern-volume-origin-1886714872',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:28:24','2025-11-29 08:30:19','2025-11-29 08:30:20',1,'882d54a9-fd7e-41ac-9421-07a1ee6da4e8',NULL,'d039e57f31de4717a235fc96ebd56559','527c6a274d1e478eadfe67139e121185','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:28:24','2025-11-29 08:28:25','2025-11-29 08:30:19','tempest-TestInstancesWithCinderVolumes-volume-1620592843',NULL,NULL,NULL,NULL,'8322e89e-6d63-49a7-a1d7-1a80b80c806b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:32:04','2025-11-29 08:32:29','2025-11-29 08:32:30',1,'8a0ffcae-e95b-4559-b222-b006f2a6a46d',NULL,'7a362a419f6a492aae2f102ad2bbd5e9','eb0810bf6f5b4eb59638b7a2cf59ed5b','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:32:05','2025-11-29 08:32:06','2025-11-29 08:32:29','tempest-AttachVolumeTestJSON-volume-1486275385',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:02:36','2025-11-29 08:05:14','2025-11-29 08:05:15',1,'905030d9-8042-49ed-9c6d-0283f1caf956',NULL,'d77e751616c9473786c8ac7ae2d34d20','faa91146f75c46ebbcd15bb2222a8545','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:02:37','2025-11-29 08:02:37','2025-11-29 08:05:14','tempest-TaggedBootDevicesTest-volume-1149890949',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:06:22','2025-11-29 08:08:41','2025-11-29 08:08:41',1,'919ec135-16e6-4c87-bbf5-1726533a5182',NULL,'f5c9a929d4b248288b84a67f96ca500d','e61a0774e90545289bd82e4a71650bde','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:06:22','2025-11-29 08:06:23','2025-11-29 08:08:41','tempest-TaggedBootDevicesTest_v242-volume-188940895',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:06:24','2025-11-29 08:08:39','2025-11-29 08:08:40',1,'9a1b020a-829d-495d-928e-9016a22fe737',NULL,'f5c9a929d4b248288b84a67f96ca500d','e61a0774e90545289bd82e4a71650bde','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:06:24','2025-11-29 08:06:24','2025-11-29 08:08:39','tempest-TaggedBootDevicesTest_v242-volume-1948781780',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:25:57','2025-11-29 08:27:26','2025-11-29 08:27:27',1,'9a3eb32a-193c-49dc-a1e2-9c3bb4895a1a',NULL,'0cbb3ac39ebd4876ad23f2a6d1c50166','f9a9decdabb1480da8f7d039e8b3d414','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:25:57','2025-11-29 08:25:57','2025-11-29 08:27:26','tempest-TestMinimumBasicScenario-volume-34000242',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:02:24','2025-11-29 08:05:16','2025-11-29 08:05:17',1,'9f626c2c-bb56-4532-9935-1e7b39440d48',NULL,'d77e751616c9473786c8ac7ae2d34d20','faa91146f75c46ebbcd15bb2222a8545','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:02:24','2025-11-29 08:02:35','2025-11-29 08:05:16','tempest-TaggedBootDevicesTest-volume-1133513288',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:06:15','2025-11-29 08:08:42','2025-11-29 08:08:43',1,'a58e04ca-51a8-451c-bfd9-cb5b176d93d9',NULL,'f5c9a929d4b248288b84a67f96ca500d','e61a0774e90545289bd82e4a71650bde','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:06:15','2025-11-29 08:06:22','2025-11-29 08:08:42','tempest-TaggedBootDevicesTest_v242-volume-173186319',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 07:53:40','2025-11-29 07:54:15','2025-11-29 07:54:17',1,'a6563453-509a-48d9-9889-41f32f7b7ce4',NULL,'8551065d65214410b616d2a71729df0a','800c0f050e95457384eee582d6da0afa','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 07:53:40','2025-11-29 07:53:40','2025-11-29 07:54:15','tempest-VolumesAdminNegativeTest-volume-614236609',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:24:17','2025-11-29 08:27:30','2025-11-29 08:27:31',1,'a7b581b2-0f8d-4327-94d4-af37ca4e6a3c',NULL,'3a37c720b9bb4273b66cd2dce30fbf48','d9406fbc6fef486fa5b0e79549e78d00','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:24:17','2025-11-29 08:24:21','2025-11-29 08:27:30','tempest-ServersNegativeTestJSON-volume-681220784',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:23:54','2025-11-29 08:30:16','2025-11-29 08:30:17',1,'a9f0bfef-3469-4919-82f4-bea2fb541eb3',NULL,'b4f4d28745dd46e586642c84c051db39','23450c2eaf4442459dec94c6d29f0412','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:23:55','2025-11-29 08:24:11','2025-11-29 08:30:16','tempest-AttachVolumeMultiAttachTest-volume-1158547624',NULL,'{\"saved_features\":61}',NULL,NULL,'866682fc-5086-4cb9-b799-71bc321825c2',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:28:23','2025-11-29 08:30:16','2025-11-29 08:30:16',1,'ab4cd0c8-adcb-470a-9b1a-e227da2d6280',NULL,'d039e57f31de4717a235fc96ebd56559','527c6a274d1e478eadfe67139e121185','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:28:24','2025-11-29 08:28:24','2025-11-29 08:30:16','tempest-TestInstancesWithCinderVolumes-volume-1762862269',NULL,NULL,NULL,NULL,'9457209b-5357-4555-bde8-00c3589693fa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:14:34','2025-11-29 08:15:54','2025-11-29 08:15:55',1,'ad74cad8-db25-41c6-a50a-ce4cad08c1ea',NULL,'58625e4c2b5d43a1abbab05b98853a65','250671461f27498d9f6b4476c7b69533','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:14:34','2025-11-29 08:14:42','2025-11-29 08:15:54','tempest-tempest.common.compute-volume-979425559',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 07:48:50','2025-11-29 07:50:57','2025-11-29 07:51:01',1,'b3b00734-4db3-42d9-ade1-f81515d9e37b',NULL,'93506ec26b16451c91dc820b139e8707','b2c58ae2e706424fa3147694fc571db0','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 07:48:50','2025-11-29 07:48:52','2025-11-29 07:50:57','tempest-UpdateMultiattachVolumeNegativeTest-volume-719845569',NULL,'{\"saved_features\":61}',NULL,NULL,'866682fc-5086-4cb9-b799-71bc321825c2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:07:26','2025-11-29 08:08:33','2025-11-29 08:08:34',1,'b58f9fa1-0337-49a9-a381-b6da4150ee36',NULL,'20d37020e7484e3ead9c61a89db491b1','a6104c57e0814f16958b14707debf843','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:07:26','2025-11-29 08:07:27','2025-11-29 08:08:33','tempest-TaggedAttachmentsTest-volume-486677149',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:29:04','2025-11-29 08:32:34','2025-11-29 08:32:35',1,'bd7644b6-0d0f-4a70-962b-b60c03d49643',NULL,'7a362a419f6a492aae2f102ad2bbd5e9','eb0810bf6f5b4eb59638b7a2cf59ed5b','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:29:06','2025-11-29 08:29:07','2025-11-29 08:32:34','tempest-AttachVolumeTestJSON-volume-2084282511',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 07:55:25','2025-11-29 07:55:51','2025-11-29 07:55:52',1,'bd8dea43-45df-40f8-8674-dea0f07a1d34',NULL,'45437f208c5a4499acac789fee214724','666052d32183417982e59c456a19c744','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 07:55:25','2025-11-29 07:55:25','2025-11-29 07:55:51','tempest-AttachSCSIVolumeTestJSON-volume-1004275421',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:11:44','2025-11-29 08:14:02','2025-11-29 08:14:04',1,'c5655890-57a1-4371-8ce4-c9179f1c49bb',NULL,'9cb37d6d47ac46aaa19aebb2e5b21658','146c65131f5b423287d348b351399c4e','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:11:44','2025-11-29 08:11:52','2025-11-29 08:14:02','tempest-tempest.common.compute-volume-674103774',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'reserved',NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:36:05','2025-11-29 08:37:30','2025-11-29 08:37:37',1,'c7b25c31-f722-44d5-bbae-250821bb79df',NULL,'6126044d5f7d49d19e3feffbc3034024','3827b5eea76e4810b48ea1733ae5edc4','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:36:05','2025-11-29 08:36:17','2025-11-29 08:37:30','tempest-TestEncryptedCinderVolumes-volume-2079928934',NULL,NULL,NULL,NULL,'0cbc8e68-2aad-4320-92d6-590295f50ec1',NULL,0,NULL,NULL,'bdf77128-7c64-47d2-ba44-8cc8070a1d1f',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:20:02','2025-11-29 08:23:25','2025-11-29 08:23:28',1,'ca617c97-cbed-42b4-9b83-01f6fe990ce2',NULL,'09f1f8a0998948b7b96830d8559609f6','61d8d3b6b31f4b36b5749db9c550c696','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:20:02','2025-11-29 08:20:03','2025-11-29 08:23:25','tempest-AttachVolumeNegativeTest-volume-2109139122',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:28:27','2025-11-29 08:31:40','2025-11-29 08:31:41',1,'cedd0225-5008-4e7b-a363-38f002cf49fe',NULL,'d039e57f31de4717a235fc96ebd56559','527c6a274d1e478eadfe67139e121185','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:28:27','2025-11-29 08:28:38','2025-11-29 08:31:40','tempest-TestInstancesWithCinderVolumes-volume-1170141488',NULL,NULL,NULL,NULL,'9949277b-be74-4808-9f98-4c3afb9ae395',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:28:23','2025-11-29 08:29:53','2025-11-29 08:29:54',1,'cf5c779b-adfb-4e81-aa81-44b14dc653ca',NULL,'d039e57f31de4717a235fc96ebd56559','527c6a274d1e478eadfe67139e121185','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:28:23','2025-11-29 08:28:24','2025-11-29 08:29:53','tempest-TestInstancesWithCinderVolumes-volume-271632608',NULL,NULL,NULL,NULL,'8322e89e-6d63-49a7-a1d7-1a80b80c806b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:31:50','2025-11-29 08:32:30','2025-11-29 08:32:33',1,'d568fd4b-b177-4a6f-a3fc-768d9d38f999',NULL,'7a362a419f6a492aae2f102ad2bbd5e9','eb0810bf6f5b4eb59638b7a2cf59ed5b','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:31:51','2025-11-29 08:31:52','2025-11-29 08:32:30','tempest-AttachVolumeTestJSON-volume-250347324',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:30:15','2025-11-29 08:32:43','2025-11-29 08:32:44',1,'d5b932e2-653b-46a6-9b2c-1d5019441709',NULL,'d45f9a4a44664af3884c15ce0f5697e0','7e8e7407a7c44208a503e8225c1cf518','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:30:15','2025-11-29 08:30:15','2025-11-29 08:32:43','tempest-TestStampPattern-volume-624012200',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 07:42:11','2025-11-29 07:44:28','2025-11-29 07:44:45',1,'d78e902f-7aa0-49b0-b066-e2f250c5b234',NULL,'35709e8ae21145ea8f20a71bfac799e7','e5fa0a96b3534909a4900e2989849968','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 07:42:11','2025-11-29 07:42:22','2025-11-29 07:44:28','tempest-VolumesAssistedSnapshotsTest-volume-1533727350',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:28:02','2025-11-29 08:29:26','2025-11-29 08:29:27',1,'d82be9cd-deee-4312-bbbb-bb9d0726ae5c',NULL,'0cbb3ac39ebd4876ad23f2a6d1c50166','f9a9decdabb1480da8f7d039e8b3d414','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:28:02','2025-11-29 08:28:03','2025-11-29 08:29:26','tempest-TestMinimumBasicScenario-volume-1496009590',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:24:24','2025-11-29 08:24:38','2025-11-29 08:24:40',1,'dd44c387-ecae-489f-a2df-d80c81e1dc90',NULL,'60088a0db74d464b8cbc442eae1f371c','c1fc65ff70ce460c924739eae21e2b49','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:24:24','2025-11-29 08:24:34','2025-11-29 08:24:38','tempest-VolumesTestJSON-volume-714733605',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:13:46','2025-11-29 08:16:33','2025-11-29 08:16:33',1,'e19fd9ae-371b-4152-b2b2-910bd950e653',NULL,'ca93c8e3eac142c0aa6b61807727dea2','ba867fac17034bb28fe2cdb0fff3af2b','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:13:47','2025-11-29 08:13:47','2025-11-29 08:16:33','tempest-ServerActionsTestOtherB-volume-565197766',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:23:04','2025-11-29 08:23:19','2025-11-29 08:23:20',1,'e2fd498b-baaf-4a87-aa0b-3132c2eb32db',NULL,'09f1f8a0998948b7b96830d8559609f6','61d8d3b6b31f4b36b5749db9c550c696','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:23:04','2025-11-29 08:23:04','2025-11-29 08:23:19','tempest-AttachVolumeNegativeTest-volume-2015611993',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:25:48','2025-11-29 08:27:36','2025-11-29 08:27:38',1,'e575575a-0c17-43ef-9168-0fa9b5177df6',NULL,'dfcf2db50da745c09bffcf32ec016854','09cc8c3182d845f597dda064f9013941','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:25:48','2025-11-29 08:25:48','2025-11-29 08:27:36','tempest-ServerRescueNegativeTestJSON-volume-1733658633',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:28:23','2025-11-29 08:29:46','2025-11-29 08:29:49',1,'e7fdb130-fae5-40cb-aa10-2d9145713cd5',NULL,'d039e57f31de4717a235fc96ebd56559','527c6a274d1e478eadfe67139e121185','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:28:23','2025-11-29 08:28:23','2025-11-29 08:29:46','tempest-TestInstancesWithCinderVolumes-volume-114766606',NULL,NULL,NULL,NULL,'9457209b-5357-4555-bde8-00c3589693fa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 09:07:16','2025-11-29 09:08:01','2025-11-29 09:08:02',1,'f02bbf94-8afe-4780-9c81-24b2a1512122',NULL,'5ff561a95dc44b9fb9f7fd8fee80f589','51af0a2ee11a460ab825a484e5c6f4a3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 09:07:16','2025-11-29 09:07:24','2025-11-29 09:08:01','tempest-TestVolumeBootPattern-volume-79840806',NULL,NULL,NULL,NULL,'f3ae0dbc-1b77-4398-94d6-14cb420f7706',NULL,1,NULL,NULL,'d358f63b-9db0-4a4f-856d-06365a5bcd6e',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:02:39','2025-11-29 08:05:13','2025-11-29 08:05:14',1,'f07a118d-ea67-4113-8ddf-ed6afb5e3f24',NULL,'d77e751616c9473786c8ac7ae2d34d20','faa91146f75c46ebbcd15bb2222a8545','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:02:39','2025-11-29 08:02:39','2025-11-29 08:05:13','tempest-TaggedBootDevicesTest-volume-157696974',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:33:47','2025-11-29 08:34:43','2025-11-29 08:34:45',1,'f3c8b389-36e8-459a-b7d9-3ed0e65767ad',NULL,'2ad82d69b01a4929b20a4d3c4dbe0135','340d97a89c434bedbead3110819c581d','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:33:47','2025-11-29 08:33:47','2025-11-29 08:34:43','tempest-TestVolumeBackupRestore-volume-351912155',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:22:09','2025-11-29 08:23:21','2025-11-29 08:23:25',1,'fe8a190c-eaa2-4117-ba27-c0ae9ce39d0e',NULL,'09f1f8a0998948b7b96830d8559609f6','61d8d3b6b31f4b36b5749db9c550c696','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:22:09','2025-11-29 08:22:10','2025-11-29 08:23:21','tempest-AttachVolumeNegativeTest-volume-1128708086',NULL,NULL,NULL,NULL,'2457eade-b9ab-4ae6-b20e-11a119fa18fe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1),('2025-11-29 08:26:50','2025-11-29 08:29:55','2025-11-29 08:29:56',1,'ff1e082f-e768-4c5f-850b-5e8ce6b839d1',NULL,'b4f4d28745dd46e586642c84c051db39','23450c2eaf4442459dec94c6d29f0412','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-11-29 08:26:51','2025-11-29 08:26:52','2025-11-29 08:29:55','tempest-AttachVolumeMultiAttachTest-volume-501290025',NULL,'{\"saved_features\":61}',NULL,NULL,'866682fc-5086-4cb9-b799-71bc321825c2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'70235708-9183-4991-bf77-6287721443fa',0,1);
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=145 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2025-11-29 06:50:10','2025-11-29 06:50:10.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'1be11678-cfa4-4dee-b54c-6c7e547e5a6a','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/1be11678-cfa4-4dee-b54c-6c7e547e5a6a/snap','2025-11-29 07:40:36','2025-11-29 07:40:36',NULL,0,'{\"store\": \"default_backend\"}','active'),(2,'ed489666-5fa2-4ea4-8005-7a7505ac1b78','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/ed489666-5fa2-4ea4-8005-7a7505ac1b78/snap','2025-11-29 07:40:59','2025-11-29 07:40:59',NULL,0,'{\"store\": \"default_backend\"}','active'),(3,'73295910-5010-42bf-ac24-9ee2d7bb4671','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/73295910-5010-42bf-ac24-9ee2d7bb4671/snap','2025-11-29 07:50:23','2025-11-29 07:50:36','2025-11-29 07:50:36',1,'{\"store\": \"default_backend\"}','deleted'),(4,'33939db1-a4ae-4fac-9a69-88ed807d304b','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/33939db1-a4ae-4fac-9a69-88ed807d304b/snap','2025-11-29 07:51:04','2025-11-29 07:51:37','2025-11-29 07:51:37',1,'{\"store\": \"default_backend\"}','deleted'),(5,'67b4b12c-5f96-4d5d-a734-669efbd0af6b','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/67b4b12c-5f96-4d5d-a734-669efbd0af6b/snap','2025-11-29 07:54:18','2025-11-29 07:55:51','2025-11-29 07:55:51',1,'{\"store\": \"default_backend\"}','deleted'),(6,'7125fca0-e10e-42cb-acad-616c180d5096','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/7125fca0-e10e-42cb-acad-616c180d5096/snap','2025-11-29 07:54:24','2025-11-29 07:54:39','2025-11-29 07:54:39',1,'{\"store\": \"default_backend\"}','deleted'),(7,'2c100ba6-aad9-4f8a-a5b0-c35f5675fe20','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/2c100ba6-aad9-4f8a-a5b0-c35f5675fe20/snap','2025-11-29 07:54:50','2025-11-29 07:55:01','2025-11-29 07:55:01',1,'{\"store\": \"default_backend\"}','deleted'),(8,'305868a8-2835-47a9-b3a6-72fd47849d38','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/305868a8-2835-47a9-b3a6-72fd47849d38/snap','2025-11-29 07:54:57','2025-11-29 07:55:05','2025-11-29 07:55:05',1,'{\"store\": \"default_backend\"}','deleted'),(9,'68d9094a-a514-4c4f-a0d2-50c99d09fcfc','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/68d9094a-a514-4c4f-a0d2-50c99d09fcfc/snap','2025-11-29 07:56:53','2025-11-29 07:57:13','2025-11-29 07:57:13',1,'{\"store\": \"default_backend\"}','deleted'),(10,'b70f1fb0-c9d8-4075-87c8-fc7a840ab566','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/b70f1fb0-c9d8-4075-87c8-fc7a840ab566/snap','2025-11-29 07:57:21','2025-11-29 07:59:28','2025-11-29 07:59:28',1,'{\"store\": \"default_backend\"}','deleted'),(11,'fc016565-453a-481e-b8ed-9b1e582842e0','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/fc016565-453a-481e-b8ed-9b1e582842e0/snap','2025-11-29 07:57:26','2025-11-29 07:59:22','2025-11-29 07:59:22',1,'{\"store\": \"default_backend\"}','deleted'),(12,'a49a2108-5e46-47ff-8e29-481726f9db30','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/a49a2108-5e46-47ff-8e29-481726f9db30/snap','2025-11-29 07:57:29','2025-11-29 07:59:17','2025-11-29 07:59:17',1,'{\"store\": \"default_backend\"}','deleted'),(13,'e89bf772-b42e-4a81-949b-a562a33a3e0c','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/e89bf772-b42e-4a81-949b-a562a33a3e0c/snap','2025-11-29 07:57:50','2025-11-29 07:58:48','2025-11-29 07:58:48',1,'{\"store\": \"default_backend\"}','deleted'),(14,'df78a6c7-19bb-4390-bc30-7251b87a9d47','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/df78a6c7-19bb-4390-bc30-7251b87a9d47/snap','2025-11-29 07:58:05','2025-11-29 07:58:45','2025-11-29 07:58:45',1,'{\"store\": \"default_backend\"}','deleted'),(15,'49b84182-d6c5-4bdc-9e97-50145d5437cf','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/49b84182-d6c5-4bdc-9e97-50145d5437cf/snap','2025-11-29 07:58:17','2025-11-29 07:58:24','2025-11-29 07:58:24',1,'{\"store\": \"default_backend\"}','deleted'),(16,'36972a45-a1b4-44eb-9fc1-abe990709f21','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/36972a45-a1b4-44eb-9fc1-abe990709f21/snap','2025-11-29 07:58:17','2025-11-29 07:58:42','2025-11-29 07:58:42',1,'{\"store\": \"default_backend\"}','deleted'),(17,'32b89eea-531a-4341-b175-80b921fa7805','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/32b89eea-531a-4341-b175-80b921fa7805/snap','2025-11-29 07:59:43','2025-11-29 07:59:49','2025-11-29 07:59:49',1,'{\"store\": \"default_backend\"}','deleted'),(18,'5db9d02f-2f54-48e1-952b-46fcc86d3d02','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/5db9d02f-2f54-48e1-952b-46fcc86d3d02/snap','2025-11-29 08:00:18','2025-11-29 08:00:21','2025-11-29 08:00:21',1,'{\"store\": \"default_backend\"}','deleted'),(19,'bb915321-974b-4310-80ce-22fe787becec','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/bb915321-974b-4310-80ce-22fe787becec/snap','2025-11-29 08:01:01','2025-11-29 08:01:22','2025-11-29 08:01:22',1,'{\"store\": \"default_backend\"}','deleted'),(20,'79df671d-c55d-4ae7-bed4-66b1126df827','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/79df671d-c55d-4ae7-bed4-66b1126df827/snap','2025-11-29 08:04:31','2025-11-29 08:04:39','2025-11-29 08:04:39',1,'{\"store\": \"default_backend\"}','deleted'),(21,'19d37975-6e79-4fd9-8985-4a51a67c9db3','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/19d37975-6e79-4fd9-8985-4a51a67c9db3/snap','2025-11-29 08:10:57','2025-11-29 08:11:14','2025-11-29 08:11:14',1,'{\"store\": \"default_backend\"}','deleted'),(22,'0136f9fb-9ab3-4552-8505-f62bd960c3d5','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/0136f9fb-9ab3-4552-8505-f62bd960c3d5/snap','2025-11-29 08:11:05','2025-11-29 08:11:19','2025-11-29 08:11:19',1,'{\"store\": \"default_backend\"}','deleted'),(23,'c02352c0-4a84-408b-a38c-1ebe85e285cf','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/c02352c0-4a84-408b-a38c-1ebe85e285cf/snap','2025-11-29 08:11:13','2025-11-29 08:11:18','2025-11-29 08:11:18',1,'{\"store\": \"default_backend\"}','deleted'),(24,'a949de33-fe8e-409f-9e15-d50c466534f9','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/a949de33-fe8e-409f-9e15-d50c466534f9/snap','2025-11-29 08:15:40','2025-11-29 08:16:27','2025-11-29 08:16:27',1,'{\"store\": \"default_backend\"}','deleted'),(25,'a83442a1-fb28-462f-8936-713084bd46ef','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/a83442a1-fb28-462f-8936-713084bd46ef/snap','2025-11-29 08:15:59','2025-11-29 08:16:23','2025-11-29 08:16:23',1,'{\"store\": \"default_backend\"}','deleted'),(26,'995630c6-dc23-4abf-afc5-51778a6f1496','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/995630c6-dc23-4abf-afc5-51778a6f1496/snap','2025-11-29 08:18:00','2025-11-29 08:21:13','2025-11-29 08:21:13',1,'{\"store\": \"default_backend\"}','deleted'),(27,'b01ef350-a5c1-4fa3-afd2-96dd9326703d','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/b01ef350-a5c1-4fa3-afd2-96dd9326703d/snap','2025-11-29 08:18:41','2025-11-29 08:23:11','2025-11-29 08:23:11',1,'{\"store\": \"default_backend\"}','deleted'),(28,'e372d671-0356-4b39-949b-13a58b062421','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/e372d671-0356-4b39-949b-13a58b062421/snap','2025-11-29 08:19:31','2025-11-29 08:23:04','2025-11-29 08:23:04',1,'{\"store\": \"default_backend\"}','deleted'),(29,'bf0aed8c-3418-4a5d-ab36-68410b6b956c','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/bf0aed8c-3418-4a5d-ab36-68410b6b956c/snap','2025-11-29 08:20:01','2025-11-29 08:21:03','2025-11-29 08:21:03',1,'{\"store\": \"default_backend\"}','deleted'),(30,'5b6878f5-ee6a-4f36-b7ce-cdb9894ce54c','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/5b6878f5-ee6a-4f36-b7ce-cdb9894ce54c/snap','2025-11-29 08:20:18','2025-11-29 08:22:58','2025-11-29 08:22:58',1,'{\"store\": \"default_backend\"}','deleted'),(31,'10d0dcc8-92b3-4e29-baff-aaa5549dce70','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/10d0dcc8-92b3-4e29-baff-aaa5549dce70/snap','2025-11-29 08:21:38','2025-11-29 08:22:50','2025-11-29 08:22:50',1,'{\"store\": \"default_backend\"}','deleted'),(32,'d9469d26-d189-44ee-a659-1398ee5e0da2','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/d9469d26-d189-44ee-a659-1398ee5e0da2/snap','2025-11-29 08:25:40','2025-11-29 08:27:38','2025-11-29 08:27:38',1,'{\"store\": \"default_backend\"}','deleted'),(33,'5945a148-7986-4fa0-8052-c380ea11f788','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/5945a148-7986-4fa0-8052-c380ea11f788/snap','2025-11-29 08:26:12','2025-11-29 08:26:47','2025-11-29 08:26:47',1,'{\"store\": \"default_backend\"}','deleted'),(34,'aad237b6-caeb-4300-902b-ba8936a7053b','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/aad237b6-caeb-4300-902b-ba8936a7053b/snap','2025-11-29 08:27:40','2025-11-29 08:29:34','2025-11-29 08:29:34',1,'{\"store\": \"default_backend\"}','deleted'),(35,'da4d6473-f717-4c5a-9ebf-ff94b495aeb0','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/da4d6473-f717-4c5a-9ebf-ff94b495aeb0/snap','2025-11-29 08:28:22','2025-11-29 08:31:46','2025-11-29 08:31:46',1,'{\"store\": \"default_backend\"}','deleted'),(36,'1b6ee968-62a2-4023-a5bf-e3fec39abfbe','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/1b6ee968-62a2-4023-a5bf-e3fec39abfbe/snap','2025-11-29 08:29:43','2025-11-29 08:29:55','2025-11-29 08:29:55',1,'{\"store\": \"default_backend\"}','deleted'),(37,'29125612-6fcb-47b2-8690-67e6e3459b96','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/29125612-6fcb-47b2-8690-67e6e3459b96/snap','2025-11-29 08:31:10','2025-11-29 08:32:32','2025-11-29 08:32:32',1,'{\"store\": \"default_backend\"}','deleted'),(38,'fde91722-ea74-45a9-b57b-7fc9203f0965','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/fde91722-ea74-45a9-b57b-7fc9203f0965/snap','2025-11-29 08:31:35','2025-11-29 08:32:20','2025-11-29 08:32:20',1,'{\"store\": \"default_backend\"}','deleted'),(39,'5e39b3d9-9c5d-4d2b-801f-dfff461af72e','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/5e39b3d9-9c5d-4d2b-801f-dfff461af72e/snap','2025-11-29 08:33:56','2025-11-29 08:34:17','2025-11-29 08:34:17',1,'{\"store\": \"default_backend\"}','deleted'),(40,'73ec6614-8649-4526-8040-59b3499a752c','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/73ec6614-8649-4526-8040-59b3499a752c/snap','2025-11-29 08:48:06','2025-11-29 08:48:26','2025-11-29 08:48:26',1,'{\"store\": \"default_backend\"}','deleted'),(41,'a7583cd4-d395-48e2-9f81-567bf2845ae0','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/a7583cd4-d395-48e2-9f81-567bf2845ae0/snap','2025-11-29 08:52:13','2025-11-29 08:53:23','2025-11-29 08:53:23',1,'{\"store\": \"default_backend\"}','deleted'),(42,'89a98419-7cd2-49c3-aac2-95418a57f2f6','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/89a98419-7cd2-49c3-aac2-95418a57f2f6/snap','2025-11-29 08:53:14','2025-11-29 08:53:15','2025-11-29 08:53:15',1,'{\"store\": \"default_backend\"}','deleted'),(43,'9edb158f-7f78-4486-aa1c-e248407be0c7','rbd://38a37ed2-442a-5e0d-a69a-881fdd186450/images/9edb158f-7f78-4486-aa1c-e248407be0c7/snap','2025-11-29 09:11:38','2025-11-29 09:13:09','2025-11-29 09:13:09',1,'{\"store\": \"default_backend\"}','deleted');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=661 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'1be11678-cfa4-4dee-b54c-6c7e547e5a6a','hw_rng_model','virtio','2025-11-29 07:39:56','2025-11-29 07:39:56',NULL,0),(2,'ed489666-5fa2-4ea4-8005-7a7505ac1b78','hw_rng_model','virtio','2025-11-29 07:40:38','2025-11-29 07:40:38',NULL,0),(3,'73295910-5010-42bf-ac24-9ee2d7bb4671','hw_rng_model','virtio','2025-11-29 07:49:48','2025-11-29 07:50:36','2025-11-29 07:50:36',1),(4,'73295910-5010-42bf-ac24-9ee2d7bb4671','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 07:49:48','2025-11-29 07:50:36','2025-11-29 07:50:36',1),(5,'73295910-5010-42bf-ac24-9ee2d7bb4671','owner_user_name','tempest-UnshelveToHostMultiNodesTest-155692188-project-member','2025-11-29 07:49:48','2025-11-29 07:50:36','2025-11-29 07:50:36',1),(6,'73295910-5010-42bf-ac24-9ee2d7bb4671','owner_project_name','tempest-UnshelveToHostMultiNodesTest-155692188','2025-11-29 07:49:48','2025-11-29 07:50:36','2025-11-29 07:50:36',1),(7,'73295910-5010-42bf-ac24-9ee2d7bb4671','boot_roles','reader,member','2025-11-29 07:49:48','2025-11-29 07:50:36','2025-11-29 07:50:36',1),(8,'73295910-5010-42bf-ac24-9ee2d7bb4671','hw_machine_type','q35','2025-11-29 07:49:48','2025-11-29 07:50:36','2025-11-29 07:50:36',1),(9,'73295910-5010-42bf-ac24-9ee2d7bb4671','hw_cdrom_bus','sata','2025-11-29 07:49:48','2025-11-29 07:50:36','2025-11-29 07:50:36',1),(10,'73295910-5010-42bf-ac24-9ee2d7bb4671','hw_disk_bus','virtio','2025-11-29 07:49:48','2025-11-29 07:50:36','2025-11-29 07:50:36',1),(11,'73295910-5010-42bf-ac24-9ee2d7bb4671','hw_input_bus','usb','2025-11-29 07:49:48','2025-11-29 07:50:36','2025-11-29 07:50:36',1),(12,'73295910-5010-42bf-ac24-9ee2d7bb4671','hw_pointer_model','usbtablet','2025-11-29 07:49:48','2025-11-29 07:50:36','2025-11-29 07:50:36',1),(13,'73295910-5010-42bf-ac24-9ee2d7bb4671','hw_video_model','virtio','2025-11-29 07:49:48','2025-11-29 07:50:36','2025-11-29 07:50:36',1),(14,'73295910-5010-42bf-ac24-9ee2d7bb4671','hw_vif_model','virtio','2025-11-29 07:49:48','2025-11-29 07:50:36','2025-11-29 07:50:36',1),(15,'73295910-5010-42bf-ac24-9ee2d7bb4671','instance_uuid','d278aa2a-e5e7-4f89-8b5c-b6dca172b57d','2025-11-29 07:49:48','2025-11-29 07:50:36','2025-11-29 07:50:36',1),(16,'73295910-5010-42bf-ac24-9ee2d7bb4671','user_id','ed57e094b4c4441c8ffbfb96ecb62afc','2025-11-29 07:49:48','2025-11-29 07:50:36','2025-11-29 07:50:36',1),(17,'73295910-5010-42bf-ac24-9ee2d7bb4671','image_type','snapshot','2025-11-29 07:49:48','2025-11-29 07:50:36','2025-11-29 07:50:36',1),(18,'73295910-5010-42bf-ac24-9ee2d7bb4671','image_location','snapshot','2025-11-29 07:50:22','2025-11-29 07:50:36','2025-11-29 07:50:36',1),(19,'73295910-5010-42bf-ac24-9ee2d7bb4671','image_state','available','2025-11-29 07:50:22','2025-11-29 07:50:36','2025-11-29 07:50:36',1),(20,'73295910-5010-42bf-ac24-9ee2d7bb4671','owner_id','cf226b9a5bb945c3a8f54976b5736fe3','2025-11-29 07:50:22','2025-11-29 07:50:36','2025-11-29 07:50:36',1),(21,'33939db1-a4ae-4fac-9a69-88ed807d304b','hw_rng_model','virtio','2025-11-29 07:50:38','2025-11-29 07:51:37','2025-11-29 07:51:37',1),(22,'33939db1-a4ae-4fac-9a69-88ed807d304b','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 07:50:38','2025-11-29 07:51:37','2025-11-29 07:51:37',1),(23,'33939db1-a4ae-4fac-9a69-88ed807d304b','owner_user_name','tempest-UnshelveToHostMultiNodesTest-155692188-project-member','2025-11-29 07:50:38','2025-11-29 07:51:37','2025-11-29 07:51:37',1),(24,'33939db1-a4ae-4fac-9a69-88ed807d304b','owner_project_name','tempest-UnshelveToHostMultiNodesTest-155692188','2025-11-29 07:50:38','2025-11-29 07:51:37','2025-11-29 07:51:37',1),(25,'33939db1-a4ae-4fac-9a69-88ed807d304b','boot_roles','reader,member','2025-11-29 07:50:38','2025-11-29 07:51:37','2025-11-29 07:51:37',1),(26,'33939db1-a4ae-4fac-9a69-88ed807d304b','hw_machine_type','q35','2025-11-29 07:50:38','2025-11-29 07:51:37','2025-11-29 07:51:37',1),(27,'33939db1-a4ae-4fac-9a69-88ed807d304b','hw_cdrom_bus','sata','2025-11-29 07:50:38','2025-11-29 07:51:37','2025-11-29 07:51:37',1),(28,'33939db1-a4ae-4fac-9a69-88ed807d304b','hw_disk_bus','virtio','2025-11-29 07:50:38','2025-11-29 07:51:37','2025-11-29 07:51:37',1),(29,'33939db1-a4ae-4fac-9a69-88ed807d304b','hw_input_bus','usb','2025-11-29 07:50:38','2025-11-29 07:51:37','2025-11-29 07:51:37',1),(30,'33939db1-a4ae-4fac-9a69-88ed807d304b','hw_pointer_model','usbtablet','2025-11-29 07:50:38','2025-11-29 07:51:37','2025-11-29 07:51:37',1),(31,'33939db1-a4ae-4fac-9a69-88ed807d304b','hw_video_model','virtio','2025-11-29 07:50:38','2025-11-29 07:51:37','2025-11-29 07:51:37',1),(32,'33939db1-a4ae-4fac-9a69-88ed807d304b','hw_vif_model','virtio','2025-11-29 07:50:38','2025-11-29 07:51:37','2025-11-29 07:51:37',1),(33,'33939db1-a4ae-4fac-9a69-88ed807d304b','clean_attempts','1','2025-11-29 07:50:38','2025-11-29 07:51:37','2025-11-29 07:51:37',1),(34,'33939db1-a4ae-4fac-9a69-88ed807d304b','instance_uuid','d278aa2a-e5e7-4f89-8b5c-b6dca172b57d','2025-11-29 07:50:38','2025-11-29 07:51:37','2025-11-29 07:51:37',1),(35,'33939db1-a4ae-4fac-9a69-88ed807d304b','user_id','ed57e094b4c4441c8ffbfb96ecb62afc','2025-11-29 07:50:38','2025-11-29 07:51:37','2025-11-29 07:51:37',1),(36,'33939db1-a4ae-4fac-9a69-88ed807d304b','image_type','snapshot','2025-11-29 07:50:38','2025-11-29 07:51:37','2025-11-29 07:51:37',1),(37,'33939db1-a4ae-4fac-9a69-88ed807d304b','image_location','snapshot','2025-11-29 07:51:03','2025-11-29 07:51:37','2025-11-29 07:51:37',1),(38,'33939db1-a4ae-4fac-9a69-88ed807d304b','image_state','available','2025-11-29 07:51:03','2025-11-29 07:51:37','2025-11-29 07:51:37',1),(39,'33939db1-a4ae-4fac-9a69-88ed807d304b','owner_id','cf226b9a5bb945c3a8f54976b5736fe3','2025-11-29 07:51:03','2025-11-29 07:51:37','2025-11-29 07:51:37',1),(40,'67b4b12c-5f96-4d5d-a734-669efbd0af6b','hw_scsi_model','virtio-scsi','2025-11-29 07:54:16','2025-11-29 07:55:51','2025-11-29 07:55:51',1),(41,'67b4b12c-5f96-4d5d-a734-669efbd0af6b','hw_disk_bus','scsi','2025-11-29 07:54:16','2025-11-29 07:55:51','2025-11-29 07:55:51',1),(42,'67b4b12c-5f96-4d5d-a734-669efbd0af6b','hw_cdrom_bus','scsi','2025-11-29 07:54:16','2025-11-29 07:55:51','2025-11-29 07:55:51',1),(43,'7125fca0-e10e-42cb-acad-616c180d5096','hw_rng_model','virtio','2025-11-29 07:54:18','2025-11-29 07:54:39','2025-11-29 07:54:39',1),(44,'7125fca0-e10e-42cb-acad-616c180d5096','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 07:54:18','2025-11-29 07:54:39','2025-11-29 07:54:39',1),(45,'7125fca0-e10e-42cb-acad-616c180d5096','owner_user_name','tempest-ImagesOneServerTestJSON-2038682252-project-member','2025-11-29 07:54:18','2025-11-29 07:54:39','2025-11-29 07:54:39',1),(46,'7125fca0-e10e-42cb-acad-616c180d5096','owner_project_name','tempest-ImagesOneServerTestJSON-2038682252','2025-11-29 07:54:18','2025-11-29 07:54:39','2025-11-29 07:54:39',1),(47,'7125fca0-e10e-42cb-acad-616c180d5096','boot_roles','member,reader','2025-11-29 07:54:18','2025-11-29 07:54:39','2025-11-29 07:54:39',1),(48,'7125fca0-e10e-42cb-acad-616c180d5096','hw_machine_type','q35','2025-11-29 07:54:18','2025-11-29 07:54:39','2025-11-29 07:54:39',1),(49,'7125fca0-e10e-42cb-acad-616c180d5096','hw_cdrom_bus','sata','2025-11-29 07:54:18','2025-11-29 07:54:39','2025-11-29 07:54:39',1),(50,'7125fca0-e10e-42cb-acad-616c180d5096','hw_disk_bus','virtio','2025-11-29 07:54:18','2025-11-29 07:54:39','2025-11-29 07:54:39',1),(51,'7125fca0-e10e-42cb-acad-616c180d5096','hw_input_bus','usb','2025-11-29 07:54:18','2025-11-29 07:54:39','2025-11-29 07:54:39',1),(52,'7125fca0-e10e-42cb-acad-616c180d5096','hw_pointer_model','usbtablet','2025-11-29 07:54:18','2025-11-29 07:54:39','2025-11-29 07:54:39',1),(53,'7125fca0-e10e-42cb-acad-616c180d5096','hw_video_model','virtio','2025-11-29 07:54:18','2025-11-29 07:54:39','2025-11-29 07:54:39',1),(54,'7125fca0-e10e-42cb-acad-616c180d5096','hw_vif_model','virtio','2025-11-29 07:54:18','2025-11-29 07:54:39','2025-11-29 07:54:39',1),(55,'7125fca0-e10e-42cb-acad-616c180d5096','instance_uuid','9554d48d-d298-43f9-a68d-c8f52fe2cc33','2025-11-29 07:54:18','2025-11-29 07:54:39','2025-11-29 07:54:39',1),(56,'7125fca0-e10e-42cb-acad-616c180d5096','user_id','3905209925cd414980eac7c79bf04af2','2025-11-29 07:54:18','2025-11-29 07:54:39','2025-11-29 07:54:39',1),(57,'7125fca0-e10e-42cb-acad-616c180d5096','image_type','test','2025-11-29 07:54:18','2025-11-29 07:54:39','2025-11-29 07:54:39',1),(58,'7125fca0-e10e-42cb-acad-616c180d5096','image_state','available','2025-11-29 07:54:23','2025-11-29 07:54:39','2025-11-29 07:54:39',1),(59,'7125fca0-e10e-42cb-acad-616c180d5096','owner_id','e6ba183d92db4c6795dd0f44dc77fad4','2025-11-29 07:54:23','2025-11-29 07:54:39','2025-11-29 07:54:39',1),(60,'7125fca0-e10e-42cb-acad-616c180d5096','image_location','snapshot','2025-11-29 07:54:23','2025-11-29 07:54:39','2025-11-29 07:54:39',1),(61,'2c100ba6-aad9-4f8a-a5b0-c35f5675fe20','hw_rng_model','virtio','2025-11-29 07:54:40','2025-11-29 07:55:01','2025-11-29 07:55:01',1),(62,'2c100ba6-aad9-4f8a-a5b0-c35f5675fe20','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 07:54:40','2025-11-29 07:55:01','2025-11-29 07:55:01',1),(63,'2c100ba6-aad9-4f8a-a5b0-c35f5675fe20','owner_user_name','tempest-ImagesOneServerTestJSON-2038682252-project-member','2025-11-29 07:54:40','2025-11-29 07:55:01','2025-11-29 07:55:01',1),(64,'2c100ba6-aad9-4f8a-a5b0-c35f5675fe20','owner_project_name','tempest-ImagesOneServerTestJSON-2038682252','2025-11-29 07:54:40','2025-11-29 07:55:01','2025-11-29 07:55:01',1),(65,'2c100ba6-aad9-4f8a-a5b0-c35f5675fe20','boot_roles','member,reader','2025-11-29 07:54:40','2025-11-29 07:55:01','2025-11-29 07:55:01',1),(66,'2c100ba6-aad9-4f8a-a5b0-c35f5675fe20','hw_machine_type','q35','2025-11-29 07:54:40','2025-11-29 07:55:01','2025-11-29 07:55:01',1),(67,'2c100ba6-aad9-4f8a-a5b0-c35f5675fe20','hw_cdrom_bus','sata','2025-11-29 07:54:40','2025-11-29 07:55:01','2025-11-29 07:55:01',1),(68,'2c100ba6-aad9-4f8a-a5b0-c35f5675fe20','hw_disk_bus','virtio','2025-11-29 07:54:40','2025-11-29 07:55:01','2025-11-29 07:55:01',1),(69,'2c100ba6-aad9-4f8a-a5b0-c35f5675fe20','hw_input_bus','usb','2025-11-29 07:54:40','2025-11-29 07:55:01','2025-11-29 07:55:01',1),(70,'2c100ba6-aad9-4f8a-a5b0-c35f5675fe20','hw_pointer_model','usbtablet','2025-11-29 07:54:40','2025-11-29 07:55:01','2025-11-29 07:55:01',1),(71,'2c100ba6-aad9-4f8a-a5b0-c35f5675fe20','hw_video_model','virtio','2025-11-29 07:54:40','2025-11-29 07:55:01','2025-11-29 07:55:01',1),(72,'2c100ba6-aad9-4f8a-a5b0-c35f5675fe20','hw_vif_model','virtio','2025-11-29 07:54:40','2025-11-29 07:55:01','2025-11-29 07:55:01',1),(73,'2c100ba6-aad9-4f8a-a5b0-c35f5675fe20','instance_uuid','9554d48d-d298-43f9-a68d-c8f52fe2cc33','2025-11-29 07:54:40','2025-11-29 07:55:01','2025-11-29 07:55:01',1),(74,'2c100ba6-aad9-4f8a-a5b0-c35f5675fe20','user_id','3905209925cd414980eac7c79bf04af2','2025-11-29 07:54:40','2025-11-29 07:55:01','2025-11-29 07:55:01',1),(75,'2c100ba6-aad9-4f8a-a5b0-c35f5675fe20','image_type','snapshot','2025-11-29 07:54:40','2025-11-29 07:55:01','2025-11-29 07:55:01',1),(76,'2c100ba6-aad9-4f8a-a5b0-c35f5675fe20','image_state','available','2025-11-29 07:54:49','2025-11-29 07:55:01','2025-11-29 07:55:01',1),(77,'2c100ba6-aad9-4f8a-a5b0-c35f5675fe20','owner_id','e6ba183d92db4c6795dd0f44dc77fad4','2025-11-29 07:54:49','2025-11-29 07:55:01','2025-11-29 07:55:01',1),(78,'2c100ba6-aad9-4f8a-a5b0-c35f5675fe20','image_location','snapshot','2025-11-29 07:54:49','2025-11-29 07:55:01','2025-11-29 07:55:01',1),(79,'58caa074-39ec-4b44-8c78-60814a120dd3','hw_rng_model','virtio','2025-11-29 07:55:57','2025-11-29 07:55:57','2025-11-29 07:55:57',1),(80,'58caa074-39ec-4b44-8c78-60814a120dd3','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 07:55:57','2025-11-29 07:55:57','2025-11-29 07:55:57',1),(81,'58caa074-39ec-4b44-8c78-60814a120dd3','owner_user_name','tempest-ImagesOneServerNegativeTestJSON-267959441-project-member','2025-11-29 07:55:57','2025-11-29 07:55:57','2025-11-29 07:55:57',1),(82,'58caa074-39ec-4b44-8c78-60814a120dd3','owner_project_name','tempest-ImagesOneServerNegativeTestJSON-267959441','2025-11-29 07:55:57','2025-11-29 07:55:57','2025-11-29 07:55:57',1),(83,'58caa074-39ec-4b44-8c78-60814a120dd3','boot_roles','member,reader','2025-11-29 07:55:57','2025-11-29 07:55:57','2025-11-29 07:55:57',1),(84,'58caa074-39ec-4b44-8c78-60814a120dd3','hw_machine_type','q35','2025-11-29 07:55:57','2025-11-29 07:55:57','2025-11-29 07:55:57',1),(85,'58caa074-39ec-4b44-8c78-60814a120dd3','hw_cdrom_bus','sata','2025-11-29 07:55:57','2025-11-29 07:55:57','2025-11-29 07:55:57',1),(86,'58caa074-39ec-4b44-8c78-60814a120dd3','hw_disk_bus','virtio','2025-11-29 07:55:57','2025-11-29 07:55:57','2025-11-29 07:55:57',1),(87,'58caa074-39ec-4b44-8c78-60814a120dd3','hw_input_bus','usb','2025-11-29 07:55:57','2025-11-29 07:55:57','2025-11-29 07:55:57',1),(88,'58caa074-39ec-4b44-8c78-60814a120dd3','hw_pointer_model','usbtablet','2025-11-29 07:55:57','2025-11-29 07:55:57','2025-11-29 07:55:57',1),(89,'58caa074-39ec-4b44-8c78-60814a120dd3','hw_video_model','virtio','2025-11-29 07:55:57','2025-11-29 07:55:57','2025-11-29 07:55:57',1),(90,'58caa074-39ec-4b44-8c78-60814a120dd3','hw_vif_model','virtio','2025-11-29 07:55:57','2025-11-29 07:55:57','2025-11-29 07:55:57',1),(91,'58caa074-39ec-4b44-8c78-60814a120dd3','instance_uuid','a97f7448-7bd5-4505-abcd-8f4e247b9469','2025-11-29 07:55:57','2025-11-29 07:55:57','2025-11-29 07:55:57',1),(92,'58caa074-39ec-4b44-8c78-60814a120dd3','user_id','dbeeaca97c3e4a1b9417ab3e996f721f','2025-11-29 07:55:57','2025-11-29 07:55:57','2025-11-29 07:55:57',1),(93,'58caa074-39ec-4b44-8c78-60814a120dd3','image_type','snapshot','2025-11-29 07:55:57','2025-11-29 07:55:57','2025-11-29 07:55:57',1),(94,'4997c363-307f-4918-8be4-b61ff6b9c1ff','hw_rng_model','virtio','2025-11-29 07:56:35','2025-11-29 07:56:35','2025-11-29 07:56:35',1),(95,'4997c363-307f-4918-8be4-b61ff6b9c1ff','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 07:56:35','2025-11-29 07:56:35','2025-11-29 07:56:35',1),(96,'4997c363-307f-4918-8be4-b61ff6b9c1ff','owner_user_name','tempest-ImagesOneServerNegativeTestJSON-267959441-project-member','2025-11-29 07:56:35','2025-11-29 07:56:35','2025-11-29 07:56:35',1),(97,'4997c363-307f-4918-8be4-b61ff6b9c1ff','owner_project_name','tempest-ImagesOneServerNegativeTestJSON-267959441','2025-11-29 07:56:35','2025-11-29 07:56:35','2025-11-29 07:56:35',1),(98,'4997c363-307f-4918-8be4-b61ff6b9c1ff','boot_roles','member,reader','2025-11-29 07:56:35','2025-11-29 07:56:35','2025-11-29 07:56:35',1),(99,'4997c363-307f-4918-8be4-b61ff6b9c1ff','hw_machine_type','q35','2025-11-29 07:56:35','2025-11-29 07:56:35','2025-11-29 07:56:35',1),(100,'4997c363-307f-4918-8be4-b61ff6b9c1ff','hw_cdrom_bus','sata','2025-11-29 07:56:35','2025-11-29 07:56:35','2025-11-29 07:56:35',1),(101,'4997c363-307f-4918-8be4-b61ff6b9c1ff','hw_disk_bus','virtio','2025-11-29 07:56:35','2025-11-29 07:56:35','2025-11-29 07:56:35',1),(102,'4997c363-307f-4918-8be4-b61ff6b9c1ff','hw_input_bus','usb','2025-11-29 07:56:35','2025-11-29 07:56:35','2025-11-29 07:56:35',1),(103,'4997c363-307f-4918-8be4-b61ff6b9c1ff','hw_pointer_model','usbtablet','2025-11-29 07:56:35','2025-11-29 07:56:35','2025-11-29 07:56:35',1),(104,'4997c363-307f-4918-8be4-b61ff6b9c1ff','hw_video_model','virtio','2025-11-29 07:56:35','2025-11-29 07:56:35','2025-11-29 07:56:35',1),(105,'4997c363-307f-4918-8be4-b61ff6b9c1ff','hw_vif_model','virtio','2025-11-29 07:56:35','2025-11-29 07:56:35','2025-11-29 07:56:35',1),(106,'4997c363-307f-4918-8be4-b61ff6b9c1ff','instance_uuid','713e0825-1b56-4572-a0bd-817359261afe','2025-11-29 07:56:35','2025-11-29 07:56:35','2025-11-29 07:56:35',1),(107,'4997c363-307f-4918-8be4-b61ff6b9c1ff','user_id','dbeeaca97c3e4a1b9417ab3e996f721f','2025-11-29 07:56:35','2025-11-29 07:56:35','2025-11-29 07:56:35',1),(108,'4997c363-307f-4918-8be4-b61ff6b9c1ff','image_type','snapshot','2025-11-29 07:56:35','2025-11-29 07:56:35','2025-11-29 07:56:35',1),(109,'68d9094a-a514-4c4f-a0d2-50c99d09fcfc','os_version','alt1','2025-11-29 07:56:55','2025-11-29 07:57:14','2025-11-29 07:57:14',1),(110,'68d9094a-a514-4c4f-a0d2-50c99d09fcfc','os_distro','value2','2025-11-29 07:56:55','2025-11-29 07:57:14','2025-11-29 07:57:14',1),(111,'68d9094a-a514-4c4f-a0d2-50c99d09fcfc','architecture','value3','2025-11-29 07:57:04','2025-11-29 07:57:14','2025-11-29 07:57:14',1),(112,'e89bf772-b42e-4a81-949b-a562a33a3e0c','hw_rng_model','virtio','2025-11-29 07:57:45','2025-11-29 07:58:48','2025-11-29 07:58:48',1),(113,'e89bf772-b42e-4a81-949b-a562a33a3e0c','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 07:57:45','2025-11-29 07:58:48','2025-11-29 07:58:48',1),(114,'e89bf772-b42e-4a81-949b-a562a33a3e0c','owner_user_name','tempest-ListImageFiltersTestJSON-667978844-project-member','2025-11-29 07:57:45','2025-11-29 07:58:48','2025-11-29 07:58:48',1),(115,'e89bf772-b42e-4a81-949b-a562a33a3e0c','owner_project_name','tempest-ListImageFiltersTestJSON-667978844','2025-11-29 07:57:45','2025-11-29 07:58:48','2025-11-29 07:58:48',1),(116,'e89bf772-b42e-4a81-949b-a562a33a3e0c','boot_roles','member,reader','2025-11-29 07:57:45','2025-11-29 07:58:48','2025-11-29 07:58:48',1),(117,'e89bf772-b42e-4a81-949b-a562a33a3e0c','hw_machine_type','q35','2025-11-29 07:57:45','2025-11-29 07:58:48','2025-11-29 07:58:48',1),(118,'e89bf772-b42e-4a81-949b-a562a33a3e0c','hw_cdrom_bus','sata','2025-11-29 07:57:45','2025-11-29 07:58:48','2025-11-29 07:58:48',1),(119,'e89bf772-b42e-4a81-949b-a562a33a3e0c','hw_disk_bus','virtio','2025-11-29 07:57:45','2025-11-29 07:58:48','2025-11-29 07:58:48',1),(120,'e89bf772-b42e-4a81-949b-a562a33a3e0c','hw_input_bus','usb','2025-11-29 07:57:45','2025-11-29 07:58:48','2025-11-29 07:58:48',1),(121,'e89bf772-b42e-4a81-949b-a562a33a3e0c','hw_pointer_model','usbtablet','2025-11-29 07:57:45','2025-11-29 07:58:48','2025-11-29 07:58:48',1),(122,'e89bf772-b42e-4a81-949b-a562a33a3e0c','hw_video_model','virtio','2025-11-29 07:57:45','2025-11-29 07:58:48','2025-11-29 07:58:48',1),(123,'e89bf772-b42e-4a81-949b-a562a33a3e0c','hw_vif_model','virtio','2025-11-29 07:57:45','2025-11-29 07:58:48','2025-11-29 07:58:48',1),(124,'e89bf772-b42e-4a81-949b-a562a33a3e0c','instance_uuid','a371a1b6-e687-429a-a4d8-338fe777c73e','2025-11-29 07:57:45','2025-11-29 07:58:48','2025-11-29 07:58:48',1),(125,'e89bf772-b42e-4a81-949b-a562a33a3e0c','user_id','c2aeea466c9049d3a023483ec2e5b4f6','2025-11-29 07:57:45','2025-11-29 07:58:48','2025-11-29 07:58:48',1),(126,'e89bf772-b42e-4a81-949b-a562a33a3e0c','image_type','snapshot','2025-11-29 07:57:45','2025-11-29 07:58:48','2025-11-29 07:58:48',1),(127,'e89bf772-b42e-4a81-949b-a562a33a3e0c','owner_id','30d42ce85b6840c6942b24cf4a7b9d64','2025-11-29 07:57:49','2025-11-29 07:58:48','2025-11-29 07:58:48',1),(128,'e89bf772-b42e-4a81-949b-a562a33a3e0c','image_state','available','2025-11-29 07:57:49','2025-11-29 07:58:48','2025-11-29 07:58:48',1),(129,'e89bf772-b42e-4a81-949b-a562a33a3e0c','image_location','snapshot','2025-11-29 07:57:49','2025-11-29 07:58:48','2025-11-29 07:58:48',1),(130,'df78a6c7-19bb-4390-bc30-7251b87a9d47','hw_rng_model','virtio','2025-11-29 07:57:53','2025-11-29 07:58:45','2025-11-29 07:58:45',1),(131,'df78a6c7-19bb-4390-bc30-7251b87a9d47','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 07:57:53','2025-11-29 07:58:45','2025-11-29 07:58:45',1),(132,'df78a6c7-19bb-4390-bc30-7251b87a9d47','owner_user_name','tempest-ListImageFiltersTestJSON-667978844-project-member','2025-11-29 07:57:53','2025-11-29 07:58:45','2025-11-29 07:58:45',1),(133,'df78a6c7-19bb-4390-bc30-7251b87a9d47','owner_project_name','tempest-ListImageFiltersTestJSON-667978844','2025-11-29 07:57:53','2025-11-29 07:58:45','2025-11-29 07:58:45',1),(134,'df78a6c7-19bb-4390-bc30-7251b87a9d47','boot_roles','member,reader','2025-11-29 07:57:53','2025-11-29 07:58:45','2025-11-29 07:58:45',1),(135,'df78a6c7-19bb-4390-bc30-7251b87a9d47','hw_machine_type','q35','2025-11-29 07:57:53','2025-11-29 07:58:45','2025-11-29 07:58:45',1),(136,'df78a6c7-19bb-4390-bc30-7251b87a9d47','hw_cdrom_bus','sata','2025-11-29 07:57:53','2025-11-29 07:58:45','2025-11-29 07:58:45',1),(137,'df78a6c7-19bb-4390-bc30-7251b87a9d47','hw_disk_bus','virtio','2025-11-29 07:57:53','2025-11-29 07:58:45','2025-11-29 07:58:45',1),(138,'df78a6c7-19bb-4390-bc30-7251b87a9d47','hw_input_bus','usb','2025-11-29 07:57:53','2025-11-29 07:58:45','2025-11-29 07:58:45',1),(139,'df78a6c7-19bb-4390-bc30-7251b87a9d47','hw_pointer_model','usbtablet','2025-11-29 07:57:53','2025-11-29 07:58:45','2025-11-29 07:58:45',1),(140,'df78a6c7-19bb-4390-bc30-7251b87a9d47','hw_video_model','virtio','2025-11-29 07:57:53','2025-11-29 07:58:45','2025-11-29 07:58:45',1),(141,'df78a6c7-19bb-4390-bc30-7251b87a9d47','hw_vif_model','virtio','2025-11-29 07:57:53','2025-11-29 07:58:45','2025-11-29 07:58:45',1),(142,'df78a6c7-19bb-4390-bc30-7251b87a9d47','instance_uuid','a0ebd5be-6171-41dc-8014-4a7eee729935','2025-11-29 07:57:53','2025-11-29 07:58:45','2025-11-29 07:58:45',1),(143,'df78a6c7-19bb-4390-bc30-7251b87a9d47','user_id','c2aeea466c9049d3a023483ec2e5b4f6','2025-11-29 07:57:53','2025-11-29 07:58:45','2025-11-29 07:58:45',1),(144,'df78a6c7-19bb-4390-bc30-7251b87a9d47','image_type','snapshot','2025-11-29 07:57:53','2025-11-29 07:58:45','2025-11-29 07:58:45',1),(145,'df78a6c7-19bb-4390-bc30-7251b87a9d47','image_state','available','2025-11-29 07:58:04','2025-11-29 07:58:45','2025-11-29 07:58:45',1),(146,'df78a6c7-19bb-4390-bc30-7251b87a9d47','owner_id','30d42ce85b6840c6942b24cf4a7b9d64','2025-11-29 07:58:04','2025-11-29 07:58:45','2025-11-29 07:58:45',1),(147,'df78a6c7-19bb-4390-bc30-7251b87a9d47','image_location','snapshot','2025-11-29 07:58:04','2025-11-29 07:58:45','2025-11-29 07:58:45',1),(148,'49b84182-d6c5-4bdc-9e97-50145d5437cf','hw_rng_model','virtio','2025-11-29 07:58:04','2025-11-29 07:58:24','2025-11-29 07:58:24',1),(149,'49b84182-d6c5-4bdc-9e97-50145d5437cf','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 07:58:04','2025-11-29 07:58:24','2025-11-29 07:58:24',1),(150,'49b84182-d6c5-4bdc-9e97-50145d5437cf','owner_user_name','tempest-ImagesTestJSON-911260095-project-member','2025-11-29 07:58:04','2025-11-29 07:58:24','2025-11-29 07:58:24',1),(151,'49b84182-d6c5-4bdc-9e97-50145d5437cf','owner_project_name','tempest-ImagesTestJSON-911260095','2025-11-29 07:58:04','2025-11-29 07:58:24','2025-11-29 07:58:24',1),(152,'49b84182-d6c5-4bdc-9e97-50145d5437cf','boot_roles','member,reader','2025-11-29 07:58:04','2025-11-29 07:58:24','2025-11-29 07:58:24',1),(153,'49b84182-d6c5-4bdc-9e97-50145d5437cf','hw_machine_type','q35','2025-11-29 07:58:04','2025-11-29 07:58:24','2025-11-29 07:58:24',1),(154,'49b84182-d6c5-4bdc-9e97-50145d5437cf','hw_cdrom_bus','sata','2025-11-29 07:58:04','2025-11-29 07:58:24','2025-11-29 07:58:24',1),(155,'49b84182-d6c5-4bdc-9e97-50145d5437cf','hw_disk_bus','virtio','2025-11-29 07:58:04','2025-11-29 07:58:24','2025-11-29 07:58:24',1),(156,'49b84182-d6c5-4bdc-9e97-50145d5437cf','hw_input_bus','usb','2025-11-29 07:58:04','2025-11-29 07:58:24','2025-11-29 07:58:24',1),(157,'49b84182-d6c5-4bdc-9e97-50145d5437cf','hw_pointer_model','usbtablet','2025-11-29 07:58:04','2025-11-29 07:58:24','2025-11-29 07:58:24',1),(158,'49b84182-d6c5-4bdc-9e97-50145d5437cf','hw_video_model','virtio','2025-11-29 07:58:04','2025-11-29 07:58:24','2025-11-29 07:58:24',1),(159,'49b84182-d6c5-4bdc-9e97-50145d5437cf','hw_vif_model','virtio','2025-11-29 07:58:04','2025-11-29 07:58:24','2025-11-29 07:58:24',1),(160,'49b84182-d6c5-4bdc-9e97-50145d5437cf','instance_uuid','2f014f4f-f43f-49b3-93cf-1cc4aec2e8af','2025-11-29 07:58:04','2025-11-29 07:58:24','2025-11-29 07:58:24',1),(161,'49b84182-d6c5-4bdc-9e97-50145d5437cf','user_id','f7d59bea260d4752aa29379967636c0b','2025-11-29 07:58:04','2025-11-29 07:58:24','2025-11-29 07:58:24',1),(162,'49b84182-d6c5-4bdc-9e97-50145d5437cf','image_type','snapshot','2025-11-29 07:58:04','2025-11-29 07:58:24','2025-11-29 07:58:24',1),(163,'36972a45-a1b4-44eb-9fc1-abe990709f21','hw_rng_model','virtio','2025-11-29 07:58:08','2025-11-29 07:58:42','2025-11-29 07:58:42',1),(164,'36972a45-a1b4-44eb-9fc1-abe990709f21','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 07:58:08','2025-11-29 07:58:42','2025-11-29 07:58:42',1),(165,'36972a45-a1b4-44eb-9fc1-abe990709f21','owner_user_name','tempest-ListImageFiltersTestJSON-667978844-project-member','2025-11-29 07:58:08','2025-11-29 07:58:42','2025-11-29 07:58:42',1),(166,'36972a45-a1b4-44eb-9fc1-abe990709f21','owner_project_name','tempest-ListImageFiltersTestJSON-667978844','2025-11-29 07:58:08','2025-11-29 07:58:42','2025-11-29 07:58:42',1),(167,'36972a45-a1b4-44eb-9fc1-abe990709f21','boot_roles','member,reader','2025-11-29 07:58:08','2025-11-29 07:58:42','2025-11-29 07:58:42',1),(168,'36972a45-a1b4-44eb-9fc1-abe990709f21','hw_machine_type','q35','2025-11-29 07:58:08','2025-11-29 07:58:42','2025-11-29 07:58:42',1),(169,'36972a45-a1b4-44eb-9fc1-abe990709f21','hw_cdrom_bus','sata','2025-11-29 07:58:08','2025-11-29 07:58:42','2025-11-29 07:58:42',1),(170,'36972a45-a1b4-44eb-9fc1-abe990709f21','hw_disk_bus','virtio','2025-11-29 07:58:08','2025-11-29 07:58:42','2025-11-29 07:58:42',1),(171,'36972a45-a1b4-44eb-9fc1-abe990709f21','hw_input_bus','usb','2025-11-29 07:58:08','2025-11-29 07:58:42','2025-11-29 07:58:42',1),(172,'36972a45-a1b4-44eb-9fc1-abe990709f21','hw_pointer_model','usbtablet','2025-11-29 07:58:08','2025-11-29 07:58:42','2025-11-29 07:58:42',1),(173,'36972a45-a1b4-44eb-9fc1-abe990709f21','hw_video_model','virtio','2025-11-29 07:58:08','2025-11-29 07:58:42','2025-11-29 07:58:42',1),(174,'36972a45-a1b4-44eb-9fc1-abe990709f21','hw_vif_model','virtio','2025-11-29 07:58:08','2025-11-29 07:58:42','2025-11-29 07:58:42',1),(175,'36972a45-a1b4-44eb-9fc1-abe990709f21','instance_uuid','a371a1b6-e687-429a-a4d8-338fe777c73e','2025-11-29 07:58:08','2025-11-29 07:58:42','2025-11-29 07:58:42',1),(176,'36972a45-a1b4-44eb-9fc1-abe990709f21','user_id','c2aeea466c9049d3a023483ec2e5b4f6','2025-11-29 07:58:08','2025-11-29 07:58:42','2025-11-29 07:58:42',1),(177,'36972a45-a1b4-44eb-9fc1-abe990709f21','image_type','snapshot','2025-11-29 07:58:08','2025-11-29 07:58:42','2025-11-29 07:58:42',1),(178,'49b84182-d6c5-4bdc-9e97-50145d5437cf','image_location','snapshot','2025-11-29 07:58:15','2025-11-29 07:58:24','2025-11-29 07:58:24',1),(179,'49b84182-d6c5-4bdc-9e97-50145d5437cf','image_state','available','2025-11-29 07:58:15','2025-11-29 07:58:24','2025-11-29 07:58:24',1),(180,'49b84182-d6c5-4bdc-9e97-50145d5437cf','owner_id','4d8c5b7e3ca74bc1880eb616b04711f7','2025-11-29 07:58:15','2025-11-29 07:58:24','2025-11-29 07:58:24',1),(181,'36972a45-a1b4-44eb-9fc1-abe990709f21','owner_id','30d42ce85b6840c6942b24cf4a7b9d64','2025-11-29 07:58:16','2025-11-29 07:58:43','2025-11-29 07:58:43',1),(182,'36972a45-a1b4-44eb-9fc1-abe990709f21','image_state','available','2025-11-29 07:58:16','2025-11-29 07:58:43','2025-11-29 07:58:43',1),(183,'36972a45-a1b4-44eb-9fc1-abe990709f21','image_location','snapshot','2025-11-29 07:58:16','2025-11-29 07:58:43','2025-11-29 07:58:43',1),(184,'32b89eea-531a-4341-b175-80b921fa7805','hw_rng_model','virtio','2025-11-29 07:59:29','2025-11-29 07:59:49','2025-11-29 07:59:49',1),(185,'32b89eea-531a-4341-b175-80b921fa7805','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 07:59:29','2025-11-29 07:59:49','2025-11-29 07:59:49',1),(186,'32b89eea-531a-4341-b175-80b921fa7805','owner_user_name','tempest-ImagesTestJSON-911260095-project-member','2025-11-29 07:59:29','2025-11-29 07:59:49','2025-11-29 07:59:49',1),(187,'32b89eea-531a-4341-b175-80b921fa7805','owner_project_name','tempest-ImagesTestJSON-911260095','2025-11-29 07:59:29','2025-11-29 07:59:49','2025-11-29 07:59:49',1),(188,'32b89eea-531a-4341-b175-80b921fa7805','boot_roles','member,reader','2025-11-29 07:59:29','2025-11-29 07:59:49','2025-11-29 07:59:49',1),(189,'32b89eea-531a-4341-b175-80b921fa7805','hw_machine_type','q35','2025-11-29 07:59:29','2025-11-29 07:59:49','2025-11-29 07:59:49',1),(190,'32b89eea-531a-4341-b175-80b921fa7805','hw_cdrom_bus','sata','2025-11-29 07:59:29','2025-11-29 07:59:49','2025-11-29 07:59:49',1),(191,'32b89eea-531a-4341-b175-80b921fa7805','hw_disk_bus','virtio','2025-11-29 07:59:29','2025-11-29 07:59:49','2025-11-29 07:59:49',1),(192,'32b89eea-531a-4341-b175-80b921fa7805','hw_input_bus','usb','2025-11-29 07:59:29','2025-11-29 07:59:49','2025-11-29 07:59:49',1),(193,'32b89eea-531a-4341-b175-80b921fa7805','hw_pointer_model','usbtablet','2025-11-29 07:59:29','2025-11-29 07:59:49','2025-11-29 07:59:49',1),(194,'32b89eea-531a-4341-b175-80b921fa7805','hw_video_model','virtio','2025-11-29 07:59:29','2025-11-29 07:59:49','2025-11-29 07:59:49',1),(195,'32b89eea-531a-4341-b175-80b921fa7805','hw_vif_model','virtio','2025-11-29 07:59:29','2025-11-29 07:59:49','2025-11-29 07:59:49',1),(196,'32b89eea-531a-4341-b175-80b921fa7805','instance_uuid','f5073e59-05bc-46a4-8bf4-ebeb74ca389b','2025-11-29 07:59:29','2025-11-29 07:59:49','2025-11-29 07:59:49',1),(197,'32b89eea-531a-4341-b175-80b921fa7805','user_id','f7d59bea260d4752aa29379967636c0b','2025-11-29 07:59:29','2025-11-29 07:59:49','2025-11-29 07:59:49',1),(198,'32b89eea-531a-4341-b175-80b921fa7805','image_type','snapshot','2025-11-29 07:59:29','2025-11-29 07:59:49','2025-11-29 07:59:49',1),(199,'32b89eea-531a-4341-b175-80b921fa7805','image_location','snapshot','2025-11-29 07:59:41','2025-11-29 07:59:49','2025-11-29 07:59:49',1),(200,'32b89eea-531a-4341-b175-80b921fa7805','image_state','available','2025-11-29 07:59:41','2025-11-29 07:59:49','2025-11-29 07:59:49',1),(201,'32b89eea-531a-4341-b175-80b921fa7805','owner_id','4d8c5b7e3ca74bc1880eb616b04711f7','2025-11-29 07:59:41','2025-11-29 07:59:49','2025-11-29 07:59:49',1),(202,'5db9d02f-2f54-48e1-952b-46fcc86d3d02','hw_rng_model','virtio','2025-11-29 08:00:11','2025-11-29 08:00:21','2025-11-29 08:00:21',1),(203,'5db9d02f-2f54-48e1-952b-46fcc86d3d02','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 08:00:11','2025-11-29 08:00:21','2025-11-29 08:00:21',1),(204,'5db9d02f-2f54-48e1-952b-46fcc86d3d02','owner_user_name','tempest-ImagesTestJSON-911260095-project-member','2025-11-29 08:00:11','2025-11-29 08:00:21','2025-11-29 08:00:21',1),(205,'5db9d02f-2f54-48e1-952b-46fcc86d3d02','owner_project_name','tempest-ImagesTestJSON-911260095','2025-11-29 08:00:11','2025-11-29 08:00:21','2025-11-29 08:00:21',1),(206,'5db9d02f-2f54-48e1-952b-46fcc86d3d02','boot_roles','reader,member','2025-11-29 08:00:11','2025-11-29 08:00:21','2025-11-29 08:00:21',1),(207,'5db9d02f-2f54-48e1-952b-46fcc86d3d02','hw_machine_type','q35','2025-11-29 08:00:11','2025-11-29 08:00:21','2025-11-29 08:00:21',1),(208,'5db9d02f-2f54-48e1-952b-46fcc86d3d02','hw_cdrom_bus','sata','2025-11-29 08:00:11','2025-11-29 08:00:21','2025-11-29 08:00:21',1),(209,'5db9d02f-2f54-48e1-952b-46fcc86d3d02','hw_disk_bus','virtio','2025-11-29 08:00:11','2025-11-29 08:00:21','2025-11-29 08:00:21',1),(210,'5db9d02f-2f54-48e1-952b-46fcc86d3d02','hw_input_bus','usb','2025-11-29 08:00:11','2025-11-29 08:00:21','2025-11-29 08:00:21',1),(211,'5db9d02f-2f54-48e1-952b-46fcc86d3d02','hw_pointer_model','usbtablet','2025-11-29 08:00:11','2025-11-29 08:00:21','2025-11-29 08:00:21',1),(212,'5db9d02f-2f54-48e1-952b-46fcc86d3d02','hw_video_model','virtio','2025-11-29 08:00:11','2025-11-29 08:00:21','2025-11-29 08:00:21',1),(213,'5db9d02f-2f54-48e1-952b-46fcc86d3d02','hw_vif_model','virtio','2025-11-29 08:00:11','2025-11-29 08:00:21','2025-11-29 08:00:21',1),(214,'5db9d02f-2f54-48e1-952b-46fcc86d3d02','old_vm_state','active','2025-11-29 08:00:11','2025-11-29 08:00:21','2025-11-29 08:00:21',1),(215,'5db9d02f-2f54-48e1-952b-46fcc86d3d02','instance_uuid','3886780f-7115-4500-9cdd-6e5aae5d95f9','2025-11-29 08:00:11','2025-11-29 08:00:21','2025-11-29 08:00:21',1),(216,'5db9d02f-2f54-48e1-952b-46fcc86d3d02','user_id','f7d59bea260d4752aa29379967636c0b','2025-11-29 08:00:11','2025-11-29 08:00:21','2025-11-29 08:00:21',1),(217,'5db9d02f-2f54-48e1-952b-46fcc86d3d02','image_type','snapshot','2025-11-29 08:00:11','2025-11-29 08:00:21','2025-11-29 08:00:21',1),(218,'5db9d02f-2f54-48e1-952b-46fcc86d3d02','owner_id','4d8c5b7e3ca74bc1880eb616b04711f7','2025-11-29 08:00:17','2025-11-29 08:00:21','2025-11-29 08:00:21',1),(219,'5db9d02f-2f54-48e1-952b-46fcc86d3d02','image_state','available','2025-11-29 08:00:17','2025-11-29 08:00:21','2025-11-29 08:00:21',1),(220,'5db9d02f-2f54-48e1-952b-46fcc86d3d02','image_location','snapshot','2025-11-29 08:00:17','2025-11-29 08:00:21','2025-11-29 08:00:21',1),(221,'bb915321-974b-4310-80ce-22fe787becec','hw_rng_model','virtio','2025-11-29 08:00:39','2025-11-29 08:01:22','2025-11-29 08:01:22',1),(222,'bb915321-974b-4310-80ce-22fe787becec','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 08:00:39','2025-11-29 08:01:22','2025-11-29 08:01:22',1),(223,'bb915321-974b-4310-80ce-22fe787becec','owner_user_name','tempest-ImagesTestJSON-911260095-project-member','2025-11-29 08:00:39','2025-11-29 08:01:22','2025-11-29 08:01:22',1),(224,'bb915321-974b-4310-80ce-22fe787becec','owner_project_name','tempest-ImagesTestJSON-911260095','2025-11-29 08:00:39','2025-11-29 08:01:22','2025-11-29 08:01:22',1),(225,'bb915321-974b-4310-80ce-22fe787becec','boot_roles','reader,member','2025-11-29 08:00:39','2025-11-29 08:01:22','2025-11-29 08:01:22',1),(226,'bb915321-974b-4310-80ce-22fe787becec','hw_machine_type','q35','2025-11-29 08:00:39','2025-11-29 08:01:22','2025-11-29 08:01:22',1),(227,'bb915321-974b-4310-80ce-22fe787becec','hw_cdrom_bus','sata','2025-11-29 08:00:39','2025-11-29 08:01:22','2025-11-29 08:01:22',1),(228,'bb915321-974b-4310-80ce-22fe787becec','hw_disk_bus','virtio','2025-11-29 08:00:39','2025-11-29 08:01:22','2025-11-29 08:01:22',1),(229,'bb915321-974b-4310-80ce-22fe787becec','hw_input_bus','usb','2025-11-29 08:00:39','2025-11-29 08:01:22','2025-11-29 08:01:22',1),(230,'bb915321-974b-4310-80ce-22fe787becec','hw_pointer_model','usbtablet','2025-11-29 08:00:39','2025-11-29 08:01:22','2025-11-29 08:01:22',1),(231,'bb915321-974b-4310-80ce-22fe787becec','hw_video_model','virtio','2025-11-29 08:00:39','2025-11-29 08:01:22','2025-11-29 08:01:22',1),(232,'bb915321-974b-4310-80ce-22fe787becec','hw_vif_model','virtio','2025-11-29 08:00:39','2025-11-29 08:01:22','2025-11-29 08:01:22',1),(233,'bb915321-974b-4310-80ce-22fe787becec','instance_uuid','5f638465-c65b-4824-bedc-60f4b695402a','2025-11-29 08:00:39','2025-11-29 08:01:22','2025-11-29 08:01:22',1),(234,'bb915321-974b-4310-80ce-22fe787becec','user_id','f7d59bea260d4752aa29379967636c0b','2025-11-29 08:00:39','2025-11-29 08:01:22','2025-11-29 08:01:22',1),(235,'bb915321-974b-4310-80ce-22fe787becec','image_type','snapshot','2025-11-29 08:00:39','2025-11-29 08:01:22','2025-11-29 08:01:22',1),(236,'bb915321-974b-4310-80ce-22fe787becec','image_state','available','2025-11-29 08:00:54','2025-11-29 08:01:22','2025-11-29 08:01:22',1),(237,'bb915321-974b-4310-80ce-22fe787becec','owner_id','4d8c5b7e3ca74bc1880eb616b04711f7','2025-11-29 08:00:54','2025-11-29 08:01:22','2025-11-29 08:01:22',1),(238,'bb915321-974b-4310-80ce-22fe787becec','image_location','snapshot','2025-11-29 08:00:54','2025-11-29 08:01:22','2025-11-29 08:01:22',1),(239,'4e6c48a5-2a39-4c6b-9d29-a38ef7a8b4b6','hw_rng_model','virtio','2025-11-29 08:01:47','2025-11-29 08:01:51','2025-11-29 08:01:51',1),(240,'4e6c48a5-2a39-4c6b-9d29-a38ef7a8b4b6','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 08:01:47','2025-11-29 08:01:51','2025-11-29 08:01:51',1),(241,'4e6c48a5-2a39-4c6b-9d29-a38ef7a8b4b6','owner_user_name','tempest-ImagesTestJSON-911260095-project-member','2025-11-29 08:01:47','2025-11-29 08:01:51','2025-11-29 08:01:51',1),(242,'4e6c48a5-2a39-4c6b-9d29-a38ef7a8b4b6','owner_project_name','tempest-ImagesTestJSON-911260095','2025-11-29 08:01:47','2025-11-29 08:01:51','2025-11-29 08:01:51',1),(243,'4e6c48a5-2a39-4c6b-9d29-a38ef7a8b4b6','boot_roles','reader,member','2025-11-29 08:01:47','2025-11-29 08:01:51','2025-11-29 08:01:51',1),(244,'4e6c48a5-2a39-4c6b-9d29-a38ef7a8b4b6','hw_machine_type','q35','2025-11-29 08:01:47','2025-11-29 08:01:51','2025-11-29 08:01:51',1),(245,'4e6c48a5-2a39-4c6b-9d29-a38ef7a8b4b6','hw_cdrom_bus','sata','2025-11-29 08:01:47','2025-11-29 08:01:51','2025-11-29 08:01:51',1),(246,'4e6c48a5-2a39-4c6b-9d29-a38ef7a8b4b6','hw_disk_bus','virtio','2025-11-29 08:01:47','2025-11-29 08:01:51','2025-11-29 08:01:51',1),(247,'4e6c48a5-2a39-4c6b-9d29-a38ef7a8b4b6','hw_input_bus','usb','2025-11-29 08:01:47','2025-11-29 08:01:51','2025-11-29 08:01:51',1),(248,'4e6c48a5-2a39-4c6b-9d29-a38ef7a8b4b6','hw_pointer_model','usbtablet','2025-11-29 08:01:47','2025-11-29 08:01:51','2025-11-29 08:01:51',1),(249,'4e6c48a5-2a39-4c6b-9d29-a38ef7a8b4b6','hw_video_model','virtio','2025-11-29 08:01:47','2025-11-29 08:01:51','2025-11-29 08:01:51',1),(250,'4e6c48a5-2a39-4c6b-9d29-a38ef7a8b4b6','hw_vif_model','virtio','2025-11-29 08:01:47','2025-11-29 08:01:51','2025-11-29 08:01:51',1),(251,'4e6c48a5-2a39-4c6b-9d29-a38ef7a8b4b6','instance_uuid','441c7c0c-4457-414d-8c62-68dda0364b56','2025-11-29 08:01:47','2025-11-29 08:01:52','2025-11-29 08:01:52',1),(252,'4e6c48a5-2a39-4c6b-9d29-a38ef7a8b4b6','user_id','f7d59bea260d4752aa29379967636c0b','2025-11-29 08:01:47','2025-11-29 08:01:52','2025-11-29 08:01:52',1),(253,'4e6c48a5-2a39-4c6b-9d29-a38ef7a8b4b6','image_type','snapshot','2025-11-29 08:01:47','2025-11-29 08:01:52','2025-11-29 08:01:52',1),(254,'79df671d-c55d-4ae7-bed4-66b1126df827','hw_rng_model','virtio','2025-11-29 08:04:10','2025-11-29 08:04:39','2025-11-29 08:04:39',1),(255,'79df671d-c55d-4ae7-bed4-66b1126df827','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 08:04:10','2025-11-29 08:04:39','2025-11-29 08:04:39',1),(256,'79df671d-c55d-4ae7-bed4-66b1126df827','owner_user_name','tempest-DeleteServersTestJSON-69711189-project-member','2025-11-29 08:04:10','2025-11-29 08:04:39','2025-11-29 08:04:39',1),(257,'79df671d-c55d-4ae7-bed4-66b1126df827','owner_project_name','tempest-DeleteServersTestJSON-69711189','2025-11-29 08:04:10','2025-11-29 08:04:39','2025-11-29 08:04:39',1),(258,'79df671d-c55d-4ae7-bed4-66b1126df827','boot_roles','member,reader','2025-11-29 08:04:10','2025-11-29 08:04:39','2025-11-29 08:04:39',1),(259,'79df671d-c55d-4ae7-bed4-66b1126df827','hw_machine_type','q35','2025-11-29 08:04:10','2025-11-29 08:04:39','2025-11-29 08:04:39',1),(260,'79df671d-c55d-4ae7-bed4-66b1126df827','hw_cdrom_bus','sata','2025-11-29 08:04:10','2025-11-29 08:04:39','2025-11-29 08:04:39',1),(261,'79df671d-c55d-4ae7-bed4-66b1126df827','hw_disk_bus','virtio','2025-11-29 08:04:10','2025-11-29 08:04:39','2025-11-29 08:04:39',1),(262,'79df671d-c55d-4ae7-bed4-66b1126df827','hw_input_bus','usb','2025-11-29 08:04:10','2025-11-29 08:04:39','2025-11-29 08:04:39',1),(263,'79df671d-c55d-4ae7-bed4-66b1126df827','hw_pointer_model','usbtablet','2025-11-29 08:04:10','2025-11-29 08:04:39','2025-11-29 08:04:39',1),(264,'79df671d-c55d-4ae7-bed4-66b1126df827','hw_video_model','virtio','2025-11-29 08:04:10','2025-11-29 08:04:39','2025-11-29 08:04:39',1),(265,'79df671d-c55d-4ae7-bed4-66b1126df827','hw_vif_model','virtio','2025-11-29 08:04:10','2025-11-29 08:04:39','2025-11-29 08:04:39',1),(266,'79df671d-c55d-4ae7-bed4-66b1126df827','instance_uuid','5ae9fe1c-0566-4112-ac09-e04deb899d41','2025-11-29 08:04:10','2025-11-29 08:04:39','2025-11-29 08:04:39',1),(267,'79df671d-c55d-4ae7-bed4-66b1126df827','user_id','ef8e9cc962eb4827954df3c42cc34798','2025-11-29 08:04:10','2025-11-29 08:04:39','2025-11-29 08:04:39',1),(268,'79df671d-c55d-4ae7-bed4-66b1126df827','image_type','snapshot','2025-11-29 08:04:10','2025-11-29 08:04:39','2025-11-29 08:04:39',1),(269,'79df671d-c55d-4ae7-bed4-66b1126df827','owner_id','f8bc2a2616a34ba1a18b3211e406993f','2025-11-29 08:04:30','2025-11-29 08:04:39','2025-11-29 08:04:39',1),(270,'79df671d-c55d-4ae7-bed4-66b1126df827','image_state','available','2025-11-29 08:04:30','2025-11-29 08:04:39','2025-11-29 08:04:39',1),(271,'79df671d-c55d-4ae7-bed4-66b1126df827','image_location','snapshot','2025-11-29 08:04:30','2025-11-29 08:04:39','2025-11-29 08:04:39',1),(272,'19d37975-6e79-4fd9-8985-4a51a67c9db3','hw_rng_model','virtio','2025-11-29 08:10:53','2025-11-29 08:11:14','2025-11-29 08:11:14',1),(273,'19d37975-6e79-4fd9-8985-4a51a67c9db3','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 08:10:53','2025-11-29 08:11:14','2025-11-29 08:11:14',1),(274,'19d37975-6e79-4fd9-8985-4a51a67c9db3','owner_user_name','tempest-ServerActionsTestOtherB-325732369-project-member','2025-11-29 08:10:53','2025-11-29 08:11:14','2025-11-29 08:11:14',1),(275,'19d37975-6e79-4fd9-8985-4a51a67c9db3','owner_project_name','tempest-ServerActionsTestOtherB-325732369','2025-11-29 08:10:53','2025-11-29 08:11:14','2025-11-29 08:11:14',1),(276,'19d37975-6e79-4fd9-8985-4a51a67c9db3','boot_roles','member,reader','2025-11-29 08:10:53','2025-11-29 08:11:14','2025-11-29 08:11:14',1),(277,'19d37975-6e79-4fd9-8985-4a51a67c9db3','hw_machine_type','q35','2025-11-29 08:10:53','2025-11-29 08:11:14','2025-11-29 08:11:14',1),(278,'19d37975-6e79-4fd9-8985-4a51a67c9db3','hw_cdrom_bus','sata','2025-11-29 08:10:53','2025-11-29 08:11:14','2025-11-29 08:11:14',1),(279,'19d37975-6e79-4fd9-8985-4a51a67c9db3','hw_disk_bus','virtio','2025-11-29 08:10:53','2025-11-29 08:11:14','2025-11-29 08:11:14',1),(280,'19d37975-6e79-4fd9-8985-4a51a67c9db3','hw_input_bus','usb','2025-11-29 08:10:53','2025-11-29 08:11:14','2025-11-29 08:11:14',1),(281,'19d37975-6e79-4fd9-8985-4a51a67c9db3','hw_pointer_model','usbtablet','2025-11-29 08:10:53','2025-11-29 08:11:14','2025-11-29 08:11:14',1),(282,'19d37975-6e79-4fd9-8985-4a51a67c9db3','hw_video_model','virtio','2025-11-29 08:10:53','2025-11-29 08:11:14','2025-11-29 08:11:14',1),(283,'19d37975-6e79-4fd9-8985-4a51a67c9db3','hw_vif_model','virtio','2025-11-29 08:10:53','2025-11-29 08:11:14','2025-11-29 08:11:14',1),(284,'19d37975-6e79-4fd9-8985-4a51a67c9db3','instance_uuid','8ea05c4f-adc6-470b-b8cd-2ee92dbfdf78','2025-11-29 08:10:53','2025-11-29 08:11:14','2025-11-29 08:11:14',1),(285,'19d37975-6e79-4fd9-8985-4a51a67c9db3','user_id','ca93c8e3eac142c0aa6b61807727dea2','2025-11-29 08:10:53','2025-11-29 08:11:14','2025-11-29 08:11:14',1),(286,'19d37975-6e79-4fd9-8985-4a51a67c9db3','image_type','backup','2025-11-29 08:10:53','2025-11-29 08:11:14','2025-11-29 08:11:14',1),(287,'19d37975-6e79-4fd9-8985-4a51a67c9db3','backup_type','daily','2025-11-29 08:10:53','2025-11-29 08:11:14','2025-11-29 08:11:14',1),(288,'19d37975-6e79-4fd9-8985-4a51a67c9db3','owner_id','ba867fac17034bb28fe2cdb0fff3af2b','2025-11-29 08:10:57','2025-11-29 08:11:14','2025-11-29 08:11:14',1),(289,'19d37975-6e79-4fd9-8985-4a51a67c9db3','image_state','available','2025-11-29 08:10:57','2025-11-29 08:11:14','2025-11-29 08:11:14',1),(290,'19d37975-6e79-4fd9-8985-4a51a67c9db3','image_location','snapshot','2025-11-29 08:10:57','2025-11-29 08:11:14','2025-11-29 08:11:14',1),(291,'0136f9fb-9ab3-4552-8505-f62bd960c3d5','hw_rng_model','virtio','2025-11-29 08:11:00','2025-11-29 08:11:19','2025-11-29 08:11:19',1),(292,'0136f9fb-9ab3-4552-8505-f62bd960c3d5','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 08:11:00','2025-11-29 08:11:19','2025-11-29 08:11:19',1),(293,'0136f9fb-9ab3-4552-8505-f62bd960c3d5','owner_user_name','tempest-ServerActionsTestOtherB-325732369-project-member','2025-11-29 08:11:00','2025-11-29 08:11:19','2025-11-29 08:11:19',1),(294,'0136f9fb-9ab3-4552-8505-f62bd960c3d5','owner_project_name','tempest-ServerActionsTestOtherB-325732369','2025-11-29 08:11:00','2025-11-29 08:11:19','2025-11-29 08:11:19',1),(295,'0136f9fb-9ab3-4552-8505-f62bd960c3d5','boot_roles','member,reader','2025-11-29 08:11:00','2025-11-29 08:11:19','2025-11-29 08:11:19',1),(296,'0136f9fb-9ab3-4552-8505-f62bd960c3d5','hw_machine_type','q35','2025-11-29 08:11:00','2025-11-29 08:11:19','2025-11-29 08:11:19',1),(297,'0136f9fb-9ab3-4552-8505-f62bd960c3d5','hw_cdrom_bus','sata','2025-11-29 08:11:00','2025-11-29 08:11:19','2025-11-29 08:11:19',1),(298,'0136f9fb-9ab3-4552-8505-f62bd960c3d5','hw_disk_bus','virtio','2025-11-29 08:11:00','2025-11-29 08:11:19','2025-11-29 08:11:19',1),(299,'0136f9fb-9ab3-4552-8505-f62bd960c3d5','hw_input_bus','usb','2025-11-29 08:11:00','2025-11-29 08:11:19','2025-11-29 08:11:19',1),(300,'0136f9fb-9ab3-4552-8505-f62bd960c3d5','hw_pointer_model','usbtablet','2025-11-29 08:11:00','2025-11-29 08:11:19','2025-11-29 08:11:19',1),(301,'0136f9fb-9ab3-4552-8505-f62bd960c3d5','hw_video_model','virtio','2025-11-29 08:11:00','2025-11-29 08:11:19','2025-11-29 08:11:19',1),(302,'0136f9fb-9ab3-4552-8505-f62bd960c3d5','hw_vif_model','virtio','2025-11-29 08:11:00','2025-11-29 08:11:19','2025-11-29 08:11:19',1),(303,'0136f9fb-9ab3-4552-8505-f62bd960c3d5','instance_uuid','8ea05c4f-adc6-470b-b8cd-2ee92dbfdf78','2025-11-29 08:11:00','2025-11-29 08:11:19','2025-11-29 08:11:19',1),(304,'0136f9fb-9ab3-4552-8505-f62bd960c3d5','user_id','ca93c8e3eac142c0aa6b61807727dea2','2025-11-29 08:11:00','2025-11-29 08:11:19','2025-11-29 08:11:19',1),(305,'0136f9fb-9ab3-4552-8505-f62bd960c3d5','image_type','backup','2025-11-29 08:11:00','2025-11-29 08:11:19','2025-11-29 08:11:19',1),(306,'0136f9fb-9ab3-4552-8505-f62bd960c3d5','backup_type','daily','2025-11-29 08:11:00','2025-11-29 08:11:19','2025-11-29 08:11:19',1),(307,'0136f9fb-9ab3-4552-8505-f62bd960c3d5','owner_id','ba867fac17034bb28fe2cdb0fff3af2b','2025-11-29 08:11:04','2025-11-29 08:11:19','2025-11-29 08:11:19',1),(308,'0136f9fb-9ab3-4552-8505-f62bd960c3d5','image_state','available','2025-11-29 08:11:04','2025-11-29 08:11:19','2025-11-29 08:11:19',1),(309,'0136f9fb-9ab3-4552-8505-f62bd960c3d5','image_location','snapshot','2025-11-29 08:11:04','2025-11-29 08:11:19','2025-11-29 08:11:19',1),(310,'c02352c0-4a84-408b-a38c-1ebe85e285cf','hw_rng_model','virtio','2025-11-29 08:11:07','2025-11-29 08:11:18','2025-11-29 08:11:18',1),(311,'c02352c0-4a84-408b-a38c-1ebe85e285cf','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 08:11:07','2025-11-29 08:11:18','2025-11-29 08:11:18',1),(312,'c02352c0-4a84-408b-a38c-1ebe85e285cf','owner_user_name','tempest-ServerActionsTestOtherB-325732369-project-member','2025-11-29 08:11:07','2025-11-29 08:11:18','2025-11-29 08:11:18',1),(313,'c02352c0-4a84-408b-a38c-1ebe85e285cf','owner_project_name','tempest-ServerActionsTestOtherB-325732369','2025-11-29 08:11:07','2025-11-29 08:11:18','2025-11-29 08:11:18',1),(314,'c02352c0-4a84-408b-a38c-1ebe85e285cf','boot_roles','member,reader','2025-11-29 08:11:07','2025-11-29 08:11:18','2025-11-29 08:11:18',1),(315,'c02352c0-4a84-408b-a38c-1ebe85e285cf','hw_machine_type','q35','2025-11-29 08:11:07','2025-11-29 08:11:18','2025-11-29 08:11:18',1),(316,'c02352c0-4a84-408b-a38c-1ebe85e285cf','hw_cdrom_bus','sata','2025-11-29 08:11:07','2025-11-29 08:11:18','2025-11-29 08:11:18',1),(317,'c02352c0-4a84-408b-a38c-1ebe85e285cf','hw_disk_bus','virtio','2025-11-29 08:11:07','2025-11-29 08:11:18','2025-11-29 08:11:18',1),(318,'c02352c0-4a84-408b-a38c-1ebe85e285cf','hw_input_bus','usb','2025-11-29 08:11:07','2025-11-29 08:11:18','2025-11-29 08:11:18',1),(319,'c02352c0-4a84-408b-a38c-1ebe85e285cf','hw_pointer_model','usbtablet','2025-11-29 08:11:07','2025-11-29 08:11:18','2025-11-29 08:11:18',1),(320,'c02352c0-4a84-408b-a38c-1ebe85e285cf','hw_video_model','virtio','2025-11-29 08:11:07','2025-11-29 08:11:18','2025-11-29 08:11:18',1),(321,'c02352c0-4a84-408b-a38c-1ebe85e285cf','hw_vif_model','virtio','2025-11-29 08:11:07','2025-11-29 08:11:18','2025-11-29 08:11:18',1),(322,'c02352c0-4a84-408b-a38c-1ebe85e285cf','instance_uuid','8ea05c4f-adc6-470b-b8cd-2ee92dbfdf78','2025-11-29 08:11:07','2025-11-29 08:11:18','2025-11-29 08:11:18',1),(323,'c02352c0-4a84-408b-a38c-1ebe85e285cf','user_id','ca93c8e3eac142c0aa6b61807727dea2','2025-11-29 08:11:07','2025-11-29 08:11:18','2025-11-29 08:11:18',1),(324,'c02352c0-4a84-408b-a38c-1ebe85e285cf','image_type','backup','2025-11-29 08:11:07','2025-11-29 08:11:18','2025-11-29 08:11:18',1),(325,'c02352c0-4a84-408b-a38c-1ebe85e285cf','backup_type','daily','2025-11-29 08:11:07','2025-11-29 08:11:18','2025-11-29 08:11:18',1),(326,'c02352c0-4a84-408b-a38c-1ebe85e285cf','owner_id','ba867fac17034bb28fe2cdb0fff3af2b','2025-11-29 08:11:12','2025-11-29 08:11:18','2025-11-29 08:11:18',1),(327,'c02352c0-4a84-408b-a38c-1ebe85e285cf','image_state','available','2025-11-29 08:11:12','2025-11-29 08:11:18','2025-11-29 08:11:18',1),(328,'c02352c0-4a84-408b-a38c-1ebe85e285cf','image_location','snapshot','2025-11-29 08:11:12','2025-11-29 08:11:18','2025-11-29 08:11:18',1),(329,'a949de33-fe8e-409f-9e15-d50c466534f9','hw_rng_model','virtio','2025-11-29 08:15:35','2025-11-29 08:16:27','2025-11-29 08:16:27',1),(330,'a949de33-fe8e-409f-9e15-d50c466534f9','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 08:15:35','2025-11-29 08:16:27','2025-11-29 08:16:27',1),(331,'a949de33-fe8e-409f-9e15-d50c466534f9','owner_user_name','tempest-ServerActionsTestOtherB-325732369-project-member','2025-11-29 08:15:35','2025-11-29 08:16:27','2025-11-29 08:16:27',1),(332,'a949de33-fe8e-409f-9e15-d50c466534f9','owner_project_name','tempest-ServerActionsTestOtherB-325732369','2025-11-29 08:15:35','2025-11-29 08:16:27','2025-11-29 08:16:27',1),(333,'a949de33-fe8e-409f-9e15-d50c466534f9','boot_roles','member,reader','2025-11-29 08:15:35','2025-11-29 08:16:27','2025-11-29 08:16:27',1),(334,'a949de33-fe8e-409f-9e15-d50c466534f9','hw_machine_type','q35','2025-11-29 08:15:35','2025-11-29 08:16:27','2025-11-29 08:16:27',1),(335,'a949de33-fe8e-409f-9e15-d50c466534f9','hw_cdrom_bus','sata','2025-11-29 08:15:35','2025-11-29 08:16:27','2025-11-29 08:16:27',1),(336,'a949de33-fe8e-409f-9e15-d50c466534f9','hw_disk_bus','virtio','2025-11-29 08:15:35','2025-11-29 08:16:27','2025-11-29 08:16:27',1),(337,'a949de33-fe8e-409f-9e15-d50c466534f9','hw_input_bus','usb','2025-11-29 08:15:35','2025-11-29 08:16:27','2025-11-29 08:16:27',1),(338,'a949de33-fe8e-409f-9e15-d50c466534f9','hw_pointer_model','usbtablet','2025-11-29 08:15:35','2025-11-29 08:16:27','2025-11-29 08:16:27',1),(339,'a949de33-fe8e-409f-9e15-d50c466534f9','hw_video_model','virtio','2025-11-29 08:15:35','2025-11-29 08:16:27','2025-11-29 08:16:27',1),(340,'a949de33-fe8e-409f-9e15-d50c466534f9','hw_vif_model','virtio','2025-11-29 08:15:35','2025-11-29 08:16:27','2025-11-29 08:16:27',1),(341,'a949de33-fe8e-409f-9e15-d50c466534f9','instance_uuid','89ab44e3-7209-4a9c-b399-77cf74efb51c','2025-11-29 08:15:35','2025-11-29 08:16:27','2025-11-29 08:16:27',1),(342,'a949de33-fe8e-409f-9e15-d50c466534f9','user_id','ca93c8e3eac142c0aa6b61807727dea2','2025-11-29 08:15:35','2025-11-29 08:16:27','2025-11-29 08:16:27',1),(343,'a949de33-fe8e-409f-9e15-d50c466534f9','image_type','snapshot','2025-11-29 08:15:35','2025-11-29 08:16:27','2025-11-29 08:16:27',1),(344,'a949de33-fe8e-409f-9e15-d50c466534f9','image_location','snapshot','2025-11-29 08:15:40','2025-11-29 08:16:27','2025-11-29 08:16:27',1),(345,'a949de33-fe8e-409f-9e15-d50c466534f9','image_state','available','2025-11-29 08:15:40','2025-11-29 08:16:27','2025-11-29 08:16:27',1),(346,'a949de33-fe8e-409f-9e15-d50c466534f9','owner_id','ba867fac17034bb28fe2cdb0fff3af2b','2025-11-29 08:15:40','2025-11-29 08:16:27','2025-11-29 08:16:27',1),(347,'a83442a1-fb28-462f-8936-713084bd46ef','hw_rng_model','virtio','2025-11-29 08:15:50','2025-11-29 08:16:23','2025-11-29 08:16:23',1),(348,'a83442a1-fb28-462f-8936-713084bd46ef','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 08:15:50','2025-11-29 08:16:23','2025-11-29 08:16:23',1),(349,'a83442a1-fb28-462f-8936-713084bd46ef','owner_user_name','tempest-ServerActionsTestOtherB-325732369-project-member','2025-11-29 08:15:50','2025-11-29 08:16:23','2025-11-29 08:16:23',1),(350,'a83442a1-fb28-462f-8936-713084bd46ef','owner_project_name','tempest-ServerActionsTestOtherB-325732369','2025-11-29 08:15:50','2025-11-29 08:16:23','2025-11-29 08:16:23',1),(351,'a83442a1-fb28-462f-8936-713084bd46ef','boot_roles','member,reader','2025-11-29 08:15:50','2025-11-29 08:16:23','2025-11-29 08:16:23',1),(352,'a83442a1-fb28-462f-8936-713084bd46ef','hw_machine_type','q35','2025-11-29 08:15:50','2025-11-29 08:16:23','2025-11-29 08:16:23',1),(353,'a83442a1-fb28-462f-8936-713084bd46ef','hw_cdrom_bus','sata','2025-11-29 08:15:50','2025-11-29 08:16:23','2025-11-29 08:16:23',1),(354,'a83442a1-fb28-462f-8936-713084bd46ef','hw_disk_bus','virtio','2025-11-29 08:15:50','2025-11-29 08:16:23','2025-11-29 08:16:23',1),(355,'a83442a1-fb28-462f-8936-713084bd46ef','hw_input_bus','usb','2025-11-29 08:15:50','2025-11-29 08:16:23','2025-11-29 08:16:23',1),(356,'a83442a1-fb28-462f-8936-713084bd46ef','hw_pointer_model','usbtablet','2025-11-29 08:15:50','2025-11-29 08:16:23','2025-11-29 08:16:23',1),(357,'a83442a1-fb28-462f-8936-713084bd46ef','hw_video_model','virtio','2025-11-29 08:15:50','2025-11-29 08:16:23','2025-11-29 08:16:23',1),(358,'a83442a1-fb28-462f-8936-713084bd46ef','hw_vif_model','virtio','2025-11-29 08:15:50','2025-11-29 08:16:23','2025-11-29 08:16:23',1),(359,'a83442a1-fb28-462f-8936-713084bd46ef','instance_uuid','6033af89-d6d3-45c5-bf88-b2f17800f12e','2025-11-29 08:15:50','2025-11-29 08:16:23','2025-11-29 08:16:23',1),(360,'a83442a1-fb28-462f-8936-713084bd46ef','user_id','ca93c8e3eac142c0aa6b61807727dea2','2025-11-29 08:15:50','2025-11-29 08:16:23','2025-11-29 08:16:23',1),(361,'a83442a1-fb28-462f-8936-713084bd46ef','image_type','snapshot','2025-11-29 08:15:50','2025-11-29 08:16:23','2025-11-29 08:16:23',1),(362,'a83442a1-fb28-462f-8936-713084bd46ef','owner_id','ba867fac17034bb28fe2cdb0fff3af2b','2025-11-29 08:15:59','2025-11-29 08:16:23','2025-11-29 08:16:23',1),(363,'a83442a1-fb28-462f-8936-713084bd46ef','image_state','available','2025-11-29 08:15:59','2025-11-29 08:16:23','2025-11-29 08:16:23',1),(364,'a83442a1-fb28-462f-8936-713084bd46ef','image_location','snapshot','2025-11-29 08:15:59','2025-11-29 08:16:23','2025-11-29 08:16:23',1),(365,'35f0e8d7-af49-4580-985f-4286c576c2fc','hw_rng_model','virtio','2025-11-29 08:16:25','2025-11-29 08:16:26','2025-11-29 08:16:26',1),(366,'35f0e8d7-af49-4580-985f-4286c576c2fc','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 08:16:25','2025-11-29 08:16:26','2025-11-29 08:16:26',1),(367,'35f0e8d7-af49-4580-985f-4286c576c2fc','owner_user_name','tempest-ServersAaction247Test-530446929-project-member','2025-11-29 08:16:25','2025-11-29 08:16:26','2025-11-29 08:16:26',1),(368,'35f0e8d7-af49-4580-985f-4286c576c2fc','owner_project_name','tempest-ServersAaction247Test-530446929','2025-11-29 08:16:25','2025-11-29 08:16:26','2025-11-29 08:16:26',1),(369,'35f0e8d7-af49-4580-985f-4286c576c2fc','boot_roles','member,reader','2025-11-29 08:16:25','2025-11-29 08:16:26','2025-11-29 08:16:26',1),(370,'35f0e8d7-af49-4580-985f-4286c576c2fc','hw_machine_type','q35','2025-11-29 08:16:25','2025-11-29 08:16:26','2025-11-29 08:16:26',1),(371,'35f0e8d7-af49-4580-985f-4286c576c2fc','hw_cdrom_bus','sata','2025-11-29 08:16:25','2025-11-29 08:16:26','2025-11-29 08:16:26',1),(372,'35f0e8d7-af49-4580-985f-4286c576c2fc','hw_disk_bus','virtio','2025-11-29 08:16:25','2025-11-29 08:16:26','2025-11-29 08:16:26',1),(373,'35f0e8d7-af49-4580-985f-4286c576c2fc','hw_input_bus','usb','2025-11-29 08:16:25','2025-11-29 08:16:26','2025-11-29 08:16:26',1),(374,'35f0e8d7-af49-4580-985f-4286c576c2fc','hw_pointer_model','usbtablet','2025-11-29 08:16:25','2025-11-29 08:16:26','2025-11-29 08:16:26',1),(375,'35f0e8d7-af49-4580-985f-4286c576c2fc','hw_video_model','virtio','2025-11-29 08:16:25','2025-11-29 08:16:26','2025-11-29 08:16:26',1),(376,'35f0e8d7-af49-4580-985f-4286c576c2fc','hw_vif_model','virtio','2025-11-29 08:16:25','2025-11-29 08:16:26','2025-11-29 08:16:26',1),(377,'35f0e8d7-af49-4580-985f-4286c576c2fc','instance_uuid','a8df16cb-c311-456a-b3d1-ab964b4e8bf4','2025-11-29 08:16:25','2025-11-29 08:16:26','2025-11-29 08:16:26',1),(378,'35f0e8d7-af49-4580-985f-4286c576c2fc','user_id','75aa7d805acd4cf29b76ffd4333a104f','2025-11-29 08:16:25','2025-11-29 08:16:26','2025-11-29 08:16:26',1),(379,'35f0e8d7-af49-4580-985f-4286c576c2fc','image_type','backup','2025-11-29 08:16:25','2025-11-29 08:16:26','2025-11-29 08:16:26',1),(380,'35f0e8d7-af49-4580-985f-4286c576c2fc','backup_type','daily','2025-11-29 08:16:25','2025-11-29 08:16:26','2025-11-29 08:16:26',1),(381,'995630c6-dc23-4abf-afc5-51778a6f1496','hw_rng_model','virtio','2025-11-29 08:17:52','2025-11-29 08:21:13','2025-11-29 08:21:13',1),(382,'995630c6-dc23-4abf-afc5-51778a6f1496','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 08:17:52','2025-11-29 08:21:13','2025-11-29 08:21:13',1),(383,'995630c6-dc23-4abf-afc5-51778a6f1496','owner_user_name','tempest-ServerBootFromVolumeStableRescueTest-1019923576-project-member','2025-11-29 08:17:52','2025-11-29 08:21:13','2025-11-29 08:21:13',1),(384,'995630c6-dc23-4abf-afc5-51778a6f1496','owner_project_name','tempest-ServerBootFromVolumeStableRescueTest-1019923576','2025-11-29 08:17:52','2025-11-29 08:21:13','2025-11-29 08:21:13',1),(385,'995630c6-dc23-4abf-afc5-51778a6f1496','boot_roles','member,reader','2025-11-29 08:17:52','2025-11-29 08:21:13','2025-11-29 08:21:13',1),(386,'995630c6-dc23-4abf-afc5-51778a6f1496','hw_machine_type','q35','2025-11-29 08:17:52','2025-11-29 08:21:13','2025-11-29 08:21:13',1),(387,'995630c6-dc23-4abf-afc5-51778a6f1496','hw_cdrom_bus','sata','2025-11-29 08:17:52','2025-11-29 08:21:13','2025-11-29 08:21:13',1),(388,'995630c6-dc23-4abf-afc5-51778a6f1496','hw_disk_bus','virtio','2025-11-29 08:17:52','2025-11-29 08:21:13','2025-11-29 08:21:13',1),(389,'995630c6-dc23-4abf-afc5-51778a6f1496','hw_input_bus','usb','2025-11-29 08:17:52','2025-11-29 08:21:13','2025-11-29 08:21:13',1),(390,'995630c6-dc23-4abf-afc5-51778a6f1496','hw_pointer_model','usbtablet','2025-11-29 08:17:52','2025-11-29 08:21:13','2025-11-29 08:21:13',1),(391,'995630c6-dc23-4abf-afc5-51778a6f1496','hw_video_model','virtio','2025-11-29 08:17:52','2025-11-29 08:21:13','2025-11-29 08:21:13',1),(392,'995630c6-dc23-4abf-afc5-51778a6f1496','hw_vif_model','virtio','2025-11-29 08:17:52','2025-11-29 08:21:13','2025-11-29 08:21:13',1),(393,'995630c6-dc23-4abf-afc5-51778a6f1496','instance_uuid','0b082cd2-d1d3-4577-be0a-30b9256a223e','2025-11-29 08:17:52','2025-11-29 08:21:13','2025-11-29 08:21:13',1),(394,'995630c6-dc23-4abf-afc5-51778a6f1496','user_id','504bc6adabad4f7d8c17b0438c4d9be7','2025-11-29 08:17:52','2025-11-29 08:21:13','2025-11-29 08:21:13',1),(395,'995630c6-dc23-4abf-afc5-51778a6f1496','image_type','snapshot','2025-11-29 08:17:52','2025-11-29 08:21:13','2025-11-29 08:21:13',1),(396,'995630c6-dc23-4abf-afc5-51778a6f1496','owner_id','b9d4c81989d641678300c7a1c173a2c2','2025-11-29 08:17:57','2025-11-29 08:21:13','2025-11-29 08:21:13',1),(397,'995630c6-dc23-4abf-afc5-51778a6f1496','image_state','available','2025-11-29 08:17:57','2025-11-29 08:21:13','2025-11-29 08:21:13',1),(398,'995630c6-dc23-4abf-afc5-51778a6f1496','image_location','snapshot','2025-11-29 08:17:57','2025-11-29 08:21:13','2025-11-29 08:21:13',1),(399,'995630c6-dc23-4abf-afc5-51778a6f1496','hw_rescue_bus','virtio','2025-11-29 08:18:23','2025-11-29 08:21:13','2025-11-29 08:21:13',1),(400,'995630c6-dc23-4abf-afc5-51778a6f1496','hw_rescue_device','disk','2025-11-29 08:18:23','2025-11-29 08:21:13','2025-11-29 08:21:13',1),(401,'b01ef350-a5c1-4fa3-afd2-96dd9326703d','hw_rng_model','virtio','2025-11-29 08:18:36','2025-11-29 08:23:11','2025-11-29 08:23:11',1),(402,'b01ef350-a5c1-4fa3-afd2-96dd9326703d','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 08:18:36','2025-11-29 08:23:11','2025-11-29 08:23:11',1),(403,'b01ef350-a5c1-4fa3-afd2-96dd9326703d','owner_user_name','tempest-ServerStableDeviceRescueTest-1105304301-project-member','2025-11-29 08:18:36','2025-11-29 08:23:11','2025-11-29 08:23:11',1),(404,'b01ef350-a5c1-4fa3-afd2-96dd9326703d','owner_project_name','tempest-ServerStableDeviceRescueTest-1105304301','2025-11-29 08:18:36','2025-11-29 08:23:11','2025-11-29 08:23:11',1),(405,'b01ef350-a5c1-4fa3-afd2-96dd9326703d','boot_roles','member,reader','2025-11-29 08:18:36','2025-11-29 08:23:11','2025-11-29 08:23:11',1),(406,'b01ef350-a5c1-4fa3-afd2-96dd9326703d','hw_machine_type','q35','2025-11-29 08:18:36','2025-11-29 08:23:11','2025-11-29 08:23:11',1),(407,'b01ef350-a5c1-4fa3-afd2-96dd9326703d','hw_cdrom_bus','sata','2025-11-29 08:18:36','2025-11-29 08:23:11','2025-11-29 08:23:11',1),(408,'b01ef350-a5c1-4fa3-afd2-96dd9326703d','hw_disk_bus','virtio','2025-11-29 08:18:36','2025-11-29 08:23:11','2025-11-29 08:23:11',1),(409,'b01ef350-a5c1-4fa3-afd2-96dd9326703d','hw_input_bus','usb','2025-11-29 08:18:36','2025-11-29 08:23:11','2025-11-29 08:23:11',1),(410,'b01ef350-a5c1-4fa3-afd2-96dd9326703d','hw_pointer_model','usbtablet','2025-11-29 08:18:36','2025-11-29 08:23:11','2025-11-29 08:23:11',1),(411,'b01ef350-a5c1-4fa3-afd2-96dd9326703d','hw_video_model','virtio','2025-11-29 08:18:36','2025-11-29 08:23:11','2025-11-29 08:23:11',1),(412,'b01ef350-a5c1-4fa3-afd2-96dd9326703d','hw_vif_model','virtio','2025-11-29 08:18:36','2025-11-29 08:23:11','2025-11-29 08:23:11',1),(413,'b01ef350-a5c1-4fa3-afd2-96dd9326703d','instance_uuid','1fad2d6f-5a00-43ad-af43-00916509fc61','2025-11-29 08:18:36','2025-11-29 08:23:12','2025-11-29 08:23:12',1),(414,'b01ef350-a5c1-4fa3-afd2-96dd9326703d','user_id','3b52040d601a4a56abcaf3f046f1e349','2025-11-29 08:18:36','2025-11-29 08:23:12','2025-11-29 08:23:12',1),(415,'b01ef350-a5c1-4fa3-afd2-96dd9326703d','image_type','snapshot','2025-11-29 08:18:36','2025-11-29 08:23:12','2025-11-29 08:23:12',1),(416,'b01ef350-a5c1-4fa3-afd2-96dd9326703d','image_location','snapshot','2025-11-29 08:18:40','2025-11-29 08:23:12','2025-11-29 08:23:12',1),(417,'b01ef350-a5c1-4fa3-afd2-96dd9326703d','image_state','available','2025-11-29 08:18:40','2025-11-29 08:23:12','2025-11-29 08:23:12',1),(418,'b01ef350-a5c1-4fa3-afd2-96dd9326703d','owner_id','358970eca7ad4b05b70f43e5507ac052','2025-11-29 08:18:40','2025-11-29 08:23:12','2025-11-29 08:23:12',1),(419,'b01ef350-a5c1-4fa3-afd2-96dd9326703d','hw_rescue_bus','scsi','2025-11-29 08:18:45','2025-11-29 08:23:12','2025-11-29 08:23:12',1),(420,'b01ef350-a5c1-4fa3-afd2-96dd9326703d','hw_rescue_device','disk','2025-11-29 08:18:45','2025-11-29 08:23:12','2025-11-29 08:23:12',1),(421,'e372d671-0356-4b39-949b-13a58b062421','hw_rng_model','virtio','2025-11-29 08:19:26','2025-11-29 08:23:04','2025-11-29 08:23:04',1),(422,'e372d671-0356-4b39-949b-13a58b062421','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 08:19:26','2025-11-29 08:23:04','2025-11-29 08:23:04',1),(423,'e372d671-0356-4b39-949b-13a58b062421','owner_user_name','tempest-ServerStableDeviceRescueTest-1105304301-project-member','2025-11-29 08:19:26','2025-11-29 08:23:04','2025-11-29 08:23:04',1),(424,'e372d671-0356-4b39-949b-13a58b062421','owner_project_name','tempest-ServerStableDeviceRescueTest-1105304301','2025-11-29 08:19:26','2025-11-29 08:23:04','2025-11-29 08:23:04',1),(425,'e372d671-0356-4b39-949b-13a58b062421','boot_roles','member,reader','2025-11-29 08:19:26','2025-11-29 08:23:04','2025-11-29 08:23:04',1),(426,'e372d671-0356-4b39-949b-13a58b062421','hw_machine_type','q35','2025-11-29 08:19:26','2025-11-29 08:23:04','2025-11-29 08:23:04',1),(427,'e372d671-0356-4b39-949b-13a58b062421','hw_cdrom_bus','sata','2025-11-29 08:19:26','2025-11-29 08:23:04','2025-11-29 08:23:04',1),(428,'e372d671-0356-4b39-949b-13a58b062421','hw_disk_bus','virtio','2025-11-29 08:19:26','2025-11-29 08:23:04','2025-11-29 08:23:04',1),(429,'e372d671-0356-4b39-949b-13a58b062421','hw_input_bus','usb','2025-11-29 08:19:26','2025-11-29 08:23:04','2025-11-29 08:23:04',1),(430,'e372d671-0356-4b39-949b-13a58b062421','hw_pointer_model','usbtablet','2025-11-29 08:19:26','2025-11-29 08:23:04','2025-11-29 08:23:04',1),(431,'e372d671-0356-4b39-949b-13a58b062421','hw_video_model','virtio','2025-11-29 08:19:26','2025-11-29 08:23:04','2025-11-29 08:23:04',1),(432,'e372d671-0356-4b39-949b-13a58b062421','hw_vif_model','virtio','2025-11-29 08:19:26','2025-11-29 08:23:04','2025-11-29 08:23:04',1),(433,'e372d671-0356-4b39-949b-13a58b062421','instance_uuid','38bba84b-1fb0-460a-a6aa-707ef29970b2','2025-11-29 08:19:26','2025-11-29 08:23:04','2025-11-29 08:23:04',1),(434,'e372d671-0356-4b39-949b-13a58b062421','user_id','3b52040d601a4a56abcaf3f046f1e349','2025-11-29 08:19:26','2025-11-29 08:23:04','2025-11-29 08:23:04',1),(435,'e372d671-0356-4b39-949b-13a58b062421','image_type','snapshot','2025-11-29 08:19:26','2025-11-29 08:23:04','2025-11-29 08:23:04',1),(436,'e372d671-0356-4b39-949b-13a58b062421','owner_id','358970eca7ad4b05b70f43e5507ac052','2025-11-29 08:19:30','2025-11-29 08:23:04','2025-11-29 08:23:04',1),(437,'e372d671-0356-4b39-949b-13a58b062421','image_state','available','2025-11-29 08:19:30','2025-11-29 08:23:04','2025-11-29 08:23:04',1),(438,'e372d671-0356-4b39-949b-13a58b062421','image_location','snapshot','2025-11-29 08:19:30','2025-11-29 08:23:04','2025-11-29 08:23:04',1),(439,'e372d671-0356-4b39-949b-13a58b062421','hw_rescue_bus','usb','2025-11-29 08:19:33','2025-11-29 08:23:04','2025-11-29 08:23:04',1),(440,'e372d671-0356-4b39-949b-13a58b062421','hw_rescue_device','disk','2025-11-29 08:19:34','2025-11-29 08:23:04','2025-11-29 08:23:04',1),(441,'bf0aed8c-3418-4a5d-ab36-68410b6b956c','hw_rng_model','virtio','2025-11-29 08:19:55','2025-11-29 08:21:03','2025-11-29 08:21:03',1),(442,'bf0aed8c-3418-4a5d-ab36-68410b6b956c','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 08:19:55','2025-11-29 08:21:03','2025-11-29 08:21:03',1),(443,'bf0aed8c-3418-4a5d-ab36-68410b6b956c','owner_user_name','tempest-ServerBootFromVolumeStableRescueTest-1019923576-project-member','2025-11-29 08:19:55','2025-11-29 08:21:03','2025-11-29 08:21:03',1),(444,'bf0aed8c-3418-4a5d-ab36-68410b6b956c','owner_project_name','tempest-ServerBootFromVolumeStableRescueTest-1019923576','2025-11-29 08:19:55','2025-11-29 08:21:03','2025-11-29 08:21:03',1),(445,'bf0aed8c-3418-4a5d-ab36-68410b6b956c','boot_roles','member,reader','2025-11-29 08:19:55','2025-11-29 08:21:03','2025-11-29 08:21:03',1),(446,'bf0aed8c-3418-4a5d-ab36-68410b6b956c','hw_machine_type','q35','2025-11-29 08:19:55','2025-11-29 08:21:03','2025-11-29 08:21:03',1),(447,'bf0aed8c-3418-4a5d-ab36-68410b6b956c','hw_cdrom_bus','sata','2025-11-29 08:19:55','2025-11-29 08:21:03','2025-11-29 08:21:03',1),(448,'bf0aed8c-3418-4a5d-ab36-68410b6b956c','hw_disk_bus','virtio','2025-11-29 08:19:55','2025-11-29 08:21:03','2025-11-29 08:21:03',1),(449,'bf0aed8c-3418-4a5d-ab36-68410b6b956c','hw_input_bus','usb','2025-11-29 08:19:55','2025-11-29 08:21:03','2025-11-29 08:21:03',1),(450,'bf0aed8c-3418-4a5d-ab36-68410b6b956c','hw_pointer_model','usbtablet','2025-11-29 08:19:55','2025-11-29 08:21:03','2025-11-29 08:21:03',1),(451,'bf0aed8c-3418-4a5d-ab36-68410b6b956c','hw_video_model','virtio','2025-11-29 08:19:55','2025-11-29 08:21:03','2025-11-29 08:21:03',1),(452,'bf0aed8c-3418-4a5d-ab36-68410b6b956c','hw_vif_model','virtio','2025-11-29 08:19:55','2025-11-29 08:21:03','2025-11-29 08:21:03',1),(453,'bf0aed8c-3418-4a5d-ab36-68410b6b956c','instance_uuid','091988cc-8042-4aa1-b909-5ca1744ff259','2025-11-29 08:19:55','2025-11-29 08:21:03','2025-11-29 08:21:03',1),(454,'bf0aed8c-3418-4a5d-ab36-68410b6b956c','user_id','504bc6adabad4f7d8c17b0438c4d9be7','2025-11-29 08:19:55','2025-11-29 08:21:03','2025-11-29 08:21:03',1),(455,'bf0aed8c-3418-4a5d-ab36-68410b6b956c','image_type','snapshot','2025-11-29 08:19:55','2025-11-29 08:21:03','2025-11-29 08:21:03',1),(456,'bf0aed8c-3418-4a5d-ab36-68410b6b956c','owner_id','b9d4c81989d641678300c7a1c173a2c2','2025-11-29 08:20:00','2025-11-29 08:21:03','2025-11-29 08:21:03',1),(457,'bf0aed8c-3418-4a5d-ab36-68410b6b956c','image_state','available','2025-11-29 08:20:00','2025-11-29 08:21:03','2025-11-29 08:21:03',1),(458,'bf0aed8c-3418-4a5d-ab36-68410b6b956c','image_location','snapshot','2025-11-29 08:20:00','2025-11-29 08:21:03','2025-11-29 08:21:03',1),(459,'5b6878f5-ee6a-4f36-b7ce-cdb9894ce54c','hw_rng_model','virtio','2025-11-29 08:20:13','2025-11-29 08:22:58','2025-11-29 08:22:58',1),(460,'5b6878f5-ee6a-4f36-b7ce-cdb9894ce54c','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 08:20:13','2025-11-29 08:22:58','2025-11-29 08:22:58',1),(461,'5b6878f5-ee6a-4f36-b7ce-cdb9894ce54c','owner_user_name','tempest-ServerStableDeviceRescueTest-1105304301-project-member','2025-11-29 08:20:13','2025-11-29 08:22:58','2025-11-29 08:22:58',1),(462,'5b6878f5-ee6a-4f36-b7ce-cdb9894ce54c','owner_project_name','tempest-ServerStableDeviceRescueTest-1105304301','2025-11-29 08:20:13','2025-11-29 08:22:58','2025-11-29 08:22:58',1),(463,'5b6878f5-ee6a-4f36-b7ce-cdb9894ce54c','boot_roles','member,reader','2025-11-29 08:20:13','2025-11-29 08:22:58','2025-11-29 08:22:58',1),(464,'5b6878f5-ee6a-4f36-b7ce-cdb9894ce54c','hw_machine_type','q35','2025-11-29 08:20:13','2025-11-29 08:22:58','2025-11-29 08:22:58',1),(465,'5b6878f5-ee6a-4f36-b7ce-cdb9894ce54c','hw_cdrom_bus','sata','2025-11-29 08:20:13','2025-11-29 08:22:58','2025-11-29 08:22:58',1),(466,'5b6878f5-ee6a-4f36-b7ce-cdb9894ce54c','hw_disk_bus','virtio','2025-11-29 08:20:13','2025-11-29 08:22:58','2025-11-29 08:22:58',1),(467,'5b6878f5-ee6a-4f36-b7ce-cdb9894ce54c','hw_input_bus','usb','2025-11-29 08:20:13','2025-11-29 08:22:58','2025-11-29 08:22:58',1),(468,'5b6878f5-ee6a-4f36-b7ce-cdb9894ce54c','hw_pointer_model','usbtablet','2025-11-29 08:20:13','2025-11-29 08:22:58','2025-11-29 08:22:58',1),(469,'5b6878f5-ee6a-4f36-b7ce-cdb9894ce54c','hw_video_model','virtio','2025-11-29 08:20:13','2025-11-29 08:22:58','2025-11-29 08:22:58',1),(470,'5b6878f5-ee6a-4f36-b7ce-cdb9894ce54c','hw_vif_model','virtio','2025-11-29 08:20:13','2025-11-29 08:22:58','2025-11-29 08:22:58',1),(471,'5b6878f5-ee6a-4f36-b7ce-cdb9894ce54c','instance_uuid','9b6f3346-1230-472f-bd04-791d2367bebb','2025-11-29 08:20:13','2025-11-29 08:22:58','2025-11-29 08:22:58',1),(472,'5b6878f5-ee6a-4f36-b7ce-cdb9894ce54c','user_id','3b52040d601a4a56abcaf3f046f1e349','2025-11-29 08:20:13','2025-11-29 08:22:58','2025-11-29 08:22:58',1),(473,'5b6878f5-ee6a-4f36-b7ce-cdb9894ce54c','image_type','snapshot','2025-11-29 08:20:13','2025-11-29 08:22:58','2025-11-29 08:22:58',1),(474,'5b6878f5-ee6a-4f36-b7ce-cdb9894ce54c','image_location','snapshot','2025-11-29 08:20:17','2025-11-29 08:22:58','2025-11-29 08:22:58',1),(475,'5b6878f5-ee6a-4f36-b7ce-cdb9894ce54c','image_state','available','2025-11-29 08:20:17','2025-11-29 08:22:58','2025-11-29 08:22:58',1),(476,'5b6878f5-ee6a-4f36-b7ce-cdb9894ce54c','owner_id','358970eca7ad4b05b70f43e5507ac052','2025-11-29 08:20:17','2025-11-29 08:22:58','2025-11-29 08:22:58',1),(477,'5b6878f5-ee6a-4f36-b7ce-cdb9894ce54c','hw_rescue_bus','virtio','2025-11-29 08:20:20','2025-11-29 08:22:58','2025-11-29 08:22:58',1),(478,'5b6878f5-ee6a-4f36-b7ce-cdb9894ce54c','hw_rescue_device','disk','2025-11-29 08:20:20','2025-11-29 08:22:58','2025-11-29 08:22:58',1),(479,'bf0aed8c-3418-4a5d-ab36-68410b6b956c','hw_rescue_bus','virtio','2025-11-29 08:20:26','2025-11-29 08:21:03','2025-11-29 08:21:03',1),(480,'bf0aed8c-3418-4a5d-ab36-68410b6b956c','hw_rescue_device','disk','2025-11-29 08:20:26','2025-11-29 08:21:03','2025-11-29 08:21:03',1),(481,'10d0dcc8-92b3-4e29-baff-aaa5549dce70','hw_rng_model','virtio','2025-11-29 08:21:33','2025-11-29 08:22:50','2025-11-29 08:22:50',1),(482,'10d0dcc8-92b3-4e29-baff-aaa5549dce70','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 08:21:33','2025-11-29 08:22:50','2025-11-29 08:22:50',1),(483,'10d0dcc8-92b3-4e29-baff-aaa5549dce70','owner_user_name','tempest-ServerStableDeviceRescueTest-1105304301-project-member','2025-11-29 08:21:33','2025-11-29 08:22:50','2025-11-29 08:22:50',1),(484,'10d0dcc8-92b3-4e29-baff-aaa5549dce70','owner_project_name','tempest-ServerStableDeviceRescueTest-1105304301','2025-11-29 08:21:33','2025-11-29 08:22:50','2025-11-29 08:22:50',1),(485,'10d0dcc8-92b3-4e29-baff-aaa5549dce70','boot_roles','member,reader','2025-11-29 08:21:33','2025-11-29 08:22:50','2025-11-29 08:22:50',1),(486,'10d0dcc8-92b3-4e29-baff-aaa5549dce70','hw_machine_type','q35','2025-11-29 08:21:33','2025-11-29 08:22:50','2025-11-29 08:22:50',1),(487,'10d0dcc8-92b3-4e29-baff-aaa5549dce70','hw_cdrom_bus','sata','2025-11-29 08:21:33','2025-11-29 08:22:50','2025-11-29 08:22:50',1),(488,'10d0dcc8-92b3-4e29-baff-aaa5549dce70','hw_disk_bus','virtio','2025-11-29 08:21:33','2025-11-29 08:22:50','2025-11-29 08:22:50',1),(489,'10d0dcc8-92b3-4e29-baff-aaa5549dce70','hw_input_bus','usb','2025-11-29 08:21:33','2025-11-29 08:22:50','2025-11-29 08:22:50',1),(490,'10d0dcc8-92b3-4e29-baff-aaa5549dce70','hw_pointer_model','usbtablet','2025-11-29 08:21:33','2025-11-29 08:22:50','2025-11-29 08:22:50',1),(491,'10d0dcc8-92b3-4e29-baff-aaa5549dce70','hw_video_model','virtio','2025-11-29 08:21:33','2025-11-29 08:22:50','2025-11-29 08:22:50',1),(492,'10d0dcc8-92b3-4e29-baff-aaa5549dce70','hw_vif_model','virtio','2025-11-29 08:21:33','2025-11-29 08:22:50','2025-11-29 08:22:50',1),(493,'10d0dcc8-92b3-4e29-baff-aaa5549dce70','instance_uuid','63dba7cc-b3af-4fb3-bbe8-58d5a087af19','2025-11-29 08:21:33','2025-11-29 08:22:50','2025-11-29 08:22:50',1),(494,'10d0dcc8-92b3-4e29-baff-aaa5549dce70','user_id','3b52040d601a4a56abcaf3f046f1e349','2025-11-29 08:21:33','2025-11-29 08:22:50','2025-11-29 08:22:50',1),(495,'10d0dcc8-92b3-4e29-baff-aaa5549dce70','image_type','snapshot','2025-11-29 08:21:33','2025-11-29 08:22:50','2025-11-29 08:22:50',1),(496,'10d0dcc8-92b3-4e29-baff-aaa5549dce70','owner_id','358970eca7ad4b05b70f43e5507ac052','2025-11-29 08:21:37','2025-11-29 08:22:50','2025-11-29 08:22:50',1),(497,'10d0dcc8-92b3-4e29-baff-aaa5549dce70','image_state','available','2025-11-29 08:21:37','2025-11-29 08:22:50','2025-11-29 08:22:50',1),(498,'10d0dcc8-92b3-4e29-baff-aaa5549dce70','image_location','snapshot','2025-11-29 08:21:37','2025-11-29 08:22:50','2025-11-29 08:22:50',1),(499,'10d0dcc8-92b3-4e29-baff-aaa5549dce70','hw_rescue_bus','virtio','2025-11-29 08:21:40','2025-11-29 08:22:50','2025-11-29 08:22:50',1),(500,'10d0dcc8-92b3-4e29-baff-aaa5549dce70','hw_rescue_device','disk','2025-11-29 08:21:40','2025-11-29 08:22:50','2025-11-29 08:22:50',1),(501,'5945a148-7986-4fa0-8052-c380ea11f788','hw_rng_model','virtio','2025-11-29 08:26:02','2025-11-29 08:26:47','2025-11-29 08:26:47',1),(502,'5945a148-7986-4fa0-8052-c380ea11f788','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 08:26:02','2025-11-29 08:26:47','2025-11-29 08:26:47',1),(503,'5945a148-7986-4fa0-8052-c380ea11f788','owner_user_name','tempest-ServersNegativeTestJSON-213437080-project-member','2025-11-29 08:26:02','2025-11-29 08:26:47','2025-11-29 08:26:47',1),(504,'5945a148-7986-4fa0-8052-c380ea11f788','owner_project_name','tempest-ServersNegativeTestJSON-213437080','2025-11-29 08:26:02','2025-11-29 08:26:47','2025-11-29 08:26:47',1),(505,'5945a148-7986-4fa0-8052-c380ea11f788','boot_roles','member,reader','2025-11-29 08:26:02','2025-11-29 08:26:47','2025-11-29 08:26:47',1),(506,'5945a148-7986-4fa0-8052-c380ea11f788','hw_machine_type','q35','2025-11-29 08:26:02','2025-11-29 08:26:47','2025-11-29 08:26:47',1),(507,'5945a148-7986-4fa0-8052-c380ea11f788','hw_cdrom_bus','sata','2025-11-29 08:26:02','2025-11-29 08:26:47','2025-11-29 08:26:47',1),(508,'5945a148-7986-4fa0-8052-c380ea11f788','hw_disk_bus','virtio','2025-11-29 08:26:02','2025-11-29 08:26:47','2025-11-29 08:26:47',1),(509,'5945a148-7986-4fa0-8052-c380ea11f788','hw_input_bus','usb','2025-11-29 08:26:02','2025-11-29 08:26:47','2025-11-29 08:26:47',1),(510,'5945a148-7986-4fa0-8052-c380ea11f788','hw_pointer_model','usbtablet','2025-11-29 08:26:02','2025-11-29 08:26:47','2025-11-29 08:26:47',1),(511,'5945a148-7986-4fa0-8052-c380ea11f788','hw_video_model','virtio','2025-11-29 08:26:02','2025-11-29 08:26:47','2025-11-29 08:26:47',1),(512,'5945a148-7986-4fa0-8052-c380ea11f788','hw_vif_model','virtio','2025-11-29 08:26:02','2025-11-29 08:26:47','2025-11-29 08:26:47',1),(513,'5945a148-7986-4fa0-8052-c380ea11f788','instance_uuid','9c6c5334-4e97-46b8-9013-cc5269d8c1c1','2025-11-29 08:26:02','2025-11-29 08:26:47','2025-11-29 08:26:47',1),(514,'5945a148-7986-4fa0-8052-c380ea11f788','user_id','3a37c720b9bb4273b66cd2dce30fbf48','2025-11-29 08:26:02','2025-11-29 08:26:47','2025-11-29 08:26:47',1),(515,'5945a148-7986-4fa0-8052-c380ea11f788','image_type','snapshot','2025-11-29 08:26:02','2025-11-29 08:26:47','2025-11-29 08:26:47',1),(516,'5945a148-7986-4fa0-8052-c380ea11f788','image_state','available','2025-11-29 08:26:10','2025-11-29 08:26:47','2025-11-29 08:26:47',1),(517,'5945a148-7986-4fa0-8052-c380ea11f788','owner_id','d9406fbc6fef486fa5b0e79549e78d00','2025-11-29 08:26:10','2025-11-29 08:26:47','2025-11-29 08:26:47',1),(518,'5945a148-7986-4fa0-8052-c380ea11f788','image_location','snapshot','2025-11-29 08:26:10','2025-11-29 08:26:47','2025-11-29 08:26:47',1),(519,'1b6ee968-62a2-4023-a5bf-e3fec39abfbe','signature_verified','False','2025-11-29 08:29:41','2025-11-29 08:29:55','2025-11-29 08:29:55',1),(520,'1b6ee968-62a2-4023-a5bf-e3fec39abfbe','hw_rng_model','virtio','2025-11-29 08:29:41','2025-11-29 08:29:55','2025-11-29 08:29:55',1),(521,'1b6ee968-62a2-4023-a5bf-e3fec39abfbe','base_image_ref','','2025-11-29 08:29:41','2025-11-29 08:29:55','2025-11-29 08:29:55',1),(522,'1b6ee968-62a2-4023-a5bf-e3fec39abfbe','owner_user_name','tempest-AttachVolumeMultiAttachTest-1454477111-project-member','2025-11-29 08:29:41','2025-11-29 08:29:55','2025-11-29 08:29:55',1),(523,'1b6ee968-62a2-4023-a5bf-e3fec39abfbe','owner_project_name','tempest-AttachVolumeMultiAttachTest-1454477111','2025-11-29 08:29:41','2025-11-29 08:29:55','2025-11-29 08:29:55',1),(524,'1b6ee968-62a2-4023-a5bf-e3fec39abfbe','boot_roles','member,reader','2025-11-29 08:29:41','2025-11-29 08:29:55','2025-11-29 08:29:55',1),(525,'1b6ee968-62a2-4023-a5bf-e3fec39abfbe','hw_machine_type','q35','2025-11-29 08:29:41','2025-11-29 08:29:55','2025-11-29 08:29:55',1),(526,'1b6ee968-62a2-4023-a5bf-e3fec39abfbe','hw_cdrom_bus','sata','2025-11-29 08:29:41','2025-11-29 08:29:55','2025-11-29 08:29:55',1),(527,'1b6ee968-62a2-4023-a5bf-e3fec39abfbe','hw_disk_bus','virtio','2025-11-29 08:29:41','2025-11-29 08:29:55','2025-11-29 08:29:55',1),(528,'1b6ee968-62a2-4023-a5bf-e3fec39abfbe','hw_input_bus','usb','2025-11-29 08:29:41','2025-11-29 08:29:55','2025-11-29 08:29:55',1),(529,'1b6ee968-62a2-4023-a5bf-e3fec39abfbe','hw_pointer_model','usbtablet','2025-11-29 08:29:41','2025-11-29 08:29:55','2025-11-29 08:29:55',1),(530,'1b6ee968-62a2-4023-a5bf-e3fec39abfbe','hw_video_model','virtio','2025-11-29 08:29:41','2025-11-29 08:29:55','2025-11-29 08:29:55',1),(531,'1b6ee968-62a2-4023-a5bf-e3fec39abfbe','hw_vif_model','virtio','2025-11-29 08:29:41','2025-11-29 08:29:55','2025-11-29 08:29:55',1),(532,'1b6ee968-62a2-4023-a5bf-e3fec39abfbe','root_device_name','/dev/vda','2025-11-29 08:29:41','2025-11-29 08:29:55','2025-11-29 08:29:55',1),(533,'1b6ee968-62a2-4023-a5bf-e3fec39abfbe','block_device_mapping','[{\"snapshot_id\": \"92bf57c5-1776-41c3-84b4-e98f1bce6a3e\", \"source_type\": \"snapshot\", \"encryption_format\": null, \"no_device\": null, \"guest_format\": null, \"volume_type\": null, \"boot_index\": 0, \"delete_on_termination\": false, \"volume_size\": 1, \"device_name\": \"/dev/vda\", \"tag\": null, \"destination_type\": \"volume\", \"volume_id\": null, \"encryption_options\": null, \"disk_bus\": \"virtio\", \"image_id\": null, \"device_type\": \"disk\", \"encryption_secret_uuid\": null, \"encrypted\": null}]','2025-11-29 08:29:41','2025-11-29 08:29:55','2025-11-29 08:29:55',1),(534,'1b6ee968-62a2-4023-a5bf-e3fec39abfbe','bdm_v2','True','2025-11-29 08:29:41','2025-11-29 08:29:55','2025-11-29 08:29:55',1),(535,'29125612-6fcb-47b2-8690-67e6e3459b96','hw_rng_model','virtio','2025-11-29 08:31:03','2025-11-29 08:32:33','2025-11-29 08:32:33',1),(536,'29125612-6fcb-47b2-8690-67e6e3459b96','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 08:31:03','2025-11-29 08:32:33','2025-11-29 08:32:33',1),(537,'29125612-6fcb-47b2-8690-67e6e3459b96','owner_user_name','tempest-TestStampPattern-1730119083-project-member','2025-11-29 08:31:03','2025-11-29 08:32:33','2025-11-29 08:32:33',1),(538,'29125612-6fcb-47b2-8690-67e6e3459b96','owner_project_name','tempest-TestStampPattern-1730119083','2025-11-29 08:31:03','2025-11-29 08:32:33','2025-11-29 08:32:33',1),(539,'29125612-6fcb-47b2-8690-67e6e3459b96','boot_roles','member,reader','2025-11-29 08:31:03','2025-11-29 08:32:33','2025-11-29 08:32:33',1),(540,'29125612-6fcb-47b2-8690-67e6e3459b96','hw_machine_type','q35','2025-11-29 08:31:03','2025-11-29 08:32:33','2025-11-29 08:32:33',1),(541,'29125612-6fcb-47b2-8690-67e6e3459b96','hw_cdrom_bus','sata','2025-11-29 08:31:03','2025-11-29 08:32:33','2025-11-29 08:32:33',1),(542,'29125612-6fcb-47b2-8690-67e6e3459b96','hw_disk_bus','virtio','2025-11-29 08:31:03','2025-11-29 08:32:33','2025-11-29 08:32:33',1),(543,'29125612-6fcb-47b2-8690-67e6e3459b96','hw_input_bus','usb','2025-11-29 08:31:03','2025-11-29 08:32:33','2025-11-29 08:32:33',1),(544,'29125612-6fcb-47b2-8690-67e6e3459b96','hw_pointer_model','usbtablet','2025-11-29 08:31:03','2025-11-29 08:32:33','2025-11-29 08:32:33',1),(545,'29125612-6fcb-47b2-8690-67e6e3459b96','hw_video_model','virtio','2025-11-29 08:31:03','2025-11-29 08:32:33','2025-11-29 08:32:33',1),(546,'29125612-6fcb-47b2-8690-67e6e3459b96','hw_vif_model','virtio','2025-11-29 08:31:03','2025-11-29 08:32:33','2025-11-29 08:32:33',1),(547,'29125612-6fcb-47b2-8690-67e6e3459b96','instance_uuid','dc8140a9-7bef-42f8-867c-13e29f022673','2025-11-29 08:31:03','2025-11-29 08:32:33','2025-11-29 08:32:33',1),(548,'29125612-6fcb-47b2-8690-67e6e3459b96','user_id','d45f9a4a44664af3884c15ce0f5697e0','2025-11-29 08:31:03','2025-11-29 08:32:33','2025-11-29 08:32:33',1),(549,'29125612-6fcb-47b2-8690-67e6e3459b96','image_type','snapshot','2025-11-29 08:31:03','2025-11-29 08:32:33','2025-11-29 08:32:33',1),(550,'29125612-6fcb-47b2-8690-67e6e3459b96','image_state','available','2025-11-29 08:31:09','2025-11-29 08:32:33','2025-11-29 08:32:33',1),(551,'29125612-6fcb-47b2-8690-67e6e3459b96','owner_id','7e8e7407a7c44208a503e8225c1cf518','2025-11-29 08:31:09','2025-11-29 08:32:33','2025-11-29 08:32:33',1),(552,'29125612-6fcb-47b2-8690-67e6e3459b96','image_location','snapshot','2025-11-29 08:31:09','2025-11-29 08:32:33','2025-11-29 08:32:33',1),(553,'fde91722-ea74-45a9-b57b-7fc9203f0965','hw_rng_model','virtio','2025-11-29 08:31:15','2025-11-29 08:32:20','2025-11-29 08:32:20',1),(554,'fde91722-ea74-45a9-b57b-7fc9203f0965','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 08:31:15','2025-11-29 08:32:20','2025-11-29 08:32:20',1),(555,'fde91722-ea74-45a9-b57b-7fc9203f0965','owner_user_name','tempest-AttachVolumeShelveTestJSON-1751768432-project-member','2025-11-29 08:31:15','2025-11-29 08:32:20','2025-11-29 08:32:20',1),(556,'fde91722-ea74-45a9-b57b-7fc9203f0965','owner_project_name','tempest-AttachVolumeShelveTestJSON-1751768432','2025-11-29 08:31:15','2025-11-29 08:32:20','2025-11-29 08:32:20',1),(557,'fde91722-ea74-45a9-b57b-7fc9203f0965','boot_roles','member,reader','2025-11-29 08:31:15','2025-11-29 08:32:20','2025-11-29 08:32:20',1),(558,'fde91722-ea74-45a9-b57b-7fc9203f0965','hw_machine_type','q35','2025-11-29 08:31:15','2025-11-29 08:32:20','2025-11-29 08:32:20',1),(559,'fde91722-ea74-45a9-b57b-7fc9203f0965','hw_cdrom_bus','sata','2025-11-29 08:31:15','2025-11-29 08:32:20','2025-11-29 08:32:20',1),(560,'fde91722-ea74-45a9-b57b-7fc9203f0965','hw_disk_bus','virtio','2025-11-29 08:31:15','2025-11-29 08:32:20','2025-11-29 08:32:20',1),(561,'fde91722-ea74-45a9-b57b-7fc9203f0965','hw_input_bus','usb','2025-11-29 08:31:15','2025-11-29 08:32:20','2025-11-29 08:32:20',1),(562,'fde91722-ea74-45a9-b57b-7fc9203f0965','hw_pointer_model','usbtablet','2025-11-29 08:31:15','2025-11-29 08:32:20','2025-11-29 08:32:20',1),(563,'fde91722-ea74-45a9-b57b-7fc9203f0965','hw_video_model','virtio','2025-11-29 08:31:15','2025-11-29 08:32:20','2025-11-29 08:32:20',1),(564,'fde91722-ea74-45a9-b57b-7fc9203f0965','hw_vif_model','virtio','2025-11-29 08:31:15','2025-11-29 08:32:20','2025-11-29 08:32:20',1),(565,'fde91722-ea74-45a9-b57b-7fc9203f0965','instance_uuid','4d6c236c-ba8a-44dc-8413-3d4bfc16ec56','2025-11-29 08:31:15','2025-11-29 08:32:20','2025-11-29 08:32:20',1),(566,'fde91722-ea74-45a9-b57b-7fc9203f0965','user_id','e6de0587a3794e30acefc687f435d388','2025-11-29 08:31:15','2025-11-29 08:32:20','2025-11-29 08:32:20',1),(567,'fde91722-ea74-45a9-b57b-7fc9203f0965','image_type','snapshot','2025-11-29 08:31:15','2025-11-29 08:32:20','2025-11-29 08:32:20',1),(568,'fde91722-ea74-45a9-b57b-7fc9203f0965','image_location','snapshot','2025-11-29 08:31:33','2025-11-29 08:32:20','2025-11-29 08:32:20',1),(569,'fde91722-ea74-45a9-b57b-7fc9203f0965','image_state','available','2025-11-29 08:31:33','2025-11-29 08:32:20','2025-11-29 08:32:20',1),(570,'fde91722-ea74-45a9-b57b-7fc9203f0965','owner_id','37972b49ddde4c519c6523d2ea1569b5','2025-11-29 08:31:33','2025-11-29 08:32:20','2025-11-29 08:32:20',1),(571,'5e39b3d9-9c5d-4d2b-801f-dfff461af72e','hw_rng_model','virtio','2025-11-29 08:33:45','2025-11-29 08:34:17','2025-11-29 08:34:17',1),(572,'5e39b3d9-9c5d-4d2b-801f-dfff461af72e','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 08:33:45','2025-11-29 08:34:17','2025-11-29 08:34:17',1),(573,'5e39b3d9-9c5d-4d2b-801f-dfff461af72e','owner_user_name','tempest-AttachVolumeShelveTestJSON-1751768432-project-member','2025-11-29 08:33:45','2025-11-29 08:34:17','2025-11-29 08:34:17',1),(574,'5e39b3d9-9c5d-4d2b-801f-dfff461af72e','owner_project_name','tempest-AttachVolumeShelveTestJSON-1751768432','2025-11-29 08:33:45','2025-11-29 08:34:17','2025-11-29 08:34:17',1),(575,'5e39b3d9-9c5d-4d2b-801f-dfff461af72e','boot_roles','member,reader','2025-11-29 08:33:45','2025-11-29 08:34:17','2025-11-29 08:34:17',1),(576,'5e39b3d9-9c5d-4d2b-801f-dfff461af72e','hw_machine_type','q35','2025-11-29 08:33:45','2025-11-29 08:34:17','2025-11-29 08:34:17',1),(577,'5e39b3d9-9c5d-4d2b-801f-dfff461af72e','hw_cdrom_bus','sata','2025-11-29 08:33:45','2025-11-29 08:34:17','2025-11-29 08:34:17',1),(578,'5e39b3d9-9c5d-4d2b-801f-dfff461af72e','hw_disk_bus','virtio','2025-11-29 08:33:45','2025-11-29 08:34:17','2025-11-29 08:34:17',1),(579,'5e39b3d9-9c5d-4d2b-801f-dfff461af72e','hw_input_bus','usb','2025-11-29 08:33:45','2025-11-29 08:34:17','2025-11-29 08:34:17',1),(580,'5e39b3d9-9c5d-4d2b-801f-dfff461af72e','hw_pointer_model','usbtablet','2025-11-29 08:33:45','2025-11-29 08:34:17','2025-11-29 08:34:17',1),(581,'5e39b3d9-9c5d-4d2b-801f-dfff461af72e','hw_video_model','virtio','2025-11-29 08:33:45','2025-11-29 08:34:17','2025-11-29 08:34:17',1),(582,'5e39b3d9-9c5d-4d2b-801f-dfff461af72e','hw_vif_model','virtio','2025-11-29 08:33:45','2025-11-29 08:34:17','2025-11-29 08:34:17',1),(583,'5e39b3d9-9c5d-4d2b-801f-dfff461af72e','instance_uuid','f7256761-4dda-41d4-bd20-f34c7a8478ef','2025-11-29 08:33:45','2025-11-29 08:34:17','2025-11-29 08:34:17',1),(584,'5e39b3d9-9c5d-4d2b-801f-dfff461af72e','user_id','e6de0587a3794e30acefc687f435d388','2025-11-29 08:33:45','2025-11-29 08:34:17','2025-11-29 08:34:17',1),(585,'5e39b3d9-9c5d-4d2b-801f-dfff461af72e','image_type','snapshot','2025-11-29 08:33:45','2025-11-29 08:34:17','2025-11-29 08:34:17',1),(586,'5e39b3d9-9c5d-4d2b-801f-dfff461af72e','image_state','available','2025-11-29 08:33:56','2025-11-29 08:34:17','2025-11-29 08:34:17',1),(587,'5e39b3d9-9c5d-4d2b-801f-dfff461af72e','owner_id','37972b49ddde4c519c6523d2ea1569b5','2025-11-29 08:33:56','2025-11-29 08:34:17','2025-11-29 08:34:17',1),(588,'5e39b3d9-9c5d-4d2b-801f-dfff461af72e','image_location','snapshot','2025-11-29 08:33:56','2025-11-29 08:34:17','2025-11-29 08:34:17',1),(589,'73ec6614-8649-4526-8040-59b3499a752c','hw_rng_model','virtio','2025-11-29 08:47:57','2025-11-29 08:48:26','2025-11-29 08:48:26',1),(590,'73ec6614-8649-4526-8040-59b3499a752c','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 08:47:57','2025-11-29 08:48:26','2025-11-29 08:48:26',1),(591,'73ec6614-8649-4526-8040-59b3499a752c','owner_user_name','tempest-TestShelveInstance-1715482181-project-member','2025-11-29 08:47:57','2025-11-29 08:48:26','2025-11-29 08:48:26',1),(592,'73ec6614-8649-4526-8040-59b3499a752c','owner_project_name','tempest-TestShelveInstance-1715482181','2025-11-29 08:47:57','2025-11-29 08:48:26','2025-11-29 08:48:26',1),(593,'73ec6614-8649-4526-8040-59b3499a752c','boot_roles','member,reader','2025-11-29 08:47:57','2025-11-29 08:48:26','2025-11-29 08:48:26',1),(594,'73ec6614-8649-4526-8040-59b3499a752c','hw_machine_type','q35','2025-11-29 08:47:57','2025-11-29 08:48:26','2025-11-29 08:48:26',1),(595,'73ec6614-8649-4526-8040-59b3499a752c','hw_cdrom_bus','sata','2025-11-29 08:47:57','2025-11-29 08:48:26','2025-11-29 08:48:26',1),(596,'73ec6614-8649-4526-8040-59b3499a752c','hw_disk_bus','virtio','2025-11-29 08:47:57','2025-11-29 08:48:26','2025-11-29 08:48:26',1),(597,'73ec6614-8649-4526-8040-59b3499a752c','hw_input_bus','usb','2025-11-29 08:47:57','2025-11-29 08:48:26','2025-11-29 08:48:26',1),(598,'73ec6614-8649-4526-8040-59b3499a752c','hw_pointer_model','usbtablet','2025-11-29 08:47:57','2025-11-29 08:48:26','2025-11-29 08:48:26',1),(599,'73ec6614-8649-4526-8040-59b3499a752c','hw_video_model','virtio','2025-11-29 08:47:57','2025-11-29 08:48:26','2025-11-29 08:48:26',1),(600,'73ec6614-8649-4526-8040-59b3499a752c','hw_vif_model','virtio','2025-11-29 08:47:57','2025-11-29 08:48:26','2025-11-29 08:48:26',1),(601,'73ec6614-8649-4526-8040-59b3499a752c','instance_uuid','6eda2a5e-bf92-4d34-b21e-ca4eaf01728b','2025-11-29 08:47:57','2025-11-29 08:48:26','2025-11-29 08:48:26',1),(602,'73ec6614-8649-4526-8040-59b3499a752c','user_id','5dbbf4fd34004538ad08aa4aa6ab8096','2025-11-29 08:47:57','2025-11-29 08:48:26','2025-11-29 08:48:26',1),(603,'73ec6614-8649-4526-8040-59b3499a752c','image_type','snapshot','2025-11-29 08:47:57','2025-11-29 08:48:26','2025-11-29 08:48:26',1),(604,'73ec6614-8649-4526-8040-59b3499a752c','owner_id','c5e836f8387a492c8119be72f1fb9980','2025-11-29 08:48:05','2025-11-29 08:48:26','2025-11-29 08:48:26',1),(605,'73ec6614-8649-4526-8040-59b3499a752c','image_state','available','2025-11-29 08:48:05','2025-11-29 08:48:26','2025-11-29 08:48:26',1),(606,'73ec6614-8649-4526-8040-59b3499a752c','image_location','snapshot','2025-11-29 08:48:05','2025-11-29 08:48:26','2025-11-29 08:48:26',1),(607,'a7583cd4-d395-48e2-9f81-567bf2845ae0','hw_rng_model','virtio','2025-11-29 08:52:07','2025-11-29 08:53:23','2025-11-29 08:53:23',1),(608,'a7583cd4-d395-48e2-9f81-567bf2845ae0','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 08:52:07','2025-11-29 08:53:23','2025-11-29 08:53:23',1),(609,'a7583cd4-d395-48e2-9f81-567bf2845ae0','owner_user_name','tempest-TestSnapshotPattern-32695225-project-member','2025-11-29 08:52:07','2025-11-29 08:53:23','2025-11-29 08:53:23',1),(610,'a7583cd4-d395-48e2-9f81-567bf2845ae0','owner_project_name','tempest-TestSnapshotPattern-32695225','2025-11-29 08:52:07','2025-11-29 08:53:23','2025-11-29 08:53:23',1),(611,'a7583cd4-d395-48e2-9f81-567bf2845ae0','boot_roles','member,reader','2025-11-29 08:52:07','2025-11-29 08:53:23','2025-11-29 08:53:23',1),(612,'a7583cd4-d395-48e2-9f81-567bf2845ae0','hw_machine_type','q35','2025-11-29 08:52:07','2025-11-29 08:53:23','2025-11-29 08:53:23',1),(613,'a7583cd4-d395-48e2-9f81-567bf2845ae0','hw_cdrom_bus','sata','2025-11-29 08:52:07','2025-11-29 08:53:23','2025-11-29 08:53:23',1),(614,'a7583cd4-d395-48e2-9f81-567bf2845ae0','hw_disk_bus','virtio','2025-11-29 08:52:07','2025-11-29 08:53:23','2025-11-29 08:53:23',1),(615,'a7583cd4-d395-48e2-9f81-567bf2845ae0','hw_input_bus','usb','2025-11-29 08:52:07','2025-11-29 08:53:23','2025-11-29 08:53:23',1),(616,'a7583cd4-d395-48e2-9f81-567bf2845ae0','hw_pointer_model','usbtablet','2025-11-29 08:52:07','2025-11-29 08:53:23','2025-11-29 08:53:23',1),(617,'a7583cd4-d395-48e2-9f81-567bf2845ae0','hw_video_model','virtio','2025-11-29 08:52:07','2025-11-29 08:53:23','2025-11-29 08:53:23',1),(618,'a7583cd4-d395-48e2-9f81-567bf2845ae0','hw_vif_model','virtio','2025-11-29 08:52:07','2025-11-29 08:53:23','2025-11-29 08:53:23',1),(619,'a7583cd4-d395-48e2-9f81-567bf2845ae0','instance_uuid','defc87c3-85a5-47bb-8d50-3121d5d780c1','2025-11-29 08:52:07','2025-11-29 08:53:23','2025-11-29 08:53:23',1),(620,'a7583cd4-d395-48e2-9f81-567bf2845ae0','user_id','7b36e3f2406043c2a741c24fb14de7df','2025-11-29 08:52:07','2025-11-29 08:53:23','2025-11-29 08:53:23',1),(621,'a7583cd4-d395-48e2-9f81-567bf2845ae0','image_type','snapshot','2025-11-29 08:52:07','2025-11-29 08:53:23','2025-11-29 08:53:23',1),(622,'a7583cd4-d395-48e2-9f81-567bf2845ae0','owner_id','0596f9d1e5a5444ca2640f6e8244d53f','2025-11-29 08:52:12','2025-11-29 08:53:23','2025-11-29 08:53:23',1),(623,'a7583cd4-d395-48e2-9f81-567bf2845ae0','image_state','available','2025-11-29 08:52:12','2025-11-29 08:53:23','2025-11-29 08:53:23',1),(624,'a7583cd4-d395-48e2-9f81-567bf2845ae0','image_location','snapshot','2025-11-29 08:52:12','2025-11-29 08:53:23','2025-11-29 08:53:23',1),(625,'a7583cd4-d395-48e2-9f81-567bf2845ae0','version','8.0','2025-11-29 08:52:14','2025-11-29 08:53:23','2025-11-29 08:53:23',1),(626,'89a98419-7cd2-49c3-aac2-95418a57f2f6','hw_rng_model','virtio','2025-11-29 08:53:08','2025-11-29 08:53:15','2025-11-29 08:53:15',1),(627,'89a98419-7cd2-49c3-aac2-95418a57f2f6','base_image_ref','1be11678-cfa4-4dee-b54c-6c7e547e5a6a','2025-11-29 08:53:08','2025-11-29 08:53:15','2025-11-29 08:53:15',1),(628,'89a98419-7cd2-49c3-aac2-95418a57f2f6','owner_user_name','tempest-TestSnapshotPattern-32695225-project-member','2025-11-29 08:53:08','2025-11-29 08:53:15','2025-11-29 08:53:15',1),(629,'89a98419-7cd2-49c3-aac2-95418a57f2f6','owner_project_name','tempest-TestSnapshotPattern-32695225','2025-11-29 08:53:08','2025-11-29 08:53:15','2025-11-29 08:53:15',1),(630,'89a98419-7cd2-49c3-aac2-95418a57f2f6','boot_roles','member,reader','2025-11-29 08:53:08','2025-11-29 08:53:15','2025-11-29 08:53:15',1),(631,'89a98419-7cd2-49c3-aac2-95418a57f2f6','hw_machine_type','q35','2025-11-29 08:53:08','2025-11-29 08:53:15','2025-11-29 08:53:15',1),(632,'89a98419-7cd2-49c3-aac2-95418a57f2f6','hw_cdrom_bus','sata','2025-11-29 08:53:08','2025-11-29 08:53:15','2025-11-29 08:53:15',1),(633,'89a98419-7cd2-49c3-aac2-95418a57f2f6','hw_disk_bus','virtio','2025-11-29 08:53:08','2025-11-29 08:53:15','2025-11-29 08:53:15',1),(634,'89a98419-7cd2-49c3-aac2-95418a57f2f6','hw_input_bus','usb','2025-11-29 08:53:08','2025-11-29 08:53:15','2025-11-29 08:53:15',1),(635,'89a98419-7cd2-49c3-aac2-95418a57f2f6','hw_pointer_model','usbtablet','2025-11-29 08:53:08','2025-11-29 08:53:15','2025-11-29 08:53:15',1),(636,'89a98419-7cd2-49c3-aac2-95418a57f2f6','hw_video_model','virtio','2025-11-29 08:53:08','2025-11-29 08:53:15','2025-11-29 08:53:15',1),(637,'89a98419-7cd2-49c3-aac2-95418a57f2f6','hw_vif_model','virtio','2025-11-29 08:53:08','2025-11-29 08:53:15','2025-11-29 08:53:15',1),(638,'89a98419-7cd2-49c3-aac2-95418a57f2f6','instance_uuid','66ab0bd5-ae63-4ae2-af64-ae8b85745f24','2025-11-29 08:53:08','2025-11-29 08:53:15','2025-11-29 08:53:15',1),(639,'89a98419-7cd2-49c3-aac2-95418a57f2f6','user_id','7b36e3f2406043c2a741c24fb14de7df','2025-11-29 08:53:08','2025-11-29 08:53:15','2025-11-29 08:53:15',1),(640,'89a98419-7cd2-49c3-aac2-95418a57f2f6','image_type','snapshot','2025-11-29 08:53:08','2025-11-29 08:53:15','2025-11-29 08:53:15',1),(641,'89a98419-7cd2-49c3-aac2-95418a57f2f6','owner_id','0596f9d1e5a5444ca2640f6e8244d53f','2025-11-29 08:53:08','2025-11-29 08:53:15','2025-11-29 08:53:15',1),(642,'89a98419-7cd2-49c3-aac2-95418a57f2f6','image_state','available','2025-11-29 08:53:08','2025-11-29 08:53:15','2025-11-29 08:53:15',1),(643,'89a98419-7cd2-49c3-aac2-95418a57f2f6','image_location','snapshot','2025-11-29 08:53:08','2025-11-29 08:53:15','2025-11-29 08:53:15',1),(644,'89a98419-7cd2-49c3-aac2-95418a57f2f6','version','8.0','2025-11-29 08:53:08','2025-11-29 08:53:15','2025-11-29 08:53:15',1),(645,'9edb158f-7f78-4486-aa1c-e248407be0c7','signature_verified','False','2025-11-29 09:11:37','2025-11-29 09:13:09','2025-11-29 09:13:09',1),(646,'9edb158f-7f78-4486-aa1c-e248407be0c7','hw_rng_model','virtio','2025-11-29 09:11:37','2025-11-29 09:13:09','2025-11-29 09:13:09',1),(647,'9edb158f-7f78-4486-aa1c-e248407be0c7','base_image_ref','','2025-11-29 09:11:37','2025-11-29 09:13:09','2025-11-29 09:13:09',1),(648,'9edb158f-7f78-4486-aa1c-e248407be0c7','owner_user_name','tempest-TestVolumeBootPattern-531976395-project-member','2025-11-29 09:11:37','2025-11-29 09:13:09','2025-11-29 09:13:09',1),(649,'9edb158f-7f78-4486-aa1c-e248407be0c7','owner_project_name','tempest-TestVolumeBootPattern-531976395','2025-11-29 09:11:37','2025-11-29 09:13:09','2025-11-29 09:13:09',1),(650,'9edb158f-7f78-4486-aa1c-e248407be0c7','boot_roles','member,reader','2025-11-29 09:11:37','2025-11-29 09:13:09','2025-11-29 09:13:09',1),(651,'9edb158f-7f78-4486-aa1c-e248407be0c7','hw_machine_type','q35','2025-11-29 09:11:37','2025-11-29 09:13:09','2025-11-29 09:13:09',1),(652,'9edb158f-7f78-4486-aa1c-e248407be0c7','hw_cdrom_bus','sata','2025-11-29 09:11:37','2025-11-29 09:13:09','2025-11-29 09:13:09',1),(653,'9edb158f-7f78-4486-aa1c-e248407be0c7','hw_disk_bus','virtio','2025-11-29 09:11:37','2025-11-29 09:13:09','2025-11-29 09:13:09',1),(654,'9edb158f-7f78-4486-aa1c-e248407be0c7','hw_input_bus','usb','2025-11-29 09:11:37','2025-11-29 09:13:09','2025-11-29 09:13:09',1),(655,'9edb158f-7f78-4486-aa1c-e248407be0c7','hw_pointer_model','usbtablet','2025-11-29 09:11:37','2025-11-29 09:13:10','2025-11-29 09:13:10',1),(656,'9edb158f-7f78-4486-aa1c-e248407be0c7','hw_video_model','virtio','2025-11-29 09:11:37','2025-11-29 09:13:10','2025-11-29 09:13:10',1),(657,'9edb158f-7f78-4486-aa1c-e248407be0c7','hw_vif_model','virtio','2025-11-29 09:11:37','2025-11-29 09:13:10','2025-11-29 09:13:10',1),(658,'9edb158f-7f78-4486-aa1c-e248407be0c7','root_device_name','/dev/vda','2025-11-29 09:11:37','2025-11-29 09:13:10','2025-11-29 09:13:10',1),(659,'9edb158f-7f78-4486-aa1c-e248407be0c7','block_device_mapping','[{\"delete_on_termination\": true, \"device_name\": \"/dev/vda\", \"volume_id\": null, \"disk_bus\": \"virtio\", \"guest_format\": null, \"source_type\": \"snapshot\", \"snapshot_id\": \"30784891-c32c-4cd3-8120-4b3acd34934a\", \"image_id\": null, \"destination_type\": \"volume\", \"tag\": null, \"volume_type\": null, \"no_device\": null, \"volume_size\": 1, \"encryption_format\": null, \"boot_index\": 0, \"encrypted\": null, \"device_type\": \"disk\", \"encryption_options\": null, \"encryption_secret_uuid\": null}]','2025-11-29 09:11:37','2025-11-29 09:13:10','2025-11-29 09:13:10',1),(660,'9edb158f-7f78-4486-aa1c-e248407be0c7','bdm_v2','True','2025-11-29 09:11:37','2025-11-29 09:13:10','2025-11-29 09:13:10',1);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('0136f9fb-9ab3-4552-8505-f62bd960c3d5','tempest-backup-2-728757861',1073741824,'deleted','2025-11-29 08:11:00','2025-11-29 08:11:19','2025-11-29 08:11:19',1,'raw','bare',NULL,'ba867fac17034bb28fe2cdb0fff3af2b',1,0,0,NULL,'private',0,NULL,NULL),('10d0dcc8-92b3-4e29-baff-aaa5549dce70','tempest-ServerStableDeviceRescueTest-image-1993878135',1073741824,'deleted','2025-11-29 08:21:33','2025-11-29 08:22:50','2025-11-29 08:22:50',1,'raw','bare',NULL,'358970eca7ad4b05b70f43e5507ac052',1,0,0,NULL,'private',0,NULL,NULL),('19d37975-6e79-4fd9-8985-4a51a67c9db3','tempest-backup-1-1058543412',1073741824,'deleted','2025-11-29 08:10:53','2025-11-29 08:11:14','2025-11-29 08:11:14',1,'raw','bare',NULL,'ba867fac17034bb28fe2cdb0fff3af2b',1,0,0,NULL,'private',0,NULL,NULL),('1b6ee968-62a2-4023-a5bf-e3fec39abfbe','multiattach-snapshot',0,'deleted','2025-11-29 08:29:41','2025-11-29 08:29:55','2025-11-29 08:29:55',1,'qcow2','bare','d41d8cd98f00b204e9800998ecf8427e','23450c2eaf4442459dec94c6d29f0412',1,0,0,NULL,'private',0,'sha512','cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e'),('1be11678-cfa4-4dee-b54c-6c7e547e5a6a','cirros-0.6.2-x86_64-disk.img',21430272,'active','2025-11-29 07:39:56','2025-11-29 07:40:36',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','532b69b8d9eb42e8a1aed36b5ddb038a',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('29125612-6fcb-47b2-8690-67e6e3459b96','tempest-TestStampPatternsnapshot-1177154409',1073741824,'deleted','2025-11-29 08:31:03','2025-11-29 08:32:33','2025-11-29 08:32:33',1,'raw','bare',NULL,'7e8e7407a7c44208a503e8225c1cf518',1,0,0,NULL,'private',0,NULL,NULL),('2c100ba6-aad9-4f8a-a5b0-c35f5675fe20','tempest-₡-153092360',1073741824,'deleted','2025-11-29 07:54:40','2025-11-29 07:55:01','2025-11-29 07:55:01',1,'raw','bare',NULL,'e6ba183d92db4c6795dd0f44dc77fad4',1,0,0,NULL,'private',0,NULL,NULL),('305868a8-2835-47a9-b3a6-72fd47849d38','tempest-image-7553237',2295,'deleted','2025-11-29 07:54:51','2025-11-29 07:55:05','2025-11-29 07:55:05',1,'qcow2','bare','a0041ccad52ccef4db551469a7cde6bd','355df1412457489ba86a191b04822a35',0,129,0,NULL,'private',0,'sha512','d28cec13341eb5c1d55fd0ed32c050fec12cfbb7122b90f0d703a078d97e6ae829d9adfa4f7df160497d264788001f43b7ebc8f7bcad9f76ca981e7a9c052709'),('32b89eea-531a-4341-b175-80b921fa7805','tempest-test-snap-1407783821',1073741824,'deleted','2025-11-29 07:59:29','2025-11-29 07:59:49','2025-11-29 07:59:49',1,'raw','bare',NULL,'4d8c5b7e3ca74bc1880eb616b04711f7',1,0,0,NULL,'private',0,NULL,NULL),('33939db1-a4ae-4fac-9a69-88ed807d304b','tempest-UnshelveToHostMultiNodesTest-server-1579333464-shelved',1073741824,'deleted','2025-11-29 07:50:38','2025-11-29 07:51:37','2025-11-29 07:51:37',1,'raw','bare',NULL,'cf226b9a5bb945c3a8f54976b5736fe3',1,0,0,NULL,'private',0,NULL,NULL),('35f0e8d7-af49-4580-985f-4286c576c2fc','tempest-backup-1-238266449',NULL,'deleted','2025-11-29 08:16:25','2025-11-29 08:16:26','2025-11-29 08:16:26',1,'qcow2','bare',NULL,'450ea210ad0e4364901c0d605c869a2c',1,0,0,NULL,'private',0,NULL,NULL),('36972a45-a1b4-44eb-9fc1-abe990709f21','tempest-ListImageFiltersTestJSON-image-1433430563',1073741824,'deleted','2025-11-29 07:58:08','2025-11-29 07:58:43','2025-11-29 07:58:43',1,'raw','bare',NULL,'30d42ce85b6840c6942b24cf4a7b9d64',1,0,0,NULL,'private',0,NULL,NULL),('4997c363-307f-4918-8be4-b61ff6b9c1ff','tempest-ImagesOneServerNegativeTestJSON-image-1297108353',NULL,'deleted','2025-11-29 07:56:35','2025-11-29 07:56:36','2025-11-29 07:56:35',1,NULL,NULL,NULL,'219d722e6a2c4164be5a30e9565f13a0',1,0,0,NULL,'private',0,NULL,NULL),('49b84182-d6c5-4bdc-9e97-50145d5437cf','tempest-test-snap-1733613230',1073741824,'deleted','2025-11-29 07:58:04','2025-11-29 07:58:24','2025-11-29 07:58:24',1,'raw','bare',NULL,'4d8c5b7e3ca74bc1880eb616b04711f7',1,0,0,NULL,'private',0,NULL,NULL),('4e6c48a5-2a39-4c6b-9d29-a38ef7a8b4b6','tempest-test-snap-1119490671',NULL,'deleted','2025-11-29 08:01:47','2025-11-29 08:01:52','2025-11-29 08:01:52',1,NULL,NULL,NULL,'4d8c5b7e3ca74bc1880eb616b04711f7',1,0,0,NULL,'private',0,NULL,NULL),('58caa074-39ec-4b44-8c78-60814a120dd3','tempest-ImagesOneServerNegativeTestJSON-image-619997216',NULL,'deleted','2025-11-29 07:55:57','2025-11-29 07:55:57','2025-11-29 07:55:57',1,NULL,NULL,NULL,'219d722e6a2c4164be5a30e9565f13a0',1,0,0,NULL,'private',0,NULL,NULL),('5945a148-7986-4fa0-8052-c380ea11f788','tempest-ServersNegativeTestJSON-server-1933381778-shelved',1073741824,'deleted','2025-11-29 08:26:02','2025-11-29 08:26:47','2025-11-29 08:26:47',1,'raw','bare',NULL,'d9406fbc6fef486fa5b0e79549e78d00',1,0,0,NULL,'private',0,NULL,NULL),('5b6878f5-ee6a-4f36-b7ce-cdb9894ce54c','tempest-ServerStableDeviceRescueTest-image-2080694992',1073741824,'deleted','2025-11-29 08:20:13','2025-11-29 08:22:58','2025-11-29 08:22:58',1,'raw','bare',NULL,'358970eca7ad4b05b70f43e5507ac052',1,0,0,NULL,'private',0,NULL,NULL),('5db9d02f-2f54-48e1-952b-46fcc86d3d02','tempest-test-snap-676648885',1073741824,'deleted','2025-11-29 08:00:11','2025-11-29 08:00:21','2025-11-29 08:00:21',1,'raw','bare',NULL,'4d8c5b7e3ca74bc1880eb616b04711f7',1,0,0,NULL,'private',0,NULL,NULL),('5e39b3d9-9c5d-4d2b-801f-dfff461af72e','tempest-AttachVolumeShelveTestJSON-server-206995635-shelved',1073741824,'deleted','2025-11-29 08:33:45','2025-11-29 08:34:17','2025-11-29 08:34:17',1,'raw','bare',NULL,'37972b49ddde4c519c6523d2ea1569b5',1,0,0,NULL,'private',0,NULL,NULL),('67b4b12c-5f96-4d5d-a734-669efbd0af6b',NULL,21430272,'deleted','2025-11-29 07:54:15','2025-11-29 07:55:51','2025-11-29 07:55:51',1,'qcow2','bare','c8fc807773e5354afe61636071771906','badfd9b8c0284ad9ba375f3f5932ae19',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('68d9094a-a514-4c4f-a0d2-50c99d09fcfc','tempest-image-549869309',1024,'deleted','2025-11-29 07:56:52','2025-11-29 07:57:14','2025-11-29 07:57:14',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','3b4124e85e7b43c8be676b077864835f',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('7125fca0-e10e-42cb-acad-616c180d5096','tempest-image-1947754594',1073741824,'deleted','2025-11-29 07:54:18','2025-11-29 07:54:39','2025-11-29 07:54:39',1,'raw','bare',NULL,'e6ba183d92db4c6795dd0f44dc77fad4',1,0,0,NULL,'private',0,NULL,NULL),('73295910-5010-42bf-ac24-9ee2d7bb4671','tempest-UnshelveToHostMultiNodesTest-server-1579333464-shelved',1073741824,'deleted','2025-11-29 07:49:48','2025-11-29 07:50:36','2025-11-29 07:50:36',1,'raw','bare',NULL,'cf226b9a5bb945c3a8f54976b5736fe3',1,0,0,NULL,'private',0,NULL,NULL),('73ec6614-8649-4526-8040-59b3499a752c','tempest-TestShelveInstance-server-74860485-shelved',1073741824,'deleted','2025-11-29 08:47:57','2025-11-29 08:48:26','2025-11-29 08:48:26',1,'raw','bare',NULL,'c5e836f8387a492c8119be72f1fb9980',1,0,0,NULL,'private',0,NULL,NULL),('79df671d-c55d-4ae7-bed4-66b1126df827','tempest-DeleteServersTestJSON-server-1390090872-shelved',1073741824,'deleted','2025-11-29 08:04:10','2025-11-29 08:04:39','2025-11-29 08:04:39',1,'raw','bare',NULL,'f8bc2a2616a34ba1a18b3211e406993f',1,0,0,NULL,'private',0,NULL,NULL),('89a98419-7cd2-49c3-aac2-95418a57f2f6','tempest-TestSnapshotPatternsnapshot-1611417956',1073741824,'deleted','2025-11-29 08:53:08','2025-11-29 08:53:15','2025-11-29 08:53:15',1,'raw','bare',NULL,'0596f9d1e5a5444ca2640f6e8244d53f',1,0,0,NULL,'private',0,NULL,NULL),('995630c6-dc23-4abf-afc5-51778a6f1496','tempest-ServerBootFromVolumeStableRescueTest-image-602458161',1073741824,'deleted','2025-11-29 08:17:52','2025-11-29 08:21:13','2025-11-29 08:21:13',1,'raw','bare',NULL,'b9d4c81989d641678300c7a1c173a2c2',1,0,0,NULL,'private',0,NULL,NULL),('9edb158f-7f78-4486-aa1c-e248407be0c7','tempest-TestVolumeBootPatternsnapshot-892575640',0,'deleted','2025-11-29 09:11:37','2025-11-29 09:13:10','2025-11-29 09:13:10',1,'qcow2','bare','d41d8cd98f00b204e9800998ecf8427e','51af0a2ee11a460ab825a484e5c6f4a3',1,0,0,NULL,'private',0,'sha512','cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e'),('a49a2108-5e46-47ff-8e29-481726f9db30','tempest-ListImageFiltersTestJSON-image-1020754993',1024,'deleted','2025-11-29 07:57:27','2025-11-29 07:59:17','2025-11-29 07:59:17',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','30d42ce85b6840c6942b24cf4a7b9d64',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('a7583cd4-d395-48e2-9f81-567bf2845ae0','tempest-TestSnapshotPatternsnapshot-1017606698',1073741824,'deleted','2025-11-29 08:52:07','2025-11-29 08:53:23','2025-11-29 08:53:23',1,'raw','bare',NULL,'0596f9d1e5a5444ca2640f6e8244d53f',1,0,0,NULL,'private',0,NULL,NULL),('a83442a1-fb28-462f-8936-713084bd46ef','tempest-ServerActionsTestOtherB-server-694037075-shelved',1073741824,'deleted','2025-11-29 08:15:50','2025-11-29 08:16:23','2025-11-29 08:16:23',1,'raw','bare',NULL,'ba867fac17034bb28fe2cdb0fff3af2b',1,0,0,NULL,'private',0,NULL,NULL),('a949de33-fe8e-409f-9e15-d50c466534f9','tempest-ServerActionsTestOtherB-server-1616306290-shelved',1073741824,'deleted','2025-11-29 08:15:35','2025-11-29 08:16:27','2025-11-29 08:16:27',1,'raw','bare',NULL,'ba867fac17034bb28fe2cdb0fff3af2b',1,0,0,NULL,'private',0,NULL,NULL),('aad237b6-caeb-4300-902b-ba8936a7053b','tempest-scenario-img--154480173',21430272,'deleted','2025-11-29 08:27:38','2025-11-29 08:29:34','2025-11-29 08:29:34',1,'qcow2','bare','c8fc807773e5354afe61636071771906','f9a9decdabb1480da8f7d039e8b3d414',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('b01ef350-a5c1-4fa3-afd2-96dd9326703d','tempest-ServerStableDeviceRescueTest-image-1188685445',1073741824,'deleted','2025-11-29 08:18:36','2025-11-29 08:23:12','2025-11-29 08:23:12',1,'raw','bare',NULL,'358970eca7ad4b05b70f43e5507ac052',1,0,0,NULL,'private',0,NULL,NULL),('b70f1fb0-c9d8-4075-87c8-fc7a840ab566','tempest-ListImageFiltersTestJSON-image-1007812034',1024,'deleted','2025-11-29 07:57:17','2025-11-29 07:59:28','2025-11-29 07:59:28',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','30d42ce85b6840c6942b24cf4a7b9d64',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('bb915321-974b-4310-80ce-22fe787becec','tempest-test-snap-142131752',1073741824,'deleted','2025-11-29 08:00:39','2025-11-29 08:01:22','2025-11-29 08:01:22',1,'raw','bare',NULL,'4d8c5b7e3ca74bc1880eb616b04711f7',1,0,0,NULL,'private',0,NULL,NULL),('bf0aed8c-3418-4a5d-ab36-68410b6b956c','tempest-ServerBootFromVolumeStableRescueTest-image-1199737480',1073741824,'deleted','2025-11-29 08:19:55','2025-11-29 08:21:03','2025-11-29 08:21:03',1,'raw','bare',NULL,'b9d4c81989d641678300c7a1c173a2c2',1,0,0,NULL,'private',0,NULL,NULL),('c02352c0-4a84-408b-a38c-1ebe85e285cf','tempest-backup-3-328356257',1073741824,'deleted','2025-11-29 08:11:07','2025-11-29 08:11:18','2025-11-29 08:11:18',1,'raw','bare',NULL,'ba867fac17034bb28fe2cdb0fff3af2b',1,0,0,NULL,'private',0,NULL,NULL),('d9469d26-d189-44ee-a659-1398ee5e0da2','tempest-scenario-img--138307583',21430272,'deleted','2025-11-29 08:25:38','2025-11-29 08:27:38','2025-11-29 08:27:38',1,'qcow2','bare','c8fc807773e5354afe61636071771906','f9a9decdabb1480da8f7d039e8b3d414',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('da4d6473-f717-4c5a-9ebf-ff94b495aeb0','tempest-scenario-img--1390363549',21430272,'deleted','2025-11-29 08:28:20','2025-11-29 08:31:46','2025-11-29 08:31:46',1,'qcow2','bare','c8fc807773e5354afe61636071771906','527c6a274d1e478eadfe67139e121185',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('df78a6c7-19bb-4390-bc30-7251b87a9d47','tempest-ListImageFiltersTestJSON-image-189027152',1073741824,'deleted','2025-11-29 07:57:52','2025-11-29 07:58:45','2025-11-29 07:58:45',1,'raw','bare',NULL,'30d42ce85b6840c6942b24cf4a7b9d64',1,0,0,NULL,'private',0,NULL,NULL),('e372d671-0356-4b39-949b-13a58b062421','tempest-ServerStableDeviceRescueTest-image-71918663',1073741824,'deleted','2025-11-29 08:19:26','2025-11-29 08:23:04','2025-11-29 08:23:04',1,'raw','bare',NULL,'358970eca7ad4b05b70f43e5507ac052',1,0,0,NULL,'private',0,NULL,NULL),('e89bf772-b42e-4a81-949b-a562a33a3e0c','tempest-ListImageFiltersTestJSON-image-2099731506',1073741824,'deleted','2025-11-29 07:57:45','2025-11-29 07:58:48','2025-11-29 07:58:48',1,'raw','bare',NULL,'30d42ce85b6840c6942b24cf4a7b9d64',1,0,0,NULL,'private',0,NULL,NULL),('ed489666-5fa2-4ea4-8005-7a7505ac1b78','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2025-11-29 07:40:38','2025-11-29 07:40:58',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','532b69b8d9eb42e8a1aed36b5ddb038a',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('fc016565-453a-481e-b8ed-9b1e582842e0','tempest-ListImageFiltersTestJSON-image-1870754707',1024,'deleted','2025-11-29 07:57:22','2025-11-29 07:59:22','2025-11-29 07:59:22',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','30d42ce85b6840c6942b24cf4a7b9d64',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('fde91722-ea74-45a9-b57b-7fc9203f0965','tempest-AttachVolumeShelveTestJSON-server-935562196-shelved',1073741824,'deleted','2025-11-29 08:31:15','2025-11-29 08:32:20','2025-11-29 08:32:20',1,'raw','bare',NULL,'37972b49ddde4c519c6523d2ea1569b5',1,0,0,NULL,'private',0,NULL,NULL);
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2025-11-29 06:46:02',NULL),(1,2,'image','CIM_RASD_','2025-11-29 06:46:03',NULL),(1,3,NULL,'CIM_SASD_','2025-11-29 06:46:04',NULL),(1,9,'image','hw_','2025-11-29 06:46:07',NULL),(1,10,'image','hw_','2025-11-29 06:46:12',NULL),(1,14,'image',NULL,'2025-11-29 06:46:25',NULL),(1,19,'image','hw_','2025-11-29 06:49:13',NULL),(1,25,'image','hw_','2025-11-29 06:49:51',NULL),(1,29,'image',NULL,'2025-11-29 06:50:03',NULL),(1,30,'image',NULL,'2025-11-29 06:50:05',NULL),(1,31,'image',NULL,'2025-11-29 06:50:09',NULL),(1,32,'image',NULL,'2025-11-29 06:50:11',NULL),(2,1,NULL,'CIM_PASD_','2025-11-29 06:46:03',NULL),(2,8,NULL,'hw_','2025-11-29 06:46:07',NULL),(2,9,NULL,'hw_','2025-11-29 06:46:07',NULL),(2,10,NULL,'hw_','2025-11-29 06:46:12',NULL),(2,11,NULL,NULL,'2025-11-29 06:46:14',NULL),(2,13,NULL,NULL,'2025-11-29 06:46:24',NULL),(2,14,NULL,NULL,'2025-11-29 06:46:25',NULL),(2,15,NULL,NULL,'2025-11-29 06:46:28',NULL),(2,16,NULL,'hw_','2025-11-29 06:46:58',NULL),(2,19,NULL,'hw_','2025-11-29 06:49:13',NULL),(2,22,NULL,NULL,'2025-11-29 06:49:45',NULL),(2,23,NULL,'hw_','2025-11-29 06:49:49',NULL),(2,24,NULL,'traits:','2025-11-29 06:49:50',NULL),(2,25,NULL,'hw_','2025-11-29 06:49:51',NULL),(2,26,NULL,NULL,'2025-11-29 06:49:55',NULL),(2,28,NULL,NULL,'2025-11-29 06:50:02',NULL),(2,29,NULL,NULL,'2025-11-29 06:50:03',NULL),(2,30,NULL,NULL,'2025-11-29 06:50:05',NULL),(2,31,NULL,NULL,'2025-11-29 06:50:08',NULL),(2,32,NULL,NULL,'2025-11-29 06:50:11',NULL),(2,33,NULL,'cinder_','2025-11-29 06:50:12',NULL),(3,1,NULL,'CIM_PASD_','2025-11-29 06:46:03',NULL),(3,2,NULL,'CIM_RASD_','2025-11-29 06:46:03',NULL),(3,3,NULL,'CIM_SASD_','2025-11-29 06:46:04',NULL),(3,4,NULL,'CIM_VSSD_','2025-11-29 06:46:05',NULL),(3,5,NULL,NULL,'2025-11-29 06:46:06',NULL),(3,6,NULL,NULL,'2025-11-29 06:46:06',NULL),(3,7,NULL,NULL,'2025-11-29 06:46:07',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2025-11-29 06:46:21',NULL),(4,1,NULL,'CIM_PASD_','2025-11-29 06:46:03',NULL),(4,2,NULL,'CIM_RASD_','2025-11-29 06:46:03',NULL),(4,3,NULL,'CIM_SASD_','2025-11-29 06:46:04',NULL),(4,4,NULL,'CIM_VSSD_','2025-11-29 06:46:06',NULL),(4,8,NULL,'hw:','2025-11-29 06:46:07',NULL),(4,9,NULL,'hw:','2025-11-29 06:46:07',NULL),(4,10,NULL,'hw:','2025-11-29 06:46:12',NULL),(4,12,NULL,'capabilities:','2025-11-29 06:46:19',NULL),(4,16,NULL,'hw:','2025-11-29 06:46:59',NULL),(4,17,NULL,NULL,'2025-11-29 06:47:08',NULL),(4,18,NULL,NULL,'2025-11-29 06:49:04',NULL),(4,19,NULL,'hw:','2025-11-29 06:49:14',NULL),(4,20,NULL,NULL,'2025-11-29 06:49:29',NULL),(4,21,NULL,NULL,'2025-11-29 06:49:34',NULL),(4,23,NULL,'hw:','2025-11-29 06:49:48',NULL),(4,24,NULL,'traits:','2025-11-29 06:49:50',NULL),(4,25,NULL,'hw:','2025-11-29 06:49:51',NULL),(5,1,'scheduler_hints',NULL,'2025-11-29 06:46:03',NULL),(5,30,'metadata',NULL,'2025-11-29 06:50:05',NULL),(5,31,'metadata',NULL,'2025-11-29 06:50:09',NULL),(5,32,'metadata',NULL,'2025-11-29 06:50:11',NULL),(6,30,NULL,NULL,'2025-11-29 06:50:05',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2025-11-29 06:46:02',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2025-11-29 06:46:03',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2025-11-29 06:46:03',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2025-11-29 06:46:05',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-11-29 06:46:06',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-11-29 06:46:06',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2025-11-29 06:46:07',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2025-11-29 06:46:07',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2025-11-29 06:46:07',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2025-11-29 06:46:11',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2025-11-29 06:46:12',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2025-11-29 06:46:14',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2025-11-29 06:46:24',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2025-11-29 06:46:24',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-29 06:46:27',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-29 06:46:58',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-29 06:47:03',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2025-11-29 06:48:48',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2025-11-29 06:49:12',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-29 06:49:26',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-29 06:49:34',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-29 06:49:39',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2025-11-29 06:49:48',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2025-11-29 06:49:50',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-11-29 06:49:51',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-11-29 06:49:55',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2025-11-29 06:49:55',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2025-11-29 06:50:02',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2025-11-29 06:50:03',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2025-11-29 06:50:04',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2025-11-29 06:50:08',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2025-11-29 06:50:10',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2025-11-29 06:50:12',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2025-11-29 06:47:15',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2025-11-29 06:47:43',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2025-11-29 06:48:31',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2025-11-29 06:50:05',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2025-11-29 06:50:05',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2025-11-29 06:50:06',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2025-11-29 06:50:06',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-11-29 06:50:06',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-11-29 06:50:06',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-11-29 06:50:06',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-11-29 06:50:06',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-11-29 06:50:06',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2025-11-29 06:50:06',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2025-11-29 06:50:06',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2025-11-29 06:50:07',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2025-11-29 06:50:09',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2025-11-29 06:50:09',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2025-11-29 06:50:09',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2025-11-29 06:50:10',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2025-11-29 06:50:10',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-11-29 06:50:12',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-11-29 06:50:12',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-11-29 06:50:12',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2025-11-29 06:46:03',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2025-11-29 06:46:03',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2025-11-29 06:46:03',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2025-11-29 06:46:03',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2025-11-29 06:46:03',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2025-11-29 06:46:03',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2025-11-29 06:46:03',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2025-11-29 06:46:03',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-11-29 06:46:03',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2025-11-29 06:46:03',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2025-11-29 06:46:03',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2025-11-29 06:46:03',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2025-11-29 06:46:03',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2025-11-29 06:46:03',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2025-11-29 06:46:03',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2025-11-29 06:46:03',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-11-29 06:46:03',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2025-11-29 06:46:03',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-11-29 06:46:03',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2025-11-29 06:46:03',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2025-11-29 06:46:03',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2025-11-29 06:46:03',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2025-11-29 06:46:04',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2025-11-29 06:46:04',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2025-11-29 06:46:04',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2025-11-29 06:46:04',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2025-11-29 06:46:04',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-11-29 06:46:04',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-11-29 06:46:05',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2025-11-29 06:46:05',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2025-11-29 06:46:05',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-11-29 06:46:05',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2025-11-29 06:46:05',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-11-29 06:46:05',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-11-29 06:46:05',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2025-11-29 06:46:06',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2025-11-29 06:46:06',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2025-11-29 06:46:06',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2025-11-29 06:46:06',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2025-11-29 06:46:06',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-11-29 06:46:06',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-11-29 06:46:06',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2025-11-29 06:46:06',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2025-11-29 06:46:06',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2025-11-29 06:46:06',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2025-11-29 06:46:06',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2025-11-29 06:46:06',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2025-11-29 06:46:06',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2025-11-29 06:46:06',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2025-11-29 06:46:06',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2025-11-29 06:46:06',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2025-11-29 06:46:06',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2025-11-29 06:46:06',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2025-11-29 06:46:06',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2025-11-29 06:46:07',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2025-11-29 06:46:07',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2025-11-29 06:46:07',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2025-11-29 06:46:07',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2025-11-29 06:46:12',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-29 06:46:14',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2025-11-29 06:46:21',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2025-11-29 06:46:23',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2025-11-29 06:46:23',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-11-29 06:46:23',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-11-29 06:46:23',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-11-29 06:46:24',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2025-11-29 06:46:24',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2025-11-29 06:46:24',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2025-11-29 06:46:24',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2025-11-29 06:46:25',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-11-29 06:46:26',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-11-29 06:46:28',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-11-29 06:46:30',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2025-11-29 06:46:30',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2025-11-29 06:46:55',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2025-11-29 06:46:56',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2025-11-29 06:46:57',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2025-11-29 06:46:57',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-29 06:46:57',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2025-11-29 06:46:57',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2025-11-29 06:46:57',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2025-11-29 06:46:57',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-29 06:46:57',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-29 06:46:57',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-11-29 06:46:58',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2025-11-29 06:46:58',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-11-29 06:46:58',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-29 06:46:59',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-29 06:47:00',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-29 06:47:01',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2025-11-29 06:49:07',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2025-11-29 06:49:08',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2025-11-29 06:49:11',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-11-29 06:49:15',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-11-29 06:49:15',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-11-29 06:49:16',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-11-29 06:49:18',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-11-29 06:49:19',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-11-29 06:49:23',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2025-11-29 06:49:31',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2025-11-29 06:49:34',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-29 06:49:35',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2025-11-29 06:49:36',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2025-11-29 06:49:46',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2025-11-29 06:49:46',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2025-11-29 06:49:46',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2025-11-29 06:49:47',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2025-11-29 06:49:48',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-11-29 06:49:48',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2025-11-29 06:49:50',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-11-29 06:49:50',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-11-29 06:49:50',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2025-11-29 06:49:52',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2025-11-29 06:49:55',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2025-11-29 06:49:58',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2025-11-29 06:49:59',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2025-11-29 06:49:59',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2025-11-29 06:49:59',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-11-29 06:50:00',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2025-11-29 06:50:00',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-11-29 06:50:00',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2025-11-29 06:50:01',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2025-11-29 06:50:01',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2025-11-29 06:50:01',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2025-11-29 06:50:02',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2025-11-29 06:50:02',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2025-11-29 06:50:03',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2025-11-29 06:50:03',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-11-29 06:50:04',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-11-29 06:50:04',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2025-11-29 06:50:04',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2025-11-29 06:50:12',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2025-11-29 06:46:02',NULL),(2,'OS::Glance::Image',1,'2025-11-29 06:46:03',NULL),(3,'OS::Nova::Aggregate',1,'2025-11-29 06:46:03',NULL),(4,'OS::Nova::Flavor',1,'2025-11-29 06:46:03',NULL),(5,'OS::Nova::Server',1,'2025-11-29 06:46:03',NULL),(6,'OS::Trove::Instance',1,'2025-11-29 06:50:05',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `external_id` (`external_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','06ac4af37d974605aafdb1bb3607f101','ad029182ad604de9a9f142e9cb3c3eec','315c85eafee64b0ab0629c6f09a31b19',0),('UserProject','06ac4af37d974605aafdb1bb3607f101','ad029182ad604de9a9f142e9cb3c3eec','6eaa1817356c4d57950ef643d32da581',0),('UserProject','1c1a72498230489eaf59bf0fb0c33001','ad029182ad604de9a9f142e9cb3c3eec','1df15c48d4b54ce1be9e293822c19a61',0),('UserProject','1c1a72498230489eaf59bf0fb0c33001','ad029182ad604de9a9f142e9cb3c3eec','6eaa1817356c4d57950ef643d32da581',0),('UserProject','466ed5261fc84e5d86e3a36e86714317','ad029182ad604de9a9f142e9cb3c3eec','315c85eafee64b0ab0629c6f09a31b19',0),('UserProject','466ed5261fc84e5d86e3a36e86714317','ad029182ad604de9a9f142e9cb3c3eec','6eaa1817356c4d57950ef643d32da581',0),('UserProject','4f3f8cf3fc5c4203bde5a3c1aed02357','ad029182ad604de9a9f142e9cb3c3eec','315c85eafee64b0ab0629c6f09a31b19',0),('UserProject','4f3f8cf3fc5c4203bde5a3c1aed02357','ad029182ad604de9a9f142e9cb3c3eec','6eaa1817356c4d57950ef643d32da581',0),('UserProject','5a8f6e09d9d9417f99023c9d150e8a2f','ad029182ad604de9a9f142e9cb3c3eec','315c85eafee64b0ab0629c6f09a31b19',0),('UserProject','5a8f6e09d9d9417f99023c9d150e8a2f','ad029182ad604de9a9f142e9cb3c3eec','6eaa1817356c4d57950ef643d32da581',0),('UserProject','6b15f899f0ec4061b471afa0c1f5c75e','ad029182ad604de9a9f142e9cb3c3eec','315c85eafee64b0ab0629c6f09a31b19',0),('UserProject','6b15f899f0ec4061b471afa0c1f5c75e','ad029182ad604de9a9f142e9cb3c3eec','6eaa1817356c4d57950ef643d32da581',0),('UserProject','6d25dc9c265e4895b997b6192a868554','ad029182ad604de9a9f142e9cb3c3eec','315c85eafee64b0ab0629c6f09a31b19',0),('UserProject','6d25dc9c265e4895b997b6192a868554','ad029182ad604de9a9f142e9cb3c3eec','6eaa1817356c4d57950ef643d32da581',0),('UserProject','7d32840c789849a29c7630e25f803b3c','532b69b8d9eb42e8a1aed36b5ddb038a','304d616ea9a142b288004b6af212b94d',0),('UserProject','7d32840c789849a29c7630e25f803b3c','532b69b8d9eb42e8a1aed36b5ddb038a','6eaa1817356c4d57950ef643d32da581',0),('UserProject','7d32840c789849a29c7630e25f803b3c','d29a1676722c4152a0105ae2c7fc316f','6eaa1817356c4d57950ef643d32da581',0),('UserProject','dfacc734c4c542069d1326226ba1a96f','ad029182ad604de9a9f142e9cb3c3eec','315c85eafee64b0ab0629c6f09a31b19',0),('UserProject','dfacc734c4c542069d1326226ba1a96f','ad029182ad604de9a9f142e9cb3c3eec','6eaa1817356c4d57950ef643d32da581',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('004028ba022141b9956cd00e3a1d2d58',NULL,'internal','142b815848f940c8bddfa89b5928819f','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('0fd82387e49b4ea3b61de7add1d70abd',NULL,'internal','5c159f213d69451cbf0b88cfd9a470c9','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('37d7f606e80143d795986e6ca2b5b46c',NULL,'public','f9923dcb9cf046f4810f51f9b0ac2a3a','https://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('42cdeabcb19642ea98d81baaa285003c',NULL,'public','1a938885dcea415ea01ea9b485229574','https://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('445beb72da734732b053a18ac5235367',NULL,'public','142b815848f940c8bddfa89b5928819f','https://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('5129d59d179449b3942365c5b11716d1',NULL,'internal','38016b6f00e94be781f164229ba7f4d7','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('5d61715a9ad4485881e5acfad78938e1',NULL,'internal','f9923dcb9cf046f4810f51f9b0ac2a3a','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('7e385cc63d104c239353698bd4345970',NULL,'internal','1a938885dcea415ea01ea9b485229574','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('839ad8a9daaf4b4e92a02c498d80ed90',NULL,'internal','f805e270a0b84a79869728af322f8ede','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('8c99a81ca653495e99a5afadfbbdc7c3',NULL,'public','1b1b6c9d72af4a4eaf4b139e5c16e78f','https://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('8d76baefa7c04e6d9bc936c239f5a38a',NULL,'public','5c159f213d69451cbf0b88cfd9a470c9','https://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('9015e29be9564ba696b6f383980fbd7e',NULL,'internal','ffdb89b3c79a4235a77a1d123b0671e8','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('954dabc945394ac182fd104478881474',NULL,'public','ffdb89b3c79a4235a77a1d123b0671e8','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('9f02073a3d4f4b37a0712addf8f806ec',NULL,'internal','1b1b6c9d72af4a4eaf4b139e5c16e78f','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('de699ac5de1f4d348f70721a12005868',NULL,'public','38016b6f00e94be781f164229ba7f4d7','https://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('f3c6df795dfa42189b47c0b0c2fdb1cd',NULL,'public','f805e270a0b84a79869728af322f8ede','https://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('1df15c48d4b54ce1be9e293822c19a61','a83af16119404dbc80e7a6285ecb859e'),('6eaa1817356c4d57950ef643d32da581','1df15c48d4b54ce1be9e293822c19a61');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'7d32840c789849a29c7630e25f803b3c','default','admin',0,NULL),(2,'4f3f8cf3fc5c4203bde5a3c1aed02357','default','barbican',0,NULL),(3,'6b15f899f0ec4061b471afa0c1f5c75e','default','glance',0,NULL),(4,'466ed5261fc84e5d86e3a36e86714317','default','nova',0,NULL),(5,'06ac4af37d974605aafdb1bb3607f101','default','ceilometer',0,NULL),(6,'dfacc734c4c542069d1326226ba1a96f','default','cinder',0,NULL),(7,'6d25dc9c265e4895b997b6192a868554','default','placement',0,NULL),(8,'5a8f6e09d9d9417f99023c9d150e8a2f','default','neutron',0,NULL),(9,'1c1a72498230489eaf59bf0fb0c33001','default','swift',0,NULL),(10,'e2e8955079d24b0f935b0f2334bc1aa9','default','demo_tempestconf',0,NULL),(11,'45fff6073ec04a3a803020c8c4aabd57','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$G7ejUicJnI7.XslQes8ua.Q/M75z./O2sRnmxwvC6KRFhLejPf/.i',1764398781903285,NULL,'2025-11-29 06:46:21'),(2,2,NULL,0,'$2b$12$dz/7vqAjKGRxm2SDSpxrUe5BqE.SFZCfqkMV34qhHnErXNzL.VFw6',1764398951350213,NULL,'2025-11-29 06:49:11'),(3,3,NULL,0,'$2b$12$L6FqYzLeM6iOnSpQcrWxy.s5xTB2nkCI37hQNANqOtrnzU4AuZoCW',1764398968421577,NULL,'2025-11-29 06:49:28'),(4,4,NULL,0,'$2b$12$6wCpPDGWlD7STbn/DYh0JeaFvg/puuoFP/zl9uFVV3tZuul9JacU6',1764398987220467,NULL,'2025-11-29 06:49:47'),(5,5,NULL,0,'$2b$12$Kg.EIJyZu4yzPoLl6XZ0E.Fg7lxEMGaKV26rFuMVBr3WI2T9FGqPK',1764398993848185,NULL,'2025-11-29 06:49:53'),(6,6,NULL,0,'$2b$12$f31T.d213yUP7LM4oranWe9t0c0nH86xJ8LSe.qvAJ.4RnR.aeuq6',1764399051409726,NULL,'2025-11-29 06:50:51'),(7,7,NULL,0,'$2b$12$V.rEW3fKvEvkiF87gceYduOVq2bFez59lYEcDDxztCXHxTB3o2qcW',1764399065017615,NULL,'2025-11-29 06:51:05'),(8,8,NULL,0,'$2b$12$J2scNxJcRewTcGWihjUtiuQ1sd9wIKICHP1T2iaXNrWJCuIDnVX4.',1764399240619829,NULL,'2025-11-29 06:54:00'),(9,9,NULL,0,'$2b$12$MlBInLGtZH8dFgr2hO48J.8Y4pxKnH3hx6/WbgHkOhrUuQGiVd8ga',1764400355067645,NULL,'2025-11-29 07:12:35'),(10,10,NULL,0,'$2b$12$B3HjPKlGmlrwys579gX9IOvu/ONPPQznTAbZlVrJOYP0fbDf6YIc.',1764401987738635,NULL,'2025-11-29 07:39:47'),(11,11,NULL,0,'$2b$12$CtKURych7u4tfB59lHgxy.A6ZkYDRvQJrZ8ANvrNtH7e5Jtiqp50q',1764401988716266,NULL,'2025-11-29 07:39:48');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('532b69b8d9eb42e8a1aed36b5ddb038a','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0),('6a519c638af44a9299a942b31ee65243','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('ad029182ad604de9a9f142e9cb3c3eec','service','{}','service',1,'default','default',0),('d29a1676722c4152a0105ae2c7fc316f','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=482 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (108,NULL,'b7fbc00e5fcb46b093ca806c2f1d1030',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:46:28',NULL,'2025-11-29 07:46:28',NULL,NULL),(109,NULL,NULL,'f7ba0de30774463e96da46895bca0fbd',NULL,NULL,NULL,NULL,'2025-11-29 07:46:30',NULL,'2025-11-29 07:46:30',NULL,NULL),(110,NULL,NULL,'fb1fb9734ffd408388c51f394ce30335',NULL,NULL,NULL,NULL,'2025-11-29 07:46:30',NULL,'2025-11-29 07:46:30',NULL,NULL),(111,NULL,'e8a3eccf5aa843f1895ce41cfeb8b4b5',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:46:32',NULL,'2025-11-29 07:46:32',NULL,NULL),(112,NULL,NULL,'89a964d112984037a61a12ddb96a2c17',NULL,NULL,NULL,NULL,'2025-11-29 07:46:33',NULL,'2025-11-29 07:46:33',NULL,NULL),(113,NULL,NULL,'335d1ebfd2a84ad599872bbe310ea7f6',NULL,NULL,NULL,NULL,'2025-11-29 07:46:33',NULL,'2025-11-29 07:46:33',NULL,NULL),(114,NULL,'f94c8ad4fba643a7a7d78c24024d4410',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:46:33',NULL,'2025-11-29 07:46:33',NULL,NULL),(115,NULL,'d998409b306b4ebfa3f66d5881d5c6bd',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:46:35',NULL,'2025-11-29 07:46:35',NULL,NULL),(116,NULL,'139d78fc8e8e4028934b003f0e2ce052',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:46:35',NULL,'2025-11-29 07:46:35',NULL,NULL),(117,NULL,NULL,'04e2d382e0354cc3b11cbb9e90ff9bbc',NULL,NULL,NULL,NULL,'2025-11-29 07:46:38',NULL,'2025-11-29 07:46:38',NULL,NULL),(118,NULL,NULL,'4968eb82100c4ef68fea6d6f3f4ce201',NULL,NULL,NULL,NULL,'2025-11-29 07:46:38',NULL,'2025-11-29 07:46:38',NULL,NULL),(119,NULL,'fdb821dbff1d4d80b984224ca87a68a6',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:46:39',NULL,'2025-11-29 07:46:39',NULL,NULL),(120,NULL,NULL,'299e9903f57e4a7da3286e4f99219c86',NULL,NULL,NULL,NULL,'2025-11-29 07:46:40',NULL,'2025-11-29 07:46:40',NULL,NULL),(121,NULL,NULL,'4b815c0f7fa848b98b3585fa8258924f',NULL,NULL,NULL,NULL,'2025-11-29 07:46:40',NULL,'2025-11-29 07:46:40',NULL,NULL),(122,NULL,'049c90f2a49f464a934f3064c2a04136',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:46:44',NULL,'2025-11-29 07:46:44',NULL,NULL),(123,NULL,'87ecdaa0fc2f4ce589caffe69c08605c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:46:44',NULL,'2025-11-29 07:46:44',NULL,NULL),(124,NULL,'7d71340d92d640f9a81d0d31148fb049',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:46:45',NULL,'2025-11-29 07:46:45',NULL,NULL),(125,NULL,'ba5507740f1343449b18223af46d7fe4',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:46:48',NULL,'2025-11-29 07:46:48',NULL,NULL),(126,NULL,NULL,'755d4f6fabf946e3bfc54daaee5c6f8c',NULL,NULL,NULL,NULL,'2025-11-29 07:46:50',NULL,'2025-11-29 07:46:50',NULL,NULL),(127,NULL,NULL,'62aa681e7e2d419294280e9128b72adc',NULL,NULL,NULL,NULL,'2025-11-29 07:46:50',NULL,'2025-11-29 07:46:50',NULL,NULL),(128,NULL,'e36d3a8d778747a583d83073589cc841',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:46:51',NULL,'2025-11-29 07:46:51',NULL,NULL),(129,NULL,NULL,'148014cfff1f4924858c5733521f4c7d',NULL,NULL,NULL,NULL,'2025-11-29 07:46:51',NULL,'2025-11-29 07:46:51',NULL,NULL),(130,NULL,NULL,'1c413d78221e4f70977029476f627a1b',NULL,NULL,NULL,NULL,'2025-11-29 07:46:54',NULL,'2025-11-29 07:46:54',NULL,NULL),(131,NULL,NULL,'7ee770942ecc49eebde6ede14ad6dbd9',NULL,NULL,NULL,NULL,'2025-11-29 07:46:54',NULL,'2025-11-29 07:46:54',NULL,NULL),(132,NULL,'f673d9c8592d40788e8b10026f1f1331',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:46:54',NULL,'2025-11-29 07:46:54',NULL,NULL),(133,NULL,'642cbb3cd3e74f8b8d3252e655c05519',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:46:58',NULL,'2025-11-29 07:46:58',NULL,NULL),(134,NULL,'46b5c4e02ce54c8dba0ab5ef2005e98e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:46:58',NULL,'2025-11-29 07:46:58',NULL,NULL),(135,NULL,'aa835171a16c4e7fb7401bd9515673de',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:47:01',NULL,'2025-11-29 07:47:01',NULL,NULL),(136,NULL,NULL,'42ac330b69d043c192686158560f514f',NULL,NULL,NULL,NULL,'2025-11-29 07:47:13',NULL,'2025-11-29 07:47:13',NULL,NULL),(137,NULL,NULL,'f896440b37e24db1a09d9d5717e2e402',NULL,NULL,NULL,NULL,'2025-11-29 07:47:14',NULL,'2025-11-29 07:47:14',NULL,NULL),(138,NULL,'ad68ea3da35a4f2d9f8ee36003b7afe2',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:47:17',NULL,'2025-11-29 07:47:17',NULL,NULL),(139,NULL,'c78d8de56f014180b68af9376c313176',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:47:18',NULL,'2025-11-29 07:47:18',NULL,NULL),(140,NULL,NULL,'a40c3321c50c4854a402a01fc8d364fb',NULL,NULL,NULL,NULL,'2025-11-29 07:47:50',NULL,'2025-11-29 07:47:50',NULL,NULL),(141,NULL,NULL,'07f15449c8bd4f0283216ce726f1ef1b',NULL,NULL,NULL,NULL,'2025-11-29 07:47:50',NULL,'2025-11-29 07:47:50',NULL,NULL),(142,NULL,'96c6081f38b447948bab3c4e2e2c08b8',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:47:53',NULL,'2025-11-29 07:47:53',NULL,NULL),(143,NULL,'5a9b7f6ed83e472387636ac0e55e5c3e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:47:54',NULL,'2025-11-29 07:47:54',NULL,NULL),(144,NULL,NULL,'d94c707cca604d72a8e1d49b636095e1',NULL,NULL,NULL,NULL,'2025-11-29 07:48:02',NULL,'2025-11-29 07:48:02',NULL,NULL),(145,NULL,NULL,'3821a242c26441f5a13b1ada4483d82b',NULL,NULL,NULL,NULL,'2025-11-29 07:48:02',NULL,'2025-11-29 07:48:02',NULL,NULL),(146,NULL,'96ea84545e71401fb69d21be6e2472f7',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:48:03',NULL,'2025-11-29 07:48:03',NULL,NULL),(147,NULL,'da1d3cc07aab49df911e7ff398f00e54',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:48:04',NULL,'2025-11-29 07:48:04',NULL,NULL),(148,NULL,NULL,'74c40de57bbb4eaa8d7b3ee08bbd67ec',NULL,NULL,NULL,NULL,'2025-11-29 07:48:08',NULL,'2025-11-29 07:48:08',NULL,NULL),(149,NULL,NULL,'5027d1d3068c4319af684dec72816fea',NULL,NULL,NULL,NULL,'2025-11-29 07:48:08',NULL,'2025-11-29 07:48:08',NULL,NULL),(150,NULL,'ce32669b0939458aa09dcee1ca10bcf5',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:48:12',NULL,'2025-11-29 07:48:12',NULL,NULL),(151,NULL,'5114ce601e6e441bab2bbdbabf6bcd11',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:48:15',NULL,'2025-11-29 07:48:15',NULL,NULL),(152,NULL,NULL,'386584ea971049e3b0c06b8237710848',NULL,NULL,NULL,NULL,'2025-11-29 07:49:32',NULL,'2025-11-29 07:49:32',NULL,NULL),(153,NULL,NULL,'cf487d7b58174cc9a2af2833650814b0',NULL,NULL,NULL,NULL,'2025-11-29 07:49:32',NULL,'2025-11-29 07:49:32',NULL,NULL),(154,NULL,'b9b7c14abe3b42c18ef058e25b1733bf',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:49:34',NULL,'2025-11-29 07:49:34',NULL,NULL),(155,NULL,'c80f8d4661784e8faaf78d28df3fb677',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:49:35',NULL,'2025-11-29 07:49:35',NULL,NULL),(156,NULL,NULL,'d15fa4897cba4410b8d341f62586c091',NULL,NULL,NULL,NULL,'2025-11-29 07:49:46',NULL,'2025-11-29 07:49:46',NULL,NULL),(157,NULL,NULL,'59581c6281ec4338a6e50f15daba8f83',NULL,NULL,NULL,NULL,'2025-11-29 07:49:46',NULL,'2025-11-29 07:49:46',NULL,NULL),(158,NULL,'f3f16345721743ccb9afb374deec67b5',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:49:48',NULL,'2025-11-29 07:49:48',NULL,NULL),(159,NULL,'0ef7361aeeb6486f81bc1b66cbf76166',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:49:48',NULL,'2025-11-29 07:49:48',NULL,NULL),(160,NULL,NULL,'e1c26cd8138e4114b4801d377b39933a',NULL,NULL,NULL,NULL,'2025-11-29 07:51:07',NULL,'2025-11-29 07:51:07',NULL,NULL),(161,NULL,NULL,'3a74818e754b4b7393e65e132a8bcf98',NULL,NULL,NULL,NULL,'2025-11-29 07:51:07',NULL,'2025-11-29 07:51:07',NULL,NULL),(162,NULL,'6326848a05cb4a28bef4b0c4d3b5726c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:51:12',NULL,'2025-11-29 07:51:12',NULL,NULL),(163,NULL,'f7e8ae9fdefb4049959228954fb4250e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:51:19',NULL,'2025-11-29 07:51:19',NULL,NULL),(164,NULL,NULL,'93506ec26b16451c91dc820b139e8707',NULL,NULL,NULL,NULL,'2025-11-29 07:51:39',NULL,'2025-11-29 07:51:39',NULL,NULL),(165,NULL,NULL,'be6f25cb57044e8a85f942176f8f668c',NULL,NULL,NULL,NULL,'2025-11-29 07:51:40',NULL,'2025-11-29 07:51:40',NULL,NULL),(166,NULL,'b2c58ae2e706424fa3147694fc571db0',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:51:42',NULL,'2025-11-29 07:51:42',NULL,NULL),(167,NULL,'f18e115c9bd847fe8235871cf715fdde',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:51:44',NULL,'2025-11-29 07:51:44',NULL,NULL),(168,NULL,NULL,'ed57e094b4c4441c8ffbfb96ecb62afc',NULL,NULL,NULL,NULL,'2025-11-29 07:51:49',NULL,'2025-11-29 07:51:49',NULL,NULL),(169,NULL,NULL,'e7f285d2d2554e7d9845ab13aecc53db',NULL,NULL,NULL,NULL,'2025-11-29 07:51:49',NULL,'2025-11-29 07:51:49',NULL,NULL),(170,NULL,'cf226b9a5bb945c3a8f54976b5736fe3',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:51:50',NULL,'2025-11-29 07:51:50',NULL,NULL),(171,NULL,'ef548e12a785446885c4b410d36a85c2',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:51:52',NULL,'2025-11-29 07:51:52',NULL,NULL),(172,NULL,NULL,'e325d4df8788423e83d0a5eced9320b8',NULL,NULL,NULL,NULL,'2025-11-29 07:52:03',NULL,'2025-11-29 07:52:03',NULL,NULL),(173,NULL,NULL,'5a9f0b2f06c5457ba3511225841e7258',NULL,NULL,NULL,NULL,'2025-11-29 07:52:03',NULL,'2025-11-29 07:52:03',NULL,NULL),(174,NULL,NULL,'21f304a1765f4908abfe7fb15189ee95',NULL,NULL,NULL,NULL,'2025-11-29 07:52:03',NULL,'2025-11-29 07:52:03',NULL,NULL),(175,NULL,'09c8bf43bac34db898b10f4f7144517d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:08',NULL,'2025-11-29 07:52:08',NULL,NULL),(176,NULL,'0766d13dbd694c6fa58cd3c7073153c8',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:15',NULL,'2025-11-29 07:52:15',NULL,NULL),(177,NULL,'61c43a276b0446a187c8aaf55b42ff96',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:52:24',NULL,'2025-11-29 07:52:24',NULL,NULL),(178,NULL,NULL,'37531d9f927d40ecadd246429b5b598d',NULL,NULL,NULL,NULL,'2025-11-29 07:53:19',NULL,'2025-11-29 07:53:19',NULL,NULL),(179,NULL,NULL,'749bb74010574cbb8b7b62a42729cb71',NULL,NULL,NULL,NULL,'2025-11-29 07:53:20',NULL,'2025-11-29 07:53:20',NULL,NULL),(180,NULL,'73f3d0f2c9aa4ba29984fc9e6a7ed869',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:53:21',NULL,'2025-11-29 07:53:21',NULL,NULL),(181,NULL,'784d8fc21d3f412f83d45f20b61ecd85',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:53:22',NULL,'2025-11-29 07:53:22',NULL,NULL),(182,NULL,NULL,'ca7da72f49a74a5b9e3fff8d172e592b',NULL,NULL,NULL,NULL,'2025-11-29 07:53:32',NULL,'2025-11-29 07:53:32',NULL,NULL),(183,NULL,NULL,'a6836a8e726f4bed8101c3fc3809d4ee',NULL,NULL,NULL,NULL,'2025-11-29 07:53:32',NULL,'2025-11-29 07:53:32',NULL,NULL),(184,NULL,'e64bdd40561d41ce91b39f78d29c3144',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:53:35',NULL,'2025-11-29 07:53:35',NULL,NULL),(185,NULL,'3d210fcdedbb4d709720bcce6eaf61e1',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:53:37',NULL,'2025-11-29 07:53:37',NULL,NULL),(186,NULL,NULL,'2e6a7e8a80384d83b5debf4c717f6e09',NULL,NULL,NULL,NULL,'2025-11-29 07:53:39',NULL,'2025-11-29 07:53:39',NULL,NULL),(187,NULL,'b1a31b637613411eaeda132dc499537b',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:53:40',NULL,'2025-11-29 07:53:40',NULL,NULL),(188,NULL,NULL,'b355cf81b0d746eab57b53c73fc040ba',NULL,NULL,NULL,NULL,'2025-11-29 07:53:41',NULL,'2025-11-29 07:53:41',NULL,NULL),(189,NULL,NULL,'79f3c5cd0ac34a90b8eaff4a9b8a2292',NULL,NULL,NULL,NULL,'2025-11-29 07:53:41',NULL,'2025-11-29 07:53:41',NULL,NULL),(190,NULL,'9b23e64c09cf47e496bc497c6cafde90',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:53:42',NULL,'2025-11-29 07:53:42',NULL,NULL),(191,NULL,NULL,'1c275b92dc9e4f9b8f617559211e956c',NULL,NULL,NULL,NULL,'2025-11-29 07:53:44',NULL,'2025-11-29 07:53:44',NULL,NULL),(192,NULL,'78b572ada61044a1a03356be8b1902fc',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:53:44',NULL,'2025-11-29 07:53:44',NULL,NULL),(193,NULL,'30d751b699e647bdb8318d5f0eaea857',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:53:46',NULL,'2025-11-29 07:53:46',NULL,NULL),(194,NULL,NULL,'ae8b18bbbe3e486ba777773ff737d418',NULL,NULL,NULL,NULL,'2025-11-29 07:53:49',NULL,'2025-11-29 07:53:49',NULL,NULL),(195,NULL,NULL,'1d4b9abb42474d05a16d6662d023ad88',NULL,NULL,NULL,NULL,'2025-11-29 07:53:49',NULL,'2025-11-29 07:53:49',NULL,NULL),(196,NULL,'ee59dd420d194368ad8fc35680178acd',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:53:51',NULL,'2025-11-29 07:53:51',NULL,NULL),(197,NULL,'483e4fb53a0f49a49916357fe228cdf8',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:53:52',NULL,'2025-11-29 07:53:52',NULL,NULL),(198,NULL,NULL,'6ca0284fe9484539925c684d27654f2f',NULL,NULL,NULL,NULL,'2025-11-29 07:53:57',NULL,'2025-11-29 07:53:57',NULL,NULL),(199,NULL,NULL,'aa1abd2a0b5e43b7b0076f858185b1e3',NULL,NULL,NULL,NULL,'2025-11-29 07:53:57',NULL,'2025-11-29 07:53:57',NULL,NULL),(200,NULL,'57675be7cc0a40a3ac5ae6b05aa344c7',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:53:59',NULL,'2025-11-29 07:53:59',NULL,NULL),(201,NULL,'cb511b88d472452f9749846769c119a1',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:54:00',NULL,'2025-11-29 07:54:00',NULL,NULL),(202,NULL,NULL,'9c227e338c3946f89cd212a1ffd1a709',NULL,NULL,NULL,NULL,'2025-11-29 07:54:05',NULL,'2025-11-29 07:54:05',NULL,NULL),(203,NULL,NULL,'405cb20247fe4b30b81b97fc2a1ea4bd',NULL,NULL,NULL,NULL,'2025-11-29 07:54:05',NULL,'2025-11-29 07:54:05',NULL,NULL),(204,NULL,'b35d533377ee4dc0b875c30c18692d44',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:54:07',NULL,'2025-11-29 07:54:07',NULL,NULL),(205,NULL,'9a6d14945e5c4e6cb4b4d2147b035508',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:54:08',NULL,'2025-11-29 07:54:08',NULL,NULL),(206,NULL,NULL,'ccb178c36233445b8c3d4fe2f1dea893',NULL,NULL,NULL,NULL,'2025-11-29 07:54:13',NULL,'2025-11-29 07:54:13',NULL,NULL),(207,NULL,'5707636a9a62443995a62b74bd4c5ac3',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:54:14',NULL,'2025-11-29 07:54:14',NULL,NULL),(208,NULL,NULL,'fb2f5c544b094a3c919d4525ce2f63ff',NULL,NULL,NULL,NULL,'2025-11-29 07:54:14',NULL,'2025-11-29 07:54:14',NULL,NULL),(209,NULL,NULL,'47ba89d5a5184cf38969a1308caeab14',NULL,NULL,NULL,NULL,'2025-11-29 07:54:14',NULL,'2025-11-29 07:54:14',NULL,NULL),(210,NULL,'5584cf7f2a28455fab0bcae966765300',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:54:17',NULL,'2025-11-29 07:54:17',NULL,NULL),(211,NULL,'d5937a36498d4065a8afdb3245e07009',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:54:18',NULL,'2025-11-29 07:54:18',NULL,NULL),(212,NULL,NULL,'de20b92d6d454f56934aa5c423732d73',NULL,NULL,NULL,NULL,'2025-11-29 07:54:22',NULL,'2025-11-29 07:54:22',NULL,NULL),(213,NULL,NULL,'38c7e917dbc04909af9c9f598b318dc3',NULL,NULL,NULL,NULL,'2025-11-29 07:54:22',NULL,'2025-11-29 07:54:22',NULL,NULL),(214,NULL,'88b0d489f03949e0b3bd1c333224d8bf',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:54:24',NULL,'2025-11-29 07:54:24',NULL,NULL),(215,NULL,'595c8e5a922440a8be23a5e9a6586264',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:54:25',NULL,'2025-11-29 07:54:25',NULL,NULL),(216,NULL,NULL,'8551065d65214410b616d2a71729df0a',NULL,NULL,NULL,NULL,'2025-11-29 07:54:40',NULL,'2025-11-29 07:54:40',NULL,NULL),(217,NULL,NULL,'6441359add4f4a57a5b227cbb34d8df8',NULL,NULL,NULL,NULL,'2025-11-29 07:54:40',NULL,'2025-11-29 07:54:40',NULL,NULL),(218,NULL,'a679eb2cadea488f9de8f5cc398bb6b5',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:54:46',NULL,'2025-11-29 07:54:46',NULL,NULL),(219,NULL,'800c0f050e95457384eee582d6da0afa',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:54:47',NULL,'2025-11-29 07:54:47',NULL,NULL),(220,NULL,NULL,'5b13aa58723747fb9b6bfab86b1ca7b3',NULL,NULL,NULL,NULL,'2025-11-29 07:54:55',NULL,'2025-11-29 07:54:55',NULL,NULL),(221,NULL,NULL,'f1da0100f8a8443db50d11c43095d7fb',NULL,NULL,NULL,NULL,'2025-11-29 07:54:55',NULL,'2025-11-29 07:54:55',NULL,NULL),(222,NULL,'5a7e86b620184ca0ad3cba352d5bc554',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:54:59',NULL,'2025-11-29 07:54:59',NULL,NULL),(223,NULL,'08368fe371b944caa7d0d51bb539528a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:55:00',NULL,'2025-11-29 07:55:00',NULL,NULL),(224,NULL,NULL,'567d07876fc64fdf8a3825ba661735c5',NULL,NULL,NULL,NULL,'2025-11-29 07:55:05',NULL,'2025-11-29 07:55:05',NULL,NULL),(225,NULL,'355df1412457489ba86a191b04822a35',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:55:07',NULL,'2025-11-29 07:55:07',NULL,NULL),(226,NULL,NULL,'3905209925cd414980eac7c79bf04af2',NULL,NULL,NULL,NULL,'2025-11-29 07:55:16',NULL,'2025-11-29 07:55:16',NULL,NULL),(227,NULL,'e6ba183d92db4c6795dd0f44dc77fad4',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:55:17',NULL,'2025-11-29 07:55:17',NULL,NULL),(228,NULL,NULL,'db06e8f865ef4c7fbacd588b0c473e37',NULL,NULL,NULL,NULL,'2025-11-29 07:55:50',NULL,'2025-11-29 07:55:50',NULL,NULL),(229,NULL,NULL,'dbf4589425d2433e8f05169c124fc996',NULL,NULL,NULL,NULL,'2025-11-29 07:55:50',NULL,'2025-11-29 07:55:50',NULL,NULL),(230,NULL,'ad7fad31d5864eb0887205db329f479a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:55:52',NULL,'2025-11-29 07:55:52',NULL,NULL),(231,NULL,'4a3681cf294441768c28547476705844',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:55:53',NULL,'2025-11-29 07:55:53',NULL,NULL),(232,NULL,NULL,'45437f208c5a4499acac789fee214724',NULL,NULL,NULL,NULL,'2025-11-29 07:56:04',NULL,'2025-11-29 07:56:04',NULL,NULL),(233,NULL,NULL,'c91e0e9cf485495da3c349e29172db0e',NULL,NULL,NULL,NULL,'2025-11-29 07:56:04',NULL,'2025-11-29 07:56:04',NULL,NULL),(234,NULL,'666052d32183417982e59c456a19c744',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:06',NULL,'2025-11-29 07:56:06',NULL,NULL),(235,NULL,'badfd9b8c0284ad9ba375f3f5932ae19',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:07',NULL,'2025-11-29 07:56:07',NULL,NULL),(236,NULL,NULL,'a4e682513e5545e7a59326b445f4b33c',NULL,NULL,NULL,NULL,'2025-11-29 07:56:11',NULL,'2025-11-29 07:56:11',NULL,NULL),(237,NULL,'782161157de7456fb73c213f1cba5c87',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:12',NULL,'2025-11-29 07:56:12',NULL,NULL),(238,NULL,NULL,'61f29c385ebd477cb1758c565c344fc8',NULL,NULL,NULL,NULL,'2025-11-29 07:56:15',NULL,'2025-11-29 07:56:15',NULL,NULL),(239,NULL,NULL,'5a0d6c36b8b141f6b1b280db4b45afc6',NULL,NULL,NULL,NULL,'2025-11-29 07:56:15',NULL,'2025-11-29 07:56:15',NULL,NULL),(240,NULL,NULL,'8f4bf9b09ffd4b6ebd538fb75ec8125b',NULL,NULL,NULL,NULL,'2025-11-29 07:56:16',NULL,'2025-11-29 07:56:16',NULL,NULL),(241,NULL,'f19eb4884f9c48bf804e00b1e85b70b3',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:16',NULL,'2025-11-29 07:56:16',NULL,NULL),(242,NULL,'e666e8b3cc744c97a39b55c135d7769f',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:17',NULL,'2025-11-29 07:56:17',NULL,NULL),(243,NULL,'67b2fe62f61f4ef285ddd60f82efd255',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:18',NULL,'2025-11-29 07:56:18',NULL,NULL),(244,NULL,NULL,'ede3152718b4460a8d7560e1fb61b7d8',NULL,NULL,NULL,NULL,'2025-11-29 07:56:22',NULL,'2025-11-29 07:56:22',NULL,NULL),(245,NULL,NULL,'0dc9b5775bf54d49b4bcbe8dac5065f5',NULL,NULL,NULL,NULL,'2025-11-29 07:56:22',NULL,'2025-11-29 07:56:22',NULL,NULL),(246,NULL,'bb22c556a45c4206ae9d737b4718d824',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:23',NULL,'2025-11-29 07:56:23',NULL,NULL),(247,NULL,'4f69e42e121540899aecfcdd8f927aa1',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:25',NULL,'2025-11-29 07:56:25',NULL,NULL),(248,NULL,NULL,'fc9ffe5168f64edd9b1e394026274825',NULL,NULL,NULL,NULL,'2025-11-29 07:56:29',NULL,'2025-11-29 07:56:29',NULL,NULL),(249,NULL,'335ff05074ba40f186e1461bc36f956f',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:31',NULL,'2025-11-29 07:56:31',NULL,NULL),(250,NULL,NULL,'b2176b32c3ee4e8fb0a6fa804f37c849',NULL,NULL,NULL,NULL,'2025-11-29 07:56:47',NULL,'2025-11-29 07:56:47',NULL,NULL),(251,NULL,'bbde6bd5a35f4b9ea2c82fe2a2ad72fe',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:48',NULL,'2025-11-29 07:56:48',NULL,NULL),(252,NULL,NULL,'bdef444fcfc4443db120e931491300f6',NULL,NULL,NULL,NULL,'2025-11-29 07:56:48',NULL,'2025-11-29 07:56:48',NULL,NULL),(253,NULL,'4c00b08d99d1447886fb40c85a9aea33',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:49',NULL,'2025-11-29 07:56:49',NULL,NULL),(254,NULL,NULL,'7655a67c0ccc4f2fa2e5518131c7910e',NULL,NULL,NULL,NULL,'2025-11-29 07:56:57',NULL,'2025-11-29 07:56:57',NULL,NULL),(255,NULL,'88010caaa38b45d3b7578dad75d84668',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:56:58',NULL,'2025-11-29 07:56:58',NULL,NULL),(256,NULL,NULL,'c2622c8c301b4717b2e8be5fd3b2ec9d',NULL,NULL,NULL,NULL,'2025-11-29 07:57:04',NULL,'2025-11-29 07:57:04',NULL,NULL),(257,NULL,'5f51a26dde554e0db6d3684424061d45',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:05',NULL,'2025-11-29 07:57:05',NULL,NULL),(258,NULL,NULL,'abdbe07b3419439fa940f75e650b3688',NULL,NULL,NULL,NULL,'2025-11-29 07:57:14',NULL,'2025-11-29 07:57:14',NULL,NULL),(259,NULL,NULL,'afbf7b04b29b4ac48ac23bfe12e6703f',NULL,NULL,NULL,NULL,'2025-11-29 07:57:14',NULL,'2025-11-29 07:57:14',NULL,NULL),(260,NULL,NULL,'dbeeaca97c3e4a1b9417ab3e996f721f',NULL,NULL,NULL,NULL,'2025-11-29 07:57:15',NULL,'2025-11-29 07:57:15',NULL,NULL),(261,NULL,'5791f892134c4684ba07d02f26ec275e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:15',NULL,'2025-11-29 07:57:15',NULL,NULL),(262,NULL,'3b4124e85e7b43c8be676b077864835f',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:15',NULL,'2025-11-29 07:57:15',NULL,NULL),(263,NULL,'219d722e6a2c4164be5a30e9565f13a0',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:16',NULL,'2025-11-29 07:57:16',NULL,NULL),(264,NULL,NULL,'3975ec4c767c41beb533243c472639d1',NULL,NULL,NULL,NULL,'2025-11-29 07:57:20',NULL,'2025-11-29 07:57:20',NULL,NULL),(265,NULL,'475211a7378a4a0aba077d55d3eb944f',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:21',NULL,'2025-11-29 07:57:21',NULL,NULL),(266,NULL,NULL,'e039265bacb1469fac128c1a282c629b',NULL,NULL,NULL,NULL,'2025-11-29 07:57:25',NULL,'2025-11-29 07:57:25',NULL,NULL),(267,NULL,'28101dec33be4fd0bb0e652cf9cd0eb2',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:27',NULL,'2025-11-29 07:57:27',NULL,NULL),(268,NULL,NULL,'da4f20ea8f8b4f6b880d787ae830922b',NULL,NULL,NULL,NULL,'2025-11-29 07:57:31',NULL,'2025-11-29 07:57:31',NULL,NULL),(269,NULL,'7d836f7df98b4261ae49c5b2e9df2398',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:32',NULL,'2025-11-29 07:57:32',NULL,NULL),(270,NULL,NULL,'19a223d694624a819e0841cbde8bcf3a',NULL,NULL,NULL,NULL,'2025-11-29 07:57:32',NULL,'2025-11-29 07:57:32',NULL,NULL),(271,NULL,'de2e3b9f975644ebba71a612c7e53731',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:57:33',NULL,'2025-11-29 07:57:33',NULL,NULL),(272,NULL,NULL,'e36c67c0cb7047838685aecc7c5fc1f1',NULL,NULL,NULL,NULL,'2025-11-29 07:58:13',NULL,'2025-11-29 07:58:13',NULL,NULL),(273,NULL,'2503a0f23e9e4708a8bd3b0f504695cc',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:58:14',NULL,'2025-11-29 07:58:14',NULL,NULL),(274,NULL,NULL,'00183201554f47b3aa46da246e60580d',NULL,NULL,NULL,NULL,'2025-11-29 07:58:45',NULL,'2025-11-29 07:58:45',NULL,NULL),(275,NULL,'cf14587bd83441a8a75c2ec83dd6a271',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:58:46',NULL,'2025-11-29 07:58:46',NULL,NULL),(276,NULL,NULL,'16731bc26a7441b98efa928e8b8a2f2c',NULL,NULL,NULL,NULL,'2025-11-29 07:58:50',NULL,'2025-11-29 07:58:50',NULL,NULL),(277,NULL,'54814b767b3d40fcbbf6cb6e7763262d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:58:52',NULL,'2025-11-29 07:58:52',NULL,NULL),(278,NULL,NULL,'c2aeea466c9049d3a023483ec2e5b4f6',NULL,NULL,NULL,NULL,'2025-11-29 07:59:28',NULL,'2025-11-29 07:59:28',NULL,NULL),(279,NULL,'30d42ce85b6840c6942b24cf4a7b9d64',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:59:29',NULL,'2025-11-29 07:59:29',NULL,NULL),(280,NULL,NULL,'36102f449c474846b05450b0ed2f31d5',NULL,NULL,NULL,NULL,'2025-11-29 07:59:32',NULL,'2025-11-29 07:59:32',NULL,NULL),(281,NULL,'9cac1541e8e549a5919d6560d18d3d18',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:59:35',NULL,'2025-11-29 07:59:35',NULL,NULL),(282,NULL,NULL,'d13a635062c8448da51d78f6ece4aa6a',NULL,NULL,NULL,NULL,'2025-11-29 07:59:38',NULL,'2025-11-29 07:59:38',NULL,NULL),(283,NULL,'dfe9f391140d491698935f7fe6747460',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:59:40',NULL,'2025-11-29 07:59:40',NULL,NULL),(284,NULL,NULL,'1988a7aa29b04893a64113a82ce7dfe1',NULL,NULL,NULL,NULL,'2025-11-29 07:59:42',NULL,'2025-11-29 07:59:42',NULL,NULL),(285,NULL,'bb391f0b183d48f893b79762d5cdb579',NULL,NULL,NULL,NULL,NULL,'2025-11-29 07:59:44',NULL,'2025-11-29 07:59:44',NULL,NULL),(286,NULL,NULL,'0cbc1fad0f0b481797ed6cafcd266d99',NULL,NULL,NULL,NULL,'2025-11-29 08:00:24',NULL,'2025-11-29 08:00:24',NULL,NULL),(287,NULL,'19b3dc1655684be39c6d284805874456',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:00:25',NULL,'2025-11-29 08:00:25',NULL,NULL),(288,NULL,NULL,'8d4e5ab1ae494327abcb3693ba332586',NULL,NULL,NULL,NULL,'2025-11-29 08:01:52',NULL,'2025-11-29 08:01:52',NULL,NULL),(289,NULL,'6fce027870d041328a9b9968bfe90665',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:01:53',NULL,'2025-11-29 08:01:53',NULL,NULL),(290,NULL,NULL,'fccef0dffe5046debab8211997669052',NULL,NULL,NULL,NULL,'2025-11-29 08:02:04',NULL,'2025-11-29 08:02:04',NULL,NULL),(291,NULL,'9cfb4837af3c440e93179ccec8e1811d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:02:05',NULL,'2025-11-29 08:02:05',NULL,NULL),(292,NULL,NULL,'f7d59bea260d4752aa29379967636c0b',NULL,NULL,NULL,NULL,'2025-11-29 08:02:17',NULL,'2025-11-29 08:02:17',NULL,NULL),(293,NULL,'4d8c5b7e3ca74bc1880eb616b04711f7',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:02:19',NULL,'2025-11-29 08:02:19',NULL,NULL),(294,NULL,NULL,'95e93166b3844248862d7292fb094271',NULL,NULL,NULL,NULL,'2025-11-29 08:02:24',NULL,'2025-11-29 08:02:24',NULL,NULL),(295,NULL,'d81eb0075a4e4e12b5b90eff0236280a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:02:28',NULL,'2025-11-29 08:02:28',NULL,NULL),(296,NULL,NULL,'e4275accda97462bab41d1990f4a1b03',NULL,NULL,NULL,NULL,'2025-11-29 08:03:41',NULL,'2025-11-29 08:03:41',NULL,NULL),(297,NULL,'7d7a9c03bcbc4a8e999e674c1d3a933a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:03:43',NULL,'2025-11-29 08:03:43',NULL,NULL),(298,NULL,NULL,'a814d0c4600e45d9a1fac7bac5b7e69e',NULL,NULL,NULL,NULL,'2025-11-29 08:03:57',NULL,'2025-11-29 08:03:57',NULL,NULL),(299,NULL,'f69605de164b4c27ae715521263676fe',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:03:58',NULL,'2025-11-29 08:03:58',NULL,NULL),(300,NULL,NULL,'b7d64f2611204481b2cb7f9b3178a0cf',NULL,NULL,NULL,NULL,'2025-11-29 08:04:45',NULL,'2025-11-29 08:04:45',NULL,NULL),(301,NULL,'e5224c4ebb92449a962d40c6cf1dd719',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:04:47',NULL,'2025-11-29 08:04:47',NULL,NULL),(302,NULL,NULL,'1a9dbe11399b4d34ad4c7a0a4098b324',NULL,NULL,NULL,NULL,'2025-11-29 08:04:51',NULL,'2025-11-29 08:04:51',NULL,NULL),(303,NULL,'bfe413599ef1478a806f8de6ae727e3a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:04:53',NULL,'2025-11-29 08:04:53',NULL,NULL),(304,NULL,NULL,'d77e751616c9473786c8ac7ae2d34d20',NULL,NULL,NULL,NULL,'2025-11-29 08:05:27',NULL,'2025-11-29 08:05:27',NULL,NULL),(305,NULL,NULL,'c9f21a9d5d8b4fa4b1f0c50a041ab850',NULL,NULL,NULL,NULL,'2025-11-29 08:05:27',NULL,'2025-11-29 08:05:27',NULL,NULL),(306,NULL,'faa91146f75c46ebbcd15bb2222a8545',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:05:28',NULL,'2025-11-29 08:05:28',NULL,NULL),(307,NULL,'c011825affe944ee865e61ea93ffd5ea',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:05:31',NULL,'2025-11-29 08:05:31',NULL,NULL),(308,NULL,NULL,'b752bbc38da346cd906c48b7e558600a',NULL,NULL,NULL,NULL,'2025-11-29 08:05:46',NULL,'2025-11-29 08:05:46',NULL,NULL),(309,NULL,'1cbb1a55279047568ac52b0498dba447',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:05:47',NULL,'2025-11-29 08:05:47',NULL,NULL),(310,NULL,NULL,'fea0b5a703d4426882e6691d4313bd30',NULL,NULL,NULL,NULL,'2025-11-29 08:05:51',NULL,'2025-11-29 08:05:51',NULL,NULL),(311,NULL,'90b6d3cc4af4471cb593f860c98e0cba',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:05:52',NULL,'2025-11-29 08:05:52',NULL,NULL),(312,NULL,NULL,'ef8e9cc962eb4827954df3c42cc34798',NULL,NULL,NULL,NULL,'2025-11-29 08:06:49',NULL,'2025-11-29 08:06:49',NULL,NULL),(313,NULL,'f8bc2a2616a34ba1a18b3211e406993f',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:06:51',NULL,'2025-11-29 08:06:51',NULL,NULL),(314,NULL,NULL,'484a7cf7f6cc49de97903a4efa4db0a5',NULL,NULL,NULL,NULL,'2025-11-29 08:07:40',NULL,'2025-11-29 08:07:40',NULL,NULL),(315,NULL,'3fc18ed0bcfe45d99b2965a6745bb628',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:07:41',NULL,'2025-11-29 08:07:41',NULL,NULL),(316,NULL,NULL,'29543b27de044f598a4f01771690222b',NULL,NULL,NULL,NULL,'2025-11-29 08:08:27',NULL,'2025-11-29 08:08:27',NULL,NULL),(317,NULL,'bd1d90fea8c547aea033c26b5dd1ccc2',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:08:28',NULL,'2025-11-29 08:08:28',NULL,NULL),(318,NULL,NULL,'20d37020e7484e3ead9c61a89db491b1',NULL,NULL,NULL,NULL,'2025-11-29 08:08:46',NULL,'2025-11-29 08:08:46',NULL,NULL),(319,NULL,NULL,'e2dd786ba01340eb9357955a41e0f036',NULL,NULL,NULL,NULL,'2025-11-29 08:08:46',NULL,'2025-11-29 08:08:46',NULL,NULL),(320,NULL,'a6104c57e0814f16958b14707debf843',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:08:47',NULL,'2025-11-29 08:08:47',NULL,NULL),(321,NULL,'5e159fba765947938177046fbae16d2e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:08:48',NULL,'2025-11-29 08:08:48',NULL,NULL),(322,NULL,NULL,'f5c9a929d4b248288b84a67f96ca500d',NULL,NULL,NULL,NULL,'2025-11-29 08:08:53',NULL,'2025-11-29 08:08:53',NULL,NULL),(323,NULL,NULL,'c283f2be04e8419f80ae8b3f16017d34',NULL,NULL,NULL,NULL,'2025-11-29 08:08:53',NULL,'2025-11-29 08:08:53',NULL,NULL),(324,NULL,'e61a0774e90545289bd82e4a71650bde',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:08:54',NULL,'2025-11-29 08:08:54',NULL,NULL),(325,NULL,'26388bce3fc444caac17353011a07e87',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:08:55',NULL,'2025-11-29 08:08:55',NULL,NULL),(326,NULL,NULL,'f8306d30b5b844909866bec7b9c8242d',NULL,NULL,NULL,NULL,'2025-11-29 08:09:27',NULL,'2025-11-29 08:09:27',NULL,NULL),(327,NULL,'8e860226190f4eb8971376b16032da1b',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:09:28',NULL,'2025-11-29 08:09:28',NULL,NULL),(328,NULL,NULL,'59f60b6ae5304ccbbe873550b6e62e81',NULL,NULL,NULL,NULL,'2025-11-29 08:09:32',NULL,'2025-11-29 08:09:32',NULL,NULL),(329,NULL,NULL,'5a7b61623f854cf59636f192ab8af005',NULL,NULL,NULL,NULL,'2025-11-29 08:09:33',NULL,'2025-11-29 08:09:33',NULL,NULL),(330,NULL,'a717411af66b4c23a4cc35a3803ff3b6',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:09:33',NULL,'2025-11-29 08:09:33',NULL,NULL),(331,NULL,'750bde86c9c7473fbf7f0a6a3b16cec1',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:09:35',NULL,'2025-11-29 08:09:35',NULL,NULL),(332,NULL,NULL,'95361d3a276f4d7f81e9f9a4bcafd2ea',NULL,NULL,NULL,NULL,'2025-11-29 08:09:42',NULL,'2025-11-29 08:09:42',NULL,NULL),(333,NULL,'e3e18973b82a4071bdc187ede8c1afb8',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:09:43',NULL,'2025-11-29 08:09:43',NULL,NULL),(334,NULL,NULL,'6907cc56541a4a7a9e563fe7c11cf669',NULL,NULL,NULL,NULL,'2025-11-29 08:10:12',NULL,'2025-11-29 08:10:12',NULL,NULL),(335,NULL,'5edfd39e548a47c3b5602c79308928e7',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:10:15',NULL,'2025-11-29 08:10:15',NULL,NULL),(336,NULL,NULL,'71c4dd5c4e2349afbbda49e7451e8b52',NULL,NULL,NULL,NULL,'2025-11-29 08:10:19',NULL,'2025-11-29 08:10:19',NULL,NULL),(337,NULL,'fd1611d1122b40baa91a43a7165fb1d1',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:10:20',NULL,'2025-11-29 08:10:20',NULL,NULL),(338,NULL,NULL,'7c90fe1780904a6098015abc66b38d9d',NULL,NULL,NULL,NULL,'2025-11-29 08:10:43',NULL,'2025-11-29 08:10:43',NULL,NULL),(339,NULL,'baca94adaa5145a6b9cef930bff28fa4',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:10:45',NULL,'2025-11-29 08:10:45',NULL,NULL),(340,NULL,NULL,'a776b2def7b4458d8c8ed719c2ea771b',NULL,NULL,NULL,NULL,'2025-11-29 08:11:23',NULL,'2025-11-29 08:11:23',NULL,NULL),(341,NULL,'c88bdebf444849adaebaf037c057e96a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:11:25',NULL,'2025-11-29 08:11:25',NULL,NULL),(342,NULL,NULL,'9cb37d6d47ac46aaa19aebb2e5b21658',NULL,NULL,NULL,NULL,'2025-11-29 08:14:14',NULL,'2025-11-29 08:14:14',NULL,NULL),(343,NULL,'146c65131f5b423287d348b351399c4e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:14:16',NULL,'2025-11-29 08:14:16',NULL,NULL),(344,NULL,NULL,'462999b573374bfcb81584d2238b4b10',NULL,NULL,NULL,NULL,'2025-11-29 08:14:56',NULL,'2025-11-29 08:14:56',NULL,NULL),(345,NULL,'97aaebdc8caa4b86b7ec1a55d18e557d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:14:56',NULL,'2025-11-29 08:14:56',NULL,NULL),(346,NULL,NULL,'8dfd7d44b219445e87f720287c54e093',NULL,NULL,NULL,NULL,'2025-11-29 08:15:46',NULL,'2025-11-29 08:15:46',NULL,NULL),(347,NULL,'e18e33f6f2ab40279f539fc9988c80d8',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:15:47',NULL,'2025-11-29 08:15:47',NULL,NULL),(348,NULL,NULL,'58625e4c2b5d43a1abbab05b98853a65',NULL,NULL,NULL,NULL,'2025-11-29 08:16:13',NULL,'2025-11-29 08:16:13',NULL,NULL),(349,NULL,'250671461f27498d9f6b4476c7b69533',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:16:14',NULL,'2025-11-29 08:16:14',NULL,NULL),(350,NULL,NULL,'75aa7d805acd4cf29b76ffd4333a104f',NULL,NULL,NULL,NULL,'2025-11-29 08:16:28',NULL,'2025-11-29 08:16:28',NULL,NULL),(351,NULL,'450ea210ad0e4364901c0d605c869a2c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:16:29',NULL,'2025-11-29 08:16:29',NULL,NULL),(352,NULL,NULL,'ca93c8e3eac142c0aa6b61807727dea2',NULL,NULL,NULL,NULL,'2025-11-29 08:16:44',NULL,'2025-11-29 08:16:44',NULL,NULL),(353,NULL,'ba867fac17034bb28fe2cdb0fff3af2b',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:16:45',NULL,'2025-11-29 08:16:45',NULL,NULL),(354,NULL,NULL,'1a450f033f4b43228c2c9b5248d22920',NULL,NULL,NULL,NULL,'2025-11-29 08:16:46',NULL,'2025-11-29 08:16:46',NULL,NULL),(355,NULL,'78b2479aee5a4b97b0c6fe9e5eaffb36',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:16:47',NULL,'2025-11-29 08:16:47',NULL,NULL),(356,NULL,NULL,'661b6600a32b40d8a48db16cb71c7e75',NULL,NULL,NULL,NULL,'2025-11-29 08:16:57',NULL,'2025-11-29 08:16:57',NULL,NULL),(357,NULL,'d72b5448be0e463f80dca118feb42d3b',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:16:58',NULL,'2025-11-29 08:16:58',NULL,NULL),(358,NULL,NULL,'f3d87a5e5ad344d1bcc70ba8075f3ca5',NULL,NULL,NULL,NULL,'2025-11-29 08:17:22',NULL,'2025-11-29 08:17:22',NULL,NULL),(359,NULL,'363fe98c689041caaa9c21709efe6d5e',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:17:22',NULL,'2025-11-29 08:17:22',NULL,NULL),(360,NULL,NULL,'97c94eba4968495e9801d5e3afc94a72',NULL,NULL,NULL,NULL,'2025-11-29 08:17:24',NULL,'2025-11-29 08:17:24',NULL,NULL),(361,NULL,'3d1a4708cff44cd7853545efb6ccc406',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:17:25',NULL,'2025-11-29 08:17:25',NULL,NULL),(362,NULL,NULL,'7bb4a89eea4e4166a7a1c5e3135cb182',NULL,NULL,NULL,NULL,'2025-11-29 08:17:28',NULL,'2025-11-29 08:17:28',NULL,NULL),(363,NULL,'6025758b69854406b221c47d9ef59dea',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:17:29',NULL,'2025-11-29 08:17:29',NULL,NULL),(364,NULL,NULL,'2c3e0eea992e4cad82cbc8d3fa09e489',NULL,NULL,NULL,NULL,'2025-11-29 08:17:33',NULL,'2025-11-29 08:17:33',NULL,NULL),(365,NULL,NULL,'9a31970a67d04c998d5af63d1dae30c7',NULL,NULL,NULL,NULL,'2025-11-29 08:17:33',NULL,'2025-11-29 08:17:33',NULL,NULL),(366,NULL,'d0f6f9bf9eae437ba35273f5b1cc1c81',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:17:35',NULL,'2025-11-29 08:17:35',NULL,NULL),(367,NULL,NULL,'bceaa894988f47b6870b2a3685a7de6d',NULL,NULL,NULL,NULL,'2025-11-29 08:17:40',NULL,'2025-11-29 08:17:40',NULL,NULL),(368,NULL,'0ddcf5b6bfeb4db184951e07d296aa62',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:17:41',NULL,'2025-11-29 08:17:41',NULL,NULL),(369,NULL,NULL,'9d3b2212bcd144cbb0c1abdeb25b9998',NULL,NULL,NULL,NULL,'2025-11-29 08:18:06',NULL,'2025-11-29 08:18:06',NULL,NULL),(370,NULL,'53808986ef2542a6b39d9d28957c85c7',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:18:08',NULL,'2025-11-29 08:18:08',NULL,NULL),(371,NULL,NULL,'942fc293eca343c5968f74e14b91d515',NULL,NULL,NULL,NULL,'2025-11-29 08:18:19',NULL,'2025-11-29 08:18:19',NULL,NULL),(372,NULL,'2f97cf99a149454eb333842c8e9713b0',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:18:21',NULL,'2025-11-29 08:18:21',NULL,NULL),(373,NULL,NULL,'64c0341c4b844cbc9fd50d485aa954a0',NULL,NULL,NULL,NULL,'2025-11-29 08:18:25',NULL,'2025-11-29 08:18:25',NULL,NULL),(374,NULL,'b4fb4eb1c2db40a5b320f63884fe8888',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:18:26',NULL,'2025-11-29 08:18:26',NULL,NULL),(375,NULL,NULL,'3d42fe42c8cd46be80de3ef91eaf4aa8',NULL,NULL,NULL,NULL,'2025-11-29 08:19:13',NULL,'2025-11-29 08:19:13',NULL,NULL),(376,NULL,NULL,'650e6bc0da5349f5aea2429ed972656e',NULL,NULL,NULL,NULL,'2025-11-29 08:19:13',NULL,'2025-11-29 08:19:13',NULL,NULL),(377,NULL,'f23df508be834631988b5617f5fba1fa',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:19:15',NULL,'2025-11-29 08:19:15',NULL,NULL),(378,NULL,'8c4fadda976d4920ad442d740dc7159a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:19:15',NULL,'2025-11-29 08:19:15',NULL,NULL),(379,NULL,NULL,'d043b72e9a1f4575835e938f1a090e3a',NULL,NULL,NULL,NULL,'2025-11-29 08:19:21',NULL,'2025-11-29 08:19:21',NULL,NULL),(380,NULL,NULL,'6dc4d1d828c2497da58cf904e0d9eb35',NULL,NULL,NULL,NULL,'2025-11-29 08:19:21',NULL,'2025-11-29 08:19:21',NULL,NULL),(381,NULL,'4b2d7c5689334b7eb116fab1fd5dedac',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:19:22',NULL,'2025-11-29 08:19:22',NULL,NULL),(382,NULL,NULL,'504bc6adabad4f7d8c17b0438c4d9be7',NULL,NULL,NULL,NULL,'2025-11-29 08:21:26',NULL,'2025-11-29 08:21:26',NULL,NULL),(383,NULL,'b9d4c81989d641678300c7a1c173a2c2',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:21:27',NULL,'2025-11-29 08:21:27',NULL,NULL),(384,NULL,NULL,'3b9a756606a84398819fa76cc6ce9ecd',NULL,NULL,NULL,NULL,'2025-11-29 08:22:35',NULL,'2025-11-29 08:22:35',NULL,NULL),(385,NULL,NULL,'babdfe5bce8f4f8c92325cb439ef256f',NULL,NULL,NULL,NULL,'2025-11-29 08:22:35',NULL,'2025-11-29 08:22:35',NULL,NULL),(386,NULL,'a738c288b1654ec58416b0da60aacb69',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:22:38',NULL,'2025-11-29 08:22:38',NULL,NULL),(387,NULL,NULL,'27fbef868fd944adb0787ac691f465f5',NULL,NULL,NULL,NULL,'2025-11-29 08:22:58',NULL,'2025-11-29 08:22:58',NULL,NULL),(388,NULL,'4574185f65454582b56aa1dfb65251ba',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:23:00',NULL,'2025-11-29 08:23:00',NULL,NULL),(389,NULL,NULL,'0508bf8e51cf4e00992499288c702602',NULL,NULL,NULL,NULL,'2025-11-29 08:23:14',NULL,'2025-11-29 08:23:14',NULL,NULL),(390,NULL,'42dc6c0cde654493984d9a0a65843d9a',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:23:15',NULL,'2025-11-29 08:23:15',NULL,NULL),(391,NULL,NULL,'65223c09766741339d5720b5cb0f35a0',NULL,NULL,NULL,NULL,'2025-11-29 08:23:18',NULL,'2025-11-29 08:23:18',NULL,NULL),(392,NULL,'c69bc34cb181407ea35b546223f3495b',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:23:20',NULL,'2025-11-29 08:23:20',NULL,NULL),(393,NULL,NULL,'3b52040d601a4a56abcaf3f046f1e349',NULL,NULL,NULL,NULL,'2025-11-29 08:23:32',NULL,'2025-11-29 08:23:32',NULL,NULL),(394,NULL,'358970eca7ad4b05b70f43e5507ac052',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:23:35',NULL,'2025-11-29 08:23:35',NULL,NULL),(395,NULL,NULL,'09f1f8a0998948b7b96830d8559609f6',NULL,NULL,NULL,NULL,'2025-11-29 08:23:48',NULL,'2025-11-29 08:23:48',NULL,NULL),(396,NULL,'61d8d3b6b31f4b36b5749db9c550c696',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:23:50',NULL,'2025-11-29 08:23:50',NULL,NULL),(397,NULL,NULL,'927e2238ca0c4d26830812effffe75ae',NULL,NULL,NULL,NULL,'2025-11-29 08:24:11',NULL,'2025-11-29 08:24:11',NULL,NULL),(398,NULL,'1e7450dd88894243affe67274f9cceb0',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:24:14',NULL,'2025-11-29 08:24:14',NULL,NULL),(399,NULL,NULL,'60088a0db74d464b8cbc442eae1f371c',NULL,NULL,NULL,NULL,'2025-11-29 08:24:44',NULL,'2025-11-29 08:24:44',NULL,NULL),(400,NULL,'c1fc65ff70ce460c924739eae21e2b49',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:24:46',NULL,'2025-11-29 08:24:46',NULL,NULL),(401,NULL,NULL,'3a37c720b9bb4273b66cd2dce30fbf48',NULL,NULL,NULL,NULL,'2025-11-29 08:27:42',NULL,'2025-11-29 08:27:42',NULL,NULL),(402,NULL,'d9406fbc6fef486fa5b0e79549e78d00',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:27:43',NULL,'2025-11-29 08:27:43',NULL,NULL),(403,NULL,NULL,'2e9157e25f964515a4cc154ffe85456c',NULL,NULL,NULL,NULL,'2025-11-29 08:27:47',NULL,'2025-11-29 08:27:47',NULL,NULL),(404,NULL,'354202154aa442c989baacf0c3057a49',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:27:49',NULL,'2025-11-29 08:27:49',NULL,NULL),(405,NULL,NULL,'cc98c29a4a6c46af9db7c0f609a8ba3d',NULL,NULL,NULL,NULL,'2025-11-29 08:27:54',NULL,'2025-11-29 08:27:54',NULL,NULL),(406,NULL,'af5a2531594540389b762bd13d671901',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:27:55',NULL,'2025-11-29 08:27:55',NULL,NULL),(407,NULL,NULL,'dfcf2db50da745c09bffcf32ec016854',NULL,NULL,NULL,NULL,'2025-11-29 08:27:56',NULL,'2025-11-29 08:27:56',NULL,NULL),(408,NULL,'09cc8c3182d845f597dda064f9013941',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:27:56',NULL,'2025-11-29 08:27:56',NULL,NULL),(409,NULL,NULL,'55df82e9b2dd406ebf4bbb33b4b8ba27',NULL,NULL,NULL,NULL,'2025-11-29 08:27:59',NULL,'2025-11-29 08:27:59',NULL,NULL),(410,NULL,'089a2328a33f4f7a8305102501466a92',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:28:03',NULL,'2025-11-29 08:28:03',NULL,NULL),(411,NULL,NULL,'0cbb3ac39ebd4876ad23f2a6d1c50166',NULL,NULL,NULL,NULL,'2025-11-29 08:29:48',NULL,'2025-11-29 08:29:48',NULL,NULL),(412,NULL,NULL,'a1db25e505094084a877a739be10485f',NULL,NULL,NULL,NULL,'2025-11-29 08:29:50',NULL,'2025-11-29 08:29:50',NULL,NULL),(413,NULL,'f9a9decdabb1480da8f7d039e8b3d414',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:29:51',NULL,'2025-11-29 08:29:51',NULL,NULL),(414,NULL,'07e12c4331664c2e80d677fb37c75704',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:29:52',NULL,'2025-11-29 08:29:52',NULL,NULL),(415,NULL,NULL,'b4f4d28745dd46e586642c84c051db39',NULL,NULL,NULL,NULL,'2025-11-29 08:30:22',NULL,'2025-11-29 08:30:22',NULL,NULL),(416,NULL,'23450c2eaf4442459dec94c6d29f0412',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:30:24',NULL,'2025-11-29 08:30:24',NULL,NULL),(417,NULL,NULL,'d039e57f31de4717a235fc96ebd56559',NULL,NULL,NULL,NULL,'2025-11-29 08:32:13',NULL,'2025-11-29 08:32:13',NULL,NULL),(418,NULL,NULL,'e02f973df4fa440192c792b778107820',NULL,NULL,NULL,NULL,'2025-11-29 08:32:13',NULL,'2025-11-29 08:32:13',NULL,NULL),(419,NULL,'527c6a274d1e478eadfe67139e121185',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:32:16',NULL,'2025-11-29 08:32:16',NULL,NULL),(420,NULL,'d2d64098df3c4359a5c207b185c9b823',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:32:19',NULL,'2025-11-29 08:32:19',NULL,NULL),(421,NULL,NULL,'7a362a419f6a492aae2f102ad2bbd5e9',NULL,NULL,NULL,NULL,'2025-11-29 08:32:43',NULL,'2025-11-29 08:32:43',NULL,NULL),(422,NULL,'eb0810bf6f5b4eb59638b7a2cf59ed5b',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:32:44',NULL,'2025-11-29 08:32:44',NULL,NULL),(423,NULL,NULL,'03abb169dca3464984975a0ece422458',NULL,NULL,NULL,NULL,'2025-11-29 08:32:49',NULL,'2025-11-29 08:32:49',NULL,NULL),(424,NULL,'12fcca7596944721afda13c50e6de05c',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:32:51',NULL,'2025-11-29 08:32:51',NULL,NULL),(425,NULL,NULL,'d45f9a4a44664af3884c15ce0f5697e0',NULL,NULL,NULL,NULL,'2025-11-29 08:32:55',NULL,'2025-11-29 08:32:55',NULL,NULL),(426,NULL,NULL,'def3e0a0f3f44f559c955f210b9091e0',NULL,NULL,NULL,NULL,'2025-11-29 08:32:55',NULL,'2025-11-29 08:32:55',NULL,NULL),(427,NULL,'87e4f8322f9b49969bfa70eb0cb1cff6',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:32:57',NULL,'2025-11-29 08:32:57',NULL,NULL),(428,NULL,'7e8e7407a7c44208a503e8225c1cf518',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:32:59',NULL,'2025-11-29 08:32:59',NULL,NULL),(429,NULL,NULL,'2ad82d69b01a4929b20a4d3c4dbe0135',NULL,NULL,NULL,NULL,'2025-11-29 08:35:02',NULL,'2025-11-29 08:35:02',NULL,NULL),(430,NULL,NULL,'60f81521815241cdb87a9c348c3a2d36',NULL,NULL,NULL,NULL,'2025-11-29 08:35:02',NULL,'2025-11-29 08:35:02',NULL,NULL),(431,NULL,'340d97a89c434bedbead3110819c581d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:35:04',NULL,'2025-11-29 08:35:04',NULL,NULL),(432,NULL,'da1f1fa420a94dc59ef1d7420ba5bfd7',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:35:06',NULL,'2025-11-29 08:35:06',NULL,NULL),(433,NULL,NULL,'e6de0587a3794e30acefc687f435d388',NULL,NULL,NULL,NULL,'2025-11-29 08:35:10',NULL,'2025-11-29 08:35:10',NULL,NULL),(434,NULL,'37972b49ddde4c519c6523d2ea1569b5',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:35:10',NULL,'2025-11-29 08:35:10',NULL,NULL),(435,NULL,NULL,'ca2de5a759104a32859a6abb65ee29ac',NULL,NULL,NULL,NULL,'2025-11-29 08:35:14',NULL,'2025-11-29 08:35:14',NULL,NULL),(436,NULL,'d27edc07e9954ef4b3a91fc8198e4434',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:35:15',NULL,'2025-11-29 08:35:15',NULL,NULL),(437,NULL,NULL,'6126044d5f7d49d19e3feffbc3034024',NULL,NULL,NULL,NULL,'2025-11-29 08:37:57',NULL,'2025-11-29 08:37:57',NULL,NULL),(438,NULL,NULL,'15be03695cff49b4bdfe7b74b2be2a0d',NULL,NULL,NULL,NULL,'2025-11-29 08:37:57',NULL,'2025-11-29 08:37:57',NULL,NULL),(439,NULL,'3827b5eea76e4810b48ea1733ae5edc4',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:37:58',NULL,'2025-11-29 08:37:58',NULL,NULL),(440,NULL,'e0c78031b9e34b3a8c85c986c3210d1d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:38:02',NULL,'2025-11-29 08:38:02',NULL,NULL),(441,NULL,NULL,'a45da8ed818144f8bd6e00d233fcb5d2',NULL,NULL,NULL,NULL,'2025-11-29 08:46:33',NULL,'2025-11-29 08:46:33',NULL,NULL),(442,NULL,NULL,'02ca6537c3444698b6f9f44f760fa337',NULL,NULL,NULL,NULL,'2025-11-29 08:46:33',NULL,'2025-11-29 08:46:33',NULL,NULL),(443,NULL,NULL,'4aa7a05ac257481c8c9d80cf2f2ad8da',NULL,NULL,NULL,NULL,'2025-11-29 08:46:33',NULL,'2025-11-29 08:46:33',NULL,NULL),(444,NULL,'9414b14debe34aef968a821a9866ef08',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:46:35',NULL,'2025-11-29 08:46:35',NULL,NULL),(445,NULL,'03858b11000d4b57bd3659c3083eed47',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:46:37',NULL,'2025-11-29 08:46:37',NULL,NULL),(446,NULL,'5d3c0f3974c74b13a327580f37daeed4',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:46:40',NULL,'2025-11-29 08:46:40',NULL,NULL),(447,NULL,NULL,'686f527a5723407b85ed34c8a312583f',NULL,NULL,NULL,NULL,'2025-11-29 08:47:35',NULL,'2025-11-29 08:47:35',NULL,NULL),(448,NULL,NULL,'7b4e953ac9d64d2b8bf3cbf02c1c9371',NULL,NULL,NULL,NULL,'2025-11-29 08:47:36',NULL,'2025-11-29 08:47:36',NULL,NULL),(449,NULL,'c4ca87a38a19497f84b6d2c170c4fe75',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:47:37',NULL,'2025-11-29 08:47:37',NULL,NULL),(450,NULL,'112d5da6ad864b7d8fdc6c67f60d3c7d',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:47:38',NULL,'2025-11-29 08:47:38',NULL,NULL),(451,NULL,NULL,'5dbbf4fd34004538ad08aa4aa6ab8096',NULL,NULL,NULL,NULL,'2025-11-29 08:50:50',NULL,'2025-11-29 08:50:50',NULL,NULL),(452,NULL,NULL,'463896a65e394c9ea44fb38e5420cc14',NULL,NULL,NULL,NULL,'2025-11-29 08:50:51',NULL,'2025-11-29 08:50:51',NULL,NULL),(453,NULL,'c5e836f8387a492c8119be72f1fb9980',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:50:52',NULL,'2025-11-29 08:50:52',NULL,NULL),(454,NULL,'97c4587652c14365a9708d6f0229a7d5',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:50:53',NULL,'2025-11-29 08:50:53',NULL,NULL),(455,NULL,NULL,'7b36e3f2406043c2a741c24fb14de7df',NULL,NULL,NULL,NULL,'2025-11-29 08:53:38',NULL,'2025-11-29 08:53:38',NULL,NULL),(456,NULL,NULL,'3deb6cadd8cf48b287096e84dcc18e8e',NULL,NULL,NULL,NULL,'2025-11-29 08:53:39',NULL,'2025-11-29 08:53:39',NULL,NULL),(457,NULL,'0596f9d1e5a5444ca2640f6e8244d53f',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:53:42',NULL,'2025-11-29 08:53:42',NULL,NULL),(458,NULL,'d8755b2f14d24a83abb39088bdff3a66',NULL,NULL,NULL,NULL,NULL,'2025-11-29 08:53:44',NULL,'2025-11-29 08:53:44',NULL,NULL),(459,NULL,NULL,'3a9ba73ff05b4529ad104362a5a57cc7',NULL,NULL,NULL,NULL,'2025-11-29 09:02:00',NULL,'2025-11-29 09:02:00',NULL,NULL),(460,NULL,NULL,'32cd2bfa5879456492a2fcf569e9fb48',NULL,NULL,NULL,NULL,'2025-11-29 09:02:00',NULL,'2025-11-29 09:02:00',NULL,NULL),(461,NULL,'fba842ed764c4937950b2a0c0827bf03',NULL,NULL,NULL,NULL,NULL,'2025-11-29 09:02:05',NULL,'2025-11-29 09:02:05',NULL,NULL),(462,NULL,'ca5878248147453baabf40a90f9feb19',NULL,NULL,NULL,NULL,NULL,'2025-11-29 09:02:07',NULL,'2025-11-29 09:02:07',NULL,NULL),(463,NULL,NULL,'72d4bc4447574563becfcc44047872c6',NULL,NULL,NULL,NULL,'2025-11-29 09:03:02',NULL,'2025-11-29 09:03:02',NULL,NULL),(464,NULL,NULL,'2cf2988cedb84f1fb59331b95618f711',NULL,NULL,NULL,NULL,'2025-11-29 09:03:02',NULL,'2025-11-29 09:03:02',NULL,NULL),(465,NULL,'68bb7f46e7ed430eaa1d724a2abe3a41',NULL,NULL,NULL,NULL,NULL,'2025-11-29 09:03:03',NULL,'2025-11-29 09:03:03',NULL,NULL),(466,NULL,'8df3322cf5114d3f8da9219df358d141',NULL,NULL,NULL,NULL,NULL,'2025-11-29 09:03:04',NULL,'2025-11-29 09:03:04',NULL,NULL),(467,NULL,NULL,'d65747cb23f34d0b82fe6b4b04e5930d',NULL,NULL,NULL,NULL,'2025-11-29 09:05:08',NULL,'2025-11-29 09:05:08',NULL,NULL),(468,NULL,NULL,'34d8988cb089463e90164e52a00dfbcd',NULL,NULL,NULL,NULL,'2025-11-29 09:05:08',NULL,'2025-11-29 09:05:08',NULL,NULL),(469,NULL,'79610f2eca54482d94e23676a7ebcbd7',NULL,NULL,NULL,NULL,NULL,'2025-11-29 09:05:09',NULL,'2025-11-29 09:05:09',NULL,NULL),(470,NULL,'8778224c6b8141ff81e94d6f4356acf6',NULL,NULL,NULL,NULL,NULL,'2025-11-29 09:05:10',NULL,'2025-11-29 09:05:10',NULL,NULL),(471,NULL,NULL,'d7766e8d2eb84c75a0df993c57157fe4',NULL,NULL,NULL,NULL,'2025-11-29 09:06:24',NULL,'2025-11-29 09:06:24',NULL,NULL),(472,NULL,NULL,'1ef789b2d4084ff99c58ebaccf153280',NULL,NULL,NULL,NULL,'2025-11-29 09:06:24',NULL,'2025-11-29 09:06:24',NULL,NULL),(473,NULL,'8c7919c45c334cfb95f0fdc69027c245',NULL,NULL,NULL,NULL,NULL,'2025-11-29 09:06:25',NULL,'2025-11-29 09:06:25',NULL,NULL),(474,NULL,'309bb9682d8741cb96a008986d8d01dd',NULL,NULL,NULL,NULL,NULL,'2025-11-29 09:06:26',NULL,'2025-11-29 09:06:26',NULL,NULL),(475,NULL,NULL,'53a6dc16ba1e40b4bb06e501d27ab8d1',NULL,NULL,NULL,NULL,'2025-11-29 09:06:42',NULL,'2025-11-29 09:06:42',NULL,NULL),(476,NULL,NULL,'2307ed6fbe40496784ed495bccde09bc',NULL,NULL,NULL,NULL,'2025-11-29 09:06:43',NULL,'2025-11-29 09:06:43',NULL,NULL),(477,NULL,'96b7210dcb5f4c37b7ba239145516256',NULL,NULL,NULL,NULL,NULL,'2025-11-29 09:06:45',NULL,'2025-11-29 09:06:45',NULL,NULL),(478,NULL,NULL,'5ff561a95dc44b9fb9f7fd8fee80f589',NULL,NULL,NULL,NULL,'2025-11-29 09:16:24',NULL,'2025-11-29 09:16:24',NULL,NULL),(479,NULL,NULL,'8db6e2e5351c40e1bb773a2db67f7ebd',NULL,NULL,NULL,NULL,'2025-11-29 09:16:24',NULL,'2025-11-29 09:16:24',NULL,NULL),(480,NULL,'51af0a2ee11a460ab825a484e5c6f4a3',NULL,NULL,NULL,NULL,NULL,'2025-11-29 09:16:25',NULL,'2025-11-29 09:16:25',NULL,NULL),(481,NULL,'4ddd3c2147c144ca985fcf334ba68c84',NULL,NULL,NULL,NULL,NULL,'2025-11-29 09:16:26',NULL,'2025-11-29 09:16:26',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('1df15c48d4b54ce1be9e293822c19a61','member','{}','<<null>>',NULL),('304d616ea9a142b288004b6af212b94d','swiftoperator','{}','<<null>>',NULL),('315c85eafee64b0ab0629c6f09a31b19','service','{}','<<null>>',NULL),('6eaa1817356c4d57950ef643d32da581','admin','{}','<<null>>',NULL),('a2fa0854eb864e85ab5d7c54338b94b1','ResellerAdmin','{}','<<null>>',NULL),('a83af16119404dbc80e7a6285ecb859e','reader','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('1df15c48d4b54ce1be9e293822c19a61','IMMU','true'),('6eaa1817356c4d57950ef643d32da581','IMMU','true'),('a83af16119404dbc80e7a6285ecb859e','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('0d0c4d95175849989b167d9a7c608217','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('142b815848f940c8bddfa89b5928819f','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('1a938885dcea415ea01ea9b485229574','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('1b1b6c9d72af4a4eaf4b139e5c16e78f','identity',1,'{\"name\": \"keystone\"}'),('38016b6f00e94be781f164229ba7f4d7','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('5c159f213d69451cbf0b88cfd9a470c9','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('f805e270a0b84a79869728af322f8ede','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('f9923dcb9cf046f4810f51f9b0ac2a3a','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('ffdb89b3c79a4235a77a1d123b0671e8','object-store',1,'{\"name\": \"swift\", \"description\": \"OpenStack Object Storage\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','7d32840c789849a29c7630e25f803b3c','system','6eaa1817356c4d57950ef643d32da581',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_trust_id` (`trust_id`),
  KEY `ix_token_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('06ac4af37d974605aafdb1bb3607f101','{}',1,'ad029182ad604de9a9f142e9cb3c3eec','2025-11-29 06:49:54','2025-11-29','default'),('1c1a72498230489eaf59bf0fb0c33001','{}',1,'ad029182ad604de9a9f142e9cb3c3eec','2025-11-29 07:12:35',NULL,'default'),('45fff6073ec04a3a803020c8c4aabd57','{\"tenantId\": \"6a519c638af44a9299a942b31ee65243\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2025-11-29 07:39:49',NULL,'default'),('466ed5261fc84e5d86e3a36e86714317','{}',1,'ad029182ad604de9a9f142e9cb3c3eec','2025-11-29 06:49:47','2025-11-29','default'),('4f3f8cf3fc5c4203bde5a3c1aed02357','{}',1,'ad029182ad604de9a9f142e9cb3c3eec','2025-11-29 06:49:11','2025-11-29','default'),('5a8f6e09d9d9417f99023c9d150e8a2f','{}',1,'ad029182ad604de9a9f142e9cb3c3eec','2025-11-29 06:54:00','2025-11-29','default'),('6b15f899f0ec4061b471afa0c1f5c75e','{}',1,'ad029182ad604de9a9f142e9cb3c3eec','2025-11-29 06:49:28','2025-11-29','default'),('6d25dc9c265e4895b997b6192a868554','{}',1,'ad029182ad604de9a9f142e9cb3c3eec','2025-11-29 06:51:05','2025-11-29','default'),('7d32840c789849a29c7630e25f803b3c','{}',1,NULL,'2025-11-29 06:46:22','2025-11-29','default'),('dfacc734c4c542069d1326226ba1a96f','{}',1,'ad029182ad604de9a9f142e9cb3c3eec','2025-11-29 06:50:51','2025-11-29','default'),('e2e8955079d24b0f935b0f2334bc1aa9','{\"tenantId\": \"d29a1676722c4152a0105ae2c7fc316f\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2025-11-29 07:39:48',NULL,'default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','placement','placement_da7d','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_da7d','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','keystone','keystone_33d8','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','glance','glance_c525','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_33d8','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_c525','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_783d','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_783d','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_bcf6','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_bcf6','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_380d','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_380d','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_9cd5','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_80d0','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_9cd5','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_80d0','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1764398606}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1764398606}'),('localhost','placement_da7d','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*3F8DF303D74B6631EDDEFCE1AF72825A848E6DF9\",\"password_last_changed\":1764398651}'),('%','placement_da7d','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*3F8DF303D74B6631EDDEFCE1AF72825A848E6DF9\",\"password_last_changed\":1764398651}'),('localhost','keystone_33d8','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*94F67F9D0AF2087966D3EB848A6E55B788193BC3\",\"password_last_changed\":1764398652}'),('localhost','glance_c525','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*CEE806D202FF4E9FBBA6999F5C64311C221F08F4\",\"password_last_changed\":1764398652}'),('%','keystone_33d8','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*94F67F9D0AF2087966D3EB848A6E55B788193BC3\",\"password_last_changed\":1764398652}'),('%','glance_c525','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*CEE806D202FF4E9FBBA6999F5C64311C221F08F4\",\"password_last_changed\":1764398652}'),('localhost','neutron_783d','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D78480DAFD6ABD74007D3D2662447CA6BCA476FB\",\"password_last_changed\":1764398661}'),('%','neutron_783d','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D78480DAFD6ABD74007D3D2662447CA6BCA476FB\",\"password_last_changed\":1764398661}'),('localhost','barbican_bcf6','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*8121825D6F710E3C99D1252209503EF4C53F6610\",\"password_last_changed\":1764398661}'),('%','barbican_bcf6','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*8121825D6F710E3C99D1252209503EF4C53F6610\",\"password_last_changed\":1764398661}'),('localhost','cinder_380d','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*BED1468D5D1A571AE98F70CB816FB5B5DE1F9E20\",\"password_last_changed\":1764398661}'),('%','cinder_380d','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*BED1468D5D1A571AE98F70CB816FB5B5DE1F9E20\",\"password_last_changed\":1764398661}'),('localhost','nova_cell0_9cd5','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B17DB332D7F01400763B1E9B9464E99B45B0345E\",\"password_last_changed\":1764398995}'),('localhost','nova_api_80d0','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*20A70C7119CB6B7D54BC20C2DDB179F54A4258EA\",\"password_last_changed\":1764398995}'),('%','nova_cell0_9cd5','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B17DB332D7F01400763B1E9B9464E99B45B0345E\",\"password_last_changed\":1764398995}'),('%','nova_api_80d0','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*20A70C7119CB6B7D54BC20C2DDB179F54A4258EA\",\"password_last_changed\":1764398995}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mysql_plugin\n-------------------------------------\n\nA plugin can be installed with the mysql_plugin utility if the server is\ncompletely offline.\n\nThe syntax is:\n\nmysql_plugin [options] <plugin> ENABLE|DISABLE\n\nFor example, to install the server_audit audit plugin, you could execute the\nfollowing:\n\nmysql_plugin server_audit ENABLE\n\nIf a plugin is installed with this utility, then a record will be added to the\nmysql.plugins table for the plugin. This means that the plugin will\nautomatically be loaded every time the server restarts, unless specifically\nuninstalled or deactivated.\n\nConfiguring the Plugin Directory\n--------------------------------\n\nWhen a plugin is being installed, the server looks for the plugin\'s library in\nthe server\'s plugin directory. This directory is configured by the plugin_dir\nsystem variable. This can be specified as a command-line argument to mysqld or\nit can be specified in a relevant server option group in an option file. For\nexample:\n\n[mariadb]\n...\nplugin_dir = /usr/lib64/mysql/plugin\n\nConfiguring the Minimum Plugin Maturity\n---------------------------------------\n\nWhen a plugin is being installed, the server compares the plugin\'s maturity\nlevel against the server\'s minimum allowed plugin maturity. This can help\nprevent users from using unstable plugins on production servers. This minimum\nplugin maturity is configured by the plugin_maturity system variable. This can\nbe specified as a command-line argument to mysqld or it can be specified in a\nrelevant server option group in an option file. For example:\n\n[mariadb]\n...\nplugin_maturity = stable\n\nConfiguring Plugin Activation at Server Startup\n-----------------------------------------------\n\nA plugin will be loaded by default when the server starts if:\n\n* The plugin was installed with the INSTALL SONAME statement.\n* The plugin was installed with the INSTALL PLUGIN statement.\n* The plugin was installed with the mysql_plugin utility.\n* The server is configured to load the plugin with the --plugin-load-add\noption.\n* The server is configured to load the plugin with the --plugin-load option.\n\nThis behavior can be changed with special options that take the form\n--plugin-name. For example, for the server_audit audit plugin, the special\noption is called --server-audit.\n\nThe possible values for these special options are:\n\n+---------------------------------------+------------------------------------+\n| Option Value                          | Description                        |\n+---------------------------------------+------------------------------------+\n| OFF                                   | Disables the plugin without        |\n|                                       | removing it from the               |\n|                                       | mysql.plugins table.               |\n+---------------------------------------+------------------------------------+\n| ON                                    | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will still continue         |\n|                                       | starting up, but the plugin will   |\n|                                       | be disabled.                       |\n+---------------------------------------+------------------------------------+\n| FORCE                                 | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error.                             |\n+---------------------------------------+------------------------------------+\n| FORCE_PLUS_PERMANENT                  | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error. In addition, the plugin     |\n|                                       | cannot be uninstalled with         |\n|                                       | UNINSTALL SONAME or UNINSTALL      |\n|                                       | PLUGIN while the server is         |\n|                                       | running.                           |\n+---------------------------------------+------------------------------------+\n\nA plugin\'s status can be found by looking at the PLUGIN_STATUS column of the\ninformation_schema.PLUGINS table.\n\nUninstalling Plugins\n--------------------\n\nPlugins that are found in the mysql.plugin table, that is those that were\ninstalled with INSTALL SONAME, INSTALL PLUGIN or mysql_plugin can be\nuninstalled in one of two ways:\n\n* The UNINSTALL SONAME or the UNINSTALL PLUGIN statement while the server is\nrunning\n* With mysql_plugin while the server is offline.\n\nPlugins that were enabled as a --plugin-load option do not need to be\nuninstalled. If --plugin-load is omitted the next time the server starts, or\nthe plugin is not listed as one of the --plugin-load entries, the plugin will\nnot be loaded.\n\nUNINSTALL PLUGIN uninstalls a single installed plugin, while UNINSTALL SONAME\nuninstalls all plugins belonging to a given library.\n\nURL: https://mariadb.com/kb/en/plugin-overview/','','https://mariadb.com/kb/en/plugin-overview/'),(79,'MBR Definition',6,'Description\n-----------\n\nThe MBR (Minimum Bounding Rectangle), or Envelope is the bounding geometry,\nformed by the minimum and maximum (X,Y) coordinates:\n\nExamples\n--------\n\n((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nURL: https://mariadb.com/kb/en/mbr-definition/','','https://mariadb.com/kb/en/mbr-definition/'),(80,'MBRContains',6,'Syntax\n------\n\nMBRContains(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\ncontains the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\n\nSET @g2 = GeomFromText(\'Point(1 1)\');\n\nSELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n+----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrcontains/','','https://mariadb.com/kb/en/mbrcontains/'),(82,'MBREqual',6,'Syntax\n------\n\nMBREqual(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are the same.\n\nExamples\n--------\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 2)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 2, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 3)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 4, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 0 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/mbrequal/','','https://mariadb.com/kb/en/mbrequal/'),(86,'MBRWithin',6,'Syntax\n------\n\nMBRWithin(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1 is\nwithin the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRContains().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nSELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n\nURL: https://mariadb.com/kb/en/mbrwithin/','','https://mariadb.com/kb/en/mbrwithin/'),(75,'UNINSTALL PLUGIN',5,'Syntax\n------\n\nUNINSTALL PLUGIN [IF EXISTS] plugin_name\n\nDescription\n-----------\n\nThis statement removes a single installed plugin. To uninstall the whole\nlibrary which contains the plugin, use UNINSTALL SONAME. You cannot uninstall\na plugin if any table that uses it is open.\n\nplugin_name must be the name of some plugin that is listed in the mysql.plugin\ntable. The server executes the plugin\'s deinitialization function and removes\nthe row for the plugin from the mysql.plugin table, so that subsequent server\nrestarts will not load and initialize the plugin. UNINSTALL PLUGIN does not\nremove the plugin\'s shared library file.\n\nTo use UNINSTALL PLUGIN, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nUNINSTALL PLUGIN example;\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------+\n| Level | Code | Message                       |\n+-------+------+-------------------------------+\n| Note  | 1305 | PLUGIN example does not exist |\n+-------+------+-------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-plugin/','','https://mariadb.com/kb/en/uninstall-plugin/'),(76,'INSTALL SONAME',5,'Syntax\n------\n\nINSTALL SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of INSTALL PLUGIN. It installs all plugins from a\ngiven plugin_library. See INSTALL PLUGIN for details.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL SONAME adds one or more lines to the mysql.plugin table that describes\nthe plugin. This table contains the plugin name and library file name.\n\nINSTALL SONAME causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL SONAME also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL SONAME, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nSONAME only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nIf you need to install only one plugin from a library, use the INSTALL PLUGIN\nstatement.\n\nExamples\n--------\n\nTo load the XtraDB storage engine and all of its information_schema tables\nwith one statement, use\n\nINSTALL SONAME \'ha_xtradb\';\n\nThis statement can be used instead of INSTALL PLUGIN even when the library\ncontains only one plugin:\n\nINSTALL SONAME \'ha_sequence\';\n\nURL: https://mariadb.com/kb/en/install-soname/','','https://mariadb.com/kb/en/install-soname/'),(77,'UNINSTALL SONAME',5,'Syntax\n------\n\nUNINSTALL SONAME  [IF EXISTS] \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of UNINSTALL PLUGIN statement, that removes all\nplugins belonging to a specified plugin_library. See UNINSTALL PLUGIN for\ndetails.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nTo use UNINSTALL SONAME, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin library does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nTo uninstall the XtraDB plugin and all of its information_schema tables with\none statement, use\n\nUNINSTALL SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------------+\n| Level | Code | Message                             |\n+-------+------+-------------------------------------+\n| Note  | 1305 | SONAME ha_example.so does not exist |\n+-------+------+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-soname/','','https://mariadb.com/kb/en/uninstall-soname/'),(90,'NULLIF',7,'Syntax\n------\n\nNULLIF(expr1,expr2)\n\nDescription\n-----------\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is the\nsame as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nExamples\n--------\n\nSELECT NULLIF(1,1);\n+-------------+\n| NULLIF(1,1) |\n+-------------+\n|        NULL |\n+-------------+\n\nSELECT NULLIF(1,2);\n+-------------+\n| NULLIF(1,2) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/nullif/','','https://mariadb.com/kb/en/nullif/'),(91,'NVL',7,'MariaDB starting with 10.3\n--------------------------\nFrom MariaDB 10.3, NVL is a synonym for IFNULL.\n\nURL: https://mariadb.com/kb/en/nvl/','','https://mariadb.com/kb/en/nvl/'),(92,'NVL2',7,'MariaDB starting with 10.3\n--------------------------\nThe NLV2 function was introduced in MariaDB 10.3.0.\n\nSyntax\n------\n\nNVL2(expr1,expr2,expr3)\n\nDescription\n-----------\n\nThe NVL2 function returns a value based on whether a specified expression is\nNULL or not. If expr1 is not NULL, then NVL2 returns expr2. If expr1 is NULL,\nthen NVL2 returns expr3.\n\nExamples\n--------\n\nSELECT NVL2(NULL,1,2);\n+----------------+\n| NVL2(NULL,1,2) |\n+----------------+\n|              2 |\n+----------------+\n\nSELECT NVL2(\'x\',1,2);\n+---------------+\n| NVL2(\'x\',1,2) |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/nvl2/','','https://mariadb.com/kb/en/nvl2/'),(81,'MBRDisjoint',6,'Syntax\n------\n\nMBRDisjoint(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are disjoint. Two geometries are disjoint if they do not\nintersect, that is touch or overlap.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECTmbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrdisjoint/','','https://mariadb.com/kb/en/mbrdisjoint/'),(83,'MBRIntersects',6,'Syntax\n------\n\nMBRIntersects(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 intersect.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      1 |\n+------------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      0 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/mbrintersects/','','https://mariadb.com/kb/en/mbrintersects/'),(84,'MBROverlaps',6,'Syntax\n------\n\nMBROverlaps(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 overlap. The term spatially overlaps is used if two\ngeometries intersect and their intersection results in a geometry of the same\ndimension but not equal to either of the given geometries.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbroverlaps/','','https://mariadb.com/kb/en/mbroverlaps/'),(85,'MBRTouches',6,'Syntax\n------\n\nMBRTouches(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 touch. Two geometries spatially touch if the interiors of\nthe geometries do not intersect, but the boundary of one of the geometries\nintersects either the boundary or the interior of the other.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   1 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/mbrtouches/','','https://mariadb.com/kb/en/mbrtouches/'),(87,'CASE OPERATOR',7,'Syntax\n------\n\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nDescription\n-----------\n\nThe first version returns the result where value=compare_value. The second\nversion returns the result for the first condition that is true. If there was\nno matching result value, the result after ELSE is returned, or NULL if there\nis no ELSE part.\n\nThere is also a CASE statement, which differs from the CASE operator described\nhere.\n\nExamples\n--------\n\nSELECT CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END;\n+------------------------------------------------------------+\n| CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END |\n+------------------------------------------------------------+\n| one                                                        |\n+------------------------------------------------------------+\n\nSELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n+--------------------------------------------+\n| CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END |\n+--------------------------------------------+\n| true                                       |\n+--------------------------------------------+\n\nSELECT CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n+-----------------------------------------------------+\n| CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END |\n+-----------------------------------------------------+\n|                                                NULL |\n+-----------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/case-operator/','','https://mariadb.com/kb/en/case-operator/'),(101,'UNLOCK TABLES',8,'Syntax\n------\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\nSee LOCK TABLES for more information.\n\nIn addition to releasing table locks acquired by the LOCK TABLES statement,\nthe UNLOCK TABLES statement also releases the global read lock acquired by the\nFLUSH TABLES WITH READ LOCK statement. The FLUSH TABLES WITH READ LOCK\nstatement is very useful for performing backups. See FLUSH for more\ninformation about FLUSH TABLES WITH READ LOCK.\n\nURL: https://mariadb.com/kb/en/transactions-unlock-tables/','','https://mariadb.com/kb/en/transactions-unlock-tables/'),(103,'XA Transactions',8,'Overview\n--------\n\nThe MariaDB XA implementation is based on the X/Open CAE document Distributed\nTransaction Processing: The XA Specification. This document is published by\nThe Open Group and available at\nhttp://www.opengroup.org/public/pubs/catalog/c193.htm.\n\nXA transactions are designed to allow distributed transactions, where a\ntransaction manager (the application) controls a transaction which involves\nmultiple resources. Such resources are usually DBMSs, but could be resources\nof any type. The whole set of required transactional operations is called a\nglobal transaction. Each subset of operations which involve a single resource\nis called a local transaction. XA used a 2-phases commit (2PC). With the first\ncommit, the transaction manager tells each resource to prepare an effective\ncommit, and waits for a confirm message. The changes are not still made\neffective at this point. If any of the resources encountered an error, the\ntransaction manager will rollback the global transaction. If all resources\ncommunicate that the first commit is successful, the transaction manager can\nrequire a second commit, which makes the changes effective.\n\nIn MariaDB, XA transactions can only be used with storage engines that support\nthem. At least InnoDB, TokuDB, SPIDER and MyRocks support them. For InnoDB,\nuntil MariaDB 10.2, XA transactions can be disabled by setting the\ninnodb_support_xa server system variable to 0. From MariaDB 10.3, XA\ntransactions are always supported.\n\nLike regular transactions, XA transactions create metadata locks on accessed\ntables.\n\nXA transactions require REPEATABLE READ as a minimum isolation level. However,\ndistributed transactions should always use SERIALIZABLE.\n\nTrying to start more than one XA transaction at the same time produces a 1400\nerror (SQLSTATE \'XAE09\'). The same error is produced when attempting to start\nan XA transaction while a regular transaction is in effect. Trying to start a\nregular transaction while an XA transaction is in effect produces a 1399 error\n(SQLSTATE \'XAE07\').\n\nThe statements that cause an implicit COMMIT for regular transactions produce\na 1400 error (SQLSTATE \'XAE09\') if a XA transaction is in effect.\n\nInternal XA vs External XA\n--------------------------\n\nXA transactions are an overloaded term in MariaDB. If a storage engine is\nXA-capable, it can mean one or both of these:\n\n* It supports MariaDB\'s internal two-phase commit API. This is transparent to\nthe user. Sometimes this is called \"internal XA\", since MariaDB\'s internal\ntransaction coordinator log can handle coordinating these transactions.\n\n* It supports XA transactions, with the XA START, XA PREPARE, XA COMMIT, etc.\nstatements. Sometimes this is called \"external XA\", since it requires the use\nof an external transaction coordinator to use this feature properly.\n\nTransaction Coordinator Log\n---------------------------\n\nIf you have two or more XA-capable storage engines enabled, then a transaction\ncoordinator log must be available.\n\nThere are currently two implementations of the transaction coordinator log:\n\n* Binary log-based transaction coordinator log\n* Memory-mapped file-based transaction coordinator log\n\nIf the binary log is enabled on a server, then the server will use the binary\nlog-based transaction coordinator log. Otherwise, it will use the\nmemory-mapped file-based transaction coordinator log.\n\nSee Transaction Coordinator Log for more information.\n\nSyntax\n------\n\nXA {START|BEGIN} xid [JOIN|RESUME]\n\nXA END xid [SUSPEND [FOR MIGRATE]]\n\nXA PREPARE xid\n\nXA COMMIT xid [ONE PHASE]\n\nXA ROLLBACK xid\n\nXA RECOVER [FORMAT=[\'RAW\'|\'SQL\']]\n\nxid: gtrid [, bqual [, formatID ]]\n\nThe interface to XA transactions is a set of SQL statements starting with XA.\nEach statement changes a transaction\'s state, determining which actions it can\nperform. A transaction which does not exist is in the NON-EXISTING state.\n\nXA START (or BEGIN) starts a transaction and defines its xid (a transaction\nidentifier). The JOIN or RESUME keywords have no effect. The new transaction\nwill be in ACTIVE state.\n\nThe xid can have 3 components, though only the first one is mandatory. gtrid\nis a quoted string representing a global transaction identifier. bqual is a\nquoted string representing a local transaction identifier. formatID is an\nunsigned integer indicating the format used for the first two components; if\nnot specified, defaults to 1. MariaDB does not interpret in any way these\ncomponents, and only uses them to identify a transaction. xids of transactions\nin effect must be unique.\n\nXA END declares that the specified ACTIVE transaction is finished and it\nchanges its state to IDLE. SUSPEND [FOR MIGRATE] has no effect.\n\nXA PREPARE prepares an IDLE transaction for commit, changing its state to\nPREPARED. This is the first commit.\n\nXA COMMIT definitely commits and terminates a transaction which has already\nbeen PREPARED. If the ONE PHASE clause is specified, this statements performs\na 1-phase commit on an IDLE transaction.\n\nXA ROLLBACK rolls back and terminates an IDLE or PREPARED transaction.\n\nXA RECOVER shows information about all PREPARED transactions.\n\nWhen trying to execute an operation which is not allowed for the transaction\'s\ncurrent state, an error is produced:\n\nXA COMMIT \'test\' ONE PHASE;\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  ACTIVE state\n\nXA COMMIT \'test2\';\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  NON-EXISTING state\n\nXA RECOVER\n----------\n\nThe XA RECOVER statement shows information about all transactions which are in\nthe PREPARED state. It does not matter which connection created the\ntransaction: if it has been PREPARED, it appears. But this does not mean that\na connection can commit or rollback a transaction which was started by another\nconnection. Note that transactions using a 1-phase commit are never in the\nPREPARED state, so they cannot be shown by XA RECOVER.\n\nXA RECOVER produces four columns:\n\nXA RECOVER;\n+----------+--------------+--------------+------+\n| formatID | gtrid_length | bqual_length | data |\n+----------+--------------+--------------+------+\n|        1 |            4 |            0 | test |\n+----------+--------------+--------------+------+\n\nMariaDB starting with 10.3.3\n----------------------------\nYou can use XA RECOVER FORMAT=\'SQL\' to get the data in a human readable form\nthat can be directly copy-pasted into XA COMMIT or XA ROLLBACK. This is\nparticularly useful for binary xid generated by some transaction coordinators.\n\nformatID is the formatID part of xid.\n\ndata are the gtrid and bqual parts of xid, concatenated.\n\ngtrid_length and bqual_length are the lengths of gtrid and bqual, respectevely.\n\nExamples\n--------\n\n2-phases commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA PREPARE \'test\';\n\nXA COMMIT \'test\';\n\n1-phase commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA COMMIT \'test\' ONE PHASE;\n\nHuman-readable:\n\nxa start \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\ninsert t1 values (40);\n\nxa end \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa prepare \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa recover format=\'RAW\';\n+----------+--------------+--------------+--------------------+\n| formatID | gtrid_length | bqual_length | data               |\n+----------+--------------+--------------+--------------------+\n34      67v78abc       11 |            7 | 12\ndef |\n+----------+--------------+--------------+--------------------+\n\nxa recover format=\'SQL\';\n+----------+--------------+--------------+-------------------------------------\n---------+\n| formatID | gtrid_length | bqual_length | data                               \n     |\n+----------+--------------+--------------+-------------------------------------\n---------+\n|        3 |           11 |            7 |\nX\'31320d3334093637763738\',X\'6162630a646566\',3 |\n+----------+--------------+--------------+-------------------------------------\n---------+\n\nxa rollback X\'31320d3334093637763738\',X\'6162630a646566\',3;\n\nKnown Issues\n------------\n\nMariaDB Galera Cluster\n----------------------\n\nMariaDB Galera Cluster does not support XA transactions.\n\nHowever, MariaDB Galera Cluster builds include a built-in plugin called wsrep.\nPrior to MariaDB 10.4.3, this plugin was internally considered an XA-capable\nstorage engine. Consequently, these MariaDB Galera Cluster builds have\nmultiple XA-capable storage engines by default, even if the only \"real\"\nstorage engine that supports external XA transactions enabled on these builds\nby default is InnoDB. Therefore, when using one these builds MariaDB would be\nforced to use a transaction coordinator log by default, which could have\nperformance implications.\n\nSee Transaction Coordinator Log Overview: MariaDB Galera Cluster for more\ninformation.\n\nURL: https://mariadb.com/kb/en/xa-transactions/','','https://mariadb.com/kb/en/xa-transactions/'),(104,'CREATE USER',10,'Syntax\n------\n\nCREATE [OR REPLACE] USER [IF NOT EXISTS] \n user_specification [,user_specification ...] \n [REQUIRE {NONE | tls_option [[AND] tls_option ...] }]\n [WITH resource_option [resource_option ...] ]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe CREATE USER statement creates new MariaDB accounts. To use it, you must\nhave the global CREATE USER privilege or the INSERT privilege for the mysql\ndatabase. For each account, CREATE USER creates a new row in mysql.user (until\nMariaDB 10.3 this is a table, from MariaDB 10.4 it\'s a view) or\nmysql.global_priv_table (from MariaDB 10.4) that has no privileges.\n\nIf any of the specified accounts, or any permissions for the specified\naccounts, already exist, then the server returns ERROR 1396 (HY000). If an\nerror occurs, CREATE USER will still create the accounts that do not result in\nan error. Only one error is produced for all users which have not been created:\n\nERROR 1396 (HY000): \n Operation CREATE USER failed for \'u1\'@\'%\',\'u2\'@\'%\'\n\nCREATE USER, DROP USER, CREATE ROLE, and DROP ROLE all produce the same error\ncode when they fail.\n\nSee Account Names below for details on how account names are specified.\n\nOR REPLACE\n----------\n\nIf the optional OR REPLACE clause is used, it is basically a shortcut for:\n\nDROP USER IF EXISTS name;\nCREATE USER name ...;\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE OR REPLACE USER foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected (0.00 sec)\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified user already exists.\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE USER IF NOT EXISTS foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+----------------------------------------------------+\n| Level | Code | Message                                            |\n+-------+------+----------------------------------------------------+\n| Note  | 1973 | Can\'t create user \'foo2\'@\'test\'; it already exists |\n+-------+------+----------------------------------------------------+\n\nAuthentication Options\n----------------------\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored in the\nmysql.user/mysql.global_priv_table table.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nCREATE USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored in the\nmysql.user/mysql.global_priv_table table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nCREATE USER foo2@test IDENTIFIED BY PASSWORD\n\'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nCREATE USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nCREATE USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\') OR\nunix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nCREATE USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to create a user with resource limits:\n\nCREATE USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nAccount Names\n-------------\n\nAccount names have both a user name component and a host name component, and\nare specified as \'user_name\'@\'host_name\'.\n\nThe user name and host name may be unquoted, quoted as strings using double\nquotes (\") or single quotes (\'), or quoted as identifiers using backticks (`).\nYou must use quotes when using special characters (such as a hyphen) or\nwildcard characters. If you quote, you must quote the user name and host name\nseparately (for example \'user_name\'@\'host_name\').\n\nHost Name Component\n-------------------\n\nIf the host name is not provided, it is assumed to be \'%\'.\n\nHost names may contain the wildcard characters % and _. They are matched as if\nby the LIKE clause. If you need to use a wildcard character literally (for\nexample, to match a domain name with an underscore), prefix the character with\na backslash. See LIKE for more information on escaping wildcard characters.\n\nHost name matches are case-insensitive. Host names can match either domain\nnames or IP addresses. Use \'localhost\' as the host name to allow only local\nclient connections.\n\nYou can use a netmask to match a range of IP addresses using \'base_ip/netmask\'\nas the host name. A user with an IP address ip_addr will be allowed to connect\nif the following condition is true:\n\nip_addr & netmask = base_ip\n\nFor example, given a user:\n\nCREATE USER \'maria\'@\'247.150.130.0/255.255.255.0\';\n\nthe IP addresses satisfying this condition range from 247.150.130.0 to\n247.150.130.255.\n\nUsing 255.255.255.255 is equivalent to not using a netmask at all. Netmasks\ncannot be used for IPv6 addresses.\n\nNote that the credentials added when creating a user with the \'%\' wildcard\nhost will not grant access in all cases. For example, some systems come with\nan anonymous localhost user, and when connecting from localhost this will take\nprecedence.\n\nBefore MariaDB 10.6, the host name component could be up to 60 characters in\nlength. Starting from MariaDB 10.6, it can be up to 255 characters.\n\nUser Name Component\n-------------------\n\nUser names must match exactly, including case. A user name that is empty is\nknown as an anonymous account and is allowed to match a login attempt with any\nuser name component. These are described more in the next section.\n\nFor valid identifiers to use as user names, see Identifier Names.\n\nIt is possible for more than one account to match when a user connects.\nMariaDB selects the first matching account after sorting according to the\nfollowing criteria:\n\n* Accounts with an exact host name are sorted before accounts using a wildcard\nin the\nhost name. Host names using a netmask are considered to be exact for sorting.\n* Accounts with a wildcard in the host name are sorted according to the\nposition of\nthe first wildcard character. Those with a wildcard character later in the\nhost name\nsort before those with a wildcard character earlier in the host name.\n* Accounts with a non-empty user name sort before accounts with an empty user\nname.\n* Accounts with an empty user name are sorted last. As mentioned previously,\nthese are known as anonymous accounts. These are described more in the next\nsection.\n\nThe following table shows a list of example account as sorted by these\ncriteria:\n\n+---------+-------------+\n| User    | Host        |\n+---------+-------------+\n| joffrey | 192.168.0.3 |\n|         | 192.168.0.% |\n| joffrey | 192.168.%   |\n|         | 192.168.%   |\n+---------+-------------+\n\nOnce connected, you only have the privileges granted to the account that\nmatched, not all accounts that could have matched. For example, consider the\nfollowing commands:\n\nCREATE USER \'joffrey\'@\'192.168.0.3\';\nCREATE USER \'joffrey\'@\'%\';\nGRANT SELECT ON test.t1 to \'joffrey\'@\'192.168.0.3\';\nGRANT SELECT ON test.t2 to \'joffrey\'@\'%\';\n\nIf you connect as joffrey from 192.168.0.3, you will have the SELECT privilege\non the table test.t1, but not on the table test.t2. If you connect as joffrey\nfrom any other IP address, you will have the SELECT privilege on the table\ntest.t2, but not on the table test.t1.\n\nUsernames can be up to 80 characters long before 10.6 and starting from 10.6\nit can be 128 characters long.\n\nAnonymous Accounts\n------------------\n\nAnonymous accounts are accounts where the user name portion of the account\nname is empty. These accounts act as special catch-all accounts. If a user\nattempts to log into the system from a host, and an anonymous account exists\nwith a host name portion that matches the user\'s host, then the user will log\nin as the anonymous account if there is no more specific account match for the\nuser name that the user entered.\n\nFor example, here are some anonymous accounts:\n\nCREATE USER \'\'@\'localhost\';\nCREATE USER \'\'@\'192.168.0.3\';\n\nFixing a Legacy Default Anonymous Account\n-----------------------------------------\n\nOn some systems, the mysql.db table has some entries for the \'\'@\'%\' anonymous\naccount by default. Unfortunately, there is no matching entry in the\nmysql.user/mysql.global_priv_table table, which means that this anonymous\naccount doesn\'t exactly exist, but it does have privileges--usually on the\ndefault test database created by mysql_install_db. These account-less\nprivileges are a legacy that is leftover from a time when MySQL\'s privilege\nsystem was less advanced.\n\nThis situation means that you will run into errors if you try to create a\n\'\'@\'%\' account. For example:\n\nCREATE USER \'\'@\'%\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'\'@\'%\'\n\nThe fix is to DELETE the row in the mysql.db table and then execute FLUSH\nPRIVILEGES:\n\nDELETE FROM mysql.db WHERE User=\'\' AND Host=\'%\';\nFLUSH PRIVILEGES;\n\nAnd then the account can be created:\n\nCREATE USER \'\'@\'%\';\nQuery OK, 0 rows affected (0.01 sec)\n\nSee MDEV-13486 for more information.\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nCREATE USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/create-user/','','https://mariadb.com/kb/en/create-user/'),(105,'ALTER USER',10,'Syntax\n------\n\nALTER USER [IF EXISTS] \n user_specification [,user_specification] ...\n [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n [WITH resource_option [resource_option] ...]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule] ...\n\nauthentication_rule:\n authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe ALTER USER statement modifies existing MariaDB accounts. To use it, you\nmust have the global CREATE USER privilege or the UPDATE privilege for the\nmysql database. The global SUPER privilege is also required if the read_only\nsystem variable is enabled.\n\nIf any of the specified user accounts do not yet exist, an error results. If\nan error occurs, ALTER USER will still modify the accounts that do not result\nin an error. Only one error is produced for all users which have not been\nmodified.\n\nIF EXISTS\n---------\n\nWhen the IF EXISTS clause is used, MariaDB will return a warning instead of an\nerror for each specified user that does not exist.\n\nAccount Names\n-------------\n\nFor ALTER USER statements, account names are specified as the username\nargument in the same way as they are for CREATE USER statements. See account\nnames from the CREATE USER page for details on how account names are specified.\n\nCURRENT_USER or CURRENT_USER() can also be used to alter the account logged\ninto the current session. For example, to change the current user\'s password\nto mariadb:\n\nALTER USER CURRENT_USER() IDENTIFIED BY \'mariadb\';\n\nAuthentication Options\n----------------------\n\nMariaDB starting with 10.4\n--------------------------\nFrom MariaDB 10.4, it is possible to use more than one authentication plugin\nfor each user account. For example, this can be useful to slowly migrate users\nto the more secure ed25519 authentication plugin over time, while allowing the\nold mysql_native_password authentication plugin as an alternative for the\ntransitional period. See Authentication from MariaDB 10.4 for more.\n\nWhen running ALTER USER, not specifying an authentication option in the\nIDENTIFIED VIA clause will remove that authentication method. (However this\nwas not the case before MariaDB 10.4.13, see MDEV-21928)\n\nFor example, a user is created with the ability to authenticate via both a\npassword and unix_socket:\n\nCREATE USER \'bob\'@\'localhost\' \n IDENTIFIED VIA mysql_native_password USING PASSWORD(\'pwd\')\n OR unix_socket;\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED VIA mysql_native_password\n USING \'*975B2CD4FF9AE554FE8AD33168FBFC326D2021DD\'\n OR unix_socket\n\nIf the user\'s password is updated, but unix_socket authentication is not\nspecified in the IDENTIFIED VIA clause, unix_socket authentication will no\nlonger be permitted.\n\nALTER USER \'bob\'@\'localhost\' IDENTIFIED VIA mysql_native_password \n USING PASSWORD(\'pwd2\');\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED BY PASSWORD \'*38366FDA01695B6A5A9DD4E428D9FB8F7EB75512\'\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored to the mysql.user table.\n\nFor example, if our password is mariadb, then we can set the account\'s\npassword with:\n\nALTER USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD#function. It will be stored to the\nmysql.user table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n\nAnd then we can set an account\'s password with the hash:\n\nALTER USER foo2@test \n IDENTIFIED BY PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nALTER USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nALTER USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nIn MariaDB 10.4 and later, the USING or AS keyword can also be used to provide\na plain-text password to a plugin if it\'s provided as an argument to the\nPASSWORD() function. This is only valid for authentication plugins that have\nimplemented a hook for the PASSWORD() function. For example, the ed25519\nauthentication plugin supports this:\n\nALTER USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can alter a user account to require these TLS options with\nthe following:\n\nALTER USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\' AND\n ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+------------------------------------+---------------------------------------+\n| Limit Type                         | Description                           |\n+------------------------------------+---------------------------------------+\n| MAX_QUERIES_PER_HOUR               | Number of statements that the         |\n|                                    | account can issue per hour            |\n|                                    | (including updates)                   |\n+------------------------------------+---------------------------------------+\n| MAX_UPDATES_PER_HOUR               | Number of updates (not queries) that  |\n|                                    | the account can issue per hour        |\n+------------------------------------+---------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR           | Number of connections that the        |\n|                                    | account can start per hour            |\n+------------------------------------+---------------------------------------+\n| MAX_USER_CONNECTIONS               | Number of simultaneous connections    |\n|                                    | that can be accepted from the same    |\n|                                    | account; if it is 0, max_connections  |\n|                                    | will be used instead; if              |\n|                                    | max_connections is 0, there is no     |\n|                                    | limit for this account\'s              |\n|                                    | simultaneous connections.             |\n+------------------------------------+---------------------------------------+\n| MAX_STATEMENT_TIME                 | Timeout, in seconds, for statements   |\n|                                    | executed by the user. See also        |\n|                                    | Aborting Statements that Exceed a     |\n|                                    | Certain Time to Execute.              |\n+------------------------------------+---------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to set an account\'s resource limits:\n\nALTER USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nALTER USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/alter-user/','','https://mariadb.com/kb/en/alter-user/'),(107,'GRANT',10,'Syntax\n------\n\nGRANT\n  priv_type [(column_list)]\n   [, priv_type [(column_list)]] ...\n  ON [object_type] priv_level\n  TO user_specification [ user_options ...]\n\nuser_specification:\n username [authentication_option]\n | PUBLIC\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\nGRANT PROXY ON username\n  TO user_specification [, user_specification ...]\n  [WITH GRANT OPTION]\n\nGRANT rolename TO grantee [, grantee ...]\n  [WITH ADMIN OPTION]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nuser_options:\n  [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n  [WITH with_option [with_option] ...]\n\nobject_type:\n  TABLE\n | FUNCTION\n | PROCEDURE\n | PACKAGE\n\npriv_level:\n  *\n | *.*\n | db_name.*\n | db_name.tbl_name\n | tbl_name\n | db_name.routine_name\n\nwith_option:\n  GRANT OPTION\n | resource_option\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nDescription\n-----------\n\nThe GRANT statement allows you to grant privileges or roles to accounts. To\nuse GRANT, you must have the GRANT OPTION privilege, and you must have the\nprivileges that you are granting.\n\nUse the REVOKE statement to revoke privileges granted with the GRANT statement.\n\nUse the SHOW GRANTS statement to determine what privileges an account has.\n\nAccount Names\n-------------\n\nFor GRANT statements, account names are specified as the username argument in\nthe same way as they are for CREATE USER statements. See account names from\nthe CREATE USER page for details on how account names are specified.\n\nImplicit Account Creation\n-------------------------\n\nThe GRANT statement also allows you to implicitly create accounts in some\ncases.\n\nIf the account does not yet exist, then GRANT can implicitly create it. To\nimplicitly create an account with GRANT, a user is required to have the same\nprivileges that would be required to explicitly create the account with the\nCREATE USER statement.\n\nIf the NO_AUTO_CREATE_USER SQL_MODE is set, then accounts can only be created\nif authentication information is specified, or with a CREATE USER statement.\nIf no authentication information is provided, GRANT will produce an error when\nthe specified account does not exist, for example:\n\nshow variables like \'%sql_mode%\' ;\n+---------------+--------------------------------------------+\n| Variable_name | Value                                      |\n+---------------+--------------------------------------------+\n| sql_mode      | NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n+---------------+--------------------------------------------+\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' IDENTIFIED BY \'\';\nERROR 1133 (28000): Can\'t find any matching row in the user table\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' \n IDENTIFIED VIA PAM using \'mariadb\' require ssl ;\nQuery OK, 0 rows affected (0.00 sec)\n\nselect host, user from mysql.user where user=\'user123\' ;\n\n+------+----------+\n| host | user     |\n+------+----------+\n| %    | user123 |\n+------+----------+\n\nPrivilege Levels\n----------------\n\nPrivileges can be set globally, for an entire database, for a table or\nroutine, or for individual columns in a table. Certain privileges can only be\nset at certain levels.\n\n* Global privileges priv_type are granted using *.* for\npriv_level. Global privileges include privileges to administer the database\nand manage user accounts, as well as privileges for all tables, functions, and\nprocedures. Global privileges are stored in the mysql.user table prior to\nMariaDB 10.4, and in  mysql.global_priv table afterwards.\n* Database privileges priv_type are granted using db_name.*\nfor priv_level, or using just * to use default database. Database\nprivileges include privileges to create tables and functions, as well as\nprivileges for all tables, functions, and procedures in the database. Database\nprivileges are stored in the mysql.db table.\n* Table privileges priv_type are granted using db_name.tbl_name\nfor priv_level, or using just tbl_name to specify a table in the default\ndatabase. The TABLE keyword is optional. Table privileges include the\nability to select and change data in the table. Certain table privileges can\nbe granted for individual columns.\n* Column privileges priv_type are granted by specifying a table for\npriv_level and providing a column list after the privilege type. They allow\nyou to control exactly which columns in a table users can select and change.\n* Function privileges priv_type are granted using FUNCTION db_name.routine_name\nfor priv_level, or using just  FUNCTION routine_name to specify a function\nin the default database.\n* Procedure privileges priv_type are granted using PROCEDURE\ndb_name.routine_name\nfor priv_level, or using just PROCEDURE routine_name to specify a procedure\nin the default database.\n\nThe USAGE Privilege\n-------------------\n\nThe USAGE privilege grants no real privileges. The SHOW GRANTS statement will\nshow a global USAGE privilege for a newly-created user. You can use USAGE with\nthe GRANT statement to change options like GRANT OPTION and\nMAX_USER_CONNECTIONS without changing any account privileges.\n\nThe ALL PRIVILEGES Privilege\n----------------------------\n\nThe ALL PRIVILEGES privilege grants all available privileges. Granting all\nprivileges only affects the given privilege level. For example, granting all\nprivileges on a table does not grant any privileges on the database or\nglobally.\n\nUsing ALL PRIVILEGES does not grant the special GRANT OPTION privilege.\n\nYou can use ALL instead of ALL PRIVILEGES.\n\nThe GRANT OPTION Privilege\n--------------------------\n\nUse the WITH GRANT OPTION clause to give users the ability to grant privileges\nto other users at the given privilege level. Users with the GRANT OPTION\nprivilege can only grant privileges they have. They cannot grant privileges at\na higher privilege level than they have the GRANT OPTION privilege.\n\nThe GRANT OPTION privilege cannot be set for individual columns. If you use\nWITH GRANT OPTION when specifying column privileges, the GRANT OPTION\nprivilege will be granted for the entire table.\n\nUsing the WITH GRANT OPTION clause is equivalent to listing GRANT OPTION as a\nprivilege.\n\nGlobal Privileges\n-----------------\n\nThe following table lists the privileges that can be granted globally. You can\nalso grant all database, table, and function privileges globally. When granted\nglobally, these privileges apply to all databases, tables, or functions,\nincluding those created later.\n\nTo set a global privilege, use *.* for priv_level.\n\nBINLOG ADMIN\n------------\n\nEnables administration of the binary log, including the PURGE BINARY LOGS\nstatement and setting the system variables:\n\n* binlog_annotate_row_events\n* binlog_cache_size\n* binlog_commit_wait_count\n* binlog_commit_wait_usec\n* binlog_direct_non_transactional_updates\n* binlog_expire_logs_seconds\n* binlog_file_cache_size\n* binlog_format\n* binlog_row_image\n* binlog_row_metadata\n* binlog_stmt_cache_size\n* expire_logs_days\n* log_bin_compress\n* log_bin_compress_min_len\n* log_bin_trust_function_creators\n* max_binlog_cache_size\n* max_binlog_size\n* max_binlog_stmt_cache_size\n* sql_log_bin and\n* sync_binlog.\n\nAdded in MariaDB 10.5.2.\n\nBINLOG MONITOR\n--------------\n\nNew name for REPLICATION CLIENT from MariaDB 10.5.2, (REPLICATION CLIENT still\nsupported as an alias for compatibility purposes). Permits running SHOW\ncommands related to the binary log, in particular the SHOW BINLOG STATUS and\nSHOW BINARY LOGS statements. Unlike REPLICATION CLIENT prior to MariaDB 10.5,\nSHOW REPLICA STATUS isn\'t included in this privilege, and REPLICA MONITOR is\nrequired.\n\nBINLOG REPLAY\n-------------\n\nEnables replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), executing SET timestamp when secure_timestamp is set to\nreplication, and setting the session values of system variables usually\nincluded in BINLOG output, in particular:\n\n* gtid_domain_id\n* gtid_seq_no\n* pseudo_thread_id\n* server_id.\n\nAdded in MariaDB 10.5.2\n\nCONNECTION ADMIN\n----------------\n\nEnables administering connection resource limit options. This includes\nignoring the limits specified by:\n\n* max_connections\n* max_user_connections and\n* max_password_errors.\n\nThe statements specified in init_connect are not executed, killing connections\nand queries owned by other users is permitted. The following\nconnection-related system variables can be changed:\n\n* connect_timeout\n* disconnect_on_expired_password\n* extra_max_connections\n* init_connect\n* max_connections\n* max_connect_errors\n* max_password_errors\n* proxy_protocol_networks\n* secure_auth\n* slow_launch_time\n* thread_pool_exact_stats\n* thread_pool_dedicated_listener\n* thread_pool_idle_timeout\n* thread_pool_max_threads\n* thread_pool_min_threads\n* thread_pool_oversubscribe\n* thread_pool_prio_kickup_timer\n* thread_pool_priority\n* thread_pool_size, and\n* thread_pool_stall_limit.\n\nAdded in MariaDB 10.5.2.\n\nCREATE USER\n-----------\n\nCreate a user using the CREATE USER statement, or implicitly create a user\nwith the GRANT statement.\n\nFEDERATED ADMIN\n---------------\n\nExecute CREATE SERVER, ALTER SERVER, and DROP SERVER statements. Added in\nMariaDB 10.5.2.\n\nFILE\n----\n\nRead and write files on the server, using statements like LOAD DATA INFILE or\nfunctions like LOAD_FILE(). Also needed to create CONNECT outward tables.\nMariaDB server must have the permissions to access those files.\n\nGRANT OPTION\n------------\n\nGrant global privileges. You can only grant privileges that you have.\n\nPROCESS\n-------\n\nShow information about the active processes, for example via SHOW PROCESSLIST\nor mysqladmin processlist. If you have the PROCESS privilege, you can see all\nthreads. Otherwise, you can see only your own threads (that is, threads\nassociated with the MariaDB account that you are using).\n\nREAD_ONLY ADMIN\n---------------\n\nUser can set the read_only system variable and allows the user to perform\nwrite operations, even when the read_only option is active. Added in MariaDB\n10.5.2.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nRELOAD\n------\n\nExecute FLUSH statements or equivalent mariadb-admin/mysqladmin commands.\n\nREPLICATION CLIENT\n------------------\n\nExecute SHOW MASTER STATUS and SHOW BINARY LOGS informative statements.\nRenamed to BINLOG MONITOR in MariaDB 10.5.2 (but still supported as an alias\nfor compatibility reasons). SHOW SLAVE STATUS was part of REPLICATION CLIENT\nprior to MariaDB 10.5.\n\nREPLICATION MASTER ADMIN\n------------------------\n\nPermits administration of primary servers, including the SHOW REPLICA HOSTS\nstatement, and setting the gtid_binlog_state, gtid_domain_id,\nmaster_verify_checksum and server_id system variables. Added in MariaDB 10.5.2.\n\nREPLICA MONITOR\n---------------\n\nPermit SHOW REPLICA STATUS and SHOW RELAYLOG EVENTS. From MariaDB 10.5.9.\n\nWhen a user would upgrade from an older major release to a MariaDB 10.5 minor\nrelease prior to MariaDB 10.5.9, certain user accounts would lose\ncapabilities. For example, a user account that had the REPLICATION CLIENT\nprivilege in older major releases could run SHOW REPLICA STATUS, but after\nupgrading to a MariaDB 10.5 minor release prior to MariaDB 10.5.9, they could\nno longer run SHOW REPLICA STATUS, because that statement was changed to\nrequire the REPLICATION REPLICA ADMIN privilege.\n\nThis issue is fixed in MariaDB 10.5.9 with this new privilege, which now\ngrants the user the ability to execute SHOW [ALL] (SLAVE | REPLICA) STATUS.\n\nWhen a database is upgraded from an older major release to MariaDB Server\n10.5.9 or later, any user accounts with the REPLICATION CLIENT or REPLICATION\nSLAVE privileges will automatically be granted the new REPLICA MONITOR\nprivilege. The privilege fix occurs when the server is started up, not when\nmariadb-upgrade is performed.\n\nHowever, when a database is upgraded from an early 10.5 minor release to\n10.5.9 and later, the user will have to fix any user account privileges\nmanually.\n\nREPLICATION REPLICA\n-------------------\n\nSynonym for REPLICATION SLAVE. From MariaDB 10.5.1.\n\nREPLICATION SLAVE\n-----------------\n\nAccounts used by replica servers on the primary need this privilege. This is\nneeded to get the updates made on the master. From MariaDB 10.5.1, REPLICATION\nREPLICA is an alias for REPLICATION SLAVE.\n\nREPLICATION SLAVE ADMIN\n-----------------------\n\nPermits administering replica servers, including START REPLICA/SLAVE, STOP\nREPLICA/SLAVE, CHANGE MASTER, SHOW REPLICA/SLAVE STATUS, SHOW RELAYLOG EVENTS\nstatements, replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), and setting the system variables:\n\n* gtid_cleanup_batch_size\n* gtid_ignore_duplicates\n* gtid_pos_auto_engines\n* gtid_slave_pos\n* gtid_strict_mode\n* init_slave\n* read_binlog_speed_limit\n* relay_log_purge\n* relay_log_recovery\n* replicate_do_db\n* replicate_do_table\n* replicate_events_marked_for_skip\n* replicate_ignore_db\n* replicate_ignore_table\n* replicate_wild_do_table\n* replicate_wild_ignore_table\n* slave_compressed_protocol\n* slave_ddl_exec_mode\n* slave_domain_parallel_threads\n* slave_exec_mode\n* slave_max_allowed_packet\n* slave_net_timeout\n* slave_parallel_max_queued\n* slave_parallel_mode\n* slave_parallel_threads\n* slave_parallel_workers\n* slave_run_triggers_for_rbr\n* slave_sql_verify_checksum\n* slave_transaction_retry_interval\n* slave_type_conversions\n* sync_master_info\n* sync_relay_log, and\n* sync_relay_log_info.\n\nAdded in MariaDB 10.5.2.\n\nSET USER\n--------\n\nEnables setting the DEFINER when creating triggers, views, stored functions\nand stored procedures. Added in MariaDB 10.5.2.\n\nSHOW DATABASES\n--------------\n\nList all databases using the SHOW DATABASES statement. Without the SHOW\nDATABASES privilege, you can still issue the SHOW DATABASES statement, but it\nwill only list databases containing tables on which you have privileges.\n\nSHUTDOWN\n--------\n\nShut down the server using SHUTDOWN or the mysqladmin shutdown command.\n\nSUPER\n-----\n\nExecute superuser statements: CHANGE MASTER TO, KILL (users who do not have\nthis privilege can only KILL their own threads), PURGE LOGS, SET global system\nvariables, or the mysqladmin debug command. Also, this permission allows the\nuser to write data even if the read_only startup option is set, enable or\ndisable logging, enable or disable replication on replica, specify a DEFINER\nfor statements that support that clause, connect once reaching the\nMAX_CONNECTIONS. If a statement has been specified for the init-connect mysqld\noption, that command will not be executed when a user with SUPER privileges\nconnects to the server.\n\nThe SUPER privilege has been split into multiple smaller privileges from\nMariaDB 10.5.2 to allow for more fine-grained privileges, although it remains\nan alias for these smaller privileges.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nDatabase Privileges\n-------------------\n\nThe following table lists the privileges that can be granted at the database\nlevel. You can also grant all table and function privileges at the database\nlevel. Table and function privileges on a database apply to all tables or\nfunctions in that database, including those created later.\n\nTo set a privilege for a database, specify the database using db_name.* for\npriv_level, or just use * to specify the default database.\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a database using the CREATE      |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. You can      |\n|                                  | grant the CREATE privilege on           |\n|                                  | databases that do not yet exist. This   |\n|                                  | also grants the CREATE privilege on     |\n|                                  | all tables in the database.             |\n+----------------------------------+-----------------------------------------+\n| CREATE ROUTINE                   | Create Stored Programs using the        |\n|                                  | CREATE PROCEDURE and CREATE FUNCTION    |\n|                                  | statements.                             |\n+----------------------------------+-----------------------------------------+\n| CREATE TEMPORARY TABLES          | Create temporary tables with the        |\n|                                  | CREATE TEMPORARY TABLE statement. This  |\n|                                  | privilege enable writing and dropping   |\n|                                  | those temporary tables                  |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a database using the DROP          |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. This also    |\n|                                  | grants the DROP privilege on all        |\n|                                  | tables in the database.                 |\n+----------------------------------+-----------------------------------------+\n| EVENT                            | Create, drop and alter EVENTs.          |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant database privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n| LOCK TABLES                      | Acquire explicit locks using the LOCK   |\n|                                  | TABLES statement; you also need to      |\n|                                  | have the SELECT privilege on a table,   |\n|                                  | in order to lock it.                    |\n+----------------------------------+-----------------------------------------+\n\nTable Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER                            | Change the structure of an existing     |\n|                                  | table using the ALTER TABLE statement.  |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a table using the CREATE TABLE   |\n|                                  | statement.  You can grant the CREATE    |\n|                                  | privilege on tables that do not yet     |\n|                                  | exist.                                  |\n+----------------------------------+-----------------------------------------+\n| CREATE VIEW                      | Create a view using the CREATE_VIEW     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| DELETE                           | Remove rows from a table using the      |\n|                                  | DELETE statement.                       |\n+----------------------------------+-----------------------------------------+\n| DELETE HISTORY                   | Remove historical rows from a table     |\n|                                  | using the DELETE HISTORY statement.     |\n|                                  | Displays as DELETE VERSIONING ROWS      |\n|                                  | when running SHOW GRANTS until MariaDB  |\n|                                  | 10.3.15 and until MariaDB 10.4.5        |\n|                                  | (MDEV-17655), or when running SHOW      |\n|                                  | PRIVILEGES until MariaDB 10.5.2,        |\n|                                  | MariaDB 10.4.13 and MariaDB 10.3.23     |\n|                                  | (MDEV-20382). From MariaDB 10.3.4.      |\n|                                  | From MariaDB 10.3.5, if a user has the  |\n|                                  | SUPER privilege but not this            |\n|                                  | privilege, running mysql_upgrade will   |\n|                                  | grant this privilege as well.           |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a table using the DROP TABLE       |\n|                                  | statement or a view using the DROP      |\n|                                  | VIEW statement. Also required to        |\n|                                  | execute the TRUNCATE TABLE statement.   |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant table privileges. You can only    |\n|                                  | grant privileges that you have.         |\n+----------------------------------+-----------------------------------------+\n| INDEX                            | Create an index on a table using the    |\n|                                  | CREATE INDEX statement. Without the     |\n|                                  | INDEX privilege, you can still create   |\n|                                  | indexes when creating a table using     |\n|                                  | the CREATE TABLE statement if the you   |\n|                                  | have the CREATE privilege, and you can  |\n|                                  | create indexes using the ALTER TABLE    |\n|                                  | statement if you have the ALTER         |\n|                                  | privilege.                              |\n+----------------------------------+-----------------------------------------+\n| INSERT                           | Add rows to a table using the INSERT    |\n|                                  | statement.  The INSERT privilege can    |\n|                                  | also be set on individual columns; see  |\n|                                  | Column Privileges below for details.    |\n+----------------------------------+-----------------------------------------+\n| REFERENCES                       | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT                           | Read data from a table using the        |\n|                                  | SELECT statement. The SELECT privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n| SHOW VIEW                        | Show the CREATE VIEW statement to       |\n|                                  | create a view using the SHOW CREATE     |\n|                                  | VIEW statement.                         |\n+----------------------------------+-----------------------------------------+\n| TRIGGER                          | Execute triggers associated to tables   |\n|                                  | you update, execute the CREATE TRIGGER  |\n|                                  | and DROP TRIGGER statements. You will   |\n|                                  | still be able to see triggers.          |\n+----------------------------------+-----------------------------------------+\n| UPDATE                           | Update existing rows in a table using   |\n|                                  | the UPDATE statement. UPDATE            |\n|                                  | statements usually include a WHERE      |\n|                                  | clause to update only certain rows.     |\n|                                  | You must have SELECT privileges on the  |\n|                                  | table or the appropriate columns for    |\n|                                  | the WHERE clause. The UPDATE privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n\nColumn Privileges\n-----------------\n\nSome table privileges can be set for individual columns of a table. To use\ncolumn privileges, specify the table explicitly and provide a list of column\nnames after the privilege type. For example, the following statement would\nallow the user to read the names and positions of employees, but not other\ninformation from the same table, such as salaries.\n\nGRANT SELECT (name, position) on Employee to \'jeffrey\'@\'localhost\';\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| INSERT (column_list)             | Add rows specifying values in columns   |\n|                                  | using the INSERT statement. If you      |\n|                                  | only have column-level INSERT           |\n|                                  | privileges, you must specify the        |\n|                                  | columns you are setting in the INSERT   |\n|                                  | statement. All other columns will be    |\n|                                  | set to their default values, or NULL.   |\n+----------------------------------+-----------------------------------------+\n| REFERENCES (column_list)         | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT (column_list)             | Read values in columns using the        |\n|                                  | SELECT statement. You cannot access or  |\n|                                  | query any columns for which you do not  |\n|                                  | have SELECT privileges, including in    |\n|                                  | WHERE, ON, GROUP BY, and ORDER BY       |\n|                                  | clauses.                                |\n+----------------------------------+-----------------------------------------+\n| UPDATE (column_list)             | Update values in columns of existing    |\n|                                  | rows using the UPDATE statement.        |\n|                                  | UPDATE statements usually include a     |\n|                                  | WHERE clause to update only certain     |\n|                                  | rows. You must have SELECT privileges   |\n|                                  | on the table or the appropriate         |\n|                                  | columns for the WHERE clause.           |\n+----------------------------------+-----------------------------------------+\n\nFunction Privileges\n-------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | function using the ALTER FUNCTION       |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Use a stored function. You need SELECT  |\n|                                  | privileges for any tables or columns    |\n|                                  | accessed by the function.               |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant function privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nProcedure Privileges\n--------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | procedure using the ALTER PROCEDURE     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Execute a stored procedure using the    |\n|                                  | CALL statement. The privilege to call   |\n|                                  | a procedure may allow you to perform    |\n|                                  | actions you wouldn\'t otherwise be able  |\n|                                  | to do, such as insert rows into a       |\n|                                  | table.                                  |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant procedure privileges. You can     |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nGRANT EXECUTE ON PROCEDURE mysql.create_db TO maintainer;\n\nProxy Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| PROXY                            | Permits one user to be a proxy for      |\n|                                  | another.                                |\n+----------------------------------+-----------------------------------------+\n\nThe PROXY privilege allows one user to proxy as another user, which means\ntheir privileges change to that of the proxy user, and the CURRENT_USER()\nfunction returns the user name of the proxy user.\n\nThe PROXY privilege only works with authentication plugins that support it.\nThe default mysql_native_password authentication plugin does not support proxy\nusers.\n\nThe pam authentication plugin is the only plugin included with MariaDB that\ncurrently supports proxy users. The PROXY privilege is commonly used with the\npam authentication plugin to enable user and group mapping with PAM.\n\nFor example, to grant the PROXY privilege to an anonymous account that\nauthenticates with the pam authentication plugin, you could execute the\nfollowing:\n\nCREATE USER \'dba\'@\'%\' IDENTIFIED BY \'strongpassword\';\nGRANT ALL PRIVILEGES ON *.* TO \'dba\'@\'%\' ;\n\nCREATE USER \'\'@\'%\' IDENTIFIED VIA pam USING \'mariadb\';\nGRANT PROXY ON \'dba\'@\'%\' TO \'\'@\'%\';\n\nA user account can only grant the PROXY privilege for a specific user account\nif the granter also has the PROXY privilege for that specific user account,\nand if that privilege is defined WITH GRANT OPTION. For example, the following\nexample fails because the granter does not have the PROXY privilege for that\nspecific user account at all:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nAnd the following example fails because the granter does have the PROXY\nprivilege for that specific user account, but it is not defined WITH GRANT\nOPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\'                     \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nBut the following example succeeds because the granter does have the PROXY\nprivilege for that specific user account, and it is defined WITH GRANT OPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\' WITH GRANT OPTION   \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\n\nA user account can grant the PROXY privilege for any other user account if the\ngranter has the PROXY privilege for the \'\'@\'%\' anonymous user account, like\nthis:\n\nGRANT PROXY ON \'\'@\'%\' TO \'dba\'@\'localhost\' WITH GRANT OPTION;\n\nFor example, the following example succeeds because the user can grant the\nPROXY privilege for any other user account:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'\'@\'%\' TO \'alice\'@\'localhost\' WITH GRANT OPTION              \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'app1_dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nGRANT PROXY ON \'app2_dba\'@\'localhost\' TO \'carol\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nThe default root user accounts created by mysql_install_db have this\nprivilege. For example:\n\nGRANT ALL PRIVILEGES ON *.* TO \'root\'@\'localhost\' WITH GRANT OPTION;\nGRANT PROXY ON \'\'@\'%\' TO \'root\'@\'localhost\' WITH GRANT OPTION;\n\nThis allows the default root user accounts to grant the PROXY privilege for\nany other user account, and it also allows the default root user accounts to\ngrant others the privilege to do the same.\n\nAuthentication Options\n----------------------\n\nThe authentication options for the GRANT statement are the same as those for\nthe CREATE USER statement.\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \n PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\') OR unix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nTo set resource limits for an account, if you do not want to change that\naccount\'s privileges, you can issue a GRANT statement with the USAGE\nprivilege, which has no meaning. The statement can name some or all limit\ntypes, in any order.\n\nHere is an example showing how to set resource limits:\n\nGRANT USAGE ON *.* TO \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 0\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nUsers with the CONNECTION ADMIN privilege (in MariaDB 10.5.2 and later) or the\nSUPER privilege are not restricted by max_user_connections, max_connections,\nor max_password_errors.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nGRANT USAGE ON *.* TO \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nRoles\n-----\n\nSyntax\n------\n\nGRANT role TO grantee [, grantee ... ]\n[ WITH ADMIN OPTION ]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nThe GRANT statement is also used to grant the use of a role to one or more\nusers or other roles. In order to be able to grant a role, the grantor doing\nso must have permission to do so (see WITH ADMIN in the CREATE ROLE article).\n\nSpecifying the WITH ADMIN OPTION permits the grantee to in turn grant the role\nto another.\n\nFor example, the following commands show how to grant the same role to a\ncouple different users.\n\nGRANT journalist TO hulda;\n\nGRANT journalist TO berengar WITH ADMIN OPTION;\n\nIf a user has been granted a role, they do not automatically obtain all\npermissions associated with that role. These permissions are only in use when\nthe user activates the role with the SET ROLE statement.\n\nTO PUBLIC\n---------\n\nMariaDB starting with 10.11\n---------------------------\n\nSyntax\n------\n\nGRANT <privilege> ON <database>.<object> TO PUBLIC;\nREVOKE <privilege> ON <database>.<object> FROM PUBLIC;\n\nGRANT ... TO PUBLIC grants privileges to all users with access to the server.\nThe privileges also apply to users created after the privileges are granted.\nThis can be useful when one only wants to state once that all users need to\nhave a certain set of privileges.\n\nWhen running SHOW GRANTS, a user will also see all privileges inherited from\nPUBLIC. SHOW GRANTS FOR PUBLIC will only show TO PUBLIC grants.\n\nGrant Examples\n--------------\n\nGranting Root-like Privileges\n-----------------------------\n\nYou can create a user that has privileges similar to the default root accounts\nby executing the following:\n\nCREATE USER \'alexander\'@\'localhost\';\nGRANT ALL PRIVILEGES ON  *.* to \'alexander\'@\'localhost\' WITH GRANT OPTION;\n\nURL: https://mariadb.com/kb/en/grant/','','https://mariadb.com/kb/en/grant/'),(117,'Authentication from MariaDB 10.4',10,'MariaDB starting with 10.4\n--------------------------\nMariaDB 10.4 introduced a number of changes to the authentication process,\nintended to make things easier and more intuitive.\n\nOverview\n--------\n\nThere are four new main features in 10.4 relating to authentication:\n\n* It is possible to use more than one authentication plugin for each user\naccount. For example, this can be useful to slowly migrate users to the more\nsecure ed25519 authentication plugin over time, while allowing the old\nmysql_native_password authentication plugin as an alternative for the\ntransitional period.\n* The root@localhost user account created by mysql_install_db is created with\nthe ability to use two authentication plugins.\nFirst, it is configured to try to use the unix_socket authentication plugin.\nThis allows the root@localhost user to login without a password via the local\nUnix socket file defined by the socket system variable, as long as the login\nis attempted from a process owned by the operating system root user account.\nSecond, if authentication fails with the unix_socket authentication plugin,\nthen it is configured to try to use the mysql_native_password authentication\nplugin. However, an invalid password is initially set, so in order to\nauthenticate this way, a password must be set with SET PASSWORD.\nHowever, just using the unix_socket authentication plugin may be fine for many\nusers, and it is very secure. You may want to try going without password\nauthentication to see how well it works for you. Remember, the best way to\nkeep your password safe is not to have one!\n\n* All user accounts, passwords, and global privileges are now stored in the\nmysql.global_priv table. The mysql.user table still exists and has exactly the\nsame set of columns as before, but it’s now a view that references the\nmysql.global_priv table. Tools that analyze the mysql.user table should\ncontinue to work as before. From MariaDB 10.4.13, the dedicated mariadb.sys\nuser is created as the definer of this view. Previously root was the definer,\nwhich resulted in privilege problems when this username was changed.\n* MariaDB 10.4 adds supports for User Password Expiry, which is not active by\ndefault.\n\nDescription\n-----------\n\nAs a result of the above changes, the open-for-everyone all-powerful root\naccount is finally gone. And installation scripts will no longer demand that\nyou \"PLEASE REMEMBER TO SET A PASSWORD FOR THE MariaDB root USER !\", because\nthe root account is securely created automatically.\n\nTwo all-powerful accounts are created by default — root and the OS user that\nowns the data directory, typically mysql. They are created as:\n\nCREATE USER root@localhost IDENTIFIED VIA unix_socket OR mysql_native_password\nUSING \'invalid\'\nCREATE USER mysql@localhost IDENTIFIED VIA unix_socket OR\nmysql_native_password USING \'invalid\'\n\nUsing unix_socket means that if you are the system root user, you can login as\nroot@locahost without a password. This technique was pioneered by Otto\nKekäläinen in Debian MariaDB packages and has been successfully used in Debian\nsince as early as MariaDB 10.0.\n\nIt is based on a simple fact that asking the system root for a password adds\nno extra security — root has full access to all the data files and all process\nmemory anyway. But not asking for a password means, there is no root password\nto forget (no need for the numerous tutorials on \"how to reset MariaDB root\npassword\"). And if you want to script some tedious database work, there is no\nneed to store the root password in plain text for the script to use (no need\nfor debian-sys-maint user).\n\nStill, some users may wish to log in as MariaDB root without using sudo. Hence\nthe old authentication method — conventional MariaDB password — is still\navailable. By default it is disabled (\"invalid\" is not a valid password hash),\nbut one can set the password with a usual SET PASSWORD statement. And still\nretain the password-less access via sudo.\n\nIf you install MariaDB locally (say from a tarball), you would not want to use\nsudo to be able to login. This is why MariaDB creates a second all-powerful\nuser with the same name as a system user that owns the data directory. In\nlocal (not system-wide) installations, this will be the user who installed\nMariaDB — they automatically get convenient password-less root-like access,\nbecause they can access all the data files anyway.\n\nEven if MariaDB is installed system-wide, you may not want to run your\ndatabase maintenance scripts as system root — now you can run them as system\nmysql user. And you will know that they will never destroy your entire system,\neven if you make a typo in a shell script.\n\nHowever, seasoned MariaDB DBAs who are used to the old ways do need to make\nsome changes. See the examples below for common tasks.\n\nCookbook\n--------\n\nAfter installing MariaDB system-wide the first thing you’ve got used to doing\nis logging in into the unprotected root account and protecting it, that is,\nsetting the root password:\n\n$ sudo dnf install MariaDB-server\n$ mysql -uroot\n...\nMariaDB> set password = password(\"XH4VmT3_jt\");\n\nThis is not only unnecessary now, it will simply not work — there is no\nunprotected root account. To login as root use\n\n$ sudo dnf install MariaDB-server\n$ sudo mysql\n\nNote that it implies you are connecting via the unix socket, not tcp. If you\nhappen to have protocol=tcp in a system-wide /etc/my.cnf file, use sudo mysql\n--protocol=socket.\n\nAfter installing MariaDB locally you’ve also used to connect to the\nunprotected root account using mysql -uroot. This will not work either, simply\nuse mysql without specifying a username.\n\nIf you\'ve forgotten your root password, no problem — you can still connect\nusing sudo and change the password. And if you\'ve also removed unix_socket\nauthentication, to restore access do as follows:\n\n* restart MariaDB with --skip-grant-tables\n* login into the unprotected server\n* run FLUSH PRIVILEGES (note, before 10.4 this would’ve been the last step,\nnot anymore). This disables --skip-grant-tables and allows you to change the\nstored authentication method\n* run SET PASSWORD FOR root@localhost to change the root password.\n\nTo view inside privilege tables, the old mysql.user table still exists. You\ncan select from it as before, although you cannot update it anymore. It\ndoesn’t show alternative authentication plugins and this was one of the\nreasons for switching to the mysql.global_priv table — complex authentication\nrules did not fit into rigid structure of a relational table. You can select\nfrom the new table, for example:\n\nselect concat(user, \'@\', host, \' => \', json_detailed(priv)) from\nmysql.global_priv;\n\nReverting to the Previous Authentication Method for root@localhost\n------------------------------------------------------------------\n\nIf you don\'t want the root@localhost user account created by mysql_install_db\nto use unix_socket authentication by default, then there are a few ways to\nrevert to the previous mysql_native_password authentication method for this\nuser account.\n\nConfiguring mysql_install_db to Revert to the Previous Authentication Method\n----------------------------------------------------------------------------\n\nOne way to revert to the previous mysql_native_password authentication method\nfor the root@localhost user account is to execute mysql_install_db with a\nspecial option. If mysql_install_db is executed while\n--auth-root-authentication-method=normal is specified, then it will create the\ndefault user accounts using the default behavior of MariaDB 10.3 and before.\n\nThis means that the root@localhost user account will use mysql_native_password\nauthentication by default. There are some other differences as well. See\nmysql_install_db: User Accounts Created by Default for more information.\n\nFor example, the option can be set on the command-line while running\nmysql_install_db:\n\nmysql_install_db --user=mysql --datadir=/var/lib/mysql\n--auth-root-authentication-method=normal\n\nThe option can also be set in an option file in an option group supported by\nmysql_install_db. For example:\n\n[mysql_install_db]\nauth_root_authentication_method=normal\n\nIf the option is set in an option file and if mysql_install_db is executed,\nthen mysql_install_db will read this option from the option file, and it will\nautomatically set this option.\n\nAltering the User Account to Revert to the Previous Authentication Method\n-------------------------------------------------------------------------\n\nIf you have already installed MariaDB, and if the root@localhost user account\nis already using unix_socket authentication, then you can revert to the old\nmysql_native_password authentication method for the user account by executing\nthe following:\n\nALTER USER root@localhost IDENTIFIED VIA mysql_native_password USING\nPASSWORD(\"verysecret\")\n\nURL: https://mariadb.com/kb/en/authentication-from-mariadb-104/','','https://mariadb.com/kb/en/authentication-from-mariadb-104/'),(119,'ST_X',11,'Syntax\n------\n\nST_X(p)\nX(p)\n\nDescription\n-----------\n\nReturns the X-coordinate value for the point p as a double-precision number.\n\nST_X() and X() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT X(GeomFromText(@pt));\n+----------------------+\n| X(GeomFromText(@pt)) |\n+----------------------+\n|                 56.7 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_x/','','https://mariadb.com/kb/en/st_x/'),(88,'IF Function',7,'Syntax\n------\n\nIF(expr1,expr2,expr3)\n\nDescription\n-----------\n\nIf expr1 is TRUE (expr1 <> 0 and expr1 <> NULL) then IF() returns expr2;\notherwise it returns expr3. IF() returns a numeric or string value, depending\non the context in which it is used.\n\nNote: There is also an IF statement which differs from the IF() function\ndescribed here.\n\nExamples\n--------\n\nSELECT IF(1>2,2,3);\n+-------------+\n| IF(1>2,2,3) |\n+-------------+\n|           3 |\n+-------------+\n\nSELECT IF(1<2,\'yes\',\'no\');\n+--------------------+\n| IF(1<2,\'yes\',\'no\') |\n+--------------------+\n| yes                |\n+--------------------+\n\nSELECT IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\');\n+---------------------------------------+\n| IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\') |\n+---------------------------------------+\n| no                                    |\n+---------------------------------------+\n\nURL: https://mariadb.com/kb/en/if-function/','','https://mariadb.com/kb/en/if-function/'),(89,'IFNULL',7,'Syntax\n------\n\nIFNULL(expr1,expr2)\nNVL(expr1,expr2)\n\nDescription\n-----------\n\nIf expr1 is not NULL, IFNULL() returns expr1; otherwise it returns expr2.\nIFNULL() returns a numeric or string value, depending on the context in which\nit is used.\n\nFrom MariaDB 10.3, NVL() is an alias for IFNULL().\n\nExamples\n--------\n\nSELECT IFNULL(1,0); \n+-------------+\n| IFNULL(1,0) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT IFNULL(NULL,10);\n+-----------------+\n| IFNULL(NULL,10) |\n+-----------------+\n|              10 |\n+-----------------+\n\nSELECT IFNULL(1/0,10);\n+----------------+\n| IFNULL(1/0,10) |\n+----------------+\n|        10.0000 |\n+----------------+\n\nSELECT IFNULL(1/0,\'yes\');\n+-------------------+\n| IFNULL(1/0,\'yes\') |\n+-------------------+\n| yes               |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/ifnull/','','https://mariadb.com/kb/en/ifnull/'),(94,'START TRANSACTION',8,'Syntax\n------\n\nSTART TRANSACTION [transaction_property [, transaction_property] ...] | BEGIN\n[WORK]\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nROLLBACK [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nSET autocommit = {0 | 1}\n\ntransaction_property:\n  WITH CONSISTENT SNAPSHOT\n | READ WRITE\n | READ ONLY\n\nDescription\n-----------\n\nThe START TRANSACTION or BEGIN statement begins a new transaction. COMMIT\ncommits the current transaction, making its changes permanent. ROLLBACK rolls\nback the current transaction, canceling its changes. The SET autocommit\nstatement disables or enables the default autocommit mode for the current\nsession.\n\nSTART TRANSACTION and SET autocommit = 1 implicitly commit the current\ntransaction, if any.\n\nThe optional WORK keyword is supported for COMMIT and ROLLBACK, as are the\nCHAIN and RELEASE clauses. CHAIN and RELEASE can be used for additional\ncontrol over transaction completion. The value of the completion_type system\nvariable determines the default completion behavior.\n\nThe AND CHAIN clause causes a new transaction to begin as soon as the current\none ends, and the new transaction has the same isolation level as the\njust-terminated transaction. The RELEASE clause causes the server to\ndisconnect the current client session after terminating the current\ntransaction. Including the NO keyword suppresses CHAIN or RELEASE completion,\nwhich can be useful if the completion_type system variable is set to cause\nchaining or release completion by default.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can perform DDL\nstatements on temporary tables.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the SET TRANSACTION\nstatement, in which case the specified mode is valid for all sessions, or for\nall subsequent transaction used by the current session.\n\nautocommit\n----------\n\nBy default, MariaDB runs with autocommit mode enabled. This means that as soon\nas you execute a statement that updates (modifies) a table, MariaDB stores the\nupdate on disk to make it permanent. To disable autocommit mode, use the\nfollowing statement:\n\nSET autocommit=0;\n\nAfter disabling autocommit mode by setting the autocommit variable to zero,\nchanges to transaction-safe tables (such as those for InnoDB or NDBCLUSTER)\nare not made permanent immediately. You must use COMMIT to store your changes\nto disk or ROLLBACK to ignore the changes.\n\nTo disable autocommit mode for a single series of statements, use the START\nTRANSACTION statement.\n\nDDL Statements\n--------------\n\nDDL statements (CREATE, ALTER, DROP) and administrative statements (FLUSH,\nRESET, OPTIMIZE, ANALYZE, CHECK, REPAIR, CACHE INDEX), transaction management\nstatements (BEGIN, START TRANSACTION) and LOAD DATA INFILE, cause an implicit\nCOMMIT and start a new transaction. An exception to this rule are the DDL that\noperate on temporary tables: you can CREATE, ALTER and DROP them without\ncausing any COMMIT, but those actions cannot be rolled back. This means that\nif you call ROLLBACK, the temporary tables you created in the transaction will\nremain, while the rest of the transaction will be rolled back.\n\nTransactions cannot be used in Stored Functions or Triggers. In Stored\nProcedures and Events BEGIN is not allowed, so you should use START\nTRANSACTION instead.\n\nA transaction acquires a metadata lock on every table it accesses to prevent\nother connections from altering their structure. The lock is released at the\nend of the transaction. This happens even with non-transactional storage\nengines (like MEMORY or CONNECT), so it makes sense to use transactions with\nnon-transactional tables.\n\nin_transaction\n--------------\n\nThe in_transaction system variable is a session-only, read-only variable that\nreturns 1 inside a transaction, and 0 if not in a transaction.\n\nWITH CONSISTENT SNAPSHOT\n------------------------\n\nThe WITH CONSISTENT SNAPSHOT option starts a consistent read for storage\nengines such as InnoDB that can do so, the same as if a START TRANSACTION\nfollowed by a SELECT from any InnoDB table was issued.\n\nSee Enhancements for START TRANSACTION WITH CONSISTENT SNAPSHOT.\n\nExamples\n--------\n\nSTART TRANSACTION;\nSELECT @A:=SUM(salary) FROM table1 WHERE type=1;\nUPDATE table2 SET summary=@A WHERE type=1;\nCOMMIT;\n\nURL: https://mariadb.com/kb/en/start-transaction/','','https://mariadb.com/kb/en/start-transaction/'),(120,'ST_Y',11,'Syntax\n------\n\nST_Y(p)\nY(p)\n\nDescription\n-----------\n\nReturns the Y-coordinate value for the point p as a double-precision number.\n\nST_Y() and Y() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT Y(GeomFromText(@pt));\n+----------------------+\n| Y(GeomFromText(@pt)) |\n+----------------------+\n|                53.34 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_y/','','https://mariadb.com/kb/en/st_y/'),(121,'X',11,'A synonym for ST_X.\n\nURL: https://mariadb.com/kb/en/point-properties-x/','','https://mariadb.com/kb/en/point-properties-x/'),(122,'Y',11,'A synonym for ST_Y.\n\nURL: https://mariadb.com/kb/en/point-properties-y/','','https://mariadb.com/kb/en/point-properties-y/'),(125,'DECODE_ORACLE',12,'MariaDB starting with 10.3.2\n----------------------------\nDECODE_ORACLE is a synonym for the Oracle mode version of the DECODE function,\nand is available in all modes.\n\nURL: https://mariadb.com/kb/en/decode_oracle/','','https://mariadb.com/kb/en/decode_oracle/'),(93,'SET TRANSACTION',8,'Syntax\n------\n\nSET [GLOBAL | SESSION] TRANSACTION\n  transaction_property [, transaction_property] ...\n\ntransaction_property:\n  ISOLATION LEVEL level\n | READ WRITE\n | READ ONLY\n\nlevel:\n  REPEATABLE READ\n | READ COMMITTED\n | READ UNCOMMITTED\n | SERIALIZABLE\n\nDescription\n-----------\n\nThis statement sets the transaction isolation level or the transaction access\nmode globally, for the current session, or for the next transaction:\n\n* With the GLOBAL keyword, the statement sets the default\n transaction level globally for all subsequent sessions. Existing sessions are\n unaffected.\n* With the SESSION keyword, the statement sets the default\n transaction level for all subsequent transactions performed within the\n current session.\n* Without any SESSION or GLOBAL keyword,\n the statement sets the isolation level for the next (not started) transaction\n performed within the current session.\n\nA change to the global default isolation level requires the SUPER privilege.\nAny session is free to change its session isolation level (even in the middle\nof a transaction), or the isolation level for its next transaction.\n\nIsolation Level\n---------------\n\nTo set the global default isolation level at server startup, use the\n--transaction-isolation=level option on the command line or in an option file.\nValues of level for this option use dashes rather than spaces, so the\nallowable values are READ-UNCOMMITTED, READ-COMMITTED, REPEATABLE-READ, or\nSERIALIZABLE. For example, to set the default isolation level to REPEATABLE\nREAD, use these lines in the [mysqld] section of an option file:\n\n[mysqld]\ntransaction-isolation = REPEATABLE-READ\nTo determine the global and session transaction isolation levels at runtime,\ncheck the value of the tx_isolation system variable:\n\nSELECT @@GLOBAL.tx_isolation, @@tx_isolation;\n\nInnoDB supports each of the translation isolation levels described here using\ndifferent locking strategies. The default level is REPEATABLE READ. For\nadditional information about InnoDB record-level locks and how it uses them to\nexecute various types of statements, see InnoDB Lock Modes, and\nhttp://dev.mysql.com/doc/refman/en/innodb-locks-set.html.\n\nIsolation Levels\n----------------\n\nThe following sections describe how MariaDB supports the different transaction\nlevels.\n\nREAD UNCOMMITTED\n----------------\n\nSELECT statements are performed in a non-locking fashion, but a possible\nearlier version of a row might be used. Thus, using this isolation level, such\nreads are not consistent. This is also called a \"dirty read.\" Otherwise, this\nisolation level works like READ COMMITTED.\n\nREAD COMMITTED\n--------------\n\nA somewhat Oracle-like isolation level with respect to consistent\n(non-locking) reads: Each consistent read, even within the same transaction,\nsets and reads its own fresh snapshot. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), InnoDB locks\nonly index records, not the gaps before them, and thus allows the free\ninsertion of new records next to locked records. For UPDATE and DELETE\nstatements, locking depends on whether the statement uses a unique index with\na unique search condition (such as WHERE id = 100), or a range-type search\ncondition (such as WHERE id > 100). For a unique index with a unique search\ncondition, InnoDB locks only the index record found, not the gap before it.\nFor range-type searches, InnoDB locks the index range scanned, using gap locks\nor next-key (gap plus index-record) locks to block insertions by other\nsessions into the gaps covered by the range. This is necessary because\n\"phantom rows\" must be blocked for MySQL replication and recovery to work.\n\nNote: If the READ COMMITTED isolation level is used or the\ninnodb_locks_unsafe_for_binlog system variable is enabled, there is no InnoDB\ngap locking except for foreign-key constraint checking and duplicate-key\nchecking. Also, record locks for non-matching rows are released after MariaDB\nhas evaluated the WHERE condition.If you use READ COMMITTED or enable\ninnodb_locks_unsafe_for_binlog, you must use row-based binary logging.\n\nREPEATABLE READ\n---------------\n\nThis is the default isolation level for InnoDB. For consistent reads, there is\nan important difference from the READ COMMITTED isolation level: All\nconsistent reads within the same transaction read the snapshot established by\nthe first read. This convention means that if you issue several plain\n(non-locking) SELECT statements within the same transaction, these SELECT\nstatements are consistent also with respect to each other. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), UPDATE, and\nDELETE statements, locking depends on whether the statement uses a unique\nindex with a unique search condition, or a range-type search condition. For a\nunique index with a unique search condition, InnoDB locks only the index\nrecord found, not the gap before it. For other search conditions, InnoDB locks\nthe index range scanned, using gap locks or next-key (gap plus index-record)\nlocks to block insertions by other sessions into the gaps covered by the range.\n\nThis is the minimum isolation level for non-distributed XA transactions.\n\nSERIALIZABLE\n------------\n\nThis level is like REPEATABLE READ, but InnoDB implicitly converts all plain\nSELECT statements to SELECT ... LOCK IN SHARE MODE if autocommit is disabled.\nIf autocommit is enabled, the SELECT is its own transaction. It therefore is\nknown to be read only and can be serialized if performed as a consistent\n(non-locking) read and need not block for other transactions. (This means that\nto force a plain SELECT to block if other transactions have modified the\nselected rows, you should disable autocommit.)\n\nDistributed XA transactions should always use this isolation level.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can perform DDL\nstatements on temporary tables.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the START TRANSACTION\nstatement, in which case the specified mode is only valid for one transaction.\n\nExamples\n--------\n\nSET GLOBAL TRANSACTION ISOLATION LEVEL SERIALIZABLE;\n\nAttempting to set the isolation level within an existing transaction without\nspecifying GLOBAL or SESSION.\n\nSTART TRANSACTION;\n\nSET TRANSACTION ISOLATION LEVEL SERIALIZABLE;\nERROR 1568 (25001): Transaction characteristics can\'t be changed while a\ntransaction is in progress\n\nURL: https://mariadb.com/kb/en/set-transaction/','','https://mariadb.com/kb/en/set-transaction/'),(126,'AES_DECRYPT',12,'Syntax\n------\n\nAES_DECRYPT(crypt_str,key_str)\n\nDescription\n-----------\n\nThis function allows decryption of data using the official AES (Advanced\nEncryption Standard) algorithm. For more information, see the description of\nAES_ENCRYPT().\n\nURL: https://mariadb.com/kb/en/aes_decrypt/','','https://mariadb.com/kb/en/aes_decrypt/'),(133,'MD5',12,'Syntax\n------\n\nMD5(str)\n\nDescription\n-----------\n\nCalculates an MD5 128-bit checksum for the string.\n\nThe return value is a 32-hex digit string, and as of MariaDB 5.5, is a\nnonbinary string in the connection character set and collation, determined by\nthe values of the character_set_connection and collation_connection system\nvariables. Before 5.5, the return value was a binary string.\n\nNULL is returned if the argument was NULL.\n\nExamples\n--------\n\nSELECT MD5(\'testing\');\n+----------------------------------+\n| MD5(\'testing\')                   |\n+----------------------------------+\n| ae2b1fca515949e5d54fb22b8ed95575 |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/md5/','','https://mariadb.com/kb/en/md5/'),(95,'COMMIT',8,'The COMMIT statement ends a transaction, saving any changes to the data so\nthat they become visible to subsequent transactions. Also, unlocks metadata\nchanged by current transaction. If autocommit is set to 1, an implicit commit\nis performed after each statement. Otherwise, all transactions which don\'t end\nwith an explicit COMMIT are implicitly rollbacked and the changes are lost.\nThe ROLLBACK statement can be used to do this explicitly.\n\nThe required syntax for the COMMIT statement is as follows:\n\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\n\nCOMMIT is the more important transaction terminator, as well as the more\ninteresting one. The basic form of the COMMIT statement is simply the keyword\nCOMMIT (the keyword WORK is simply noise and can be omitted without changing\nthe effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated.\n\nRELEASE tells the server to disconnect the client immediately after the\ncurrent transaction.\n\nThere are NO RELEASE and AND NO CHAIN options. By default, commits do not\nRELEASE or CHAIN, but it\'s possible to change this default behavior with the\ncompletion_type server system variable. In this case, the AND NO CHAIN and NO\nRELEASE options override the server default.\n\nURL: https://mariadb.com/kb/en/commit/','','https://mariadb.com/kb/en/commit/'),(96,'ROLLBACK',8,'The ROLLBACK statement rolls back (ends) a transaction, destroying any changes\nto SQL-data so that they never become visible to subsequent transactions. The\nrequired syntax for the ROLLBACK statement is as follows.\n\nROLLBACK [ WORK ] [ AND [ NO ] CHAIN ] \n[ TO [ SAVEPOINT ] {<savepoint name> | <simple target specification>} ]\n\nThe ROLLBACK statement will either end a transaction, destroying all data\nchanges that happened during any of the transaction, or it will just destroy\nany data changes that happened since you established a savepoint. The basic\nform of the ROLLBACK statement is just the keyword ROLLBACK (the keyword WORK\nis simply noise and can be omitted without changing the effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated. The AND NO CHAIN option just tells your DBMS to end the\ntransaction — that is, these four SQL statements are equivalent:\n\nROLLBACK; \nROLLBACK WORK; \nROLLBACK AND NO CHAIN; \nROLLBACK WORK AND NO CHAIN;\n\nAll of them end a transaction without saving any transaction characteristics.\nThe only other options, the equivalent statements:\n\nROLLBACK AND CHAIN;\nROLLBACK WORK AND CHAIN;\n\nboth tell your DBMS to end a transaction, but to save that transaction\'s\ncharacteristics for the next transaction.\n\nROLLBACK is much simpler than COMMIT: it may involve no more than a few\ndeletions (of Cursors, locks, prepared SQL statements and log-file entries).\nIt\'s usually assumed that ROLLBACK can\'t fail, although such a thing is\nconceivable (for example, an encompassing transaction might reject an attempt\nto ROLLBACK because it\'s lining up for a COMMIT).\n\nROLLBACK cancels all effects of a transaction. It does not cancel effects on\nobjects outside the DBMS\'s control (for example the values in host program\nvariables or the settings made by some SQL/CLI function calls). But in\ngeneral, it is a convenient statement for those situations when you say \"oops,\nthis isn\'t working\" or when you simply don\'t care whether your temporary work\nbecomes permanent or not.\n\nHere is a moot question. If all you\'ve been doing is SELECTs, so that there\nhave been no data changes, should you end the transaction with ROLLBACK or\nCOMMIT? It shouldn\'t really matter because both ROLLBACK and COMMIT do the\nsame transaction-terminating job. However, the popular conception is that\nROLLBACK implies failure, so after a successful series of SELECT statements\nthe convention is to end the transaction with COMMIT rather than ROLLBACK.\n\nMariaDB (and most other DBMSs) supports rollback of SQL-data change\nstatements, but not of SQL-Schema statements. This means that if you use any\nof CREATE, ALTER, DROP, GRANT, REVOKE, you are implicitly committing at\nexecution time.\n\nINSERT INTO Table_2 VALUES(5); \nDROP TABLE Table_3 CASCADE; \nROLLBACK;\n\nThe result will be that both the INSERT and the DROP will go through as\nseparate transactions so the ROLLBACK will have no effect.\n\nURL: https://mariadb.com/kb/en/rollback/','','https://mariadb.com/kb/en/rollback/'),(138,'ENDPOINT',13,'A synonym for ST_ENDPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-endpoint/','','https://mariadb.com/kb/en/linestring-properties-endpoint/'),(139,'GLENGTH',13,'Syntax\n------\n\nGLength(ls)\n\nDescription\n-----------\n\nReturns as a double-precision number the length of the LineString value ls in\nits associated spatial reference.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT GLength(GeomFromText(@ls));\n+----------------------------+\n| GLength(GeomFromText(@ls)) |\n+----------------------------+\n|           2.82842712474619 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/glength/','','https://mariadb.com/kb/en/glength/'),(140,'NumPoints',13,'A synonym for ST_NumPoints.\n\nURL: https://mariadb.com/kb/en/linestring-properties-numpoints/','','https://mariadb.com/kb/en/linestring-properties-numpoints/'),(141,'PointN',13,'A synonym for ST_PointN.\n\nURL: https://mariadb.com/kb/en/linestring-properties-pointn/','','https://mariadb.com/kb/en/linestring-properties-pointn/'),(142,'STARTPOINT',13,'A synonym for ST_STARTPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-startpoint/','','https://mariadb.com/kb/en/linestring-properties-startpoint/'),(143,'ST_ENDPOINT',13,'Syntax\n------\n\nST_EndPoint(ls)\nEndPoint(ls)\n\nDescription\n-----------\n\nReturns the Point that is the endpoint of the LineString value ls.\n\nST_EndPoint() and EndPoint() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(EndPoint(GeomFromText(@ls)));\n+-------------------------------------+\n| AsText(EndPoint(GeomFromText(@ls))) |\n+-------------------------------------+\n| POINT(3 3)                          |\n+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_endpoint/','','https://mariadb.com/kb/en/st_endpoint/'),(144,'ST_NUMPOINTS',13,'Syntax\n------\n\nST_NumPoints(ls)\nNumPoints(ls)\n\nDescription\n-----------\n\nReturns the number of Point objects in the LineString value ls.\n\nST_NumPoints() and NumPoints() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT NumPoints(GeomFromText(@ls));\n+------------------------------+\n| NumPoints(GeomFromText(@ls)) |\n+------------------------------+\n|                            3 |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/st_numpoints/','','https://mariadb.com/kb/en/st_numpoints/'),(97,'LOCK TABLES',8,'Syntax\n------\n\nLOCK TABLE[S]\n  tbl_name [[AS] alias] lock_type\n  [, tbl_name [[AS] alias] lock_type] ...\n  [WAIT n|NOWAIT]\n\nlock_type:\n  READ [LOCAL]\n | [LOW_PRIORITY] WRITE\n | WRITE CONCURRENT\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nThe lock_type can be one of:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| READ                      | Read lock, no writes allowed                   |\n+---------------------------+------------------------------------------------+\n| READ LOCAL                | Read lock, but allow concurrent inserts        |\n+---------------------------+------------------------------------------------+\n| WRITE                     | Exclusive write lock. No other connections     |\n|                           | can read or write to this table                |\n+---------------------------+------------------------------------------------+\n| LOW_PRIORITY WRITE        | Exclusive write lock, but allow new read       |\n|                           | locks on the table until we get the write      |\n|                           | lock.                                          |\n+---------------------------+------------------------------------------------+\n| WRITE CONCURRENT          | Exclusive write lock, but allow READ LOCAL     |\n|                           | locks to the table.                            |\n+---------------------------+------------------------------------------------+\n\nMariaDB enables client sessions to acquire table locks explicitly for the\npurpose of cooperating with other sessions for access to tables, or to prevent\nother sessions from modifying tables during periods when a session requires\nexclusive access to them. A session can acquire or release locks only for\nitself. One session cannot acquire locks for another session or release locks\nheld by another session.\n\nLocks may be used to emulate transactions or to get more speed when updating\ntables.\n\nLOCK TABLES explicitly acquires table locks for the current client session.\nTable locks can be acquired for base tables or views. To use LOCK TABLES, you\nmust have the LOCK TABLES privilege, and the SELECT privilege for each object\nto be locked. See GRANT\n\nFor view locking, LOCK TABLES adds all base tables used in the view to the set\nof tables to be locked and locks them automatically. If you lock a table\nexplicitly with LOCK TABLES, any tables used in triggers are also locked\nimplicitly, as described in Triggers and Implicit Locks.\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\n\nMariaDB starting with 10.3.0\n----------------------------\n\nWAIT/NOWAIT\n-----------\n\nSet the lock wait timeout. See WAIT and NOWAIT.\n\nLimitations\n-----------\n\n* LOCK TABLES doesn\'t work when using Galera cluster.   You may experience\ncrashes or locks when used with Galera.\n* LOCK TABLES works on XtraDB/InnoDB tables only if the innodb_table_locks\nsystem variable is set to 1 (the default) and autocommit is set to 0 (1 is\ndefault). Please note that no error message will be returned on LOCK TABLES\nwith innodb_table_locks = 0.\n* LOCK TABLES implicitly commits the active transaction, if any. Also,\nstarting a transaction always releases all table locks acquired with LOCK\nTABLES. This means that there is no way to have table locks and an active\ntransaction at the same time. The only exceptions are the transactions in\nautocommit mode. To preserve the data integrity between transactional and\nnon-transactional tables, the GET_LOCK() function can be used.\n* When using LOCK TABLES on a TEMPORARY table, it will always be locked with a\nWRITE lock.\n* While a connection holds an explicit read lock on a table, it cannot modify\nit. If you try, the following error will be produced:\n\nERROR 1099 (HY000): Table \'tab_name\' was locked with a READ lock and can\'t be\nupdated\n\n* While a connection holds an explicit lock on a table, it cannot access a\nnon-locked table. If you try, the following error will be produced:\n\nERROR 1100 (HY000): Table \'tab_name\' was not locked with LOCK TABLES\n\n* While a connection holds an explicit lock on a table, it cannot issue the\nfollowing: INSERT DELAYED, CREATE TABLE, CREATE TABLE ... LIKE, and DDL\nstatements involving stored programs and views (except for triggers). If you\ntry, the following error will be produced:\n\nERROR 1192 (HY000): Can\'t execute the given command because you have active\nlocked tables or an active transaction\n\n* LOCK TABLES can not be used in stored routines - if you try, the following\nerror will be produced on creation. This restriction was removed in MariaDB\n10.6.2:\n\nERROR 1314 (0A000): LOCK is not allowed in stored procedures\n\nURL: https://mariadb.com/kb/en/lock-tables/','','https://mariadb.com/kb/en/lock-tables/'),(145,'ST_POINTN',13,'Syntax\n------\n\nST_PointN(ls,N)\nPointN(ls,N)\n\nDescription\n-----------\n\nReturns the N-th Point in the LineString value ls. Points are numbered\nbeginning with 1.\n\nST_PointN() and PointN() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(PointN(GeomFromText(@ls),2));\n+-------------------------------------+\n| AsText(PointN(GeomFromText(@ls),2)) |\n+-------------------------------------+\n| POINT(2 2)                          |\n+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_pointn/','','https://mariadb.com/kb/en/st_pointn/'),(146,'ST_STARTPOINT',13,'Syntax\n------\n\nST_StartPoint(ls)\nStartPoint(ls)\n\nDescription\n-----------\n\nReturns the Point that is the start point of the LineString value ls.\n\nST_StartPoint() and StartPoint() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(StartPoint(GeomFromText(@ls)));\n+---------------------------------------+\n| AsText(StartPoint(GeomFromText(@ls))) |\n+---------------------------------------+\n| POINT(1 1)                            |\n+---------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_startpoint/','','https://mariadb.com/kb/en/st_startpoint/'),(150,'INET_ATON',14,'Syntax\n------\n\nINET_ATON(expr)\n\nDescription\n-----------\n\nGiven the dotted-quad representation of an IPv4 network address as a string,\nreturns an integer that represents the numeric value of the address. Addresses\nmay be 4- or 8-byte addresses.\n\nReturns NULL if the argument is not understood.\n\nExamples\n--------\n\nSELECT INET_ATON(\'192.168.1.1\');\n+--------------------------+\n| INET_ATON(\'192.168.1.1\') |\n+--------------------------+\n|               3232235777 |\n+--------------------------+\n\nThis is calculated as follows: 192 x 2563 + 168 x 256 2 + 1 x 256 + 1\n\nURL: https://mariadb.com/kb/en/inet_aton/','','https://mariadb.com/kb/en/inet_aton/'),(151,'INET_NTOA',14,'Syntax\n------\n\nINET_NTOA(expr)\n\nDescription\n-----------\n\nGiven a numeric IPv4 network address in network byte order (4 or 8 byte),\nreturns the dotted-quad representation of the address as a string.\n\nExamples\n--------\n\nSELECT INET_NTOA(3232235777);\n+-----------------------+\n| INET_NTOA(3232235777) |\n+-----------------------+\n| 192.168.1.1           |\n+-----------------------+\n\n192.168.1.1 corresponds to 3232235777 since 192 x 2563 + 168 x 256 2 + 1 x 256\n+ 1 = 3232235777\n\nURL: https://mariadb.com/kb/en/inet_ntoa/','','https://mariadb.com/kb/en/inet_ntoa/'),(98,'SAVEPOINT',8,'Syntax\n------\n\nSAVEPOINT identifier\nROLLBACK [WORK] TO [SAVEPOINT] identifier\nRELEASE SAVEPOINT identifier\n\nDescription\n-----------\n\nInnoDB supports the SQL statements SAVEPOINT, ROLLBACK TO SAVEPOINT, RELEASE\nSAVEPOINT and the optional WORK keyword for ROLLBACK.\n\nEach savepoint must have a legal MariaDB identifier. A savepoint is a named\nsub-transaction.\n\nNormally ROLLBACK undoes the changes performed by the whole transaction. When\nused with the TO clause, it undoes the changes performed after the specified\nsavepoint, and erases all subsequent savepoints. However, all locks that have\nbeen acquired after the save point will survive. RELEASE SAVEPOINT does not\nrollback or commit any changes, but removes the specified savepoint.\n\nWhen the execution of a trigger or a stored function begins, it is not\npossible to use statements which reference a savepoint which was defined from\nout of that stored program.\n\nWhen a COMMIT (including implicit commits) or a ROLLBACK statement (with no TO\nclause) is performed, they act on the whole transaction, and all savepoints\nare removed.\n\nErrors\n------\n\nIf COMMIT or ROLLBACK is issued and no transaction was started, no error is\nreported.\n\nIf SAVEPOINT is issued and no transaction was started, no error is reported\nbut no savepoint is created. When ROLLBACK TO SAVEPOINT or RELEASE SAVEPOINT\nis called for a savepoint that does not exist, an error like this is issued:\n\nERROR 1305 (42000): SAVEPOINT svp_name does not exist\n\nURL: https://mariadb.com/kb/en/savepoint/','','https://mariadb.com/kb/en/savepoint/'),(99,'Metadata Locking',8,'MariaDB supports metadata locking. This means that when a transaction\n(including XA transactions) uses a table, it locks its metadata until the end\nof transaction. Non-transactional tables are also locked, as well as views and\nobjects which are related to locked tables/views (stored functions, triggers,\netc). When a connection tries to use a DDL statement (like an ALTER TABLE)\nwhich modifies a table that is locked, that connection is queued, and has to\nwait until it\'s unlocked. Using savepoints and performing a partial rollback\ndoes not release metadata locks.\n\nLOCK TABLES ... WRITE are also queued. Some wrong statements which produce an\nerror may not need to wait for the lock to be freed.\n\nThe metadata lock\'s timeout is determined by the value of the\nlock_wait_timeout server system variable (in seconds). However, note that its\ndefault value is 31536000 (1 year, MariaDB <= 10.2.3), or 86400 (1 day,\nMariaDB >= 10.2.4). If this timeout is exceeded, the following error is\nreturned:\n\nERROR 1205 (HY000): Lock wait timeout exceeded; try restarting transaction\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table stores information about existing metadata locks.\n\nMariaDB starting with 10.5.2\n----------------------------\nFrom MariaDB 10.5, the Performance Schema metadata_locks table contains\nmetadata lock information.\n\nExample\n-------\n\nLet\'s use the following MEMORY (non-transactional) table:\n\nCREATE TABLE t (a INT) ENGINE = MEMORY;\n\nConnection 1 starts a transaction, and INSERTs a row into t:\n\nSTART TRANSACTION;\n\nINSERT INTO t SET a=1;\n\nt\'s metadata is now locked by connection 1. Connection 2 tries to alter t, but\nhas to wait:\n\nALTER TABLE t ADD COLUMN b INT;\n\nConnection 2\'s prompt is blocked now.\n\nNow connection 1 ends the transaction:\n\nCOMMIT;\n\n...and connection 2 finally gets the output of its command:\n\nQuery OK, 1 row affected (35.23 sec)\nRecords: 1  Duplicates: 0  Warnings: 0\n\nURL: https://mariadb.com/kb/en/metadata-locking/','','https://mariadb.com/kb/en/metadata-locking/'),(100,'Transaction Timeouts',8,'MariaDB has always had the wait_timeout and interactive_timeout settings,\nwhich close connections after a certain period of inactivity.\n\nHowever, these are by default set to a long wait period. In situations where\ntransactions may be started, but not committed or rolled back, more granular\ncontrol and a shorter timeout may be desirable so as to avoid locks being held\nfor too long.\n\nMariaDB 10.3 introduced three new variables to handle this situation.\n\n* idle_transaction_timeout (all transactions)\n* idle_write_transaction_timeout (write transactions - called\nidle_readwrite_transaction_timeout until MariaDB 10.3.2)\n* idle_readonly_transaction_timeout (read transactions)\n\nThese accept a time in seconds to time out, by closing the connection,\ntransactions that are idle for longer than this period. By default all are set\nto zero, or no timeout.\n\nidle_transaction_timeout affects all transactions,\nidle_write_transaction_timeout affects write transactions only and\nidle_readonly_transaction_timeout affects read transactions only. The latter\ntwo variables work independently. However, if either is set along with\nidle_transaction_timeout, the settings for idle_write_transaction_timeout or\nidle_readonly_transaction_timeout will take precedence.\n\nExamples\n--------\n\nSET SESSION idle_transaction_timeout=2;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 3 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nSET SESSION idle_write_transaction_timeout=2;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 3 seconds\nSELECT * FROM t;\nEmpty set (0.000 sec)\nINSERT INTO t VALUES(1);\n## wait 3 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nSET SESSION idle_transaction_timeout=2, SESSION\nidle_readonly_transaction_timeout=10;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n ## wait 3 seconds\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 11 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nURL: https://mariadb.com/kb/en/transa