/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('7125a495-c31a-432e-a45c-84cd206b1f52','2026-01-21 13:31:02','2026-01-21 13:31:02',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','a68b3657-d4fb-4766-a733-d576575d3ca3','2026-01-21 13:30:56','2026-01-21 13:30:56',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('a68b3657-d4fb-4766-a733-d576575d3ca3','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2026-01-21 13:30:56','2026-01-21 13:30:56',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2026-01-21 13:30:52',NULL,NULL,0,1,'default','volumes',10),('2026-01-21 13:30:52',NULL,NULL,0,2,'default','snapshots',10),('2026-01-21 13:30:52',NULL,NULL,0,3,'default','gigabytes',1000),('2026-01-21 13:30:52',NULL,NULL,0,4,'default','consistencygroups',10),('2026-01-21 13:30:52',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2026-01-21 13:30:52',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2026-01-21 13:31:08','2026-01-21 14:35:30',NULL,0,1,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',382,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'e37c4b23-a96b-4900-b8de-e6fda7a74119'),('2026-01-21 14:04:00','2026-01-21 14:35:34',NULL,0,2,'cinder-backup-0','cinder-backup','cinder-backup',189,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'ed451233-474a-4a60-9a57-6934432a590e'),('2026-01-21 14:04:00','2026-01-21 14:35:34',NULL,0,3,'hostgroup@ceph','cinder-volume','cinder-volume',189,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'268872e5-8b63-45c5-a31b-80078142a996');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2026-01-21 13:30:56','2026-01-21 13:30:56',NULL,0,'65111cd2-26d4-4cf8-ac79-c6c0f9e64313','__DEFAULT__',NULL,1,'Default Volume Type');
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2026-01-21 13:30:56','2026-01-21 13:30:56.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'0fe582cf-0e10-45d8-a06c-809db5750f1a','rbd://2f0e9cad-f0a3-5869-9cc3-8d84d071866a/images/0fe582cf-0e10-45d8-a06c-809db5750f1a/snap','2026-01-21 14:09:54','2026-01-21 14:09:54',NULL,0,'{\"store\": \"default_backend\"}','active'),(2,'9ee37107-0b6b-4262-99b1-6222d7a5c8af','rbd://2f0e9cad-f0a3-5869-9cc3-8d84d071866a/images/9ee37107-0b6b-4262-99b1-6222d7a5c8af/snap','2026-01-21 14:09:57','2026-01-21 14:09:57',NULL,0,'{\"store\": \"default_backend\"}','active');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'0fe582cf-0e10-45d8-a06c-809db5750f1a','hw_rng_model','virtio','2026-01-21 14:09:47','2026-01-21 14:09:47',NULL,0),(2,'9ee37107-0b6b-4262-99b1-6222d7a5c8af','hw_rng_model','virtio','2026-01-21 14:09:55','2026-01-21 14:09:55',NULL,0);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('0fe582cf-0e10-45d8-a06c-809db5750f1a','cirros-0.6.2-x86_64-disk.img',21430272,'active','2026-01-21 14:09:47','2026-01-21 14:09:50',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','408592f9f990495db91f5ad490c151f0',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('9ee37107-0b6b-4262-99b1-6222d7a5c8af','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2026-01-21 14:09:55','2026-01-21 14:09:57',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','408592f9f990495db91f5ad490c151f0',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b');
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2026-01-21 13:29:29',NULL),(1,2,'image','CIM_RASD_','2026-01-21 13:29:29',NULL),(1,3,NULL,'CIM_SASD_','2026-01-21 13:29:29',NULL),(1,9,'image','hw_','2026-01-21 13:29:29',NULL),(1,10,'image','hw_','2026-01-21 13:29:29',NULL),(1,14,'image',NULL,'2026-01-21 13:29:29',NULL),(1,19,'image','hw_','2026-01-21 13:29:29',NULL),(1,25,'image','hw_','2026-01-21 13:29:30',NULL),(1,29,'image',NULL,'2026-01-21 13:29:30',NULL),(1,30,'image',NULL,'2026-01-21 13:29:30',NULL),(1,31,'image',NULL,'2026-01-21 13:29:30',NULL),(1,32,'image',NULL,'2026-01-21 13:29:30',NULL),(2,1,NULL,'CIM_PASD_','2026-01-21 13:29:29',NULL),(2,8,NULL,'hw_','2026-01-21 13:29:29',NULL),(2,9,NULL,'hw_','2026-01-21 13:29:29',NULL),(2,10,NULL,'hw_','2026-01-21 13:29:29',NULL),(2,11,NULL,NULL,'2026-01-21 13:29:29',NULL),(2,13,NULL,NULL,'2026-01-21 13:29:29',NULL),(2,14,NULL,NULL,'2026-01-21 13:29:29',NULL),(2,15,NULL,NULL,'2026-01-21 13:29:29',NULL),(2,16,NULL,'hw_','2026-01-21 13:29:29',NULL),(2,19,NULL,'hw_','2026-01-21 13:29:29',NULL),(2,22,NULL,NULL,'2026-01-21 13:29:29',NULL),(2,23,NULL,'hw_','2026-01-21 13:29:30',NULL),(2,24,NULL,'traits:','2026-01-21 13:29:30',NULL),(2,25,NULL,'hw_','2026-01-21 13:29:30',NULL),(2,26,NULL,NULL,'2026-01-21 13:29:30',NULL),(2,28,NULL,NULL,'2026-01-21 13:29:30',NULL),(2,29,NULL,NULL,'2026-01-21 13:29:30',NULL),(2,30,NULL,NULL,'2026-01-21 13:29:30',NULL),(2,31,NULL,NULL,'2026-01-21 13:29:30',NULL),(2,32,NULL,NULL,'2026-01-21 13:29:30',NULL),(2,33,NULL,'cinder_','2026-01-21 13:29:30',NULL),(3,1,NULL,'CIM_PASD_','2026-01-21 13:29:29',NULL),(3,2,NULL,'CIM_RASD_','2026-01-21 13:29:29',NULL),(3,3,NULL,'CIM_SASD_','2026-01-21 13:29:29',NULL),(3,4,NULL,'CIM_VSSD_','2026-01-21 13:29:29',NULL),(3,5,NULL,NULL,'2026-01-21 13:29:29',NULL),(3,6,NULL,NULL,'2026-01-21 13:29:29',NULL),(3,7,NULL,NULL,'2026-01-21 13:29:29',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2026-01-21 13:29:29',NULL),(4,1,NULL,'CIM_PASD_','2026-01-21 13:29:29',NULL),(4,2,NULL,'CIM_RASD_','2026-01-21 13:29:29',NULL),(4,3,NULL,'CIM_SASD_','2026-01-21 13:29:29',NULL),(4,4,NULL,'CIM_VSSD_','2026-01-21 13:29:29',NULL),(4,8,NULL,'hw:','2026-01-21 13:29:29',NULL),(4,9,NULL,'hw:','2026-01-21 13:29:29',NULL),(4,10,NULL,'hw:','2026-01-21 13:29:29',NULL),(4,12,NULL,'capabilities:','2026-01-21 13:29:29',NULL),(4,16,NULL,'hw:','2026-01-21 13:29:29',NULL),(4,17,NULL,NULL,'2026-01-21 13:29:29',NULL),(4,18,NULL,NULL,'2026-01-21 13:29:29',NULL),(4,19,NULL,'hw:','2026-01-21 13:29:29',NULL),(4,20,NULL,NULL,'2026-01-21 13:29:29',NULL),(4,21,NULL,NULL,'2026-01-21 13:29:29',NULL),(4,23,NULL,'hw:','2026-01-21 13:29:30',NULL),(4,24,NULL,'traits:','2026-01-21 13:29:30',NULL),(4,25,NULL,'hw:','2026-01-21 13:29:30',NULL),(5,1,'scheduler_hints',NULL,'2026-01-21 13:29:29',NULL),(5,30,'metadata',NULL,'2026-01-21 13:29:30',NULL),(5,31,'metadata',NULL,'2026-01-21 13:29:30',NULL),(5,32,'metadata',NULL,'2026-01-21 13:29:30',NULL),(6,30,NULL,NULL,'2026-01-21 13:29:30',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2026-01-21 13:29:29',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2026-01-21 13:29:29',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2026-01-21 13:29:29',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2026-01-21 13:29:29',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-01-21 13:29:29',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-01-21 13:29:29',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2026-01-21 13:29:29',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2026-01-21 13:29:29',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2026-01-21 13:29:29',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2026-01-21 13:29:29',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2026-01-21 13:29:29',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2026-01-21 13:29:29',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2026-01-21 13:29:29',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2026-01-21 13:29:29',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-21 13:29:29',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-21 13:29:29',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-21 13:29:29',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2026-01-21 13:29:29',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2026-01-21 13:29:29',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-21 13:29:29',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-21 13:29:29',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-21 13:29:29',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2026-01-21 13:29:29',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2026-01-21 13:29:30',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-21 13:29:30',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-21 13:29:30',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2026-01-21 13:29:30',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2026-01-21 13:29:30',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2026-01-21 13:29:30',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2026-01-21 13:29:30',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2026-01-21 13:29:30',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2026-01-21 13:29:30',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2026-01-21 13:29:30',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2026-01-21 13:29:29',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2026-01-21 13:29:29',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2026-01-21 13:29:29',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2026-01-21 13:29:30',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2026-01-21 13:29:30',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2026-01-21 13:29:30',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2026-01-21 13:29:30',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-21 13:29:30',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-21 13:29:30',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-01-21 13:29:30',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-01-21 13:29:30',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-21 13:29:30',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2026-01-21 13:29:30',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2026-01-21 13:29:30',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2026-01-21 13:29:30',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2026-01-21 13:29:30',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2026-01-21 13:29:30',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2026-01-21 13:29:30',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2026-01-21 13:29:30',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2026-01-21 13:29:30',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-21 13:29:30',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-21 13:29:30',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-21 13:29:30',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2026-01-21 13:29:29',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2026-01-21 13:29:29',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2026-01-21 13:29:29',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2026-01-21 13:29:29',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2026-01-21 13:29:29',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-01-21 13:29:29',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2026-01-21 13:29:29',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-01-21 13:29:29',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2026-01-21 13:29:29',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2026-01-21 13:29:29',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2026-01-21 13:29:29',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2026-01-21 13:29:29',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2026-01-21 13:29:29',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2026-01-21 13:29:29',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2026-01-21 13:29:29',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2026-01-21 13:29:29',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2026-01-21 13:29:29',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2026-01-21 13:29:29',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2026-01-21 13:29:29',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2026-01-21 13:29:29',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-21 13:29:29',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2026-01-21 13:29:29',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2026-01-21 13:29:29',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2026-01-21 13:29:29',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-21 13:29:29',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-21 13:29:29',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-21 13:29:29',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2026-01-21 13:29:29',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2026-01-21 13:29:29',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2026-01-21 13:29:29',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2026-01-21 13:29:29',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-21 13:29:29',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-01-21 13:29:29',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-01-21 13:29:29',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2026-01-21 13:29:29',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2026-01-21 13:29:29',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2026-01-21 13:29:29',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2026-01-21 13:29:29',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-21 13:29:29',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2026-01-21 13:29:29',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2026-01-21 13:29:29',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-21 13:29:29',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-21 13:29:29',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-21 13:29:29',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2026-01-21 13:29:29',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-21 13:29:29',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-21 13:29:29',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-21 13:29:29',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-21 13:29:29',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2026-01-21 13:29:29',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2026-01-21 13:29:29',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2026-01-21 13:29:29',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-01-21 13:29:29',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-01-21 13:29:29',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-01-21 13:29:29',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-01-21 13:29:29',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-01-21 13:29:29',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-01-21 13:29:29',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2026-01-21 13:29:29',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2026-01-21 13:29:29',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-21 13:29:29',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-21 13:29:29',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2026-01-21 13:29:29',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2026-01-21 13:29:29',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2026-01-21 13:29:29',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2026-01-21 13:29:29',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2026-01-21 13:29:29',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-21 13:29:29',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2026-01-21 13:29:30',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-01-21 13:29:30',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-01-21 13:29:30',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2026-01-21 13:29:30',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2026-01-21 13:29:30',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2026-01-21 13:29:30',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2026-01-21 13:29:30',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2026-01-21 13:29:30',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2026-01-21 13:29:30',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-01-21 13:29:30',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2026-01-21 13:29:30',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-01-21 13:29:30',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2026-01-21 13:29:30',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2026-01-21 13:29:30',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2026-01-21 13:29:30',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2026-01-21 13:29:30',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2026-01-21 13:29:30',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2026-01-21 13:29:30',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2026-01-21 13:29:30',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-01-21 13:29:30',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-01-21 13:29:30',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2026-01-21 13:29:30',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2026-01-21 13:29:30',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2026-01-21 13:29:29',NULL),(2,'OS::Glance::Image',1,'2026-01-21 13:29:29',NULL),(3,'OS::Nova::Aggregate',1,'2026-01-21 13:29:29',NULL),(4,'OS::Nova::Flavor',1,'2026-01-21 13:29:29',NULL),(5,'OS::Nova::Server',1,'2026-01-21 13:29:29',NULL),(6,'OS::Trove::Instance',1,'2026-01-21 13:29:30',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `user_id` (`user_id`),
  KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','2cbde5c50dad460fb2cd0528113fc82b','9fe1cfb5a0c94e3f9373148450b42755','49036114c709426d9900a92e9b637437',0),('UserProject','2cbde5c50dad460fb2cd0528113fc82b','9fe1cfb5a0c94e3f9373148450b42755','4d26d25438e347a185f0b5da3011dd78',0),('UserProject','6f34e8796a1b4806896d0d03d81f6eca','9fe1cfb5a0c94e3f9373148450b42755','49036114c709426d9900a92e9b637437',0),('UserProject','6f34e8796a1b4806896d0d03d81f6eca','9fe1cfb5a0c94e3f9373148450b42755','4d26d25438e347a185f0b5da3011dd78',0),('UserProject','8f773bf58f7e4798bc681f39c85c3fae','408592f9f990495db91f5ad490c151f0','4d26d25438e347a185f0b5da3011dd78',0),('UserProject','8f773bf58f7e4798bc681f39c85c3fae','408592f9f990495db91f5ad490c151f0','86dbcebcb6924e8cb0cbda34fa129a15',0),('UserProject','8f773bf58f7e4798bc681f39c85c3fae','4dce6c721e184b13bd84cddd0e203a0d','4d26d25438e347a185f0b5da3011dd78',0),('UserProject','98346b7f610d48d98cc4efc0d50f511a','9fe1cfb5a0c94e3f9373148450b42755','49036114c709426d9900a92e9b637437',0),('UserProject','98346b7f610d48d98cc4efc0d50f511a','9fe1cfb5a0c94e3f9373148450b42755','4d26d25438e347a185f0b5da3011dd78',0),('UserProject','ae7aeaa718a64439964d40116aa42d2c','9fe1cfb5a0c94e3f9373148450b42755','49036114c709426d9900a92e9b637437',0),('UserProject','ae7aeaa718a64439964d40116aa42d2c','9fe1cfb5a0c94e3f9373148450b42755','4d26d25438e347a185f0b5da3011dd78',0),('UserProject','b96cc77704e744748cf4b5937cd98e20','9fe1cfb5a0c94e3f9373148450b42755','49036114c709426d9900a92e9b637437',0),('UserProject','b96cc77704e744748cf4b5937cd98e20','9fe1cfb5a0c94e3f9373148450b42755','4d26d25438e347a185f0b5da3011dd78',0),('UserProject','cf373519529d406680aae2c33da9ee28','9fe1cfb5a0c94e3f9373148450b42755','49036114c709426d9900a92e9b637437',0),('UserProject','cf373519529d406680aae2c33da9ee28','9fe1cfb5a0c94e3f9373148450b42755','4d26d25438e347a185f0b5da3011dd78',0),('UserProject','dac7ad005b4f4f33a3b76497a4b8836e','9fe1cfb5a0c94e3f9373148450b42755','49036114c709426d9900a92e9b637437',0),('UserProject','dac7ad005b4f4f33a3b76497a4b8836e','9fe1cfb5a0c94e3f9373148450b42755','4d26d25438e347a185f0b5da3011dd78',0),('UserProject','e655d1e4aae443afa93b1a5b49b8b1bf','9fe1cfb5a0c94e3f9373148450b42755','4d26d25438e347a185f0b5da3011dd78',0),('UserProject','e655d1e4aae443afa93b1a5b49b8b1bf','9fe1cfb5a0c94e3f9373148450b42755','6ee92856e97a4cfa84894ba9d92cb800',0),('UserProject','f5c81fe487de44d095395ed8a64f9cf3','9fe1cfb5a0c94e3f9373148450b42755','49036114c709426d9900a92e9b637437',0),('UserProject','f5c81fe487de44d095395ed8a64f9cf3','9fe1cfb5a0c94e3f9373148450b42755','4d26d25438e347a185f0b5da3011dd78',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('0203f9bc92774347929a19aed11d95a8',NULL,'public','ee31b26cd8ed4af8bcdb0938a22adf6c','https://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('03b2c4cdc1f448b58377cf6cdb142649',NULL,'internal','b9e56ed39a064fbd8dc3e9999fd2895f','https://manila-internal.openstack.svc:8786/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('077fcb8732154032b2ebc1286cdfdaeb',NULL,'public','7d1cf0826de04bbfbe67a9dc484970e2','https://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('0f2a3bef1343466d962c7e093d920947',NULL,'internal','47adc1d65e1e40708a3373675eb8195d','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('1ffb1c9757db4dd18d9524e8104173e7',NULL,'public','cb2e22aaf86f47bf837c5ccb92699af6','https://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('38221ea2b09a4ea8bc953293a371bb11',NULL,'internal','11b6a46360ff42c4928ff39158bb1762','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('46260071bd2d4273b5c76e7deeeb01db',NULL,'internal','5549658b521d4401ac714ff81240d7c5','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('554b2818c0de458ebd9403f724e92dd6',NULL,'public','3c8d484856354deea2351cb57612be56','https://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('643f963c32714819a3859c7d7632a895',NULL,'internal','cb2e22aaf86f47bf837c5ccb92699af6','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('76a0f515390e4b87944c89327b6d269c',NULL,'internal','ee31b26cd8ed4af8bcdb0938a22adf6c','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('7d4f916b0ae0416ab5ca93fa31860bb6',NULL,'public','5549658b521d4401ac714ff81240d7c5','https://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('8c6b40f857db47e697d8efe28517cfc0',NULL,'internal','3c8d484856354deea2351cb57612be56','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('9a15170d7eb04514b6c55f332f98be49',NULL,'internal','24103d7dbe86463e91b655780265157e','https://manila-internal.openstack.svc:8786/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('9b9de9ab83f64373b1691661ba3c4899',NULL,'public','b9e56ed39a064fbd8dc3e9999fd2895f','https://manila-public-openstack.apps-crc.testing/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('aace0170bc964758b168c692c4bf21f5',NULL,'public','11b6a46360ff42c4928ff39158bb1762','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('cb9766f9dde543b8b9f7560a0b38065b',NULL,'public','14c22a55c0764d77a8abca2aa9c59d3b','https://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('d30615baf7ad476a8435780373645929',NULL,'internal','14c22a55c0764d77a8abca2aa9c59d3b','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('f87617ba6d114c368d9fac48e1229b4b',NULL,'internal','7d1cf0826de04bbfbe67a9dc484970e2','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('fc8e714bd0fe4828922db7dd68f00a11',NULL,'public','47adc1d65e1e40708a3373675eb8195d','https://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('fd94e32676b24dac9e4571b4bb6d881c',NULL,'public','24103d7dbe86463e91b655780265157e','https://manila-public-openstack.apps-crc.testing/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('4d26d25438e347a185f0b5da3011dd78','6ee92856e97a4cfa84894ba9d92cb800'),('6ee92856e97a4cfa84894ba9d92cb800','23e95c3313b341a3a24057e69983f687');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=233 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'8f773bf58f7e4798bc681f39c85c3fae','default','admin',0,NULL),(2,'cf373519529d406680aae2c33da9ee28','default','ceilometer',0,NULL),(3,'dac7ad005b4f4f33a3b76497a4b8836e','default','cinder',0,NULL),(4,'98346b7f610d48d98cc4efc0d50f511a','default','barbican',0,NULL),(5,'b96cc77704e744748cf4b5937cd98e20','default','glance',0,NULL),(6,'2cbde5c50dad460fb2cd0528113fc82b','default','neutron',0,NULL),(7,'ae7aeaa718a64439964d40116aa42d2c','default','nova',0,NULL),(8,'f5c81fe487de44d095395ed8a64f9cf3','default','placement',0,NULL),(9,'e655d1e4aae443afa93b1a5b49b8b1bf','default','swift',0,NULL),(10,'6f34e8796a1b4806896d0d03d81f6eca','default','manila',0,NULL),(11,'d8d57f0d66f44201b0f8e364ef0ddaa3','default','demo_tempestconf',0,NULL),(12,'6f99e659e1814a83a66e932f12ae158a','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=233 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$CvDYDrUCyPyFhYilh5RnFemsc2u4nflkwjuYCkrR0aQqrkf0BQVZu',1769002194062480,NULL,'2026-01-21 13:29:54'),(2,2,NULL,0,'$2b$12$RK9qtLMGlY7u63RUSbpZBOwN3RrwEr9Wi3/IFevELJFCx5tMgpkO6',1769002274441939,NULL,'2026-01-21 13:31:14'),(3,3,NULL,0,'$2b$12$Cz46diEaSQeQWDCesLlxXeYdemC5X98OMiX1MVJVEkAXVLay6j4rW',1769002278065439,NULL,'2026-01-21 13:31:18'),(4,4,NULL,0,'$2b$12$YfeIVeltwuse4LjkMjrbPeGJEj288ZBYQAFguMFfUh037fcrIMCX2',1769002280586249,NULL,'2026-01-21 13:31:20'),(5,5,NULL,0,'$2b$12$T2t68DXRUNoS0/k4dVfd0OqCLxWhFEEfWOfqoCl7M/sP7BNPVRu1a',1769002283867902,NULL,'2026-01-21 13:31:23'),(6,6,NULL,0,'$2b$12$UWHOdJxMr4pw3gu16lPvOupOUqfB.3mVbBvtVShDNid3eiC3ClRCy',1769002288757743,NULL,'2026-01-21 13:31:28'),(7,7,NULL,0,'$2b$12$RQlKcMXw4sL/3VSwi.YcHe5ct1xAJ0aHN4M7aYM9V8auEa1vxSAQy',1769002301344904,NULL,'2026-01-21 13:31:41'),(8,8,NULL,0,'$2b$12$QEZwyYbvNtPg3wxyHNiwLugtt2XwZ.kJMahTUThsZ06jF/YncgRvO',1769002304810334,NULL,'2026-01-21 13:31:44'),(9,9,NULL,0,'$2b$12$41WgC3/0rpTytUASbN.MyO.aDlDecjDcKaXwzBoKm1zJRfiy0SkW2',1769003203139922,NULL,'2026-01-21 13:46:43'),(10,10,NULL,0,'$2b$12$KhnQAI0/2Hi8wmULJtjF1elyNwO8USl8lBfJORiL/RWJVR3Z5aJJi',1769004272216024,NULL,'2026-01-21 14:04:32'),(11,11,NULL,0,'$2b$12$nzEJgfJMQERmHmHG9dgUueLz00w3adavjGouCurJrGEpi9B.X6L0G',1769004452916900,NULL,'2026-01-21 14:07:32'),(12,12,NULL,0,'$2b$12$sPtmPW7ClLmKpcaINZdy8Os/oQwIR43s2iuz5A.jFvGszi5CloTdm',1769004453389245,NULL,'2026-01-21 14:07:33');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('408592f9f990495db91f5ad490c151f0','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0),('450bf23628d34d56aabe65f29d190c76','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('4dce6c721e184b13bd84cddd0e203a0d','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('9fe1cfb5a0c94e3f9373148450b42755','service','{}','service',1,'default','default',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=395 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,'42627a38f4314f97bb8aa038d0431c64',NULL,NULL,NULL,NULL,'2026-01-21 14:10:24',NULL,'2026-01-21 14:10:24',NULL,NULL),(2,NULL,NULL,'ee7505c13e224a2dba8d4c640e429fd9',NULL,NULL,NULL,NULL,'2026-01-21 14:10:24',NULL,'2026-01-21 14:10:24',NULL,NULL),(3,NULL,NULL,'b4cedcc40ad442e084cd3a4cd230506f',NULL,NULL,NULL,NULL,'2026-01-21 14:10:24',NULL,'2026-01-21 14:10:24',NULL,NULL),(4,NULL,NULL,'7b81f26ca34c44a694af5e24ace6d946',NULL,NULL,NULL,NULL,'2026-01-21 14:10:24',NULL,'2026-01-21 14:10:24',NULL,NULL),(5,NULL,'bb016556eecc46a3b8f4d9d4c57f3e42',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:10:28',NULL,'2026-01-21 14:10:28',NULL,NULL),(6,NULL,'208fb35344d048a1986780019cf60faa',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:10:29',NULL,'2026-01-21 14:10:29',NULL,NULL),(7,NULL,NULL,'19718582469642429302002210db69a2',NULL,NULL,NULL,NULL,'2026-01-21 14:10:30',NULL,'2026-01-21 14:10:30',NULL,NULL),(8,NULL,'8f3e0d396d2f44889a4034fad825a681',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:10:31',NULL,'2026-01-21 14:10:31',NULL,NULL),(9,NULL,NULL,'b04fe10708cc4548b68b2bc2ed56c979',NULL,NULL,NULL,NULL,'2026-01-21 14:10:31',NULL,'2026-01-21 14:10:31',NULL,NULL),(10,NULL,NULL,'5a73d58635f24f0395cbb66e80780cd3',NULL,NULL,NULL,NULL,'2026-01-21 14:10:35',NULL,'2026-01-21 14:10:35',NULL,NULL),(11,NULL,NULL,'150de356f40247f280c57856fdd80cc1',NULL,NULL,NULL,NULL,'2026-01-21 14:10:35',NULL,'2026-01-21 14:10:35',NULL,NULL),(12,NULL,NULL,'228bfc7fb13c47b380489bcd5430418f',NULL,NULL,NULL,NULL,'2026-01-21 14:10:37',NULL,'2026-01-21 14:10:37',NULL,NULL),(13,NULL,NULL,'1d8f4010c3cf48a0bf29d6b44accc150',NULL,NULL,NULL,NULL,'2026-01-21 14:10:37',NULL,'2026-01-21 14:10:37',NULL,NULL),(14,NULL,NULL,'88612755fd4c490c96b9c4b454fc53d5',NULL,NULL,NULL,NULL,'2026-01-21 14:10:37',NULL,'2026-01-21 14:10:37',NULL,NULL),(15,NULL,NULL,'5d7f2827b74d446e943b48be823e75b7',NULL,NULL,NULL,NULL,'2026-01-21 14:10:37',NULL,'2026-01-21 14:10:37',NULL,NULL),(16,NULL,NULL,'c585b1d2d5d64ff09f12475b01bfdb96',NULL,NULL,NULL,NULL,'2026-01-21 14:10:38',NULL,'2026-01-21 14:10:38',NULL,NULL),(17,NULL,'4a2fcb2eef364c78b1e854e8866eff91',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:10:38',NULL,'2026-01-21 14:10:38',NULL,NULL),(18,NULL,'e572f44fe308456cbc7572fb3e6de14a',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:10:39',NULL,'2026-01-21 14:10:39',NULL,NULL),(19,NULL,'69c55edfbbbb4300a9514dc11388eddc',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:10:40',NULL,'2026-01-21 14:10:40',NULL,NULL),(20,NULL,NULL,'69c2563de276497fa774a0596b86c6ea',NULL,NULL,NULL,NULL,'2026-01-21 14:10:40',NULL,'2026-01-21 14:10:40',NULL,NULL),(21,NULL,'e17b908e218c4cd78e47e6be458b89a4',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:10:41',NULL,'2026-01-21 14:10:41',NULL,NULL),(22,NULL,'5a55c2f8a6314c09b3c890fbc0f05acc',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:10:41',NULL,'2026-01-21 14:10:41',NULL,NULL),(23,NULL,'f12d797ab69245a49d1d3c8b1a1d1a56',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:10:42',NULL,'2026-01-21 14:10:42',NULL,NULL),(24,NULL,'689d6efce72f4b52a7bb3a7cf691526f',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:10:42',NULL,'2026-01-21 14:10:42',NULL,NULL),(25,NULL,'25182f2d153d4140867b49ea0c5064d3',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:10:42',NULL,'2026-01-21 14:10:42',NULL,NULL),(26,NULL,NULL,'ef745c59b81e4d36a1d9e07edef4f369',NULL,NULL,NULL,NULL,'2026-01-21 14:10:45',NULL,'2026-01-21 14:10:45',NULL,NULL),(27,NULL,NULL,'120a55487a84420e8a38457d781e0000',NULL,NULL,NULL,NULL,'2026-01-21 14:10:45',NULL,'2026-01-21 14:10:45',NULL,NULL),(28,NULL,NULL,'eb744aacb6844e309d601467d7b78e3f',NULL,NULL,NULL,NULL,'2026-01-21 14:10:46',NULL,'2026-01-21 14:10:46',NULL,NULL),(29,NULL,'e47455cf787b4c26aa7b529c772523c5',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:10:55',NULL,'2026-01-21 14:10:55',NULL,NULL),(30,NULL,'fd26316d0b544bb5a97b892695226415',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:10:55',NULL,'2026-01-21 14:10:55',NULL,NULL),(31,NULL,'43a435eb87ed4daaaa85c7ee37feb606',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:10:57',NULL,'2026-01-21 14:10:57',NULL,NULL),(32,NULL,NULL,'b763743775be4b47a15e79ada2485bc9',NULL,NULL,NULL,NULL,'2026-01-21 14:10:58',NULL,'2026-01-21 14:10:58',NULL,NULL),(33,NULL,NULL,'734a514c766e4c04a0ec5e4fb9ce0ff5',NULL,NULL,NULL,NULL,'2026-01-21 14:10:59',NULL,'2026-01-21 14:10:59',NULL,NULL),(34,NULL,'69e57c59b566460492a573d2f42e766a',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:11:01',NULL,'2026-01-21 14:11:01',NULL,NULL),(35,NULL,'ffe70dacfedd465389c3558dffdfed18',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:11:01',NULL,'2026-01-21 14:11:01',NULL,NULL),(36,NULL,NULL,'415ca277f7324b73b4ee7ebe90d83caa',NULL,NULL,NULL,NULL,'2026-01-21 14:11:03',NULL,'2026-01-21 14:11:03',NULL,NULL),(37,NULL,NULL,'02b82c0ecc5f4f6e8673af6efdd41b01',NULL,NULL,NULL,NULL,'2026-01-21 14:11:04',NULL,'2026-01-21 14:11:04',NULL,NULL),(38,NULL,'0ce2384776ec4c73affce27e7414fb9b',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:11:05',NULL,'2026-01-21 14:11:05',NULL,NULL),(39,NULL,'045ec3800eaa4fac8ccfb772802ea9be',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:11:05',NULL,'2026-01-21 14:11:05',NULL,NULL),(40,NULL,NULL,'1725b05d28d84c2aa406493ed5f167ef',NULL,NULL,NULL,NULL,'2026-01-21 14:11:11',NULL,'2026-01-21 14:11:11',NULL,NULL),(41,NULL,'9b8a07991aaf4cfa8fa44450fc1ffb4b',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:11:17',NULL,'2026-01-21 14:11:17',NULL,NULL),(42,NULL,NULL,'a6541c4cbb634db49634374f85dbab19',NULL,NULL,NULL,NULL,'2026-01-21 14:11:20',NULL,'2026-01-21 14:11:20',NULL,NULL),(43,NULL,'8c6b7d3aba3a46f797081d4d836666ee',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:11:21',NULL,'2026-01-21 14:11:21',NULL,NULL),(44,NULL,NULL,'a882c5a362294497a67a6e4a4631cb76',NULL,NULL,NULL,NULL,'2026-01-21 14:11:35',NULL,'2026-01-21 14:11:35',NULL,NULL),(45,NULL,'18bb008a1840444c9d68a413a43a3d81',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:11:38',NULL,'2026-01-21 14:11:38',NULL,NULL),(46,NULL,NULL,'ef6fb07e42db4a93b3111bd38f10fe99',NULL,NULL,NULL,NULL,'2026-01-21 14:11:54',NULL,'2026-01-21 14:11:54',NULL,NULL),(47,NULL,NULL,'64b23a942c084e1a9ecd54fc3b8e9ce0',NULL,NULL,NULL,NULL,'2026-01-21 14:11:56',NULL,'2026-01-21 14:11:56',NULL,NULL),(48,NULL,NULL,'1bd4fed2217b40e0bf03bf97fbc6e22b',NULL,NULL,NULL,NULL,'2026-01-21 14:11:56',NULL,'2026-01-21 14:11:56',NULL,NULL),(49,NULL,NULL,'98eb76bf8ab64142b94d7eff30f822d9',NULL,NULL,NULL,NULL,'2026-01-21 14:11:56',NULL,'2026-01-21 14:11:56',NULL,NULL),(50,NULL,'61c5e24fb0424631a59a92b02b059b8d',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:12:01',NULL,'2026-01-21 14:12:01',NULL,NULL),(51,NULL,NULL,'eabd986b9e274262a34ffc9cdfc09733',NULL,NULL,NULL,NULL,'2026-01-21 14:12:03',NULL,'2026-01-21 14:12:03',NULL,NULL),(52,NULL,'b4672f90c6b04396acf1897e9dda0572',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:12:03',NULL,'2026-01-21 14:12:03',NULL,NULL),(53,NULL,'be1f7cf07d7d4650b595c26295279fc2',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:12:11',NULL,'2026-01-21 14:12:11',NULL,NULL),(54,NULL,'50bb744aaa0a40ecbfeaa20d4e691f46',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:12:12',NULL,'2026-01-21 14:12:12',NULL,NULL),(55,NULL,NULL,'91a5b3e563184701bd5a4f2a997f8221',NULL,NULL,NULL,NULL,'2026-01-21 14:12:12',NULL,'2026-01-21 14:12:12',NULL,NULL),(56,NULL,NULL,'9f6fd3bf04e94f2d8e668d8e93cb0afa',NULL,NULL,NULL,NULL,'2026-01-21 14:12:16',NULL,'2026-01-21 14:12:16',NULL,NULL),(57,NULL,'2806d215025845bc90e195f0b5c64c21',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:12:17',NULL,'2026-01-21 14:12:17',NULL,NULL),(58,NULL,NULL,'aba5fb7f48d64e01a3694378a50f9c54',NULL,NULL,NULL,NULL,'2026-01-21 14:12:31',NULL,'2026-01-21 14:12:31',NULL,NULL),(59,NULL,'81d0568612894d6da94e01a77bfde64f',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:12:31',NULL,'2026-01-21 14:12:31',NULL,NULL),(60,NULL,NULL,'980dab1283e949b08283a3ca1880f58c',NULL,NULL,NULL,NULL,'2026-01-21 14:12:33',NULL,'2026-01-21 14:12:33',NULL,NULL),(61,NULL,NULL,'a5435667fadf4424b28031e93a081775',NULL,NULL,NULL,NULL,'2026-01-21 14:12:33',NULL,'2026-01-21 14:12:33',NULL,NULL),(62,NULL,NULL,'98bc4321e3154a83b6089614b5cc7354',NULL,NULL,NULL,NULL,'2026-01-21 14:12:33',NULL,'2026-01-21 14:12:33',NULL,NULL),(63,NULL,'91fa423674524226acfe253061607c0b',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:12:33',NULL,'2026-01-21 14:12:33',NULL,NULL),(64,NULL,NULL,'4d38cddb5de843cd8b50dd064d6370a9',NULL,NULL,NULL,NULL,'2026-01-21 14:12:34',NULL,'2026-01-21 14:12:34',NULL,NULL),(65,NULL,'a339f7e1ee674fafb5009a3eadd63d47',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:12:37',NULL,'2026-01-21 14:12:37',NULL,NULL),(66,NULL,NULL,'561f676f9fd94b9f83b47172d27f8e4d',NULL,NULL,NULL,NULL,'2026-01-21 14:12:40',NULL,'2026-01-21 14:12:40',NULL,NULL),(67,NULL,'fe8da51f9e2e4abb80350a111b2e3c24',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:12:45',NULL,'2026-01-21 14:12:45',NULL,NULL),(68,NULL,'8ea8a62d6efd4fdcac316c24e39fb155',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:12:46',NULL,'2026-01-21 14:12:46',NULL,NULL),(69,NULL,'daa1927a3ace42c190dee1e9d8009a13',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:12:46',NULL,'2026-01-21 14:12:46',NULL,NULL),(70,NULL,NULL,'5430056e4e8b448fac2d3068aa831d0d',NULL,NULL,NULL,NULL,'2026-01-21 14:12:47',NULL,'2026-01-21 14:12:47',NULL,NULL),(71,NULL,NULL,'6e9999bd9ff5404bbcb4506e36d95c2d',NULL,NULL,NULL,NULL,'2026-01-21 14:12:47',NULL,'2026-01-21 14:12:47',NULL,NULL),(72,NULL,NULL,'b5fd600a7dab49b49454834378fa2ca7',NULL,NULL,NULL,NULL,'2026-01-21 14:12:47',NULL,'2026-01-21 14:12:47',NULL,NULL),(73,NULL,NULL,'dfa2a6a7bfd3403598b938a13251049b',NULL,NULL,NULL,NULL,'2026-01-21 14:12:48',NULL,'2026-01-21 14:12:48',NULL,NULL),(74,NULL,'fa64a63fa5d2448a9231efc2bcbaff32',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:12:49',NULL,'2026-01-21 14:12:49',NULL,NULL),(75,NULL,'60b21277b6f94a48b54b6ac656b5d67e',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:12:50',NULL,'2026-01-21 14:12:50',NULL,NULL),(76,NULL,'904f511c91d24e66a06441fbd98e890e',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:12:53',NULL,'2026-01-21 14:12:53',NULL,NULL),(77,NULL,NULL,'43cfb6507e88484890c6ba97ce2bc648',NULL,NULL,NULL,NULL,'2026-01-21 14:12:54',NULL,'2026-01-21 14:12:54',NULL,NULL),(78,NULL,NULL,'29a6968c7bc546daa3b0d6f66d78b47d',NULL,NULL,NULL,NULL,'2026-01-21 14:12:57',NULL,'2026-01-21 14:12:57',NULL,NULL),(79,NULL,'1b3742f5641b4b52b073a4c45690b91a',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:13:01',NULL,'2026-01-21 14:13:01',NULL,NULL),(80,NULL,NULL,'ddb03f287bb94dd7a7faa2069b951af0',NULL,NULL,NULL,NULL,'2026-01-21 14:13:01',NULL,'2026-01-21 14:13:01',NULL,NULL),(81,NULL,NULL,'b5651ae0357f46e9b7345b23eb46bb87',NULL,NULL,NULL,NULL,'2026-01-21 14:13:02',NULL,'2026-01-21 14:13:02',NULL,NULL),(82,NULL,NULL,'10424ef24b6e43b7984121d7f43bcbbe',NULL,NULL,NULL,NULL,'2026-01-21 14:13:03',NULL,'2026-01-21 14:13:03',NULL,NULL),(83,NULL,NULL,'296b3ba1092e47d48708162556c13492',NULL,NULL,NULL,NULL,'2026-01-21 14:13:03',NULL,'2026-01-21 14:13:03',NULL,NULL),(84,NULL,'8f23a9ff8e6249a7b232ba280b7bee1d',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:13:05',NULL,'2026-01-21 14:13:05',NULL,NULL),(85,NULL,'caa0567d8ba746acbb107c4763113626',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:13:06',NULL,'2026-01-21 14:13:06',NULL,NULL),(86,NULL,'64938da360204e688907e8cdb534bac3',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:13:07',NULL,'2026-01-21 14:13:07',NULL,NULL),(87,NULL,NULL,'9cf6ac7eae95486caefe1f00101f1cdd',NULL,NULL,NULL,NULL,'2026-01-21 14:13:07',NULL,'2026-01-21 14:13:07',NULL,NULL),(88,NULL,NULL,'ef447f4361544e118e572a53dd2f99b3',NULL,NULL,NULL,NULL,'2026-01-21 14:13:08',NULL,'2026-01-21 14:13:08',NULL,NULL),(89,NULL,NULL,'b9bfed6e407f4592b8be12c0d224789c',NULL,NULL,NULL,NULL,'2026-01-21 14:13:08',NULL,'2026-01-21 14:13:08',NULL,NULL),(90,NULL,NULL,'9be313018d6249069121f830bd1bce00',NULL,NULL,NULL,NULL,'2026-01-21 14:13:12',NULL,'2026-01-21 14:13:12',NULL,NULL),(91,NULL,NULL,'d379b48b6a3b403fb286a1f9a3af9244',NULL,NULL,NULL,NULL,'2026-01-21 14:13:12',NULL,'2026-01-21 14:13:12',NULL,NULL),(92,NULL,'248f7e8b81bf41be848a02eb4bf2133a',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:13:13',NULL,'2026-01-21 14:13:13',NULL,NULL),(93,NULL,NULL,'7f220c7272614ea49eb86d8b36f4c14f',NULL,NULL,NULL,NULL,'2026-01-21 14:13:14',NULL,'2026-01-21 14:13:14',NULL,NULL),(94,NULL,NULL,'35db38a15abe40a295df7c3547bde530',NULL,NULL,NULL,NULL,'2026-01-21 14:13:14',NULL,'2026-01-21 14:13:14',NULL,NULL),(95,NULL,'4faa2ddbfb954f8280a033ca80afb96c',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:13:15',NULL,'2026-01-21 14:13:15',NULL,NULL),(96,NULL,NULL,'9483007bf98b4f2d9bba7822bb608e5b',NULL,NULL,NULL,NULL,'2026-01-21 14:13:15',NULL,'2026-01-21 14:13:15',NULL,NULL),(97,NULL,'0e2ec07a880f4c5aacb4bfe2c0dae058',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:13:15',NULL,'2026-01-21 14:13:15',NULL,NULL),(98,NULL,NULL,'a0672e98f4144413a0f7f662605555ca',NULL,NULL,NULL,NULL,'2026-01-21 14:13:15',NULL,'2026-01-21 14:13:15',NULL,NULL),(99,NULL,'2f54c7129d93417a802569e6ed88b4b1',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:13:16',NULL,'2026-01-21 14:13:16',NULL,NULL),(100,NULL,'be1b77ea1d0645118006aa3222dc88be',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:13:16',NULL,'2026-01-21 14:13:16',NULL,NULL),(101,NULL,'5da033845de7469096a0943fc3046311',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:13:18',NULL,'2026-01-21 14:13:18',NULL,NULL),(102,NULL,NULL,'c3b2b780b0644b419dbbe5f9b823dcfb',NULL,NULL,NULL,NULL,'2026-01-21 14:13:20',NULL,'2026-01-21 14:13:20',NULL,NULL),(103,NULL,'891f44294a7349bebe9d03a161e85ff8',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:13:20',NULL,'2026-01-21 14:13:20',NULL,NULL),(104,NULL,'75a76cc477654725b32c43289a83fc8f',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:13:21',NULL,'2026-01-21 14:13:21',NULL,NULL),(105,NULL,'b35a8154480c4106bba1f807564320e6',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:13:21',NULL,'2026-01-21 14:13:21',NULL,NULL),(106,NULL,NULL,'c6c8a810fd924928b3bea8310dfe9d8a',NULL,NULL,NULL,NULL,'2026-01-21 14:13:21',NULL,'2026-01-21 14:13:21',NULL,NULL),(107,NULL,'7d22112c054f4cc6ae1dd492b8ddab2f',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:13:23',NULL,'2026-01-21 14:13:23',NULL,NULL),(108,NULL,NULL,'c94784fa7452411e8fc5a8052d638984',NULL,NULL,NULL,NULL,'2026-01-21 14:13:23',NULL,'2026-01-21 14:13:23',NULL,NULL),(109,NULL,'74d299646bb6472580c1cd1d5192f54b',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:13:26',NULL,'2026-01-21 14:13:26',NULL,NULL),(110,NULL,NULL,'3b6f471dc46345c2a565b9da7fb144dc',NULL,NULL,NULL,NULL,'2026-01-21 14:13:27',NULL,'2026-01-21 14:13:27',NULL,NULL),(111,NULL,'189dd22c077947f39b36ab2091a2566e',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:13:29',NULL,'2026-01-21 14:13:29',NULL,NULL),(112,NULL,NULL,'7462bbce50a04ba5b49af22315a70b13',NULL,NULL,NULL,NULL,'2026-01-21 14:13:29',NULL,'2026-01-21 14:13:29',NULL,NULL),(113,NULL,'ddf35ebcd81441f48535894e19dd68f7',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:13:31',NULL,'2026-01-21 14:13:31',NULL,NULL),(114,NULL,NULL,'96544551592a4f219ae68cb618995d2b',NULL,NULL,NULL,NULL,'2026-01-21 14:13:31',NULL,'2026-01-21 14:13:31',NULL,NULL),(115,NULL,NULL,'371332db2a2c453ea215c3980707fbd6',NULL,NULL,NULL,NULL,'2026-01-21 14:13:32',NULL,'2026-01-21 14:13:32',NULL,NULL),(116,NULL,NULL,'b020af4acf6c46669264d3692bde318e',NULL,NULL,NULL,NULL,'2026-01-21 14:13:32',NULL,'2026-01-21 14:13:32',NULL,NULL),(117,NULL,NULL,'e03f1d50dcb049cfa83bce8b76369eb7',NULL,NULL,NULL,NULL,'2026-01-21 14:13:32',NULL,'2026-01-21 14:13:32',NULL,NULL),(118,NULL,'13c5ce7776694d3ba842a33559f0ce31',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:13:33',NULL,'2026-01-21 14:13:33',NULL,NULL),(119,NULL,NULL,'cc3ce931ea874625877b84ec44bbff9b',NULL,NULL,NULL,NULL,'2026-01-21 14:13:33',NULL,'2026-01-21 14:13:33',NULL,NULL),(120,NULL,'a3b429928a5843a5b5996c1d8c1421f3',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:13:34',NULL,'2026-01-21 14:13:34',NULL,NULL),(121,NULL,'8895417a23f6490f9859410d8a4d3cd5',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:13:34',NULL,'2026-01-21 14:13:34',NULL,NULL),(122,NULL,'938ff6c62b4d4bfe9c13b015ab84e14b',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:13:35',NULL,'2026-01-21 14:13:35',NULL,NULL),(123,NULL,NULL,'08c3bbbd7ed046baacd9b11d383c5ae9',NULL,NULL,NULL,NULL,'2026-01-21 14:14:01',NULL,'2026-01-21 14:14:01',NULL,NULL),(124,NULL,NULL,'54bd2d99c737409a8cdb47d0ef61c0af',NULL,NULL,NULL,NULL,'2026-01-21 14:14:02',NULL,'2026-01-21 14:14:02',NULL,NULL),(125,NULL,NULL,'6fc9e38a391d41b1bce34dc4cb926a6d',NULL,NULL,NULL,NULL,'2026-01-21 14:14:03',NULL,'2026-01-21 14:14:03',NULL,NULL),(126,NULL,NULL,'c19488bbbf72409483fd4e61f2c279b2',NULL,NULL,NULL,NULL,'2026-01-21 14:14:03',NULL,'2026-01-21 14:14:03',NULL,NULL),(127,NULL,NULL,'4511d38bd68247eba9208759779e446e',NULL,NULL,NULL,NULL,'2026-01-21 14:14:03',NULL,'2026-01-21 14:14:03',NULL,NULL),(128,NULL,'bf58a5c191654263a44f73287e2a242e',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:14:04',NULL,'2026-01-21 14:14:04',NULL,NULL),(129,NULL,'1812e512403748bd8d20cf83682d6ecb',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:14:04',NULL,'2026-01-21 14:14:04',NULL,NULL),(130,NULL,'f1f74a46300f4957a145b46d3a2ec58d',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:14:07',NULL,'2026-01-21 14:14:07',NULL,NULL),(131,NULL,'d4bd3474c8454154beb553b584435d55',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:14:08',NULL,'2026-01-21 14:14:08',NULL,NULL),(132,NULL,NULL,'8666d037e84840d8a30be8fd80ce752a',NULL,NULL,NULL,NULL,'2026-01-21 14:14:17',NULL,'2026-01-21 14:14:17',NULL,NULL),(133,NULL,NULL,'88cc26cb7c4a4a38b32d79acbf3e84a9',NULL,NULL,NULL,NULL,'2026-01-21 14:14:26',NULL,'2026-01-21 14:14:26',NULL,NULL),(134,NULL,NULL,'111328e7e8c9499f9dd897f7f644b965',NULL,NULL,NULL,NULL,'2026-01-21 14:14:26',NULL,'2026-01-21 14:14:26',NULL,NULL),(135,NULL,NULL,'1c31351d8965468cb12d6d6a87c0f8fc',NULL,NULL,NULL,NULL,'2026-01-21 14:14:26',NULL,'2026-01-21 14:14:26',NULL,NULL),(136,NULL,NULL,'0f49b0d1ba944c46946a092657f6b0f2',NULL,NULL,NULL,NULL,'2026-01-21 14:14:26',NULL,'2026-01-21 14:14:26',NULL,NULL),(137,NULL,'79952fad07e54cf18c5f2c207bdbf9fb',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:14:27',NULL,'2026-01-21 14:14:27',NULL,NULL),(138,NULL,'63bf9e7d467e4b998e13dd207e54acf0',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:14:27',NULL,'2026-01-21 14:14:27',NULL,NULL),(139,NULL,'d8fea3bdb3ee4c03a1197b6e46ed71bc',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:14:29',NULL,'2026-01-21 14:14:29',NULL,NULL),(140,NULL,NULL,'54b0820a6e484b2cbc433f8fbeceeb36',NULL,NULL,NULL,NULL,'2026-01-21 14:14:29',NULL,'2026-01-21 14:14:29',NULL,NULL),(141,NULL,'ee221b4be6e54a1bb68f257f5d74ccd5',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:14:30',NULL,'2026-01-21 14:14:30',NULL,NULL),(142,NULL,'e4137fbad35640c7b31753670e510c19',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:14:31',NULL,'2026-01-21 14:14:31',NULL,NULL),(143,NULL,NULL,'1a91fb438908466d8fdc8d51066886da',NULL,NULL,NULL,NULL,'2026-01-21 14:14:33',NULL,'2026-01-21 14:14:33',NULL,NULL),(144,NULL,'3e6f00bc49d84ec6ac0dce392ec11ba2',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:14:35',NULL,'2026-01-21 14:14:35',NULL,NULL),(145,NULL,NULL,'692a441814ac4b82be2e8c67b5ddbe6f',NULL,NULL,NULL,NULL,'2026-01-21 14:14:35',NULL,'2026-01-21 14:14:35',NULL,NULL),(146,NULL,NULL,'08b65b71493b4e308f90701ae466cc99',NULL,NULL,NULL,NULL,'2026-01-21 14:14:38',NULL,'2026-01-21 14:14:38',NULL,NULL),(147,NULL,NULL,'905a1b7b3d564aff8a845738129ed2b6',NULL,NULL,NULL,NULL,'2026-01-21 14:14:38',NULL,'2026-01-21 14:14:38',NULL,NULL),(148,NULL,'aaa62a90ea4b473e881ada9ecf177255',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:14:39',NULL,'2026-01-21 14:14:39',NULL,NULL),(149,NULL,NULL,'18d829f19dd445aa98c02d30c005b747',NULL,NULL,NULL,NULL,'2026-01-21 14:14:40',NULL,'2026-01-21 14:14:40',NULL,NULL),(150,NULL,NULL,'2f5f883d4bc94b9c96ff6d3cd5c5c312',NULL,NULL,NULL,NULL,'2026-01-21 14:14:41',NULL,'2026-01-21 14:14:41',NULL,NULL),(151,NULL,NULL,'8c6d60c554124a13bd2760aaa5aee2e1',NULL,NULL,NULL,NULL,'2026-01-21 14:14:41',NULL,'2026-01-21 14:14:41',NULL,NULL),(152,NULL,NULL,'f008c1282ce84d87b3f3ddf192a932ea',NULL,NULL,NULL,NULL,'2026-01-21 14:14:41',NULL,'2026-01-21 14:14:41',NULL,NULL),(153,NULL,NULL,'b4c32c9c7b1047fc890e37a5372183aa',NULL,NULL,NULL,NULL,'2026-01-21 14:14:42',NULL,'2026-01-21 14:14:42',NULL,NULL),(154,NULL,NULL,'21c03b750d2248efa60320acf7cf8ddd',NULL,NULL,NULL,NULL,'2026-01-21 14:14:42',NULL,'2026-01-21 14:14:42',NULL,NULL),(155,NULL,'285db46a64ef4b1cb145bba35672433b',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:14:42',NULL,'2026-01-21 14:14:42',NULL,NULL),(156,NULL,NULL,'2b308b43a8404cc1a8e2575b7d7cf938',NULL,NULL,NULL,NULL,'2026-01-21 14:14:43',NULL,'2026-01-21 14:14:43',NULL,NULL),(157,NULL,'498aac0871e5417786fbc3341cc80fbf',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:14:43',NULL,'2026-01-21 14:14:43',NULL,NULL),(158,NULL,'12d659665d804266a99bf6e03ecc29b9',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:14:44',NULL,'2026-01-21 14:14:44',NULL,NULL),(159,NULL,'42f926cfde224068a742ef536ed79928',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:14:44',NULL,'2026-01-21 14:14:44',NULL,NULL),(160,NULL,'236dedfa65b0456e95607c65c7d0ec21',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:14:45',NULL,'2026-01-21 14:14:45',NULL,NULL),(161,NULL,'6cdf50349af44e52adde833e63cb07c3',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:14:45',NULL,'2026-01-21 14:14:45',NULL,NULL),(162,NULL,'965a5c37125642708cdb78117dad59f5',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:14:48',NULL,'2026-01-21 14:14:48',NULL,NULL),(163,NULL,NULL,'95702c7f05ff4f4c913ab459fb5f01ee',NULL,NULL,NULL,NULL,'2026-01-21 14:15:05',NULL,'2026-01-21 14:15:05',NULL,NULL),(164,NULL,NULL,'898bcc3dcc3f4bcbbc9d4f5e8650a71f',NULL,NULL,NULL,NULL,'2026-01-21 14:15:06',NULL,'2026-01-21 14:15:06',NULL,NULL),(165,NULL,NULL,'29824244ca994d38a91f46f7cb52ca0f',NULL,NULL,NULL,NULL,'2026-01-21 14:15:09',NULL,'2026-01-21 14:15:09',NULL,NULL),(166,NULL,NULL,'80bd0c2483b2418fa6bc56b40d52543e',NULL,NULL,NULL,NULL,'2026-01-21 14:15:12',NULL,'2026-01-21 14:15:12',NULL,NULL),(167,NULL,NULL,'65c070abc6a145b69f58157a970729c5',NULL,NULL,NULL,NULL,'2026-01-21 14:15:13',NULL,'2026-01-21 14:15:13',NULL,NULL),(168,NULL,NULL,'691428d7711d49218388c97727044c76',NULL,NULL,NULL,NULL,'2026-01-21 14:15:17',NULL,'2026-01-21 14:15:17',NULL,NULL),(169,NULL,'067288c681f8495498f05a35a65a52fa',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:15:17',NULL,'2026-01-21 14:15:17',NULL,NULL),(170,NULL,NULL,'094fbfd71dab40a5825010f843ad6dfe',NULL,NULL,NULL,NULL,'2026-01-21 14:15:17',NULL,'2026-01-21 14:15:17',NULL,NULL),(171,NULL,NULL,'c3f9477477b7490d83b45a1d94cb30eb',NULL,NULL,NULL,NULL,'2026-01-21 14:15:18',NULL,'2026-01-21 14:15:18',NULL,NULL),(172,NULL,'c9bb1f7073a64c7f8a1a47ae8a027ec8',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:15:22',NULL,'2026-01-21 14:15:22',NULL,NULL),(173,NULL,'28d69e0c83c84d03bcfbc4f9c9057023',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:15:23',NULL,'2026-01-21 14:15:23',NULL,NULL),(174,NULL,'ef367d46915e42899003255d11c5ebdd',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:15:23',NULL,'2026-01-21 14:15:23',NULL,NULL),(175,NULL,'451047ec603a4268807ef30160b19d08',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:15:23',NULL,'2026-01-21 14:15:23',NULL,NULL),(176,NULL,'ba683803c6da4199889668373208d67d',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:15:24',NULL,'2026-01-21 14:15:24',NULL,NULL),(177,NULL,NULL,'7ec6da0c8e2440dd868b66e47f688d9a',NULL,NULL,NULL,NULL,'2026-01-21 14:15:26',NULL,'2026-01-21 14:15:26',NULL,NULL),(178,NULL,NULL,'c6254cd94fbf4d5a8ed43f651e16e2c6',NULL,NULL,NULL,NULL,'2026-01-21 14:15:27',NULL,'2026-01-21 14:15:27',NULL,NULL),(179,NULL,'c7a3fd056fd440d6bf1503c0e30e9b63',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:15:27',NULL,'2026-01-21 14:15:27',NULL,NULL),(180,NULL,'bef4973bb4b74bb8a607ce14f2adc5d3',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:15:28',NULL,'2026-01-21 14:15:28',NULL,NULL),(181,NULL,NULL,'9c10de2ebafa4c568f53a358adc22f39',NULL,NULL,NULL,NULL,'2026-01-21 14:15:29',NULL,'2026-01-21 14:15:29',NULL,NULL),(182,NULL,NULL,'11cecd8dfe964dea9e0460c187ff9563',NULL,NULL,NULL,NULL,'2026-01-21 14:15:30',NULL,'2026-01-21 14:15:30',NULL,NULL),(183,NULL,'e4d179aa0b3b4a7994b2ad60b440aceb',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:15:31',NULL,'2026-01-21 14:15:31',NULL,NULL),(184,NULL,'479cfaf277564bda8bf06162366283ff',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:15:32',NULL,'2026-01-21 14:15:32',NULL,NULL),(185,NULL,NULL,'1582fd57caf04d9188d3b72ecfc4ddd8',NULL,NULL,NULL,NULL,'2026-01-21 14:15:34',NULL,'2026-01-21 14:15:34',NULL,NULL),(186,NULL,'c55f56602b994198b2b9437533a437d7',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:15:35',NULL,'2026-01-21 14:15:35',NULL,NULL),(187,NULL,NULL,'1391c32d81544c6d87c3c26c6bb4ac2d',NULL,NULL,NULL,NULL,'2026-01-21 14:15:38',NULL,'2026-01-21 14:15:38',NULL,NULL),(188,NULL,NULL,'3b5afeab723b4cc7841de33f81ae1c08',NULL,NULL,NULL,NULL,'2026-01-21 14:15:39',NULL,'2026-01-21 14:15:39',NULL,NULL),(189,NULL,NULL,'6fd0576a9bd343429ca79cd389442228',NULL,NULL,NULL,NULL,'2026-01-21 14:15:39',NULL,'2026-01-21 14:15:39',NULL,NULL),(190,NULL,NULL,'2dcdb501628141d49aa722b426ce72c0',NULL,NULL,NULL,NULL,'2026-01-21 14:15:39',NULL,'2026-01-21 14:15:39',NULL,NULL),(191,NULL,NULL,'3457dc353d2542b48b36c77e4c9135c8',NULL,NULL,NULL,NULL,'2026-01-21 14:15:40',NULL,'2026-01-21 14:15:40',NULL,NULL),(192,NULL,'3fc18c22b9f340dfa895b33b0ca00b41',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:15:40',NULL,'2026-01-21 14:15:40',NULL,NULL),(193,NULL,'b4a571ae4eec45b9b24ab70f80d95d96',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:15:41',NULL,'2026-01-21 14:15:41',NULL,NULL),(194,NULL,'206a12c19bf2472b9f6416610e66e80c',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:15:42',NULL,'2026-01-21 14:15:42',NULL,NULL),(195,NULL,NULL,'1a5e769aae5047f2b658c4a43271fd58',NULL,NULL,NULL,NULL,'2026-01-21 14:15:42',NULL,'2026-01-21 14:15:42',NULL,NULL),(196,NULL,'a326a0be5e7c4aed8925f4c9ae42b0af',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:15:42',NULL,'2026-01-21 14:15:42',NULL,NULL),(197,NULL,'fc6a6ef7261044c086ada7ecee510df4',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:15:43',NULL,'2026-01-21 14:15:43',NULL,NULL),(198,NULL,NULL,'2da78f48e3214733b082ba0c1b3b0fff',NULL,NULL,NULL,NULL,'2026-01-21 14:15:51',NULL,'2026-01-21 14:15:51',NULL,NULL),(199,NULL,NULL,'293519a837134c9eb5c1064ac437ea0d',NULL,NULL,NULL,NULL,'2026-01-21 14:15:52',NULL,'2026-01-21 14:15:52',NULL,NULL),(200,NULL,NULL,'14e9868b3b7244ff89929111eaaf382c',NULL,NULL,NULL,NULL,'2026-01-21 14:15:52',NULL,'2026-01-21 14:15:52',NULL,NULL),(201,NULL,NULL,'f9134499f84f4bf789fe1fc4a7322533',NULL,NULL,NULL,NULL,'2026-01-21 14:15:52',NULL,'2026-01-21 14:15:52',NULL,NULL),(202,NULL,'e564b97ee9594256ae7ad401e2e84d33',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:15:53',NULL,'2026-01-21 14:15:53',NULL,NULL),(203,NULL,'58a3e7944b2a44b488d46c5f859def32',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:15:54',NULL,'2026-01-21 14:15:54',NULL,NULL),(204,NULL,'4a0c0065226042eaac70e4756955e590',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:15:55',NULL,'2026-01-21 14:15:55',NULL,NULL),(205,NULL,NULL,'a06726757dba4059be25559e60764b65',NULL,NULL,NULL,NULL,'2026-01-21 14:16:04',NULL,'2026-01-21 14:16:04',NULL,NULL),(206,NULL,NULL,'e98a65c358ff470b949414cd13a3245a',NULL,NULL,NULL,NULL,'2026-01-21 14:16:06',NULL,'2026-01-21 14:16:06',NULL,NULL),(207,NULL,NULL,'2b08a54befda49ee9ee36d8d98cca64a',NULL,NULL,NULL,NULL,'2026-01-21 14:16:06',NULL,'2026-01-21 14:16:06',NULL,NULL),(208,NULL,NULL,'b1df025cc11c4b709014b7559b07a793',NULL,NULL,NULL,NULL,'2026-01-21 14:16:06',NULL,'2026-01-21 14:16:06',NULL,NULL),(209,NULL,'e8573ffed0994ab9a0ffc21aedaaee25',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:16:07',NULL,'2026-01-21 14:16:07',NULL,NULL),(210,NULL,'92310dd9a58d4b52bd58372cc6bcd1e4',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:16:08',NULL,'2026-01-21 14:16:08',NULL,NULL),(211,NULL,'a7c6c7c42b5d4ca3933e833a80ca4f97',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:16:09',NULL,'2026-01-21 14:16:09',NULL,NULL),(212,NULL,NULL,'4b5983154fc643288fc727e3e2e8deeb',NULL,NULL,NULL,NULL,'2026-01-21 14:16:10',NULL,'2026-01-21 14:16:10',NULL,NULL),(213,NULL,NULL,'f07a91bc02124be4adc5d225bf9de898',NULL,NULL,NULL,NULL,'2026-01-21 14:16:10',NULL,'2026-01-21 14:16:10',NULL,NULL),(214,NULL,NULL,'019c05e449334ed6943f737c7efb579c',NULL,NULL,NULL,NULL,'2026-01-21 14:16:12',NULL,'2026-01-21 14:16:12',NULL,NULL),(215,NULL,NULL,'90415a0f3d4e49cba79c941b229a5421',NULL,NULL,NULL,NULL,'2026-01-21 14:16:12',NULL,'2026-01-21 14:16:12',NULL,NULL),(216,NULL,NULL,'e4c5b5bff6d34764b463bc7c968628e6',NULL,NULL,NULL,NULL,'2026-01-21 14:16:13',NULL,'2026-01-21 14:16:13',NULL,NULL),(217,NULL,NULL,'1d9340b6b4b74f75b34a2b5167cb11c9',NULL,NULL,NULL,NULL,'2026-01-21 14:16:13',NULL,'2026-01-21 14:16:13',NULL,NULL),(218,NULL,'fe6ecb2e1f884cbc9c68fd817770b598',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:16:14',NULL,'2026-01-21 14:16:14',NULL,NULL),(219,NULL,NULL,'47292555c1b142f8967d2205628edba1',NULL,NULL,NULL,NULL,'2026-01-21 14:16:19',NULL,'2026-01-21 14:16:19',NULL,NULL),(220,NULL,'4bd635a5dcc14e2b9d854dd0e78ecc0a',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:16:19',NULL,'2026-01-21 14:16:19',NULL,NULL),(221,NULL,NULL,'8a6f93a8a18f46399e42ee548ac4ec3f',NULL,NULL,NULL,NULL,'2026-01-21 14:16:19',NULL,'2026-01-21 14:16:19',NULL,NULL),(222,NULL,NULL,'e3e594883dea4c21973f5ee9b632bd35',NULL,NULL,NULL,NULL,'2026-01-21 14:16:20',NULL,'2026-01-21 14:16:20',NULL,NULL),(223,NULL,'9706b90ceb3b46678324d74c1b285687',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:16:20',NULL,'2026-01-21 14:16:20',NULL,NULL),(224,NULL,'4e8fa7a25332473d862da2961c16f506',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:16:21',NULL,'2026-01-21 14:16:21',NULL,NULL),(225,NULL,'1033ea579ccf4fc5808bd0b371a1f1da',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:16:22',NULL,'2026-01-21 14:16:22',NULL,NULL),(226,NULL,'a226ad4df79b48a2b4c6ddc1ed2cb474',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:16:23',NULL,'2026-01-21 14:16:23',NULL,NULL),(227,NULL,NULL,'8b6d0acdfaa04cb98498dd6fd27045d2',NULL,NULL,NULL,NULL,'2026-01-21 14:16:34',NULL,'2026-01-21 14:16:34',NULL,NULL),(228,NULL,NULL,'1ef074ee6470440697a21fef250bac39',NULL,NULL,NULL,NULL,'2026-01-21 14:16:39',NULL,'2026-01-21 14:16:39',NULL,NULL),(229,NULL,NULL,'fe53deaff858414dbf5f5b206fd69056',NULL,NULL,NULL,NULL,'2026-01-21 14:16:40',NULL,'2026-01-21 14:16:40',NULL,NULL),(230,NULL,NULL,'9618fae463a3456ab00f4dd42464d5b5',NULL,NULL,NULL,NULL,'2026-01-21 14:16:40',NULL,'2026-01-21 14:16:40',NULL,NULL),(231,NULL,'920f7398bc954a8c843f83308f35cb79',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:16:43',NULL,'2026-01-21 14:16:43',NULL,NULL),(232,NULL,'8170a1b3ee244e20950ea119437c9696',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:16:45',NULL,'2026-01-21 14:16:45',NULL,NULL),(233,NULL,'00ad6a9aaa7a46e98273aa36df95068c',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:16:47',NULL,'2026-01-21 14:16:47',NULL,NULL),(234,NULL,NULL,'1e36f40dbb4a41dfa0a09d53e38a09a3',NULL,NULL,NULL,NULL,'2026-01-21 14:16:55',NULL,'2026-01-21 14:16:55',NULL,NULL),(235,NULL,'78145dbf5c284a599c7efda43d8f4201',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:17:02',NULL,'2026-01-21 14:17:02',NULL,NULL),(236,NULL,NULL,'8ea7e6cddb304b81b50172522efdcf70',NULL,NULL,NULL,NULL,'2026-01-21 14:17:20',NULL,'2026-01-21 14:17:20',NULL,NULL),(237,NULL,NULL,'9a2f0c528668499db7c5fb089f64e301',NULL,NULL,NULL,NULL,'2026-01-21 14:17:20',NULL,'2026-01-21 14:17:20',NULL,NULL),(238,NULL,NULL,'5b82aab7825049b98c501e132b34bfa2',NULL,NULL,NULL,NULL,'2026-01-21 14:17:21',NULL,'2026-01-21 14:17:21',NULL,NULL),(239,NULL,NULL,'12da713099134baead7eac46fab92c0d',NULL,NULL,NULL,NULL,'2026-01-21 14:17:21',NULL,'2026-01-21 14:17:21',NULL,NULL),(240,NULL,NULL,'67c225430a3b4452afea3a3b62eaf8e9',NULL,NULL,NULL,NULL,'2026-01-21 14:17:23',NULL,'2026-01-21 14:17:23',NULL,NULL),(241,NULL,'12f72ef945cc4adbb18b25d146f29e19',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:17:24',NULL,'2026-01-21 14:17:24',NULL,NULL),(242,NULL,NULL,'6cb2e0df2e5e4f68acb0a95b2439997b',NULL,NULL,NULL,NULL,'2026-01-21 14:17:24',NULL,'2026-01-21 14:17:24',NULL,NULL),(243,NULL,NULL,'14b1b7ca69c94906ab006f47db3af123',NULL,NULL,NULL,NULL,'2026-01-21 14:17:24',NULL,'2026-01-21 14:17:24',NULL,NULL),(244,NULL,NULL,'5ee8d264d70c4222b4a9c5b60523ed5b',NULL,NULL,NULL,NULL,'2026-01-21 14:17:24',NULL,'2026-01-21 14:17:24',NULL,NULL),(245,NULL,'e1de231dd9604e8bb9706202a8524575',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:17:25',NULL,'2026-01-21 14:17:25',NULL,NULL),(246,NULL,'3fdd89fc56bc4e1e80efe02dccfd1c88',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:17:26',NULL,'2026-01-21 14:17:26',NULL,NULL),(247,NULL,'265133ca5c98414893ceadef10ae55fd',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:17:26',NULL,'2026-01-21 14:17:26',NULL,NULL),(248,NULL,'e5bede18d60e4bb389fabc44847d9a1a',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:17:27',NULL,'2026-01-21 14:17:27',NULL,NULL),(249,NULL,'7082e34f517e479cba6e2abeac710db8',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:17:30',NULL,'2026-01-21 14:17:30',NULL,NULL),(250,NULL,NULL,'1a618c59cc4f4422a8c6e97671c362e1',NULL,NULL,NULL,NULL,'2026-01-21 14:17:38',NULL,'2026-01-21 14:17:38',NULL,NULL),(251,NULL,NULL,'c9132702f2324cf7b8026c09a5d89dee',NULL,NULL,NULL,NULL,'2026-01-21 14:17:53',NULL,'2026-01-21 14:17:53',NULL,NULL),(252,NULL,NULL,'53e1b03c59294270a311e7426f54bef6',NULL,NULL,NULL,NULL,'2026-01-21 14:17:53',NULL,'2026-01-21 14:17:53',NULL,NULL),(253,NULL,NULL,'5b3d57e6c4dc49f18e3cac6b880678ac',NULL,NULL,NULL,NULL,'2026-01-21 14:17:53',NULL,'2026-01-21 14:17:53',NULL,NULL),(254,NULL,'183d8c03d481485397037ffe17a60995',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:17:58',NULL,'2026-01-21 14:17:58',NULL,NULL),(255,NULL,'6b53653c238d45b18082508e065d099c',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:18:00',NULL,'2026-01-21 14:18:00',NULL,NULL),(256,NULL,'d94c30b7707d438da5bc29018aae24d1',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:18:03',NULL,'2026-01-21 14:18:03',NULL,NULL),(257,NULL,NULL,'db5e28bfe60c4ef4a854a3cebac03189',NULL,NULL,NULL,NULL,'2026-01-21 14:18:26',NULL,'2026-01-21 14:18:26',NULL,NULL),(258,NULL,NULL,'f3ba781794ce45c0b1298c9ef8ce95d7',NULL,NULL,NULL,NULL,'2026-01-21 14:18:31',NULL,'2026-01-21 14:18:31',NULL,NULL),(259,NULL,NULL,'864d60b72f854b56b7667cd12bb74c21',NULL,NULL,NULL,NULL,'2026-01-21 14:18:32',NULL,'2026-01-21 14:18:32',NULL,NULL),(260,NULL,NULL,'847ff8e5688c42c1bb942b9ed884ef49',NULL,NULL,NULL,NULL,'2026-01-21 14:18:32',NULL,'2026-01-21 14:18:32',NULL,NULL),(261,NULL,NULL,'e7526c7aeb034e5c89b26de1c4b99bf9',NULL,NULL,NULL,NULL,'2026-01-21 14:18:33',NULL,'2026-01-21 14:18:33',NULL,NULL),(262,NULL,NULL,'c8fc2a8f3e8c4cda811de2ca83b023b9',NULL,NULL,NULL,NULL,'2026-01-21 14:18:33',NULL,'2026-01-21 14:18:33',NULL,NULL),(263,NULL,NULL,'4a2fe10fc9e348b7882f646ffc46378a',NULL,NULL,NULL,NULL,'2026-01-21 14:18:34',NULL,'2026-01-21 14:18:34',NULL,NULL),(264,NULL,NULL,'32f8f6bc48eb4208bf6ce044b71728b7',NULL,NULL,NULL,NULL,'2026-01-21 14:18:34',NULL,'2026-01-21 14:18:34',NULL,NULL),(265,NULL,NULL,'a85e42519b5a4a9bbc60957369e55eb0',NULL,NULL,NULL,NULL,'2026-01-21 14:18:34',NULL,'2026-01-21 14:18:34',NULL,NULL),(266,NULL,'057c07904cd34efc9ceea6ab2d3e4d04',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:18:34',NULL,'2026-01-21 14:18:34',NULL,NULL),(267,NULL,'152f8a8b68f04ede82e620ecf0d07d43',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:18:36',NULL,'2026-01-21 14:18:36',NULL,NULL),(268,NULL,'8ac26a239e8f483295cc41511f987d14',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:18:36',NULL,'2026-01-21 14:18:36',NULL,NULL),(269,NULL,'e66a7c6c1cc746b682e2d69f3a215fb0',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:18:36',NULL,'2026-01-21 14:18:36',NULL,NULL),(270,NULL,'976cb73653274d2c9f294f04e2c886d7',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:18:36',NULL,'2026-01-21 14:18:36',NULL,NULL),(271,NULL,'3cc89d84bffa401eab10c32a2f4b29d2',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:18:39',NULL,'2026-01-21 14:18:39',NULL,NULL),(272,NULL,NULL,'3f155a642cbe41c5a9ffda4ad895b42a',NULL,NULL,NULL,NULL,'2026-01-21 14:18:39',NULL,'2026-01-21 14:18:39',NULL,NULL),(273,NULL,NULL,'758295ca667c45b18dcc69f1f409b227',NULL,NULL,NULL,NULL,'2026-01-21 14:18:39',NULL,'2026-01-21 14:18:39',NULL,NULL),(274,NULL,NULL,'2f46d6fd77654a25b5b80b2c93c743fc',NULL,NULL,NULL,NULL,'2026-01-21 14:18:39',NULL,'2026-01-21 14:18:39',NULL,NULL),(275,NULL,'0741e04dd0374acbb9a94dc2f84a66f0',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:18:41',NULL,'2026-01-21 14:18:41',NULL,NULL),(276,NULL,'42d0f9e7ca75499fafa3885d62f2fa91',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:18:41',NULL,'2026-01-21 14:18:41',NULL,NULL),(277,NULL,'d035f6d09645453b8fe1b93378c60f84',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:18:43',NULL,'2026-01-21 14:18:43',NULL,NULL),(278,NULL,NULL,'f83293c3035649b18ab8fd2fa579be67',NULL,NULL,NULL,NULL,'2026-01-21 14:18:44',NULL,'2026-01-21 14:18:44',NULL,NULL),(279,NULL,NULL,'f1490949d0aa4cbc925931d4f1730b66',NULL,NULL,NULL,NULL,'2026-01-21 14:18:44',NULL,'2026-01-21 14:18:44',NULL,NULL),(280,NULL,NULL,'e28b258417e34b1198b83c01a2b8551f',NULL,NULL,NULL,NULL,'2026-01-21 14:18:44',NULL,'2026-01-21 14:18:44',NULL,NULL),(281,NULL,NULL,'f98e0173c17f4432974a288b6f57d950',NULL,NULL,NULL,NULL,'2026-01-21 14:18:44',NULL,'2026-01-21 14:18:44',NULL,NULL),(282,NULL,NULL,'6f4cf9c5c5c3414eaec6f1989411f3b9',NULL,NULL,NULL,NULL,'2026-01-21 14:18:44',NULL,'2026-01-21 14:18:44',NULL,NULL),(283,NULL,NULL,'58cb477bb4c941a09c9fb2d93c71dfa6',NULL,NULL,NULL,NULL,'2026-01-21 14:18:45',NULL,'2026-01-21 14:18:45',NULL,NULL),(284,NULL,NULL,'91dff5cca87f4f518c72188d84b27019',NULL,NULL,NULL,NULL,'2026-01-21 14:18:45',NULL,'2026-01-21 14:18:45',NULL,NULL),(285,NULL,NULL,'067d58a6d58a4da48aa28149a3f459eb',NULL,NULL,NULL,NULL,'2026-01-21 14:18:46',NULL,'2026-01-21 14:18:46',NULL,NULL),(286,NULL,'442246f3561d44a5843979409b5e6dd0',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:18:47',NULL,'2026-01-21 14:18:47',NULL,NULL),(287,NULL,'603423311df64251b73f42dbddc8c381',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:18:48',NULL,'2026-01-21 14:18:48',NULL,NULL),(288,NULL,'9ffaca3370a64ddb878a2025d78e82f3',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:18:48',NULL,'2026-01-21 14:18:48',NULL,NULL),(289,NULL,'82a0f85130824a22871f71a341aef188',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:18:49',NULL,'2026-01-21 14:18:49',NULL,NULL),(290,NULL,'b9c7638b2c3e4b739d631d4d01d08cef',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:18:49',NULL,'2026-01-21 14:18:49',NULL,NULL),(291,NULL,'8b8b88644b4a4433acf73b8af4b407ea',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:18:49',NULL,'2026-01-21 14:18:49',NULL,NULL),(292,NULL,NULL,'a8665239b0094d2ea841bc8327b9e7cb',NULL,NULL,NULL,NULL,'2026-01-21 14:18:56',NULL,'2026-01-21 14:18:56',NULL,NULL),(293,NULL,NULL,'1db23cc75258457897c405fd66bb96d1',NULL,NULL,NULL,NULL,'2026-01-21 14:18:59',NULL,'2026-01-21 14:18:59',NULL,NULL),(294,NULL,NULL,'268de681116841a9bf4c612dfaaf3e3e',NULL,NULL,NULL,NULL,'2026-01-21 14:18:59',NULL,'2026-01-21 14:18:59',NULL,NULL),(295,NULL,NULL,'92864ba7907c4819938c67b37ab8496f',NULL,NULL,NULL,NULL,'2026-01-21 14:18:59',NULL,'2026-01-21 14:18:59',NULL,NULL),(296,NULL,NULL,'e22534ea36d543998491240c75960b69',NULL,NULL,NULL,NULL,'2026-01-21 14:19:01',NULL,'2026-01-21 14:19:01',NULL,NULL),(297,NULL,NULL,'58f090ca7eb44d6283619dbe4093d976',NULL,NULL,NULL,NULL,'2026-01-21 14:19:03',NULL,'2026-01-21 14:19:03',NULL,NULL),(298,NULL,NULL,'766a4fafe0794d0bbe923182d3309dc4',NULL,NULL,NULL,NULL,'2026-01-21 14:19:03',NULL,'2026-01-21 14:19:03',NULL,NULL),(299,NULL,'72fa4f57192c4e668a28bb49c014603a',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:19:03',NULL,'2026-01-21 14:19:03',NULL,NULL),(300,NULL,NULL,'9811bae6bdb642018920955fd8481816',NULL,NULL,NULL,NULL,'2026-01-21 14:19:03',NULL,'2026-01-21 14:19:03',NULL,NULL),(301,NULL,'b5c9b0d4e08f4bfd8959823b79382206',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:19:05',NULL,'2026-01-21 14:19:05',NULL,NULL),(302,NULL,'b1afda5f0aaf44c1872e3c8563376a31',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:19:05',NULL,'2026-01-21 14:19:05',NULL,NULL),(303,NULL,'95f63a954c354e96b9452108123722c8',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:19:07',NULL,'2026-01-21 14:19:07',NULL,NULL),(304,NULL,'c1296b6d5b894590a81d189d81d8463c',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:19:07',NULL,'2026-01-21 14:19:07',NULL,NULL),(305,NULL,'36f9e0931d704f3381212884901f4087',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:19:08',NULL,'2026-01-21 14:19:08',NULL,NULL),(306,NULL,NULL,'1bdd99b08fdf48cbae340f6fab64e0de',NULL,NULL,NULL,NULL,'2026-01-21 14:19:13',NULL,'2026-01-21 14:19:13',NULL,NULL),(307,NULL,'3045c953c1f44932b48db800dd54be02',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:19:14',NULL,'2026-01-21 14:19:14',NULL,NULL),(308,NULL,NULL,'eb3f5b0643a14343821bdf28eb7b1727',NULL,NULL,NULL,NULL,'2026-01-21 14:19:22',NULL,'2026-01-21 14:19:22',NULL,NULL),(309,NULL,NULL,'b01f23e1df1240dd9949216a2466ed8c',NULL,NULL,NULL,NULL,'2026-01-21 14:19:22',NULL,'2026-01-21 14:19:22',NULL,NULL),(310,NULL,NULL,'d69a48424d0f4941871f2f35a34c0408',NULL,NULL,NULL,NULL,'2026-01-21 14:19:23',NULL,'2026-01-21 14:19:23',NULL,NULL),(311,NULL,NULL,'5e463fc3b37f4ad683d113fe4e8b2d6a',NULL,NULL,NULL,NULL,'2026-01-21 14:19:24',NULL,'2026-01-21 14:19:24',NULL,NULL),(312,NULL,NULL,'1c1eea8f9887474dbca49904b6ac7f31',NULL,NULL,NULL,NULL,'2026-01-21 14:19:24',NULL,'2026-01-21 14:19:24',NULL,NULL),(313,NULL,NULL,'5b965558f0c0497ebdd72dab09fa0fc2',NULL,NULL,NULL,NULL,'2026-01-21 14:19:24',NULL,'2026-01-21 14:19:24',NULL,NULL),(314,NULL,NULL,'920083400adf4bf88354be8bd2e50ba1',NULL,NULL,NULL,NULL,'2026-01-21 14:19:26',NULL,'2026-01-21 14:19:26',NULL,NULL),(315,NULL,NULL,'5fc5352869ae4b5bb2f79b93d597a568',NULL,NULL,NULL,NULL,'2026-01-21 14:19:26',NULL,'2026-01-21 14:19:26',NULL,NULL),(316,NULL,'e5d2b19b5e42472bbc153671b4a835ba',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:19:26',NULL,'2026-01-21 14:19:26',NULL,NULL),(317,NULL,NULL,'d3490ec0052540c7841976a462fe6261',NULL,NULL,NULL,NULL,'2026-01-21 14:19:26',NULL,'2026-01-21 14:19:26',NULL,NULL),(318,NULL,'a0b12c49110549909e03960562b43f46',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:19:29',NULL,'2026-01-21 14:19:29',NULL,NULL),(319,NULL,'7be9e3a0119b40f692133210ebe5f9a2',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:19:29',NULL,'2026-01-21 14:19:29',NULL,NULL),(320,NULL,'cd5112270f724330a46a1bd0ffc257f1',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:19:30',NULL,'2026-01-21 14:19:30',NULL,NULL),(321,NULL,'c0101bfae81d4f5ca4e379933d2a549e',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:19:30',NULL,'2026-01-21 14:19:30',NULL,NULL),(322,NULL,'4acbbeeeb4a34c749df67662a42f4124',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:19:32',NULL,'2026-01-21 14:19:32',NULL,NULL),(323,NULL,NULL,'7e622d91977e48908ef7bdca6f37d018',NULL,NULL,NULL,NULL,'2026-01-21 14:19:37',NULL,'2026-01-21 14:19:37',NULL,NULL),(324,NULL,NULL,'5463824d9e094577947a77236c032597',NULL,NULL,NULL,NULL,'2026-01-21 14:19:38',NULL,'2026-01-21 14:19:38',NULL,NULL),(325,NULL,NULL,'6717b1577b4d43eb8fc6178e45a8ab82',NULL,NULL,NULL,NULL,'2026-01-21 14:19:38',NULL,'2026-01-21 14:19:38',NULL,NULL),(326,NULL,NULL,'ab8d7bb0ef654ed3bac1720f64cfee7e',NULL,NULL,NULL,NULL,'2026-01-21 14:19:38',NULL,'2026-01-21 14:19:38',NULL,NULL),(327,NULL,NULL,'10ff34009a86401b9b465330679710ec',NULL,NULL,NULL,NULL,'2026-01-21 14:19:39',NULL,'2026-01-21 14:19:39',NULL,NULL),(328,NULL,'cdbddd7deba64c728b0d38385bc326b8',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:19:39',NULL,'2026-01-21 14:19:39',NULL,NULL),(329,NULL,'6c312d17103c4740ba2670d2e3011c65',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:19:41',NULL,'2026-01-21 14:19:41',NULL,NULL),(330,NULL,'f9c7d0690a704c3aade3c766e1dc58e7',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:19:41',NULL,'2026-01-21 14:19:41',NULL,NULL),(331,NULL,NULL,'2c69a0214bdd4c6b9712b9fe700516c5',NULL,NULL,NULL,NULL,'2026-01-21 14:19:44',NULL,'2026-01-21 14:19:44',NULL,NULL),(332,NULL,'1406ea2dc774411ebb2977eb6dee678f',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:19:46',NULL,'2026-01-21 14:19:46',NULL,NULL),(333,NULL,NULL,'51daa32984f24d90b50a4cba851c93da',NULL,NULL,NULL,NULL,'2026-01-21 14:19:46',NULL,'2026-01-21 14:19:46',NULL,NULL),(334,NULL,NULL,'93197948461c4499bd3cbe3148aa54fc',NULL,NULL,NULL,NULL,'2026-01-21 14:19:47',NULL,'2026-01-21 14:19:47',NULL,NULL),(335,NULL,NULL,'ff291d01fba44b98a36928b61708a714',NULL,NULL,NULL,NULL,'2026-01-21 14:19:47',NULL,'2026-01-21 14:19:47',NULL,NULL),(336,NULL,'340973e5122140889a25a6682616f5ca',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:19:48',NULL,'2026-01-21 14:19:48',NULL,NULL),(337,NULL,'3efc5d38bf75484d9e4b2aed22003264',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:19:48',NULL,'2026-01-21 14:19:48',NULL,NULL),(338,NULL,'6ac3f58b102c47698cc8ad883157c589',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:19:49',NULL,'2026-01-21 14:19:49',NULL,NULL),(339,NULL,NULL,'6efc09cb0cf44c1d872b3f3506c66e18',NULL,NULL,NULL,NULL,'2026-01-21 14:20:00',NULL,'2026-01-21 14:20:00',NULL,NULL),(340,NULL,NULL,'0d9f34eea44c4c89af97a5953e8ca62d',NULL,NULL,NULL,NULL,'2026-01-21 14:20:00',NULL,'2026-01-21 14:20:00',NULL,NULL),(341,NULL,NULL,'ded0b3c843fb433dbacce42395d7d87b',NULL,NULL,NULL,NULL,'2026-01-21 14:20:00',NULL,'2026-01-21 14:20:00',NULL,NULL),(342,NULL,NULL,'33119e28a9c44733817645e0a1c0bdd8',NULL,NULL,NULL,NULL,'2026-01-21 14:20:00',NULL,'2026-01-21 14:20:00',NULL,NULL),(343,NULL,'c75f0483f6fb42f5ac6577236b0579e9',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:20:05',NULL,'2026-01-21 14:20:05',NULL,NULL),(344,NULL,'5287c34d74954423ba30381636cbb812',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:20:06',NULL,'2026-01-21 14:20:06',NULL,NULL),(345,NULL,'d638cf7a9e1e49ccbfafad2ce91ed67c',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:20:08',NULL,'2026-01-21 14:20:08',NULL,NULL),(346,NULL,NULL,'7ecd3e7e5f104220addc133f4c00820e',NULL,NULL,NULL,NULL,'2026-01-21 14:20:17',NULL,'2026-01-21 14:20:17',NULL,NULL),(347,NULL,NULL,'6ec525d992e341d68f12ae0cac568446',NULL,NULL,NULL,NULL,'2026-01-21 14:20:17',NULL,'2026-01-21 14:20:17',NULL,NULL),(348,NULL,NULL,'f495d6bf0526437fa38255453fbf17cc',NULL,NULL,NULL,NULL,'2026-01-21 14:20:17',NULL,'2026-01-21 14:20:17',NULL,NULL),(349,NULL,NULL,'f087f4f09db24a5e88847c85528c749d',NULL,NULL,NULL,NULL,'2026-01-21 14:20:18',NULL,'2026-01-21 14:20:18',NULL,NULL),(350,NULL,'273b0f88119142bb88f70bd49708607c',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:20:19',NULL,'2026-01-21 14:20:19',NULL,NULL),(351,NULL,'5c2bb5d77e9c4c8d9466b3c2b6e3fb46',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:20:21',NULL,'2026-01-21 14:20:21',NULL,NULL),(352,NULL,'6ff3cfe56ef449499ddd2b4f9cf82923',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:20:23',NULL,'2026-01-21 14:20:23',NULL,NULL),(353,NULL,NULL,'da435899744543de9da028611ac45aa7',NULL,NULL,NULL,NULL,'2026-01-21 14:20:46',NULL,'2026-01-21 14:20:46',NULL,NULL),(354,NULL,NULL,'8f91d7fab0ee4a86a798bfda435f3ff4',NULL,NULL,NULL,NULL,'2026-01-21 14:21:00',NULL,'2026-01-21 14:21:00',NULL,NULL),(355,NULL,NULL,'3fd7591b80834a81bc0b1ed5454a5bf1',NULL,NULL,NULL,NULL,'2026-01-21 14:21:00',NULL,'2026-01-21 14:21:00',NULL,NULL),(356,NULL,NULL,'4cc07965ab254e219f36710122d2bf17',NULL,NULL,NULL,NULL,'2026-01-21 14:21:00',NULL,'2026-01-21 14:21:00',NULL,NULL),(357,NULL,'b5b435b7b2e64c43b6b66fae5fe5a556',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:21:02',NULL,'2026-01-21 14:21:02',NULL,NULL),(358,NULL,'265433c915284e308788d3048cf90078',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:21:02',NULL,'2026-01-21 14:21:02',NULL,NULL),(359,NULL,'6668028fb0bc4ecfa2b00c68f85b812b',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:21:06',NULL,'2026-01-21 14:21:06',NULL,NULL),(360,NULL,NULL,'fe76e78dff8a49dd86c5e126d0f3542a',NULL,NULL,NULL,NULL,'2026-01-21 14:22:48',NULL,'2026-01-21 14:22:48',NULL,NULL),(361,NULL,NULL,'67dae406f3fa410bac4003400c38ab9e',NULL,NULL,NULL,NULL,'2026-01-21 14:23:03',NULL,'2026-01-21 14:23:03',NULL,NULL),(362,NULL,NULL,'2533be2157db436cb5f5d1bb87ccbff1',NULL,NULL,NULL,NULL,'2026-01-21 14:23:05',NULL,'2026-01-21 14:23:05',NULL,NULL),(363,NULL,NULL,'e27b73117883457c9578ed3d817c1c33',NULL,NULL,NULL,NULL,'2026-01-21 14:23:05',NULL,'2026-01-21 14:23:05',NULL,NULL),(364,NULL,'a8d99ee5003949d4bb2eb5d78ce0afce',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:23:08',NULL,'2026-01-21 14:23:08',NULL,NULL),(365,NULL,'41d4aecafc20406482129223e7dd4624',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:23:14',NULL,'2026-01-21 14:23:14',NULL,NULL),(366,NULL,'5af5b0f9a5c0485a95b3339eb837b67c',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:23:17',NULL,'2026-01-21 14:23:17',NULL,NULL),(367,NULL,NULL,'5e2561a904c44855ab0022c9ebed2708',NULL,NULL,NULL,NULL,'2026-01-21 14:23:46',NULL,'2026-01-21 14:23:46',NULL,NULL),(368,NULL,NULL,'40585f18d2e84161b8eca432bf37306f',NULL,NULL,NULL,NULL,'2026-01-21 14:23:55',NULL,'2026-01-21 14:23:55',NULL,NULL),(369,NULL,NULL,'32c3193068214e77afa70f31723c7f8d',NULL,NULL,NULL,NULL,'2026-01-21 14:23:55',NULL,'2026-01-21 14:23:55',NULL,NULL),(370,NULL,NULL,'26c52db73e304e86b2d969e0056302de',NULL,NULL,NULL,NULL,'2026-01-21 14:23:55',NULL,'2026-01-21 14:23:55',NULL,NULL),(371,NULL,'c5e66c4c75914670a87b293313357987',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:23:58',NULL,'2026-01-21 14:23:58',NULL,NULL),(372,NULL,'18bcd7a466594b3abec112774943eca1',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:24:00',NULL,'2026-01-21 14:24:00',NULL,NULL),(373,NULL,'bddb45e54b3d4a8d8841e6bde4e5da58',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:24:03',NULL,'2026-01-21 14:24:03',NULL,NULL),(374,NULL,NULL,'dff8382a1fa94ece807190bf30c12664',NULL,NULL,NULL,NULL,'2026-01-21 14:24:12',NULL,'2026-01-21 14:24:12',NULL,NULL),(375,NULL,NULL,'768ea9e23e064d4fb42fede4ad130a38',NULL,NULL,NULL,NULL,'2026-01-21 14:24:13',NULL,'2026-01-21 14:24:13',NULL,NULL),(376,NULL,NULL,'cd5d4ca3a52f4f948b76cac53aae0bb6',NULL,NULL,NULL,NULL,'2026-01-21 14:24:13',NULL,'2026-01-21 14:24:13',NULL,NULL),(377,NULL,NULL,'9aca4c55268249d896761f2ac1fe5fb7',NULL,NULL,NULL,NULL,'2026-01-21 14:24:13',NULL,'2026-01-21 14:24:13',NULL,NULL),(378,NULL,'bcae83c5d7354c1aa1d3c6894f117833',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:24:15',NULL,'2026-01-21 14:24:15',NULL,NULL),(379,NULL,'ca4c47771ffd4ba78a90c060d9308a7e',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:24:16',NULL,'2026-01-21 14:24:16',NULL,NULL),(380,NULL,'290d65c18ec44f7799cb9d7b572b080d',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:24:19',NULL,'2026-01-21 14:24:19',NULL,NULL),(381,NULL,NULL,'11253502df6f4df58cd1f1daf7ae0c3d',NULL,NULL,NULL,NULL,'2026-01-21 14:24:48',NULL,'2026-01-21 14:24:48',NULL,NULL),(382,NULL,NULL,'37b3bbc0092f402c82354dc1111facd4',NULL,NULL,NULL,NULL,'2026-01-21 14:24:56',NULL,'2026-01-21 14:24:56',NULL,NULL),(383,NULL,NULL,'7977544062bc433aa883a21f99bc6e25',NULL,NULL,NULL,NULL,'2026-01-21 14:24:56',NULL,'2026-01-21 14:24:56',NULL,NULL),(384,NULL,NULL,'2c6507b5b65c4708b17257f1ba195122',NULL,NULL,NULL,NULL,'2026-01-21 14:24:56',NULL,'2026-01-21 14:24:56',NULL,NULL),(385,NULL,'a4f094a58f4542e2ab299637736993f9',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:24:58',NULL,'2026-01-21 14:24:58',NULL,NULL),(386,NULL,'f4db8abbd224402f903f07baff88b2c3',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:24:59',NULL,'2026-01-21 14:24:59',NULL,NULL),(387,NULL,'13e8c4e3586a483791302a530e4d20f9',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:25:00',NULL,'2026-01-21 14:25:00',NULL,NULL),(388,NULL,NULL,'989ef14460114158b3c5e393542ef3b5',NULL,NULL,NULL,NULL,'2026-01-21 14:25:15',NULL,'2026-01-21 14:25:15',NULL,NULL),(389,NULL,NULL,'1168f378c75641a9a34467d731e79a9e',NULL,NULL,NULL,NULL,'2026-01-21 14:25:23',NULL,'2026-01-21 14:25:23',NULL,NULL),(390,NULL,NULL,'242442d8ef2942e287dc3d7ce5714312',NULL,NULL,NULL,NULL,'2026-01-21 14:25:23',NULL,'2026-01-21 14:25:23',NULL,NULL),(391,NULL,NULL,'5235555694064d97abb44d263b9b9986',NULL,NULL,NULL,NULL,'2026-01-21 14:25:24',NULL,'2026-01-21 14:25:24',NULL,NULL),(392,NULL,'1f8a85ca800a4a4d913bae00eea17cff',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:25:27',NULL,'2026-01-21 14:25:27',NULL,NULL),(393,NULL,'92e3ad67f91c49a482df2c989242e88e',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:25:28',NULL,'2026-01-21 14:25:28',NULL,NULL),(394,NULL,'3ae1279c04024905bd21b77f8a95d5ae',NULL,NULL,NULL,NULL,NULL,'2026-01-21 14:25:30',NULL,'2026-01-21 14:25:30',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('23e95c3313b341a3a24057e69983f687','reader','{}','<<null>>',NULL),('49036114c709426d9900a92e9b637437','service','{}','<<null>>',NULL),('4d26d25438e347a185f0b5da3011dd78','admin','{}','<<null>>',NULL),('651596e0ced14587af645e2d21b6d0e4','ResellerAdmin','{}','<<null>>',NULL),('6ee92856e97a4cfa84894ba9d92cb800','member','{}','<<null>>',NULL),('86dbcebcb6924e8cb0cbda34fa129a15','swiftoperator','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('23e95c3313b341a3a24057e69983f687','IMMU','true'),('4d26d25438e347a185f0b5da3011dd78','IMMU','true'),('6ee92856e97a4cfa84894ba9d92cb800','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('11b6a46360ff42c4928ff39158bb1762','object-store',1,'{\"name\": \"swift\", \"description\": \"OpenStack Object Storage\"}'),('14c22a55c0764d77a8abca2aa9c59d3b','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('24103d7dbe86463e91b655780265157e','share',1,'{\"description\": \"Manila V1 Service\", \"name\": \"manila\"}'),('3c8d484856354deea2351cb57612be56','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('47adc1d65e1e40708a3373675eb8195d','identity',1,'{\"name\": \"keystone\"}'),('5549658b521d4401ac714ff81240d7c5','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('7d1cf0826de04bbfbe67a9dc484970e2','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('a2199ae7153b40a18f119ca3473db05c','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('b9e56ed39a064fbd8dc3e9999fd2895f','sharev2',1,'{\"description\": \"Manila V2 Service\", \"name\": \"manilav2\"}'),('cb2e22aaf86f47bf837c5ccb92699af6','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('ee31b26cd8ed4af8bcdb0938a22adf6c','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','8f773bf58f7e4798bc681f39c85c3fae','system','4d26d25438e347a185f0b5da3011dd78',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_user_id` (`user_id`),
  KEY `ix_token_trust_id` (`trust_id`),
  KEY `ix_token_expires` (`expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('2cbde5c50dad460fb2cd0528113fc82b','{}',1,'9fe1cfb5a0c94e3f9373148450b42755','2026-01-21 13:31:29','2026-01-21','default'),('6f34e8796a1b4806896d0d03d81f6eca','{}',1,'9fe1cfb5a0c94e3f9373148450b42755','2026-01-21 14:04:32','2026-01-21','default'),('6f99e659e1814a83a66e932f12ae158a','{\"tenantId\": \"450bf23628d34d56aabe65f29d190c76\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2026-01-21 14:07:33',NULL,'default'),('8f773bf58f7e4798bc681f39c85c3fae','{}',1,NULL,'2026-01-21 13:29:54','2026-01-21','default'),('98346b7f610d48d98cc4efc0d50f511a','{}',1,'9fe1cfb5a0c94e3f9373148450b42755','2026-01-21 13:31:20',NULL,'default'),('ae7aeaa718a64439964d40116aa42d2c','{}',1,'9fe1cfb5a0c94e3f9373148450b42755','2026-01-21 13:31:41','2026-01-21','default'),('b96cc77704e744748cf4b5937cd98e20','{}',1,'9fe1cfb5a0c94e3f9373148450b42755','2026-01-21 13:31:24','2026-01-21','default'),('cf373519529d406680aae2c33da9ee28','{}',1,'9fe1cfb5a0c94e3f9373148450b42755','2026-01-21 13:31:14','2026-01-21','default'),('d8d57f0d66f44201b0f8e364ef0ddaa3','{\"tenantId\": \"4dce6c721e184b13bd84cddd0e203a0d\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2026-01-21 14:07:33',NULL,'default'),('dac7ad005b4f4f33a3b76497a4b8836e','{}',1,'9fe1cfb5a0c94e3f9373148450b42755','2026-01-21 13:31:18','2026-01-21','default'),('e655d1e4aae443afa93b1a5b49b8b1bf','{}',1,'9fe1cfb5a0c94e3f9373148450b42755','2026-01-21 13:46:43',NULL,'default'),('f5c81fe487de44d095395ed8a64f9cf3','{}',1,'9fe1cfb5a0c94e3f9373148450b42755','2026-01-21 13:31:45','2026-01-21','default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `manila`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `manila` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `manila`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('aebe2a413e13');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `async_operation_data`
--

DROP TABLE IF EXISTS `async_operation_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `async_operation_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `async_operation_data`
--

LOCK TABLES `async_operation_data` WRITE;
/*!40000 ALTER TABLE `async_operation_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `async_operation_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `availability_zones`
--

DROP TABLE IF EXISTS `availability_zones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `availability_zones` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `az_name_uc` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `availability_zones`
--

LOCK TABLES `availability_zones` WRITE;
/*!40000 ALTER TABLE `availability_zones` DISABLE KEYS */;
INSERT INTO `availability_zones` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`) VALUES ('2026-01-21 14:04:35.131780',NULL,NULL,'False','63c64197-bff4-402b-8808-40cae651ac91','nova');
/*!40000 ALTER TABLE `availability_zones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backend_info`
--

DROP TABLE IF EXISTS `backend_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backend_info` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `host` varchar(255) NOT NULL,
  `info_hash` varchar(255) NOT NULL,
  PRIMARY KEY (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backend_info`
--

LOCK TABLES `backend_info` WRITE;
/*!40000 ALTER TABLE `backend_info` DISABLE KEYS */;
INSERT INTO `backend_info` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `host`, `info_hash`) VALUES ('2026-01-21 14:04:46.048008',NULL,NULL,0,'hostgroup@cephfs','e66c0dfc0d422efa26af62f5a81dd60603e2d39a');
/*!40000 ALTER TABLE `backend_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `drivers_private_data`
--

DROP TABLE IF EXISTS `drivers_private_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `drivers_private_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `drivers_private_data`
--

LOCK TABLES `drivers_private_data` WRITE;
/*!40000 ALTER TABLE `drivers_private_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `drivers_private_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_id` varchar(36) DEFAULT NULL,
  `action_id` varchar(10) NOT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
INSERT INTO `messages` (`id`, `project_id`, `request_id`, `resource_type`, `resource_id`, `action_id`, `detail_id`, `message_level`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `expires_at`) VALUES ('0251aa92-7726-409a-aa1a-143d65535012','1812e512403748bd8d20cf83682d6ecb','req-82afb153-9281-4d68-ab22-6a9b416a3aac','SHARE','30854878-3900-4399-8036-f35b4759f865','001','008','ERROR','2026-01-21 14:13:45.920222',NULL,NULL,'False','2026-02-20 14:13:45'),('0d52b34f-1e58-4078-a8db-56d3794eceee','1812e512403748bd8d20cf83682d6ecb','req-e238f80d-1c21-48d4-90b7-6352fbc5267e','SHARE','0399260c-a060-46ea-bcae-f845b64ac843','001','008','ERROR','2026-01-21 14:13:41.420514',NULL,NULL,'False','2026-02-20 14:13:41'),('0dfe9948-a69e-4c03-b6a2-0f43d1cbac31','c55f56602b994198b2b9437533a437d7','req-a0589151-e5b0-4b1b-8cdb-7f1f600a73e9','SHARE','18e262aa-85d0-4141-b91e-66da6fddace6','001','008','ERROR','2026-01-21 14:15:27.382130',NULL,'2026-01-21 14:15:30.918860','0dfe9948-a69e-4c03-b6a2-0f43d1cbac31','2026-02-20 14:15:27'),('1f067035-1675-41b1-8499-de30a8ba4a7d','183d8c03d481485397037ffe17a60995','req-6ad25c9d-4f85-490f-8f79-73d811b36f1a','SHARE','ca6daf26-9831-4772-bcf0-7b69e0070af8','010','020','ERROR','2026-01-21 14:17:15.084096',NULL,NULL,'False','2026-02-20 14:17:15'),('27811ea1-7bd8-40bf-8e12-c7f51ab8f43d','c55f56602b994198b2b9437533a437d7','req-1c9b2776-e39c-4c75-9dff-a35b345ffec9','SHARE','37fea2af-cb5f-4ce6-ad57-8e3fdf18c513','001','008','ERROR','2026-01-21 14:14:56.136024',NULL,NULL,'False','2026-02-20 14:14:56'),('2bf7588d-fcb8-47cd-914e-f0633b7320bf','1812e512403748bd8d20cf83682d6ecb','req-0440bfd4-dd88-4200-afd9-5c20d151af66','SHARE','3f2fb9c0-2e57-4d1b-8cf8-6074c5454331','001','008','ERROR','2026-01-21 14:13:35.308898',NULL,NULL,'False','2026-02-20 14:13:35'),('2df40fe8-219a-4e5b-b269-22eb8fd046b8','1812e512403748bd8d20cf83682d6ecb','req-677c05c6-1185-4668-9fac-be5703cdb24d','SHARE','84744f0f-3821-4ef8-81d7-2f297251eeda','001','008','ERROR','2026-01-21 14:13:51.302528',NULL,NULL,'False','2026-02-20 14:13:51'),('55148d57-50f6-4ee0-8f24-307f74fec361','c55f56602b994198b2b9437533a437d7','req-7de5a21f-ccd9-44d7-8ad6-4a69cbb5083a','SHARE','d9a40d08-858b-4fe0-8d78-6d99497a249f','001','008','ERROR','2026-01-21 14:14:43.148954',NULL,NULL,'False','2026-02-20 14:14:43'),('8feb6d1c-ba24-4d23-ba20-2c88e3403ae5','c55f56602b994198b2b9437533a437d7','req-98525e14-9bb2-4f4e-8e81-bb7398deb1dd','SHARE','e74a9198-b8ec-4c66-8843-e247a2163eda','001','008','ERROR','2026-01-21 14:14:48.754865',NULL,NULL,'False','2026-02-20 14:14:48'),('91ec4ef2-97c4-4756-be5e-be571e235916','c55f56602b994198b2b9437533a437d7','req-f392d04f-34ad-421f-babc-f2ae11ce282d','SHARE','f43ad296-d798-4b0d-a20a-11bd1a371881','001','008','ERROR','2026-01-21 14:15:05.409643',NULL,NULL,'False','2026-02-20 14:15:05'),('9d59c079-2911-41c7-a138-d025586bf8c0','c55f56602b994198b2b9437533a437d7','req-cdfb2872-9677-40b3-b2a2-33411e2ae33f','SHARE','2c754312-2184-4de2-a6bb-7fbb0fd69571','001','008','ERROR','2026-01-21 14:15:17.754958',NULL,NULL,'False','2026-02-20 14:15:17'),('9eae38a1-af14-456f-bd53-7caeda95c7d9','c55f56602b994198b2b9437533a437d7','req-c17249a9-6cf9-47c4-9880-e7ea440ad196','SHARE','1dadb7a1-c595-48c0-8c20-61b9f6b86eb2','001','008','ERROR','2026-01-21 14:15:01.613161',NULL,NULL,'False','2026-02-20 14:15:01'),('d216fda5-f123-4ff5-92b7-4124be6da4bd','c55f56602b994198b2b9437533a437d7','req-0eda55df-a24d-4494-909e-7735fc04827b','SHARE','0f20f2be-86ec-43cb-8ba5-0e7061804ec3','001','008','ERROR','2026-01-21 14:14:38.718947',NULL,'2026-01-21 14:14:42.106349','d216fda5-f123-4ff5-92b7-4124be6da4bd','2026-02-20 14:14:38'),('e70c4a19-ad1b-4191-8573-763c3fa6623d','1812e512403748bd8d20cf83682d6ecb','req-7c4e6810-22b1-4146-afee-03064c270648','SHARE','78c2bfb4-61d4-432b-9ea3-5bfb830f3b03','001','008','ERROR','2026-01-21 14:13:57.102300',NULL,NULL,'False','2026-02-20 14:13:57'),('f7c0f564-9df4-400a-b908-013d54e7ca59','c55f56602b994198b2b9437533a437d7','req-6c6aae1f-b5ce-46eb-9fff-9a05b155a3eb','SHARE','fab0fdf5-9fef-4cce-a2ee-7832c9376c39','001','008','ERROR','2026-01-21 14:15:22.562325',NULL,NULL,'False','2026-02-20 14:15:22'),('fc84970f-f5e5-437d-9f03-caa8fcf154e3','c55f56602b994198b2b9437533a437d7','req-6a505add-7a0c-4719-843c-4a180c90083c','SHARE','ac96fc6c-01cf-4118-aff0-f8a200342bf0','001','008','ERROR','2026-01-21 14:15:09.664753',NULL,NULL,'False','2026-02-20 14:15:09');
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `network_allocations`
--

DROP TABLE IF EXISTS `network_allocations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `network_allocations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ip_address` varchar(64) DEFAULT NULL,
  `mac_address` varchar(32) DEFAULT NULL,
  `share_server_id` varchar(36) NOT NULL,
  `label` varchar(255) DEFAULT 'user',
  `network_type` varchar(32) DEFAULT NULL,
  `segmentation_id` int(11) DEFAULT NULL,
  `ip_version` int(11) DEFAULT NULL,
  `cidr` varchar(64) DEFAULT NULL,
  `gateway` varchar(64) DEFAULT NULL,
  `mtu` int(11) DEFAULT NULL,
  `share_network_subnet_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_server_id` (`share_server_id`),
  KEY `fk_network_allocation_subnet_id_share_network_subnets` (`share_network_subnet_id`),
  CONSTRAINT `fk_network_allocation_subnet_id_share_network_subnets` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`),
  CONSTRAINT `network_allocations_ibfk_1` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `network_allocations`
--

LOCK TABLES `network_allocations` WRITE;
/*!40000 ALTER TABLE `network_allocations` DISABLE KEYS */;
/*!40000 ALTER TABLE `network_allocations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_share_type_quotas`
--

DROP TABLE IF EXISTS `project_share_type_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_share_type_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uc_quotas_per_share_types` (`share_type_id`,`resource`,`deleted`,`project_id`),
  CONSTRAINT `share_type_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_share_type_quotas`
--

LOCK TABLES `project_share_type_quotas` WRITE;
/*!40000 ALTER TABLE `project_share_type_quotas` DISABLE KEYS */;
INSERT INTO `project_share_type_quotas` (`id`, `project_id`, `resource`, `hard_limit`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_type_id`) VALUES (1,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',2,'2026-01-21 14:11:02.642823',NULL,'2026-01-21 14:12:02.503965',1,'08dc12ec-0496-4207-ab26-687dc1000122'),(2,'50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',4,'2026-01-21 14:11:02.650527',NULL,'2026-01-21 14:12:02.503965',2,'08dc12ec-0496-4207-ab26-687dc1000122'),(3,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',2,'2026-01-21 14:11:02.794989',NULL,'2026-01-21 14:12:02.067033',3,'3055f25f-99ca-47e1-85fd-3d023797e4ab'),(4,'50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',4,'2026-01-21 14:11:02.799796',NULL,'2026-01-21 14:12:02.067033',4,'3055f25f-99ca-47e1-85fd-3d023797e4ab'),(5,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',53,'2026-01-21 14:11:21.894846',NULL,'2026-01-21 14:11:22.203503',5,'789ac2c9-711f-4a07-a8a8-e5a726b61aec'),(6,'50bb744aaa0a40ecbfeaa20d4e691f46','snapshots',53,'2026-01-21 14:11:21.903831',NULL,'2026-01-21 14:11:22.203503',6,'789ac2c9-711f-4a07-a8a8-e5a726b61aec'),(7,'50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',1003,'2026-01-21 14:11:21.918856',NULL,'2026-01-21 14:11:22.203503',7,'789ac2c9-711f-4a07-a8a8-e5a726b61aec'),(8,'50bb744aaa0a40ecbfeaa20d4e691f46','snapshot_gigabytes',1003,'2026-01-21 14:11:21.924117',NULL,'2026-01-21 14:11:22.203503',8,'789ac2c9-711f-4a07-a8a8-e5a726b61aec'),(9,'50bb744aaa0a40ecbfeaa20d4e691f46','share_replicas',103,'2026-01-21 14:11:21.929688',NULL,'2026-01-21 14:11:22.203503',9,'789ac2c9-711f-4a07-a8a8-e5a726b61aec'),(10,'50bb744aaa0a40ecbfeaa20d4e691f46','replica_gigabytes',1003,'2026-01-21 14:11:21.987401',NULL,'2026-01-21 14:11:22.203503',10,'789ac2c9-711f-4a07-a8a8-e5a726b61aec'),(11,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',53,'2026-01-21 14:11:23.294838',NULL,'2026-01-21 14:11:23.417017',11,'5081aafe-5bcd-4868-82bc-92284af11fa0'),(12,'50bb744aaa0a40ecbfeaa20d4e691f46','snapshots',53,'2026-01-21 14:11:23.305165',NULL,'2026-01-21 14:11:23.417017',12,'5081aafe-5bcd-4868-82bc-92284af11fa0'),(13,'50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',1003,'2026-01-21 14:11:23.309690',NULL,'2026-01-21 14:11:23.417017',13,'5081aafe-5bcd-4868-82bc-92284af11fa0'),(14,'50bb744aaa0a40ecbfeaa20d4e691f46','snapshot_gigabytes',1003,'2026-01-21 14:11:23.314334',NULL,'2026-01-21 14:11:23.417017',14,'5081aafe-5bcd-4868-82bc-92284af11fa0'),(15,'50bb744aaa0a40ecbfeaa20d4e691f46','share_replicas',103,'2026-01-21 14:11:23.318395',NULL,'2026-01-21 14:11:23.417017',15,'5081aafe-5bcd-4868-82bc-92284af11fa0'),(16,'50bb744aaa0a40ecbfeaa20d4e691f46','replica_gigabytes',1003,'2026-01-21 14:11:23.333507',NULL,'2026-01-21 14:11:23.417017',16,'5081aafe-5bcd-4868-82bc-92284af11fa0'),(17,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',12,'2026-01-21 14:11:27.141043',NULL,'2026-01-21 14:12:01.149218',17,'283e163d-39d4-4850-bbf9-a7e3eb6d8974'),(18,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',49,'2026-01-21 14:11:35.857200',NULL,'2026-01-21 14:12:00.679753',18,'46b5cf9b-25b2-40af-8cff-d939d6ed0251'),(19,'50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',999,'2026-01-21 14:11:35.997543',NULL,'2026-01-21 14:12:00.679753',19,'46b5cf9b-25b2-40af-8cff-d939d6ed0251'),(20,'50bb744aaa0a40ecbfeaa20d4e691f46','snapshots',49,'2026-01-21 14:11:36.171239',NULL,'2026-01-21 14:12:00.679753',20,'46b5cf9b-25b2-40af-8cff-d939d6ed0251'),(21,'50bb744aaa0a40ecbfeaa20d4e691f46','snapshot_gigabytes',999,'2026-01-21 14:11:36.353457',NULL,'2026-01-21 14:12:00.679753',21,'46b5cf9b-25b2-40af-8cff-d939d6ed0251'),(22,'50bb744aaa0a40ecbfeaa20d4e691f46','share_replicas',99,'2026-01-21 14:11:36.655788',NULL,'2026-01-21 14:12:00.679753',22,'46b5cf9b-25b2-40af-8cff-d939d6ed0251'),(23,'50bb744aaa0a40ecbfeaa20d4e691f46','replica_gigabytes',999,'2026-01-21 14:11:37.024366',NULL,'2026-01-21 14:12:00.679753',23,'46b5cf9b-25b2-40af-8cff-d939d6ed0251'),(24,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',49,'2026-01-21 14:11:38.284612',NULL,'2026-01-21 14:12:00.294332',24,'20f5b5fd-9c31-4b20-8536-8a9964fff283'),(25,'50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',999,'2026-01-21 14:11:38.516850',NULL,'2026-01-21 14:12:00.294332',25,'20f5b5fd-9c31-4b20-8536-8a9964fff283'),(26,'50bb744aaa0a40ecbfeaa20d4e691f46','snapshots',49,'2026-01-21 14:11:38.718593',NULL,'2026-01-21 14:12:00.294332',26,'20f5b5fd-9c31-4b20-8536-8a9964fff283'),(27,'50bb744aaa0a40ecbfeaa20d4e691f46','snapshot_gigabytes',999,'2026-01-21 14:11:38.868508',NULL,'2026-01-21 14:12:00.294332',27,'20f5b5fd-9c31-4b20-8536-8a9964fff283'),(28,'50bb744aaa0a40ecbfeaa20d4e691f46','share_replicas',99,'2026-01-21 14:11:39.006080',NULL,'2026-01-21 14:12:00.294332',28,'20f5b5fd-9c31-4b20-8536-8a9964fff283'),(29,'50bb744aaa0a40ecbfeaa20d4e691f46','replica_gigabytes',999,'2026-01-21 14:11:39.195130',NULL,'2026-01-21 14:12:00.294332',29,'20f5b5fd-9c31-4b20-8536-8a9964fff283'),(30,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',11,'2026-01-21 14:11:40.353699',NULL,'2026-01-21 14:11:59.834922',30,'b42fe5e7-36a4-4949-a87c-fc57879172ce'),(31,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',-1,'2026-01-21 14:11:41.212806',NULL,'2026-01-21 14:11:59.505976',31,'17cc8bc7-2a1d-4d75-abb8-7b834d3b229d');
/*!40000 ALTER TABLE `project_share_type_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_user_quotas`
--

DROP TABLE IF EXISTS `project_user_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_user_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `resource` varchar(25) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_user_quotas`
--

LOCK TABLES `project_user_quotas` WRITE;
/*!40000 ALTER TABLE `project_user_quotas` DISABLE KEYS */;
INSERT INTO `project_user_quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `user_id`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2026-01-21 14:11:02.258648',NULL,'2026-01-21 14:11:21.207867',1,'eabd986b9e274262a34ffc9cdfc09733','50bb744aaa0a40ecbfeaa20d4e691f46','shares',2),(2,'2026-01-21 14:11:02.300332',NULL,'2026-01-21 14:11:21.207867',2,'eabd986b9e274262a34ffc9cdfc09733','50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',7),(3,'2026-01-21 14:11:25.929616',NULL,'2026-01-21 14:11:27.340547',3,'eabd986b9e274262a34ffc9cdfc09733','50bb744aaa0a40ecbfeaa20d4e691f46','shares',11),(4,'2026-01-21 14:11:30.459640',NULL,'2026-01-21 14:11:30.727645',4,'eabd986b9e274262a34ffc9cdfc09733','50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',-1),(5,'2026-01-21 14:11:30.866815',NULL,'2026-01-21 14:11:31.029806',5,'eabd986b9e274262a34ffc9cdfc09733','50bb744aaa0a40ecbfeaa20d4e691f46','share_replicas',-1),(6,'2026-01-21 14:11:31.195316',NULL,'2026-01-21 14:11:33.331431',6,'eabd986b9e274262a34ffc9cdfc09733','50bb744aaa0a40ecbfeaa20d4e691f46','replica_gigabytes',-1),(7,'2026-01-21 14:11:33.509864',NULL,'2026-01-21 14:11:33.744560',7,'eabd986b9e274262a34ffc9cdfc09733','50bb744aaa0a40ecbfeaa20d4e691f46','share_networks',-1),(8,'2026-01-21 14:11:34.045291',NULL,'2026-01-21 14:11:34.265879',8,'eabd986b9e274262a34ffc9cdfc09733','50bb744aaa0a40ecbfeaa20d4e691f46','shares',-1),(9,'2026-01-21 14:11:34.417218',NULL,'2026-01-21 14:11:34.683483',9,'eabd986b9e274262a34ffc9cdfc09733','50bb744aaa0a40ecbfeaa20d4e691f46','snapshot_gigabytes',-1),(10,'2026-01-21 14:11:34.826446',NULL,'2026-01-21 14:11:34.991620',10,'eabd986b9e274262a34ffc9cdfc09733','50bb744aaa0a40ecbfeaa20d4e691f46','snapshots',-1),(11,'2026-01-21 14:11:44.684840',NULL,'2026-01-21 14:11:44.778193',11,'eabd986b9e274262a34ffc9cdfc09733','50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',999),(12,'2026-01-21 14:11:45.478506',NULL,'2026-01-21 14:11:45.883906',12,'eabd986b9e274262a34ffc9cdfc09733','50bb744aaa0a40ecbfeaa20d4e691f46','share_replicas',99),(13,'2026-01-21 14:11:47.439497',NULL,'2026-01-21 14:11:47.548725',13,'eabd986b9e274262a34ffc9cdfc09733','50bb744aaa0a40ecbfeaa20d4e691f46','replica_gigabytes',999),(14,'2026-01-21 14:11:47.881431',NULL,'2026-01-21 14:11:49.209471',14,'eabd986b9e274262a34ffc9cdfc09733','50bb744aaa0a40ecbfeaa20d4e691f46','share_networks',9),(15,'2026-01-21 14:11:49.920870',NULL,'2026-01-21 14:11:53.569618',15,'eabd986b9e274262a34ffc9cdfc09733','50bb744aaa0a40ecbfeaa20d4e691f46','shares',49),(16,'2026-01-21 14:11:54.823511',NULL,'2026-01-21 14:11:55.767262',16,'eabd986b9e274262a34ffc9cdfc09733','50bb744aaa0a40ecbfeaa20d4e691f46','snapshot_gigabytes',999),(17,'2026-01-21 14:11:56.228889',NULL,'2026-01-21 14:11:56.413499',17,'eabd986b9e274262a34ffc9cdfc09733','50bb744aaa0a40ecbfeaa20d4e691f46','snapshots',49),(18,'2026-01-21 14:11:57.220929',NULL,'2026-01-21 14:11:57.517238',18,'eabd986b9e274262a34ffc9cdfc09733','50bb744aaa0a40ecbfeaa20d4e691f46','shares',11),(19,'2026-01-21 14:11:58.999146',NULL,'2026-01-21 14:11:59.099436',19,'eabd986b9e274262a34ffc9cdfc09733','50bb744aaa0a40ecbfeaa20d4e691f46','shares',-1);
/*!40000 ALTER TABLE `project_user_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_usages_project_id` (`project_id`)
) ENGINE=InnoDB AUTO_INCREMENT=270 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `share_type_id`) VALUES ('2026-01-21 14:10:20.813847','2026-01-21 14:12:12.319805',NULL,0,1,'9f6fd3bf04e94f2d8e668d8e93cb0afa','81d0568612894d6da94e01a77bfde64f','shares',0,0,NULL,NULL),('2026-01-21 14:10:20.822215','2026-01-21 14:12:12.319809',NULL,0,2,'9f6fd3bf04e94f2d8e668d8e93cb0afa','81d0568612894d6da94e01a77bfde64f','gigabytes',0,0,NULL,NULL),('2026-01-21 14:10:20.842293','2026-01-21 14:12:12.319811','2026-01-21 14:12:15.466873',3,3,NULL,'81d0568612894d6da94e01a77bfde64f','shares',0,0,NULL,'9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:10:20.847487','2026-01-21 14:12:12.319812','2026-01-21 14:12:15.466873',4,4,NULL,'81d0568612894d6da94e01a77bfde64f','gigabytes',0,0,NULL,'9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:10:22.699899','2026-01-21 14:10:33.778953',NULL,0,5,'c585b1d2d5d64ff09f12475b01bfdb96','25182f2d153d4140867b49ea0c5064d3','gigabytes',0,0,NULL,NULL),('2026-01-21 14:10:22.716443','2026-01-21 14:10:33.778957',NULL,0,6,'c585b1d2d5d64ff09f12475b01bfdb96','25182f2d153d4140867b49ea0c5064d3','shares',0,0,NULL,NULL),('2026-01-21 14:10:22.748863','2026-01-21 14:10:33.778959','2026-01-21 14:10:36.826942',7,7,NULL,'25182f2d153d4140867b49ea0c5064d3','gigabytes',0,0,NULL,'730c7c03-7e1d-487b-906f-6935715d2b12'),('2026-01-21 14:10:22.752897','2026-01-21 14:10:33.778961','2026-01-21 14:10:36.826942',8,8,NULL,'25182f2d153d4140867b49ea0c5064d3','shares',0,0,NULL,'730c7c03-7e1d-487b-906f-6935715d2b12'),('2026-01-21 14:10:23.372805','2026-01-21 14:10:31.637585',NULL,0,9,'88612755fd4c490c96b9c4b454fc53d5','e17b908e218c4cd78e47e6be458b89a4','shares',0,0,NULL,NULL),('2026-01-21 14:10:23.375196','2026-01-21 14:10:31.637588',NULL,0,10,'88612755fd4c490c96b9c4b454fc53d5','e17b908e218c4cd78e47e6be458b89a4','gigabytes',0,0,NULL,NULL),('2026-01-21 14:10:23.477510','2026-01-21 14:10:31.637589','2026-01-21 14:10:35.001176',11,11,NULL,'e17b908e218c4cd78e47e6be458b89a4','shares',0,0,NULL,'22f02301-b01e-4d8f-b557-3558b6a3b9a3'),('2026-01-21 14:10:23.480489','2026-01-21 14:10:31.637591','2026-01-21 14:10:35.001176',12,12,NULL,'e17b908e218c4cd78e47e6be458b89a4','gigabytes',0,0,NULL,'22f02301-b01e-4d8f-b557-3558b6a3b9a3'),('2026-01-21 14:11:03.144412','2026-01-21 14:11:17.411711','2026-01-21 14:11:21.211904',13,13,'eabd986b9e274262a34ffc9cdfc09733','50bb744aaa0a40ecbfeaa20d4e691f46','shares',0,0,NULL,NULL),('2026-01-21 14:11:03.146613','2026-01-21 14:11:17.411715','2026-01-21 14:11:21.211904',14,14,'eabd986b9e274262a34ffc9cdfc09733','50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',0,0,NULL,NULL),('2026-01-21 14:11:03.172854','2026-01-21 14:11:14.112983','2026-01-21 14:11:21.378078',15,15,NULL,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',0,0,NULL,'08dc12ec-0496-4207-ab26-687dc1000122'),('2026-01-21 14:11:03.175033','2026-01-21 14:11:14.112985','2026-01-21 14:11:21.378078',16,16,NULL,'50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',0,0,NULL,'08dc12ec-0496-4207-ab26-687dc1000122'),('2026-01-21 14:11:03.796414','2026-01-21 14:12:08.724501',NULL,0,17,'9f6fd3bf04e94f2d8e668d8e93cb0afa','81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-21 14:11:03.801316','2026-01-21 14:12:08.724505',NULL,0,18,'9f6fd3bf04e94f2d8e668d8e93cb0afa','81d0568612894d6da94e01a77bfde64f','snapshots',0,0,NULL,NULL),('2026-01-21 14:11:03.811718','2026-01-21 14:12:08.724507','2026-01-21 14:12:15.466873',19,19,NULL,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',0,0,NULL,'9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:11:03.815228','2026-01-21 14:12:08.724509','2026-01-21 14:12:15.466873',20,20,NULL,'81d0568612894d6da94e01a77bfde64f','snapshots',0,0,NULL,'9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:11:07.596251','2026-01-21 14:11:17.411717','2026-01-21 14:11:21.378078',21,21,NULL,'50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',0,0,NULL,'3055f25f-99ca-47e1-85fd-3d023797e4ab'),('2026-01-21 14:11:07.598879','2026-01-21 14:11:17.411718','2026-01-21 14:11:21.378078',22,22,NULL,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',0,0,NULL,'3055f25f-99ca-47e1-85fd-3d023797e4ab'),('2026-01-21 14:11:21.138463','2026-01-21 14:11:21.329718','2026-01-21 14:11:25.202631',23,23,'91a5b3e563184701bd5a4f2a997f8221','2806d215025845bc90e195f0b5c64c21','gigabytes',1,0,NULL,NULL),('2026-01-21 14:11:21.143420','2026-01-21 14:11:21.329722','2026-01-21 14:11:25.202631',24,24,'91a5b3e563184701bd5a4f2a997f8221','2806d215025845bc90e195f0b5c64c21','shares',1,0,NULL,NULL),('2026-01-21 14:11:21.180159','2026-01-21 14:11:21.329724','2026-01-21 14:11:25.202631',25,25,NULL,'2806d215025845bc90e195f0b5c64c21','gigabytes',1,0,NULL,'c5bac032-cc46-4150-aad5-9325071c0935'),('2026-01-21 14:11:21.186029','2026-01-21 14:11:21.329726','2026-01-21 14:11:25.202631',26,26,NULL,'2806d215025845bc90e195f0b5c64c21','shares',1,0,NULL,'c5bac032-cc46-4150-aad5-9325071c0935'),('2026-01-21 14:11:25.471556','2026-01-21 14:11:26.103274','2026-01-21 14:11:36.653448',27,27,'91a5b3e563184701bd5a4f2a997f8221','2806d215025845bc90e195f0b5c64c21','gigabytes',2,0,NULL,NULL),('2026-01-21 14:11:25.476630','2026-01-21 14:11:26.103278','2026-01-21 14:11:36.653448',28,28,'91a5b3e563184701bd5a4f2a997f8221','2806d215025845bc90e195f0b5c64c21','shares',2,0,NULL,NULL),('2026-01-21 14:11:26.038050','2026-01-21 14:11:26.103280','2026-01-21 14:11:36.653448',29,29,NULL,'2806d215025845bc90e195f0b5c64c21','shares',1,0,NULL,'29cdbce9-1270-470b-8e9e-290edf433bce'),('2026-01-21 14:11:26.042890','2026-01-21 14:11:26.103281','2026-01-21 14:11:36.653448',30,30,NULL,'2806d215025845bc90e195f0b5c64c21','gigabytes',1,0,NULL,'29cdbce9-1270-470b-8e9e-290edf433bce'),('2026-01-21 14:11:30.806619','2026-01-21 14:11:31.057456','2026-01-21 14:11:36.653448',31,31,'91a5b3e563184701bd5a4f2a997f8221','2806d215025845bc90e195f0b5c64c21','snapshot_gigabytes',1,0,NULL,NULL),('2026-01-21 14:11:30.810013','2026-01-21 14:11:31.057459','2026-01-21 14:11:36.653448',32,32,'91a5b3e563184701bd5a4f2a997f8221','2806d215025845bc90e195f0b5c64c21','snapshots',1,0,NULL,NULL),('2026-01-21 14:11:30.883348','2026-01-21 14:11:31.057462','2026-01-21 14:11:36.653448',33,33,NULL,'2806d215025845bc90e195f0b5c64c21','snapshot_gigabytes',1,0,NULL,'29cdbce9-1270-470b-8e9e-290edf433bce'),('2026-01-21 14:11:30.888906','2026-01-21 14:11:31.057463','2026-01-21 14:11:36.653448',34,34,NULL,'2806d215025845bc90e195f0b5c64c21','snapshots',1,0,NULL,'29cdbce9-1270-470b-8e9e-290edf433bce'),('2026-01-21 14:12:00.348859','2026-01-21 14:12:00.699611',NULL,0,35,'91a5b3e563184701bd5a4f2a997f8221','2806d215025845bc90e195f0b5c64c21','snapshot_gigabytes',-1,0,NULL,NULL),('2026-01-21 14:12:00.352970','2026-01-21 14:12:00.699614',NULL,0,36,'91a5b3e563184701bd5a4f2a997f8221','2806d215025845bc90e195f0b5c64c21','snapshots',-1,0,NULL,NULL),('2026-01-21 14:12:00.590365','2026-01-21 14:12:00.699616','2026-01-21 14:12:07.593718',37,37,NULL,'2806d215025845bc90e195f0b5c64c21','snapshot_gigabytes',-1,0,NULL,'29cdbce9-1270-470b-8e9e-290edf433bce'),('2026-01-21 14:12:00.594528','2026-01-21 14:12:00.699618','2026-01-21 14:12:07.593718',38,38,NULL,'2806d215025845bc90e195f0b5c64c21','snapshots',-1,0,NULL,'29cdbce9-1270-470b-8e9e-290edf433bce'),('2026-01-21 14:12:04.548282','2026-01-21 14:12:09.120138',NULL,0,39,'91a5b3e563184701bd5a4f2a997f8221','2806d215025845bc90e195f0b5c64c21','shares',0,0,NULL,NULL),('2026-01-21 14:12:04.558992','2026-01-21 14:12:09.120142',NULL,0,40,'91a5b3e563184701bd5a4f2a997f8221','2806d215025845bc90e195f0b5c64c21','gigabytes',0,0,NULL,NULL),('2026-01-21 14:12:05.387458','2026-01-21 14:12:07.312843','2026-01-21 14:12:07.593718',41,41,NULL,'2806d215025845bc90e195f0b5c64c21','shares',0,0,NULL,'29cdbce9-1270-470b-8e9e-290edf433bce'),('2026-01-21 14:12:06.461541','2026-01-21 14:12:07.312844','2026-01-21 14:12:07.593718',42,42,NULL,'2806d215025845bc90e195f0b5c64c21','gigabytes',0,0,NULL,'29cdbce9-1270-470b-8e9e-290edf433bce'),('2026-01-21 14:12:08.977551','2026-01-21 14:12:09.120144','2026-01-21 14:12:12.173477',43,43,NULL,'2806d215025845bc90e195f0b5c64c21','shares',0,0,NULL,'c5bac032-cc46-4150-aad5-9325071c0935'),('2026-01-21 14:12:08.983794','2026-01-21 14:12:09.120146','2026-01-21 14:12:12.173477',44,44,NULL,'2806d215025845bc90e195f0b5c64c21','gigabytes',0,0,NULL,'c5bac032-cc46-4150-aad5-9325071c0935'),('2026-01-21 14:12:16.214529','2026-01-21 14:12:22.483165',NULL,0,45,'aba5fb7f48d64e01a3694378a50f9c54','91fa423674524226acfe253061607c0b','gigabytes',0,0,NULL,NULL),('2026-01-21 14:12:16.219201','2026-01-21 14:12:22.483168',NULL,0,46,'aba5fb7f48d64e01a3694378a50f9c54','91fa423674524226acfe253061607c0b','shares',0,0,NULL,NULL),('2026-01-21 14:12:16.304272','2026-01-21 14:12:22.483170','2026-01-21 14:12:23.833466',47,47,NULL,'91fa423674524226acfe253061607c0b','gigabytes',0,0,NULL,'5a374d5e-d0ed-4003-9ec7-10084960d609'),('2026-01-21 14:12:16.308245','2026-01-21 14:12:22.483171','2026-01-21 14:12:23.833466',48,48,NULL,'91fa423674524226acfe253061607c0b','shares',0,0,NULL,'5a374d5e-d0ed-4003-9ec7-10084960d609'),('2026-01-21 14:12:23.909308','2026-01-21 14:12:36.598709',NULL,0,49,'561f676f9fd94b9f83b47172d27f8e4d','8ea8a62d6efd4fdcac316c24e39fb155','gigabytes',0,0,NULL,NULL),('2026-01-21 14:12:23.911880','2026-01-21 14:12:36.598713',NULL,0,50,'561f676f9fd94b9f83b47172d27f8e4d','8ea8a62d6efd4fdcac316c24e39fb155','shares',0,0,NULL,NULL),('2026-01-21 14:12:30.213565','2026-01-21 14:12:36.598715','2026-01-21 14:12:39.970012',51,51,NULL,'8ea8a62d6efd4fdcac316c24e39fb155','gigabytes',0,0,NULL,'291913af-f721-4784-852d-18a81c2dbf2d'),('2026-01-21 14:12:30.777652','2026-01-21 14:12:36.598717','2026-01-21 14:12:39.970012',52,52,NULL,'8ea8a62d6efd4fdcac316c24e39fb155','shares',0,0,NULL,'291913af-f721-4784-852d-18a81c2dbf2d'),('2026-01-21 14:12:40.109540','2026-01-21 14:12:59.950634',NULL,0,53,'296b3ba1092e47d48708162556c13492','8f23a9ff8e6249a7b232ba280b7bee1d','gigabytes',0,0,NULL,NULL),('2026-01-21 14:12:40.112736','2026-01-21 14:12:59.950637',NULL,0,54,'296b3ba1092e47d48708162556c13492','8f23a9ff8e6249a7b232ba280b7bee1d','shares',0,0,NULL,NULL),('2026-01-21 14:12:40.159486','2026-01-21 14:12:59.950638','2026-01-21 14:13:02.320662',55,55,NULL,'8f23a9ff8e6249a7b232ba280b7bee1d','gigabytes',0,0,NULL,'59554df7-024a-45b7-9735-27031cc895f1'),('2026-01-21 14:12:40.164231','2026-01-21 14:12:59.950639','2026-01-21 14:13:02.320662',56,56,NULL,'8f23a9ff8e6249a7b232ba280b7bee1d','shares',0,0,NULL,'59554df7-024a-45b7-9735-27031cc895f1'),('2026-01-21 14:12:49.081746','2026-01-21 14:12:55.224052',NULL,0,57,'296b3ba1092e47d48708162556c13492','8f23a9ff8e6249a7b232ba280b7bee1d','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-21 14:12:49.084420','2026-01-21 14:12:55.224055',NULL,0,58,'296b3ba1092e47d48708162556c13492','8f23a9ff8e6249a7b232ba280b7bee1d','snapshots',0,0,NULL,NULL),('2026-01-21 14:12:49.103664','2026-01-21 14:12:55.224057','2026-01-21 14:13:02.320662',59,59,NULL,'8f23a9ff8e6249a7b232ba280b7bee1d','snapshot_gigabytes',0,0,NULL,'59554df7-024a-45b7-9735-27031cc895f1'),('2026-01-21 14:12:49.106568','2026-01-21 14:12:55.224059','2026-01-21 14:13:02.320662',60,60,NULL,'8f23a9ff8e6249a7b232ba280b7bee1d','snapshots',0,0,NULL,'59554df7-024a-45b7-9735-27031cc895f1'),('2026-01-21 14:12:49.800964','2026-01-21 14:13:15.315455',NULL,0,61,'a0672e98f4144413a0f7f662605555ca','5da033845de7469096a0943fc3046311','gigabytes',0,0,NULL,NULL),('2026-01-21 14:12:49.803796','2026-01-21 14:13:15.315459',NULL,0,62,'a0672e98f4144413a0f7f662605555ca','5da033845de7469096a0943fc3046311','shares',0,0,NULL,NULL),('2026-01-21 14:12:49.815974','2026-01-21 14:13:15.315461','2026-01-21 14:13:15.715394',63,63,NULL,'5da033845de7469096a0943fc3046311','gigabytes',0,0,NULL,'9381faef-bf67-41dd-aaaa-a9be7a2bcc68'),('2026-01-21 14:12:49.818237','2026-01-21 14:13:15.315463','2026-01-21 14:13:15.715394',64,64,NULL,'5da033845de7469096a0943fc3046311','shares',0,0,NULL,'9381faef-bf67-41dd-aaaa-a9be7a2bcc68'),('2026-01-21 14:13:20.849755','2026-01-21 14:14:22.345599',NULL,0,65,'111328e7e8c9499f9dd897f7f644b965','79952fad07e54cf18c5f2c207bdbf9fb','gigabytes',0,0,NULL,NULL),('2026-01-21 14:13:20.852416','2026-01-21 14:14:22.345603',NULL,0,66,'111328e7e8c9499f9dd897f7f644b965','79952fad07e54cf18c5f2c207bdbf9fb','shares',0,0,NULL,NULL),('2026-01-21 14:13:20.863873','2026-01-21 14:14:22.345605','2026-01-21 14:14:25.260957',67,67,NULL,'79952fad07e54cf18c5f2c207bdbf9fb','gigabytes',0,0,NULL,'d763adfd-4693-4b03-ad1c-6cfad5db99b3'),('2026-01-21 14:13:20.867065','2026-01-21 14:14:22.345606','2026-01-21 14:14:25.260957',68,68,NULL,'79952fad07e54cf18c5f2c207bdbf9fb','shares',0,0,NULL,'d763adfd-4693-4b03-ad1c-6cfad5db99b3'),('2026-01-21 14:13:24.521786','2026-01-21 14:14:18.723736',NULL,0,69,'111328e7e8c9499f9dd897f7f644b965','79952fad07e54cf18c5f2c207bdbf9fb','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-21 14:13:24.525798','2026-01-21 14:14:18.723738',NULL,0,70,'111328e7e8c9499f9dd897f7f644b965','79952fad07e54cf18c5f2c207bdbf9fb','snapshots',0,0,NULL,NULL),('2026-01-21 14:13:24.536208','2026-01-21 14:14:18.723740','2026-01-21 14:14:25.260957',71,71,NULL,'79952fad07e54cf18c5f2c207bdbf9fb','snapshot_gigabytes',0,0,NULL,'d763adfd-4693-4b03-ad1c-6cfad5db99b3'),('2026-01-21 14:13:24.539236','2026-01-21 14:14:18.723741','2026-01-21 14:14:25.260957',72,72,NULL,'79952fad07e54cf18c5f2c207bdbf9fb','snapshots',0,0,NULL,'d763adfd-4693-4b03-ad1c-6cfad5db99b3'),('2026-01-21 14:13:28.225146','2026-01-21 14:13:31.743765',NULL,0,73,'371332db2a2c453ea215c3980707fbd6','938ff6c62b4d4bfe9c13b015ab84e14b','share_networks',0,0,NULL,NULL),('2026-01-21 14:13:29.203445','2026-01-21 14:13:29.253135',NULL,0,74,'b020af4acf6c46669264d3692bde318e','13c5ce7776694d3ba842a33559f0ce31','share_networks',1,0,NULL,NULL),('2026-01-21 14:13:34.831786','2026-01-21 14:14:00.976986',NULL,0,75,'6fc9e38a391d41b1bce34dc4cb926a6d','1812e512403748bd8d20cf83682d6ecb','gigabytes',0,0,NULL,NULL),('2026-01-21 14:13:34.833823','2026-01-21 14:14:00.976990',NULL,0,76,'6fc9e38a391d41b1bce34dc4cb926a6d','1812e512403748bd8d20cf83682d6ecb','shares',0,0,NULL,NULL),('2026-01-21 14:13:35.146809','2026-01-21 14:13:39.141982','2026-01-21 14:14:02.659335',77,77,NULL,'1812e512403748bd8d20cf83682d6ecb','gigabytes',0,0,NULL,'0b0ef60b-789a-4f97-ab23-aa852b1b2e11'),('2026-01-21 14:13:35.149584','2026-01-21 14:13:39.141983','2026-01-21 14:14:02.659335',78,78,NULL,'1812e512403748bd8d20cf83682d6ecb','shares',0,0,NULL,'0b0ef60b-789a-4f97-ab23-aa852b1b2e11'),('2026-01-21 14:13:38.697560','2026-01-21 14:13:58.712402',NULL,0,79,'54bd2d99c737409a8cdb47d0ef61c0af','bf58a5c191654263a44f73287e2a242e','gigabytes',0,0,NULL,NULL),('2026-01-21 14:13:38.701256','2026-01-21 14:13:58.712405',NULL,0,80,'54bd2d99c737409a8cdb47d0ef61c0af','bf58a5c191654263a44f73287e2a242e','shares',0,0,NULL,NULL),('2026-01-21 14:13:38.718695','2026-01-21 14:13:58.712407','2026-01-21 14:14:01.765260',81,81,NULL,'bf58a5c191654263a44f73287e2a242e','gigabytes',0,0,NULL,'7cec5100-da97-4c19-a6d2-711aa40fb4a4'),('2026-01-21 14:13:38.721225','2026-01-21 14:13:58.712409','2026-01-21 14:14:01.765260',82,82,NULL,'bf58a5c191654263a44f73287e2a242e','shares',0,0,NULL,'7cec5100-da97-4c19-a6d2-711aa40fb4a4'),('2026-01-21 14:13:39.650721','2026-01-21 14:13:45.164283','2026-01-21 14:14:02.197875',83,83,NULL,'1812e512403748bd8d20cf83682d6ecb','gigabytes',0,0,NULL,'9ca783c9-ecfe-469c-a4a8-d087ab0379ae'),('2026-01-21 14:13:39.655501','2026-01-21 14:13:45.164285','2026-01-21 14:14:02.197875',84,84,NULL,'1812e512403748bd8d20cf83682d6ecb','shares',0,0,NULL,'9ca783c9-ecfe-469c-a4a8-d087ab0379ae'),('2026-01-21 14:13:41.538010','2026-01-21 14:14:37.426002',NULL,0,85,'18d829f19dd445aa98c02d30c005b747','498aac0871e5417786fbc3341cc80fbf','gigabytes',0,0,NULL,NULL),('2026-01-21 14:13:41.540564','2026-01-21 14:14:37.426006',NULL,0,86,'18d829f19dd445aa98c02d30c005b747','498aac0871e5417786fbc3341cc80fbf','shares',0,0,NULL,NULL),('2026-01-21 14:13:41.551773','2026-01-21 14:14:37.426007','2026-01-21 14:14:40.705582',87,87,NULL,'498aac0871e5417786fbc3341cc80fbf','gigabytes',0,0,NULL,'21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:13:41.554643','2026-01-21 14:14:37.426008','2026-01-21 14:14:40.705582',88,88,NULL,'498aac0871e5417786fbc3341cc80fbf','shares',0,0,NULL,'21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:13:42.110447','2026-01-21 14:13:55.393473',NULL,0,89,'54bd2d99c737409a8cdb47d0ef61c0af','bf58a5c191654263a44f73287e2a242e','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-21 14:13:42.113166','2026-01-21 14:13:55.393477',NULL,0,90,'54bd2d99c737409a8cdb47d0ef61c0af','bf58a5c191654263a44f73287e2a242e','snapshots',0,0,NULL,NULL),('2026-01-21 14:13:42.124344','2026-01-21 14:13:55.393479','2026-01-21 14:14:01.765260',91,91,NULL,'bf58a5c191654263a44f73287e2a242e','snapshot_gigabytes',0,0,NULL,'7cec5100-da97-4c19-a6d2-711aa40fb4a4'),('2026-01-21 14:13:42.129047','2026-01-21 14:13:55.393480','2026-01-21 14:14:01.765260',92,92,NULL,'bf58a5c191654263a44f73287e2a242e','snapshots',0,0,NULL,'7cec5100-da97-4c19-a6d2-711aa40fb4a4'),('2026-01-21 14:13:45.724274','2026-01-21 14:13:50.085600','2026-01-21 14:14:01.980951',93,93,NULL,'1812e512403748bd8d20cf83682d6ecb','gigabytes',0,0,NULL,'cdda8570-26be-4330-bd36-622a2eb10327'),('2026-01-21 14:13:45.728249','2026-01-21 14:13:50.085602','2026-01-21 14:14:01.980951',94,94,NULL,'1812e512403748bd8d20cf83682d6ecb','shares',0,0,NULL,'cdda8570-26be-4330-bd36-622a2eb10327'),('2026-01-21 14:13:50.981275','2026-01-21 14:13:54.995251','2026-01-21 14:14:01.663954',95,95,NULL,'1812e512403748bd8d20cf83682d6ecb','gigabytes',0,0,NULL,'78590156-25d2-468c-8633-1b5bd4532903'),('2026-01-21 14:13:50.983465','2026-01-21 14:13:54.995252','2026-01-21 14:14:01.663954',96,96,NULL,'1812e512403748bd8d20cf83682d6ecb','shares',0,0,NULL,'78590156-25d2-468c-8633-1b5bd4532903'),('2026-01-21 14:13:55.618996','2026-01-21 14:14:00.976992','2026-01-21 14:14:01.490330',97,97,NULL,'1812e512403748bd8d20cf83682d6ecb','gigabytes',0,0,NULL,'5afaec67-94c3-4b24-8db9-1b003291becd'),('2026-01-21 14:13:55.621975','2026-01-21 14:14:00.976994','2026-01-21 14:14:01.490330',98,98,NULL,'1812e512403748bd8d20cf83682d6ecb','shares',0,0,NULL,'5afaec67-94c3-4b24-8db9-1b003291becd'),('2026-01-21 14:14:10.303555','2026-01-21 14:14:22.644372',NULL,0,99,'0f49b0d1ba944c46946a092657f6b0f2','d8fea3bdb3ee4c03a1197b6e46ed71bc','gigabytes',0,0,NULL,NULL),('2026-01-21 14:14:10.306043','2026-01-21 14:14:22.644376',NULL,0,100,'0f49b0d1ba944c46946a092657f6b0f2','d8fea3bdb3ee4c03a1197b6e46ed71bc','shares',0,0,NULL,NULL),('2026-01-21 14:14:10.318741','2026-01-21 14:14:22.644378','2026-01-21 14:14:25.282974',101,101,NULL,'d8fea3bdb3ee4c03a1197b6e46ed71bc','gigabytes',0,0,NULL,'7ac1d9c2-538b-4775-a2d5-4c70805fd54c'),('2026-01-21 14:14:10.323330','2026-01-21 14:14:22.644379','2026-01-21 14:14:25.282974',102,102,NULL,'d8fea3bdb3ee4c03a1197b6e46ed71bc','shares',0,0,NULL,'7ac1d9c2-538b-4775-a2d5-4c70805fd54c'),('2026-01-21 14:14:13.790852','2026-01-21 14:14:39.777989',NULL,0,103,'b4c32c9c7b1047fc890e37a5372183aa','42f926cfde224068a742ef536ed79928','gigabytes',0,0,NULL,NULL),('2026-01-21 14:14:13.793369','2026-01-21 14:14:39.777992',NULL,0,104,'b4c32c9c7b1047fc890e37a5372183aa','42f926cfde224068a742ef536ed79928','shares',0,0,NULL,NULL),('2026-01-21 14:14:13.807749','2026-01-21 14:14:39.777994','2026-01-21 14:14:42.417773',105,105,NULL,'42f926cfde224068a742ef536ed79928','gigabytes',0,0,NULL,'d714b627-a89b-463b-804f-ebe84408a229'),('2026-01-21 14:14:13.810184','2026-01-21 14:14:39.777996','2026-01-21 14:14:42.417773',106,106,NULL,'42f926cfde224068a742ef536ed79928','shares',0,0,NULL,'d714b627-a89b-463b-804f-ebe84408a229'),('2026-01-21 14:14:13.859391','2026-01-21 14:14:18.996066',NULL,0,107,'0f49b0d1ba944c46946a092657f6b0f2','d8fea3bdb3ee4c03a1197b6e46ed71bc','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-21 14:14:13.862067','2026-01-21 14:14:18.996068',NULL,0,108,'0f49b0d1ba944c46946a092657f6b0f2','d8fea3bdb3ee4c03a1197b6e46ed71bc','snapshots',0,0,NULL,NULL),('2026-01-21 14:14:13.870938','2026-01-21 14:14:18.996070','2026-01-21 14:14:25.282974',109,109,NULL,'d8fea3bdb3ee4c03a1197b6e46ed71bc','snapshot_gigabytes',0,0,NULL,'7ac1d9c2-538b-4775-a2d5-4c70805fd54c'),('2026-01-21 14:14:13.873177','2026-01-21 14:14:18.996071','2026-01-21 14:14:25.282974',110,110,NULL,'d8fea3bdb3ee4c03a1197b6e46ed71bc','snapshots',0,0,NULL,'7ac1d9c2-538b-4775-a2d5-4c70805fd54c'),('2026-01-21 14:14:38.524310','2026-01-21 14:15:31.237673',NULL,0,111,'1582fd57caf04d9188d3b72ecfc4ddd8','c55f56602b994198b2b9437533a437d7','shares',0,0,NULL,NULL),('2026-01-21 14:14:38.526582','2026-01-21 14:15:31.237677',NULL,0,112,'1582fd57caf04d9188d3b72ecfc4ddd8','c55f56602b994198b2b9437533a437d7','gigabytes',0,0,NULL,NULL),('2026-01-21 14:14:38.536855','2026-01-21 14:14:42.546396','2026-01-21 14:15:34.158500',113,113,NULL,'c55f56602b994198b2b9437533a437d7','shares',0,0,NULL,'073dda3b-4203-4183-90b1-b02118757953'),('2026-01-21 14:14:38.541458','2026-01-21 14:14:42.546397','2026-01-21 14:15:34.158500',114,114,NULL,'c55f56602b994198b2b9437533a437d7','gigabytes',0,0,NULL,'073dda3b-4203-4183-90b1-b02118757953'),('2026-01-21 14:14:42.922706','2026-01-21 14:14:47.086174','2026-01-21 14:15:33.712845',115,115,NULL,'c55f56602b994198b2b9437533a437d7','gigabytes',0,0,NULL,'2e51bd45-5453-4e78-b8d6-9b395d5d763d'),('2026-01-21 14:14:42.926702','2026-01-21 14:14:47.086175','2026-01-21 14:15:33.712845',116,116,NULL,'c55f56602b994198b2b9437533a437d7','shares',0,0,NULL,'2e51bd45-5453-4e78-b8d6-9b395d5d763d'),('2026-01-21 14:14:47.911701','2026-01-21 14:15:00.548754','2026-01-21 14:15:33.254780',117,117,NULL,'c55f56602b994198b2b9437533a437d7','shares',0,0,NULL,'570df0ca-219d-4456-90e9-bfe5252d183e'),('2026-01-21 14:14:47.914596','2026-01-21 14:15:00.548756','2026-01-21 14:15:33.254780',118,118,NULL,'c55f56602b994198b2b9437533a437d7','gigabytes',0,0,NULL,'570df0ca-219d-4456-90e9-bfe5252d183e'),('2026-01-21 14:14:51.246622','2026-01-21 14:16:12.245309',NULL,0,119,'47292555c1b142f8967d2205628edba1','a226ad4df79b48a2b4c6ddc1ed2cb474','gigabytes',0,0,NULL,NULL),('2026-01-21 14:14:51.252493','2026-01-21 14:16:12.245312',NULL,0,120,'47292555c1b142f8967d2205628edba1','a226ad4df79b48a2b4c6ddc1ed2cb474','shares',0,0,NULL,NULL),('2026-01-21 14:14:51.437889','2026-01-21 14:16:12.245313','2026-01-21 14:16:18.992372',121,121,NULL,'a226ad4df79b48a2b4c6ddc1ed2cb474','gigabytes',0,0,NULL,'4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b'),('2026-01-21 14:14:51.440645','2026-01-21 14:16:12.245315','2026-01-21 14:16:18.992372',122,122,NULL,'a226ad4df79b48a2b4c6ddc1ed2cb474','shares',0,0,NULL,'4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b'),('2026-01-21 14:14:53.978796','2026-01-21 14:15:00.209252','2026-01-21 14:15:33.087078',123,123,NULL,'c55f56602b994198b2b9437533a437d7','gigabytes',0,0,NULL,'f90ca7dd-2c72-49d1-9bfd-c7cfc1f6b718'),('2026-01-21 14:14:53.982059','2026-01-21 14:15:00.209254','2026-01-21 14:15:33.087078',124,124,NULL,'c55f56602b994198b2b9437533a437d7','shares',0,0,NULL,'f90ca7dd-2c72-49d1-9bfd-c7cfc1f6b718'),('2026-01-21 14:14:59.523023','2026-01-21 14:15:06.294453',NULL,0,125,'29824244ca994d38a91f46f7cb52ca0f','ef367d46915e42899003255d11c5ebdd','gigabytes',0,0,NULL,NULL),('2026-01-21 14:14:59.526703','2026-01-21 14:15:06.294456',NULL,0,126,'29824244ca994d38a91f46f7cb52ca0f','ef367d46915e42899003255d11c5ebdd','shares',0,0,NULL,NULL),('2026-01-21 14:14:59.543395','2026-01-21 14:15:06.294457','2026-01-21 14:15:08.978504',127,127,NULL,'ef367d46915e42899003255d11c5ebdd','gigabytes',0,0,NULL,'fa3be0f8-2dde-43f0-80c0-e2a4ba884d5b'),('2026-01-21 14:14:59.546697','2026-01-21 14:15:06.294458','2026-01-21 14:15:08.978504',128,128,NULL,'ef367d46915e42899003255d11c5ebdd','shares',0,0,NULL,'fa3be0f8-2dde-43f0-80c0-e2a4ba884d5b'),('2026-01-21 14:15:01.118524','2026-01-21 14:15:16.877667','2026-01-21 14:15:32.759619',129,129,NULL,'c55f56602b994198b2b9437533a437d7','shares',0,0,NULL,'c920fd72-4f4d-4931-b24d-6a9c60f2e233'),('2026-01-21 14:15:01.125757','2026-01-21 14:15:16.877668','2026-01-21 14:15:32.759619',130,130,NULL,'c55f56602b994198b2b9437533a437d7','gigabytes',0,0,NULL,'c920fd72-4f4d-4931-b24d-6a9c60f2e233'),('2026-01-21 14:15:01.153036','2026-01-21 14:15:12.895013',NULL,0,131,'691428d7711d49218388c97727044c76','28d69e0c83c84d03bcfbc4f9c9057023','gigabytes',0,0,NULL,NULL),('2026-01-21 14:15:01.156139','2026-01-21 14:15:12.895016',NULL,0,132,'691428d7711d49218388c97727044c76','28d69e0c83c84d03bcfbc4f9c9057023','shares',0,0,NULL,NULL),('2026-01-21 14:15:01.232288','2026-01-21 14:15:12.895018','2026-01-21 14:15:16.824174',133,133,NULL,'28d69e0c83c84d03bcfbc4f9c9057023','gigabytes',0,0,NULL,'5f9f4ef7-dc66-42d3-8b39-c62ccc780aba'),('2026-01-21 14:15:01.235893','2026-01-21 14:15:12.895019','2026-01-21 14:15:16.824174',134,134,NULL,'28d69e0c83c84d03bcfbc4f9c9057023','shares',0,0,NULL,'5f9f4ef7-dc66-42d3-8b39-c62ccc780aba'),('2026-01-21 14:15:05.258553','2026-01-21 14:15:13.855155','2026-01-21 14:15:32.449568',135,135,NULL,'c55f56602b994198b2b9437533a437d7','shares',0,0,NULL,'60b901c2-472b-4f17-bdda-ff703ace9faf'),('2026-01-21 14:15:05.261728','2026-01-21 14:15:13.855156','2026-01-21 14:15:32.449568',136,136,NULL,'c55f56602b994198b2b9437533a437d7','gigabytes',0,0,NULL,'60b901c2-472b-4f17-bdda-ff703ace9faf'),('2026-01-21 14:15:08.979244','2026-01-21 14:15:13.017776','2026-01-21 14:15:32.251258',137,137,NULL,'c55f56602b994198b2b9437533a437d7','gigabytes',0,0,NULL,'7efdd4ee-25a0-4ed9-bca7-168f82a1df34'),('2026-01-21 14:15:08.981992','2026-01-21 14:15:13.017779','2026-01-21 14:15:32.251258',138,138,NULL,'c55f56602b994198b2b9437533a437d7','shares',0,0,NULL,'7efdd4ee-25a0-4ed9-bca7-168f82a1df34'),('2026-01-21 14:15:17.410000','2026-01-21 14:15:26.988024','2026-01-21 14:15:31.979445',139,139,NULL,'c55f56602b994198b2b9437533a437d7','gigabytes',0,0,NULL,'96a3f3a7-7b33-4316-8b52-e062643518d7'),('2026-01-21 14:15:17.412462','2026-01-21 14:15:26.988025','2026-01-21 14:15:31.979445',140,140,NULL,'c55f56602b994198b2b9437533a437d7','shares',0,0,NULL,'96a3f3a7-7b33-4316-8b52-e062643518d7'),('2026-01-21 14:15:22.406244','2026-01-21 14:15:26.338720','2026-01-21 14:15:31.627289',141,141,NULL,'c55f56602b994198b2b9437533a437d7','gigabytes',0,0,NULL,'86c39d6d-2e5a-4607-a4f6-36e6a44459c6'),('2026-01-21 14:15:22.411296','2026-01-21 14:15:26.338721','2026-01-21 14:15:31.627289',142,142,NULL,'c55f56602b994198b2b9437533a437d7','shares',0,0,NULL,'86c39d6d-2e5a-4607-a4f6-36e6a44459c6'),('2026-01-21 14:15:27.271885','2026-01-21 14:15:31.237679','2026-01-21 14:15:31.451644',143,143,NULL,'c55f56602b994198b2b9437533a437d7','gigabytes',0,0,NULL,'6c2e02fc-c934-482d-bdc9-0685eab3a289'),('2026-01-21 14:15:27.274444','2026-01-21 14:15:31.237680','2026-01-21 14:15:31.451644',144,144,NULL,'c55f56602b994198b2b9437533a437d7','shares',0,0,NULL,'6c2e02fc-c934-482d-bdc9-0685eab3a289'),('2026-01-21 14:15:36.912283','2026-01-21 14:19:22.995803',NULL,0,145,'920083400adf4bf88354be8bd2e50ba1','7be9e3a0119b40f692133210ebe5f9a2','gigabytes',0,0,NULL,NULL),('2026-01-21 14:15:36.915037','2026-01-21 14:19:22.995808',NULL,0,146,'920083400adf4bf88354be8bd2e50ba1','7be9e3a0119b40f692133210ebe5f9a2','shares',0,0,NULL,NULL),('2026-01-21 14:15:36.927458','2026-01-21 14:19:22.995811',NULL,0,147,NULL,'7be9e3a0119b40f692133210ebe5f9a2','gigabytes',1,0,NULL,'6ee0f8f5-aa3a-4c92-817a-3d69c33b511e'),('2026-01-21 14:15:36.930498','2026-01-21 14:19:22.995813',NULL,0,148,NULL,'7be9e3a0119b40f692133210ebe5f9a2','shares',1,0,NULL,'6ee0f8f5-aa3a-4c92-817a-3d69c33b511e'),('2026-01-21 14:15:48.200882','2026-01-21 14:15:51.459416',NULL,0,149,'293519a837134c9eb5c1064ac437ea0d','e564b97ee9594256ae7ad401e2e84d33','share_networks',1,0,NULL,NULL),('2026-01-21 14:15:49.280831','2026-01-21 14:16:00.954307',NULL,0,150,'1d9340b6b4b74f75b34a2b5167cb11c9','9706b90ceb3b46678324d74c1b285687','gigabytes',0,0,NULL,NULL),('2026-01-21 14:15:49.282579','2026-01-21 14:16:00.954310',NULL,0,151,'1d9340b6b4b74f75b34a2b5167cb11c9','9706b90ceb3b46678324d74c1b285687','shares',0,0,NULL,NULL),('2026-01-21 14:15:49.341762','2026-01-21 14:16:00.954312','2026-01-21 14:16:12.496887',152,152,NULL,'9706b90ceb3b46678324d74c1b285687','gigabytes',0,0,NULL,'d54caddb-c1a6-4c3f-b2f9-7d1717fa702a'),('2026-01-21 14:15:49.489590','2026-01-21 14:16:00.954313','2026-01-21 14:16:12.496887',153,153,NULL,'9706b90ceb3b46678324d74c1b285687','shares',0,0,NULL,'d54caddb-c1a6-4c3f-b2f9-7d1717fa702a'),('2026-01-21 14:15:53.331744','2026-01-21 14:16:08.730861',NULL,0,154,'90415a0f3d4e49cba79c941b229a5421','4bd635a5dcc14e2b9d854dd0e78ecc0a','gigabytes',0,0,NULL,NULL),('2026-01-21 14:15:53.333507','2026-01-21 14:16:08.730865',NULL,0,155,'90415a0f3d4e49cba79c941b229a5421','4bd635a5dcc14e2b9d854dd0e78ecc0a','shares',0,0,NULL,NULL),('2026-01-21 14:15:53.342384','2026-01-21 14:16:08.730868','2026-01-21 14:16:12.496887',156,156,NULL,'4bd635a5dcc14e2b9d854dd0e78ecc0a','gigabytes',0,0,NULL,'d54caddb-c1a6-4c3f-b2f9-7d1717fa702a'),('2026-01-21 14:15:53.344249','2026-01-21 14:16:08.730869','2026-01-21 14:16:12.496887',157,157,NULL,'4bd635a5dcc14e2b9d854dd0e78ecc0a','shares',0,0,NULL,'d54caddb-c1a6-4c3f-b2f9-7d1717fa702a'),('2026-01-21 14:15:59.918268','2026-01-21 14:16:05.530947',NULL,0,158,'e98a65c358ff470b949414cd13a3245a','a7c6c7c42b5d4ca3933e833a80ca4f97','share_networks',0,0,NULL,NULL),('2026-01-21 14:16:18.928630','2026-01-21 14:17:16.851499',NULL,0,159,'9a2f0c528668499db7c5fb089f64e301','12f72ef945cc4adbb18b25d146f29e19','gigabytes',0,0,NULL,NULL),('2026-01-21 14:16:18.932554','2026-01-21 14:17:16.851502',NULL,0,160,'9a2f0c528668499db7c5fb089f64e301','12f72ef945cc4adbb18b25d146f29e19','shares',0,0,NULL,NULL),('2026-01-21 14:16:18.996710','2026-01-21 14:16:35.775569','2026-01-21 14:16:38.369431',161,161,NULL,'12f72ef945cc4adbb18b25d146f29e19','gigabytes',0,0,NULL,'24dda13d-d1e8-43b2-948e-8336430d5aff'),('2026-01-21 14:16:19.000067','2026-01-21 14:16:35.775570','2026-01-21 14:16:38.369431',162,162,NULL,'12f72ef945cc4adbb18b25d146f29e19','shares',0,0,NULL,'24dda13d-d1e8-43b2-948e-8336430d5aff'),('2026-01-21 14:16:23.291492','2026-01-21 14:17:13.232467',NULL,0,163,'9a2f0c528668499db7c5fb089f64e301','12f72ef945cc4adbb18b25d146f29e19','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-21 14:16:23.295176','2026-01-21 14:17:13.232476',NULL,0,164,'9a2f0c528668499db7c5fb089f64e301','12f72ef945cc4adbb18b25d146f29e19','snapshots',0,0,NULL,NULL),('2026-01-21 14:16:23.305654','2026-01-21 14:16:27.488155','2026-01-21 14:16:38.369431',165,165,NULL,'12f72ef945cc4adbb18b25d146f29e19','snapshot_gigabytes',0,0,NULL,'24dda13d-d1e8-43b2-948e-8336430d5aff'),('2026-01-21 14:16:23.308285','2026-01-21 14:16:27.488156','2026-01-21 14:16:38.369431',166,166,NULL,'12f72ef945cc4adbb18b25d146f29e19','snapshots',0,0,NULL,'24dda13d-d1e8-43b2-948e-8336430d5aff'),('2026-01-21 14:16:27.187734','2026-01-21 14:16:36.721007',NULL,0,167,'9618fae463a3456ab00f4dd42464d5b5','00ad6a9aaa7a46e98273aa36df95068c','shares',0,0,NULL,NULL),('2026-01-21 14:16:27.190614','2026-01-21 14:16:36.721010',NULL,0,168,'9618fae463a3456ab00f4dd42464d5b5','00ad6a9aaa7a46e98273aa36df95068c','gigabytes',0,0,NULL,NULL),('2026-01-21 14:16:27.199995','2026-01-21 14:16:36.721011','2026-01-21 14:16:39.476840',169,169,NULL,'00ad6a9aaa7a46e98273aa36df95068c','shares',0,0,NULL,'06f3f214-12da-4ea9-a206-446558478b75'),('2026-01-21 14:16:27.202038','2026-01-21 14:16:36.721012','2026-01-21 14:16:39.476840',170,170,NULL,'00ad6a9aaa7a46e98273aa36df95068c','gigabytes',0,0,NULL,'06f3f214-12da-4ea9-a206-446558478b75'),('2026-01-21 14:16:37.289953','2026-01-21 14:17:50.905182',NULL,0,171,'c9132702f2324cf7b8026c09a5d89dee','183d8c03d481485397037ffe17a60995','shares',0,0,NULL,NULL),('2026-01-21 14:16:37.415859','2026-01-21 14:17:50.905185',NULL,0,172,'c9132702f2324cf7b8026c09a5d89dee','183d8c03d481485397037ffe17a60995','gigabytes',0,0,NULL,NULL),('2026-01-21 14:16:37.606403','2026-01-21 14:17:50.905187','2026-01-21 14:17:53.150358',173,173,NULL,'183d8c03d481485397037ffe17a60995','shares',0,0,NULL,'e930702d-a3b3-40a2-9f70-64fa8134ddf6'),('2026-01-21 14:16:37.612713','2026-01-21 14:17:50.905189','2026-01-21 14:17:53.150358',174,174,NULL,'183d8c03d481485397037ffe17a60995','gigabytes',0,0,NULL,'e930702d-a3b3-40a2-9f70-64fa8134ddf6'),('2026-01-21 14:16:38.682924','2026-01-21 14:16:43.383039','2026-01-21 14:17:20.686818',175,175,NULL,'12f72ef945cc4adbb18b25d146f29e19','shares',0,0,NULL,'ddce9437-41f6-41e1-9345-e8f73447a2bc'),('2026-01-21 14:16:38.684895','2026-01-21 14:16:43.383041','2026-01-21 14:17:20.686818',176,176,NULL,'12f72ef945cc4adbb18b25d146f29e19','gigabytes',0,0,NULL,'ddce9437-41f6-41e1-9345-e8f73447a2bc'),('2026-01-21 14:16:42.236692','2026-01-21 14:17:46.692397',NULL,0,177,NULL,'183d8c03d481485397037ffe17a60995','gigabytes',0,0,NULL,'b162a983-fd22-416d-b3c5-874636612a2e'),('2026-01-21 14:16:42.245288','2026-01-21 14:17:46.692399',NULL,0,178,NULL,'183d8c03d481485397037ffe17a60995','shares',0,0,NULL,'b162a983-fd22-416d-b3c5-874636612a2e'),('2026-01-21 14:16:46.828552','2026-01-21 14:17:16.851504','2026-01-21 14:17:19.699681',179,179,NULL,'12f72ef945cc4adbb18b25d146f29e19','gigabytes',0,0,NULL,'3ded9bac-2fe5-4f42-8fae-b77fb1f40041'),('2026-01-21 14:16:46.830789','2026-01-21 14:17:16.851506','2026-01-21 14:17:19.699681',180,180,NULL,'12f72ef945cc4adbb18b25d146f29e19','shares',0,0,NULL,'3ded9bac-2fe5-4f42-8fae-b77fb1f40041'),('2026-01-21 14:16:50.223583','2026-01-21 14:17:42.835827',NULL,0,181,'53e1b03c59294270a311e7426f54bef6','6b53653c238d45b18082508e065d099c','gigabytes',0,0,NULL,NULL),('2026-01-21 14:16:50.225592','2026-01-21 14:17:42.835830',NULL,0,182,'53e1b03c59294270a311e7426f54bef6','6b53653c238d45b18082508e065d099c','shares',0,0,NULL,NULL),('2026-01-21 14:16:50.706214','2026-01-21 14:17:42.835831',NULL,0,183,NULL,'6b53653c238d45b18082508e065d099c','gigabytes',0,0,NULL,'b162a983-fd22-416d-b3c5-874636612a2e'),('2026-01-21 14:16:50.708488','2026-01-21 14:17:42.835832',NULL,0,184,NULL,'6b53653c238d45b18082508e065d099c','shares',0,0,NULL,'b162a983-fd22-416d-b3c5-874636612a2e'),('2026-01-21 14:16:51.881756','2026-01-21 14:17:13.232478','2026-01-21 14:17:19.699681',185,185,NULL,'12f72ef945cc4adbb18b25d146f29e19','snapshot_gigabytes',0,0,NULL,'3ded9bac-2fe5-4f42-8fae-b77fb1f40041'),('2026-01-21 14:16:51.887593','2026-01-21 14:17:13.232480','2026-01-21 14:17:19.699681',186,186,NULL,'12f72ef945cc4adbb18b25d146f29e19','snapshots',0,0,NULL,'3ded9bac-2fe5-4f42-8fae-b77fb1f40041'),('2026-01-21 14:16:53.526607','2026-01-21 14:16:53.586680',NULL,0,187,'1e36f40dbb4a41dfa0a09d53e38a09a3','78145dbf5c284a599c7efda43d8f4201','share_networks',1,0,NULL,NULL),('2026-01-21 14:17:08.147091','2026-01-21 14:17:20.054935',NULL,0,188,'6cb2e0df2e5e4f68acb0a95b2439997b','e5bede18d60e4bb389fabc44847d9a1a','gigabytes',1,0,NULL,NULL),('2026-01-21 14:17:08.150289','2026-01-21 14:17:20.054937',NULL,0,189,'6cb2e0df2e5e4f68acb0a95b2439997b','e5bede18d60e4bb389fabc44847d9a1a','shares',1,0,NULL,NULL),('2026-01-21 14:17:08.162432','2026-01-21 14:17:20.054939','2026-01-21 14:17:24.331165',190,190,NULL,'e5bede18d60e4bb389fabc44847d9a1a','gigabytes',1,0,NULL,'a35627cc-f912-49fe-a347-ce5ebde9e5e7'),('2026-01-21 14:17:08.165024','2026-01-21 14:17:20.054940','2026-01-21 14:17:24.331165',191,191,NULL,'e5bede18d60e4bb389fabc44847d9a1a','shares',1,0,NULL,'a35627cc-f912-49fe-a347-ce5ebde9e5e7'),('2026-01-21 14:17:11.772952','2026-01-21 14:17:12.731866',NULL,0,192,'14b1b7ca69c94906ab006f47db3af123','3fdd89fc56bc4e1e80efe02dccfd1c88','gigabytes',0,0,NULL,NULL),('2026-01-21 14:17:11.780599','2026-01-21 14:17:12.731869',NULL,0,193,'14b1b7ca69c94906ab006f47db3af123','3fdd89fc56bc4e1e80efe02dccfd1c88','shares',0,0,NULL,NULL),('2026-01-21 14:17:11.803607','2026-01-21 14:17:12.147765',NULL,0,194,'14b1b7ca69c94906ab006f47db3af123','e5bede18d60e4bb389fabc44847d9a1a','gigabytes',-1,0,NULL,NULL),('2026-01-21 14:17:11.805326','2026-01-21 14:17:12.147771',NULL,0,195,'14b1b7ca69c94906ab006f47db3af123','e5bede18d60e4bb389fabc44847d9a1a','shares',-1,0,NULL,NULL),('2026-01-21 14:17:12.713588','2026-01-21 14:17:12.731870','2026-01-21 14:17:24.331165',196,196,NULL,'3fdd89fc56bc4e1e80efe02dccfd1c88','shares',0,0,NULL,'a35627cc-f912-49fe-a347-ce5ebde9e5e7'),('2026-01-21 14:17:12.717398','2026-01-21 14:17:12.731871','2026-01-21 14:17:24.331165',197,197,NULL,'3fdd89fc56bc4e1e80efe02dccfd1c88','gigabytes',0,0,NULL,'a35627cc-f912-49fe-a347-ce5ebde9e5e7'),('2026-01-21 14:17:22.145874','2026-01-21 14:17:39.173787','2026-01-21 14:17:53.150358',198,198,NULL,'6b53653c238d45b18082508e065d099c','gigabytes',0,0,NULL,'e930702d-a3b3-40a2-9f70-64fa8134ddf6'),('2026-01-21 14:17:22.148876','2026-01-21 14:17:39.173788','2026-01-21 14:17:53.150358',199,199,NULL,'6b53653c238d45b18082508e065d099c','shares',0,0,NULL,'e930702d-a3b3-40a2-9f70-64fa8134ddf6'),('2026-01-21 14:17:33.050808','2026-01-21 14:18:36.081739',NULL,0,200,'3f155a642cbe41c5a9ffda4ad895b42a','42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',0,0,NULL,NULL),('2026-01-21 14:17:33.053388','2026-01-21 14:18:36.081742',NULL,0,201,'3f155a642cbe41c5a9ffda4ad895b42a','42d0f9e7ca75499fafa3885d62f2fa91','shares',0,0,NULL,NULL),('2026-01-21 14:17:33.107039','2026-01-21 14:18:36.081743','2026-01-21 14:18:39.257571',202,202,NULL,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',0,0,NULL,'113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:17:33.109368','2026-01-21 14:18:36.081745','2026-01-21 14:18:39.257571',203,203,NULL,'42d0f9e7ca75499fafa3885d62f2fa91','shares',0,0,NULL,'113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:17:36.910000','2026-01-21 14:18:33.070148',NULL,0,204,'3f155a642cbe41c5a9ffda4ad895b42a','42d0f9e7ca75499fafa3885d62f2fa91','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-21 14:17:36.915442','2026-01-21 14:18:33.070150',NULL,0,205,'3f155a642cbe41c5a9ffda4ad895b42a','42d0f9e7ca75499fafa3885d62f2fa91','snapshots',0,0,NULL,NULL),('2026-01-21 14:17:38.109340','2026-01-21 14:18:33.070152','2026-01-21 14:18:39.257571',206,206,NULL,'42d0f9e7ca75499fafa3885d62f2fa91','snapshot_gigabytes',0,0,NULL,'113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:17:38.114157','2026-01-21 14:18:33.070153','2026-01-21 14:18:39.257571',207,207,NULL,'42d0f9e7ca75499fafa3885d62f2fa91','snapshots',0,0,NULL,'113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:17:44.919859','2026-01-21 14:18:29.014769',NULL,0,208,'847ff8e5688c42c1bb942b9ed884ef49','057c07904cd34efc9ceea6ab2d3e4d04','gigabytes',0,0,NULL,NULL),('2026-01-21 14:17:44.922573','2026-01-21 14:18:29.014772',NULL,0,209,'847ff8e5688c42c1bb942b9ed884ef49','057c07904cd34efc9ceea6ab2d3e4d04','shares',0,0,NULL,NULL),('2026-01-21 14:17:45.001298','2026-01-21 14:18:29.014773','2026-01-21 14:18:32.255287',210,210,NULL,'057c07904cd34efc9ceea6ab2d3e4d04','gigabytes',0,0,NULL,'a36cdb63-0be1-431b-b3a6-13bc024a485c'),('2026-01-21 14:17:45.008500','2026-01-21 14:18:29.014774','2026-01-21 14:18:32.255287',211,211,NULL,'057c07904cd34efc9ceea6ab2d3e4d04','shares',0,0,NULL,'a36cdb63-0be1-431b-b3a6-13bc024a485c'),('2026-01-21 14:18:00.351286','2026-01-21 14:18:16.660280',NULL,0,212,'847ff8e5688c42c1bb942b9ed884ef49','057c07904cd34efc9ceea6ab2d3e4d04','share_groups',0,0,NULL,NULL),('2026-01-21 14:18:19.201978','2026-01-21 14:18:30.985415',NULL,0,213,'4a2fe10fc9e348b7882f646ffc46378a','3cc89d84bffa401eab10c32a2f4b29d2','gigabytes',0,0,NULL,NULL),('2026-01-21 14:18:19.205360','2026-01-21 14:18:30.985418',NULL,0,214,'4a2fe10fc9e348b7882f646ffc46378a','3cc89d84bffa401eab10c32a2f4b29d2','shares',0,0,NULL,NULL),('2026-01-21 14:18:19.239202','2026-01-21 14:18:30.985420','2026-01-21 14:18:34.136705',215,215,NULL,'3cc89d84bffa401eab10c32a2f4b29d2','gigabytes',0,0,NULL,'f78ae5cb-fced-4e97-b8cd-e69b71d0827c'),('2026-01-21 14:18:19.243040','2026-01-21 14:18:30.985422','2026-01-21 14:18:34.136705',216,216,NULL,'3cc89d84bffa401eab10c32a2f4b29d2','shares',0,0,NULL,'f78ae5cb-fced-4e97-b8cd-e69b71d0827c'),('2026-01-21 14:18:22.797170','2026-01-21 14:18:28.023213',NULL,0,217,'4a2fe10fc9e348b7882f646ffc46378a','3cc89d84bffa401eab10c32a2f4b29d2','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-21 14:18:22.799296','2026-01-21 14:18:28.023216',NULL,0,218,'4a2fe10fc9e348b7882f646ffc46378a','3cc89d84bffa401eab10c32a2f4b29d2','snapshots',0,0,NULL,NULL),('2026-01-21 14:18:22.813469','2026-01-21 14:18:28.023217','2026-01-21 14:18:34.136705',219,219,NULL,'3cc89d84bffa401eab10c32a2f4b29d2','snapshot_gigabytes',0,0,NULL,'f78ae5cb-fced-4e97-b8cd-e69b71d0827c'),('2026-01-21 14:18:22.820545','2026-01-21 14:18:28.023218','2026-01-21 14:18:34.136705',220,220,NULL,'3cc89d84bffa401eab10c32a2f4b29d2','snapshots',0,0,NULL,'f78ae5cb-fced-4e97-b8cd-e69b71d0827c'),('2026-01-21 14:18:49.062165','2026-01-21 14:19:43.469816',NULL,0,221,'51daa32984f24d90b50a4cba851c93da','3efc5d38bf75484d9e4b2aed22003264','gigabytes',0,0,NULL,NULL),('2026-01-21 14:18:49.066474','2026-01-21 14:19:43.469819',NULL,0,222,'51daa32984f24d90b50a4cba851c93da','3efc5d38bf75484d9e4b2aed22003264','shares',0,0,NULL,NULL),('2026-01-21 14:18:49.080335','2026-01-21 14:19:43.469820','2026-01-21 14:19:46.781536',223,223,NULL,'3efc5d38bf75484d9e4b2aed22003264','gigabytes',0,0,NULL,'fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:18:49.083738','2026-01-21 14:19:43.469821','2026-01-21 14:19:46.781536',224,224,NULL,'3efc5d38bf75484d9e4b2aed22003264','shares',0,0,NULL,'fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:18:53.349348','2026-01-21 14:19:41.348472',NULL,0,225,'51daa32984f24d90b50a4cba851c93da','3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-21 14:18:53.351257','2026-01-21 14:19:41.348475',NULL,0,226,'51daa32984f24d90b50a4cba851c93da','3efc5d38bf75484d9e4b2aed22003264','snapshots',0,0,NULL,NULL),('2026-01-21 14:18:53.362463','2026-01-21 14:19:41.348477','2026-01-21 14:19:46.781536',227,227,NULL,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',0,0,NULL,'fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:18:53.365083','2026-01-21 14:19:41.348479','2026-01-21 14:19:46.781536',228,228,NULL,'3efc5d38bf75484d9e4b2aed22003264','snapshots',0,0,NULL,'fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:19:07.222803','2026-01-21 14:19:07.440056',NULL,0,229,'b01f23e1df1240dd9949216a2466ed8c','7be9e3a0119b40f692133210ebe5f9a2','gigabytes',1,0,NULL,NULL),('2026-01-21 14:19:07.360820','2026-01-21 14:19:07.440057',NULL,0,230,'b01f23e1df1240dd9949216a2466ed8c','7be9e3a0119b40f692133210ebe5f9a2','shares',1,0,NULL,NULL),('2026-01-21 14:19:09.999174','2026-01-21 14:19:13.143869',NULL,0,231,'1bdd99b08fdf48cbae340f6fab64e0de','3045c953c1f44932b48db800dd54be02','share_networks',0,0,NULL,NULL),('2026-01-21 14:19:19.667222','2026-01-21 14:19:24.096027',NULL,0,232,'5e463fc3b37f4ad683d113fe4e8b2d6a','e5d2b19b5e42472bbc153671b4a835ba','share_networks',0,0,NULL,NULL),('2026-01-21 14:20:14.233266','2026-01-21 14:20:16.059378',NULL,0,233,'6ec525d992e341d68f12ae0cac568446','273b0f88119142bb88f70bd49708607c','share_networks',0,0,NULL,NULL),('2026-01-21 14:20:29.302613','2026-01-21 14:20:57.432521',NULL,0,234,'8f91d7fab0ee4a86a798bfda435f3ff4','265433c915284e308788d3048cf90078','gigabytes',0,0,NULL,NULL),('2026-01-21 14:20:29.305269','2026-01-21 14:20:57.432523',NULL,0,235,'8f91d7fab0ee4a86a798bfda435f3ff4','265433c915284e308788d3048cf90078','shares',0,0,NULL,NULL),('2026-01-21 14:20:29.314215','2026-01-21 14:20:57.432525','2026-01-21 14:21:00.248396',236,236,NULL,'265433c915284e308788d3048cf90078','gigabytes',0,0,NULL,'703cfc70-9932-41ed-8a49-185d2994a4af'),('2026-01-21 14:20:29.316452','2026-01-21 14:20:57.432526','2026-01-21 14:21:00.248396',237,237,NULL,'265433c915284e308788d3048cf90078','shares',0,0,NULL,'703cfc70-9932-41ed-8a49-185d2994a4af'),('2026-01-21 14:21:12.415637','2026-01-21 14:22:59.913794',NULL,0,238,'67dae406f3fa410bac4003400c38ab9e','41d4aecafc20406482129223e7dd4624','gigabytes',0,0,NULL,NULL),('2026-01-21 14:21:12.419079','2026-01-21 14:22:59.913799',NULL,0,239,'67dae406f3fa410bac4003400c38ab9e','41d4aecafc20406482129223e7dd4624','shares',0,0,NULL,NULL),('2026-01-21 14:21:12.428638','2026-01-21 14:22:59.913801','2026-01-21 14:23:02.690163',240,240,NULL,'41d4aecafc20406482129223e7dd4624','gigabytes',0,0,NULL,'cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:21:12.430972','2026-01-21 14:22:59.913811','2026-01-21 14:23:02.690163',241,241,NULL,'41d4aecafc20406482129223e7dd4624','shares',0,0,NULL,'cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:21:16.164979','2026-01-21 14:22:56.220533',NULL,0,242,'67dae406f3fa410bac4003400c38ab9e','41d4aecafc20406482129223e7dd4624','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-21 14:21:16.170018','2026-01-21 14:22:56.220535',NULL,0,243,'67dae406f3fa410bac4003400c38ab9e','41d4aecafc20406482129223e7dd4624','snapshots',0,0,NULL,NULL),('2026-01-21 14:21:16.182304','2026-01-21 14:22:56.220537','2026-01-21 14:23:02.690163',244,244,NULL,'41d4aecafc20406482129223e7dd4624','snapshot_gigabytes',0,0,NULL,'cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:21:16.186028','2026-01-21 14:22:56.220538','2026-01-21 14:23:02.690163',245,245,NULL,'41d4aecafc20406482129223e7dd4624','snapshots',0,0,NULL,'cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:23:26.677374','2026-01-21 14:23:52.476706',NULL,0,246,'40585f18d2e84161b8eca432bf37306f','18bcd7a466594b3abec112774943eca1','gigabytes',0,0,NULL,NULL),('2026-01-21 14:23:26.679561','2026-01-21 14:23:52.476709',NULL,0,247,'40585f18d2e84161b8eca432bf37306f','18bcd7a466594b3abec112774943eca1','shares',0,0,NULL,NULL),('2026-01-21 14:23:26.716247','2026-01-21 14:23:52.476711','2026-01-21 14:23:55.091550',248,248,NULL,'18bcd7a466594b3abec112774943eca1','gigabytes',0,0,NULL,'a1bc5a3b-4487-4ec2-9108-ad6c89a426e4'),('2026-01-21 14:23:26.718417','2026-01-21 14:23:52.476712','2026-01-21 14:23:55.091550',249,249,NULL,'18bcd7a466594b3abec112774943eca1','shares',0,0,NULL,'a1bc5a3b-4487-4ec2-9108-ad6c89a426e4'),('2026-01-21 14:23:40.241110','2026-01-21 14:23:48.335316',NULL,0,250,'40585f18d2e84161b8eca432bf37306f','18bcd7a466594b3abec112774943eca1','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-21 14:23:40.244069','2026-01-21 14:23:48.335321',NULL,0,251,'40585f18d2e84161b8eca432bf37306f','18bcd7a466594b3abec112774943eca1','snapshots',0,0,NULL,NULL),('2026-01-21 14:23:40.537653','2026-01-21 14:23:48.335323','2026-01-21 14:23:55.091550',252,252,NULL,'18bcd7a466594b3abec112774943eca1','snapshot_gigabytes',0,0,NULL,'a1bc5a3b-4487-4ec2-9108-ad6c89a426e4'),('2026-01-21 14:23:40.540120','2026-01-21 14:23:48.335324','2026-01-21 14:23:55.091550',253,253,NULL,'18bcd7a466594b3abec112774943eca1','snapshots',0,0,NULL,'a1bc5a3b-4487-4ec2-9108-ad6c89a426e4'),('2026-01-21 14:24:25.132249','2026-01-21 14:24:53.499817',NULL,0,254,'37b3bbc0092f402c82354dc1111facd4','a4f094a58f4542e2ab299637736993f9','gigabytes',0,0,NULL,NULL),('2026-01-21 14:24:25.134397','2026-01-21 14:24:53.499820',NULL,0,255,'37b3bbc0092f402c82354dc1111facd4','a4f094a58f4542e2ab299637736993f9','shares',0,0,NULL,NULL),('2026-01-21 14:24:25.145569','2026-01-21 14:24:53.499821','2026-01-21 14:24:56.037623',256,256,NULL,'a4f094a58f4542e2ab299637736993f9','gigabytes',0,0,NULL,'f7db249e-6360-4f95-914d-c75a6989e840'),('2026-01-21 14:24:25.149123','2026-01-21 14:24:53.499822','2026-01-21 14:24:56.037623',257,257,NULL,'a4f094a58f4542e2ab299637736993f9','shares',0,0,NULL,'f7db249e-6360-4f95-914d-c75a6989e840'),('2026-01-21 14:24:29.323556','2026-01-21 14:24:50.566295',NULL,0,258,'37b3bbc0092f402c82354dc1111facd4','a4f094a58f4542e2ab299637736993f9','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-21 14:24:29.330867','2026-01-21 14:24:50.566298',NULL,0,259,'37b3bbc0092f402c82354dc1111facd4','a4f094a58f4542e2ab299637736993f9','snapshots',0,0,NULL,NULL),('2026-01-21 14:24:29.350713','2026-01-21 14:24:50.566300','2026-01-21 14:24:56.037623',260,260,NULL,'a4f094a58f4542e2ab299637736993f9','snapshot_gigabytes',0,0,NULL,'f7db249e-6360-4f95-914d-c75a6989e840'),('2026-01-21 14:24:29.353360','2026-01-21 14:24:50.566302','2026-01-21 14:24:56.037623',261,261,NULL,'a4f094a58f4542e2ab299637736993f9','snapshots',0,0,NULL,'f7db249e-6360-4f95-914d-c75a6989e840'),('2026-01-21 14:25:06.683184','2026-01-21 14:25:19.790624',NULL,0,262,'1168f378c75641a9a34467d731e79a9e','3ae1279c04024905bd21b77f8a95d5ae','gigabytes',0,0,NULL,NULL),('2026-01-21 14:25:06.687479','2026-01-21 14:25:19.790628',NULL,0,263,'1168f378c75641a9a34467d731e79a9e','3ae1279c04024905bd21b77f8a95d5ae','shares',0,0,NULL,NULL),('2026-01-21 14:25:06.700396','2026-01-21 14:25:19.790629','2026-01-21 14:25:22.954078',264,264,NULL,'3ae1279c04024905bd21b77f8a95d5ae','gigabytes',0,0,NULL,'7c9297d5-c3a5-4113-9133-2dae5de6223a'),('2026-01-21 14:25:06.706939','2026-01-21 14:25:19.790631','2026-01-21 14:25:22.954078',265,265,NULL,'3ae1279c04024905bd21b77f8a95d5ae','shares',0,0,NULL,'7c9297d5-c3a5-4113-9133-2dae5de6223a'),('2026-01-21 14:25:10.265503','2026-01-21 14:25:16.311402',NULL,0,266,'1168f378c75641a9a34467d731e79a9e','3ae1279c04024905bd21b77f8a95d5ae','snapshot_gigabytes',0,0,NULL,NULL),('2026-01-21 14:25:10.269441','2026-01-21 14:25:16.311405',NULL,0,267,'1168f378c75641a9a34467d731e79a9e','3ae1279c04024905bd21b77f8a95d5ae','snapshots',0,0,NULL,NULL),('2026-01-21 14:25:10.283471','2026-01-21 14:25:16.311407','2026-01-21 14:25:22.954078',268,268,NULL,'3ae1279c04024905bd21b77f8a95d5ae','snapshot_gigabytes',0,0,NULL,'7c9297d5-c3a5-4113-9133-2dae5de6223a'),('2026-01-21 14:25:10.286783','2026-01-21 14:25:16.311408','2026-01-21 14:25:22.954078',269,269,NULL,'3ae1279c04024905bd21b77f8a95d5ae','snapshots',0,0,NULL,'7c9297d5-c3a5-4113-9133-2dae5de6223a');
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
INSERT INTO `quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2026-01-21 14:11:01.888340',NULL,'2026-01-21 14:11:21.372313',1,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',3),(2,'2026-01-21 14:11:01.914482',NULL,'2026-01-21 14:11:21.372313',2,'50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',10),(3,'2026-01-21 14:11:21.704473',NULL,'2026-01-21 14:11:22.483989',3,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',55),(4,'2026-01-21 14:11:21.711246',NULL,'2026-01-21 14:11:22.483989',4,'50bb744aaa0a40ecbfeaa20d4e691f46','snapshots',55),(5,'2026-01-21 14:11:21.722951',NULL,'2026-01-21 14:11:22.483989',5,'50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',1005),(6,'2026-01-21 14:11:21.728224',NULL,'2026-01-21 14:11:22.483989',6,'50bb744aaa0a40ecbfeaa20d4e691f46','snapshot_gigabytes',1005),(7,'2026-01-21 14:11:21.760062',NULL,'2026-01-21 14:11:22.483989',7,'50bb744aaa0a40ecbfeaa20d4e691f46','share_replicas',105),(8,'2026-01-21 14:11:21.776246',NULL,'2026-01-21 14:11:22.483989',8,'50bb744aaa0a40ecbfeaa20d4e691f46','replica_gigabytes',1005),(9,'2026-01-21 14:11:22.910257',NULL,'2026-01-21 14:11:24.238906',9,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',55),(10,'2026-01-21 14:11:22.954691',NULL,'2026-01-21 14:11:24.238906',10,'50bb744aaa0a40ecbfeaa20d4e691f46','snapshots',55),(11,'2026-01-21 14:11:22.967114',NULL,'2026-01-21 14:11:24.238906',11,'50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',1005),(12,'2026-01-21 14:11:22.993956',NULL,'2026-01-21 14:11:24.238906',12,'50bb744aaa0a40ecbfeaa20d4e691f46','snapshot_gigabytes',1005),(13,'2026-01-21 14:11:23.033660',NULL,'2026-01-21 14:11:24.238906',13,'50bb744aaa0a40ecbfeaa20d4e691f46','share_replicas',105),(14,'2026-01-21 14:11:23.067041',NULL,'2026-01-21 14:11:24.238906',14,'50bb744aaa0a40ecbfeaa20d4e691f46','replica_gigabytes',1005),(15,'2026-01-21 14:11:24.739949',NULL,'2026-01-21 14:11:25.137750',15,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',52),(16,'2026-01-21 14:11:24.839443',NULL,'2026-01-21 14:11:25.194609',16,'2806d215025845bc90e195f0b5c64c21','shares',1),(17,'2026-01-21 14:11:24.931215',NULL,'2026-01-21 14:11:25.137750',17,'50bb744aaa0a40ecbfeaa20d4e691f46','snapshots',52),(18,'2026-01-21 14:11:24.938570',NULL,'2026-01-21 14:11:25.137750',18,'50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',1002),(19,'2026-01-21 14:11:24.977322',NULL,'2026-01-21 14:11:25.137750',19,'50bb744aaa0a40ecbfeaa20d4e691f46','snapshot_gigabytes',1002),(20,'2026-01-21 14:11:24.996666',NULL,'2026-01-21 14:11:25.137750',20,'50bb744aaa0a40ecbfeaa20d4e691f46','share_networks',12),(21,'2026-01-21 14:11:25.002250',NULL,'2026-01-21 14:11:25.137750',21,'50bb744aaa0a40ecbfeaa20d4e691f46','share_replicas',102),(22,'2026-01-21 14:11:25.028837',NULL,'2026-01-21 14:11:25.137750',22,'50bb744aaa0a40ecbfeaa20d4e691f46','replica_gigabytes',1002),(23,'2026-01-21 14:11:25.637294',NULL,'2026-01-21 14:11:27.455590',23,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',13),(24,'2026-01-21 14:11:27.590202',NULL,'2026-01-21 14:11:27.832420',24,'50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',-1),(25,'2026-01-21 14:11:27.960576',NULL,'2026-01-21 14:11:28.158218',25,'50bb744aaa0a40ecbfeaa20d4e691f46','share_replicas',-1),(26,'2026-01-21 14:11:28.274978',NULL,'2026-01-21 14:11:28.486174',26,'50bb744aaa0a40ecbfeaa20d4e691f46','replica_gigabytes',-1),(27,'2026-01-21 14:11:28.685705',NULL,'2026-01-21 14:11:28.829177',27,'50bb744aaa0a40ecbfeaa20d4e691f46','share_networks',-1),(28,'2026-01-21 14:11:29.029333',NULL,'2026-01-21 14:11:29.200522',28,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',-1),(29,'2026-01-21 14:11:29.461055',NULL,'2026-01-21 14:11:29.868783',29,'50bb744aaa0a40ecbfeaa20d4e691f46','snapshot_gigabytes',-1),(30,'2026-01-21 14:11:30.030458',NULL,'2026-01-21 14:11:30.294756',30,'50bb744aaa0a40ecbfeaa20d4e691f46','snapshots',-1),(31,'2026-01-21 14:11:30.605921',NULL,'2026-01-21 14:11:36.648713',31,'2806d215025845bc90e195f0b5c64c21','snapshots',1),(32,'2026-01-21 14:11:39.886968',NULL,'2026-01-21 14:11:40.442156',32,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',10),(33,'2026-01-21 14:11:40.981874',NULL,'2026-01-21 14:11:41.542781',33,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',10),(34,'2026-01-21 14:11:41.835396',NULL,'2026-01-21 14:11:41.980407',34,'50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',1002),(35,'2026-01-21 14:11:42.272502',NULL,'2026-01-21 14:11:43.030387',35,'50bb744aaa0a40ecbfeaa20d4e691f46','share_networks',12),(36,'2026-01-21 14:11:43.412670',NULL,'2026-01-21 14:11:43.494852',36,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',52),(37,'2026-01-21 14:11:43.784194',NULL,'2026-01-21 14:11:43.903721',37,'50bb744aaa0a40ecbfeaa20d4e691f46','snapshot_gigabytes',1002),(38,'2026-01-21 14:11:44.165984',NULL,'2026-01-21 14:11:44.329043',38,'50bb744aaa0a40ecbfeaa20d4e691f46','snapshots',52),(39,'2026-01-21 14:11:44.987473',NULL,'2026-01-21 14:11:45.149852',39,'50bb744aaa0a40ecbfeaa20d4e691f46','share_replicas',99),(40,'2026-01-21 14:11:45.962364',NULL,'2026-01-21 14:11:46.853329',40,'2806d215025845bc90e195f0b5c64c21','shares',10),(41,'2026-01-21 14:11:46.358851',NULL,'2026-01-21 14:11:46.867846',41,'50bb744aaa0a40ecbfeaa20d4e691f46','replica_gigabytes',999),(42,'2026-01-21 14:11:47.443458',NULL,'2026-01-21 14:11:47.782985',42,'2806d215025845bc90e195f0b5c64c21','shares',10),(43,'2026-01-21 14:11:56.891820',NULL,'2026-01-21 14:11:57.703926',43,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',10),(44,'2026-01-21 14:11:58.102327',NULL,'2026-01-21 14:11:59.187365',44,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',10);
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `usage_id` (`usage_id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=976 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `share_type_id`) VALUES ('2026-01-21 14:10:20.825956',NULL,'2026-01-21 14:10:21.029175',1,1,'9f6fd3bf04e94f2d8e668d8e93cb0afa','29b42836-82f9-4122-9fb1-c729e821b66a',1,'81d0568612894d6da94e01a77bfde64f','shares',1,'2026-01-22 14:10:20',NULL),('2026-01-21 14:10:20.829190',NULL,'2026-01-21 14:10:21.029175',2,2,'9f6fd3bf04e94f2d8e668d8e93cb0afa','982430ec-e473-4d35-a9c0-59c49edc200b',2,'81d0568612894d6da94e01a77bfde64f','gigabytes',1,'2026-01-22 14:10:20',NULL),('2026-01-21 14:10:20.852429',NULL,'2026-01-21 14:10:21.029175',3,3,NULL,'50649d0d-793a-4875-9b86-3b2e59ec91ae',3,'81d0568612894d6da94e01a77bfde64f','shares',1,'2026-01-22 14:10:20','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:10:20.856326',NULL,'2026-01-21 14:10:21.029175',4,4,NULL,'8120fa2f-353d-4393-b4e7-017453f42b6b',4,'81d0568612894d6da94e01a77bfde64f','gigabytes',1,'2026-01-22 14:10:20','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:10:22.721747',NULL,'2026-01-21 14:10:22.831433',5,5,'c585b1d2d5d64ff09f12475b01bfdb96','440254bb-5b6d-47df-b84e-802f63df3133',6,'25182f2d153d4140867b49ea0c5064d3','shares',1,'2026-01-22 14:10:22',NULL),('2026-01-21 14:10:22.730163',NULL,'2026-01-21 14:10:22.831433',6,6,'c585b1d2d5d64ff09f12475b01bfdb96','11145dbe-e41a-4ae8-8d9e-51f07d70d4dd',5,'25182f2d153d4140867b49ea0c5064d3','gigabytes',1,'2026-01-22 14:10:22',NULL),('2026-01-21 14:10:22.756208',NULL,'2026-01-21 14:10:22.831433',7,7,NULL,'2fd5cb99-7873-408e-a65a-c1d9c3ae30f6',8,'25182f2d153d4140867b49ea0c5064d3','shares',1,'2026-01-22 14:10:22','730c7c03-7e1d-487b-906f-6935715d2b12'),('2026-01-21 14:10:22.757515',NULL,'2026-01-21 14:10:22.831433',8,8,NULL,'dc1b2c37-e16c-4740-bde7-3374b1f882b8',7,'25182f2d153d4140867b49ea0c5064d3','gigabytes',1,'2026-01-22 14:10:22','730c7c03-7e1d-487b-906f-6935715d2b12'),('2026-01-21 14:10:23.377212',NULL,'2026-01-21 14:10:23.554325',9,9,'88612755fd4c490c96b9c4b454fc53d5','cbd6beb4-632f-47d5-a43f-33df95590a06',9,'e17b908e218c4cd78e47e6be458b89a4','shares',1,'2026-01-22 14:10:23',NULL),('2026-01-21 14:10:23.378715',NULL,'2026-01-21 14:10:23.554325',10,10,'88612755fd4c490c96b9c4b454fc53d5','cfaa518a-8f89-4c40-b509-baaa79f11768',10,'e17b908e218c4cd78e47e6be458b89a4','gigabytes',1,'2026-01-22 14:10:23',NULL),('2026-01-21 14:10:23.483061',NULL,'2026-01-21 14:10:23.554325',11,11,NULL,'25e97c14-4169-42a0-aa48-aff72bd60928',11,'e17b908e218c4cd78e47e6be458b89a4','shares',1,'2026-01-22 14:10:23','22f02301-b01e-4d8f-b557-3558b6a3b9a3'),('2026-01-21 14:10:23.487152',NULL,'2026-01-21 14:10:23.554325',12,12,NULL,'95b0d6fe-10e0-4d69-ab0b-dcd2e6e15f07',12,'e17b908e218c4cd78e47e6be458b89a4','gigabytes',1,'2026-01-22 14:10:23','22f02301-b01e-4d8f-b557-3558b6a3b9a3'),('2026-01-21 14:10:25.232707',NULL,'2026-01-21 14:10:25.308702',13,13,'9f6fd3bf04e94f2d8e668d8e93cb0afa','ed61738e-e57a-4ebe-8cf2-e832b3a97ec7',1,'81d0568612894d6da94e01a77bfde64f','shares',1,'2026-01-22 14:10:25',NULL),('2026-01-21 14:10:25.235649',NULL,'2026-01-21 14:10:25.308702',14,14,'9f6fd3bf04e94f2d8e668d8e93cb0afa','be2de665-bda6-42b1-99b3-acab022b35cb',2,'81d0568612894d6da94e01a77bfde64f','gigabytes',1,'2026-01-22 14:10:25',NULL),('2026-01-21 14:10:25.260155',NULL,'2026-01-21 14:10:25.308702',15,15,NULL,'e9a71a6e-c2bc-46bb-9735-7ac13d6499f3',3,'81d0568612894d6da94e01a77bfde64f','shares',1,'2026-01-22 14:10:25','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:10:25.261870',NULL,'2026-01-21 14:10:25.308702',16,16,NULL,'c33e7c14-2822-4dbc-97ef-ecc1f4cb589c',4,'81d0568612894d6da94e01a77bfde64f','gigabytes',1,'2026-01-22 14:10:25','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:10:25.785917',NULL,'2026-01-21 14:10:26.191625',17,17,'9f6fd3bf04e94f2d8e668d8e93cb0afa','58c0e4a7-0d1f-4229-a476-8cbdd22cf3b0',2,'81d0568612894d6da94e01a77bfde64f','gigabytes',1,'2026-01-22 14:10:25',NULL),('2026-01-21 14:10:25.796034',NULL,'2026-01-21 14:10:26.191625',18,18,NULL,'a4a4b472-a8ac-4bc1-9aaf-16d7a0bd3cba',4,'81d0568612894d6da94e01a77bfde64f','gigabytes',1,'2026-01-22 14:10:25','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:10:28.788967',NULL,'2026-01-21 14:10:28.821730',19,19,'9f6fd3bf04e94f2d8e668d8e93cb0afa','1109dc01-4b17-4b77-9628-b16b77911287',1,'81d0568612894d6da94e01a77bfde64f','shares',-1,'2026-01-22 14:10:28',NULL),('2026-01-21 14:10:28.790083',NULL,'2026-01-21 14:10:28.821730',20,20,'9f6fd3bf04e94f2d8e668d8e93cb0afa','f5a3a712-45c1-4dd0-9f73-74e72a28bba7',2,'81d0568612894d6da94e01a77bfde64f','gigabytes',-2,'2026-01-22 14:10:28',NULL),('2026-01-21 14:10:28.796510',NULL,'2026-01-21 14:10:28.821730',21,21,NULL,'f4d249b9-44a2-4abc-833a-a037bb2f9548',3,'81d0568612894d6da94e01a77bfde64f','shares',-1,'2026-01-22 14:10:28','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:10:28.797361',NULL,'2026-01-21 14:10:28.821730',22,22,NULL,'5cfa05af-c217-4746-aeff-01460720fd00',4,'81d0568612894d6da94e01a77bfde64f','gigabytes',-2,'2026-01-22 14:10:28','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:10:31.614930',NULL,'2026-01-21 14:10:31.637069',23,23,'88612755fd4c490c96b9c4b454fc53d5','3ec00d54-80bb-49ae-ae94-1abccc627614',9,'e17b908e218c4cd78e47e6be458b89a4','shares',-1,'2026-01-22 14:10:31',NULL),('2026-01-21 14:10:31.615734',NULL,'2026-01-21 14:10:31.637069',24,24,'88612755fd4c490c96b9c4b454fc53d5','93cac19a-a29f-49b9-8bec-e76839a60a88',10,'e17b908e218c4cd78e47e6be458b89a4','gigabytes',-1,'2026-01-22 14:10:31',NULL),('2026-01-21 14:10:31.623587',NULL,'2026-01-21 14:10:31.637069',25,25,NULL,'f7438717-cc8f-41dc-a9d1-bfe835726082',11,'e17b908e218c4cd78e47e6be458b89a4','shares',-1,'2026-01-22 14:10:31','22f02301-b01e-4d8f-b557-3558b6a3b9a3'),('2026-01-21 14:10:31.625285',NULL,'2026-01-21 14:10:31.637069',26,26,NULL,'5df1b7c4-016a-461c-9f25-6dccfb4c1773',12,'e17b908e218c4cd78e47e6be458b89a4','gigabytes',-1,'2026-01-22 14:10:31','22f02301-b01e-4d8f-b557-3558b6a3b9a3'),('2026-01-21 14:10:31.820368',NULL,'2026-01-21 14:10:31.936863',27,27,'9f6fd3bf04e94f2d8e668d8e93cb0afa','8bc35519-2dc9-46c5-9689-6b059d8d899a',1,'81d0568612894d6da94e01a77bfde64f','shares',1,'2026-01-22 14:10:31',NULL),('2026-01-21 14:10:31.822592',NULL,'2026-01-21 14:10:31.936863',28,28,'9f6fd3bf04e94f2d8e668d8e93cb0afa','fe4f86da-1482-45b4-89db-8e04f8cf9ae8',2,'81d0568612894d6da94e01a77bfde64f','gigabytes',1,'2026-01-22 14:10:31',NULL),('2026-01-21 14:10:31.829901',NULL,'2026-01-21 14:10:31.936863',29,29,NULL,'1b4f9445-1161-4598-af11-085888972b43',3,'81d0568612894d6da94e01a77bfde64f','shares',1,'2026-01-22 14:10:31','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:10:31.831385',NULL,'2026-01-21 14:10:31.936863',30,30,NULL,'158a89ca-290f-43a6-a29a-87403288ef68',4,'81d0568612894d6da94e01a77bfde64f','gigabytes',1,'2026-01-22 14:10:31','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:10:33.279567',NULL,'2026-01-21 14:10:33.778426',31,31,'c585b1d2d5d64ff09f12475b01bfdb96','d49f6fa1-9a32-4d71-90a4-745fbd6a88ec',6,'25182f2d153d4140867b49ea0c5064d3','shares',-1,'2026-01-22 14:10:33',NULL),('2026-01-21 14:10:33.281156',NULL,'2026-01-21 14:10:33.778426',32,32,'c585b1d2d5d64ff09f12475b01bfdb96','3947043b-af45-468f-a0f6-21dd112fa523',5,'25182f2d153d4140867b49ea0c5064d3','gigabytes',-1,'2026-01-22 14:10:33',NULL),('2026-01-21 14:10:33.586171',NULL,'2026-01-21 14:10:33.778426',33,33,NULL,'34900447-44c4-4fb6-9be4-195cdb346497',8,'25182f2d153d4140867b49ea0c5064d3','shares',-1,'2026-01-22 14:10:33','730c7c03-7e1d-487b-906f-6935715d2b12'),('2026-01-21 14:10:33.586966',NULL,'2026-01-21 14:10:33.778426',34,34,NULL,'af84dde1-fa1f-4678-91f4-849c94b9093c',7,'25182f2d153d4140867b49ea0c5064d3','gigabytes',-1,'2026-01-22 14:10:33','730c7c03-7e1d-487b-906f-6935715d2b12'),('2026-01-21 14:10:36.036753',NULL,'2026-01-21 14:10:37.398955',35,35,'9f6fd3bf04e94f2d8e668d8e93cb0afa','ee35cce4-7085-4752-b5c7-e5383ba197b9',2,'81d0568612894d6da94e01a77bfde64f','gigabytes',1,'2026-01-22 14:10:36',NULL),('2026-01-21 14:10:36.827547',NULL,'2026-01-21 14:10:37.398955',36,36,NULL,'488eb2d5-2c73-4773-8b61-7ad9c615f9de',4,'81d0568612894d6da94e01a77bfde64f','gigabytes',1,'2026-01-22 14:10:36','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:10:39.215150',NULL,'2026-01-21 14:10:39.409297',37,37,'9f6fd3bf04e94f2d8e668d8e93cb0afa','f007cba9-f128-4861-8e36-e98fa15914f7',1,'81d0568612894d6da94e01a77bfde64f','shares',-1,'2026-01-22 14:10:39',NULL),('2026-01-21 14:10:39.216232',NULL,'2026-01-21 14:10:39.409297',38,38,'9f6fd3bf04e94f2d8e668d8e93cb0afa','68a47676-c05e-4592-b978-558f0768b332',2,'81d0568612894d6da94e01a77bfde64f','gigabytes',-2,'2026-01-22 14:10:39',NULL),('2026-01-21 14:10:39.377053',NULL,'2026-01-21 14:10:39.409297',39,39,NULL,'67041feb-8eff-447b-a3c6-6e1d5e80d339',3,'81d0568612894d6da94e01a77bfde64f','shares',-1,'2026-01-22 14:10:39','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:10:39.377809',NULL,'2026-01-21 14:10:39.409297',40,40,NULL,'3f574dd2-ea57-4a3d-b30e-c57e524e079a',4,'81d0568612894d6da94e01a77bfde64f','gigabytes',-2,'2026-01-22 14:10:39','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:10:42.485055',NULL,'2026-01-21 14:10:42.771583',41,41,'9f6fd3bf04e94f2d8e668d8e93cb0afa','8854f24f-4076-4c9f-a131-7fef8e779e62',1,'81d0568612894d6da94e01a77bfde64f','shares',1,'2026-01-22 14:10:42',NULL),('2026-01-21 14:10:42.486922',NULL,'2026-01-21 14:10:42.771583',42,42,'9f6fd3bf04e94f2d8e668d8e93cb0afa','c43e78f8-1053-4784-ab82-95f0df3a75f5',2,'81d0568612894d6da94e01a77bfde64f','gigabytes',1,'2026-01-22 14:10:42',NULL),('2026-01-21 14:10:42.510774',NULL,'2026-01-21 14:10:42.771583',43,43,NULL,'b2e87475-4612-4e4d-9d9e-dbaf5356cf19',3,'81d0568612894d6da94e01a77bfde64f','shares',1,'2026-01-22 14:10:42','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:10:42.512425',NULL,'2026-01-21 14:10:42.771583',44,44,NULL,'191e988f-24d2-4a32-b5d5-034b99df9369',4,'81d0568612894d6da94e01a77bfde64f','gigabytes',1,'2026-01-22 14:10:42','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:10:45.959899',NULL,'2026-01-21 14:10:45.983776',45,45,'9f6fd3bf04e94f2d8e668d8e93cb0afa','fe6ec8ec-3b2b-4af9-90f2-450d6376cb38',1,'81d0568612894d6da94e01a77bfde64f','shares',-1,'2026-01-22 14:10:45',NULL),('2026-01-21 14:10:45.960895',NULL,'2026-01-21 14:10:45.983776',46,46,'9f6fd3bf04e94f2d8e668d8e93cb0afa','a598f70d-c5fa-4cca-8d4b-8384926186c1',2,'81d0568612894d6da94e01a77bfde64f','gigabytes',-1,'2026-01-22 14:10:45',NULL),('2026-01-21 14:10:45.968432',NULL,'2026-01-21 14:10:45.983776',47,47,NULL,'5167a8e6-7436-4d61-bcb9-2e60106b85eb',3,'81d0568612894d6da94e01a77bfde64f','shares',-1,'2026-01-22 14:10:45','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:10:45.969684',NULL,'2026-01-21 14:10:45.983776',48,48,NULL,'2ee1f320-ea05-429b-9173-75fd2f525524',4,'81d0568612894d6da94e01a77bfde64f','gigabytes',-1,'2026-01-22 14:10:45','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:10:54.954154',NULL,'2026-01-21 14:10:55.060441',49,49,'9f6fd3bf04e94f2d8e668d8e93cb0afa','482f1847-258b-4bb2-94fd-345c01df33f0',1,'81d0568612894d6da94e01a77bfde64f','shares',1,'2026-01-22 14:10:54',NULL),('2026-01-21 14:10:54.955816',NULL,'2026-01-21 14:10:55.060441',50,50,'9f6fd3bf04e94f2d8e668d8e93cb0afa','afec3bae-b096-49ae-833e-29ad9ae3ecaf',2,'81d0568612894d6da94e01a77bfde64f','gigabytes',1,'2026-01-22 14:10:54',NULL),('2026-01-21 14:10:54.963923',NULL,'2026-01-21 14:10:55.060441',51,51,NULL,'d10673ea-0e24-4e2e-8a33-f4c40fd41c63',3,'81d0568612894d6da94e01a77bfde64f','shares',1,'2026-01-22 14:10:54','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:10:54.966147',NULL,'2026-01-21 14:10:55.060441',52,52,NULL,'2f032014-d0e2-4da1-955e-5b6e9ded5737',4,'81d0568612894d6da94e01a77bfde64f','gigabytes',1,'2026-01-22 14:10:54','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:11:00.146858',NULL,'2026-01-21 14:11:00.281341',53,53,'9f6fd3bf04e94f2d8e668d8e93cb0afa','90781db3-3fcb-4bbd-a175-d40de1f4dd46',1,'81d0568612894d6da94e01a77bfde64f','shares',-1,'2026-01-22 14:11:00',NULL),('2026-01-21 14:11:00.148181',NULL,'2026-01-21 14:11:00.281341',54,54,'9f6fd3bf04e94f2d8e668d8e93cb0afa','8f5d8159-160d-4efe-93ac-c28daba7960d',2,'81d0568612894d6da94e01a77bfde64f','gigabytes',-1,'2026-01-22 14:11:00',NULL),('2026-01-21 14:11:00.234422',NULL,'2026-01-21 14:11:00.281341',55,55,NULL,'e3762073-23e0-4fc8-8d7c-332c686f6468',3,'81d0568612894d6da94e01a77bfde64f','shares',-1,'2026-01-22 14:11:00','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:11:00.235319',NULL,'2026-01-21 14:11:00.281341',56,56,NULL,'a06a6505-ab87-40ce-8cfa-ad5c4b67f5dc',4,'81d0568612894d6da94e01a77bfde64f','gigabytes',-1,'2026-01-22 14:11:00','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:11:03.150664',NULL,'2026-01-21 14:11:03.210715',57,57,'eabd986b9e274262a34ffc9cdfc09733','0bc5cd8f-8bb9-4d8e-856e-6bc50f7c9cce',13,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',1,'2026-01-22 14:11:03',NULL),('2026-01-21 14:11:03.152497',NULL,'2026-01-21 14:11:03.210715',58,58,'eabd986b9e274262a34ffc9cdfc09733','63a7810f-1013-495c-8946-2f26c9cbb5b7',14,'50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',4,'2026-01-22 14:11:03',NULL),('2026-01-21 14:11:03.177000',NULL,'2026-01-21 14:11:03.210715',59,59,NULL,'037daafa-113d-4065-a9c9-8c5a00e9c13c',15,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',1,'2026-01-22 14:11:03','08dc12ec-0496-4207-ab26-687dc1000122'),('2026-01-21 14:11:03.180421',NULL,'2026-01-21 14:11:03.210715',60,60,NULL,'e0071c57-e0f3-4f94-9b22-f783c855589e',16,'50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',4,'2026-01-22 14:11:03','08dc12ec-0496-4207-ab26-687dc1000122'),('2026-01-21 14:11:03.803811',NULL,'2026-01-21 14:11:03.943243',61,61,'9f6fd3bf04e94f2d8e668d8e93cb0afa','cc00d5cb-4ddc-425a-833f-313c2492cafd',18,'81d0568612894d6da94e01a77bfde64f','snapshots',1,'2026-01-22 14:11:03',NULL),('2026-01-21 14:11:03.805068',NULL,'2026-01-21 14:11:03.943243',62,62,'9f6fd3bf04e94f2d8e668d8e93cb0afa','c18a5dd1-930f-41e1-b421-2e067bac992e',17,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',1,'2026-01-22 14:11:03',NULL),('2026-01-21 14:11:03.821337',NULL,'2026-01-21 14:11:03.943243',63,63,NULL,'b9fe0b65-169a-4d7a-94eb-80f2d242454e',20,'81d0568612894d6da94e01a77bfde64f','snapshots',1,'2026-01-22 14:11:03','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:11:03.823049',NULL,'2026-01-21 14:11:03.943243',64,64,NULL,'fd47e3a7-b8e2-4f3a-812f-d2b8e86419f9',19,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',1,'2026-01-22 14:11:03','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:11:05.798659',NULL,'2026-01-21 14:11:05.824034',65,65,'9f6fd3bf04e94f2d8e668d8e93cb0afa','df882e54-ffac-45d6-9f9b-6973911edaca',18,'81d0568612894d6da94e01a77bfde64f','snapshots',-1,'2026-01-22 14:11:05',NULL),('2026-01-21 14:11:05.799738',NULL,'2026-01-21 14:11:05.824034',66,66,'9f6fd3bf04e94f2d8e668d8e93cb0afa','479368a8-ae6f-48c5-b3fe-c9fe7b093c5d',17,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',-1,'2026-01-22 14:11:05',NULL),('2026-01-21 14:11:05.809613',NULL,'2026-01-21 14:11:05.824034',67,67,NULL,'e01adefa-4efa-4205-8807-76dd3d7175aa',20,'81d0568612894d6da94e01a77bfde64f','snapshots',-1,'2026-01-22 14:11:05','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:11:05.810510',NULL,'2026-01-21 14:11:05.824034',68,68,NULL,'f2148345-797f-497b-b780-2b552d32c77e',19,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',-1,'2026-01-22 14:11:05','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:11:07.056820',NULL,'2026-01-21 14:11:07.082949',69,69,'eabd986b9e274262a34ffc9cdfc09733','3307ad4c-22aa-4996-ab1d-173c65bf7ce2',13,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',1,'2026-01-22 14:11:07',NULL),('2026-01-21 14:11:07.059751',NULL,'2026-01-21 14:11:07.082949',70,70,'eabd986b9e274262a34ffc9cdfc09733','1567f3ee-51d4-4997-8273-00e74f31fe4c',14,'50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',3,'2026-01-22 14:11:07',NULL),('2026-01-21 14:11:07.582464',NULL,'2026-01-21 14:11:07.652026',71,71,'eabd986b9e274262a34ffc9cdfc09733','72c1e73c-6dee-4935-803f-4110aa6b420f',13,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',1,'2026-01-22 14:11:07',NULL),('2026-01-21 14:11:07.584262',NULL,'2026-01-21 14:11:07.652026',72,72,'eabd986b9e274262a34ffc9cdfc09733','209e8af2-4a6b-4f67-a18a-0bbf37023be1',14,'50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',3,'2026-01-22 14:11:07',NULL),('2026-01-21 14:11:07.601231',NULL,'2026-01-21 14:11:07.652026',73,73,NULL,'99599bd8-3668-47c6-8168-6055cb12432d',22,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',1,'2026-01-22 14:11:07','3055f25f-99ca-47e1-85fd-3d023797e4ab'),('2026-01-21 14:11:07.603836',NULL,'2026-01-21 14:11:07.652026',74,74,NULL,'fec94f6c-e01e-4b8e-a28e-9bd0112fdc32',21,'50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',3,'2026-01-22 14:11:07','3055f25f-99ca-47e1-85fd-3d023797e4ab'),('2026-01-21 14:11:13.754090',NULL,'2026-01-21 14:11:14.112388',75,75,'eabd986b9e274262a34ffc9cdfc09733','c197f146-af7c-4127-8a94-b4cdedbabb0d',13,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',-1,'2026-01-22 14:11:13',NULL),('2026-01-21 14:11:13.754876',NULL,'2026-01-21 14:11:14.112388',76,76,'eabd986b9e274262a34ffc9cdfc09733','ce33d1e2-fe18-4efb-9fd2-3ef9fdc97777',14,'50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',-4,'2026-01-22 14:11:13',NULL),('2026-01-21 14:11:13.818210',NULL,'2026-01-21 14:11:14.112388',77,77,NULL,'c1f28951-1594-4521-ad22-b56cbee59e4d',15,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',-1,'2026-01-22 14:11:13','08dc12ec-0496-4207-ab26-687dc1000122'),('2026-01-21 14:11:13.821811',NULL,'2026-01-21 14:11:14.112388',78,78,NULL,'c2519fc4-31ca-4ea1-8a72-93b76b0b48e6',16,'50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',-4,'2026-01-22 14:11:13','08dc12ec-0496-4207-ab26-687dc1000122'),('2026-01-21 14:11:17.112009',NULL,'2026-01-21 14:11:17.410916',79,79,'eabd986b9e274262a34ffc9cdfc09733','75dc07df-85ea-4b88-ba4c-a701ea10a9a3',13,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',-1,'2026-01-22 14:11:17',NULL),('2026-01-21 14:11:17.112709',NULL,'2026-01-21 14:11:17.410916',80,80,'eabd986b9e274262a34ffc9cdfc09733','63ef628b-2897-44c2-a7db-4c51ade326da',14,'50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',-3,'2026-01-22 14:11:17',NULL),('2026-01-21 14:11:17.332049',NULL,'2026-01-21 14:11:17.410916',81,81,NULL,'da29b634-9851-4145-acd0-49a012311794',22,'50bb744aaa0a40ecbfeaa20d4e691f46','shares',-1,'2026-01-22 14:11:17','3055f25f-99ca-47e1-85fd-3d023797e4ab'),('2026-01-21 14:11:17.347674',NULL,'2026-01-21 14:11:17.410916',82,82,NULL,'18300252-5e0c-414e-b162-af31b059d0b8',21,'50bb744aaa0a40ecbfeaa20d4e691f46','gigabytes',-3,'2026-01-22 14:11:17','3055f25f-99ca-47e1-85fd-3d023797e4ab'),('2026-01-21 14:11:20.327773',NULL,'2026-01-21 14:11:20.494503',83,83,'9f6fd3bf04e94f2d8e668d8e93cb0afa','e791e70d-1de4-4c4d-a07e-9d0dde09cf12',18,'81d0568612894d6da94e01a77bfde64f','snapshots',1,'2026-01-22 14:11:20',NULL),('2026-01-21 14:11:20.329558',NULL,'2026-01-21 14:11:20.494503',84,84,'9f6fd3bf04e94f2d8e668d8e93cb0afa','f88c55cc-4ac0-4c49-a8f5-109cd1b1528f',17,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',1,'2026-01-22 14:11:20',NULL),('2026-01-21 14:11:20.356235',NULL,'2026-01-21 14:11:20.494503',85,85,NULL,'e644d3ee-ddd8-400d-a304-1643f182bbc0',20,'81d0568612894d6da94e01a77bfde64f','snapshots',1,'2026-01-22 14:11:20','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:11:20.360587',NULL,'2026-01-21 14:11:20.494503',86,86,NULL,'6917f8f6-c5d4-443e-8a4d-db4275aa4aca',19,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',1,'2026-01-22 14:11:20','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:11:21.145957',NULL,'2026-01-21 14:11:21.329121',87,87,'91a5b3e563184701bd5a4f2a997f8221','77369044-0115-4b02-8ace-84a3055016b2',24,'2806d215025845bc90e195f0b5c64c21','shares',1,'2026-01-22 14:11:21',NULL),('2026-01-21 14:11:21.147481',NULL,'2026-01-21 14:11:21.329121',88,88,'91a5b3e563184701bd5a4f2a997f8221','c9918ac0-8e28-49a9-b8cc-e1422aca4f9c',23,'2806d215025845bc90e195f0b5c64c21','gigabytes',1,'2026-01-22 14:11:21',NULL),('2026-01-21 14:11:21.189288',NULL,'2026-01-21 14:11:21.329121',89,89,NULL,'633b8114-963d-4e5d-8520-3ec06d122ed1',26,'2806d215025845bc90e195f0b5c64c21','shares',1,'2026-01-22 14:11:21','c5bac032-cc46-4150-aad5-9325071c0935'),('2026-01-21 14:11:21.243789',NULL,'2026-01-21 14:11:21.329121',90,90,NULL,'7b26e51b-3191-43e1-8cc5-86fda7621c93',25,'2806d215025845bc90e195f0b5c64c21','gigabytes',1,'2026-01-22 14:11:21','c5bac032-cc46-4150-aad5-9325071c0935'),('2026-01-21 14:11:25.587631',NULL,'2026-01-21 14:11:26.021253',91,91,'9f6fd3bf04e94f2d8e668d8e93cb0afa','6811813d-0f3f-482d-9f65-a177859dcc8c',18,'81d0568612894d6da94e01a77bfde64f','snapshots',1,'2026-01-22 14:11:25',NULL),('2026-01-21 14:11:25.730541',NULL,'2026-01-21 14:11:26.021253',92,92,'9f6fd3bf04e94f2d8e668d8e93cb0afa','e8b3766c-a92b-43ed-abab-7198e62f71db',17,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',1,'2026-01-22 14:11:25',NULL),('2026-01-21 14:11:25.765997',NULL,'2026-01-21 14:11:26.021253',93,93,NULL,'37dc851a-2e28-4e23-95b3-d0735b640c71',20,'81d0568612894d6da94e01a77bfde64f','snapshots',1,'2026-01-22 14:11:25','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:11:25.767797',NULL,'2026-01-21 14:11:26.021253',94,94,NULL,'3dc3e65d-9351-4247-9914-2d9e04b884e0',19,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',1,'2026-01-22 14:11:25','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:11:26.000936',NULL,'2026-01-21 14:11:26.102393',95,95,'91a5b3e563184701bd5a4f2a997f8221','6f3b136d-0941-4953-a0ec-2982ae9e10e8',28,'2806d215025845bc90e195f0b5c64c21','shares',1,'2026-01-22 14:11:25',NULL),('2026-01-21 14:11:26.009371',NULL,'2026-01-21 14:11:26.102393',96,96,'91a5b3e563184701bd5a4f2a997f8221','ad8e7809-175e-4d88-a4fe-00100e9b7f3d',27,'2806d215025845bc90e195f0b5c64c21','gigabytes',1,'2026-01-22 14:11:25',NULL),('2026-01-21 14:11:26.051658',NULL,'2026-01-21 14:11:26.102393',97,97,NULL,'d3b68167-b6e8-4b5e-b23f-76b3800b7ce0',29,'2806d215025845bc90e195f0b5c64c21','shares',1,'2026-01-22 14:11:25','29cdbce9-1270-470b-8e9e-290edf433bce'),('2026-01-21 14:11:26.056507',NULL,'2026-01-21 14:11:26.102393',98,98,NULL,'6d829d95-a0a8-4544-8459-db091563cc85',30,'2806d215025845bc90e195f0b5c64c21','gigabytes',1,'2026-01-22 14:11:25','29cdbce9-1270-470b-8e9e-290edf433bce'),('2026-01-21 14:11:30.812911',NULL,'2026-01-21 14:11:31.056764',99,99,'91a5b3e563184701bd5a4f2a997f8221','c61cc9f0-0b94-473c-acd6-9d9fdb41d753',32,'2806d215025845bc90e195f0b5c64c21','snapshots',1,'2026-01-22 14:11:30',NULL),('2026-01-21 14:11:30.814570',NULL,'2026-01-21 14:11:31.056764',100,100,'91a5b3e563184701bd5a4f2a997f8221','cda8fa71-3f72-486c-bd2b-f94f7ecb6009',31,'2806d215025845bc90e195f0b5c64c21','snapshot_gigabytes',1,'2026-01-22 14:11:30',NULL),('2026-01-21 14:11:30.892658',NULL,'2026-01-21 14:11:31.056764',101,101,NULL,'1da110d2-173f-4af4-9707-d5263a113d0e',34,'2806d215025845bc90e195f0b5c64c21','snapshots',1,'2026-01-22 14:11:30','29cdbce9-1270-470b-8e9e-290edf433bce'),('2026-01-21 14:11:30.896801',NULL,'2026-01-21 14:11:31.056764',102,102,NULL,'7e40cc10-28d8-4bdc-9fd1-06c73f030ae3',33,'2806d215025845bc90e195f0b5c64c21','snapshot_gigabytes',1,'2026-01-22 14:11:30','29cdbce9-1270-470b-8e9e-290edf433bce'),('2026-01-21 14:11:30.965035',NULL,'2026-01-21 14:11:33.292834',103,103,'9f6fd3bf04e94f2d8e668d8e93cb0afa','a0068660-8892-4846-8c0e-24366480877f',18,'81d0568612894d6da94e01a77bfde64f','snapshots',1,'2026-01-22 14:11:30',NULL),('2026-01-21 14:11:30.966468',NULL,'2026-01-21 14:11:33.292834',104,104,'9f6fd3bf04e94f2d8e668d8e93cb0afa','f21eafb3-2272-45ae-a4fe-73fa6d6a0d1e',17,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',1,'2026-01-22 14:11:30',NULL),('2026-01-21 14:11:31.065087',NULL,'2026-01-21 14:11:33.292834',105,105,NULL,'a9222db7-fb60-44c0-97bf-9af576a96096',20,'81d0568612894d6da94e01a77bfde64f','snapshots',1,'2026-01-22 14:11:30','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:11:31.066522',NULL,'2026-01-21 14:11:33.292834',106,106,NULL,'4081aff0-1bcc-49cb-95dc-faec8ed865bc',19,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',1,'2026-01-22 14:11:30','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:11:38.089511',NULL,'2026-01-21 14:11:38.290599',107,107,'9f6fd3bf04e94f2d8e668d8e93cb0afa','c6a9c1fe-9c6e-46eb-ab09-313329a11ce5',18,'81d0568612894d6da94e01a77bfde64f','snapshots',1,'2026-01-22 14:11:38',NULL),('2026-01-21 14:11:38.091185',NULL,'2026-01-21 14:11:38.290599',108,108,'9f6fd3bf04e94f2d8e668d8e93cb0afa','2fd7ce19-cba7-477d-b3db-ed16216b9e66',17,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',1,'2026-01-22 14:11:38',NULL),('2026-01-21 14:11:38.120822',NULL,'2026-01-21 14:11:38.290599',109,109,NULL,'1ad96c4c-b863-4f90-806c-318b0d40b173',20,'81d0568612894d6da94e01a77bfde64f','snapshots',1,'2026-01-22 14:11:38','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:11:38.122359',NULL,'2026-01-21 14:11:38.290599',110,110,NULL,'e0153f86-6c4e-4072-aefb-954a319024ed',19,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',1,'2026-01-22 14:11:38','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:11:39.328792',NULL,'2026-01-21 14:11:40.120789',111,111,'9f6fd3bf04e94f2d8e668d8e93cb0afa','87bac98e-9124-4052-880f-c5efb50f522e',18,'81d0568612894d6da94e01a77bfde64f','snapshots',1,'2026-01-22 14:11:39',NULL),('2026-01-21 14:11:39.330233',NULL,'2026-01-21 14:11:40.120789',112,112,'9f6fd3bf04e94f2d8e668d8e93cb0afa','318c7ca7-301c-4dc9-a71a-64cc319d3dcf',17,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',1,'2026-01-22 14:11:39',NULL),('2026-01-21 14:11:39.708834',NULL,'2026-01-21 14:11:40.120789',113,113,NULL,'d3e82965-58fa-4c36-ac34-e05344745a88',20,'81d0568612894d6da94e01a77bfde64f','snapshots',1,'2026-01-22 14:11:39','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:11:39.711881',NULL,'2026-01-21 14:11:40.120789',114,114,NULL,'f5d7ac80-18be-4b2a-a6d9-6f4e58b09a6b',19,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',1,'2026-01-22 14:11:39','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:11:45.850441',NULL,'2026-01-21 14:11:46.700158',115,115,'9f6fd3bf04e94f2d8e668d8e93cb0afa','33eae462-bbd4-4b95-a969-7386cce2a0b6',18,'81d0568612894d6da94e01a77bfde64f','snapshots',-1,'2026-01-22 14:11:45',NULL),('2026-01-21 14:11:45.851367',NULL,'2026-01-21 14:11:46.700158',116,116,'9f6fd3bf04e94f2d8e668d8e93cb0afa','97e3a202-b6dc-435f-b654-956388bd2de0',17,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',-1,'2026-01-22 14:11:45',NULL),('2026-01-21 14:11:46.232854',NULL,'2026-01-21 14:11:46.700158',117,117,NULL,'8ac6f85a-b0c2-4d64-8eda-c42195bbee8a',20,'81d0568612894d6da94e01a77bfde64f','snapshots',-1,'2026-01-22 14:11:45','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:11:46.233911',NULL,'2026-01-21 14:11:46.700158',118,118,NULL,'a3e1d8f8-da0d-433a-8446-86180940cc7b',19,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',-1,'2026-01-22 14:11:45','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:11:55.716378',NULL,'2026-01-21 14:11:55.971392',119,119,'9f6fd3bf04e94f2d8e668d8e93cb0afa','5c52013a-54ae-412b-97ee-d49deef002f7',18,'81d0568612894d6da94e01a77bfde64f','snapshots',-1,'2026-01-22 14:11:55',NULL),('2026-01-21 14:11:55.717157',NULL,'2026-01-21 14:11:55.971392',120,120,'9f6fd3bf04e94f2d8e668d8e93cb0afa','327e59db-5b76-4f84-b71a-9467df96a1a6',17,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',-1,'2026-01-22 14:11:55',NULL),('2026-01-21 14:11:55.803536',NULL,'2026-01-21 14:11:55.971392',121,121,NULL,'3097b1ac-49a4-4597-8869-17420b0572c3',20,'81d0568612894d6da94e01a77bfde64f','snapshots',-1,'2026-01-22 14:11:55','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:11:55.804924',NULL,'2026-01-21 14:11:55.971392',122,122,NULL,'a5ec1c9b-af11-42ad-87c0-e19f8e7488af',19,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',-1,'2026-01-22 14:11:55','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:11:59.218612',NULL,'2026-01-21 14:11:59.258724',123,123,'9f6fd3bf04e94f2d8e668d8e93cb0afa','ee87c913-89ef-4777-aa98-6b0579842c45',18,'81d0568612894d6da94e01a77bfde64f','snapshots',-1,'2026-01-22 14:11:59',NULL),('2026-01-21 14:11:59.219503',NULL,'2026-01-21 14:11:59.258724',124,124,'9f6fd3bf04e94f2d8e668d8e93cb0afa','e53ed0e1-680e-430f-ba63-6a48741c952e',17,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',-1,'2026-01-22 14:11:59',NULL),('2026-01-21 14:11:59.236218',NULL,'2026-01-21 14:11:59.258724',125,125,NULL,'0c0450da-d4ca-452f-9869-47c74a65c5e1',20,'81d0568612894d6da94e01a77bfde64f','snapshots',-1,'2026-01-22 14:11:59','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:11:59.237175',NULL,'2026-01-21 14:11:59.258724',126,126,NULL,'2af79ae7-3b3e-4f74-aa34-49b6d44651d6',19,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',-1,'2026-01-22 14:11:59','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:12:00.354829',NULL,'2026-01-21 14:12:00.698802',127,127,'91a5b3e563184701bd5a4f2a997f8221','0aa78f0f-5029-4c20-86d0-6b6987d73b3d',36,'2806d215025845bc90e195f0b5c64c21','snapshots',-1,'2026-01-22 14:12:00',NULL),('2026-01-21 14:12:00.355894',NULL,'2026-01-21 14:12:00.698802',128,128,'91a5b3e563184701bd5a4f2a997f8221','1d758bd7-bc18-4629-93e1-c4ffb6d3289a',35,'2806d215025845bc90e195f0b5c64c21','snapshot_gigabytes',-1,'2026-01-22 14:12:00',NULL),('2026-01-21 14:12:00.596956',NULL,'2026-01-21 14:12:00.698802',129,129,NULL,'400a9dc7-5e25-47bc-bab1-a72c5039899e',38,'2806d215025845bc90e195f0b5c64c21','snapshots',-1,'2026-01-22 14:12:00','29cdbce9-1270-470b-8e9e-290edf433bce'),('2026-01-21 14:12:00.597748',NULL,'2026-01-21 14:12:00.698802',130,130,NULL,'60f7186b-119e-42bf-ad3a-ca4b12b33e8f',37,'2806d215025845bc90e195f0b5c64c21','snapshot_gigabytes',-1,'2026-01-22 14:12:00','29cdbce9-1270-470b-8e9e-290edf433bce'),('2026-01-21 14:12:03.360999',NULL,'2026-01-21 14:12:03.476393',131,131,'9f6fd3bf04e94f2d8e668d8e93cb0afa','38d421a8-6f7c-4927-b418-56c62fe83323',18,'81d0568612894d6da94e01a77bfde64f','snapshots',-1,'2026-01-22 14:12:03',NULL),('2026-01-21 14:12:03.362054',NULL,'2026-01-21 14:12:03.476393',132,132,'9f6fd3bf04e94f2d8e668d8e93cb0afa','0cad49f0-1ecd-4116-a9d5-e74c6ce5e6cb',17,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',-1,'2026-01-22 14:12:03',NULL),('2026-01-21 14:12:03.423619',NULL,'2026-01-21 14:12:03.476393',133,133,NULL,'8e64aee6-da3f-4c41-8c0b-6cfc983c8829',20,'81d0568612894d6da94e01a77bfde64f','snapshots',-1,'2026-01-22 14:12:03','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:12:03.424742',NULL,'2026-01-21 14:12:03.476393',134,134,NULL,'cac75c48-ed24-49ff-bf34-2c27a701b76a',19,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',-1,'2026-01-22 14:12:03','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:12:04.563748',NULL,'2026-01-21 14:12:07.312218',135,135,'91a5b3e563184701bd5a4f2a997f8221','2fd59e04-aa65-4571-8da3-d9b9b7c082ce',39,'2806d215025845bc90e195f0b5c64c21','shares',-1,'2026-01-22 14:12:04',NULL),('2026-01-21 14:12:04.564465',NULL,'2026-01-21 14:12:07.312218',136,136,'91a5b3e563184701bd5a4f2a997f8221','0cf0fa0c-8273-4c43-8e79-bb3fa8585d17',40,'2806d215025845bc90e195f0b5c64c21','gigabytes',-1,'2026-01-22 14:12:04',NULL),('2026-01-21 14:12:07.270890',NULL,'2026-01-21 14:12:07.312218',137,137,NULL,'00fc9da8-ed2d-4284-8591-c066af329d3d',41,'2806d215025845bc90e195f0b5c64c21','shares',-1,'2026-01-22 14:12:04','29cdbce9-1270-470b-8e9e-290edf433bce'),('2026-01-21 14:12:07.273243',NULL,'2026-01-21 14:12:07.312218',138,138,NULL,'f256747c-c227-4bed-8065-7956a6066c80',42,'2806d215025845bc90e195f0b5c64c21','gigabytes',-1,'2026-01-22 14:12:04','29cdbce9-1270-470b-8e9e-290edf433bce'),('2026-01-21 14:12:08.575867',NULL,'2026-01-21 14:12:08.723933',139,139,'9f6fd3bf04e94f2d8e668d8e93cb0afa','ea1a5350-6e7d-495c-a014-f11aa3fe3f7c',18,'81d0568612894d6da94e01a77bfde64f','snapshots',-1,'2026-01-22 14:12:08',NULL),('2026-01-21 14:12:08.577038',NULL,'2026-01-21 14:12:08.723933',140,140,'9f6fd3bf04e94f2d8e668d8e93cb0afa','32999b74-35bf-4fb7-b6df-184f51bbcc31',17,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',-1,'2026-01-22 14:12:08',NULL),('2026-01-21 14:12:08.605972',NULL,'2026-01-21 14:12:08.723933',141,141,NULL,'35d913f7-056c-4ccb-8d8b-e2a81155c582',20,'81d0568612894d6da94e01a77bfde64f','snapshots',-1,'2026-01-22 14:12:08','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:12:08.607030',NULL,'2026-01-21 14:12:08.723933',142,142,NULL,'c0b621c1-bfb7-4031-a6a1-a702215d92a3',19,'81d0568612894d6da94e01a77bfde64f','snapshot_gigabytes',-1,'2026-01-22 14:12:08','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:12:08.692700',NULL,'2026-01-21 14:12:09.119622',143,143,'91a5b3e563184701bd5a4f2a997f8221','15faecac-ef55-4f58-96e2-926b97d8942f',39,'2806d215025845bc90e195f0b5c64c21','shares',-1,'2026-01-22 14:12:08',NULL),('2026-01-21 14:12:08.693654',NULL,'2026-01-21 14:12:09.119622',144,144,'91a5b3e563184701bd5a4f2a997f8221','67f262ed-a07b-42de-bfa8-f42509239aae',40,'2806d215025845bc90e195f0b5c64c21','gigabytes',-1,'2026-01-22 14:12:08',NULL),('2026-01-21 14:12:08.986644',NULL,'2026-01-21 14:12:09.119622',145,145,NULL,'48b0487c-4a2d-46f9-85fb-1a0d31c026eb',43,'2806d215025845bc90e195f0b5c64c21','shares',-1,'2026-01-22 14:12:08','c5bac032-cc46-4150-aad5-9325071c0935'),('2026-01-21 14:12:08.987334',NULL,'2026-01-21 14:12:09.119622',146,146,NULL,'e7750510-01e0-4030-882f-815086b9b08f',44,'2806d215025845bc90e195f0b5c64c21','gigabytes',-1,'2026-01-22 14:12:08','c5bac032-cc46-4150-aad5-9325071c0935'),('2026-01-21 14:12:12.277072',NULL,'2026-01-21 14:12:12.318077',147,147,'9f6fd3bf04e94f2d8e668d8e93cb0afa','541f9231-1ddf-4818-9a33-195166976bdf',1,'81d0568612894d6da94e01a77bfde64f','shares',-1,'2026-01-22 14:12:12',NULL),('2026-01-21 14:12:12.278385',NULL,'2026-01-21 14:12:12.318077',148,148,'9f6fd3bf04e94f2d8e668d8e93cb0afa','b3ec5404-9ea7-452f-8452-cb736b00c9f9',2,'81d0568612894d6da94e01a77bfde64f','gigabytes',-1,'2026-01-22 14:12:12',NULL),('2026-01-21 14:12:12.301148',NULL,'2026-01-21 14:12:12.318077',149,149,NULL,'32e242ee-9390-4f02-b36c-72474b09a219',3,'81d0568612894d6da94e01a77bfde64f','shares',-1,'2026-01-22 14:12:12','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:12:12.302466',NULL,'2026-01-21 14:12:12.318077',150,150,NULL,'5b576533-c1c7-4866-9343-c83821a0134d',4,'81d0568612894d6da94e01a77bfde64f','gigabytes',-1,'2026-01-22 14:12:12','9bfc08e1-2434-47e7-8b27-5587894f67ed'),('2026-01-21 14:12:16.221944',NULL,'2026-01-21 14:12:16.848211',151,151,'aba5fb7f48d64e01a3694378a50f9c54','bb4c83ab-1647-4da3-ba56-5bf70b1449d3',46,'91fa423674524226acfe253061607c0b','shares',1,'2026-01-22 14:12:16',NULL),('2026-01-21 14:12:16.223803',NULL,'2026-01-21 14:12:16.848211',152,152,'aba5fb7f48d64e01a3694378a50f9c54','9182af2d-3225-41c4-bcfa-34dfa2c4ad91',45,'91fa423674524226acfe253061607c0b','gigabytes',1,'2026-01-22 14:12:16',NULL),('2026-01-21 14:12:16.310681',NULL,'2026-01-21 14:12:16.848211',153,153,NULL,'4393da32-e28f-483c-a243-332eafc81396',48,'91fa423674524226acfe253061607c0b','shares',1,'2026-01-22 14:12:16','5a374d5e-d0ed-4003-9ec7-10084960d609'),('2026-01-21 14:12:16.311866',NULL,'2026-01-21 14:12:16.848211',154,154,NULL,'6d14ed04-aa6c-4b4e-a813-5d16f249a9c2',47,'91fa423674524226acfe253061607c0b','gigabytes',1,'2026-01-22 14:12:16','5a374d5e-d0ed-4003-9ec7-10084960d609'),('2026-01-21 14:12:21.082382',NULL,'2026-01-21 14:12:22.482563',155,155,'aba5fb7f48d64e01a3694378a50f9c54','0f410b15-de03-43d2-80d3-e440467658b4',46,'91fa423674524226acfe253061607c0b','shares',-1,'2026-01-22 14:12:21',NULL),('2026-01-21 14:12:21.083279',NULL,'2026-01-21 14:12:22.482563',156,156,'aba5fb7f48d64e01a3694378a50f9c54','9b231e7c-b088-493d-812f-9c666e821ad1',45,'91fa423674524226acfe253061607c0b','gigabytes',-1,'2026-01-22 14:12:21',NULL),('2026-01-21 14:12:22.281606',NULL,'2026-01-21 14:12:22.482563',157,157,NULL,'135c35ac-9aa8-47c1-a174-b73b538cbf19',48,'91fa423674524226acfe253061607c0b','shares',-1,'2026-01-22 14:12:21','5a374d5e-d0ed-4003-9ec7-10084960d609'),('2026-01-21 14:12:22.282407',NULL,'2026-01-21 14:12:22.482563',158,158,NULL,'9c44a32c-0f4f-4a77-aaf2-59849e462784',47,'91fa423674524226acfe253061607c0b','gigabytes',-1,'2026-01-22 14:12:21','5a374d5e-d0ed-4003-9ec7-10084960d609'),('2026-01-21 14:12:23.913543',NULL,'2026-01-21 14:12:31.010818',159,159,'561f676f9fd94b9f83b47172d27f8e4d','615554ac-b595-480b-bb94-1b179f7605de',50,'8ea8a62d6efd4fdcac316c24e39fb155','shares',1,'2026-01-22 14:12:23',NULL),('2026-01-21 14:12:23.914794',NULL,'2026-01-21 14:12:31.010818',160,160,'561f676f9fd94b9f83b47172d27f8e4d','f5647ae4-36a0-45e8-a009-fa2d3f31d98e',49,'8ea8a62d6efd4fdcac316c24e39fb155','gigabytes',1,'2026-01-22 14:12:23',NULL),('2026-01-21 14:12:30.780085',NULL,'2026-01-21 14:12:31.010818',161,161,NULL,'f12c43a3-ce01-4dfb-b7c9-2e43d8b6d306',52,'8ea8a62d6efd4fdcac316c24e39fb155','shares',1,'2026-01-22 14:12:23','291913af-f721-4784-852d-18a81c2dbf2d'),('2026-01-21 14:12:30.782466',NULL,'2026-01-21 14:12:31.010818',162,162,NULL,'a01cb0f0-9505-4d3e-916a-d5fb112e1539',51,'8ea8a62d6efd4fdcac316c24e39fb155','gigabytes',1,'2026-01-22 14:12:23','291913af-f721-4784-852d-18a81c2dbf2d'),('2026-01-21 14:12:36.564959',NULL,'2026-01-21 14:12:36.598160',163,163,'561f676f9fd94b9f83b47172d27f8e4d','77415745-d7f6-48e2-921e-e5e8f61b4a9e',50,'8ea8a62d6efd4fdcac316c24e39fb155','shares',-1,'2026-01-22 14:12:36',NULL),('2026-01-21 14:12:36.566080',NULL,'2026-01-21 14:12:36.598160',164,164,'561f676f9fd94b9f83b47172d27f8e4d','bc284092-260c-488e-8d9e-b21f30d7f243',49,'8ea8a62d6efd4fdcac316c24e39fb155','gigabytes',-1,'2026-01-22 14:12:36',NULL),('2026-01-21 14:12:36.580390',NULL,'2026-01-21 14:12:36.598160',165,165,NULL,'f4861156-3e76-4dce-82a2-f314e7524b33',52,'8ea8a62d6efd4fdcac316c24e39fb155','shares',-1,'2026-01-22 14:12:36','291913af-f721-4784-852d-18a81c2dbf2d'),('2026-01-21 14:12:36.581339',NULL,'2026-01-21 14:12:36.598160',166,166,NULL,'32e52d4e-bb72-4983-b3a9-0a306629a1ee',51,'8ea8a62d6efd4fdcac316c24e39fb155','gigabytes',-1,'2026-01-22 14:12:36','291913af-f721-4784-852d-18a81c2dbf2d'),('2026-01-21 14:12:40.117290',NULL,'2026-01-21 14:12:40.363322',167,167,'296b3ba1092e47d48708162556c13492','784e1f2e-cfa4-4b28-a280-c60543d6b62b',54,'8f23a9ff8e6249a7b232ba280b7bee1d','shares',1,'2026-01-22 14:12:40',NULL),('2026-01-21 14:12:40.119544',NULL,'2026-01-21 14:12:40.363322',168,168,'296b3ba1092e47d48708162556c13492','0d0a30bb-9ebd-40c7-b798-0b36767e989a',53,'8f23a9ff8e6249a7b232ba280b7bee1d','gigabytes',1,'2026-01-22 14:12:40',NULL),('2026-01-21 14:12:40.166569',NULL,'2026-01-21 14:12:40.363322',169,169,NULL,'ad666318-c412-4ad1-aee7-40184c5a5474',56,'8f23a9ff8e6249a7b232ba280b7bee1d','shares',1,'2026-01-22 14:12:40','59554df7-024a-45b7-9735-27031cc895f1'),('2026-01-21 14:12:40.167799',NULL,'2026-01-21 14:12:40.363322',170,170,NULL,'bbbc51f5-a004-451d-95ab-49ef7ea4de13',55,'8f23a9ff8e6249a7b232ba280b7bee1d','gigabytes',1,'2026-01-22 14:12:40','59554df7-024a-45b7-9735-27031cc895f1'),('2026-01-21 14:12:49.086029',NULL,'2026-01-21 14:12:49.197784',171,171,'296b3ba1092e47d48708162556c13492','dc793f5d-b8c9-430c-a2ff-e7b5ce057ebb',58,'8f23a9ff8e6249a7b232ba280b7bee1d','snapshots',1,'2026-01-22 14:12:49',NULL),('2026-01-21 14:12:49.088849',NULL,'2026-01-21 14:12:49.197784',172,172,'296b3ba1092e47d48708162556c13492','447b21d9-5535-4d94-b1dc-99114350f1de',57,'8f23a9ff8e6249a7b232ba280b7bee1d','snapshot_gigabytes',1,'2026-01-22 14:12:49',NULL),('2026-01-21 14:12:49.108574',NULL,'2026-01-21 14:12:49.197784',173,173,NULL,'c8d5347d-0cd1-45dd-abc5-650b792f5441',60,'8f23a9ff8e6249a7b232ba280b7bee1d','snapshots',1,'2026-01-22 14:12:49','59554df7-024a-45b7-9735-27031cc895f1'),('2026-01-21 14:12:49.109908',NULL,'2026-01-21 14:12:49.197784',174,174,NULL,'dd0c4dae-e92b-4f54-b66c-5a3d0169e32a',59,'8f23a9ff8e6249a7b232ba280b7bee1d','snapshot_gigabytes',1,'2026-01-22 14:12:49','59554df7-024a-45b7-9735-27031cc895f1'),('2026-01-21 14:12:49.806219',NULL,'2026-01-21 14:12:49.847634',175,175,'a0672e98f4144413a0f7f662605555ca','741b1f39-7e3b-426e-bb3a-202774f79861',62,'5da033845de7469096a0943fc3046311','shares',1,'2026-01-22 14:12:49',NULL),('2026-01-21 14:12:49.807622',NULL,'2026-01-21 14:12:49.847634',176,176,'a0672e98f4144413a0f7f662605555ca','62ce3cd3-938c-4179-b35f-83ea09234743',61,'5da033845de7469096a0943fc3046311','gigabytes',1,'2026-01-22 14:12:49',NULL),('2026-01-21 14:12:49.821690',NULL,'2026-01-21 14:12:49.847634',177,177,NULL,'993e6cee-28eb-4ac5-9bb8-0eda69bc6139',64,'5da033845de7469096a0943fc3046311','shares',1,'2026-01-22 14:12:49','9381faef-bf67-41dd-aaaa-a9be7a2bcc68'),('2026-01-21 14:12:49.822819',NULL,'2026-01-21 14:12:49.847634',178,178,NULL,'709cfd42-8d33-4d3d-ba64-c2df750257c0',63,'5da033845de7469096a0943fc3046311','gigabytes',1,'2026-01-22 14:12:49','9381faef-bf67-41dd-aaaa-a9be7a2bcc68'),('2026-01-21 14:12:55.198274',NULL,'2026-01-21 14:12:55.223478',179,179,'296b3ba1092e47d48708162556c13492','de460486-0068-4fd0-871d-3abe8c53b5ed',58,'8f23a9ff8e6249a7b232ba280b7bee1d','snapshots',-1,'2026-01-22 14:12:55',NULL),('2026-01-21 14:12:55.202554',NULL,'2026-01-21 14:12:55.223478',180,180,'296b3ba1092e47d48708162556c13492','60bce29f-ff7e-4796-a1e2-e750162168e7',57,'8f23a9ff8e6249a7b232ba280b7bee1d','snapshot_gigabytes',-1,'2026-01-22 14:12:55',NULL),('2026-01-21 14:12:55.211924',NULL,'2026-01-21 14:12:55.223478',181,181,NULL,'165d8ada-ebce-41f7-9a68-e8e029d49e4e',60,'8f23a9ff8e6249a7b232ba280b7bee1d','snapshots',-1,'2026-01-22 14:12:55','59554df7-024a-45b7-9735-27031cc895f1'),('2026-01-21 14:12:55.213004',NULL,'2026-01-21 14:12:55.223478',182,182,NULL,'00ad9c6b-a6e2-45b3-9b2b-c71bef0d425f',59,'8f23a9ff8e6249a7b232ba280b7bee1d','snapshot_gigabytes',-1,'2026-01-22 14:12:55','59554df7-024a-45b7-9735-27031cc895f1'),('2026-01-21 14:12:59.871809',NULL,'2026-01-21 14:12:59.950081',183,183,'296b3ba1092e47d48708162556c13492','6a084bff-dd12-4c84-9554-364b9ececf99',54,'8f23a9ff8e6249a7b232ba280b7bee1d','shares',-1,'2026-01-22 14:12:59',NULL),('2026-01-21 14:12:59.872615',NULL,'2026-01-21 14:12:59.950081',184,184,'296b3ba1092e47d48708162556c13492','590d0a2d-d8d2-4c88-97f9-537a02f2197c',53,'8f23a9ff8e6249a7b232ba280b7bee1d','gigabytes',-1,'2026-01-22 14:12:59',NULL),('2026-01-21 14:12:59.911263',NULL,'2026-01-21 14:12:59.950081',185,185,NULL,'72846271-1640-4e70-bd0d-b6198323dfc2',56,'8f23a9ff8e6249a7b232ba280b7bee1d','shares',-1,'2026-01-22 14:12:59','59554df7-024a-45b7-9735-27031cc895f1'),('2026-01-21 14:12:59.912251',NULL,'2026-01-21 14:12:59.950081',186,186,NULL,'5f3699fe-7b8d-4129-9b37-9cbde566fcf3',55,'8f23a9ff8e6249a7b232ba280b7bee1d','gigabytes',-1,'2026-01-22 14:12:59','59554df7-024a-45b7-9735-27031cc895f1'),('2026-01-21 14:13:15.285842',NULL,'2026-01-21 14:13:15.314836',187,187,'a0672e98f4144413a0f7f662605555ca','1dee6b98-59d5-48f1-a08a-685dc5cd5a05',62,'5da033845de7469096a0943fc3046311','shares',-1,'2026-01-22 14:13:15',NULL),('2026-01-21 14:13:15.288298',NULL,'2026-01-21 14:13:15.314836',188,188,'a0672e98f4144413a0f7f662605555ca','5ea1c6c8-d80b-4ce8-a731-7a36d0ca5200',61,'5da033845de7469096a0943fc3046311','gigabytes',-1,'2026-01-22 14:13:15',NULL),('2026-01-21 14:13:15.299085',NULL,'2026-01-21 14:13:15.314836',189,189,NULL,'2698ab1d-37ea-4854-93cc-78d292d0ba3a',64,'5da033845de7469096a0943fc3046311','shares',-1,'2026-01-22 14:13:15','9381faef-bf67-41dd-aaaa-a9be7a2bcc68'),('2026-01-21 14:13:15.303211',NULL,'2026-01-21 14:13:15.314836',190,190,NULL,'bdd5b49d-c24d-4f71-aa6f-2b525a9f7f60',63,'5da033845de7469096a0943fc3046311','gigabytes',-1,'2026-01-22 14:13:15','9381faef-bf67-41dd-aaaa-a9be7a2bcc68'),('2026-01-21 14:13:20.854988',NULL,'2026-01-21 14:13:20.899559',191,191,'111328e7e8c9499f9dd897f7f644b965','56ca1ba3-d457-413c-a1e8-5fa6f25e1cc2',66,'79952fad07e54cf18c5f2c207bdbf9fb','shares',1,'2026-01-22 14:13:20',NULL),('2026-01-21 14:13:20.856602',NULL,'2026-01-21 14:13:20.899559',192,192,'111328e7e8c9499f9dd897f7f644b965','369e21c5-8583-420b-93a2-2d266f046a1e',65,'79952fad07e54cf18c5f2c207bdbf9fb','gigabytes',1,'2026-01-22 14:13:20',NULL),('2026-01-21 14:13:20.869970',NULL,'2026-01-21 14:13:20.899559',193,193,NULL,'57604446-6b88-4163-9b30-452d52761f6d',68,'79952fad07e54cf18c5f2c207bdbf9fb','shares',1,'2026-01-22 14:13:20','d763adfd-4693-4b03-ad1c-6cfad5db99b3'),('2026-01-21 14:13:20.871619',NULL,'2026-01-21 14:13:20.899559',194,194,NULL,'781bacf2-83a5-4cf9-8b4c-7e93fc89310b',67,'79952fad07e54cf18c5f2c207bdbf9fb','gigabytes',1,'2026-01-22 14:13:20','d763adfd-4693-4b03-ad1c-6cfad5db99b3'),('2026-01-21 14:13:24.527864',NULL,'2026-01-21 14:13:24.619400',195,195,'111328e7e8c9499f9dd897f7f644b965','eff1247f-826e-4dce-8e12-75f89d65108b',70,'79952fad07e54cf18c5f2c207bdbf9fb','snapshots',1,'2026-01-22 14:13:24',NULL),('2026-01-21 14:13:24.529177',NULL,'2026-01-21 14:13:24.619400',196,196,'111328e7e8c9499f9dd897f7f644b965','9e431d37-ae8c-44eb-8226-1f5c18f76591',69,'79952fad07e54cf18c5f2c207bdbf9fb','snapshot_gigabytes',1,'2026-01-22 14:13:24',NULL),('2026-01-21 14:13:24.541039',NULL,'2026-01-21 14:13:24.619400',197,197,NULL,'a9217eba-d7fd-43d8-8442-88c7a34b69e4',72,'79952fad07e54cf18c5f2c207bdbf9fb','snapshots',1,'2026-01-22 14:13:24','d763adfd-4693-4b03-ad1c-6cfad5db99b3'),('2026-01-21 14:13:24.542376',NULL,'2026-01-21 14:13:24.619400',198,198,NULL,'8d181840-bf8c-4eac-82b1-b4cb30829667',71,'79952fad07e54cf18c5f2c207bdbf9fb','snapshot_gigabytes',1,'2026-01-22 14:13:24','d763adfd-4693-4b03-ad1c-6cfad5db99b3'),('2026-01-21 14:13:25.295897',NULL,'2026-01-21 14:13:26.590214',199,199,'111328e7e8c9499f9dd897f7f644b965','3a4478df-c1dd-4169-bac1-f92a005c246a',66,'79952fad07e54cf18c5f2c207bdbf9fb','shares',1,'2026-01-22 14:13:25',NULL),('2026-01-21 14:13:25.297595',NULL,'2026-01-21 14:13:26.590214',200,200,'111328e7e8c9499f9dd897f7f644b965','acde3d73-c444-492e-80bb-d7b6c79c03b6',65,'79952fad07e54cf18c5f2c207bdbf9fb','gigabytes',1,'2026-01-22 14:13:25',NULL),('2026-01-21 14:13:26.512019',NULL,'2026-01-21 14:13:26.590214',201,201,NULL,'61b37f83-df69-4e5a-ace5-d09c41755a4a',68,'79952fad07e54cf18c5f2c207bdbf9fb','shares',1,'2026-01-22 14:13:25','d763adfd-4693-4b03-ad1c-6cfad5db99b3'),('2026-01-21 14:13:26.539295',NULL,'2026-01-21 14:13:26.590214',202,202,NULL,'98aef3f3-8314-4225-9bea-1bda06037ecf',67,'79952fad07e54cf18c5f2c207bdbf9fb','gigabytes',1,'2026-01-22 14:13:25','d763adfd-4693-4b03-ad1c-6cfad5db99b3'),('2026-01-21 14:13:28.228847',NULL,'2026-01-21 14:13:28.458656',203,203,'371332db2a2c453ea215c3980707fbd6','d03824a7-1f56-4ab8-8cfe-174efb3fed9b',73,'938ff6c62b4d4bfe9c13b015ab84e14b','share_networks',1,'2026-01-22 14:13:28',NULL),('2026-01-21 14:13:29.207836',NULL,'2026-01-21 14:13:29.252453',204,204,'b020af4acf6c46669264d3692bde318e','6182aae0-ce2d-4971-9300-2714208c31bb',74,'13c5ce7776694d3ba842a33559f0ce31','share_networks',1,'2026-01-22 14:13:29',NULL),('2026-01-21 14:13:31.731582',NULL,'2026-01-21 14:13:31.743011',205,205,'371332db2a2c453ea215c3980707fbd6','d6020fc5-026d-42a6-8983-97257ae5c7e6',73,'938ff6c62b4d4bfe9c13b015ab84e14b','share_networks',-1,'2026-01-22 14:13:31',NULL),('2026-01-21 14:13:34.835847',NULL,'2026-01-21 14:13:35.178307',206,206,'6fc9e38a391d41b1bce34dc4cb926a6d','e892200d-bfa8-4951-842a-8a3c1c9ed8ac',76,'1812e512403748bd8d20cf83682d6ecb','shares',1,'2026-01-22 14:13:34',NULL),('2026-01-21 14:13:34.837319',NULL,'2026-01-21 14:13:35.178307',207,207,'6fc9e38a391d41b1bce34dc4cb926a6d','bc7802d4-6bbc-4941-81f1-c8f5c9794f49',75,'1812e512403748bd8d20cf83682d6ecb','gigabytes',1,'2026-01-22 14:13:34',NULL),('2026-01-21 14:13:35.151650',NULL,'2026-01-21 14:13:35.178307',208,208,NULL,'c9608db5-72f0-4213-97a7-8e70a9734445',78,'1812e512403748bd8d20cf83682d6ecb','shares',1,'2026-01-22 14:13:34','0b0ef60b-789a-4f97-ab23-aa852b1b2e11'),('2026-01-21 14:13:35.153085',NULL,'2026-01-21 14:13:35.178307',209,209,NULL,'9cf7b32f-7b50-46e8-b048-28c60502dd09',77,'1812e512403748bd8d20cf83682d6ecb','gigabytes',1,'2026-01-22 14:13:34','0b0ef60b-789a-4f97-ab23-aa852b1b2e11'),('2026-01-21 14:13:38.703407',NULL,'2026-01-21 14:13:38.754192',210,210,'54bd2d99c737409a8cdb47d0ef61c0af','778c39fd-277d-4656-8438-abc69705871c',80,'bf58a5c191654263a44f73287e2a242e','shares',1,'2026-01-22 14:13:38',NULL),('2026-01-21 14:13:38.705329',NULL,'2026-01-21 14:13:38.754192',211,211,'54bd2d99c737409a8cdb47d0ef61c0af','ccbad2f5-511d-4824-b223-4131eb1984ce',79,'bf58a5c191654263a44f73287e2a242e','gigabytes',1,'2026-01-22 14:13:38',NULL),('2026-01-21 14:13:38.723337',NULL,'2026-01-21 14:13:38.754192',212,212,NULL,'cc0a6d1f-38e1-4aa9-84cb-c77d58d91e56',82,'bf58a5c191654263a44f73287e2a242e','shares',1,'2026-01-22 14:13:38','7cec5100-da97-4c19-a6d2-711aa40fb4a4'),('2026-01-21 14:13:38.724597',NULL,'2026-01-21 14:13:38.754192',213,213,NULL,'7044cf99-7173-4f34-9b3d-e796dd944a77',81,'bf58a5c191654263a44f73287e2a242e','gigabytes',1,'2026-01-22 14:13:38','7cec5100-da97-4c19-a6d2-711aa40fb4a4'),('2026-01-21 14:13:38.959616',NULL,'2026-01-21 14:13:39.140846',214,214,'6fc9e38a391d41b1bce34dc4cb926a6d','b8d8519e-8c98-45f5-a71a-c780f4527486',76,'1812e512403748bd8d20cf83682d6ecb','shares',-1,'2026-01-22 14:13:38',NULL),('2026-01-21 14:13:38.960575',NULL,'2026-01-21 14:13:39.140846',215,215,'6fc9e38a391d41b1bce34dc4cb926a6d','ba443660-0b99-4301-8474-6b2d8af01a5f',75,'1812e512403748bd8d20cf83682d6ecb','gigabytes',-1,'2026-01-22 14:13:38',NULL),('2026-01-21 14:13:39.006088',NULL,'2026-01-21 14:13:39.140846',216,216,NULL,'d69b4adb-e187-4689-89d7-b292874b145e',78,'1812e512403748bd8d20cf83682d6ecb','shares',-1,'2026-01-22 14:13:38','0b0ef60b-789a-4f97-ab23-aa852b1b2e11'),('2026-01-21 14:13:39.007893',NULL,'2026-01-21 14:13:39.140846',217,217,NULL,'82bf7a0c-b36e-485d-ba71-ad62396e6fe0',77,'1812e512403748bd8d20cf83682d6ecb','gigabytes',-1,'2026-01-22 14:13:38','0b0ef60b-789a-4f97-ab23-aa852b1b2e11'),('2026-01-21 14:13:39.606722',NULL,'2026-01-21 14:13:41.237970',218,218,'6fc9e38a391d41b1bce34dc4cb926a6d','c73e21bf-8f35-4e3e-9493-7fc99ad1b65f',76,'1812e512403748bd8d20cf83682d6ecb','shares',1,'2026-01-22 14:13:39',NULL),('2026-01-21 14:13:39.608822',NULL,'2026-01-21 14:13:41.237970',219,219,'6fc9e38a391d41b1bce34dc4cb926a6d','733746f3-31e4-473f-8dc1-512aa909e177',75,'1812e512403748bd8d20cf83682d6ecb','gigabytes',1,'2026-01-22 14:13:39',NULL),('2026-01-21 14:13:39.657438',NULL,'2026-01-21 14:13:41.237970',220,220,NULL,'425675c7-f331-4058-a712-f9195bec6541',84,'1812e512403748bd8d20cf83682d6ecb','shares',1,'2026-01-22 14:13:39','9ca783c9-ecfe-469c-a4a8-d087ab0379ae'),('2026-01-21 14:13:39.658765',NULL,'2026-01-21 14:13:41.237970',221,221,NULL,'41a86725-aa71-47c4-8e9e-de7755226d8f',83,'1812e512403748bd8d20cf83682d6ecb','gigabytes',1,'2026-01-22 14:13:39','9ca783c9-ecfe-469c-a4a8-d087ab0379ae'),('2026-01-21 14:13:41.542357',NULL,'2026-01-21 14:13:41.585515',222,222,'18d829f19dd445aa98c02d30c005b747','36b4e5fd-a451-479c-a639-ff46ce2efa3d',86,'498aac0871e5417786fbc3341cc80fbf','shares',1,'2026-01-22 14:13:41',NULL),('2026-01-21 14:13:41.543803',NULL,'2026-01-21 14:13:41.585515',223,223,'18d829f19dd445aa98c02d30c005b747','fed46b16-a96d-4a3a-b450-862aa61adc06',85,'498aac0871e5417786fbc3341cc80fbf','gigabytes',1,'2026-01-22 14:13:41',NULL),('2026-01-21 14:13:41.556639',NULL,'2026-01-21 14:13:41.585515',224,224,NULL,'cac0f3bb-9c65-4f0f-9040-9c254389535d',88,'498aac0871e5417786fbc3341cc80fbf','shares',1,'2026-01-22 14:13:41','21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:13:41.558356',NULL,'2026-01-21 14:13:41.585515',225,225,NULL,'b28b3e56-6c94-4ec1-9c4a-2c20d14af204',87,'498aac0871e5417786fbc3341cc80fbf','gigabytes',1,'2026-01-22 14:13:41','21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:13:42.115611',NULL,'2026-01-21 14:13:42.226344',226,226,'54bd2d99c737409a8cdb47d0ef61c0af','9cf9582a-0df5-4d97-bceb-5bd2c1479d05',90,'bf58a5c191654263a44f73287e2a242e','snapshots',1,'2026-01-22 14:13:42',NULL),('2026-01-21 14:13:42.117252',NULL,'2026-01-21 14:13:42.226344',227,227,'54bd2d99c737409a8cdb47d0ef61c0af','de0d32de-6e0c-4ef3-b569-f2f38fc67e22',89,'bf58a5c191654263a44f73287e2a242e','snapshot_gigabytes',1,'2026-01-22 14:13:42',NULL),('2026-01-21 14:13:42.131549',NULL,'2026-01-21 14:13:42.226344',228,228,NULL,'07fe6b67-3b2f-484b-8b5f-a16c2d316d25',92,'bf58a5c191654263a44f73287e2a242e','snapshots',1,'2026-01-22 14:13:42','7cec5100-da97-4c19-a6d2-711aa40fb4a4'),('2026-01-21 14:13:42.133083',NULL,'2026-01-21 14:13:42.226344',229,229,NULL,'c9a9a92c-ede9-4cd0-9c81-688379725146',91,'bf58a5c191654263a44f73287e2a242e','snapshot_gigabytes',1,'2026-01-22 14:13:42','7cec5100-da97-4c19-a6d2-711aa40fb4a4'),('2026-01-21 14:13:44.931896',NULL,'2026-01-21 14:13:45.213065',230,230,'18d829f19dd445aa98c02d30c005b747','c3ea00ce-e98b-4203-8085-28e268f480bd',86,'498aac0871e5417786fbc3341cc80fbf','shares',1,'2026-01-22 14:13:44',NULL),('2026-01-21 14:13:44.933077',NULL,'2026-01-21 14:13:45.213065',231,231,'18d829f19dd445aa98c02d30c005b747','8232f58c-159d-43e5-92ae-00557cd2be56',85,'498aac0871e5417786fbc3341cc80fbf','gigabytes',1,'2026-01-22 14:13:44',NULL),('2026-01-21 14:13:44.940368',NULL,'2026-01-21 14:13:45.163403',232,232,'6fc9e38a391d41b1bce34dc4cb926a6d','1a4546ae-f634-432e-9ba8-d494898e3111',76,'1812e512403748bd8d20cf83682d6ecb','shares',-1,'2026-01-22 14:13:44',NULL),('2026-01-21 14:13:44.941640',NULL,'2026-01-21 14:13:45.163403',233,233,'6fc9e38a391d41b1bce34dc4cb926a6d','65b31916-eef0-447e-84df-69dcfc56623c',75,'1812e512403748bd8d20cf83682d6ecb','gigabytes',-1,'2026-01-22 14:13:44',NULL),('2026-01-21 14:13:44.999293',NULL,'2026-01-21 14:13:45.213065',234,234,NULL,'4b9f5976-154c-4826-8d91-5d1e6c795499',88,'498aac0871e5417786fbc3341cc80fbf','shares',1,'2026-01-22 14:13:44','21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:13:45.000895',NULL,'2026-01-21 14:13:45.213065',235,235,NULL,'65d8498f-2870-4848-999c-c6a5c8c884aa',87,'498aac0871e5417786fbc3341cc80fbf','gigabytes',1,'2026-01-22 14:13:44','21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:13:45.047535',NULL,'2026-01-21 14:13:45.163403',236,236,NULL,'93b12fea-b100-434a-83b7-7c217e515d21',84,'1812e512403748bd8d20cf83682d6ecb','shares',-1,'2026-01-22 14:13:44','9ca783c9-ecfe-469c-a4a8-d087ab0379ae'),('2026-01-21 14:13:45.048637',NULL,'2026-01-21 14:13:45.163403',237,237,NULL,'bdb2c44f-f1a9-46f3-aa7e-8e1e98b464c7',83,'1812e512403748bd8d20cf83682d6ecb','gigabytes',-1,'2026-01-22 14:13:44','9ca783c9-ecfe-469c-a4a8-d087ab0379ae'),('2026-01-21 14:13:45.706946',NULL,'2026-01-21 14:13:45.768783',238,238,'6fc9e38a391d41b1bce34dc4cb926a6d','7c771a30-23f7-4592-9e51-326a0384ae48',76,'1812e512403748bd8d20cf83682d6ecb','shares',1,'2026-01-22 14:13:45',NULL),('2026-01-21 14:13:45.711279',NULL,'2026-01-21 14:13:45.768783',239,239,'6fc9e38a391d41b1bce34dc4cb926a6d','346605b9-0a56-41e3-955e-35858eeafc52',75,'1812e512403748bd8d20cf83682d6ecb','gigabytes',1,'2026-01-22 14:13:45',NULL),('2026-01-21 14:13:45.730620',NULL,'2026-01-21 14:13:45.768783',240,240,NULL,'0511e755-064b-4f12-8610-14b8a9c95438',94,'1812e512403748bd8d20cf83682d6ecb','shares',1,'2026-01-22 14:13:45','cdda8570-26be-4330-bd36-622a2eb10327'),('2026-01-21 14:13:45.731887',NULL,'2026-01-21 14:13:45.768783',241,241,NULL,'7cb5e0c7-8bdc-4205-b3fb-4a5fb634b279',93,'1812e512403748bd8d20cf83682d6ecb','gigabytes',1,'2026-01-22 14:13:45','cdda8570-26be-4330-bd36-622a2eb10327'),('2026-01-21 14:13:46.076212',NULL,'2026-01-21 14:13:46.607594',242,242,'54bd2d99c737409a8cdb47d0ef61c0af','4987d569-70fb-4cfa-9531-571cf82d45de',90,'bf58a5c191654263a44f73287e2a242e','snapshots',1,'2026-01-22 14:13:46',NULL),('2026-01-21 14:13:46.077533',NULL,'2026-01-21 14:13:46.607594',243,243,'54bd2d99c737409a8cdb47d0ef61c0af','7c937415-a304-40c1-83b2-0f3fe7cad29f',89,'bf58a5c191654263a44f73287e2a242e','snapshot_gigabytes',1,'2026-01-22 14:13:46',NULL),('2026-01-21 14:13:46.112731',NULL,'2026-01-21 14:13:46.607594',244,244,NULL,'10cb4233-62d0-4f58-89b0-19b282148a53',92,'bf58a5c191654263a44f73287e2a242e','snapshots',1,'2026-01-22 14:13:46','7cec5100-da97-4c19-a6d2-711aa40fb4a4'),('2026-01-21 14:13:46.114188',NULL,'2026-01-21 14:13:46.607594',245,245,NULL,'deb6aef2-3c54-479a-81c4-7e5c95c2ec66',91,'bf58a5c191654263a44f73287e2a242e','snapshot_gigabytes',1,'2026-01-22 14:13:46','7cec5100-da97-4c19-a6d2-711aa40fb4a4'),('2026-01-21 14:13:50.042359',NULL,'2026-01-21 14:13:50.085051',246,246,'6fc9e38a391d41b1bce34dc4cb926a6d','bbd9e730-4114-49b4-a206-0643cdc42e71',76,'1812e512403748bd8d20cf83682d6ecb','shares',-1,'2026-01-22 14:13:50',NULL),('2026-01-21 14:13:50.043208',NULL,'2026-01-21 14:13:50.085051',247,247,'6fc9e38a391d41b1bce34dc4cb926a6d','63fe9908-25c0-4826-ac17-d3d2f508242b',75,'1812e512403748bd8d20cf83682d6ecb','gigabytes',-1,'2026-01-22 14:13:50',NULL),('2026-01-21 14:13:50.076335',NULL,'2026-01-21 14:13:50.085051',248,248,NULL,'d29a9196-90c2-4164-92e0-bcd36d42bfa8',94,'1812e512403748bd8d20cf83682d6ecb','shares',-1,'2026-01-22 14:13:50','cdda8570-26be-4330-bd36-622a2eb10327'),('2026-01-21 14:13:50.077170',NULL,'2026-01-21 14:13:50.085051',249,249,NULL,'71adc9f8-6dd0-4ef6-bd4f-27b4b9c58427',93,'1812e512403748bd8d20cf83682d6ecb','gigabytes',-1,'2026-01-22 14:13:50','cdda8570-26be-4330-bd36-622a2eb10327'),('2026-01-21 14:13:50.956390',NULL,'2026-01-21 14:13:51.023258',250,250,'6fc9e38a391d41b1bce34dc4cb926a6d','95526d4a-bae6-4055-aa6f-1dfbb8952d54',76,'1812e512403748bd8d20cf83682d6ecb','shares',1,'2026-01-22 14:13:50',NULL),('2026-01-21 14:13:50.962765',NULL,'2026-01-21 14:13:51.023258',251,251,'6fc9e38a391d41b1bce34dc4cb926a6d','d7d9b055-da8e-46a9-ba5e-babf6d4bf55a',75,'1812e512403748bd8d20cf83682d6ecb','gigabytes',1,'2026-01-22 14:13:50',NULL),('2026-01-21 14:13:50.985377',NULL,'2026-01-21 14:13:51.023258',252,252,NULL,'8d753886-9bbd-48d1-9f80-1b7dd4c20869',96,'1812e512403748bd8d20cf83682d6ecb','shares',1,'2026-01-22 14:13:50','78590156-25d2-468c-8633-1b5bd4532903'),('2026-01-21 14:13:50.986660',NULL,'2026-01-21 14:13:51.023258',253,253,NULL,'8353faba-1291-4c6d-86b2-ee60482b17da',95,'1812e512403748bd8d20cf83682d6ecb','gigabytes',1,'2026-01-22 14:13:50','78590156-25d2-468c-8633-1b5bd4532903'),('2026-01-21 14:13:51.991571',NULL,'2026-01-21 14:13:52.062022',254,254,'54bd2d99c737409a8cdb47d0ef61c0af','598527d4-cbb0-4676-92a7-2697d60f5163',90,'bf58a5c191654263a44f73287e2a242e','snapshots',-1,'2026-01-22 14:13:51',NULL),('2026-01-21 14:13:51.993047',NULL,'2026-01-21 14:13:52.062022',255,255,'54bd2d99c737409a8cdb47d0ef61c0af','2f53da9d-2a1b-4599-87ec-afe6c7891659',89,'bf58a5c191654263a44f73287e2a242e','snapshot_gigabytes',-1,'2026-01-22 14:13:51',NULL),('2026-01-21 14:13:52.008585',NULL,'2026-01-21 14:13:52.062022',256,256,NULL,'a25d4153-5cb7-4c39-a9ab-ce2c655070dd',92,'bf58a5c191654263a44f73287e2a242e','snapshots',-1,'2026-01-22 14:13:51','7cec5100-da97-4c19-a6d2-711aa40fb4a4'),('2026-01-21 14:13:52.010063',NULL,'2026-01-21 14:13:52.062022',257,257,NULL,'86af2d4f-2627-40d4-908a-c1ee9964c389',91,'bf58a5c191654263a44f73287e2a242e','snapshot_gigabytes',-1,'2026-01-22 14:13:51','7cec5100-da97-4c19-a6d2-711aa40fb4a4'),('2026-01-21 14:13:52.047308',NULL,'2026-01-21 14:13:52.113840',258,258,'18d829f19dd445aa98c02d30c005b747','dd8c1d4b-6317-438c-a059-6320d7e03321',86,'498aac0871e5417786fbc3341cc80fbf','shares',-1,'2026-01-22 14:13:52',NULL),('2026-01-21 14:13:52.048236',NULL,'2026-01-21 14:13:52.113840',259,259,'18d829f19dd445aa98c02d30c005b747','51853aef-648f-4aa2-86a2-49e7496c2cc2',85,'498aac0871e5417786fbc3341cc80fbf','gigabytes',-1,'2026-01-22 14:13:52',NULL),('2026-01-21 14:13:52.063304',NULL,'2026-01-21 14:13:52.113840',260,260,NULL,'dd5eae46-d302-414f-8655-542a1247870b',88,'498aac0871e5417786fbc3341cc80fbf','shares',-1,'2026-01-22 14:13:52','21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:13:52.067501',NULL,'2026-01-21 14:13:52.113840',261,261,NULL,'aa47c78e-b384-4d39-b4b8-ad5c123606ef',87,'498aac0871e5417786fbc3341cc80fbf','gigabytes',-1,'2026-01-22 14:13:52','21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:13:54.715481',NULL,'2026-01-21 14:13:54.994245',262,262,'6fc9e38a391d41b1bce34dc4cb926a6d','0d07d7b0-978c-48ad-8b82-21c07385df6c',76,'1812e512403748bd8d20cf83682d6ecb','shares',-1,'2026-01-22 14:13:54',NULL),('2026-01-21 14:13:54.716264',NULL,'2026-01-21 14:13:54.994245',263,263,'6fc9e38a391d41b1bce34dc4cb926a6d','409a5d60-4eb0-44fb-9199-fdb6186b974f',75,'1812e512403748bd8d20cf83682d6ecb','gigabytes',-1,'2026-01-22 14:13:54',NULL),('2026-01-21 14:13:54.726945',NULL,'2026-01-21 14:13:55.082131',264,264,'18d829f19dd445aa98c02d30c005b747','57c6e119-9bec-4ea6-a95d-11abf1f7a99a',86,'498aac0871e5417786fbc3341cc80fbf','shares',1,'2026-01-22 14:13:54',NULL),('2026-01-21 14:13:54.728180',NULL,'2026-01-21 14:13:55.082131',265,265,'18d829f19dd445aa98c02d30c005b747','8f78d486-aa76-491b-8031-ae6c4d686427',85,'498aac0871e5417786fbc3341cc80fbf','gigabytes',1,'2026-01-22 14:13:54',NULL),('2026-01-21 14:13:54.980000',NULL,'2026-01-21 14:13:54.994245',266,266,NULL,'88c0f04f-6a0a-4d98-8493-3fc44dae8fcd',96,'1812e512403748bd8d20cf83682d6ecb','shares',-1,'2026-01-22 14:13:54','78590156-25d2-468c-8633-1b5bd4532903'),('2026-01-21 14:13:54.980920',NULL,'2026-01-21 14:13:54.994245',267,267,NULL,'676a6c5f-13e0-435b-bf5b-0629536be8da',95,'1812e512403748bd8d20cf83682d6ecb','gigabytes',-1,'2026-01-22 14:13:54','78590156-25d2-468c-8633-1b5bd4532903'),('2026-01-21 14:13:54.986983',NULL,'2026-01-21 14:13:55.082131',268,268,NULL,'0cb720be-4591-4a02-a59a-dbf88d8c07b4',88,'498aac0871e5417786fbc3341cc80fbf','shares',1,'2026-01-22 14:13:54','21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:13:54.990692',NULL,'2026-01-21 14:13:55.082131',269,269,NULL,'7c651b41-5716-434c-a8cf-6a95d1d2fde2',87,'498aac0871e5417786fbc3341cc80fbf','gigabytes',1,'2026-01-22 14:13:54','21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:13:55.241532',NULL,'2026-01-21 14:13:55.392809',270,270,'54bd2d99c737409a8cdb47d0ef61c0af','f4017644-aa87-4f06-a403-05fcbb5b54e0',90,'bf58a5c191654263a44f73287e2a242e','snapshots',-1,'2026-01-22 14:13:55',NULL),('2026-01-21 14:13:55.242568',NULL,'2026-01-21 14:13:55.392809',271,271,'54bd2d99c737409a8cdb47d0ef61c0af','919c180b-f356-49db-887b-16139104b030',89,'bf58a5c191654263a44f73287e2a242e','snapshot_gigabytes',-1,'2026-01-22 14:13:55',NULL),('2026-01-21 14:13:55.319960',NULL,'2026-01-21 14:13:55.392809',272,272,NULL,'827a84cd-7cd6-4224-b682-8de7b5973e46',92,'bf58a5c191654263a44f73287e2a242e','snapshots',-1,'2026-01-22 14:13:55','7cec5100-da97-4c19-a6d2-711aa40fb4a4'),('2026-01-21 14:13:55.320997',NULL,'2026-01-21 14:13:55.392809',273,273,NULL,'5ff81a9d-0efe-4c89-b6bc-f44e5bf8bc46',91,'bf58a5c191654263a44f73287e2a242e','snapshot_gigabytes',-1,'2026-01-22 14:13:55','7cec5100-da97-4c19-a6d2-711aa40fb4a4'),('2026-01-21 14:13:55.384816',NULL,'2026-01-21 14:13:56.067956',274,274,'6fc9e38a391d41b1bce34dc4cb926a6d','d6aa0c4e-2106-45ad-a751-b93f6904dcfa',76,'1812e512403748bd8d20cf83682d6ecb','shares',1,'2026-01-22 14:13:55',NULL),('2026-01-21 14:13:55.389716',NULL,'2026-01-21 14:13:56.067956',275,275,'6fc9e38a391d41b1bce34dc4cb926a6d','4d1ed065-53da-4c19-abf7-42f96ef6f191',75,'1812e512403748bd8d20cf83682d6ecb','gigabytes',1,'2026-01-22 14:13:55',NULL),('2026-01-21 14:13:55.623901',NULL,'2026-01-21 14:13:56.067956',276,276,NULL,'b14fa169-be55-40c4-b350-dd277717f91a',98,'1812e512403748bd8d20cf83682d6ecb','shares',1,'2026-01-22 14:13:55','5afaec67-94c3-4b24-8db9-1b003291becd'),('2026-01-21 14:13:55.625285',NULL,'2026-01-21 14:13:56.067956',277,277,NULL,'dd174452-52e0-41f0-8f8b-0f761706c12a',97,'1812e512403748bd8d20cf83682d6ecb','gigabytes',1,'2026-01-22 14:13:55','5afaec67-94c3-4b24-8db9-1b003291becd'),('2026-01-21 14:13:58.695494',NULL,'2026-01-21 14:13:58.711876',278,278,'54bd2d99c737409a8cdb47d0ef61c0af','e8b74431-b00e-48d7-ab29-9cc0ddd0189f',80,'bf58a5c191654263a44f73287e2a242e','shares',-1,'2026-01-22 14:13:58',NULL),('2026-01-21 14:13:58.696253',NULL,'2026-01-21 14:13:58.711876',279,279,'54bd2d99c737409a8cdb47d0ef61c0af','77fcc31b-0355-40c0-ab80-601096d6b6df',79,'bf58a5c191654263a44f73287e2a242e','gigabytes',-1,'2026-01-22 14:13:58',NULL),('2026-01-21 14:13:58.702147',NULL,'2026-01-21 14:13:58.711876',280,280,NULL,'a2062a36-bd49-4ee6-be30-138890eff576',82,'bf58a5c191654263a44f73287e2a242e','shares',-1,'2026-01-22 14:13:58','7cec5100-da97-4c19-a6d2-711aa40fb4a4'),('2026-01-21 14:13:58.702929',NULL,'2026-01-21 14:13:58.711876',281,281,NULL,'1bc03a43-4bbd-49fb-bd24-2529ab4f65f6',81,'bf58a5c191654263a44f73287e2a242e','gigabytes',-1,'2026-01-22 14:13:58','7cec5100-da97-4c19-a6d2-711aa40fb4a4'),('2026-01-21 14:14:00.845562',NULL,'2026-01-21 14:14:00.868248',282,282,'18d829f19dd445aa98c02d30c005b747','52ff7f50-0b48-41d6-b729-1bb3820cf111',86,'498aac0871e5417786fbc3341cc80fbf','shares',-1,'2026-01-22 14:14:00',NULL),('2026-01-21 14:14:00.846430',NULL,'2026-01-21 14:14:00.868248',283,283,'18d829f19dd445aa98c02d30c005b747','3c736d52-e099-4b22-9100-b1966d71837d',85,'498aac0871e5417786fbc3341cc80fbf','gigabytes',-1,'2026-01-22 14:14:00',NULL),('2026-01-21 14:14:00.852577',NULL,'2026-01-21 14:14:00.868248',284,284,NULL,'0e2287ea-2568-4492-bb63-4de65d000559',88,'498aac0871e5417786fbc3341cc80fbf','shares',-1,'2026-01-22 14:14:00','21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:14:00.853461',NULL,'2026-01-21 14:14:00.868248',285,285,NULL,'c0996662-d693-4354-b9b0-fc7cce42fe85',87,'498aac0871e5417786fbc3341cc80fbf','gigabytes',-1,'2026-01-22 14:14:00','21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:14:00.958392',NULL,'2026-01-21 14:14:00.975604',286,286,'6fc9e38a391d41b1bce34dc4cb926a6d','067c0710-8625-420b-94b9-40b7093f64f7',76,'1812e512403748bd8d20cf83682d6ecb','shares',-1,'2026-01-22 14:14:00',NULL),('2026-01-21 14:14:00.959262',NULL,'2026-01-21 14:14:00.975604',287,287,'6fc9e38a391d41b1bce34dc4cb926a6d','7ccc95f5-b84a-4067-8d85-fee958e6e98b',75,'1812e512403748bd8d20cf83682d6ecb','gigabytes',-1,'2026-01-22 14:14:00',NULL),('2026-01-21 14:14:00.966349',NULL,'2026-01-21 14:14:00.975604',288,288,NULL,'f58261d1-cfe9-46ee-a4f3-15338c914cad',98,'1812e512403748bd8d20cf83682d6ecb','shares',-1,'2026-01-22 14:14:00','5afaec67-94c3-4b24-8db9-1b003291becd'),('2026-01-21 14:14:00.967501',NULL,'2026-01-21 14:14:00.975604',289,289,NULL,'b9329618-f39d-4fa8-be4d-2c51a14b063e',97,'1812e512403748bd8d20cf83682d6ecb','gigabytes',-1,'2026-01-22 14:14:00','5afaec67-94c3-4b24-8db9-1b003291becd'),('2026-01-21 14:14:04.101632',NULL,'2026-01-21 14:14:04.219266',290,290,'18d829f19dd445aa98c02d30c005b747','7bc30edb-c782-473e-a854-aaf0db33c2ca',86,'498aac0871e5417786fbc3341cc80fbf','shares',1,'2026-01-22 14:14:04',NULL),('2026-01-21 14:14:04.102975',NULL,'2026-01-21 14:14:04.219266',291,291,'18d829f19dd445aa98c02d30c005b747','7ef9cadb-b541-46cb-aa9b-f76357a00c5b',85,'498aac0871e5417786fbc3341cc80fbf','gigabytes',1,'2026-01-22 14:14:04',NULL),('2026-01-21 14:14:04.166337',NULL,'2026-01-21 14:14:04.219266',292,292,NULL,'0c9858cf-1d38-40c2-b745-4cbddaebc4c3',88,'498aac0871e5417786fbc3341cc80fbf','shares',1,'2026-01-22 14:14:04','21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:14:04.167664',NULL,'2026-01-21 14:14:04.219266',293,293,NULL,'b94f17fe-72ff-4c00-863b-ac3ba588afb6',87,'498aac0871e5417786fbc3341cc80fbf','gigabytes',1,'2026-01-22 14:14:04','21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:14:08.958301',NULL,'2026-01-21 14:14:09.094915',294,294,'18d829f19dd445aa98c02d30c005b747','8ebd05c7-5142-4f40-8513-9763ae3f2778',86,'498aac0871e5417786fbc3341cc80fbf','shares',-1,'2026-01-22 14:14:08',NULL),('2026-01-21 14:14:08.959076',NULL,'2026-01-21 14:14:09.094915',295,295,'18d829f19dd445aa98c02d30c005b747','37ced5b1-db9d-411d-9d48-a362c7d074ee',85,'498aac0871e5417786fbc3341cc80fbf','gigabytes',-1,'2026-01-22 14:14:08',NULL),('2026-01-21 14:14:09.065370',NULL,'2026-01-21 14:14:09.094915',296,296,NULL,'379258e1-b43b-4659-8b62-f10c15272d79',88,'498aac0871e5417786fbc3341cc80fbf','shares',-1,'2026-01-22 14:14:08','21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:14:09.067033',NULL,'2026-01-21 14:14:09.094915',297,297,NULL,'cdcee24b-a78d-4969-9dee-15d225edd510',87,'498aac0871e5417786fbc3341cc80fbf','gigabytes',-1,'2026-01-22 14:14:08','21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:14:10.308224',NULL,'2026-01-21 14:14:10.348869',298,298,'0f49b0d1ba944c46946a092657f6b0f2','be833e7e-257d-46c3-8bb5-7f5ef87b11bd',100,'d8fea3bdb3ee4c03a1197b6e46ed71bc','shares',1,'2026-01-22 14:14:10',NULL),('2026-01-21 14:14:10.310131',NULL,'2026-01-21 14:14:10.348869',299,299,'0f49b0d1ba944c46946a092657f6b0f2','18c5f4a2-c310-4f95-8647-b21dc8b42f10',99,'d8fea3bdb3ee4c03a1197b6e46ed71bc','gigabytes',1,'2026-01-22 14:14:10',NULL),('2026-01-21 14:14:10.326211',NULL,'2026-01-21 14:14:10.348869',300,300,NULL,'0c9222ca-1941-4193-b2c8-baf0c4993731',102,'d8fea3bdb3ee4c03a1197b6e46ed71bc','shares',1,'2026-01-22 14:14:10','7ac1d9c2-538b-4775-a2d5-4c70805fd54c'),('2026-01-21 14:14:10.327361',NULL,'2026-01-21 14:14:10.348869',301,301,NULL,'8ceb33f6-c085-4ddc-b25b-40edb9abe543',101,'d8fea3bdb3ee4c03a1197b6e46ed71bc','gigabytes',1,'2026-01-22 14:14:10','7ac1d9c2-538b-4775-a2d5-4c70805fd54c'),('2026-01-21 14:14:11.986298',NULL,'2026-01-21 14:14:12.398264',302,302,'18d829f19dd445aa98c02d30c005b747','07d7e433-f3a0-4554-899c-c380acf1027a',86,'498aac0871e5417786fbc3341cc80fbf','shares',1,'2026-01-22 14:14:11',NULL),('2026-01-21 14:14:11.991878',NULL,'2026-01-21 14:14:12.398264',303,303,'18d829f19dd445aa98c02d30c005b747','aea5cdaa-e52a-4a0e-be90-4a5b8563c9c6',85,'498aac0871e5417786fbc3341cc80fbf','gigabytes',1,'2026-01-22 14:14:11',NULL),('2026-01-21 14:14:12.170604',NULL,'2026-01-21 14:14:12.398264',304,304,NULL,'45422809-253f-440b-b3f0-b4ce5388896f',88,'498aac0871e5417786fbc3341cc80fbf','shares',1,'2026-01-22 14:14:11','21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:14:12.173303',NULL,'2026-01-21 14:14:12.398264',305,305,NULL,'5070ddc9-3df8-4098-80a8-1e8cf01dd18d',87,'498aac0871e5417786fbc3341cc80fbf','gigabytes',1,'2026-01-22 14:14:11','21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:14:13.780020',NULL,'2026-01-21 14:14:13.799872',306,306,'111328e7e8c9499f9dd897f7f644b965','4558b484-6ce0-4f8c-858b-16d3177acfcc',66,'79952fad07e54cf18c5f2c207bdbf9fb','shares',-1,'2026-01-22 14:14:13',NULL),('2026-01-21 14:14:13.781230',NULL,'2026-01-21 14:14:13.799872',307,307,'111328e7e8c9499f9dd897f7f644b965','4ffbb69c-a4c2-4e69-8bae-4c7c3359e185',65,'79952fad07e54cf18c5f2c207bdbf9fb','gigabytes',-1,'2026-01-22 14:14:13',NULL),('2026-01-21 14:14:13.787343',NULL,'2026-01-21 14:14:13.799872',308,308,NULL,'f33eaa12-9bf0-4979-94c5-b5b0ec303ae8',68,'79952fad07e54cf18c5f2c207bdbf9fb','shares',-1,'2026-01-22 14:14:13','d763adfd-4693-4b03-ad1c-6cfad5db99b3'),('2026-01-21 14:14:13.788484',NULL,'2026-01-21 14:14:13.799872',309,309,NULL,'4662d3d6-73d6-43d9-af96-52c8e30ef885',67,'79952fad07e54cf18c5f2c207bdbf9fb','gigabytes',-1,'2026-01-22 14:14:13','d763adfd-4693-4b03-ad1c-6cfad5db99b3'),('2026-01-21 14:14:13.795749',NULL,'2026-01-21 14:14:13.840247',310,310,'b4c32c9c7b1047fc890e37a5372183aa','7802f63b-5ffc-402e-b881-8abbaf3e3c15',104,'42f926cfde224068a742ef536ed79928','shares',1,'2026-01-22 14:14:13',NULL),('2026-01-21 14:14:13.797313',NULL,'2026-01-21 14:14:13.840247',311,311,'b4c32c9c7b1047fc890e37a5372183aa','6ae1cd87-a769-4a95-ba71-4e7eae89d653',103,'42f926cfde224068a742ef536ed79928','gigabytes',1,'2026-01-22 14:14:13',NULL),('2026-01-21 14:14:13.812360',NULL,'2026-01-21 14:14:13.840247',312,312,NULL,'4470e2e0-2744-4add-abbf-ccb1b82be19f',106,'42f926cfde224068a742ef536ed79928','shares',1,'2026-01-22 14:14:13','d714b627-a89b-463b-804f-ebe84408a229'),('2026-01-21 14:14:13.813697',NULL,'2026-01-21 14:14:13.840247',313,313,NULL,'62cc5492-54e5-4e2b-803e-52e3a17fed47',105,'42f926cfde224068a742ef536ed79928','gigabytes',1,'2026-01-22 14:14:13','d714b627-a89b-463b-804f-ebe84408a229'),('2026-01-21 14:14:13.863644',NULL,'2026-01-21 14:14:13.954293',314,314,'0f49b0d1ba944c46946a092657f6b0f2','1ae9f83d-52e8-46a1-a151-d5eeed7ad8ff',108,'d8fea3bdb3ee4c03a1197b6e46ed71bc','snapshots',1,'2026-01-22 14:14:13',NULL),('2026-01-21 14:14:13.864750',NULL,'2026-01-21 14:14:13.954293',315,315,'0f49b0d1ba944c46946a092657f6b0f2','6e0f8293-6048-4c34-b77d-00160637194a',107,'d8fea3bdb3ee4c03a1197b6e46ed71bc','snapshot_gigabytes',1,'2026-01-22 14:14:13',NULL),('2026-01-21 14:14:13.875028',NULL,'2026-01-21 14:14:13.954293',316,316,NULL,'87093900-493e-4aad-b9cd-58243a2af794',110,'d8fea3bdb3ee4c03a1197b6e46ed71bc','snapshots',1,'2026-01-22 14:14:13','7ac1d9c2-538b-4775-a2d5-4c70805fd54c'),('2026-01-21 14:14:13.876380',NULL,'2026-01-21 14:14:13.954293',317,317,NULL,'6a6a9e1e-9a09-4169-ba97-cebcbbd2dbb6',109,'d8fea3bdb3ee4c03a1197b6e46ed71bc','snapshot_gigabytes',1,'2026-01-22 14:14:13','7ac1d9c2-538b-4775-a2d5-4c70805fd54c'),('2026-01-21 14:14:18.625491',NULL,'2026-01-21 14:14:18.723182',318,318,'111328e7e8c9499f9dd897f7f644b965','6cf06f78-c690-45b4-bfdd-cef42e9b4f9a',70,'79952fad07e54cf18c5f2c207bdbf9fb','snapshots',-1,'2026-01-22 14:14:18',NULL),('2026-01-21 14:14:18.634712',NULL,'2026-01-21 14:14:18.723182',319,319,'111328e7e8c9499f9dd897f7f644b965','934bd6cc-e238-4c55-a235-99018e49baa4',69,'79952fad07e54cf18c5f2c207bdbf9fb','snapshot_gigabytes',-1,'2026-01-22 14:14:18',NULL),('2026-01-21 14:14:18.664615',NULL,'2026-01-21 14:14:18.723182',320,320,NULL,'cea04293-d7e7-4a31-9af0-ff194c0cb84b',72,'79952fad07e54cf18c5f2c207bdbf9fb','snapshots',-1,'2026-01-22 14:14:18','d763adfd-4693-4b03-ad1c-6cfad5db99b3'),('2026-01-21 14:14:18.665752',NULL,'2026-01-21 14:14:18.723182',321,321,NULL,'db63feb9-50ea-4c33-a043-10d6217062c0',71,'79952fad07e54cf18c5f2c207bdbf9fb','snapshot_gigabytes',-1,'2026-01-22 14:14:18','d763adfd-4693-4b03-ad1c-6cfad5db99b3'),('2026-01-21 14:14:18.950244',NULL,'2026-01-21 14:14:18.995540',322,322,'0f49b0d1ba944c46946a092657f6b0f2','8c3909e7-750a-4cba-b33b-5dc92a1f7e69',108,'d8fea3bdb3ee4c03a1197b6e46ed71bc','snapshots',-1,'2026-01-22 14:14:18',NULL),('2026-01-21 14:14:18.951550',NULL,'2026-01-21 14:14:18.995540',323,323,'0f49b0d1ba944c46946a092657f6b0f2','53e49086-4767-4903-bf64-5319a8b5697b',107,'d8fea3bdb3ee4c03a1197b6e46ed71bc','snapshot_gigabytes',-1,'2026-01-22 14:14:18',NULL),('2026-01-21 14:14:18.966808',NULL,'2026-01-21 14:14:18.995540',324,324,NULL,'fe87b492-2b2c-46e1-86c2-42f970bd64a2',110,'d8fea3bdb3ee4c03a1197b6e46ed71bc','snapshots',-1,'2026-01-22 14:14:18','7ac1d9c2-538b-4775-a2d5-4c70805fd54c'),('2026-01-21 14:14:18.968317',NULL,'2026-01-21 14:14:18.995540',325,325,NULL,'ad1231c1-5fd5-4b00-8858-84ef39ce8207',109,'d8fea3bdb3ee4c03a1197b6e46ed71bc','snapshot_gigabytes',-1,'2026-01-22 14:14:18','7ac1d9c2-538b-4775-a2d5-4c70805fd54c'),('2026-01-21 14:14:19.569666',NULL,'2026-01-21 14:14:20.026599',326,326,'18d829f19dd445aa98c02d30c005b747','3d05a477-8ca4-40dc-b382-169f8eaf9674',86,'498aac0871e5417786fbc3341cc80fbf','shares',-1,'2026-01-22 14:14:19',NULL),('2026-01-21 14:14:19.571014',NULL,'2026-01-21 14:14:20.026599',327,327,'18d829f19dd445aa98c02d30c005b747','dddee8e5-ae48-4709-acf6-eedd308a856e',85,'498aac0871e5417786fbc3341cc80fbf','gigabytes',-1,'2026-01-22 14:14:19',NULL),('2026-01-21 14:14:19.857246',NULL,'2026-01-21 14:14:20.026599',328,328,NULL,'0543ef3b-ff78-4164-aa1f-0882576866e3',88,'498aac0871e5417786fbc3341cc80fbf','shares',-1,'2026-01-22 14:14:19','21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:14:19.858676',NULL,'2026-01-21 14:14:20.026599',329,329,NULL,'de890781-3739-419c-bbd0-fd57b3eff408',87,'498aac0871e5417786fbc3341cc80fbf','gigabytes',-1,'2026-01-22 14:14:19','21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:14:22.012741',NULL,'2026-01-21 14:14:22.345042',330,330,'111328e7e8c9499f9dd897f7f644b965','ece8e5e9-d6aa-4c91-a0aa-63d784d4f004',66,'79952fad07e54cf18c5f2c207bdbf9fb','shares',-1,'2026-01-22 14:14:21',NULL),('2026-01-21 14:14:22.015612',NULL,'2026-01-21 14:14:22.345042',331,331,'111328e7e8c9499f9dd897f7f644b965','47c0e859-66ba-4632-b69b-9ac8ce8fd09c',65,'79952fad07e54cf18c5f2c207bdbf9fb','gigabytes',-1,'2026-01-22 14:14:21',NULL),('2026-01-21 14:14:22.197275',NULL,'2026-01-21 14:14:22.345042',332,332,NULL,'17d7ae05-38ea-422e-a6a5-54d722a2e2de',68,'79952fad07e54cf18c5f2c207bdbf9fb','shares',-1,'2026-01-22 14:14:21','d763adfd-4693-4b03-ad1c-6cfad5db99b3'),('2026-01-21 14:14:22.200239',NULL,'2026-01-21 14:14:22.345042',333,333,NULL,'bc8d7300-19ce-48fa-aa5c-f27e9c67dcfb',67,'79952fad07e54cf18c5f2c207bdbf9fb','gigabytes',-1,'2026-01-22 14:14:21','d763adfd-4693-4b03-ad1c-6cfad5db99b3'),('2026-01-21 14:14:22.433554',NULL,'2026-01-21 14:14:22.643358',334,334,'0f49b0d1ba944c46946a092657f6b0f2','aa587a71-c92e-4d67-b1cb-b2f84a7b8d10',100,'d8fea3bdb3ee4c03a1197b6e46ed71bc','shares',-1,'2026-01-22 14:14:22',NULL),('2026-01-21 14:14:22.434315',NULL,'2026-01-21 14:14:22.643358',335,335,'0f49b0d1ba944c46946a092657f6b0f2','fe1c95dd-94ed-4598-a584-b518711465dc',99,'d8fea3bdb3ee4c03a1197b6e46ed71bc','gigabytes',-1,'2026-01-22 14:14:22',NULL),('2026-01-21 14:14:22.609278',NULL,'2026-01-21 14:14:22.643358',336,336,NULL,'02842646-cec8-4402-a3a7-611a212e68cd',102,'d8fea3bdb3ee4c03a1197b6e46ed71bc','shares',-1,'2026-01-22 14:14:22','7ac1d9c2-538b-4775-a2d5-4c70805fd54c'),('2026-01-21 14:14:22.611723',NULL,'2026-01-21 14:14:22.643358',337,337,NULL,'616bf74a-d1b1-4467-98ff-43b875d17e6a',101,'d8fea3bdb3ee4c03a1197b6e46ed71bc','gigabytes',-1,'2026-01-22 14:14:22','7ac1d9c2-538b-4775-a2d5-4c70805fd54c'),('2026-01-21 14:14:25.517669',NULL,'2026-01-21 14:14:26.124474',338,338,'18d829f19dd445aa98c02d30c005b747','b15fccff-e60e-4f11-94f1-2eed24fe74ce',86,'498aac0871e5417786fbc3341cc80fbf','shares',1,'2026-01-22 14:14:25',NULL),('2026-01-21 14:14:25.519504',NULL,'2026-01-21 14:14:26.124474',339,339,'18d829f19dd445aa98c02d30c005b747','59dfc946-06fd-46b0-bae4-25ef59e445fd',85,'498aac0871e5417786fbc3341cc80fbf','gigabytes',1,'2026-01-22 14:14:25',NULL),('2026-01-21 14:14:25.954173',NULL,'2026-01-21 14:14:26.124474',340,340,NULL,'4176e9e0-2bd5-4288-ae8b-d631d407c44f',88,'498aac0871e5417786fbc3341cc80fbf','shares',1,'2026-01-22 14:14:25','21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:14:25.956449',NULL,'2026-01-21 14:14:26.124474',341,341,NULL,'26191601-758a-45bd-83c8-366d3200fe0f',87,'498aac0871e5417786fbc3341cc80fbf','gigabytes',1,'2026-01-22 14:14:25','21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:14:30.134717',NULL,'2026-01-21 14:14:30.177696',342,342,'18d829f19dd445aa98c02d30c005b747','e585a168-e303-4966-9299-fa4683f40b9c',86,'498aac0871e5417786fbc3341cc80fbf','shares',-1,'2026-01-22 14:14:30',NULL),('2026-01-21 14:14:30.135610',NULL,'2026-01-21 14:14:30.177696',343,343,'18d829f19dd445aa98c02d30c005b747','6eff2706-e593-40d1-a337-42eee87eff8f',85,'498aac0871e5417786fbc3341cc80fbf','gigabytes',-1,'2026-01-22 14:14:30',NULL),('2026-01-21 14:14:30.155922',NULL,'2026-01-21 14:14:30.177696',344,344,NULL,'d57ab05a-607e-4449-9994-b927afe1d013',88,'498aac0871e5417786fbc3341cc80fbf','shares',-1,'2026-01-22 14:14:30','21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:14:30.158303',NULL,'2026-01-21 14:14:30.177696',345,345,NULL,'b9641062-808f-4ee0-bcad-224e33795a8a',87,'498aac0871e5417786fbc3341cc80fbf','gigabytes',-1,'2026-01-22 14:14:30','21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:14:37.407615',NULL,'2026-01-21 14:14:37.425171',346,346,'18d829f19dd445aa98c02d30c005b747','bfd031ce-1dd9-468e-9e7a-cbe0290b69f8',86,'498aac0871e5417786fbc3341cc80fbf','shares',-1,'2026-01-22 14:14:37',NULL),('2026-01-21 14:14:37.408615',NULL,'2026-01-21 14:14:37.425171',347,347,'18d829f19dd445aa98c02d30c005b747','f380bf2a-1e63-46d0-b936-501c385a3bff',85,'498aac0871e5417786fbc3341cc80fbf','gigabytes',-1,'2026-01-22 14:14:37',NULL),('2026-01-21 14:14:37.416436',NULL,'2026-01-21 14:14:37.425171',348,348,NULL,'a5e7f221-8c9f-4d92-be41-2420511bfcb5',88,'498aac0871e5417786fbc3341cc80fbf','shares',-1,'2026-01-22 14:14:37','21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:14:37.417681',NULL,'2026-01-21 14:14:37.425171',349,349,NULL,'4a79ce24-570d-4aea-978f-dec9a12d9e8d',87,'498aac0871e5417786fbc3341cc80fbf','gigabytes',-1,'2026-01-22 14:14:37','21dd7853-6f9b-4e9a-91b3-a47c3de6b980'),('2026-01-21 14:14:38.528177',NULL,'2026-01-21 14:14:38.607162',350,350,'1582fd57caf04d9188d3b72ecfc4ddd8','f0c8d8b2-765e-4a3e-9ea6-e8acf9e59a0b',111,'c55f56602b994198b2b9437533a437d7','shares',1,'2026-01-22 14:14:38',NULL),('2026-01-21 14:14:38.529311',NULL,'2026-01-21 14:14:38.607162',351,351,'1582fd57caf04d9188d3b72ecfc4ddd8','858773dd-c1bb-486e-b6cb-93885349d160',112,'c55f56602b994198b2b9437533a437d7','gigabytes',1,'2026-01-22 14:14:38',NULL),('2026-01-21 14:14:38.545017',NULL,'2026-01-21 14:14:38.607162',352,352,NULL,'c0b01e87-aec2-4d05-ab47-d0a87bc82792',113,'c55f56602b994198b2b9437533a437d7','shares',1,'2026-01-22 14:14:38','073dda3b-4203-4183-90b1-b02118757953'),('2026-01-21 14:14:38.550326',NULL,'2026-01-21 14:14:38.607162',353,353,NULL,'c6ddeafc-4766-40cb-83a9-8dd1a126cbbc',114,'c55f56602b994198b2b9437533a437d7','gigabytes',1,'2026-01-22 14:14:38','073dda3b-4203-4183-90b1-b02118757953'),('2026-01-21 14:14:39.755338',NULL,'2026-01-21 14:14:39.777458',354,354,'b4c32c9c7b1047fc890e37a5372183aa','4c07ac32-b5db-484e-8311-6254d98bc157',104,'42f926cfde224068a742ef536ed79928','shares',-1,'2026-01-22 14:14:39',NULL),('2026-01-21 14:14:39.756304',NULL,'2026-01-21 14:14:39.777458',355,355,'b4c32c9c7b1047fc890e37a5372183aa','fee11834-6e94-4ad8-8fd4-235bc5eafa3f',103,'42f926cfde224068a742ef536ed79928','gigabytes',-1,'2026-01-22 14:14:39',NULL),('2026-01-21 14:14:39.762720',NULL,'2026-01-21 14:14:39.777458',356,356,NULL,'57a4208b-d9f2-47a6-b7b7-b32c60433e7e',106,'42f926cfde224068a742ef536ed79928','shares',-1,'2026-01-22 14:14:39','d714b627-a89b-463b-804f-ebe84408a229'),('2026-01-21 14:14:39.763646',NULL,'2026-01-21 14:14:39.777458',357,357,NULL,'c3f2321e-4e40-44dd-a265-0a9d4964fa96',105,'42f926cfde224068a742ef536ed79928','gigabytes',-1,'2026-01-22 14:14:39','d714b627-a89b-463b-804f-ebe84408a229'),('2026-01-21 14:14:42.531663',NULL,'2026-01-21 14:14:42.545967',358,358,'1582fd57caf04d9188d3b72ecfc4ddd8','22750322-ff6b-4e10-9943-7460a4108dfb',111,'c55f56602b994198b2b9437533a437d7','shares',-1,'2026-01-22 14:14:42',NULL),('2026-01-21 14:14:42.532507',NULL,'2026-01-21 14:14:42.545967',359,359,'1582fd57caf04d9188d3b72ecfc4ddd8','b7f89fa8-b1f1-4204-9726-1ce8cf843782',112,'c55f56602b994198b2b9437533a437d7','gigabytes',-1,'2026-01-22 14:14:42',NULL),('2026-01-21 14:14:42.537310',NULL,'2026-01-21 14:14:42.545967',360,360,NULL,'2fcbbaf4-b6f0-4eed-889a-f3d261f13cc4',113,'c55f56602b994198b2b9437533a437d7','shares',-1,'2026-01-22 14:14:42','073dda3b-4203-4183-90b1-b02118757953'),('2026-01-21 14:14:42.537939',NULL,'2026-01-21 14:14:42.545967',361,361,NULL,'c0cd6347-d154-47ca-a2bb-7fca685cafcd',114,'c55f56602b994198b2b9437533a437d7','gigabytes',-1,'2026-01-22 14:14:42','073dda3b-4203-4183-90b1-b02118757953'),('2026-01-21 14:14:42.908434',NULL,'2026-01-21 14:14:43.010375',362,362,'1582fd57caf04d9188d3b72ecfc4ddd8','c72047b3-d709-4db5-9bc1-07f8add89185',111,'c55f56602b994198b2b9437533a437d7','shares',1,'2026-01-22 14:14:42',NULL),('2026-01-21 14:14:42.909987',NULL,'2026-01-21 14:14:43.010375',363,363,'1582fd57caf04d9188d3b72ecfc4ddd8','82159001-7a2d-4a80-af73-fb099a7628b5',112,'c55f56602b994198b2b9437533a437d7','gigabytes',1,'2026-01-22 14:14:42',NULL),('2026-01-21 14:14:42.961948',NULL,'2026-01-21 14:14:43.010375',364,364,NULL,'7b08ec19-08c6-4bda-8139-ed9baf912882',116,'c55f56602b994198b2b9437533a437d7','shares',1,'2026-01-22 14:14:42','2e51bd45-5453-4e78-b8d6-9b395d5d763d'),('2026-01-21 14:14:42.965441',NULL,'2026-01-21 14:14:43.010375',365,365,NULL,'44c83a3c-c517-4638-a639-ba0acccb797e',115,'c55f56602b994198b2b9437533a437d7','gigabytes',1,'2026-01-22 14:14:42','2e51bd45-5453-4e78-b8d6-9b395d5d763d'),('2026-01-21 14:14:47.048262',NULL,'2026-01-21 14:14:47.084901',366,366,'1582fd57caf04d9188d3b72ecfc4ddd8','7cc459b1-a058-42bf-8d92-aa27cc99e5a3',111,'c55f56602b994198b2b9437533a437d7','shares',-1,'2026-01-22 14:14:47',NULL),('2026-01-21 14:14:47.050164',NULL,'2026-01-21 14:14:47.084901',367,367,'1582fd57caf04d9188d3b72ecfc4ddd8','8913f94c-7812-4613-a7f3-a7ad97f9b274',112,'c55f56602b994198b2b9437533a437d7','gigabytes',-1,'2026-01-22 14:14:47',NULL),('2026-01-21 14:14:47.061144',NULL,'2026-01-21 14:14:47.084901',368,368,NULL,'2617d1bf-a271-496b-abbc-f507de2ec96e',116,'c55f56602b994198b2b9437533a437d7','shares',-1,'2026-01-22 14:14:47','2e51bd45-5453-4e78-b8d6-9b395d5d763d'),('2026-01-21 14:14:47.063075',NULL,'2026-01-21 14:14:47.084901',369,369,NULL,'ca17cd12-a965-4e28-b6e3-f88312167e4d',115,'c55f56602b994198b2b9437533a437d7','gigabytes',-1,'2026-01-22 14:14:47','2e51bd45-5453-4e78-b8d6-9b395d5d763d'),('2026-01-21 14:14:47.846662',NULL,'2026-01-21 14:14:48.317209',370,370,'1582fd57caf04d9188d3b72ecfc4ddd8','592502d4-014f-408d-b5e6-00e42777474b',111,'c55f56602b994198b2b9437533a437d7','shares',1,'2026-01-22 14:14:47',NULL),('2026-01-21 14:14:47.849911',NULL,'2026-01-21 14:14:48.317209',371,371,'1582fd57caf04d9188d3b72ecfc4ddd8','7a9e929d-7a64-47e9-8ebb-ba3aee26b37d',112,'c55f56602b994198b2b9437533a437d7','gigabytes',1,'2026-01-22 14:14:47',NULL),('2026-01-21 14:14:47.921328',NULL,'2026-01-21 14:14:48.317209',372,372,NULL,'40e48b11-f292-4e0f-8e66-6447a9650466',117,'c55f56602b994198b2b9437533a437d7','shares',1,'2026-01-22 14:14:47','570df0ca-219d-4456-90e9-bfe5252d183e'),('2026-01-21 14:14:47.934281',NULL,'2026-01-21 14:14:48.317209',373,373,NULL,'22e2c6b0-1285-43b9-b792-4886138fcb25',118,'c55f56602b994198b2b9437533a437d7','gigabytes',1,'2026-01-22 14:14:47','570df0ca-219d-4456-90e9-bfe5252d183e'),('2026-01-21 14:14:51.254564',NULL,'2026-01-21 14:14:51.466717',374,374,'47292555c1b142f8967d2205628edba1','c650aed6-9957-4d09-a805-b1a230993f83',120,'a226ad4df79b48a2b4c6ddc1ed2cb474','shares',1,'2026-01-22 14:14:51',NULL),('2026-01-21 14:14:51.422039',NULL,'2026-01-21 14:14:51.466717',375,375,'47292555c1b142f8967d2205628edba1','25cd0713-1b4c-4d79-9958-06f9ece8afae',119,'a226ad4df79b48a2b4c6ddc1ed2cb474','gigabytes',1,'2026-01-22 14:14:51',NULL),('2026-01-21 14:14:51.443416',NULL,'2026-01-21 14:14:51.466717',376,376,NULL,'5b1f2daf-70a1-4338-b179-d5903781f15d',122,'a226ad4df79b48a2b4c6ddc1ed2cb474','shares',1,'2026-01-22 14:14:51','4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b'),('2026-01-21 14:14:51.444767',NULL,'2026-01-21 14:14:51.466717',377,377,NULL,'3e014d25-83cc-48a5-b065-45ec80a83350',121,'a226ad4df79b48a2b4c6ddc1ed2cb474','gigabytes',1,'2026-01-22 14:14:51','4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b'),('2026-01-21 14:14:53.630651',NULL,'2026-01-21 14:14:56.004365',378,378,'1582fd57caf04d9188d3b72ecfc4ddd8','6bde0db6-b6d2-4a90-84d0-209eec2392cf',111,'c55f56602b994198b2b9437533a437d7','shares',1,'2026-01-22 14:14:53',NULL),('2026-01-21 14:14:53.632053',NULL,'2026-01-21 14:14:56.004365',379,379,'1582fd57caf04d9188d3b72ecfc4ddd8','2226f0a0-875e-475d-abd8-160910ec232a',112,'c55f56602b994198b2b9437533a437d7','gigabytes',1,'2026-01-22 14:14:53',NULL),('2026-01-21 14:14:53.984357',NULL,'2026-01-21 14:14:56.004365',380,380,NULL,'df2594ca-c80f-4833-a25d-f837bca168b2',124,'c55f56602b994198b2b9437533a437d7','shares',1,'2026-01-22 14:14:53','f90ca7dd-2c72-49d1-9bfd-c7cfc1f6b718'),('2026-01-21 14:14:53.986223',NULL,'2026-01-21 14:14:56.004365',381,381,NULL,'962e0439-05a0-4154-bb2c-6e3b5c0a3c42',123,'c55f56602b994198b2b9437533a437d7','gigabytes',1,'2026-01-22 14:14:53','f90ca7dd-2c72-49d1-9bfd-c7cfc1f6b718'),('2026-01-21 14:14:59.472340',NULL,'2026-01-21 14:14:59.550611',382,382,'47292555c1b142f8967d2205628edba1','a518b80b-6486-4f8b-b02b-13a6df6d800b',120,'a226ad4df79b48a2b4c6ddc1ed2cb474','shares',1,'2026-01-22 14:14:59',NULL),('2026-01-21 14:14:59.477045',NULL,'2026-01-21 14:14:59.550611',383,383,'47292555c1b142f8967d2205628edba1','35f6da00-276d-49e3-9486-26abc238660c',119,'a226ad4df79b48a2b4c6ddc1ed2cb474','gigabytes',1,'2026-01-22 14:14:59',NULL),('2026-01-21 14:14:59.486028',NULL,'2026-01-21 14:14:59.550611',384,384,NULL,'a22457ab-ab26-4f00-a824-ce695881b33d',122,'a226ad4df79b48a2b4c6ddc1ed2cb474','shares',1,'2026-01-22 14:14:59','4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b'),('2026-01-21 14:14:59.489942',NULL,'2026-01-21 14:14:59.550611',385,385,NULL,'f8a1ec00-7de8-41eb-98f2-b86a84992594',121,'a226ad4df79b48a2b4c6ddc1ed2cb474','gigabytes',1,'2026-01-22 14:14:59','4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b'),('2026-01-21 14:14:59.532398',NULL,'2026-01-21 14:14:59.623292',386,386,'29824244ca994d38a91f46f7cb52ca0f','1f7c6e78-44bd-493b-b201-bb567bb6009f',126,'ef367d46915e42899003255d11c5ebdd','shares',1,'2026-01-22 14:14:59',NULL),('2026-01-21 14:14:59.534127',NULL,'2026-01-21 14:14:59.623292',387,387,'29824244ca994d38a91f46f7cb52ca0f','520ab03a-8ada-49f2-8de2-0824ecb7b96a',125,'ef367d46915e42899003255d11c5ebdd','gigabytes',1,'2026-01-22 14:14:59',NULL),('2026-01-21 14:14:59.554015',NULL,'2026-01-21 14:14:59.623292',388,388,NULL,'a8217587-3da5-4e5a-b5ff-f6a2e997ec6a',128,'ef367d46915e42899003255d11c5ebdd','shares',1,'2026-01-22 14:14:59','fa3be0f8-2dde-43f0-80c0-e2a4ba884d5b'),('2026-01-21 14:14:59.560508',NULL,'2026-01-21 14:14:59.623292',389,389,NULL,'8d40cb2b-1a6d-4d64-b5b7-a084a4cb02ca',127,'ef367d46915e42899003255d11c5ebdd','gigabytes',1,'2026-01-22 14:14:59','fa3be0f8-2dde-43f0-80c0-e2a4ba884d5b'),('2026-01-21 14:15:00.078598',NULL,'2026-01-21 14:15:00.206925',390,390,'1582fd57caf04d9188d3b72ecfc4ddd8','b49c3660-090f-481a-b62b-ce9e55f383be',111,'c55f56602b994198b2b9437533a437d7','shares',-1,'2026-01-22 14:15:00',NULL),('2026-01-21 14:15:00.079420',NULL,'2026-01-21 14:15:00.206925',391,391,'1582fd57caf04d9188d3b72ecfc4ddd8','55304c57-eb4b-47a4-adc4-bad589c88f40',112,'c55f56602b994198b2b9437533a437d7','gigabytes',-1,'2026-01-22 14:15:00',NULL),('2026-01-21 14:15:00.101091',NULL,'2026-01-21 14:15:00.206925',392,392,NULL,'66f85569-52ca-4da1-993f-425eb1cfec46',124,'c55f56602b994198b2b9437533a437d7','shares',-1,'2026-01-22 14:15:00','f90ca7dd-2c72-49d1-9bfd-c7cfc1f6b718'),('2026-01-21 14:15:00.102013',NULL,'2026-01-21 14:15:00.206925',393,393,NULL,'91720531-d87a-43cf-a2a4-c4026a9e4569',123,'c55f56602b994198b2b9437533a437d7','gigabytes',-1,'2026-01-22 14:15:00','f90ca7dd-2c72-49d1-9bfd-c7cfc1f6b718'),('2026-01-21 14:15:00.517459',NULL,'2026-01-21 14:15:00.548235',394,394,'1582fd57caf04d9188d3b72ecfc4ddd8','07d397ef-37ea-44e4-b8c3-0c11c7854846',111,'c55f56602b994198b2b9437533a437d7','shares',-1,'2026-01-22 14:15:00',NULL),('2026-01-21 14:15:00.518638',NULL,'2026-01-21 14:15:00.548235',395,395,'1582fd57caf04d9188d3b72ecfc4ddd8','4868627f-80c2-4f79-b569-c385fe2620da',112,'c55f56602b994198b2b9437533a437d7','gigabytes',-1,'2026-01-22 14:15:00',NULL),('2026-01-21 14:15:00.530998',NULL,'2026-01-21 14:15:00.548235',396,396,NULL,'8667e1fa-f35a-4a7f-aee4-b1e13a3ad296',117,'c55f56602b994198b2b9437533a437d7','shares',-1,'2026-01-22 14:15:00','570df0ca-219d-4456-90e9-bfe5252d183e'),('2026-01-21 14:15:00.531876',NULL,'2026-01-21 14:15:00.548235',397,397,NULL,'33f6fa64-2448-45a4-b3c8-6c0507ca6474',118,'c55f56602b994198b2b9437533a437d7','gigabytes',-1,'2026-01-22 14:15:00','570df0ca-219d-4456-90e9-bfe5252d183e'),('2026-01-21 14:15:01.098555',NULL,'2026-01-21 14:15:01.246946',398,398,'1582fd57caf04d9188d3b72ecfc4ddd8','5f018d68-b32b-44fd-a1de-cec25fe22ad9',111,'c55f56602b994198b2b9437533a437d7','shares',1,'2026-01-22 14:15:01',NULL),('2026-01-21 14:15:01.099879',NULL,'2026-01-21 14:15:01.246946',399,399,'1582fd57caf04d9188d3b72ecfc4ddd8','994eb435-5242-4ae0-93ac-ea19816279a9',112,'c55f56602b994198b2b9437533a437d7','gigabytes',1,'2026-01-22 14:15:01',NULL),('2026-01-21 14:15:01.130571',NULL,'2026-01-21 14:15:01.246946',400,400,NULL,'4933afef-b097-400a-8db7-08b765facd65',129,'c55f56602b994198b2b9437533a437d7','shares',1,'2026-01-22 14:15:01','c920fd72-4f4d-4931-b24d-6a9c60f2e233'),('2026-01-21 14:15:01.134279',NULL,'2026-01-21 14:15:01.246946',401,401,NULL,'f4ab9947-3898-44ff-9ef3-c8aed416ed9d',130,'c55f56602b994198b2b9437533a437d7','gigabytes',1,'2026-01-22 14:15:01','c920fd72-4f4d-4931-b24d-6a9c60f2e233'),('2026-01-21 14:15:01.158882',NULL,'2026-01-21 14:15:01.300349',402,402,'691428d7711d49218388c97727044c76','9a8728ae-4cf5-4dab-89e2-9c4e40091dd1',132,'28d69e0c83c84d03bcfbc4f9c9057023','shares',1,'2026-01-22 14:15:01',NULL),('2026-01-21 14:15:01.160434',NULL,'2026-01-21 14:15:01.300349',403,403,'691428d7711d49218388c97727044c76','7ea922b1-a5ba-4ceb-ac57-0f1bdd7b7aed',131,'28d69e0c83c84d03bcfbc4f9c9057023','gigabytes',1,'2026-01-22 14:15:01',NULL),('2026-01-21 14:15:01.239618',NULL,'2026-01-21 14:15:01.300349',404,404,NULL,'62f50646-4b77-4c2c-9729-e7e36fa4c0f5',134,'28d69e0c83c84d03bcfbc4f9c9057023','shares',1,'2026-01-22 14:15:01','5f9f4ef7-dc66-42d3-8b39-c62ccc780aba'),('2026-01-21 14:15:01.243711',NULL,'2026-01-21 14:15:01.300349',405,405,NULL,'9341aaa3-6092-44f0-b367-3a03f60a13b3',133,'28d69e0c83c84d03bcfbc4f9c9057023','gigabytes',1,'2026-01-22 14:15:01','5f9f4ef7-dc66-42d3-8b39-c62ccc780aba'),('2026-01-21 14:15:05.245892',NULL,'2026-01-21 14:15:05.310322',406,406,'1582fd57caf04d9188d3b72ecfc4ddd8','d8f54373-cf05-47be-9a1c-48c464b0b5fc',111,'c55f56602b994198b2b9437533a437d7','shares',1,'2026-01-22 14:15:05',NULL),('2026-01-21 14:15:05.247789',NULL,'2026-01-21 14:15:05.310322',407,407,'1582fd57caf04d9188d3b72ecfc4ddd8','bda370c6-ad55-4c1e-a6c9-9a1e3098a3ce',112,'c55f56602b994198b2b9437533a437d7','gigabytes',1,'2026-01-22 14:15:05',NULL),('2026-01-21 14:15:05.264793',NULL,'2026-01-21 14:15:05.310322',408,408,NULL,'e8c1b013-6530-4252-ab3a-e9e6a9baa230',135,'c55f56602b994198b2b9437533a437d7','shares',1,'2026-01-22 14:15:05','60b901c2-472b-4f17-bdda-ff703ace9faf'),('2026-01-21 14:15:05.266068',NULL,'2026-01-21 14:15:05.310322',409,409,NULL,'a509ce6e-93c1-4f3d-8e5b-8e80a3401c8c',136,'c55f56602b994198b2b9437533a437d7','gigabytes',1,'2026-01-22 14:15:05','60b901c2-472b-4f17-bdda-ff703ace9faf'),('2026-01-21 14:15:05.857386',NULL,'2026-01-21 14:15:06.293748',410,410,'29824244ca994d38a91f46f7cb52ca0f','1c6be4de-56ff-4041-b47c-0e5e22ed60a7',126,'ef367d46915e42899003255d11c5ebdd','shares',-1,'2026-01-22 14:15:05',NULL),('2026-01-21 14:15:05.858413',NULL,'2026-01-21 14:15:06.293748',411,411,'29824244ca994d38a91f46f7cb52ca0f','ab21c47e-3636-47d8-b132-ce3f6ce855db',125,'ef367d46915e42899003255d11c5ebdd','gigabytes',-1,'2026-01-22 14:15:05',NULL),('2026-01-21 14:15:06.113140',NULL,'2026-01-21 14:15:06.293748',412,412,NULL,'d7087dac-cb74-400f-8121-ab8f37c110fe',128,'ef367d46915e42899003255d11c5ebdd','shares',-1,'2026-01-22 14:15:05','fa3be0f8-2dde-43f0-80c0-e2a4ba884d5b'),('2026-01-21 14:15:06.114300',NULL,'2026-01-21 14:15:06.293748',413,413,NULL,'0a3bb93e-16e9-463a-8beb-7bc36d078c7b',127,'ef367d46915e42899003255d11c5ebdd','gigabytes',-1,'2026-01-22 14:15:05','fa3be0f8-2dde-43f0-80c0-e2a4ba884d5b'),('2026-01-21 14:15:08.888186',NULL,'2026-01-21 14:15:09.108627',414,414,'1582fd57caf04d9188d3b72ecfc4ddd8','64f6ad2f-5499-4eca-b98a-e2cb9d28cc5b',111,'c55f56602b994198b2b9437533a437d7','shares',1,'2026-01-22 14:15:08',NULL),('2026-01-21 14:15:08.890294',NULL,'2026-01-21 14:15:09.108627',415,415,'1582fd57caf04d9188d3b72ecfc4ddd8','0e56dd1e-6a72-43b1-b7d3-dbf49d2eea5f',112,'c55f56602b994198b2b9437533a437d7','gigabytes',1,'2026-01-22 14:15:08',NULL),('2026-01-21 14:15:08.984153',NULL,'2026-01-21 14:15:09.108627',416,416,NULL,'ed36a4ac-3130-4595-b093-347e626d16a4',138,'c55f56602b994198b2b9437533a437d7','shares',1,'2026-01-22 14:15:08','7efdd4ee-25a0-4ed9-bca7-168f82a1df34'),('2026-01-21 14:15:08.985434',NULL,'2026-01-21 14:15:09.108627',417,417,NULL,'aa607d0c-0436-4b10-aa07-d721ff8795eb',137,'c55f56602b994198b2b9437533a437d7','gigabytes',1,'2026-01-22 14:15:08','7efdd4ee-25a0-4ed9-bca7-168f82a1df34'),('2026-01-21 14:15:12.408880',NULL,'2026-01-21 14:15:12.894521',418,418,'691428d7711d49218388c97727044c76','351e83ab-8f88-421d-93c1-c3fb73f87863',132,'28d69e0c83c84d03bcfbc4f9c9057023','shares',-1,'2026-01-22 14:15:11',NULL),('2026-01-21 14:15:12.409942',NULL,'2026-01-21 14:15:12.894521',419,419,'691428d7711d49218388c97727044c76','b74126e6-901e-4d46-8088-0e48e66d43cb',131,'28d69e0c83c84d03bcfbc4f9c9057023','gigabytes',-1,'2026-01-22 14:15:11',NULL),('2026-01-21 14:15:12.773051',NULL,'2026-01-21 14:15:12.920298',420,420,'47292555c1b142f8967d2205628edba1','4b3206cc-362c-4ffc-92ef-9ce2c7abaa35',120,'a226ad4df79b48a2b4c6ddc1ed2cb474','shares',-1,'2026-01-22 14:15:12',NULL),('2026-01-21 14:15:12.779182',NULL,'2026-01-21 14:15:12.920298',421,421,'47292555c1b142f8967d2205628edba1','b567cb04-a6b1-446c-a660-78e8ef8ec52e',119,'a226ad4df79b48a2b4c6ddc1ed2cb474','gigabytes',-1,'2026-01-22 14:15:12',NULL),('2026-01-21 14:15:12.804032',NULL,'2026-01-21 14:15:12.894521',422,422,NULL,'696e1afb-19d2-4025-b9e6-980516f960b0',134,'28d69e0c83c84d03bcfbc4f9c9057023','shares',-1,'2026-01-22 14:15:11','5f9f4ef7-dc66-42d3-8b39-c62ccc780aba'),('2026-01-21 14:15:12.804963',NULL,'2026-01-21 14:15:12.894521',423,423,NULL,'79c4a520-68bd-4eee-aad1-9220a698af97',133,'28d69e0c83c84d03bcfbc4f9c9057023','gigabytes',-1,'2026-01-22 14:15:11','5f9f4ef7-dc66-42d3-8b39-c62ccc780aba'),('2026-01-21 14:15:12.831542',NULL,'2026-01-21 14:15:12.920298',424,424,NULL,'07e1bda5-607e-4ff9-bfd7-89913b9a82fa',122,'a226ad4df79b48a2b4c6ddc1ed2cb474','shares',-1,'2026-01-22 14:15:12','4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b'),('2026-01-21 14:15:12.832468',NULL,'2026-01-21 14:15:12.920298',425,425,NULL,'dc30f94a-f5e1-47f6-b39f-7284bba57a3e',121,'a226ad4df79b48a2b4c6ddc1ed2cb474','gigabytes',-1,'2026-01-22 14:15:12','4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b'),('2026-01-21 14:15:12.995690',NULL,'2026-01-21 14:15:13.017177',426,426,'1582fd57caf04d9188d3b72ecfc4ddd8','47c8d21f-3fbf-4cf3-9007-47c15fec89be',111,'c55f56602b994198b2b9437533a437d7','shares',-1,'2026-01-22 14:15:12',NULL),('2026-01-21 14:15:12.996636',NULL,'2026-01-21 14:15:13.017177',427,427,'1582fd57caf04d9188d3b72ecfc4ddd8','802a9258-14dc-48b5-87f1-a7cc1680bc19',112,'c55f56602b994198b2b9437533a437d7','gigabytes',-1,'2026-01-22 14:15:12',NULL),('2026-01-21 14:15:13.005909',NULL,'2026-01-21 14:15:13.017177',428,428,NULL,'b0111cc2-01f5-4117-829b-a29953019939',138,'c55f56602b994198b2b9437533a437d7','shares',-1,'2026-01-22 14:15:12','7efdd4ee-25a0-4ed9-bca7-168f82a1df34'),('2026-01-21 14:15:13.006782',NULL,'2026-01-21 14:15:13.017177',429,429,NULL,'027ecc93-d48c-40be-b355-97264b17a032',137,'c55f56602b994198b2b9437533a437d7','gigabytes',-1,'2026-01-22 14:15:12','7efdd4ee-25a0-4ed9-bca7-168f82a1df34'),('2026-01-21 14:15:13.363856',NULL,'2026-01-21 14:15:13.854615',430,430,'1582fd57caf04d9188d3b72ecfc4ddd8','73819753-1946-4e86-8497-908815a8f23b',111,'c55f56602b994198b2b9437533a437d7','shares',-1,'2026-01-22 14:15:13',NULL),('2026-01-21 14:15:13.365045',NULL,'2026-01-21 14:15:13.854615',431,431,'1582fd57caf04d9188d3b72ecfc4ddd8','cf882418-2133-428a-b144-693f16f925c3',112,'c55f56602b994198b2b9437533a437d7','gigabytes',-1,'2026-01-22 14:15:13',NULL),('2026-01-21 14:15:13.710642',NULL,'2026-01-21 14:15:13.854615',432,432,NULL,'f3096d12-0081-423a-8863-e7b43bce5107',135,'c55f56602b994198b2b9437533a437d7','shares',-1,'2026-01-22 14:15:13','60b901c2-472b-4f17-bdda-ff703ace9faf'),('2026-01-21 14:15:13.711681',NULL,'2026-01-21 14:15:13.854615',433,433,NULL,'4cda6838-0471-4624-9f90-16075f2aa9f0',136,'c55f56602b994198b2b9437533a437d7','gigabytes',-1,'2026-01-22 14:15:13','60b901c2-472b-4f17-bdda-ff703ace9faf'),('2026-01-21 14:15:16.856665',NULL,'2026-01-21 14:15:16.876977',434,434,'1582fd57caf04d9188d3b72ecfc4ddd8','05d98aee-83d8-4f56-bd2f-ed511c53b15d',111,'c55f56602b994198b2b9437533a437d7','shares',-1,'2026-01-22 14:15:16',NULL),('2026-01-21 14:15:16.857796',NULL,'2026-01-21 14:15:16.876977',435,435,'1582fd57caf04d9188d3b72ecfc4ddd8','06fa2053-2f7a-4f9d-aaa7-3ac471534c25',112,'c55f56602b994198b2b9437533a437d7','gigabytes',-1,'2026-01-22 14:15:16',NULL),('2026-01-21 14:15:16.866507',NULL,'2026-01-21 14:15:16.876977',436,436,NULL,'26205e98-2f9e-4c37-a6ee-4eed6a70949f',129,'c55f56602b994198b2b9437533a437d7','shares',-1,'2026-01-22 14:15:16','c920fd72-4f4d-4931-b24d-6a9c60f2e233'),('2026-01-21 14:15:16.867441',NULL,'2026-01-21 14:15:16.876977',437,437,NULL,'2c5ffe2b-d14c-45f1-a65f-daa48545ed4d',130,'c55f56602b994198b2b9437533a437d7','gigabytes',-1,'2026-01-22 14:15:16','c920fd72-4f4d-4931-b24d-6a9c60f2e233'),('2026-01-21 14:15:16.890435',NULL,'2026-01-21 14:15:16.952284',438,438,'47292555c1b142f8967d2205628edba1','1de8d0aa-cc2e-4c24-ab90-dfdccec741d2',120,'a226ad4df79b48a2b4c6ddc1ed2cb474','shares',1,'2026-01-22 14:15:16',NULL),('2026-01-21 14:15:16.893302',NULL,'2026-01-21 14:15:16.952284',439,439,'47292555c1b142f8967d2205628edba1','8426d157-faf6-4c81-9395-47a043cd0867',119,'a226ad4df79b48a2b4c6ddc1ed2cb474','gigabytes',1,'2026-01-22 14:15:16',NULL),('2026-01-21 14:15:16.908091',NULL,'2026-01-21 14:15:16.952284',440,440,NULL,'f5d7e2fe-85b1-4010-ab44-a4410e5211b3',122,'a226ad4df79b48a2b4c6ddc1ed2cb474','shares',1,'2026-01-22 14:15:16','4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b'),('2026-01-21 14:15:16.910893',NULL,'2026-01-21 14:15:16.952284',441,441,NULL,'6e1c6211-26cb-4fca-8ef9-ec2b738f2d70',121,'a226ad4df79b48a2b4c6ddc1ed2cb474','gigabytes',1,'2026-01-22 14:15:16','4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b'),('2026-01-21 14:15:17.338672',NULL,'2026-01-21 14:15:17.483401',442,442,'1582fd57caf04d9188d3b72ecfc4ddd8','f3366045-dce5-4f18-bcd2-dcc660a1fbe6',111,'c55f56602b994198b2b9437533a437d7','shares',1,'2026-01-22 14:15:17',NULL),('2026-01-21 14:15:17.339924',NULL,'2026-01-21 14:15:17.483401',443,443,'1582fd57caf04d9188d3b72ecfc4ddd8','86bb3ae9-91a6-43d0-bc14-7296a26f56d6',112,'c55f56602b994198b2b9437533a437d7','gigabytes',1,'2026-01-22 14:15:17',NULL),('2026-01-21 14:15:17.414896',NULL,'2026-01-21 14:15:17.483401',444,444,NULL,'905c870f-3148-4ed3-9fcd-cb3b54956747',140,'c55f56602b994198b2b9437533a437d7','shares',1,'2026-01-22 14:15:17','96a3f3a7-7b33-4316-8b52-e062643518d7'),('2026-01-21 14:15:17.416469',NULL,'2026-01-21 14:15:17.483401',445,445,NULL,'31fe1df2-2ef2-44d0-ba37-7b182a85d119',139,'c55f56602b994198b2b9437533a437d7','gigabytes',1,'2026-01-22 14:15:17','96a3f3a7-7b33-4316-8b52-e062643518d7'),('2026-01-21 14:15:22.394201',NULL,'2026-01-21 14:15:22.448447',446,446,'1582fd57caf04d9188d3b72ecfc4ddd8','8e0d17e8-ff70-440a-95ec-4932d8494ed6',111,'c55f56602b994198b2b9437533a437d7','shares',1,'2026-01-22 14:15:22',NULL),('2026-01-21 14:15:22.396924',NULL,'2026-01-21 14:15:22.448447',447,447,'1582fd57caf04d9188d3b72ecfc4ddd8','010d9ef4-6d1d-4094-aabd-4094854854c5',112,'c55f56602b994198b2b9437533a437d7','gigabytes',1,'2026-01-22 14:15:22',NULL),('2026-01-21 14:15:22.414466',NULL,'2026-01-21 14:15:22.448447',448,448,NULL,'ac05a7a2-de1f-4018-a76a-26e6a85336e7',142,'c55f56602b994198b2b9437533a437d7','shares',1,'2026-01-22 14:15:22','86c39d6d-2e5a-4607-a4f6-36e6a44459c6'),('2026-01-21 14:15:22.416166',NULL,'2026-01-21 14:15:22.448447',449,449,NULL,'c3ce431a-e211-4930-b61e-28eb3ea226b5',141,'c55f56602b994198b2b9437533a437d7','gigabytes',1,'2026-01-22 14:15:22','86c39d6d-2e5a-4607-a4f6-36e6a44459c6'),('2026-01-21 14:15:26.326573',NULL,'2026-01-21 14:15:26.338370',450,450,'1582fd57caf04d9188d3b72ecfc4ddd8','1dbdd58a-fb32-44e5-980e-6df5528a2719',111,'c55f56602b994198b2b9437533a437d7','shares',-1,'2026-01-22 14:15:26',NULL),('2026-01-21 14:15:26.327277',NULL,'2026-01-21 14:15:26.338370',451,451,'1582fd57caf04d9188d3b72ecfc4ddd8','23447c55-82c3-47e9-9d46-442c083b5dde',112,'c55f56602b994198b2b9437533a437d7','gigabytes',-1,'2026-01-22 14:15:26',NULL),('2026-01-21 14:15:26.332031',NULL,'2026-01-21 14:15:26.338370',452,452,NULL,'3efad041-ea77-4a3a-a3ad-40822021e4bf',142,'c55f56602b994198b2b9437533a437d7','shares',-1,'2026-01-22 14:15:26','86c39d6d-2e5a-4607-a4f6-36e6a44459c6'),('2026-01-21 14:15:26.332622',NULL,'2026-01-21 14:15:26.338370',453,453,NULL,'eefdcdac-788e-4493-99a3-67cb352cc841',141,'c55f56602b994198b2b9437533a437d7','gigabytes',-1,'2026-01-22 14:15:26','86c39d6d-2e5a-4607-a4f6-36e6a44459c6'),('2026-01-21 14:15:26.884451',NULL,'2026-01-21 14:15:26.904697',454,454,'47292555c1b142f8967d2205628edba1','cf78b443-e6fa-4d8e-b0d9-fc20724415f3',120,'a226ad4df79b48a2b4c6ddc1ed2cb474','shares',-1,'2026-01-22 14:15:26',NULL),('2026-01-21 14:15:26.885331',NULL,'2026-01-21 14:15:26.904697',455,455,'47292555c1b142f8967d2205628edba1','08d5da27-e675-488e-b6f8-2b21d8456b42',119,'a226ad4df79b48a2b4c6ddc1ed2cb474','gigabytes',-1,'2026-01-22 14:15:26',NULL),('2026-01-21 14:15:26.892774',NULL,'2026-01-21 14:15:26.904697',456,456,NULL,'6b258902-0517-4446-8a39-3db7ff782081',122,'a226ad4df79b48a2b4c6ddc1ed2cb474','shares',-1,'2026-01-22 14:15:26','4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b'),('2026-01-21 14:15:26.893982',NULL,'2026-01-21 14:15:26.904697',457,457,NULL,'bc9025c9-2e5a-4514-a357-ee7138add0c9',121,'a226ad4df79b48a2b4c6ddc1ed2cb474','gigabytes',-1,'2026-01-22 14:15:26','4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b'),('2026-01-21 14:15:26.953547',NULL,'2026-01-21 14:15:26.987315',458,458,'1582fd57caf04d9188d3b72ecfc4ddd8','45aad129-3a5d-40ce-be91-20ce9fff8b65',111,'c55f56602b994198b2b9437533a437d7','shares',-1,'2026-01-22 14:15:26',NULL),('2026-01-21 14:15:26.955997',NULL,'2026-01-21 14:15:26.987315',459,459,'1582fd57caf04d9188d3b72ecfc4ddd8','2fd30dbd-581f-43ee-8bc0-6be6a2931f82',112,'c55f56602b994198b2b9437533a437d7','gigabytes',-1,'2026-01-22 14:15:26',NULL),('2026-01-21 14:15:26.972151',NULL,'2026-01-21 14:15:26.987315',460,460,NULL,'2f9fca37-9f42-4053-8887-f67e83f67401',140,'c55f56602b994198b2b9437533a437d7','shares',-1,'2026-01-22 14:15:26','96a3f3a7-7b33-4316-8b52-e062643518d7'),('2026-01-21 14:15:26.973801',NULL,'2026-01-21 14:15:26.987315',461,461,NULL,'3cbf2d95-9948-44e1-bd5e-dd4c693abda8',139,'c55f56602b994198b2b9437533a437d7','gigabytes',-1,'2026-01-22 14:15:26','96a3f3a7-7b33-4316-8b52-e062643518d7'),('2026-01-21 14:15:27.264984',NULL,'2026-01-21 14:15:27.299875',462,462,'1582fd57caf04d9188d3b72ecfc4ddd8','199782f4-1863-4891-8042-cc682ff47ae5',111,'c55f56602b994198b2b9437533a437d7','shares',1,'2026-01-22 14:15:27',NULL),('2026-01-21 14:15:27.266237',NULL,'2026-01-21 14:15:27.299875',463,463,'1582fd57caf04d9188d3b72ecfc4ddd8','41718229-7512-4717-8613-321079a28f62',112,'c55f56602b994198b2b9437533a437d7','gigabytes',1,'2026-01-22 14:15:27',NULL),('2026-01-21 14:15:27.275967',NULL,'2026-01-21 14:15:27.299875',464,464,NULL,'3c3b51f6-5ecc-4be6-a043-4c68da72cd2c',144,'c55f56602b994198b2b9437533a437d7','shares',1,'2026-01-22 14:15:27','6c2e02fc-c934-482d-bdc9-0685eab3a289'),('2026-01-21 14:15:27.277089',NULL,'2026-01-21 14:15:27.299875',465,465,NULL,'a9e0d528-c82f-4e0a-ab60-c22ed5f660c1',143,'c55f56602b994198b2b9437533a437d7','gigabytes',1,'2026-01-22 14:15:27','6c2e02fc-c934-482d-bdc9-0685eab3a289'),('2026-01-21 14:15:29.436051',NULL,'2026-01-21 14:15:29.472017',466,466,'47292555c1b142f8967d2205628edba1','7e73f6d2-7ccf-41dc-971d-f6e78653eb48',120,'a226ad4df79b48a2b4c6ddc1ed2cb474','shares',1,'2026-01-22 14:15:29',NULL),('2026-01-21 14:15:29.437268',NULL,'2026-01-21 14:15:29.472017',467,467,'47292555c1b142f8967d2205628edba1','aa639ee1-605f-4be0-9e8b-0c03bed9eb2c',119,'a226ad4df79b48a2b4c6ddc1ed2cb474','gigabytes',1,'2026-01-22 14:15:29',NULL),('2026-01-21 14:15:29.442865',NULL,'2026-01-21 14:15:29.472017',468,468,NULL,'f3f30f05-547f-4f70-9105-e43f25e299a4',122,'a226ad4df79b48a2b4c6ddc1ed2cb474','shares',1,'2026-01-22 14:15:29','4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b'),('2026-01-21 14:15:29.444121',NULL,'2026-01-21 14:15:29.472017',469,469,NULL,'c220d60b-56ce-4596-93e5-0bfe54cf662d',121,'a226ad4df79b48a2b4c6ddc1ed2cb474','gigabytes',1,'2026-01-22 14:15:29','4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b'),('2026-01-21 14:15:31.223212',NULL,'2026-01-21 14:15:31.237200',470,470,'1582fd57caf04d9188d3b72ecfc4ddd8','7a01c6c2-0ba4-4a2b-a0de-e3db20a0abb9',111,'c55f56602b994198b2b9437533a437d7','shares',-1,'2026-01-22 14:15:31',NULL),('2026-01-21 14:15:31.224045',NULL,'2026-01-21 14:15:31.237200',471,471,'1582fd57caf04d9188d3b72ecfc4ddd8','d56809d4-c24f-457c-91dc-61838fbf9c00',112,'c55f56602b994198b2b9437533a437d7','gigabytes',-1,'2026-01-22 14:15:31',NULL),('2026-01-21 14:15:31.229309',NULL,'2026-01-21 14:15:31.237200',472,472,NULL,'a241af84-5981-424b-9975-13af08750cbd',144,'c55f56602b994198b2b9437533a437d7','shares',-1,'2026-01-22 14:15:31','6c2e02fc-c934-482d-bdc9-0685eab3a289'),('2026-01-21 14:15:31.229943',NULL,'2026-01-21 14:15:31.237200',473,473,NULL,'f0d6edf5-17af-4765-84f3-59e57b10d7ea',143,'c55f56602b994198b2b9437533a437d7','gigabytes',-1,'2026-01-22 14:15:31','6c2e02fc-c934-482d-bdc9-0685eab3a289'),('2026-01-21 14:15:36.917179',NULL,'2026-01-21 14:15:37.006695',474,474,'920083400adf4bf88354be8bd2e50ba1','3439a32d-a5aa-4ff8-8bdb-74309cfbb4c6',146,'7be9e3a0119b40f692133210ebe5f9a2','shares',1,'2026-01-22 14:15:36',NULL),('2026-01-21 14:15:36.918845',NULL,'2026-01-21 14:15:37.006695',475,475,'920083400adf4bf88354be8bd2e50ba1','b54a4d41-23e9-44fc-af2b-61aeaa2c1614',145,'7be9e3a0119b40f692133210ebe5f9a2','gigabytes',1,'2026-01-22 14:15:36',NULL),('2026-01-21 14:15:36.934275',NULL,'2026-01-21 14:15:37.006695',476,476,NULL,'a2192f52-4472-487e-8985-b234d49b501b',148,'7be9e3a0119b40f692133210ebe5f9a2','shares',1,'2026-01-22 14:15:36','6ee0f8f5-aa3a-4c92-817a-3d69c33b511e'),('2026-01-21 14:15:36.942525',NULL,'2026-01-21 14:15:37.006695',477,477,NULL,'23341b47-790c-48e2-b94f-52a060054525',147,'7be9e3a0119b40f692133210ebe5f9a2','gigabytes',1,'2026-01-22 14:15:36','6ee0f8f5-aa3a-4c92-817a-3d69c33b511e'),('2026-01-21 14:15:37.947553',NULL,'2026-01-21 14:15:37.987297',478,478,'47292555c1b142f8967d2205628edba1','dc3e5a07-8f58-4ce7-9502-3131e7f11d6c',120,'a226ad4df79b48a2b4c6ddc1ed2cb474','shares',-1,'2026-01-22 14:15:37',NULL),('2026-01-21 14:15:37.948789',NULL,'2026-01-21 14:15:37.987297',479,479,'47292555c1b142f8967d2205628edba1','247e855f-57b6-431e-b675-91774188bd45',119,'a226ad4df79b48a2b4c6ddc1ed2cb474','gigabytes',-1,'2026-01-22 14:15:37',NULL),('2026-01-21 14:15:37.973895',NULL,'2026-01-21 14:15:37.987297',480,480,NULL,'1481cd3f-2bde-4d42-b681-5e80fe58bb5c',122,'a226ad4df79b48a2b4c6ddc1ed2cb474','shares',-1,'2026-01-22 14:15:37','4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b'),('2026-01-21 14:15:37.975649',NULL,'2026-01-21 14:15:37.987297',481,481,NULL,'85f77c77-3712-4b90-ad9a-54fdb52b3227',121,'a226ad4df79b48a2b4c6ddc1ed2cb474','gigabytes',-1,'2026-01-22 14:15:37','4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b'),('2026-01-21 14:15:48.204789',NULL,'2026-01-21 14:15:48.357705',482,482,'293519a837134c9eb5c1064ac437ea0d','3aa7deb0-570b-49fe-90fd-c94c6c689046',149,'e564b97ee9594256ae7ad401e2e84d33','share_networks',1,'2026-01-22 14:15:48',NULL),('2026-01-21 14:15:48.526358',NULL,'2026-01-21 14:15:48.851111',483,483,'293519a837134c9eb5c1064ac437ea0d','6a517879-b5e3-4feb-b133-faef41e7ba94',149,'e564b97ee9594256ae7ad401e2e84d33','share_networks',1,'2026-01-22 14:15:48',NULL),('2026-01-21 14:15:49.284071',NULL,'2026-01-21 14:15:49.573400',484,484,'1d9340b6b4b74f75b34a2b5167cb11c9','2d146813-ed5d-430b-8875-a432ab81e129',151,'9706b90ceb3b46678324d74c1b285687','shares',1,'2026-01-22 14:15:49',NULL),('2026-01-21 14:15:49.285333',NULL,'2026-01-21 14:15:49.573400',485,485,'1d9340b6b4b74f75b34a2b5167cb11c9','fe8ed42c-6bb5-4269-852e-11def705f0a9',150,'9706b90ceb3b46678324d74c1b285687','gigabytes',1,'2026-01-22 14:15:49',NULL),('2026-01-21 14:15:49.491677',NULL,'2026-01-21 14:15:49.573400',486,486,NULL,'05129d22-6b41-42bc-ae9f-7a809a6030cf',153,'9706b90ceb3b46678324d74c1b285687','shares',1,'2026-01-22 14:15:49','d54caddb-c1a6-4c3f-b2f9-7d1717fa702a'),('2026-01-21 14:15:49.492892',NULL,'2026-01-21 14:15:49.573400',487,487,NULL,'1f76ad80-d2b2-49e4-b30d-344f1f13aaa8',152,'9706b90ceb3b46678324d74c1b285687','gigabytes',1,'2026-01-22 14:15:49','d54caddb-c1a6-4c3f-b2f9-7d1717fa702a'),('2026-01-21 14:15:50.102762',NULL,'2026-01-21 14:15:50.120892',488,488,'293519a837134c9eb5c1064ac437ea0d','b3e6c651-891a-4aae-adcb-71db4b428132',149,'e564b97ee9594256ae7ad401e2e84d33','share_networks',-1,'2026-01-22 14:15:50',NULL),('2026-01-21 14:15:50.402766',NULL,'2026-01-21 14:15:50.492338',489,489,'293519a837134c9eb5c1064ac437ea0d','b421f9b8-2e6f-4ef4-abae-313be7fa7730',149,'e564b97ee9594256ae7ad401e2e84d33','share_networks',1,'2026-01-22 14:15:50',NULL),('2026-01-21 14:15:51.413033',NULL,'2026-01-21 14:15:51.458877',490,490,'293519a837134c9eb5c1064ac437ea0d','554e4536-f194-4f99-ab09-e21df116ddad',149,'e564b97ee9594256ae7ad401e2e84d33','share_networks',-1,'2026-01-22 14:15:51',NULL),('2026-01-21 14:15:53.335699',NULL,'2026-01-21 14:15:53.370144',491,491,'90415a0f3d4e49cba79c941b229a5421','4b2cadab-7b6b-4377-ba2b-818de2babbd6',155,'4bd635a5dcc14e2b9d854dd0e78ecc0a','shares',1,'2026-01-22 14:15:53',NULL),('2026-01-21 14:15:53.336914',NULL,'2026-01-21 14:15:53.370144',492,492,'90415a0f3d4e49cba79c941b229a5421','09b1a807-dfc4-44f5-98a8-206c21f594b9',154,'4bd635a5dcc14e2b9d854dd0e78ecc0a','gigabytes',1,'2026-01-22 14:15:53',NULL),('2026-01-21 14:15:53.346162',NULL,'2026-01-21 14:15:53.370144',493,493,NULL,'5a247f39-72c5-4783-9785-c6877edeae0a',157,'4bd635a5dcc14e2b9d854dd0e78ecc0a','shares',1,'2026-01-22 14:15:53','d54caddb-c1a6-4c3f-b2f9-7d1717fa702a'),('2026-01-21 14:15:53.347324',NULL,'2026-01-21 14:15:53.370144',494,494,NULL,'381ee1b7-58cd-4ab2-817f-1e43c7bc697a',156,'4bd635a5dcc14e2b9d854dd0e78ecc0a','gigabytes',1,'2026-01-22 14:15:53','d54caddb-c1a6-4c3f-b2f9-7d1717fa702a'),('2026-01-21 14:15:57.418075',NULL,'2026-01-21 14:15:57.431042',495,495,'90415a0f3d4e49cba79c941b229a5421','7c3abfbe-aff4-4184-a03e-0e23c9a977fa',155,'4bd635a5dcc14e2b9d854dd0e78ecc0a','shares',-1,'2026-01-22 14:15:57',NULL),('2026-01-21 14:15:57.418775',NULL,'2026-01-21 14:15:57.431042',496,496,'90415a0f3d4e49cba79c941b229a5421','3c1624ab-38fc-4355-a5a4-a3c29b10432a',154,'4bd635a5dcc14e2b9d854dd0e78ecc0a','gigabytes',-1,'2026-01-22 14:15:57',NULL),('2026-01-21 14:15:57.423647',NULL,'2026-01-21 14:15:57.431042',497,497,NULL,'4ed5acf9-c0a2-4f01-bc3b-a6c75259ec93',157,'4bd635a5dcc14e2b9d854dd0e78ecc0a','shares',-1,'2026-01-22 14:15:57','d54caddb-c1a6-4c3f-b2f9-7d1717fa702a'),('2026-01-21 14:15:57.424385',NULL,'2026-01-21 14:15:57.431042',498,498,NULL,'1cf89ff5-3004-49b4-9a35-0dc7a3c990f0',156,'4bd635a5dcc14e2b9d854dd0e78ecc0a','gigabytes',-1,'2026-01-22 14:15:57','d54caddb-c1a6-4c3f-b2f9-7d1717fa702a'),('2026-01-21 14:15:59.920255',NULL,'2026-01-21 14:15:59.947462',499,499,'e98a65c358ff470b949414cd13a3245a','ee5626d4-889e-4469-8393-e24806c10594',158,'a7c6c7c42b5d4ca3933e833a80ca4f97','share_networks',1,'2026-01-22 14:15:59',NULL),('2026-01-21 14:16:00.223518',NULL,'2026-01-21 14:16:00.265089',500,500,'e98a65c358ff470b949414cd13a3245a','cd03f6d4-c738-4f25-96ae-db5f440ce778',158,'a7c6c7c42b5d4ca3933e833a80ca4f97','share_networks',1,'2026-01-22 14:16:00',NULL),('2026-01-21 14:16:00.473402',NULL,'2026-01-21 14:16:00.510289',501,501,'e98a65c358ff470b949414cd13a3245a','b34b6199-5eed-4a6b-8107-f3c4bf1b0ea7',158,'a7c6c7c42b5d4ca3933e833a80ca4f97','share_networks',1,'2026-01-22 14:16:00',NULL),('2026-01-21 14:16:00.685406',NULL,'2026-01-21 14:16:00.697771',502,502,'e98a65c358ff470b949414cd13a3245a','0e487759-548d-4237-ac4b-d2d496a5687a',158,'a7c6c7c42b5d4ca3933e833a80ca4f97','share_networks',-1,'2026-01-22 14:16:00',NULL),('2026-01-21 14:16:00.927585',NULL,'2026-01-21 14:16:00.953580',503,503,'1d9340b6b4b74f75b34a2b5167cb11c9','dffa6d53-9c4e-4288-a700-9705a3e85689',151,'9706b90ceb3b46678324d74c1b285687','shares',-1,'2026-01-22 14:16:00',NULL),('2026-01-21 14:16:00.928615',NULL,'2026-01-21 14:16:00.953580',504,504,'1d9340b6b4b74f75b34a2b5167cb11c9','d4c449c2-3e9b-4dc6-a0da-5fe30a3ce805',150,'9706b90ceb3b46678324d74c1b285687','gigabytes',-1,'2026-01-22 14:16:00',NULL),('2026-01-21 14:16:00.934916',NULL,'2026-01-21 14:16:00.953580',505,505,NULL,'10400818-3d6d-4b38-9adf-842011c25217',153,'9706b90ceb3b46678324d74c1b285687','shares',-1,'2026-01-22 14:16:00','d54caddb-c1a6-4c3f-b2f9-7d1717fa702a'),('2026-01-21 14:16:00.935672',NULL,'2026-01-21 14:16:00.953580',506,506,NULL,'7e393b9d-ea1d-4472-8c5e-99213ef00eef',152,'9706b90ceb3b46678324d74c1b285687','gigabytes',-1,'2026-01-22 14:16:00','d54caddb-c1a6-4c3f-b2f9-7d1717fa702a'),('2026-01-21 14:16:00.939163',NULL,'2026-01-21 14:16:00.981981',507,507,'e98a65c358ff470b949414cd13a3245a','8fe30bb5-5404-4fa1-81e5-12586cb03c5b',158,'a7c6c7c42b5d4ca3933e833a80ca4f97','share_networks',1,'2026-01-22 14:16:00',NULL),('2026-01-21 14:16:01.117460',NULL,'2026-01-21 14:16:01.165303',508,508,'e98a65c358ff470b949414cd13a3245a','34bdbe30-ac11-419a-b78a-ac54971f96b7',158,'a7c6c7c42b5d4ca3933e833a80ca4f97','share_networks',1,'2026-01-22 14:16:01',NULL),('2026-01-21 14:16:01.314895',NULL,'2026-01-21 14:16:01.322726',509,509,'e98a65c358ff470b949414cd13a3245a','2d434e3b-e56d-4d4b-b2d4-acd0a8a74896',158,'a7c6c7c42b5d4ca3933e833a80ca4f97','share_networks',-1,'2026-01-22 14:16:01',NULL),('2026-01-21 14:16:01.565164',NULL,'2026-01-21 14:16:01.573938',510,510,'e98a65c358ff470b949414cd13a3245a','7516c8dd-f985-49b9-bc39-ad60a5282725',158,'a7c6c7c42b5d4ca3933e833a80ca4f97','share_networks',-1,'2026-01-22 14:16:01',NULL),('2026-01-21 14:16:02.445785',NULL,'2026-01-21 14:16:03.102279',511,511,'e98a65c358ff470b949414cd13a3245a','0b56bbd8-2d5a-4a12-a17d-95fe32b3e3ac',158,'a7c6c7c42b5d4ca3933e833a80ca4f97','share_networks',1,'2026-01-22 14:16:02',NULL),('2026-01-21 14:16:03.340390',NULL,'2026-01-21 14:16:03.349637',512,512,'e98a65c358ff470b949414cd13a3245a','a18c9e48-2672-4e8f-bddc-473edcd512ec',158,'a7c6c7c42b5d4ca3933e833a80ca4f97','share_networks',-1,'2026-01-22 14:16:03',NULL),('2026-01-21 14:16:03.474245',NULL,'2026-01-21 14:16:03.528343',513,513,'e98a65c358ff470b949414cd13a3245a','9c4b9e75-5027-45c7-bbb7-e326847e53a2',158,'a7c6c7c42b5d4ca3933e833a80ca4f97','share_networks',1,'2026-01-22 14:16:03',NULL),('2026-01-21 14:16:03.736267',NULL,'2026-01-21 14:16:03.766744',514,514,'e98a65c358ff470b949414cd13a3245a','6e1e7fb0-acdc-4604-864c-85c307c11b7b',158,'a7c6c7c42b5d4ca3933e833a80ca4f97','share_networks',-1,'2026-01-22 14:16:03',NULL),('2026-01-21 14:16:04.231252',NULL,'2026-01-21 14:16:04.264499',515,515,'90415a0f3d4e49cba79c941b229a5421','bcc2c9d4-a196-4d58-8f8c-417ecf9ae909',155,'4bd635a5dcc14e2b9d854dd0e78ecc0a','shares',1,'2026-01-22 14:16:04',NULL),('2026-01-21 14:16:04.232483',NULL,'2026-01-21 14:16:04.264499',516,516,'90415a0f3d4e49cba79c941b229a5421','920b4aae-c47e-4b6a-ac55-a58f87a560af',154,'4bd635a5dcc14e2b9d854dd0e78ecc0a','gigabytes',1,'2026-01-22 14:16:04',NULL),('2026-01-21 14:16:04.239156',NULL,'2026-01-21 14:16:04.264499',517,517,NULL,'c4b8be3f-9fcf-4e7f-ad0c-8c056918961a',157,'4bd635a5dcc14e2b9d854dd0e78ecc0a','shares',1,'2026-01-22 14:16:04','d54caddb-c1a6-4c3f-b2f9-7d1717fa702a'),('2026-01-21 14:16:04.240207',NULL,'2026-01-21 14:16:04.264499',518,518,NULL,'3d5c4054-1af1-46bb-b05d-82b8a2150872',156,'4bd635a5dcc14e2b9d854dd0e78ecc0a','gigabytes',1,'2026-01-22 14:16:04','d54caddb-c1a6-4c3f-b2f9-7d1717fa702a'),('2026-01-21 14:16:05.248294',NULL,'2026-01-21 14:16:05.255092',519,519,'e98a65c358ff470b949414cd13a3245a','ba14462a-9dcf-4eba-8165-ad3e96abc85b',158,'a7c6c7c42b5d4ca3933e833a80ca4f97','share_networks',-1,'2026-01-22 14:16:05',NULL),('2026-01-21 14:16:05.524979',NULL,'2026-01-21 14:16:05.530583',520,520,'e98a65c358ff470b949414cd13a3245a','1b6d6d74-8e9e-4ebf-b804-0cfb7ae5353f',158,'a7c6c7c42b5d4ca3933e833a80ca4f97','share_networks',-1,'2026-01-22 14:16:05',NULL),('2026-01-21 14:16:08.711378',NULL,'2026-01-21 14:16:08.730231',521,521,'90415a0f3d4e49cba79c941b229a5421','045903cd-efb0-409a-884b-7340987a9bc6',155,'4bd635a5dcc14e2b9d854dd0e78ecc0a','shares',-1,'2026-01-22 14:16:08',NULL),('2026-01-21 14:16:08.712582',NULL,'2026-01-21 14:16:08.730231',522,522,'90415a0f3d4e49cba79c941b229a5421','e52c293b-5eeb-4fae-ab50-1b9753f47648',154,'4bd635a5dcc14e2b9d854dd0e78ecc0a','gigabytes',-1,'2026-01-22 14:16:08',NULL),('2026-01-21 14:16:08.720287',NULL,'2026-01-21 14:16:08.730231',523,523,NULL,'51b0a0f0-ba7c-46f2-a74a-d4e5d813a780',157,'4bd635a5dcc14e2b9d854dd0e78ecc0a','shares',-1,'2026-01-22 14:16:08','d54caddb-c1a6-4c3f-b2f9-7d1717fa702a'),('2026-01-21 14:16:08.721192',NULL,'2026-01-21 14:16:08.730231',524,524,NULL,'61d676a1-7c03-4888-8ebe-59e68bee9014',156,'4bd635a5dcc14e2b9d854dd0e78ecc0a','gigabytes',-1,'2026-01-22 14:16:08','d54caddb-c1a6-4c3f-b2f9-7d1717fa702a'),('2026-01-21 14:16:12.224464',NULL,'2026-01-21 14:16:12.244862',525,525,'47292555c1b142f8967d2205628edba1','b8fc4f12-6f67-4ab8-9161-919ca1d53d8b',120,'a226ad4df79b48a2b4c6ddc1ed2cb474','shares',-1,'2026-01-22 14:16:12',NULL),('2026-01-21 14:16:12.227373',NULL,'2026-01-21 14:16:12.244862',526,526,'47292555c1b142f8967d2205628edba1','01e6e804-bcae-490c-b925-ace7c05cf891',119,'a226ad4df79b48a2b4c6ddc1ed2cb474','gigabytes',-1,'2026-01-22 14:16:12',NULL),('2026-01-21 14:16:12.234177',NULL,'2026-01-21 14:16:12.244862',527,527,NULL,'dde211ba-4a98-44c8-ad88-54a9db2c2f24',122,'a226ad4df79b48a2b4c6ddc1ed2cb474','shares',-1,'2026-01-22 14:16:12','4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b'),('2026-01-21 14:16:12.235013',NULL,'2026-01-21 14:16:12.244862',528,528,NULL,'8fefb9b9-6e5b-4c6c-a939-c550815aa86e',121,'a226ad4df79b48a2b4c6ddc1ed2cb474','gigabytes',-1,'2026-01-22 14:16:12','4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b'),('2026-01-21 14:16:18.934542',NULL,'2026-01-21 14:16:19.185571',529,529,'9a2f0c528668499db7c5fb089f64e301','9f9bb921-3a80-4434-b0c2-678b0590b0ee',160,'12f72ef945cc4adbb18b25d146f29e19','shares',1,'2026-01-22 14:16:18',NULL),('2026-01-21 14:16:18.935795',NULL,'2026-01-21 14:16:19.185571',530,530,'9a2f0c528668499db7c5fb089f64e301','f06d2195-9079-4206-a9af-ac7787caa3a9',159,'12f72ef945cc4adbb18b25d146f29e19','gigabytes',1,'2026-01-22 14:16:18',NULL),('2026-01-21 14:16:19.002298',NULL,'2026-01-21 14:16:19.185571',531,531,NULL,'179de843-1972-42ad-ae9a-b3c6150f91f1',162,'12f72ef945cc4adbb18b25d146f29e19','shares',1,'2026-01-22 14:16:18','24dda13d-d1e8-43b2-948e-8336430d5aff'),('2026-01-21 14:16:19.003523',NULL,'2026-01-21 14:16:19.185571',532,532,NULL,'c5586b98-40a2-4f37-a157-b4a6a89c093b',161,'12f72ef945cc4adbb18b25d146f29e19','gigabytes',1,'2026-01-22 14:16:18','24dda13d-d1e8-43b2-948e-8336430d5aff'),('2026-01-21 14:16:23.297929',NULL,'2026-01-21 14:16:23.386898',533,533,'9a2f0c528668499db7c5fb089f64e301','6b0c69bc-508b-4a54-80b5-f32c43deae87',164,'12f72ef945cc4adbb18b25d146f29e19','snapshots',1,'2026-01-22 14:16:23',NULL),('2026-01-21 14:16:23.299557',NULL,'2026-01-21 14:16:23.386898',534,534,'9a2f0c528668499db7c5fb089f64e301','63e245b5-0d14-4f68-bac2-0d5aed620f91',163,'12f72ef945cc4adbb18b25d146f29e19','snapshot_gigabytes',1,'2026-01-22 14:16:23',NULL),('2026-01-21 14:16:23.310568',NULL,'2026-01-21 14:16:23.386898',535,535,NULL,'5a53023b-3e05-45e4-8355-e6f12ddb1839',166,'12f72ef945cc4adbb18b25d146f29e19','snapshots',1,'2026-01-22 14:16:23','24dda13d-d1e8-43b2-948e-8336430d5aff'),('2026-01-21 14:16:23.312021',NULL,'2026-01-21 14:16:23.386898',536,536,NULL,'b8e0ef98-a72a-4482-86e4-0eb607f61476',165,'12f72ef945cc4adbb18b25d146f29e19','snapshot_gigabytes',1,'2026-01-22 14:16:23','24dda13d-d1e8-43b2-948e-8336430d5aff'),('2026-01-21 14:16:27.192749',NULL,'2026-01-21 14:16:27.267821',537,537,'9618fae463a3456ab00f4dd42464d5b5','1a53c1ff-38c7-43ce-b15d-07836a08b477',167,'00ad6a9aaa7a46e98273aa36df95068c','shares',1,'2026-01-22 14:16:27',NULL),('2026-01-21 14:16:27.194051',NULL,'2026-01-21 14:16:27.267821',538,538,'9618fae463a3456ab00f4dd42464d5b5','b12d96a7-d665-4e29-99ec-cad3f528dab6',168,'00ad6a9aaa7a46e98273aa36df95068c','gigabytes',1,'2026-01-22 14:16:27',NULL),('2026-01-21 14:16:27.203948',NULL,'2026-01-21 14:16:27.267821',539,539,NULL,'08dcbce6-4fe0-4584-b4bc-aed96a9d43fe',169,'00ad6a9aaa7a46e98273aa36df95068c','shares',1,'2026-01-22 14:16:27','06f3f214-12da-4ea9-a206-446558478b75'),('2026-01-21 14:16:27.205130',NULL,'2026-01-21 14:16:27.267821',540,540,NULL,'6e648f52-52b8-4fd2-a591-6b6879f7c6af',170,'00ad6a9aaa7a46e98273aa36df95068c','gigabytes',1,'2026-01-22 14:16:27','06f3f214-12da-4ea9-a206-446558478b75'),('2026-01-21 14:16:27.453699',NULL,'2026-01-21 14:16:27.487614',541,541,'9a2f0c528668499db7c5fb089f64e301','e5dbf811-af54-4eb9-bb7f-31f17e187943',164,'12f72ef945cc4adbb18b25d146f29e19','snapshots',-1,'2026-01-22 14:16:27',NULL),('2026-01-21 14:16:27.455660',NULL,'2026-01-21 14:16:27.487614',542,542,'9a2f0c528668499db7c5fb089f64e301','52587894-5494-450e-8e87-583ec83c2277',163,'12f72ef945cc4adbb18b25d146f29e19','snapshot_gigabytes',-1,'2026-01-22 14:16:27',NULL),('2026-01-21 14:16:27.470426',NULL,'2026-01-21 14:16:27.487614',543,543,NULL,'1867d5e9-1116-4795-8f30-a4b50ddd64b4',166,'12f72ef945cc4adbb18b25d146f29e19','snapshots',-1,'2026-01-22 14:16:27','24dda13d-d1e8-43b2-948e-8336430d5aff'),('2026-01-21 14:16:27.471521',NULL,'2026-01-21 14:16:27.487614',544,544,NULL,'81171dad-3db6-4b80-8e94-2df3b7eb748e',165,'12f72ef945cc4adbb18b25d146f29e19','snapshot_gigabytes',-1,'2026-01-22 14:16:27','24dda13d-d1e8-43b2-948e-8336430d5aff'),('2026-01-21 14:16:34.656150',NULL,'2026-01-21 14:16:35.775047',545,545,'9a2f0c528668499db7c5fb089f64e301','8036d07e-d3c2-4b6f-987b-4495f5286bea',160,'12f72ef945cc4adbb18b25d146f29e19','shares',-1,'2026-01-22 14:16:34',NULL),('2026-01-21 14:16:34.657022',NULL,'2026-01-21 14:16:35.775047',546,546,'9a2f0c528668499db7c5fb089f64e301','aa035a8a-15c0-48f9-85fb-4aceac974af7',159,'12f72ef945cc4adbb18b25d146f29e19','gigabytes',-1,'2026-01-22 14:16:34',NULL),('2026-01-21 14:16:34.998619',NULL,'2026-01-21 14:16:35.775047',547,547,NULL,'f35b0fd3-37a2-45c8-aeae-3749c070770b',162,'12f72ef945cc4adbb18b25d146f29e19','shares',-1,'2026-01-22 14:16:34','24dda13d-d1e8-43b2-948e-8336430d5aff'),('2026-01-21 14:16:35.000166',NULL,'2026-01-21 14:16:35.775047',548,548,NULL,'8cc5a4da-28f4-4cee-b943-8aeaa215b44e',161,'12f72ef945cc4adbb18b25d146f29e19','gigabytes',-1,'2026-01-22 14:16:34','24dda13d-d1e8-43b2-948e-8336430d5aff'),('2026-01-21 14:16:36.401787',NULL,'2026-01-21 14:16:36.720064',549,549,'9618fae463a3456ab00f4dd42464d5b5','6734cf3c-2d06-434c-9ade-d7ede4526d4b',167,'00ad6a9aaa7a46e98273aa36df95068c','shares',-1,'2026-01-22 14:16:36',NULL),('2026-01-21 14:16:36.402993',NULL,'2026-01-21 14:16:36.720064',550,550,'9618fae463a3456ab00f4dd42464d5b5','ddd2d80b-002d-4ef6-ad91-361776a27664',168,'00ad6a9aaa7a46e98273aa36df95068c','gigabytes',-1,'2026-01-22 14:16:36',NULL),('2026-01-21 14:16:36.642146',NULL,'2026-01-21 14:16:36.720064',551,551,NULL,'5e795488-e688-4567-986c-3e0e17cd77e3',169,'00ad6a9aaa7a46e98273aa36df95068c','shares',-1,'2026-01-22 14:16:36','06f3f214-12da-4ea9-a206-446558478b75'),('2026-01-21 14:16:36.643671',NULL,'2026-01-21 14:16:36.720064',552,552,NULL,'9c0735cb-3b4c-4585-89b8-604e31fbe5ed',170,'00ad6a9aaa7a46e98273aa36df95068c','gigabytes',-1,'2026-01-22 14:16:36','06f3f214-12da-4ea9-a206-446558478b75'),('2026-01-21 14:16:37.423214',NULL,'2026-01-21 14:16:37.651308',553,553,'c9132702f2324cf7b8026c09a5d89dee','f4ddb29a-69d4-4671-b02c-19b77b552103',171,'183d8c03d481485397037ffe17a60995','shares',1,'2026-01-22 14:16:37',NULL),('2026-01-21 14:16:37.571163',NULL,'2026-01-21 14:16:37.651308',554,554,'c9132702f2324cf7b8026c09a5d89dee','d3f34354-0d87-418d-baa8-02780bb513bb',172,'183d8c03d481485397037ffe17a60995','gigabytes',1,'2026-01-22 14:16:37',NULL),('2026-01-21 14:16:37.615143',NULL,'2026-01-21 14:16:37.651308',555,555,NULL,'c54e157c-db28-4f9f-ae73-049616c17285',173,'183d8c03d481485397037ffe17a60995','shares',1,'2026-01-22 14:16:37','e930702d-a3b3-40a2-9f70-64fa8134ddf6'),('2026-01-21 14:16:37.616563',NULL,'2026-01-21 14:16:37.651308',556,556,NULL,'7484411a-efaa-4cb1-b554-9d27f8d3471b',174,'183d8c03d481485397037ffe17a60995','gigabytes',1,'2026-01-22 14:16:37','e930702d-a3b3-40a2-9f70-64fa8134ddf6'),('2026-01-21 14:16:38.566935',NULL,'2026-01-21 14:16:38.928126',557,557,'9a2f0c528668499db7c5fb089f64e301','579f061b-bfeb-4466-88a6-6c238f92e14c',160,'12f72ef945cc4adbb18b25d146f29e19','shares',1,'2026-01-22 14:16:38',NULL),('2026-01-21 14:16:38.569184',NULL,'2026-01-21 14:16:38.928126',558,558,'9a2f0c528668499db7c5fb089f64e301','437a42f4-b683-4d11-92a1-5c02181f85fc',159,'12f72ef945cc4adbb18b25d146f29e19','gigabytes',1,'2026-01-22 14:16:38',NULL),('2026-01-21 14:16:38.687307',NULL,'2026-01-21 14:16:38.928126',559,559,NULL,'9c8169a6-1caf-4fe0-896b-8a7df7aa0491',175,'12f72ef945cc4adbb18b25d146f29e19','shares',1,'2026-01-22 14:16:38','ddce9437-41f6-41e1-9345-e8f73447a2bc'),('2026-01-21 14:16:38.688825',NULL,'2026-01-21 14:16:38.928126',560,560,NULL,'7bce66e8-75f8-4a33-960b-12d7195f972b',176,'12f72ef945cc4adbb18b25d146f29e19','gigabytes',1,'2026-01-22 14:16:38','ddce9437-41f6-41e1-9345-e8f73447a2bc'),('2026-01-21 14:16:41.788786',NULL,'2026-01-21 14:16:42.321654',561,561,'c9132702f2324cf7b8026c09a5d89dee','63dd530b-7b8a-4059-837b-271646cb70f5',171,'183d8c03d481485397037ffe17a60995','shares',1,'2026-01-22 14:16:41',NULL),('2026-01-21 14:16:41.790046',NULL,'2026-01-21 14:16:42.321654',562,562,'c9132702f2324cf7b8026c09a5d89dee','97f6af7a-267f-4fed-bc91-9e71062756a2',172,'183d8c03d481485397037ffe17a60995','gigabytes',1,'2026-01-22 14:16:41',NULL),('2026-01-21 14:16:42.250932',NULL,'2026-01-21 14:16:42.321654',563,563,NULL,'c09ce584-1310-4b46-bed9-295ddbc9ffdd',178,'183d8c03d481485397037ffe17a60995','shares',1,'2026-01-22 14:16:41','b162a983-fd22-416d-b3c5-874636612a2e'),('2026-01-21 14:16:42.252830',NULL,'2026-01-21 14:16:42.321654',564,564,NULL,'a5ee8af4-79e4-4219-99bc-cfeb6f93673d',177,'183d8c03d481485397037ffe17a60995','gigabytes',1,'2026-01-22 14:16:41','b162a983-fd22-416d-b3c5-874636612a2e'),('2026-01-21 14:16:43.364123',NULL,'2026-01-21 14:16:43.382538',565,565,'9a2f0c528668499db7c5fb089f64e301','9d59693f-c6b9-4c3f-b97e-f242fda2bcbe',160,'12f72ef945cc4adbb18b25d146f29e19','shares',-1,'2026-01-22 14:16:43',NULL),('2026-01-21 14:16:43.364936',NULL,'2026-01-21 14:16:43.382538',566,566,'9a2f0c528668499db7c5fb089f64e301','489592b6-41e4-48a5-9c77-ddfe8ded4a23',159,'12f72ef945cc4adbb18b25d146f29e19','gigabytes',-1,'2026-01-22 14:16:43',NULL),('2026-01-21 14:16:43.373557',NULL,'2026-01-21 14:16:43.382538',567,567,NULL,'71f598bd-daf5-49cd-949e-4683f3bd4fca',175,'12f72ef945cc4adbb18b25d146f29e19','shares',-1,'2026-01-22 14:16:43','ddce9437-41f6-41e1-9345-e8f73447a2bc'),('2026-01-21 14:16:43.374340',NULL,'2026-01-21 14:16:43.382538',568,568,NULL,'f314eb28-1b88-439b-8d53-2e7df8e97ee7',176,'12f72ef945cc4adbb18b25d146f29e19','gigabytes',-1,'2026-01-22 14:16:43','ddce9437-41f6-41e1-9345-e8f73447a2bc'),('2026-01-21 14:16:46.810083',NULL,'2026-01-21 14:16:46.941851',569,569,'9a2f0c528668499db7c5fb089f64e301','e99e98e0-4f59-4ae7-9475-09d09b4a5401',160,'12f72ef945cc4adbb18b25d146f29e19','shares',1,'2026-01-22 14:16:46',NULL),('2026-01-21 14:16:46.811430',NULL,'2026-01-21 14:16:46.941851',570,570,'9a2f0c528668499db7c5fb089f64e301','7aa9b361-6ca9-4df8-ba48-ad42bd35a087',159,'12f72ef945cc4adbb18b25d146f29e19','gigabytes',1,'2026-01-22 14:16:46',NULL),('2026-01-21 14:16:46.832637',NULL,'2026-01-21 14:16:46.941851',571,571,NULL,'13b1519c-ee96-4524-9fa1-7cecb61ce7df',180,'12f72ef945cc4adbb18b25d146f29e19','shares',1,'2026-01-22 14:16:46','3ded9bac-2fe5-4f42-8fae-b77fb1f40041'),('2026-01-21 14:16:46.833746',NULL,'2026-01-21 14:16:46.941851',572,572,NULL,'75c0e820-ba84-4508-9aac-86bd551bbed8',179,'12f72ef945cc4adbb18b25d146f29e19','gigabytes',1,'2026-01-22 14:16:46','3ded9bac-2fe5-4f42-8fae-b77fb1f40041'),('2026-01-21 14:16:50.227536',NULL,'2026-01-21 14:16:51.921419',573,573,'53e1b03c59294270a311e7426f54bef6','64931790-bc83-4aab-aa02-22a2f4ad087e',182,'6b53653c238d45b18082508e065d099c','shares',1,'2026-01-22 14:16:50',NULL),('2026-01-21 14:16:50.228874',NULL,'2026-01-21 14:16:51.921419',574,574,'53e1b03c59294270a311e7426f54bef6','6380562e-782e-45e3-bbac-ada44f014785',181,'6b53653c238d45b18082508e065d099c','gigabytes',1,'2026-01-22 14:16:50',NULL),('2026-01-21 14:16:50.387840',NULL,'2026-01-21 14:16:52.041684',575,575,'9a2f0c528668499db7c5fb089f64e301','d3786437-2ef1-42fb-b035-43d58c7f1d61',164,'12f72ef945cc4adbb18b25d146f29e19','snapshots',1,'2026-01-22 14:16:50',NULL),('2026-01-21 14:16:50.389225',NULL,'2026-01-21 14:16:52.041684',576,576,'9a2f0c528668499db7c5fb089f64e301','4ee2256a-c130-404c-a3ed-44df980c09f3',163,'12f72ef945cc4adbb18b25d146f29e19','snapshot_gigabytes',1,'2026-01-22 14:16:50',NULL),('2026-01-21 14:16:50.710869',NULL,'2026-01-21 14:16:51.921419',577,577,NULL,'e2bdee9a-1b31-4cbc-8f4f-7b70302e5698',184,'6b53653c238d45b18082508e065d099c','shares',1,'2026-01-22 14:16:50','b162a983-fd22-416d-b3c5-874636612a2e'),('2026-01-21 14:16:50.712764',NULL,'2026-01-21 14:16:51.921419',578,578,NULL,'1bdff8d1-cf42-4304-a995-80872e460723',183,'6b53653c238d45b18082508e065d099c','gigabytes',1,'2026-01-22 14:16:50','b162a983-fd22-416d-b3c5-874636612a2e'),('2026-01-21 14:16:51.890424',NULL,'2026-01-21 14:16:52.041684',579,579,NULL,'12c8142a-ecc4-49dd-93c3-70ce2c272f5e',186,'12f72ef945cc4adbb18b25d146f29e19','snapshots',1,'2026-01-22 14:16:50','3ded9bac-2fe5-4f42-8fae-b77fb1f40041'),('2026-01-21 14:16:51.891814',NULL,'2026-01-21 14:16:52.041684',580,580,NULL,'631659b0-10ff-4977-9433-edc35cb7973c',185,'12f72ef945cc4adbb18b25d146f29e19','snapshot_gigabytes',1,'2026-01-22 14:16:50','3ded9bac-2fe5-4f42-8fae-b77fb1f40041'),('2026-01-21 14:16:53.528807',NULL,'2026-01-21 14:16:53.586180',581,581,'1e36f40dbb4a41dfa0a09d53e38a09a3','e49182a0-c997-4f42-9257-69d1a8ecf68d',187,'78145dbf5c284a599c7efda43d8f4201','share_networks',1,'2026-01-22 14:16:53',NULL),('2026-01-21 14:16:55.755426',NULL,'2026-01-21 14:16:55.858637',582,582,'9a2f0c528668499db7c5fb089f64e301','f746e904-52ce-4a33-a6e1-bec56bdfd810',160,'12f72ef945cc4adbb18b25d146f29e19','shares',1,'2026-01-22 14:16:55',NULL),('2026-01-21 14:16:55.757024',NULL,'2026-01-21 14:16:55.858637',583,583,'9a2f0c528668499db7c5fb089f64e301','1689fb95-8032-4643-975b-0bb3974e907c',159,'12f72ef945cc4adbb18b25d146f29e19','gigabytes',1,'2026-01-22 14:16:55',NULL),('2026-01-21 14:16:55.829946',NULL,'2026-01-21 14:16:55.858637',584,584,NULL,'342a35e0-79bf-4e33-bdf6-1e6f9a9016b3',180,'12f72ef945cc4adbb18b25d146f29e19','shares',1,'2026-01-22 14:16:55','3ded9bac-2fe5-4f42-8fae-b77fb1f40041'),('2026-01-21 14:16:55.831392',NULL,'2026-01-21 14:16:55.858637',585,585,NULL,'f378b8c7-8744-49c5-bea1-7a2ae131998d',179,'12f72ef945cc4adbb18b25d146f29e19','gigabytes',1,'2026-01-22 14:16:55','3ded9bac-2fe5-4f42-8fae-b77fb1f40041'),('2026-01-21 14:17:08.152569',NULL,'2026-01-21 14:17:08.200720',586,586,'6cb2e0df2e5e4f68acb0a95b2439997b','8fe732bb-4536-4d90-bd06-10a314a3cf5e',189,'e5bede18d60e4bb389fabc44847d9a1a','shares',1,'2026-01-22 14:17:08',NULL),('2026-01-21 14:17:08.153978',NULL,'2026-01-21 14:17:08.200720',587,587,'6cb2e0df2e5e4f68acb0a95b2439997b','bb9f5640-15b6-46f9-9b20-3da12b54b279',188,'e5bede18d60e4bb389fabc44847d9a1a','gigabytes',1,'2026-01-22 14:17:08',NULL),('2026-01-21 14:17:08.166952',NULL,'2026-01-21 14:17:08.200720',588,588,NULL,'05a83523-9f5e-4a72-b122-34b0124b7042',191,'e5bede18d60e4bb389fabc44847d9a1a','shares',1,'2026-01-22 14:17:08','a35627cc-f912-49fe-a347-ce5ebde9e5e7'),('2026-01-21 14:17:08.169607',NULL,'2026-01-21 14:17:08.200720',589,589,NULL,'b521d14b-b955-470e-adb9-8687db931e12',190,'e5bede18d60e4bb389fabc44847d9a1a','gigabytes',1,'2026-01-22 14:17:08','a35627cc-f912-49fe-a347-ce5ebde9e5e7'),('2026-01-21 14:17:09.879859',NULL,'2026-01-21 14:17:09.936927',590,590,'9a2f0c528668499db7c5fb089f64e301','6696d266-5cad-4b27-bf56-c340b9e591b4',160,'12f72ef945cc4adbb18b25d146f29e19','shares',-1,'2026-01-22 14:17:09',NULL),('2026-01-21 14:17:09.880658',NULL,'2026-01-21 14:17:09.936927',591,591,'9a2f0c528668499db7c5fb089f64e301','b366b8db-1987-4bcf-abac-b6157abe55eb',159,'12f72ef945cc4adbb18b25d146f29e19','gigabytes',-1,'2026-01-22 14:17:09',NULL),('2026-01-21 14:17:09.900080',NULL,'2026-01-21 14:17:09.936927',592,592,NULL,'1244b10b-c02f-4e5c-8972-c5bff2604986',180,'12f72ef945cc4adbb18b25d146f29e19','shares',-1,'2026-01-22 14:17:09','3ded9bac-2fe5-4f42-8fae-b77fb1f40041'),('2026-01-21 14:17:09.900783',NULL,'2026-01-21 14:17:09.936927',593,593,NULL,'6fe8e634-10ee-4272-bdc1-8a425e211dd2',179,'12f72ef945cc4adbb18b25d146f29e19','gigabytes',-1,'2026-01-22 14:17:09','3ded9bac-2fe5-4f42-8fae-b77fb1f40041'),('2026-01-21 14:17:11.782827',NULL,'2026-01-21 14:17:12.132077',594,594,'14b1b7ca69c94906ab006f47db3af123','edcc2592-25bf-401b-ac5d-18e1dc9086bd',193,'3fdd89fc56bc4e1e80efe02dccfd1c88','shares',1,'2026-01-22 14:17:11',NULL),('2026-01-21 14:17:11.784526',NULL,'2026-01-21 14:17:12.132077',595,595,'14b1b7ca69c94906ab006f47db3af123','beeab306-30ab-4c98-ae31-2a8bcbe76b84',192,'3fdd89fc56bc4e1e80efe02dccfd1c88','gigabytes',1,'2026-01-22 14:17:11',NULL),('2026-01-21 14:17:11.811550',NULL,'2026-01-21 14:17:12.147170',596,596,'14b1b7ca69c94906ab006f47db3af123','b40a12ab-a57c-4d89-930c-bd09f2e62269',195,'e5bede18d60e4bb389fabc44847d9a1a','shares',-1,'2026-01-22 14:17:11',NULL),('2026-01-21 14:17:11.812393',NULL,'2026-01-21 14:17:12.147170',597,597,'14b1b7ca69c94906ab006f47db3af123','4707b325-2e0a-4a8d-abf0-1bee026a5382',194,'e5bede18d60e4bb389fabc44847d9a1a','gigabytes',-1,'2026-01-22 14:17:11',NULL),('2026-01-21 14:17:12.703028',NULL,'2026-01-21 14:17:12.731443',598,598,'14b1b7ca69c94906ab006f47db3af123','513d7c2b-4ad9-4119-ad3f-0f81048fdcc0',193,'3fdd89fc56bc4e1e80efe02dccfd1c88','shares',-1,'2026-01-22 14:17:12',NULL),('2026-01-21 14:17:12.704005',NULL,'2026-01-21 14:17:12.731443',599,599,'14b1b7ca69c94906ab006f47db3af123','ebd3196b-c720-42b9-84e2-9661999a22b8',192,'3fdd89fc56bc4e1e80efe02dccfd1c88','gigabytes',-1,'2026-01-22 14:17:12',NULL),('2026-01-21 14:17:12.720861',NULL,'2026-01-21 14:17:12.731443',600,600,NULL,'46c9fb19-33b6-4ea3-853c-5b0fbf73e27d',196,'3fdd89fc56bc4e1e80efe02dccfd1c88','shares',-1,'2026-01-22 14:17:12','a35627cc-f912-49fe-a347-ce5ebde9e5e7'),('2026-01-21 14:17:12.721710',NULL,'2026-01-21 14:17:12.731443',601,601,NULL,'2374126b-4507-450e-80e9-c8f26cb6fc18',197,'3fdd89fc56bc4e1e80efe02dccfd1c88','gigabytes',-1,'2026-01-22 14:17:12','a35627cc-f912-49fe-a347-ce5ebde9e5e7'),('2026-01-21 14:17:13.203011',NULL,'2026-01-21 14:17:13.230824',602,602,'9a2f0c528668499db7c5fb089f64e301','5213ec7e-61d2-484a-959c-799442ac8e73',164,'12f72ef945cc4adbb18b25d146f29e19','snapshots',-1,'2026-01-22 14:17:13',NULL),('2026-01-21 14:17:13.204161',NULL,'2026-01-21 14:17:13.230824',603,603,'9a2f0c528668499db7c5fb089f64e301','96bb9175-9e78-4a15-a157-65539f6f17da',163,'12f72ef945cc4adbb18b25d146f29e19','snapshot_gigabytes',-1,'2026-01-22 14:17:13',NULL),('2026-01-21 14:17:13.211595',NULL,'2026-01-21 14:17:13.230824',604,604,NULL,'dd96e75a-86a9-4b1a-8ccc-6e93fa26e427',186,'12f72ef945cc4adbb18b25d146f29e19','snapshots',-1,'2026-01-22 14:17:13','3ded9bac-2fe5-4f42-8fae-b77fb1f40041'),('2026-01-21 14:17:13.212388',NULL,'2026-01-21 14:17:13.230824',605,605,NULL,'37571473-9e69-4a87-9444-bdb8f40a5ecd',185,'12f72ef945cc4adbb18b25d146f29e19','snapshot_gigabytes',-1,'2026-01-22 14:17:13','3ded9bac-2fe5-4f42-8fae-b77fb1f40041'),('2026-01-21 14:17:15.800587',NULL,'2026-01-21 14:17:15.841018',606,606,'6cb2e0df2e5e4f68acb0a95b2439997b','04cd0454-c8cc-492c-b1a1-8064468eeb3f',189,'e5bede18d60e4bb389fabc44847d9a1a','shares',1,'2026-01-22 14:17:15',NULL),('2026-01-21 14:17:15.802215',NULL,'2026-01-21 14:17:15.841018',607,607,'6cb2e0df2e5e4f68acb0a95b2439997b','a56db375-ae35-4e5c-94a3-da65c57a258d',188,'e5bede18d60e4bb389fabc44847d9a1a','gigabytes',1,'2026-01-22 14:17:15',NULL),('2026-01-21 14:17:15.818383',NULL,'2026-01-21 14:17:15.841018',608,608,NULL,'a9309ad2-2364-4e66-8205-bba5b4ece359',191,'e5bede18d60e4bb389fabc44847d9a1a','shares',1,'2026-01-22 14:17:15','a35627cc-f912-49fe-a347-ce5ebde9e5e7'),('2026-01-21 14:17:15.819695',NULL,'2026-01-21 14:17:15.841018',609,609,NULL,'b9e45933-50ad-4384-a63f-fb816a59c980',190,'e5bede18d60e4bb389fabc44847d9a1a','gigabytes',1,'2026-01-22 14:17:15','a35627cc-f912-49fe-a347-ce5ebde9e5e7'),('2026-01-21 14:17:16.802442',NULL,'2026-01-21 14:17:16.850675',610,610,'9a2f0c528668499db7c5fb089f64e301','f93251bc-bf6b-4615-b6aa-0ece6578bd2f',160,'12f72ef945cc4adbb18b25d146f29e19','shares',-1,'2026-01-22 14:17:16',NULL),('2026-01-21 14:17:16.803526',NULL,'2026-01-21 14:17:16.850675',611,611,'9a2f0c528668499db7c5fb089f64e301','9910b200-c919-4b39-98e9-9556eb794711',159,'12f72ef945cc4adbb18b25d146f29e19','gigabytes',-1,'2026-01-22 14:17:16',NULL),('2026-01-21 14:17:16.829085',NULL,'2026-01-21 14:17:16.850675',612,612,NULL,'a777d66c-22e6-4f25-b73b-349d8ff4dd89',180,'12f72ef945cc4adbb18b25d146f29e19','shares',-1,'2026-01-22 14:17:16','3ded9bac-2fe5-4f42-8fae-b77fb1f40041'),('2026-01-21 14:17:16.830054',NULL,'2026-01-21 14:17:16.850675',613,613,NULL,'a7d014a4-bf15-417e-8e2b-abf0d198a6be',179,'12f72ef945cc4adbb18b25d146f29e19','gigabytes',-1,'2026-01-22 14:17:16','3ded9bac-2fe5-4f42-8fae-b77fb1f40041'),('2026-01-21 14:17:20.032024',NULL,'2026-01-21 14:17:20.054471',614,614,'6cb2e0df2e5e4f68acb0a95b2439997b','5787328e-1926-4e11-8174-2581a6aa35ca',189,'e5bede18d60e4bb389fabc44847d9a1a','shares',-1,'2026-01-22 14:17:20',NULL),('2026-01-21 14:17:20.032738',NULL,'2026-01-21 14:17:20.054471',615,615,'6cb2e0df2e5e4f68acb0a95b2439997b','bf4e2f10-9724-48da-a8d8-f0b2254ae3f7',188,'e5bede18d60e4bb389fabc44847d9a1a','gigabytes',-1,'2026-01-22 14:17:20',NULL),('2026-01-21 14:17:20.041347',NULL,'2026-01-21 14:17:20.054471',616,616,NULL,'c5a0becf-921a-4b42-a07e-0ff34681bb08',191,'e5bede18d60e4bb389fabc44847d9a1a','shares',-1,'2026-01-22 14:17:20','a35627cc-f912-49fe-a347-ce5ebde9e5e7'),('2026-01-21 14:17:20.042450',NULL,'2026-01-21 14:17:20.054471',617,617,NULL,'d8902e37-d808-42ed-8f24-d4c290b15a27',190,'e5bede18d60e4bb389fabc44847d9a1a','gigabytes',-1,'2026-01-22 14:17:20','a35627cc-f912-49fe-a347-ce5ebde9e5e7'),('2026-01-21 14:17:22.109000',NULL,'2026-01-21 14:17:22.242341',618,618,'53e1b03c59294270a311e7426f54bef6','a420c8a7-62a9-4886-8dd4-ad9cac1c809a',182,'6b53653c238d45b18082508e065d099c','shares',1,'2026-01-22 14:17:22',NULL),('2026-01-21 14:17:22.110405',NULL,'2026-01-21 14:17:22.242341',619,619,'53e1b03c59294270a311e7426f54bef6','98d65d16-c617-418a-baf8-d6c46d9a149c',181,'6b53653c238d45b18082508e065d099c','gigabytes',1,'2026-01-22 14:17:22',NULL),('2026-01-21 14:17:22.151028',NULL,'2026-01-21 14:17:22.242341',620,620,NULL,'c749fae7-b315-4efb-8bdf-62ac4a91d921',199,'6b53653c238d45b18082508e065d099c','shares',1,'2026-01-22 14:17:22','e930702d-a3b3-40a2-9f70-64fa8134ddf6'),('2026-01-21 14:17:22.152670',NULL,'2026-01-21 14:17:22.242341',621,621,NULL,'0601070e-1c44-42ce-8dd9-b98c4fe39f49',198,'6b53653c238d45b18082508e065d099c','gigabytes',1,'2026-01-22 14:17:22','e930702d-a3b3-40a2-9f70-64fa8134ddf6'),('2026-01-21 14:17:33.055063',NULL,'2026-01-21 14:17:33.200939',622,622,'3f155a642cbe41c5a9ffda4ad895b42a','caa9ae3d-69f5-41e0-a9fd-db3209780841',201,'42d0f9e7ca75499fafa3885d62f2fa91','shares',1,'2026-01-22 14:17:33',NULL),('2026-01-21 14:17:33.056462',NULL,'2026-01-21 14:17:33.200939',623,623,'3f155a642cbe41c5a9ffda4ad895b42a','9a3e174a-919f-446b-8e54-13acf06cda1d',200,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',1,'2026-01-22 14:17:33',NULL),('2026-01-21 14:17:33.111375',NULL,'2026-01-21 14:17:33.200939',624,624,NULL,'054f8756-2584-4cb1-8d4b-6508630eb174',203,'42d0f9e7ca75499fafa3885d62f2fa91','shares',1,'2026-01-22 14:17:33','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:17:33.112977',NULL,'2026-01-21 14:17:33.200939',625,625,NULL,'0769a6b4-523a-4b4a-a30a-98934e261bbf',202,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',1,'2026-01-22 14:17:33','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:17:36.918460',NULL,'2026-01-21 14:17:38.214808',626,626,'3f155a642cbe41c5a9ffda4ad895b42a','b3c646e4-c9b1-4928-8d92-10954b0711cf',205,'42d0f9e7ca75499fafa3885d62f2fa91','snapshots',1,'2026-01-22 14:17:36',NULL),('2026-01-21 14:17:36.922953',NULL,'2026-01-21 14:17:38.214808',627,627,'3f155a642cbe41c5a9ffda4ad895b42a','18709472-a762-46d0-a23b-fc5ee3336e1b',204,'42d0f9e7ca75499fafa3885d62f2fa91','snapshot_gigabytes',1,'2026-01-22 14:17:36',NULL),('2026-01-21 14:17:38.117334',NULL,'2026-01-21 14:17:38.214808',628,628,NULL,'a346fc16-9d73-46e8-b85a-4695ab0e5fa1',207,'42d0f9e7ca75499fafa3885d62f2fa91','snapshots',1,'2026-01-22 14:17:36','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:17:38.120539',NULL,'2026-01-21 14:17:38.214808',629,629,NULL,'3062e40d-1e30-4ace-9c8a-eda6f0d2348b',206,'42d0f9e7ca75499fafa3885d62f2fa91','snapshot_gigabytes',1,'2026-01-22 14:17:36','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:17:39.136787',NULL,'2026-01-21 14:17:39.172980',630,630,'53e1b03c59294270a311e7426f54bef6','8107080c-22e9-402d-b6b0-914f7a7e17f7',182,'6b53653c238d45b18082508e065d099c','shares',-1,'2026-01-22 14:17:39',NULL),('2026-01-21 14:17:39.137779',NULL,'2026-01-21 14:17:39.172980',631,631,'53e1b03c59294270a311e7426f54bef6','a6c98d0e-02b2-463b-a591-242745e1324c',181,'6b53653c238d45b18082508e065d099c','gigabytes',-1,'2026-01-22 14:17:39',NULL),('2026-01-21 14:17:39.161576',NULL,'2026-01-21 14:17:39.172980',632,632,NULL,'09f6749b-ceee-44f9-a7e2-ba4a57b6540b',199,'6b53653c238d45b18082508e065d099c','shares',-1,'2026-01-22 14:17:39','e930702d-a3b3-40a2-9f70-64fa8134ddf6'),('2026-01-21 14:17:39.163391',NULL,'2026-01-21 14:17:39.172980',633,633,NULL,'3122d15d-471a-4324-9d44-7d0abd199bd6',198,'6b53653c238d45b18082508e065d099c','gigabytes',-1,'2026-01-22 14:17:39','e930702d-a3b3-40a2-9f70-64fa8134ddf6'),('2026-01-21 14:17:42.730420',NULL,'2026-01-21 14:17:42.835408',634,634,'53e1b03c59294270a311e7426f54bef6','f2991304-097b-4f27-85ba-da411ef973a2',182,'6b53653c238d45b18082508e065d099c','shares',-1,'2026-01-22 14:17:42',NULL),('2026-01-21 14:17:42.731974',NULL,'2026-01-21 14:17:42.835408',635,635,'53e1b03c59294270a311e7426f54bef6','2604180d-c92b-4270-8e5a-a1ffb171dc5d',181,'6b53653c238d45b18082508e065d099c','gigabytes',-1,'2026-01-22 14:17:42',NULL),('2026-01-21 14:17:42.822538',NULL,'2026-01-21 14:17:42.835408',636,636,NULL,'904224d0-64b2-4482-bf99-7132d6faf294',184,'6b53653c238d45b18082508e065d099c','shares',-1,'2026-01-22 14:17:42','b162a983-fd22-416d-b3c5-874636612a2e'),('2026-01-21 14:17:42.823408',NULL,'2026-01-21 14:17:42.835408',637,637,NULL,'f4ecf724-78fa-42fd-8a63-f12ae9ed7944',183,'6b53653c238d45b18082508e065d099c','gigabytes',-1,'2026-01-22 14:17:42','b162a983-fd22-416d-b3c5-874636612a2e'),('2026-01-21 14:17:43.056955',NULL,'2026-01-21 14:17:43.430237',638,638,'3f155a642cbe41c5a9ffda4ad895b42a','71c5d3d8-60ad-4c20-bdec-c1f5c7953bcb',201,'42d0f9e7ca75499fafa3885d62f2fa91','shares',1,'2026-01-22 14:17:43',NULL),('2026-01-21 14:17:43.058592',NULL,'2026-01-21 14:17:43.430237',639,639,'3f155a642cbe41c5a9ffda4ad895b42a','f5166c31-b1fa-4690-9183-87295b415e0d',200,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',1,'2026-01-22 14:17:43',NULL),('2026-01-21 14:17:43.150444',NULL,'2026-01-21 14:17:43.430237',640,640,NULL,'303af817-d95f-45be-b9f4-e94e1e556332',203,'42d0f9e7ca75499fafa3885d62f2fa91','shares',1,'2026-01-22 14:17:43','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:17:43.151789',NULL,'2026-01-21 14:17:43.430237',641,641,NULL,'6c778a13-0405-4ce5-970d-143ebc0d2531',202,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',1,'2026-01-22 14:17:43','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:17:44.924185',NULL,'2026-01-21 14:17:45.045717',642,642,'847ff8e5688c42c1bb942b9ed884ef49','28a67fa9-719f-449e-b03f-3766ff0a7da5',209,'057c07904cd34efc9ceea6ab2d3e4d04','shares',1,'2026-01-22 14:17:44',NULL),('2026-01-21 14:17:44.925428',NULL,'2026-01-21 14:17:45.045717',643,643,'847ff8e5688c42c1bb942b9ed884ef49','f2e6b292-aa89-4700-b1e6-40c395ab9ecc',208,'057c07904cd34efc9ceea6ab2d3e4d04','gigabytes',1,'2026-01-22 14:17:44',NULL),('2026-01-21 14:17:45.011602',NULL,'2026-01-21 14:17:45.045717',644,644,NULL,'625783bc-0f78-4be9-8ae1-fcab988f7a57',211,'057c07904cd34efc9ceea6ab2d3e4d04','shares',1,'2026-01-22 14:17:44','a36cdb63-0be1-431b-b3a6-13bc024a485c'),('2026-01-21 14:17:45.012838',NULL,'2026-01-21 14:17:45.045717',645,645,NULL,'b5f2f543-9498-46db-ad9c-632c09996bfc',210,'057c07904cd34efc9ceea6ab2d3e4d04','gigabytes',1,'2026-01-22 14:17:44','a36cdb63-0be1-431b-b3a6-13bc024a485c'),('2026-01-21 14:17:46.668781',NULL,'2026-01-21 14:17:46.691740',646,646,'c9132702f2324cf7b8026c09a5d89dee','4b1ac5de-7b36-4692-8671-d7a1f9cd2497',171,'183d8c03d481485397037ffe17a60995','shares',-1,'2026-01-22 14:17:46',NULL),('2026-01-21 14:17:46.669633',NULL,'2026-01-21 14:17:46.691740',647,647,'c9132702f2324cf7b8026c09a5d89dee','7fda81f7-3b83-4fdb-9d2b-0242986a55be',172,'183d8c03d481485397037ffe17a60995','gigabytes',-1,'2026-01-22 14:17:46',NULL),('2026-01-21 14:17:46.677374',NULL,'2026-01-21 14:17:46.691740',648,648,NULL,'b29e1985-949e-4270-a0b9-54f8214ce958',178,'183d8c03d481485397037ffe17a60995','shares',-1,'2026-01-22 14:17:46','b162a983-fd22-416d-b3c5-874636612a2e'),('2026-01-21 14:17:46.678673',NULL,'2026-01-21 14:17:46.691740',649,649,NULL,'bdfaf613-c07c-479e-934c-d9e9360807bc',177,'183d8c03d481485397037ffe17a60995','gigabytes',-1,'2026-01-22 14:17:46','b162a983-fd22-416d-b3c5-874636612a2e'),('2026-01-21 14:17:47.673043',NULL,'2026-01-21 14:17:47.752221',650,650,'3f155a642cbe41c5a9ffda4ad895b42a','cb723500-7fc9-4e96-81f7-3048896186ff',201,'42d0f9e7ca75499fafa3885d62f2fa91','shares',-1,'2026-01-22 14:17:47',NULL),('2026-01-21 14:17:47.673904',NULL,'2026-01-21 14:17:47.752221',651,651,'3f155a642cbe41c5a9ffda4ad895b42a','b9e10497-2192-487a-87d4-b8942c57aba0',200,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',-1,'2026-01-22 14:17:47',NULL),('2026-01-21 14:17:47.739773',NULL,'2026-01-21 14:17:47.752221',652,652,NULL,'b5c48e3c-28ac-4197-8e5c-497ff86038df',203,'42d0f9e7ca75499fafa3885d62f2fa91','shares',-1,'2026-01-22 14:17:47','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:17:47.740809',NULL,'2026-01-21 14:17:47.752221',653,653,NULL,'0c640abf-4c4d-4eb9-b205-22b0c3ae2b2c',202,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',-1,'2026-01-22 14:17:47','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:17:48.821503',NULL,'2026-01-21 14:17:48.857397',654,654,'847ff8e5688c42c1bb942b9ed884ef49','c1b2f938-3ca8-4681-a4e3-29b98c22329a',209,'057c07904cd34efc9ceea6ab2d3e4d04','shares',1,'2026-01-22 14:17:48',NULL),('2026-01-21 14:17:48.824357',NULL,'2026-01-21 14:17:48.857397',655,655,'847ff8e5688c42c1bb942b9ed884ef49','fdb57dc4-2c3e-4d3e-8f7a-0595a30e52de',208,'057c07904cd34efc9ceea6ab2d3e4d04','gigabytes',1,'2026-01-22 14:17:48',NULL),('2026-01-21 14:17:48.832971',NULL,'2026-01-21 14:17:48.857397',656,656,NULL,'cdb0fd2d-6506-4542-8334-3d9ec8965be8',211,'057c07904cd34efc9ceea6ab2d3e4d04','shares',1,'2026-01-22 14:17:48','a36cdb63-0be1-431b-b3a6-13bc024a485c'),('2026-01-21 14:17:48.834594',NULL,'2026-01-21 14:17:48.857397',657,657,NULL,'da0cda00-5fa6-484c-8685-1a80024edff3',210,'057c07904cd34efc9ceea6ab2d3e4d04','gigabytes',1,'2026-01-22 14:17:48','a36cdb63-0be1-431b-b3a6-13bc024a485c'),('2026-01-21 14:17:50.697016',NULL,'2026-01-21 14:17:50.904676',658,658,'c9132702f2324cf7b8026c09a5d89dee','7a490492-15b3-48b8-9d2a-8f4466318936',171,'183d8c03d481485397037ffe17a60995','shares',-1,'2026-01-22 14:17:50',NULL),('2026-01-21 14:17:50.698118',NULL,'2026-01-21 14:17:50.904676',659,659,'c9132702f2324cf7b8026c09a5d89dee','eac2723c-d56f-4580-82ab-f17a06049507',172,'183d8c03d481485397037ffe17a60995','gigabytes',-1,'2026-01-22 14:17:50',NULL),('2026-01-21 14:17:50.882136',NULL,'2026-01-21 14:17:50.904676',660,660,NULL,'22d49dee-e119-4fdd-ba9c-ecdc67fae955',173,'183d8c03d481485397037ffe17a60995','shares',-1,'2026-01-22 14:17:50','e930702d-a3b3-40a2-9f70-64fa8134ddf6'),('2026-01-21 14:17:50.882972',NULL,'2026-01-21 14:17:50.904676',661,661,NULL,'70adbbd1-c655-4d9b-9f89-9f778326fb5b',174,'183d8c03d481485397037ffe17a60995','gigabytes',-1,'2026-01-22 14:17:50','e930702d-a3b3-40a2-9f70-64fa8134ddf6'),('2026-01-21 14:17:50.950018',NULL,'2026-01-21 14:17:50.989550',662,662,'3f155a642cbe41c5a9ffda4ad895b42a','c8e0a862-e6eb-4466-8af6-6943a98ff005',201,'42d0f9e7ca75499fafa3885d62f2fa91','shares',1,'2026-01-22 14:17:50',NULL),('2026-01-21 14:17:50.951286',NULL,'2026-01-21 14:17:50.989550',663,663,'3f155a642cbe41c5a9ffda4ad895b42a','e5d0cd01-6715-4d6c-ad0d-0ec70e8a5ca7',200,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',2,'2026-01-22 14:17:50',NULL),('2026-01-21 14:17:50.967268',NULL,'2026-01-21 14:17:50.989550',664,664,NULL,'e9172a48-6827-40ed-b4a6-c462cfebdbe1',203,'42d0f9e7ca75499fafa3885d62f2fa91','shares',1,'2026-01-22 14:17:50','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:17:50.968631',NULL,'2026-01-21 14:17:50.989550',665,665,NULL,'fc9c75b3-a28e-488b-a4be-2ff4566ee062',202,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',2,'2026-01-22 14:17:50','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:17:53.004672',NULL,'2026-01-21 14:17:53.039256',666,666,'847ff8e5688c42c1bb942b9ed884ef49','08b1003c-8bd4-4521-ae52-3295b7da74b2',209,'057c07904cd34efc9ceea6ab2d3e4d04','shares',-1,'2026-01-22 14:17:52',NULL),('2026-01-21 14:17:53.005836',NULL,'2026-01-21 14:17:53.039256',667,667,'847ff8e5688c42c1bb942b9ed884ef49','d24a419b-c356-45e8-8a2e-8207e6b66dbc',208,'057c07904cd34efc9ceea6ab2d3e4d04','gigabytes',-1,'2026-01-22 14:17:52',NULL),('2026-01-21 14:17:53.024838',NULL,'2026-01-21 14:17:53.039256',668,668,NULL,'67b7edc1-4825-4b52-a53a-0815687d1c5e',211,'057c07904cd34efc9ceea6ab2d3e4d04','shares',-1,'2026-01-22 14:17:52','a36cdb63-0be1-431b-b3a6-13bc024a485c'),('2026-01-21 14:17:53.030199',NULL,'2026-01-21 14:17:53.039256',669,669,NULL,'6de2fab6-f407-4564-86a8-43522b362ae3',210,'057c07904cd34efc9ceea6ab2d3e4d04','gigabytes',-1,'2026-01-22 14:17:52','a36cdb63-0be1-431b-b3a6-13bc024a485c'),('2026-01-21 14:17:57.162436',NULL,'2026-01-21 14:17:57.628190',670,670,'847ff8e5688c42c1bb942b9ed884ef49','e952c89e-e9ef-48d6-82b9-8ef81d2f018b',209,'057c07904cd34efc9ceea6ab2d3e4d04','shares',-1,'2026-01-22 14:17:57',NULL),('2026-01-21 14:17:57.163712',NULL,'2026-01-21 14:17:57.628190',671,671,'847ff8e5688c42c1bb942b9ed884ef49','c83367ed-1403-4c24-8a8b-fb455b2567ee',208,'057c07904cd34efc9ceea6ab2d3e4d04','gigabytes',-1,'2026-01-22 14:17:57',NULL),('2026-01-21 14:17:57.310872',NULL,'2026-01-21 14:17:57.628190',672,672,NULL,'2f7ac3cb-37d9-4f68-802e-1079ba371fa3',211,'057c07904cd34efc9ceea6ab2d3e4d04','shares',-1,'2026-01-22 14:17:57','a36cdb63-0be1-431b-b3a6-13bc024a485c'),('2026-01-21 14:17:57.311966',NULL,'2026-01-21 14:17:57.628190',673,673,NULL,'ab6b9a3c-4f39-4227-9cec-6a4fcac55423',210,'057c07904cd34efc9ceea6ab2d3e4d04','gigabytes',-1,'2026-01-22 14:17:57','a36cdb63-0be1-431b-b3a6-13bc024a485c'),('2026-01-21 14:17:57.327146',NULL,'2026-01-21 14:17:57.811419',674,674,'3f155a642cbe41c5a9ffda4ad895b42a','68be770f-a618-4e9d-b09c-53f353a72cb5',201,'42d0f9e7ca75499fafa3885d62f2fa91','shares',-1,'2026-01-22 14:17:57',NULL),('2026-01-21 14:17:57.328051',NULL,'2026-01-21 14:17:57.811419',675,675,'3f155a642cbe41c5a9ffda4ad895b42a','004493c4-cf8a-4433-90ac-2866f8e11dba',200,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',-2,'2026-01-22 14:17:57',NULL),('2026-01-21 14:17:57.689564',NULL,'2026-01-21 14:17:57.811419',676,676,NULL,'587cac52-8950-4e4c-8cf5-a10b8c1c8865',203,'42d0f9e7ca75499fafa3885d62f2fa91','shares',-1,'2026-01-22 14:17:57','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:17:57.690752',NULL,'2026-01-21 14:17:57.811419',677,677,NULL,'94599f23-4818-474d-8c64-304649622da7',202,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',-2,'2026-01-22 14:17:57','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:18:00.355537',NULL,'2026-01-21 14:18:00.395396',678,678,'847ff8e5688c42c1bb942b9ed884ef49','e8109f1b-b6f1-4451-8787-f3a00f6b8be3',212,'057c07904cd34efc9ceea6ab2d3e4d04','share_groups',1,'2026-01-22 14:18:00',NULL),('2026-01-21 14:18:00.385591',NULL,'2026-01-21 14:18:00.451038',679,679,'3f155a642cbe41c5a9ffda4ad895b42a','c0ead24e-3179-4a2a-8626-c7e0d855d2cc',201,'42d0f9e7ca75499fafa3885d62f2fa91','shares',1,'2026-01-22 14:18:00',NULL),('2026-01-21 14:18:00.386823',NULL,'2026-01-21 14:18:00.451038',680,680,'3f155a642cbe41c5a9ffda4ad895b42a','9a63a612-97a7-4b79-b385-dea4d622aa41',200,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',1,'2026-01-22 14:18:00',NULL),('2026-01-21 14:18:00.398921',NULL,'2026-01-21 14:18:00.451038',681,681,NULL,'e3d639b7-ae39-4e03-a057-6b9852c300dd',203,'42d0f9e7ca75499fafa3885d62f2fa91','shares',1,'2026-01-22 14:18:00','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:18:00.400941',NULL,'2026-01-21 14:18:00.451038',682,682,NULL,'ca731538-6e67-43f7-9785-30ac66d23f16',202,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',1,'2026-01-22 14:18:00','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:18:04.102814',NULL,'2026-01-21 14:18:04.210830',683,683,'847ff8e5688c42c1bb942b9ed884ef49','b7850a16-108d-4f99-91bc-23d58f194e71',212,'057c07904cd34efc9ceea6ab2d3e4d04','share_groups',-1,'2026-01-22 14:18:04',NULL),('2026-01-21 14:18:04.717926',NULL,'2026-01-21 14:18:05.876521',684,684,'847ff8e5688c42c1bb942b9ed884ef49','c88dc368-92a7-4d5f-9aae-fa1b20308126',212,'057c07904cd34efc9ceea6ab2d3e4d04','share_groups',1,'2026-01-22 14:18:04',NULL),('2026-01-21 14:18:11.960045',NULL,'2026-01-21 14:18:12.107064',685,685,'3f155a642cbe41c5a9ffda4ad895b42a','c9d0922d-9e02-413d-a608-94af1310cdc9',201,'42d0f9e7ca75499fafa3885d62f2fa91','shares',-1,'2026-01-22 14:18:11',NULL),('2026-01-21 14:18:11.960939',NULL,'2026-01-21 14:18:12.107064',686,686,'3f155a642cbe41c5a9ffda4ad895b42a','24935c32-6184-4915-9793-61d90ac6f8fd',200,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',-1,'2026-01-22 14:18:11',NULL),('2026-01-21 14:18:12.056509',NULL,'2026-01-21 14:18:12.107064',687,687,NULL,'5be4d30c-746d-4de6-be13-3f821240653f',203,'42d0f9e7ca75499fafa3885d62f2fa91','shares',-1,'2026-01-22 14:18:11','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:18:12.057982',NULL,'2026-01-21 14:18:12.107064',688,688,NULL,'308ec193-1036-4251-bc2e-b21a1312bd5c',202,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',-1,'2026-01-22 14:18:11','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:18:15.199822',NULL,'2026-01-21 14:18:16.670073',689,689,'3f155a642cbe41c5a9ffda4ad895b42a','d8ca89a4-e344-4b48-949d-722ce6fdd613',201,'42d0f9e7ca75499fafa3885d62f2fa91','shares',1,'2026-01-22 14:18:15',NULL),('2026-01-21 14:18:15.201380',NULL,'2026-01-21 14:18:16.670073',690,690,'3f155a642cbe41c5a9ffda4ad895b42a','f7252b68-bdd4-4e9c-8a0e-b407f6cab501',200,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',1,'2026-01-22 14:18:15',NULL),('2026-01-21 14:18:15.300181',NULL,'2026-01-21 14:18:16.670073',691,691,NULL,'66c245fd-46f7-41f1-9d3d-6410c5175bf5',203,'42d0f9e7ca75499fafa3885d62f2fa91','shares',1,'2026-01-22 14:18:15','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:18:15.462953',NULL,'2026-01-21 14:18:16.659782',692,692,'847ff8e5688c42c1bb942b9ed884ef49','aa571327-1fee-4674-a27c-876b0717f2e8',212,'057c07904cd34efc9ceea6ab2d3e4d04','share_groups',-1,'2026-01-22 14:18:15',NULL),('2026-01-21 14:18:15.598173',NULL,'2026-01-21 14:18:16.670073',693,693,NULL,'d03d4f03-495f-429d-a20c-a1f029730777',202,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',1,'2026-01-22 14:18:15','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:18:17.230474',NULL,'2026-01-21 14:18:17.315770',694,694,'847ff8e5688c42c1bb942b9ed884ef49','8501b4e4-6d16-4d8f-8789-1711b609c969',209,'057c07904cd34efc9ceea6ab2d3e4d04','shares',1,'2026-01-22 14:18:17',NULL),('2026-01-21 14:18:17.234287',NULL,'2026-01-21 14:18:17.315770',695,695,'847ff8e5688c42c1bb942b9ed884ef49','d4216191-fdf9-40dc-aef7-f124187cbb70',208,'057c07904cd34efc9ceea6ab2d3e4d04','gigabytes',1,'2026-01-22 14:18:17',NULL),('2026-01-21 14:18:17.251811',NULL,'2026-01-21 14:18:17.315770',696,696,NULL,'73fb4352-2188-4a57-b965-a4690ffb5f05',211,'057c07904cd34efc9ceea6ab2d3e4d04','shares',1,'2026-01-22 14:18:17','a36cdb63-0be1-431b-b3a6-13bc024a485c'),('2026-01-21 14:18:17.255164',NULL,'2026-01-21 14:18:17.315770',697,697,NULL,'1f737133-d9ea-4038-a9f6-dd02553bf264',210,'057c07904cd34efc9ceea6ab2d3e4d04','gigabytes',1,'2026-01-22 14:18:17','a36cdb63-0be1-431b-b3a6-13bc024a485c'),('2026-01-21 14:18:19.207402',NULL,'2026-01-21 14:18:19.299609',698,698,'4a2fe10fc9e348b7882f646ffc46378a','ff1a8e44-901e-4342-879e-cfd8a7a73e68',214,'3cc89d84bffa401eab10c32a2f4b29d2','shares',1,'2026-01-22 14:18:19',NULL),('2026-01-21 14:18:19.209418',NULL,'2026-01-21 14:18:19.299609',699,699,'4a2fe10fc9e348b7882f646ffc46378a','d67b08d9-80d0-49f7-9820-0c07df658f93',213,'3cc89d84bffa401eab10c32a2f4b29d2','gigabytes',1,'2026-01-22 14:18:19',NULL),('2026-01-21 14:18:19.245684',NULL,'2026-01-21 14:18:19.299609',700,700,NULL,'45626289-9f2c-494d-85c7-4defb721d2fb',216,'3cc89d84bffa401eab10c32a2f4b29d2','shares',1,'2026-01-22 14:18:19','f78ae5cb-fced-4e97-b8cd-e69b71d0827c'),('2026-01-21 14:18:19.246995',NULL,'2026-01-21 14:18:19.299609',701,701,NULL,'8a47125e-73b6-497e-98df-9dfc35816917',215,'3cc89d84bffa401eab10c32a2f4b29d2','gigabytes',1,'2026-01-22 14:18:19','f78ae5cb-fced-4e97-b8cd-e69b71d0827c'),('2026-01-21 14:18:20.996317',NULL,'2026-01-21 14:18:21.012286',702,702,'3f155a642cbe41c5a9ffda4ad895b42a','22ee55af-0b53-4e5d-99b0-3b46f024d515',201,'42d0f9e7ca75499fafa3885d62f2fa91','shares',-1,'2026-01-22 14:18:20',NULL),('2026-01-21 14:18:20.997138',NULL,'2026-01-21 14:18:21.012286',703,703,'3f155a642cbe41c5a9ffda4ad895b42a','25c627c2-ad60-458a-99b5-81817c6b1240',200,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',-1,'2026-01-22 14:18:20',NULL),('2026-01-21 14:18:21.003031',NULL,'2026-01-21 14:18:21.012286',704,704,NULL,'a834af57-9f1c-4cde-bfb0-b5bb1e8fe77f',203,'42d0f9e7ca75499fafa3885d62f2fa91','shares',-1,'2026-01-22 14:18:20','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:18:21.003717',NULL,'2026-01-21 14:18:21.012286',705,705,NULL,'b91addce-a111-452e-b8ea-a506ff52ab7b',202,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',-1,'2026-01-22 14:18:20','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:18:21.233682',NULL,'2026-01-21 14:18:21.252410',706,706,'847ff8e5688c42c1bb942b9ed884ef49','cc6cc870-90ad-480c-8c8e-35ce17c2ee2c',209,'057c07904cd34efc9ceea6ab2d3e4d04','shares',-1,'2026-01-22 14:18:21',NULL),('2026-01-21 14:18:21.234722',NULL,'2026-01-21 14:18:21.252410',707,707,'847ff8e5688c42c1bb942b9ed884ef49','387b3747-db85-4510-9169-ff614d1369ce',208,'057c07904cd34efc9ceea6ab2d3e4d04','gigabytes',-1,'2026-01-22 14:18:21',NULL),('2026-01-21 14:18:21.241969',NULL,'2026-01-21 14:18:21.252410',708,708,NULL,'6e93dd16-55e7-46e2-bb82-090019f043e4',211,'057c07904cd34efc9ceea6ab2d3e4d04','shares',-1,'2026-01-22 14:18:21','a36cdb63-0be1-431b-b3a6-13bc024a485c'),('2026-01-21 14:18:21.242764',NULL,'2026-01-21 14:18:21.252410',709,709,NULL,'3f9df5a3-d1f5-4f35-9ceb-021a7e8af31d',210,'057c07904cd34efc9ceea6ab2d3e4d04','gigabytes',-1,'2026-01-22 14:18:21','a36cdb63-0be1-431b-b3a6-13bc024a485c'),('2026-01-21 14:18:22.802056',NULL,'2026-01-21 14:18:22.899692',710,710,'4a2fe10fc9e348b7882f646ffc46378a','fd732d69-5b76-4087-9be0-327229d6226c',218,'3cc89d84bffa401eab10c32a2f4b29d2','snapshots',1,'2026-01-22 14:18:22',NULL),('2026-01-21 14:18:22.803555',NULL,'2026-01-21 14:18:22.899692',711,711,'4a2fe10fc9e348b7882f646ffc46378a','92c5b57a-6ff5-4dbc-8407-d23860683957',217,'3cc89d84bffa401eab10c32a2f4b29d2','snapshot_gigabytes',1,'2026-01-22 14:18:22',NULL),('2026-01-21 14:18:22.826708',NULL,'2026-01-21 14:18:22.899692',712,712,NULL,'4b805f37-cbed-42aa-bc04-28d5dfbac0a3',220,'3cc89d84bffa401eab10c32a2f4b29d2','snapshots',1,'2026-01-22 14:18:22','f78ae5cb-fced-4e97-b8cd-e69b71d0827c'),('2026-01-21 14:18:22.828045',NULL,'2026-01-21 14:18:22.899692',713,713,NULL,'4a21ab92-9db2-4ee5-af1f-9e44f251e8c6',219,'3cc89d84bffa401eab10c32a2f4b29d2','snapshot_gigabytes',1,'2026-01-22 14:18:22','f78ae5cb-fced-4e97-b8cd-e69b71d0827c'),('2026-01-21 14:18:24.081831',NULL,'2026-01-21 14:18:24.119996',714,714,'3f155a642cbe41c5a9ffda4ad895b42a','ec2b2c7f-c952-4fa0-9c58-bcc609aed525',201,'42d0f9e7ca75499fafa3885d62f2fa91','shares',1,'2026-01-22 14:18:24',NULL),('2026-01-21 14:18:24.083623',NULL,'2026-01-21 14:18:24.119996',715,715,'3f155a642cbe41c5a9ffda4ad895b42a','de94bc70-0272-4887-905b-553652882479',200,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',1,'2026-01-22 14:18:24',NULL),('2026-01-21 14:18:24.093907',NULL,'2026-01-21 14:18:24.119996',716,716,NULL,'eba4a34d-af55-4b85-ae08-223deac03480',203,'42d0f9e7ca75499fafa3885d62f2fa91','shares',1,'2026-01-22 14:18:24','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:18:24.095784',NULL,'2026-01-21 14:18:24.119996',717,717,NULL,'dea18344-dcbc-4af3-aedf-3daac5ae0b00',202,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',1,'2026-01-22 14:18:24','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:18:24.478063',NULL,'2026-01-21 14:18:24.520769',718,718,'847ff8e5688c42c1bb942b9ed884ef49','d3fc3477-575e-465c-87fa-1ac193861d12',209,'057c07904cd34efc9ceea6ab2d3e4d04','shares',1,'2026-01-22 14:18:24',NULL),('2026-01-21 14:18:24.480321',NULL,'2026-01-21 14:18:24.520769',719,719,'847ff8e5688c42c1bb942b9ed884ef49','d8fafe68-1fa3-4561-a8e8-dd3ab3179ecb',208,'057c07904cd34efc9ceea6ab2d3e4d04','gigabytes',1,'2026-01-22 14:18:24',NULL),('2026-01-21 14:18:24.490622',NULL,'2026-01-21 14:18:24.520769',720,720,NULL,'2b778452-0243-4aa8-9a98-a343a0bebdf3',211,'057c07904cd34efc9ceea6ab2d3e4d04','shares',1,'2026-01-22 14:18:24','a36cdb63-0be1-431b-b3a6-13bc024a485c'),('2026-01-21 14:18:24.491790',NULL,'2026-01-21 14:18:24.520769',721,721,NULL,'30bbd437-174f-453d-af2f-d479036dbe68',210,'057c07904cd34efc9ceea6ab2d3e4d04','gigabytes',1,'2026-01-22 14:18:24','a36cdb63-0be1-431b-b3a6-13bc024a485c'),('2026-01-21 14:18:27.968464',NULL,'2026-01-21 14:18:28.022726',722,722,'4a2fe10fc9e348b7882f646ffc46378a','2cb48eb3-aacf-48a6-8c38-0acbb59473de',218,'3cc89d84bffa401eab10c32a2f4b29d2','snapshots',-1,'2026-01-22 14:18:27',NULL),('2026-01-21 14:18:27.970066',NULL,'2026-01-21 14:18:28.022726',723,723,'4a2fe10fc9e348b7882f646ffc46378a','7ea238b4-c1cc-43d9-ae04-50a1de38f54f',217,'3cc89d84bffa401eab10c32a2f4b29d2','snapshot_gigabytes',-1,'2026-01-22 14:18:27',NULL),('2026-01-21 14:18:28.002667',NULL,'2026-01-21 14:18:28.022726',724,724,NULL,'6d3368f1-d0a1-4912-b02d-e13fbcce8c76',220,'3cc89d84bffa401eab10c32a2f4b29d2','snapshots',-1,'2026-01-22 14:18:27','f78ae5cb-fced-4e97-b8cd-e69b71d0827c'),('2026-01-21 14:18:28.003642',NULL,'2026-01-21 14:18:28.022726',725,725,NULL,'f8ee5d42-f74c-47e7-9760-6157a873d144',219,'3cc89d84bffa401eab10c32a2f4b29d2','snapshot_gigabytes',-1,'2026-01-22 14:18:27','f78ae5cb-fced-4e97-b8cd-e69b71d0827c'),('2026-01-21 14:18:28.979478',NULL,'2026-01-21 14:18:29.005995',726,726,'3f155a642cbe41c5a9ffda4ad895b42a','9a7a31dc-8fd4-4013-bfe3-fa057108d2b8',201,'42d0f9e7ca75499fafa3885d62f2fa91','shares',-1,'2026-01-22 14:18:28',NULL),('2026-01-21 14:18:28.980835',NULL,'2026-01-21 14:18:29.005995',727,727,'3f155a642cbe41c5a9ffda4ad895b42a','90069c1a-d727-4bb6-883b-5fae3158f316',200,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',-1,'2026-01-22 14:18:28',NULL),('2026-01-21 14:18:28.988446',NULL,'2026-01-21 14:18:29.014359',728,728,'847ff8e5688c42c1bb942b9ed884ef49','3568073d-7a57-459a-9930-9f767ce7fa38',209,'057c07904cd34efc9ceea6ab2d3e4d04','shares',-1,'2026-01-22 14:18:28',NULL),('2026-01-21 14:18:28.989216',NULL,'2026-01-21 14:18:29.005995',729,729,NULL,'77954ed2-958c-4144-9dd9-7c5e5a908483',203,'42d0f9e7ca75499fafa3885d62f2fa91','shares',-1,'2026-01-22 14:18:28','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:18:28.990027',NULL,'2026-01-21 14:18:29.014359',730,730,'847ff8e5688c42c1bb942b9ed884ef49','307cb3a1-576b-44e8-9f8a-0cc227569c36',208,'057c07904cd34efc9ceea6ab2d3e4d04','gigabytes',-1,'2026-01-22 14:18:28',NULL),('2026-01-21 14:18:28.990705',NULL,'2026-01-21 14:18:29.005995',731,731,NULL,'e8b93a7e-d281-473e-95d5-9a2fd59aaa54',202,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',-1,'2026-01-22 14:18:28','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:18:29.001407',NULL,'2026-01-21 14:18:29.014359',732,732,NULL,'a9912ad9-082f-40a2-a1dc-6802f817536a',211,'057c07904cd34efc9ceea6ab2d3e4d04','shares',-1,'2026-01-22 14:18:28','a36cdb63-0be1-431b-b3a6-13bc024a485c'),('2026-01-21 14:18:29.002892',NULL,'2026-01-21 14:18:29.014359',733,733,NULL,'35da0e94-dde5-481e-82a6-a41022049662',210,'057c07904cd34efc9ceea6ab2d3e4d04','gigabytes',-1,'2026-01-22 14:18:28','a36cdb63-0be1-431b-b3a6-13bc024a485c'),('2026-01-21 14:18:30.949317',NULL,'2026-01-21 14:18:30.984809',734,734,'4a2fe10fc9e348b7882f646ffc46378a','0cdba3aa-4c84-4d4c-8d07-6690e0cbcd89',214,'3cc89d84bffa401eab10c32a2f4b29d2','shares',-1,'2026-01-22 14:18:30',NULL),('2026-01-21 14:18:30.952189',NULL,'2026-01-21 14:18:30.984809',735,735,'4a2fe10fc9e348b7882f646ffc46378a','c9f0c89a-d52c-4fe1-bd44-289255f624c2',213,'3cc89d84bffa401eab10c32a2f4b29d2','gigabytes',-1,'2026-01-22 14:18:30',NULL),('2026-01-21 14:18:30.964484',NULL,'2026-01-21 14:18:30.984809',736,736,NULL,'90d30ebd-ea8b-47b5-8a91-56a72e7e811d',216,'3cc89d84bffa401eab10c32a2f4b29d2','shares',-1,'2026-01-22 14:18:30','f78ae5cb-fced-4e97-b8cd-e69b71d0827c'),('2026-01-21 14:18:30.965783',NULL,'2026-01-21 14:18:30.984809',737,737,NULL,'91d9eb84-69f0-4930-9436-e3edd32cfe9d',215,'3cc89d84bffa401eab10c32a2f4b29d2','gigabytes',-1,'2026-01-22 14:18:30','f78ae5cb-fced-4e97-b8cd-e69b71d0827c'),('2026-01-21 14:18:32.533328',NULL,'2026-01-21 14:18:33.069733',738,738,'3f155a642cbe41c5a9ffda4ad895b42a','01697740-48a2-4067-99b7-035f2b33383d',205,'42d0f9e7ca75499fafa3885d62f2fa91','snapshots',-1,'2026-01-22 14:18:32',NULL),('2026-01-21 14:18:32.534294',NULL,'2026-01-21 14:18:33.069733',739,739,'3f155a642cbe41c5a9ffda4ad895b42a','834588bc-c008-4eef-ac8f-9eb0ded6adfb',204,'42d0f9e7ca75499fafa3885d62f2fa91','snapshot_gigabytes',-1,'2026-01-22 14:18:32',NULL),('2026-01-21 14:18:32.690431',NULL,'2026-01-21 14:18:33.069733',740,740,NULL,'b63e9197-110d-42ff-aa43-cc351004bb4f',207,'42d0f9e7ca75499fafa3885d62f2fa91','snapshots',-1,'2026-01-22 14:18:32','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:18:32.691261',NULL,'2026-01-21 14:18:33.069733',741,741,NULL,'96cf7f78-feee-47a4-8579-52078016ce02',206,'42d0f9e7ca75499fafa3885d62f2fa91','snapshot_gigabytes',-1,'2026-01-22 14:18:32','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:18:36.058231',NULL,'2026-01-21 14:18:36.081285',742,742,'3f155a642cbe41c5a9ffda4ad895b42a','5a01f8a1-dee4-4b2e-9a92-fac7d25d8fbf',201,'42d0f9e7ca75499fafa3885d62f2fa91','shares',-1,'2026-01-22 14:18:36',NULL),('2026-01-21 14:18:36.059041',NULL,'2026-01-21 14:18:36.081285',743,743,'3f155a642cbe41c5a9ffda4ad895b42a','4ba6eb4d-077d-4050-8b31-7ed71d3be56e',200,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',-1,'2026-01-22 14:18:36',NULL),('2026-01-21 14:18:36.066505',NULL,'2026-01-21 14:18:36.081285',744,744,NULL,'e99982f3-56ba-4b63-be6d-31f5139839cc',203,'42d0f9e7ca75499fafa3885d62f2fa91','shares',-1,'2026-01-22 14:18:36','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:18:36.067314',NULL,'2026-01-21 14:18:36.081285',745,745,NULL,'5c01a9a5-2dd3-442d-b8fc-32c930728875',202,'42d0f9e7ca75499fafa3885d62f2fa91','gigabytes',-1,'2026-01-22 14:18:36','113e6005-36b8-4048-8bc1-1b192c85dbac'),('2026-01-21 14:18:49.070441',NULL,'2026-01-21 14:18:49.112299',746,746,'51daa32984f24d90b50a4cba851c93da','3a8993b2-3b7b-4fbb-918b-ded245ded4b2',222,'3efc5d38bf75484d9e4b2aed22003264','shares',1,'2026-01-22 14:18:49',NULL),('2026-01-21 14:18:49.072115',NULL,'2026-01-21 14:18:49.112299',747,747,'51daa32984f24d90b50a4cba851c93da','9e3a54df-1664-4868-9ba0-7185a746be50',221,'3efc5d38bf75484d9e4b2aed22003264','gigabytes',1,'2026-01-22 14:18:49',NULL),('2026-01-21 14:18:49.086161',NULL,'2026-01-21 14:18:49.112299',748,748,NULL,'49edf5df-5c88-4ba4-9079-e9aa7f1821c4',224,'3efc5d38bf75484d9e4b2aed22003264','shares',1,'2026-01-22 14:18:49','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:18:49.087549',NULL,'2026-01-21 14:18:49.112299',749,749,NULL,'6e990787-824f-4277-92c9-8a55ee90fd11',223,'3efc5d38bf75484d9e4b2aed22003264','gigabytes',1,'2026-01-22 14:18:49','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:18:53.352672',NULL,'2026-01-21 14:18:53.612323',750,750,'51daa32984f24d90b50a4cba851c93da','3a3812f4-e9d3-4d31-97ab-8646e233c197',226,'3efc5d38bf75484d9e4b2aed22003264','snapshots',1,'2026-01-22 14:18:53',NULL),('2026-01-21 14:18:53.353742',NULL,'2026-01-21 14:18:53.612323',751,751,'51daa32984f24d90b50a4cba851c93da','5d01c75c-4216-40cf-a0d1-c1e3d5ef809f',225,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',1,'2026-01-22 14:18:53',NULL),('2026-01-21 14:18:53.367303',NULL,'2026-01-21 14:18:53.612323',752,752,NULL,'b9124c94-984e-4d9d-ab68-f680204288c2',228,'3efc5d38bf75484d9e4b2aed22003264','snapshots',1,'2026-01-22 14:18:53','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:18:53.368675',NULL,'2026-01-21 14:18:53.612323',753,753,NULL,'74358ba1-13b2-47cd-88a4-509223954d85',227,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',1,'2026-01-22 14:18:53','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:18:53.986392',NULL,'2026-01-21 14:18:54.079000',754,754,'51daa32984f24d90b50a4cba851c93da','c6486465-3f39-43fb-b9b2-d5d0f4f3db1f',226,'3efc5d38bf75484d9e4b2aed22003264','snapshots',1,'2026-01-22 14:18:53',NULL),('2026-01-21 14:18:53.987701',NULL,'2026-01-21 14:18:54.079000',755,755,'51daa32984f24d90b50a4cba851c93da','bd44b367-9cf5-4b42-bc73-902a4ab7f275',225,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',1,'2026-01-22 14:18:53',NULL),('2026-01-21 14:18:54.002475',NULL,'2026-01-21 14:18:54.079000',756,756,NULL,'c3929a9f-90e8-41d7-b83f-b99f24431a8e',228,'3efc5d38bf75484d9e4b2aed22003264','snapshots',1,'2026-01-22 14:18:53','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:18:54.004375',NULL,'2026-01-21 14:18:54.079000',757,757,NULL,'efe898e6-f501-48fb-9a67-6b79cb3f7395',227,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',1,'2026-01-22 14:18:53','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:18:56.188030',NULL,'2026-01-21 14:18:56.309788',758,758,'51daa32984f24d90b50a4cba851c93da','b8cf5f8c-b6f3-4e92-97cf-6260de9c2255',226,'3efc5d38bf75484d9e4b2aed22003264','snapshots',-1,'2026-01-22 14:18:56',NULL),('2026-01-21 14:18:56.188902',NULL,'2026-01-21 14:18:56.309788',759,759,'51daa32984f24d90b50a4cba851c93da','a4a9c4c8-d38a-4833-b85d-81e55b97a129',225,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',-1,'2026-01-22 14:18:56',NULL),('2026-01-21 14:18:56.242893',NULL,'2026-01-21 14:18:56.309788',760,760,NULL,'3d276c8d-1560-43ab-9c6d-c06d3fd115d4',228,'3efc5d38bf75484d9e4b2aed22003264','snapshots',-1,'2026-01-22 14:18:56','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:18:56.244271',NULL,'2026-01-21 14:18:56.309788',761,761,NULL,'99be97df-3a34-4521-bfdf-f34b5bff699f',227,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',-1,'2026-01-22 14:18:56','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:18:59.518740',NULL,'2026-01-21 14:18:59.840602',762,762,'51daa32984f24d90b50a4cba851c93da','a02364f1-dd38-420a-a1d0-85ffc9adbe41',226,'3efc5d38bf75484d9e4b2aed22003264','snapshots',1,'2026-01-22 14:18:59',NULL),('2026-01-21 14:18:59.520555',NULL,'2026-01-21 14:18:59.840602',763,763,'51daa32984f24d90b50a4cba851c93da','98f09ee3-7498-42cc-bd0e-8aa4f6d375a6',225,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',1,'2026-01-22 14:18:59',NULL),('2026-01-21 14:18:59.670381',NULL,'2026-01-21 14:18:59.840602',764,764,NULL,'2abd1964-59ae-467a-a1f4-61945d769cc1',228,'3efc5d38bf75484d9e4b2aed22003264','snapshots',1,'2026-01-22 14:18:59','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:18:59.672937',NULL,'2026-01-21 14:18:59.840602',765,765,NULL,'1314932f-f9cd-4127-9663-4559ebfac48c',227,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',1,'2026-01-22 14:18:59','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:19:05.763772',NULL,'2026-01-21 14:19:05.791273',766,766,'51daa32984f24d90b50a4cba851c93da','708048c1-f706-4dc7-bde7-ab60f2333e17',226,'3efc5d38bf75484d9e4b2aed22003264','snapshots',-1,'2026-01-22 14:19:05',NULL),('2026-01-21 14:19:05.765836',NULL,'2026-01-21 14:19:05.791273',767,767,'51daa32984f24d90b50a4cba851c93da','4db6c585-d1de-4d97-97ab-867333c49e1c',225,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',-1,'2026-01-22 14:19:05',NULL),('2026-01-21 14:19:05.776584',NULL,'2026-01-21 14:19:05.791273',768,768,NULL,'a13b67cc-86e6-4fc0-888f-9c9dcbbf4efd',228,'3efc5d38bf75484d9e4b2aed22003264','snapshots',-1,'2026-01-22 14:19:05','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:19:05.777698',NULL,'2026-01-21 14:19:05.791273',769,769,NULL,'cf963efb-5ff2-42e2-b1d1-247b70abcdb8',227,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',-1,'2026-01-22 14:19:05','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:19:07.362981',NULL,'2026-01-21 14:19:07.439571',770,770,'b01f23e1df1240dd9949216a2466ed8c','977c2108-507e-407f-be1e-b8f01ef586f9',230,'7be9e3a0119b40f692133210ebe5f9a2','shares',1,'2026-01-22 14:19:07',NULL),('2026-01-21 14:19:07.364205',NULL,'2026-01-21 14:19:07.439571',771,771,'b01f23e1df1240dd9949216a2466ed8c','d10eb3f7-cbe7-4490-9a28-d6e7175948b6',229,'7be9e3a0119b40f692133210ebe5f9a2','gigabytes',1,'2026-01-22 14:19:07',NULL),('2026-01-21 14:19:07.412993',NULL,'2026-01-21 14:19:07.439571',772,772,NULL,'8d8f653f-7a20-47cf-b6c9-8cf93f86b250',148,'7be9e3a0119b40f692133210ebe5f9a2','shares',1,'2026-01-22 14:19:07','6ee0f8f5-aa3a-4c92-817a-3d69c33b511e'),('2026-01-21 14:19:07.415272',NULL,'2026-01-21 14:19:07.439571',773,773,NULL,'cce4cb0f-7987-499c-9ffb-b1a2720cbd26',147,'7be9e3a0119b40f692133210ebe5f9a2','gigabytes',1,'2026-01-22 14:19:07','6ee0f8f5-aa3a-4c92-817a-3d69c33b511e'),('2026-01-21 14:19:09.056413',NULL,'2026-01-21 14:19:09.159611',774,774,'51daa32984f24d90b50a4cba851c93da','46a59714-dc8b-4c79-be4c-ba70a7483384',226,'3efc5d38bf75484d9e4b2aed22003264','snapshots',1,'2026-01-22 14:19:09',NULL),('2026-01-21 14:19:09.057565',NULL,'2026-01-21 14:19:09.159611',775,775,'51daa32984f24d90b50a4cba851c93da','9d233a6b-e59f-4f03-a8ac-cdf7732c6c06',225,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',1,'2026-01-22 14:19:09',NULL),('2026-01-21 14:19:09.083401',NULL,'2026-01-21 14:19:09.159611',776,776,NULL,'ea10386f-d200-4966-a101-0daa0b9072a3',228,'3efc5d38bf75484d9e4b2aed22003264','snapshots',1,'2026-01-22 14:19:09','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:19:09.084514',NULL,'2026-01-21 14:19:09.159611',777,777,NULL,'9185abf5-ff83-42fc-b6df-152f97bb1955',227,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',1,'2026-01-22 14:19:09','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:19:10.001996',NULL,'2026-01-21 14:19:10.129807',778,778,'1bdd99b08fdf48cbae340f6fab64e0de','2cbfe480-9aa3-4f64-95f8-25c6272384bd',231,'3045c953c1f44932b48db800dd54be02','share_networks',1,'2026-01-22 14:19:09',NULL),('2026-01-21 14:19:11.251231',NULL,'2026-01-21 14:19:11.283694',779,779,'1bdd99b08fdf48cbae340f6fab64e0de','7caa0034-3033-4eeb-8509-3519e93548d6',231,'3045c953c1f44932b48db800dd54be02','share_networks',-1,'2026-01-22 14:19:11',NULL),('2026-01-21 14:19:11.464185',NULL,'2026-01-21 14:19:11.528399',780,780,'1bdd99b08fdf48cbae340f6fab64e0de','34770554-8ae8-401d-b1f7-02205f7a4650',231,'3045c953c1f44932b48db800dd54be02','share_networks',1,'2026-01-22 14:19:11',NULL),('2026-01-21 14:19:12.226966',NULL,'2026-01-21 14:19:12.232130',781,781,'1bdd99b08fdf48cbae340f6fab64e0de','a4cb9f81-02cf-422b-ac46-32430564d53d',231,'3045c953c1f44932b48db800dd54be02','share_networks',-1,'2026-01-22 14:19:12',NULL),('2026-01-21 14:19:12.369462',NULL,'2026-01-21 14:19:12.489878',782,782,'1bdd99b08fdf48cbae340f6fab64e0de','95a652ee-0ca0-4139-94fe-a9e5ce512ed3',231,'3045c953c1f44932b48db800dd54be02','share_networks',1,'2026-01-22 14:19:12',NULL),('2026-01-21 14:19:13.117082',NULL,'2026-01-21 14:19:13.143362',783,783,'1bdd99b08fdf48cbae340f6fab64e0de','ecd04ecb-1e99-4c81-9441-370baa69d976',231,'3045c953c1f44932b48db800dd54be02','share_networks',-1,'2026-01-22 14:19:13',NULL),('2026-01-21 14:19:13.330059',NULL,'2026-01-21 14:19:13.347311',784,784,'51daa32984f24d90b50a4cba851c93da','b838b644-97e9-453a-a8bf-c76d57220526',226,'3efc5d38bf75484d9e4b2aed22003264','snapshots',-1,'2026-01-22 14:19:13',NULL),('2026-01-21 14:19:13.331027',NULL,'2026-01-21 14:19:13.347311',785,785,'51daa32984f24d90b50a4cba851c93da','936f3072-b62d-43b3-9f30-4ed23bb90199',225,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',-1,'2026-01-22 14:19:13',NULL),('2026-01-21 14:19:13.335646',NULL,'2026-01-21 14:19:13.347311',786,786,NULL,'6e2b1e89-6dd5-49cb-afa6-626fa4d33dd7',228,'3efc5d38bf75484d9e4b2aed22003264','snapshots',-1,'2026-01-22 14:19:13','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:19:13.336338',NULL,'2026-01-21 14:19:13.347311',787,787,NULL,'70368309-6e61-4461-87c5-9c8de3a3387c',227,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',-1,'2026-01-22 14:19:13','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:19:16.422862',NULL,'2026-01-21 14:19:16.546781',788,788,'51daa32984f24d90b50a4cba851c93da','a9709f50-3baf-4746-a1cc-1cd87ab2f4a5',226,'3efc5d38bf75484d9e4b2aed22003264','snapshots',1,'2026-01-22 14:19:16',NULL),('2026-01-21 14:19:16.424108',NULL,'2026-01-21 14:19:16.546781',789,789,'51daa32984f24d90b50a4cba851c93da','5c65f0e2-0499-4803-98b9-decbcacf7d9b',225,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',1,'2026-01-22 14:19:16',NULL),('2026-01-21 14:19:16.461711',NULL,'2026-01-21 14:19:16.546781',790,790,NULL,'fe05865b-c9de-4ae5-913b-4c2f8a23f541',228,'3efc5d38bf75484d9e4b2aed22003264','snapshots',1,'2026-01-22 14:19:16','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:19:16.463513',NULL,'2026-01-21 14:19:16.546781',791,791,NULL,'b7b05a7e-7af8-4654-abfd-49f85b7029dc',227,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',1,'2026-01-22 14:19:16','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:19:19.669141',NULL,'2026-01-21 14:19:19.700055',792,792,'5e463fc3b37f4ad683d113fe4e8b2d6a','080306b2-ae23-458b-8ad5-9cd1875a1a0a',232,'e5d2b19b5e42472bbc153671b4a835ba','share_networks',1,'2026-01-22 14:19:19',NULL),('2026-01-21 14:19:20.756252',NULL,'2026-01-21 14:19:20.904195',793,793,'5e463fc3b37f4ad683d113fe4e8b2d6a','3a83f86a-8ab3-48bc-9d09-bcd8df338a27',232,'e5d2b19b5e42472bbc153671b4a835ba','share_networks',1,'2026-01-22 14:19:20',NULL),('2026-01-21 14:19:21.639847',NULL,'2026-01-21 14:19:21.650822',794,794,'5e463fc3b37f4ad683d113fe4e8b2d6a','83b15a35-a7c2-4a15-bf5e-0c12713644f8',232,'e5d2b19b5e42472bbc153671b4a835ba','share_networks',-1,'2026-01-22 14:19:21',NULL),('2026-01-21 14:19:21.836890',NULL,'2026-01-21 14:19:21.875800',795,795,'5e463fc3b37f4ad683d113fe4e8b2d6a','404278b2-7c09-4c84-9567-3434806d4134',232,'e5d2b19b5e42472bbc153671b4a835ba','share_networks',1,'2026-01-22 14:19:21',NULL),('2026-01-21 14:19:21.911749',NULL,'2026-01-21 14:19:21.927420',796,796,'51daa32984f24d90b50a4cba851c93da','ec43779d-957d-4e57-a21e-d10167bc8175',226,'3efc5d38bf75484d9e4b2aed22003264','snapshots',-1,'2026-01-22 14:19:21',NULL),('2026-01-21 14:19:21.912537',NULL,'2026-01-21 14:19:21.927420',797,797,'51daa32984f24d90b50a4cba851c93da','4d86efe0-baea-4bb5-950b-6cc0c88fc5a6',225,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',-1,'2026-01-22 14:19:21',NULL),('2026-01-21 14:19:21.918284',NULL,'2026-01-21 14:19:21.927420',798,798,NULL,'ea97583b-1071-46d7-bfac-ff9093ba1b2c',228,'3efc5d38bf75484d9e4b2aed22003264','snapshots',-1,'2026-01-22 14:19:21','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:19:21.919325',NULL,'2026-01-21 14:19:21.927420',799,799,NULL,'ae8cc802-626c-450a-92fc-cf004efe28d1',227,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',-1,'2026-01-22 14:19:21','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:19:22.903980',NULL,'2026-01-21 14:19:22.912401',800,800,'5e463fc3b37f4ad683d113fe4e8b2d6a','289a7371-e8b6-4f43-813c-9873e322d313',232,'e5d2b19b5e42472bbc153671b4a835ba','share_networks',-1,'2026-01-22 14:19:22',NULL),('2026-01-21 14:19:22.977462',NULL,'2026-01-21 14:19:22.995404',801,801,'920083400adf4bf88354be8bd2e50ba1','e821584b-f74b-4a49-9531-0d914841c077',146,'7be9e3a0119b40f692133210ebe5f9a2','shares',-1,'2026-01-22 14:19:22',NULL),('2026-01-21 14:19:22.978318',NULL,'2026-01-21 14:19:22.995404',802,802,'920083400adf4bf88354be8bd2e50ba1','427ef22d-6d0b-4ed7-b225-e77f3dfff3bd',145,'7be9e3a0119b40f692133210ebe5f9a2','gigabytes',-1,'2026-01-22 14:19:22',NULL),('2026-01-21 14:19:22.986043',NULL,'2026-01-21 14:19:22.995404',803,803,NULL,'56fd6af4-f959-44e4-be82-eae80c79f2c3',148,'7be9e3a0119b40f692133210ebe5f9a2','shares',-1,'2026-01-22 14:19:22','6ee0f8f5-aa3a-4c92-817a-3d69c33b511e'),('2026-01-21 14:19:22.987000',NULL,'2026-01-21 14:19:22.995404',804,804,NULL,'1bf7fa2d-64aa-4b2c-82e1-8503c54247d1',147,'7be9e3a0119b40f692133210ebe5f9a2','gigabytes',-1,'2026-01-22 14:19:22','6ee0f8f5-aa3a-4c92-817a-3d69c33b511e'),('2026-01-21 14:19:24.087712',NULL,'2026-01-21 14:19:24.095549',805,805,'5e463fc3b37f4ad683d113fe4e8b2d6a','e3e82ebc-ce43-41a9-94ac-f5b1eadb1525',232,'e5d2b19b5e42472bbc153671b4a835ba','share_networks',-1,'2026-01-22 14:19:24',NULL),('2026-01-21 14:19:26.941414',NULL,'2026-01-21 14:19:27.104734',806,806,'51daa32984f24d90b50a4cba851c93da','8b937ba0-1fec-4e37-97f5-3c2fb3d87154',226,'3efc5d38bf75484d9e4b2aed22003264','snapshots',1,'2026-01-22 14:19:26',NULL),('2026-01-21 14:19:26.943730',NULL,'2026-01-21 14:19:27.104734',807,807,'51daa32984f24d90b50a4cba851c93da','453550df-f65d-4795-ab42-93a3995cd063',225,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',1,'2026-01-22 14:19:26',NULL),('2026-01-21 14:19:26.952846',NULL,'2026-01-21 14:19:27.104734',808,808,NULL,'0144a573-6bff-4d07-8043-cc632fd72a03',228,'3efc5d38bf75484d9e4b2aed22003264','snapshots',1,'2026-01-22 14:19:26','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:19:26.954071',NULL,'2026-01-21 14:19:27.104734',809,809,NULL,'d08255ee-b2d2-4d59-83d2-432318faba7c',227,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',1,'2026-01-22 14:19:26','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:19:33.292929',NULL,'2026-01-21 14:19:33.318792',810,810,'51daa32984f24d90b50a4cba851c93da','0059ae75-f7b4-405e-80e1-19efc89d60e0',226,'3efc5d38bf75484d9e4b2aed22003264','snapshots',-1,'2026-01-22 14:19:33',NULL),('2026-01-21 14:19:33.293851',NULL,'2026-01-21 14:19:33.318792',811,811,'51daa32984f24d90b50a4cba851c93da','87fd03f8-b6d3-4f1e-886e-4d559ccabbee',225,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',-1,'2026-01-22 14:19:33',NULL),('2026-01-21 14:19:33.307832',NULL,'2026-01-21 14:19:33.318792',812,812,NULL,'8874d754-a37a-4459-b04d-150418d78383',228,'3efc5d38bf75484d9e4b2aed22003264','snapshots',-1,'2026-01-22 14:19:33','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:19:33.308643',NULL,'2026-01-21 14:19:33.318792',813,813,NULL,'5bbe061f-3a76-41df-9efb-5efb9be29f44',227,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',-1,'2026-01-22 14:19:33','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:19:41.239234',NULL,'2026-01-21 14:19:41.347925',814,814,'51daa32984f24d90b50a4cba851c93da','76081655-1d60-4b9f-9015-f6187f7a9bde',226,'3efc5d38bf75484d9e4b2aed22003264','snapshots',-1,'2026-01-22 14:19:41',NULL),('2026-01-21 14:19:41.240405',NULL,'2026-01-21 14:19:41.347925',815,815,'51daa32984f24d90b50a4cba851c93da','63477c17-da74-4c59-91d2-f7f72c7a8014',225,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',-1,'2026-01-22 14:19:41',NULL),('2026-01-21 14:19:41.293212',NULL,'2026-01-21 14:19:41.347925',816,816,NULL,'a93a591f-0f3e-4fd9-92d4-030fc50d94ed',228,'3efc5d38bf75484d9e4b2aed22003264','snapshots',-1,'2026-01-22 14:19:41','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:19:41.295579',NULL,'2026-01-21 14:19:41.347925',817,817,NULL,'37ddf023-24af-49df-96f2-5004e98b8907',227,'3efc5d38bf75484d9e4b2aed22003264','snapshot_gigabytes',-1,'2026-01-22 14:19:41','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:19:43.446830',NULL,'2026-01-21 14:19:43.469292',818,818,'51daa32984f24d90b50a4cba851c93da','a63f0343-4caa-43e7-80be-9906e982910b',222,'3efc5d38bf75484d9e4b2aed22003264','shares',-1,'2026-01-22 14:19:43',NULL),('2026-01-21 14:19:43.447901',NULL,'2026-01-21 14:19:43.469292',819,819,'51daa32984f24d90b50a4cba851c93da','07dc5fff-f675-498c-acc6-229bb95d7eb4',221,'3efc5d38bf75484d9e4b2aed22003264','gigabytes',-1,'2026-01-22 14:19:43',NULL),('2026-01-21 14:19:43.456147',NULL,'2026-01-21 14:19:43.469292',820,820,NULL,'4928df87-25b0-41f4-9dbe-f32816b0d706',224,'3efc5d38bf75484d9e4b2aed22003264','shares',-1,'2026-01-22 14:19:43','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:19:43.457424',NULL,'2026-01-21 14:19:43.469292',821,821,NULL,'42f9f4a7-aeef-4cc3-8bb6-8edd42d9e939',223,'3efc5d38bf75484d9e4b2aed22003264','gigabytes',-1,'2026-01-22 14:19:43','fce16d73-418d-491b-b08b-4701c62ff5bc'),('2026-01-21 14:20:14.235502',NULL,'2026-01-21 14:20:14.282421',822,822,'6ec525d992e341d68f12ae0cac568446','61bd81dd-b87b-49b3-b2c0-56300eb74a57',233,'273b0f88119142bb88f70bd49708607c','share_networks',1,'2026-01-22 14:20:14',NULL),('2026-01-21 14:20:14.528828',NULL,'2026-01-21 14:20:14.534719',823,823,'6ec525d992e341d68f12ae0cac568446','47e9bd62-66e9-4a59-a181-cbfa739f344b',233,'273b0f88119142bb88f70bd49708607c','share_networks',-1,'2026-01-22 14:20:14',NULL),('2026-01-21 14:20:14.818757',NULL,'2026-01-21 14:20:14.852450',824,824,'6ec525d992e341d68f12ae0cac568446','5a472f35-da3e-45ee-a6c4-64619c5b5ec8',233,'273b0f88119142bb88f70bd49708607c','share_networks',1,'2026-01-22 14:20:14',NULL),('2026-01-21 14:20:15.508447',NULL,'2026-01-21 14:20:15.515675',825,825,'6ec525d992e341d68f12ae0cac568446','9818c01a-a21d-4e87-9093-f153f6aa4cbf',233,'273b0f88119142bb88f70bd49708607c','share_networks',-1,'2026-01-22 14:20:15',NULL),('2026-01-21 14:20:15.862031',NULL,'2026-01-21 14:20:15.891702',826,826,'6ec525d992e341d68f12ae0cac568446','c1c544d3-f923-4c76-a0d9-ffb9f2597765',233,'273b0f88119142bb88f70bd49708607c','share_networks',1,'2026-01-22 14:20:15',NULL),('2026-01-21 14:20:16.053478',NULL,'2026-01-21 14:20:16.059001',827,827,'6ec525d992e341d68f12ae0cac568446','8e326d83-0448-4b6f-bee8-f90e2a226041',233,'273b0f88119142bb88f70bd49708607c','share_networks',-1,'2026-01-22 14:20:16',NULL),('2026-01-21 14:20:29.307008',NULL,'2026-01-21 14:20:29.344883',828,828,'8f91d7fab0ee4a86a798bfda435f3ff4','7b89ddb7-a102-4a10-81be-e0837eb94120',235,'265433c915284e308788d3048cf90078','shares',1,'2026-01-22 14:20:29',NULL),('2026-01-21 14:20:29.308408',NULL,'2026-01-21 14:20:29.344883',829,829,'8f91d7fab0ee4a86a798bfda435f3ff4','85ea0651-76b1-4997-992e-4979fe2ba0aa',234,'265433c915284e308788d3048cf90078','gigabytes',1,'2026-01-22 14:20:29',NULL),('2026-01-21 14:20:29.318633',NULL,'2026-01-21 14:20:29.344883',830,830,NULL,'52d38a78-47ac-415f-83a2-ac36afacf6a2',237,'265433c915284e308788d3048cf90078','shares',1,'2026-01-22 14:20:29','703cfc70-9932-41ed-8a49-185d2994a4af'),('2026-01-21 14:20:29.319974',NULL,'2026-01-21 14:20:29.344883',831,831,NULL,'2fb42e8c-f916-4f22-8b91-750ce60cf3ea',236,'265433c915284e308788d3048cf90078','gigabytes',1,'2026-01-22 14:20:29','703cfc70-9932-41ed-8a49-185d2994a4af'),('2026-01-21 14:20:33.596200',NULL,'2026-01-21 14:20:33.629855',832,832,'8f91d7fab0ee4a86a798bfda435f3ff4','b04b2394-a681-4b23-8032-80778ca54587',235,'265433c915284e308788d3048cf90078','shares',1,'2026-01-22 14:20:33',NULL),('2026-01-21 14:20:33.597927',NULL,'2026-01-21 14:20:33.629855',833,833,'8f91d7fab0ee4a86a798bfda435f3ff4','c1bfeba5-71fe-4ced-9868-5f6f7d08a438',234,'265433c915284e308788d3048cf90078','gigabytes',1,'2026-01-22 14:20:33',NULL),('2026-01-21 14:20:33.604387',NULL,'2026-01-21 14:20:33.629855',834,834,NULL,'604a2d60-a81f-46ca-96ad-0d4e71dcc594',237,'265433c915284e308788d3048cf90078','shares',1,'2026-01-22 14:20:33','703cfc70-9932-41ed-8a49-185d2994a4af'),('2026-01-21 14:20:33.605939',NULL,'2026-01-21 14:20:33.629855',835,835,NULL,'a9672438-87c8-4476-b08b-69073cbb8aa6',236,'265433c915284e308788d3048cf90078','gigabytes',1,'2026-01-22 14:20:33','703cfc70-9932-41ed-8a49-185d2994a4af'),('2026-01-21 14:20:37.557213',NULL,'2026-01-21 14:20:37.589252',836,836,'8f91d7fab0ee4a86a798bfda435f3ff4','5f01d73c-7254-4c3d-8405-67853433e04e',235,'265433c915284e308788d3048cf90078','shares',1,'2026-01-22 14:20:37',NULL),('2026-01-21 14:20:37.558724',NULL,'2026-01-21 14:20:37.589252',837,837,'8f91d7fab0ee4a86a798bfda435f3ff4','72541b80-456a-4a0f-9bce-0b9cffb3fa2f',234,'265433c915284e308788d3048cf90078','gigabytes',1,'2026-01-22 14:20:37',NULL),('2026-01-21 14:20:37.566074',NULL,'2026-01-21 14:20:37.589252',838,838,NULL,'2828b0d3-ac1d-4f53-b7fa-350ca913db16',237,'265433c915284e308788d3048cf90078','shares',1,'2026-01-22 14:20:37','703cfc70-9932-41ed-8a49-185d2994a4af'),('2026-01-21 14:20:37.567568',NULL,'2026-01-21 14:20:37.589252',839,839,NULL,'997f9bf9-568e-4af1-a192-b088bae5ea24',236,'265433c915284e308788d3048cf90078','gigabytes',1,'2026-01-22 14:20:37','703cfc70-9932-41ed-8a49-185d2994a4af'),('2026-01-21 14:20:41.683419',NULL,'2026-01-21 14:20:41.907376',840,840,'8f91d7fab0ee4a86a798bfda435f3ff4','2047e3ef-b835-4dc4-aad4-b85a45152934',235,'265433c915284e308788d3048cf90078','shares',1,'2026-01-22 14:20:41',NULL),('2026-01-21 14:20:41.684948',NULL,'2026-01-21 14:20:41.907376',841,841,'8f91d7fab0ee4a86a798bfda435f3ff4','054a22d9-a694-40fb-a956-90e5416cf5b2',234,'265433c915284e308788d3048cf90078','gigabytes',1,'2026-01-22 14:20:41',NULL),('2026-01-21 14:20:41.827401',NULL,'2026-01-21 14:20:41.907376',842,842,NULL,'6b479b82-503c-4378-8fa8-4a5695aa945c',237,'265433c915284e308788d3048cf90078','shares',1,'2026-01-22 14:20:41','703cfc70-9932-41ed-8a49-185d2994a4af'),('2026-01-21 14:20:41.828861',NULL,'2026-01-21 14:20:41.907376',843,843,NULL,'0ee956f2-4e36-4661-9d53-cf9e818ec1fe',236,'265433c915284e308788d3048cf90078','gigabytes',1,'2026-01-22 14:20:41','703cfc70-9932-41ed-8a49-185d2994a4af'),('2026-01-21 14:20:46.990321',NULL,'2026-01-21 14:20:47.171022',844,844,'8f91d7fab0ee4a86a798bfda435f3ff4','32693f9e-7e04-404b-9139-c8b36690b23b',235,'265433c915284e308788d3048cf90078','shares',-1,'2026-01-22 14:20:46',NULL),('2026-01-21 14:20:46.991327',NULL,'2026-01-21 14:20:47.171022',845,845,'8f91d7fab0ee4a86a798bfda435f3ff4','e976e96a-ef13-4291-8cb9-c333c7248706',234,'265433c915284e308788d3048cf90078','gigabytes',-1,'2026-01-22 14:20:46',NULL),('2026-01-21 14:20:47.111806',NULL,'2026-01-21 14:20:47.171022',846,846,NULL,'23979fa5-4a7d-43b2-b238-351787cade03',237,'265433c915284e308788d3048cf90078','shares',-1,'2026-01-22 14:20:46','703cfc70-9932-41ed-8a49-185d2994a4af'),('2026-01-21 14:20:47.112544',NULL,'2026-01-21 14:20:47.171022',847,847,NULL,'ff0085be-61d2-426c-91c8-32fead5183d7',236,'265433c915284e308788d3048cf90078','gigabytes',-1,'2026-01-22 14:20:46','703cfc70-9932-41ed-8a49-185d2994a4af'),('2026-01-21 14:20:50.379442',NULL,'2026-01-21 14:20:50.401378',848,848,'8f91d7fab0ee4a86a798bfda435f3ff4','d0cbb660-f9ea-4e0b-a371-672afe42e0f0',235,'265433c915284e308788d3048cf90078','shares',-1,'2026-01-22 14:20:50',NULL),('2026-01-21 14:20:50.380148',NULL,'2026-01-21 14:20:50.401378',849,849,'8f91d7fab0ee4a86a798bfda435f3ff4','ddad56b4-4d19-4a98-b865-72904b12eec8',234,'265433c915284e308788d3048cf90078','gigabytes',-1,'2026-01-22 14:20:50',NULL),('2026-01-21 14:20:50.390674',NULL,'2026-01-21 14:20:50.401378',850,850,NULL,'2b6fca93-4944-429a-a6ca-d3f59b2b2ac8',237,'265433c915284e308788d3048cf90078','shares',-1,'2026-01-22 14:20:50','703cfc70-9932-41ed-8a49-185d2994a4af'),('2026-01-21 14:20:50.391439',NULL,'2026-01-21 14:20:50.401378',851,851,NULL,'740f15dc-9379-44b3-8f2e-7678b3b25669',236,'265433c915284e308788d3048cf90078','gigabytes',-1,'2026-01-22 14:20:50','703cfc70-9932-41ed-8a49-185d2994a4af'),('2026-01-21 14:20:53.769884',NULL,'2026-01-21 14:20:53.785496',852,852,'8f91d7fab0ee4a86a798bfda435f3ff4','0b9a5fb4-3fac-486c-888e-7c3769b4cc6d',235,'265433c915284e308788d3048cf90078','shares',-1,'2026-01-22 14:20:53',NULL),('2026-01-21 14:20:53.771557',NULL,'2026-01-21 14:20:53.785496',853,853,'8f91d7fab0ee4a86a798bfda435f3ff4','96ecdc3f-9c2b-4f30-8e83-88d06dc618db',234,'265433c915284e308788d3048cf90078','gigabytes',-1,'2026-01-22 14:20:53',NULL),('2026-01-21 14:20:53.776770',NULL,'2026-01-21 14:20:53.785496',854,854,NULL,'a2c04fda-5d7c-4df8-a68b-7f2d136fbd65',237,'265433c915284e308788d3048cf90078','shares',-1,'2026-01-22 14:20:53','703cfc70-9932-41ed-8a49-185d2994a4af'),('2026-01-21 14:20:53.777609',NULL,'2026-01-21 14:20:53.785496',855,855,NULL,'21b942dd-1306-4697-aca4-c25b5fd60b41',236,'265433c915284e308788d3048cf90078','gigabytes',-1,'2026-01-22 14:20:53','703cfc70-9932-41ed-8a49-185d2994a4af'),('2026-01-21 14:20:57.324857',NULL,'2026-01-21 14:20:57.432069',856,856,'8f91d7fab0ee4a86a798bfda435f3ff4','d1bd0bb5-045a-41c8-b1fa-796b14f4d2c2',235,'265433c915284e308788d3048cf90078','shares',-1,'2026-01-22 14:20:57',NULL),('2026-01-21 14:20:57.374148',NULL,'2026-01-21 14:20:57.432069',857,857,'8f91d7fab0ee4a86a798bfda435f3ff4','be19debd-c8bd-417c-b195-b6592545f1db',234,'265433c915284e308788d3048cf90078','gigabytes',-1,'2026-01-22 14:20:57',NULL),('2026-01-21 14:20:57.411153',NULL,'2026-01-21 14:20:57.432069',858,858,NULL,'5687f11e-2e61-460b-a3ed-3474cc6a47ec',237,'265433c915284e308788d3048cf90078','shares',-1,'2026-01-22 14:20:57','703cfc70-9932-41ed-8a49-185d2994a4af'),('2026-01-21 14:20:57.411968',NULL,'2026-01-21 14:20:57.432069',859,859,NULL,'eb14f356-0ce2-4620-970e-94594a11d8d0',236,'265433c915284e308788d3048cf90078','gigabytes',-1,'2026-01-22 14:20:57','703cfc70-9932-41ed-8a49-185d2994a4af'),('2026-01-21 14:21:12.420796',NULL,'2026-01-21 14:21:12.463948',860,860,'67dae406f3fa410bac4003400c38ab9e','48d1d247-1188-44d9-947d-440d4e0af8ff',239,'41d4aecafc20406482129223e7dd4624','shares',1,'2026-01-22 14:21:12',NULL),('2026-01-21 14:21:12.422294',NULL,'2026-01-21 14:21:12.463948',861,861,'67dae406f3fa410bac4003400c38ab9e','6ee96f26-902e-4416-ade8-8fc0a52f1edc',238,'41d4aecafc20406482129223e7dd4624','gigabytes',1,'2026-01-22 14:21:12',NULL),('2026-01-21 14:21:12.432718',NULL,'2026-01-21 14:21:12.463948',862,862,NULL,'fd586e44-caba-4699-a582-ab03715aaa1f',241,'41d4aecafc20406482129223e7dd4624','shares',1,'2026-01-22 14:21:12','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:21:12.434079',NULL,'2026-01-21 14:21:12.463948',863,863,NULL,'d423ba4e-c33f-4114-a1b2-245694bc106e',240,'41d4aecafc20406482129223e7dd4624','gigabytes',1,'2026-01-22 14:21:12','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:21:16.172567',NULL,'2026-01-21 14:21:16.351347',864,864,'67dae406f3fa410bac4003400c38ab9e','66b245d8-864b-4f86-94a7-e964fcffc740',243,'41d4aecafc20406482129223e7dd4624','snapshots',1,'2026-01-22 14:21:16',NULL),('2026-01-21 14:21:16.173793',NULL,'2026-01-21 14:21:16.351347',865,865,'67dae406f3fa410bac4003400c38ab9e','fa4ec807-8dc1-444c-866a-c45fb5e2a641',242,'41d4aecafc20406482129223e7dd4624','snapshot_gigabytes',1,'2026-01-22 14:21:16',NULL),('2026-01-21 14:21:16.188195',NULL,'2026-01-21 14:21:16.351347',866,866,NULL,'057c0f44-b308-4d09-9c42-b036255ccf59',245,'41d4aecafc20406482129223e7dd4624','snapshots',1,'2026-01-22 14:21:16','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:21:16.189373',NULL,'2026-01-21 14:21:16.351347',867,867,NULL,'9ec43b1c-e559-4691-b064-88176dd844b9',244,'41d4aecafc20406482129223e7dd4624','snapshot_gigabytes',1,'2026-01-22 14:21:16','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:21:19.802882',NULL,'2026-01-21 14:21:19.840866',868,868,'67dae406f3fa410bac4003400c38ab9e','571cddb0-bb6b-48b1-bbde-a8fc51dc1ad6',239,'41d4aecafc20406482129223e7dd4624','shares',1,'2026-01-22 14:21:19',NULL),('2026-01-21 14:21:19.804920',NULL,'2026-01-21 14:21:19.840866',869,869,'67dae406f3fa410bac4003400c38ab9e','b77acb8b-c2cc-481d-b3dd-29e08404821d',238,'41d4aecafc20406482129223e7dd4624','gigabytes',1,'2026-01-22 14:21:19',NULL),('2026-01-21 14:21:19.811935',NULL,'2026-01-21 14:21:19.840866',870,870,NULL,'2bbf7410-d941-496b-82c6-1c78bcb8914d',241,'41d4aecafc20406482129223e7dd4624','shares',1,'2026-01-22 14:21:19','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:21:19.813130',NULL,'2026-01-21 14:21:19.840866',871,871,NULL,'057e9777-0433-448a-ab8a-32d613f77906',240,'41d4aecafc20406482129223e7dd4624','gigabytes',1,'2026-01-22 14:21:19','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:22:09.899047',NULL,'2026-01-21 14:22:09.952696',872,872,'67dae406f3fa410bac4003400c38ab9e','5195779d-a221-4006-b99c-464368ce036d',239,'41d4aecafc20406482129223e7dd4624','shares',1,'2026-01-22 14:22:09',NULL),('2026-01-21 14:22:09.900526',NULL,'2026-01-21 14:22:09.952696',873,873,'67dae406f3fa410bac4003400c38ab9e','eefdf596-9172-4dda-bb51-53598525f92c',238,'41d4aecafc20406482129223e7dd4624','gigabytes',1,'2026-01-22 14:22:09',NULL),('2026-01-21 14:22:09.911851',NULL,'2026-01-21 14:22:09.952696',874,874,NULL,'30ab8e13-fa73-4e36-93d5-9cc267c817ec',241,'41d4aecafc20406482129223e7dd4624','shares',1,'2026-01-22 14:22:09','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:22:09.913369',NULL,'2026-01-21 14:22:09.952696',875,875,NULL,'ff1dc114-bb94-4706-ae22-1951409d0332',240,'41d4aecafc20406482129223e7dd4624','gigabytes',1,'2026-01-22 14:22:09','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:22:13.366728',NULL,'2026-01-21 14:22:14.127979',876,876,'67dae406f3fa410bac4003400c38ab9e','c236649b-3c59-44f4-8101-c61b8a32432b',238,'41d4aecafc20406482129223e7dd4624','gigabytes',1,'2026-01-22 14:22:13',NULL),('2026-01-21 14:22:13.511459',NULL,'2026-01-21 14:22:14.127979',877,877,NULL,'00900fd8-3a4e-4e13-a586-06ba9dae0814',240,'41d4aecafc20406482129223e7dd4624','gigabytes',1,'2026-01-22 14:22:13','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:22:18.024125',NULL,'2026-01-21 14:22:18.056715',878,878,'67dae406f3fa410bac4003400c38ab9e','c5ea3459-aad3-413c-a72a-1bb4e1fa3380',239,'41d4aecafc20406482129223e7dd4624','shares',-1,'2026-01-22 14:22:17',NULL),('2026-01-21 14:22:18.029901',NULL,'2026-01-21 14:22:18.056715',879,879,'67dae406f3fa410bac4003400c38ab9e','b9f120b3-4e29-4c6b-92f9-9978d56c620b',238,'41d4aecafc20406482129223e7dd4624','gigabytes',-2,'2026-01-22 14:22:17',NULL),('2026-01-21 14:22:18.047281',NULL,'2026-01-21 14:22:18.056715',880,880,NULL,'a27ea4b0-2477-4545-a3e2-ca568e1b5ed3',241,'41d4aecafc20406482129223e7dd4624','shares',-1,'2026-01-22 14:22:17','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:22:18.048520',NULL,'2026-01-21 14:22:18.056715',881,881,NULL,'c5e2dbe9-2717-4dc3-a4fa-a7a11e6efbc4',240,'41d4aecafc20406482129223e7dd4624','gigabytes',-2,'2026-01-22 14:22:17','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:22:26.670585',NULL,'2026-01-21 14:22:26.798682',882,882,'67dae406f3fa410bac4003400c38ab9e','9f22fcb0-52a0-4168-83f4-0964a29088f1',239,'41d4aecafc20406482129223e7dd4624','shares',1,'2026-01-22 14:22:26',NULL),('2026-01-21 14:22:26.672163',NULL,'2026-01-21 14:22:26.798682',883,883,'67dae406f3fa410bac4003400c38ab9e','58f8e16a-88a8-4866-a7c6-eecf867f8f28',238,'41d4aecafc20406482129223e7dd4624','gigabytes',2,'2026-01-22 14:22:26',NULL),('2026-01-21 14:22:26.723398',NULL,'2026-01-21 14:22:26.798682',884,884,NULL,'c304c48f-746d-42ce-b63e-7f70e6af6f9e',241,'41d4aecafc20406482129223e7dd4624','shares',1,'2026-01-22 14:22:26','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:22:26.724843',NULL,'2026-01-21 14:22:26.798682',885,885,NULL,'92dfafba-cb40-4fd0-a006-d37370e54baf',240,'41d4aecafc20406482129223e7dd4624','gigabytes',2,'2026-01-22 14:22:26','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:22:30.728335',NULL,'2026-01-21 14:22:31.591774',886,886,'67dae406f3fa410bac4003400c38ab9e','ce6d0a38-147b-4bab-8562-6ff67a77ee34',238,'41d4aecafc20406482129223e7dd4624','gigabytes',-1,'2026-01-22 14:22:30',NULL),('2026-01-21 14:22:31.032719',NULL,'2026-01-21 14:22:31.591774',887,887,NULL,'e1fd2552-19a3-479b-af35-ac8ab15bb837',240,'41d4aecafc20406482129223e7dd4624','gigabytes',-1,'2026-01-22 14:22:30','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:22:34.700704',NULL,'2026-01-21 14:22:34.724631',888,888,'67dae406f3fa410bac4003400c38ab9e','b3b25abb-15e7-4663-8661-995824bd2880',239,'41d4aecafc20406482129223e7dd4624','shares',-1,'2026-01-22 14:22:34',NULL),('2026-01-21 14:22:34.701840',NULL,'2026-01-21 14:22:34.724631',889,889,'67dae406f3fa410bac4003400c38ab9e','a5a5318e-04e3-4fc2-86ee-04bdf0db1b8a',238,'41d4aecafc20406482129223e7dd4624','gigabytes',-1,'2026-01-22 14:22:34',NULL),('2026-01-21 14:22:34.711405',NULL,'2026-01-21 14:22:34.724631',890,890,NULL,'4aa6643c-641c-4847-91bb-4bbc9ca7b84a',241,'41d4aecafc20406482129223e7dd4624','shares',-1,'2026-01-22 14:22:34','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:22:34.712882',NULL,'2026-01-21 14:22:34.724631',891,891,NULL,'7c8813eb-1cf6-45f7-961f-4ee534730634',240,'41d4aecafc20406482129223e7dd4624','gigabytes',-1,'2026-01-22 14:22:34','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:22:37.794690',NULL,'2026-01-21 14:22:43.128674',892,892,'67dae406f3fa410bac4003400c38ab9e','99ed7ca2-2c10-49f8-a268-ded1507c3435',239,'41d4aecafc20406482129223e7dd4624','shares',1,'2026-01-22 14:22:37',NULL),('2026-01-21 14:22:37.796150',NULL,'2026-01-21 14:22:43.128674',893,893,'67dae406f3fa410bac4003400c38ab9e','b436e240-f5be-49c3-af3b-e79fb5b40305',238,'41d4aecafc20406482129223e7dd4624','gigabytes',1,'2026-01-22 14:22:37',NULL),('2026-01-21 14:22:41.696678',NULL,'2026-01-21 14:22:43.128674',894,894,NULL,'618acceb-1423-4c02-90df-3a24f0713dae',241,'41d4aecafc20406482129223e7dd4624','shares',1,'2026-01-22 14:22:37','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:22:41.698218',NULL,'2026-01-21 14:22:43.128674',895,895,NULL,'53a077d0-c6ac-495a-9213-8a18af0d75cf',240,'41d4aecafc20406482129223e7dd4624','gigabytes',1,'2026-01-22 14:22:37','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:22:49.029574',NULL,'2026-01-21 14:22:49.087556',896,896,'67dae406f3fa410bac4003400c38ab9e','8a299ce6-3f47-43ff-9ee4-9d556a0d53f6',239,'41d4aecafc20406482129223e7dd4624','shares',-1,'2026-01-22 14:22:48',NULL),('2026-01-21 14:22:49.030436',NULL,'2026-01-21 14:22:49.087556',897,897,'67dae406f3fa410bac4003400c38ab9e','b4baceea-107c-4d04-bcd7-5bcde61fec73',238,'41d4aecafc20406482129223e7dd4624','gigabytes',-1,'2026-01-22 14:22:48',NULL),('2026-01-21 14:22:49.076549',NULL,'2026-01-21 14:22:49.087556',898,898,NULL,'c81168c2-9bc8-44db-b7d7-2dc80af3c996',241,'41d4aecafc20406482129223e7dd4624','shares',-1,'2026-01-22 14:22:48','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:22:49.077646',NULL,'2026-01-21 14:22:49.087556',899,899,NULL,'1be21b69-d0c5-4b48-9351-38d6dfdf9eca',240,'41d4aecafc20406482129223e7dd4624','gigabytes',-1,'2026-01-22 14:22:48','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:22:52.616313',NULL,'2026-01-21 14:22:52.763799',900,900,'67dae406f3fa410bac4003400c38ab9e','d69b4eed-f50e-4e28-9e4c-310f6b75b70b',239,'41d4aecafc20406482129223e7dd4624','shares',-1,'2026-01-22 14:22:52',NULL),('2026-01-21 14:22:52.617079',NULL,'2026-01-21 14:22:52.763799',901,901,'67dae406f3fa410bac4003400c38ab9e','a7a60e74-ab5d-4016-a8bd-2c143c3c37ce',238,'41d4aecafc20406482129223e7dd4624','gigabytes',-1,'2026-01-22 14:22:52',NULL),('2026-01-21 14:22:52.686763',NULL,'2026-01-21 14:22:52.763799',902,902,NULL,'24b6a7ab-a913-4cd1-a843-bfca57a553c4',241,'41d4aecafc20406482129223e7dd4624','shares',-1,'2026-01-22 14:22:52','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:22:52.687577',NULL,'2026-01-21 14:22:52.763799',903,903,NULL,'94713932-6737-44ae-aa90-abe74a5f3ba6',240,'41d4aecafc20406482129223e7dd4624','gigabytes',-1,'2026-01-22 14:22:52','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:22:56.177365',NULL,'2026-01-21 14:22:56.219974',904,904,'67dae406f3fa410bac4003400c38ab9e','d30a9ffc-209a-49e2-aeff-7122d81fcce8',243,'41d4aecafc20406482129223e7dd4624','snapshots',-1,'2026-01-22 14:22:56',NULL),('2026-01-21 14:22:56.178336',NULL,'2026-01-21 14:22:56.219974',905,905,'67dae406f3fa410bac4003400c38ab9e','21e82dda-71b7-4758-b00e-26a28f4c4ad6',242,'41d4aecafc20406482129223e7dd4624','snapshot_gigabytes',-1,'2026-01-22 14:22:56',NULL),('2026-01-21 14:22:56.195940',NULL,'2026-01-21 14:22:56.219974',906,906,NULL,'c77bed32-c843-4ddd-976c-46e8c3019366',245,'41d4aecafc20406482129223e7dd4624','snapshots',-1,'2026-01-22 14:22:56','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:22:56.196911',NULL,'2026-01-21 14:22:56.219974',907,907,NULL,'d7fe6070-839a-4259-a0f9-18e2dda9a93e',244,'41d4aecafc20406482129223e7dd4624','snapshot_gigabytes',-1,'2026-01-22 14:22:56','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:22:59.643730',NULL,'2026-01-21 14:22:59.912866',908,908,'67dae406f3fa410bac4003400c38ab9e','f7f919cf-1e8b-4beb-8d52-01c3c1f3d79d',239,'41d4aecafc20406482129223e7dd4624','shares',-1,'2026-01-22 14:22:59',NULL),('2026-01-21 14:22:59.644867',NULL,'2026-01-21 14:22:59.912866',909,909,'67dae406f3fa410bac4003400c38ab9e','aa938eaa-8b15-4fd4-9cb7-bace46772fda',238,'41d4aecafc20406482129223e7dd4624','gigabytes',-1,'2026-01-22 14:22:59',NULL),('2026-01-21 14:22:59.831436',NULL,'2026-01-21 14:22:59.912866',910,910,NULL,'b5e55025-8ebe-41f4-a689-77a441192f88',241,'41d4aecafc20406482129223e7dd4624','shares',-1,'2026-01-22 14:22:59','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:22:59.832925',NULL,'2026-01-21 14:22:59.912866',911,911,NULL,'91813f90-ba93-409b-bcfc-64f01024fdaa',240,'41d4aecafc20406482129223e7dd4624','gigabytes',-1,'2026-01-22 14:22:59','cf23d5d3-0f2f-42ba-aef6-7861fed7457c'),('2026-01-21 14:23:26.681134',NULL,'2026-01-21 14:23:26.838435',912,912,'40585f18d2e84161b8eca432bf37306f','d5dd897b-92ac-4fdc-940f-5a5ef8bfb42d',247,'18bcd7a466594b3abec112774943eca1','shares',1,'2026-01-22 14:23:26',NULL),('2026-01-21 14:23:26.682273',NULL,'2026-01-21 14:23:26.838435',913,913,'40585f18d2e84161b8eca432bf37306f','b8774252-30d2-4b41-8268-abde24bb0e13',246,'18bcd7a466594b3abec112774943eca1','gigabytes',1,'2026-01-22 14:23:26',NULL),('2026-01-21 14:23:26.720019',NULL,'2026-01-21 14:23:26.838435',914,914,NULL,'2677267c-9bdc-437f-9fab-3b5a4d1e7bbb',249,'18bcd7a466594b3abec112774943eca1','shares',1,'2026-01-22 14:23:26','a1bc5a3b-4487-4ec2-9108-ad6c89a426e4'),('2026-01-21 14:23:26.721345',NULL,'2026-01-21 14:23:26.838435',915,915,NULL,'7cc23e77-d835-44aa-9803-43eba01e0d2f',248,'18bcd7a466594b3abec112774943eca1','gigabytes',1,'2026-01-22 14:23:26','a1bc5a3b-4487-4ec2-9108-ad6c89a426e4'),('2026-01-21 14:23:40.246235',NULL,'2026-01-21 14:23:40.892112',916,916,'40585f18d2e84161b8eca432bf37306f','beacfc82-3236-4ebc-a4c2-efd34819a85b',251,'18bcd7a466594b3abec112774943eca1','snapshots',1,'2026-01-22 14:23:40',NULL),('2026-01-21 14:23:40.248219',NULL,'2026-01-21 14:23:40.892112',917,917,'40585f18d2e84161b8eca432bf37306f','dcda79fc-37d0-4f69-85c9-50816da7722d',250,'18bcd7a466594b3abec112774943eca1','snapshot_gigabytes',1,'2026-01-22 14:23:40',NULL),('2026-01-21 14:23:40.543438',NULL,'2026-01-21 14:23:40.892112',918,918,NULL,'25e1f0ed-d710-4683-b37d-42a9b47b4475',253,'18bcd7a466594b3abec112774943eca1','snapshots',1,'2026-01-22 14:23:40','a1bc5a3b-4487-4ec2-9108-ad6c89a426e4'),('2026-01-21 14:23:40.544733',NULL,'2026-01-21 14:23:40.892112',919,919,NULL,'37f8eaf2-1206-41d7-be52-c719961b032e',252,'18bcd7a466594b3abec112774943eca1','snapshot_gigabytes',1,'2026-01-22 14:23:40','a1bc5a3b-4487-4ec2-9108-ad6c89a426e4'),('2026-01-21 14:23:48.192699',NULL,'2026-01-21 14:23:48.333494',920,920,'40585f18d2e84161b8eca432bf37306f','48df032f-952f-4ce8-8e83-ec6d6ad01e0f',251,'18bcd7a466594b3abec112774943eca1','snapshots',-1,'2026-01-22 14:23:48',NULL),('2026-01-21 14:23:48.193569',NULL,'2026-01-21 14:23:48.333494',921,921,'40585f18d2e84161b8eca432bf37306f','eafd0f6b-771f-4d21-987c-807f40f1398b',250,'18bcd7a466594b3abec112774943eca1','snapshot_gigabytes',-1,'2026-01-22 14:23:48',NULL),('2026-01-21 14:23:48.245370',NULL,'2026-01-21 14:23:48.333494',922,922,NULL,'7cd67eb3-590d-44b2-940d-2e8623bbdf29',253,'18bcd7a466594b3abec112774943eca1','snapshots',-1,'2026-01-22 14:23:48','a1bc5a3b-4487-4ec2-9108-ad6c89a426e4'),('2026-01-21 14:23:48.246101',NULL,'2026-01-21 14:23:48.333494',923,923,NULL,'1042a530-e2cc-4a37-9205-6076ef36a7d3',252,'18bcd7a466594b3abec112774943eca1','snapshot_gigabytes',-1,'2026-01-22 14:23:48','a1bc5a3b-4487-4ec2-9108-ad6c89a426e4'),('2026-01-21 14:23:52.120266',NULL,'2026-01-21 14:23:52.476195',924,924,'40585f18d2e84161b8eca432bf37306f','dadc4558-d645-4255-8754-d5e969b964ed',247,'18bcd7a466594b3abec112774943eca1','shares',-1,'2026-01-22 14:23:52',NULL),('2026-01-21 14:23:52.121002',NULL,'2026-01-21 14:23:52.476195',925,925,'40585f18d2e84161b8eca432bf37306f','3f32e1e2-585b-456b-98bd-c89f3d36ac1d',246,'18bcd7a466594b3abec112774943eca1','gigabytes',-1,'2026-01-22 14:23:52',NULL),('2026-01-21 14:23:52.221630',NULL,'2026-01-21 14:23:52.476195',926,926,NULL,'09bf96ec-d364-4b0f-9d10-2d23cf529dac',249,'18bcd7a466594b3abec112774943eca1','shares',-1,'2026-01-22 14:23:52','a1bc5a3b-4487-4ec2-9108-ad6c89a426e4'),('2026-01-21 14:23:52.222476',NULL,'2026-01-21 14:23:52.476195',927,927,NULL,'46c13740-1be4-4423-b057-9078050698f4',248,'18bcd7a466594b3abec112774943eca1','gigabytes',-1,'2026-01-22 14:23:52','a1bc5a3b-4487-4ec2-9108-ad6c89a426e4'),('2026-01-21 14:24:25.136017',NULL,'2026-01-21 14:24:25.179538',928,928,'37b3bbc0092f402c82354dc1111facd4','3331d07a-2580-4397-9e52-b19269927604',255,'a4f094a58f4542e2ab299637736993f9','shares',1,'2026-01-22 14:24:25',NULL),('2026-01-21 14:24:25.137302',NULL,'2026-01-21 14:24:25.179538',929,929,'37b3bbc0092f402c82354dc1111facd4','737b39c6-1dc0-4e71-9de3-980e9a1dbca8',254,'a4f094a58f4542e2ab299637736993f9','gigabytes',2,'2026-01-22 14:24:25',NULL),('2026-01-21 14:24:25.151405',NULL,'2026-01-21 14:24:25.179538',930,930,NULL,'6fcf9dad-467e-4af9-876c-793985f9d259',257,'a4f094a58f4542e2ab299637736993f9','shares',1,'2026-01-22 14:24:25','f7db249e-6360-4f95-914d-c75a6989e840'),('2026-01-21 14:24:25.152844',NULL,'2026-01-21 14:24:25.179538',931,931,NULL,'0a781154-0d80-4c43-a01c-3f67f75f55fa',256,'a4f094a58f4542e2ab299637736993f9','gigabytes',2,'2026-01-22 14:24:25','f7db249e-6360-4f95-914d-c75a6989e840'),('2026-01-21 14:24:29.334192',NULL,'2026-01-21 14:24:29.452507',932,932,'37b3bbc0092f402c82354dc1111facd4','9b0a6e18-51bd-4d75-99ee-e026b65ce38b',259,'a4f094a58f4542e2ab299637736993f9','snapshots',1,'2026-01-22 14:24:29',NULL),('2026-01-21 14:24:29.336756',NULL,'2026-01-21 14:24:29.452507',933,933,'37b3bbc0092f402c82354dc1111facd4','989e607e-356d-4f92-884c-5aa1b00088d5',258,'a4f094a58f4542e2ab299637736993f9','snapshot_gigabytes',2,'2026-01-22 14:24:29',NULL),('2026-01-21 14:24:29.355395',NULL,'2026-01-21 14:24:29.452507',934,934,NULL,'6e2ef702-3d02-4249-af62-3bd726b80a15',261,'a4f094a58f4542e2ab299637736993f9','snapshots',1,'2026-01-22 14:24:29','f7db249e-6360-4f95-914d-c75a6989e840'),('2026-01-21 14:24:29.358601',NULL,'2026-01-21 14:24:29.452507',935,935,NULL,'6a5aa197-7ac7-4808-b149-255da0c3249d',260,'a4f094a58f4542e2ab299637736993f9','snapshot_gigabytes',2,'2026-01-22 14:24:29','f7db249e-6360-4f95-914d-c75a6989e840'),('2026-01-21 14:24:33.768634',NULL,'2026-01-21 14:24:33.931751',936,936,'37b3bbc0092f402c82354dc1111facd4','e4b241c4-48cd-48cb-8c05-e7f23888ed4c',259,'a4f094a58f4542e2ab299637736993f9','snapshots',-1,'2026-01-22 14:24:33',NULL),('2026-01-21 14:24:33.769593',NULL,'2026-01-21 14:24:33.931751',937,937,'37b3bbc0092f402c82354dc1111facd4','bdaaabd4-9452-411f-bd8e-701916e8e1c3',258,'a4f094a58f4542e2ab299637736993f9','snapshot_gigabytes',-2,'2026-01-22 14:24:33',NULL),('2026-01-21 14:24:33.842765',NULL,'2026-01-21 14:24:33.931751',938,938,NULL,'febe2acf-d44d-46b7-a00d-3c7574ffd32b',261,'a4f094a58f4542e2ab299637736993f9','snapshots',-1,'2026-01-22 14:24:33','f7db249e-6360-4f95-914d-c75a6989e840'),('2026-01-21 14:24:33.844237',NULL,'2026-01-21 14:24:33.931751',939,939,NULL,'fb86c48b-f77c-4714-89ce-78de0a14e9a5',260,'a4f094a58f4542e2ab299637736993f9','snapshot_gigabytes',-2,'2026-01-22 14:24:33','f7db249e-6360-4f95-914d-c75a6989e840'),('2026-01-21 14:24:37.215710',NULL,'2026-01-21 14:24:37.327106',940,940,'37b3bbc0092f402c82354dc1111facd4','30cfe2a1-7081-4faa-b8ca-925fe5fd1521',255,'a4f094a58f4542e2ab299637736993f9','shares',-1,'2026-01-22 14:24:37',NULL),('2026-01-21 14:24:37.216419',NULL,'2026-01-21 14:24:37.327106',941,941,'37b3bbc0092f402c82354dc1111facd4','03edd1b2-91c7-49ce-ad45-1000b3388c3d',254,'a4f094a58f4542e2ab299637736993f9','gigabytes',-2,'2026-01-22 14:24:37',NULL),('2026-01-21 14:24:37.283983',NULL,'2026-01-21 14:24:37.327106',942,942,NULL,'9d700e55-2361-49a2-adc1-bc50871b4719',257,'a4f094a58f4542e2ab299637736993f9','shares',-1,'2026-01-22 14:24:37','f7db249e-6360-4f95-914d-c75a6989e840'),('2026-01-21 14:24:37.284869',NULL,'2026-01-21 14:24:37.327106',943,943,NULL,'12117b3e-4035-419a-a775-c69f0bb27bcf',256,'a4f094a58f4542e2ab299637736993f9','gigabytes',-2,'2026-01-22 14:24:37','f7db249e-6360-4f95-914d-c75a6989e840'),('2026-01-21 14:24:40.209611',NULL,'2026-01-21 14:24:40.261299',944,944,'37b3bbc0092f402c82354dc1111facd4','a43256f7-df22-4b93-805a-4dcebd2d8048',255,'a4f094a58f4542e2ab299637736993f9','shares',1,'2026-01-22 14:24:40',NULL),('2026-01-21 14:24:40.214883',NULL,'2026-01-21 14:24:40.261299',945,945,'37b3bbc0092f402c82354dc1111facd4','42a7e4b1-a266-4503-a9f1-8ed4dae8ca82',254,'a4f094a58f4542e2ab299637736993f9','gigabytes',1,'2026-01-22 14:24:40',NULL),('2026-01-21 14:24:40.227049',NULL,'2026-01-21 14:24:40.261299',946,946,NULL,'78df0cab-f33d-45d9-905b-dd7515ec79b6',257,'a4f094a58f4542e2ab299637736993f9','shares',1,'2026-01-22 14:24:40','f7db249e-6360-4f95-914d-c75a6989e840'),('2026-01-21 14:24:40.228837',NULL,'2026-01-21 14:24:40.261299',947,947,NULL,'a0068f38-624c-4ad7-bc34-e0c59466d010',256,'a4f094a58f4542e2ab299637736993f9','gigabytes',1,'2026-01-22 14:24:40','f7db249e-6360-4f95-914d-c75a6989e840'),('2026-01-21 14:24:43.949068',NULL,'2026-01-21 14:24:44.098414',948,948,'37b3bbc0092f402c82354dc1111facd4','021a9dfc-4b9d-4601-884a-9108a3631315',259,'a4f094a58f4542e2ab299637736993f9','snapshots',1,'2026-01-22 14:24:43',NULL),('2026-01-21 14:24:43.950946',NULL,'2026-01-21 14:24:44.098414',949,949,'37b3bbc0092f402c82354dc1111facd4','142d4626-4578-4dbc-ae7e-76e7efcc6813',258,'a4f094a58f4542e2ab299637736993f9','snapshot_gigabytes',1,'2026-01-22 14:24:43',NULL),('2026-01-21 14:24:43.973135',NULL,'2026-01-21 14:24:44.098414',950,950,NULL,'d74dbdea-69bc-481c-9dd0-f05997652315',261,'a4f094a58f4542e2ab299637736993f9','snapshots',1,'2026-01-22 14:24:43','f7db249e-6360-4f95-914d-c75a6989e840'),('2026-01-21 14:24:43.976226',NULL,'2026-01-21 14:24:44.098414',951,951,NULL,'811106fd-ebbe-4ab3-a1ef-85d7987fb22e',260,'a4f094a58f4542e2ab299637736993f9','snapshot_gigabytes',1,'2026-01-22 14:24:43','f7db249e-6360-4f95-914d-c75a6989e840'),('2026-01-21 14:24:50.545488',NULL,'2026-01-21 14:24:50.565663',952,952,'37b3bbc0092f402c82354dc1111facd4','5c323b69-bfca-4bcf-b713-2365bdecdf1a',259,'a4f094a58f4542e2ab299637736993f9','snapshots',-1,'2026-01-22 14:24:50',NULL),('2026-01-21 14:24:50.546871',NULL,'2026-01-21 14:24:50.565663',953,953,'37b3bbc0092f402c82354dc1111facd4','32aa27c4-403a-4757-b739-814a98c11fde',258,'a4f094a58f4542e2ab299637736993f9','snapshot_gigabytes',-1,'2026-01-22 14:24:50',NULL),('2026-01-21 14:24:50.556293',NULL,'2026-01-21 14:24:50.565663',954,954,NULL,'75f7fa07-4d11-4ec2-b19a-76e1fb561e5f',261,'a4f094a58f4542e2ab299637736993f9','snapshots',-1,'2026-01-22 14:24:50','f7db249e-6360-4f95-914d-c75a6989e840'),('2026-01-21 14:24:50.557049',NULL,'2026-01-21 14:24:50.565663',955,955,NULL,'be43d341-1991-4956-8f75-73679aff6bc0',260,'a4f094a58f4542e2ab299637736993f9','snapshot_gigabytes',-1,'2026-01-22 14:24:50','f7db249e-6360-4f95-914d-c75a6989e840'),('2026-01-21 14:24:53.480768',NULL,'2026-01-21 14:24:53.499384',956,956,'37b3bbc0092f402c82354dc1111facd4','21eb8e02-26bd-4b13-8868-90d867f9ff33',255,'a4f094a58f4542e2ab299637736993f9','shares',-1,'2026-01-22 14:24:53',NULL),('2026-01-21 14:24:53.481657',NULL,'2026-01-21 14:24:53.499384',957,957,'37b3bbc0092f402c82354dc1111facd4','986877a8-140e-4201-97d4-e092be256924',254,'a4f094a58f4542e2ab299637736993f9','gigabytes',-1,'2026-01-22 14:24:53',NULL),('2026-01-21 14:24:53.488771',NULL,'2026-01-21 14:24:53.499384',958,958,NULL,'1171b799-4a6c-4d57-b35f-bf6cfa504cfb',257,'a4f094a58f4542e2ab299637736993f9','shares',-1,'2026-01-22 14:24:53','f7db249e-6360-4f95-914d-c75a6989e840'),('2026-01-21 14:24:53.490378',NULL,'2026-01-21 14:24:53.499384',959,959,NULL,'333a77f6-8351-49f7-990d-ffb807e7051a',256,'a4f094a58f4542e2ab299637736993f9','gigabytes',-1,'2026-01-22 14:24:53','f7db249e-6360-4f95-914d-c75a6989e840'),('2026-01-21 14:25:06.691008',NULL,'2026-01-21 14:25:06.752564',960,960,'1168f378c75641a9a34467d731e79a9e','c44e2829-d597-44e8-8dec-02578a51d36a',263,'3ae1279c04024905bd21b77f8a95d5ae','shares',1,'2026-01-22 14:25:06',NULL),('2026-01-21 14:25:06.692398',NULL,'2026-01-21 14:25:06.752564',961,961,'1168f378c75641a9a34467d731e79a9e','c10a3b39-690b-4ee2-8f38-2236ab70f7b8',262,'3ae1279c04024905bd21b77f8a95d5ae','gigabytes',1,'2026-01-22 14:25:06',NULL),('2026-01-21 14:25:06.711009',NULL,'2026-01-21 14:25:06.752564',962,962,NULL,'91513d40-bcbd-43f8-b87d-72dc3c4d63ea',265,'3ae1279c04024905bd21b77f8a95d5ae','shares',1,'2026-01-22 14:25:06','7c9297d5-c3a5-4113-9133-2dae5de6223a'),('2026-01-21 14:25:06.715254',NULL,'2026-01-21 14:25:06.752564',963,963,NULL,'4b5a7f7b-f668-4e6d-a24d-1ecd44d594e3',264,'3ae1279c04024905bd21b77f8a95d5ae','gigabytes',1,'2026-01-22 14:25:06','7c9297d5-c3a5-4113-9133-2dae5de6223a'),('2026-01-21 14:25:10.272241',NULL,'2026-01-21 14:25:10.393076',964,964,'1168f378c75641a9a34467d731e79a9e','84bada0f-0bb3-40c3-96b4-0e30d8c9a723',267,'3ae1279c04024905bd21b77f8a95d5ae','snapshots',1,'2026-01-22 14:25:10',NULL),('2026-01-21 14:25:10.276041',NULL,'2026-01-21 14:25:10.393076',965,965,'1168f378c75641a9a34467d731e79a9e','c70e0c8b-2b7d-47ba-ae20-2d50228e3f51',266,'3ae1279c04024905bd21b77f8a95d5ae','snapshot_gigabytes',1,'2026-01-22 14:25:10',NULL),('2026-01-21 14:25:10.289640',NULL,'2026-01-21 14:25:10.393076',966,966,NULL,'5b1a38fc-ecbc-4b65-88f1-4d5e2acd16c7',269,'3ae1279c04024905bd21b77f8a95d5ae','snapshots',1,'2026-01-22 14:25:10','7c9297d5-c3a5-4113-9133-2dae5de6223a'),('2026-01-21 14:25:10.291785',NULL,'2026-01-21 14:25:10.393076',967,967,NULL,'0e4d3c8f-7a41-4299-9c5d-6705be8849fa',268,'3ae1279c04024905bd21b77f8a95d5ae','snapshot_gigabytes',1,'2026-01-22 14:25:10','7c9297d5-c3a5-4113-9133-2dae5de6223a'),('2026-01-21 14:25:16.269272',NULL,'2026-01-21 14:25:16.310879',968,968,'1168f378c75641a9a34467d731e79a9e','bfd2dab7-7815-4e9b-a853-5f42655fa768',267,'3ae1279c04024905bd21b77f8a95d5ae','snapshots',-1,'2026-01-22 14:25:16',NULL),('2026-01-21 14:25:16.270198',NULL,'2026-01-21 14:25:16.310879',969,969,'1168f378c75641a9a34467d731e79a9e','4b572e6d-0e3b-46fd-9d5a-0bc519050c53',266,'3ae1279c04024905bd21b77f8a95d5ae','snapshot_gigabytes',-1,'2026-01-22 14:25:16',NULL),('2026-01-21 14:25:16.290270',NULL,'2026-01-21 14:25:16.310879',970,970,NULL,'7b6cdd6b-0b4e-47e2-bd69-5ed93af01628',269,'3ae1279c04024905bd21b77f8a95d5ae','snapshots',-1,'2026-01-22 14:25:16','7c9297d5-c3a5-4113-9133-2dae5de6223a'),('2026-01-21 14:25:16.291168',NULL,'2026-01-21 14:25:16.310879',971,971,NULL,'0648750c-3913-42ae-a636-11141f5080ca',268,'3ae1279c04024905bd21b77f8a95d5ae','snapshot_gigabytes',-1,'2026-01-22 14:25:16','7c9297d5-c3a5-4113-9133-2dae5de6223a'),('2026-01-21 14:25:19.769925',NULL,'2026-01-21 14:25:19.790078',972,972,'1168f378c75641a9a34467d731e79a9e','b47b53f2-b307-4741-bb83-40f5f1f6c6fa',263,'3ae1279c04024905bd21b77f8a95d5ae','shares',-1,'2026-01-22 14:25:19',NULL),('2026-01-21 14:25:19.770798',NULL,'2026-01-21 14:25:19.790078',973,973,'1168f378c75641a9a34467d731e79a9e','00269624-b34e-4c77-bef4-4e219f8e8223',262,'3ae1279c04024905bd21b77f8a95d5ae','gigabytes',-1,'2026-01-22 14:25:19',NULL),('2026-01-21 14:25:19.777747',NULL,'2026-01-21 14:25:19.790078',974,974,NULL,'57542a62-2111-4bad-8c2f-d122fb53cbaf',265,'3ae1279c04024905bd21b77f8a95d5ae','shares',-1,'2026-01-22 14:25:19','7c9297d5-c3a5-4113-9133-2dae5de6223a'),('2026-01-21 14:25:19.778607',NULL,'2026-01-21 14:25:19.790078',975,975,NULL,'19245468-63f4-4a31-81cd-ec29365c4cf7',264,'3ae1279c04024905bd21b77f8a95d5ae','gigabytes',-1,'2026-01-22 14:25:19','7c9297d5-c3a5-4113-9133-2dae5de6223a');
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `security_services`
--

DROP TABLE IF EXISTS `security_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `security_services` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `type` varchar(32) NOT NULL,
  `dns_ip` varchar(64) DEFAULT NULL,
  `server` varchar(255) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `user` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `ou` varchar(255) DEFAULT NULL,
  `default_ad_site` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `security_services`
--

LOCK TABLES `security_services` WRITE;
/*!40000 ALTER TABLE `security_services` DISABLE KEYS */;
INSERT INTO `security_services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `type`, `dns_ip`, `server`, `domain`, `user`, `password`, `name`, `description`, `ou`, `default_ad_site`) VALUES ('2026-01-21 14:11:31.222558','2026-01-21 14:11:33.752803','2026-01-21 14:11:33.752406','066f7472-5239-4098-84be-8d59c35cafaf','066f7472-5239-4098-84be-8d59c35cafaf','18bb008a1840444c9d68a413a43a3d81','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2026-01-21 14:11:28.722893','2026-01-21 14:11:29.259827','2026-01-21 14:11:29.259453','0a5486b3-a3c2-4272-bef8-1c0acae48d4b','0a5486b3-a3c2-4272-bef8-1c0acae48d4b','18bb008a1840444c9d68a413a43a3d81','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2002-02-02 00:00:00.000000',NULL,NULL,'False','15f343aa-e463-4581-94a9-c22e06f659ae','13c5ce7776694d3ba842a33559f0ce31','kerberos',NULL,NULL,NULL,NULL,NULL,'sn_with_ldap_ss','fake description',NULL,NULL),('2026-01-21 14:19:56.830064','2026-01-21 14:19:56.974161','2026-01-21 14:19:56.973686','1c8b434c-5c50-457e-a1a1-cf4bc2031618','1c8b434c-5c50-457e-a1a1-cf4bc2031618','d638cf7a9e1e49ccbfafad2ce91ed67c','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-21 14:19:21.969628',NULL,NULL,'False','1d2de491-87ab-4fac-b38f-220ed5a8f172','e5d2b19b5e42472bbc153671b4a835ba','ldap','203.0.113.250','203.0.113.124','tempest-ss-domain-28685185','tempest-ss-user-645962408','tempest-ss-password-1325180257','tempest-ss-name-282737962','tempest-ss-desc-638997348',NULL,NULL),('2026-01-21 14:19:57.876341','2026-01-21 14:19:58.037098','2026-01-21 14:19:58.036719','223264de-e8ee-4311-9330-2e23c6e05b5d','223264de-e8ee-4311-9330-2e23c6e05b5d','5287c34d74954423ba30381636cbb812','ldap','203.0.113.123','203.0.113.78','tempest-ss-domain-1070906625','tempest-ss-user-708799381','tempest-ss-password-1388363480','tempest-ss-name-1420544352','tempest-ss-desc-194132617',NULL,NULL),('2026-01-21 14:19:53.226615','2026-01-21 14:19:53.348361','2026-01-21 14:19:53.347997','2371d8a0-afa6-43ae-9f1f-609afd74a6e0','2371d8a0-afa6-43ae-9f1f-609afd74a6e0','d638cf7a9e1e49ccbfafad2ce91ed67c','ldap','203.0.113.104','203.0.113.231','tempest-ss-domain-678227111','tempest-ss-user-1590259359','tempest-ss-password-2045293610','tempest-ss-name-288272257','tempest-ss-desc-1383906169','tempest-ss-ou-401438200',NULL),('2026-01-21 14:19:55.432415','2026-01-21 14:19:55.541780','2026-01-21 14:19:55.541473','2621b9b7-fc3f-49d0-8dc7-566ae1b5f39b','2621b9b7-fc3f-49d0-8dc7-566ae1b5f39b','d638cf7a9e1e49ccbfafad2ce91ed67c','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-21 14:19:53.110914','2026-01-21 14:19:53.619036','2026-01-21 14:19:53.618648','27560df7-bd56-4dbb-a085-7d64b5c0e8ae','27560df7-bd56-4dbb-a085-7d64b5c0e8ae','d638cf7a9e1e49ccbfafad2ce91ed67c','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-21 14:19:56.198931','2026-01-21 14:19:56.657037','2026-01-21 14:19:56.656375','28f7e615-59c3-44b4-a2f4-e3cb8dce0fbc','28f7e615-59c3-44b4-a2f4-e3cb8dce0fbc','d638cf7a9e1e49ccbfafad2ce91ed67c','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-21 14:19:57.770218','2026-01-21 14:19:58.156184','2026-01-21 14:19:58.155824','2ccd58be-0acd-413a-a041-756f24b9ed3d','2ccd58be-0acd-413a-a041-756f24b9ed3d','d638cf7a9e1e49ccbfafad2ce91ed67c','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-21 14:19:57.231382','2026-01-21 14:19:57.584430','2026-01-21 14:19:57.583988','328bb6c5-2e67-4a91-8dee-451de2b6490b','328bb6c5-2e67-4a91-8dee-451de2b6490b','d638cf7a9e1e49ccbfafad2ce91ed67c','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-21 14:11:27.166269','2026-01-21 14:11:27.781642','2026-01-21 14:11:27.781294','358289d2-a0e1-467c-aaea-8800c644b7e6','358289d2-a0e1-467c-aaea-8800c644b7e6','18bb008a1840444c9d68a413a43a3d81','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2026-01-21 14:19:54.498647','2026-01-21 14:19:54.658163','2026-01-21 14:19:54.657686','393cab69-048f-481a-99db-d5fde295e1a9','393cab69-048f-481a-99db-d5fde295e1a9','d638cf7a9e1e49ccbfafad2ce91ed67c','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-21 14:11:34.196925','2026-01-21 14:11:34.427175','2026-01-21 14:11:34.426789','3ed1a30a-45d0-44fa-a19e-5410c647d89e','3ed1a30a-45d0-44fa-a19e-5410c647d89e','18bb008a1840444c9d68a413a43a3d81','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2026-01-21 14:19:10.235087','2026-01-21 14:19:10.564525','2026-01-21 14:19:10.564225','4315334e-7020-480d-9b92-0ce2c1e17930','4315334e-7020-480d-9b92-0ce2c1e17930','3045c953c1f44932b48db800dd54be02','ldap','203.0.113.243','203.0.113.21','tempest-ss-domain-1555480459','tempest-ss-user-2025932653','tempest-ss-password-1389663708','tempest-ss-name-927712021','tempest-ss-desc-415452857',NULL,NULL),('2026-01-21 14:19:57.305728','2026-01-21 14:19:57.466197','2026-01-21 14:19:57.465842','45f6414a-d674-4e2b-adc6-1da318bcb40b','45f6414a-d674-4e2b-adc6-1da318bcb40b','d638cf7a9e1e49ccbfafad2ce91ed67c','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-21 14:11:25.176737','2026-01-21 14:11:26.044114','2026-01-21 14:11:26.042845','48e6cf44-33bb-495a-90e0-ceb800a52428','48e6cf44-33bb-495a-90e0-ceb800a52428','18bb008a1840444c9d68a413a43a3d81','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2026-01-21 14:19:19.781980',NULL,NULL,'False','4e975191-d286-4c47-aa55-3d56fb460808','e5d2b19b5e42472bbc153671b4a835ba','ldap',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:19:11.790976',NULL,NULL,'False','54ae9369-7156-4a0b-9f06-3916384d35e8','3045c953c1f44932b48db800dd54be02','ldap','203.0.113.161','203.0.113.90','tempest-ss-domain-469629578','tempest-ss-user-64397886','tempest-ss-password-1350617797','tempest-ss-name-1729382703','tempest-ss-desc-1023737500',NULL,NULL),('2026-01-21 14:11:30.376406','2026-01-21 14:11:30.937684','2026-01-21 14:11:30.937328','5ba9056e-603d-4c92-b33d-3c322816baa3','5ba9056e-603d-4c92-b33d-3c322816baa3','18bb008a1840444c9d68a413a43a3d81','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2026-01-21 14:11:27.343514','2026-01-21 14:11:27.597235','2026-01-21 14:11:27.596778','6325ef81-a90e-4687-8164-2146ee2e4eec','6325ef81-a90e-4687-8164-2146ee2e4eec','18bb008a1840444c9d68a413a43a3d81','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2026-01-21 14:19:52.454983','2026-01-21 14:19:52.998995','2026-01-21 14:19:52.998634','63e30bb8-3c0f-4e41-a150-edf4d2785bff','63e30bb8-3c0f-4e41-a150-edf4d2785bff','d638cf7a9e1e49ccbfafad2ce91ed67c','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-21 14:19:52.125612','2026-01-21 14:19:52.194709','2026-01-21 14:19:52.194372','65d531af-55de-4b96-ba0f-07b91dd223f5','65d531af-55de-4b96-ba0f-07b91dd223f5','d638cf7a9e1e49ccbfafad2ce91ed67c','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-21 14:15:38.121147','2026-01-21 14:15:38.290184','2026-01-21 14:15:38.289706','6d0690e8-d899-49a8-b275-5ce7a01c0f39','6d0690e8-d899-49a8-b275-5ce7a01c0f39','b4a571ae4eec45b9b24ab70f80d95d96','ldap','203.0.113.228','203.0.113.63','tempest-ss-domain-688512206','tempest-ss-user-1189045146','tempest-ss-password-1341468638','tempest-ss-name-480341492','tempest-ss-desc-1556440106',NULL,NULL),('2026-01-21 14:11:25.299820','2026-01-21 14:11:25.559965','2026-01-21 14:11:25.558477','7245af73-7020-4fe2-9229-9caa0b667a15','7245af73-7020-4fe2-9229-9caa0b667a15','18bb008a1840444c9d68a413a43a3d81','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2026-01-21 14:19:51.062981','2026-01-21 14:19:51.684669','2026-01-21 14:19:51.684369','727489b1-c08b-4b76-b1e9-9b94b4759972','727489b1-c08b-4b76-b1e9-9b94b4759972','d638cf7a9e1e49ccbfafad2ce91ed67c','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-21 14:19:58.536176','2026-01-21 14:19:59.493044','2026-01-21 14:19:59.492641','73641411-ddd8-4eb4-8e9a-7f3f7c2d9c5d','73641411-ddd8-4eb4-8e9a-7f3f7c2d9c5d','d638cf7a9e1e49ccbfafad2ce91ed67c','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-21 14:19:52.070322','2026-01-21 14:19:52.328537','2026-01-21 14:19:52.327778','79314a3a-7d0e-497e-b1c2-04fa0954b64f','79314a3a-7d0e-497e-b1c2-04fa0954b64f','d638cf7a9e1e49ccbfafad2ce91ed67c','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-21 14:19:51.269886','2026-01-21 14:19:51.326343','2026-01-21 14:19:51.326038','7ad4dfb4-fef2-45b3-b9fc-c3e58d0fd443','7ad4dfb4-fef2-45b3-b9fc-c3e58d0fd443','d638cf7a9e1e49ccbfafad2ce91ed67c','kerberos','203.0.113.124','203.0.113.215','tempest-ss-domain-266243868','tempest-ss-user-432682939','tempest-ss-password-363862383','tempest-ss-name-433623849','tempest-ss-desc-1289247829',NULL,NULL),('2026-01-21 14:19:52.595009','2026-01-21 14:19:52.740548','2026-01-21 14:19:52.740183','7c48f49b-affc-409a-8ab0-686858f78473','7c48f49b-affc-409a-8ab0-686858f78473','d638cf7a9e1e49ccbfafad2ce91ed67c','ldap','203.0.113.251','203.0.113.254','tempest-ss-domain-1011776879','tempest-ss-user-5760796','tempest-ss-password-2013590138','tempest-ss-name-1934165674','tempest-ss-desc-284862029',NULL,NULL),('2026-01-21 14:11:27.954729','2026-01-21 14:11:28.460026','2026-01-21 14:11:28.459598','82051abf-ae68-47e2-82e4-e313a7f3d02c','82051abf-ae68-47e2-82e4-e313a7f3d02c','18bb008a1840444c9d68a413a43a3d81','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2026-01-21 14:11:28.822388','2026-01-21 14:11:29.042838','2026-01-21 14:11:29.042373','82442352-dd50-465f-9975-9ca88cf19645','82442352-dd50-465f-9975-9ca88cf19645','18bb008a1840444c9d68a413a43a3d81','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2026-01-21 14:19:21.005406','2026-01-21 14:19:21.402892','2026-01-21 14:19:21.401896','852ebf37-02a5-4311-b63f-915aaad6fbb6','852ebf37-02a5-4311-b63f-915aaad6fbb6','e5d2b19b5e42472bbc153671b4a835ba','ldap','203.0.113.40','203.0.113.142','tempest-ss-domain-1353644205','tempest-ss-user-360298008','tempest-ss-password-736046764','tempest-ss-name-718363230','tempest-ss-desc-1417583139',NULL,NULL),('2026-01-21 14:19:55.780415','2026-01-21 14:19:55.999796','2026-01-21 14:19:55.999338','87c149d1-0620-4e6e-a4dd-30032e2e8020','87c149d1-0620-4e6e-a4dd-30032e2e8020','d638cf7a9e1e49ccbfafad2ce91ed67c','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-21 14:11:33.248037','2026-01-21 14:11:33.471649','2026-01-21 14:11:33.471193','8cb3da3d-b06b-4bb0-9919-fd907f554424','8cb3da3d-b06b-4bb0-9919-fd907f554424','18bb008a1840444c9d68a413a43a3d81','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2026-01-21 14:19:54.924017','2026-01-21 14:19:55.257722','2026-01-21 14:19:55.257338','8f46f958-1361-479d-a733-97766e27bf43','8f46f958-1361-479d-a733-97766e27bf43','d638cf7a9e1e49ccbfafad2ce91ed67c','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-21 14:19:55.378482','2026-01-21 14:19:55.646498','2026-01-21 14:19:55.646183','92359328-6aed-4f9b-aea1-f587d6200c38','92359328-6aed-4f9b-aea1-f587d6200c38','d638cf7a9e1e49ccbfafad2ce91ed67c','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-21 14:19:58.479823','2026-01-21 14:19:59.617457','2026-01-21 14:19:59.617011','97a76a81-d6c3-4051-a82b-97dc888f5cf1','97a76a81-d6c3-4051-a82b-97dc888f5cf1','d638cf7a9e1e49ccbfafad2ce91ed67c','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-21 14:19:51.131869','2026-01-21 14:19:51.216345','2026-01-21 14:19:51.215955','992c98b8-c909-46f0-8a2e-587061a1a4e4','992c98b8-c909-46f0-8a2e-587061a1a4e4','d638cf7a9e1e49ccbfafad2ce91ed67c','ldap','203.0.113.124','203.0.113.215','tempest-ss-domain-266243868','tempest-ss-user-432682939','tempest-ss-password-363862383','tempest-ss-name-433623849','tempest-ss-desc-1289247829',NULL,NULL),('2026-01-21 14:19:58.593675','2026-01-21 14:19:59.209701','2026-01-21 14:19:59.209356','9ee3104b-c2d8-451a-be1a-d32189d1bab6','9ee3104b-c2d8-451a-be1a-d32189d1bab6','d638cf7a9e1e49ccbfafad2ce91ed67c','ldap','203.0.113.22','203.0.113.33','tempest-ss-domain-152746046','tempest-ss-user-216553639','tempest-ss-password-1500224599','tempest-ss-name-1109863627','tempest-ss-desc-1238190777','tempest-ss-ou-52720023',NULL),('2026-01-21 14:15:59.821374',NULL,NULL,'False','a5f65d8f-bb40-403e-9b86-6684b5f7b30c','a7c6c7c42b5d4ca3933e833a80ca4f97','ldap','203.0.113.166','203.0.113.222','tempest-ss-domain-1489945908','tempest-ss-user-1831369062','tempest-ss-password-1404043997','tempest-ss-name-1478680721','tempest-ss-desc-140816114',NULL,NULL),('2026-01-21 14:19:54.992610','2026-01-21 14:19:55.134177','2026-01-21 14:19:55.133636','a971e837-a108-49b4-a7ed-ad20d0c8769a','a971e837-a108-49b4-a7ed-ad20d0c8769a','d638cf7a9e1e49ccbfafad2ce91ed67c','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-21 14:19:51.387914','2026-01-21 14:19:51.452170','2026-01-21 14:19:51.451818','ad71128c-c46e-4ec0-a53b-69dc61618353','ad71128c-c46e-4ec0-a53b-69dc61618353','d638cf7a9e1e49ccbfafad2ce91ed67c','active_directory','203.0.113.124','203.0.113.215','tempest-ss-domain-266243868','tempest-ss-user-432682939','tempest-ss-password-363862383','tempest-ss-name-433623849','tempest-ss-desc-1289247829',NULL,NULL),('2026-01-21 14:19:12.566421',NULL,NULL,'False','ad969dbd-799d-4a25-a274-395b7960b371','3045c953c1f44932b48db800dd54be02','ldap','203.0.113.244','203.0.113.172','tempest-ss-domain-1241507194','tempest-ss-user-745419885','tempest-ss-password-533931021','tempest-ss-name-1245460393','tempest-ss-desc-624399511',NULL,NULL),('2026-01-21 14:19:57.712035','2026-01-21 14:19:58.270244','2026-01-21 14:19:58.269832','b4fe373d-e280-407f-954c-2db4d4b77bb4','b4fe373d-e280-407f-954c-2db4d4b77bb4','d638cf7a9e1e49ccbfafad2ce91ed67c','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-21 14:19:53.891035','2026-01-21 14:19:54.033045','2026-01-21 14:19:54.032689','bb50e940-43e9-4985-b9f5-b123df1708c0','bb50e940-43e9-4985-b9f5-b123df1708c0','d638cf7a9e1e49ccbfafad2ce91ed67c','ldap','203.0.113.102','203.0.113.64','tempest-ss-domain-292741781','tempest-ss-user-81824531','tempest-ss-password-1283254665','tempest-ss-name-871640172','tempest-ss-desc-2118374519','tempest-ss-ou-1005305194',NULL),('2026-01-21 14:19:55.838309','2026-01-21 14:19:55.891277','2026-01-21 14:19:55.890960','bc0d7915-b739-40a1-8e0f-13cc4c785f31','bc0d7915-b739-40a1-8e0f-13cc4c785f31','d638cf7a9e1e49ccbfafad2ce91ed67c','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2002-02-02 00:00:00.000000',NULL,NULL,'False','c12c1108-38be-44c3-9f8f-8e69beedf912','a7c6c7c42b5d4ca3933e833a80ca4f97','kerberos',NULL,NULL,NULL,NULL,NULL,'sn_with_ldap_ss','fake description',NULL,NULL),('2026-01-21 14:19:54.439991','2026-01-21 14:19:54.802816','2026-01-21 14:19:54.802515','c167947f-7730-4eb1-ac94-fc1366caa318','c167947f-7730-4eb1-ac94-fc1366caa318','d638cf7a9e1e49ccbfafad2ce91ed67c','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-21 14:19:53.172842','2026-01-21 14:19:53.481160','2026-01-21 14:19:53.480795','c7c8d7dd-5124-4818-8776-a30da0694663','c7c8d7dd-5124-4818-8776-a30da0694663','d638cf7a9e1e49ccbfafad2ce91ed67c','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-21 14:19:53.821947','2026-01-21 14:19:54.184685','2026-01-21 14:19:54.184318','ca6c2be5-a245-4abe-8565-1826d0070b65','ca6c2be5-a245-4abe-8565-1826d0070b65','d638cf7a9e1e49ccbfafad2ce91ed67c','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-21 14:19:22.041896','2026-01-21 14:19:22.585922','2026-01-21 14:19:22.585624','cba37bc6-0790-45e1-9164-ef3bd4173a99','cba37bc6-0790-45e1-9164-ef3bd4173a99','e5d2b19b5e42472bbc153671b4a835ba','ldap','203.0.113.233','203.0.113.56','tempest-ss-domain-125853381','tempest-ss-user-501608649','tempest-ss-password-437117277','tempest-ss-name-909162059','tempest-ss-desc-2049807166',NULL,NULL),('2026-01-21 14:19:50.999990','2026-01-21 14:19:51.950824','2026-01-21 14:19:51.950456','cd900015-8bc1-4f73-a4f1-982cd1fdc969','cd900015-8bc1-4f73-a4f1-982cd1fdc969','d638cf7a9e1e49ccbfafad2ce91ed67c','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-21 14:11:28.043844','2026-01-21 14:11:28.226678','2026-01-21 14:11:28.225736','cdc1e1cc-ddda-4a45-a38f-7edcb865cba8','cdc1e1cc-ddda-4a45-a38f-7edcb865cba8','18bb008a1840444c9d68a413a43a3d81','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2026-01-21 14:11:29.869526','2026-01-21 14:11:29.939317','2026-01-21 14:11:29.938976','d691b73d-8555-49dd-a101-3f0e6b3f34e5','d691b73d-8555-49dd-a101-3f0e6b3f34e5','18bb008a1840444c9d68a413a43a3d81','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2026-01-21 14:11:34.081050','2026-01-21 14:11:34.682990','2026-01-21 14:11:34.682588','db794857-6b27-4388-ba04-d83f8648eee5','db794857-6b27-4388-ba04-d83f8648eee5','18bb008a1840444c9d68a413a43a3d81','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2026-01-21 14:19:56.356562','2026-01-21 14:19:56.484040','2026-01-21 14:19:56.483731','dc49948e-a5fb-4392-918f-70933aa950b5','dc49948e-a5fb-4392-918f-70933aa950b5','d638cf7a9e1e49ccbfafad2ce91ed67c','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-21 14:11:30.494650','2026-01-21 14:11:30.721227','2026-01-21 14:11:30.720570','e0586615-8050-4309-a9b5-b5f59737216c','e0586615-8050-4309-a9b5-b5f59737216c','18bb008a1840444c9d68a413a43a3d81','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,NULL,NULL),('2026-01-21 14:13:28.125000',NULL,NULL,'False','e0647723-226b-4ce9-8eb0-2445ed614fc3','938ff6c62b4d4bfe9c13b015ab84e14b','ldap','203.0.113.37','203.0.113.203','tempest-ss-domain-1360701581','tempest-ss-user-605604950','tempest-ss-password-5873094','tempest-ss-name-1418403151','tempest-ss-desc-650256885',NULL,NULL),('2026-01-21 14:19:52.523750','2026-01-21 14:19:52.864524','2026-01-21 14:19:52.864187','e383debc-db55-4cb7-9b19-e9773a1d885c','e383debc-db55-4cb7-9b19-e9773a1d885c','d638cf7a9e1e49ccbfafad2ce91ed67c','kerberos','2.2.2.2','fake_server_2','fake_domain_2','test_user','word','ss_kerberos',NULL,'OU=fake_unit_2',NULL),('2026-01-21 14:19:53.755235','2026-01-21 14:19:54.308915','2026-01-21 14:19:54.308498','f2b123aa-348b-46fd-b6fb-208735d29c22','f2b123aa-348b-46fd-b6fb-208735d29c22','d638cf7a9e1e49ccbfafad2ce91ed67c','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL),('2026-01-21 14:11:29.542072','2026-01-21 14:11:30.203251','2026-01-21 14:11:30.202336','f75f6717-7ff4-456c-87cd-102a282589b3','f75f6717-7ff4-456c-87cd-102a282589b3','18bb008a1840444c9d68a413a43a3d81','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,NULL,NULL),('2026-01-21 14:19:56.767329','2026-01-21 14:19:57.105581','2026-01-21 14:19:57.105246','fa5fdbde-03e4-485d-9508-5d0548165a68','fa5fdbde-03e4-485d-9508-5d0548165a68','d638cf7a9e1e49ccbfafad2ce91ed67c','ldap','1.1.1.1','fake_server_1','fake_domain_1','fake_user','pass','ss_ldap',NULL,'OU=fake_unit_1',NULL);
/*!40000 ALTER TABLE `security_services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  `state` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `service_az_id_fk` (`availability_zone_id`),
  CONSTRAINT `service_az_id_fk` FOREIGN KEY (`availability_zone_id`) REFERENCES `availability_zones` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone_id`, `state`) VALUES ('2026-01-21 14:04:35.134550','2026-01-21 14:35:29.757368',NULL,0,1,'hostgroup','manila-scheduler','manila-scheduler',184,0,'63c64197-bff4-402b-8808-40cae651ac91','up'),('2026-01-21 14:04:45.953248','2026-01-21 14:35:37.245816',NULL,0,2,'hostgroup@cephfs','manila-share','manila-share',184,0,'63c64197-bff4-402b-8808-40cae651ac91','up');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_access_map`
--

DROP TABLE IF EXISTS `share_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_access_map` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `share_id` varchar(36) NOT NULL,
  `access_type` varchar(255) DEFAULT NULL,
  `access_to` varchar(255) DEFAULT NULL,
  `access_level` varchar(2) DEFAULT NULL,
  `access_key` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_id` (`share_id`),
  CONSTRAINT `share_access_map_ibfk_1` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_access_map`
--

LOCK TABLES `share_access_map` WRITE;
/*!40000 ALTER TABLE `share_access_map` DISABLE KEYS */;
INSERT INTO `share_access_map` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_id`, `access_type`, `access_to`, `access_level`, `access_key`) VALUES ('2026-01-21 14:16:02.479775','2026-01-21 14:16:06.991539','2026-01-21 14:19:22.927841','04c63bc4-424f-49f5-ba37-1b8819c4e899','04c63bc4-424f-49f5-ba37-1b8819c4e899','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','alice_bob','ro','AQCj33BpcDJoIRAAz2pGssnmkgwE4LvgOsmvpA=='),('2026-01-21 14:14:30.054166','2026-01-21 14:14:34.581795','2026-01-21 14:14:39.724423','0adb5035-75c4-4a10-8bcf-d4e25bee71bc','0adb5035-75c4-4a10-8bcf-d4e25bee71bc','e556b944-c601-4d6a-9a44-72d806af4101','cephx','eve47','rw','AQBG33BppodWKBAA4S1dDvCCi59DzmJz0x0uqg=='),('2026-01-21 14:14:21.009962','2026-01-21 14:14:26.472207','2026-01-21 14:14:39.724423','0d84db21-6050-4abd-a9b6-92283fa14449','0d84db21-6050-4abd-a9b6-92283fa14449','e556b944-c601-4d6a-9a44-72d806af4101','cephx','eve48','rw','AQA+33BplaxVEBAA5lc0n1hSHGLu6mXHhi/XXg=='),('2026-01-21 14:17:25.799171','2026-01-21 14:17:29.881329','2026-01-21 14:17:39.018910','0ef1a8a3-733b-40d2-90b4-047c73350fbd','0ef1a8a3-733b-40d2-90b4-047c73350fbd','87161409-8bb7-4318-a754-72802d038d2f','cephx','david','rw',NULL),('2026-01-21 14:16:02.480733','2026-01-21 14:16:07.041851','2026-01-21 14:16:12.181478','1e47e7aa-cb8e-4984-ad0f-c0fee186d808','1e47e7aa-cb8e-4984-ad0f-c0fee186d808','1aabce1b-dbbb-4dae-a6a5-613066113ab2','cephx','tempest-cephx-id-1440431664','rw','AQCj33BpZcrqJRAAZwf1nRuL6H17Shh72OtzKw=='),('2026-01-21 14:16:55.631783','2026-01-21 14:17:07.021958','2026-01-21 14:17:42.649419','1f444e7e-33c4-45eb-8eeb-11530f627d7c','1f444e7e-33c4-45eb-8eeb-11530f627d7c','b1af7887-8549-4ad6-8f39-3d20abb6170a','cephx','Joe','rw',NULL),('2026-01-21 14:16:17.879603','2026-01-21 14:16:23.327253','2026-01-21 14:19:22.927841','1fabf8cd-2938-4185-9a71-42bd0f2f8661','1fabf8cd-2938-4185-9a71-42bd0f2f8661','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','alice bob','ro','AQCz33Bp6FpmJRAAs/YuwjGOlBqO7Fpn6dY3yg=='),('2026-01-21 14:15:48.025593','2026-01-21 14:15:52.161215','2026-01-21 14:16:12.181478','218cc456-62b1-4a12-a56c-077fa858d6e7','218cc456-62b1-4a12-a56c-077fa858d6e7','1aabce1b-dbbb-4dae-a6a5-613066113ab2','cephx','tempest-cephx-id-1440431664','rw','AQCU33BpcVieNhAAHU81T6OxO8aSnxzoL2cToA=='),('2026-01-21 14:17:14.616480','2026-01-21 14:17:50.141409','2026-01-21 14:17:50.658038','2297f3e5-f5cb-4bbe-8382-81de55b382a3','2297f3e5-f5cb-4bbe-8382-81de55b382a3','ca6daf26-9831-4772-bcf0-7b69e0070af8','cephx','admin','rw',NULL),('2026-01-21 14:15:05.057880','2026-01-21 14:15:08.661387','2026-01-21 14:15:09.977183','26fecfd8-20b9-4f38-8bad-d59efa8c547e','26fecfd8-20b9-4f38-8bad-d59efa8c547e','72fbe20a-9dea-4a19-8d2c-fbf5fca1a08e','cephx','tempest-cephx-id-483669843','rw','AQBp33BpQI4FGxAABja5rD6QdXKyhoyBDsr1dQ=='),('2026-01-21 14:16:59.757902','2026-01-21 14:17:07.485205','2026-01-21 14:17:42.649419','2bbbf40a-e79d-475e-bf8e-4e71a49e03dc','2bbbf40a-e79d-475e-bf8e-4e71a49e03dc','b1af7887-8549-4ad6-8f39-3d20abb6170a','cephx','tempest-cephx-id-102251759','rw','AQDc33BpETR7KRAAhhbkPcIPmYQCbDN/MLGZDw=='),('2026-01-21 14:17:41.641289','2026-01-21 14:17:45.650714','2026-01-21 14:19:22.927841','3d62b1c7-afd1-4569-a2a8-484e020c5a25','3d62b1c7-afd1-4569-a2a8-484e020c5a25','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','alice_bob','rw','AQAG4HBp1VN7DxAAm3VId7DNnQlDZ8fLhAUzdQ=='),('2026-01-21 14:18:53.356302','2026-01-21 14:18:59.232293','2026-01-21 14:19:22.927841','40248d4a-a7f6-4c06-91d3-0ba3ad0a42ee','40248d4a-a7f6-4c06-91d3-0ba3ad0a42ee','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','alice bob','ro','AQBO4HBptFktAxAAIBWmUqv2ze8/VUEzUhZGVQ=='),('2026-01-21 14:17:56.383014','2026-01-21 14:18:00.274271','2026-01-21 14:19:22.927841','419c5e7a-8933-4a3d-a4f6-fa4bf046aef0','419c5e7a-8933-4a3d-a4f6-fa4bf046aef0','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','alice bob','rw','AQAU4HBp7SxpNRAAIrhKB6dXzXd/TZZ0O3Jpfw=='),('2026-01-21 14:19:02.607567','2026-01-21 14:19:18.452296','2026-01-21 14:19:22.927841','4765b77d-de28-4870-bc36-7b4a3c1eac7c','4765b77d-de28-4870-bc36-7b4a3c1eac7c','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','bob','rw','AQBX4HBpPcL8BxAAEpUSe8i+ZcG2oX3x9t8a6A=='),('2026-01-21 14:15:48.001515','2026-01-21 14:15:51.897533','2026-01-21 14:19:22.927841','6194110d-8c30-4666-8cde-4191b117c2cd','6194110d-8c30-4666-8cde-4191b117c2cd','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','alice','ro','AQCU33BpMdwyIRAAGmy7F3qOgcIMqtzpG+jG9A=='),('2026-01-21 14:17:32.025354','2026-01-21 14:17:38.341113','2026-01-21 14:19:22.927841','630eb073-1060-4849-934d-89c1d1c194b1','630eb073-1060-4849-934d-89c1d1c194b1','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','alice','ro','AQD833Bp+39bKhAAZ+7COnzYdOAP+Alz6v9L3Q=='),('2026-01-21 14:15:40.463305','2026-01-21 14:15:44.617924','2026-01-21 14:16:12.181478','6d69d8aa-0bc4-4a62-996b-d44bf55c6244','6d69d8aa-0bc4-4a62-996b-d44bf55c6244','1aabce1b-dbbb-4dae-a6a5-613066113ab2','cephx','tempest-cephx-id-1440431664','rw','AQCM33Bp/XhMNBAAE8T54HFx+Yh0d2i/FK1YSQ=='),('2026-01-21 14:17:24.348817','2026-01-21 14:17:28.231755','2026-01-21 14:19:22.927841','73bbbc4c-6b71-4850-909d-1fbd6a2f0932','73bbbc4c-6b71-4850-909d-1fbd6a2f0932','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','alice','rw','AQD033Bpd6ZVKxAARf4LxjJu2QIvvfOUeQBv/g=='),('2026-01-21 14:17:10.154011','2026-01-21 14:17:13.946273','2026-01-21 14:19:22.927841','7bec69d6-7c5b-46a1-99c5-7bd9fa1f5b93','7bec69d6-7c5b-46a1-99c5-7bd9fa1f5b93','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','alice bob','rw','AQDm33Bpmax0GRAAo47gGlScaRDeIC7SdPf+SQ=='),('2026-01-21 14:19:10.870586','2026-01-21 14:19:14.650401','2026-01-21 14:19:14.953220','8018c2d8-2467-4c70-99a2-1daaaa98e7ce','8018c2d8-2467-4c70-99a2-1daaaa98e7ce','7222a48c-e385-4ac8-9476-23ef2ccbfa6c','cephx','bob','rw','AQBX4HBpPcL8BxAAEpUSe8i+ZcG2oX3x9t8a6A=='),('2026-01-21 14:15:20.722414','2026-01-21 14:15:26.192387','2026-01-21 14:15:26.819460','8d5bfc90-e372-4beb-a9bc-ec10628ef966','8d5bfc90-e372-4beb-a9bc-ec10628ef966','498f15a0-21ee-49ad-8bf0-150074745f0c','cephx','tempest-cephx-id-1440431664','rw','AQB633BpjdlTIxAACX+1VJithmTEiax5JtfhrQ=='),('2026-01-21 14:16:45.994612','2026-01-21 14:16:52.030317','2026-01-21 14:19:22.927841','8f85a230-ec39-4c3b-a2eb-faeb5350c05f','8f85a230-ec39-4c3b-a2eb-faeb5350c05f','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','alice_bob','rw','AQDQ33BpIms1JBAAdJy/inqFAEPUncAcRGb13A=='),('2026-01-21 14:17:17.172533','2026-01-21 14:17:21.017360','2026-01-21 14:19:22.927841','9060a010-b2ba-48a8-8d15-2b7e25cc399d','9060a010-b2ba-48a8-8d15-2b7e25cc399d','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','alice bob','ro','AQDt33BpyMe0NBAAKoAqghovoZ/RTrJ7aOTO2g=='),('2026-01-21 14:16:45.906540','2026-01-21 14:17:11.325724','2026-01-21 14:17:46.631992','9c2e3a07-b8e3-4bc6-a2a5-e7d17e4416e7','9c2e3a07-b8e3-4bc6-a2a5-e7d17e4416e7','688d05e3-d534-4588-8ef1-588302e0580a','cephx','Joe','rw','AQDQ33BpGnnxChAAlyccNwIgSzAFmTFo7c4ffg=='),('2026-01-21 14:18:30.885475','2026-01-21 14:18:34.744264','2026-01-21 14:19:22.927841','a6427195-0352-4801-8066-77617268234a','a6427195-0352-4801-8066-77617268234a','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','alice_bob','rw','AQA34HBpd+EvChAADiPfDrF6uq0FG1l2zJBK6A=='),('2026-01-21 14:15:40.514249','2026-01-21 14:15:44.505743','2026-01-21 14:19:22.927841','bc39977f-a10f-4ba6-8cc1-7a4e784f9460','bc39977f-a10f-4ba6-8cc1-7a4e784f9460','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','alice','rw','AQCN33BpzYmFAhAAfcI8ZYTbEQ6Y8VtJlz4Gmg=='),('2026-01-21 14:14:17.155534','2026-01-21 14:14:39.218896','2026-01-21 14:14:39.724423','c2dd5996-4662-4c33-b91a-736e0bd5654c','c2dd5996-4662-4c33-b91a-736e0bd5654c','e556b944-c601-4d6a-9a44-72d806af4101','cephx','eve49','rw','AQA733BpH2F9ARAADg5TGeUvo2Um6+IF30IwjA=='),('2026-01-21 14:15:32.968644','2026-01-21 14:15:36.875325','2026-01-21 14:15:37.911003','c93483fb-0cf5-47b1-801c-8b49b03481f0','c93483fb-0cf5-47b1-801c-8b49b03481f0','073f2038-c750-4560-82ed-b9e3b4ba99e5','cephx','tempest-cephx-id-1440431664','rw','AQCF33BpbgGpDhAAYuvOpR8rTfhlWy+jVk7Juw=='),('2026-01-21 14:18:16.578012','2026-01-21 14:18:20.521410','2026-01-21 14:19:22.927841','caacee66-d62e-4269-831b-b9164cee8b34','caacee66-d62e-4269-831b-b9164cee8b34','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','alice','rw','AQAp4HBpLtDMCBAA3LjywAkqyVhwFwiktXB/Pw=='),('2026-01-21 14:16:55.482374','2026-01-21 14:17:03.694853','2026-01-21 14:19:22.927841','cf1a9052-36f7-4c12-bc1f-0d55d827cb9e','cf1a9052-36f7-4c12-bc1f-0d55d827cb9e','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','alice_bob','ro','AQDY33BpXW86MRAAs1Ai3axRhw0BaZ5T94ZegQ=='),('2026-01-21 14:15:55.257922','2026-01-21 14:15:59.183927','2026-01-21 14:19:22.927841','d507cb4c-0c93-4a05-8edb-38197de194f7','d507cb4c-0c93-4a05-8edb-38197de194f7','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','alice_bob','rw','AQCb33BpLhgrJhAAQK/HedfGVLw3nqEpofF45A=='),('2026-01-21 14:15:55.370209','2026-01-21 14:15:59.245576','2026-01-21 14:16:12.181478','d91a9234-6db5-45d1-bb79-36d2ac535226','d91a9234-6db5-45d1-bb79-36d2ac535226','1aabce1b-dbbb-4dae-a6a5-613066113ab2','cephx','tempest-cephx-id-1440431664','rw','AQCb33Bpl7dzMBAAr37mn4R3kbLhWGDuGqjv2Q=='),('2026-01-21 14:18:38.222791','2026-01-21 14:18:42.231732','2026-01-21 14:19:22.927841','d968ef4e-ffc0-4752-a18f-7af8f4f91ae1','d968ef4e-ffc0-4752-a18f-7af8f4f91ae1','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','alice_bob','ro','AQA/4HBpuEUcFRAAun5U6cFNPbiJWALnO5QG3A=='),('2026-01-21 14:16:37.949629','2026-01-21 14:16:42.805920','2026-01-21 14:19:22.927841','dd338092-0108-442d-9927-697fcdd5c74a','dd338092-0108-442d-9927-697fcdd5c74a','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','alice','ro','AQDH33BpN+UwERAA6/w+i4TX2XsypevkEv1e3w=='),('2026-01-21 14:17:48.804685','2026-01-21 14:17:52.517475','2026-01-21 14:19:22.927841','e4fcffce-4863-4b39-ada5-75f5c208e5fe','e4fcffce-4863-4b39-ada5-75f5c208e5fe','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','alice_bob','ro','AQAN4HBpQNrqDBAATKpGCws2VQ6BPNrbYn7xXA=='),('2026-01-21 14:17:18.385802','2026-01-21 14:17:33.602972','2026-01-21 14:17:50.658038','ec196e24-f83a-4ac8-b0a4-bf7ba3249a9d','ec196e24-f83a-4ac8-b0a4-bf7ba3249a9d','ca6daf26-9831-4772-bcf0-7b69e0070af8','cephx','david','rw','AQDu33Bp3x/fJRAA+wR1/3sFsWRkGhfdBN/hqQ=='),('2026-01-21 14:18:45.731436','2026-01-21 14:18:49.700290','2026-01-21 14:19:22.927841','f0394560-3a69-460f-85da-aac5a85fa1c7','f0394560-3a69-460f-85da-aac5a85fa1c7','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','alice bob','rw','AQBG4HBptUwyLBAAv2/h6gZ24ISMO/CMV2VbgQ=='),('2026-01-21 14:18:23.675561','2026-01-21 14:18:27.981941','2026-01-21 14:19:22.927841','f72ec979-9c51-4398-a9e0-d46e5cc45485','f72ec979-9c51-4398-a9e0-d46e5cc45485','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','alice','ro','AQAw4HBpTm3eDBAAmVJn+oUDy0BvjYedLy8h+g=='),('2026-01-21 14:16:26.786264','2026-01-21 14:16:34.622995','2026-01-21 14:19:22.927841','f7a98923-7de4-4a13-8ae8-ef8a4425d645','f7a98923-7de4-4a13-8ae8-ef8a4425d645','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','alice','rw','AQC733BpTv72BBAA+I/YkRlDGZc1i65VJ//IHA=='),('2026-01-21 14:18:03.745653','2026-01-21 14:18:13.240418','2026-01-21 14:19:22.927841','f7cedbeb-e2df-44ad-a281-e8c06d36df3f','f7cedbeb-e2df-44ad-a281-e8c06d36df3f','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','alice bob','ro','AQAc4HBpH/f0NRAAPWieJzA42BZkYhVpcvkWNg=='),('2026-01-21 14:15:03.129692','2026-01-21 14:15:08.875632','2026-01-21 14:15:12.392691','fc1f0aeb-f5ea-407c-ab18-67dbde7db4af','fc1f0aeb-f5ea-407c-ab18-67dbde7db4af','ba13b15f-cf4d-49e6-8796-991bdc13606f','cephx','tempest-cephx-id-1440431664','rw','AQBo33BpDS16ABAApO9e7u3u6TJjm0IjpnWMXQ=='),('2026-01-21 14:16:10.353603','2026-01-21 14:16:14.539526','2026-01-21 14:19:22.927841','fc52062a-3334-4b12-875d-9db36e7d895b','fc52062a-3334-4b12-875d-9db36e7d895b','fc256f6b-1503-4a6e-8c37-1daea3157b6f','cephx','alice bob','rw','AQCq33BpEkr+LBAAtzh4oWbTuuSaW5GWRt4wBQ==');
/*!40000 ALTER TABLE `share_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_access_rules_metadata`
--

DROP TABLE IF EXISTS `share_access_rules_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_access_rules_metadata` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `access_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `access_id` (`access_id`),
  CONSTRAINT `share_access_rules_metadata_ibfk_1` FOREIGN KEY (`access_id`) REFERENCES `share_access_map` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_access_rules_metadata`
--

LOCK TABLES `share_access_rules_metadata` WRITE;
/*!40000 ALTER TABLE `share_access_rules_metadata` DISABLE KEYS */;
INSERT INTO `share_access_rules_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `access_id`, `key`, `value`, `id`) VALUES ('2026-01-21 14:14:17.157465',NULL,'2026-01-21 14:14:39.579463','1','c2dd5996-4662-4c33-b91a-736e0bd5654c','key1','value1',1),('2026-01-21 14:14:17.452832','2026-01-21 14:14:38.087789','2026-01-21 14:14:39.579463','2','c2dd5996-4662-4c33-b91a-736e0bd5654c','key2','value6_new',2),('2026-01-21 14:14:21.010585',NULL,'2026-01-21 14:14:26.944622','3','0d84db21-6050-4abd-a9b6-92283fa14449','key3','v3',3),('2026-01-21 14:14:21.011121',NULL,'2026-01-21 14:14:26.944622','4','0d84db21-6050-4abd-a9b6-92283fa14449','key4','value4',4),('2026-01-21 14:14:30.055339','2026-01-21 14:14:33.923429','2026-01-21 14:14:34.979633','5','0adb5035-75c4-4a10-8bcf-d4e25bee71bc','key1','vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv',5),('2026-01-21 14:14:30.056401','2026-01-21 14:14:34.065116','2026-01-21 14:14:34.979633','6','0adb5035-75c4-4a10-8bcf-d4e25bee71bc','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value2',6),('2026-01-21 14:14:38.078936',NULL,'2026-01-21 14:14:39.579463','7','c2dd5996-4662-4c33-b91a-736e0bd5654c','key7','value7',7),('2026-01-21 14:15:05.059422',NULL,'2026-01-21 14:15:09.196441','8','26fecfd8-20b9-4f38-8bad-d59efa8c547e','key1','value1',8),('2026-01-21 14:15:55.373046',NULL,'2026-01-21 14:15:59.742369','9','d91a9234-6db5-45d1-bb79-36d2ac535226','key1','v1',9),('2026-01-21 14:15:55.374014',NULL,'2026-01-21 14:15:59.742369','10','d91a9234-6db5-45d1-bb79-36d2ac535226','key2','v2',10),('2026-01-21 14:16:02.481563',NULL,'2026-01-21 14:16:07.424147','11','1e47e7aa-cb8e-4984-ad0f-c0fee186d808','key1','v1',11),('2026-01-21 14:16:02.482118',NULL,'2026-01-21 14:16:07.424147','12','1e47e7aa-cb8e-4984-ad0f-c0fee186d808','key2','v2',12);
/*!40000 ALTER TABLE `share_access_rules_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_share_type_mappings`
--

DROP TABLE IF EXISTS `share_group_share_type_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_share_type_mappings` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_group_id` varchar(36) DEFAULT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_sgstm_share_group_id` (`share_group_id`),
  KEY `fk_sgstm_share_type_id` (`share_type_id`),
  CONSTRAINT `fk_sgstm_share_group_id` FOREIGN KEY (`share_group_id`) REFERENCES `share_groups` (`id`),
  CONSTRAINT `fk_sgstm_share_type_id` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_share_type_mappings`
--

LOCK TABLES `share_group_share_type_mappings` WRITE;
/*!40000 ALTER TABLE `share_group_share_type_mappings` DISABLE KEYS */;
INSERT INTO `share_group_share_type_mappings` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_group_id`, `share_type_id`) VALUES ('be7a6afa-b773-4bb2-b2a5-24da15269207','2026-01-21 14:18:00.368682',NULL,'2026-01-21 14:18:04.240893','be7a6afa-b773-4bb2-b2a5-24da15269207','aefb1c02-8305-4e9b-9f91-87659561ca53','a36cdb63-0be1-431b-b3a6-13bc024a485c'),('cf8be67a-2e75-494f-a9e4-40759412e612','2026-01-21 14:18:05.449436',NULL,'2026-01-21 14:18:16.693155','cf8be67a-2e75-494f-a9e4-40759412e612','701e45e4-89b7-4d59-81cf-4a02e67d640b','a36cdb63-0be1-431b-b3a6-13bc024a485c');
/*!40000 ALTER TABLE `share_group_share_type_mappings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_snapshots`
--

DROP TABLE IF EXISTS `share_group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_snapshots` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `share_group_id` varchar(36) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_share_group_snapshots_share_group_id` (`share_group_id`),
  CONSTRAINT `fk_share_group_snapshots_share_group_id` FOREIGN KEY (`share_group_id`) REFERENCES `share_groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_snapshots`
--

LOCK TABLES `share_group_snapshots` WRITE;
/*!40000 ALTER TABLE `share_group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_type_projects`
--

DROP TABLE IF EXISTS `share_group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sgtp_project_id_uc` (`share_group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `sgtp_id_fk` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_type_projects`
--

LOCK TABLES `share_group_type_projects` WRITE;
/*!40000 ALTER TABLE `share_group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_type_share_type_mappings`
--

DROP TABLE IF EXISTS `share_group_type_share_type_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_type_share_type_mappings` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_group_type_id` varchar(36) NOT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sgtp_id_sgt_id_uc` (`share_group_type_id`),
  KEY `sgtp_id_st_id_uc` (`share_type_id`),
  CONSTRAINT `sgtp_id_sgt_id_uc` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`),
  CONSTRAINT `sgtp_id_st_id_uc` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_type_share_type_mappings`
--

LOCK TABLES `share_group_type_share_type_mappings` WRITE;
/*!40000 ALTER TABLE `share_group_type_share_type_mappings` DISABLE KEYS */;
INSERT INTO `share_group_type_share_type_mappings` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_group_type_id`, `share_type_id`) VALUES ('083cbf3e-d47a-49f3-bd43-bc293fafd1f6','2026-01-21 14:17:38.377358',NULL,'2026-01-21 14:18:31.742939','083cbf3e-d47a-49f3-bd43-bc293fafd1f6','e6f440f5-e15d-4e76-a6d3-9851bafac07e','a36cdb63-0be1-431b-b3a6-13bc024a485c'),('11905a24-b773-4b91-b937-1fca583b7e8a','2026-01-21 14:11:20.979222',NULL,'2026-01-21 14:12:11.660673','11905a24-b773-4b91-b937-1fca583b7e8a','a454f3e8-b8ca-4320-8307-c8cf11685092','c5bac032-cc46-4150-aad5-9325071c0935'),('4b801539-5201-4ba2-88b6-fa5192d647ce','2026-01-21 14:11:01.427124',NULL,'2026-01-21 14:12:02.662229','4b801539-5201-4ba2-88b6-fa5192d647ce','87f97308-c50f-4e98-a5fd-4c817110cda5','de4f8dd5-59c7-4043-a6d2-b1a1fa120cc6'),('848dc049-6c14-4f89-8158-a0f31e66f096','2026-01-21 14:18:42.408394',NULL,'2026-01-21 14:18:44.830216','848dc049-6c14-4f89-8158-a0f31e66f096','83dde095-423f-49ba-bdee-28fe7352687a','524f3f41-1bea-4cc7-88dc-f04916d1f10b');
/*!40000 ALTER TABLE `share_group_type_share_type_mappings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_type_specs`
--

DROP TABLE IF EXISTS `share_group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `spec_key` varchar(255) DEFAULT NULL,
  `spec_value` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sgtp_id_extra_specs_fk` (`share_group_type_id`),
  CONSTRAINT `sgtp_id_extra_specs_fk` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_type_specs`
--

LOCK TABLES `share_group_type_specs` WRITE;
/*!40000 ALTER TABLE `share_group_type_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_group_types`
--

DROP TABLE IF EXISTS `share_group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_group_types` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_share_group_type_name` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_group_types`
--

LOCK TABLES `share_group_types` WRITE;
/*!40000 ALTER TABLE `share_group_types` DISABLE KEYS */;
INSERT INTO `share_group_types` (`id`, `created_at`, `updated_at`, `deleted_at`, `is_public`, `name`, `deleted`) VALUES ('83dde095-423f-49ba-bdee-28fe7352687a','2026-01-21 14:18:42.407743',NULL,'2026-01-21 14:18:44.832992',1,'tempest-unique_sgtype_name-758244870','83dde095-423f-49ba-bdee-28fe7352687a'),('87f97308-c50f-4e98-a5fd-4c817110cda5','2026-01-21 14:11:01.425498',NULL,'2026-01-21 14:12:02.667963',1,'tempest-unique_sgtype_name-446993243','87f97308-c50f-4e98-a5fd-4c817110cda5'),('a454f3e8-b8ca-4320-8307-c8cf11685092','2026-01-21 14:11:20.978350',NULL,'2026-01-21 14:12:11.666933',1,'tempest-unique_sgtype_name-1939674872','a454f3e8-b8ca-4320-8307-c8cf11685092'),('e6f440f5-e15d-4e76-a6d3-9851bafac07e','2026-01-21 14:17:38.370573',NULL,'2026-01-21 14:18:31.748936',1,'tempest-unique_sgtype_name-1497251573','e6f440f5-e15d-4e76-a6d3-9851bafac07e');
/*!40000 ALTER TABLE `share_group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_groups`
--

DROP TABLE IF EXISTS `share_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_groups` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `host` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `source_share_group_snapshot_id` varchar(36) DEFAULT NULL,
  `share_network_id` varchar(36) DEFAULT NULL,
  `share_server_id` varchar(36) DEFAULT NULL,
  `share_group_type_id` varchar(36) DEFAULT NULL,
  `consistent_snapshot_support` enum('pool','host') DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_share_group_share_network_id` (`share_network_id`),
  KEY `fk_share_group_share_server_id` (`share_server_id`),
  KEY `sgt_id_sg_id_uc` (`share_group_type_id`),
  CONSTRAINT `fk_share_group_share_network_id` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`),
  CONSTRAINT `fk_share_group_share_server_id` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`),
  CONSTRAINT `sgt_id_sg_id_uc` FOREIGN KEY (`share_group_type_id`) REFERENCES `share_group_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_groups`
--

LOCK TABLES `share_groups` WRITE;
/*!40000 ALTER TABLE `share_groups` DISABLE KEYS */;
INSERT INTO `share_groups` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `user_id`, `project_id`, `host`, `name`, `description`, `status`, `source_share_group_snapshot_id`, `share_network_id`, `share_server_id`, `share_group_type_id`, `consistent_snapshot_support`, `availability_zone_id`) VALUES ('701e45e4-89b7-4d59-81cf-4a02e67d640b','2026-01-21 14:18:12.225651','2026-01-21 14:18:16.691991','2026-01-21 14:18:16.691298','701e45e4-89b7-4d59-81cf-4a02e67d640b','847ff8e5688c42c1bb942b9ed884ef49','057c07904cd34efc9ceea6ab2d3e4d04','hostgroup@cephfs#cephfs',NULL,NULL,'deleting',NULL,NULL,NULL,'e6f440f5-e15d-4e76-a6d3-9851bafac07e',NULL,'63c64197-bff4-402b-8808-40cae651ac91'),('aefb1c02-8305-4e9b-9f91-87659561ca53','2026-01-21 14:18:00.775026','2026-01-21 14:18:04.239866','2026-01-21 14:18:04.238922','aefb1c02-8305-4e9b-9f91-87659561ca53','847ff8e5688c42c1bb942b9ed884ef49','057c07904cd34efc9ceea6ab2d3e4d04','hostgroup@cephfs#cephfs',NULL,NULL,'deleting',NULL,NULL,NULL,'e6f440f5-e15d-4e76-a6d3-9851bafac07e',NULL,'63c64197-bff4-402b-8808-40cae651ac91');
/*!40000 ALTER TABLE `share_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instance_access_map`
--

DROP TABLE IF EXISTS `share_instance_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instance_access_map` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `share_instance_id` varchar(36) DEFAULT NULL,
  `access_id` varchar(36) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `siam_instance_fk` (`share_instance_id`),
  KEY `siam_access_fk` (`access_id`),
  CONSTRAINT `siam_access_fk` FOREIGN KEY (`access_id`) REFERENCES `share_access_map` (`id`),
  CONSTRAINT `siam_instance_fk` FOREIGN KEY (`share_instance_id`) REFERENCES `share_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instance_access_map`
--

LOCK TABLES `share_instance_access_map` WRITE;
/*!40000 ALTER TABLE `share_instance_access_map` DISABLE KEYS */;
INSERT INTO `share_instance_access_map` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_instance_id`, `access_id`, `state`) VALUES ('2026-01-21 14:16:02.493149','2026-01-21 14:16:07.422276','2026-01-21 14:16:07.421827','011dd585-cd21-4536-82f3-fccf705a88ec','011dd585-cd21-4536-82f3-fccf705a88ec','cb5ab99b-0e59-4153-829e-95580fc1cdff','1e47e7aa-cb8e-4984-ad0f-c0fee186d808','deleted'),('2026-01-21 14:19:10.880396','2026-01-21 14:19:14.950274','2026-01-21 14:19:14.949866','056a7af1-7d06-42e4-a7dc-caa3460aa519','056a7af1-7d06-42e4-a7dc-caa3460aa519','c707dfa3-0985-4b01-bd2d-86b20bf31443','8018c2d8-2467-4c70-99a2-1daaaa98e7ce','deleted'),('2026-01-21 14:15:40.478619','2026-01-21 14:15:45.393665','2026-01-21 14:15:45.393254','06477cdd-ba69-4ec5-b100-9a927237c0bc','06477cdd-ba69-4ec5-b100-9a927237c0bc','cb5ab99b-0e59-4153-829e-95580fc1cdff','6d69d8aa-0bc4-4a62-996b-d44bf55c6244','deleted'),('2026-01-21 14:16:59.772441','2026-01-21 14:17:07.757547','2026-01-21 14:17:07.757002','0ad21bee-edd0-4c87-a325-aa28318fa7d3','0ad21bee-edd0-4c87-a325-aa28318fa7d3','7a1d41ab-f2a7-4734-8f5d-029c6fa0d7e3','2bbbf40a-e79d-475e-bf8e-4e71a49e03dc','deleted'),('2026-01-21 14:16:37.962090','2026-01-21 14:16:43.092291','2026-01-21 14:16:43.091836','107950fd-7855-4426-8d15-9a269ad476dd','107950fd-7855-4426-8d15-9a269ad476dd','424167b3-6c3d-4062-8da1-4d053af4cf7b','dd338092-0108-442d-9927-697fcdd5c74a','deleted'),('2026-01-21 14:18:53.372215','2026-01-21 14:18:59.586604','2026-01-21 14:18:59.586199','190bd1af-a272-48ea-a8fd-04295c3e9822','190bd1af-a272-48ea-a8fd-04295c3e9822','424167b3-6c3d-4062-8da1-4d053af4cf7b','40248d4a-a7f6-4c06-91d3-0ba3ad0a42ee','deleted'),('2026-01-21 14:15:55.385372','2026-01-21 14:15:59.740626','2026-01-21 14:15:59.740257','1a8b04d2-6b31-4f20-92d9-8b9d521b1891','1a8b04d2-6b31-4f20-92d9-8b9d521b1891','cb5ab99b-0e59-4153-829e-95580fc1cdff','d91a9234-6db5-45d1-bb79-36d2ac535226','deleted'),('2026-01-21 14:17:25.819985','2026-01-21 14:17:30.064556','2026-01-21 14:17:30.064076','21da171b-52fd-4a6e-9ae6-a615e9c1930c','21da171b-52fd-4a6e-9ae6-a615e9c1930c','61ae05c8-89f3-407b-bbf2-1e843fc0b15c','0ef1a8a3-733b-40d2-90b4-047c73350fbd','deleted'),('2026-01-21 14:17:41.654611','2026-01-21 14:17:45.881973','2026-01-21 14:17:45.881516','21f36d60-8fa4-45b6-b035-902af85c30a3','21f36d60-8fa4-45b6-b035-902af85c30a3','424167b3-6c3d-4062-8da1-4d053af4cf7b','3d62b1c7-afd1-4569-a2a8-484e020c5a25','deleted'),('2026-01-21 14:17:18.397464','2026-01-21 14:17:34.134836','2026-01-21 14:17:34.134580','23a8196c-4936-4310-b4a0-cbb4b0eac68a','23a8196c-4936-4310-b4a0-cbb4b0eac68a','d4d9a3e7-c006-4c96-ab86-0ee694f36366','ec196e24-f83a-4ac8-b0a4-bf7ba3249a9d','deleted'),('2026-01-21 14:16:55.498079','2026-01-21 14:17:07.063716','2026-01-21 14:17:07.063272','2569545a-2375-4a0d-9677-23309c59e5e5','2569545a-2375-4a0d-9677-23309c59e5e5','424167b3-6c3d-4062-8da1-4d053af4cf7b','cf1a9052-36f7-4c12-bc1f-0d55d827cb9e','deleted'),('2026-01-21 14:17:14.647371','2026-01-21 14:17:50.437119','2026-01-21 14:17:50.436669','31e450fa-987c-49fe-8832-f271c8dd7ba7','31e450fa-987c-49fe-8832-f271c8dd7ba7','d4d9a3e7-c006-4c96-ab86-0ee694f36366','2297f3e5-f5cb-4bbe-8382-81de55b382a3','deleted'),('2026-01-21 14:16:45.917680','2026-01-21 14:17:12.088825','2026-01-21 14:17:12.088417','37305472-8cfd-4be4-bc4f-310b6e5bd8a1','37305472-8cfd-4be4-bc4f-310b6e5bd8a1','9d63fab0-cc30-4952-b485-806c5f0f78c2','9c2e3a07-b8e3-4bc6-a2a5-e7d17e4416e7','deleted'),('2026-01-21 14:18:03.762851','2026-01-21 14:18:13.484356','2026-01-21 14:18:13.483899','3a048105-c729-431a-8e6a-6a159c8f5ebb','3a048105-c729-431a-8e6a-6a159c8f5ebb','424167b3-6c3d-4062-8da1-4d053af4cf7b','f7cedbeb-e2df-44ad-a281-e8c06d36df3f','deleted'),('2026-01-21 14:15:48.013167','2026-01-21 14:15:52.176854','2026-01-21 14:15:52.176501','3f28bd0f-4dca-4167-abc9-88b489afbcda','3f28bd0f-4dca-4167-abc9-88b489afbcda','424167b3-6c3d-4062-8da1-4d053af4cf7b','6194110d-8c30-4666-8cde-4191b117c2cd','deleted'),('2026-01-21 14:15:03.148728','2026-01-21 14:15:09.540198','2026-01-21 14:15:09.539731','413aae37-2b8e-4d72-aa99-e18d145ffe2a','413aae37-2b8e-4d72-aa99-e18d145ffe2a','0b71204a-52c0-4e93-8d46-339e009b5492','fc1f0aeb-f5ea-407c-ab18-67dbde7db4af','deleted'),('2026-01-21 14:16:46.009401','2026-01-21 14:16:52.914437','2026-01-21 14:16:52.913888','486e469a-87f6-441c-8749-a3f16c13f8bf','486e469a-87f6-441c-8749-a3f16c13f8bf','424167b3-6c3d-4062-8da1-4d053af4cf7b','8f85a230-ec39-4c3b-a2eb-faeb5350c05f','deleted'),('2026-01-21 14:17:32.038953','2026-01-21 14:17:38.826703','2026-01-21 14:17:38.826183','494ddcf8-33d6-4659-944a-e0652a7ec49d','494ddcf8-33d6-4659-944a-e0652a7ec49d','424167b3-6c3d-4062-8da1-4d053af4cf7b','630eb073-1060-4849-934d-89c1d1c194b1','deleted'),('2026-01-21 14:14:17.469849','2026-01-21 14:14:39.576995','2026-01-21 14:14:39.576213','580605ad-7439-4a1d-a927-744563b70271','580605ad-7439-4a1d-a927-744563b70271','0a87ab89-25c8-43d7-9b97-672b44e8c221','c2dd5996-4662-4c33-b91a-736e0bd5654c','deleted'),('2026-01-21 14:15:55.270239','2026-01-21 14:15:59.470074','2026-01-21 14:15:59.469637','599a4a93-b9cb-4657-9d69-a40b7d814f7e','599a4a93-b9cb-4657-9d69-a40b7d814f7e','424167b3-6c3d-4062-8da1-4d053af4cf7b','d507cb4c-0c93-4a05-8edb-38197de194f7','deleted'),('2026-01-21 14:18:45.749414','2026-01-21 14:18:49.937847','2026-01-21 14:18:49.937367','5cf3044b-39ce-4c85-92a3-415ab7a609cc','5cf3044b-39ce-4c85-92a3-415ab7a609cc','424167b3-6c3d-4062-8da1-4d053af4cf7b','f0394560-3a69-460f-85da-aac5a85fa1c7','deleted'),('2026-01-21 14:18:30.897119','2026-01-21 14:18:34.989313','2026-01-21 14:18:34.988741','6bd45f5b-08b0-4a91-92c0-2f953fb39a5e','6bd45f5b-08b0-4a91-92c0-2f953fb39a5e','424167b3-6c3d-4062-8da1-4d053af4cf7b','a6427195-0352-4801-8066-77617268234a','deleted'),('2026-01-21 14:15:32.984698','2026-01-21 14:15:37.392624','2026-01-21 14:15:37.392259','81183a29-b4b3-4e32-b1d7-67d79e6b069f','81183a29-b4b3-4e32-b1d7-67d79e6b069f','5991b6dd-3598-462c-9b52-78412a23786c','c93483fb-0cf5-47b1-801c-8b49b03481f0','deleted'),('2026-01-21 14:17:56.393698','2026-01-21 14:18:00.825559','2026-01-21 14:18:00.825068','8e0f5164-f834-463e-b04f-022123ef6373','8e0f5164-f834-463e-b04f-022123ef6373','424167b3-6c3d-4062-8da1-4d053af4cf7b','419c5e7a-8933-4a3d-a4f6-fa4bf046aef0','deleted'),('2026-01-21 14:16:10.365232','2026-01-21 14:16:14.938767','2026-01-21 14:16:14.938389','916c8e8e-f8ec-4abe-937a-f8ef61ed255d','916c8e8e-f8ec-4abe-937a-f8ef61ed255d','424167b3-6c3d-4062-8da1-4d053af4cf7b','fc52062a-3334-4b12-875d-9db36e7d895b','deleted'),('2026-01-21 14:15:20.733016','2026-01-21 14:15:26.463352','2026-01-21 14:15:26.462779','969653df-7281-448c-b80d-2a29e65d9d1a','969653df-7281-448c-b80d-2a29e65d9d1a','c804cc91-0101-4131-a680-b760e9df84f1','8d5bfc90-e372-4beb-a9bc-ec10628ef966','deleted'),('2026-01-21 14:16:02.506069','2026-01-21 14:16:07.252959','2026-01-21 14:16:07.252589','a230483b-c7e5-42b3-ae34-b2b002ee20d4','a230483b-c7e5-42b3-ae34-b2b002ee20d4','424167b3-6c3d-4062-8da1-4d053af4cf7b','04c63bc4-424f-49f5-ba37-1b8819c4e899','deleted'),('2026-01-21 14:17:24.360193','2026-01-21 14:17:29.164536','2026-01-21 14:17:29.164064','a54592a4-7439-4f87-87bb-455006433f95','a54592a4-7439-4f87-87bb-455006433f95','424167b3-6c3d-4062-8da1-4d053af4cf7b','73bbbc4c-6b71-4850-909d-1fbd6a2f0932','deleted'),('2026-01-21 14:19:02.620951','2026-01-21 14:19:18.660466','2026-01-21 14:19:18.659717','a8e1f987-c6ac-49f3-a11e-1bfa98149389','a8e1f987-c6ac-49f3-a11e-1bfa98149389','424167b3-6c3d-4062-8da1-4d053af4cf7b','4765b77d-de28-4870-bc36-7b4a3c1eac7c','deleted'),('2026-01-21 14:16:17.897598','2026-01-21 14:16:23.711542','2026-01-21 14:16:23.711080','aa15fa0e-fed7-4178-9ce5-ebe4ad8194e2','aa15fa0e-fed7-4178-9ce5-ebe4ad8194e2','424167b3-6c3d-4062-8da1-4d053af4cf7b','1fabf8cd-2938-4185-9a71-42bd0f2f8661','deleted'),('2026-01-21 14:17:10.172197','2026-01-21 14:17:14.225200','2026-01-21 14:17:14.224795','abd88d3e-1723-41dc-8c8f-5b19b46f610a','abd88d3e-1723-41dc-8c8f-5b19b46f610a','424167b3-6c3d-4062-8da1-4d053af4cf7b','7bec69d6-7c5b-46a1-99c5-7bd9fa1f5b93','deleted'),('2026-01-21 14:14:21.023462','2026-01-21 14:14:26.941333','2026-01-21 14:14:26.940549','add4f1e4-b8e9-4751-8712-fb1de73c7101','add4f1e4-b8e9-4751-8712-fb1de73c7101','0a87ab89-25c8-43d7-9b97-672b44e8c221','0d84db21-6050-4abd-a9b6-92283fa14449','deleted'),('2026-01-21 14:18:23.688762','2026-01-21 14:18:28.736262','2026-01-21 14:18:28.735885','c1cbe1e8-4bf7-4109-b724-6c35ae1a40cb','c1cbe1e8-4bf7-4109-b724-6c35ae1a40cb','424167b3-6c3d-4062-8da1-4d053af4cf7b','f72ec979-9c51-4398-a9e0-d46e5cc45485','deleted'),('2026-01-21 14:14:30.070240','2026-01-21 14:14:34.977334','2026-01-21 14:14:34.976932','cee99d99-b644-44e8-85e2-5b6ed96303cb','cee99d99-b644-44e8-85e2-5b6ed96303cb','0a87ab89-25c8-43d7-9b97-672b44e8c221','0adb5035-75c4-4a10-8bcf-d4e25bee71bc','deleted'),('2026-01-21 14:16:26.798800','2026-01-21 14:16:34.997798','2026-01-21 14:16:34.997063','d6c7d2f5-de4b-47b2-96ac-491de6f227c4','d6c7d2f5-de4b-47b2-96ac-491de6f227c4','424167b3-6c3d-4062-8da1-4d053af4cf7b','f7a98923-7de4-4a13-8ae8-ef8a4425d645','deleted'),('2026-01-21 14:16:55.645029','2026-01-21 14:17:07.268966','2026-01-21 14:17:07.268499','d77f11a6-edc3-4905-b694-7af11a68678a','d77f11a6-edc3-4905-b694-7af11a68678a','7a1d41ab-f2a7-4734-8f5d-029c6fa0d7e3','1f444e7e-33c4-45eb-8eeb-11530f627d7c','deleted'),('2026-01-21 14:17:48.815545','2026-01-21 14:17:52.951215','2026-01-21 14:17:52.950284','d9a11ca3-65bd-4c2a-bd21-50a62543e223','d9a11ca3-65bd-4c2a-bd21-50a62543e223','424167b3-6c3d-4062-8da1-4d053af4cf7b','e4fcffce-4863-4b39-ada5-75f5c208e5fe','deleted'),('2026-01-21 14:15:40.525357','2026-01-21 14:15:45.218233','2026-01-21 14:15:45.217805','dc8fe7ac-08b8-4f22-a344-6414d85563da','dc8fe7ac-08b8-4f22-a344-6414d85563da','424167b3-6c3d-4062-8da1-4d053af4cf7b','bc39977f-a10f-4ba6-8cc1-7a4e784f9460','deleted'),('2026-01-21 14:18:16.595420','2026-01-21 14:18:20.766857','2026-01-21 14:18:20.766084','df6b3e61-d6ad-42be-956a-db5cb7ce4efc','df6b3e61-d6ad-42be-956a-db5cb7ce4efc','424167b3-6c3d-4062-8da1-4d053af4cf7b','caacee66-d62e-4269-831b-b9164cee8b34','deleted'),('2026-01-21 14:15:48.039335','2026-01-21 14:15:52.417902','2026-01-21 14:15:52.417482','f355e9f6-dbc5-4c88-8c33-167cc121106c','f355e9f6-dbc5-4c88-8c33-167cc121106c','cb5ab99b-0e59-4153-829e-95580fc1cdff','218cc456-62b1-4a12-a56c-077fa858d6e7','deleted'),('2026-01-21 14:17:17.187580','2026-01-21 14:17:21.894494','2026-01-21 14:17:21.894034','f8c60519-17e5-444a-8ef0-6605ffdd1341','f8c60519-17e5-444a-8ef0-6605ffdd1341','424167b3-6c3d-4062-8da1-4d053af4cf7b','9060a010-b2ba-48a8-8d15-2b7e25cc399d','deleted'),('2026-01-21 14:18:38.236727','2026-01-21 14:18:42.495482','2026-01-21 14:18:42.495039','fa2b90c6-ef38-4e2b-9eb5-db5e9780bf95','fa2b90c6-ef38-4e2b-9eb5-db5e9780bf95','424167b3-6c3d-4062-8da1-4d053af4cf7b','d968ef4e-ffc0-4752-a18f-7af8f4f91ae1','deleted'),('2026-01-21 14:15:05.088540','2026-01-21 14:15:09.194060','2026-01-21 14:15:09.193549','fe59f2dd-e0f8-4493-a90e-d1bda91c5f8b','fe59f2dd-e0f8-4493-a90e-d1bda91c5f8b','a27e07da-ba92-4d67-aa02-2edb8a28bc44','26fecfd8-20b9-4f38-8bad-d59efa8c547e','deleted');
/*!40000 ALTER TABLE `share_instance_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instance_export_locations`
--

DROP TABLE IF EXISTS `share_instance_export_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instance_export_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `path` varchar(2000) DEFAULT NULL,
  `share_instance_id` varchar(36) DEFAULT NULL,
  `is_admin_only` tinyint(1) DEFAULT NULL,
  `uuid` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `sel_instance_id_fk` (`share_instance_id`),
  CONSTRAINT `sel_instance_id_fk` FOREIGN KEY (`share_instance_id`) REFERENCES `share_instances` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instance_export_locations`
--

LOCK TABLES `share_instance_export_locations` WRITE;
/*!40000 ALTER TABLE `share_instance_export_locations` DISABLE KEYS */;
INSERT INTO `share_instance_export_locations` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `path`, `share_instance_id`, `is_admin_only`, `uuid`) VALUES (1,'2026-01-21 14:10:22.747515','2026-01-21 14:12:12.196037','2026-01-21 14:12:12.194159',1,'192.168.122.100:6789:/volumes/_nogroup/d3ce0e74-c7d0-4049-ba17-7d4296160447/d2577f41-d908-4371-8c43-e8fbe046d39f','d3ce0e74-c7d0-4049-ba17-7d4296160447',0,'71e1f082-51e8-487b-adf1-8176f42514eb'),(2,'2026-01-21 14:10:23.924513','2026-01-21 14:10:33.086959','2026-01-21 14:10:33.085345',2,'192.168.122.100:6789:/volumes/_nogroup/f1e76c5b-dd9f-45f4-b2d2-e22465776219/a6452fa6-7ff6-41a5-b0cb-e0c7da2f4521','f1e76c5b-dd9f-45f4-b2d2-e22465776219',0,'fd9f9af9-9733-4220-a6b1-f4b67afb6e3d'),(3,'2026-01-21 14:10:24.210082','2026-01-21 14:10:31.551625','2026-01-21 14:10:31.550276',3,'192.168.122.100:6789:/volumes/_nogroup/ec4e87bc-026b-4a6f-938e-c32b3b1010de/205f3a51-88be-4bba-be8f-7be277cabc08','ec4e87bc-026b-4a6f-938e-c32b3b1010de',0,'28e7a9e1-e3bc-4c17-b5fc-e46fce3364e6'),(4,'2026-01-21 14:10:25.603176','2026-01-21 14:10:28.674724','2026-01-21 14:10:28.672617',4,'192.168.122.100:6789:/volumes/_nogroup/ca297459-dcdc-48cc-b973-0a2fd8a93409/9de7cc8f-afb8-49c1-8ccf-2bc90c8f924e','ca297459-dcdc-48cc-b973-0a2fd8a93409',0,'2d163926-7531-4cd7-ac0f-b3159e7fd23f'),(5,'2026-01-21 14:10:33.050242','2026-01-21 14:10:39.115853','2026-01-21 14:10:39.114344',5,'192.168.122.100:6789:/volumes/_nogroup/0a16a328-6a6b-4997-8d01-233d8aaecf94/ca18ae93-6039-44b0-aed6-bffe7b551018','0a16a328-6a6b-4997-8d01-233d8aaecf94',0,'c33d5f9c-8837-4032-9a1e-d97a26f05a7d'),(6,'2026-01-21 14:10:43.179718','2026-01-21 14:10:45.897256','2026-01-21 14:10:45.895924',6,'192.168.122.100:6789:/volumes/_nogroup/09f7a444-a5d6-4cd1-8195-bcb6a300bcd5/8b4e0f9c-cd5e-4a1d-b5b4-0c646ea195b3','09f7a444-a5d6-4cd1-8195-bcb6a300bcd5',0,'b15bf5b8-d949-40b1-acdd-54c5d38e0482'),(7,'2026-01-21 14:10:56.689716','2026-01-21 14:11:00.073045','2026-01-21 14:11:00.071599',7,'192.168.122.100:6789:/volumes/_nogroup/d765fd4c-f99f-46af-bd07-596dac7c37d5/801344bb-1db0-4dbb-90a5-ccedbd38215f','d765fd4c-f99f-46af-bd07-596dac7c37d5',0,'981ac7b6-1576-46d7-a527-1729f01957e4'),(8,'2026-01-21 14:11:03.600972','2026-01-21 14:11:13.328760','2026-01-21 14:11:13.327775',8,'192.168.122.100:6789:/volumes/_nogroup/18603bd9-4e2c-4abb-ab1b-01752b8839c2/deefac8d-d835-46fb-b96e-2a3f5c2af6a5','18603bd9-4e2c-4abb-ab1b-01752b8839c2',0,'1a4e086c-e016-4cb4-a72b-aff7c4836b34'),(9,'2026-01-21 14:11:07.991744','2026-01-21 14:11:16.878231','2026-01-21 14:11:16.876523',9,'192.168.122.100:6789:/volumes/_nogroup/73408dc6-4c0b-4079-a270-af31e9a2608f/0db648a5-66e9-45ca-ac1f-bc80d2193114','73408dc6-4c0b-4079-a270-af31e9a2608f',0,'110e409f-8f62-46a7-acb5-601b7b9fc866'),(10,'2026-01-21 14:11:21.701465','2026-01-21 14:12:08.584509','2026-01-21 14:12:08.583558',10,'192.168.122.100:6789:/volumes/_nogroup/be026c8c-9a77-4436-9eb0-bd80e75652ed/c17a5ed2-c845-4ea1-bc03-5533f6ecbf92','be026c8c-9a77-4436-9eb0-bd80e75652ed',0,'1bfb60b7-ddaa-4cc4-aae0-6e444de3b90f'),(11,'2026-01-21 14:11:28.415599','2026-01-21 14:12:04.128716','2026-01-21 14:12:04.117742',11,'192.168.122.100:6789:/volumes/_nogroup/901b9a46-d563-4a2c-bc82-2f893614e2f0/f9253af6-64bc-4ad7-b4bd-56feef7fa9fe','901b9a46-d563-4a2c-bc82-2f893614e2f0',0,'efa2a462-c670-442e-84a0-aaef4e80e0f8'),(12,'2026-01-21 14:12:17.396730','2026-01-21 14:12:20.325325','2026-01-21 14:12:20.324225',12,'192.168.122.100:6789:/volumes/_nogroup/ea104d42-8223-4da1-870a-ba39917e4943/1282aaf8-9b49-40e2-a843-a3b0a737b268','ea104d42-8223-4da1-870a-ba39917e4943',0,'065bac1c-d65a-43d3-8bbc-c3ebdf20fec5'),(13,'2026-01-21 14:12:31.579502','2026-01-21 14:12:36.467423','2026-01-21 14:12:36.466021',13,'192.168.122.100:6789:/volumes/_nogroup/672756b3-d8dc-429b-8b05-6a6f7934e823/1fba2d90-325a-4d51-8a85-96a3d9d56a0b','672756b3-d8dc-429b-8b05-6a6f7934e823',0,'c4f474c3-ad24-47b9-9dbe-2a0da482533a'),(14,'2026-01-21 14:12:45.821793','2026-01-21 14:12:58.979889','2026-01-21 14:12:58.978824',14,'192.168.122.100:6789:/volumes/_nogroup/909aa505-0296-4e74-80ca-1c8370556d29/992722e6-fc0f-4dc3-97ca-752fee9b705f','909aa505-0296-4e74-80ca-1c8370556d29',0,'75635c24-6a8d-47a5-b8a9-31df814abb57'),(15,'2026-01-21 14:12:50.393047','2026-01-21 14:13:15.217570','2026-01-21 14:13:15.216028',15,'192.168.122.100:6789:/volumes/_nogroup/1dd3a4c4-ba47-419f-88a7-3a23e3b00147/4f12a03b-2b1c-4bba-a51f-c6afbf76db5e','1dd3a4c4-ba47-419f-88a7-3a23e3b00147',0,'0ccbae40-1827-4a7e-bed5-e6885e6a59c2'),(16,'2026-01-21 14:13:21.318754','2026-01-21 14:14:21.814124','2026-01-21 14:14:21.812655',16,'192.168.122.100:6789:/volumes/_nogroup/1442b436-f5bb-47c2-acbf-ac7903d9399e/b0d2c918-ebda-4af3-87c7-5d6e78fc290b','1442b436-f5bb-47c2-acbf-ac7903d9399e',0,'d6379937-fc8e-441b-94f8-3b858bbe186c'),(17,'2026-01-21 14:13:39.103524','2026-01-21 14:13:58.633456','2026-01-21 14:13:58.632291',17,'192.168.122.100:6789:/volumes/_nogroup/bba0c3cf-adf3-468e-ae9d-3e37f7ff8fa0/c098c762-a168-49c0-8e80-1871b71016e6','bba0c3cf-adf3-468e-ae9d-3e37f7ff8fa0',0,'d371beed-30ad-4df6-b92f-e8b1fc93a627'),(18,'2026-01-21 14:13:41.877780','2026-01-21 14:14:37.350001','2026-01-21 14:14:37.348909',18,'192.168.122.100:6789:/volumes/_nogroup/98584c80-dc48-400e-a1ef-b94d26420f34/074547f2-7f4b-4646-af87-b0582d94198e','98584c80-dc48-400e-a1ef-b94d26420f34',0,'1e9c184e-21de-4d50-b4c4-d6d18b12739c'),(19,'2026-01-21 14:13:45.797574','2026-01-21 14:13:51.972184','2026-01-21 14:13:51.970752',19,'192.168.122.100:6789:/volumes/_nogroup/6321f0ab-1903-4b13-841b-f76cfd9c3cac/4132ab36-79f1-480e-a2a7-55e9bc4b49be','6321f0ab-1903-4b13-841b-f76cfd9c3cac',0,'57a795eb-ac26-452f-ae46-6fbb57c341df'),(20,'2026-01-21 14:13:56.888767','2026-01-21 14:14:00.790724','2026-01-21 14:14:00.789531',20,'192.168.122.100:6789:/volumes/_nogroup/e92e9c0d-aab4-453c-97fd-2dccbd1b01ca/3947d664-f79c-4559-a25c-0c3cb75d8faa','e92e9c0d-aab4-453c-97fd-2dccbd1b01ca',0,'89ea9ae8-ca3a-4b4b-a2b3-0695f67d4606'),(21,'2026-01-21 14:14:07.256948','2026-01-21 14:14:13.684154','2026-01-21 14:14:13.682639',21,'192.168.122.100:6789:/volumes/_nogroup/6fd14f2b-0487-4f6b-a678-d4c00c894fd8/441def10-d72f-43de-9c5a-cb8d8d24291f','6fd14f2b-0487-4f6b-a678-d4c00c894fd8',0,'57ec5cd6-6b86-4f37-8c9f-6e7c7aa513db'),(22,'2026-01-21 14:14:07.334457','2026-01-21 14:14:08.812956','2026-01-21 14:14:08.811906',22,'192.168.122.100:6789:/volumes/_nogroup/8bc5fdaa-02e4-4394-ab57-82acdd89427e/8d8c9d37-265b-4f39-a819-7b0f7f9a7c1c','8bc5fdaa-02e4-4394-ab57-82acdd89427e',0,'837d333b-89a6-450d-9648-7de08646477f'),(23,'2026-01-21 14:14:11.854802','2026-01-21 14:14:22.228056','2026-01-21 14:14:22.225922',23,'192.168.122.100:6789:/volumes/_nogroup/398fce8f-70d1-42b2-8ff9-f180fc0fd07c/9d663342-1ee6-4020-b764-46d047183f0b','398fce8f-70d1-42b2-8ff9-f180fc0fd07c',0,'4a4d0197-63c0-42e4-a18d-98edcd1d993a'),(24,'2026-01-21 14:14:13.497154','2026-01-21 14:14:19.471719','2026-01-21 14:14:19.470760',24,'192.168.122.100:6789:/volumes/_nogroup/ee86be96-97ed-41e6-a8dc-978f7f6c00d9/e221679c-b44b-4c53-ae2f-803a06a1737b','ee86be96-97ed-41e6-a8dc-978f7f6c00d9',0,'c97d7120-0f2a-4b2c-a120-8e52bfff73fd'),(25,'2026-01-21 14:14:14.488689','2026-01-21 14:14:39.695823','2026-01-21 14:14:39.694795',25,'192.168.122.100:6789:/volumes/_nogroup/0a87ab89-25c8-43d7-9b97-672b44e8c221/e7478f03-d463-4063-bb17-146a7fb16007','0a87ab89-25c8-43d7-9b97-672b44e8c221',0,'3380d763-acca-43c2-8cc8-814600cb17fc'),(26,'2026-01-21 14:14:26.625370','2026-01-21 14:14:30.056607','2026-01-21 14:14:30.055291',26,'192.168.122.100:6789:/volumes/_nogroup/dd111cee-cd8c-410d-afba-122eba9f97ef/598a97dd-299d-4cce-beaf-351d6cc6c6de','dd111cee-cd8c-410d-afba-122eba9f97ef',0,'f713269a-6c72-44b9-a1ff-f68e274431dc'),(27,'2026-01-21 14:14:53.739119','2026-01-21 14:16:12.159951','2026-01-21 14:16:12.159066',27,'192.168.122.100:6789:/volumes/_nogroup/cb5ab99b-0e59-4153-829e-95580fc1cdff/d1ede643-cc11-4a46-837a-818a7e57f478','cb5ab99b-0e59-4153-829e-95580fc1cdff',0,'f8d94ca6-6288-483a-9b76-2b8e9fd8651f'),(28,'2026-01-21 14:15:00.253847','2026-01-21 14:15:09.838832','2026-01-21 14:15:09.836788',28,'192.168.122.100:6789:/volumes/_nogroup/0b71204a-52c0-4e93-8d46-339e009b5492/1459d9db-30f5-43d3-af84-146db6808591','0b71204a-52c0-4e93-8d46-339e009b5492',0,'ba1995de-c396-494c-9858-372c56a6d0bb'),(29,'2026-01-21 14:15:00.293274','2026-01-21 14:15:05.759548','2026-01-21 14:15:05.757832',29,'192.168.122.100:6789:/volumes/_nogroup/74d6c6f5-e0f2-4207-b59c-99c525e6f1c7/a3cff92f-535d-4f55-9c8d-18e6e534e3fb','74d6c6f5-e0f2-4207-b59c-99c525e6f1c7',0,'8b152d8a-0636-4fe2-baae-2624a01c5e62'),(30,'2026-01-21 14:15:01.988650','2026-01-21 14:15:09.807755','2026-01-21 14:15:09.783589',30,'192.168.122.100:6789:/volumes/_nogroup/a27e07da-ba92-4d67-aa02-2edb8a28bc44/e23699aa-6ed1-45b2-bad4-4a8d71525ba5','a27e07da-ba92-4d67-aa02-2edb8a28bc44',0,'aa7fcd64-a7ad-4b89-9b20-7a2ed5f13b45'),(31,'2026-01-21 14:15:18.075737','2026-01-21 14:15:26.775761','2026-01-21 14:15:26.773922',31,'192.168.122.100:6789:/volumes/_nogroup/c804cc91-0101-4131-a680-b760e9df84f1/5e654857-70e7-450c-a3f9-033cf187753b','c804cc91-0101-4131-a680-b760e9df84f1',0,'61d7fcde-f97d-43c1-8b30-66475f219b82'),(32,'2026-01-21 14:15:29.814950','2026-01-21 14:15:37.883073','2026-01-21 14:15:37.881990',32,'192.168.122.100:6789:/volumes/_nogroup/5991b6dd-3598-462c-9b52-78412a23786c/1191fcfe-399e-45fb-be1f-5e25d8e752ac','5991b6dd-3598-462c-9b52-78412a23786c',0,'313653a4-2c30-4d5b-b7fb-9b142cdd296e'),(33,'2026-01-21 14:15:37.814232','2026-01-21 14:19:22.899941','2026-01-21 14:19:22.898726',33,'192.168.122.100:6789:/volumes/_nogroup/424167b3-6c3d-4062-8da1-4d053af4cf7b/04464bce-b5c2-48d9-860a-5b8b6ce45575','424167b3-6c3d-4062-8da1-4d053af4cf7b',0,'114234f0-b35d-4955-bce9-2353f79724df'),(34,'2026-01-21 14:15:50.271370','2026-01-21 14:16:00.863018','2026-01-21 14:16:00.861724',34,'192.168.122.100:6789:/volumes/_nogroup/49d5247d-28e2-437f-92c4-34b98896805f/742bffda-1701-416d-826e-80b5efe59ac3','49d5247d-28e2-437f-92c4-34b98896805f',0,'50e14378-4a2f-4e15-9454-8483866f9861'),(35,'2026-01-21 14:15:53.602167','2026-01-21 14:15:57.360779','2026-01-21 14:15:57.359341',35,'192.168.122.100:6789:/volumes/_nogroup/12981b05-fe8f-4fd8-aee2-ae12c976e9f6/40891370-3f9d-46b0-aed4-8e174a61d9cd','12981b05-fe8f-4fd8-aee2-ae12c976e9f6',0,'6f245ce9-903f-4b4e-93e7-3072942ef7cc'),(36,'2026-01-21 14:16:04.510793','2026-01-21 14:16:08.644196','2026-01-21 14:16:08.642804',36,'192.168.122.100:6789:/volumes/_nogroup/62ba25ce-388a-4a45-8f6e-7a5833c81f31/f099d9d8-babe-4015-821a-199cd77c6934','62ba25ce-388a-4a45-8f6e-7a5833c81f31',0,'19b869df-9f0f-4e6b-8207-393696e5f72a'),(37,'2026-01-21 14:16:19.899624','2026-01-21 14:16:34.304592','2026-01-21 14:16:34.303126',37,'192.168.122.100:6789:/volumes/_nogroup/a444a045-3a18-4422-831d-838f3d178e33/c1e7aa2f-b3f5-4340-abef-4ba3f2f8f5fc','a444a045-3a18-4422-831d-838f3d178e33',0,'700605d0-1bfc-44c2-b0ac-4e6298380e8a'),(38,'2026-01-21 14:16:27.645513','2026-01-21 14:16:36.267226','2026-01-21 14:16:36.265878',38,'192.168.122.100:6789:/volumes/_nogroup/96494b3b-24ff-4794-b86c-c27bb64a476f/114899ef-653e-4eb2-b694-cbe1ddce5d94','96494b3b-24ff-4794-b86c-c27bb64a476f',0,'13399708-b478-4daf-aa10-06e42dcbd37c'),(39,'2026-01-21 14:16:39.130679','2026-01-21 14:17:50.626868','2026-01-21 14:17:50.625733',39,'192.168.122.100:6789:/volumes/_nogroup/d4d9a3e7-c006-4c96-ab86-0ee694f36366/5021dd0b-410c-4556-8ea7-3591d44d4e37','d4d9a3e7-c006-4c96-ab86-0ee694f36366',0,'9c91da49-9a44-49dd-a632-6513802a0914'),(40,'2026-01-21 14:16:39.808842','2026-01-21 14:16:43.309074','2026-01-21 14:16:43.307990',40,'192.168.122.100:6789:/volumes/_nogroup/5006c4a9-49c2-40a4-8229-4463bddd3634/f85cfe1c-ebd8-429a-98e6-8135bd6e60d3','5006c4a9-49c2-40a4-8229-4463bddd3634',0,'328338d0-3a40-4f9e-a374-42a9af741549'),(41,'2026-01-21 14:16:42.768253','2026-01-21 14:17:46.592565','2026-01-21 14:17:46.590383',41,'192.168.122.100:6789:/volumes/_nogroup/9d63fab0-cc30-4952-b485-806c5f0f78c2/e6ee0d7e-e80e-4cfd-9421-b1c84c73d118','9d63fab0-cc30-4952-b485-806c5f0f78c2',0,'da276464-49b8-40fc-869a-2abe5fd3a1aa'),(42,'2026-01-21 14:16:48.768216','2026-01-21 14:17:16.673758','2026-01-21 14:17:16.672802',42,'192.168.122.100:6789:/volumes/_nogroup/d96d5fd8-0350-40e0-a742-9103d3d18e31/c83a9347-47a8-43c7-ae36-697341704e14','d96d5fd8-0350-40e0-a742-9103d3d18e31',0,'284946d8-bd1a-44e8-8c39-74b0c5dba27a'),(43,'2026-01-21 14:16:52.886895','2026-01-21 14:17:42.554845','2026-01-21 14:17:42.553682',43,'192.168.122.100:6789:/volumes/_nogroup/7a1d41ab-f2a7-4734-8f5d-029c6fa0d7e3/4677f60a-4f75-4468-9335-de3d6560e239','7a1d41ab-f2a7-4734-8f5d-029c6fa0d7e3',0,'b909d9ff-284e-4189-9c47-b39e0a30f9c4'),(44,'2026-01-21 14:17:06.853568','2026-01-21 14:17:09.815908','2026-01-21 14:17:09.813605',44,'192.168.122.100:6789:/volumes/_nogroup/af536fd1-8269-495b-9b12-b007bdeeab50/87b82afe-d56b-4746-a27d-d86b000ae695','af536fd1-8269-495b-9b12-b007bdeeab50',0,'37637ec3-7475-40c7-83d1-cfb64edd48cf'),(45,'2026-01-21 14:17:08.470504','2026-01-21 14:17:12.640992','2026-01-21 14:17:12.639622',45,'192.168.122.100:6789:/volumes/_nogroup/5409ffd4-eaac-442c-8587-e47fdf7d7341/d87b1044-560b-4671-b984-5a9e764bf8bb','5409ffd4-eaac-442c-8587-e47fdf7d7341',0,'26ec7b96-fd06-48b2-bdb5-2062252b508a'),(46,'2026-01-21 14:17:16.118922','2026-01-21 14:17:19.980438','2026-01-21 14:17:19.978651',46,'192.168.122.100:6789:/volumes/_nogroup/f149fb68-d34d-441e-9d9e-10acfdb751c3/be395b17-77ea-4d1f-a3d5-cf12644172e9','f149fb68-d34d-441e-9d9e-10acfdb751c3',0,'34cd9904-f361-4dfd-ac28-5c80de66639f'),(47,'2026-01-21 14:17:24.016951','2026-01-21 14:17:38.981548','2026-01-21 14:17:38.980552',47,'192.168.122.100:6789:/volumes/_nogroup/61ae05c8-89f3-407b-bbf2-1e843fc0b15c/f8485c14-2515-499e-a291-140bfb971fb6','61ae05c8-89f3-407b-bbf2-1e843fc0b15c',0,'a7920c2b-169d-4225-883c-41410fb96706'),(48,'2026-01-21 14:17:34.091797','2026-01-21 14:18:35.997235','2026-01-21 14:18:35.995990',48,'192.168.122.100:6789:/volumes/_nogroup/6fb09730-0544-4361-97f8-11e56000d2f0/b078df4b-38f9-4410-ab89-a5c09da3b1cb','6fb09730-0544-4361-97f8-11e56000d2f0',0,'8f27f2b1-afbb-4369-8c35-b6ac51182ec1'),(49,'2026-01-21 14:17:43.842276','2026-01-21 14:17:47.549527','2026-01-21 14:17:47.548199',49,'192.168.122.100:6789:/volumes/_nogroup/4934ef18-6cd5-442b-a8fa-227c3608b0bd/c71696ba-936e-4f18-89f5-ca8196c4bb94','4934ef18-6cd5-442b-a8fa-227c3608b0bd',0,'021445ff-e2fd-4715-bf1d-d088b0d57ae5'),(50,'2026-01-21 14:17:45.541440','2026-01-21 14:17:57.032441','2026-01-21 14:17:57.031285',50,'192.168.122.100:6789:/volumes/_nogroup/93827b21-dc3b-4f90-ab80-d532ba42cf82/d69cf44b-7a0d-437d-8b78-55611c70851f','93827b21-dc3b-4f90-ab80-d532ba42cf82',0,'88a215a2-9fe6-44fc-bef5-add987e3a32f'),(51,'2026-01-21 14:17:49.264965','2026-01-21 14:17:52.872812','2026-01-21 14:17:52.870334',51,'192.168.122.100:6789:/volumes/_nogroup/a2a02f3a-dc86-4c41-ae4c-20c17fe75226/37873579-fd8d-4e0a-980b-73d1a1678e9b','a2a02f3a-dc86-4c41-ae4c-20c17fe75226',0,'3ab5b2d5-fbd8-4513-a3ab-8cdc40daf349'),(52,'2026-01-21 14:17:51.656358','2026-01-21 14:17:57.128524','2026-01-21 14:17:57.126197',52,'192.168.122.100:6789:/volumes/_nogroup/2e583eb2-e6ab-4a68-a607-ecd6ca50e3b6/1245fb95-20a1-49fb-a04e-48144d861baf','2e583eb2-e6ab-4a68-a607-ecd6ca50e3b6',0,'1d3996f4-d1d2-460f-baf4-6cbf6a439b32'),(53,'2026-01-21 14:18:02.346272','2026-01-21 14:18:05.917340','2026-01-21 14:18:05.916414',53,'192.168.122.100:6789:/volumes/_nogroup/03db482a-4a9f-44b3-ba43-fe5ff12e229e/4ada938c-7ccc-47bb-8a7d-06e39fa21b91','03db482a-4a9f-44b3-ba43-fe5ff12e229e',0,'59e60930-22cf-42eb-a721-e8b730a6a8e1'),(54,'2026-01-21 14:18:17.474508','2026-01-21 14:18:20.940342','2026-01-21 14:18:20.939414',54,'192.168.122.100:6789:/volumes/_nogroup/619f82dd-2461-43fe-994a-71a6fb22cc9a/f9498102-fea3-4cc1-a405-bc1e6a9a7838','619f82dd-2461-43fe-994a-71a6fb22cc9a',0,'7e8cb0ab-e600-4119-8fa9-cfa51f5bc60f'),(55,'2026-01-21 14:18:17.761817','2026-01-21 14:18:21.157590','2026-01-21 14:18:21.156286',55,'192.168.122.100:6789:/volumes/_nogroup/d6e6fe01-b413-4bf6-b249-91dc19a3e3fc/a3719bda-5e93-4bc8-a6ba-43796639d277','d6e6fe01-b413-4bf6-b249-91dc19a3e3fc',0,'0d757431-6603-4617-95e7-234e8dd45d50'),(56,'2026-01-21 14:18:19.726329','2026-01-21 14:18:30.896473','2026-01-21 14:18:30.895393',56,'192.168.122.100:6789:/volumes/_nogroup/75787c7c-a801-4e74-8f54-f20d6b4880b0/1f606e4a-db26-4f08-a985-162ca262e6fc','75787c7c-a801-4e74-8f54-f20d6b4880b0',0,'661aad94-8fc5-4b12-8487-ea24809a5463'),(57,'2026-01-21 14:18:24.471985','2026-01-21 14:18:28.886670','2026-01-21 14:18:28.885475',57,'192.168.122.100:6789:/volumes/_nogroup/6b95bf55-eb7d-43c0-9f25-36884d529a89/d5ba67b3-4905-4db0-80f8-8f636f4190ab','6b95bf55-eb7d-43c0-9f25-36884d529a89',0,'81a8a785-5bf8-44b6-b54b-e493bde1369a'),(58,'2026-01-21 14:18:24.748441','2026-01-21 14:18:28.893904','2026-01-21 14:18:28.891953',58,'192.168.122.100:6789:/volumes/_nogroup/c1154fdb-2d56-4b79-b688-aa930d49c33b/c6b7d6f4-455b-41b1-b245-1cc7021ed1f6','c1154fdb-2d56-4b79-b688-aa930d49c33b',0,'c4a13516-d01a-43f9-a76a-d9a3d269c3a7'),(59,'2026-01-21 14:18:49.458184','2026-01-21 14:19:43.388573','2026-01-21 14:19:43.387290',59,'192.168.122.100:6789:/volumes/_nogroup/4fe02932-2d04-427d-b4f6-1c341396704b/0d39357a-8414-4374-b0d6-05a412ce9464','4fe02932-2d04-427d-b4f6-1c341396704b',0,'42e8c410-871c-445a-a870-54fb694475ef'),(60,'2026-01-21 14:19:07.832467','2026-01-21 14:19:07.831318',NULL,0,'192.168.122.100:6789:/volumes/_nogroup/c707dfa3-0985-4b01-bd2d-86b20bf31443/626d5d30-99af-40b0-a0ee-52f501bcaa57','c707dfa3-0985-4b01-bd2d-86b20bf31443',0,'4c3122ad-2f60-4e5f-9947-817395161d02'),(61,'2026-01-21 14:20:29.592298','2026-01-21 14:20:57.151616','2026-01-21 14:20:57.150415',61,'192.168.122.100:6789:/volumes/_nogroup/378a9e2b-830b-4331-9f8d-cddced43a09c/e838926d-ddbc-4be3-a09d-636b8eb3404d','378a9e2b-830b-4331-9f8d-cddced43a09c',0,'16e80995-d0ee-4095-b616-bb0ddbea32b0'),(62,'2026-01-21 14:20:34.196350','2026-01-21 14:20:53.717018','2026-01-21 14:20:53.716082',62,'192.168.122.100:6789:/volumes/_nogroup/05a1a08c-ad8e-48c0-9200-239aff8cbad0/a864419b-98a6-4b69-8083-22802883d427','05a1a08c-ad8e-48c0-9200-239aff8cbad0',0,'8ee8abc9-b423-4e59-b089-d06cf5a4b8fb'),(63,'2026-01-21 14:20:38.043991','2026-01-21 14:20:50.328908','2026-01-21 14:20:50.327367',63,'192.168.122.100:6789:/volumes/_nogroup/4f159ef8-5ae2-4a2e-8475-13a3dd691b3d/1fa83db7-b63e-4998-96ec-6ffd93b788e9','4f159ef8-5ae2-4a2e-8475-13a3dd691b3d',0,'6567a1a6-943f-4d08-9657-da63a09352b7'),(64,'2026-01-21 14:20:42.466425','2026-01-21 14:20:46.925739','2026-01-21 14:20:46.924518',64,'192.168.122.100:6789:/volumes/_nogroup/c2b5535e-c671-412e-8a2f-000a21e98354/a31a2175-050a-460b-86dc-4703b9dd32ff','c2b5535e-c671-412e-8a2f-000a21e98354',0,'e24fe373-5f42-493e-b6d1-7d5a56f7c4d7'),(65,'2026-01-21 14:21:13.088017','2026-01-21 14:22:59.523807','2026-01-21 14:22:59.522073',65,'192.168.122.100:6789:/volumes/_nogroup/cf9fedcb-41b1-4a3d-849f-ba456ffc232e/8cb7ae86-bfd3-4a18-836f-c9c7d266cc44','cf9fedcb-41b1-4a3d-849f-ba456ffc232e',0,'524a6fe0-45b4-46d9-8cc3-f4398ec12316'),(66,'2026-01-21 14:22:06.827666','2026-01-21 14:22:52.527922','2026-01-21 14:22:52.525633',66,'192.168.122.100:6789:/volumes/_nogroup/1837d3d1-766d-46d2-bd38-bb850ab9ec75/7101b50f-5fdb-4753-a2d7-62f31ffe88aa','1837d3d1-766d-46d2-bd38-bb850ab9ec75',0,'cc08465a-1b1a-41a5-86b1-b778bf2242e2'),(67,'2026-01-21 14:22:10.283837','2026-01-21 14:22:17.917946','2026-01-21 14:22:17.916545',67,'192.168.122.100:6789:/volumes/_nogroup/5be10ce2-edd5-48e2-9745-1baad2e01576/2bcde8f3-ae45-419c-921c-04b7d67afb7e','5be10ce2-edd5-48e2-9745-1baad2e01576',0,'aca312e6-30fd-4998-84f1-227929d1b223'),(68,'2026-01-21 14:22:28.009172','2026-01-21 14:22:34.630061','2026-01-21 14:22:34.628739',68,'192.168.122.100:6789:/volumes/_nogroup/5b257f1d-b61f-419d-bc85-c380d554748f/49e6749a-b814-4d79-b2c3-87dadc89263e','5b257f1d-b61f-419d-bc85-c380d554748f',0,'452f360a-5696-4b30-8fc4-c412216ccc0f'),(69,'2026-01-21 14:22:46.050481','2026-01-21 14:22:48.901453','2026-01-21 14:22:48.900172',69,'192.168.122.100:6789:/volumes/_nogroup/c251ad3b-9d06-4c01-a543-f9720f7a74a6/20533bf2-9642-4ef1-8d58-d49be22aa6ba','c251ad3b-9d06-4c01-a543-f9720f7a74a6',0,'19263567-df2e-4667-b623-84191aec5ac9'),(70,'2026-01-21 14:23:38.506255','2026-01-21 14:23:51.945949','2026-01-21 14:23:51.944675',70,'192.168.122.100:6789:/volumes/_nogroup/536a2c39-721a-4234-bb20-8865a7392cf1/9d3ee2ce-401b-4b9c-9303-f18eb5e8eade','536a2c39-721a-4234-bb20-8865a7392cf1',0,'cf0b9e6e-6f5e-4bd4-9c75-fdc01e4ef6c3'),(71,'2026-01-21 14:24:27.519187','2026-01-21 14:24:37.094024','2026-01-21 14:24:37.092834',71,'192.168.122.100:6789:/volumes/_nogroup/a5f701d9-3332-493b-805e-f694262123e2/f62c360a-91ba-4a12-8a48-a3a783029d44','a5f701d9-3332-493b-805e-f694262123e2',0,'3a3ef404-da7a-4ecf-8997-ce43659478f6'),(72,'2026-01-21 14:24:41.023849','2026-01-21 14:24:53.424540','2026-01-21 14:24:53.423290',72,'192.168.122.100:6789:/volumes/_nogroup/4564206e-a1af-4abb-a427-9d87957a49e0/5b0d28ac-7ccd-4441-b34b-f4cb942173d6','4564206e-a1af-4abb-a427-9d87957a49e0',0,'8593c041-b522-45ee-8ef7-65b90cfd3729'),(73,'2026-01-21 14:25:07.233172','2026-01-21 14:25:19.690807','2026-01-21 14:25:19.688943',73,'192.168.122.100:6789:/volumes/_nogroup/074ccac6-f42c-493c-9d0b-aab404cacaf6/f269e34a-77c5-41c7-8925-5dbbabe47fe9','074ccac6-f42c-493c-9d0b-aab404cacaf6',0,'e548fe5e-725b-4b24-819f-39b39a9dc26a');
/*!40000 ALTER TABLE `share_instance_export_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instance_export_locations_metadata`
--

DROP TABLE IF EXISTS `share_instance_export_locations_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instance_export_locations_metadata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `export_location_id` int(11) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `elm_el_id_uc` (`export_location_id`,`key`,`deleted`),
  CONSTRAINT `elm_id_fk` FOREIGN KEY (`export_location_id`) REFERENCES `share_instance_export_locations` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instance_export_locations_metadata`
--

LOCK TABLES `share_instance_export_locations_metadata` WRITE;
/*!40000 ALTER TABLE `share_instance_export_locations_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_instance_export_locations_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_instances`
--

DROP TABLE IF EXISTS `share_instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_instances` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `share_id` varchar(36) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `share_network_id` varchar(36) DEFAULT NULL,
  `share_server_id` varchar(36) DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  `access_rules_status` varchar(255) DEFAULT NULL,
  `replica_state` varchar(255) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  `cast_rules_to_readonly` tinyint(1) NOT NULL,
  `progress` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `si_share_network_fk` (`share_network_id`),
  KEY `si_share_server_fk` (`share_server_id`),
  KEY `si_az_id_fk` (`availability_zone_id`),
  KEY `si_st_id_fk` (`share_type_id`),
  KEY `share_instances_share_id_idx` (`share_id`),
  CONSTRAINT `si_az_id_fk` FOREIGN KEY (`availability_zone_id`) REFERENCES `availability_zones` (`id`),
  CONSTRAINT `si_share_fk` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`),
  CONSTRAINT `si_share_network_fk` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`),
  CONSTRAINT `si_share_server_fk` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`),
  CONSTRAINT `si_st_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_instances`
--

LOCK TABLES `share_instances` WRITE;
/*!40000 ALTER TABLE `share_instances` DISABLE KEYS */;
INSERT INTO `share_instances` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_id`, `host`, `status`, `scheduled_at`, `launched_at`, `terminated_at`, `share_network_id`, `share_server_id`, `availability_zone_id`, `access_rules_status`, `replica_state`, `share_type_id`, `cast_rules_to_readonly`, `progress`) VALUES ('2026-01-21 14:18:00.459460','2026-01-21 14:18:11.889406','2026-01-21 14:18:11.888634','03db482a-4a9f-44b3-ba43-fe5ff12e229e','03db482a-4a9f-44b3-ba43-fe5ff12e229e','fb08a62f-fd73-4321-8a32-ef0d0454f815','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:18:00','2026-01-21 14:18:02','2026-01-21 14:18:04',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'113e6005-36b8-4048-8bc1-1b192c85dbac',0,'100%'),('2026-01-21 14:14:38.616380','2026-01-21 14:14:42.442062','2026-01-21 14:14:42.441156','04645f5f-49e9-4d34-bec7-637462bf5b1a','04645f5f-49e9-4d34-bec7-637462bf5b1a','0f20f2be-86ec-43cb-8ba5-0e7061804ec3','','deleted','2026-01-21 14:14:38',NULL,NULL,NULL,NULL,NULL,'active',NULL,'073dda3b-4203-4183-90b1-b02118757953',0,NULL),('2026-01-21 14:20:33.636035','2026-01-21 14:20:53.730464','2026-01-21 14:20:53.729888','05a1a08c-ad8e-48c0-9200-239aff8cbad0','05a1a08c-ad8e-48c0-9200-239aff8cbad0','fdcf3635-f7ea-4eb3-943e-64e6fa02cf1a','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:20:33','2026-01-21 14:20:34','2026-01-21 14:20:53',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'703cfc70-9932-41ed-8a49-185d2994a4af',0,'100%'),('2026-01-21 14:25:06.761140','2026-01-21 14:25:19.716436','2026-01-21 14:25:19.715625','074ccac6-f42c-493c-9d0b-aab404cacaf6','074ccac6-f42c-493c-9d0b-aab404cacaf6','70d8a2e8-9754-4f37-bd26-0b4d171eeca4','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:25:06','2026-01-21 14:25:07','2026-01-21 14:25:19',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'7c9297d5-c3a5-4113-9133-2dae5de6223a',0,'100%'),('2026-01-21 14:10:42.825212','2026-01-21 14:10:45.912559','2026-01-21 14:10:45.911903','09f7a444-a5d6-4cd1-8195-bcb6a300bcd5','09f7a444-a5d6-4cd1-8195-bcb6a300bcd5','157f3a2d-e430-41d6-ba23-49c652f8d4de','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:10:42','2026-01-21 14:10:43','2026-01-21 14:10:44',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'9bfc08e1-2434-47e7-8b27-5587894f67ed',0,'100%'),('2026-01-21 14:10:31.972780','2026-01-21 14:10:39.162117','2026-01-21 14:10:39.161445','0a16a328-6a6b-4997-8d01-233d8aaecf94','0a16a328-6a6b-4997-8d01-233d8aaecf94','18d6912a-f9cf-49cb-972f-a01b1c28918e','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:10:32','2026-01-21 14:10:33','2026-01-21 14:10:38',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'9bfc08e1-2434-47e7-8b27-5587894f67ed',0,'100%'),('2026-01-21 14:14:13.849581','2026-01-21 14:14:39.715068','2026-01-21 14:14:39.714413','0a87ab89-25c8-43d7-9b97-672b44e8c221','0a87ab89-25c8-43d7-9b97-672b44e8c221','e556b944-c601-4d6a-9a44-72d806af4101','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:14:13','2026-01-21 14:14:15','2026-01-21 14:14:38',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'d714b627-a89b-463b-804f-ebe84408a229',0,'100%'),('2026-01-21 14:14:59.569181','2026-01-21 14:15:12.384176','2026-01-21 14:15:12.383381','0b71204a-52c0-4e93-8d46-339e009b5492','0b71204a-52c0-4e93-8d46-339e009b5492','ba13b15f-cf4d-49e6-8796-991bdc13606f','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:14:59','2026-01-21 14:15:00','2026-01-21 14:15:07',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b',0,'100%'),('2026-01-21 14:15:53.377823','2026-01-21 14:15:57.385779','2026-01-21 14:15:57.385207','12981b05-fe8f-4fd8-aee2-ae12c976e9f6','12981b05-fe8f-4fd8-aee2-ae12c976e9f6','9f297125-ba6b-4bf8-bdcd-ba79f70cf48e','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:15:53','2026-01-21 14:15:53','2026-01-21 14:15:57',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'d54caddb-c1a6-4c3f-b2f9-7d1717fa702a',0,'100%'),('2026-01-21 14:13:20.908794','2026-01-21 14:14:21.944060','2026-01-21 14:14:21.943249','1442b436-f5bb-47c2-acbf-ac7903d9399e','1442b436-f5bb-47c2-acbf-ac7903d9399e','fc76ee87-f013-4833-92c5-4c98f6ef4c19','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:13:21','2026-01-21 14:13:21','2026-01-21 14:14:20',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'d763adfd-4693-4b03-ad1c-6cfad5db99b3',0,'100%'),('2026-01-21 14:21:19.851872','2026-01-21 14:22:52.563985','2026-01-21 14:22:52.563303','1837d3d1-766d-46d2-bd38-bb850ab9ec75','1837d3d1-766d-46d2-bd38-bb850ab9ec75','e93e4111-7c93-41b8-8ba6-a67aecdc9a85','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:21:19','2026-01-21 14:21:20','2026-01-21 14:22:52',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'cf23d5d3-0f2f-42ba-aef6-7861fed7457c',0,'100%'),('2026-01-21 14:11:03.217162','2026-01-21 14:11:13.681777','2026-01-21 14:11:13.681210','18603bd9-4e2c-4abb-ab1b-01752b8839c2','18603bd9-4e2c-4abb-ab1b-01752b8839c2','a561393a-d080-4ae1-ab47-796e34de4fb1','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:11:03','2026-01-21 14:11:03','2026-01-21 14:11:11',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'08dc12ec-0496-4207-ab26-687dc1000122',0,'100%'),('2026-01-21 14:12:49.857930','2026-01-21 14:13:15.236356','2026-01-21 14:13:15.235683','1dd3a4c4-ba47-419f-88a7-3a23e3b00147','1dd3a4c4-ba47-419f-88a7-3a23e3b00147','9969199e-c110-4822-a15e-3778a83fe39c','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:12:49','2026-01-21 14:12:50','2026-01-21 14:13:15',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'9381faef-bf67-41dd-aaaa-a9be7a2bcc68',0,'100%'),('2026-01-21 14:15:01.258862','2026-01-21 14:15:16.804528','2026-01-21 14:15:16.803857','1f4e19bc-5b51-4bf9-bb0d-7236c3e6e1b3','1f4e19bc-5b51-4bf9-bb0d-7236c3e6e1b3','1dadb7a1-c595-48c0-8c20-61b9f6b86eb2','','deleted','2026-01-21 14:15:01',NULL,NULL,NULL,NULL,NULL,'active',NULL,'c920fd72-4f4d-4931-b24d-6a9c60f2e233',0,NULL),('2026-01-21 14:17:51.013192','2026-01-21 14:17:57.276714','2026-01-21 14:17:57.276170','2e583eb2-e6ab-4a68-a607-ecd6ca50e3b6','2e583eb2-e6ab-4a68-a607-ecd6ca50e3b6','01a85aaf-b459-4ec1-81a3-8d27efbc9c48','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:17:51','2026-01-21 14:17:52','2026-01-21 14:17:56',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'113e6005-36b8-4048-8bc1-1b192c85dbac',0,'100%'),('2026-01-21 14:20:29.355289','2026-01-21 14:20:57.169781','2026-01-21 14:20:57.169165','378a9e2b-830b-4331-9f8d-cddced43a09c','378a9e2b-830b-4331-9f8d-cddced43a09c','407b384e-148b-43f2-a5fb-b1e5aa164bd3','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:20:29','2026-01-21 14:20:29','2026-01-21 14:20:56',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'703cfc70-9932-41ed-8a49-185d2994a4af',0,'100%'),('2026-01-21 14:14:10.357313','2026-01-21 14:14:22.354318','2026-01-21 14:14:22.353574','398fce8f-70d1-42b2-8ff9-f180fc0fd07c','398fce8f-70d1-42b2-8ff9-f180fc0fd07c','d05f4623-92be-4e54-b528-ddbb8752adb2','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:14:10','2026-01-21 14:14:11','2026-01-21 14:14:21',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'7ac1d9c2-538b-4775-a2d5-4c70805fd54c',0,'100%'),('2026-01-21 14:15:37.014695','2026-01-21 14:19:22.918013','2026-01-21 14:19:22.917444','424167b3-6c3d-4062-8da1-4d053af4cf7b','424167b3-6c3d-4062-8da1-4d053af4cf7b','fc256f6b-1503-4a6e-8c37-1daea3157b6f','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:15:37','2026-01-21 14:15:37','2026-01-21 14:19:22',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'6ee0f8f5-aa3a-4c92-817a-3d69c33b511e',0,'100%'),('2026-01-21 14:24:40.275872','2026-01-21 14:24:53.442810','2026-01-21 14:24:53.442158','4564206e-a1af-4abb-a427-9d87957a49e0','4564206e-a1af-4abb-a427-9d87957a49e0','ba38a422-131c-4c1e-8d0d-119a6f068d6a','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:24:40','2026-01-21 14:24:41','2026-01-21 14:24:52',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'f7db249e-6360-4f95-914d-c75a6989e840',0,'100%'),('2026-01-21 14:17:43.509561','2026-01-21 14:17:47.634539','2026-01-21 14:17:47.633850','4934ef18-6cd5-442b-a8fa-227c3608b0bd','4934ef18-6cd5-442b-a8fa-227c3608b0bd','91279f1f-f7d7-4658-ba1b-77828dd85ad2','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:17:43','2026-01-21 14:17:43','2026-01-21 14:17:47',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'113e6005-36b8-4048-8bc1-1b192c85dbac',0,'100%'),('2026-01-21 14:15:49.635473','2026-01-21 14:16:00.885598','2026-01-21 14:16:00.884964','49d5247d-28e2-437f-92c4-34b98896805f','49d5247d-28e2-437f-92c4-34b98896805f','45242132-b4fc-4649-a43e-b4fe5539da32','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:15:49','2026-01-21 14:15:50','2026-01-21 14:16:00',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'d54caddb-c1a6-4c3f-b2f9-7d1717fa702a',0,'100%'),('2026-01-21 14:20:37.595876','2026-01-21 14:20:50.345673','2026-01-21 14:20:50.345034','4f159ef8-5ae2-4a2e-8475-13a3dd691b3d','4f159ef8-5ae2-4a2e-8475-13a3dd691b3d','a97b8cff-7809-490b-a244-8dd0e34e7ef5','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:20:37','2026-01-21 14:20:38','2026-01-21 14:20:50',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'703cfc70-9932-41ed-8a49-185d2994a4af',0,'100%'),('2026-01-21 14:18:49.118539','2026-01-21 14:19:43.409732','2026-01-21 14:19:43.409139','4fe02932-2d04-427d-b4f6-1c341396704b','4fe02932-2d04-427d-b4f6-1c341396704b','fa3c3ca4-ee78-4359-90c1-d7c6060a822d','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:18:49','2026-01-21 14:18:49','2026-01-21 14:19:43',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'fce16d73-418d-491b-b08b-4701c62ff5bc',0,'100%'),('2026-01-21 14:16:38.967004','2026-01-21 14:16:43.327666','2026-01-21 14:16:43.327085','5006c4a9-49c2-40a4-8229-4463bddd3634','5006c4a9-49c2-40a4-8229-4463bddd3634','a46b1a94-810e-46d9-8210-a58533c70b5a','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:16:39','2026-01-21 14:16:40','2026-01-21 14:16:43',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'ddce9437-41f6-41e1-9345-e8f73447a2bc',0,'100%'),('2026-01-21 14:23:26.939662','2026-01-21 14:23:52.069430','2026-01-21 14:23:52.068574','536a2c39-721a-4234-bb20-8865a7392cf1','536a2c39-721a-4234-bb20-8865a7392cf1','b0c80a60-09de-4bf8-8210-d9e7065bb4bd','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:23:27','2026-01-21 14:23:38','2026-01-21 14:23:51',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'a1bc5a3b-4487-4ec2-9108-ad6c89a426e4',0,'100%'),('2026-01-21 14:17:08.209427','2026-01-21 14:17:12.657233','2026-01-21 14:17:12.656638','5409ffd4-eaac-442c-8587-e47fdf7d7341','5409ffd4-eaac-442c-8587-e47fdf7d7341','7f1408e7-914e-4693-903c-3d7ca7ce6766','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:17:08','2026-01-21 14:17:08','2026-01-21 14:17:12',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'a35627cc-f912-49fe-a347-ce5ebde9e5e7',0,'100%'),('2026-01-21 14:15:29.481998','2026-01-21 14:15:37.897987','2026-01-21 14:15:37.897234','5991b6dd-3598-462c-9b52-78412a23786c','5991b6dd-3598-462c-9b52-78412a23786c','073f2038-c750-4560-82ed-b9e3b4ba99e5','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:15:29','2026-01-21 14:15:29','2026-01-21 14:15:36',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b',0,'100%'),('2026-01-21 14:22:26.819265','2026-01-21 14:22:34.645825','2026-01-21 14:22:34.644980','5b257f1d-b61f-419d-bc85-c380d554748f','5b257f1d-b61f-419d-bc85-c380d554748f','4b663ce3-0e4f-46e1-9a65-29146bd45b68','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:22:27','2026-01-21 14:22:28','2026-01-21 14:22:34',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'cf23d5d3-0f2f-42ba-aef6-7861fed7457c',0,'100%'),('2026-01-21 14:22:09.959732','2026-01-21 14:22:17.956276','2026-01-21 14:22:17.955684','5be10ce2-edd5-48e2-9745-1baad2e01576','5be10ce2-edd5-48e2-9745-1baad2e01576','368eadbe-e949-4a9e-9e1a-932072519f7f','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:22:10','2026-01-21 14:22:10','2026-01-21 14:22:17',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'cf23d5d3-0f2f-42ba-aef6-7861fed7457c',0,'100%'),('2026-01-21 14:15:05.322886','2026-01-21 14:15:13.328046','2026-01-21 14:15:13.327075','6187a83c-4683-40d3-9dfc-9d6ddd6d6ddb','6187a83c-4683-40d3-9dfc-9d6ddd6d6ddb','f43ad296-d798-4b0d-a20a-11bd1a371881','','deleted','2026-01-21 14:15:05',NULL,NULL,NULL,NULL,NULL,'active',NULL,'60b901c2-472b-4f17-bdda-ff703ace9faf',0,NULL),('2026-01-21 14:18:16.770400','2026-01-21 14:18:20.958914','2026-01-21 14:18:20.958370','619f82dd-2461-43fe-994a-71a6fb22cc9a','619f82dd-2461-43fe-994a-71a6fb22cc9a','5940feee-026c-404d-ad37-10cf7a1f2128','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:18:17','2026-01-21 14:18:17','2026-01-21 14:18:20',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'113e6005-36b8-4048-8bc1-1b192c85dbac',0,'100%'),('2026-01-21 14:17:22.294135','2026-01-21 14:17:39.009509','2026-01-21 14:17:39.008625','61ae05c8-89f3-407b-bbf2-1e843fc0b15c','61ae05c8-89f3-407b-bbf2-1e843fc0b15c','87161409-8bb7-4318-a754-72802d038d2f','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:17:22','2026-01-21 14:17:24','2026-01-21 14:17:38',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'e930702d-a3b3-40a2-9f70-64fa8134ddf6',0,'100%'),('2026-01-21 14:16:04.273448','2026-01-21 14:16:08.662655','2026-01-21 14:16:08.661842','62ba25ce-388a-4a45-8f6e-7a5833c81f31','62ba25ce-388a-4a45-8f6e-7a5833c81f31','269f943c-b9aa-4c05-80a0-0a278a29a848','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:16:04','2026-01-21 14:16:04','2026-01-21 14:16:08',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'d54caddb-c1a6-4c3f-b2f9-7d1717fa702a',0,'100%'),('2026-01-21 14:13:45.323246','2026-01-21 14:13:52.007775','2026-01-21 14:13:52.007146','6321f0ab-1903-4b13-841b-f76cfd9c3cac','6321f0ab-1903-4b13-841b-f76cfd9c3cac','3c665c41-2d99-4918-8898-968ff5d4b5b8','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:13:45','2026-01-21 14:13:45','2026-01-21 14:13:51',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'21dd7853-6f9b-4e9a-91b3-a47c3de6b980',0,'100%'),('2026-01-21 14:12:31.034500','2026-01-21 14:12:36.512213','2026-01-21 14:12:36.510521','672756b3-d8dc-429b-8b05-6a6f7934e823','672756b3-d8dc-429b-8b05-6a6f7934e823','b526118c-476f-4240-99b7-711476531384','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:12:31','2026-01-21 14:12:31','2026-01-21 14:12:35',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'291913af-f721-4784-852d-18a81c2dbf2d',0,'100%'),('2026-01-21 14:13:56.750674','2026-01-21 14:14:00.907237','2026-01-21 14:14:00.906054','67e413f3-ad10-4caa-86cb-30d84d43311e','67e413f3-ad10-4caa-86cb-30d84d43311e','78c2bfb4-61d4-432b-9ea3-5bfb830f3b03','','deleted','2026-01-21 14:13:56',NULL,NULL,NULL,NULL,NULL,'active',NULL,'5afaec67-94c3-4b24-8db9-1b003291becd',0,NULL),('2026-01-21 14:13:45.786631','2026-01-21 14:13:50.008694','2026-01-21 14:13:50.007868','6a2c4ab2-3b49-4ebc-ba58-57f2ae6d099f','6a2c4ab2-3b49-4ebc-ba58-57f2ae6d099f','30854878-3900-4399-8036-f35b4759f865','','deleted','2026-01-21 14:13:45',NULL,NULL,NULL,NULL,NULL,'active',NULL,'cdda8570-26be-4330-bd36-622a2eb10327',0,NULL),('2026-01-21 14:18:24.125533','2026-01-21 14:18:28.908879','2026-01-21 14:18:28.908301','6b95bf55-eb7d-43c0-9f25-36884d529a89','6b95bf55-eb7d-43c0-9f25-36884d529a89','14534c4c-1b02-4468-8f33-545d362f0c63','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:18:24','2026-01-21 14:18:24','2026-01-21 14:18:28',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'113e6005-36b8-4048-8bc1-1b192c85dbac',0,'100%'),('2026-01-21 14:17:33.328009','2026-01-21 14:18:36.015289','2026-01-21 14:18:36.014651','6fb09730-0544-4361-97f8-11e56000d2f0','6fb09730-0544-4361-97f8-11e56000d2f0','684e0b48-a2b0-4730-acfb-d81d371a3a68','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:17:33','2026-01-21 14:17:34','2026-01-21 14:18:35',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'113e6005-36b8-4048-8bc1-1b192c85dbac',0,'100%'),('2026-01-21 14:13:26.602919','2026-01-21 14:14:13.715070','2026-01-21 14:14:13.714421','6fd14f2b-0487-4f6b-a678-d4c00c894fd8','6fd14f2b-0487-4f6b-a678-d4c00c894fd8','bf3f919b-8c4d-4a4b-ba98-44d0f3aac87a','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:13:26','2026-01-21 14:13:29','2026-01-21 14:14:12',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'d763adfd-4693-4b03-ad1c-6cfad5db99b3',0,'100%'),('2026-01-21 14:11:07.662231','2026-01-21 14:11:17.071559','2026-01-21 14:11:17.070946','73408dc6-4c0b-4079-a270-af31e9a2608f','73408dc6-4c0b-4079-a270-af31e9a2608f','c80c0fc3-4bc7-4598-a0d4-d69daf2fd776','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:11:07','2026-01-21 14:11:08','2026-01-21 14:11:16',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'3055f25f-99ca-47e1-85fd-3d023797e4ab',0,'100%'),('2026-01-21 14:14:59.656256','2026-01-21 14:15:05.788776','2026-01-21 14:15:05.787902','74d6c6f5-e0f2-4207-b59c-99c525e6f1c7','74d6c6f5-e0f2-4207-b59c-99c525e6f1c7','e0d7e609-a29b-4fb3-ba97-e5984dc35087','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:14:59','2026-01-21 14:15:00','2026-01-21 14:15:05',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'fa3be0f8-2dde-43f0-80c0-e2a4ba884d5b',0,'100%'),('2026-01-21 14:18:19.321508','2026-01-21 14:18:30.910744','2026-01-21 14:18:30.910236','75787c7c-a801-4e74-8f54-f20d6b4880b0','75787c7c-a801-4e74-8f54-f20d6b4880b0','cae1b4e3-e1c6-4069-8095-973e2efe7b2e','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:18:19','2026-01-21 14:18:19','2026-01-21 14:18:30',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'f78ae5cb-fced-4e97-b8cd-e69b71d0827c',0,'100%'),('2026-01-21 14:16:51.937961','2026-01-21 14:17:42.640494','2026-01-21 14:17:42.639899','7a1d41ab-f2a7-4734-8f5d-029c6fa0d7e3','7a1d41ab-f2a7-4734-8f5d-029c6fa0d7e3','b1af7887-8549-4ad6-8f39-3d20abb6170a','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:16:52','2026-01-21 14:16:52','2026-01-21 14:17:42',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'b162a983-fd22-416d-b3c5-874636612a2e',0,'100%'),('2026-01-21 14:15:17.499534','2026-01-21 14:15:26.884600','2026-01-21 14:15:26.883458','7e20a48a-701d-4436-9856-75906117d35b','7e20a48a-701d-4436-9856-75906117d35b','2c754312-2184-4de2-a6bb-7fbb0fd69571','','deleted','2026-01-21 14:15:17',NULL,NULL,NULL,NULL,NULL,'active',NULL,'96a3f3a7-7b33-4316-8b52-e062643518d7',0,NULL),('2026-01-21 14:15:27.311364','2026-01-21 14:15:31.188318','2026-01-21 14:15:31.187461','80f065f2-eae8-4721-a78f-6cf075a7121d','80f065f2-eae8-4721-a78f-6cf075a7121d','18e262aa-85d0-4141-b91e-66da6fddace6','','deleted','2026-01-21 14:15:27',NULL,NULL,NULL,NULL,NULL,'active',NULL,'6c2e02fc-c934-482d-bdc9-0685eab3a289',0,NULL),('2026-01-21 14:14:04.247198','2026-01-21 14:14:08.921194','2026-01-21 14:14:08.920403','8bc5fdaa-02e4-4394-ab57-82acdd89427e','8bc5fdaa-02e4-4394-ab57-82acdd89427e','f67386cf-d1ad-458d-a3f9-c5a2653692fc','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:14:04','2026-01-21 14:14:07','2026-01-21 14:14:08',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'21dd7853-6f9b-4e9a-91b3-a47c3de6b980',0,'100%'),('2026-01-21 14:11:26.217051','2026-01-21 14:12:04.508027','2026-01-21 14:12:04.507365','901b9a46-d563-4a2c-bc82-2f893614e2f0','901b9a46-d563-4a2c-bc82-2f893614e2f0','056ffbf5-e5ac-4f37-86c8-8cb3627cce73','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:11:27','2026-01-21 14:11:28','2026-01-21 14:12:03',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'29cdbce9-1270-470b-8e9e-290edf433bce',0,'100%'),('2026-01-21 14:12:40.380406','2026-01-21 14:12:59.827717','2026-01-21 14:12:59.826937','909aa505-0296-4e74-80ca-1c8370556d29','909aa505-0296-4e74-80ca-1c8370556d29','f3049aa0-1e31-4c57-bea3-c4cb3a5c1ba7','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:12:40','2026-01-21 14:12:45','2026-01-21 14:12:58',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'59554df7-024a-45b7-9735-27031cc895f1',0,'100%'),('2026-01-21 14:14:43.020150','2026-01-21 14:14:47.000081','2026-01-21 14:14:46.999043','91e1103b-bce3-4723-8d02-3cb7b626a03b','91e1103b-bce3-4723-8d02-3cb7b626a03b','d9a40d08-858b-4fe0-8d78-6d99497a249f','','deleted','2026-01-21 14:14:43',NULL,NULL,NULL,NULL,NULL,'active',NULL,'2e51bd45-5453-4e78-b8d6-9b395d5d763d',0,NULL),('2026-01-21 14:17:45.083167','2026-01-21 14:17:57.105634','2026-01-21 14:17:57.104883','93827b21-dc3b-4f90-ab80-d532ba42cf82','93827b21-dc3b-4f90-ab80-d532ba42cf82','099f5b0a-98b5-4972-ad30-abd6e3819995','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:17:45','2026-01-21 14:17:45','2026-01-21 14:17:56',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'a36cdb63-0be1-431b-b3a6-13bc024a485c',0,'100%'),('2026-01-21 14:16:27.275129','2026-01-21 14:16:36.358843','2026-01-21 14:16:36.358237','96494b3b-24ff-4794-b86c-c27bb64a476f','96494b3b-24ff-4794-b86c-c27bb64a476f','e26f4411-d608-4767-8300-5651275fd6c4','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:16:27','2026-01-21 14:16:27','2026-01-21 14:16:35',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'06f3f214-12da-4ea9-a206-446558478b75',0,'100%'),('2026-01-21 14:13:41.591745','2026-01-21 14:14:37.366394','2026-01-21 14:14:37.365840','98584c80-dc48-400e-a1ef-b94d26420f34','98584c80-dc48-400e-a1ef-b94d26420f34','d2064608-c39f-4121-8bf3-57367d234998','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:13:41','2026-01-21 14:13:41','2026-01-21 14:14:36',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'21dd7853-6f9b-4e9a-91b3-a47c3de6b980',0,'100%'),('2026-01-21 14:14:56.014929','2026-01-21 14:14:59.946854','2026-01-21 14:14:59.946276','9d25231b-4d96-4d97-a97b-04ec5aee2ade','9d25231b-4d96-4d97-a97b-04ec5aee2ade','37fea2af-cb5f-4ce6-ad57-8e3fdf18c513','','deleted','2026-01-21 14:14:56',NULL,NULL,NULL,NULL,NULL,'active',NULL,'f90ca7dd-2c72-49d1-9bfd-c7cfc1f6b718',0,NULL),('2026-01-21 14:16:42.340937','2026-01-21 14:17:46.621501','2026-01-21 14:17:46.620898','9d63fab0-cc30-4952-b485-806c5f0f78c2','9d63fab0-cc30-4952-b485-806c5f0f78c2','688d05e3-d534-4588-8ef1-588302e0580a','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:16:42','2026-01-21 14:16:42','2026-01-21 14:17:45',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'b162a983-fd22-416d-b3c5-874636612a2e',0,'100%'),('2026-01-21 14:15:01.323067','2026-01-21 14:15:09.967469','2026-01-21 14:15:09.966656','a27e07da-ba92-4d67-aa02-2edb8a28bc44','a27e07da-ba92-4d67-aa02-2edb8a28bc44','72fbe20a-9dea-4a19-8d2c-fbf5fca1a08e','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:15:01','2026-01-21 14:15:02','2026-01-21 14:15:06',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'5f9f4ef7-dc66-42d3-8b39-c62ccc780aba',0,'100%'),('2026-01-21 14:17:48.863840','2026-01-21 14:17:52.898593','2026-01-21 14:17:52.897796','a2a02f3a-dc86-4c41-ae4c-20c17fe75226','a2a02f3a-dc86-4c41-ae4c-20c17fe75226','cacacb68-f5cc-4781-bc3e-01f1c20a372b','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:17:48','2026-01-21 14:17:49','2026-01-21 14:17:52',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'a36cdb63-0be1-431b-b3a6-13bc024a485c',0,'100%'),('2026-01-21 14:16:19.462863','2026-01-21 14:16:34.580043','2026-01-21 14:16:34.579020','a444a045-3a18-4422-831d-838f3d178e33','a444a045-3a18-4422-831d-838f3d178e33','5386cb7d-3729-4e52-b4c5-42215607272e','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:16:19','2026-01-21 14:16:19','2026-01-21 14:16:30',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'24dda13d-d1e8-43b2-948e-8336430d5aff',0,'100%'),('2026-01-21 14:24:25.191205','2026-01-21 14:24:37.179406','2026-01-21 14:24:37.178678','a5f701d9-3332-493b-805e-f694262123e2','a5f701d9-3332-493b-805e-f694262123e2','6eb48da7-67ab-49fc-b63a-2af56663b79e','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:24:25','2026-01-21 14:24:27','2026-01-21 14:24:36',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'f7db249e-6360-4f95-914d-c75a6989e840',0,'100%'),('2026-01-21 14:16:55.874304','2026-01-21 14:17:09.833402','2026-01-21 14:17:09.832682','af536fd1-8269-495b-9b12-b007bdeeab50','af536fd1-8269-495b-9b12-b007bdeeab50','a2f00a33-a7b2-4e3d-a950-1bec6b8c16c5','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:16:55','2026-01-21 14:16:58','2026-01-21 14:17:09',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'3ded9bac-2fe5-4f42-8fae-b77fb1f40041',0,'100%'),('2026-01-21 14:14:48.373982','2026-01-21 14:15:00.469422','2026-01-21 14:15:00.468612','b068099c-41a2-47ad-aa5d-2bef47dbd312','b068099c-41a2-47ad-aa5d-2bef47dbd312','e74a9198-b8ec-4c66-8843-e247a2163eda','','deleted','2026-01-21 14:14:48',NULL,NULL,NULL,NULL,NULL,'active',NULL,'570df0ca-219d-4456-90e9-bfe5252d183e',0,NULL),('2026-01-21 14:13:35.184303','2026-01-21 14:13:38.897244','2026-01-21 14:13:38.895839','b6b72de7-f609-4bc6-9c80-a81cdd9590dc','b6b72de7-f609-4bc6-9c80-a81cdd9590dc','3f2fb9c0-2e57-4d1b-8cf8-6074c5454331','','deleted','2026-01-21 14:13:35',NULL,NULL,NULL,NULL,NULL,'active',NULL,'0b0ef60b-789a-4f97-ab23-aa852b1b2e11',0,NULL),('2026-01-21 14:13:38.762342','2026-01-21 14:13:58.649021','2026-01-21 14:13:58.648411','bba0c3cf-adf3-468e-ae9d-3e37f7ff8fa0','bba0c3cf-adf3-468e-ae9d-3e37f7ff8fa0','f7f2a070-b60a-4b51-878d-5e40e7a13a72','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:13:38','2026-01-21 14:13:39','2026-01-21 14:13:58',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'7cec5100-da97-4c19-a6d2-711aa40fb4a4',0,'100%'),('2026-01-21 14:11:21.345627','2026-01-21 14:12:08.658928','2026-01-21 14:12:08.658293','be026c8c-9a77-4436-9eb0-bd80e75652ed','be026c8c-9a77-4436-9eb0-bd80e75652ed','eb470898-ab04-4f3a-a04b-e77ceb023449','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:11:21','2026-01-21 14:11:21','2026-01-21 14:12:08',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'c5bac032-cc46-4150-aad5-9325071c0935',0,'100%'),('2026-01-21 14:15:22.458072','2026-01-21 14:15:26.299568','2026-01-21 14:15:26.298963','bf82b95f-596f-4d02-9ba2-28ada17dba18','bf82b95f-596f-4d02-9ba2-28ada17dba18','fab0fdf5-9fef-4cce-a2ee-7832c9376c39','','deleted','2026-01-21 14:15:22',NULL,NULL,NULL,NULL,NULL,'active',NULL,'86c39d6d-2e5a-4607-a4f6-36e6a44459c6',0,NULL),('2026-01-21 14:18:24.528281','2026-01-21 14:18:28.927011','2026-01-21 14:18:28.926426','c1154fdb-2d56-4b79-b688-aa930d49c33b','c1154fdb-2d56-4b79-b688-aa930d49c33b','3d3e1f20-6c20-4283-aa54-1405dbde1c68','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:18:24','2026-01-21 14:18:24','2026-01-21 14:18:28',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'a36cdb63-0be1-431b-b3a6-13bc024a485c',0,'100%'),('2026-01-21 14:22:43.135253','2026-01-21 14:22:48.923069','2026-01-21 14:22:48.922360','c251ad3b-9d06-4c01-a543-f9720f7a74a6','c251ad3b-9d06-4c01-a543-f9720f7a74a6','f9cd06dc-fd20-4cfe-8013-3dd5c1e3307e','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:22:43','2026-01-21 14:22:46','2026-01-21 14:22:48',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'cf23d5d3-0f2f-42ba-aef6-7861fed7457c',0,'100%'),('2026-01-21 14:20:41.990313','2026-01-21 14:20:46.943653','2026-01-21 14:20:46.942804','c2b5535e-c671-412e-8a2f-000a21e98354','c2b5535e-c671-412e-8a2f-000a21e98354','70d9343f-5f35-46c7-ad39-1d03bcfc6faa','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:20:42','2026-01-21 14:20:42','2026-01-21 14:20:46',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'703cfc70-9932-41ed-8a49-185d2994a4af',0,'100%'),('2026-01-21 14:19:07.475559','2026-01-21 14:19:14.978019',NULL,'False','c707dfa3-0985-4b01-bd2d-86b20bf31443','7222a48c-e385-4ac8-9476-23ef2ccbfa6c','hostgroup@cephfs#cephfs','available','2026-01-21 14:19:07','2026-01-21 14:19:07',NULL,NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'6ee0f8f5-aa3a-4c92-817a-3d69c33b511e',0,'100%'),('2026-01-21 14:15:16.960721','2026-01-21 14:15:26.804842','2026-01-21 14:15:26.804147','c804cc91-0101-4131-a680-b760e9df84f1','c804cc91-0101-4131-a680-b760e9df84f1','498f15a0-21ee-49ad-8bf0-150074745f0c','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:15:17','2026-01-21 14:15:18','2026-01-21 14:15:25',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b',0,'100%'),('2026-01-21 14:15:09.118812','2026-01-21 14:15:12.942828','2026-01-21 14:15:12.941781','c854353e-d43c-4ca6-aae3-611c93fcc3f3','c854353e-d43c-4ca6-aae3-611c93fcc3f3','ac96fc6c-01cf-4118-aff0-f8a200342bf0','','deleted','2026-01-21 14:15:09',NULL,NULL,NULL,NULL,NULL,'active',NULL,'7efdd4ee-25a0-4ed9-bca7-168f82a1df34',0,NULL),('2026-01-21 14:10:25.318308','2026-01-21 14:10:28.706413','2026-01-21 14:10:28.705216','ca297459-dcdc-48cc-b973-0a2fd8a93409','ca297459-dcdc-48cc-b973-0a2fd8a93409','751d6039-55f6-48ec-8c28-0b0ebaeb9d5b','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:10:25','2026-01-21 14:10:25','2026-01-21 14:10:27',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'9bfc08e1-2434-47e7-8b27-5587894f67ed',0,'100%'),('2026-01-21 14:14:51.473702','2026-01-21 14:16:12.173396','2026-01-21 14:16:12.172824','cb5ab99b-0e59-4153-829e-95580fc1cdff','cb5ab99b-0e59-4153-829e-95580fc1cdff','1aabce1b-dbbb-4dae-a6a5-613066113ab2','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:14:51','2026-01-21 14:14:54','2026-01-21 14:16:11',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b',0,'100%'),('2026-01-21 14:21:12.471903','2026-01-21 14:22:59.593503','2026-01-21 14:22:59.592626','cf9fedcb-41b1-4a3d-849f-ba456ffc232e','cf9fedcb-41b1-4a3d-849f-ba456ffc232e','70bc77af-7e50-4669-ba31-537c6a183e1f','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:21:12','2026-01-21 14:21:13','2026-01-21 14:22:59',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'cf23d5d3-0f2f-42ba-aef6-7861fed7457c',0,'100%'),('2026-01-21 14:10:21.038996','2026-01-21 14:12:12.219954','2026-01-21 14:12:12.218997','d3ce0e74-c7d0-4049-ba17-7d4296160447','d3ce0e74-c7d0-4049-ba17-7d4296160447','036723cc-3463-4bf3-a330-5b38b8f58ab6','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:10:21','2026-01-21 14:10:22','2026-01-21 14:12:11',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'9bfc08e1-2434-47e7-8b27-5587894f67ed',0,'100%'),('2026-01-21 14:16:37.676554','2026-01-21 14:17:50.649064','2026-01-21 14:17:50.648459','d4d9a3e7-c006-4c96-ab86-0ee694f36366','d4d9a3e7-c006-4c96-ab86-0ee694f36366','ca6daf26-9831-4772-bcf0-7b69e0070af8','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:16:38','2026-01-21 14:16:39','2026-01-21 14:17:49',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'e930702d-a3b3-40a2-9f70-64fa8134ddf6',0,'100%'),('2026-01-21 14:18:17.352332','2026-01-21 14:18:21.175335','2026-01-21 14:18:21.174617','d6e6fe01-b413-4bf6-b249-91dc19a3e3fc','d6e6fe01-b413-4bf6-b249-91dc19a3e3fc','8a0ee85c-28b4-48fa-a44e-9cb6516391d3','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:18:17','2026-01-21 14:18:18','2026-01-21 14:18:21',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'a36cdb63-0be1-431b-b3a6-13bc024a485c',0,'100%'),('2026-01-21 14:10:55.111057','2026-01-21 14:11:00.100226','2026-01-21 14:11:00.099441','d765fd4c-f99f-46af-bd07-596dac7c37d5','d765fd4c-f99f-46af-bd07-596dac7c37d5','c8d2e256-38ca-48f6-94ba-6ee388f70097','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:10:55','2026-01-21 14:10:56','2026-01-21 14:10:59',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'9bfc08e1-2434-47e7-8b27-5587894f67ed',0,'100%'),('2026-01-21 14:16:46.968997','2026-01-21 14:17:16.686922','2026-01-21 14:17:16.686383','d96d5fd8-0350-40e0-a742-9103d3d18e31','d96d5fd8-0350-40e0-a742-9103d3d18e31','7c0e94b3-fc54-45fc-a321-25827669641d','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:16:47','2026-01-21 14:16:48','2026-01-21 14:17:16',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'3ded9bac-2fe5-4f42-8fae-b77fb1f40041',0,'100%'),('2026-01-21 14:14:26.236533','2026-01-21 14:14:30.076986','2026-01-21 14:14:30.076372','dd111cee-cd8c-410d-afba-122eba9f97ef','dd111cee-cd8c-410d-afba-122eba9f97ef','5d497481-daaf-4806-bc02-7a9b977bfe8c','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:14:26','2026-01-21 14:14:26','2026-01-21 14:14:29',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'21dd7853-6f9b-4e9a-91b3-a47c3de6b980',0,'100%'),('2026-01-21 14:13:55.210120','2026-01-21 14:14:00.808506','2026-01-21 14:14:00.807801','e92e9c0d-aab4-453c-97fd-2dccbd1b01ca','e92e9c0d-aab4-453c-97fd-2dccbd1b01ca','7fbe17a9-8106-4974-a0c0-060797971eae','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:13:55','2026-01-21 14:13:56','2026-01-21 14:14:00',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'21dd7853-6f9b-4e9a-91b3-a47c3de6b980',0,'100%'),('2026-01-21 14:13:51.043406','2026-01-21 14:13:54.659758','2026-01-21 14:13:54.658495','e99020d8-2d0b-4424-bee7-25ad034e7783','e99020d8-2d0b-4424-bee7-25ad034e7783','84744f0f-3821-4ef8-81d7-2f297251eeda','','deleted','2026-01-21 14:13:51',NULL,NULL,NULL,NULL,NULL,'active',NULL,'78590156-25d2-468c-8633-1b5bd4532903',0,NULL),('2026-01-21 14:12:17.015321','2026-01-21 14:12:21.049159','2026-01-21 14:12:21.048610','ea104d42-8223-4da1-870a-ba39917e4943','ea104d42-8223-4da1-870a-ba39917e4943','6eefd607-c1fc-4d82-a269-17cb0784b4c7','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:12:17','2026-01-21 14:12:17','2026-01-21 14:12:19',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'5a374d5e-d0ed-4003-9ec7-10084960d609',0,'100%'),('2026-01-21 14:10:23.629863','2026-01-21 14:10:31.573482','2026-01-21 14:10:31.572738','ec4e87bc-026b-4a6f-938e-c32b3b1010de','ec4e87bc-026b-4a6f-938e-c32b3b1010de','f101d908-567e-4304-b028-50ff6e482c84','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:10:23','2026-01-21 14:10:24','2026-01-21 14:10:31',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'22f02301-b01e-4d8f-b557-3558b6a3b9a3',0,'100%'),('2026-01-21 14:14:12.404764','2026-01-21 14:14:19.525316','2026-01-21 14:14:19.524474','ee86be96-97ed-41e6-a8dc-978f7f6c00d9','ee86be96-97ed-41e6-a8dc-978f7f6c00d9','8473a94d-852b-4ce3-8f32-21882d9b901e','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:14:12','2026-01-21 14:14:13','2026-01-21 14:14:19',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'21dd7853-6f9b-4e9a-91b3-a47c3de6b980',0,'100%'),('2026-01-21 14:17:15.849749','2026-01-21 14:17:19.999502','2026-01-21 14:17:19.998881','f149fb68-d34d-441e-9d9e-10acfdb751c3','f149fb68-d34d-441e-9d9e-10acfdb751c3','8f836eb8-08c0-452d-81ff-f53f9bda94b5','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:17:15','2026-01-21 14:17:16','2026-01-21 14:17:19',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'a35627cc-f912-49fe-a347-ce5ebde9e5e7',0,'100%'),('2026-01-21 14:10:22.895563','2026-01-21 14:10:33.169899','2026-01-21 14:10:33.168923','f1e76c5b-dd9f-45f4-b2d2-e22465776219','f1e76c5b-dd9f-45f4-b2d2-e22465776219','4a078edd-e7cf-4d2f-8afc-c08793d660dd','hostgroup@cephfs#cephfs','deleted','2026-01-21 14:10:23','2026-01-21 14:10:23','2026-01-21 14:10:32',NULL,NULL,'63c64197-bff4-402b-8808-40cae651ac91','active',NULL,'730c7c03-7e1d-487b-906f-6935715d2b12',0,'100%'),('2026-01-21 14:13:41.281286','2026-01-21 14:13:44.884942','2026-01-21 14:13:44.883828','faf2bf20-4ba4-48e9-89e1-782ae03f4ed6','faf2bf20-4ba4-48e9-89e1-782ae03f4ed6','0399260c-a060-46ea-bcae-f845b64ac843','','deleted','2026-01-21 14:13:41',NULL,NULL,NULL,NULL,NULL,'active',NULL,'9ca783c9-ecfe-469c-a4a8-d087ab0379ae',0,NULL);
/*!40000 ALTER TABLE `share_instances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_metadata`
--

DROP TABLE IF EXISTS `share_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_metadata` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `share_id` (`share_id`),
  CONSTRAINT `share_metadata_ibfk_1` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=108 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_metadata`
--

LOCK TABLES `share_metadata` WRITE;
/*!40000 ALTER TABLE `share_metadata` DISABLE KEYS */;
INSERT INTO `share_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_id`, `key`, `value`) VALUES ('2026-01-21 14:10:22.691355',NULL,'2026-01-21 14:12:12.231666',1,1,'036723cc-3463-4bf3-a330-5b38b8f58ab6','__mount_options','fs=cephfs'),('2026-01-21 14:10:23.758723',NULL,'2026-01-21 14:10:33.217420',2,2,'4a078edd-e7cf-4d2f-8afc-c08793d660dd','__mount_options','fs=cephfs'),('2026-01-21 14:10:24.196606',NULL,'2026-01-21 14:10:31.585733',3,3,'f101d908-567e-4304-b028-50ff6e482c84','__mount_options','fs=cephfs'),('2026-01-21 14:10:25.591978',NULL,'2026-01-21 14:10:28.748575',4,4,'751d6039-55f6-48ec-8c28-0b0ebaeb9d5b','__mount_options','fs=cephfs'),('2026-01-21 14:10:32.935731',NULL,'2026-01-21 14:10:39.177543',5,5,'18d6912a-f9cf-49cb-972f-a01b1c28918e','__mount_options','fs=cephfs'),('2026-01-21 14:10:43.166361',NULL,'2026-01-21 14:10:45.928079',6,6,'157f3a2d-e430-41d6-ba23-49c652f8d4de','__mount_options','fs=cephfs'),('2026-01-21 14:10:55.750909',NULL,'2026-01-21 14:11:00.113856',7,7,'c8d2e256-38ca-48f6-94ba-6ee388f70097','__mount_options','fs=cephfs'),('2026-01-21 14:11:03.574426',NULL,'2026-01-21 14:11:13.706988',8,8,'a561393a-d080-4ae1-ab47-796e34de4fb1','__mount_options','fs=cephfs'),('2026-01-21 14:11:07.977577',NULL,'2026-01-21 14:11:17.084516',9,9,'c80c0fc3-4bc7-4598-a0d4-d69daf2fd776','__mount_options','fs=cephfs'),('2026-01-21 14:11:21.684508',NULL,'2026-01-21 14:12:08.668631',10,10,'eb470898-ab04-4f3a-a04b-e77ceb023449','__mount_options','fs=cephfs'),('2026-01-21 14:11:28.355965',NULL,'2026-01-21 14:12:04.521751',11,11,'056ffbf5-e5ac-4f37-86c8-8cb3627cce73','__mount_options','fs=cephfs'),('2026-01-21 14:12:17.329858',NULL,'2026-01-21 14:12:21.059821',12,12,'6eefd607-c1fc-4d82-a269-17cb0784b4c7','__mount_options','fs=cephfs'),('2026-01-21 14:12:31.563664',NULL,'2026-01-21 14:12:36.531808',13,13,'b526118c-476f-4240-99b7-711476531384','__mount_options','fs=cephfs'),('2026-01-21 14:12:45.806802',NULL,'2026-01-21 14:12:59.841768',14,14,'f3049aa0-1e31-4c57-bea3-c4cb3a5c1ba7','__mount_options','fs=cephfs'),('2026-01-21 14:12:50.382359',NULL,'2026-01-21 14:13:15.248539',15,15,'9969199e-c110-4822-a15e-3778a83fe39c','__mount_options','fs=cephfs'),('2026-01-21 14:13:20.881573',NULL,'2026-01-21 14:14:21.962746',16,16,'fc76ee87-f013-4833-92c5-4c98f6ef4c19','foo_key_share_1','foo_value_share_1'),('2026-01-21 14:13:20.882528',NULL,'2026-01-21 14:14:21.962746',17,17,'fc76ee87-f013-4833-92c5-4c98f6ef4c19','bar_key_share_1','foo_value_share_1'),('2026-01-21 14:13:21.307721',NULL,'2026-01-21 14:14:21.962746',18,18,'fc76ee87-f013-4833-92c5-4c98f6ef4c19','__mount_options','fs=cephfs'),('2026-01-21 14:13:26.568371',NULL,'2026-01-21 14:14:13.732873',19,19,'bf3f919b-8c4d-4a4b-ba98-44d0f3aac87a','foo_key_share_2','foo_value_share_2'),('2026-01-21 14:13:26.569605',NULL,'2026-01-21 14:14:13.732873',20,20,'bf3f919b-8c4d-4a4b-ba98-44d0f3aac87a','bar_key_share_2','foo_value_share_2'),('2026-01-21 14:13:29.083821',NULL,'2026-01-21 14:14:13.732873',21,21,'bf3f919b-8c4d-4a4b-ba98-44d0f3aac87a','__mount_options','fs=cephfs'),('2026-01-21 14:13:39.005499',NULL,'2026-01-21 14:13:58.659208',22,22,'f7f2a070-b60a-4b51-878d-5e40e7a13a72','__mount_options','fs=cephfs'),('2026-01-21 14:13:41.861481',NULL,'2026-01-21 14:14:37.376189',23,23,'d2064608-c39f-4121-8bf3-57367d234998','__mount_options','fs=cephfs'),('2026-01-21 14:13:45.776269',NULL,'2026-01-21 14:13:52.018761',24,24,'3c665c41-2d99-4918-8898-968ff5d4b5b8','__mount_options','fs=cephfs'),('2026-01-21 14:13:49.585854',NULL,'2026-01-21 14:13:52.018761',25,25,'3c665c41-2d99-4918-8898-968ff5d4b5b8','key5','value5'),('2026-01-21 14:13:49.613816',NULL,'2026-01-21 14:13:52.018761',26,26,'3c665c41-2d99-4918-8898-968ff5d4b5b8','key6','value6'),('2026-01-21 14:13:50.166026',NULL,'2026-01-21 14:13:52.018761',27,27,'3c665c41-2d99-4918-8898-968ff5d4b5b8','key7','value7'),('2026-01-21 14:13:50.171881',NULL,'2026-01-21 14:13:52.018761',28,28,'3c665c41-2d99-4918-8898-968ff5d4b5b8','key8','value8'),('2026-01-21 14:13:56.834069',NULL,'2026-01-21 14:14:00.819851',29,29,'7fbe17a9-8106-4974-a0c0-060797971eae','__mount_options','fs=cephfs'),('2026-01-21 14:13:58.742377',NULL,'2026-01-21 14:14:00.819851',30,30,'7fbe17a9-8106-4974-a0c0-060797971eae','key3','value3'),('2026-01-21 14:13:58.748871',NULL,'2026-01-21 14:14:00.819851',31,31,'7fbe17a9-8106-4974-a0c0-060797971eae','key4','value4'),('2026-01-21 14:13:58.754755',NULL,'2026-01-21 14:14:00.819851',32,32,'7fbe17a9-8106-4974-a0c0-060797971eae','key.5.1','value.5'),('2026-01-21 14:14:04.188004',NULL,'2026-01-21 14:14:08.935374',33,33,'f67386cf-d1ad-458d-a3f9-c5a2653692fc','key1','value1'),('2026-01-21 14:14:04.188489',NULL,'2026-01-21 14:14:08.935374',34,34,'f67386cf-d1ad-458d-a3f9-c5a2653692fc','key2','value2'),('2026-01-21 14:14:07.285802',NULL,'2026-01-21 14:14:08.935374',35,35,'f67386cf-d1ad-458d-a3f9-c5a2653692fc','__mount_options','fs=cephfs'),('2026-01-21 14:14:11.841963',NULL,'2026-01-21 14:14:22.394306',36,36,'d05f4623-92be-4e54-b528-ddbb8752adb2','__mount_options','fs=cephfs'),('2026-01-21 14:14:13.477167',NULL,'2026-01-21 14:14:19.536971',37,37,'8473a94d-852b-4ce3-8f32-21882d9b901e','__mount_options','fs=cephfs'),('2026-01-21 14:14:14.466341',NULL,'2026-01-21 14:14:39.729312',38,38,'e556b944-c601-4d6a-9a44-72d806af4101','__mount_options','fs=cephfs'),('2026-01-21 14:14:15.944289','2026-01-21 14:14:16.456496','2026-01-21 14:14:19.536971',39,39,'8473a94d-852b-4ce3-8f32-21882d9b901e','key9','value13'),('2026-01-21 14:14:15.951760',NULL,'2026-01-21 14:14:19.536971',40,40,'8473a94d-852b-4ce3-8f32-21882d9b901e','key10','value10'),('2026-01-21 14:14:16.471587',NULL,'2026-01-21 14:14:19.536971',41,41,'8473a94d-852b-4ce3-8f32-21882d9b901e','key11','value11'),('2026-01-21 14:14:22.679148',NULL,'2026-01-21 14:14:37.376189',42,42,'d2064608-c39f-4121-8bf3-57367d234998','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value'),('2026-01-21 14:14:23.029249','2026-01-21 14:14:25.086368','2026-01-21 14:14:37.376189',43,43,'d2064608-c39f-4121-8bf3-57367d234998','key','v'),('2026-01-21 14:14:23.387514',NULL,'2026-01-21 14:14:37.376189',44,44,'d2064608-c39f-4121-8bf3-57367d234998','k','value'),('2026-01-21 14:14:26.609525',NULL,'2026-01-21 14:14:30.092411',45,45,'5d497481-daaf-4806-bc02-7a9b977bfe8c','__mount_options','fs=cephfs'),('2026-01-21 14:14:27.010425',NULL,'2026-01-21 14:14:30.092411',46,46,'5d497481-daaf-4806-bc02-7a9b977bfe8c','key9','value9'),('2026-01-21 14:14:27.014034',NULL,'2026-01-21 14:14:30.092411',47,47,'5d497481-daaf-4806-bc02-7a9b977bfe8c','key10','value10'),('2026-01-21 14:14:27.486831',NULL,'2026-01-21 14:14:30.092411',48,48,'5d497481-daaf-4806-bc02-7a9b977bfe8c','key11','value11'),('2026-01-21 14:14:27.495462',NULL,'2026-01-21 14:14:30.092411',49,49,'5d497481-daaf-4806-bc02-7a9b977bfe8c','key12','value12'),('2026-01-21 14:14:33.574418',NULL,'2026-01-21 14:14:37.376189',50,50,'d2064608-c39f-4121-8bf3-57367d234998','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value'),('2026-01-21 14:14:34.287243',NULL,'2026-01-21 14:14:37.376189',51,51,'d2064608-c39f-4121-8bf3-57367d234998','key','vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv'),('2026-01-21 14:14:34.782296',NULL,'2026-01-21 14:14:37.376189',52,52,'d2064608-c39f-4121-8bf3-57367d234998','k','value'),('2026-01-21 14:14:35.295499',NULL,'2026-01-21 14:14:37.376189',53,53,'d2064608-c39f-4121-8bf3-57367d234998','key','v'),('2026-01-21 14:14:53.198856',NULL,'2026-01-21 14:16:12.186351',54,54,'1aabce1b-dbbb-4dae-a6a5-613066113ab2','__mount_options','fs=cephfs'),('2026-01-21 14:15:00.104581',NULL,'2026-01-21 14:15:12.739896',55,55,'ba13b15f-cf4d-49e6-8796-991bdc13606f','__mount_options','fs=cephfs'),('2026-01-21 14:15:00.265132',NULL,'2026-01-21 14:15:05.806353',56,56,'e0d7e609-a29b-4fb3-ba97-e5984dc35087','__mount_options','fs=cephfs'),('2026-01-21 14:15:01.961886',NULL,'2026-01-21 14:15:11.353292',57,57,'72fbe20a-9dea-4a19-8d2c-fbf5fca1a08e','__mount_options','fs=cephfs'),('2026-01-21 14:15:18.064229',NULL,'2026-01-21 14:15:26.834836',58,58,'498f15a0-21ee-49ad-8bf0-150074745f0c','__mount_options','fs=cephfs'),('2026-01-21 14:15:29.794847',NULL,'2026-01-21 14:15:37.916896',59,59,'073f2038-c750-4560-82ed-b9e3b4ba99e5','__mount_options','fs=cephfs'),('2026-01-21 14:15:37.794345',NULL,'2026-01-21 14:19:22.933015',60,60,'fc256f6b-1503-4a6e-8c37-1daea3157b6f','__mount_options','fs=cephfs'),('2026-01-21 14:15:50.243775',NULL,'2026-01-21 14:16:00.894419',61,61,'45242132-b4fc-4649-a43e-b4fe5539da32','__mount_options','fs=cephfs'),('2026-01-21 14:15:53.591664',NULL,'2026-01-21 14:15:57.395138',62,62,'9f297125-ba6b-4bf8-bdcd-ba79f70cf48e','__mount_options','fs=cephfs'),('2026-01-21 14:16:04.490447',NULL,'2026-01-21 14:16:08.675063',63,63,'269f943c-b9aa-4c05-80a0-0a278a29a848','__mount_options','fs=cephfs'),('2026-01-21 14:16:19.882008',NULL,'2026-01-21 14:16:34.597635',64,64,'5386cb7d-3729-4e52-b4c5-42215607272e','__mount_options','fs=cephfs'),('2026-01-21 14:16:27.241622',NULL,'2026-01-21 14:16:36.369907',65,65,'e26f4411-d608-4767-8300-5651275fd6c4','key','value'),('2026-01-21 14:16:27.630704',NULL,'2026-01-21 14:16:36.369907',66,66,'e26f4411-d608-4767-8300-5651275fd6c4','__mount_options','fs=cephfs'),('2026-01-21 14:16:39.040457',NULL,'2026-01-21 14:17:50.664155',67,67,'ca6daf26-9831-4772-bcf0-7b69e0070af8','__mount_options','fs=cephfs'),('2026-01-21 14:16:39.604432',NULL,'2026-01-21 14:16:43.339221',68,68,'a46b1a94-810e-46d9-8210-a58533c70b5a','__mount_options','fs=cephfs'),('2026-01-21 14:16:42.745766',NULL,'2026-01-21 14:17:46.638632',69,69,'688d05e3-d534-4588-8ef1-588302e0580a','__mount_options','fs=cephfs'),('2026-01-21 14:16:48.736138',NULL,'2026-01-21 14:17:16.697170',70,70,'7c0e94b3-fc54-45fc-a321-25827669641d','__mount_options','fs=cephfs'),('2026-01-21 14:16:52.849561',NULL,'2026-01-21 14:17:42.660450',71,71,'b1af7887-8549-4ad6-8f39-3d20abb6170a','__mount_options','fs=cephfs'),('2026-01-21 14:16:56.423733',NULL,'2026-01-21 14:17:09.850614',72,72,'a2f00a33-a7b2-4e3d-a950-1bec6b8c16c5','__mount_options','fs=cephfs'),('2026-01-21 14:17:08.459300',NULL,'2026-01-21 14:17:12.674665',73,73,'7f1408e7-914e-4693-903c-3d7ca7ce6766','__mount_options','fs=cephfs'),('2026-01-21 14:17:16.091615',NULL,'2026-01-21 14:17:20.010214',74,74,'8f836eb8-08c0-452d-81ff-f53f9bda94b5','__mount_options','fs=cephfs'),('2026-01-21 14:17:23.999625',NULL,'2026-01-21 14:17:39.103856',75,75,'87161409-8bb7-4318-a754-72802d038d2f','__mount_options','fs=cephfs'),('2026-01-21 14:17:34.068388',NULL,'2026-01-21 14:18:36.029498',76,76,'684e0b48-a2b0-4730-acfb-d81d371a3a68','__mount_options','fs=cephfs'),('2026-01-21 14:17:43.829309',NULL,'2026-01-21 14:17:47.648260',77,77,'91279f1f-f7d7-4658-ba1b-77828dd85ad2','__mount_options','fs=cephfs'),('2026-01-21 14:17:45.525450',NULL,'2026-01-21 14:17:57.120398',78,78,'099f5b0a-98b5-4972-ad30-abd6e3819995','__mount_options','fs=cephfs'),('2026-01-21 14:17:49.172139',NULL,'2026-01-21 14:17:52.916761',79,79,'cacacb68-f5cc-4781-bc3e-01f1c20a372b','__mount_options','fs=cephfs'),('2026-01-21 14:17:51.560339',NULL,'2026-01-21 14:17:57.285075',80,80,'01a85aaf-b459-4ec1-81a3-8d27efbc9c48','__mount_options','fs=cephfs'),('2026-01-21 14:18:02.142404',NULL,'2026-01-21 14:18:11.913049',81,81,'fb08a62f-fd73-4321-8a32-ef0d0454f815','__mount_options','fs=cephfs'),('2026-01-21 14:18:17.448443',NULL,'2026-01-21 14:18:20.971141',82,82,'5940feee-026c-404d-ad37-10cf7a1f2128','__mount_options','fs=cephfs'),('2026-01-21 14:18:17.637784',NULL,'2026-01-21 14:18:21.189047',83,83,'8a0ee85c-28b4-48fa-a44e-9cb6516391d3','__mount_options','fs=cephfs'),('2026-01-21 14:18:19.713146',NULL,'2026-01-21 14:18:30.920171',84,84,'cae1b4e3-e1c6-4069-8095-973e2efe7b2e','__mount_options','fs=cephfs'),('2026-01-21 14:18:24.447262',NULL,'2026-01-21 14:18:28.930461',85,85,'14534c4c-1b02-4468-8f33-545d362f0c63','__mount_options','fs=cephfs'),('2026-01-21 14:18:24.735281',NULL,'2026-01-21 14:18:28.946217',86,86,'3d3e1f20-6c20-4283-aa54-1405dbde1c68','__mount_options','fs=cephfs'),('2026-01-21 14:18:49.438895',NULL,'2026-01-21 14:19:43.423495',87,87,'fa3c3ca4-ee78-4359-90c1-d7c6060a822d','__mount_options','fs=cephfs'),('2026-01-21 14:19:07.816541',NULL,NULL,0,88,'7222a48c-e385-4ac8-9476-23ef2ccbfa6c','__mount_options','fs=cephfs'),('2026-01-21 14:20:29.581516',NULL,'2026-01-21 14:20:57.186450',89,89,'407b384e-148b-43f2-a5fb-b1e5aa164bd3','__mount_options','fs=cephfs'),('2026-01-21 14:20:34.185312',NULL,'2026-01-21 14:20:53.743998',90,90,'fdcf3635-f7ea-4eb3-943e-64e6fa02cf1a','__mount_options','fs=cephfs'),('2026-01-21 14:20:38.015708',NULL,'2026-01-21 14:20:50.355743',91,91,'a97b8cff-7809-490b-a244-8dd0e34e7ef5','__mount_options','fs=cephfs'),('2026-01-21 14:20:42.435561',NULL,'2026-01-21 14:20:46.958453',92,92,'70d9343f-5f35-46c7-ad39-1d03bcfc6faa','__mount_options','fs=cephfs'),('2026-01-21 14:21:12.442020',NULL,'2026-01-21 14:22:59.608751',93,93,'70bc77af-7e50-4669-ba31-537c6a183e1f','foo_key_share_1','foo_value_share_1'),('2026-01-21 14:21:12.442502',NULL,'2026-01-21 14:22:59.608751',94,94,'70bc77af-7e50-4669-ba31-537c6a183e1f','bar_key_share_1','foo_value_share_1'),('2026-01-21 14:21:13.001817',NULL,'2026-01-21 14:22:59.608751',95,95,'70bc77af-7e50-4669-ba31-537c6a183e1f','__mount_options','fs=cephfs'),('2026-01-21 14:21:19.819033',NULL,'2026-01-21 14:22:52.579411',96,96,'e93e4111-7c93-41b8-8ba6-a67aecdc9a85','foo_key_share_2','foo_value_share_2'),('2026-01-21 14:21:19.819514',NULL,'2026-01-21 14:22:52.579411',97,97,'e93e4111-7c93-41b8-8ba6-a67aecdc9a85','bar_key_share_2','foo_value_share_2'),('2026-01-21 14:21:20.119462',NULL,'2026-01-21 14:22:52.579411',98,98,'e93e4111-7c93-41b8-8ba6-a67aecdc9a85','__mount_options','fs=cephfs'),('2026-01-21 14:22:10.199186',NULL,'2026-01-21 14:22:17.979515',99,99,'368eadbe-e949-4a9e-9e1a-932072519f7f','__mount_options','fs=cephfs'),('2026-01-21 14:22:27.974795',NULL,'2026-01-21 14:22:34.658829',100,100,'4b663ce3-0e4f-46e1-9a65-29146bd45b68','__mount_options','fs=cephfs'),('2026-01-21 14:22:45.992562',NULL,'2026-01-21 14:22:48.944311',101,101,'f9cd06dc-fd20-4cfe-8013-3dd5c1e3307e','__mount_options','fs=cephfs'),('2026-01-21 14:23:38.415511',NULL,'2026-01-21 14:23:52.084324',102,102,'b0c80a60-09de-4bf8-8210-d9e7065bb4bd','__mount_options','fs=cephfs'),('2026-01-21 14:24:27.507656',NULL,'2026-01-21 14:24:37.191821',103,103,'6eb48da7-67ab-49fc-b63a-2af56663b79e','__mount_options','fs=cephfs'),('2026-01-21 14:24:41.008908',NULL,'2026-01-21 14:24:53.453299',104,104,'ba38a422-131c-4c1e-8d0d-119a6f068d6a','__mount_options','fs=cephfs'),('2026-01-21 14:25:06.726937',NULL,'2026-01-21 14:25:19.730478',105,105,'70d8a2e8-9754-4f37-bd26-0b4d171eeca4','foo_key_share_1','foo_value_share_1'),('2026-01-21 14:25:06.727419',NULL,'2026-01-21 14:25:19.730478',106,106,'70d8a2e8-9754-4f37-bd26-0b4d171eeca4','bar_key_share_1','foo_value_share_1'),('2026-01-21 14:25:07.137264',NULL,'2026-01-21 14:25:19.730478',107,107,'70d8a2e8-9754-4f37-bd26-0b4d171eeca4','__mount_options','fs=cephfs');
/*!40000 ALTER TABLE `share_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_network_security_service_association`
--

DROP TABLE IF EXISTS `share_network_security_service_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_network_security_service_association` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_network_id` varchar(36) NOT NULL,
  `security_service_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `share_network_id` (`share_network_id`),
  KEY `security_service_id` (`security_service_id`),
  CONSTRAINT `share_network_security_service_association_ibfk_1` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`),
  CONSTRAINT `share_network_security_service_association_ibfk_2` FOREIGN KEY (`security_service_id`) REFERENCES `security_services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_network_security_service_association`
--

LOCK TABLES `share_network_security_service_association` WRITE;
/*!40000 ALTER TABLE `share_network_security_service_association` DISABLE KEYS */;
INSERT INTO `share_network_security_service_association` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_network_id`, `security_service_id`) VALUES ('2026-01-21 14:13:28.903058','2026-01-21 14:13:31.607980','2026-01-21 14:13:31.606940',1,1,'485085e3-5e2a-4303-9239-738a81d82c93','e0647723-226b-4ce9-8eb0-2445ed614fc3'),('2026-01-21 14:13:29.688732',NULL,NULL,0,2,'162c5662-3395-4546-81b1-f1788734fced','15f343aa-e463-4581-94a9-c22e06f659ae'),('2026-01-21 14:16:00.075999','2026-01-21 14:16:05.483209','2026-01-21 14:16:05.482373',3,3,'37fe3b80-7ddb-484f-b814-90d74a546e1f','a5f65d8f-bb40-403e-9b86-6684b5f7b30c'),('2026-01-21 14:16:00.374890','2026-01-21 14:16:05.215970','2026-01-21 14:16:05.215655',4,4,'5362ddaa-08d4-4ac6-9cc4-4208d840621f','c12c1108-38be-44c3-9f8f-8e69beedf912'),('2026-01-21 14:19:10.334268','2026-01-21 14:19:10.460207','2026-01-21 14:19:10.459858',5,5,'e971272e-60df-420d-b7ae-9fa6ba9710b3','4315334e-7020-480d-9b92-0ce2c1e17930'),('2026-01-21 14:19:11.881120','2026-01-21 14:19:12.151278','2026-01-21 14:19:12.150896',6,6,'3d9f7d4c-3e43-4898-9b96-a9cdc8832745','54ae9369-7156-4a0b-9f06-3916384d35e8'),('2026-01-21 14:19:12.657989','2026-01-21 14:19:12.760790','2026-01-21 14:19:12.759538',7,7,'f482b194-2878-4295-820e-cf8200bbaa8e','ad969dbd-799d-4a25-a274-395b7960b371'),('2026-01-21 14:19:12.851931','2026-01-21 14:19:13.074607','2026-01-21 14:19:13.073655',8,8,'f482b194-2878-4295-820e-cf8200bbaa8e','ad969dbd-799d-4a25-a274-395b7960b371'),('2026-01-21 14:19:20.268313','2026-01-21 14:19:24.053874','2026-01-21 14:19:24.053609',9,9,'caeb4676-46f7-4871-a2a7-54349af7a125','4e975191-d286-4c47-aa55-3d56fb460808'),('2026-01-21 14:19:21.111217','2026-01-21 14:19:21.333729','2026-01-21 14:19:21.333415',10,10,'f68c1ccb-5701-4bb7-82b9-9d9661464b60','852ebf37-02a5-4311-b63f-915aaad6fbb6'),('2026-01-21 14:19:22.249079','2026-01-21 14:19:22.856805','2026-01-21 14:19:22.856510',11,11,'b32cff85-ca7c-47ae-a09e-9bbb8d6511c6','1d2de491-87ab-4fac-b38f-220ed5a8f172');
/*!40000 ALTER TABLE `share_network_security_service_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_network_subnet_metadata`
--

DROP TABLE IF EXISTS `share_network_subnet_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_network_subnet_metadata` (
  `deleted` varchar(36) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_network_subnet_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `share_network_subnet_id` (`share_network_subnet_id`),
  CONSTRAINT `share_network_subnet_metadata_ibfk_1` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_network_subnet_metadata`
--

LOCK TABLES `share_network_subnet_metadata` WRITE;
/*!40000 ALTER TABLE `share_network_subnet_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_network_subnet_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_network_subnets`
--

DROP TABLE IF EXISTS `share_network_subnets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_network_subnets` (
  `id` varchar(36) NOT NULL,
  `neutron_net_id` varchar(36) DEFAULT NULL,
  `neutron_subnet_id` varchar(36) DEFAULT NULL,
  `network_type` varchar(32) DEFAULT NULL,
  `cidr` varchar(64) DEFAULT NULL,
  `segmentation_id` int(11) DEFAULT NULL,
  `gateway` varchar(64) DEFAULT NULL,
  `mtu` int(11) DEFAULT NULL,
  `share_network_id` varchar(36) DEFAULT NULL,
  `ip_version` int(11) DEFAULT NULL,
  `availability_zone_id` varchar(36) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_share_network_subnets_share_network_id_share_networks` (`share_network_id`),
  KEY `fk_share_network_subnets_availaility_zone_id_availability_zones` (`availability_zone_id`),
  CONSTRAINT `fk_share_network_subnets_availaility_zone_id_availability_zones` FOREIGN KEY (`availability_zone_id`) REFERENCES `availability_zones` (`id`),
  CONSTRAINT `fk_share_network_subnets_share_network_id_share_networks` FOREIGN KEY (`share_network_id`) REFERENCES `share_networks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_network_subnets`
--

LOCK TABLES `share_network_subnets` WRITE;
/*!40000 ALTER TABLE `share_network_subnets` DISABLE KEYS */;
INSERT INTO `share_network_subnets` (`id`, `neutron_net_id`, `neutron_subnet_id`, `network_type`, `cidr`, `segmentation_id`, `gateway`, `mtu`, `share_network_id`, `ip_version`, `availability_zone_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES ('041a4bc6-3908-4278-b6df-09795909bdea','tempest-net-id-797083481','tempest-subnet-id-1625204738',NULL,NULL,NULL,NULL,NULL,'feecd564-ed29-4c73-a49c-0b612e82bf9c',NULL,NULL,'2026-01-21 14:20:15.881517',NULL,NULL,'False'),('046b6f96-4912-4e1d-ba6b-e19197635a41','tempest-net-id-753697212','tempest-subnet-id-1043808256',NULL,NULL,NULL,NULL,NULL,'ffb20845-eebc-47d6-8c8e-0100ce6292bb',NULL,'63c64197-bff4-402b-8808-40cae651ac91','2026-01-21 14:15:49.262197','2026-01-21 14:15:49.557044','2026-01-21 14:15:49.555904','046b6f96-4912-4e1d-ba6b-e19197635a41'),('064659bb-8b44-4f58-8bbf-d5c64bd9f6ff',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'434dc312-f939-4a0c-8935-4b1787a14a3a',NULL,NULL,'2026-01-21 14:15:50.459345',NULL,NULL,'False'),('083084f4-edd3-48c6-9433-0e9f2195553a','1111','2222','vlan','10.0.0.0/24',1000,NULL,NULL,'485085e3-5e2a-4303-9239-738a81d82c93',4,NULL,'2002-02-02 00:00:00.000000',NULL,NULL,'False'),('083b253a-5fd4-4ce3-af23-162069b6239a',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'c9e84896-4ef5-447c-b797-4a91a6c7d0e0',NULL,NULL,'2026-01-21 14:20:14.270395',NULL,NULL,'False'),('084d9e48-5f3c-466c-8607-2623889da6b1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'ffb20845-eebc-47d6-8c8e-0100ce6292bb',NULL,NULL,'2026-01-21 14:15:48.681803',NULL,NULL,'False'),('1c26ffec-4ac4-4906-b5bc-acb1a8886dfa','tempest-net-id-1481983475','tempest-subnet-id-988571908',NULL,NULL,NULL,NULL,NULL,'b32cff85-ca7c-47ae-a09e-9bbb8d6511c6',NULL,NULL,'2026-01-21 14:19:21.862972',NULL,NULL,'False'),('2fd3931e-0576-46d9-bf34-f904ab821401','tempest-net-id-339552698','tempest-subnet-id-2055718015','vlan','10.0.0.0/24',1000,NULL,NULL,'37fe3b80-7ddb-484f-b814-90d74a546e1f',4,NULL,'2002-02-02 00:00:00.000000','2026-01-21 14:16:04.334123',NULL,'False'),('3d6d088e-d5e4-4775-ba0d-4a11686ff5b5','tempest-net-id-1725092471','tempest-subnet-id-2011583249',NULL,NULL,NULL,NULL,NULL,'027c38ca-d8cf-4dbe-84a9-712bb32dde7d',NULL,NULL,'2026-01-21 14:16:00.496828',NULL,NULL,'False'),('41d5c9e0-c9d0-453a-b6f6-e233feeb96fe','tempest-net-id-1654392906','tempest-subnet-id-1001842277',NULL,NULL,NULL,NULL,NULL,'e971272e-60df-420d-b7ae-9fa6ba9710b3',NULL,NULL,'2026-01-21 14:19:10.116293',NULL,NULL,'False'),('52b9b7e0-79d5-4a90-91b7-e9a92bca720e','tempest-net-id-1462091440','tempest-subnet-id-1593695729',NULL,NULL,NULL,NULL,NULL,'f482b194-2878-4295-820e-cf8200bbaa8e',NULL,NULL,'2026-01-21 14:19:12.453292',NULL,NULL,'False'),('67606c62-3e7e-42a8-9718-99e86c28f4dd','test net id','test subnet id','local','10.0.0.0/13',2000,NULL,NULL,'162c5662-3395-4546-81b1-f1788734fced',6,NULL,'2003-03-03 00:00:00.000000',NULL,NULL,'False'),('6f4deaae-77b7-4b71-ae67-22f3e4cca51b',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'caeb4676-46f7-4871-a2a7-54349af7a125',NULL,NULL,'2026-01-21 14:19:19.689319',NULL,NULL,'False'),('78975d38-54de-491e-9ad8-1f90efcd6938','tempest-net-id-1129554397','tempest-subnet-id-423251629',NULL,NULL,NULL,NULL,NULL,'199f99ba-fc76-4c50-bb33-7d435260933d',NULL,NULL,'2026-01-21 14:16:03.075551',NULL,NULL,'False'),('7fc3433f-c003-4490-a188-093735b6723c','tempest-net-id-867214452','tempest-subnet-id-1843806812',NULL,NULL,NULL,NULL,NULL,'3d9f7d4c-3e43-4898-9b96-a9cdc8832745',NULL,NULL,'2026-01-21 14:19:11.511840',NULL,NULL,'False'),('860eb642-bdf1-4f70-842a-ce01b19c35e4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'80a04173-cb2c-4773-ba95-6e2eab0776cf',NULL,NULL,'2026-01-21 14:20:14.841735',NULL,NULL,'False'),('a8cb92db-6c93-4d24-860b-293a0a578a57','tempest-net-id-1618100854','tempest-subnet-id-1995841673',NULL,NULL,NULL,NULL,NULL,'99679f47-d64a-48cc-bee7-de94950ab548',NULL,'63c64197-bff4-402b-8808-40cae651ac91','2026-01-21 14:16:54.344258','2026-01-21 14:16:54.483652','2026-01-21 14:16:54.482700','a8cb92db-6c93-4d24-860b-293a0a578a57'),('aa584d1e-5640-40f6-899d-524382b95088','tempest-net-id-1131507167','tempest-subnet-id-1515928355',NULL,NULL,NULL,NULL,NULL,'80a04173-cb2c-4773-ba95-6e2eab0776cf',NULL,'63c64197-bff4-402b-8808-40cae651ac91','2026-01-21 14:20:15.041616','2026-01-21 14:20:15.232023','2026-01-21 14:20:15.231478','aa584d1e-5640-40f6-899d-524382b95088'),('b0796d77-253e-4b5b-a757-7fb0f2ddc789',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'99679f47-d64a-48cc-bee7-de94950ab548',NULL,NULL,'2026-01-21 14:16:53.569362',NULL,NULL,'False'),('b2ad96e9-3b1d-42d0-8c2e-40feca806310','tempest-net-id-814525796','tempest-subnet-id-1681152145',NULL,NULL,NULL,NULL,NULL,'9a47896f-cc26-427e-a01f-a856517f4dae',NULL,NULL,'2026-01-21 14:16:01.154884',NULL,NULL,'False'),('c0cf9297-1081-49ae-b26b-fcc1dfaf37f5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'32de66f4-8382-4480-8bb4-384e3b991248',NULL,NULL,'2026-01-21 14:15:48.295575',NULL,NULL,'False'),('d0b7956d-244a-4579-bebc-cd20dd0bf927','test net id','test subnet id','local','10.0.0.0/13',2000,NULL,NULL,'5362ddaa-08d4-4ac6-9cc4-4208d840621f',6,NULL,'2003-03-03 00:00:00.000000',NULL,NULL,'False'),('e6dcca4a-d6be-4903-878b-c2fc864481c3','tempest-net-id-422586802','tempest-subnet-id-1143161422',NULL,NULL,NULL,NULL,NULL,'434dc312-f939-4a0c-8935-4b1787a14a3a',NULL,'63c64197-bff4-402b-8808-40cae651ac91','2026-01-21 14:15:50.663563','2026-01-21 14:15:50.957581','2026-01-21 14:15:50.956791','e6dcca4a-d6be-4903-878b-c2fc864481c3'),('e9ae5953-c621-4648-8662-0c50e0f18591','tempest-net-id-1129554397','tempest-subnet-id-423251629',NULL,NULL,NULL,NULL,NULL,'c21c336c-f840-482a-b435-6d0c59aab4e6',NULL,NULL,'2026-01-21 14:16:03.515795',NULL,NULL,'False'),('ee9125b6-9fa2-46a6-9f3f-c6d5751d9013','tempest-net-id-636622381','tempest-subnet-id-309322209',NULL,NULL,NULL,NULL,NULL,'f68c1ccb-5701-4bb7-82b9-9d9661464b60',NULL,NULL,'2026-01-21 14:19:20.816029',NULL,NULL,'False'),('fa6febad-ca2c-4d79-83f8-e4576541c135','tempest-net-id-814525796','tempest-subnet-id-1681152145',NULL,NULL,NULL,NULL,NULL,'c35d16da-17b9-42f4-b963-0177df5495bc',NULL,NULL,'2026-01-21 14:16:00.965372',NULL,NULL,'False');
/*!40000 ALTER TABLE `share_network_subnets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_networks`
--

DROP TABLE IF EXISTS `share_networks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_networks` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(36) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_networks`
--

LOCK TABLES `share_networks` WRITE;
/*!40000 ALTER TABLE `share_networks` DISABLE KEYS */;
INSERT INTO `share_networks` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `user_id`, `name`, `description`, `status`) VALUES ('2026-01-21 14:16:00.478278','2026-01-21 14:16:00.650674','2026-01-21 14:16:00.650218','027c38ca-d8cf-4dbe-84a9-712bb32dde7d','027c38ca-d8cf-4dbe-84a9-712bb32dde7d','a7c6c7c42b5d4ca3933e833a80ca4f97','e98a65c358ff470b949414cd13a3245a','tempest-sn-name-1950009566','tempest-sn-desc-685928236','active'),('2003-03-03 00:00:00.000000',NULL,NULL,'False','162c5662-3395-4546-81b1-f1788734fced','13c5ce7776694d3ba842a33559f0ce31','b020af4acf6c46669264d3692bde318e','sn_with_kerberos_ss','fake description','active'),('2026-01-21 14:16:03.058160','2026-01-21 14:16:03.245658','2026-01-21 14:16:03.245228','199f99ba-fc76-4c50-bb33-7d435260933d','199f99ba-fc76-4c50-bb33-7d435260933d','a7c6c7c42b5d4ca3933e833a80ca4f97','e98a65c358ff470b949414cd13a3245a','tempest-sn-name-969368265','tempest-sn-desc-1090406142','active'),('2026-01-21 14:15:48.234912','2026-01-21 14:15:50.061832','2026-01-21 14:15:50.058872','32de66f4-8382-4480-8bb4-384e3b991248','32de66f4-8382-4480-8bb4-384e3b991248','e564b97ee9594256ae7ad401e2e84d33','293519a837134c9eb5c1064ac437ea0d',NULL,NULL,'active'),('2002-02-02 00:00:00.000000','2026-01-21 14:16:05.501977','2026-01-21 14:16:05.501441','37fe3b80-7ddb-484f-b814-90d74a546e1f','37fe3b80-7ddb-484f-b814-90d74a546e1f','a7c6c7c42b5d4ca3933e833a80ca4f97','e98a65c358ff470b949414cd13a3245a','tempest-sn-name-800612864','tempest-sn-desc-122524989','active'),('2026-01-21 14:19:11.496976','2026-01-21 14:19:12.210922','2026-01-21 14:19:12.210317','3d9f7d4c-3e43-4898-9b96-a9cdc8832745','3d9f7d4c-3e43-4898-9b96-a9cdc8832745','3045c953c1f44932b48db800dd54be02','1bdd99b08fdf48cbae340f6fab64e0de','tempest-sn-name-244771903','tempest-sn-desc-1008164220','active'),('2026-01-21 14:15:50.408661','2026-01-21 14:15:51.311844','2026-01-21 14:15:51.311275','434dc312-f939-4a0c-8935-4b1787a14a3a','434dc312-f939-4a0c-8935-4b1787a14a3a','e564b97ee9594256ae7ad401e2e84d33','293519a837134c9eb5c1064ac437ea0d',NULL,NULL,'active'),('2002-02-02 00:00:00.000000','2026-01-21 14:13:31.709430','2026-01-21 14:13:31.708473','485085e3-5e2a-4303-9239-738a81d82c93','485085e3-5e2a-4303-9239-738a81d82c93','938ff6c62b4d4bfe9c13b015ab84e14b','371332db2a2c453ea215c3980707fbd6','sn_with_ldap_ss','fake description','active'),('2003-03-03 00:00:00.000000','2026-01-21 14:16:05.231446','2026-01-21 14:16:05.230902','5362ddaa-08d4-4ac6-9cc4-4208d840621f','5362ddaa-08d4-4ac6-9cc4-4208d840621f','a7c6c7c42b5d4ca3933e833a80ca4f97','e98a65c358ff470b949414cd13a3245a','sn_with_kerberos_ss','fake description','active'),('2026-01-21 14:20:14.825040','2026-01-21 14:20:15.485070','2026-01-21 14:20:15.484433','80a04173-cb2c-4773-ba95-6e2eab0776cf','80a04173-cb2c-4773-ba95-6e2eab0776cf','273b0f88119142bb88f70bd49708607c','6ec525d992e341d68f12ae0cac568446',NULL,NULL,'active'),('2026-01-21 14:16:53.535459',NULL,NULL,'False','99679f47-d64a-48cc-bee7-de94950ab548','78145dbf5c284a599c7efda43d8f4201','1e36f40dbb4a41dfa0a09d53e38a09a3',NULL,NULL,'active'),('2026-01-21 14:16:01.131327','2026-01-21 14:16:01.291826','2026-01-21 14:16:01.290730','9a47896f-cc26-427e-a01f-a856517f4dae','9a47896f-cc26-427e-a01f-a856517f4dae','a7c6c7c42b5d4ca3933e833a80ca4f97','e98a65c358ff470b949414cd13a3245a','tempest-sn-name-465625992','tempest-sn-desc-2049512825','active'),('2026-01-21 14:19:21.844279','2026-01-21 14:19:22.876469','2026-01-21 14:19:22.875976','b32cff85-ca7c-47ae-a09e-9bbb8d6511c6','b32cff85-ca7c-47ae-a09e-9bbb8d6511c6','e5d2b19b5e42472bbc153671b4a835ba','5e463fc3b37f4ad683d113fe4e8b2d6a','tempest-sn-name-1460799423','tempest-sn-desc-1034708193','active'),('2026-01-21 14:16:03.481143','2026-01-21 14:16:03.698790','2026-01-21 14:16:03.697835','c21c336c-f840-482a-b435-6d0c59aab4e6','c21c336c-f840-482a-b435-6d0c59aab4e6','a7c6c7c42b5d4ca3933e833a80ca4f97','e98a65c358ff470b949414cd13a3245a','tempest-sn-name-969368265','tempest-sn-desc-1090406142','active'),('2026-01-21 14:16:00.948973','2026-01-21 14:16:01.493060','2026-01-21 14:16:01.492645','c35d16da-17b9-42f4-b963-0177df5495bc','c35d16da-17b9-42f4-b963-0177df5495bc','a7c6c7c42b5d4ca3933e833a80ca4f97','e98a65c358ff470b949414cd13a3245a','tempest-sn-name-465625992','tempest-sn-desc-2049512825','active'),('2026-01-21 14:20:14.250895','2026-01-21 14:20:14.515260','2026-01-21 14:20:14.514745','c9e84896-4ef5-447c-b797-4a91a6c7d0e0','c9e84896-4ef5-447c-b797-4a91a6c7d0e0','273b0f88119142bb88f70bd49708607c','6ec525d992e341d68f12ae0cac568446',NULL,NULL,'active'),('2026-01-21 14:19:19.673424','2026-01-21 14:19:24.069327','2026-01-21 14:19:24.068864','caeb4676-46f7-4871-a2a7-54349af7a125','caeb4676-46f7-4871-a2a7-54349af7a125','e5d2b19b5e42472bbc153671b4a835ba','5e463fc3b37f4ad683d113fe4e8b2d6a',NULL,NULL,'active'),('2026-01-21 14:19:10.044134','2026-01-21 14:19:11.128990','2026-01-21 14:19:11.128506','e971272e-60df-420d-b7ae-9fa6ba9710b3','e971272e-60df-420d-b7ae-9fa6ba9710b3','3045c953c1f44932b48db800dd54be02','1bdd99b08fdf48cbae340f6fab64e0de','tempest-sn-name-1295693055','tempest-sn-desc-1536998509','active'),('2026-01-21 14:19:12.437970','2026-01-21 14:19:13.090919','2026-01-21 14:19:13.090425','f482b194-2878-4295-820e-cf8200bbaa8e','f482b194-2878-4295-820e-cf8200bbaa8e','3045c953c1f44932b48db800dd54be02','1bdd99b08fdf48cbae340f6fab64e0de','tempest-sn-name-978316193','tempest-sn-desc-806778508','active'),('2026-01-21 14:19:20.771077','2026-01-21 14:19:21.621702','2026-01-21 14:19:21.621234','f68c1ccb-5701-4bb7-82b9-9d9661464b60','f68c1ccb-5701-4bb7-82b9-9d9661464b60','e5d2b19b5e42472bbc153671b4a835ba','5e463fc3b37f4ad683d113fe4e8b2d6a','tempest-sn-name-794299665','tempest-sn-desc-995389273','active'),('2026-01-21 14:20:15.867323','2026-01-21 14:20:16.029675','2026-01-21 14:20:16.029139','feecd564-ed29-4c73-a49c-0b612e82bf9c','feecd564-ed29-4c73-a49c-0b612e82bf9c','273b0f88119142bb88f70bd49708607c','6ec525d992e341d68f12ae0cac568446','tempest-sn-name-2088618036','tempest-sn-desc-1941864074','active'),('2026-01-21 14:15:48.612570',NULL,NULL,'False','ffb20845-eebc-47d6-8c8e-0100ce6292bb','e564b97ee9594256ae7ad401e2e84d33','293519a837134c9eb5c1064ac437ea0d',NULL,NULL,'active');
/*!40000 ALTER TABLE `share_networks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_server_backend_details`
--

DROP TABLE IF EXISTS `share_server_backend_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_server_backend_details` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_server_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `share_server_id` (`share_server_id`),
  CONSTRAINT `share_server_backend_details_ibfk_1` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_server_backend_details`
--

LOCK TABLES `share_server_backend_details` WRITE;
/*!40000 ALTER TABLE `share_server_backend_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_server_backend_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_server_share_network_subnet_mappings`
--

DROP TABLE IF EXISTS `share_server_share_network_subnet_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_server_share_network_subnet_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_server_id` varchar(36) NOT NULL,
  `share_network_subnet_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_ss_sns_m_share_server_id_share_servers` (`share_server_id`),
  KEY `fk_ss_sns_m_share_network_subnet_id_share_network_subnets` (`share_network_subnet_id`),
  CONSTRAINT `fk_ss_sns_m_share_network_subnet_id_share_network_subnets` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`),
  CONSTRAINT `fk_ss_sns_m_share_server_id_share_servers` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_server_share_network_subnet_mappings`
--

LOCK TABLES `share_server_share_network_subnet_mappings` WRITE;
/*!40000 ALTER TABLE `share_server_share_network_subnet_mappings` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_server_share_network_subnet_mappings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_servers`
--

DROP TABLE IF EXISTS `share_servers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_servers` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `host` varchar(255) DEFAULT NULL,
  `status` varchar(32) DEFAULT NULL,
  `is_auto_deletable` tinyint(1) DEFAULT NULL,
  `identifier` varchar(255) DEFAULT NULL,
  `task_state` varchar(255) DEFAULT NULL,
  `source_share_server_id` varchar(36) DEFAULT NULL,
  `security_service_update_support` tinyint(1) NOT NULL DEFAULT 0,
  `network_allocation_update_support` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `fk_share_servers_source_share_server_id` (`source_share_server_id`),
  CONSTRAINT `fk_share_servers_source_share_server_id` FOREIGN KEY (`source_share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_servers`
--

LOCK TABLES `share_servers` WRITE;
/*!40000 ALTER TABLE `share_servers` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_servers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_access_map`
--

DROP TABLE IF EXISTS `share_snapshot_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_access_map` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_snapshot_id` varchar(36) DEFAULT NULL,
  `access_type` varchar(255) DEFAULT NULL,
  `access_to` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ssam_snapshot_fk` (`share_snapshot_id`),
  CONSTRAINT `ssam_snapshot_fk` FOREIGN KEY (`share_snapshot_id`) REFERENCES `share_snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_access_map`
--

LOCK TABLES `share_snapshot_access_map` WRITE;
/*!40000 ALTER TABLE `share_snapshot_access_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_instance_access_map`
--

DROP TABLE IF EXISTS `share_snapshot_instance_access_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_instance_access_map` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_snapshot_instance_id` varchar(36) DEFAULT NULL,
  `access_id` varchar(36) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ssiam_snapshot_instance_fk` (`share_snapshot_instance_id`),
  KEY `ssam_access_fk` (`access_id`),
  CONSTRAINT `ssam_access_fk` FOREIGN KEY (`access_id`) REFERENCES `share_snapshot_access_map` (`id`),
  CONSTRAINT `ssiam_snapshot_instance_fk` FOREIGN KEY (`share_snapshot_instance_id`) REFERENCES `share_snapshot_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_instance_access_map`
--

LOCK TABLES `share_snapshot_instance_access_map` WRITE;
/*!40000 ALTER TABLE `share_snapshot_instance_access_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_instance_access_map` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_instance_export_locations`
--

DROP TABLE IF EXISTS `share_snapshot_instance_export_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_instance_export_locations` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `share_snapshot_instance_id` varchar(36) DEFAULT NULL,
  `path` varchar(2000) DEFAULT NULL,
  `is_admin_only` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ssiel_snapshot_instance_fk` (`share_snapshot_instance_id`),
  CONSTRAINT `ssiel_snapshot_instance_fk` FOREIGN KEY (`share_snapshot_instance_id`) REFERENCES `share_snapshot_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_instance_export_locations`
--

LOCK TABLES `share_snapshot_instance_export_locations` WRITE;
/*!40000 ALTER TABLE `share_snapshot_instance_export_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_snapshot_instance_export_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_instances`
--

DROP TABLE IF EXISTS `share_snapshot_instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_instances` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `share_instance_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `share_proto` varchar(255) DEFAULT NULL,
  `share_group_snapshot_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ssi_snapshot_fk` (`snapshot_id`),
  KEY `ssi_share_instance_fk` (`share_instance_id`),
  CONSTRAINT `ssi_share_instance_fk` FOREIGN KEY (`share_instance_id`) REFERENCES `share_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_instances`
--

LOCK TABLES `share_snapshot_instances` WRITE;
/*!40000 ALTER TABLE `share_snapshot_instances` DISABLE KEYS */;
INSERT INTO `share_snapshot_instances` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `snapshot_id`, `share_instance_id`, `status`, `progress`, `provider_location`, `user_id`, `project_id`, `size`, `share_proto`, `share_group_snapshot_id`) VALUES ('2026-01-21 14:13:42.177569','2026-01-21 14:13:55.088690','2026-01-21 14:13:55.088172','0d157e9e-6dbe-4da5-910a-8205b873e355','0d157e9e-6dbe-4da5-910a-8205b873e355','f1069ca7-a7f5-4b7d-93eb-79908004053c','bba0c3cf-adf3-468e-ae9d-3e37f7ff8fa0','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:11:33.190087','2026-01-21 14:11:59.145711','2026-01-21 14:11:59.144883','13d8e771-64b1-4720-ac35-75306a2796ca','13d8e771-64b1-4720-ac35-75306a2796ca','ef40f7be-1cf7-4119-b7a9-71eb5b9dc8ce','d3ce0e74-c7d0-4049-ba17-7d4296160447','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:11:03.862560','2026-01-21 14:11:05.721082','2026-01-21 14:11:05.719060','2fe464ee-20eb-425c-b4bb-d3f446c877cd','2fe464ee-20eb-425c-b4bb-d3f446c877cd','079a2c23-2c42-4cc1-a9d6-b5424fcac054','d3ce0e74-c7d0-4049-ba17-7d4296160447','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:25:10.320177','2026-01-21 14:25:16.205877','2026-01-21 14:25:16.205327','31812bf0-d81e-40c3-a226-5318705677c6','31812bf0-d81e-40c3-a226-5318705677c6','11cda10a-e8ff-460e-8c56-b778054d00c7','074ccac6-f42c-493c-9d0b-aab404cacaf6','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:11:38.165045','2026-01-21 14:11:54.793468','2026-01-21 14:11:54.792801','3545ae94-f727-47c4-a7fd-1c526ecea0fa','3545ae94-f727-47c4-a7fd-1c526ecea0fa','d00da2a0-c417-42b5-bf93-02a64cbb16fe','d3ce0e74-c7d0-4049-ba17-7d4296160447','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:18:54.029490','2026-01-21 14:18:56.123684','2026-01-21 14:18:56.123265','3865f07e-c822-4316-8c79-2b1c82ad80c4','3865f07e-c822-4316-8c79-2b1c82ad80c4','a8a4303d-8f0c-4d7c-83ea-8406b6d6fcc5','4fe02932-2d04-427d-b4f6-1c341396704b','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:16:51.948396','2026-01-21 14:17:13.156583','2026-01-21 14:17:13.155993','42f3b54a-8269-4b88-8ab9-77648d8a58e3','42f3b54a-8269-4b88-8ab9-77648d8a58e3','fb763622-636c-421d-a618-54f14cb70a37','d96d5fd8-0350-40e0-a742-9103d3d18e31','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:18:53.520516','2026-01-21 14:19:41.142125','2026-01-21 14:19:41.141569','50188602-9386-4740-9326-44acaedb4caa','50188602-9386-4740-9326-44acaedb4caa','e9dfc6f5-6817-4818-8b7a-6638ecfd5d54','4fe02932-2d04-427d-b4f6-1c341396704b','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:14:13.905766','2026-01-21 14:14:18.857416','2026-01-21 14:14:18.856705','550e4856-6eec-4620-8d3b-79929da3bf92','550e4856-6eec-4620-8d3b-79929da3bf92','7e50f506-28fa-4be1-8389-acdae8ac8ba3','398fce8f-70d1-42b2-8ff9-f180fc0fd07c','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:24:44.020492','2026-01-21 14:24:50.490713','2026-01-21 14:24:50.489836','58879d21-f788-4eae-af79-848cdb9584de','58879d21-f788-4eae-af79-848cdb9584de','d9839651-f469-4415-89ae-cc62bff4e10f','4564206e-a1af-4abb-a427-9d87957a49e0','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:11:25.883641','2026-01-21 14:12:03.222927','2026-01-21 14:12:03.222321','61418a5a-530f-4665-9f42-37eaec4b7f3b','61418a5a-530f-4665-9f42-37eaec4b7f3b','56d6dc8f-03ac-4a2a-b985-23defb122518','d3ce0e74-c7d0-4049-ba17-7d4296160447','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:19:16.486501','2026-01-21 14:19:21.867820','2026-01-21 14:19:21.867341','6730d26a-6aff-40af-a601-82d487d21c1b','6730d26a-6aff-40af-a601-82d487d21c1b','d0adc3df-76d3-4b70-bbe5-e57bff1140d1','4fe02932-2d04-427d-b4f6-1c341396704b','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:17:38.162404','2026-01-21 14:18:32.473731','2026-01-21 14:18:32.472993','73e67d86-f13b-459e-a543-f49785594c69','73e67d86-f13b-459e-a543-f49785594c69','ed4d40c5-f4bd-45ce-9692-e4bc79bb0372','6fb09730-0544-4361-97f8-11e56000d2f0','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:11:39.784192','2026-01-21 14:11:45.280340','2026-01-21 14:11:45.279851','7af6d476-9e96-455d-901d-cb117be73224','7af6d476-9e96-455d-901d-cb117be73224','97526c93-fc84-45f0-b580-04d89d51b5a7','d3ce0e74-c7d0-4049-ba17-7d4296160447','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:18:59.767400','2026-01-21 14:19:05.696736','2026-01-21 14:19:05.696072','882c1b0b-28af-4e8f-82ab-4260c6bbe2e1','882c1b0b-28af-4e8f-82ab-4260c6bbe2e1','fda77d42-2af2-4751-8381-d4861d82e3b5','4fe02932-2d04-427d-b4f6-1c341396704b','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:23:40.640439','2026-01-21 14:23:48.053484','2026-01-21 14:23:48.052971','89f00eb7-0d7f-4bfa-aebe-ef725e504018','89f00eb7-0d7f-4bfa-aebe-ef725e504018','a974555c-2f99-4804-bf49-5a8570c58762','536a2c39-721a-4234-bb20-8865a7392cf1','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:21:16.310597','2026-01-21 14:22:56.007556','2026-01-21 14:22:56.006933','93465ce5-7efa-45bd-b994-86ad6664e631','93465ce5-7efa-45bd-b994-86ad6664e631','717877ed-ee59-4b6f-a8b8-a5e824a0e143','cf9fedcb-41b1-4a3d-849f-ba456ffc232e','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:13:24.569671','2026-01-21 14:14:18.507333','2026-01-21 14:14:18.506861','9e095a23-07cd-445c-a098-afd719bc8021','9e095a23-07cd-445c-a098-afd719bc8021','09b94b8f-18fe-41bc-bc29-2dce63cc4501','1442b436-f5bb-47c2-acbf-ac7903d9399e','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:11:20.419679','2026-01-21 14:12:08.119887','2026-01-21 14:12:08.119318','a8b3e1a0-047e-4d57-b74a-72ec2981cdc4','a8b3e1a0-047e-4d57-b74a-72ec2981cdc4','c5e71a6b-b6f4-4c59-b979-36f333691be0','d3ce0e74-c7d0-4049-ba17-7d4296160447','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:11:30.933907','2026-01-21 14:12:00.160772','2026-01-21 14:12:00.160282','b687d358-d36c-4697-89e0-1aa237110732','b687d358-d36c-4697-89e0-1aa237110732','18fb6d14-013d-43de-a247-048a332ec2b1','901b9a46-d563-4a2c-bc82-2f893614e2f0','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:19:09.108928','2026-01-21 14:19:13.210304','2026-01-21 14:19:13.209827','b761fcee-f754-4df5-8daa-e066bd13935b','b761fcee-f754-4df5-8daa-e066bd13935b','fe9bc1b3-d5c9-4565-8fc7-bafb91560e19','4fe02932-2d04-427d-b4f6-1c341396704b','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:18:22.849972','2026-01-21 14:18:27.818181','2026-01-21 14:18:27.817700','beb041ba-4500-43bc-91c9-794ff68a2025','beb041ba-4500-43bc-91c9-794ff68a2025','325147df-76fa-4b90-9267-80d02dee5e0b','75787c7c-a801-4e74-8f54-f20d6b4880b0','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:19:26.977330','2026-01-21 14:19:33.244551','2026-01-21 14:19:33.244112','c69e25ee-cc9d-4429-8a2a-8711a855d3dd','c69e25ee-cc9d-4429-8a2a-8711a855d3dd','737b967c-2386-438d-aa9d-7e9a039e9aac','4fe02932-2d04-427d-b4f6-1c341396704b','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:12:49.136373','2026-01-21 14:12:55.086436','2026-01-21 14:12:55.085837','c7ae62df-b2fa-47d8-aba5-e6ef84f541d4','c7ae62df-b2fa-47d8-aba5-e6ef84f541d4','e3be0d8d-321f-4f19-926e-84f856a6aa95','909aa505-0296-4e74-80ca-1c8370556d29','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:24:29.393135','2026-01-21 14:24:33.687036','2026-01-21 14:24:33.685899','ca15cc81-265c-4731-8934-f7ef13bd3c7e','ca15cc81-265c-4731-8934-f7ef13bd3c7e','129f980f-9630-48b1-bcde-e45a9ed0079b','a5f701d9-3332-493b-805e-f694262123e2','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:13:46.191042','2026-01-21 14:13:51.836290','2026-01-21 14:13:51.835733','dabc2c37-27ba-4a51-926a-eca273cf108c','dabc2c37-27ba-4a51-926a-eca273cf108c','c7c0cfbe-1a2d-4759-861e-1f5bef8b3de7','bba0c3cf-adf3-468e-ae9d-3e37f7ff8fa0','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL),('2026-01-21 14:16:23.337187','2026-01-21 14:16:27.341738','2026-01-21 14:16:27.341303','daf7ebd9-3c4d-4d8d-a4bf-e96f88964a3b','daf7ebd9-3c4d-4d8d-a4bf-e96f88964a3b','cd26f1f2-bc6e-4358-affb-44dc2065fabf','a444a045-3a18-4422-831d-838f3d178e33','deleted','100%',NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `share_snapshot_instances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshot_metadata`
--

DROP TABLE IF EXISTS `share_snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshot_metadata` (
  `deleted` varchar(36) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `share_snapshot_id` (`share_snapshot_id`),
  CONSTRAINT `share_snapshot_metadata_ibfk_1` FOREIGN KEY (`share_snapshot_id`) REFERENCES `share_snapshots` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshot_metadata`
--

LOCK TABLES `share_snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `share_snapshot_metadata` DISABLE KEYS */;
INSERT INTO `share_snapshot_metadata` (`deleted`, `created_at`, `updated_at`, `deleted_at`, `share_snapshot_id`, `key`, `value`, `id`) VALUES ('1','2026-01-21 14:18:54.491336','2026-01-21 14:18:54.908049','2026-01-21 14:18:56.136137','a8a4303d-8f0c-4d7c-83ea-8406b6d6fcc5','key5','value5',1),('2','2026-01-21 14:18:54.494090','2026-01-21 14:18:54.987676','2026-01-21 14:18:56.136137','a8a4303d-8f0c-4d7c-83ea-8406b6d6fcc5','key6','value6',2),('3','2026-01-21 14:18:55.033041',NULL,'2026-01-21 14:18:56.136137','a8a4303d-8f0c-4d7c-83ea-8406b6d6fcc5','key7','value7',3),('4','2026-01-21 14:18:55.035640',NULL,'2026-01-21 14:18:56.136137','a8a4303d-8f0c-4d7c-83ea-8406b6d6fcc5','key8','value8',4),('5','2026-01-21 14:19:03.546581','2026-01-21 14:19:04.401998','2026-01-21 14:19:05.719845','fda77d42-2af2-4751-8381-d4861d82e3b5','key3','value3',5),('6','2026-01-21 14:19:03.548567','2026-01-21 14:19:04.597029','2026-01-21 14:19:05.719845','fda77d42-2af2-4751-8381-d4861d82e3b5','key4','value4',6),('7','2026-01-21 14:19:03.550707','2026-01-21 14:19:04.962397','2026-01-21 14:19:05.719845','fda77d42-2af2-4751-8381-d4861d82e3b5','key.5.1','value.5',7),('8','2026-01-21 14:19:09.107652',NULL,'2026-01-21 14:19:13.220922','fe9bc1b3-d5c9-4565-8fc7-bafb91560e19','key1','value1',8),('9','2026-01-21 14:19:09.108075',NULL,'2026-01-21 14:19:13.220922','fe9bc1b3-d5c9-4565-8fc7-bafb91560e19','key2','value2',9),('10','2026-01-21 14:19:20.012008','2026-01-21 14:19:21.031716','2026-01-21 14:19:21.877869','d0adc3df-76d3-4b70-bbe5-e57bff1140d1','key9','value13',10),('11','2026-01-21 14:19:20.014958','2026-01-21 14:19:21.204375','2026-01-21 14:19:21.877869','d0adc3df-76d3-4b70-bbe5-e57bff1140d1','key10','value10',11),('12','2026-01-21 14:19:20.460525','2026-01-21 14:19:21.361033','2026-01-21 14:19:21.877869','d0adc3df-76d3-4b70-bbe5-e57bff1140d1','key11','value11',12),('13','2026-01-21 14:19:25.163279','2026-01-21 14:19:36.795926','2026-01-21 14:19:41.160817','e9dfc6f5-6817-4818-8b7a-6638ecfd5d54','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value',13),('14','2026-01-21 14:19:25.533350','2026-01-21 14:19:36.833893','2026-01-21 14:19:41.160817','e9dfc6f5-6817-4818-8b7a-6638ecfd5d54','key','v',14),('15','2026-01-21 14:19:25.897969','2026-01-21 14:19:36.868477','2026-01-21 14:19:41.160817','e9dfc6f5-6817-4818-8b7a-6638ecfd5d54','k','value',15),('16','2026-01-21 14:19:30.933306','2026-01-21 14:19:32.271500','2026-01-21 14:19:33.256343','737b967c-2386-438d-aa9d-7e9a039e9aac','key9','value9',16),('17','2026-01-21 14:19:30.937719','2026-01-21 14:19:32.407437','2026-01-21 14:19:33.256343','737b967c-2386-438d-aa9d-7e9a039e9aac','key10','value10',17),('18','2026-01-21 14:19:31.464767','2026-01-21 14:19:32.546520','2026-01-21 14:19:33.256343','737b967c-2386-438d-aa9d-7e9a039e9aac','key11','value11',18),('19','2026-01-21 14:19:31.466912','2026-01-21 14:19:32.697800','2026-01-21 14:19:33.256343','737b967c-2386-438d-aa9d-7e9a039e9aac','key12','value12',19),('20','2026-01-21 14:19:36.914388','2026-01-21 14:19:37.389990','2026-01-21 14:19:41.160817','e9dfc6f5-6817-4818-8b7a-6638ecfd5d54','kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk','value',20),('21','2026-01-21 14:19:37.439126','2026-01-21 14:19:37.872646','2026-01-21 14:19:41.160817','e9dfc6f5-6817-4818-8b7a-6638ecfd5d54','key','vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv',21),('22','2026-01-21 14:19:37.915876','2026-01-21 14:19:38.464304','2026-01-21 14:19:41.160817','e9dfc6f5-6817-4818-8b7a-6638ecfd5d54','k','value',22),('23','2026-01-21 14:19:38.499128',NULL,'2026-01-21 14:19:41.160817','e9dfc6f5-6817-4818-8b7a-6638ecfd5d54','key','v',23);
/*!40000 ALTER TABLE `share_snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_snapshots`
--

DROP TABLE IF EXISTS `share_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_snapshots` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `share_id` varchar(36) NOT NULL,
  `size` int(11) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `share_size` int(11) DEFAULT NULL,
  `share_proto` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_id` (`share_id`),
  CONSTRAINT `share_snapshots_ibfk_1` FOREIGN KEY (`share_id`) REFERENCES `shares` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_snapshots`
--

LOCK TABLES `share_snapshots` WRITE;
/*!40000 ALTER TABLE `share_snapshots` DISABLE KEYS */;
INSERT INTO `share_snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `share_id`, `size`, `display_name`, `display_description`, `share_size`, `share_proto`) VALUES ('2026-01-21 14:11:03.856143','2026-01-21 14:11:05.743505','2026-01-21 14:11:05.742519','079a2c23-2c42-4cc1-a9d6-b5424fcac054','079a2c23-2c42-4cc1-a9d6-b5424fcac054','9f6fd3bf04e94f2d8e668d8e93cb0afa','81d0568612894d6da94e01a77bfde64f','036723cc-3463-4bf3-a330-5b38b8f58ab6',1,'tempest-tempest-created-share-snap-681226081','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-21 14:13:24.566361','2026-01-21 14:14:18.530567','2026-01-21 14:14:18.530158','09b94b8f-18fe-41bc-bc29-2dce63cc4501','09b94b8f-18fe-41bc-bc29-2dce63cc4501','111328e7e8c9499f9dd897f7f644b965','79952fad07e54cf18c5f2c207bdbf9fb','fc76ee87-f013-4833-92c5-4c98f6ef4c19',1,'tempest-tempest-snapshot-name-407382745','tempest-tempest-snapshot-description-2051413593',1,'CEPHFS'),('2026-01-21 14:25:10.318325','2026-01-21 14:25:16.220798','2026-01-21 14:25:16.220259','11cda10a-e8ff-460e-8c56-b778054d00c7','11cda10a-e8ff-460e-8c56-b778054d00c7','1168f378c75641a9a34467d731e79a9e','3ae1279c04024905bd21b77f8a95d5ae','70d8a2e8-9754-4f37-bd26-0b4d171eeca4',1,'tempest-tempest-snapshot-name-480920098','tempest-tempest-snapshot-description-1006184577',1,'CEPHFS'),('2026-01-21 14:24:29.391794','2026-01-21 14:24:33.712244','2026-01-21 14:24:33.711458','129f980f-9630-48b1-bcde-e45a9ed0079b','129f980f-9630-48b1-bcde-e45a9ed0079b','37b3bbc0092f402c82354dc1111facd4','a4f094a58f4542e2ab299637736993f9','6eb48da7-67ab-49fc-b63a-2af56663b79e',2,'tempest-tempest-created-share-snap-906738623','Tempest\'s snapshot',2,'CEPHFS'),('2026-01-21 14:11:30.932530','2026-01-21 14:12:00.177645','2026-01-21 14:12:00.177085','18fb6d14-013d-43de-a247-048a332ec2b1','18fb6d14-013d-43de-a247-048a332ec2b1','91a5b3e563184701bd5a4f2a997f8221','2806d215025845bc90e195f0b5c64c21','056ffbf5-e5ac-4f37-86c8-8cb3627cce73',1,'tempest-tempest-created-share-snap-813794414','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-21 14:18:22.848756','2026-01-21 14:18:27.896979','2026-01-21 14:18:27.896497','325147df-76fa-4b90-9267-80d02dee5e0b','325147df-76fa-4b90-9267-80d02dee5e0b','4a2fe10fc9e348b7882f646ffc46378a','3cc89d84bffa401eab10c32a2f4b29d2','cae1b4e3-e1c6-4069-8095-973e2efe7b2e',1,'tempest-tempest-created-share-snap-1993236573','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-21 14:11:25.879508','2026-01-21 14:12:03.240659','2026-01-21 14:12:03.239930','56d6dc8f-03ac-4a2a-b985-23defb122518','56d6dc8f-03ac-4a2a-b985-23defb122518','9f6fd3bf04e94f2d8e668d8e93cb0afa','81d0568612894d6da94e01a77bfde64f','036723cc-3463-4bf3-a330-5b38b8f58ab6',1,'tempest-tempest-created-share-snap-303222180','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-21 14:21:16.309008','2026-01-21 14:22:56.022925','2026-01-21 14:22:56.022253','717877ed-ee59-4b6f-a8b8-a5e824a0e143','717877ed-ee59-4b6f-a8b8-a5e824a0e143','67dae406f3fa410bac4003400c38ab9e','41d4aecafc20406482129223e7dd4624','70bc77af-7e50-4669-ba31-537c6a183e1f',1,'tempest-tempest-snapshot-name-2145657637','tempest-tempest-snapshot-description-39171773',1,'CEPHFS'),('2026-01-21 14:19:26.975811','2026-01-21 14:19:33.258859','2026-01-21 14:19:33.258428','737b967c-2386-438d-aa9d-7e9a039e9aac','737b967c-2386-438d-aa9d-7e9a039e9aac','51daa32984f24d90b50a4cba851c93da','3efc5d38bf75484d9e4b2aed22003264','fa3c3ca4-ee78-4359-90c1-d7c6060a822d',1,'tempest-tempest-created-share-snap-1809478409','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-21 14:14:13.904525','2026-01-21 14:14:18.878326','2026-01-21 14:14:18.877857','7e50f506-28fa-4be1-8389-acdae8ac8ba3','7e50f506-28fa-4be1-8389-acdae8ac8ba3','0f49b0d1ba944c46946a092657f6b0f2','d8fea3bdb3ee4c03a1197b6e46ed71bc','d05f4623-92be-4e54-b528-ddbb8752adb2',1,'tempest-tempest-created-share-snap-2098116023','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-21 14:11:39.782337','2026-01-21 14:11:45.310230','2026-01-21 14:11:45.309545','97526c93-fc84-45f0-b580-04d89d51b5a7','97526c93-fc84-45f0-b580-04d89d51b5a7','9f6fd3bf04e94f2d8e668d8e93cb0afa','81d0568612894d6da94e01a77bfde64f','036723cc-3463-4bf3-a330-5b38b8f58ab6',1,'tempest-tempest-created-share-snap-331540289','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-21 14:18:54.028495','2026-01-21 14:18:56.139040','2026-01-21 14:18:56.138049','a8a4303d-8f0c-4d7c-83ea-8406b6d6fcc5','a8a4303d-8f0c-4d7c-83ea-8406b6d6fcc5','51daa32984f24d90b50a4cba851c93da','3efc5d38bf75484d9e4b2aed22003264','fa3c3ca4-ee78-4359-90c1-d7c6060a822d',1,'tempest-tempest-created-share-snap-1027559017','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-21 14:23:40.638682','2026-01-21 14:23:48.066048','2026-01-21 14:23:48.065664','a974555c-2f99-4804-bf49-5a8570c58762','a974555c-2f99-4804-bf49-5a8570c58762','40585f18d2e84161b8eca432bf37306f','18bcd7a466594b3abec112774943eca1','b0c80a60-09de-4bf8-8210-d9e7065bb4bd',1,'tempest-tempest-new-name-for-snapshot-261222457','tempest-tempest-new-description-for-snapshot-156653932',1,'CEPHFS'),('2026-01-21 14:11:20.416664','2026-01-21 14:12:08.385739','2026-01-21 14:12:08.385292','c5e71a6b-b6f4-4c59-b979-36f333691be0','c5e71a6b-b6f4-4c59-b979-36f333691be0','9f6fd3bf04e94f2d8e668d8e93cb0afa','81d0568612894d6da94e01a77bfde64f','036723cc-3463-4bf3-a330-5b38b8f58ab6',1,'tempest-tempest-created-share-snap-526709684','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-21 14:13:46.181914','2026-01-21 14:13:51.858812','2026-01-21 14:13:51.858398','c7c0cfbe-1a2d-4759-861e-1f5bef8b3de7','c7c0cfbe-1a2d-4759-861e-1f5bef8b3de7','54bd2d99c737409a8cdb47d0ef61c0af','bf58a5c191654263a44f73287e2a242e','f7f2a070-b60a-4b51-878d-5e40e7a13a72',1,'tempest-tempest-created-share-snap-2105551422','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-21 14:16:23.336080','2026-01-21 14:16:27.358807','2026-01-21 14:16:27.358367','cd26f1f2-bc6e-4358-affb-44dc2065fabf','cd26f1f2-bc6e-4358-affb-44dc2065fabf','9a2f0c528668499db7c5fb089f64e301','12f72ef945cc4adbb18b25d146f29e19','5386cb7d-3729-4e52-b4c5-42215607272e',1,'tempest-tempest-created-share-snap-2034689099','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-21 14:11:38.163375','2026-01-21 14:11:54.810186','2026-01-21 14:11:54.809690','d00da2a0-c417-42b5-bf93-02a64cbb16fe','d00da2a0-c417-42b5-bf93-02a64cbb16fe','9f6fd3bf04e94f2d8e668d8e93cb0afa','81d0568612894d6da94e01a77bfde64f','036723cc-3463-4bf3-a330-5b38b8f58ab6',1,'tempest-tempest-created-share-snap-100508419','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-21 14:19:16.485446','2026-01-21 14:19:21.879430','2026-01-21 14:19:21.879033','d0adc3df-76d3-4b70-bbe5-e57bff1140d1','d0adc3df-76d3-4b70-bbe5-e57bff1140d1','51daa32984f24d90b50a4cba851c93da','3efc5d38bf75484d9e4b2aed22003264','fa3c3ca4-ee78-4359-90c1-d7c6060a822d',1,'tempest-tempest-created-share-snap-462835595','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-21 14:24:44.018473','2026-01-21 14:24:50.508398','2026-01-21 14:24:50.507729','d9839651-f469-4415-89ae-cc62bff4e10f','d9839651-f469-4415-89ae-cc62bff4e10f','37b3bbc0092f402c82354dc1111facd4','a4f094a58f4542e2ab299637736993f9','ba38a422-131c-4c1e-8d0d-119a6f068d6a',1,'tempest-tempest-created-share-snap-1979262118','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-21 14:12:49.135030','2026-01-21 14:12:55.164068','2026-01-21 14:12:55.163358','e3be0d8d-321f-4f19-926e-84f856a6aa95','e3be0d8d-321f-4f19-926e-84f856a6aa95','296b3ba1092e47d48708162556c13492','8f23a9ff8e6249a7b232ba280b7bee1d','f3049aa0-1e31-4c57-bea3-c4cb3a5c1ba7',1,'tempest-tempest-created-share-snap-196782747','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-21 14:18:53.519281','2026-01-21 14:19:41.162788','2026-01-21 14:19:41.162248','e9dfc6f5-6817-4818-8b7a-6638ecfd5d54','e9dfc6f5-6817-4818-8b7a-6638ecfd5d54','51daa32984f24d90b50a4cba851c93da','3efc5d38bf75484d9e4b2aed22003264','fa3c3ca4-ee78-4359-90c1-d7c6060a822d',1,'tempest-tempest-snapshot-name-767757025','tempest-tempest-snapshot-description-66041263',1,'CEPHFS'),('2026-01-21 14:17:38.157738','2026-01-21 14:18:32.496506','2026-01-21 14:18:32.495871','ed4d40c5-f4bd-45ce-9692-e4bc79bb0372','ed4d40c5-f4bd-45ce-9692-e4bc79bb0372','3f155a642cbe41c5a9ffda4ad895b42a','42d0f9e7ca75499fafa3885d62f2fa91','684e0b48-a2b0-4730-acfb-d81d371a3a68',1,'tempest-tempest-snapshot-name-109784422','tempest-tempest-snapshot-description-599129273',1,'CEPHFS'),('2026-01-21 14:11:33.187454','2026-01-21 14:11:59.165516','2026-01-21 14:11:59.164893','ef40f7be-1cf7-4119-b7a9-71eb5b9dc8ce','ef40f7be-1cf7-4119-b7a9-71eb5b9dc8ce','9f6fd3bf04e94f2d8e668d8e93cb0afa','81d0568612894d6da94e01a77bfde64f','036723cc-3463-4bf3-a330-5b38b8f58ab6',1,'tempest-tempest-created-share-snap-960575394','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-21 14:13:42.176272','2026-01-21 14:13:55.104974','2026-01-21 14:13:55.104524','f1069ca7-a7f5-4b7d-93eb-79908004053c','f1069ca7-a7f5-4b7d-93eb-79908004053c','54bd2d99c737409a8cdb47d0ef61c0af','bf58a5c191654263a44f73287e2a242e','f7f2a070-b60a-4b51-878d-5e40e7a13a72',1,'tempest-tempest-created-share-snap-481598901','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-21 14:16:51.946884','2026-01-21 14:17:13.171472','2026-01-21 14:17:13.170844','fb763622-636c-421d-a618-54f14cb70a37','fb763622-636c-421d-a618-54f14cb70a37','9a2f0c528668499db7c5fb089f64e301','12f72ef945cc4adbb18b25d146f29e19','7c0e94b3-fc54-45fc-a321-25827669641d',1,'tempest-tempest-created-share-snap-1319346975','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-21 14:18:59.766387','2026-01-21 14:19:05.722079','2026-01-21 14:19:05.721657','fda77d42-2af2-4751-8381-d4861d82e3b5','fda77d42-2af2-4751-8381-d4861d82e3b5','51daa32984f24d90b50a4cba851c93da','3efc5d38bf75484d9e4b2aed22003264','fa3c3ca4-ee78-4359-90c1-d7c6060a822d',1,'tempest-tempest-created-share-snap-1622400652','Tempest\'s snapshot',1,'CEPHFS'),('2026-01-21 14:19:09.106554','2026-01-21 14:19:13.222742','2026-01-21 14:19:13.222228','fe9bc1b3-d5c9-4565-8fc7-bafb91560e19','fe9bc1b3-d5c9-4565-8fc7-bafb91560e19','51daa32984f24d90b50a4cba851c93da','3efc5d38bf75484d9e4b2aed22003264','fa3c3ca4-ee78-4359-90c1-d7c6060a822d',1,'tempest-tempest-created-share-snap-843226846','Tempest\'s snapshot',1,'CEPHFS');
/*!40000 ALTER TABLE `share_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_type_extra_specs`
--

DROP TABLE IF EXISTS `share_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_type_extra_specs` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `share_type_id` varchar(36) NOT NULL,
  `spec_key` varchar(255) DEFAULT NULL,
  `spec_value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `st_id_fk` (`share_type_id`),
  CONSTRAINT `st_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=293 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_type_extra_specs`
--

LOCK TABLES `share_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `share_type_extra_specs` DISABLE KEYS */;
INSERT INTO `share_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `share_type_id`, `spec_key`, `spec_value`) VALUES ('2026-01-21 14:06:15.610063',NULL,NULL,0,1,'b162a983-fd22-416d-b3c5-874636612a2e','driver_handles_share_servers','False'),('2026-01-21 14:06:19.776675',NULL,NULL,0,2,'b162a983-fd22-416d-b3c5-874636612a2e','snapshot_support','True'),('2026-01-21 14:06:19.780325',NULL,NULL,0,3,'b162a983-fd22-416d-b3c5-874636612a2e','create_share_from_snapshot_support','True'),('2026-01-21 14:10:20.345153',NULL,'2026-01-21 14:12:15.376645',4,4,'9bfc08e1-2434-47e7-8b27-5587894f67ed','driver_handles_share_servers','False'),('2026-01-21 14:10:20.348162',NULL,'2026-01-21 14:12:15.376645',5,5,'9bfc08e1-2434-47e7-8b27-5587894f67ed','snapshot_support','True'),('2026-01-21 14:10:22.551128',NULL,'2026-01-21 14:10:36.233839',6,6,'730c7c03-7e1d-487b-906f-6935715d2b12','driver_handles_share_servers','False'),('2026-01-21 14:10:23.167419',NULL,'2026-01-21 14:10:34.673774',7,7,'22f02301-b01e-4d8f-b557-3558b6a3b9a3','driver_handles_share_servers','False'),('2026-01-21 14:11:01.182106',NULL,'2026-01-21 14:12:03.058886',8,8,'de4f8dd5-59c7-4043-a6d2-b1a1fa120cc6','driver_handles_share_servers','False'),('2026-01-21 14:11:01.185628',NULL,'2026-01-21 14:12:03.058886',9,9,'de4f8dd5-59c7-4043-a6d2-b1a1fa120cc6','snapshot_support','True'),('2026-01-21 14:11:01.187633',NULL,'2026-01-21 14:12:03.058886',10,10,'de4f8dd5-59c7-4043-a6d2-b1a1fa120cc6','create_share_from_snapshot_support','True'),('2026-01-21 14:11:01.605451',NULL,'2026-01-21 14:12:02.463313',11,11,'08dc12ec-0496-4207-ab26-687dc1000122','driver_handles_share_servers','False'),('2026-01-21 14:11:01.699061',NULL,'2026-01-21 14:12:02.001436',12,12,'3055f25f-99ca-47e1-85fd-3d023797e4ab','driver_handles_share_servers','False'),('2026-01-21 14:11:08.322073',NULL,'2026-01-21 14:11:10.013864',13,13,'4fd1707a-48c4-4e0f-b197-978fd868c037','driver_handles_share_servers','False'),('2026-01-21 14:11:09.076305',NULL,'2026-01-21 14:11:09.315840',14,14,'6ef617ea-74fb-480b-8598-cb5a61cefa41','driver_handles_share_servers','False'),('2026-01-21 14:11:09.529347',NULL,'2026-01-21 14:11:09.834009',15,15,'3a8f9ed8-9c5f-48ce-bc78-8e37ac8f057a','driver_handles_share_servers','False'),('2026-01-21 14:11:09.741783',NULL,'2026-01-21 14:11:19.772799',16,16,'0702aa99-d0f6-4f0d-87b0-59e808fb4acc','driver_handles_share_servers','False'),('2026-01-21 14:11:10.102902',NULL,'2026-01-21 14:11:19.463913',17,17,'8df9198b-0103-44d3-a6df-cde5afc23c93','driver_handles_share_servers','False'),('2026-01-21 14:11:13.419457',NULL,'2026-01-21 14:11:19.128541',18,18,'8c635de3-9579-4fc9-bf8e-9507d93a21e2','driver_handles_share_servers','False'),('2026-01-21 14:11:13.903424',NULL,'2026-01-21 14:11:18.949870',19,19,'297b2a0a-ff05-4991-a30a-a02068f8eac9','driver_handles_share_servers','False'),('2026-01-21 14:11:14.747280',NULL,'2026-01-21 14:11:18.682257',20,20,'5f3109e8-43e4-46c3-9ec1-eda96338311b','driver_handles_share_servers','False'),('2026-01-21 14:11:14.749042',NULL,'2026-01-21 14:11:18.682257',21,21,'5f3109e8-43e4-46c3-9ec1-eda96338311b','share_backend_name','tempest-fake_name-2118981742'),('2026-01-21 14:11:15.975305',NULL,'2026-01-21 14:11:18.441500',22,22,'8eef7f78-8896-4816-bbb1-4faa510ec52f','driver_handles_share_servers','False'),('2026-01-21 14:11:15.975770',NULL,'2026-01-21 14:11:18.441500',23,23,'8eef7f78-8896-4816-bbb1-4faa510ec52f','share_backend_name','tempest-fake_name-537039621'),('2026-01-21 14:11:16.198179',NULL,'2026-01-21 14:11:17.665737',24,24,'d0a806f2-cacc-40f3-8260-02bf317137a5','driver_handles_share_servers','False'),('2026-01-21 14:11:16.198646',NULL,'2026-01-21 14:11:17.665737',25,25,'d0a806f2-cacc-40f3-8260-02bf317137a5','share_backend_name','tempest-fake_name-224000034'),('2026-01-21 14:11:16.573747',NULL,'2026-01-21 14:11:17.367983',26,26,'e972fe9d-ca2e-40da-aba1-cd2b5c6f5035','driver_handles_share_servers','False'),('2026-01-21 14:11:16.574165',NULL,'2026-01-21 14:11:17.367983',27,27,'e972fe9d-ca2e-40da-aba1-cd2b5c6f5035','share_backend_name','tempest-fake_name-212362038'),('2026-01-21 14:11:20.863758',NULL,'2026-01-21 14:12:12.163937',28,28,'c5bac032-cc46-4150-aad5-9325071c0935','driver_handles_share_servers','False'),('2026-01-21 14:11:21.509566',NULL,'2026-01-21 14:12:01.712692',29,29,'789ac2c9-711f-4a07-a8a8-e5a726b61aec','driver_handles_share_servers','False'),('2026-01-21 14:11:22.576949',NULL,'2026-01-21 14:12:01.479305',30,30,'5081aafe-5bcd-4868-82bc-92284af11fa0','driver_handles_share_servers','False'),('2026-01-21 14:11:25.389742',NULL,'2026-01-21 14:12:01.103012',31,31,'283e163d-39d4-4850-bbf9-a7e3eb6d8974','driver_handles_share_servers','False'),('2026-01-21 14:11:25.860726',NULL,'2026-01-21 14:12:07.551044',32,32,'29cdbce9-1270-470b-8e9e-290edf433bce','driver_handles_share_servers','False'),('2026-01-21 14:11:25.861477',NULL,'2026-01-21 14:12:07.551044',33,33,'29cdbce9-1270-470b-8e9e-290edf433bce','snapshot_support','True'),('2026-01-21 14:11:35.287838',NULL,'2026-01-21 14:12:00.481301',34,34,'46b5cf9b-25b2-40af-8cff-d939d6ed0251','driver_handles_share_servers','False'),('2026-01-21 14:11:37.069282',NULL,'2026-01-21 14:11:59.330229',35,35,'fdc63508-dc4f-4ae6-a43b-cdc0f9e32f3c','driver_handles_share_servers','False'),('2026-01-21 14:11:37.277747',NULL,'2026-01-21 14:12:00.050295',36,36,'20f5b5fd-9c31-4b20-8536-8a9964fff283','driver_handles_share_servers','False'),('2026-01-21 14:11:37.290587',NULL,'2026-01-21 14:11:59.107642',37,37,'c48c3211-571d-48cc-adeb-a0cae69c52d7','driver_handles_share_servers','False'),('2026-01-21 14:11:38.103975',NULL,'2026-01-21 14:11:58.285122',38,38,'e3981754-2bfe-4dbc-a179-acf2f02c6ece','driver_handles_share_servers','False'),('2026-01-21 14:11:39.488509',NULL,'2026-01-21 14:11:57.796391',39,39,'563a2127-2f8d-45e9-86b1-3f1b5b1bbf10','driver_handles_share_servers','False'),('2026-01-21 14:11:39.489064',NULL,'2026-01-21 14:11:59.705950',40,40,'b42fe5e7-36a4-4949-a87c-fc57879172ce','driver_handles_share_servers','False'),('2026-01-21 14:11:39.919206',NULL,'2026-01-21 14:11:57.381339',41,41,'d2a6f39a-4c8f-4196-8348-a04525553d5f','driver_handles_share_servers','False'),('2026-01-21 14:11:40.357783',NULL,'2026-01-21 14:11:56.874681',42,42,'6766bec6-bf02-4cce-8e69-bfcaa405c120','driver_handles_share_servers','False'),('2026-01-21 14:11:40.767088',NULL,'2026-01-21 14:11:59.320463',43,43,'17cc8bc7-2a1d-4d75-abb8-7b834d3b229d','driver_handles_share_servers','False'),('2026-01-21 14:11:43.346493',NULL,'2026-01-21 14:11:56.308071',44,44,'e03cfafd-6d82-4075-8e97-052efd572982','driver_handles_share_servers','False'),('2026-01-21 14:11:43.589376',NULL,'2026-01-21 14:11:55.859684',45,45,'2d1d6de3-0dbc-47ed-8762-ae98d5903b16','driver_handles_share_servers','False'),('2026-01-21 14:11:43.969524',NULL,'2026-01-21 14:11:54.313011',46,46,'479ba5fa-bee8-4bad-b073-700b5c151289','driver_handles_share_servers','False'),('2026-01-21 14:11:44.496462',NULL,'2026-01-21 14:11:53.482267',47,47,'5d544b7d-6d61-4588-8421-9a74b9f58b6c','driver_handles_share_servers','False'),('2026-01-21 14:11:45.599442',NULL,'2026-01-21 14:11:49.747450',48,48,'b61f136f-352c-46d4-b7cd-eae096e4ac0c','driver_handles_share_servers','False'),('2026-01-21 14:11:47.342866',NULL,'2026-01-21 14:11:47.955723',49,49,'64cf5b56-724a-43be-bc52-e3d17596c75e','driver_handles_share_servers','False'),('2026-01-21 14:12:15.621631',NULL,'2026-01-21 14:12:23.598534',50,50,'5a374d5e-d0ed-4003-9ec7-10084960d609','driver_handles_share_servers','False'),('2026-01-21 14:12:23.599430',NULL,'2026-01-21 14:12:39.955422',51,51,'291913af-f721-4784-852d-18a81c2dbf2d','driver_handles_share_servers','False'),('2026-01-21 14:12:39.962192',NULL,'2026-01-21 14:13:02.298838',52,52,'59554df7-024a-45b7-9735-27031cc895f1','driver_handles_share_servers','False'),('2026-01-21 14:12:39.962703',NULL,'2026-01-21 14:13:02.298838',53,53,'59554df7-024a-45b7-9735-27031cc895f1','snapshot_support','True'),('2026-01-21 14:12:49.563859',NULL,'2026-01-21 14:13:15.705399',54,54,'9381faef-bf67-41dd-aaaa-a9be7a2bcc68','driver_handles_share_servers','False'),('2026-01-21 14:12:49.565620',NULL,'2026-01-21 14:13:15.705399',55,55,'9381faef-bf67-41dd-aaaa-a9be7a2bcc68','storage_protocol','cephfs'),('2026-01-21 14:12:52.757915',NULL,'2026-01-21 14:13:07.715745',56,56,'5db47c29-acbc-40ec-8e55-f1ce76935da6','driver_handles_share_servers','False'),('2026-01-21 14:12:52.758409',NULL,'2026-01-21 14:13:07.715745',57,57,'5db47c29-acbc-40ec-8e55-f1ce76935da6','key','value'),('2026-01-21 14:12:53.109040',NULL,'2026-01-21 14:13:07.522619',58,58,'4a9b67a4-7409-4001-be69-bf77cf76b216','driver_handles_share_servers','False'),('2026-01-21 14:12:53.109764',NULL,'2026-01-21 14:13:07.522619',59,59,'4a9b67a4-7409-4001-be69-bf77cf76b216','key','value'),('2026-01-21 14:12:53.334397',NULL,'2026-01-21 14:13:07.365694',60,60,'35f80e6b-cd13-40a3-bbe5-46fcfd62ca5a','driver_handles_share_servers','False'),('2026-01-21 14:12:53.335084',NULL,'2026-01-21 14:13:07.365694',61,61,'35f80e6b-cd13-40a3-bbe5-46fcfd62ca5a','key','value'),('2026-01-21 14:12:53.890550',NULL,'2026-01-21 14:13:14.469340',62,62,'d412b829-d477-46b7-a489-e30be89cfea6','driver_handles_share_servers','False'),('2026-01-21 14:12:53.891574',NULL,'2026-01-21 14:13:14.469340',63,63,'d412b829-d477-46b7-a489-e30be89cfea6','key','value'),('2026-01-21 14:12:53.933681',NULL,'2026-01-21 14:13:07.223317',64,64,'11f5f65a-72f7-4a81-ab60-1400cdb3601b','driver_handles_share_servers','False'),('2026-01-21 14:12:53.934525',NULL,'2026-01-21 14:13:07.223317',65,65,'11f5f65a-72f7-4a81-ab60-1400cdb3601b','key','value'),('2026-01-21 14:12:54.568414',NULL,'2026-01-21 14:13:06.967237',66,66,'ed730878-bd51-471b-bdd1-1f9be5254bb2','driver_handles_share_servers','False'),('2026-01-21 14:12:54.568934',NULL,'2026-01-21 14:13:06.967237',67,67,'ed730878-bd51-471b-bdd1-1f9be5254bb2','key','value'),('2026-01-21 14:12:54.955281',NULL,'2026-01-21 14:13:06.709749',68,68,'cf065933-60bb-4ef0-afcb-2b7d4daffd3f','driver_handles_share_servers','False'),('2026-01-21 14:12:54.955950',NULL,'2026-01-21 14:13:06.709749',69,69,'cf065933-60bb-4ef0-afcb-2b7d4daffd3f','key','value'),('2026-01-21 14:12:55.167337',NULL,'2026-01-21 14:13:06.511407',70,70,'4d8e8a1c-ea7f-4ed7-bc13-dc40c78ad424','driver_handles_share_servers','False'),('2026-01-21 14:12:55.169176',NULL,'2026-01-21 14:13:06.511407',71,71,'4d8e8a1c-ea7f-4ed7-bc13-dc40c78ad424','key','value'),('2026-01-21 14:12:55.315586',NULL,'2026-01-21 14:12:55.412805',72,72,'4cee2d84-06d7-4693-b766-982d7ff81504','driver_handles_share_servers','False'),('2026-01-21 14:12:55.334183',NULL,'2026-01-21 14:13:06.235564',73,73,'d81f794c-d08c-45dc-bbc9-511ee7439cc1','driver_handles_share_servers','False'),('2026-01-21 14:12:55.334644',NULL,'2026-01-21 14:13:06.235564',74,74,'d81f794c-d08c-45dc-bbc9-511ee7439cc1','key','value'),('2026-01-21 14:12:55.586632',NULL,'2026-01-21 14:13:06.087521',75,75,'7099eca0-d9eb-4a38-8b8f-e1e906bb4b00','driver_handles_share_servers','False'),('2026-01-21 14:12:55.587071',NULL,'2026-01-21 14:13:06.087521',76,76,'7099eca0-d9eb-4a38-8b8f-e1e906bb4b00','key','value'),('2026-01-21 14:12:55.738568',NULL,'2026-01-21 14:13:05.815035',77,77,'fee23a04-44b6-4b72-95ef-bed37f2d1630','driver_handles_share_servers','False'),('2026-01-21 14:12:55.740551',NULL,'2026-01-21 14:13:05.815035',78,78,'fee23a04-44b6-4b72-95ef-bed37f2d1630','key','value'),('2026-01-21 14:12:55.834821',NULL,'2026-01-21 14:13:14.235537',79,79,'08a48950-513b-45dc-9540-6e080e46f372','driver_handles_share_servers','False'),('2026-01-21 14:12:55.835310',NULL,'2026-01-21 14:13:14.235537',80,80,'08a48950-513b-45dc-9540-6e080e46f372','key','value'),('2026-01-21 14:12:55.835694',NULL,'2026-01-21 14:13:14.235537',81,81,'08a48950-513b-45dc-9540-6e080e46f372','snapshot_support','True'),('2026-01-21 14:12:55.927340',NULL,'2026-01-21 14:13:05.532634',82,82,'768bc3bf-35e4-420e-869a-bd64ab319b31','driver_handles_share_servers','False'),('2026-01-21 14:12:55.927980',NULL,'2026-01-21 14:13:05.532634',83,83,'768bc3bf-35e4-420e-869a-bd64ab319b31','key','value'),('2026-01-21 14:12:56.371508',NULL,'2026-01-21 14:13:13.850672',84,84,'43ca4f08-53cb-4ba4-8916-c9865280e268','driver_handles_share_servers','False'),('2026-01-21 14:12:56.372359',NULL,'2026-01-21 14:13:13.850672',85,85,'43ca4f08-53cb-4ba4-8916-c9865280e268','key','value'),('2026-01-21 14:12:56.372785',NULL,'2026-01-21 14:13:13.850672',86,86,'43ca4f08-53cb-4ba4-8916-c9865280e268','snapshot_support','True'),('2026-01-21 14:12:56.623800',NULL,'2026-01-21 14:13:05.189921',87,87,'a87bc269-1838-4f29-8277-1729483d3860','driver_handles_share_servers','False'),('2026-01-21 14:12:56.624343',NULL,'2026-01-21 14:13:05.189921',88,88,'a87bc269-1838-4f29-8277-1729483d3860','key','value'),('2026-01-21 14:12:56.669382',NULL,'2026-01-21 14:13:13.681810',89,89,'9f296d55-0304-4830-9fa5-6211637fe75f','driver_handles_share_servers','False'),('2026-01-21 14:12:56.671373',NULL,'2026-01-21 14:13:13.681810',90,90,'9f296d55-0304-4830-9fa5-6211637fe75f','key','value'),('2026-01-21 14:12:56.672621',NULL,'2026-01-21 14:13:13.681810',91,91,'9f296d55-0304-4830-9fa5-6211637fe75f','snapshot_support','True'),('2026-01-21 14:12:56.873012',NULL,'2026-01-21 14:13:13.397489',92,92,'3adc6194-84b7-4be6-a311-d4308aac9063','driver_handles_share_servers','False'),('2026-01-21 14:12:56.873601',NULL,'2026-01-21 14:13:13.397489',93,93,'3adc6194-84b7-4be6-a311-d4308aac9063','key','value'),('2026-01-21 14:12:56.883514',NULL,'2026-01-21 14:12:57.486355',94,94,'b655505b-7540-4117-870a-bc0df7ff0060','driver_handles_share_servers','False'),('2026-01-21 14:12:57.016077',NULL,'2026-01-21 14:13:05.012139',95,95,'3d5b0370-a926-45f6-b91e-366a806d0d80','driver_handles_share_servers','False'),('2026-01-21 14:12:57.016429',NULL,'2026-01-21 14:13:05.012139',96,96,'3d5b0370-a926-45f6-b91e-366a806d0d80','key','value'),('2026-01-21 14:12:57.016589',NULL,'2026-01-21 14:12:57.486355',97,97,'b655505b-7540-4117-870a-bc0df7ff0060','key1','value1'),('2026-01-21 14:12:57.019746',NULL,'2026-01-21 14:12:57.486355',98,98,'b655505b-7540-4117-870a-bc0df7ff0060','key2','value2'),('2026-01-21 14:12:57.062043',NULL,'2026-01-21 14:13:13.227514',99,99,'0ff89cde-abc7-4313-9251-cc82bbb5270b','driver_handles_share_servers','False'),('2026-01-21 14:12:57.062478',NULL,'2026-01-21 14:13:13.227514',100,100,'0ff89cde-abc7-4313-9251-cc82bbb5270b','key','value'),('2026-01-21 14:12:57.343525',NULL,'2026-01-21 14:13:04.858512',101,101,'49431ee2-5502-40e8-ad0c-b7a171ad66b3','driver_handles_share_servers','False'),('2026-01-21 14:12:57.344073',NULL,'2026-01-21 14:13:04.858512',102,102,'49431ee2-5502-40e8-ad0c-b7a171ad66b3','key','value'),('2026-01-21 14:12:57.374228',NULL,'2026-01-21 14:13:12.955223',103,103,'c900e2f6-56da-45a0-a8ca-77bf28c9e506','driver_handles_share_servers','False'),('2026-01-21 14:12:57.374720',NULL,'2026-01-21 14:13:12.955223',104,104,'c900e2f6-56da-45a0-a8ca-77bf28c9e506','snapshot_support','True'),('2026-01-21 14:12:57.666647',NULL,'2026-01-21 14:13:04.579440',105,105,'fdc6db57-5ff6-455a-a2ab-20fbd091b679','driver_handles_share_servers','False'),('2026-01-21 14:12:57.667223',NULL,'2026-01-21 14:13:04.579440',106,106,'fdc6db57-5ff6-455a-a2ab-20fbd091b679','key','value'),('2026-01-21 14:12:57.713987',NULL,'2026-01-21 14:13:12.471572',107,107,'21b5580a-f59d-413c-9408-1349c9b22246','driver_handles_share_servers','False'),('2026-01-21 14:12:57.714501',NULL,'2026-01-21 14:13:12.471572',108,108,'21b5580a-f59d-413c-9408-1349c9b22246','snapshot_support','True'),('2026-01-21 14:12:58.063361',NULL,'2026-01-21 14:13:04.381470',109,109,'64248035-9de8-48ff-a96d-82c098528eec','driver_handles_share_servers','False'),('2026-01-21 14:12:58.063865',NULL,'2026-01-21 14:13:04.381470',110,110,'64248035-9de8-48ff-a96d-82c098528eec','key','value'),('2026-01-21 14:12:58.134269',NULL,'2026-01-21 14:13:12.274830',111,111,'3823cbda-4634-482b-87a3-52aaea9b923a','driver_handles_share_servers','False'),('2026-01-21 14:12:58.134716',NULL,'2026-01-21 14:13:12.274830',112,112,'3823cbda-4634-482b-87a3-52aaea9b923a','snapshot_support','True'),('2026-01-21 14:12:58.567741',NULL,'2026-01-21 14:13:03.750859',113,113,'576dc762-759a-4e85-aa38-3f7c8e73b9f7','driver_handles_share_servers','False'),('2026-01-21 14:12:58.568307',NULL,'2026-01-21 14:13:03.750859',114,114,'576dc762-759a-4e85-aa38-3f7c8e73b9f7','key','value'),('2026-01-21 14:12:58.591270',NULL,'2026-01-21 14:13:11.937440',115,115,'9c5c6fe8-d3d4-4ac9-a539-5ec180819cbb','driver_handles_share_servers','False'),('2026-01-21 14:12:58.910013',NULL,'2026-01-21 14:13:11.568638',116,116,'a410e5a9-ea68-47cc-be7a-d472ddbe0aa7','driver_handles_share_servers','False'),('2026-01-21 14:12:58.955415',NULL,'2026-01-21 14:13:03.233022',117,117,'818fd452-3d60-48fb-972b-85580aa222a9','driver_handles_share_servers','False'),('2026-01-21 14:12:58.955816',NULL,'2026-01-21 14:13:03.233022',118,118,'818fd452-3d60-48fb-972b-85580aa222a9','key','value'),('2026-01-21 14:12:59.978981',NULL,'2026-01-21 14:13:08.461008',119,119,'7d3cb003-36db-4745-9df4-d4f1569e4c05','driver_handles_share_servers','False'),('2026-01-21 14:13:00.270488',NULL,'2026-01-21 14:13:02.897312',120,120,'3830166d-da4c-4040-9a83-bbe130b0da04','driver_handles_share_servers','False'),('2026-01-21 14:13:00.270971',NULL,'2026-01-21 14:13:02.897312',121,121,'3830166d-da4c-4040-9a83-bbe130b0da04','key','value'),('2026-01-21 14:13:00.421954',NULL,'2026-01-21 14:13:08.051081',122,122,'06ee2e67-5fc3-4e01-b2e6-24967778d2e6','driver_handles_share_servers','False'),('2026-01-21 14:13:00.892212',NULL,'2026-01-21 14:13:02.518298',123,123,'372188f9-9263-49f2-b40d-0e327e3d9b3b','driver_handles_share_servers','False'),('2026-01-21 14:13:00.892737',NULL,'2026-01-21 14:13:02.518298',124,124,'372188f9-9263-49f2-b40d-0e327e3d9b3b','key','value'),('2026-01-21 14:13:00.945763',NULL,'2026-01-21 14:13:07.749398',125,125,'85182014-309a-4002-b3f5-bc452a862b65','driver_handles_share_servers','False'),('2026-01-21 14:13:01.240908',NULL,'2026-01-21 14:13:02.379966',126,126,'745427b5-ef77-4a9c-a0f0-14456b9f1b7e','driver_handles_share_servers','False'),('2026-01-21 14:13:01.241479',NULL,'2026-01-21 14:13:02.379966',127,127,'745427b5-ef77-4a9c-a0f0-14456b9f1b7e','key','value'),('2026-01-21 14:13:01.352793',NULL,'2026-01-21 14:13:07.560769',128,128,'6def9bdd-be47-4d08-a5e2-ecc064c736ad','driver_handles_share_servers','False'),('2026-01-21 14:13:01.355610',NULL,'2026-01-21 14:13:07.560769',129,129,'6def9bdd-be47-4d08-a5e2-ecc064c736ad','key','value'),('2026-01-21 14:13:01.519382',NULL,'2026-01-21 14:13:07.401155',130,130,'5a67966c-f574-4600-aba2-a15061ec309b','driver_handles_share_servers','False'),('2026-01-21 14:13:01.519761',NULL,'2026-01-21 14:13:07.401155',131,131,'5a67966c-f574-4600-aba2-a15061ec309b','key','value'),('2026-01-21 14:13:01.658897',NULL,'2026-01-21 14:13:02.226388',132,132,'b486058c-98b6-4a76-a025-d9e66804a495','driver_handles_share_servers','False'),('2026-01-21 14:13:01.659371',NULL,'2026-01-21 14:13:02.226388',133,133,'b486058c-98b6-4a76-a025-d9e66804a495','key','value'),('2026-01-21 14:13:01.674388',NULL,'2026-01-21 14:13:07.261436',134,134,'e9be21a6-06c4-4646-9ebe-00b5664fe89d','driver_handles_share_servers','False'),('2026-01-21 14:13:01.674920',NULL,'2026-01-21 14:13:07.261436',135,135,'e9be21a6-06c4-4646-9ebe-00b5664fe89d','key','value'),('2026-01-21 14:13:01.840916',NULL,'2026-01-21 14:13:06.996967',136,136,'e0b7cd58-7e56-43b9-8d5d-0714aeba3923','driver_handles_share_servers','False'),('2026-01-21 14:13:01.841304',NULL,'2026-01-21 14:13:06.996967',137,137,'e0b7cd58-7e56-43b9-8d5d-0714aeba3923','key','value'),('2026-01-21 14:13:02.241391',NULL,'2026-01-21 14:13:06.742902',138,138,'7babed33-967f-4958-b1a5-0a8dcd909950','driver_handles_share_servers','False'),('2026-01-21 14:13:02.242064',NULL,'2026-01-21 14:13:06.742902',139,139,'7babed33-967f-4958-b1a5-0a8dcd909950','key','value'),('2026-01-21 14:13:02.400999',NULL,'2026-01-21 14:13:06.532379',140,140,'4b1f54da-0ea5-44c4-8b97-4c1a9e9fda0a','driver_handles_share_servers','False'),('2026-01-21 14:13:02.402454',NULL,'2026-01-21 14:13:06.532379',141,141,'4b1f54da-0ea5-44c4-8b97-4c1a9e9fda0a','key','value'),('2026-01-21 14:13:02.806512',NULL,'2026-01-21 14:13:06.362601',142,142,'683d7b00-2e48-4c37-adab-c0b5d4bb0b5a','driver_handles_share_servers','False'),('2026-01-21 14:13:02.806949',NULL,'2026-01-21 14:13:06.362601',143,143,'683d7b00-2e48-4c37-adab-c0b5d4bb0b5a','key','value'),('2026-01-21 14:13:03.473941',NULL,'2026-01-21 14:13:06.128736',144,144,'c49ea73f-3c43-480c-941a-313c35650c4a','driver_handles_share_servers','False'),('2026-01-21 14:13:03.474457',NULL,'2026-01-21 14:13:06.128736',145,145,'c49ea73f-3c43-480c-941a-313c35650c4a','key','value'),('2026-01-21 14:13:03.782478',NULL,'2026-01-21 14:13:05.912617',146,146,'82af13b1-6123-4330-bb82-5cf38fdac57f','driver_handles_share_servers','False'),('2026-01-21 14:13:03.783119',NULL,'2026-01-21 14:13:05.912617',147,147,'82af13b1-6123-4330-bb82-5cf38fdac57f','key','value'),('2026-01-21 14:13:04.396292',NULL,'2026-01-21 14:13:05.668331',148,148,'a60962cb-c43f-4698-aafa-443085e9d38f','driver_handles_share_servers','False'),('2026-01-21 14:13:04.396727',NULL,'2026-01-21 14:13:05.668331',149,149,'a60962cb-c43f-4698-aafa-443085e9d38f','key','value'),('2026-01-21 14:13:04.641660',NULL,'2026-01-21 14:13:05.230945',150,150,'ca5317ec-f975-4b16-9412-1a835dd293fd','driver_handles_share_servers','False'),('2026-01-21 14:13:04.642319',NULL,'2026-01-21 14:13:05.230945',151,151,'ca5317ec-f975-4b16-9412-1a835dd293fd','key','value'),('2026-01-21 14:13:04.885211',NULL,'2026-01-21 14:13:05.045195',152,152,'e3c8823e-5eb9-4dae-a968-ccf2953e9e2f','driver_handles_share_servers','False'),('2026-01-21 14:13:04.885662',NULL,'2026-01-21 14:13:05.045195',153,153,'e3c8823e-5eb9-4dae-a968-ccf2953e9e2f','key','value'),('2026-01-21 14:13:06.979813',NULL,'2026-01-21 14:13:13.651506',154,154,'1ce52fbd-5775-4005-b564-079c46a8be68','driver_handles_share_servers','False'),('2026-01-21 14:13:06.980416',NULL,'2026-01-21 14:13:13.651506',155,155,'1ce52fbd-5775-4005-b564-079c46a8be68','key','value'),('2026-01-21 14:13:07.588021',NULL,'2026-01-21 14:13:13.391220',156,156,'935cd5fe-f41b-49cf-ad89-0aef2a9bcdc3','driver_handles_share_servers','False'),('2026-01-21 14:13:08.566339',NULL,'2026-01-21 14:13:13.245547',157,157,'966ab038-89e3-4448-aa6d-f60b379c13fd','driver_handles_share_servers','False'),('2026-01-21 14:13:08.567085',NULL,'2026-01-21 14:13:13.245547',158,158,'966ab038-89e3-4448-aa6d-f60b379c13fd','key','value'),('2026-01-21 14:13:11.789787',NULL,'2026-01-21 14:13:13.083566',159,159,'582c08e2-111a-4218-a6e7-f9b876bd9671','driver_handles_share_servers','False'),('2026-01-21 14:13:11.790346',NULL,'2026-01-21 14:13:13.083566',160,160,'582c08e2-111a-4218-a6e7-f9b876bd9671','key','value'),('2026-01-21 14:13:20.650361',NULL,'2026-01-21 14:14:25.193454',161,161,'d763adfd-4693-4b03-ad1c-6cfad5db99b3','driver_handles_share_servers','False'),('2026-01-21 14:13:20.651165',NULL,'2026-01-21 14:14:25.193454',162,162,'d763adfd-4693-4b03-ad1c-6cfad5db99b3','storage_protocol','cephfs'),('2026-01-21 14:13:20.651618',NULL,'2026-01-21 14:14:25.193454',163,163,'d763adfd-4693-4b03-ad1c-6cfad5db99b3','snapshot_support','True'),('2026-01-21 14:13:20.651983',NULL,'2026-01-21 14:14:25.193454',164,164,'d763adfd-4693-4b03-ad1c-6cfad5db99b3','create_share_from_snapshot_support','True'),('2026-01-21 14:13:34.618302',NULL,'2026-01-21 14:14:02.516353',165,165,'0b0ef60b-789a-4f97-ab23-aa852b1b2e11','driver_handles_share_servers','False'),('2026-01-21 14:13:34.619008',NULL,'2026-01-21 14:14:02.516353',166,166,'0b0ef60b-789a-4f97-ab23-aa852b1b2e11','vendor_name','foobar'),('2026-01-21 14:13:38.476875',NULL,'2026-01-21 14:14:01.752146',167,167,'7cec5100-da97-4c19-a6d2-711aa40fb4a4','driver_handles_share_servers','False'),('2026-01-21 14:13:38.477267',NULL,'2026-01-21 14:14:01.752146',168,168,'7cec5100-da97-4c19-a6d2-711aa40fb4a4','snapshot_support','True'),('2026-01-21 14:13:39.399623',NULL,'2026-01-21 14:14:02.188300',169,169,'9ca783c9-ecfe-469c-a4a8-d087ab0379ae','driver_handles_share_servers','False'),('2026-01-21 14:13:39.399992',NULL,'2026-01-21 14:14:02.188300',170,170,'9ca783c9-ecfe-469c-a4a8-d087ab0379ae','vendor_name','foobar'),('2026-01-21 14:13:41.382603',NULL,'2026-01-21 14:14:40.692658',171,171,'21dd7853-6f9b-4e9a-91b3-a47c3de6b980','driver_handles_share_servers','False'),('2026-01-21 14:13:45.492124',NULL,'2026-01-21 14:14:01.838669',172,172,'cdda8570-26be-4330-bd36-622a2eb10327','driver_handles_share_servers','False'),('2026-01-21 14:13:45.492542',NULL,'2026-01-21 14:14:01.838669',173,173,'cdda8570-26be-4330-bd36-622a2eb10327','vendor_name','foobar'),('2026-01-21 14:13:50.164301',NULL,'2026-01-21 14:14:01.650251',174,174,'78590156-25d2-468c-8633-1b5bd4532903','driver_handles_share_servers','False'),('2026-01-21 14:13:50.165009',NULL,'2026-01-21 14:14:01.650251',175,175,'78590156-25d2-468c-8633-1b5bd4532903','vendor_name','foobar'),('2026-01-21 14:13:55.225110',NULL,'2026-01-21 14:14:01.476320',176,176,'5afaec67-94c3-4b24-8db9-1b003291becd','driver_handles_share_servers','False'),('2026-01-21 14:13:55.226810',NULL,'2026-01-21 14:14:01.476320',177,177,'5afaec67-94c3-4b24-8db9-1b003291becd','vendor_name','foobar'),('2026-01-21 14:14:10.200731',NULL,'2026-01-21 14:14:25.218600',178,178,'7ac1d9c2-538b-4775-a2d5-4c70805fd54c','driver_handles_share_servers','False'),('2026-01-21 14:14:10.201263',NULL,'2026-01-21 14:14:25.218600',179,179,'7ac1d9c2-538b-4775-a2d5-4c70805fd54c','snapshot_support','True'),('2026-01-21 14:14:13.533803',NULL,'2026-01-21 14:14:42.369726',180,180,'d714b627-a89b-463b-804f-ebe84408a229','driver_handles_share_servers','False'),('2026-01-21 14:14:33.348712',NULL,'2026-01-21 14:14:37.695388',181,181,'6d2837a3-2f8e-45c2-9b30-084b458e7292','driver_handles_share_servers','False'),('2026-01-21 14:14:33.466128',NULL,'2026-01-21 14:14:33.600653',182,182,'6d2837a3-2f8e-45c2-9b30-084b458e7292','key1','value1'),('2026-01-21 14:14:33.474385',NULL,'2026-01-21 14:14:37.695388',183,183,'6d2837a3-2f8e-45c2-9b30-084b458e7292','key2','value2'),('2026-01-21 14:14:33.902042',NULL,'2026-01-21 14:14:37.506462',184,184,'8e884ac6-f10e-4f13-9c29-5343effb2738','driver_handles_share_servers','False'),('2026-01-21 14:14:33.987571',NULL,'2026-01-21 14:14:37.506462',185,185,'8e884ac6-f10e-4f13-9c29-5343effb2738','key1','value1'),('2026-01-21 14:14:33.991372',NULL,'2026-01-21 14:14:37.506462',186,186,'8e884ac6-f10e-4f13-9c29-5343effb2738','key2','value2'),('2026-01-21 14:14:34.100337',NULL,'2026-01-21 14:14:34.282372',187,187,'8e884ac6-f10e-4f13-9c29-5343effb2738','snapshot_support','True'),('2026-01-21 14:14:34.446882',NULL,'2026-01-21 14:14:37.217312',188,188,'2cc95c42-3ed4-484b-8292-b22b83574d2b','driver_handles_share_servers','False'),('2026-01-21 14:14:34.538435',NULL,'2026-01-21 14:14:37.217312',189,189,'2cc95c42-3ed4-484b-8292-b22b83574d2b','key1','value1'),('2026-01-21 14:14:34.543489',NULL,'2026-01-21 14:14:37.217312',190,190,'2cc95c42-3ed4-484b-8292-b22b83574d2b','key2','value2'),('2026-01-21 14:14:34.638764',NULL,'2026-01-21 14:14:34.910670',191,191,'2cc95c42-3ed4-484b-8292-b22b83574d2b','snapshot_support','True'),('2026-01-21 14:14:35.154359',NULL,'2026-01-21 14:14:36.333763',192,192,'660161c0-3c6e-4433-a6c3-5879e5be1d62','driver_handles_share_servers','False'),('2026-01-21 14:14:35.364515',NULL,'2026-01-21 14:14:36.333763',193,193,'660161c0-3c6e-4433-a6c3-5879e5be1d62','key1','value1'),('2026-01-21 14:14:35.370060','2026-01-21 14:14:35.448321','2026-01-21 14:14:36.333763',194,194,'660161c0-3c6e-4433-a6c3-5879e5be1d62','key2','value2_updated'),('2026-01-21 14:14:35.594743',NULL,'2026-01-21 14:14:35.922708',195,195,'a7f028e8-71b4-4459-ae31-7a7e0fda8422','driver_handles_share_servers','False'),('2026-01-21 14:14:35.678003','2026-01-21 14:14:35.752605','2026-01-21 14:14:35.922708',196,196,'a7f028e8-71b4-4459-ae31-7a7e0fda8422','key1','fake_value1_updated'),('2026-01-21 14:14:35.680695',NULL,'2026-01-21 14:14:35.922708',197,197,'a7f028e8-71b4-4459-ae31-7a7e0fda8422','key2','value2'),('2026-01-21 14:14:38.372155',NULL,'2026-01-21 14:15:33.876380',198,198,'073dda3b-4203-4183-90b1-b02118757953','driver_handles_share_servers','False'),('2026-01-21 14:14:38.372790',NULL,'2026-01-21 14:15:33.876380',199,199,'073dda3b-4203-4183-90b1-b02118757953','vendor_name','foobar'),('2026-01-21 14:14:42.650923',NULL,'2026-01-21 14:15:33.386727',200,200,'2e51bd45-5453-4e78-b8d6-9b395d5d763d','driver_handles_share_servers','False'),('2026-01-21 14:14:42.651414',NULL,'2026-01-21 14:15:33.386727',201,201,'2e51bd45-5453-4e78-b8d6-9b395d5d763d','vendor_name','foobar'),('2026-01-21 14:14:47.329348',NULL,'2026-01-21 14:15:33.224807',202,202,'570df0ca-219d-4456-90e9-bfe5252d183e','driver_handles_share_servers','False'),('2026-01-21 14:14:47.329772',NULL,'2026-01-21 14:15:33.224807',203,203,'570df0ca-219d-4456-90e9-bfe5252d183e','vendor_name','foobar'),('2026-01-21 14:14:50.787860',NULL,'2026-01-21 14:16:15.342171',204,204,'4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b','driver_handles_share_servers','False'),('2026-01-21 14:14:52.542762',NULL,'2026-01-21 14:15:33.073753',205,205,'f90ca7dd-2c72-49d1-9bfd-c7cfc1f6b718','driver_handles_share_servers','False'),('2026-01-21 14:14:52.543339',NULL,'2026-01-21 14:15:33.073753',206,206,'f90ca7dd-2c72-49d1-9bfd-c7cfc1f6b718','vendor_name','foobar'),('2026-01-21 14:14:59.048637',NULL,'2026-01-21 14:15:08.904025',207,207,'fa3be0f8-2dde-43f0-80c0-e2a4ba884d5b','driver_handles_share_servers','False'),('2026-01-21 14:15:00.758786',NULL,'2026-01-21 14:15:16.810171',208,208,'5f9f4ef7-dc66-42d3-8b39-c62ccc780aba','driver_handles_share_servers','False'),('2026-01-21 14:15:00.836294',NULL,'2026-01-21 14:15:32.749361',209,209,'c920fd72-4f4d-4931-b24d-6a9c60f2e233','driver_handles_share_servers','False'),('2026-01-21 14:15:00.840307',NULL,'2026-01-21 14:15:32.749361',210,210,'c920fd72-4f4d-4931-b24d-6a9c60f2e233','vendor_name','foobar'),('2026-01-21 14:15:04.808592',NULL,'2026-01-21 14:15:32.402964',211,211,'60b901c2-472b-4f17-bdda-ff703ace9faf','driver_handles_share_servers','False'),('2026-01-21 14:15:04.809048',NULL,'2026-01-21 14:15:32.402964',212,212,'60b901c2-472b-4f17-bdda-ff703ace9faf','vendor_name','foobar'),('2026-01-21 14:15:08.732292',NULL,'2026-01-21 14:15:32.241643',213,213,'7efdd4ee-25a0-4ed9-bca7-168f82a1df34','driver_handles_share_servers','False'),('2026-01-21 14:15:08.732847',NULL,'2026-01-21 14:15:32.241643',214,214,'7efdd4ee-25a0-4ed9-bca7-168f82a1df34','vendor_name','foobar'),('2026-01-21 14:15:16.973450',NULL,'2026-01-21 14:15:31.776166',215,215,'96a3f3a7-7b33-4316-8b52-e062643518d7','driver_handles_share_servers','False'),('2026-01-21 14:15:16.974012',NULL,'2026-01-21 14:15:31.776166',216,216,'96a3f3a7-7b33-4316-8b52-e062643518d7','vendor_name','foobar'),('2026-01-21 14:15:21.134997',NULL,'2026-01-21 14:15:31.579034',217,217,'86c39d6d-2e5a-4607-a4f6-36e6a44459c6','driver_handles_share_servers','False'),('2026-01-21 14:15:21.135821',NULL,'2026-01-21 14:15:31.579034',218,218,'86c39d6d-2e5a-4607-a4f6-36e6a44459c6','vendor_name','foobar'),('2026-01-21 14:15:27.071970',NULL,'2026-01-21 14:15:31.441804',219,219,'6c2e02fc-c934-482d-bdc9-0685eab3a289','driver_handles_share_servers','False'),('2026-01-21 14:15:27.072425',NULL,'2026-01-21 14:15:31.441804',220,220,'6c2e02fc-c934-482d-bdc9-0685eab3a289','vendor_name','foobar'),('2026-01-21 14:15:36.606553',NULL,NULL,0,221,'6ee0f8f5-aa3a-4c92-817a-3d69c33b511e','driver_handles_share_servers','False'),('2026-01-21 14:15:38.006271',NULL,'2026-01-21 14:15:39.380529',222,222,'0672d9de-f09f-45be-aa42-a0a781ebaacf','driver_handles_share_servers','False'),('2026-01-21 14:15:47.916499',NULL,'2026-01-21 14:15:52.166262',223,223,'9d070e4c-cd5d-4016-8488-753afbe9b6bd','driver_handles_share_servers','False'),('2026-01-21 14:15:49.146639',NULL,'2026-01-21 14:16:12.419783',224,224,'d54caddb-c1a6-4c3f-b2f9-7d1717fa702a','driver_handles_share_servers','False'),('2026-01-21 14:15:59.689147',NULL,'2026-01-21 14:16:05.772962',225,225,'4d59cdd9-e6fc-421a-8787-4a177f95dd1b','driver_handles_share_servers','False'),('2026-01-21 14:16:15.083644',NULL,'2026-01-21 14:17:20.676472',226,226,'ddce9437-41f6-41e1-9345-e8f73447a2bc','driver_handles_share_servers','False'),('2026-01-21 14:16:15.178792',NULL,'2026-01-21 14:16:37.773168',227,227,'24dda13d-d1e8-43b2-948e-8336430d5aff','driver_handles_share_servers','False'),('2026-01-21 14:16:15.179254',NULL,'2026-01-21 14:16:37.773168',228,228,'24dda13d-d1e8-43b2-948e-8336430d5aff','snapshot_support','True'),('2026-01-21 14:16:26.993041',NULL,'2026-01-21 14:16:39.390996',229,229,'06f3f214-12da-4ea9-a206-446558478b75','driver_handles_share_servers','False'),('2026-01-21 14:16:37.033200',NULL,'2026-01-21 14:17:53.141379',230,230,'e930702d-a3b3-40a2-9f70-64fa8134ddf6','driver_handles_share_servers','False'),('2026-01-21 14:16:46.603067',NULL,'2026-01-21 14:17:19.690097',231,231,'3ded9bac-2fe5-4f42-8fae-b77fb1f40041','driver_handles_share_servers','False'),('2026-01-21 14:16:46.603529',NULL,'2026-01-21 14:17:19.690097',232,232,'3ded9bac-2fe5-4f42-8fae-b77fb1f40041','snapshot_support','True'),('2026-01-21 14:16:46.603862',NULL,'2026-01-21 14:17:19.690097',233,233,'3ded9bac-2fe5-4f42-8fae-b77fb1f40041','create_share_from_snapshot_support','True'),('2026-01-21 14:16:53.738994',NULL,'2026-01-21 14:16:55.010146',234,234,'210d12bf-0cfe-4758-9931-8d68f5b9bd3f','driver_handles_share_servers','False'),('2026-01-21 14:17:07.944516',NULL,'2026-01-21 14:17:24.321336',235,235,'a35627cc-f912-49fe-a347-ce5ebde9e5e7','driver_handles_share_servers','False'),('2026-01-21 14:17:32.811867',NULL,'2026-01-21 14:18:39.249296',236,236,'113e6005-36b8-4048-8bc1-1b192c85dbac','driver_handles_share_servers','False'),('2026-01-21 14:17:32.813900',NULL,'2026-01-21 14:18:39.249296',237,237,'113e6005-36b8-4048-8bc1-1b192c85dbac','snapshot_support','True'),('2026-01-21 14:17:35.612963',NULL,'2026-01-21 14:18:32.247492',238,238,'a36cdb63-0be1-431b-b3a6-13bc024a485c','driver_handles_share_servers','False'),('2026-01-21 14:17:38.963630',NULL,'2026-01-21 14:17:39.146548',239,239,'c73aab02-1188-4223-92a9-2ae0ddbf0eb7','driver_handles_share_servers','False'),('2026-01-21 14:17:38.964052',NULL,'2026-01-21 14:17:39.146548',240,240,'c73aab02-1188-4223-92a9-2ae0ddbf0eb7','availability_zones','az1,az2,az 3'),('2026-01-21 14:17:39.303684',NULL,'2026-01-21 14:17:39.481441',241,241,'4f33df57-735a-485d-9526-7b946884a29e','driver_handles_share_servers','False'),('2026-01-21 14:17:39.304268',NULL,'2026-01-21 14:17:39.481441',242,242,'4f33df57-735a-485d-9526-7b946884a29e','availability_zones','az1,az2,az 3'),('2026-01-21 14:17:39.634308',NULL,'2026-01-21 14:17:39.763719',243,243,'453f8969-d259-485b-a4c6-0f22653d576a','driver_handles_share_servers','False'),('2026-01-21 14:17:39.634889',NULL,'2026-01-21 14:17:39.763719',244,244,'453f8969-d259-485b-a4c6-0f22653d576a','availability_zones','az1,az2,az 3'),('2026-01-21 14:17:39.892060',NULL,'2026-01-21 14:17:40.290527',245,245,'22861331-52f4-4a40-b2cb-9989ebd6e398','driver_handles_share_servers','False'),('2026-01-21 14:17:39.893198',NULL,'2026-01-21 14:17:40.290527',246,246,'22861331-52f4-4a40-b2cb-9989ebd6e398','availability_zones','az1,az2,az 3'),('2026-01-21 14:17:39.975254',NULL,'2026-01-21 14:17:40.124848',247,247,'b04e45a9-2ca1-446c-9e15-015ee6917dc7','driver_handles_share_servers','False'),('2026-01-21 14:17:40.573082',NULL,'2026-01-21 14:17:41.122033',248,248,'87ed3676-80cd-4929-b549-326481e7943a','driver_handles_share_servers','False'),('2026-01-21 14:17:40.573687',NULL,'2026-01-21 14:17:41.122033',249,249,'87ed3676-80cd-4929-b549-326481e7943a','availability_zones','az1,az2,az 3'),('2026-01-21 14:17:40.806813',NULL,'2026-01-21 14:17:40.956084',250,250,'d28ed814-526b-4077-99ec-a6cee0d6828a','driver_handles_share_servers','False'),('2026-01-21 14:17:41.323910',NULL,'2026-01-21 14:17:42.180705',251,251,'3c982ee3-151a-44e6-8f94-7a6dcf6dcb9b','driver_handles_share_servers','False'),('2026-01-21 14:17:41.324356',NULL,'2026-01-21 14:17:42.180705',252,252,'3c982ee3-151a-44e6-8f94-7a6dcf6dcb9b','availability_zones','az1,az2,az 3'),('2026-01-21 14:17:41.516772',NULL,'2026-01-21 14:17:41.873954',253,253,'c82cb231-032a-4a65-aa1e-59f0a201a371','driver_handles_share_servers','False'),('2026-01-21 14:17:42.381817',NULL,'2026-01-21 14:17:42.990189',254,254,'8b92d8d0-8cc5-4d4b-9823-bdb4c7be80a9','driver_handles_share_servers','False'),('2026-01-21 14:17:42.382850',NULL,'2026-01-21 14:17:42.990189',255,255,'8b92d8d0-8cc5-4d4b-9823-bdb4c7be80a9','availability_zones','az1,az2,az 3'),('2026-01-21 14:17:42.473219',NULL,'2026-01-21 14:17:42.771266',256,256,'56c06339-c13a-444f-a12a-00a983a7800e','driver_handles_share_servers','False'),('2026-01-21 14:17:43.131887',NULL,'2026-01-21 14:17:43.758515',257,257,'75fd427d-d3b5-4598-be04-e8b127176e91','driver_handles_share_servers','False'),('2026-01-21 14:17:43.132316',NULL,'2026-01-21 14:17:43.758515',258,258,'75fd427d-d3b5-4598-be04-e8b127176e91','availability_zones','az1,az2,az 3'),('2026-01-21 14:17:43.318879',NULL,'2026-01-21 14:17:43.620247',259,259,'96214695-f459-4610-9830-f80ba96473a4','driver_handles_share_servers','False'),('2026-01-21 14:17:43.902548',NULL,'2026-01-21 14:17:44.287596',260,260,'7954f283-4a6b-4dde-8e45-2c45f0d4e5b5','driver_handles_share_servers','False'),('2026-01-21 14:17:43.903109',NULL,'2026-01-21 14:17:44.287596',261,261,'7954f283-4a6b-4dde-8e45-2c45f0d4e5b5','availability_zones','az1,az2,az 3'),('2026-01-21 14:17:44.003307',NULL,'2026-01-21 14:17:44.145306',262,262,'49d3472e-308c-4583-9287-4156d23ba27e','driver_handles_share_servers','False'),('2026-01-21 14:17:44.583235','2026-01-21 14:18:00.068858','2026-01-21 14:18:32.247492',263,263,'a36cdb63-0be1-431b-b3a6-13bc024a485c','availability_zones','nova'),('2026-01-21 14:18:19.058241',NULL,'2026-01-21 14:18:34.074977',264,264,'f78ae5cb-fced-4e97-b8cd-e69b71d0827c','driver_handles_share_servers','False'),('2026-01-21 14:18:19.058787',NULL,'2026-01-21 14:18:34.074977',265,265,'f78ae5cb-fced-4e97-b8cd-e69b71d0827c','snapshot_support','True'),('2026-01-21 14:18:42.342285',NULL,'2026-01-21 14:18:45.188643',266,266,'524f3f41-1bea-4cc7-88dc-f04916d1f10b','driver_handles_share_servers','False'),('2026-01-21 14:18:43.300997','2026-01-21 14:18:43.774657','2026-01-21 14:18:45.188643',267,267,'524f3f41-1bea-4cc7-88dc-f04916d1f10b','availability_zones','az_that_doesnt_exist'),('2026-01-21 14:18:43.359056',NULL,'2026-01-21 14:18:43.579261',268,268,'20fe7a0f-3e7b-4a16-9fe8-5663abdf9a6c','driver_handles_share_servers','False'),('2026-01-21 14:18:48.854315',NULL,'2026-01-21 14:19:46.771947',269,269,'fce16d73-418d-491b-b08b-4701c62ff5bc','driver_handles_share_servers','False'),('2026-01-21 14:18:48.854692',NULL,'2026-01-21 14:19:46.771947',270,270,'fce16d73-418d-491b-b08b-4701c62ff5bc','snapshot_support','True'),('2026-01-21 14:18:48.854979',NULL,'2026-01-21 14:19:46.771947',271,271,'fce16d73-418d-491b-b08b-4701c62ff5bc','create_share_from_snapshot_support','True'),('2026-01-21 14:18:59.342081',NULL,'2026-01-21 14:19:02.635870',272,272,'473bf32a-284d-4c47-b01e-32e375d8dc32','driver_handles_share_servers','False'),('2026-01-21 14:18:59.520041',NULL,'2026-01-21 14:19:02.485210',273,273,'5ffdf703-3111-4cea-8522-bba2da97cc7c','driver_handles_share_servers','False'),('2026-01-21 14:19:19.887417',NULL,'2026-01-21 14:19:23.790886',274,274,'734fab31-124c-4fae-95e9-40289f0e1373','driver_handles_share_servers','False'),('2026-01-21 14:19:50.870376',NULL,'2026-01-21 14:20:00.403189',275,275,'03f56b46-4af0-499c-b9ab-b1d2f4aa8d40','driver_handles_share_servers','False'),('2026-01-21 14:20:13.939981',NULL,'2026-01-21 14:20:17.286755',276,276,'d6d924e7-25a0-4e6c-9279-2b6808552542','driver_handles_share_servers','False'),('2026-01-21 14:20:29.138048',NULL,'2026-01-21 14:21:00.240583',277,277,'703cfc70-9932-41ed-8a49-185d2994a4af','driver_handles_share_servers','False'),('2026-01-21 14:21:12.241477',NULL,'2026-01-21 14:23:02.664924',278,278,'cf23d5d3-0f2f-42ba-aef6-7861fed7457c','driver_handles_share_servers','False'),('2026-01-21 14:21:12.242020',NULL,'2026-01-21 14:23:02.664924',279,279,'cf23d5d3-0f2f-42ba-aef6-7861fed7457c','snapshot_support','True'),('2026-01-21 14:21:12.242480',NULL,'2026-01-21 14:23:02.664924',280,280,'cf23d5d3-0f2f-42ba-aef6-7861fed7457c','create_share_from_snapshot_support','True'),('2026-01-21 14:23:26.489430',NULL,'2026-01-21 14:23:55.056021',281,281,'a1bc5a3b-4487-4ec2-9108-ad6c89a426e4','driver_handles_share_servers','False'),('2026-01-21 14:23:26.489950',NULL,'2026-01-21 14:23:55.056021',282,282,'a1bc5a3b-4487-4ec2-9108-ad6c89a426e4','snapshot_support','True'),('2026-01-21 14:24:10.167706',NULL,'2026-01-21 14:24:13.008186',283,283,'d28e40ca-af07-490d-85a5-c80230cd0999','driver_handles_share_servers','False'),('2026-01-21 14:24:10.247825',NULL,'2026-01-21 14:24:12.825678',284,284,'4d1e73ff-574c-4b59-8269-3dc2748f8dd7','driver_handles_share_servers','False'),('2026-01-21 14:24:10.248732',NULL,'2026-01-21 14:24:12.825678',285,285,'4d1e73ff-574c-4b59-8269-3dc2748f8dd7','provisioning:max_share_size','5'),('2026-01-21 14:24:10.249302',NULL,'2026-01-21 14:24:12.825678',286,286,'4d1e73ff-574c-4b59-8269-3dc2748f8dd7','provisioning:min_share_size','2'),('2026-01-21 14:24:24.893671',NULL,'2026-01-21 14:24:56.023916',287,287,'f7db249e-6360-4f95-914d-c75a6989e840','driver_handles_share_servers','False'),('2026-01-21 14:24:24.894127',NULL,'2026-01-21 14:24:56.023916',288,288,'f7db249e-6360-4f95-914d-c75a6989e840','snapshot_support','True'),('2026-01-21 14:24:24.894529',NULL,'2026-01-21 14:24:56.023916',289,289,'f7db249e-6360-4f95-914d-c75a6989e840','create_share_from_snapshot_support','True'),('2026-01-21 14:25:06.470137',NULL,'2026-01-21 14:25:22.812441',290,290,'7c9297d5-c3a5-4113-9133-2dae5de6223a','driver_handles_share_servers','False'),('2026-01-21 14:25:06.470922',NULL,'2026-01-21 14:25:22.812441',291,291,'7c9297d5-c3a5-4113-9133-2dae5de6223a','snapshot_support','True'),('2026-01-21 14:25:06.471388',NULL,'2026-01-21 14:25:22.812441',292,292,'7c9297d5-c3a5-4113-9133-2dae5de6223a','create_share_from_snapshot_support','True');
/*!40000 ALTER TABLE `share_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_type_projects`
--

DROP TABLE IF EXISTS `share_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `stp_project_id_uc` (`share_type_id`,`project_id`,`deleted`),
  CONSTRAINT `stp_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_type_projects`
--

LOCK TABLES `share_type_projects` WRITE;
/*!40000 ALTER TABLE `share_type_projects` DISABLE KEYS */;
INSERT INTO `share_type_projects` (`id`, `created_at`, `updated_at`, `deleted_at`, `share_type_id`, `project_id`, `deleted`) VALUES (1,'2026-01-21 14:12:54.742938',NULL,'2026-01-21 14:12:55.041081','d412b829-d477-46b7-a489-e30be89cfea6','5da033845de7469096a0943fc3046311',1);
/*!40000 ALTER TABLE `share_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `share_types`
--

DROP TABLE IF EXISTS `share_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `share_types` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `st_name_uc` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `share_types`
--

LOCK TABLES `share_types` WRITE;
/*!40000 ALTER TABLE `share_types` DISABLE KEYS */;
INSERT INTO `share_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `is_public`, `description`) VALUES ('2026-01-21 14:19:50.869572',NULL,'2026-01-21 14:20:00.406586','03f56b46-4af0-499c-b9ab-b1d2f4aa8d40','03f56b46-4af0-499c-b9ab-b1d2f4aa8d40','tempest-typeshare-type-2138349714',1,NULL),('2026-01-21 14:15:38.005541',NULL,'2026-01-21 14:15:39.387536','0672d9de-f09f-45be-aa42-a0a781ebaacf','0672d9de-f09f-45be-aa42-a0a781ebaacf','tempest-typeshare-type-315096245',1,NULL),('2026-01-21 14:13:00.421139',NULL,'2026-01-21 14:13:08.053928','06ee2e67-5fc3-4e01-b2e6-24967778d2e6','06ee2e67-5fc3-4e01-b2e6-24967778d2e6','tempest-tempest-manila-1990118445',1,NULL),('2026-01-21 14:16:26.992248',NULL,'2026-01-21 14:16:39.396883','06f3f214-12da-4ea9-a206-446558478b75','06f3f214-12da-4ea9-a206-446558478b75','tempest-typeshare-type-1265494158',1,NULL),('2026-01-21 14:11:09.740868',NULL,'2026-01-21 14:11:19.775713','0702aa99-d0f6-4f0d-87b0-59e808fb4acc','0702aa99-d0f6-4f0d-87b0-59e808fb4acc','tempest-typeshare-type-1016393146',1,NULL),('2026-01-21 14:14:38.369558',NULL,'2026-01-21 14:15:33.878482','073dda3b-4203-4183-90b1-b02118757953','073dda3b-4203-4183-90b1-b02118757953','tempest-share-type-1316566573',1,NULL),('2026-01-21 14:12:55.834031',NULL,'2026-01-21 14:13:14.238052','08a48950-513b-45dc-9540-6e080e46f372','08a48950-513b-45dc-9540-6e080e46f372','tempest-tempest-manila-57463586',1,NULL),('2026-01-21 14:11:01.604171',NULL,'2026-01-21 14:12:02.465641','08dc12ec-0496-4207-ab26-687dc1000122','08dc12ec-0496-4207-ab26-687dc1000122','tempest-typeshare-type-1481494122',1,NULL),('2026-01-21 14:13:34.617287',NULL,'2026-01-21 14:14:02.518828','0b0ef60b-789a-4f97-ab23-aa852b1b2e11','0b0ef60b-789a-4f97-ab23-aa852b1b2e11','tempest-share-type-1510328768',1,NULL),('2026-01-21 14:12:57.061234',NULL,'2026-01-21 14:13:13.230688','0ff89cde-abc7-4313-9251-cc82bbb5270b','0ff89cde-abc7-4313-9251-cc82bbb5270b','tempest-tempest-manila-1140370670',1,'Description for share type'),('2026-01-21 14:17:32.810351',NULL,'2026-01-21 14:18:39.251929','113e6005-36b8-4048-8bc1-1b192c85dbac','113e6005-36b8-4048-8bc1-1b192c85dbac','tempest-typeshare-type-1098290829',1,NULL),('2026-01-21 14:12:53.932695',NULL,'2026-01-21 14:13:07.225850','11f5f65a-72f7-4a81-ab60-1400cdb3601b','11f5f65a-72f7-4a81-ab60-1400cdb3601b','tempest-typeshare-type-122901405',1,NULL),('2026-01-21 14:11:40.766241',NULL,'2026-01-21 14:11:59.325591','17cc8bc7-2a1d-4d75-abb8-7b834d3b229d','17cc8bc7-2a1d-4d75-abb8-7b834d3b229d','tempest-typeshare-type-1098990154',1,NULL),('2026-01-21 14:13:06.978819',NULL,'2026-01-21 14:13:13.655930','1ce52fbd-5775-4005-b564-079c46a8be68','1ce52fbd-5775-4005-b564-079c46a8be68','tempest-typeshare-type-2028691009',1,NULL),('2026-01-21 14:11:37.276649',NULL,'2026-01-21 14:12:00.052617','20f5b5fd-9c31-4b20-8536-8a9964fff283','20f5b5fd-9c31-4b20-8536-8a9964fff283','tempest-typeshare-type-1091413458',0,NULL),('2026-01-21 14:18:43.358339',NULL,'2026-01-21 14:18:43.581482','20fe7a0f-3e7b-4a16-9fe8-5663abdf9a6c','20fe7a0f-3e7b-4a16-9fe8-5663abdf9a6c','tempest-support_any_az_share_type-1799664700',1,NULL),('2026-01-21 14:16:53.737139',NULL,'2026-01-21 14:16:55.012854','210d12bf-0cfe-4758-9931-8d68f5b9bd3f','210d12bf-0cfe-4758-9931-8d68f5b9bd3f','tempest-typeshare-type-1069156194',1,NULL),('2026-01-21 14:12:57.713177',NULL,'2026-01-21 14:13:12.475215','21b5580a-f59d-413c-9408-1349c9b22246','21b5580a-f59d-413c-9408-1349c9b22246','tempest-tempest-manila-423745809',1,NULL),('2026-01-21 14:13:41.381354',NULL,'2026-01-21 14:14:40.695362','21dd7853-6f9b-4e9a-91b3-a47c3de6b980','21dd7853-6f9b-4e9a-91b3-a47c3de6b980','tempest-typeshare-type-1131198483',1,NULL),('2026-01-21 14:17:39.891221',NULL,'2026-01-21 14:17:40.293004','22861331-52f4-4a40-b2cb-9989ebd6e398','22861331-52f4-4a40-b2cb-9989ebd6e398','tempest-support_some_azs_share_type-1731768428',1,NULL),('2026-01-21 14:10:23.166440',NULL,'2026-01-21 14:10:34.678489','22f02301-b01e-4d8f-b557-3558b6a3b9a3','22f02301-b01e-4d8f-b557-3558b6a3b9a3','tempest-typeshare-type-146186215',1,NULL),('2026-01-21 14:16:15.178005',NULL,'2026-01-21 14:16:37.776233','24dda13d-d1e8-43b2-948e-8336430d5aff','24dda13d-d1e8-43b2-948e-8336430d5aff','tempest-typeshare-type-792489772',1,NULL),('2026-01-21 14:11:25.388479',NULL,'2026-01-21 14:12:01.106400','283e163d-39d4-4850-bbf9-a7e3eb6d8974','283e163d-39d4-4850-bbf9-a7e3eb6d8974','tempest-typeshare-type-1186628030',1,NULL),('2026-01-21 14:12:23.598527',NULL,'2026-01-21 14:12:39.961406','291913af-f721-4784-852d-18a81c2dbf2d','291913af-f721-4784-852d-18a81c2dbf2d','tempest-typeshare-type-1867242624',1,NULL),('2026-01-21 14:11:13.902738',NULL,'2026-01-21 14:11:18.955644','297b2a0a-ff05-4991-a30a-a02068f8eac9','297b2a0a-ff05-4991-a30a-a02068f8eac9','tempest-typeshare-type-2083983018',1,NULL),('2026-01-21 14:11:25.859609',NULL,'2026-01-21 14:12:07.555816','29cdbce9-1270-470b-8e9e-290edf433bce','29cdbce9-1270-470b-8e9e-290edf433bce','tempest-typeshare-type-104340156',1,NULL),('2026-01-21 14:14:34.445793',NULL,'2026-01-21 14:14:37.221627','2cc95c42-3ed4-484b-8292-b22b83574d2b','2cc95c42-3ed4-484b-8292-b22b83574d2b','tempest-share-type-924729874',1,NULL),('2026-01-21 14:11:43.588275',NULL,'2026-01-21 14:11:55.862425','2d1d6de3-0dbc-47ed-8762-ae98d5903b16','2d1d6de3-0dbc-47ed-8762-ae98d5903b16','tempest-typeshare-type-948511955',1,NULL),('2026-01-21 14:14:42.646551',NULL,'2026-01-21 14:15:33.388878','2e51bd45-5453-4e78-b8d6-9b395d5d763d','2e51bd45-5453-4e78-b8d6-9b395d5d763d','tempest-share-type-1196277477',1,NULL),('2026-01-21 14:11:01.698183',NULL,'2026-01-21 14:12:02.003984','3055f25f-99ca-47e1-85fd-3d023797e4ab','3055f25f-99ca-47e1-85fd-3d023797e4ab','tempest-typeshare-type-574205827',1,NULL),('2026-01-21 14:12:53.333044',NULL,'2026-01-21 14:13:07.369743','35f80e6b-cd13-40a3-bbe5-46fcfd62ca5a','35f80e6b-cd13-40a3-bbe5-46fcfd62ca5a','tempest-typeshare-type-932380549',1,NULL),('2026-01-21 14:13:00.890844',NULL,'2026-01-21 14:13:02.520586','372188f9-9263-49f2-b40d-0e327e3d9b3b','372188f9-9263-49f2-b40d-0e327e3d9b3b','tempest-typeshare-type-1708817035',1,NULL),('2026-01-21 14:12:58.133176',NULL,'2026-01-21 14:13:12.277849','3823cbda-4634-482b-87a3-52aaea9b923a','3823cbda-4634-482b-87a3-52aaea9b923a','tempest-tempest-manila-453769982',1,NULL),('2026-01-21 14:13:00.268360',NULL,'2026-01-21 14:13:02.901529','3830166d-da4c-4040-9a83-bbe130b0da04','3830166d-da4c-4040-9a83-bbe130b0da04','tempest-typeshare-type-1345143515',1,NULL),('2026-01-21 14:11:09.528122',NULL,'2026-01-21 14:11:09.840411','3a8f9ed8-9c5f-48ce-bc78-8e37ac8f057a','3a8f9ed8-9c5f-48ce-bc78-8e37ac8f057a','tempest-tempest-manila-571069597',0,NULL),('2026-01-21 14:12:56.871688',NULL,'2026-01-21 14:13:13.400521','3adc6194-84b7-4be6-a311-d4308aac9063','3adc6194-84b7-4be6-a311-d4308aac9063','tempest-tempest-manila-1425161202',1,NULL),('2026-01-21 14:17:41.323056',NULL,'2026-01-21 14:17:42.186460','3c982ee3-151a-44e6-8f94-7a6dcf6dcb9b','3c982ee3-151a-44e6-8f94-7a6dcf6dcb9b','tempest-support_some_azs_share_type-1561640369',1,NULL),('2026-01-21 14:12:57.015407',NULL,'2026-01-21 14:13:05.014662','3d5b0370-a926-45f6-b91e-366a806d0d80','3d5b0370-a926-45f6-b91e-366a806d0d80','tempest-typeshare-type-583069605',1,NULL),('2026-01-21 14:16:46.602241',NULL,'2026-01-21 14:17:19.694361','3ded9bac-2fe5-4f42-8fae-b77fb1f40041','3ded9bac-2fe5-4f42-8fae-b77fb1f40041','tempest-typeshare-type-1694165797',1,NULL),('2026-01-21 14:12:56.370606',NULL,'2026-01-21 14:13:13.853182','43ca4f08-53cb-4ba4-8916-c9865280e268','43ca4f08-53cb-4ba4-8916-c9865280e268','tempest-tempest-manila-1231860863',1,NULL),('2026-01-21 14:17:39.633235',NULL,'2026-01-21 14:17:39.766324','453f8969-d259-485b-a4c6-0f22653d576a','453f8969-d259-485b-a4c6-0f22653d576a','tempest-az_share_type-79129573',1,NULL),('2026-01-21 14:11:35.286516',NULL,'2026-01-21 14:12:00.483862','46b5cf9b-25b2-40af-8cff-d939d6ed0251','46b5cf9b-25b2-40af-8cff-d939d6ed0251','tempest-typeshare-type-1446760827',1,NULL),('2026-01-21 14:18:59.340514',NULL,'2026-01-21 14:19:02.638303','473bf32a-284d-4c47-b01e-32e375d8dc32','473bf32a-284d-4c47-b01e-32e375d8dc32','tempest-typeshare-type-41589352',1,NULL),('2026-01-21 14:11:43.968285',NULL,'2026-01-21 14:11:54.317262','479ba5fa-bee8-4bad-b073-700b5c151289','479ba5fa-bee8-4bad-b073-700b5c151289','tempest-typeshare-type-183199327',1,NULL),('2026-01-21 14:12:57.341735',NULL,'2026-01-21 14:13:04.861116','49431ee2-5502-40e8-ad0c-b7a171ad66b3','49431ee2-5502-40e8-ad0c-b7a171ad66b3','tempest-typeshare-type-589304121',1,NULL),('2026-01-21 14:17:44.002497',NULL,'2026-01-21 14:17:44.148269','49d3472e-308c-4583-9287-4156d23ba27e','49d3472e-308c-4583-9287-4156d23ba27e','tempest-support_any_az_share_type-1104992601',1,NULL),('2026-01-21 14:12:53.108117',NULL,'2026-01-21 14:13:07.524956','4a9b67a4-7409-4001-be69-bf77cf76b216','4a9b67a4-7409-4001-be69-bf77cf76b216','tempest-typeshare-type-1585143345',1,NULL),('2026-01-21 14:13:02.399950','2026-01-21 14:13:02.536417','2026-01-21 14:13:06.535925','4b1f54da-0ea5-44c4-8b97-4c1a9e9fda0a','4b1f54da-0ea5-44c4-8b97-4c1a9e9fda0a','tempest-type_updated-1352391055',1,'description_updated'),('2026-01-21 14:14:50.787081',NULL,'2026-01-21 14:16:18.906492','4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b','4b33a0e0-ee2f-4d7f-8c3e-fe30b8c6400b','tempest-typeshare-type-2107245026',1,NULL),('2026-01-21 14:12:55.311956',NULL,'2026-01-21 14:12:55.415986','4cee2d84-06d7-4693-b766-982d7ff81504','4cee2d84-06d7-4693-b766-982d7ff81504','tempest-tempest-manila-1582242739',1,NULL),('2026-01-21 14:24:10.246626',NULL,'2026-01-21 14:24:12.829381','4d1e73ff-574c-4b59-8269-3dc2748f8dd7','4d1e73ff-574c-4b59-8269-3dc2748f8dd7','tempest-typeshare-type-1949517028',1,NULL),('2026-01-21 14:15:59.688175',NULL,'2026-01-21 14:16:05.776385','4d59cdd9-e6fc-421a-8787-4a177f95dd1b','4d59cdd9-e6fc-421a-8787-4a177f95dd1b','tempest-typeshare-type-415667253',1,NULL),('2026-01-21 14:12:55.166161',NULL,'2026-01-21 14:13:06.514815','4d8e8a1c-ea7f-4ed7-bc13-dc40c78ad424','4d8e8a1c-ea7f-4ed7-bc13-dc40c78ad424','tempest-typeshare-type-307457778',1,NULL),('2026-01-21 14:17:39.302955',NULL,'2026-01-21 14:17:39.484122','4f33df57-735a-485d-9526-7b946884a29e','4f33df57-735a-485d-9526-7b946884a29e','tempest-az_share_type-518004999',1,NULL),('2026-01-21 14:11:08.318596',NULL,'2026-01-21 14:11:10.019621','4fd1707a-48c4-4e0f-b197-978fd868c037','4fd1707a-48c4-4e0f-b197-978fd868c037','tempest-typeshare-type-883962953',1,NULL),('2026-01-21 14:11:22.575841',NULL,'2026-01-21 14:12:01.482769','5081aafe-5bcd-4868-82bc-92284af11fa0','5081aafe-5bcd-4868-82bc-92284af11fa0','tempest-typeshare-type-826912295',0,NULL),('2026-01-21 14:18:42.341464',NULL,'2026-01-21 14:18:45.191680','524f3f41-1bea-4cc7-88dc-f04916d1f10b','524f3f41-1bea-4cc7-88dc-f04916d1f10b','tempest-typeshare-type-23655769',1,NULL),('2026-01-21 14:11:39.487789',NULL,'2026-01-21 14:11:57.799801','563a2127-2f8d-45e9-86b1-3f1b5b1bbf10','563a2127-2f8d-45e9-86b1-3f1b5b1bbf10','tempest-typeshare-type-262056618',1,NULL),('2026-01-21 14:17:42.471942',NULL,'2026-01-21 14:17:42.775441','56c06339-c13a-444f-a12a-00a983a7800e','56c06339-c13a-444f-a12a-00a983a7800e','tempest-support_any_az_share_type-45381427',1,NULL),('2026-01-21 14:14:47.328419',NULL,'2026-01-21 14:15:33.227178','570df0ca-219d-4456-90e9-bfe5252d183e','570df0ca-219d-4456-90e9-bfe5252d183e','tempest-share-type-1697853628',1,NULL),('2026-01-21 14:12:58.566036',NULL,'2026-01-21 14:13:03.753810','576dc762-759a-4e85-aa38-3f7c8e73b9f7','576dc762-759a-4e85-aa38-3f7c8e73b9f7','tempest-typeshare-type-329716364',1,NULL),('2026-01-21 14:13:11.788692',NULL,'2026-01-21 14:13:13.086072','582c08e2-111a-4218-a6e7-f9b876bd9671','582c08e2-111a-4218-a6e7-f9b876bd9671','tempest-typeshare-type-1034786314',1,NULL),('2026-01-21 14:12:39.961223',NULL,'2026-01-21 14:13:02.310041','59554df7-024a-45b7-9735-27031cc895f1','59554df7-024a-45b7-9735-27031cc895f1','tempest-typeshare-type-1033386325',1,NULL),('2026-01-21 14:12:15.620943',NULL,'2026-01-21 14:12:23.603676','5a374d5e-d0ed-4003-9ec7-10084960d609','5a374d5e-d0ed-4003-9ec7-10084960d609','tempest-typeshare-type-900195014',1,NULL),('2026-01-21 14:13:01.518576','2026-01-21 14:13:01.599870','2026-01-21 14:13:07.403742','5a67966c-f574-4600-aba2-a15061ec309b','5a67966c-f574-4600-aba2-a15061ec309b','tempest-type_updated-114420375',1,'Description for share type'),('2026-01-21 14:13:55.224276',NULL,'2026-01-21 14:14:01.481990','5afaec67-94c3-4b24-8db9-1b003291becd','5afaec67-94c3-4b24-8db9-1b003291becd','tempest-share-type-35133678',1,NULL),('2026-01-21 14:11:44.494438',NULL,'2026-01-21 14:11:53.485297','5d544b7d-6d61-4588-8421-9a74b9f58b6c','5d544b7d-6d61-4588-8421-9a74b9f58b6c','tempest-typeshare-type-1255948915',1,NULL),('2026-01-21 14:12:52.757022',NULL,'2026-01-21 14:13:07.718474','5db47c29-acbc-40ec-8e55-f1ce76935da6','5db47c29-acbc-40ec-8e55-f1ce76935da6','tempest-typeshare-type-785614202',1,NULL),('2026-01-21 14:11:14.746457',NULL,'2026-01-21 14:11:18.701174','5f3109e8-43e4-46c3-9ec1-eda96338311b','5f3109e8-43e4-46c3-9ec1-eda96338311b','tempest-unique_st_name-59321740',1,NULL),('2026-01-21 14:15:00.755666',NULL,'2026-01-21 14:15:16.815995','5f9f4ef7-dc66-42d3-8b39-c62ccc780aba','5f9f4ef7-dc66-42d3-8b39-c62ccc780aba','tempest-typeshare-type-835876379',1,NULL),('2026-01-21 14:18:59.519344',NULL,'2026-01-21 14:19:02.489661','5ffdf703-3111-4cea-8522-bba2da97cc7c','5ffdf703-3111-4cea-8522-bba2da97cc7c','tempest-typeshare-type-893002328',1,NULL),('2026-01-21 14:15:04.807733',NULL,'2026-01-21 14:15:32.406276','60b901c2-472b-4f17-bdda-ff703ace9faf','60b901c2-472b-4f17-bdda-ff703ace9faf','tempest-share-type-2036488519',1,NULL),('2026-01-21 14:12:58.061984',NULL,'2026-01-21 14:13:04.386263','64248035-9de8-48ff-a96d-82c098528eec','64248035-9de8-48ff-a96d-82c098528eec','tempest-typeshare-type-539888182',1,NULL),('2026-01-21 14:11:47.341384',NULL,'2026-01-21 14:11:47.959194','64cf5b56-724a-43be-bc52-e3d17596c75e','64cf5b56-724a-43be-bc52-e3d17596c75e','tempest-typeshare-type-626939645',1,NULL),('2026-01-21 14:14:35.153680',NULL,'2026-01-21 14:14:36.336359','660161c0-3c6e-4433-a6c3-5879e5be1d62','660161c0-3c6e-4433-a6c3-5879e5be1d62','tempest-share-type-1442450175',1,NULL),('2026-01-21 14:11:40.357057',NULL,'2026-01-21 14:11:56.878694','6766bec6-bf02-4cce-8e69-bfcaa405c120','6766bec6-bf02-4cce-8e69-bfcaa405c120','tempest-typeshare-type-1401190436',1,NULL),('2026-01-21 14:13:02.805161','2026-01-21 14:13:03.186953','2026-01-21 14:13:06.365324','683d7b00-2e48-4c37-adab-c0b5d4bb0b5a','683d7b00-2e48-4c37-adab-c0b5d4bb0b5a','tempest-type_updated-1933319227',1,'Description for share type'),('2026-01-21 14:15:27.071186',NULL,'2026-01-21 14:15:31.444401','6c2e02fc-c934-482d-bdc9-0685eab3a289','6c2e02fc-c934-482d-bdc9-0685eab3a289','tempest-share-type-1927906303',1,NULL),('2026-01-21 14:14:33.347306',NULL,'2026-01-21 14:14:37.699169','6d2837a3-2f8e-45c2-9b30-084b458e7292','6d2837a3-2f8e-45c2-9b30-084b458e7292','tempest-share-type-1630771846',1,NULL),('2026-01-21 14:13:01.336478','2026-01-21 14:13:01.443878','2026-01-21 14:13:07.563570','6def9bdd-be47-4d08-a5e2-ecc064c736ad','6def9bdd-be47-4d08-a5e2-ecc064c736ad','tempest-type_updated-1983447676',1,'description_updated'),('2026-01-21 14:15:36.605216',NULL,NULL,'False','6ee0f8f5-aa3a-4c92-817a-3d69c33b511e','tempest-typeshare-type-420030955',1,NULL),('2026-01-21 14:11:09.075464',NULL,'2026-01-21 14:11:09.321631','6ef617ea-74fb-480b-8598-cb5a61cefa41','6ef617ea-74fb-480b-8598-cb5a61cefa41','tempest-tempest-manila-1606823932',1,NULL),('2026-01-21 14:20:29.134537',NULL,'2026-01-21 14:21:00.243493','703cfc70-9932-41ed-8a49-185d2994a4af','703cfc70-9932-41ed-8a49-185d2994a4af','tempest-typeshare-type-2110985887',1,NULL),('2026-01-21 14:12:55.585834',NULL,'2026-01-21 14:13:06.090227','7099eca0-d9eb-4a38-8b8f-e1e906bb4b00','7099eca0-d9eb-4a38-8b8f-e1e906bb4b00','tempest-typeshare-type-975641037',1,NULL),('2026-01-21 14:10:22.548331',NULL,'2026-01-21 14:10:36.237361','730c7c03-7e1d-487b-906f-6935715d2b12','730c7c03-7e1d-487b-906f-6935715d2b12','tempest-typeshare-type-2003622226',1,NULL),('2026-01-21 14:19:19.886552',NULL,'2026-01-21 14:19:23.793782','734fab31-124c-4fae-95e9-40289f0e1373','734fab31-124c-4fae-95e9-40289f0e1373','tempest-typeshare-type-290427827',1,NULL),('2026-01-21 14:13:01.239326',NULL,'2026-01-21 14:13:02.383875','745427b5-ef77-4a9c-a0f0-14456b9f1b7e','745427b5-ef77-4a9c-a0f0-14456b9f1b7e','tempest-typeshare-type-809631706',1,NULL),('2026-01-21 14:17:43.130927',NULL,'2026-01-21 14:17:43.765196','75fd427d-d3b5-4598-be04-e8b127176e91','75fd427d-d3b5-4598-be04-e8b127176e91','tempest-support_some_azs_share_type-1824629652',1,NULL),('2026-01-21 14:12:55.925582',NULL,'2026-01-21 14:13:05.536831','768bc3bf-35e4-420e-869a-bd64ab319b31','768bc3bf-35e4-420e-869a-bd64ab319b31','tempest-typeshare-type-858509808',1,NULL),('2026-01-21 14:13:50.162490',NULL,'2026-01-21 14:14:01.655076','78590156-25d2-468c-8633-1b5bd4532903','78590156-25d2-468c-8633-1b5bd4532903','tempest-share-type-1087729781',1,NULL),('2026-01-21 14:11:21.508010',NULL,'2026-01-21 14:12:01.714867','789ac2c9-711f-4a07-a8a8-e5a726b61aec','789ac2c9-711f-4a07-a8a8-e5a726b61aec','tempest-typeshare-type-320158819',1,NULL),('2026-01-21 14:17:43.899934',NULL,'2026-01-21 14:17:44.290685','7954f283-4a6b-4dde-8e45-2c45f0d4e5b5','7954f283-4a6b-4dde-8e45-2c45f0d4e5b5','tempest-support_some_azs_share_type-1040714473',1,NULL),('2026-01-21 14:14:10.199882',NULL,'2026-01-21 14:14:25.221272','7ac1d9c2-538b-4775-a2d5-4c70805fd54c','7ac1d9c2-538b-4775-a2d5-4c70805fd54c','tempest-typeshare-type-495968078',1,NULL),('2026-01-21 14:13:02.239617','2026-01-21 14:13:02.333338','2026-01-21 14:13:06.746739','7babed33-967f-4958-b1a5-0a8dcd909950','7babed33-967f-4958-b1a5-0a8dcd909950','tempest-tempest-manila-614801825',0,'Description for share type'),('2026-01-21 14:25:06.468232',NULL,'2026-01-21 14:25:22.815187','7c9297d5-c3a5-4113-9133-2dae5de6223a','7c9297d5-c3a5-4113-9133-2dae5de6223a','tempest-typeshare-type-1996263211',1,NULL),('2026-01-21 14:13:38.476205',NULL,'2026-01-21 14:14:01.755078','7cec5100-da97-4c19-a6d2-711aa40fb4a4','7cec5100-da97-4c19-a6d2-711aa40fb4a4','tempest-typeshare-type-879141496',1,NULL),('2026-01-21 14:12:59.978209',NULL,'2026-01-21 14:13:08.463854','7d3cb003-36db-4745-9df4-d4f1569e4c05','7d3cb003-36db-4745-9df4-d4f1569e4c05','tempest-tempest-manila-989700553',1,NULL),('2026-01-21 14:15:08.730971',NULL,'2026-01-21 14:15:32.245234','7efdd4ee-25a0-4ed9-bca7-168f82a1df34','7efdd4ee-25a0-4ed9-bca7-168f82a1df34','tempest-share-type-1950405358',1,NULL),('2026-01-21 14:12:58.954512',NULL,'2026-01-21 14:13:03.236441','818fd452-3d60-48fb-972b-85580aa222a9','818fd452-3d60-48fb-972b-85580aa222a9','tempest-typeshare-type-893658576',1,NULL),('2026-01-21 14:13:03.781664','2026-01-21 14:13:03.916197','2026-01-21 14:13:05.915002','82af13b1-6123-4330-bb82-5cf38fdac57f','82af13b1-6123-4330-bb82-5cf38fdac57f','tempest-tempest-manila-410343200',1,'Description for share type'),('2026-01-21 14:13:00.942404',NULL,'2026-01-21 14:13:07.752552','85182014-309a-4002-b3f5-bc452a862b65','85182014-309a-4002-b3f5-bc452a862b65','tempest-tempest-manila-548562320',1,NULL),('2026-01-21 14:15:21.134069',NULL,'2026-01-21 14:15:31.581381','86c39d6d-2e5a-4607-a4f6-36e6a44459c6','86c39d6d-2e5a-4607-a4f6-36e6a44459c6','tempest-share-type-557767060',1,NULL),('2026-01-21 14:17:40.571870',NULL,'2026-01-21 14:17:41.127940','87ed3676-80cd-4929-b549-326481e7943a','87ed3676-80cd-4929-b549-326481e7943a','tempest-support_some_azs_share_type-1890285597',1,NULL),('2026-01-21 14:17:42.378867',NULL,'2026-01-21 14:17:42.993049','8b92d8d0-8cc5-4d4b-9823-bdb4c7be80a9','8b92d8d0-8cc5-4d4b-9823-bdb4c7be80a9','tempest-support_some_azs_share_type-804090904',1,NULL),('2026-01-21 14:11:13.418699',NULL,'2026-01-21 14:11:19.131732','8c635de3-9579-4fc9-bf8e-9507d93a21e2','8c635de3-9579-4fc9-bf8e-9507d93a21e2','tempest-typeshare-type-584164596',1,NULL),('2026-01-21 14:11:10.101750',NULL,'2026-01-21 14:11:19.466981','8df9198b-0103-44d3-a6df-cde5afc23c93','8df9198b-0103-44d3-a6df-cde5afc23c93','tempest-typeshare-type-413609111',1,NULL),('2026-01-21 14:14:33.901285',NULL,'2026-01-21 14:14:37.510154','8e884ac6-f10e-4f13-9c29-5343effb2738','8e884ac6-f10e-4f13-9c29-5343effb2738','tempest-share-type-760203665',1,NULL),('2026-01-21 14:11:15.974341',NULL,'2026-01-21 14:11:18.444724','8eef7f78-8896-4816-bbb1-4faa510ec52f','8eef7f78-8896-4816-bbb1-4faa510ec52f','tempest-unique_st_name-28807680',1,NULL),('2026-01-21 14:13:07.586899',NULL,'2026-01-21 14:13:13.395657','935cd5fe-f41b-49cf-ad89-0aef2a9bcdc3','935cd5fe-f41b-49cf-ad89-0aef2a9bcdc3','tempest-share-type-1907097049',0,NULL),('2026-01-21 14:12:49.563003',NULL,'2026-01-21 14:13:15.710235','9381faef-bf67-41dd-aaaa-a9be7a2bcc68','9381faef-bf67-41dd-aaaa-a9be7a2bcc68','tempest-share-type-1100686857',1,NULL),('2026-01-21 14:17:43.316940',NULL,'2026-01-21 14:17:43.622868','96214695-f459-4610-9830-f80ba96473a4','96214695-f459-4610-9830-f80ba96473a4','tempest-support_any_az_share_type-1508148397',1,NULL),('2026-01-21 14:13:08.565350',NULL,'2026-01-21 14:13:13.248666','966ab038-89e3-4448-aa6d-f60b379c13fd','966ab038-89e3-4448-aa6d-f60b379c13fd','tempest-typeshare-type-1182249540',1,NULL),('2026-01-21 14:15:16.972082',NULL,'2026-01-21 14:15:31.780495','96a3f3a7-7b33-4316-8b52-e062643518d7','96a3f3a7-7b33-4316-8b52-e062643518d7','tempest-share-type-242337527',1,NULL),('2026-01-21 14:10:20.341796',NULL,'2026-01-21 14:12:15.379566','9bfc08e1-2434-47e7-8b27-5587894f67ed','9bfc08e1-2434-47e7-8b27-5587894f67ed','tempest-typeshare-type-372037022',1,NULL),('2026-01-21 14:12:58.590418',NULL,'2026-01-21 14:13:11.939795','9c5c6fe8-d3d4-4ac9-a539-5ec180819cbb','9c5c6fe8-d3d4-4ac9-a539-5ec180819cbb','tempest-tempest-manila-2027308814',1,NULL),('2026-01-21 14:13:39.398870',NULL,'2026-01-21 14:14:02.191277','9ca783c9-ecfe-469c-a4a8-d087ab0379ae','9ca783c9-ecfe-469c-a4a8-d087ab0379ae','tempest-share-type-1197392264',1,NULL),('2026-01-21 14:15:47.911226',NULL,'2026-01-21 14:15:52.169432','9d070e4c-cd5d-4016-8488-753afbe9b6bd','9d070e4c-cd5d-4016-8488-753afbe9b6bd','tempest-typeshare-type-4873953',1,NULL),('2026-01-21 14:12:56.668347',NULL,'2026-01-21 14:13:13.688546','9f296d55-0304-4830-9fa5-6211637fe75f','9f296d55-0304-4830-9fa5-6211637fe75f','tempest-tempest-manila-963727745',1,NULL),('2026-01-21 14:23:26.486978',NULL,'2026-01-21 14:23:55.060347','a1bc5a3b-4487-4ec2-9108-ad6c89a426e4','a1bc5a3b-4487-4ec2-9108-ad6c89a426e4','tempest-typeshare-type-939762759',1,NULL),('2026-01-21 14:17:07.940955',NULL,'2026-01-21 14:17:24.323821','a35627cc-f912-49fe-a347-ce5ebde9e5e7','a35627cc-f912-49fe-a347-ce5ebde9e5e7','tempest-typeshare-type-1536486980',1,NULL),('2026-01-21 14:17:35.611675',NULL,'2026-01-21 14:18:32.250198','a36cdb63-0be1-431b-b3a6-13bc024a485c','a36cdb63-0be1-431b-b3a6-13bc024a485c','tempest-typeshare-type-1749260320',1,NULL),('2026-01-21 14:12:58.908785',NULL,'2026-01-21 14:13:11.574914','a410e5a9-ea68-47cc-be7a-d472ddbe0aa7','a410e5a9-ea68-47cc-be7a-d472ddbe0aa7','tempest-tempest-manila-1920831017',1,'Description for share type'),('2026-01-21 14:13:04.395425','2026-01-21 14:13:04.532884','2026-01-21 14:13:05.671483','a60962cb-c43f-4698-aafa-443085e9d38f','a60962cb-c43f-4698-aafa-443085e9d38f','tempest-tempest-manila-1918758206',0,'Description for share type'),('2026-01-21 14:14:35.593978',NULL,'2026-01-21 14:14:35.925039','a7f028e8-71b4-4459-ae31-7a7e0fda8422','a7f028e8-71b4-4459-ae31-7a7e0fda8422','tempest-share-type-1621738681',1,NULL),('2026-01-21 14:12:56.622832',NULL,'2026-01-21 14:13:05.192689','a87bc269-1838-4f29-8277-1729483d3860','a87bc269-1838-4f29-8277-1729483d3860','tempest-typeshare-type-780932319',1,NULL),('2026-01-21 14:17:39.973327',NULL,'2026-01-21 14:17:40.127868','b04e45a9-2ca1-446c-9e15-015ee6917dc7','b04e45a9-2ca1-446c-9e15-015ee6917dc7','tempest-support_any_az_share_type-339591235',1,NULL),('2026-01-21 14:06:15.608474',NULL,NULL,'False','b162a983-fd22-416d-b3c5-874636612a2e','default',1,NULL),('2026-01-21 14:11:39.488299',NULL,'2026-01-21 14:11:59.710585','b42fe5e7-36a4-4949-a87c-fc57879172ce','b42fe5e7-36a4-4949-a87c-fc57879172ce','tempest-typeshare-type-1659430216',1,NULL),('2026-01-21 14:13:01.657989',NULL,'2026-01-21 14:13:02.228847','b486058c-98b6-4a76-a025-d9e66804a495','b486058c-98b6-4a76-a025-d9e66804a495','tempest-typeshare-type-1667554282',1,NULL),('2026-01-21 14:11:45.598569',NULL,'2026-01-21 14:11:49.753312','b61f136f-352c-46d4-b7cd-eae096e4ac0c','b61f136f-352c-46d4-b7cd-eae096e4ac0c','tempest-typeshare-type-2102400359',1,NULL),('2026-01-21 14:12:56.882658',NULL,'2026-01-21 14:12:57.489134','b655505b-7540-4117-870a-bc0df7ff0060','b655505b-7540-4117-870a-bc0df7ff0060','tempest-share-type-1071461028',1,NULL),('2026-01-21 14:11:37.289715',NULL,'2026-01-21 14:11:59.109847','c48c3211-571d-48cc-adeb-a0cae69c52d7','c48c3211-571d-48cc-adeb-a0cae69c52d7','tempest-typeshare-type-1946615054',1,NULL),('2026-01-21 14:13:03.472959','2026-01-21 14:13:03.621585','2026-01-21 14:13:06.131892','c49ea73f-3c43-480c-941a-313c35650c4a','c49ea73f-3c43-480c-941a-313c35650c4a','tempest-tempest-manila-312451552',1,'description_updated'),('2026-01-21 14:11:20.862915',NULL,'2026-01-21 14:12:12.167180','c5bac032-cc46-4150-aad5-9325071c0935','c5bac032-cc46-4150-aad5-9325071c0935','tempest-typeshare-type-722222469',1,NULL),('2026-01-21 14:17:38.962746',NULL,'2026-01-21 14:17:39.149362','c73aab02-1188-4223-92a9-2ae0ddbf0eb7','c73aab02-1188-4223-92a9-2ae0ddbf0eb7','tempest-az_share_type-2078616337',1,NULL),('2026-01-21 14:17:41.513360',NULL,'2026-01-21 14:17:41.876742','c82cb231-032a-4a65-aa1e-59f0a201a371','c82cb231-032a-4a65-aa1e-59f0a201a371','tempest-support_any_az_share_type-938728368',1,NULL),('2026-01-21 14:12:57.373483',NULL,'2026-01-21 14:13:12.961005','c900e2f6-56da-45a0-a8ca-77bf28c9e506','c900e2f6-56da-45a0-a8ca-77bf28c9e506','tempest-tempest-manila-1628059012',1,NULL),('2026-01-21 14:15:00.820208',NULL,'2026-01-21 14:15:32.752210','c920fd72-4f4d-4931-b24d-6a9c60f2e233','c920fd72-4f4d-4931-b24d-6a9c60f2e233','tempest-share-type-1283145277',1,NULL),('2026-01-21 14:13:04.640669','2026-01-21 14:13:04.774579','2026-01-21 14:13:05.233788','ca5317ec-f975-4b16-9412-1a835dd293fd','ca5317ec-f975-4b16-9412-1a835dd293fd','tempest-tempest-manila-2046713621',1,NULL),('2026-01-21 14:13:45.491312',NULL,'2026-01-21 14:14:01.842005','cdda8570-26be-4330-bd36-622a2eb10327','cdda8570-26be-4330-bd36-622a2eb10327','tempest-share-type-427277412',1,NULL),('2026-01-21 14:12:54.952869',NULL,'2026-01-21 14:13:06.715611','cf065933-60bb-4ef0-afcb-2b7d4daffd3f','cf065933-60bb-4ef0-afcb-2b7d4daffd3f','tempest-typeshare-type-1052186424',1,NULL),('2026-01-21 14:21:12.239922',NULL,'2026-01-21 14:23:02.667964','cf23d5d3-0f2f-42ba-aef6-7861fed7457c','cf23d5d3-0f2f-42ba-aef6-7861fed7457c','tempest-typeshare-type-750024894',1,NULL),('2026-01-21 14:11:16.197283',NULL,'2026-01-21 14:11:17.676508','d0a806f2-cacc-40f3-8260-02bf317137a5','d0a806f2-cacc-40f3-8260-02bf317137a5','tempest-unique_st_name-1121989013',1,NULL),('2026-01-21 14:24:10.166672',NULL,'2026-01-21 14:24:13.012322','d28e40ca-af07-490d-85a5-c80230cd0999','d28e40ca-af07-490d-85a5-c80230cd0999','tempest-typeshare-type-982561485',1,NULL),('2026-01-21 14:17:40.805986',NULL,'2026-01-21 14:17:40.959277','d28ed814-526b-4077-99ec-a6cee0d6828a','d28ed814-526b-4077-99ec-a6cee0d6828a','tempest-support_any_az_share_type-164316432',1,NULL),('2026-01-21 14:11:39.918440',NULL,'2026-01-21 14:11:57.385038','d2a6f39a-4c8f-4196-8348-a04525553d5f','d2a6f39a-4c8f-4196-8348-a04525553d5f','tempest-typeshare-type-66234714',1,NULL),('2026-01-21 14:12:53.888295',NULL,'2026-01-21 14:13:14.471599','d412b829-d477-46b7-a489-e30be89cfea6','d412b829-d477-46b7-a489-e30be89cfea6','tempest-tempest-manila-1694524023',0,NULL),('2026-01-21 14:15:49.143635',NULL,'2026-01-21 14:16:12.422526','d54caddb-c1a6-4c3f-b2f9-7d1717fa702a','d54caddb-c1a6-4c3f-b2f9-7d1717fa702a','tempest-typeshare-type-1179470594',1,NULL),('2026-01-21 14:20:13.936909',NULL,'2026-01-21 14:20:17.289595','d6d924e7-25a0-4e6c-9279-2b6808552542','d6d924e7-25a0-4e6c-9279-2b6808552542','tempest-typeshare-type-1110395277',1,NULL),('2026-01-21 14:14:13.521877',NULL,'2026-01-21 14:14:42.372129','d714b627-a89b-463b-804f-ebe84408a229','d714b627-a89b-463b-804f-ebe84408a229','tempest-typeshare-type-1404786665',1,NULL),('2026-01-21 14:13:20.649264',NULL,'2026-01-21 14:14:25.196246','d763adfd-4693-4b03-ad1c-6cfad5db99b3','d763adfd-4693-4b03-ad1c-6cfad5db99b3','tempest-typeshare-type-1350772718',1,NULL),('2026-01-21 14:12:55.333068',NULL,'2026-01-21 14:13:06.238669','d81f794c-d08c-45dc-bbc9-511ee7439cc1','d81f794c-d08c-45dc-bbc9-511ee7439cc1','tempest-typeshare-type-414128193',1,NULL),('2026-01-21 14:16:15.082853',NULL,'2026-01-21 14:17:20.679894','ddce9437-41f6-41e1-9345-e8f73447a2bc','ddce9437-41f6-41e1-9345-e8f73447a2bc','tempest-typeshare-type-1020534566',1,NULL),('2026-01-21 14:11:01.179018',NULL,'2026-01-21 14:12:03.062079','de4f8dd5-59c7-4043-a6d2-b1a1fa120cc6','de4f8dd5-59c7-4043-a6d2-b1a1fa120cc6','tempest-typeshare-type-868761493',1,NULL),('2026-01-21 14:11:43.345509',NULL,'2026-01-21 14:11:56.310555','e03cfafd-6d82-4075-8e97-052efd572982','e03cfafd-6d82-4075-8e97-052efd572982','tempest-typeshare-type-1084006182',1,NULL),('2026-01-21 14:13:01.839994','2026-01-21 14:13:02.084928','2026-01-21 14:13:07.000201','e0b7cd58-7e56-43b9-8d5d-0714aeba3923','e0b7cd58-7e56-43b9-8d5d-0714aeba3923','tempest-tempest-manila-161432398',1,'Description for share type'),('2026-01-21 14:11:38.103271',NULL,'2026-01-21 14:11:58.287862','e3981754-2bfe-4dbc-a179-acf2f02c6ece','e3981754-2bfe-4dbc-a179-acf2f02c6ece','tempest-typeshare-type-1112445821',1,NULL),('2026-01-21 14:13:04.884308','2026-01-21 14:13:04.959406','2026-01-21 14:13:05.047835','e3c8823e-5eb9-4dae-a968-ccf2953e9e2f','e3c8823e-5eb9-4dae-a968-ccf2953e9e2f','tempest-tempest-manila-291653091',1,NULL),('2026-01-21 14:16:37.032170',NULL,'2026-01-21 14:17:53.144579','e930702d-a3b3-40a2-9f70-64fa8134ddf6','e930702d-a3b3-40a2-9f70-64fa8134ddf6','tempest-typeshare-type-1771481992',1,NULL),('2026-01-21 14:11:16.572996',NULL,'2026-01-21 14:11:17.370440','e972fe9d-ca2e-40da-aba1-cd2b5c6f5035','e972fe9d-ca2e-40da-aba1-cd2b5c6f5035','tempest-unique_st_name-1525691043',1,NULL),('2026-01-21 14:13:01.673329','2026-01-21 14:13:01.754605','2026-01-21 14:13:07.264121','e9be21a6-06c4-4646-9ebe-00b5664fe89d','e9be21a6-06c4-4646-9ebe-00b5664fe89d','tempest-tempest-manila-393909343',1,'description_updated'),('2026-01-21 14:12:54.567003',NULL,'2026-01-21 14:13:06.969486','ed730878-bd51-471b-bdd1-1f9be5254bb2','ed730878-bd51-471b-bdd1-1f9be5254bb2','tempest-typeshare-type-987906068',1,NULL),('2026-01-21 14:18:19.057452',NULL,'2026-01-21 14:18:34.081358','f78ae5cb-fced-4e97-b8cd-e69b71d0827c','f78ae5cb-fced-4e97-b8cd-e69b71d0827c','tempest-typeshare-type-733612223',1,NULL),('2026-01-21 14:24:24.892775',NULL,'2026-01-21 14:24:56.027751','f7db249e-6360-4f95-914d-c75a6989e840','f7db249e-6360-4f95-914d-c75a6989e840','tempest-typeshare-type-2040673441',1,NULL),('2026-01-21 14:14:52.541958',NULL,'2026-01-21 14:15:33.081053','f90ca7dd-2c72-49d1-9bfd-c7cfc1f6b718','f90ca7dd-2c72-49d1-9bfd-c7cfc1f6b718','tempest-share-type-1872404032',1,NULL),('2026-01-21 14:14:59.047400',NULL,'2026-01-21 14:15:08.906313','fa3be0f8-2dde-43f0-80c0-e2a4ba884d5b','fa3be0f8-2dde-43f0-80c0-e2a4ba884d5b','tempest-typeshare-type-1868221735',1,NULL),('2026-01-21 14:18:48.853558',NULL,'2026-01-21 14:19:46.775693','fce16d73-418d-491b-b08b-4701c62ff5bc','fce16d73-418d-491b-b08b-4701c62ff5bc','tempest-typeshare-type-2086285848',1,NULL),('2026-01-21 14:11:37.068406',NULL,'2026-01-21 14:11:59.333354','fdc63508-dc4f-4ae6-a43b-cdc0f9e32f3c','fdc63508-dc4f-4ae6-a43b-cdc0f9e32f3c','tempest-typeshare-type-304734510',1,NULL),('2026-01-21 14:12:57.665528',NULL,'2026-01-21 14:13:04.583951','fdc6db57-5ff6-455a-a2ab-20fbd091b679','fdc6db57-5ff6-455a-a2ab-20fbd091b679','tempest-typeshare-type-722024407',1,NULL),('2026-01-21 14:12:55.737532',NULL,'2026-01-21 14:13:05.818602','fee23a04-44b6-4b72-95ef-bed37f2d1630','fee23a04-44b6-4b72-95ef-bed37f2d1630','tempest-typeshare-type-220472961',1,NULL);
/*!40000 ALTER TABLE `share_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shares`
--

DROP TABLE IF EXISTS `shares`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shares` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `share_proto` varchar(255) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `snapshot_support` tinyint(1) DEFAULT NULL,
  `share_group_id` varchar(36) DEFAULT NULL,
  `source_share_group_snapshot_member_id` varchar(36) DEFAULT NULL,
  `task_state` varchar(255) DEFAULT NULL,
  `replication_type` varchar(255) DEFAULT NULL,
  `create_share_from_snapshot_support` tinyint(1) DEFAULT NULL,
  `revert_to_snapshot_support` tinyint(1) DEFAULT NULL,
  `mount_snapshot_support` tinyint(1) DEFAULT NULL,
  `is_soft_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `scheduled_to_be_deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_shares_share_group_id` (`share_group_id`),
  CONSTRAINT `fk_shares_share_group_id` FOREIGN KEY (`share_group_id`) REFERENCES `share_groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shares`
--

LOCK TABLES `shares` WRITE;
/*!40000 ALTER TABLE `shares` DISABLE KEYS */;
INSERT INTO `shares` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `size`, `display_name`, `display_description`, `snapshot_id`, `share_proto`, `is_public`, `snapshot_support`, `share_group_id`, `source_share_group_snapshot_member_id`, `task_state`, `replication_type`, `create_share_from_snapshot_support`, `revert_to_snapshot_support`, `mount_snapshot_support`, `is_soft_deleted`, `scheduled_to_be_deleted_at`) VALUES ('2026-01-21 14:17:50.973781','2026-01-21 14:17:57.286526','2026-01-21 14:17:57.286183','01a85aaf-b459-4ec1-81a3-8d27efbc9c48','01a85aaf-b459-4ec1-81a3-8d27efbc9c48','3f155a642cbe41c5a9ffda4ad895b42a','42d0f9e7ca75499fafa3885d62f2fa91',2,'tempest-tempest-created-share-65427163','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:10:20.869065','2026-01-21 14:12:12.244799','2026-01-21 14:12:12.244164','036723cc-3463-4bf3-a330-5b38b8f58ab6','036723cc-3463-4bf3-a330-5b38b8f58ab6','9f6fd3bf04e94f2d8e668d8e93cb0afa','81d0568612894d6da94e01a77bfde64f',1,'tempest-tempest-created-share-808337786','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:13:41.211360','2026-01-21 14:13:44.918233','2026-01-21 14:13:44.917521','0399260c-a060-46ea-bcae-f845b64ac843','0399260c-a060-46ea-bcae-f845b64ac843','6fc9e38a391d41b1bce34dc4cb926a6d','1812e512403748bd8d20cf83682d6ecb',1,'tempest-tempest-created-share-879310387','tempest-tempest-created-share-desc-649924013',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:11:26.072619','2026-01-21 14:12:04.524856','2026-01-21 14:12:04.523168','056ffbf5-e5ac-4f37-86c8-8cb3627cce73','056ffbf5-e5ac-4f37-86c8-8cb3627cce73','91a5b3e563184701bd5a4f2a997f8221','2806d215025845bc90e195f0b5c64c21',1,'tempest-tempest-created-share-2001512497','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:15:29.452412','2026-01-21 14:15:37.919246','2026-01-21 14:15:37.918774','073f2038-c750-4560-82ed-b9e3b4ba99e5','073f2038-c750-4560-82ed-b9e3b4ba99e5','47292555c1b142f8967d2205628edba1','a226ad4df79b48a2b4c6ddc1ed2cb474',1,'tempest-tempest-created-share-713429313','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:17:45.020818','2026-01-21 14:17:57.122308','2026-01-21 14:17:57.121936','099f5b0a-98b5-4972-ad30-abd6e3819995','099f5b0a-98b5-4972-ad30-abd6e3819995','847ff8e5688c42c1bb942b9ed884ef49','057c07904cd34efc9ceea6ab2d3e4d04',1,'tempest-tempest-created-share-1905338779','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:14:38.557563','2026-01-21 14:14:42.455224','2026-01-21 14:14:42.454733','0f20f2be-86ec-43cb-8ba5-0e7061804ec3','0f20f2be-86ec-43cb-8ba5-0e7061804ec3','1582fd57caf04d9188d3b72ecfc4ddd8','c55f56602b994198b2b9437533a437d7',1,'tempest-tempest-created-share-270626427','tempest-tempest-created-share-desc-171339347',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:18:24.104297','2026-01-21 14:18:28.940554','2026-01-21 14:18:28.940020','14534c4c-1b02-4468-8f33-545d362f0c63','14534c4c-1b02-4468-8f33-545d362f0c63','3f155a642cbe41c5a9ffda4ad895b42a','42d0f9e7ca75499fafa3885d62f2fa91',1,'tempest-tempest-created-share-1383440940','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:10:42.659718','2026-01-21 14:10:45.930450','2026-01-21 14:10:45.930002','157f3a2d-e430-41d6-ba23-49c652f8d4de','157f3a2d-e430-41d6-ba23-49c652f8d4de','9f6fd3bf04e94f2d8e668d8e93cb0afa','81d0568612894d6da94e01a77bfde64f',1,'tempest-tempest-created-share-1748330980','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:10:31.852306','2026-01-21 14:10:39.179395','2026-01-21 14:10:39.178901','18d6912a-f9cf-49cb-972f-a01b1c28918e','18d6912a-f9cf-49cb-972f-a01b1c28918e','9f6fd3bf04e94f2d8e668d8e93cb0afa','81d0568612894d6da94e01a77bfde64f',2,'tempest-tempest-created-share-1200816784','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:15:27.284274','2026-01-21 14:15:31.202513','2026-01-21 14:15:31.201993','18e262aa-85d0-4141-b91e-66da6fddace6','18e262aa-85d0-4141-b91e-66da6fddace6','1582fd57caf04d9188d3b72ecfc4ddd8','c55f56602b994198b2b9437533a437d7',1,'tempest-tempest-created-share-1444501233','tempest-tempest-created-share-desc-174706985',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:14:51.450590','2026-01-21 14:16:12.188418','2026-01-21 14:16:12.187961','1aabce1b-dbbb-4dae-a6a5-613066113ab2','1aabce1b-dbbb-4dae-a6a5-613066113ab2','47292555c1b142f8967d2205628edba1','a226ad4df79b48a2b4c6ddc1ed2cb474',1,'tempest-tempest-created-share-1828707790','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:15:01.154651','2026-01-21 14:15:16.820216','2026-01-21 14:15:16.819637','1dadb7a1-c595-48c0-8c20-61b9f6b86eb2','1dadb7a1-c595-48c0-8c20-61b9f6b86eb2','1582fd57caf04d9188d3b72ecfc4ddd8','c55f56602b994198b2b9437533a437d7',1,'tempest-tempest-created-share-2115755314','tempest-tempest-created-share-desc-426521992',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:16:04.247587','2026-01-21 14:16:08.677154','2026-01-21 14:16:08.676657','269f943c-b9aa-4c05-80a0-0a278a29a848','269f943c-b9aa-4c05-80a0-0a278a29a848','90415a0f3d4e49cba79c941b229a5421','4bd635a5dcc14e2b9d854dd0e78ecc0a',1,'tempest-tempest-new-share-name-1556067257','share is now updated',NULL,'CEPHFS',1,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:15:17.444910','2026-01-21 14:15:26.908641','2026-01-21 14:15:26.908167','2c754312-2184-4de2-a6bb-7fbb0fd69571','2c754312-2184-4de2-a6bb-7fbb0fd69571','1582fd57caf04d9188d3b72ecfc4ddd8','c55f56602b994198b2b9437533a437d7',1,'tempest-tempest-created-share-1331287038','tempest-tempest-created-share-desc-1383028646',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:13:45.747613','2026-01-21 14:13:50.020666','2026-01-21 14:13:50.020303','30854878-3900-4399-8036-f35b4759f865','30854878-3900-4399-8036-f35b4759f865','6fc9e38a391d41b1bce34dc4cb926a6d','1812e512403748bd8d20cf83682d6ecb',1,'tempest-tempest-created-share-646259574','tempest-tempest-created-share-desc-138711542',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:22:09.918666','2026-01-21 14:22:17.982042','2026-01-21 14:22:17.981514','368eadbe-e949-4a9e-9e1a-932072519f7f','368eadbe-e949-4a9e-9e1a-932072519f7f','67dae406f3fa410bac4003400c38ab9e','41d4aecafc20406482129223e7dd4624',2,'tempest-tempest-created-share-1032612926','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-21 14:14:55.665874','2026-01-21 14:15:00.047303','2026-01-21 14:15:00.046453','37fea2af-cb5f-4ce6-ad57-8e3fdf18c513','37fea2af-cb5f-4ce6-ad57-8e3fdf18c513','1582fd57caf04d9188d3b72ecfc4ddd8','c55f56602b994198b2b9437533a437d7',1,'tempest-tempest-created-share-1706893653','tempest-tempest-created-share-desc-1282910377',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:13:45.138662','2026-01-21 14:13:52.020546','2026-01-21 14:13:52.020087','3c665c41-2d99-4918-8898-968ff5d4b5b8','3c665c41-2d99-4918-8898-968ff5d4b5b8','18d829f19dd445aa98c02d30c005b747','498aac0871e5417786fbc3341cc80fbf',1,'tempest-tempest-created-share-1081995407','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:18:24.497756','2026-01-21 14:18:28.949745','2026-01-21 14:18:28.949285','3d3e1f20-6c20-4283-aa54-1405dbde1c68','3d3e1f20-6c20-4283-aa54-1405dbde1c68','847ff8e5688c42c1bb942b9ed884ef49','057c07904cd34efc9ceea6ab2d3e4d04',1,'tempest-tempest-created-share-1192311160','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:13:35.158450','2026-01-21 14:13:38.934306','2026-01-21 14:13:38.933535','3f2fb9c0-2e57-4d1b-8cf8-6074c5454331','3f2fb9c0-2e57-4d1b-8cf8-6074c5454331','6fc9e38a391d41b1bce34dc4cb926a6d','1812e512403748bd8d20cf83682d6ecb',1,'tempest-tempest-created-share-1687579940','tempest-tempest-created-share-desc-1414268343',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:20:29.325424','2026-01-21 14:20:57.188638','2026-01-21 14:20:57.188121','407b384e-148b-43f2-a5fb-b1e5aa164bd3','407b384e-148b-43f2-a5fb-b1e5aa164bd3','8f91d7fab0ee4a86a798bfda435f3ff4','265433c915284e308788d3048cf90078',1,'tempest-tempest-share-name-491022380','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:15:49.532915','2026-01-21 14:16:00.896040','2026-01-21 14:16:00.895662','45242132-b4fc-4649-a43e-b4fe5539da32','45242132-b4fc-4649-a43e-b4fe5539da32','1d9340b6b4b74f75b34a2b5167cb11c9','9706b90ceb3b46678324d74c1b285687',1,'public_share - must be visible to all projects in the cloud','public_share_desc',NULL,'CEPHFS',1,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:15:16.922193','2026-01-21 14:15:26.837786','2026-01-21 14:15:26.837255','498f15a0-21ee-49ad-8bf0-150074745f0c','498f15a0-21ee-49ad-8bf0-150074745f0c','47292555c1b142f8967d2205628edba1','a226ad4df79b48a2b4c6ddc1ed2cb474',1,'tempest-tempest-created-share-375232159','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:10:22.764838','2026-01-21 14:10:33.221242','2026-01-21 14:10:33.220383','4a078edd-e7cf-4d2f-8afc-c08793d660dd','4a078edd-e7cf-4d2f-8afc-c08793d660dd','c585b1d2d5d64ff09f12475b01bfdb96','25182f2d153d4140867b49ea0c5064d3',1,'tempest-tempest-created-share-1610653969','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:22:26.749074','2026-01-21 14:22:34.660854','2026-01-21 14:22:34.660300','4b663ce3-0e4f-46e1-9a65-29146bd45b68','4b663ce3-0e4f-46e1-9a65-29146bd45b68','67dae406f3fa410bac4003400c38ab9e','41d4aecafc20406482129223e7dd4624',1,'tempest-tempest-created-share-59838736','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-21 14:16:19.151531','2026-01-21 14:16:34.600385','2026-01-21 14:16:34.599817','5386cb7d-3729-4e52-b4c5-42215607272e','5386cb7d-3729-4e52-b4c5-42215607272e','9a2f0c528668499db7c5fb089f64e301','12f72ef945cc4adbb18b25d146f29e19',1,'tempest-tempest-created-share-1900888420','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:18:16.635501','2026-01-21 14:18:20.972901','2026-01-21 14:18:20.972512','5940feee-026c-404d-ad37-10cf7a1f2128','5940feee-026c-404d-ad37-10cf7a1f2128','3f155a642cbe41c5a9ffda4ad895b42a','42d0f9e7ca75499fafa3885d62f2fa91',1,'tempest-tempest-created-share-1837316583','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:14:25.974426','2026-01-21 14:14:30.094433','2026-01-21 14:14:30.094013','5d497481-daaf-4806-bc02-7a9b977bfe8c','5d497481-daaf-4806-bc02-7a9b977bfe8c','18d829f19dd445aa98c02d30c005b747','498aac0871e5417786fbc3341cc80fbf',1,'tempest-tempest-created-share-1277043088','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:17:33.121065','2026-01-21 14:18:36.031014','2026-01-21 14:18:36.030622','684e0b48-a2b0-4730-acfb-d81d371a3a68','684e0b48-a2b0-4730-acfb-d81d371a3a68','3f155a642cbe41c5a9ffda4ad895b42a','42d0f9e7ca75499fafa3885d62f2fa91',1,'tempest-tempest-share-name-747712821','tempest-tempest-share-description-410454362',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:16:42.274768','2026-01-21 14:17:46.640981','2026-01-21 14:17:46.640484','688d05e3-d534-4588-8ef1-588302e0580a','688d05e3-d534-4588-8ef1-588302e0580a','c9132702f2324cf7b8026c09a5d89dee','183d8c03d481485397037ffe17a60995',1,'tempest-tempest-created-share-1296253397','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-21 14:24:25.157807','2026-01-21 14:24:37.193666','2026-01-21 14:24:37.193290','6eb48da7-67ab-49fc-b63a-2af56663b79e','6eb48da7-67ab-49fc-b63a-2af56663b79e','37b3bbc0092f402c82354dc1111facd4','a4f094a58f4542e2ab299637736993f9',2,'tempest-tempest-created-share-212971132','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-21 14:12:16.743289','2026-01-21 14:12:21.061370','2026-01-21 14:12:21.060918','6eefd607-c1fc-4d82-a269-17cb0784b4c7','6eefd607-c1fc-4d82-a269-17cb0784b4c7','aba5fb7f48d64e01a3694378a50f9c54','91fa423674524226acfe253061607c0b',1,'tempest-tempest-created-share-1809901680','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:21:12.439945','2026-01-21 14:22:59.610993','2026-01-21 14:22:59.610485','70bc77af-7e50-4669-ba31-537c6a183e1f','70bc77af-7e50-4669-ba31-537c6a183e1f','67dae406f3fa410bac4003400c38ab9e','41d4aecafc20406482129223e7dd4624',1,'tempest-tempest-share-name-329990925','tempest-tempest-share-description-1768333746',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-21 14:25:06.725496','2026-01-21 14:25:19.732360','2026-01-21 14:25:19.731924','70d8a2e8-9754-4f37-bd26-0b4d171eeca4','70d8a2e8-9754-4f37-bd26-0b4d171eeca4','1168f378c75641a9a34467d731e79a9e','3ae1279c04024905bd21b77f8a95d5ae',1,'tempest-tempest-share-name-642079048','tempest-tempest-share-description-144468970',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-21 14:20:41.859223','2026-01-21 14:20:46.961710','2026-01-21 14:20:46.961332','70d9343f-5f35-46c7-ad39-1d03bcfc6faa','70d9343f-5f35-46c7-ad39-1d03bcfc6faa','8f91d7fab0ee4a86a798bfda435f3ff4','265433c915284e308788d3048cf90078',1,'tempest-tempest-share-name-531467844','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:19:07.421068',NULL,NULL,'False','7222a48c-e385-4ac8-9476-23ef2ccbfa6c','b01f23e1df1240dd9949216a2466ed8c','7be9e3a0119b40f692133210ebe5f9a2',1,'tempest-tempest-created-share-152544034','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:15:01.251439','2026-01-21 14:15:11.732984','2026-01-21 14:15:11.731261','72fbe20a-9dea-4a19-8d2c-fbf5fca1a08e','72fbe20a-9dea-4a19-8d2c-fbf5fca1a08e','691428d7711d49218388c97727044c76','28d69e0c83c84d03bcfbc4f9c9057023',1,'tempest-tempest-created-share-665669759','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:10:25.268388','2026-01-21 14:10:28.752543','2026-01-21 14:10:28.751004','751d6039-55f6-48ec-8c28-0b0ebaeb9d5b','751d6039-55f6-48ec-8c28-0b0ebaeb9d5b','9f6fd3bf04e94f2d8e668d8e93cb0afa','81d0568612894d6da94e01a77bfde64f',2,'tempest-tempest-created-share-1206938058','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:13:55.836396','2026-01-21 14:14:00.937764','2026-01-21 14:14:00.937074','78c2bfb4-61d4-432b-9ea3-5bfb830f3b03','78c2bfb4-61d4-432b-9ea3-5bfb830f3b03','6fc9e38a391d41b1bce34dc4cb926a6d','1812e512403748bd8d20cf83682d6ecb',1,'tempest-tempest-created-share-146502441','tempest-tempest-created-share-desc-1493092860',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:16:46.868976','2026-01-21 14:17:16.699345','2026-01-21 14:17:16.698602','7c0e94b3-fc54-45fc-a321-25827669641d','7c0e94b3-fc54-45fc-a321-25827669641d','9a2f0c528668499db7c5fb089f64e301','12f72ef945cc4adbb18b25d146f29e19',1,'tempest-tempest-created-share-610905033','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-21 14:17:08.175786','2026-01-21 14:17:12.676633','2026-01-21 14:17:12.676212','7f1408e7-914e-4693-903c-3d7ca7ce6766','7f1408e7-914e-4693-903c-3d7ca7ce6766','14b1b7ca69c94906ab006f47db3af123','3fdd89fc56bc4e1e80efe02dccfd1c88',1,'tempest-tempest-share-name-1592172107','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:13:55.024363','2026-01-21 14:14:00.821803','2026-01-21 14:14:00.821422','7fbe17a9-8106-4974-a0c0-060797971eae','7fbe17a9-8106-4974-a0c0-060797971eae','18d829f19dd445aa98c02d30c005b747','498aac0871e5417786fbc3341cc80fbf',1,'tempest-tempest-created-share-1700830423','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:14:12.371451','2026-01-21 14:14:19.539778','2026-01-21 14:14:19.539057','8473a94d-852b-4ce3-8f32-21882d9b901e','8473a94d-852b-4ce3-8f32-21882d9b901e','18d829f19dd445aa98c02d30c005b747','498aac0871e5417786fbc3341cc80fbf',1,'tempest-tempest-created-share-1646736873','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:13:50.995222','2026-01-21 14:13:54.689723','2026-01-21 14:13:54.689195','84744f0f-3821-4ef8-81d7-2f297251eeda','84744f0f-3821-4ef8-81d7-2f297251eeda','6fc9e38a391d41b1bce34dc4cb926a6d','1812e512403748bd8d20cf83682d6ecb',1,'tempest-tempest-created-share-1467573217','tempest-tempest-created-share-desc-1052238816',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:17:22.173760','2026-01-21 14:17:39.108457','2026-01-21 14:17:39.107301','87161409-8bb7-4318-a754-72802d038d2f','87161409-8bb7-4318-a754-72802d038d2f','53e1b03c59294270a311e7426f54bef6','6b53653c238d45b18082508e065d099c',1,'tempest-tempest-created-share-662964445','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:18:17.276754','2026-01-21 14:18:21.191585','2026-01-21 14:18:21.191162','8a0ee85c-28b4-48fa-a44e-9cb6516391d3','8a0ee85c-28b4-48fa-a44e-9cb6516391d3','847ff8e5688c42c1bb942b9ed884ef49','057c07904cd34efc9ceea6ab2d3e4d04',1,'tempest-tempest-created-share-2080117498','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:17:15.824889','2026-01-21 14:17:20.011917','2026-01-21 14:17:20.011545','8f836eb8-08c0-452d-81ff-f53f9bda94b5','8f836eb8-08c0-452d-81ff-f53f9bda94b5','6cb2e0df2e5e4f68acb0a95b2439997b','e5bede18d60e4bb389fabc44847d9a1a',1,'tempest-tempest-share-name-237477536','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:17:43.408686','2026-01-21 14:17:47.649968','2026-01-21 14:17:47.649601','91279f1f-f7d7-4658-ba1b-77828dd85ad2','91279f1f-f7d7-4658-ba1b-77828dd85ad2','3f155a642cbe41c5a9ffda4ad895b42a','42d0f9e7ca75499fafa3885d62f2fa91',1,'tempest-tempest-created-share-1699173109','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:12:49.829997','2026-01-21 14:13:15.250744','2026-01-21 14:13:15.250178','9969199e-c110-4822-a15e-3778a83fe39c','9969199e-c110-4822-a15e-3778a83fe39c','a0672e98f4144413a0f7f662605555ca','5da033845de7469096a0943fc3046311',1,'tempest-share-1015072507','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:15:53.351884','2026-01-21 14:15:57.396683','2026-01-21 14:15:57.396278','9f297125-ba6b-4bf8-bdcd-ba79f70cf48e','9f297125-ba6b-4bf8-bdcd-ba79f70cf48e','90415a0f3d4e49cba79c941b229a5421','4bd635a5dcc14e2b9d854dd0e78ecc0a',1,'private_share','private share in the primary user project',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:16:55.838659','2026-01-21 14:17:09.853208','2026-01-21 14:17:09.852793','a2f00a33-a7b2-4e3d-a950-1bec6b8c16c5','a2f00a33-a7b2-4e3d-a950-1bec6b8c16c5','9a2f0c528668499db7c5fb089f64e301','12f72ef945cc4adbb18b25d146f29e19',1,'tempest-tempest-created-share-981339480','Tempest\'s share','fb763622-636c-421d-a618-54f14cb70a37','CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-21 14:16:38.885877','2026-01-21 14:16:43.340688','2026-01-21 14:16:43.340305','a46b1a94-810e-46d9-8210-a58533c70b5a','a46b1a94-810e-46d9-8210-a58533c70b5a','9a2f0c528668499db7c5fb089f64e301','12f72ef945cc4adbb18b25d146f29e19',1,'tempest-tempest-created-share-690621183','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:11:03.186823','2026-01-21 14:11:13.709742','2026-01-21 14:11:13.709061','a561393a-d080-4ae1-ab47-796e34de4fb1','a561393a-d080-4ae1-ab47-796e34de4fb1','eabd986b9e274262a34ffc9cdfc09733','50bb744aaa0a40ecbfeaa20d4e691f46',4,'tempest-tempest-created-share-1318210271','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:20:37.572649','2026-01-21 14:20:50.357267','2026-01-21 14:20:50.356824','a97b8cff-7809-490b-a244-8dd0e34e7ef5','a97b8cff-7809-490b-a244-8dd0e34e7ef5','8f91d7fab0ee4a86a798bfda435f3ff4','265433c915284e308788d3048cf90078',1,'tempest-tempest-share-name-1596276340','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:15:08.997232','2026-01-21 14:15:12.961575','2026-01-21 14:15:12.960943','ac96fc6c-01cf-4118-aff0-f8a200342bf0','ac96fc6c-01cf-4118-aff0-f8a200342bf0','1582fd57caf04d9188d3b72ecfc4ddd8','c55f56602b994198b2b9437533a437d7',1,'tempest-tempest-created-share-11698134','tempest-tempest-created-share-desc-264865471',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:23:26.763404','2026-01-21 14:23:52.087160','2026-01-21 14:23:52.086517','b0c80a60-09de-4bf8-8210-d9e7065bb4bd','b0c80a60-09de-4bf8-8210-d9e7065bb4bd','40585f18d2e84161b8eca432bf37306f','18bcd7a466594b3abec112774943eca1',1,'tempest-tempest-new-name-1675773020','tempest-tempest-new-description-1590742921',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:16:51.889325','2026-01-21 14:17:42.663040','2026-01-21 14:17:42.662477','b1af7887-8549-4ad6-8f39-3d20abb6170a','b1af7887-8549-4ad6-8f39-3d20abb6170a','53e1b03c59294270a311e7426f54bef6','6b53653c238d45b18082508e065d099c',1,'tempest-tempest-created-share-865125680','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-21 14:12:30.983633','2026-01-21 14:12:36.536150','2026-01-21 14:12:36.534872','b526118c-476f-4240-99b7-711476531384','b526118c-476f-4240-99b7-711476531384','561f676f9fd94b9f83b47172d27f8e4d','8ea8a62d6efd4fdcac316c24e39fb155',1,'tempest-tempest-created-share-119982924','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:14:59.503777','2026-01-21 14:15:12.743340','2026-01-21 14:15:12.742731','ba13b15f-cf4d-49e6-8796-991bdc13606f','ba13b15f-cf4d-49e6-8796-991bdc13606f','47292555c1b142f8967d2205628edba1','a226ad4df79b48a2b4c6ddc1ed2cb474',1,'tempest-tempest-created-share-613969644','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:24:40.236529','2026-01-21 14:24:53.455623','2026-01-21 14:24:53.455146','ba38a422-131c-4c1e-8d0d-119a6f068d6a','ba38a422-131c-4c1e-8d0d-119a6f068d6a','37b3bbc0092f402c82354dc1111facd4','a4f094a58f4542e2ab299637736993f9',1,'tempest-tempest-created-share-748831709','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-21 14:13:26.565160','2026-01-21 14:14:13.735343','2026-01-21 14:14:13.734764','bf3f919b-8c4d-4a4b-ba98-44d0f3aac87a','bf3f919b-8c4d-4a4b-ba98-44d0f3aac87a','111328e7e8c9499f9dd897f7f644b965','79952fad07e54cf18c5f2c207bdbf9fb',1,'tempest-tempest-share-name-1387870556','tempest-tempest-share-description-74621568','09b94b8f-18fe-41bc-bc29-2dce63cc4501','CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-21 14:11:07.631390','2026-01-21 14:11:17.087311','2026-01-21 14:11:17.086798','c80c0fc3-4bc7-4598-a0d4-d69daf2fd776','c80c0fc3-4bc7-4598-a0d4-d69daf2fd776','eabd986b9e274262a34ffc9cdfc09733','50bb744aaa0a40ecbfeaa20d4e691f46',3,'tempest-tempest-created-share-754391501','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:10:54.973333','2026-01-21 14:11:00.115629','2026-01-21 14:11:00.115123','c8d2e256-38ca-48f6-94ba-6ee388f70097','c8d2e256-38ca-48f6-94ba-6ee388f70097','9f6fd3bf04e94f2d8e668d8e93cb0afa','81d0568612894d6da94e01a77bfde64f',1,'tempest-tempest-created-share-1162860555','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:16:37.624001','2026-01-21 14:17:50.666489','2026-01-21 14:17:50.665937','ca6daf26-9831-4772-bcf0-7b69e0070af8','ca6daf26-9831-4772-bcf0-7b69e0070af8','c9132702f2324cf7b8026c09a5d89dee','183d8c03d481485397037ffe17a60995',1,'tempest-tempest-created-share-1310451009','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:17:48.840236','2026-01-21 14:17:52.919355','2026-01-21 14:17:52.918797','cacacb68-f5cc-4781-bc3e-01f1c20a372b','cacacb68-f5cc-4781-bc3e-01f1c20a372b','847ff8e5688c42c1bb942b9ed884ef49','057c07904cd34efc9ceea6ab2d3e4d04',1,'tempest-tempest-created-share-1134492867','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:18:19.265899','2026-01-21 14:18:30.921672','2026-01-21 14:18:30.921302','cae1b4e3-e1c6-4069-8095-973e2efe7b2e','cae1b4e3-e1c6-4069-8095-973e2efe7b2e','4a2fe10fc9e348b7882f646ffc46378a','3cc89d84bffa401eab10c32a2f4b29d2',1,'tempest-tempest-created-share-1478167427','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:14:10.332726','2026-01-21 14:14:22.396030','2026-01-21 14:14:22.395638','d05f4623-92be-4e54-b528-ddbb8752adb2','d05f4623-92be-4e54-b528-ddbb8752adb2','0f49b0d1ba944c46946a092657f6b0f2','d8fea3bdb3ee4c03a1197b6e46ed71bc',1,'tempest-tempest-created-share-1597346306','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:13:41.564802','2026-01-21 14:14:37.378201','2026-01-21 14:14:37.377794','d2064608-c39f-4121-8bf3-57367d234998','d2064608-c39f-4121-8bf3-57367d234998','18d829f19dd445aa98c02d30c005b747','498aac0871e5417786fbc3341cc80fbf',1,'tempest-tempest-created-share-994912656','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:14:42.979371','2026-01-21 14:14:47.020215','2026-01-21 14:14:47.019660','d9a40d08-858b-4fe0-8d78-6d99497a249f','d9a40d08-858b-4fe0-8d78-6d99497a249f','1582fd57caf04d9188d3b72ecfc4ddd8','c55f56602b994198b2b9437533a437d7',1,'tempest-tempest-created-share-1545044138','tempest-tempest-created-share-desc-1096385426',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:14:59.577175','2026-01-21 14:15:05.809378','2026-01-21 14:15:05.808800','e0d7e609-a29b-4fb3-ba97-e5984dc35087','e0d7e609-a29b-4fb3-ba97-e5984dc35087','29824244ca994d38a91f46f7cb52ca0f','ef367d46915e42899003255d11c5ebdd',1,'tempest-tempest-created-share-1417391561','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:16:27.239943','2026-01-21 14:16:36.372002','2026-01-21 14:16:36.371638','e26f4411-d608-4767-8300-5651275fd6c4','e26f4411-d608-4767-8300-5651275fd6c4','9618fae463a3456ab00f4dd42464d5b5','00ad6a9aaa7a46e98273aa36df95068c',1,'public_share','public_share_desc',NULL,'CEPHFS',1,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:14:13.818608','2026-01-21 14:14:39.731085','2026-01-21 14:14:39.730580','e556b944-c601-4d6a-9a44-72d806af4101','e556b944-c601-4d6a-9a44-72d806af4101','b4c32c9c7b1047fc890e37a5372183aa','42f926cfde224068a742ef536ed79928',1,'tempest-tempest-created-share-2062668854','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:14:48.234030','2026-01-21 14:15:00.483726','2026-01-21 14:15:00.483286','e74a9198-b8ec-4c66-8843-e247a2163eda','e74a9198-b8ec-4c66-8843-e247a2163eda','1582fd57caf04d9188d3b72ecfc4ddd8','c55f56602b994198b2b9437533a437d7',1,'tempest-tempest-created-share-1771398255','tempest-tempest-created-share-desc-232670587',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:21:19.817999','2026-01-21 14:22:52.582736','2026-01-21 14:22:52.581950','e93e4111-7c93-41b8-8ba6-a67aecdc9a85','e93e4111-7c93-41b8-8ba6-a67aecdc9a85','67dae406f3fa410bac4003400c38ab9e','41d4aecafc20406482129223e7dd4624',1,'tempest-tempest-share-name-1817081430','tempest-tempest-share-description-1972083550','717877ed-ee59-4b6f-a8b8-a5e824a0e143','CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-21 14:11:21.293996','2026-01-21 14:12:08.670160','2026-01-21 14:12:08.669729','eb470898-ab04-4f3a-a04b-e77ceb023449','eb470898-ab04-4f3a-a04b-e77ceb023449','91a5b3e563184701bd5a4f2a997f8221','2806d215025845bc90e195f0b5c64c21',1,'tempest-tempest-created-share-706881536','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:10:23.522871','2026-01-21 14:10:31.587681','2026-01-21 14:10:31.587182','f101d908-567e-4304-b028-50ff6e482c84','f101d908-567e-4304-b028-50ff6e482c84','88612755fd4c490c96b9c4b454fc53d5','e17b908e218c4cd78e47e6be458b89a4',1,'tempest-tempest-created-share-1935304355','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:12:40.332174','2026-01-21 14:12:59.843731','2026-01-21 14:12:59.843249','f3049aa0-1e31-4c57-bea3-c4cb3a5c1ba7','f3049aa0-1e31-4c57-bea3-c4cb3a5c1ba7','296b3ba1092e47d48708162556c13492','8f23a9ff8e6249a7b232ba280b7bee1d',1,'tempest-tempest-created-share-2073111849','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:15:05.275482','2026-01-21 14:15:13.341010','2026-01-21 14:15:13.340404','f43ad296-d798-4b0d-a20a-11bd1a371881','f43ad296-d798-4b0d-a20a-11bd1a371881','1582fd57caf04d9188d3b72ecfc4ddd8','c55f56602b994198b2b9437533a437d7',1,'tempest-tempest-created-share-1918873747','tempest-tempest-created-share-desc-159565689',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:14:04.186855','2026-01-21 14:14:08.937810','2026-01-21 14:14:08.937283','f67386cf-d1ad-458d-a3f9-c5a2653692fc','f67386cf-d1ad-458d-a3f9-c5a2653692fc','18d829f19dd445aa98c02d30c005b747','498aac0871e5417786fbc3341cc80fbf',1,'tempest-tempest-created-share-581964537','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:13:38.732724','2026-01-21 14:13:58.661828','2026-01-21 14:13:58.661275','f7f2a070-b60a-4b51-878d-5e40e7a13a72','f7f2a070-b60a-4b51-878d-5e40e7a13a72','54bd2d99c737409a8cdb47d0ef61c0af','bf58a5c191654263a44f73287e2a242e',1,'tempest-tempest-created-share-661400057','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:22:43.105591','2026-01-21 14:22:48.947429','2026-01-21 14:22:48.946784','f9cd06dc-fd20-4cfe-8013-3dd5c1e3307e','f9cd06dc-fd20-4cfe-8013-3dd5c1e3307e','67dae406f3fa410bac4003400c38ab9e','41d4aecafc20406482129223e7dd4624',1,'tempest-tempest-created-share-1736140013','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-21 14:18:49.093417','2026-01-21 14:19:43.425458','2026-01-21 14:19:43.425056','fa3c3ca4-ee78-4359-90c1-d7c6060a822d','fa3c3ca4-ee78-4359-90c1-d7c6060a822d','51daa32984f24d90b50a4cba851c93da','3efc5d38bf75484d9e4b2aed22003264',1,'tempest-tempest-share-name-199206810','tempest-tempest-share-description-736700062',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-21 14:15:22.426043','2026-01-21 14:15:26.309400','2026-01-21 14:15:26.309018','fab0fdf5-9fef-4cce-a2ee-7832c9376c39','fab0fdf5-9fef-4cce-a2ee-7832c9376c39','1582fd57caf04d9188d3b72ecfc4ddd8','c55f56602b994198b2b9437533a437d7',1,'tempest-tempest-created-share-1844179341','tempest-tempest-created-share-desc-417173990',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:18:00.423980','2026-01-21 14:18:11.915155','2026-01-21 14:18:11.914722','fb08a62f-fd73-4321-8a32-ef0d0454f815','fb08a62f-fd73-4321-8a32-ef0d0454f815','3f155a642cbe41c5a9ffda4ad895b42a','42d0f9e7ca75499fafa3885d62f2fa91',1,'tempest-tempest-created-share-2028723656','Tempest\'s share',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:15:36.958024','2026-01-21 14:19:22.935144','2026-01-21 14:19:22.934602','fc256f6b-1503-4a6e-8c37-1daea3157b6f','fc256f6b-1503-4a6e-8c37-1daea3157b6f','920083400adf4bf88354be8bd2e50ba1','7be9e3a0119b40f692133210ebe5f9a2',1,'tempest-tempest-created-share-65477451','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL),('2026-01-21 14:13:20.879609','2026-01-21 14:14:21.964678','2026-01-21 14:14:21.964087','fc76ee87-f013-4833-92c5-4c98f6ef4c19','fc76ee87-f013-4833-92c5-4c98f6ef4c19','111328e7e8c9499f9dd897f7f644b965','79952fad07e54cf18c5f2c207bdbf9fb',1,'tempest-tempest-share-name-667534337','tempest-tempest-share-description-1170251620',NULL,'CEPHFS',0,1,NULL,NULL,NULL,NULL,1,0,0,0,NULL),('2026-01-21 14:20:33.612177','2026-01-21 14:20:53.745578','2026-01-21 14:20:53.745213','fdcf3635-f7ea-4eb3-943e-64e6fa02cf1a','fdcf3635-f7ea-4eb3-943e-64e6fa02cf1a','8f91d7fab0ee4a86a798bfda435f3ff4','265433c915284e308788d3048cf90078',1,'tempest-tempest-share-name-2007117055','Tempest\'s share',NULL,'CEPHFS',0,0,NULL,NULL,NULL,NULL,0,0,0,0,NULL);
/*!40000 ALTER TABLE `shares` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `resource_id` varchar(36) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime(6) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
INSERT INTO `transfers` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `resource_id`, `resource_type`, `display_name`, `salt`, `crypt_hash`, `expires_at`, `source_project_id`, `destination_project_id`, `accepted`) VALUES ('0b058408-f39b-4a6c-8ab3-e98be0715d69','2026-01-21 14:20:40.905816',NULL,'2026-01-21 14:20:41.389999','0b058408-f39b-4a6c-8ab3-e98be0715d69','a97b8cff-7809-490b-a244-8dd0e34e7ef5','share','tempest-tempest-created-share-transfer-992890640','220b9525','3afec52a6da4a8bebb830a3a695ab058c38e905930aef98839cb486064944b38','2026-01-21 14:25:40.904127','265433c915284e308788d3048cf90078',NULL,0),('1fa79439-d2e5-42bf-98ac-98ff73779e33','2026-01-21 14:20:45.353030',NULL,'2026-01-21 14:20:45.645890','1fa79439-d2e5-42bf-98ac-98ff73779e33','70d9343f-5f35-46c7-ad39-1d03bcfc6faa','share','tempest-tempest-created-share-transfer-1494802699','06bdc5c8','6efa3eecb946e42df4d52ef7d20cdb46934240af69fb7788d65393924954f427','2026-01-21 14:25:45.350335','265433c915284e308788d3048cf90078',NULL,0),('3b1b78d2-db2b-4a43-b1ad-7526823f60a2','2026-01-21 14:20:36.991130',NULL,'2026-01-21 14:20:37.277013','3b1b78d2-db2b-4a43-b1ad-7526823f60a2','fdcf3635-f7ea-4eb3-943e-64e6fa02cf1a','share','tempest-tempest-created-share-transfer-635762380','12a301d2','0763f571c6b7bc302dc28e5c8dc0ea74db826ef55b49f3713335ccefc03a6df4','2026-01-21 14:25:36.989948','265433c915284e308788d3048cf90078',NULL,0),('6ed3eab5-c973-4382-b3bf-39df7fc1de0e','2026-01-21 14:20:32.867729',NULL,'2026-01-21 14:20:33.331067','6ed3eab5-c973-4382-b3bf-39df7fc1de0e','407b384e-148b-43f2-a5fb-b1e5aa164bd3','share','tempest-tempest-created-share-transfer-134927087','88fed1e0','3190acbf1b6175e7163360cdd0cf6ef5145dafbc3d1f836abbe64e8826465764','2026-01-21 14:25:32.866141','265433c915284e308788d3048cf90078',NULL,0),('8fc3a6bd-5aeb-4421-8f25-7d6b247e9567','2026-01-21 14:17:19.175836',NULL,'2026-01-21 14:17:19.465955','8fc3a6bd-5aeb-4421-8f25-7d6b247e9567','8f836eb8-08c0-452d-81ff-f53f9bda94b5','share','tempest_share_transfer','03bb2341','57dcfee3514db47c0409470d046e9e080cbaa911baa2152e0fe6623e28f1ad2e','2026-01-21 14:22:19.174420','e5bede18d60e4bb389fabc44847d9a1a',NULL,0),('d66f5998-778f-4825-b5fb-a8b400329587','2026-01-21 14:17:11.520256','2026-01-21 14:17:12.119533','2026-01-21 14:17:12.119530','1','7f1408e7-914e-4693-903c-3d7ca7ce6766','share','tempest-tempest-created-share-transfer-1696841195','081a981d','14f152ed19796da998a34c0c1fd9abf5835f54b0ee9813859d68a0f0a7612a1f','2026-01-21 14:22:11.517887','e5bede18d60e4bb389fabc44847d9a1a','3fdd89fc56bc4e1e80efe02dccfd1c88',1);
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','keystone','keystone_93be','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_93be','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','placement','placement_6593','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_6593','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','glance','glance_878b','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_878b','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_4ddb','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_4ddb','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_9e31','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_9e31','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_b5ae','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_b5ae','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_ca0c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_ca0c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_54c0','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_54c0','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','manila','manila_eb24','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','manila','manila_eb24','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1769002122}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1769002122}'),('localhost','keystone_93be','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*446BD287402354CED172ECDD4512CA77380FD10B\",\"password_last_changed\":1769002111}'),('%','keystone_93be','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*446BD287402354CED172ECDD4512CA77380FD10B\",\"password_last_changed\":1769002111}'),('localhost','placement_6593','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*9BCF2351950E9DBDE01514BB9BDD9207E1F73433\",\"password_last_changed\":1769002112}'),('%','placement_6593','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*9BCF2351950E9DBDE01514BB9BDD9207E1F73433\",\"password_last_changed\":1769002112}'),('localhost','glance_878b','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B6BAE9607F2A4460E31A0F79CD8A5EABAC3736B2\",\"password_last_changed\":1769002122}'),('%','glance_878b','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B6BAE9607F2A4460E31A0F79CD8A5EABAC3736B2\",\"password_last_changed\":1769002122}'),('localhost','barbican_4ddb','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B107F560ABE8CDEAF375948EA5DDB7AC0E236E3C\",\"password_last_changed\":1769002152}'),('%','barbican_4ddb','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B107F560ABE8CDEAF375948EA5DDB7AC0E236E3C\",\"password_last_changed\":1769002152}'),('localhost','neutron_9e31','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*E39BDB13A7B9B988DBDAD7FC8CF5E398349877E9\",\"password_last_changed\":1769002152}'),('%','neutron_9e31','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*E39BDB13A7B9B988DBDAD7FC8CF5E398349877E9\",\"password_last_changed\":1769002152}'),('localhost','cinder_b5ae','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*3619FE6A08628376AAAA6BB1F1F15858F02A852F\",\"password_last_changed\":1769002153}'),('%','cinder_b5ae','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*3619FE6A08628376AAAA6BB1F1F15858F02A852F\",\"password_last_changed\":1769002153}'),('localhost','nova_api_ca0c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*850CE98C29AB4DAA08D7EDBE1FFD9F191F35177D\",\"password_last_changed\":1769002304}'),('%','nova_api_ca0c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*850CE98C29AB4DAA08D7EDBE1FFD9F191F35177D\",\"password_last_changed\":1769002304}'),('localhost','nova_cell0_54c0','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*19D90E5D8F7F209006C2F793B730EE244E013496\",\"password_last_changed\":1769002304}'),('%','nova_cell0_54c0','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*19D90E5D8F7F209006C2F793B730EE244E013496\",\"password_last_changed\":1769002304}'),('localhost','manila_eb24','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*1C471AC0D7A1E5A2F53F9221817B0ADD66BD7F83\",\"password_last_changed\":1769004235}'),('%','manila_eb24','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*1C471AC0D7A1E5A2F53F9221817B0ADD66BD7F83\",\"password_last_changed\":1769004235}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mysql_plugin\n----------------------------