/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `aodh`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `aodh` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `aodh`;

--
-- Table structure for table `alarm`
--

DROP TABLE IF EXISTS `alarm`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alarm` (
  `alarm_id` varchar(128) NOT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `name` text DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `severity` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `timestamp` datetime(6) DEFAULT NULL,
  `user_id` varchar(128) DEFAULT NULL,
  `project_id` varchar(128) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `state_reason` text DEFAULT NULL,
  `state_timestamp` datetime(6) DEFAULT NULL,
  `ok_actions` text DEFAULT NULL,
  `alarm_actions` text DEFAULT NULL,
  `insufficient_data_actions` text DEFAULT NULL,
  `repeat_actions` tinyint(1) DEFAULT NULL,
  `rule` text DEFAULT NULL,
  `time_constraints` text DEFAULT NULL,
  `evaluate_timestamp` datetime DEFAULT NULL,
  PRIMARY KEY (`alarm_id`),
  KEY `ix_alarm_user_id` (`user_id`),
  KEY `ix_alarm_enabled` (`enabled`),
  KEY `ix_alarm_type` (`type`),
  KEY `ix_alarm_project_id` (`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alarm`
--

LOCK TABLES `alarm` WRITE;
/*!40000 ALTER TABLE `alarm` DISABLE KEYS */;
/*!40000 ALTER TABLE `alarm` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alarm_history`
--

DROP TABLE IF EXISTS `alarm_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alarm_history` (
  `event_id` varchar(128) NOT NULL,
  `alarm_id` varchar(128) DEFAULT NULL,
  `on_behalf_of` varchar(128) DEFAULT NULL,
  `project_id` varchar(128) DEFAULT NULL,
  `user_id` varchar(128) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `detail` text DEFAULT NULL,
  `timestamp` datetime(6) DEFAULT NULL,
  `severity` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`event_id`),
  KEY `ix_alarm_history_alarm_id` (`alarm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alarm_history`
--

LOCK TABLES `alarm_history` WRITE;
/*!40000 ALTER TABLE `alarm_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `alarm_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('007');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota`
--

DROP TABLE IF EXISTS `quota`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(128) DEFAULT NULL,
  `resource` varchar(50) DEFAULT NULL,
  `limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`),
  KEY `ix_quota_project_id_resource` (`project_id`,`resource`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota`
--

LOCK TABLES `quota` WRITE;
/*!40000 ALTER TABLE `quota` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
INSERT INTO `encrypted_data` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `content_type`, `secret_id`, `kek_id`, `cypher_text`, `kek_meta_extended`) VALUES ('02b2e76e-572f-4f27-be27-36683c8f70b2','2025-12-03 22:55:30','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'ACTIVE','application/octet-stream','e866b0f1-43b8-4fbc-bfc8-69efa1cb413b','f4d729f3-c7b8-48a7-b624-6cecd66d98de','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',NULL),('0bcb4c24-48be-43d8-a0bb-aee510d851fb','2025-12-03 22:55:05','2025-12-03 22:55:56','2025-12-03 22:55:56',1,'ACTIVE','application/octet-stream','1af1e6b9-59a9-4d7c-9ac7-781176e8ea73','6a8d3b7d-b9d7-4fa8-9497-0eb698e64727','Z0FBQUFBQnBNTF9KbVlUUnNwc2xiaE5Mc3hWazRmZXBqUm9LSnZfZUozQURZWU9pZDNIOXB4Zk9JUXJVYVRYVzhSejV4NEZWb0JZdFg4YTR6VW9VdkltTVhLRlEtWFByUGh0T2xVN2JuZ1FtQU5vNFRjendudG0yZy1YeEVuMTNGUWVtdTZsOGpvUDNtcVRwWTVmUFBKQnpWcWVBaEFac0FhNW5iSzQzb1NXd0QyQ2JoS1R4LWlRN29hNExWM2ZjbVROWFh6Q1VXd1F5Mi16U0ZzNXN0NGFnRTROa1BjLTRVekU4ZThidlJLdmZxVWdCcU8tVkpWdmdJVjFNbnltaXBzTmhWWDhBeWt3R3hxSm5IRGpvS0IxbFhnemVjQlFWcTR5OUtyb1BxN19kR3IzejVScGRjUUhkQ3RzUnl2bjBseXhfLUNYbzVsbzNpYUlBaHdIMk9fOWR4RlRfTjZHZS1ZR3NRQ1BlSkFJSm5nZDBScWZNMkFkWVN0czh5UTVXSE4tMndWSXFqQ1VBZUVuLU05dTM4MmIwV3NlLW1YQUt2YWphaUJfS3JkWEtHQnBna3pvZ2lGVHV2VkNSNEt2WWJKZmo0UWFYQWR3b2dJTm5SSnpDV0Rza21ZOE90WEdmTnk0NEt4LXdYYzNDS01OWkVGVXJocHFHZ3ZGTXdwaTJLUTNnSks0bi1lYm04SGtZR2xsN0c0SXBWUks5bmU0ZDZ2Y1lDb21LalRDVTd2V05uWGYxaW40VTdzd1lFazZ6Qm5wNDhBai1RQzRJcFNVNmJpS0ZLaG5tNWd1VFMtQkhJdjljYnM1VFpRaml1bkpyNDh1LXZaUnBER1lqWmo0SHpEQ3BMX2FlczRmUFE2LUZ6WDZIVnVSa0dsX2l3V2dtd2RkaWZxVTBQZTZaZG5XOHR5ZTRjWTIyN1R5N0JsejFXQkxORHB3bF9HRzhab3B6d3JzVkRXS0FkTFVhLWRrdXgtM1ljU3lFSDlubnF1UGRyQ0pEa3d0N3VNalRnSVlqeXlFaEF2RHZONm1qNFN4bzZOOXFSX3NDM0tFMzExNzAzRk96SFM2QmZPcjRpX2J5VmM3YTIwUHBlQnRBNlo1cTkwN05YYkEtUV9XRVV4Qk1nbkxNYTNLVzMtX1BGazRoVDEtWDNLZE5zZ2JCSjBQRjZYRmNaei1rSlpDbFcxTTlxS1JyOFpNOGQ3WUV6ZkFXdVROZWhZYVVMa3JJMFNtZXBpT2NJdmlTZHd4aWRPZ0xHN193WEtWcy1iTEtfb2NxRVRybmFJVUk5bmxVaWxMbTliTU8yRHFCNlJ5R0kxb2tmeGoyRG5kbTlzclpFWVI3Vl8zbnZCTUx6Sk1fRERzSEhHeE5feWZCblZSdkc1Qi1McmM1c2s4Q2RCQm40bnBjYnc1Y3JDal9USE5PSlBLZ09RV1dUdzdTbTBjUkFMYlVBYmk2Tld2cDFENTc1T2Rucnl5SWNuaDhENFBLQTc3UWlNaVViZnV5SG12RDZJSFRPZzF1cVFxa2VkRWpObFdHekxjV1BBXzhWQllJeVAxWnJIU19DUXc5WDdsdGV3a0ZqV3hyaU9zZ01HQkluRTdnd1RveDBDZkhuNm1GV085bmJxcnV2MF9TaVNyYndoLTBrcXlWTDBvcmZSelFBWUxyeUtqRF9vLVl4ZVVUZzIzNEhDanQ3OEppYzVTa2ZNYnlRSlJfSlRGVjlTaXdRX1lFMC1sSjZENmw2U1RWVkdOOTlvbkFiNkdFTVV5ZWthcDl4N3g4M3RYQ1BvZGVoWWtCTzdQUUtza01HOWM0b2l5QlEtN2tNN2RHbDl6eEFjbG5kd004Vk81dUs4M3hiVlJTeWc4Wnd4NWpQTjJtUVpjM2x0ZThjNzVtYzF0Y2xvbW5wYmdscEVKTk5FMGRVMDZNOGExeXlRNXY2SWlwTlo0QUVUaGFrd1N5WGRRc3g1U1ZtbWR3VEctS0J6Rmg3SmNHUWNqRlpkbGhCanBmemVQNWVXX0N5SGFEUW41TFhyMU13S2E1TVRvOUw1M0xFamlnelBGWTlGblpaUTU3djV6MzhSeFlKY1djcGRMVlQ3ZUFJVWFva0g2Y0dScktjRl9HNElGOFhuM1ZDZGlCeU4weEc3enliT055QWR4NUJid3NnLS1ZcW5zTXM4TUpvMDlJUkdVWXI0LVdYZHZKSEZ3aDJZSElteUhXMGswR2tURTdwNUZGQklPUy1BZF9QaU1Xd3VmTVJ4dFNoQ3JYdmZxa3NzaVBHZTNXVzVLUDV4YVpucFJ4S05vT0pyNzNHU2x5enpuQjhPZGlCVFlhUTl6YTBtdW9DYWZYRE9JUEx1VkxJdjhCZXJOT1NlUkVnRjcxOFVLM29aUWIzc01QVno0RXNOamJJd28yOHR3X0YzRGNEMU1xT3N6U21OdzItUDN2MWpxNUVWVS0yWHJJTmRYalM5ZDlkSy1HLVJkVHYzSkY2TGVmc29RZ1BFLW04VWJkbXpRYzE2UHE2QlRJVlp3MjlUa1loWUl1dkpqNnE4Q1FfbDVweVl5S1V3ZVdUVW5NSzBNcXRqMU41WWJwZVFVYzNmV3NUbTJuMUdTVmxrLTBjMzlZcmZzWE9rdVNSNXg5eUp4NENqSzFjUTZEQWxxeWs2THVIMjJiUzRLNC1WQ29Wb2dRM2pEdlk2Z01qb2gydkJUYk5kaGMyUENRRTd5U0pkaThVeVNVVk5tU3VnZVlyQzEyZ3dqMGJPenVOLXRtMzFGQlF6Z1RkOXFCU2NDR1g3U0dnZE1LWlJfM0tmVkVseHh5VHRuOXFSeVpXT2k1cGtoTlZZN2tFQm10UnBpRFVieVI4cWFKdm9KdjRjVFM5M3Jvc3ZVRVNXUVh2Zk1qNU1MUkROVEFNMVRuYmtOdHNYQ1BTbGRBTnFiN1U5bFFSaVJPb3EzREJ1czdtZW95dWV3Q21CSkltZUdSUVZ6WTZ4WU1rYmc9',NULL),('1b41ee30-1c80-450f-8fc8-c8d2f4ce1090','2025-12-03 22:56:19','2025-12-03 22:56:49','2025-12-03 22:56:49',1,'ACTIVE','application/octet-stream','c4de12dc-5b1e-452b-bbc2-0bc52b3734e5','52cc38b4-6672-42ee-8e6c-d832d8a9fd37','Z0FBQUFBQnBNTUFUaWlCYm5zZEtpV3lhSkljYVBlZklya09tQ2dsbFVlbXBoTGdwclZuWThqR1hDQTN4ektSaW5EZWkyYmVNbGw4Vk01N2dWRUhSWERSS0dEYW1oV0ZFSGVpek9CUFlKMUtVZkVBMzdJT25GdGFYU08teGswZ3VtaGhJREM4d3l1QWw=',NULL),('2dbd1d06-a33e-48ee-8f7c-863508efa28e','2025-12-03 22:55:57','2025-12-03 22:57:07','2025-12-03 22:57:07',1,'ACTIVE','application/octet-stream','1b9bb6d9-e0f6-4055-8b53-9d61eea22f90','52cc38b4-6672-42ee-8e6c-d832d8a9fd37','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',NULL),('3361bbad-5bc1-42e0-9d1e-77700ea76427','2025-12-03 23:32:41','2025-12-03 23:33:13','2025-12-03 23:33:13',1,'ACTIVE','application/octet-stream','16a0e7dc-e8ea-4e77-ba06-63c725e1708d','6ce88d36-0f27-4246-8624-635795044c38','Z0FBQUFBQnBNTWlaVGpEbzRLMmtvRXkzazhVQkhNVXQ5ek1keXR6N3BPVHZ6NDhJSEp6UEdyLUlYUnFXTUNQVnRWYVAyMnJiaGJfMEY3dnNEQ2gwQkktcTBYbk1EWW5Ha2ZfVkdGazBtckgxYVVWN0YxbEVmX3llcEZIRTYyN0o0cHpfNFNvNGdTMG8=',NULL),('5367ad1e-d7f9-4be3-b318-895ff70b67ee','2025-12-03 22:54:53','2025-12-03 22:57:07','2025-12-03 22:57:07',1,'ACTIVE','application/octet-stream','4b97ba0d-9666-4a07-b64b-66f8e50f3d0f','52cc38b4-6672-42ee-8e6c-d832d8a9fd37','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',NULL),('554b1042-4d97-42ce-936d-421f239d6c9e','2025-12-03 22:58:31','2025-12-03 22:59:47','2025-12-03 22:59:47',1,'ACTIVE','application/octet-stream','ff6c55fc-50ec-4ea0-a52c-1112ed5da99a','062ff219-8556-42ba-a8ed-6cab995bcda4','Z0FBQUFBQnBNTUNYaVYwMVFoZ0ZKaTRXa2RZQmEwckl3YTlVT3hPQnBLM25aeHR6YVRrY25fWkFDSDI3RXRhb182QnRRX2dqOWZwanZjTTJpUVAxTUZYZnA4YVJ1a0JqOTlvRWs5LTM0OUR3d2NsT3FsY2xHYkNNaEpZSmNLbmYxYWl6SUMxeFZ3MUg=',NULL),('5f5f6276-e812-4c17-8e6d-855af2c913f3','2025-12-03 22:54:42','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'ACTIVE','application/octet-stream','c6678d15-6087-4ddd-a037-d8049e64f93a','f4d729f3-c7b8-48a7-b624-6cecd66d98de','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',NULL),('6c4db721-f9e7-4874-9b27-efbb27361fac','2025-12-03 23:01:11','2025-12-03 23:02:22','2025-12-03 23:02:22',1,'ACTIVE','application/octet-stream','04b496f3-463b-42b4-a712-84571b420280','062ff219-8556-42ba-a8ed-6cab995bcda4','Z0FBQUFBQnBNTUUzV0UySjJTRnc0anFucDg0THE0NGgzbGwxV3lnTmNCdm1FWkZ1YWxkUXRLMXZ5akFBRDBrS3Q1RUhfTGtNTk1ReV9qdDFJejhNNTZ2WVZoZlVKSzJ6dV9jSTVIaWpwREVJNVR2M0VFSUttYlVqdXNJRHEyVlNEeldxc2UycGh0U3I=',NULL),('787a10e8-fe39-49e5-8440-efe727098ce9','2025-12-03 22:54:42','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'ACTIVE','application/octet-stream','9cbc0b8f-1592-413a-b9cf-5317f1b4bbcf','f4d729f3-c7b8-48a7-b624-6cecd66d98de','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',NULL),('87023348-fed2-4d38-a98f-3ff479abec6b','2025-12-03 22:55:57','2025-12-03 22:57:07','2025-12-03 22:57:07',1,'ACTIVE','application/octet-stream','d15a1e1f-c23d-4da2-9a13-c98e301d7afb','52cc38b4-6672-42ee-8e6c-d832d8a9fd37','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',NULL),('8bca5e0b-2aa0-4c20-becc-4f7b2ca7dd8f','2025-12-03 23:33:16','2025-12-03 23:34:00','2025-12-03 23:34:00',1,'ACTIVE','application/octet-stream','fb1e773a-2c66-4d55-84fd-3ce345fe5a83','6ce88d36-0f27-4246-8624-635795044c38','Z0FBQUFBQnBNTWk4UG0yVVNDWmVYQ3A1U2M5R0FDaEtXblZJZWdyekdZOHRzam81cXdac0RrNzBVQjRTLTBMOVltVWNwVVl4cFc2VTVuTG4zcXZzTnlSRjl5MlhxZ2txTWNDUHlMZ3MwSW1BaE9QTTF2dVNtWUtVVUNJVEFoeFhnR0tsRjUwX0dtOG8=',NULL),('9b3765dc-5881-494a-8afa-a3cbeac48f52','2025-12-03 22:55:04','2025-12-03 22:55:56','2025-12-03 22:55:56',1,'ACTIVE','application/octet-stream','d6b2e7a5-4bd1-4600-b3b6-a77d1c04c743','6a8d3b7d-b9d7-4fa8-9497-0eb698e64727','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',NULL),('9e6a4c10-6e8f-48e4-a7f0-c6de680d44c4','2025-12-03 22:54:41','2025-12-03 22:55:35','2025-12-03 22:55:35',1,'ACTIVE','application/octet-stream','f1caa75c-461a-4781-b85f-4faa92900595','24cc3307-5671-43e6-9f1b-9187d829f7b3','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',NULL),('a383b51a-0fb4-437b-aad4-bd0ed2f3b595','2025-12-03 22:59:50','2025-12-03 23:01:08','2025-12-03 23:01:08',1,'ACTIVE','application/octet-stream','59dc8964-81ad-42a4-a094-5c6a126404e5','062ff219-8556-42ba-a8ed-6cab995bcda4','Z0FBQUFBQnBNTURtZjZhV1g2Y3p5T1BNTFEzeDgtUVVGRW5LX24zUzBkTlNDQTVMYm1Xblo3Q3BpcWw2SURSWDNqY011bnVhLXVsMVVwWXRvWHBDSXlGTlplMDZyTVhwN3puaTNlMjFRT2h5V280U21lLXRYNWotcTVtOFd6dHViR1NxbkpGY2dJNHk=',NULL),('a50b9ce2-9131-460d-8dfe-9854156e6c60','2025-12-03 22:54:41','2025-12-03 22:55:35','2025-12-03 22:55:35',1,'ACTIVE','application/octet-stream','e8d44c9e-214b-49dd-9354-2d05685840bb','24cc3307-5671-43e6-9f1b-9187d829f7b3','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',NULL),('b7316ab3-ee3c-48af-883a-71a689f9562f','2025-12-03 22:55:30','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'ACTIVE','application/octet-stream','80b6fba2-a9d0-417e-8ff8-7c828eade650','f4d729f3-c7b8-48a7-b624-6cecd66d98de','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',NULL),('b9889f80-7a2b-4f22-a3a3-fd6520fa3470','2025-12-03 22:54:10','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'ACTIVE','application/octet-stream','144df04f-b8bf-410b-91e4-1cf230c80a98','f4d729f3-c7b8-48a7-b624-6cecd66d98de','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',NULL),('c8a6fdf5-effd-4da5-8ee3-8ea7f0f01402','2025-12-03 22:54:53','2025-12-03 22:57:07','2025-12-03 22:57:07',1,'ACTIVE','application/octet-stream','723811ed-48d4-4e9a-af84-00897f80d0f9','52cc38b4-6672-42ee-8e6c-d832d8a9fd37','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',NULL),('ed8e4173-a6e7-4f1f-a701-5128ca747eb1','2025-12-03 22:55:22','2025-12-03 22:55:49','2025-12-03 22:55:49',1,'ACTIVE','application/octet-stream','bdeea01f-40a6-424c-9a51-ed2bc6a25fa4','52cc38b4-6672-42ee-8e6c-d832d8a9fd37','Z0FBQUFBQnBNTF9hT3d1bllaQ19ucE5pWllXR1FmRExrdkZRczQtaUZDVTgxVGFyTDJLUDhJUVNFU0FfVHZTMHlUVjdLSFBJNGZDSmhtSlRwUnNMUG9ZcjY4Qkw0T3B6MHZSZEsyYkhhNnhrVjdGVlhmY1BEeXMtUUlINU9IWkhXNHJPZ0pGUDBGaW8=',NULL),('f8b4e0c0-bdfd-4033-8de7-676c3490103b','2025-12-03 22:54:10','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'ACTIVE','application/octet-stream','1e20b5cb-04ab-4e60-be3e-8a8d8d612c4e','f4d729f3-c7b8-48a7-b624-6cecd66d98de','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',NULL);
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
INSERT INTO `kek_data` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `plugin_name`, `kek_label`, `project_id`, `active`, `bind_completed`, `algorithm`, `bit_length`, `mode`, `plugin_meta`) VALUES ('062ff219-8556-42ba-a8ed-6cab995bcda4','2025-12-03 22:58:31','2025-12-03 23:02:36','2025-12-03 23:02:36',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-9bf6771e795f41a4b232098116b975b1-key-d4f08fd0-7b50-4e04-b150-7b1e7ae0e042','8b3dd9f3-a0de-4b00-aec3-be7017615e2a',1,1,'aes',128,'cbc','gAAAAABpMMCX5wi0vYFds6k-BLWsYNOXZR3DRL23VeeaTmq815XxQB5STw2ef8F9Ai8qAi40iuoHpEoEwoAJTLyMzu72PWYU9yrunhN8hDFtUaP_67bc1NZpsq0KIW8m09Sl5Brt06ut'),('24cc3307-5671-43e6-9f1b-9187d829f7b3','2025-12-03 22:54:41','2025-12-03 22:55:35','2025-12-03 22:55:35',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-cf9cba8c32de4120b657757dd4d6cccf-key-d3e88aef-d3d9-4761-be82-3a76655af440','fe122a28-2e32-4737-9d21-b3c3dd81757f',1,1,'aes',128,'cbc','gAAAAABpML-xsHPwB-a5-pHzuQlP1vfYJETrbjzo6fjPnc6Io2tiImHp5fPAUFn13640hVwEEu-AJ-jFKJki3iQHcW8ihi5NWsoYNqUSxZzs8Zok6d8nRQahm-IZaNccGAKhq7iC1R0p'),('52cc38b4-6672-42ee-8e6c-d832d8a9fd37','2025-12-03 22:54:53','2025-12-03 22:57:07','2025-12-03 22:57:07',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-dbb2710d867347c5b4a3eeb47ef0e6a0-key-9c9b826f-a3e2-418a-aedb-49e71b6224e3','33fc420b-e406-4fcc-ba67-44941bd3c86c',1,1,'aes',128,'cbc','gAAAAABpML-9RALj2Fp9Ph4dmpNh8WVgyhHt0Bob5XSVAt3hxhm5qMnYi-XRlh-KylnFB__rpN8ji3aUOLR0bMYFMX5FjyHycHrleBHiCZqmuoI6JvXoeTdnHltHmtbp63oQPlOzdVDg'),('6a8d3b7d-b9d7-4fa8-9497-0eb698e64727','2025-12-03 22:55:04','2025-12-03 22:55:56','2025-12-03 22:55:56',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-50c6b4aa393644a6a1f79dc8daa3a531-key-d9ab0a2f-9f98-4ca7-a57c-ccbed40a938d','e01ba697-bf8c-4090-959f-ad19772d2da8',1,1,'aes',128,'cbc','gAAAAABpML_IU7a7s0ldmWDadOsdBppSNd13a3QAesEEmH33ri9XkynI7BAywbwYr67DW6auqWh01n0d0HvSEOqvfCtULbqQmMLyyFI92nreo21UfKb_mUfOFZ99umhkHSCywnMpG4N7'),('6ce88d36-0f27-4246-8624-635795044c38','2025-12-03 23:32:41','2025-12-03 23:40:11','2025-12-03 23:40:11',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-17135a905ddc412883361a7397e2e39c-key-c5a6e57b-7472-410c-925f-bca3c76475d2','ee4faadd-6c25-4955-b1f8-4a251da19374',1,1,'aes',128,'cbc','gAAAAABpMMiZAiNCCjfLGo7VDs0ypaHR9VHtfAUSI3j7cVPhHaIhYyvgUycDxPQ7FxkDkjCfSVmLSIpFhwWRXflvhFJjt2Z_QBSX_Igxh9HXUMvFlNo1IeupWkfoMsAuy26CW7yyZMws'),('f4d729f3-c7b8-48a7-b624-6cecd66d98de','2025-12-03 22:54:10','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-81805fcc94854ba6997bebb34be6a5db-key-815e5328-c771-4522-8c98-ebe94a8222d9','9d1528c0-f361-4a3c-a08b-a79d8a73e304',1,1,'aes',128,'cbc','gAAAAABpML-SW_d8aqRtj7P_pKNIz2ru_A2YLiWOQNQe2NdyfUwBKETsd4SRUL7K4SyP32Ex1wZTPYQ57qv5I36-AS5FlbXcY_DuPltUDYoUDDHlXuSzVh9K5a6tmskRhUvEoGUfni6M');
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
INSERT INTO `orders` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `type`, `project_id`, `error_status_code`, `error_reason`, `meta`, `secret_id`, `container_id`, `sub_status`, `sub_status_message`, `creator_id`) VALUES ('2050ccbe-f1a6-4c24-b60c-d7dd52c413ea','2025-12-03 22:55:22','2025-12-03 22:55:22',NULL,0,'ACTIVE','key','33fc420b-e406-4fcc-ba67-44941bd3c86c',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','bdeea01f-40a6-424c-9a51-ed2bc6a25fa4',NULL,'Unknown','Unknown','973c46d6fb5e49898e1694e673e032c7'),('555b4ad0-26ea-41f1-90fb-3a09fb83edae','2025-12-03 23:01:11','2025-12-03 23:01:11',NULL,0,'ACTIVE','key','8b3dd9f3-a0de-4b00-aec3-be7017615e2a',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','04b496f3-463b-42b4-a712-84571b420280',NULL,'Unknown','Unknown','811f72730dd14e429b7343a2286cfde0'),('77c2d25b-ac6e-4972-9fc0-486b54585352','2025-12-03 22:59:50','2025-12-03 22:59:50',NULL,0,'ACTIVE','key','8b3dd9f3-a0de-4b00-aec3-be7017615e2a',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','59dc8964-81ad-42a4-a094-5c6a126404e5',NULL,'Unknown','Unknown','811f72730dd14e429b7343a2286cfde0'),('8c45d6cb-649e-47da-ab80-b9103aeebc2a','2025-12-03 23:32:41','2025-12-03 23:32:41',NULL,0,'ACTIVE','key','ee4faadd-6c25-4955-b1f8-4a251da19374',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','16a0e7dc-e8ea-4e77-ba06-63c725e1708d',NULL,'Unknown','Unknown','562adaac81824180a41f0757e2b448ee'),('9b6f389d-5a34-472e-ae95-093f4633810c','2025-12-03 22:58:31','2025-12-03 22:58:31',NULL,0,'ACTIVE','key','8b3dd9f3-a0de-4b00-aec3-be7017615e2a',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','ff6c55fc-50ec-4ea0-a52c-1112ed5da99a',NULL,'Unknown','Unknown','811f72730dd14e429b7343a2286cfde0'),('cc7adda4-ec27-4cf1-a86f-73a431b27ab3','2025-12-03 22:56:19','2025-12-03 22:56:19',NULL,0,'ACTIVE','key','33fc420b-e406-4fcc-ba67-44941bd3c86c',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','c4de12dc-5b1e-452b-bbc2-0bc52b3734e5',NULL,'Unknown','Unknown','973c46d6fb5e49898e1694e673e032c7'),('ed614734-5b5a-4680-95d7-798afaa0b69d','2025-12-03 23:33:16','2025-12-03 23:33:16',NULL,0,'ACTIVE','key','ee4faadd-6c25-4955-b1f8-4a251da19374',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','fb1e773a-2c66-4d55-84fd-3ce345fe5a83',NULL,'Unknown','Unknown','562adaac81824180a41f0757e2b448ee');
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
INSERT INTO `projects` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `external_id`) VALUES ('33fc420b-e406-4fcc-ba67-44941bd3c86c','2025-12-03 22:54:53','2025-12-03 22:57:07','2025-12-03 22:57:07',1,'ACTIVE','dbb2710d867347c5b4a3eeb47ef0e6a0'),('8b3dd9f3-a0de-4b00-aec3-be7017615e2a','2025-12-03 22:58:31','2025-12-03 23:02:36','2025-12-03 23:02:36',1,'ACTIVE','9bf6771e795f41a4b232098116b975b1'),('9d1528c0-f361-4a3c-a08b-a79d8a73e304','2025-12-03 22:54:10','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'ACTIVE','81805fcc94854ba6997bebb34be6a5db'),('e01ba697-bf8c-4090-959f-ad19772d2da8','2025-12-03 22:55:04','2025-12-03 22:55:56','2025-12-03 22:55:56',1,'ACTIVE','50c6b4aa393644a6a1f79dc8daa3a531'),('ee4faadd-6c25-4955-b1f8-4a251da19374','2025-12-03 23:32:41','2025-12-03 23:40:11','2025-12-03 23:40:11',1,'ACTIVE','17135a905ddc412883361a7397e2e39c'),('fe122a28-2e32-4737-9d21-b3c3dd81757f','2025-12-03 22:54:41','2025-12-03 22:55:35','2025-12-03 22:55:35',1,'ACTIVE','cf9cba8c32de4120b657757dd4d6cccf');
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
INSERT INTO `secret_store_metadata` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `key`, `value`, `secret_id`) VALUES ('022d60f5-efed-4b92-9578-3c879335d74f','2025-12-03 22:54:53','2025-12-03 22:57:07','2025-12-03 22:57:07',1,'PENDING','content_type','application/octet-stream','4b97ba0d-9666-4a07-b64b-66f8e50f3d0f'),('039b8ae5-9cf9-40b7-91e4-f7e7bab03e99','2025-12-03 22:55:30','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'PENDING','content_type','application/octet-stream','e866b0f1-43b8-4fbc-bfc8-69efa1cb413b'),('04ad38d8-6ac8-4b82-9fd6-262b2344a659','2025-12-03 22:55:05','2025-12-03 22:55:56','2025-12-03 22:55:56',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','1af1e6b9-59a9-4d7c-9ac7-781176e8ea73'),('0afdf547-e98f-46a9-8463-79dce4bf66c8','2025-12-03 23:01:11','2025-12-03 23:02:22','2025-12-03 23:02:22',1,'PENDING','content_type','application/octet-stream','04b496f3-463b-42b4-a712-84571b420280'),('11a74fa3-2e9d-4afd-8910-814387080bea','2025-12-03 23:33:16','2025-12-03 23:34:00','2025-12-03 23:34:00',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','fb1e773a-2c66-4d55-84fd-3ce345fe5a83'),('14acdde0-9b03-4406-b8b1-8750340347db','2025-12-03 22:54:10','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'PENDING','content_type','application/octet-stream','144df04f-b8bf-410b-91e4-1cf230c80a98'),('1526aa07-02e0-42bf-b8b4-86d3055fec44','2025-12-03 22:58:31','2025-12-03 22:59:47','2025-12-03 22:59:47',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','ff6c55fc-50ec-4ea0-a52c-1112ed5da99a'),('18f2902f-33be-4c2c-a6ea-9927df08ccbb','2025-12-03 22:54:42','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','c6678d15-6087-4ddd-a037-d8049e64f93a'),('256ba2e4-a0ca-41fd-ad61-2222ad3f878f','2025-12-03 22:54:42','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'PENDING','content_type','application/octet-stream','c6678d15-6087-4ddd-a037-d8049e64f93a'),('2c737e6d-be79-4fdb-8325-e3075e34d4db','2025-12-03 22:55:57','2025-12-03 22:57:07','2025-12-03 22:57:07',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','1b9bb6d9-e0f6-4055-8b53-9d61eea22f90'),('2f6972db-37ca-4d19-a5fb-b94fd5a7092f','2025-12-03 22:55:22','2025-12-03 22:55:49','2025-12-03 22:55:49',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','bdeea01f-40a6-424c-9a51-ed2bc6a25fa4'),('34793e69-7985-4647-b228-1eff3cdaecc1','2025-12-03 22:55:57','2025-12-03 22:57:07','2025-12-03 22:57:07',1,'PENDING','content_type','application/octet-stream','1b9bb6d9-e0f6-4055-8b53-9d61eea22f90'),('357580e0-5cd9-454a-8fd0-412d1fdc1ba0','2025-12-03 22:54:41','2025-12-03 22:55:35','2025-12-03 22:55:35',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','e8d44c9e-214b-49dd-9354-2d05685840bb'),('36da0676-ee36-4125-8819-d7791777457e','2025-12-03 22:59:50','2025-12-03 23:01:08','2025-12-03 23:01:08',1,'PENDING','content_type','application/octet-stream','59dc8964-81ad-42a4-a094-5c6a126404e5'),('434fd3bb-149a-47be-89e9-634498eacc40','2025-12-03 22:54:53','2025-12-03 22:57:07','2025-12-03 22:57:07',1,'PENDING','content_type','application/octet-stream','723811ed-48d4-4e9a-af84-00897f80d0f9'),('4ed8b0c8-790b-48d0-a1f0-6570fdce75b1','2025-12-03 22:55:22','2025-12-03 22:55:49','2025-12-03 22:55:49',1,'PENDING','content_type','application/octet-stream','bdeea01f-40a6-424c-9a51-ed2bc6a25fa4'),('53ac7872-a570-4989-92ee-6f1f137ecc88','2025-12-03 23:32:41','2025-12-03 23:33:13','2025-12-03 23:33:13',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','16a0e7dc-e8ea-4e77-ba06-63c725e1708d'),('564c93b9-5368-4ddc-a1c3-d5107933f9a4','2025-12-03 22:54:10','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','144df04f-b8bf-410b-91e4-1cf230c80a98'),('696df320-d70d-4791-85dd-21327c33ba1b','2025-12-03 22:54:42','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','9cbc0b8f-1592-413a-b9cf-5317f1b4bbcf'),('6b4c52d4-0540-425b-acaa-ea6f00833045','2025-12-03 23:32:41','2025-12-03 23:33:13','2025-12-03 23:33:13',1,'PENDING','content_type','application/octet-stream','16a0e7dc-e8ea-4e77-ba06-63c725e1708d'),('70bc24b7-ad45-47fb-827a-298322c5b2b5','2025-12-03 22:55:30','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','e866b0f1-43b8-4fbc-bfc8-69efa1cb413b'),('73ff1d65-f718-4624-b8cb-e39d81336748','2025-12-03 22:54:10','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'PENDING','content_type','application/octet-stream','1e20b5cb-04ab-4e60-be3e-8a8d8d612c4e'),('77c6d97a-1921-4436-8728-cd44fe577f81','2025-12-03 22:55:57','2025-12-03 22:57:07','2025-12-03 22:57:07',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','d15a1e1f-c23d-4da2-9a13-c98e301d7afb'),('78df76b8-16e9-4606-a62d-3bcc117dd362','2025-12-03 22:56:19','2025-12-03 22:56:49','2025-12-03 22:56:49',1,'PENDING','content_type','application/octet-stream','c4de12dc-5b1e-452b-bbc2-0bc52b3734e5'),('7fa20ce1-fada-4d58-a5b3-581a394d80f9','2025-12-03 23:33:16','2025-12-03 23:34:00','2025-12-03 23:34:00',1,'PENDING','content_type','application/octet-stream','fb1e773a-2c66-4d55-84fd-3ce345fe5a83'),('8487d889-86c9-4310-873e-b284c61db0d7','2025-12-03 22:55:57','2025-12-03 22:57:07','2025-12-03 22:57:07',1,'PENDING','content_type','application/octet-stream','d15a1e1f-c23d-4da2-9a13-c98e301d7afb'),('850692bd-1f0b-41ee-a1a3-5bf86ca8fd41','2025-12-03 22:55:04','2025-12-03 22:55:56','2025-12-03 22:55:56',1,'PENDING','content_type','application/octet-stream','d6b2e7a5-4bd1-4600-b3b6-a77d1c04c743'),('8abd8092-af6b-477f-832a-0ebdb3e345ec','2025-12-03 22:54:41','2025-12-03 22:55:35','2025-12-03 22:55:35',1,'PENDING','content_type','application/octet-stream','e8d44c9e-214b-49dd-9354-2d05685840bb'),('959b5407-1104-42c7-b40a-6a286cbba2f5','2025-12-03 22:54:10','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','1e20b5cb-04ab-4e60-be3e-8a8d8d612c4e'),('96b192fa-cbb2-4800-8a4c-dab4a9e6a764','2025-12-03 22:54:41','2025-12-03 22:55:35','2025-12-03 22:55:35',1,'PENDING','content_type','application/octet-stream','f1caa75c-461a-4781-b85f-4faa92900595'),('98738403-6d03-4f95-b6e5-581df24f2598','2025-12-03 22:55:30','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'PENDING','content_type','application/octet-stream','80b6fba2-a9d0-417e-8ff8-7c828eade650'),('9ec871f9-a6e8-4dea-b59f-2976b726d630','2025-12-03 22:55:05','2025-12-03 22:55:56','2025-12-03 22:55:56',1,'PENDING','content_type','application/octet-stream','1af1e6b9-59a9-4d7c-9ac7-781176e8ea73'),('a2a8d74e-1059-4b97-ac65-ea84824384ba','2025-12-03 22:54:41','2025-12-03 22:55:35','2025-12-03 22:55:35',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','f1caa75c-461a-4781-b85f-4faa92900595'),('a306a3d2-6b5f-4b24-8066-0fe1e12a396f','2025-12-03 22:58:31','2025-12-03 22:59:47','2025-12-03 22:59:47',1,'PENDING','content_type','application/octet-stream','ff6c55fc-50ec-4ea0-a52c-1112ed5da99a'),('a380c670-7a29-4a62-9199-741bf0841c6b','2025-12-03 22:55:04','2025-12-03 22:55:56','2025-12-03 22:55:56',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','d6b2e7a5-4bd1-4600-b3b6-a77d1c04c743'),('a8c8fe40-a525-497f-97a4-6e805139975d','2025-12-03 22:59:50','2025-12-03 23:01:08','2025-12-03 23:01:08',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','59dc8964-81ad-42a4-a094-5c6a126404e5'),('b529d6bf-4df9-4730-ac9c-d8db3e75b841','2025-12-03 22:55:30','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','80b6fba2-a9d0-417e-8ff8-7c828eade650'),('b6388c16-2f86-414f-8a99-fb2cd2f39686','2025-12-03 23:01:11','2025-12-03 23:02:22','2025-12-03 23:02:22',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','04b496f3-463b-42b4-a712-84571b420280'),('c711d9ac-283e-4790-89d7-becf483dd0d9','2025-12-03 22:54:53','2025-12-03 22:57:07','2025-12-03 22:57:07',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','4b97ba0d-9666-4a07-b64b-66f8e50f3d0f'),('d2020e0c-c82b-4d35-aec1-96779d71645a','2025-12-03 22:56:19','2025-12-03 22:56:49','2025-12-03 22:56:49',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','c4de12dc-5b1e-452b-bbc2-0bc52b3734e5'),('d3f0c7aa-b985-4401-8b97-b4646d811751','2025-12-03 22:54:42','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'PENDING','content_type','application/octet-stream','9cbc0b8f-1592-413a-b9cf-5317f1b4bbcf'),('ff80fc54-7e71-4d33-add4-d65045fb5012','2025-12-03 22:54:53','2025-12-03 22:57:07','2025-12-03 22:57:07',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','723811ed-48d4-4e9a-af84-00897f80d0f9');
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('6e426b9c-e193-414b-adad-bb50760d1415','2025-12-03 22:25:49','2025-12-03 22:25:49',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
INSERT INTO `secrets` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `name`, `secret_type`, `expiration`, `algorithm`, `bit_length`, `mode`, `creator_id`, `project_id`) VALUES ('04b496f3-463b-42b4-a712-84571b420280','2025-12-03 23:01:11','2025-12-03 23:02:22','2025-12-03 23:02:22',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'811f72730dd14e429b7343a2286cfde0','8b3dd9f3-a0de-4b00-aec3-be7017615e2a'),('144df04f-b8bf-410b-91e4-1cf230c80a98','2025-12-03 22:54:10','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'ACTIVE','tempest-tempest-sec-1973502273','certificate','2025-12-08 22:54:09','rsa',NULL,NULL,'0cc788bf94b043be9fa78d151316c180','9d1528c0-f361-4a3c-a08b-a79d8a73e304'),('16a0e7dc-e8ea-4e77-ba06-63c725e1708d','2025-12-03 23:32:41','2025-12-03 23:33:13','2025-12-03 23:33:13',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'562adaac81824180a41f0757e2b448ee','ee4faadd-6c25-4955-b1f8-4a251da19374'),('1af1e6b9-59a9-4d7c-9ac7-781176e8ea73','2025-12-03 22:55:05','2025-12-03 22:55:56','2025-12-03 22:55:56',1,'ACTIVE','tempest-tempest-sec-497686490','certificate','2025-12-08 22:55:04','rsa',NULL,NULL,'eb1e57f1c5d0413399aaed259cde52ed','e01ba697-bf8c-4090-959f-ad19772d2da8'),('1b9bb6d9-e0f6-4055-8b53-9d61eea22f90','2025-12-03 22:55:57','2025-12-03 22:57:07','2025-12-03 22:57:07',1,'ACTIVE','tempest-tempest-sec-696149605','certificate','2025-12-08 22:55:57','rsa',NULL,NULL,'973c46d6fb5e49898e1694e673e032c7','33fc420b-e406-4fcc-ba67-44941bd3c86c'),('1e20b5cb-04ab-4e60-be3e-8a8d8d612c4e','2025-12-03 22:54:10','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'ACTIVE','tempest-tempest-sec-503536808','certificate','2025-12-08 22:54:10','rsa',NULL,NULL,'0cc788bf94b043be9fa78d151316c180','9d1528c0-f361-4a3c-a08b-a79d8a73e304'),('4b97ba0d-9666-4a07-b64b-66f8e50f3d0f','2025-12-03 22:54:53','2025-12-03 22:57:07','2025-12-03 22:57:07',1,'ACTIVE','tempest-tempest-sec-974745461','certificate','2025-12-08 22:54:53','rsa',NULL,NULL,'973c46d6fb5e49898e1694e673e032c7','33fc420b-e406-4fcc-ba67-44941bd3c86c'),('59dc8964-81ad-42a4-a094-5c6a126404e5','2025-12-03 22:59:50','2025-12-03 23:01:08','2025-12-03 23:01:08',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'811f72730dd14e429b7343a2286cfde0','8b3dd9f3-a0de-4b00-aec3-be7017615e2a'),('723811ed-48d4-4e9a-af84-00897f80d0f9','2025-12-03 22:54:53','2025-12-03 22:57:07','2025-12-03 22:57:07',1,'ACTIVE','tempest-tempest-sec-1111313322','certificate','2025-12-08 22:54:53','rsa',NULL,NULL,'973c46d6fb5e49898e1694e673e032c7','33fc420b-e406-4fcc-ba67-44941bd3c86c'),('80b6fba2-a9d0-417e-8ff8-7c828eade650','2025-12-03 22:55:30','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'ACTIVE','tempest-tempest-sec-1740051165','certificate','2025-12-08 22:55:30','rsa',NULL,NULL,'0cc788bf94b043be9fa78d151316c180','9d1528c0-f361-4a3c-a08b-a79d8a73e304'),('9cbc0b8f-1592-413a-b9cf-5317f1b4bbcf','2025-12-03 22:54:42','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'ACTIVE','tempest-tempest-sec-1315779181','certificate','2025-12-08 22:54:42','rsa',NULL,NULL,'0cc788bf94b043be9fa78d151316c180','9d1528c0-f361-4a3c-a08b-a79d8a73e304'),('bdeea01f-40a6-424c-9a51-ed2bc6a25fa4','2025-12-03 22:55:22','2025-12-03 22:55:49','2025-12-03 22:55:49',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'973c46d6fb5e49898e1694e673e032c7','33fc420b-e406-4fcc-ba67-44941bd3c86c'),('c4de12dc-5b1e-452b-bbc2-0bc52b3734e5','2025-12-03 22:56:19','2025-12-03 22:56:49','2025-12-03 22:56:49',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'973c46d6fb5e49898e1694e673e032c7','33fc420b-e406-4fcc-ba67-44941bd3c86c'),('c6678d15-6087-4ddd-a037-d8049e64f93a','2025-12-03 22:54:42','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'ACTIVE','tempest-tempest-sec-1532453609','certificate','2025-12-08 22:54:42','rsa',NULL,NULL,'0cc788bf94b043be9fa78d151316c180','9d1528c0-f361-4a3c-a08b-a79d8a73e304'),('d15a1e1f-c23d-4da2-9a13-c98e301d7afb','2025-12-03 22:55:57','2025-12-03 22:57:07','2025-12-03 22:57:07',1,'ACTIVE','tempest-tempest-sec-943482389','certificate','2025-12-08 22:55:57','rsa',NULL,NULL,'973c46d6fb5e49898e1694e673e032c7','33fc420b-e406-4fcc-ba67-44941bd3c86c'),('d6b2e7a5-4bd1-4600-b3b6-a77d1c04c743','2025-12-03 22:55:04','2025-12-03 22:55:56','2025-12-03 22:55:56',1,'ACTIVE','tempest-tempest-sec-1040275230','certificate','2025-12-08 22:55:04','rsa',NULL,NULL,'eb1e57f1c5d0413399aaed259cde52ed','e01ba697-bf8c-4090-959f-ad19772d2da8'),('e866b0f1-43b8-4fbc-bfc8-69efa1cb413b','2025-12-03 22:55:30','2025-12-03 22:56:31','2025-12-03 22:56:31',1,'ACTIVE','tempest-tempest-sec-959607748','certificate','2025-12-08 22:55:30','rsa',NULL,NULL,'0cc788bf94b043be9fa78d151316c180','9d1528c0-f361-4a3c-a08b-a79d8a73e304'),('e8d44c9e-214b-49dd-9354-2d05685840bb','2025-12-03 22:54:41','2025-12-03 22:55:35','2025-12-03 22:55:35',1,'ACTIVE','tempest-tempest-sec-1990122315','certificate','2025-12-08 22:54:41','rsa',NULL,NULL,'06598f3c0e874151a106669c7d106cc9','fe122a28-2e32-4737-9d21-b3c3dd81757f'),('f1caa75c-461a-4781-b85f-4faa92900595','2025-12-03 22:54:41','2025-12-03 22:55:35','2025-12-03 22:55:35',1,'ACTIVE','tempest-tempest-sec-952326245','certificate','2025-12-08 22:54:41','rsa',NULL,NULL,'06598f3c0e874151a106669c7d106cc9','fe122a28-2e32-4737-9d21-b3c3dd81757f'),('fb1e773a-2c66-4d55-84fd-3ce345fe5a83','2025-12-03 23:33:16','2025-12-03 23:34:00','2025-12-03 23:34:00',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'562adaac81824180a41f0757e2b448ee','ee4faadd-6c25-4955-b1f8-4a251da19374'),('ff6c55fc-50ec-4ea0-a52c-1112ed5da99a','2025-12-03 22:58:31','2025-12-03 22:59:47','2025-12-03 22:59:47',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'811f72730dd14e429b7343a2286cfde0','8b3dd9f3-a0de-4b00-aec3-be7017615e2a');
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
INSERT INTO `backups` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `host`, `availability_zone`, `display_name`, `display_description`, `container`, `status`, `fail_reason`, `service_metadata`, `service`, `size`, `object_count`, `parent_id`, `temp_volume_id`, `temp_snapshot_id`, `num_dependent_backups`, `snapshot_id`, `data_timestamp`, `restore_volume_id`, `encryption_key_id`) VALUES ('2025-12-03 23:18:55','2025-12-03 23:19:07','2025-12-03 23:19:07',1,'51bcede1-6936-4258-8d87-4277790985dd','573cbd14-e420-4691-87de-6a3f4cd7e701','26c99312872e462f9fcc402116b69c78','e014ab433f1c45e4bdfa23184aca2555','cinder-baebb-backup-0',NULL,'tempest-TestVolumeBackupRestore-backup-1884849532',NULL,'volumebackups','deleted','Connection to swift failed: Container HEAD failed: https://swift-public-openstack.apps.sno.openstack.lab/v1/AUTH_e014ab433f1c45e4bdfa23184aca2555/volumebackups 403 Forbidden (txn: tx89597e4bc5364141b20b9-006930c567)',NULL,'cinder.backup.drivers.swift.SwiftBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:18:55',NULL,NULL),('2025-12-03 23:41:08','2025-12-03 23:41:18','2025-12-03 23:41:18',1,'d6026479-ddde-4999-9bb4-eaed697635bc','13215b4c-c6e9-4e2a-8854-2c2be49f6a00','ecca011520524ca2b0dda4a3f90ea632','736cfa939ed54e37b1dae7d67c7093e6','cinder-baebb-backup-0',NULL,'tempest-TestVolumeBackupRestore-backup-1281417647',NULL,'volumebackups','deleted','Connection to swift failed: Container HEAD failed: https://swift-public-openstack.apps.sno.openstack.lab/v1/AUTH_736cfa939ed54e37b1dae7d67c7093e6/volumebackups 403 Forbidden (txn: txcfcf55660ce2478197583-006930ca99)',NULL,'cinder.backup.drivers.swift.SwiftBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:41:08',NULL,NULL);
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
INSERT INTO `encryption` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `cipher`, `control_location`, `key_size`, `provider`, `volume_type_id`, `encryption_id`) VALUES ('2025-12-03 22:58:31',NULL,'2025-12-03 22:59:49',1,'aes-xts-plain64','front-end',256,'plain','3300577a-a510-4e00-994f-7e924a49dc4d','15224504-e007-49ea-b47a-bdad9dffee7c'),('2025-12-03 22:56:19',NULL,'2025-12-03 22:56:51',1,'aes-xts-plain64','front-end',256,'luks','0a10354e-2227-4a04-976f-fab6bce5a4c5','249ecaba-2b4d-418f-b8ea-385856d42751'),('2025-12-03 23:32:41',NULL,'2025-12-03 23:33:16',1,'aes-xts-plain64','front-end',256,'luks','3eb0e2bf-407d-466d-8b22-5b1e225efd3c','62aaf8ca-4374-4f43-bad9-5c3e7cdf5485'),('2025-12-03 23:01:11',NULL,'2025-12-03 23:02:25',1,'aes-xts-plain64','front-end',256,'luks2','14bc9703-bb2e-47eb-9b34-387f140577fa','788f83f2-1155-4825-8785-0ace8c35a938'),('2025-12-03 22:59:49',NULL,'2025-12-03 23:01:11',1,'aes-xts-plain64','front-end',256,'luks','dbc6d7a6-cfa1-46e4-8d33-236310341f95','827e4014-8cd1-4055-8729-a987596b2024'),('2025-12-03 23:33:16',NULL,'2025-12-03 23:34:03',1,'aes-xts-plain64','front-end',256,'luks2','9c148a4c-d734-416d-8d30-9b6b92319ec5','b5178be4-dda1-4971-97b3-6b8f052b978b'),('2025-12-03 22:55:22',NULL,'2025-12-03 22:55:52',1,'aes-xts-plain64','front-end',256,'plain','439954bb-c5fc-49e1-9f8f-6b3a78420c02','f43dbe03-3fde-4bf1-9369-ed81d4448023');
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','c50a00b1-9843-48ff-8d95-380d012db2c5','2025-12-03 22:25:30','2025-12-03 22:25:30',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('c50a00b1-9843-48ff-8d95-380d012db2c5','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2025-12-03 22:25:30','2025-12-03 22:25:30',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_host` (`host`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
INSERT INTO `messages` (`id`, `project_id`, `request_id`, `resource_type`, `resource_uuid`, `event_id`, `message_level`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `expires_at`, `detail_id`, `action_id`) VALUES ('77060090-bab9-4ddf-a57a-0dd20fa4c9cc','736cfa939ed54e37b1dae7d67c7093e6','req-891eb7cd-eff2-4193-bc39-61cb35a7de44','VOLUME_BACKUP','d6026479-ddde-4999-9bb4-eaed697635bc','VOLUME_VOLUME_BACKUP_013_020','ERROR','2025-12-03 23:41:14',NULL,NULL,0,'2026-01-02 23:41:14','020','013'),('f4156908-19c6-4d21-9bfe-fa745e4d430e','e014ab433f1c45e4bdfa23184aca2555','req-bc138ad4-6a08-4bb2-a46a-4b229adc1ece','VOLUME_BACKUP','51bcede1-6936-4258-8d87-4277790985dd','VOLUME_VOLUME_BACKUP_013_020','ERROR','2025-12-03 23:19:03',NULL,NULL,0,'2026-01-02 23:19:03','020','013');
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2025-12-03 22:25:21',NULL,NULL,0,1,'default','volumes',10),('2025-12-03 22:25:21',NULL,NULL,0,2,'default','snapshots',10),('2025-12-03 22:25:21',NULL,NULL,0,3,'default','gigabytes',1000),('2025-12-03 22:25:21',NULL,NULL,0,4,'default','consistencygroups',10),('2025-12-03 22:25:21',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2025-12-03 22:25:21',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `race_preventer`) VALUES ('2025-12-03 22:50:28','2025-12-03 22:50:46',NULL,0,1,'771bd7b64c5e4f84bdc615bbe9783218','volumes',0,0,NULL,1),('2025-12-03 22:50:28','2025-12-03 22:50:46',NULL,0,2,'771bd7b64c5e4f84bdc615bbe9783218','gigabytes',0,0,NULL,1),('2025-12-03 22:50:28','2025-12-03 22:50:46',NULL,0,3,'771bd7b64c5e4f84bdc615bbe9783218','volumes___DEFAULT__',0,0,NULL,1),('2025-12-03 22:50:28','2025-12-03 22:50:46',NULL,0,4,'771bd7b64c5e4f84bdc615bbe9783218','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-03 22:52:25','2025-12-03 22:53:25',NULL,0,5,'301200c274804774ab9b73b272642d78','volumes',0,0,NULL,1),('2025-12-03 22:52:25','2025-12-03 22:53:25',NULL,0,6,'301200c274804774ab9b73b272642d78','gigabytes',0,0,NULL,1),('2025-12-03 22:52:25','2025-12-03 22:53:25',NULL,0,7,'301200c274804774ab9b73b272642d78','volumes___DEFAULT__',0,0,NULL,1),('2025-12-03 22:52:25','2025-12-03 22:53:25',NULL,0,8,'301200c274804774ab9b73b272642d78','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-03 22:53:19','2025-12-03 22:53:58',NULL,0,9,'9e39f529b7be4d20a35fb40e772872cb','volumes',0,0,NULL,1),('2025-12-03 22:53:19','2025-12-03 22:53:58',NULL,0,10,'9e39f529b7be4d20a35fb40e772872cb','gigabytes',0,0,NULL,1),('2025-12-03 22:53:19','2025-12-03 22:53:58',NULL,0,11,'9e39f529b7be4d20a35fb40e772872cb','volumes___DEFAULT__',0,0,NULL,1),('2025-12-03 22:53:19','2025-12-03 22:53:58',NULL,0,12,'9e39f529b7be4d20a35fb40e772872cb','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-03 22:53:35','2025-12-03 22:54:05',NULL,0,13,'5609e6f02f014669b58967ff0e930abd','volumes',0,0,NULL,1),('2025-12-03 22:53:35','2025-12-03 22:54:05',NULL,0,14,'5609e6f02f014669b58967ff0e930abd','gigabytes',0,0,NULL,1),('2025-12-03 22:53:35','2025-12-03 22:54:05',NULL,0,15,'5609e6f02f014669b58967ff0e930abd','volumes___DEFAULT__',0,0,NULL,1),('2025-12-03 22:53:35','2025-12-03 22:54:05',NULL,0,16,'5609e6f02f014669b58967ff0e930abd','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-03 22:55:23','2025-12-03 22:56:51',NULL,0,17,'dbb2710d867347c5b4a3eeb47ef0e6a0','volumes',0,0,NULL,1),('2025-12-03 22:55:23','2025-12-03 22:56:51',NULL,0,18,'dbb2710d867347c5b4a3eeb47ef0e6a0','gigabytes',0,0,NULL,1),('2025-12-03 22:55:23','2025-12-03 22:55:51',NULL,0,19,'dbb2710d867347c5b4a3eeb47ef0e6a0','volumes_tempest-scenario-type-cryptsetup-872248707',0,0,NULL,1),('2025-12-03 22:55:23','2025-12-03 22:55:51',NULL,0,20,'dbb2710d867347c5b4a3eeb47ef0e6a0','gigabytes_tempest-scenario-type-cryptsetup-872248707',0,0,NULL,1),('2025-12-03 22:56:21','2025-12-03 22:56:51',NULL,0,21,'dbb2710d867347c5b4a3eeb47ef0e6a0','volumes_tempest-scenario-type-luks-1546695227',0,0,NULL,1),('2025-12-03 22:56:21','2025-12-03 22:56:51',NULL,0,22,'dbb2710d867347c5b4a3eeb47ef0e6a0','gigabytes_tempest-scenario-type-luks-1546695227',0,0,NULL,1),('2025-12-03 22:58:31','2025-12-03 23:02:24',NULL,0,23,'9bf6771e795f41a4b232098116b975b1','volumes',0,0,NULL,1),('2025-12-03 22:58:31','2025-12-03 23:02:24',NULL,0,24,'9bf6771e795f41a4b232098116b975b1','gigabytes',0,0,NULL,1),('2025-12-03 22:58:31','2025-12-03 22:59:49',NULL,0,25,'9bf6771e795f41a4b232098116b975b1','volumes_tempest-scenario-type-cryptsetup-1643023224',0,0,NULL,1),('2025-12-03 22:58:31','2025-12-03 22:59:49',NULL,0,26,'9bf6771e795f41a4b232098116b975b1','gigabytes_tempest-scenario-type-cryptsetup-1643023224',0,0,NULL,1),('2025-12-03 22:58:51','2025-12-03 23:01:40',NULL,0,27,'26d36ac1678744fabdbe8d702fccfb9d','volumes',0,0,NULL,1),('2025-12-03 22:58:51','2025-12-03 23:01:40',NULL,0,28,'26d36ac1678744fabdbe8d702fccfb9d','gigabytes',0,0,NULL,1),('2025-12-03 22:58:51','2025-12-03 23:01:40',NULL,0,29,'26d36ac1678744fabdbe8d702fccfb9d','volumes___DEFAULT__',0,0,NULL,1),('2025-12-03 22:58:51','2025-12-03 23:01:40',NULL,0,30,'26d36ac1678744fabdbe8d702fccfb9d','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-03 22:59:01','2025-12-03 22:59:17',NULL,0,31,'26d36ac1678744fabdbe8d702fccfb9d','snapshots',0,0,NULL,1),('2025-12-03 22:59:01','2025-12-03 22:59:17',NULL,0,32,'26d36ac1678744fabdbe8d702fccfb9d','snapshots___DEFAULT__',0,0,NULL,1),('2025-12-03 22:59:51','2025-12-03 23:01:10',NULL,0,33,'9bf6771e795f41a4b232098116b975b1','volumes_tempest-scenario-type-luks-284497772',0,0,NULL,1),('2025-12-03 22:59:51','2025-12-03 23:01:10',NULL,0,34,'9bf6771e795f41a4b232098116b975b1','gigabytes_tempest-scenario-type-luks-284497772',0,0,NULL,1),('2025-12-03 23:01:13','2025-12-03 23:02:24',NULL,0,35,'9bf6771e795f41a4b232098116b975b1','volumes_tempest-scenario-type-luksv2-1021171620',0,0,NULL,1),('2025-12-03 23:01:13','2025-12-03 23:02:24',NULL,0,36,'9bf6771e795f41a4b232098116b975b1','gigabytes_tempest-scenario-type-luksv2-1021171620',0,0,NULL,1),('2025-12-03 23:15:50','2025-12-03 23:18:04',NULL,0,37,'0ebc213514c247388f90f7a4b0b39e1e','volumes',0,0,NULL,1),('2025-12-03 23:15:50','2025-12-03 23:18:04',NULL,0,38,'0ebc213514c247388f90f7a4b0b39e1e','gigabytes',0,0,NULL,1),('2025-12-03 23:15:50','2025-12-03 23:18:04',NULL,0,39,'0ebc213514c247388f90f7a4b0b39e1e','volumes___DEFAULT__',0,0,NULL,1),('2025-12-03 23:15:50','2025-12-03 23:18:04',NULL,0,40,'0ebc213514c247388f90f7a4b0b39e1e','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-03 23:16:34','2025-12-03 23:17:56',NULL,0,41,'0ebc213514c247388f90f7a4b0b39e1e','snapshots',0,0,NULL,1),('2025-12-03 23:16:34','2025-12-03 23:17:56',NULL,0,42,'0ebc213514c247388f90f7a4b0b39e1e','snapshots___DEFAULT__',0,0,NULL,1),('2025-12-03 23:18:47','2025-12-03 23:19:09',NULL,0,43,'e014ab433f1c45e4bdfa23184aca2555','volumes',0,0,NULL,1),('2025-12-03 23:18:47','2025-12-03 23:19:09',NULL,0,44,'e014ab433f1c45e4bdfa23184aca2555','gigabytes',0,0,NULL,1),('2025-12-03 23:18:47','2025-12-03 23:19:09',NULL,0,45,'e014ab433f1c45e4bdfa23184aca2555','volumes___DEFAULT__',0,0,NULL,1),('2025-12-03 23:18:47','2025-12-03 23:19:09',NULL,0,46,'e014ab433f1c45e4bdfa23184aca2555','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-03 23:18:55','2025-12-03 23:19:07',NULL,0,47,'e014ab433f1c45e4bdfa23184aca2555','backups',0,0,NULL,1),('2025-12-03 23:18:55','2025-12-03 23:19:07',NULL,0,48,'e014ab433f1c45e4bdfa23184aca2555','backup_gigabytes',0,0,NULL,1),('2025-12-03 23:32:42','2025-12-03 23:39:58',NULL,0,49,'17135a905ddc412883361a7397e2e39c','volumes',0,0,NULL,1),('2025-12-03 23:32:42','2025-12-03 23:39:58',NULL,0,50,'17135a905ddc412883361a7397e2e39c','gigabytes',0,0,NULL,1),('2025-12-03 23:32:42','2025-12-03 23:33:15',NULL,0,51,'17135a905ddc412883361a7397e2e39c','volumes_tempest-scenario-type-luks-1072837293',0,0,NULL,1),('2025-12-03 23:32:42','2025-12-03 23:33:15',NULL,0,52,'17135a905ddc412883361a7397e2e39c','gigabytes_tempest-scenario-type-luks-1072837293',0,0,NULL,1),('2025-12-03 23:33:17','2025-12-03 23:34:02',NULL,0,53,'17135a905ddc412883361a7397e2e39c','volumes_tempest-scenario-type-luks2-1265354225',0,0,NULL,1),('2025-12-03 23:33:17','2025-12-03 23:34:02',NULL,0,54,'17135a905ddc412883361a7397e2e39c','gigabytes_tempest-scenario-type-luks2-1265354225',0,0,NULL,1),('2025-12-03 23:34:04','2025-12-03 23:39:58',NULL,0,55,'17135a905ddc412883361a7397e2e39c','volumes___DEFAULT__',0,0,NULL,1),('2025-12-03 23:34:04','2025-12-03 23:39:58',NULL,0,56,'17135a905ddc412883361a7397e2e39c','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-03 23:34:14','2025-12-03 23:39:48',NULL,0,57,'17135a905ddc412883361a7397e2e39c','snapshots',0,0,NULL,1),('2025-12-03 23:34:14','2025-12-03 23:39:48',NULL,0,58,'17135a905ddc412883361a7397e2e39c','snapshots___DEFAULT__',0,0,NULL,1),('2025-12-03 23:40:59','2025-12-03 23:41:20',NULL,0,59,'736cfa939ed54e37b1dae7d67c7093e6','volumes',0,0,NULL,1),('2025-12-03 23:40:59','2025-12-03 23:41:20',NULL,0,60,'736cfa939ed54e37b1dae7d67c7093e6','gigabytes',0,0,NULL,1),('2025-12-03 23:40:59','2025-12-03 23:41:20',NULL,0,61,'736cfa939ed54e37b1dae7d67c7093e6','volumes___DEFAULT__',0,0,NULL,1),('2025-12-03 23:40:59','2025-12-03 23:41:20',NULL,0,62,'736cfa939ed54e37b1dae7d67c7093e6','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-03 23:41:08','2025-12-03 23:41:18',NULL,0,63,'736cfa939ed54e37b1dae7d67c7093e6','backups',0,0,NULL,1),('2025-12-03 23:41:08','2025-12-03 23:41:18',NULL,0,64,'736cfa939ed54e37b1dae7d67c7093e6','backup_gigabytes',0,0,NULL,1);
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=273 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `allocated_id`) VALUES ('2025-12-03 22:50:28','2025-12-03 22:50:28','2025-12-03 22:50:28',1,1,'843004df-cd83-401b-aadb-60bbb86fa0e2',1,'771bd7b64c5e4f84bdc615bbe9783218','volumes',1,'2025-12-04 22:50:28',NULL),('2025-12-03 22:50:28','2025-12-03 22:50:28','2025-12-03 22:50:28',1,2,'2257d8bb-ccae-4b8b-adb9-2423a03745fe',2,'771bd7b64c5e4f84bdc615bbe9783218','gigabytes',1,'2025-12-04 22:50:28',NULL),('2025-12-03 22:50:28','2025-12-03 22:50:28','2025-12-03 22:50:28',1,3,'564c8b85-c95f-48ca-ab66-d30c6ba0045c',3,'771bd7b64c5e4f84bdc615bbe9783218','volumes___DEFAULT__',1,'2025-12-04 22:50:28',NULL),('2025-12-03 22:50:28','2025-12-03 22:50:28','2025-12-03 22:50:28',1,4,'faf38402-0cc5-448d-b1ae-4923a21adf0c',4,'771bd7b64c5e4f84bdc615bbe9783218','gigabytes___DEFAULT__',1,'2025-12-04 22:50:28',NULL),('2025-12-03 22:50:31','2025-12-03 22:50:32','2025-12-03 22:50:32',1,5,'acbb11ca-dd45-4e87-bb7d-0dc835e47648',1,'771bd7b64c5e4f84bdc615bbe9783218','volumes',1,'2025-12-04 22:50:31',NULL),('2025-12-03 22:50:31','2025-12-03 22:50:32','2025-12-03 22:50:32',1,6,'f798e2ef-d4e0-4c85-bcc2-8d0d9e189b54',2,'771bd7b64c5e4f84bdc615bbe9783218','gigabytes',1,'2025-12-04 22:50:31',NULL),('2025-12-03 22:50:31','2025-12-03 22:50:32','2025-12-03 22:50:32',1,7,'f46387c1-42d3-4bcc-b95a-b91b053e8731',3,'771bd7b64c5e4f84bdc615bbe9783218','volumes___DEFAULT__',1,'2025-12-04 22:50:31',NULL),('2025-12-03 22:50:31','2025-12-03 22:50:32','2025-12-03 22:50:32',1,8,'bf11b275-dd91-4a66-a795-d0e510d58224',4,'771bd7b64c5e4f84bdc615bbe9783218','gigabytes___DEFAULT__',1,'2025-12-04 22:50:31',NULL),('2025-12-03 22:50:34','2025-12-03 22:50:34','2025-12-03 22:50:34',1,9,'efaec876-f73e-42d4-901c-7d3eb7b006f0',1,'771bd7b64c5e4f84bdc615bbe9783218','volumes',1,'2025-12-04 22:50:34',NULL),('2025-12-03 22:50:34','2025-12-03 22:50:34','2025-12-03 22:50:34',1,10,'58bdf34a-2732-41e9-ad01-20fb252a1264',2,'771bd7b64c5e4f84bdc615bbe9783218','gigabytes',1,'2025-12-04 22:50:34',NULL),('2025-12-03 22:50:34','2025-12-03 22:50:34','2025-12-03 22:50:34',1,11,'6a9e750d-f4ce-4b00-a9dd-9a483ccbbd54',3,'771bd7b64c5e4f84bdc615bbe9783218','volumes___DEFAULT__',1,'2025-12-04 22:50:34',NULL),('2025-12-03 22:50:34','2025-12-03 22:50:34','2025-12-03 22:50:34',1,12,'932e32b4-6f05-4d68-92c6-335e03f35a6a',4,'771bd7b64c5e4f84bdc615bbe9783218','gigabytes___DEFAULT__',1,'2025-12-04 22:50:34',NULL),('2025-12-03 22:50:39','2025-12-03 22:50:39','2025-12-03 22:50:39',1,13,'12578507-2247-4008-85cb-886d257d9477',1,'771bd7b64c5e4f84bdc615bbe9783218','volumes',-1,'2025-12-04 22:50:39',NULL),('2025-12-03 22:50:39','2025-12-03 22:50:39','2025-12-03 22:50:39',1,14,'e97b40d6-1d7c-4088-a2c9-484a20dbf00d',2,'771bd7b64c5e4f84bdc615bbe9783218','gigabytes',-1,'2025-12-04 22:50:39',NULL),('2025-12-03 22:50:39','2025-12-03 22:50:39','2025-12-03 22:50:39',1,15,'097dee02-fa0f-41eb-bd6f-11ccea687d83',3,'771bd7b64c5e4f84bdc615bbe9783218','volumes___DEFAULT__',-1,'2025-12-04 22:50:39',NULL),('2025-12-03 22:50:39','2025-12-03 22:50:39','2025-12-03 22:50:39',1,16,'855cf704-af1b-409d-8f85-3f4ccf8e0848',4,'771bd7b64c5e4f84bdc615bbe9783218','gigabytes___DEFAULT__',-1,'2025-12-04 22:50:39',NULL),('2025-12-03 22:50:43','2025-12-03 22:50:44','2025-12-03 22:50:44',1,17,'29902a88-af80-44df-8792-deb99bf7a420',1,'771bd7b64c5e4f84bdc615bbe9783218','volumes',-1,'2025-12-04 22:50:43',NULL),('2025-12-03 22:50:43','2025-12-03 22:50:44','2025-12-03 22:50:44',1,18,'8a2aee5a-2bbd-435b-be07-940dc28b6cbe',2,'771bd7b64c5e4f84bdc615bbe9783218','gigabytes',-1,'2025-12-04 22:50:43',NULL),('2025-12-03 22:50:43','2025-12-03 22:50:44','2025-12-03 22:50:44',1,19,'fefe29cc-de40-4db1-ae8a-69c52f358975',3,'771bd7b64c5e4f84bdc615bbe9783218','volumes___DEFAULT__',-1,'2025-12-04 22:50:43',NULL),('2025-12-03 22:50:43','2025-12-03 22:50:44','2025-12-03 22:50:44',1,20,'524eaee7-111a-4ce5-93af-a8545cf2c5dd',4,'771bd7b64c5e4f84bdc615bbe9783218','gigabytes___DEFAULT__',-1,'2025-12-04 22:50:43',NULL),('2025-12-03 22:50:46','2025-12-03 22:50:46','2025-12-03 22:50:46',1,21,'34f971b1-6ebd-44a5-908f-34520109b1cf',1,'771bd7b64c5e4f84bdc615bbe9783218','volumes',-1,'2025-12-04 22:50:46',NULL),('2025-12-03 22:50:46','2025-12-03 22:50:46','2025-12-03 22:50:46',1,22,'4a7a8e8f-9f8f-4aa4-9358-1f34bd27e636',2,'771bd7b64c5e4f84bdc615bbe9783218','gigabytes',-1,'2025-12-04 22:50:46',NULL),('2025-12-03 22:50:46','2025-12-03 22:50:46','2025-12-03 22:50:46',1,23,'85af6a4b-0c9b-4293-a815-d128c630dee0',3,'771bd7b64c5e4f84bdc615bbe9783218','volumes___DEFAULT__',-1,'2025-12-04 22:50:46',NULL),('2025-12-03 22:50:46','2025-12-03 22:50:46','2025-12-03 22:50:46',1,24,'b7f242a6-621f-4c97-95e5-2e2f6e0d60e1',4,'771bd7b64c5e4f84bdc615bbe9783218','gigabytes___DEFAULT__',-1,'2025-12-04 22:50:46',NULL),('2025-12-03 22:52:25','2025-12-03 22:52:25','2025-12-03 22:52:25',1,25,'59393b66-fae9-4018-9db4-2c5ced178fa4',5,'301200c274804774ab9b73b272642d78','volumes',1,'2025-12-04 22:52:25',NULL),('2025-12-03 22:52:25','2025-12-03 22:52:25','2025-12-03 22:52:25',1,26,'794db072-b029-49e2-80e2-31272ecd7706',6,'301200c274804774ab9b73b272642d78','gigabytes',1,'2025-12-04 22:52:25',NULL),('2025-12-03 22:52:25','2025-12-03 22:52:25','2025-12-03 22:52:25',1,27,'7d905db2-ee63-4973-8aca-2cc863d26a0f',7,'301200c274804774ab9b73b272642d78','volumes___DEFAULT__',1,'2025-12-04 22:52:25',NULL),('2025-12-03 22:52:25','2025-12-03 22:52:25','2025-12-03 22:52:25',1,28,'e737d33e-f947-472b-8884-4d0062476133',8,'301200c274804774ab9b73b272642d78','gigabytes___DEFAULT__',1,'2025-12-04 22:52:25',NULL),('2025-12-03 22:53:19','2025-12-03 22:53:19','2025-12-03 22:53:19',1,29,'f7be18f1-041c-4d30-8de0-552e16e8f403',9,'9e39f529b7be4d20a35fb40e772872cb','volumes',1,'2025-12-04 22:53:19',NULL),('2025-12-03 22:53:19','2025-12-03 22:53:19','2025-12-03 22:53:19',1,30,'52679a97-aade-4e46-9c54-2e5c2a212368',10,'9e39f529b7be4d20a35fb40e772872cb','gigabytes',1,'2025-12-04 22:53:19',NULL),('2025-12-03 22:53:19','2025-12-03 22:53:19','2025-12-03 22:53:19',1,31,'8587e621-ca67-4750-8980-922e246a672a',11,'9e39f529b7be4d20a35fb40e772872cb','volumes___DEFAULT__',1,'2025-12-04 22:53:19',NULL),('2025-12-03 22:53:19','2025-12-03 22:53:19','2025-12-03 22:53:19',1,32,'bc4298b4-759a-40cb-90d8-b6fbc0ca94ef',12,'9e39f529b7be4d20a35fb40e772872cb','gigabytes___DEFAULT__',1,'2025-12-04 22:53:19',NULL),('2025-12-03 22:53:25','2025-12-03 22:53:25','2025-12-03 22:53:25',1,33,'77ccd0cd-2aee-4e1a-b0c2-a3c02959a662',5,'301200c274804774ab9b73b272642d78','volumes',-1,'2025-12-04 22:53:25',NULL),('2025-12-03 22:53:25','2025-12-03 22:53:25','2025-12-03 22:53:25',1,34,'f3792fba-4607-4a1d-9333-489d3db1d92c',6,'301200c274804774ab9b73b272642d78','gigabytes',-1,'2025-12-04 22:53:25',NULL),('2025-12-03 22:53:25','2025-12-03 22:53:25','2025-12-03 22:53:25',1,35,'e80df6f9-ecbf-41a0-bf30-4f5ab9c7cef1',7,'301200c274804774ab9b73b272642d78','volumes___DEFAULT__',-1,'2025-12-04 22:53:25',NULL),('2025-12-03 22:53:25','2025-12-03 22:53:25','2025-12-03 22:53:25',1,36,'fb4805eb-ac1c-4f32-9d76-3669f89941c0',8,'301200c274804774ab9b73b272642d78','gigabytes___DEFAULT__',-1,'2025-12-04 22:53:25',NULL),('2025-12-03 22:53:35','2025-12-03 22:53:35','2025-12-03 22:53:35',1,37,'4e39e6cd-f29b-447e-81c0-8e2745a64138',13,'5609e6f02f014669b58967ff0e930abd','volumes',1,'2025-12-04 22:53:35',NULL),('2025-12-03 22:53:35','2025-12-03 22:53:35','2025-12-03 22:53:35',1,38,'39f7509d-8403-4cd8-8891-81af6861ff99',14,'5609e6f02f014669b58967ff0e930abd','gigabytes',1,'2025-12-04 22:53:35',NULL),('2025-12-03 22:53:35','2025-12-03 22:53:35','2025-12-03 22:53:35',1,39,'1cc46f63-91ad-4ff9-845f-1986adbb37b5',15,'5609e6f02f014669b58967ff0e930abd','volumes___DEFAULT__',1,'2025-12-04 22:53:35',NULL),('2025-12-03 22:53:35','2025-12-03 22:53:35','2025-12-03 22:53:35',1,40,'d992a2be-e7f2-41ef-8030-7b3e70068bfd',16,'5609e6f02f014669b58967ff0e930abd','gigabytes___DEFAULT__',1,'2025-12-04 22:53:35',NULL),('2025-12-03 22:53:38','2025-12-03 22:53:38','2025-12-03 22:53:38',1,41,'2bd233b9-65f8-4e54-9bf1-9356f1dcef09',13,'5609e6f02f014669b58967ff0e930abd','volumes',1,'2025-12-04 22:53:38',NULL),('2025-12-03 22:53:38','2025-12-03 22:53:38','2025-12-03 22:53:38',1,42,'2eb9b55f-3b88-4bca-a54f-ae565051d944',14,'5609e6f02f014669b58967ff0e930abd','gigabytes',1,'2025-12-04 22:53:38',NULL),('2025-12-03 22:53:38','2025-12-03 22:53:38','2025-12-03 22:53:38',1,43,'9d5da3b9-a84b-4ccb-82b4-cf6a0a7baae4',15,'5609e6f02f014669b58967ff0e930abd','volumes___DEFAULT__',1,'2025-12-04 22:53:38',NULL),('2025-12-03 22:53:38','2025-12-03 22:53:38','2025-12-03 22:53:38',1,44,'05b140ea-f84d-44f3-8ccb-c3044d24f04b',16,'5609e6f02f014669b58967ff0e930abd','gigabytes___DEFAULT__',1,'2025-12-04 22:53:38',NULL),('2025-12-03 22:53:42','2025-12-03 22:53:42','2025-12-03 22:53:42',1,45,'18323969-a6b0-44c9-acc2-a966f45b9c26',13,'5609e6f02f014669b58967ff0e930abd','volumes',-1,'2025-12-04 22:53:42',NULL),('2025-12-03 22:53:42','2025-12-03 22:53:42','2025-12-03 22:53:42',1,46,'ab33f5bd-42e6-43e8-b38a-5296fdfeae2c',14,'5609e6f02f014669b58967ff0e930abd','gigabytes',-1,'2025-12-04 22:53:42',NULL),('2025-12-03 22:53:42','2025-12-03 22:53:42','2025-12-03 22:53:42',1,47,'c032cc71-7da7-44b1-89f6-393bbfd6bfa1',15,'5609e6f02f014669b58967ff0e930abd','volumes___DEFAULT__',-1,'2025-12-04 22:53:42',NULL),('2025-12-03 22:53:42','2025-12-03 22:53:42','2025-12-03 22:53:42',1,48,'99b339af-2210-4374-a8b8-c54663b65f17',16,'5609e6f02f014669b58967ff0e930abd','gigabytes___DEFAULT__',-1,'2025-12-04 22:53:42',NULL),('2025-12-03 22:53:45','2025-12-03 22:53:45','2025-12-03 22:53:45',1,49,'0f4a4edd-dc84-432f-95d5-0cdcad5feb48',13,'5609e6f02f014669b58967ff0e930abd','volumes',-1,'2025-12-04 22:53:45',NULL),('2025-12-03 22:53:45','2025-12-03 22:53:45','2025-12-03 22:53:45',1,50,'1ecc4f8f-f24c-4f9b-ab5f-f95c37ad3fe7',14,'5609e6f02f014669b58967ff0e930abd','gigabytes',-1,'2025-12-04 22:53:45',NULL),('2025-12-03 22:53:45','2025-12-03 22:53:45','2025-12-03 22:53:45',1,51,'96bf672a-9268-4d92-9b17-d70530057df8',15,'5609e6f02f014669b58967ff0e930abd','volumes___DEFAULT__',-1,'2025-12-04 22:53:45',NULL),('2025-12-03 22:53:45','2025-12-03 22:53:45','2025-12-03 22:53:45',1,52,'458dca8a-5e50-4b4d-b0a8-483f360074d3',16,'5609e6f02f014669b58967ff0e930abd','gigabytes___DEFAULT__',-1,'2025-12-04 22:53:45',NULL),('2025-12-03 22:53:49','2025-12-03 22:53:49','2025-12-03 22:53:49',1,53,'1888e3cb-41f0-4556-ad25-2ab3c1832dfa',13,'5609e6f02f014669b58967ff0e930abd','volumes',1,'2025-12-04 22:53:49',NULL),('2025-12-03 22:53:49','2025-12-03 22:53:49','2025-12-03 22:53:49',1,54,'bc335bc2-5a5b-4314-84f4-eaa233a9b3a7',14,'5609e6f02f014669b58967ff0e930abd','gigabytes',1,'2025-12-04 22:53:49',NULL),('2025-12-03 22:53:49','2025-12-03 22:53:49','2025-12-03 22:53:49',1,55,'a3d0b9b1-6c1a-4f31-ad29-daed172fda41',15,'5609e6f02f014669b58967ff0e930abd','volumes___DEFAULT__',1,'2025-12-04 22:53:49',NULL),('2025-12-03 22:53:49','2025-12-03 22:53:49','2025-12-03 22:53:49',1,56,'e2cbe9e7-8fbe-48e4-ad3a-61339b811f2e',16,'5609e6f02f014669b58967ff0e930abd','gigabytes___DEFAULT__',1,'2025-12-04 22:53:49',NULL),('2025-12-03 22:53:58','2025-12-03 22:53:58','2025-12-03 22:53:58',1,57,'f8a197ab-c10f-4e9a-82a8-e56200bf73b6',9,'9e39f529b7be4d20a35fb40e772872cb','volumes',-1,'2025-12-04 22:53:58',NULL),('2025-12-03 22:53:58','2025-12-03 22:53:58','2025-12-03 22:53:58',1,58,'55af4aa3-bf7f-412e-9c15-1ff63852961e',10,'9e39f529b7be4d20a35fb40e772872cb','gigabytes',-1,'2025-12-04 22:53:58',NULL),('2025-12-03 22:53:58','2025-12-03 22:53:58','2025-12-03 22:53:58',1,59,'3167cfbe-71ee-4f48-b6b8-b4ccc87bb7bd',11,'9e39f529b7be4d20a35fb40e772872cb','volumes___DEFAULT__',-1,'2025-12-04 22:53:58',NULL),('2025-12-03 22:53:58','2025-12-03 22:53:58','2025-12-03 22:53:58',1,60,'0d352c36-b0ca-49f0-b85b-7eeeccb2f179',12,'9e39f529b7be4d20a35fb40e772872cb','gigabytes___DEFAULT__',-1,'2025-12-04 22:53:58',NULL),('2025-12-03 22:53:59','2025-12-03 22:53:59','2025-12-03 22:53:59',1,61,'08c18436-30a2-4b55-ad4d-f735410a5a9b',13,'5609e6f02f014669b58967ff0e930abd','volumes',1,'2025-12-04 22:53:59',NULL),('2025-12-03 22:53:59','2025-12-03 22:53:59','2025-12-03 22:53:59',1,62,'8a586dab-3a90-45d9-b735-96813b517296',14,'5609e6f02f014669b58967ff0e930abd','gigabytes',1,'2025-12-04 22:53:59',NULL),('2025-12-03 22:53:59','2025-12-03 22:53:59','2025-12-03 22:53:59',1,63,'e6075c53-89d3-40dd-872c-5fdaa2332cf6',15,'5609e6f02f014669b58967ff0e930abd','volumes___DEFAULT__',1,'2025-12-04 22:53:59',NULL),('2025-12-03 22:53:59','2025-12-03 22:53:59','2025-12-03 22:53:59',1,64,'95465df5-85a3-4fbc-8aa9-6c05e99efd81',16,'5609e6f02f014669b58967ff0e930abd','gigabytes___DEFAULT__',1,'2025-12-04 22:53:59',NULL),('2025-12-03 22:54:03','2025-12-03 22:54:03','2025-12-03 22:54:03',1,65,'c3313edb-a032-4421-9461-94e9533228ca',13,'5609e6f02f014669b58967ff0e930abd','volumes',-1,'2025-12-04 22:54:03',NULL),('2025-12-03 22:54:03','2025-12-03 22:54:03','2025-12-03 22:54:03',1,66,'1176364f-b008-4f4d-b2f8-42b570174c6c',14,'5609e6f02f014669b58967ff0e930abd','gigabytes',-1,'2025-12-04 22:54:03',NULL),('2025-12-03 22:54:03','2025-12-03 22:54:03','2025-12-03 22:54:03',1,67,'bde95a84-029e-42e9-8d59-7d24d19c91b7',15,'5609e6f02f014669b58967ff0e930abd','volumes___DEFAULT__',-1,'2025-12-04 22:54:03',NULL),('2025-12-03 22:54:03','2025-12-03 22:54:03','2025-12-03 22:54:03',1,68,'9fa16bbc-be45-4ee5-a9f5-33a01cd635a9',16,'5609e6f02f014669b58967ff0e930abd','gigabytes___DEFAULT__',-1,'2025-12-04 22:54:03',NULL),('2025-12-03 22:54:05','2025-12-03 22:54:05','2025-12-03 22:54:05',1,69,'d456d3c7-6966-43ff-81bd-a8c7339b048e',13,'5609e6f02f014669b58967ff0e930abd','volumes',-1,'2025-12-04 22:54:05',NULL),('2025-12-03 22:54:05','2025-12-03 22:54:05','2025-12-03 22:54:05',1,70,'126670d0-4441-4bb1-a472-027495f2417d',14,'5609e6f02f014669b58967ff0e930abd','gigabytes',-1,'2025-12-04 22:54:05',NULL),('2025-12-03 22:54:05','2025-12-03 22:54:05','2025-12-03 22:54:05',1,71,'da350794-df9d-4ea0-94be-46b405496c82',15,'5609e6f02f014669b58967ff0e930abd','volumes___DEFAULT__',-1,'2025-12-04 22:54:05',NULL),('2025-12-03 22:54:05','2025-12-03 22:54:05','2025-12-03 22:54:05',1,72,'a20aab85-91f0-47df-8f0d-335fba7af3d3',16,'5609e6f02f014669b58967ff0e930abd','gigabytes___DEFAULT__',-1,'2025-12-04 22:54:05',NULL),('2025-12-03 22:55:23','2025-12-03 22:55:24','2025-12-03 22:55:23',1,73,'df263363-53d5-42fa-8026-31241331f3b5',17,'dbb2710d867347c5b4a3eeb47ef0e6a0','volumes',1,'2025-12-04 22:55:23',NULL),('2025-12-03 22:55:23','2025-12-03 22:55:23','2025-12-03 22:55:23',1,74,'546b71f7-b64d-41cc-830d-727463948ec7',18,'dbb2710d867347c5b4a3eeb47ef0e6a0','gigabytes',1,'2025-12-04 22:55:23',NULL),('2025-12-03 22:55:23','2025-12-03 22:55:23','2025-12-03 22:55:23',1,75,'103e684c-82fd-4b34-bc6e-4921aa91e5c3',19,'dbb2710d867347c5b4a3eeb47ef0e6a0','volumes_tempest-scenario-type-cryptsetup-872248707',1,'2025-12-04 22:55:23',NULL),('2025-12-03 22:55:23','2025-12-03 22:55:23','2025-12-03 22:55:23',1,76,'69c4e3ac-3108-49a8-b65d-724ca5f1e675',20,'dbb2710d867347c5b4a3eeb47ef0e6a0','gigabytes_tempest-scenario-type-cryptsetup-872248707',1,'2025-12-04 22:55:23',NULL),('2025-12-03 22:55:51','2025-12-03 22:55:51','2025-12-03 22:55:51',1,77,'0fc36e09-a253-49c9-ae00-0b3beac2e4db',17,'dbb2710d867347c5b4a3eeb47ef0e6a0','volumes',-1,'2025-12-04 22:55:51',NULL),('2025-12-03 22:55:51','2025-12-03 22:55:51','2025-12-03 22:55:51',1,78,'8608da5a-3e14-44a5-bbb9-7bb512fa61dc',18,'dbb2710d867347c5b4a3eeb47ef0e6a0','gigabytes',-1,'2025-12-04 22:55:51',NULL),('2025-12-03 22:55:51','2025-12-03 22:55:51','2025-12-03 22:55:51',1,79,'46ff95e6-6cdf-4f7f-a2ab-32e5dd3625f5',19,'dbb2710d867347c5b4a3eeb47ef0e6a0','volumes_tempest-scenario-type-cryptsetup-872248707',-1,'2025-12-04 22:55:51',NULL),('2025-12-03 22:55:51','2025-12-03 22:55:51','2025-12-03 22:55:51',1,80,'2f39e715-7c3a-4485-bdad-8239c2c74c3b',20,'dbb2710d867347c5b4a3eeb47ef0e6a0','gigabytes_tempest-scenario-type-cryptsetup-872248707',-1,'2025-12-04 22:55:51',NULL),('2025-12-03 22:56:21','2025-12-03 22:56:21','2025-12-03 22:56:21',1,81,'da40bbf2-43da-4ebd-996a-ba401668cd11',17,'dbb2710d867347c5b4a3eeb47ef0e6a0','volumes',1,'2025-12-04 22:56:21',NULL),('2025-12-03 22:56:21','2025-12-03 22:56:21','2025-12-03 22:56:21',1,82,'ecaf3648-57bf-41be-8c46-20ccdc6b9051',18,'dbb2710d867347c5b4a3eeb47ef0e6a0','gigabytes',1,'2025-12-04 22:56:21',NULL),('2025-12-03 22:56:21','2025-12-03 22:56:21','2025-12-03 22:56:21',1,83,'9a8b1435-1634-419c-bf20-8244cc3fbff9',21,'dbb2710d867347c5b4a3eeb47ef0e6a0','volumes_tempest-scenario-type-luks-1546695227',1,'2025-12-04 22:56:21',NULL),('2025-12-03 22:56:21','2025-12-03 22:56:21','2025-12-03 22:56:21',1,84,'a6189948-9449-4c05-99e0-68d768e98312',22,'dbb2710d867347c5b4a3eeb47ef0e6a0','gigabytes_tempest-scenario-type-luks-1546695227',1,'2025-12-04 22:56:21',NULL),('2025-12-03 22:56:51','2025-12-03 22:56:51','2025-12-03 22:56:51',1,85,'b91ca7aa-6653-4280-9ad8-9e3e93fde5dd',17,'dbb2710d867347c5b4a3eeb47ef0e6a0','volumes',-1,'2025-12-04 22:56:51',NULL),('2025-12-03 22:56:51','2025-12-03 22:56:51','2025-12-03 22:56:51',1,86,'6bfab31b-5a58-4a7c-af82-d9319e3300cc',18,'dbb2710d867347c5b4a3eeb47ef0e6a0','gigabytes',-1,'2025-12-04 22:56:51',NULL),('2025-12-03 22:56:51','2025-12-03 22:56:51','2025-12-03 22:56:51',1,87,'8414348f-3360-4a3b-a470-22d24a763bcc',21,'dbb2710d867347c5b4a3eeb47ef0e6a0','volumes_tempest-scenario-type-luks-1546695227',-1,'2025-12-04 22:56:51',NULL),('2025-12-03 22:56:51','2025-12-03 22:56:51','2025-12-03 22:56:51',1,88,'7280cad9-460d-4213-b11c-c281d5377adc',22,'dbb2710d867347c5b4a3eeb47ef0e6a0','gigabytes_tempest-scenario-type-luks-1546695227',-1,'2025-12-04 22:56:51',NULL),('2025-12-03 22:58:31','2025-12-03 22:58:31','2025-12-03 22:58:31',1,89,'af2014d1-d222-4157-980b-27555c6cf375',23,'9bf6771e795f41a4b232098116b975b1','volumes',1,'2025-12-04 22:58:31',NULL),('2025-12-03 22:58:31','2025-12-03 22:58:31','2025-12-03 22:58:31',1,90,'6207082f-5453-49e7-8f61-c997634e011b',24,'9bf6771e795f41a4b232098116b975b1','gigabytes',1,'2025-12-04 22:58:31',NULL),('2025-12-03 22:58:31','2025-12-03 22:58:31','2025-12-03 22:58:31',1,91,'a50f70d0-548d-4a64-8213-d3c4acf0c985',25,'9bf6771e795f41a4b232098116b975b1','volumes_tempest-scenario-type-cryptsetup-1643023224',1,'2025-12-04 22:58:31',NULL),('2025-12-03 22:58:31','2025-12-03 22:58:31','2025-12-03 22:58:31',1,92,'60b2c717-fab1-4066-a063-794d73d67736',26,'9bf6771e795f41a4b232098116b975b1','gigabytes_tempest-scenario-type-cryptsetup-1643023224',1,'2025-12-04 22:58:31',NULL),('2025-12-03 22:58:51','2025-12-03 22:58:51','2025-12-03 22:58:51',1,93,'3aade6d4-14aa-48ab-a2bb-3d9e5c02cdcf',27,'26d36ac1678744fabdbe8d702fccfb9d','volumes',1,'2025-12-04 22:58:51',NULL),('2025-12-03 22:58:51','2025-12-03 22:58:51','2025-12-03 22:58:51',1,94,'47731f33-a3fb-4f61-8ed7-ca128276680f',28,'26d36ac1678744fabdbe8d702fccfb9d','gigabytes',1,'2025-12-04 22:58:51',NULL),('2025-12-03 22:58:51','2025-12-03 22:58:51','2025-12-03 22:58:51',1,95,'406c937b-9c8f-451b-911c-9d60c4b2dc36',29,'26d36ac1678744fabdbe8d702fccfb9d','volumes___DEFAULT__',1,'2025-12-04 22:58:51',NULL),('2025-12-03 22:58:51','2025-12-03 22:58:51','2025-12-03 22:58:51',1,96,'460dd6b7-9237-4de7-b261-38e32c5b6edb',30,'26d36ac1678744fabdbe8d702fccfb9d','gigabytes___DEFAULT__',1,'2025-12-04 22:58:51',NULL),('2025-12-03 22:59:01','2025-12-03 22:59:01','2025-12-03 22:59:01',1,97,'b46c3699-6f2e-4da8-9ce2-bc5a9eced8d2',31,'26d36ac1678744fabdbe8d702fccfb9d','snapshots',1,'2025-12-04 22:59:01',NULL),('2025-12-03 22:59:01','2025-12-03 22:59:01','2025-12-03 22:59:01',1,98,'9bc10ca2-7625-4c04-b46a-337d6fad64d0',28,'26d36ac1678744fabdbe8d702fccfb9d','gigabytes',1,'2025-12-04 22:59:01',NULL),('2025-12-03 22:59:01','2025-12-03 22:59:01','2025-12-03 22:59:01',1,99,'af7ad1ae-0f10-44b3-9a13-4dbd8557ea29',30,'26d36ac1678744fabdbe8d702fccfb9d','gigabytes___DEFAULT__',1,'2025-12-04 22:59:01',NULL),('2025-12-03 22:59:01','2025-12-03 22:59:01','2025-12-03 22:59:01',1,100,'b957f353-f217-4a63-9288-1bd217b6a82c',32,'26d36ac1678744fabdbe8d702fccfb9d','snapshots___DEFAULT__',1,'2025-12-04 22:59:01',NULL),('2025-12-03 22:59:17','2025-12-03 22:59:17','2025-12-03 22:59:17',1,101,'7fdf1a79-d8c8-4c57-8ccb-375a6ef77b01',31,'26d36ac1678744fabdbe8d702fccfb9d','snapshots',-1,'2025-12-04 22:59:17',NULL),('2025-12-03 22:59:17','2025-12-03 22:59:17','2025-12-03 22:59:17',1,102,'3eef0f32-5899-40a5-a0e8-f36092234c4f',28,'26d36ac1678744fabdbe8d702fccfb9d','gigabytes',-1,'2025-12-04 22:59:17',NULL),('2025-12-03 22:59:17','2025-12-03 22:59:17','2025-12-03 22:59:17',1,103,'7b0f985c-0006-490e-8c42-45069c405522',30,'26d36ac1678744fabdbe8d702fccfb9d','gigabytes___DEFAULT__',-1,'2025-12-04 22:59:17',NULL),('2025-12-03 22:59:17','2025-12-03 22:59:17','2025-12-03 22:59:17',1,104,'2ef9cb29-9b61-4113-beb4-40ced7059cf2',32,'26d36ac1678744fabdbe8d702fccfb9d','snapshots___DEFAULT__',-1,'2025-12-04 22:59:17',NULL),('2025-12-03 22:59:49','2025-12-03 22:59:49','2025-12-03 22:59:49',1,105,'ccd1909d-07d6-4198-9145-6eb5bda8ae82',23,'9bf6771e795f41a4b232098116b975b1','volumes',-1,'2025-12-04 22:59:49',NULL),('2025-12-03 22:59:49','2025-12-03 22:59:49','2025-12-03 22:59:49',1,106,'356444f5-d2c4-45b5-b9bf-830babce1c62',24,'9bf6771e795f41a4b232098116b975b1','gigabytes',-1,'2025-12-04 22:59:49',NULL),('2025-12-03 22:59:49','2025-12-03 22:59:49','2025-12-03 22:59:49',1,107,'d095f283-3412-424e-a5a2-c253781c8a1a',25,'9bf6771e795f41a4b232098116b975b1','volumes_tempest-scenario-type-cryptsetup-1643023224',-1,'2025-12-04 22:59:49',NULL),('2025-12-03 22:59:49','2025-12-03 22:59:49','2025-12-03 22:59:49',1,108,'918ee433-bd5b-4a48-afc8-e23e4dc59e5d',26,'9bf6771e795f41a4b232098116b975b1','gigabytes_tempest-scenario-type-cryptsetup-1643023224',-1,'2025-12-04 22:59:49',NULL),('2025-12-03 22:59:51','2025-12-03 22:59:51','2025-12-03 22:59:51',1,109,'b61a3223-5a9e-476f-b16b-173cfc7e451c',23,'9bf6771e795f41a4b232098116b975b1','volumes',1,'2025-12-04 22:59:51',NULL),('2025-12-03 22:59:51','2025-12-03 22:59:51','2025-12-03 22:59:51',1,110,'d69abfd4-c34c-433f-ab82-dbea0bb8374f',24,'9bf6771e795f41a4b232098116b975b1','gigabytes',1,'2025-12-04 22:59:51',NULL),('2025-12-03 22:59:51','2025-12-03 22:59:51','2025-12-03 22:59:51',1,111,'a72bdc5f-6156-49be-b957-92e548ccdd9f',33,'9bf6771e795f41a4b232098116b975b1','volumes_tempest-scenario-type-luks-284497772',1,'2025-12-04 22:59:51',NULL),('2025-12-03 22:59:51','2025-12-03 22:59:51','2025-12-03 22:59:51',1,112,'b4345519-a865-4d42-823b-80af33d7b939',34,'9bf6771e795f41a4b232098116b975b1','gigabytes_tempest-scenario-type-luks-284497772',1,'2025-12-04 22:59:51',NULL),('2025-12-03 23:00:13','2025-12-03 23:00:13','2025-12-03 23:00:13',1,113,'a99e7bb0-9cfa-4f34-8277-28d0759bd5be',27,'26d36ac1678744fabdbe8d702fccfb9d','volumes',-1,'2025-12-04 23:00:13',NULL),('2025-12-03 23:00:13','2025-12-03 23:00:13','2025-12-03 23:00:13',1,114,'661100b3-a6f5-4406-a342-ce2bd2e55f5c',28,'26d36ac1678744fabdbe8d702fccfb9d','gigabytes',-1,'2025-12-04 23:00:13',NULL),('2025-12-03 23:00:13','2025-12-03 23:00:13','2025-12-03 23:00:13',1,115,'75bf2fd4-070f-4adc-863b-c65f3e8b265f',29,'26d36ac1678744fabdbe8d702fccfb9d','volumes___DEFAULT__',-1,'2025-12-04 23:00:13',NULL),('2025-12-03 23:00:13','2025-12-03 23:00:13','2025-12-03 23:00:13',1,116,'07051e39-9220-4752-8049-b364c6fb997f',30,'26d36ac1678744fabdbe8d702fccfb9d','gigabytes___DEFAULT__',-1,'2025-12-04 23:00:13',NULL),('2025-12-03 23:00:33','2025-12-03 23:00:33','2025-12-03 23:00:33',1,117,'6f4fc7de-36a3-496a-a16e-28c7809a6634',27,'26d36ac1678744fabdbe8d702fccfb9d','volumes',1,'2025-12-04 23:00:33',NULL),('2025-12-03 23:00:33','2025-12-03 23:00:33','2025-12-03 23:00:33',1,118,'c1cfe9ea-7bcd-4a93-8505-fe7316624861',28,'26d36ac1678744fabdbe8d702fccfb9d','gigabytes',1,'2025-12-04 23:00:33',NULL),('2025-12-03 23:00:33','2025-12-03 23:00:33','2025-12-03 23:00:33',1,119,'27d745d2-6c3e-487d-8c6c-e94773c31815',29,'26d36ac1678744fabdbe8d702fccfb9d','volumes___DEFAULT__',1,'2025-12-04 23:00:33',NULL),('2025-12-03 23:00:33','2025-12-03 23:00:33','2025-12-03 23:00:33',1,120,'a171b694-c9be-4ff0-8369-a9e3bb0f247b',30,'26d36ac1678744fabdbe8d702fccfb9d','gigabytes___DEFAULT__',1,'2025-12-04 23:00:33',NULL),('2025-12-03 23:01:10','2025-12-03 23:01:10','2025-12-03 23:01:10',1,121,'4dbe6680-4f81-4ed7-90aa-7161a5f3f156',23,'9bf6771e795f41a4b232098116b975b1','volumes',-1,'2025-12-04 23:01:10',NULL),('2025-12-03 23:01:10','2025-12-03 23:01:10','2025-12-03 23:01:10',1,122,'f908cfe3-9786-4d2f-b49e-cd9d01b3ad9e',24,'9bf6771e795f41a4b232098116b975b1','gigabytes',-1,'2025-12-04 23:01:10',NULL),('2025-12-03 23:01:10','2025-12-03 23:01:10','2025-12-03 23:01:10',1,123,'b2898564-2272-4b4c-a372-e72c9bb6b8aa',33,'9bf6771e795f41a4b232098116b975b1','volumes_tempest-scenario-type-luks-284497772',-1,'2025-12-04 23:01:10',NULL),('2025-12-03 23:01:10','2025-12-03 23:01:10','2025-12-03 23:01:10',1,124,'f2e19ada-1f46-42e3-8471-f8d807cae82c',34,'9bf6771e795f41a4b232098116b975b1','gigabytes_tempest-scenario-type-luks-284497772',-1,'2025-12-04 23:01:10',NULL),('2025-12-03 23:01:13','2025-12-03 23:01:13','2025-12-03 23:01:13',1,125,'3dbe7555-84ff-49ff-9014-4b9aaf7e402c',23,'9bf6771e795f41a4b232098116b975b1','volumes',1,'2025-12-04 23:01:13',NULL),('2025-12-03 23:01:13','2025-12-03 23:01:13','2025-12-03 23:01:13',1,126,'9c24cbc1-7dc6-4567-bc7d-ac29e43c2e6a',24,'9bf6771e795f41a4b232098116b975b1','gigabytes',1,'2025-12-04 23:01:13',NULL),('2025-12-03 23:01:13','2025-12-03 23:01:13','2025-12-03 23:01:13',1,127,'26cd54eb-fd9c-4252-8328-3caf7c515bce',35,'9bf6771e795f41a4b232098116b975b1','volumes_tempest-scenario-type-luksv2-1021171620',1,'2025-12-04 23:01:13',NULL),('2025-12-03 23:01:13','2025-12-03 23:01:13','2025-12-03 23:01:13',1,128,'73be479f-8015-475f-b773-0629be4f946f',36,'9bf6771e795f41a4b232098116b975b1','gigabytes_tempest-scenario-type-luksv2-1021171620',1,'2025-12-04 23:01:13',NULL),('2025-12-03 23:01:39','2025-12-03 23:01:40','2025-12-03 23:01:40',1,129,'20c86587-aac3-44da-ad76-f3fd9e1bf1b8',27,'26d36ac1678744fabdbe8d702fccfb9d','volumes',-1,'2025-12-04 23:01:39',NULL),('2025-12-03 23:01:39','2025-12-03 23:01:40','2025-12-03 23:01:40',1,130,'dcc6786f-bfd9-47ba-95c3-609b6a2e4f0b',28,'26d36ac1678744fabdbe8d702fccfb9d','gigabytes',-1,'2025-12-04 23:01:39',NULL),('2025-12-03 23:01:39','2025-12-03 23:01:40','2025-12-03 23:01:40',1,131,'01f3d99e-a694-4ff9-885a-3ac8822e6f0b',29,'26d36ac1678744fabdbe8d702fccfb9d','volumes___DEFAULT__',-1,'2025-12-04 23:01:39',NULL),('2025-12-03 23:01:39','2025-12-03 23:01:40','2025-12-03 23:01:40',1,132,'7a42f4a1-573f-45a1-95e3-14daf8b5c9ba',30,'26d36ac1678744fabdbe8d702fccfb9d','gigabytes___DEFAULT__',-1,'2025-12-04 23:01:39',NULL),('2025-12-03 23:02:24','2025-12-03 23:02:24','2025-12-03 23:02:24',1,133,'3ac638fa-704c-46a3-a5cd-2925467a4f82',23,'9bf6771e795f41a4b232098116b975b1','volumes',-1,'2025-12-04 23:02:24',NULL),('2025-12-03 23:02:24','2025-12-03 23:02:24','2025-12-03 23:02:24',1,134,'bb299263-dfc9-4ed7-9530-20288de9655c',24,'9bf6771e795f41a4b232098116b975b1','gigabytes',-1,'2025-12-04 23:02:24',NULL),('2025-12-03 23:02:24','2025-12-03 23:02:24','2025-12-03 23:02:24',1,135,'d2da8c53-d1eb-42e8-8f78-08bd70d28da4',35,'9bf6771e795f41a4b232098116b975b1','volumes_tempest-scenario-type-luksv2-1021171620',-1,'2025-12-04 23:02:24',NULL),('2025-12-03 23:02:24','2025-12-03 23:02:24','2025-12-03 23:02:24',1,136,'c9d0303e-18e0-4535-9dae-d69fb9a40241',36,'9bf6771e795f41a4b232098116b975b1','gigabytes_tempest-scenario-type-luksv2-1021171620',-1,'2025-12-04 23:02:24',NULL),('2025-12-03 23:15:50','2025-12-03 23:15:50','2025-12-03 23:15:50',1,137,'8befce4d-5609-4eaa-85eb-b666528943ae',37,'0ebc213514c247388f90f7a4b0b39e1e','volumes',1,'2025-12-04 23:15:50',NULL),('2025-12-03 23:15:50','2025-12-03 23:15:50','2025-12-03 23:15:50',1,138,'c7ef1e17-0ec8-432b-a7f3-752ce0a6662a',38,'0ebc213514c247388f90f7a4b0b39e1e','gigabytes',1,'2025-12-04 23:15:50',NULL),('2025-12-03 23:15:50','2025-12-03 23:15:50','2025-12-03 23:15:50',1,139,'f0153452-885f-49fe-8cb8-4d202c225a0b',39,'0ebc213514c247388f90f7a4b0b39e1e','volumes___DEFAULT__',1,'2025-12-04 23:15:50',NULL),('2025-12-03 23:15:50','2025-12-03 23:15:50','2025-12-03 23:15:50',1,140,'cbb4e051-d72a-44b4-a7bc-2799c629aa9f',40,'0ebc213514c247388f90f7a4b0b39e1e','gigabytes___DEFAULT__',1,'2025-12-04 23:15:50',NULL),('2025-12-03 23:16:34','2025-12-03 23:16:34','2025-12-03 23:16:34',1,141,'2496fdc1-6494-48f4-9a58-e41d01c609fa',41,'0ebc213514c247388f90f7a4b0b39e1e','snapshots',1,'2025-12-04 23:16:34',NULL),('2025-12-03 23:16:34','2025-12-03 23:16:34','2025-12-03 23:16:34',1,142,'be100f1b-f32f-4a4a-bb2e-ccddf9d2c768',38,'0ebc213514c247388f90f7a4b0b39e1e','gigabytes',1,'2025-12-04 23:16:34',NULL),('2025-12-03 23:16:34','2025-12-03 23:16:34','2025-12-03 23:16:34',1,143,'78f3d658-7889-4ecf-a12f-49bb31ae0c1b',40,'0ebc213514c247388f90f7a4b0b39e1e','gigabytes___DEFAULT__',1,'2025-12-04 23:16:34',NULL),('2025-12-03 23:16:34','2025-12-03 23:16:34','2025-12-03 23:16:34',1,144,'0569092f-eeef-49c3-b36e-90ea3aa5e1ad',42,'0ebc213514c247388f90f7a4b0b39e1e','snapshots___DEFAULT__',1,'2025-12-04 23:16:34',NULL),('2025-12-03 23:16:41','2025-12-03 23:16:41','2025-12-03 23:16:41',1,145,'bfae5029-cce1-4835-9041-865b5a14d957',37,'0ebc213514c247388f90f7a4b0b39e1e','volumes',1,'2025-12-04 23:16:41',NULL),('2025-12-03 23:16:41','2025-12-03 23:16:41','2025-12-03 23:16:41',1,146,'36abb0fa-cae6-4adb-bbde-870e19ae3e87',38,'0ebc213514c247388f90f7a4b0b39e1e','gigabytes',1,'2025-12-04 23:16:41',NULL),('2025-12-03 23:16:41','2025-12-03 23:16:41','2025-12-03 23:16:41',1,147,'b85f2470-c693-4545-8b53-cae79577db11',39,'0ebc213514c247388f90f7a4b0b39e1e','volumes___DEFAULT__',1,'2025-12-04 23:16:41',NULL),('2025-12-03 23:16:41','2025-12-03 23:16:41','2025-12-03 23:16:41',1,148,'1432991c-0a39-4846-bece-cab314758234',40,'0ebc213514c247388f90f7a4b0b39e1e','gigabytes___DEFAULT__',1,'2025-12-04 23:16:41',NULL),('2025-12-03 23:17:54','2025-12-03 23:17:54','2025-12-03 23:17:54',1,149,'eb54d768-c569-4f7c-9817-eef0b61d009d',37,'0ebc213514c247388f90f7a4b0b39e1e','volumes',-1,'2025-12-04 23:17:54',NULL),('2025-12-03 23:17:54','2025-12-03 23:17:54','2025-12-03 23:17:54',1,150,'91d71e59-e024-4409-af21-ed9458f5113e',38,'0ebc213514c247388f90f7a4b0b39e1e','gigabytes',-1,'2025-12-04 23:17:54',NULL),('2025-12-03 23:17:54','2025-12-03 23:17:54','2025-12-03 23:17:54',1,151,'d9e0ac51-0f59-4102-81a3-9f1429a567e5',39,'0ebc213514c247388f90f7a4b0b39e1e','volumes___DEFAULT__',-1,'2025-12-04 23:17:54',NULL),('2025-12-03 23:17:54','2025-12-03 23:17:54','2025-12-03 23:17:54',1,152,'c7cb62f5-65c4-42f4-bb09-3ea8da31ec63',40,'0ebc213514c247388f90f7a4b0b39e1e','gigabytes___DEFAULT__',-1,'2025-12-04 23:17:54',NULL),('2025-12-03 23:17:56','2025-12-03 23:17:56','2025-12-03 23:17:56',1,153,'438ef6d9-bcea-4a94-913e-0d5395d9687f',41,'0ebc213514c247388f90f7a4b0b39e1e','snapshots',-1,'2025-12-04 23:17:56',NULL),('2025-12-03 23:17:56','2025-12-03 23:17:56','2025-12-03 23:17:56',1,154,'56522de4-ca62-4786-9d0e-0609e58654b9',38,'0ebc213514c247388f90f7a4b0b39e1e','gigabytes',-1,'2025-12-04 23:17:56',NULL),('2025-12-03 23:17:56','2025-12-03 23:17:56','2025-12-03 23:17:56',1,155,'a8069fae-8ab2-46e6-a50e-9a9dbff7754b',40,'0ebc213514c247388f90f7a4b0b39e1e','gigabytes___DEFAULT__',-1,'2025-12-04 23:17:56',NULL),('2025-12-03 23:17:56','2025-12-03 23:17:56','2025-12-03 23:17:56',1,156,'f44a1c6e-2047-43d8-b917-77b100e681b8',42,'0ebc213514c247388f90f7a4b0b39e1e','snapshots___DEFAULT__',-1,'2025-12-04 23:17:56',NULL),('2025-12-03 23:18:04','2025-12-03 23:18:04','2025-12-03 23:18:04',1,157,'b562b947-4ba0-4f1f-a04d-28313b898539',37,'0ebc213514c247388f90f7a4b0b39e1e','volumes',-1,'2025-12-04 23:18:04',NULL),('2025-12-03 23:18:04','2025-12-03 23:18:04','2025-12-03 23:18:04',1,158,'56655b67-cc7e-4ad4-af33-e5d6a397a072',38,'0ebc213514c247388f90f7a4b0b39e1e','gigabytes',-1,'2025-12-04 23:18:04',NULL),('2025-12-03 23:18:04','2025-12-03 23:18:04','2025-12-03 23:18:04',1,159,'00442f63-c766-4769-a4d6-60af00119a2c',39,'0ebc213514c247388f90f7a4b0b39e1e','volumes___DEFAULT__',-1,'2025-12-04 23:18:04',NULL),('2025-12-03 23:18:04','2025-12-03 23:18:04','2025-12-03 23:18:04',1,160,'24be7c25-6635-415c-bc13-c92ae90e08e3',40,'0ebc213514c247388f90f7a4b0b39e1e','gigabytes___DEFAULT__',-1,'2025-12-04 23:18:04',NULL),('2025-12-03 23:18:47','2025-12-03 23:18:47','2025-12-03 23:18:47',1,161,'c8107311-9de7-4a71-8c09-14259474f724',43,'e014ab433f1c45e4bdfa23184aca2555','volumes',1,'2025-12-04 23:18:47',NULL),('2025-12-03 23:18:47','2025-12-03 23:18:47','2025-12-03 23:18:47',1,162,'29e47184-7daa-45f3-967b-4360d99ac3d8',44,'e014ab433f1c45e4bdfa23184aca2555','gigabytes',1,'2025-12-04 23:18:47',NULL),('2025-12-03 23:18:47','2025-12-03 23:18:47','2025-12-03 23:18:47',1,163,'e0944451-d213-4837-a75c-213b93db9743',45,'e014ab433f1c45e4bdfa23184aca2555','volumes___DEFAULT__',1,'2025-12-04 23:18:47',NULL),('2025-12-03 23:18:47','2025-12-03 23:18:47','2025-12-03 23:18:47',1,164,'c96c2ff2-cb80-4792-8d6f-c6e52168f665',46,'e014ab433f1c45e4bdfa23184aca2555','gigabytes___DEFAULT__',1,'2025-12-04 23:18:47',NULL),('2025-12-03 23:18:55','2025-12-03 23:18:55','2025-12-03 23:18:55',1,165,'da5e82e9-7446-40f3-ac1c-a1073471d42e',47,'e014ab433f1c45e4bdfa23184aca2555','backups',1,'2025-12-04 23:18:55',NULL),('2025-12-03 23:18:55','2025-12-03 23:18:55','2025-12-03 23:18:55',1,166,'32bf0f65-1602-48c4-a3fc-664f927a99f7',48,'e014ab433f1c45e4bdfa23184aca2555','backup_gigabytes',1,'2025-12-04 23:18:55',NULL),('2025-12-03 23:19:07','2025-12-03 23:19:07','2025-12-03 23:19:07',1,167,'f0fe3d59-fe72-43d1-85dc-aae5f697a7df',47,'e014ab433f1c45e4bdfa23184aca2555','backups',-1,'2025-12-04 23:19:07',NULL),('2025-12-03 23:19:07','2025-12-03 23:19:07','2025-12-03 23:19:07',1,168,'25dfbf5e-d104-4868-b6b5-ba0f315a6898',48,'e014ab433f1c45e4bdfa23184aca2555','backup_gigabytes',-1,'2025-12-04 23:19:07',NULL),('2025-12-03 23:19:09','2025-12-03 23:19:09','2025-12-03 23:19:09',1,169,'b971e8af-97b8-4779-b542-184e8702414b',43,'e014ab433f1c45e4bdfa23184aca2555','volumes',-1,'2025-12-04 23:19:09',NULL),('2025-12-03 23:19:09','2025-12-03 23:19:09','2025-12-03 23:19:09',1,170,'a5c8c07a-5b0b-4b1a-a7e5-06ce94b53886',44,'e014ab433f1c45e4bdfa23184aca2555','gigabytes',-1,'2025-12-04 23:19:09',NULL),('2025-12-03 23:19:09','2025-12-03 23:19:09','2025-12-03 23:19:09',1,171,'4999819d-c79a-4bdb-88d6-4dac9608c2a3',45,'e014ab433f1c45e4bdfa23184aca2555','volumes___DEFAULT__',-1,'2025-12-04 23:19:09',NULL),('2025-12-03 23:19:09','2025-12-03 23:19:09','2025-12-03 23:19:09',1,172,'6b18d138-05b0-41e2-89cc-7ecd58294762',46,'e014ab433f1c45e4bdfa23184aca2555','gigabytes___DEFAULT__',-1,'2025-12-04 23:19:09',NULL),('2025-12-03 23:32:42','2025-12-03 23:32:42','2025-12-03 23:32:42',1,173,'07877fd5-3981-42f8-9501-b6933171a8af',49,'17135a905ddc412883361a7397e2e39c','volumes',1,'2025-12-04 23:32:42',NULL),('2025-12-03 23:32:42','2025-12-03 23:32:42','2025-12-03 23:32:42',1,174,'c673f7ee-6560-445b-b7af-5cdabf5b1ac0',50,'17135a905ddc412883361a7397e2e39c','gigabytes',1,'2025-12-04 23:32:42',NULL),('2025-12-03 23:32:42','2025-12-03 23:32:42','2025-12-03 23:32:42',1,175,'a60db320-aee8-4384-834d-5bbbb276d5f7',51,'17135a905ddc412883361a7397e2e39c','volumes_tempest-scenario-type-luks-1072837293',1,'2025-12-04 23:32:42',NULL),('2025-12-03 23:32:42','2025-12-03 23:32:42','2025-12-03 23:32:42',1,176,'a8f7026c-0f6b-422b-910c-ea7d105f34b9',52,'17135a905ddc412883361a7397e2e39c','gigabytes_tempest-scenario-type-luks-1072837293',1,'2025-12-04 23:32:42',NULL),('2025-12-03 23:33:15','2025-12-03 23:33:15','2025-12-03 23:33:15',1,177,'8bf45ae5-0811-4c21-96cf-f7dc1b762f96',49,'17135a905ddc412883361a7397e2e39c','volumes',-1,'2025-12-04 23:33:15',NULL),('2025-12-03 23:33:15','2025-12-03 23:33:15','2025-12-03 23:33:15',1,178,'5c8b48b4-f3fc-43e0-909a-7da36e983c45',50,'17135a905ddc412883361a7397e2e39c','gigabytes',-1,'2025-12-04 23:33:15',NULL),('2025-12-03 23:33:15','2025-12-03 23:33:15','2025-12-03 23:33:15',1,179,'1d0de28a-69b2-4f71-9dcc-231dde1d2a8f',51,'17135a905ddc412883361a7397e2e39c','volumes_tempest-scenario-type-luks-1072837293',-1,'2025-12-04 23:33:15',NULL),('2025-12-03 23:33:15','2025-12-03 23:33:15','2025-12-03 23:33:15',1,180,'5ee142fe-2acc-40d0-bb9e-62ff8b1be29f',52,'17135a905ddc412883361a7397e2e39c','gigabytes_tempest-scenario-type-luks-1072837293',-1,'2025-12-04 23:33:15',NULL),('2025-12-03 23:33:17','2025-12-03 23:33:17','2025-12-03 23:33:17',1,181,'4db8d040-dca7-4414-bab4-b619385a6fde',49,'17135a905ddc412883361a7397e2e39c','volumes',1,'2025-12-04 23:33:17',NULL),('2025-12-03 23:33:17','2025-12-03 23:33:17','2025-12-03 23:33:17',1,182,'13ae327b-0151-4df8-ae5f-e20c2e8b528c',50,'17135a905ddc412883361a7397e2e39c','gigabytes',1,'2025-12-04 23:33:17',NULL),('2025-12-03 23:33:17','2025-12-03 23:33:17','2025-12-03 23:33:17',1,183,'474f858a-22e8-4382-b60e-b7c575f06dcb',53,'17135a905ddc412883361a7397e2e39c','volumes_tempest-scenario-type-luks2-1265354225',1,'2025-12-04 23:33:17',NULL),('2025-12-03 23:33:17','2025-12-03 23:33:17','2025-12-03 23:33:17',1,184,'b743f2de-7fbe-4f1a-a425-db48b8af8d8c',54,'17135a905ddc412883361a7397e2e39c','gigabytes_tempest-scenario-type-luks2-1265354225',1,'2025-12-04 23:33:17',NULL),('2025-12-03 23:34:02','2025-12-03 23:34:02','2025-12-03 23:34:02',1,185,'704dfad7-c1ef-485b-b026-e41ab23f2fe0',49,'17135a905ddc412883361a7397e2e39c','volumes',-1,'2025-12-04 23:34:02',NULL),('2025-12-03 23:34:02','2025-12-03 23:34:02','2025-12-03 23:34:02',1,186,'ae18b0bd-825d-4c1f-91ac-41c744cc1dee',50,'17135a905ddc412883361a7397e2e39c','gigabytes',-1,'2025-12-04 23:34:02',NULL),('2025-12-03 23:34:02','2025-12-03 23:34:02','2025-12-03 23:34:02',1,187,'e7ffa42d-20cb-4c36-b7ce-4af97d893083',53,'17135a905ddc412883361a7397e2e39c','volumes_tempest-scenario-type-luks2-1265354225',-1,'2025-12-04 23:34:02',NULL),('2025-12-03 23:34:02','2025-12-03 23:34:02','2025-12-03 23:34:02',1,188,'55c8eea9-f10f-45c9-88e2-6fa92fefaf76',54,'17135a905ddc412883361a7397e2e39c','gigabytes_tempest-scenario-type-luks2-1265354225',-1,'2025-12-04 23:34:02',NULL),('2025-12-03 23:34:04','2025-12-03 23:34:04','2025-12-03 23:34:04',1,189,'ad33ea68-f68a-4429-9340-fc3898c5ec91',49,'17135a905ddc412883361a7397e2e39c','volumes',1,'2025-12-04 23:34:04',NULL),('2025-12-03 23:34:04','2025-12-03 23:34:04','2025-12-03 23:34:04',1,190,'751151fc-a2ef-442c-97c0-f15d4bfefd0c',50,'17135a905ddc412883361a7397e2e39c','gigabytes',1,'2025-12-04 23:34:04',NULL),('2025-12-03 23:34:04','2025-12-03 23:34:04','2025-12-03 23:34:04',1,191,'ddfd6a82-d2b4-4e81-ab12-12c11ac1b7ad',55,'17135a905ddc412883361a7397e2e39c','volumes___DEFAULT__',1,'2025-12-04 23:34:04',NULL),('2025-12-03 23:34:04','2025-12-03 23:34:04','2025-12-03 23:34:04',1,192,'d871f008-6e2a-48ba-b2e0-9e9529b5ba30',56,'17135a905ddc412883361a7397e2e39c','gigabytes___DEFAULT__',1,'2025-12-04 23:34:04',NULL),('2025-12-03 23:34:14','2025-12-03 23:34:14','2025-12-03 23:34:14',1,193,'e8c4c33b-c82f-479c-8e1e-6cfc78800e4f',57,'17135a905ddc412883361a7397e2e39c','snapshots',1,'2025-12-04 23:34:14',NULL),('2025-12-03 23:34:14','2025-12-03 23:34:14','2025-12-03 23:34:14',1,194,'6de66118-82dc-463b-b739-c01f67d33a0e',50,'17135a905ddc412883361a7397e2e39c','gigabytes',1,'2025-12-04 23:34:14',NULL),('2025-12-03 23:34:14','2025-12-03 23:34:14','2025-12-03 23:34:14',1,195,'37781582-ab65-4671-b0c4-4557e82f6d6e',56,'17135a905ddc412883361a7397e2e39c','gigabytes___DEFAULT__',1,'2025-12-04 23:34:14',NULL),('2025-12-03 23:34:14','2025-12-03 23:34:14','2025-12-03 23:34:14',1,196,'08c11f7a-738f-4530-bed3-df8ccad96eea',58,'17135a905ddc412883361a7397e2e39c','snapshots___DEFAULT__',1,'2025-12-04 23:34:14',NULL),('2025-12-03 23:34:20','2025-12-03 23:34:20','2025-12-03 23:34:20',1,197,'38a5cd7d-ee72-4ee3-ba18-63d1a78a99d0',49,'17135a905ddc412883361a7397e2e39c','volumes',1,'2025-12-04 23:34:20',NULL),('2025-12-03 23:34:20','2025-12-03 23:34:20','2025-12-03 23:34:20',1,198,'8976a9b2-28eb-48bf-b711-05d127ee5b2f',50,'17135a905ddc412883361a7397e2e39c','gigabytes',1,'2025-12-04 23:34:20',NULL),('2025-12-03 23:34:20','2025-12-03 23:34:20','2025-12-03 23:34:20',1,199,'86fb1688-2995-4db9-94ce-5e2efe44b09a',55,'17135a905ddc412883361a7397e2e39c','volumes___DEFAULT__',1,'2025-12-04 23:34:20',NULL),('2025-12-03 23:34:20','2025-12-03 23:34:20','2025-12-03 23:34:20',1,200,'0038c81b-d316-4c2d-ac21-aef2263ce70f',56,'17135a905ddc412883361a7397e2e39c','gigabytes___DEFAULT__',1,'2025-12-04 23:34:20',NULL),('2025-12-03 23:34:48','2025-12-03 23:34:48','2025-12-03 23:34:48',1,201,'8e87ba40-8258-4a0f-8616-ae9e76a17ee0',49,'17135a905ddc412883361a7397e2e39c','volumes',-1,'2025-12-04 23:34:48',NULL),('2025-12-03 23:34:48','2025-12-03 23:34:48','2025-12-03 23:34:48',1,202,'81a624ce-546b-40bd-b261-97e48b4f792d',50,'17135a905ddc412883361a7397e2e39c','gigabytes',-1,'2025-12-04 23:34:48',NULL),('2025-12-03 23:34:48','2025-12-03 23:34:48','2025-12-03 23:34:48',1,203,'3f995f02-d6e2-4b67-8085-778d91f57210',55,'17135a905ddc412883361a7397e2e39c','volumes___DEFAULT__',-1,'2025-12-04 23:34:48',NULL),('2025-12-03 23:34:48','2025-12-03 23:34:48','2025-12-03 23:34:48',1,204,'11e15b13-8f74-451b-a8fd-d3b2147761cc',56,'17135a905ddc412883361a7397e2e39c','gigabytes___DEFAULT__',-1,'2025-12-04 23:34:48',NULL),('2025-12-03 23:34:51','2025-12-03 23:34:51','2025-12-03 23:34:51',1,205,'7e13525b-8a74-44f7-9e9a-f4c6c6ba0d07',57,'17135a905ddc412883361a7397e2e39c','snapshots',-1,'2025-12-04 23:34:51',NULL),('2025-12-03 23:34:51','2025-12-03 23:34:51','2025-12-03 23:34:51',1,206,'5bfe3299-0d77-45f3-84f6-c48312be0ce3',50,'17135a905ddc412883361a7397e2e39c','gigabytes',-1,'2025-12-04 23:34:51',NULL),('2025-12-03 23:34:51','2025-12-03 23:34:51','2025-12-03 23:34:51',1,207,'baf6cb1d-9f3d-40a1-80cb-b72f70a740f2',56,'17135a905ddc412883361a7397e2e39c','gigabytes___DEFAULT__',-1,'2025-12-04 23:34:51',NULL),('2025-12-03 23:34:51','2025-12-03 23:34:51','2025-12-03 23:34:51',1,208,'f24d555c-0dfe-4b6b-9d10-5b1ded683aa0',58,'17135a905ddc412883361a7397e2e39c','snapshots___DEFAULT__',-1,'2025-12-04 23:34:51',NULL),('2025-12-03 23:34:52','2025-12-03 23:34:52','2025-12-03 23:34:52',1,209,'491a27c5-708d-4c0d-bd68-b39db2cf47cf',49,'17135a905ddc412883361a7397e2e39c','volumes',-1,'2025-12-04 23:34:52',NULL),('2025-12-03 23:34:52','2025-12-03 23:34:52','2025-12-03 23:34:52',1,210,'72793e0e-2de9-48d5-a1f5-aaf6a25a80b0',50,'17135a905ddc412883361a7397e2e39c','gigabytes',-1,'2025-12-04 23:34:52',NULL),('2025-12-03 23:34:52','2025-12-03 23:34:52','2025-12-03 23:34:52',1,211,'880c4a0f-d498-4549-9364-a0608e00ec0a',55,'17135a905ddc412883361a7397e2e39c','volumes___DEFAULT__',-1,'2025-12-04 23:34:52',NULL),('2025-12-03 23:34:52','2025-12-03 23:34:52','2025-12-03 23:34:52',1,212,'ab874efc-5bcc-4d9f-9f70-a2c52cfa6d74',56,'17135a905ddc412883361a7397e2e39c','gigabytes___DEFAULT__',-1,'2025-12-04 23:34:52',NULL),('2025-12-03 23:34:54','2025-12-03 23:34:54','2025-12-03 23:34:54',1,213,'572ae4ba-07ae-4697-9cb5-c231796ac086',49,'17135a905ddc412883361a7397e2e39c','volumes',1,'2025-12-04 23:34:54',NULL),('2025-12-03 23:34:54','2025-12-03 23:34:54','2025-12-03 23:34:54',1,214,'d7989631-631a-4254-8495-cd4497737dba',50,'17135a905ddc412883361a7397e2e39c','gigabytes',1,'2025-12-04 23:34:54',NULL),('2025-12-03 23:34:54','2025-12-03 23:34:54','2025-12-03 23:34:54',1,215,'26e2fb89-5a2a-4d31-b6a3-89deffccf8fd',55,'17135a905ddc412883361a7397e2e39c','volumes___DEFAULT__',1,'2025-12-04 23:34:54',NULL),('2025-12-03 23:34:54','2025-12-03 23:34:54','2025-12-03 23:34:54',1,216,'1ffa726d-5475-498b-a445-e63d37fd1c5e',56,'17135a905ddc412883361a7397e2e39c','gigabytes___DEFAULT__',1,'2025-12-04 23:34:54',NULL),('2025-12-03 23:35:40','2025-12-03 23:35:40','2025-12-03 23:35:40',1,217,'4fdbb4fa-9a54-4b45-8786-5607db8b0195',57,'17135a905ddc412883361a7397e2e39c','snapshots',1,'2025-12-04 23:35:40',NULL),('2025-12-03 23:35:40','2025-12-03 23:35:40','2025-12-03 23:35:40',1,218,'f6af2cd8-78ab-4581-b907-5dba381cfeb2',50,'17135a905ddc412883361a7397e2e39c','gigabytes',1,'2025-12-04 23:35:40',NULL),('2025-12-03 23:35:40','2025-12-03 23:35:40','2025-12-03 23:35:40',1,219,'affb79d5-ced3-48dd-b7e7-775d847ca0b1',56,'17135a905ddc412883361a7397e2e39c','gigabytes___DEFAULT__',1,'2025-12-04 23:35:40',NULL),('2025-12-03 23:35:40','2025-12-03 23:35:40','2025-12-03 23:35:40',1,220,'85f56e25-b420-4cf8-bf80-d3e26ac9efb2',58,'17135a905ddc412883361a7397e2e39c','snapshots___DEFAULT__',1,'2025-12-04 23:35:40',NULL),('2025-12-03 23:35:48','2025-12-03 23:35:48','2025-12-03 23:35:48',1,221,'8ec995be-8c84-4944-a7d4-e1c238c78ce1',49,'17135a905ddc412883361a7397e2e39c','volumes',1,'2025-12-04 23:35:48',NULL),('2025-12-03 23:35:48','2025-12-03 23:35:48','2025-12-03 23:35:48',1,222,'72c9be7b-787c-4d61-91ce-e7d8afcd9a7b',50,'17135a905ddc412883361a7397e2e39c','gigabytes',1,'2025-12-04 23:35:48',NULL),('2025-12-03 23:35:48','2025-12-03 23:35:48','2025-12-03 23:35:48',1,223,'37dcbe69-588d-43aa-bc64-dcd9cfc8a62e',55,'17135a905ddc412883361a7397e2e39c','volumes___DEFAULT__',1,'2025-12-04 23:35:48',NULL),('2025-12-03 23:35:48','2025-12-03 23:35:48','2025-12-03 23:35:48',1,224,'c5d38e63-8f5f-4d2f-aea6-5826a8f889a0',56,'17135a905ddc412883361a7397e2e39c','gigabytes___DEFAULT__',1,'2025-12-04 23:35:48',NULL),('2025-12-03 23:36:44','2025-12-03 23:36:44','2025-12-03 23:36:44',1,225,'5ea6bcd4-95cd-4269-823c-9a2ad9b1c210',49,'17135a905ddc412883361a7397e2e39c','volumes',-1,'2025-12-04 23:36:44',NULL),('2025-12-03 23:36:44','2025-12-03 23:36:44','2025-12-03 23:36:44',1,226,'d6ff8215-8954-456f-8dc6-d64dd2773f47',50,'17135a905ddc412883361a7397e2e39c','gigabytes',-1,'2025-12-04 23:36:44',NULL),('2025-12-03 23:36:44','2025-12-03 23:36:44','2025-12-03 23:36:44',1,227,'8ecf923c-5a60-412c-b8aa-fe99b7ce3bf8',55,'17135a905ddc412883361a7397e2e39c','volumes___DEFAULT__',-1,'2025-12-04 23:36:44',NULL),('2025-12-03 23:36:44','2025-12-03 23:36:44','2025-12-03 23:36:44',1,228,'18887ea8-7674-4162-8463-efe855176c72',56,'17135a905ddc412883361a7397e2e39c','gigabytes___DEFAULT__',-1,'2025-12-04 23:36:44',NULL),('2025-12-03 23:36:46','2025-12-03 23:36:46','2025-12-03 23:36:46',1,229,'d9a0dbc0-2bd7-430a-9bda-466a1d72c913',57,'17135a905ddc412883361a7397e2e39c','snapshots',-1,'2025-12-04 23:36:46',NULL),('2025-12-03 23:36:46','2025-12-03 23:36:46','2025-12-03 23:36:46',1,230,'447c890c-dd85-4f0d-bee5-cf750aad24c3',50,'17135a905ddc412883361a7397e2e39c','gigabytes',-1,'2025-12-04 23:36:46',NULL),('2025-12-03 23:36:46','2025-12-03 23:36:46','2025-12-03 23:36:46',1,231,'62384885-79e2-4ff0-9260-ce5328384e97',56,'17135a905ddc412883361a7397e2e39c','gigabytes___DEFAULT__',-1,'2025-12-04 23:36:46',NULL),('2025-12-03 23:36:46','2025-12-03 23:36:46','2025-12-03 23:36:46',1,232,'bf859303-cd07-4d4c-91fd-7ea0f816c42f',58,'17135a905ddc412883361a7397e2e39c','snapshots___DEFAULT__',-1,'2025-12-04 23:36:46',NULL),('2025-12-03 23:36:55','2025-12-03 23:36:55','2025-12-03 23:36:55',1,233,'db3b1954-da4a-4992-bc8a-ac1334b8694c',49,'17135a905ddc412883361a7397e2e39c','volumes',-1,'2025-12-04 23:36:55',NULL),('2025-12-03 23:36:55','2025-12-03 23:36:55','2025-12-03 23:36:55',1,234,'65ecab63-0d0f-48ff-bbb8-88a693093761',50,'17135a905ddc412883361a7397e2e39c','gigabytes',-1,'2025-12-04 23:36:55',NULL),('2025-12-03 23:36:55','2025-12-03 23:36:55','2025-12-03 23:36:55',1,235,'715ddfc9-1ca1-418a-9369-608baac5df74',55,'17135a905ddc412883361a7397e2e39c','volumes___DEFAULT__',-1,'2025-12-04 23:36:55',NULL),('2025-12-03 23:36:55','2025-12-03 23:36:55','2025-12-03 23:36:55',1,236,'b8fb4550-98b1-404a-ab7b-235cc7bfafa3',56,'17135a905ddc412883361a7397e2e39c','gigabytes___DEFAULT__',-1,'2025-12-04 23:36:55',NULL),('2025-12-03 23:37:07','2025-12-03 23:37:07','2025-12-03 23:37:07',1,237,'bce89c5d-6c96-4876-8626-4d62c29fddf1',49,'17135a905ddc412883361a7397e2e39c','volumes',1,'2025-12-04 23:37:07',NULL),('2025-12-03 23:37:07','2025-12-03 23:37:07','2025-12-03 23:37:07',1,238,'4f7e3aa3-8106-4e5f-939d-6020dbea2bb6',50,'17135a905ddc412883361a7397e2e39c','gigabytes',1,'2025-12-04 23:37:07',NULL),('2025-12-03 23:37:07','2025-12-03 23:37:07','2025-12-03 23:37:07',1,239,'3679a6aa-6b4f-4010-a26c-9c66daf24dab',55,'17135a905ddc412883361a7397e2e39c','volumes___DEFAULT__',1,'2025-12-04 23:37:07',NULL),('2025-12-03 23:37:07','2025-12-03 23:37:07','2025-12-03 23:37:07',1,240,'4ca4ce35-2260-4a74-aafd-2c92e1eec246',56,'17135a905ddc412883361a7397e2e39c','gigabytes___DEFAULT__',1,'2025-12-04 23:37:07',NULL),('2025-12-03 23:38:46','2025-12-03 23:38:46','2025-12-03 23:38:46',1,241,'c5b8679a-3ad3-4ede-b266-189d888202c1',57,'17135a905ddc412883361a7397e2e39c','snapshots',1,'2025-12-04 23:38:46',NULL),('2025-12-03 23:38:46','2025-12-03 23:38:46','2025-12-03 23:38:46',1,242,'7c232138-5ffe-4a6e-941e-b78124fdff18',50,'17135a905ddc412883361a7397e2e39c','gigabytes',1,'2025-12-04 23:38:46',NULL),('2025-12-03 23:38:46','2025-12-03 23:38:46','2025-12-03 23:38:46',1,243,'4f1dfb35-f742-4de5-91e6-4fa4961a3b97',56,'17135a905ddc412883361a7397e2e39c','gigabytes___DEFAULT__',1,'2025-12-04 23:38:46',NULL),('2025-12-03 23:38:46','2025-12-03 23:38:46','2025-12-03 23:38:46',1,244,'588c540c-317e-42e1-8788-ec6d3207e033',58,'17135a905ddc412883361a7397e2e39c','snapshots___DEFAULT__',1,'2025-12-04 23:38:46',NULL),('2025-12-03 23:38:48','2025-12-03 23:38:48','2025-12-03 23:38:48',1,245,'507777c1-4d82-487a-b5a5-493c85de14dc',49,'17135a905ddc412883361a7397e2e39c','volumes',1,'2025-12-04 23:38:48',NULL),('2025-12-03 23:38:48','2025-12-03 23:38:48','2025-12-03 23:38:48',1,246,'16839e19-57ae-4160-8712-a02eabd6fa8d',50,'17135a905ddc412883361a7397e2e39c','gigabytes',1,'2025-12-04 23:38:48',NULL),('2025-12-03 23:38:48','2025-12-03 23:38:48','2025-12-03 23:38:48',1,247,'c51469a8-b28c-42f0-9246-6e44fd9b3740',55,'17135a905ddc412883361a7397e2e39c','volumes___DEFAULT__',1,'2025-12-04 23:38:48',NULL),('2025-12-03 23:38:48','2025-12-03 23:38:48','2025-12-03 23:38:48',1,248,'7e200e5c-a10a-43f9-b9e1-353a0978368e',56,'17135a905ddc412883361a7397e2e39c','gigabytes___DEFAULT__',1,'2025-12-04 23:38:48',NULL),('2025-12-03 23:39:46','2025-12-03 23:39:46','2025-12-03 23:39:46',1,249,'2a99ea0a-0d5e-457a-aa91-65c215ff091e',49,'17135a905ddc412883361a7397e2e39c','volumes',-1,'2025-12-04 23:39:46',NULL),('2025-12-03 23:39:46','2025-12-03 23:39:46','2025-12-03 23:39:46',1,250,'756df4f7-052c-4890-ad9d-7461b9069a17',50,'17135a905ddc412883361a7397e2e39c','gigabytes',-1,'2025-12-04 23:39:46',NULL),('2025-12-03 23:39:46','2025-12-03 23:39:46','2025-12-03 23:39:46',1,251,'2735ce1f-6149-4b0e-a04c-c76edb7bf9be',55,'17135a905ddc412883361a7397e2e39c','volumes___DEFAULT__',-1,'2025-12-04 23:39:46',NULL),('2025-12-03 23:39:46','2025-12-03 23:39:46','2025-12-03 23:39:46',1,252,'6a0c163a-ba9d-487f-9a99-44c5b8e8242f',56,'17135a905ddc412883361a7397e2e39c','gigabytes___DEFAULT__',-1,'2025-12-04 23:39:46',NULL),('2025-12-03 23:39:47','2025-12-03 23:39:48','2025-12-03 23:39:48',1,253,'ea10e560-8189-4b77-9602-84f7d75edfab',57,'17135a905ddc412883361a7397e2e39c','snapshots',-1,'2025-12-04 23:39:47',NULL),('2025-12-03 23:39:47','2025-12-03 23:39:48','2025-12-03 23:39:48',1,254,'f7bfb793-f618-4c23-a57b-da8625e72c36',50,'17135a905ddc412883361a7397e2e39c','gigabytes',-1,'2025-12-04 23:39:47',NULL),('2025-12-03 23:39:47','2025-12-03 23:39:48','2025-12-03 23:39:48',1,255,'5d8532be-57f5-4844-a411-3963699105bb',56,'17135a905ddc412883361a7397e2e39c','gigabytes___DEFAULT__',-1,'2025-12-04 23:39:47',NULL),('2025-12-03 23:39:47','2025-12-03 23:39:48','2025-12-03 23:39:48',1,256,'231a689b-66c2-40d2-9791-5a5b98255520',58,'17135a905ddc412883361a7397e2e39c','snapshots___DEFAULT__',-1,'2025-12-04 23:39:47',NULL),('2025-12-03 23:39:58','2025-12-03 23:39:58','2025-12-03 23:39:58',1,257,'7da91936-3b0e-43df-8855-c2806082a25f',49,'17135a905ddc412883361a7397e2e39c','volumes',-1,'2025-12-04 23:39:58',NULL),('2025-12-03 23:39:58','2025-12-03 23:39:58','2025-12-03 23:39:58',1,258,'cf02073d-56f7-47cb-94f5-f74663a4e3b0',50,'17135a905ddc412883361a7397e2e39c','gigabytes',-1,'2025-12-04 23:39:58',NULL),('2025-12-03 23:39:58','2025-12-03 23:39:58','2025-12-03 23:39:58',1,259,'d5557938-7fe2-43c6-8215-366cc2ab7e0c',55,'17135a905ddc412883361a7397e2e39c','volumes___DEFAULT__',-1,'2025-12-04 23:39:58',NULL),('2025-12-03 23:39:58','2025-12-03 23:39:58','2025-12-03 23:39:58',1,260,'8743cf74-f3a2-412e-9247-fac337beb731',56,'17135a905ddc412883361a7397e2e39c','gigabytes___DEFAULT__',-1,'2025-12-04 23:39:58',NULL),('2025-12-03 23:40:59','2025-12-03 23:40:59','2025-12-03 23:40:59',1,261,'6df5220a-1e0b-41da-a5fd-33d260f13633',59,'736cfa939ed54e37b1dae7d67c7093e6','volumes',1,'2025-12-04 23:40:59',NULL),('2025-12-03 23:40:59','2025-12-03 23:40:59','2025-12-03 23:40:59',1,262,'e4e17340-180c-4c27-8b0e-a5bb7fc75e1e',60,'736cfa939ed54e37b1dae7d67c7093e6','gigabytes',1,'2025-12-04 23:40:59',NULL),('2025-12-03 23:40:59','2025-12-03 23:40:59','2025-12-03 23:40:59',1,263,'46f65ecc-d87b-451b-be52-690b39891f0a',61,'736cfa939ed54e37b1dae7d67c7093e6','volumes___DEFAULT__',1,'2025-12-04 23:40:59',NULL),('2025-12-03 23:40:59','2025-12-03 23:40:59','2025-12-03 23:40:59',1,264,'56d10fd6-1702-49f0-838a-2ea8bfd257cf',62,'736cfa939ed54e37b1dae7d67c7093e6','gigabytes___DEFAULT__',1,'2025-12-04 23:40:59',NULL),('2025-12-03 23:41:08','2025-12-03 23:41:08','2025-12-03 23:41:08',1,265,'0c8889f6-6ae9-4d3a-8066-4717ff0f2652',63,'736cfa939ed54e37b1dae7d67c7093e6','backups',1,'2025-12-04 23:41:08',NULL),('2025-12-03 23:41:08','2025-12-03 23:41:08','2025-12-03 23:41:08',1,266,'bdbc1642-0980-4800-9e6a-de1606d9accd',64,'736cfa939ed54e37b1dae7d67c7093e6','backup_gigabytes',1,'2025-12-04 23:41:08',NULL),('2025-12-03 23:41:18','2025-12-03 23:41:18','2025-12-03 23:41:18',1,267,'3d7fd281-fb6c-49d4-972b-671bc581706a',63,'736cfa939ed54e37b1dae7d67c7093e6','backups',-1,'2025-12-04 23:41:18',NULL),('2025-12-03 23:41:18','2025-12-03 23:41:18','2025-12-03 23:41:18',1,268,'39d96a34-ef99-4934-8371-fa74626bf1f7',64,'736cfa939ed54e37b1dae7d67c7093e6','backup_gigabytes',-1,'2025-12-04 23:41:18',NULL),('2025-12-03 23:41:20','2025-12-03 23:41:20','2025-12-03 23:41:20',1,269,'68055e38-997f-4db6-a018-954d75219078',59,'736cfa939ed54e37b1dae7d67c7093e6','volumes',-1,'2025-12-04 23:41:20',NULL),('2025-12-03 23:41:20','2025-12-03 23:41:20','2025-12-03 23:41:20',1,270,'f32b878e-8653-4279-83ac-23bac39e497e',60,'736cfa939ed54e37b1dae7d67c7093e6','gigabytes',-1,'2025-12-04 23:41:20',NULL),('2025-12-03 23:41:20','2025-12-03 23:41:20','2025-12-03 23:41:20',1,271,'9b66b6c3-b308-46a2-a27e-afafcb3586ea',61,'736cfa939ed54e37b1dae7d67c7093e6','volumes___DEFAULT__',-1,'2025-12-04 23:41:20',NULL),('2025-12-03 23:41:20','2025-12-03 23:41:20','2025-12-03 23:41:20',1,272,'afe31aa4-9647-4f38-a5f9-fd88fa72b664',62,'736cfa939ed54e37b1dae7d67c7093e6','gigabytes___DEFAULT__',-1,'2025-12-04 23:41:20',NULL);
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2025-12-03 22:25:47','2025-12-03 23:46:21',NULL,0,1,'cinder-baebb-scheduler-0','cinder-scheduler','cinder-scheduler',480,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'749f76a7-0554-4c04-bf77-1a44ceac3a5a'),('2025-12-03 22:25:49','2025-12-03 23:46:24',NULL,0,2,'cinder-baebb-backup-0','cinder-backup','cinder-backup',482,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'098b09b1-0184-4708-80c0-e2536b656a28'),('2025-12-03 22:25:49','2025-12-03 23:46:23',NULL,0,3,'cinder-baebb-volume-lvm-iscsi-0@lvm','cinder-volume','cinder-volume',480,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
INSERT INTO `snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `status`, `progress`, `volume_size`, `scheduled_at`, `display_name`, `display_description`, `provider_location`, `encryption_key_id`, `volume_type_id`, `cgsnapshot_id`, `provider_id`, `provider_auth`, `group_snapshot_id`, `use_quota`) VALUES ('2025-12-03 23:35:40','2025-12-03 23:36:45','2025-12-03 23:36:46',1,'75c870e7-5a8e-4c57-b179-6b92a01989dd','f9e6f6da-570c-4f5d-835b-99c75d783f8e','562adaac81824180a41f0757e2b448ee','17135a905ddc412883361a7397e2e39c','deleted','100%',1,NULL,'snapshot for tempest-TestVolumeBootPatternsnapshot-237575455',NULL,NULL,NULL,'70f41377-9e53-4b51-abc0-604ca3412d34',NULL,NULL,NULL,NULL,1),('2025-12-03 23:38:46','2025-12-03 23:39:47','2025-12-03 23:39:48',1,'8b27417e-562c-47b0-9563-0e851756df0c','181167a7-932d-42a2-b911-9fccfb3b4252','562adaac81824180a41f0757e2b448ee','17135a905ddc412883361a7397e2e39c','deleted','100%',1,NULL,'tempest-TestVolumeBootPattern-snapshot-1214142680',NULL,NULL,NULL,'70f41377-9e53-4b51-abc0-604ca3412d34',NULL,NULL,NULL,NULL,1),('2025-12-03 23:16:34','2025-12-03 23:17:55','2025-12-03 23:17:56',1,'a2075fea-97ef-44b8-8ddb-1b407b0be0d8','494b04c2-9472-4355-afc1-7c637d69239b','6c4a705892cc42cfbedfe3de1504c143','0ebc213514c247388f90f7a4b0b39e1e','deleted','100%',1,NULL,'tempest-TestStampPattern-snapshot-1720886204',NULL,NULL,NULL,'70f41377-9e53-4b51-abc0-604ca3412d34',NULL,NULL,NULL,NULL,1),('2025-12-03 23:34:14','2025-12-03 23:34:50','2025-12-03 23:34:51',1,'d5af72e9-2c72-45cf-a37f-6e7838f62053','8149c040-0a26-43d7-8896-b0c1d2feb021','562adaac81824180a41f0757e2b448ee','17135a905ddc412883361a7397e2e39c','deleted','100%',1,NULL,'tempest-TestVolumeBootPattern-snapshot-1318591324',NULL,NULL,NULL,'70f41377-9e53-4b51-abc0-604ca3412d34',NULL,NULL,NULL,NULL,1),('2025-12-03 22:59:01','2025-12-03 22:59:16','2025-12-03 22:59:17',1,'fb8d8ab5-9029-4b0f-aff5-7dfc4badc704','32e7a0bf-24be-4840-bad8-fac67f6a76fb','c210c585120043549f62ccb01cec9817','26d36ac1678744fabdbe8d702fccfb9d','deleted','100%',1,NULL,'tempest-TestMinimumBasicScenario-snapshot-1182209292',NULL,NULL,NULL,'70f41377-9e53-4b51-abc0-604ca3412d34',NULL,NULL,NULL,NULL,1);
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
INSERT INTO `volume_admin_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `key`, `value`) VALUES ('2025-12-03 22:53:49',NULL,'2025-12-03 22:53:58',1,1,'72bac73e-6a1c-427b-8881-4aa1fd2d20cc','readonly','False'),('2025-12-03 22:53:49',NULL,'2025-12-03 22:53:50',1,2,'72bac73e-6a1c-427b-8881-4aa1fd2d20cc','attached_mode','rw');
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
INSERT INTO `volume_attachment` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `attached_host`, `instance_uuid`, `mountpoint`, `attach_time`, `detach_time`, `attach_mode`, `attach_status`, `connection_info`, `connector`) VALUES ('2025-12-03 22:59:29','2025-12-03 22:59:41','2025-12-03 22:59:41',1,'17152ed8-d1e7-4f96-9728-eaf910fad8e4','355e6a34-12ac-44c5-a011-f347504ff5c6','edpm-compute-0.ctlplane.openstack.lab','4e42e763-4f36-4179-9318-0f113223058a','/dev/vdb','2025-12-03 22:59:33','2025-12-03 22:59:41','rw','detached','{\"target_discovered\": false, \"target_portals\": [\"172.18.0.10:3260\", \"172.19.0.10:3260\"], \"target_iqns\": [\"iqn.2010-10.org.openstack:volume-355e6a34-12ac-44c5-a011-f347504ff5c6\", \"iqn.2010-10.org.openstack:volume-355e6a34-12ac-44c5-a011-f347504ff5c6\"], \"target_luns\": [0, 0], \"target_portal\": \"172.18.0.10:3260\", \"target_iqn\": \"iqn.2010-10.org.openstack:volume-355e6a34-12ac-44c5-a011-f347504ff5c6\", \"target_lun\": 0, \"volume_id\": \"355e6a34-12ac-44c5-a011-f347504ff5c6\", \"auth_method\": \"CHAP\", \"auth_username\": \"CrhXFHqmXCw7LBEm6Xrm\", \"auth_password\": \"RWYiXW9uyMuPsCK4\", \"encrypted\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"cacheable\": false, \"driver_volume_type\": \"iscsi\", \"attachment_id\": \"17152ed8-d1e7-4f96-9728-eaf910fad8e4\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"edpm-compute-0.ctlplane.openstack.lab\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:de67f5764d74\", \"do_local_attach\": false, \"nvme_hostid\": \"9d2caaef-1159-4058-9696-bd58427d6710\", \"system uuid\": \"fe021eff-a897-4e2f-a7f4-732ef2ad3e31\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:9d2caaef-1159-4058-9696-bd58427d6710\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-03 22:52:46','2025-12-03 22:53:23','2025-12-03 22:53:23',1,'3435c088-90de-4864-86aa-a547a94a97ce','b9801a13-7e42-4c4c-a64d-8071d16018e1','edpm-compute-0.ctlplane.openstack.lab','d8ea9f23-e691-45c6-bb48-6ae2a5586109','/dev/vda','2025-12-03 22:52:55','2025-12-03 22:53:23','rw','detached','{\"target_discovered\": false, \"target_portals\": [\"172.18.0.10:3260\", \"172.19.0.10:3260\"], \"target_iqns\": [\"iqn.2010-10.org.openstack:volume-b9801a13-7e42-4c4c-a64d-8071d16018e1\", \"iqn.2010-10.org.openstack:volume-b9801a13-7e42-4c4c-a64d-8071d16018e1\"], \"target_luns\": [0, 0], \"target_portal\": \"172.18.0.10:3260\", \"target_iqn\": \"iqn.2010-10.org.openstack:volume-b9801a13-7e42-4c4c-a64d-8071d16018e1\", \"target_lun\": 0, \"volume_id\": \"b9801a13-7e42-4c4c-a64d-8071d16018e1\", \"auth_method\": \"CHAP\", \"auth_username\": \"Eeek47DYvp5n5qg5niCJ\", \"auth_password\": \"oThjUTJ6FuQhNzhJ\", \"encrypted\": false, \"qos_specs\": null, \"access_mode\": \"rw\", \"cacheable\": false, \"driver_volume_type\": \"iscsi\", \"attachment_id\": \"3435c088-90de-4864-86aa-a547a94a97ce\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"edpm-compute-0.ctlplane.openstack.lab\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:de67f5764d74\", \"do_local_attach\": false, \"nvme_hostid\": \"9d2caaef-1159-4058-9696-bd58427d6710\", \"system uuid\": \"fe021eff-a897-4e2f-a7f4-732ef2ad3e31\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:9d2caaef-1159-4058-9696-bd58427d6710\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-03 22:55:26','2025-12-03 22:55:48','2025-12-03 22:55:48',1,'3ac8a20f-0bbb-43dd-bbf5-244d9425ca11','b26e0ea4-fdd8-4c5b-996a-825accd9ccb3','edpm-compute-0.ctlplane.openstack.lab','9d461f5b-b98c-4720-a727-796854f9ef01','/dev/vdb','2025-12-03 22:55:30','2025-12-03 22:55:48','rw','detached','{\"target_discovered\": false, \"target_portals\": [\"172.18.0.10:3260\", \"172.19.0.10:3260\"], \"target_iqns\": [\"iqn.2010-10.org.openstack:volume-b26e0ea4-fdd8-4c5b-996a-825accd9ccb3\", \"iqn.2010-10.org.openstack:volume-b26e0ea4-fdd8-4c5b-996a-825accd9ccb3\"], \"target_luns\": [0, 0], \"target_portal\": \"172.18.0.10:3260\", \"target_iqn\": \"iqn.2010-10.org.openstack:volume-b26e0ea4-fdd8-4c5b-996a-825accd9ccb3\", \"target_lun\": 0, \"volume_id\": \"b26e0ea4-fdd8-4c5b-996a-825accd9ccb3\", \"auth_method\": \"CHAP\", \"auth_username\": \"DBFqV9S3hiUo4LcYHTuy\", \"auth_password\": \"JMT6xNecB7ApXNc2\", \"encrypted\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"cacheable\": false, \"driver_volume_type\": \"iscsi\", \"attachment_id\": \"3ac8a20f-0bbb-43dd-bbf5-244d9425ca11\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"edpm-compute-0.ctlplane.openstack.lab\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:de67f5764d74\", \"do_local_attach\": false, \"nvme_hostid\": \"9d2caaef-1159-4058-9696-bd58427d6710\", \"system uuid\": \"fe021eff-a897-4e2f-a7f4-732ef2ad3e31\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:9d2caaef-1159-4058-9696-bd58427d6710\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-03 23:33:22','2025-12-03 23:33:59','2025-12-03 23:33:59',1,'40347357-54e3-4046-a46c-154c4278d2cb','54e1e900-b77c-4281-921b-006456c26276','edpm-compute-0.ctlplane.openstack.lab','3bcf5e32-652d-4a21-865f-e087a5a445b8','/dev/vda','2025-12-03 23:33:27','2025-12-03 23:33:59','rw','detached','{\"target_discovered\": false, \"target_portals\": [\"172.18.0.10:3260\", \"172.19.0.10:3260\"], \"target_iqns\": [\"iqn.2010-10.org.openstack:volume-54e1e900-b77c-4281-921b-006456c26276\", \"iqn.2010-10.org.openstack:volume-54e1e900-b77c-4281-921b-006456c26276\"], \"target_luns\": [0, 0], \"target_portal\": \"172.18.0.10:3260\", \"target_iqn\": \"iqn.2010-10.org.openstack:volume-54e1e900-b77c-4281-921b-006456c26276\", \"target_lun\": 0, \"volume_id\": \"54e1e900-b77c-4281-921b-006456c26276\", \"auth_method\": \"CHAP\", \"auth_username\": \"RaSZLELXWP3U4m2JgQFQ\", \"auth_password\": \"9k8kEgeBv7h9dQBs\", \"encrypted\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"cacheable\": false, \"driver_volume_type\": \"iscsi\", \"attachment_id\": \"40347357-54e3-4046-a46c-154c4278d2cb\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"edpm-compute-0.ctlplane.openstack.lab\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:de67f5764d74\", \"do_local_attach\": false, \"nvme_hostid\": \"9d2caaef-1159-4058-9696-bd58427d6710\", \"system uuid\": \"fe021eff-a897-4e2f-a7f4-732ef2ad3e31\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:9d2caaef-1159-4058-9696-bd58427d6710\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-03 23:32:46','2025-12-03 23:33:12','2025-12-03 23:33:12',1,'4b2bece2-c175-49ff-a86f-5427869be556','e68af44c-47d0-4477-b6ba-f67055ae2fa3','edpm-compute-0.ctlplane.openstack.lab','829d6680-52c3-4da8-81d1-de84474e0c2c','/dev/vda','2025-12-03 23:32:51','2025-12-03 23:33:12','rw','detached','{\"target_discovered\": false, \"target_portals\": [\"172.18.0.10:3260\", \"172.19.0.10:3260\"], \"target_iqns\": [\"iqn.2010-10.org.openstack:volume-e68af44c-47d0-4477-b6ba-f67055ae2fa3\", \"iqn.2010-10.org.openstack:volume-e68af44c-47d0-4477-b6ba-f67055ae2fa3\"], \"target_luns\": [0, 0], \"target_portal\": \"172.18.0.10:3260\", \"target_iqn\": \"iqn.2010-10.org.openstack:volume-e68af44c-47d0-4477-b6ba-f67055ae2fa3\", \"target_lun\": 0, \"volume_id\": \"e68af44c-47d0-4477-b6ba-f67055ae2fa3\", \"auth_method\": \"CHAP\", \"auth_username\": \"fSk44pSVE899uHxH5aCF\", \"auth_password\": \"j8zgFjMqDcUkUU5g\", \"encrypted\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"cacheable\": false, \"driver_volume_type\": \"iscsi\", \"attachment_id\": \"4b2bece2-c175-49ff-a86f-5427869be556\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"edpm-compute-0.ctlplane.openstack.lab\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:de67f5764d74\", \"do_local_attach\": false, \"nvme_hostid\": \"9d2caaef-1159-4058-9696-bd58427d6710\", \"system uuid\": \"fe021eff-a897-4e2f-a7f4-732ef2ad3e31\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:9d2caaef-1159-4058-9696-bd58427d6710\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-03 23:35:52','2025-12-03 23:36:42','2025-12-03 23:36:42',1,'4e0610be-a752-4ec9-9a2c-2a2bcc4d67eb','3679a497-5948-44f7-81ad-65eefe1bb9ba','edpm-compute-0.ctlplane.openstack.lab','afd97eb0-5ff9-49df-a642-e78a8058b0ce','/dev/vda','2025-12-03 23:35:56','2025-12-03 23:36:42','rw','detached','{\"target_discovered\": false, \"target_portals\": [\"172.18.0.10:3260\", \"172.19.0.10:3260\"], \"target_iqns\": [\"iqn.2010-10.org.openstack:volume-3679a497-5948-44f7-81ad-65eefe1bb9ba\", \"iqn.2010-10.org.openstack:volume-3679a497-5948-44f7-81ad-65eefe1bb9ba\"], \"target_luns\": [0, 0], \"target_portal\": \"172.18.0.10:3260\", \"target_iqn\": \"iqn.2010-10.org.openstack:volume-3679a497-5948-44f7-81ad-65eefe1bb9ba\", \"target_lun\": 0, \"volume_id\": \"3679a497-5948-44f7-81ad-65eefe1bb9ba\", \"auth_method\": \"CHAP\", \"auth_username\": \"G7bFPqUr4RwXwgBoDv6p\", \"auth_password\": \"J6btYfsn7XJ35fd4\", \"encrypted\": false, \"qos_specs\": null, \"access_mode\": \"rw\", \"cacheable\": false, \"driver_volume_type\": \"iscsi\", \"attachment_id\": \"4e0610be-a752-4ec9-9a2c-2a2bcc4d67eb\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"edpm-compute-0.ctlplane.openstack.lab\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:de67f5764d74\", \"do_local_attach\": false, \"nvme_hostid\": \"9d2caaef-1159-4058-9696-bd58427d6710\", \"system uuid\": \"fe021eff-a897-4e2f-a7f4-732ef2ad3e31\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:9d2caaef-1159-4058-9696-bd58427d6710\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-03 22:56:23','2025-12-03 22:56:48','2025-12-03 22:56:48',1,'6f51a9f5-940c-440e-9a3a-1a4990d3dafd','c033528c-b279-451f-af1d-c06f7d011053','edpm-compute-0.ctlplane.openstack.lab','ea00fb1f-7adf-40f1-a9ef-0e19c66615d6','/dev/vdb','2025-12-03 22:56:27','2025-12-03 22:56:48','rw','detached','{\"target_discovered\": false, \"target_portals\": [\"172.18.0.10:3260\", \"172.19.0.10:3260\"], \"target_iqns\": [\"iqn.2010-10.org.openstack:volume-c033528c-b279-451f-af1d-c06f7d011053\", \"iqn.2010-10.org.openstack:volume-c033528c-b279-451f-af1d-c06f7d011053\"], \"target_luns\": [0, 0], \"target_portal\": \"172.18.0.10:3260\", \"target_iqn\": \"iqn.2010-10.org.openstack:volume-c033528c-b279-451f-af1d-c06f7d011053\", \"target_lun\": 0, \"volume_id\": \"c033528c-b279-451f-af1d-c06f7d011053\", \"auth_method\": \"CHAP\", \"auth_username\": \"Eeyo99o6KwMJLK6y9CaL\", \"auth_password\": \"eNBFPQvdJGZY7dHF\", \"encrypted\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"cacheable\": false, \"driver_volume_type\": \"iscsi\", \"attachment_id\": \"6f51a9f5-940c-440e-9a3a-1a4990d3dafd\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"edpm-compute-0.ctlplane.openstack.lab\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:de67f5764d74\", \"do_local_attach\": false, \"nvme_hostid\": \"9d2caaef-1159-4058-9696-bd58427d6710\", \"system uuid\": \"fe021eff-a897-4e2f-a7f4-732ef2ad3e31\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:9d2caaef-1159-4058-9696-bd58427d6710\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-03 23:01:47','2025-12-03 23:02:15','2025-12-03 23:02:15',1,'710d1d1f-7fba-47b3-8c74-28b638ae7f00','1a8b2d07-722e-4c97-8dfd-18fbd4093a0d','edpm-compute-0.ctlplane.openstack.lab','869e6614-1bf3-4a4e-920a-59cd0c6891ba','/dev/vdb','2025-12-03 23:01:50','2025-12-03 23:02:15','rw','detached','{\"target_discovered\": false, \"target_portals\": [\"172.18.0.10:3260\", \"172.19.0.10:3260\"], \"target_iqns\": [\"iqn.2010-10.org.openstack:volume-1a8b2d07-722e-4c97-8dfd-18fbd4093a0d\", \"iqn.2010-10.org.openstack:volume-1a8b2d07-722e-4c97-8dfd-18fbd4093a0d\"], \"target_luns\": [0, 0], \"target_portal\": \"172.18.0.10:3260\", \"target_iqn\": \"iqn.2010-10.org.openstack:volume-1a8b2d07-722e-4c97-8dfd-18fbd4093a0d\", \"target_lun\": 0, \"volume_id\": \"1a8b2d07-722e-4c97-8dfd-18fbd4093a0d\", \"auth_method\": \"CHAP\", \"auth_username\": \"CyBgSgqHKC24K9WqMCeZ\", \"auth_password\": \"BDH74HJNjH9qsuAM\", \"encrypted\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"cacheable\": false, \"driver_volume_type\": \"iscsi\", \"attachment_id\": \"710d1d1f-7fba-47b3-8c74-28b638ae7f00\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"edpm-compute-0.ctlplane.openstack.lab\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:de67f5764d74\", \"do_local_attach\": false, \"nvme_hostid\": \"9d2caaef-1159-4058-9696-bd58427d6710\", \"system uuid\": \"fe021eff-a897-4e2f-a7f4-732ef2ad3e31\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:9d2caaef-1159-4058-9696-bd58427d6710\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-03 23:35:08','2025-12-03 23:36:52','2025-12-03 23:36:52',1,'890260e5-5c3b-46f1-b110-0b173839c340','f9e6f6da-570c-4f5d-835b-99c75d783f8e','edpm-compute-0.ctlplane.openstack.lab','2372f8df-05c3-4022-b0ee-3307ced34161','/dev/vda','2025-12-03 23:35:13','2025-12-03 23:36:52','rw','detached','{\"target_discovered\": false, \"target_portals\": [\"172.18.0.10:3260\", \"172.19.0.10:3260\"], \"target_iqns\": [\"iqn.2010-10.org.openstack:volume-f9e6f6da-570c-4f5d-835b-99c75d783f8e\", \"iqn.2010-10.org.openstack:volume-f9e6f6da-570c-4f5d-835b-99c75d783f8e\"], \"target_luns\": [0, 0], \"target_portal\": \"172.18.0.10:3260\", \"target_iqn\": \"iqn.2010-10.org.openstack:volume-f9e6f6da-570c-4f5d-835b-99c75d783f8e\", \"target_lun\": 0, \"volume_id\": \"f9e6f6da-570c-4f5d-835b-99c75d783f8e\", \"auth_method\": \"CHAP\", \"auth_username\": \"z2E2VX9VfG2zmgJLMWia\", \"auth_password\": \"6KBpEKxgKu5YQiSS\", \"encrypted\": false, \"qos_specs\": null, \"access_mode\": \"rw\", \"cacheable\": false, \"driver_volume_type\": \"iscsi\", \"attachment_id\": \"890260e5-5c3b-46f1-b110-0b173839c340\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"edpm-compute-0.ctlplane.openstack.lab\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:de67f5764d74\", \"do_local_attach\": false, \"nvme_hostid\": \"9d2caaef-1159-4058-9696-bd58427d6710\", \"system uuid\": \"fe021eff-a897-4e2f-a7f4-732ef2ad3e31\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:9d2caaef-1159-4058-9696-bd58427d6710\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-03 22:58:53','2025-12-03 23:00:09','2025-12-03 23:00:09',1,'95c0572f-2767-4e99-87a5-7cf25b73a9ed','32e7a0bf-24be-4840-bad8-fac67f6a76fb','edpm-compute-0.ctlplane.openstack.lab','f7c16a79-7209-439b-9d74-60b637cc03cf','/dev/vdb','2025-12-03 22:58:57','2025-12-03 23:00:09','rw','detached','{\"target_discovered\": false, \"target_portals\": [\"172.18.0.10:3260\", \"172.19.0.10:3260\"], \"target_iqns\": [\"iqn.2010-10.org.openstack:volume-32e7a0bf-24be-4840-bad8-fac67f6a76fb\", \"iqn.2010-10.org.openstack:volume-32e7a0bf-24be-4840-bad8-fac67f6a76fb\"], \"target_luns\": [0, 0], \"target_portal\": \"172.18.0.10:3260\", \"target_iqn\": \"iqn.2010-10.org.openstack:volume-32e7a0bf-24be-4840-bad8-fac67f6a76fb\", \"target_lun\": 0, \"volume_id\": \"32e7a0bf-24be-4840-bad8-fac67f6a76fb\", \"auth_method\": \"CHAP\", \"auth_username\": \"PoroPJoYsWCPGp9QJJ95\", \"auth_password\": \"cnSM2mA59WNmizJ6\", \"encrypted\": false, \"qos_specs\": null, \"access_mode\": \"rw\", \"cacheable\": false, \"driver_volume_type\": \"iscsi\", \"attachment_id\": \"95c0572f-2767-4e99-87a5-7cf25b73a9ed\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"edpm-compute-0.ctlplane.openstack.lab\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:de67f5764d74\", \"do_local_attach\": false, \"nvme_hostid\": \"9d2caaef-1159-4058-9696-bd58427d6710\", \"system uuid\": \"fe021eff-a897-4e2f-a7f4-732ef2ad3e31\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:9d2caaef-1159-4058-9696-bd58427d6710\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-03 23:00:43','2025-12-03 23:01:01','2025-12-03 23:01:01',1,'9e174cf7-32cb-49b9-aca7-548b650ad19e','e06e986b-9ab2-48b3-8507-b137e64a204b','edpm-compute-0.ctlplane.openstack.lab','434628a1-4d62-44e6-9f0c-17529d707234','/dev/vdb','2025-12-03 23:00:47','2025-12-03 23:01:01','rw','detached','{\"target_discovered\": false, \"target_portals\": [\"172.18.0.10:3260\", \"172.19.0.10:3260\"], \"target_iqns\": [\"iqn.2010-10.org.openstack:volume-e06e986b-9ab2-48b3-8507-b137e64a204b\", \"iqn.2010-10.org.openstack:volume-e06e986b-9ab2-48b3-8507-b137e64a204b\"], \"target_luns\": [0, 0], \"target_portal\": \"172.18.0.10:3260\", \"target_iqn\": \"iqn.2010-10.org.openstack:volume-e06e986b-9ab2-48b3-8507-b137e64a204b\", \"target_lun\": 0, \"volume_id\": \"e06e986b-9ab2-48b3-8507-b137e64a204b\", \"auth_method\": \"CHAP\", \"auth_username\": \"q9u5crBfk89E8FDD23tE\", \"auth_password\": \"ja76MhQBL5CF8Q6Z\", \"encrypted\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"cacheable\": false, \"driver_volume_type\": \"iscsi\", \"attachment_id\": \"9e174cf7-32cb-49b9-aca7-548b650ad19e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"edpm-compute-0.ctlplane.openstack.lab\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:de67f5764d74\", \"do_local_attach\": false, \"nvme_hostid\": \"9d2caaef-1159-4058-9696-bd58427d6710\", \"system uuid\": \"fe021eff-a897-4e2f-a7f4-732ef2ad3e31\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:9d2caaef-1159-4058-9696-bd58427d6710\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-03 23:37:59','2025-12-03 23:39:54','2025-12-03 23:39:54',1,'9f14b590-d742-4921-afa5-9afe66700103','181167a7-932d-42a2-b911-9fccfb3b4252','edpm-compute-0.ctlplane.openstack.lab','88c08093-8400-49af-8967-2550cb5df4fc','/dev/vda','2025-12-03 23:38:05','2025-12-03 23:39:54','rw','detached','{\"target_discovered\": false, \"target_portals\": [\"172.18.0.10:3260\", \"172.19.0.10:3260\"], \"target_iqns\": [\"iqn.2010-10.org.openstack:volume-181167a7-932d-42a2-b911-9fccfb3b4252\", \"iqn.2010-10.org.openstack:volume-181167a7-932d-42a2-b911-9fccfb3b4252\"], \"target_luns\": [0, 0], \"target_portal\": \"172.18.0.10:3260\", \"target_iqn\": \"iqn.2010-10.org.openstack:volume-181167a7-932d-42a2-b911-9fccfb3b4252\", \"target_lun\": 0, \"volume_id\": \"181167a7-932d-42a2-b911-9fccfb3b4252\", \"auth_method\": \"CHAP\", \"auth_username\": \"2yUJG44H3HLqVkLegqjh\", \"auth_password\": \"M2LaHgkzv64wGpKP\", \"encrypted\": false, \"qos_specs\": null, \"access_mode\": \"rw\", \"cacheable\": false, \"driver_volume_type\": \"iscsi\", \"attachment_id\": \"9f14b590-d742-4921-afa5-9afe66700103\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"edpm-compute-0.ctlplane.openstack.lab\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:de67f5764d74\", \"do_local_attach\": false, \"nvme_hostid\": \"9d2caaef-1159-4058-9696-bd58427d6710\", \"system uuid\": \"fe021eff-a897-4e2f-a7f4-732ef2ad3e31\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:9d2caaef-1159-4058-9696-bd58427d6710\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-03 23:00:35','2025-12-03 23:01:37','2025-12-03 23:01:37',1,'aa80d278-eb7e-4c38-b6fc-f7a829dfbd47','cffc6d58-25a3-400a-b1ec-e5fea05231cc','edpm-compute-0.ctlplane.openstack.lab','47b01995-50da-49cb-81ec-0830ae424fb6','/dev/vdb','2025-12-03 23:00:39','2025-12-03 23:01:37','rw','detached','{\"target_discovered\": false, \"target_portals\": [\"172.18.0.10:3260\", \"172.19.0.10:3260\"], \"target_iqns\": [\"iqn.2010-10.org.openstack:volume-cffc6d58-25a3-400a-b1ec-e5fea05231cc\", \"iqn.2010-10.org.openstack:volume-cffc6d58-25a3-400a-b1ec-e5fea05231cc\"], \"target_luns\": [0, 0], \"target_portal\": \"172.18.0.10:3260\", \"target_iqn\": \"iqn.2010-10.org.openstack:volume-cffc6d58-25a3-400a-b1ec-e5fea05231cc\", \"target_lun\": 0, \"volume_id\": \"cffc6d58-25a3-400a-b1ec-e5fea05231cc\", \"auth_method\": \"CHAP\", \"auth_username\": \"eUg8iFPKaND3YfDmsg3p\", \"auth_password\": \"k3V5RackU4ECYERz\", \"encrypted\": false, \"qos_specs\": null, \"access_mode\": \"rw\", \"cacheable\": false, \"driver_volume_type\": \"iscsi\", \"attachment_id\": \"aa80d278-eb7e-4c38-b6fc-f7a829dfbd47\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"edpm-compute-0.ctlplane.openstack.lab\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:de67f5764d74\", \"do_local_attach\": false, \"nvme_hostid\": \"9d2caaef-1159-4058-9696-bd58427d6710\", \"system uuid\": \"fe021eff-a897-4e2f-a7f4-732ef2ad3e31\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:9d2caaef-1159-4058-9696-bd58427d6710\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-03 23:17:33','2025-12-03 23:17:46','2025-12-03 23:17:46',1,'abe1d3d2-9311-4750-82b6-9b092dfdc19b','2e9f8be8-9b60-4613-9902-8d9e51c1a8f8','edpm-compute-0.ctlplane.openstack.lab','97ce2dbc-01c4-4e30-b170-426717055869','/dev/vdb','2025-12-03 23:17:37','2025-12-03 23:17:46','rw','detached','{\"target_discovered\": false, \"target_portals\": [\"172.18.0.10:3260\", \"172.19.0.10:3260\"], \"target_iqns\": [\"iqn.2010-10.org.openstack:volume-2e9f8be8-9b60-4613-9902-8d9e51c1a8f8\", \"iqn.2010-10.org.openstack:volume-2e9f8be8-9b60-4613-9902-8d9e51c1a8f8\"], \"target_luns\": [0, 0], \"target_portal\": \"172.18.0.10:3260\", \"target_iqn\": \"iqn.2010-10.org.openstack:volume-2e9f8be8-9b60-4613-9902-8d9e51c1a8f8\", \"target_lun\": 0, \"volume_id\": \"2e9f8be8-9b60-4613-9902-8d9e51c1a8f8\", \"auth_method\": \"CHAP\", \"auth_username\": \"2afNRjku34s2Br7f6uRE\", \"auth_password\": \"taTG3vC98zV4TLE5\", \"encrypted\": false, \"qos_specs\": null, \"access_mode\": \"rw\", \"cacheable\": false, \"driver_volume_type\": \"iscsi\", \"attachment_id\": \"abe1d3d2-9311-4750-82b6-9b092dfdc19b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"edpm-compute-0.ctlplane.openstack.lab\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:de67f5764d74\", \"do_local_attach\": false, \"nvme_hostid\": \"9d2caaef-1159-4058-9696-bd58427d6710\", \"system uuid\": \"fe021eff-a897-4e2f-a7f4-732ef2ad3e31\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:9d2caaef-1159-4058-9696-bd58427d6710\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-03 23:38:53','2025-12-03 23:39:43','2025-12-03 23:39:43',1,'bacca030-506d-40eb-9e96-eb1404b51f44','bb4a183c-441c-49f2-be01-34537d0cba07','edpm-compute-0.ctlplane.openstack.lab','2f57f72f-a979-4cee-a314-30dd3e3bddb6','/dev/vda','2025-12-03 23:38:58','2025-12-03 23:39:43','rw','detached','{\"target_discovered\": false, \"target_portals\": [\"172.18.0.10:3260\", \"172.19.0.10:3260\"], \"target_iqns\": [\"iqn.2010-10.org.openstack:volume-bb4a183c-441c-49f2-be01-34537d0cba07\", \"iqn.2010-10.org.openstack:volume-bb4a183c-441c-49f2-be01-34537d0cba07\"], \"target_luns\": [0, 0], \"target_portal\": \"172.18.0.10:3260\", \"target_iqn\": \"iqn.2010-10.org.openstack:volume-bb4a183c-441c-49f2-be01-34537d0cba07\", \"target_lun\": 0, \"volume_id\": \"bb4a183c-441c-49f2-be01-34537d0cba07\", \"auth_method\": \"CHAP\", \"auth_username\": \"2K3bP2QYCkLNiAyUvaxE\", \"auth_password\": \"D2wu5dVz2ZtCCT9g\", \"encrypted\": false, \"qos_specs\": null, \"access_mode\": \"rw\", \"cacheable\": false, \"driver_volume_type\": \"iscsi\", \"attachment_id\": \"bacca030-506d-40eb-9e96-eb1404b51f44\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"edpm-compute-0.ctlplane.openstack.lab\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:de67f5764d74\", \"do_local_attach\": false, \"nvme_hostid\": \"9d2caaef-1159-4058-9696-bd58427d6710\", \"system uuid\": \"fe021eff-a897-4e2f-a7f4-732ef2ad3e31\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:9d2caaef-1159-4058-9696-bd58427d6710\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-03 23:16:20','2025-12-03 23:16:33','2025-12-03 23:16:33',1,'c1a85888-8262-4a4c-a600-b38287f8eab8','494b04c2-9472-4355-afc1-7c637d69239b','edpm-compute-0.ctlplane.openstack.lab','4c946f71-cae9-432c-8fdf-94c38c282bb6','/dev/vdb','2025-12-03 23:16:24','2025-12-03 23:16:33','rw','detached','{\"target_discovered\": false, \"target_portals\": [\"172.18.0.10:3260\", \"172.19.0.10:3260\"], \"target_iqns\": [\"iqn.2010-10.org.openstack:volume-494b04c2-9472-4355-afc1-7c637d69239b\", \"iqn.2010-10.org.openstack:volume-494b04c2-9472-4355-afc1-7c637d69239b\"], \"target_luns\": [0, 0], \"target_portal\": \"172.18.0.10:3260\", \"target_iqn\": \"iqn.2010-10.org.openstack:volume-494b04c2-9472-4355-afc1-7c637d69239b\", \"target_lun\": 0, \"volume_id\": \"494b04c2-9472-4355-afc1-7c637d69239b\", \"auth_method\": \"CHAP\", \"auth_username\": \"KsxSkXcgAQ5tRcH3xcAL\", \"auth_password\": \"BykCQHCZ8agjCC9D\", \"encrypted\": false, \"qos_specs\": null, \"access_mode\": \"rw\", \"cacheable\": false, \"driver_volume_type\": \"iscsi\", \"attachment_id\": \"c1a85888-8262-4a4c-a600-b38287f8eab8\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"edpm-compute-0.ctlplane.openstack.lab\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:de67f5764d74\", \"do_local_attach\": false, \"nvme_hostid\": \"9d2caaef-1159-4058-9696-bd58427d6710\", \"system uuid\": \"fe021eff-a897-4e2f-a7f4-732ef2ad3e31\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:9d2caaef-1159-4058-9696-bd58427d6710\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-03 22:53:49','2025-12-03 22:53:50','2025-12-03 22:53:50',1,'e4066784-3e4b-4dc1-bfd6-14062f5596cd','72bac73e-6a1c-427b-8881-4aa1fd2d20cc',NULL,'a81ca786-60f7-437c-bc12-768d8f6bf8ad','/dev/vdb','2025-12-03 22:53:49','2025-12-03 22:53:50','rw','detached',NULL,NULL),('2025-12-03 23:34:26','2025-12-03 23:34:46','2025-12-03 23:34:46',1,'e7a6de7b-05c8-4f8e-9a0c-792055c66ba8','1177b748-ad2b-46a4-a221-d240271cbcf0','edpm-compute-0.ctlplane.openstack.lab','ea2e874b-6d33-409e-b62d-15e34bcd6f07','/dev/vda','2025-12-03 23:34:30','2025-12-03 23:34:46','rw','detached','{\"target_discovered\": false, \"target_portals\": [\"172.18.0.10:3260\", \"172.19.0.10:3260\"], \"target_iqns\": [\"iqn.2010-10.org.openstack:volume-1177b748-ad2b-46a4-a221-d240271cbcf0\", \"iqn.2010-10.org.openstack:volume-1177b748-ad2b-46a4-a221-d240271cbcf0\"], \"target_luns\": [0, 0], \"target_portal\": \"172.18.0.10:3260\", \"target_iqn\": \"iqn.2010-10.org.openstack:volume-1177b748-ad2b-46a4-a221-d240271cbcf0\", \"target_lun\": 0, \"volume_id\": \"1177b748-ad2b-46a4-a221-d240271cbcf0\", \"auth_method\": \"CHAP\", \"auth_username\": \"WhCS4sNDU2uG75UdZ8Xx\", \"auth_password\": \"MFwoKAGifmHPn5Ex\", \"encrypted\": false, \"qos_specs\": null, \"access_mode\": \"rw\", \"cacheable\": false, \"driver_volume_type\": \"iscsi\", \"attachment_id\": \"e7a6de7b-05c8-4f8e-9a0c-792055c66ba8\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"edpm-compute-0.ctlplane.openstack.lab\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:de67f5764d74\", \"do_local_attach\": false, \"nvme_hostid\": \"9d2caaef-1159-4058-9696-bd58427d6710\", \"system uuid\": \"fe021eff-a897-4e2f-a7f4-732ef2ad3e31\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:9d2caaef-1159-4058-9696-bd58427d6710\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-03 23:37:18','2025-12-03 23:37:56','2025-12-03 23:37:56',1,'f705cfb3-ad0a-48c4-a88e-3ae192ce1ea1','181167a7-932d-42a2-b911-9fccfb3b4252','edpm-compute-0.ctlplane.openstack.lab','d48bf4d8-1ee2-4da1-9004-79d345f60cf9','/dev/vda','2025-12-03 23:37:23','2025-12-03 23:37:56','rw','detached','{\"target_discovered\": false, \"target_portals\": [\"172.18.0.10:3260\", \"172.19.0.10:3260\"], \"target_iqns\": [\"iqn.2010-10.org.openstack:volume-181167a7-932d-42a2-b911-9fccfb3b4252\", \"iqn.2010-10.org.openstack:volume-181167a7-932d-42a2-b911-9fccfb3b4252\"], \"target_luns\": [0, 0], \"target_portal\": \"172.18.0.10:3260\", \"target_iqn\": \"iqn.2010-10.org.openstack:volume-181167a7-932d-42a2-b911-9fccfb3b4252\", \"target_lun\": 0, \"volume_id\": \"181167a7-932d-42a2-b911-9fccfb3b4252\", \"auth_method\": \"CHAP\", \"auth_username\": \"2yUJG44H3HLqVkLegqjh\", \"auth_password\": \"M2LaHgkzv64wGpKP\", \"encrypted\": false, \"qos_specs\": null, \"access_mode\": \"rw\", \"cacheable\": false, \"driver_volume_type\": \"iscsi\", \"attachment_id\": \"f705cfb3-ad0a-48c4-a88e-3ae192ce1ea1\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"edpm-compute-0.ctlplane.openstack.lab\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:de67f5764d74\", \"do_local_attach\": false, \"nvme_hostid\": \"9d2caaef-1159-4058-9696-bd58427d6710\", \"system uuid\": \"fe021eff-a897-4e2f-a7f4-732ef2ad3e31\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:9d2caaef-1159-4058-9696-bd58427d6710\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}');
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=131 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
INSERT INTO `volume_glance_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `snapshot_id`, `key`, `value`) VALUES ('2025-12-03 22:52:31',NULL,'2025-12-03 22:53:25',1,1,'b9801a13-7e42-4c4c-a64d-8071d16018e1',NULL,'signature_verified','False'),('2025-12-03 22:52:38',NULL,'2025-12-03 22:53:25',1,2,'b9801a13-7e42-4c4c-a64d-8071d16018e1',NULL,'hw_rng_model','virtio'),('2025-12-03 22:52:38',NULL,'2025-12-03 22:53:25',1,3,'b9801a13-7e42-4c4c-a64d-8071d16018e1',NULL,'image_id','ee36e3bb-565a-439c-ab21-6b7f9eae8147'),('2025-12-03 22:52:38',NULL,'2025-12-03 22:53:25',1,4,'b9801a13-7e42-4c4c-a64d-8071d16018e1',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-03 22:52:38',NULL,'2025-12-03 22:53:25',1,5,'b9801a13-7e42-4c4c-a64d-8071d16018e1',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-03 22:52:38',NULL,'2025-12-03 22:53:25',1,6,'b9801a13-7e42-4c4c-a64d-8071d16018e1',NULL,'container_format','bare'),('2025-12-03 22:52:38',NULL,'2025-12-03 22:53:25',1,7,'b9801a13-7e42-4c4c-a64d-8071d16018e1',NULL,'disk_format','qcow2'),('2025-12-03 22:52:38',NULL,'2025-12-03 22:53:25',1,8,'b9801a13-7e42-4c4c-a64d-8071d16018e1',NULL,'min_disk','0'),('2025-12-03 22:52:38',NULL,'2025-12-03 22:53:25',1,9,'b9801a13-7e42-4c4c-a64d-8071d16018e1',NULL,'min_ram','0'),('2025-12-03 22:52:38',NULL,'2025-12-03 22:53:25',1,10,'b9801a13-7e42-4c4c-a64d-8071d16018e1',NULL,'size','21430272'),('2025-12-03 22:53:52',NULL,'2025-12-03 22:54:05',1,11,'0cff6eeb-7187-4497-b2c9-97a62f80f1f4',NULL,'signature_verified','False'),('2025-12-03 22:53:58',NULL,'2025-12-03 22:54:05',1,12,'0cff6eeb-7187-4497-b2c9-97a62f80f1f4',NULL,'hw_rng_model','virtio'),('2025-12-03 22:53:58',NULL,'2025-12-03 22:54:05',1,13,'0cff6eeb-7187-4497-b2c9-97a62f80f1f4',NULL,'image_id','ee36e3bb-565a-439c-ab21-6b7f9eae8147'),('2025-12-03 22:53:58',NULL,'2025-12-03 22:54:05',1,14,'0cff6eeb-7187-4497-b2c9-97a62f80f1f4',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-03 22:53:58',NULL,'2025-12-03 22:54:05',1,15,'0cff6eeb-7187-4497-b2c9-97a62f80f1f4',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-03 22:53:58',NULL,'2025-12-03 22:54:05',1,16,'0cff6eeb-7187-4497-b2c9-97a62f80f1f4',NULL,'container_format','bare'),('2025-12-03 22:53:58',NULL,'2025-12-03 22:54:05',1,17,'0cff6eeb-7187-4497-b2c9-97a62f80f1f4',NULL,'disk_format','qcow2'),('2025-12-03 22:53:58',NULL,'2025-12-03 22:54:05',1,18,'0cff6eeb-7187-4497-b2c9-97a62f80f1f4',NULL,'min_disk','0'),('2025-12-03 22:53:58',NULL,'2025-12-03 22:54:05',1,19,'0cff6eeb-7187-4497-b2c9-97a62f80f1f4',NULL,'min_ram','0'),('2025-12-03 22:53:58',NULL,'2025-12-03 22:54:05',1,20,'0cff6eeb-7187-4497-b2c9-97a62f80f1f4',NULL,'size','21430272'),('2025-12-03 23:18:49',NULL,'2025-12-03 23:19:09',1,21,'573cbd14-e420-4691-87de-6a3f4cd7e701',NULL,'signature_verified','False'),('2025-12-03 23:18:54',NULL,'2025-12-03 23:19:09',1,22,'573cbd14-e420-4691-87de-6a3f4cd7e701',NULL,'hw_rng_model','virtio'),('2025-12-03 23:18:54',NULL,'2025-12-03 23:19:09',1,23,'573cbd14-e420-4691-87de-6a3f4cd7e701',NULL,'image_id','ee36e3bb-565a-439c-ab21-6b7f9eae8147'),('2025-12-03 23:18:54',NULL,'2025-12-03 23:19:09',1,24,'573cbd14-e420-4691-87de-6a3f4cd7e701',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-03 23:18:54',NULL,'2025-12-03 23:19:09',1,25,'573cbd14-e420-4691-87de-6a3f4cd7e701',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-03 23:18:54',NULL,'2025-12-03 23:19:09',1,26,'573cbd14-e420-4691-87de-6a3f4cd7e701',NULL,'container_format','bare'),('2025-12-03 23:18:54',NULL,'2025-12-03 23:19:09',1,27,'573cbd14-e420-4691-87de-6a3f4cd7e701',NULL,'disk_format','qcow2'),('2025-12-03 23:18:54',NULL,'2025-12-03 23:19:09',1,28,'573cbd14-e420-4691-87de-6a3f4cd7e701',NULL,'min_disk','0'),('2025-12-03 23:18:54',NULL,'2025-12-03 23:19:09',1,29,'573cbd14-e420-4691-87de-6a3f4cd7e701',NULL,'min_ram','0'),('2025-12-03 23:18:54',NULL,'2025-12-03 23:19:09',1,30,'573cbd14-e420-4691-87de-6a3f4cd7e701',NULL,'size','21430272'),('2025-12-03 23:34:07',NULL,'2025-12-03 23:34:52',1,31,'8149c040-0a26-43d7-8896-b0c1d2feb021',NULL,'signature_verified','False'),('2025-12-03 23:34:12',NULL,'2025-12-03 23:34:52',1,32,'8149c040-0a26-43d7-8896-b0c1d2feb021',NULL,'hw_rng_model','virtio'),('2025-12-03 23:34:12',NULL,'2025-12-03 23:34:52',1,33,'8149c040-0a26-43d7-8896-b0c1d2feb021',NULL,'image_id','ee36e3bb-565a-439c-ab21-6b7f9eae8147'),('2025-12-03 23:34:12',NULL,'2025-12-03 23:34:52',1,34,'8149c040-0a26-43d7-8896-b0c1d2feb021',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-03 23:34:12',NULL,'2025-12-03 23:34:52',1,35,'8149c040-0a26-43d7-8896-b0c1d2feb021',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-03 23:34:12',NULL,'2025-12-03 23:34:52',1,36,'8149c040-0a26-43d7-8896-b0c1d2feb021',NULL,'container_format','bare'),('2025-12-03 23:34:12',NULL,'2025-12-03 23:34:52',1,37,'8149c040-0a26-43d7-8896-b0c1d2feb021',NULL,'disk_format','qcow2'),('2025-12-03 23:34:12',NULL,'2025-12-03 23:34:52',1,38,'8149c040-0a26-43d7-8896-b0c1d2feb021',NULL,'min_disk','0'),('2025-12-03 23:34:12',NULL,'2025-12-03 23:34:52',1,39,'8149c040-0a26-43d7-8896-b0c1d2feb021',NULL,'min_ram','0'),('2025-12-03 23:34:12',NULL,'2025-12-03 23:34:52',1,40,'8149c040-0a26-43d7-8896-b0c1d2feb021',NULL,'size','21430272'),('2025-12-03 23:34:15',NULL,'2025-12-03 23:34:51',1,41,NULL,'d5af72e9-2c72-45cf-a37f-6e7838f62053','signature_verified','False'),('2025-12-03 23:34:15',NULL,'2025-12-03 23:34:51',1,42,NULL,'d5af72e9-2c72-45cf-a37f-6e7838f62053','hw_rng_model','virtio'),('2025-12-03 23:34:15',NULL,'2025-12-03 23:34:51',1,43,NULL,'d5af72e9-2c72-45cf-a37f-6e7838f62053','image_id','ee36e3bb-565a-439c-ab21-6b7f9eae8147'),('2025-12-03 23:34:15',NULL,'2025-12-03 23:34:51',1,44,NULL,'d5af72e9-2c72-45cf-a37f-6e7838f62053','image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-03 23:34:15',NULL,'2025-12-03 23:34:51',1,45,NULL,'d5af72e9-2c72-45cf-a37f-6e7838f62053','checksum','c8fc807773e5354afe61636071771906'),('2025-12-03 23:34:15',NULL,'2025-12-03 23:34:51',1,46,NULL,'d5af72e9-2c72-45cf-a37f-6e7838f62053','container_format','bare'),('2025-12-03 23:34:15',NULL,'2025-12-03 23:34:51',1,47,NULL,'d5af72e9-2c72-45cf-a37f-6e7838f62053','disk_format','qcow2'),('2025-12-03 23:34:15',NULL,'2025-12-03 23:34:51',1,48,NULL,'d5af72e9-2c72-45cf-a37f-6e7838f62053','min_disk','0'),('2025-12-03 23:34:15',NULL,'2025-12-03 23:34:51',1,49,NULL,'d5af72e9-2c72-45cf-a37f-6e7838f62053','min_ram','0'),('2025-12-03 23:34:15',NULL,'2025-12-03 23:34:51',1,50,NULL,'d5af72e9-2c72-45cf-a37f-6e7838f62053','size','21430272'),('2025-12-03 23:34:23',NULL,'2025-12-03 23:34:48',1,51,'1177b748-ad2b-46a4-a221-d240271cbcf0',NULL,'signature_verified','False'),('2025-12-03 23:34:23',NULL,'2025-12-03 23:34:48',1,52,'1177b748-ad2b-46a4-a221-d240271cbcf0',NULL,'hw_rng_model','virtio'),('2025-12-03 23:34:23',NULL,'2025-12-03 23:34:48',1,53,'1177b748-ad2b-46a4-a221-d240271cbcf0',NULL,'image_id','ee36e3bb-565a-439c-ab21-6b7f9eae8147'),('2025-12-03 23:34:23',NULL,'2025-12-03 23:34:48',1,54,'1177b748-ad2b-46a4-a221-d240271cbcf0',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-03 23:34:23',NULL,'2025-12-03 23:34:48',1,55,'1177b748-ad2b-46a4-a221-d240271cbcf0',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-03 23:34:23',NULL,'2025-12-03 23:34:48',1,56,'1177b748-ad2b-46a4-a221-d240271cbcf0',NULL,'container_format','bare'),('2025-12-03 23:34:23',NULL,'2025-12-03 23:34:48',1,57,'1177b748-ad2b-46a4-a221-d240271cbcf0',NULL,'disk_format','qcow2'),('2025-12-03 23:34:23',NULL,'2025-12-03 23:34:48',1,58,'1177b748-ad2b-46a4-a221-d240271cbcf0',NULL,'min_disk','0'),('2025-12-03 23:34:23',NULL,'2025-12-03 23:34:48',1,59,'1177b748-ad2b-46a4-a221-d240271cbcf0',NULL,'min_ram','0'),('2025-12-03 23:34:23',NULL,'2025-12-03 23:34:48',1,60,'1177b748-ad2b-46a4-a221-d240271cbcf0',NULL,'size','21430272'),('2025-12-03 23:34:57',NULL,'2025-12-03 23:36:55',1,61,'f9e6f6da-570c-4f5d-835b-99c75d783f8e',NULL,'signature_verified','False'),('2025-12-03 23:35:02',NULL,'2025-12-03 23:36:55',1,62,'f9e6f6da-570c-4f5d-835b-99c75d783f8e',NULL,'hw_rng_model','virtio'),('2025-12-03 23:35:02',NULL,'2025-12-03 23:36:55',1,63,'f9e6f6da-570c-4f5d-835b-99c75d783f8e',NULL,'image_id','ee36e3bb-565a-439c-ab21-6b7f9eae8147'),('2025-12-03 23:35:02',NULL,'2025-12-03 23:36:55',1,64,'f9e6f6da-570c-4f5d-835b-99c75d783f8e',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-03 23:35:02',NULL,'2025-12-03 23:36:55',1,65,'f9e6f6da-570c-4f5d-835b-99c75d783f8e',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-03 23:35:02',NULL,'2025-12-03 23:36:55',1,66,'f9e6f6da-570c-4f5d-835b-99c75d783f8e',NULL,'container_format','bare'),('2025-12-03 23:35:02',NULL,'2025-12-03 23:36:55',1,67,'f9e6f6da-570c-4f5d-835b-99c75d783f8e',NULL,'disk_format','qcow2'),('2025-12-03 23:35:02',NULL,'2025-12-03 23:36:55',1,68,'f9e6f6da-570c-4f5d-835b-99c75d783f8e',NULL,'min_disk','0'),('2025-12-03 23:35:02',NULL,'2025-12-03 23:36:55',1,69,'f9e6f6da-570c-4f5d-835b-99c75d783f8e',NULL,'min_ram','0'),('2025-12-03 23:35:02',NULL,'2025-12-03 23:36:55',1,70,'f9e6f6da-570c-4f5d-835b-99c75d783f8e',NULL,'size','21430272'),('2025-12-03 23:35:41',NULL,'2025-12-03 23:36:46',1,71,NULL,'75c870e7-5a8e-4c57-b179-6b92a01989dd','signature_verified','False'),('2025-12-03 23:35:41',NULL,'2025-12-03 23:36:46',1,72,NULL,'75c870e7-5a8e-4c57-b179-6b92a01989dd','hw_rng_model','virtio'),('2025-12-03 23:35:41',NULL,'2025-12-03 23:36:46',1,73,NULL,'75c870e7-5a8e-4c57-b179-6b92a01989dd','image_id','ee36e3bb-565a-439c-ab21-6b7f9eae8147'),('2025-12-03 23:35:41',NULL,'2025-12-03 23:36:46',1,74,NULL,'75c870e7-5a8e-4c57-b179-6b92a01989dd','image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-03 23:35:41',NULL,'2025-12-03 23:36:46',1,75,NULL,'75c870e7-5a8e-4c57-b179-6b92a01989dd','checksum','c8fc807773e5354afe61636071771906'),('2025-12-03 23:35:41',NULL,'2025-12-03 23:36:46',1,76,NULL,'75c870e7-5a8e-4c57-b179-6b92a01989dd','container_format','bare'),('2025-12-03 23:35:41',NULL,'2025-12-03 23:36:46',1,77,NULL,'75c870e7-5a8e-4c57-b179-6b92a01989dd','disk_format','qcow2'),('2025-12-03 23:35:41',NULL,'2025-12-03 23:36:46',1,78,NULL,'75c870e7-5a8e-4c57-b179-6b92a01989dd','min_disk','0'),('2025-12-03 23:35:41',NULL,'2025-12-03 23:36:46',1,79,NULL,'75c870e7-5a8e-4c57-b179-6b92a01989dd','min_ram','0'),('2025-12-03 23:35:41',NULL,'2025-12-03 23:36:46',1,80,NULL,'75c870e7-5a8e-4c57-b179-6b92a01989dd','size','21430272'),('2025-12-03 23:35:50',NULL,'2025-12-03 23:36:44',1,81,'3679a497-5948-44f7-81ad-65eefe1bb9ba',NULL,'signature_verified','False'),('2025-12-03 23:35:50',NULL,'2025-12-03 23:36:44',1,82,'3679a497-5948-44f7-81ad-65eefe1bb9ba',NULL,'hw_rng_model','virtio'),('2025-12-03 23:35:50',NULL,'2025-12-03 23:36:44',1,83,'3679a497-5948-44f7-81ad-65eefe1bb9ba',NULL,'image_id','ee36e3bb-565a-439c-ab21-6b7f9eae8147'),('2025-12-03 23:35:50',NULL,'2025-12-03 23:36:44',1,84,'3679a497-5948-44f7-81ad-65eefe1bb9ba',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-03 23:35:50',NULL,'2025-12-03 23:36:44',1,85,'3679a497-5948-44f7-81ad-65eefe1bb9ba',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-03 23:35:50',NULL,'2025-12-03 23:36:44',1,86,'3679a497-5948-44f7-81ad-65eefe1bb9ba',NULL,'container_format','bare'),('2025-12-03 23:35:50',NULL,'2025-12-03 23:36:44',1,87,'3679a497-5948-44f7-81ad-65eefe1bb9ba',NULL,'disk_format','qcow2'),('2025-12-03 23:35:50',NULL,'2025-12-03 23:36:44',1,88,'3679a497-5948-44f7-81ad-65eefe1bb9ba',NULL,'min_disk','0'),('2025-12-03 23:35:50',NULL,'2025-12-03 23:36:44',1,89,'3679a497-5948-44f7-81ad-65eefe1bb9ba',NULL,'min_ram','0'),('2025-12-03 23:35:50',NULL,'2025-12-03 23:36:44',1,90,'3679a497-5948-44f7-81ad-65eefe1bb9ba',NULL,'size','21430272'),('2025-12-03 23:37:10',NULL,'2025-12-03 23:39:58',1,91,'181167a7-932d-42a2-b911-9fccfb3b4252',NULL,'signature_verified','False'),('2025-12-03 23:37:14',NULL,'2025-12-03 23:39:58',1,92,'181167a7-932d-42a2-b911-9fccfb3b4252',NULL,'hw_rng_model','virtio'),('2025-12-03 23:37:14',NULL,'2025-12-03 23:39:58',1,93,'181167a7-932d-42a2-b911-9fccfb3b4252',NULL,'image_id','ee36e3bb-565a-439c-ab21-6b7f9eae8147'),('2025-12-03 23:37:14',NULL,'2025-12-03 23:39:58',1,94,'181167a7-932d-42a2-b911-9fccfb3b4252',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-03 23:37:14',NULL,'2025-12-03 23:39:58',1,95,'181167a7-932d-42a2-b911-9fccfb3b4252',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-03 23:37:14',NULL,'2025-12-03 23:39:58',1,96,'181167a7-932d-42a2-b911-9fccfb3b4252',NULL,'container_format','bare'),('2025-12-03 23:37:14',NULL,'2025-12-03 23:39:58',1,97,'181167a7-932d-42a2-b911-9fccfb3b4252',NULL,'disk_format','qcow2'),('2025-12-03 23:37:14',NULL,'2025-12-03 23:39:58',1,98,'181167a7-932d-42a2-b911-9fccfb3b4252',NULL,'min_disk','0'),('2025-12-03 23:37:14',NULL,'2025-12-03 23:39:58',1,99,'181167a7-932d-42a2-b911-9fccfb3b4252',NULL,'min_ram','0'),('2025-12-03 23:37:14',NULL,'2025-12-03 23:39:58',1,100,'181167a7-932d-42a2-b911-9fccfb3b4252',NULL,'size','21430272'),('2025-12-03 23:38:47',NULL,'2025-12-03 23:39:48',1,101,NULL,'8b27417e-562c-47b0-9563-0e851756df0c','signature_verified','False'),('2025-12-03 23:38:47',NULL,'2025-12-03 23:39:48',1,102,NULL,'8b27417e-562c-47b0-9563-0e851756df0c','hw_rng_model','virtio'),('2025-12-03 23:38:47',NULL,'2025-12-03 23:39:48',1,103,NULL,'8b27417e-562c-47b0-9563-0e851756df0c','image_id','ee36e3bb-565a-439c-ab21-6b7f9eae8147'),('2025-12-03 23:38:47',NULL,'2025-12-03 23:39:48',1,104,NULL,'8b27417e-562c-47b0-9563-0e851756df0c','image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-03 23:38:47',NULL,'2025-12-03 23:39:48',1,105,NULL,'8b27417e-562c-47b0-9563-0e851756df0c','checksum','c8fc807773e5354afe61636071771906'),('2025-12-03 23:38:47',NULL,'2025-12-03 23:39:48',1,106,NULL,'8b27417e-562c-47b0-9563-0e851756df0c','container_format','bare'),('2025-12-03 23:38:47',NULL,'2025-12-03 23:39:48',1,107,NULL,'8b27417e-562c-47b0-9563-0e851756df0c','disk_format','qcow2'),('2025-12-03 23:38:47',NULL,'2025-12-03 23:39:48',1,108,NULL,'8b27417e-562c-47b0-9563-0e851756df0c','min_disk','0'),('2025-12-03 23:38:47',NULL,'2025-12-03 23:39:48',1,109,NULL,'8b27417e-562c-47b0-9563-0e851756df0c','min_ram','0'),('2025-12-03 23:38:47',NULL,'2025-12-03 23:39:48',1,110,NULL,'8b27417e-562c-47b0-9563-0e851756df0c','size','21430272'),('2025-12-03 23:38:50',NULL,'2025-12-03 23:39:46',1,111,'bb4a183c-441c-49f2-be01-34537d0cba07',NULL,'signature_verified','False'),('2025-12-03 23:38:50',NULL,'2025-12-03 23:39:46',1,112,'bb4a183c-441c-49f2-be01-34537d0cba07',NULL,'hw_rng_model','virtio'),('2025-12-03 23:38:50',NULL,'2025-12-03 23:39:46',1,113,'bb4a183c-441c-49f2-be01-34537d0cba07',NULL,'image_id','ee36e3bb-565a-439c-ab21-6b7f9eae8147'),('2025-12-03 23:38:50',NULL,'2025-12-03 23:39:46',1,114,'bb4a183c-441c-49f2-be01-34537d0cba07',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-03 23:38:50',NULL,'2025-12-03 23:39:46',1,115,'bb4a183c-441c-49f2-be01-34537d0cba07',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-03 23:38:50',NULL,'2025-12-03 23:39:46',1,116,'bb4a183c-441c-49f2-be01-34537d0cba07',NULL,'container_format','bare'),('2025-12-03 23:38:50',NULL,'2025-12-03 23:39:46',1,117,'bb4a183c-441c-49f2-be01-34537d0cba07',NULL,'disk_format','qcow2'),('2025-12-03 23:38:50',NULL,'2025-12-03 23:39:46',1,118,'bb4a183c-441c-49f2-be01-34537d0cba07',NULL,'min_disk','0'),('2025-12-03 23:38:50',NULL,'2025-12-03 23:39:46',1,119,'bb4a183c-441c-49f2-be01-34537d0cba07',NULL,'min_ram','0'),('2025-12-03 23:38:50',NULL,'2025-12-03 23:39:46',1,120,'bb4a183c-441c-49f2-be01-34537d0cba07',NULL,'size','21430272'),('2025-12-03 23:41:02',NULL,'2025-12-03 23:41:20',1,121,'13215b4c-c6e9-4e2a-8854-2c2be49f6a00',NULL,'signature_verified','False'),('2025-12-03 23:41:07',NULL,'2025-12-03 23:41:20',1,122,'13215b4c-c6e9-4e2a-8854-2c2be49f6a00',NULL,'hw_rng_model','virtio'),('2025-12-03 23:41:07',NULL,'2025-12-03 23:41:20',1,123,'13215b4c-c6e9-4e2a-8854-2c2be49f6a00',NULL,'image_id','ee36e3bb-565a-439c-ab21-6b7f9eae8147'),('2025-12-03 23:41:07',NULL,'2025-12-03 23:41:20',1,124,'13215b4c-c6e9-4e2a-8854-2c2be49f6a00',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-03 23:41:07',NULL,'2025-12-03 23:41:20',1,125,'13215b4c-c6e9-4e2a-8854-2c2be49f6a00',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-03 23:41:07',NULL,'2025-12-03 23:41:20',1,126,'13215b4c-c6e9-4e2a-8854-2c2be49f6a00',NULL,'container_format','bare'),('2025-12-03 23:41:07',NULL,'2025-12-03 23:41:20',1,127,'13215b4c-c6e9-4e2a-8854-2c2be49f6a00',NULL,'disk_format','qcow2'),('2025-12-03 23:41:07',NULL,'2025-12-03 23:41:20',1,128,'13215b4c-c6e9-4e2a-8854-2c2be49f6a00',NULL,'min_disk','0'),('2025-12-03 23:41:07',NULL,'2025-12-03 23:41:20',1,129,'13215b4c-c6e9-4e2a-8854-2c2be49f6a00',NULL,'min_ram','0'),('2025-12-03 23:41:07',NULL,'2025-12-03 23:41:20',1,130,'13215b4c-c6e9-4e2a-8854-2c2be49f6a00',NULL,'size','21430272');
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
INSERT INTO `volume_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `key`, `value`) VALUES ('2025-12-03 22:50:28',NULL,'2025-12-03 22:50:46',1,1,'7db703c8-be53-45d5-9c0f-73cdbba9135d','Type','work'),('2025-12-03 22:50:32',NULL,'2025-12-03 22:50:43',1,2,'ccd7adff-c431-466c-9eac-d79d5cb7a745','Type','work'),('2025-12-03 22:50:34',NULL,'2025-12-03 22:50:39',1,3,'decd88b2-6fe6-488d-9d05-420d8e13b450','Type','work'),('2025-12-03 22:53:35',NULL,'2025-12-03 22:53:45',1,4,'004b89de-ccc8-409a-8bee-16dc2c0fdc98','Type','Test'),('2025-12-03 22:53:49',NULL,'2025-12-03 22:54:05',1,5,'0cff6eeb-7187-4497-b2c9-97a62f80f1f4','Type','Test');
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
INSERT INTO `volume_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_type_id`, `key`, `value`) VALUES ('2025-12-03 22:48:17',NULL,NULL,0,1,'74947cf2-0d85-4a6f-b162-bfcd888b29be','multiattach','<is> True');
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2025-12-03 22:56:19',NULL,'2025-12-03 22:56:51',1,'0a10354e-2227-4a04-976f-fab6bce5a4c5','tempest-scenario-type-luks-1546695227',NULL,1,NULL),('2025-12-03 23:01:11',NULL,'2025-12-03 23:02:25',1,'14bc9703-bb2e-47eb-9b34-387f140577fa','tempest-scenario-type-luksv2-1021171620',NULL,1,NULL),('2025-12-03 22:58:31',NULL,'2025-12-03 22:59:49',1,'3300577a-a510-4e00-994f-7e924a49dc4d','tempest-scenario-type-cryptsetup-1643023224',NULL,1,NULL),('2025-12-03 23:32:41',NULL,'2025-12-03 23:33:16',1,'3eb0e2bf-407d-466d-8b22-5b1e225efd3c','tempest-scenario-type-luks-1072837293',NULL,1,NULL),('2025-12-03 22:55:21',NULL,'2025-12-03 22:55:52',1,'439954bb-c5fc-49e1-9f8f-6b3a78420c02','tempest-scenario-type-cryptsetup-872248707',NULL,1,NULL),('2025-12-03 22:25:30','2025-12-03 22:25:30',NULL,0,'70f41377-9e53-4b51-abc0-604ca3412d34','__DEFAULT__',NULL,1,'Default Volume Type'),('2025-12-03 22:48:14',NULL,NULL,0,'74947cf2-0d85-4a6f-b162-bfcd888b29be','multiattach',NULL,1,NULL),('2025-12-03 23:33:16',NULL,'2025-12-03 23:34:03',1,'9c148a4c-d734-416d-8d30-9b6b92319ec5','tempest-scenario-type-luks2-1265354225',NULL,1,NULL),('2025-12-03 22:59:49',NULL,'2025-12-03 23:01:11',1,'dbc6d7a6-cfa1-46e4-8d33-236310341f95','tempest-scenario-type-luks-284497772',NULL,1,NULL);
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
INSERT INTO `volumes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `ec2_id`, `user_id`, `project_id`, `host`, `size`, `availability_zone`, `status`, `attach_status`, `scheduled_at`, `launched_at`, `terminated_at`, `display_name`, `display_description`, `provider_location`, `provider_auth`, `snapshot_id`, `volume_type_id`, `source_volid`, `bootable`, `provider_geometry`, `_name_id`, `encryption_key_id`, `migration_status`, `replication_status`, `replication_extended_status`, `replication_driver_data`, `consistencygroup_id`, `provider_id`, `multiattach`, `previous_status`, `cluster_name`, `group_id`, `service_uuid`, `shared_targets`, `use_quota`) VALUES ('2025-12-03 22:53:35','2025-12-03 22:53:44','2025-12-03 22:53:45',1,'004b89de-ccc8-409a-8bee-16dc2c0fdc98',NULL,'43c5ace3a12448ffbcc5f41fcbde1140','5609e6f02f014669b58967ff0e930abd','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 22:53:35','2025-12-03 22:53:36','2025-12-03 22:53:44','tempest-VolumesGetTest-new-Volume-1532252897','This is the new description of volume',NULL,NULL,NULL,'70f41377-9e53-4b51-abc0-604ca3412d34',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 22:53:49','2025-12-03 22:54:04','2025-12-03 22:54:05',1,'0cff6eeb-7187-4497-b2c9-97a62f80f1f4',NULL,'43c5ace3a12448ffbcc5f41fcbde1140','5609e6f02f014669b58967ff0e930abd','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 22:53:49','2025-12-03 22:53:58','2025-12-03 22:54:04','tempest-VolumesGetTest-new-Volume-868244910','This is the new description of volume',NULL,NULL,NULL,'70f41377-9e53-4b51-abc0-604ca3412d34',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 23:34:20','2025-12-03 23:34:46','2025-12-03 23:34:48',1,'1177b748-ad2b-46a4-a221-d240271cbcf0',NULL,'562adaac81824180a41f0757e2b448ee','17135a905ddc412883361a7397e2e39c','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 23:34:20','2025-12-03 23:34:23','2025-12-03 23:34:46','','','172.18.0.10:3260;172.19.0.10:3260,iqn.2010-10.org.openstack:volume-1177b748-ad2b-46a4-a221-d240271cbcf0 iqn.2010-10.org.openstack:volume-1177b748-ad2b-46a4-a221-d240271cbcf0 0','CHAP WhCS4sNDU2uG75UdZ8Xx MFwoKAGifmHPn5Ex','d5af72e9-2c72-45cf-a37f-6e7838f62053','70f41377-9e53-4b51-abc0-604ca3412d34',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 23:40:59','2025-12-03 23:41:18','2025-12-03 23:41:20',1,'13215b4c-c6e9-4e2a-8854-2c2be49f6a00',NULL,'ecca011520524ca2b0dda4a3f90ea632','736cfa939ed54e37b1dae7d67c7093e6','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 23:40:59','2025-12-03 23:41:07','2025-12-03 23:41:18','tempest-TestVolumeBackupRestore-volume-841285340',NULL,'172.18.0.10:3260;172.19.0.10:3260,iqn.2010-10.org.openstack:volume-13215b4c-c6e9-4e2a-8854-2c2be49f6a00 iqn.2010-10.org.openstack:volume-13215b4c-c6e9-4e2a-8854-2c2be49f6a00 0','CHAP XFS6x8Q9DKdJogV26KQF qe4K3BTL8sc58H5n',NULL,'70f41377-9e53-4b51-abc0-604ca3412d34',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'error_backing-up',NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 23:37:07','2025-12-03 23:39:56','2025-12-03 23:39:58',1,'181167a7-932d-42a2-b911-9fccfb3b4252',NULL,'562adaac81824180a41f0757e2b448ee','17135a905ddc412883361a7397e2e39c','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 23:37:07','2025-12-03 23:37:14','2025-12-03 23:39:56','tempest-TestVolumeBootPattern-volume-origin-1963046082',NULL,'172.18.0.10:3260;172.19.0.10:3260,iqn.2010-10.org.openstack:volume-181167a7-932d-42a2-b911-9fccfb3b4252 iqn.2010-10.org.openstack:volume-181167a7-932d-42a2-b911-9fccfb3b4252 0','CHAP 2yUJG44H3HLqVkLegqjh M2LaHgkzv64wGpKP',NULL,'70f41377-9e53-4b51-abc0-604ca3412d34',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 23:01:13','2025-12-03 23:02:22','2025-12-03 23:02:24',1,'1a8b2d07-722e-4c97-8dfd-18fbd4093a0d',NULL,'811f72730dd14e429b7343a2286cfde0','9bf6771e795f41a4b232098116b975b1','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 23:01:13','2025-12-03 23:01:13','2025-12-03 23:02:22','tempest-TestEncryptedCinderVolumes-volume-796163848',NULL,'172.18.0.10:3260;172.19.0.10:3260,iqn.2010-10.org.openstack:volume-1a8b2d07-722e-4c97-8dfd-18fbd4093a0d iqn.2010-10.org.openstack:volume-1a8b2d07-722e-4c97-8dfd-18fbd4093a0d 0','CHAP CyBgSgqHKC24K9WqMCeZ BDH74HJNjH9qsuAM',NULL,'14bc9703-bb2e-47eb-9b34-387f140577fa',NULL,0,NULL,NULL,'04b496f3-463b-42b4-a712-84571b420280',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 22:53:59','2025-12-03 22:54:01','2025-12-03 22:54:03',1,'1b014e63-b840-4955-a467-157978c9db8c',NULL,'43c5ace3a12448ffbcc5f41fcbde1140','5609e6f02f014669b58967ff0e930abd','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 22:54:00','2025-12-03 22:54:00','2025-12-03 22:54:01','tempest-VolumesGetTest-Volume-1644685759',NULL,NULL,NULL,NULL,'70f41377-9e53-4b51-abc0-604ca3412d34',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 22:53:38','2025-12-03 22:53:40','2025-12-03 22:53:42',1,'218cb055-7f35-45fc-9516-e7ab4245124d',NULL,'43c5ace3a12448ffbcc5f41fcbde1140','5609e6f02f014669b58967ff0e930abd','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 22:53:38','2025-12-03 22:53:39','2025-12-03 22:53:40','tempest-VolumesGetTest-Volume-1108130065',NULL,NULL,NULL,NULL,'70f41377-9e53-4b51-abc0-604ca3412d34',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 23:16:41','2025-12-03 23:17:51','2025-12-03 23:17:54',1,'2e9f8be8-9b60-4613-9902-8d9e51c1a8f8',NULL,'6c4a705892cc42cfbedfe3de1504c143','0ebc213514c247388f90f7a4b0b39e1e','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 23:16:42','2025-12-03 23:16:44','2025-12-03 23:17:51','tempest-TestStampPattern-volume-2130213149',NULL,'172.18.0.10:3260;172.19.0.10:3260,iqn.2010-10.org.openstack:volume-2e9f8be8-9b60-4613-9902-8d9e51c1a8f8 iqn.2010-10.org.openstack:volume-2e9f8be8-9b60-4613-9902-8d9e51c1a8f8 0','CHAP 2afNRjku34s2Br7f6uRE taTG3vC98zV4TLE5','a2075fea-97ef-44b8-8ddb-1b407b0be0d8','70f41377-9e53-4b51-abc0-604ca3412d34',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 22:58:51','2025-12-03 23:00:10','2025-12-03 23:00:13',1,'32e7a0bf-24be-4840-bad8-fac67f6a76fb',NULL,'c210c585120043549f62ccb01cec9817','26d36ac1678744fabdbe8d702fccfb9d','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 22:58:51','2025-12-03 22:58:51','2025-12-03 23:00:10','tempest-TestMinimumBasicScenario-volume-1470936891',NULL,'172.18.0.10:3260;172.19.0.10:3260,iqn.2010-10.org.openstack:volume-32e7a0bf-24be-4840-bad8-fac67f6a76fb iqn.2010-10.org.openstack:volume-32e7a0bf-24be-4840-bad8-fac67f6a76fb 0','CHAP PoroPJoYsWCPGp9QJJ95 cnSM2mA59WNmizJ6',NULL,'70f41377-9e53-4b51-abc0-604ca3412d34',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 22:58:31','2025-12-03 22:59:47','2025-12-03 22:59:49',1,'355e6a34-12ac-44c5-a011-f347504ff5c6',NULL,'811f72730dd14e429b7343a2286cfde0','9bf6771e795f41a4b232098116b975b1','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 22:58:32','2025-12-03 22:58:32','2025-12-03 22:59:47','tempest-TestEncryptedCinderVolumes-volume-1389819520',NULL,'172.18.0.10:3260;172.19.0.10:3260,iqn.2010-10.org.openstack:volume-355e6a34-12ac-44c5-a011-f347504ff5c6 iqn.2010-10.org.openstack:volume-355e6a34-12ac-44c5-a011-f347504ff5c6 0','CHAP CrhXFHqmXCw7LBEm6Xrm RWYiXW9uyMuPsCK4',NULL,'3300577a-a510-4e00-994f-7e924a49dc4d',NULL,0,NULL,NULL,'ff6c55fc-50ec-4ea0-a52c-1112ed5da99a',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 23:35:48','2025-12-03 23:36:42','2025-12-03 23:36:44',1,'3679a497-5948-44f7-81ad-65eefe1bb9ba',NULL,'562adaac81824180a41f0757e2b448ee','17135a905ddc412883361a7397e2e39c','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 23:35:48','2025-12-03 23:35:51','2025-12-03 23:36:42','','','172.18.0.10:3260;172.19.0.10:3260,iqn.2010-10.org.openstack:volume-3679a497-5948-44f7-81ad-65eefe1bb9ba iqn.2010-10.org.openstack:volume-3679a497-5948-44f7-81ad-65eefe1bb9ba 0','CHAP G7bFPqUr4RwXwgBoDv6p J6btYfsn7XJ35fd4','75c870e7-5a8e-4c57-b179-6b92a01989dd','70f41377-9e53-4b51-abc0-604ca3412d34',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 23:15:50','2025-12-03 23:18:02','2025-12-03 23:18:04',1,'494b04c2-9472-4355-afc1-7c637d69239b',NULL,'6c4a705892cc42cfbedfe3de1504c143','0ebc213514c247388f90f7a4b0b39e1e','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 23:15:50','2025-12-03 23:15:52','2025-12-03 23:18:02','tempest-TestStampPattern-volume-675708975',NULL,'172.18.0.10:3260;172.19.0.10:3260,iqn.2010-10.org.openstack:volume-494b04c2-9472-4355-afc1-7c637d69239b iqn.2010-10.org.openstack:volume-494b04c2-9472-4355-afc1-7c637d69239b 0','CHAP KsxSkXcgAQ5tRcH3xcAL BykCQHCZ8agjCC9D',NULL,'70f41377-9e53-4b51-abc0-604ca3412d34',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 23:33:17','2025-12-03 23:34:00','2025-12-03 23:34:02',1,'54e1e900-b77c-4281-921b-006456c26276',NULL,'562adaac81824180a41f0757e2b448ee','17135a905ddc412883361a7397e2e39c','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 23:33:17','2025-12-03 23:33:18','2025-12-03 23:34:00','tempest-TestVolumeBootPattern-volume-224540623',NULL,'172.18.0.10:3260;172.19.0.10:3260,iqn.2010-10.org.openstack:volume-54e1e900-b77c-4281-921b-006456c26276 iqn.2010-10.org.openstack:volume-54e1e900-b77c-4281-921b-006456c26276 0','CHAP RaSZLELXWP3U4m2JgQFQ 9k8kEgeBv7h9dQBs',NULL,'9c148a4c-d734-416d-8d30-9b6b92319ec5',NULL,1,NULL,NULL,'fb1e773a-2c66-4d55-84fd-3ce345fe5a83',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 23:18:47','2025-12-03 23:19:07','2025-12-03 23:19:09',1,'573cbd14-e420-4691-87de-6a3f4cd7e701',NULL,'26c99312872e462f9fcc402116b69c78','e014ab433f1c45e4bdfa23184aca2555','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 23:18:47','2025-12-03 23:18:54','2025-12-03 23:19:07','tempest-TestVolumeBackupRestore-volume-119228006',NULL,'172.18.0.10:3260;172.19.0.10:3260,iqn.2010-10.org.openstack:volume-573cbd14-e420-4691-87de-6a3f4cd7e701 iqn.2010-10.org.openstack:volume-573cbd14-e420-4691-87de-6a3f4cd7e701 0','CHAP h4vGZL8kRk3GWRgGKxjG y4ycLEcmGb936T9H',NULL,'70f41377-9e53-4b51-abc0-604ca3412d34',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'error_backing-up',NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 22:53:19','2025-12-03 22:53:56','2025-12-03 22:53:58',1,'72bac73e-6a1c-427b-8881-4aa1fd2d20cc',NULL,'a70a6ef9eeaf4292bdfc6f0d0f2a5458','9e39f529b7be4d20a35fb40e772872cb','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 22:53:20','2025-12-03 22:53:20','2025-12-03 22:53:56','tempest-VolumesActionsTest-Volume-1330920840',NULL,NULL,NULL,NULL,'70f41377-9e53-4b51-abc0-604ca3412d34',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 22:50:28','2025-12-03 22:50:44','2025-12-03 22:50:46',1,'7db703c8-be53-45d5-9c0f-73cdbba9135d',NULL,'9e25cf1abffc4c9fb4ab5d4c4f845a0c','771bd7b64c5e4f84bdc615bbe9783218','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 22:50:28','2025-12-03 22:50:30','2025-12-03 22:50:44','tempest-VolumesListTestJSON-Volume-510507389',NULL,NULL,NULL,NULL,'70f41377-9e53-4b51-abc0-604ca3412d34',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 23:34:04','2025-12-03 23:34:51','2025-12-03 23:34:52',1,'8149c040-0a26-43d7-8896-b0c1d2feb021',NULL,'562adaac81824180a41f0757e2b448ee','17135a905ddc412883361a7397e2e39c','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 23:34:04','2025-12-03 23:34:12','2025-12-03 23:34:51','tempest-TestVolumeBootPattern-volume-origin-1869070850',NULL,NULL,NULL,NULL,'70f41377-9e53-4b51-abc0-604ca3412d34',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 22:55:23','2025-12-03 22:55:48','2025-12-03 22:55:51',1,'b26e0ea4-fdd8-4c5b-996a-825accd9ccb3',NULL,'973c46d6fb5e49898e1694e673e032c7','dbb2710d867347c5b4a3eeb47ef0e6a0','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 22:55:24','2025-12-03 22:55:24','2025-12-03 22:55:48','tempest-VolumeEncryptionTest-volume-2084817532',NULL,'172.18.0.10:3260;172.19.0.10:3260,iqn.2010-10.org.openstack:volume-b26e0ea4-fdd8-4c5b-996a-825accd9ccb3 iqn.2010-10.org.openstack:volume-b26e0ea4-fdd8-4c5b-996a-825accd9ccb3 0','CHAP DBFqV9S3hiUo4LcYHTuy JMT6xNecB7ApXNc2',NULL,'439954bb-c5fc-49e1-9f8f-6b3a78420c02',NULL,0,NULL,NULL,'bdeea01f-40a6-424c-9a51-ed2bc6a25fa4',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 22:52:25','2025-12-03 22:53:23','2025-12-03 22:53:25',1,'b9801a13-7e42-4c4c-a64d-8071d16018e1',NULL,'98dc1ec922434f1ba0c31c914737ce0d','301200c274804774ab9b73b272642d78','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 22:52:25','2025-12-03 22:52:38','2025-12-03 22:53:23','tempest-tempest.common.compute-volume-887999511',NULL,'172.18.0.10:3260;172.19.0.10:3260,iqn.2010-10.org.openstack:volume-b9801a13-7e42-4c4c-a64d-8071d16018e1 iqn.2010-10.org.openstack:volume-b9801a13-7e42-4c4c-a64d-8071d16018e1 0','CHAP Eeek47DYvp5n5qg5niCJ oThjUTJ6FuQhNzhJ',NULL,'70f41377-9e53-4b51-abc0-604ca3412d34',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 23:38:48','2025-12-03 23:39:44','2025-12-03 23:39:46',1,'bb4a183c-441c-49f2-be01-34537d0cba07',NULL,'562adaac81824180a41f0757e2b448ee','17135a905ddc412883361a7397e2e39c','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 23:38:48','2025-12-03 23:38:50','2025-12-03 23:39:44','tempest-TestVolumeBootPattern-volume-1198602566',NULL,'172.18.0.10:3260;172.19.0.10:3260,iqn.2010-10.org.openstack:volume-bb4a183c-441c-49f2-be01-34537d0cba07 iqn.2010-10.org.openstack:volume-bb4a183c-441c-49f2-be01-34537d0cba07 0','CHAP 2K3bP2QYCkLNiAyUvaxE D2wu5dVz2ZtCCT9g','8b27417e-562c-47b0-9563-0e851756df0c','70f41377-9e53-4b51-abc0-604ca3412d34',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 22:56:21','2025-12-03 22:56:49','2025-12-03 22:56:51',1,'c033528c-b279-451f-af1d-c06f7d011053',NULL,'973c46d6fb5e49898e1694e673e032c7','dbb2710d867347c5b4a3eeb47ef0e6a0','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 22:56:21','2025-12-03 22:56:21','2025-12-03 22:56:49','tempest-VolumeEncryptionTest-volume-2060225629',NULL,'172.18.0.10:3260;172.19.0.10:3260,iqn.2010-10.org.openstack:volume-c033528c-b279-451f-af1d-c06f7d011053 iqn.2010-10.org.openstack:volume-c033528c-b279-451f-af1d-c06f7d011053 0','CHAP Eeyo99o6KwMJLK6y9CaL eNBFPQvdJGZY7dHF',NULL,'0a10354e-2227-4a04-976f-fab6bce5a4c5',NULL,0,NULL,NULL,'c4de12dc-5b1e-452b-bbc2-0bc52b3734e5',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 22:50:32','2025-12-03 22:50:41','2025-12-03 22:50:43',1,'ccd7adff-c431-466c-9eac-d79d5cb7a745',NULL,'9e25cf1abffc4c9fb4ab5d4c4f845a0c','771bd7b64c5e4f84bdc615bbe9783218','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 22:50:32','2025-12-03 22:50:32','2025-12-03 22:50:41','tempest-VolumesListTestJSON-Volume-176825702',NULL,NULL,NULL,NULL,'70f41377-9e53-4b51-abc0-604ca3412d34',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 23:00:33','2025-12-03 23:01:37','2025-12-03 23:01:39',1,'cffc6d58-25a3-400a-b1ec-e5fea05231cc',NULL,'c210c585120043549f62ccb01cec9817','26d36ac1678744fabdbe8d702fccfb9d','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 23:00:33','2025-12-03 23:00:34','2025-12-03 23:01:37','tempest-TestMinimumBasicScenario-volume-448845276',NULL,'172.18.0.10:3260;172.19.0.10:3260,iqn.2010-10.org.openstack:volume-cffc6d58-25a3-400a-b1ec-e5fea05231cc iqn.2010-10.org.openstack:volume-cffc6d58-25a3-400a-b1ec-e5fea05231cc 0','CHAP eUg8iFPKaND3YfDmsg3p k3V5RackU4ECYERz',NULL,'70f41377-9e53-4b51-abc0-604ca3412d34',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 22:50:34','2025-12-03 22:50:37','2025-12-03 22:50:39',1,'decd88b2-6fe6-488d-9d05-420d8e13b450',NULL,'9e25cf1abffc4c9fb4ab5d4c4f845a0c','771bd7b64c5e4f84bdc615bbe9783218','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 22:50:34','2025-12-03 22:50:36','2025-12-03 22:50:37','tempest-VolumesListTestJSON-Volume-1145190326',NULL,NULL,NULL,NULL,'70f41377-9e53-4b51-abc0-604ca3412d34',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 22:59:51','2025-12-03 23:01:08','2025-12-03 23:01:10',1,'e06e986b-9ab2-48b3-8507-b137e64a204b',NULL,'811f72730dd14e429b7343a2286cfde0','9bf6771e795f41a4b232098116b975b1','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 22:59:51','2025-12-03 22:59:52','2025-12-03 23:01:08','tempest-TestEncryptedCinderVolumes-volume-1456151855',NULL,'172.18.0.10:3260;172.19.0.10:3260,iqn.2010-10.org.openstack:volume-e06e986b-9ab2-48b3-8507-b137e64a204b iqn.2010-10.org.openstack:volume-e06e986b-9ab2-48b3-8507-b137e64a204b 0','CHAP q9u5crBfk89E8FDD23tE ja76MhQBL5CF8Q6Z',NULL,'dbc6d7a6-cfa1-46e4-8d33-236310341f95',NULL,0,NULL,NULL,'59dc8964-81ad-42a4-a094-5c6a126404e5',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 23:32:42','2025-12-03 23:33:13','2025-12-03 23:33:15',1,'e68af44c-47d0-4477-b6ba-f67055ae2fa3',NULL,'562adaac81824180a41f0757e2b448ee','17135a905ddc412883361a7397e2e39c','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 23:32:42','2025-12-03 23:32:42','2025-12-03 23:33:13','tempest-TestVolumeBootPattern-volume-1827657833',NULL,'172.18.0.10:3260;172.19.0.10:3260,iqn.2010-10.org.openstack:volume-e68af44c-47d0-4477-b6ba-f67055ae2fa3 iqn.2010-10.org.openstack:volume-e68af44c-47d0-4477-b6ba-f67055ae2fa3 0','CHAP fSk44pSVE899uHxH5aCF j8zgFjMqDcUkUU5g',NULL,'3eb0e2bf-407d-466d-8b22-5b1e225efd3c',NULL,1,NULL,NULL,'16a0e7dc-e8ea-4e77-ba06-63c725e1708d',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1),('2025-12-03 23:34:54','2025-12-03 23:36:52','2025-12-03 23:36:55',1,'f9e6f6da-570c-4f5d-835b-99c75d783f8e',NULL,'562adaac81824180a41f0757e2b448ee','17135a905ddc412883361a7397e2e39c','cinder-baebb-volume-lvm-iscsi-0@lvm#lvm_iscsi',1,'nova','deleted','detached','2025-12-03 23:34:54','2025-12-03 23:35:02','2025-12-03 23:36:52','tempest-TestVolumeBootPattern-volume-origin-1499657069',NULL,'172.18.0.10:3260;172.19.0.10:3260,iqn.2010-10.org.openstack:volume-f9e6f6da-570c-4f5d-835b-99c75d783f8e iqn.2010-10.org.openstack:volume-f9e6f6da-570c-4f5d-835b-99c75d783f8e 0','CHAP z2E2VX9VfG2zmgJLMWia 6KBpEKxgKu5YQiSS',NULL,'70f41377-9e53-4b51-abc0-604ca3412d34',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'671da63d-d0c7-4262-9cde-df595c3c2045',0,1);
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2025-12-03 22:25:30','2025-12-03 22:25:30.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'3b3f1220-89d7-42bc-a96b-ae5580cc46a7','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/3b3f1220-89d7-42bc-a96b-ae5580cc46a7','2025-12-03 22:31:16','2025-12-03 22:31:16',NULL,0,'{\"store\": \"default_backend\"}','active'),(2,'ee36e3bb-565a-439c-ab21-6b7f9eae8147','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/ee36e3bb-565a-439c-ab21-6b7f9eae8147','2025-12-03 22:49:43','2025-12-03 22:49:43',NULL,0,'{\"store\": \"default_backend\"}','active'),(3,'64d84e4c-a771-4dd9-83d4-929d5e4750e4','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/64d84e4c-a771-4dd9-83d4-929d5e4750e4','2025-12-03 22:49:44','2025-12-03 22:49:44',NULL,0,'{\"store\": \"default_backend\"}','active'),(4,'857ec267-2b05-455c-8ea3-ababb2d7c8f8','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/857ec267-2b05-455c-8ea3-ababb2d7c8f8','2025-12-03 22:50:22','2025-12-03 22:50:25','2025-12-03 22:50:25',1,'{\"store\": \"default_backend\"}','deleted'),(5,'56c42dba-2fe8-4be1-992b-e0b2958ad1ad','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/56c42dba-2fe8-4be1-992b-e0b2958ad1ad','2025-12-03 22:54:14','2025-12-03 22:54:41','2025-12-03 22:54:41',1,'{\"store\": \"default_backend\"}','deleted'),(6,'c7d2ce17-d12a-4196-967d-ddd1e0938a61','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/c7d2ce17-d12a-4196-967d-ddd1e0938a61','2025-12-03 22:54:44','2025-12-03 22:55:17','2025-12-03 22:55:17',1,'{\"store\": \"default_backend\"}','deleted'),(7,'34ead15b-112d-4a73-ac5f-6e925a541488','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/34ead15b-112d-4a73-ac5f-6e925a541488','2025-12-03 22:54:46','2025-12-03 22:55:29','2025-12-03 22:55:29',1,'{\"store\": \"default_backend\"}','deleted'),(8,'ddffe08f-a470-4099-b6c7-c781cd538208','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/ddffe08f-a470-4099-b6c7-c781cd538208','2025-12-03 22:54:55','2025-12-03 22:55:57','2025-12-03 22:55:57',1,'{\"store\": \"default_backend\"}','deleted'),(9,'d3a4f7fe-8a5b-4567-9751-8422a9174a00','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/d3a4f7fe-8a5b-4567-9751-8422a9174a00','2025-12-03 22:55:06','2025-12-03 22:55:40','2025-12-03 22:55:40',1,'{\"store\": \"default_backend\"}','deleted'),(10,'bcbe4ee5-57b5-4dd7-a5e7-aabe4c13e7b8','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/bcbe4ee5-57b5-4dd7-a5e7-aabe4c13e7b8','2025-12-03 22:55:32','2025-12-03 22:56:20','2025-12-03 22:56:20',1,'{\"store\": \"default_backend\"}','deleted'),(11,'9bffb0bd-23b7-428c-ab5c-8406f0d933e4','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/9bffb0bd-23b7-428c-ab5c-8406f0d933e4','2025-12-03 22:55:33','2025-12-03 22:55:41','2025-12-03 22:55:41',1,'{\"store\": \"default_backend\"}','deleted'),(12,'938ddeea-e99a-4536-b866-8d3b39faaf0e','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/938ddeea-e99a-4536-b866-8d3b39faaf0e','2025-12-03 22:55:51','2025-12-03 22:56:18','2025-12-03 22:56:18',1,'{\"store\": \"default_backend\"}','deleted'),(13,'e8b8bf25-5654-4234-bc6e-542bce0407e3','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/e8b8bf25-5654-4234-bc6e-542bce0407e3','2025-12-03 22:55:59','2025-12-03 22:56:55','2025-12-03 22:56:55',1,'{\"store\": \"default_backend\"}','deleted'),(14,'f5f318a8-625b-47ae-a88d-c5c5b1677ba4','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/f5f318a8-625b-47ae-a88d-c5c5b1677ba4','2025-12-03 22:58:37','2025-12-03 23:00:17','2025-12-03 23:00:17',1,'{\"store\": \"default_backend\"}','deleted'),(15,'3d15d465-24a7-444b-ae4c-142047d2c510','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/3d15d465-24a7-444b-ae4c-142047d2c510','2025-12-03 23:00:18','2025-12-03 23:01:44','2025-12-03 23:01:44',1,'{\"store\": \"default_backend\"}','deleted'),(16,'7e82cff5-ec49-4a1a-8c2b-84a3bb9860b6','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/7e82cff5-ec49-4a1a-8c2b-84a3bb9860b6','2025-12-03 23:14:05','2025-12-03 23:15:02','2025-12-03 23:15:02',1,'{\"store\": \"default_backend\"}','deleted'),(17,'af899b37-e090-4bff-9023-a51a33041494','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/af899b37-e090-4bff-9023-a51a33041494','2025-12-03 23:14:56','2025-12-03 23:14:58','2025-12-03 23:14:58',1,'{\"store\": \"default_backend\"}','deleted'),(18,'64807003-5484-4976-9026-4db6b9160977','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/64807003-5484-4976-9026-4db6b9160977','2025-12-03 23:16:40','2025-12-03 23:17:55','2025-12-03 23:17:55',1,'{\"store\": \"default_backend\"}','deleted'),(19,'b0785a14-41d8-4929-979f-8b742fefe2af','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/b0785a14-41d8-4929-979f-8b742fefe2af','2025-12-03 23:35:42','2025-12-03 23:36:59','2025-12-03 23:36:59',1,'{\"store\": \"default_backend\"}','deleted');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=129 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'3b3f1220-89d7-42bc-a96b-ae5580cc46a7','image_checksum','3827a5c295e21b9662aabde8a3c94fd82e623b311d854050d32dbda326e56a93','2025-12-03 22:31:06','2025-12-03 22:31:06',NULL,0),(3,'3b3f1220-89d7-42bc-a96b-ae5580cc46a7','os_glance_importing_to_stores','','2025-12-03 22:31:06','2025-12-03 22:31:16',NULL,0),(4,'3b3f1220-89d7-42bc-a96b-ae5580cc46a7','os_glance_failed_import','','2025-12-03 22:31:06','2025-12-03 22:31:06',NULL,0),(5,'ee36e3bb-565a-439c-ab21-6b7f9eae8147','hw_rng_model','virtio','2025-12-03 22:49:41','2025-12-03 22:49:41',NULL,0),(6,'64d84e4c-a771-4dd9-83d4-929d5e4750e4','hw_rng_model','virtio','2025-12-03 22:49:43','2025-12-03 22:49:43',NULL,0),(7,'857ec267-2b05-455c-8ea3-ababb2d7c8f8','ramdisk_id','00000000-1111-2222-3333-444455556666','2025-12-03 22:50:20','2025-12-03 22:50:25','2025-12-03 22:50:25',1),(8,'56c42dba-2fe8-4be1-992b-e0b2958ad1ad','img_signature','2bXIGVhD9TeIWHubqkH6TMqy68CTxAtxBr/Lgn/TmqLQDoIpNKTkP9kawBmjvxsihVectdGeJgoCnnxcdmgaKYBlCwjZirhEFJwzJNDZE+AEnxvKzKuW0l6Ja7oF+orqwQqFNsOa1Al38GsNcfl9S7VB0D/D9SmvheBo5ov52yFLAjjlBIkFi1STqnIWdny1GFuWQFRPrft8LFpi8yaIyUQHgZ+9Q+bEgr/srKXTg1puhLocc+Cfm0LP4IuREZJ+xUu7XpKGUAPnRkw5trTJf4j9jNhaFMt2sfVvokPutjosL3eaJFxA7243HClUR4/HDRjZHGtoQjHPKrBl1/LIgTXJpe6i1jnPERWBdXJt9HDaNaaeDMbulwW0NNjsoQFOFT0l9Cr7ToIHqLO69z+JagI4JkojnRp66KXxsj/H+Sg6duH9VNv9+qyhZkE8pqmuOSl7Qr6R7y1yTBXCB4YKl3gOEZhBNtL+mWj3fzW6xFFNtiBBMSzXPRSCm9KvhFQE','2025-12-03 22:54:11','2025-12-03 22:54:42','2025-12-03 22:54:42',1),(9,'56c42dba-2fe8-4be1-992b-e0b2958ad1ad','img_signature_certificate_uuid','144df04f-b8bf-410b-91e4-1cf230c80a98','2025-12-03 22:54:11','2025-12-03 22:54:42','2025-12-03 22:54:42',1),(10,'56c42dba-2fe8-4be1-992b-e0b2958ad1ad','img_signature_key_type','RSA-PSS','2025-12-03 22:54:11','2025-12-03 22:54:42','2025-12-03 22:54:42',1),(11,'56c42dba-2fe8-4be1-992b-e0b2958ad1ad','img_signature_hash_method','SHA-256','2025-12-03 22:54:11','2025-12-03 22:54:42','2025-12-03 22:54:42',1),(12,'c7d2ce17-d12a-4196-967d-ddd1e0938a61','img_signature','xS3CN7OE0AhlhjbTEn8L3o4/D1NJMQg4NVqUA3NGZQhpXAl7KHR86ZV1ml65BpNtmw78t7VRMi4nwjHm15SoyK5VNsVw4ia6ldynVcB52QcWeZ78xeG25+tEjGtIWSUSUG8UiMggywq8hq+7OZeQn4Uz55mzhiwpuYAqVPw2OQbmA+SHFsvDXsZUtpISzhX8iVQdnWHaIOCNf2rIrm8i96zpQ69SK/65V+MTrS0Kg/5oApjJ1fR+/Ngbtx8ojEPuwxpUgLbVoZLbAPnL++PHa+BSsxfpGV46iHUCO060iH0s49Ia+iwxSw0KyvqLv+/FJY04YGjbaGcHN26Ut0KVYBH+lDrtmO1YAJpN2EjN8Wwvx7EA8Ie8Ehz248iX9Qm3a66oJvgOcw13wT6j+GOFsWxd+47qKPojJjfAeYEcqoFuH9bKALmnJpH5xYSqadUJ7um3hgzGiMDVH2qLNXPM9YK5DpMm8A7pRUcBHpk0bAzHLPpGk7h4Ubjrq/i9c0Db','2025-12-03 22:54:41','2025-12-03 22:55:17','2025-12-03 22:55:17',1),(13,'c7d2ce17-d12a-4196-967d-ddd1e0938a61','img_signature_certificate_uuid','f1caa75c-461a-4781-b85f-4faa92900595','2025-12-03 22:54:41','2025-12-03 22:55:17','2025-12-03 22:55:17',1),(14,'c7d2ce17-d12a-4196-967d-ddd1e0938a61','img_signature_key_type','RSA-PSS','2025-12-03 22:54:41','2025-12-03 22:55:17','2025-12-03 22:55:17',1),(15,'c7d2ce17-d12a-4196-967d-ddd1e0938a61','img_signature_hash_method','SHA-256','2025-12-03 22:54:41','2025-12-03 22:55:17','2025-12-03 22:55:17',1),(16,'34ead15b-112d-4a73-ac5f-6e925a541488','img_signature','QhGqImAEwlJR5Ad1/6VtH6hcGXCnsQbE01Ww9OY3SHgTvpafQjvB1pmfop6r4U+n3uTzeW5P5IxtzR8WBkxS665aah0StuyGrcduWoL3DHLRV1QZXjhH/NcgruOOuZ0WyUj571gjRoo4Sujcf55TGzv2r1Mzxm9UybukaR20NKKBLvC9TjzIA7iiqrPB1Keo2R8vlB3yvCIhiuPkXwZ/edbr/ZQ8dWIiPIrPtuFH+yo29mzFSt/eAns3Okdj7CDBPZgXNtRKE6m7j9YBKXs6cSBXO3BTM3Zr0KxyZADgB6agudOqFnrw7u0QbBCUs0gFzQlHUJNHNGCdRqBdT/0BPiGOKZJ7yU86sPpRyS8a6V5LXpHKTFlPQ4yaj3wcUylVBdFPegMFsdm1eRVYDv9jcZARM7YkhZtX82BTk2wh8M8wrrIe3ByeIZG5IDdYw28SlUYcTArqsHGMbH/b4q61UGTpiChN6MN8LcunpmC8ytmSWjvqLnsaaz8FCV22RAEJ','2025-12-03 22:54:43','2025-12-03 22:55:29','2025-12-03 22:55:29',1),(17,'34ead15b-112d-4a73-ac5f-6e925a541488','img_signature_certificate_uuid','c6678d15-6087-4ddd-a037-d8049e64f93a','2025-12-03 22:54:43','2025-12-03 22:55:29','2025-12-03 22:55:29',1),(18,'34ead15b-112d-4a73-ac5f-6e925a541488','img_signature_key_type','RSA-PSS','2025-12-03 22:54:43','2025-12-03 22:55:29','2025-12-03 22:55:29',1),(19,'34ead15b-112d-4a73-ac5f-6e925a541488','img_signature_hash_method','SHA-256','2025-12-03 22:54:43','2025-12-03 22:55:29','2025-12-03 22:55:29',1),(20,'ddffe08f-a470-4099-b6c7-c781cd538208','img_signature','SGKmIVAqJEy0D7ijRoUueQe41TBdHEdeNYZGoWZ4p9k5WPYwCpblkPc80iW9mAubX3SrMFCHqLOy4Z/h9M3WWBWM+fpiO3GrqZIA8WFw0MA6aa5NTS7H2hG1F45k/y0PpbV0BPGFqQxiGAMDU99MKsn0AQFGk7+yp0mB7BBrntzfFmHp+yznQsBXKcrSCAdXgbPuU2ip8FCBS0qdNyk/6YMXieaNs+5ffdrz4+VaARX4EhkA6oq09iv7l0RTqHB2Lkt+g8uoFy7wDRs+pLXt1JCePIg3/NkNkmBQE6dsjKg9Xtjo6UQW/+9fdARJTEoqe15mZ1g87OeNjtcYgRTJ6WuZp+M9sX7ql0MBseY9eZxR0c4RlzQBtV2WI0StZpb/fzv49z5yNVQmC9cLaCsXtTAc++L0lnv08k5S6VMkc48R+NOH0hDjf908scqWAy0pwaVLWMCOw8pSG2i3CBH5unLgmiqT1cO6EwLtQIPUccvP1aECpF8FAco9Wrn/djie','2025-12-03 22:54:54','2025-12-03 22:55:57','2025-12-03 22:55:57',1),(21,'ddffe08f-a470-4099-b6c7-c781cd538208','img_signature_certificate_uuid','723811ed-48d4-4e9a-af84-00897f80d0f9','2025-12-03 22:54:54','2025-12-03 22:55:57','2025-12-03 22:55:57',1),(22,'ddffe08f-a470-4099-b6c7-c781cd538208','img_signature_key_type','RSA-PSS','2025-12-03 22:54:54','2025-12-03 22:55:57','2025-12-03 22:55:57',1),(23,'ddffe08f-a470-4099-b6c7-c781cd538208','img_signature_hash_method','SHA-256','2025-12-03 22:54:54','2025-12-03 22:55:57','2025-12-03 22:55:57',1),(24,'d3a4f7fe-8a5b-4567-9751-8422a9174a00','img_signature','C01TfpzGIRlnwCwV9i9sFwDcy84aRTAno9ybx57CBylKq5au1D13NeIKlWUFBWMPRPwP2p4DWMCTZ1wWR9gcIN7ahz7g3JP0BFzFcOZxP0mU1KYVT083mHikEmPVIjJU+g0XaFG+fzJG315ltWgA3ixZyXabcZNPKJmlaAseIZxr3wIdQ+AF4NdLtV+jWAaJrv2I68jrEuOTcm8k3wk43Lt9rKMg4JmQOP1CAV3W8VkYdo5f+H6VzwkgSXOf94vweE0CBvTMRoJD+RmY7h3OvOStr6foplits22iD57eMOqh+J2tzSOC10xvnTXqGsoC/ICtTYWOxLZWNIjvG885Jw+uWSEcwXPQd0B8oJpYpK0gBHxzNyPHXNm2yOTHlz35+WQajiE/wa4P/jG7rVu9AEzcPzdiVJUGyN3rRr5IK51VxaJe2HbQlfrakM/zNIgsa+rw8ET36KKUxzEezosb0adZKf2lt9QOalRkWD4EBYAiYHCoygqKoqiW/jojJVJT','2025-12-03 22:55:05','2025-12-03 22:55:40','2025-12-03 22:55:40',1),(25,'d3a4f7fe-8a5b-4567-9751-8422a9174a00','img_signature_certificate_uuid','d6b2e7a5-4bd1-4600-b3b6-a77d1c04c743','2025-12-03 22:55:05','2025-12-03 22:55:40','2025-12-03 22:55:40',1),(26,'d3a4f7fe-8a5b-4567-9751-8422a9174a00','img_signature_key_type','RSA-PSS','2025-12-03 22:55:05','2025-12-03 22:55:40','2025-12-03 22:55:40',1),(27,'d3a4f7fe-8a5b-4567-9751-8422a9174a00','img_signature_hash_method','SHA-256','2025-12-03 22:55:05','2025-12-03 22:55:40','2025-12-03 22:55:40',1),(28,'9bffb0bd-23b7-428c-ab5c-8406f0d933e4','base_image_ref','d3a4f7fe-8a5b-4567-9751-8422a9174a00','2025-12-03 22:55:28','2025-12-03 22:55:41','2025-12-03 22:55:41',1),(29,'9bffb0bd-23b7-428c-ab5c-8406f0d933e4','owner_user_name','tempest-ImageSigningSnapshotTest-1696105409-project-member','2025-12-03 22:55:28','2025-12-03 22:55:41','2025-12-03 22:55:41',1),(30,'9bffb0bd-23b7-428c-ab5c-8406f0d933e4','owner_project_name','tempest-ImageSigningSnapshotTest-1696105409','2025-12-03 22:55:28','2025-12-03 22:55:41','2025-12-03 22:55:41',1),(31,'9bffb0bd-23b7-428c-ab5c-8406f0d933e4','boot_roles','swiftoperator,reader,member','2025-12-03 22:55:28','2025-12-03 22:55:41','2025-12-03 22:55:41',1),(32,'9bffb0bd-23b7-428c-ab5c-8406f0d933e4','hw_machine_type','q35','2025-12-03 22:55:28','2025-12-03 22:55:41','2025-12-03 22:55:41',1),(33,'9bffb0bd-23b7-428c-ab5c-8406f0d933e4','hw_cdrom_bus','sata','2025-12-03 22:55:28','2025-12-03 22:55:41','2025-12-03 22:55:41',1),(34,'9bffb0bd-23b7-428c-ab5c-8406f0d933e4','hw_disk_bus','virtio','2025-12-03 22:55:28','2025-12-03 22:55:41','2025-12-03 22:55:41',1),(35,'9bffb0bd-23b7-428c-ab5c-8406f0d933e4','hw_input_bus','usb','2025-12-03 22:55:28','2025-12-03 22:55:41','2025-12-03 22:55:41',1),(36,'9bffb0bd-23b7-428c-ab5c-8406f0d933e4','hw_pointer_model','usbtablet','2025-12-03 22:55:28','2025-12-03 22:55:41','2025-12-03 22:55:41',1),(37,'9bffb0bd-23b7-428c-ab5c-8406f0d933e4','hw_video_model','virtio','2025-12-03 22:55:28','2025-12-03 22:55:41','2025-12-03 22:55:41',1),(38,'9bffb0bd-23b7-428c-ab5c-8406f0d933e4','hw_vif_model','virtio','2025-12-03 22:55:28','2025-12-03 22:55:41','2025-12-03 22:55:41',1),(39,'9bffb0bd-23b7-428c-ab5c-8406f0d933e4','instance_uuid','08d20f3c-bf3f-404b-b3e2-67e23e57fb60','2025-12-03 22:55:28','2025-12-03 22:55:41','2025-12-03 22:55:41',1),(40,'9bffb0bd-23b7-428c-ab5c-8406f0d933e4','user_id','eb1e57f1c5d0413399aaed259cde52ed','2025-12-03 22:55:28','2025-12-03 22:55:41','2025-12-03 22:55:41',1),(41,'9bffb0bd-23b7-428c-ab5c-8406f0d933e4','image_type','snapshot','2025-12-03 22:55:28','2025-12-03 22:55:41','2025-12-03 22:55:41',1),(42,'bcbe4ee5-57b5-4dd7-a5e7-aabe4c13e7b8','img_signature','dDWIx5x3VAB/UPsP0T40I7PZML5mbNEA1/zyVYiyaAXOnjtjElsi6Sapz24cSOSGXC09cO8KOwUsX+yJ06J/TpZkLVDaRjLjyeJxk11pmjMBQVaN6fC12hGz2CJXwuYxKvclvhTCoTBjnHDqdaEwrg3CAkGnWaxrLz6RPmIrRDxDHhVUpdvVRz6Ov+A3MqMP0Z1ynesxopwYnBK/cHZ9ZYJtPssnlKYyNXttbfYGnrF8EZBxERhfY1bb7L9JrKi33aAjlmczgYm3Ukk+R3khxKDqeHOEG5Diz3ADlJ2GhjCuVekRa9RWre9gIAArAddUN+QtHYyQVksO5KjDAtnu89i75ykbctaPzgpqFV0d2P9lL0ZPYVaNhgMGfK+kd2gQX+b0mYigGbnud9wEWQaTvkWzO+rbNuuJWZq7+7P2WZ93W/byNNjAGCZKI7iKJSTWAUOmbPetFWA1OA5rnKM4NwLapPDrfvvcdUafi7Dw/6okn65WcP2rOsnIGfi6ItPm','2025-12-03 22:55:30','2025-12-03 22:56:20','2025-12-03 22:56:20',1),(43,'bcbe4ee5-57b5-4dd7-a5e7-aabe4c13e7b8','img_signature_certificate_uuid','80b6fba2-a9d0-417e-8ff8-7c828eade650','2025-12-03 22:55:30','2025-12-03 22:56:20','2025-12-03 22:56:20',1),(44,'bcbe4ee5-57b5-4dd7-a5e7-aabe4c13e7b8','img_signature_key_type','RSA-PSS','2025-12-03 22:55:30','2025-12-03 22:56:20','2025-12-03 22:56:20',1),(45,'bcbe4ee5-57b5-4dd7-a5e7-aabe4c13e7b8','img_signature_hash_method','SHA-256','2025-12-03 22:55:30','2025-12-03 22:56:20','2025-12-03 22:56:20',1),(46,'9bffb0bd-23b7-428c-ab5c-8406f0d933e4','image_state','available','2025-12-03 22:55:31','2025-12-03 22:55:41','2025-12-03 22:55:41',1),(47,'9bffb0bd-23b7-428c-ab5c-8406f0d933e4','image_location','snapshot','2025-12-03 22:55:31','2025-12-03 22:55:41','2025-12-03 22:55:41',1),(48,'9bffb0bd-23b7-428c-ab5c-8406f0d933e4','owner_id','50c6b4aa393644a6a1f79dc8daa3a531','2025-12-03 22:55:31','2025-12-03 22:55:41','2025-12-03 22:55:41',1),(49,'938ddeea-e99a-4536-b866-8d3b39faaf0e','img_signature','jrXfLi9AqKnVDKjIjQf5QH8KM0tNYnFz+y7fgAJfbJ57HUgRZCzylpMZUZ8m9sk2JPVe6z4IFqAkKiAKOnLbWORa2G6sBKGOeiXyTN1YexzKKzMgd6cQU5AIsVHJS9CNR8qt7GUbJ7nPNguwDYmbQmCaxlQT3pnQK5XOrkGGrp91cOlJptI03BUiS/oQz/qn/OoBnsyRul/FROe1HZ2c4OmbQT5bIS9Cc20n2vq7Q4EgD9+NPvY8fyQQCdru5HB+Ja1GTTTj1CVlt+AYXYeoDrmIqyxD+t5GWYdvcBEVAqWLjZnZpJ+i/V6GOH05SUPTtbUuiT+nmPOzL9jwRLEq9KJhDx4myiYT1P2Z0vqzjQ6WBJz8UQSbXGMyCC2clacmMz88DB0NmIXtssH569qeSLb5mK/Mtbqsk1RzJafiuFLFdkRV+/Ob5aazCN8tLs08wdYOvjyIisLReJZQHOJkiKXiUbebG+FVmchLcLGKcqj2KKutNac6p8yMShpq9zwz','2025-12-03 22:55:49','2025-12-03 22:56:18','2025-12-03 22:56:18',1),(50,'938ddeea-e99a-4536-b866-8d3b39faaf0e','img_signature_certificate_uuid','80b6fba2-a9d0-417e-8ff8-7c828eade650','2025-12-03 22:55:49','2025-12-03 22:56:18','2025-12-03 22:56:18',1),(51,'938ddeea-e99a-4536-b866-8d3b39faaf0e','img_signature_key_type','RSA-PSS','2025-12-03 22:55:49','2025-12-03 22:56:18','2025-12-03 22:56:18',1),(52,'938ddeea-e99a-4536-b866-8d3b39faaf0e','img_signature_hash_method','SHA-256','2025-12-03 22:55:49','2025-12-03 22:56:18','2025-12-03 22:56:18',1),(53,'e8b8bf25-5654-4234-bc6e-542bce0407e3','img_signature','maoin6yLg9h1dhEgjFoUWqR7vegjdkEh1NifjVOBeA8djcE+RAYhha2iBWvXiLl8hmjILEVUmNsP4xJf4w5IJ5k5SktPFMIonGgL4o/A/4otfhHJ+zA5C7EosaclcOcfKROkxuA6yevNeWs6Z7cacTLLdldZ++mziffItcihRrt8t85P3VlepoWceTCsa7GitHJNpoD7E3P8wYhw0o0kuGQfGDpp4geYFub8OPtCAI5+3cvnnNDim9P4kWWMFkwvHXReg/id3A1Iq4ayZ/QwhqFe4uxh2Zg3RkLo6s4/ZH352KpapMkiZzY/GamTIs20BprIMajGJIchHYiDR5M3THy/hAcBCVTVOdVn+3g51NXcebVkoUmUghzGRx700gkG1EpHFnlW3UKO3IHXhmJTnGVIN+8nuZnGNwE3nIHNeUAATsAfNk5wD9+ol6zjh5PvzYO25tKHtH/pthaRgB2eePrwbMKB6yXW4BdgVzCcC3cOidNWVQs0s/xi2xDin/86','2025-12-03 22:55:58','2025-12-03 22:56:55','2025-12-03 22:56:55',1),(54,'e8b8bf25-5654-4234-bc6e-542bce0407e3','img_signature_certificate_uuid','d15a1e1f-c23d-4da2-9a13-c98e301d7afb','2025-12-03 22:55:58','2025-12-03 22:56:55','2025-12-03 22:56:55',1),(55,'e8b8bf25-5654-4234-bc6e-542bce0407e3','img_signature_key_type','RSA-PSS','2025-12-03 22:55:58','2025-12-03 22:56:55','2025-12-03 22:56:55',1),(56,'e8b8bf25-5654-4234-bc6e-542bce0407e3','img_signature_hash_method','SHA-256','2025-12-03 22:55:58','2025-12-03 22:56:55','2025-12-03 22:56:55',1),(57,'7e82cff5-ec49-4a1a-8c2b-84a3bb9860b6','hw_rng_model','virtio','2025-12-03 23:14:01','2025-12-03 23:15:02','2025-12-03 23:15:02',1),(58,'7e82cff5-ec49-4a1a-8c2b-84a3bb9860b6','base_image_ref','ee36e3bb-565a-439c-ab21-6b7f9eae8147','2025-12-03 23:14:01','2025-12-03 23:15:02','2025-12-03 23:15:02',1),(59,'7e82cff5-ec49-4a1a-8c2b-84a3bb9860b6','owner_user_name','tempest-TestSnapshotPattern-1746177856-project-member','2025-12-03 23:14:01','2025-12-03 23:15:02','2025-12-03 23:15:02',1),(60,'7e82cff5-ec49-4a1a-8c2b-84a3bb9860b6','owner_project_name','tempest-TestSnapshotPattern-1746177856','2025-12-03 23:14:01','2025-12-03 23:15:02','2025-12-03 23:15:02',1),(61,'7e82cff5-ec49-4a1a-8c2b-84a3bb9860b6','boot_roles','member,reader','2025-12-03 23:14:01','2025-12-03 23:15:02','2025-12-03 23:15:02',1),(62,'7e82cff5-ec49-4a1a-8c2b-84a3bb9860b6','hw_machine_type','q35','2025-12-03 23:14:01','2025-12-03 23:15:02','2025-12-03 23:15:02',1),(63,'7e82cff5-ec49-4a1a-8c2b-84a3bb9860b6','hw_cdrom_bus','sata','2025-12-03 23:14:01','2025-12-03 23:15:02','2025-12-03 23:15:02',1),(64,'7e82cff5-ec49-4a1a-8c2b-84a3bb9860b6','hw_disk_bus','virtio','2025-12-03 23:14:01','2025-12-03 23:15:02','2025-12-03 23:15:02',1),(65,'7e82cff5-ec49-4a1a-8c2b-84a3bb9860b6','hw_input_bus','usb','2025-12-03 23:14:01','2025-12-03 23:15:02','2025-12-03 23:15:02',1),(66,'7e82cff5-ec49-4a1a-8c2b-84a3bb9860b6','hw_pointer_model','usbtablet','2025-12-03 23:14:01','2025-12-03 23:15:02','2025-12-03 23:15:02',1),(67,'7e82cff5-ec49-4a1a-8c2b-84a3bb9860b6','hw_video_model','virtio','2025-12-03 23:14:01','2025-12-03 23:15:02','2025-12-03 23:15:02',1),(68,'7e82cff5-ec49-4a1a-8c2b-84a3bb9860b6','hw_vif_model','virtio','2025-12-03 23:14:01','2025-12-03 23:15:02','2025-12-03 23:15:02',1),(69,'7e82cff5-ec49-4a1a-8c2b-84a3bb9860b6','instance_uuid','3de114c9-3f5c-46ec-9894-66b9234d1ca1','2025-12-03 23:14:01','2025-12-03 23:15:02','2025-12-03 23:15:02',1),(70,'7e82cff5-ec49-4a1a-8c2b-84a3bb9860b6','user_id','2539b37a97c744c386a7fc680a4cd3a7','2025-12-03 23:14:01','2025-12-03 23:15:02','2025-12-03 23:15:02',1),(71,'7e82cff5-ec49-4a1a-8c2b-84a3bb9860b6','image_type','snapshot','2025-12-03 23:14:01','2025-12-03 23:15:02','2025-12-03 23:15:02',1),(72,'7e82cff5-ec49-4a1a-8c2b-84a3bb9860b6','image_state','available','2025-12-03 23:14:03','2025-12-03 23:15:02','2025-12-03 23:15:02',1),(73,'7e82cff5-ec49-4a1a-8c2b-84a3bb9860b6','image_location','snapshot','2025-12-03 23:14:03','2025-12-03 23:15:02','2025-12-03 23:15:02',1),(74,'7e82cff5-ec49-4a1a-8c2b-84a3bb9860b6','owner_id','5c73b76d928d4467989a8e2e395bb892','2025-12-03 23:14:03','2025-12-03 23:15:02','2025-12-03 23:15:02',1),(75,'7e82cff5-ec49-4a1a-8c2b-84a3bb9860b6','version','8.0','2025-12-03 23:14:05','2025-12-03 23:15:02','2025-12-03 23:15:02',1),(76,'af899b37-e090-4bff-9023-a51a33041494','hw_rng_model','virtio','2025-12-03 23:14:52','2025-12-03 23:14:58','2025-12-03 23:14:58',1),(77,'af899b37-e090-4bff-9023-a51a33041494','base_image_ref','ee36e3bb-565a-439c-ab21-6b7f9eae8147','2025-12-03 23:14:52','2025-12-03 23:14:58','2025-12-03 23:14:58',1),(78,'af899b37-e090-4bff-9023-a51a33041494','owner_user_name','tempest-TestSnapshotPattern-1746177856-project-member','2025-12-03 23:14:52','2025-12-03 23:14:58','2025-12-03 23:14:58',1),(79,'af899b37-e090-4bff-9023-a51a33041494','owner_project_name','tempest-TestSnapshotPattern-1746177856','2025-12-03 23:14:52','2025-12-03 23:14:58','2025-12-03 23:14:58',1),(80,'af899b37-e090-4bff-9023-a51a33041494','boot_roles','member,reader','2025-12-03 23:14:52','2025-12-03 23:14:58','2025-12-03 23:14:58',1),(81,'af899b37-e090-4bff-9023-a51a33041494','hw_machine_type','q35','2025-12-03 23:14:52','2025-12-03 23:14:58','2025-12-03 23:14:58',1),(82,'af899b37-e090-4bff-9023-a51a33041494','hw_cdrom_bus','sata','2025-12-03 23:14:52','2025-12-03 23:14:58','2025-12-03 23:14:58',1),(83,'af899b37-e090-4bff-9023-a51a33041494','hw_disk_bus','virtio','2025-12-03 23:14:52','2025-12-03 23:14:58','2025-12-03 23:14:58',1),(84,'af899b37-e090-4bff-9023-a51a33041494','hw_input_bus','usb','2025-12-03 23:14:52','2025-12-03 23:14:58','2025-12-03 23:14:58',1),(85,'af899b37-e090-4bff-9023-a51a33041494','hw_pointer_model','usbtablet','2025-12-03 23:14:52','2025-12-03 23:14:58','2025-12-03 23:14:58',1),(86,'af899b37-e090-4bff-9023-a51a33041494','hw_video_model','virtio','2025-12-03 23:14:52','2025-12-03 23:14:58','2025-12-03 23:14:58',1),(87,'af899b37-e090-4bff-9023-a51a33041494','hw_vif_model','virtio','2025-12-03 23:14:52','2025-12-03 23:14:58','2025-12-03 23:14:58',1),(88,'af899b37-e090-4bff-9023-a51a33041494','instance_uuid','13470d33-f1a6-4c46-9cb3-b2001975f77f','2025-12-03 23:14:52','2025-12-03 23:14:58','2025-12-03 23:14:58',1),(89,'af899b37-e090-4bff-9023-a51a33041494','user_id','2539b37a97c744c386a7fc680a4cd3a7','2025-12-03 23:14:52','2025-12-03 23:14:58','2025-12-03 23:14:58',1),(90,'af899b37-e090-4bff-9023-a51a33041494','image_type','snapshot','2025-12-03 23:14:52','2025-12-03 23:14:58','2025-12-03 23:14:58',1),(91,'af899b37-e090-4bff-9023-a51a33041494','image_state','available','2025-12-03 23:14:52','2025-12-03 23:14:58','2025-12-03 23:14:58',1),(92,'af899b37-e090-4bff-9023-a51a33041494','image_location','snapshot','2025-12-03 23:14:52','2025-12-03 23:14:58','2025-12-03 23:14:58',1),(93,'af899b37-e090-4bff-9023-a51a33041494','owner_id','5c73b76d928d4467989a8e2e395bb892','2025-12-03 23:14:52','2025-12-03 23:14:58','2025-12-03 23:14:58',1),(94,'af899b37-e090-4bff-9023-a51a33041494','version','8.0','2025-12-03 23:14:52','2025-12-03 23:14:58','2025-12-03 23:14:58',1),(95,'64807003-5484-4976-9026-4db6b9160977','hw_rng_model','virtio','2025-12-03 23:16:36','2025-12-03 23:17:55','2025-12-03 23:17:55',1),(96,'64807003-5484-4976-9026-4db6b9160977','base_image_ref','ee36e3bb-565a-439c-ab21-6b7f9eae8147','2025-12-03 23:16:36','2025-12-03 23:17:55','2025-12-03 23:17:55',1),(97,'64807003-5484-4976-9026-4db6b9160977','owner_user_name','tempest-TestStampPattern-1238213770-project-member','2025-12-03 23:16:36','2025-12-03 23:17:55','2025-12-03 23:17:55',1),(98,'64807003-5484-4976-9026-4db6b9160977','owner_project_name','tempest-TestStampPattern-1238213770','2025-12-03 23:16:36','2025-12-03 23:17:55','2025-12-03 23:17:55',1),(99,'64807003-5484-4976-9026-4db6b9160977','boot_roles','member,reader','2025-12-03 23:16:36','2025-12-03 23:17:55','2025-12-03 23:17:55',1),(100,'64807003-5484-4976-9026-4db6b9160977','hw_machine_type','q35','2025-12-03 23:16:36','2025-12-03 23:17:55','2025-12-03 23:17:55',1),(101,'64807003-5484-4976-9026-4db6b9160977','hw_cdrom_bus','sata','2025-12-03 23:16:36','2025-12-03 23:17:55','2025-12-03 23:17:55',1),(102,'64807003-5484-4976-9026-4db6b9160977','hw_disk_bus','virtio','2025-12-03 23:16:36','2025-12-03 23:17:55','2025-12-03 23:17:55',1),(103,'64807003-5484-4976-9026-4db6b9160977','hw_input_bus','usb','2025-12-03 23:16:36','2025-12-03 23:17:55','2025-12-03 23:17:55',1),(104,'64807003-5484-4976-9026-4db6b9160977','hw_pointer_model','usbtablet','2025-12-03 23:16:36','2025-12-03 23:17:55','2025-12-03 23:17:55',1),(105,'64807003-5484-4976-9026-4db6b9160977','hw_video_model','virtio','2025-12-03 23:16:36','2025-12-03 23:17:55','2025-12-03 23:17:55',1),(106,'64807003-5484-4976-9026-4db6b9160977','hw_vif_model','virtio','2025-12-03 23:16:36','2025-12-03 23:17:55','2025-12-03 23:17:55',1),(107,'64807003-5484-4976-9026-4db6b9160977','instance_uuid','4c946f71-cae9-432c-8fdf-94c38c282bb6','2025-12-03 23:16:36','2025-12-03 23:17:55','2025-12-03 23:17:55',1),(108,'64807003-5484-4976-9026-4db6b9160977','user_id','6c4a705892cc42cfbedfe3de1504c143','2025-12-03 23:16:36','2025-12-03 23:17:55','2025-12-03 23:17:55',1),(109,'64807003-5484-4976-9026-4db6b9160977','image_type','snapshot','2025-12-03 23:16:36','2025-12-03 23:17:55','2025-12-03 23:17:55',1),(110,'64807003-5484-4976-9026-4db6b9160977','image_state','available','2025-12-03 23:16:39','2025-12-03 23:17:55','2025-12-03 23:17:55',1),(111,'64807003-5484-4976-9026-4db6b9160977','image_location','snapshot','2025-12-03 23:16:39','2025-12-03 23:17:55','2025-12-03 23:17:55',1),(112,'64807003-5484-4976-9026-4db6b9160977','owner_id','0ebc213514c247388f90f7a4b0b39e1e','2025-12-03 23:16:39','2025-12-03 23:17:55','2025-12-03 23:17:55',1),(113,'b0785a14-41d8-4929-979f-8b742fefe2af','signature_verified','False','2025-12-03 23:35:41','2025-12-03 23:36:59','2025-12-03 23:36:59',1),(114,'b0785a14-41d8-4929-979f-8b742fefe2af','hw_rng_model','virtio','2025-12-03 23:35:41','2025-12-03 23:36:59','2025-12-03 23:36:59',1),(115,'b0785a14-41d8-4929-979f-8b742fefe2af','base_image_ref','','2025-12-03 23:35:41','2025-12-03 23:36:59','2025-12-03 23:36:59',1),(116,'b0785a14-41d8-4929-979f-8b742fefe2af','owner_user_name','tempest-TestVolumeBootPattern-787648750-project-member','2025-12-03 23:35:41','2025-12-03 23:36:59','2025-12-03 23:36:59',1),(117,'b0785a14-41d8-4929-979f-8b742fefe2af','owner_project_name','tempest-TestVolumeBootPattern-787648750','2025-12-03 23:35:41','2025-12-03 23:36:59','2025-12-03 23:36:59',1),(118,'b0785a14-41d8-4929-979f-8b742fefe2af','boot_roles','member,reader','2025-12-03 23:35:41','2025-12-03 23:36:59','2025-12-03 23:36:59',1),(119,'b0785a14-41d8-4929-979f-8b742fefe2af','hw_machine_type','q35','2025-12-03 23:35:41','2025-12-03 23:36:59','2025-12-03 23:36:59',1),(120,'b0785a14-41d8-4929-979f-8b742fefe2af','hw_cdrom_bus','sata','2025-12-03 23:35:41','2025-12-03 23:36:59','2025-12-03 23:36:59',1),(121,'b0785a14-41d8-4929-979f-8b742fefe2af','hw_disk_bus','virtio','2025-12-03 23:35:41','2025-12-03 23:36:59','2025-12-03 23:36:59',1),(122,'b0785a14-41d8-4929-979f-8b742fefe2af','hw_input_bus','usb','2025-12-03 23:35:41','2025-12-03 23:36:59','2025-12-03 23:36:59',1),(123,'b0785a14-41d8-4929-979f-8b742fefe2af','hw_pointer_model','usbtablet','2025-12-03 23:35:41','2025-12-03 23:36:59','2025-12-03 23:36:59',1),(124,'b0785a14-41d8-4929-979f-8b742fefe2af','hw_video_model','virtio','2025-12-03 23:35:41','2025-12-03 23:36:59','2025-12-03 23:36:59',1),(125,'b0785a14-41d8-4929-979f-8b742fefe2af','hw_vif_model','virtio','2025-12-03 23:35:41','2025-12-03 23:36:59','2025-12-03 23:36:59',1),(126,'b0785a14-41d8-4929-979f-8b742fefe2af','root_device_name','/dev/vda','2025-12-03 23:35:41','2025-12-03 23:36:59','2025-12-03 23:36:59',1),(127,'b0785a14-41d8-4929-979f-8b742fefe2af','block_device_mapping','[{\"volume_type\": null, \"disk_bus\": \"virtio\", \"volume_size\": 1, \"encryption_format\": null, \"tag\": null, \"device_name\": \"/dev/vda\", \"snapshot_id\": \"75c870e7-5a8e-4c57-b179-6b92a01989dd\", \"volume_id\": null, \"delete_on_termination\": true, \"encryption_secret_uuid\": null, \"guest_format\": null, \"no_device\": null, \"encrypted\": null, \"source_type\": \"snapshot\", \"device_type\": \"disk\", \"boot_index\": 0, \"destination_type\": \"volume\", \"image_id\": null, \"encryption_options\": null}]','2025-12-03 23:35:41','2025-12-03 23:36:59','2025-12-03 23:36:59',1),(128,'b0785a14-41d8-4929-979f-8b742fefe2af','bdm_v2','True','2025-12-03 23:35:41','2025-12-03 23:36:59','2025-12-03 23:36:59',1);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
INSERT INTO `image_tags` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'3b3f1220-89d7-42bc-a96b-ae5580cc46a7','amphora-image','2025-12-03 22:31:06','2025-12-03 22:31:06',NULL,0);
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('34ead15b-112d-4a73-ac5f-6e925a541488','tempest-signed_img--1340693239',21430272,'deleted','2025-12-03 22:54:43','2025-12-03 22:55:29','2025-12-03 22:55:29',1,'qcow2','bare','c8fc807773e5354afe61636071771906','81805fcc94854ba6997bebb34be6a5db',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('3b3f1220-89d7-42bc-a96b-ae5580cc46a7','octavia-amphora-x64-haproxy-centos-9-stream',530211328,'active','2025-12-03 22:31:06','2025-12-03 22:31:16',NULL,0,'qcow2','bare','67642eb5016064ccf4682c9791e66911','287bb4deac5947ca983293ae47928819',0,0,0,2147483648,'private',0,'sha512','0e07e55e1cea58c86339a163f6e063d977af7a3266b849af9a20728153d8f23caf2cf5c90733080da120a953c0fcf59b0a1a8da0871d1be8a8eecc3c13a06d55'),('3d15d465-24a7-444b-ae4c-142047d2c510','tempest-scenario-img--5369378',21430272,'deleted','2025-12-03 23:00:17','2025-12-03 23:01:44','2025-12-03 23:01:44',1,'qcow2','bare','c8fc807773e5354afe61636071771906','26d36ac1678744fabdbe8d702fccfb9d',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('56c42dba-2fe8-4be1-992b-e0b2958ad1ad','tempest-signed_img--205071832',21430272,'deleted','2025-12-03 22:54:11','2025-12-03 22:54:42','2025-12-03 22:54:42',1,'qcow2','bare','c8fc807773e5354afe61636071771906','81805fcc94854ba6997bebb34be6a5db',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('64807003-5484-4976-9026-4db6b9160977','tempest-TestStampPatternsnapshot-1431305839',52363264,'deleted','2025-12-03 23:16:36','2025-12-03 23:17:55','2025-12-03 23:17:55',1,'qcow2','bare','8c0fabcb1ba26e8f2fb9aac06747f183','0ebc213514c247388f90f7a4b0b39e1e',1,0,0,1073741824,'private',0,'sha512','0cda8ab92c10b259a6f401dce262391e32b737291eeef6a841b0eb43ed701daad9c550660e2d3f6bad6dcbce1669296d4faad049811b122bb6d1a404737fbba6'),('64d84e4c-a771-4dd9-83d4-929d5e4750e4','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2025-12-03 22:49:43','2025-12-03 22:49:44',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','ebdbc6bd6ac94fca9ac245c271bc304b',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('7e82cff5-ec49-4a1a-8c2b-84a3bb9860b6','tempest-TestSnapshotPatternsnapshot-1616974217',52297728,'deleted','2025-12-03 23:14:01','2025-12-03 23:15:02','2025-12-03 23:15:02',1,'qcow2','bare','2edb8b3b4c92a0f4edf48ef7dea94d20','5c73b76d928d4467989a8e2e395bb892',1,0,0,1073741824,'private',0,'sha512','442be502c763bc0dc9b561975989473b5fc3b0c2519a8c0162d185477453370278a3d646958576f1251e1c53a72c927d0556677b0fff25d5b8d61fbe235440b8'),('857ec267-2b05-455c-8ea3-ababb2d7c8f8','tempest-image-2109977672',1024,'deleted','2025-12-03 22:50:20','2025-12-03 22:50:25','2025-12-03 22:50:25',1,'qcow2','bare','38d355ff3f4789f43d1c39780119abc3','fe8c6cbf216f4d4c8759f06e4dfff2a6',0,0,0,NULL,'private',0,'sha512','ac183ae1c6f69dbfd3704f638fc01b8682f61f33102fb4de980bca956259f6792625ef4d59f3176c418654c75e4248dbff79c6ad9c4cad5b9baa71fee3c4b5df'),('8e19f9e0-6063-4e4e-979d-9fe728bbc894','tempest-new-image-1997741591',NULL,'deleted','2025-12-03 22:50:24','2025-12-03 22:50:24','2025-12-03 22:50:24',1,'qcow2','bare',NULL,'fe8c6cbf216f4d4c8759f06e4dfff2a6',0,0,0,NULL,'private',0,NULL,NULL),('938ddeea-e99a-4536-b866-8d3b39faaf0e','tempest-signed_img--1291667399',21430272,'deleted','2025-12-03 22:55:49','2025-12-03 22:56:18','2025-12-03 22:56:18',1,'qcow2','bare','c8fc807773e5354afe61636071771906','81805fcc94854ba6997bebb34be6a5db',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('9bffb0bd-23b7-428c-ab5c-8406f0d933e4','tempest-ImageSigningSnapshotTest-image-96857097',23330816,'deleted','2025-12-03 22:55:28','2025-12-03 22:55:41','2025-12-03 22:55:41',1,'qcow2','bare','8585e91edf8d37af388395b4946b59f4','50c6b4aa393644a6a1f79dc8daa3a531',1,0,0,1073741824,'private',0,'sha512','0cd6d4fd90baef1f0427abe5d55fcacb637c2164bbec76316ced74ff8e7e77a44677d4d45615f28ead8b2acf44f37960d1d6689f9639b834b9745ff4b35749a4'),('af899b37-e090-4bff-9023-a51a33041494','tempest-TestSnapshotPatternsnapshot-439713168',52494336,'deleted','2025-12-03 23:14:52','2025-12-03 23:14:58','2025-12-03 23:14:58',1,'qcow2','bare','7b7925f98e1c321bc7cf2c4c068d9b98','5c73b76d928d4467989a8e2e395bb892',1,0,0,1073741824,'private',0,'sha512','09f17ade36d464154d18aef7fa07202225f7081964591f5a1d0ac618f576cdfc93cec466897f2a667e8e22195c0a6f63a23ba6a442c5831ce04dadd310d9ff1b'),('b0785a14-41d8-4929-979f-8b742fefe2af','tempest-TestVolumeBootPatternsnapshot-237575455',0,'deleted','2025-12-03 23:35:41','2025-12-03 23:36:59','2025-12-03 23:36:59',1,'qcow2','bare','d41d8cd98f00b204e9800998ecf8427e','17135a905ddc412883361a7397e2e39c',1,0,0,NULL,'private',0,'sha512','cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e'),('bcbe4ee5-57b5-4dd7-a5e7-aabe4c13e7b8','tempest-signed_img--406734506',21430272,'deleted','2025-12-03 22:55:30','2025-12-03 22:56:20','2025-12-03 22:56:20',1,'qcow2','bare','c8fc807773e5354afe61636071771906','81805fcc94854ba6997bebb34be6a5db',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('c7d2ce17-d12a-4196-967d-ddd1e0938a61','tempest-signed_img--1620303424',21430272,'deleted','2025-12-03 22:54:41','2025-12-03 22:55:17','2025-12-03 22:55:17',1,'qcow2','bare','c8fc807773e5354afe61636071771906','cf9cba8c32de4120b657757dd4d6cccf',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('d3a4f7fe-8a5b-4567-9751-8422a9174a00','tempest-signed_img--74063865',21430272,'deleted','2025-12-03 22:55:05','2025-12-03 22:55:40','2025-12-03 22:55:40',1,'qcow2','bare','c8fc807773e5354afe61636071771906','50c6b4aa393644a6a1f79dc8daa3a531',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('ddffe08f-a470-4099-b6c7-c781cd538208','tempest-signed_img--1454037526',21430272,'deleted','2025-12-03 22:54:54','2025-12-03 22:55:57','2025-12-03 22:55:57',1,'qcow2','bare','c8fc807773e5354afe61636071771906','dbb2710d867347c5b4a3eeb47ef0e6a0',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('e1643bf9-aac5-4617-acf9-5d5f6fce756f','tempest-image-864768086',NULL,'deleted','2025-12-03 22:50:19','2025-12-03 22:50:19','2025-12-03 22:50:19',1,'qcow2','bare',NULL,'fe8c6cbf216f4d4c8759f06e4dfff2a6',0,0,0,NULL,'private',0,NULL,NULL),('e8b8bf25-5654-4234-bc6e-542bce0407e3','tempest-signed_img--1172955989',21430272,'deleted','2025-12-03 22:55:58','2025-12-03 22:56:55','2025-12-03 22:56:55',1,'qcow2','bare','c8fc807773e5354afe61636071771906','dbb2710d867347c5b4a3eeb47ef0e6a0',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('ee36e3bb-565a-439c-ab21-6b7f9eae8147','cirros-0.6.2-x86_64-disk.img',21430272,'active','2025-12-03 22:49:41','2025-12-03 22:49:43',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','ebdbc6bd6ac94fca9ac245c271bc304b',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('f5f318a8-625b-47ae-a88d-c5c5b1677ba4','tempest-scenario-img--1134632033',21430272,'deleted','2025-12-03 22:58:36','2025-12-03 23:00:17','2025-12-03 23:00:17',1,'qcow2','bare','c8fc807773e5354afe61636071771906','26d36ac1678744fabdbe8d702fccfb9d',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b');
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2025-12-03 22:24:27',NULL),(1,2,'image','CIM_RASD_','2025-12-03 22:24:27',NULL),(1,3,NULL,'CIM_SASD_','2025-12-03 22:24:27',NULL),(1,9,'image','hw_','2025-12-03 22:24:29',NULL),(1,10,'image','hw_','2025-12-03 22:24:30',NULL),(1,14,'image',NULL,'2025-12-03 22:24:31',NULL),(1,19,'image','hw_','2025-12-03 22:24:32',NULL),(1,25,'image','hw_','2025-12-03 22:24:33',NULL),(1,29,'image',NULL,'2025-12-03 22:24:33',NULL),(1,30,'image',NULL,'2025-12-03 22:24:33',NULL),(1,31,'image',NULL,'2025-12-03 22:24:33',NULL),(1,32,'image',NULL,'2025-12-03 22:24:33',NULL),(2,1,NULL,'CIM_PASD_','2025-12-03 22:24:27',NULL),(2,8,NULL,'hw_','2025-12-03 22:24:29',NULL),(2,9,NULL,'hw_','2025-12-03 22:24:29',NULL),(2,10,NULL,'hw_','2025-12-03 22:24:30',NULL),(2,11,NULL,NULL,'2025-12-03 22:24:30',NULL),(2,13,NULL,NULL,'2025-12-03 22:24:31',NULL),(2,14,NULL,NULL,'2025-12-03 22:24:31',NULL),(2,15,NULL,NULL,'2025-12-03 22:24:31',NULL),(2,16,NULL,'hw_','2025-12-03 22:24:31',NULL),(2,19,NULL,'hw_','2025-12-03 22:24:32',NULL),(2,22,NULL,NULL,'2025-12-03 22:24:32',NULL),(2,23,NULL,'hw_','2025-12-03 22:24:32',NULL),(2,24,NULL,'traits:','2025-12-03 22:24:32',NULL),(2,25,NULL,'hw_','2025-12-03 22:24:33',NULL),(2,26,NULL,NULL,'2025-12-03 22:24:33',NULL),(2,28,NULL,NULL,'2025-12-03 22:24:33',NULL),(2,29,NULL,NULL,'2025-12-03 22:24:33',NULL),(2,30,NULL,NULL,'2025-12-03 22:24:33',NULL),(2,31,NULL,NULL,'2025-12-03 22:24:33',NULL),(2,32,NULL,NULL,'2025-12-03 22:24:33',NULL),(2,33,NULL,'cinder_','2025-12-03 22:24:33',NULL),(3,1,NULL,'CIM_PASD_','2025-12-03 22:24:27',NULL),(3,2,NULL,'CIM_RASD_','2025-12-03 22:24:27',NULL),(3,3,NULL,'CIM_SASD_','2025-12-03 22:24:27',NULL),(3,4,NULL,'CIM_VSSD_','2025-12-03 22:24:28',NULL),(3,5,NULL,NULL,'2025-12-03 22:24:28',NULL),(3,6,NULL,NULL,'2025-12-03 22:24:28',NULL),(3,7,NULL,NULL,'2025-12-03 22:24:29',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2025-12-03 22:24:30',NULL),(4,1,NULL,'CIM_PASD_','2025-12-03 22:24:27',NULL),(4,2,NULL,'CIM_RASD_','2025-12-03 22:24:27',NULL),(4,3,NULL,'CIM_SASD_','2025-12-03 22:24:27',NULL),(4,4,NULL,'CIM_VSSD_','2025-12-03 22:24:28',NULL),(4,8,NULL,'hw:','2025-12-03 22:24:29',NULL),(4,9,NULL,'hw:','2025-12-03 22:24:29',NULL),(4,10,NULL,'hw:','2025-12-03 22:24:29',NULL),(4,12,NULL,'capabilities:','2025-12-03 22:24:30',NULL),(4,16,NULL,'hw:','2025-12-03 22:24:31',NULL),(4,17,NULL,NULL,'2025-12-03 22:24:31',NULL),(4,18,NULL,NULL,'2025-12-03 22:24:31',NULL),(4,19,NULL,'hw:','2025-12-03 22:24:32',NULL),(4,20,NULL,NULL,'2025-12-03 22:24:32',NULL),(4,21,NULL,NULL,'2025-12-03 22:24:32',NULL),(4,23,NULL,'hw:','2025-12-03 22:24:32',NULL),(4,24,NULL,'traits:','2025-12-03 22:24:32',NULL),(4,25,NULL,'hw:','2025-12-03 22:24:33',NULL),(5,1,'scheduler_hints',NULL,'2025-12-03 22:24:27',NULL),(5,30,'metadata',NULL,'2025-12-03 22:24:33',NULL),(5,31,'metadata',NULL,'2025-12-03 22:24:33',NULL),(5,32,'metadata',NULL,'2025-12-03 22:24:33',NULL),(6,30,NULL,NULL,'2025-12-03 22:24:33',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2025-12-03 22:24:27',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2025-12-03 22:24:27',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2025-12-03 22:24:27',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2025-12-03 22:24:28',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-12-03 22:24:28',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-12-03 22:24:28',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2025-12-03 22:24:29',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2025-12-03 22:24:29',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2025-12-03 22:24:29',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2025-12-03 22:24:29',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2025-12-03 22:24:30',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2025-12-03 22:24:30',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2025-12-03 22:24:31',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2025-12-03 22:24:31',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-03 22:24:31',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-03 22:24:31',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-03 22:24:31',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2025-12-03 22:24:31',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2025-12-03 22:24:32',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-03 22:24:32',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-03 22:24:32',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-03 22:24:32',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2025-12-03 22:24:32',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2025-12-03 22:24:32',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-03 22:24:33',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-03 22:24:33',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2025-12-03 22:24:33',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2025-12-03 22:24:33',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2025-12-03 22:24:33',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2025-12-03 22:24:33',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2025-12-03 22:24:33',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2025-12-03 22:24:33',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2025-12-03 22:24:33',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2025-12-03 22:24:31',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2025-12-03 22:24:31',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2025-12-03 22:24:31',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2025-12-03 22:24:33',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2025-12-03 22:24:33',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2025-12-03 22:24:33',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2025-12-03 22:24:33',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-12-03 22:24:33',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-12-03 22:24:33',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-12-03 22:24:33',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-12-03 22:24:33',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-12-03 22:24:33',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2025-12-03 22:24:33',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2025-12-03 22:24:33',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2025-12-03 22:24:33',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2025-12-03 22:24:33',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2025-12-03 22:24:33',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2025-12-03 22:24:33',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2025-12-03 22:24:33',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2025-12-03 22:24:33',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-12-03 22:24:33',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-12-03 22:24:33',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-12-03 22:24:33',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2025-12-03 22:24:27',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2025-12-03 22:24:27',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2025-12-03 22:24:27',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2025-12-03 22:24:27',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2025-12-03 22:24:27',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2025-12-03 22:24:27',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2025-12-03 22:24:27',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2025-12-03 22:24:27',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-12-03 22:24:27',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2025-12-03 22:24:27',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2025-12-03 22:24:27',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2025-12-03 22:24:27',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2025-12-03 22:24:27',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2025-12-03 22:24:27',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2025-12-03 22:24:27',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2025-12-03 22:24:27',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-12-03 22:24:27',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2025-12-03 22:24:27',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-12-03 22:24:27',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2025-12-03 22:24:27',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2025-12-03 22:24:27',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2025-12-03 22:24:27',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2025-12-03 22:24:27',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2025-12-03 22:24:28',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2025-12-03 22:24:28',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2025-12-03 22:24:28',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2025-12-03 22:24:28',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-12-03 22:24:28',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-12-03 22:24:28',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2025-12-03 22:24:28',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2025-12-03 22:24:28',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-12-03 22:24:28',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2025-12-03 22:24:28',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-12-03 22:24:28',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-12-03 22:24:28',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2025-12-03 22:24:28',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2025-12-03 22:24:28',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2025-12-03 22:24:28',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2025-12-03 22:24:28',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2025-12-03 22:24:28',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-12-03 22:24:28',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-12-03 22:24:28',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2025-12-03 22:24:28',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2025-12-03 22:24:28',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2025-12-03 22:24:28',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2025-12-03 22:24:28',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2025-12-03 22:24:28',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2025-12-03 22:24:28',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2025-12-03 22:24:28',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2025-12-03 22:24:28',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2025-12-03 22:24:28',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2025-12-03 22:24:28',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2025-12-03 22:24:28',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2025-12-03 22:24:28',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2025-12-03 22:24:29',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2025-12-03 22:24:29',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2025-12-03 22:24:29',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2025-12-03 22:24:29',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2025-12-03 22:24:30',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-03 22:24:30',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2025-12-03 22:24:30',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2025-12-03 22:24:30',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2025-12-03 22:24:30',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-12-03 22:24:31',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-12-03 22:24:31',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-12-03 22:24:31',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2025-12-03 22:24:31',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2025-12-03 22:24:31',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2025-12-03 22:24:31',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2025-12-03 22:24:31',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-12-03 22:24:31',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-12-03 22:24:31',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-12-03 22:24:31',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2025-12-03 22:24:31',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2025-12-03 22:24:31',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2025-12-03 22:24:31',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2025-12-03 22:24:31',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2025-12-03 22:24:31',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-03 22:24:31',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2025-12-03 22:24:31',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2025-12-03 22:24:31',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2025-12-03 22:24:31',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-03 22:24:31',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-03 22:24:31',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-12-03 22:24:31',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2025-12-03 22:24:31',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-12-03 22:24:31',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-03 22:24:31',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-03 22:24:31',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-03 22:24:31',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2025-12-03 22:24:32',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2025-12-03 22:24:32',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2025-12-03 22:24:32',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-12-03 22:24:32',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-12-03 22:24:32',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-12-03 22:24:32',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-12-03 22:24:32',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-12-03 22:24:32',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-12-03 22:24:32',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2025-12-03 22:24:32',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2025-12-03 22:24:32',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-03 22:24:32',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-03 22:24:32',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2025-12-03 22:24:32',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2025-12-03 22:24:32',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2025-12-03 22:24:32',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2025-12-03 22:24:32',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2025-12-03 22:24:32',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-03 22:24:32',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2025-12-03 22:24:32',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-12-03 22:24:32',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-12-03 22:24:33',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2025-12-03 22:24:33',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2025-12-03 22:24:33',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2025-12-03 22:24:33',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2025-12-03 22:24:33',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2025-12-03 22:24:33',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2025-12-03 22:24:33',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-12-03 22:24:33',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2025-12-03 22:24:33',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-12-03 22:24:33',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2025-12-03 22:24:33',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2025-12-03 22:24:33',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2025-12-03 22:24:33',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2025-12-03 22:24:33',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2025-12-03 22:24:33',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2025-12-03 22:24:33',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2025-12-03 22:24:33',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-12-03 22:24:33',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-12-03 22:24:33',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2025-12-03 22:24:33',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2025-12-03 22:24:33',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2025-12-03 22:24:27',NULL),(2,'OS::Glance::Image',1,'2025-12-03 22:24:27',NULL),(3,'OS::Nova::Aggregate',1,'2025-12-03 22:24:27',NULL),(4,'OS::Nova::Flavor',1,'2025-12-03 22:24:27',NULL),(5,'OS::Nova::Server',1,'2025-12-03 22:24:27',NULL),(6,'OS::Trove::Instance',1,'2025-12-03 22:24:33',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
INSERT INTO `task_info` (`task_id`, `input`, `result`, `message`) VALUES ('db6dae59-d3e3-4d0c-a52e-1f79b87a8c21','{\"image_id\": \"3b3f1220-89d7-42bc-a96b-ae5580cc46a7\", \"import_req\": {\"method\": {\"name\": \"web-download\", \"uri\": \"http://octavia-image-upload-internal.openstack.svc:80/octavia-amphora-x64-haproxy-centos-9-stream.qcow2\"}}, \"backend\": [\"default_backend\"]}','{\"image_id\": \"3b3f1220-89d7-42bc-a96b-ae5580cc46a7\"}','Copied 505 MiB');
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
INSERT INTO `tasks` (`id`, `type`, `status`, `owner`, `expires_at`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `image_id`, `request_id`, `user_id`) VALUES ('db6dae59-d3e3-4d0c-a52e-1f79b87a8c21','api_image_import','success','287bb4deac5947ca983293ae47928819','2025-12-05 22:31:16','2025-12-03 22:31:06','2025-12-03 22:31:16',NULL,0,'3b3f1220-89d7-42bc-a96b-ae5580cc46a7','req-69d07949-6328-43f4-83d0-916d1e85329b','8c3aef96126f47b49d7cf9954a203662');
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `heat`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `heat` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `heat`;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `resource_action` varchar(255) DEFAULT NULL,
  `resource_status` varchar(255) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `physical_resource_id` varchar(255) DEFAULT NULL,
  `resource_status_reason` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_properties` blob DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `ev_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  CONSTRAINT `ev_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `event_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event`
--

LOCK TABLES `event` WRITE;
/*!40000 ALTER TABLE `event` DISABLE KEYS */;
/*!40000 ALTER TABLE `event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('heat','/usr/lib/python3.9/site-packages/heat/db/sqlalchemy/migrate_repo',86);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template`
--

DROP TABLE IF EXISTS `raw_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `template` longtext DEFAULT NULL,
  `files` longtext DEFAULT NULL,
  `environment` longtext DEFAULT NULL,
  `files_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_tmpl_files_fkey_ref` (`files_id`),
  CONSTRAINT `raw_tmpl_files_fkey_ref` FOREIGN KEY (`files_id`) REFERENCES `raw_template_files` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template`
--

LOCK TABLES `raw_template` WRITE;
/*!40000 ALTER TABLE `raw_template` DISABLE KEYS */;
/*!40000 ALTER TABLE `raw_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template_files`
--

DROP TABLE IF EXISTS `raw_template_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `files` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template_files`
--

LOCK TABLES `raw_template_files` WRITE;
/*!40000 ALTER TABLE `raw_template_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `raw_template_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource`
--

DROP TABLE IF EXISTS `resource`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `nova_instance` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `rsrc_metadata` longtext DEFAULT NULL,
  `properties_data` longtext DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  `atomic_key` int(11) DEFAULT NULL,
  `needed_by` longtext DEFAULT NULL,
  `requires` longtext DEFAULT NULL,
  `replaces` int(11) DEFAULT NULL,
  `replaced_by` int(11) DEFAULT NULL,
  `current_template_id` int(11) DEFAULT NULL,
  `properties_data_encrypted` tinyint(1) DEFAULT NULL,
  `root_stack_id` varchar(36) DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  `attr_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `current_template_id` (`current_template_id`),
  KEY `ix_resource_root_stack_id` (`root_stack_id`),
  KEY `rsrc_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  KEY `rsrc_attr_data_ref` (`attr_data_id`),
  CONSTRAINT `resource_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`),
  CONSTRAINT `resource_ibfk_2` FOREIGN KEY (`current_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `rsrc_attr_data_ref` FOREIGN KEY (`attr_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `rsrc_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource`
--

LOCK TABLES `resource` WRITE;
/*!40000 ALTER TABLE `resource` DISABLE KEYS */;
/*!40000 ALTER TABLE `resource` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_data`
--

DROP TABLE IF EXISTS `resource_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  `redact` tinyint(1) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `resource_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_resource_id` (`resource_id`),
  CONSTRAINT `fk_resource_id` FOREIGN KEY (`resource_id`) REFERENCES `resource` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_data`
--

LOCK TABLES `resource_data` WRITE;
/*!40000 ALTER TABLE `resource_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `resource_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_properties_data`
--

DROP TABLE IF EXISTS `resource_properties_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_properties_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `data` longtext DEFAULT NULL,
  `encrypted` tinyint(1) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_properties_data`
--

LOCK TABLES `resource_properties_data` WRITE;
/*!40000 ALTER TABLE `resource_properties_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `resource_properties_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(36) NOT NULL,
  `engine_id` varchar(36) NOT NULL,
  `host` varchar(255) NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `topic` varchar(255) NOT NULL,
  `report_interval` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `engine_id`, `host`, `hostname`, `binary`, `topic`, `report_interval`, `created_at`, `updated_at`, `deleted_at`) VALUES ('19fa571e-1022-4c41-88ac-92c9300e66a3','30b8c6fa-5834-4936-832b-2ac171e3fa0f','heat-engine-5cd76d4c4c-pwkqf','heat-engine-5cd76d4c4c-pwkqf','heat-engine','engine',60,'2025-12-03 22:26:30','2025-12-03 22:27:05','2025-12-03 22:27:05'),('2d4271aa-2dbd-4632-95d8-8f97228dc56e','40a283ac-df25-4c5e-9387-0244d4efea02','heat-engine-6bbd7fd869-fccfd','heat-engine-6bbd7fd869-fccfd','heat-engine','engine',60,'2025-12-03 22:26:41','2025-12-03 23:45:42',NULL),('30f1fe0c-c9b5-4918-8c3c-8c0d2f1ab342','309b71e8-3bda-4e3d-bd08-bd0f571a305d','heat-engine-6bbd7fd869-fccfd','heat-engine-6bbd7fd869-fccfd','heat-engine','engine',60,'2025-12-03 22:26:41','2025-12-03 23:45:42',NULL),('319521e2-4c3e-4017-9866-3b14981fd36e','0021e976-04b7-488a-a6d7-4b911e2ee0fc','heat-engine-5cd76d4c4c-pwkqf','heat-engine-5cd76d4c4c-pwkqf','heat-engine','engine',60,'2025-12-03 22:26:30','2025-12-03 22:27:05','2025-12-03 22:27:05'),('48b9c408-74b1-43db-8681-2a844282cfe0','9e6dca4f-8cb1-4f27-8569-597c3f45a5a2','heat-engine-5cd76d4c4c-pwkqf','heat-engine-5cd76d4c4c-pwkqf','heat-engine','engine',60,'2025-12-03 22:26:30','2025-12-03 22:27:05','2025-12-03 22:27:05'),('c1bd6964-bcea-49f2-86cf-3545ba3db2c9','9e26cb69-1fb5-4aad-9282-2712dd446581','heat-engine-6bbd7fd869-fccfd','heat-engine-6bbd7fd869-fccfd','heat-engine','engine',60,'2025-12-03 22:26:41','2025-12-03 23:45:42',NULL),('f94682c9-b6b9-43bb-abc2-d1f667d2e3ed','88fcfc9f-ed13-4a5e-9dd6-aca62090e949','heat-engine-6bbd7fd869-fccfd','heat-engine-6bbd7fd869-fccfd','heat-engine','engine',60,'2025-12-03 22:26:41','2025-12-03 23:45:42',NULL),('fbcc2113-8109-4c4c-934e-f244066c3366','0323e32e-9109-449f-9638-865b490a034f','heat-engine-5cd76d4c4c-pwkqf','heat-engine-5cd76d4c4c-pwkqf','heat-engine','engine',60,'2025-12-03 22:26:30','2025-12-03 22:27:05','2025-12-03 22:27:05');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot`
--

DROP TABLE IF EXISTS `snapshot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot` (
  `id` varchar(36) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` varchar(255) DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  KEY `ix_snapshot_tenant` (`tenant`),
  CONSTRAINT `snapshot_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot`
--

LOCK TABLES `snapshot` WRITE;
/*!40000 ALTER TABLE `snapshot` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_config`
--

DROP TABLE IF EXISTS `software_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_config` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `group` varchar(255) DEFAULT NULL,
  `config` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_software_config_tenant` (`tenant`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_config`
--

LOCK TABLES `software_config` WRITE;
/*!40000 ALTER TABLE `software_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `software_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_deployment`
--

DROP TABLE IF EXISTS `software_deployment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_deployment` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `server_id` varchar(36) NOT NULL,
  `config_id` varchar(36) NOT NULL,
  `input_values` longtext DEFAULT NULL,
  `output_values` longtext DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `config_id` (`config_id`),
  KEY `ix_software_deployment_server_id` (`server_id`),
  KEY `ix_software_deployment_created_at` (`created_at`),
  KEY `ix_software_deployment_tenant` (`tenant`),
  CONSTRAINT `software_deployment_ibfk_1` FOREIGN KEY (`config_id`) REFERENCES `software_config` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_deployment`
--

LOCK TABLES `software_deployment` WRITE;
/*!40000 ALTER TABLE `software_deployment` DISABLE KEYS */;
/*!40000 ALTER TABLE `software_deployment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack`
--

DROP TABLE IF EXISTS `stack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `raw_template_id` int(11) NOT NULL,
  `prev_raw_template_id` int(11) DEFAULT NULL,
  `user_creds_id` int(11) DEFAULT NULL,
  `username` varchar(256) DEFAULT NULL,
  `owner_id` varchar(36) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `timeout` int(11) DEFAULT NULL,
  `tenant` varchar(256) DEFAULT NULL,
  `disable_rollback` tinyint(1) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  `backup` tinyint(1) DEFAULT NULL,
  `nested_depth` int(11) DEFAULT NULL,
  `convergence` tinyint(1) DEFAULT NULL,
  `current_traversal` varchar(36) DEFAULT NULL,
  `current_deps` longtext DEFAULT NULL,
  `parent_resource_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_template_id` (`raw_template_id`),
  KEY `prev_raw_template_id` (`prev_raw_template_id`),
  KEY `user_creds_id` (`user_creds_id`),
  KEY `ix_stack_tenant` (`tenant`(255)),
  KEY `ix_stack_owner_id` (`owner_id`),
  KEY `ix_stack_name` (`name`),
  CONSTRAINT `stack_ibfk_1` FOREIGN KEY (`raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_2` FOREIGN KEY (`prev_raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_3` FOREIGN KEY (`user_creds_id`) REFERENCES `user_creds` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack`
--

LOCK TABLES `stack` WRITE;
/*!40000 ALTER TABLE `stack` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_lock`
--

DROP TABLE IF EXISTS `stack_lock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_lock` (
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`stack_id`),
  CONSTRAINT `stack_lock_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_lock`
--

LOCK TABLES `stack_lock` WRITE;
/*!40000 ALTER TABLE `stack_lock` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack_lock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_tag`
--

DROP TABLE IF EXISTS `stack_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `tag` varchar(80) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  CONSTRAINT `stack_tag_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_tag`
--

LOCK TABLES `stack_tag` WRITE;
/*!40000 ALTER TABLE `stack_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_point`
--

DROP TABLE IF EXISTS `sync_point`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sync_point` (
  `entity_id` varchar(36) NOT NULL,
  `traversal_id` varchar(36) NOT NULL,
  `is_update` tinyint(1) NOT NULL,
  `atomic_key` int(11) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `input_data` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`traversal_id`,`is_update`),
  KEY `fk_stack_id` (`stack_id`),
  CONSTRAINT `fk_stack_id` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_point`
--

LOCK TABLES `sync_point` WRITE;
/*!40000 ALTER TABLE `sync_point` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_point` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_creds`
--

DROP TABLE IF EXISTS `user_creds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_creds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `region_name` varchar(255) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `tenant` varchar(1024) DEFAULT NULL,
  `auth_url` text DEFAULT NULL,
  `tenant_id` varchar(256) DEFAULT NULL,
  `trust_id` varchar(255) DEFAULT NULL,
  `trustor_user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_creds`
--

LOCK TABLES `user_creds` WRITE;
/*!40000 ALTER TABLE `user_creds` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_creds` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `user_id` (`user_id`),
  KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','43adc31c21d345b8ac08a01f5aa08929','287bb4deac5947ca983293ae47928819','563c6312ce444f79b731961a5e9dbc18',0),('UserProject','43adc31c21d345b8ac08a01f5aa08929','287bb4deac5947ca983293ae47928819','8325bacc3d764ab7b6beb4b9ddfc92d3',0),('UserProject','50ec2e8535db48c39e3558cb0dfee35c','287bb4deac5947ca983293ae47928819','563c6312ce444f79b731961a5e9dbc18',0),('UserProject','50ec2e8535db48c39e3558cb0dfee35c','287bb4deac5947ca983293ae47928819','8325bacc3d764ab7b6beb4b9ddfc92d3',0),('UserProject','5f5dc25cf83a47a0817c768e7601bb22','287bb4deac5947ca983293ae47928819','563c6312ce444f79b731961a5e9dbc18',0),('UserProject','5f5dc25cf83a47a0817c768e7601bb22','287bb4deac5947ca983293ae47928819','8325bacc3d764ab7b6beb4b9ddfc92d3',0),('UserProject','6301cba904174eca840f9d74c4ce7273','287bb4deac5947ca983293ae47928819','462e02cc92ba4a129f55a5872ac64386',0),('UserProject','6301cba904174eca840f9d74c4ce7273','287bb4deac5947ca983293ae47928819','563c6312ce444f79b731961a5e9dbc18',0),('UserProject','6301cba904174eca840f9d74c4ce7273','287bb4deac5947ca983293ae47928819','8325bacc3d764ab7b6beb4b9ddfc92d3',0),('UserProject','6ff04a48fc27407182d63a1211f2359d','287bb4deac5947ca983293ae47928819','563c6312ce444f79b731961a5e9dbc18',0),('UserProject','6ff04a48fc27407182d63a1211f2359d','287bb4deac5947ca983293ae47928819','8325bacc3d764ab7b6beb4b9ddfc92d3',0),('UserProject','8c3aef96126f47b49d7cf9954a203662','287bb4deac5947ca983293ae47928819','563c6312ce444f79b731961a5e9dbc18',0),('UserProject','8c3aef96126f47b49d7cf9954a203662','287bb4deac5947ca983293ae47928819','8325bacc3d764ab7b6beb4b9ddfc92d3',0),('UserProject','ab0f36b1258c48a29c07f01889f62554','287bb4deac5947ca983293ae47928819','563c6312ce444f79b731961a5e9dbc18',0),('UserProject','ab0f36b1258c48a29c07f01889f62554','287bb4deac5947ca983293ae47928819','8325bacc3d764ab7b6beb4b9ddfc92d3',0),('UserProject','af7abaab325e41e7a00f222909ab37f2','287bb4deac5947ca983293ae47928819','563c6312ce444f79b731961a5e9dbc18',0),('UserProject','af7abaab325e41e7a00f222909ab37f2','287bb4deac5947ca983293ae47928819','8325bacc3d764ab7b6beb4b9ddfc92d3',0),('UserProject','c2d6654e7a9b4e46b16813084bc5ab94','287bb4deac5947ca983293ae47928819','563c6312ce444f79b731961a5e9dbc18',0),('UserProject','c2d6654e7a9b4e46b16813084bc5ab94','287bb4deac5947ca983293ae47928819','8325bacc3d764ab7b6beb4b9ddfc92d3',0),('UserProject','d13984bf328f459bb9809cc7ce6d5742','287bb4deac5947ca983293ae47928819','563c6312ce444f79b731961a5e9dbc18',0),('UserProject','d13984bf328f459bb9809cc7ce6d5742','287bb4deac5947ca983293ae47928819','8325bacc3d764ab7b6beb4b9ddfc92d3',0),('UserProject','d87ba3f0156c4497bd935576d0e8f8cd','86b65474d4544ed68efb10a9bb276b2d','c31e33e5de1c492b88b1cf7e89a2a5bd',0),('UserProject','f02d735f9c704b2e8bde78ca5e15c788','86b65474d4544ed68efb10a9bb276b2d','563c6312ce444f79b731961a5e9dbc18',0),('UserProject','f02d735f9c704b2e8bde78ca5e15c788','ebdbc6bd6ac94fca9ac245c271bc304b','563c6312ce444f79b731961a5e9dbc18',0),('UserProject','ff9e7238d29c4bf1b4d67a95d8aa4dc7','287bb4deac5947ca983293ae47928819','563c6312ce444f79b731961a5e9dbc18',0),('UserProject','ff9e7238d29c4bf1b4d67a95d8aa4dc7','287bb4deac5947ca983293ae47928819','8325bacc3d764ab7b6beb4b9ddfc92d3',0),('UserDomain','d9876f1f4419445ca56487301512b1e1','964cab5a794342a6a87fe6400d740537','563c6312ce444f79b731961a5e9dbc18',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('09dc6f3ea68149da97c784e5c20e5561',NULL,'public','7c566ab40f4d496e97cf50d499920501','https://glance-default-public-openstack.apps.sno.openstack.lab','{\"name\": \"glance\"}',1,'regionOne'),('0a49c4d824f84169a0f45392b703e218',NULL,'public','a94bf68096db44e8b9245fe26cce0817','https://placement-public-openstack.apps.sno.openstack.lab','{\"name\": \"placement\"}',1,'regionOne'),('0c1b82255c2941b5b609aa11703220e3',NULL,'internal','a94bf68096db44e8b9245fe26cce0817','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('1444fdb4aa9b4dd1b467a8884cffa9b5',NULL,'internal','3ad63fded6894b7c9327af339287ef45','https://heat-api-internal.openstack.svc:8004/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('16f647ccf28540c3b365ed2e9c8b1f8e',NULL,'internal','4278e8473bd64ac79f334c1dacd9ead3','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('1b45b2abe7cf425e8dc29937a98ab7d2',NULL,'public','f0ac45ef0214449c9dcc7f31f4351258','https://swift-public-openstack.apps.sno.openstack.lab/v1/AUTH_%(tenant_id)s','{\"name\": \"swift\"}',1,'regionOne'),('2453c8f63bbd4a2998bd4206691a586c',NULL,'internal','a82c87bcf12a4d7093f90e4096aa7f19','https://heat-cfnapi-internal.openstack.svc:8000/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('3f4cde37795941d6ba5e893fefed7b7d',NULL,'internal','61717597aaaa4c91b908676809a28d04','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('4a82947ee4e9429ba1d6d373f6ce3ac0',NULL,'internal','7c566ab40f4d496e97cf50d499920501','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('5437a93fd5444a6c97b62c0679c32c0e',NULL,'public','cda58a89c81845c9b843f99ed550c705','https://octavia-public-openstack.apps.sno.openstack.lab','{\"name\": \"octavia\"}',1,'regionOne'),('5a22873dbfb0443e96d052f9046a3cfe',NULL,'internal','d2687e3bec014b8fa344c2a6a1757fcb','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('6aab933539f74f1e8a05db579cfe978d',NULL,'public','b007b645f9044c4ba892f6e4a1f0faf5','https://aodh-public-openstack.apps.sno.openstack.lab','{\"name\": \"aodh\"}',1,'regionOne'),('6c89206ecaa14efc80347a8cc99aef7d',NULL,'public','3ad63fded6894b7c9327af339287ef45','https://heat-api-public-openstack.apps.sno.openstack.lab/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('87a81391aecf42bfa3fb308db2df1a42',NULL,'public','752915ad7e4b4cfd847af0fda281f62b','https://barbican-public-openstack.apps.sno.openstack.lab','{\"name\": \"barbican\"}',1,'regionOne'),('88f9262c932145c1bc6c6a4945dc50d6',NULL,'public','61717597aaaa4c91b908676809a28d04','https://cinder-public-openstack.apps.sno.openstack.lab/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('8a97f673661f4823b40f8afabfedd8e4',NULL,'public','4278e8473bd64ac79f334c1dacd9ead3','https://nova-public-openstack.apps.sno.openstack.lab/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('8eae09e423d04fa19680d5a25b57bb6a',NULL,'public','d2687e3bec014b8fa344c2a6a1757fcb','https://keystone-public-openstack.apps.sno.openstack.lab','{}',1,'regionOne'),('c1ec27b754514590baa9ae4c6ad4b3b1',NULL,'public','5fa748def03844f5a69f72b7a588f5f1','https://neutron-public-openstack.apps.sno.openstack.lab','{\"name\": \"neutron\"}',1,'regionOne'),('c794d8185d1046d3a7de06e905c70b96',NULL,'internal','5fa748def03844f5a69f72b7a588f5f1','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('cb8969d632a74d1cad5d0aca9308ba3c',NULL,'internal','cda58a89c81845c9b843f99ed550c705','https://octavia-internal.openstack.svc:9876','{\"name\": \"octavia\"}',1,'regionOne'),('d4bf4f00d9dd4103aae1b042210fea3a',NULL,'public','a82c87bcf12a4d7093f90e4096aa7f19','https://heat-cfnapi-public-openstack.apps.sno.openstack.lab/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('d79e62c54e1b41e99e164ca8d234c6ff',NULL,'internal','752915ad7e4b4cfd847af0fda281f62b','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('f7230b15718143b4bf1eec55c8875199',NULL,'internal','f0ac45ef0214449c9dcc7f31f4351258','https://swift-internal.openstack.svc:8080/v1/AUTH_%(tenant_id)s','{\"name\": \"swift\"}',1,'regionOne'),('fae9ccb224f74312bc0333431ba67884',NULL,'internal','b007b645f9044c4ba892f6e4a1f0faf5','https://aodh-internal.openstack.svc:8042','{\"name\": \"aodh\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('563c6312ce444f79b731961a5e9dbc18','c31e33e5de1c492b88b1cf7e89a2a5bd'),('c31e33e5de1c492b88b1cf7e89a2a5bd','d7e9d57d77b446e380c76f6eb735f008');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=163 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'f02d735f9c704b2e8bde78ca5e15c788','default','admin',0,NULL),(2,'af7abaab325e41e7a00f222909ab37f2','default','swift',0,NULL),(3,'50ec2e8535db48c39e3558cb0dfee35c','default','cinder',0,NULL),(4,'d13984bf328f459bb9809cc7ce6d5742','default','placement',0,NULL),(5,'d9876f1f4419445ca56487301512b1e1','964cab5a794342a6a87fe6400d740537','heat_stack_domain_admin',0,NULL),(6,'ff9e7238d29c4bf1b4d67a95d8aa4dc7','default','glance',0,NULL),(7,'6ff04a48fc27407182d63a1211f2359d','default','barbican',0,NULL),(8,'43adc31c21d345b8ac08a01f5aa08929','default','nova',0,NULL),(9,'c2d6654e7a9b4e46b16813084bc5ab94','default','neutron',0,NULL),(10,'6301cba904174eca840f9d74c4ce7273','default','ceilometer',0,NULL),(11,'ab0f36b1258c48a29c07f01889f62554','default','heat',0,NULL),(12,'5f5dc25cf83a47a0817c768e7601bb22','default','aodh',0,NULL),(13,'8c3aef96126f47b49d7cf9954a203662','default','octavia',0,NULL),(14,'d87ba3f0156c4497bd935576d0e8f8cd','default','demo_tempestconf',0,NULL),(15,'d774a047c2a34cb4a7855c76dc880720','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=163 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$0GNncsg93qffmG2qOdIHq.Dg6LPUyjJ/Vzste.nSffALJdo9VelUG',1764800691816785,NULL,'2025-12-03 22:24:51'),(2,2,NULL,0,'$2b$12$TkkuH5TsJwWFuhHz0hxNKehDUt6bU9HLmRW24DLXhYBSsBQtTlYDm',1764800769365272,NULL,'2025-12-03 22:26:09'),(3,3,NULL,0,'$2b$12$fCP2nbWZQsCU8DjU.fvOkub/cAiWeMXSZXW84/w3qsNsNgoSC/RPe',1764800776073252,NULL,'2025-12-03 22:26:16'),(4,4,NULL,0,'$2b$12$vKV/UgHcjYF8WioKT1QCBeVbpvFr1a559rp38cKG2odpG.WuhL3Y.',1764800780303044,NULL,'2025-12-03 22:26:20'),(5,5,NULL,0,'$2b$12$B8gjK0dgf7F6J9Cj9u/QueenutZhRnjADvA8JvYsfwByxpGYceqWe',1764800782467682,NULL,'2025-12-03 22:26:22'),(6,6,NULL,0,'$2b$12$FM50lBAHKJLnbUJZpYV1nOGk4rflHa2kBv35UWFVu/rETszF4FiSO',1764800783133339,NULL,'2025-12-03 22:26:23'),(7,7,NULL,0,'$2b$12$zfp7Cmn5ySFW/INQRLDseeKTd6zpslR0CVHzWGkTCiA2Zyd3CpJLG',1764800788633831,NULL,'2025-12-03 22:26:28'),(8,8,NULL,0,'$2b$12$jcx9emt4XPtJozWa6iZdzu4i4rIQ8F8ZpTPu2VN/HcXQnauBECHgO',1764800792635324,NULL,'2025-12-03 22:26:32'),(9,9,NULL,0,'$2b$12$6WChnHGVgeGzaPRboJdlhu.u1sbZ6sdPTzKJERvMZWMi5o1TGWPy2',1764800804589151,NULL,'2025-12-03 22:26:44'),(10,10,NULL,0,'$2b$12$R1pzWd3/9q.55sslvFR6LeSykrEDRAA0Mfp/lySKKl6Nyi2/3sRgC',1764800812768907,NULL,'2025-12-03 22:26:52'),(11,11,NULL,0,'$2b$12$ridCCxF9UnpZ8SyMYrDbnu93oaYJIhD4rYoZPwBgITzw6DIl9hOrG',1764800825968907,NULL,'2025-12-03 22:27:05'),(12,12,NULL,0,'$2b$12$apr4ErOqqhspqxWOG.H4ze7yUgRGDhQQxOX92VGLL6JXLwPFK2v5u',1764800861493123,NULL,'2025-12-03 22:27:41'),(13,13,NULL,0,'$2b$12$1pref7v1ZPfQlpmEVk/dDeg3Qc4.z1UpYna8KoPsbVkBdI9KuCIXu',1764800991556643,NULL,'2025-12-03 22:29:51'),(14,14,NULL,0,'$2b$12$BeVvZ/BwQN0WfL9pBgx01O909cdpxViLCw7Dw7M55jjU9j55bMq0W',1764802173339086,NULL,'2025-12-03 22:49:33'),(15,15,NULL,0,'$2b$12$MDnc6qrRFg15R/ob/mcSGOu5V3S4pvV/jBzbWWEJWUarWBUHQqvNm',1764802173779099,NULL,'2025-12-03 22:49:33');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('287bb4deac5947ca983293ae47928819','service','{}','service',1,'default','default',0),('58bb5488538843998338914be63d5017','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('86b65474d4544ed68efb10a9bb276b2d','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('964cab5a794342a6a87fe6400d740537','heat_stack','{}','Domain for Heat stacks',1,'<<keystone.domain.root>>',NULL,1),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1),('ebdbc6bd6ac94fca9ac245c271bc304b','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=304 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,'345bac56175146c4b2293d7cec925dd9',NULL,NULL,NULL,NULL,'2025-12-03 22:50:20',NULL,'2025-12-03 22:50:20',NULL,NULL),(2,NULL,'7d9fe74f619b4248846a60877047d089',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:50:22',NULL,'2025-12-03 22:50:22',NULL,NULL),(3,NULL,NULL,'896f23cc8b914260b53e68f8fd857092',NULL,NULL,NULL,NULL,'2025-12-03 22:50:22',NULL,'2025-12-03 22:50:22',NULL,NULL),(4,NULL,'57011d8c327944848089d617f00ad28f',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:50:22',NULL,'2025-12-03 22:50:22',NULL,NULL),(5,NULL,NULL,'0b813da009594560bf946b5286b90713',NULL,NULL,NULL,NULL,'2025-12-03 22:50:23',NULL,'2025-12-03 22:50:23',NULL,NULL),(6,NULL,NULL,'827ac408f13d4237aae3e63bc5d41f2d',NULL,NULL,NULL,NULL,'2025-12-03 22:50:23',NULL,'2025-12-03 22:50:23',NULL,NULL),(7,NULL,NULL,'8def57e527774f93b89a055d4ae9f369',NULL,NULL,NULL,NULL,'2025-12-03 22:50:23',NULL,'2025-12-03 22:50:23',NULL,NULL),(8,NULL,NULL,'8001566fb0e84051863c6d0a0a569883',NULL,NULL,NULL,NULL,'2025-12-03 22:50:23',NULL,'2025-12-03 22:50:23',NULL,NULL),(9,NULL,NULL,'aa2c7a1c414f410fbe6aaa79bc31727c',NULL,NULL,NULL,NULL,'2025-12-03 22:50:23',NULL,'2025-12-03 22:50:23',NULL,NULL),(10,NULL,'a4d7ee188ab74a3f806ac1a834ddf532',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:50:25',NULL,'2025-12-03 22:50:25',NULL,NULL),(11,NULL,NULL,'37f25ffc3e724629950ad0939314d019',NULL,NULL,NULL,NULL,'2025-12-03 22:50:26',NULL,'2025-12-03 22:50:26',NULL,NULL),(12,NULL,'6749fb8438b5459bb7cb20f714879698',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:50:27',NULL,'2025-12-03 22:50:27',NULL,NULL),(13,NULL,'c5154e1da0344b01898afa919ed98549',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:50:27',NULL,'2025-12-03 22:50:27',NULL,NULL),(14,NULL,'822efd6cd0534d16a04a75d84fca5577',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:50:27',NULL,'2025-12-03 22:50:27',NULL,NULL),(15,NULL,'a0cda9e523a64e20a63fb93e22024727',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:50:31',NULL,'2025-12-03 22:50:31',NULL,NULL),(16,NULL,'fe8c6cbf216f4d4c8759f06e4dfff2a6',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:50:31',NULL,'2025-12-03 22:50:31',NULL,NULL),(17,NULL,'6b140018e13d4a8495709cc773ed5151',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:50:32',NULL,'2025-12-03 22:50:32',NULL,NULL),(18,NULL,'574422b4d5034a2d9a1b706f02b7575c',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:50:32',NULL,'2025-12-03 22:50:32',NULL,NULL),(19,NULL,NULL,'17a16d0b5ae3472b9b51f51aeb7e5467',NULL,NULL,NULL,NULL,'2025-12-03 22:50:36',NULL,'2025-12-03 22:50:36',NULL,NULL),(20,NULL,NULL,NULL,NULL,'6e49c47eebd9409f864f5db997e447c9',NULL,NULL,'2025-12-03 22:50:39',NULL,'2025-12-03 22:50:39',NULL,NULL),(21,NULL,NULL,'f8d59eab08064cb2a7b071d00ab4e503',NULL,NULL,NULL,NULL,'2025-12-03 22:50:40',NULL,'2025-12-03 22:50:40',NULL,NULL),(22,NULL,'b269e31eca144eeea5e24a4d86797f4b',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:50:40',NULL,'2025-12-03 22:50:40',NULL,NULL),(23,NULL,NULL,'e5044c7a2c33421b81398fc3f809a9e0',NULL,NULL,NULL,NULL,'2025-12-03 22:50:41',NULL,'2025-12-03 22:50:41',NULL,NULL),(24,NULL,NULL,'b0bee10aaa054ef59c1dd1157035112c',NULL,NULL,NULL,NULL,'2025-12-03 22:50:41',NULL,'2025-12-03 22:50:41',NULL,NULL),(25,NULL,'6a99743378914e70a56e1bb436e36100',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:50:42',NULL,'2025-12-03 22:50:42',NULL,NULL),(26,NULL,'c5d118ebbb024404b5aceee9cecb9c5d',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:50:45',NULL,'2025-12-03 22:50:45',NULL,NULL),(27,NULL,NULL,'9e25cf1abffc4c9fb4ab5d4c4f845a0c',NULL,NULL,NULL,NULL,'2025-12-03 22:50:46',NULL,'2025-12-03 22:50:46',NULL,NULL),(28,NULL,'10983d81a1a84d7989d61b2829d43eb5',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:50:51',NULL,'2025-12-03 22:50:51',NULL,NULL),(29,NULL,'771bd7b64c5e4f84bdc615bbe9783218',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:50:51',NULL,'2025-12-03 22:50:51',NULL,NULL),(30,NULL,NULL,'3342f002045f4b9d8000490e0024f6d7',NULL,NULL,NULL,NULL,'2025-12-03 22:50:53',NULL,'2025-12-03 22:50:53',NULL,NULL),(31,NULL,'29d6948d4c644a8d86c6a197c60b5d01',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:50:57',NULL,'2025-12-03 22:50:57',NULL,NULL),(32,NULL,NULL,'bd2349f2b2594a1ab15c8054d14a687b',NULL,NULL,NULL,NULL,'2025-12-03 22:51:10',NULL,'2025-12-03 22:51:10',NULL,NULL),(33,NULL,'29021e365a014f149392b11a9c50beaa',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:51:12',NULL,'2025-12-03 22:51:12',NULL,NULL),(34,NULL,NULL,'8f1578fd275a47a6a9074b3c6df27b82',NULL,NULL,NULL,NULL,'2025-12-03 22:51:24',NULL,'2025-12-03 22:51:24',NULL,NULL),(35,NULL,'2ef26536e2ad4fda90109f84582e0911',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:51:27',NULL,'2025-12-03 22:51:27',NULL,NULL),(36,NULL,NULL,'fc01d49e8f1b43e588a54f64ccb41e4c',NULL,NULL,NULL,NULL,'2025-12-03 22:51:36',NULL,'2025-12-03 22:51:36',NULL,NULL),(37,NULL,'3c37aa255415426b94a467e99a821924',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:51:37',NULL,'2025-12-03 22:51:37',NULL,NULL),(38,NULL,NULL,'dca2f67305da4f4ea112cb05d9b8946b',NULL,NULL,NULL,NULL,'2025-12-03 22:51:42',NULL,'2025-12-03 22:51:42',NULL,NULL),(39,NULL,'299ee2f66db64e96b81a849a523d8680',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:51:47',NULL,'2025-12-03 22:51:47',NULL,NULL),(40,NULL,NULL,'c80083fdf50d4a0dbc2a2ba0c2b1d70d',NULL,NULL,NULL,NULL,'2025-12-03 22:51:53',NULL,'2025-12-03 22:51:53',NULL,NULL),(41,NULL,NULL,'88d4dd5f1f7343928f7515beb7a68fd7',NULL,NULL,NULL,NULL,'2025-12-03 22:51:54',NULL,'2025-12-03 22:51:54',NULL,NULL),(42,NULL,'f80ffd4aa9d54d968dc59b79b40dd107',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:51:56',NULL,'2025-12-03 22:51:56',NULL,NULL),(43,NULL,'82e872fe50a84e02b3cb45cf1bf487e1',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:51:58',NULL,'2025-12-03 22:51:58',NULL,NULL),(44,NULL,'bf49fa48c19346c8b772bba61286cc53',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:03',NULL,'2025-12-03 22:52:03',NULL,NULL),(45,NULL,'96457527ea964d3691865ed0c87fce2c',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:03',NULL,'2025-12-03 22:52:03',NULL,NULL),(46,NULL,'ff14c466652c43b0b1142f8594eea81a',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:03',NULL,'2025-12-03 22:52:03',NULL,NULL),(47,NULL,'2ae2f015abba4ae4b65a4aa201b4d2f8',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:04',NULL,'2025-12-03 22:52:04',NULL,NULL),(48,NULL,NULL,'ad5d448d104c48ad96776f067ab95dc0',NULL,NULL,NULL,NULL,'2025-12-03 22:52:04',NULL,'2025-12-03 22:52:04',NULL,NULL),(49,NULL,NULL,'bce53ff955664f2a802bb21117d80d97',NULL,NULL,NULL,NULL,'2025-12-03 22:52:04',NULL,'2025-12-03 22:52:04',NULL,NULL),(50,NULL,NULL,'a42c681828e242a785dd22266446e58b',NULL,NULL,NULL,NULL,'2025-12-03 22:52:05',NULL,'2025-12-03 22:52:05',NULL,NULL),(51,NULL,'f59030bedd6c413a8d472d66c224e2b4',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:08',NULL,'2025-12-03 22:52:08',NULL,NULL),(52,NULL,'f30d07c8bd5d47f3bb513e5e5fa7f4f8',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:10',NULL,'2025-12-03 22:52:10',NULL,NULL),(53,NULL,NULL,'66c0335dd0ea42c7be40caaafbdfc74b',NULL,NULL,NULL,NULL,'2025-12-03 22:52:10',NULL,'2025-12-03 22:52:10',NULL,NULL),(54,NULL,NULL,'a10580bd517d4e65ba03548fffb525fd',NULL,NULL,NULL,NULL,'2025-12-03 22:52:14',NULL,'2025-12-03 22:52:14',NULL,NULL),(55,NULL,NULL,'71b720982d28470eb4ee66d7d5278440',NULL,NULL,NULL,NULL,'2025-12-03 22:52:14',NULL,'2025-12-03 22:52:14',NULL,NULL),(56,NULL,'39001f7aaba146b7a3a74e326e6a2137',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:14',NULL,'2025-12-03 22:52:14',NULL,NULL),(57,NULL,NULL,'3496bbec2fac47ffad1bfccc6bb59688',NULL,NULL,NULL,NULL,'2025-12-03 22:52:15',NULL,'2025-12-03 22:52:15',NULL,NULL),(58,NULL,'a3517b49aeab42658ca71c0a20bc55af',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:16',NULL,'2025-12-03 22:52:16',NULL,NULL),(59,NULL,NULL,'00a0ccd0aaf24ba2aff80a5627fc3980',NULL,NULL,NULL,NULL,'2025-12-03 22:52:21',NULL,'2025-12-03 22:52:21',NULL,NULL),(60,NULL,NULL,'aa2121c24d61463c87e387513f42cd1f',NULL,NULL,NULL,NULL,'2025-12-03 22:52:22',NULL,'2025-12-03 22:52:22',NULL,NULL),(61,NULL,'7f7ed8a90f7a4cf195f665030cfef3ed',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:22',NULL,'2025-12-03 22:52:22',NULL,NULL),(62,NULL,NULL,'a484437dfb6b40869e9a75ee63c415b5',NULL,NULL,NULL,NULL,'2025-12-03 22:52:22',NULL,'2025-12-03 22:52:22',NULL,NULL),(63,NULL,NULL,'a484437dfb6b40869e9a75ee63c415b5',NULL,NULL,NULL,NULL,'2025-12-03 22:52:22',NULL,'2025-12-03 22:52:22',NULL,NULL),(64,NULL,NULL,'aa2121c24d61463c87e387513f42cd1f',NULL,NULL,NULL,NULL,'2025-12-03 22:52:22',NULL,'2025-12-03 22:52:22',NULL,NULL),(65,NULL,NULL,'00a0ccd0aaf24ba2aff80a5627fc3980',NULL,NULL,NULL,NULL,'2025-12-03 22:52:23',NULL,'2025-12-03 22:52:23',NULL,NULL),(66,NULL,'de604749b6734287ac08fb4abda9e9f8',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:23',NULL,'2025-12-03 22:52:23',NULL,NULL),(67,NULL,'9310e9931efb4972a4283281290913e5',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:24',NULL,'2025-12-03 22:52:24',NULL,NULL),(68,NULL,NULL,'1ab20430bb2a4aa8afaa3865cb5b75f1',NULL,NULL,NULL,NULL,'2025-12-03 22:52:24',NULL,'2025-12-03 22:52:24',NULL,NULL),(69,NULL,NULL,'2e58bbfa314c4f688e59f9d46b2a4910',NULL,NULL,NULL,NULL,'2025-12-03 22:52:24',NULL,'2025-12-03 22:52:24',NULL,NULL),(70,NULL,NULL,'f2dcf16c25b345788cf2b18972536974',NULL,NULL,NULL,NULL,'2025-12-03 22:52:26',NULL,'2025-12-03 22:52:26',NULL,NULL),(71,NULL,NULL,'28596c695eb04e8a82ccdb8b6985c3e1',NULL,NULL,NULL,NULL,'2025-12-03 22:52:27',NULL,'2025-12-03 22:52:27',NULL,NULL),(72,NULL,'d606603b860540b69b8bbfb589f9e842',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:28',NULL,'2025-12-03 22:52:28',NULL,NULL),(73,NULL,'0db3365295534d039fa7d7f057e47464',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:29',NULL,'2025-12-03 22:52:29',NULL,NULL),(74,NULL,'3edf9c26c4034e4bbec25f8f11c34043',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:29',NULL,'2025-12-03 22:52:29',NULL,NULL),(75,NULL,'3d295958a08b4f3eb35efc327c812b5a',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:31',NULL,'2025-12-03 22:52:31',NULL,NULL),(76,NULL,'6189962f722744cb85a5bfb3f959d630',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:31',NULL,'2025-12-03 22:52:31',NULL,NULL),(77,NULL,NULL,'fc67aae238634f9981f11afb8da4f6ed',NULL,NULL,NULL,NULL,'2025-12-03 22:52:34',NULL,'2025-12-03 22:52:34',NULL,NULL),(78,NULL,'ffa4cac4aa4f4d4c9954e1427a2d71b1',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:37',NULL,'2025-12-03 22:52:37',NULL,NULL),(79,NULL,NULL,'becd6cc7cf914ba195e231cb29591675',NULL,NULL,NULL,NULL,'2025-12-03 22:52:38',NULL,'2025-12-03 22:52:38',NULL,NULL),(80,NULL,NULL,'1be30217a8b548df9187a7fe0c39c8a7',NULL,NULL,NULL,NULL,'2025-12-03 22:52:40',NULL,'2025-12-03 22:52:40',NULL,NULL),(81,NULL,NULL,'fb5bd8499c9f412192c182148e6f4981',NULL,NULL,NULL,NULL,'2025-12-03 22:52:40',NULL,'2025-12-03 22:52:40',NULL,NULL),(82,NULL,NULL,'47b906b2121d4314b41f1844427ba2ce',NULL,NULL,NULL,NULL,'2025-12-03 22:52:40',NULL,'2025-12-03 22:52:40',NULL,NULL),(83,NULL,'b06a9958363945768d782fd561e86e56',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:42',NULL,'2025-12-03 22:52:42',NULL,NULL),(84,NULL,'ecd440be7f264336ada53d09bd04a132',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:42',NULL,'2025-12-03 22:52:42',NULL,NULL),(85,NULL,'e5ea0788a3334ff2b5022751fcca82dd',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:44',NULL,'2025-12-03 22:52:44',NULL,NULL),(86,NULL,NULL,'f9a78bab16dc4ca3a08b91e61b54d797',NULL,NULL,NULL,NULL,'2025-12-03 22:52:45',NULL,'2025-12-03 22:52:45',NULL,NULL),(87,NULL,'2471e4eb22de475081e38f2eab8dc116',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:47',NULL,'2025-12-03 22:52:47',NULL,NULL),(88,NULL,NULL,'58f3da95654047428d389d3239f02873',NULL,NULL,NULL,NULL,'2025-12-03 22:52:48',NULL,'2025-12-03 22:52:48',NULL,NULL),(89,NULL,'ddb6c9b423dd48b4b4c460aff8309d3e',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:48',NULL,'2025-12-03 22:52:48',NULL,NULL),(90,NULL,NULL,'ead32083fb8f42afaa505d4a8343d425',NULL,NULL,NULL,NULL,'2025-12-03 22:52:53',NULL,'2025-12-03 22:52:53',NULL,NULL),(91,NULL,NULL,'a9871e9f57244541864af388a66566b4',NULL,NULL,NULL,NULL,'2025-12-03 22:52:53',NULL,'2025-12-03 22:52:53',NULL,NULL),(92,NULL,NULL,'55db4b3857e04eac8b2f54b842831566',NULL,NULL,NULL,NULL,'2025-12-03 22:52:53',NULL,'2025-12-03 22:52:53',NULL,NULL),(93,NULL,'eb9b2332061c4045b378f91559fffc0c',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:54',NULL,'2025-12-03 22:52:54',NULL,NULL),(94,NULL,'635d6ff05dfb44cb827f4d0e030c9aa4',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:55',NULL,'2025-12-03 22:52:55',NULL,NULL),(95,NULL,NULL,'26f72133b23a426b9883e72861247683',NULL,NULL,NULL,NULL,'2025-12-03 22:52:56',NULL,'2025-12-03 22:52:56',NULL,NULL),(96,NULL,NULL,'32cfae7e72da498ea01454b489037b0f',NULL,NULL,NULL,NULL,'2025-12-03 22:52:56',NULL,'2025-12-03 22:52:56',NULL,NULL),(97,NULL,'4ae36d3410e048c2a90651633ac5b971',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:56',NULL,'2025-12-03 22:52:56',NULL,NULL),(98,NULL,'fc87fb9d2e854521ac7a3b6f2f3f2957',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:52:57',NULL,'2025-12-03 22:52:57',NULL,NULL),(99,NULL,NULL,'a4224fba8f594a2ab6372d8c693ec007',NULL,NULL,NULL,NULL,'2025-12-03 22:52:59',NULL,'2025-12-03 22:52:59',NULL,NULL),(100,NULL,NULL,'8746926f4ab844698a16415869b79807',NULL,NULL,NULL,NULL,'2025-12-03 22:53:00',NULL,'2025-12-03 22:53:00',NULL,NULL),(101,NULL,'dda3dcd919224d45b869584c36cd68dc',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:53:01',NULL,'2025-12-03 22:53:01',NULL,NULL),(102,NULL,'839817f089914b35a0a9bbc0314a900a',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:53:01',NULL,'2025-12-03 22:53:01',NULL,NULL),(103,NULL,'e74ea7b8a674449db8848a81a3350002',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:53:01',NULL,'2025-12-03 22:53:01',NULL,NULL),(104,NULL,NULL,'24d136f16b894420851f06e95c0d4953',NULL,NULL,NULL,NULL,'2025-12-03 22:53:02',NULL,'2025-12-03 22:53:02',NULL,NULL),(105,NULL,NULL,'cbbd7286bb414895ad900d21ddeb2467',NULL,NULL,NULL,NULL,'2025-12-03 22:53:02',NULL,'2025-12-03 22:53:02',NULL,NULL),(106,NULL,NULL,'ff463d03850c4a04a3e4bd711fc5b20e',NULL,NULL,NULL,NULL,'2025-12-03 22:53:02',NULL,'2025-12-03 22:53:02',NULL,NULL),(107,NULL,NULL,'b2c8d3b2c25f4290aa85d8f281573c65',NULL,NULL,NULL,NULL,'2025-12-03 22:53:04',NULL,'2025-12-03 22:53:04',NULL,NULL),(108,NULL,'c19438a71e444d29b102c6bb27b31216',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:53:04',NULL,'2025-12-03 22:53:04',NULL,NULL),(109,NULL,NULL,'9b00565da4454299b1b3d596afc555be',NULL,NULL,NULL,NULL,'2025-12-03 22:53:04',NULL,'2025-12-03 22:53:04',NULL,NULL),(110,NULL,'9f5ae97d4aec4edd8fe6601dc8edca08',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:53:05',NULL,'2025-12-03 22:53:05',NULL,NULL),(111,NULL,'7f4636e2f5f24a6cb517c37ab6de6d9b',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:53:05',NULL,'2025-12-03 22:53:05',NULL,NULL),(112,NULL,'6402e5785ee74c12862ed773ab5db6c9',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:53:07',NULL,'2025-12-03 22:53:07',NULL,NULL),(113,NULL,'3e7bc7be4d034372941f60edf773bdef',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:53:10',NULL,'2025-12-03 22:53:10',NULL,NULL),(114,NULL,'e25422242e3f4e64bd4a390aef883be4',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:53:12',NULL,'2025-12-03 22:53:12',NULL,NULL),(115,NULL,'8aa54fd96eef422fab3d86995f70518a',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:53:15',NULL,'2025-12-03 22:53:15',NULL,NULL),(116,NULL,NULL,'03b55c2ff43047a395b4efc70ccbb960',NULL,NULL,NULL,NULL,'2025-12-03 22:53:18',NULL,'2025-12-03 22:53:18',NULL,NULL),(117,NULL,NULL,'1ec123bd4f05436f8fd33123783b3b61',NULL,NULL,NULL,NULL,'2025-12-03 22:53:18',NULL,'2025-12-03 22:53:18',NULL,NULL),(118,NULL,'08a0acb189054a389ef82e612bfb6d6b',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:53:22',NULL,'2025-12-03 22:53:22',NULL,NULL),(119,NULL,NULL,'65971293350c4e128e309150688e2247',NULL,NULL,NULL,NULL,'2025-12-03 22:53:27',NULL,'2025-12-03 22:53:27',NULL,NULL),(120,NULL,NULL,'edcd11c6109a46d595e34216f0c0cb1a',NULL,NULL,NULL,NULL,'2025-12-03 22:53:27',NULL,'2025-12-03 22:53:27',NULL,NULL),(121,NULL,NULL,'c194c5fefb0a4a838f0fc6bea5d47e0e',NULL,NULL,NULL,NULL,'2025-12-03 22:53:27',NULL,'2025-12-03 22:53:27',NULL,NULL),(122,NULL,'9eef047e06a043a8ba5677630ae7e2a6',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:53:27',NULL,'2025-12-03 22:53:27',NULL,NULL),(123,NULL,NULL,'a7cff2c0764a40e6a51e931ae57e3fb7',NULL,NULL,NULL,NULL,'2025-12-03 22:53:27',NULL,'2025-12-03 22:53:27',NULL,NULL),(124,NULL,NULL,'071b4d5e918746dd86a9223643aef827',NULL,NULL,NULL,NULL,'2025-12-03 22:53:27',NULL,'2025-12-03 22:53:27',NULL,NULL),(125,NULL,NULL,'e5981f0ad6cd4963b323b2453a7ab5e8',NULL,NULL,NULL,NULL,'2025-12-03 22:53:28',NULL,'2025-12-03 22:53:28',NULL,NULL),(126,NULL,'ded63259c62042edb9bd375e23c6b0ec',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:53:29',NULL,'2025-12-03 22:53:29',NULL,NULL),(127,NULL,NULL,'de259bbaf32141a893f17b3dd23dde27',NULL,NULL,NULL,NULL,'2025-12-03 22:53:29',NULL,'2025-12-03 22:53:29',NULL,NULL),(128,NULL,'5cb275dcfb3b4cbd81fb9b583d81f247',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:53:30',NULL,'2025-12-03 22:53:30',NULL,NULL),(129,NULL,'aafc2e856ab640178a99edbe27cbea1e',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:53:31',NULL,'2025-12-03 22:53:31',NULL,NULL),(130,NULL,NULL,'1b45ca5ca0fa4103b18b096d0fb3ba08',NULL,NULL,NULL,NULL,'2025-12-03 22:53:31',NULL,'2025-12-03 22:53:31',NULL,NULL),(131,NULL,'f5cc4f2f610e455bb01ee0baf48dd46b',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:53:33',NULL,'2025-12-03 22:53:33',NULL,NULL),(132,NULL,'47d82f9c45174b9791a9c300cddc2345',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:53:34',NULL,'2025-12-03 22:53:34',NULL,NULL),(133,NULL,'31279a5177e9407e889316d45724f66e',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:53:35',NULL,'2025-12-03 22:53:35',NULL,NULL),(134,NULL,NULL,'1ce1a1ac890340d6b7d47a3c0ca8fcf5',NULL,NULL,NULL,NULL,'2025-12-03 22:53:36',NULL,'2025-12-03 22:53:36',NULL,NULL),(135,NULL,'c66ef6ac1eb947988bc61f6e80c44809',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:53:37',NULL,'2025-12-03 22:53:37',NULL,NULL),(136,NULL,NULL,'21182765e5a64145bfad17b88a5726a6',NULL,NULL,NULL,NULL,'2025-12-03 22:53:38',NULL,'2025-12-03 22:53:38',NULL,NULL),(137,NULL,'303bd5b34d754cebb2513f340e3b2706',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:53:42',NULL,'2025-12-03 22:53:42',NULL,NULL),(138,NULL,'447980ae13e34c23a32566d3f54e775e',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:53:43',NULL,'2025-12-03 22:53:43',NULL,NULL),(139,NULL,'33377f922a8e464a9660e08035d1dc6d',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:53:43',NULL,'2025-12-03 22:53:43',NULL,NULL),(140,NULL,NULL,'98dc1ec922434f1ba0c31c914737ce0d',NULL,NULL,NULL,NULL,'2025-12-03 22:53:44',NULL,'2025-12-03 22:53:44',NULL,NULL),(141,NULL,'301200c274804774ab9b73b272642d78',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:53:46',NULL,'2025-12-03 22:53:46',NULL,NULL),(142,NULL,NULL,'077c88ccd29e495c830147a766951740',NULL,NULL,NULL,NULL,'2025-12-03 22:53:59',NULL,'2025-12-03 22:53:59',NULL,NULL),(143,NULL,NULL,'5480c707a5264bd7b2bdc0c68c1fdbe0',NULL,NULL,NULL,NULL,'2025-12-03 22:53:59',NULL,'2025-12-03 22:53:59',NULL,NULL),(144,NULL,'bc386e6a04654a30b254338a19a1f048',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:54:04',NULL,'2025-12-03 22:54:04',NULL,NULL),(145,NULL,NULL,'dc899a1417f84074b5577c799da15e9b',NULL,NULL,NULL,NULL,'2025-12-03 22:54:06',NULL,'2025-12-03 22:54:06',NULL,NULL),(146,NULL,NULL,'25a011b7033046ee856600b38fa85bdd',NULL,NULL,NULL,NULL,'2025-12-03 22:54:06',NULL,'2025-12-03 22:54:06',NULL,NULL),(147,NULL,NULL,'43c5ace3a12448ffbcc5f41fcbde1140',NULL,NULL,NULL,NULL,'2025-12-03 22:54:07',NULL,'2025-12-03 22:54:07',NULL,NULL),(148,NULL,'a7f6e8062a80435399522a8e8e6b496f',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:54:07',NULL,'2025-12-03 22:54:07',NULL,NULL),(149,NULL,NULL,'7f00e869a84947d8b59d080e0aecaf99',NULL,NULL,NULL,NULL,'2025-12-03 22:54:07',NULL,'2025-12-03 22:54:07',NULL,NULL),(150,NULL,NULL,'43380522b25542f999e6095fee491960',NULL,NULL,NULL,NULL,'2025-12-03 22:54:08',NULL,'2025-12-03 22:54:08',NULL,NULL),(151,NULL,NULL,'3b6132868a674d618c2cca4e10c25e68',NULL,NULL,NULL,NULL,'2025-12-03 22:54:08',NULL,'2025-12-03 22:54:08',NULL,NULL),(152,NULL,'729ac17434274f4897bd3279dd5806a8',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:54:08',NULL,'2025-12-03 22:54:08',NULL,NULL),(153,NULL,'5609e6f02f014669b58967ff0e930abd',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:54:08',NULL,'2025-12-03 22:54:08',NULL,NULL),(154,NULL,'895acd3403154be09e5a330133831f60',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:54:10',NULL,'2025-12-03 22:54:10',NULL,NULL),(155,NULL,NULL,'a70a6ef9eeaf4292bdfc6f0d0f2a5458',NULL,NULL,NULL,NULL,'2025-12-03 22:54:10',NULL,'2025-12-03 22:54:10',NULL,NULL),(156,NULL,'5fb1836d783440eeb2c6050a2c2dce5e',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:54:11',NULL,'2025-12-03 22:54:11',NULL,NULL),(157,NULL,'d3ff56c71f1d42848827b88e690b6147',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:54:11',NULL,'2025-12-03 22:54:11',NULL,NULL),(158,NULL,'9e39f529b7be4d20a35fb40e772872cb',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:54:11',NULL,'2025-12-03 22:54:11',NULL,NULL),(159,NULL,'664b62fdebe0449cb155355357829f76',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:54:12',NULL,'2025-12-03 22:54:12',NULL,NULL),(160,NULL,NULL,'53c673855bfa414f88212696f16273dd',NULL,NULL,NULL,NULL,'2025-12-03 22:54:27',NULL,'2025-12-03 22:54:27',NULL,NULL),(161,NULL,NULL,'0f7739ba53d845c1a7845adc4c2f6aa2',NULL,NULL,NULL,NULL,'2025-12-03 22:54:27',NULL,'2025-12-03 22:54:27',NULL,NULL),(162,NULL,NULL,'515bc57c1f464e7881196ac04879540d',NULL,NULL,NULL,NULL,'2025-12-03 22:54:29',NULL,'2025-12-03 22:54:29',NULL,NULL),(163,NULL,NULL,'6b984b36678945229fdc0ed4ec8ad22f',NULL,NULL,NULL,NULL,'2025-12-03 22:54:29',NULL,'2025-12-03 22:54:29',NULL,NULL),(164,NULL,NULL,'5b54c744a0584c3e8e4ddd699173552e',NULL,NULL,NULL,NULL,'2025-12-03 22:54:29',NULL,'2025-12-03 22:54:29',NULL,NULL),(165,NULL,'b1b5eb1923ed44c1b9921fc98b1af21b',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:54:30',NULL,'2025-12-03 22:54:30',NULL,NULL),(166,NULL,'2a26e6396bda451a942830c00022f922',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:54:32',NULL,'2025-12-03 22:54:32',NULL,NULL),(167,NULL,'029c171c4dfc4b30ae3b8d1b8e2f2e9d',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:54:34',NULL,'2025-12-03 22:54:34',NULL,NULL),(168,NULL,'dc36edd7971f480d86db17ee4e6268fa',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:54:37',NULL,'2025-12-03 22:54:37',NULL,NULL),(169,NULL,'8d428363e3244dfe8fc41c91b8e5bb4c',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:54:38',NULL,'2025-12-03 22:54:38',NULL,NULL),(170,NULL,NULL,'57b98e41f0c7487081bfcd9b97d634e2',NULL,NULL,NULL,NULL,'2025-12-03 22:54:41',NULL,'2025-12-03 22:54:41',NULL,NULL),(171,NULL,NULL,'edecf24b446d4404b68cdda5c7c8d6fa',NULL,NULL,NULL,NULL,'2025-12-03 22:54:44',NULL,'2025-12-03 22:54:44',NULL,NULL),(172,NULL,'17740b1ad7584f87b4eeaf23296856e6',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:54:44',NULL,'2025-12-03 22:54:44',NULL,NULL),(173,NULL,NULL,'1bc426f2fe1441ebb19e834fbe2217d1',NULL,NULL,NULL,NULL,'2025-12-03 22:54:44',NULL,'2025-12-03 22:54:44',NULL,NULL),(174,NULL,'09d72257e76f41d4946930fbdedf3314',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:54:46',NULL,'2025-12-03 22:54:46',NULL,NULL),(175,NULL,'ce1f9a21bf4b4c00b17fdf996b423c2d',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:54:47',NULL,'2025-12-03 22:54:47',NULL,NULL),(176,NULL,NULL,'61f775249a5044b5b148c2b7c7d5a028',NULL,NULL,NULL,NULL,'2025-12-03 22:54:51',NULL,'2025-12-03 22:54:51',NULL,NULL),(177,NULL,NULL,'84c537c6ac3b43c2b205970653893bcf',NULL,NULL,NULL,NULL,'2025-12-03 22:54:52',NULL,'2025-12-03 22:54:52',NULL,NULL),(178,NULL,'6b5d12f97df643d89e59ee96c8e14baf',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:54:57',NULL,'2025-12-03 22:54:57',NULL,NULL),(179,NULL,NULL,'fc9470dbf271411e887615ed6ed97267',NULL,NULL,NULL,NULL,'2025-12-03 22:55:00',NULL,'2025-12-03 22:55:00',NULL,NULL),(180,NULL,NULL,'894e0c56499f40399b2527f26d6af7d7',NULL,NULL,NULL,NULL,'2025-12-03 22:55:00',NULL,'2025-12-03 22:55:00',NULL,NULL),(181,NULL,'549c58cba1ee48f082c8b0b8d5a95a52',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:55:01',NULL,'2025-12-03 22:55:01',NULL,NULL),(182,NULL,'a0f27dbc7f4149fc8c87b34fdec75ee9',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:55:02',NULL,'2025-12-03 22:55:02',NULL,NULL),(183,NULL,'e837123e0f3f4651abcea5506739ca73',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:55:03',NULL,'2025-12-03 22:55:03',NULL,NULL),(184,NULL,NULL,'87572cb3e62a4ba7bf45cdc9eba69681',NULL,NULL,NULL,NULL,'2025-12-03 22:55:03',NULL,'2025-12-03 22:55:03',NULL,NULL),(185,NULL,'7c262565f60d44c8b82b94e6e4e05d25',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:55:09',NULL,'2025-12-03 22:55:09',NULL,NULL),(186,NULL,NULL,'988ef9f2fa834867a97227c8b6fd8eb6',NULL,NULL,NULL,NULL,'2025-12-03 22:55:10',NULL,'2025-12-03 22:55:10',NULL,NULL),(187,NULL,NULL,'cd0fd3523e734dc29d21d137d337ca31',NULL,NULL,NULL,NULL,'2025-12-03 22:55:10',NULL,'2025-12-03 22:55:10',NULL,NULL),(188,NULL,NULL,'3ce992652ca244b189955ba4c6835b65',NULL,NULL,NULL,NULL,'2025-12-03 22:55:11',NULL,'2025-12-03 22:55:11',NULL,NULL),(189,NULL,NULL,'92f6b0a2a0d44846adb02f3f03038a70',NULL,NULL,NULL,NULL,'2025-12-03 22:55:12',NULL,'2025-12-03 22:55:12',NULL,NULL),(190,NULL,'e69a09146c7e4da78d6ca99d795105cf',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:55:13',NULL,'2025-12-03 22:55:13',NULL,NULL),(191,NULL,'f547c1443c8f4b8da2819942b61ea044',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:55:15',NULL,'2025-12-03 22:55:15',NULL,NULL),(192,NULL,'21f654ec9d724a63920e7c068ae790d7',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:55:15',NULL,'2025-12-03 22:55:15',NULL,NULL),(193,NULL,'226d61e7249e47cb91d50bbb777fe779',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:55:17',NULL,'2025-12-03 22:55:17',NULL,NULL),(194,NULL,NULL,'fce884bad38c498f82e58ba29696fadf',NULL,NULL,NULL,NULL,'2025-12-03 22:55:26',NULL,'2025-12-03 22:55:26',NULL,NULL),(195,NULL,NULL,'a91449bf8ac4439cb5f0c3391ce35f63',NULL,NULL,NULL,NULL,'2025-12-03 22:55:26',NULL,'2025-12-03 22:55:26',NULL,NULL),(196,NULL,'134bc6816936462f9412836b8097d970',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:55:28',NULL,'2025-12-03 22:55:28',NULL,NULL),(197,NULL,'381fd7fb1cbf49ce9bf936b1b1a51d16',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:55:29',NULL,'2025-12-03 22:55:29',NULL,NULL),(198,NULL,NULL,'6236b5bdabe64916a910fd9a93fc40f5',NULL,NULL,NULL,NULL,'2025-12-03 22:55:30',NULL,'2025-12-03 22:55:30',NULL,NULL),(199,NULL,NULL,'26a95056d9ee43fda927fe836079a95d',NULL,NULL,NULL,NULL,'2025-12-03 22:55:30',NULL,'2025-12-03 22:55:30',NULL,NULL),(200,NULL,NULL,'93c41d83210545b497e7b9b8c72e9d82',NULL,NULL,NULL,NULL,'2025-12-03 22:55:30',NULL,'2025-12-03 22:55:30',NULL,NULL),(201,NULL,NULL,'6ef04db22948468aac6741da595f26b8',NULL,NULL,NULL,NULL,'2025-12-03 22:55:30',NULL,'2025-12-03 22:55:30',NULL,NULL),(202,NULL,NULL,'aab5dbd441794068bdb5aad7c536ed2e',NULL,NULL,NULL,NULL,'2025-12-03 22:55:31',NULL,'2025-12-03 22:55:31',NULL,NULL),(203,NULL,'052a6534f8754429bbd644a3b9b34e8c',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:55:32',NULL,'2025-12-03 22:55:32',NULL,NULL),(204,NULL,'5b2e2fbf36e94d739c3989d4026a6623',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:55:33',NULL,'2025-12-03 22:55:33',NULL,NULL),(205,NULL,'02bf230dd5ba442c9433005b5afb2c22',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:55:34',NULL,'2025-12-03 22:55:34',NULL,NULL),(206,NULL,'4a089a935117487eb325233c0cb13eeb',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:55:34',NULL,'2025-12-03 22:55:34',NULL,NULL),(207,NULL,NULL,'06598f3c0e874151a106669c7d106cc9',NULL,NULL,NULL,NULL,'2025-12-03 22:55:34',NULL,'2025-12-03 22:55:34',NULL,NULL),(208,NULL,NULL,'dde750300f974b37b06531bd735d939e',NULL,NULL,NULL,NULL,'2025-12-03 22:55:34',NULL,'2025-12-03 22:55:34',NULL,NULL),(209,NULL,'82b277da7d2d4fd19dcb4f99d9b44f72',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:55:35',NULL,'2025-12-03 22:55:35',NULL,NULL),(210,NULL,'cf9cba8c32de4120b657757dd4d6cccf',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:55:35',NULL,'2025-12-03 22:55:35',NULL,NULL),(211,NULL,'4e0c0690de8f457393b144fee0a952c5',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:55:36',NULL,'2025-12-03 22:55:36',NULL,NULL),(212,NULL,NULL,'4855c9e003a749bfb315acaadfbff55c',NULL,NULL,NULL,NULL,'2025-12-03 22:55:47',NULL,'2025-12-03 22:55:47',NULL,NULL),(213,NULL,NULL,'f27edabfc03c467b9434ad9f31bb5050',NULL,NULL,NULL,NULL,'2025-12-03 22:55:48',NULL,'2025-12-03 22:55:48',NULL,NULL),(214,NULL,NULL,'fd62f4e18a804daf8e258378bf15ec1c',NULL,NULL,NULL,NULL,'2025-12-03 22:55:48',NULL,'2025-12-03 22:55:48',NULL,NULL),(215,NULL,'078cd8a3d54d477488ee69e316da9417',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:55:49',NULL,'2025-12-03 22:55:49',NULL,NULL),(216,NULL,'663b3e36c0344a0b93e3eb7bbbd43522',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:55:51',NULL,'2025-12-03 22:55:51',NULL,NULL),(217,NULL,'1fae4fbf6b314e20b42b9cf6ad7a6cce',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:55:52',NULL,'2025-12-03 22:55:52',NULL,NULL),(218,NULL,NULL,'eb1e57f1c5d0413399aaed259cde52ed',NULL,NULL,NULL,NULL,'2025-12-03 22:55:55',NULL,'2025-12-03 22:55:55',NULL,NULL),(219,NULL,NULL,'62880a93b5e748a3a587ed0a4ddd637b',NULL,NULL,NULL,NULL,'2025-12-03 22:55:55',NULL,'2025-12-03 22:55:55',NULL,NULL),(220,NULL,'50c6b4aa393644a6a1f79dc8daa3a531',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:55:56',NULL,'2025-12-03 22:55:56',NULL,NULL),(221,NULL,'6f42f97838fa4c508671d01963b773e6',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:55:57',NULL,'2025-12-03 22:55:57',NULL,NULL),(222,NULL,NULL,'2194e8d350cd4cbe803a5b22a84c9456',NULL,NULL,NULL,NULL,'2025-12-03 22:56:01',NULL,'2025-12-03 22:56:01',NULL,NULL),(223,NULL,NULL,'0e82fc559db24281b300f0bff12bdf3f',NULL,NULL,NULL,NULL,'2025-12-03 22:56:01',NULL,'2025-12-03 22:56:01',NULL,NULL),(224,NULL,'ee2d67240bc84eec820a32af1cc0dcdd',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:56:02',NULL,'2025-12-03 22:56:02',NULL,NULL),(225,NULL,'c0427ab7191f43f1babfd46123f63e71',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:56:03',NULL,'2025-12-03 22:56:03',NULL,NULL),(226,NULL,NULL,'38218d1e6a504895a16576b10ea72007',NULL,NULL,NULL,NULL,'2025-12-03 22:56:08',NULL,'2025-12-03 22:56:08',NULL,NULL),(227,NULL,NULL,'3f8379d33de54f5eafe02e2a5d349400',NULL,NULL,NULL,NULL,'2025-12-03 22:56:08',NULL,'2025-12-03 22:56:08',NULL,NULL),(228,NULL,'164233494b204651a995cda5380f8b48',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:56:10',NULL,'2025-12-03 22:56:10',NULL,NULL),(229,NULL,'a37adb7059df4b0aa67905c005131c16',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:56:10',NULL,'2025-12-03 22:56:10',NULL,NULL),(230,NULL,NULL,'0cc788bf94b043be9fa78d151316c180',NULL,NULL,NULL,NULL,'2025-12-03 22:56:30',NULL,'2025-12-03 22:56:30',NULL,NULL),(231,NULL,NULL,'247fe760d4cc40308700965a1b493e8e',NULL,NULL,NULL,NULL,'2025-12-03 22:56:30',NULL,'2025-12-03 22:56:30',NULL,NULL),(232,NULL,'81805fcc94854ba6997bebb34be6a5db',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:56:31',NULL,'2025-12-03 22:56:31',NULL,NULL),(233,NULL,'e8cc745fa6b343e78b026b8673ab3f3b',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:56:32',NULL,'2025-12-03 22:56:32',NULL,NULL),(234,NULL,NULL,'70f9a24361c241c7b294442ad8bee7a4',NULL,NULL,NULL,NULL,'2025-12-03 22:56:52',NULL,'2025-12-03 22:56:52',NULL,NULL),(235,NULL,NULL,'dde0bbd44c754eda8edf64a5346b6085',NULL,NULL,NULL,NULL,'2025-12-03 22:56:53',NULL,'2025-12-03 22:56:53',NULL,NULL),(236,NULL,NULL,'666dc0a4b20f4516848839ff84c05013',NULL,NULL,NULL,NULL,'2025-12-03 22:56:53',NULL,'2025-12-03 22:56:53',NULL,NULL),(237,NULL,'6abf3bcf0046445a804c54d668ccdbc6',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:56:54',NULL,'2025-12-03 22:56:54',NULL,NULL),(238,NULL,'e4205a329b2c4a51b34c38688dd2ac01',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:56:55',NULL,'2025-12-03 22:56:55',NULL,NULL),(239,NULL,'c510a8e8115743f3a8995e5ab990f86d',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:56:56',NULL,'2025-12-03 22:56:56',NULL,NULL),(240,NULL,NULL,'973c46d6fb5e49898e1694e673e032c7',NULL,NULL,NULL,NULL,'2025-12-03 22:57:06',NULL,'2025-12-03 22:57:06',NULL,NULL),(241,NULL,NULL,'0674a24dd9184608a6d1d00877859cc7',NULL,NULL,NULL,NULL,'2025-12-03 22:57:06',NULL,'2025-12-03 22:57:06',NULL,NULL),(242,NULL,NULL,'67b9835ed75344ec98d4421c81cc73e4',NULL,NULL,NULL,NULL,'2025-12-03 22:57:06',NULL,'2025-12-03 22:57:06',NULL,NULL),(243,NULL,NULL,'5c4717d799b845d7a495cdec998eb4b4',NULL,NULL,NULL,NULL,'2025-12-03 22:57:07',NULL,'2025-12-03 22:57:07',NULL,NULL),(244,NULL,'dbb2710d867347c5b4a3eeb47ef0e6a0',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:57:07',NULL,'2025-12-03 22:57:07',NULL,NULL),(245,NULL,'17caf3595e89451baa10bb7e15e8a036',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:57:08',NULL,'2025-12-03 22:57:08',NULL,NULL),(246,NULL,'ae1ebf853bc3410fa146f01289e8a0ca',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:57:08',NULL,'2025-12-03 22:57:08',NULL,NULL),(247,NULL,'abb84de7ce31470ab8213e9aa033fcbe',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:57:09',NULL,'2025-12-03 22:57:09',NULL,NULL),(248,NULL,NULL,'47008815b13f4a379de6cf76e53687bb',NULL,NULL,NULL,NULL,'2025-12-03 22:57:27',NULL,'2025-12-03 22:57:27',NULL,NULL),(249,NULL,NULL,'ca9fac55313c40be8af5afe4a0b81bf9',NULL,NULL,NULL,NULL,'2025-12-03 22:57:27',NULL,'2025-12-03 22:57:27',NULL,NULL),(250,NULL,NULL,'b9f8cd3495c845cdbff03fe5db99b610',NULL,NULL,NULL,NULL,'2025-12-03 22:57:27',NULL,'2025-12-03 22:57:27',NULL,NULL),(251,NULL,'e9ddfa98f88a4aac949fc924e21d615a',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:57:29',NULL,'2025-12-03 22:57:29',NULL,NULL),(252,NULL,'cda0dc998c7f45a386f172f03b24708e',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:57:31',NULL,'2025-12-03 22:57:31',NULL,NULL),(253,NULL,'52f6c8d2e22847d7866150f41c54ced1',NULL,NULL,NULL,NULL,NULL,'2025-12-03 22:57:32',NULL,'2025-12-03 22:57:32',NULL,NULL),(254,NULL,NULL,'c210c585120043549f62ccb01cec9817',NULL,NULL,NULL,NULL,'2025-12-03 23:01:56',NULL,'2025-12-03 23:01:56',NULL,NULL),(255,NULL,NULL,'eaf56a57e81343718ad3783fce81d128',NULL,NULL,NULL,NULL,'2025-12-03 23:01:56',NULL,'2025-12-03 23:01:56',NULL,NULL),(256,NULL,'22c057c39a054d8697ee9de37f5e2c32',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:01:56',NULL,'2025-12-03 23:01:56',NULL,NULL),(257,NULL,'26d36ac1678744fabdbe8d702fccfb9d',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:01:57',NULL,'2025-12-03 23:01:57',NULL,NULL),(258,NULL,NULL,'811f72730dd14e429b7343a2286cfde0',NULL,NULL,NULL,NULL,'2025-12-03 23:02:35',NULL,'2025-12-03 23:02:35',NULL,NULL),(259,NULL,NULL,'3fd86bba3e944275909d3dbb21d4dbc0',NULL,NULL,NULL,NULL,'2025-12-03 23:02:35',NULL,'2025-12-03 23:02:35',NULL,NULL),(260,NULL,'2407815f69fb4ffa8636b95712d4d760',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:02:35',NULL,'2025-12-03 23:02:35',NULL,NULL),(261,NULL,'9bf6771e795f41a4b232098116b975b1',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:02:36',NULL,'2025-12-03 23:02:36',NULL,NULL),(262,NULL,NULL,'c89fc057f1c54b10b211404f170223fb',NULL,NULL,NULL,NULL,'2025-12-03 23:08:05',NULL,'2025-12-03 23:08:05',NULL,NULL),(263,NULL,NULL,'6857a2e7db224a81b3941b9f49242e41',NULL,NULL,NULL,NULL,'2025-12-03 23:08:05',NULL,'2025-12-03 23:08:05',NULL,NULL),(264,NULL,'fa8b510e27fa41689c0a609860cbc171',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:08:07',NULL,'2025-12-03 23:08:07',NULL,NULL),(265,NULL,'3989de3c2cf844418cdd96de2dc55a66',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:08:08',NULL,'2025-12-03 23:08:08',NULL,NULL),(266,NULL,NULL,'5fbcdb66523a4207a1ca67b715ecf389',NULL,NULL,NULL,NULL,'2025-12-03 23:12:53',NULL,'2025-12-03 23:12:53',NULL,NULL),(267,NULL,NULL,'f13ca3cbb72742db8ac2b3b15e08ec80',NULL,NULL,NULL,NULL,'2025-12-03 23:12:53',NULL,'2025-12-03 23:12:53',NULL,NULL),(268,NULL,'3113e7b4a32d488aa794bfb1290e620b',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:12:55',NULL,'2025-12-03 23:12:55',NULL,NULL),(269,NULL,'5f45986fc95543d5a0014e214c498f28',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:12:57',NULL,'2025-12-03 23:12:57',NULL,NULL),(270,NULL,NULL,'2539b37a97c744c386a7fc680a4cd3a7',NULL,NULL,NULL,NULL,'2025-12-03 23:15:20',NULL,'2025-12-03 23:15:20',NULL,NULL),(271,NULL,NULL,'7850e2c011a647aaad54e05b53c0fe54',NULL,NULL,NULL,NULL,'2025-12-03 23:15:20',NULL,'2025-12-03 23:15:20',NULL,NULL),(272,NULL,'4d6220adca01441899d635b708f8ab85',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:15:21',NULL,'2025-12-03 23:15:21',NULL,NULL),(273,NULL,'5c73b76d928d4467989a8e2e395bb892',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:15:22',NULL,'2025-12-03 23:15:22',NULL,NULL),(274,NULL,NULL,'6c4a705892cc42cfbedfe3de1504c143',NULL,NULL,NULL,NULL,'2025-12-03 23:18:15',NULL,'2025-12-03 23:18:15',NULL,NULL),(275,NULL,NULL,'11edf0dabc364964a97be8ae2527ee14',NULL,NULL,NULL,NULL,'2025-12-03 23:18:16',NULL,'2025-12-03 23:18:16',NULL,NULL),(276,NULL,'0ebc213514c247388f90f7a4b0b39e1e',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:18:17',NULL,'2025-12-03 23:18:17',NULL,NULL),(277,NULL,'36d068bfb4984dcb89b830d0aa30be15',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:18:18',NULL,'2025-12-03 23:18:18',NULL,NULL),(278,NULL,NULL,'26c99312872e462f9fcc402116b69c78',NULL,NULL,NULL,NULL,'2025-12-03 23:19:23',NULL,'2025-12-03 23:19:23',NULL,NULL),(279,NULL,NULL,'758f4f1090cf4431ad3101bfd8efed25',NULL,NULL,NULL,NULL,'2025-12-03 23:19:23',NULL,'2025-12-03 23:19:23',NULL,NULL),(280,NULL,'e014ab433f1c45e4bdfa23184aca2555',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:19:24',NULL,'2025-12-03 23:19:24',NULL,NULL),(281,NULL,'7ecf0b1cff1c4aa4b3be33769da7f6d1',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:19:25',NULL,'2025-12-03 23:19:25',NULL,NULL),(282,NULL,NULL,'20e92b2fdb464ec3a95622fa11c193d3',NULL,NULL,NULL,NULL,'2025-12-03 23:23:31',NULL,'2025-12-03 23:23:31',NULL,NULL),(283,NULL,NULL,'c54e6f2bcabb4751be65c044ebf58a5c',NULL,NULL,NULL,NULL,'2025-12-03 23:23:31',NULL,'2025-12-03 23:23:31',NULL,NULL),(284,NULL,'392542f6ffae4fd4801c87a6dbbba04a',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:23:33',NULL,'2025-12-03 23:23:33',NULL,NULL),(285,NULL,'8edcb9e8bd074a6db5931da8d1e0eeb5',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:23:35',NULL,'2025-12-03 23:23:35',NULL,NULL),(286,NULL,NULL,'a790f8cb047e47538fae6cd3d44b528c',NULL,NULL,NULL,NULL,'2025-12-03 23:23:39',NULL,'2025-12-03 23:23:39',NULL,NULL),(287,NULL,NULL,'f0c49d8076244a93a13cc6bdb5e6fd12',NULL,NULL,NULL,NULL,'2025-12-03 23:23:39',NULL,'2025-12-03 23:23:39',NULL,NULL),(288,NULL,'da54137f2da143fca9b22841ffc645b4',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:23:41',NULL,'2025-12-03 23:23:41',NULL,NULL),(289,NULL,'f083ad12be4e4097aa571b8633c25960',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:23:42',NULL,'2025-12-03 23:23:42',NULL,NULL),(290,NULL,NULL,'c38142631cfe422a921dfe4f854b4c60',NULL,NULL,NULL,NULL,'2025-12-03 23:32:15',NULL,'2025-12-03 23:32:15',NULL,NULL),(291,NULL,NULL,'29ee038ef7a14f57a151d7ab44891582',NULL,NULL,NULL,NULL,'2025-12-03 23:32:15',NULL,'2025-12-03 23:32:15',NULL,NULL),(292,NULL,NULL,'6599744efd2248788b4d5cb36f30a729',NULL,NULL,NULL,NULL,'2025-12-03 23:32:15',NULL,'2025-12-03 23:32:15',NULL,NULL),(293,NULL,'2acbb37228214c408b218b31d6d0f830',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:32:17',NULL,'2025-12-03 23:32:17',NULL,NULL),(294,NULL,'187a1cbe79574a0bb8074b8a7d039dc7',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:32:18',NULL,'2025-12-03 23:32:18',NULL,NULL),(295,NULL,'5912f137b1b64b9589d4ffa9287bb984',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:32:19',NULL,'2025-12-03 23:32:19',NULL,NULL),(296,NULL,NULL,'562adaac81824180a41f0757e2b448ee',NULL,NULL,NULL,NULL,'2025-12-03 23:40:10',NULL,'2025-12-03 23:40:10',NULL,NULL),(297,NULL,NULL,'d93bce4dd1464a339c534362004ddfc1',NULL,NULL,NULL,NULL,'2025-12-03 23:40:10',NULL,'2025-12-03 23:40:10',NULL,NULL),(298,NULL,'17135a905ddc412883361a7397e2e39c',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:40:11',NULL,'2025-12-03 23:40:11',NULL,NULL),(299,NULL,'57ba084f5cba49d59d4694d7d8939563',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:40:11',NULL,'2025-12-03 23:40:11',NULL,NULL),(300,NULL,NULL,'ecca011520524ca2b0dda4a3f90ea632',NULL,NULL,NULL,NULL,'2025-12-03 23:41:28',NULL,'2025-12-03 23:41:28',NULL,NULL),(301,NULL,NULL,'5c2f8ef607d3401ba57a5a577c68cc04',NULL,NULL,NULL,NULL,'2025-12-03 23:41:28',NULL,'2025-12-03 23:41:28',NULL,NULL),(302,NULL,'ae8969323e1249818e8f28cdce601dea',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:41:29',NULL,'2025-12-03 23:41:29',NULL,NULL),(303,NULL,'736cfa939ed54e37b1dae7d67c7093e6',NULL,NULL,NULL,NULL,NULL,'2025-12-03 23:41:30',NULL,'2025-12-03 23:41:30',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('39ff283961d549e4888a0ec8b42070c6','swiftoperator','{}','<<null>>',NULL),('462e02cc92ba4a129f55a5872ac64386','SwiftSystemReader','{}','<<null>>',NULL),('563c6312ce444f79b731961a5e9dbc18','admin','{}','<<null>>',NULL),('6f9d2dcd57aa488d857b72031a5ff2f7','SwiftProjectReader','{}','<<null>>',NULL),('748b109ef5674528ae4915a3f5d65a86','ResellerAdmin','{}','<<null>>',NULL),('8325bacc3d764ab7b6beb4b9ddfc92d3','service','{}','<<null>>',NULL),('c31e33e5de1c492b88b1cf7e89a2a5bd','member','{}','<<null>>',NULL),('d7e9d57d77b446e380c76f6eb735f008','reader','{}','<<null>>',NULL),('db24b8862b1a41eab8a7c0239dd0af65','heat_stack_user','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('563c6312ce444f79b731961a5e9dbc18','IMMU','true'),('c31e33e5de1c492b88b1cf7e89a2a5bd','IMMU','true'),('d7e9d57d77b446e380c76f6eb735f008','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('3ad63fded6894b7c9327af339287ef45','orchestration',1,'{\"description\": \"Heat API service\", \"name\": \"heat\"}'),('4278e8473bd64ac79f334c1dacd9ead3','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('5fa748def03844f5a69f72b7a588f5f1','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('61717597aaaa4c91b908676809a28d04','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('752915ad7e4b4cfd847af0fda281f62b','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('7c566ab40f4d496e97cf50d499920501','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('a82c87bcf12a4d7093f90e4096aa7f19','cloudformation',1,'{\"description\": \"Heat Cloudformation API service\", \"name\": \"heat-cfn\"}'),('a94bf68096db44e8b9245fe26cce0817','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('b007b645f9044c4ba892f6e4a1f0faf5','alarming',1,'{\"description\": \"Aodh for autoscaling Service\", \"name\": \"aodh\"}'),('be65e3d002cd4bf5aad47679e4b7bad3','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('cda58a89c81845c9b843f99ed550c705','load-balancer',1,'{\"description\": \"Octavia Service\", \"name\": \"octavia\"}'),('d2687e3bec014b8fa344c2a6a1757fcb','identity',1,'{\"name\": \"keystone\"}'),('f0ac45ef0214449c9dcc7f31f4351258','object-store',1,'{\"description\": \"Swift Object Storage\", \"name\": \"swift\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','f02d735f9c704b2e8bde78ca5e15c788','system','563c6312ce444f79b731961a5e9dbc18',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_user_id` (`user_id`),
  KEY `ix_token_trust_id` (`trust_id`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_expires` (`expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
INSERT INTO `trust_role` (`trust_id`, `role_id`) VALUES ('6e49c47eebd9409f864f5db997e447c9','04505272edd0442993743668b80304bd');
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('43adc31c21d345b8ac08a01f5aa08929','{}',1,'287bb4deac5947ca983293ae47928819','2025-12-03 22:26:32','2025-12-03','default'),('50ec2e8535db48c39e3558cb0dfee35c','{}',1,'287bb4deac5947ca983293ae47928819','2025-12-03 22:26:16','2025-12-03','default'),('5f5dc25cf83a47a0817c768e7601bb22','{}',1,'287bb4deac5947ca983293ae47928819','2025-12-03 22:27:41',NULL,'default'),('6301cba904174eca840f9d74c4ce7273','{}',1,'287bb4deac5947ca983293ae47928819','2025-12-03 22:26:53','2025-12-03','default'),('6ff04a48fc27407182d63a1211f2359d','{}',1,'287bb4deac5947ca983293ae47928819','2025-12-03 22:26:28','2025-12-03','default'),('8c3aef96126f47b49d7cf9954a203662','{}',1,'287bb4deac5947ca983293ae47928819','2025-12-03 22:29:51','2025-12-03','default'),('ab0f36b1258c48a29c07f01889f62554','{}',1,'287bb4deac5947ca983293ae47928819','2025-12-03 22:27:06','2025-12-03','default'),('af7abaab325e41e7a00f222909ab37f2','{}',1,'287bb4deac5947ca983293ae47928819','2025-12-03 22:26:09','2025-12-03','default'),('c2d6654e7a9b4e46b16813084bc5ab94','{}',1,'287bb4deac5947ca983293ae47928819','2025-12-03 22:26:44','2025-12-03','default'),('d13984bf328f459bb9809cc7ce6d5742','{}',1,'287bb4deac5947ca983293ae47928819','2025-12-03 22:26:20','2025-12-03','default'),('d774a047c2a34cb4a7855c76dc880720','{\"tenantId\": \"58bb5488538843998338914be63d5017\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2025-12-03 22:49:34',NULL,'default'),('d87ba3f0156c4497bd935576d0e8f8cd','{\"tenantId\": \"86b65474d4544ed68efb10a9bb276b2d\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2025-12-03 22:49:33','2025-12-03','default'),('d9876f1f4419445ca56487301512b1e1','{}',1,NULL,'2025-12-03 22:26:22',NULL,'964cab5a794342a6a87fe6400d740537'),('f02d735f9c704b2e8bde78ca5e15c788','{}',1,NULL,'2025-12-03 22:24:52','2025-12-03','default'),('ff9e7238d29c4bf1b4d67a95d8aa4dc7','{}',1,'287bb4deac5947ca983293ae47928819','2025-12-03 22:26:23','2025-12-03','default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','glance','glance_84f8','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_84f8','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','placement','placement_0ba6','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_0ba6','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','keystone','keystone_2d6c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_2d6c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','heat','heat_113a','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','heat','heat_113a','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_d991','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_d991','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_0539','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_0539','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_a73c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_a73c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_e258','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_e258','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_3ad6','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_3ad6','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','aodh','aodh_3663','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','aodh','aodh_3663','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','octavia','octavia_ce39','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','octavia','octavia_ce39','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','octavia_persistence','octavia_c786','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','octavia_persistence','octavia_c786','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1764800616}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1764800616}'),('localhost','glance_84f8','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*19977E1E53A1D2FDA1DE766EC389CD646162E252\",\"password_last_changed\":1764800629}'),('localhost','placement_0ba6','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*BC6DB017143CF12D27A58D401070422123EBDA85\",\"password_last_changed\":1764800629}'),('%','glance_84f8','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*19977E1E53A1D2FDA1DE766EC389CD646162E252\",\"password_last_changed\":1764800629}'),('%','placement_0ba6','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*BC6DB017143CF12D27A58D401070422123EBDA85\",\"password_last_changed\":1764800629}'),('localhost','keystone_2d6c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*E8530B912AF507DC2AAFBED91B2BC9B28F234C38\",\"password_last_changed\":1764800638}'),('%','keystone_2d6c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*E8530B912AF507DC2AAFBED91B2BC9B28F234C38\",\"password_last_changed\":1764800638}'),('localhost','heat_113a','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*16418903ED5A9333BD17F3616FDD49E2C604D6F1\",\"password_last_changed\":1764800671}'),('%','heat_113a','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*16418903ED5A9333BD17F3616FDD49E2C604D6F1\",\"password_last_changed\":1764800671}'),('localhost','neutron_d991','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*0A9F4AD5F4ABE4A1F581882D036A71BD3BBF2F73\",\"password_last_changed\":1764800672}'),('%','neutron_d991','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*0A9F4AD5F4ABE4A1F581882D036A71BD3BBF2F73\",\"password_last_changed\":1764800672}'),('localhost','cinder_0539','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*0FF9F8FA2A78F58BB8FF2D2DEB08A23669E19642\",\"password_last_changed\":1764800672}'),('%','cinder_0539','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*0FF9F8FA2A78F58BB8FF2D2DEB08A23669E19642\",\"password_last_changed\":1764800672}'),('localhost','barbican_a73c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*C7684AE88B9B95F2591AE683F409E7559096624A\",\"password_last_changed\":1764800672}'),('%','barbican_a73c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*C7684AE88B9B95F2591AE683F409E7559096624A\",\"password_last_changed\":1764800672}'),('localhost','nova_cell0_e258','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*50A091197C03B88F6DEDE6D1EBD2B06E671EAF08\",\"password_last_changed\":1764800804}'),('%','nova_cell0_e258','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*50A091197C03B88F6DEDE6D1EBD2B06E671EAF08\",\"password_last_changed\":1764800804}'),('localhost','nova_api_3ad6','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*2295E45AE6629FB80E111615B2FB8598466DDF48\",\"password_last_changed\":1764800804}'),('%','nova_api_3ad6','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*2295E45AE6629FB80E111615B2FB8598466DDF48\",\"password_last_changed\":1764800804}'),('localhost','aodh_3663','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*132B2A70D175248E2E3B359B48BBF7EC352B2481\",\"password_last_changed\":1764800850}'),('%','aodh_3663','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*132B2A70D175248E2E3B359B48BBF7EC352B2481\",\"password_last_changed\":1764800850}'),('localhost','octavia_ce39','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*6F91B7D0294967F18B658C54515B29024B9E55AE\",\"password_last_changed\":1764800973}'),('%','octavia_ce39','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*6F91B7D0294967F18B658C54515B29024B9E55AE\",\"password_last_changed\":1764800973}'),('localhost','octavia_c786','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B999EAAE80089DC8E4110FFE8373A52360EC5B00\",\"password_last_changed\":1764800981}'),('%','octavia_c786','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B999EAAE80089DC8E4110FFE8373A52360EC5B00\",\"password_last_changed\":1764800981}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mysql_plugin\n-------------------------------------\n\nA plugin can be installed with the mysql_plugin utility if the server is\ncompletely offline.\n\nThe syntax is:\n\nmysql_plugin [options] <plugin> ENABLE|DISABLE\n\nFor example, to install the server_audit audit plugin, you could execute the\nfollowing:\n\nmysql_plugin server_audit ENABLE\n\nIf a plugin is installed with this utility, then a record will be added to the\nmysql.plugins table for the plugin. This means that the plugin will\nautomatically be loaded every time the server restarts, unless specifically\nuninstalled or deactivated.\n\nConfiguring the Plugin Directory\n--------------------------------\n\nWhen a plugin is being installed, the server looks for the plugin\'s library in\nthe server\'s plugin directory. This directory is configured by the plugin_dir\nsystem variable. This can be specified as a command-line argument to mysqld or\nit can be specified in a relevant server option group in an option file. For\nexample:\n\n[mariadb]\n...\nplugin_dir = /usr/lib64/mysql/plugin\n\nConfiguring the Minimum Plugin Maturity\n---------------------------------------\n\nWhen a plugin is being installed, the server compares the plugin\'s maturity\nlevel against the server\'s minimum allowed plugin maturity. This can help\nprevent users from using unstable plugins on production servers. This minimum\nplugin maturity is configured by the plugin_maturity system variable. This can\nbe specified as a command-line argument to mysqld or it can be specified in a\nrelevant server option group in an option file. For example:\n\n[mariadb]\n...\nplugin_maturity = stable\n\nConfiguring Plugin Activation at Server Startup\n-----------------------------------------------\n\nA plugin will be loaded by default when the server starts if:\n\n* The plugin was installed with the INSTALL SONAME statement.\n* The plugin was installed with the INSTALL PLUGIN statement.\n* The plugin was installed with the mysql_plugin utility.\n* The server is configured to load the plugin with the --plugin-load-add\noption.\n* The server is configured to load the plugin with the --plugin-load option.\n\nThis behavior can be changed with special options that take the form\n--plugin-name. For example, for the server_audit audit plugin, the special\noption is called --server-audit.\n\nThe possible values for these special options are:\n\n+---------------------------------------+------------------------------------+\n| Option Value                          | Description                        |\n+---------------------------------------+------------------------------------+\n| OFF                                   | Disables the plugin without        |\n|                                       | removing it from the               |\n|                                       | mysql.plugins table.               |\n+---------------------------------------+------------------------------------+\n| ON                                    | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will still continue         |\n|                                       | starting up, but the plugin will   |\n|                                       | be disabled.                       |\n+---------------------------------------+------------------------------------+\n| FORCE                                 | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error.                             |\n+---------------------------------------+------------------------------------+\n| FORCE_PLUS_PERMANENT                  | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error. In addition, the plugin     |\n|                                       | cannot be uninstalled with         |\n|                                       | UNINSTALL SONAME or UNINSTALL      |\n|                                       | PLUGIN while the server is         |\n|                                       | running.                           |\n+---------------------------------------+------------------------------------+\n\nA plugin\'s status can be found by looking at the PLUGIN_STATUS column of the\ninformation_schema.PLUGINS table.\n\nUninstalling Plugins\n--------------------\n\nPlugins that are found in the mysql.plugin table, that is those that were\ninstalled with INSTALL SONAME, INSTALL PLUGIN or mysql_plugin can be\nuninstalled in one of two ways:\n\n* The UNINSTALL SONAME or the UNINSTALL PLUGIN statement while the server is\nrunning\n* With mysql_plugin while the server is offline.\n\nPlugins that were enabled as a --plugin-load option do not need to be\nuninstalled. If --plugin-load is omitted the next time the server starts, or\nthe plugin is not listed as one of the --plugin-load entries, the plugin will\nnot be loaded.\n\nUNINSTALL PLUGIN uninstalls a single installed plugin, while UNINSTALL SONAME\nuninstalls all plugins belonging to a given library.\n\nURL: https://mariadb.com/kb/en/plugin-overview/','','https://mariadb.com/kb/en/plugin-overview/'),(79,'MBR Definition',6,'Description\n-----------\n\nThe MBR (Minimum Bounding Rectangle), or Envelope is the bounding geometry,\nformed by the minimum and maximum (X,Y) coordinates:\n\nExamples\n--------\n\n((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nURL: https://mariadb.com/kb/en/mbr-definition/','','https://mariadb.com/kb/en/mbr-definition/'),(80,'MBRContains',6,'Syntax\n------\n\nMBRContains(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\ncontains the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\n\nSET @g2 = GeomFromText(\'Point(1 1)\');\n\nSELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n+----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrcontains/','','https://mariadb.com/kb/en/mbrcontains/'),(82,'MBREqual',6,'Syntax\n------\n\nMBREqual(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are the same.\n\nExamples\n--------\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 2)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 2, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 3)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 4, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 0 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/mbrequal/','','https://mariadb.com/kb/en/mbrequal/'),(86,'MBRWithin',6,'Syntax\n------\n\nMBRWithin(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1 is\nwithin the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRContains().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nSELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n\nURL: https://mariadb.com/kb/en/mbrwithin/','','https://mariadb.com/kb/en/mbrwithin/'),(75,'UNINSTALL PLUGIN',5,'Syntax\n------\n\nUNINSTALL PLUGIN [IF EXISTS] plugin_name\n\nDescription\n-----------\n\nThis statement removes a single installed plugin. To uninstall the whole\nlibrary which contains the plugin, use UNINSTALL SONAME. You cannot uninstall\na plugin if any table that uses it is open.\n\nplugin_name must be the name of some plugin that is listed in the mysql.plugin\ntable. The server executes the plugin\'s deinitialization function and removes\nthe row for the plugin from the mysql.plugin table, so that subsequent server\nrestarts will not load and initialize the plugin. UNINSTALL PLUGIN does not\nremove the plugin\'s shared library file.\n\nTo use UNINSTALL PLUGIN, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nUNINSTALL PLUGIN example;\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------+\n| Level | Code | Message                       |\n+-------+------+-------------------------------+\n| Note  | 1305 | PLUGIN example does not exist |\n+-------+------+-------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-plugin/','','https://mariadb.com/kb/en/uninstall-plugin/'),(76,'INSTALL SONAME',5,'Syntax\n------\n\nINSTALL SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of INSTALL PLUGIN. It installs all plugins from a\ngiven plugin_library. See INSTALL PLUGIN for details.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL SONAME adds one or more lines to the mysql.plugin table that describes\nthe plugin. This table contains the plugin name and library file name.\n\nINSTALL SONAME causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL SONAME also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL SONAME, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nSONAME only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nIf you need to install only one plugin from a library, use the INSTALL PLUGIN\nstatement.\n\nExamples\n--------\n\nTo load the XtraDB storage engine and all of its information_schema tables\nwith one statement, use\n\nINSTALL SONAME \'ha_xtradb\';\n\nThis statement can be used instead of INSTALL PLUGIN even when the library\ncontains only one plugin:\n\nINSTALL SONAME \'ha_sequence\';\n\nURL: https://mariadb.com/kb/en/install-soname/','','https://mariadb.com/kb/en/install-soname/'),(77,'UNINSTALL SONAME',5,'Syntax\n------\n\nUNINSTALL SONAME  [IF EXISTS] \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of UNINSTALL PLUGIN statement, that removes all\nplugins belonging to a specified plugin_library. See UNINSTALL PLUGIN for\ndetails.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nTo use UNINSTALL SONAME, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin library does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nTo uninstall the XtraDB plugin and all of its information_schema tables with\none statement, use\n\nUNINSTALL SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------------+\n| Level | Code | Message                             |\n+-------+------+-------------------------------------+\n| Note  | 1305 | SONAME ha_example.so does not exist |\n+-------+------+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-soname/','','https://mariadb.com/kb/en/uninstall-soname/'),(90,'NULLIF',7,'Syntax\n------\n\nNULLIF(expr1,expr2)\n\nDescription\n-----------\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is the\nsame as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nExamples\n--------\n\nSELECT NULLIF(1,1);\n+-------------+\n| NULLIF(1,1) |\n+-------------+\n|        NULL |\n+-------------+\n\nSELECT NULLIF(1,2);\n+-------------+\n| NULLIF(1,2) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/nullif/','','https://mariadb.com/kb/en/nullif/'),(91,'NVL',7,'MariaDB starting with 10.3\n--------------------------\nFrom MariaDB 10.3, NVL is a synonym for IFNULL.\n\nURL: https://mariadb.com/kb/en/nvl/','','https://mariadb.com/kb/en/nvl/'),(92,'NVL2',7,'MariaDB starting with 10.3\n--------------------------\nThe NLV2 function was introduced in MariaDB 10.3.0.\n\nSyntax\n------\n\nNVL2(expr1,expr2,expr3)\n\nDescription\n-----------\n\nThe NVL2 function returns a value based on whether a specified expression is\nNULL or not. If expr1 is not NULL, then NVL2 returns expr2. If expr1 is NULL,\nthen NVL2 returns expr3.\n\nExamples\n--------\n\nSELECT NVL2(NULL,1,2);\n+----------------+\n| NVL2(NULL,1,2) |\n+----------------+\n|              2 |\n+----------------+\n\nSELECT NVL2(\'x\',1,2);\n+---------------+\n| NVL2(\'x\',1,2) |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/nvl2/','','https://mariadb.com/kb/en/nvl2/'),(81,'MBRDisjoint',6,'Syntax\n------\n\nMBRDisjoint(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are disjoint. Two geometries are disjoint if they do not\nintersect, that is touch or overlap.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECTmbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrdisjoint/','','https://mariadb.com/kb/en/mbrdisjoint/'),(83,'MBRIntersects',6,'Syntax\n------\n\nMBRIntersects(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 intersect.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      1 |\n+------------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      0 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/mbrintersects/','','https://mariadb.com/kb/en/mbrintersects/'),(84,'MBROverlaps',6,'Syntax\n------\n\nMBROverlaps(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 overlap. The term spatially overlaps is used if two\ngeometries intersect and their intersection results in a geometry of the same\ndimension but not equal to either of the given geometries.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbroverlaps/','','https://mariadb.com/kb/en/mbroverlaps/'),(85,'MBRTouches',6,'Syntax\n------\n\nMBRTouches(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 touch. Two geometries spatially touch if the interiors of\nthe geometries do not intersect, but the boundary of one of the geometries\nintersects either the boundary or the interior of the other.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   1 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/mbrtouches/','','https://mariadb.com/kb/en/mbrtouches/'),(87,'CASE OPERATOR',7,'Syntax\n------\n\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nDescription\n-----------\n\nThe first version returns the result where value=compare_value. The second\nversion returns the result for the first condition that is true. If there was\nno matching result value, the result after ELSE is returned, or NULL if there\nis no ELSE part.\n\nThere is also a CASE statement, which differs from the CASE operator described\nhere.\n\nExamples\n--------\n\nSELECT CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END;\n+------------------------------------------------------------+\n| CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END |\n+------------------------------------------------------------+\n| one                                                        |\n+------------------------------------------------------------+\n\nSELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n+--------------------------------------------+\n| CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END |\n+--------------------------------------------+\n| true                                       |\n+--------------------------------------------+\n\nSELECT CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n+-----------------------------------------------------+\n| CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END |\n+-----------------------------------------------------+\n|                                                NULL |\n+-----------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/case-operator/','','https://mariadb.com/kb/en/case-operator/'),(101,'UNLOCK TABLES',8,'Syntax\n------\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\nSee LOCK TABLES for more information.\n\nIn addition to releasing table locks acquired by the LOCK TABLES statement,\nthe UNLOCK TABLES statement also releases the global read lock acquired by the\nFLUSH TABLES WITH READ LOCK statement. The FLUSH TABLES WITH READ LOCK\nstatement is very useful for performing backups. See FLUSH for more\ninformation about FLUSH TABLES WITH READ LOCK.\n\nURL: https://mariadb.com/kb/en/transactions-unlock-tables/','','https://mariadb.com/kb/en/transactions-unlock-tables/'),(103,'XA Transactions',8,'Overview\n--------\n\nThe MariaDB XA implementation is based on the X/Open CAE document Distributed\nTransaction Processing: The XA Specification. This document is published by\nThe Open Group and available at\nhttp://www.opengroup.org/public/pubs/catalog/c193.htm.\n\nXA transactions are designed to allow distributed transactions, where a\ntransaction manager (the application) controls a transaction which involves\nmultiple resources. Such resources are usually DBMSs, but could be resources\nof any type. The whole set of required transactional operations is called a\nglobal transaction. Each subset of operations which involve a single resource\nis called a local transaction. XA used a 2-phases commit (2PC). With the first\ncommit, the transaction manager tells each resource to prepare an effective\ncommit, and waits for a confirm message. The changes are not still made\neffective at this point. If any of the resources encountered an error, the\ntransaction manager will rollback the global transaction. If all resources\ncommunicate that the first commit is successful, the transaction manager can\nrequire a second commit, which makes the changes effective.\n\nIn MariaDB, XA transactions can only be used with storage engines that support\nthem. At least InnoDB, TokuDB, SPIDER and MyRocks support them. For InnoDB,\nuntil MariaDB 10.2, XA transactions can be disabled by setting the\ninnodb_support_xa server system variable to 0. From MariaDB 10.3, XA\ntransactions are always supported.\n\nLike regular transactions, XA transactions create metadata locks on accessed\ntables.\n\nXA transactions require REPEATABLE READ as a minimum isolation level. However,\ndistributed transactions should always use SERIALIZABLE.\n\nTrying to start more than one XA transaction at the same time produces a 1400\nerror (SQLSTATE \'XAE09\'). The same error is produced when attempting to start\nan XA transaction while a regular transaction is in effect. Trying to start a\nregular transaction while an XA transaction is in effect produces a 1399 error\n(SQLSTATE \'XAE07\').\n\nThe statements that cause an implicit COMMIT for regular transactions produce\na 1400 error (SQLSTATE \'XAE09\') if a XA transaction is in effect.\n\nInternal XA vs External XA\n--------------------------\n\nXA transactions are an overloaded term in MariaDB. If a storage engine is\nXA-capable, it can mean one or both of these:\n\n* It supports MariaDB\'s internal two-phase commit API. This is transparent to\nthe user. Sometimes this is called \"internal XA\", since MariaDB\'s internal\ntransaction coordinator log can handle coordinating these transactions.\n\n* It supports XA transactions, with the XA START, XA PREPARE, XA COMMIT, etc.\nstatements. Sometimes this is called \"external XA\", since it requires the use\nof an external transaction coordinator to use this feature properly.\n\nTransaction Coordinator Log\n---------------------------\n\nIf you have two or more XA-capable storage engines enabled, then a transaction\ncoordinator log must be available.\n\nThere are currently two implementations of the transaction coordinator log:\n\n* Binary log-based transaction coordinator log\n* Memory-mapped file-based transaction coordinator log\n\nIf the binary log is enabled on a server, then the server will use the binary\nlog-based transaction coordinator log. Otherwise, it will use the\nmemory-mapped file-based transaction coordinator log.\n\nSee Transaction Coordinator Log for more information.\n\nSyntax\n------\n\nXA {START|BEGIN} xid [JOIN|RESUME]\n\nXA END xid [SUSPEND [FOR MIGRATE]]\n\nXA PREPARE xid\n\nXA COMMIT xid [ONE PHASE]\n\nXA ROLLBACK xid\n\nXA RECOVER [FORMAT=[\'RAW\'|\'SQL\']]\n\nxid: gtrid [, bqual [, formatID ]]\n\nThe interface to XA transactions is a set of SQL statements starting with XA.\nEach statement changes a transaction\'s state, determining which actions it can\nperform. A transaction which does not exist is in the NON-EXISTING state.\n\nXA START (or BEGIN) starts a transaction and defines its xid (a transaction\nidentifier). The JOIN or RESUME keywords have no effect. The new transaction\nwill be in ACTIVE state.\n\nThe xid can have 3 components, though only the first one is mandatory. gtrid\nis a quoted string representing a global transaction identifier. bqual is a\nquoted string representing a local transaction identifier. formatID is an\nunsigned integer indicating the format used for the first two components; if\nnot specified, defaults to 1. MariaDB does not interpret in any way these\ncomponents, and only uses them to identify a transaction. xids of transactions\nin effect must be unique.\n\nXA END declares that the specified ACTIVE transaction is finished and it\nchanges its state to IDLE. SUSPEND [FOR MIGRATE] has no effect.\n\nXA PREPARE prepares an IDLE transaction for commit, changing its state to\nPREPARED. This is the first commit.\n\nXA COMMIT definitely commits and terminates a transaction which has already\nbeen PREPARED. If the ONE PHASE clause is specified, this statements performs\na 1-phase commit on an IDLE transaction.\n\nXA ROLLBACK rolls back and terminates an IDLE or PREPARED transaction.\n\nXA RECOVER shows information about all PREPARED transactions.\n\nWhen trying to execute an operation which is not allowed for the transaction\'s\ncurrent state, an error is produced:\n\nXA COMMIT \'test\' ONE PHASE;\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  ACTIVE state\n\nXA COMMIT \'test2\';\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  NON-EXISTING state\n\nXA RECOVER\n----------\n\nThe XA RECOVER statement shows information about all transactions which are in\nthe PREPARED state. It does not matter which connection created the\ntransaction: if it has been PREPARED, it appears. But this does not mean that\na connection can commit or rollback a transaction which was started by another\nconnection. Note that transactions using a 1-phase commit are never in the\nPREPARED state, so they cannot be shown by XA RECOVER.\n\nXA RECOVER produces four columns:\n\nXA RECOVER;\n+----------+--------------+--------------+------+\n| formatID | gtrid_length | bqual_length | data |\n+----------+--------------+--------------+------+\n|        1 |            4 |            0 | test |\n+----------+--------------+--------------+------+\n\nMariaDB starting with 10.3.3\n----------------------------\nYou can use XA RECOVER FORMAT=\'SQL\' to get the data in a human readable form\nthat can be directly copy-pasted into XA COMMIT or XA ROLLBACK. This is\nparticularly useful for binary xid generated by some transaction coordinators.\n\nformatID is the formatID part of xid.\n\ndata are the gtrid and bqual parts of xid, concatenated.\n\ngtrid_length and bqual_length are the lengths of gtrid and bqual, respectevely.\n\nExamples\n--------\n\n2-phases commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA PREPARE \'test\';\n\nXA COMMIT \'test\';\n\n1-phase commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA COMMIT \'test\' ONE PHASE;\n\nHuman-readable:\n\nxa start \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\ninsert t1 values (40);\n\nxa end \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa prepare \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa recover format=\'RAW\';\n+----------+--------------+--------------+--------------------+\n| formatID | gtrid_length | bqual_length | data               |\n+----------+--------------+--------------+--------------------+\n34      67v78abc       11 |            7 | 12\ndef |\n+----------+--------------+--------------+--------------------+\n\nxa recover format=\'SQL\';\n+----------+--------------+--------------+-------------------------------------\n---------+\n| formatID | gtrid_length | bqual_length | data                               \n     |\n+----------+--------------+--------------+-------------------------------------\n---------+\n|        3 |           11 |            7 |\nX\'31320d3334093637763738\',X\'6162630a646566\',3 |\n+----------+--------------+--------------+-------------------------------------\n---------+\n\nxa rollback X\'31320d3334093637763738\',X\'6162630a646566\',3;\n\nKnown Issues\n------------\n\nMariaDB Galera Cluster\n----------------------\n\nMariaDB Galera Cluster does not support XA transactions.\n\nHowever, MariaDB Galera Cluster builds include a built-in plugin called wsrep.\nPrior to MariaDB 10.4.3, this plugin was internally considered an XA-capable\nstorage engine. Consequently, these MariaDB Galera Cluster builds have\nmultiple XA-capable storage engines by default, even if the only \"real\"\nstorage engine that supports external XA transactions enabled on these builds\nby default is InnoDB. Therefore, when using one these builds MariaDB would be\nforced to use a transaction coordinator log by default, which could have\nperformance implications.\n\nSee Transaction Coordinator Log Overview: MariaDB Galera Cluster for more\ninformation.\n\nURL: https://mariadb.com/kb/en/xa-transactions/','','https://mariadb.com/kb/en/xa-transactions/'),(104,'CREATE USER',10,'Syntax\n------\n\nCREATE [OR REPLACE] USER [IF NOT EXISTS] \n user_specification [,user_specification ...] \n [REQUIRE {NONE | tls_option [[AND] tls_option ...] }]\n [WITH resource_option [resource_option ...] ]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe CREATE USER statement creates new MariaDB accounts. To use it, you must\nhave the global CREATE USER privilege or the INSERT privilege for the mysql\ndatabase. For each account, CREATE USER creates a new row in mysql.user (until\nMariaDB 10.3 this is a table, from MariaDB 10.4 it\'s a view) or\nmysql.global_priv_table (from MariaDB 10.4) that has no privileges.\n\nIf any of the specified accounts, or any permissions for the specified\naccounts, already exist, then the server returns ERROR 1396 (HY000). If an\nerror occurs, CREATE USER will still create the accounts that do not result in\nan error. Only one error is produced for all users which have not been created:\n\nERROR 1396 (HY000): \n Operation CREATE USER failed for \'u1\'@\'%\',\'u2\'@\'%\'\n\nCREATE USER, DROP USER, CREATE ROLE, and DROP ROLE all produce the same error\ncode when they fail.\n\nSee Account Names below for details on how account names are specified.\n\nOR REPLACE\n----------\n\nIf the optional OR REPLACE clause is used, it is basically a shortcut for:\n\nDROP USER IF EXISTS name;\nCREATE USER name ...;\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE OR REPLACE USER foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected (0.00 sec)\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified user already exists.\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE USER IF NOT EXISTS foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+----------------------------------------------------+\n| Level | Code | Message                                            |\n+-------+------+----------------------------------------------------+\n| Note  | 1973 | Can\'t create user \'foo2\'@\'test\'; it already exists |\n+-------+------+----------------------------------------------------+\n\nAuthentication Options\n----------------------\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored in the\nmysql.user/mysql.global_priv_table table.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nCREATE USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored in the\nmysql.user/mysql.global_priv_table table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nCREATE USER foo2@test IDENTIFIED BY PASSWORD\n\'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nCREATE USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nCREATE USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\') OR\nunix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nCREATE USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to create a user with resource limits:\n\nCREATE USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nAccount Names\n-------------\n\nAccount names have both a user name component and a host name component, and\nare specified as \'user_name\'@\'host_name\'.\n\nThe user name and host name may be unquoted, quoted as strings using double\nquotes (\") or single quotes (\'), or quoted as identifiers using backticks (`).\nYou must use quotes when using special characters (such as a hyphen) or\nwildcard characters. If you quote, you must quote the user name and host name\nseparately (for example \'user_name\'@\'host_name\').\n\nHost Name Component\n-------------------\n\nIf the host name is not provided, it is assumed to be \'%\'.\n\nHost names may contain the wildcard characters % and _. They are matched as if\nby the LIKE clause. If you need to use a wildcard character literally (for\nexample, to match a domain name with an underscore), prefix the character with\na backslash. See LIKE for more information on escaping wildcard characters.\n\nHost name matches are case-insensitive. Host names can match either domain\nnames or IP addresses. Use \'localhost\' as the host name to allow only local\nclient connections.\n\nYou can use a netmask to match a range of IP addresses using \'base_ip/netmask\'\nas the host name. A user with an IP address ip_addr will be allowed to connect\nif the following condition is true:\n\nip_addr & netmask = base_ip\n\nFor example, given a user:\n\nCREATE USER \'maria\'@\'247.150.130.0/255.255.255.0\';\n\nthe IP addresses satisfying this condition range from 247.150.130.0 to\n247.150.130.255.\n\nUsing 255.255.255.255 is equivalent to not using a netmask at all. Netmasks\ncannot be used for IPv6 addresses.\n\nNote that the credentials added when creating a user with the \'%\' wildcard\nhost will not grant access in all cases. For example, some systems come with\nan anonymous localhost user, and when connecting from localhost this will take\nprecedence.\n\nBefore MariaDB 10.6, the host name component could be up to 60 characters in\nlength. Starting from MariaDB 10.6, it can be up to 255 characters.\n\nUser Name Component\n-------------------\n\nUser names must match exactly, including case. A user name that is empty is\nknown as an anonymous account and is allowed to match a login attempt with any\nuser name component. These are described more in the next section.\n\nFor valid identifiers to use as user names, see Identifier Names.\n\nIt is possible for more than one account to match when a user connects.\nMariaDB selects the first matching account after sorting according to the\nfollowing criteria:\n\n* Accounts with an exact host name are sorted before accounts using a wildcard\nin the\nhost name. Host names using a netmask are considered to be exact for sorting.\n* Accounts with a wildcard in the host name are sorted according to the\nposition of\nthe first wildcard character. Those with a wildcard character later in the\nhost name\nsort before those with a wildcard character earlier in the host name.\n* Accounts with a non-empty user name sort before accounts with an empty user\nname.\n* Accounts with an empty user name are sorted last. As mentioned previously,\nthese are known as anonymous accounts. These are described more in the next\nsection.\n\nThe following table shows a list of example account as sorted by these\ncriteria:\n\n+---------+-------------+\n| User    | Host        |\n+---------+-------------+\n| joffrey | 192.168.0.3 |\n|         | 192.168.0.% |\n| joffrey | 192.168.%   |\n|         | 192.168.%   |\n+---------+-------------+\n\nOnce connected, you only have the privileges granted to the account that\nmatched, not all accounts that could have matched. For example, consider the\nfollowing commands:\n\nCREATE USER \'joffrey\'@\'192.168.0.3\';\nCREATE USER \'joffrey\'@\'%\';\nGRANT SELECT ON test.t1 to \'joffrey\'@\'192.168.0.3\';\nGRANT SELECT ON test.t2 to \'joffrey\'@\'%\';\n\nIf you connect as joffrey from 192.168.0.3, you will have the SELECT privilege\non the table test.t1, but not on the table test.t2. If you connect as joffrey\nfrom any other IP address, you will have the SELECT privilege on the table\ntest.t2, but not on the table test.t1.\n\nUsernames can be up to 80 characters long before 10.6 and starting from 10.6\nit can be 128 characters long.\n\nAnonymous Accounts\n------------------\n\nAnonymous accounts are accounts where the user name portion of the account\nname is empty. These accounts act as special catch-all accounts. If a user\nattempts to log into the system from a host, and an anonymous account exists\nwith a host name portion that matches the user\'s host, then the user will log\nin as the anonymous account if there is no more specific account match for the\nuser name that the user entered.\n\nFor example, here are some anonymous accounts:\n\nCREATE USER \'\'@\'localhost\';\nCREATE USER \'\'@\'192.168.0.3\';\n\nFixing a Legacy Default Anonymous Account\n-----------------------------------------\n\nOn some systems, the mysql.db table has some entries for the \'\'@\'%\' anonymous\naccount by default. Unfortunately, there is no matching entry in the\nmysql.user/mysql.global_priv_table table, which means that this anonymous\naccount doesn\'t exactly exist, but it does have privileges--usually on the\ndefault test database created by mysql_install_db. These account-less\nprivileges are a legacy that is leftover from a time when MySQL\'s privilege\nsystem was less advanced.\n\nThis situation means that you will run into errors if you try to create a\n\'\'@\'%\' account. For example:\n\nCREATE USER \'\'@\'%\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'\'@\'%\'\n\nThe fix is to DELETE the row in the mysql.db table and then execute FLUSH\nPRIVILEGES:\n\nDELETE FROM mysql.db WHERE User=\'\' AND Host=\'%\';\nFLUSH PRIVILEGES;\n\nAnd then the account can be created:\n\nCREATE USER \'\'@\'%\';\nQuery OK, 0 rows affected (0.01 sec)\n\nSee MDEV-13486 for more information.\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nCREATE USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/create-user/','','https://mariadb.com/kb/en/create-user/'),(105,'ALTER USER',10,'Syntax\n------\n\nALTER USER [IF EXISTS] \n user_specification [,user_specification] ...\n [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n [WITH resource_option [resource_option] ...]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule] ...\n\nauthentication_rule:\n authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe ALTER USER statement modifies existing MariaDB accounts. To use it, you\nmust have the global CREATE USER privilege or the UPDATE privilege for the\nmysql database. The global SUPER privilege is also required if the read_only\nsystem variable is enabled.\n\nIf any of the specified user accounts do not yet exist, an error results. If\nan error occurs, ALTER USER will still modify the accounts that do not result\nin an error. Only one error is produced for all users which have not been\nmodified.\n\nIF EXISTS\n---------\n\nWhen the IF EXISTS clause is used, MariaDB will return a warning instead of an\nerror for each specified user that does not exist.\n\nAccount Names\n-------------\n\nFor ALTER USER statements, account names are specified as the username\nargument in the same way as they are for CREATE USER statements. See account\nnames from the CREATE USER page for details on how account names are specified.\n\nCURRENT_USER or CURRENT_USER() can also be used to alter the account logged\ninto the current session. For example, to change the current user\'s password\nto mariadb:\n\nALTER USER CURRENT_USER() IDENTIFIED BY \'mariadb\';\n\nAuthentication Options\n----------------------\n\nMariaDB starting with 10.4\n--------------------------\nFrom MariaDB 10.4, it is possible to use more than one authentication plugin\nfor each user account. For example, this can be useful to slowly migrate users\nto the more secure ed25519 authentication plugin over time, while allowing the\nold mysql_native_password authentication plugin as an alternative for the\ntransitional period. See Authentication from MariaDB 10.4 for more.\n\nWhen running ALTER USER, not specifying an authentication option in the\nIDENTIFIED VIA clause will remove that authentication method. (However this\nwas not the case before MariaDB 10.4.13, see MDEV-21928)\n\nFor example, a user is created with the ability to authenticate via both a\npassword and unix_socket:\n\nCREATE USER \'bob\'@\'localhost\' \n IDENTIFIED VIA mysql_native_password USING PASSWORD(\'pwd\')\n OR unix_socket;\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED VIA mysql_native_password\n USING \'*975B2CD4FF9AE554FE8AD33168FBFC326D2021DD\'\n OR unix_socket\n\nIf the user\'s password is updated, but unix_socket authentication is not\nspecified in the IDENTIFIED VIA clause, unix_socket authentication will no\nlonger be permitted.\n\nALTER USER \'bob\'@\'localhost\' IDENTIFIED VIA mysql_native_password \n USING PASSWORD(\'pwd2\');\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED BY PASSWORD \'*38366FDA01695B6A5A9DD4E428D9FB8F7EB75512\'\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored to the mysql.user table.\n\nFor example, if our password is mariadb, then we can set the account\'s\npassword with:\n\nALTER USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD#function. It will be stored to the\nmysql.user table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n\nAnd then we can set an account\'s password with the hash:\n\nALTER USER foo2@test \n IDENTIFIED BY PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nALTER USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nALTER USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nIn MariaDB 10.4 and later, the USING or AS keyword can also be used to provide\na plain-text password to a plugin if it\'s provided as an argument to the\nPASSWORD() function. This is only valid for authentication plugins that have\nimplemented a hook for the PASSWORD() function. For example, the ed25519\nauthentication plugin supports this:\n\nALTER USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can alter a user account to require these TLS options with\nthe following:\n\nALTER USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\' AND\n ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+------------------------------------+---------------------------------------+\n| Limit Type                         | Description                           |\n+------------------------------------+---------------------------------------+\n| MAX_QUERIES_PER_HOUR               | Number of statements that the         |\n|                                    | account can issue per hour            |\n|                                    | (including updates)                   |\n+------------------------------------+---------------------------------------+\n| MAX_UPDATES_PER_HOUR               | Number of updates (not queries) that  |\n|                                    | the account can issue per hour        |\n+------------------------------------+---------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR           | Number of connections that the        |\n|                                    | account can start per hour            |\n+------------------------------------+---------------------------------------+\n| MAX_USER_CONNECTIONS               | Number of simultaneous connections    |\n|                                    | that can be accepted from the same    |\n|                                    | account; if it is 0, max_connections  |\n|                                    | will be used instead; if              |\n|                                    | max_connections is 0, there is no     |\n|                                    | limit for this account\'s              |\n|                                    | simultaneous connections.             |\n+------------------------------------+---------------------------------------+\n| MAX_STATEMENT_TIME                 | Timeout, in seconds, for statements   |\n|                                    | executed by the user. See also        |\n|                                    | Aborting Statements that Exceed a     |\n|                                    | Certain Time to Execute.              |\n+------------------------------------+---------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to set an account\'s resource limits:\n\nALTER USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nALTER USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/alter-user/','','https://mariadb.com/kb/en/alter-user/'),(107,'GRANT',10,'Syntax\n------\n\nGRANT\n  priv_type [(column_list)]\n   [, priv_type [(column_list)]] ...\n  ON [object_type] priv_level\n  TO user_specification [ user_options ...]\n\nuser_specification:\n username [authentication_option]\n | PUBLIC\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\nGRANT PROXY ON username\n  TO user_specification [, user_specification ...]\n  [WITH GRANT OPTION]\n\nGRANT rolename TO grantee [, grantee ...]\n  [WITH ADMIN OPTION]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nuser_options:\n  [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n  [WITH with_option [with_option] ...]\n\nobject_type:\n  TABLE\n | FUNCTION\n | PROCEDURE\n | PACKAGE\n\npriv_level:\n  *\n | *.*\n | db_name.*\n | db_name.tbl_name\n | tbl_name\n | db_name.routine_name\n\nwith_option:\n  GRANT OPTION\n | resource_option\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nDescription\n-----------\n\nThe GRANT statement allows you to grant privileges or roles to accounts. To\nuse GRANT, you must have the GRANT OPTION privilege, and you must have the\nprivileges that you are granting.\n\nUse the REVOKE statement to revoke privileges granted with the GRANT statement.\n\nUse the SHOW GRANTS statement to determine what privileges an account has.\n\nAccount Names\n-------------\n\nFor GRANT statements, account names are specified as the username argument in\nthe same way as they are for CREATE USER statements. See account names from\nthe CREATE USER page for details on how account names are specified.\n\nImplicit Account Creation\n-------------------------\n\nThe GRANT statement also allows you to implicitly create accounts in some\ncases.\n\nIf the account does not yet exist, then GRANT can implicitly create it. To\nimplicitly create an account with GRANT, a user is required to have the same\nprivileges that would be required to explicitly create the account with the\nCREATE USER statement.\n\nIf the NO_AUTO_CREATE_USER SQL_MODE is set, then accounts can only be created\nif authentication information is specified, or with a CREATE USER statement.\nIf no authentication information is provided, GRANT will produce an error when\nthe specified account does not exist, for example:\n\nshow variables like \'%sql_mode%\' ;\n+---------------+--------------------------------------------+\n| Variable_name | Value                                      |\n+---------------+--------------------------------------------+\n| sql_mode      | NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n+---------------+--------------------------------------------+\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' IDENTIFIED BY \'\';\nERROR 1133 (28000): Can\'t find any matching row in the user table\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' \n IDENTIFIED VIA PAM using \'mariadb\' require ssl ;\nQuery OK, 0 rows affected (0.00 sec)\n\nselect host, user from mysql.user where user=\'user123\' ;\n\n+------+----------+\n| host | user     |\n+------+----------+\n| %    | user123 |\n+------+----------+\n\nPrivilege Levels\n----------------\n\nPrivileges can be set globally, for an entire database, for a table or\nroutine, or for individual columns in a table. Certain privileges can only be\nset at certain levels.\n\n* Global privileges priv_type are granted using *.* for\npriv_level. Global privileges include privileges to administer the database\nand manage user accounts, as well as privileges for all tables, functions, and\nprocedures. Global privileges are stored in the mysql.user table prior to\nMariaDB 10.4, and in  mysql.global_priv table afterwards.\n* Database privileges priv_type are granted using db_name.*\nfor priv_level, or using just * to use default database. Database\nprivileges include privileges to create tables and functions, as well as\nprivileges for all tables, functions, and procedures in the database. Database\nprivileges are stored in the mysql.db table.\n* Table privileges priv_type are granted using db_name.tbl_name\nfor priv_level, or using just tbl_name to specify a table in the default\ndatabase. The TABLE keyword is optional. Table privileges include the\nability to select and change data in the table. Certain table privileges can\nbe granted for individual columns.\n* Column privileges priv_type are granted by specifying a table for\npriv_level and providing a column list after the privilege type. They allow\nyou to control exactly which columns in a table users can select and change.\n* Function privileges priv_type are granted using FUNCTION db_name.routine_name\nfor priv_level, or using just  FUNCTION routine_name to specify a function\nin the default database.\n* Procedure privileges priv_type are granted using PROCEDURE\ndb_name.routine_name\nfor priv_level, or using just PROCEDURE routine_name to specify a procedure\nin the default database.\n\nThe USAGE Privilege\n-------------------\n\nThe USAGE privilege grants no real privileges. The SHOW GRANTS statement will\nshow a global USAGE privilege for a newly-created user. You can use USAGE with\nthe GRANT statement to change options like GRANT OPTION and\nMAX_USER_CONNECTIONS without changing any account privileges.\n\nThe ALL PRIVILEGES Privilege\n----------------------------\n\nThe ALL PRIVILEGES privilege grants all available privileges. Granting all\nprivileges only affects the given privilege level. For example, granting all\nprivileges on a table does not grant any privileges on the database or\nglobally.\n\nUsing ALL PRIVILEGES does not grant the special GRANT OPTION privilege.\n\nYou can use ALL instead of ALL PRIVILEGES.\n\nThe GRANT OPTION Privilege\n--------------------------\n\nUse the WITH GRANT OPTION clause to give users the ability to grant privileges\nto other users at the given privilege level. Users with the GRANT OPTION\nprivilege can only grant privileges they have. They cannot grant privileges at\na higher privilege level than they have the GRANT OPTION privilege.\n\nThe GRANT OPTION privilege cannot be set for individual columns. If you use\nWITH GRANT OPTION when specifying column privileges, the GRANT OPTION\nprivilege will be granted for the entire table.\n\nUsing the WITH GRANT OPTION clause is equivalent to listing GRANT OPTION as a\nprivilege.\n\nGlobal Privileges\n-----------------\n\nThe following table lists the privileges that can be granted globally. You can\nalso grant all database, table, and function privileges globally. When granted\nglobally, these privileges apply to all databases, tables, or functions,\nincluding those created later.\n\nTo set a global privilege, use *.* for priv_level.\n\nBINLOG ADMIN\n------------\n\nEnables administration of the binary log, including the PURGE BINARY LOGS\nstatement and setting the system variables:\n\n* binlog_annotate_row_events\n* binlog_cache_size\n* binlog_commit_wait_count\n* binlog_commit_wait_usec\n* binlog_direct_non_transactional_updates\n* binlog_expire_logs_seconds\n* binlog_file_cache_size\n* binlog_format\n* binlog_row_image\n* binlog_row_metadata\n* binlog_stmt_cache_size\n* expire_logs_days\n* log_bin_compress\n* log_bin_compress_min_len\n* log_bin_trust_function_creators\n* max_binlog_cache_size\n* max_binlog_size\n* max_binlog_stmt_cache_size\n* sql_log_bin and\n* sync_binlog.\n\nAdded in MariaDB 10.5.2.\n\nBINLOG MONITOR\n--------------\n\nNew name for REPLICATION CLIENT from MariaDB 10.5.2, (REPLICATION CLIENT still\nsupported as an alias for compatibility purposes). Permits running SHOW\ncommands related to the binary log, in particular the SHOW BINLOG STATUS and\nSHOW BINARY LOGS statements. Unlike REPLICATION CLIENT prior to MariaDB 10.5,\nSHOW REPLICA STATUS isn\'t included in this privilege, and REPLICA MONITOR is\nrequired.\n\nBINLOG REPLAY\n-------------\n\nEnables replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), executing SET timestamp when secure_timestamp is set to\nreplication, and setting the session values of system variables usually\nincluded in BINLOG output, in particular:\n\n* gtid_domain_id\n* gtid_seq_no\n* pseudo_thread_id\n* server_id.\n\nAdded in MariaDB 10.5.2\n\nCONNECTION ADMIN\n----------------\n\nEnables administering connection resource limit options. This includes\nignoring the limits specified by:\n\n* max_connections\n* max_user_connections and\n* max_password_errors.\n\nThe statements specified in init_connect are not executed, killing connections\nand queries owned by other users is permitted. The following\nconnection-related system variables can be changed:\n\n* connect_timeout\n* disconnect_on_expired_password\n* extra_max_connections\n* init_connect\n* max_connections\n* max_connect_errors\n* max_password_errors\n* proxy_protocol_networks\n* secure_auth\n* slow_launch_time\n* thread_pool_exact_stats\n* thread_pool_dedicated_listener\n* thread_pool_idle_timeout\n* thread_pool_max_threads\n* thread_pool_min_threads\n* thread_pool_oversubscribe\n* thread_pool_prio_kickup_timer\n* thread_pool_priority\n* thread_pool_size, and\n* thread_pool_stall_limit.\n\nAdded in MariaDB 10.5.2.\n\nCREATE USER\n-----------\n\nCreate a user using the CREATE USER statement, or implicitly create a user\nwith the GRANT statement.\n\nFEDERATED ADMIN\n---------------\n\nExecute CREATE SERVER, ALTER SERVER, and DROP SERVER statements. Added in\nMariaDB 10.5.2.\n\nFILE\n----\n\nRead and write files on the server, using statements like LOAD DATA INFILE or\nfunctions like LOAD_FILE(). Also needed to create CONNECT outward tables.\nMariaDB server must have the permissions to access those files.\n\nGRANT OPTION\n------------\n\nGrant global privileges. You can only grant privileges that you have.\n\nPROCESS\n-------\n\nShow information about the active processes, for example via SHOW PROCESSLIST\nor mysqladmin processlist. If you have the PROCESS privilege, you can see all\nthreads. Otherwise, you can see only your own threads (that is, threads\nassociated with the MariaDB account that you are using).\n\nREAD_ONLY ADMIN\n---------------\n\nUser can set the read_only system variable and allows the user to perform\nwrite operations, even when the read_only option is active. Added in MariaDB\n10.5.2.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nRELOAD\n------\n\nExecute FLUSH statements or equivalent mariadb-admin/mysqladmin commands.\n\nREPLICATION CLIENT\n------------------\n\nExecute SHOW MASTER STATUS and SHOW BINARY LOGS informative statements.\nRenamed to BINLOG MONITOR in MariaDB 10.5.2 (but still supported as an alias\nfor compatibility reasons). SHOW SLAVE STATUS was part of REPLICATION CLIENT\nprior to MariaDB 10.5.\n\nREPLICATION MASTER ADMIN\n------------------------\n\nPermits administration of primary servers, including the SHOW REPLICA HOSTS\nstatement, and setting the gtid_binlog_state, gtid_domain_id,\nmaster_verify_checksum and server_id system variables. Added in MariaDB 10.5.2.\n\nREPLICA MONITOR\n---------------\n\nPermit SHOW REPLICA STATUS and SHOW RELAYLOG EVENTS. From MariaDB 10.5.9.\n\nWhen a user would upgrade from an older major release to a MariaDB 10.5 minor\nrelease prior to MariaDB 10.5.9, certain user accounts would lose\ncapabilities. For example, a user account that had the REPLICATION CLIENT\nprivilege in older major releases could run SHOW REPLICA STATUS, but after\nupgrading to a MariaDB 10.5 minor release prior to MariaDB 10.5.9, they could\nno longer run SHOW REPLICA STATUS, because that statement was changed to\nrequire the REPLICATION REPLICA ADMIN privilege.\n\nThis issue is fixed in MariaDB 10.5.9 with this new privilege, which now\ngrants the user the ability to execute SHOW [ALL] (SLAVE | REPLICA) STATUS.\n\nWhen a database is upgraded from an older major release to MariaDB Server\n10.5.9 or later, any user accounts with the REPLICATION CLIENT or REPLICATION\nSLAVE privileges will automatically be granted the new REPLICA MONITOR\nprivilege. The privilege fix occurs when the server is started up, not when\nmariadb-upgrade is performed.\n\nHowever, when a database is upgraded from an early 10.5 minor release to\n10.5.9 and later, the user will have to fix any user account privileges\nmanually.\n\nREPLICATION REPLICA\n-------------------\n\nSynonym for REPLICATION SLAVE. From MariaDB 10.5.1.\n\nREPLICATION SLAVE\n-----------------\n\nAccounts used by replica servers on the primary need this privilege. This is\nneeded to get the updates made on the master. From MariaDB 10.5.1, REPLICATION\nREPLICA is an alias for REPLICATION SLAVE.\n\nREPLICATION SLAVE ADMIN\n-----------------------\n\nPermits administering replica servers, including START REPLICA/SLAVE, STOP\nREPLICA/SLAVE, CHANGE MASTER, SHOW REPLICA/SLAVE STATUS, SHOW RELAYLOG EVENTS\nstatements, replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), and setting the system variables:\n\n* gtid_cleanup_batch_size\n* gtid_ignore_duplicates\n* gtid_pos_auto_engines\n* gtid_slave_pos\n* gtid_strict_mode\n* init_slave\n* read_binlog_speed_limit\n* relay_log_purge\n* relay_log_recovery\n* replicate_do_db\n* replicate_do_table\n* replicate_events_marked_for_skip\n* replicate_ignore_db\n* replicate_ignore_table\n* replicate_wild_do_table\n* replicate_wild_ignore_table\n* slave_compressed_protocol\n* slave_ddl_exec_mode\n* slave_domain_parallel_threads\n* slave_exec_mode\n* slave_max_allowed_packet\n* slave_net_timeout\n* slave_parallel_max_queued\n* slave_parallel_mode\n* slave_parallel_threads\n* slave_parallel_workers\n* slave_run_triggers_for_rbr\n* slave_sql_verify_checksum\n* slave_transaction_retry_interval\n* slave_type_conversions\n* sync_master_info\n* sync_relay_log, and\n* sync_relay_log_info.\n\nAdded in MariaDB 10.5.2.\n\nSET USER\n--------\n\nEnables setting the DEFINER when creating triggers, views, stored functions\nand stored procedures. Added in MariaDB 10.5.2.\n\nSHOW DATABASES\n--------------\n\nList all databases using the SHOW DATABASES statement. Without the SHOW\nDATABASES privilege, you can still issue the SHOW DATABASES statement, but it\nwill only list databases containing tables on which you have privileges.\n\nSHUTDOWN\n--------\n\nShut down the server using SHUTDOWN or the mysqladmin shutdown command.\n\nSUPER\n-----\n\nExecute superuser statements: CHANGE MASTER TO, KILL (users who do not have\nthis privilege can only KILL their own threads), PURGE LOGS, SET global system\nvariables, or the mysqladmin debug command. Also, this permission allows the\nuser to write data even if the read_only startup option is set, enable or\ndisable logging, enable or disable replication on replica, specify a DEFINER\nfor statements that support that clause, connect once reaching the\nMAX_CONNECTIONS. If a statement has been specified for the init-connect mysqld\noption, that command will not be executed when a user with SUPER privileges\nconnects to the server.\n\nThe SUPER privilege has been split into multiple smaller privileges from\nMariaDB 10.5.2 to allow for more fine-grained privileges, although it remains\nan alias for these smaller privileges.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nDatabase Privileges\n-------------------\n\nThe following table lists the privileges that can be granted at the database\nlevel. You can also grant all table and function privileges at the database\nlevel. Table and function privileges on a database apply to all tables or\nfunctions in that database, including those created later.\n\nTo set a privilege for a database, specify the database using db_name.* for\npriv_level, or just use * to specify the default database.\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a database using the CREATE      |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. You can      |\n|                                  | grant the CREATE privilege on           |\n|                                  | databases that do not yet exist. This   |\n|                                  | also grants the CREATE privilege on     |\n|                                  | all tables in the database.             |\n+----------------------------------+-----------------------------------------+\n| CREATE ROUTINE                   | Create Stored Programs using the        |\n|                                  | CREATE PROCEDURE and CREATE FUNCTION    |\n|                                  | statements.                             |\n+----------------------------------+-----------------------------------------+\n| CREATE TEMPORARY TABLES          | Create temporary tables with the        |\n|                                  | CREATE TEMPORARY TABLE statement. This  |\n|                                  | privilege enable writing and dropping   |\n|                                  | those temporary tables                  |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a database using the DROP          |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. This also    |\n|                                  | grants the DROP privilege on all        |\n|                                  | tables in the database.                 |\n+----------------------------------+-----------------------------------------+\n| EVENT                            | Create, drop and alter EVENTs.          |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant database privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n| LOCK TABLES                      | Acquire explicit locks using the LOCK   |\n|                                  | TABLES statement; you also need to      |\n|                                  | have the SELECT privilege on a table,   |\n|                                  | in order to lock it.                    |\n+----------------------------------+-----------------------------------------+\n\nTable Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER                            | Change the structure of an existing     |\n|                                  | table using the ALTER TABLE statement.  |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a table using the CREATE TABLE   |\n|                                  | statement.  You can grant the CREATE    |\n|                                  | privilege on tables that do not yet     |\n|                                  | exist.                                  |\n+----------------------------------+-----------------------------------------+\n| CREATE VIEW                      | Create a view using the CREATE_VIEW     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| DELETE                           | Remove rows from a table using the      |\n|                                  | DELETE statement.                       |\n+----------------------------------+-----------------------------------------+\n| DELETE HISTORY                   | Remove historical rows from a table     |\n|                                  | using the DELETE HISTORY statement.     |\n|                                  | Displays as DELETE VERSIONING ROWS      |\n|                                  | when running SHOW GRANTS until MariaDB  |\n|                                  | 10.3.15 and until MariaDB 10.4.5        |\n|                                  | (MDEV-17655), or when running SHOW      |\n|                                  | PRIVILEGES until MariaDB 10.5.2,        |\n|                                  | MariaDB 10.4.13 and MariaDB 10.3.23     |\n|                                  | (MDEV-20382). From MariaDB 10.3.4.      |\n|                                  | From MariaDB 10.3.5, if a user has the  |\n|                                  | SUPER privilege but not this            |\n|                                  | privilege, running mysql_upgrade will   |\n|                                  | grant this privilege as well.           |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a table using the DROP TABLE       |\n|                                  | statement or a view using the DROP      |\n|                                  | VIEW statement. Also required to        |\n|                                  | execute the TRUNCATE TABLE statement.   |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant table privileges. You can only    |\n|                                  | grant privileges that you have.         |\n+----------------------------------+-----------------------------------------+\n| INDEX                            | Create an index on a table using the    |\n|                                  | CREATE INDEX statement. Without the     |\n|                                  | INDEX privilege, you can still create   |\n|                                  | indexes when creating a table using     |\n|                                  | the CREATE TABLE statement if the you   |\n|                                  | have the CREATE privilege, and you can  |\n|                                  | create indexes using the ALTER TABLE    |\n|                                  | statement if you have the ALTER         |\n|                                  | privilege.                              |\n+----------------------------------+-----------------------------------------+\n| INSERT                           | Add rows to a table using the INSERT    |\n|                                  | statement.  The INSERT privilege can    |\n|                                  | also be set on individual columns; see  |\n|                                  | Column Privileges below for details.    |\n+----------------------------------+-----------------------------------------+\n| REFERENCES                       | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT                           | Read data from a table using the        |\n|                                  | SELECT statement. The SELECT privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n| SHOW VIEW                        | Show the CREATE VIEW statement to       |\n|                                  | create a view using the SHOW CREATE     |\n|                                  | VIEW statement.                         |\n+----------------------------------+-----------------------------------------+\n| TRIGGER                          | Execute triggers associated to tables   |\n|                                  | you update, execute the CREATE TRIGGER  |\n|                                  | and DROP TRIGGER statements. You will   |\n|                                  | still be able to see triggers.          |\n+----------------------------------+-----------------------------------------+\n| UPDATE                           | Update existing rows in a table using   |\n|                                  | the UPDATE statement. UPDATE            |\n|                                  | statements usually include a WHERE      |\n|                                  | clause to update only certain rows.     |\n|                                  | You must have SELECT privileges on the  |\n|                                  | table or the appropriate columns for    |\n|                                  | the WHERE clause. The UPDATE privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n\nColumn Privileges\n-----------------\n\nSome table privileges can be set for individual columns of a table. To use\ncolumn privileges, specify the table explicitly and provide a list of column\nnames after the privilege type. For example, the following statement would\nallow the user to read the names and positions of employees, but not other\ninformation from the same table, such as salaries.\n\nGRANT SELECT (name, position) on Employee to \'jeffrey\'@\'localhost\';\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| INSERT (column_list)             | Add rows specifying values in columns   |\n|                                  | using the INSERT statement. If you      |\n|                                  | only have column-level INSERT           |\n|                                  | privileges, you must specify the        |\n|                                  | columns you are setting in the INSERT   |\n|                                  | statement. All other columns will be    |\n|                                  | set to their default values, or NULL.   |\n+----------------------------------+-----------------------------------------+\n| REFERENCES (column_list)         | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT (column_list)             | Read values in columns using the        |\n|                                  | SELECT statement. You cannot access or  |\n|                                  | query any columns for which you do not  |\n|                                  | have SELECT privileges, including in    |\n|                                  | WHERE, ON, GROUP BY, and ORDER BY       |\n|                                  | clauses.                                |\n+----------------------------------+-----------------------------------------+\n| UPDATE (column_list)             | Update values in columns of existing    |\n|                                  | rows using the UPDATE statement.        |\n|                                  | UPDATE statements usually include a     |\n|                                  | WHERE clause to update only certain     |\n|                                  | rows. You must have SELECT privileges   |\n|                                  | on the table or the appropriate         |\n|                                  | columns for the WHERE clause.           |\n+----------------------------------+-----------------------------------------+\n\nFunction Privileges\n-------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | function using the ALTER FUNCTION       |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Use a stored function. You need SELECT  |\n|                                  | privileges for any tables or columns    |\n|                                  | accessed by the function.               |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant function privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nProcedure Privileges\n--------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | procedure using the ALTER PROCEDURE     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Execute a stored procedure using the    |\n|                                  | CALL statement. The privilege to call   |\n|                                  | a procedure may allow you to perform    |\n|                                  | actions you wouldn\'t otherwise be able  |\n|                                  | to do, such as insert rows into a       |\n|                                  | table.                                  |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant procedure privileges. You can     |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nGRANT EXECUTE ON PROCEDURE mysql.create_db TO maintainer;\n\nProxy Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| PROXY                            | Permits one user to be a proxy for      |\n|                                  | another.                                |\n+----------------------------------+-----------------------------------------+\n\nThe PROXY privilege allows one user to proxy as another user, which means\ntheir privileges change to that of the proxy user, and the CURRENT_USER()\nfunction returns the user name of the proxy user.\n\nThe PROXY privilege only works with authentication plugins that support it.\nThe default mysql_native_password authentication plugin does not support proxy\nusers.\n\nThe pam authentication plugin is the only plugin included with MariaDB that\ncurrently supports proxy users. The PROXY privilege is commonly used with the\npam authentication plugin to enable user and group mapping with PAM.\n\nFor example, to grant the PROXY privilege to an anonymous account that\nauthenticates with the pam authentication plugin, you could execute the\nfollowing:\n\nCREATE USER \'dba\'@\'%\' IDENTIFIED BY \'strongpassword\';\nGRANT ALL PRIVILEGES ON *.* TO \'dba\'@\'%\' ;\n\nCREATE USER \'\'@\'%\' IDENTIFIED VIA pam USING \'mariadb\';\nGRANT PROXY ON \'dba\'@\'%\' TO \'\'@\'%\';\n\nA user account can only grant the PROXY privilege for a specific user account\nif the granter also has the PROXY privilege for that specific user account,\nand if that privilege is defined WITH GRANT OPTION. For example, the following\nexample fails because the granter does not have the PROXY privilege for that\nspecific user account at all:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nAnd the following example fails because the granter does have the PROXY\nprivilege for that specific user account, but it is not defined WITH GRANT\nOPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\'                     \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nBut the following example succeeds because the granter does have the PROXY\nprivilege for that specific user account, and it is defined WITH GRANT OPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\' WITH GRANT OPTION   \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\n\nA user account can grant the PROXY privilege for any other user account if the\ngranter has the PROXY privilege for the \'\'@\'%\' anonymous user account, like\nthis:\n\nGRANT PROXY ON \'\'@\'%\' TO \'dba\'@\'localhost\' WITH GRANT OPTION;\n\nFor example, the following example succeeds because the user can grant the\nPROXY privilege for any other user account:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'\'@\'%\' TO \'alice\'@\'localhost\' WITH GRANT OPTION              \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'app1_dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nGRANT PROXY ON \'app2_dba\'@\'localhost\' TO \'carol\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nThe default root user accounts created by mysql_install_db have this\nprivilege. For example:\n\nGRANT ALL PRIVILEGES ON *.* TO \'root\'@\'localhost\' WITH GRANT OPTION;\nGRANT PROXY ON \'\'@\'%\' TO \'root\'@\'localhost\' WITH GRANT OPTION;\n\nThis allows the default root user accounts to grant the PROXY privilege for\nany other user account, and it also allows the default root user accounts to\ngrant others the privilege to do the same.\n\nAuthentication Options\n----------------------\n\nThe authentication options for the GRANT statement are the same as those for\nthe CREATE USER statement.\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \n PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\') OR unix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nTo set resource limits for an account, if you do not want to change that\naccount\'s privileges, you can issue a GRANT statement with the USAGE\nprivilege, which has no meaning. The statement can name some or all limit\ntypes, in any order.\n\nHere is an example showing how to set resource limits:\n\nGRANT USAGE ON *.* TO \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 0\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nUsers with the CONNECTION ADMIN privilege (in MariaDB 10.5.2 and later) or the\nSUPER privilege are not restricted by max_user_connections, max_connections,\nor max_password_errors.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nGRANT USAGE ON *.* TO \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nRoles\n-----\n\nSyntax\n------\n\nGRANT role TO grantee [, grantee ... ]\n[ WITH ADMIN OPTION ]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nThe GRANT statement is also used to grant the use of a role to one or more\nusers or other roles. In order to be able to grant a role, the grantor doing\nso must have permission to do so (see WITH ADMIN in the CREATE ROLE article).\n\nSpecifying the WITH ADMIN OPTION permits the grantee to in turn grant the role\nto another.\n\nFor example, the following commands show how to grant the same role to a\ncouple different users.\n\nGRANT journalist TO hulda;\n\nGRANT journalist TO berengar WITH ADMIN OPTION;\n\nIf a user has been granted a role, they do not automatically obtain all\npermissions associated with that role. These permissions are only in use when\nthe user activates the role with the SET ROLE statement.\n\nTO PUBLIC\n---------\n\nMariaDB starting with 10.11\n---------------------------\n\nSyntax\n------\n\nGRANT <privilege> ON <database>.<object> TO PUBLIC;\nREVOKE <privilege> ON <database>.<object> FROM PUBLIC;\n\nGRANT ... TO PUBLIC grants privileges to all users with access to the server.\nThe privileges also apply to users created after the privileges are granted.\nThis can be useful when one only wants to state once that all users need to\nhave a certain set of privileges.\n\nWhen running SHOW GRANTS, a user will also see all privileges inherited from\nPUBLIC. SHOW GRANTS FOR PUBLIC will only show TO PUBLIC grants.\n\nGrant Examples\n--------------\n\nGranting Root-like Privileges\n-----------------------------\n\nYou can create a user that has privileges similar to the default root accounts\nby executing the following:\n\nCREATE USER \'alexander\'@\'localhost\';\nGRANT ALL PRIVILEGES ON  *.* to \'alexander\'@\'localhost\' WITH GRANT OPTION;\n\nURL: https://mariadb.com/kb/en/grant/','','https://mariadb.com/kb/en/grant/'),(117,'Authentication from MariaDB 10.4',10,'MariaDB starting with 10.4\n--------------------------\nMariaDB 10.4 introduced a number of changes to the authentication process,\nintended to make things easier and more intuitive.\n\nOverview\n--------\n\nThere are four new main features in 10.4 relating to authentication:\n\n* It is possible to use more than one authentication plugin for each user\naccount. For example, this can be useful to slowly migrate users to the more\nsecure ed25519 authentication plugin over time, while allowing the old\nmysql_native_password authentication plugin as an alternative for the\ntransitional period.\n* The root@localhost user account created by mysql_install_db is created with\nthe ability to use two authentication plugins.\nFirst, it is configured to try to use the unix_socket authentication plugin.\nThis allows the root@localhost user to login without a password via the local\nUnix socket file defined by the socket system variable, as long as the login\nis attempted from a process owned by the operating system root user account.\nSecond, if authentication fails with the unix_socket authentication plugin,\nthen it is configured to try to use the mysql_native_password authentication\nplugin. However, an invalid password is initially set, so in order to\nauthenticate this way, a password must be set with SET PASSWORD.\nHowever, just using the unix_socket authentication plugin may be fine for many\nusers, and it is very secure. You may want to try going without password\nauthentication to see how well it works for you. Remember, the best way to\nkeep your password safe is not to have one!\n\n* All user accounts, passwords, and global privileges are now stored in the\nmysql.global_priv table. The mysql.user table still exists and has exactly the\nsame set of columns as before, but it’s now a view that references the\nmysql.global_priv table. Tools that analyze the mysql.user table should\ncontinue to work as before. From MariaDB 10.4.13, the dedicated mariadb.sys\nuser is created as the definer of this view. Previously root was the definer,\nwhich resulted in privilege problems when this username was changed.\n* MariaDB 10.4 adds supports for User Password Expiry, which is not active by\ndefault.\n\nDescription\n-----------\n\nAs a result of the above changes, the open-for-everyone all-powerful root\naccount is finally gone. And installation scripts will no longer demand that\nyou \"PLEASE REMEMBER TO SET A PASSWORD FOR THE MariaDB root USER !\", because\nthe root account is securely created automatically.\n\nTwo all-powerful accounts are created by default — root and the OS user that\nowns the data directory, typically mysql. They are created as:\n\nCREATE USER root@localhost IDENTIFIED VIA unix_socket OR mysql_native_password\nUSING \'invalid\'\nCREATE USER mysql@localhost IDENTIFIED VIA unix_socket OR\nmysql_native_password USING \'invalid\'\n\nUsing unix_socket means that if you are the system root user, you can login as\nroot@locahost without a password. This technique was pioneered by Otto\nKekäläinen in Debian MariaDB packages and has been successfully used in Debian\nsince as early as MariaDB 10.0.\n\nIt is based on a simple fact that asking the system root for a password adds\nno extra security — root has full access to all the data files and all process\nmemory anyway. But not asking for a password means, there is no root password\nto forget (no need for the numerous tutorials on \"how to reset MariaDB root\npassword\"). And if you want to script some tedious database work, there is no\nneed to store the root password in plain text for the script to use (no need\nfor debian-sys-maint user).\n\nStill, some users may wish to log in as MariaDB root without using sudo. Hence\nthe old authentication method — conventional MariaDB password — is still\navailable. By default it is disabled (\"invalid\" is not a valid password hash),\nbut one can set the password with a usual SET PASSWORD statement. And still\nretain the password-less access via sudo.\n\nIf you install MariaDB locally (say from a tarball), you would not want to use\nsudo to be able to login. This is why MariaDB creates a second all-powerful\nuser with the same name as a system user that owns the data directory. In\nlocal (not system-wide) installations, this will be the user who installed\nMariaDB — they automatically get convenient password-less root-like access,\nbecause they can access all the data files anyway.\n\nEven if MariaDB is installed system-wide, you may not want to run your\ndatabase maintenance scripts as system root — now you can run them as system\nmysql user. And you will know that they will never destroy your entire system,\neven if you make a typo in a shell script.\n\nHowever, seasoned MariaDB DBAs who are used to the old ways do need to make\nsome changes. See the examples below for common tasks.\n\nCookbook\n--------\n\nAfter installing MariaDB system-wide the first thing you’ve got used to doing\nis logging in into the unprotected root account and protecting it, that is,\nsetting the root password:\n\n$ sudo dnf install MariaDB-server\n$ mysql -uroot\n...\nMariaDB> set password = password(\"XH4VmT3_jt\");\n\nThis is not only unnecessary now, it will simply not work — there is no\nunprotected root account. To login as root use\n\n$ sudo dnf install MariaDB-server\n$ sudo mysql\n\nNote that it implies you are connecting via the unix socket, not tcp. If you\nhappen to have protocol=tcp in a system-wide /etc/my.cnf file, use sudo mysql\n--protocol=socket.\n\nAfter installing MariaDB locally you’ve also used to connect to the\nunprotected root account using mysql -uroot. This will not work either, simply\nuse mysql without specifying a username.\n\nIf you\'ve forgotten your root password, no problem — you can still connect\nusing sudo and change the password. And if you\'ve also removed unix_socket\nauthentication, to restore access do as follows:\n\n* restart MariaDB with --skip-grant-tables\n* login into the unprotected server\n* run FLUSH PRIVILEGES (note, before 10.4 this would’ve been the last step,\nnot anymore). This disables --skip-grant-tables and allows you to change the\nstored authentication method\n* run SET PASSWORD FOR root@localhost to change the root password.\n\nTo view inside privilege tables, the old mysql.user table still exists. You\ncan select from it as before, although you cannot update it anymore. It\ndoesn’t show alternative authentication plugins and this was one of the\nreasons for switching to the mysql.global_priv table — complex authentication\nrules did not fit into rigid structure of a relational table. You can select\nfrom the new table, for example:\n\nselect concat(user, \'@\', host, \' => \', json_detailed(priv)) from\nmysql.global_priv;\n\nReverting to the Previous Authentication Method for root@localhost\n------------------------------------------------------------------\n\nIf you don\'t want the root@localhost user account created by mysql_install_db\nto use unix_socket authentication by default, then there are a few ways to\nrevert to the previous mysql_native_password authentication method for this\nuser account.\n\nConfiguring mysql_install_db to Revert to the Previous Authentication Method\n----------------------------------------------------------------------------\n\nOne way to revert to the previous mysql_native_password authentication method\nfor the root@localhost user account is to execute mysql_install_db with a\nspecial option. If mysql_install_db is executed while\n--auth-root-authentication-method=normal is specified, then it will create the\ndefault user accounts using the default behavior of MariaDB 10.3 and before.\n\nThis means that the root@localhost user account will use mysql_native_password\nauthentication by default. There are some other differences as well. See\nmysql_install_db: User Accounts Created by Default for more information.\n\nFor example, the option can be set on the command-line while running\nmysql_install_db:\n\nmysql_install_db --user=mysql --datadir=/var/lib/mysql\n--auth-root-authentication-method=normal\n\nThe option can also be set in an option file in an option group supported by\nmysql_install_db. For example:\n\n[mysql_install_db]\nauth_root_authentication_method=normal\n\nIf the option is set in an option file and if mysql_install_db is executed,\nthen mysql_install_db will read this option from the option file, and it will\nautomatically set this option.\n\nAltering the User Account to Revert to the Previous Authentication Method\n-------------------------------------------------------------------------\n\nIf you have already installed MariaDB, and if the root@localhost user account\nis already using unix_socket authentication, then you can revert to the old\nmysql_native_password authentication method for the user account by executing\nthe following:\n\nALTER USER root@localhost IDENTIFIED VIA mysql_native_password USING\nPASSWORD(\"verysecret\")\n\nURL: https://mariadb.com/kb/en/authentication-from-mariadb-104/','','https://mariadb.com/kb/en/authentication-from-mariadb-104/'),(119,'ST_X',11,'Syntax\n------\n\nST_X(p)\nX(p)\n\nDescription\n-----------\n\nReturns the X-coordinate value for the point p as a double-precision number.\n\nST_X() and X() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT X(GeomFromText(@pt));\n+----------------------+\n| X(GeomFromText(@pt)) |\n+----------------------+\n|                 56.7 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_x/','','https://mariadb.com/kb/en/st_x/'),(88,'IF Function',7,'Syntax\n------\n\nIF(expr1,expr2,expr3)\n\nDescription\n-----------\n\nIf expr1 is TRUE (expr1 <> 0 and expr1 <> NULL) then IF() returns expr2;\notherwise it returns expr3. IF() returns a numeric or string value, depending\non the context in which it is used.\n\nNote: There is also an IF statement which differs from the IF() function\ndescribed here.\n\nExamples\n--------\n\nSELECT IF(1>2,2,3);\n+-------------+\n| IF(1>2,2,3) |\n+-------------+\n|           3 |\n+-------------+\n\nSELECT IF(1<2,\'yes\',\'no\');\n+--------------------+\n| IF(1<2,\'yes\',\'no\') |\n+--------------------+\n| yes                |\n+--------------------+\n\nSELECT IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\');\n+---------------------------------------+\n| IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\') |\n+---------------------------------------+\n| no                                    |\n+---------------------------------------+\n\nURL: https://mariadb.com/kb/en/if-function/','','https://mariadb.com/kb/en/if-function/'),(89,'IFNULL',7,'Syntax\n------\n\nIFNULL(expr1,expr2)\nNVL(expr1,expr2)\n\nDescription\n-----------\n\nIf expr1 is not NULL, IFNULL() returns expr1; otherwise it returns expr2.\nIFNULL() returns a numeric or string value, depending on the context in which\nit is used.\n\nFrom MariaDB 10.3, NVL() is an alias for IFNULL().\n\nExamples\n--------\n\nSELECT IFNULL(1,0); \n+-------------+\n| IFNULL(1,0) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT IFNULL(NULL,10);\n+-----------------+\n| IFNULL(NULL,10) |\n+-----------------+\n|              10 |\n+-----------------+\n\nSELECT IFNULL(1/0,10);\n+----------------+\n| IFNULL(1/0,10) |\n+----------------+\n|        10.0000 |\n+----------------+\n\nSELECT IFNULL(1/0,\'yes\');\n+-------------------+\n| IFNULL(1/0,\'yes\') |\n+-------------------+\n| yes               |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/ifnull/','','https://mariadb.com/kb/en/ifnull/'),(94,'START TRANSACTION',8,'Syntax\n------\n\nSTART TRANSACTION [transaction_property [, transaction_property] ...] | BEGIN\n[WORK]\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nROLLBACK [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nSET autocommit = {0 | 1}\n\ntransaction_property:\n  WITH CONSISTENT SNAPSHOT\n | READ WRITE\n | READ ONLY\n\nDescription\n-----------\n\nThe START TRANSACTION or BEGIN statement begins a new transaction. COMMIT\ncommits the current transaction, making its changes permanent. ROLLBACK rolls\nback the current transaction, canceling its changes. The SET autocommit\nstatement disables or enables the default autocommit mode for the current\nsession.\n\nSTART TRANSACTION and SET autocommit = 1 implicitly commit the current\ntransaction, if any.\n\nThe optional WORK keyword is supported for COMMIT and ROLLBACK, as are the\nCHAIN and RELEASE clauses. CHAIN and RELEASE can be used for additional\ncontrol over transaction completion. The value of the completion_type system\nvariable determines the default completion behavior.\n\nThe AND CHAIN clause causes a new transaction to begin as soon as the current\none ends, and the new transaction has the same isolation level as the\njust-terminated transaction. The RELEASE clause causes the server to\ndisconnect the current client session after terminating the current\ntransaction. Including the NO keyword suppresses CHAIN or RELEASE completion,\nwhich can be useful if the completion_type system variable is set to cause\nchaining or release completion by default.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can perform DDL\nstatements on temporary tables.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the SET TRANSACTION\nstatement, in which case the specified mode is valid for all sessions, or for\nall subsequent transaction used by the current session.\n\nautocommit\n----------\n\nBy default, MariaDB runs with autocommit mode enabled. This means that as soon\nas you execute a statement that updates (modifies) a table, MariaDB stores the\nupdate on disk to make it permanent. To disable autocommit mode, use the\nfollowing statement:\n\nSET autocommit=0;\n\nAfter disabling autocommit mode by setting the autocommit variable to zero,\nchanges to transaction-safe tables (such as those for InnoDB or NDBCLUSTER)\nare not made permanent immediately. You must use COMMIT to store your changes\nto disk or ROLLBACK to ignore the changes.\n\nTo disable autocommit mode for a single series of statements, use the START\nTRANSACTION statement.\n\nDDL Statements\n--------------\n\nDDL statements (CREATE, ALTER, DROP) and administrative statements (FLUSH,\nRESET, OPTIMIZE, ANALYZE, CHECK, REPAIR, CACHE INDEX), transaction management\nstatements (BEGIN, START TRANSACTION) and LOAD DATA INFILE, cause an implicit\nCOMMIT and start a new transaction. An exception to this rule are the DDL that\noperate on temporary tables: you can CREATE, ALTER and DROP them without\ncausing any COMMIT, but those actions cannot be rolled back. This means that\nif you call ROLLBACK, the temporary tables you created in the transaction will\nremain, while the rest of the transaction will be rolled back.\n\nTransactions cannot be used in Stored Functions or Triggers. In Stored\nProcedures and Events BEGIN is not allowed, so you should use START\nTRANSACTION instead.\n\nA transaction acquires a metadata lock on every table it accesses to prevent\nother connections from altering their structure. The lock is released at the\nend of the transaction. This happens even with non-transactional storage\nengines (like MEMORY or CONNECT), so it makes sense to use transactions with\nnon-transactional tables.\n\nin_transaction\n--------------\n\nThe in_transaction system variable is a session-only, read-only variable that\nreturns 1 inside a transaction, and 0 if not in a transaction.\n\nWITH CONSISTENT SNAPSHOT\n------------------------\n\nThe WITH CONSISTENT SNAPSHOT option starts a consistent read for storage\nengines such as InnoDB that can do so, the same as if a START TRANSACTION\nfollowed by a SELECT from any InnoDB table was issued.\n\nSee Enhancements for START TRANSACTION WITH CONSISTENT SNAPSHOT.\n\nExamples\n--------\n\nSTART TRANSACTION;\nSELECT @A:=SUM(salary) FROM table1 WHERE type=1;\nUPDATE table2 SET summary=@A WHERE type=1;\nCOMMIT;\n\nURL: https://mariadb.com/kb/en/start-transaction/','','https://mariadb.com/kb/en/start-transaction/'),(120,'ST_Y',11,'Syntax\n------\n\nST_Y(p)\nY(p)\n\nDescription\n-----------\n\nReturns the Y-coordinate value for the point p as a double-precision number.\n\nST_Y() and Y() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT Y(GeomFromText(@pt));\n+----------------------+\n| Y(GeomFromText(@pt)) |\n+----------------------+\n|                53.34 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_y/','','https://mariadb.com/kb/en/st_y/'),(121,'X',11,'A synonym for ST_X.\n\nURL: https://mariadb.com/kb/en/point-properties-x/','','https://mariadb.com/kb/en/point-properties-x/'),(122,'Y',11,'A synonym for ST_Y.\n\nURL: https://mariadb.com/kb/en/point-properties-y/','','https://mariadb.com/kb/en/point-properties-y/'),(125,'DECODE_ORACLE',12,'MariaDB starting with 10.3.2\n----------------------------\nDECODE_ORACLE is a synonym for the Oracle mode version of the DECODE function,\nand is available in all modes.\n\nURL: https://mariadb.com/kb/en/decode_oracle/','','https://mariadb.com/kb/en/decode_oracle/'),(93,'SET TRANSACTION',8,'Syntax\n------\n\nSET [GLOBAL | SESSION] TRANSACTION\n  transaction_property [, transaction_property] ...\n\ntransaction_property:\n  ISOLATION LEVEL level\n | READ WRITE\n | READ ONLY\n\nlevel:\n  REPEATABLE READ\n | READ COMMITTED\n | READ UNCOMMITTED\n | SERIALIZABLE\n\nDescription\n-----------\n\nThis statement sets the transaction isolation level or the transaction access\nmode globally, for the current session, or for the next transaction:\n\n* With the GLOBAL keyword, the statement sets the default\n transaction level globally for all subsequent sessions. Existing sessions are\n unaffected.\n* With the SESSION keyword, the statement sets the default\n transaction level for all subsequent transactions performed within the\n current session.\n* Without any SESSION or GLOBAL keyword,\n the statement sets the isolation level for the next (not started) transaction\n performed within the current session.\n\nA change to the global default isolation level requires the SUPER privilege.\nAny session is free to change its session isolation level (even in the middle\nof a transaction), or the isolation level for its next transaction.\n\nIsolation Level\n---------------\n\nTo set the global default isolation level at server startup, use the\n--transaction-isolation=level option on the command line or in an option file.\nValues of level for this option use dashes rather than spaces, so the\nallowable values are READ-UNCOMMITTED, READ-COMMITTED, REPEATABLE-READ, or\nSERIALIZABLE. For example, to set the default isolation level to REPEATABLE\nREAD, use these lines in the [mysqld] section of an option file:\n\n[mysqld]\ntransaction-isolation = REPEATABLE-READ\nTo determine the global and session transaction isolation levels at runtime,\ncheck the value of the tx_isolation system variable:\n\nSELECT @@GLOBAL.tx_isolation, @@tx_isolation;\n\nInnoDB supports each of the translation isolation levels described here using\ndifferent locking strategies. The default level is REPEATABLE READ. For\nadditional information about InnoDB record-level locks and how it uses them to\nexecute various types of statements, see InnoDB Lock Modes, and\nhttp://dev.mysql.com/doc/refman/en/innodb-locks-set.html.\n\nIsolation Levels\n----------------\n\nThe following sections describe how MariaDB supports the different transaction\nlevels.\n\nREAD UNCOMMITTED\n----------------\n\nSELECT statements are performed in a non-locking fashion, but a possible\nearlier version of a row might be used. Thus, using this isolation level, such\nreads are not consistent. This is also called a \"dirty read.\" Otherwise, this\nisolation level works like READ COMMITTED.\n\nREAD COMMITTED\n--------------\n\nA somewhat Oracle-like isolation level with respect to consistent\n(non-locking) reads: Each consistent read, even within the same transaction,\nsets and reads its own fresh snapshot. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), InnoDB locks\nonly index records, not the gaps before them, and thus allows the free\ninsertion of new records next to locked records. For UPDATE and DELETE\nstatements, locking depends on whether the statement uses a unique index with\na unique search condition (such as WHERE id = 100), or a range-type search\ncondition (such as WHERE id > 100). For a unique index with a unique search\ncondition, InnoDB locks only the index record found, not the gap before it.\nFor range-type searches, InnoDB locks the index range scanned, using gap locks\nor next-key (gap plus index-record) locks to block insertions by other\nsessions into the gaps covered by the range. This is necessary because\n\"phantom rows\" must be blocked for MySQL replication and recovery to work.\n\nNote: If the READ COMMITTED isolation level is used or the\ninnodb_locks_unsafe_for_binlog system variable is enabled, there is no InnoDB\ngap locking except for foreign-key constraint checking and duplicate-key\nchecking. Also, record locks for non-matching rows are released after MariaDB\nhas evaluated the WHERE condition.If you use READ COMMITTED or enable\ninnodb_locks_unsafe_for_binlog, you must use row-based binary logging.\n\nREPEATABLE READ\n---------------\n\nThis is the default isolation level for InnoDB. For consistent reads, there is\nan important difference from the READ COMMITTED isolation level: All\nconsistent reads within the same transaction read the snapshot established by\nthe first read. This convention means that if you issue several plain\n(non-locking) SELECT statements within the same transaction, these SELECT\nstatements are consistent also with respect to each other. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), UPDATE, and\nDELETE statements, locking depends on whether the statement uses a unique\nindex with a unique search condition, or a range-type search condition. For a\nunique index with a unique search condition, InnoDB locks only the index\nrecord found, not the gap before it. For other search conditions, InnoDB locks\nthe index range scanned, using gap locks or next-key (gap plus index-record)\nlocks to block insertions by other sessions into the gaps covered by the range.\n\nThis is the minimum isolation level for non-distributed XA transactions.\n\nSERIALIZABLE\n------------\n\nThis level is like REPEATABLE READ, but InnoDB implicitly converts all plain\nSELECT statements to SELECT ... LOCK IN SHARE MODE if autocommit is disabled.\nIf autocommit is enabled, the SELECT is its own transaction. It therefore is\nknown to be read only and can be serialized if performed as a consistent\n(non-locking) read and need not block for other transactions. (This means that\nto force a plain SELECT to block if other transactions have modified the\nselected rows, you should disable autocommit.)\n\nDistributed XA transactions should always use this isolation level.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can perform DDL\nstatements on temporary tables.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the START TRANSACTION\nstatement, in which case the specified mode is only valid for one transaction.\n\nExamples\n--------\n\nSET GLOBAL TRANSACTION ISOLATION LEVEL SERIALIZABLE;\n\nAttempting to set the isolation level within an existing transaction without\nspecifying GLOBAL or SESSION.\n\nSTART TRANSACTION;\n\nSET TRANSACTION ISOLATION LEVEL SERIALIZABLE;\nERROR 1568 (25001): Transaction characteristics can\'t be changed while a\ntransaction is in progress\n\nURL: https://mariadb.com/kb/en/set-transaction/','','https://mariadb.com/kb/en/set-transaction/'),(126,'AES_DECRYPT',12,'Syntax\n------\n\nAES_DECRYPT(crypt_str,key_str)\n\nDescription\n-----------\n\nThis function allows decryption of data using the official AES (Advanced\nEncryption Standard) algorithm. For more information, see the description of\nAES_ENCRYPT().\n\nURL: https://mariadb.com/kb/en/aes_decrypt/','','https://mariadb.com/kb/en/aes_decrypt/'),(133,'MD5',12,'Syntax\n------\n\nMD5(str)\n\nDescription\n-----------\n\nCalculates an MD5 128-bit checksum for the string.\n\nThe return value is a 32-hex digit string, and as of MariaDB 5.5, is a\nnonbinary string in the connection character set and collation, determined by\nthe values of the character_set_connection and collation_connection system\nvariables. Before 5.5, the return value was a binary string.\n\nNULL is returned if the argument was NULL.\n\nExamples\n--------\n\nSELECT MD5(\'testing\');\n+----------------------------------+\n| MD5(\'testing\')                   |\n+----------------------------------+\n| ae2b1fca515949e5d54fb22b8ed95575 |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/md5/','','https://mariadb.com/kb/en/md5/'),(95,'COMMIT',8,'The COMMIT statement ends a transaction, saving any changes to the data so\nthat they become visible to subsequent transactions. Also, unlocks metadata\nchanged by current transaction. If autocommit is set to 1, an implicit commit\nis performed after each statement. Otherwise, all transactions which don\'t end\nwith an explicit COMMIT are implicitly rollbacked and the changes are lost.\nThe ROLLBACK statement can be used to do this explicitly.\n\nThe required syntax for the COMMIT statement is as follows:\n\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\n\nCOMMIT is the more important transaction terminator, as well as the more\ninteresting one. The basic form of the COMMIT statement is simply the keyword\nCOMMIT (the keyword WORK is simply noise and can be omitted without changing\nthe effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated.\n\nRELEASE tells the server to disconnect the client immediately after the\ncurrent transaction.\n\nThere are NO RELEASE and AND NO CHAIN options. By default, commits do not\nRELEASE or CHAIN, but it\'s possible to change this default behavior with the\ncompletion_type server system variable. In this case, the AND NO CHAIN and NO\nRELEASE options override the server default.\n\nURL: https://mariadb.com/kb/en/commit/','','https://mariadb.com/kb/en/commit/'),(96,'ROLLBACK',8,'The ROLLBACK statement rolls back (ends) a transaction, destroying any changes\nto SQL-data so that they never become visible to subsequent transactions. The\nrequired syntax for the ROLLBACK statement is as follows.\n\nROLLBACK [ WORK ] [ AND [ NO ] CHAIN ] \n[ TO [ SAVEPOINT ] {<savepoint name> | <simple target specification>} ]\n\nThe ROLLBACK statement will either end a transaction, destroying all data\nchanges that happened during any of the transaction, or it will just destroy\nany data changes that happened since you established a savepoint. The basic\nform of the ROLLBACK statement is just the keyword ROLLBACK (the keyword WORK\nis simply noise and can be omitted without changing the effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated. The AND NO CHAIN option just tells your DBMS to end the\ntransaction — that is, these four SQL statements are equivalent:\n\nROLLBACK; \nROLLBACK WORK; \nROLLBACK AND NO CHAIN; \nROLLBACK WORK AND NO CHAIN;\n\nAll of them end a transaction without saving any transaction characteristics.\nThe only other options, the equivalent statements:\n\nROLLBACK AND CHAIN;\nROLLBACK WORK AND CHAIN;\n\nboth tell your DBMS to end a transaction, but to save that transaction\'s\ncharacteristics for the next transaction.\n\nROLLBACK is much simpler than COMMIT: it may involve no more than a few\ndeletions (of Cursors, locks, prepared SQL statements and log-file entries).\nIt\'s usually assumed that ROLLBACK can\'t fail, although such a thing is\nconceivable (for example, an encompassing transaction might reject an attempt\nto ROLLBACK because it\'s lining up for a COMMIT).\n\nROLLBACK cancels all effects of a transaction. It does not cancel effects on\nobjects outside the DBMS\'s control (for example the values in host program\nvariables or the settings made by some SQL/CLI function calls). But in\ngeneral, it is a convenient statement for those situations when you say \"oops,\nthis isn\'t working\" or when you simply don\'t care whether your temporary work\nbecomes permanent or not.\n\nHere is a moot question. If all you\'ve been doing is SELECTs, so that there\nhave been no data changes, should you end the transaction with ROLLBACK or\nCOMMIT? It shouldn\'t really matter because both ROLLBACK and COMMIT do the\nsame transaction-terminating job. However, the popular conception is that\nROLLBACK implies failure, so after a successful series of SELECT statements\nthe convention is to end the transaction with COMMIT rather than ROLLBACK.\n\nMariaDB (and most other DBMSs) supports rollback of SQL-data change\nstatements, but not of SQL-Schema statements. This means that if you use any\nof CREATE, ALTER, DROP, GRANT, REVOKE, you are implicitly committing at\nexecution time.\n\nINSERT INTO Table_2 VALUES(5); \nDROP TABLE Table_3 CASCADE; \nROLLBACK;\n\nThe result will be that both the INSERT and the DROP will go through as\nseparate transactions so the ROLLBACK will have no effect.\n\nURL: https://mariadb.com/kb/en/rollback/','','https://mariadb.com/kb/en/rollback/'),(138,'ENDPOINT',13,'A synonym for ST_ENDPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-endpoint/','','https://mariadb.com/kb/en/linestring-properties-endpoint/'),(139,'GLENGTH',13,'Syntax\n------\n\nGLength(ls)\n\nDescription\n-----------\n\nReturns as a double-precision number the length of the LineString value ls in\nits associated spatial reference.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT GLength(GeomFromText(@ls));\n+----------------------------+\n| GLength(GeomFromText(@ls)) |\n+----------------------------+\n|           2.82842712474619 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/glength/','','https://mariadb.com/kb/en/glength/'),(140,'NumPoints',13,'A synonym for ST_NumPoints.\n\nURL: https://mariadb.com/kb/en/linestring-properties-numpoints/','','https://mariadb.com/kb/en/linestring-properties-numpoints/'),(141,'PointN',13,'A synonym for ST_PointN.\n\nURL: https://mariadb.com/kb/en/linestring-properties-pointn/','','https://mariadb.com/kb/en/linestring-properties-pointn/'),(142,'STARTPOINT',13,'A synonym for ST_STARTPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-startpoint/','','https://mariadb.com/kb/en/linestring-properties-startpoint/'),(143,'ST_ENDPOINT',13,'Syntax\n------\n\nST_EndPoint(ls)\nEndPoint(ls)\n\nDescription\n-----------\n\nReturns the Point that is the endpoint of the LineString value ls.\n\nST_EndPoint() and EndPoint() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(EndPoint(GeomFromText(@ls)));\n+-------------------------------------+\n| AsText(EndPoint(GeomFromText(@ls))) |\n+-------------------------------------+\n| POINT(3 3)                          |\n+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_endpoint/','','https://mariadb.com/kb/en/st_endpoint/'),(144,'ST_NUMPOINTS',13,'Syntax\n------\n\nST_NumPoints(ls)\nNumPoints(ls)\n\nDescription\n-----------\n\nReturns the number of Point objects in the LineString value ls.\n\nST_NumPoints() and NumPoints() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT NumPoints(GeomFromText(@ls));\n+------------------------------+\n| NumPoints(GeomFromText(@ls)) |\n+------------------------------+\n|                            3 |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/st_numpoints/','','https://mariadb.com/kb/en/st_numpoints/'),(97,'LOCK TABLES',8,'Syntax\n------\n\nLOCK TABLE[S]\n  tbl_name [[AS] alias] lock_type\n  [, tbl_name [[AS] alias] lock_type] ...\n  [WAIT n|NOWAIT]\n\nlock_type:\n  READ [LOCAL]\n | [LOW_PRIORITY] WRITE\n | WRITE CONCURRENT\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nThe lock_type can be one of:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| READ                      | Read lock, no writes allowed                   |\n+---------------------------+------------------------------------------------+\n| READ LOCAL                | Read lock, but allow concurrent inserts        |\n+---------------------------+------------------------------------------------+\n| WRITE                     | Exclusive write lock. No other connections     |\n|                           | can read or write to this table                |\n+---------------------------+------------------------------------------------+\n| LOW_PRIORITY WRITE        | Exclusive write lock, but allow new read       |\n|                           | locks on the table until we get the write      |\n|                           | lock.                                          |\n+---------------------------+------------------------------------------------+\n| WRITE CONCURRENT          | Exclusive write lock, but allow READ LOCAL     |\n|                           | locks to the table.                            |\n+---------------------------+------------------------------------------------+\n\nMariaDB enables client sessions to acquire table locks explicitly for the\npurpose of cooperating with other sessions for access to tables, or to prevent\nother sessions from modifying tables during periods when a session requires\nexclusive access to them. A session can acquire or release locks only for\nitself. One session cannot acquire locks for another session or release locks\nheld by another session.\n\nLocks may be used to emulate transactions or to get more speed when updating\ntables.\n\nLOCK TABLES explicitly acquires table locks for the current client session.\nTable locks can be acquired for base tables or views. To use LOCK TABLES, you\nmust have the LOCK TABLES privilege, and the SELECT privilege for each object\nto be locked. See GRANT\n\nFor view locking, LOCK TABLES adds all base tables used in the view to the set\nof tables to be locked and locks them automatically. If you lock a table\nexplicitly with LOCK TABLES, any tables used in triggers are also locked\nimplicitly, as described in Triggers and Implicit Locks.\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\n\nMariaDB starting with 10.3.0\n----------------------------\n\nWAIT/NOWAIT\n-----------\n\nSet the lock wait timeout. See WAIT and NOWAIT.\n\nLimitations\n-----------\n\n* LOCK TABLES doesn\'t work when using Galera cluster.   You may experience\ncrashes or locks when used with Galera.\n* LOCK TABLES works on XtraDB/InnoDB tables only if the innodb_table_locks\nsystem variable is set to 1 (the default) and autocommit is set to 0 (1 is\ndefault). Please note that no error message will be returned on LOCK TABLES\nwith innodb_table_locks = 0.\n* LOCK TABLES implicitly commits the active transaction, if any. Also,\nstarting a transaction always releases all table locks acquired with LOCK\nTABLES. This means that there is no way to have table locks and an active\ntransaction at the same time. The only exceptions are the transactions in\nautocommit mode. To preserve the data integrity between transactional and\nnon-transactional tables, the GET_LOCK() function can be used.\n* When using LOCK TABLES on a TEMPORARY table, it will always be locked with a\nWRITE lock.\n* While a connection holds an explicit read lock on a table, it cannot modify\nit. If you try, the following error will be produced:\n\nERROR 1099 (HY000): Table \'tab_name\' was locked with a READ lock and can\'t be\nupdated\n\n* While a connection holds an explicit lock on a table, it cannot access a\nnon-locked table. If you try, the following error will be produced:\n\nERROR 1100 (HY000): Table \'tab_name\' was not locked with LOCK TABLES\n\n* While a connection holds an explicit lock on a table, it cannot issue the\nfollowing: INSERT DELAYED, CREATE TABLE, CREATE TABLE ... LIKE, and DDL\nstatements involving stored programs and views (except for triggers). If you\ntry, the following error will be produced:\n\nERROR 1192 (HY000): Can\'t execute the given command because you have active\nlocked tables or an active transaction\n\n* LOCK TABLES can not be used in stored routines - if you try, the following\nerror will be produced on creation. This restriction was removed in MariaDB\n10.6.2:\n\nERROR 1314 (0A000): LOCK is not allowed in stored procedures\n\nURL: https://mariadb.com/kb/en/lock-tables/','','https://mariadb.com/kb/en/lock-tables/'),(145,'ST_POINTN',13,'Syntax\n------\n\nST_PointN(ls,N)\nPointN(ls,N)\n\nDescription\n-----------\n\nReturns the N-th Point in the LineString value ls. Points are numbered\nbeginning with 1.\n\nST_PointN() and PointN() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(PointN(GeomFromText(@ls),2));\n+-------------------------------------+\n| AsText(PointN(GeomFromText(@ls),2)) |\n+-------------------------------------+\n| POINT(2 2)                          |\n+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_pointn/','','https://mariadb.com/kb/en/st_pointn/'),(146,'ST_STARTPOINT',13,'Syntax\n------\n\nST_StartPoint(ls)\nStartPoint(ls)\n\nDescription\n-----------\n\nReturns the Point that is the start point of the LineString value ls.\n\nST_StartPoint() and StartPoint() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(StartPoint(GeomFromText(@ls)));\n+---------------------------------------+\n| AsText(StartPoint(GeomFromText(@ls))) |\n+---------------------------------------+\n| POINT(1 1)                            |\n+---------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_startpoint/','','https://mariadb.com/kb/en/st_startpoint/'),(150,'INET_ATON',14,'Syntax\n------\n\nINET_ATON(expr)\n\nDescription\n-----------\n\nGiven the dotted-quad representation of an IPv4 network address as a string,\nreturns an integer that represents the numeric value of the address. Addresses\nmay be 4- or 8-byte addresses.\n\nReturns NULL if the argument is not understood.\n\nExamples\n--------\n\nSELECT INET_ATON(\'192.168.1.1\');\n+--------------------------+\n| INET_ATON(\'192.168.1.1\') |\n+--------------------------+\n|               3232235777 |\n+--------------------------+\n\nThis is calculated as follows: 192 x 2563 + 168 x 256 2 + 1 x 256 + 1\n\nURL: https://mariadb.com/kb/en/inet_aton/','','https://mariadb.com/kb/en/inet_aton/'),(151,'INET_NTOA',14,'Syntax\n------\n\nINET_NTOA(expr)\n\nDescription\n-----------\n\nGiven a numeric IPv4 network address in network byte order (4 or 8 byte),\nreturns the dotted-quad representation of the address as a string.\n\nExamples\n--------\n\nSELECT INET_NTOA(3232235777);\n+-----------------------+\n| INET_NTOA(3232235777) |\n+-----------------------+\n| 192.168.1.1           |\n+-----------------------+\n\n192.168.1.1 corresponds to 3232235777 since 192 x 2563 + 168 x 256 2 + 1 x 256\n+ 1 = 3232235777\n\nURL: https://mariadb.com/kb/en/inet_ntoa/','','https://mariadb.com/kb/en/inet_ntoa/'),(98,'SAVEPOINT',8,'Syntax\n------\n\nSAVEPOINT identifier\nROLLBACK [WORK] TO [SAVEPOINT] identifier\nRELEASE SAVEPOINT identifier\n\nDescription\n-----------\n\nInnoDB supports the SQL statements SAVEPOINT, ROLLBACK TO SAVEPOINT, RELEASE\nSAVEPOINT and the optional WORK keyword for ROLLBACK.\n\nEach savepoint must have a legal MariaDB identifier. A savepoint is a named\nsub-transaction.\n\nNormally ROLLBACK undoes the changes performed by the whole transaction. When\nused with the TO clause, it undoes the changes performed after the specified\nsavepoint, and erases all subsequent savepoints. However, all locks that have\nbeen acquired after the save point will survive. RELEASE SAVEPOINT does not\nrollback or commit any changes, but removes the specified savepoint.\n\nWhen the execution of a trigger or a stored function begins, it is not\npossible to use statements which reference a savepoint which was defined from\nout of that stored program.\n\nWhen a COMMIT (including implicit commits) or a ROLLBACK statement (with no TO\nclause) is performed, they act on the whole transaction, and all savepoints\nare removed.\n\nErrors\n------\n\nIf COMMIT or ROLLBACK is issued and no transaction was started, no error is\nreported.\n\nIf SAVEPOINT is issued and no transaction was started, no error is reported\nbut no savepoint is created. When ROLLBACK TO SAVEPOINT or RELEASE SAVEPOINT\nis called for a savepoint that does not exist, an error like this is issued:\n\nERROR 1305 (42000): SAVEPOINT svp_name does not exist\n\nURL: https://mariadb.com/kb/en/savepoint/','','https://mariadb.com/kb/en/savepoint/'),(99,'Metadata Locking',8,'MariaDB supports metadata locking. This means that when a transaction\n(including XA transactions) uses a table, it locks its metadata until the end\nof transaction. Non-transactional tables are also locked, as well as views and\nobjects which are related to locked tables/views (stored functions, triggers,\netc). When a connection tries to use a DDL statement (like an ALTER TABLE)\nwhich modifies a table that is locked, that connection is queued, and has to\nwait until it\'s unlocked. Using savepoints and performing a partial rollback\ndoes not release metadata locks.\n\nLOCK TABLES ... WRITE are also queued. Some wrong statements which produce an\nerror may not need to wait for the lock to be freed.\n\nThe metadata lock\'s timeout is determined by the value of the\nlock_wait_timeout server system variable (in seconds). However, note that its\ndefault value is 31536000 (1 year, MariaDB <= 10.2.3), or 86400 (1 day,\nMariaDB >= 10.2.4). If this timeout is exceeded, the following error is\nreturned:\n\nERROR 1205 (HY000): Lock wait timeout exceeded; try restarting transaction\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table stores information about existing metadata locks.\n\nMariaDB starting with 10.5.2\n----------------------------\nFrom MariaDB 10.5, the Performance Schema metadata_locks table contains\nmetadata lock information.\n\nExample\n-------\n\nLet\'s use the following MEMORY (non-transactional) table:\n\nCREATE TABLE t (a INT) ENGINE = MEMORY;\n\nConnection 1 starts a transaction, and INSERTs a row into t:\n\nSTART TRANSACTION;\n\nINSERT INTO t SET a=1;\n\nt\'s metadata is now locked by connection 1. Connection 2 tries to alter t, but\nhas to wait:\n\nALTER TABLE t ADD COLUMN b INT;\n\nConnection 2\'s prompt is blocked now.\n\nNow connection 1 ends the transaction:\n\nCOMMIT;\n\n...and connection 2 finally gets the output of its command:\n\nQuery OK, 1 row affected (35.23 sec)\nRecords: 1  Duplicates: 0  Warnings: 0\n\nURL: https://mariadb.com/kb/en/metadata-locking/','','https://mariadb.com/kb/en/metadata-locking/'),(100,'Transaction Timeouts',8,'MariaDB has always had the wait_timeout and interactive_timeout settings,\nwhich close connections after a certain period of inactivity.\n\nHowever, these are by default set to a long wait period. In situations where\ntransactions may be started, but not committed or rolled back, more granular\ncontrol and a shorter timeout may be desirable so as to avoid locks being held\nfor too long.\n\nMariaDB 10.3 introduced three new variables to handle this situation.\n\n* idle_transaction_timeout (all transactions)\n* idle_write_transaction_timeout (write transactions - called\nidle_readwrite_transaction_timeout until MariaDB 10.3.2)\n* idle_readonly_transaction_timeout (read transactions)\n\nThese accept a time in seconds to time out, by closing the connection,\ntransactions that are idle for longer than this period. By default all are set\nto zero, or no timeout.\n\nidle_transaction_timeout affects all transactions,\nidle_write_transaction_timeout affects write transactions only and\nidle_readonly_transaction_timeout affects read transactions only. The latter\ntwo variables work independently. However, if either is set along with\nidle_transaction_timeout, the settings for idle_write_transaction_timeout or\nidle_readonly_transaction_timeout will take precedence.\n\nExamples\n--------\n\nSET SESSION idle_transaction_timeout=2;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 3 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nSET SESSION idle_write_transaction_timeout=2;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 3 seconds\nSELECT * FROM t;\nEmpty set (0.000 sec)\nINSERT INTO t VALUES(1);\n## wait 3 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nSET SESSION idle_transaction_timeout=2, SESSION\nidle_readonly_transaction_timeout=10;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n ## wait 3 seconds\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 11 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nURL: https://mariadb.com/kb/en/transaction-timeouts/','','https://mariadb.com/kb/en/transaction-timeouts/'),(152,'IS_FREE_LOCK',14,'Syntax\n------\n\nIS_FREE_LOCK(str)\n\nDescription\n-----------\n\nChecks whether the lock named str is free to use (that is, not locked).\nReturns 1 if the lock is free (no one is using the lock), 0 if the lock is in\nuse, and NULL if an error occurs (such as an incorrect argument, like an empty\nstring or NULL). str is case insensitive.\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table contains information about locks of this kind (as\nwell as metadata locks).\n\nStatements using the IS_FREE_LOCK function are not safe for statement-based\nreplication.\n\nURL: https://mariadb.com/kb/en/is_free_lock/','','https://mariadb.com/kb/en/is_free_lock/'),(156,'IS_IPV6',14,'Syntax\n------\n\nIS_IPV6(expr)\n\nDescription\n-----------\n\nReturns 1 if the expression is a valid IPv6 address specified as a string,\notherwise returns 0. Does not consider IPv4 addresses to be valid IPv6\naddresses.\n\nExamples\n--------\n\nSELECT IS_IPV6(\'48f3::d432:1431:ba23:846f\');\n+--------------------------------------+\n| IS_IPV6(\'48f3::d432:1431:ba23:846f\') |\n+--------------------------------------+\n|                                    1 |\n+--------------------------------------+\n1 row in set (0.02 sec)\n\nSELECT IS_IPV6(\'10.0.1.1\');\n+---------------------+\n| IS_IPV6(\'10.0.1.1\') |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/is_ipv6/','','https://mariadb.com/kb/en/is_ipv6/'),(157,'IS_USED_LOCK',14,'Syntax\n------\n\nIS_USED_LOCK(str)\n\nDescription\n-----------\n\nChecks whether the lock named str is in use (that is, locked). If so, it\nreturns the connection identifier of the client that holds the lock.\nOtherwise, it returns NULL. str is case insensitive.\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table contains information about locks of this kind (as\nwell as metadata locks).\n\nStatements using the IS_USED_LOCK function are not safe for statement-based\nreplication.\n\nURL: https://mariadb.com/kb/en/is_used_lock/','','https://mariadb.com/kb/en/is_used_lock/'),(102,'WAIT and NOWAIT',8,'MariaDB starting with 10.3.0\n----------------------------\nMariaDB 10.3.0 introduced extended syntax so that it is possible to set\ninnodb_lock_wait_timeout and lock_wait_timeout for the following statements:\n\nSyntax\n------\n\nALTER TABLE tbl_name [WAIT n|NOWAIT] ...\nCREATE ... INDEX ON tbl_name (index_col_name, ...) [WAIT n|NOWAIT] ...\nDROP INDEX ... [WAIT n|NOWAIT]\nDROP TABLE tbl_name [WAIT n|NOWAIT] ...\nLOCK TABLE ... [WAIT n|NOWAIT]\nOPTIMIZE TABLE tbl_name [WAIT n|NOWAIT]\nRENAME TABLE tbl_name [WAIT n|NOWAIT] ...\nSELECT ... FOR UPDATE [WAIT n|NOWAIT]\nSELECT ... LOCK IN SHARE MODE [WAIT n|NOWAIT]\nTRUNCATE TABLE tbl_name [WAIT n|NOWAIT]\n\nDescription\n-----------\n\nThe lock wait timeout can be explicitly set in the statement by using either\nWAIT n (to set the wait in seconds) or NOWAIT, in which case the statement\nwill immediately fail if the lock cannot be obtained. WAIT 0 is equivalent to\nNOWAIT.\n\nURL: https://mariadb.com/kb/en/wait-and-nowait/','','https://mariadb.com/kb/en/wait-and-nowait/'),(106,'DROP USER',10,'Syntax\n------\n\nDROP USER [IF EXISTS] user_name [, user_name] ...\n\nDescription\n-----------\n\nThe DROP USER statement removes one or more MariaDB accounts. It removes\nprivilege rows for the account from all grant tables. To use this statement,\nyou must have the global CREATE USER privilege or the DELETE privilege for the\nmysql database. Each account is named using the same format as for the CREATE\nUSER statement; for example, \'jeffrey\'@\'localhost\'. If you specify only the\nuser name part of the account name, a host name part of \'%\' is used. For\nadditional information about specifying account names, see CREATE USER.\n\nNote that, if you specify an account that is currently connected, it will not\nbe deleted until the connection is closed. The connection will not be\nautomatically closed.\n\nIf any of the specified user accounts do not exist, ERROR 1396 (HY000)\nresults. If an error occurs, DROP USER will still drop the accounts that do\nnot result in an error. Only one error is produced for all users which have\nnot been dropped:\n\nERROR 1396 (HY000): Operation DROP USER failed for \'u1\'@\'%\',\'u2\'@\'%\'\n\nFailed CREATE or DROP operations, for both users and roles, produce the same\nerror code.\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the user does not exist.\n\nExamples\n--------\n\nDROP USER bob;\n\nDROP USER foo2@localhost,foo2@\'127.%\';\n\nIF EXISTS:\n\nDROP USER bob;\nERROR 1396 (HY000): Operation DROP USER failed for \'bob\'@\'%\'\n\nDROP USER IF EXISTS bob;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+---------------------------------------------+\n| Level | Code | Message                                     |\n+-------+------+---------------------------------------------+\n| Note  | 1974 | Can\'t drop user \'bob\'@\'%\'; it doesn\'t exist |\n+-------+------+---------------------------------------------+\n\nURL: https://mariadb.com/kb/en/drop-user/','','https://mariadb.com/kb/en/drop-user/'),(108,'RENAME USER',10,'Syntax\n------\n\nRENAME USER old_user TO new_user\n  [, old_user TO new_user] ...\n\nDescription\n-----------\n\nThe RENAME USER statement renames existing MariaDB accounts. To use it, you\nmust have the global CREATE USER privilege or the UPDATE privilege for the\nmysql database. Each account is named using the same format as for the CREATE\nUSER statement; for example, \'jeffrey\'@\'localhost\'. If you specify only the\nuser name part of the account name, a host name part of \'%\' is used.\n\nIf any of the old user accounts do not exist or any of the new user accounts\nalready exist, ERROR 1396 (HY000) results. If an error occurs, RENAME USER\nwill still rename the accounts that do not result in an error.\n\nExamples\n--------\n\nCREATE USER \'donald\', \'mickey\';\nRENAME USER \'donald\' TO \'duck\'@\'localhost\', \'mickey\' TO \'mouse\'@\'localhost\';\n\nURL: https://mariadb.com/kb/en/rename-user/','','https://mariadb.com/kb/en/rename-user/'),(109,'REVOKE',10,'Privileges\n----------\n\nSyntax\n------\n\nREVOKE \n  priv_type [(column_list)]\n   [, priv_type [(column_list)]] ...\n  ON [object_type] priv_level\n  FROM user [, user] ...\n\nREVOKE ALL PRIVILEGES, GRANT OPTION\n  FROM user [, user] ...\n\nDescription\n-----------\n\nThe REVOKE statement enables system administrators to revoke privileges (or\nroles - see section below) from MariaDB accounts. Each account is named using\nthe same format as for the GRANT statement; for example,\n\'jeffrey\'@\'localhost\'. If you specify only the user name part of the account\nname, a host name part of \'%\' is used. For details on the levels at which\nprivileges exist, the allowable priv_type and priv_level values, and the\nsyntax for specifying users and passwords, see GRANT.\n\nTo use the first REVOKE syntax, you must have the GRANT OPTION privilege, and\nyou must have the privileges that you are revoking.\n\nTo revoke all privileges, use the second syntax, which drops all global,\ndatabase, table, column, and routine privileges for the named user or users:\n\nREVOKE ALL PRIVILEGES, GRANT OPTION FROM user [, user] ...\n\nTo use this REVOKE syntax, you must have the global CREATE USER privilege or\nthe UPDATE privilege for the mysql database. See GRANT.\n\nExamples\n--------\n\nREVOKE SUPER ON *.* FROM \'alexander\'@\'localhost\';\n\nRoles\n-----\n\nSyntax\n------\n\nREVOKE role  [, role ...]\n  FROM grantee [, grantee2 ... ]\n\nREVOKE ADMIN OPTION FOR role FROM grantee [, grantee2]\n\nDescription\n-----------\n\nREVOKE is also used to remove a role from a user or another role that it\'s\npreviously been assigned to. If a role has previously been set as a default\nrole, REVOKE does not remove the record of the default role from the\nmysql.user table. If the role is subsequently granted again, it will again be\nthe user\'s default. Use SET DEFAULT ROLE NONE to explicitly remove this.\n\nBefore MariaDB 10.1.13, the REVOKE role statement was not permitted in\nprepared statements.\n\nExample\n-------\n\nREVOKE journalist FROM hulda\n\nURL: https://mariadb.com/kb/en/revoke/','','https://mariadb.com/kb/en/revoke/'),(160,'NAME_CONST',14,'Syntax\n------\n\nNAME_CONST(name,value)\n\nDescription\n-----------\n\nReturns the given value. When used to produce a result set column,\nNAME_CONST() causes the column to have the given name. The arguments should be\nconstants.\n\nThis function is used internally when replicating stored procedures. It makes\nlittle sense to use it explicitly in SQL statements, and it was not supposed\nto be used like that.\n\nSELECT NAME_CONST(\'myname\', 14);\n+--------+\n| myname |\n+--------+\n|     14 |\n+--------+\n\nURL: https://mariadb.com/kb/en/name_const/','','https://mariadb.com/kb/en/name_const/'),(163,'SLEEP',14,'Syntax\n------\n\nSLEEP(duration)\n\nDescription\n-----------\n\nSleeps (pauses) for the number of seconds given by the duration argument, then\nreturns 0. If SLEEP() is interrupted, it returns 1. The duration may have a\nfractional part given in microseconds.\n\nStatements using the SLEEP() function are not safe for replication.\n\nExample\n-------\n\nSELECT SLEEP(5.5);\n+------------+\n| SLEEP(5.5) |\n+------------+\n|          0 |\n+------------+\n1 row in set (5.50 sec)\n\nURL: https://mariadb.com/kb/en/sleep/','','https://mariadb.com/kb/en/sleep/'),(167,'!',15,'Syntax\n------\n\nNOT, !\n\nDescription\n-----------\n\nLogical NOT. Evaluates to 1 if the operand is 0, to 0 if the operand is\nnon-zero, and NOT NULL returns NULL.\n\nBy default, the ! operator has a higher precedence. If the HIGH_NOT_PRECEDENCE\nSQL_MODE flag is set, NOT and ! have the same precedence.\n\nExamples\n--------\n\nSELECT NOT 10;\n+--------+\n| NOT 10 |\n+--------+\n|      0 |\n+--------+\n\nSELECT NOT 0;\n+-------+\n| NOT 0 |\n+-------+\n|     1 |\n+-------+\n\nSELECT NOT NULL;\n+----------+\n| NOT NULL |\n+----------+\n|     NULL |\n+----------+\n\nSELECT ! (1+1);\n+---------+\n| ! (1+1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ! 1+1;\n+-------+\n| ! 1+1 |\n+-------+\n|     1 |\n+-------+\n\nURL: https://mariadb.com/kb/en/not/','','https://mariadb.com/kb/en/not/'),(110,'SET PASSWORD',10,'Syntax\n------\n\nSET PASSWORD [FOR user] =\n  {\n    PASSWORD(\'some password\')\n   | OLD_PASSWORD(\'some password\')\n   | \'encrypted password\'\n  }\n\nDescription\n-----------\n\nThe SET PASSWORD statement assigns a password to an existing MariaDB user\naccount.\n\nIf the password is specified using the PASSWORD() or OLD_PASSWORD() function,\nthe literal text of the password should be given. If the password is specified\nwithout using either function, the password should be the already-encrypted\npassword value as returned by PASSWORD().\n\nOLD_PASSWORD() should only be used if your MariaDB/MySQL clients are very old\n(< 4.0.0).\n\nWith no FOR clause, this statement sets the password for the current user. Any\nclient that has connected to the server using a non-anonymous account can\nchange the password for that account.\n\nWith a FOR clause, this statement sets the password for a specific account on\nthe current server host. Only clients that have the UPDATE privilege for the\nmysql database can do this. The user value should be given in\nuser_name@host_name format, where user_name and host_name are exactly as they\nare listed in the User and Host columns of the mysql.user table (or view in\nMariaDB-10.4 onwards) entry.\n\nThe argument to PASSWORD() and the password given to MariaDB clients can be of\narbitrary length.\n\nAuthentication Plugin Support\n-----------------------------\n\nMariaDB starting with 10.4\n--------------------------\nIn MariaDB 10.4 and later, SET PASSWORD (with or without PASSWORD()) works for\naccounts authenticated via any authentication plugin that supports passwords\nstored in the mysql.global_priv table.\n\nThe ed25519, mysql_native_password, and mysql_old_password authentication\nplugins store passwords in the mysql.global_priv table.\n\nIf you run SET PASSWORD on an account that authenticates with one of these\nauthentication plugins that stores passwords in the mysql.global_priv table,\nthen the PASSWORD() function is evaluated by the specific authentication\nplugin used by the account. The authentication plugin hashes the password with\na method that is compatible with that specific authentication plugin.\n\nThe unix_socket, named_pipe, gssapi, and pam authentication plugins do not\nstore passwords in the mysql.global_priv table. These authentication plugins\nrely on other methods to authenticate the user.\n\nIf you attempt to run SET PASSWORD on an account that authenticates with one\nof these authentication plugins that doesn\'t store a password in the\nmysql.global_priv table, then MariaDB Server will raise a warning like the\nfollowing:\n\nSET PASSWORD is ignored for users authenticating via unix_socket plugin\n\nSee Authentication from MariaDB 10.4 for an overview of authentication changes\nin MariaDB 10.4.\n\nMariaDB until 10.3\n------------------\nIn MariaDB 10.3 and before, SET PASSWORD (with or without PASSWORD()) only\nworks for accounts authenticated via mysql_native_password or\nmysql_old_password authentication plugins\n\nPasswordless User Accounts\n--------------------------\n\nUser accounts do not always require passwords to login.\n\nThe unix_socket , named_pipe and gssapi authentication plugins do not require\na password to authenticate the user.\n\nThe pam authentication plugin may or may not require a password to\nauthenticate the user, depending on the specific configuration.\n\nThe mysql_native_password and mysql_old_password authentication plugins\nrequire passwords for authentication, but the password can be blank. In that\ncase, no password is required.\n\nIf you provide a password while attempting to log into the server as an\naccount that doesn\'t require a password, then MariaDB server will simply\nignore the password.\n\nMariaDB starting with 10.4\n--------------------------\nIn MariaDB 10.4 and later, a user account can be defined to use multiple\nauthentication plugins in a specific order of preference. This specific\nscenario may be more noticeable in these versions, since an account could be\nassociated with some authentication plugins that require a password, and some\nthat do not.\n\nExample\n-------\n\nFor example, if you had an entry with User and Host column values of \'bob\' and\n\'%.loc.gov\', you would write the statement like this:\n\nSET PASSWORD FOR \'bob\'@\'%.loc.gov\' = PASSWORD(\'newpass\');\n\nIf you want to delete a password for a user, you would do:\n\nSET PASSWORD FOR \'bob\'@localhost = PASSWORD(\"\");\n\nURL: https://mariadb.com/kb/en/set-password/','','https://mariadb.com/kb/en/set-password/'),(112,'DROP ROLE',10,'Syntax\n------\n\nDROP ROLE [IF EXISTS] role_name [,role_name ...]\n\nDescription\n-----------\n\nThe DROP ROLE statement removes one or more MariaDB roles. To use this\nstatement, you must have the global CREATE USER privilege or the DELETE\nprivilege for the mysql database.\n\nDROP ROLE does not disable roles for connections which selected them with SET\nROLE. If a role has previously been set as a default role, DROP ROLE does not\nremove the record of the default role from the mysql.user table. If the role\nis subsequently recreated and granted, it will again be the user\'s default.\nUse SET DEFAULT ROLE NONE to explicitly remove this.\n\nIf any of the specified user accounts do not exist, ERROR 1396 (HY000)\nresults. If an error occurs, DROP ROLE will still drop the roles that do not\nresult in an error. Only one error is produced for all roles which have not\nbeen dropped:\n\nERROR 1396 (HY000): Operation DROP ROLE failed for \'a\',\'b\',\'c\'\n\nFailed CREATE or DROP operations, for both users and roles, produce the same\nerror code.\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a warning instead of an\nerror if the role does not exist.\n\nExamples\n--------\n\nDROP ROLE journalist;\n\nThe same thing using the optional IF EXISTS clause:\n\nDROP ROLE journalist;\nERROR 1396 (HY000): Operation DROP ROLE failed for \'journalist\'\n\nDROP ROLE IF EXISTS journalist;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nNote (Code 1975): Can\'t drop role \'journalist\'; it doesn\'t exist\n\nURL: https://mariadb.com/kb/en/drop-role/','','https://mariadb.com/kb/en/drop-role/'),(168,'&&',15,'Syntax\n------\n\nAND, &&\n\nDescription\n-----------\n\nLogical AND. Evaluates to 1 if all operands are non-zero and not NULL, to 0 if\none or more operands are 0, otherwise NULL is returned.\n\nFor this operator, short-circuit evaluation can be used.\n\nExamples\n--------\n\nSELECT 1 && 1;\n+--------+\n| 1 && 1 |\n+--------+\n|      1 |\n+--------+\n\nSELECT 1 && 0;\n+--------+\n| 1 && 0 |\n+--------+\n|      0 |\n+--------+\n\nSELECT 1 && NULL;\n+-----------+\n| 1 && NULL |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT 0 && NULL;\n+-----------+\n| 0 && NULL |\n+-----------+\n|         0 |\n+-----------+\n\nSELECT NULL && 0;\n+-----------+\n| NULL && 0 |\n+-----------+\n|         0 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/and/','','https://mariadb.com/kb/en/and/'),(169,'XOR',15,'Syntax\n------\n\nXOR\n\nDescription\n-----------\n\nXOR stands for eXclusive OR. Returns NULL if either operand is NULL. For\nnon-NULL operands, evaluates to 1 if an odd number of operands is non-zero,\notherwise 0 is returned.\n\nExamples\n--------\n\nSELECT 1 XOR 1;\n+---------+\n| 1 XOR 1 |\n+---------+\n|       0 |\n+---------+\n\nSELECT 1 XOR 0;\n+---------+\n| 1 XOR 0 |\n+---------+\n|       1 |\n+---------+\n\nSELECT 1 XOR NULL;\n+------------+\n| 1 XOR NULL |\n+------------+\n|       NULL |\n+------------+\n\nIn the following example, the right 1 XOR 1 is evaluated first, and returns 0.\nThen, 1 XOR 0 is evaluated, and 1 is returned.\n\nSELECT 1 XOR 1 XOR 1;\n+---------------+\n| 1 XOR 1 XOR 1 |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/xor/','','https://mariadb.com/kb/en/xor/'),(111,'CREATE ROLE',10,'Syntax\n------\n\nCREATE [OR REPLACE] ROLE [IF NOT EXISTS] role \n [WITH ADMIN\n  {CURRENT_USER | CURRENT_ROLE | user | role}]\n\nDescription\n-----------\n\nThe CREATE ROLE statement creates one or more MariaDB roles. To use it, you\nmust have the global CREATE USER privilege or the INSERT privilege for the\nmysql database. For each account, CREATE ROLE creates a new row in the\nmysql.user table that has no privileges, and with the corresponding is_role\nfield set to Y. It also creates a record in the mysql.roles_mapping table.\n\nIf any of the specified roles already exist, ERROR 1396 (HY000) results. If an\nerror occurs, CREATE ROLE will still create the roles that do not result in an\nerror. The maximum length for a role is 128 characters. Role names can be\nquoted, as explained in the Identifier names page. Only one error is produced\nfor all roles which have not been created:\n\nERROR 1396 (HY000): Operation CREATE ROLE failed for \'a\',\'b\',\'c\'\n\nFailed CREATE or DROP operations, for both users and roles, produce the same\nerror code.\n\nPUBLIC and NONE are reserved, and cannot be used as role names. NONE is used\nto unset a role and PUBLIC has a special use in other systems, such as Oracle,\nso is reserved for compatibility purposes.\n\nFor valid identifiers to use as role names, see Identifier Names.\n\nWITH ADMIN\n----------\n\nThe optional WITH ADMIN clause determines whether the current user, the\ncurrent role or another user or role has use of the newly created role. If the\nclause is omitted, WITH ADMIN CURRENT_USER is treated as the default, which\nmeans that the current user will be able to GRANT this role to users.\n\nOR REPLACE\n----------\n\nIf the optional OR REPLACE clause is used, it acts as a shortcut for:\n\nDROP ROLE IF EXISTS name;\nCREATE ROLE name ...;\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified role already exists. Cannot be used together with\nthe OR REPLACE clause.\n\nExamples\n--------\n\nCREATE ROLE journalist;\n\nCREATE ROLE developer WITH ADMIN lorinda@localhost;\n\nGranting the role to another user. Only user lorinda@localhost has permission\nto grant the developer role:\n\nSELECT USER();\n+-------------------+\n| USER()            |\n+-------------------+\n| henning@localhost |\n+-------------------+\n...\nGRANT developer TO ian@localhost;\nAccess denied for user \'henning\'@\'localhost\'\n\nSELECT USER();\n+-------------------+\n| USER()            |\n+-------------------+\n| lorinda@localhost |\n+-------------------+\n\nGRANT m_role TO ian@localhost;\n\nThe OR REPLACE and IF NOT EXISTS clauses. The journalist role already exists:\n\nCREATE ROLE journalist;\nERROR 1396 (HY000): Operation CREATE ROLE failed for \'journalist\'\n\nCREATE OR REPLACE ROLE journalist;\nQuery OK, 0 rows affected (0.00 sec)\n\nCREATE ROLE IF NOT EXISTS journalist;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+---------------------------------------------------+\n| Level | Code | Message                                           |\n+-------+------+---------------------------------------------------+\n| Note  | 1975 | Can\'t create role \'journalist\'; it already exists |\n+-------+------+---------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/create-role/','','https://mariadb.com/kb/en/create-role/'),(113,'SET ROLE',10,'Syntax\n------\n\nSET ROLE { role | NONE }\n\nDescription\n-----------\n\nThe SET ROLE statement enables a role, along with all of its associated\npermissions, for the current session. To unset a role, use NONE .\n\nIf a role that doesn\'t exist, or to which the user has not been assigned, is\nspecified, an ERROR 1959 (OP000): Invalid role specification error occurs.\n\nAn automatic SET ROLE is implicitly performed when a user connects if that\nuser has been assigned a default role. See SET DEFAULT ROLE.\n\nExample\n-------\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| NULL         |\n+--------------+\n\nSET ROLE staff;\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| staff        |\n+--------------+\n\nSET ROLE NONE;\n\nSELECT CURRENT_ROLE();\n+----------------+\n| CURRENT_ROLE() |\n+----------------+\n| NULL           |\n+----------------+\n\nURL: https://mariadb.com/kb/en/set-role/','','https://mariadb.com/kb/en/set-role/'),(114,'SET DEFAULT ROLE',10,'Syntax\n------\n\nSET DEFAULT ROLE { role | NONE } [ FOR user@host ]\n\nDescription\n-----------\n\nThe SET DEFAULT ROLE statement sets a default role for a specified (or\ncurrent) user. A default role is automatically enabled when a user connects\n(an implicit SET ROLE statement is executed immediately after a connection is\nestablished).\n\nTo be able to set a role as a default, the role must already have been granted\nto that user, and one needs the privileges to enable this role (if you cannot\ndo SET ROLE X, you won\'t be able to do SET DEFAULT ROLE X). To set a default\nrole for another user one needs to have write access to the mysql database.\n\nTo remove a user\'s default role, use SET DEFAULT ROLE NONE [ FOR user@host ].\nThe record of the default role is not removed if the role is dropped or\nrevoked, so if the role is subsequently re-created or granted, it will again\nbe the user\'s default role.\n\nThe default role is stored in the default_role column in the mysql.user\ntable/view, as well as in the Information Schema APPLICABLE_ROLES table, so\nthese can be viewed to see which role has been assigned to a user as the\ndefault.\n\nExamples\n--------\n\nSetting a default role for the current user:\n\nSET DEFAULT ROLE journalist;\n\nRemoving a default role from the current user:\n\nSET DEFAULT ROLE NONE;\n\nSetting a default role for another user. The role has to have been granted to\nthe user before it can be set as default:\n\nCREATE ROLE journalist;\nCREATE USER taniel;\n\nSET DEFAULT ROLE journalist FOR taniel;\nERROR 1959 (OP000): Invalid role specification `journalist`\n\nGRANT journalist TO taniel;\nSET DEFAULT ROLE journalist FOR taniel;\n\nViewing mysql.user:\n\nselect * from mysql.user where user=\'taniel\'\\G\n*************************** 1. row ***************************\n         Host: %\n         User: taniel\n...\n       is_role: N\n     default_role: journalist\n...\n\nRemoving a default role for another user\n\nSET DEFAULT ROLE NONE FOR taniel;\n\nURL: https://mariadb.com/kb/en/set-default-role/','','https://mariadb.com/kb/en/set-default-role/'),(184,'STDDEV_SAMP',16,'Syntax\n------\n\nSTDDEV_SAMP(expr)\n\nDescription\n-----------\n\nReturns the sample standard deviation of expr (the square root of VAR_SAMP()).\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nSTDDEV_SAMP() can be used as a window function.\n\nSTDDEV_SAMP() returns NULL if there were no matching rows.\n\nURL: https://mariadb.com/kb/en/stddev_samp/','','https://mariadb.com/kb/en/stddev_samp/'),(189,'BENCHMARK',17,'Syntax\n------\n\nBENCHMARK(count,expr)\n\nDescription\n-----------\n\nThe BENCHMARK() function executes the expression expr repeatedly count times.\nIt may be used to time how quickly MariaDB processes the expression. The\nresult value is always 0. The intended use is from within the mysql client,\nwhich reports query execution times.\n\nExamples\n--------\n\nSELECT BENCHMARK(1000000,ENCODE(\'hello\',\'goodbye\'));\n+----------------------------------------------+\n| BENCHMARK(1000000,ENCODE(\'hello\',\'goodbye\')) |\n+----------------------------------------------+\n|                                            0 |\n+----------------------------------------------+\n1 row in set (0.21 sec)\n\nURL: https://mariadb.com/kb/en/benchmark/','','https://mariadb.com/kb/en/benchmark/'),(115,'Roles Overview',10,'Description\n-----------\n\nA role bundles a number of privileges together. It assists larger\norganizations where, typically, a number of users would have the same\nprivileges, and, previously, the only way to change the privileges for a group\nof users was by changing each user\'s privileges individually.\n\nAlternatively, multiple external users could have been assigned the same user,\nand there would have been no way to see which actual user was responsible for\nwhich action.\n\nWith roles, managing this is easy. For example, there could be a number of\nusers assigned to a journalist role, with identical privileges. Changing the\nprivileges for all the journalists is a matter of simply changing the role\'s\nprivileges, while the individual user is still linked with any changes that\ntake place.\n\nRoles are created with the CREATE ROLE statement, and dropped with the DROP\nROLE statement. Roles are then assigned to a user with an extension to the\nGRANT statement, while privileges are assigned to a role in the regular way\nwith GRANT. Similarly, the REVOKE statement can be used to both revoke a role\nfrom a user, or revoke a privilege from a role.\n\nOnce a user has connected, he can obtain all privileges associated with a role\nby setting a role with the SET ROLE statement. The CURRENT_ROLE function\nreturns the currently set role for the session, if any.\n\nOnly roles granted directly to a user can be set, roles granted to other roles\ncannot. Instead the privileges granted to a role, which is, in turn, granted\nto another role (grantee), will be immediately available to any user who sets\nthis second grantee role.\n\nThe SET DEFAULT ROLE statement allows one to set a default role for a user. A\ndefault role is automatically enabled when a user connects (an implicit SET\nROLE statement is executed immediately after a connection is established).\n\nRoles were implemented as a GSoC 2013 project by Vicentiu Ciorbaru.\n\nSystem Tables\n-------------\n\nInformation about roles and who they\'ve been granted to can be found in the\nInformation Schema APPLICABLE_ROLES table as well as the mysql.ROLES_MAPPING\ntable.\n\nThe Information Schema ENABLED_ROLES table shows the enabled roles for the\ncurrent session.\n\nExamples\n--------\n\nCreating a role and granting a privilege:\n\nCREATE ROLE journalist;\n\nGRANT SHOW DATABASES ON *.* TO journalist;\n\nGRANT journalist to hulda;\n\nNote, that hulda has no SHOW DATABASES privilege, even though she was granted\nthe journalist role. She needs to set the role first:\n\nSHOW DATABASES;\n+--------------------+\n| Database           |\n+--------------------+\n| information_schema |\n+--------------------+\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| NULL         |\n+--------------+\n\nSET ROLE journalist;\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| journalist   |\n+--------------+\n\nSHOW DATABASES;\n+--------------------+\n| Database           |\n+--------------------+\n| ...                |\n| information_schema |\n| mysql              |\n| performance_schema |\n| test               |\n| ...                |\n+--------------------+\n\nSET ROLE NONE;\n\nRoles can be granted to roles:\n\nCREATE ROLE writer;\n\nGRANT SELECT ON data.* TO writer;\n\nGRANT writer TO journalist;\n\nBut one does not need to set a role granted to a role. For example, hulda will\nautomatically get all writer privileges when she sets the journalist role:\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| NULL         |\n+--------------+\n\nSHOW TABLES FROM data;\nEmpty set (0.01 sec)\n\nSET ROLE journalist;\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| journalist   |\n+--------------+\n\nSHOW TABLES FROM data;\n+------------------------------+\n| Tables_in_data               |\n+------------------------------+\n| set1                         |\n| ...                          |\n+------------------------------+\n\nRoles and Views (and Stored Routines)\n-------------------------------------\n\nWhen a user sets a role, he, in a sense, has two identities with two\nassociated sets of privileges. But a view (or a stored routine) can have only\none definer. So, when a view (or a stored routine) is created with the SQL\nSECURITY DEFINER, one can specify whether the definer should be CURRENT_USER\n(and the view will have none of the privileges of the user\'s role) or\nCURRENT_ROLE (in this case, the view will use role\'s privileges, but none of\nthe user\'s privileges). As a result, sometimes one can create a view that is\nimpossible to use.\n\nCREATE ROLE r1;\n\nGRANT ALL ON db1.* TO r1;\n\nGRANT r1 TO foo@localhost;\n\nGRANT ALL ON db.* TO foo@localhost;\n\nSELECT CURRENT_USER\n+---------------+\n| current_user  |\n+---------------+\n| foo@localhost |\n+---------------+\n\nSET ROLE r1;\n\nCREATE TABLE db1.t1 (i int);\n\nCREATE VIEW db.v1 AS SELECT * FROM db1.t1;\n\nSHOW CREATE VIEW db.v1;\n+------+-----------------------------------------------------------------------\n------------------------------------------------------------------+------------\n---------+----------------------+\n| View | Create View                                                          \n                                 |\ncharacter_set_client | collation_connection |\n+------+-----------------------------------------------------------------------\n------------------------------------------------------------------+------------\n---------+----------------------+\n| v1   | CREATE ALGORITHM=UNDEFINED DEFINER=`foo`@`localhost` SQL SECURITY\nDEFINER VIEW `db`.`v1` AS SELECT `db1`.`t1`.`i` AS `i` from `db1`.`t1` | utf8 \n       | utf8_general_ci      |\n+------+-----------------------------------------------------------------------\n------------------------------------------------------------------+------------\n---------+----------------------+\n\nCREATE DEFINER=CURRENT_ROLE VIEW db.v2 AS SELECT * FROM db1.t1;\n\nSHOW CREATE VIEW db.b2;\n+------+-----------------------------------------------------------------------\n-----------------------------------------------------+----------------------+--\n-------------------+\n| View | Create View                                                          \n                           | character_set_client |\ncollation_connection |\n+------+-----------------------------------------------------------------------\n-----------------------------------------------------+----------------------+--\n-------------------+\n| v2   | CREATE ALGORITHM=UNDEFINED DEFINER=`r1` SQL SECURITY DEFINER VIEW\n`db`.`v2` AS select `db1`.`t1`.`a` AS `a` from `db1`.`t1` | utf8              \n | utf8_general_ci      |\n+------+-----------------------------------------------------------------------\n-----------------------------------------------------+----------------------+--\n-------------------+\n\nOther Resources\n---------------\n\n* Roles Review by Peter Gulutzan\n\nURL: https://mariadb.com/kb/en/roles_overview/','','https://mariadb.com/kb/en/roles_overview/'),(190,'BINLOG_GTID_POS',17,'Syntax\n------\n\nBINLOG_GTID_POS(binlog_filename,binlog_offset)\n\nDescription\n-----------\n\nThe BINLOG_GTID_POS() function takes as input an old-style binary log position\nin the form of a file name and a file offset. It looks up the position in the\ncurrent binlog, and returns a string representation of the corresponding GTID\nposition. If the position is not found in the current binlog, NULL is returned.\n\nExamples\n--------\n\nSELECT BINLOG_GTID_POS(\"master-bin.000001\", 600);\n\nURL: https://mariadb.com/kb/en/binlog_gtid_pos/','','https://mariadb.com/kb/en/binlog_gtid_pos/'),(116,'Account Locking',10,'MariaDB starting with 10.4.2\n----------------------------\nAccount locking was introduced in MariaDB 10.4.2.\n\nDescription\n-----------\n\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected).\n\nUser accounts can be locked at creation, with the CREATE USER statement, or\nmodified after creation with the ALTER USER statement. For example:\n\nCREATE USER \'lorin\'@\'localhost\' ACCOUNT LOCK;\n\nor\n\nALTER USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nThe server will return an ER_ACCOUNT_HAS_BEEN_LOCKED error when locked users\nattempt to connect:\n\nmysql -ulorin\n ERROR 4151 (HY000): Access denied, this account is locked\n\nThe ALTER USER statement is also used to unlock a user:\n\nALTER USER \'lorin\'@\'localhost\' ACCOUNT UNLOCK;\n\nThe SHOW CREATE USER statement will show whether the account is locked:\n\nSHOW CREATE USER \'marijn\'@\'localhost\';\n+-----------------------------------------------+\n| CREATE USER for marijn@localhost              |\n+-----------------------------------------------+\n| CREATE USER \'marijn\'@\'localhost\' ACCOUNT LOCK |\n+-----------------------------------------------+\n\nas well as querying the mysql.global_priv table:\n\nSELECT CONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv)) FROM\nmysql.global_priv \n WHERE user=\'marijn\';\n+------------------------------------------------------------------------------\n-------+\n| CONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv))                        \n    |\n+------------------------------------------------------------------------------\n-------+\n| marijn@localhost => {\n  \"access\": 0,\n  \"plugin\": \"mysql_native_password\",\n  \"authentication_string\": \"\",\n  \"account_locked\": true,\n  \"password_last_changed\": 1558017158\n} |\n+------------------------------------------------------------------------------\n-------+\n\nURL: https://mariadb.com/kb/en/account-locking/','','https://mariadb.com/kb/en/account-locking/'),(118,'User Password Expiry',10,'MariaDB starting with 10.4.3\n----------------------------\nUser password expiry was introduced in MariaDB 10.4.3.\n\nPassword expiry permits administrators to expire user passwords, either\nmanually or automatically.\n\nSystem Variables\n----------------\n\nThere are two system variables which affect password expiry:\ndefault_password_lifetime, which determines the amount of time between\nrequiring the user to change their password. 0, the default, means automatic\npassword expiry is not active.\n\nThe second variable, disconnect_on_expired_password determines whether a\nclient is permitted to connect if their password has expired, or whether they\nare permitted to connect in sandbox mode, able to perform a limited subset of\nqueries related to resetting the password, in particular SET PASSWORD and SET.\n\nSetting a Password Expiry Limit for a User\n------------------------------------------\n\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal using the CREATE USER or ALTER USER statements, for example:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nLimits can be disabled by use of the NEVER keyword, for example:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\n\nA manually set limit can be restored the system default by use of DEFAULT, for\nexample:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nSHOW CREATE USER\n----------------\n\nThe SHOW CREATE USER statement will display information about the password\nexpiry status of the user. Unlike MySQL, it will not display if the user is\nunlocked, or if the password expiry is set to default.\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\nCREATE USER \'konstantin\'@\'localhost\' PASSWORD EXPIRE NEVER;\nCREATE USER \'amse\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nSHOW CREATE USER \'monty\'@\'localhost\';\n+------------------------------------------------------------------+\n| CREATE USER for monty@localhost                                  |\n+------------------------------------------------------------------+\n| CREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY |\n+------------------------------------------------------------------+\n\nSHOW CREATE USER \'konstantin\'@\'localhost\';\n+------------------------------------------------------------+\n| CREATE USER for konstantin@localhost                       |\n+------------------------------------------------------------+\n| CREATE USER \'konstantin\'@\'localhost\' PASSWORD EXPIRE NEVER |\n+------------------------------------------------------------+\n\nSHOW CREATE USER \'amse\'@\'localhost\';\n+--------------------------------+\n| CREATE USER for amse@localhost |\n+--------------------------------+\n| CREATE USER \'amse\'@\'localhost\' |\n+--------------------------------+\n\nChecking When Passwords Expire\n------------------------------\n\nThe following query can be used to check when the current passwords expire for\nall users:\n\nWITH password_expiration_info AS (\n SELECT User, Host,\n IF(\n IFNULL(JSON_EXTRACT(Priv, \'$.password_lifetime\'), -1) = -1,\n @@global.default_password_lifetime,\n JSON_EXTRACT(Priv, \'$.password_lifetime\')\n ) AS password_lifetime,\n JSON_EXTRACT(Priv, \'$.password_last_changed\') AS password_last_changed\n FROM mysql.global_priv\n)\nSELECT pei.User, pei.Host,\n pei.password_lifetime,\n FROM_UNIXTIME(pei.password_last_changed) AS password_last_changed_datetime,\n FROM_UNIXTIME(\n pei.password_last_changed +\n (pei.password_lifetime * 60 * 60 * 24)\n ) AS password_expiration_datetime\n FROM password_expiration_info pei\n WHERE pei.password_lifetime != 0\n AND pei.password_last_changed IS NOT NULL\nUNION\nSELECT pei.User, pei.Host,\n pei.password_lifetime,\n FROM_UNIXTIME(pei.password_last_changed) AS password_last_changed_datetime,\n 0 AS password_expiration_datetime\n FROM password_expiration_info pei\n WHERE pei.password_lifetime = 0\n OR pei.password_last_changed IS NULL;\n\n--connect-expired-password Client Option\n----------------------------------------\n\nThe mysql client --connect-expired-password option notifies the server that\nthe client is prepared to handle expired password sandbox mode (even if the\n--batch option was specified).\n\nURL: https://mariadb.com/kb/en/user-password-expiry/','','https://mariadb.com/kb/en/user-password-expiry/'),(193,'COLLATION',17,'Syntax\n------\n\nCOLLATION(str)\n\nDescription\n-----------\n\nReturns the collation of the string argument. If str is not a string, it is\nconsidered as a binary string (so the function returns \'binary\'). This applies\nto NULL, too. The return value is a string in the utf8 character set.\n\nSee Character Sets and Collations.\n\nExamples\n--------\n\nSELECT COLLATION(\'abc\');\n+-------------------+\n| COLLATION(\'abc\')  |\n+-------------------+\n| latin1_swedish_ci |\n+-------------------+\n\nSELECT COLLATION(_utf8\'abc\');\n+-----------------------+\n| COLLATION(_utf8\'abc\') |\n+-----------------------+\n| utf8_general_ci       |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/collation/','','https://mariadb.com/kb/en/collation/'),(194,'CONNECTION_ID',17,'Syntax\n------\n\nCONNECTION_ID()\n\nDescription\n-----------\n\nReturns the connection ID for the connection. Every connection (including\nevents) has an ID that is unique among the set of currently connected clients.\n\nUntil MariaDB 10.3.1, returns MYSQL_TYPE_LONGLONG, or bigint(10), in all\ncases. From MariaDB 10.3.1, returns MYSQL_TYPE_LONG, or int(10), when the\nresult would fit within 32-bits.\n\nExamples\n--------\n\nSELECT CONNECTION_ID();\n+-----------------+\n| CONNECTION_ID() |\n+-----------------+\n|               3 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/connection_id/','','https://mariadb.com/kb/en/connection_id/'),(123,'UNCOMPRESS',12,'Syntax\n------\n\nUNCOMPRESS(string_to_uncompress)\n\nDescription\n-----------\n\nUncompresses a string compressed by the COMPRESS() function. If the argument\nis not a compressed value, the result is NULL. This function requires MariaDB\nto have been compiled with a compression library such as zlib. Otherwise, the\nreturn value is always NULL. The have_compress server system variable\nindicates whether a compression library is present.\n\nExamples\n--------\n\nSELECT UNCOMPRESS(COMPRESS(\'a string\'));\n+----------------------------------+\n| UNCOMPRESS(COMPRESS(\'a string\')) |\n+----------------------------------+\n| a string                         |\n+----------------------------------+\n\nSELECT UNCOMPRESS(\'a string\');\n+------------------------+\n| UNCOMPRESS(\'a string\') |\n+------------------------+\n| NULL                   |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/uncompress/','','https://mariadb.com/kb/en/uncompress/'),(124,'DECODE',12,'Syntax\n------\n\nDECODE(crypt_str,pass_str)\n\nIn Oracle mode from MariaDB 10.3.2:\n\nDECODE(expr, search_expr, result_expr [, search_expr2, result_expr2 ...]\n[default_expr])\n\nIn all modes from MariaDB 10.3.2:\n\nDECODE_ORACLE(expr, search_expr, result_expr [, search_expr2, result_expr2\n...] [default_expr])\n\nDescription\n-----------\n\nIn the default mode, DECODE decrypts the encrypted string crypt_str using\npass_str as the password. crypt_str should be a string returned from ENCODE().\nThe resulting string will be the original string only if pass_str is the same.\n\nIn Oracle mode from MariaDB 10.3.2, DECODE compares expr to the search\nexpressions, in order. If it finds a match, the corresponding result\nexpression is returned. If no matches are found, the default expression is\nreturned, or NULL if no default is provided.\n\nNULLs are treated as equivalent.\n\nDECODE_ORACLE is a synonym for the Oracle-mode version of the function, and is\navailable in all modes.\n\nExamples\n--------\n\nFrom MariaDB 10.3.2:\n\nSELECT DECODE_ORACLE(2+1,3*1,\'found1\',3*2,\'found2\',\'default\');\n+--------------------------------------------------------+\n| DECODE_ORACLE(2+1,3*1,\'found1\',3*2,\'found2\',\'default\') |\n+--------------------------------------------------------+\n| found1                                                 |\n+--------------------------------------------------------+\n\nSELECT DECODE_ORACLE(2+4,3*1,\'found1\',3*2,\'found2\',\'default\');\n+--------------------------------------------------------+\n| DECODE_ORACLE(2+4,3*1,\'found1\',3*2,\'found2\',\'default\') |\n+--------------------------------------------------------+\n| found2                                                 |\n+--------------------------------------------------------+\n\nSELECT DECODE_ORACLE(2+2,3*1,\'found1\',3*2,\'found2\',\'default\');\n+--------------------------------------------------------+\n| DECODE_ORACLE(2+2,3*1,\'found1\',3*2,\'found2\',\'default\') |\n+--------------------------------------------------------+\n| default                                                |\n+--------------------------------------------------------+\n\nNulls are treated as equivalent:\n\nSELECT DECODE_ORACLE(NULL,NULL,\'Nulls are equivalent\',\'Nulls are not\nequivalent\');\n+----------------------------------------------------------------------------+\n| DECODE_ORACLE(NULL,NULL,\'Nulls are equivalent\',\'Nulls are not equivalent\') |\n+----------------------------------------------------------------------------+\n| Nulls are equivalent                                                       |\n+----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/decode/','','https://mariadb.com/kb/en/decode/'),(127,'AES_ENCRYPT',12,'Syntax\n------\n\nAES_ENCRYPT(str,key_str)\n\nDescription\n-----------\n\nAES_ENCRYPT() and AES_DECRYPT() allow encryption and decryption of data using\nthe official AES (Advanced Encryption Standard) algorithm, previously known as\n\"Rijndael.\" Encoding with a 128-bit key length is used, but you can extend it\nup to 256 bits by modifying the source. We chose 128 bits because it is much\nfaster and it is secure enough for most purposes.\n\nAES_ENCRYPT() encrypts a string str using the key key_str, and returns a\nbinary string.\n\nAES_DECRYPT() decrypts the encrypted string and returns the original string.\n\nThe input arguments may be any length. If either argument is NULL, the result\nof this function is also NULL.\n\nBecause AES is a block-level algorithm, padding is used to encode uneven\nlength strings and so the result string length may be calculated using this\nformula:\n\n16 x (trunc(string_length / 16) + 1)\n\nIf AES_DECRYPT() detects invalid data or incorrect padding, it returns NULL.\nHowever, it is possible for AES_DECRYPT() to return a non-NULL value (possibly\ngarbage) if the input data or the key is invalid.\n\nExamples\n--------\n\nINSERT INTO t VALUES (AES_ENCRYPT(\'text\',SHA2(\'password\',512)));\n\nURL: https://mariadb.com/kb/en/aes_encrypt/','','https://mariadb.com/kb/en/aes_encrypt/'),(205,'SCHEMA',17,'Syntax\n------\n\nSCHEMA()\n\nDescription\n-----------\n\nThis function is a synonym for DATABASE().\n\nURL: https://mariadb.com/kb/en/schema/','','https://mariadb.com/kb/en/schema/'),(206,'SESSION_USER',17,'Syntax\n------\n\nSESSION_USER()\n\nDescription\n-----------\n\nSESSION_USER() is a synonym for USER().\n\nURL: https://mariadb.com/kb/en/session_user/','','https://mariadb.com/kb/en/session_user/'),(207,'SYSTEM_USER',17,'Syntax\n------\n\nSYSTEM_USER()\n\nDescription\n-----------\n\nSYSTEM_USER() is a synonym for USER().\n\nURL: https://mariadb.com/kb/en/system_user/','','https://mariadb.com/kb/en/system_user/'),(210,'Assignment Operator (:=)',18,'Syntax\n------\n\nvar_name := expr\n\nDescription\n-----------\n\nAssignment operator for assigning a value. The value on the right is assigned\nto the variable on left.\n\nUnlike the = operator, := can always be used to assign a value to a variable.\n\nThis operator works with both user-defined variables and local variables.\n\nWhen assigning the same value to several variables, LAST_VALUE() can be useful.\n\nExamples\n--------\n\nSELECT @x := 10;\n+----------+\n| @x := 10 |\n+----------+\n|       10 |\n+----------+\n\nSELECT @x, @y := @x;\n+------+----------+\n| @x   | @y := @x |\n+------+----------+\n|   10 |       10 |\n+------+----------+\n\nURL: https://mariadb.com/kb/en/assignment-operator/','','https://mariadb.com/kb/en/assignment-operator/'),(221,'GREATEST',19,'Syntax\n------\n\nGREATEST(value1,value2,...)\n\nDescription\n-----------\n\nWith two or more arguments, returns the largest (maximum-valued) argument. The\narguments are compared using the same rules as for LEAST().\n\nExamples\n--------\n\nSELECT GREATEST(2,0);\n+---------------+\n| GREATEST(2,0) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT GREATEST(34.0,3.0,5.0,767.0);\n+------------------------------+\n| GREATEST(34.0,3.0,5.0,767.0) |\n+------------------------------+\n|                        767.0 |\n+------------------------------+\n\nSELECT GREATEST(\'B\',\'A\',\'C\');\n+-----------------------+\n| GREATEST(\'B\',\'A\',\'C\') |\n+-----------------------+\n| C                     |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/greatest/','','https://mariadb.com/kb/en/greatest/'),(226,'IS NOT NULL',19,'Syntax\n------\n\nIS NOT NULL\n\nDescription\n-----------\n\nTests whether a value is not NULL. See also NULL Values in MariaDB.\n\nExamples\n--------\n\nSELECT 1 IS NOT NULL, 0 IS NOT NULL, NULL IS NOT NULL;\n+---------------+---------------+------------------+\n| 1 IS NOT NULL | 0 IS NOT NULL | NULL IS NOT NULL |\n+---------------+---------------+------------------+\n|             1 |             1 |                0 |\n+---------------+---------------+------------------+\n\nURL: https://mariadb.com/kb/en/is-not-null/','','https://mariadb.com/kb/en/is-not-null/'),(128,'COMPRESS',12,'Syntax\n------\n\nCOMPRESS(string_to_compress)\n\nDescription\n-----------\n\nCompresses a string and returns the result as a binary string. This function\nrequires MariaDB to have been compiled with a compression library such as\nzlib. Otherwise, the return value is always NULL. The compressed string can be\nuncompressed with UNCOMPRESS().\n\nThe have_compress server system variable indicates whether a compression\nlibrary is present.\n\nExamples\n--------\n\nSELECT LENGTH(COMPRESS(REPEAT(\'a\',1000)));\n+------------------------------------+\n| LENGTH(COMPRESS(REPEAT(\'a\',1000))) |\n+------------------------------------+\n|                                 21 |\n+------------------------------------+\n\nSELECT LENGTH(COMPRESS(\'\'));\n+----------------------+\n| LENGTH(COMPRESS(\'\')) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSELECT LENGTH(COMPRESS(\'a\'));\n+-----------------------+\n| LENGTH(COMPRESS(\'a\')) |\n+-----------------------+\n|                    13 |\n+-----------------------+\n\nSELECT LENGTH(COMPRESS(REPEAT(\'a\',16)));\n+----------------------------------+\n| LENGTH(COMPRESS(REPEAT(\'a\',16))) |\n+----------------------------------+\n|                               15 |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/compress/','','https://mariadb.com/kb/en/compress/'),(129,'DES_DECRYPT',12,'DES_DECRYPT has been deprecated from MariaDB 10.10.0, and will be removed in a\nfuture release.\n\nSyntax\n------\n\nDES_DECRYPT(crypt_str[,key_str])\n\nDescription\n-----------\n\nDecrypts a string encrypted with DES_ENCRYPT(). If an error occurs, this\nfunction returns NULL.\n\nThis function works only if MariaDB has been configured with TLS support.\n\nIf no key_str argument is given, DES_DECRYPT() examines the first byte of the\nencrypted string to determine the DES key number that was used to encrypt the\noriginal string, and then reads the key from the DES key file to decrypt the\nmessage. For this to work, the user must have the SUPER privilege. The key\nfile can be specified with the --des-key-file server option.\n\nIf you pass this function a key_str argument, that string is used as the key\nfor decrypting the message.\n\nIf the crypt_str argument does not appear to be an encrypted string, MariaDB\nreturns the given crypt_str.\n\nURL: https://mariadb.com/kb/en/des_decrypt/','','https://mariadb.com/kb/en/des_decrypt/'),(130,'DES_ENCRYPT',12,'DES_ENCRYPT has been deprecated from MariaDB 10.10.0, and will be removed in a\nfuture release.\n\nSyntax\n------\n\nDES_ENCRYPT(str[,{key_num|key_str}])\n\nDescription\n-----------\n\nEncrypts the string with the given key using the Triple-DES algorithm.\n\nThis function works only if MariaDB has been configured with TLS support.\n\nThe encryption key to use is chosen based on the second argument to\nDES_ENCRYPT(), if one was given. With no argument, the first key from the DES\nkey file is used. With a key_num argument, the given key number (0-9) from the\nDES key file is used. With a key_str argument, the given key string is used to\nencrypt str.\n\nThe key file can be specified with the --des-key-file server option.\n\nThe return string is a binary string where the first character is CHAR(128 |\nkey_num). If an error occurs, DES_ENCRYPT() returns NULL.\n\nThe 128 is added to make it easier to recognize an encrypted key. If you use a\nstring key, key_num is 127.\n\nThe string length for the result is given by this formula:\n\nnew_len = orig_len + (8 - (orig_len % 8)) + 1\n\nEach line in the DES key file has the following format:\n\nkey_num des_key_str\n\nEach key_num value must be a number in the range from 0 to 9. Lines in the\nfile may be in any order. des_key_str is the string that is used to encrypt\nthe message. There should be at least one space between the number and the\nkey. The first key is the default key that is used if you do not specify any\nkey argument to DES_ENCRYPT().\n\nYou can tell MariaDB to read new key values from the key file with the FLUSH\nDES_KEY_FILE statement. This requires the RELOAD privilege.\n\nOne benefit of having a set of default keys is that it gives applications a\nway to check for the existence of encrypted column values, without giving the\nend user the right to decrypt those values.\n\nExamples\n--------\n\nSELECT customer_address FROM customer_table \n WHERE crypted_credit_card = DES_ENCRYPT(\'credit_card_number\');\n\nURL: https://mariadb.com/kb/en/des_encrypt/','','https://mariadb.com/kb/en/des_encrypt/'),(131,'ENCODE',12,'Syntax\n------\n\nENCODE(str,pass_str)\n\nDescription\n-----------\n\nENCODE is not considered cryptographically secure, and should not be used for\npassword encryption.\n\nEncrypt str using pass_str as the password. To decrypt the result, use\nDECODE().\n\nThe result is a binary string of the same length as str.\n\nThe strength of the encryption is based on how good the random generator is.\n\nIt is not recommended to rely on the encryption performed by the ENCODE\nfunction. Using a salt value (changed when a password is updated) will improve\nmatters somewhat, but for storing passwords, consider a more cryptographically\nsecure function, such as SHA2().\n\nExamples\n--------\n\nENCODE(\'not so secret text\', CONCAT(\'random_salt\',\'password\'))\n\nURL: https://mariadb.com/kb/en/encode/','','https://mariadb.com/kb/en/encode/'),(228,'ISNULL',19,'Syntax\n------\n\nISNULL(expr)\n\nDescription\n-----------\n\nIf expr is NULL, ISNULL() returns 1, otherwise it returns 0.\n\nSee also NULL Values in MariaDB.\n\nExamples\n--------\n\nSELECT ISNULL(1+1);\n+-------------+\n| ISNULL(1+1) |\n+-------------+\n|           0 |\n+-------------+\n\nSELECT ISNULL(1/0);\n+-------------+\n| ISNULL(1/0) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/isnull/','','https://mariadb.com/kb/en/isnull/'),(232,'&',20,'Syntax\n------\n\n&\n\nDescription\n-----------\n\nBitwise AND. Converts the values to binary and compares bits. Only if both the\ncorresponding bits are 1 is the resulting bit also 1.\n\nSee also bitwise OR.\n\nExamples\n--------\n\nSELECT 2&1;\n+-----+\n| 2&1 |\n+-----+\n|   0 |\n+-----+\n\nSELECT 3&1;\n+-----+\n| 3&1 |\n+-----+\n|   1 |\n+-----+\n\nSELECT 29 & 15;\n+---------+\n| 29 & 15 |\n+---------+\n|      13 |\n+---------+\n\nURL: https://mariadb.com/kb/en/bitwise_and/','','https://mariadb.com/kb/en/bitwise_and/'),(233,'<<',20,'Syntax\n------\n\nvalue1 << value2\n\nDescription\n-----------\n\nConverts a longlong (BIGINT) number (value1) to binary and shifts value2 units\nto the left.\n\nExamples\n--------\n\nSELECT 1 << 2;\n+--------+\n| 1 << 2 |\n+--------+\n|      4 |\n+--------+\n\nURL: https://mariadb.com/kb/en/shift-left/','','https://mariadb.com/kb/en/shift-left/'),(234,'>>',20,'Syntax\n------\n\nvalue1 >> value2\n\nDescription\n-----------\n\nConverts a longlong (BIGINT) number (value1) to binary and shifts value2 units\nto the right.\n\nExamples\n--------\n\nSELECT 4 >> 2;\n+--------+\n| 4 >> 2 |\n+--------+\n|      1 |\n+--------+\n\nURL: https://mariadb.com/kb/en/shift-right/','','https://mariadb.com/kb/en/shift-right/'),(235,'BIT_COUNT',20,'Syntax\n------\n\nBIT_COUNT(N)\n\nDescription\n-----------\n\nReturns the number of bits that are set in the argument N.\n\nExamples\n--------\n\nSELECT BIT_COUNT(29), BIT_COUNT(b\'101010\');\n+---------------+----------------------+\n| BIT_COUNT(29) | BIT_COUNT(b\'101010\') |\n+---------------+----------------------+\n|             4 |                    3 |\n+---------------+----------------------+\n\nURL: https://mariadb.com/kb/en/bit_count/','','https://mariadb.com/kb/en/bit_count/'),(132,'ENCRYPT',12,'Syntax\n------\n\nENCRYPT(str[,salt])\n\nDescription\n-----------\n\nEncrypts a string using the Unix crypt() system call, returning an encrypted\nbinary string. The salt argument should be a string with at least two\ncharacters or the returned result will be NULL. If no salt argument is given,\na random value of sufficient length is used.\n\nIt is not recommended to use ENCRYPT() with utf16, utf32 or ucs2 multi-byte\ncharacter sets because the crypt() system call expects a string terminated\nwith a zero byte.\n\nNote that the underlying crypt() system call may have some limitations, such\nas ignoring all but the first eight characters.\n\nIf the have_crypt system variable is set to NO (because the crypt() system\ncall is not available), the ENCRYPT function will always return NULL.\n\nExamples\n--------\n\nSELECT ENCRYPT(\'encrypt me\');\n+-----------------------+\n| ENCRYPT(\'encrypt me\') |\n+-----------------------+\n| 4I5BsEx0lqTDk         |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/encrypt/','','https://mariadb.com/kb/en/encrypt/'),(134,'OLD_PASSWORD',12,'Syntax\n------\n\nOLD_PASSWORD(str)\n\nDescription\n-----------\n\nOLD_PASSWORD() was added to MySQL when the implementation of PASSWORD() was\nchanged to improve security. OLD_PASSWORD() returns the value of the old\n(pre-MySQL 4.1) implementation of PASSWORD() as a string, and is intended to\npermit you to reset passwords for any pre-4.1 clients that need to connect to\na more recent MySQL server version, or any version of MariaDB, without locking\nthem out.\n\nAs of MariaDB 5.5, the return value is a nonbinary string in the connection\ncharacter set and collation, determined by the values of the\ncharacter_set_connection and collation_connection system variables. Before\n5.5, the return value was a binary string.\n\nThe return value is 16 bytes in length, or NULL if the argument was NULL.\n\nURL: https://mariadb.com/kb/en/old_password/','','https://mariadb.com/kb/en/old_password/'),(135,'PASSWORD',12,'Syntax\n------\n\nPASSWORD(str)\n\nDescription\n-----------\n\nThe PASSWORD() function is used for hashing passwords for use in\nauthentication by the MariaDB server. It is not intended for use in other\napplications.\n\nCalculates and returns a hashed password string from the plaintext password\nstr. Returns an empty string (>= MariaDB 10.0.4) if the argument was NULL.\n\nThe return value is a nonbinary string in the connection character set and\ncollation, determined by the values of the character_set_connection and\ncollation_connection system variables.\n\nThis is the function that is used for hashing MariaDB passwords for storage in\nthe Password column of the user table (see privileges), usually used with the\nSET PASSWORD statement. It is not intended for use in other applications.\n\nUntil MariaDB 10.3, the return value is 41-bytes in length, and the first\ncharacter is always \'*\'. From MariaDB 10.4, the function takes into account\nthe authentication plugin where applicable (A CREATE USER or SET PASSWORD\nstatement). For example, when used in conjunction with a user authenticated by\nthe ed25519 plugin, the statement will create a longer hash:\n\nCREATE USER edtest@localhost IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nCREATE USER edtest2@localhost IDENTIFIED BY \'secret\';\n\nSELECT CONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv)) FROM\nmysql.global_priv\n WHERE user LIKE \'edtest%\'\\G\n*************************** 1. row ***************************\nCONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv)): edtest@localhost => {\n...\n  \"plugin\": \"ed25519\",\n  \"authentication_string\": \"ZIgUREUg5PVgQ6LskhXmO+eZLS0nC8be6HPjYWR4YJY\",\n...\n}\n*************************** 2. row ***************************\nCONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv)): edtest2@localhost => {\n...\n  \"plugin\": \"mysql_native_password\",\n  \"authentication_string\": \"*14E65567ABDB5135D0CFD9A70B3032C179A49EE7\",\n...\n}\n\nThe behavior of this function is affected by the value of the old_passwords\nsystem variable. If this is set to 1 (0 is default), MariaDB reverts to using\nthe mysql_old_password authentication plugin by default for newly created\nusers and passwords.\n\nExamples\n--------\n\nSELECT PASSWORD(\'notagoodpwd\');\n+-------------------------------------------+\n| PASSWORD(\'notagoodpwd\')                   |\n+-------------------------------------------+\n| *3A70EE9FC6594F88CE9E959CD51C5A1C002DC937 |\n+-------------------------------------------+\n\nSET PASSWORD FOR \'bob\'@\'%.loc.gov\' = PASSWORD(\'newpass\');\n\nURL: https://mariadb.com/kb/en/password/','','https://mariadb.com/kb/en/password/'),(136,'SHA1',12,'Syntax\n------\n\nSHA1(str), SHA(str)\n\nDescription\n-----------\n\nCalculates an SHA-1 160-bit checksum for the string str, as described in RFC\n3174 (Secure Hash Algorithm).\n\nThe value is returned as a string of 40 hex digits, or NULL if the argument\nwas NULL. As of MariaDB 5.5, the return value is a nonbinary string in the\nconnection character set and collation, determined by the values of the\ncharacter_set_connection and collation_connection system variables. Before\n5.5, the return value was a binary string.\n\nExamples\n--------\n\nSELECT SHA1(\'some boring text\');\n+------------------------------------------+\n| SHA1(\'some boring text\')                 |\n+------------------------------------------+\n| af969fc2085b1bb6d31e517d5c456def5cdd7093 |\n+------------------------------------------+\n\nURL: https://mariadb.com/kb/en/sha1/','','https://mariadb.com/kb/en/sha1/'),(236,'^',20,'Syntax\n------\n\n^\n\nDescription\n-----------\n\nBitwise XOR. Converts the values to binary and compares bits. If one (and only\none) of the corresponding bits is 1 is the resulting bit also 1.\n\nExamples\n--------\n\nSELECT 1 ^ 1;\n+-------+\n| 1 ^ 1 |\n+-------+\n|     0 |\n+-------+\n\nSELECT 1 ^ 0;\n+-------+\n| 1 ^ 0 |\n+-------+\n|     1 |\n+-------+\n\nSELECT 11 ^ 3;\n+--------+\n| 11 ^ 3 |\n+--------+\n|      8 |\n+--------+\n\nURL: https://mariadb.com/kb/en/bitwise-xor/','','https://mariadb.com/kb/en/bitwise-xor/'),(237,'|',20,'Syntax\n------\n\n|\n\nDescription\n-----------\n\nBitwise OR. Converts the values to binary and compares bits. If either of the\ncorresponding bits has a value of 1, the resulting bit is also 1.\n\nSee also bitwise AND.\n\nExamples\n--------\n\nSELECT 2|1;\n+-----+\n| 2|1 |\n+-----+\n|   3 |\n+-----+\n\nSELECT 29 | 15;\n+---------+\n| 29 | 15 |\n+---------+\n|      31 |\n+---------+\n\nURL: https://mariadb.com/kb/en/bitwise-or/','','https://mariadb.com/kb/en/bitwise-or/'),(238,'~',20,'Syntax\n------\n\n~\n\nDescription\n-----------\n\nBitwise NOT. Converts the value to 4 bytes binary and inverts all bits.\n\nExamples\n--------\n\nSELECT 3 & ~1;\n+--------+\n| 3 & ~1 |\n+--------+\n|      2 |\n+--------+\n\nSELECT 5 & ~1;\n+--------+\n| 5 & ~1 |\n+--------+\n|      4 |\n+--------+\n\nURL: https://mariadb.com/kb/en/bitwise-not/','','https://mariadb.com/kb/en/bitwise-not/'),(240,'TRUE FALSE',20,'Description\n-----------\n\nThe constants TRUE and FALSE evaluate to 1 and 0, respectively. The constant\nnames can be written in any lettercase.\n\nExamples\n--------\n\nSELECT TRUE, true, FALSE, false;\n+------+------+-------+-------+\n| TRUE | TRUE | FALSE | FALSE |\n+------+------+-------+-------+\n|    1 |    1 |     0 |     0 |\n+------+------+-------+-------+\n\nURL: https://mariadb.com/kb/en/true-false/','','https://mariadb.com/kb/en/true-false/'),(243,'CHECK VIEW',21,'Syntax\n------\n\nCHECK VIEW view_name\n\nDescription\n-----------\n\nThe CHECK VIEW statement was introduced in MariaDB 10.0.18 to assist with\nfixing MDEV-6916, an issue introduced in MariaDB 5.2 where the view algorithms\nwere swapped. It checks whether the view algorithm is correct. It is run as\npart of mysql_upgrade, and should not normally be required in regular use.\n\nURL: https://mariadb.com/kb/en/check-view/','','https://mariadb.com/kb/en/check-view/'),(137,'SHA2',12,'Syntax\n------\n\nSHA2(str,hash_len)\n\nDescription\n-----------\n\nGiven a string str, calculates an SHA-2 checksum, which is considered more\ncryptographically secure than its SHA-1 equivalent. The SHA-2 family includes\nSHA-224, SHA-256, SHA-384, and SHA-512, and the hash_len must correspond to\none of these, i.e. 224, 256, 384 or 512. 0 is equivalent to 256.\n\nThe return value is a nonbinary string in the connection character set and\ncollation, determined by the values of the character_set_connection and\ncollation_connection system variables.\n\nNULL is returned if the hash length is not valid, or the string str is NULL.\n\nSHA2 will only work if MariaDB was has been configured with TLS support.\n\nExamples\n--------\n\nSELECT SHA2(\'Maria\',224);\n+----------------------------------------------------------+\n| SHA2(\'Maria\',224)                                        |\n+----------------------------------------------------------+\n| 6cc67add32286412efcab9d0e1675a43a5c2ef3cec8879f81516ff83 |\n+----------------------------------------------------------+\n\nSELECT SHA2(\'Maria\',256);\n+------------------------------------------------------------------+\n| SHA2(\'Maria\',256)                                                |\n+------------------------------------------------------------------+\n| 9ff18ebe7449349f358e3af0b57cf7a032c1c6b2272cb2656ff85eb112232f16 |\n+------------------------------------------------------------------+\n\nSELECT SHA2(\'Maria\',0);\n+------------------------------------------------------------------+\n| SHA2(\'Maria\',0)                                                  |\n+------------------------------------------------------------------+\n| 9ff18ebe7449349f358e3af0b57cf7a032c1c6b2272cb2656ff85eb112232f16 |\n+------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/sha2/','','https://mariadb.com/kb/en/sha2/'),(148,'INET6_ATON',14,'Syntax\n------\n\nINET6_ATON(expr)\n\nDescription\n-----------\n\nGiven an IPv6 or IPv4 network address as a string, returns a binary string\nthat represents the numeric value of the address.\n\nNo trailing zone ID\'s or traling network masks are permitted. For IPv4\naddresses, or IPv6 addresses with IPv4 address parts, no classful addresses or\ntrailing port numbers are permitted and octal numbers are not supported.\n\nThe returned binary string will be VARBINARY(16) or VARBINARY(4) for IPv6 and\nIPv4 addresses respectively.\n\nReturns NULL if the argument is not understood.\n\nMariaDB starting with 10.5.0\n----------------------------\nFrom MariaDB 10.5.0, INET6_ATON can take INET6 as an argument.\n\nExamples\n--------\n\nSELECT HEX(INET6_ATON(\'10.0.1.1\'));\n+-----------------------------+\n| HEX(INET6_ATON(\'10.0.1.1\')) |\n+-----------------------------+\n| 0A000101                    |\n+-----------------------------+\n\nSELECT HEX(INET6_ATON(\'48f3::d432:1431:ba23:846f\'));\n+----------------------------------------------+\n| HEX(INET6_ATON(\'48f3::d432:1431:ba23:846f\')) |\n+----------------------------------------------+\n| 48F3000000000000D4321431BA23846F             |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/inet6_aton/','','https://mariadb.com/kb/en/inet6_aton/'),(149,'INET6_NTOA',14,'Syntax\n------\n\nINET6_NTOA(expr)\n\nDescription\n-----------\n\nGiven an IPv6 or IPv4 network address as a numeric binary string, returns the\naddress as a nonbinary string in the connection character set.\n\nThe return string is lowercase, and is platform independent, since it does not\nuse functions specific to the operating system. It has a maximum length of 39\ncharacters.\n\nReturns NULL if the argument is not understood.\n\nExamples\n--------\n\nSELECT INET6_NTOA(UNHEX(\'0A000101\'));\n+-------------------------------+\n| INET6_NTOA(UNHEX(\'0A000101\')) |\n+-------------------------------+\n| 10.0.1.1                      |\n+-------------------------------+\n\nSELECT INET6_NTOA(UNHEX(\'48F3000000000000D4321431BA23846F\'));\n+-------------------------------------------------------+\n| INET6_NTOA(UNHEX(\'48F3000000000000D4321431BA23846F\')) |\n+-------------------------------------------------------+\n| 48f3::d432:1431:ba23:846f                             |\n+-------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/inet6_ntoa/','','https://mariadb.com/kb/en/inet6_ntoa/'),(153,'IS_IPV4',14,'Syntax\n------\n\nIS_IPV4(expr)\n\nDescription\n-----------\n\nIf the expression is a valid IPv4 address, returns 1, otherwise returns 0.\n\nIS_IPV4() is stricter than INET_ATON(), but as strict as INET6_ATON(), in\ndetermining the validity of an IPv4 address. This implies that if IS_IPV4\nreturns 1, the same expression will always return a non-NULL result when\npassed to INET_ATON(), but that the reverse may not apply.\n\nExamples\n--------\n\nSELECT IS_IPV4(\'1110.0.1.1\');\n+-----------------------+\n| IS_IPV4(\'1110.0.1.1\') |\n+-----------------------+\n|                     0 |\n+-----------------------+\n\nSELECT IS_IPV4(\'48f3::d432:1431:ba23:846f\');\n+--------------------------------------+\n| IS_IPV4(\'48f3::d432:1431:ba23:846f\') |\n+--------------------------------------+\n|                                    0 |\n+--------------------------------------+\n\nURL: https://mariadb.com/kb/en/is_ipv4/','','https://mariadb.com/kb/en/is_ipv4/'),(270,'CHAR BYTE',23,'Description\n-----------\n\nThe CHAR BYTE data type is an alias for the BINARY data type. This is a\ncompatibility feature.\n\nURL: https://mariadb.com/kb/en/char-byte/','','https://mariadb.com/kb/en/char-byte/'),(272,'INET6',23,'MariaDB starting with 10.5.0\n----------------------------\nThe INET6 data type was added in MariaDB 10.5.0\n\nSyntax\n------\n\nINET6\n\nDescription\n-----------\n\nThe INET6 data type is intended for storage of IPv6 addresses, as well as IPv4\naddresses assuming conventional mapping of IPv4 addresses into IPv6 addresses.\n\nBoth short and long IPv6 notation are permitted, according to RFC-5952.\n\n* Values are stored as a 16-byte fixed length binary string, with most\nsignificant byte first.\n* Storage engines see INET6 as BINARY(16).\n* Clients see INET6 as CHAR(39) and get text representation on retrieval.\n\nThe IPv4-compatible notation is considered as deprecated. It is supported for\ncompatibility with the INET6_ATON function, which also understands this\nformat. It\'s recommended to use the mapped format to store IPv4 addresses in\nINET6.\n\nWhen an IPv4 mapped (or compatible) value is stored in INET6, it still\noccupies 16 bytes:\n\nRetrieval\n---------\n\nOn retrieval, in the client-server text protocol, INET6 values are converted\nto the short text representation, according to RFC-5952, that is with all\nleading zeroes in each group removed and with consequent zero groups\ncompressed.\n\nBesides creating one\'s own stored function, there is no a way to retrieve an\nINET6 value using long text representation.\n\nCasting\n-------\n\n* CAST from a character string to INET6 understands addresses in short or long\ntext notation (including IPv4 mapped and compatible addresses). NULL is\nreturned if the format is not understood.\n* CAST from a binary string to INET6 requires a 16-byte string as an argument.\nNULL is returned if the argument length is not equal to 16.\n* CAST from other data types to INET6 first converts data to a character\nstring, then CAST from character string to INET6 is applied.\n* CAST from INET6 to CHAR returns short text address notation.\n* CAST from INET6 to BINARY returns its 16-byte binary string representation.\n* CAST from INET6 to data types other than CHAR (e.g. SIGNED, UNSIGNED, TIME,\netc) returns an error.\n\nComparisons\n-----------\n\nAn INET6 expression can be compared to:\n\n* another INET6 expression\n* a character string expression with a text (short or long) address\nrepresentation:\n* a 16-byte binary string expression:\n\nAttempting to compare INET6 to an expression of any other data type returns an\nerror.\n\nMixing INET6 Values for Result\n------------------------------\n\nAn INET6 expression can be mixed for result (i.e. UNION, CASE..THEN, COALESCE\netc) with:\n\n* another INET6 expression. The resulting data type is INET6.\n* a character string in text (short or long) address representation. The\nresult data type is INET6. The character string counterpart is automatically\nconverted to INET6. If the string format is not understood, it\'s converted\nwith a warning to either NULL or to \'::\', depending on the NULL-ability of the\nresult.\n* a 16-byte binary string. The resulting data type is INET6. The binary string\ncounterpart is automatically converted to INET6. If the length of the binary\nstring is not equal to 16, it\'s converted with a warning to NULL or to \'::\'\ndepending on the NULL-ability of the result.\n\nAttempts to mix INET6 for result with other data types will return an error.\n\nMixing INET6 with other data types for LEAST and GREATEST, when mixing for\ncomparison and mixing for result are involved at the same time, uses the same\nrules with mixing for result, described in the previous paragraphs.\n\nFunctions and Operators\n-----------------------\n\n* HEX() with an INET6 argument returns a hexadecimal representation of the\nunderlying 16-byte binary string\n* Arithmetic operators (+,-,*,/,MOD,DIV) are not supported for INET6. This may\nchange in the future.\n* The INET6_ATON function now understands INET6 values as an argument\n* The prototypes of the IS_IPV4_COMPAT and IS_IPV4_MAPPED functions have\nchanged from a BINARY(16) to a INET6,\n* When the argument for these two functions is not INET6, automatic implicit\nCAST to INET6 is applied. As a consequence, both functions now understand\narguments in both text representation and binary(16) representation. Before\nMariaDB 10.5.0, these functions understood only binary(16) representation.\n\nPrepared Statement Parameters\n-----------------------------\n\nINET6 understands both text and binary(16) address representation in prepared\nstatement parameters (PREPARE..EXECUTE and EXECUTE IMMEDIATE statements).\n\nMigration between  BINARY(16) and INET6\n---------------------------------------\n\nBefore MariaDB 10.5.0, you may have used BINARY(16) as a storage for IPv6\ninternet addresses, in combination with INET6_ATON and INET6_NTOA to\nrespectively insert and retrieve data.\n\nFrom 10.5, you can ALTER BINARY(16) columns storing IPv6 addresses to INET6.\nAfter such an alter, there is no a need to use INET6_ATON() and INET6_NTOA().\nAddresses can be inserted and retrieved directly.\n\nIt is also possible to convert INET6 columns to BINARY(16) and continue using\nthe data in combination with INET6_NTOA() and INET6_ATON().\n\nExamples\n--------\n\nCREATE TABLE t1 (a INET6);\n\nInserting using short text address notation:\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n\nLong text address notation:\n\nINSERT INTO t1 VALUES (\'2001:0db8:0000:0000:0000:ff00:0042:8329\');\n\n16-byte binary string notation:\n\nINSERT INTO t1 VALUES (0x20010DB8000000000000FF0000428329);\nINSERT INTO t1 VALUES (UNHEX(\'20010DB8000000000000FF0000428329\'));\n\nIPv4 addresses, using IPv4-mapped and IPv4-compatible notations:\n\nINSERT INTO t1 VALUES (\'::ffff:192.0.2.128\'); -- mapped\nINSERT INTO t1 VALUES (\'::192.0.2.128\'); -- compatible\n\nSELECT * FROM t1;\n+------------------------+\n| a                      |\n+------------------------+\n| 2001:db8::ff00:42:8329 |\n| 2001:db8::ff00:42:8329 |\n| 2001:db8::ff00:42:8329 |\n| 2001:db8::ff00:42:8329 |\n| ::ffff:192.0.2.128     |\n| ::192.0.2.128          |\n+------------------------+\n\nIPv4 mapped (or compatible) values still occupy 16 bytes:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'::ffff:192.0.2.128\');\n\nSELECT * FROM t1;\n+--------------------+\n| a                  |\n+--------------------+\n| ::ffff:192.0.2.128 |\n+--------------------+\n\nSELECT HEX(a) FROM t1;\n+----------------------------------+\n| HEX(a)                           |\n+----------------------------------+\n| 00000000000000000000FFFFC0000280 |\n+----------------------------------+\n\nCasting from INET6 to anything other than CHAR returns an error:\n\nSELECT CAST(a AS DECIMAL) FROM t1;\n\nERROR 4079 (HY000): Illegal parameter data type inet6 for operation\n\'decimal_typecast\'\n\nComparison Examples\n-------------------\n\nComparison with another INET6 expression:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n  CREATE OR REPLACE TABLE t2 (a INET6);\n\nINSERT INTO t1 VALUES\n(\'2001:db8::ff00:42:8328\'),(\'2001:db8::ff00:42:8329\');\n  INSERT INTO t2 VALUES\n(\'2001:db8::ff00:42:832a\'),(\'2001:db8::ff00:42:8329\');\n\nSELECT t1.* FROM t1,t2 WHERE t1.a=t2.a;\n  +------------------------+\n  | a                      |\n  +------------------------+\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nWith a character string expression with a text (short or long) address\nrepresentation:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n\nSELECT * FROM t1 WHERE a=\'2001:db8::ff00:42:8329\';\n  +------------------------+\n  | a                      |\n  +------------------------+\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nWith a 16-byte binary string expression:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n\nSELECT * FROM t1 WHERE a=X\'20010DB8000000000000FF0000428329\';\n  +------------------------+\n  | a                      |\n  +------------------------+\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nWith an expression of another data type:\n\nSELECT * FROM t1 WHERE a=1;\nERROR 4078 (HY000): Illegal parameter data types inet6 and int for operation\n\'=\'\n\nMixing for Result Examples\n--------------------------\n\nMixed with another INET6 expression, returning an INET6 data type:\n\nCREATE OR REPLACE TABLE t1 (a INET6, b INET6);\n\nINSERT INTO t1 VALUES (NULL,\'2001:db8::ff00:42:8329\');\n\nSELECT a FROM t1 UNION SELECT b FROM t1;\n  +------------------------+\n  | a                      |\n  +------------------------+\n  | NULL                   |\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nSELECT COALESCE(a, b) FROM t1;\n  +------------------------+\n  | COALESCE(a, b)         |\n  +------------------------+\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nMixed with a character string in text (short or long) address representation:\n\nCREATE OR REPLACE TABLE t1 (a INET6, b VARCHAR(64));\n\nINSERT INTO t1 VALUES (NULL,\'2001:db8::ff00:42:8328\');\n\nINSERT INTO t1 VALUES (NULL,\'2001:db8::ff00:42:832a garbage\');\n\nSELECT COALESCE(a,b) FROM t1;\n  +------------------------+\n  | COALESCE(a,b)          |\n  +------------------------+\n  | 2001:db8::ff00:42:8328 |\n  | NULL                   |\n  +------------------------+\n  2 rows in set, 1 warning (0.001 sec)\n\nSHOW WARNINGS;\n\n+---------+------+---------------------------------------------------------+\n  | Level   | Code | Message\n|\n\n+---------+------+---------------------------------------------------------+\n  | Warning | 1292 | Incorrect inet6 value: \'2001:db8::ff00:42:832a garbage\'\n|\n\n+---------+------+---------------------------------------------------------+\n\nMixed with a 16-byte binary string:\n\nCREATE OR REPLACE TABLE t1 (a INET6, b VARBINARY(16));\n\nINSERT INTO t1 VALUES (NULL,CONCAT(0xFFFF,REPEAT(0x0000,6),0xFFFF));\n\nINSERT INTO t1 VALUES (NULL,0x00/*garbage*/);\n\nSELECT COALESCE(a,b) FROM t1;\n  +---------------+\n  | COALESCE(a,b) |\n  +---------------+\n  | ffff::ffff    |\n  | NULL          |\n  +---------------+\n  2 rows in set, 1 warning (0.001 sec)\n\nSHOW WARNINGS;\n  +---------+------+-------------------------------+\n  | Level   | Code | Message                       |\n  +---------+------+-------------------------------+\n  | Warning | 1292 | Incorrect inet6 value: \'\\x00\' |\n  +---------+------+-------------------------------+\n\nMixing with other data types:\n\nSELECT CAST(\'ffff::ffff\' AS INET6) UNION SELECT 1;\nERROR 4078 (HY000): Illegal parameter data types inet6 and int for operation\n\'UNION\'\n\nFunctions and Operators Examples\n--------------------------------\n\nHEX with an INET6 argument returning a hexadecimal representation:\n\nSELECT HEX(CAST(\'2001:db8::ff00:42:8329\' AS INET6));\n  +----------------------------------------------+\n  | HEX(CAST(\'2001:db8::ff00:42:8329\' AS INET6)) |\n  +----------------------------------------------+\n  | 20010DB8000000000000FF0000428329             |\n  +----------------------------------------------+\n\nINET6_ATON now understands INET6 values as an argument:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n\nSELECT a, HEX(INET6_ATON(a)) FROM t1;\n  +------------------------+----------------------------------+\n  | a                      | HEX(INET6_ATON(a))               |\n  +------------------------+----------------------------------+\n  | 2001:db8::ff00:42:8329 | 20010DB8000000000000FF0000428329 |\n  +------------------------+----------------------------------+\n\nIS_IPV4_COMPAT and IS_IPV4_MAPPED prototype now a BINARY(16)):\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n  INSERT INTO t1 VALUES (\'::ffff:192.168.0.1\');\n  INSERT INTO t1 VALUES (\'::192.168.0.1\');\n\nSELECT a, IS_IPV4_MAPPED(a), IS_IPV4_COMPAT(a) FROM t1;\n  +------------------------+-------------------+-------------------+\n  | a                      | IS_IPV4_MAPPED(a) | IS_IPV4_COMPAT(a) |\n  +------------------------+-------------------+-------------------+\n  | 2001:db8::ff00:42:8329 |                 0 |                 0 |\n  | ::ffff:192.168.0.1     |                 1 |                 0 |\n  | ::192.168.0.1          |                 0 |                 1 |\n  +------------------------+-------------------+-------------------+\n\nAutomatic implicit CAST to INET6:\n\nCREATE OR REPLACE TABLE t1 (\n   a INET6,\n   b VARCHAR(39) DEFAULT a\n  );\n\nINSERT INTO t1 (a) VALUES (\'ffff::ffff\'),(\'::ffff:192.168.0.1\');\n\nSELECT a, IS_IPV4_MAPPED(a), b, IS_IPV4_MAPPED(b) FROM t1;\n\n+--------------------+-------------------+--------------------+----------------\n--+\n  | a                  | IS_IPV4_MAPPED(a) | b                  |\nIS_IPV4_MAPPED(b) |\n\n+--------------------+-------------------+--------------------+----------------\n--+\n  | ffff::ffff         |                 0 | ffff::ffff         |\n  0 |\n  | ::ffff:192.168.0.1 |                 1 | ::ffff:192.168.0.1 |\n  1 |\n\n+--------------------+-------------------+--------------------+----------------\n--+\n\nCREATE OR REPLACE TABLE t1 (\n   a INET6,\n   b BINARY(16) DEFAULT UNHEX(HEX(a))\n  );\n\nINSERT INTO t1 (a) VALUES (\'ffff::ffff\'),(\'::ffff:192.168.0.1\');\n\nSELECT a, IS_IPV4_MAPPED(a), HEX(b), IS_IPV4_MAPPED(b) FROM t1;\n\n+--------------------+-------------------+----------------------------------+--\n----------------+\n  | a                  | IS_IPV4_MAPPED(a) | HEX(b)\n | IS_IPV4_MAPPED(b) |\n\n+--------------------+-------------------+----------------------------------+--\n----------------+\n  | ffff::ffff         |                 0 |\nFFFF000000000000000000000000FFFF |                 0 |\n  | ::ffff:192.168.0.1 |                 1 |\n00000000000000000000FFFFC0A80001 |                 1 |\n\n+--------------------+-------------------+----------------------------------+--\n----------------+\n\nPrepared Statement Parameters Examples\n--------------------------------------\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nEXECUTE IMMEDIATE \'INSERT INTO t1 VALUES (?)\' USING \'ffff::fffe\';\nEXECUTE IMMEDIATE \'INSERT INTO t1 VALUES (?)\' USING\nX\'FFFF000000000000000000000000FFFF\';\n\nSELECT * FROM t1;\n+------------+\n| a          |\n+------------+\n| ffff::fffe |\n| ffff::ffff |\n+------------+\n\nEXECUTE IMMEDIATE \'SELECT * FROM t1 WHERE a=?\' USING \'ffff::fffe\';\n+------------+\n| a          |\n+------------+\n| ffff::fffe |\n+------------+\n\nEXECUTE IMMEDIATE \'SELECT * FROM t1 WHERE a=?\' USING\nX\'FFFF000000000000000000000000FFFF\';\n+------------+\n| a          |\n+------------+\n| ffff::ffff |\n+------------+\n\nMigration between BINARY(16) and INET6 Examples\n-----------------------------------------------\n\nBefore MariaDB 10.5:\n\nCREATE OR REPLACE TABLE t1 (a BINARY(16));\n\nINSERT INTO t1 VALUES (INET6_ATON(\'ffff::ffff\'));\n\nSELECT INET6_NTOA(a) FROM t1;\n+---------------+\n| INET6_NTOA(a) |\n+---------------+\n| ffff::ffff    |\n+---------------+\n\nMigrating to INET6, from MariaDB 10.5:\n\nALTER TABLE t1 MODIFY a INET6;\n\nINSERT INTO t1 VALUES (\'ffff::fffe\');\n\nSELECT * FROM t1;\n+------------+\n| a          |\n+------------+\n| ffff::ffff |\n| ffff::fffe |\n+------------+\n\nMigration from INET6 to BINARY(16):\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\nINSERT INTO t1 VALUES (\'::ffff:192.168.0.1\');\nINSERT INTO t1 VALUES (\'::192.168.0.1\');\n\nALTER TABLE t1 MODIFY a BINARY(16);\n\nSELECT INET6_NTOA(a) FROM t1;\n+------------------------+\n| INET6_NTOA(a)          |\n+------------------------+\n| 2001:db8::ff00:42:8329 |\n| ::ffff:192.168.0.1     |\n| ::192.168.0.1          |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/inet6/','','https://mariadb.com/kb/en/inet6/'),(274,'MEDIUMBLOB',23,'Syntax\n------\n\nMEDIUMBLOB\n\nDescription\n-----------\n\nA BLOB column with a maximum length of 16,777,215 (224 - 1) bytes. Each\nMEDIUMBLOB value is stored using a three-byte length prefix that indicates the\nnumber of bytes in the value.\n\nURL: https://mariadb.com/kb/en/mediumblob/','','https://mariadb.com/kb/en/mediumblob/'),(275,'MEDIUMTEXT',23,'Syntax\n------\n\nMEDIUMTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nDescription\n-----------\n\nA TEXT column with a maximum length of 16,777,215 (224 - 1) characters. The\neffective maximum length is less if the value contains multi-byte characters.\nEach MEDIUMTEXT value is stored using a three-byte length prefix that\nindicates the number of bytes in the value.\n\nURL: https://mariadb.com/kb/en/mediumtext/','','https://mariadb.com/kb/en/mediumtext/'),(276,'LONGBLOB',23,'Syntax\n------\n\nLONGBLOB\n\nDescription\n-----------\n\nA BLOB column with a maximum length of 4,294,967,295 bytes or 4GB (232 - 1).\nThe effective maximum length of LONGBLOB columns depends on the configured\nmaximum packet size in the client/server protocol and available memory. Each\nLONGBLOB value is stored using a four-byte length prefix that indicates the\nnumber of bytes in the value.\n\nOracle Mode\n-----------\n\nMariaDB starting with 10.3\n--------------------------\nIn Oracle mode from MariaDB 10.3, BLOB is a synonym for LONGBLOB.\n\nURL: https://mariadb.com/kb/en/longblob/','','https://mariadb.com/kb/en/longblob/'),(280,'TINYBLOB',23,'Syntax\n------\n\nTINYBLOB\n\nDescription\n-----------\n\nA BLOB column with a maximum length of 255 (28 - 1) bytes. Each TINYBLOB value\nis stored using a one-byte length prefix that indicates the number of bytes in\nthe value.\n\nURL: https://mariadb.com/kb/en/tinyblob/','','https://mariadb.com/kb/en/tinyblob/'),(281,'TINYTEXT',23,'Syntax\n------\n\nTINYTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nDescription\n-----------\n\nA TEXT column with a maximum length of 255 (28 - 1) characters. The effective\nmaximum length is less if the value contains multi-byte characters. Each\nTINYTEXT value is stored using a one-byte length prefix that indicates the\nnumber of bytes in the value.\n\nURL: https://mariadb.com/kb/en/tinytext/','','https://mariadb.com/kb/en/tinytext/'),(147,'GET_LOCK',14,'Syntax\n------\n\nGET_LOCK(str,timeout)\n\nDescription\n-----------\n\nTries to obtain a lock with a name given by the string str, using a timeout of\ntimeout seconds. Returns 1 if the lock was obtained successfully, 0 if the\nattempt timed out (for example, because another client has previously locked\nthe name), or NULL if an error occurred (such as running out of memory or the\nthread was killed with mysqladmin kill).\n\nA lock is released with RELEASE_LOCK(), when the connection terminates (either\nnormally or abnormally). A connection can hold multiple locks at the same\ntime, so a lock that is no longer needed needs to be explicitly released.\n\nThe IS_FREE_LOCK function returns whether a specified lock a free or not, and\nthe IS_USED_LOCK whether the function is in use or not.\n\nLocks obtained with GET_LOCK() do not interact with transactions. That is,\ncommitting a transaction does not release any such locks obtained during the\ntransaction.\n\nIt is also possible to recursively set the same lock. If a lock with the same\nname is set n times, it needs to be released n times as well.\n\nstr is case insensitive for GET_LOCK() and related functions. If str is an\nempty string or NULL, GET_LOCK() returns NULL and does nothing. From MariaDB\n10.2.2, timeout supports microseconds. Before then, it was rounded to the\nclosest integer.\n\nIf the metadata_lock_info plugin is installed, locks acquired with this\nfunction are visible in the Information Schema METADATA_LOCK_INFO table.\n\nThis function can be used to implement application locks or to simulate record\nlocks. Names are locked on a server-wide basis. If a name has been locked by\none client, GET_LOCK() blocks any request by another client for a lock with\nthe same name. This allows clients that agree on a given lock name to use the\nname to perform cooperative advisory locking. But be aware that it also allows\na client that is not among the set of cooperating clients to lock a name,\neither inadvertently or deliberately, and thus prevent any of the cooperating\nclients from locking that name. One way to reduce the likelihood of this is to\nuse lock names that are database-specific or application-specific. For\nexample, use lock names of the form db_name.str or app_name.str.\n\nStatements using the GET_LOCK function are not safe for statement-based\nreplication.\n\nThe patch to permit multiple locks was contributed by Konstantin \"Kostja\"\nOsipov (MDEV-3917).\n\nExamples\n--------\n\nSELECT GET_LOCK(\'lock1\',10);\n+----------------------+\n| GET_LOCK(\'lock1\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT IS_FREE_LOCK(\'lock1\'), IS_USED_LOCK(\'lock1\');\n+-----------------------+-----------------------+\n| IS_FREE_LOCK(\'lock1\') | IS_USED_LOCK(\'lock1\') |\n+-----------------------+-----------------------+\n|                     0 |                    46 |\n+-----------------------+-----------------------+\n\nSELECT IS_FREE_LOCK(\'lock2\'), IS_USED_LOCK(\'lock2\');\n+-----------------------+-----------------------+\n| IS_FREE_LOCK(\'lock2\') | IS_USED_LOCK(\'lock2\') |\n+-----------------------+-----------------------+\n|                     1 |                  NULL |\n+-----------------------+-----------------------+\n\nMultiple locks can be held:\n\nSELECT GET_LOCK(\'lock2\',10);\n+----------------------+\n| GET_LOCK(\'lock2\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT IS_FREE_LOCK(\'lock1\'), IS_FREE_LOCK(\'lock2\');\n+-----------------------+-----------------------+\n| IS_FREE_LOCK(\'lock1\') | IS_FREE_LOCK(\'lock2\') |\n+-----------------------+-----------------------+\n|                     0 |                     0 |\n+-----------------------+-----------------------+\n\nSELECT RELEASE_LOCK(\'lock1\'), RELEASE_LOCK(\'lock2\');\n+-----------------------+-----------------------+\n| RELEASE_LOCK(\'lock1\') | RELEASE_LOCK(\'lock2\') |\n+-----------------------+-----------------------+\n|                     1 |                     1 |\n+-----------------------+-----------------------+\n\nIt is possible to hold the same lock recursively. This example is viewed using\nthe metadata_lock_info plugin:\n\nSELECT GET_LOCK(\'lock3\',10);\n+----------------------+\n| GET_LOCK(\'lock3\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT GET_LOCK(\'lock3\',10);\n+----------------------+\n| GET_LOCK(\'lock3\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n| THREAD_ID | LOCK_MODE           | LOCK_DURATION | LOCK_TYPE | TABLE_SCHEMA |\nTABLE_NAME |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n|        46 | MDL_SHARED_NO_WRITE | NULL          | User lock | lock3        |\n     |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n\nSELECT RELEASE_LOCK(\'lock3\');\n+-----------------------+\n| RELEASE_LOCK(\'lock3\') |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n| THREAD_ID | LOCK_MODE           | LOCK_DURATION | LOCK_TYPE | TABLE_SCHEMA |\nTABLE_NAME |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n|        46 | MDL_SHARED_NO_WRITE | NULL          | User lock | lock3        |\n     |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n\nSELECT RELEASE_LOCK(\'lock3\');\n+-----------------------+\n| RELEASE_LOCK(\'lock3\') |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\nEmpty set (0.000 sec)\n\nTimeout example: Connection 1:\n\nSELECT GET_LOCK(\'lock4\',10);\n+----------------------+\n| GET_LOCK(\'lock4\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 2:\n\nSELECT GET_LOCK(\'lock4\',10);\n\nAfter 10 seconds...\n\n+----------------------+\n| GET_LOCK(\'lock4\',10) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nDeadlocks are automatically detected and resolved. Connection 1:\n\nSELECT GET_LOCK(\'lock5\',10); \n+----------------------+\n| GET_LOCK(\'lock5\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 2:\n\nSELECT GET_LOCK(\'lock6\',10);\n+----------------------+\n| GET_LOCK(\'lock6\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 1:\n\nSELECT GET_LOCK(\'lock6\',10); \n+----------------------+\n| GET_LOCK(\'lock6\',10) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nConnection 2:\n\nSELECT GET_LOCK(\'lock5\',10);\nERROR 1213 (40001): Deadlock found when trying to get lock; try restarting\ntransaction\n\nURL: https://mariadb.com/kb/en/get_lock/','','https://mariadb.com/kb/en/get_lock/'),(284,'SET Data Type',23,'Syntax\n------\n\nSET(\'value1\',\'value2\',...) [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nDescription\n-----------\n\nA set. A string object that can have zero or more values, each of which must\nbe chosen from the list of values \'value1\', \'value2\', ... A SET column can\nhave a maximum of 64 members. SET values are represented internally as\nintegers.\n\nSET values cannot contain commas.\n\nIf a SET contains duplicate values, an error will be returned if strict mode\nis enabled, or a warning if strict mode is not enabled.\n\nURL: https://mariadb.com/kb/en/set-data-type/','','https://mariadb.com/kb/en/set-data-type/'),(154,'IS_IPV4_COMPAT',14,'Syntax\n------\n\nIS_IPV4_COMPAT(expr)\n\nDescription\n-----------\n\nReturns 1 if a given numeric binary string IPv6 address, such as returned by\nINET6_ATON(), is IPv4-compatible, otherwise returns 0.\n\nMariaDB starting with 10.5.0\n----------------------------\nFrom MariaDB 10.5.0, when the argument is not INET6, automatic implicit CAST\nto INET6 is applied. As a consequence, IS_IPV4_COMPAT now understands\narguments in both text representation and binary(16) representation. Before\nMariaDB 10.5.0, the function understood only binary(16) representation.\n\nExamples\n--------\n\nSELECT IS_IPV4_COMPAT(INET6_ATON(\'::10.0.1.1\'));\n+------------------------------------------+\n| IS_IPV4_COMPAT(INET6_ATON(\'::10.0.1.1\')) |\n+------------------------------------------+\n|                                        1 |\n+------------------------------------------+\n\nSELECT IS_IPV4_COMPAT(INET6_ATON(\'::48f3::d432:1431:ba23:846f\'));\n+-----------------------------------------------------------+\n| IS_IPV4_COMPAT(INET6_ATON(\'::48f3::d432:1431:ba23:846f\')) |\n+-----------------------------------------------------------+\n|                                                         0 |\n+-----------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/is_ipv4_compat/','','https://mariadb.com/kb/en/is_ipv4_compat/'),(155,'IS_IPV4_MAPPED',14,'Syntax\n------\n\nIS_IPV4_MAPPED(expr)\n\nDescription\n-----------\n\nReturns 1 if a given a numeric binary string IPv6 address, such as returned by\nINET6_ATON(), is a valid IPv4-mapped address, otherwise returns 0.\n\nMariaDB starting with 10.5.0\n----------------------------\nFrom MariaDB 10.5.0, when the argument is not INET6, automatic implicit CAST\nto INET6 is applied. As a consequence, IS_IPV4_MAPPED now understands\narguments in both text representation and binary(16) representation. Before\nMariaDB 10.5.0, the function understood only binary(16) representation.\n\nExamples\n--------\n\nSELECT IS_IPV4_MAPPED(INET6_ATON(\'::10.0.1.1\'));\n+------------------------------------------+\n| IS_IPV4_MAPPED(INET6_ATON(\'::10.0.1.1\')) |\n+------------------------------------------+\n|                                        0 |\n+------------------------------------------+\n\nSELECT IS_IPV4_MAPPED(INET6_ATON(\'::ffff:10.0.1.1\'));\n+-----------------------------------------------+\n| IS_IPV4_MAPPED(INET6_ATON(\'::ffff:10.0.1.1\')) |\n+-----------------------------------------------+\n|                                             1 |\n+-----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/is_ipv4_mapped/','','https://mariadb.com/kb/en/is_ipv4_mapped/'),(159,'MASTER_POS_WAIT',14,'Syntax\n------\n\nMASTER_POS_WAIT(log_name,log_pos[,timeout,[\"connection_name\"]])\n\nDescription\n-----------\n\nThis function is useful in replication for controlling primary/replica\nsynchronization. It blocks until the replica has read and applied all updates\nup to the specified position (log_name,log_pos) in the primary log. The return\nvalue is the number of log events the replica had to wait for to advance to\nthe specified position. The function returns NULL if the replica SQL thread is\nnot started, the replica\'s primary information is not initialized, the\narguments are incorrect, or an error occurs. It returns -1 if the timeout has\nbeen exceeded. If the replica SQL thread stops while MASTER_POS_WAIT() is\nwaiting, the function returns NULL. If the replica is past the specified\nposition, the function returns immediately.\n\nIf a timeout value is specified, MASTER_POS_WAIT() stops waiting when timeout\nseconds have elapsed. timeout must be greater than 0; a zero or negative\ntimeout means no timeout.\n\nThe connection_name is used when you are using multi-source-replication. If\nyou don\'t specify it, it\'s set to the value of the default_master_connection\nsystem variable.\n\nStatements using the MASTER_POS_WAIT() function are not safe for replication.\n\nURL: https://mariadb.com/kb/en/master_pos_wait/','','https://mariadb.com/kb/en/master_pos_wait/'),(161,'RELEASE_ALL_LOCKS',14,'MariaDB until 10.5.2\n--------------------\nRELEASE_ALL_LOCKS was added in MariaDB 10.5.2.\n\nSyntax\n------\n\nRELEASE_ALL_LOCKS()\n\nDescription\n-----------\n\nReleases all named locks held by the current session. Returns the number of\nlocks released, or 0 if none were held.\n\nStatements using the RELEASE_ALL_LOCKS function are not safe for\nstatement-based replication.\n\nExamples\n--------\n\nSELECT RELEASE_ALL_LOCKS();\n+---------------------+\n| RELEASE_ALL_LOCKS() | \n+---------------------+\n|                   0 |\n+---------------------+\n\nSELECT GET_LOCK(\'lock1\',10);\n+----------------------+\n| GET_LOCK(\'lock1\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT RELEASE_ALL_LOCKS();\n+---------------------+\n| RELEASE_ALL_LOCKS() | \n+---------------------+\n|                   1 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/release_all_locks/','','https://mariadb.com/kb/en/release_all_locks/'),(288,'TIMESTAMP',23,'Syntax\n------\n\nTIMESTAMP [(<microsecond precision)]\n\nDescription\n-----------\n\nA timestamp in the format YYYY-MM-DD HH:MM:SS.ffffff.\n\nThe timestamp field is generally used to define at which moment in time a row\nwas added or updated and by default will automatically be assigned the current\ndatetime when a record is inserted or updated. The automatic properties only\napply to the first TIMESTAMP in the record; subsequent TIMESTAMP columns will\nnot be changed.\n\nMariaDB includes the --mysql56-temporal-format option, on by default, which\nallows MariaDB to store TIMESTAMPs using the same low-level format MySQL 5.6\nuses.\n\nFor more information, see Internal Format.\n\nSupported Values\n----------------\n\nMariaDB stores values that use the TIMESTAMP data type as the number of\nseconds since \'1970-01-01 00:00:00\' (UTC). This means that the TIMESTAMP data\ntype can hold values between \'1970-01-01 00:00:01\' (UTC) and \'2038-01-19\n03:14:07\' (UTC).\n\nMariaDB can also store microseconds with a precision between 0 and 6. If no\nmicrosecond precision is specified, then 0 is used by default.\n\nAutomatic Values\n----------------\n\nMariaDB has special behavior for the first column that uses the TIMESTAMP data\ntype in a specific table. For the first column that uses the TIMESTAMP data\ntype in a specific table, MariaDB automatically assigns the following\nproperties to the column:\n\n* DEFAULT CURRENT_TIMESTAMP\n* ON UPDATE CURRENT_TIMESTAMP\n\nThis means that if the column is not explicitly assigned a value in an INSERT\nor UPDATE query, then MariaDB will automatically initialize the column\'s value\nwith the current date and time.\n\nThis automatic initialization for INSERT and UPDATE queries can also be\nexplicitly enabled for a column that uses the TIMESTAMP data type by\nspecifying the DEFAULT CURRENT_TIMESTAMP and ON UPDATE CURRENT_TIMESTAMP\nclauses for the column. In these clauses, any synonym of CURRENT_TIMESTAMP is\naccepted, including CURRENT_TIMESTAMP(), NOW(), LOCALTIME, LOCALTIME(),\nLOCALTIMESTAMP, and LOCALTIMESTAMP().\n\nThis automatic initialization for INSERT queries can also be explicitly\ndisabled for a column that uses the TIMESTAMP data type by specifying a\nconstant DEFAULT value. For example, DEFAULT 0.\n\nThis automatic initialization for UPDATE queries can also be explicitly\ndisabled for a column that uses the TIMESTAMP data type by specifying a\nDEFAULT clause for the column, but no ON UPDATE clause. If a DEFAULT clause is\nexplicitly specified for a column that uses the TIMESTAMP data type, but an ON\nUPDATE clause is not specified for the column, then the timestamp value will\nnot automatically change when an UPDATE statement is executed.\n\nMariaDB also has special behavior if NULL is assigned to column that uses the\nTIMESTAMP data type. If the column is assigned the NULL value in an INSERT or\nUPDATE query, then MariaDB will automatically initialize the column\'s value\nwith the current date and time. For details, see NULL values in MariaDB.\n\nThis automatic initialization for NULL values can also be explicitly disabled\nfor a column that uses the TIMESTAMP data type by specifying the NULL\nattribute for the column. In this case, if the column\'s value is set to NULL,\nthen the column\'s value will actually be set to NULL.\n\nTime Zones\n----------\n\nIf a column uses the TIMESTAMP data type, then any inserted values are\nconverted from the session\'s time zone to Coordinated Universal Time (UTC)\nwhen stored, and converted back to the session\'s time zone when retrieved.\n\nMariaDB does not currently store any time zone identifier with the value of\nthe TIMESTAMP data type. See MDEV-10018 for more information.\n\nMariaDB does not currently support time zone literals that contain time zone\nidentifiers. See MDEV-11829 for more information.\n\nLimitations\n-----------\n\n* Because the TIMESTAMP value is stored as Epoch Seconds, the timestamp value\n\'1970-01-01 00:00:00\' (UTC) is reserved since the second #0 is used to\nrepresent \'0000-00-00 00:00:00\'.\n* In MariaDB 5.5 and before there could only be one TIMESTAMP column per table\nthat had CURRENT_TIMESTAMP defined as its default value. This limit has no\nlonger applied since MariaDB 10.0.\n\nSQL_MODE=MAXDB\n--------------\n\nIf the SQL_MODE is set to MAXDB, TIMESTAMP fields will be silently converted\nto DATETIME.\n\nInternal Format\n---------------\n\nIn MariaDB 10.1.2 a new temporal format was introduced from MySQL 5.6 that\nalters how the TIME, DATETIME and TIMESTAMP columns operate at lower levels.\nThese changes allow these temporal data types to have fractional parts and\nnegative values. You can disable this feature using the\nmysql56_temporal_format system variable.\n\nTables that include TIMESTAMP values that were created on an older version of\nMariaDB or that were created while the mysql56_temporal_format system variable\nwas disabled continue to store data using the older data type format.\n\nIn order to update table columns from the older format to the newer format,\nexecute an ALTER TABLE... MODIFY COLUMN statement that changes the column to\nthe *same* data type. This change may be needed if you want to export the\ntable\'s tablespace and import it onto a server that has\nmysql56_temporal_format=ON set (see MDEV-15225).\n\nFor instance, if you have a TIMESTAMP column in your table:\n\nSHOW VARIABLES LIKE \'mysql56_temporal_format\';\n\n+-------------------------+-------+\n| Variable_name           | Value |\n+-------------------------+-------+\n| mysql56_temporal_format | ON    |\n+-------------------------+-------+\n\nALTER TABLE example_table MODIFY ts_col TIMESTAMP;\n\nWhen MariaDB executes the ALTER TABLE statement, it converts the data from the\nolder temporal format to the newer one.\n\nIn the event that you have several tables and columns using temporal data\ntypes that you want to switch over to the new format, make sure the system\nvariable is enabled, then perform a dump and restore using mysqldump. The\ncolumns using relevant temporal data types are restored using the new temporal\nformat.\n\nStarting from MariaDB 10.5.1 columns with old temporal formats are marked with\na /* mariadb-5.3 */ comment in the output of SHOW CREATE TABLE, SHOW COLUMNS,\nDESCRIBE statements, as well as in the COLUMN_TYPE column of the\nINFORMATION_SCHEMA.COLUMNS Table.\n\nSHOW CREATE TABLE mariadb5312_timestamp\\G\n*************************** 1. row ***************************\n   Table: mariadb5312_timestamp\nCreate Table: CREATE TABLE `mariadb5312_timestamp` (\n `ts0` timestamp /* mariadb-5.3 */ NOT NULL DEFAULT current_timestamp() ON\nUPDATE current_timestamp(),\n `ts6` timestamp(6) /* mariadb-5.3 */ NOT NULL DEFAULT \'0000-00-00\n00:00:00.000000\'\n) ENGINE=MyISAM DEFAULT CHARSET=latin1\n\nNote: Prior to MySQL 4.1 a different format for the TIMESTAMP datatype was\nused. This format is unsupported in MariaDB 5.1 and upwards.\n\nExamples\n--------\n\nCREATE TABLE t (id INT, ts TIMESTAMP);\n\nDESC t;\n+-------+-----------+------+-----+-------------------+-------------------------\n---+\n| Field | Type      | Null | Key | Default           | Extra                  \n  |\n+-------+-----------+------+-----+-------------------+-------------------------\n---+\n| id    | int(11)   | YES  |     | NULL              |                        \n  |\n| ts    | timestamp | NO   |     | CURRENT_TIMESTAMP | on update\nCURRENT_TIMESTAMP |\n+-------+-----------+------+-----+-------------------+-------------------------\n---+\n\nINSERT INTO t(id)  VALUES (1),(2);\n\nSELECT * FROM t;\n+------+---------------------+\n| id   | ts                  |\n+------+---------------------+\n|    1 | 2013-07-22 12:50:05 |\n|    2 | 2013-07-22 12:50:05 |\n+------+---------------------+\n\nINSERT INTO t  VALUES (3,NULL),(4,\'2001-07-22 12:12:12\');\n\nSELECT * FROM t;\n+------+---------------------+\n| id   | ts                  |\n+------+---------------------+\n|    1 | 2013-07-22 12:50:05 |\n|    2 | 2013-07-22 12:50:05 |\n|    3 | 2013-07-22 12:51:56 |\n|    4 | 2001-07-22 12:12:12 |\n+------+---------------------+\n\nConverting to Unix epoch:\n\nSELECT ts, UNIX_TIMESTAMP(ts) FROM t;\n+---------------------+--------------------+\n| ts                  | UNIX_TIMESTAMP(ts) |\n+---------------------+--------------------+\n| 2013-07-22 12:50:05 |         1374490205 |\n| 2013-07-22 12:50:05 |         1374490205 |\n| 2013-07-22 12:51:56 |         1374490316 |\n| 2001-07-22 12:12:12 |          995796732 |\n+---------------------+--------------------+\n\nUpdate also changes the timestamp:\n\nUPDATE t set id=5 WHERE id=1;\n\nSELECT * FROM t;\n+------+---------------------+\n| id   | ts                  |\n+------+---------------------+\n|    5 | 2013-07-22 14:52:33 |\n|    2 | 2013-07-22 12:50:05 |\n|    3 | 2013-07-22 12:51:56 |\n|    4 | 2001-07-22 12:12:12 |\n+------+---------------------+\n\nDefault NULL:\n\nCREATE TABLE t2 (id INT, ts TIMESTAMP NULL ON UPDATE CURRENT_TIMESTAMP);\n\nINSERT INTO t(id)  VALUES (1),(2);\n\nSELECT * FROM t2;\n\nINSERT INTO t2(id)  VALUES (1),(2);\n\nSELECT * FROM t2;\n+------+------+\n| id   | ts   |\n+------+------+\n|    1 | NULL |\n|    2 | NULL |\n+------+------+\n\nUPDATE t2 SET id=3 WHERE id=1;\n\nSELECT * FROM t2;\n+------+---------------------+\n| id   | ts                  |\n+------+---------------------+\n|    3 | 2013-07-22 15:32:22 |\n|    2 | NULL                |\n+------+---------------------+\n\nOnly the first timestamp is automatically inserted and updated:\n\nCREATE TABLE t3 (id INT, ts1 TIMESTAMP, ts2 TIMESTAMP);\n\nINSERT INTO t3(id)  VALUES (1),(2);\n\nSELECT * FROM t3;\n+------+---------------------+---------------------+\n| id   | ts1                 | ts2                 |\n+------+---------------------+---------------------+\n|    1 | 2013-07-22 15:35:07 | 0000-00-00 00:00:00 |\n|    2 | 2013-07-22 15:35:07 | 0000-00-00 00:00:00 |\n+------+---------------------+---------------------+\n\nDESC t3;\n+-------+-----------+------+-----+---------------------+-----------------------\n-----+\n| Field | Type      | Null | Key | Default             | Extra                \n   |\n+-------+-----------+------+-----+---------------------+-----------------------\n-----+\n| id    | int(11)   | YES  |     | NULL                |                      \n   |\n| ts1   | timestamp | NO   |     | CURRENT_TIMESTAMP   | on update\nCURRENT_TIMESTAMP |\n| ts2   | timestamp | NO   |     | 0000-00-00 00:00:00 |                      \n   |\n+-------+-----------+------+-----+---------------------+-----------------------\n-----+\n\nExplicitly setting a timestamp with the CURRENT_TIMESTAMP function:\n\nINSERT INTO t3(id,ts2)  VALUES (3,CURRENT_TIMESTAMP());\n\nSELECT * FROM t3;\n+------+---------------------+---------------------+\n| id   | ts1                 | ts2                 |\n+------+---------------------+---------------------+\n|    1 | 2013-07-22 15:35:07 | 0000-00-00 00:00:00 |\n|    2 | 2013-07-22 15:35:07 | 0000-00-00 00:00:00 |\n|    3 | 2013-07-22 15:38:52 | 2013-07-22 15:38:52 |\n+------+---------------------+---------------------+\n\nSpecifying the timestamp as NOT NULL:\n\nCREATE TABLE t4 (id INT, ts TIMESTAMP NOT NULL);\n\nINSERT INTO t4(id)  VALUES (1);\nSELECT SLEEP(1);\nINSERT INTO t4(id,ts) VALUES (2,NULL);\n\nSELECT * FROM t4;\n\nURL: https://mariadb.com/kb/en/timestamp/','','https://mariadb.com/kb/en/timestamp/'),(298,'GOTO',24,'MariaDB starting with 10.3\n--------------------------\nThe GOTO statement was introduced in MariaDB 10.3 for Oracle compatibility.\n\nSyntax\n------\n\nGOTO label\n\nDescription\n-----------\n\nThe GOTO statement causes the code to jump to the specified label, and\ncontinue operating from there. It is only accepted when in Oracle mode.\n\nExample\n-------\n\nSET sql_mode=ORACLE;\n\nDELIMITER //\n\nCREATE OR REPLACE PROCEDURE p1 AS\n\nBEGIN\n\nSELECT 1;\n GOTO label;\n SELECT 2;\n <<label>>\n SELECT 3;\n\nEND;\n\n//\n\nDELIMITER\n\ncall p1();\n+---+\n| 1 |\n+---+\n| 1 |\n+---+\n1 row in set (0.000 sec)\n\n+---+\n| 3 |\n+---+\n| 3 |\n+---+\n1 row in set (0.000 sec)\n\nURL: https://mariadb.com/kb/en/goto/','','https://mariadb.com/kb/en/goto/'),(299,'IF',24,'Syntax\n------\n\nIF search_condition THEN statement_list\n  [ELSEIF search_condition THEN statement_list] ...\n  [ELSE statement_list]\nEND IF;\n\nDescription\n-----------\n\nIF implements a basic conditional construct. If the search_condition evaluates\nto true, the corresponding SQL statement list is executed. If no\nsearch_condition matches, the statement list in the ELSE clause is executed.\nEach statement_list consists of one or more statements.\n\nURL: https://mariadb.com/kb/en/if/','','https://mariadb.com/kb/en/if/'),(303,'LOOP',24,'Syntax\n------\n\n[begin_label:] LOOP\n  statement_list\nEND LOOP [end_label]\n\nDescription\n-----------\n\nLOOP implements a simple loop construct, enabling repeated execution of the\nstatement list, which consists of one or more statements, each terminated by a\nsemicolon (i.e., ;) statement delimiter. The statements within the loop are\nrepeated until the loop is exited; usually this is accomplished with a LEAVE\nstatement.\n\nA LOOP statement can be labeled. end_label cannot be given unless begin_label\nalso is present. If both are present, they must be the same.\n\nSee Delimiters in the mysql client for more on delimiter usage in the client.\n\nURL: https://mariadb.com/kb/en/loop/','','https://mariadb.com/kb/en/loop/'),(306,'RETURN',24,'Syntax\n------\n\nRETURN expr\n\nThe RETURN statement terminates execution of a stored function and returns the\nvalue expr to the function caller. There must be at least one RETURN statement\nin a stored function. If the function has multiple exit points, all exit\npoints must have a RETURN.\n\nThis statement is not used in stored procedures, triggers, or events. LEAVE\ncan be used instead.\n\nThe following example shows that RETURN can return the result of a scalar\nsubquery:\n\nCREATE FUNCTION users_count() RETURNS BOOL\n READS SQL DATA\nBEGIN\n RETURN (SELECT COUNT(DISTINCT User) FROM mysql.user);\nEND;\n\nURL: https://mariadb.com/kb/en/return/','','https://mariadb.com/kb/en/return/'),(158,'MASTER_GTID_WAIT',14,'Syntax\n------\n\nMASTER_GTID_WAIT(gtid-list[, timeout)\n\nDescription\n-----------\n\nThis function takes a string containing a comma-separated list of global\ntransaction id\'s (similar to the value of, for example, gtid_binlog_pos). It\nwaits until the value of gtid_slave_pos has the same or higher seq_no within\nall replication domains specified in the gtid-list; in other words, it waits\nuntil the slave has reached the specified GTID position.\n\nAn optional second argument gives a timeout in seconds. If the timeout expires\nbefore the specified GTID position is reached, then the function returns -1.\nPassing NULL or a negative number for the timeout means no timeout, and the\nfunction will wait indefinitely.\n\nIf the wait completes without a timeout, 0 is returned. Passing NULL for the\ngtid-list makes the function return NULL immediately, without waiting.\n\nThe gtid-list may be the empty string, in which case MASTER_GTID_WAIT()\nreturns immediately. If the gtid-list contains fewer domains than\ngtid_slave_pos, then only those domains are waited upon. If gtid-list contains\na domain that is not present in @@gtid_slave_pos, then MASTER_GTID_WAIT() will\nwait until an event containing such domain_id arrives on the slave (or until\ntimed out or killed).\n\nMASTER_GTID_WAIT() can be useful to ensure that a slave has caught up to a\nmaster. Simply take the value of gtid_binlog_pos on the master, and use it in\na MASTER_GTID_WAIT() call on the slave; when the call completes, the slave\nwill have caught up with that master position.\n\nMASTER_GTID_WAIT() can also be used in client applications together with the\nlast_gtid session variable. This is useful in a read-scaleout replication\nsetup, where the application writes to a single master but divides the reads\nout to a number of slaves to distribute the load. In such a setup, there is a\nrisk that an application could first do an update on the master, and then a\nbit later do a read on a slave, and if the slave is not fast enough, the data\nread from the slave might not include the update just made, possibly confusing\nthe application and/or the end-user. One way to avoid this is to request the\nvalue of last_gtid on the master just after the update. Then before doing the\nread on the slave, do a MASTER_GTID_WAIT() on the value obtained from the\nmaster; this will ensure that the read is not performed until the slave has\nreplicated sufficiently far for the update to have become visible.\n\nNote that MASTER_GTID_WAIT() can be used even if the slave is configured not\nto use GTID for connections (CHANGE MASTER TO master_use_gtid=no). This is\nbecause from MariaDB 10, GTIDs are always logged on the master server, and\nalways recorded on the slave servers.\n\nDifferences to MASTER_POS_WAIT()\n--------------------------------\n\n* MASTER_GTID_WAIT() is global; it waits for any master connection to reach\n the specified GTID position. MASTER_POS_WAIT() works only against a\n specific connection. This also means that while MASTER_POS_WAIT() aborts if\n its master connection is terminated with STOP SLAVE or due to an error,\n MASTER_GTID_WAIT() continues to wait while slaves are stopped.\n\n* MASTER_GTID_WAIT() can take its timeout as a floating-point value, so a\n timeout in fractional seconds is supported, eg. MASTER_GTID_WAIT(\"0-1-100\",\n 0.5). (The minimum wait is one microsecond, 0.000001 seconds).\n\n* MASTER_GTID_WAIT() allows one to specify a timeout of zero in order to do a\n non-blocking check to see if the slaves have progressed to a specific GTID\nposition\n (MASTER_POS_WAIT() takes a zero timeout as meaning an infinite wait). To do\n an infinite MASTER_GTID_WAIT(), specify a negative timeout, or omit the\n timeout argument.\n\n* MASTER_GTID_WAIT() does not return the number of events executed since the\n wait started, nor does it return NULL if a slave thread is stopped. It\n always returns either 0 for successful wait completed, or -1 for timeout\n reached (or NULL if the specified gtid-pos is NULL).\n\nSince MASTER_GTID_WAIT() looks only at the seq_no part of the GTIDs, not the\nserver_id, care is needed if a slave becomes diverged from another server so\nthat two different GTIDs with the same seq_no (in the same domain) arrive at\nthe same server. This situation is in any case best avoided; setting\ngtid_strict_mode is recommended, as this will prevent any such out-of-order\nsequence numbers from ever being replicated on a slave.\n\nURL: https://mariadb.com/kb/en/master_gtid_wait/','','https://mariadb.com/kb/en/master_gtid_wait/'),(164,'UUID',14,'Syntax\n------\n\nUUID()\n\nDescription\n-----------\n\nReturns a Universally Unique Identifier (UUID).\n\nA UUID is designed as a number that is globally unique in space and time. Two\ncalls to UUID() are expected to generate two different values, even if these\ncalls are performed on two separate computers that are not connected to each\nother.\n\nUUID() results are intended to be unique, but cannot always be relied upon to\nunpredictable and unguessable, so should not be relied upon for these purposes.\n\nA UUID is a 128-bit number represented by a utf8 string of five hexadecimal\nnumbers in aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee format:\n\n* The first three numbers are generated from a timestamp.\n* The fourth number preserves temporal uniqueness in case the timestamp value\n loses monotonicity (for example, due to daylight saving time).\n* The fifth number is an IEEE 802 node number that provides spatial uniqueness.\n A random number is substituted if the latter is not available (for example,\n because the host computer has no Ethernet card, or we do not know how to find\n the hardware address of an interface on your operating system). In this case,\n spatial uniqueness cannot be guaranteed. Nevertheless, a collision should\n have very low probability.\n\nCurrently, the MAC address of an interface is taken into account only on\nFreeBSD and Linux. On other operating systems, MariaDB uses a randomly\ngenerated 48-bit number.\n\nStatements using the UUID() function are not safe for replication.\n\nThe results are generated according to the \"DCE 1.1:Remote Procedure Call\"\n(Appendix A) CAE (Common Applications Environment) Specifications published by\nThe Open Group in October 1997 (Document Number C706).\n\nExamples\n--------\n\nSELECT UUID();\n+--------------------------------------+\n| UUID()                               |\n+--------------------------------------+\n| cd41294a-afb0-11df-bc9b-00241dd75637 |\n+--------------------------------------+\n\nURL: https://mariadb.com/kb/en/uuid/','','https://mariadb.com/kb/en/uuid/'),(309,'WHILE',24,'Syntax\n------\n\n[begin_label:] WHILE search_condition DO\n  statement_list\nEND WHILE [end_label]\n\nDescription\n-----------\n\nThe statement list within a WHILE statement is repeated as long as the\nsearch_condition is true. statement_list consists of one or more statements.\nIf the loop must be executed at least once, REPEAT ... LOOP can be used\ninstead.\n\nA WHILE statement can be labeled. end_label cannot be given unless begin_label\nalso is present. If both are present, they must be the same.\n\nExamples\n--------\n\nCREATE PROCEDURE dowhile()\nBEGIN\n DECLARE v1 INT DEFAULT 5;\n\nWHILE v1 > 0 DO\n  ...\n  SET v1 = v1 - 1;\n END WHILE;\nEND\n\nURL: https://mariadb.com/kb/en/while/','','https://mariadb.com/kb/en/while/'),(312,'OPEN',24,'Syntax\n------\n\n<= MariaDB 10.2\n\nOPEN cursor_name\n\nFrom MariaDB 10.3\n\nOPEN cursor_name [expression[,...]];\n\nDescription\n-----------\n\nThis statement opens a cursor which was previously declared with DECLARE\nCURSOR.\n\nThe query associated to the DECLARE CURSOR is executed when OPEN is executed.\nIt is important to remember this if the query produces an error, or calls\nfunctions which have side effects.\n\nThis is necessary in order to FETCH rows from a cursor.\n\nSee Cursor Overview for an example.\n\nURL: https://mariadb.com/kb/en/open/','','https://mariadb.com/kb/en/open/'),(162,'RELEASE_LOCK',14,'Syntax\n------\n\nRELEASE_LOCK(str)\n\nDescription\n-----------\n\nReleases the lock named by the string str that was obtained with GET_LOCK().\nReturns 1 if the lock was released, 0 if the lock was not established by this\nthread (in which case the lock is not released), and NULL if the named lock\ndid not exist. The lock does not exist if it was never obtained by a call to\nGET_LOCK() or if it has previously been released.\n\nstr is case insensitive. If str is an empty string or NULL, RELEASE_LOCK()\nreturns NULL and does nothing.\n\nStatements using the RELEASE_LOCK() function are not safe for replication.\n\nThe DO statement is convenient to use with RELEASE_LOCK().\n\nExamples\n--------\n\nConnection1:\n\nSELECT GET_LOCK(\'lock1\',10);\n+----------------------+\n| GET_LOCK(\'lock1\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 2:\n\nSELECT GET_LOCK(\'lock2\',10);\n+----------------------+\n| GET_LOCK(\'lock2\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 1:\n\nSELECT RELEASE_LOCK(\'lock1\'), RELEASE_LOCK(\'lock2\'), RELEASE_LOCK(\'lock3\');\n+-----------------------+-----------------------+-----------------------+\n| RELEASE_LOCK(\'lock1\') | RELEASE_LOCK(\'lock2\') | RELEASE_LOCK(\'lock3\') |\n+-----------------------+-----------------------+-----------------------+\n|                     1 |                     0 |                  NULL |\n+-----------------------+-----------------------+-----------------------+\n\nFrom MariaDB 10.0.2, it is possible to hold the same lock recursively. This\nexample is viewed using the metadata_lock_info plugin:\n\nSELECT GET_LOCK(\'lock3\',10);\n+----------------------+\n| GET_LOCK(\'lock3\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT GET_LOCK(\'lock3\',10);\n+----------------------+\n| GET_LOCK(\'lock3\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n| THREAD_ID | LOCK_MODE           | LOCK_DURATION | LOCK_TYPE | TABLE_SCHEMA |\nTABLE_NAME |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n|        46 | MDL_SHARED_NO_WRITE | NULL          | User lock | lock3        |\n     |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n\nSELECT RELEASE_LOCK(\'lock3\');\n+-----------------------+\n| RELEASE_LOCK(\'lock3\') |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n| THREAD_ID | LOCK_MODE           | LOCK_DURATION | LOCK_TYPE | TABLE_SCHEMA |\nTABLE_NAME |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n|        46 | MDL_SHARED_NO_WRITE | NULL          | User lock | lock3        |\n     |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n\nSELECT RELEASE_LOCK(\'lock3\');\n+-----------------------+\n| RELEASE_LOCK(\'lock3\') |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\nEmpty set (0.000 sec)\n\nURL: https://mariadb.com/kb/en/release_lock/','','https://mariadb.com/kb/en/release_lock/'),(165,'UUID_SHORT',14,'Syntax\n------\n\nUUID_SHORT()\n\nDescription\n-----------\n\nReturns a \"short\" universally unique identifier as a 64-bit unsigned integer\n(rather than a string-form 128-bit identifier as returned by the UUID()\nfunction).\n\nThe value of UUID_SHORT() is guaranteed to be unique if the following\nconditions hold:\n\n* The server_id of the current host is unique among your set of master and\n slave servers\n* server_id is between 0 and 255\n* You don\'t set back your system time for your server between mysqld restarts\n* You do not invoke UUID_SHORT() on average more than 16\n million times per second between mysqld restarts\n\nThe UUID_SHORT() return value is constructed this way:\n\n(server_id & 255) << 56\n+ (server_startup_time_in_seconds << 24)\n+ incremented_variable++;\n\nStatements using the UUID_SHORT() function are not safe for statement-based\nreplication.\n\nExamples\n--------\n\nSELECT UUID_SHORT();\n+-------------------+\n| UUID_SHORT()      |\n+-------------------+\n| 21517162376069120 |\n+-------------------+\n\ncreate table t1 (a bigint unsigned default(uuid_short()) primary key);\ninsert into t1 values(),();\nselect * from t1;\n+-------------------+\n| a                 |\n+-------------------+\n| 98113699159474176 |\n| 98113699159474177 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/uuid_short/','','https://mariadb.com/kb/en/uuid_short/'),(166,'VALUES / VALUE',14,'Syntax\n------\n\nMariaDB starting with 10.3.3\n----------------------------\n\nVALUE(col_name)\n\nMariaDB until 10.3.2\n--------------------\n\nVALUES(col_name)\n\nDescription\n-----------\n\nIn an INSERT ... ON DUPLICATE KEY UPDATE statement, you can use the\nVALUES(col_name) function in the UPDATE clause to refer to column values from\nthe INSERT portion of the statement. In other words, VALUES(col_name) in the\nUPDATE clause refers to the value of col_name that would be inserted, had no\nduplicate-key conflict occurred. This function is especially useful in\nmultiple-row inserts.\n\nThe VALUES() function is meaningful only in INSERT ... ON DUPLICATE KEY UPDATE\nstatements and returns NULL otherwise.\n\nIn MariaDB 10.3.3 this function was renamed to VALUE(), because it\'s\nincompatible with the standard Table Value Constructors syntax, implemented in\nMariaDB 10.3.3.\n\nThe VALUES() function can still be used even from MariaDB 10.3.3, but only in\nINSERT ... ON DUPLICATE KEY UPDATE statements; it\'s a syntax error otherwise.\n\nExamples\n--------\n\nMariaDB starting with 10.3.3\n----------------------------\n\nINSERT INTO t (a,b,c) VALUES (1,2,3),(4,5,6)\n  ON DUPLICATE KEY UPDATE c=VALUE(a)+VALUE(b);\n\nMariaDB until 10.3.2\n--------------------\n\nINSERT INTO t (a,b,c) VALUES (1,2,3),(4,5,6)\n  ON DUPLICATE KEY UPDATE c=VALUES(a)+VALUES(b);\n\nURL: https://mariadb.com/kb/en/values-value/','','https://mariadb.com/kb/en/values-value/'),(313,'FETCH',24,'Syntax\n------\n\nFETCH cursor_name INTO var_name [, var_name] ...\n\nDescription\n-----------\n\nThis statement fetches the next row (if a row exists) using the specified open\ncursor, and advances the cursor pointer.\n\nvar_name can be a local variable, but not a user-defined variable.\n\nIf no more rows are available, a No Data condition occurs with SQLSTATE value\n02000. To detect this condition, you can set up a handler for it (or for a NOT\nFOUND condition).\n\nSee Cursor Overview for an example.\n\nURL: https://mariadb.com/kb/en/fetch/','','https://mariadb.com/kb/en/fetch/'),(314,'CLOSE',24,'Syntax\n------\n\nCLOSE cursor_name\n\nDescription\n-----------\n\nThis statement closes a previously opened cursor. The cursor must have been\npreviously opened or else an error occurs.\n\nIf not closed explicitly, a cursor is closed at the end of the compound\nstatement in which it was declared.\n\nSee Cursor Overview for an example.\n\nURL: https://mariadb.com/kb/en/close/','','https://mariadb.com/kb/en/close/'),(315,'BUFFER',25,'A synonym for ST_BUFFER.\n\nURL: https://mariadb.com/kb/en/buffer/','','https://mariadb.com/kb/en/buffer/'),(170,'||',15,'Syntax\n------\n\nOR, ||\n\nDescription\n-----------\n\nLogical OR. When both operands are non-NULL, the result is 1 if any operand is\nnon-zero, and 0 otherwise. With a NULL operand, the result is 1 if the other\noperand is non-zero, and NULL otherwise. If both operands are NULL, the result\nis NULL.\n\nFor this operator, short-circuit evaluation can be used.\n\nNote that, if the PIPES_AS_CONCAT SQL_MODE is set, || is used as a string\nconcatenation operator. This means that a || b is the same as CONCAT(a,b). See\nCONCAT() for details.\n\nOracle Mode\n-----------\n\nMariaDB starting with 10.3\n--------------------------\nIn Oracle mode from MariaDB 10.3, || ignores NULL.\n\nExamples\n--------\n\nSELECT 1 || 1;\n+--------+\n| 1 || 1 |\n+--------+\n|      1 |\n+--------+\n\nSELECT 1 || 0;\n+--------+\n| 1 || 0 |\n+--------+\n|      1 |\n+--------+\n\nSELECT 0 || 0;\n+--------+\n| 0 || 0 |\n+--------+\n|      0 |\n+--------+\n\nSELECT 0 || NULL;\n+-----------+\n| 0 || NULL |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT 1 || NULL;\n+-----------+\n| 1 || NULL |\n+-----------+\n|         1 |\n+-----------+\n\nIn Oracle mode, from MariaDB 10.3:\n\nSELECT 0 || NULL;\n+-----------+\n| 0 || NULL |\n+-----------+\n| 0         |\n+-----------+\n\nURL: https://mariadb.com/kb/en/or/','','https://mariadb.com/kb/en/or/'),(171,'Stored Aggregate Functions',16,'MariaDB starting with 10.3.3\n----------------------------\nThe ability to create stored aggregate functions was added in MariaDB 10.3.3.\n\nAggregate functions are functions that are computed over a sequence of rows\nand return one result for the sequence of rows.\n\nCreating a custom aggregate function is done using the CREATE FUNCTION\nstatement with two main differences:\n\n* The addition of the AGGREGATE keyword, so CREATE AGGREGATE FUNCTION\n* The FETCH GROUP NEXT ROW instruction inside the loop\n* Oracle PL/SQL compatibility using SQL/PL is provided\n\nStandard Syntax\n---------------\n\nCREATE AGGREGATE FUNCTION function_name (parameters) RETURNS return_type\nBEGIN\n   All types of declarations\n   DECLARE CONTINUE HANDLER FOR NOT FOUND RETURN return_val;\n   LOOP\n     FETCH GROUP NEXT ROW; // fetches next row from table\n     other instructions\n   END LOOP;\nEND\n\nStored aggregate functions were a 2016 Google Summer of Code project by Varun\nGupta.\n\nUsing SQL/PL\n------------\n\nSET sql_mode=Oracle;\nDELIMITER //\n\nCREATE AGGREGATE FUNCTION function_name (parameters) RETURN return_type\n declarations\nBEGIN\n LOOP\n   FETCH GROUP NEXT ROW; -- fetches next row from table\n   -- other instructions\n\nEND LOOP;\nEXCEPTION\n WHEN NO_DATA_FOUND THEN\n   RETURN return_val;\nEND //\n\nDELIMITER ;\n\nExamples\n--------\n\nFirst a simplified example:\n\nCREATE TABLE marks(stud_id INT, grade_count INT);\n\nINSERT INTO marks VALUES (1,6), (2,4), (3,7), (4,5), (5,8);\n\nSELECT * FROM marks;\n+---------+-------------+\n| stud_id | grade_count |\n+---------+-------------+\n|       1 |           6 |\n|       2 |           4 |\n|       3 |           7 |\n|       4 |           5 |\n|       5 |           8 |\n+---------+-------------+\n\nDELIMITER //\nCREATE AGGREGATE FUNCTION IF NOT EXISTS aggregate_count(x INT) RETURNS INT\nBEGIN\n DECLARE count_students INT DEFAULT 0;\n DECLARE CONTINUE HANDLER FOR NOT FOUND\n RETURN count_students;\n   LOOP\n     FETCH GROUP NEXT ROW;\n     IF x  THEN\n      SET count_students = count_students+1;\n     END IF;\n   END LOOP;\nEND //\nDELIMITER ;\n\nA non-trivial example that cannot easily be rewritten using existing functions:\n\nDELIMITER //\nCREATE AGGREGATE FUNCTION medi_int(x INT) RETURNS DOUBLE\nBEGIN\n DECLARE CONTINUE HANDLER FOR NOT FOUND\n  BEGIN\n   DECLARE res DOUBLE;\n   DECLARE cnt INT DEFAULT (SELECT COUNT(*) FROM tt);\n   DECLARE lim INT DEFAULT (cnt-1) DIV 2;\n   IF cnt % 2 = 0 THEN\n    SET res = (SELECT AVG(a) FROM (SELECT a FROM tt ORDER BY a LIMIT\nlim,2) ttt);\n   ELSE\n    SET res = (SELECT a FROM tt ORDER BY a LIMIT lim,1);\n   END IF;\n   DROP TEMPORARY TABLE tt;\n   RETURN res;\n  END;\n CREATE TEMPORARY TABLE tt (a INT);\n LOOP\n  FETCH GROUP NEXT ROW;\n  INSERT INTO tt VALUES (x);\n END LOOP;\nEND //\nDELIMITER ;\n\nSQL/PL Example\n--------------\n\nThis uses the same marks table as created above.\n\nSET sql_mode=Oracle;\nDELIMITER //\n\nCREATE AGGREGATE FUNCTION aggregate_count(x INT) RETURN INT AS count_students\nINT DEFAULT 0;\nBEGIN\n LOOP\n   FETCH GROUP NEXT ROW;\n   IF x  THEN\n    SET count_students := count_students+1;\n   END IF;\n END LOOP;\nEXCEPTION\n WHEN NO_DATA_FOUND THEN\n   RETURN count_students;\nEND aggregate_count //\nDELIMITER ;\n\nSELECT aggregate_count(stud_id) FROM marks;\n\nURL: https://mariadb.com/kb/en/stored-aggregate-functions/','','https://mariadb.com/kb/en/stored-aggregate-functions/'),(172,'AVG',16,'Syntax\n------\n\nAVG([DISTINCT] expr)\n\nDescription\n-----------\n\nReturns the average value of expr. The DISTINCT option can be used to return\nthe average of the distinct values of expr. NULL values are ignored. It is an\naggregate function, and so can be used with the GROUP BY clause.\n\nAVG() returns NULL if there were no matching rows.\n\nAVG() can be used as a window function.\n\nExamples\n--------\n\nCREATE TABLE sales (sales_value INT);\n\nINSERT INTO sales VALUES(10),(20),(20),(40);\n\nSELECT AVG(sales_value) FROM sales;\n+------------------+\n| AVG(sales_value) |\n+------------------+\n|          22.5000 |\n+------------------+\n\nSELECT AVG(DISTINCT(sales_value)) FROM sales;\n+----------------------------+\n| AVG(DISTINCT(sales_value)) |\n+----------------------------+\n|                    23.3333 |\n+----------------------------+\n\nCommonly, AVG() is used with a GROUP BY clause:\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT name, AVG(score) FROM student GROUP BY name;\n+---------+------------+\n| name    | AVG(score) |\n+---------+------------+\n| Chun    |    74.0000 |\n| Esben   |    37.0000 |\n| Kaolin  |    72.0000 |\n| Tatiana |    85.0000 |\n+---------+------------+\n\nBe careful to avoid this common mistake, not grouping correctly and returning\nmismatched data:\n\nSELECT name,test,AVG(score) FROM student;\n+------+------+------------+\n| name | test | MIN(score) |\n+------+------+------------+\n| Chun | SQL  |         31 |\n+------+------+------------+\n\nAs a window function:\n\nCREATE TABLE student_test (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT name, test, score, AVG(score) OVER (PARTITION BY test) \n  AS average_by_test FROM student_test;\n+---------+--------+-------+-----------------+\n| name    | test   | score | average_by_test |\n+---------+--------+-------+-----------------+\n| Chun    | SQL    |    75 |         65.2500 |\n| Chun    | Tuning |    73 |         68.7500 |\n| Esben   | SQL    |    43 |         65.2500 |\n| Esben   | Tuning |    31 |         68.7500 |\n| Kaolin  | SQL    |    56 |         65.2500 |\n| Kaolin  | Tuning |    88 |         68.7500 |\n| Tatiana | SQL    |    87 |         65.2500 |\n| Tatiana | Tuning |    83 |         68.7500 |\n+---------+--------+-------+-----------------+\n\nURL: https://mariadb.com/kb/en/avg/','','https://mariadb.com/kb/en/avg/'),(173,'BIT_AND',16,'Syntax\n------\n\nBIT_AND(expr) [over_clause]\n\nDescription\n-----------\n\nReturns the bitwise AND of all bits in expr. The calculation is performed with\n64-bit (BIGINT) precision. It is an aggregate function, and so can be used\nwith the GROUP BY clause.\n\nIf no rows match, BIT_AND will return a value with all bits set to 1. NULL\nvalues have no effect on the result unless all results are NULL, which is\ntreated as no match.\n\nBIT_AND can be used as a window function with the addition of the over_clause.\n\nExamples\n--------\n\nCREATE TABLE vals (x INT);\n\nINSERT INTO vals VALUES(111),(110),(100);\n\nSELECT BIT_AND(x), BIT_OR(x), BIT_XOR(x) FROM vals;\n+------------+-----------+------------+\n| BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+------------+-----------+------------+\n|        100 |       111 |        101 |\n+------------+-----------+------------+\n\nAs an aggregate function:\n\nCREATE TABLE vals2 (category VARCHAR(1), x INT);\n\nINSERT INTO vals2 VALUES\n (\'a\',111),(\'a\',110),(\'a\',100),\n (\'b\',\'000\'),(\'b\',001),(\'b\',011);\n\nSELECT category, BIT_AND(x), BIT_OR(x), BIT_XOR(x) \n FROM vals GROUP BY category;\n+----------+------------+-----------+------------+\n| category | BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+----------+------------+-----------+------------+\n| a        |        100 |       111 |        101 |\n| b        |          0 |        11 |         10 |\n+----------+------------+-----------+------------+\n\nNo match:\n\nSELECT BIT_AND(NULL);\n+----------------------+\n| BIT_AND(NULL)        |\n+----------------------+\n| 18446744073709551615 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/bit_and/','','https://mariadb.com/kb/en/bit_and/'),(174,'BIT_OR',16,'Syntax\n------\n\nBIT_OR(expr) [over_clause]\n\nDescription\n-----------\n\nReturns the bitwise OR of all bits in expr. The calculation is performed with\n64-bit (BIGINT) precision. It is an aggregate function, and so can be used\nwith the GROUP BY clause.\n\nIf no rows match, BIT_OR will return a value with all bits set to 0. NULL\nvalues have no effect on the result unless all results are NULL, which is\ntreated as no match.\n\nBIT_OR can be used as a window function with the addition of the over_clause.\n\nExamples\n--------\n\nCREATE TABLE vals (x INT);\n\nINSERT INTO vals VALUES(111),(110),(100);\n\nSELECT BIT_AND(x), BIT_OR(x), BIT_XOR(x) FROM vals;\n+------------+-----------+------------+\n| BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+------------+-----------+------------+\n|        100 |       111 |        101 |\n+------------+-----------+------------+\n\nAs an aggregate function:\n\nCREATE TABLE vals2 (category VARCHAR(1), x INT);\n\nINSERT INTO vals2 VALUES\n (\'a\',111),(\'a\',110),(\'a\',100),\n (\'b\',\'000\'),(\'b\',001),(\'b\',011);\n\nSELECT category, BIT_AND(x), BIT_OR(x), BIT_XOR(x) \n FROM vals GROUP BY category;\n+----------+------------+-----------+------------+\n| category | BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+----------+------------+-----------+------------+\n| a        |        100 |       111 |        101 |\n| b        |          0 |        11 |         10 |\n+----------+------------+-----------+------------+\n\nNo match:\n\nSELECT BIT_OR(NULL);\n+--------------+\n| BIT_OR(NULL) |\n+--------------+\n|            0 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/bit_or/','','https://mariadb.com/kb/en/bit_or/'),(175,'BIT_XOR',16,'Syntax\n------\n\nBIT_XOR(expr) [over_clause]\n\nDescription\n-----------\n\nReturns the bitwise XOR of all bits in expr. The calculation is performed with\n64-bit (BIGINT) precision. It is an aggregate function, and so can be used\nwith the GROUP BY clause.\n\nIf no rows match, BIT_XOR will return a value with all bits set to 0. NULL\nvalues have no effect on the result unless all results are NULL, which is\ntreated as no match.\n\nBIT_XOR can be used as a window function with the addition of the over_clause.\n\nExamples\n--------\n\nCREATE TABLE vals (x INT);\n\nINSERT INTO vals VALUES(111),(110),(100);\n\nSELECT BIT_AND(x), BIT_OR(x), BIT_XOR(x) FROM vals;\n+------------+-----------+------------+\n| BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+------------+-----------+------------+\n|        100 |       111 |        101 |\n+------------+-----------+------------+\n\nAs an aggregate function:\n\nCREATE TABLE vals2 (category VARCHAR(1), x INT);\n\nINSERT INTO vals2 VALUES\n (\'a\',111),(\'a\',110),(\'a\',100),\n (\'b\',\'000\'),(\'b\',001),(\'b\',011);\n\nSELECT category, BIT_AND(x), BIT_OR(x), BIT_XOR(x) \n FROM vals GROUP BY category;\n+----------+------------+-----------+------------+\n| category | BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+----------+------------+-----------+------------+\n| a        |        100 |       111 |        101 |\n| b        |          0 |        11 |         10 |\n+----------+------------+-----------+------------+\n\nNo match:\n\nSELECT BIT_XOR(NULL);\n+---------------+\n| BIT_XOR(NULL) |\n+---------------+\n|             0 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/bit_xor/','','https://mariadb.com/kb/en/bit_xor/'),(176,'COUNT',16,'Syntax\n------\n\nCOUNT(expr)\n\nDescription\n-----------\n\nReturns a count of the number of non-NULL values of expr in the rows retrieved\nby a SELECT statement. The result is a BIGINT value. It is an aggregate\nfunction, and so can be used with the GROUP BY clause.\n\nCOUNT(*) counts the total number of rows in a table.\n\nCOUNT() returns 0 if there were no matching rows.\n\nCOUNT() can be used as a window function.\n\nExamples\n--------\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT COUNT(*) FROM student;\n+----------+\n| COUNT(*) |\n+----------+\n|        8 |\n+----------+\n\nCOUNT(DISTINCT) example:\n\nSELECT COUNT(DISTINCT (name)) FROM student;\n+------------------------+\n| COUNT(DISTINCT (name)) |\n+------------------------+\n|                      4 |\n+------------------------+\n\nAs a window function\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, COUNT(score) OVER (PARTITION BY name) \n  AS tests_written FROM student_test;\n+---------+--------+-------+---------------+\n| name    | test   | score | tests_written |\n+---------+--------+-------+---------------+\n| Chun    | SQL    |    75 |             2 |\n| Chun    | Tuning |    73 |             2 |\n| Esben   | SQL    |    43 |             2 |\n| Esben   | Tuning |    31 |             2 |\n| Kaolin  | SQL    |    56 |             2 |\n| Kaolin  | Tuning |    88 |             2 |\n| Tatiana | SQL    |    87 |             1 |\n+---------+--------+-------+---------------+\n\nURL: https://mariadb.com/kb/en/count/','','https://mariadb.com/kb/en/count/'),(316,'CONVEXHULL',25,'A synonym for ST_CONVEXHULL.\n\nURL: https://mariadb.com/kb/en/convexhull/','','https://mariadb.com/kb/en/convexhull/'),(317,'GEOMETRYCOLLECTION',25,'Syntax\n------\n\nGeometryCollection(g1,g2,...)\n\nDescription\n-----------\n\nConstructs a WKB GeometryCollection. If any argument is not a well-formed WKB\nrepresentation of a geometry, the return value is NULL.\n\nExamples\n--------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/geometrycollection/','','https://mariadb.com/kb/en/geometrycollection/'),(177,'COUNT DISTINCT',16,'Syntax\n------\n\nCOUNT(DISTINCT expr,[expr...])\n\nDescription\n-----------\n\nReturns a count of the number of different non-NULL values.\n\nCOUNT(DISTINCT) returns 0 if there were no matching rows.\n\nAlthough, from MariaDB 10.2.0, COUNT can be used as a window function, COUNT\nDISTINCT cannot be.\n\nExamples\n--------\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT COUNT(*) FROM student;\n+----------+\n| COUNT(*) |\n+----------+\n|        8 |\n+----------+\n\nSELECT COUNT(DISTINCT (name)) FROM student;\n+------------------------+\n| COUNT(DISTINCT (name)) |\n+------------------------+\n|                      4 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/count-distinct/','','https://mariadb.com/kb/en/count-distinct/'),(178,'GROUP_CONCAT',16,'Syntax\n------\n\nGROUP_CONCAT(expr)\n\nDescription\n-----------\n\nThis function returns a string result with the concatenated non-NULL values\nfrom a group. It returns NULL if there are no non-NULL values.\n\nThe maximum returned length in bytes is determined by the group_concat_max_len\nserver system variable, which defaults to 1M (>= MariaDB 10.2.4) or 1K (<=\nMariaDB 10.2.3).\n\nIf group_concat_max_len <= 512, the return type is VARBINARY or VARCHAR;\notherwise, the return type is BLOB or TEXT. The choice between binary or\nnon-binary types depends from the input.\n\nThe full syntax is as follows:\n\nGROUP_CONCAT([DISTINCT] expr [,expr ...]\n      [ORDER BY {unsigned_integer | col_name | expr}\n        [ASC | DESC] [,col_name ...]]\n      [SEPARATOR str_val]\n      [LIMIT {[offset,] row_count | row_count OFFSET offset}])\n\nDISTINCT eliminates duplicate values from the output string.\n\nORDER BY determines the order of returned values.\n\nSEPARATOR specifies a separator between the values. The default separator is a\ncomma (,). It is possible to avoid using a separator by specifying an empty\nstring.\n\nLIMIT\n-----\n\nMariaDB starting with 10.3.3\n----------------------------\nUntil MariaDB 10.3.2, it was not possible to use the LIMIT clause with\nGROUP_CONCAT. This restriction was lifted in MariaDB 10.3.3.\n\nExamples\n--------\n\nSELECT student_name,\n   GROUP_CONCAT(test_score)\n   FROM student\n   GROUP BY student_name;\n\nGet a readable list of MariaDB users from the mysql.user table:\n\nSELECT GROUP_CONCAT(DISTINCT User ORDER BY User SEPARATOR \'\\n\')\n FROM mysql.user;\n\nIn the former example, DISTINCT is used because the same user may occur more\nthan once. The new line (\\n) used as a SEPARATOR makes the results easier to\nread.\n\nGet a readable list of hosts from which each user can connect:\n\nSELECT User, GROUP_CONCAT(Host ORDER BY Host SEPARATOR \', \') \n FROM mysql.user GROUP BY User ORDER BY User;\n\nThe former example shows the difference between the GROUP_CONCAT\'s ORDER BY\n(which sorts the concatenated hosts), and the SELECT\'s ORDER BY (which sorts\nthe rows).\n\nFrom MariaDB 10.3.3, LIMIT can be used with GROUP_CONCAT, so, for example,\ngiven the following table:\n\nCREATE TABLE d (dd DATE, cc INT);\n\nINSERT INTO d VALUES (\'2017-01-01\',1);\nINSERT INTO d VALUES (\'2017-01-02\',2);\nINSERT INTO d VALUES (\'2017-01-04\',3);\n\nthe following query:\n\nSELECT SUBSTRING_INDEX(GROUP_CONCAT(CONCAT_WS(\":\",dd,cc) ORDER BY cc\nDESC),\",\",1) FROM d;\n+----------------------------------------------------------------------------+\n| SUBSTRING_INDEX(GROUP_CONCAT(CONCAT_WS(\":\",dd,cc) ORDER BY cc DESC),\",\",1) |\n+----------------------------------------------------------------------------+\n| 2017-01-04:3                                                               |\n+----------------------------------------------------------------------------+\n\ncan be more simply rewritten as:\n\nSELECT GROUP_CONCAT(CONCAT_WS(\":\",dd,cc) ORDER BY cc DESC LIMIT 1) FROM d;\n+-------------------------------------------------------------+\n| GROUP_CONCAT(CONCAT_WS(\":\",dd,cc) ORDER BY cc DESC LIMIT 1) |\n+-------------------------------------------------------------+\n| 2017-01-04:3                                                |\n+-------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/group_concat/','','https://mariadb.com/kb/en/group_concat/'),(179,'MAX',16,'Syntax\n------\n\nMAX([DISTINCT] expr)\n\nDescription\n-----------\n\nReturns the largest, or maximum, value of expr. MAX() can also take a string\nargument in which case it returns the maximum string value. The DISTINCT\nkeyword can be used to find the maximum of the distinct values of expr,\nhowever, this produces the same result as omitting DISTINCT.\n\nNote that SET and ENUM fields are currently compared by their string value\nrather than their relative position in the set, so MAX() may produce a\ndifferent highest result than ORDER BY DESC.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nMAX() can be used as a window function.\n\nMAX() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT name, MAX(score) FROM student GROUP BY name;\n+---------+------------+\n| name    | MAX(score) |\n+---------+------------+\n| Chun    |         75 |\n| Esben   |         43 |\n| Kaolin  |         88 |\n| Tatiana |         87 |\n+---------+------------+\n\nMAX string:\n\nSELECT MAX(name) FROM student;\n+-----------+\n| MAX(name) |\n+-----------+\n| Tatiana   |\n+-----------+\n\nBe careful to avoid this common mistake, not grouping correctly and returning\nmismatched data:\n\nSELECT name,test,MAX(SCORE) FROM student;\n+------+------+------------+\n| name | test | MAX(SCORE) |\n+------+------+------------+\n| Chun | SQL  |         88 |\n+------+------+------------+\n\nDifference between ORDER BY DESC and MAX():\n\nCREATE TABLE student2(name CHAR(10),grade ENUM(\'b\',\'c\',\'a\'));\n\nINSERT INTO student2 VALUES(\'Chun\',\'b\'),(\'Esben\',\'c\'),(\'Kaolin\',\'a\');\n\nSELECT MAX(grade) FROM student2;\n+------------+\n| MAX(grade) |\n+------------+\n| c          |\n+------------+\n\nSELECT grade FROM student2 ORDER BY grade DESC LIMIT 1;\n+-------+\n| grade |\n+-------+\n| a     |\n+-------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, MAX(score) \n OVER (PARTITION BY name) AS highest_score FROM student_test;\n+---------+--------+-------+---------------+\n| name    | test   | score | highest_score |\n+---------+--------+-------+---------------+\n| Chun    | SQL    |    75 |            75 |\n| Chun    | Tuning |    73 |            75 |\n| Esben   | SQL    |    43 |            43 |\n| Esben   | Tuning |    31 |            43 |\n| Kaolin  | SQL    |    56 |            88 |\n| Kaolin  | Tuning |    88 |            88 |\n| Tatiana | SQL    |    87 |            87 |\n+---------+--------+-------+---------------+\n\nURL: https://mariadb.com/kb/en/max/','','https://mariadb.com/kb/en/max/'),(180,'MIN',16,'Syntax\n------\n\nMIN([DISTINCT] expr)\n\nDescription\n-----------\n\nReturns the minimum value of expr. MIN() may take a string argument, in which\ncase it returns the minimum string value. The DISTINCT keyword can be used to\nfind the minimum of the distinct values of expr, however, this produces the\nsame result as omitting DISTINCT.\n\nNote that SET and ENUM fields are currently compared by their string value\nrather than their relative position in the set, so MIN() may produce a\ndifferent lowest result than ORDER BY ASC.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nMIN() can be used as a window function.\n\nMIN() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT name, MIN(score) FROM student GROUP BY name;\n+---------+------------+\n| name    | MIN(score) |\n+---------+------------+\n| Chun    |         73 |\n| Esben   |         31 |\n| Kaolin  |         56 |\n| Tatiana |         83 |\n+---------+------------+\n\nMIN() with a string:\n\nSELECT MIN(name) FROM student;\n+-----------+\n| MIN(name) |\n+-----------+\n| Chun      |\n+-----------+\n\nBe careful to avoid this common mistake, not grouping correctly and returning\nmismatched data:\n\nSELECT name,test,MIN(score) FROM student;\n+------+------+------------+\n| name | test | MIN(score) |\n+------+------+------------+\n| Chun | SQL  |         31 |\n+------+------+------------+\n\nDifference between ORDER BY ASC and MIN():\n\nCREATE TABLE student2(name CHAR(10),grade ENUM(\'b\',\'c\',\'a\'));\n\nINSERT INTO student2 VALUES(\'Chun\',\'b\'),(\'Esben\',\'c\'),(\'Kaolin\',\'a\');\n\nSELECT MIN(grade) FROM student2;\n+------------+\n| MIN(grade) |\n+------------+\n| a          |\n+------------+\n\nSELECT grade FROM student2 ORDER BY grade ASC LIMIT 1;\n+-------+\n| grade |\n+-------+\n| b     |\n+-------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, MIN(score) \n OVER (PARTITION BY name) AS lowest_score FROM student_test;\n+---------+--------+-------+--------------+\n| name    | test   | score | lowest_score |\n+---------+--------+-------+--------------+\n| Chun    | SQL    |    75 |           73 |\n| Chun    | Tuning |    73 |           73 |\n| Esben   | SQL    |    43 |           31 |\n| Esben   | Tuning |    31 |           31 |\n| Kaolin  | SQL    |    56 |           56 |\n| Kaolin  | Tuning |    88 |           56 |\n| Tatiana | SQL    |    87 |           87 |\n+---------+--------+-------+--------------+\n\nURL: https://mariadb.com/kb/en/min/','','https://mariadb.com/kb/en/min/'),(181,'STD',16,'Syntax\n------\n\nSTD(expr)\n\nDescription\n-----------\n\nReturns the population standard deviation of expr. This is an extension to\nstandard SQL. The standard SQL function STDDEV_POP() can be used instead.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nSTD() can be used as a window function.\n\nThis function returns NULL if there were no matching rows.\n\nExamples\n--------\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, STDDEV_POP(score) \n OVER (PARTITION BY test) AS stddev_results FROM student_test;\n+---------+--------+-------+----------------+\n| name    | test   | score | stddev_results |\n+---------+--------+-------+----------------+\n| Chun    | SQL    |    75 |        16.9466 |\n| Chun    | Tuning |    73 |        24.1247 |\n| Esben   | SQL    |    43 |        16.9466 |\n| Esben   | Tuning |    31 |        24.1247 |\n| Kaolin  | SQL    |    56 |        16.9466 |\n| Kaolin  | Tuning |    88 |        24.1247 |\n| Tatiana | SQL    |    87 |        16.9466 |\n+---------+--------+-------+----------------+\n\nURL: https://mariadb.com/kb/en/std/','','https://mariadb.com/kb/en/std/'),(319,'MULTILINESTRING',25,'Syntax\n------\n\nMultiLineString(ls1,ls2,...)\n\nDescription\n-----------\n\nConstructs a WKB MultiLineString value using WKB LineString arguments. If any\nargument is not a WKB LineString, the return value is NULL.\n\nExample\n-------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nINSERT INTO gis_multi_line VALUES\n (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16 23,16\n48))\')),\n (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n (MLineFromWKB(AsWKB(MultiLineString(LineString(Point(1, 2), \n  Point(3, 5)), LineString(Point(2, 5),Point(5, 8),Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/multilinestring/','','https://mariadb.com/kb/en/multilinestring/'),(320,'MULTIPOINT',25,'Syntax\n------\n\nMultiPoint(pt1,pt2,...)\n\nDescription\n-----------\n\nConstructs a WKB MultiPoint value using WKB Point arguments. If any argument\nis not a WKB Point, the return value is NULL.\n\nExamples\n--------\n\nSET @g = ST_GEOMFROMTEXT(\'MultiPoint( 1 1, 2 2, 5 3, 7 2, 9 3, 8 4, 6 6, 6 9,\n4 9, 1 5 )\');\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/multipoint/','','https://mariadb.com/kb/en/multipoint/'),(322,'POINT',25,'Syntax\n------\n\nPoint(x,y)\n\nDescription\n-----------\n\nConstructs a WKB Point using the given coordinates.\n\nExamples\n--------\n\nSET @g = ST_GEOMFROMTEXT(\'Point(1 1)\');\n\nCREATE TABLE gis_point  (g POINT);\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/point/','','https://mariadb.com/kb/en/point/'),(323,'PointOnSurface',25,'A synonym for ST_PointOnSurface.\n\nURL: https://mariadb.com/kb/en/pointonsurface/','','https://mariadb.com/kb/en/pointonsurface/'),(327,'ST_INTERSECTION',25,'Syntax\n------\n\nST_INTERSECTION(g1,g2)\n\nDescription\n-----------\n\nReturns a geometry that is the intersection, or shared portion, of geometry g1\nand geometry g2.\n\nExamples\n--------\n\nSET @g1 = ST_GEOMFROMTEXT(\'POINT(2 1)\');\n\nSET @g2 = ST_GEOMFROMTEXT(\'LINESTRING(2 1, 0 2)\');\n\nSELECT ASTEXT(ST_INTERSECTION(@g1,@g2));\n+----------------------------------+\n| ASTEXT(ST_INTERSECTION(@g1,@g2)) |\n+----------------------------------+\n| POINT(2 1)                       |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/st_intersection/','','https://mariadb.com/kb/en/st_intersection/'),(182,'STDDEV',16,'Syntax\n------\n\nSTDDEV(expr)\n\nDescription\n-----------\n\nReturns the population standard deviation of expr. This function is provided\nfor compatibility with Oracle. The standard SQL function STDDEV_POP() can be\nused instead.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nSTDDEV() can be used as a window function.\n\nThis function returns NULL if there were no matching rows.\n\nExamples\n--------\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, STDDEV_POP(score) \n OVER (PARTITION BY test) AS stddev_results FROM student_test;\n+---------+--------+-------+----------------+\n| name    | test   | score | stddev_results |\n+---------+--------+-------+----------------+\n| Chun    | SQL    |    75 |        16.9466 |\n| Chun    | Tuning |    73 |        24.1247 |\n| Esben   | SQL    |    43 |        16.9466 |\n| Esben   | Tuning |    31 |        24.1247 |\n| Kaolin  | SQL    |    56 |        16.9466 |\n| Kaolin  | Tuning |    88 |        24.1247 |\n| Tatiana | SQL    |    87 |        16.9466 |\n+---------+--------+-------+----------------+\n\nURL: https://mariadb.com/kb/en/stddev/','','https://mariadb.com/kb/en/stddev/'),(183,'STDDEV_POP',16,'Syntax\n------\n\nSTDDEV_POP(expr)\n\nDescription\n-----------\n\nReturns the population standard deviation of expr (the square root of\nVAR_POP()). You can also use STD() or STDDEV(), which are equivalent but not\nstandard SQL.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nSTDDEV_POP() can be used as a window function.\n\nSTDDEV_POP() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, STDDEV_POP(score) \n OVER (PARTITION BY test) AS stddev_results FROM student_test;\n+---------+--------+-------+----------------+\n| name    | test   | score | stddev_results |\n+---------+--------+-------+----------------+\n| Chun    | SQL    |    75 |        16.9466 |\n| Chun    | Tuning |    73 |        24.1247 |\n| Esben   | SQL    |    43 |        16.9466 |\n| Esben   | Tuning |    31 |        24.1247 |\n| Kaolin  | SQL    |    56 |        16.9466 |\n| Kaolin  | Tuning |    88 |        24.1247 |\n| Tatiana | SQL    |    87 |        16.9466 |\n+---------+--------+-------+----------------+\n\nURL: https://mariadb.com/kb/en/stddev_pop/','','https://mariadb.com/kb/en/stddev_pop/'),(185,'SUM',16,'Syntax\n------\n\nSUM([DISTINCT] expr)\n\nDescription\n-----------\n\nReturns the sum of expr. If the return set has no rows, SUM() returns NULL.\nThe DISTINCT keyword can be used to sum only the distinct values of expr.\n\nSUM() can be used as a window function, although not with the DISTINCT\nspecifier.\n\nExamples\n--------\n\nCREATE TABLE sales (sales_value INT);\nINSERT INTO sales VALUES(10),(20),(20),(40);\n\nSELECT SUM(sales_value) FROM sales;\n+------------------+\n| SUM(sales_value) |\n+------------------+\n|               90 |\n+------------------+\n\nSELECT SUM(DISTINCT(sales_value)) FROM sales;\n+----------------------------+\n| SUM(DISTINCT(sales_value)) |\n+----------------------------+\n|                         70 |\n+----------------------------+\n\nCommonly, SUM is used with a GROUP BY clause:\n\nCREATE TABLE sales (name CHAR(10), month CHAR(10), units INT);\n\nINSERT INTO sales VALUES \n (\'Chun\', \'Jan\', 75), (\'Chun\', \'Feb\', 73),\n (\'Esben\', \'Jan\', 43), (\'Esben\', \'Feb\', 31),\n (\'Kaolin\', \'Jan\', 56), (\'Kaolin\', \'Feb\', 88),\n (\'Tatiana\', \'Jan\', 87), (\'Tatiana\', \'Feb\', 83);\n\nSELECT name, SUM(units) FROM sales GROUP BY name;\n+---------+------------+\n| name    | SUM(units) |\n+---------+------------+\n| Chun    |        148 |\n| Esben   |         74 |\n| Kaolin  |        144 |\n| Tatiana |        170 |\n+---------+------------+\n\nThe GROUP BY clause is required when using an aggregate function along with\nregular column data, otherwise the result will be a mismatch, as in the\nfollowing common type of mistake:\n\nSELECT name,SUM(units) FROM sales\n;+------+------------+\n| name | SUM(units) |\n+------+------------+\n| Chun |        536 |\n+------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, SUM(score) OVER (PARTITION BY name) AS total_score\nFROM student_test;\n+---------+--------+-------+-------------+\n| name    | test   | score | total_score |\n+---------+--------+-------+-------------+\n| Chun    | SQL    |    75 |         148 |\n| Chun    | Tuning |    73 |         148 |\n| Esben   | SQL    |    43 |          74 |\n| Esben   | Tuning |    31 |          74 |\n| Kaolin  | SQL    |    56 |         144 |\n| Kaolin  | Tuning |    88 |         144 |\n| Tatiana | SQL    |    87 |          87 |\n+---------+--------+-------+-------------+\n\nURL: https://mariadb.com/kb/en/sum/','','https://mariadb.com/kb/en/sum/'),(328,'ST_POINTONSURFACE',25,'MariaDB starting with 10.1.2\n----------------------------\nST_POINTONSURFACE() was introduced in MariaDB 10.1.2\n\nSyntax\n------\n\nST_PointOnSurface(g)\nPointOnSurface(g)\n\nDescription\n-----------\n\nGiven a geometry, returns a POINT guaranteed to intersect a surface. However,\nsee MDEV-7514.\n\nST_PointOnSurface() and PointOnSurface() are synonyms.\n\nURL: https://mariadb.com/kb/en/st_pointonsurface/','','https://mariadb.com/kb/en/st_pointonsurface/'),(339,'FLUSH',26,'Syntax\n------\n\nFLUSH [NO_WRITE_TO_BINLOG | LOCAL]\n  flush_option [, flush_option] ...\n\nor when flushing tables:\n\nFLUSH [NO_WRITE_TO_BINLOG | LOCAL] TABLES [table_list]  [table_flush_option]\n\nwhere table_list is a list of tables separated by , (comma).\n\nDescription\n-----------\n\nThe FLUSH statement clears or reloads various internal caches used by MariaDB.\nTo execute FLUSH, you must have the RELOAD privilege. See GRANT.\n\nThe RESET statement is similar to FLUSH. See RESET.\n\nYou cannot issue a FLUSH statement from within a stored function or a trigger.\nDoing so within a stored procedure is permitted, as long as it is not called\nby a stored function or trigger. See Stored Routine Limitations, Stored\nFunction Limitations and Trigger Limitations.\n\nIf a listed table is a view, an error like the following will be produced:\n\nERROR 1347 (HY000): \'test.v\' is not BASE TABLE\n\nBy default, FLUSH statements are written to the binary log and will be\nreplicated. The NO_WRITE_TO_BINLOG keyword (LOCAL is an alias) will ensure the\nstatement is not written to the binary log.\n\nThe different flush options are:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| CHANGED_PAGE_BITMAPS      | XtraDB only. Internal command used for backup  |\n|                           | purposes. See the Information Schema           |\n|                           | CHANGED_PAGE_BITMAPS Table.                    |\n+---------------------------+------------------------------------------------+\n| CLIENT_STATISTICS         | Reset client statistics (see SHOW              |\n|                           | CLIENT_STATISTICS).                            |\n+---------------------------+------------------------------------------------+\n| DES_KEY_FILE              | Reloads the DES key file (Specified with the   |\n|                           | --des-key-file startup option).                |\n+---------------------------+------------------------------------------------+\n| HOSTS                     | Flush the hostname cache (used for converting  |\n|                           | ip to host names and for unblocking blocked    |\n|                           | hosts. See max_connect_errors and              |\n|                           | performance_schema.host_cache                  |\n+---------------------------+------------------------------------------------+\n| INDEX_STATISTICS          | Reset index statistics (see SHOW               |\n|                           | INDEX_STATISTICS).                             |\n+---------------------------+------------------------------------------------+\n| [ERROR | ENGINE |         | Close and reopen the specified log type, or    |\n| GENERAL | SLOW | BINARY   | all log types if none are specified. FLUSH     |\n| | RELAY] LOGS             | RELAY LOGS [connection-name] can be used to    |\n|                           | flush the relay logs for a specific            |\n|                           | connection. Only one connection can be         |\n|                           | specified per FLUSH command. See Multi-source  |\n|                           | replication. FLUSH ENGINE LOGS will delete     |\n|                           | all unneeded Aria redo logs. Since MariaDB     |\n|                           | 10.1.30 and MariaDB 10.2.11, FLUSH BINARY      |\n|                           | LOGS DELETE_DOMAIN_ID=(list-of-domains) can    |\n|                           | be used to discard obsolete GTID domains from  |\n|                           | the server\'s binary log state. In order for    |\n|                           | this to be successful, no event group from     |\n|                           | the listed GTID domains can be present in      |\n|                           | existing binary log files. If some still       |\n|                           | exist, then they must be purged prior to       |\n|                           | executing this command. If the command         |\n|                           | completes successfully, then it also rotates   |\n|                           | the binary log.                                |\n+---------------------------+------------------------------------------------+\n| MASTER                    | Deprecated option, use RESET MASTER instead.   |\n+---------------------------+------------------------------------------------+\n| PRIVILEGES                | Reload all privileges from the privilege       |\n|                           | tables in the mysql database. If the server    |\n|                           | is started with --skip-grant-table option,     |\n|                           | this will activate the privilege tables again. |\n+---------------------------+------------------------------------------------+\n| QUERY CACHE               | Defragment the query cache to better utilize   |\n|                           | its memory. If you want to reset the query     |\n|                           | cache, you can do it with RESET QUERY CACHE.   |\n+---------------------------+------------------------------------------------+\n| QUERY_RESPONSE_TIME       | See the QUERY_RESPONSE_TIME plugin.            |\n+---------------------------+------------------------------------------------+\n| SLAVE                     | Deprecated option, use RESET REPLICA or RESET  |\n|                           | SLAVE instead.                                 |\n+---------------------------+------------------------------------------------+\n| SSL                       | Used to dynamically reinitialize the server\'s  |\n|                           | TLS context by reloading the files defined by  |\n|                           | several TLS system variables. See FLUSH SSL    |\n|                           | for more information. This command was first   |\n|                           | added in MariaDB 10.4.1.                       |\n+---------------------------+------------------------------------------------+\n| STATUS                    | Resets all server status variables that can    |\n|                           | be reset to 0. Not all global status           |\n|                           | variables support this, so not all global      |\n|                           | values are reset. See FLUSH STATUS for more    |\n|                           | information.                                   |\n+---------------------------+------------------------------------------------+\n| TABLE                     | Close tables given as options or all open      |\n|                           | tables if no table list was used. From         |\n|                           | MariaDB 10.4.1, using without any table list   |\n|                           | will only close tables not in use, and tables  |\n|                           | not locked by the FLUSH TABLES connection. If  |\n|                           | there are no locked tables, FLUSH TABLES will  |\n|                           | be instant and will not cause any waits, as    |\n|                           | it no longer waits for tables in use. When a   |\n|                           | table list is provided, from MariaDB 10.4.1,   |\n|                           | the server will wait for the end of any        |\n|                           | transactions that are using the tables.        |\n|                           | Previously, FLUSH TABLES only waited for the   |\n|                           | statements to complete.                        |\n+---------------------------+------------------------------------------------+\n| TABLES                    | Same as FLUSH TABLE.                           |\n+---------------------------+------------------------------------------------+\n| TABLES ... FOR EXPORT     | For InnoDB tables, flushes table changes to    |\n|                           | disk to permit binary table copies while the   |\n|                           | server is running. See FLUSH TABLES ... FOR    |\n|                           | EXPORT for more.                               |\n+---------------------------+------------------------------------------------+\n| TABLES WITH READ LOCK     | Closes all open tables. New tables are only    |\n|                           | allowed to be opened with read locks until an  |\n|                           | UNLOCK TABLES is given.                        |\n+---------------------------+------------------------------------------------+\n| TABLES WITH READ LOCK     | As TABLES WITH READ LOCK but also disable all  |\n| AND DISABLE CHECKPOINT    | checkpoint writes by transactional table       |\n|                           | engines. This is useful when doing a disk      |\n|                           | snapshot of all tables.                        |\n+---------------------------+------------------------------------------------+\n| TABLE_STATISTICS          | Reset table statistics (see SHOW               |\n|                           | TABLE_STATISTICS).                             |\n+---------------------------+------------------------------------------------+\n| USER_RESOURCES            | Resets all per hour user resources. This       |\n|                           | enables clients that have exhausted their      |\n|                           | resources to connect again.                    |\n+---------------------------+------------------------------------------------+\n| USER_STATISTICS           | Reset user statistics (see SHOW                |\n|                           | USER_STATISTICS).                              |\n+---------------------------+------------------------------------------------+\n| USER_VARIABLES            | Reset user variables (see User-defined         |\n|                           | variables).                                    |\n+---------------------------+------------------------------------------------+\n\nYou can also use the mysqladmin client to flush things. Use mysqladmin --help\nto examine what flush commands it s